/*
 * Copyright (c) 2023 Nordic Semiconductor ASA
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DRIVERS_SENSOR_NPM13XX_CHARGER_H_
#define ZEPHYR_INCLUDE_DRIVERS_SENSOR_NPM13XX_CHARGER_H_

#include <zephyr/drivers/sensor.h>

/* NPM13XX charger specific channels */
enum sensor_channel_npm13xx_charger {
	SENSOR_CHAN_NPM13XX_CHARGER_STATUS = SENSOR_CHAN_PRIV_START,
	SENSOR_CHAN_NPM13XX_CHARGER_ERROR,
	SENSOR_CHAN_NPM13XX_CHARGER_VBUS_STATUS,
};

/* NPM13XX charger specific attributes */
enum sensor_attribute_npm13xx_charger {
	SENSOR_ATTR_NPM13XX_CHARGER_VBUS_PRESENT = SENSOR_ATTR_PRIV_START,
	SENSOR_ATTR_NPM13XX_CHARGER_VBUS_CUR_LIMIT,
	SENSOR_ATTR_NPM13XX_CHARGER_VBUS_OVERVLT_PROT,
	SENSOR_ATTR_NPM13XX_CHARGER_VBUS_UNDERVLT,
	SENSOR_ATTR_NPM13XX_CHARGER_VBUS_SUSPENDED,
	SENSOR_ATTR_NPM13XX_CHARGER_VBUS_BUSOUT,
};

#endif
