/*
 * Copyright (c) 2024 Nuvoton Technology Corporation.
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_NPCM_CLOCK_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_NPCM_CLOCK_H_

/* clock bus references */
#define NPCM_CLOCK_GROUP_OFFSET(N) ((N) << 3)

#define NPCM_CLOCK_PWM_I   (NPCM_CLOCK_GROUP_OFFSET(0) + 0)
#define NPCM_CLOCK_PWM_J   (NPCM_CLOCK_GROUP_OFFSET(0) + 1)
#define NPCM_CLOCK_I3CI    (NPCM_CLOCK_GROUP_OFFSET(0) + 2)
#define NPCM_CLOCK_UART3   (NPCM_CLOCK_GROUP_OFFSET(0) + 5)
#define NPCM_CLOCK_UART2   (NPCM_CLOCK_GROUP_OFFSET(0) + 6)
#define NPCM_CLOCK_SPIM    (NPCM_CLOCK_GROUP_OFFSET(1) + 0)
#define NPCM_CLOCK_FIU     (NPCM_CLOCK_GROUP_OFFSET(1) + 2)
#define NPCM_CLOCK_USB20   (NPCM_CLOCK_GROUP_OFFSET(1) + 3)
#define NPCM_CLOCK_UART    (NPCM_CLOCK_GROUP_OFFSET(1) + 4)
#define NPCM_CLOCK_MFT1    (NPCM_CLOCK_GROUP_OFFSET(1) + 5)
#define NPCM_CLOCK_MFT2    (NPCM_CLOCK_GROUP_OFFSET(1) + 6)
#define NPCM_CLOCK_MFT3    (NPCM_CLOCK_GROUP_OFFSET(1) + 7)
#define NPCM_CLOCK_PWM_A   (NPCM_CLOCK_GROUP_OFFSET(2) + 0)
#define NPCM_CLOCK_PWM_B   (NPCM_CLOCK_GROUP_OFFSET(2) + 1)
#define NPCM_CLOCK_PWM_C   (NPCM_CLOCK_GROUP_OFFSET(2) + 2)
#define NPCM_CLOCK_PWM_D   (NPCM_CLOCK_GROUP_OFFSET(2) + 3)
#define NPCM_CLOCK_PWM_E   (NPCM_CLOCK_GROUP_OFFSET(2) + 4)
#define NPCM_CLOCK_PWM_F   (NPCM_CLOCK_GROUP_OFFSET(2) + 5)
#define NPCM_CLOCK_PWM_G   (NPCM_CLOCK_GROUP_OFFSET(2) + 6)
#define NPCM_CLOCK_PWM_H   (NPCM_CLOCK_GROUP_OFFSET(2) + 7)
#define NPCM_CLOCK_SMB1    (NPCM_CLOCK_GROUP_OFFSET(3) + 0)
#define NPCM_CLOCK_SMB2    (NPCM_CLOCK_GROUP_OFFSET(3) + 1)
#define NPCM_CLOCK_SMB3    (NPCM_CLOCK_GROUP_OFFSET(3) + 2)
#define NPCM_CLOCK_SMB4    (NPCM_CLOCK_GROUP_OFFSET(3) + 3)
#define NPCM_CLOCK_SMB5    (NPCM_CLOCK_GROUP_OFFSET(3) + 4)
#define NPCM_CLOCK_SMB6    (NPCM_CLOCK_GROUP_OFFSET(3) + 5)
#define NPCM_CLOCK_GDMA    (NPCM_CLOCK_GROUP_OFFSET(3) + 7)
#define NPCM_CLOCK_ITIM1   (NPCM_CLOCK_GROUP_OFFSET(4) + 0)
#define NPCM_CLOCK_ITIM2   (NPCM_CLOCK_GROUP_OFFSET(4) + 1)
#define NPCM_CLOCK_ITIM3   (NPCM_CLOCK_GROUP_OFFSET(4) + 2)
#define NPCM_CLOCK_SMB_DMA (NPCM_CLOCK_GROUP_OFFSET(4) + 3)
#define NPCM_CLOCK_ADC     (NPCM_CLOCK_GROUP_OFFSET(4) + 4)
#define NPCM_CLOCK_PECI    (NPCM_CLOCK_GROUP_OFFSET(4) + 5)
#define NPCM_CLOCK_SPIP1   (NPCM_CLOCK_GROUP_OFFSET(4) + 7)
#define NPCM_CLOCK_UART4   (NPCM_CLOCK_GROUP_OFFSET(5) + 0)
#define NPCM_CLOCK_C2HACC  (NPCM_CLOCK_GROUP_OFFSET(5) + 3)
#define NPCM_CLOCK_SHM_REG (NPCM_CLOCK_GROUP_OFFSET(5) + 4)
#define NPCM_CLOCK_SHM     (NPCM_CLOCK_GROUP_OFFSET(5) + 5)
#define NPCM_CLOCK_DP80    (NPCM_CLOCK_GROUP_OFFSET(5) + 6)
#define NPCM_CLOCK_MSWC    (NPCM_CLOCK_GROUP_OFFSET(5) + 7)
#define NPCM_CLOCK_ITIM4   (NPCM_CLOCK_GROUP_OFFSET(6) + 0)
#define NPCM_CLOCK_ITIM5   (NPCM_CLOCK_GROUP_OFFSET(6) + 1)
#define NPCM_CLOCK_ITIM6   (NPCM_CLOCK_GROUP_OFFSET(6) + 2)
#define NPCM_CLOCK_RNG     (NPCM_CLOCK_GROUP_OFFSET(6) + 3)
#define NPCM_CLOCK_SHA     (NPCM_CLOCK_GROUP_OFFSET(6) + 5)
#define NPCM_CLOCK_ESPI    (NPCM_CLOCK_GROUP_OFFSET(6) + 7)
#define NPCM_CLOCK_SMB7    (NPCM_CLOCK_GROUP_OFFSET(7) + 0)
#define NPCM_CLOCK_SMB8    (NPCM_CLOCK_GROUP_OFFSET(7) + 1)
#define NPCM_CLOCK_SMB9    (NPCM_CLOCK_GROUP_OFFSET(7) + 2)
#define NPCM_CLOCK_SMB10   (NPCM_CLOCK_GROUP_OFFSET(7) + 3)
#define NPCM_CLOCK_SMB11   (NPCM_CLOCK_GROUP_OFFSET(7) + 4)
#define NPCM_CLOCK_SMB12   (NPCM_CLOCK_GROUP_OFFSET(7) + 5)
#define NPCM_CLOCK_SIOX2   (NPCM_CLOCK_GROUP_OFFSET(7) + 6)
#define NPCM_CLOCK_SIOX1   (NPCM_CLOCK_GROUP_OFFSET(7) + 7)
#define NPCM_CLOCK_I3CI2   (NPCM_CLOCK_GROUP_OFFSET(8) + 0)
#define NPCM_CLOCK_I3CI3   (NPCM_CLOCK_GROUP_OFFSET(8) + 1)
#define NPCM_CLOCK_I3CI4   (NPCM_CLOCK_GROUP_OFFSET(8) + 2)
#define NPCM_CLOCK_I3CI5   (NPCM_CLOCK_GROUP_OFFSET(8) + 3)
#define NPCM_CLOCK_I3CI6   (NPCM_CLOCK_GROUP_OFFSET(8) + 4)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_NPCM_CLOCK_H_ */
