/*
 * Copyright (c) 2023 Nuvoton Technology Corporation.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_NUMAKER_M46X_CLOCK_H
#define ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_NUMAKER_M46X_CLOCK_H

/* Beginning of M460 BSP clk_reg.h copy */

#define NUMAKER_CLK_AHBCLK0_PDMA0CKEN_Pos  (1)
#define NUMAKER_CLK_AHBCLK0_ISPCKEN_Pos	   (2)
#define NUMAKER_CLK_AHBCLK0_EBICKEN_Pos	   (3)
#define NUMAKER_CLK_AHBCLK0_STCKEN_Pos	   (4)
#define NUMAKER_CLK_AHBCLK0_EMAC0CKEN_Pos  (5)
#define NUMAKER_CLK_AHBCLK0_SDH0CKEN_Pos   (6)
#define NUMAKER_CLK_AHBCLK0_CRCCKEN_Pos	   (7)
#define NUMAKER_CLK_AHBCLK0_CCAPCKEN_Pos   (8)
#define NUMAKER_CLK_AHBCLK0_SENCKEN_Pos	   (9)
#define NUMAKER_CLK_AHBCLK0_HSUSBDCKEN_Pos (10)
#define NUMAKER_CLK_AHBCLK0_HBICKEN_Pos	   (11)
#define NUMAKER_CLK_AHBCLK0_CRPTCKEN_Pos   (12)
#define NUMAKER_CLK_AHBCLK0_KSCKEN_Pos	   (13)
#define NUMAKER_CLK_AHBCLK0_SPIMCKEN_Pos   (14)
#define NUMAKER_CLK_AHBCLK0_FMCIDLE_Pos	   (15)
#define NUMAKER_CLK_AHBCLK0_USBHCKEN_Pos   (16)
#define NUMAKER_CLK_AHBCLK0_SDH1CKEN_Pos   (17)
#define NUMAKER_CLK_AHBCLK0_PDMA1CKEN_Pos  (18)
#define NUMAKER_CLK_AHBCLK0_TRACECKEN_Pos  (19)
#define NUMAKER_CLK_AHBCLK0_GPACKEN_Pos	   (24)
#define NUMAKER_CLK_AHBCLK0_GPBCKEN_Pos	   (25)
#define NUMAKER_CLK_AHBCLK0_GPCCKEN_Pos	   (26)
#define NUMAKER_CLK_AHBCLK0_GPDCKEN_Pos	   (27)
#define NUMAKER_CLK_AHBCLK0_GPECKEN_Pos	   (28)
#define NUMAKER_CLK_AHBCLK0_GPFCKEN_Pos	   (29)
#define NUMAKER_CLK_AHBCLK0_GPGCKEN_Pos	   (30)
#define NUMAKER_CLK_AHBCLK0_GPHCKEN_Pos	   (31)

#define NUMAKER_CLK_APBCLK0_WDTCKEN_Pos	   (0)
#define NUMAKER_CLK_APBCLK0_RTCCKEN_Pos	   (1)
#define NUMAKER_CLK_APBCLK0_TMR0CKEN_Pos   (2)
#define NUMAKER_CLK_APBCLK0_TMR1CKEN_Pos   (3)
#define NUMAKER_CLK_APBCLK0_TMR2CKEN_Pos   (4)
#define NUMAKER_CLK_APBCLK0_TMR3CKEN_Pos   (5)
#define NUMAKER_CLK_APBCLK0_CLKOCKEN_Pos   (6)
#define NUMAKER_CLK_APBCLK0_ACMP01CKEN_Pos (7)
#define NUMAKER_CLK_APBCLK0_I2C0CKEN_Pos   (8)
#define NUMAKER_CLK_APBCLK0_I2C1CKEN_Pos   (9)
#define NUMAKER_CLK_APBCLK0_I2C2CKEN_Pos   (10)
#define NUMAKER_CLK_APBCLK0_I2C3CKEN_Pos   (11)
#define NUMAKER_CLK_APBCLK0_QSPI0CKEN_Pos  (12)
#define NUMAKER_CLK_APBCLK0_SPI0CKEN_Pos   (13)
#define NUMAKER_CLK_APBCLK0_SPI1CKEN_Pos   (14)
#define NUMAKER_CLK_APBCLK0_SPI2CKEN_Pos   (15)
#define NUMAKER_CLK_APBCLK0_UART0CKEN_Pos  (16)
#define NUMAKER_CLK_APBCLK0_UART1CKEN_Pos  (17)
#define NUMAKER_CLK_APBCLK0_UART2CKEN_Pos  (18)
#define NUMAKER_CLK_APBCLK0_UART3CKEN_Pos  (19)
#define NUMAKER_CLK_APBCLK0_UART4CKEN_Pos  (20)
#define NUMAKER_CLK_APBCLK0_UART5CKEN_Pos  (21)
#define NUMAKER_CLK_APBCLK0_UART6CKEN_Pos  (22)
#define NUMAKER_CLK_APBCLK0_UART7CKEN_Pos  (23)
#define NUMAKER_CLK_APBCLK0_OTGCKEN_Pos	   (26)
#define NUMAKER_CLK_APBCLK0_USBDCKEN_Pos   (27)
#define NUMAKER_CLK_APBCLK0_EADC0CKEN_Pos  (28)
#define NUMAKER_CLK_APBCLK0_I2S0CKEN_Pos   (29)
#define NUMAKER_CLK_APBCLK0_HSOTGCKEN_Pos  (30)
#define NUMAKER_CLK_APBCLK1_SC0CKEN_Pos	   (0)
#define NUMAKER_CLK_APBCLK1_SC1CKEN_Pos	   (1)
#define NUMAKER_CLK_APBCLK1_SC2CKEN_Pos	   (2)
#define NUMAKER_CLK_APBCLK1_I2C4CKEN_Pos   (3)
#define NUMAKER_CLK_APBCLK1_QSPI1CKEN_Pos  (4)
#define NUMAKER_CLK_APBCLK1_SPI3CKEN_Pos   (6)
#define NUMAKER_CLK_APBCLK1_SPI4CKEN_Pos   (7)
#define NUMAKER_CLK_APBCLK1_USCI0CKEN_Pos  (8)
#define NUMAKER_CLK_APBCLK1_PSIOCKEN_Pos   (10)
#define NUMAKER_CLK_APBCLK1_DACCKEN_Pos	   (12)
#define NUMAKER_CLK_APBCLK1_ECAP2CKEN_Pos  (13)
#define NUMAKER_CLK_APBCLK1_ECAP3CKEN_Pos  (14)
#define NUMAKER_CLK_APBCLK1_EPWM0CKEN_Pos  (16)
#define NUMAKER_CLK_APBCLK1_EPWM1CKEN_Pos  (17)
#define NUMAKER_CLK_APBCLK1_BPWM0CKEN_Pos  (18)
#define NUMAKER_CLK_APBCLK1_BPWM1CKEN_Pos  (19)
#define NUMAKER_CLK_APBCLK1_EQEI2CKEN_Pos  (20)
#define NUMAKER_CLK_APBCLK1_EQEI3CKEN_Pos  (21)
#define NUMAKER_CLK_APBCLK1_EQEI0CKEN_Pos  (22)
#define NUMAKER_CLK_APBCLK1_EQEI1CKEN_Pos  (23)
#define NUMAKER_CLK_APBCLK1_TRNGCKEN_Pos   (25)
#define NUMAKER_CLK_APBCLK1_ECAP0CKEN_Pos  (26)
#define NUMAKER_CLK_APBCLK1_ECAP1CKEN_Pos  (27)
#define NUMAKER_CLK_APBCLK1_I2S1CKEN_Pos   (29)
#define NUMAKER_CLK_APBCLK1_EADC1CKEN_Pos  (31)

#define NUMAKER_CLK_CLKSEL0_HCLKSEL_Pos	  (0)
#define NUMAKER_CLK_CLKSEL0_STCLKSEL_Pos  (3)
#define NUMAKER_CLK_CLKSEL0_USBSEL_Pos	  (8)
#define NUMAKER_CLK_CLKSEL0_EADC0SEL_Pos  (10)
#define NUMAKER_CLK_CLKSEL0_EADC1SEL_Pos  (12)
#define NUMAKER_CLK_CLKSEL0_EADC2SEL_Pos  (14)
#define NUMAKER_CLK_CLKSEL0_CCAPSEL_Pos	  (16)
#define NUMAKER_CLK_CLKSEL0_SDH0SEL_Pos	  (20)
#define NUMAKER_CLK_CLKSEL0_SDH1SEL_Pos	  (22)
#define NUMAKER_CLK_CLKSEL0_CANFD0SEL_Pos (24)
#define NUMAKER_CLK_CLKSEL0_CANFD1SEL_Pos (26)
#define NUMAKER_CLK_CLKSEL0_CANFD2SEL_Pos (28)
#define NUMAKER_CLK_CLKSEL0_CANFD3SEL_Pos (30)
#define NUMAKER_CLK_CLKSEL1_WDTSEL_Pos	  (0)
#define NUMAKER_CLK_CLKSEL1_CLKOSEL_Pos	  (4)
#define NUMAKER_CLK_CLKSEL1_TMR0SEL_Pos	  (8)
#define NUMAKER_CLK_CLKSEL1_TMR1SEL_Pos	  (12)
#define NUMAKER_CLK_CLKSEL1_TMR2SEL_Pos	  (16)
#define NUMAKER_CLK_CLKSEL1_TMR3SEL_Pos	  (20)
#define NUMAKER_CLK_CLKSEL1_UART0SEL_Pos  (24)
#define NUMAKER_CLK_CLKSEL1_UART1SEL_Pos  (26)
#define NUMAKER_CLK_CLKSEL1_WWDTSEL_Pos	  (30)
#define NUMAKER_CLK_CLKSEL2_EPWM0SEL_Pos  (0)
#define NUMAKER_CLK_CLKSEL2_EPWM1SEL_Pos  (1)
#define NUMAKER_CLK_CLKSEL2_QSPI0SEL_Pos  (2)
#define NUMAKER_CLK_CLKSEL2_SPI0SEL_Pos	  (4)
#define NUMAKER_CLK_CLKSEL2_BPWM0SEL_Pos  (8)
#define NUMAKER_CLK_CLKSEL2_BPWM1SEL_Pos  (9)
#define NUMAKER_CLK_CLKSEL2_QSPI1SEL_Pos  (10)
#define NUMAKER_CLK_CLKSEL2_SPI1SEL_Pos	  (12)
#define NUMAKER_CLK_CLKSEL2_I2S1SEL_Pos	  (16)
#define NUMAKER_CLK_CLKSEL2_UART8SEL_Pos  (20)
#define NUMAKER_CLK_CLKSEL2_UART9SEL_Pos  (22)
#define NUMAKER_CLK_CLKSEL2_TRNGSEL_Pos	  (27)
#define NUMAKER_CLK_CLKSEL2_PSIOSEL_Pos	  (28)
#define NUMAKER_CLK_CLKSEL3_SC0SEL_Pos	  (0)
#define NUMAKER_CLK_CLKSEL3_SC1SEL_Pos	  (2)
#define NUMAKER_CLK_CLKSEL3_SC2SEL_Pos	  (4)
#define NUMAKER_CLK_CLKSEL3_KPISEL_Pos	  (6)
#define NUMAKER_CLK_CLKSEL3_SPI2SEL_Pos	  (9)
#define NUMAKER_CLK_CLKSEL3_SPI3SEL_Pos	  (12)
#define NUMAKER_CLK_CLKSEL3_I2S0SEL_Pos	  (16)
#define NUMAKER_CLK_CLKSEL3_UART6SEL_Pos  (20)
#define NUMAKER_CLK_CLKSEL3_UART7SEL_Pos  (22)
#define NUMAKER_CLK_CLKSEL3_UART2SEL_Pos  (24)
#define NUMAKER_CLK_CLKSEL3_UART3SEL_Pos  (26)
#define NUMAKER_CLK_CLKSEL3_UART4SEL_Pos  (28)
#define NUMAKER_CLK_CLKSEL3_UART5SEL_Pos  (30)

#define NUMAKER_CLK_CLKDIV0_HCLKDIV_Pos	  (0)
#define NUMAKER_CLK_CLKDIV0_USBDIV_Pos	  (4)
#define NUMAKER_CLK_CLKDIV0_UART0DIV_Pos  (8)
#define NUMAKER_CLK_CLKDIV0_UART1DIV_Pos  (12)
#define NUMAKER_CLK_CLKDIV0_EADC0DIV_Pos  (16)
#define NUMAKER_CLK_CLKDIV0_SDH0DIV_Pos	  (24)
#define NUMAKER_CLK_CLKDIV1_SC0DIV_Pos	  (0)
#define NUMAKER_CLK_CLKDIV1_SC1DIV_Pos	  (8)
#define NUMAKER_CLK_CLKDIV1_SC2DIV_Pos	  (16)
#define NUMAKER_CLK_CLKDIV1_PSIODIV_Pos	  (24)
#define NUMAKER_CLK_CLKDIV2_I2S0DIV_Pos	  (0)
#define NUMAKER_CLK_CLKDIV2_I2S1DIV_Pos	  (4)
#define NUMAKER_CLK_CLKDIV2_KPIDIV_Pos	  (8)
#define NUMAKER_CLK_CLKDIV2_EADC1DIV_Pos  (24)
#define NUMAKER_CLK_CLKDIV3_VSENSEDIV_Pos (8)
#define NUMAKER_CLK_CLKDIV3_EMAC0DIV_Pos  (16)
#define NUMAKER_CLK_CLKDIV3_SDH1DIV_Pos	  (24)
#define NUMAKER_CLK_CLKDIV4_UART2DIV_Pos  (0)
#define NUMAKER_CLK_CLKDIV4_UART3DIV_Pos  (4)
#define NUMAKER_CLK_CLKDIV4_UART4DIV_Pos  (8)
#define NUMAKER_CLK_CLKDIV4_UART5DIV_Pos  (12)
#define NUMAKER_CLK_CLKDIV4_UART6DIV_Pos  (16)
#define NUMAKER_CLK_CLKDIV4_UART7DIV_Pos  (20)

#define NUMAKER_CLK_PCLKDIV_APB0DIV_Pos (0)
#define NUMAKER_CLK_PCLKDIV_APB1DIV_Pos (4)

#define NUMAKER_CLK_APBCLK2_KPICKEN_Pos	   (0)
#define NUMAKER_CLK_APBCLK2_EADC2CKEN_Pos  (6)
#define NUMAKER_CLK_APBCLK2_ACMP23CKEN_Pos (7)
#define NUMAKER_CLK_APBCLK2_SPI5CKEN_Pos   (8)
#define NUMAKER_CLK_APBCLK2_SPI6CKEN_Pos   (9)
#define NUMAKER_CLK_APBCLK2_SPI7CKEN_Pos   (10)
#define NUMAKER_CLK_APBCLK2_SPI8CKEN_Pos   (11)
#define NUMAKER_CLK_APBCLK2_SPI9CKEN_Pos   (12)
#define NUMAKER_CLK_APBCLK2_SPI10CKEN_Pos  (13)
#define NUMAKER_CLK_APBCLK2_UART8CKEN_Pos  (16)
#define NUMAKER_CLK_APBCLK2_UART9CKEN_Pos  (17)

#define NUMAKER_CLK_CLKDIV5_CANFD0DIV_Pos (0)
#define NUMAKER_CLK_CLKDIV5_CANFD1DIV_Pos (4)
#define NUMAKER_CLK_CLKDIV5_CANFD2DIV_Pos (8)
#define NUMAKER_CLK_CLKDIV5_CANFD3DIV_Pos (12)
#define NUMAKER_CLK_CLKDIV5_UART8DIV_Pos  (16)
#define NUMAKER_CLK_CLKDIV5_UART9DIV_Pos  (20)
#define NUMAKER_CLK_CLKDIV5_EADC2DIV_Pos  (24)

#define NUMAKER_CLK_AHBCLK1_CANFD0CKEN_Pos (20)
#define NUMAKER_CLK_AHBCLK1_CANFD1CKEN_Pos (21)
#define NUMAKER_CLK_AHBCLK1_CANFD2CKEN_Pos (22)
#define NUMAKER_CLK_AHBCLK1_CANFD3CKEN_Pos (23)
#define NUMAKER_CLK_AHBCLK1_GPICKEN_Pos	   (24)
#define NUMAKER_CLK_AHBCLK1_GPJCKEN_Pos	   (25)
#define NUMAKER_CLK_AHBCLK1_BMCCKEN_Pos	   (28)

#define NUMAKER_CLK_CLKSEL4_SPI4SEL_Pos	 (0)
#define NUMAKER_CLK_CLKSEL4_SPI5SEL_Pos	 (4)
#define NUMAKER_CLK_CLKSEL4_SPI6SEL_Pos	 (8)
#define NUMAKER_CLK_CLKSEL4_SPI7SEL_Pos	 (12)
#define NUMAKER_CLK_CLKSEL4_SPI8SEL_Pos	 (16)
#define NUMAKER_CLK_CLKSEL4_SPI9SEL_Pos	 (20)
#define NUMAKER_CLK_CLKSEL4_SPI10SEL_Pos (24)

/* End of M460 BSP clk_reg.h copy */

/* Beginning of M460 BSP clk.h copy */

/*  CLKSEL0 constant definitions.  (Write-protection) */

#define NUMAKER_CLK_CLKSEL0_HCLKSEL_HXT	 (0x0UL << NUMAKER_CLK_CLKSEL0_HCLKSEL_Pos)
#define NUMAKER_CLK_CLKSEL0_HCLKSEL_LXT	 (0x1UL << NUMAKER_CLK_CLKSEL0_HCLKSEL_Pos)
#define NUMAKER_CLK_CLKSEL0_HCLKSEL_PLL	 (0x2UL << NUMAKER_CLK_CLKSEL0_HCLKSEL_Pos)
#define NUMAKER_CLK_CLKSEL0_HCLKSEL_LIRC (0x3UL << NUMAKER_CLK_CLKSEL0_HCLKSEL_Pos)
#define NUMAKER_CLK_CLKSEL0_HCLKSEL_HIRC (0x7UL << NUMAKER_CLK_CLKSEL0_HCLKSEL_Pos)

#define NUMAKER_CLK_CLKSEL0_STCLKSEL_HXT       (0x0UL << NUMAKER_CLK_CLKSEL0_STCLKSEL_Pos)
#define NUMAKER_CLK_CLKSEL0_STCLKSEL_LXT       (0x1UL << NUMAKER_CLK_CLKSEL0_STCLKSEL_Pos)
#define NUMAKER_CLK_CLKSEL0_STCLKSEL_HXT_DIV2  (0x2UL << NUMAKER_CLK_CLKSEL0_STCLKSEL_Pos)
#define NUMAKER_CLK_CLKSEL0_STCLKSEL_HCLK_DIV2 (0x3UL << NUMAKER_CLK_CLKSEL0_STCLKSEL_Pos)
#define NUMAKER_CLK_CLKSEL0_STCLKSEL_HIRC_DIV2 (0x7UL << NUMAKER_CLK_CLKSEL0_STCLKSEL_Pos)
#define NUMAKER_CLK_CLKSEL0_STCLKSEL_HCLK      (0x1UL << SysTick_CTRL_CLKSOURCE_Pos)

#define NUMAKER_CLK_CLKSEL0_USBSEL_HIRC48M  (0x0UL << NUMAKER_CLK_CLKSEL0_USBSEL_Pos)
#define NUMAKER_CLK_CLKSEL0_USBSEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL0_USBSEL_Pos)

#define NUMAKER_CLK_CLKSEL0_EADC0SEL_PLLFN_DIV2 (0x0UL << NUMAKER_CLK_CLKSEL0_EADC0SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_EADC0SEL_PLL_DIV2	(0x1UL << NUMAKER_CLK_CLKSEL0_EADC0SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_EADC0SEL_HCLK	(0x2UL << NUMAKER_CLK_CLKSEL0_EADC0SEL_Pos)

#define NUMAKER_CLK_CLKSEL0_EADC1SEL_PLLFN_DIV2 (0x0UL << NUMAKER_CLK_CLKSEL0_EADC1SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_EADC1SEL_PLL_DIV2	(0x1UL << NUMAKER_CLK_CLKSEL0_EADC1SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_EADC1SEL_HCLK	(0x2UL << NUMAKER_CLK_CLKSEL0_EADC1SEL_Pos)

#define NUMAKER_CLK_CLKSEL0_EADC2SEL_PLLFN_DIV2 (0x0UL << NUMAKER_CLK_CLKSEL0_EADC2SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_EADC2SEL_PLL_DIV2	(0x1UL << NUMAKER_CLK_CLKSEL0_EADC2SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_EADC2SEL_HCLK	(0x2UL << NUMAKER_CLK_CLKSEL0_EADC2SEL_Pos)

#define NUMAKER_CLK_CLKSEL0_CCAPSEL_HXT	     (0x0UL << NUMAKER_CLK_CLKSEL0_CCAPSEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CCAPSEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL0_CCAPSEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CCAPSEL_HCLK     (0x2UL << NUMAKER_CLK_CLKSEL0_CCAPSEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CCAPSEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL0_CCAPSEL_Pos)

#define NUMAKER_CLK_CLKSEL0_SDH0SEL_HXT	     (0x0UL << NUMAKER_CLK_CLKSEL0_SDH0SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_SDH0SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL0_SDH0SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_SDH0SEL_HCLK     (0x2UL << NUMAKER_CLK_CLKSEL0_SDH0SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_SDH0SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL0_SDH0SEL_Pos)

#define NUMAKER_CLK_CLKSEL0_SDH1SEL_HXT	     (0x0UL << NUMAKER_CLK_CLKSEL0_SDH1SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_SDH1SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL0_SDH1SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_SDH1SEL_HCLK     (0x2UL << NUMAKER_CLK_CLKSEL0_SDH1SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_SDH1SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL0_SDH1SEL_Pos)

#define NUMAKER_CLK_CLKSEL0_CANFD0SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL0_CANFD0SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CANFD0SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL0_CANFD0SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CANFD0SEL_HCLK     (0x2UL << NUMAKER_CLK_CLKSEL0_CANFD0SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CANFD0SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL0_CANFD0SEL_Pos)

#define NUMAKER_CLK_CLKSEL0_CANFD1SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL0_CANFD1SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CANFD1SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL0_CANFD1SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CANFD1SEL_HCLK     (0x2UL << NUMAKER_CLK_CLKSEL0_CANFD1SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CANFD1SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL0_CANFD1SEL_Pos)

#define NUMAKER_CLK_CLKSEL0_CANFD2SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL0_CANFD2SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CANFD2SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL0_CANFD2SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CANFD2SEL_HCLK     (0x2UL << NUMAKER_CLK_CLKSEL0_CANFD2SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CANFD2SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL0_CANFD2SEL_Pos)

#define NUMAKER_CLK_CLKSEL0_CANFD3SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL0_CANFD3SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CANFD3SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL0_CANFD3SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CANFD3SEL_HCLK     (0x2UL << NUMAKER_CLK_CLKSEL0_CANFD3SEL_Pos)
#define NUMAKER_CLK_CLKSEL0_CANFD3SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL0_CANFD3SEL_Pos)

/*  CLKSEL1 constant definitions. */

#define NUMAKER_CLK_CLKSEL1_WDTSEL_LXT		(0x1UL << NUMAKER_CLK_CLKSEL1_WDTSEL_Pos)
#define NUMAKER_CLK_CLKSEL1_WDTSEL_HCLK_DIV2048 (0x2UL << NUMAKER_CLK_CLKSEL1_WDTSEL_Pos)
#define NUMAKER_CLK_CLKSEL1_WDTSEL_LIRC		(0x3UL << NUMAKER_CLK_CLKSEL1_WDTSEL_Pos)

#define NUMAKER_CLK_CLKSEL1_CLKOSEL_HXT	       (0x0UL << NUMAKER_CLK_CLKSEL1_CLKOSEL_Pos)
#define NUMAKER_CLK_CLKSEL1_CLKOSEL_LXT	       (0x1UL << NUMAKER_CLK_CLKSEL1_CLKOSEL_Pos)
#define NUMAKER_CLK_CLKSEL1_CLKOSEL_HCLK       (0x2UL << NUMAKER_CLK_CLKSEL1_CLKOSEL_Pos)
#define NUMAKER_CLK_CLKSEL1_CLKOSEL_HIRC       (0x3UL << NUMAKER_CLK_CLKSEL1_CLKOSEL_Pos)
#define NUMAKER_CLK_CLKSEL1_CLKOSEL_LIRC       (0x4UL << NUMAKER_CLK_CLKSEL1_CLKOSEL_Pos)
#define NUMAKER_CLK_CLKSEL1_CLKOSEL_PLLFN_DIV2 (0x5UL << NUMAKER_CLK_CLKSEL1_CLKOSEL_Pos)
#define NUMAKER_CLK_CLKSEL1_CLKOSEL_PLL_DIV2   (0x6UL << NUMAKER_CLK_CLKSEL1_CLKOSEL_Pos)

#define NUMAKER_CLK_CLKSEL1_TMR0SEL_HXT	  (0x0UL << NUMAKER_CLK_CLKSEL1_TMR0SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR0SEL_LXT	  (0x1UL << NUMAKER_CLK_CLKSEL1_TMR0SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR0SEL_PCLK0 (0x2UL << NUMAKER_CLK_CLKSEL1_TMR0SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR0SEL_EXT	  (0x3UL << NUMAKER_CLK_CLKSEL1_TMR0SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR0SEL_LIRC  (0x5UL << NUMAKER_CLK_CLKSEL1_TMR0SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR0SEL_HIRC  (0x7UL << NUMAKER_CLK_CLKSEL1_TMR0SEL_Pos)

#define NUMAKER_CLK_CLKSEL1_TMR1SEL_HXT	  (0x0UL << NUMAKER_CLK_CLKSEL1_TMR1SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR1SEL_LXT	  (0x1UL << NUMAKER_CLK_CLKSEL1_TMR1SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR1SEL_PCLK0 (0x2UL << NUMAKER_CLK_CLKSEL1_TMR1SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR1SEL_EXT	  (0x3UL << NUMAKER_CLK_CLKSEL1_TMR1SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR1SEL_LIRC  (0x5UL << NUMAKER_CLK_CLKSEL1_TMR1SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR1SEL_HIRC  (0x7UL << NUMAKER_CLK_CLKSEL1_TMR1SEL_Pos)

#define NUMAKER_CLK_CLKSEL1_TMR2SEL_HXT	  (0x0UL << NUMAKER_CLK_CLKSEL1_TMR2SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR2SEL_LXT	  (0x1UL << NUMAKER_CLK_CLKSEL1_TMR2SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR2SEL_PCLK1 (0x2UL << NUMAKER_CLK_CLKSEL1_TMR2SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR2SEL_EXT	  (0x3UL << NUMAKER_CLK_CLKSEL1_TMR2SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR2SEL_LIRC  (0x5UL << NUMAKER_CLK_CLKSEL1_TMR2SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR2SEL_HIRC  (0x7UL << NUMAKER_CLK_CLKSEL1_TMR2SEL_Pos)

#define NUMAKER_CLK_CLKSEL1_TMR3SEL_HXT	  (0x0UL << NUMAKER_CLK_CLKSEL1_TMR3SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR3SEL_LXT	  (0x1UL << NUMAKER_CLK_CLKSEL1_TMR3SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR3SEL_PCLK1 (0x2UL << NUMAKER_CLK_CLKSEL1_TMR3SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR3SEL_EXT	  (0x3UL << NUMAKER_CLK_CLKSEL1_TMR3SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR3SEL_LIRC  (0x5UL << NUMAKER_CLK_CLKSEL1_TMR3SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_TMR3SEL_HIRC  (0x7UL << NUMAKER_CLK_CLKSEL1_TMR3SEL_Pos)

#define NUMAKER_CLK_CLKSEL1_UART0SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL1_UART0SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_UART0SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL1_UART0SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_UART0SEL_LXT      (0x2UL << NUMAKER_CLK_CLKSEL1_UART0SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_UART0SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL1_UART0SEL_Pos)

#define NUMAKER_CLK_CLKSEL1_UART1SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL1_UART1SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_UART1SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL1_UART1SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_UART1SEL_LXT      (0x2UL << NUMAKER_CLK_CLKSEL1_UART1SEL_Pos)
#define NUMAKER_CLK_CLKSEL1_UART1SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL1_UART1SEL_Pos)

#define NUMAKER_CLK_CLKSEL1_WWDTSEL_HCLK_DIV2048 (0x2UL << NUMAKER_CLK_CLKSEL1_WWDTSEL_Pos)
#define NUMAKER_CLK_CLKSEL1_WWDTSEL_LIRC	 (0x3UL << NUMAKER_CLK_CLKSEL1_WWDTSEL_Pos)

/*  CLKSEL2 constant definitions. */

#define NUMAKER_CLK_CLKSEL2_EPWM0SEL_HCLK  (0x0UL << NUMAKER_CLK_CLKSEL2_EPWM0SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_EPWM0SEL_PCLK0 (0x1UL << NUMAKER_CLK_CLKSEL2_EPWM0SEL_Pos)

#define NUMAKER_CLK_CLKSEL2_EPWM1SEL_HCLK  (0x0UL << NUMAKER_CLK_CLKSEL2_EPWM1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_EPWM1SEL_PCLK1 (0x1UL << NUMAKER_CLK_CLKSEL2_EPWM1SEL_Pos)

#define NUMAKER_CLK_CLKSEL2_QSPI0SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL2_QSPI0SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_QSPI0SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL2_QSPI0SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_QSPI0SEL_PCLK0    (0x2UL << NUMAKER_CLK_CLKSEL2_QSPI0SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_QSPI0SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL2_QSPI0SEL_Pos)

#define NUMAKER_CLK_CLKSEL2_SPI0SEL_HXT	       (0x0UL << NUMAKER_CLK_CLKSEL2_SPI0SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_SPI0SEL_PLL_DIV2   (0x1UL << NUMAKER_CLK_CLKSEL2_SPI0SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_SPI0SEL_PCLK1      (0x2UL << NUMAKER_CLK_CLKSEL2_SPI0SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_SPI0SEL_HIRC       (0x3UL << NUMAKER_CLK_CLKSEL2_SPI0SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_SPI0SEL_HIRC48M    (0x4UL << NUMAKER_CLK_CLKSEL2_SPI0SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_SPI0SEL_PLLFN_DIV2 (0x5UL << NUMAKER_CLK_CLKSEL2_SPI0SEL_Pos)

#define NUMAKER_CLK_CLKSEL2_BPWM0SEL_HCLK  (0x0UL << NUMAKER_CLK_CLKSEL2_BPWM0SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_BPWM0SEL_PCLK0 (0x1UL << NUMAKER_CLK_CLKSEL2_BPWM0SEL_Pos)

#define NUMAKER_CLK_CLKSEL2_BPWM1SEL_HCLK  (0x0UL << NUMAKER_CLK_CLKSEL2_BPWM1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_BPWM1SEL_PCLK1 (0x1UL << NUMAKER_CLK_CLKSEL2_BPWM1SEL_Pos)

#define NUMAKER_CLK_CLKSEL2_QSPI1SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL2_QSPI1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_QSPI1SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL2_QSPI1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_QSPI1SEL_PCLK1    (0x2UL << NUMAKER_CLK_CLKSEL2_QSPI1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_QSPI1SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL2_QSPI1SEL_Pos)

#define NUMAKER_CLK_CLKSEL2_SPI1SEL_HXT	       (0x0UL << NUMAKER_CLK_CLKSEL2_SPI1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_SPI1SEL_PLL_DIV2   (0x1UL << NUMAKER_CLK_CLKSEL2_SPI1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_SPI1SEL_PCLK0      (0x2UL << NUMAKER_CLK_CLKSEL2_SPI1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_SPI1SEL_HIRC       (0x3UL << NUMAKER_CLK_CLKSEL2_SPI1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_SPI1SEL_HIRC48M    (0x4UL << NUMAKER_CLK_CLKSEL2_SPI1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_SPI1SEL_PLLFN_DIV2 (0x5UL << NUMAKER_CLK_CLKSEL2_SPI1SEL_Pos)

#define NUMAKER_CLK_CLKSEL2_I2S1SEL_HXT	       (0x0UL << NUMAKER_CLK_CLKSEL2_I2S1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_I2S1SEL_PLL_DIV2   (0x1UL << NUMAKER_CLK_CLKSEL2_I2S1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_I2S1SEL_PCLK1      (0x2UL << NUMAKER_CLK_CLKSEL2_I2S1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_I2S1SEL_HIRC       (0x3UL << NUMAKER_CLK_CLKSEL2_I2S1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_I2S1SEL_HIRC48M    (0x4UL << NUMAKER_CLK_CLKSEL2_I2S1SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_I2S1SEL_PLLFN_DIV2 (0x5UL << NUMAKER_CLK_CLKSEL2_I2S1SEL_Pos)

#define NUMAKER_CLK_CLKSEL2_UART8SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL2_UART8SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_UART8SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL2_UART8SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_UART8SEL_LXT      (0x2UL << NUMAKER_CLK_CLKSEL2_UART8SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_UART8SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL2_UART8SEL_Pos)

#define NUMAKER_CLK_CLKSEL2_UART9SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL2_UART9SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_UART9SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL2_UART9SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_UART9SEL_LXT      (0x2UL << NUMAKER_CLK_CLKSEL2_UART9SEL_Pos)
#define NUMAKER_CLK_CLKSEL2_UART9SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL2_UART9SEL_Pos)

#define NUMAKER_CLK_CLKSEL2_TRNGSEL_LXT	 (0x0UL << NUMAKER_CLK_CLKSEL2_TRNGSEL_Pos)
#define NUMAKER_CLK_CLKSEL2_TRNGSEL_LIRC (0x1UL << NUMAKER_CLK_CLKSEL2_TRNGSEL_Pos)

#define NUMAKER_CLK_CLKSEL2_PSIOSEL_HXT	     (0x0UL << NUMAKER_CLK_CLKSEL2_PSIOSEL_Pos)
#define NUMAKER_CLK_CLKSEL2_PSIOSEL_LXT	     (0x1UL << NUMAKER_CLK_CLKSEL2_PSIOSEL_Pos)
#define NUMAKER_CLK_CLKSEL2_PSIOSEL_PCLK1    (0x2UL << NUMAKER_CLK_CLKSEL2_PSIOSEL_Pos)
#define NUMAKER_CLK_CLKSEL2_PSIOSEL_PLL_DIV2 (0x3UL << NUMAKER_CLK_CLKSEL2_PSIOSEL_Pos)
#define NUMAKER_CLK_CLKSEL2_PSIOSEL_LIRC     (0x4UL << NUMAKER_CLK_CLKSEL2_PSIOSEL_Pos)
#define NUMAKER_CLK_CLKSEL2_PSIOSEL_HIRC     (0x5UL << NUMAKER_CLK_CLKSEL2_PSIOSEL_Pos)

/*  CLKSEL3 constant definitions. */

#define NUMAKER_CLK_CLKSEL3_SC0SEL_HXT	    (0x0UL << NUMAKER_CLK_CLKSEL3_SC0SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SC0SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL3_SC0SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SC0SEL_PCLK0    (0x2UL << NUMAKER_CLK_CLKSEL3_SC0SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SC0SEL_HIRC	    (0x3UL << NUMAKER_CLK_CLKSEL3_SC0SEL_Pos)

#define NUMAKER_CLK_CLKSEL3_SC1SEL_HXT	    (0x0UL << NUMAKER_CLK_CLKSEL3_SC1SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SC1SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL3_SC1SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SC1SEL_PCLK1    (0x2UL << NUMAKER_CLK_CLKSEL3_SC1SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SC1SEL_HIRC	    (0x3UL << NUMAKER_CLK_CLKSEL3_SC1SEL_Pos)

#define NUMAKER_CLK_CLKSEL3_SC2SEL_HXT	    (0x0UL << NUMAKER_CLK_CLKSEL3_SC2SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SC2SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL3_SC2SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SC2SEL_PCLK0    (0x2UL << NUMAKER_CLK_CLKSEL3_SC2SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SC2SEL_HIRC	    (0x3UL << NUMAKER_CLK_CLKSEL3_SC2SEL_Pos)

#define NUMAKER_CLK_CLKSEL3_KPISEL_HXT	(0x0UL << NUMAKER_CLK_CLKSEL3_KPISEL_Pos)
#define NUMAKER_CLK_CLKSEL3_KPISEL_LIRC (0x1UL << NUMAKER_CLK_CLKSEL3_KPISEL_Pos)
#define NUMAKER_CLK_CLKSEL3_KPISEL_HIRC (0x2UL << NUMAKER_CLK_CLKSEL3_KPISEL_Pos)

#define NUMAKER_CLK_CLKSEL3_SPI2SEL_HXT	       (0x0UL << NUMAKER_CLK_CLKSEL3_SPI2SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SPI2SEL_PLL_DIV2   (0x1UL << NUMAKER_CLK_CLKSEL3_SPI2SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SPI2SEL_PCLK1      (0x2UL << NUMAKER_CLK_CLKSEL3_SPI2SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SPI2SEL_HIRC       (0x3UL << NUMAKER_CLK_CLKSEL3_SPI2SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SPI2SEL_HIRC48M    (0x4UL << NUMAKER_CLK_CLKSEL3_SPI2SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SPI2SEL_PLLFN_DIV2 (0x5UL << NUMAKER_CLK_CLKSEL3_SPI2SEL_Pos)

#define NUMAKER_CLK_CLKSEL3_SPI3SEL_HXT	       (0x0UL << NUMAKER_CLK_CLKSEL3_SPI3SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SPI3SEL_PLL_DIV2   (0x1UL << NUMAKER_CLK_CLKSEL3_SPI3SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SPI3SEL_PCLK0      (0x2UL << NUMAKER_CLK_CLKSEL3_SPI3SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SPI3SEL_HIRC       (0x3UL << NUMAKER_CLK_CLKSEL3_SPI3SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SPI3SEL_HIRC48M    (0x4UL << NUMAKER_CLK_CLKSEL3_SPI3SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_SPI3SEL_PLLFN_DIV2 (0x5UL << NUMAKER_CLK_CLKSEL3_SPI3SEL_Pos)

#define NUMAKER_CLK_CLKSEL3_I2S0SEL_HXT	       (0x0UL << NUMAKER_CLK_CLKSEL3_I2S0SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_I2S0SEL_PLL_DIV2   (0x1UL << NUMAKER_CLK_CLKSEL3_I2S0SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_I2S0SEL_PCLK0      (0x2UL << NUMAKER_CLK_CLKSEL3_I2S0SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_I2S0SEL_HIRC       (0x3UL << NUMAKER_CLK_CLKSEL3_I2S0SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_I2S0SEL_HIRC48M    (0x4UL << NUMAKER_CLK_CLKSEL3_I2S0SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_I2S0SEL_PLLFN_DIV2 (0x5UL << NUMAKER_CLK_CLKSEL3_I2S0SEL_Pos)

#define NUMAKER_CLK_CLKSEL3_UART6SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL3_UART6SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART6SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL3_UART6SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART6SEL_LXT      (0x2UL << NUMAKER_CLK_CLKSEL3_UART6SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART6SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL3_UART6SEL_Pos)

#define NUMAKER_CLK_CLKSEL3_UART7SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL3_UART7SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART7SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL3_UART7SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART7SEL_LXT      (0x2UL << NUMAKER_CLK_CLKSEL3_UART7SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART7SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL3_UART7SEL_Pos)

#define NUMAKER_CLK_CLKSEL3_UART2SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL3_UART2SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART2SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL3_UART2SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART2SEL_LXT      (0x2UL << NUMAKER_CLK_CLKSEL3_UART2SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART2SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL3_UART2SEL_Pos)

#define NUMAKER_CLK_CLKSEL3_UART3SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL3_UART3SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART3SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL3_UART3SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART3SEL_LXT      (0x2UL << NUMAKER_CLK_CLKSEL3_UART3SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART3SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL3_UART3SEL_Pos)

#define NUMAKER_CLK_CLKSEL3_UART4SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL3_UART4SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART4SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL3_UART4SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART4SEL_LXT      (0x2UL << NUMAKER_CLK_CLKSEL3_UART4SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART4SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL3_UART4SEL_Pos)

#define NUMAKER_CLK_CLKSEL3_UART5SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL3_UART5SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART5SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL3_UART5SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART5SEL_LXT      (0x2UL << NUMAKER_CLK_CLKSEL3_UART5SEL_Pos)
#define NUMAKER_CLK_CLKSEL3_UART5SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL3_UART5SEL_Pos)

/*  CLKSEL4 constant definitions. */

#define NUMAKER_CLK_CLKSEL4_SPI4SEL_HXT	     (0x0UL << NUMAKER_CLK_CLKSEL4_SPI4SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI4SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL4_SPI4SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI4SEL_PCLK1    (0x2UL << NUMAKER_CLK_CLKSEL4_SPI4SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI4SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL4_SPI4SEL_Pos)

#define NUMAKER_CLK_CLKSEL4_SPI5SEL_HXT	     (0x0UL << NUMAKER_CLK_CLKSEL4_SPI5SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI5SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL4_SPI5SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI5SEL_PCLK0    (0x2UL << NUMAKER_CLK_CLKSEL4_SPI5SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI5SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL4_SPI5SEL_Pos)

#define NUMAKER_CLK_CLKSEL4_SPI6SEL_HXT	     (0x0UL << NUMAKER_CLK_CLKSEL4_SPI6SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI6SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL4_SPI6SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI6SEL_PCLK1    (0x2UL << NUMAKER_CLK_CLKSEL4_SPI6SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI6SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL4_SPI6SEL_Pos)

#define NUMAKER_CLK_CLKSEL4_SPI7SEL_HXT	     (0x0UL << NUMAKER_CLK_CLKSEL4_SPI7SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI7SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL4_SPI7SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI7SEL_PCLK0    (0x2UL << NUMAKER_CLK_CLKSEL4_SPI7SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI7SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL4_SPI7SEL_Pos)

#define NUMAKER_CLK_CLKSEL4_SPI8SEL_HXT	     (0x0UL << NUMAKER_CLK_CLKSEL4_SPI8SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI8SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL4_SPI8SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI8SEL_PCLK1    (0x2UL << NUMAKER_CLK_CLKSEL4_SPI8SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI8SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL4_SPI8SEL_Pos)

#define NUMAKER_CLK_CLKSEL4_SPI9SEL_HXT	     (0x0UL << NUMAKER_CLK_CLKSEL4_SPI9SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI9SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL4_SPI9SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI9SEL_PCLK0    (0x2UL << NUMAKER_CLK_CLKSEL4_SPI9SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI9SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL4_SPI9SEL_Pos)

#define NUMAKER_CLK_CLKSEL4_SPI10SEL_HXT      (0x0UL << NUMAKER_CLK_CLKSEL4_SPI10SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI10SEL_PLL_DIV2 (0x1UL << NUMAKER_CLK_CLKSEL4_SPI10SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI10SEL_PCLK1    (0x2UL << NUMAKER_CLK_CLKSEL4_SPI10SEL_Pos)
#define NUMAKER_CLK_CLKSEL4_SPI10SEL_HIRC     (0x3UL << NUMAKER_CLK_CLKSEL4_SPI10SEL_Pos)

/*  CLKDIV0 constant definitions. */

#define NUMAKER_CLK_CLKDIV0_HCLK(x)  (((x)-1UL) << NUMAKER_CLK_CLKDIV0_HCLKDIV_Pos)
#define NUMAKER_CLK_CLKDIV0_USB(x)   (((x)-1UL) << NUMAKER_CLK_CLKDIV0_USBDIV_Pos)
#define NUMAKER_CLK_CLKDIV0_SDH0(x)  (((x)-1UL) << NUMAKER_CLK_CLKDIV0_SDH0DIV_Pos)
#define NUMAKER_CLK_CLKDIV0_UART0(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV0_UART0DIV_Pos)
#define NUMAKER_CLK_CLKDIV0_UART1(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV0_UART1DIV_Pos)
#define NUMAKER_CLK_CLKDIV0_EADC0(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV0_EADC0DIV_Pos)

/*  CLKDIV1 constant definitions. */

#define NUMAKER_CLK_CLKDIV1_SC0(x)  (((x)-1UL) << NUMAKER_CLK_CLKDIV1_SC0DIV_Pos)
#define NUMAKER_CLK_CLKDIV1_SC1(x)  (((x)-1UL) << NUMAKER_CLK_CLKDIV1_SC1DIV_Pos)
#define NUMAKER_CLK_CLKDIV1_SC2(x)  (((x)-1UL) << NUMAKER_CLK_CLKDIV1_SC2DIV_Pos)
#define NUMAKER_CLK_CLKDIV1_PSIO(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV1_PSIODIV_Pos)

/*  CLKDIV2 constant definitions. */

#define NUMAKER_CLK_CLKDIV2_I2S0(x)  (((x)-1UL) << NUMAKER_CLK_CLKDIV2_I2S0DIV_Pos)
#define NUMAKER_CLK_CLKDIV2_I2S1(x)  (((x)-1UL) << NUMAKER_CLK_CLKDIV2_I2S1DIV_Pos)
#define NUMAKER_CLK_CLKDIV2_KPI(x)   (((x)-1UL) << NUMAKER_CLK_CLKDIV2_KPIDIV_Pos)
#define NUMAKER_CLK_CLKDIV2_EADC1(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV2_EADC1DIV_Pos)

/*  CLKDIV3 constant definitions. */

#define NUMAKER_CLK_CLKDIV3_VSENSE(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV3_VSENSEDIV_Pos)
#define NUMAKER_CLK_CLKDIV3_EMAC0(x)  (((x)-1UL) << NUMAKER_CLK_CLKDIV3_EMAC0DIV_Pos)
#define NUMAKER_CLK_CLKDIV3_SDH1(x)   (((x)-1UL) << NUMAKER_CLK_CLKDIV3_SDH1DIV_Pos)

/*  CLKDIV4 constant definitions. */

#define NUMAKER_CLK_CLKDIV4_UART2(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV4_UART2DIV_Pos)
#define NUMAKER_CLK_CLKDIV4_UART3(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV4_UART3DIV_Pos)
#define NUMAKER_CLK_CLKDIV4_UART4(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV4_UART4DIV_Pos)
#define NUMAKER_CLK_CLKDIV4_UART5(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV4_UART5DIV_Pos)
#define NUMAKER_CLK_CLKDIV4_UART6(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV4_UART6DIV_Pos)
#define NUMAKER_CLK_CLKDIV4_UART7(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV4_UART7DIV_Pos)

/*  CLKDIV5 constant definitions. */

#define NUMAKER_CLK_CLKDIV5_CANFD0(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV5_CANFD0DIV_Pos)
#define NUMAKER_CLK_CLKDIV5_CANFD1(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV5_CANFD1DIV_Pos)
#define NUMAKER_CLK_CLKDIV5_CANFD2(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV5_CANFD2DIV_Pos)
#define NUMAKER_CLK_CLKDIV5_CANFD3(x) (((x)-1UL) << NUMAKER_CLK_CLKDIV5_CANFD3DIV_Pos)
#define NUMAKER_CLK_CLKDIV5_UART8(x)  (((x)-1UL) << NUMAKER_CLK_CLKDIV5_UART8DIV_Pos)
#define NUMAKER_CLK_CLKDIV5_UART9(x)  (((x)-1UL) << NUMAKER_CLK_CLKDIV5_UART9DIV_Pos)
#define NUMAKER_CLK_CLKDIV5_EADC2(x)  (((x)-1UL) << NUMAKER_CLK_CLKDIV5_EADC2DIV_Pos)

/*  PCLKDIV constant definitions. */

#define NUMAKER_CLK_PCLKDIV_PCLK0DIV1  (0x0UL << NUMAKER_CLK_PCLKDIV_APB0DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_PCLK0DIV2  (0x1UL << NUMAKER_CLK_PCLKDIV_APB0DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_PCLK0DIV4  (0x2UL << NUMAKER_CLK_PCLKDIV_APB0DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_PCLK0DIV8  (0x3UL << NUMAKER_CLK_PCLKDIV_APB0DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_PCLK0DIV16 (0x4UL << NUMAKER_CLK_PCLKDIV_APB0DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_PCLK1DIV1  (0x0UL << NUMAKER_CLK_PCLKDIV_APB1DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_PCLK1DIV2  (0x1UL << NUMAKER_CLK_PCLKDIV_APB1DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_PCLK1DIV4  (0x2UL << NUMAKER_CLK_PCLKDIV_APB1DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_PCLK1DIV8  (0x3UL << NUMAKER_CLK_PCLKDIV_APB1DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_PCLK1DIV16 (0x4UL << NUMAKER_CLK_PCLKDIV_APB1DIV_Pos)

#define NUMAKER_CLK_PCLKDIV_APB0DIV_DIV1  (0x0UL << NUMAKER_CLK_PCLKDIV_APB0DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_APB0DIV_DIV2  (0x1UL << NUMAKER_CLK_PCLKDIV_APB0DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_APB0DIV_DIV4  (0x2UL << NUMAKER_CLK_PCLKDIV_APB0DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_APB0DIV_DIV8  (0x3UL << NUMAKER_CLK_PCLKDIV_APB0DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_APB0DIV_DIV16 (0x4UL << NUMAKER_CLK_PCLKDIV_APB0DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_APB1DIV_DIV1  (0x0UL << NUMAKER_CLK_PCLKDIV_APB1DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_APB1DIV_DIV2  (0x1UL << NUMAKER_CLK_PCLKDIV_APB1DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_APB1DIV_DIV4  (0x2UL << NUMAKER_CLK_PCLKDIV_APB1DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_APB1DIV_DIV8  (0x3UL << NUMAKER_CLK_PCLKDIV_APB1DIV_Pos)
#define NUMAKER_CLK_PCLKDIV_APB1DIV_DIV16 (0x4UL << NUMAKER_CLK_PCLKDIV_APB1DIV_Pos)

/*  MODULE constant definitions. */

/*
 * APBCLK(31:29)|CLKSEL(28:26)|CLKSEL_Msk(25:22)|CLKSEL_Pos(21:17)|CLKDIV(16:14)|
 * CLKDIV_Msk(13:10)|CLKDIV_Pos(9:5)|IP_EN_Pos(4:0)
 */

#define NUMAKER_MODULE_NoMsk 0x0UL
#define NUMAKER_NA	     NUMAKER_MODULE_NoMsk

#define NUMAKER_MODULE_APBCLK_ENC(x)	 (((x)&0x07UL) << 29)
#define NUMAKER_MODULE_CLKSEL_ENC(x)	 (((x)&0x07UL) << 26)
#define NUMAKER_MODULE_CLKSEL_Msk_ENC(x) (((x)&0x0fUL) << 22)
#define NUMAKER_MODULE_CLKSEL_Pos_ENC(x) (((x)&0x1fUL) << 17)
#define NUMAKER_MODULE_CLKDIV_ENC(x)	 (((x)&0x07UL) << 14)
#define NUMAKER_MODULE_CLKDIV_Msk_ENC(x) (((x)&0x0fUL) << 10)
#define NUMAKER_MODULE_CLKDIV_Pos_ENC(x) (((x)&0x1fUL) << 5)
#define NUMAKER_MODULE_IP_EN_Pos_ENC(x)	 (((x)&0x1fUL) << 0)

/* AHBCLK0 */
#define NUMAKER_PDMA0_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_PDMA0CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_ISP_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_ISPCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_EBI_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_EBICKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_ST_MODULE                                                                          \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_STCKEN_Pos) |                            \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_EMAC0_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_EMAC0CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(3UL) |              \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(16UL))

#define NUMAKER_SDH0_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_SDH0CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(0UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(20UL) | NUMAKER_MODULE_CLKDIV_ENC(0UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(24UL))

#define NUMAKER_CRC_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_CRCCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_CCAP_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_CCAPCKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_SEN_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_SENCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(0UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(16UL) | NUMAKER_MODULE_CLKDIV_ENC(3UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(8UL))

#define NUMAKER_HSUSBD_MODULE                                                                      \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_HSUSBDCKEN_Pos) |                        \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_HBI_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_HBICKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_CRPT_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_CRPTCKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_KS_MODULE                                                                          \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_KSCKEN_Pos) |                            \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_SPIM_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_SPIMCKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_FMCIDLE_MODULE                                                                     \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_FMCIDLE_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_USBH_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_USBHCKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(0UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(1UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(8UL) | NUMAKER_MODULE_CLKDIV_ENC(0UL) |                     \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0xFUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(4UL))

#define NUMAKER_SDH1_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_SDH1CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(0UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(22UL) | NUMAKER_MODULE_CLKDIV_ENC(3UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(24UL))

#define NUMAKER_PDMA1_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_PDMA1CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_TRACE_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_TRACECKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_GPA_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_GPACKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_GPB_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_GPBCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_GPC_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_GPCCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_GPD_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_GPDCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_GPE_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_GPECKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_GPF_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_GPFCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_GPG_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_GPGCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_GPH_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(0UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK0_GPHCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

/* AHBCLK1 */
#define NUMAKER_CANFD0_MODULE                                                                      \
	(NUMAKER_MODULE_APBCLK_ENC(4UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK1_CANFD0CKEN_Pos) |                        \
	 NUMAKER_MODULE_CLKSEL_ENC(0UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(24UL) | NUMAKER_MODULE_CLKDIV_ENC(5UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(0UL))

#define NUMAKER_CANFD1_MODULE                                                                      \
	(NUMAKER_MODULE_APBCLK_ENC(4UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK1_CANFD1CKEN_Pos) |                        \
	 NUMAKER_MODULE_CLKSEL_ENC(0UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(26UL) | NUMAKER_MODULE_CLKDIV_ENC(5UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(4UL))

#define NUMAKER_CANFD2_MODULE                                                                      \
	(NUMAKER_MODULE_APBCLK_ENC(4UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK1_CANFD2CKEN_Pos) |                        \
	 NUMAKER_MODULE_CLKSEL_ENC(0UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(28UL) | NUMAKER_MODULE_CLKDIV_ENC(5UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(8UL))

#define NUMAKER_CANFD3_MODULE                                                                      \
	(NUMAKER_MODULE_APBCLK_ENC(4UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK1_CANFD3CKEN_Pos) |                        \
	 NUMAKER_MODULE_CLKSEL_ENC(0UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(30UL) | NUMAKER_MODULE_CLKDIV_ENC(5UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(12UL))

#define NUMAKER_GPI_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(4UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK1_GPICKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_GPJ_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(4UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK1_GPJCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_BMC_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(4UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_AHBCLK1_BMCCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

/* APBCLK0 */
#define NUMAKER_WDT_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_WDTCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(1UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(0UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |              \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_WWDT_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_WDTCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(1UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(30UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |             \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_RTC_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_RTCCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_TMR0_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_TMR0CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(1UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(8UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |              \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_TMR1_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_TMR1CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(1UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(12UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |             \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_TMR2_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_TMR2CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(1UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(16UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |             \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_TMR3_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_TMR3CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(1UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(20UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |             \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_CLKO_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_CLKOCKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(1UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(4UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |              \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_ACMP01_MODULE                                                                      \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_ACMP01CKEN_Pos) |                        \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_I2C0_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_I2C0CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_I2C1_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_I2C1CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_I2C2_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_I2C2CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_I2C3_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_I2C3CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_QSPI0_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_QSPI0CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(2UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(2UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |              \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_SPI0_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_SPI0CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(2UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(4UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |              \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_SPI1_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_SPI1CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(2UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(12UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |             \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_SPI2_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_SPI2CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(3UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(9UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |              \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_UART0_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_UART0CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(1UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(24UL) | NUMAKER_MODULE_CLKDIV_ENC(0UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(8UL))

#define NUMAKER_UART1_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_UART1CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(1UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(26UL) | NUMAKER_MODULE_CLKDIV_ENC(0UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(12UL))

#define NUMAKER_UART2_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_UART2CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(3UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(24UL) | NUMAKER_MODULE_CLKDIV_ENC(4UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(0UL))

#define NUMAKER_UART3_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_UART3CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(3UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(26UL) | NUMAKER_MODULE_CLKDIV_ENC(4UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(4UL))

#define NUMAKER_UART4_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_UART4CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(3UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(28UL) | NUMAKER_MODULE_CLKDIV_ENC(4UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(8UL))

#define NUMAKER_UART5_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_UART5CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(3UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(30UL) | NUMAKER_MODULE_CLKDIV_ENC(4UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(12UL))

#define NUMAKER_UART6_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_UART6CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(3UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(20UL) | NUMAKER_MODULE_CLKDIV_ENC(4UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(16UL))

#define NUMAKER_UART7_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_UART7CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(3UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(22UL) | NUMAKER_MODULE_CLKDIV_ENC(4UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(20UL))

#define NUMAKER_OTG_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_OTGCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(0UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(1UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(8UL) | NUMAKER_MODULE_CLKDIV_ENC(0UL) |                     \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0xFUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(4UL))

#define NUMAKER_USBD_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_USBDCKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(0UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(1UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(8UL) | NUMAKER_MODULE_CLKDIV_ENC(0UL) |                     \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0xFUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(4UL))

#define NUMAKER_EADC0_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_EADC0CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(0UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(10UL) | NUMAKER_MODULE_CLKDIV_ENC(0UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(16UL))

#define NUMAKER_I2S0_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_I2S0CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(3UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(16UL) | NUMAKER_MODULE_CLKDIV_ENC(2UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(0UL))

#define NUMAKER_HSOTG_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(1UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK0_HSOTGCKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

/* APBCLK1 */
#define NUMAKER_SC0_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_SC0CKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(3UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(0UL) | NUMAKER_MODULE_CLKDIV_ENC(1UL) |                     \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(0UL))

#define NUMAKER_SC1_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_SC1CKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(3UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(2UL) | NUMAKER_MODULE_CLKDIV_ENC(1UL) |                     \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(8UL))

#define NUMAKER_SC2_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_SC2CKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(3UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(4UL) | NUMAKER_MODULE_CLKDIV_ENC(1UL) |                     \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(16UL))

#define NUMAKER_I2C4_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_I2C4CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_QSPI1_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_QSPI1CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(2UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(10UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |             \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_SPI3_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_SPI3CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(3UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(12UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |             \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_SPI4_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_SPI4CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(4UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(0UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |              \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_USCI0_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_USCI0CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_PSIO_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_PSIOCKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(2UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(28UL) | NUMAKER_MODULE_CLKDIV_ENC(1UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(24UL))

#define NUMAKER_DAC_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_DACCKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_ECAP2_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_ECAP2CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_ECAP3_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_ECAP3CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_EPWM0_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_EPWM0CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(2UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(1UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(0UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |              \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_EPWM1_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_EPWM1CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(2UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(1UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(1UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |              \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_BPWM0_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_BPWM0CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(2UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(1UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(8UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |              \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_BPWM1_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_BPWM1CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(2UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(1UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(9UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |              \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_EQEI0_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_EQEI0CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_EQEI1_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_EQEI1CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_EQEI2_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_EQEI2CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_EQEI3_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_EQEI3CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_TRNG_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_TRNGCKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(2UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(1UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(27UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |             \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_ECAP0_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_ECAP0CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_ECAP1_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_ECAP1CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_I2S1_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_I2S1CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(2UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(16UL) | NUMAKER_MODULE_CLKDIV_ENC(2UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(4UL))

#define NUMAKER_EADC1_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(2UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK1_EADC1CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(0UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(12UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |             \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

/* APBCLK2 */
#define NUMAKER_KPI_MODULE                                                                         \
	(NUMAKER_MODULE_APBCLK_ENC(3UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK2_KPICKEN_Pos) |                           \
	 NUMAKER_MODULE_CLKSEL_ENC(3UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(6UL) | NUMAKER_MODULE_CLKDIV_ENC(2UL) |                     \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(8UL))

#define NUMAKER_EADC2_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(3UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK2_EADC2CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(0UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(14UL) | NUMAKER_MODULE_CLKDIV_ENC(2UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(24UL))

#define NUMAKER_ACMP23_MODULE                                                                      \
	(NUMAKER_MODULE_APBCLK_ENC(3UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK2_ACMP23CKEN_Pos) |                        \
	 NUMAKER_MODULE_CLKSEL_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKSEL_Msk_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |       \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_SPI5_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(3UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK2_SPI5CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(4UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(4UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |              \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_SPI6_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(3UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK2_SPI6CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(4UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(8UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |              \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_SPI7_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(3UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK2_SPI7CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(4UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(12UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |             \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_SPI8_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(3UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK2_SPI8CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(4UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(16UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |             \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_SPI9_MODULE                                                                        \
	(NUMAKER_MODULE_APBCLK_ENC(3UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK2_SPI9CKEN_Pos) |                          \
	 NUMAKER_MODULE_CLKSEL_ENC(4UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(20UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |             \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_SPI10_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(3UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK2_SPI10CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(4UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(7UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(24UL) | NUMAKER_MODULE_CLKDIV_ENC(NUMAKER_NA) |             \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(NUMAKER_NA) | NUMAKER_MODULE_CLKDIV_Pos_ENC(NUMAKER_NA))

#define NUMAKER_UART8_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(3UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK2_UART8CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(2UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(20UL) | NUMAKER_MODULE_CLKDIV_ENC(5UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(16UL))

#define NUMAKER_UART9_MODULE                                                                       \
	(NUMAKER_MODULE_APBCLK_ENC(3UL) |                                                          \
	 NUMAKER_MODULE_IP_EN_Pos_ENC(NUMAKER_CLK_APBCLK2_UART9CKEN_Pos) |                         \
	 NUMAKER_MODULE_CLKSEL_ENC(2UL) | NUMAKER_MODULE_CLKSEL_Msk_ENC(3UL) |                     \
	 NUMAKER_MODULE_CLKSEL_Pos_ENC(22UL) | NUMAKER_MODULE_CLKDIV_ENC(5UL) |                    \
	 NUMAKER_MODULE_CLKDIV_Msk_ENC(0x0FUL) | NUMAKER_MODULE_CLKDIV_Pos_ENC(20UL))

/* End of M460 BSP clk.h copy */

#define NUMAKER_CLK_PMUCTL_PDMSEL_PD 0x00000000
#define NUMAKER_CLK_PMUCTL_PDMSEL_LLPD 0x00000001
#define NUMAKER_CLK_PMUCTL_PDMSEL_FWPD 0x00000002
#define NUMAKER_CLK_PMUCTL_PDMSEL_SPD 0x00000004
#define NUMAKER_CLK_PMUCTL_PDMSEL_DPD 0x00000006

#endif
