/*
 * Copyright (c) 2020 Linaro Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_ATMEL_SAMX7X_DMA_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_ATMEL_SAMX7X_DMA_H_

/**
 * Atmel SAMx7x Peripheral Hardware Request HW Interface Number (XDMAC_CC.PERID).
 *
 * See table Table 35-1. Peripheral Hardware Requests in the SAM E70/S70/V70/V71 datasheet.
 */
#define DMA_PERID_HSMCI_TX_RX 0
#define DMA_PERID_SPI0_TX     1
#define DMA_PERID_SPI0_RX     2
#define DMA_PERID_SPI1_TX     3
#define DMA_PERID_SPI1_RX     4
#define DMA_PERID_QSPI_TX     5
#define DMA_PERID_QSPI_RX     6
#define DMA_PERID_USART0_TX   7
#define DMA_PERID_USART0_RX   8
#define DMA_PERID_USART1_TX   9
#define DMA_PERID_USART1_RX   10
#define DMA_PERID_USART2_TX   11
#define DMA_PERID_USART2_RX   12
#define DMA_PERID_PWM0_TX     13
#define DMA_PERID_TWIHS0_TX   14
#define DMA_PERID_TWIHS0_RX   15
#define DMA_PERID_TWIHS1_TX   16
#define DMA_PERID_TWIHS1_RX   17
#define DMA_PERID_TWIHS2_TX   18
#define DMA_PERID_TWIHS2_RX   19
#define DMA_PERID_UART0_TX    20
#define DMA_PERID_UART0_RX    21
#define DMA_PERID_UART1_TX    22
#define DMA_PERID_UART1_RX    23
#define DMA_PERID_UART2_TX    24
#define DMA_PERID_UART2_RX    25
#define DMA_PERID_UART3_TX    26
#define DMA_PERID_UART3_RX    27
#define DMA_PERID_UART4_TX    28
#define DMA_PERID_UART4_RX    29
#define DMA_PERID_DACC0_TX    30
#define DMA_PERID_DACC1_TX    31
#define DMA_PERID_SSC_TX      32
#define DMA_PERID_SSC_RX      33
#define DMA_PERID_PIOA_RX     34
#define DMA_PERID_AFEC0_RX    35
#define DMA_PERID_AFEC1_RX    36
#define DMA_PERID_AES_TX      37
#define DMA_PERID_AES_RX      38
#define DMA_PERID_PWM1_TX     39
#define DMA_PERID_TC0_RX      40
#define DMA_PERID_TC1_RX      41
#define DMA_PERID_TC2_RX      42
#define DMA_PERID_TC3_RX      43
#define DMA_PERID_I2SC0_TX_L  44
#define DMA_PERID_I2SC0_RX_L  45
#define DMA_PERID_I2SC1_TX_L  46
#define DMA_PERID_I2SC1_RX_L  47
#define DMA_PERID_I2SC0_TX_R  48
#define DMA_PERID_I2SC0_RX_R  49
#define DMA_PERID_I2SC1_TX_R  50
#define DMA_PERID_I2SC1_RX_R  51

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_ATMEL_SAMX7X_DMA_H_ */
