/*
 * Copyright (c) 2025 TOKITA Hiroshi
 *
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * @file
 * @brief Arduino Uno (R3) header pin constants
 * @ingroup arduino-header-r3
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_ARDUINO_HEADER_R3_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_ARDUINO_HEADER_R3_H_

/**
 * @defgroup arduino-header-r3 Arduino Uno (R3) header
 * @brief Constants for pins exposed on Arduino Uno (R3) header
 * @ingroup devicetree-gpio-pin-headers
 * @{
 */

#define ARDUINO_HEADER_R3_A0  0  /**< Analog pin 0 (A0) */
#define ARDUINO_HEADER_R3_A1  1  /**< Analog pin 1 (A1) */
#define ARDUINO_HEADER_R3_A2  2  /**< Analog pin 2 (A2) */
#define ARDUINO_HEADER_R3_A3  3  /**< Analog pin 3 (A3) */
#define ARDUINO_HEADER_R3_A4  4  /**< Analog pin 4 (A4) */
#define ARDUINO_HEADER_R3_A5  5  /**< Analog pin 5 (A5) */
#define ARDUINO_HEADER_R3_D0  6  /**< Digital pin 0 (D0) */
#define ARDUINO_HEADER_R3_D1  7  /**< Digital pin 1 (D1) */
#define ARDUINO_HEADER_R3_D2  8  /**< Digital pin 2 (D2) */
#define ARDUINO_HEADER_R3_D3  9  /**< Digital pin 3 (D3) */
#define ARDUINO_HEADER_R3_D4  10 /**< Digital pin 4 (D4) */
#define ARDUINO_HEADER_R3_D5  11 /**< Digital pin 5 (D5) */
#define ARDUINO_HEADER_R3_D6  12 /**< Digital pin 6 (D6) */
#define ARDUINO_HEADER_R3_D7  13 /**< Digital pin 7 (D7) */
#define ARDUINO_HEADER_R3_D8  14 /**< Digital pin 8 (D8) */
#define ARDUINO_HEADER_R3_D9  15 /**< Digital pin 9 (D9) */
#define ARDUINO_HEADER_R3_D10 16 /**< Digital pin 10 (D10) */
#define ARDUINO_HEADER_R3_D11 17 /**< Digital pin 11 (D11) */
#define ARDUINO_HEADER_R3_D12 18 /**< Digital pin 12 (D12) */
#define ARDUINO_HEADER_R3_D13 19 /**< Digital pin 13 (D13) */
#define ARDUINO_HEADER_R3_D14 20 /**< Digital pin 14 (D14) */
#define ARDUINO_HEADER_R3_D15 21 /**< Digital pin 15 (D15) */

/** @} */

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_ARDUINO_HEADER_R3_H_ */
