/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright (c) 2025 Linumiz GmbH
 * Author: Sri Surya  <srisurya@linumiz.com>
 */

#ifndef AMBIQ_APOLLO2_PINCTRL_H
#define AMBIQ_APOLLO2_PINCTRL_H

#define APOLLO2_ALT_FUNC_POS  0
#define APOLLO2_ALT_FUNC_MASK 0x7

#define APOLLO2_PIN_NUM_POS  3
#define APOLLO2_PIN_NUM_MASK 0x3f

#define APOLLO2_PINMUX(pin_num, alt_func)					\
	(((pin_num) << APOLLO2_PIN_NUM_POS) | ((alt_func) << APOLLO2_ALT_FUNC_POS))

#define SLSCL_P0        APOLLO2_PINMUX(0, 0)
#define SLSCK_P0        APOLLO2_PINMUX(0, 1)
#define CLKOUT_P0       APOLLO2_PINMUX(0, 2)
#define GPIO0_P0        APOLLO2_PINMUX(0, 3)
#define MXSCKLB_P0      APOLLO2_PINMUX(0, 4)
#define M2SCK_P0        APOLLO2_PINMUX(0, 5)
#define MXSCLLB_P0      APOLLO2_PINMUX(0, 6)
#define M2SCL_P0        APOLLO2_PINMUX(0, 7)

#define SLSDA_P1        APOLLO2_PINMUX(1, 0)
#define SLMISO_P1       APOLLO2_PINMUX(1, 1)
#define UART0TX_P1      APOLLO2_PINMUX(1, 2)
#define GPIO1_P1        APOLLO2_PINMUX(1, 3)
#define MXMISOLB_P1     APOLLO2_PINMUX(1, 4)
#define M2MISO_P1       APOLLO2_PINMUX(1, 5)
#define MXSDALB_P1      APOLLO2_PINMUX(1, 6)
#define M2SDA_P1        APOLLO2_PINMUX(1, 7)

#define SLWIR3_P2       APOLLO2_PINMUX(2, 0)
#define SLMOSI_P2       APOLLO2_PINMUX(2, 1)
#define UART0RX_P2      APOLLO2_PINMUX(2, 2)
#define GPIO2_P2        APOLLO2_PINMUX(2, 3)
#define MXMOSILB_P2     APOLLO2_PINMUX(2, 4)
#define M2MOSI_P2       APOLLO2_PINMUX(2, 5)
#define MXWIR3LB_P2     APOLLO2_PINMUX(2, 6)
#define M2WIR3_P2       APOLLO2_PINMUX(2, 7)

#define UART0RTS_P3     APOLLO2_PINMUX(3, 0)
#define SLNCE_P3        APOLLO2_PINMUX(3, 1)
#define M1NCE4_P3       APOLLO2_PINMUX(3, 2)
#define GPIO3_P3        APOLLO2_PINMUX(3, 3)
#define MXNCELB_P3      APOLLO2_PINMUX(3, 4)
#define M2NCE0_P3       APOLLO2_PINMUX(3, 5)
#define TRIG1_P3        APOLLO2_PINMUX(3, 6)
#define I2S_WCLK_P3     APOLLO2_PINMUX(3, 7)

#define UART0CTS_P4     APOLLO2_PINMUX(4, 0)
#define SLINT_P4        APOLLO2_PINMUX(4, 1)
#define M0NCE5_P4       APOLLO2_PINMUX(4, 2)
#define GPIO4_P4        APOLLO2_PINMUX(4, 3)
#define SLINTGP_P4      APOLLO2_PINMUX(4, 4)
#define M2NCE5_P4       APOLLO2_PINMUX(4, 5)
#define CLKOUT_P4       APOLLO2_PINMUX(4, 6)
#define _32KHZ_XT_P4    APOLLO2_PINMUX(4, 7)

#define M0SCL_P5        APOLLO2_PINMUX(5, 0)
#define M0SCK_P5        APOLLO2_PINMUX(5, 1)
#define UART0RTS_P5     APOLLO2_PINMUX(5, 2)
#define GPIO5_P5        APOLLO2_PINMUX(5, 3)
#define M0SCKLB_P5      APOLLO2_PINMUX(5, 4)
#define M0SCLLB_P5      APOLLO2_PINMUX(5, 6)
#define M1NCE2_P5       APOLLO2_PINMUX(5, 7)

#define M0SDA_P6        APOLLO2_PINMUX(6, 0)
#define M0MISO_P6       APOLLO2_PINMUX(6, 1)
#define UART0CTS_P6     APOLLO2_PINMUX(6, 2)
#define GPIO6_P6        APOLLO2_PINMUX(6, 3)
#define SLMISOLB_P6     APOLLO2_PINMUX(6, 4)
#define M1NCE0_P6       APOLLO2_PINMUX(6, 5)
#define SLSDALB_P6      APOLLO2_PINMUX(6, 6)
#define I2S_DAT_P6      APOLLO2_PINMUX(6, 7)

#define M0WIR3_P7       APOLLO2_PINMUX(7, 0)
#define M0MOSI_P7       APOLLO2_PINMUX(7, 1)
#define CLKOUT_P7       APOLLO2_PINMUX(7, 2)
#define GPIO7_P7        APOLLO2_PINMUX(7, 3)
#define TRIG0_P7        APOLLO2_PINMUX(7, 4)
#define UART0TX_P7      APOLLO2_PINMUX(7, 5)
#define SLWIR3LB_P7     APOLLO2_PINMUX(7, 6)
#define M1NCE1_P7       APOLLO2_PINMUX(7, 7)

#define M1SCL_P8        APOLLO2_PINMUX(8, 0)
#define M1SCK_P8        APOLLO2_PINMUX(8, 1)
#define M0NCE4_P8       APOLLO2_PINMUX(8, 2)
#define GPIO8_P8        APOLLO2_PINMUX(8, 3)
#define M2NCE4_P8       APOLLO2_PINMUX(8, 4)
#define M1SCKLB_P8      APOLLO2_PINMUX(8, 5)
#define UART1TX_P8      APOLLO2_PINMUX(8, 6)
#define M1SCLLB_P8      APOLLO2_PINMUX(8, 7)

#define M1SDA_P9        APOLLO2_PINMUX(9, 0)
#define M1MISO_P9       APOLLO2_PINMUX(9, 1)
#define M0NCE5_P9       APOLLO2_PINMUX(9, 2)
#define GPIO9_P9        APOLLO2_PINMUX(9, 3)
#define M4NCE5_P9       APOLLO2_PINMUX(9, 4)
#define SLMISOLB_P9     APOLLO2_PINMUX(9, 5)
#define UART1RX_P9      APOLLO2_PINMUX(9, 6)
#define SLSDALB_P9      APOLLO2_PINMUX(9, 7)

#define M1WIR3_P10      APOLLO2_PINMUX(10, 0)
#define M1MOSI_P10      APOLLO2_PINMUX(10, 1)
#define M0NCE6_P10      APOLLO2_PINMUX(10, 2)
#define GPIO10_P10      APOLLO2_PINMUX(10, 3)
#define M2NCE6_P10      APOLLO2_PINMUX(10, 4)
#define UART1RTS_P10    APOLLO2_PINMUX(10, 5)
#define M4NCE4_P10      APOLLO2_PINMUX(10, 6)
#define SLWIR3LB_P10    APOLLO2_PINMUX(10, 7)

#define ADCSE2_P11      APOLLO2_PINMUX(11, 0)
#define M0NCE0_P11      APOLLO2_PINMUX(11, 1)
#define CLKOUT_P11      APOLLO2_PINMUX(11, 2)
#define GPIO11_P11      APOLLO2_PINMUX(11, 3)
#define M2NCE7_P11      APOLLO2_PINMUX(11, 4)
#define UART1CTS_P11    APOLLO2_PINMUX(11, 5)
#define UART0RX_P11     APOLLO2_PINMUX(11, 6)
#define PDM_DATA_P11    APOLLO2_PINMUX(11, 7)

#define ADCD0NSE9_P12   APOLLO2_PINMUX(12, 0)
#define M1NCE0_P12      APOLLO2_PINMUX(12, 1)
#define TCTA0_P12       APOLLO2_PINMUX(12, 2)
#define GPIO12_P12      APOLLO2_PINMUX(12, 3)
#define CLKOUT_P12      APOLLO2_PINMUX(12, 4)
#define PDM_CLK_P12     APOLLO2_PINMUX(12, 5)
#define UART0CTS_P12    APOLLO2_PINMUX(12, 6)
#define UART1TX_P12     APOLLO2_PINMUX(12, 7)

#define ADCD0PSE8_P13   APOLLO2_PINMUX(13, 0)
#define M1NCE1_P13      APOLLO2_PINMUX(13, 1)
#define TCTB0_P13       APOLLO2_PINMUX(13, 2)
#define GPIO13_P13      APOLLO2_PINMUX(13, 3)
#define M2NCE3_P13      APOLLO2_PINMUX(13, 4)
#define UART0RTS_P13    APOLLO2_PINMUX(13, 6)
#define UART1RX_P13     APOLLO2_PINMUX(13, 7)

#define ADCD1P_P14      APOLLO2_PINMUX(14, 0)
#define M1NCE2_P14      APOLLO2_PINMUX(14, 1)
#define UART1TX_P14     APOLLO2_PINMUX(14, 2)
#define GPIO14_P14      APOLLO2_PINMUX(14, 3)
#define M2NCE1_P14      APOLLO2_PINMUX(14, 4)
#define SWDCK_P14       APOLLO2_PINMUX(14, 6)
#define _32KHZ_XT_P14   APOLLO2_PINMUX(14, 7)

#define ADCD1N_P15      APOLLO2_PINMUX(15, 0)
#define M1NCE3_P15      APOLLO2_PINMUX(15, 1)
#define UART1RX_P15     APOLLO2_PINMUX(15, 2)
#define GPIO15_P15      APOLLO2_PINMUX(15, 3)
#define M2NCE2_P15      APOLLO2_PINMUX(15, 4)
#define SWDIO_P15       APOLLO2_PINMUX(15, 6)
#define SWO_P15         APOLLO2_PINMUX(15, 7)

#define ADCSE0_P16      APOLLO2_PINMUX(16, 0)
#define M0NCE4_P16      APOLLO2_PINMUX(16, 1)
#define TRIG0_P16       APOLLO2_PINMUX(16, 2)
#define GPIO16_P16      APOLLO2_PINMUX(16, 3)
#define M2NCE3_P16      APOLLO2_PINMUX(16, 4)
#define CMPIN0_P16      APOLLO2_PINMUX(16, 5)
#define UART0TX_P16     APOLLO2_PINMUX(16, 6)
#define UART1RTS_P16    APOLLO2_PINMUX(16, 7)

#define CMPRF1_P17      APOLLO2_PINMUX(17, 0)
#define M0NCE1_P17      APOLLO2_PINMUX(17, 1)
#define TRIG1_P17       APOLLO2_PINMUX(17, 2)
#define GPIO17_P17      APOLLO2_PINMUX(17, 3)
#define M4NCE3_P17      APOLLO2_PINMUX(17, 4)
#define UART0RX_P17     APOLLO2_PINMUX(17, 6)
#define UART1CTS_P17    APOLLO2_PINMUX(17, 7)

#define CMPIN1_P18      APOLLO2_PINMUX(18, 0)
#define M0NCE2_P18      APOLLO2_PINMUX(18, 1)
#define TCTA1_P18       APOLLO2_PINMUX(18, 2)
#define GPIO18_P18      APOLLO2_PINMUX(18, 3)
#define M4NCE1_P18      APOLLO2_PINMUX(18, 4)
#define UART1TX_P18     APOLLO2_PINMUX(18, 6)
#define _32KHZ_XT_P18   APOLLO2_PINMUX(18, 7)

#define CMPRF0_P19      APOLLO2_PINMUX(19, 0)
#define M0NCE3_P19      APOLLO2_PINMUX(19, 1)
#define TCTB1_P19       APOLLO2_PINMUX(19, 2)
#define GPIO19_P19      APOLLO2_PINMUX(19, 3)
#define TCTA1_P19       APOLLO2_PINMUX(19, 4)
#define UART1RX_P19     APOLLO2_PINMUX(19, 6)
#define I2S_BCLK_P19    APOLLO2_PINMUX(19, 7)

#define SWDCK_P20       APOLLO2_PINMUX(20, 0)
#define M1NCE5_P20      APOLLO2_PINMUX(20, 1)
#define TCTA2_P20       APOLLO2_PINMUX(20, 2)
#define GPIO20_P20      APOLLO2_PINMUX(20, 3)
#define UART0TX_P20     APOLLO2_PINMUX(20, 4)
#define UART1TX_P20     APOLLO2_PINMUX(20, 5)

#define SWDIO_P21       APOLLO2_PINMUX(21, 0)
#define M1NCE6_P21      APOLLO2_PINMUX(21, 1)
#define TCTB2_P21       APOLLO2_PINMUX(21, 2)
#define GPIO21_P21      APOLLO2_PINMUX(21, 3)
#define UART0RX_P21     APOLLO2_PINMUX(21, 4)
#define UART1RX_P21     APOLLO2_PINMUX(21, 5)

#define UART0TX_P22     APOLLO2_PINMUX(22, 0)
#define M1NCE7_P22      APOLLO2_PINMUX(22, 1)
#define TCTA3_P22       APOLLO2_PINMUX(22, 2)
#define GPIO22_P22      APOLLO2_PINMUX(22, 3)
#define PDM_CLK_P22     APOLLO2_PINMUX(22, 4)
#define TCTB1_P22       APOLLO2_PINMUX(22, 6)
#define SWO_P22         APOLLO2_PINMUX(22, 7)

#define UART0RX_P23     APOLLO2_PINMUX(23, 0)
#define M0NCE0_P23      APOLLO2_PINMUX(23, 1)
#define TCTB3_P23       APOLLO2_PINMUX(23, 2)
#define GPIO23_P23      APOLLO2_PINMUX(23, 3)
#define PDM_DATA_P23    APOLLO2_PINMUX(23, 4)
#define CMPOUT_P23      APOLLO2_PINMUX(23, 5)
#define TCTB1_P23       APOLLO2_PINMUX(23, 6)

#define M2NCE1_P24      APOLLO2_PINMUX(24, 0)
#define M0NCE1_P24      APOLLO2_PINMUX(24, 1)
#define CLKOUT_P24      APOLLO2_PINMUX(24, 2)
#define GPIO24_P24      APOLLO2_PINMUX(24, 3)
#define M5NCE0_P24      APOLLO2_PINMUX(24, 4)
#define TCTA1_P24       APOLLO2_PINMUX(24, 5)
#define I2S_BCLK_P24    APOLLO2_PINMUX(24, 6)
#define SWO_P24         APOLLO2_PINMUX(24, 7)

#define M0NCE2_P25      APOLLO2_PINMUX(25, 1)
#define TCTA0_P25       APOLLO2_PINMUX(25, 2)
#define GPIO25_P25      APOLLO2_PINMUX(25, 3)
#define M2SDA_P25       APOLLO2_PINMUX(25, 4)
#define M2MISO_P25      APOLLO2_PINMUX(25, 5)
#define SLMISOLB_P25    APOLLO2_PINMUX(25, 6)
#define SLSDALB_P25     APOLLO2_PINMUX(25, 7)

#define M0NCE3_P26      APOLLO2_PINMUX(26, 1)
#define TCTB0_P26       APOLLO2_PINMUX(26, 2)
#define GPIO26_P26      APOLLO2_PINMUX(26, 3)
#define M2NCE0_P26      APOLLO2_PINMUX(26, 4)
#define TCTA1_P26       APOLLO2_PINMUX(26, 5)
#define M5NCE1_P26      APOLLO2_PINMUX(26, 6)
#define M3NCE0_P26      APOLLO2_PINMUX(26, 7)

#define M1NCE4_P27      APOLLO2_PINMUX(27, 1)
#define TCTA1_P27       APOLLO2_PINMUX(27, 2)
#define GPIO27_P27      APOLLO2_PINMUX(27, 3)
#define M2SCL_P27       APOLLO2_PINMUX(27, 4)
#define M2SCK_P27       APOLLO2_PINMUX(27, 5)
#define M2SCKLB_P27     APOLLO2_PINMUX(27, 6)
#define M2SCLLB_P27     APOLLO2_PINMUX(27, 7)

#define I2S_WCLK_P28    APOLLO2_PINMUX(28, 0)
#define M1NCE5_P28      APOLLO2_PINMUX(28, 1)
#define TCTB1_P28       APOLLO2_PINMUX(28, 2)
#define GPIO28_P28      APOLLO2_PINMUX(28, 3)
#define M2WIR3_P28      APOLLO2_PINMUX(28, 4)
#define M2MOSI_P28      APOLLO2_PINMUX(28, 5)
#define M5NCE3_P28      APOLLO2_PINMUX(28, 6)
#define SLWIR3LB_P28    APOLLO2_PINMUX(28, 7)

#define ADCSE1_P29      APOLLO2_PINMUX(29, 0)
#define M1NCE6_P29      APOLLO2_PINMUX(29, 1)
#define TCTA2_P29       APOLLO2_PINMUX(29, 2)
#define GPIO29_P29      APOLLO2_PINMUX(29, 3)
#define UART0CTS_P29    APOLLO2_PINMUX(29, 4)
#define UART1CTS_P29    APOLLO2_PINMUX(29, 5)
#define M4NCE0_P29      APOLLO2_PINMUX(29, 6)
#define PDM_DATA_P29    APOLLO2_PINMUX(29, 7)

#define M1NCE7_P30      APOLLO2_PINMUX(30, 1)
#define TCTB2_P30       APOLLO2_PINMUX(30, 2)
#define GPIO30_P30      APOLLO2_PINMUX(30, 3)
#define UART0TX_P30     APOLLO2_PINMUX(30, 4)
#define UART1RTS_P30    APOLLO2_PINMUX(30, 5)
#define I2S_DAT_P30     APOLLO2_PINMUX(30, 7)

#define ADCSE3_P31      APOLLO2_PINMUX(31, 0)
#define M0NCE4_P31      APOLLO2_PINMUX(31, 1)
#define TCTA3_P31       APOLLO2_PINMUX(31, 2)
#define GPIO31_P31      APOLLO2_PINMUX(31, 3)
#define UART0RX_P31     APOLLO2_PINMUX(31, 4)
#define TCTB1_P31       APOLLO2_PINMUX(31, 5)

#define ADCSE4_P32      APOLLO2_PINMUX(32, 0)
#define M0NCE5_P32      APOLLO2_PINMUX(32, 1)
#define TCTB3_P32       APOLLO2_PINMUX(32, 2)
#define GPIO32_P32      APOLLO2_PINMUX(32, 3)
#define TCTB1_P32       APOLLO2_PINMUX(32, 5)

#define ADCSE5_P33      APOLLO2_PINMUX(33, 0)
#define M0NCE6_P33      APOLLO2_PINMUX(33, 1)
#define _32KHZ_XT_P33   APOLLO2_PINMUX(33, 2)
#define GPIO33_P33      APOLLO2_PINMUX(33, 3)
#define M3NCE7_P33      APOLLO2_PINMUX(33, 5)
#define TCTB1_P33       APOLLO2_PINMUX(33, 6)
#define SWO_P33         APOLLO2_PINMUX(33, 7)

#define ADCSE6_P34      APOLLO2_PINMUX(34, 0)
#define M0NCE7_P34      APOLLO2_PINMUX(34, 1)
#define M2NCE3_P34      APOLLO2_PINMUX(34, 2)
#define GPIO34_P34      APOLLO2_PINMUX(34, 3)
#define CMPRF2_P34      APOLLO2_PINMUX(34, 4)
#define M3NCE1_P34      APOLLO2_PINMUX(34, 5)
#define M4NCE0_P34      APOLLO2_PINMUX(34, 6)
#define M5NCE2_P34      APOLLO2_PINMUX(34, 7)

#define ADCSE7_P35      APOLLO2_PINMUX(35, 0)
#define M1NCE0_P35      APOLLO2_PINMUX(35, 1)
#define UART1TX_P35     APOLLO2_PINMUX(35, 2)
#define GPIO35_P35      APOLLO2_PINMUX(35, 3)
#define M4NCE6_P35      APOLLO2_PINMUX(35, 4)
#define TCTA1_P35       APOLLO2_PINMUX(35, 5)
#define UART0RTS_P35    APOLLO2_PINMUX(35, 6)
#define M3NCE2_P35      APOLLO2_PINMUX(35, 7)

#define TRIG1_P36       APOLLO2_PINMUX(36, 0)
#define M1NCE1_P36      APOLLO2_PINMUX(36, 1)
#define UART1RX_P36     APOLLO2_PINMUX(36, 2)
#define GPIO36_P36      APOLLO2_PINMUX(36, 3)
#define _32KHZ_XT_P36   APOLLO2_PINMUX(36, 4)
#define M2NCE0_P36      APOLLO2_PINMUX(36, 5)
#define UART0CTS_P36    APOLLO2_PINMUX(36, 6)
#define M3NCE3_P36      APOLLO2_PINMUX(36, 7)

#define TRIG2_P37       APOLLO2_PINMUX(37, 0)
#define M1NCE2_P37      APOLLO2_PINMUX(37, 1)
#define UART0RTS_P37    APOLLO2_PINMUX(37, 2)
#define GPIO37_P37      APOLLO2_PINMUX(37, 3)
#define M3NCE4_P37      APOLLO2_PINMUX(37, 4)
#define M4NCE1_P37      APOLLO2_PINMUX(37, 5)
#define PDM_CLK_P37     APOLLO2_PINMUX(37, 6)
#define TCTA1_P37       APOLLO2_PINMUX(37, 7)

#define TRIG3_P38       APOLLO2_PINMUX(38, 0)
#define M1NCE3_P38      APOLLO2_PINMUX(38, 1)
#define UART0CTS_P38    APOLLO2_PINMUX(38, 2)
#define GPIO38_P38      APOLLO2_PINMUX(38, 3)
#define M3WIR3_P38      APOLLO2_PINMUX(38, 4)
#define M3MOSI_P38      APOLLO2_PINMUX(38, 5)
#define M4NCE7_P38      APOLLO2_PINMUX(38, 6)
#define SLWIR3LB_P38    APOLLO2_PINMUX(38, 7)

#define UART0TX_P39     APOLLO2_PINMUX(39, 0)
#define UART1TX_P39     APOLLO2_PINMUX(39, 1)
#define CLKOUT_P39      APOLLO2_PINMUX(39, 2)
#define GPIO39_P39      APOLLO2_PINMUX(39, 3)
#define M4SCL_P39       APOLLO2_PINMUX(39, 4)
#define M4SCK_P39       APOLLO2_PINMUX(39, 5)
#define M4SCKLB_P39     APOLLO2_PINMUX(39, 6)
#define M4SCLLB_P39     APOLLO2_PINMUX(39, 7)

#define UART0RX_P40     APOLLO2_PINMUX(40, 0)
#define UART1RX_P40     APOLLO2_PINMUX(40, 1)
#define TRIG0_P40       APOLLO2_PINMUX(40, 2)
#define GPIO40_P40      APOLLO2_PINMUX(40, 3)
#define M4SDA_P40       APOLLO2_PINMUX(40, 4)
#define M4MISO_P40      APOLLO2_PINMUX(40, 5)
#define SLMISOLB_P40    APOLLO2_PINMUX(40, 6)
#define SLSDALB_P40     APOLLO2_PINMUX(40, 7)

#define M2NCE1_P41      APOLLO2_PINMUX(41, 0)
#define CLKOUT_P41      APOLLO2_PINMUX(41, 1)
#define SWO_P41         APOLLO2_PINMUX(41, 2)
#define GPIO41_P41      APOLLO2_PINMUX(41, 3)
#define M3NCE5_P41      APOLLO2_PINMUX(41, 4)
#define M5NCE7_P41      APOLLO2_PINMUX(41, 5)
#define M4NCE2_P41      APOLLO2_PINMUX(41, 6)
#define UART0RTS_P41    APOLLO2_PINMUX(41, 7)

#define M2NCE2_P42      APOLLO2_PINMUX(42, 0)
#define M0NCE0_P42      APOLLO2_PINMUX(42, 1)
#define TCTA0_P42       APOLLO2_PINMUX(42, 2)
#define GPIO42_P42      APOLLO2_PINMUX(42, 3)
#define M3SCL_P42       APOLLO2_PINMUX(42, 4)
#define M3SCK_P42       APOLLO2_PINMUX(42, 5)
#define M3SCKLB_P42     APOLLO2_PINMUX(42, 6)
#define M3SCLLB_P42     APOLLO2_PINMUX(42, 7)

#define M2NCE4_P43      APOLLO2_PINMUX(43, 0)
#define M0NCE1_P43      APOLLO2_PINMUX(43, 1)
#define TCTB0_P43       APOLLO2_PINMUX(43, 2)
#define GPIO43_P43      APOLLO2_PINMUX(43, 3)
#define M3SDA_P43       APOLLO2_PINMUX(43, 4)
#define M3MISO_P43      APOLLO2_PINMUX(43, 5)
#define SLMISOLB_P43    APOLLO2_PINMUX(43, 6)
#define SLSDALB_P43     APOLLO2_PINMUX(43, 7)

#define UART1RTS_P44    APOLLO2_PINMUX(44, 0)
#define M0NCE2_P44      APOLLO2_PINMUX(44, 1)
#define TCTA1_P44       APOLLO2_PINMUX(44, 2)
#define GPIO44_P44      APOLLO2_PINMUX(44, 3)
#define M4WIR3_P44      APOLLO2_PINMUX(44, 4)
#define M4MOSI_P44      APOLLO2_PINMUX(44, 5)
#define M5NCE6_P44      APOLLO2_PINMUX(44, 6)
#define SLWIR3LB_P44    APOLLO2_PINMUX(44, 7)

#define UART1CTS_P45    APOLLO2_PINMUX(45, 0)
#define M0NCE3_P45      APOLLO2_PINMUX(45, 1)
#define TCTB1_P45       APOLLO2_PINMUX(45, 2)
#define GPIO45_P45      APOLLO2_PINMUX(45, 3)
#define M4NCE3_P45      APOLLO2_PINMUX(45, 4)
#define M3NCE6_P45      APOLLO2_PINMUX(45, 5)
#define M5NCE5_P45      APOLLO2_PINMUX(45, 6)
#define SWO_P45         APOLLO2_PINMUX(45, 7)

#define _32KHZ_XT_P46   APOLLO2_PINMUX(46, 0)
#define M0NCE4_P46      APOLLO2_PINMUX(46, 1)
#define TCTA2_P46       APOLLO2_PINMUX(46, 2)
#define GPIO46_P46      APOLLO2_PINMUX(46, 3)
#define TCTA1_P46       APOLLO2_PINMUX(46, 4)
#define M5NCE4_P46      APOLLO2_PINMUX(46, 5)
#define M4NCE4_P46      APOLLO2_PINMUX(46, 6)
#define SWO_P46         APOLLO2_PINMUX(46, 7)

#define M2NCE5_P47      APOLLO2_PINMUX(47, 0)
#define M0NCE5_P47      APOLLO2_PINMUX(47, 1)
#define TCTB2_P47       APOLLO2_PINMUX(47, 2)
#define GPIO47_P47      APOLLO2_PINMUX(47, 3)
#define M5WIR3_P47      APOLLO2_PINMUX(47, 4)
#define M5MOSI_P47      APOLLO2_PINMUX(47, 5)
#define M4NCE5_P47      APOLLO2_PINMUX(47, 6)
#define SLWIR3LB_P47    APOLLO2_PINMUX(47, 7)

#define M2NCE6_P48      APOLLO2_PINMUX(48, 0)
#define M0NCE6_P48      APOLLO2_PINMUX(48, 1)
#define TCTA3_P48       APOLLO2_PINMUX(48, 2)
#define GPIO48_P48      APOLLO2_PINMUX(48, 3)
#define M5SCL_P48       APOLLO2_PINMUX(48, 4)
#define M5SCK_P48       APOLLO2_PINMUX(48, 5)
#define M5SCKLB_P48     APOLLO2_PINMUX(48, 6)
#define M5SCLLB_P48     APOLLO2_PINMUX(48, 7)

#define M2NCE7_P49      APOLLO2_PINMUX(49, 0)
#define M0NCE7_P49      APOLLO2_PINMUX(49, 1)
#define TCTB3_P49       APOLLO2_PINMUX(49, 2)
#define GPIO49_P49      APOLLO2_PINMUX(49, 3)
#define M5SDA_P49       APOLLO2_PINMUX(49, 4)
#define M5MISO_P49      APOLLO2_PINMUX(49, 5)
#define SLMISOLB_P49    APOLLO2_PINMUX(49, 6)
#define SLSDALB_P49     APOLLO2_PINMUX(49, 7)

#endif /* AMBIQ_APOLLO2_PINCTRL_H*/
