/*
 * Copyright 2025 Arm Limited and/or its affiliates <open-source-office@arm.com>
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#define V2M_BEETLE_ALT_FUNC_POS 0
#define V2M_BEETLE_ALT_FUNC_MASK 0x7

#define V2M_BEETLE_EXP_NUM_POS 3
#define V2M_BEETLE_EXP_NUM_MASK 0x1F8

#define V2M_BEETLE_PINCTRL_FUNC_UART 0
#define V2M_BEETLE_PINCTRL_FUNC_GPIO 1
#define V2M_BEETLE_PINCTRL_FUNC_I2C 2
#define V2M_BEETLE_PINCTRL_FUNC_SPI 3
#define V2M_BEETLE_PINCTRL_FUNC_QSPI 4

#define V2M_BEETLE_PINMUX(alt_func, exp_num) (exp_num << V2M_BEETLE_EXP_NUM_POS | \
	alt_func << V2M_BEETLE_ALT_FUNC_POS)



/* GPIO 0 */
#define UART0_RXD_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_UART, 0)
#define UART0_TXD_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_UART, 1)
#define SPI0_SS_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_SPI, 10)
#define SPI0_MOSI_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_SPI, 11)
#define SPI0_MISO_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_SPI, 12)
#define SPI0_SCK_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_SPI, 13)
#define SBCON0_SDA_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_I2C, 14)
#define SBCON0_SCL_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_I2C, 15)

/* GPIO 1 */
#define UART1_RXD_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_UART, 16)
#define UART1_TXD_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_UART, 17)
#define SPI1_SS_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_SPI, 18)
#define SPI1_MOSI_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_SPI, 19)
#define SPI1_MISO_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_SPI, 20)
#define SPI1_SCK_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_SPI, 21)
#define SBCON1_SDA_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_I2C, 22)
#define SBCON1_SCL_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_I2C, 23)
#define QSPI_CS2_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_QSPI, 24)
#define QSPI_CS1_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_QSPI, 25)
#define QSPI_IOF0_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_QSPI, 26)
#define QSPI_IOF1_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_QSPI, 27)
#define QSPI_IOF2_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_QSPI, 28)
#define QSPI_IOF3_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_QSPI, 29)
#define QSPI_SCK_EXP V2M_BEETLE_PINMUX(V2M_BEETLE_PINCTRL_FUNC_QSPI, 30)
