/*
 * Copyright (c) 2025 Michael Hope <michaelh@juju.nz>
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef __CH32V00X_PINCTRL_H__
#define __CH32V00X_PINCTRL_H__

#define CH32V00X_PINMUX_PORT_PA 0
#define CH32V00X_PINMUX_PORT_PB 1
#define CH32V00X_PINMUX_PORT_PC 2
#define CH32V00X_PINMUX_PORT_PD 3

/* Starting bit for the remap field in PCFR1 */
#define CH32V00X_PINMUX_SPI1_RM         0
#define CH32V00X_PINMUX_I2C1_RM         3
#define CH32V00X_PINMUX_USART1_RM       6
#define CH32V00X_PINMUX_TIM1_RM         10
#define CH32V00X_PINMUX_TIM2_RM         14
#define CH32V00X_PINMUX_PA1PA2_RM       17
#define CH32V00X_PINMUX_ADC_DTR_GINJ_RM 18
#define CH32V00X_PINMUX_ADC_DTR_GREG_RM 19
#define CH32V00X_PINMUX_USART2_RM       20

/* Port number with 0-3 */
#define CH32V00X_PINCTRL_PORT_SHIFT 0
#define CH32V00X_PINCTRL_PORT_MASK  GENMASK(1, 0)
/* Pin number 0-7 */
#define CH32V00X_PINCTRL_PIN_SHIFT  2
#define CH32V00X_PINCTRL_PIN_MASK   GENMASK(4, 2)
/* Base remap bit 0-31 */
#define CH32V00X_PINCTRL_BASE_SHIFT 5
#define CH32V00X_PINCTRL_BASE_MASK  GENMASK(9, 5)
/* Function remapping ID 0-7 */
#define CH32V00X_PINCTRL_RM_SHIFT   10
#define CH32V00X_PINCTRL_RM_MASK    GENMASK(12, 10)

#define CH32V00X_PINMUX_DEFINE(port, pin, rm, remapping)                                           \
	((CH32V00X_PINMUX_PORT_##port << CH32V00X_PINCTRL_PORT_SHIFT) |                            \
	 (pin << CH32V00X_PINCTRL_PIN_SHIFT) |                                                     \
	 (CH32V00X_PINMUX_##rm##_RM << CH32V00X_PINCTRL_BASE_SHIFT) |                              \
	 (remapping << CH32V00X_PINCTRL_RM_SHIFT))

#define TIM1_ETR_PC5_0  CH32V00X_PINMUX_DEFINE(PC, 5, TIM1, 0)
#define TIM1_ETR_PD4_1  CH32V00X_PINMUX_DEFINE(PD, 4, TIM1, 1)
#define TIM1_ETR_PC5_2  CH32V00X_PINMUX_DEFINE(PC, 5, TIM1, 2)
#define TIM1_ETR_PC2_3  CH32V00X_PINMUX_DEFINE(PC, 2, TIM1, 3)
#define TIM1_ETR_PD4_4  CH32V00X_PINMUX_DEFINE(PD, 4, TIM1, 4)
#define TIM1_ETR_PD4_5  CH32V00X_PINMUX_DEFINE(PD, 4, TIM1, 5)
#define TIM1_ETR_PD4_6  CH32V00X_PINMUX_DEFINE(PD, 4, TIM1, 6)
#define TIM1_ETR_PB4_7  CH32V00X_PINMUX_DEFINE(PB, 4, TIM1, 7)
#define TIM1_ETR_PB4_8  CH32V00X_PINMUX_DEFINE(PB, 4, TIM1, 8)
#define TIM1_ETR_PB4_9  CH32V00X_PINMUX_DEFINE(PB, 4, TIM1, 9)
#define TIM1_CH1_PD2_0  CH32V00X_PINMUX_DEFINE(PD, 2, TIM1, 0)
#define TIM1_CH1_PD2_1  CH32V00X_PINMUX_DEFINE(PD, 2, TIM1, 1)
#define TIM1_CH1_PC6_2  CH32V00X_PINMUX_DEFINE(PC, 6, TIM1, 2)
#define TIM1_CH1_PC4_3  CH32V00X_PINMUX_DEFINE(PC, 4, TIM1, 3)
#define TIM1_CH1_PA3_4  CH32V00X_PINMUX_DEFINE(PA, 3, TIM1, 4)
#define TIM1_CH1_PA3_5  CH32V00X_PINMUX_DEFINE(PA, 3, TIM1, 5)
#define TIM1_CH1_PA3_6  CH32V00X_PINMUX_DEFINE(PA, 3, TIM1, 6)
#define TIM1_CH1_PC4_7  CH32V00X_PINMUX_DEFINE(PC, 4, TIM1, 7)
#define TIM1_CH1_PC4_8  CH32V00X_PINMUX_DEFINE(PC, 4, TIM1, 8)
#define TIM1_CH1_PA0_9  CH32V00X_PINMUX_DEFINE(PA, 0, TIM1, 9)
#define TIM1_CH2_PA1_0  CH32V00X_PINMUX_DEFINE(PA, 1, TIM1, 0)
#define TIM1_CH2_PA1_1  CH32V00X_PINMUX_DEFINE(PA, 1, TIM1, 1)
#define TIM1_CH2_PC7_2  CH32V00X_PINMUX_DEFINE(PC, 7, TIM1, 2)
#define TIM1_CH2_PC7_3  CH32V00X_PINMUX_DEFINE(PC, 7, TIM1, 3)
#define TIM1_CH2_PB0_4  CH32V00X_PINMUX_DEFINE(PB, 0, TIM1, 4)
#define TIM1_CH2_PB0_5  CH32V00X_PINMUX_DEFINE(PB, 0, TIM1, 5)
#define TIM1_CH2_PB0_6  CH32V00X_PINMUX_DEFINE(PB, 0, TIM1, 6)
#define TIM1_CH2_PC5_7  CH32V00X_PINMUX_DEFINE(PC, 5, TIM1, 7)
#define TIM1_CH2_PC5_8  CH32V00X_PINMUX_DEFINE(PC, 5, TIM1, 8)
#define TIM1_CH2_PA1_9  CH32V00X_PINMUX_DEFINE(PA, 1, TIM1, 9)
#define TIM1_CH3_PC3_0  CH32V00X_PINMUX_DEFINE(PC, 3, TIM1, 0)
#define TIM1_CH3_PC3_1  CH32V00X_PINMUX_DEFINE(PC, 3, TIM1, 1)
#define TIM1_CH3_PC0_2  CH32V00X_PINMUX_DEFINE(PC, 0, TIM1, 2)
#define TIM1_CH3_PC5_3  CH32V00X_PINMUX_DEFINE(PC, 5, TIM1, 3)
#define TIM1_CH3_PB1_4  CH32V00X_PINMUX_DEFINE(PB, 1, TIM1, 4)
#define TIM1_CH3_PC3_5  CH32V00X_PINMUX_DEFINE(PC, 3, TIM1, 5)
#define TIM1_CH3_PB1_6  CH32V00X_PINMUX_DEFINE(PB, 1, TIM1, 6)
#define TIM1_CH3_PC6_7  CH32V00X_PINMUX_DEFINE(PC, 6, TIM1, 7)
#define TIM1_CH3_PC6_8  CH32V00X_PINMUX_DEFINE(PC, 6, TIM1, 8)
#define TIM1_CH3_PA2_9  CH32V00X_PINMUX_DEFINE(PA, 2, TIM1, 9)
#define TIM1_CH4_PC4_0  CH32V00X_PINMUX_DEFINE(PC, 4, TIM1, 0)
#define TIM1_CH4_PC4_1  CH32V00X_PINMUX_DEFINE(PC, 4, TIM1, 1)
#define TIM1_CH4_PD3_2  CH32V00X_PINMUX_DEFINE(PD, 3, TIM1, 2)
#define TIM1_CH4_PD4_3  CH32V00X_PINMUX_DEFINE(PD, 4, TIM1, 3)
#define TIM1_CH4_PD1_4  CH32V00X_PINMUX_DEFINE(PD, 1, TIM1, 4)
#define TIM1_CH4_PD1_5  CH32V00X_PINMUX_DEFINE(PD, 1, TIM1, 5)
#define TIM1_CH4_PB2_6  CH32V00X_PINMUX_DEFINE(PB, 2, TIM1, 6)
#define TIM1_CH4_PC7_7  CH32V00X_PINMUX_DEFINE(PC, 7, TIM1, 7)
#define TIM1_CH4_PC7_8  CH32V00X_PINMUX_DEFINE(PC, 7, TIM1, 8)
#define TIM1_CH4_PA3_9  CH32V00X_PINMUX_DEFINE(PA, 3, TIM1, 9)
#define TIM1_BKIN_PC2_0 CH32V00X_PINMUX_DEFINE(PC, 2, TIM1, 0)
#define TIM1_BKIN_PC2_1 CH32V00X_PINMUX_DEFINE(PC, 2, TIM1, 1)
#define TIM1_BKIN_PC1_2 CH32V00X_PINMUX_DEFINE(PC, 1, TIM1, 2)
#define TIM1_BKIN_PC1_3 CH32V00X_PINMUX_DEFINE(PC, 1, TIM1, 3)
#define TIM1_BKIN_PB3_4 CH32V00X_PINMUX_DEFINE(PB, 3, TIM1, 4)
#define TIM1_BKIN_PB3_5 CH32V00X_PINMUX_DEFINE(PB, 3, TIM1, 5)
#define TIM1_BKIN_PA7_6 CH32V00X_PINMUX_DEFINE(PA, 7, TIM1, 6)
#define TIM1_BKIN_PB2_7 CH32V00X_PINMUX_DEFINE(PB, 2, TIM1, 7)
#define TIM1_BKIN_PB2_8 CH32V00X_PINMUX_DEFINE(PB, 2, TIM1, 8)
#define TIM1_BKIN_PB2_9 CH32V00X_PINMUX_DEFINE(PB, 2, TIM1, 9)
#define TIM1_CH1N_PD0_0 CH32V00X_PINMUX_DEFINE(PD, 0, TIM1, 0)
#define TIM1_CH1N_PD0_1 CH32V00X_PINMUX_DEFINE(PD, 0, TIM1, 1)
#define TIM1_CH1N_PC3_2 CH32V00X_PINMUX_DEFINE(PC, 3, TIM1, 2)
#define TIM1_CH1N_PC3_3 CH32V00X_PINMUX_DEFINE(PC, 3, TIM1, 3)
#define TIM1_CH1N_PA0_4 CH32V00X_PINMUX_DEFINE(PA, 0, TIM1, 4)
#define TIM1_CH1N_PA0_5 CH32V00X_PINMUX_DEFINE(PA, 0, TIM1, 5)
#define TIM1_CH1N_PA0_6 CH32V00X_PINMUX_DEFINE(PA, 0, TIM1, 6)
#define TIM1_CH1N_PC0_7 CH32V00X_PINMUX_DEFINE(PC, 0, TIM1, 7)
#define TIM1_CH1N_PA3_8 CH32V00X_PINMUX_DEFINE(PA, 3, TIM1, 8)
#define TIM1_CH1N_PC0_9 CH32V00X_PINMUX_DEFINE(PC, 0, TIM1, 9)
#define TIM1_CH2N_PA2_0 CH32V00X_PINMUX_DEFINE(PA, 2, TIM1, 0)
#define TIM1_CH2N_PA2_1 CH32V00X_PINMUX_DEFINE(PA, 2, TIM1, 1)
#define TIM1_CH2N_PC4_2 CH32V00X_PINMUX_DEFINE(PC, 4, TIM1, 2)
#define TIM1_CH2N_PD2_3 CH32V00X_PINMUX_DEFINE(PD, 2, TIM1, 3)
#define TIM1_CH2N_PA2_4 CH32V00X_PINMUX_DEFINE(PA, 2, TIM1, 4)
#define TIM1_CH2N_PA2_5 CH32V00X_PINMUX_DEFINE(PA, 2, TIM1, 5)
#define TIM1_CH2N_PA2_6 CH32V00X_PINMUX_DEFINE(PA, 2, TIM1, 6)
#define TIM1_CH2N_PC1_7 CH32V00X_PINMUX_DEFINE(PC, 1, TIM1, 7)
#define TIM1_CH2N_PB0_8 CH32V00X_PINMUX_DEFINE(PB, 0, TIM1, 8)
#define TIM1_CH2N_PC1_9 CH32V00X_PINMUX_DEFINE(PC, 1, TIM1, 9)
#define TIM1_CH3N_PD1_0 CH32V00X_PINMUX_DEFINE(PD, 1, TIM1, 0)
#define TIM1_CH3N_PD1_1 CH32V00X_PINMUX_DEFINE(PD, 1, TIM1, 1)
#define TIM1_CH3N_PD1_2 CH32V00X_PINMUX_DEFINE(PD, 1, TIM1, 2)
#define TIM1_CH3N_PC6_3 CH32V00X_PINMUX_DEFINE(PC, 6, TIM1, 3)
#define TIM1_CH3N_PD0_4 CH32V00X_PINMUX_DEFINE(PD, 0, TIM1, 4)
#define TIM1_CH3N_PD0_5 CH32V00X_PINMUX_DEFINE(PD, 0, TIM1, 5)
#define TIM1_CH3N_PD0_6 CH32V00X_PINMUX_DEFINE(PD, 0, TIM1, 6)
#define TIM1_CH3N_PC2_7 CH32V00X_PINMUX_DEFINE(PC, 2, TIM1, 7)
#define TIM1_CH3N_PB1_8 CH32V00X_PINMUX_DEFINE(PB, 1, TIM1, 8)
#define TIM1_CH3N_PC2_9 CH32V00X_PINMUX_DEFINE(PC, 2, TIM1, 9)

#define TIM2_ETR_PD4_0 CH32V00X_PINMUX_DEFINE(PD, 4, TIM2, 0)
#define TIM2_ETR_PC1_1 CH32V00X_PINMUX_DEFINE(PC, 1, TIM2, 1)
#define TIM2_ETR_PC5_2 CH32V00X_PINMUX_DEFINE(PC, 5, TIM2, 2)
#define TIM2_ETR_PC1_3 CH32V00X_PINMUX_DEFINE(PC, 1, TIM2, 3)
#define TIM2_ETR_PC0_4 CH32V00X_PINMUX_DEFINE(PC, 0, TIM2, 4)
#define TIM2_ETR_PA0_5 CH32V00X_PINMUX_DEFINE(PA, 0, TIM2, 5)
#define TIM2_ETR_PB1_6 CH32V00X_PINMUX_DEFINE(PB, 1, TIM2, 6)
#define TIM2_ETR_PD3_7 CH32V00X_PINMUX_DEFINE(PD, 3, TIM2, 7)
#define TIM2_CH1_PD4_0 CH32V00X_PINMUX_DEFINE(PD, 4, TIM2, 0)
#define TIM2_CH1_PC1_1 CH32V00X_PINMUX_DEFINE(PC, 1, TIM2, 1)
#define TIM2_CH1_PC5_2 CH32V00X_PINMUX_DEFINE(PC, 5, TIM2, 2)
#define TIM2_CH1_PC1_3 CH32V00X_PINMUX_DEFINE(PC, 1, TIM2, 3)
#define TIM2_CH1_PC0_4 CH32V00X_PINMUX_DEFINE(PC, 0, TIM2, 4)
#define TIM2_CH1_PA0_5 CH32V00X_PINMUX_DEFINE(PA, 0, TIM2, 5)
#define TIM2_CH1_PB1_6 CH32V00X_PINMUX_DEFINE(PB, 1, TIM2, 6)
#define TIM2_CH1_PD3_7 CH32V00X_PINMUX_DEFINE(PD, 3, TIM2, 7)
#define TIM2_CH2_PD3_0 CH32V00X_PINMUX_DEFINE(PD, 3, TIM2, 0)
#define TIM2_CH2_PD3_1 CH32V00X_PINMUX_DEFINE(PD, 3, TIM2, 1)
#define TIM2_CH2_PC2_2 CH32V00X_PINMUX_DEFINE(PC, 2, TIM2, 2)
/* CH32V007 specific remap */
#define TIM2_CH2_PB3_2 CH32V00X_PINMUX_DEFINE(PB, 3, TIM2, 2)
#define TIM2_CH2_PC7_3 CH32V00X_PINMUX_DEFINE(PC, 7, TIM2, 3)
#define TIM2_CH2_PC1_4 CH32V00X_PINMUX_DEFINE(PC, 1, TIM2, 4)
#define TIM2_CH2_PA1_5 CH32V00X_PINMUX_DEFINE(PA, 1, TIM2, 5)
#define TIM2_CH2_PA1_6 CH32V00X_PINMUX_DEFINE(PA, 1, TIM2, 6)
#define TIM2_CH2_PD4_7 CH32V00X_PINMUX_DEFINE(PD, 4, TIM2, 7)
#define TIM2_CH3_PC0_0 CH32V00X_PINMUX_DEFINE(PC, 0, TIM2, 0)
#define TIM2_CH3_PC0_1 CH32V00X_PINMUX_DEFINE(PC, 0, TIM2, 1)
#define TIM2_CH3_PD2_2 CH32V00X_PINMUX_DEFINE(PD, 2, TIM2, 2)
#define TIM2_CH3_PD6_3 CH32V00X_PINMUX_DEFINE(PD, 6, TIM2, 3)
#define TIM2_CH3_PC3_4 CH32V00X_PINMUX_DEFINE(PC, 3, TIM2, 4)
#define TIM2_CH3_PA2_5 CH32V00X_PINMUX_DEFINE(PA, 2, TIM2, 5)
#define TIM2_CH3_PA2_6 CH32V00X_PINMUX_DEFINE(PA, 2, TIM2, 6)
#define TIM2_CH3_PA2_7 CH32V00X_PINMUX_DEFINE(PA, 2, TIM2, 7)
#define TIM2_CH4_PD7_0 CH32V00X_PINMUX_DEFINE(PD, 7, TIM2, 0)
#define TIM2_CH4_PD7_1 CH32V00X_PINMUX_DEFINE(PD, 7, TIM2, 1)
#define TIM2_CH4_PC1_2 CH32V00X_PINMUX_DEFINE(PC, 1, TIM2, 2)
#define TIM2_CH4_PD5_3 CH32V00X_PINMUX_DEFINE(PD, 5, TIM2, 3)
#define TIM2_CH4_PB6_4 CH32V00X_PINMUX_DEFINE(PB, 6, TIM2, 4)
#define TIM2_CH4_PA3_5 CH32V00X_PINMUX_DEFINE(PA, 3, TIM2, 5)
#define TIM2_CH4_PA3_6 CH32V00X_PINMUX_DEFINE(PA, 3, TIM2, 6)
#define TIM2_CH4_PA3_7 CH32V00X_PINMUX_DEFINE(PA, 3, TIM2, 7)

#define USART1_TX_PD5_0  CH32V00X_PINMUX_DEFINE(PD, 5, USART1, 0)
#define USART1_TX_PD6_1  CH32V00X_PINMUX_DEFINE(PD, 6, USART1, 1)
#define USART1_TX_PD0_2  CH32V00X_PINMUX_DEFINE(PD, 0, USART1, 2)
#define USART1_TX_PC0_3  CH32V00X_PINMUX_DEFINE(PC, 0, USART1, 3)
#define USART1_TX_PD1_4  CH32V00X_PINMUX_DEFINE(PD, 1, USART1, 4)
#define USART1_TX_PB3_5  CH32V00X_PINMUX_DEFINE(PB, 3, USART1, 5)
#define USART1_TX_PC5_6  CH32V00X_PINMUX_DEFINE(PC, 5, USART1, 6)
#define USART1_TX_PB5_7  CH32V00X_PINMUX_DEFINE(PB, 5, USART1, 7)
#define USART1_TX_PA0_8  CH32V00X_PINMUX_DEFINE(PA, 0, USART1, 8)
#define USART1_TX_PA0_9  CH32V00X_PINMUX_DEFINE(PA, 0, USART1, 9)
#define USART1_RX_PD6_0  CH32V00X_PINMUX_DEFINE(PD, 6, USART1, 0)
#define USART1_RX_PD5_1  CH32V00X_PINMUX_DEFINE(PD, 5, USART1, 1)
#define USART1_RX_PD1_2  CH32V00X_PINMUX_DEFINE(PD, 1, USART1, 2)
#define USART1_RX_PC1_3  CH32V00X_PINMUX_DEFINE(PC, 1, USART1, 3)
#define USART1_RX_PB3_4  CH32V00X_PINMUX_DEFINE(PB, 3, USART1, 4)
#define USART1_RX_PD1_5  CH32V00X_PINMUX_DEFINE(PD, 1, USART1, 5)
#define USART1_RX_PC6_6  CH32V00X_PINMUX_DEFINE(PC, 6, USART1, 6)
#define USART1_RX_PB6_7  CH32V00X_PINMUX_DEFINE(PB, 6, USART1, 7)
#define USART1_RX_PA1_8  CH32V00X_PINMUX_DEFINE(PA, 1, USART1, 8)
#define USART1_RX_PC4_9  CH32V00X_PINMUX_DEFINE(PC, 4, USART1, 9)
#define USART1_CTS_PD3_0 CH32V00X_PINMUX_DEFINE(PD, 3, USART1, 0)
#define USART1_CTS_PC6_1 CH32V00X_PINMUX_DEFINE(PC, 6, USART1, 1)
#define USART1_CTS_PC3_2 CH32V00X_PINMUX_DEFINE(PC, 3, USART1, 2)
#define USART1_CTS_PC6_3 CH32V00X_PINMUX_DEFINE(PC, 6, USART1, 3)
#define USART1_CTS_PD7_4 CH32V00X_PINMUX_DEFINE(PD, 7, USART1, 4)
#define USART1_CTS_PD7_5 CH32V00X_PINMUX_DEFINE(PD, 7, USART1, 5)
#define USART1_CTS_PC7_6 CH32V00X_PINMUX_DEFINE(PC, 7, USART1, 6)
#define USART1_CTS_PC7_7 CH32V00X_PINMUX_DEFINE(PC, 7, USART1, 7)
#define USART1_CTS_PD2_8 CH32V00X_PINMUX_DEFINE(PD, 2, USART1, 8)
#define USART1_CTS_PD5_9 CH32V00X_PINMUX_DEFINE(PD, 5, USART1, 9)
#define USART1_RTS_PC2_0 CH32V00X_PINMUX_DEFINE(PC, 2, USART1, 0)
#define USART1_RTS_PC7_1 CH32V00X_PINMUX_DEFINE(PC, 7, USART1, 1)
#define USART1_RTS_PC2_2 CH32V00X_PINMUX_DEFINE(PC, 2, USART1, 2)
#define USART1_RTS_PC7_3 CH32V00X_PINMUX_DEFINE(PC, 7, USART1, 3)
#define USART1_RTS_PA5_4 CH32V00X_PINMUX_DEFINE(PA, 5, USART1, 4)
#define USART1_RTS_PA5_5 CH32V00X_PINMUX_DEFINE(PA, 5, USART1, 5)
#define USART1_RTS_PB4_6 CH32V00X_PINMUX_DEFINE(PB, 4, USART1, 6)
#define USART1_RTS_PB4_7 CH32V00X_PINMUX_DEFINE(PB, 4, USART1, 7)
#define USART1_RTS_PD3_8 CH32V00X_PINMUX_DEFINE(PD, 3, USART1, 8)
#define USART1_RTS_PD4_9 CH32V00X_PINMUX_DEFINE(PD, 4, USART1, 9)

#define USART2_TX_PA7_0  CH32V00X_PINMUX_DEFINE(PA, 7, USART2, 0)
#define USART2_TX_PA4_1  CH32V00X_PINMUX_DEFINE(PA, 4, USART2, 1)
#define USART2_TX_PA2_2  CH32V00X_PINMUX_DEFINE(PA, 2, USART2, 2)
#define USART2_TX_PD2_3  CH32V00X_PINMUX_DEFINE(PD, 2, USART2, 3)
#define USART2_TX_PB0_4  CH32V00X_PINMUX_DEFINE(PB, 0, USART2, 4)
#define USART2_TX_PC4_5  CH32V00X_PINMUX_DEFINE(PC, 4, USART2, 5)
#define USART2_TX_PA6_6  CH32V00X_PINMUX_DEFINE(PA, 6, USART2, 6)
#define USART2_RX_PB3_0  CH32V00X_PINMUX_DEFINE(PB, 3, USART2, 0)
#define USART2_RX_PA5_1  CH32V00X_PINMUX_DEFINE(PA, 5, USART2, 1)
#define USART2_RX_PA3_2  CH32V00X_PINMUX_DEFINE(PA, 3, USART2, 2)
#define USART2_RX_PD3_3  CH32V00X_PINMUX_DEFINE(PD, 3, USART2, 3)
#define USART2_RX_PB1_4  CH32V00X_PINMUX_DEFINE(PB, 1, USART2, 4)
#define USART2_RX_PD1_5  CH32V00X_PINMUX_DEFINE(PD, 1, USART2, 5)
#define USART2_RX_PA5_6  CH32V00X_PINMUX_DEFINE(PA, 5, USART2, 6)
#define USART2_CTS_PA4_0 CH32V00X_PINMUX_DEFINE(PA, 4, USART2, 0)
#define USART2_CTS_PA7_1 CH32V00X_PINMUX_DEFINE(PA, 7, USART2, 1)
#define USART2_CTS_PA0_2 CH32V00X_PINMUX_DEFINE(PA, 0, USART2, 2)
#define USART2_CTS_PA0_3 CH32V00X_PINMUX_DEFINE(PA, 0, USART2, 3)
#define USART2_CTS_PB6_4 CH32V00X_PINMUX_DEFINE(PB, 6, USART2, 4)
#define USART2_CTS_PA4_5 CH32V00X_PINMUX_DEFINE(PA, 4, USART2, 5)
#define USART2_CTS_PA7_6 CH32V00X_PINMUX_DEFINE(PA, 7, USART2, 6)
#define USART2_RTS_PA5_0 CH32V00X_PINMUX_DEFINE(PA, 5, USART2, 0)
#define USART2_RTS_PB3_1 CH32V00X_PINMUX_DEFINE(PB, 3, USART2, 1)
#define USART2_RTS_PA1_2 CH32V00X_PINMUX_DEFINE(PA, 1, USART2, 2)
#define USART2_RTS_PA1_3 CH32V00X_PINMUX_DEFINE(PA, 1, USART2, 3)
#define USART2_RTS_PA1_4 CH32V00X_PINMUX_DEFINE(PA, 1, USART2, 4)
#define USART2_RTS_PA1_5 CH32V00X_PINMUX_DEFINE(PA, 1, USART2, 5)
#define USART2_RTS_PB3_6 CH32V00X_PINMUX_DEFINE(PB, 3, USART2, 6)

#define SPI1_NSS_PC1_0  CH32V00X_PINMUX_DEFINE(PC, 1, SPI1, 0)
#define SPI1_NSS_PC0_1  CH32V00X_PINMUX_DEFINE(PC, 0, SPI1, 1)
#define SPI1_NSS_PC4_2  CH32V00X_PINMUX_DEFINE(PC, 4, SPI1, 2)
#define SPI1_NSS_PB0_3  CH32V00X_PINMUX_DEFINE(PB, 0, SPI1, 3)
#define SPI1_NSS_PD3_4  CH32V00X_PINMUX_DEFINE(PD, 3, SPI1, 4)
#define SPI1_NSS_PC1_5  CH32V00X_PINMUX_DEFINE(PC, 1, SPI1, 5)
#define SPI1_NSS_PC4_6  CH32V00X_PINMUX_DEFINE(PC, 4, SPI1, 6)
#define SPI1_SCK_PC5_0  CH32V00X_PINMUX_DEFINE(PC, 5, SPI1, 0)
#define SPI1_SCK_PC5_1  CH32V00X_PINMUX_DEFINE(PC, 5, SPI1, 1)
#define SPI1_SCK_PD2_2  CH32V00X_PINMUX_DEFINE(PD, 2, SPI1, 2)
#define SPI1_SCK_PB1_3  CH32V00X_PINMUX_DEFINE(PB, 1, SPI1, 3)
#define SPI1_SCK_PD4_4  CH32V00X_PINMUX_DEFINE(PD, 4, SPI1, 4)
#define SPI1_SCK_PA1_5  CH32V00X_PINMUX_DEFINE(PA, 1, SPI1, 5)
#define SPI1_SCK_PB5_6  CH32V00X_PINMUX_DEFINE(PB, 5, SPI1, 6)
#define SPI1_MISO_PC7_0 CH32V00X_PINMUX_DEFINE(PC, 7, SPI1, 0)
#define SPI1_MISO_PC7_1 CH32V00X_PINMUX_DEFINE(PC, 7, SPI1, 1)
#define SPI1_MISO_PB3_2 CH32V00X_PINMUX_DEFINE(PB, 3, SPI1, 2)
#define SPI1_MISO_PB2_3 CH32V00X_PINMUX_DEFINE(PB, 2, SPI1, 3)
#define SPI1_MISO_PD5_4 CH32V00X_PINMUX_DEFINE(PD, 5, SPI1, 4)
#define SPI1_MISO_PB5_5 CH32V00X_PINMUX_DEFINE(PB, 5, SPI1, 5)
#define SPI1_MISO_PC7_6 CH32V00X_PINMUX_DEFINE(PC, 7, SPI1, 6)
#define SPI1_MOSI_PC6_0 CH32V00X_PINMUX_DEFINE(PC, 6, SPI1, 0)
#define SPI1_MOSI_PC6_1 CH32V00X_PINMUX_DEFINE(PC, 6, SPI1, 1)
#define SPI1_MOSI_PD3_2 CH32V00X_PINMUX_DEFINE(PD, 3, SPI1, 2)
#define SPI1_MOSI_PC0_3 CH32V00X_PINMUX_DEFINE(PC, 0, SPI1, 3)
#define SPI1_MOSI_PD6_4 CH32V00X_PINMUX_DEFINE(PD, 6, SPI1, 4)
#define SPI1_MOSI_PA2_5 CH32V00X_PINMUX_DEFINE(PA, 2, SPI1, 5)
#define SPI1_MOSI_PB4_6 CH32V00X_PINMUX_DEFINE(PB, 4, SPI1, 6)

#define I2C1_SCL_PC2_0 CH32V00X_PINMUX_DEFINE(PC, 2, I2C1, 0)
#define I2C1_SCL_PD1_1 CH32V00X_PINMUX_DEFINE(PD, 1, I2C1, 1)
#define I2C1_SCL_PC5_2 CH32V00X_PINMUX_DEFINE(PC, 5, I2C1, 2)
#define I2C1_SCL_PB5_3 CH32V00X_PINMUX_DEFINE(PB, 5, I2C1, 3)
#define I2C1_SCL_PB3_4 CH32V00X_PINMUX_DEFINE(PB, 3, I2C1, 4)
#define I2C1_SDA_PC1_0 CH32V00X_PINMUX_DEFINE(PC, 1, I2C1, 0)
#define I2C1_SDA_PD0_1 CH32V00X_PINMUX_DEFINE(PD, 0, I2C1, 1)
#define I2C1_SDA_PC6_2 CH32V00X_PINMUX_DEFINE(PC, 6, I2C1, 2)
/* CH32V007 specific remap */
#define I2C1_SDA_PC4_2 CH32V00X_PINMUX_DEFINE(PC, 4, I2C1, 2)
#define I2C1_SDA_PB6_3 CH32V00X_PINMUX_DEFINE(PB, 6, I2C1, 3)
#define I2C1_SDA_PD1_4 CH32V00X_PINMUX_DEFINE(PD, 1, I2C1, 4)

#endif /* __CH32V00X_PINCTRL_H__ */
