/*
 * Copyright 2023, 2025 NXP
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_IMX8QM_PINCTRL_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_IMX8QM_PINCTRL_H_

/* values for pad field */
#define SC_P_UART0_RTS_B 23
#define SC_P_UART0_CTS_B 24
#define SC_P_ESAI0_FSR 104
#define SC_P_ESAI0_FST 105
#define SC_P_ESAI0_SCKR 106
#define SC_P_ESAI0_SCKT 107
#define SC_P_ESAI0_TX0 108
#define SC_P_ESAI0_TX1 109
#define SC_P_ESAI0_TX2_RX3 110
#define SC_P_ESAI0_TX3_RX2 111
#define SC_P_ESAI0_TX4_RX1 112
#define SC_P_ESAI0_TX5_RX0 113
#define SC_P_SAI1_RXD 128
#define SC_P_SAI1_TXC 130
#define SC_P_SAI1_TXD 131
#define SC_P_SAI1_TXFS 132

/* mux values */
#define IMX8QM_DMA_LPUART2_RX_UART0_RTS_B 2 /* UART0_RTS_B ---> DMA_LPUART2_RX */
#define IMX8QM_DMA_LPUART2_TX_UART0_CTS_B 2 /* DMA_LPUART2_TX ---> UART0_CTS_B */
#define IMX8QM_AUD_SAI1_RXD_SAI1_RXD 0 /* AUD_SAI1_RXD <--- SAI1_RXD */
#define IMX8QM_AUD_SAI1_TXC_SAI1_TXC 0 /* AUD_SAI1_TXC <---> SAI1_TXC */
#define IMX8QM_AUD_SAI1_TXD_SAI1_TXD 0 /* AUD_SAI1_TXD ---> SAI1_TXD */
#define IMX8QM_AUD_SAI1_TXFS_SAI1_TXFS 0 /* AUD_SAI1_TXFS <---> SAI1_TXFS */
#define IMX8QM_AUD_ESAI0_FSR_ESAI0_FSR 0
#define IMX8QM_AUD_ESAI0_FST_ESAI0_FST 0
#define IMX8QM_AUD_ESAI0_SCKR_ESAI0_SCKR 0
#define IMX8QM_AUD_ESAI0_SCKT_ESAI0_SCKT 0
#define IMX8QM_AUD_ESAI0_TX0_ESAI_TX0 0
#define IMX8QM_AUD_ESAI0_TX1_ESAI_TX1 0
#define IMX8QM_AUD_ESAI0_TX2_RX3_ESAI0_TX2_RX3 0
#define IMX8QM_AUD_ESAI0_TX3_RX2_ESAI0_TX3_RX2 0
#define IMX8QM_AUD_ESAI0_TX4_RX1_ESAI0_TX4_RX1 0
#define IMX8QM_AUD_ESAI0_TX5_RX0_ESAI0_TX5_RX0 0

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_IMX8QM_PINCTRL_H_ */
