/*
 * Copyright (c) 2021 IoT.bzh
 * Copyright (c) 2023-2024 EPAM Systems
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_RENESAS_PINCTRL_R8A77961_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_RENESAS_PINCTRL_R8A77961_H_

#include "pinctrl-rcar-common.h"

/* Pins declaration */
#define PIN_NONE                   -1
#define PIN_D0                     RCAR_GP_PIN(0, 0)
#define PIN_D1                     RCAR_GP_PIN(0, 1)
#define PIN_D2                     RCAR_GP_PIN(0, 2)
#define PIN_D3                     RCAR_GP_PIN(0, 3)
#define PIN_D4                     RCAR_GP_PIN(0, 4)
#define PIN_D5                     RCAR_GP_PIN(0, 5)
#define PIN_D6                     RCAR_GP_PIN(0, 6)
#define PIN_D7                     RCAR_GP_PIN(0, 7)
#define PIN_D8                     RCAR_GP_PIN(0, 8)
#define PIN_D9                     RCAR_GP_PIN(0, 9)
#define PIN_D10                    RCAR_GP_PIN(0, 10)
#define PIN_D11                    RCAR_GP_PIN(0, 11)
#define PIN_D12                    RCAR_GP_PIN(0, 12)
#define PIN_D13                    RCAR_GP_PIN(0, 13)
#define PIN_D14                    RCAR_GP_PIN(0, 14)
#define PIN_D15                    RCAR_GP_PIN(0, 15)
#define PIN_A0                     RCAR_GP_PIN(1, 0)
#define PIN_A1                     RCAR_GP_PIN(1, 1)
#define PIN_A2                     RCAR_GP_PIN(1, 2)
#define PIN_A3                     RCAR_GP_PIN(1, 3)
#define PIN_A4                     RCAR_GP_PIN(1, 4)
#define PIN_A5                     RCAR_GP_PIN(1, 5)
#define PIN_A6                     RCAR_GP_PIN(1, 6)
#define PIN_A7                     RCAR_GP_PIN(1, 7)
#define PIN_A8                     RCAR_GP_PIN(1, 8)
#define PIN_A9                     RCAR_GP_PIN(1, 9)
#define PIN_A10                    RCAR_GP_PIN(1, 10)
#define PIN_A11                    RCAR_GP_PIN(1, 11)
#define PIN_A12                    RCAR_GP_PIN(1, 12)
#define PIN_A13                    RCAR_GP_PIN(1, 13)
#define PIN_A14                    RCAR_GP_PIN(1, 14)
#define PIN_A15                    RCAR_GP_PIN(1, 15)
#define PIN_A16                    RCAR_GP_PIN(1, 16)
#define PIN_A17                    RCAR_GP_PIN(1, 17)
#define PIN_A18                    RCAR_GP_PIN(1, 18)
#define PIN_A19                    RCAR_GP_PIN(1, 19)
#define PIN_CS0                    RCAR_GP_PIN(1, 20)
#define PIN_CS1                    RCAR_GP_PIN(1, 21)
#define PIN_BS                     RCAR_GP_PIN(1, 22)
#define PIN_RD                     RCAR_GP_PIN(1, 23)
#define PIN_RD_WR                  RCAR_GP_PIN(1, 24)
#define PIN_WE0                    RCAR_GP_PIN(1, 25)
#define PIN_WE1                    RCAR_GP_PIN(1, 26)
#define PIN_EX_WAIT0               RCAR_GP_PIN(1, 27)
#define PIN_CLKOUT                 RCAR_GP_PIN(1, 28)
#define PIN_IRQ0                   RCAR_GP_PIN(2, 0)
#define PIN_IRQ1                   RCAR_GP_PIN(2, 1)
#define PIN_IRQ2                   RCAR_GP_PIN(2, 2)
#define PIN_IRQ3                   RCAR_GP_PIN(2, 3)
#define PIN_IRQ4                   RCAR_GP_PIN(2, 4)
#define PIN_IRQ5                   RCAR_GP_PIN(2, 5)
#define PIN_PWM0                   RCAR_GP_PIN(2, 6)
#define PIN_PWM1_A                 RCAR_GP_PIN(2, 7)
#define PIN_PWM2_A                 RCAR_GP_PIN(2, 8)
#define PIN_AVB_MDC                RCAR_GP_PIN(2, 9)
#define PIN_AVB_MAGIC              RCAR_GP_PIN(2, 10)
#define PIN_AVB_PHY_INT            RCAR_GP_PIN(2, 11)
#define PIN_AVB_LINK               RCAR_GP_PIN(2, 12)
#define PIN_AVB_AVTP_MATCH_A       RCAR_GP_PIN(2, 13)
#define PIN_AVB_AVTP_CAPTURE_A     RCAR_GP_PIN(2, 14)
#define PIN_SD0_CLK                RCAR_GP_PIN(3, 0)
#define PIN_SD0_CMD                RCAR_GP_PIN(3, 1)
#define PIN_SD0_DATA0              RCAR_GP_PIN(3, 2)
#define PIN_SD0_DATA1              RCAR_GP_PIN(3, 3)
#define PIN_SD0_DATA2              RCAR_GP_PIN(3, 4)
#define PIN_SD0_DATA3              RCAR_GP_PIN(3, 5)
#define PIN_SD1_CLK                RCAR_GP_PIN(3, 6)
#define PIN_SD1_CMD                RCAR_GP_PIN(3, 7)
#define PIN_SD1_DATA0              RCAR_GP_PIN(3, 8)
#define PIN_SD1_DATA1              RCAR_GP_PIN(3, 9)
#define PIN_SD1_DATA2              RCAR_GP_PIN(3, 10)
#define PIN_SD1_DATA3              RCAR_GP_PIN(3, 11)
#define PIN_SD0_CD                 RCAR_GP_PIN(3, 12)
#define PIN_SD0_WP                 RCAR_GP_PIN(3, 13)
#define PIN_SD1_CD                 RCAR_GP_PIN(3, 14)
#define PIN_SD1_WP                 RCAR_GP_PIN(3, 15)
#define PIN_SD2_CLK                RCAR_GP_PIN(4, 0)
#define PIN_SD2_CMD                RCAR_GP_PIN(4,  1)
#define PIN_SD2_DATA0              RCAR_GP_PIN(4,  2)
#define PIN_SD2_DATA1              RCAR_GP_PIN(4,  3)
#define PIN_SD2_DATA2              RCAR_GP_PIN(4,  4)
#define PIN_SD2_DATA3              RCAR_GP_PIN(4,  5)
#define PIN_SD2_DS                 RCAR_GP_PIN(4,  6)
#define PIN_SD3_CLK                RCAR_GP_PIN(4,  7)
#define PIN_SD3_CMD                RCAR_GP_PIN(4,  8)
#define PIN_SD3_DATA0              RCAR_GP_PIN(4,  9)
#define PIN_SD3_DATA1              RCAR_GP_PIN(4,  10)
#define PIN_SD3_DATA2              RCAR_GP_PIN(4,  11)
#define PIN_SD3_DATA3              RCAR_GP_PIN(4,  12)
#define PIN_SD3_DATA4              RCAR_GP_PIN(4,  13)
#define PIN_SD3_DATA5              RCAR_GP_PIN(4,  14)
#define PIN_SD3_DATA6              RCAR_GP_PIN(4,  15)
#define PIN_SD3_DATA7              RCAR_GP_PIN(4,  16)
#define PIN_SD3_DS                 RCAR_GP_PIN(4,  17)
#define PIN_SCK0                   RCAR_GP_PIN(5, 0)
#define PIN_RX0                    RCAR_GP_PIN(5, 1)
#define PIN_TX0                    RCAR_GP_PIN(5, 2)
#define PIN_CTS0                   RCAR_GP_PIN(5, 3)
#define PIN_RTS0                   RCAR_GP_PIN(5, 4)
#define PIN_RX1_A                  RCAR_GP_PIN(5, 5)
#define PIN_TX1_A                  RCAR_GP_PIN(5, 6)
#define PIN_CTS1                   RCAR_GP_PIN(5, 7)
#define PIN_RTS1                   RCAR_GP_PIN(5, 8)
#define PIN_SCK2                   RCAR_GP_PIN(5, 9)
#define PIN_TX2_A                  RCAR_GP_PIN(5, 10)
#define PIN_RX2_A                  RCAR_GP_PIN(5, 11)
#define PIN_HSCK0                  RCAR_GP_PIN(5, 12)
#define PIN_HRX0                   RCAR_GP_PIN(5, 13)
#define PIN_HTX0                   RCAR_GP_PIN(5, 14)
#define PIN_HCTS0                  RCAR_GP_PIN(5, 15)
#define PIN_HRTS0                  RCAR_GP_PIN(5, 16)
#define PIN_MSIOF0_SCK             RCAR_GP_PIN(5, 17)
#define PIN_MSIOF0_SYNC            RCAR_GP_PIN(5, 18)
#define PIN_MSIOF0_SS1             RCAR_GP_PIN(5, 19)
#define PIN_MSIOF0_TXD             RCAR_GP_PIN(5, 20)
#define PIN_MSIOF0_SS2             RCAR_GP_PIN(5, 21)
#define PIN_MSIOF0_RXD             RCAR_GP_PIN(5, 22)
#define PIN_MLB_CLK                RCAR_GP_PIN(5, 23)
#define PIN_MLB_SIG                RCAR_GP_PIN(5, 24)
#define PIN_MLB_DAT                RCAR_GP_PIN(5, 25)
#define PIN_SSI_SCK01239           RCAR_GP_PIN(6, 0)
#define PIN_SSI_WS01239            RCAR_GP_PIN(6, 1)
#define PIN_SSI_SDATA0             RCAR_GP_PIN(6, 2)
#define PIN_SSI_SDATA1_A           RCAR_GP_PIN(6, 3)
#define PIN_SSI_SDATA2_A           RCAR_GP_PIN(6, 4)
#define PIN_SSI_SCK349             RCAR_GP_PIN(6, 5)
#define PIN_SSI_WS349              RCAR_GP_PIN(6, 6)
#define PIN_SSI_SDATA3             RCAR_GP_PIN(6, 7)
#define PIN_SSI_SCK4               RCAR_GP_PIN(6, 8)
#define PIN_SSI_WS4                RCAR_GP_PIN(6, 9)
#define PIN_SSI_SDAT_A4            RCAR_GP_PIN(6, 10)
#define PIN_SSI_SCK5               RCAR_GP_PIN(6, 11)
#define PIN_SSI_WS5                RCAR_GP_PIN(6, 12)
#define PIN_SSI_SDAT_A5            RCAR_GP_PIN(6, 13)
#define PIN_SSI_SCK6               RCAR_GP_PIN(6, 14)
#define PIN_SSI_WS6                RCAR_GP_PIN(6, 15)
#define PIN_SSI_SDATA6             RCAR_GP_PIN(6, 16)
#define PIN_SSI_SCK78              RCAR_GP_PIN(6, 17)
#define PIN_WS78                   RCAR_GP_PIN(6, 18)
#define PIN_SSI_SDATA7             RCAR_GP_PIN(6, 19)
#define PIN_SSI_SDATA8             RCAR_GP_PIN(6, 20)
#define PIN_SSI_SDATA9_A           RCAR_GP_PIN(6, 21)
#define PIN_AUDIO_CLKA_A           RCAR_GP_PIN(6, 22)
#define PIN_AUDIO_CLKB_B           RCAR_GP_PIN(6, 23)
#define PIN_USB0_PWEN              RCAR_GP_PIN(6, 24)
#define PIN_USB0_OVC               RCAR_GP_PIN(6, 25)
#define PIN_USB1_PWEN              RCAR_GP_PIN(6, 26)
#define PIN_USB1_OVC               RCAR_GP_PIN(6, 27)
#define PIN_USB30_PWEN             RCAR_GP_PIN(6, 28)
#define PIN_USB30_OVC              RCAR_GP_PIN(6, 29)
#define PIN_USB2_CH3_PWEN          RCAR_GP_PIN(6, 30)
#define PIN_USB2_CH3_OVC           RCAR_GP_PIN(6, 31)
#define PIN_AVS1                   RCAR_GP_PIN(7, 0)
#define PIN_AVS2                   RCAR_GP_PIN(7, 1)
#define PIN_GP7_02                 RCAR_GP_PIN(7, 2)
#define PIN_GP7_03                 RCAR_GP_PIN(7, 3)
#define PIN_ASEBRK                 RCAR_NOGP_PIN(1)
#define PIN_AVB_MDIO               RCAR_NOGP_PIN(2)
#define PIN_AVB_RD0                RCAR_NOGP_PIN(3)
#define PIN_AVB_RD1                RCAR_NOGP_PIN(4)
#define PIN_AVB_RD2                RCAR_NOGP_PIN(5)
#define PIN_AVB_RD3                RCAR_NOGP_PIN(6)
#define PIN_AVB_RXC                RCAR_NOGP_PIN(7)
#define PIN_AVB_RX_CTL             RCAR_NOGP_PIN(8)
#define PIN_AVB_TD0                RCAR_NOGP_PIN(9)
#define PIN_AVB_TD1                RCAR_NOGP_PIN(10)
#define PIN_AVB_TD2                RCAR_NOGP_PIN(11)
#define PIN_AVB_TD3                RCAR_NOGP_PIN(12)
#define PIN_AVB_TXC                RCAR_NOGP_PIN(13)
#define PIN_AVB_TXCREFCLK          RCAR_NOGP_PIN(14)
#define PIN_AVB_TX_CTL             RCAR_NOGP_PIN(15)
#define PIN_DU_DOTCLKIN0           RCAR_NOGP_PIN(16)
#define PIN_DU_DOTCLKIN1           RCAR_NOGP_PIN(17)
#define PIN_DU_DOTCLKIN2           RCAR_NOGP_PIN(18)
#define PIN_DU_DOTCLKIN3           RCAR_NOGP_PIN(19)
#define PIN_EXTALR                 RCAR_NOGP_PIN(20)
#define PIN_FSCLKST_N              RCAR_NOGP_PIN(21)
#define PIN_MLB_REF                RCAR_NOGP_PIN(22)
#define PIN_PRESETOUT_N            RCAR_NOGP_PIN(23)
#define PIN_QSPI0_IO2              RCAR_NOGP_PIN(24)
#define PIN_QSPI0_IO3              RCAR_NOGP_PIN(25)
#define PIN_QSPI0_MISO_IO1         RCAR_NOGP_PIN(26)
#define PIN_QSPI0_MOSI_IO0         RCAR_NOGP_PIN(27)
#define PIN_QSPI0_SPCLK            RCAR_NOGP_PIN(28)
#define PIN_QSPI0_SSL              RCAR_NOGP_PIN(29)
#define PIN_QSPI1_IO2              RCAR_NOGP_PIN(30)
#define PIN_QSPI1_IO3              RCAR_NOGP_PIN(31)
#define PIN_QSPI1_MISO_IO1         RCAR_NOGP_PIN(32)
#define PIN_QSPI1_MOSI_IO0         RCAR_NOGP_PIN(33)
#define PIN_QSPI1_SPCLK            RCAR_NOGP_PIN(34)
#define PIN_QSPI1_SSL              RCAR_NOGP_PIN(35)
#define PIN_RPC_INT_N              RCAR_NOGP_PIN(36)
#define PIN_RPC_RESET_N            RCAR_NOGP_PIN(37)
#define PIN_RPC_WP_N               RCAR_NOGP_PIN(38)
#define PIN_TCK                    RCAR_NOGP_PIN(39)
#define PIN_TDI                    RCAR_NOGP_PIN(40)
#define PIN_TDO                    RCAR_NOGP_PIN(41)
#define PIN_TMS                    RCAR_NOGP_PIN(42)
#define PIN_TRST_N                 RCAR_NOGP_PIN(43)

/* Pinmux function declarations */
#define FUNC_AVB_MDC                    IPSR(0, 0, 0)
#define FUNC_MSIOD2_SS2_C               IPSR(0, 0, 2)
#define FUNC_AVB_MAGIC                  IPSR(0, 4, 0)
#define FUNC_MSIOF2_SS1_C               IPSR(0, 4, 2)
#define FUNC_SCK4_A                     IPSR(0, 4, 3)
#define FUNC_AVB_PHY_INT                IPSR(0, 8, 0)
#define FUNC_MSIOF2_SYNC_C              IPSR(0, 8, 2)
#define FUNC_RX4_A                      IPSR(0, 8, 3)
#define FUNC_AVB_LINK                   IPSR(0, 12, 0)
#define FUNC_MSIOF2_SCK_C               IPSR(0, 12, 2)
#define FUNC_TX4_A                      IPSR(0, 12, 3)
#define FUNC_AVB_AVTP_MATCH_A           IPSR(0, 16, 0)
#define FUNC_MSIOF2_RXD_C               IPSR(0, 16, 2)
#define FUNC_CTS4_N_A                   IPSR(0, 16, 3)
#define FUNC_AVB_AVTP_CAPTURE_A         IPSR(0, 20, 0)
#define FUNC_MSIOF2_TXD_C               IPSR(0, 20, 2)
#define FUNC_RTS4_N_A                   IPSR(0, 20, 3)
#define FUNC_IRQ0                       IPSR(0, 24, 0)
#define FUNC_QPOLB                      IPSR(0, 24, 1)
#define FUNC_DU_CDE                     IPSR(0, 24, 3)
#define FUNC_VI4_DATA0_B                IPSR(0, 24, 4)
#define FUNC_CAN0_TX_B                  IPSR(0, 24, 5)
#define FUNC_CANFD0_TX_B                IPSR(0, 24, 6)
#define FUNC_MSIOF3_SS2_E               IPSR(0, 24, 7)
#define FUNC_IRQ1                       IPSR(0, 28, 0)
#define FUNC_QPOLA                      IPSR(0, 28, 1)
#define FUNC_DU_DISP                    IPSR(0, 28, 3)
#define FUNC_VI4_DATA1_B                IPSR(0, 28, 4)
#define FUNC_CAN0_RX_B                  IPSR(0, 28, 5)
#define FUNC_CANFD0_RX_B                IPSR(0, 28, 6)
#define FUNC_MSIOF3_SS1_E               IPSR(0, 28, 7)
#define FUNC_IRQ2                       IPSR(1, 0, 0)
#define FUNC_QCPV_QDE                   IPSR(1, 0, 1)
#define FUNC_DU_EXODDF_DU_ODDF_DISP_CDE IPSR(1, 0, 3)
#define FUNC_VI4_DATA2_B                IPSR(1, 0, 4)
#define FUNC_MSIOF3_SYNC_E              IPSR(1, 0, 7)
#define FUNC_PWM3_B                     IPSR(1, 0, 9)
#define FUNC_IRQ3                       IPSR(1, 4, 0)
#define FUNC_QSTVB_QVE                  IPSR(1, 4, 1)
#define FUNC_DU_DOTCLKOUT1              IPSR(1, 4, 3)
#define FUNC_VI4_DATA3_B                IPSR(1, 4, 4)
#define FUNC_MSIOF3_SCK_E               IPSR(1, 4, 7)
#define FUNC_PWM4_B                     IPSR(1, 4, 9)
#define FUNC_IRQ4                       IPSR(1, 8, 0)
#define FUNC_QSTH_QHS                   IPSR(1, 8, 1)
#define FUNC_DU_EXHSYNC_DU_HSYNC        IPSR(1, 8, 3)
#define FUNC_VI4_DATA4_B                IPSR(1, 8, 4)
#define FUNC_MSIOF3_RXD_E               IPSR(1, 8, 7)
#define FUNC_PWM5_B                     IPSR(1, 8, 9)
#define FUNC_IRQ5                       IPSR(1, 12, 0)
#define FUNC_QSTB_QHE                   IPSR(1, 12, 1)
#define FUNC_DU_EXVSYNC_DU_VSYNC        IPSR(1, 12, 3)
#define FUNC_VI4_DATA5_B                IPSR(1, 12, 4)
#define FUNC_MSIOF3_TXD_E               IPSR(1, 12, 7)
#define FUNC_PWM6_B                     IPSR(1, 12, 9)
#define FUNC_PWM0                       IPSR(1, 16, 0)
#define FUNC_AVB_AVTP_PPS               IPSR(1, 16, 1)
#define FUNC_VI4_DATA6_B                IPSR(1, 16, 4)
#define FUNC_IECLK_B                    IPSR(1, 16, 9)
#define FUNC_PWM1_A                     IPSR(1, 20, 0)
#define FUNC_HRX3_D                     IPSR(1, 20, 3)
#define FUNC_VI4_DATA7_B                IPSR(1, 20, 4)
#define FUNC_IERX_B                     IPSR(1, 20, 9)
#define FUNC_PWM2_A                     IPSR(1, 24, 0)
#define FUNC_HTX3_D                     IPSR(1, 24, 3)
#define FUNC_IETX_B                     IPSR(1, 24, 9)
#define FUNC_A0                         IPSR(1, 28, 0)
#define FUNC_LCDOUT16                   IPSR(1, 28, 1)
#define FUNC_MSIOF3_SYNC_B              IPSR(1, 28, 2)
#define FUNC_VI4_DATA8                  IPSR(1, 28, 4)
#define FUNC_DU_DB0                     IPSR(1, 28, 6)
#define FUNC_PWM3_A                     IPSR(1, 28, 9)
#define FUNC_A1                         IPSR(2, 0, 0)
#define FUNC_LCDOUT17                   IPSR(2, 0, 1)
#define FUNC_MSIOF3_TXD_B               IPSR(2, 0, 2)
#define FUNC_VI4_DATA9                  IPSR(2, 0, 4)
#define FUNC_DU_DB1                     IPSR(2, 0, 6)
#define FUNC_PWM4_A                     IPSR(2, 0, 9)
#define FUNC_A2                         IPSR(2, 4, 0)
#define FUNC_LCDOUT18                   IPSR(2, 4, 1)
#define FUNC_MSIOF3_SCK_B               IPSR(2, 4, 2)
#define FUNC_VI4_DATA10                 IPSR(2, 4, 4)
#define FUNC_DU_DB2                     IPSR(2, 4, 6)
#define FUNC_PWM5_A                     IPSR(2, 4, 9)
#define FUNC_A3                         IPSR(2, 8, 0)
#define FUNC_LCDOUT19                   IPSR(2, 8, 1)
#define FUNC_MSIOF3_RXD_B               IPSR(2, 8, 2)
#define FUNC_VI4_DATA11                 IPSR(2, 8, 4)
#define FUNC_DU_DB3                     IPSR(2, 8, 6)
#define FUNC_PWM6_A                     IPSR(2, 8, 9)
#define FUNC_A4                         IPSR(2, 12, 0)
#define FUNC_LCDOUT20                   IPSR(2, 12, 1)
#define FUNC_MSIOF3_SS1_B               IPSR(2, 12, 2)
#define FUNC_VI4_DATA12                 IPSR(2, 12, 4)
#define FUNC_VI5_DATA12                 IPSR(2, 12, 5)
#define FUNC_DU_DB4                     IPSR(2, 12, 6)
#define FUNC_A5                         IPSR(2, 16, 0)
#define FUNC_LCDOUT21                   IPSR(2, 16, 1)
#define FUNC_MSIOF3_SS2_B               IPSR(2, 16, 2)
#define FUNC_SCK4_B                     IPSR(2, 16, 3)
#define FUNC_VI4_DATA13                 IPSR(2, 16, 4)
#define FUNC_VI5_DATA13                 IPSR(2, 16, 5)
#define FUNC_DU_DB5                     IPSR(2, 16, 6)
#define FUNC_A6                         IPSR(2, 20, 0)
#define FUNC_LCDOUT22                   IPSR(2, 20, 1)
#define FUNC_MSIOF2_SS1_A               IPSR(2, 20, 2)
#define FUNC_RX4_B                      IPSR(2, 20, 3)
#define FUNC_VI4_DATA14                 IPSR(2, 20, 4)
#define FUNC_VI5_DATA14                 IPSR(2, 20, 5)
#define FUNC_DU_DB6                     IPSR(2, 20, 6)
#define FUNC_A7                         IPSR(2, 24, 0)
#define FUNC_LCDOUT23                   IPSR(2, 24, 1)
#define FUNC_MSIOF2_SS2_A               IPSR(2, 24, 2)
#define FUNC_TX4_B                      IPSR(2, 24, 3)
#define FUNC_VI4_DATA15                 IPSR(2, 24, 4)
#define FUNC_VI5_DATA15                 IPSR(2, 24, 5)
#define FUNC_DU_DB7                     IPSR(2, 24, 6)
#define FUNC_A8                         IPSR(2, 28, 0)
#define FUNC_RX3_B                      IPSR(2, 28, 1)
#define FUNC_MSIOF2_SYNC_A              IPSR(2, 28, 2)
#define FUNC_HRX4_B                     IPSR(2, 28, 3)
#define FUNC_SDA6_A                     IPSR(2, 28, 7)
#define FUNC_AVB_AVTP_MATCH_B           IPSR(2, 28, 8)
#define FUNC_PWM1_B                     IPSR(2, 28, 9)
#define FUNC_A9                         IPSR(3, 0, 0)
#define FUNC_MSIOF2_SCK_A               IPSR(3, 0, 2)
#define FUNC_CTS4_N_B                   IPSR(3, 0, 3)
#define FUNC_VI5_VSYNC_N                IPSR(3, 0, 5)
#define FUNC_A10                        IPSR(3, 4, 0)
#define FUNC_MSIOF2_RXD_A               IPSR(3, 4, 2)
#define FUNC_RTS4_N_B                   IPSR(3, 4, 3)
#define FUNC_VI5_HSYNC_N                IPSR(3, 4, 5)
#define FUNC_A11                        IPSR(3, 8, 0)
#define FUNC_TX3_B                      IPSR(3, 8, 1)
#define FUNC_MSIOF2_TXD_A               IPSR(3, 8, 2)
#define FUNC_HTX4_B                     IPSR(3, 8, 3)
#define FUNC_HSCK4                      IPSR(3, 8, 4)
#define FUNC_VI5_FIELD                  IPSR(3, 8, 5)
#define FUNC_SCL6_A                     IPSR(3, 8, 7)
#define FUNC_AVB_AVTP_CAPTURE_B         IPSR(3, 8, 8)
#define FUNC_PWM2_B                     IPSR(3, 8, 9)
#define FUNC_A12                        IPSR(3, 12, 0)
#define FUNC_LCDOUT12                   IPSR(3, 12, 1)
#define FUNC_MSIOF3_SCK_C               IPSR(3, 12, 2)
#define FUNC_HRX4_A                     IPSR(3, 12, 4)
#define FUNC_VI5_DATA8                  IPSR(3, 12, 5)
#define FUNC_DU_DG4                     IPSR(3, 12, 6)
#define FUNC_A13                        IPSR(3, 16, 0)
#define FUNC_LCDOUT13                   IPSR(3, 16, 1)
#define FUNC_MSIOF3_SYNC_C              IPSR(3, 16, 2)
#define FUNC_HTX4_A                     IPSR(3, 16, 4)
#define FUNC_VI5_DATA9                  IPSR(3, 16, 5)
#define FUNC_DU_DG5                     IPSR(3, 16, 6)
#define FUNC_A14                        IPSR(3, 20, 0)
#define FUNC_LCDOUT14                   IPSR(3, 20, 1)
#define FUNC_MSIOF3_RXD_C               IPSR(3, 20, 2)
#define FUNC_HCTS4_N                    IPSR(3, 20, 4)
#define FUNC_VI5_DATA10                 IPSR(3, 20, 5)
#define FUNC_DU_DG6                     IPSR(3, 20, 6)
#define FUNC_A15                        IPSR(3, 24, 0)
#define FUNC_LCDOUT15                   IPSR(3, 24, 1)
#define FUNC_MSIOF3_TXD_C               IPSR(3, 24, 2)
#define FUNC_HRTS4_N                    IPSR(3, 24, 4)
#define FUNC_VI5_DATA11                 IPSR(3, 24, 5)
#define FUNC_DU_DG7                     IPSR(3, 24, 6)
#define FUNC_A16                        IPSR(3, 28, 0)
#define FUNC_LCDOUT8                    IPSR(3, 28, 1)
#define FUNC_VI4_FIELD                  IPSR(3, 28, 4)
#define FUNC_DU_DG0                     IPSR(3, 28, 6)
#define FUNC_A17                        IPSR(4, 0, 0)
#define FUNC_LCDOUT9                    IPSR(4, 0, 1)
#define FUNC_VI4_VSYNC_N                IPSR(4, 0, 4)
#define FUNC_DU_DG1                     IPSR(4, 0, 6)
#define FUNC_A18                        IPSR(4, 4, 0)
#define FUNC_LCDOUT10                   IPSR(4, 4, 1)
#define FUNC_VI4_HSYNC_N                IPSR(4, 4, 4)
#define FUNC_DU_DG2                     IPSR(4, 4, 6)
#define FUNC_A19                        IPSR(4, 8, 0)
#define FUNC_LCDOUT11                   IPSR(4, 8, 1)
#define FUNC_VI4_CLKENB                 IPSR(4, 8, 4)
#define FUNC_DU_DG3                     IPSR(4, 8, 6)
#define FUNC_CS0_N                      IPSR(4, 12, 0)
#define FUNC_VI5_CLKENB                 IPSR(4, 12, 5)
#define FUNC_CS1_N                      IPSR(4, 16, 0)
#define FUNC_VI5_CLK                    IPSR(4, 16, 5)
#define FUNC_EX_WAIT0_B                 IPSR(4, 16, 7)
#define FUNC_BS_N                       IPSR(4, 20, 0)
#define FUNC_QSTVA_QVS                  IPSR(4, 20, 1)
#define FUNC_MSIOF3_SCK_D               IPSR(4, 20, 2)
#define FUNC_SCK3                       IPSR(4, 20, 3)
#define FUNC_HSCK3                      IPSR(4, 20, 4)
#define FUNC_CAN1_TX                    IPSR(4, 20, 8)
#define FUNC_CANFD1_TX                  IPSR(4, 20, 9)
#define FUNC_IETX_A                     IPSR(4, 20, 0xA)
#define FUNC_RD_N                       IPSR(4, 24, 0)
#define FUNC_MSIOF3_SYNC_D              IPSR(4, 24, 2)
#define FUNC_RX3_A                      IPSR(4, 24, 3)
#define FUNC_HRX3_A                     IPSR(4, 24, 4)
#define FUNC_CAN0_TX_A                  IPSR(4, 24, 8)
#define FUNC_CANFD0_TX_A                IPSR(4, 24, 9)
#define FUNC_RD_WR_N                    IPSR(4, 28, 0)
#define FUNC_MSIOF3_RXD_D               IPSR(4, 28, 2)
#define FUNC_TX3_A                      IPSR(4, 28, 3)
#define FUNC_HTX3_A                     IPSR(4, 28, 4)
#define FUNC_CAN0_RX_A                  IPSR(4, 28, 8)
#define FUNC_CANFD0_RX_A                IPSR(4, 28, 9)
#define FUNC_WE0_N                      IPSR(5, 0, 0)
#define FUNC_MSIOF3_TXD_D               IPSR(5, 0, 2)
#define FUNC_CTS3_N                     IPSR(5, 0, 3)
#define FUNC_HCTS3_N                    IPSR(5, 0, 4)
#define FUNC_SCL6_B                     IPSR(5, 0, 7)
#define FUNC_CAN_CLK                    IPSR(5, 0, 8)
#define FUNC_IECLK_A                    IPSR(5, 0, 0xA)
#define FUNC_WE1_N                      IPSR(5, 4, 0)
#define FUNC_MSIOF3_SS1_D               IPSR(5, 4, 2)
#define FUNC_RTS3_N                     IPSR(5, 4, 3)
#define FUNC_HRTS3_N                    IPSR(5, 4, 4)
#define FUNC_SDA6_B                     IPSR(5, 4, 7)
#define FUNC_CAN1_RX                    IPSR(5, 4, 8)
#define FUNC_CANFD1_RX                  IPSR(5, 4, 9)
#define FUNC_IERX_A                     IPSR(5, 4, 0xA)
#define FUNC_EX_WAIT0_A                 IPSR(5, 8, 0)
#define FUNC_QCLK                       IPSR(5, 8, 1)
#define FUNC_VI4_CLK                    IPSR(5, 8, 4)
#define FUNC_DU_DOTCLKOUT0              IPSR(5, 8, 6)
#define FUNC_D0                         IPSR(5, 12, 0)
#define FUNC_MSIOF2_SS1_B               IPSR(5, 12, 1)
#define FUNC_MSIOF3_SCK_A               IPSR(5, 12, 2)
#define FUNC_VI4_DATA16                 IPSR(5, 12, 4)
#define FUNC_VI5_DATA0                  IPSR(5, 12, 5)
#define FUNC_D1                         IPSR(5, 16, 0)
#define FUNC_MSIOF2_SS2_B               IPSR(5, 16, 1)
#define FUNC_MSIOF3_SYNC_A              IPSR(5, 16, 2)
#define FUNC_VI4_DATA17                 IPSR(5, 16, 4)
#define FUNC_VI5_DATA1                  IPSR(5, 16, 5)
#define FUNC_D2                         IPSR(5, 20, 0)
#define FUNC_MSIOF3_RXD_A               IPSR(5, 20, 2)
#define FUNC_VI4_DATA18                 IPSR(5, 20, 4)
#define FUNC_VI5_DATA2                  IPSR(5, 20, 5)
#define FUNC_D3                         IPSR(5, 24, 0)
#define FUNC_MSIOF3_TXD_A               IPSR(5, 24, 2)
#define FUNC_VI4_DATA19                 IPSR(5, 24, 4)
#define FUNC_VI5_DATA3                  IPSR(5, 24, 5)
#define FUNC_D4                         IPSR(5, 28, 0)
#define FUNC_MSIOF2_SCK_B               IPSR(5, 28, 1)
#define FUNC_VI4_DATA20                 IPSR(5, 28, 4)
#define FUNC_VI5_DATA4                  IPSR(5, 28, 5)
#define FUNC_D5                         IPSR(6, 0, 0)
#define FUNC_MSIOF2_SYNC_B              IPSR(6, 0, 1)
#define FUNC_VI4_DATA21                 IPSR(6, 0, 4)
#define FUNC_VI5_DATA5                  IPSR(6, 0, 5)
#define FUNC_D6                         IPSR(6, 4, 0)
#define FUNC_MSIOF2_RXD_B               IPSR(6, 4, 1)
#define FUNC_VI4_DATA22                 IPSR(6, 4, 4)
#define FUNC_VI5_DATA6                  IPSR(6, 4, 5)
#define FUNC_D7                         IPSR(6, 8, 0)
#define FUNC_MSIOF2_TXD_B               IPSR(6, 8, 1)
#define FUNC_VI4_DATA23                 IPSR(6, 8, 4)
#define FUNC_VI5_DATA7                  IPSR(6, 8, 5)
#define FUNC_D8                         IPSR(6, 12, 0)
#define FUNC_LCDOUT0                    IPSR(6, 12, 1)
#define FUNC_MSIOF2_SCK_D               IPSR(6, 12, 2)
#define FUNC_SCK4_C                     IPSR(6, 12, 3)
#define FUNC_VI4_DATA0_A                IPSR(6, 12, 4)
#define FUNC_DU_DR0                     IPSR(6, 12, 6)
#define FUNC_D9                         IPSR(6, 16, 0)
#define FUNC_LCDOUT1                    IPSR(6, 16, 1)
#define FUNC_MSIOF2_SYNC_D              IPSR(6, 16, 2)
#define FUNC_VI4_DATA1_A                IPSR(6, 16, 4)
#define FUNC_DU_DR1                     IPSR(6, 16, 6)
#define FUNC_D10                        IPSR(6, 20, 0)
#define FUNC_LCDOUT2                    IPSR(6, 20, 1)
#define FUNC_MSIOF2_RXD_D               IPSR(6, 20, 2)
#define FUNC_HRX3_B                     IPSR(6, 20, 3)
#define FUNC_VI4_DATA2_A                IPSR(6, 20, 4)
#define FUNC_CTS4_N_C                   IPSR(6, 20, 5)
#define FUNC_DU_DR2                     IPSR(6, 20, 6)
#define FUNC_D11                        IPSR(6, 24, 0)
#define FUNC_LCDOUT3                    IPSR(6, 24, 1)
#define FUNC_MSIOF2_TXD_D               IPSR(6, 24, 2)
#define FUNC_HTX3_B                     IPSR(6, 24, 3)
#define FUNC_VI4_DATA3_A                IPSR(6, 24, 4)
#define FUNC_RTS4_N_C                   IPSR(6, 24, 5)
#define FUNC_DU_DR3                     IPSR(6, 24, 6)
#define FUNC_D12                        IPSR(6, 28, 0)
#define FUNC_LCDOUT4                    IPSR(6, 28, 1)
#define FUNC_MSIOF2_SS1_D               IPSR(6, 28, 2)
#define FUNC_RX4_C                      IPSR(6, 28, 3)
#define FUNC_VI4_DATA4_A                IPSR(6, 28, 4)
#define FUNC_DU_DR4                     IPSR(6, 28, 6)
#define FUNC_D13                        IPSR(7, 0, 0)
#define FUNC_LCDOUT5                    IPSR(7, 0, 1)
#define FUNC_MSIOF2_SS2_D               IPSR(7, 0, 2)
#define FUNC_TX4_C                      IPSR(7, 0, 3)
#define FUNC_VI4_DATA5_A                IPSR(7, 0, 4)
#define FUNC_DU_DR5                     IPSR(7, 0, 6)
#define FUNC_D14                        IPSR(7, 4, 0)
#define FUNC_LCDOUT6                    IPSR(7, 4, 1)
#define FUNC_MSIOF3_SS1_A               IPSR(7, 4, 2)
#define FUNC_HRX3_C                     IPSR(7, 4, 3)
#define FUNC_VI4_DATA6_A                IPSR(7, 4, 4)
#define FUNC_DU_DR6                     IPSR(7, 4, 6)
#define FUNC_SCL6_C                     IPSR(7, 4, 7)
#define FUNC_D15                        IPSR(7, 8, 0)
#define FUNC_LCDOUT7                    IPSR(7, 8, 1)
#define FUNC_MSIOF3_SS2_A               IPSR(7, 8, 2)
#define FUNC_HTX3_C                     IPSR(7, 8, 3)
#define FUNC_VI4_DATA7_A                IPSR(7, 8, 4)
#define FUNC_DU_DR7                     IPSR(7, 8, 6)
#define FUNC_SDA6_C                     IPSR(7, 8, 7)
#define FUNC_SD0_CLK                    IPSR(7, 16, 0)
#define FUNC_MSIOF1_SCK_E               IPSR(7, 16, 2)
#define FUNC_STP_OPWM_0_B               IPSR(7, 16, 6)
#define FUNC_SD0_CMD                    IPSR(7, 20, 0)
#define FUNC_MSIOF1_SYNC_E              IPSR(7, 20, 2)
#define FUNC_STP_IVCXO27_0_B            IPSR(7, 20, 6)
#define FUNC_SD0_DAT0                   IPSR(7, 24, 0)
#define FUNC_MSIOF1_RXD_E               IPSR(7, 24, 2)
#define FUNC_TS_SCK0_B                  IPSR(7, 24, 5)
#define FUNC_STP_ISCLK_0_B              IPSR(7, 24, 6)
#define FUNC_SD0_DAT1                   IPSR(7, 28, 0)
#define FUNC_MSIOF1_TXD_E               IPSR(7, 28, 2)
#define FUNC_TS_SPSYNC0_B               IPSR(7, 28, 5)
#define FUNC_STP_ISSYNC_0_B             IPSR(7, 28, 6)
#define FUNC_SD0_DAT2                   IPSR(8, 0, 0)
#define FUNC_MSIOF1_SS1_E               IPSR(8, 0, 2)
#define FUNC_TS_SDAT0_B                 IPSR(8, 0, 5)
#define FUNC_STP_ISD_0_B                IPSR(8, 0, 6)
#define FUNC_SD0_DAT3                   IPSR(8, 4, 0)
#define FUNC_MSIOF1_SS2_E               IPSR(8, 4, 2)
#define FUNC_TS_SDEN0_B                 IPSR(8, 4, 5)
#define FUNC_STP_ISEN_0_B               IPSR(8, 4, 6)
#define FUNC_SD1_CLK                    IPSR(8, 8, 0)
#define FUNC_MSIOF1_SCK_G               IPSR(8, 8, 2)
#define FUNC_SIM0_CLK_A                 IPSR(8, 8, 5)
#define FUNC_SD1_CMD                    IPSR(8, 12, 0)
#define FUNC_MSIOF1_SYNC_G              IPSR(8, 12, 2)
#define FUNC_NFCE_N_B                   IPSR(8, 12, 3)
#define FUNC_SIM0_D_A                   IPSR(8, 12, 5)
#define FUNC_STP_IVCXO27_1_B            IPSR(8, 12, 6)
#define FUNC_SD1_DAT0                   IPSR(8, 16, 0)
#define FUNC_SD2_DAT4                   IPSR(8, 16, 1)
#define FUNC_MSIOF1_RXD_G               IPSR(8, 16, 2)
#define FUNC_NFWP_N_B                   IPSR(8, 16, 3)
#define FUNC_TS_SCK1_B                  IPSR(8, 16, 5)
#define FUNC_STP_ISCLK_1_B              IPSR(8, 16, 6)
#define FUNC_SD1_DAT1                   IPSR(8, 20, 0)
#define FUNC_SD2_DAT5                   IPSR(8, 20, 1)
#define FUNC_MSIOF1_TXD_G               IPSR(8, 20, 2)
#define FUNC_NFDATA14_B                 IPSR(8, 20, 3)
#define FUNC_TS_SPSYNC1_B               IPSR(8, 20, 5)
#define FUNC_STP_ISSYNC_1_B             IPSR(8, 20, 6)
#define FUNC_SD1_DAT2                   IPSR(8, 24, 0)
#define FUNC_SD2_DAT6                   IPSR(8, 24, 1)
#define FUNC_MSIOF1_SS1_G               IPSR(8, 24, 2)
#define FUNC_NFDATA15_B                 IPSR(8, 24, 3)
#define FUNC_TS_SDAT1_B                 IPSR(8, 24, 5)
#define FUNC_STP_ISD_1_B                IPSR(8, 24, 6)
#define FUNC_SD1_DAT3                   IPSR(8, 28, 0)
#define FUNC_SD2_DAT7                   IPSR(8, 28, 1)
#define FUNC_MSIOF1_SS2_G               IPSR(8, 28, 2)
#define FUNC_NFRB_N_B                   IPSR(8, 28, 3)
#define FUNC_TS_SDEN1_B                 IPSR(8, 28, 5)
#define FUNC_STP_ISEN_1_B               IPSR(8, 28, 6)
#define FUNC_SD2_CLK                    IPSR(9, 0, 0)
#define FUNC_NFDATA8                    IPSR(9, 0, 2)
#define FUNC_SD2_CMD                    IPSR(9, 4, 0)
#define FUNC_NFDATA9                    IPSR(9, 4, 2)
#define FUNC_SD2_DAT0                   IPSR(9, 8, 0)
#define FUNC_NFDATA10                   IPSR(9, 8, 2)
#define FUNC_SD2_DAT1                   IPSR(9, 12, 0)
#define FUNC_NFDATA11                   IPSR(9, 12, 2)
#define FUNC_SD2_DAT2                   IPSR(9, 16, 0)
#define FUNC_NFDATA12                   IPSR(9, 16, 2)
#define FUNC_SD2_DAT3                   IPSR(9, 20, 0)
#define FUNC_NFDATA13                   IPSR(9, 20, 2)
#define FUNC_SD2_DS                     IPSR(9, 24, 0)
#define FUNC_NFALE                      IPSR(9, 24, 2)
#define FUNC_SD3_CLK                    IPSR(9, 28, 0)
#define FUNC_NFWE_N                     IPSR(9, 28, 2)
#define FUNC_SD3_CMD                    IPSR(10, 0, 0)
#define FUNC_NFRE_N                     IPSR(10, 0, 2)
#define FUNC_SD3_DAT0                   IPSR(10, 4, 0)
#define FUNC_NFDATA0                    IPSR(10, 4, 2)
#define FUNC_SD3_DAT1                   IPSR(10, 8, 0)
#define FUNC_NFDATA1                    IPSR(10, 8, 2)
#define FUNC_SD3_DAT2                   IPSR(10, 12, 0)
#define FUNC_NFDATA2                    IPSR(10, 12, 2)
#define FUNC_SD3_DAT3                   IPSR(10, 16, 0)
#define FUNC_NFDATA3                    IPSR(10, 16, 2)
#define FUNC_SD3_DAT4                   IPSR(10, 20, 0)
#define FUNC_SD2_CD_A                   IPSR(10, 20, 1)
#define FUNC_NFDATA4                    IPSR(10, 20, 2)
#define FUNC_SD3_DAT5                   IPSR(10, 24, 0)
#define FUNC_SD2_WP_A                   IPSR(10, 24, 1)
#define FUNC_NFDATA5                    IPSR(10, 24, 2)
#define FUNC_SD3_DAT6                   IPSR(10, 28, 0)
#define FUNC_SD3_CD                     IPSR(10, 28, 1)
#define FUNC_NFDATA6                    IPSR(10, 28, 2)
#define FUNC_SD3_DAT7                   IPSR(11, 0, 0)
#define FUNC_SD3_WP                     IPSR(11, 0, 1)
#define FUNC_NFDATA7                    IPSR(11, 0, 2)
#define FUNC_SD3_DS                     IPSR(11, 4, 0)
#define FUNC_NFCLE                      IPSR(11, 4, 2)
#define FUNC_SD0_CD                     IPSR(11, 8, 0)
#define FUNC_NFDATA14_A                 IPSR(11, 8, 2)
#define FUNC_SCL2_B                     IPSR(11, 8, 4)
#define FUNC_SIM0_RST_A                 IPSR(11, 8, 5)
#define FUNC_SD0_WP                     IPSR(11, 12, 0)
#define FUNC_NFDATA15_A                 IPSR(11, 12, 2)
#define FUNC_SDA2_B                     IPSR(11, 12, 4)
#define FUNC_SD1_CD                     IPSR(11, 16, 0)
#define FUNC_NFRB_N_A                   IPSR(11, 16, 2)
#define FUNC_SIM0_CLK_B                 IPSR(11, 16, 5)
#define FUNC_SD1_WP                     IPSR(11, 20, 0)
#define FUNC_NFCE_N_A                   IPSR(11, 20, 2)
#define FUNC_SIM0_D_B                   IPSR(11, 20, 5)
#define FUNC_SCK0                       IPSR(11, 24, 0)
#define FUNC_HSCK1_B                    IPSR(11, 24, 1)
#define FUNC_MSIOF1_SS2_B               IPSR(11, 24, 2)
#define FUNC_AUDIO_CLKC_B               IPSR(11, 24, 3)
#define FUNC_SDA2_A                     IPSR(11, 24, 4)
#define FUNC_SIM0_RST_B                 IPSR(11, 24, 5)
#define FUNC_STP_OPWM_0_C               IPSR(11, 24, 6)
#define FUNC_RIF0_CLK_B                 IPSR(11, 24, 7)
#define FUNC_ADICHS2                    IPSR(11, 24, 9)
#define FUNC_SCK5_B                     IPSR(11, 24, 0xA)
#define FUNC_RX0                        IPSR(11, 28, 0)
#define FUNC_HRX1_B                     IPSR(11, 28, 1)
#define FUNC_TS_SCK0_C                  IPSR(11, 28, 5)
#define FUNC_STP_ISCLK_0_C              IPSR(11, 28, 6)
#define FUNC_RIF0_D0_B                  IPSR(11, 28, 7)
#define FUNC_TX0                        IPSR(12, 0, 0)
#define FUNC_HTX1_B                     IPSR(12, 0, 1)
#define FUNC_TS_SPSYNC0_C               IPSR(12, 0, 5)
#define FUNC_STP_ISSYNC_0_C             IPSR(12, 0, 6)
#define FUNC_RIF0_D1_B                  IPSR(12, 0, 7)
#define FUNC_CTS0_N                     IPSR(12, 4, 0)
#define FUNC_HCTS1_N_B                  IPSR(12, 4, 1)
#define FUNC_MSIOF1_SYNC_B              IPSR(12, 4, 2)
#define FUNC_TS_SPSYNC1_C               IPSR(12, 4, 5)
#define FUNC_STP_ISSYNC_1_C             IPSR(12, 4, 6)
#define FUNC_RIF1_SYNC_B                IPSR(12, 4, 7)
#define FUNC_AUDIO_CLKOUT_C             IPSR(12, 4, 8)
#define FUNC_ADICS_SAMP                 IPSR(12, 4, 9)
#define FUNC_RTS0_N                     IPSR(12, 8, 0)
#define FUNC_HRTS1_N_B                  IPSR(12, 8, 1)
#define FUNC_MSIOF1_SS1_B               IPSR(12, 8, 2)
#define FUNC_AUDIO_CLKA_B               IPSR(12, 8, 3)
#define FUNC_SCL2_A                     IPSR(12, 8, 4)
#define FUNC_STP_IVCXO27_1_C            IPSR(12, 8, 6)
#define FUNC_RIF0_SYNC_B                IPSR(12, 8, 7)
#define FUNC_ADICHS1                    IPSR(12, 8, 9)
#define FUNC_RX1_A                      IPSR(12, 12, 0)
#define FUNC_HRX1_A                     IPSR(12, 12, 1)
#define FUNC_TS_SDAT0_C                 IPSR(12, 12, 5)
#define FUNC_STP_ISD_0_C                IPSR(12, 12, 6)
#define FUNC_RIF1_CLK_C                 IPSR(12, 12, 7)
#define FUNC_TX1_A                      IPSR(12, 16, 0)
#define FUNC_HTX1_A                     IPSR(12, 16, 1)
#define FUNC_TS_SDEN0_C                 IPSR(12, 16, 5)
#define FUNC_STP_ISEN_0_C               IPSR(12, 16, 6)
#define FUNC_RIF1_D0_C                  IPSR(12, 16, 7)
#define FUNC_CTS1_N                     IPSR(12, 20, 0)
#define FUNC_HCTS1_N_A                  IPSR(12, 20, 1)
#define FUNC_MSIOF1_RXD_B               IPSR(12, 20, 2)
#define FUNC_TS_SDEN1_C                 IPSR(12, 20, 5)
#define FUNC_STP_ISEN_1_C               IPSR(12, 20, 6)
#define FUNC_RIF1_D0_B                  IPSR(12, 20, 7)
#define FUNC_ADIDATA                    IPSR(12, 20, 9)
#define FUNC_RTS1_N                     IPSR(12, 24, 0)
#define FUNC_HRTS1_N_A                  IPSR(12, 24, 1)
#define FUNC_MSIOF1_TXD_B               IPSR(12, 24, 2)
#define FUNC_TS_SDAT1_C                 IPSR(12, 24, 5)
#define FUNC_STP_ISD_1_C                IPSR(12, 24, 6)
#define FUNC_RIF1_D1_B                  IPSR(12, 24, 7)
#define FUNC_ADICHS0                    IPSR(12, 24, 9)
#define FUNC_SCK2                       IPSR(12, 28, 0)
#define FUNC_SCIF_CLK_B                 IPSR(12, 28, 1)
#define FUNC_MSIOF1_SCK_B               IPSR(12, 28, 2)
#define FUNC_TS_SCK1_C                  IPSR(12, 28, 5)
#define FUNC_STP_ISCLK_1_C              IPSR(12, 28, 6)
#define FUNC_RIF1_CLK_B                 IPSR(12, 28, 7)
#define FUNC_ADICLK                     IPSR(12, 28, 9)
#define FUNC_TX2_A                      IPSR(13, 0, 0)
#define FUNC_SD2_CD_B                   IPSR(13, 0, 3)
#define FUNC_SCL1_A                     IPSR(13, 0, 4)
#define FUNC_FMCLK_A                    IPSR(13, 0, 6)
#define FUNC_RIF1_D1_C                  IPSR(13, 0, 7)
#define FUNC_FSO_CFE_0_N                IPSR(13, 0, 9)
#define FUNC_RX2_A                      IPSR(13, 4, 0)
#define FUNC_SD2_WP_B                   IPSR(13, 4, 3)
#define FUNC_SDA1_A                     IPSR(13, 4, 4)
#define FUNC_FMIN_A                     IPSR(13, 4, 6)
#define FUNC_RIF1_SYNC_C                IPSR(13, 4, 7)
#define FUNC_FSO_CFE_1_N                IPSR(13, 4, 9)
#define FUNC_HSCK0                      IPSR(13, 8, 0)
#define FUNC_MSIOF1_SCK_D               IPSR(13, 8, 2)
#define FUNC_AUDIO_CLKB_A               IPSR(13, 8, 3)
#define FUNC_SSI_SDATA1_B               IPSR(13, 8, 4)
#define FUNC_TS_SCK0_D                  IPSR(13, 8, 5)
#define FUNC_STP_ISCLK_0_D              IPSR(13, 8, 6)
#define FUNC_RIF0_CLK_C                 IPSR(13, 8, 7)
#define FUNC_RX5_B                      IPSR(13, 8, 0xA)
#define FUNC_HRX0                       IPSR(13, 12, 0)
#define FUNC_MSIOF1_RXD_D               IPSR(13, 12, 2)
#define FUNC_SSI_SDATA2_B               IPSR(13, 12, 4)
#define FUNC_TS_SDEN0_D                 IPSR(13, 12, 5)
#define FUNC_STP_ISEN_0_D               IPSR(13, 12, 6)
#define FUNC_RIF0_D0_C                  IPSR(13, 12, 7)
#define FUNC_HTX0                       IPSR(13, 16, 0)
#define FUNC_MSIOF1_TXD_D               IPSR(13, 16, 2)
#define FUNC_SSI_SDATA9_B               IPSR(13, 16, 4)
#define FUNC_TS_SDAT0_D                 IPSR(13, 16, 5)
#define FUNC_STP_ISD_0_D                IPSR(13, 16, 6)
#define FUNC_RIF0_D1_C                  IPSR(13, 16, 7)
#define FUNC_HCTS0_N                    IPSR(13, 20, 0)
#define FUNC_RX2_B                      IPSR(13, 20, 1)
#define FUNC_MSIOF1_SYNC_D              IPSR(13, 20, 2)
#define FUNC_SSI_SCK9_A                 IPSR(13, 20, 4)
#define FUNC_TS_SPSYNC0_D               IPSR(13, 20, 5)
#define FUNC_STP_ISSYNC_0_D             IPSR(13, 20, 6)
#define FUNC_RIF0_SYNC_C                IPSR(13, 20, 7)
#define FUNC_AUDIO_CLKOUT1_A            IPSR(13, 20, 8)
#define FUNC_HRTS0_N                    IPSR(13, 24, 0)
#define FUNC_TX2_B                      IPSR(13, 24, 1)
#define FUNC_MSIOF1_SS1_D               IPSR(13, 24, 2)
#define FUNC_SSI_WS9_A                  IPSR(13, 24, 4)
#define FUNC_STP_IVCXO27_0_D            IPSR(13, 24, 6)
#define FUNC_BPFCLK_A                   IPSR(13, 24, 7)
#define FUNC_AUDIO_CLKOUT2_A            IPSR(13, 24, 8)
#define FUNC_MSIOF0_SYNC                IPSR(13, 28, 0)
#define FUNC_AUDIO_CLKOUT_A             IPSR(13, 28, 8)
#define FUNC_TX5_B                      IPSR(13, 28, 0xA)
#define FUNC_BPFCLK_D                   IPSR(13, 28, 0xD)
#define FUNC_MSIOF0_SS1                 IPSR(14, 0, 0)
#define FUNC_RX5_A                      IPSR(14, 0, 1)
#define FUNC_NFWP_N_A                   IPSR(14, 0, 2)
#define FUNC_AUDIO_CLKA_C               IPSR(14, 0, 3)
#define FUNC_SSI_SCK2_A                 IPSR(14, 0, 4)
#define FUNC_STP_IVCXO27_0_C            IPSR(14, 0, 6)
#define FUNC_AUDIO_CLKOUT3_A            IPSR(14, 0, 8)
#define FUNC_TCLK1_B                    IPSR(14, 0, 0xA)
#define FUNC_MSIOF0_SS2                 IPSR(14, 4, 0)
#define FUNC_TX5_A                      IPSR(14, 4, 1)
#define FUNC_MSIOF1_SS2_D               IPSR(14, 4, 2)
#define FUNC_AUDIO_CLKC_A               IPSR(14, 4, 3)
#define FUNC_SSI_WS2_A                  IPSR(14, 4, 4)
#define FUNC_STP_OPWM_0_D               IPSR(14, 4, 6)
#define FUNC_AUDIO_CLKOUT_D             IPSR(14, 4, 8)
#define FUNC_SPEEDIN_B                  IPSR(14, 4, 0xA)
#define FUNC_MLB_CLK                    IPSR(14, 8, 0)
#define FUNC_MSIOF1_SCK_F               IPSR(14, 8, 2)
#define FUNC_SCL1_B                     IPSR(14, 8, 4)
#define FUNC_MLB_SIG                    IPSR(14, 12, 0)
#define FUNC_RX1_B                      IPSR(14, 12, 1)
#define FUNC_MSIOF1_SYNC_F              IPSR(14, 12, 2)
#define FUNC_SDA1_B                     IPSR(14, 12, 4)
#define FUNC_MLB_DAT                    IPSR(14, 16, 0)
#define FUNC_TX1_B                      IPSR(14, 16, 1)
#define FUNC_MSIOF1_RXD_F               IPSR(14, 16, 2)
#define FUNC_SSI_SCK01239               IPSR(14, 20, 0)
#define FUNC_MSIOF1_TXD_F               IPSR(14, 20, 2)
#define FUNC_SSI_WS01239                IPSR(14, 24, 0)
#define FUNC_MSIOF1_SS1_F               IPSR(14, 24, 2)
#define FUNC_SSI_SDATA0                 IPSR(14, 28, 0)
#define FUNC_MSIOF1_SS2_F               IPSR(14, 28, 2)
#define FUNC_SSI_SDATA1_A               IPSR(15, 0, 0)
#define FUNC_SSI_SDATA2_A               IPSR(15, 4, 0)
#define FUNC_SSI_SCK1_B                 IPSR(15, 4, 4)
#define FUNC_SSI_SCK349                 IPSR(15, 8, 0)
#define FUNC_MSIOF1_SS1_A               IPSR(15, 8, 2)
#define FUNC_STP_OPWM_0_A               IPSR(15, 8, 6)
#define FUNC_SSI_WS349                  IPSR(15, 12, 0)
#define FUNC_HCTS2_N_A                  IPSR(15, 12, 1)
#define FUNC_MSIOF1_SS2_A               IPSR(15, 12, 2)
#define FUNC_STP_IVCXO27_0_A            IPSR(15, 12, 6)
#define FUNC_SSI_SDATA3                 IPSR(15, 16, 0)
#define FUNC_HRTS2_N_A                  IPSR(15, 16, 1)
#define FUNC_MSIOF1_TXD_A               IPSR(15, 16, 2)
#define FUNC_TS_SCK0_A                  IPSR(15, 16, 5)
#define FUNC_STP_ISCLK_0_A              IPSR(15, 16, 6)
#define FUNC_RIF0_D1_A                  IPSR(15, 16, 7)
#define FUNC_RIF2_D0_A                  IPSR(15, 16, 8)
#define FUNC_SSI_SCK4                   IPSR(15, 20, 0)
#define FUNC_HRX2_A                     IPSR(15, 20, 1)
#define FUNC_MSIOF1_SCK_A               IPSR(15, 20, 2)
#define FUNC_TS_SDAT0_A                 IPSR(15, 20, 5)
#define FUNC_STP_ISD_0_A                IPSR(15, 20, 6)
#define FUNC_RIF0_CLK_A                 IPSR(15, 20, 7)
#define FUNC_RIF2_CLK_A                 IPSR(15, 20, 8)
#define FUNC_SSI_WS4                    IPSR(15, 24, 0)
#define FUNC_HTX2_A                     IPSR(15, 24, 1)
#define FUNC_MSIOF1_SYNC_A              IPSR(15, 24, 2)
#define FUNC_TS_SDEN0_A                 IPSR(15, 24, 5)
#define FUNC_STP_ISEN_0_A               IPSR(15, 24, 6)
#define FUNC_RIF0_SYNC_A                IPSR(15, 24, 7)
#define FUNC_RIF2_SYNC_A                IPSR(15, 24, 8)
#define FUNC_SSI_SDATA4                 IPSR(15, 28, 0)
#define FUNC_HSCK2_A                    IPSR(15, 28, 1)
#define FUNC_MSIOF1_RXD_A               IPSR(15, 28, 2)
#define FUNC_TS_SPSYNC0_A               IPSR(15, 28, 5)
#define FUNC_STP_ISSYNC_0_A             IPSR(15, 28, 6)
#define FUNC_RIF0_D0_A                  IPSR(15, 28, 7)
#define FUNC_RIF2_D1_A                  IPSR(15, 28, 8)
#define FUNC_SSI_SCK6                   IPSR(16, 0, 0)
#define FUNC_SIM0_RST_D                 IPSR(16, 0, 3)
#define FUNC_SSI_WS6                    IPSR(16, 4, 0)
#define FUNC_SIM0_D_D                   IPSR(16, 4, 3)
#define FUNC_SSI_SDATA6                 IPSR(16, 8, 0)
#define FUNC_SIM0_CLK_D                 IPSR(16, 8, 3)
#define FUNC_SSI_SCK78                  IPSR(16, 12, 0)
#define FUNC_HRX2_B                     IPSR(16, 12, 1)
#define FUNC_MSIOF1_SCK_C               IPSR(16, 12, 2)
#define FUNC_TS_SCK1_A                  IPSR(16, 12, 5)
#define FUNC_STP_ISCLK_1_A              IPSR(16, 12, 6)
#define FUNC_RIF1_CLK_A                 IPSR(16, 12, 7)
#define FUNC_RIF3_CLK_A                 IPSR(16, 12, 8)
#define FUNC_SSI_WS78                   IPSR(16, 16, 0)
#define FUNC_HTX2_B                     IPSR(16, 16, 1)
#define FUNC_MSIOF1_SYNC_C              IPSR(16, 16, 2)
#define FUNC_TS_SDAT1_A                 IPSR(16, 16, 5)
#define FUNC_STP_ISD_1_A                IPSR(16, 16, 6)
#define FUNC_RIF1_SYNC_A                IPSR(16, 16, 7)
#define FUNC_RIF3_SYNC_A                IPSR(16, 16, 8)
#define FUNC_SSI_SDATA7                 IPSR(16, 20, 0)
#define FUNC_HCTS2_N_B                  IPSR(16, 20, 1)
#define FUNC_MSIOF1_RXD_C               IPSR(16, 20, 2)
#define FUNC_TS_SDEN1_A                 IPSR(16, 20, 5)
#define FUNC_STP_ISEN_1_A               IPSR(16, 20, 6)
#define FUNC_RIF1_D0_A                  IPSR(16, 20, 7)
#define FUNC_RIF3_D0_A                  IPSR(16, 20, 8)
#define FUNC_TCLK2_A                    IPSR(16, 20, 0xA)
#define FUNC_SSI_SDATA8                 IPSR(16, 24, 0)
#define FUNC_HRTS2_N_B                  IPSR(16, 24, 1)
#define FUNC_MSIOF1_TXD_C               IPSR(16, 24, 2)
#define FUNC_TS_SPSYNC1_A               IPSR(16, 24, 5)
#define FUNC_STP_ISSYNC_1_A             IPSR(16, 24, 6)
#define FUNC_RIF1_D1_A                  IPSR(16, 24, 7)
#define FUNC_RIF3_D1_A                  IPSR(16, 24, 8)
#define FUNC_SSI_SDATA9_A               IPSR(16, 28, 0)
#define FUNC_HSCK2_B                    IPSR(16, 28, 1)
#define FUNC_MSIOF1_SS1_C               IPSR(16, 28, 2)
#define FUNC_HSCK1_A                    IPSR(16, 28, 3)
#define FUNC_SSI_WS1_B                  IPSR(16, 28, 4)
#define FUNC_SCK1                       IPSR(16, 28, 5)
#define FUNC_STP_IVCXO27_1_A            IPSR(16, 28, 6)
#define FUNC_SCK5_A                     IPSR(16, 28, 7)
#define FUNC_AUDIO_CLKA_A               IPSR(17, 0, 0)
#define FUNC_AUDIO_CLKB_B               IPSR(17, 4, 0)
#define FUNC_SCIF_CLK_A                 IPSR(17, 4, 1)
#define FUNC_STP_IVCXO27_1_D            IPSR(17, 4, 6)
#define FUNC_REMOCON_A                  IPSR(17, 4, 7)
#define FUNC_TCLK1_A                    IPSR(17, 4, 0xA)
#define FUNC_USB0_PWEN                  IPSR(17, 8, 0)
#define FUNC_SIM0_RST_C                 IPSR(17, 8, 3)
#define FUNC_TS_SCK1_D                  IPSR(17, 8, 5)
#define FUNC_STP_ISCLK_1_D              IPSR(17, 8, 6)
#define FUNC_BPFCLK_B                   IPSR(17, 8, 7)
#define FUNC_RIF3_CLK_B                 IPSR(17, 8, 8)
#define FUNC_HSCK2_C                    IPSR(17, 8, 0xD)
#define FUNC_USB0_OVC                   IPSR(17, 12, 0)
#define FUNC_SIM0_D_C                   IPSR(17, 12, 3)
#define FUNC_TS_SDAT1_D                 IPSR(17, 12, 5)
#define FUNC_STP_ISD_1_D                IPSR(17, 12, 6)
#define FUNC_RIF3_SYNC_B                IPSR(17, 12, 8)
#define FUNC_HRX2_C                     IPSR(17, 12, 0xD)
#define FUNC_USB1_PWEN                  IPSR(17, 16, 0)
#define FUNC_SIM0_CLK_C                 IPSR(17, 16, 3)
#define FUNC_SSI_SCK1_A                 IPSR(17, 16, 4)
#define FUNC_TS_SCK0_E                  IPSR(17, 16, 5)
#define FUNC_STP_ISCLK_0_E              IPSR(17, 16, 6)
#define FUNC_FMCLK_B                    IPSR(17, 16, 7)
#define FUNC_RIF2_CLK_B                 IPSR(17, 16, 8)
#define FUNC_SPEEDIN_A                  IPSR(17, 16, 0xA)
#define FUNC_HTX2_C                     IPSR(17, 16, 0xD)
#define FUNC_USB1_OVC                   IPSR(17, 20, 0)
#define FUNC_MSIOF1_SS2_C               IPSR(17, 20, 2)
#define FUNC_SSI_WS1_A                  IPSR(17, 20, 4)
#define FUNC_TS_SDAT0_E                 IPSR(17, 20, 5)
#define FUNC_STP_ISD_0_E                IPSR(17, 20, 6)
#define FUNC_FMIN_B                     IPSR(17, 20, 7)
#define FUNC_RIF2_SYNC_B                IPSR(17, 20, 8)
#define FUNC_REMOCON_B                  IPSR(17, 20, 0xA)
#define FUNC_HCTS2_N_C                  IPSR(17, 20, 0xD)
#define FUNC_USB30_PWEN                 IPSR(17, 24, 0)
#define FUNC_AUDIO_CLKOUT_B             IPSR(17, 24, 3)
#define FUNC_SSI_SCK2_B                 IPSR(17, 24, 4)
#define FUNC_TS_SDEN1_D                 IPSR(17, 24, 5)
#define FUNC_STP_ISEN_1_D               IPSR(17, 24, 6)
#define FUNC_STP_OPWM_0_E               IPSR(17, 24, 7)
#define FUNC_RIF3_D0_B                  IPSR(17, 24, 8)
#define FUNC_TCLK2_B                    IPSR(17, 24, 0xA)
#define FUNC_TPU0TO0                    IPSR(17, 24, 0xB)
#define FUNC_BPFCLK_C                   IPSR(17, 24, 0xC)
#define FUNC_HRTS2_N_C                  IPSR(17, 24, 0xD)
#define FUNC_USB30_OVC                  IPSR(17, 28, 0)
#define FUNC_AUDIO_CLKOUT1_B            IPSR(17, 28, 3)
#define FUNC_SSI_WS2_B                  IPSR(17, 28, 4)
#define FUNC_TS_SPSYNC1_D               IPSR(17, 28, 5)
#define FUNC_STP_ISSYNC_1_D             IPSR(17, 28, 6)
#define FUNC_STP_IVCXO27_0_E            IPSR(17, 28, 7)
#define FUNC_RIF3_D1_B                  IPSR(17, 28, 8)
#define FUNC_FSO_TOE_N                  IPSR(17, 28, 0xA)
#define FUNC_TPU0TO1                    IPSR(17, 28, 0xB)
#define FUNC_GP6_30                     IPSR(18, 0, 0)
#define FUNC_AUDIO_CLKOUT2_B            IPSR(18, 0, 3)
#define FUNC_SSI_SCK9_B                 IPSR(18, 0, 4)
#define FUNC_TS_SDEN0_E                 IPSR(18, 0, 5)
#define FUNC_STP_ISEN_0_E               IPSR(18, 0, 6)
#define FUNC_RIF2_D0_B                  IPSR(18, 0, 8)
#define FUNC_TPU0TO2                    IPSR(18, 0, 0xB)
#define FUNC_FMCLK_C                    IPSR(18, 0, 0xC)
#define FUNC_FMCLK_D                    IPSR(18, 0, 0xD)
#define FUNC_GP6_31                     IPSR(18, 4, 0)
#define FUNC_AUDIO_CLKOUT3_B            IPSR(18, 4, 3)
#define FUNC_SSI_WS9_B                  IPSR(18, 4, 4)
#define FUNC_TS_SPSYNC0_E               IPSR(18, 4, 5)
#define FUNC_STP_ISSYNC_0_E             IPSR(18, 4, 6)
#define FUNC_RIF2_D1_B                  IPSR(18, 4, 8)
#define FUNC_TPU0TO3                    IPSR(18, 4, 0xB)
#define FUNC_FMIN_C                     IPSR(18, 4, 0xC)
#define FUNC_FMIN_D                     IPSR(18, 4, 0xD)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_RENESAS_PINCTRL_R8A77961_H_ */
