/*
 * Copyright (c) 2024 Renesas Electronics Corporation
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_PINCTRL_RX_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_PINCTRL_RX_H_

#define RX_PORT_NUM_POS  0
#define RX_PORT_NUM_MASK 0x1f

#define RX_PIN_NUM_POS  5
#define RX_PIN_NUM_MASK 0xf

#define RX_PSEL_MASK 0x1f
#define RX_PSEL_POS  9

#define RX_PSEL_RSCI      0xA
#define RX_PSEL_RSCI_TXDB 0xC
#define RX_PSEL_SCI_1     0xA
#define RX_PSEL_SCI_5     0xA
#define RX_PSEL_SCI_6     0xB
#define RX_PSEL_SCI_12    0xC
#define RX_PSEL_TMR       0x5
#define RX_PSEL_POE       0x7
#define RX_PSEL_ADC       0x0
#define RX_PSEL_LVD       0x0

/* P0nPFS */
#define RX_PSEL_P0nPFS_HIZ    0x0
#define RX_PSEL_P0nPFS_ADTRG0 0x1

/* P1nPFS */
#define RX_PSEL_P1nPFS_MTIOC0B 0x01
#define RX_PSEL_P1nPFS_MTIOC3A 0x01
#define RX_PSEL_P1nPFS_MTIOC3C 0x01

#define RX_PSEL_P1nPFS_MTCLKA  0x02
#define RX_PSEL_P1nPFS_MTCLKB  0x02
#define RX_PSEL_P1nPFS_MTIOC3B 0x02
#define RX_PSEL_P1nPFS_MTIOC3D 0x02

#define RX_PSEL_P1nPFS_TMCI1 0x5
#define RX_PSEL_P1nPFS_TMO1  0x5
#define RX_PSEL_P1nPFS_TMCI2 0x5
#define RX_PSEL_P1nPFS_TMO2  0x5
#define RX_PSEL_P1nPFS_TMRI2 0x5
#define RX_PSEL_P1nPFS_TMO3  0x5

#define RX_PSEL_P1nPFS_RTCOUT 0x7
#define RX_PSEL_P1nPFS_POE8   0x7

#define RX_PSEL_P1nPFS_ADTRG0 0x9

#define RX_PSEL_P1nPFS_RXD1   0xA
#define RX_PSEL_P1nPFS_SMISO1 0xA
#define RX_PSEL_P1nPFS_SSCL1  0xA
#define RX_PSEL_P1nPFS_TXD1   0xA
#define RX_PSEL_P1nPFS_SMOSI1 0xA
#define RX_PSEL_P1nPFS_SSDA1  0xA

#define RX_PSEL_P1nPFS_CTS1 0xB
#define RX_PSEL_P1nPFS_RTS1 0xB
#define RX_PSEL_P1nPFS_SS1  0xB

#define RX_PSEL_P1nPFS_MOSIA 0xD
#define RX_PSEL_P1nPFS_MISOA 0xD

#define RX_PSEL_P1nPFS_SCL 0xF
#define RX_PSEL_P1nPFS_SDA 0xF

#define RX_PSEL_P1nPFS_TS5 0x19
#define RX_PSEL_P1nPFS_TS6 0x19

/* P2nPFS */
#define RX_PSEL_P2nPFS_MTIOC1A 0x01
#define RX_PSEL_P2nPFS_MTIOC1B 0x01
#define RX_PSEL_P2nPFS_MTIOC2A 0x01
#define RX_PSEL_P2nPFS_MTIOC2B 0x01
#define RX_PSEL_P2nPFS_MTIOC3B 0x01
#define RX_PSEL_P2nPFS_MTIOC3D 0x01
#define RX_PSEL_P2nPFS_MTIOC4A 0x01
#define RX_PSEL_P2nPFS_MTIOC4C 0x01

#define RX_PSEL_P2nPFS_MTCLKA 0x02
#define RX_PSEL_P2nPFS_MTCLKB 0x02
#define RX_PSEL_P2nPFS_MTCLKC 0x02
#define RX_PSEL_P2nPFS_MTCLKD 0x02

#define RX_PSEL_P2nPFS_TMCI0 0x5
#define RX_PSEL_P2nPFS_TMO0  0x5
#define RX_PSEL_P2nPFS_TMRI0 0x5
#define RX_PSEL_P2nPFS_TMO1  0x5
#define RX_PSEL_P2nPFS_TMRI1 0x5
#define RX_PSEL_P2nPFS_TMCI3 0x5

#define RX_PSEL_P2nPFS_ADTRG0 0x9

#define RX_PSEL_P2nPFS_RXD0   0xA
#define RX_PSEL_P2nPFS_SMISO0 0xA
#define RX_PSEL_P2nPFS_SSCL0  0xA
#define RX_PSEL_P2nPFS_TXD0   0xA
#define RX_PSEL_P2nPFS_SMOSI0 0xA
#define RX_PSEL_P2nPFS_SSDA0  0xA
#define RX_PSEL_P2nPFS_SCK0   0xA
#define RX_PSEL_P2nPFS_TXD1   0xA
#define RX_PSEL_P2nPFS_SMOSI1 0xA
#define RX_PSEL_P2nPFS_SSDA1  0xA
#define RX_PSEL_P2nPFS_SCK1   0xA

#define RX_PSEL_P2nPFS_CTS0 0xB
#define RX_PSEL_P2nPFS_RTS0 0xB
#define RX_PSEL_P2nPFS_SS0  0xB

#define RX_PSEL_P2nPFS_TS3 0x19
#define RX_PSEL_P2nPFS_TS4 0x19

/* P3nPFS */
#define RX_PSEL_P3nPFS_MTIOC0A 0x01
#define RX_PSEL_P3nPFS_MTIOC0C 0x01
#define RX_PSEL_P3nPFS_MTIOC0D 0x01
#define RX_PSEL_P3nPFS_MTIOC4B 0x01
#define RX_PSEL_P3nPFS_MTIOC4D 0x01

#define RX_PSEL_P3nPFS_TMCI2 0x5
#define RX_PSEL_P3nPFS_TMO3  0x5
#define RX_PSEL_P3nPFS_TMRI3 0x5
#define RX_PSEL_P3nPFS_TMCI3 0x5

#define RX_PSEL_P3nPFS_RTCOUT 0x7
#define RX_PSEL_P3nPFS_POE2   0x7
#define RX_PSEL_P3nPFS_POE3   0x7
#define RX_PSEL_P3nPFS_POE8   0x7

#define RX_PSEL_P3nPFS_RXD1   0xA
#define RX_PSEL_P3nPFS_SMISO1 0xA
#define RX_PSEL_P3nPFS_SSCL1  0xA

#define RX_PSEL_P3nPFS_CTS1   0xB
#define RX_PSEL_P3nPFS_RTS1   0xB
#define RX_PSEL_P3nPFS_SS1    0xB
#define RX_PSEL_P3nPFS_RXD6   0xB
#define RX_PSEL_P3nPFS_SMISO6 0xB
#define RX_PSEL_P3nPFS_SSCL6  0xB
#define RX_PSEL_P3nPFS_TXD6   0xB
#define RX_PSEL_P3nPFS_SMOSI6 0xB
#define RX_PSEL_P3nPFS_SSDA6  0xB
#define RX_PSEL_P3nPFS_SCK6   0xB

#define RX_PSEL_P3nPFS_TS0 0x19
#define RX_PSEL_P3nPFS_TS1 0x19
#define RX_PSEL_P3nPFS_TS2 0x19

/* P5nPFS */
#define RX_PSEL_P5nPFS_MTIOC4B 0x01
#define RX_PSEL_P5nPFS_MTIOC4D 0x01

#define RX_PSEL_P5nPFS_TMCI1 0x5
#define RX_PSEL_P5nPFS_TMO3  0x5

#define RX_PSEL_P5nPFS_TS11 0x19
#define RX_PSEL_P5nPFS_TS12 0x19

#define RX_PSEL_P5nPFS_PMC0 0x19
#define RX_PSEL_P5nPFS_PMC1 0x19

/* PAnPFS */
#define RX_PSEL_PAnPFS_MTIOC4A 0x01
#define RX_PSEL_PAnPFS_MTIOC0B 0x01
#define RX_PSEL_PAnPFS_MTIOC0D 0x01
#define RX_PSEL_PAnPFS_MTIOC5U 0x01
#define RX_PSEL_PAnPFS_MTIOC5V 0x01

#define RX_PSEL_PAnPFS_MTCLKA 0x02
#define RX_PSEL_PAnPFS_MTCLKB 0x02
#define RX_PSEL_PAnPFS_MTCLKC 0x02
#define RX_PSEL_PAnPFS_MTCLKD 0x02

#define RX_PSEL_PAnPFS_TMRI0 0x5
#define RX_PSEL_PAnPFS_TMCI3 0x5

#define RX_PSEL_PAnPFS_POE2   0x7
#define RX_PSEL_PAnPFS_CACREF 0x7

#define RX_PSEL_PAnPFS_RXD5   0xA
#define RX_PSEL_PAnPFS_SMISO5 0xA
#define RX_PSEL_PAnPFS_SSCL5  0xA
#define RX_PSEL_PAnPFS_TXD5   0xA
#define RX_PSEL_PAnPFS_SMOSI5 0xA
#define RX_PSEL_PAnPFS_SSDA5  0xA
#define RX_PSEL_PAnPFS_SCK5   0xA

#define RX_PSEL_PAnPFS_CTS5 0xB
#define RX_PSEL_PAnPFS_RTS5 0xB
#define RX_PSEL_PAnPFS_SS5  0xB

#define RX_PSEL_PAnPFS_SSLA0  0xD
#define RX_PSEL_PAnPFS_SSLA1  0xD
#define RX_PSEL_PAnPFS_SSLA2  0xD
#define RX_PSEL_PAnPFS_SSLA3  0xD
#define RX_PSEL_PAnPFS_RSPCKA 0xD
#define RX_PSEL_PAnPFS_MOSIA  0xD
#define RX_PSEL_PAnPFS_MISOA  0xD

#define RX_PSEL_PAnPFS_TS26 0x19
#define RX_PSEL_PAnPFS_TS27 0x19
#define RX_PSEL_PAnPFS_TS28 0x19
#define RX_PSEL_PAnPFS_TS29 0x19
#define RX_PSEL_PAnPFS_TS30 0x19
#define RX_PSEL_PAnPFS_TS31 0x19
#define RX_PSEL_PAnPFS_TS32 0x19

/* PBnPFS */
#define RX_PSEL_PBnPFS_MTIOC0A 0x01
#define RX_PSEL_PBnPFS_MTIOC0C 0x01
#define RX_PSEL_PBnPFS_MTIOC2A 0x01
#define RX_PSEL_PBnPFS_MTIOC3B 0x01
#define RX_PSEL_PBnPFS_MTIOC3D 0x01
#define RX_PSEL_PBnPFS_MTIOC5W 0x01

#define RX_PSEL_PBnPFS_MTIOC1B 0x02
#define RX_PSEL_PBnPFS_MTIOC4A 0x02
#define RX_PSEL_PBnPFS_MTIOC4C 0x02

#define RX_PSEL_PBnPFS_TMO0  0x5
#define RX_PSEL_PBnPFS_TMRI1 0x5
#define RX_PSEL_PBnPFS_TMCI0 0x5

#define RX_PSEL_PBnPFS_POE1 0x7
#define RX_PSEL_PBnPFS_POE3 0x7

#define RX_PSEL_PBnPFS_RXD9   0xA
#define RX_PSEL_PBnPFS_SMISO9 0xA
#define RX_PSEL_PBnPFS_SSCL9  0xA
#define RX_PSEL_PBnPFS_TXD9   0xA
#define RX_PSEL_PBnPFS_SMOSI9 0xA
#define RX_PSEL_PBnPFS_SSDA9  0xA
#define RX_PSEL_PBnPFS_SCK9   0xA

#define RX_PSEL_PBnPFS_CTS6   0xB
#define RX_PSEL_PBnPFS_RTS6   0xB
#define RX_PSEL_PBnPFS_SS6    0xB
#define RX_PSEL_PBnPFS_CTS9   0xB
#define RX_PSEL_PBnPFS_RTS9   0xB
#define RX_PSEL_PBnPFS_SS9    0xB
#define RX_PSEL_PBnPFS_RXD6   0xB
#define RX_PSEL_PBnPFS_SMISO6 0xB
#define RX_PSEL_PBnPFS_SSCL6  0xB
#define RX_PSEL_PBnPFS_TXD6   0xB
#define RX_PSEL_PBnPFS_SMOSI6 0xB
#define RX_PSEL_PBnPFS_SSDA6  0xB
#define RX_PSEL_PBnPFS_SCK6   0xB

#define RX_PSEL_PBnPFS_RSPCKA 0xD

#define RX_PSEL_PBnPFS_CMPOB1 0x10

#define RX_PSEL_PBnPFS_TS18 0x19
#define RX_PSEL_PBnPFS_TS19 0x19
#define RX_PSEL_PBnPFS_TS20 0x19
#define RX_PSEL_PBnPFS_TS21 0x19
#define RX_PSEL_PBnPFS_TS22 0x19
#define RX_PSEL_PBnPFS_TS23 0x19
#define RX_PSEL_PBnPFS_TS24 0x19
#define RX_PSEL_PBnPFS_TS25 0x19

/* PCnPFS */
#define RX_PSEL_PCnPFS_MTIOC3A 0x01
#define RX_PSEL_PCnPFS_MTIOC3B 0x01
#define RX_PSEL_PCnPFS_MTIOC3C 0x01
#define RX_PSEL_PCnPFS_MTIOC3D 0x01
#define RX_PSEL_PCnPFS_MTIOC4B 0x01
#define RX_PSEL_PCnPFS_MTIOC4D 0x01

#define RX_PSEL_PCnPFS_MTCLKA 0x02
#define RX_PSEL_PCnPFS_MTCLKB 0x02
#define RX_PSEL_PCnPFS_MTCLKC 0x02
#define RX_PSEL_PCnPFS_MTCLKD 0x02

#define RX_PSEL_PCnPFS_TMCI1 0x5
#define RX_PSEL_PCnPFS_TMO2  0x5
#define RX_PSEL_PCnPFS_TMRI2 0x5
#define RX_PSEL_PCnPFS_TMCI2 0x5

#define RX_PSEL_PCnPFS_POE0   0x7
#define RX_PSEL_PCnPFS_CACREF 0x7

#define RX_PSEL_PCnPFS_RXD5   0xA
#define RX_PSEL_PCnPFS_SMISO5 0xA
#define RX_PSEL_PCnPFS_SSCL5  0xA
#define RX_PSEL_PCnPFS_TXD5   0xA
#define RX_PSEL_PCnPFS_SMOSI5 0xA
#define RX_PSEL_PCnPFS_SSDA5  0xA
#define RX_PSEL_PCnPFS_SCK5   0xA
#define RX_PSEL_PCnPFS_RXD8   0xA
#define RX_PSEL_PCnPFS_SMISO8 0xA
#define RX_PSEL_PCnPFS_SSCL8  0xA
#define RX_PSEL_PCnPFS_TXD8   0xA
#define RX_PSEL_PCnPFS_SMOSI8 0xA
#define RX_PSEL_PCnPFS_SSDA8  0xA
#define RX_PSEL_PCnPFS_SCK8   0xA

#define RX_PSEL_PCnPFS_CTS5 0xB
#define RX_PSEL_PCnPFS_RTS5 0xB
#define RX_PSEL_PCnPFS_SS5  0xB
#define RX_PSEL_PCnPFS_CTS8 0xB
#define RX_PSEL_PCnPFS_RTS8 0xB
#define RX_PSEL_PCnPFS_SS8  0xB

#define RX_PSEL_PCnPFS_SSLA0  0xD
#define RX_PSEL_PCnPFS_SSLA1  0xD
#define RX_PSEL_PCnPFS_SSLA2  0xD
#define RX_PSEL_PCnPFS_SSLA3  0xD
#define RX_PSEL_PCnPFS_RSPCKA 0xD
#define RX_PSEL_PCnPFS_MOSIA  0xD
#define RX_PSEL_PCnPFS_MISOA  0xD

#define RX_PSEL_PCnPFS_TS13  0x19
#define RX_PSEL_PCnPFS_TS14  0x19
#define RX_PSEL_PCnPFS_TS15  0x19
#define RX_PSEL_PCnPFS_TS16  0x19
#define RX_PSEL_PCnPFS_TS17  0x19
#define RX_PSEL_PCnPFS_TSCAP 0x19

/* PDnPFS */
#define RX_PSEL_PDnPFS_MTIOC4B 0x01
#define RX_PSEL_PDnPFS_MTIOC4D 0x01
#define RX_PSEL_PDnPFS_MTIOC5W 0x01
#define RX_PSEL_PDnPFS_MTIOC5V 0x01
#define RX_PSEL_PDnPFS_MTIOC5U 0x01

#define RX_PSEL_PDnPFS_POE0 0x7
#define RX_PSEL_PDnPFS_POE1 0x7
#define RX_PSEL_PDnPFS_POE2 0x7
#define RX_PSEL_PDnPFS_POE3 0x7
#define RX_PSEL_PDnPFS_POE8 0x7

#define RX_PSEL_PDnPFS_RXD6   0xB
#define RX_PSEL_PDnPFS_SMISO6 0xB
#define RX_PSEL_PDnPFS_SSCL6  0xB
#define RX_PSEL_PDnPFS_TXD6   0xB
#define RX_PSEL_PDnPFS_SMOSI6 0xB
#define RX_PSEL_PDnPFS_SSDA6  0xB
#define RX_PSEL_PDnPFS_SCK6   0xB

/* PEnPFS */
#define RX_PSEL_PEnPFS_MTIOC4A 0x01
#define RX_PSEL_PEnPFS_MTIOC4B 0x01
#define RX_PSEL_PEnPFS_MTIOC4C 0x01
#define RX_PSEL_PEnPFS_MTIOC4D 0x01

#define RX_PSEL_PEnPFS_MTIOC1A 0x02
#define RX_PSEL_PEnPFS_MTIOC2B 0x02

#define RX_PSEL_PEnPFS_POE8 0x7

#define RX_PSEL_PEnPFS_CLKOUT 0x9

#define RX_PSEL_PEnPFS_RXD12   0xC
#define RX_PSEL_PEnPFS_SMISO12 0xC
#define RX_PSEL_PEnPFS_SSCL12  0xC
#define RX_PSEL_PEnPFS_TXD12   0xC
#define RX_PSEL_PEnPFS_SMOSI12 0xC
#define RX_PSEL_PEnPFS_SSDA12  0xC
#define RX_PSEL_PEnPFS_SCK12   0xC
#define RX_PSEL_PEnPFS_TXDX12  0xC
#define RX_PSEL_PEnPFS_RXDX12  0xC
#define RX_PSEL_PEnPFS_SIOX12  0xC
#define RX_PSEL_PEnPFS_CTS12   0xC
#define RX_PSEL_PEnPFS_RTS12   0xC
#define RX_PSEL_PEnPFS_SS12    0xC

#define RX_PSEL_PEnPFS_CMPOB0 0X10

#define RX_PSEL_PEnPFS_TS33 0X19
#define RX_PSEL_PEnPFS_TS34 0x19
#define RX_PSEL_PEnPFS_TS35 0x19

/* PHnPFS */
#define RX_PSEL_PHnPFS_TMO0  0x05
#define RX_PSEL_PHnPFS_TMRI0 0x05
#define RX_PSEL_PHnPFS_TMCI0 0x05

#define RX_PSEL_PHnPFS_CACREF 0x7

#define RX_PSEL_PHnPFS_TS7  0x19
#define RX_PSEL_PHnPFS_TS8  0x19
#define RX_PSEL_PHnPFS_TS9  0x19
#define RX_PSEL_PHnPFS_TS10 0x19

/* PJnPFS */
#define RX_PSEL_PJnPFS_MTIOC3A 0x01
#define RX_PSEL_PJnPFS_MTIOC3C 0x01

#define RX_PSEL_PJnPFS_CTS6 0xB
#define RX_PSEL_PJnPFS_TTS6 0xB
#define RX_PSEL_PJnPFS_SS6  0xB

#define RX_PSEL(psel, port_num, pin_num)                                                           \
	(psel << RX_PSEL_POS | pin_num << RX_PIN_NUM_POS | port_num << RX_PORT_NUM_POS)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_SOC_RX_COMMON_H_ */
