/*
 * Copyright (c) 2024, Andrew Featherstone
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_RPI_PICO_RP2350_PINCTRL_COMMON_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_RPI_PICO_RP2350_PINCTRL_COMMON_H_

#define RP2_PINCTRL_GPIO_FUNC_HSTX 0

#define RP2_PINCTRL_GPIO_FUNC_PIO2     8
#define RP2_PINCTRL_GPIO_FUNC_GPCK     9
#define RP2_PINCTRL_GPIO_FUNC_USB      10
#define RP2_PINCTRL_GPIO_FUNC_UART_AUX 11
#define RP2_PINCTRL_GPIO_FUNC_NULL     0x1f

#include "rpi-pico-pinctrl-common.h"

#define PIO2_P0  RP2XXX_PINMUX(0, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P1  RP2XXX_PINMUX(1, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P2  RP2XXX_PINMUX(2, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P3  RP2XXX_PINMUX(3, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P4  RP2XXX_PINMUX(4, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P5  RP2XXX_PINMUX(5, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P6  RP2XXX_PINMUX(6, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P7  RP2XXX_PINMUX(7, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P8  RP2XXX_PINMUX(8, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P9  RP2XXX_PINMUX(9, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P10 RP2XXX_PINMUX(10, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P11 RP2XXX_PINMUX(11, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P12 RP2XXX_PINMUX(12, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P13 RP2XXX_PINMUX(13, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P14 RP2XXX_PINMUX(14, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P15 RP2XXX_PINMUX(15, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P16 RP2XXX_PINMUX(16, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P17 RP2XXX_PINMUX(17, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P18 RP2XXX_PINMUX(18, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P19 RP2XXX_PINMUX(19, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P20 RP2XXX_PINMUX(20, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P21 RP2XXX_PINMUX(21, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P22 RP2XXX_PINMUX(22, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P23 RP2XXX_PINMUX(23, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P24 RP2XXX_PINMUX(24, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P25 RP2XXX_PINMUX(25, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P26 RP2XXX_PINMUX(26, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P27 RP2XXX_PINMUX(27, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P28 RP2XXX_PINMUX(28, RP2_PINCTRL_GPIO_FUNC_PIO2)
#define PIO2_P29 RP2XXX_PINMUX(29, RP2_PINCTRL_GPIO_FUNC_PIO2)

#define GPIN0_P12  RP2XXX_PINMUX(20, RP2_PINCTRL_GPIO_FUNC_GPCK)
#define GPIN1_P14  RP2XXX_PINMUX(22, RP2_PINCTRL_GPIO_FUNC_GPCK)
#define GPOUT0_P13 RP2XXX_PINMUX(21, RP2_PINCTRL_GPIO_FUNC_GPCK)
#define GPOUT1_P15 RP2XXX_PINMUX(23, RP2_PINCTRL_GPIO_FUNC_GPCK)

#define UART0_TX_P2  RP2XXX_PINMUX(2, RP2_PINCTRL_GPIO_FUNC_UART_ALT)
#define UART0_RX_P3  RP2XXX_PINMUX(3, RP2_PINCTRL_GPIO_FUNC_UART_ALT)
#define UART1_TX_P6  RP2XXX_PINMUX(6, RP2_PINCTRL_GPIO_FUNC_UART_ALT)
#define UART1_RX_P7  RP2XXX_PINMUX(7, RP2_PINCTRL_GPIO_FUNC_UART_ALT)
#define UART1_TX_P10 RP2XXX_PINMUX(10, RP2_PINCTRL_GPIO_FUNC_UART_ALT)
#define UART1_RX_P11 RP2XXX_PINMUX(11, RP2_PINCTRL_GPIO_FUNC_UART_ALT)
#define UART0_TX_P14 RP2XXX_PINMUX(14, RP2_PINCTRL_GPIO_FUNC_UART_ALT)
#define UART0_RX_P15 RP2XXX_PINMUX(15, RP2_PINCTRL_GPIO_FUNC_UART_ALT)
#define UART0_TX_P18 RP2XXX_PINMUX(18, RP2_PINCTRL_GPIO_FUNC_UART_ALT)
#define UART0_RX_P19 RP2XXX_PINMUX(19, RP2_PINCTRL_GPIO_FUNC_UART_ALT)
#define UART1_TX_P22 RP2XXX_PINMUX(22, RP2_PINCTRL_GPIO_FUNC_UART_ALT)
#define UART1_RX_P23 RP2XXX_PINMUX(23, RP2_PINCTRL_GPIO_FUNC_UART_ALT)
#define UART1_TX_P26 RP2XXX_PINMUX(26, RP2_PINCTRL_GPIO_FUNC_UART_ALT)
#define UART1_RX_P27 RP2XXX_PINMUX(27, RP2_PINCTRL_GPIO_FUNC_UART_ALT)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_RPI_PICO_RP2350_PINCTRL_COMMON_H_ */
