/*
 * Copyright (c) 2022 Teslabs Engineering S.L.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_RESET_GD32F3X0_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_RESET_GD32F3X0_H_

#include "gd32-common.h"

/**
 * @name Register offsets
 * @{
 */

#define GD32_APB2RST_OFFSET       0x0CU
#define GD32_APB1RST_OFFSET       0x10U
#define GD32_AHBRST_OFFSET        0x28U
#define GD32_ADDAPB1RST_OFFSET    0xFCU

/** @} */

/**
 * @name Clock enable/disable definitions for peripherals
 * @{
 */

/* APB2 peripherals */
#define GD32_RESET_CFGCMP     GD32_RESET_CONFIG(APB2RST, 0U)
#define GD32_RESET_ADC        GD32_RESET_CONFIG(APB2RST, 9U)
#define GD32_RESET_TIMER0     GD32_RESET_CONFIG(APB2RST, 11U)
#define GD32_RESET_SPI0       GD32_RESET_CONFIG(APB2RST, 12U)
#define GD32_RESET_USART0     GD32_RESET_CONFIG(APB2RST, 14U)
#define GD32_RESET_TIMER14    GD32_RESET_CONFIG(APB2RST, 16U)
#define GD32_RESET_TIMER15    GD32_RESET_CONFIG(APB2RST, 17U)
#define GD32_RESET_TIMER16    GD32_RESET_CONFIG(APB2RST, 18U)

/* APB1 peripherals */
#define GD32_RESET_TIMER1     GD32_RESET_CONFIG(APB1RST, 0U)
#define GD32_RESET_TIMER2     GD32_RESET_CONFIG(APB1RST, 1U)
#define GD32_RESET_TIMER5     GD32_RESET_CONFIG(APB1RST, 4U)
#define GD32_RESET_TIMER13    GD32_RESET_CONFIG(APB1RST, 8U)
#define GD32_RESET_WWDGT      GD32_RESET_CONFIG(APB1RST, 11U)
#define GD32_RESET_SPI1       GD32_RESET_CONFIG(APB1RST, 14U)
#define GD32_RESET_USART1     GD32_RESET_CONFIG(APB1RST, 17U)
#define GD32_RESET_PMU        GD32_RESET_CONFIG(APB1RST, 28U)
#define GD32_RESET_DAC        GD32_RESET_CONFIG(APB1RST, 29U)
#define GD32_RESET_CEC        GD32_RESET_CONFIG(APB1RST, 30U)

/* AHB peripherals */
#define GD32_RESET_USBFS      GD32_RESET_CONFIG(AHBRST, 12U)
#define GD32_RESET_GPIOA      GD32_RESET_CONFIG(AHBRST, 17U)
#define GD32_RESET_GPIOB      GD32_RESET_CONFIG(AHBRST, 18U)
#define GD32_RESET_GPIOC      GD32_RESET_CONFIG(AHBRST, 19U)
#define GD32_RESET_GPIOD      GD32_RESET_CONFIG(AHBRST, 20U)
#define GD32_RESET_GPIOF      GD32_RESET_CONFIG(AHBRST, 22U)
#define GD32_RESET_TSI        GD32_RESET_CONFIG(AHBRST, 24U)

/* APB1 additional peripherals */
#define GD32_RESET_CTC        GD32_RESET_CONFIG(ADDAPB1RST, 27U)

/** @} */

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_RESET_GD32F3X0_H_ */
