/*
 * Copyright (c) 2022 Intel Corporation
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_SYS_CBPRINTF_ENUMS_H_
#define ZEPHYR_INCLUDE_SYS_CBPRINTF_ENUMS_H_

/** @brief cbprintf package argument type
 *
 * This is used to tag each argument in cbprintf in the variable
 * length argument list.
 */
enum cbprintf_package_arg_type {
	/** End of argument list */
	CBPRINTF_PACKAGE_ARG_TYPE_END = 0,

	CBPRINTF_PACKAGE_ARG_TYPE_CHAR,
	CBPRINTF_PACKAGE_ARG_TYPE_UNSIGNED_CHAR,

	CBPRINTF_PACKAGE_ARG_TYPE_SHORT,
	CBPRINTF_PACKAGE_ARG_TYPE_UNSIGNED_SHORT,

	CBPRINTF_PACKAGE_ARG_TYPE_INT,
	CBPRINTF_PACKAGE_ARG_TYPE_UNSIGNED_INT,

	CBPRINTF_PACKAGE_ARG_TYPE_LONG,
	CBPRINTF_PACKAGE_ARG_TYPE_UNSIGNED_LONG,

	CBPRINTF_PACKAGE_ARG_TYPE_LONG_LONG,
	CBPRINTF_PACKAGE_ARG_TYPE_UNSIGNED_LONG_LONG,

	CBPRINTF_PACKAGE_ARG_TYPE_FLOAT,
	CBPRINTF_PACKAGE_ARG_TYPE_DOUBLE,
	CBPRINTF_PACKAGE_ARG_TYPE_LONG_DOUBLE,

	CBPRINTF_PACKAGE_ARG_TYPE_PTR_CHAR,

	CBPRINTF_PACKAGE_ARG_TYPE_PTR_VOID,

	CBPRINTF_PACKAGE_ARG_TYPE_MAX,

	CBPRINTF_PACKAGE_ARG_TYPE_COUNT = CBPRINTF_PACKAGE_ARG_TYPE_MAX
};

#endif /* ZEPHYR_INCLUDE_SYS_CBPRINTF_ENUMS_H_ */
