/*
 * Copyright (c) 2025 Silicon Laboratories Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * This configuration header is used by the Silicon Labs Bluetooth Controller init functions.
 * It is used to configure LE Power Control options.
 */

#ifndef SL_BT_POWER_CONTROL_CONFIG_H
#define SL_BT_POWER_CONTROL_CONFIG_H

#define SL_BT_ACTIVATE_POWER_CONTROL CONFIG_BT_SILABS_EFR32_ACTIVATE_POWER_CONTROL

#define SL_BT_GOLDEN_RSSI_MIN_1M CONFIG_BT_SILABS_EFR32_GOLDEN_RSSI_MIN_1M

#define SL_BT_GOLDEN_RSSI_MAX_1M CONFIG_BT_SILABS_EFR32_GOLDEN_RSSI_MAX_1M

#define SL_BT_GOLDEN_RSSI_MIN_2M CONFIG_BT_SILABS_EFR32_GOLDEN_RSSI_MIN_2M

#define SL_BT_GOLDEN_RSSI_MAX_2M CONFIG_BT_SILABS_EFR32_GOLDEN_RSSI_MAX_2M

#define SL_BT_GOLDEN_RSSI_MIN_CODED_S8 CONFIG_BT_SILABS_EFR32_GOLDEN_RSSI_MIN_CODED_S8

#define SL_BT_GOLDEN_RSSI_MAX_CODED_S8 CONFIG_BT_SILABS_EFR32_GOLDEN_RSSI_MAX_CODED_S8

#define SL_BT_GOLDEN_RSSI_MIN_CODED_S2 CONFIG_BT_SILABS_EFR32_GOLDEN_RSSI_MIN_CODED_S2

#define SL_BT_GOLDEN_RSSI_MAX_CODED_S2 CONFIG_BT_SILABS_EFR32_GOLDEN_RSSI_MAX_CODED_S2

/* TODO: make these configurable in a sensible way, preferably based on HW limits */
#define SL_BT_DEFAULT_MAX_POWER_LEVEL SL_BT_USE_MAX_POWER_LEVEL_SUPPORTED_BY_RADIO

#define SL_BT_DEFAULT_MIN_POWER_LEVEL SL_BT_USE_MIN_POWER_LEVEL_SUPPORTED_BY_RADIO

#endif
