/*
 * Copyright (c) 2025 Renesas Electronics Corporation
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef QE_TOUCH_DEFINE_H
#define QE_TOUCH_DEFINE_H

/* Generated content from Renesas QE Capacitive Touch */

#define QE_TOUCH_VERSION (0x0410)

#define CTSU_CFG_NUM_SELF_ELEMENTS (12)

#define CTSU_CFG_NUM_MUTUAL_ELEMENTS (0)
#define CTSU_CFG_NUM_CFC             (0)
#define CTSU_CFG_NUM_CFC_TX          (0)

#define TOUCH_CFG_MONITOR_ENABLE (1)
#define TOUCH_CFG_NUM_BUTTONS    (3)
#define TOUCH_CFG_NUM_SLIDERS    (1)
#define TOUCH_CFG_NUM_WHEELS     (1)
#define TOUCH_CFG_PAD_ENABLE     (0)

#define QE_TOUCH_MACRO_CTSU_IP_KIND (2)

#define CTSU_CFG_VCC_MV           (5000)
#define CTSU_CFG_LOW_VOLTAGE_MODE (0)

#define CTSU_CFG_PCLK_DIVISION (0)

#define CTSU_CFG_TSCAP_PORT (0x010C)

#define CTSU_CFG_NUM_SUMULTI (3)
#define CTSU_CFG_SUMULTI0    (0x3F)
#define CTSU_CFG_SUMULTI1    (0x36)
#define CTSU_CFG_SUMULTI2    (0x48)

#define CTSU_CFG_CALIB_RTRIM_SUPPORT     (0)
#define CTSU_CFG_TEMP_CORRECTION_SUPPORT (0)
#define CTSU_CFG_TEMP_CORRECTION_TS      (0)
#define CTSU_CFG_TEMP_CORRECTION_TIME    (0)

#define CTSU_CFG_TARGET_VALUE_QE_SUPPORT (1)

#define CTSU_CFG_MAJORITY_MODE                 (1)
#define CTSU_CFG_NUM_AUTOJUDGE_SELF_ELEMENTS   (0)
#define CTSU_CFG_NUM_AUTOJUDGE_MUTUAL_ELEMENTS (0)

#define CONFIG01_INDEX_BUTTON00 (2)
#define CONFIG01_MASK_BUTTON00  (1ULL << CONFIG01_INDEX_BUTTON00)
#define CONFIG01_INDEX_BUTTON01 (1)
#define CONFIG01_MASK_BUTTON01  (1ULL << CONFIG01_INDEX_BUTTON01)
#define CONFIG01_INDEX_BUTTON02 (0)
#define CONFIG01_MASK_BUTTON02  (1ULL << CONFIG01_INDEX_BUTTON02)

#endif /* QE_TOUCH_DEFINE_H */
