static const uint16_t in_cfft_noisy_16[32] = {
    0xa963, 0x0, 0x37dd, 0x0, 0x39ca, 0x0, 0x389f, 0x0,
    0x23a5, 0x0, 0xb69a, 0x0, 0xb9c8, 0x0, 0xb77f, 0x0,
    0x2638, 0x0, 0x37c1, 0x0, 0x3956, 0x0, 0x3800, 0x0,
    0x9f32, 0x0, 0xb7f4, 0x0, 0xb9c0, 0x0, 0xb803, 0x0
    };

static const uint16_t in_cifft_noisy_16[32] = {
    0x2f3e, 0x0, 0xaa72, 0xb333, 0xb07c, 0xc59d, 0xaf3d, 0x20c9,
    0x2943, 0x294b, 0xaebf, 0x293d, 0x2daf, 0x2a77, 0x1b0a, 0xaec2,
    0xb384, 0x0, 0x1b0a, 0x2ec2, 0x2daf, 0xaa77, 0xaebf, 0xa93d,
    0x2943, 0xa94b, 0xaf3d, 0xa0c9, 0xb07c, 0x459d, 0xaa72, 0x3333
    };

static const uint16_t ref_cfft_noisy_16[32] = {
    0x2f3e, 0x0, 0xaa72, 0xb333, 0xb07c, 0xc59d, 0xaf3d, 0x20c9,
    0x2943, 0x294b, 0xaebf, 0x293d, 0x2daf, 0x2a77, 0x1b0a, 0xaec2,
    0xb384, 0x0, 0x1b0a, 0x2ec2, 0x2daf, 0xaa77, 0xaebf, 0xa93d,
    0x2943, 0xa94b, 0xaf3d, 0xa0c9, 0xb07c, 0x459d, 0xaa72, 0x3333
    };

static const uint16_t in_cfft_noisy_32[64] = {
    0x2a24, 0x0, 0x3771, 0x0, 0x3a25, 0x0, 0x378e, 0x0,
    0xabf0, 0x0, 0xb7ba, 0x0, 0xb987, 0x0, 0xb7c1, 0x0,
    0xad2b, 0x0, 0x389f, 0x0, 0x39ce, 0x0, 0x3828, 0x0,
    0xaed5, 0x0, 0xb77d, 0x0, 0xb9b5, 0x0, 0xb826, 0x0,
    0x2941, 0x0, 0x372e, 0x0, 0x3994, 0x0, 0x3757, 0x0,
    0xad1f, 0x0, 0xb81b, 0x0, 0xb9e2, 0x0, 0xb6c2, 0x0,
    0x29f3, 0x0, 0x385c, 0x0, 0x3979, 0x0, 0x3766, 0x0,
    0x28c3, 0x0, 0xb745, 0x0, 0xb89e, 0x0, 0xb80b, 0x0
    };

static const uint16_t in_cifft_noisy_32[64] = {
    0x2e71, 0x0, 0x3551, 0x2f86, 0xa837, 0x3479, 0x2c4a, 0x2218,
    0x3585, 0xc98d, 0xb475, 0x3362, 0xb10f, 0x2548, 0xa0cb, 0xb53f,
    0xb50c, 0xb05c, 0xb042, 0x32d6, 0x3046, 0x2aca, 0xadc3, 0xa80e,
    0x3202, 0x2cdf, 0xb021, 0xae43, 0x3868, 0x25a2, 0x34bd, 0xb297,
    0xae39, 0x0, 0x34bd, 0x3297, 0x3868, 0xa5a2, 0xb021, 0x2e43,
    0x3202, 0xacdf, 0xadc3, 0x280e, 0x3046, 0xaaca, 0xb042, 0xb2d6,
    0xb50c, 0x305c, 0xa0cb, 0x353f, 0xb10f, 0xa548, 0xb475, 0xb362,
    0x3585, 0x498d, 0x2c4a, 0xa218, 0xa837, 0xb479, 0x3551, 0xaf86
    };

static const uint16_t ref_cfft_noisy_32[64] = {
    0x2e71, 0x0, 0x3551, 0x2f86, 0xa837, 0x3479, 0x2c4a, 0x2218,
    0x3585, 0xc98d, 0xb475, 0x3362, 0xb10f, 0x2548, 0xa0cb, 0xb53f,
    0xb50c, 0xb05c, 0xb042, 0x32d6, 0x3046, 0x2aca, 0xadc3, 0xa80e,
    0x3202, 0x2cdf, 0xb021, 0xae43, 0x3868, 0x25a2, 0x34bd, 0xb297,
    0xae39, 0x0, 0x34bd, 0x3297, 0x3868, 0xa5a2, 0xb021, 0x2e43,
    0x3202, 0xacdf, 0xadc3, 0x280e, 0x3046, 0xaaca, 0xb042, 0xb2d6,
    0xb50c, 0x305c, 0xa0cb, 0x353f, 0xb10f, 0xa548, 0xb475, 0xb362,
    0x3585, 0x498d, 0x2c4a, 0xa218, 0xa837, 0xb479, 0x3551, 0xaf86
    };

static const uint16_t in_cfft_noisy_64[128] = {
    0xa868, 0x0, 0x3828, 0x0, 0x396c, 0x0, 0x3721, 0x0,
    0xa18b, 0x0, 0xb822, 0x0, 0xb937, 0x0, 0xb7cd, 0x0,
    0x2f37, 0x0, 0x382c, 0x0, 0x39fe, 0x0, 0x3722, 0x0,
    0xa693, 0x0, 0xb803, 0x0, 0xb969, 0x0, 0xb70c, 0x0,
    0x28cd, 0x0, 0x377b, 0x0, 0x39b0, 0x0, 0x379a, 0x0,
    0x2987, 0x0, 0xb7a8, 0x0, 0xb970, 0x0, 0xb7da, 0x0,
    0x254f, 0x0, 0x384c, 0x0, 0x3977, 0x0, 0x3787, 0x0,
    0xa30e, 0x0, 0xb81c, 0x0, 0xb992, 0x0, 0xb66c, 0x0,
    0xa314, 0x0, 0x37de, 0x0, 0x3a82, 0x0, 0x380d, 0x0,
    0xa80a, 0x0, 0xb80b, 0x0, 0xba06, 0x0, 0xb838, 0x0,
    0xa056, 0x0, 0x3745, 0x0, 0x3967, 0x0, 0x37b6, 0x0,
    0x2d0a, 0x0, 0xb71a, 0x0, 0xb990, 0x0, 0xb7cf, 0x0,
    0x281b, 0x0, 0x3823, 0x0, 0x3969, 0x0, 0x38c6, 0x0,
    0xad50, 0x0, 0xb751, 0x0, 0xb979, 0x0, 0xb713, 0x0,
    0xabd5, 0x0, 0x374a, 0x0, 0x39c4, 0x0, 0x3654, 0x0,
    0xea6, 0x0, 0xb630, 0x0, 0xb9bc, 0x0, 0xb875, 0x0
    };

static const uint16_t in_cifft_noisy_64[128] = {
    0x356a, 0x0, 0xb022, 0xb137, 0xb4b2, 0xa7a6, 0xb45e, 0xb502,
    0x3235, 0xa54c, 0xb6e7, 0x35bc, 0x328d, 0x214c, 0xa7c0, 0x38b4,
    0x32af, 0xcd8a, 0x2a72, 0xb151, 0xb12b, 0xb33a, 0xb726, 0xaf26,
    0xb596, 0xadef, 0x35c9, 0xb415, 0xb301, 0xa9e0, 0xa67f, 0xb454,
    0xaf1a, 0xb1b6, 0xac5b, 0xb5a6, 0xb1d7, 0xb59e, 0x36d0, 0xb8b7,
    0x32e9, 0x33d6, 0x357d, 0xadd2, 0xb067, 0x341d, 0x30a6, 0xb1bc,
    0x29f0, 0x35b5, 0x2d97, 0x2c67, 0xb1d2, 0x2e1a, 0xb883, 0xb1d8,
    0xb360, 0xb176, 0x3253, 0xaea1, 0x274a, 0x36cb, 0x26f9, 0x370e,
    0x2aea, 0x0, 0x26f9, 0xb70e, 0x274a, 0xb6cb, 0x3253, 0x2ea1,
    0xb360, 0x3176, 0xb883, 0x31d8, 0xb1d2, 0xae1a, 0x2d97, 0xac67,
    0x29f0, 0xb5b5, 0x30a6, 0x31bc, 0xb067, 0xb41d, 0x357d, 0x2dd2,
    0x32e9, 0xb3d6, 0x36d0, 0x38b7, 0xb1d7, 0x359e, 0xac5b, 0x35a6,
    0xaf1a, 0x31b6, 0xa67f, 0x3454, 0xb301, 0x29e0, 0x35c9, 0x3415,
    0xb596, 0x2def, 0xb726, 0x2f26, 0xb12b, 0x333a, 0x2a72, 0x3151,
    0x32af, 0x4d8a, 0xa7c0, 0xb8b4, 0x328d, 0xa14c, 0xb6e7, 0xb5bc,
    0x3235, 0x254c, 0xb45e, 0x3502, 0xb4b2, 0x27a6, 0xb022, 0x3137
    };

static const uint16_t ref_cfft_noisy_64[128] = {
    0x356a, 0x0, 0xb022, 0xb137, 0xb4b2, 0xa7a6, 0xb45e, 0xb502,
    0x3235, 0xa54c, 0xb6e7, 0x35bc, 0x328d, 0x214c, 0xa7c0, 0x38b4,
    0x32af, 0xcd8a, 0x2a72, 0xb151, 0xb12b, 0xb33a, 0xb726, 0xaf26,
    0xb596, 0xadef, 0x35c9, 0xb415, 0xb301, 0xa9e0, 0xa67f, 0xb454,
    0xaf1a, 0xb1b6, 0xac5b, 0xb5a6, 0xb1d7, 0xb59e, 0x36d0, 0xb8b7,
    0x32e9, 0x33d6, 0x357d, 0xadd2, 0xb067, 0x341d, 0x30a6, 0xb1bc,
    0x29f0, 0x35b5, 0x2d97, 0x2c67, 0xb1d2, 0x2e1a, 0xb883, 0xb1d8,
    0xb360, 0xb176, 0x3253, 0xaea1, 0x274a, 0x36cb, 0x26f9, 0x370e,
    0x2aea, 0x0, 0x26f9, 0xb70e, 0x274a, 0xb6cb, 0x3253, 0x2ea1,
    0xb360, 0x3176, 0xb883, 0x31d8, 0xb1d2, 0xae1a, 0x2d97, 0xac67,
    0x29f0, 0xb5b5, 0x30a6, 0x31bc, 0xb067, 0xb41d, 0x357d, 0x2dd2,
    0x32e9, 0xb3d6, 0x36d0, 0x38b7, 0xb1d7, 0x359e, 0xac5b, 0x35a6,
    0xaf1a, 0x31b6, 0xa67f, 0x3454, 0xb301, 0x29e0, 0x35c9, 0x3415,
    0xb596, 0x2def, 0xb726, 0x2f26, 0xb12b, 0x333a, 0x2a72, 0x3151,
    0x32af, 0x4d8a, 0xa7c0, 0xb8b4, 0x328d, 0xa14c, 0xb6e7, 0xb5bc,
    0x3235, 0x254c, 0xb45e, 0x3502, 0xb4b2, 0x27a6, 0xb022, 0x3137
    };

static const uint16_t in_cfft_noisy_128[256] = {
    0xa095, 0x0, 0x383e, 0x0, 0x394a, 0x0, 0x3814, 0x0,
    0xa598, 0x0, 0xb71e, 0x0, 0xb9a9, 0x0, 0xb728, 0x0,
    0x9c90, 0x0, 0x378f, 0x0, 0x39b3, 0x0, 0x3873, 0x0,
    0x2a98, 0x0, 0xb74a, 0x0, 0xb953, 0x0, 0xb771, 0x0,
    0xa6c5, 0x0, 0x382a, 0x0, 0x39ad, 0x0, 0x37eb, 0x0,
    0x2a4f, 0x0, 0xb84f, 0x0, 0xb984, 0x0, 0xb889, 0x0,
    0xabf9, 0x0, 0x373d, 0x0, 0x394e, 0x0, 0x3691, 0x0,
    0xa8a7, 0x0, 0xb7b8, 0x0, 0xb993, 0x0, 0xb873, 0x0,
    0x1364, 0x0, 0x37c0, 0x0, 0x38ca, 0x0, 0x3800, 0x0,
    0x22b2, 0x0, 0xb791, 0x0, 0xb98c, 0x0, 0xb80b, 0x0,
    0x29e4, 0x0, 0x3827, 0x0, 0x39e2, 0x0, 0x3753, 0x0,
    0x2361, 0x0, 0xb726, 0x0, 0xb946, 0x0, 0xb852, 0x0,
    0xa055, 0x0, 0x3800, 0x0, 0x39be, 0x0, 0x3825, 0x0,
    0x283e, 0x0, 0xb712, 0x0, 0xb976, 0x0, 0xb835, 0x0,
    0x22ba, 0x0, 0x3827, 0x0, 0x3983, 0x0, 0x36ed, 0x0,
    0xaa1f, 0x0, 0xb7e9, 0x0, 0xb97a, 0x0, 0xb7c1, 0x0,
    0xac07, 0x0, 0x3899, 0x0, 0x3979, 0x0, 0x38e2, 0x0,
    0x94fe, 0x0, 0xb83d, 0x0, 0xb993, 0x0, 0xb7db, 0x0,
    0xacd6, 0x0, 0x37b0, 0x0, 0x38d6, 0x0, 0x3809, 0x0,
    0x306d, 0x0, 0xb7c4, 0x0, 0xb94f, 0x0, 0xb751, 0x0,
    0xa608, 0x0, 0x3847, 0x0, 0x39b3, 0x0, 0x375e, 0x0,
    0x2429, 0x0, 0xb877, 0x0, 0xb93c, 0x0, 0xb6eb, 0x0,
    0x2282, 0x0, 0x38f0, 0x0, 0x39ab, 0x0, 0x3830, 0x0,
    0x2829, 0x0, 0xb6ed, 0x0, 0xb97a, 0x0, 0xb842, 0x0,
    0xa7da, 0x0, 0x3819, 0x0, 0x38d4, 0x0, 0x376b, 0x0,
    0x2bd5, 0x0, 0xb8b6, 0x0, 0xb998, 0x0, 0xb879, 0x0,
    0xa893, 0x0, 0x38c6, 0x0, 0x3a1c, 0x0, 0x3687, 0x0,
    0x29a2, 0x0, 0xb79f, 0x0, 0xba3b, 0x0, 0xb78f, 0x0,
    0x1cd7, 0x0, 0x37d0, 0x0, 0x3960, 0x0, 0x3790, 0x0,
    0x9ed4, 0x0, 0xb77f, 0x0, 0xb902, 0x0, 0xb885, 0x0,
    0xa85d, 0x0, 0x36f8, 0x0, 0x3a33, 0x0, 0x3851, 0x0,
    0x2706, 0x0, 0xb704, 0x0, 0xb8f1, 0x0, 0xb84e, 0x0
    };

static const uint16_t in_cifft_noisy_128[256] = {
    0x3638, 0x0, 0xaaed, 0x3481, 0x381e, 0xb249, 0x3b47, 0xb819,
    0xb7dd, 0xaf5a, 0xb8e3, 0x2ff7, 0x3350, 0x30b7, 0x367e, 0x38cb,
    0x2c88, 0x3690, 0xb879, 0x31b2, 0x38e9, 0xb893, 0xb63b, 0x3a44,
    0x2f68, 0xa981, 0x32f2, 0x3749, 0xb700, 0xaad7, 0xb680, 0xadec,
    0xb959, 0xd191, 0x2892, 0x315d, 0xb166, 0x306a, 0xb23b, 0x2f06,
    0xac11, 0x2fb7, 0xb323, 0xb8cf, 0x38c7, 0xb83c, 0x3625, 0xaa0f,
    0xb420, 0x2c71, 0x3936, 0x2f55, 0xb692, 0xb10e, 0x3438, 0xabd1,
    0xb3f2, 0x35a4, 0x2ccd, 0xa829, 0xbb15, 0x36f0, 0xaeb6, 0xaf7a,
    0xa91d, 0xba11, 0xb0aa, 0x29b7, 0x305e, 0x343d, 0xb279, 0x271c,
    0x306c, 0xb860, 0xac02, 0xb723, 0xb622, 0xb418, 0x354d, 0xb71b,
    0x3926, 0xb1d3, 0xb26b, 0x2b48, 0xb7ec, 0x3535, 0xb8ba, 0xb17e,
    0x3516, 0xb9c5, 0x34cf, 0xa921, 0x3848, 0xb5fa, 0x3045, 0x3abd,
    0xb942, 0xb9b7, 0x36a0, 0xb54d, 0x1fee, 0x3767, 0x3663, 0x29bd,
    0x3530, 0xb375, 0x31a5, 0xa3bb, 0xb23b, 0xaffe, 0x3114, 0x288f,
    0xb823, 0xb141, 0xb60c, 0x29b9, 0x2b32, 0xb94a, 0x38a0, 0xb4a7,
    0xb79f, 0xb5b1, 0x2e74, 0xb27a, 0xb638, 0xb617, 0x3508, 0x2e9c,
    0xa5d8, 0x0, 0x3508, 0xae9c, 0xb638, 0x3617, 0x2e74, 0x327a,
    0xb79f, 0x35b1, 0x38a0, 0x34a7, 0x2b32, 0x394a, 0xb60c, 0xa9b9,
    0xb823, 0x3141, 0x3114, 0xa88f, 0xb23b, 0x2ffe, 0x31a5, 0x23bb,
    0x3530, 0x3375, 0x3663, 0xa9bd, 0x1fee, 0xb767, 0x36a0, 0x354d,
    0xb942, 0x39b7, 0x3045, 0xbabd, 0x3848, 0x35fa, 0x34cf, 0x2921,
    0x3516, 0x39c5, 0xb8ba, 0x317e, 0xb7ec, 0xb535, 0xb26b, 0xab48,
    0x3926, 0x31d3, 0x354d, 0x371b, 0xb622, 0x3418, 0xac02, 0x3723,
    0x306c, 0x3860, 0xb279, 0xa71c, 0x305e, 0xb43d, 0xb0aa, 0xa9b7,
    0xa91d, 0x3a11, 0xaeb6, 0x2f7a, 0xbb15, 0xb6f0, 0x2ccd, 0x2829,
    0xb3f2, 0xb5a4, 0x3438, 0x2bd1, 0xb692, 0x310e, 0x3936, 0xaf55,
    0xb420, 0xac71, 0x3625, 0x2a0f, 0x38c7, 0x383c, 0xb323, 0x38cf,
    0xac11, 0xafb7, 0xb23b, 0xaf06, 0xb166, 0xb06a, 0x2892, 0xb15d,
    0xb959, 0x5191, 0xb680, 0x2dec, 0xb700, 0x2ad7, 0x32f2, 0xb749,
    0x2f68, 0x2981, 0xb63b, 0xba44, 0x38e9, 0x3893, 0xb879, 0xb1b2,
    0x2c88, 0xb690, 0x367e, 0xb8cb, 0x3350, 0xb0b7, 0xb8e3, 0xaff7,
    0xb7dd, 0x2f5a, 0x3b47, 0x3819, 0x381e, 0x3249, 0xaaed, 0xb481
    };

static const uint16_t ref_cfft_noisy_128[256] = {
    0x3638, 0x0, 0xaaed, 0x3481, 0x381e, 0xb249, 0x3b47, 0xb819,
    0xb7dd, 0xaf5a, 0xb8e3, 0x2ff7, 0x3350, 0x30b7, 0x367e, 0x38cb,
    0x2c88, 0x3690, 0xb879, 0x31b2, 0x38e9, 0xb893, 0xb63b, 0x3a44,
    0x2f68, 0xa981, 0x32f2, 0x3749, 0xb700, 0xaad7, 0xb680, 0xadec,
    0xb959, 0xd191, 0x2892, 0x315d, 0xb166, 0x306a, 0xb23b, 0x2f06,
    0xac11, 0x2fb7, 0xb323, 0xb8cf, 0x38c7, 0xb83c, 0x3625, 0xaa0f,
    0xb420, 0x2c71, 0x3936, 0x2f55, 0xb692, 0xb10e, 0x3438, 0xabd1,
    0xb3f2, 0x35a4, 0x2ccd, 0xa829, 0xbb15, 0x36f0, 0xaeb6, 0xaf7a,
    0xa91d, 0xba11, 0xb0aa, 0x29b7, 0x305e, 0x343d, 0xb279, 0x271c,
    0x306c, 0xb860, 0xac02, 0xb723, 0xb622, 0xb418, 0x354d, 0xb71b,
    0x3926, 0xb1d3, 0xb26b, 0x2b48, 0xb7ec, 0x3535, 0xb8ba, 0xb17e,
    0x3516, 0xb9c5, 0x34cf, 0xa921, 0x3848, 0xb5fa, 0x3045, 0x3abd,
    0xb942, 0xb9b7, 0x36a0, 0xb54d, 0x1fee, 0x3767, 0x3663, 0x29bd,
    0x3530, 0xb375, 0x31a5, 0xa3bb, 0xb23b, 0xaffe, 0x3114, 0x288f,
    0xb823, 0xb141, 0xb60c, 0x29b9, 0x2b32, 0xb94a, 0x38a0, 0xb4a7,
    0xb79f, 0xb5b1, 0x2e74, 0xb27a, 0xb638, 0xb617, 0x3508, 0x2e9c,
    0xa5d8, 0x0, 0x3508, 0xae9c, 0xb638, 0x3617, 0x2e74, 0x327a,
    0xb79f, 0x35b1, 0x38a0, 0x34a7, 0x2b32, 0x394a, 0xb60c, 0xa9b9,
    0xb823, 0x3141, 0x3114, 0xa88f, 0xb23b, 0x2ffe, 0x31a5, 0x23bb,
    0x3530, 0x3375, 0x3663, 0xa9bd, 0x1fee, 0xb767, 0x36a0, 0x354d,
    0xb942, 0x39b7, 0x3045, 0xbabd, 0x3848, 0x35fa, 0x34cf, 0x2921,
    0x3516, 0x39c5, 0xb8ba, 0x317e, 0xb7ec, 0xb535, 0xb26b, 0xab48,
    0x3926, 0x31d3, 0x354d, 0x371b, 0xb622, 0x3418, 0xac02, 0x3723,
    0x306c, 0x3860, 0xb279, 0xa71c, 0x305e, 0xb43d, 0xb0aa, 0xa9b7,
    0xa91d, 0x3a11, 0xaeb6, 0x2f7a, 0xbb15, 0xb6f0, 0x2ccd, 0x2829,
    0xb3f2, 0xb5a4, 0x3438, 0x2bd1, 0xb692, 0x310e, 0x3936, 0xaf55,
    0xb420, 0xac71, 0x3625, 0x2a0f, 0x38c7, 0x383c, 0xb323, 0x38cf,
    0xac11, 0xafb7, 0xb23b, 0xaf06, 0xb166, 0xb06a, 0x2892, 0xb15d,
    0xb959, 0x5191, 0xb680, 0x2dec, 0xb700, 0x2ad7, 0x32f2, 0xb749,
    0x2f68, 0x2981, 0xb63b, 0xba44, 0x38e9, 0x3893, 0xb879, 0xb1b2,
    0x2c88, 0xb690, 0x367e, 0xb8cb, 0x3350, 0xb0b7, 0xb8e3, 0xaff7,
    0xb7dd, 0x2f5a, 0x3b47, 0x3819, 0x381e, 0x3249, 0xaaed, 0xb481
    };

static const uint16_t in_cfft_noisy_256[512] = {
    0x28e8, 0x0, 0x3768, 0x0, 0x3963, 0x0, 0x3676, 0x0,
    0x28c3, 0x0, 0xb781, 0x0, 0xb930, 0x0, 0xb834, 0x0,
    0x2750, 0x0, 0x367a, 0x0, 0x39bc, 0x0, 0x3809, 0x0,
    0x245b, 0x0, 0xb778, 0x0, 0xba4d, 0x0, 0xb8da, 0x0,
    0x2cb1, 0x0, 0x376c, 0x0, 0x39ca, 0x0, 0x3837, 0x0,
    0xa6b7, 0x0, 0xb67d, 0x0, 0xb962, 0x0, 0xb80a, 0x0,
    0xaa96, 0x0, 0x3783, 0x0, 0x3957, 0x0, 0x37c9, 0x0,
    0xaad6, 0x0, 0xb760, 0x0, 0xb9e3, 0x0, 0xb80f, 0x0,
    0xa7c8, 0x0, 0x387f, 0x0, 0x3a15, 0x0, 0x36bd, 0x0,
    0xac11, 0x0, 0xb834, 0x0, 0xb9e1, 0x0, 0xb7c0, 0x0,
    0x2979, 0x0, 0x3842, 0x0, 0x397f, 0x0, 0x3756, 0x0,
    0xaf0e, 0x0, 0xb842, 0x0, 0xb986, 0x0, 0xb7fe, 0x0,
    0x2ba6, 0x0, 0x3723, 0x0, 0x38f9, 0x0, 0x3663, 0x0,
    0xac1d, 0x0, 0xb7d7, 0x0, 0xb986, 0x0, 0xb795, 0x0,
    0x2258, 0x0, 0x374e, 0x0, 0x3a52, 0x0, 0x381a, 0x0,
    0x1ee6, 0x0, 0xb865, 0x0, 0xb94a, 0x0, 0xb78e, 0x0,
    0x142a, 0x0, 0x3804, 0x0, 0x3a23, 0x0, 0x38b7, 0x0,
    0x2a7c, 0x0, 0xb8b5, 0x0, 0xba22, 0x0, 0xb804, 0x0,
    0x1c40, 0x0, 0x386a, 0x0, 0x39a2, 0x0, 0x3835, 0x0,
    0xacc0, 0x0, 0xb7c7, 0x0, 0xb9cf, 0x0, 0xb867, 0x0,
    0x1e7c, 0x0, 0x37a1, 0x0, 0x38a4, 0x0, 0x37c4, 0x0,
    0x271d, 0x0, 0xb768, 0x0, 0xb8f1, 0x0, 0xb77f, 0x0,
    0xa57a, 0x0, 0x37c0, 0x0, 0x3962, 0x0, 0x3792, 0x0,
    0x99de, 0x0, 0xb6c2, 0x0, 0xb98d, 0x0, 0xb78c, 0x0,
    0xa99d, 0x0, 0x380d, 0x0, 0x38e6, 0x0, 0x3867, 0x0,
    0x1bd1, 0x0, 0xb724, 0x0, 0xb93a, 0x0, 0xb75b, 0x0,
    0xac24, 0x0, 0x370e, 0x0, 0x39dd, 0x0, 0x37db, 0x0,
    0xaa9d, 0x0, 0xb721, 0x0, 0xb965, 0x0, 0xb74b, 0x0,
    0x2c5f, 0x0, 0x37a9, 0x0, 0x3969, 0x0, 0x37df, 0x0,
    0x2c91, 0x0, 0xb7b1, 0x0, 0xb94f, 0x0, 0xb6da, 0x0,
    0x2950, 0x0, 0x37ec, 0x0, 0x3970, 0x0, 0x36b0, 0x0,
    0x1a8e, 0x0, 0xb847, 0x0, 0xba54, 0x0, 0xb860, 0x0,
    0xa9d7, 0x0, 0x378b, 0x0, 0x3a43, 0x0, 0x365e, 0x0,
    0xa9fc, 0x0, 0xb76c, 0x0, 0xba10, 0x0, 0xb623, 0x0,
    0xa4c1, 0x0, 0x36a9, 0x0, 0x39fa, 0x0, 0x384a, 0x0,
    0xae70, 0x0, 0xb855, 0x0, 0xb9e2, 0x0, 0xb783, 0x0,
    0x2bba, 0x0, 0x3738, 0x0, 0x38c1, 0x0, 0x3739, 0x0,
    0x2c52, 0x0, 0xb8bb, 0x0, 0xb946, 0x0, 0xb849, 0x0,
    0xa70a, 0x0, 0x38b3, 0x0, 0x3993, 0x0, 0x3710, 0x0,
    0x27c8, 0x0, 0xb745, 0x0, 0xb97e, 0x0, 0xb79e, 0x0,
    0x225f, 0x0, 0x3730, 0x0, 0x397d, 0x0, 0x3610, 0x0,
    0x243a, 0x0, 0xb794, 0x0, 0xb9d4, 0x0, 0xb89d, 0x0,
    0x2202, 0x0, 0x369a, 0x0, 0x3a4c, 0x0, 0x3873, 0x0,
    0x26ad, 0x0, 0xb837, 0x0, 0xba16, 0x0, 0xb812, 0x0,
    0x2771, 0x0, 0x3741, 0x0, 0x39e2, 0x0, 0x3775, 0x0,
    0x2b47, 0x0, 0xb81b, 0x0, 0xb9d1, 0x0, 0xb819, 0x0,
    0x248b, 0x0, 0x371d, 0x0, 0x3996, 0x0, 0x3876, 0x0,
    0x2a46, 0x0, 0xb820, 0x0, 0xb9f4, 0x0, 0xb7f3, 0x0,
    0x25ed, 0x0, 0x378c, 0x0, 0x39d9, 0x0, 0x3741, 0x0,
    0xacca, 0x0, 0xb839, 0x0, 0xb959, 0x0, 0xb80a, 0x0,
    0xa8ec, 0x0, 0x37e9, 0x0, 0x39d8, 0x0, 0x3831, 0x0,
    0xaa93, 0x0, 0xb82e, 0x0, 0xb965, 0x0, 0xb801, 0x0,
    0x26ca, 0x0, 0x37a6, 0x0, 0x3972, 0x0, 0x382b, 0x0,
    0x30b2, 0x0, 0xb87d, 0x0, 0xb8f2, 0x0, 0xb8a1, 0x0,
    0xa4db, 0x0, 0x3852, 0x0, 0x3a09, 0x0, 0x37d2, 0x0,
    0x2923, 0x0, 0xb836, 0x0, 0xb9a2, 0x0, 0xb712, 0x0,
    0xa833, 0x0, 0x38a3, 0x0, 0x38ed, 0x0, 0x3740, 0x0,
    0x2bfa, 0x0, 0xb842, 0x0, 0xb943, 0x0, 0xb79e, 0x0,
    0xa4db, 0x0, 0x3776, 0x0, 0x393b, 0x0, 0x37c6, 0x0,
    0x2bf9, 0x0, 0xb7e9, 0x0, 0xb935, 0x0, 0xb83e, 0x0,
    0x2419, 0x0, 0x3754, 0x0, 0x39fc, 0x0, 0x3732, 0x0,
    0x2c4b, 0x0, 0xb68e, 0x0, 0xb9aa, 0x0, 0xb811, 0x0,
    0x1e73, 0x0, 0x37fa, 0x0, 0x39d8, 0x0, 0x37d3, 0x0,
    0x27f6, 0x0, 0xb7a5, 0x0, 0xb9bc, 0x0, 0xb89f, 0x0
    };

static const uint16_t in_cifft_noisy_256[512] = {
    0xba4a, 0x0, 0x32dc, 0x2f88, 0xa9a6, 0x3c53, 0x345f, 0xa9a1,
    0xb0d7, 0x34e6, 0x3223, 0xb96d, 0xb934, 0x3388, 0x3510, 0x3931,
    0xab2c, 0x3a16, 0xb031, 0xb6ea, 0xbb56, 0xb477, 0x30dc, 0x3a47,
    0xb04a, 0xb59e, 0x3761, 0x3642, 0xb972, 0xb907, 0x38c5, 0xb35f,
    0xb940, 0xb035, 0xb43c, 0x2c9a, 0x2fb1, 0xb896, 0xb8d3, 0x308a,
    0xb8f5, 0xa841, 0xb09a, 0x35b8, 0xb919, 0x2efb, 0x389f, 0x3901,
    0x3747, 0x303e, 0xb76b, 0x3117, 0xadf3, 0xb1f3, 0x39ae, 0x30f4,
    0x367b, 0xbb53, 0xbd4b, 0xb186, 0x3508, 0x3d4b, 0xb939, 0x33c5,
    0xac75, 0xd593, 0x119e, 0xba21, 0xba92, 0x2d9d, 0xbc36, 0x37c1,
    0xb0b5, 0xb8a8, 0xb547, 0x3cbf, 0x37fe, 0x30a1, 0x3cff, 0xbcef,
    0xb4b3, 0xba36, 0x3071, 0x3a06, 0x3908, 0x3ab2, 0x25e7, 0x3b5e,
    0xb2fb, 0xb6d8, 0x3b95, 0x2cf1, 0x36a5, 0xb4c3, 0x2f70, 0xbae7,
    0x3db7, 0x3042, 0x22fb, 0x2fe4, 0xb22c, 0xb9f0, 0xb8c9, 0xb40e,
    0x2d81, 0xb81f, 0x39b5, 0x39ea, 0xb021, 0xb9b9, 0xb844, 0x39d7,
    0xbbeb, 0xbb56, 0x3c47, 0x3ada, 0xb7dc, 0xb594, 0xb5ad, 0x2fa7,
    0x2c7e, 0x382f, 0x3924, 0xb891, 0x37da, 0xb8e9, 0x3126, 0xbba9,
    0x349f, 0xb0f2, 0xaf2e, 0xb43b, 0x2f06, 0xb8c1, 0x36b3, 0xad5c,
    0x2bbb, 0x3992, 0xb0fe, 0xb67b, 0x3a9b, 0xb9c3, 0xae0d, 0xb783,
    0x2003, 0x2a0d, 0x26da, 0xa9e1, 0xad3c, 0xb017, 0x3899, 0x3400,
    0xb51e, 0x3996, 0xb008, 0x32bb, 0xb156, 0xb8c0, 0x21e7, 0x3730,
    0x38b4, 0xbb1e, 0xb8cc, 0xabde, 0x3487, 0x3574, 0x35bc, 0xabf0,
    0xb6ae, 0xba9d, 0x392e, 0xb4ff, 0xb9e5, 0xb4ea, 0x39d1, 0xba54,
    0xbd76, 0x3baf, 0x2f24, 0xba8d, 0xaa74, 0x3757, 0x3337, 0xb807,
    0x3ca9, 0x3a24, 0x3221, 0x3a96, 0xba72, 0x3d45, 0x3275, 0x32b7,
    0x2e24, 0x37cb, 0x3306, 0xbb5b, 0x3aea, 0xa7a4, 0x3b1f, 0xba33,
    0xb0e8, 0x38f6, 0x2f17, 0xb49a, 0x3023, 0x3219, 0xbbc7, 0xb790,
    0xb84c, 0xb25e, 0xb837, 0x3936, 0x3292, 0xb5eb, 0xad58, 0xb781,
    0x347b, 0xb4fd, 0x9bd1, 0xb020, 0x301a, 0x34e0, 0x3824, 0x2ae7,
    0x2c44, 0x3b1a, 0xb58b, 0xb2f9, 0x3786, 0xb7d1, 0xacf4, 0x2468,
    0x3c5e, 0xaac2, 0xb0d2, 0x380a, 0xb8ff, 0x39ea, 0xb185, 0x3a3f,
    0xb879, 0xb70b, 0xac55, 0x32da, 0x383e, 0xab1a, 0x3886, 0x3c03,
    0x3a4a, 0xb79c, 0x34fa, 0xb87a, 0x2e8b, 0x366b, 0x3919, 0xbcec,
    0x3df8, 0x0, 0x3919, 0x3cec, 0x2e8b, 0xb66b, 0x34fa, 0x387a,
    0x3a4a, 0x379c, 0x3886, 0xbc03, 0x383e, 0x2b1a, 0xac55, 0xb2da,
    0xb879, 0x370b, 0xb185, 0xba3f, 0xb8ff, 0xb9ea, 0xb0d2, 0xb80a,
    0x3c5e, 0x2ac2, 0xacf4, 0xa468, 0x3786, 0x37d1, 0xb58b, 0x32f9,
    0x2c44, 0xbb1a, 0x3824, 0xaae7, 0x301a, 0xb4e0, 0x9bd1, 0x3020,
    0x347b, 0x34fd, 0xad58, 0x3781, 0x3292, 0x35eb, 0xb837, 0xb936,
    0xb84c, 0x325e, 0xbbc7, 0x3790, 0x3023, 0xb219, 0x2f17, 0x349a,
    0xb0e8, 0xb8f6, 0x3b1f, 0x3a33, 0x3aea, 0x27a4, 0x3306, 0x3b5b,
    0x2e24, 0xb7cb, 0x3275, 0xb2b7, 0xba72, 0xbd45, 0x3221, 0xba96,
    0x3ca9, 0xba24, 0x3337, 0x3807, 0xaa74, 0xb757, 0x2f24, 0x3a8d,
    0xbd76, 0xbbaf, 0x39d1, 0x3a54, 0xb9e5, 0x34ea, 0x392e, 0x34ff,
    0xb6ae, 0x3a9d, 0x35bc, 0x2bf0, 0x3487, 0xb574, 0xb8cc, 0x2bde,
    0x38b4, 0x3b1e, 0x21e7, 0xb730, 0xb156, 0x38c0, 0xb008, 0xb2bb,
    0xb51e, 0xb996, 0x3899, 0xb400, 0xad3c, 0x3017, 0x26da, 0x29e1,
    0x2003, 0xaa0d, 0xae0d, 0x3783, 0x3a9b, 0x39c3, 0xb0fe, 0x367b,
    0x2bbb, 0xb992, 0x36b3, 0x2d5c, 0x2f06, 0x38c1, 0xaf2e, 0x343b,
    0x349f, 0x30f2, 0x3126, 0x3ba9, 0x37da, 0x38e9, 0x3924, 0x3891,
    0x2c7e, 0xb82f, 0xb5ad, 0xafa7, 0xb7dc, 0x3594, 0x3c47, 0xbada,
    0xbbeb, 0x3b56, 0xb844, 0xb9d7, 0xb021, 0x39b9, 0x39b5, 0xb9ea,
    0x2d81, 0x381f, 0xb8c9, 0x340e, 0xb22c, 0x39f0, 0x22fb, 0xafe4,
    0x3db7, 0xb042, 0x2f70, 0x3ae7, 0x36a5, 0x34c3, 0x3b95, 0xacf1,
    0xb2fb, 0x36d8, 0x25e7, 0xbb5e, 0x3908, 0xbab2, 0x3071, 0xba06,
    0xb4b3, 0x3a36, 0x3cff, 0x3cef, 0x37fe, 0xb0a1, 0xb547, 0xbcbf,
    0xb0b5, 0x38a8, 0xbc36, 0xb7c1, 0xba92, 0xad9d, 0x119e, 0x3a21,
    0xac75, 0x5593, 0xb939, 0xb3c5, 0x3508, 0xbd4b, 0xbd4b, 0x3186,
    0x367b, 0x3b53, 0x39ae, 0xb0f4, 0xadf3, 0x31f3, 0xb76b, 0xb117,
    0x3747, 0xb03e, 0x389f, 0xb901, 0xb919, 0xaefb, 0xb09a, 0xb5b8,
    0xb8f5, 0x2841, 0xb8d3, 0xb08a, 0x2fb1, 0x3896, 0xb43c, 0xac9a,
    0xb940, 0x3035, 0x38c5, 0x335f, 0xb972, 0x3907, 0x3761, 0xb642,
    0xb04a, 0x359e, 0x30dc, 0xba47, 0xbb56, 0x3477, 0xb031, 0x36ea,
    0xab2c, 0xba16, 0x3510, 0xb931, 0xb934, 0xb388, 0x3223, 0x396d,
    0xb0d7, 0xb4e6, 0x345f, 0x29a1, 0xa9a6, 0xbc53, 0x32dc, 0xaf88
    };

static const uint16_t ref_cfft_noisy_256[512] = {
    0xba4a, 0x0, 0x32dc, 0x2f88, 0xa9a6, 0x3c53, 0x345f, 0xa9a1,
    0xb0d7, 0x34e6, 0x3223, 0xb96d, 0xb934, 0x3388, 0x3510, 0x3931,
    0xab2c, 0x3a16, 0xb031, 0xb6ea, 0xbb56, 0xb477, 0x30dc, 0x3a47,
    0xb04a, 0xb59e, 0x3761, 0x3642, 0xb972, 0xb907, 0x38c5, 0xb35f,
    0xb940, 0xb035, 0xb43c, 0x2c9a, 0x2fb1, 0xb896, 0xb8d3, 0x308a,
    0xb8f5, 0xa841, 0xb09a, 0x35b8, 0xb919, 0x2efb, 0x389f, 0x3901,
    0x3747, 0x303e, 0xb76b, 0x3117, 0xadf3, 0xb1f3, 0x39ae, 0x30f4,
    0x367b, 0xbb53, 0xbd4b, 0xb186, 0x3508, 0x3d4b, 0xb939, 0x33c5,
    0xac75, 0xd593, 0x119e, 0xba21, 0xba92, 0x2d9d, 0xbc36, 0x37c1,
    0xb0b5, 0xb8a8, 0xb547, 0x3cbf, 0x37fe, 0x30a1, 0x3cff, 0xbcef,
    0xb4b3, 0xba36, 0x3071, 0x3a06, 0x3908, 0x3ab2, 0x25e7, 0x3b5e,
    0xb2fb, 0xb6d8, 0x3b95, 0x2cf1, 0x36a5, 0xb4c3, 0x2f70, 0xbae7,
    0x3db7, 0x3042, 0x22fb, 0x2fe4, 0xb22c, 0xb9f0, 0xb8c9, 0xb40e,
    0x2d81, 0xb81f, 0x39b5, 0x39ea, 0xb021, 0xb9b9, 0xb844, 0x39d7,
    0xbbeb, 0xbb56, 0x3c47, 0x3ada, 0xb7dc, 0xb594, 0xb5ad, 0x2fa7,
    0x2c7e, 0x382f, 0x3924, 0xb891, 0x37da, 0xb8e9, 0x3126, 0xbba9,
    0x349f, 0xb0f2, 0xaf2e, 0xb43b, 0x2f06, 0xb8c1, 0x36b3, 0xad5c,
    0x2bbb, 0x3992, 0xb0fe, 0xb67b, 0x3a9b, 0xb9c3, 0xae0d, 0xb783,
    0x2003, 0x2a0d, 0x26da, 0xa9e1, 0xad3c, 0xb017, 0x3899, 0x3400,
    0xb51e, 0x3996, 0xb008, 0x32bb, 0xb156, 0xb8c0, 0x21e7, 0x3730,
    0x38b4, 0xbb1e, 0xb8cc, 0xabde, 0x3487, 0x3574, 0x35bc, 0xabf0,
    0xb6ae, 0xba9d, 0x392e, 0xb4ff, 0xb9e5, 0xb4ea, 0x39d1, 0xba54,
    0xbd76, 0x3baf, 0x2f24, 0xba8d, 0xaa74, 0x3757, 0x3337, 0xb807,
    0x3ca9, 0x3a24, 0x3221, 0x3a96, 0xba72, 0x3d45, 0x3275, 0x32b7,
    0x2e24, 0x37cb, 0x3306, 0xbb5b, 0x3aea, 0xa7a4, 0x3b1f, 0xba33,
    0xb0e8, 0x38f6, 0x2f17, 0xb49a, 0x3023, 0x3219, 0xbbc7, 0xb790,
    0xb84c, 0xb25e, 0xb837, 0x3936, 0x3292, 0xb5eb, 0xad58, 0xb781,
    0x347b, 0xb4fd, 0x9bd1, 0xb020, 0x301a, 0x34e0, 0x3824, 0x2ae7,
    0x2c44, 0x3b1a, 0xb58b, 0xb2f9, 0x3786, 0xb7d1, 0xacf4, 0x2468,
    0x3c5e, 0xaac2, 0xb0d2, 0x380a, 0xb8ff, 0x39ea, 0xb185, 0x3a3f,
    0xb879, 0xb70b, 0xac55, 0x32da, 0x383e, 0xab1a, 0x3886, 0x3c03,
    0x3a4a, 0xb79c, 0x34fa, 0xb87a, 0x2e8b, 0x366b, 0x3919, 0xbcec,
    0x3df8, 0x0, 0x3919, 0x3cec, 0x2e8b, 0xb66b, 0x34fa, 0x387a,
    0x3a4a, 0x379c, 0x3886, 0xbc03, 0x383e, 0x2b1a, 0xac55, 0xb2da,
    0xb879, 0x370b, 0xb185, 0xba3f, 0xb8ff, 0xb9ea, 0xb0d2, 0xb80a,
    0x3c5e, 0x2ac2, 0xacf4, 0xa468, 0x3786, 0x37d1, 0xb58b, 0x32f9,
    0x2c44, 0xbb1a, 0x3824, 0xaae7, 0x301a, 0xb4e0, 0x9bd1, 0x3020,
    0x347b, 0x34fd, 0xad58, 0x3781, 0x3292, 0x35eb, 0xb837, 0xb936,
    0xb84c, 0x325e, 0xbbc7, 0x3790, 0x3023, 0xb219, 0x2f17, 0x349a,
    0xb0e8, 0xb8f6, 0x3b1f, 0x3a33, 0x3aea, 0x27a4, 0x3306, 0x3b5b,
    0x2e24, 0xb7cb, 0x3275, 0xb2b7, 0xba72, 0xbd45, 0x3221, 0xba96,
    0x3ca9, 0xba24, 0x3337, 0x3807, 0xaa74, 0xb757, 0x2f24, 0x3a8d,
    0xbd76, 0xbbaf, 0x39d1, 0x3a54, 0xb9e5, 0x34ea, 0x392e, 0x34ff,
    0xb6ae, 0x3a9d, 0x35bc, 0x2bf0, 0x3487, 0xb574, 0xb8cc, 0x2bde,
    0x38b4, 0x3b1e, 0x21e7, 0xb730, 0xb156, 0x38c0, 0xb008, 0xb2bb,
    0xb51e, 0xb996, 0x3899, 0xb400, 0xad3c, 0x3017, 0x26da, 0x29e1,
    0x2003, 0xaa0d, 0xae0d, 0x3783, 0x3a9b, 0x39c3, 0xb0fe, 0x367b,
    0x2bbb, 0xb992, 0x36b3, 0x2d5c, 0x2f06, 0x38c1, 0xaf2e, 0x343b,
    0x349f, 0x30f2, 0x3126, 0x3ba9, 0x37da, 0x38e9, 0x3924, 0x3891,
    0x2c7e, 0xb82f, 0xb5ad, 0xafa7, 0xb7dc, 0x3594, 0x3c47, 0xbada,
    0xbbeb, 0x3b56, 0xb844, 0xb9d7, 0xb021, 0x39b9, 0x39b5, 0xb9ea,
    0x2d81, 0x381f, 0xb8c9, 0x340e, 0xb22c, 0x39f0, 0x22fb, 0xafe4,
    0x3db7, 0xb042, 0x2f70, 0x3ae7, 0x36a5, 0x34c3, 0x3b95, 0xacf1,
    0xb2fb, 0x36d8, 0x25e7, 0xbb5e, 0x3908, 0xbab2, 0x3071, 0xba06,
    0xb4b3, 0x3a36, 0x3cff, 0x3cef, 0x37fe, 0xb0a1, 0xb547, 0xbcbf,
    0xb0b5, 0x38a8, 0xbc36, 0xb7c1, 0xba92, 0xad9d, 0x119e, 0x3a21,
    0xac75, 0x5593, 0xb939, 0xb3c5, 0x3508, 0xbd4b, 0xbd4b, 0x3186,
    0x367b, 0x3b53, 0x39ae, 0xb0f4, 0xadf3, 0x31f3, 0xb76b, 0xb117,
    0x3747, 0xb03e, 0x389f, 0xb901, 0xb919, 0xaefb, 0xb09a, 0xb5b8,
    0xb8f5, 0x2841, 0xb8d3, 0xb08a, 0x2fb1, 0x3896, 0xb43c, 0xac9a,
    0xb940, 0x3035, 0x38c5, 0x335f, 0xb972, 0x3907, 0x3761, 0xb642,
    0xb04a, 0x359e, 0x30dc, 0xba47, 0xbb56, 0x3477, 0xb031, 0x36ea,
    0xab2c, 0xba16, 0x3510, 0xb931, 0xb934, 0xb388, 0x3223, 0x396d,
    0xb0d7, 0xb4e6, 0x345f, 0x29a1, 0xa9a6, 0xbc53, 0x32dc, 0xaf88
    };

static const uint16_t in_cfft_noisy_512[1024] = {
    0xa984, 0x0, 0x37c5, 0x0, 0x39be, 0x0, 0x377b, 0x0,
    0xa8b2, 0x0, 0xb8cb, 0x0, 0xb9b9, 0x0, 0xb832, 0x0,
    0x21e4, 0x0, 0x37ce, 0x0, 0x399c, 0x0, 0x3811, 0x0,
    0x1d1f, 0x0, 0xb78b, 0x0, 0xb901, 0x0, 0xb8b1, 0x0,
    0x2cc0, 0x0, 0x3693, 0x0, 0x39c9, 0x0, 0x388f, 0x0,
    0xa70d, 0x0, 0xb69d, 0x0, 0xb916, 0x0, 0xb8a1, 0x0,
    0xa119, 0x0, 0x3834, 0x0, 0x393d, 0x0, 0x38b9, 0x0,
    0x2883, 0x0, 0xb7ba, 0x0, 0xb994, 0x0, 0xb83b, 0x0,
    0x1e74, 0x0, 0x36d7, 0x0, 0x393a, 0x0, 0x3887, 0x0,
    0xa960, 0x0, 0xb7d6, 0x0, 0xb8c1, 0x0, 0xb8b1, 0x0,
    0xaa36, 0x0, 0x37b9, 0x0, 0x3919, 0x0, 0x3894, 0x0,
    0x2b7a, 0x0, 0xb81b, 0x0, 0xba71, 0x0, 0xb792, 0x0,
    0x2a10, 0x0, 0x3879, 0x0, 0x39ce, 0x0, 0x3621, 0x0,
    0x1c92, 0x0, 0xb837, 0x0, 0xb906, 0x0, 0xb71e, 0x0,
    0xa9f4, 0x0, 0x3854, 0x0, 0x394f, 0x0, 0x36fb, 0x0,
    0x2c8b, 0x0, 0xb785, 0x0, 0xb9cc, 0x0, 0xb78a, 0x0,
    0xa6c2, 0x0, 0x3838, 0x0, 0x3963, 0x0, 0x3610, 0x0,
    0xabd4, 0x0, 0xb84c, 0x0, 0xba05, 0x0, 0xb735, 0x0,
    0x24aa, 0x0, 0x3847, 0x0, 0x3987, 0x0, 0x37bb, 0x0,
    0x2ad6, 0x0, 0xb6e1, 0x0, 0xb930, 0x0, 0xb826, 0x0,
    0xa3e0, 0x0, 0x382f, 0x0, 0x39a1, 0x0, 0x3914, 0x0,
    0x2ec6, 0x0, 0xb760, 0x0, 0xb96a, 0x0, 0xb8b9, 0x0,
    0xa4c7, 0x0, 0x384e, 0x0, 0x396a, 0x0, 0x382e, 0x0,
    0xab1b, 0x0, 0xb71d, 0x0, 0xb987, 0x0, 0xb8bc, 0x0,
    0x2e6e, 0x0, 0x3777, 0x0, 0x398d, 0x0, 0x3761, 0x0,
    0x2559, 0x0, 0xb5ed, 0x0, 0xb9fa, 0x0, 0xb802, 0x0,
    0xa76b, 0x0, 0x3806, 0x0, 0x39c2, 0x0, 0x36e9, 0x0,
    0x9b9e, 0x0, 0xb7ef, 0x0, 0xb938, 0x0, 0xb824, 0x0,
    0x216e, 0x0, 0x381f, 0x0, 0x39a8, 0x0, 0x36bb, 0x0,
    0xa91e, 0x0, 0xb817, 0x0, 0xb8ed, 0x0, 0xb792, 0x0,
    0x2a26, 0x0, 0x37e6, 0x0, 0x39c4, 0x0, 0x36ef, 0x0,
    0x2955, 0x0, 0xb79b, 0x0, 0xb9a9, 0x0, 0xb909, 0x0,
    0xa9db, 0x0, 0x37a3, 0x0, 0x3962, 0x0, 0x37ed, 0x0,
    0x2a3d, 0x0, 0xb765, 0x0, 0xb930, 0x0, 0xb86e, 0x0,
    0x26f4, 0x0, 0x3841, 0x0, 0x399f, 0x0, 0x3783, 0x0,
    0x280d, 0x0, 0xb819, 0x0, 0xb91a, 0x0, 0xb77c, 0x0,
    0xb064, 0x0, 0x37cc, 0x0, 0x390b, 0x0, 0x3875, 0x0,
    0x2591, 0x0, 0xb699, 0x0, 0xb9a1, 0x0, 0xb6f5, 0x0,
    0xa51c, 0x0, 0x370c, 0x0, 0x39bf, 0x0, 0x37ed, 0x0,
    0xa905, 0x0, 0xb81f, 0x0, 0xb911, 0x0, 0xb843, 0x0,
    0xaaea, 0x0, 0x3838, 0x0, 0x3985, 0x0, 0x3643, 0x0,
    0x2f08, 0x0, 0xb813, 0x0, 0xb8af, 0x0, 0xb73f, 0x0,
    0x29a3, 0x0, 0x3815, 0x0, 0x3a1b, 0x0, 0x37c1, 0x0,
    0xa837, 0x0, 0xb82c, 0x0, 0xb9a6, 0x0, 0xb842, 0x0,
    0xae43, 0x0, 0x3707, 0x0, 0x394d, 0x0, 0x38b9, 0x0,
    0x2f49, 0x0, 0xb6e0, 0x0, 0xba23, 0x0, 0xb738, 0x0,
    0xa40f, 0x0, 0x3830, 0x0, 0x39ae, 0x0, 0x377e, 0x0,
    0xa7d2, 0x0, 0xb751, 0x0, 0xb98e, 0x0, 0xb855, 0x0,
    0x2846, 0x0, 0x37ce, 0x0, 0x398d, 0x0, 0x3860, 0x0,
    0x2fe0, 0x0, 0xb821, 0x0, 0xb9a0, 0x0, 0xb739, 0x0,
    0x9cc5, 0x0, 0x38a0, 0x0, 0x3a37, 0x0, 0x3889, 0x0,
    0xa458, 0x0, 0xb6de, 0x0, 0xb976, 0x0, 0xb83c, 0x0,
    0x29ef, 0x0, 0x3756, 0x0, 0x395b, 0x0, 0x36fd, 0x0,
    0x9de2, 0x0, 0xb754, 0x0, 0xb995, 0x0, 0xb864, 0x0,
    0xa950, 0x0, 0x37c3, 0x0, 0x3969, 0x0, 0x38e5, 0x0,
    0xae67, 0x0, 0xb80c, 0x0, 0xb926, 0x0, 0xb5b4, 0x0,
    0xa14c, 0x0, 0x3777, 0x0, 0x3904, 0x0, 0x3811, 0x0,
    0x2aa4, 0x0, 0xb757, 0x0, 0xb93e, 0x0, 0xb81c, 0x0,
    0x29e1, 0x0, 0x371b, 0x0, 0x39c2, 0x0, 0x38ac, 0x0,
    0x2716, 0x0, 0xb8b1, 0x0, 0xb9ab, 0x0, 0xb70b, 0x0,
    0x2526, 0x0, 0x3801, 0x0, 0x3997, 0x0, 0x384f, 0x0,
    0xa696, 0x0, 0xb8b9, 0x0, 0xba01, 0x0, 0xb868, 0x0,
    0x25d4, 0x0, 0x3803, 0x0, 0x390f, 0x0, 0x3858, 0x0,
    0x28fa, 0x0, 0xb877, 0x0, 0xb9f2, 0x0, 0xb8b0, 0x0,
    0x22f7, 0x0, 0x386b, 0x0, 0x396a, 0x0, 0x37ef, 0x0,
    0x251d, 0x0, 0xb7c0, 0x0, 0xba67, 0x0, 0xb84a, 0x0,
    0xa512, 0x0, 0x380e, 0x0, 0x39c9, 0x0, 0x37da, 0x0,
    0xaac3, 0x0, 0xb864, 0x0, 0xb9c2, 0x0, 0xb6b0, 0x0,
    0x2523, 0x0, 0x3814, 0x0, 0x3949, 0x0, 0x36a0, 0x0,
    0x2bed, 0x0, 0xb86d, 0x0, 0xb97c, 0x0, 0xb899, 0x0,
    0x2186, 0x0, 0x3740, 0x0, 0x39d0, 0x0, 0x3816, 0x0,
    0x21c1, 0x0, 0xb7ba, 0x0, 0xb9c8, 0x0, 0xb817, 0x0,
    0x2526, 0x0, 0x3809, 0x0, 0x38bc, 0x0, 0x3769, 0x0,
    0x13b5, 0x0, 0xb86d, 0x0, 0xb96b, 0x0, 0xb711, 0x0,
    0x2c6a, 0x0, 0x378b, 0x0, 0x3a45, 0x0, 0x3796, 0x0,
    0x22ad, 0x0, 0xb801, 0x0, 0xba27, 0x0, 0xb815, 0x0,
    0x2aa8, 0x0, 0x379d, 0x0, 0x39fa, 0x0, 0x3811, 0x0,
    0x2c78, 0x0, 0xb7ce, 0x0, 0xba96, 0x0, 0xb87f, 0x0,
    0x2c66, 0x0, 0x382f, 0x0, 0x39b2, 0x0, 0x370d, 0x0,
    0x23c5, 0x0, 0xb774, 0x0, 0xb9ca, 0x0, 0xb74a, 0x0,
    0x27d1, 0x0, 0x3803, 0x0, 0x390a, 0x0, 0x3750, 0x0,
    0xa29d, 0x0, 0xb86b, 0x0, 0xba4f, 0x0, 0xb825, 0x0,
    0x230f, 0x0, 0x385e, 0x0, 0x3938, 0x0, 0x3826, 0x0,
    0xa960, 0x0, 0xb7e9, 0x0, 0xb9b6, 0x0, 0xb825, 0x0,
    0xa874, 0x0, 0x387f, 0x0, 0x393d, 0x0, 0x36d0, 0x0,
    0xa8e8, 0x0, 0xb842, 0x0, 0xb99a, 0x0, 0xb6ed, 0x0,
    0x986c, 0x0, 0x383f, 0x0, 0x3950, 0x0, 0x38e2, 0x0,
    0xae9d, 0x0, 0xb63b, 0x0, 0xb952, 0x0, 0xb76f, 0x0,
    0x3067, 0x0, 0x37b3, 0x0, 0x3938, 0x0, 0x375f, 0x0,
    0x22a2, 0x0, 0xb827, 0x0, 0xb9e8, 0x0, 0xb765, 0x0,
    0xa2e1, 0x0, 0x3800, 0x0, 0x3975, 0x0, 0x376a, 0x0,
    0x1c74, 0x0, 0xb76a, 0x0, 0xb914, 0x0, 0xb798, 0x0,
    0xb05b, 0x0, 0x3825, 0x0, 0x39f3, 0x0, 0x36ef, 0x0,
    0x2ee3, 0x0, 0xb6f8, 0x0, 0xba40, 0x0, 0xb7cd, 0x0,
    0x3127, 0x0, 0x37d1, 0x0, 0x39b4, 0x0, 0x3702, 0x0,
    0x2266, 0x0, 0xb822, 0x0, 0xb94b, 0x0, 0xb6e2, 0x0,
    0x2fc9, 0x0, 0x3825, 0x0, 0x397d, 0x0, 0x3887, 0x0,
    0xa640, 0x0, 0xb7ec, 0x0, 0xb981, 0x0, 0xb803, 0x0,
    0x9735, 0x0, 0x37eb, 0x0, 0x38db, 0x0, 0x3843, 0x0,
    0xb063, 0x0, 0xb828, 0x0, 0xba4e, 0x0, 0xb778, 0x0,
    0xa85d, 0x0, 0x36f0, 0x0, 0x38f1, 0x0, 0x37b6, 0x0,
    0x294e, 0x0, 0xb850, 0x0, 0xb95f, 0x0, 0xb7d8, 0x0,
    0xac86, 0x0, 0x37b6, 0x0, 0x3a00, 0x0, 0x374d, 0x0,
    0xae0c, 0x0, 0xb792, 0x0, 0xb995, 0x0, 0xb71c, 0x0,
    0xa578, 0x0, 0x384b, 0x0, 0x3a34, 0x0, 0x37cc, 0x0,
    0xa969, 0x0, 0xb899, 0x0, 0xb972, 0x0, 0xb840, 0x0,
    0xace9, 0x0, 0x382d, 0x0, 0x39d7, 0x0, 0x37cd, 0x0,
    0x28c1, 0x0, 0xb6ad, 0x0, 0xb982, 0x0, 0xb817, 0x0,
    0x232d, 0x0, 0x36dc, 0x0, 0x3948, 0x0, 0x3720, 0x0,
    0x2d9e, 0x0, 0xb855, 0x0, 0xb92c, 0x0, 0xb754, 0x0,
    0x1c25, 0x0, 0x37b0, 0x0, 0x39e6, 0x0, 0x36e4, 0x0,
    0x2aaf, 0x0, 0xb78e, 0x0, 0xb996, 0x0, 0xb808, 0x0,
    0xa6c2, 0x0, 0x37cb, 0x0, 0x39a1, 0x0, 0x37d3, 0x0,
    0x2efc, 0x0, 0xb873, 0x0, 0xba1a, 0x0, 0xb6a4, 0x0,
    0x2413, 0x0, 0x368d, 0x0, 0x3a2d, 0x0, 0x37e0, 0x0,
    0xa1c4, 0x0, 0xb7ef, 0x0, 0xb9ca, 0x0, 0xb84b, 0x0,
    0xa952, 0x0, 0x3886, 0x0, 0x3a64, 0x0, 0x3800, 0x0,
    0xac73, 0x0, 0xb81a, 0x0, 0xb992, 0x0, 0xb7f1, 0x0,
    0xae6a, 0x0, 0x3839, 0x0, 0x38fd, 0x0, 0x3747, 0x0,
    0x277e, 0x0, 0xb7ac, 0x0, 0xb8da, 0x0, 0xb84f, 0x0,
    0xa9a0, 0x0, 0x36d8, 0x0, 0x39fe, 0x0, 0x3830, 0x0,
    0xad6a, 0x0, 0xb88b, 0x0, 0xb940, 0x0, 0xb730, 0x0,
    0x2a6c, 0x0, 0x38c8, 0x0, 0x39de, 0x0, 0x3768, 0x0,
    0xabdd, 0x0, 0xb7c1, 0x0, 0xb97f, 0x0, 0xb7aa, 0x0,
    0xa8a4, 0x0, 0x37c7, 0x0, 0x39f3, 0x0, 0x3873, 0x0,
    0x21ee, 0x0, 0xb801, 0x0, 0xba20, 0x0, 0xb80b, 0x0,
    0xa3cf, 0x0, 0x3779, 0x0, 0x39cc, 0x0, 0x375c, 0x0,
    0xaa7e, 0x0, 0xb87b, 0x0, 0xb9bb, 0x0, 0xb712, 0x0
    };

static const uint16_t in_cifft_noisy_512[1024] = {
    0xae39, 0x0, 0xb066, 0xbb44, 0xb9d6, 0x3658, 0x380c, 0xba86,
    0xbb77, 0x3a46, 0xaa91, 0x356e, 0xb6f4, 0xbc36, 0x3ce7, 0xb8b9,
    0xb856, 0x38fe, 0xbd12, 0xabd5, 0xbb0f, 0x3743, 0xb51d, 0xb4b4,
    0xadf3, 0x3085, 0xae10, 0x3a97, 0xc057, 0xbda3, 0xb114, 0xb701,
    0xb2eb, 0xb013, 0xbdcd, 0x3ec5, 0x356a, 0xa8ec, 0x380f, 0xb962,
    0x3916, 0x2c2a, 0x3068, 0xb7c5, 0xae71, 0x32bf, 0xb8d9, 0xb253,
    0xb55b, 0x3482, 0x3bcc, 0x3b41, 0x3765, 0xa5bb, 0xba32, 0x1aef,
    0x38f5, 0xbd2d, 0xbb67, 0x3617, 0xb428, 0x3d64, 0x3bab, 0xbd07,
    0xb8bb, 0x3701, 0xb5eb, 0x3b17, 0x3ded, 0x3223, 0xb9ad, 0xb9c2,
    0xb321, 0x2c2b, 0x3c6c, 0xb006, 0x330a, 0x322c, 0xbce1, 0x3737,
    0x32af, 0xb9a3, 0xacdd, 0x2d8c, 0x3f46, 0xb874, 0x3fbc, 0xb6bd,
    0xb25f, 0xb7f2, 0x3c85, 0x3dd3, 0xbc35, 0x3832, 0x35e3, 0xb888,
    0x3cc1, 0x3d4d, 0x3747, 0x38f2, 0xb851, 0x3d8b, 0xada2, 0x14ea,
    0xbb34, 0xbc93, 0xbc01, 0x3840, 0xb0bf, 0x28e4, 0x4002, 0x373c,
    0x3736, 0xbdef, 0x31ae, 0x2de6, 0xb0d3, 0xbdea, 0xb22e, 0xbbe4,
    0x34be, 0xb8fb, 0xb54d, 0x3173, 0x3286, 0xb855, 0xba41, 0xbd12,
    0xb348, 0xd999, 0x269a, 0x3f51, 0x2774, 0xc061, 0x373a, 0x3680,
    0x36e8, 0x39a3, 0x3805, 0x3042, 0x2c76, 0x36f0, 0xb878, 0x3ed4,
    0x38bd, 0xb92c, 0x3bf3, 0x3cc5, 0x3c80, 0xbdfb, 0xb02c, 0xbe38,
    0x39c3, 0xb8b3, 0x327d, 0x38f9, 0xba73, 0x380e, 0x284b, 0xb84b,
    0x362b, 0xaf22, 0xb243, 0xab63, 0xb5cb, 0xb5fb, 0x3bde, 0xb8a3,
    0xb985, 0xb864, 0x3e33, 0x380d, 0x3b95, 0xba21, 0x4083, 0xc006,
    0xbe08, 0x347b, 0xbaf2, 0x3539, 0xb82a, 0x3a79, 0x3916, 0x40ad,
    0x3216, 0x3d13, 0xbd63, 0x3ead, 0x3d07, 0x3424, 0xbb4d, 0xba70,
    0xb584, 0x3d96, 0xbc39, 0xbf63, 0xb0b4, 0xbb0f, 0xb883, 0xb8aa,
    0xa9f5, 0xb436, 0xb899, 0x3719, 0xb533, 0x367b, 0x3495, 0x3b38,
    0xbb28, 0xb78b, 0x38ed, 0x35b0, 0x3658, 0xb15c, 0xbda0, 0x3775,
    0x3e2d, 0xbdb9, 0xaf48, 0xa4c5, 0xb880, 0x3928, 0xad64, 0x3c1b,
    0xa710, 0xb406, 0xbab6, 0x2c69, 0xb856, 0x2dd7, 0x3904, 0x3ab0,
    0xb028, 0x31b4, 0x3450, 0x21e8, 0x3b3d, 0xbd1e, 0xb732, 0x38b5,
    0x3e99, 0xbb90, 0xb7f5, 0x3d1d, 0x3878, 0x3834, 0xb5ba, 0xb34f,
    0xb9fb, 0x3949, 0xbd1c, 0x387f, 0x3d26, 0x4159, 0xb9e5, 0xb9d2,
    0x3768, 0xb7bd, 0xc0b7, 0x9a78, 0xbb95, 0xb4ef, 0x34f0, 0xb1db,
    0xb2b1, 0x353d, 0x2ce3, 0xabae, 0xba8c, 0xb8e9, 0x3a07, 0xb820,
    0x3e95, 0x33dd, 0xb190, 0x3d98, 0xbde1, 0x38fe, 0xb518, 0x2f5e,
    0xae61, 0xba24, 0xb5b2, 0x3745, 0x3040, 0x39a3, 0x38c6, 0xb0ef,
    0x3b28, 0x2c2b, 0xbc46, 0x38de, 0x3210, 0xad3b, 0x3993, 0x3c52,
    0xb72a, 0x3ac1, 0xbbcc, 0x3930, 0xb80f, 0xbf70, 0xb39e, 0xb56f,
    0x3445, 0xb1fc, 0xb800, 0xbed8, 0x3c64, 0xb6ab, 0x376c, 0x291c,
    0xbd69, 0x3dba, 0xbc54, 0xb8f9, 0xbafd, 0x3a9c, 0x37f0, 0x3ccf,
    0x36ca, 0xbd8c, 0x3c80, 0x3e2a, 0x39a0, 0x3d0b, 0x3203, 0xade6,
    0xba3b, 0xac45, 0x3e79, 0x3387, 0xb95c, 0xbddb, 0xb8a0, 0x2c3c,
    0xb8fa, 0xb45a, 0x9e32, 0xbe61, 0x2c83, 0x3043, 0xb8ac, 0xaed0,
    0x3a70, 0xad3f, 0x392a, 0xb24b, 0xbdd4, 0x3535, 0xb4ae, 0x32d6,
    0x37f4, 0xb922, 0xb833, 0x3d43, 0xbcdf, 0xba88, 0x3b47, 0xbc96,
    0x3962, 0xb37f, 0xb5ce, 0x33a9, 0xbd0f, 0x36bd, 0xb8fa, 0x3855,
    0xadab, 0x3f05, 0xb894, 0x3f34, 0xb91e, 0x392b, 0x402f, 0x3c17,
    0x3b0b, 0xbcfb, 0x3c84, 0x3923, 0x39e1, 0x3173, 0x39fa, 0x2d94,
    0xb5e6, 0xba18, 0xbc19, 0xb048, 0x310a, 0xbcb3, 0xb489, 0xba4e,
    0x3aaa, 0xb17b, 0x38ea, 0xb0ff, 0x2b67, 0xbaf2, 0xb947, 0xb25d,
    0xc043, 0x280e, 0xbaa2, 0x3816, 0x28bf, 0x4092, 0xbcda, 0x3308,
    0x390b, 0xbdcd, 0xbbe8, 0xb022, 0xb8cb, 0x352e, 0xbb32, 0xacf6,
    0x370f, 0xb3ba, 0x2cb0, 0xb2e9, 0xb55d, 0xbdbe, 0xbcd4, 0x390d,
    0xb512, 0x3dc5, 0xb80c, 0x39e9, 0x3976, 0x3666, 0xb66f, 0x3c4f,
    0xb8ff, 0xb768, 0x2739, 0xb489, 0x36f4, 0x3c10, 0xa8f2, 0x33fe,
    0xb8f1, 0xbf29, 0xb999, 0x32bf, 0xa4dc, 0x2f11, 0x3d9f, 0x2e82,
    0xa4e4, 0x3d20, 0xaf76, 0xb80d, 0x2879, 0xa4ef, 0x3dea, 0xb7c7,
    0xb555, 0x35f2, 0x383d, 0x3471, 0x35ff, 0xb7ad, 0xbfa4, 0xa6de,
    0x2c8a, 0xbd19, 0xbd05, 0x3883, 0x3681, 0xa251, 0xbd4a, 0xbd7e,
    0x37e8, 0xb7f5, 0x3b03, 0x3ac9, 0xb38b, 0xb533, 0xba11, 0x30d3,
    0x35d1, 0x3174, 0x3c70, 0xb512, 0xbe7f, 0x3c02, 0x37a6, 0x3ece,
    0x2ce5, 0xb90a, 0xb486, 0x36ba, 0xb52b, 0x3c7a, 0xad4f, 0x346b,
    0x38ff, 0xbe97, 0x3c3d, 0x3a52, 0xb787, 0x3e05, 0x311b, 0x3337,
    0x36a9, 0x3c29, 0xb967, 0xbdb2, 0x33ff, 0xb4ea, 0x3758, 0x3813,
    0x3833, 0x0, 0x3758, 0xb813, 0x33ff, 0x34ea, 0xb967, 0x3db2,
    0x36a9, 0xbc29, 0x311b, 0xb337, 0xb787, 0xbe05, 0x3c3d, 0xba52,
    0x38ff, 0x3e97, 0xad4f, 0xb46b, 0xb52b, 0xbc7a, 0xb486, 0xb6ba,
    0x2ce5, 0x390a, 0x37a6, 0xbece, 0xbe7f, 0xbc02, 0x3c70, 0x3512,
    0x35d1, 0xb174, 0xba11, 0xb0d3, 0xb38b, 0x3533, 0x3b03, 0xbac9,
    0x37e8, 0x37f5, 0xbd4a, 0x3d7e, 0x3681, 0x2251, 0xbd05, 0xb883,
    0x2c8a, 0x3d19, 0xbfa4, 0x26de, 0x35ff, 0x37ad, 0x383d, 0xb471,
    0xb555, 0xb5f2, 0x3dea, 0x37c7, 0x2879, 0x24ef, 0xaf76, 0x380d,
    0xa4e4, 0xbd20, 0x3d9f, 0xae82, 0xa4dc, 0xaf11, 0xb999, 0xb2bf,
    0xb8f1, 0x3f29, 0xa8f2, 0xb3fe, 0x36f4, 0xbc10, 0x2739, 0x3489,
    0xb8ff, 0x3768, 0xb66f, 0xbc4f, 0x3976, 0xb666, 0xb80c, 0xb9e9,
    0xb512, 0xbdc5, 0xbcd4, 0xb90d, 0xb55d, 0x3dbe, 0x2cb0, 0x32e9,
    0x370f, 0x33ba, 0xbb32, 0x2cf6, 0xb8cb, 0xb52e, 0xbbe8, 0x3022,
    0x390b, 0x3dcd, 0xbcda, 0xb308, 0x28bf, 0xc092, 0xbaa2, 0xb816,
    0xc043, 0xa80e, 0xb947, 0x325d, 0x2b67, 0x3af2, 0x38ea, 0x30ff,
    0x3aaa, 0x317b, 0xb489, 0x3a4e, 0x310a, 0x3cb3, 0xbc19, 0x3048,
    0xb5e6, 0x3a18, 0x39fa, 0xad94, 0x39e1, 0xb173, 0x3c84, 0xb923,
    0x3b0b, 0x3cfb, 0x402f, 0xbc17, 0xb91e, 0xb92b, 0xb894, 0xbf34,
    0xadab, 0xbf05, 0xb8fa, 0xb855, 0xbd0f, 0xb6bd, 0xb5ce, 0xb3a9,
    0x3962, 0x337f, 0x3b47, 0x3c96, 0xbcdf, 0x3a88, 0xb833, 0xbd43,
    0x37f4, 0x3922, 0xb4ae, 0xb2d6, 0xbdd4, 0xb535, 0x392a, 0x324b,
    0x3a70, 0x2d3f, 0xb8ac, 0x2ed0, 0x2c83, 0xb043, 0x9e32, 0x3e61,
    0xb8fa, 0x345a, 0xb8a0, 0xac3c, 0xb95c, 0x3ddb, 0x3e79, 0xb387,
    0xba3b, 0x2c45, 0x3203, 0x2de6, 0x39a0, 0xbd0b, 0x3c80, 0xbe2a,
    0x36ca, 0x3d8c, 0x37f0, 0xbccf, 0xbafd, 0xba9c, 0xbc54, 0x38f9,
    0xbd69, 0xbdba, 0x376c, 0xa91c, 0x3c64, 0x36ab, 0xb800, 0x3ed8,
    0x3445, 0x31fc, 0xb39e, 0x356f, 0xb80f, 0x3f70, 0xbbcc, 0xb930,
    0xb72a, 0xbac1, 0x3993, 0xbc52, 0x3210, 0x2d3b, 0xbc46, 0xb8de,
    0x3b28, 0xac2b, 0x38c6, 0x30ef, 0x3040, 0xb9a3, 0xb5b2, 0xb745,
    0xae61, 0x3a24, 0xb518, 0xaf5e, 0xbde1, 0xb8fe, 0xb190, 0xbd98,
    0x3e95, 0xb3dd, 0x3a07, 0x3820, 0xba8c, 0x38e9, 0x2ce3, 0x2bae,
    0xb2b1, 0xb53d, 0x34f0, 0x31db, 0xbb95, 0x34ef, 0xc0b7, 0x1a78,
    0x3768, 0x37bd, 0xb9e5, 0x39d2, 0x3d26, 0xc159, 0xbd1c, 0xb87f,
    0xb9fb, 0xb949, 0xb5ba, 0x334f, 0x3878, 0xb834, 0xb7f5, 0xbd1d,
    0x3e99, 0x3b90, 0xb732, 0xb8b5, 0x3b3d, 0x3d1e, 0x3450, 0xa1e8,
    0xb028, 0xb1b4, 0x3904, 0xbab0, 0xb856, 0xadd7, 0xbab6, 0xac69,
    0xa710, 0x3406, 0xad64, 0xbc1b, 0xb880, 0xb928, 0xaf48, 0x24c5,
    0x3e2d, 0x3db9, 0xbda0, 0xb775, 0x3658, 0x315c, 0x38ed, 0xb5b0,
    0xbb28, 0x378b, 0x3495, 0xbb38, 0xb533, 0xb67b, 0xb899, 0xb719,
    0xa9f5, 0x3436, 0xb883, 0x38aa, 0xb0b4, 0x3b0f, 0xbc39, 0x3f63,
    0xb584, 0xbd96, 0xbb4d, 0x3a70, 0x3d07, 0xb424, 0xbd63, 0xbead,
    0x3216, 0xbd13, 0x3916, 0xc0ad, 0xb82a, 0xba79, 0xbaf2, 0xb539,
    0xbe08, 0xb47b, 0x4083, 0x4006, 0x3b95, 0x3a21, 0x3e33, 0xb80d,
    0xb985, 0x3864, 0x3bde, 0x38a3, 0xb5cb, 0x35fb, 0xb243, 0x2b63,
    0x362b, 0x2f22, 0x284b, 0x384b, 0xba73, 0xb80e, 0x327d, 0xb8f9,
    0x39c3, 0x38b3, 0xb02c, 0x3e38, 0x3c80, 0x3dfb, 0x3bf3, 0xbcc5,
    0x38bd, 0x392c, 0xb878, 0xbed4, 0x2c76, 0xb6f0, 0x3805, 0xb042,
    0x36e8, 0xb9a3, 0x373a, 0xb680, 0x2774, 0x4061, 0x269a, 0xbf51,
    0xb348, 0x5999, 0xba41, 0x3d12, 0x3286, 0x3855, 0xb54d, 0xb173,
    0x34be, 0x38fb, 0xb22e, 0x3be4, 0xb0d3, 0x3dea, 0x31ae, 0xade6,
    0x3736, 0x3def, 0x4002, 0xb73c, 0xb0bf, 0xa8e4, 0xbc01, 0xb840,
    0xbb34, 0x3c93, 0xada2, 0x94ea, 0xb851, 0xbd8b, 0x3747, 0xb8f2,
    0x3cc1, 0xbd4d, 0x35e3, 0x3888, 0xbc35, 0xb832, 0x3c85, 0xbdd3,
    0xb25f, 0x37f2, 0x3fbc, 0x36bd, 0x3f46, 0x3874, 0xacdd, 0xad8c,
    0x32af, 0x39a3, 0xbce1, 0xb737, 0x330a, 0xb22c, 0x3c6c, 0x3006,
    0xb321, 0xac2b, 0xb9ad, 0x39c2, 0x3ded, 0xb223, 0xb5eb, 0xbb17,
    0xb8bb, 0xb701, 0x3bab, 0x3d07, 0xb428, 0xbd64, 0xbb67, 0xb617,
    0x38f5, 0x3d2d, 0xba32, 0x9aef, 0x3765, 0x25bb, 0x3bcc, 0xbb41,
    0xb55b, 0xb482, 0xb8d9, 0x3253, 0xae71, 0xb2bf, 0x3068, 0x37c5,
    0x3916, 0xac2a, 0x380f, 0x3962, 0x356a, 0x28ec, 0xbdcd, 0xbec5,
    0xb2eb, 0x3013, 0xb114, 0x3701, 0xc057, 0x3da3, 0xae10, 0xba97,
    0xadf3, 0xb085, 0xb51d, 0x34b4, 0xbb0f, 0xb743, 0xbd12, 0x2bd5,
    0xb856, 0xb8fe, 0x3ce7, 0x38b9, 0xb6f4, 0x3c36, 0xaa91, 0xb56e,
    0xbb77, 0xba46, 0x380c, 0x3a86, 0xb9d6, 0xb658, 0xb066, 0x3b44
    };

static const uint16_t ref_cfft_noisy_512[1024] = {
    0xae39, 0x0, 0xb066, 0xbb44, 0xb9d6, 0x3658, 0x380c, 0xba86,
    0xbb77, 0x3a46, 0xaa91, 0x356e, 0xb6f4, 0xbc36, 0x3ce7, 0xb8b9,
    0xb856, 0x38fe, 0xbd12, 0xabd5, 0xbb0f, 0x3743, 0xb51d, 0xb4b4,
    0xadf3, 0x3085, 0xae10, 0x3a97, 0xc057, 0xbda3, 0xb114, 0xb701,
    0xb2eb, 0xb013, 0xbdcd, 0x3ec5, 0x356a, 0xa8ec, 0x380f, 0xb962,
    0x3916, 0x2c2a, 0x3068, 0xb7c5, 0xae71, 0x32bf, 0xb8d9, 0xb253,
    0xb55b, 0x3482, 0x3bcc, 0x3b41, 0x3765, 0xa5bb, 0xba32, 0x1aef,
    0x38f5, 0xbd2d, 0xbb67, 0x3617, 0xb428, 0x3d64, 0x3bab, 0xbd07,
    0xb8bb, 0x3701, 0xb5eb, 0x3b17, 0x3ded, 0x3223, 0xb9ad, 0xb9c2,
    0xb321, 0x2c2b, 0x3c6c, 0xb006, 0x330a, 0x322c, 0xbce1, 0x3737,
    0x32af, 0xb9a3, 0xacdd, 0x2d8c, 0x3f46, 0xb874, 0x3fbc, 0xb6bd,
    0xb25f, 0xb7f2, 0x3c85, 0x3dd3, 0xbc35, 0x3832, 0x35e3, 0xb888,
    0x3cc1, 0x3d4d, 0x3747, 0x38f2, 0xb851, 0x3d8b, 0xada2, 0x14ea,
    0xbb34, 0xbc93, 0xbc01, 0x3840, 0xb0bf, 0x28e4, 0x4002, 0x373c,
    0x3736, 0xbdef, 0x31ae, 0x2de6, 0xb0d3, 0xbdea, 0xb22e, 0xbbe4,
    0x34be, 0xb8fb, 0xb54d, 0x3173, 0x3286, 0xb855, 0xba41, 0xbd12,
    0xb348, 0xd999, 0x269a, 0x3f51, 0x2774, 0xc061, 0x373a, 0x3680,
    0x36e8, 0x39a3, 0x3805, 0x3042, 0x2c76, 0x36f0, 0xb878, 0x3ed4,
    0x38bd, 0xb92c, 0x3bf3, 0x3cc5, 0x3c80, 0xbdfb, 0xb02c, 0xbe38,
    0x39c3, 0xb8b3, 0x327d, 0x38f9, 0xba73, 0x380e, 0x284b, 0xb84b,
    0x362b, 0xaf22, 0xb243, 0xab63, 0xb5cb, 0xb5fb, 0x3bde, 0xb8a3,
    0xb985, 0xb864, 0x3e33, 0x380d, 0x3b95, 0xba21, 0x4083, 0xc006,
    0xbe08, 0x347b, 0xbaf2, 0x3539, 0xb82a, 0x3a79, 0x3916, 0x40ad,
    0x3216, 0x3d13, 0xbd63, 0x3ead, 0x3d07, 0x3424, 0xbb4d, 0xba70,
    0xb584, 0x3d96, 0xbc39, 0xbf63, 0xb0b4, 0xbb0f, 0xb883, 0xb8aa,
    0xa9f5, 0xb436, 0xb899, 0x3719, 0xb533, 0x367b, 0x3495, 0x3b38,
    0xbb28, 0xb78b, 0x38ed, 0x35b0, 0x3658, 0xb15c, 0xbda0, 0x3775,
    0x3e2d, 0xbdb9, 0xaf48, 0xa4c5, 0xb880, 0x3928, 0xad64, 0x3c1b,
    0xa710, 0xb406, 0xbab6, 0x2c69, 0xb856, 0x2dd7, 0x3904, 0x3ab0,
    0xb028, 0x31b4, 0x3450, 0x21e8, 0x3b3d, 0xbd1e, 0xb732, 0x38b5,
    0x3e99, 0xbb90, 0xb7f5, 0x3d1d, 0x3878, 0x3834, 0xb5ba, 0xb34f,
    0xb9fb, 0x3949, 0xbd1c, 0x387f, 0x3d26, 0x4159, 0xb9e5, 0xb9d2,
    0x3768, 0xb7bd, 0xc0b7, 0x9a78, 0xbb95, 0xb4ef, 0x34f0, 0xb1db,
    0xb2b1, 0x353d, 0x2ce3, 0xabae, 0xba8c, 0xb8e9, 0x3a07, 0xb820,
    0x3e95, 0x33dd, 0xb190, 0x3d98, 0xbde1, 0x38fe, 0xb518, 0x2f5e,
    0xae61, 0xba24, 0xb5b2, 0x3745, 0x3040, 0x39a3, 0x38c6, 0xb0ef,
    0x3b28, 0x2c2b, 0xbc46, 0x38de, 0x3210, 0xad3b, 0x3993, 0x3c52,
    0xb72a, 0x3ac1, 0xbbcc, 0x3930, 0xb80f, 0xbf70, 0xb39e, 0xb56f,
    0x3445, 0xb1fc, 0xb800, 0xbed8, 0x3c64, 0xb6ab, 0x376c, 0x291c,
    0xbd69, 0x3dba, 0xbc54, 0xb8f9, 0xbafd, 0x3a9c, 0x37f0, 0x3ccf,
    0x36ca, 0xbd8c, 0x3c80, 0x3e2a, 0x39a0, 0x3d0b, 0x3203, 0xade6,
    0xba3b, 0xac45, 0x3e79, 0x3387, 0xb95c, 0xbddb, 0xb8a0, 0x2c3c,
    0xb8fa, 0xb45a, 0x9e32, 0xbe61, 0x2c83, 0x3043, 0xb8ac, 0xaed0,
    0x3a70, 0xad3f, 0x392a, 0xb24b, 0xbdd4, 0x3535, 0xb4ae, 0x32d6,
    0x37f4, 0xb922, 0xb833, 0x3d43, 0xbcdf, 0xba88, 0x3b47, 0xbc96,
    0x3962, 0xb37f, 0xb5ce, 0x33a9, 0xbd0f, 0x36bd, 0xb8fa, 0x3855,
    0xadab, 0x3f05, 0xb894, 0x3f34, 0xb91e, 0x392b, 0x402f, 0x3c17,
    0x3b0b, 0xbcfb, 0x3c84, 0x3923, 0x39e1, 0x3173, 0x39fa, 0x2d94,
    0xb5e6, 0xba18, 0xbc19, 0xb048, 0x310a, 0xbcb3, 0xb489, 0xba4e,
    0x3aaa, 0xb17b, 0x38ea, 0xb0ff, 0x2b67, 0xbaf2, 0xb947, 0xb25d,
    0xc043, 0x280e, 0xbaa2, 0x3816, 0x28bf, 0x4092, 0xbcda, 0x3308,
    0x390b, 0xbdcd, 0xbbe8, 0xb022, 0xb8cb, 0x352e, 0xbb32, 0xacf6,
    0x370f, 0xb3ba, 0x2cb0, 0xb2e9, 0xb55d, 0xbdbe, 0xbcd4, 0x390d,
    0xb512, 0x3dc5, 0xb80c, 0x39e9, 0x3976, 0x3666, 0xb66f, 0x3c4f,
    0xb8ff, 0xb768, 0x2739, 0xb489, 0x36f4, 0x3c10, 0xa8f2, 0x33fe,
    0xb8f1, 0xbf29, 0xb999, 0x32bf, 0xa4dc, 0x2f11, 0x3d9f, 0x2e82,
    0xa4e4, 0x3d20, 0xaf76, 0xb80d, 0x2879, 0xa4ef, 0x3dea, 0xb7c7,
    0xb555, 0x35f2, 0x383d, 0x3471, 0x35ff, 0xb7ad, 0xbfa4, 0xa6de,
    0x2c8a, 0xbd19, 0xbd05, 0x3883, 0x3681, 0xa251, 0xbd4a, 0xbd7e,
    0x37e8, 0xb7f5, 0x3b03, 0x3ac9, 0xb38b, 0xb533, 0xba11, 0x30d3,
    0x35d1, 0x3174, 0x3c70, 0xb512, 0xbe7f, 0x3c02, 0x37a6, 0x3ece,
    0x2ce5, 0xb90a, 0xb486, 0x36ba, 0xb52b, 0x3c7a, 0xad4f, 0x346b,
    0x38ff, 0xbe97, 0x3c3d, 0x3a52, 0xb787, 0x3e05, 0x311b, 0x3337,
    0x36a9, 0x3c29, 0xb967, 0xbdb2, 0x33ff, 0xb4ea, 0x3758, 0x3813,
    0x3833, 0x0, 0x3758, 0xb813, 0x33ff, 0x34ea, 0xb967, 0x3db2,
    0x36a9, 0xbc29, 0x311b, 0xb337, 0xb787, 0xbe05, 0x3c3d, 0xba52,
    0x38ff, 0x3e97, 0xad4f, 0xb46b, 0xb52b, 0xbc7a, 0xb486, 0xb6ba,
    0x2ce5, 0x390a, 0x37a6, 0xbece, 0xbe7f, 0xbc02, 0x3c70, 0x3512,
    0x35d1, 0xb174, 0xba11, 0xb0d3, 0xb38b, 0x3533, 0x3b03, 0xbac9,
    0x37e8, 0x37f5, 0xbd4a, 0x3d7e, 0x3681, 0x2251, 0xbd05, 0xb883,
    0x2c8a, 0x3d19, 0xbfa4, 0x26de, 0x35ff, 0x37ad, 0x383d, 0xb471,
    0xb555, 0xb5f2, 0x3dea, 0x37c7, 0x2879, 0x24ef, 0xaf76, 0x380d,
    0xa4e4, 0xbd20, 0x3d9f, 0xae82, 0xa4dc, 0xaf11, 0xb999, 0xb2bf,
    0xb8f1, 0x3f29, 0xa8f2, 0xb3fe, 0x36f4, 0xbc10, 0x2739, 0x3489,
    0xb8ff, 0x3768, 0xb66f, 0xbc4f, 0x3976, 0xb666, 0xb80c, 0xb9e9,
    0xb512, 0xbdc5, 0xbcd4, 0xb90d, 0xb55d, 0x3dbe, 0x2cb0, 0x32e9,
    0x370f, 0x33ba, 0xbb32, 0x2cf6, 0xb8cb, 0xb52e, 0xbbe8, 0x3022,
    0x390b, 0x3dcd, 0xbcda, 0xb308, 0x28bf, 0xc092, 0xbaa2, 0xb816,
    0xc043, 0xa80e, 0xb947, 0x325d, 0x2b67, 0x3af2, 0x38ea, 0x30ff,
    0x3aaa, 0x317b, 0xb489, 0x3a4e, 0x310a, 0x3cb3, 0xbc19, 0x3048,
    0xb5e6, 0x3a18, 0x39fa, 0xad94, 0x39e1, 0xb173, 0x3c84, 0xb923,
    0x3b0b, 0x3cfb, 0x402f, 0xbc17, 0xb91e, 0xb92b, 0xb894, 0xbf34,
    0xadab, 0xbf05, 0xb8fa, 0xb855, 0xbd0f, 0xb6bd, 0xb5ce, 0xb3a9,
    0x3962, 0x337f, 0x3b47, 0x3c96, 0xbcdf, 0x3a88, 0xb833, 0xbd43,
    0x37f4, 0x3922, 0xb4ae, 0xb2d6, 0xbdd4, 0xb535, 0x392a, 0x324b,
    0x3a70, 0x2d3f, 0xb8ac, 0x2ed0, 0x2c83, 0xb043, 0x9e32, 0x3e61,
    0xb8fa, 0x345a, 0xb8a0, 0xac3c, 0xb95c, 0x3ddb, 0x3e79, 0xb387,
    0xba3b, 0x2c45, 0x3203, 0x2de6, 0x39a0, 0xbd0b, 0x3c80, 0xbe2a,
    0x36ca, 0x3d8c, 0x37f0, 0xbccf, 0xbafd, 0xba9c, 0xbc54, 0x38f9,
    0xbd69, 0xbdba, 0x376c, 0xa91c, 0x3c64, 0x36ab, 0xb800, 0x3ed8,
    0x3445, 0x31fc, 0xb39e, 0x356f, 0xb80f, 0x3f70, 0xbbcc, 0xb930,
    0xb72a, 0xbac1, 0x3993, 0xbc52, 0x3210, 0x2d3b, 0xbc46, 0xb8de,
    0x3b28, 0xac2b, 0x38c6, 0x30ef, 0x3040, 0xb9a3, 0xb5b2, 0xb745,
    0xae61, 0x3a24, 0xb518, 0xaf5e, 0xbde1, 0xb8fe, 0xb190, 0xbd98,
    0x3e95, 0xb3dd, 0x3a07, 0x3820, 0xba8c, 0x38e9, 0x2ce3, 0x2bae,
    0xb2b1, 0xb53d, 0x34f0, 0x31db, 0xbb95, 0x34ef, 0xc0b7, 0x1a78,
    0x3768, 0x37bd, 0xb9e5, 0x39d2, 0x3d26, 0xc159, 0xbd1c, 0xb87f,
    0xb9fb, 0xb949, 0xb5ba, 0x334f, 0x3878, 0xb834, 0xb7f5, 0xbd1d,
    0x3e99, 0x3b90, 0xb732, 0xb8b5, 0x3b3d, 0x3d1e, 0x3450, 0xa1e8,
    0xb028, 0xb1b4, 0x3904, 0xbab0, 0xb856, 0xadd7, 0xbab6, 0xac69,
    0xa710, 0x3406, 0xad64, 0xbc1b, 0xb880, 0xb928, 0xaf48, 0x24c5,
    0x3e2d, 0x3db9, 0xbda0, 0xb775, 0x3658, 0x315c, 0x38ed, 0xb5b0,
    0xbb28, 0x378b, 0x3495, 0xbb38, 0xb533, 0xb67b, 0xb899, 0xb719,
    0xa9f5, 0x3436, 0xb883, 0x38aa, 0xb0b4, 0x3b0f, 0xbc39, 0x3f63,
    0xb584, 0xbd96, 0xbb4d, 0x3a70, 0x3d07, 0xb424, 0xbd63, 0xbead,
    0x3216, 0xbd13, 0x3916, 0xc0ad, 0xb82a, 0xba79, 0xbaf2, 0xb539,
    0xbe08, 0xb47b, 0x4083, 0x4006, 0x3b95, 0x3a21, 0x3e33, 0xb80d,
    0xb985, 0x3864, 0x3bde, 0x38a3, 0xb5cb, 0x35fb, 0xb243, 0x2b63,
    0x362b, 0x2f22, 0x284b, 0x384b, 0xba73, 0xb80e, 0x327d, 0xb8f9,
    0x39c3, 0x38b3, 0xb02c, 0x3e38, 0x3c80, 0x3dfb, 0x3bf3, 0xbcc5,
    0x38bd, 0x392c, 0xb878, 0xbed4, 0x2c76, 0xb6f0, 0x3805, 0xb042,
    0x36e8, 0xb9a3, 0x373a, 0xb680, 0x2774, 0x4061, 0x269a, 0xbf51,
    0xb348, 0x5999, 0xba41, 0x3d12, 0x3286, 0x3855, 0xb54d, 0xb173,
    0x34be, 0x38fb, 0xb22e, 0x3be4, 0xb0d3, 0x3dea, 0x31ae, 0xade6,
    0x3736, 0x3def, 0x4002, 0xb73c, 0xb0bf, 0xa8e4, 0xbc01, 0xb840,
    0xbb34, 0x3c93, 0xada2, 0x94ea, 0xb851, 0xbd8b, 0x3747, 0xb8f2,
    0x3cc1, 0xbd4d, 0x35e3, 0x3888, 0xbc35, 0xb832, 0x3c85, 0xbdd3,
    0xb25f, 0x37f2, 0x3fbc, 0x36bd, 0x3f46, 0x3874, 0xacdd, 0xad8c,
    0x32af, 0x39a3, 0xbce1, 0xb737, 0x330a, 0xb22c, 0x3c6c, 0x3006,
    0xb321, 0xac2b, 0xb9ad, 0x39c2, 0x3ded, 0xb223, 0xb5eb, 0xbb17,
    0xb8bb, 0xb701, 0x3bab, 0x3d07, 0xb428, 0xbd64, 0xbb67, 0xb617,
    0x38f5, 0x3d2d, 0xba32, 0x9aef, 0x3765, 0x25bb, 0x3bcc, 0xbb41,
    0xb55b, 0xb482, 0xb8d9, 0x3253, 0xae71, 0xb2bf, 0x3068, 0x37c5,
    0x3916, 0xac2a, 0x380f, 0x3962, 0x356a, 0x28ec, 0xbdcd, 0xbec5,
    0xb2eb, 0x3013, 0xb114, 0x3701, 0xc057, 0x3da3, 0xae10, 0xba97,
    0xadf3, 0xb085, 0xb51d, 0x34b4, 0xbb0f, 0xb743, 0xbd12, 0x2bd5,
    0xb856, 0xb8fe, 0x3ce7, 0x38b9, 0xb6f4, 0x3c36, 0xaa91, 0xb56e,
    0xbb77, 0xba46, 0x380c, 0x3a86, 0xb9d6, 0xb658, 0xb066, 0x3b44
    };

static const uint16_t in_cfft_noisy_1024[2048] = {
    0xa6b5, 0x0, 0x3858, 0x0, 0x3a07, 0x0, 0x3807, 0x0,
    0x282e, 0x0, 0xb84e, 0x0, 0xb915, 0x0, 0xb77f, 0x0,
    0x22f4, 0x0, 0x37d5, 0x0, 0x3971, 0x0, 0x373e, 0x0,
    0x2876, 0x0, 0xb804, 0x0, 0xb9b9, 0x0, 0xb6cd, 0x0,
    0xa5b8, 0x0, 0x383b, 0x0, 0x394e, 0x0, 0x378f, 0x0,
    0xa911, 0x0, 0xb800, 0x0, 0xb94c, 0x0, 0xb814, 0x0,
    0xaa3b, 0x0, 0x371e, 0x0, 0x3a87, 0x0, 0x3810, 0x0,
    0xa7e2, 0x0, 0xb81a, 0x0, 0xba2a, 0x0, 0xb803, 0x0,
    0x9a92, 0x0, 0x3751, 0x0, 0x39f5, 0x0, 0x379c, 0x0,
    0x2916, 0x0, 0xb861, 0x0, 0xb8e6, 0x0, 0xb756, 0x0,
    0xac95, 0x0, 0x3809, 0x0, 0x3a56, 0x0, 0x37a7, 0x0,
    0x2c52, 0x0, 0xb6ee, 0x0, 0xb981, 0x0, 0xb84f, 0x0,
    0xa95f, 0x0, 0x37d8, 0x0, 0x39de, 0x0, 0x3816, 0x0,
    0x2905, 0x0, 0xb74c, 0x0, 0xb977, 0x0, 0xb830, 0x0,
    0x9bab, 0x0, 0x385b, 0x0, 0x39dd, 0x0, 0x3774, 0x0,
    0xa6af, 0x0, 0xb871, 0x0, 0xb92d, 0x0, 0xb7d6, 0x0,
    0xa873, 0x0, 0x3761, 0x0, 0x39ae, 0x0, 0x38c6, 0x0,
    0xa91e, 0x0, 0xb78c, 0x0, 0xb985, 0x0, 0xb93d, 0x0,
    0xab6e, 0x0, 0x37fe, 0x0, 0x39f9, 0x0, 0x38d9, 0x0,
    0xa9f0, 0x0, 0xb8b4, 0x0, 0xb9a6, 0x0, 0xb75a, 0x0,
    0x236f, 0x0, 0x36d5, 0x0, 0x3982, 0x0, 0x3729, 0x0,
    0xad24, 0x0, 0xb7ce, 0x0, 0xb96e, 0x0, 0xb843, 0x0,
    0x1dcc, 0x0, 0x373c, 0x0, 0x3950, 0x0, 0x3861, 0x0,
    0x2b83, 0x0, 0xb755, 0x0, 0xb990, 0x0, 0xb637, 0x0,
    0x284a, 0x0, 0x3830, 0x0, 0x39b7, 0x0, 0x3852, 0x0,
    0x2cb5, 0x0, 0xb6d7, 0x0, 0xb969, 0x0, 0xb86f, 0x0,
    0x26d6, 0x0, 0x3833, 0x0, 0x3908, 0x0, 0x3788, 0x0,
    0x202a, 0x0, 0xb791, 0x0, 0xba01, 0x0, 0xb836, 0x0,
    0x2840, 0x0, 0x36ed, 0x0, 0x3a23, 0x0, 0x3747, 0x0,
    0xa910, 0x0, 0xb892, 0x0, 0xb959, 0x0, 0xb843, 0x0,
    0x2428, 0x0, 0x374c, 0x0, 0x3832, 0x0, 0x374e, 0x0,
    0x2bd7, 0x0, 0xb83b, 0x0, 0xba0e, 0x0, 0xb752, 0x0,
    0xa07c, 0x0, 0x37ed, 0x0, 0x3a82, 0x0, 0x3881, 0x0,
    0xab58, 0x0, 0xb79b, 0x0, 0xba22, 0x0, 0xb66e, 0x0,
    0x2477, 0x0, 0x37c9, 0x0, 0x397d, 0x0, 0x3765, 0x0,
    0x2b8a, 0x0, 0xb83f, 0x0, 0xb934, 0x0, 0xb7e5, 0x0,
    0xa050, 0x0, 0x3843, 0x0, 0x391a, 0x0, 0x3814, 0x0,
    0xae0b, 0x0, 0xb751, 0x0, 0xb929, 0x0, 0xb71f, 0x0,
    0x21bb, 0x0, 0x3755, 0x0, 0x3983, 0x0, 0x38bb, 0x0,
    0x2c33, 0x0, 0xb819, 0x0, 0xb9b2, 0x0, 0xb86f, 0x0,
    0x2cfb, 0x0, 0x36a8, 0x0, 0x3a0c, 0x0, 0x38b4, 0x0,
    0xae07, 0x0, 0xb81e, 0x0, 0xb9e1, 0x0, 0xb6be, 0x0,
    0x2c44, 0x0, 0x3803, 0x0, 0x3a5a, 0x0, 0x3855, 0x0,
    0xad43, 0x0, 0xb808, 0x0, 0xb96e, 0x0, 0xb7fe, 0x0,
    0x2e95, 0x0, 0x391e, 0x0, 0x3992, 0x0, 0x3715, 0x0,
    0xaa42, 0x0, 0xb883, 0x0, 0xb9a9, 0x0, 0xb83b, 0x0,
    0x3004, 0x0, 0x37e8, 0x0, 0x39ab, 0x0, 0x37f9, 0x0,
    0x1064, 0x0, 0xb791, 0x0, 0xb9a3, 0x0, 0xb803, 0x0,
    0xa43b, 0x0, 0x384a, 0x0, 0x3961, 0x0, 0x3828, 0x0,
    0x2ddb, 0x0, 0xb824, 0x0, 0xb9e6, 0x0, 0xb74a, 0x0,
    0xa07a, 0x0, 0x388a, 0x0, 0x3993, 0x0, 0x382e, 0x0,
    0xad76, 0x0, 0xb6bd, 0x0, 0xb9e1, 0x0, 0xb683, 0x0,
    0x2b0a, 0x0, 0x3880, 0x0, 0x39b0, 0x0, 0x3878, 0x0,
    0x9aeb, 0x0, 0xb84f, 0x0, 0xb8f7, 0x0, 0xb83d, 0x0,
    0xb05d, 0x0, 0x3887, 0x0, 0x3989, 0x0, 0x3738, 0x0,
    0xabc4, 0x0, 0xb818, 0x0, 0xb93d, 0x0, 0xb916, 0x0,
    0x1ef5, 0x0, 0x3780, 0x0, 0x3921, 0x0, 0x38bd, 0x0,
    0xa75f, 0x0, 0xb755, 0x0, 0xb9cd, 0x0, 0xb6d9, 0x0,
    0xac95, 0x0, 0x37c3, 0x0, 0x39f8, 0x0, 0x37d6, 0x0,
    0x990d, 0x0, 0xb80c, 0x0, 0xb948, 0x0, 0xb774, 0x0,
    0xaadd, 0x0, 0x3776, 0x0, 0x3914, 0x0, 0x380a, 0x0,
    0x2a32, 0x0, 0xb885, 0x0, 0xba09, 0x0, 0xb71b, 0x0,
    0x2b0e, 0x0, 0x3733, 0x0, 0x39c8, 0x0, 0x36c2, 0x0,
    0xaa10, 0x0, 0xb7ce, 0x0, 0xb9d3, 0x0, 0xb76e, 0x0,
    0x9e33, 0x0, 0x37d1, 0x0, 0x39ae, 0x0, 0x3721, 0x0,
    0xa01d, 0x0, 0xb78b, 0x0, 0xb987, 0x0, 0xb7af, 0x0,
    0x20d7, 0x0, 0x389d, 0x0, 0x3973, 0x0, 0x37b7, 0x0,
    0xa751, 0x0, 0xb7a3, 0x0, 0xb906, 0x0, 0xb6c2, 0x0,
    0x296b, 0x0, 0x3923, 0x0, 0x389a, 0x0, 0x3760, 0x0,
    0x26fd, 0x0, 0xb827, 0x0, 0xb96e, 0x0, 0xb829, 0x0,
    0xa81d, 0x0, 0x3774, 0x0, 0x3a0c, 0x0, 0x382c, 0x0,
    0x2886, 0x0, 0xb864, 0x0, 0xb8a3, 0x0, 0xb71a, 0x0,
    0x23a5, 0x0, 0x3843, 0x0, 0x397a, 0x0, 0x37f4, 0x0,
    0xaca4, 0x0, 0xb744, 0x0, 0xb9b8, 0x0, 0xb819, 0x0,
    0x2947, 0x0, 0x389a, 0x0, 0x3a18, 0x0, 0x3745, 0x0,
    0xa7a0, 0x0, 0xb774, 0x0, 0xba01, 0x0, 0xb754, 0x0,
    0x2490, 0x0, 0x385c, 0x0, 0x38c5, 0x0, 0x3776, 0x0,
    0x294b, 0x0, 0xb7a8, 0x0, 0xba24, 0x0, 0xb838, 0x0,
    0x2205, 0x0, 0x3806, 0x0, 0x3955, 0x0, 0x38cb, 0x0,
    0x2860, 0x0, 0xb810, 0x0, 0xb9ae, 0x0, 0xb805, 0x0,
    0x2aea, 0x0, 0x3855, 0x0, 0x3a33, 0x0, 0x37e1, 0x0,
    0x2e84, 0x0, 0xb855, 0x0, 0xb975, 0x0, 0xb898, 0x0,
    0xab29, 0x0, 0x3655, 0x0, 0x39b8, 0x0, 0x3772, 0x0,
    0xa567, 0x0, 0xb6d9, 0x0, 0xb8e8, 0x0, 0xb657, 0x0,
    0xad63, 0x0, 0x37b0, 0x0, 0x3977, 0x0, 0x379d, 0x0,
    0xab00, 0x0, 0xb874, 0x0, 0xb93e, 0x0, 0xb830, 0x0,
    0x29ef, 0x0, 0x386f, 0x0, 0x39c0, 0x0, 0x377d, 0x0,
    0x2b2d, 0x0, 0xb7fe, 0x0, 0xb96a, 0x0, 0xb86a, 0x0,
    0xa946, 0x0, 0x3816, 0x0, 0x38aa, 0x0, 0x3843, 0x0,
    0x9d41, 0x0, 0xb743, 0x0, 0xb8f6, 0x0, 0xb745, 0x0,
    0x2b41, 0x0, 0x377a, 0x0, 0x394c, 0x0, 0x36bf, 0x0,
    0x2073, 0x0, 0xb857, 0x0, 0xb8f3, 0x0, 0xb6ac, 0x0,
    0xa535, 0x0, 0x3891, 0x0, 0x3951, 0x0, 0x37ae, 0x0,
    0x98ef, 0x0, 0xb7f1, 0x0, 0xb971, 0x0, 0xb799, 0x0,
    0xace9, 0x0, 0x3846, 0x0, 0x39a8, 0x0, 0x389c, 0x0,
    0x1ef2, 0x0, 0xb868, 0x0, 0xb98e, 0x0, 0xb825, 0x0,
    0xad20, 0x0, 0x388e, 0x0, 0x38de, 0x0, 0x3885, 0x0,
    0x2c93, 0x0, 0xb784, 0x0, 0xb9af, 0x0, 0xb787, 0x0,
    0xa924, 0x0, 0x3712, 0x0, 0x39bf, 0x0, 0x3886, 0x0,
    0xa73e, 0x0, 0xb85d, 0x0, 0xb9aa, 0x0, 0xb736, 0x0,
    0xad29, 0x0, 0x383f, 0x0, 0x399e, 0x0, 0x375a, 0x0,
    0xa9ba, 0x0, 0xb8f4, 0x0, 0xb9c3, 0x0, 0xb721, 0x0,
    0x2128, 0x0, 0x365b, 0x0, 0x39e8, 0x0, 0x3810, 0x0,
    0x2de7, 0x0, 0xb87f, 0x0, 0xb9bb, 0x0, 0xb7a2, 0x0,
    0x29a4, 0x0, 0x3789, 0x0, 0x3969, 0x0, 0x3844, 0x0,
    0xa8c3, 0x0, 0xb744, 0x0, 0xb9a7, 0x0, 0xb842, 0x0,
    0x94e6, 0x0, 0x387d, 0x0, 0x3918, 0x0, 0x36c8, 0x0,
    0xa7c2, 0x0, 0xb702, 0x0, 0xba46, 0x0, 0xb793, 0x0,
    0xa9be, 0x0, 0x388f, 0x0, 0x39d0, 0x0, 0x382f, 0x0,
    0xabbe, 0x0, 0xb733, 0x0, 0xb9e9, 0x0, 0xb810, 0x0,
    0x21c3, 0x0, 0x38e0, 0x0, 0x397c, 0x0, 0x372c, 0x0,
    0x2157, 0x0, 0xb781, 0x0, 0xb8e2, 0x0, 0xb67f, 0x0,
    0xa28a, 0x0, 0x3832, 0x0, 0x39dc, 0x0, 0x36da, 0x0,
    0x274a, 0x0, 0xb8af, 0x0, 0xb98e, 0x0, 0xb7eb, 0x0,
    0x9cfa, 0x0, 0x37ba, 0x0, 0x391d, 0x0, 0x37a1, 0x0,
    0xa556, 0x0, 0xb85b, 0x0, 0xb9b9, 0x0, 0xb7c8, 0x0,
    0x29e3, 0x0, 0x38a9, 0x0, 0x39f9, 0x0, 0x3802, 0x0,
    0xa93d, 0x0, 0xb7e2, 0x0, 0xb9dd, 0x0, 0xb8ed, 0x0,
    0xaab6, 0x0, 0x3833, 0x0, 0x38cd, 0x0, 0x3736, 0x0,
    0xa02f, 0x0, 0xb7b9, 0x0, 0xb9ff, 0x0, 0xb84c, 0x0,
    0xb01d, 0x0, 0x37b6, 0x0, 0x39ca, 0x0, 0x3797, 0x0,
    0x2351, 0x0, 0xb75e, 0x0, 0xb999, 0x0, 0xb7b9, 0x0,
    0x2a59, 0x0, 0x383e, 0x0, 0x3a06, 0x0, 0x3853, 0x0,
    0xad17, 0x0, 0xb77c, 0x0, 0xb8df, 0x0, 0xb721, 0x0,
    0x2551, 0x0, 0x372a, 0x0, 0x395e, 0x0, 0x3870, 0x0,
    0x2b05, 0x0, 0xb831, 0x0, 0xba2f, 0x0, 0xb76e, 0x0,
    0xacda, 0x0, 0x3716, 0x0, 0x3978, 0x0, 0x381b, 0x0,
    0xaa30, 0x0, 0xb786, 0x0, 0xba0f, 0x0, 0xb776, 0x0,
    0x2b01, 0x0, 0x374d, 0x0, 0x3923, 0x0, 0x383d, 0x0,
    0xa3ec, 0x0, 0xb76d, 0x0, 0xb9b0, 0x0, 0xb7cf, 0x0,
    0x17bb, 0x0, 0x3710, 0x0, 0x3995, 0x0, 0x37ee, 0x0,
    0x2c17, 0x0, 0xb6b6, 0x0, 0xb954, 0x0, 0xb6ef, 0x0,
    0x20a6, 0x0, 0x38d5, 0x0, 0x39cc, 0x0, 0x3747, 0x0,
    0xa746, 0x0, 0xb6f5, 0x0, 0xb9b2, 0x0, 0xb7fc, 0x0,
    0x2d57, 0x0, 0x37ec, 0x0, 0x39d7, 0x0, 0x3790, 0x0,
    0x27a4, 0x0, 0xb899, 0x0, 0xb9e0, 0x0, 0xb805, 0x0,
    0xaa87, 0x0, 0x3820, 0x0, 0x392f, 0x0, 0x3841, 0x0,
    0xa8e6, 0x0, 0xb802, 0x0, 0xb912, 0x0, 0xb809, 0x0,
    0xa414, 0x0, 0x36f8, 0x0, 0x398d, 0x0, 0x3815, 0x0,
    0x293c, 0x0, 0xb87b, 0x0, 0xb968, 0x0, 0xb7ce, 0x0,
    0x1df3, 0x0, 0x37f0, 0x0, 0x3972, 0x0, 0x380c, 0x0,
    0xaf25, 0x0, 0xb698, 0x0, 0xb902, 0x0, 0xb80a, 0x0,
    0x2838, 0x0, 0x36d6, 0x0, 0x398e, 0x0, 0x389d, 0x0,
    0xa94e, 0x0, 0xb6ca, 0x0, 0xb971, 0x0, 0xb850, 0x0,
    0x2978, 0x0, 0x3775, 0x0, 0x39e7, 0x0, 0x388e, 0x0,
    0xa7b2, 0x0, 0xb7c7, 0x0, 0xb9b0, 0x0, 0xb869, 0x0,
    0xa82d, 0x0, 0x36d1, 0x0, 0x395e, 0x0, 0x3742, 0x0,
    0x64a, 0x0, 0xb88d, 0x0, 0xb9f3, 0x0, 0xb872, 0x0,
    0x2739, 0x0, 0x373a, 0x0, 0x3868, 0x0, 0x37d0, 0x0,
    0x1eda, 0x0, 0xb7dc, 0x0, 0xb91f, 0x0, 0xb814, 0x0,
    0x2bba, 0x0, 0x3763, 0x0, 0x3a02, 0x0, 0x382e, 0x0,
    0xa983, 0x0, 0xb8b1, 0x0, 0xb95e, 0x0, 0xb875, 0x0,
    0x2f8d, 0x0, 0x368c, 0x0, 0x3a27, 0x0, 0x3822, 0x0,
    0xa980, 0x0, 0xb7f7, 0x0, 0xb8de, 0x0, 0xb72f, 0x0,
    0xa88f, 0x0, 0x37dc, 0x0, 0x38db, 0x0, 0x3717, 0x0,
    0xa82a, 0x0, 0xb801, 0x0, 0xb999, 0x0, 0xb773, 0x0,
    0x2393, 0x0, 0x3878, 0x0, 0x3907, 0x0, 0x37a9, 0x0,
    0x2049, 0x0, 0xb809, 0x0, 0xba5b, 0x0, 0xb806, 0x0,
    0xa820, 0x0, 0x3710, 0x0, 0x3958, 0x0, 0x37e9, 0x0,
    0xa7e7, 0x0, 0xb688, 0x0, 0xb9b7, 0x0, 0xb7a1, 0x0,
    0x9ed0, 0x0, 0x381f, 0x0, 0x398b, 0x0, 0x381e, 0x0,
    0xaaa5, 0x0, 0xb8f4, 0x0, 0xb99f, 0x0, 0xb7a2, 0x0,
    0x2857, 0x0, 0x37a9, 0x0, 0x39a2, 0x0, 0x3719, 0x0,
    0x9d72, 0x0, 0xb6b6, 0x0, 0xb9dd, 0x0, 0xb67b, 0x0,
    0xaa4d, 0x0, 0x36f4, 0x0, 0x3945, 0x0, 0x374b, 0x0,
    0xad13, 0x0, 0xb779, 0x0, 0xb921, 0x0, 0xb7bf, 0x0,
    0x28f2, 0x0, 0x3706, 0x0, 0x398b, 0x0, 0x3958, 0x0,
    0x2d16, 0x0, 0xb8c6, 0x0, 0xb9e6, 0x0, 0xb6a8, 0x0,
    0xa877, 0x0, 0x37f7, 0x0, 0x39d1, 0x0, 0x389c, 0x0,
    0xa9cf, 0x0, 0xb851, 0x0, 0xb870, 0x0, 0xb6e3, 0x0,
    0xa472, 0x0, 0x3823, 0x0, 0x3998, 0x0, 0x3837, 0x0,
    0xaa8c, 0x0, 0xb700, 0x0, 0xb9b1, 0x0, 0xb803, 0x0,
    0x1e54, 0x0, 0x3721, 0x0, 0x3885, 0x0, 0x380c, 0x0,
    0xada6, 0x0, 0xb7aa, 0x0, 0xba35, 0x0, 0xb87e, 0x0,
    0xab6b, 0x0, 0x37b9, 0x0, 0x3949, 0x0, 0x38ba, 0x0,
    0x28a8, 0x0, 0xb5d5, 0x0, 0xb9d7, 0x0, 0xb7aa, 0x0,
    0xade9, 0x0, 0x3763, 0x0, 0x3a03, 0x0, 0x3815, 0x0,
    0x2d18, 0x0, 0xb74b, 0x0, 0xb956, 0x0, 0xb809, 0x0,
    0x9d46, 0x0, 0x3831, 0x0, 0x3927, 0x0, 0x3896, 0x0,
    0x9561, 0x0, 0xb806, 0x0, 0xb8ff, 0x0, 0xb853, 0x0,
    0xadf5, 0x0, 0x385a, 0x0, 0x3954, 0x0, 0x37b7, 0x0,
    0xad11, 0x0, 0xb7c6, 0x0, 0xb9f9, 0x0, 0xb785, 0x0,
    0xa961, 0x0, 0x35a4, 0x0, 0x397f, 0x0, 0x37c5, 0x0,
    0x2742, 0x0, 0xb7a4, 0x0, 0xb93b, 0x0, 0xb87b, 0x0,
    0x2b2f, 0x0, 0x3836, 0x0, 0x39ff, 0x0, 0x3826, 0x0,
    0xafde, 0x0, 0xb7bc, 0x0, 0xb9ec, 0x0, 0xb6b2, 0x0,
    0xa193, 0x0, 0x3765, 0x0, 0x39e5, 0x0, 0x37f0, 0x0,
    0x2c95, 0x0, 0xb81e, 0x0, 0xb99a, 0x0, 0xb846, 0x0,
    0x28b2, 0x0, 0x37ad, 0x0, 0x38c1, 0x0, 0x382f, 0x0,
    0x243d, 0x0, 0xb8a8, 0x0, 0xb8c8, 0x0, 0xb879, 0x0,
    0xa15d, 0x0, 0x382f, 0x0, 0x3abb, 0x0, 0x380c, 0x0,
    0x2605, 0x0, 0xb6b5, 0x0, 0xb9a5, 0x0, 0xb686, 0x0,
    0x9cd6, 0x0, 0x3732, 0x0, 0x3942, 0x0, 0x3820, 0x0,
    0xa8ba, 0x0, 0xb819, 0x0, 0xba1a, 0x0, 0xb838, 0x0,
    0x8b90, 0x0, 0x3773, 0x0, 0x3905, 0x0, 0x3893, 0x0,
    0x9ea6, 0x0, 0xb827, 0x0, 0xba3d, 0x0, 0xb799, 0x0,
    0x274a, 0x0, 0x381b, 0x0, 0x395e, 0x0, 0x3802, 0x0,
    0x25d9, 0x0, 0xb780, 0x0, 0xb967, 0x0, 0xb824, 0x0,
    0x2828, 0x0, 0x384e, 0x0, 0x3a08, 0x0, 0x3816, 0x0,
    0xa1fa, 0x0, 0xb780, 0x0, 0xba37, 0x0, 0xb824, 0x0,
    0x1c82, 0x0, 0x3876, 0x0, 0x395f, 0x0, 0x37ec, 0x0,
    0x2cc5, 0x0, 0xb727, 0x0, 0xb9aa, 0x0, 0xb6fd, 0x0,
    0x257f, 0x0, 0x38bf, 0x0, 0x397d, 0x0, 0x3791, 0x0,
    0x9e7d, 0x0, 0xb6e3, 0x0, 0xb9f2, 0x0, 0xb7f3, 0x0,
    0x1c76, 0x0, 0x3810, 0x0, 0x39d5, 0x0, 0x36f8, 0x0,
    0xa80f, 0x0, 0xb73b, 0x0, 0xb97d, 0x0, 0xb87c, 0x0,
    0xac6b, 0x0, 0x3816, 0x0, 0x39f9, 0x0, 0x36de, 0x0,
    0xaab4, 0x0, 0xb8b5, 0x0, 0xb943, 0x0, 0xb64a, 0x0,
    0x2719, 0x0, 0x383c, 0x0, 0x39a8, 0x0, 0x382d, 0x0,
    0x282f, 0x0, 0xb803, 0x0, 0xb91f, 0x0, 0xb627, 0x0,
    0x1858, 0x0, 0x3762, 0x0, 0x39ce, 0x0, 0x37d2, 0x0,
    0x29df, 0x0, 0xb796, 0x0, 0xba21, 0x0, 0xb760, 0x0,
    0x2a71, 0x0, 0x37fa, 0x0, 0x39fd, 0x0, 0x3814, 0x0,
    0x9eae, 0x0, 0xb6e9, 0x0, 0xb9c8, 0x0, 0xb7a5, 0x0,
    0x2b17, 0x0, 0x376d, 0x0, 0x39dd, 0x0, 0x36c8, 0x0,
    0xa2ad, 0x0, 0xb6d1, 0x0, 0xba35, 0x0, 0xb852, 0x0,
    0xab0a, 0x0, 0x382b, 0x0, 0x39ea, 0x0, 0x3882, 0x0,
    0x2816, 0x0, 0xb6f9, 0x0, 0xb9b2, 0x0, 0xb6ee, 0x0,
    0x2119, 0x0, 0x36a6, 0x0, 0x3a4b, 0x0, 0x36ce, 0x0,
    0xa5a7, 0x0, 0xb816, 0x0, 0xb9d4, 0x0, 0xb863, 0x0,
    0x2db4, 0x0, 0x384a, 0x0, 0x39ff, 0x0, 0x376f, 0x0,
    0x9d5f, 0x0, 0xb743, 0x0, 0xb997, 0x0, 0xb685, 0x0,
    0x2065, 0x0, 0x37ee, 0x0, 0x3a3c, 0x0, 0x381e, 0x0,
    0x28a9, 0x0, 0xb80b, 0x0, 0xbaed, 0x0, 0xb81c, 0x0,
    0x9e6e, 0x0, 0x3770, 0x0, 0x3932, 0x0, 0x3877, 0x0,
    0x23ef, 0x0, 0xb5f1, 0x0, 0xb9b2, 0x0, 0xb74b, 0x0,
    0x276a, 0x0, 0x3769, 0x0, 0x3a0b, 0x0, 0x3822, 0x0,
    0xaf8d, 0x0, 0xb7c6, 0x0, 0xb91c, 0x0, 0xb86a, 0x0,
    0xa87b, 0x0, 0x3732, 0x0, 0x3978, 0x0, 0x3606, 0x0,
    0xb175, 0x0, 0xb821, 0x0, 0xb9e6, 0x0, 0xb81c, 0x0,
    0xa712, 0x0, 0x380d, 0x0, 0x3923, 0x0, 0x3743, 0x0,
    0xaab6, 0x0, 0xb76a, 0x0, 0xb990, 0x0, 0xb80a, 0x0,
    0xaada, 0x0, 0x382b, 0x0, 0x39ac, 0x0, 0x3872, 0x0,
    0x27f2, 0x0, 0xb73c, 0x0, 0xb987, 0x0, 0xb89c, 0x0,
    0x2d6b, 0x0, 0x38ae, 0x0, 0x3938, 0x0, 0x389a, 0x0,
    0xa821, 0x0, 0xb6cf, 0x0, 0xb9b3, 0x0, 0xb66c, 0x0,
    0xa0c6, 0x0, 0x3780, 0x0, 0x3980, 0x0, 0x3856, 0x0,
    0x16af, 0x0, 0xb768, 0x0, 0xb922, 0x0, 0xb7e4, 0x0,
    0x2e48, 0x0, 0x38b3, 0x0, 0x3919, 0x0, 0x3809, 0x0,
    0xab93, 0x0, 0xb848, 0x0, 0xb978, 0x0, 0xb744, 0x0,
    0xaced, 0x0, 0x371e, 0x0, 0x398d, 0x0, 0x384b, 0x0,
    0xa3cc, 0x0, 0xb7c2, 0x0, 0xb94f, 0x0, 0xb845, 0x0,
    0x2cc2, 0x0, 0x38c1, 0x0, 0x3945, 0x0, 0x380c, 0x0,
    0xa826, 0x0, 0xb6f2, 0x0, 0xb92e, 0x0, 0xb72f, 0x0,
    0x2d18, 0x0, 0x36e0, 0x0, 0x3971, 0x0, 0x3809, 0x0,
    0xae64, 0x0, 0xb856, 0x0, 0xb9d1, 0x0, 0xb80d, 0x0,
    0x2c5f, 0x0, 0x3892, 0x0, 0x398d, 0x0, 0x3853, 0x0,
    0xac42, 0x0, 0xb82d, 0x0, 0xb924, 0x0, 0xb735, 0x0,
    0xab19, 0x0, 0x379a, 0x0, 0x39db, 0x0, 0x37f2, 0x0,
    0xa3d9, 0x0, 0xb82a, 0x0, 0xb97d, 0x0, 0xb7fb, 0x0,
    0x1f12, 0x0, 0x3748, 0x0, 0x3a48, 0x0, 0x37c8, 0x0,
    0xa893, 0x0, 0xb789, 0x0, 0xb954, 0x0, 0xb81c, 0x0,
    0x24cd, 0x0, 0x37d8, 0x0, 0x3955, 0x0, 0x373f, 0x0,
    0xab1e, 0x0, 0xb7ef, 0x0, 0xb886, 0x0, 0xb808, 0x0,
    0xa3eb, 0x0, 0x37a1, 0x0, 0x3962, 0x0, 0x3853, 0x0,
    0x21c4, 0x0, 0xb87e, 0x0, 0xb985, 0x0, 0xb70c, 0x0
    };

static const uint16_t in_cifft_noisy_1024[2048] = {
    0x3d95, 0x0, 0x3e9d, 0xb74e, 0xbc06, 0x3ab1, 0xb931, 0x299f,
    0x3a1e, 0xb555, 0x2f1a, 0x3950, 0x3f8d, 0x3885, 0xb657, 0x389f,
    0xbc2d, 0xbdbf, 0xbe5a, 0x39f7, 0xbafa, 0xae0c, 0x3942, 0xb7ab,
    0x3c4d, 0xbfb7, 0xb7f5, 0xa4dc, 0x3e3f, 0xb37d, 0x3595, 0x35aa,
    0xad20, 0x3d21, 0xba55, 0x3265, 0xb913, 0x4120, 0x2c3e, 0x38f1,
    0x36f7, 0x33e4, 0x3173, 0xb79d, 0x3d91, 0xc286, 0x43f4, 0xb64e,
    0xb91d, 0xaea4, 0x3ba7, 0x3504, 0xbd0a, 0xbe85, 0x3a15, 0x3c57,
    0xc213, 0x3a19, 0x3e1b, 0x3d65, 0xbaf2, 0x3cf6, 0xa386, 0xc013,
    0x3e13, 0xc1b3, 0x2cba, 0xae79, 0xb98a, 0xb975, 0x3fb6, 0xb84a,
    0xb973, 0xb840, 0xbe44, 0x3d13, 0xbc2a, 0xba05, 0x40ec, 0x3e99,
    0xb691, 0xb6d2, 0xba93, 0x38cc, 0x3e80, 0xbd23, 0x3692, 0xb848,
    0x3f08, 0x4095, 0xbab7, 0x33dc, 0xb52f, 0x380a, 0xbdb3, 0xbb35,
    0x39c8, 0x3be9, 0xbf59, 0xbb62, 0xba1c, 0xbeb5, 0xa6fe, 0xbbb0,
    0x3a14, 0x3b29, 0x3fa3, 0x3398, 0x400d, 0x391d, 0x3ac9, 0xbd80,
    0xbe82, 0xbb0d, 0x33de, 0xb237, 0x3534, 0xbd28, 0x3631, 0xba1b,
    0x3f0d, 0x3c87, 0xb802, 0x420b, 0xb9f1, 0xa924, 0xbd9c, 0x3afd,
    0x3024, 0x3919, 0xbbf7, 0xbf6b, 0x3985, 0xbd6e, 0x2312, 0x3cbc,
    0xba5b, 0x3994, 0xbc62, 0xbec8, 0xb9f3, 0x3ca5, 0x3acc, 0xb51a,
    0x3a11, 0x3c19, 0xbdd8, 0xb38d, 0x3c57, 0xbea1, 0x3501, 0x3a46,
    0xbc4f, 0x32b1, 0x35be, 0xb590, 0xb482, 0xb1d3, 0x3a90, 0xb79b,
    0x40c0, 0xb9ce, 0xc0d2, 0xbe51, 0x3fca, 0xb4ab, 0x36c6, 0xb7a7,
    0xba57, 0xc200, 0x3415, 0x3e04, 0x3a96, 0x3e2b, 0xba97, 0xb911,
    0xb49a, 0x3435, 0x3509, 0x351c, 0xb80b, 0xbcf1, 0xbe14, 0x36a9,
    0x404d, 0x3d1b, 0xbd34, 0xb4ce, 0x2e0a, 0x3894, 0x3b1f, 0xbe0d,
    0xc2a5, 0xc107, 0x3be6, 0xb750, 0x3892, 0xc048, 0x3d5a, 0xbc83,
    0x28eb, 0xab95, 0x3b9a, 0x2fbe, 0xc0de, 0x38e7, 0x393b, 0x3c18,
    0xb803, 0xb6ed, 0xb45c, 0xba8c, 0xb123, 0xbc79, 0x39c6, 0x3cd0,
    0x3d41, 0x3e03, 0xb705, 0x3201, 0x3bbb, 0x3c0c, 0x3c86, 0x3a95,
    0xb8ae, 0x2ff1, 0xb803, 0x2cfb, 0x36e2, 0x3cc7, 0xbe25, 0xba2b,
    0x2131, 0x3f9c, 0x4084, 0xb9a8, 0xbd62, 0x3464, 0xc00b, 0x3150,
    0x3be2, 0x3df8, 0x3ed6, 0xb23d, 0x340b, 0xc005, 0x3fd8, 0xbc6c,
    0xb4c4, 0xbbb5, 0x311c, 0xb4c8, 0xb332, 0xb6fa, 0x3b6c, 0x30d8,
    0x3daa, 0xdd97, 0x3339, 0xbee8, 0x2e9b, 0x3c24, 0xc047, 0x4142,
    0x31a7, 0x3a3b, 0x3cbc, 0x2880, 0xba22, 0x407d, 0xb697, 0xb8db,
    0xb635, 0x3142, 0x333b, 0x3d45, 0x387e, 0xafc7, 0x3acd, 0x3fee,
    0x3a01, 0xb5f8, 0xbe98, 0xbd38, 0xb84d, 0xb950, 0x3e25, 0x35b9,
    0xb436, 0x2915, 0x3bf8, 0xbaec, 0xb53b, 0xb629, 0xbd78, 0xb8e3,
    0xb997, 0x39d3, 0xb54a, 0xb808, 0xb3d2, 0x4047, 0x399e, 0x3555,
    0x3bed, 0xbc7c, 0xaa41, 0xb788, 0xbb7e, 0xc00d, 0x3c04, 0x3995,
    0x3c58, 0x3d61, 0xabbf, 0xbc30, 0x3d18, 0x30b3, 0xbdf3, 0xae3e,
    0xc0c0, 0xbf01, 0xba2f, 0x3e66, 0xbd1a, 0x3e2a, 0x3e9f, 0xbedd,
    0x3cea, 0xbaf6, 0x3b3a, 0xb51e, 0x3d6e, 0xbc2d, 0xbde8, 0xb911,
    0xb4fe, 0xbd27, 0xbc43, 0xbb00, 0x2f17, 0xbf39, 0xc05f, 0x31eb,
    0x39fd, 0x2882, 0xc0e0, 0x38f8, 0xbb6b, 0xc1d7, 0xb7fe, 0xb8a0,
    0x311f, 0x3f25, 0xb84f, 0x373b, 0x39ba, 0x4030, 0x3941, 0xbb7f,
    0x31d6, 0x339d, 0x3786, 0xb13d, 0x3f62, 0xbfc0, 0xadb4, 0xbd7a,
    0x3c3e, 0xb5a7, 0xaf7a, 0xc12d, 0x3bfb, 0xb844, 0xadbf, 0x1eb8,
    0x3810, 0x4401, 0x3d97, 0x3a1a, 0x3d74, 0x38b3, 0xbcfb, 0x3119,
    0x3c57, 0xb468, 0x3992, 0x3c01, 0xbfdd, 0xb298, 0xb9f0, 0x3022,
    0x3a0f, 0xba1a, 0x3cb4, 0xb796, 0xb995, 0xc189, 0x3cb7, 0xc118,
    0x1fa8, 0xc0f7, 0x2506, 0x2f93, 0xba6e, 0x40b4, 0x3b0a, 0xbbc7,
    0x3777, 0x3c84, 0xb8d1, 0x3164, 0x38a9, 0xc029, 0x4092, 0xb832,
    0xbc0d, 0x39f6, 0xb758, 0xabcb, 0xb838, 0x3976, 0x3001, 0x3ca9,
    0xbaf7, 0xbcbd, 0xb950, 0x38d8, 0x3e44, 0xae48, 0x3a18, 0xb53a,
    0xb680, 0x3b8a, 0xb1f1, 0xb2b9, 0x3890, 0x39c1, 0xb9ab, 0x3cdc,
    0xbe59, 0xb570, 0xae1f, 0x2200, 0x353a, 0xb843, 0x3c2e, 0x3fb4,
    0xb87c, 0x3e4b, 0xb8c0, 0xb949, 0x344b, 0x3b67, 0x3c30, 0xb6e6,
    0xbc3d, 0x3844, 0xbeab, 0x3e1f, 0xb141, 0xb809, 0xb9b0, 0x3cca,
    0x4172, 0xb969, 0x34c8, 0x3993, 0x3fe7, 0x3bfa, 0xbc46, 0x3cc3,
    0x393c, 0x3486, 0xbdb1, 0xc472, 0x3bfd, 0x3dd6, 0x391b, 0x37ca,
    0xabaf, 0x2593, 0xbd13, 0xb6c0, 0xbd6a, 0x31e6, 0x2f36, 0x3c97,
    0x420f, 0x4225, 0xbff5, 0x3919, 0x3aea, 0xb958, 0xaed7, 0xbd9c,
    0x3926, 0x3f35, 0x3c78, 0xb51a, 0xbc12, 0xb94e, 0x341a, 0xb46d,
    0xb620, 0xb889, 0xbe00, 0x3c96, 0xc178, 0x36bb, 0xb964, 0xb3b0,
    0xbd8f, 0x3d45, 0xbc2d, 0xb406, 0x39f0, 0x36d3, 0xbcea, 0x3aae,
    0xbbe3, 0xbc8a, 0xbce7, 0x3cb5, 0xb071, 0x404f, 0xbb4d, 0xb3b8,
    0x3908, 0x3cc1, 0xb60c, 0xb1d5, 0x37de, 0xbb36, 0x3a65, 0xbd86,
    0xbdd8, 0xba88, 0x396d, 0xb5fd, 0x3d05, 0xb4fc, 0xb575, 0x3caa,
    0x3fa0, 0x3a32, 0x3b64, 0x34db, 0xc055, 0xbaa3, 0x3bc0, 0xb992,
    0xb56c, 0xac4b, 0x3c36, 0xc0c2, 0x346e, 0xacb6, 0x4027, 0xbd66,
    0xbd34, 0xb690, 0xb66c, 0x4036, 0x40ec, 0x41b7, 0xbc63, 0xbb99,
    0xbc32, 0xbc5b, 0xb9f8, 0x3e31, 0xbd7f, 0xb5a8, 0xb208, 0xaf30,
    0x3620, 0x402d, 0x34a9, 0xb50a, 0x3dcd, 0x3cd9, 0xc0d3, 0xb468,
    0xbc0a, 0xbad8, 0x3c20, 0xb154, 0x373d, 0xb024, 0xbccc, 0x3304,
    0x3e52, 0x2c32, 0x3b62, 0xba61, 0xbaa5, 0xb8ca, 0xb8d8, 0x372c,
    0xbc0c, 0x39e6, 0x394e, 0xb890, 0x387a, 0xb83b, 0xbd97, 0x3857,
    0xbae4, 0xbe08, 0xb824, 0x410e, 0x3432, 0x3a96, 0xbb39, 0xba88,
    0xa537, 0x3860, 0xc030, 0x3dda, 0xbec8, 0x2874, 0x3498, 0x3c80,
    0x2875, 0xc002, 0x3bc2, 0x386b, 0x402e, 0xb446, 0x40a2, 0xb08b,
    0x3ad4, 0xb7bf, 0xbec1, 0xa53b, 0xc01c, 0x4144, 0x3aaa, 0x38d1,
    0x3621, 0x3bbf, 0xb499, 0x3e0e, 0xb5ab, 0x3d63, 0x3994, 0x39d6,
    0x3953, 0xbdb9, 0x3de2, 0xbeba, 0xbeea, 0xc048, 0xbcdd, 0xbf1d,
    0x3ce9, 0xb81c, 0xb8bf, 0x400f, 0x3c5f, 0xbdf2, 0xb970, 0xbaa0,
    0x3995, 0x3c79, 0xc047, 0xb1f3, 0x2f2a, 0x301f, 0x3c12, 0x36e1,
    0xb467, 0x3c52, 0xc000, 0x401c, 0x3a33, 0xb8e8, 0x3bec, 0x3c7a,
    0x3942, 0x3d3e, 0xb823, 0xc00c, 0x3ec7, 0x399f, 0xc066, 0x31c2,
    0x3d00, 0x4057, 0xbbc4, 0x3ce3, 0xbed0, 0x3823, 0x341f, 0xbcea,
    0x3ae7, 0x3f03, 0xb383, 0xbbfb, 0xa63e, 0xa9f0, 0xbeb1, 0x21ff,
    0xb972, 0xa9af, 0xbc77, 0x3778, 0xb601, 0xbd75, 0x38a3, 0xb532,
    0xbc4c, 0xb874, 0xb4db, 0xbe60, 0xbb54, 0xc193, 0x3944, 0x3b0f,
    0x3374, 0x3cda, 0xba76, 0xbebc, 0xbc2e, 0xb8e4, 0xbd09, 0x353d,
    0x39de, 0x347c, 0x3bbc, 0xbc64, 0x2c39, 0xb564, 0x2520, 0xb0fe,
    0xb8bc, 0x2f18, 0xb856, 0xb5ff, 0x3647, 0xba82, 0xbd42, 0x3664,
    0x3dec, 0xbd6e, 0xb9ac, 0xbcfb, 0xbe07, 0xbdbd, 0x36f9, 0xbd7f,
    0xbd2b, 0x3b7a, 0x3797, 0x3e15, 0xb9cd, 0x3d0f, 0xc2b2, 0xbdcf,
    0xbf69, 0xbb12, 0xbe7e, 0xc363, 0x3df0, 0x3d7d, 0x406e, 0xbbaa,
    0x3e15, 0xbdd2, 0xbb47, 0x412a, 0x24d7, 0xbf9f, 0xb9d5, 0xb5c2,
    0x2f2d, 0x326d, 0x3919, 0x3dec, 0xb886, 0x3b72, 0x3839, 0x3a08,
    0xbb03, 0x3e50, 0xbc84, 0x30f3, 0x38f0, 0x3ea6, 0xbab1, 0xbda6,
    0x3ba1, 0x3cc0, 0x3ebd, 0xbb7e, 0x3465, 0xb999, 0xbdaf, 0xc0fe,
    0xbcec, 0x3716, 0x332b, 0xb6f8, 0x3f45, 0xbc39, 0xbc77, 0xb482,
    0xbb50, 0xbc40, 0xb9f2, 0x2984, 0xab84, 0xb1b3, 0xc008, 0x38b1,
    0x3c98, 0xb8fb, 0x3b66, 0x41fd, 0xa81d, 0x3045, 0x3ba2, 0xbccf,
    0x34a9, 0x3e29, 0xb211, 0xba29, 0xc196, 0x3824, 0x384b, 0x3dc9,
    0x3928, 0x378b, 0xbe68, 0xbfda, 0x3a2d, 0xbcd2, 0x2d4b, 0x3965,
    0x2f47, 0x396d, 0x381a, 0x3e0c, 0xb0c1, 0xb30e, 0x3d26, 0x3cea,
    0x3bb6, 0x383a, 0x39f6, 0xb241, 0xb37b, 0xbe22, 0xba48, 0xba9d,
    0x3a16, 0x3f1a, 0x36d3, 0x3b9d, 0x3eac, 0xbf0a, 0xb28e, 0xb5a1,
    0xb697, 0x3d86, 0x3a2d, 0xb135, 0x3d49, 0xbd27, 0xbc52, 0xb1b2,
    0xc0fb, 0xb034, 0xc1f7, 0xb6a5, 0x3c7d, 0x3af0, 0x3389, 0x4136,
    0xb7db, 0xc0c8, 0xb2dd, 0xbf1a, 0x3cc6, 0xb6f6, 0xbabd, 0x313c,
    0x39df, 0xb77a, 0xbcfc, 0x3ab9, 0xae08, 0x3e04, 0x3b50, 0x3b58,
    0xc1a3, 0xbbcb, 0x307e, 0x3abb, 0x2864, 0xaf5d, 0xbcd3, 0x3af9,
    0xbd58, 0x3c85, 0x36f5, 0x9c49, 0xc171, 0x2cf2, 0x3e0f, 0xbf88,
    0xb711, 0xac49, 0xb6c8, 0x2bab, 0x350a, 0x3ee5, 0xb31c, 0x3902,
    0x29e9, 0x3d5d, 0x37f2, 0x3bc7, 0xad1e, 0xc0ea, 0xbccc, 0xbd35,
    0xb77c, 0x410e, 0xaf2c, 0xbf80, 0x34d0, 0x306c, 0x3612, 0x3a90,
    0x3a75, 0xb297, 0xb029, 0xbac0, 0x3cf3, 0x35cb, 0xbbf0, 0x3d6a,
    0xbd06, 0x3871, 0x3610, 0x3c90, 0x2e00, 0x3c27, 0x382f, 0xb779,
    0x343d, 0xbaca, 0x3e84, 0x37b0, 0xb31c, 0x4071, 0xba29, 0x3623,
    0x3c1a, 0xbadc, 0xbf2c, 0xbdae, 0xb8ea, 0x3d08, 0x3a54, 0x3e2a,
    0x382f, 0x28ff, 0x3e90, 0xbd7c, 0xba12, 0x405c, 0x3aa8, 0xb33c,
    0xc030, 0xbf69, 0xb11d, 0x34d6, 0x3cbb, 0xbf45, 0xbc03, 0x3551,
    0x39fc, 0xbc2f, 0xb3f4, 0x3d44, 0x34bf, 0x3016, 0x3c54, 0xbf3d,
    0xbd58, 0x2c6f, 0x3a4d, 0xc072, 0xbd1d, 0x3ca3, 0xbc69, 0x39fa,
    0x3bc5, 0xbbde, 0x310f, 0xb5ec, 0xbb57, 0x38f0, 0xb79a, 0xb100,
    0xace4, 0xbe82, 0x40a4, 0x3ac3, 0x2fb1, 0x32f4, 0x3af0, 0xb9e4,
    0x384a, 0x420a, 0x3599, 0x34c4, 0x3ca8, 0x3bb5, 0x3b6b, 0x38d2,
    0xc344, 0x0, 0x3b6b, 0xb8d2, 0x3ca8, 0xbbb5, 0x3599, 0xb4c4,
    0x384a, 0xc20a, 0x3af0, 0x39e4, 0x2fb1, 0xb2f4, 0x40a4, 0xbac3,
    0xace4, 0x3e82, 0xb79a, 0x3100, 0xbb57, 0xb8f0, 0x310f, 0x35ec,
    0x3bc5, 0x3bde, 0xbc69, 0xb9fa, 0xbd1d, 0xbca3, 0x3a4d, 0x4072,
    0xbd58, 0xac6f, 0x3c54, 0x3f3d, 0x34bf, 0xb016, 0xb3f4, 0xbd44,
    0x39fc, 0x3c2f, 0xbc03, 0xb551, 0x3cbb, 0x3f45, 0xb11d, 0xb4d6,
    0xc030, 0x3f69, 0x3aa8, 0x333c, 0xba12, 0xc05c, 0x3e90, 0x3d7c,
    0x382f, 0xa8ff, 0x3a54, 0xbe2a, 0xb8ea, 0xbd08, 0xbf2c, 0x3dae,
    0x3c1a, 0x3adc, 0xba29, 0xb623, 0xb31c, 0xc071, 0x3e84, 0xb7b0,
    0x343d, 0x3aca, 0x382f, 0x3779, 0x2e00, 0xbc27, 0x3610, 0xbc90,
    0xbd06, 0xb871, 0xbbf0, 0xbd6a, 0x3cf3, 0xb5cb, 0xb029, 0x3ac0,
    0x3a75, 0x3297, 0x3612, 0xba90, 0x34d0, 0xb06c, 0xaf2c, 0x3f80,
    0xb77c, 0xc10e, 0xbccc, 0x3d35, 0xad1e, 0x40ea, 0x37f2, 0xbbc7,
    0x29e9, 0xbd5d, 0xb31c, 0xb902, 0x350a, 0xbee5, 0xb6c8, 0xabab,
    0xb711, 0x2c49, 0x3e0f, 0x3f88, 0xc171, 0xacf2, 0x36f5, 0x1c49,
    0xbd58, 0xbc85, 0xbcd3, 0xbaf9, 0x2864, 0x2f5d, 0x307e, 0xbabb,
    0xc1a3, 0x3bcb, 0x3b50, 0xbb58, 0xae08, 0xbe04, 0xbcfc, 0xbab9,
    0x39df, 0x377a, 0xbabd, 0xb13c, 0x3cc6, 0x36f6, 0xb2dd, 0x3f1a,
    0xb7db, 0x40c8, 0x3389, 0xc136, 0x3c7d, 0xbaf0, 0xc1f7, 0x36a5,
    0xc0fb, 0x3034, 0xbc52, 0x31b2, 0x3d49, 0x3d27, 0x3a2d, 0x3135,
    0xb697, 0xbd86, 0xb28e, 0x35a1, 0x3eac, 0x3f0a, 0x36d3, 0xbb9d,
    0x3a16, 0xbf1a, 0xba48, 0x3a9d, 0xb37b, 0x3e22, 0x39f6, 0x3241,
    0x3bb6, 0xb83a, 0x3d26, 0xbcea, 0xb0c1, 0x330e, 0x381a, 0xbe0c,
    0x2f47, 0xb96d, 0x2d4b, 0xb965, 0x3a2d, 0x3cd2, 0xbe68, 0x3fda,
    0x3928, 0xb78b, 0x384b, 0xbdc9, 0xc196, 0xb824, 0xb211, 0x3a29,
    0x34a9, 0xbe29, 0x3ba2, 0x3ccf, 0xa81d, 0xb045, 0x3b66, 0xc1fd,
    0x3c98, 0x38fb, 0xc008, 0xb8b1, 0xab84, 0x31b3, 0xb9f2, 0xa984,
    0xbb50, 0x3c40, 0xbc77, 0x3482, 0x3f45, 0x3c39, 0x332b, 0x36f8,
    0xbcec, 0xb716, 0xbdaf, 0x40fe, 0x3465, 0x3999, 0x3ebd, 0x3b7e,
    0x3ba1, 0xbcc0, 0xbab1, 0x3da6, 0x38f0, 0xbea6, 0xbc84, 0xb0f3,
    0xbb03, 0xbe50, 0x3839, 0xba08, 0xb886, 0xbb72, 0x3919, 0xbdec,
    0x2f2d, 0xb26d, 0xb9d5, 0x35c2, 0x24d7, 0x3f9f, 0xbb47, 0xc12a,
    0x3e15, 0x3dd2, 0x406e, 0x3baa, 0x3df0, 0xbd7d, 0xbe7e, 0x4363,
    0xbf69, 0x3b12, 0xc2b2, 0x3dcf, 0xb9cd, 0xbd0f, 0x3797, 0xbe15,
    0xbd2b, 0xbb7a, 0x36f9, 0x3d7f, 0xbe07, 0x3dbd, 0xb9ac, 0x3cfb,
    0x3dec, 0x3d6e, 0xbd42, 0xb664, 0x3647, 0x3a82, 0xb856, 0x35ff,
    0xb8bc, 0xaf18, 0x2520, 0x30fe, 0x2c39, 0x3564, 0x3bbc, 0x3c64,
    0x39de, 0xb47c, 0xbd09, 0xb53d, 0xbc2e, 0x38e4, 0xba76, 0x3ebc,
    0x3374, 0xbcda, 0x3944, 0xbb0f, 0xbb54, 0x4193, 0xb4db, 0x3e60,
    0xbc4c, 0x3874, 0x38a3, 0x3532, 0xb601, 0x3d75, 0xbc77, 0xb778,
    0xb972, 0x29af, 0xbeb1, 0xa1ff, 0xa63e, 0x29f0, 0xb383, 0x3bfb,
    0x3ae7, 0xbf03, 0x341f, 0x3cea, 0xbed0, 0xb823, 0xbbc4, 0xbce3,
    0x3d00, 0xc057, 0xc066, 0xb1c2, 0x3ec7, 0xb99f, 0xb823, 0x400c,
    0x3942, 0xbd3e, 0x3bec, 0xbc7a, 0x3a33, 0x38e8, 0xc000, 0xc01c,
    0xb467, 0xbc52, 0x3c12, 0xb6e1, 0x2f2a, 0xb01f, 0xc047, 0x31f3,
    0x3995, 0xbc79, 0xb970, 0x3aa0, 0x3c5f, 0x3df2, 0xb8bf, 0xc00f,
    0x3ce9, 0x381c, 0xbcdd, 0x3f1d, 0xbeea, 0x4048, 0x3de2, 0x3eba,
    0x3953, 0x3db9, 0x3994, 0xb9d6, 0xb5ab, 0xbd63, 0xb499, 0xbe0e,
    0x3621, 0xbbbf, 0x3aaa, 0xb8d1, 0xc01c, 0xc144, 0xbec1, 0x253b,
    0x3ad4, 0x37bf, 0x40a2, 0x308b, 0x402e, 0x3446, 0x3bc2, 0xb86b,
    0x2875, 0x4002, 0x3498, 0xbc80, 0xbec8, 0xa874, 0xc030, 0xbdda,
    0xa537, 0xb860, 0xbb39, 0x3a88, 0x3432, 0xba96, 0xb824, 0xc10e,
    0xbae4, 0x3e08, 0xbd97, 0xb857, 0x387a, 0x383b, 0x394e, 0x3890,
    0xbc0c, 0xb9e6, 0xb8d8, 0xb72c, 0xbaa5, 0x38ca, 0x3b62, 0x3a61,
    0x3e52, 0xac32, 0xbccc, 0xb304, 0x373d, 0x3024, 0x3c20, 0x3154,
    0xbc0a, 0x3ad8, 0xc0d3, 0x3468, 0x3dcd, 0xbcd9, 0x34a9, 0x350a,
    0x3620, 0xc02d, 0xb208, 0x2f30, 0xbd7f, 0x35a8, 0xb9f8, 0xbe31,
    0xbc32, 0x3c5b, 0xbc63, 0x3b99, 0x40ec, 0xc1b7, 0xb66c, 0xc036,
    0xbd34, 0x3690, 0x4027, 0x3d66, 0x346e, 0x2cb6, 0x3c36, 0x40c2,
    0xb56c, 0x2c4b, 0x3bc0, 0x3992, 0xc055, 0x3aa3, 0x3b64, 0xb4db,
    0x3fa0, 0xba32, 0xb575, 0xbcaa, 0x3d05, 0x34fc, 0x396d, 0x35fd,
    0xbdd8, 0x3a88, 0x3a65, 0x3d86, 0x37de, 0x3b36, 0xb60c, 0x31d5,
    0x3908, 0xbcc1, 0xbb4d, 0x33b8, 0xb071, 0xc04f, 0xbce7, 0xbcb5,
    0xbbe3, 0x3c8a, 0xbcea, 0xbaae, 0x39f0, 0xb6d3, 0xbc2d, 0x3406,
    0xbd8f, 0xbd45, 0xb964, 0x33b0, 0xc178, 0xb6bb, 0xbe00, 0xbc96,
    0xb620, 0x3889, 0x341a, 0x346d, 0xbc12, 0x394e, 0x3c78, 0x351a,
    0x3926, 0xbf35, 0xaed7, 0x3d9c, 0x3aea, 0x3958, 0xbff5, 0xb919,
    0x420f, 0xc225, 0x2f36, 0xbc97, 0xbd6a, 0xb1e6, 0xbd13, 0x36c0,
    0xabaf, 0xa593, 0x391b, 0xb7ca, 0x3bfd, 0xbdd6, 0xbdb1, 0x4472,
    0x393c, 0xb486, 0xbc46, 0xbcc3, 0x3fe7, 0xbbfa, 0x34c8, 0xb993,
    0x4172, 0x3969, 0xb9b0, 0xbcca, 0xb141, 0x3809, 0xbeab, 0xbe1f,
    0xbc3d, 0xb844, 0x3c30, 0x36e6, 0x344b, 0xbb67, 0xb8c0, 0x3949,
    0xb87c, 0xbe4b, 0x3c2e, 0xbfb4, 0x353a, 0x3843, 0xae1f, 0xa200,
    0xbe59, 0x3570, 0xb9ab, 0xbcdc, 0x3890, 0xb9c1, 0xb1f1, 0x32b9,
    0xb680, 0xbb8a, 0x3a18, 0x353a, 0x3e44, 0x2e48, 0xb950, 0xb8d8,
    0xbaf7, 0x3cbd, 0x3001, 0xbca9, 0xb838, 0xb976, 0xb758, 0x2bcb,
    0xbc0d, 0xb9f6, 0x4092, 0x3832, 0x38a9, 0x4029, 0xb8d1, 0xb164,
    0x3777, 0xbc84, 0x3b0a, 0x3bc7, 0xba6e, 0xc0b4, 0x2506, 0xaf93,
    0x1fa8, 0x40f7, 0x3cb7, 0x4118, 0xb995, 0x4189, 0x3cb4, 0x3796,
    0x3a0f, 0x3a1a, 0xb9f0, 0xb022, 0xbfdd, 0x3298, 0x3992, 0xbc01,
    0x3c57, 0x3468, 0xbcfb, 0xb119, 0x3d74, 0xb8b3, 0x3d97, 0xba1a,
    0x3810, 0xc401, 0xadbf, 0x9eb8, 0x3bfb, 0x3844, 0xaf7a, 0x412d,
    0x3c3e, 0x35a7, 0xadb4, 0x3d7a, 0x3f62, 0x3fc0, 0x3786, 0x313d,
    0x31d6, 0xb39d, 0x3941, 0x3b7f, 0x39ba, 0xc030, 0xb84f, 0xb73b,
    0x311f, 0xbf25, 0xb7fe, 0x38a0, 0xbb6b, 0x41d7, 0xc0e0, 0xb8f8,
    0x39fd, 0xa882, 0xc05f, 0xb1eb, 0x2f17, 0x3f39, 0xbc43, 0x3b00,
    0xb4fe, 0x3d27, 0xbde8, 0x3911, 0x3d6e, 0x3c2d, 0x3b3a, 0x351e,
    0x3cea, 0x3af6, 0x3e9f, 0x3edd, 0xbd1a, 0xbe2a, 0xba2f, 0xbe66,
    0xc0c0, 0x3f01, 0xbdf3, 0x2e3e, 0x3d18, 0xb0b3, 0xabbf, 0x3c30,
    0x3c58, 0xbd61, 0x3c04, 0xb995, 0xbb7e, 0x400d, 0xaa41, 0x3788,
    0x3bed, 0x3c7c, 0x399e, 0xb555, 0xb3d2, 0xc047, 0xb54a, 0x3808,
    0xb997, 0xb9d3, 0xbd78, 0x38e3, 0xb53b, 0x3629, 0x3bf8, 0x3aec,
    0xb436, 0xa915, 0x3e25, 0xb5b9, 0xb84d, 0x3950, 0xbe98, 0x3d38,
    0x3a01, 0x35f8, 0x3acd, 0xbfee, 0x387e, 0x2fc7, 0x333b, 0xbd45,
    0xb635, 0xb142, 0xb697, 0x38db, 0xba22, 0xc07d, 0x3cbc, 0xa880,
    0x31a7, 0xba3b, 0xc047, 0xc142, 0x2e9b, 0xbc24, 0x3339, 0x3ee8,
    0x3daa, 0x5d97, 0x3b6c, 0xb0d8, 0xb332, 0x36fa, 0x311c, 0x34c8,
    0xb4c4, 0x3bb5, 0x3fd8, 0x3c6c, 0x340b, 0x4005, 0x3ed6, 0x323d,
    0x3be2, 0xbdf8, 0xc00b, 0xb150, 0xbd62, 0xb464, 0x4084, 0x39a8,
    0x2131, 0xbf9c, 0xbe25, 0x3a2b, 0x36e2, 0xbcc7, 0xb803, 0xacfb,
    0xb8ae, 0xaff1, 0x3c86, 0xba95, 0x3bbb, 0xbc0c, 0xb705, 0xb201,
    0x3d41, 0xbe03, 0x39c6, 0xbcd0, 0xb123, 0x3c79, 0xb45c, 0x3a8c,
    0xb803, 0x36ed, 0x393b, 0xbc18, 0xc0de, 0xb8e7, 0x3b9a, 0xafbe,
    0x28eb, 0x2b95, 0x3d5a, 0x3c83, 0x3892, 0x4048, 0x3be6, 0x3750,
    0xc2a5, 0x4107, 0x3b1f, 0x3e0d, 0x2e0a, 0xb894, 0xbd34, 0x34ce,
    0x404d, 0xbd1b, 0xbe14, 0xb6a9, 0xb80b, 0x3cf1, 0x3509, 0xb51c,
    0xb49a, 0xb435, 0xba97, 0x3911, 0x3a96, 0xbe2b, 0x3415, 0xbe04,
    0xba57, 0x4200, 0x36c6, 0x37a7, 0x3fca, 0x34ab, 0xc0d2, 0x3e51,
    0x40c0, 0x39ce, 0x3a90, 0x379b, 0xb482, 0x31d3, 0x35be, 0x3590,
    0xbc4f, 0xb2b1, 0x3501, 0xba46, 0x3c57, 0x3ea1, 0xbdd8, 0x338d,
    0x3a11, 0xbc19, 0x3acc, 0x351a, 0xb9f3, 0xbca5, 0xbc62, 0x3ec8,
    0xba5b, 0xb994, 0x2312, 0xbcbc, 0x3985, 0x3d6e, 0xbbf7, 0x3f6b,
    0x3024, 0xb919, 0xbd9c, 0xbafd, 0xb9f1, 0x2924, 0xb802, 0xc20b,
    0x3f0d, 0xbc87, 0x3631, 0x3a1b, 0x3534, 0x3d28, 0x33de, 0x3237,
    0xbe82, 0x3b0d, 0x3ac9, 0x3d80, 0x400d, 0xb91d, 0x3fa3, 0xb398,
    0x3a14, 0xbb29, 0xa6fe, 0x3bb0, 0xba1c, 0x3eb5, 0xbf59, 0x3b62,
    0x39c8, 0xbbe9, 0xbdb3, 0x3b35, 0xb52f, 0xb80a, 0xbab7, 0xb3dc,
    0x3f08, 0xc095, 0x3692, 0x3848, 0x3e80, 0x3d23, 0xba93, 0xb8cc,
    0xb691, 0x36d2, 0x40ec, 0xbe99, 0xbc2a, 0x3a05, 0xbe44, 0xbd13,
    0xb973, 0x3840, 0x3fb6, 0x384a, 0xb98a, 0x3975, 0x2cba, 0x2e79,
    0x3e13, 0x41b3, 0xa386, 0x4013, 0xbaf2, 0xbcf6, 0x3e1b, 0xbd65,
    0xc213, 0xba19, 0x3a15, 0xbc57, 0xbd0a, 0x3e85, 0x3ba7, 0xb504,
    0xb91d, 0x2ea4, 0x43f4, 0x364e, 0x3d91, 0x4286, 0x3173, 0x379d,
    0x36f7, 0xb3e4, 0x2c3e, 0xb8f1, 0xb913, 0xc120, 0xba55, 0xb265,
    0xad20, 0xbd21, 0x3595, 0xb5aa, 0x3e3f, 0x337d, 0xb7f5, 0x24dc,
    0x3c4d, 0x3fb7, 0x3942, 0x37ab, 0xbafa, 0x2e0c, 0xbe5a, 0xb9f7,
    0xbc2d, 0x3dbf, 0xb657, 0xb89f, 0x3f8d, 0xb885, 0x2f1a, 0xb950,
    0x3a1e, 0x3555, 0xb931, 0xa99f, 0xbc06, 0xbab1, 0x3e9d, 0x374e
    };

static const uint16_t ref_cfft_noisy_1024[2048] = {
    0x3d95, 0x0, 0x3e9d, 0xb74e, 0xbc06, 0x3ab1, 0xb931, 0x299f,
    0x3a1e, 0xb555, 0x2f1a, 0x3950, 0x3f8d, 0x3885, 0xb657, 0x389f,
    0xbc2d, 0xbdbf, 0xbe5a, 0x39f7, 0xbafa, 0xae0c, 0x3942, 0xb7ab,
    0x3c4d, 0xbfb7, 0xb7f5, 0xa4dc, 0x3e3f, 0xb37d, 0x3595, 0x35aa,
    0xad20, 0x3d21, 0xba55, 0x3265, 0xb913, 0x4120, 0x2c3e, 0x38f1,
    0x36f7, 0x33e4, 0x3173, 0xb79d, 0x3d91, 0xc286, 0x43f4, 0xb64e,
    0xb91d, 0xaea4, 0x3ba7, 0x3504, 0xbd0a, 0xbe85, 0x3a15, 0x3c57,
    0xc213, 0x3a19, 0x3e1b, 0x3d65, 0xbaf2, 0x3cf6, 0xa386, 0xc013,
    0x3e13, 0xc1b3, 0x2cba, 0xae79, 0xb98a, 0xb975, 0x3fb6, 0xb84a,
    0xb973, 0xb840, 0xbe44, 0x3d13, 0xbc2a, 0xba05, 0x40ec, 0x3e99,
    0xb691, 0xb6d2, 0xba93, 0x38cc, 0x3e80, 0xbd23, 0x3692, 0xb848,
    0x3f08, 0x4095, 0xbab7, 0x33dc, 0xb52f, 0x380a, 0xbdb3, 0xbb35,
    0x39c8, 0x3be9, 0xbf59, 0xbb62, 0xba1c, 0xbeb5, 0xa6fe, 0xbbb0,
    0x3a14, 0x3b29, 0x3fa3, 0x3398, 0x400d, 0x391d, 0x3ac9, 0xbd80,
    0xbe82, 0xbb0d, 0x33de, 0xb237, 0x3534, 0xbd28, 0x3631, 0xba1b,
    0x3f0d, 0x3c87, 0xb802, 0x420b, 0xb9f1, 0xa924, 0xbd9c, 0x3afd,
    0x3024, 0x3919, 0xbbf7, 0xbf6b, 0x3985, 0xbd6e, 0x2312, 0x3cbc,
    0xba5b, 0x3994, 0xbc62, 0xbec8, 0xb9f3, 0x3ca5, 0x3acc, 0xb51a,
    0x3a11, 0x3c19, 0xbdd8, 0xb38d, 0x3c57, 0xbea1, 0x3501, 0x3a46,
    0xbc4f, 0x32b1, 0x35be, 0xb590, 0xb482, 0xb1d3, 0x3a90, 0xb79b,
    0x40c0, 0xb9ce, 0xc0d2, 0xbe51, 0x3fca, 0xb4ab, 0x36c6, 0xb7a7,
    0xba57, 0xc200, 0x3415, 0x3e04, 0x3a96, 0x3e2b, 0xba97, 0xb911,
    0xb49a, 0x3435, 0x3509, 0x351c, 0xb80b, 0xbcf1, 0xbe14, 0x36a9,
    0x404d, 0x3d1b, 0xbd34, 0xb4ce, 0x2e0a, 0x3894, 0x3b1f, 0xbe0d,
    0xc2a5, 0xc107, 0x3be6, 0xb750, 0x3892, 0xc048, 0x3d5a, 0xbc83,
    0x28eb, 0xab95, 0x3b9a, 0x2fbe, 0xc0de, 0x38e7, 0x393b, 0x3c18,
    0xb803, 0xb6ed, 0xb45c, 0xba8c, 0xb123, 0xbc79, 0x39c6, 0x3cd0,
    0x3d41, 0x3e03, 0xb705, 0x3201, 0x3bbb, 0x3c0c, 0x3c86, 0x3a95,
    0xb8ae, 0x2ff1, 0xb803, 0x2cfb, 0x36e2, 0x3cc7, 0xbe25, 0xba2b,
    0x2131, 0x3f9c, 0x4084, 0xb9a8, 0xbd62, 0x3464, 0xc00b, 0x3150,
    0x3be2, 0x3df8, 0x3ed6, 0xb23d, 0x340b, 0xc005, 0x3fd8, 0xbc6c,
    0xb4c4, 0xbbb5, 0x311c, 0xb4c8, 0xb332, 0xb6fa, 0x3b6c, 0x30d8,
    0x3daa, 0xdd97, 0x3339, 0xbee8, 0x2e9b, 0x3c24, 0xc047, 0x4142,
    0x31a7, 0x3a3b, 0x3cbc, 0x2880, 0xba22, 0x407d, 0xb697, 0xb8db,
    0xb635, 0x3142, 0x333b, 0x3d45, 0x387e, 0xafc7, 0x3acd, 0x3fee,
    0x3a01, 0xb5f8, 0xbe98, 0xbd38, 0xb84d, 0xb950, 0x3e25, 0x35b9,
    0xb436, 0x2915, 0x3bf8, 0xbaec, 0xb53b, 0xb629, 0xbd78, 0xb8e3,
    0xb997, 0x39d3, 0xb54a, 0xb808, 0xb3d2, 0x4047, 0x399e, 0x3555,
    0x3bed, 0xbc7c, 0xaa41, 0xb788, 0xbb7e, 0xc00d, 0x3c04, 0x3995,
    0x3c58, 0x3d61, 0xabbf, 0xbc30, 0x3d18, 0x30b3, 0xbdf3, 0xae3e,
    0xc0c0, 0xbf01, 0xba2f, 0x3e66, 0xbd1a, 0x3e2a, 0x3e9f, 0xbedd,
    0x3cea, 0xbaf6, 0x3b3a, 0xb51e, 0x3d6e, 0xbc2d, 0xbde8, 0xb911,
    0xb4fe, 0xbd27, 0xbc43, 0xbb00, 0x2f17, 0xbf39, 0xc05f, 0x31eb,
    0x39fd, 0x2882, 0xc0e0, 0x38f8, 0xbb6b, 0xc1d7, 0xb7fe, 0xb8a0,
    0x311f, 0x3f25, 0xb84f, 0x373b, 0x39ba, 0x4030, 0x3941, 0xbb7f,
    0x31d6, 0x339d, 0x3786, 0xb13d, 0x3f62, 0xbfc0, 0xadb4, 0xbd7a,
    0x3c3e, 0xb5a7, 0xaf7a, 0xc12d, 0x3bfb, 0xb844, 0xadbf, 0x1eb8,
    0x3810, 0x4401, 0x3d97, 0x3a1a, 0x3d74, 0x38b3, 0xbcfb, 0x3119,
    0x3c57, 0xb468, 0x3992, 0x3c01, 0xbfdd, 0xb298, 0xb9f0, 0x3022,
    0x3a0f, 0xba1a, 0x3cb4, 0xb796, 0xb995, 0xc189, 0x3cb7, 0xc118,
    0x1fa8, 0xc0f7, 0x2506, 0x2f93, 0xba6e, 0x40b4, 0x3b0a, 0xbbc7,
    0x3777, 0x3c84, 0xb8d1, 0x3164, 0x38a9, 0xc029, 0x4092, 0xb832,
    0xbc0d, 0x39f6, 0xb758, 0xabcb, 0xb838, 0x3976, 0x3001, 0x3ca9,
    0xbaf7, 0xbcbd, 0xb950, 0x38d8, 0x3e44, 0xae48, 0x3a18, 0xb53a,
    0xb680, 0x3b8a, 0xb1f1, 0xb2b9, 0x3890, 0x39c1, 0xb9ab, 0x3cdc,
    0xbe59, 0xb570, 0xae1f, 0x2200, 0x353a, 0xb843, 0x3c2e, 0x3fb4,
    0xb87c, 0x3e4b, 0xb8c0, 0xb949, 0x344b, 0x3b67, 0x3c30, 0xb6e6,
    0xbc3d, 0x3844, 0xbeab, 0x3e1f, 0xb141, 0xb809, 0xb9b0, 0x3cca,
    0x4172, 0xb969, 0x34c8, 0x3993, 0x3fe7, 0x3bfa, 0xbc46, 0x3cc3,
    0x393c, 0x3486, 0xbdb1, 0xc472, 0x3bfd, 0x3dd6, 0x391b, 0x37ca,
    0xabaf, 0x2593, 0xbd13, 0xb6c0, 0xbd6a, 0x31e6, 0x2f36, 0x3c97,
    0x420f, 0x4225, 0xbff5, 0x3919, 0x3aea, 0xb958, 0xaed7, 0xbd9c,
    0x3926, 0x3f35, 0x3c78, 0xb51a, 0xbc12, 0xb94e, 0x341a, 0xb46d,
    0xb620, 0xb889, 0xbe00, 0x3c96, 0xc178, 0x36bb, 0xb964, 0xb3b0,
    0xbd8f, 0x3d45, 0xbc2d, 0xb406, 0x39f0, 0x36d3, 0xbcea, 0x3aae,
    0xbbe3, 0xbc8a, 0xbce7, 0x3cb5, 0xb071, 0x404f, 0xbb4d, 0xb3b8,
    0x3908, 0x3cc1, 0xb60c, 0xb1d5, 0x37de, 0xbb36, 0x3a65, 0xbd86,
    0xbdd8, 0xba88, 0x396d, 0xb5fd, 0x3d05, 0xb4fc, 0xb575, 0x3caa,
    0x3fa0, 0x3a32, 0x3b64, 0x34db, 0xc055, 0xbaa3, 0x3bc0, 0xb992,
    0xb56c, 0xac4b, 0x3c36, 0xc0c2, 0x346e, 0xacb6, 0x4027, 0xbd66,
    0xbd34, 0xb690, 0xb66c, 0x4036, 0x40ec, 0x41b7, 0xbc63, 0xbb99,
    0xbc32, 0xbc5b, 0xb9f8, 0x3e31, 0xbd7f, 0xb5a8, 0xb208, 0xaf30,
    0x3620, 0x402d, 0x34a9, 0xb50a, 0x3dcd, 0x3cd9, 0xc0d3, 0xb468,
    0xbc0a, 0xbad8, 0x3c20, 0xb154, 0x373d, 0xb024, 0xbccc, 0x3304,
    0x3e52, 0x2c32, 0x3b62, 0xba61, 0xbaa5, 0xb8ca, 0xb8d8, 0x372c,
    0xbc0c, 0x39e6, 0x394e, 0xb890, 0x387a, 0xb83b, 0xbd97, 0x3857,
    0xbae4, 0xbe08, 0xb824, 0x410e, 0x3432, 0x3a96, 0xbb39, 0xba88,
    0xa537, 0x3860, 0xc030, 0x3dda, 0xbec8, 0x2874, 0x3498, 0x3c80,
    0x2875, 0xc002, 0x3bc2, 0x386b, 0x402e, 0xb446, 0x40a2, 0xb08b,
    0x3ad4, 0xb7bf, 0xbec1, 0xa53b, 0xc01c, 0x4144, 0x3aaa, 0x38d1,
    0x3621, 0x3bbf, 0xb499, 0x3e0e, 0xb5ab, 0x3d63, 0x3994, 0x39d6,
    0x3953, 0xbdb9, 0x3de2, 0xbeba, 0xbeea, 0xc048, 0xbcdd, 0xbf1d,
    0x3ce9, 0xb81c, 0xb8bf, 0x400f, 0x3c5f, 0xbdf2, 0xb970, 0xbaa0,
    0x3995, 0x3c79, 0xc047, 0xb1f3, 0x2f2a, 0x301f, 0x3c12, 0x36e1,
    0xb467, 0x3c52, 0xc000, 0x401c, 0x3a33, 0xb8e8, 0x3bec, 0x3c7a,
    0x3942, 0x3d3e, 0xb823, 0xc00c, 0x3ec7, 0x399f, 0xc066, 0x31c2,
    0x3d00, 0x4057, 0xbbc4, 0x3ce3, 0xbed0, 0x3823, 0x341f, 0xbcea,
    0x3ae7, 0x3f03, 0xb383, 0xbbfb, 0xa63e, 0xa9f0, 0xbeb1, 0x21ff,
    0xb972, 0xa9af, 0xbc77, 0x3778, 0xb601, 0xbd75, 0x38a3, 0xb532,
    0xbc4c, 0xb874, 0xb4db, 0xbe60, 0xbb54, 0xc193, 0x3944, 0x3b0f,
    0x3374, 0x3cda, 0xba76, 0xbebc, 0xbc2e, 0xb8e4, 0xbd09, 0x353d,
    0x39de, 0x347c, 0x3bbc, 0xbc64, 0x2c39, 0xb564, 0x2520, 0xb0fe,
    0xb8bc, 0x2f18, 0xb856, 0xb5ff, 0x3647, 0xba82, 0xbd42, 0x3664,
    0x3dec, 0xbd6e, 0xb9ac, 0xbcfb, 0xbe07, 0xbdbd, 0x36f9, 0xbd7f,
    0xbd2b, 0x3b7a, 0x3797, 0x3e15, 0xb9cd, 0x3d0f, 0xc2b2, 0xbdcf,
    0xbf69, 0xbb12, 0xbe7e, 0xc363, 0x3df0, 0x3d7d, 0x406e, 0xbbaa,
    0x3e15, 0xbdd2, 0xbb47, 0x412a, 0x24d7, 0xbf9f, 0xb9d5, 0xb5c2,
    0x2f2d, 0x326d, 0x3919, 0x3dec, 0xb886, 0x3b72, 0x3839, 0x3a08,
    0xbb03, 0x3e50, 0xbc84, 0x30f3, 0x38f0, 0x3ea6, 0xbab1, 0xbda6,
    0x3ba1, 0x3cc0, 0x3ebd, 0xbb7e, 0x3465, 0xb999, 0xbdaf, 0xc0fe,
    0xbcec, 0x3716, 0x332b, 0xb6f8, 0x3f45, 0xbc39, 0xbc77, 0xb482,
    0xbb50, 0xbc40, 0xb9f2, 0x2984, 0xab84, 0xb1b3, 0xc008, 0x38b1,
    0x3c98, 0xb8fb, 0x3b66, 0x41fd, 0xa81d, 0x3045, 0x3ba2, 0xbccf,
    0x34a9, 0x3e29, 0xb211, 0xba29, 0xc196, 0x3824, 0x384b, 0x3dc9,
    0x3928, 0x378b, 0xbe68, 0xbfda, 0x3a2d, 0xbcd2, 0x2d4b, 0x3965,
    0x2f47, 0x396d, 0x381a, 0x3e0c, 0xb0c1, 0xb30e, 0x3d26, 0x3cea,
    0x3bb6, 0x383a, 0x39f6, 0xb241, 0xb37b, 0xbe22, 0xba48, 0xba9d,
    0x3a16, 0x3f1a, 0x36d3, 0x3b9d, 0x3eac, 0xbf0a, 0xb28e, 0xb5a1,
    0xb697, 0x3d86, 0x3a2d, 0xb135, 0x3d49, 0xbd27, 0xbc52, 0xb1b2,
    0xc0fb, 0xb034, 0xc1f7, 0xb6a5, 0x3c7d, 0x3af0, 0x3389, 0x4136,
    0xb7db, 0xc0c8, 0xb2dd, 0xbf1a, 0x3cc6, 0xb6f6, 0xbabd, 0x313c,
    0x39df, 0xb77a, 0xbcfc, 0x3ab9, 0xae08, 0x3e04, 0x3b50, 0x3b58,
    0xc1a3, 0xbbcb, 0x307e, 0x3abb, 0x2864, 0xaf5d, 0xbcd3, 0x3af9,
    0xbd58, 0x3c85, 0x36f5, 0x9c49, 0xc171, 0x2cf2, 0x3e0f, 0xbf88,
    0xb711, 0xac49, 0xb6c8, 0x2bab, 0x350a, 0x3ee5, 0xb31c, 0x3902,
    0x29e9, 0x3d5d, 0x37f2, 0x3bc7, 0xad1e, 0xc0ea, 0xbccc, 0xbd35,
    0xb77c, 0x410e, 0xaf2c, 0xbf80, 0x34d0, 0x306c, 0x3612, 0x3a90,
    0x3a75, 0xb297, 0xb029, 0xbac0, 0x3cf3, 0x35cb, 0xbbf0, 0x3d6a,
    0xbd06, 0x3871, 0x3610, 0x3c90, 0x2e00, 0x3c27, 0x382f, 0xb779,
    0x343d, 0xbaca, 0x3e84, 0x37b0, 0xb31c, 0x4071, 0xba29, 0x3623,
    0x3c1a, 0xbadc, 0xbf2c, 0xbdae, 0xb8ea, 0x3d08, 0x3a54, 0x3e2a,
    0x382f, 0x28ff, 0x3e90, 0xbd7c, 0xba12, 0x405c, 0x3aa8, 0xb33c,
    0xc030, 0xbf69, 0xb11d, 0x34d6, 0x3cbb, 0xbf45, 0xbc03, 0x3551,
    0x39fc, 0xbc2f, 0xb3f4, 0x3d44, 0x34bf, 0x3016, 0x3c54, 0xbf3d,
    0xbd58, 0x2c6f, 0x3a4d, 0xc072, 0xbd1d, 0x3ca3, 0xbc69, 0x39fa,
    0x3bc5, 0xbbde, 0x310f, 0xb5ec, 0xbb57, 0x38f0, 0xb79a, 0xb100,
    0xace4, 0xbe82, 0x40a4, 0x3ac3, 0x2fb1, 0x32f4, 0x3af0, 0xb9e4,
    0x384a, 0x420a, 0x3599, 0x34c4, 0x3ca8, 0x3bb5, 0x3b6b, 0x38d2,
    0xc344, 0x0, 0x3b6b, 0xb8d2, 0x3ca8, 0xbbb5, 0x3599, 0xb4c4,
    0x384a, 0xc20a, 0x3af0, 0x39e4, 0x2fb1, 0xb2f4, 0x40a4, 0xbac3,
    0xace4, 0x3e82, 0xb79a, 0x3100, 0xbb57, 0xb8f0, 0x310f, 0x35ec,
    0x3bc5, 0x3bde, 0xbc69, 0xb9fa, 0xbd1d, 0xbca3, 0x3a4d, 0x4072,
    0xbd58, 0xac6f, 0x3c54, 0x3f3d, 0x34bf, 0xb016, 0xb3f4, 0xbd44,
    0x39fc, 0x3c2f, 0xbc03, 0xb551, 0x3cbb, 0x3f45, 0xb11d, 0xb4d6,
    0xc030, 0x3f69, 0x3aa8, 0x333c, 0xba12, 0xc05c, 0x3e90, 0x3d7c,
    0x382f, 0xa8ff, 0x3a54, 0xbe2a, 0xb8ea, 0xbd08, 0xbf2c, 0x3dae,
    0x3c1a, 0x3adc, 0xba29, 0xb623, 0xb31c, 0xc071, 0x3e84, 0xb7b0,
    0x343d, 0x3aca, 0x382f, 0x3779, 0x2e00, 0xbc27, 0x3610, 0xbc90,
    0xbd06, 0xb871, 0xbbf0, 0xbd6a, 0x3cf3, 0xb5cb, 0xb029, 0x3ac0,
    0x3a75, 0x3297, 0x3612, 0xba90, 0x34d0, 0xb06c, 0xaf2c, 0x3f80,
    0xb77c, 0xc10e, 0xbccc, 0x3d35, 0xad1e, 0x40ea, 0x37f2, 0xbbc7,
    0x29e9, 0xbd5d, 0xb31c, 0xb902, 0x350a, 0xbee5, 0xb6c8, 0xabab,
    0xb711, 0x2c49, 0x3e0f, 0x3f88, 0xc171, 0xacf2, 0x36f5, 0x1c49,
    0xbd58, 0xbc85, 0xbcd3, 0xbaf9, 0x2864, 0x2f5d, 0x307e, 0xbabb,
    0xc1a3, 0x3bcb, 0x3b50, 0xbb58, 0xae08, 0xbe04, 0xbcfc, 0xbab9,
    0x39df, 0x377a, 0xbabd, 0xb13c, 0x3cc6, 0x36f6, 0xb2dd, 0x3f1a,
    0xb7db, 0x40c8, 0x3389, 0xc136, 0x3c7d, 0xbaf0, 0xc1f7, 0x36a5,
    0xc0fb, 0x3034, 0xbc52, 0x31b2, 0x3d49, 0x3d27, 0x3a2d, 0x3135,
    0xb697, 0xbd86, 0xb28e, 0x35a1, 0x3eac, 0x3f0a, 0x36d3, 0xbb9d,
    0x3a16, 0xbf1a, 0xba48, 0x3a9d, 0xb37b, 0x3e22, 0x39f6, 0x3241,
    0x3bb6, 0xb83a, 0x3d26, 0xbcea, 0xb0c1, 0x330e, 0x381a, 0xbe0c,
    0x2f47, 0xb96d, 0x2d4b, 0xb965, 0x3a2d, 0x3cd2, 0xbe68, 0x3fda,
    0x3928, 0xb78b, 0x384b, 0xbdc9, 0xc196, 0xb824, 0xb211, 0x3a29,
    0x34a9, 0xbe29, 0x3ba2, 0x3ccf, 0xa81d, 0xb045, 0x3b66, 0xc1fd,
    0x3c98, 0x38fb, 0xc008, 0xb8b1, 0xab84, 0x31b3, 0xb9f2, 0xa984,
    0xbb50, 0x3c40, 0xbc77, 0x3482, 0x3f45, 0x3c39, 0x332b, 0x36f8,
    0xbcec, 0xb716, 0xbdaf, 0x40fe, 0x3465, 0x3999, 0x3ebd, 0x3b7e,
    0x3ba1, 0xbcc0, 0xbab1, 0x3da6, 0x38f0, 0xbea6, 0xbc84, 0xb0f3,
    0xbb03, 0xbe50, 0x3839, 0xba08, 0xb886, 0xbb72, 0x3919, 0xbdec,
    0x2f2d, 0xb26d, 0xb9d5, 0x35c2, 0x24d7, 0x3f9f, 0xbb47, 0xc12a,
    0x3e15, 0x3dd2, 0x406e, 0x3baa, 0x3df0, 0xbd7d, 0xbe7e, 0x4363,
    0xbf69, 0x3b12, 0xc2b2, 0x3dcf, 0xb9cd, 0xbd0f, 0x3797, 0xbe15,
    0xbd2b, 0xbb7a, 0x36f9, 0x3d7f, 0xbe07, 0x3dbd, 0xb9ac, 0x3cfb,
    0x3dec, 0x3d6e, 0xbd42, 0xb664, 0x3647, 0x3a82, 0xb856, 0x35ff,
    0xb8bc, 0xaf18, 0x2520, 0x30fe, 0x2c39, 0x3564, 0x3bbc, 0x3c64,
    0x39de, 0xb47c, 0xbd09, 0xb53d, 0xbc2e, 0x38e4, 0xba76, 0x3ebc,
    0x3374, 0xbcda, 0x3944, 0xbb0f, 0xbb54, 0x4193, 0xb4db, 0x3e60,
    0xbc4c, 0x3874, 0x38a3, 0x3532, 0xb601, 0x3d75, 0xbc77, 0xb778,
    0xb972, 0x29af, 0xbeb1, 0xa1ff, 0xa63e, 0x29f0, 0xb383, 0x3bfb,
    0x3ae7, 0xbf03, 0x341f, 0x3cea, 0xbed0, 0xb823, 0xbbc4, 0xbce3,
    0x3d00, 0xc057, 0xc066, 0xb1c2, 0x3ec7, 0xb99f, 0xb823, 0x400c,
    0x3942, 0xbd3e, 0x3bec, 0xbc7a, 0x3a33, 0x38e8, 0xc000, 0xc01c,
    0xb467, 0xbc52, 0x3c12, 0xb6e1, 0x2f2a, 0xb01f, 0xc047, 0x31f3,
    0x3995, 0xbc79, 0xb970, 0x3aa0, 0x3c5f, 0x3df2, 0xb8bf, 0xc00f,
    0x3ce9, 0x381c, 0xbcdd, 0x3f1d, 0xbeea, 0x4048, 0x3de2, 0x3eba,
    0x3953, 0x3db9, 0x3994, 0xb9d6, 0xb5ab, 0xbd63, 0xb499, 0xbe0e,
    0x3621, 0xbbbf, 0x3aaa, 0xb8d1, 0xc01c, 0xc144, 0xbec1, 0x253b,
    0x3ad4, 0x37bf, 0x40a2, 0x308b, 0x402e, 0x3446, 0x3bc2, 0xb86b,
    0x2875, 0x4002, 0x3498, 0xbc80, 0xbec8, 0xa874, 0xc030, 0xbdda,
    0xa537, 0xb860, 0xbb39, 0x3a88, 0x3432, 0xba96, 0xb824, 0xc10e,
    0xbae4, 0x3e08, 0xbd97, 0xb857, 0x387a, 0x383b, 0x394e, 0x3890,
    0xbc0c, 0xb9e6, 0xb8d8, 0xb72c, 0xbaa5, 0x38ca, 0x3b62, 0x3a61,
    0x3e52, 0xac32, 0xbccc, 0xb304, 0x373d, 0x3024, 0x3c20, 0x3154,
    0xbc0a, 0x3ad8, 0xc0d3, 0x3468, 0x3dcd, 0xbcd9, 0x34a9, 0x350a,
    0x3620, 0xc02d, 0xb208, 0x2f30, 0xbd7f, 0x35a8, 0xb9f8, 0xbe31,
    0xbc32, 0x3c5b, 0xbc63, 0x3b99, 0x40ec, 0xc1b7, 0xb66c, 0xc036,
    0xbd34, 0x3690, 0x4027, 0x3d66, 0x346e, 0x2cb6, 0x3c36, 0x40c2,
    0xb56c, 0x2c4b, 0x3bc0, 0x3992, 0xc055, 0x3aa3, 0x3b64, 0xb4db,
    0x3fa0, 0xba32, 0xb575, 0xbcaa, 0x3d05, 0x34fc, 0x396d, 0x35fd,
    0xbdd8, 0x3a88, 0x3a65, 0x3d86, 0x37de, 0x3b36, 0xb60c, 0x31d5,
    0x3908, 0xbcc1, 0xbb4d, 0x33b8, 0xb071, 0xc04f, 0xbce7, 0xbcb5,
    0xbbe3, 0x3c8a, 0xbcea, 0xbaae, 0x39f0, 0xb6d3, 0xbc2d, 0x3406,
    0xbd8f, 0xbd45, 0xb964, 0x33b0, 0xc178, 0xb6bb, 0xbe00, 0xbc96,
    0xb620, 0x3889, 0x341a, 0x346d, 0xbc12, 0x394e, 0x3c78, 0x351a,
    0x3926, 0xbf35, 0xaed7, 0x3d9c, 0x3aea, 0x3958, 0xbff5, 0xb919,
    0x420f, 0xc225, 0x2f36, 0xbc97, 0xbd6a, 0xb1e6, 0xbd13, 0x36c0,
    0xabaf, 0xa593, 0x391b, 0xb7ca, 0x3bfd, 0xbdd6, 0xbdb1, 0x4472,
    0x393c, 0xb486, 0xbc46, 0xbcc3, 0x3fe7, 0xbbfa, 0x34c8, 0xb993,
    0x4172, 0x3969, 0xb9b0, 0xbcca, 0xb141, 0x3809, 0xbeab, 0xbe1f,
    0xbc3d, 0xb844, 0x3c30, 0x36e6, 0x344b, 0xbb67, 0xb8c0, 0x3949,
    0xb87c, 0xbe4b, 0x3c2e, 0xbfb4, 0x353a, 0x3843, 0xae1f, 0xa200,
    0xbe59, 0x3570, 0xb9ab, 0xbcdc, 0x3890, 0xb9c1, 0xb1f1, 0x32b9,
    0xb680, 0xbb8a, 0x3a18, 0x353a, 0x3e44, 0x2e48, 0xb950, 0xb8d8,
    0xbaf7, 0x3cbd, 0x3001, 0xbca9, 0xb838, 0xb976, 0xb758, 0x2bcb,
    0xbc0d, 0xb9f6, 0x4092, 0x3832, 0x38a9, 0x4029, 0xb8d1, 0xb164,
    0x3777, 0xbc84, 0x3b0a, 0x3bc7, 0xba6e, 0xc0b4, 0x2506, 0xaf93,
    0x1fa8, 0x40f7, 0x3cb7, 0x4118, 0xb995, 0x4189, 0x3cb4, 0x3796,
    0x3a0f, 0x3a1a, 0xb9f0, 0xb022, 0xbfdd, 0x3298, 0x3992, 0xbc01,
    0x3c57, 0x3468, 0xbcfb, 0xb119, 0x3d74, 0xb8b3, 0x3d97, 0xba1a,
    0x3810, 0xc401, 0xadbf, 0x9eb8, 0x3bfb, 0x3844, 0xaf7a, 0x412d,
    0x3c3e, 0x35a7, 0xadb4, 0x3d7a, 0x3f62, 0x3fc0, 0x3786, 0x313d,
    0x31d6, 0xb39d, 0x3941, 0x3b7f, 0x39ba, 0xc030, 0xb84f, 0xb73b,
    0x311f, 0xbf25, 0xb7fe, 0x38a0, 0xbb6b, 0x41d7, 0xc0e0, 0xb8f8,
    0x39fd, 0xa882, 0xc05f, 0xb1eb, 0x2f17, 0x3f39, 0xbc43, 0x3b00,
    0xb4fe, 0x3d27, 0xbde8, 0x3911, 0x3d6e, 0x3c2d, 0x3b3a, 0x351e,
    0x3cea, 0x3af6, 0x3e9f, 0x3edd, 0xbd1a, 0xbe2a, 0xba2f, 0xbe66,
    0xc0c0, 0x3f01, 0xbdf3, 0x2e3e, 0x3d18, 0xb0b3, 0xabbf, 0x3c30,
    0x3c58, 0xbd61, 0x3c04, 0xb995, 0xbb7e, 0x400d, 0xaa41, 0x3788,
    0x3bed, 0x3c7c, 0x399e, 0xb555, 0xb3d2, 0xc047, 0xb54a, 0x3808,
    0xb997, 0xb9d3, 0xbd78, 0x38e3, 0xb53b, 0x3629, 0x3bf8, 0x3aec,
    0xb436, 0xa915, 0x3e25, 0xb5b9, 0xb84d, 0x3950, 0xbe98, 0x3d38,
    0x3a01, 0x35f8, 0x3acd, 0xbfee, 0x387e, 0x2fc7, 0x333b, 0xbd45,
    0xb635, 0xb142, 0xb697, 0x38db, 0xba22, 0xc07d, 0x3cbc, 0xa880,
    0x31a7, 0xba3b, 0xc047, 0xc142, 0x2e9b, 0xbc24, 0x3339, 0x3ee8,
    0x3daa, 0x5d97, 0x3b6c, 0xb0d8, 0xb332, 0x36fa, 0x311c, 0x34c8,
    0xb4c4, 0x3bb5, 0x3fd8, 0x3c6c, 0x340b, 0x4005, 0x3ed6, 0x323d,
    0x3be2, 0xbdf8, 0xc00b, 0xb150, 0xbd62, 0xb464, 0x4084, 0x39a8,
    0x2131, 0xbf9c, 0xbe25, 0x3a2b, 0x36e2, 0xbcc7, 0xb803, 0xacfb,
    0xb8ae, 0xaff1, 0x3c86, 0xba95, 0x3bbb, 0xbc0c, 0xb705, 0xb201,
    0x3d41, 0xbe03, 0x39c6, 0xbcd0, 0xb123, 0x3c79, 0xb45c, 0x3a8c,
    0xb803, 0x36ed, 0x393b, 0xbc18, 0xc0de, 0xb8e7, 0x3b9a, 0xafbe,
    0x28eb, 0x2b95, 0x3d5a, 0x3c83, 0x3892, 0x4048, 0x3be6, 0x3750,
    0xc2a5, 0x4107, 0x3b1f, 0x3e0d, 0x2e0a, 0xb894, 0xbd34, 0x34ce,
    0x404d, 0xbd1b, 0xbe14, 0xb6a9, 0xb80b, 0x3cf1, 0x3509, 0xb51c,
    0xb49a, 0xb435, 0xba97, 0x3911, 0x3a96, 0xbe2b, 0x3415, 0xbe04,
    0xba57, 0x4200, 0x36c6, 0x37a7, 0x3fca, 0x34ab, 0xc0d2, 0x3e51,
    0x40c0, 0x39ce, 0x3a90, 0x379b, 0xb482, 0x31d3, 0x35be, 0x3590,
    0xbc4f, 0xb2b1, 0x3501, 0xba46, 0x3c57, 0x3ea1, 0xbdd8, 0x338d,
    0x3a11, 0xbc19, 0x3acc, 0x351a, 0xb9f3, 0xbca5, 0xbc62, 0x3ec8,
    0xba5b, 0xb994, 0x2312, 0xbcbc, 0x3985, 0x3d6e, 0xbbf7, 0x3f6b,
    0x3024, 0xb919, 0xbd9c, 0xbafd, 0xb9f1, 0x2924, 0xb802, 0xc20b,
    0x3f0d, 0xbc87, 0x3631, 0x3a1b, 0x3534, 0x3d28, 0x33de, 0x3237,
    0xbe82, 0x3b0d, 0x3ac9, 0x3d80, 0x400d, 0xb91d, 0x3fa3, 0xb398,
    0x3a14, 0xbb29, 0xa6fe, 0x3bb0, 0xba1c, 0x3eb5, 0xbf59, 0x3b62,
    0x39c8, 0xbbe9, 0xbdb3, 0x3b35, 0xb52f, 0xb80a, 0xbab7, 0xb3dc,
    0x3f08, 0xc095, 0x3692, 0x3848, 0x3e80, 0x3d23, 0xba93, 0xb8cc,
    0xb691, 0x36d2, 0x40ec, 0xbe99, 0xbc2a, 0x3a05, 0xbe44, 0xbd13,
    0xb973, 0x3840, 0x3fb6, 0x384a, 0xb98a, 0x3975, 0x2cba, 0x2e79,
    0x3e13, 0x41b3, 0xa386, 0x4013, 0xbaf2, 0xbcf6, 0x3e1b, 0xbd65,
    0xc213, 0xba19, 0x3a15, 0xbc57, 0xbd0a, 0x3e85, 0x3ba7, 0xb504,
    0xb91d, 0x2ea4, 0x43f4, 0x364e, 0x3d91, 0x4286, 0x3173, 0x379d,
    0x36f7, 0xb3e4, 0x2c3e, 0xb8f1, 0xb913, 0xc120, 0xba55, 0xb265,
    0xad20, 0xbd21, 0x3595, 0xb5aa, 0x3e3f, 0x337d, 0xb7f5, 0x24dc,
    0x3c4d, 0x3fb7, 0x3942, 0x37ab, 0xbafa, 0x2e0c, 0xbe5a, 0xb9f7,
    0xbc2d, 0x3dbf, 0xb657, 0xb89f, 0x3f8d, 0xb885, 0x2f1a, 0xb950,
    0x3a1e, 0x3555, 0xb931, 0xa99f, 0xbc06, 0xbab1, 0x3e9d, 0x374e
    };

static const uint16_t in_cfft_noisy_2048[4096] = {
    0x24a5, 0x0, 0x37d8, 0x0, 0x39c4, 0x0, 0x370b, 0x0,
    0x2685, 0x0, 0xb6a8, 0x0, 0xb990, 0x0, 0xb791, 0x0,
    0x2b73, 0x0, 0x3809, 0x0, 0x397b, 0x0, 0x376d, 0x0,
    0xa239, 0x0, 0xb847, 0x0, 0xb9da, 0x0, 0xb725, 0x0,
    0x8c78, 0x0, 0x37a6, 0x0, 0x3954, 0x0, 0x3822, 0x0,
    0xaa3f, 0x0, 0xb669, 0x0, 0xb933, 0x0, 0xb83b, 0x0,
    0xa4d1, 0x0, 0x381b, 0x0, 0x395f, 0x0, 0x387d, 0x0,
    0x18a3, 0x0, 0xb84b, 0x0, 0xb982, 0x0, 0xb8b2, 0x0,
    0x2417, 0x0, 0x3801, 0x0, 0x399d, 0x0, 0x37e3, 0x0,
    0x2df7, 0x0, 0xb80a, 0x0, 0xb9df, 0x0, 0xb829, 0x0,
    0xa9d5, 0x0, 0x381b, 0x0, 0x3910, 0x0, 0x3838, 0x0,
    0xaa9c, 0x0, 0xb79e, 0x0, 0xb9ab, 0x0, 0xb701, 0x0,
    0x2449, 0x0, 0x38dd, 0x0, 0x39f9, 0x0, 0x36f4, 0x0,
    0x27b2, 0x0, 0xb828, 0x0, 0xb9d9, 0x0, 0xb7e7, 0x0,
    0xadca, 0x0, 0x383a, 0x0, 0x3934, 0x0, 0x38ce, 0x0,
    0x2dcf, 0x0, 0xb7ea, 0x0, 0xb99b, 0x0, 0xb6aa, 0x0,
    0xa149, 0x0, 0x3837, 0x0, 0x3943, 0x0, 0x3870, 0x0,
    0xaaf6, 0x0, 0xb6fd, 0x0, 0xb92b, 0x0, 0xb8a5, 0x0,
    0x29a9, 0x0, 0x36ab, 0x0, 0x39a0, 0x0, 0x371e, 0x0,
    0xb02b, 0x0, 0xb7bd, 0x0, 0xb9bc, 0x0, 0xb76f, 0x0,
    0xa774, 0x0, 0x373a, 0x0, 0x399f, 0x0, 0x3660, 0x0,
    0x2b2e, 0x0, 0xb795, 0x0, 0xb937, 0x0, 0xb792, 0x0,
    0x28b0, 0x0, 0x37af, 0x0, 0x39ef, 0x0, 0x3814, 0x0,
    0x2d5f, 0x0, 0xb87c, 0x0, 0xb954, 0x0, 0xb7cf, 0x0,
    0x210b, 0x0, 0x3770, 0x0, 0x39fe, 0x0, 0x3617, 0x0,
    0xa919, 0x0, 0xb7cd, 0x0, 0xb97f, 0x0, 0xb882, 0x0,
    0x2d33, 0x0, 0x3832, 0x0, 0x3924, 0x0, 0x3850, 0x0,
    0x288f, 0x0, 0xb75f, 0x0, 0xb9ab, 0x0, 0xb71d, 0x0,
    0xa270, 0x0, 0x3864, 0x0, 0x3991, 0x0, 0x38b7, 0x0,
    0x23ed, 0x0, 0xb78f, 0x0, 0xba0f, 0x0, 0xb778, 0x0,
    0xa4da, 0x0, 0x377f, 0x0, 0x3a61, 0x0, 0x37f1, 0x0,
    0x10ae, 0x0, 0xb837, 0x0, 0xb9c8, 0x0, 0xb7f5, 0x0,
    0xa14e, 0x0, 0x376e, 0x0, 0x3959, 0x0, 0x3873, 0x0,
    0x2585, 0x0, 0xb735, 0x0, 0xba04, 0x0, 0xb785, 0x0,
    0xb141, 0x0, 0x37b0, 0x0, 0x3a12, 0x0, 0x381e, 0x0,
    0x299f, 0x0, 0xb8c9, 0x0, 0xb9fe, 0x0, 0xb882, 0x0,
    0xa8ec, 0x0, 0x3657, 0x0, 0x3926, 0x0, 0x3843, 0x0,
    0x2640, 0x0, 0xb85d, 0x0, 0xb962, 0x0, 0xb73d, 0x0,
    0x9d09, 0x0, 0x3882, 0x0, 0x3987, 0x0, 0x383b, 0x0,
    0xa8a6, 0x0, 0xb70b, 0x0, 0xb9a5, 0x0, 0xb840, 0x0,
    0xa71c, 0x0, 0x360c, 0x0, 0x3948, 0x0, 0x36c0, 0x0,
    0x2d12, 0x0, 0xb746, 0x0, 0xb8fd, 0x0, 0xb884, 0x0,
    0xac82, 0x0, 0x37b8, 0x0, 0x3960, 0x0, 0x375b, 0x0,
    0xa69b, 0x0, 0xb892, 0x0, 0xb939, 0x0, 0xb7f7, 0x0,
    0xa421, 0x0, 0x36b9, 0x0, 0x3997, 0x0, 0x3737, 0x0,
    0x2fb3, 0x0, 0xb816, 0x0, 0xb968, 0x0, 0xb7cb, 0x0,
    0xa173, 0x0, 0x3784, 0x0, 0x398b, 0x0, 0x385c, 0x0,
    0x9ce3, 0x0, 0xb862, 0x0, 0xb8a8, 0x0, 0xb867, 0x0,
    0xaabb, 0x0, 0x387e, 0x0, 0x38f7, 0x0, 0x3813, 0x0,
    0xa00d, 0x0, 0xb7f0, 0x0, 0xb8f2, 0x0, 0xb891, 0x0,
    0xaac3, 0x0, 0x3854, 0x0, 0x3985, 0x0, 0x3761, 0x0,
    0x2f00, 0x0, 0xb81b, 0x0, 0xb98d, 0x0, 0xb822, 0x0,
    0xa613, 0x0, 0x3662, 0x0, 0x3968, 0x0, 0x3733, 0x0,
    0x2a41, 0x0, 0xb840, 0x0, 0xba21, 0x0, 0xb70e, 0x0,
    0xa38c, 0x0, 0x3638, 0x0, 0x39d5, 0x0, 0x389f, 0x0,
    0xa0c4, 0x0, 0xb779, 0x0, 0xb9cf, 0x0, 0xb87e, 0x0,
    0xadb4, 0x0, 0x37a4, 0x0, 0x3960, 0x0, 0x3818, 0x0,
    0x243e, 0x0, 0xb768, 0x0, 0xb91a, 0x0, 0xb6c9, 0x0,
    0x29c5, 0x0, 0x36ca, 0x0, 0x38cc, 0x0, 0x38a4, 0x0,
    0x2a96, 0x0, 0xb79a, 0x0, 0xb97d, 0x0, 0xb7db, 0x0,
    0x2142, 0x0, 0x3739, 0x0, 0x3936, 0x0, 0x383f, 0x0,
    0x9907, 0x0, 0xb7aa, 0x0, 0xb9e3, 0x0, 0xb8a1, 0x0,
    0xaa8e, 0x0, 0x35d9, 0x0, 0x3949, 0x0, 0x3838, 0x0,
    0x9f72, 0x0, 0xb815, 0x0, 0xba04, 0x0, 0xb737, 0x0,
    0xa8f8, 0x0, 0x3758, 0x0, 0x3922, 0x0, 0x386f, 0x0,
    0xa949, 0x0, 0xb88a, 0x0, 0xb9f1, 0x0, 0xb80f, 0x0,
    0xa3f2, 0x0, 0x3748, 0x0, 0x38c2, 0x0, 0x3849, 0x0,
    0x2802, 0x0, 0xb796, 0x0, 0xb9fa, 0x0, 0xb868, 0x0,
    0x2762, 0x0, 0x379d, 0x0, 0x394a, 0x0, 0x3709, 0x0,
    0xac8e, 0x0, 0xb801, 0x0, 0xba66, 0x0, 0xb704, 0x0,
    0x234a, 0x0, 0x37d5, 0x0, 0x3a08, 0x0, 0x38da, 0x0,
    0xa937, 0x0, 0xb758, 0x0, 0xb9cb, 0x0, 0xb72f, 0x0,
    0x2a1c, 0x0, 0x37ce, 0x0, 0x3a15, 0x0, 0x3828, 0x0,
    0xa66f, 0x0, 0xb7d1, 0x0, 0xb9e7, 0x0, 0xb92e, 0x0,
    0x8e3b, 0x0, 0x387b, 0x0, 0x38be, 0x0, 0x3774, 0x0,
    0x2ca8, 0x0, 0xb80e, 0x0, 0xb9a5, 0x0, 0xb7fa, 0x0,
    0x2916, 0x0, 0x3896, 0x0, 0x399c, 0x0, 0x386f, 0x0,
    0xa6f1, 0x0, 0xb6fa, 0x0, 0xb928, 0x0, 0xb86a, 0x0,
    0x24a7, 0x0, 0x382e, 0x0, 0x3a06, 0x0, 0x37a4, 0x0,
    0x2c83, 0x0, 0xb758, 0x0, 0xb929, 0x0, 0xb7cd, 0x0,
    0x9d83, 0x0, 0x37e7, 0x0, 0x399f, 0x0, 0x3702, 0x0,
    0x115b, 0x0, 0xb839, 0x0, 0xb9c7, 0x0, 0xb72b, 0x0,
    0xa4a8, 0x0, 0x38f7, 0x0, 0x3926, 0x0, 0x3832, 0x0,
    0xa5e7, 0x0, 0xb7a6, 0x0, 0xb9d9, 0x0, 0xb870, 0x0,
    0x1fb3, 0x0, 0x37a3, 0x0, 0x3944, 0x0, 0x378e, 0x0,
    0xad46, 0x0, 0xb8cd, 0x0, 0xb989, 0x0, 0xb85e, 0x0,
    0x2625, 0x0, 0x362a, 0x0, 0x39f7, 0x0, 0x3848, 0x0,
    0x9e6e, 0x0, 0xb763, 0x0, 0xb9e9, 0x0, 0xb7c1, 0x0,
    0x2958, 0x0, 0x3790, 0x0, 0x3a5c, 0x0, 0x375b, 0x0,
    0x2af6, 0x0, 0xb786, 0x0, 0xb90e, 0x0, 0xb846, 0x0,
    0xaba0, 0x0, 0x387e, 0x0, 0x39ae, 0x0, 0x37d4, 0x0,
    0xa6cd, 0x0, 0xb865, 0x0, 0xb9be, 0x0, 0xb615, 0x0,
    0xaf7b, 0x0, 0x3666, 0x0, 0x3aac, 0x0, 0x386e, 0x0,
    0x2c0b, 0x0, 0xb814, 0x0, 0xb96e, 0x0, 0xb866, 0x0,
    0x2c4c, 0x0, 0x374a, 0x0, 0x39bc, 0x0, 0x3747, 0x0,
    0xad4c, 0x0, 0xb766, 0x0, 0xb9d1, 0x0, 0xb811, 0x0,
    0xa24d, 0x0, 0x358a, 0x0, 0x39ba, 0x0, 0x36ef, 0x0,
    0x2ed1, 0x0, 0xb82b, 0x0, 0xb959, 0x0, 0xb8c5, 0x0,
    0x2b0e, 0x0, 0x3814, 0x0, 0x395e, 0x0, 0x3734, 0x0,
    0x2243, 0x0, 0xb8aa, 0x0, 0xba12, 0x0, 0xb6d4, 0x0,
    0x285d, 0x0, 0x37ca, 0x0, 0x395b, 0x0, 0x3806, 0x0,
    0x293c, 0x0, 0xb802, 0x0, 0xb928, 0x0, 0xb81d, 0x0,
    0x2f6b, 0x0, 0x3825, 0x0, 0x39b9, 0x0, 0x3821, 0x0,
    0x2b6f, 0x0, 0xb783, 0x0, 0xb9d6, 0x0, 0xb870, 0x0,
    0x1913, 0x0, 0x3854, 0x0, 0x3992, 0x0, 0x370e, 0x0,
    0x2022, 0x0, 0xb868, 0x0, 0xb988, 0x0, 0xb805, 0x0,
    0x9e8c, 0x0, 0x378d, 0x0, 0x39ea, 0x0, 0x382f, 0x0,
    0xaece, 0x0, 0xb7e6, 0x0, 0xb94f, 0x0, 0xb7f0, 0x0,
    0x29f3, 0x0, 0x37c9, 0x0, 0x39da, 0x0, 0x3726, 0x0,
    0x2365, 0x0, 0xb87c, 0x0, 0xb904, 0x0, 0xb853, 0x0,
    0x251b, 0x0, 0x36c3, 0x0, 0x38e7, 0x0, 0x36e4, 0x0,
    0x23a4, 0x0, 0xb86f, 0x0, 0xb9df, 0x0, 0xb88b, 0x0,
    0x2a1d, 0x0, 0x385d, 0x0, 0x3967, 0x0, 0x371e, 0x0,
    0x1e6b, 0x0, 0xb69a, 0x0, 0xb9b7, 0x0, 0xb835, 0x0,
    0x9aed, 0x0, 0x371d, 0x0, 0x3988, 0x0, 0x371b, 0x0,
    0xac6c, 0x0, 0xb8ad, 0x0, 0xb996, 0x0, 0xb6da, 0x0,
    0xaa24, 0x0, 0x35fd, 0x0, 0x3960, 0x0, 0x36f2, 0x0,
    0x2a89, 0x0, 0xb7d0, 0x0, 0xb95b, 0x0, 0xb7d5, 0x0,
    0x28eb, 0x0, 0x37c4, 0x0, 0x3983, 0x0, 0x3845, 0x0,
    0x2bae, 0x0, 0xb825, 0x0, 0xba6b, 0x0, 0xb6b4, 0x0,
    0x2b12, 0x0, 0x36e1, 0x0, 0x3916, 0x0, 0x3829, 0x0,
    0xab29, 0x0, 0xb735, 0x0, 0xb9a4, 0x0, 0xb848, 0x0,
    0xa04c, 0x0, 0x3784, 0x0, 0x3935, 0x0, 0x3836, 0x0,
    0x9df2, 0x0, 0xb7be, 0x0, 0xb981, 0x0, 0xb762, 0x0,
    0xa5af, 0x0, 0x38b8, 0x0, 0x395a, 0x0, 0x36f0, 0x0,
    0x2e8e, 0x0, 0xb7bb, 0x0, 0xb9d3, 0x0, 0xb7f5, 0x0,
    0x2964, 0x0, 0x3869, 0x0, 0x398c, 0x0, 0x387e, 0x0,
    0x29ee, 0x0, 0xb70b, 0x0, 0xb98f, 0x0, 0xb723, 0x0,
    0xa69d, 0x0, 0x386a, 0x0, 0x386f, 0x0, 0x375f, 0x0,
    0xaa08, 0x0, 0xb88a, 0x0, 0xb9cb, 0x0, 0xb876, 0x0,
    0xaaa3, 0x0, 0x36ff, 0x0, 0x39df, 0x0, 0x3748, 0x0,
    0xaccf, 0x0, 0xb809, 0x0, 0xb957, 0x0, 0xb81d, 0x0,
    0xa907, 0x0, 0x3873, 0x0, 0x3932, 0x0, 0x37a6, 0x0,
    0x21bb, 0x0, 0xb5fe, 0x0, 0xb988, 0x0, 0xb7da, 0x0,
    0xa165, 0x0, 0x36be, 0x0, 0x3a05, 0x0, 0x37e8, 0x0,
    0x285f, 0x0, 0xb86b, 0x0, 0xb9c1, 0x0, 0xb87b, 0x0,
    0xa554, 0x0, 0x3780, 0x0, 0x3903, 0x0, 0x386c, 0x0,
    0xaac6, 0x0, 0xb5c9, 0x0, 0xba10, 0x0, 0xb7d6, 0x0,
    0xa577, 0x0, 0x3706, 0x0, 0x3a3e, 0x0, 0x383f, 0x0,
    0xa6ac, 0x0, 0xb859, 0x0, 0xb9fb, 0x0, 0xb79f, 0x0,
    0x260d, 0x0, 0x3731, 0x0, 0x392e, 0x0, 0x3794, 0x0,
    0xac35, 0x0, 0xb8e8, 0x0, 0xb95b, 0x0, 0xb788, 0x0,
    0xa5d4, 0x0, 0x379d, 0x0, 0x3906, 0x0, 0x36d2, 0x0,
    0x1dab, 0x0, 0xb8fd, 0x0, 0xb91c, 0x0, 0xb817, 0x0,
    0x21e1, 0x0, 0x3837, 0x0, 0x399d, 0x0, 0x3747, 0x0,
    0xa422, 0x0, 0xb79a, 0x0, 0xb984, 0x0, 0xb833, 0x0,
    0x1a10, 0x0, 0x37c9, 0x0, 0x3993, 0x0, 0x36f0, 0x0,
    0xab01, 0x0, 0xb876, 0x0, 0xb9c1, 0x0, 0xb867, 0x0,
    0xa79a, 0x0, 0x37bb, 0x0, 0x392b, 0x0, 0x3802, 0x0,
    0x2ce2, 0x0, 0xb93c, 0x0, 0xba0a, 0x0, 0xb7bd, 0x0,
    0xa857, 0x0, 0x38d2, 0x0, 0x3a83, 0x0, 0x37bd, 0x0,
    0xa396, 0x0, 0xb728, 0x0, 0xb99f, 0x0, 0xb635, 0x0,
    0x2c82, 0x0, 0x381a, 0x0, 0x396b, 0x0, 0x37f8, 0x0,
    0x24d6, 0x0, 0xb721, 0x0, 0xb8f5, 0x0, 0xb81d, 0x0,
    0x2c6b, 0x0, 0x382d, 0x0, 0x3990, 0x0, 0x386a, 0x0,
    0x9eee, 0x0, 0xb89c, 0x0, 0xb9bf, 0x0, 0xb881, 0x0,
    0x2ad4, 0x0, 0x382c, 0x0, 0x396b, 0x0, 0x384d, 0x0,
    0xaf72, 0x0, 0xb85e, 0x0, 0xb9b5, 0x0, 0xb71f, 0x0,
    0x2876, 0x0, 0x37cf, 0x0, 0x39ad, 0x0, 0x361c, 0x0,
    0x255f, 0x0, 0xb722, 0x0, 0xb9b4, 0x0, 0xb855, 0x0,
    0x1981, 0x0, 0x3828, 0x0, 0x396b, 0x0, 0x379f, 0x0,
    0xa20a, 0x0, 0xb841, 0x0, 0xb9ef, 0x0, 0xb636, 0x0,
    0xa3b5, 0x0, 0x37b5, 0x0, 0x3944, 0x0, 0x38a1, 0x0,
    0xa20a, 0x0, 0xb79a, 0x0, 0xba5a, 0x0, 0xb6df, 0x0,
    0xa65c, 0x0, 0x380b, 0x0, 0x394d, 0x0, 0x36bf, 0x0,
    0xae36, 0x0, 0xb823, 0x0, 0xb9c8, 0x0, 0xb6e2, 0x0,
    0xa8b1, 0x0, 0x3846, 0x0, 0x38f6, 0x0, 0x370f, 0x0,
    0x2301, 0x0, 0xb813, 0x0, 0xba07, 0x0, 0xb6e9, 0x0,
    0xa543, 0x0, 0x383e, 0x0, 0x3966, 0x0, 0x37c7, 0x0,
    0x2070, 0x0, 0xb823, 0x0, 0xb946, 0x0, 0xb83c, 0x0,
    0x29b3, 0x0, 0x3756, 0x0, 0x38a7, 0x0, 0x37c3, 0x0,
    0x2609, 0x0, 0xb7f7, 0x0, 0xba09, 0x0, 0xb829, 0x0,
    0xabd0, 0x0, 0x3724, 0x0, 0x39a6, 0x0, 0x387c, 0x0,
    0xa631, 0x0, 0xb870, 0x0, 0xb9e7, 0x0, 0xb7c2, 0x0,
    0x2cdf, 0x0, 0x37d2, 0x0, 0x39cc, 0x0, 0x3802, 0x0,
    0xa475, 0x0, 0xb78a, 0x0, 0xb99e, 0x0, 0xb658, 0x0,
    0x1453, 0x0, 0x3834, 0x0, 0x392d, 0x0, 0x3721, 0x0,
    0xaed6, 0x0, 0xb848, 0x0, 0xba08, 0x0, 0xb7b8, 0x0,
    0xae31, 0x0, 0x377a, 0x0, 0x39cf, 0x0, 0x38c2, 0x0,
    0xa3c7, 0x0, 0xb7ee, 0x0, 0xb997, 0x0, 0xb75b, 0x0,
    0xa9fd, 0x0, 0x3702, 0x0, 0x39bf, 0x0, 0x3811, 0x0,
    0x299c, 0x0, 0xb72d, 0x0, 0xb9a2, 0x0, 0xb87f, 0x0,
    0x20e8, 0x0, 0x36b5, 0x0, 0x3972, 0x0, 0x385d, 0x0,
    0xabe5, 0x0, 0xb83c, 0x0, 0xb94d, 0x0, 0xb850, 0x0,
    0x28ac, 0x0, 0x380a, 0x0, 0x39f7, 0x0, 0x37c7, 0x0,
    0x20dc, 0x0, 0xb851, 0x0, 0xb9fd, 0x0, 0xb7a5, 0x0,
    0xa6ea, 0x0, 0x380a, 0x0, 0x39bd, 0x0, 0x3802, 0x0,
    0xa5a4, 0x0, 0xb79a, 0x0, 0xb976, 0x0, 0xb7ca, 0x0,
    0x2ddd, 0x0, 0x3854, 0x0, 0x3984, 0x0, 0x37e4, 0x0,
    0xa25c, 0x0, 0xb7b9, 0x0, 0xb90d, 0x0, 0xb825, 0x0,
    0x27a7, 0x0, 0x37f9, 0x0, 0x39db, 0x0, 0x3829, 0x0,
    0x2958, 0x0, 0xb80f, 0x0, 0xba7d, 0x0, 0xb750, 0x0,
    0x2d2e, 0x0, 0x36d6, 0x0, 0x3981, 0x0, 0x37d1, 0x0,
    0x9e9e, 0x0, 0xb77d, 0x0, 0xb944, 0x0, 0xb833, 0x0,
    0xa20e, 0x0, 0x3838, 0x0, 0x3960, 0x0, 0x37f0, 0x0,
    0x2d5b, 0x0, 0xb7eb, 0x0, 0xb955, 0x0, 0xb79d, 0x0,
    0x140e, 0x0, 0x380f, 0x0, 0x3965, 0x0, 0x3650, 0x0,
    0xa847, 0x0, 0xb844, 0x0, 0xba0d, 0x0, 0xb7a0, 0x0,
    0xa285, 0x0, 0x3878, 0x0, 0x38d4, 0x0, 0x37fc, 0x0,
    0x17c9, 0x0, 0xb718, 0x0, 0xb9d0, 0x0, 0xb848, 0x0,
    0x2adc, 0x0, 0x372c, 0x0, 0x396b, 0x0, 0x373d, 0x0,
    0xacf8, 0x0, 0xb701, 0x0, 0xb91c, 0x0, 0xb81b, 0x0,
    0xa916, 0x0, 0x37a1, 0x0, 0x3991, 0x0, 0x38cd, 0x0,
    0x2c0d, 0x0, 0xb738, 0x0, 0xb8c3, 0x0, 0xb881, 0x0,
    0xab7a, 0x0, 0x37a0, 0x0, 0x396a, 0x0, 0x36cc, 0x0,
    0x21da, 0x0, 0xb830, 0x0, 0xb961, 0x0, 0xb7f1, 0x0,
    0x20bf, 0x0, 0x37fa, 0x0, 0x39ee, 0x0, 0x373d, 0x0,
    0xa66e, 0x0, 0xb7cf, 0x0, 0xb9b1, 0x0, 0xb809, 0x0,
    0xab01, 0x0, 0x3833, 0x0, 0x396f, 0x0, 0x366a, 0x0,
    0x2a43, 0x0, 0xb821, 0x0, 0xb9c6, 0x0, 0xb880, 0x0,
    0xae0a, 0x0, 0x3817, 0x0, 0x3923, 0x0, 0x3801, 0x0,
    0x286b, 0x0, 0xb7c1, 0x0, 0xb9c7, 0x0, 0xb7b5, 0x0,
    0x2707, 0x0, 0x38c5, 0x0, 0x3995, 0x0, 0x3860, 0x0,
    0x21da, 0x0, 0xb809, 0x0, 0xb981, 0x0, 0xb836, 0x0,
    0x2848, 0x0, 0x37ec, 0x0, 0x3a0f, 0x0, 0x3744, 0x0,
    0x2683, 0x0, 0xb806, 0x0, 0xba6c, 0x0, 0xb849, 0x0,
    0x2f7f, 0x0, 0x374a, 0x0, 0x3924, 0x0, 0x369d, 0x0,
    0x2c0e, 0x0, 0xb82e, 0x0, 0xba48, 0x0, 0xb7ce, 0x0,
    0xa982, 0x0, 0x376e, 0x0, 0x398a, 0x0, 0x3707, 0x0,
    0x9d27, 0x0, 0xb8a3, 0x0, 0xb9db, 0x0, 0xb815, 0x0,
    0x2275, 0x0, 0x37df, 0x0, 0x39db, 0x0, 0x379d, 0x0,
    0xa6ea, 0x0, 0xb863, 0x0, 0xb92d, 0x0, 0xb863, 0x0,
    0xb019, 0x0, 0x3858, 0x0, 0x3a58, 0x0, 0x37fc, 0x0,
    0xa30f, 0x0, 0xb6ee, 0x0, 0xb8e8, 0x0, 0xb826, 0x0,
    0x2d47, 0x0, 0x377b, 0x0, 0x39ac, 0x0, 0x3868, 0x0,
    0x2bc4, 0x0, 0xb7a8, 0x0, 0xba29, 0x0, 0xb709, 0x0,
    0x137e, 0x0, 0x3843, 0x0, 0x3a02, 0x0, 0x3859, 0x0,
    0xad56, 0x0, 0xb83c, 0x0, 0xb9a4, 0x0, 0xb825, 0x0,
    0xab0f, 0x0, 0x3706, 0x0, 0x39fc, 0x0, 0x3821, 0x0,
    0xa857, 0x0, 0xb8e9, 0x0, 0xb9f4, 0x0, 0xb6b7, 0x0,
    0xab9c, 0x0, 0x3825, 0x0, 0x38c6, 0x0, 0x3704, 0x0,
    0xa3a4, 0x0, 0xb74b, 0x0, 0xba96, 0x0, 0xb714, 0x0,
    0x94f0, 0x0, 0x3816, 0x0, 0x38f9, 0x0, 0x37ba, 0x0,
    0xac7e, 0x0, 0xb874, 0x0, 0xb8c2, 0x0, 0xb679, 0x0,
    0x2dbb, 0x0, 0x3812, 0x0, 0x39d4, 0x0, 0x3832, 0x0,
    0x9ff7, 0x0, 0xb71b, 0x0, 0xba6f, 0x0, 0xb71b, 0x0,
    0xa825, 0x0, 0x38af, 0x0, 0x39df, 0x0, 0x3847, 0x0,
    0xac47, 0x0, 0xb873, 0x0, 0xb9dd, 0x0, 0xb7b6, 0x0,
    0x3092, 0x0, 0x3816, 0x0, 0x3963, 0x0, 0x3759, 0x0,
    0x1fd2, 0x0, 0xb656, 0x0, 0xba35, 0x0, 0xb83f, 0x0,
    0x2541, 0x0, 0x387e, 0x0, 0x392c, 0x0, 0x371b, 0x0,
    0xa715, 0x0, 0xb780, 0x0, 0xba07, 0x0, 0xb761, 0x0,
    0x2ca6, 0x0, 0x3874, 0x0, 0x398a, 0x0, 0x36c2, 0x0,
    0x9590, 0x0, 0xb77c, 0x0, 0xb962, 0x0, 0xb7a4, 0x0,
    0xa420, 0x0, 0x3644, 0x0, 0x3979, 0x0, 0x3864, 0x0,
    0x9a8f, 0x0, 0xb822, 0x0, 0xb96d, 0x0, 0xb838, 0x0,
    0x2ed0, 0x0, 0x3895, 0x0, 0x39bb, 0x0, 0x3846, 0x0,
    0x219f, 0x0, 0xb6df, 0x0, 0xb971, 0x0, 0xb692, 0x0,
    0x2b23, 0x0, 0x389f, 0x0, 0x39b5, 0x0, 0x36d5, 0x0,
    0x304a, 0x0, 0xb85a, 0x0, 0xb94a, 0x0, 0xb7ed, 0x0,
    0xa4ef, 0x0, 0x3827, 0x0, 0x39fc, 0x0, 0x37dc, 0x0,
    0xa674, 0x0, 0xb813, 0x0, 0xb9c5, 0x0, 0xb77d, 0x0,
    0xa964, 0x0, 0x37bb, 0x0, 0x39c3, 0x0, 0x3749, 0x0,
    0xa74f, 0x0, 0xb81a, 0x0, 0xb972, 0x0, 0xb789, 0x0,
    0x1fa9, 0x0, 0x37a8, 0x0, 0x397b, 0x0, 0x376d, 0x0,
    0x292a, 0x0, 0xb771, 0x0, 0xb9a1, 0x0, 0xb63a, 0x0,
    0xac7e, 0x0, 0x382f, 0x0, 0x397a, 0x0, 0x3796, 0x0,
    0xadcf, 0x0, 0xb74b, 0x0, 0xb9cc, 0x0, 0xb7f7, 0x0,
    0x2b33, 0x0, 0x36fd, 0x0, 0x3987, 0x0, 0x373e, 0x0,
    0x1443, 0x0, 0xb80b, 0x0, 0xba3a, 0x0, 0xb73f, 0x0,
    0xa58b, 0x0, 0x3711, 0x0, 0x3a55, 0x0, 0x383d, 0x0,
    0x2d5b, 0x0, 0xb836, 0x0, 0xb97b, 0x0, 0xb82e, 0x0,
    0xb05b, 0x0, 0x3804, 0x0, 0x3903, 0x0, 0x36b3, 0x0,
    0x2f7c, 0x0, 0xb802, 0x0, 0xb998, 0x0, 0xb736, 0x0,
    0xa73c, 0x0, 0x37d3, 0x0, 0x39c4, 0x0, 0x3818, 0x0,
    0xa48d, 0x0, 0xb855, 0x0, 0xb965, 0x0, 0xb715, 0x0,
    0xa380, 0x0, 0x3827, 0x0, 0x38da, 0x0, 0x38d7, 0x0,
    0xae84, 0x0, 0xb801, 0x0, 0xb96a, 0x0, 0xb7ca, 0x0,
    0x2f2c, 0x0, 0x37a0, 0x0, 0x3a39, 0x0, 0x3780, 0x0,
    0xac47, 0x0, 0xb789, 0x0, 0xb99e, 0x0, 0xb81d, 0x0,
    0xa5e7, 0x0, 0x38a2, 0x0, 0x39e6, 0x0, 0x381f, 0x0,
    0x2e0a, 0x0, 0xb777, 0x0, 0xb976, 0x0, 0xb7be, 0x0,
    0xadf2, 0x0, 0x382e, 0x0, 0x3916, 0x0, 0x37b2, 0x0,
    0x92a0, 0x0, 0xb81c, 0x0, 0xb930, 0x0, 0xb84c, 0x0,
    0xa51f, 0x0, 0x37f9, 0x0, 0x38b7, 0x0, 0x36e0, 0x0,
    0xa963, 0x0, 0xb74b, 0x0, 0xba8e, 0x0, 0xb887, 0x0,
    0x2cef, 0x0, 0x3819, 0x0, 0x3954, 0x0, 0x3804, 0x0,
    0x2666, 0x0, 0xb6d6, 0x0, 0xb98e, 0x0, 0xb835, 0x0,
    0xa9a7, 0x0, 0x3721, 0x0, 0x3911, 0x0, 0x37c7, 0x0,
    0xab17, 0x0, 0xb862, 0x0, 0xb9e3, 0x0, 0xb7ca, 0x0,
    0xa453, 0x0, 0x36c8, 0x0, 0x39fa, 0x0, 0x38a3, 0x0,
    0xa969, 0x0, 0xb814, 0x0, 0xb9c0, 0x0, 0xb793, 0x0,
    0xa1a6, 0x0, 0x3818, 0x0, 0x3a0b, 0x0, 0x384f, 0x0,
    0xa8c5, 0x0, 0xb81a, 0x0, 0xb978, 0x0, 0xb82f, 0x0,
    0xa1d6, 0x0, 0x36d4, 0x0, 0x39c0, 0x0, 0x3852, 0x0,
    0xa82b, 0x0, 0xb864, 0x0, 0xb8fe, 0x0, 0xb799, 0x0,
    0xa60d, 0x0, 0x37df, 0x0, 0x3996, 0x0, 0x37d5, 0x0,
    0xa9b6, 0x0, 0xb86c, 0x0, 0xb9a3, 0x0, 0xb76b, 0x0,
    0xa4ca, 0x0, 0x36bd, 0x0, 0x39ac, 0x0, 0x389e, 0x0,
    0x2bfb, 0x0, 0xb7ae, 0x0, 0xb9a3, 0x0, 0xb765, 0x0,
    0x2c79, 0x0, 0x37ef, 0x0, 0x3980, 0x0, 0x37be, 0x0,
    0xa563, 0x0, 0xb88a, 0x0, 0xb9b3, 0x0, 0xb72e, 0x0,
    0xaaee, 0x0, 0x3833, 0x0, 0x39d4, 0x0, 0x36ee, 0x0,
    0x271c, 0x0, 0xb71c, 0x0, 0xb959, 0x0, 0xb879, 0x0,
    0xa274, 0x0, 0x3842, 0x0, 0x3a5d, 0x0, 0x3910, 0x0,
    0xa62b, 0x0, 0xb842, 0x0, 0xb9ca, 0x0, 0xb8be, 0x0,
    0xa846, 0x0, 0x38b8, 0x0, 0x3949, 0x0, 0x387e, 0x0,
    0x23b5, 0x0, 0xb708, 0x0, 0xb98e, 0x0, 0xb833, 0x0,
    0x29b7, 0x0, 0x3794, 0x0, 0x39ab, 0x0, 0x374f, 0x0,
    0x2c3c, 0x0, 0xb92d, 0x0, 0xb95d, 0x0, 0xb74e, 0x0,
    0xaccf, 0x0, 0x368d, 0x0, 0x3926, 0x0, 0x38ba, 0x0,
    0x25b2, 0x0, 0xb7a4, 0x0, 0xb964, 0x0, 0xb75c, 0x0,
    0xa88e, 0x0, 0x3892, 0x0, 0x3963, 0x0, 0x3766, 0x0,
    0xa90e, 0x0, 0xb889, 0x0, 0xb972, 0x0, 0xb784, 0x0,
    0xa6d6, 0x0, 0x3740, 0x0, 0x3a64, 0x0, 0x384c, 0x0,
    0xa70d, 0x0, 0xb87a, 0x0, 0xba45, 0x0, 0xb7d3, 0x0,
    0xa7f8, 0x0, 0x377b, 0x0, 0x39e2, 0x0, 0x382d, 0x0,
    0x12d6, 0x0, 0xb791, 0x0, 0xb9bd, 0x0, 0xb81f, 0x0,
    0x2d4c, 0x0, 0x3839, 0x0, 0x38ce, 0x0, 0x3765, 0x0,
    0x2084, 0x0, 0xb81d, 0x0, 0xb955, 0x0, 0xb85c, 0x0,
    0x9c42, 0x0, 0x37dd, 0x0, 0x39fb, 0x0, 0x3803, 0x0,
    0xad75, 0x0, 0xb81e, 0x0, 0xb98f, 0x0, 0xb7b1, 0x0,
    0x2d7b, 0x0, 0x37e4, 0x0, 0x3a12, 0x0, 0x3896, 0x0,
    0x27e3, 0x0, 0xb76a, 0x0, 0xb994, 0x0, 0xb633, 0x0,
    0x1d18, 0x0, 0x387a, 0x0, 0x39b0, 0x0, 0x37c8, 0x0,
    0x2575, 0x0, 0xb6a8, 0x0, 0xb9bd, 0x0, 0xb6df, 0x0,
    0x29fb, 0x0, 0x3844, 0x0, 0x39a1, 0x0, 0x36fa, 0x0,
    0xab14, 0x0, 0xb834, 0x0, 0xb9ed, 0x0, 0xb870, 0x0,
    0xaac3, 0x0, 0x3850, 0x0, 0x3950, 0x0, 0x385d, 0x0,
    0x2807, 0x0, 0xb790, 0x0, 0xb8f9, 0x0, 0xb6ec, 0x0,
    0x2446, 0x0, 0x37e0, 0x0, 0x3992, 0x0, 0x36dd, 0x0,
    0x2bd2, 0x0, 0xb82a, 0x0, 0xba09, 0x0, 0xb803, 0x0,
    0xa745, 0x0, 0x37ba, 0x0, 0x39ab, 0x0, 0x385e, 0x0,
    0x24ea, 0x0, 0xb820, 0x0, 0xb9b4, 0x0, 0xb72a, 0x0,
    0xaa11, 0x0, 0x37b3, 0x0, 0x3899, 0x0, 0x3812, 0x0,
    0xaae0, 0x0, 0xb7ef, 0x0, 0xb96f, 0x0, 0xb84b, 0x0,
    0x2bb9, 0x0, 0x3781, 0x0, 0x3a37, 0x0, 0x3800, 0x0,
    0xaa83, 0x0, 0xb6ea, 0x0, 0xb9d8, 0x0, 0xb73f, 0x0,
    0xa92d, 0x0, 0x377a, 0x0, 0x3a4d, 0x0, 0x3741, 0x0,
    0x25eb, 0x0, 0xb872, 0x0, 0xb9ce, 0x0, 0xb73c, 0x0,
    0xa41c, 0x0, 0x36ea, 0x0, 0x39a0, 0x0, 0x3819, 0x0,
    0xac55, 0x0, 0xb808, 0x0, 0xb9ef, 0x0, 0xb887, 0x0,
    0x25dc, 0x0, 0x37c5, 0x0, 0x39c2, 0x0, 0x3860, 0x0,
    0x9b0e, 0x0, 0xb76a, 0x0, 0xb94f, 0x0, 0xb7b7, 0x0,
    0x15c5, 0x0, 0x36e2, 0x0, 0x39ef, 0x0, 0x373f, 0x0,
    0x284b, 0x0, 0xb7d1, 0x0, 0xb969, 0x0, 0xb84d, 0x0,
    0xabbe, 0x0, 0x3808, 0x0, 0x3994, 0x0, 0x375b, 0x0,
    0x2f4c, 0x0, 0xb747, 0x0, 0xb96a, 0x0, 0xb707, 0x0,
    0xa1ae, 0x0, 0x3847, 0x0, 0x398b, 0x0, 0x375b, 0x0,
    0x2913, 0x0, 0xb888, 0x0, 0xba16, 0x0, 0xb862, 0x0,
    0xab11, 0x0, 0x3714, 0x0, 0x3a41, 0x0, 0x3823, 0x0,
    0xa86a, 0x0, 0xb72b, 0x0, 0xb97f, 0x0, 0xb847, 0x0,
    0xa431, 0x0, 0x3868, 0x0, 0x3aa0, 0x0, 0x378f, 0x0,
    0xa823, 0x0, 0xb789, 0x0, 0xb8c6, 0x0, 0xb753, 0x0,
    0x85fe, 0x0, 0x381e, 0x0, 0x39ab, 0x0, 0x382e, 0x0,
    0x2618, 0x0, 0xb858, 0x0, 0xb9bc, 0x0, 0xb734, 0x0,
    0xac50, 0x0, 0x381c, 0x0, 0x3994, 0x0, 0x3877, 0x0,
    0xadb0, 0x0, 0xb80f, 0x0, 0xb97c, 0x0, 0xb7a1, 0x0,
    0xa33e, 0x0, 0x376b, 0x0, 0x3a87, 0x0, 0x37e3, 0x0,
    0x2e81, 0x0, 0xb83f, 0x0, 0xb933, 0x0, 0xb750, 0x0,
    0xa920, 0x0, 0x3794, 0x0, 0x399e, 0x0, 0x3714, 0x0,
    0x24d2, 0x0, 0xb6d6, 0x0, 0xb9ea, 0x0, 0xb777, 0x0,
    0xa9c0, 0x0, 0x37c4, 0x0, 0x3989, 0x0, 0x380f, 0x0,
    0xa5f5, 0x0, 0xb805, 0x0, 0xb9be, 0x0, 0xb833, 0x0,
    0xa076, 0x0, 0x37f4, 0x0, 0x39bf, 0x0, 0x3799, 0x0,
    0xab73, 0x0, 0xb86f, 0x0, 0xb9a2, 0x0, 0xb88e, 0x0,
    0x2a43, 0x0, 0x382f, 0x0, 0x399c, 0x0, 0x3861, 0x0,
    0xa190, 0x0, 0xb733, 0x0, 0xb9d9, 0x0, 0xb809, 0x0,
    0xa954, 0x0, 0x3752, 0x0, 0x3949, 0x0, 0x370e, 0x0,
    0x2fb9, 0x0, 0xb7bf, 0x0, 0xba15, 0x0, 0xb709, 0x0,
    0x2a76, 0x0, 0x3794, 0x0, 0x3983, 0x0, 0x3811, 0x0,
    0xa017, 0x0, 0xb870, 0x0, 0xba27, 0x0, 0xb81d, 0x0,
    0x2abf, 0x0, 0x37a1, 0x0, 0x3a32, 0x0, 0x3885, 0x0,
    0x2919, 0x0, 0xb845, 0x0, 0xba42, 0x0, 0xb904, 0x0,
    0x2377, 0x0, 0x3758, 0x0, 0x39ed, 0x0, 0x3804, 0x0,
    0xa72b, 0x0, 0xb8cc, 0x0, 0xb8e3, 0x0, 0xb81b, 0x0,
    0x2161, 0x0, 0x3841, 0x0, 0x3934, 0x0, 0x382f, 0x0,
    0x23e8, 0x0, 0xb6c1, 0x0, 0xb966, 0x0, 0xb8af, 0x0,
    0x994e, 0x0, 0x3832, 0x0, 0x3991, 0x0, 0x38d8, 0x0,
    0x2402, 0x0, 0xb656, 0x0, 0xb9ac, 0x0, 0xb82d, 0x0,
    0x9167, 0x0, 0x3778, 0x0, 0x394a, 0x0, 0x373c, 0x0,
    0xab52, 0x0, 0xb7ea, 0x0, 0xb93d, 0x0, 0xb7d2, 0x0,
    0x2962, 0x0, 0x3810, 0x0, 0x398f, 0x0, 0x37e8, 0x0,
    0xac3a, 0x0, 0xb80f, 0x0, 0xb997, 0x0, 0xb8ec, 0x0,
    0xaabf, 0x0, 0x36a8, 0x0, 0x39c0, 0x0, 0x3816, 0x0,
    0x23f0, 0x0, 0xb8b2, 0x0, 0xb93e, 0x0, 0xb7ef, 0x0,
    0x2e69, 0x0, 0x3813, 0x0, 0x398f, 0x0, 0x38ff, 0x0,
    0xa0aa, 0x0, 0xb7c9, 0x0, 0xb9fb, 0x0, 0xb701, 0x0,
    0x27a0, 0x0, 0x389f, 0x0, 0x3940, 0x0, 0x37ba, 0x0,
    0x2929, 0x0, 0xb835, 0x0, 0xba0b, 0x0, 0xb69e, 0x0,
    0xa26b, 0x0, 0x3853, 0x0, 0x3969, 0x0, 0x36d1, 0x0,
    0x20bc, 0x0, 0xb7ae, 0x0, 0xb953, 0x0, 0xb7bd, 0x0,
    0xa0a3, 0x0, 0x3769, 0x0, 0x3938, 0x0, 0x36fc, 0x0,
    0x27f6, 0x0, 0xb752, 0x0, 0xb8de, 0x0, 0xb7bb, 0x0,
    0x28b8, 0x0, 0x385d, 0x0, 0x38c0, 0x0, 0x3841, 0x0,
    0xa071, 0x0, 0xb79c, 0x0, 0xb998, 0x0, 0xb825, 0x0,
    0xa296, 0x0, 0x3725, 0x0, 0x38a0, 0x0, 0x3898, 0x0,
    0x2b6f, 0x0, 0xb7e4, 0x0, 0xb9a7, 0x0, 0xb6ea, 0x0,
    0xa90c, 0x0, 0x36df, 0x0, 0x39e0, 0x0, 0x37bc, 0x0,
    0xaaa9, 0x0, 0xb8dc, 0x0, 0xb9d6, 0x0, 0xb7a9, 0x0,
    0xa97c, 0x0, 0x380a, 0x0, 0x39ff, 0x0, 0x37b2, 0x0,
    0xa5cd, 0x0, 0xb8a7, 0x0, 0xb984, 0x0, 0xb85b, 0x0,
    0x2dfa, 0x0, 0x371c, 0x0, 0x39a6, 0x0, 0x37e5, 0x0,
    0xa298, 0x0, 0xb80d, 0x0, 0xb9be, 0x0, 0xb7b4, 0x0,
    0xa4f4, 0x0, 0x38ae, 0x0, 0x3937, 0x0, 0x37a1, 0x0,
    0xad2e, 0x0, 0xb826, 0x0, 0xba39, 0x0, 0xb762, 0x0,
    0x2428, 0x0, 0x37a1, 0x0, 0x39c5, 0x0, 0x37e8, 0x0,
    0x9bba, 0x0, 0xb80a, 0x0, 0xb9b5, 0x0, 0xb707, 0x0,
    0x2bcf, 0x0, 0x37e5, 0x0, 0x393c, 0x0, 0x3813, 0x0,
    0x2c79, 0x0, 0xb824, 0x0, 0xb9dc, 0x0, 0xb86e, 0x0,
    0x25c8, 0x0, 0x3808, 0x0, 0x3911, 0x0, 0x3822, 0x0,
    0xaa8d, 0x0, 0xb894, 0x0, 0xb90a, 0x0, 0xb837, 0x0,
    0x26d2, 0x0, 0x3852, 0x0, 0x39c0, 0x0, 0x37b0, 0x0,
    0x22ca, 0x0, 0xb783, 0x0, 0xb97b, 0x0, 0xb79b, 0x0,
    0x1fff, 0x0, 0x37d1, 0x0, 0x3a5b, 0x0, 0x380e, 0x0,
    0x2847, 0x0, 0xb7d8, 0x0, 0xb967, 0x0, 0xb8df, 0x0,
    0xa845, 0x0, 0x371c, 0x0, 0x3a74, 0x0, 0x3820, 0x0,
    0x954f, 0x0, 0xb880, 0x0, 0xba1b, 0x0, 0xb80b, 0x0,
    0x2845, 0x0, 0x37c0, 0x0, 0x39b6, 0x0, 0x37c7, 0x0,
    0x2654, 0x0, 0xb775, 0x0, 0xb9c2, 0x0, 0xb729, 0x0,
    0x2d3a, 0x0, 0x3805, 0x0, 0x39e6, 0x0, 0x36d5, 0x0,
    0x1ab2, 0x0, 0xb642, 0x0, 0xba1e, 0x0, 0xb7cc, 0x0,
    0x2973, 0x0, 0x389c, 0x0, 0x39fb, 0x0, 0x3855, 0x0,
    0x2c93, 0x0, 0xb84c, 0x0, 0xba0b, 0x0, 0xb7da, 0x0,
    0xa08a, 0x0, 0x3842, 0x0, 0x3915, 0x0, 0x3746, 0x0,
    0x294f, 0x0, 0xb8bb, 0x0, 0xb944, 0x0, 0xb886, 0x0,
    0x2437, 0x0, 0x37cb, 0x0, 0x3980, 0x0, 0x386d, 0x0,
    0x22d5, 0x0, 0xb6e5, 0x0, 0xb982, 0x0, 0xb805, 0x0,
    0x153f, 0x0, 0x3772, 0x0, 0x3941, 0x0, 0x385d, 0x0,
    0x2b08, 0x0, 0xb85b, 0x0, 0xb933, 0x0, 0xb78e, 0x0,
    0xa968, 0x0, 0x371f, 0x0, 0x39cb, 0x0, 0x3810, 0x0,
    0xafb2, 0x0, 0xb6a2, 0x0, 0xb937, 0x0, 0xb821, 0x0,
    0x9b51, 0x0, 0x385a, 0x0, 0x398a, 0x0, 0x36ef, 0x0,
    0x2a96, 0x0, 0xb7d2, 0x0, 0xbab2, 0x0, 0xb7c9, 0x0,
    0x2612, 0x0, 0x37fb, 0x0, 0x3925, 0x0, 0x3703, 0x0,
    0xa88c, 0x0, 0xb877, 0x0, 0xb9ac, 0x0, 0xb816, 0x0,
    0x1b0f, 0x0, 0x382a, 0x0, 0x39ff, 0x0, 0x3861, 0x0,
    0x2a1b, 0x0, 0xb76d, 0x0, 0xb92d, 0x0, 0xb808, 0x0,
    0x2eab, 0x0, 0x370d, 0x0, 0x39d5, 0x0, 0x3811, 0x0,
    0x262f, 0x0, 0xb6d1, 0x0, 0xb8f1, 0x0, 0xb8a7, 0x0,
    0x2c48, 0x0, 0x370a, 0x0, 0x39db, 0x0, 0x3831, 0x0,
    0x256f, 0x0, 0xb6b1, 0x0, 0xb97e, 0x0, 0xb784, 0x0,
    0xa8e8, 0x0, 0x38d0, 0x0, 0x39f2, 0x0, 0x3841, 0x0,
    0xa4f8, 0x0, 0xb87f, 0x0, 0xb915, 0x0, 0xb82a, 0x0,
    0xab23, 0x0, 0x37a2, 0x0, 0x3995, 0x0, 0x3792, 0x0,
    0xac48, 0x0, 0xb7f9, 0x0, 0xb9d5, 0x0, 0xb759, 0x0,
    0xa97b, 0x0, 0x381e, 0x0, 0x396c, 0x0, 0x3768, 0x0,
    0xa080, 0x0, 0xb7a0, 0x0, 0xb920, 0x0, 0xb7e7, 0x0,
    0x2819, 0x0, 0x372b, 0x0, 0x398c, 0x0, 0x377e, 0x0,
    0x28e2, 0x0, 0xb63c, 0x0, 0xb9bf, 0x0, 0xb878, 0x0,
    0xa926, 0x0, 0x3733, 0x0, 0x39d3, 0x0, 0x3807, 0x0,
    0xac1d, 0x0, 0xb891, 0x0, 0xb93d, 0x0, 0xb7cb, 0x0,
    0x2977, 0x0, 0x3821, 0x0, 0x3a41, 0x0, 0x38cd, 0x0,
    0xace5, 0x0, 0xb733, 0x0, 0xb9a4, 0x0, 0xb75c, 0x0,
    0xaab1, 0x0, 0x388c, 0x0, 0x392f, 0x0, 0x38e8, 0x0,
    0xa9f2, 0x0, 0xb6bf, 0x0, 0xb94f, 0x0, 0xb864, 0x0,
    0xa9dc, 0x0, 0x37fe, 0x0, 0x3933, 0x0, 0x374c, 0x0,
    0xa86a, 0x0, 0xb80d, 0x0, 0xb96f, 0x0, 0xb76a, 0x0,
    0xadad, 0x0, 0x3647, 0x0, 0x396f, 0x0, 0x37f8, 0x0,
    0xaa9d, 0x0, 0xb799, 0x0, 0xb975, 0x0, 0xb88d, 0x0,
    0x28ba, 0x0, 0x3737, 0x0, 0x394c, 0x0, 0x3734, 0x0,
    0xa89f, 0x0, 0xb7cc, 0x0, 0xb988, 0x0, 0xb775, 0x0,
    0x9dc5, 0x0, 0x369d, 0x0, 0x39e2, 0x0, 0x38d0, 0x0,
    0x2250, 0x0, 0xb828, 0x0, 0xb995, 0x0, 0xb83e, 0x0,
    0xa56c, 0x0, 0x3831, 0x0, 0x39c2, 0x0, 0x3733, 0x0,
    0x1b7e, 0x0, 0xb7c6, 0x0, 0xb992, 0x0, 0xb6dc, 0x0,
    0xab06, 0x0, 0x36f3, 0x0, 0x395c, 0x0, 0x363e, 0x0,
    0x2a62, 0x0, 0xb85b, 0x0, 0xb986, 0x0, 0xb7f0, 0x0,
    0xa5de, 0x0, 0x381f, 0x0, 0x39f1, 0x0, 0x3707, 0x0,
    0x296f, 0x0, 0xb774, 0x0, 0xb8a0, 0x0, 0xb867, 0x0,
    0x2e7d, 0x0, 0x38a6, 0x0, 0x3a5c, 0x0, 0x3604, 0x0,
    0xac17, 0x0, 0xb817, 0x0, 0xba15, 0x0, 0xb7e2, 0x0,
    0x2c92, 0x0, 0x382d, 0x0, 0x394e, 0x0, 0x3869, 0x0,
    0x2a29, 0x0, 0xb81b, 0x0, 0xba24, 0x0, 0xb870, 0x0,
    0x2e21, 0x0, 0x375a, 0x0, 0x39f2, 0x0, 0x3812, 0x0,
    0x26b5, 0x0, 0xb725, 0x0, 0xb9d6, 0x0, 0xb7e2, 0x0,
    0x2eda, 0x0, 0x37bc, 0x0, 0x38f4, 0x0, 0x3711, 0x0,
    0xaa94, 0x0, 0xb768, 0x0, 0xb953, 0x0, 0xb723, 0x0,
    0xa1e3, 0x0, 0x381b, 0x0, 0x39f2, 0x0, 0x36c1, 0x0,
    0xab80, 0x0, 0xb855, 0x0, 0xb8f7, 0x0, 0xb7e0, 0x0,
    0x2248, 0x0, 0x3811, 0x0, 0x39ea, 0x0, 0x3791, 0x0,
    0xaae7, 0x0, 0xb857, 0x0, 0xb99d, 0x0, 0xb789, 0x0,
    0xac26, 0x0, 0x381e, 0x0, 0x39ff, 0x0, 0x36be, 0x0,
    0xade5, 0x0, 0xb817, 0x0, 0xba2a, 0x0, 0xb752, 0x0,
    0x1c90, 0x0, 0x36b9, 0x0, 0x39b5, 0x0, 0x37f2, 0x0,
    0xa358, 0x0, 0xb7a3, 0x0, 0xba27, 0x0, 0xb763, 0x0,
    0xa1d8, 0x0, 0x37df, 0x0, 0x3932, 0x0, 0x37e9, 0x0,
    0x22f1, 0x0, 0xb828, 0x0, 0xb994, 0x0, 0xb6bf, 0x0,
    0xa269, 0x0, 0x3834, 0x0, 0x39d2, 0x0, 0x37d1, 0x0,
    0xae64, 0x0, 0xb88a, 0x0, 0xb9a4, 0x0, 0xb7d7, 0x0,
    0xadbd, 0x0, 0x36e1, 0x0, 0x3972, 0x0, 0x385d, 0x0,
    0xac77, 0x0, 0xb7fa, 0x0, 0xb94c, 0x0, 0xb81a, 0x0,
    0xa50d, 0x0, 0x380b, 0x0, 0x3974, 0x0, 0x3813, 0x0,
    0x2d3b, 0x0, 0xb76c, 0x0, 0xb9c8, 0x0, 0xb782, 0x0,
    0x1dd4, 0x0, 0x3897, 0x0, 0x3947, 0x0, 0x3669, 0x0,
    0xa01e, 0x0, 0xb801, 0x0, 0xb94d, 0x0, 0xb8bd, 0x0,
    0xa4fd, 0x0, 0x384b, 0x0, 0x39ac, 0x0, 0x374c, 0x0,
    0x1ea8, 0x0, 0xb87f, 0x0, 0xb9f9, 0x0, 0xb817, 0x0,
    0x2d15, 0x0, 0x389b, 0x0, 0x3a36, 0x0, 0x3772, 0x0,
    0xacf9, 0x0, 0xb7a9, 0x0, 0xba13, 0x0, 0xb7c0, 0x0,
    0x1b18, 0x0, 0x3701, 0x0, 0x3986, 0x0, 0x377e, 0x0,
    0x2bc5, 0x0, 0xb7ea, 0x0, 0xba0a, 0x0, 0xb7a0, 0x0,
    0x1d93, 0x0, 0x3771, 0x0, 0x39c1, 0x0, 0x37f4, 0x0,
    0x25c6, 0x0, 0xb76c, 0x0, 0xb98e, 0x0, 0xb813, 0x0,
    0xacb4, 0x0, 0x35c5, 0x0, 0x398b, 0x0, 0x3875, 0x0,
    0xa87a, 0x0, 0xb84d, 0x0, 0xb9bc, 0x0, 0xb7d6, 0x0,
    0x27fa, 0x0, 0x36cc, 0x0, 0x39b7, 0x0, 0x37af, 0x0,
    0x26e8, 0x0, 0xb77f, 0x0, 0xba59, 0x0, 0xb8c6, 0x0,
    0xaa2b, 0x0, 0x375b, 0x0, 0x3a24, 0x0, 0x36ec, 0x0,
    0x2633, 0x0, 0xb7b0, 0x0, 0xb91d, 0x0, 0xb755, 0x0,
    0xa25e, 0x0, 0x384f, 0x0, 0x3993, 0x0, 0x35b8, 0x0,
    0x1f67, 0x0, 0xb810, 0x0, 0xb97a, 0x0, 0xb7b2, 0x0,
    0xa082, 0x0, 0x3894, 0x0, 0x395b, 0x0, 0x3745, 0x0,
    0x1c17, 0x0, 0xb743, 0x0, 0xb962, 0x0, 0xb813, 0x0,
    0xac47, 0x0, 0x37bc, 0x0, 0x39d5, 0x0, 0x3782, 0x0,
    0xaf9c, 0x0, 0xb7cb, 0x0, 0xb9ca, 0x0, 0xb850, 0x0,
    0xa92d, 0x0, 0x3749, 0x0, 0x39e3, 0x0, 0x3832, 0x0,
    0xac8d, 0x0, 0xb815, 0x0, 0xb91b, 0x0, 0xb6ca, 0x0,
    0x2675, 0x0, 0x38a6, 0x0, 0x39f5, 0x0, 0x373d, 0x0,
    0xa808, 0x0, 0xb5f8, 0x0, 0xb8d5, 0x0, 0xb83f, 0x0,
    0x2453, 0x0, 0x379c, 0x0, 0x392b, 0x0, 0x3739, 0x0,
    0xa668, 0x0, 0xb810, 0x0, 0xb9c3, 0x0, 0xb8c2, 0x0
    };

static const uint16_t in_cifft_noisy_2048[4096] = {
    0xc501, 0x0, 0xbd60, 0x4243, 0x3904, 0xb5eb, 0xbb8d, 0xba8a,
    0xb4d2, 0xb63a, 0x3e1c, 0xbeeb, 0x4168, 0xb7b2, 0xb453, 0xc023,
    0x359f, 0x2361, 0xbf41, 0xc0f1, 0x3922, 0x3b1b, 0x3681, 0xbc42,
    0x37d4, 0x3d93, 0x3bf9, 0x3836, 0xba91, 0xbd92, 0xbbbd, 0x339f,
    0x2e15, 0x4142, 0xbe87, 0xbfae, 0xbb02, 0xbe42, 0x4239, 0x4119,
    0x4113, 0xb58b, 0x4372, 0xbbcc, 0xc182, 0xb0e1, 0x3999, 0xba8a,
    0xbb87, 0x3f09, 0xb34a, 0x2be3, 0xbe59, 0x3f7e, 0x32eb, 0xb907,
    0xbdcb, 0xb7de, 0xb4d5, 0x3a9c, 0x35dc, 0xbf49, 0x3130, 0xba73,
    0xbddd, 0x44e9, 0x31de, 0x3f0d, 0x3dbb, 0x3b6a, 0x377c, 0xc22c,
    0x3a57, 0xb1d0, 0x3ce1, 0xb152, 0x3960, 0x32f1, 0x3448, 0x3ad8,
    0xba4f, 0x3b6b, 0x3cbb, 0xbd23, 0xc066, 0xc2b3, 0x3d57, 0x404d,
    0x4050, 0xbd41, 0x38be, 0x4142, 0x3f03, 0xc385, 0xc283, 0x3f23,
    0xc00c, 0xbf42, 0xc0af, 0x363e, 0x4179, 0x4139, 0x3550, 0xb108,
    0x33c6, 0x4026, 0x3c5e, 0xb98d, 0xb7a7, 0xb969, 0xbf4e, 0xb06a,
    0xbcf2, 0x2e88, 0x400d, 0x3daa, 0xbff8, 0xb842, 0xc417, 0x3194,
    0x3c65, 0x3a52, 0x3e6f, 0x3b0b, 0xbf64, 0x428b, 0xc409, 0x4011,
    0x386b, 0x3ed2, 0xbd17, 0x2ce6, 0xb7b4, 0xc15c, 0x37f4, 0xb780,
    0x34ac, 0x37d6, 0xb814, 0xb5ef, 0x40e8, 0x4007, 0xb810, 0xc28e,
    0x36b3, 0x2f79, 0xbad7, 0x3cba, 0xbdb6, 0xc0ab, 0xbf36, 0xc2d2,
    0x38e4, 0x4243, 0x2cfe, 0x2cfd, 0xba99, 0x366d, 0xc067, 0xbab4,
    0xbaa7, 0xb9cc, 0x2e0f, 0x3799, 0xb8cd, 0xc4d2, 0xc3be, 0xbe8d,
    0xc46a, 0x3b58, 0x4317, 0xb5b4, 0xb96c, 0x3da3, 0x3394, 0xbd85,
    0x3be8, 0x3b74, 0x3c28, 0xbadc, 0xbc3f, 0x36a2, 0x40bf, 0x420a,
    0xb813, 0x4048, 0xbe7d, 0xb9ae, 0x3ed8, 0xbe20, 0x3700, 0xc3fa,
    0x3763, 0xc010, 0xb6c6, 0xc2dd, 0xb941, 0x340a, 0xb69e, 0x3983,
    0x3d2f, 0xbc8e, 0xc204, 0xc478, 0xc114, 0xc405, 0x3eca, 0x384d,
    0x317d, 0x3cb8, 0xb256, 0xbba7, 0x3c1d, 0xc169, 0xbfd6, 0xb1a3,
    0x3dc5, 0xafc6, 0x404e, 0x3941, 0xbc6b, 0x3b4d, 0xbc67, 0x33f3,
    0xbb07, 0xbce8, 0xba2b, 0x3559, 0x39df, 0xc03d, 0xbdd5, 0xb56e,
    0x343a, 0xaf56, 0xadc2, 0xc27c, 0xbccc, 0x3e63, 0xbdcd, 0xc058,
    0x414e, 0x41a5, 0x3427, 0xb81e, 0x4106, 0xa866, 0x38f3, 0xc0b7,
    0x3d6b, 0xc25f, 0xb6c8, 0x384e, 0x3e4b, 0xb8b6, 0xbb93, 0xbbe8,
    0x2c38, 0x3952, 0x3f64, 0x3c38, 0xbf88, 0x392d, 0x3fc8, 0xb5a5,
    0x18ea, 0xbaea, 0x37c3, 0x3c98, 0xb967, 0xb635, 0x3d14, 0xb4ee,
    0x40b2, 0x40da, 0xbada, 0xbf51, 0x3838, 0xc2d0, 0xbff1, 0x3cca,
    0xbe58, 0xbd2d, 0xbcc9, 0x4302, 0xc1cf, 0xbde8, 0xbe1a, 0xc2a2,
    0x35a9, 0x39de, 0xc13f, 0xbc3d, 0xba88, 0xbeed, 0xbbd3, 0xa83e,
    0xbc0a, 0x38f1, 0x3b91, 0x3c65, 0xbdeb, 0xc1d8, 0xb5ed, 0x2e8c,
    0xb601, 0xba69, 0xb967, 0xbc83, 0x3a95, 0xc03b, 0x3979, 0x3c2c,
    0xc126, 0x3af0, 0x2e38, 0x3c38, 0xc127, 0x4003, 0xb85e, 0x3b7b,
    0x3e0c, 0x2fde, 0x436d, 0xbbe2, 0x36c5, 0xa775, 0x33ff, 0xb9d9,
    0xafba, 0xbe9a, 0x40b3, 0x3752, 0xc130, 0x4460, 0x3b44, 0xc126,
    0x3d44, 0x4352, 0x3ca6, 0x408c, 0x3c36, 0xb8ee, 0xc1bf, 0xb80e,
    0x4053, 0x3944, 0xb807, 0x38fb, 0xb25d, 0xbc69, 0x3e7e, 0xba5b,
    0x3b16, 0x39fa, 0x3ba6, 0x3391, 0xbb47, 0xbc13, 0xaf6b, 0xb81f,
    0xbd66, 0xb8a4, 0x3660, 0xb713, 0xbac1, 0xbdcc, 0xb93a, 0x3ddf,
    0xbdb8, 0xc27f, 0xb657, 0xb698, 0x3412, 0x4093, 0xbf39, 0xc118,
    0xb00f, 0x3c48, 0xb440, 0xbeb1, 0xbd54, 0xbd21, 0xb4d8, 0xbfaa,
    0xbdc2, 0x39ec, 0xbf7e, 0xbd33, 0x209c, 0xae16, 0x4034, 0xbde8,
    0xbbd3, 0x3ecf, 0x3fcb, 0xc07b, 0x40d8, 0x41e7, 0x368b, 0x3dd3,
    0x3ad8, 0x40c3, 0xbef6, 0x3e43, 0xc0f6, 0x3859, 0xc2d5, 0x2c95,
    0x4111, 0xbf16, 0x3a64, 0xbaae, 0x4082, 0x3f63, 0xb57d, 0xbfaa,
    0xb3f8, 0x3a75, 0xa919, 0x397c, 0x3f56, 0x3b11, 0xc09b, 0xb6ab,
    0x410a, 0x3feb, 0xc139, 0xbc5e, 0x4074, 0xc149, 0x3aa7, 0xb2c8,
    0x38dc, 0x35e3, 0x39f1, 0x3dee, 0xbb2c, 0xa8e3, 0x3d83, 0x3a50,
    0x3c1d, 0x3d5b, 0x34da, 0xb627, 0xbe99, 0xb3af, 0xb9c9, 0x4128,
    0xc0ce, 0x3cc7, 0xbe9c, 0xbda4, 0x3af4, 0xbfc9, 0xbc07, 0x35d7,
    0xbf3a, 0xbe0b, 0xc02d, 0x3d51, 0xbc21, 0x3cea, 0x345f, 0x414f,
    0x3d16, 0xb550, 0x3948, 0xbc55, 0x3eba, 0x3dbc, 0x4011, 0xbe42,
    0x3f14, 0xb96d, 0x3c80, 0xbd75, 0x3b67, 0x2403, 0x3cba, 0xbc5c,
    0xb89f, 0xac1a, 0xae73, 0x3752, 0x3518, 0xc225, 0x4100, 0xbb61,
    0xb40f, 0x3882, 0xbc91, 0x3dd9, 0xb5be, 0x3c4a, 0x3ea2, 0x3ee8,
    0x31d7, 0x43e0, 0x2cba, 0x419c, 0xb955, 0xc088, 0xb829, 0xbdd1,
    0x3ea0, 0xbc2e, 0x3822, 0xc058, 0x3446, 0xc1bf, 0xc247, 0x3def,
    0x38bd, 0xe19b, 0xb684, 0x3cae, 0xbb60, 0x43f4, 0xadee, 0x3fe3,
    0x410e, 0x3eca, 0x3b26, 0xadee, 0x3d54, 0x3f45, 0xbc9b, 0xc549,
    0xbe65, 0x40b2, 0xbe0b, 0xb8e7, 0x3c03, 0xb4ad, 0x3ddf, 0xb980,
    0xbded, 0x3ee7, 0x42c1, 0x411c, 0xb09f, 0xbe75, 0x2c99, 0x23fc,
    0xb975, 0x3cfd, 0xc218, 0xb5d8, 0xba14, 0x3dbe, 0x3bb0, 0x3ac1,
    0xbbaf, 0xb45c, 0x389e, 0x37d1, 0x3a52, 0xb1e6, 0x3818, 0x4151,
    0x345a, 0x3e95, 0xb4d2, 0xab4c, 0x3aec, 0x3f6e, 0x357e, 0x3598,
    0x3709, 0x4280, 0xb690, 0xbeeb, 0xb434, 0xbfb5, 0x3e62, 0x2d59,
    0xb81a, 0x426b, 0xc074, 0xc024, 0xb5f8, 0xbafd, 0xb7eb, 0x3bcf,
    0x3eb1, 0x3c4f, 0xbffd, 0xb7ba, 0x3a71, 0xc022, 0x3a71, 0xbcb3,
    0x3ff8, 0x3cc5, 0xb467, 0xbf56, 0x26c2, 0xbab9, 0x407b, 0x3c82,
    0x3825, 0xba04, 0xb5ac, 0xc389, 0x3eef, 0x40ea, 0x4193, 0x355d,
    0xbe70, 0x3b79, 0xba7e, 0x4003, 0xbc68, 0xb2f4, 0xbcf6, 0x3cdb,
    0x3df5, 0xb5d5, 0xb623, 0x3b29, 0x39c2, 0x3855, 0x400a, 0x3b13,
    0xc024, 0xbac3, 0xc2aa, 0xa9a7, 0xb488, 0xc050, 0xbc6c, 0xc117,
    0xb92e, 0x3354, 0xbf5f, 0x40e2, 0x3c6e, 0xc096, 0xc096, 0xb86e,
    0xbc21, 0xaff2, 0x3a86, 0xc151, 0xbb8c, 0x3803, 0x3a20, 0x3252,
    0xc02f, 0xbe01, 0x33db, 0xbef6, 0xbfab, 0x3f27, 0xbec2, 0xb3c4,
    0x37fb, 0xc07f, 0xbf7d, 0xbef8, 0xbca2, 0x3a27, 0xbfa8, 0x2d71,
    0xbdec, 0x3c11, 0xbd99, 0x3981, 0xbeb1, 0xbe42, 0x3e25, 0xb428,
    0x3bd3, 0x3f3a, 0x40bf, 0x3f55, 0x382c, 0xbec1, 0xbcf8, 0xc20e,
    0x3600, 0x3c72, 0x3ade, 0xb93a, 0xc178, 0xbe7b, 0xb333, 0xc156,
    0x41d0, 0xc0f6, 0xb4ca, 0xbec9, 0xb032, 0x38ed, 0x3e78, 0x3e10,
    0xbfb6, 0xb87d, 0x3550, 0x3c62, 0xb02b, 0x39cd, 0x3b19, 0x3944,
    0xc389, 0x3cac, 0x3e5e, 0xb4d3, 0x3f62, 0xb43a, 0xb9ec, 0xba30,
    0xbf98, 0xc000, 0xb14f, 0x423b, 0x3dcf, 0xbcb2, 0xbb38, 0x3bb2,
    0xbc3d, 0xc0da, 0x2c73, 0x3ba6, 0xb166, 0xbd50, 0xbd98, 0x325f,
    0x4144, 0xc025, 0x41f0, 0xbaf4, 0xb902, 0xbac1, 0xbdeb, 0x3f44,
    0x3ff9, 0x3e1d, 0xc39a, 0x3a17, 0x34ba, 0x3c9f, 0xa042, 0xc04f,
    0x3292, 0x3e90, 0x3a39, 0x36ce, 0x40a6, 0x3d01, 0xbacc, 0xb46b,
    0x3b3a, 0xb61e, 0xba57, 0xc1a9, 0xc126, 0xbc0b, 0x3cd5, 0x3d6b,
    0x3813, 0x3b1a, 0x42f5, 0xb5fe, 0xc013, 0x364a, 0x3cb5, 0x3ebe,
    0x41ed, 0xaf34, 0x3eb3, 0xbf4e, 0x4041, 0xb6c5, 0x3a9b, 0x36a3,
    0x3e04, 0xbc0b, 0x4417, 0x3c29, 0xbabe, 0xc00d, 0x3ae1, 0x40b9,
    0x3be2, 0xb700, 0xc021, 0x2bee, 0xc318, 0xb8fc, 0xbd9b, 0x38d9,
    0x39d3, 0x3795, 0xb9b8, 0xbd6a, 0x3d9b, 0x39ee, 0x3d4f, 0xbe55,
    0xbee5, 0x3d03, 0x3ab5, 0xbb77, 0x350d, 0xba31, 0x3709, 0xbfaa,
    0xc41e, 0xbf3b, 0x39e0, 0x385e, 0x3014, 0xb769, 0x40d2, 0xbc59,
    0x416f, 0xb254, 0xb8fe, 0x3b13, 0x3973, 0x289e, 0xbd1c, 0x3ef8,
    0x4125, 0xbe6a, 0x3f46, 0xbc01, 0x4017, 0x3d9f, 0xb897, 0x3bb8,
    0x9fa2, 0xb189, 0x3d54, 0x3af0, 0x30f6, 0x42b4, 0x4065, 0xbeb9,
    0xbed5, 0x311c, 0x3450, 0xbdbb, 0x3873, 0xbc7e, 0xc0da, 0x3d7f,
    0x3dbb, 0x3c0d, 0x2cba, 0x318e, 0xb9e5, 0xbc33, 0x3d2b, 0x3b6a,
    0xc06d, 0x3908, 0xbafc, 0x3c18, 0x392e, 0x381f, 0xc2ad, 0xbeef,
    0xb89b, 0x3f21, 0xc2eb, 0x3ac4, 0xbc07, 0xbcb2, 0xa652, 0xbc76,
    0x3855, 0xc006, 0x3ff7, 0xb9c4, 0xbdcc, 0xc206, 0xb8c4, 0x3dc9,
    0xc249, 0x3c8d, 0xb27d, 0x414c, 0x38b7, 0xb704, 0x4363, 0x3d27,
    0x40c7, 0xc0dc, 0xb9c1, 0x41ae, 0xc035, 0x2fbe, 0x425a, 0x3f8f,
    0x3bc3, 0xa98c, 0xc08d, 0xbdc9, 0x2110, 0x4012, 0xbedb, 0xbbc4,
    0x3fe3, 0xaf4e, 0xc104, 0xbc87, 0xbf22, 0xc08f, 0xb91e, 0x360a,
    0x3faf, 0xb55a, 0x40cc, 0xbe65, 0x426d, 0xa440, 0xaee9, 0x371c,
    0xbc2b, 0x3c83, 0xbc14, 0xbed2, 0x3698, 0x3777, 0xc07b, 0xb8a3,
    0xc22a, 0x3c74, 0x3c6e, 0xbf69, 0x36d0, 0xbb21, 0xb0fe, 0xba43,
    0xba9e, 0xb597, 0x3711, 0x3c28, 0x40a9, 0xbe04, 0x40ae, 0xb8aa,
    0xb434, 0xb51e, 0xb697, 0xbd3d, 0xb6b4, 0x330d, 0x3c45, 0xb53c,
    0x39c0, 0xc0aa, 0x4176, 0xc0d4, 0x31ad, 0x4295, 0xbc57, 0xbc87,
    0x3b92, 0xb062, 0x3d26, 0x3cd6, 0x3d4f, 0x3de5, 0xb6ea, 0x4100,
    0x3471, 0xbbfb, 0xbdc0, 0x41f8, 0x3d10, 0x3b2c, 0xbd64, 0x3f9a,
    0xb4ed, 0xc106, 0xbcd7, 0xbb99, 0xbe19, 0x436f, 0x409f, 0xc29a,
    0xac14, 0xb978, 0xb4fc, 0xbcb3, 0xc1b2, 0x3fa7, 0x40d1, 0x413b,
    0x2422, 0x4410, 0x2e0f, 0xb483, 0xbddc, 0xa99a, 0x3af4, 0xbe20,
    0xc3cc, 0xc063, 0xbc79, 0xb4dc, 0x3aed, 0x3ca9, 0xadf0, 0x41ae,
    0x3f65, 0xbe61, 0xbeec, 0xb203, 0xb97b, 0xc0b3, 0x3d03, 0xc0db,
    0xb972, 0xba3a, 0xbb47, 0x3e8e, 0xc304, 0xbc04, 0xbb35, 0x3a4c,
    0x3965, 0x3ca4, 0xb8a6, 0xc203, 0x372e, 0xbabb, 0xbb27, 0xc041,
    0x426d, 0xbba9, 0xbadf, 0xbadd, 0xbda3, 0xb3b0, 0x3070, 0xbe49,
    0xb854, 0xb539, 0x1870, 0xb658, 0x39d0, 0xc426, 0x2f13, 0xb868,
    0x3599, 0x3c01, 0xade3, 0xbeb6, 0xbff2, 0x3cdc, 0xbc8b, 0xbde2,
    0x2e92, 0x3852, 0x2e92, 0xbadc, 0xb804, 0x39a6, 0x4152, 0xc4ac,
    0x39cd, 0xc09f, 0x3f54, 0xbee3, 0x3882, 0xbfe7, 0xbab8, 0xb485,
    0x42a6, 0x361d, 0xc10b, 0x3e03, 0x40dc, 0xbc91, 0x3826, 0x399d,
    0xc244, 0xb933, 0xbb88, 0x3ebf, 0x38fe, 0xb971, 0x40b0, 0x3f61,
    0xb8fc, 0xbca9, 0x2f16, 0x4131, 0xc0dd, 0xb412, 0xbab0, 0x3c3f,
    0x3ff0, 0xbabe, 0x2519, 0x37c3, 0xbe1e, 0xb862, 0xbffd, 0xc41f,
    0x3f40, 0xc238, 0x457c, 0xc00e, 0xa4b1, 0xbcbe, 0x3dd8, 0xbf54,
    0x359c, 0x4299, 0x3d5d, 0xb863, 0xb8b8, 0x3718, 0xbc56, 0xba18,
    0x41a2, 0x3775, 0xb327, 0xbcc2, 0x388c, 0xbed7, 0xb6a8, 0x354e,
    0x3bd4, 0xc2b0, 0x4050, 0xb5e6, 0x3607, 0x3773, 0xb842, 0xaea2,
    0xa8dd, 0x3bf3, 0x424f, 0xb97a, 0xb4bd, 0x3c22, 0x3cf7, 0x4117,
    0x3abd, 0xbd95, 0x3d3c, 0xb317, 0x2d14, 0xc08c, 0xc106, 0xade2,
    0x404e, 0xc15d, 0xc065, 0x41b9, 0xbe00, 0x415b, 0xbd09, 0x2ee3,
    0x40c4, 0x3d62, 0x3e94, 0xbef4, 0x41cd, 0xc025, 0xbb81, 0xb958,
    0xacef, 0x4246, 0x4361, 0xbc1e, 0x354f, 0xbf19, 0xbd61, 0x3485,
    0x3dbc, 0xbf5f, 0x3e2e, 0x40b3, 0xbadc, 0xbd20, 0xbe51, 0x3c19,
    0x3b6c, 0xc0b7, 0x2dd6, 0xc0a3, 0x35c3, 0xbc09, 0x3170, 0xba04,
    0xc281, 0x2e2f, 0xbe7b, 0xbe85, 0xba31, 0x3e58, 0xb99b, 0x3d54,
    0xbfdd, 0x3edc, 0x3fac, 0x3c37, 0xbd0b, 0xb9cb, 0x3490, 0xc1bf,
    0xbbf5, 0xa684, 0x3e12, 0xb613, 0xbc7b, 0x42e6, 0xb7b7, 0x4235,
    0xbe82, 0xac1c, 0x341f, 0xbdeb, 0x3c56, 0xb958, 0x3b4d, 0xbad1,
    0xb4dc, 0xc06c, 0xb69b, 0x3ed2, 0xb3b4, 0x3832, 0x4116, 0xbc1a,
    0x3279, 0x3e6f, 0xbcf5, 0xbd73, 0xc3fe, 0x414d, 0xb586, 0x3ca1,
    0x3e4c, 0xbc17, 0x321e, 0xaf38, 0x3ac4, 0x3b07, 0x384a, 0x42be,
    0xbcd0, 0x3979, 0x3719, 0x37cd, 0xb515, 0x3113, 0x40f3, 0x341a,
    0xbc3c, 0x3b07, 0x3630, 0xbff3, 0xb38e, 0xb87d, 0xb932, 0xc186,
    0xc0d0, 0x26e4, 0x32b9, 0x20c3, 0xbf82, 0x3b90, 0x3c9b, 0x3dbb,
    0xbb10, 0x35b5, 0xbaa9, 0xba0e, 0xb886, 0xb75f, 0xbe78, 0xb6b9,
    0x311d, 0x4301, 0xc36d, 0x3d80, 0xbf04, 0x3ca4, 0xbb0d, 0xc3aa,
    0xb175, 0x3af8, 0xc292, 0xb68b, 0x3ca0, 0x421a, 0x3f35, 0xb54c,
    0xbe96, 0xb357, 0xb828, 0x374e, 0xb031, 0x383c, 0xb767, 0x3867,
    0xc060, 0xbdd8, 0x3e73, 0x3bb2, 0x3e47, 0xbfd7, 0x35c6, 0xbae6,
    0x3f2a, 0x3c3a, 0xb2ca, 0xbd6e, 0x381c, 0x40b9, 0xb8ab, 0xbe0c,
    0xbe12, 0xc03e, 0xc10b, 0x40c4, 0x3ab1, 0x3aaf, 0xba0c, 0x3ecd,
    0xbb89, 0x3c11, 0xc09e, 0xbf61, 0xb89b, 0x3fe8, 0x3971, 0x3beb,
    0x2e73, 0xbece, 0x3df0, 0x3a1e, 0x3c90, 0xbc7e, 0x4083, 0xbdd7,
    0x2deb, 0xb44f, 0xb0f1, 0xb6b3, 0x326a, 0x3a1d, 0x2e13, 0xb977,
    0x35eb, 0xbbd0, 0xbd15, 0x3c61, 0x3b00, 0xbdf6, 0xc15a, 0x3d6f,
    0xbba7, 0x356b, 0x42b1, 0xb57d, 0xb865, 0x368b, 0x40ab, 0xb8c5,
    0x3d8a, 0xbb73, 0xbc4c, 0xc34a, 0x35c6, 0x3fc1, 0x4056, 0x30f5,
    0x38e3, 0x3b8b, 0xd2e, 0xc095, 0xc0d2, 0x3a83, 0x407b, 0x3c44,
    0x404a, 0xc07f, 0x28d3, 0xb8c6, 0xbf8f, 0xb79c, 0x32d7, 0xbf83,
    0xbe5d, 0xbbfe, 0x3bf2, 0x3c6c, 0xc1dc, 0xbc92, 0x3025, 0xc1a3,
    0xb586, 0x38c5, 0x3c3c, 0x4403, 0x337c, 0x3a79, 0x39d2, 0x3deb,
    0x36b3, 0x3ba3, 0x4113, 0xc0b9, 0xc13a, 0xb519, 0xbf6e, 0xbcc7,
    0xba2f, 0x3916, 0x3e25, 0x3543, 0xbc4c, 0xb6f9, 0xafb9, 0x3ff7,
    0x3e62, 0xb988, 0x3ad1, 0xbcad, 0xa5b8, 0x40b7, 0xc0c3, 0xc2a6,
    0x34e8, 0xc063, 0xb968, 0x3aa2, 0xbdb0, 0x2a9c, 0xbf11, 0x3947,
    0x3e51, 0x3f5a, 0xc279, 0x39d7, 0xbedc, 0xc0f6, 0xb606, 0xbef5,
    0xb38f, 0x414b, 0x3e29, 0xbd13, 0x3ebe, 0x33cc, 0xc1d6, 0xb070,
    0xbbac, 0xb029, 0xc4ca, 0x3f34, 0xbe5e, 0x332c, 0xa992, 0xac76,
    0x4030, 0xbdc5, 0xb9d1, 0x3883, 0xae36, 0xb4d0, 0x3d10, 0xc1af,
    0xbda2, 0xc116, 0x3c3a, 0x39a3, 0x402b, 0x42f9, 0xacbd, 0x386b,
    0x345e, 0x4169, 0xbbc1, 0x3d2b, 0x406d, 0x3b48, 0x3f5f, 0xbeab,
    0xbf57, 0x3a19, 0x3f84, 0xb3c9, 0x336e, 0x3b52, 0x3ddc, 0xb98f,
    0xb884, 0x3d00, 0xbd26, 0xb700, 0xb654, 0xb0a8, 0x397a, 0x3c61,
    0x39f0, 0x3a7d, 0x40d4, 0xbf9f, 0x4161, 0xbe72, 0x3d1d, 0xb99f,
    0xc075, 0xb87d, 0x417a, 0xb720, 0xb987, 0x3490, 0x2fc5, 0x3de3,
    0x3a14, 0xbf89, 0x3e26, 0xbfbb, 0x3f47, 0x41d1, 0xb619, 0xbbab,
    0x3d84, 0xb0a6, 0x34a5, 0x3461, 0xb45d, 0x3b3f, 0x3db6, 0xba40,
    0x32cc, 0xb82a, 0x3972, 0x3712, 0xbfa6, 0x3da9, 0xbff1, 0x3960,
    0xc1ed, 0xada4, 0x3cfe, 0x3c1e, 0xb6e4, 0x3acf, 0x400c, 0xc05d,
    0x3f1d, 0xaf4c, 0x3a89, 0xbbee, 0xbe3b, 0xbc49, 0x32b5, 0xb8c1,
    0xc22f, 0x3264, 0xafd3, 0xbb58, 0xbb52, 0x3a84, 0xb32c, 0x33c9,
    0xbe96, 0x3ed2, 0x3c16, 0xbe2a, 0x3ade, 0x3c14, 0x3e55, 0xbae8,
    0x3981, 0xbc8d, 0xc0f9, 0xbf15, 0x4122, 0x3bad, 0x43c2, 0x3ac6,
    0x3e92, 0xbdee, 0x3bb9, 0x3dd5, 0x3775, 0x42c5, 0xbcc1, 0xb580,
    0x3557, 0xa02c, 0x382c, 0x3d67, 0x407a, 0x37ee, 0xbd29, 0xb98d,
    0xb1cd, 0xbd6d, 0x40f5, 0xbd92, 0x2f23, 0x427c, 0xbe19, 0x3dc4,
    0x3bf9, 0xb547, 0xc1da, 0xb831, 0x3f10, 0x3b10, 0x3593, 0xc01f,
    0xbc44, 0x3aaf, 0xb6e6, 0xb331, 0xb55d, 0xba68, 0x347c, 0xbeb9,
    0xbe99, 0x3c38, 0xc25d, 0x4285, 0xb939, 0x3022, 0xc59a, 0x418a,
    0x3e69, 0xbbe5, 0xbae8, 0x3aa4, 0x42e2, 0x405c, 0xbf7d, 0x3e01,
    0x3fe7, 0x3a0a, 0x3f5a, 0x3c27, 0x3f42, 0xc00b, 0x28b3, 0xae9e,
    0x35b5, 0xc106, 0xb850, 0x3e28, 0xc216, 0x3c85, 0x420b, 0x3a23,
    0x441c, 0xc67d, 0x3f72, 0xbea9, 0x2e38, 0xbadd, 0xa482, 0xbc24,
    0x3502, 0xb666, 0x404c, 0xba29, 0x3fe8, 0x37ee, 0x3fdc, 0x3988,
    0xbc66, 0xc3c9, 0x4301, 0x3f37, 0xc426, 0x41a2, 0x3cf3, 0xb7b8,
    0xb465, 0x4059, 0xc12b, 0xbfaa, 0xbbaa, 0x3bb9, 0x3c41, 0x3d45,
    0xc0cf, 0x3e13, 0xa56c, 0x39b0, 0x3095, 0x3847, 0x3a9a, 0xbb3d,
    0x34d9, 0x3e38, 0x3e38, 0x427f, 0x3bdb, 0xbb86, 0xb735, 0x3ae0,
    0xb51e, 0xb3b0, 0x40e9, 0xbb0a, 0x410b, 0xb920, 0xbcb7, 0x3b95,
    0xb4ba, 0xbdb4, 0x3028, 0x409b, 0x3aaf, 0xbc24, 0x3be0, 0x419f,
    0x3f3a, 0xbe64, 0xb0de, 0x33f0, 0xb7a5, 0xb4fd, 0xb839, 0xbde0,
    0x2301, 0xc11b, 0x3a93, 0x3772, 0xbd0a, 0xc060, 0x397b, 0x38b1,
    0xbc61, 0x3ee0, 0xba4c, 0xbe47, 0x355e, 0x30b2, 0xbad9, 0x407f,
    0xc250, 0x39f2, 0x3f0b, 0xba0c, 0x3976, 0xbec7, 0x402e, 0x3dd8,
    0x3323, 0x38bd, 0xb6dc, 0xb7c7, 0xb863, 0xbcd2, 0xbc5d, 0x3bbe,
    0x3921, 0x396b, 0xb8e0, 0x34c0, 0x33ce, 0x3963, 0x31dc, 0xbd43,
    0xbb4d, 0xb9c6, 0x374f, 0xbe12, 0x3d79, 0x3a18, 0x3e71, 0x36b9,
    0xba62, 0x3f0a, 0xbe20, 0xc1e1, 0xc1df, 0x40bf, 0x35f7, 0xba6a,
    0x3d35, 0xbab2, 0x3ce4, 0x2c94, 0x3784, 0x4035, 0xbe64, 0xbb9b,
    0xbe1b, 0x409e, 0x3b56, 0x33d6, 0x3c33, 0x34cf, 0x3fd5, 0xc345,
    0xc0b0, 0xbd8b, 0x36aa, 0x4157, 0x2916, 0x4054, 0x3ed6, 0xbc22,
    0x32fd, 0xc070, 0xb9ca, 0x3eb7, 0x3e98, 0x35ca, 0x3e7e, 0x3e4d,
    0x4048, 0xb856, 0x417e, 0x44e9, 0xbc9a, 0xc043, 0xbd4d, 0xc254,
    0xbc1e, 0xbf45, 0x27d0, 0xc0ab, 0x4324, 0x331e, 0xbe59, 0xc1d7,
    0xc1b4, 0xbf67, 0x37e1, 0xacce, 0xbcbd, 0x3a58, 0x38d3, 0xb959,
    0xc30c, 0x3595, 0x4152, 0x427f, 0xc13e, 0xc408, 0x3d26, 0x3a4f,
    0xbc13, 0x3c65, 0x40c8, 0xbd7d, 0x35a5, 0xc05d, 0x3e4c, 0xa591,
    0xbf47, 0xbd0c, 0xbff0, 0xbb40, 0x38dc, 0xb41b, 0xc220, 0x42ea,
    0xc196, 0x2def, 0xb4dd, 0x4106, 0x3041, 0x3c32, 0xb286, 0xbd3e,
    0xb5dd, 0x38d8, 0xad0a, 0xbad0, 0x3ef6, 0x3ca1, 0x3257, 0x3d5b,
    0x40e3, 0x41d0, 0x3954, 0xba9a, 0xb189, 0xc156, 0xb633, 0x327e,
    0xb98d, 0x2b44, 0x412b, 0xa47c, 0x3913, 0xad8a, 0xb978, 0x3b46,
    0x3a79, 0xb7f8, 0xb2ee, 0xb4d4, 0xb5a7, 0x3e82, 0xbb53, 0xbc41,
    0x3c1b, 0x40af, 0xb358, 0x43d9, 0x3db3, 0xb57e, 0x3cca, 0xb35d,
    0xbc52, 0xbd99, 0x3d45, 0x32d5, 0x146a, 0x3f34, 0x38fc, 0x30e8,
    0x3520, 0xc312, 0x3d13, 0x3b0f, 0xbaa5, 0x416a, 0xb741, 0xa912,
    0x3477, 0xbeb1, 0x42c8, 0xb7f8, 0x3b38, 0x3826, 0x31ba, 0xbfb2,
    0xb644, 0xc0c3, 0x365f, 0x404a, 0xc04f, 0x3ecf, 0xb653, 0x37c0,
    0xbe42, 0xbe83, 0x39b9, 0xbc32, 0x36bb, 0xb3c5, 0x3a93, 0xb9d1,
    0x43f5, 0x4056, 0x3e75, 0x3af6, 0xbecf, 0xb48b, 0x3c25, 0xc1a1,
    0xc08b, 0xc0fe, 0x4052, 0x1988, 0x41e4, 0xbd66, 0x3a15, 0xbd8f,
    0xbb52, 0x3deb, 0x3596, 0xc28f, 0x3858, 0xbf9d, 0x38a4, 0x3b8a,
    0xb53f, 0x3c6d, 0x37a8, 0xbe7b, 0xbe03, 0x3aab, 0x3972, 0x405a,
    0xbaaa, 0xae56, 0xbf14, 0x3705, 0xb064, 0x34a4, 0xba34, 0x3c57,
    0xac3d, 0x41b9, 0x3e91, 0x3a23, 0x2e8f, 0x37a7, 0x3f49, 0x37f4,
    0x3853, 0x3f01, 0x3fb3, 0x3a7a, 0xaeba, 0x312e, 0x4116, 0xc040,
    0x3ef4, 0xbd96, 0x3ed5, 0x3754, 0x3a23, 0xba04, 0xb6c2, 0x4090,
    0xc33f, 0xbc49, 0xc368, 0x3bf0, 0x3fb3, 0xba83, 0xc1f4, 0xbdfb,
    0xa910, 0xb8bf, 0x3fdf, 0x38b6, 0x447f, 0xc1ea, 0xba78, 0xc034,
    0xc16f, 0x391e, 0xbf54, 0xbc67, 0xbacc, 0x3fb9, 0x4051, 0x3879,
    0xb6c8, 0xc04d, 0xbc5b, 0xa30b, 0xbf2e, 0x3b87, 0x4048, 0xb640,
    0x3b0d, 0x0, 0x4048, 0x3640, 0xbf2e, 0xbb87, 0xbc5b, 0x230b,
    0xb6c8, 0x404d, 0x4051, 0xb879, 0xbacc, 0xbfb9, 0xbf54, 0x3c67,
    0xc16f, 0xb91e, 0xba78, 0x4034, 0x447f, 0x41ea, 0x3fdf, 0xb8b6,
    0xa910, 0x38bf, 0xc1f4, 0x3dfb, 0x3fb3, 0x3a83, 0xc368, 0xbbf0,
    0xc33f, 0x3c49, 0xb6c2, 0xc090, 0x3a23, 0x3a04, 0x3ed5, 0xb754,
    0x3ef4, 0x3d96, 0x4116, 0x4040, 0xaeba, 0xb12e, 0x3fb3, 0xba7a,
    0x3853, 0xbf01, 0x3f49, 0xb7f4, 0x2e8f, 0xb7a7, 0x3e91, 0xba23,
    0xac3d, 0xc1b9, 0xba34, 0xbc57, 0xb064, 0xb4a4, 0xbf14, 0xb705,
    0xbaaa, 0x2e56, 0x3972, 0xc05a, 0xbe03, 0xbaab, 0x37a8, 0x3e7b,
    0xb53f, 0xbc6d, 0x38a4, 0xbb8a, 0x3858, 0x3f9d, 0x3596, 0x428f,
    0xbb52, 0xbdeb, 0x3a15, 0x3d8f, 0x41e4, 0x3d66, 0x4052, 0x9988,
    0xc08b, 0x40fe, 0x3c25, 0x41a1, 0xbecf, 0x348b, 0x3e75, 0xbaf6,
    0x43f5, 0xc056, 0x3a93, 0x39d1, 0x36bb, 0x33c5, 0x39b9, 0x3c32,
    0xbe42, 0x3e83, 0xb653, 0xb7c0, 0xc04f, 0xbecf, 0x365f, 0xc04a,
    0xb644, 0x40c3, 0x31ba, 0x3fb2, 0x3b38, 0xb826, 0x42c8, 0x37f8,
    0x3477, 0x3eb1, 0xb741, 0x2912, 0xbaa5, 0xc16a, 0x3d13, 0xbb0f,
    0x3520, 0x4312, 0x38fc, 0xb0e8, 0x146a, 0xbf34, 0x3d45, 0xb2d5,
    0xbc52, 0x3d99, 0x3cca, 0x335d, 0x3db3, 0x357e, 0xb358, 0xc3d9,
    0x3c1b, 0xc0af, 0xbb53, 0x3c41, 0xb5a7, 0xbe82, 0xb2ee, 0x34d4,
    0x3a79, 0x37f8, 0xb978, 0xbb46, 0x3913, 0x2d8a, 0x412b, 0x247c,
    0xb98d, 0xab44, 0xb633, 0xb27e, 0xb189, 0x4156, 0x3954, 0x3a9a,
    0x40e3, 0xc1d0, 0x3257, 0xbd5b, 0x3ef6, 0xbca1, 0xad0a, 0x3ad0,
    0xb5dd, 0xb8d8, 0xb286, 0x3d3e, 0x3041, 0xbc32, 0xb4dd, 0xc106,
    0xc196, 0xadef, 0xc220, 0xc2ea, 0x38dc, 0x341b, 0xbff0, 0x3b40,
    0xbf47, 0x3d0c, 0x3e4c, 0x2591, 0x35a5, 0x405d, 0x40c8, 0x3d7d,
    0xbc13, 0xbc65, 0x3d26, 0xba4f, 0xc13e, 0x4408, 0x4152, 0xc27f,
    0xc30c, 0xb595, 0x38d3, 0x3959, 0xbcbd, 0xba58, 0x37e1, 0x2cce,
    0xc1b4, 0x3f67, 0xbe59, 0x41d7, 0x4324, 0xb31e, 0x27d0, 0x40ab,
    0xbc1e, 0x3f45, 0xbd4d, 0x4254, 0xbc9a, 0x4043, 0x417e, 0xc4e9,
    0x4048, 0x3856, 0x3e7e, 0xbe4d, 0x3e98, 0xb5ca, 0xb9ca, 0xbeb7,
    0x32fd, 0x4070, 0x3ed6, 0x3c22, 0x2916, 0xc054, 0x36aa, 0xc157,
    0xc0b0, 0x3d8b, 0x3fd5, 0x4345, 0x3c33, 0xb4cf, 0x3b56, 0xb3d6,
    0xbe1b, 0xc09e, 0xbe64, 0x3b9b, 0x3784, 0xc035, 0x3ce4, 0xac94,
    0x3d35, 0x3ab2, 0x35f7, 0x3a6a, 0xc1df, 0xc0bf, 0xbe20, 0x41e1,
    0xba62, 0xbf0a, 0x3e71, 0xb6b9, 0x3d79, 0xba18, 0x374f, 0x3e12,
    0xbb4d, 0x39c6, 0x31dc, 0x3d43, 0x33ce, 0xb963, 0xb8e0, 0xb4c0,
    0x3921, 0xb96b, 0xbc5d, 0xbbbe, 0xb863, 0x3cd2, 0xb6dc, 0x37c7,
    0x3323, 0xb8bd, 0x402e, 0xbdd8, 0x3976, 0x3ec7, 0x3f0b, 0x3a0c,
    0xc250, 0xb9f2, 0xbad9, 0xc07f, 0x355e, 0xb0b2, 0xba4c, 0x3e47,
    0xbc61, 0xbee0, 0x397b, 0xb8b1, 0xbd0a, 0x4060, 0x3a93, 0xb772,
    0x2301, 0x411b, 0xb839, 0x3de0, 0xb7a5, 0x34fd, 0xb0de, 0xb3f0,
    0x3f3a, 0x3e64, 0x3be0, 0xc19f, 0x3aaf, 0x3c24, 0x3028, 0xc09b,
    0xb4ba, 0x3db4, 0xbcb7, 0xbb95, 0x410b, 0x3920, 0x40e9, 0x3b0a,
    0xb51e, 0x33b0, 0xb735, 0xbae0, 0x3bdb, 0x3b86, 0x3e38, 0xc27f,
    0x34d9, 0xbe38, 0x3a9a, 0x3b3d, 0x3095, 0xb847, 0xa56c, 0xb9b0,
    0xc0cf, 0xbe13, 0x3c41, 0xbd45, 0xbbaa, 0xbbb9, 0xc12b, 0x3faa,
    0xb465, 0xc059, 0x3cf3, 0x37b8, 0xc426, 0xc1a2, 0x4301, 0xbf37,
    0xbc66, 0x43c9, 0x3fdc, 0xb988, 0x3fe8, 0xb7ee, 0x404c, 0x3a29,
    0x3502, 0x3666, 0xa482, 0x3c24, 0x2e38, 0x3add, 0x3f72, 0x3ea9,
    0x441c, 0x467d, 0x420b, 0xba23, 0xc216, 0xbc85, 0xb850, 0xbe28,
    0x35b5, 0x4106, 0x28b3, 0x2e9e, 0x3f42, 0x400b, 0x3f5a, 0xbc27,
    0x3fe7, 0xba0a, 0xbf7d, 0xbe01, 0x42e2, 0xc05c, 0xbae8, 0xbaa4,
    0x3e69, 0x3be5, 0xc59a, 0xc18a, 0xb939, 0xb022, 0xc25d, 0xc285,
    0xbe99, 0xbc38, 0x347c, 0x3eb9, 0xb55d, 0x3a68, 0xb6e6, 0x3331,
    0xbc44, 0xbaaf, 0x3593, 0x401f, 0x3f10, 0xbb10, 0xc1da, 0x3831,
    0x3bf9, 0x3547, 0xbe19, 0xbdc4, 0x2f23, 0xc27c, 0x40f5, 0x3d92,
    0xb1cd, 0x3d6d, 0xbd29, 0x398d, 0x407a, 0xb7ee, 0x382c, 0xbd67,
    0x3557, 0x202c, 0xbcc1, 0x3580, 0x3775, 0xc2c5, 0x3bb9, 0xbdd5,
    0x3e92, 0x3dee, 0x43c2, 0xbac6, 0x4122, 0xbbad, 0xc0f9, 0x3f15,
    0x3981, 0x3c8d, 0x3e55, 0x3ae8, 0x3ade, 0xbc14, 0x3c16, 0x3e2a,
    0xbe96, 0xbed2, 0xb32c, 0xb3c9, 0xbb52, 0xba84, 0xafd3, 0x3b58,
    0xc22f, 0xb264, 0x32b5, 0x38c1, 0xbe3b, 0x3c49, 0x3a89, 0x3bee,
    0x3f1d, 0x2f4c, 0x400c, 0x405d, 0xb6e4, 0xbacf, 0x3cfe, 0xbc1e,
    0xc1ed, 0x2da4, 0xbff1, 0xb960, 0xbfa6, 0xbda9, 0x3972, 0xb712,
    0x32cc, 0x382a, 0x3db6, 0x3a40, 0xb45d, 0xbb3f, 0x34a5, 0xb461,
    0x3d84, 0x30a6, 0xb619, 0x3bab, 0x3f47, 0xc1d1, 0x3e26, 0x3fbb,
    0x3a14, 0x3f89, 0x2fc5, 0xbde3, 0xb987, 0xb490, 0x417a, 0x3720,
    0xc075, 0x387d, 0x3d1d, 0x399f, 0x4161, 0x3e72, 0x40d4, 0x3f9f,
    0x39f0, 0xba7d, 0x397a, 0xbc61, 0xb654, 0x30a8, 0xbd26, 0x3700,
    0xb884, 0xbd00, 0x3ddc, 0x398f, 0x336e, 0xbb52, 0x3f84, 0x33c9,
    0xbf57, 0xba19, 0x3f5f, 0x3eab, 0x406d, 0xbb48, 0xbbc1, 0xbd2b,
    0x345e, 0xc169, 0xacbd, 0xb86b, 0x402b, 0xc2f9, 0x3c3a, 0xb9a3,
    0xbda2, 0x4116, 0x3d10, 0x41af, 0xae36, 0x34d0, 0xb9d1, 0xb883,
    0x4030, 0x3dc5, 0xa992, 0x2c76, 0xbe5e, 0xb32c, 0xc4ca, 0xbf34,
    0xbbac, 0x3029, 0xc1d6, 0x3070, 0x3ebe, 0xb3cc, 0x3e29, 0x3d13,
    0xb38f, 0xc14b, 0xb606, 0x3ef5, 0xbedc, 0x40f6, 0xc279, 0xb9d7,
    0x3e51, 0xbf5a, 0xbf11, 0xb947, 0xbdb0, 0xaa9c, 0xb968, 0xbaa2,
    0x34e8, 0x4063, 0xc0c3, 0x42a6, 0xa5b8, 0xc0b7, 0x3ad1, 0x3cad,
    0x3e62, 0x3988, 0xafb9, 0xbff7, 0xbc4c, 0x36f9, 0x3e25, 0xb543,
    0xba2f, 0xb916, 0xbf6e, 0x3cc7, 0xc13a, 0x3519, 0x4113, 0x40b9,
    0x36b3, 0xbba3, 0x39d2, 0xbdeb, 0x337c, 0xba79, 0x3c3c, 0xc403,
    0xb586, 0xb8c5, 0x3025, 0x41a3, 0xc1dc, 0x3c92, 0x3bf2, 0xbc6c,
    0xbe5d, 0x3bfe, 0x32d7, 0x3f83, 0xbf8f, 0x379c, 0x28d3, 0x38c6,
    0x404a, 0x407f, 0x407b, 0xbc44, 0xc0d2, 0xba83, 0xd2e, 0x4095,
    0x38e3, 0xbb8b, 0x4056, 0xb0f5, 0x35c6, 0xbfc1, 0xbc4c, 0x434a,
    0x3d8a, 0x3b73, 0x40ab, 0x38c5, 0xb865, 0xb68b, 0x42b1, 0x357d,
    0xbba7, 0xb56b, 0xc15a, 0xbd6f, 0x3b00, 0x3df6, 0xbd15, 0xbc61,
    0x35eb, 0x3bd0, 0x2e13, 0x3977, 0x326a, 0xba1d, 0xb0f1, 0x36b3,
    0x2deb, 0x344f, 0x4083, 0x3dd7, 0x3c90, 0x3c7e, 0x3df0, 0xba1e,
    0x2e73, 0x3ece, 0x3971, 0xbbeb, 0xb89b, 0xbfe8, 0xc09e, 0x3f61,
    0xbb89, 0xbc11, 0xba0c, 0xbecd, 0x3ab1, 0xbaaf, 0xc10b, 0xc0c4,
    0xbe12, 0x403e, 0xb8ab, 0x3e0c, 0x381c, 0xc0b9, 0xb2ca, 0x3d6e,
    0x3f2a, 0xbc3a, 0x35c6, 0x3ae6, 0x3e47, 0x3fd7, 0x3e73, 0xbbb2,
    0xc060, 0x3dd8, 0xb767, 0xb867, 0xb031, 0xb83c, 0xb828, 0xb74e,
    0xbe96, 0x3357, 0x3f35, 0x354c, 0x3ca0, 0xc21a, 0xc292, 0x368b,
    0xb175, 0xbaf8, 0xbb0d, 0x43aa, 0xbf04, 0xbca4, 0xc36d, 0xbd80,
    0x311d, 0xc301, 0xbe78, 0x36b9, 0xb886, 0x375f, 0xbaa9, 0x3a0e,
    0xbb10, 0xb5b5, 0x3c9b, 0xbdbb, 0xbf82, 0xbb90, 0x32b9, 0xa0c3,
    0xc0d0, 0xa6e4, 0xb932, 0x4186, 0xb38e, 0x387d, 0x3630, 0x3ff3,
    0xbc3c, 0xbb07, 0x40f3, 0xb41a, 0xb515, 0xb113, 0x3719, 0xb7cd,
    0xbcd0, 0xb979, 0x384a, 0xc2be, 0x3ac4, 0xbb07, 0x321e, 0x2f38,
    0x3e4c, 0x3c17, 0xb586, 0xbca1, 0xc3fe, 0xc14d, 0xbcf5, 0x3d73,
    0x3279, 0xbe6f, 0x4116, 0x3c1a, 0xb3b4, 0xb832, 0xb69b, 0xbed2,
    0xb4dc, 0x406c, 0x3b4d, 0x3ad1, 0x3c56, 0x3958, 0x341f, 0x3deb,
    0xbe82, 0x2c1c, 0xb7b7, 0xc235, 0xbc7b, 0xc2e6, 0x3e12, 0x3613,
    0xbbf5, 0x2684, 0x3490, 0x41bf, 0xbd0b, 0x39cb, 0x3fac, 0xbc37,
    0xbfdd, 0xbedc, 0xb99b, 0xbd54, 0xba31, 0xbe58, 0xbe7b, 0x3e85,
    0xc281, 0xae2f, 0x3170, 0x3a04, 0x35c3, 0x3c09, 0x2dd6, 0x40a3,
    0x3b6c, 0x40b7, 0xbe51, 0xbc19, 0xbadc, 0x3d20, 0x3e2e, 0xc0b3,
    0x3dbc, 0x3f5f, 0xbd61, 0xb485, 0x354f, 0x3f19, 0x4361, 0x3c1e,
    0xacef, 0xc246, 0xbb81, 0x3958, 0x41cd, 0x4025, 0x3e94, 0x3ef4,
    0x40c4, 0xbd62, 0xbd09, 0xaee3, 0xbe00, 0xc15b, 0xc065, 0xc1b9,
    0x404e, 0x415d, 0xc106, 0x2de2, 0x2d14, 0x408c, 0x3d3c, 0x3317,
    0x3abd, 0x3d95, 0x3cf7, 0xc117, 0xb4bd, 0xbc22, 0x424f, 0x397a,
    0xa8dd, 0xbbf3, 0xb842, 0x2ea2, 0x3607, 0xb773, 0x4050, 0x35e6,
    0x3bd4, 0x42b0, 0xb6a8, 0xb54e, 0x388c, 0x3ed7, 0xb327, 0x3cc2,
    0x41a2, 0xb775, 0xbc56, 0x3a18, 0xb8b8, 0xb718, 0x3d5d, 0x3863,
    0x359c, 0xc299, 0x3dd8, 0x3f54, 0xa4b1, 0x3cbe, 0x457c, 0x400e,
    0x3f40, 0x4238, 0xbffd, 0x441f, 0xbe1e, 0x3862, 0x2519, 0xb7c3,
    0x3ff0, 0x3abe, 0xbab0, 0xbc3f, 0xc0dd, 0x3412, 0x2f16, 0xc131,
    0xb8fc, 0x3ca9, 0x40b0, 0xbf61, 0x38fe, 0x3971, 0xbb88, 0xbebf,
    0xc244, 0x3933, 0x3826, 0xb99d, 0x40dc, 0x3c91, 0xc10b, 0xbe03,
    0x42a6, 0xb61d, 0xbab8, 0x3485, 0x3882, 0x3fe7, 0x3f54, 0x3ee3,
    0x39cd, 0x409f, 0x4152, 0x44ac, 0xb804, 0xb9a6, 0x2e92, 0x3adc,
    0x2e92, 0xb852, 0xbc8b, 0x3de2, 0xbff2, 0xbcdc, 0xade3, 0x3eb6,
    0x3599, 0xbc01, 0x2f13, 0x3868, 0x39d0, 0x4426, 0x1870, 0x3658,
    0xb854, 0x3539, 0x3070, 0x3e49, 0xbda3, 0x33b0, 0xbadf, 0x3add,
    0x426d, 0x3ba9, 0xbb27, 0x4041, 0x372e, 0x3abb, 0xb8a6, 0x4203,
    0x3965, 0xbca4, 0xbb35, 0xba4c, 0xc304, 0x3c04, 0xbb47, 0xbe8e,
    0xb972, 0x3a3a, 0x3d03, 0x40db, 0xb97b, 0x40b3, 0xbeec, 0x3203,
    0x3f65, 0x3e61, 0xadf0, 0xc1ae, 0x3aed, 0xbca9, 0xbc79, 0x34dc,
    0xc3cc, 0x4063, 0x3af4, 0x3e20, 0xbddc, 0x299a, 0x2e0f, 0x3483,
    0x2422, 0xc410, 0x40d1, 0xc13b, 0xc1b2, 0xbfa7, 0xb4fc, 0x3cb3,
    0xac14, 0x3978, 0x409f, 0x429a, 0xbe19, 0xc36f, 0xbcd7, 0x3b99,
    0xb4ed, 0x4106, 0xbd64, 0xbf9a, 0x3d10, 0xbb2c, 0xbdc0, 0xc1f8,
    0x3471, 0x3bfb, 0xb6ea, 0xc100, 0x3d4f, 0xbde5, 0x3d26, 0xbcd6,
    0x3b92, 0x3062, 0xbc57, 0x3c87, 0x31ad, 0xc295, 0x4176, 0x40d4,
    0x39c0, 0x40aa, 0x3c45, 0x353c, 0xb6b4, 0xb30d, 0xb697, 0x3d3d,
    0xb434, 0x351e, 0x40ae, 0x38aa, 0x40a9, 0x3e04, 0x3711, 0xbc28,
    0xba9e, 0x3597, 0xb0fe, 0x3a43, 0x36d0, 0x3b21, 0x3c6e, 0x3f69,
    0xc22a, 0xbc74, 0xc07b, 0x38a3, 0x3698, 0xb777, 0xbc14, 0x3ed2,
    0xbc2b, 0xbc83, 0xaee9, 0xb71c, 0x426d, 0x2440, 0x40cc, 0x3e65,
    0x3faf, 0x355a, 0xb91e, 0xb60a, 0xbf22, 0x408f, 0xc104, 0x3c87,
    0x3fe3, 0x2f4e, 0xbedb, 0x3bc4, 0x2110, 0xc012, 0xc08d, 0x3dc9,
    0x3bc3, 0x298c, 0x425a, 0xbf8f, 0xc035, 0xafbe, 0xb9c1, 0xc1ae,
    0x40c7, 0x40dc, 0x4363, 0xbd27, 0x38b7, 0x3704, 0xb27d, 0xc14c,
    0xc249, 0xbc8d, 0xb8c4, 0xbdc9, 0xbdcc, 0x4206, 0x3ff7, 0x39c4,
    0x3855, 0x4006, 0xa652, 0x3c76, 0xbc07, 0x3cb2, 0xc2eb, 0xbac4,
    0xb89b, 0xbf21, 0xc2ad, 0x3eef, 0x392e, 0xb81f, 0xbafc, 0xbc18,
    0xc06d, 0xb908, 0x3d2b, 0xbb6a, 0xb9e5, 0x3c33, 0x2cba, 0xb18e,
    0x3dbb, 0xbc0d, 0xc0da, 0xbd7f, 0x3873, 0x3c7e, 0x3450, 0x3dbb,
    0xbed5, 0xb11c, 0x4065, 0x3eb9, 0x30f6, 0xc2b4, 0x3d54, 0xbaf0,
    0x9fa2, 0x3189, 0xb897, 0xbbb8, 0x4017, 0xbd9f, 0x3f46, 0x3c01,
    0x4125, 0x3e6a, 0xbd1c, 0xbef8, 0x3973, 0xa89e, 0xb8fe, 0xbb13,
    0x416f, 0x3254, 0x40d2, 0x3c59, 0x3014, 0x3769, 0x39e0, 0xb85e,
    0xc41e, 0x3f3b, 0x3709, 0x3faa, 0x350d, 0x3a31, 0x3ab5, 0x3b77,
    0xbee5, 0xbd03, 0x3d4f, 0x3e55, 0x3d9b, 0xb9ee, 0xb9b8, 0x3d6a,
    0x39d3, 0xb795, 0xbd9b, 0xb8d9, 0xc318, 0x38fc, 0xc021, 0xabee,
    0x3be2, 0x3700, 0x3ae1, 0xc0b9, 0xbabe, 0x400d, 0x4417, 0xbc29,
    0x3e04, 0x3c0b, 0x3a9b, 0xb6a3, 0x4041, 0x36c5, 0x3eb3, 0x3f4e,
    0x41ed, 0x2f34, 0x3cb5, 0xbebe, 0xc013, 0xb64a, 0x42f5, 0x35fe,
    0x3813, 0xbb1a, 0x3cd5, 0xbd6b, 0xc126, 0x3c0b, 0xba57, 0x41a9,
    0x3b3a, 0x361e, 0xbacc, 0x346b, 0x40a6, 0xbd01, 0x3a39, 0xb6ce,
    0x3292, 0xbe90, 0xa042, 0x404f, 0x34ba, 0xbc9f, 0xc39a, 0xba17,
    0x3ff9, 0xbe1d, 0xbdeb, 0xbf44, 0xb902, 0x3ac1, 0x41f0, 0x3af4,
    0x4144, 0x4025, 0xbd98, 0xb25f, 0xb166, 0x3d50, 0x2c73, 0xbba6,
    0xbc3d, 0x40da, 0xbb38, 0xbbb2, 0x3dcf, 0x3cb2, 0xb14f, 0xc23b,
    0xbf98, 0x4000, 0xb9ec, 0x3a30, 0x3f62, 0x343a, 0x3e5e, 0x34d3,
    0xc389, 0xbcac, 0x3b19, 0xb944, 0xb02b, 0xb9cd, 0x3550, 0xbc62,
    0xbfb6, 0x387d, 0x3e78, 0xbe10, 0xb032, 0xb8ed, 0xb4ca, 0x3ec9,
    0x41d0, 0x40f6, 0xb333, 0x4156, 0xc178, 0x3e7b, 0x3ade, 0x393a,
    0x3600, 0xbc72, 0xbcf8, 0x420e, 0x382c, 0x3ec1, 0x40bf, 0xbf55,
    0x3bd3, 0xbf3a, 0x3e25, 0x3428, 0xbeb1, 0x3e42, 0xbd99, 0xb981,
    0xbdec, 0xbc11, 0xbfa8, 0xad71, 0xbca2, 0xba27, 0xbf7d, 0x3ef8,
    0x37fb, 0x407f, 0xbec2, 0x33c4, 0xbfab, 0xbf27, 0x33db, 0x3ef6,
    0xc02f, 0x3e01, 0x3a20, 0xb252, 0xbb8c, 0xb803, 0x3a86, 0x4151,
    0xbc21, 0x2ff2, 0xc096, 0x386e, 0x3c6e, 0x4096, 0xbf5f, 0xc0e2,
    0xb92e, 0xb354, 0xbc6c, 0x4117, 0xb488, 0x4050, 0xc2aa, 0x29a7,
    0xc024, 0x3ac3, 0x400a, 0xbb13, 0x39c2, 0xb855, 0xb623, 0xbb29,
    0x3df5, 0x35d5, 0xbcf6, 0xbcdb, 0xbc68, 0x32f4, 0xba7e, 0xc003,
    0xbe70, 0xbb79, 0x4193, 0xb55d, 0x3eef, 0xc0ea, 0xb5ac, 0x4389,
    0x3825, 0x3a04, 0x407b, 0xbc82, 0x26c2, 0x3ab9, 0xb467, 0x3f56,
    0x3ff8, 0xbcc5, 0x3a71, 0x3cb3, 0x3a71, 0x4022, 0xbffd, 0x37ba,
    0x3eb1, 0xbc4f, 0xb7eb, 0xbbcf, 0xb5f8, 0x3afd, 0xc074, 0x4024,
    0xb81a, 0xc26b, 0x3e62, 0xad59, 0xb434, 0x3fb5, 0xb690, 0x3eeb,
    0x3709, 0xc280, 0x357e, 0xb598, 0x3aec, 0xbf6e, 0xb4d2, 0x2b4c,
    0x345a, 0xbe95, 0x3818, 0xc151, 0x3a52, 0x31e6, 0x389e, 0xb7d1,
    0xbbaf, 0x345c, 0x3bb0, 0xbac1, 0xba14, 0xbdbe, 0xc218, 0x35d8,
    0xb975, 0xbcfd, 0x2c99, 0xa3fc, 0xb09f, 0x3e75, 0x42c1, 0xc11c,
    0xbded, 0xbee7, 0x3ddf, 0x3980, 0x3c03, 0x34ad, 0xbe0b, 0x38e7,
    0xbe65, 0xc0b2, 0xbc9b, 0x4549, 0x3d54, 0xbf45, 0x3b26, 0x2dee,
    0x410e, 0xbeca, 0xadee, 0xbfe3, 0xbb60, 0xc3f4, 0xb684, 0xbcae,
    0x38bd, 0x619b, 0xc247, 0xbdef, 0x3446, 0x41bf, 0x3822, 0x4058,
    0x3ea0, 0x3c2e, 0xb829, 0x3dd1, 0xb955, 0x4088, 0x2cba, 0xc19c,
    0x31d7, 0xc3e0, 0x3ea2, 0xbee8, 0xb5be, 0xbc4a, 0xbc91, 0xbdd9,
    0xb40f, 0xb882, 0x4100, 0x3b61, 0x3518, 0x4225, 0xae73, 0xb752,
    0xb89f, 0x2c1a, 0x3cba, 0x3c5c, 0x3b67, 0xa403, 0x3c80, 0x3d75,
    0x3f14, 0x396d, 0x4011, 0x3e42, 0x3eba, 0xbdbc, 0x3948, 0x3c55,
    0x3d16, 0x3550, 0x345f, 0xc14f, 0xbc21, 0xbcea, 0xc02d, 0xbd51,
    0xbf3a, 0x3e0b, 0xbc07, 0xb5d7, 0x3af4, 0x3fc9, 0xbe9c, 0x3da4,
    0xc0ce, 0xbcc7, 0xb9c9, 0xc128, 0xbe99, 0x33af, 0x34da, 0x3627,
    0x3c1d, 0xbd5b, 0x3d83, 0xba50, 0xbb2c, 0x28e3, 0x39f1, 0xbdee,
    0x38dc, 0xb5e3, 0x3aa7, 0x32c8, 0x4074, 0x4149, 0xc139, 0x3c5e,
    0x410a, 0xbfeb, 0xc09b, 0x36ab, 0x3f56, 0xbb11, 0xa919, 0xb97c,
    0xb3f8, 0xba75, 0xb57d, 0x3faa, 0x4082, 0xbf63, 0x3a64, 0x3aae,
    0x4111, 0x3f16, 0xc2d5, 0xac95, 0xc0f6, 0xb859, 0xbef6, 0xbe43,
    0x3ad8, 0xc0c3, 0x368b, 0xbdd3, 0x40d8, 0xc1e7, 0x3fcb, 0x407b,
    0xbbd3, 0xbecf, 0x4034, 0x3de8, 0x209c, 0x2e16, 0xbf7e, 0x3d33,
    0xbdc2, 0xb9ec, 0xb4d8, 0x3faa, 0xbd54, 0x3d21, 0xb440, 0x3eb1,
    0xb00f, 0xbc48, 0xbf39, 0x4118, 0x3412, 0xc093, 0xb657, 0x3698,
    0xbdb8, 0x427f, 0xb93a, 0xbddf, 0xbac1, 0x3dcc, 0x3660, 0x3713,
    0xbd66, 0x38a4, 0xaf6b, 0x381f, 0xbb47, 0x3c13, 0x3ba6, 0xb391,
    0x3b16, 0xb9fa, 0x3e7e, 0x3a5b, 0xb25d, 0x3c69, 0xb807, 0xb8fb,
    0x4053, 0xb944, 0xc1bf, 0x380e, 0x3c36, 0x38ee, 0x3ca6, 0xc08c,
    0x3d44, 0xc352, 0x3b44, 0x4126, 0xc130, 0xc460, 0x40b3, 0xb752,
    0xafba, 0x3e9a, 0x33ff, 0x39d9, 0x36c5, 0x2775, 0x436d, 0x3be2,
    0x3e0c, 0xafde, 0xb85e, 0xbb7b, 0xc127, 0xc003, 0x2e38, 0xbc38,
    0xc126, 0xbaf0, 0x3979, 0xbc2c, 0x3a95, 0x403b, 0xb967, 0x3c83,
    0xb601, 0x3a69, 0xb5ed, 0xae8c, 0xbdeb, 0x41d8, 0x3b91, 0xbc65,
    0xbc0a, 0xb8f1, 0xbbd3, 0x283e, 0xba88, 0x3eed, 0xc13f, 0x3c3d,
    0x35a9, 0xb9de, 0xbe1a, 0x42a2, 0xc1cf, 0x3de8, 0xbcc9, 0xc302,
    0xbe58, 0x3d2d, 0xbff1, 0xbcca, 0x3838, 0x42d0, 0xbada, 0x3f51,
    0x40b2, 0xc0da, 0x3d14, 0x34ee, 0xb967, 0x3635, 0x37c3, 0xbc98,
    0x18ea, 0x3aea, 0x3fc8, 0x35a5, 0xbf88, 0xb92d, 0x3f64, 0xbc38,
    0x2c38, 0xb952, 0xbb93, 0x3be8, 0x3e4b, 0x38b6, 0xb6c8, 0xb84e,
    0x3d6b, 0x425f, 0x38f3, 0x40b7, 0x4106, 0x2866, 0x3427, 0x381e,
    0x414e, 0xc1a5, 0xbdcd, 0x4058, 0xbccc, 0xbe63, 0xadc2, 0x427c,
    0x343a, 0x2f56, 0xbdd5, 0x356e, 0x39df, 0x403d, 0xba2b, 0xb559,
    0xbb07, 0x3ce8, 0xbc67, 0xb3f3, 0xbc6b, 0xbb4d, 0x404e, 0xb941,
    0x3dc5, 0x2fc6, 0xbfd6, 0x31a3, 0x3c1d, 0x4169, 0xb256, 0x3ba7,
    0x317d, 0xbcb8, 0x3eca, 0xb84d, 0xc114, 0x4405, 0xc204, 0x4478,
    0x3d2f, 0x3c8e, 0xb69e, 0xb983, 0xb941, 0xb40a, 0xb6c6, 0x42dd,
    0x3763, 0x4010, 0x3700, 0x43fa, 0x3ed8, 0x3e20, 0xbe7d, 0x39ae,
    0xb813, 0xc048, 0x40bf, 0xc20a, 0xbc3f, 0xb6a2, 0x3c28, 0x3adc,
    0x3be8, 0xbb74, 0x3394, 0x3d85, 0xb96c, 0xbda3, 0x4317, 0x35b4,
    0xc46a, 0xbb58, 0xc3be, 0x3e8d, 0xb8cd, 0x44d2, 0x2e0f, 0xb799,
    0xbaa7, 0x39cc, 0xc067, 0x3ab4, 0xba99, 0xb66d, 0x2cfe, 0xacfd,
    0x38e4, 0xc243, 0xbf36, 0x42d2, 0xbdb6, 0x40ab, 0xbad7, 0xbcba,
    0x36b3, 0xaf79, 0xb810, 0x428e, 0x40e8, 0xc007, 0xb814, 0x35ef,
    0x34ac, 0xb7d6, 0x37f4, 0x3780, 0xb7b4, 0x415c, 0xbd17, 0xace6,
    0x386b, 0xbed2, 0xc409, 0xc011, 0xbf64, 0xc28b, 0x3e6f, 0xbb0b,
    0x3c65, 0xba52, 0xc417, 0xb194, 0xbff8, 0x3842, 0x400d, 0xbdaa,
    0xbcf2, 0xae88, 0xbf4e, 0x306a, 0xb7a7, 0x3969, 0x3c5e, 0x398d,
    0x33c6, 0xc026, 0x3550, 0x3108, 0x4179, 0xc139, 0xc0af, 0xb63e,
    0xc00c, 0x3f42, 0xc283, 0xbf23, 0x3f03, 0x4385, 0x38be, 0xc142,
    0x4050, 0x3d41, 0x3d57, 0xc04d, 0xc066, 0x42b3, 0x3cbb, 0x3d23,
    0xba4f, 0xbb6b, 0x3448, 0xbad8, 0x3960, 0xb2f1, 0x3ce1, 0x3152,
    0x3a57, 0x31d0, 0x377c, 0x422c, 0x3dbb, 0xbb6a, 0x31de, 0xbf0d,
    0xbddd, 0xc4e9, 0x3130, 0x3a73, 0x35dc, 0x3f49, 0xb4d5, 0xba9c,
    0xbdcb, 0x37de, 0x32eb, 0x3907, 0xbe59, 0xbf7e, 0xb34a, 0xabe3,
    0xbb87, 0xbf09, 0x3999, 0x3a8a, 0xc182, 0x30e1, 0x4372, 0x3bcc,
    0x4113, 0x358b, 0x4239, 0xc119, 0xbb02, 0x3e42, 0xbe87, 0x3fae,
    0x2e15, 0xc142, 0xbbbd, 0xb39f, 0xba91, 0x3d92, 0x3bf9, 0xb836,
    0x37d4, 0xbd93, 0x3681, 0x3c42, 0x3922, 0xbb1b, 0xbf41, 0x40f1,
    0x359f, 0xa361, 0xb453, 0x4023, 0x4168, 0x37b2, 0x3e1c, 0x3eeb,
    0xb4d2, 0x363a, 0xbb8d, 0x3a8a, 0x3904, 0x35eb, 0xbd60, 0xc243
    };

static const uint16_t ref_cfft_noisy_2048[4096] = {
    0xc501, 0x0, 0xbd60, 0x4243, 0x3904, 0xb5eb, 0xbb8d, 0xba8a,
    0xb4d2, 0xb63a, 0x3e1c, 0xbeeb, 0x4168, 0xb7b2, 0xb453, 0xc023,
    0x359f, 0x2361, 0xbf41, 0xc0f1, 0x3922, 0x3b1b, 0x3681, 0xbc42,
    0x37d4, 0x3d93, 0x3bf9, 0x3836, 0xba91, 0xbd92, 0xbbbd, 0x339f,
    0x2e15, 0x4142, 0xbe87, 0xbfae, 0xbb02, 0xbe42, 0x4239, 0x4119,
    0x4113, 0xb58b, 0x4372, 0xbbcc, 0xc182, 0xb0e1, 0x3999, 0xba8a,
    0xbb87, 0x3f09, 0xb34a, 0x2be3, 0xbe59, 0x3f7e, 0x32eb, 0xb907,
    0xbdcb, 0xb7de, 0xb4d5, 0x3a9c, 0x35dc, 0xbf49, 0x3130, 0xba73,
    0xbddd, 0x44e9, 0x31de, 0x3f0d, 0x3dbb, 0x3b6a, 0x377c, 0xc22c,
    0x3a57, 0xb1d0, 0x3ce1, 0xb152, 0x3960, 0x32f1, 0x3448, 0x3ad8,
    0xba4f, 0x3b6b, 0x3cbb, 0xbd23, 0xc066, 0xc2b3, 0x3d57, 0x404d,
    0x4050, 0xbd41, 0x38be, 0x4142, 0x3f03, 0xc385, 0xc283, 0x3f23,
    0xc00c, 0xbf42, 0xc0af, 0x363e, 0x4179, 0x4139, 0x3550, 0xb108,
    0x33c6, 0x4026, 0x3c5e, 0xb98d, 0xb7a7, 0xb969, 0xbf4e, 0xb06a,
    0xbcf2, 0x2e88, 0x400d, 0x3daa, 0xbff8, 0xb842, 0xc417, 0x3194,
    0x3c65, 0x3a52, 0x3e6f, 0x3b0b, 0xbf64, 0x428b, 0xc409, 0x4011,
    0x386b, 0x3ed2, 0xbd17, 0x2ce6, 0xb7b4, 0xc15c, 0x37f4, 0xb780,
    0x34ac, 0x37d6, 0xb814, 0xb5ef, 0x40e8, 0x4007, 0xb810, 0xc28e,
    0x36b3, 0x2f79, 0xbad7, 0x3cba, 0xbdb6, 0xc0ab, 0xbf36, 0xc2d2,
    0x38e4, 0x4243, 0x2cfe, 0x2cfd, 0xba99, 0x366d, 0xc067, 0xbab4,
    0xbaa7, 0xb9cc, 0x2e0f, 0x3799, 0xb8cd, 0xc4d2, 0xc3be, 0xbe8d,
    0xc46a, 0x3b58, 0x4317, 0xb5b4, 0xb96c, 0x3da3, 0x3394, 0xbd85,
    0x3be8, 0x3b74, 0x3c28, 0xbadc, 0xbc3f, 0x36a2, 0x40bf, 0x420a,
    0xb813, 0x4048, 0xbe7d, 0xb9ae, 0x3ed8, 0xbe20, 0x3700, 0xc3fa,
    0x3763, 0xc010, 0xb6c6, 0xc2dd, 0xb941, 0x340a, 0xb69e, 0x3983,
    0x3d2f, 0xbc8e, 0xc204, 0xc478, 0xc114, 0xc405, 0x3eca, 0x384d,
    0x317d, 0x3cb8, 0xb256, 0xbba7, 0x3c1d, 0xc169, 0xbfd6, 0xb1a3,
    0x3dc5, 0xafc6, 0x404e, 0x3941, 0xbc6b, 0x3b4d, 0xbc67, 0x33f3,
    0xbb07, 0xbce8, 0xba2b, 0x3559, 0x39df, 0xc03d, 0xbdd5, 0xb56e,
    0x343a, 0xaf56, 0xadc2, 0xc27c, 0xbccc, 0x3e63, 0xbdcd, 0xc058,
    0x414e, 0x41a5, 0x3427, 0xb81e, 0x4106, 0xa866, 0x38f3, 0xc0b7,
    0x3d6b, 0xc25f, 0xb6c8, 0x384e, 0x3e4b, 0xb8b6, 0xbb93, 0xbbe8,
    0x2c38, 0x3952, 0x3f64, 0x3c38, 0xbf88, 0x392d, 0x3fc8, 0xb5a5,
    0x18ea, 0xbaea, 0x37c3, 0x3c98, 0xb967, 0xb635, 0x3d14, 0xb4ee,
    0x40b2, 0x40da, 0xbada, 0xbf51, 0x3838, 0xc2d0, 0xbff1, 0x3cca,
    0xbe58, 0xbd2d, 0xbcc9, 0x4302, 0xc1cf, 0xbde8, 0xbe1a, 0xc2a2,
    0x35a9, 0x39de, 0xc13f, 0xbc3d, 0xba88, 0xbeed, 0xbbd3, 0xa83e,
    0xbc0a, 0x38f1, 0x3b91, 0x3c65, 0xbdeb, 0xc1d8, 0xb5ed, 0x2e8c,
    0xb601, 0xba69, 0xb967, 0xbc83, 0x3a95, 0xc03b, 0x3979, 0x3c2c,
    0xc126, 0x3af0, 0x2e38, 0x3c38, 0xc127, 0x4003, 0xb85e, 0x3b7b,
    0x3e0c, 0x2fde, 0x436d, 0xbbe2, 0x36c5, 0xa775, 0x33ff, 0xb9d9,
    0xafba, 0xbe9a, 0x40b3, 0x3752, 0xc130, 0x4460, 0x3b44, 0xc126,
    0x3d44, 0x4352, 0x3ca6, 0x408c, 0x3c36, 0xb8ee, 0xc1bf, 0xb80e,
    0x4053, 0x3944, 0xb807, 0x38fb, 0xb25d, 0xbc69, 0x3e7e, 0xba5b,
    0x3b16, 0x39fa, 0x3ba6, 0x3391, 0xbb47, 0xbc13, 0xaf6b, 0xb81f,
    0xbd66, 0xb8a4, 0x3660, 0xb713, 0xbac1, 0xbdcc, 0xb93a, 0x3ddf,
    0xbdb8, 0xc27f, 0xb657, 0xb698, 0x3412, 0x4093, 0xbf39, 0xc118,
    0xb00f, 0x3c48, 0xb440, 0xbeb1, 0xbd54, 0xbd21, 0xb4d8, 0xbfaa,
    0xbdc2, 0x39ec, 0xbf7e, 0xbd33, 0x209c, 0xae16, 0x4034, 0xbde8,
    0xbbd3, 0x3ecf, 0x3fcb, 0xc07b, 0x40d8, 0x41e7, 0x368b, 0x3dd3,
    0x3ad8, 0x40c3, 0xbef6, 0x3e43, 0xc0f6, 0x3859, 0xc2d5, 0x2c95,
    0x4111, 0xbf16, 0x3a64, 0xbaae, 0x4082, 0x3f63, 0xb57d, 0xbfaa,
    0xb3f8, 0x3a75, 0xa919, 0x397c, 0x3f56, 0x3b11, 0xc09b, 0xb6ab,
    0x410a, 0x3feb, 0xc139, 0xbc5e, 0x4074, 0xc149, 0x3aa7, 0xb2c8,
    0x38dc, 0x35e3, 0x39f1, 0x3dee, 0xbb2c, 0xa8e3, 0x3d83, 0x3a50,
    0x3c1d, 0x3d5b, 0x34da, 0xb627, 0xbe99, 0xb3af, 0xb9c9, 0x4128,
    0xc0ce, 0x3cc7, 0xbe9c, 0xbda4, 0x3af4, 0xbfc9, 0xbc07, 0x35d7,
    0xbf3a, 0xbe0b, 0xc02d, 0x3d51, 0xbc21, 0x3cea, 0x345f, 0x414f,
    0x3d16, 0xb550, 0x3948, 0xbc55, 0x3eba, 0x3dbc, 0x4011, 0xbe42,
    0x3f14, 0xb96d, 0x3c80, 0xbd75, 0x3b67, 0x2403, 0x3cba, 0xbc5c,
    0xb89f, 0xac1a, 0xae73, 0x3752, 0x3518, 0xc225, 0x4100, 0xbb61,
    0xb40f, 0x3882, 0xbc91, 0x3dd9, 0xb5be, 0x3c4a, 0x3ea2, 0x3ee8,
    0x31d7, 0x43e0, 0x2cba, 0x419c, 0xb955, 0xc088, 0xb829, 0xbdd1,
    0x3ea0, 0xbc2e, 0x3822, 0xc058, 0x3446, 0xc1bf, 0xc247, 0x3def,
    0x38bd, 0xe19b, 0xb684, 0x3cae, 0xbb60, 0x43f4, 0xadee, 0x3fe3,
    0x410e, 0x3eca, 0x3b26, 0xadee, 0x3d54, 0x3f45, 0xbc9b, 0xc549,
    0xbe65, 0x40b2, 0xbe0b, 0xb8e7, 0x3c03, 0xb4ad, 0x3ddf, 0xb980,
    0xbded, 0x3ee7, 0x42c1, 0x411c, 0xb09f, 0xbe75, 0x2c99, 0x23fc,
    0xb975, 0x3cfd, 0xc218, 0xb5d8, 0xba14, 0x3dbe, 0x3bb0, 0x3ac1,
    0xbbaf, 0xb45c, 0x389e, 0x37d1, 0x3a52, 0xb1e6, 0x3818, 0x4151,
    0x345a, 0x3e95, 0xb4d2, 0xab4c, 0x3aec, 0x3f6e, 0x357e, 0x3598,
    0x3709, 0x4280, 0xb690, 0xbeeb, 0xb434, 0xbfb5, 0x3e62, 0x2d59,
    0xb81a, 0x426b, 0xc074, 0xc024, 0xb5f8, 0xbafd, 0xb7eb, 0x3bcf,
    0x3eb1, 0x3c4f, 0xbffd, 0xb7ba, 0x3a71, 0xc022, 0x3a71, 0xbcb3,
    0x3ff8, 0x3cc5, 0xb467, 0xbf56, 0x26c2, 0xbab9, 0x407b, 0x3c82,
    0x3825, 0xba04, 0xb5ac, 0xc389, 0x3eef, 0x40ea, 0x4193, 0x355d,
    0xbe70, 0x3b79, 0xba7e, 0x4003, 0xbc68, 0xb2f4, 0xbcf6, 0x3cdb,
    0x3df5, 0xb5d5, 0xb623, 0x3b29, 0x39c2, 0x3855, 0x400a, 0x3b13,
    0xc024, 0xbac3, 0xc2aa, 0xa9a7, 0xb488, 0xc050, 0xbc6c, 0xc117,
    0xb92e, 0x3354, 0xbf5f, 0x40e2, 0x3c6e, 0xc096, 0xc096, 0xb86e,
    0xbc21, 0xaff2, 0x3a86, 0xc151, 0xbb8c, 0x3803, 0x3a20, 0x3252,
    0xc02f, 0xbe01, 0x33db, 0xbef6, 0xbfab, 0x3f27, 0xbec2, 0xb3c4,
    0x37fb, 0xc07f, 0xbf7d, 0xbef8, 0xbca2, 0x3a27, 0xbfa8, 0x2d71,
    0xbdec, 0x3c11, 0xbd99, 0x3981, 0xbeb1, 0xbe42, 0x3e25, 0xb428,
    0x3bd3, 0x3f3a, 0x40bf, 0x3f55, 0x382c, 0xbec1, 0xbcf8, 0xc20e,
    0x3600, 0x3c72, 0x3ade, 0xb93a, 0xc178, 0xbe7b, 0xb333, 0xc156,
    0x41d0, 0xc0f6, 0xb4ca, 0xbec9, 0xb032, 0x38ed, 0x3e78, 0x3e10,
    0xbfb6, 0xb87d, 0x3550, 0x3c62, 0xb02b, 0x39cd, 0x3b19, 0x3944,
    0xc389, 0x3cac, 0x3e5e, 0xb4d3, 0x3f62, 0xb43a, 0xb9ec, 0xba30,
    0xbf98, 0xc000, 0xb14f, 0x423b, 0x3dcf, 0xbcb2, 0xbb38, 0x3bb2,
    0xbc3d, 0xc0da, 0x2c73, 0x3ba6, 0xb166, 0xbd50, 0xbd98, 0x325f,
    0x4144, 0xc025, 0x41f0, 0xbaf4, 0xb902, 0xbac1, 0xbdeb, 0x3f44,
    0x3ff9, 0x3e1d, 0xc39a, 0x3a17, 0x34ba, 0x3c9f, 0xa042, 0xc04f,
    0x3292, 0x3e90, 0x3a39, 0x36ce, 0x40a6, 0x3d01, 0xbacc, 0xb46b,
    0x3b3a, 0xb61e, 0xba57, 0xc1a9, 0xc126, 0xbc0b, 0x3cd5, 0x3d6b,
    0x3813, 0x3b1a, 0x42f5, 0xb5fe, 0xc013, 0x364a, 0x3cb5, 0x3ebe,
    0x41ed, 0xaf34, 0x3eb3, 0xbf4e, 0x4041, 0xb6c5, 0x3a9b, 0x36a3,
    0x3e04, 0xbc0b, 0x4417, 0x3c29, 0xbabe, 0xc00d, 0x3ae1, 0x40b9,
    0x3be2, 0xb700, 0xc021, 0x2bee, 0xc318, 0xb8fc, 0xbd9b, 0x38d9,
    0x39d3, 0x3795, 0xb9b8, 0xbd6a, 0x3d9b, 0x39ee, 0x3d4f, 0xbe55,
    0xbee5, 0x3d03, 0x3ab5, 0xbb77, 0x350d, 0xba31, 0x3709, 0xbfaa,
    0xc41e, 0xbf3b, 0x39e0, 0x385e, 0x3014, 0xb769, 0x40d2, 0xbc59,
    0x416f, 0xb254, 0xb8fe, 0x3b13, 0x3973, 0x289e, 0xbd1c, 0x3ef8,
    0x4125, 0xbe6a, 0x3f46, 0xbc01, 0x4017, 0x3d9f, 0xb897, 0x3bb8,
    0x9fa2, 0xb189, 0x3d54, 0x3af0, 0x30f6, 0x42b4, 0x4065, 0xbeb9,
    0xbed5, 0x311c, 0x3450, 0xbdbb, 0x3873, 0xbc7e, 0xc0da, 0x3d7f,
    0x3dbb, 0x3c0d, 0x2cba, 0x318e, 0xb9e5, 0xbc33, 0x3d2b, 0x3b6a,
    0xc06d, 0x3908, 0xbafc, 0x3c18, 0x392e, 0x381f, 0xc2ad, 0xbeef,
    0xb89b, 0x3f21, 0xc2eb, 0x3ac4, 0xbc07, 0xbcb2, 0xa652, 0xbc76,
    0x3855, 0xc006, 0x3ff7, 0xb9c4, 0xbdcc, 0xc206, 0xb8c4, 0x3dc9,
    0xc249, 0x3c8d, 0xb27d, 0x414c, 0x38b7, 0xb704, 0x4363, 0x3d27,
    0x40c7, 0xc0dc, 0xb9c1, 0x41ae, 0xc035, 0x2fbe, 0x425a, 0x3f8f,
    0x3bc3, 0xa98c, 0xc08d, 0xbdc9, 0x2110, 0x4012, 0xbedb, 0xbbc4,
    0x3fe3, 0xaf4e, 0xc104, 0xbc87, 0xbf22, 0xc08f, 0xb91e, 0x360a,
    0x3faf, 0xb55a, 0x40cc, 0xbe65, 0x426d, 0xa440, 0xaee9, 0x371c,
    0xbc2b, 0x3c83, 0xbc14, 0xbed2, 0x3698, 0x3777, 0xc07b, 0xb8a3,
    0xc22a, 0x3c74, 0x3c6e, 0xbf69, 0x36d0, 0xbb21, 0xb0fe, 0xba43,
    0xba9e, 0xb597, 0x3711, 0x3c28, 0x40a9, 0xbe04, 0x40ae, 0xb8aa,
    0xb434, 0xb51e, 0xb697, 0xbd3d, 0xb6b4, 0x330d, 0x3c45, 0xb53c,
    0x39c0, 0xc0aa, 0x4176, 0xc0d4, 0x31ad, 0x4295, 0xbc57, 0xbc87,
    0x3b92, 0xb062, 0x3d26, 0x3cd6, 0x3d4f, 0x3de5, 0xb6ea, 0x4100,
    0x3471, 0xbbfb, 0xbdc0, 0x41f8, 0x3d10, 0x3b2c, 0xbd64, 0x3f9a,
    0xb4ed, 0xc106, 0xbcd7, 0xbb99, 0xbe19, 0x436f, 0x409f, 0xc29a,
    0xac14, 0xb978, 0xb4fc, 0xbcb3, 0xc1b2, 0x3fa7, 0x40d1, 0x413b,
    0x2422, 0x4410, 0x2e0f, 0xb483, 0xbddc, 0xa99a, 0x3af4, 0xbe20,
    0xc3cc, 0xc063, 0xbc79, 0xb4dc, 0x3aed, 0x3ca9, 0xadf0, 0x41ae,
    0x3f65, 0xbe61, 0xbeec, 0xb203, 0xb97b, 0xc0b3, 0x3d03, 0xc0db,
    0xb972, 0xba3a, 0xbb47, 0x3e8e, 0xc304, 0xbc04, 0xbb35, 0x3a4c,
    0x3965, 0x3ca4, 0xb8a6, 0xc203, 0x372e, 0xbabb, 0xbb27, 0xc041,
    0x426d, 0xbba9, 0xbadf, 0xbadd, 0xbda3, 0xb3b0, 0x3070, 0xbe49,
    0xb854, 0xb539, 0x1870, 0xb658, 0x39d0, 0xc426, 0x2f13, 0xb868,
    0x3599, 0x3c01, 0xade3, 0xbeb6, 0xbff2, 0x3cdc, 0xbc8b, 0xbde2,
    0x2e92, 0x3852, 0x2e92, 0xbadc, 0xb804, 0x39a6, 0x4152, 0xc4ac,
    0x39cd, 0xc09f, 0x3f54, 0xbee3, 0x3882, 0xbfe7, 0xbab8, 0xb485,
    0x42a6, 0x361d, 0xc10b, 0x3e03, 0x40dc, 0xbc91, 0x3826, 0x399d,
    0xc244, 0xb933, 0xbb88, 0x3ebf, 0x38fe, 0xb971, 0x40b0, 0x3f61,
    0xb8fc, 0xbca9, 0x2f16, 0x4131, 0xc0dd, 0xb412, 0xbab0, 0x3c3f,
    0x3ff0, 0xbabe, 0x2519, 0x37c3, 0xbe1e, 0xb862, 0xbffd, 0xc41f,
    0x3f40, 0xc238, 0x457c, 0xc00e, 0xa4b1, 0xbcbe, 0x3dd8, 0xbf54,
    0x359c, 0x4299, 0x3d5d, 0xb863, 0xb8b8, 0x3718, 0xbc56, 0xba18,
    0x41a2, 0x3775, 0xb327, 0xbcc2, 0x388c, 0xbed7, 0xb6a8, 0x354e,
    0x3bd4, 0xc2b0, 0x4050, 0xb5e6, 0x3607, 0x3773, 0xb842, 0xaea2,
    0xa8dd, 0x3bf3, 0x424f, 0xb97a, 0xb4bd, 0x3c22, 0x3cf7, 0x4117,
    0x3abd, 0xbd95, 0x3d3c, 0xb317, 0x2d14, 0xc08c, 0xc106, 0xade2,
    0x404e, 0xc15d, 0xc065, 0x41b9, 0xbe00, 0x415b, 0xbd09, 0x2ee3,
    0x40c4, 0x3d62, 0x3e94, 0xbef4, 0x41cd, 0xc025, 0xbb81, 0xb958,
    0xacef, 0x4246, 0x4361, 0xbc1e, 0x354f, 0xbf19, 0xbd61, 0x3485,
    0x3dbc, 0xbf5f, 0x3e2e, 0x40b3, 0xbadc, 0xbd20, 0xbe51, 0x3c19,
    0x3b6c, 0xc0b7, 0x2dd6, 0xc0a3, 0x35c3, 0xbc09, 0x3170, 0xba04,
    0xc281, 0x2e2f, 0xbe7b, 0xbe85, 0xba31, 0x3e58, 0xb99b, 0x3d54,
    0xbfdd, 0x3edc, 0x3fac, 0x3c37, 0xbd0b, 0xb9cb, 0x3490, 0xc1bf,
    0xbbf5, 0xa684, 0x3e12, 0xb613, 0xbc7b, 0x42e6, 0xb7b7, 0x4235,
    0xbe82, 0xac1c, 0x341f, 0xbdeb, 0x3c56, 0xb958, 0x3b4d, 0xbad1,
    0xb4dc, 0xc06c, 0xb69b, 0x3ed2, 0xb3b4, 0x3832, 0x4116, 0xbc1a,
    0x3279, 0x3e6f, 0xbcf5, 0xbd73, 0xc3fe, 0x414d, 0xb586, 0x3ca1,
    0x3e4c, 0xbc17, 0x321e, 0xaf38, 0x3ac4, 0x3b07, 0x384a, 0x42be,
    0xbcd0, 0x3979, 0x3719, 0x37cd, 0xb515, 0x3113, 0x40f3, 0x341a,
    0xbc3c, 0x3b07, 0x3630, 0xbff3, 0xb38e, 0xb87d, 0xb932, 0xc186,
    0xc0d0, 0x26e4, 0x32b9, 0x20c3, 0xbf82, 0x3b90, 0x3c9b, 0x3dbb,
    0xbb10, 0x35b5, 0xbaa9, 0xba0e, 0xb886, 0xb75f, 0xbe78, 0xb6b9,
    0x311d, 0x4301, 0xc36d, 0x3d80, 0xbf04, 0x3ca4, 0xbb0d, 0xc3aa,
    0xb175, 0x3af8, 0xc292, 0xb68b, 0x3ca0, 0x421a, 0x3f35, 0xb54c,
    0xbe96, 0xb357, 0xb828, 0x374e, 0xb031, 0x383c, 0xb767, 0x3867,
    0xc060, 0xbdd8, 0x3e73, 0x3bb2, 0x3e47, 0xbfd7, 0x35c6, 0xbae6,
    0x3f2a, 0x3c3a, 0xb2ca, 0xbd6e, 0x381c, 0x40b9, 0xb8ab, 0xbe0c,
    0xbe12, 0xc03e, 0xc10b, 0x40c4, 0x3ab1, 0x3aaf, 0xba0c, 0x3ecd,
    0xbb89, 0x3c11, 0xc09e, 0xbf61, 0xb89b, 0x3fe8, 0x3971, 0x3beb,
    0x2e73, 0xbece, 0x3df0, 0x3a1e, 0x3c90, 0xbc7e, 0x4083, 0xbdd7,
    0x2deb, 0xb44f, 0xb0f1, 0xb6b3, 0x326a, 0x3a1d, 0x2e13, 0xb977,
    0x35eb, 0xbbd0, 0xbd15, 0x3c61, 0x3b00, 0xbdf6, 0xc15a, 0x3d6f,
    0xbba7, 0x356b, 0x42b1, 0xb57d, 0xb865, 0x368b, 0x40ab, 0xb8c5,
    0x3d8a, 0xbb73, 0xbc4c, 0xc34a, 0x35c6, 0x3fc1, 0x4056, 0x30f5,
    0x38e3, 0x3b8b, 0xd2e, 0xc095, 0xc0d2, 0x3a83, 0x407b, 0x3c44,
    0x404a, 0xc07f, 0x28d3, 0xb8c6, 0xbf8f, 0xb79c, 0x32d7, 0xbf83,
    0xbe5d, 0xbbfe, 0x3bf2, 0x3c6c, 0xc1dc, 0xbc92, 0x3025, 0xc1a3,
    0xb586, 0x38c5, 0x3c3c, 0x4403, 0x337c, 0x3a79, 0x39d2, 0x3deb,
    0x36b3, 0x3ba3, 0x4113, 0xc0b9, 0xc13a, 0xb519, 0xbf6e, 0xbcc7,
    0xba2f, 0x3916, 0x3e25, 0x3543, 0xbc4c, 0xb6f9, 0xafb9, 0x3ff7,
    0x3e62, 0xb988, 0x3ad1, 0xbcad, 0xa5b8, 0x40b7, 0xc0c3, 0xc2a6,
    0x34e8, 0xc063, 0xb968, 0x3aa2, 0xbdb0, 0x2a9c, 0xbf11, 0x3947,
    0x3e51, 0x3f5a, 0xc279, 0x39d7, 0xbedc, 0xc0f6, 0xb606, 0xbef5,
    0xb38f, 0x414b, 0x3e29, 0xbd13, 0x3ebe, 0x33cc, 0xc1d6, 0xb070,
    0xbbac, 0xb029, 0xc4ca, 0x3f34, 0xbe5e, 0x332c, 0xa992, 0xac76,
    0x4030, 0xbdc5, 0xb9d1, 0x3883, 0xae36, 0xb4d0, 0x3d10, 0xc1af,
    0xbda2, 0xc116, 0x3c3a, 0x39a3, 0x402b, 0x42f9, 0xacbd, 0x386b,
    0x345e, 0x4169, 0xbbc1, 0x3d2b, 0x406d, 0x3b48, 0x3f5f, 0xbeab,
    0xbf57, 0x3a19, 0x3f84, 0xb3c9, 0x336e, 0x3b52, 0x3ddc, 0xb98f,
    0xb884, 0x3d00, 0xbd26, 0xb700, 0xb654, 0xb0a8, 0x397a, 0x3c61,
    0x39f0, 0x3a7d, 0x40d4, 0xbf9f, 0x4161, 0xbe72, 0x3d1d, 0xb99f,
    0xc075, 0xb87d, 0x417a, 0xb720, 0xb987, 0x3490, 0x2fc5, 0x3de3,
    0x3a14, 0xbf89, 0x3e26, 0xbfbb, 0x3f47, 0x41d1, 0xb619, 0xbbab,
    0x3d84, 0xb0a6, 0x34a5, 0x3461, 0xb45d, 0x3b3f, 0x3db6, 0xba40,
    0x32cc, 0xb82a, 0x3972, 0x3712, 0xbfa6, 0x3da9, 0xbff1, 0x3960,
    0xc1ed, 0xada4, 0x3cfe, 0x3c1e, 0xb6e4, 0x3acf, 0x400c, 0xc05d,
    0x3f1d, 0xaf4c, 0x3a89, 0xbbee, 0xbe3b, 0xbc49, 0x32b5, 0xb8c1,
    0xc22f, 0x3264, 0xafd3, 0xbb58, 0xbb52, 0x3a84, 0xb32c, 0x33c9,
    0xbe96, 0x3ed2, 0x3c16, 0xbe2a, 0x3ade, 0x3c14, 0x3e55, 0xbae8,
    0x3981, 0xbc8d, 0xc0f9, 0xbf15, 0x4122, 0x3bad, 0x43c2, 0x3ac6,
    0x3e92, 0xbdee, 0x3bb9, 0x3dd5, 0x3775, 0x42c5, 0xbcc1, 0xb580,
    0x3557, 0xa02c, 0x382c, 0x3d67, 0x407a, 0x37ee, 0xbd29, 0xb98d,
    0xb1cd, 0xbd6d, 0x40f5, 0xbd92, 0x2f23, 0x427c, 0xbe19, 0x3dc4,
    0x3bf9, 0xb547, 0xc1da, 0xb831, 0x3f10, 0x3b10, 0x3593, 0xc01f,
    0xbc44, 0x3aaf, 0xb6e6, 0xb331, 0xb55d, 0xba68, 0x347c, 0xbeb9,
    0xbe99, 0x3c38, 0xc25d, 0x4285, 0xb939, 0x3022, 0xc59a, 0x418a,
    0x3e69, 0xbbe5, 0xbae8, 0x3aa4, 0x42e2, 0x405c, 0xbf7d, 0x3e01,
    0x3fe7, 0x3a0a, 0x3f5a, 0x3c27, 0x3f42, 0xc00b, 0x28b3, 0xae9e,
    0x35b5, 0xc106, 0xb850, 0x3e28, 0xc216, 0x3c85, 0x420b, 0x3a23,
    0x441c, 0xc67d, 0x3f72, 0xbea9, 0x2e38, 0xbadd, 0xa482, 0xbc24,
    0x3502, 0xb666, 0x404c, 0xba29, 0x3fe8, 0x37ee, 0x3fdc, 0x3988,
    0xbc66, 0xc3c9, 0x4301, 0x3f37, 0xc426, 0x41a2, 0x3cf3, 0xb7b8,
    0xb465, 0x4059, 0xc12b, 0xbfaa, 0xbbaa, 0x3bb9, 0x3c41, 0x3d45,
    0xc0cf, 0x3e13, 0xa56c, 0x39b0, 0x3095, 0x3847, 0x3a9a, 0xbb3d,
    0x34d9, 0x3e38, 0x3e38, 0x427f, 0x3bdb, 0xbb86, 0xb735, 0x3ae0,
    0xb51e, 0xb3b0, 0x40e9, 0xbb0a, 0x410b, 0xb920, 0xbcb7, 0x3b95,
    0xb4ba, 0xbdb4, 0x3028, 0x409b, 0x3aaf, 0xbc24, 0x3be0, 0x419f,
    0x3f3a, 0xbe64, 0xb0de, 0x33f0, 0xb7a5, 0xb4fd, 0xb839, 0xbde0,
    0x2301, 0xc11b, 0x3a93, 0x3772, 0xbd0a, 0xc060, 0x397b, 0x38b1,
    0xbc61, 0x3ee0, 0xba4c, 0xbe47, 0x355e, 0x30b2, 0xbad9, 0x407f,
    0xc250, 0x39f2, 0x3f0b, 0xba0c, 0x3976, 0xbec7, 0x402e, 0x3dd8,
    0x3323, 0x38bd, 0xb6dc, 0xb7c7, 0xb863, 0xbcd2, 0xbc5d, 0x3bbe,
    0x3921, 0x396b, 0xb8e0, 0x34c0, 0x33ce, 0x3963, 0x31dc, 0xbd43,
    0xbb4d, 0xb9c6, 0x374f, 0xbe12, 0x3d79, 0x3a18, 0x3e71, 0x36b9,
    0xba62, 0x3f0a, 0xbe20, 0xc1e1, 0xc1df, 0x40bf, 0x35f7, 0xba6a,
    0x3d35, 0xbab2, 0x3ce4, 0x2c94, 0x3784, 0x4035, 0xbe64, 0xbb9b,
    0xbe1b, 0x409e, 0x3b56, 0x33d6, 0x3c33, 0x34cf, 0x3fd5, 0xc345,
    0xc0b0, 0xbd8b, 0x36aa, 0x4157, 0x2916, 0x4054, 0x3ed6, 0xbc22,
    0x32fd, 0xc070, 0xb9ca, 0x3eb7, 0x3e98, 0x35ca, 0x3e7e, 0x3e4d,
    0x4048, 0xb856, 0x417e, 0x44e9, 0xbc9a, 0xc043, 0xbd4d, 0xc254,
    0xbc1e, 0xbf45, 0x27d0, 0xc0ab, 0x4324, 0x331e, 0xbe59, 0xc1d7,
    0xc1b4, 0xbf67, 0x37e1, 0xacce, 0xbcbd, 0x3a58, 0x38d3, 0xb959,
    0xc30c, 0x3595, 0x4152, 0x427f, 0xc13e, 0xc408, 0x3d26, 0x3a4f,
    0xbc13, 0x3c65, 0x40c8, 0xbd7d, 0x35a5, 0xc05d, 0x3e4c, 0xa591,
    0xbf47, 0xbd0c, 0xbff0, 0xbb40, 0x38dc, 0xb41b, 0xc220, 0x42ea,
    0xc196, 0x2def, 0xb4dd, 0x4106, 0x3041, 0x3c32, 0xb286, 0xbd3e,
    0xb5dd, 0x38d8, 0xad0a, 0xbad0, 0x3ef6, 0x3ca1, 0x3257, 0x3d5b,
    0x40e3, 0x41d0, 0x3954, 0xba9a, 0xb189, 0xc156, 0xb633, 0x327e,
    0xb98d, 0x2b44, 0x412b, 0xa47c, 0x3913, 0xad8a, 0xb978, 0x3b46,
    0x3a79, 0xb7f8, 0xb2ee, 0xb4d4, 0xb5a7, 0x3e82, 0xbb53, 0xbc41,
    0x3c1b, 0x40af, 0xb358, 0x43d9, 0x3db3, 0xb57e, 0x3cca, 0xb35d,
    0xbc52, 0xbd99, 0x3d45, 0x32d5, 0x146a, 0x3f34, 0x38fc, 0x30e8,
    0x3520, 0xc312, 0x3d13, 0x3b0f, 0xbaa5, 0x416a, 0xb741, 0xa912,
    0x3477, 0xbeb1, 0x42c8, 0xb7f8, 0x3b38, 0x3826, 0x31ba, 0xbfb2,
    0xb644, 0xc0c3, 0x365f, 0x404a, 0xc04f, 0x3ecf, 0xb653, 0x37c0,
    0xbe42, 0xbe83, 0x39b9, 0xbc32, 0x36bb, 0xb3c5, 0x3a93, 0xb9d1,
    0x43f5, 0x4056, 0x3e75, 0x3af6, 0xbecf, 0xb48b, 0x3c25, 0xc1a1,
    0xc08b, 0xc0fe, 0x4052, 0x1988, 0x41e4, 0xbd66, 0x3a15, 0xbd8f,
    0xbb52, 0x3deb, 0x3596, 0xc28f, 0x3858, 0xbf9d, 0x38a4, 0x3b8a,
    0xb53f, 0x3c6d, 0x37a8, 0xbe7b, 0xbe03, 0x3aab, 0x3972, 0x405a,
    0xbaaa, 0xae56, 0xbf14, 0x3705, 0xb064, 0x34a4, 0xba34, 0x3c57,
    0xac3d, 0x41b9, 0x3e91, 0x3a23, 0x2e8f, 0x37a7, 0x3f49, 0x37f4,
    0x3853, 0x3f01, 0x3fb3, 0x3a7a, 0xaeba, 0x312e, 0x4116, 0xc040,
    0x3ef4, 0xbd96, 0x3ed5, 0x3754, 0x3a23, 0xba04, 0xb6c2, 0x4090,
    0xc33f, 0xbc49, 0xc368, 0x3bf0, 0x3fb3, 0xba83, 0xc1f4, 0xbdfb,
    0xa910, 0xb8bf, 0x3fdf, 0x38b6, 0x447f, 0xc1ea, 0xba78, 0xc034,
    0xc16f, 0x391e, 0xbf54, 0xbc67, 0xbacc, 0x3fb9, 0x4051, 0x3879,
    0xb6c8, 0xc04d, 0xbc5b, 0xa30b, 0xbf2e, 0x3b87, 0x4048, 0xb640,
    0x3b0d, 0x0, 0x4048, 0x3640, 0xbf2e, 0xbb87, 0xbc5b, 0x230b,
    0xb6c8, 0x404d, 0x4051, 0xb879, 0xbacc, 0xbfb9, 0xbf54, 0x3c67,
    0xc16f, 0xb91e, 0xba78, 0x4034, 0x447f, 0x41ea, 0x3fdf, 0xb8b6,
    0xa910, 0x38bf, 0xc1f4, 0x3dfb, 0x3fb3, 0x3a83, 0xc368, 0xbbf0,
    0xc33f, 0x3c49, 0xb6c2, 0xc090, 0x3a23, 0x3a04, 0x3ed5, 0xb754,
    0x3ef4, 0x3d96, 0x4116, 0x4040, 0xaeba, 0xb12e, 0x3fb3, 0xba7a,
    0x3853, 0xbf01, 0x3f49, 0xb7f4, 0x2e8f, 0xb7a7, 0x3e91, 0xba23,
    0xac3d, 0xc1b9, 0xba34, 0xbc57, 0xb064, 0xb4a4, 0xbf14, 0xb705,
    0xbaaa, 0x2e56, 0x3972, 0xc05a, 0xbe03, 0xbaab, 0x37a8, 0x3e7b,
    0xb53f, 0xbc6d, 0x38a4, 0xbb8a, 0x3858, 0x3f9d, 0x3596, 0x428f,
    0xbb52, 0xbdeb, 0x3a15, 0x3d8f, 0x41e4, 0x3d66, 0x4052, 0x9988,
    0xc08b, 0x40fe, 0x3c25, 0x41a1, 0xbecf, 0x348b, 0x3e75, 0xbaf6,
    0x43f5, 0xc056, 0x3a93, 0x39d1, 0x36bb, 0x33c5, 0x39b9, 0x3c32,
    0xbe42, 0x3e83, 0xb653, 0xb7c0, 0xc04f, 0xbecf, 0x365f, 0xc04a,
    0xb644, 0x40c3, 0x31ba, 0x3fb2, 0x3b38, 0xb826, 0x42c8, 0x37f8,
    0x3477, 0x3eb1, 0xb741, 0x2912, 0xbaa5, 0xc16a, 0x3d13, 0xbb0f,
    0x3520, 0x4312, 0x38fc, 0xb0e8, 0x146a, 0xbf34, 0x3d45, 0xb2d5,
    0xbc52, 0x3d99, 0x3cca, 0x335d, 0x3db3, 0x357e, 0xb358, 0xc3d9,
    0x3c1b, 0xc0af, 0xbb53, 0x3c41, 0xb5a7, 0xbe82, 0xb2ee, 0x34d4,
    0x3a79, 0x37f8, 0xb978, 0xbb46, 0x3913, 0x2d8a, 0x412b, 0x247c,
    0xb98d, 0xab44, 0xb633, 0xb27e, 0xb189, 0x4156, 0x3954, 0x3a9a,
    0x40e3, 0xc1d0, 0x3257, 0xbd5b, 0x3ef6, 0xbca1, 0xad0a, 0x3ad0,
    0xb5dd, 0xb8d8, 0xb286, 0x3d3e, 0x3041, 0xbc32, 0xb4dd, 0xc106,
    0xc196, 0xadef, 0xc220, 0xc2ea, 0x38dc, 0x341b, 0xbff0, 0x3b40,
    0xbf47, 0x3d0c, 0x3e4c, 0x2591, 0x35a5, 0x405d, 0x40c8, 0x3d7d,
    0xbc13, 0xbc65, 0x3d26, 0xba4f, 0xc13e, 0x4408, 0x4152, 0xc27f,
    0xc30c, 0xb595, 0x38d3, 0x3959, 0xbcbd, 0xba58, 0x37e1, 0x2cce,
    0xc1b4, 0x3f67, 0xbe59, 0x41d7, 0x4324, 0xb31e, 0x27d0, 0x40ab,
    0xbc1e, 0x3f45, 0xbd4d, 0x4254, 0xbc9a, 0x4043, 0x417e, 0xc4e9,
    0x4048, 0x3856, 0x3e7e, 0xbe4d, 0x3e98, 0xb5ca, 0xb9ca, 0xbeb7,
    0x32fd, 0x4070, 0x3ed6, 0x3c22, 0x2916, 0xc054, 0x36aa, 0xc157,
    0xc0b0, 0x3d8b, 0x3fd5, 0x4345, 0x3c33, 0xb4cf, 0x3b56, 0xb3d6,
    0xbe1b, 0xc09e, 0xbe64, 0x3b9b, 0x3784, 0xc035, 0x3ce4, 0xac94,
    0x3d35, 0x3ab2, 0x35f7, 0x3a6a, 0xc1df, 0xc0bf, 0xbe20, 0x41e1,
    0xba62, 0xbf0a, 0x3e71, 0xb6b9, 0x3d79, 0xba18, 0x374f, 0x3e12,
    0xbb4d, 0x39c6, 0x31dc, 0x3d43, 0x33ce, 0xb963, 0xb8e0, 0xb4c0,
    0x3921, 0xb96b, 0xbc5d, 0xbbbe, 0xb863, 0x3cd2, 0xb6dc, 0x37c7,
    0x3323, 0xb8bd, 0x402e, 0xbdd8, 0x3976, 0x3ec7, 0x3f0b, 0x3a0c,
    0xc250, 0xb9f2, 0xbad9, 0xc07f, 0x355e, 0xb0b2, 0xba4c, 0x3e47,
    0xbc61, 0xbee0, 0x397b, 0xb8b1, 0xbd0a, 0x4060, 0x3a93, 0xb772,
    0x2301, 0x411b, 0xb839, 0x3de0, 0xb7a5, 0x34fd, 0xb0de, 0xb3f0,
    0x3f3a, 0x3e64, 0x3be0, 0xc19f, 0x3aaf, 0x3c24, 0x3028, 0xc09b,
    0xb4ba, 0x3db4, 0xbcb7, 0xbb95, 0x410b, 0x3920, 0x40e9, 0x3b0a,
    0xb51e, 0x33b0, 0xb735, 0xbae0, 0x3bdb, 0x3b86, 0x3e38, 0xc27f,
    0x34d9, 0xbe38, 0x3a9a, 0x3b3d, 0x3095, 0xb847, 0xa56c, 0xb9b0,
    0xc0cf, 0xbe13, 0x3c41, 0xbd45, 0xbbaa, 0xbbb9, 0xc12b, 0x3faa,
    0xb465, 0xc059, 0x3cf3, 0x37b8, 0xc426, 0xc1a2, 0x4301, 0xbf37,
    0xbc66, 0x43c9, 0x3fdc, 0xb988, 0x3fe8, 0xb7ee, 0x404c, 0x3a29,
    0x3502, 0x3666, 0xa482, 0x3c24, 0x2e38, 0x3add, 0x3f72, 0x3ea9,
    0x441c, 0x467d, 0x420b, 0xba23, 0xc216, 0xbc85, 0xb850, 0xbe28,
    0x35b5, 0x4106, 0x28b3, 0x2e9e, 0x3f42, 0x400b, 0x3f5a, 0xbc27,
    0x3fe7, 0xba0a, 0xbf7d, 0xbe01, 0x42e2, 0xc05c, 0xbae8, 0xbaa4,
    0x3e69, 0x3be5, 0xc59a, 0xc18a, 0xb939, 0xb022, 0xc25d, 0xc285,
    0xbe99, 0xbc38, 0x347c, 0x3eb9, 0xb55d, 0x3a68, 0xb6e6, 0x3331,
    0xbc44, 0xbaaf, 0x3593, 0x401f, 0x3f10, 0xbb10, 0xc1da, 0x3831,
    0x3bf9, 0x3547, 0xbe19, 0xbdc4, 0x2f23, 0xc27c, 0x40f5, 0x3d92,
    0xb1cd, 0x3d6d, 0xbd29, 0x398d, 0x407a, 0xb7ee, 0x382c, 0xbd67,
    0x3557, 0x202c, 0xbcc1, 0x3580, 0x3775, 0xc2c5, 0x3bb9, 0xbdd5,
    0x3e92, 0x3dee, 0x43c2, 0xbac6, 0x4122, 0xbbad, 0xc0f9, 0x3f15,
    0x3981, 0x3c8d, 0x3e55, 0x3ae8, 0x3ade, 0xbc14, 0x3c16, 0x3e2a,
    0xbe96, 0xbed2, 0xb32c, 0xb3c9, 0xbb52, 0xba84, 0xafd3, 0x3b58,
    0xc22f, 0xb264, 0x32b5, 0x38c1, 0xbe3b, 0x3c49, 0x3a89, 0x3bee,
    0x3f1d, 0x2f4c, 0x400c, 0x405d, 0xb6e4, 0xbacf, 0x3cfe, 0xbc1e,
    0xc1ed, 0x2da4, 0xbff1, 0xb960, 0xbfa6, 0xbda9, 0x3972, 0xb712,
    0x32cc, 0x382a, 0x3db6, 0x3a40, 0xb45d, 0xbb3f, 0x34a5, 0xb461,
    0x3d84, 0x30a6, 0xb619, 0x3bab, 0x3f47, 0xc1d1, 0x3e26, 0x3fbb,
    0x3a14, 0x3f89, 0x2fc5, 0xbde3, 0xb987, 0xb490, 0x417a, 0x3720,
    0xc075, 0x387d, 0x3d1d, 0x399f, 0x4161, 0x3e72, 0x40d4, 0x3f9f,
    0x39f0, 0xba7d, 0x397a, 0xbc61, 0xb654, 0x30a8, 0xbd26, 0x3700,
    0xb884, 0xbd00, 0x3ddc, 0x398f, 0x336e, 0xbb52, 0x3f84, 0x33c9,
    0xbf57, 0xba19, 0x3f5f, 0x3eab, 0x406d, 0xbb48, 0xbbc1, 0xbd2b,
    0x345e, 0xc169, 0xacbd, 0xb86b, 0x402b, 0xc2f9, 0x3c3a, 0xb9a3,
    0xbda2, 0x4116, 0x3d10, 0x41af, 0xae36, 0x34d0, 0xb9d1, 0xb883,
    0x4030, 0x3dc5, 0xa992, 0x2c76, 0xbe5e, 0xb32c, 0xc4ca, 0xbf34,
    0xbbac, 0x3029, 0xc1d6, 0x3070, 0x3ebe, 0xb3cc, 0x3e29, 0x3d13,
    0xb38f, 0xc14b, 0xb606, 0x3ef5, 0xbedc, 0x40f6, 0xc279, 0xb9d7,
    0x3e51, 0xbf5a, 0xbf11, 0xb947, 0xbdb0, 0xaa9c, 0xb968, 0xbaa2,
    0x34e8, 0x4063, 0xc0c3, 0x42a6, 0xa5b8, 0xc0b7, 0x3ad1, 0x3cad,
    0x3e62, 0x3988, 0xafb9, 0xbff7, 0xbc4c, 0x36f9, 0x3e25, 0xb543,
    0xba2f, 0xb916, 0xbf6e, 0x3cc7, 0xc13a, 0x3519, 0x4113, 0x40b9,
    0x36b3, 0xbba3, 0x39d2, 0xbdeb, 0x337c, 0xba79, 0x3c3c, 0xc403,
    0xb586, 0xb8c5, 0x3025, 0x41a3, 0xc1dc, 0x3c92, 0x3bf2, 0xbc6c,
    0xbe5d, 0x3bfe, 0x32d7, 0x3f83, 0xbf8f, 0x379c, 0x28d3, 0x38c6,
    0x404a, 0x407f, 0x407b, 0xbc44, 0xc0d2, 0xba83, 0xd2e, 0x4095,
    0x38e3, 0xbb8b, 0x4056, 0xb0f5, 0x35c6, 0xbfc1, 0xbc4c, 0x434a,
    0x3d8a, 0x3b73, 0x40ab, 0x38c5, 0xb865, 0xb68b, 0x42b1, 0x357d,
    0xbba7, 0xb56b, 0xc15a, 0xbd6f, 0x3b00, 0x3df6, 0xbd15, 0xbc61,
    0x35eb, 0x3bd0, 0x2e13, 0x3977, 0x326a, 0xba1d, 0xb0f1, 0x36b3,
    0x2deb, 0x344f, 0x4083, 0x3dd7, 0x3c90, 0x3c7e, 0x3df0, 0xba1e,
    0x2e73, 0x3ece, 0x3971, 0xbbeb, 0xb89b, 0xbfe8, 0xc09e, 0x3f61,
    0xbb89, 0xbc11, 0xba0c, 0xbecd, 0x3ab1, 0xbaaf, 0xc10b, 0xc0c4,
    0xbe12, 0x403e, 0xb8ab, 0x3e0c, 0x381c, 0xc0b9, 0xb2ca, 0x3d6e,
    0x3f2a, 0xbc3a, 0x35c6, 0x3ae6, 0x3e47, 0x3fd7, 0x3e73, 0xbbb2,
    0xc060, 0x3dd8, 0xb767, 0xb867, 0xb031, 0xb83c, 0xb828, 0xb74e,
    0xbe96, 0x3357, 0x3f35, 0x354c, 0x3ca0, 0xc21a, 0xc292, 0x368b,
    0xb175, 0xbaf8, 0xbb0d, 0x43aa, 0xbf04, 0xbca4, 0xc36d, 0xbd80,
    0x311d, 0xc301, 0xbe78, 0x36b9, 0xb886, 0x375f, 0xbaa9, 0x3a0e,
    0xbb10, 0xb5b5, 0x3c9b, 0xbdbb, 0xbf82, 0xbb90, 0x32b9, 0xa0c3,
    0xc0d0, 0xa6e4, 0xb932, 0x4186, 0xb38e, 0x387d, 0x3630, 0x3ff3,
    0xbc3c, 0xbb07, 0x40f3, 0xb41a, 0xb515, 0xb113, 0x3719, 0xb7cd,
    0xbcd0, 0xb979, 0x384a, 0xc2be, 0x3ac4, 0xbb07, 0x321e, 0x2f38,
    0x3e4c, 0x3c17, 0xb586, 0xbca1, 0xc3fe, 0xc14d, 0xbcf5, 0x3d73,
    0x3279, 0xbe6f, 0x4116, 0x3c1a, 0xb3b4, 0xb832, 0xb69b, 0xbed2,
    0xb4dc, 0x406c, 0x3b4d, 0x3ad1, 0x3c56, 0x3958, 0x341f, 0x3deb,
    0xbe82, 0x2c1c, 0xb7b7, 0xc235, 0xbc7b, 0xc2e6, 0x3e12, 0x3613,
    0xbbf5, 0x2684, 0x3490, 0x41bf, 0xbd0b, 0x39cb, 0x3fac, 0xbc37,
    0xbfdd, 0xbedc, 0xb99b, 0xbd54, 0xba31, 0xbe58, 0xbe7b, 0x3e85,
    0xc281, 0xae2f, 0x3170, 0x3a04, 0x35c3, 0x3c09, 0x2dd6, 0x40a3,
    0x3b6c, 0x40b7, 0xbe51, 0xbc19, 0xbadc, 0x3d20, 0x3e2e, 0xc0b3,
    0x3dbc, 0x3f5f, 0xbd61, 0xb485, 0x354f, 0x3f19, 0x4361, 0x3c1e,
    0xacef, 0xc246, 0xbb81, 0x3958, 0x41cd, 0x4025, 0x3e94, 0x3ef4,
    0x40c4, 0xbd62, 0xbd09, 0xaee3, 0xbe00, 0xc15b, 0xc065, 0xc1b9,
    0x404e, 0x415d, 0xc106, 0x2de2, 0x2d14, 0x408c, 0x3d3c, 0x3317,
    0x3abd, 0x3d95, 0x3cf7, 0xc117, 0xb4bd, 0xbc22, 0x424f, 0x397a,
    0xa8dd, 0xbbf3, 0xb842, 0x2ea2, 0x3607, 0xb773, 0x4050, 0x35e6,
    0x3bd4, 0x42b0, 0xb6a8, 0xb54e, 0x388c, 0x3ed7, 0xb327, 0x3cc2,
    0x41a2, 0xb775, 0xbc56, 0x3a18, 0xb8b8, 0xb718, 0x3d5d, 0x3863,
    0x359c, 0xc299, 0x3dd8, 0x3f54, 0xa4b1, 0x3cbe, 0x457c, 0x400e,
    0x3f40, 0x4238, 0xbffd, 0x441f, 0xbe1e, 0x3862, 0x2519, 0xb7c3,
    0x3ff0, 0x3abe, 0xbab0, 0xbc3f, 0xc0dd, 0x3412, 0x2f16, 0xc131,
    0xb8fc, 0x3ca9, 0x40b0, 0xbf61, 0x38fe, 0x3971, 0xbb88, 0xbebf,
    0xc244, 0x3933, 0x3826, 0xb99d, 0x40dc, 0x3c91, 0xc10b, 0xbe03,
    0x42a6, 0xb61d, 0xbab8, 0x3485, 0x3882, 0x3fe7, 0x3f54, 0x3ee3,
    0x39cd, 0x409f, 0x4152, 0x44ac, 0xb804, 0xb9a6, 0x2e92, 0x3adc,
    0x2e92, 0xb852, 0xbc8b, 0x3de2, 0xbff2, 0xbcdc, 0xade3, 0x3eb6,
    0x3599, 0xbc01, 0x2f13, 0x3868, 0x39d0, 0x4426, 0x1870, 0x3658,
    0xb854, 0x3539, 0x3070, 0x3e49, 0xbda3, 0x33b0, 0xbadf, 0x3add,
    0x426d, 0x3ba9, 0xbb27, 0x4041, 0x372e, 0x3abb, 0xb8a6, 0x4203,
    0x3965, 0xbca4, 0xbb35, 0xba4c, 0xc304, 0x3c04, 0xbb47, 0xbe8e,
    0xb972, 0x3a3a, 0x3d03, 0x40db, 0xb97b, 0x40b3, 0xbeec, 0x3203,
    0x3f65, 0x3e61, 0xadf0, 0xc1ae, 0x3aed, 0xbca9, 0xbc79, 0x34dc,
    0xc3cc, 0x4063, 0x3af4, 0x3e20, 0xbddc, 0x299a, 0x2e0f, 0x3483,
    0x2422, 0xc410, 0x40d1, 0xc13b, 0xc1b2, 0xbfa7, 0xb4fc, 0x3cb3,
    0xac14, 0x3978, 0x409f, 0x429a, 0xbe19, 0xc36f, 0xbcd7, 0x3b99,
    0xb4ed, 0x4106, 0xbd64, 0xbf9a, 0x3d10, 0xbb2c, 0xbdc0, 0xc1f8,
    0x3471, 0x3bfb, 0xb6ea, 0xc100, 0x3d4f, 0xbde5, 0x3d26, 0xbcd6,
    0x3b92, 0x3062, 0xbc57, 0x3c87, 0x31ad, 0xc295, 0x4176, 0x40d4,
    0x39c0, 0x40aa, 0x3c45, 0x353c, 0xb6b4, 0xb30d, 0xb697, 0x3d3d,
    0xb434, 0x351e, 0x40ae, 0x38aa, 0x40a9, 0x3e04, 0x3711, 0xbc28,
    0xba9e, 0x3597, 0xb0fe, 0x3a43, 0x36d0, 0x3b21, 0x3c6e, 0x3f69,
    0xc22a, 0xbc74, 0xc07b, 0x38a3, 0x3698, 0xb777, 0xbc14, 0x3ed2,
    0xbc2b, 0xbc83, 0xaee9, 0xb71c, 0x426d, 0x2440, 0x40cc, 0x3e65,
    0x3faf, 0x355a, 0xb91e, 0xb60a, 0xbf22, 0x408f, 0xc104, 0x3c87,
    0x3fe3, 0x2f4e, 0xbedb, 0x3bc4, 0x2110, 0xc012, 0xc08d, 0x3dc9,
    0x3bc3, 0x298c, 0x425a, 0xbf8f, 0xc035, 0xafbe, 0xb9c1, 0xc1ae,
    0x40c7, 0x40dc, 0x4363, 0xbd27, 0x38b7, 0x3704, 0xb27d, 0xc14c,
    0xc249, 0xbc8d, 0xb8c4, 0xbdc9, 0xbdcc, 0x4206, 0x3ff7, 0x39c4,
    0x3855, 0x4006, 0xa652, 0x3c76, 0xbc07, 0x3cb2, 0xc2eb, 0xbac4,
    0xb89b, 0xbf21, 0xc2ad, 0x3eef, 0x392e, 0xb81f, 0xbafc, 0xbc18,
    0xc06d, 0xb908, 0x3d2b, 0xbb6a, 0xb9e5, 0x3c33, 0x2cba, 0xb18e,
    0x3dbb, 0xbc0d, 0xc0da, 0xbd7f, 0x3873, 0x3c7e, 0x3450, 0x3dbb,
    0xbed5, 0xb11c, 0x4065, 0x3eb9, 0x30f6, 0xc2b4, 0x3d54, 0xbaf0,
    0x9fa2, 0x3189, 0xb897, 0xbbb8, 0x4017, 0xbd9f, 0x3f46, 0x3c01,
    0x4125, 0x3e6a, 0xbd1c, 0xbef8, 0x3973, 0xa89e, 0xb8fe, 0xbb13,
    0x416f, 0x3254, 0x40d2, 0x3c59, 0x3014, 0x3769, 0x39e0, 0xb85e,
    0xc41e, 0x3f3b, 0x3709, 0x3faa, 0x350d, 0x3a31, 0x3ab5, 0x3b77,
    0xbee5, 0xbd03, 0x3d4f, 0x3e55, 0x3d9b, 0xb9ee, 0xb9b8, 0x3d6a,
    0x39d3, 0xb795, 0xbd9b, 0xb8d9, 0xc318, 0x38fc, 0xc021, 0xabee,
    0x3be2, 0x3700, 0x3ae1, 0xc0b9, 0xbabe, 0x400d, 0x4417, 0xbc29,
    0x3e04, 0x3c0b, 0x3a9b, 0xb6a3, 0x4041, 0x36c5, 0x3eb3, 0x3f4e,
    0x41ed, 0x2f34, 0x3cb5, 0xbebe, 0xc013, 0xb64a, 0x42f5, 0x35fe,
    0x3813, 0xbb1a, 0x3cd5, 0xbd6b, 0xc126, 0x3c0b, 0xba57, 0x41a9,
    0x3b3a, 0x361e, 0xbacc, 0x346b, 0x40a6, 0xbd01, 0x3a39, 0xb6ce,
    0x3292, 0xbe90, 0xa042, 0x404f, 0x34ba, 0xbc9f, 0xc39a, 0xba17,
    0x3ff9, 0xbe1d, 0xbdeb, 0xbf44, 0xb902, 0x3ac1, 0x41f0, 0x3af4,
    0x4144, 0x4025, 0xbd98, 0xb25f, 0xb166, 0x3d50, 0x2c73, 0xbba6,
    0xbc3d, 0x40da, 0xbb38, 0xbbb2, 0x3dcf, 0x3cb2, 0xb14f, 0xc23b,
    0xbf98, 0x4000, 0xb9ec, 0x3a30, 0x3f62, 0x343a, 0x3e5e, 0x34d3,
    0xc389, 0xbcac, 0x3b19, 0xb944, 0xb02b, 0xb9cd, 0x3550, 0xbc62,
    0xbfb6, 0x387d, 0x3e78, 0xbe10, 0xb032, 0xb8ed, 0xb4ca, 0x3ec9,
    0x41d0, 0x40f6, 0xb333, 0x4156, 0xc178, 0x3e7b, 0x3ade, 0x393a,
    0x3600, 0xbc72, 0xbcf8, 0x420e, 0x382c, 0x3ec1, 0x40bf, 0xbf55,
    0x3bd3, 0xbf3a, 0x3e25, 0x3428, 0xbeb1, 0x3e42, 0xbd99, 0xb981,
    0xbdec, 0xbc11, 0xbfa8, 0xad71, 0xbca2, 0xba27, 0xbf7d, 0x3ef8,
    0x37fb, 0x407f, 0xbec2, 0x33c4, 0xbfab, 0xbf27, 0x33db, 0x3ef6,
    0xc02f, 0x3e01, 0x3a20, 0xb252, 0xbb8c, 0xb803, 0x3a86, 0x4151,
    0xbc21, 0x2ff2, 0xc096, 0x386e, 0x3c6e, 0x4096, 0xbf5f, 0xc0e2,
    0xb92e, 0xb354, 0xbc6c, 0x4117, 0xb488, 0x4050, 0xc2aa, 0x29a7,
    0xc024, 0x3ac3, 0x400a, 0xbb13, 0x39c2, 0xb855, 0xb623, 0xbb29,
    0x3df5, 0x35d5, 0xbcf6, 0xbcdb, 0xbc68, 0x32f4, 0xba7e, 0xc003,
    0xbe70, 0xbb79, 0x4193, 0xb55d, 0x3eef, 0xc0ea, 0xb5ac, 0x4389,
    0x3825, 0x3a04, 0x407b, 0xbc82, 0x26c2, 0x3ab9, 0xb467, 0x3f56,
    0x3ff8, 0xbcc5, 0x3a71, 0x3cb3, 0x3a71, 0x4022, 0xbffd, 0x37ba,
    0x3eb1, 0xbc4f, 0xb7eb, 0xbbcf, 0xb5f8, 0x3afd, 0xc074, 0x4024,
    0xb81a, 0xc26b, 0x3e62, 0xad59, 0xb434, 0x3fb5, 0xb690, 0x3eeb,
    0x3709, 0xc280, 0x357e, 0xb598, 0x3aec, 0xbf6e, 0xb4d2, 0x2b4c,
    0x345a, 0xbe95, 0x3818, 0xc151, 0x3a52, 0x31e6, 0x389e, 0xb7d1,
    0xbbaf, 0x345c, 0x3bb0, 0xbac1, 0xba14, 0xbdbe, 0xc218, 0x35d8,
    0xb975, 0xbcfd, 0x2c99, 0xa3fc, 0xb09f, 0x3e75, 0x42c1, 0xc11c,
    0xbded, 0xbee7, 0x3ddf, 0x3980, 0x3c03, 0x34ad, 0xbe0b, 0x38e7,
    0xbe65, 0xc0b2, 0xbc9b, 0x4549, 0x3d54, 0xbf45, 0x3b26, 0x2dee,
    0x410e, 0xbeca, 0xadee, 0xbfe3, 0xbb60, 0xc3f4, 0xb684, 0xbcae,
    0x38bd, 0x619b, 0xc247, 0xbdef, 0x3446, 0x41bf, 0x3822, 0x4058,
    0x3ea0, 0x3c2e, 0xb829, 0x3dd1, 0xb955, 0x4088, 0x2cba, 0xc19c,
    0x31d7, 0xc3e0, 0x3ea2, 0xbee8, 0xb5be, 0xbc4a, 0xbc91, 0xbdd9,
    0xb40f, 0xb882, 0x4100, 0x3b61, 0x3518, 0x4225, 0xae73, 0xb752,
    0xb89f, 0x2c1a, 0x3cba, 0x3c5c, 0x3b67, 0xa403, 0x3c80, 0x3d75,
    0x3f14, 0x396d, 0x4011, 0x3e42, 0x3eba, 0xbdbc, 0x3948, 0x3c55,
    0x3d16, 0x3550, 0x345f, 0xc14f, 0xbc21, 0xbcea, 0xc02d, 0xbd51,
    0xbf3a, 0x3e0b, 0xbc07, 0xb5d7, 0x3af4, 0x3fc9, 0xbe9c, 0x3da4,
    0xc0ce, 0xbcc7, 0xb9c9, 0xc128, 0xbe99, 0x33af, 0x34da, 0x3627,
    0x3c1d, 0xbd5b, 0x3d83, 0xba50, 0xbb2c, 0x28e3, 0x39f1, 0xbdee,
    0x38dc, 0xb5e3, 0x3aa7, 0x32c8, 0x4074, 0x4149, 0xc139, 0x3c5e,
    0x410a, 0xbfeb, 0xc09b, 0x36ab, 0x3f56, 0xbb11, 0xa919, 0xb97c,
    0xb3f8, 0xba75, 0xb57d, 0x3faa, 0x4082, 0xbf63, 0x3a64, 0x3aae,
    0x4111, 0x3f16, 0xc2d5, 0xac95, 0xc0f6, 0xb859, 0xbef6, 0xbe43,
    0x3ad8, 0xc0c3, 0x368b, 0xbdd3, 0x40d8, 0xc1e7, 0x3fcb, 0x407b,
    0xbbd3, 0xbecf, 0x4034, 0x3de8, 0x209c, 0x2e16, 0xbf7e, 0x3d33,
    0xbdc2, 0xb9ec, 0xb4d8, 0x3faa, 0xbd54, 0x3d21, 0xb440, 0x3eb1,
    0xb00f, 0xbc48, 0xbf39, 0x4118, 0x3412, 0xc093, 0xb657, 0x3698,
    0xbdb8, 0x427f, 0xb93a, 0xbddf, 0xbac1, 0x3dcc, 0x3660, 0x3713,
    0xbd66, 0x38a4, 0xaf6b, 0x381f, 0xbb47, 0x3c13, 0x3ba6, 0xb391,
    0x3b16, 0xb9fa, 0x3e7e, 0x3a5b, 0xb25d, 0x3c69, 0xb807, 0xb8fb,
    0x4053, 0xb944, 0xc1bf, 0x380e, 0x3c36, 0x38ee, 0x3ca6, 0xc08c,
    0x3d44, 0xc352, 0x3b44, 0x4126, 0xc130, 0xc460, 0x40b3, 0xb752,
    0xafba, 0x3e9a, 0x33ff, 0x39d9, 0x36c5, 0x2775, 0x436d, 0x3be2,
    0x3e0c, 0xafde, 0xb85e, 0xbb7b, 0xc127, 0xc003, 0x2e38, 0xbc38,
    0xc126, 0xbaf0, 0x3979, 0xbc2c, 0x3a95, 0x403b, 0xb967, 0x3c83,
    0xb601, 0x3a69, 0xb5ed, 0xae8c, 0xbdeb, 0x41d8, 0x3b91, 0xbc65,
    0xbc0a, 0xb8f1, 0xbbd3, 0x283e, 0xba88, 0x3eed, 0xc13f, 0x3c3d,
    0x35a9, 0xb9de, 0xbe1a, 0x42a2, 0xc1cf, 0x3de8, 0xbcc9, 0xc302,
    0xbe58, 0x3d2d, 0xbff1, 0xbcca, 0x3838, 0x42d0, 0xbada, 0x3f51,
    0x40b2, 0xc0da, 0x3d14, 0x34ee, 0xb967, 0x3635, 0x37c3, 0xbc98,
    0x18ea, 0x3aea, 0x3fc8, 0x35a5, 0xbf88, 0xb92d, 0x3f64, 0xbc38,
    0x2c38, 0xb952, 0xbb93, 0x3be8, 0x3e4b, 0x38b6, 0xb6c8, 0xb84e,
    0x3d6b, 0x425f, 0x38f3, 0x40b7, 0x4106, 0x2866, 0x3427, 0x381e,
    0x414e, 0xc1a5, 0xbdcd, 0x4058, 0xbccc, 0xbe63, 0xadc2, 0x427c,
    0x343a, 0x2f56, 0xbdd5, 0x356e, 0x39df, 0x403d, 0xba2b, 0xb559,
    0xbb07, 0x3ce8, 0xbc67, 0xb3f3, 0xbc6b, 0xbb4d, 0x404e, 0xb941,
    0x3dc5, 0x2fc6, 0xbfd6, 0x31a3, 0x3c1d, 0x4169, 0xb256, 0x3ba7,
    0x317d, 0xbcb8, 0x3eca, 0xb84d, 0xc114, 0x4405, 0xc204, 0x4478,
    0x3d2f, 0x3c8e, 0xb69e, 0xb983, 0xb941, 0xb40a, 0xb6c6, 0x42dd,
    0x3763, 0x4010, 0x3700, 0x43fa, 0x3ed8, 0x3e20, 0xbe7d, 0x39ae,
    0xb813, 0xc048, 0x40bf, 0xc20a, 0xbc3f, 0xb6a2, 0x3c28, 0x3adc,
    0x3be8, 0xbb74, 0x3394, 0x3d85, 0xb96c, 0xbda3, 0x4317, 0x35b4,
    0xc46a, 0xbb58, 0xc3be, 0x3e8d, 0xb8cd, 0x44d2, 0x2e0f, 0xb799,
    0xbaa7, 0x39cc, 0xc067, 0x3ab4, 0xba99, 0xb66d, 0x2cfe, 0xacfd,
    0x38e4, 0xc243, 0xbf36, 0x42d2, 0xbdb6, 0x40ab, 0xbad7, 0xbcba,
    0x36b3, 0xaf79, 0xb810, 0x428e, 0x40e8, 0xc007, 0xb814, 0x35ef,
    0x34ac, 0xb7d6, 0x37f4, 0x3780, 0xb7b4, 0x415c, 0xbd17, 0xace6,
    0x386b, 0xbed2, 0xc409, 0xc011, 0xbf64, 0xc28b, 0x3e6f, 0xbb0b,
    0x3c65, 0xba52, 0xc417, 0xb194, 0xbff8, 0x3842, 0x400d, 0xbdaa,
    0xbcf2, 0xae88, 0xbf4e, 0x306a, 0xb7a7, 0x3969, 0x3c5e, 0x398d,
    0x33c6, 0xc026, 0x3550, 0x3108, 0x4179, 0xc139, 0xc0af, 0xb63e,
    0xc00c, 0x3f42, 0xc283, 0xbf23, 0x3f03, 0x4385, 0x38be, 0xc142,
    0x4050, 0x3d41, 0x3d57, 0xc04d, 0xc066, 0x42b3, 0x3cbb, 0x3d23,
    0xba4f, 0xbb6b, 0x3448, 0xbad8, 0x3960, 0xb2f1, 0x3ce1, 0x3152,
    0x3a57, 0x31d0, 0x377c, 0x422c, 0x3dbb, 0xbb6a, 0x31de, 0xbf0d,
    0xbddd, 0xc4e9, 0x3130, 0x3a73, 0x35dc, 0x3f49, 0xb4d5, 0xba9c,
    0xbdcb, 0x37de, 0x32eb, 0x3907, 0xbe59, 0xbf7e, 0xb34a, 0xabe3,
    0xbb87, 0xbf09, 0x3999, 0x3a8a, 0xc182, 0x30e1, 0x4372, 0x3bcc,
    0x4113, 0x358b, 0x4239, 0xc119, 0xbb02, 0x3e42, 0xbe87, 0x3fae,
    0x2e15, 0xc142, 0xbbbd, 0xb39f, 0xba91, 0x3d92, 0x3bf9, 0xb836,
    0x37d4, 0xbd93, 0x3681, 0x3c42, 0x3922, 0xbb1b, 0xbf41, 0x40f1,
    0x359f, 0xa361, 0xb453, 0x4023, 0x4168, 0x37b2, 0x3e1c, 0x3eeb,
    0xb4d2, 0x363a, 0xbb8d, 0x3a8a, 0x3904, 0x35eb, 0xbd60, 0xc243
    };

static const uint16_t in_cfft_noisy_4096[8192] = {
    0x2cc9, 0x0, 0x379e, 0x0, 0x39b0, 0x0, 0x3849, 0x0,
    0xa72e, 0x0, 0xb676, 0x0, 0xb9ad, 0x0, 0xb791, 0x0,
    0xa0df, 0x0, 0x3705, 0x0, 0x38fa, 0x0, 0x385f, 0x0,
    0x9c23, 0x0, 0xb787, 0x0, 0xb986, 0x0, 0xb81a, 0x0,
    0xa221, 0x0, 0x3823, 0x0, 0x3a2c, 0x0, 0x36b0, 0x0,
    0x29bf, 0x0, 0xb8f9, 0x0, 0xb955, 0x0, 0xb859, 0x0,
    0x247e, 0x0, 0x38ad, 0x0, 0x39a0, 0x0, 0x37c7, 0x0,
    0x2d3f, 0x0, 0xb870, 0x0, 0xb9b9, 0x0, 0xb810, 0x0,
    0xa29a, 0x0, 0x379f, 0x0, 0x39b2, 0x0, 0x36c6, 0x0,
    0xa5ec, 0x0, 0xb865, 0x0, 0xb9bc, 0x0, 0xb81f, 0x0,
    0x2d3e, 0x0, 0x3847, 0x0, 0x396e, 0x0, 0x3724, 0x0,
    0x217e, 0x0, 0xb802, 0x0, 0xb993, 0x0, 0xb86e, 0x0,
    0x2751, 0x0, 0x3852, 0x0, 0x3962, 0x0, 0x38cf, 0x0,
    0x2dcc, 0x0, 0xb781, 0x0, 0xb993, 0x0, 0xb84b, 0x0,
    0x206b, 0x0, 0x3722, 0x0, 0x3981, 0x0, 0x385e, 0x0,
    0xaa8b, 0x0, 0xb846, 0x0, 0xb92a, 0x0, 0xb800, 0x0,
    0xae03, 0x0, 0x372a, 0x0, 0x39a8, 0x0, 0x3816, 0x0,
    0x29bd, 0x0, 0xb80c, 0x0, 0xb9b0, 0x0, 0xb76f, 0x0,
    0xae72, 0x0, 0x3884, 0x0, 0x3a02, 0x0, 0x3752, 0x0,
    0xaae9, 0x0, 0xb5b1, 0x0, 0xb9ba, 0x0, 0xb7eb, 0x0,
    0xade8, 0x0, 0x3689, 0x0, 0x3a2a, 0x0, 0x37b1, 0x0,
    0x2bff, 0x0, 0xb7cc, 0x0, 0xb985, 0x0, 0xb898, 0x0,
    0x9cdf, 0x0, 0x3638, 0x0, 0x39a5, 0x0, 0x374c, 0x0,
    0xac01, 0x0, 0xb89e, 0x0, 0xba3d, 0x0, 0xb6b8, 0x0,
    0xa743, 0x0, 0x380e, 0x0, 0x39b4, 0x0, 0x3819, 0x0,
    0x25fb, 0x0, 0xb7e7, 0x0, 0xb907, 0x0, 0xb7e4, 0x0,
    0xa46e, 0x0, 0x3852, 0x0, 0x391e, 0x0, 0x3810, 0x0,
    0xa910, 0x0, 0xb78b, 0x0, 0xb8e0, 0x0, 0xb7a1, 0x0,
    0xad9b, 0x0, 0x389a, 0x0, 0x3aa4, 0x0, 0x3807, 0x0,
    0x2626, 0x0, 0xb7a0, 0x0, 0xba14, 0x0, 0xb7e6, 0x0,
    0x1dcc, 0x0, 0x37f8, 0x0, 0x3986, 0x0, 0x386d, 0x0,
    0x1f70, 0x0, 0xb824, 0x0, 0xb9a3, 0x0, 0xb7b5, 0x0,
    0x3022, 0x0, 0x3873, 0x0, 0x391e, 0x0, 0x3759, 0x0,
    0xaf1e, 0x0, 0xb88b, 0x0, 0xb9f4, 0x0, 0xb75a, 0x0,
    0x2507, 0x0, 0x3819, 0x0, 0x38cd, 0x0, 0x37ec, 0x0,
    0xa7b0, 0x0, 0xb848, 0x0, 0xba85, 0x0, 0xb5e1, 0x0,
    0xa9b0, 0x0, 0x37b6, 0x0, 0x3981, 0x0, 0x3725, 0x0,
    0x2528, 0x0, 0xb767, 0x0, 0xb95c, 0x0, 0xb853, 0x0,
    0x2b80, 0x0, 0x37e6, 0x0, 0x39e6, 0x0, 0x3892, 0x0,
    0x93f7, 0x0, 0xb83a, 0x0, 0xb97f, 0x0, 0xb806, 0x0,
    0xa268, 0x0, 0x386b, 0x0, 0x393e, 0x0, 0x3815, 0x0,
    0xa261, 0x0, 0xb7fd, 0x0, 0xb96b, 0x0, 0xb7c6, 0x0,
    0x9ab9, 0x0, 0x3798, 0x0, 0x3a03, 0x0, 0x3775, 0x0,
    0xad4b, 0x0, 0xb839, 0x0, 0xb9d7, 0x0, 0xb775, 0x0,
    0x230e, 0x0, 0x3856, 0x0, 0x39cc, 0x0, 0x37fd, 0x0,
    0x25cd, 0x0, 0xb7a6, 0x0, 0xb9ba, 0x0, 0xb86c, 0x0,
    0xacd1, 0x0, 0x36e5, 0x0, 0x3959, 0x0, 0x3628, 0x0,
    0xa76a, 0x0, 0xb80a, 0x0, 0xba83, 0x0, 0xb78d, 0x0,
    0xa13e, 0x0, 0x37ab, 0x0, 0x397f, 0x0, 0x3810, 0x0,
    0x2081, 0x0, 0xb7a3, 0x0, 0xba55, 0x0, 0xb7bf, 0x0,
    0xa016, 0x0, 0x37de, 0x0, 0x3a4f, 0x0, 0x38ad, 0x0,
    0x9d32, 0x0, 0xb738, 0x0, 0xb931, 0x0, 0xb7f6, 0x0,
    0x29e1, 0x0, 0x37f0, 0x0, 0x39a6, 0x0, 0x383d, 0x0,
    0x2d2c, 0x0, 0xb85f, 0x0, 0xb916, 0x0, 0xb771, 0x0,
    0xa98a, 0x0, 0x36d7, 0x0, 0x39a6, 0x0, 0x3811, 0x0,
    0x23b3, 0x0, 0xb656, 0x0, 0xb9c1, 0x0, 0xb830, 0x0,
    0x28a6, 0x0, 0x380b, 0x0, 0x3944, 0x0, 0x3801, 0x0,
    0x1a2c, 0x0, 0xb847, 0x0, 0xb996, 0x0, 0xb763, 0x0,
    0x2d3c, 0x0, 0x389c, 0x0, 0x3991, 0x0, 0x382c, 0x0,
    0xac84, 0x0, 0xb77a, 0x0, 0xb984, 0x0, 0xb742, 0x0,
    0x2d7d, 0x0, 0x3859, 0x0, 0x3a09, 0x0, 0x38ae, 0x0,
    0x29ce, 0x0, 0xb885, 0x0, 0xb9e2, 0x0, 0xb7f9, 0x0,
    0xa3c0, 0x0, 0x3672, 0x0, 0x39ed, 0x0, 0x3824, 0x0,
    0xab39, 0x0, 0xb8b9, 0x0, 0xb93e, 0x0, 0xb7f5, 0x0,
    0xacbb, 0x0, 0x37bc, 0x0, 0x397a, 0x0, 0x38ae, 0x0,
    0xa223, 0x0, 0xb717, 0x0, 0xb8f1, 0x0, 0xb6b6, 0x0,
    0xa590, 0x0, 0x38d6, 0x0, 0x3a2d, 0x0, 0x3856, 0x0,
    0xa8d4, 0x0, 0xb70a, 0x0, 0xb972, 0x0, 0xb82e, 0x0,
    0xac24, 0x0, 0x37df, 0x0, 0x3946, 0x0, 0x3842, 0x0,
    0x28c7, 0x0, 0xb837, 0x0, 0xba75, 0x0, 0xb8a4, 0x0,
    0x2b7b, 0x0, 0x38c0, 0x0, 0x3980, 0x0, 0x381a, 0x0,
    0xa026, 0x0, 0xb7d4, 0x0, 0xb9a3, 0x0, 0xb8c5, 0x0,
    0x28fa, 0x0, 0x381f, 0x0, 0x3a18, 0x0, 0x366f, 0x0,
    0xac22, 0x0, 0xb80c, 0x0, 0xb938, 0x0, 0xb835, 0x0,
    0xa31c, 0x0, 0x37a9, 0x0, 0x3912, 0x0, 0x377d, 0x0,
    0xaae6, 0x0, 0xb805, 0x0, 0xba2d, 0x0, 0xb879, 0x0,
    0xa6b8, 0x0, 0x3887, 0x0, 0x390a, 0x0, 0x3849, 0x0,
    0xa82d, 0x0, 0xb7b6, 0x0, 0xb98e, 0x0, 0xb7ad, 0x0,
    0x2717, 0x0, 0x3864, 0x0, 0x392a, 0x0, 0x388b, 0x0,
    0xa3e5, 0x0, 0xb844, 0x0, 0xb955, 0x0, 0xb81b, 0x0,
    0x2926, 0x0, 0x37f3, 0x0, 0x3947, 0x0, 0x3808, 0x0,
    0xb027, 0x0, 0xb828, 0x0, 0xb9fa, 0x0, 0xb7c8, 0x0,
    0x2a8d, 0x0, 0x381d, 0x0, 0x3965, 0x0, 0x382e, 0x0,
    0x1e4d, 0x0, 0xb899, 0x0, 0xb9e1, 0x0, 0xb762, 0x0,
    0x1bc1, 0x0, 0x3893, 0x0, 0x3a06, 0x0, 0x380f, 0x0,
    0xacd6, 0x0, 0xb751, 0x0, 0xb9ac, 0x0, 0xb856, 0x0,
    0x1ea4, 0x0, 0x372b, 0x0, 0x394e, 0x0, 0x37b5, 0x0,
    0xa95c, 0x0, 0xb89d, 0x0, 0xb9be, 0x0, 0xb77b, 0x0,
    0x25a2, 0x0, 0x381f, 0x0, 0x39c5, 0x0, 0x3806, 0x0,
    0xa91f, 0x0, 0xb6cf, 0x0, 0xb932, 0x0, 0xb7db, 0x0,
    0x29ea, 0x0, 0x36f6, 0x0, 0x392d, 0x0, 0x37e6, 0x0,
    0x2234, 0x0, 0xb823, 0x0, 0xba21, 0x0, 0xb838, 0x0,
    0xac9b, 0x0, 0x3788, 0x0, 0x39c7, 0x0, 0x3776, 0x0,
    0x2c56, 0x0, 0xb857, 0x0, 0xb9d5, 0x0, 0xb85a, 0x0,
    0x2a83, 0x0, 0x3874, 0x0, 0x3947, 0x0, 0x3666, 0x0,
    0x23ec, 0x0, 0xb8f8, 0x0, 0xb91f, 0x0, 0xb6b8, 0x0,
    0xa836, 0x0, 0x382b, 0x0, 0x398f, 0x0, 0x382a, 0x0,
    0xac2e, 0x0, 0xb76f, 0x0, 0xb988, 0x0, 0xb815, 0x0,
    0x2dad, 0x0, 0x373a, 0x0, 0x392a, 0x0, 0x386a, 0x0,
    0x29bb, 0x0, 0xb832, 0x0, 0xb96d, 0x0, 0xb812, 0x0,
    0xa946, 0x0, 0x3771, 0x0, 0x395a, 0x0, 0x3826, 0x0,
    0xaa49, 0x0, 0xb721, 0x0, 0xb955, 0x0, 0xb731, 0x0,
    0x279f, 0x0, 0x373e, 0x0, 0x3a09, 0x0, 0x38af, 0x0,
    0x2b4f, 0x0, 0xb7ce, 0x0, 0xb94d, 0x0, 0xb83d, 0x0,
    0x2a02, 0x0, 0x384d, 0x0, 0x397a, 0x0, 0x3802, 0x0,
    0xa7dd, 0x0, 0xb841, 0x0, 0xb921, 0x0, 0xb7d7, 0x0,
    0x2fba, 0x0, 0x3733, 0x0, 0x39a4, 0x0, 0x364d, 0x0,
    0xa4c5, 0x0, 0xb86f, 0x0, 0xb9a1, 0x0, 0xb602, 0x0,
    0x2a97, 0x0, 0x37eb, 0x0, 0x39b9, 0x0, 0x3814, 0x0,
    0x26db, 0x0, 0xb75b, 0x0, 0xb905, 0x0, 0xb6e1, 0x0,
    0xaa5b, 0x0, 0x38a2, 0x0, 0x3928, 0x0, 0x3824, 0x0,
    0xa267, 0x0, 0xb856, 0x0, 0xb8b4, 0x0, 0xb7ee, 0x0,
    0x2d37, 0x0, 0x3806, 0x0, 0x3a01, 0x0, 0x3875, 0x0,
    0x9608, 0x0, 0xb836, 0x0, 0xb9a3, 0x0, 0xb7a1, 0x0,
    0x1db6, 0x0, 0x3607, 0x0, 0x3a40, 0x0, 0x3832, 0x0,
    0xab6c, 0x0, 0xb855, 0x0, 0xba0c, 0x0, 0xb68f, 0x0,
    0x2853, 0x0, 0x383a, 0x0, 0x3904, 0x0, 0x3868, 0x0,
    0xacec, 0x0, 0xb860, 0x0, 0xb983, 0x0, 0xb828, 0x0,
    0xa650, 0x0, 0x3726, 0x0, 0x3967, 0x0, 0x37d2, 0x0,
    0x801a, 0x0, 0xb84f, 0x0, 0xb9ca, 0x0, 0xb817, 0x0,
    0x24ba, 0x0, 0x3849, 0x0, 0x396d, 0x0, 0x3836, 0x0,
    0x28be, 0x0, 0xb7cb, 0x0, 0xb9cf, 0x0, 0xb850, 0x0,
    0xa105, 0x0, 0x37d1, 0x0, 0x39c4, 0x0, 0x3811, 0x0,
    0x2853, 0x0, 0xb6cb, 0x0, 0xba25, 0x0, 0xb864, 0x0,
    0x2016, 0x0, 0x3870, 0x0, 0x39d6, 0x0, 0x373e, 0x0,
    0x2cdb, 0x0, 0xb771, 0x0, 0xb91a, 0x0, 0xb7c0, 0x0,
    0xace3, 0x0, 0x3789, 0x0, 0x398d, 0x0, 0x36a4, 0x0,
    0xae01, 0x0, 0xb8ad, 0x0, 0xb90f, 0x0, 0xb75c, 0x0,
    0x23aa, 0x0, 0x3824, 0x0, 0x3991, 0x0, 0x37a7, 0x0,
    0x1dde, 0x0, 0xb7b6, 0x0, 0xb90b, 0x0, 0xb82d, 0x0,
    0xae1a, 0x0, 0x37c3, 0x0, 0x3a17, 0x0, 0x3786, 0x0,
    0x2617, 0x0, 0xb750, 0x0, 0xb9f2, 0x0, 0xb814, 0x0,
    0x2145, 0x0, 0x3854, 0x0, 0x39d4, 0x0, 0x3846, 0x0,
    0xa081, 0x0, 0xb763, 0x0, 0xb95c, 0x0, 0xb845, 0x0,
    0x1d2a, 0x0, 0x3880, 0x0, 0x3a40, 0x0, 0x3732, 0x0,
    0x2c67, 0x0, 0xb871, 0x0, 0xb98c, 0x0, 0xb6fe, 0x0,
    0x2c91, 0x0, 0x373a, 0x0, 0x397c, 0x0, 0x3864, 0x0,
    0x2443, 0x0, 0xb81f, 0x0, 0xb9a8, 0x0, 0xb827, 0x0,
    0x2455, 0x0, 0x38b4, 0x0, 0x3980, 0x0, 0x3805, 0x0,
    0x2d20, 0x0, 0xb6c3, 0x0, 0xb956, 0x0, 0xb785, 0x0,
    0xa704, 0x0, 0x368c, 0x0, 0x399e, 0x0, 0x3809, 0x0,
    0x2a11, 0x0, 0xb811, 0x0, 0xba7a, 0x0, 0xb621, 0x0,
    0xa9bb, 0x0, 0x371e, 0x0, 0x39ce, 0x0, 0x3830, 0x0,
    0xa4ff, 0x0, 0xb87b, 0x0, 0xb9d2, 0x0, 0xb6e2, 0x0,
    0x1e50, 0x0, 0x389f, 0x0, 0x39c5, 0x0, 0x389e, 0x0,
    0xa5da, 0x0, 0xb7ad, 0x0, 0xb978, 0x0, 0xb6c6, 0x0,
    0xaa8b, 0x0, 0x3854, 0x0, 0x39de, 0x0, 0x38b4, 0x0,
    0xacb5, 0x0, 0xb87d, 0x0, 0xb8e0, 0x0, 0xb816, 0x0,
    0x1f48, 0x0, 0x3784, 0x0, 0x3939, 0x0, 0x3866, 0x0,
    0x2d34, 0x0, 0xb820, 0x0, 0xb977, 0x0, 0xb751, 0x0,
    0xa663, 0x0, 0x3740, 0x0, 0x38f2, 0x0, 0x3862, 0x0,
    0x227b, 0x0, 0xb784, 0x0, 0xb9ff, 0x0, 0xb783, 0x0,
    0xa1dc, 0x0, 0x385d, 0x0, 0x3924, 0x0, 0x36ab, 0x0,
    0x2b13, 0x0, 0xb77d, 0x0, 0xb924, 0x0, 0xb71d, 0x0,
    0xa666, 0x0, 0x37bd, 0x0, 0x3966, 0x0, 0x381c, 0x0,
    0x261e, 0x0, 0xb78c, 0x0, 0xb9ad, 0x0, 0xb886, 0x0,
    0xacf6, 0x0, 0x3657, 0x0, 0x39ab, 0x0, 0x37b5, 0x0,
    0x27b1, 0x0, 0xb820, 0x0, 0xb8ec, 0x0, 0xb709, 0x0,
    0x2a22, 0x0, 0x388c, 0x0, 0x3952, 0x0, 0x37da, 0x0,
    0x2b2a, 0x0, 0xb888, 0x0, 0xb920, 0x0, 0xb7f6, 0x0,
    0x2695, 0x0, 0x37ad, 0x0, 0x39bf, 0x0, 0x376c, 0x0,
    0x25ef, 0x0, 0xb760, 0x0, 0xb9f0, 0x0, 0xb82e, 0x0,
    0x9451, 0x0, 0x3838, 0x0, 0x398e, 0x0, 0x38cd, 0x0,
    0x265d, 0x0, 0xb7e6, 0x0, 0xb91a, 0x0, 0xb807, 0x0,
    0xac1b, 0x0, 0x377a, 0x0, 0x38e7, 0x0, 0x37b7, 0x0,
    0x2b30, 0x0, 0xb6e4, 0x0, 0xb963, 0x0, 0xb77e, 0x0,
    0xa8bf, 0x0, 0x37b1, 0x0, 0x3969, 0x0, 0x3837, 0x0,
    0x2612, 0x0, 0xb715, 0x0, 0xb9ad, 0x0, 0xb81a, 0x0,
    0xa0a3, 0x0, 0x38c5, 0x0, 0x3987, 0x0, 0x3861, 0x0,
    0x28a6, 0x0, 0xb839, 0x0, 0xb98d, 0x0, 0xb838, 0x0,
    0xa87d, 0x0, 0x37be, 0x0, 0x3941, 0x0, 0x380a, 0x0,
    0x871, 0x0, 0xb7a6, 0x0, 0xb933, 0x0, 0xb81a, 0x0,
    0xa4af, 0x0, 0x3764, 0x0, 0x3956, 0x0, 0x3855, 0x0,
    0x2528, 0x0, 0xb70b, 0x0, 0xb992, 0x0, 0xb833, 0x0,
    0xa9e7, 0x0, 0x38a4, 0x0, 0x3a21, 0x0, 0x3852, 0x0,
    0x2979, 0x0, 0xb783, 0x0, 0xb939, 0x0, 0xb84f, 0x0,
    0x20db, 0x0, 0x37b0, 0x0, 0x399d, 0x0, 0x37ae, 0x0,
    0x2b19, 0x0, 0xb89b, 0x0, 0xb8c1, 0x0, 0xb74d, 0x0,
    0xadba, 0x0, 0x3831, 0x0, 0x3a90, 0x0, 0x3743, 0x0,
    0xa5e0, 0x0, 0xb845, 0x0, 0xb9d3, 0x0, 0xb817, 0x0,
    0xa99c, 0x0, 0x3851, 0x0, 0x39ff, 0x0, 0x37fb, 0x0,
    0x294c, 0x0, 0xb804, 0x0, 0xb940, 0x0, 0xb6f5, 0x0,
    0x24a4, 0x0, 0x37f8, 0x0, 0x3996, 0x0, 0x3844, 0x0,
    0x2c6e, 0x0, 0xb7c3, 0x0, 0xb995, 0x0, 0xb845, 0x0,
    0xb00c, 0x0, 0x37b2, 0x0, 0x3998, 0x0, 0x3736, 0x0,
    0xa322, 0x0, 0xb74a, 0x0, 0xb9b1, 0x0, 0xb824, 0x0,
    0xaf66, 0x0, 0x3816, 0x0, 0x39ce, 0x0, 0x3842, 0x0,
    0x29ad, 0x0, 0xb851, 0x0, 0xb900, 0x0, 0xb704, 0x0,
    0xac64, 0x0, 0x3885, 0x0, 0x3984, 0x0, 0x3822, 0x0,
    0xa6a8, 0x0, 0xb798, 0x0, 0xb9cc, 0x0, 0xb879, 0x0,
    0xb018, 0x0, 0x37f9, 0x0, 0x3932, 0x0, 0x3793, 0x0,
    0xa389, 0x0, 0xb883, 0x0, 0xb9c6, 0x0, 0xb88f, 0x0,
    0x299f, 0x0, 0x37cf, 0x0, 0x3a0d, 0x0, 0x3753, 0x0,
    0x2af3, 0x0, 0xb761, 0x0, 0xb997, 0x0, 0xb6fc, 0x0,
    0x2fe5, 0x0, 0x3749, 0x0, 0x3a12, 0x0, 0x3826, 0x0,
    0xaba3, 0x0, 0xb7d9, 0x0, 0xb959, 0x0, 0xb810, 0x0,
    0x2cf4, 0x0, 0x385c, 0x0, 0x3952, 0x0, 0x37da, 0x0,
    0xa707, 0x0, 0xb8ad, 0x0, 0xb98a, 0x0, 0xb84f, 0x0,
    0xa19e, 0x0, 0x3824, 0x0, 0x398b, 0x0, 0x36d1, 0x0,
    0xac71, 0x0, 0xb8bf, 0x0, 0xb976, 0x0, 0xb792, 0x0,
    0xadd4, 0x0, 0x389d, 0x0, 0x39a5, 0x0, 0x3859, 0x0,
    0xa27d, 0x0, 0xb71f, 0x0, 0xb955, 0x0, 0xb661, 0x0,
    0x211a, 0x0, 0x3797, 0x0, 0x39aa, 0x0, 0x372b, 0x0,
    0x1d71, 0x0, 0xb755, 0x0, 0xb9b8, 0x0, 0xb828, 0x0,
    0x2ebc, 0x0, 0x3801, 0x0, 0x39a8, 0x0, 0x37a0, 0x0,
    0xacc3, 0x0, 0xb850, 0x0, 0xb9da, 0x0, 0xb698, 0x0,
    0xa91e, 0x0, 0x3841, 0x0, 0x39a2, 0x0, 0x36ed, 0x0,
    0x28cf, 0x0, 0xb85d, 0x0, 0xba2c, 0x0, 0xb797, 0x0,
    0x1fcd, 0x0, 0x3795, 0x0, 0x39d5, 0x0, 0x37c9, 0x0,
    0x295b, 0x0, 0xb852, 0x0, 0xb97b, 0x0, 0xb693, 0x0,
    0x2c57, 0x0, 0x3868, 0x0, 0x3934, 0x0, 0x37cf, 0x0,
    0x2822, 0x0, 0xb8cc, 0x0, 0xba3e, 0x0, 0xb7a6, 0x0,
    0x203a, 0x0, 0x382a, 0x0, 0x39eb, 0x0, 0x3748, 0x0,
    0x1e6e, 0x0, 0xb7c7, 0x0, 0xb96d, 0x0, 0xb740, 0x0,
    0x2900, 0x0, 0x370b, 0x0, 0x3992, 0x0, 0x386e, 0x0,
    0xa718, 0x0, 0xb75a, 0x0, 0xb8de, 0x0, 0xb6f1, 0x0,
    0x285f, 0x0, 0x372d, 0x0, 0x3923, 0x0, 0x376c, 0x0,
    0xa735, 0x0, 0xb87d, 0x0, 0xb9b9, 0x0, 0xb8f5, 0x0,
    0x3107, 0x0, 0x38a1, 0x0, 0x3a36, 0x0, 0x377b, 0x0,
    0x249c, 0x0, 0xb6bb, 0x0, 0xb9ba, 0x0, 0xb85a, 0x0,
    0xa9a3, 0x0, 0x384d, 0x0, 0x39d8, 0x0, 0x381f, 0x0,
    0x226c, 0x0, 0xb841, 0x0, 0xb9ab, 0x0, 0xb796, 0x0,
    0x2399, 0x0, 0x3840, 0x0, 0x3898, 0x0, 0x3858, 0x0,
    0x2c17, 0x0, 0xb869, 0x0, 0xb9f7, 0x0, 0xb89b, 0x0,
    0xaad4, 0x0, 0x3661, 0x0, 0x39a4, 0x0, 0x37eb, 0x0,
    0x2544, 0x0, 0xb89d, 0x0, 0xb990, 0x0, 0xb75c, 0x0,
    0xac35, 0x0, 0x37de, 0x0, 0x395b, 0x0, 0x3818, 0x0,
    0x9841, 0x0, 0xb817, 0x0, 0xb932, 0x0, 0xb81a, 0x0,
    0xa62a, 0x0, 0x3816, 0x0, 0x3931, 0x0, 0x3701, 0x0,
    0xaa7e, 0x0, 0xb764, 0x0, 0xb969, 0x0, 0xb883, 0x0,
    0x28fb, 0x0, 0x37f0, 0x0, 0x393f, 0x0, 0x3871, 0x0,
    0x12d9, 0x0, 0xb816, 0x0, 0xba4d, 0x0, 0xb7bf, 0x0,
    0xa754, 0x0, 0x36fa, 0x0, 0x3900, 0x0, 0x37e4, 0x0,
    0x231d, 0x0, 0xb74f, 0x0, 0xb99b, 0x0, 0xb86e, 0x0,
    0xadbd, 0x0, 0x37c6, 0x0, 0x3945, 0x0, 0x37c6, 0x0,
    0xa73a, 0x0, 0xb705, 0x0, 0xb9b1, 0x0, 0xb6d9, 0x0,
    0xa47f, 0x0, 0x37d5, 0x0, 0x3a0b, 0x0, 0x36ec, 0x0,
    0x22f2, 0x0, 0xb706, 0x0, 0xb956, 0x0, 0xb803, 0x0,
    0xa621, 0x0, 0x3898, 0x0, 0x3969, 0x0, 0x388c, 0x0,
    0x2cf5, 0x0, 0xb770, 0x0, 0xb99c, 0x0, 0xb7e3, 0x0,
    0x21d4, 0x0, 0x37e1, 0x0, 0x395c, 0x0, 0x377f, 0x0,
    0x275a, 0x0, 0xb806, 0x0, 0xb9bb, 0x0, 0xb83e, 0x0,
    0x28a0, 0x0, 0x37c8, 0x0, 0x397c, 0x0, 0x386b, 0x0,
    0xa6de, 0x0, 0xb7e0, 0x0, 0xb8f5, 0x0, 0xb7d9, 0x0,
    0xa02e, 0x0, 0x3817, 0x0, 0x3a0d, 0x0, 0x380b, 0x0,
    0x954f, 0x0, 0xb786, 0x0, 0xb87a, 0x0, 0xb780, 0x0,
    0x2517, 0x0, 0x37d8, 0x0, 0x3a18, 0x0, 0x3831, 0x0,
    0x9fc7, 0x0, 0xb804, 0x0, 0xba1b, 0x0, 0xb754, 0x0,
    0x9ef5, 0x0, 0x3854, 0x0, 0x39b6, 0x0, 0x3845, 0x0,
    0xab08, 0x0, 0xb641, 0x0, 0xb977, 0x0, 0xb863, 0x0,
    0x1f30, 0x0, 0x36cb, 0x0, 0x3968, 0x0, 0x3866, 0x0,
    0xa6ec, 0x0, 0xb6ec, 0x0, 0xb8b5, 0x0, 0xb7d0, 0x0,
    0x9b33, 0x0, 0x37a2, 0x0, 0x3952, 0x0, 0x37f6, 0x0,
    0x2d73, 0x0, 0xb898, 0x0, 0xb950, 0x0, 0xb85c, 0x0,
    0xab84, 0x0, 0x3947, 0x0, 0x38e2, 0x0, 0x37df, 0x0,
    0x2c37, 0x0, 0xb78b, 0x0, 0xb918, 0x0, 0xb789, 0x0,
    0x2628, 0x0, 0x3834, 0x0, 0x38bc, 0x0, 0x389b, 0x0,
    0xaa28, 0x0, 0xb85d, 0x0, 0xba42, 0x0, 0xb81d, 0x0,
    0xa510, 0x0, 0x37c7, 0x0, 0x3a07, 0x0, 0x375a, 0x0,
    0xaa4a, 0x0, 0xb868, 0x0, 0xb982, 0x0, 0xb800, 0x0,
    0x2b90, 0x0, 0x3729, 0x0, 0x39c6, 0x0, 0x38e0, 0x0,
    0x2874, 0x0, 0xb7c0, 0x0, 0xb8e9, 0x0, 0xb846, 0x0,
    0x2c81, 0x0, 0x38b4, 0x0, 0x3a21, 0x0, 0x3861, 0x0,
    0x2502, 0x0, 0xb747, 0x0, 0xb969, 0x0, 0xb823, 0x0,
    0x2ae7, 0x0, 0x385c, 0x0, 0x39fd, 0x0, 0x3826, 0x0,
    0x9879, 0x0, 0xb8a4, 0x0, 0xb93d, 0x0, 0xb805, 0x0,
    0x9490, 0x0, 0x3827, 0x0, 0x398b, 0x0, 0x3854, 0x0,
    0xab2c, 0x0, 0xb870, 0x0, 0xb994, 0x0, 0xb7d2, 0x0,
    0xab14, 0x0, 0x37ce, 0x0, 0x39e3, 0x0, 0x3816, 0x0,
    0xa536, 0x0, 0xb7ff, 0x0, 0xb920, 0x0, 0xb876, 0x0,
    0x1d36, 0x0, 0x3861, 0x0, 0x390d, 0x0, 0x37f1, 0x0,
    0x2b2c, 0x0, 0xb7cd, 0x0, 0xb9cd, 0x0, 0xb6cc, 0x0,
    0x2d6d, 0x0, 0x383f, 0x0, 0x3961, 0x0, 0x378e, 0x0,
    0xa5fe, 0x0, 0xb808, 0x0, 0xb96c, 0x0, 0xb82f, 0x0,
    0xa0a4, 0x0, 0x377c, 0x0, 0x3980, 0x0, 0x3793, 0x0,
    0xa6b3, 0x0, 0xb6ec, 0x0, 0xba07, 0x0, 0xb764, 0x0,
    0xa7bc, 0x0, 0x37e9, 0x0, 0x39b5, 0x0, 0x381a, 0x0,
    0x2999, 0x0, 0xb82c, 0x0, 0xb9b7, 0x0, 0xb7f3, 0x0,
    0x9365, 0x0, 0x3842, 0x0, 0x3921, 0x0, 0x372c, 0x0,
    0xa6db, 0x0, 0xb84d, 0x0, 0xb920, 0x0, 0xb7b3, 0x0,
    0xa0ed, 0x0, 0x37b5, 0x0, 0x3a2d, 0x0, 0x3790, 0x0,
    0x263d, 0x0, 0xb7d0, 0x0, 0xb9f1, 0x0, 0xb767, 0x0,
    0xacb4, 0x0, 0x3857, 0x0, 0x39c0, 0x0, 0x3866, 0x0,
    0x172d, 0x0, 0xb7c4, 0x0, 0xb94f, 0x0, 0xb864, 0x0,
    0x2df2, 0x0, 0x37af, 0x0, 0x399e, 0x0, 0x381f, 0x0,
    0x26d6, 0x0, 0xb7c4, 0x0, 0xb91a, 0x0, 0xb7fb, 0x0,
    0x293f, 0x0, 0x376f, 0x0, 0x3961, 0x0, 0x382b, 0x0,
    0x2513, 0x0, 0xb837, 0x0, 0xb9ef, 0x0, 0xb7e8, 0x0,
    0x2602, 0x0, 0x3702, 0x0, 0x397e, 0x0, 0x3748, 0x0,
    0x2f21, 0x0, 0xb720, 0x0, 0xb989, 0x0, 0xb61f, 0x0,
    0x261a, 0x0, 0x3814, 0x0, 0x3891, 0x0, 0x3847, 0x0,
    0xac95, 0x0, 0xb806, 0x0, 0xb997, 0x0, 0xb87b, 0x0,
    0x200d, 0x0, 0x38b3, 0x0, 0x3a08, 0x0, 0x36aa, 0x0,
    0xaadb, 0x0, 0xb7f1, 0x0, 0xb9e9, 0x0, 0xb68f, 0x0,
    0x1d67, 0x0, 0x3879, 0x0, 0x39ec, 0x0, 0x3805, 0x0,
    0x2ed5, 0x0, 0xb750, 0x0, 0xb9cf, 0x0, 0xb75b, 0x0,
    0x29f2, 0x0, 0x387c, 0x0, 0x3a1a, 0x0, 0x37df, 0x0,
    0xa642, 0x0, 0xb70a, 0x0, 0xb975, 0x0, 0xb890, 0x0,
    0xa6ae, 0x0, 0x37eb, 0x0, 0x393a, 0x0, 0x3804, 0x0,
    0x275b, 0x0, 0xb6b3, 0x0, 0xba97, 0x0, 0xb7da, 0x0,
    0xa6b7, 0x0, 0x3753, 0x0, 0x39d4, 0x0, 0x377b, 0x0,
    0xa946, 0x0, 0xb838, 0x0, 0xb8e0, 0x0, 0xb7c2, 0x0,
    0xa543, 0x0, 0x3686, 0x0, 0x3957, 0x0, 0x3811, 0x0,
    0xa968, 0x0, 0xb7a2, 0x0, 0xb92b, 0x0, 0xb8dc, 0x0,
    0x2871, 0x0, 0x3864, 0x0, 0x39d4, 0x0, 0x376c, 0x0,
    0x9c40, 0x0, 0xb6b4, 0x0, 0xb984, 0x0, 0xb732, 0x0,
    0xaf0f, 0x0, 0x378d, 0x0, 0x38e4, 0x0, 0x372e, 0x0,
    0xa166, 0x0, 0xb743, 0x0, 0xb936, 0x0, 0xb84b, 0x0,
    0x2895, 0x0, 0x3703, 0x0, 0x396c, 0x0, 0x36df, 0x0,
    0x2709, 0x0, 0xb706, 0x0, 0xb954, 0x0, 0xb79a, 0x0,
    0x1c87, 0x0, 0x38b5, 0x0, 0x3a0d, 0x0, 0x37fe, 0x0,
    0xa4ea, 0x0, 0xb762, 0x0, 0xb943, 0x0, 0xb87c, 0x0,
    0xaaf8, 0x0, 0x370d, 0x0, 0x39f8, 0x0, 0x383f, 0x0,
    0xa553, 0x0, 0xb88c, 0x0, 0xb8cb, 0x0, 0xb6ea, 0x0,
    0x3040, 0x0, 0x3821, 0x0, 0x392d, 0x0, 0x3802, 0x0,
    0xa1e0, 0x0, 0xb838, 0x0, 0xb9c4, 0x0, 0xb7d2, 0x0,
    0xa97c, 0x0, 0x379b, 0x0, 0x39dc, 0x0, 0x3796, 0x0,
    0x28f1, 0x0, 0xb853, 0x0, 0xba0d, 0x0, 0xb722, 0x0,
    0xabdf, 0x0, 0x3856, 0x0, 0x3954, 0x0, 0x3829, 0x0,
    0xab32, 0x0, 0xb79b, 0x0, 0xb913, 0x0, 0xb76a, 0x0,
    0x1abe, 0x0, 0x37f6, 0x0, 0x3965, 0x0, 0x3802, 0x0,
    0x2585, 0x0, 0xb89f, 0x0, 0xb9af, 0x0, 0xb866, 0x0,
    0xac28, 0x0, 0x376a, 0x0, 0x392c, 0x0, 0x3858, 0x0,
    0x266c, 0x0, 0xb6ac, 0x0, 0xb9dd, 0x0, 0xb810, 0x0,
    0x280a, 0x0, 0x374d, 0x0, 0x3994, 0x0, 0x3811, 0x0,
    0xa00f, 0x0, 0xb707, 0x0, 0xb959, 0x0, 0xb835, 0x0,
    0xa533, 0x0, 0x381a, 0x0, 0x38a2, 0x0, 0x38a6, 0x0,
    0x283a, 0x0, 0xb85d, 0x0, 0xb925, 0x0, 0xb703, 0x0,
    0xa40b, 0x0, 0x37e2, 0x0, 0x39c1, 0x0, 0x3815, 0x0,
    0x29a0, 0x0, 0xb7b8, 0x0, 0xb967, 0x0, 0xb82f, 0x0,
    0xa96f, 0x0, 0x37fc, 0x0, 0x397c, 0x0, 0x3810, 0x0,
    0xa6f7, 0x0, 0xb7a7, 0x0, 0xb9b5, 0x0, 0xb7c9, 0x0,
    0x2914, 0x0, 0x37ac, 0x0, 0x39a8, 0x0, 0x3819, 0x0,
    0xb007, 0x0, 0xb86b, 0x0, 0xb9e3, 0x0, 0xb755, 0x0,
    0x2b35, 0x0, 0x3716, 0x0, 0x38df, 0x0, 0x3696, 0x0,
    0xa873, 0x0, 0xb7be, 0x0, 0xb96c, 0x0, 0xb7cb, 0x0,
    0x22a8, 0x0, 0x370f, 0x0, 0x3a41, 0x0, 0x3819, 0x0,
    0x2f3a, 0x0, 0xb77c, 0x0, 0xb924, 0x0, 0xb86c, 0x0,
    0xa613, 0x0, 0x374f, 0x0, 0x3976, 0x0, 0x37bb, 0x0,
    0x2919, 0x0, 0xb66e, 0x0, 0xba05, 0x0, 0xb852, 0x0,
    0xa806, 0x0, 0x381a, 0x0, 0x3a57, 0x0, 0x376c, 0x0,
    0x2cd3, 0x0, 0xb750, 0x0, 0xb992, 0x0, 0xb8d4, 0x0,
    0x2d41, 0x0, 0x3845, 0x0, 0x3a9f, 0x0, 0x3723, 0x0,
    0x1e99, 0x0, 0xb7e9, 0x0, 0xb940, 0x0, 0xb842, 0x0,
    0xacc6, 0x0, 0x382b, 0x0, 0x39b5, 0x0, 0x3851, 0x0,
    0x286f, 0x0, 0xb6a1, 0x0, 0xb992, 0x0, 0xb734, 0x0,
    0x2e24, 0x0, 0x3719, 0x0, 0x393d, 0x0, 0x378a, 0x0,
    0xace6, 0x0, 0xb675, 0x0, 0xb969, 0x0, 0xb867, 0x0,
    0x8987, 0x0, 0x382b, 0x0, 0x39b2, 0x0, 0x36ce, 0x0,
    0x9f38, 0x0, 0xb795, 0x0, 0xb99d, 0x0, 0xb828, 0x0,
    0xa623, 0x0, 0x381e, 0x0, 0x3974, 0x0, 0x389c, 0x0,
    0x2739, 0x0, 0xb86f, 0x0, 0xb9fa, 0x0, 0xb7e3, 0x0,
    0x20a0, 0x0, 0x3734, 0x0, 0x3902, 0x0, 0x381c, 0x0,
    0x2d48, 0x0, 0xb82b, 0x0, 0xba4e, 0x0, 0xb80f, 0x0,
    0xa9b4, 0x0, 0x3782, 0x0, 0x398a, 0x0, 0x38ad, 0x0,
    0xa7bd, 0x0, 0xb898, 0x0, 0xb93d, 0x0, 0xb701, 0x0,
    0x26ed, 0x0, 0x3845, 0x0, 0x39bb, 0x0, 0x3860, 0x0,
    0xa4f4, 0x0, 0xb762, 0x0, 0xb942, 0x0, 0xb812, 0x0,
    0x2a57, 0x0, 0x3857, 0x0, 0x39b8, 0x0, 0x38db, 0x0,
    0xa78a, 0x0, 0xb7e4, 0x0, 0xb8da, 0x0, 0xb749, 0x0,
    0x2d29, 0x0, 0x36f1, 0x0, 0x39d5, 0x0, 0x3761, 0x0,
    0x2819, 0x0, 0xb7fc, 0x0, 0xb91f, 0x0, 0xb7bc, 0x0,
    0xa953, 0x0, 0x36dd, 0x0, 0x399f, 0x0, 0x37f5, 0x0,
    0x29ba, 0x0, 0xb731, 0x0, 0xb9c6, 0x0, 0xb852, 0x0,
    0xaa81, 0x0, 0x37a1, 0x0, 0x398c, 0x0, 0x3763, 0x0,
    0x281c, 0x0, 0xb6c5, 0x0, 0xb9a6, 0x0, 0xb5fe, 0x0,
    0xa006, 0x0, 0x367f, 0x0, 0x398c, 0x0, 0x37bb, 0x0,
    0x297a, 0x0, 0xb5f2, 0x0, 0xb942, 0x0, 0xb835, 0x0,
    0x2ca2, 0x0, 0x3828, 0x0, 0x3a11, 0x0, 0x3846, 0x0,
    0x23bb, 0x0, 0xb723, 0x0, 0xb9a3, 0x0, 0xb755, 0x0,
    0xa8a4, 0x0, 0x38a4, 0x0, 0x39db, 0x0, 0x37dd, 0x0,
    0xa8d4, 0x0, 0xb791, 0x0, 0xb93e, 0x0, 0xb794, 0x0,
    0x2421, 0x0, 0x3760, 0x0, 0x39d5, 0x0, 0x3837, 0x0,
    0x24a6, 0x0, 0xb625, 0x0, 0xba19, 0x0, 0xb622, 0x0,
    0x3084, 0x0, 0x3892, 0x0, 0x3943, 0x0, 0x3728, 0x0,
    0xa480, 0x0, 0xb8b3, 0x0, 0xb97d, 0x0, 0xb7a6, 0x0,
    0xa992, 0x0, 0x3893, 0x0, 0x3a35, 0x0, 0x3810, 0x0,
    0x2237, 0x0, 0xb85d, 0x0, 0xb972, 0x0, 0xb80c, 0x0,
    0xac18, 0x0, 0x380b, 0x0, 0x397e, 0x0, 0x3890, 0x0,
    0x21ae, 0x0, 0xb814, 0x0, 0xba55, 0x0, 0xb770, 0x0,
    0x2306, 0x0, 0x383b, 0x0, 0x39ff, 0x0, 0x386c, 0x0,
    0x9f24, 0x0, 0xb828, 0x0, 0xb9f9, 0x0, 0xb763, 0x0,
    0x1c15, 0x0, 0x383d, 0x0, 0x39a3, 0x0, 0x3800, 0x0,
    0xb033, 0x0, 0xb87e, 0x0, 0xb9a9, 0x0, 0xb76c, 0x0,
    0xa924, 0x0, 0x385a, 0x0, 0x3971, 0x0, 0x3818, 0x0,
    0x16a1, 0x0, 0xb857, 0x0, 0xb94d, 0x0, 0xb724, 0x0,
    0xa2d5, 0x0, 0x3860, 0x0, 0x3960, 0x0, 0x38a3, 0x0,
    0x1ea9, 0x0, 0xb7d0, 0x0, 0xb98b, 0x0, 0xb7cc, 0x0,
    0xa9dc, 0x0, 0x3741, 0x0, 0x39fb, 0x0, 0x36c9, 0x0,
    0xad13, 0x0, 0xb70e, 0x0, 0xb9a3, 0x0, 0xb874, 0x0,
    0x2dfd, 0x0, 0x371a, 0x0, 0x3947, 0x0, 0x3829, 0x0,
    0xa176, 0x0, 0xb75f, 0x0, 0xb95f, 0x0, 0xb7b6, 0x0,
    0xa9a5, 0x0, 0x3842, 0x0, 0x39ea, 0x0, 0x3808, 0x0,
    0xa9ef, 0x0, 0xb7af, 0x0, 0xb9f3, 0x0, 0xb825, 0x0,
    0x1fb1, 0x0, 0x3792, 0x0, 0x3a17, 0x0, 0x3829, 0x0,
    0x2002, 0x0, 0xb7e1, 0x0, 0xb99d, 0x0, 0xb8d1, 0x0,
    0x27b9, 0x0, 0x36e7, 0x0, 0x3a33, 0x0, 0x379e, 0x0,
    0x2808, 0x0, 0xb835, 0x0, 0xb955, 0x0, 0xb73f, 0x0,
    0xaae1, 0x0, 0x37fb, 0x0, 0x39cb, 0x0, 0x37b0, 0x0,
    0x2ee3, 0x0, 0xb80f, 0x0, 0xba42, 0x0, 0xb804, 0x0,
    0x265c, 0x0, 0x3748, 0x0, 0x39fd, 0x0, 0x381c, 0x0,
    0x22cb, 0x0, 0xb799, 0x0, 0xb9a5, 0x0, 0xb79d, 0x0,
    0xa476, 0x0, 0x385f, 0x0, 0x3993, 0x0, 0x3783, 0x0,
    0xa422, 0x0, 0xb7c5, 0x0, 0xb9bf, 0x0, 0xb80b, 0x0,
    0x1c5d, 0x0, 0x384b, 0x0, 0x3968, 0x0, 0x3861, 0x0,
    0x23f8, 0x0, 0xb6e8, 0x0, 0xb92d, 0x0, 0xb78d, 0x0,
    0xa05b, 0x0, 0x3805, 0x0, 0x3941, 0x0, 0x360c, 0x0,
    0x2ad5, 0x0, 0xb800, 0x0, 0xb9a8, 0x0, 0xb7ce, 0x0,
    0x29c5, 0x0, 0x3822, 0x0, 0x39d6, 0x0, 0x3759, 0x0,
    0x275f, 0x0, 0xb82d, 0x0, 0xb91e, 0x0, 0xb822, 0x0,
    0xadc2, 0x0, 0x384a, 0x0, 0x39a8, 0x0, 0x38b6, 0x0,
    0x212c, 0x0, 0xb6f4, 0x0, 0xba03, 0x0, 0xb73b, 0x0,
    0xa66d, 0x0, 0x3809, 0x0, 0x3a9f, 0x0, 0x3833, 0x0,
    0x2a73, 0x0, 0xb80c, 0x0, 0xb9bb, 0x0, 0xb871, 0x0,
    0x2850, 0x0, 0x3838, 0x0, 0x3a05, 0x0, 0x37b4, 0x0,
    0xa916, 0x0, 0xb7ba, 0x0, 0xb8af, 0x0, 0xb787, 0x0,
    0x2a65, 0x0, 0x371c, 0x0, 0x396f, 0x0, 0x3801, 0x0,
    0x2921, 0x0, 0xb7d9, 0x0, 0xba60, 0x0, 0xb7e1, 0x0,
    0xaca5, 0x0, 0x3798, 0x0, 0x3934, 0x0, 0x387f, 0x0,
    0x2c06, 0x0, 0xb7bf, 0x0, 0xb9db, 0x0, 0xb8d0, 0x0,
    0xad2a, 0x0, 0x373f, 0x0, 0x39c7, 0x0, 0x37db, 0x0,
    0xa9b9, 0x0, 0xb7d9, 0x0, 0xb9a5, 0x0, 0xb691, 0x0,
    0xa8d1, 0x0, 0x3865, 0x0, 0x3a29, 0x0, 0x37c3, 0x0,
    0x1c06, 0x0, 0xb737, 0x0, 0xb8de, 0x0, 0xb826, 0x0,
    0x2e42, 0x0, 0x37d7, 0x0, 0x39f8, 0x0, 0x3801, 0x0,
    0x27b0, 0x0, 0xb628, 0x0, 0xb96f, 0x0, 0xb887, 0x0,
    0xa5a4, 0x0, 0x3690, 0x0, 0x39a7, 0x0, 0x3828, 0x0,
    0x2913, 0x0, 0xb83e, 0x0, 0xb9bd, 0x0, 0xb7b6, 0x0,
    0x2b85, 0x0, 0x3816, 0x0, 0x39b4, 0x0, 0x3702, 0x0,
    0x21ee, 0x0, 0xb726, 0x0, 0xb9b8, 0x0, 0xb76e, 0x0,
    0xad69, 0x0, 0x378e, 0x0, 0x3973, 0x0, 0x3747, 0x0,
    0xa92c, 0x0, 0xb820, 0x0, 0xba48, 0x0, 0xb795, 0x0,
    0x2349, 0x0, 0x37a5, 0x0, 0x3a29, 0x0, 0x37c6, 0x0,
    0x2c1b, 0x0, 0xb8a1, 0x0, 0xb97c, 0x0, 0xb74f, 0x0,
    0x2a3a, 0x0, 0x377a, 0x0, 0x3a61, 0x0, 0x3707, 0x0,
    0xac92, 0x0, 0xb816, 0x0, 0xba28, 0x0, 0xb832, 0x0,
    0xa8f5, 0x0, 0x369e, 0x0, 0x396e, 0x0, 0x38a2, 0x0,
    0x25f8, 0x0, 0xb7fa, 0x0, 0xb93d, 0x0, 0xb8b4, 0x0,
    0x22a8, 0x0, 0x37d5, 0x0, 0x3971, 0x0, 0x382f, 0x0,
    0x9812, 0x0, 0xb7bd, 0x0, 0xb979, 0x0, 0xb8ca, 0x0,
    0xac99, 0x0, 0x387e, 0x0, 0x3984, 0x0, 0x3751, 0x0,
    0xa7df, 0x0, 0xb766, 0x0, 0xb966, 0x0, 0xb880, 0x0,
    0x2c90, 0x0, 0x3793, 0x0, 0x396d, 0x0, 0x3760, 0x0,
    0xa300, 0x0, 0xb8f1, 0x0, 0xba06, 0x0, 0xb7d8, 0x0,
    0x2618, 0x0, 0x37f7, 0x0, 0x3a03, 0x0, 0x385f, 0x0,
    0x1e04, 0x0, 0xb724, 0x0, 0xb9d3, 0x0, 0xb77d, 0x0,
    0x2bde, 0x0, 0x3832, 0x0, 0x390e, 0x0, 0x37f6, 0x0,
    0x2463, 0x0, 0xb7f5, 0x0, 0xb97c, 0x0, 0xb78d, 0x0,
    0x2b10, 0x0, 0x3870, 0x0, 0x3995, 0x0, 0x370d, 0x0,
    0xab6a, 0x0, 0xb7dd, 0x0, 0xb9b4, 0x0, 0xb7e6, 0x0,
    0xa180, 0x0, 0x373e, 0x0, 0x3941, 0x0, 0x3879, 0x0,
    0x27a6, 0x0, 0xb782, 0x0, 0xb996, 0x0, 0xb702, 0x0,
    0xa889, 0x0, 0x385b, 0x0, 0x3a87, 0x0, 0x37cf, 0x0,
    0x2d86, 0x0, 0xb806, 0x0, 0xba3e, 0x0, 0xb734, 0x0,
    0xb027, 0x0, 0x365f, 0x0, 0x3a0b, 0x0, 0x37be, 0x0,
    0x9c34, 0x0, 0xb7ad, 0x0, 0xb95e, 0x0, 0xb78d, 0x0,
    0x93b3, 0x0, 0x388c, 0x0, 0x399a, 0x0, 0x372f, 0x0,
    0xa5ea, 0x0, 0xb6e4, 0x0, 0xb98b, 0x0, 0xb706, 0x0,
    0x1ce0, 0x0, 0x37da, 0x0, 0x3941, 0x0, 0x385e, 0x0,
    0x479, 0x0, 0xb735, 0x0, 0xb99a, 0x0, 0xb854, 0x0,
    0x19dd, 0x0, 0x36c8, 0x0, 0x3948, 0x0, 0x3743, 0x0,
    0xa0ae, 0x0, 0xb864, 0x0, 0xb9a8, 0x0, 0xb69b, 0x0,
    0x29cf, 0x0, 0x382e, 0x0, 0x39d6, 0x0, 0x376a, 0x0,
    0xa833, 0x0, 0xb7f3, 0x0, 0xb9ac, 0x0, 0xb771, 0x0,
    0xa8a7, 0x0, 0x3817, 0x0, 0x3966, 0x0, 0x3896, 0x0,
    0xad76, 0x0, 0xb80f, 0x0, 0xba0e, 0x0, 0xb87a, 0x0,
    0xa8aa, 0x0, 0x3775, 0x0, 0x3930, 0x0, 0x381a, 0x0,
    0x1fc1, 0x0, 0xb66c, 0x0, 0xb968, 0x0, 0xb821, 0x0,
    0xa865, 0x0, 0x382f, 0x0, 0x397a, 0x0, 0x3732, 0x0,
    0xa9f3, 0x0, 0xb87b, 0x0, 0xb895, 0x0, 0xb6d6, 0x0,
    0x21dd, 0x0, 0x3824, 0x0, 0x39e6, 0x0, 0x3712, 0x0,
    0x2c77, 0x0, 0xb829, 0x0, 0xba21, 0x0, 0xb67f, 0x0,
    0x1d08, 0x0, 0x37e5, 0x0, 0x39ec, 0x0, 0x3857, 0x0,
    0x2541, 0x0, 0xb6ff, 0x0, 0xb9a2, 0x0, 0xb6e7, 0x0,
    0x2cec, 0x0, 0x3830, 0x0, 0x39f1, 0x0, 0x3899, 0x0,
    0xa0a1, 0x0, 0xb6c7, 0x0, 0xb971, 0x0, 0xb80f, 0x0,
    0xac14, 0x0, 0x3701, 0x0, 0x390f, 0x0, 0x3769, 0x0,
    0xaa08, 0x0, 0xb67f, 0x0, 0xba37, 0x0, 0xb7d9, 0x0,
    0x9e8b, 0x0, 0x36e4, 0x0, 0x39ad, 0x0, 0x380d, 0x0,
    0xac05, 0x0, 0xb695, 0x0, 0xb9a4, 0x0, 0xb5dd, 0x0,
    0x2568, 0x0, 0x370d, 0x0, 0x3955, 0x0, 0x36c1, 0x0,
    0x25b3, 0x0, 0xb6f2, 0x0, 0xba35, 0x0, 0xb7b2, 0x0,
    0x2b25, 0x0, 0x3817, 0x0, 0x3911, 0x0, 0x3709, 0x0,
    0xa142, 0x0, 0xb880, 0x0, 0xb98b, 0x0, 0xb7cc, 0x0,
    0x22cf, 0x0, 0x37cb, 0x0, 0x39e4, 0x0, 0x366a, 0x0,
    0x2113, 0x0, 0xb729, 0x0, 0xb922, 0x0, 0xb65e, 0x0,
    0x2b19, 0x0, 0x37e4, 0x0, 0x39c8, 0x0, 0x37a8, 0x0,
    0x2340, 0x0, 0xb786, 0x0, 0xb9e0, 0x0, 0xb7dd, 0x0,
    0x294b, 0x0, 0x3820, 0x0, 0x390a, 0x0, 0x3801, 0x0,
    0xaa3e, 0x0, 0xb7ff, 0x0, 0xb9e9, 0x0, 0xb6a9, 0x0,
    0xab5c, 0x0, 0x36b6, 0x0, 0x395c, 0x0, 0x3845, 0x0,
    0x9901, 0x0, 0xb7f9, 0x0, 0xb94c, 0x0, 0xb789, 0x0,
    0x2c63, 0x0, 0x381e, 0x0, 0x3970, 0x0, 0x38c7, 0x0,
    0x24f3, 0x0, 0xb84c, 0x0, 0xb9a8, 0x0, 0xb739, 0x0,
    0x263f, 0x0, 0x3782, 0x0, 0x3a2f, 0x0, 0x36a5, 0x0,
    0x2b51, 0x0, 0xb853, 0x0, 0xb8a4, 0x0, 0xb7ac, 0x0,
    0x29e6, 0x0, 0x37cb, 0x0, 0x3965, 0x0, 0x379e, 0x0,
    0xa89a, 0x0, 0xb7c3, 0x0, 0xb9d1, 0x0, 0xb819, 0x0,
    0x143e, 0x0, 0x382f, 0x0, 0x397f, 0x0, 0x37e6, 0x0,
    0xa90c, 0x0, 0xb6ca, 0x0, 0xb98e, 0x0, 0xb686, 0x0,
    0xa69d, 0x0, 0x373b, 0x0, 0x39e6, 0x0, 0x3826, 0x0,
    0x2cf0, 0x0, 0xb689, 0x0, 0xb96f, 0x0, 0xb7ff, 0x0,
    0x1e2d, 0x0, 0x36d3, 0x0, 0x3996, 0x0, 0x3743, 0x0,
    0x2b2c, 0x0, 0xb744, 0x0, 0xb87c, 0x0, 0xb6eb, 0x0,
    0x1dc7, 0x0, 0x3874, 0x0, 0x3a75, 0x0, 0x3713, 0x0,
    0x92b4, 0x0, 0xb852, 0x0, 0xb9fd, 0x0, 0xb82b, 0x0,
    0x2c15, 0x0, 0x38c0, 0x0, 0x39a2, 0x0, 0x375f, 0x0,
    0x1ca3, 0x0, 0xb6a4, 0x0, 0xb932, 0x0, 0xb7fa, 0x0,
    0x2ef5, 0x0, 0x3725, 0x0, 0x39bb, 0x0, 0x36b3, 0x0,
    0x24bb, 0x0, 0xb8b6, 0x0, 0xb9b8, 0x0, 0xb791, 0x0,
    0x25d3, 0x0, 0x38a1, 0x0, 0x3a60, 0x0, 0x3817, 0x0,
    0x2dff, 0x0, 0xb7de, 0x0, 0xba46, 0x0, 0xb7e2, 0x0,
    0xa780, 0x0, 0x35ef, 0x0, 0x3998, 0x0, 0x3776, 0x0,
    0x9ff5, 0x0, 0xb861, 0x0, 0xb8fc, 0x0, 0xb802, 0x0,
    0xa933, 0x0, 0x3793, 0x0, 0x3958, 0x0, 0x376d, 0x0,
    0xa76b, 0x0, 0xb8d7, 0x0, 0xb9c7, 0x0, 0xb77a, 0x0,
    0xabfd, 0x0, 0x3838, 0x0, 0x395b, 0x0, 0x3875, 0x0,
    0x2ca2, 0x0, 0xb798, 0x0, 0xba27, 0x0, 0xb87b, 0x0,
    0x2bbb, 0x0, 0x37e8, 0x0, 0x3a29, 0x0, 0x3793, 0x0,
    0xac2a, 0x0, 0xb879, 0x0, 0xb9e6, 0x0, 0xb809, 0x0,
    0xac3e, 0x0, 0x3730, 0x0, 0x396b, 0x0, 0x36b6, 0x0,
    0x2891, 0x0, 0xb895, 0x0, 0xba52, 0x0, 0xb804, 0x0,
    0x2f2b, 0x0, 0x3721, 0x0, 0x39b2, 0x0, 0x37ca, 0x0,
    0x2929, 0x0, 0xb868, 0x0, 0xb9fc, 0x0, 0xb7c0, 0x0,
    0xac9e, 0x0, 0x3851, 0x0, 0x398a, 0x0, 0x3842, 0x0,
    0x280b, 0x0, 0xb860, 0x0, 0xb94a, 0x0, 0xb801, 0x0,
    0x21f9, 0x0, 0x3785, 0x0, 0x3987, 0x0, 0x3783, 0x0,
    0xaa1f, 0x0, 0xb84a, 0x0, 0xba32, 0x0, 0xb77e, 0x0,
    0xa73a, 0x0, 0x382b, 0x0, 0x3998, 0x0, 0x376a, 0x0,
    0x2e6f, 0x0, 0xb80d, 0x0, 0xb98d, 0x0, 0xb831, 0x0,
    0x9fcb, 0x0, 0x3710, 0x0, 0x3963, 0x0, 0x36fa, 0x0,
    0xadd3, 0x0, 0xb775, 0x0, 0xb973, 0x0, 0xb6eb, 0x0,
    0x96ce, 0x0, 0x373a, 0x0, 0x3901, 0x0, 0x3853, 0x0,
    0xa7ff, 0x0, 0xb6cc, 0x0, 0xb9a4, 0x0, 0xb80f, 0x0,
    0x2caa, 0x0, 0x3795, 0x0, 0x3999, 0x0, 0x3785, 0x0,
    0xa5ce, 0x0, 0xb7fd, 0x0, 0xb9c0, 0x0, 0xb87b, 0x0,
    0xa6f9, 0x0, 0x3877, 0x0, 0x3911, 0x0, 0x37df, 0x0,
    0x2855, 0x0, 0xb7c1, 0x0, 0xb9ac, 0x0, 0xb79a, 0x0,
    0x20d2, 0x0, 0x37bf, 0x0, 0x3957, 0x0, 0x3709, 0x0,
    0x2f46, 0x0, 0xb835, 0x0, 0xb9bb, 0x0, 0xb6b0, 0x0,
    0x2852, 0x0, 0x37b1, 0x0, 0x391f, 0x0, 0x36f6, 0x0,
    0x2c2e, 0x0, 0xb823, 0x0, 0xb94d, 0x0, 0xb81c, 0x0,
    0x239a, 0x0, 0x38a2, 0x0, 0x39f1, 0x0, 0x3797, 0x0,
    0x9c89, 0x0, 0xb84e, 0x0, 0xb948, 0x0, 0xb828, 0x0,
    0xacc7, 0x0, 0x3699, 0x0, 0x3954, 0x0, 0x368e, 0x0,
    0xa98f, 0x0, 0xb7fe, 0x0, 0xbab2, 0x0, 0xb7c6, 0x0,
    0x2e77, 0x0, 0x3840, 0x0, 0x39a6, 0x0, 0x3724, 0x0,
    0xa7e3, 0x0, 0xb701, 0x0, 0xb9ca, 0x0, 0xb7ed, 0x0,
    0xabbe, 0x0, 0x37c1, 0x0, 0x39a1, 0x0, 0x3669, 0x0,
    0x26bb, 0x0, 0xb6c7, 0x0, 0xb9bb, 0x0, 0xb86d, 0x0,
    0x2916, 0x0, 0x3829, 0x0, 0x3992, 0x0, 0x3821, 0x0,
    0x2297, 0x0, 0xb7eb, 0x0, 0xb99a, 0x0, 0xb827, 0x0,
    0xa862, 0x0, 0x3707, 0x0, 0x39c0, 0x0, 0x3883, 0x0,
    0x2a3e, 0x0, 0xb823, 0x0, 0xba2e, 0x0, 0xb847, 0x0,
    0xa497, 0x0, 0x3832, 0x0, 0x39d4, 0x0, 0x383f, 0x0,
    0x2526, 0x0, 0xb6da, 0x0, 0xb95e, 0x0, 0xb857, 0x0,
    0xa74f, 0x0, 0x38a7, 0x0, 0x3a1c, 0x0, 0x3821, 0x0,
    0x1fdc, 0x0, 0xb885, 0x0, 0xb942, 0x0, 0xb84e, 0x0,
    0xa865, 0x0, 0x3826, 0x0, 0x3961, 0x0, 0x383c, 0x0,
    0xab8f, 0x0, 0xb835, 0x0, 0xb918, 0x0, 0xb865, 0x0,
    0xa3e5, 0x0, 0x37b8, 0x0, 0x39e9, 0x0, 0x368a, 0x0,
    0xa8e8, 0x0, 0xb72e, 0x0, 0xb972, 0x0, 0xb832, 0x0,
    0x269a, 0x0, 0x375d, 0x0, 0x3a59, 0x0, 0x3799, 0x0,
    0xa70c, 0x0, 0xb89f, 0x0, 0xb929, 0x0, 0xb75b, 0x0,
    0xaaa7, 0x0, 0x3743, 0x0, 0x3972, 0x0, 0x38e9, 0x0,
    0x2a20, 0x0, 0xb629, 0x0, 0xba7b, 0x0, 0xb72b, 0x0,
    0xa522, 0x0, 0x37d8, 0x0, 0x3a56, 0x0, 0x3706, 0x0,
    0x2f6e, 0x0, 0xb822, 0x0, 0xb9e6, 0x0, 0xb800, 0x0,
    0x2d85, 0x0, 0x36f6, 0x0, 0x394c, 0x0, 0x3792, 0x0,
    0x1fe7, 0x0, 0xb777, 0x0, 0xb9aa, 0x0, 0xb6f7, 0x0,
    0xa723, 0x0, 0x382b, 0x0, 0x398a, 0x0, 0x3816, 0x0,
    0x2d2c, 0x0, 0xb84c, 0x0, 0xb97d, 0x0, 0xb8a6, 0x0,
    0xac4c, 0x0, 0x3722, 0x0, 0x3938, 0x0, 0x37ea, 0x0,
    0xa5d4, 0x0, 0xb83a, 0x0, 0xb9f1, 0x0, 0xb887, 0x0,
    0xa9c9, 0x0, 0x3618, 0x0, 0x39d9, 0x0, 0x36c8, 0x0,
    0xab01, 0x0, 0xb8e9, 0x0, 0xb9e5, 0x0, 0xb650, 0x0,
    0xa038, 0x0, 0x3847, 0x0, 0x394d, 0x0, 0x3840, 0x0,
    0xa264, 0x0, 0xb82a, 0x0, 0xb969, 0x0, 0xb70f, 0x0,
    0x152f, 0x0, 0x374b, 0x0, 0x391c, 0x0, 0x375d, 0x0,
    0x2bb6, 0x0, 0xb83b, 0x0, 0xb9be, 0x0, 0xb648, 0x0,
    0xa345, 0x0, 0x381b, 0x0, 0x39b2, 0x0, 0x3813, 0x0,
    0x2bdf, 0x0, 0xb70a, 0x0, 0xb929, 0x0, 0xb6de, 0x0,
    0x1891, 0x0, 0x3704, 0x0, 0x3966, 0x0, 0x37fe, 0x0,
    0x21a5, 0x0, 0xb815, 0x0, 0xb993, 0x0, 0xb68c, 0x0,
    0xb0da, 0x0, 0x3868, 0x0, 0x3941, 0x0, 0x3830, 0x0,
    0xa81b, 0x0, 0xb71d, 0x0, 0xb9c9, 0x0, 0xb76a, 0x0,
    0xaa79, 0x0, 0x3887, 0x0, 0x39fb, 0x0, 0x375a, 0x0,
    0xa51a, 0x0, 0xb83e, 0x0, 0xb9a2, 0x0, 0xb796, 0x0,
    0x9b98, 0x0, 0x365b, 0x0, 0x39a3, 0x0, 0x385a, 0x0,
    0x2d2c, 0x0, 0xb863, 0x0, 0xb9c4, 0x0, 0xb842, 0x0,
    0xa400, 0x0, 0x380b, 0x0, 0x398f, 0x0, 0x3835, 0x0,
    0xa53e, 0x0, 0xb7be, 0x0, 0xb967, 0x0, 0xb5fb, 0x0,
    0xa547, 0x0, 0x3807, 0x0, 0x39d2, 0x0, 0x36ca, 0x0,
    0xaa7d, 0x0, 0xb781, 0x0, 0xb9bc, 0x0, 0xb71e, 0x0,
    0x2370, 0x0, 0x381c, 0x0, 0x3986, 0x0, 0x381f, 0x0,
    0xafa8, 0x0, 0xb7d0, 0x0, 0xb96b, 0x0, 0xb924, 0x0,
    0xac5f, 0x0, 0x375e, 0x0, 0x3a2e, 0x0, 0x37a5, 0x0,
    0x2405, 0x0, 0xb738, 0x0, 0xb9a3, 0x0, 0xb869, 0x0,
    0xab9f, 0x0, 0x37ce, 0x0, 0x39b3, 0x0, 0x372a, 0x0,
    0x2996, 0x0, 0xb843, 0x0, 0xb991, 0x0, 0xb7a0, 0x0,
    0xab38, 0x0, 0x36dc, 0x0, 0x3951, 0x0, 0x3826, 0x0,
    0xab19, 0x0, 0xb777, 0x0, 0xba3f, 0x0, 0xb77a, 0x0,
    0xab6b, 0x0, 0x36e7, 0x0, 0x39b5, 0x0, 0x37b8, 0x0,
    0xacac, 0x0, 0xb7e2, 0x0, 0xb988, 0x0, 0xb7a3, 0x0,
    0xa575, 0x0, 0x38b1, 0x0, 0x394d, 0x0, 0x3827, 0x0,
    0x2850, 0x0, 0xb8d6, 0x0, 0xb905, 0x0, 0xb838, 0x0,
    0xab61, 0x0, 0x35ee, 0x0, 0x38d1, 0x0, 0x3887, 0x0,
    0x292d, 0x0, 0xb70a, 0x0, 0xb943, 0x0, 0xb746, 0x0,
    0x25de, 0x0, 0x37d0, 0x0, 0x39fe, 0x0, 0x366c, 0x0,
    0xac6a, 0x0, 0xb818, 0x0, 0xb96d, 0x0, 0xb69e, 0x0,
    0xa9a3, 0x0, 0x3656, 0x0, 0x3964, 0x0, 0x37e9, 0x0,
    0xae46, 0x0, 0xb532, 0x0, 0xb9c6, 0x0, 0xb845, 0x0,
    0x1e06, 0x0, 0x37b9, 0x0, 0x395c, 0x0, 0x37ec, 0x0,
    0x2aa7, 0x0, 0xb6f0, 0x0, 0xb94f, 0x0, 0xb7d3, 0x0,
    0x25d2, 0x0, 0x3743, 0x0, 0x39b7, 0x0, 0x37be, 0x0,
    0x1b93, 0x0, 0xb849, 0x0, 0xb867, 0x0, 0xb6be, 0x0,
    0xafa8, 0x0, 0x3832, 0x0, 0x3956, 0x0, 0x38e7, 0x0,
    0xa803, 0x0, 0xb818, 0x0, 0xb98f, 0x0, 0xb82c, 0x0,
    0xa778, 0x0, 0x3795, 0x0, 0x395b, 0x0, 0x372f, 0x0,
    0xa836, 0x0, 0xb6e8, 0x0, 0xb9eb, 0x0, 0xb7f2, 0x0,
    0x9ee5, 0x0, 0x3808, 0x0, 0x3a51, 0x0, 0x3874, 0x0,
    0x288e, 0x0, 0xb694, 0x0, 0xb9cd, 0x0, 0xb82f, 0x0,
    0xa1bc, 0x0, 0x381d, 0x0, 0x3a02, 0x0, 0x3804, 0x0,
    0xa624, 0x0, 0xb822, 0x0, 0xb9ca, 0x0, 0xb7ed, 0x0,
    0x2959, 0x0, 0x37c9, 0x0, 0x38f6, 0x0, 0x373a, 0x0,
    0x2359, 0x0, 0xb744, 0x0, 0xb99d, 0x0, 0xb778, 0x0,
    0x126b, 0x0, 0x37f2, 0x0, 0x3ab6, 0x0, 0x387a, 0x0,
    0xa2da, 0x0, 0xb785, 0x0, 0xba84, 0x0, 0xb761, 0x0,
    0xacf9, 0x0, 0x37ed, 0x0, 0x397c, 0x0, 0x3893, 0x0,
    0x2186, 0x0, 0xb820, 0x0, 0xb9f4, 0x0, 0xb7d1, 0x0,
    0x2ef1, 0x0, 0x3786, 0x0, 0x3a33, 0x0, 0x3880, 0x0,
    0xaa6a, 0x0, 0xb749, 0x0, 0xb960, 0x0, 0xb87b, 0x0,
    0xab86, 0x0, 0x37df, 0x0, 0x3a06, 0x0, 0x3860, 0x0,
    0x1c3f, 0x0, 0xb7f9, 0x0, 0xb9b0, 0x0, 0xb6ce, 0x0,
    0x2a4a, 0x0, 0x377e, 0x0, 0x3975, 0x0, 0x389e, 0x0,
    0x2974, 0x0, 0xb700, 0x0, 0xb9d2, 0x0, 0xb70e, 0x0,
    0xa4c5, 0x0, 0x36b4, 0x0, 0x39c2, 0x0, 0x37f0, 0x0,
    0xab92, 0x0, 0xb794, 0x0, 0xb9e5, 0x0, 0xb731, 0x0,
    0x2191, 0x0, 0x37b1, 0x0, 0x39d0, 0x0, 0x381a, 0x0,
    0x1b9f, 0x0, 0xb7e6, 0x0, 0xb9a7, 0x0, 0xb5ed, 0x0,
    0xa8c3, 0x0, 0x380d, 0x0, 0x3a59, 0x0, 0x382d, 0x0,
    0x22c7, 0x0, 0xb884, 0x0, 0xb943, 0x0, 0xb87f, 0x0,
    0xaad9, 0x0, 0x3792, 0x0, 0x39cd, 0x0, 0x3729, 0x0,
    0xa89a, 0x0, 0xb7f5, 0x0, 0xb99c, 0x0, 0xb880, 0x0,
    0xacc8, 0x0, 0x379c, 0x0, 0x393e, 0x0, 0x36a1, 0x0,
    0xa741, 0x0, 0xb84d, 0x0, 0xb8cf, 0x0, 0xb841, 0x0,
    0xa85d, 0x0, 0x36ce, 0x0, 0x38dc, 0x0, 0x381d, 0x0,
    0x264d, 0x0, 0xb6ed, 0x0, 0xb9c4, 0x0, 0xb7b3, 0x0,
    0xa9d1, 0x0, 0x380b, 0x0, 0x38e6, 0x0, 0x3787, 0x0,
    0x2f18, 0x0, 0xb83b, 0x0, 0xba0a, 0x0, 0xb841, 0x0,
    0x26c8, 0x0, 0x37d4, 0x0, 0x38e8, 0x0, 0x36f5, 0x0,
    0xa943, 0x0, 0xb86a, 0x0, 0xb97d, 0x0, 0xb87d, 0x0,
    0x2c03, 0x0, 0x37a8, 0x0, 0x39bf, 0x0, 0x3798, 0x0,
    0xacc6, 0x0, 0xb749, 0x0, 0xb9db, 0x0, 0xb80a, 0x0,
    0xa785, 0x0, 0x37f9, 0x0, 0x39dc, 0x0, 0x37eb, 0x0,
    0xac44, 0x0, 0xb69a, 0x0, 0xb947, 0x0, 0xb6b5, 0x0,
    0x28e3, 0x0, 0x36f7, 0x0, 0x3a5c, 0x0, 0x375a, 0x0,
    0x1c30, 0x0, 0xb7ed, 0x0, 0xb9b8, 0x0, 0xb73d, 0x0,
    0x2af6, 0x0, 0x37f2, 0x0, 0x39c9, 0x0, 0x3812, 0x0,
    0x2818, 0x0, 0xb828, 0x0, 0xb971, 0x0, 0xb6ed, 0x0,
    0x1d4e, 0x0, 0x3883, 0x0, 0x38f8, 0x0, 0x37bb, 0x0,
    0xa95a, 0x0, 0xb787, 0x0, 0xb9ee, 0x0, 0xb824, 0x0,
    0x297b, 0x0, 0x36f5, 0x0, 0x3a9b, 0x0, 0x3718, 0x0,
    0xa9d0, 0x0, 0xb7fb, 0x0, 0xb9a4, 0x0, 0xb6ff, 0x0,
    0x28ad, 0x0, 0x3896, 0x0, 0x39a5, 0x0, 0x3821, 0x0,
    0x2b2a, 0x0, 0xb5ef, 0x0, 0xb8fb, 0x0, 0xb825, 0x0,
    0xadda, 0x0, 0x37c3, 0x0, 0x3a60, 0x0, 0x37fe, 0x0,
    0xa2c8, 0x0, 0xb7de, 0x0, 0xb9e6, 0x0, 0xb877, 0x0,
    0x9a34, 0x0, 0x37bd, 0x0, 0x3981, 0x0, 0x37c8, 0x0,
    0xace1, 0x0, 0xb7f6, 0x0, 0xb95a, 0x0, 0xb926, 0x0,
    0xa0da, 0x0, 0x37dd, 0x0, 0x39fc, 0x0, 0x3828, 0x0,
    0xa244, 0x0, 0xb7c9, 0x0, 0xb94d, 0x0, 0xb857, 0x0,
    0xaa26, 0x0, 0x36ac, 0x0, 0x3989, 0x0, 0x385e, 0x0,
    0x2aa6, 0x0, 0xb77f, 0x0, 0xb96e, 0x0, 0xb810, 0x0,
    0x26e1, 0x0, 0x3746, 0x0, 0x39ef, 0x0, 0x386e, 0x0,
    0x2be5, 0x0, 0xb672, 0x0, 0xb9b3, 0x0, 0xb80d, 0x0,
    0x1d26, 0x0, 0x3743, 0x0, 0x39ee, 0x0, 0x380c, 0x0,
    0x228b, 0x0, 0xb7bf, 0x0, 0xb938, 0x0, 0xb783, 0x0,
    0xa8f0, 0x0, 0x36bd, 0x0, 0x397b, 0x0, 0x380e, 0x0,
    0xa5ae, 0x0, 0xb69c, 0x0, 0xb938, 0x0, 0xb706, 0x0,
    0x91fa, 0x0, 0x3853, 0x0, 0x39c8, 0x0, 0x381d, 0x0,
    0x28dd, 0x0, 0xb6a5, 0x0, 0xb9ca, 0x0, 0xb79a, 0x0,
    0xa2fc, 0x0, 0x3763, 0x0, 0x399a, 0x0, 0x37a5, 0x0,
    0xa0fa, 0x0, 0xb770, 0x0, 0xb9d2, 0x0, 0xb81e, 0x0,
    0xa97b, 0x0, 0x3876, 0x0, 0x39e7, 0x0, 0x3713, 0x0,
    0x2b8b, 0x0, 0xb801, 0x0, 0xb993, 0x0, 0xb82d, 0x0,
    0x267d, 0x0, 0x383b, 0x0, 0x3952, 0x0, 0x37d9, 0x0,
    0xb04c, 0x0, 0xb8ac, 0x0, 0xb95a, 0x0, 0xb8c0, 0x0,
    0xa63a, 0x0, 0x37c4, 0x0, 0x3931, 0x0, 0x3628, 0x0,
    0xa65d, 0x0, 0xb802, 0x0, 0xba08, 0x0, 0xb7a7, 0x0,
    0x2987, 0x0, 0x377c, 0x0, 0x39da, 0x0, 0x38a7, 0x0,
    0xa663, 0x0, 0xb792, 0x0, 0xb94b, 0x0, 0xb778, 0x0,
    0x2806, 0x0, 0x3742, 0x0, 0x39e4, 0x0, 0x3739, 0x0,
    0xa127, 0x0, 0xb7e1, 0x0, 0xb8ec, 0x0, 0xb773, 0x0,
    0xac06, 0x0, 0x378b, 0x0, 0x39a6, 0x0, 0x381b, 0x0,
    0xa710, 0x0, 0xb7ad, 0x0, 0xb973, 0x0, 0xb8b4, 0x0,
    0xa6f4, 0x0, 0x385f, 0x0, 0x3a25, 0x0, 0x36cb, 0x0,
    0x9529, 0x0, 0xb84e, 0x0, 0xb9bf, 0x0, 0xb81c, 0x0,
    0x2ade, 0x0, 0x387d, 0x0, 0x3987, 0x0, 0x3621, 0x0,
    0x277f, 0x0, 0xb772, 0x0, 0xb913, 0x0, 0xb753, 0x0,
    0x2e37, 0x0, 0x3871, 0x0, 0x38e0, 0x0, 0x3804, 0x0,
    0x21a7, 0x0, 0xb812, 0x0, 0xb9e0, 0x0, 0xb787, 0x0,
    0x29fe, 0x0, 0x38c2, 0x0, 0x39bd, 0x0, 0x37b0, 0x0,
    0x1b64, 0x0, 0xb872, 0x0, 0xb9b3, 0x0, 0xb84d, 0x0,
    0xa9a7, 0x0, 0x386a, 0x0, 0x392e, 0x0, 0x385b, 0x0,
    0xab99, 0x0, 0xb7be, 0x0, 0xb95e, 0x0, 0xb7f9, 0x0,
    0x22b6, 0x0, 0x36a4, 0x0, 0x3967, 0x0, 0x381b, 0x0,
    0x2b23, 0x0, 0xb6bf, 0x0, 0xb933, 0x0, 0xb812, 0x0,
    0x19fd, 0x0, 0x375f, 0x0, 0x38db, 0x0, 0x37cf, 0x0,
    0x23fe, 0x0, 0xb82a, 0x0, 0xb930, 0x0, 0xb7fa, 0x0,
    0xad81, 0x0, 0x379f, 0x0, 0x39b8, 0x0, 0x3803, 0x0,
    0x2a50, 0x0, 0xb80d, 0x0, 0xb9fa, 0x0, 0xb808, 0x0,
    0xa132, 0x0, 0x37d5, 0x0, 0x38f9, 0x0, 0x3863, 0x0,
    0xb079, 0x0, 0xb70d, 0x0, 0xb975, 0x0, 0xb85d, 0x0,
    0xaf91, 0x0, 0x374a, 0x0, 0x3936, 0x0, 0x3819, 0x0,
    0x9f82, 0x0, 0xb87f, 0x0, 0xba08, 0x0, 0xb836, 0x0,
    0xabca, 0x0, 0x36fc, 0x0, 0x395f, 0x0, 0x37b3, 0x0,
    0xae02, 0x0, 0xb81c, 0x0, 0xb969, 0x0, 0xb814, 0x0,
    0x238f, 0x0, 0x37c9, 0x0, 0x3951, 0x0, 0x3841, 0x0,
    0xa99a, 0x0, 0xb779, 0x0, 0xba58, 0x0, 0xb71b, 0x0,
    0x1208, 0x0, 0x384c, 0x0, 0x3981, 0x0, 0x37e3, 0x0,
    0xa620, 0x0, 0xb79d, 0x0, 0xb912, 0x0, 0xb81f, 0x0,
    0x2c62, 0x0, 0x3806, 0x0, 0x3985, 0x0, 0x3834, 0x0,
    0x2a9d, 0x0, 0xb870, 0x0, 0xb94d, 0x0, 0xb98e, 0x0,
    0x2451, 0x0, 0x37bf, 0x0, 0x39fd, 0x0, 0x38ba, 0x0,
    0x2ac8, 0x0, 0xb809, 0x0, 0xba57, 0x0, 0xb81e, 0x0,
    0xa950, 0x0, 0x379e, 0x0, 0x3919, 0x0, 0x3794, 0x0,
    0xa1c7, 0x0, 0xb723, 0x0, 0xb9d1, 0x0, 0xb865, 0x0,
    0x2447, 0x0, 0x36db, 0x0, 0x39e6, 0x0, 0x380f, 0x0,
    0xa923, 0x0, 0xb8d5, 0x0, 0xb962, 0x0, 0xb950, 0x0,
    0x2285, 0x0, 0x381e, 0x0, 0x39e5, 0x0, 0x3802, 0x0,
    0xaa45, 0x0, 0xb7a7, 0x0, 0xb9df, 0x0, 0xb6f3, 0x0,
    0xa488, 0x0, 0x36c9, 0x0, 0x39f8, 0x0, 0x3775, 0x0,
    0xa9f0, 0x0, 0xb7f7, 0x0, 0xbab1, 0x0, 0xb72e, 0x0,
    0xa1db, 0x0, 0x385c, 0x0, 0x3963, 0x0, 0x38b9, 0x0,
    0x215d, 0x0, 0xb842, 0x0, 0xba06, 0x0, 0xb749, 0x0,
    0x2c40, 0x0, 0x37a3, 0x0, 0x39d2, 0x0, 0x36f9, 0x0,
    0x1df1, 0x0, 0xb7de, 0x0, 0xb928, 0x0, 0xb775, 0x0,
    0x2a60, 0x0, 0x3833, 0x0, 0x38c7, 0x0, 0x3802, 0x0,
    0xa25d, 0x0, 0xb83c, 0x0, 0xb9ff, 0x0, 0xb7cf, 0x0,
    0xa68b, 0x0, 0x382b, 0x0, 0x3999, 0x0, 0x36bc, 0x0,
    0x2b3d, 0x0, 0xb79e, 0x0, 0xb969, 0x0, 0xb84b, 0x0,
    0xaa2c, 0x0, 0x3803, 0x0, 0x39db, 0x0, 0x378b, 0x0,
    0x1a6e, 0x0, 0xb876, 0x0, 0xb9a3, 0x0, 0xb846, 0x0,
    0xa244, 0x0, 0x37a9, 0x0, 0x39a8, 0x0, 0x379f, 0x0,
    0x1e9d, 0x0, 0xb6de, 0x0, 0xb98b, 0x0, 0xb822, 0x0,
    0xacb9, 0x0, 0x3862, 0x0, 0x397b, 0x0, 0x3709, 0x0,
    0x1a09, 0x0, 0xb648, 0x0, 0xb91c, 0x0, 0xb817, 0x0,
    0x21ca, 0x0, 0x3698, 0x0, 0x39bd, 0x0, 0x3825, 0x0,
    0x2d16, 0x0, 0xb76f, 0x0, 0xb98f, 0x0, 0xb7a3, 0x0,
    0xaf5a, 0x0, 0x371c, 0x0, 0x3a22, 0x0, 0x37cf, 0x0,
    0x2cd7, 0x0, 0xb8e7, 0x0, 0xb983, 0x0, 0xb6ac, 0x0,
    0xa883, 0x0, 0x3836, 0x0, 0x3a08, 0x0, 0x37d8, 0x0,
    0xa718, 0x0, 0xb6e4, 0x0, 0xb996, 0x0, 0xb828, 0x0,
    0x29de, 0x0, 0x382e, 0x0, 0x3981, 0x0, 0x3897, 0x0,
    0x2033, 0x0, 0xb832, 0x0, 0xba91, 0x0, 0xb880, 0x0,
    0xaa49, 0x0, 0x3799, 0x0, 0x38ec, 0x0, 0x37f2, 0x0,
    0xa70e, 0x0, 0xb697, 0x0, 0xb986, 0x0, 0xb67f, 0x0,
    0x189b, 0x0, 0x3817, 0x0, 0x3a6c, 0x0, 0x3682, 0x0,
    0x2c02, 0x0, 0xb81a, 0x0, 0xba6b, 0x0, 0xb887, 0x0,
    0x25a9, 0x0, 0x37d0, 0x0, 0x390a, 0x0, 0x3829, 0x0,
    0x24a0, 0x0, 0xb850, 0x0, 0xba6a, 0x0, 0xb7de, 0x0,
    0x29ac, 0x0, 0x3803, 0x0, 0x38f8, 0x0, 0x3776, 0x0,
    0xa9f9, 0x0, 0xb79e, 0x0, 0xb9b8, 0x0, 0xb74d, 0x0,
    0x95a4, 0x0, 0x3779, 0x0, 0x39be, 0x0, 0x3819, 0x0,
    0x2b81, 0x0, 0xb857, 0x0, 0xb981, 0x0, 0xb819, 0x0,
    0x2c9d, 0x0, 0x3738, 0x0, 0x387a, 0x0, 0x3800, 0x0,
    0x27ef, 0x0, 0xb8b4, 0x0, 0xb961, 0x0, 0xb85d, 0x0,
    0xa475, 0x0, 0x3725, 0x0, 0x3984, 0x0, 0x3840, 0x0,
    0xa91c, 0x0, 0xb822, 0x0, 0xb95c, 0x0, 0xb626, 0x0,
    0x2c07, 0x0, 0x370d, 0x0, 0x3979, 0x0, 0x3709, 0x0,
    0x21b6, 0x0, 0xb76c, 0x0, 0xba06, 0x0, 0xb817, 0x0,
    0x2871, 0x0, 0x377e, 0x0, 0x39b2, 0x0, 0x36ed, 0x0,
    0xa670, 0x0, 0xb664, 0x0, 0xb9c6, 0x0, 0xb7c4, 0x0,
    0x205f, 0x0, 0x3871, 0x0, 0x392d, 0x0, 0x367e, 0x0,
    0x1332, 0x0, 0xb806, 0x0, 0xba10, 0x0, 0xb826, 0x0,
    0x2cf2, 0x0, 0x36df, 0x0, 0x39a7, 0x0, 0x37f0, 0x0,
    0xa924, 0x0, 0xb833, 0x0, 0xb996, 0x0, 0xb8ae, 0x0,
    0x9cce, 0x0, 0x380e, 0x0, 0x39ef, 0x0, 0x387f, 0x0,
    0x26e5, 0x0, 0xb827, 0x0, 0xb969, 0x0, 0xb7a5, 0x0,
    0x2d3c, 0x0, 0x377f, 0x0, 0x39e9, 0x0, 0x3707, 0x0,
    0x2b11, 0x0, 0xb818, 0x0, 0xb8ff, 0x0, 0xb754, 0x0,
    0x254d, 0x0, 0x3779, 0x0, 0x39f0, 0x0, 0x3824, 0x0,
    0x2d90, 0x0, 0xb5a8, 0x0, 0xb9e6, 0x0, 0xb747, 0x0,
    0x250a, 0x0, 0x389a, 0x0, 0x39c8, 0x0, 0x37a9, 0x0,
    0x98d9, 0x0, 0xb893, 0x0, 0xba5c, 0x0, 0xb815, 0x0,
    0xa34f, 0x0, 0x382f, 0x0, 0x392c, 0x0, 0x37bb, 0x0,
    0xa930, 0x0, 0xb816, 0x0, 0xb8d2, 0x0, 0xb6f9, 0x0,
    0xa675, 0x0, 0x3911, 0x0, 0x39b9, 0x0, 0x36ec, 0x0,
    0xaebc, 0x0, 0xb8e7, 0x0, 0xb9bd, 0x0, 0xb6d6, 0x0,
    0xaa59, 0x0, 0x37b7, 0x0, 0x396e, 0x0, 0x3814, 0x0,
    0x2dbc, 0x0, 0xb677, 0x0, 0xb99e, 0x0, 0xb86b, 0x0,
    0x255c, 0x0, 0x3756, 0x0, 0x39bd, 0x0, 0x3687, 0x0,
    0xacf1, 0x0, 0xb836, 0x0, 0xb8f7, 0x0, 0xb87b, 0x0,
    0xa6f7, 0x0, 0x37aa, 0x0, 0x3a0c, 0x0, 0x374a, 0x0,
    0x29b6, 0x0, 0xb7ed, 0x0, 0xba1b, 0x0, 0xb877, 0x0,
    0xa7cb, 0x0, 0x3822, 0x0, 0x3977, 0x0, 0x371f, 0x0,
    0xaad4, 0x0, 0xb82a, 0x0, 0xb9b0, 0x0, 0xb8aa, 0x0,
    0xa9b0, 0x0, 0x3796, 0x0, 0x39a2, 0x0, 0x3773, 0x0,
    0x283d, 0x0, 0xb838, 0x0, 0xb979, 0x0, 0xb7fd, 0x0,
    0xa694, 0x0, 0x37c1, 0x0, 0x394e, 0x0, 0x36e6, 0x0,
    0xa5c1, 0x0, 0xb887, 0x0, 0xb959, 0x0, 0xb853, 0x0,
    0xa37e, 0x0, 0x3843, 0x0, 0x39b8, 0x0, 0x3798, 0x0,
    0x2c01, 0x0, 0xb860, 0x0, 0xb9df, 0x0, 0xb817, 0x0,
    0xac21, 0x0, 0x382d, 0x0, 0x39c2, 0x0, 0x38f7, 0x0,
    0x2a70, 0x0, 0xb810, 0x0, 0xb91e, 0x0, 0xb60e, 0x0,
    0xa441, 0x0, 0x3842, 0x0, 0x3a10, 0x0, 0x38bc, 0x0,
    0xa2ea, 0x0, 0xb5ec, 0x0, 0xba6c, 0x0, 0xb756, 0x0,
    0xa47a, 0x0, 0x3737, 0x0, 0x39ec, 0x0, 0x381d, 0x0,
    0x2ba5, 0x0, 0xb828, 0x0, 0xb96d, 0x0, 0xb7f1, 0x0,
    0xabbc, 0x0, 0x3875, 0x0, 0x3922, 0x0, 0x37b4, 0x0,
    0xa94b, 0x0, 0xb830, 0x0, 0xb9f6, 0x0, 0xb842, 0x0,
    0xa91e, 0x0, 0x3871, 0x0, 0x395c, 0x0, 0x3718, 0x0,
    0xa5de, 0x0, 0xb88b, 0x0, 0xb952, 0x0, 0xb817, 0x0,
    0x25b0, 0x0, 0x381d, 0x0, 0x3914, 0x0, 0x3850, 0x0,
    0x2a08, 0x0, 0xb758, 0x0, 0xb96e, 0x0, 0xb62a, 0x0,
    0xabea, 0x0, 0x3854, 0x0, 0x3981, 0x0, 0x384b, 0x0,
    0x2908, 0x0, 0xb83a, 0x0, 0xb9b7, 0x0, 0xb821, 0x0,
    0x2f7b, 0x0, 0x3789, 0x0, 0x39bb, 0x0, 0x36d1, 0x0,
    0xa8eb, 0x0, 0xb76e, 0x0, 0xba4b, 0x0, 0xb745, 0x0,
    0xac12, 0x0, 0x3836, 0x0, 0x390f, 0x0, 0x3674, 0x0,
    0x2d96, 0x0, 0xb8ab, 0x0, 0xb9fc, 0x0, 0xb824, 0x0,
    0xa739, 0x0, 0x3773, 0x0, 0x38fb, 0x0, 0x3774, 0x0,
    0x2131, 0x0, 0xb8a0, 0x0, 0xb929, 0x0, 0xb6a0, 0x0,
    0xa8b3, 0x0, 0x376c, 0x0, 0x3973, 0x0, 0x3667, 0x0,
    0x2bb7, 0x0, 0xb802, 0x0, 0xb983, 0x0, 0xb804, 0x0,
    0x1d6f, 0x0, 0x3798, 0x0, 0x3999, 0x0, 0x382d, 0x0,
    0xac38, 0x0, 0xb7d7, 0x0, 0xb9ae, 0x0, 0xb80d, 0x0,
    0x184a, 0x0, 0x3865, 0x0, 0x3889, 0x0, 0x3802, 0x0,
    0x2b2c, 0x0, 0xb84f, 0x0, 0xb973, 0x0, 0xb87a, 0x0,
    0xa9b0, 0x0, 0x389b, 0x0, 0x3993, 0x0, 0x3838, 0x0,
    0xac9f, 0x0, 0xb82b, 0x0, 0xb961, 0x0, 0xb80f, 0x0,
    0x2bd5, 0x0, 0x3764, 0x0, 0x3967, 0x0, 0x371d, 0x0,
    0xa1da, 0x0, 0xb82d, 0x0, 0xb973, 0x0, 0xb6f0, 0x0,
    0xa50d, 0x0, 0x3805, 0x0, 0x396d, 0x0, 0x3750, 0x0,
    0xa406, 0x0, 0xb806, 0x0, 0xb98c, 0x0, 0xb80e, 0x0,
    0xaba4, 0x0, 0x3834, 0x0, 0x3a64, 0x0, 0x37f7, 0x0,
    0x2453, 0x0, 0xb812, 0x0, 0xb9c5, 0x0, 0xb7f3, 0x0,
    0xa787, 0x0, 0x3812, 0x0, 0x3a5e, 0x0, 0x36fd, 0x0,
    0xa415, 0x0, 0xb81a, 0x0, 0xb9e3, 0x0, 0xb88f, 0x0,
    0xa9a7, 0x0, 0x381a, 0x0, 0x396d, 0x0, 0x36d8, 0x0,
    0x2589, 0x0, 0xb6f5, 0x0, 0xb94c, 0x0, 0xb803, 0x0,
    0xa16a, 0x0, 0x3892, 0x0, 0x38c9, 0x0, 0x37bc, 0x0,
    0x2693, 0x0, 0xb83c, 0x0, 0xb9a8, 0x0, 0xb897, 0x0,
    0xa861, 0x0, 0x380c, 0x0, 0x38ff, 0x0, 0x37ee, 0x0,
    0xa57a, 0x0, 0xb7c2, 0x0, 0xb95a, 0x0, 0xb6d6, 0x0,
    0xa82b, 0x0, 0x37d4, 0x0, 0x39a0, 0x0, 0x3817, 0x0,
    0xa5cc, 0x0, 0xb810, 0x0, 0xb99e, 0x0, 0xb896, 0x0,
    0x2199, 0x0, 0x3877, 0x0, 0x3953, 0x0, 0x36f5, 0x0,
    0xae65, 0x0, 0xb7fe, 0x0, 0xb9c3, 0x0, 0xb7b3, 0x0,
    0xaaa8, 0x0, 0x3811, 0x0, 0x39cd, 0x0, 0x36cb, 0x0,
    0x2960, 0x0, 0xb862, 0x0, 0xb99a, 0x0, 0xb812, 0x0,
    0x230c, 0x0, 0x37cc, 0x0, 0x39a5, 0x0, 0x3874, 0x0,
    0x2ae4, 0x0, 0xb8d1, 0x0, 0xb992, 0x0, 0xb758, 0x0,
    0x309b, 0x0, 0x37f1, 0x0, 0x39ff, 0x0, 0x38e7, 0x0,
    0x2ac6, 0x0, 0xb6e1, 0x0, 0xba0f, 0x0, 0xb679, 0x0,
    0xad81, 0x0, 0x375f, 0x0, 0x3a08, 0x0, 0x380b, 0x0,
    0x2714, 0x0, 0xb891, 0x0, 0xb913, 0x0, 0xb6e9, 0x0,
    0x26c1, 0x0, 0x370a, 0x0, 0x3989, 0x0, 0x37e1, 0x0,
    0x1c60, 0x0, 0xb839, 0x0, 0xb98b, 0x0, 0xb78f, 0x0,
    0x2a72, 0x0, 0x372c, 0x0, 0x39c4, 0x0, 0x37ec, 0x0,
    0xa583, 0x0, 0xb740, 0x0, 0xba24, 0x0, 0xb659, 0x0,
    0x2512, 0x0, 0x3755, 0x0, 0x39e1, 0x0, 0x37c8, 0x0,
    0x2771, 0x0, 0xb7c7, 0x0, 0xba2d, 0x0, 0xb847, 0x0,
    0xa926, 0x0, 0x37ba, 0x0, 0x395e, 0x0, 0x3912, 0x0,
    0x1bd1, 0x0, 0xb788, 0x0, 0xb994, 0x0, 0xb793, 0x0,
    0x28be, 0x0, 0x3832, 0x0, 0x39c6, 0x0, 0x372e, 0x0,
    0xa677, 0x0, 0xb7a0, 0x0, 0xb951, 0x0, 0xb786, 0x0,
    0x2917, 0x0, 0x3817, 0x0, 0x3959, 0x0, 0x38a8, 0x0,
    0x24a6, 0x0, 0xb7ba, 0x0, 0xb97b, 0x0, 0xb8f6, 0x0,
    0xa803, 0x0, 0x3855, 0x0, 0x3a85, 0x0, 0x37fc, 0x0,
    0x20ee, 0x0, 0xb813, 0x0, 0xb971, 0x0, 0xb7e3, 0x0,
    0x2d05, 0x0, 0x3710, 0x0, 0x39ad, 0x0, 0x36e6, 0x0,
    0x24e3, 0x0, 0xb900, 0x0, 0xb9e4, 0x0, 0xb844, 0x0,
    0x25ac, 0x0, 0x3642, 0x0, 0x3951, 0x0, 0x3816, 0x0,
    0x2663, 0x0, 0xb7de, 0x0, 0xb9d8, 0x0, 0xb6c3, 0x0,
    0xaa52, 0x0, 0x37b9, 0x0, 0x39be, 0x0, 0x3833, 0x0,
    0x1945, 0x0, 0xb732, 0x0, 0xb952, 0x0, 0xb72c, 0x0,
    0x2815, 0x0, 0x383e, 0x0, 0x39d6, 0x0, 0x36f5, 0x0,
    0x2acb, 0x0, 0xb893, 0x0, 0xb99a, 0x0, 0xb885, 0x0,
    0x2885, 0x0, 0x3831, 0x0, 0x3981, 0x0, 0x37ea, 0x0,
    0x2ab0, 0x0, 0xb77f, 0x0, 0xb9dd, 0x0, 0xb883, 0x0,
    0x1f6c, 0x0, 0x380f, 0x0, 0x3943, 0x0, 0x36d5, 0x0,
    0xac24, 0x0, 0xb814, 0x0, 0xba0c, 0x0, 0xb80a, 0x0,
    0x9934, 0x0, 0x384b, 0x0, 0x399f, 0x0, 0x381b, 0x0,
    0x23e5, 0x0, 0xb740, 0x0, 0xb92e, 0x0, 0xb6ba, 0x0,
    0xabef, 0x0, 0x3838, 0x0, 0x3934, 0x0, 0x372c, 0x0,
    0xa4e7, 0x0, 0xb878, 0x0, 0xba52, 0x0, 0xb6ad, 0x0,
    0xa139, 0x0, 0x36c0, 0x0, 0x39af, 0x0, 0x37a4, 0x0,
    0x2731, 0x0, 0xb830, 0x0, 0xb959, 0x0, 0xb7e2, 0x0,
    0xa86b, 0x0, 0x386f, 0x0, 0x395a, 0x0, 0x370e, 0x0,
    0xa555, 0x0, 0xb7ad, 0x0, 0xb90f, 0x0, 0xb8b1, 0x0,
    0xa825, 0x0, 0x378c, 0x0, 0x393d, 0x0, 0x3825, 0x0,
    0xaf5a, 0x0, 0xb7a7, 0x0, 0xb948, 0x0, 0xb70a, 0x0,
    0x183e, 0x0, 0x3732, 0x0, 0x3988, 0x0, 0x3782, 0x0,
    0x26de, 0x0, 0xb753, 0x0, 0xb99d, 0x0, 0xb839, 0x0,
    0x2bdd, 0x0, 0x381f, 0x0, 0x38fb, 0x0, 0x383c, 0x0,
    0xa919, 0x0, 0xb6b6, 0x0, 0xb976, 0x0, 0xb835, 0x0,
    0xa983, 0x0, 0x3819, 0x0, 0x3993, 0x0, 0x3846, 0x0,
    0x2415, 0x0, 0xb87a, 0x0, 0xb97e, 0x0, 0xb81f, 0x0,
    0x2c00, 0x0, 0x37d6, 0x0, 0x39ac, 0x0, 0x367f, 0x0,
    0xab31, 0x0, 0xb7fb, 0x0, 0xb8f4, 0x0, 0xb68f, 0x0,
    0x2ac1, 0x0, 0x384d, 0x0, 0x3a2e, 0x0, 0x3816, 0x0,
    0xa996, 0x0, 0xb7e1, 0x0, 0xb8a5, 0x0, 0xb77d, 0x0,
    0x26d3, 0x0, 0x36ea, 0x0, 0x3a10, 0x0, 0x37ce, 0x0,
    0x1337, 0x0, 0xb6ee, 0x0, 0xba40, 0x0, 0xb83d, 0x0,
    0x1329, 0x0, 0x37b2, 0x0, 0x3965, 0x0, 0x385c, 0x0,
    0x2c06, 0x0, 0xb7e6, 0x0, 0xb99c, 0x0, 0xb83a, 0x0,
    0x237a, 0x0, 0x377d, 0x0, 0x399c, 0x0, 0x3810, 0x0,
    0x26bb, 0x0, 0xb91a, 0x0, 0xb929, 0x0, 0xb780, 0x0,
    0x2bd1, 0x0, 0x37f6, 0x0, 0x3970, 0x0, 0x3865, 0x0,
    0x2c40, 0x0, 0xb81a, 0x0, 0xb992, 0x0, 0xb72e, 0x0,
    0x2a7d, 0x0, 0x37ae, 0x0, 0x390a, 0x0, 0x3813, 0x0,
    0x27f6, 0x0, 0xb79f, 0x0, 0xba02, 0x0, 0xb8a4, 0x0,
    0x2a1e, 0x0, 0x3667, 0x0, 0x3997, 0x0, 0x3865, 0x0,
    0x2b21, 0x0, 0xb855, 0x0, 0xb96a, 0x0, 0xb8ad, 0x0,
    0x28c7, 0x0, 0x370d, 0x0, 0x3969, 0x0, 0x3744, 0x0,
    0x9e72, 0x0, 0xb839, 0x0, 0xb90a, 0x0, 0xb6d1, 0x0,
    0x2826, 0x0, 0x3837, 0x0, 0x39e9, 0x0, 0x36d4, 0x0,
    0xa8b6, 0x0, 0xb891, 0x0, 0xb96b, 0x0, 0xb809, 0x0,
    0x2eab, 0x0, 0x3802, 0x0, 0x3a9c, 0x0, 0x376e, 0x0,
    0xab35, 0x0, 0xb8d0, 0x0, 0xba1d, 0x0, 0xb80b, 0x0,
    0x1d01, 0x0, 0x37a6, 0x0, 0x3a38, 0x0, 0x37ae, 0x0,
    0x9dcf, 0x0, 0xb7d1, 0x0, 0xba1a, 0x0, 0xb835, 0x0,
    0xae24, 0x0, 0x37e3, 0x0, 0x3a0c, 0x0, 0x38f9, 0x0,
    0xab79, 0x0, 0xb85b, 0x0, 0xba1a, 0x0, 0xb821, 0x0,
    0xa6d5, 0x0, 0x3810, 0x0, 0x39a7, 0x0, 0x3833, 0x0,
    0xa846, 0x0, 0xb6dc, 0x0, 0xba69, 0x0, 0xb78a, 0x0,
    0x9b23, 0x0, 0x3808, 0x0, 0x3a29, 0x0, 0x37c1, 0x0,
    0x2bf4, 0x0, 0xb855, 0x0, 0xba36, 0x0, 0xb851, 0x0,
    0x2b73, 0x0, 0x3766, 0x0, 0x3a9a, 0x0, 0x384c, 0x0,
    0x1d26, 0x0, 0xb7d7, 0x0, 0xb976, 0x0, 0xb6d7, 0x0,
    0x2b77, 0x0, 0x3838, 0x0, 0x398e, 0x0, 0x3847, 0x0,
    0x2daf, 0x0, 0xb712, 0x0, 0xb9e9, 0x0, 0xb74d, 0x0,
    0x264c, 0x0, 0x3859, 0x0, 0x39ed, 0x0, 0x37ff, 0x0,
    0xa8af, 0x0, 0xb670, 0x0, 0xb921, 0x0, 0xb85d, 0x0,
    0x2dfa, 0x0, 0x3869, 0x0, 0x39e0, 0x0, 0x379a, 0x0,
    0x299c, 0x0, 0xb87e, 0x0, 0xb951, 0x0, 0xb857, 0x0,
    0x2c9d, 0x0, 0x3878, 0x0, 0x3a28, 0x0, 0x37c4, 0x0,
    0xa97d, 0x0, 0xb892, 0x0, 0xb841, 0x0, 0xb82a, 0x0,
    0xafb3, 0x0, 0x3775, 0x0, 0x3994, 0x0, 0x3794, 0x0,
    0x2d0e, 0x0, 0xb5b4, 0x0, 0xb948, 0x0, 0xb812, 0x0,
    0xa6e8, 0x0, 0x3825, 0x0, 0x3968, 0x0, 0x37bf, 0x0,
    0x2937, 0x0, 0xb8da, 0x0, 0xb9a7, 0x0, 0xb85a, 0x0,
    0x255a, 0x0, 0x3826, 0x0, 0x3a1b, 0x0, 0x37ed, 0x0,
    0x2a38, 0x0, 0xb6a3, 0x0, 0xb9a1, 0x0, 0xb760, 0x0,
    0x20db, 0x0, 0x3828, 0x0, 0x39a3, 0x0, 0x383b, 0x0,
    0xa97b, 0x0, 0xb82c, 0x0, 0xb93c, 0x0, 0xb88b, 0x0,
    0x2996, 0x0, 0x3811, 0x0, 0x3a39, 0x0, 0x381e, 0x0,
    0xad0e, 0x0, 0xb6be, 0x0, 0xbab6, 0x0, 0xb80c, 0x0,
    0xa399, 0x0, 0x3706, 0x0, 0x3996, 0x0, 0x384f, 0x0,
    0x9959, 0x0, 0xb739, 0x0, 0xb8a0, 0x0, 0xb6c1, 0x0,
    0xaabb, 0x0, 0x381f, 0x0, 0x39d2, 0x0, 0x3864, 0x0,
    0x29f0, 0x0, 0xb87e, 0x0, 0xb965, 0x0, 0xb878, 0x0,
    0xac0c, 0x0, 0x3835, 0x0, 0x39b9, 0x0, 0x3722, 0x0,
    0x2231, 0x0, 0xb73e, 0x0, 0xb97c, 0x0, 0xb72a, 0x0,
    0xa6e0, 0x0, 0x3841, 0x0, 0x3a18, 0x0, 0x38e9, 0x0,
    0x2649, 0x0, 0xb81a, 0x0, 0xb9ef, 0x0, 0xb617, 0x0,
    0xa059, 0x0, 0x37f6, 0x0, 0x392a, 0x0, 0x37f8, 0x0,
    0x1cd3, 0x0, 0xb7e3, 0x0, 0xb987, 0x0, 0xb7af, 0x0,
    0xa1b2, 0x0, 0x381b, 0x0, 0x3a1b, 0x0, 0x383f, 0x0,
    0xa9e3, 0x0, 0xb7d7, 0x0, 0xb93d, 0x0, 0xb884, 0x0,
    0x1d7a, 0x0, 0x37ca, 0x0, 0x3993, 0x0, 0x3665, 0x0,
    0x1cba, 0x0, 0xb732, 0x0, 0xb9a9, 0x0, 0xb813, 0x0,
    0xa8cb, 0x0, 0x37de, 0x0, 0x3a01, 0x0, 0x3703, 0x0,
    0xa5e4, 0x0, 0xb854, 0x0, 0xb9b6, 0x0, 0xb6ee, 0x0,
    0x232e, 0x0, 0x3837, 0x0, 0x3998, 0x0, 0x385a, 0x0,
    0xa7d0, 0x0, 0xb787, 0x0, 0xb93d, 0x0, 0xb875, 0x0,
    0x25aa, 0x0, 0x3809, 0x0, 0x3a10, 0x0, 0x3771, 0x0,
    0xaeeb, 0x0, 0xb741, 0x0, 0xba47, 0x0, 0xb7b1, 0x0,
    0xa537, 0x0, 0x37ed, 0x0, 0x3a67, 0x0, 0x37ca, 0x0,
    0xa7ff, 0x0, 0xb843, 0x0, 0xb956, 0x0, 0xb666, 0x0,
    0x229f, 0x0, 0x3796, 0x0, 0x39a2, 0x0, 0x382c, 0x0,
    0xa6a8, 0x0, 0xb795, 0x0, 0xb9c7, 0x0, 0xb888, 0x0,
    0x29f6, 0x0, 0x38cd, 0x0, 0x3982, 0x0, 0x3884, 0x0,
    0xa53e, 0x0, 0xb88f, 0x0, 0xb95a, 0x0, 0xb72c, 0x0,
    0x9ccf, 0x0, 0x377a, 0x0, 0x398a, 0x0, 0x3745, 0x0,
    0x2bb8, 0x0, 0xb757, 0x0, 0xb9c0, 0x0, 0xb6d1, 0x0,
    0x2d64, 0x0, 0x37b7, 0x0, 0x39bd, 0x0, 0x387b, 0x0,
    0xa474, 0x0, 0xb6c0, 0x0, 0xb9ef, 0x0, 0xb78d, 0x0,
    0x9897, 0x0, 0x3857, 0x0, 0x39c7, 0x0, 0x371e, 0x0,
    0x3004, 0x0, 0xb7ae, 0x0, 0xb9b9, 0x0, 0xb7b8, 0x0,
    0x2c37, 0x0, 0x3819, 0x0, 0x39de, 0x0, 0x3660, 0x0,
    0xa67b, 0x0, 0xb82c, 0x0, 0xb96c, 0x0, 0xb7ae, 0x0,
    0x287a, 0x0, 0x3860, 0x0, 0x38d9, 0x0, 0x37fa, 0x0,
    0x2c68, 0x0, 0xb78e, 0x0, 0xb946, 0x0, 0xb7d9, 0x0,
    0xadf1, 0x0, 0x3834, 0x0, 0x387a, 0x0, 0x3826, 0x0,
    0x2b6f, 0x0, 0xb71d, 0x0, 0xb977, 0x0, 0xb6f6, 0x0,
    0x301a, 0x0, 0x3792, 0x0, 0x395d, 0x0, 0x3684, 0x0,
    0xa8e6, 0x0, 0xb808, 0x0, 0xb99e, 0x0, 0xb7fb, 0x0,
    0xab40, 0x0, 0x389a, 0x0, 0x39f9, 0x0, 0x37a2, 0x0,
    0x9b8, 0x0, 0xb7e7, 0x0, 0xb9d2, 0x0, 0xb74e, 0x0,
    0xadce, 0x0, 0x377e, 0x0, 0x39c6, 0x0, 0x3690, 0x0,
    0x2590, 0x0, 0xb730, 0x0, 0xb9ed, 0x0, 0xb6d1, 0x0,
    0xe54, 0x0, 0x383c, 0x0, 0x3947, 0x0, 0x365d, 0x0,
    0x9e3a, 0x0, 0xb6b5, 0x0, 0xb9fd, 0x0, 0xb7d7, 0x0,
    0xa7ae, 0x0, 0x373e, 0x0, 0x3a1f, 0x0, 0x3812, 0x0,
    0xa170, 0x0, 0xb7c2, 0x0, 0xba07, 0x0, 0xb5be, 0x0,
    0x1ef8, 0x0, 0x3815, 0x0, 0x3914, 0x0, 0x37b3, 0x0,
    0xa99b, 0x0, 0xb752, 0x0, 0xb962, 0x0, 0xb848, 0x0,
    0x2ce3, 0x0, 0x375c, 0x0, 0x39e5, 0x0, 0x380b, 0x0,
    0xb04a, 0x0, 0xb67d, 0x0, 0xb9b0, 0x0, 0xb754, 0x0,
    0xa570, 0x0, 0x3854, 0x0, 0x39ab, 0x0, 0x3779, 0x0,
    0x2509, 0x0, 0xb87a, 0x0, 0xb9f1, 0x0, 0xb721, 0x0,
    0x29d5, 0x0, 0x3823, 0x0, 0x3a37, 0x0, 0x37dd, 0x0,
    0xaa7c, 0x0, 0xb648, 0x0, 0xb916, 0x0, 0xb8ac, 0x0,
    0x2cc8, 0x0, 0x3849, 0x0, 0x39bc, 0x0, 0x3817, 0x0,
    0x2c15, 0x0, 0xb6ce, 0x0, 0xb94d, 0x0, 0xb647, 0x0,
    0x24b6, 0x0, 0x37c0, 0x0, 0x398e, 0x0, 0x3775, 0x0,
    0xacd5, 0x0, 0xb659, 0x0, 0xb9ad, 0x0, 0xb848, 0x0,
    0x2bd6, 0x0, 0x386e, 0x0, 0x38c2, 0x0, 0x3756, 0x0,
    0x29a4, 0x0, 0xb6c2, 0x0, 0xb98c, 0x0, 0xb78d, 0x0,
    0x2a26, 0x0, 0x374a, 0x0, 0x3a01, 0x0, 0x378d, 0x0,
    0xa7ee, 0x0, 0xb81e, 0x0, 0xb941, 0x0, 0xb808, 0x0,
    0x2075, 0x0, 0x3885, 0x0, 0x397d, 0x0, 0x384f, 0x0,
    0x2d21, 0x0, 0xb7af, 0x0, 0xb929, 0x0, 0xb88d, 0x0,
    0xa5fb, 0x0, 0x36fc, 0x0, 0x397c, 0x0, 0x3770, 0x0,
    0x233d, 0x0, 0xb76f, 0x0, 0xb99a, 0x0, 0xb8a3, 0x0,
    0x9c8d, 0x0, 0x374c, 0x0, 0x39d5, 0x0, 0x373a, 0x0,
    0x285c, 0x0, 0xb86e, 0x0, 0xb9c7, 0x0, 0xb6f4, 0x0,
    0x1c15, 0x0, 0x383a, 0x0, 0x3952, 0x0, 0x3853, 0x0,
    0x2696, 0x0, 0xb815, 0x0, 0xb96b, 0x0, 0xb819, 0x0,
    0xaa40, 0x0, 0x372e, 0x0, 0x3937, 0x0, 0x3873, 0x0,
    0xa6a2, 0x0, 0xb819, 0x0, 0xb9b4, 0x0, 0xb725, 0x0
    };

static const uint16_t in_cifft_noisy_4096[8192] = {
    0x441e, 0x0, 0x4119, 0xc64c, 0x3f26, 0x4329, 0x3f1f, 0x40d1,
    0xc2c4, 0x42e4, 0xb980, 0x3be4, 0x2e72, 0x4333, 0xbf43, 0x2cf3,
    0x42fc, 0xb51f, 0xbd3d, 0xc1c9, 0xc43f, 0x407f, 0x3b59, 0xbde6,
    0x3fb9, 0x39f4, 0x3890, 0x38cb, 0xbd03, 0x43e6, 0x3ca5, 0x36db,
    0xbf29, 0x4525, 0x35bb, 0xc197, 0x409a, 0x315d, 0xb403, 0x409d,
    0x4266, 0xb2c6, 0xbac9, 0xc083, 0xbfbd, 0xba76, 0xb8c3, 0xc3ed,
    0xbd45, 0x408c, 0x4251, 0xc43c, 0xbc72, 0x44b5, 0xc5b2, 0x456b,
    0x2631, 0x4100, 0x3ce0, 0x424e, 0xb8e1, 0x38f1, 0xbd62, 0xc17b,
    0xc1b8, 0xb297, 0x3de2, 0xc050, 0x3cf8, 0x3f8a, 0xa020, 0x3c68,
    0xc090, 0x3e33, 0x3ae0, 0xc4ab, 0x3f67, 0x42f7, 0x3db9, 0xc3ee,
    0xc5da, 0xc0d3, 0xc25c, 0xc61b, 0x433e, 0xc0fd, 0xa66b, 0xbdf1,
    0xbbd0, 0xc244, 0x32c0, 0x450a, 0xbd76, 0xbb55, 0x43a3, 0xbee9,
    0x4116, 0x3e2b, 0xc31b, 0x3cad, 0x3ddf, 0x2650, 0x39b9, 0x3869,
    0xbe88, 0x330c, 0xb941, 0xc21c, 0xbcd6, 0x3df1, 0xb912, 0xc085,
    0x3ebe, 0x39ed, 0x3d6c, 0x395e, 0x3476, 0xabb7, 0x3ba9, 0xba31,
    0x3d32, 0x2f72, 0x26ef, 0x3c29, 0xbcd9, 0x43e0, 0x3f89, 0xc197,
    0xc26d, 0xc271, 0x429a, 0x4052, 0xb7d9, 0x320d, 0x3c8f, 0xc0d4,
    0xbb8f, 0x4414, 0x408f, 0x4147, 0xbf95, 0xbe45, 0x3c3a, 0x38e1,
    0x419b, 0x4470, 0xc394, 0xb8d8, 0x44b8, 0x3e1e, 0x412f, 0x3a59,
    0x3f11, 0xbdfb, 0x3ad4, 0xbafe, 0x4427, 0xc42f, 0x3a8d, 0x3ddc,
    0x40ca, 0xbd34, 0xbce8, 0x407e, 0xc03f, 0xb0dc, 0x3894, 0xc473,
    0xb877, 0xc1a5, 0x41e7, 0xbe81, 0xc3f1, 0x4011, 0xc351, 0xc549,
    0xc43b, 0xbced, 0x4147, 0x4032, 0x3cb3, 0x3d31, 0x382f, 0x34ec,
    0x3a6c, 0xc11e, 0xb8c3, 0x4364, 0x3f1c, 0x3916, 0xc1cc, 0xb563,
    0xc57d, 0x360a, 0x4004, 0xaabb, 0x3889, 0xb84c, 0x3c74, 0x443d,
    0xbabc, 0x3f4f, 0x3a84, 0xba2b, 0x3c18, 0xc177, 0x3783, 0x31a6,
    0x4128, 0xb8e2, 0x3ac0, 0x3a5a, 0x4018, 0xa2ce, 0xc0eb, 0xc458,
    0x427a, 0xb972, 0x40b8, 0xbacf, 0xbdc6, 0xbb66, 0x3dca, 0x3792,
    0x3ae8, 0xba0a, 0xbf8c, 0xc241, 0x3ecd, 0xaff6, 0xc085, 0x4567,
    0xc10b, 0x3a35, 0x459b, 0xc26d, 0x404a, 0x3303, 0xbb62, 0xb81b,
    0x3ff8, 0x44f0, 0x3ea6, 0x40ee, 0xb2d2, 0xc571, 0xbcfa, 0x282f,
    0xc484, 0x4002, 0x410a, 0xbfef, 0x4001, 0xbed1, 0xb84c, 0xb5d5,
    0x38dc, 0x44bd, 0xbf11, 0xb6c2, 0xc5fb, 0x3e04, 0xbc3b, 0xbf30,
    0xbf9f, 0x3d8f, 0x36c9, 0xb909, 0xc008, 0x434d, 0xb08f, 0xabb7,
    0xbc64, 0x433e, 0x3d6d, 0xb380, 0x3836, 0x392e, 0x34c6, 0xb39e,
    0x3c3b, 0x44ec, 0x3373, 0xbf13, 0x42ce, 0xbd7e, 0x3233, 0xc17f,
    0xc403, 0xc20e, 0x3440, 0x4221, 0xc029, 0x3e97, 0x36f3, 0x434d,
    0xb8e1, 0x39ac, 0xbdc7, 0xc01e, 0xc664, 0xbcaa, 0xc1e5, 0x4191,
    0x3e0c, 0x3a02, 0xbc43, 0xad53, 0x3eb9, 0xbd8e, 0x36af, 0x41a9,
    0xaa53, 0x4208, 0x40c1, 0xba58, 0x4466, 0x42d2, 0x3f43, 0xc174,
    0x40fe, 0xc315, 0xbc32, 0xb783, 0x4108, 0xb004, 0x3d50, 0xb966,
    0xb54b, 0xb7b4, 0xc2ac, 0xc4bc, 0xbf60, 0x4184, 0x3067, 0x2bca,
    0x4304, 0xae1d, 0x4072, 0xb420, 0x458f, 0x3765, 0xbf8d, 0xc028,
    0xbc1c, 0x3bab, 0x3fd8, 0xc7ba, 0xb564, 0x3967, 0x3ca4, 0xc0d0,
    0xc0cc, 0x30ff, 0x3627, 0xc361, 0xc25d, 0xbef5, 0xc18b, 0x4356,
    0xba5c, 0xbe08, 0x40c9, 0x3843, 0x3d6c, 0xbd67, 0xbbe2, 0x4438,
    0x3ee7, 0xc07c, 0x41f3, 0x3ce0, 0x40e8, 0x3d0d, 0xbe37, 0xc25f,
    0x4080, 0x3faa, 0xc211, 0xc0f1, 0xaca3, 0xbdf7, 0xc088, 0xbcbe,
    0x3f73, 0xc330, 0xc0b2, 0xc0bd, 0xbcf8, 0x3de3, 0xbfa4, 0x359b,
    0x41e8, 0xc118, 0x4187, 0x3dc3, 0xc11c, 0x4116, 0x3e8e, 0xc258,
    0x3fba, 0x3d4e, 0x4163, 0x40e2, 0xbc2d, 0xbc68, 0xc1c0, 0x3e66,
    0xc12e, 0x414e, 0xbb98, 0xbf0e, 0x3fa4, 0xb086, 0xbf71, 0xbd82,
    0x4596, 0xc27f, 0xb51b, 0xbfbd, 0xc25f, 0xc24b, 0xbe3e, 0xb806,
    0x3d8a, 0xb42c, 0x4174, 0xbb1e, 0xba82, 0x3a1a, 0x3fc2, 0x405d,
    0xc178, 0xc1a0, 0xc098, 0x440c, 0xc09a, 0x3d45, 0x4271, 0x2c1e,
    0x403e, 0xc440, 0x4034, 0xbd13, 0x34e7, 0x3938, 0xc044, 0xc6af,
    0xbb09, 0x416a, 0x3c5e, 0xbcaa, 0xb9bc, 0xc046, 0xba96, 0x4223,
    0x38ce, 0xb5b7, 0x4478, 0xb8e8, 0x3c24, 0x4240, 0x404b, 0x389a,
    0xc1b2, 0x391f, 0xc188, 0xbf6f, 0x45cf, 0xbc37, 0xb92e, 0xc023,
    0x4007, 0xb216, 0xb600, 0x4112, 0x372b, 0x38f9, 0x3641, 0x42aa,
    0xba29, 0xbe4b, 0xb2aa, 0xc4de, 0x3f9f, 0xc37c, 0xc05a, 0x45b1,
    0x418d, 0x351e, 0x35cb, 0x33ec, 0x40fc, 0x34e2, 0x3787, 0x430c,
    0x3125, 0x3e4e, 0xb5dc, 0xbdc9, 0xb920, 0xbec8, 0xb822, 0x3b75,
    0x3d3b, 0x408c, 0x43ac, 0xbd1b, 0x3ebc, 0xbc42, 0x412e, 0x36d7,
    0xbc72, 0xc090, 0xbe6c, 0xbe5f, 0x3e73, 0xb66b, 0x3f20, 0xba90,
    0xc00f, 0x40f0, 0x34f3, 0xa925, 0xc25e, 0x41a1, 0x35e4, 0xc1be,
    0x3aad, 0x2f85, 0x407c, 0xb5d0, 0xbeb2, 0xb063, 0xc38b, 0xc194,
    0xb9e2, 0xc13e, 0xbd63, 0x3c89, 0xbbd8, 0x3b0b, 0x3a24, 0x3e5e,
    0x40db, 0xbbbd, 0x411f, 0x3efa, 0xbb4d, 0x44c8, 0xc07a, 0xb86c,
    0xb93d, 0x40f0, 0x3d90, 0xc006, 0xbf5f, 0x452d, 0xc04f, 0xb9b1,
    0xc0e8, 0xb4c8, 0x4644, 0xc25a, 0xc401, 0x3e93, 0x3946, 0xbee0,
    0xc440, 0xb808, 0x40ef, 0xb94b, 0x3fe5, 0x2ef7, 0x3cd6, 0x40df,
    0x3abf, 0x3fd4, 0x3b6c, 0xb8d0, 0x3ce4, 0x4465, 0x41a5, 0x3b0c,
    0xc47b, 0x41ac, 0x3ccc, 0xbca4, 0x3812, 0xc0bf, 0x35ed, 0xc1d0,
    0x3b6a, 0x3cbc, 0x40e4, 0xc2a0, 0x3465, 0x3e4d, 0x2ca1, 0xc050,
    0x401b, 0xc01f, 0x4266, 0xbf8f, 0xb9b1, 0xc2ce, 0xba1f, 0x3833,
    0x434d, 0xc2fd, 0xbe3f, 0xbd11, 0xc46a, 0xc542, 0xb933, 0xc47b,
    0x4328, 0x3afc, 0x4465, 0xa8c5, 0x3e0e, 0x3f55, 0x440d, 0xbbb6,
    0x23ab, 0x411e, 0x32ec, 0x3dbb, 0xc085, 0xc29e, 0x3d20, 0x4475,
    0xbc6c, 0x4575, 0x417f, 0x4440, 0xbc94, 0x3bdd, 0x40ba, 0xac3d,
    0xb02f, 0x41cf, 0x39ea, 0xc261, 0x426f, 0xb4c3, 0x419e, 0x335b,
    0xbed5, 0xc20b, 0x4038, 0x3db4, 0x2ed9, 0x38bb, 0x3e06, 0xc25e,
    0xb96f, 0x351a, 0x425a, 0xbe50, 0xbeea, 0xc14f, 0xbdeb, 0xbbc9,
    0xbdad, 0x329e, 0x439e, 0xc10d, 0x3896, 0xc5aa, 0x3bcb, 0x3c30,
    0xa3d5, 0xbcd9, 0x464c, 0x401a, 0x3117, 0xc164, 0x4572, 0x4575,
    0xc189, 0xa49c, 0xbe80, 0xb8c5, 0x3da2, 0xbe6f, 0x42ef, 0x38a7,
    0xc515, 0x3371, 0xbe5e, 0x3fa2, 0x30d4, 0x35fb, 0x424c, 0xc0e8,
    0xc35e, 0xbcde, 0xc3f4, 0x34f3, 0x3e2d, 0x3dcc, 0x3c44, 0x3b5e,
    0xbe82, 0xbb3f, 0x3a0a, 0xc17a, 0xc477, 0xbf88, 0xbe88, 0xaddf,
    0xb5a9, 0x3d09, 0x3ec0, 0x39f8, 0xc4de, 0x38b2, 0x40ef, 0xbb7a,
    0xbe7c, 0xc107, 0x359c, 0x40f9, 0x4214, 0xc287, 0xc138, 0xbdd3,
    0x37c8, 0x425e, 0x342e, 0xbc8c, 0x3ff3, 0xbc03, 0xc2fe, 0xbacd,
    0x3759, 0xb154, 0x3f21, 0x3f0c, 0x386d, 0x4408, 0x2d05, 0xbf82,
    0xb722, 0x9fe0, 0x2cdf, 0x39fc, 0xb382, 0x3d55, 0xbb3f, 0x4174,
    0x40d8, 0x340d, 0x3b22, 0x3d5c, 0xc3c4, 0xc063, 0xc088, 0x41d1,
    0xc6e0, 0x962f, 0xc005, 0x3cec, 0xbe49, 0x4053, 0xadb4, 0x3d2d,
    0x42ca, 0x3ac8, 0xc102, 0xb2e9, 0x441e, 0x40a4, 0xaba7, 0xbf4a,
    0xb7a5, 0x43dd, 0xbbbb, 0x44f5, 0xc459, 0xc271, 0x412b, 0xbe8c,
    0x405e, 0xc563, 0x3f11, 0xc51e, 0xb8d0, 0x416e, 0x3d13, 0xb7fd,
    0xbcf8, 0x42fe, 0x3c52, 0xc016, 0xc0f5, 0x41ae, 0xbff8, 0xb6b0,
    0xbacc, 0xb7a8, 0xbd41, 0xbdb7, 0xc566, 0x3f85, 0x41ed, 0xb166,
    0x30da, 0xc212, 0x3a36, 0x2346, 0xc01f, 0x3cf7, 0x3d28, 0x3c17,
    0x4174, 0x3d01, 0xc1c5, 0xbd3d, 0xb823, 0xc484, 0xc043, 0xbf82,
    0xbd60, 0x3ecb, 0xbc4a, 0xc31c, 0x4283, 0x2a2f, 0xbfc5, 0x3580,
    0xc32c, 0xaf3b, 0x3f06, 0xbb95, 0xb8cf, 0xb9a7, 0x3fc1, 0xc063,
    0xbd5a, 0x3de8, 0x4416, 0xbc96, 0x3b52, 0x3e21, 0x3ea3, 0x38a7,
    0x4214, 0xbc23, 0x42f9, 0x3d72, 0x1f31, 0x3a92, 0x43a7, 0x3e6d,
    0xc0b7, 0xc43e, 0x1f18, 0xc43b, 0xc0e2, 0xc072, 0xbdf2, 0x4502,
    0x3bf4, 0xbe58, 0x2fb4, 0x3c4f, 0x37c3, 0xb9de, 0x3cd8, 0x4117,
    0xb867, 0x3d48, 0xbc4e, 0x3d6f, 0xba24, 0x4173, 0xbc2f, 0x9eb9,
    0xc23d, 0x3c33, 0x4064, 0xb638, 0x382a, 0xc3e7, 0x4155, 0x31b3,
    0xc0f4, 0x4180, 0xb7f0, 0x3873, 0xb893, 0x3b50, 0xbac9, 0x34a8,
    0x3c7b, 0x3849, 0x307b, 0x3ca7, 0xc261, 0xc316, 0xc3dc, 0xc332,
    0x36f5, 0x37ed, 0xb565, 0x3926, 0xb7cd, 0xaf49, 0x4050, 0x410f,
    0xc0c7, 0x4612, 0xb145, 0xb95d, 0xc463, 0xc270, 0x4229, 0x46a7,
    0x3e1b, 0xc2a5, 0xbd4e, 0xc0b1, 0x39b8, 0x3d52, 0x386b, 0x3e52,
    0x378e, 0x3741, 0x35c9, 0x449c, 0xb476, 0xb6a9, 0xc14d, 0xb8e9,
    0xc2f9, 0x3855, 0xc036, 0xbe9a, 0xb29d, 0xbc5a, 0xc162, 0x3626,
    0x420d, 0x410e, 0x3845, 0x42c0, 0x426e, 0x3cd3, 0x3962, 0x351a,
    0x44c6, 0x4427, 0x3745, 0xbb87, 0xbaa4, 0xade5, 0x3d67, 0x4142,
    0xbc8e, 0xa628, 0x3cea, 0x32d3, 0x44ec, 0x4508, 0xc186, 0xb899,
    0x44ca, 0xbc84, 0xbe34, 0x41d9, 0xaaee, 0xc15b, 0x4331, 0x4221,
    0xbd12, 0xc117, 0xc2ed, 0xc23a, 0xbe8f, 0xbe1c, 0x30bb, 0x35df,
    0x34fc, 0xbab3, 0x425d, 0xbacd, 0xc064, 0xc525, 0x3f51, 0x40a8,
    0x4301, 0x3eec, 0xc1e5, 0x3c5f, 0xc39f, 0xc1bc, 0xc16f, 0xc15c,
    0xbde5, 0x3c8b, 0x2f2e, 0x296a, 0x4407, 0xc32e, 0x3a9d, 0x341c,
    0x4317, 0xbeb7, 0xc366, 0x3811, 0x422b, 0x4089, 0xbf69, 0x3ffa,
    0x3f55, 0x3f77, 0xb516, 0x3d29, 0x3a4e, 0xbc95, 0x4154, 0xc15d,
    0xb663, 0xe59a, 0x42df, 0xbfee, 0x40f6, 0x3def, 0xc1ce, 0xbc6f,
    0x40c0, 0x3b59, 0xc04b, 0xbf27, 0xc4ab, 0x42d7, 0xc11c, 0x4293,
    0xc1fa, 0x4250, 0x24a0, 0x433d, 0xbe24, 0x4015, 0x3e64, 0xc3ba,
    0xc491, 0xc0ac, 0xc0ba, 0x4027, 0x3ed3, 0xb6ac, 0x3b10, 0xb95a,
    0x3698, 0xc3e5, 0xc683, 0x3f40, 0xc4b6, 0xbd6b, 0x37be, 0x40a9,
    0xbcfd, 0xb5bb, 0x439a, 0xbebb, 0x3ec6, 0x3c3e, 0xb5f7, 0x4126,
    0x3889, 0xc05e, 0x41be, 0x4598, 0xbe9b, 0x410d, 0xb6f4, 0xbc1e,
    0xbbd5, 0xc156, 0x402c, 0x3a14, 0xc0f6, 0xbf82, 0x3c8b, 0xc2ed,
    0x3921, 0x3bb5, 0xc486, 0xbe17, 0x3eb6, 0xbb0e, 0x437f, 0xc003,
    0xbb28, 0xba71, 0xb886, 0x3e95, 0xbf10, 0xc490, 0x3d49, 0xc197,
    0xb833, 0x3f66, 0xbef1, 0xc2c7, 0x9bf8, 0xc307, 0x3c21, 0xc22f,
    0xbd82, 0xbb03, 0xbee7, 0x41d6, 0x3df7, 0xbeef, 0xb9ce, 0xbbe9,
    0x31a8, 0x409d, 0xb609, 0xb989, 0xb429, 0x3a75, 0x3c8b, 0x3a2e,
    0xc207, 0x3056, 0x3a84, 0xbc48, 0x3103, 0x3327, 0xb44f, 0x37ce,
    0xb8d1, 0x3588, 0x4033, 0x37d9, 0x3db4, 0x3ec7, 0x2c51, 0xc33e,
    0xbc7b, 0x3d59, 0xb9a5, 0x4122, 0x3c24, 0x4483, 0xc363, 0xc12c,
    0x4337, 0x2afb, 0xc396, 0x3506, 0x3d9b, 0xbfe4, 0x3d00, 0x40b2,
    0x41ee, 0x403b, 0x4089, 0xbf65, 0xbfe1, 0x388e, 0x3a2f, 0x440e,
    0xc1c6, 0xc38d, 0xb7ba, 0x21c3, 0x41c9, 0x426d, 0xc03c, 0xc148,
    0xbc3d, 0x4059, 0x3963, 0xb951, 0xbc61, 0xbb62, 0xc134, 0x358e,
    0x3c5d, 0x418e, 0xbcb6, 0xbab2, 0xbc2b, 0x460d, 0x447f, 0x41c6,
    0xbe61, 0x4237, 0x3878, 0x38ff, 0x37d2, 0x3fce, 0x23d1, 0xbb9e,
    0xbc0d, 0x3fb3, 0x31c2, 0xb8db, 0xbd9e, 0xc006, 0x3e00, 0xba50,
    0x3dca, 0x37cb, 0xc4fa, 0x3b31, 0x36a3, 0x3c0f, 0x40d2, 0x40da,
    0x4209, 0x3dd4, 0x44f3, 0x3b2a, 0xafaa, 0xba1f, 0x4420, 0xc55c,
    0xc22e, 0xbd66, 0x40d8, 0x40a0, 0xc2d7, 0xb90f, 0xc36f, 0x40c5,
    0x376c, 0x343a, 0xb7bd, 0xc100, 0xb312, 0x3826, 0x446d, 0xbfcf,
    0x3356, 0x3905, 0xc121, 0xc0d3, 0x299e, 0x433f, 0xc408, 0x455f,
    0xc272, 0x3ed9, 0xbe56, 0x4497, 0x3620, 0x3f72, 0xbe4f, 0xbe4e,
    0x42fe, 0xc206, 0x41aa, 0xbc0c, 0x3f90, 0x41ae, 0xb088, 0x449c,
    0xc027, 0xba58, 0x4451, 0xc0fc, 0x400e, 0x3643, 0xb91b, 0x3cd4,
    0x3c83, 0xc087, 0x3c31, 0x41db, 0x457a, 0x3d9e, 0xbe0a, 0xba46,
    0x442e, 0x37d3, 0x3efb, 0xbd0a, 0xb63c, 0xbe73, 0x3589, 0x3b40,
    0xb676, 0xc4e1, 0xb99d, 0x394b, 0xbf25, 0xb125, 0x41b3, 0x3b1f,
    0xbf2b, 0x4034, 0xc381, 0x2d1c, 0xbee5, 0x3446, 0xb4da, 0x386f,
    0xb718, 0xbf0d, 0x3708, 0xc0dc, 0xb5f5, 0xc00b, 0x3c95, 0x3a04,
    0x41e4, 0xc132, 0xc069, 0xb40d, 0xc04a, 0x2f4f, 0xc3d7, 0xbc20,
    0x406f, 0xbd59, 0xc471, 0xb26c, 0x3c57, 0xba06, 0x42cd, 0x364f,
    0xc4a6, 0x4344, 0x3eb0, 0xb030, 0x4083, 0xbe4c, 0x40a0, 0x3f1e,
    0x39cb, 0xb828, 0x354c, 0x4555, 0x3b6a, 0xbb1c, 0xc2f2, 0x3816,
    0x40b4, 0x37c8, 0xb0d5, 0xb9ee, 0xbb02, 0x40df, 0x32ba, 0xc294,
    0x3ec1, 0xc433, 0xbe4c, 0x3660, 0xb95d, 0xc2db, 0xc138, 0x923f,
    0x42db, 0xb012, 0x41b2, 0x417e, 0x4120, 0xb461, 0xbe16, 0x3dd8,
    0xc2ae, 0x3a73, 0x4131, 0x3cef, 0x386d, 0x3d79, 0x3ca1, 0xc461,
    0x43c5, 0xae38, 0x38b0, 0xb819, 0xc0a5, 0xc20f, 0xc2fa, 0x3fa9,
    0x3eaa, 0xa57e, 0x3b3b, 0x3c9a, 0x427e, 0xbc23, 0xc22b, 0x4124,
    0xbe1a, 0x330b, 0xb03e, 0x383f, 0xc004, 0xbda3, 0xbcf9, 0xc5a2,
    0x3e58, 0xc4a1, 0x3acf, 0xc120, 0xbfb8, 0x416c, 0xbbfc, 0xc006,
    0x3d30, 0x3d69, 0x41d7, 0x40c6, 0x406f, 0xbc67, 0x4116, 0xb5c9,
    0xaf89, 0xb103, 0x3c8c, 0xc10b, 0xbd15, 0x402d, 0x4395, 0xc031,
    0x38a3, 0x4040, 0xbc1a, 0xabef, 0x4150, 0xbb04, 0x3d12, 0xba93,
    0xbd6f, 0x33b6, 0x3e4d, 0x415d, 0xac78, 0xc152, 0x4144, 0x39d5,
    0x3b42, 0x3df9, 0x3c15, 0xbc7d, 0x4649, 0x3d45, 0xc187, 0x4481,
    0xc1c3, 0x34ba, 0x43ab, 0x3090, 0x3c22, 0xbbc2, 0x3ea7, 0x388b,
    0x3c39, 0xbfab, 0x3566, 0xbdcd, 0x3e08, 0xb919, 0xb84a, 0xc189,
    0x3ae9, 0x41b8, 0xbcbd, 0x3c99, 0x44a7, 0xc4e5, 0xc46d, 0x341a,
    0xb815, 0x4045, 0xb316, 0xc0b3, 0xc22a, 0xc148, 0x448f, 0xbccf,
    0x3c99, 0xb427, 0x4252, 0xc336, 0x469a, 0x4004, 0x3ece, 0xb54f,
    0xc164, 0xbe6d, 0x4184, 0xc0ec, 0x40c5, 0x4180, 0x3e4d, 0x359e,
    0xc363, 0x352e, 0xc40d, 0x3560, 0xbe9b, 0xbcdd, 0x3ee0, 0xc0f0,
    0x3b9a, 0xbd50, 0x3127, 0x407b, 0xae58, 0xac1a, 0xc5a5, 0xc085,
    0x3a2a, 0x38c5, 0x3c98, 0xb6ea, 0xc42a, 0xc240, 0xba8c, 0xbc9d,
    0xb1f3, 0x3eb0, 0x4369, 0xc0e3, 0xbe05, 0x3de2, 0x3c8e, 0xa902,
    0xbd79, 0xba48, 0x418d, 0x384d, 0xc11a, 0x4633, 0x3d1b, 0x3129,
    0xb5b8, 0x34f6, 0x33e4, 0xb964, 0xb370, 0x3e62, 0xc270, 0xc221,
    0xba85, 0x3d12, 0xbb26, 0xbf25, 0x3dc7, 0x3ccc, 0x38b1, 0xab0f,
    0x3e33, 0x3833, 0x428e, 0xbd0c, 0x4053, 0xbef9, 0xbc1a, 0x309a,
    0xc18c, 0x4152, 0xba96, 0xc2b6, 0xb409, 0x26b1, 0xc00a, 0x41b7,
    0xc0df, 0x3faf, 0x41f1, 0xb839, 0x3f5c, 0xc23f, 0x3092, 0x3d5a,
    0x41c3, 0x3d7a, 0x3c2d, 0x3ef6, 0x3d7c, 0xbaf8, 0x4446, 0x4243,
    0x2e4a, 0x31da, 0x44a6, 0x3a2d, 0x4003, 0x3e06, 0x34cf, 0xbdd5,
    0xc107, 0x3ae4, 0xc1b5, 0xbd0d, 0xb5f3, 0xb65c, 0xbca6, 0xb40e,
    0xbe22, 0xc048, 0x3d32, 0x38b5, 0x3a2f, 0xbba9, 0xbe8e, 0xc0f7,
    0xb4b1, 0xbe56, 0x3c58, 0x3da4, 0x3d62, 0x3a14, 0xc2a9, 0xc46f,
    0x42a7, 0xb158, 0x3520, 0xc00c, 0xc31c, 0xb5e2, 0xc064, 0x44a1,
    0xbf65, 0xbbb7, 0xbca1, 0x379b, 0x383d, 0xb8ea, 0xc1b5, 0x4703,
    0x3cc9, 0xc1aa, 0x408a, 0xb8b8, 0x4328, 0xc41f, 0xbf58, 0xbd38,
    0xb9a4, 0x4054, 0x40f5, 0xbaf8, 0x4514, 0xb0e6, 0xbeac, 0xb2d7,
    0x37f7, 0xb9a2, 0x4488, 0x38cc, 0x45fe, 0x41e8, 0xbe1f, 0x4091,
    0xbe84, 0x4586, 0xc412, 0xbb55, 0x3e85, 0x3c2e, 0xbd85, 0x3abd,
    0x3bb3, 0x398e, 0xb7d9, 0xbda4, 0x367d, 0x442e, 0x400c, 0x4326,
    0xc16c, 0xbe6f, 0xb7e6, 0x4494, 0xbd87, 0xb977, 0xc4ff, 0xc035,
    0x426e, 0xbf8e, 0xc448, 0xbd9f, 0xc263, 0xbd0c, 0xbf10, 0x4472,
    0xb9db, 0xbda8, 0x3df9, 0x43b0, 0xbc81, 0x3dec, 0xbb4d, 0xc0fe,
    0x360b, 0xb0e2, 0xb47e, 0xb9d0, 0x4336, 0xbcc5, 0xc104, 0x3f47,
    0x4068, 0xc2c5, 0xbfb0, 0x4110, 0xbd90, 0xbfa3, 0x3fb6, 0x2c06,
    0xc16f, 0xc443, 0x3c88, 0x4224, 0x4152, 0x33f2, 0x3f9f, 0xb927,
    0xbdd6, 0xc29c, 0x4048, 0x3b5d, 0x40a4, 0xbd79, 0x40e5, 0xbf17,
    0xc3a5, 0x3c70, 0x44db, 0xc418, 0x34c9, 0xb2d7, 0x3d0a, 0x41a1,
    0x4399, 0xb7e9, 0xc38f, 0xc17e, 0xc41e, 0x42c5, 0xc45d, 0xc01c,
    0xc019, 0x3ffc, 0x3955, 0xba5e, 0x37d3, 0x3dbe, 0x2cf0, 0x349e,
    0xbcbf, 0xbd67, 0xbfc1, 0xbe7c, 0xb8e6, 0xbd54, 0x41fe, 0xbf33,
    0xbdc2, 0xbf9b, 0x3167, 0x44da, 0x3c6d, 0xb8c1, 0x36c8, 0xb8ac,
    0xb406, 0xc3b9, 0xc0e1, 0xb803, 0xc245, 0x3ea0, 0x4296, 0x46c8,
    0x41bf, 0x40ca, 0x35ad, 0x3d38, 0xb4db, 0x4271, 0xb463, 0x3979,
    0x2fbe, 0xbb6f, 0xb521, 0xb129, 0xba77, 0xbb55, 0x41fb, 0xbda5,
    0x40af, 0x4021, 0x3d0b, 0xb35c, 0xb4ad, 0x37f0, 0xc0dd, 0x3d81,
    0x4102, 0x3a78, 0x3de6, 0xb631, 0xbd68, 0x378e, 0x4066, 0xc096,
    0xb297, 0x38ad, 0xbe40, 0x391b, 0x307d, 0x3c08, 0x3d30, 0xb4c4,
    0xc146, 0xbe98, 0x3e64, 0xc195, 0x4317, 0xbca0, 0x4021, 0x42bd,
    0xbbbc, 0xc1c2, 0xbc49, 0x4097, 0x442b, 0xb8e6, 0xbc69, 0x3bab,
    0xc0ce, 0x3ca5, 0xb709, 0xbf4e, 0x3c68, 0xb781, 0xc019, 0xbd39,
    0x371f, 0x4090, 0x3a84, 0x3eed, 0xbb45, 0xae5d, 0x4168, 0x38d7,
    0xc164, 0xbcad, 0xbb2c, 0xc02b, 0xbda8, 0x416c, 0xbfac, 0xb418,
    0xb41c, 0x425f, 0xb876, 0x31da, 0x3d82, 0xb444, 0x345a, 0xc106,
    0xbabd, 0x3e28, 0x38d1, 0x3292, 0x44bd, 0x3c93, 0x40e8, 0x3ec7,
    0x396b, 0xb84d, 0x38c5, 0x3e65, 0xc055, 0xc3d4, 0x4424, 0xbbf6,
    0xb1ef, 0xbb47, 0xbd36, 0xbd0a, 0xbbe0, 0xb8ea, 0x3c98, 0xb83f,
    0xc00b, 0x3c72, 0x3ff0, 0xacfa, 0x388a, 0x400f, 0x2e7c, 0xbd3d,
    0x445c, 0x3fb5, 0xbdb1, 0x3aaf, 0x3c55, 0xbd11, 0xbe40, 0xb9c9,
    0xbfb2, 0xc200, 0x3b50, 0x4194, 0xc34e, 0xbbd8, 0x3ad6, 0xb6cf,
    0x40fc, 0x3146, 0x3a11, 0xabbd, 0xbb0d, 0xc633, 0xb8eb, 0x3476,
    0x3faf, 0x42d3, 0x9c05, 0x3c3b, 0xb821, 0x44ff, 0x41ba, 0x44c2,
    0xb2a9, 0x3e4d, 0xc217, 0xbe0a, 0xb463, 0xc2f6, 0x41ab, 0xc3d2,
    0x3cf6, 0x3d0f, 0xc1cd, 0xbe41, 0x4064, 0x4071, 0x3071, 0x3eb4,
    0xc0c4, 0xbc5b, 0x3bc5, 0xc12e, 0xbd4e, 0x37fc, 0x3df6, 0x3f1b,
    0x3535, 0xc2ac, 0x3a37, 0xb91c, 0xbd41, 0x4137, 0x416f, 0x3a34,
    0x3d7f, 0x434c, 0x4227, 0x430d, 0xba55, 0x41fb, 0xc2b0, 0x3570,
    0xc287, 0x3a36, 0xb9dd, 0xaffe, 0xc0ac, 0x3e80, 0xbfae, 0x3c2d,
    0xb565, 0x3dd0, 0x3c13, 0x41da, 0x3a98, 0x3dd8, 0xb0a9, 0xbcc6,
    0x3e79, 0x3b9c, 0x3d84, 0xba39, 0xbbe4, 0xc000, 0xbfdc, 0x4306,
    0x43cc, 0xb61f, 0x3e53, 0x3ad7, 0xb774, 0x3654, 0x4626, 0xb8e6,
    0xb937, 0xb7b6, 0xc031, 0x2561, 0xc17d, 0xc017, 0x4623, 0xbc24,
    0x3d31, 0x4478, 0x455d, 0x4572, 0xbbec, 0x3f5a, 0xc251, 0xc4e3,
    0xc1bb, 0x4113, 0xb7dd, 0x3a3e, 0x39b0, 0xb38c, 0xbc32, 0xc18b,
    0xbd7d, 0xbe59, 0xbc31, 0xbce0, 0xbc19, 0x3a79, 0xbfdc, 0xc18c,
    0x4407, 0xa68c, 0xbf04, 0x311a, 0x2eff, 0xb65c, 0xc03c, 0xb904,
    0x3f68, 0xbf65, 0xc00e, 0xb8ef, 0xbf49, 0xb6b2, 0xb15a, 0xb79c,
    0xbd73, 0x3951, 0x3c34, 0x3538, 0x3c9f, 0x414a, 0xbe25, 0xc45a,
    0x455e, 0xc2a9, 0xbd20, 0x2ed3, 0x3e77, 0xc078, 0x4094, 0x3dbb,
    0x2eb5, 0x4175, 0x41e6, 0x4001, 0x37b4, 0xba40, 0x3d8e, 0x3d73,
    0xb8d9, 0x391b, 0x32a8, 0x3d9f, 0xb65b, 0x3e09, 0x35bb, 0xc4cf,
    0x2a76, 0xb339, 0xbff5, 0x3504, 0xb6ef, 0x38f9, 0x37da, 0x4298,
    0x4288, 0x41ec, 0xbae7, 0x410b, 0xb65e, 0xc09b, 0x446a, 0xbc6d,
    0x4095, 0xc06a, 0x41b0, 0x3b0a, 0x37c3, 0xba0f, 0xb965, 0xb6d9,
    0x3e30, 0x34b6, 0x3ff0, 0x4330, 0x4083, 0x2425, 0xc04b, 0x3c85,
    0x388b, 0x3ff6, 0xc554, 0xc189, 0xc061, 0xb79a, 0x384a, 0x40e0,
    0x458a, 0x3d83, 0xc334, 0x4465, 0x4231, 0xbf78, 0x2303, 0xb73f,
    0xc2f9, 0xbcfb, 0x4177, 0xc350, 0xba1b, 0x387e, 0xc1e6, 0x3db9,
    0x3e27, 0xc07e, 0xc3bb, 0xc0ee, 0xb89d, 0x340a, 0xbe90, 0x3aba,
    0xc4c1, 0x40d2, 0xc419, 0x38d5, 0xbf1c, 0x3ef1, 0xbc9f, 0xa262,
    0x4040, 0x44e9, 0xb6e8, 0xc0df, 0x34a6, 0xbb9a, 0x4407, 0x41bc,
    0xbea6, 0x3cda, 0xc0b6, 0xbb91, 0xb81e, 0x3552, 0x3ac1, 0x41d6,
    0x3943, 0xc0e9, 0xc0c5, 0xb686, 0xc4d1, 0xb25d, 0xb33f, 0xb606,
    0x3ec5, 0x4499, 0x40ce, 0xc01d, 0xbb54, 0x3e09, 0x4329, 0x352e,
    0xaad1, 0x41d9, 0x3acc, 0xc325, 0xbdf0, 0xc161, 0xc074, 0x3806,
    0xbde5, 0x2f6f, 0x4196, 0xbdf5, 0x4238, 0x3de8, 0xbc30, 0x3bca,
    0x3a19, 0xb5a8, 0xc63e, 0xbd48, 0x3a72, 0x4186, 0x41dc, 0xac31,
    0xb4e6, 0x44d2, 0xc196, 0x3ad4, 0x448a, 0x43d9, 0xbc37, 0x45e3,
    0xb3d3, 0xafd7, 0x41e5, 0x3efa, 0xb8d8, 0x38b0, 0x3ced, 0x35a4,
    0x3e57, 0x415e, 0x4478, 0xbf7f, 0x430c, 0x3dd5, 0xbf0b, 0xb1d9,
    0xba65, 0x4158, 0xba4e, 0x356f, 0xc0f0, 0xc5bd, 0x3980, 0x2be4,
    0x3e2e, 0x411a, 0xbc24, 0xad44, 0xbc5d, 0x3d62, 0xc2a8, 0xbebb,
    0xba27, 0x34c5, 0x42bc, 0xc356, 0x41ff, 0x3771, 0x3cfd, 0xc43f,
    0xb835, 0x40fa, 0xbc09, 0xc1d8, 0x3f70, 0xb873, 0x450e, 0xc3ac,
    0x3e53, 0x3637, 0xc51d, 0xb584, 0xbf22, 0x36fb, 0x342f, 0xc131,
    0xc4a5, 0xbd2f, 0xbf1b, 0x3c6c, 0xc2fb, 0x392a, 0xb304, 0x4337,
    0x3ce5, 0x38e0, 0xbd94, 0xbbc6, 0xc35a, 0x2b0c, 0xc1e5, 0xbb46,
    0x4443, 0x3ea0, 0xc178, 0xba25, 0xc19c, 0x3991, 0x40e8, 0x4236,
    0xbed6, 0xaf69, 0xb5a2, 0xab83, 0xc277, 0xbf8a, 0xbc5e, 0x431a,
    0xbc5e, 0x3b36, 0x385a, 0xbecb, 0xb0d5, 0xb2a8, 0xbce8, 0x4095,
    0x4171, 0x38a6, 0xbe64, 0x3cb2, 0xbc17, 0xc184, 0x36f1, 0xbe46,
    0x3939, 0xbf60, 0x440f, 0xbfac, 0xbfee, 0xb39c, 0x3ab5, 0xb76a,
    0x401b, 0xbe7d, 0x3e2d, 0xba99, 0xbc81, 0x443b, 0xb9fe, 0x42c8,
    0xbbc1, 0x369b, 0x3a38, 0x412d, 0xc0ca, 0xb113, 0x4003, 0xc340,
    0x3e62, 0xc145, 0x345a, 0xc045, 0x3588, 0x4007, 0x4292, 0xa254,
    0x433a, 0xbab6, 0xb908, 0x4187, 0x3cf9, 0xb85f, 0x3373, 0xbe78,
    0x2f72, 0x3a55, 0x3ed9, 0x398d, 0xc286, 0x3a60, 0xb4de, 0x37c8,
    0xbaeb, 0x375a, 0xc277, 0xc063, 0x3b93, 0xbe11, 0x3af1, 0xb579,
    0x42b3, 0xbd67, 0x34a5, 0x2c1f, 0x3cca, 0xc285, 0x4153, 0xb8bf,
    0xbc9d, 0x3666, 0xb7e1, 0x40c7, 0xb61c, 0xbea8, 0x4131, 0xbecb,
    0xb9b9, 0x40fe, 0xbbac, 0x40b0, 0x3abe, 0xb9b9, 0x4059, 0xc1ff,
    0x40d2, 0x3b08, 0xbc4c, 0xb8b5, 0x3eb4, 0xb02c, 0xc183, 0xc0aa,
    0xb898, 0x4435, 0x3f22, 0xc049, 0x3246, 0xb9e5, 0xbe88, 0xc056,
    0xba52, 0x379c, 0xbbf6, 0xb8b0, 0x4101, 0xbc1c, 0xb7b6, 0x3dd1,
    0x3b73, 0xb9bd, 0xb4c4, 0xc13b, 0xbb97, 0x3193, 0x3a3d, 0x432e,
    0x40c4, 0xbe70, 0xbe8a, 0xbc6d, 0xb6c3, 0x3e31, 0xba2d, 0x41ab,
    0xc418, 0x3a8f, 0x438b, 0xaf30, 0xbd6f, 0xac0d, 0xbaaf, 0xb8c0,
    0xad6b, 0xb8df, 0xc321, 0xb503, 0x4460, 0xbe4f, 0xc2ed, 0x415f,
    0x3bd4, 0xb7f2, 0x36ab, 0xb8c6, 0xbde2, 0xbda2, 0xc57f, 0x347e,
    0x3cab, 0xb849, 0xbdf3, 0xc3b0, 0x3f99, 0x3fc0, 0xbe5a, 0x3a9f,
    0x382e, 0x32fa, 0xb832, 0xb9a4, 0xbabc, 0xc0a5, 0xb494, 0x39f4,
    0xb7e7, 0x31ab, 0xc194, 0xc457, 0x3b3a, 0x3d1d, 0xbbda, 0x3e6c,
    0x2fc7, 0xc050, 0xc031, 0xc4b5, 0xb714, 0xc206, 0x3ec3, 0xc32c,
    0xbdb4, 0x351f, 0xafdc, 0x428b, 0x42da, 0x33a1, 0x3936, 0x3eec,
    0xb9ab, 0x3fe5, 0xbcf7, 0xbc85, 0xc023, 0x3bca, 0xbec2, 0x317f,
    0x3701, 0xb4f6, 0x4064, 0x34d4, 0x3f0a, 0x3070, 0x36b9, 0xb404,
    0x4499, 0x3918, 0x4021, 0x34a2, 0x4153, 0x3cd9, 0x436a, 0xb8a2,
    0x318e, 0x3888, 0x4027, 0xc2ff, 0xb607, 0xc122, 0xc397, 0x3dba,
    0x2cd6, 0xbcc6, 0xc1a1, 0x3684, 0x39a7, 0x37d1, 0x3e42, 0x3e14,
    0x4442, 0x44c5, 0x4477, 0x41fb, 0xb5f3, 0xbfdc, 0x3c82, 0x3eac,
    0xad47, 0x4347, 0xc0c3, 0x40c7, 0xbffc, 0xbcbd, 0x33a2, 0x3826,
    0xc280, 0x3ada, 0x3daa, 0x4246, 0xc40d, 0xb8e7, 0xbce6, 0x3852,
    0xbb96, 0x429b, 0xb8ba, 0xbd04, 0x3bba, 0xbbf2, 0xb485, 0x40d0,
    0xbe29, 0x405b, 0xc446, 0x3da3, 0xbc91, 0x40fa, 0xc32a, 0x285a,
    0xc1d4, 0x32a2, 0x40be, 0x3fe7, 0xbe30, 0x45b2, 0xb8eb, 0x3ce5,
    0x4240, 0x309e, 0x3938, 0xc1d0, 0xbfca, 0xbf7d, 0xb955, 0xbce6,
    0x3360, 0xc2d5, 0xc682, 0xbfbf, 0xc075, 0xbeae, 0x3df4, 0x3d67,
    0xc106, 0x3b45, 0xbc34, 0xc429, 0xbd54, 0xbed0, 0xb961, 0xc268,
    0x3ac8, 0x3bee, 0x3dc4, 0xc3bf, 0xc135, 0x42b7, 0x448f, 0xc47e,
    0x3541, 0x3c38, 0x3d61, 0x41ad, 0xc040, 0x3ec4, 0x40f7, 0x43b5,
    0x34bb, 0xc0dd, 0xc088, 0xb54d, 0x3c31, 0x410f, 0xbca5, 0x4245,
    0x42e6, 0x3a8e, 0xaccc, 0xc015, 0xb047, 0xc199, 0xc3fa, 0xba4d,
    0xb098, 0x3825, 0xb566, 0x3d11, 0x43ac, 0x3c97, 0x3f7e, 0xc076,
    0x432d, 0xb2db, 0x38fb, 0x3526, 0xbcd4, 0x4120, 0xbe96, 0xbdce,
    0x4360, 0xaf27, 0x3bd8, 0x4381, 0x3d87, 0x39f4, 0x2f79, 0x3897,
    0x4180, 0xb867, 0xbf4b, 0xc219, 0x41d4, 0x3d69, 0x419c, 0x3e4d,
    0xac51, 0x4446, 0x3662, 0x21c1, 0x372e, 0xb6f9, 0xbea2, 0x4178,
    0xc2f7, 0x3f78, 0xc149, 0xc442, 0x4075, 0x445a, 0xc14c, 0xbda9,
    0xc22a, 0xc0d2, 0xb8dd, 0xc1b4, 0x431b, 0xc0e2, 0xc0c2, 0xc559,
    0x3984, 0x3cd3, 0xb996, 0xc2a5, 0xb992, 0xba2a, 0xb04a, 0x3623,
    0xac03, 0xbc61, 0xb67b, 0xc110, 0x3a0d, 0x35df, 0x3c4d, 0xb523,
    0x44c5, 0xc114, 0xc3ea, 0xc31d, 0xc2bf, 0x445e, 0xb978, 0x415e,
    0xc52a, 0x3d14, 0x3b0b, 0x4212, 0xb718, 0x40b9, 0xc089, 0x4029,
    0xbc48, 0xbdd1, 0x4307, 0x3df7, 0x40d9, 0x4263, 0xbe99, 0x35e6,
    0x3e55, 0x3fe0, 0x38ed, 0xc078, 0x41c8, 0xb21d, 0xbae8, 0x35f3,
    0x4040, 0x2eef, 0x3edb, 0x3c65, 0x3f60, 0x3c8b, 0xbc0c, 0xc02b,
    0x3b16, 0xc114, 0x38ee, 0xc079, 0xc59e, 0x3d52, 0xb79f, 0x3a4b,
    0xb8fc, 0x3da1, 0x41ef, 0xbfe6, 0xbf3b, 0x410d, 0xc4fd, 0x3829,
    0x3e6e, 0x45b7, 0xc160, 0xc362, 0xbd87, 0xbce5, 0x4032, 0x3ed0,
    0xc1e6, 0x2940, 0xc1e2, 0x406d, 0x420e, 0xbbff, 0x3fe5, 0x3630,
    0xb00f, 0xb952, 0x3fa7, 0x3e2e, 0x3e49, 0x3f14, 0xbe3f, 0x3f03,
    0xae10, 0x366b, 0xbc74, 0x4126, 0xb21d, 0xbc16, 0xc15c, 0xbc84,
    0x401d, 0x3e33, 0xbba0, 0xacd8, 0x3756, 0xc1f8, 0x4194, 0xbff8,
    0xc124, 0x400b, 0xbafa, 0x3fb9, 0x312a, 0x39b0, 0x359c, 0xc703,
    0xa24d, 0x414b, 0x39ce, 0xbcba, 0x334a, 0xc16d, 0x3bb2, 0x3d37,
    0xba36, 0xb61c, 0x3c8f, 0x3dea, 0xc3ad, 0x2c51, 0xbc8c, 0x2c70,
    0xc48d, 0x3efd, 0x426d, 0xbc8a, 0x3fee, 0x3deb, 0xc466, 0x3ae9,
    0x3c58, 0x38eb, 0xbbb5, 0x4036, 0x3f23, 0x3b43, 0xc29f, 0x431b,
    0xc368, 0x42b6, 0x3040, 0x4032, 0x40ab, 0x4439, 0x3c3e, 0xc0cf,
    0x3cbb, 0x3cad, 0xb518, 0xb9ce, 0x3a5c, 0x4398, 0xb27d, 0x3b69,
    0x26d4, 0xb9b0, 0x4416, 0x4235, 0x3968, 0xc1a8, 0xbf21, 0xb4ee,
    0xab41, 0xc046, 0x41ba, 0x401c, 0x4782, 0x3d18, 0xc455, 0xa9bd,
    0x3f77, 0x4231, 0xbac6, 0x30ec, 0x4099, 0x40a5, 0x4198, 0x313c,
    0xc425, 0xc407, 0xc462, 0x3ec5, 0x4343, 0x34e0, 0x3e0e, 0xbcc3,
    0x4016, 0xc02b, 0x40aa, 0xb400, 0x4316, 0xbed5, 0x3b78, 0xbe04,
    0x3f52, 0x3bdb, 0x4343, 0xbc47, 0x44ff, 0xbf37, 0x41bb, 0x34e9,
    0xc300, 0x3a79, 0x3b9c, 0xafc2, 0xc24a, 0xa83d, 0xb34c, 0xbda1,
    0x39ac, 0xb14e, 0x42d5, 0x3dfa, 0x3d5e, 0xb076, 0x3cca, 0x3cd2,
    0xbf63, 0xc19f, 0x3ee8, 0x408e, 0xc084, 0x4061, 0xc045, 0xb434,
    0xc239, 0x39a6, 0x3798, 0x3789, 0x391f, 0x414c, 0xbc34, 0xaefa,
    0xc39a, 0xbc79, 0xc197, 0xbe53, 0x4356, 0xb961, 0x4055, 0xc10b,
    0x3850, 0x3e86, 0xb8a0, 0xc02e, 0x4298, 0x40b7, 0xacb7, 0xbe4e,
    0x3c14, 0x3da9, 0xb8ea, 0x288b, 0x3c54, 0xb7c2, 0xc07b, 0x3d3c,
    0xc01a, 0xbf83, 0x4106, 0x33be, 0x3048, 0xc58f, 0xb41f, 0x45c1,
    0x404b, 0x3865, 0x3e56, 0x42c4, 0x4266, 0x3c14, 0x2ee9, 0xb058,
    0x34d4, 0x295f, 0xb2f7, 0x42de, 0x4047, 0x41ae, 0x3f59, 0x3807,
    0xb4c7, 0x3c7c, 0xbc17, 0xc1a8, 0x2c17, 0x4052, 0x3e68, 0x3cb3,
    0xb16e, 0xbafa, 0xbbf2, 0x419a, 0xc444, 0x3f86, 0xbeee, 0xbed0,
    0xc199, 0xbe33, 0xbc06, 0xc341, 0xb66a, 0xbd4e, 0xc0f2, 0xc1a3,
    0x3f43, 0xb824, 0xbe06, 0xc084, 0xc38a, 0x2c85, 0x40d2, 0x28ed,
    0x410e, 0xbbff, 0x3859, 0xb954, 0xbd95, 0xc197, 0x40b6, 0xb1b3,
    0xb1e5, 0xc2d1, 0x3a78, 0x2b57, 0x3d36, 0xbf52, 0x4409, 0xc2df,
    0x3f94, 0xc031, 0xc263, 0xbdb0, 0xbbc9, 0xbcb1, 0x4234, 0xc085,
    0x40e8, 0xbd4e, 0xc173, 0x383f, 0xb59e, 0x3a8c, 0xbfba, 0x44c2,
    0xb6c2, 0xbb82, 0x4569, 0x39df, 0x4174, 0x4471, 0x410d, 0xc3c9,
    0xc051, 0xa919, 0xc2a2, 0xc429, 0xbd5c, 0x44fe, 0x44eb, 0x3d84,
    0xc304, 0x3924, 0xc480, 0xc036, 0xc2db, 0xb943, 0x3d2f, 0xbc05,
    0x35e5, 0x43ac, 0xb904, 0x3717, 0x32cb, 0xbea8, 0x437c, 0x3e1b,
    0x354a, 0xc01a, 0xaf9f, 0xbc9f, 0xc25b, 0x3cca, 0x25e5, 0xb444,
    0xc03f, 0xc21d, 0x4294, 0xbeb1, 0x3e44, 0x4323, 0xbb35, 0xbf1c,
    0x3e77, 0x3458, 0xbdc4, 0x4433, 0xc1f1, 0x2c2a, 0xbb52, 0xb557,
    0x3c5b, 0x2ae6, 0x3075, 0x3d62, 0x3c6c, 0xbbae, 0x38a0, 0xc0e8,
    0x3d1a, 0xbc67, 0xbd32, 0xb96d, 0xc0a7, 0x3593, 0x42cb, 0xba72,
    0xbed8, 0xc204, 0xc10d, 0xb813, 0xb8b3, 0x4485, 0xc109, 0xc344,
    0xb4b5, 0x42d5, 0x427d, 0xc33c, 0xc09e, 0xbcd9, 0x3ff8, 0x3eff,
    0xbaaa, 0xc036, 0x3fe0, 0x3f73, 0x3df7, 0x4136, 0xc112, 0x3e14,
    0xc0f7, 0xb613, 0xc29a, 0x448b, 0xbea0, 0xb594, 0x3d43, 0x32a1,
    0x37bf, 0xbdb9, 0x410b, 0x39e0, 0x3d4e, 0x43e7, 0xc10a, 0xb5f6,
    0x4120, 0xc05e, 0x4463, 0x3f5b, 0xbcba, 0xc113, 0x3edb, 0xabb8,
    0xbfcf, 0x4056, 0xbec4, 0x3a8a, 0x440e, 0xb23a, 0x33b1, 0x43f5,
    0x40b6, 0x4011, 0xbb8e, 0xb6dd, 0x42c3, 0x3662, 0x2e4a, 0xc43f,
    0x3f76, 0xbe3d, 0x3a6d, 0x4052, 0x3e87, 0x3d61, 0x3d6f, 0x442d,
    0x387b, 0xbd5a, 0x4043, 0x4113, 0xb4e0, 0x4218, 0x45ad, 0x3a95,
    0xc2ab, 0xc2d6, 0xb522, 0xc24b, 0x38be, 0x4098, 0x411f, 0xbaaf,
    0x2130, 0xc24e, 0xbec0, 0xba8c, 0xc752, 0xbd52, 0x4213, 0xc127,
    0x43e4, 0xba0d, 0x357c, 0x37b2, 0xbf84, 0x3cda, 0xb624, 0xc4a9,
    0x41c1, 0xbe37, 0xbce4, 0x3aa4, 0x403a, 0x36c3, 0xbcd7, 0xb49b,
    0x3c58, 0x408c, 0x4433, 0x4043, 0xc063, 0x3fc2, 0x4106, 0xc281,
    0x3cd1, 0xc0be, 0x3c1b, 0xbb63, 0x425e, 0x44f6, 0x391e, 0xadeb,
    0x3c78, 0x3ebd, 0xbc7f, 0x3d00, 0xc2b9, 0x3a9a, 0xbebb, 0x3423,
    0xb9de, 0x4143, 0x3dec, 0xbc6f, 0x3846, 0xbf38, 0x3d5f, 0xc31d,
    0xbc67, 0xb912, 0x365c, 0xbc42, 0xc2ac, 0xc267, 0x3e3a, 0xc0c2,
    0x3d2e, 0xc2b9, 0x3ec4, 0xb2d9, 0xb7e8, 0x358d, 0x4472, 0x40c5,
    0xc2ab, 0xc1ff, 0x400d, 0xbb0f, 0xb2c9, 0x43fc, 0xbd97, 0xb82c,
    0x42da, 0x3d23, 0x381a, 0xb91e, 0x4271, 0xbdbd, 0x42bc, 0xc02d,
    0xc3dc, 0x3e18, 0xbd4d, 0xc4e0, 0xbd45, 0x4126, 0xb0ce, 0x40cd,
    0x35c5, 0x363f, 0x4028, 0xc153, 0x4062, 0x3f3b, 0x44f9, 0xbe31,
    0xb641, 0xc445, 0x39f3, 0xbca8, 0x2d8c, 0xbcab, 0xbfb0, 0xb10e,
    0x40e6, 0xbf91, 0x3f3e, 0x3bf3, 0x37de, 0x4297, 0xb8f3, 0x3b37,
    0x403c, 0xbae0, 0x4339, 0xac80, 0x3840, 0xb0ea, 0x30af, 0x43e0,
    0x267f, 0xbf0b, 0xb4d9, 0x3b98, 0xc4bf, 0x417c, 0x3d37, 0xc1a5,
    0x416a, 0xb1c8, 0x4092, 0x3506, 0x4048, 0x292c, 0x3dd6, 0xb873,
    0x4151, 0xc096, 0x28a6, 0xbc03, 0x426e, 0x450b, 0xb34f, 0x42d5,
    0x3d36, 0x2ab5, 0xc3f7, 0x40e1, 0x4200, 0x2925, 0xb62a, 0xb8b6,
    0x4048, 0xbfbf, 0x1fd7, 0xc1b7, 0xc0db, 0xc17b, 0xbd84, 0xbbcd,
    0x33c4, 0xc248, 0x3cd6, 0xc081, 0xbc88, 0xbd0d, 0xbdc4, 0xc456,
    0x4464, 0xb984, 0x4406, 0x4402, 0xc0f8, 0xbfc6, 0xb90b, 0xb74b,
    0x3e4b, 0x3eae, 0x4098, 0xbe40, 0xbe8e, 0x3d65, 0xb563, 0x4432,
    0x3f87, 0x3cc9, 0xc235, 0xbdca, 0x3edc, 0xbffd, 0x41fa, 0x4465,
    0xc04c, 0xc070, 0xbd19, 0xb592, 0xc049, 0x411f, 0x44b9, 0xb973,
    0x3cdc, 0x3819, 0xb81b, 0x4078, 0x3bec, 0x47e6, 0xbcc4, 0x3e15,
    0x3be9, 0xbdcb, 0xc02c, 0xb885, 0xbf20, 0xba3a, 0x42ba, 0x2c6a,
    0xbcf4, 0x41ac, 0x36bf, 0x447f, 0xc23e, 0x42c7, 0xc023, 0x3b76,
    0x42fc, 0xbaf7, 0xb78b, 0xc5da, 0xc122, 0xb79f, 0xc380, 0x4022,
    0xc144, 0x35ee, 0xc39c, 0xb4b5, 0xbb7d, 0xc209, 0xb9a1, 0x422a,
    0x3edc, 0xb9ab, 0xbde1, 0x3ef6, 0xbfa4, 0xb011, 0x34a5, 0xc2a5,
    0x394d, 0x3f48, 0xc019, 0xb694, 0x3e2b, 0xbd57, 0xc045, 0x34a0,
    0xbec7, 0xbc2f, 0x2ed5, 0x44cc, 0xc17c, 0xbcb5, 0xc07f, 0xae0b,
    0x42ce, 0x37e0, 0xc3ee, 0xaaac, 0xbf54, 0x39d0, 0xc0f6, 0xbcf4,
    0x4253, 0xb78e, 0x3bcf, 0xbeeb, 0x44a4, 0xbfd6, 0x3da8, 0x420f,
    0x4498, 0xbf26, 0xc322, 0x4241, 0x3f08, 0xbae9, 0x3cec, 0x3f5d,
    0x39f9, 0x4276, 0x3fcb, 0xbebf, 0xc07f, 0x414b, 0x3ca6, 0xbd56,
    0x3c3a, 0x2eb0, 0xb17d, 0xb80b, 0xb2bc, 0x3cff, 0x430e, 0xbc85,
    0xc023, 0x40a3, 0xc48c, 0xbc8f, 0x4603, 0xb3b9, 0xc2ea, 0x45a7,
    0xc4bb, 0xba72, 0xc40b, 0xb706, 0xc04b, 0xb82c, 0x3f1b, 0x33c0,
    0xbcda, 0xc23d, 0x3dd3, 0x42b6, 0xc00e, 0x32dd, 0x3b47, 0xbdfa,
    0x390a, 0xc44c, 0x41f4, 0xbc73, 0xc098, 0xbb69, 0xc1e0, 0xbfba,
    0xc217, 0x329f, 0x403f, 0xbc07, 0x3d44, 0x3e87, 0xc0ee, 0xba9f,
    0xbe7c, 0xb636, 0x40ef, 0x413e, 0x30c4, 0xc6cb, 0xb5e3, 0x4186,
    0x3cf1, 0x420c, 0x4214, 0xc1e3, 0xc2b4, 0x3c43, 0x3fcb, 0x439e,
    0x3db5, 0x45a1, 0x22ab, 0x452e, 0xc04f, 0x3a87, 0x4480, 0xbd98,
    0x3f68, 0x3763, 0xa628, 0x2dec, 0x3de5, 0x4419, 0xbefe, 0xc2a8,
    0xbcb9, 0x400d, 0x3044, 0x3b14, 0x435b, 0x3d02, 0xad2c, 0xc257,
    0x3c22, 0xbc03, 0x4169, 0xbd40, 0x31ee, 0x42b6, 0x295e, 0x3f6e,
    0x391f, 0xbb1d, 0xb99d, 0xc049, 0xbcad, 0x4119, 0xbb87, 0xc6b8,
    0x3ca6, 0x41a4, 0xbe79, 0x3621, 0xbdb0, 0x3267, 0x3f1b, 0xbec6,
    0x3fc8, 0x3e21, 0x3b27, 0x3371, 0xbefc, 0x368f, 0xc01f, 0xbd61,
    0xad0d, 0xbbc2, 0xbe43, 0xb6f2, 0x3a5b, 0x3feb, 0xbf48, 0x3e14,
    0x42f0, 0xc057, 0xbe1f, 0xc02c, 0x3c43, 0x3c2d, 0x3e30, 0xb0eb,
    0x389a, 0xbc75, 0x4359, 0xc00b, 0xbfd0, 0x40e9, 0x444f, 0x449e,
    0xbfed, 0xbf33, 0xc0ad, 0xb40a, 0xb6ff, 0xa6a2, 0x2d32, 0xbc41,
    0xc10a, 0x38bb, 0x3cb5, 0xbe62, 0x31c5, 0xba9f, 0xbd08, 0xc439,
    0x38d7, 0x3dc5, 0x2dc3, 0x41f2, 0xc030, 0x41c9, 0xb4bc, 0x36e1,
    0xb874, 0xbd18, 0xb040, 0x3eb8, 0x45d3, 0xb9b1, 0x44e0, 0x43a3,
    0x3b66, 0xbe30, 0x404b, 0xbc48, 0xc02a, 0x4188, 0x355c, 0xbc77,
    0x405b, 0x404c, 0x3af5, 0xc731, 0x4389, 0xbba9, 0xb889, 0x3b49,
    0xbeec, 0x3f9e, 0x3ad8, 0xb8dc, 0x4128, 0xbcc3, 0xbb00, 0xc1c4,
    0xc00a, 0x401a, 0xbeb1, 0xb8f0, 0x4131, 0xc27c, 0xb80f, 0xbea8,
    0x3c61, 0xc1e9, 0x3c6a, 0xc520, 0x3709, 0xc574, 0xb680, 0xb578,
    0x3c7a, 0x3747, 0x3897, 0xc098, 0x3d7e, 0x4015, 0x44bd, 0xbfa6,
    0xc476, 0xaeb4, 0x3a1a, 0xc0b6, 0x3f57, 0xb8bb, 0xbd08, 0x3eaf,
    0xb85f, 0xb323, 0x3e14, 0x3d15, 0x3cfd, 0x4567, 0x326d, 0xc172,
    0x398b, 0xb7af, 0x342b, 0x38ee, 0x3681, 0x31e4, 0xb188, 0xadf0,
    0x371a, 0xbee8, 0x3c17, 0x4569, 0xc4f5, 0xbd66, 0xbe9a, 0xbe70,
    0x3b3d, 0x43fa, 0x411d, 0xc056, 0xbeee, 0xb755, 0x458c, 0xb8b5,
    0xc4d7, 0xbcd4, 0x3dc4, 0xc1d9, 0x446c, 0xbe3c, 0xb49c, 0xb9cc,
    0xc3b0, 0x40f0, 0xbdf9, 0x4536, 0x408e, 0x3b41, 0xbee3, 0x3797,
    0xa6b8, 0xc2d2, 0x4587, 0xbd57, 0x4206, 0x422a, 0xc2b3, 0x4151,
    0xc042, 0x3d73, 0x4069, 0x40f0, 0xc02f, 0x4325, 0xb03a, 0xbcc4,
    0xb472, 0xbe97, 0xb696, 0xc054, 0xb181, 0xb776, 0x371d, 0xc270,
    0x3f31, 0xbae4, 0x1931, 0xb7ab, 0x3f43, 0xc465, 0x3fd4, 0x40e7,
    0x4129, 0xc0f6, 0xbc3f, 0x3a9d, 0xbcc9, 0xbf6d, 0xbd6f, 0xc278,
    0xc44a, 0xc410, 0xc185, 0xb728, 0x3729, 0xa594, 0xc22f, 0xc36e,
    0x4042, 0xc136, 0xc293, 0x44e0, 0x44fa, 0x3648, 0xbd31, 0x3b46,
    0x4167, 0xbd15, 0x3a28, 0x3dcc, 0xbe04, 0x4337, 0x38ce, 0xc44e,
    0xc20b, 0x448a, 0xb9ea, 0xbb29, 0xb8d8, 0xbe46, 0xc17b, 0xbae6,
    0x42ba, 0xc394, 0xc389, 0x3857, 0x40cd, 0x41c6, 0xc05a, 0x401b,
    0xb887, 0x3f89, 0xc456, 0xb899, 0x2952, 0xbed9, 0x42a5, 0xb929,
    0x4189, 0x4082, 0x401a, 0x4156, 0x4073, 0x9d97, 0x43c3, 0xbc7c,
    0xa0fc, 0x4035, 0xbf02, 0xc124, 0xbd0d, 0xbce1, 0xb8e2, 0xb749,
    0xc430, 0x3cfb, 0x35e0, 0x421f, 0xc1ce, 0x3dd0, 0x3d00, 0xc24a,
    0xbcb4, 0xbe18, 0x3dd2, 0x3b5c, 0xc043, 0x412e, 0x407a, 0x3f1a,
    0xba9d, 0xc023, 0xbe59, 0x4100, 0xbb0d, 0xbcdf, 0xc0b0, 0x39a7,
    0xc07c, 0xbb60, 0xb00c, 0x3622, 0xbc5b, 0xbe03, 0xc29d, 0x3af8,
    0x3a74, 0xbdc2, 0x38c0, 0x40f2, 0xc0a9, 0xbc17, 0xc276, 0xbd82,
    0x3d15, 0xbf5a, 0xc0e6, 0x2ef6, 0xba0d, 0x38f4, 0xbcef, 0xbeb1,
    0x3fd7, 0xbfba, 0x3366, 0xbd49, 0xbe6f, 0x3f6d, 0xc0b7, 0x3c5c,
    0xc1f7, 0xb67b, 0xc1a9, 0x35fe, 0xbe2e, 0xc3de, 0xc434, 0x4056,
    0xc11e, 0x35b6, 0x410a, 0x4107, 0x35be, 0x4151, 0xb6ad, 0xb42c,
    0xc42d, 0xc46c, 0x403c, 0x3fbe, 0x3a91, 0x4091, 0xc1fc, 0x3a27,
    0xbd9a, 0xb887, 0xa87c, 0xc0fe, 0xbd72, 0xc2a3, 0xb0e3, 0x3974,
    0x37a4, 0x43a8, 0x4059, 0x4442, 0x4001, 0x2f08, 0xb7b1, 0xb4fd,
    0xc199, 0x3d19, 0xc270, 0x403b, 0xbef1, 0xc06c, 0xa829, 0xc116,
    0x3985, 0x459a, 0xbdcc, 0xc00d, 0xb603, 0xc3cb, 0x35e4, 0xb5ba,
    0x3e99, 0xbda1, 0xc18c, 0x3989, 0x9c4c, 0x4526, 0x20aa, 0x3b83,
    0xbe27, 0xbecc, 0xb3a8, 0x3f2c, 0xc0b8, 0xc1de, 0xbe66, 0xbfbe,
    0x39c0, 0xc1c7, 0x2de9, 0xadaa, 0x37b2, 0x3c9c, 0xad52, 0x3c4b,
    0x3c76, 0x449a, 0xbb52, 0xbe8d, 0x3cd1, 0xbf5e, 0x3ea3, 0x40fe,
    0x41c4, 0xb241, 0x3b86, 0x3e9f, 0x43ad, 0xbd71, 0x391d, 0x3d78,
    0x30b0, 0x35af, 0xb807, 0x3c4b, 0x3662, 0xc314, 0xc13c, 0x3dc7,
    0x448a, 0x343b, 0x388e, 0x3e50, 0x4248, 0x408e, 0x4213, 0xc368,
    0x4216, 0x435f, 0xba92, 0xb56d, 0x3c47, 0x407d, 0xc2e5, 0xb73d,
    0xb3f0, 0xbc4f, 0xc140, 0xb99f, 0xb98f, 0xc0cd, 0x2a88, 0xbe0c,
    0xb24b, 0x0, 0x2a88, 0x3e0c, 0xb98f, 0x40cd, 0xc140, 0x399f,
    0xb3f0, 0x3c4f, 0xc2e5, 0x373d, 0x3c47, 0xc07d, 0xba92, 0x356d,
    0x4216, 0xc35f, 0x4213, 0x4368, 0x4248, 0xc08e, 0x388e, 0xbe50,
    0x448a, 0xb43b, 0xc13c, 0xbdc7, 0x3662, 0x4314, 0xb807, 0xbc4b,
    0x30b0, 0xb5af, 0x391d, 0xbd78, 0x43ad, 0x3d71, 0x3b86, 0xbe9f,
    0x41c4, 0x3241, 0x3ea3, 0xc0fe, 0x3cd1, 0x3f5e, 0xbb52, 0x3e8d,
    0x3c76, 0xc49a, 0xad52, 0xbc4b, 0x37b2, 0xbc9c, 0x2de9, 0x2daa,
    0x39c0, 0x41c7, 0xbe66, 0x3fbe, 0xc0b8, 0x41de, 0xb3a8, 0xbf2c,
    0xbe27, 0x3ecc, 0x20aa, 0xbb83, 0x9c4c, 0xc526, 0xc18c, 0xb989,
    0x3e99, 0x3da1, 0x35e4, 0x35ba, 0xb603, 0x43cb, 0xbdcc, 0x400d,
    0x3985, 0xc59a, 0xa829, 0x4116, 0xbef1, 0x406c, 0xc270, 0xc03b,
    0xc199, 0xbd19, 0xb7b1, 0x34fd, 0x4001, 0xaf08, 0x4059, 0xc442,
    0x37a4, 0xc3a8, 0xb0e3, 0xb974, 0xbd72, 0x42a3, 0xa87c, 0x40fe,
    0xbd9a, 0x3887, 0xc1fc, 0xba27, 0x3a91, 0xc091, 0x403c, 0xbfbe,
    0xc42d, 0x446c, 0xb6ad, 0x342c, 0x35be, 0xc151, 0x410a, 0xc107,
    0xc11e, 0xb5b6, 0xc434, 0xc056, 0xbe2e, 0x43de, 0xc1a9, 0xb5fe,
    0xc1f7, 0x367b, 0xc0b7, 0xbc5c, 0xbe6f, 0xbf6d, 0x3366, 0x3d49,
    0x3fd7, 0x3fba, 0xbcef, 0x3eb1, 0xba0d, 0xb8f4, 0xc0e6, 0xaef6,
    0x3d15, 0x3f5a, 0xc276, 0x3d82, 0xc0a9, 0x3c17, 0x38c0, 0xc0f2,
    0x3a74, 0x3dc2, 0xc29d, 0xbaf8, 0xbc5b, 0x3e03, 0xb00c, 0xb622,
    0xc07c, 0x3b60, 0xc0b0, 0xb9a7, 0xbb0d, 0x3cdf, 0xbe59, 0xc100,
    0xba9d, 0x4023, 0x407a, 0xbf1a, 0xc043, 0xc12e, 0x3dd2, 0xbb5c,
    0xbcb4, 0x3e18, 0x3d00, 0x424a, 0xc1ce, 0xbdd0, 0x35e0, 0xc21f,
    0xc430, 0xbcfb, 0xb8e2, 0x3749, 0xbd0d, 0x3ce1, 0xbf02, 0x4124,
    0xa0fc, 0xc035, 0x43c3, 0x3c7c, 0x4073, 0x1d97, 0x401a, 0xc156,
    0x4189, 0xc082, 0x42a5, 0x3929, 0x2952, 0x3ed9, 0xc456, 0x3899,
    0xb887, 0xbf89, 0xc05a, 0xc01b, 0x40cd, 0xc1c6, 0xc389, 0xb857,
    0x42ba, 0x4394, 0xc17b, 0x3ae6, 0xb8d8, 0x3e46, 0xb9ea, 0x3b29,
    0xc20b, 0xc48a, 0x38ce, 0x444e, 0xbe04, 0xc337, 0x3a28, 0xbdcc,
    0x4167, 0x3d15, 0xbd31, 0xbb46, 0x44fa, 0xb648, 0xc293, 0xc4e0,
    0x4042, 0x4136, 0xc22f, 0x436e, 0x3729, 0x2594, 0xc185, 0x3728,
    0xc44a, 0x4410, 0xbd6f, 0x4278, 0xbcc9, 0x3f6d, 0xbc3f, 0xba9d,
    0x4129, 0x40f6, 0x3fd4, 0xc0e7, 0x3f43, 0x4465, 0x1931, 0x37ab,
    0x3f31, 0x3ae4, 0x371d, 0x4270, 0xb181, 0x3776, 0xb696, 0x4054,
    0xb472, 0x3e97, 0xb03a, 0x3cc4, 0xc02f, 0xc325, 0x4069, 0xc0f0,
    0xc042, 0xbd73, 0xc2b3, 0xc151, 0x4206, 0xc22a, 0x4587, 0x3d57,
    0xa6b8, 0x42d2, 0xbee3, 0xb797, 0x408e, 0xbb41, 0xbdf9, 0xc536,
    0xc3b0, 0xc0f0, 0xb49c, 0x39cc, 0x446c, 0x3e3c, 0x3dc4, 0x41d9,
    0xc4d7, 0x3cd4, 0x458c, 0x38b5, 0xbeee, 0x3755, 0x411d, 0x4056,
    0x3b3d, 0xc3fa, 0xbe9a, 0x3e70, 0xc4f5, 0x3d66, 0x3c17, 0xc569,
    0x371a, 0x3ee8, 0xb188, 0x2df0, 0x3681, 0xb1e4, 0x342b, 0xb8ee,
    0x398b, 0x37af, 0x326d, 0x4172, 0x3cfd, 0xc567, 0x3e14, 0xbd15,
    0xb85f, 0x3323, 0xbd08, 0xbeaf, 0x3f57, 0x38bb, 0x3a1a, 0x40b6,
    0xc476, 0x2eb4, 0x44bd, 0x3fa6, 0x3d7e, 0xc015, 0x3897, 0x4098,
    0x3c7a, 0xb747, 0xb680, 0x3578, 0x3709, 0x4574, 0x3c6a, 0x4520,
    0x3c61, 0x41e9, 0xb80f, 0x3ea8, 0x4131, 0x427c, 0xbeb1, 0x38f0,
    0xc00a, 0xc01a, 0xbb00, 0x41c4, 0x4128, 0x3cc3, 0x3ad8, 0x38dc,
    0xbeec, 0xbf9e, 0xb889, 0xbb49, 0x4389, 0x3ba9, 0x3af5, 0x4731,
    0x405b, 0xc04c, 0x355c, 0x3c77, 0xc02a, 0xc188, 0x404b, 0x3c48,
    0x3b66, 0x3e30, 0x44e0, 0xc3a3, 0x45d3, 0x39b1, 0xb040, 0xbeb8,
    0xb874, 0x3d18, 0xb4bc, 0xb6e1, 0xc030, 0xc1c9, 0x2dc3, 0xc1f2,
    0x38d7, 0xbdc5, 0xbd08, 0x4439, 0x31c5, 0x3a9f, 0x3cb5, 0x3e62,
    0xc10a, 0xb8bb, 0x2d32, 0x3c41, 0xb6ff, 0x26a2, 0xc0ad, 0x340a,
    0xbfed, 0x3f33, 0x444f, 0xc49e, 0xbfd0, 0xc0e9, 0x4359, 0x400b,
    0x389a, 0x3c75, 0x3e30, 0x30eb, 0x3c43, 0xbc2d, 0xbe1f, 0x402c,
    0x42f0, 0x4057, 0xbf48, 0xbe14, 0x3a5b, 0xbfeb, 0xbe43, 0x36f2,
    0xad0d, 0x3bc2, 0xc01f, 0x3d61, 0xbefc, 0xb68f, 0x3b27, 0xb371,
    0x3fc8, 0xbe21, 0x3f1b, 0x3ec6, 0xbdb0, 0xb267, 0xbe79, 0xb621,
    0x3ca6, 0xc1a4, 0xbb87, 0x46b8, 0xbcad, 0xc119, 0xb99d, 0x4049,
    0x391f, 0x3b1d, 0x295e, 0xbf6e, 0x31ee, 0xc2b6, 0x4169, 0x3d40,
    0x3c22, 0x3c03, 0xad2c, 0x4257, 0x435b, 0xbd02, 0x3044, 0xbb14,
    0xbcb9, 0xc00d, 0xbefe, 0x42a8, 0x3de5, 0xc419, 0xa628, 0xadec,
    0x3f68, 0xb763, 0x4480, 0x3d98, 0xc04f, 0xba87, 0x22ab, 0xc52e,
    0x3db5, 0xc5a1, 0x3fcb, 0xc39e, 0xc2b4, 0xbc43, 0x4214, 0x41e3,
    0x3cf1, 0xc20c, 0xb5e3, 0xc186, 0x30c4, 0x46cb, 0x40ef, 0xc13e,
    0xbe7c, 0x3636, 0xc0ee, 0x3a9f, 0x3d44, 0xbe87, 0x403f, 0x3c07,
    0xc217, 0xb29f, 0xc1e0, 0x3fba, 0xc098, 0x3b69, 0x41f4, 0x3c73,
    0x390a, 0x444c, 0x3b47, 0x3dfa, 0xc00e, 0xb2dd, 0x3dd3, 0xc2b6,
    0xbcda, 0x423d, 0x3f1b, 0xb3c0, 0xc04b, 0x382c, 0xc40b, 0x3706,
    0xc4bb, 0x3a72, 0xc2ea, 0xc5a7, 0x4603, 0x33b9, 0xc48c, 0x3c8f,
    0xc023, 0xc0a3, 0x430e, 0x3c85, 0xb2bc, 0xbcff, 0xb17d, 0x380b,
    0x3c3a, 0xaeb0, 0x3ca6, 0x3d56, 0xc07f, 0xc14b, 0x3fcb, 0x3ebf,
    0x39f9, 0xc276, 0x3cec, 0xbf5d, 0x3f08, 0x3ae9, 0xc322, 0xc241,
    0x4498, 0x3f26, 0x3da8, 0xc20f, 0x44a4, 0x3fd6, 0x3bcf, 0x3eeb,
    0x4253, 0x378e, 0xc0f6, 0x3cf4, 0xbf54, 0xb9d0, 0xc3ee, 0x2aac,
    0x42ce, 0xb7e0, 0xc07f, 0x2e0b, 0xc17c, 0x3cb5, 0x2ed5, 0xc4cc,
    0xbec7, 0x3c2f, 0xc045, 0xb4a0, 0x3e2b, 0x3d57, 0xc019, 0x3694,
    0x394d, 0xbf48, 0x34a5, 0x42a5, 0xbfa4, 0x3011, 0xbde1, 0xbef6,
    0x3edc, 0x39ab, 0xb9a1, 0xc22a, 0xbb7d, 0x4209, 0xc39c, 0x34b5,
    0xc144, 0xb5ee, 0xc380, 0xc022, 0xc122, 0x379f, 0xb78b, 0x45da,
    0x42fc, 0x3af7, 0xc023, 0xbb76, 0xc23e, 0xc2c7, 0x36bf, 0xc47f,
    0xbcf4, 0xc1ac, 0x42ba, 0xac6a, 0xbf20, 0x3a3a, 0xc02c, 0x3885,
    0x3be9, 0x3dcb, 0xbcc4, 0xbe15, 0x3bec, 0xc7e6, 0xb81b, 0xc078,
    0x3cdc, 0xb819, 0x44b9, 0x3973, 0xc049, 0xc11f, 0xbd19, 0x3592,
    0xc04c, 0x4070, 0x41fa, 0xc465, 0x3edc, 0x3ffd, 0xc235, 0x3dca,
    0x3f87, 0xbcc9, 0xb563, 0xc432, 0xbe8e, 0xbd65, 0x4098, 0x3e40,
    0x3e4b, 0xbeae, 0xb90b, 0x374b, 0xc0f8, 0x3fc6, 0x4406, 0xc402,
    0x4464, 0x3984, 0xbdc4, 0x4456, 0xbc88, 0x3d0d, 0x3cd6, 0x4081,
    0x33c4, 0x4248, 0xbd84, 0x3bcd, 0xc0db, 0x417b, 0x1fd7, 0x41b7,
    0x4048, 0x3fbf, 0xb62a, 0x38b6, 0x4200, 0xa925, 0xc3f7, 0xc0e1,
    0x3d36, 0xaab5, 0xb34f, 0xc2d5, 0x426e, 0xc50b, 0x28a6, 0x3c03,
    0x4151, 0x4096, 0x3dd6, 0x3873, 0x4048, 0xa92c, 0x4092, 0xb506,
    0x416a, 0x31c8, 0x3d37, 0x41a5, 0xc4bf, 0xc17c, 0xb4d9, 0xbb98,
    0x267f, 0x3f0b, 0x30af, 0xc3e0, 0x3840, 0x30ea, 0x4339, 0x2c80,
    0x403c, 0x3ae0, 0xb8f3, 0xbb37, 0x37de, 0xc297, 0x3f3e, 0xbbf3,
    0x40e6, 0x3f91, 0xbfb0, 0x310e, 0x2d8c, 0x3cab, 0x39f3, 0x3ca8,
    0xb641, 0x4445, 0x44f9, 0x3e31, 0x4062, 0xbf3b, 0x4028, 0x4153,
    0x35c5, 0xb63f, 0xb0ce, 0xc0cd, 0xbd45, 0xc126, 0xbd4d, 0x44e0,
    0xc3dc, 0xbe18, 0x42bc, 0x402d, 0x4271, 0x3dbd, 0x381a, 0x391e,
    0x42da, 0xbd23, 0xbd97, 0x382c, 0xb2c9, 0xc3fc, 0x400d, 0x3b0f,
    0xc2ab, 0x41ff, 0x4472, 0xc0c5, 0xb7e8, 0xb58d, 0x3ec4, 0x32d9,
    0x3d2e, 0x42b9, 0x3e3a, 0x40c2, 0xc2ac, 0x4267, 0x365c, 0x3c42,
    0xbc67, 0x3912, 0x3d5f, 0x431d, 0x3846, 0x3f38, 0x3dec, 0x3c6f,
    0xb9de, 0xc143, 0xbebb, 0xb423, 0xc2b9, 0xba9a, 0xbc7f, 0xbd00,
    0x3c78, 0xbebd, 0x391e, 0x2deb, 0x425e, 0xc4f6, 0x3c1b, 0x3b63,
    0x3cd1, 0x40be, 0x4106, 0x4281, 0xc063, 0xbfc2, 0x4433, 0xc043,
    0x3c58, 0xc08c, 0xbcd7, 0x349b, 0x403a, 0xb6c3, 0xbce4, 0xbaa4,
    0x41c1, 0x3e37, 0xb624, 0x44a9, 0xbf84, 0xbcda, 0x357c, 0xb7b2,
    0x43e4, 0x3a0d, 0x4213, 0x4127, 0xc752, 0x3d52, 0xbec0, 0x3a8c,
    0x2130, 0x424e, 0x411f, 0x3aaf, 0x38be, 0xc098, 0xb522, 0x424b,
    0xc2ab, 0x42d6, 0x45ad, 0xba95, 0xb4e0, 0xc218, 0x4043, 0xc113,
    0x387b, 0x3d5a, 0x3d6f, 0xc42d, 0x3e87, 0xbd61, 0x3a6d, 0xc052,
    0x3f76, 0x3e3d, 0x2e4a, 0x443f, 0x42c3, 0xb662, 0xbb8e, 0x36dd,
    0x40b6, 0xc011, 0x33b1, 0xc3f5, 0x440e, 0x323a, 0xbec4, 0xba8a,
    0xbfcf, 0xc056, 0x3edb, 0x2bb8, 0xbcba, 0x4113, 0x4463, 0xbf5b,
    0x4120, 0x405e, 0xc10a, 0x35f6, 0x3d4e, 0xc3e7, 0x410b, 0xb9e0,
    0x37bf, 0x3db9, 0x3d43, 0xb2a1, 0xbea0, 0x3594, 0xc29a, 0xc48b,
    0xc0f7, 0x3613, 0xc112, 0xbe14, 0x3df7, 0xc136, 0x3fe0, 0xbf73,
    0xbaaa, 0x4036, 0x3ff8, 0xbeff, 0xc09e, 0x3cd9, 0x427d, 0x433c,
    0xb4b5, 0xc2d5, 0xc109, 0x4344, 0xb8b3, 0xc485, 0xc10d, 0x3813,
    0xbed8, 0x4204, 0x42cb, 0x3a72, 0xc0a7, 0xb593, 0xbd32, 0x396d,
    0x3d1a, 0x3c67, 0x38a0, 0x40e8, 0x3c6c, 0x3bae, 0x3075, 0xbd62,
    0x3c5b, 0xaae6, 0xbb52, 0x3557, 0xc1f1, 0xac2a, 0xbdc4, 0xc433,
    0x3e77, 0xb458, 0xbb35, 0x3f1c, 0x3e44, 0xc323, 0x4294, 0x3eb1,
    0xc03f, 0x421d, 0x25e5, 0x3444, 0xc25b, 0xbcca, 0xaf9f, 0x3c9f,
    0x354a, 0x401a, 0x437c, 0xbe1b, 0x32cb, 0x3ea8, 0xb904, 0xb717,
    0x35e5, 0xc3ac, 0x3d2f, 0x3c05, 0xc2db, 0x3943, 0xc480, 0x4036,
    0xc304, 0xb924, 0x44eb, 0xbd84, 0xbd5c, 0xc4fe, 0xc2a2, 0x4429,
    0xc051, 0x2919, 0x410d, 0x43c9, 0x4174, 0xc471, 0x4569, 0xb9df,
    0xb6c2, 0x3b82, 0xbfba, 0xc4c2, 0xb59e, 0xba8c, 0xc173, 0xb83f,
    0x40e8, 0x3d4e, 0x4234, 0x4085, 0xbbc9, 0x3cb1, 0xc263, 0x3db0,
    0x3f94, 0x4031, 0x4409, 0x42df, 0x3d36, 0x3f52, 0x3a78, 0xab57,
    0xb1e5, 0x42d1, 0x40b6, 0x31b3, 0xbd95, 0x4197, 0x3859, 0x3954,
    0x410e, 0x3bff, 0x40d2, 0xa8ed, 0xc38a, 0xac85, 0xbe06, 0x4084,
    0x3f43, 0x3824, 0xc0f2, 0x41a3, 0xb66a, 0x3d4e, 0xbc06, 0x4341,
    0xc199, 0x3e33, 0xbeee, 0x3ed0, 0xc444, 0xbf86, 0xbbf2, 0xc19a,
    0xb16e, 0x3afa, 0x3e68, 0xbcb3, 0x2c17, 0xc052, 0xbc17, 0x41a8,
    0xb4c7, 0xbc7c, 0x3f59, 0xb807, 0x4047, 0xc1ae, 0xb2f7, 0xc2de,
    0x34d4, 0xa95f, 0x2ee9, 0x3058, 0x4266, 0xbc14, 0x3e56, 0xc2c4,
    0x404b, 0xb865, 0xb41f, 0xc5c1, 0x3048, 0x458f, 0x4106, 0xb3be,
    0xc01a, 0x3f83, 0xc07b, 0xbd3c, 0x3c54, 0x37c2, 0xb8ea, 0xa88b,
    0x3c14, 0xbda9, 0xacb7, 0x3e4e, 0x4298, 0xc0b7, 0xb8a0, 0x402e,
    0x3850, 0xbe86, 0x4055, 0x410b, 0x4356, 0x3961, 0xc197, 0x3e53,
    0xc39a, 0x3c79, 0xbc34, 0x2efa, 0x391f, 0xc14c, 0x3798, 0xb789,
    0xc239, 0xb9a6, 0xc045, 0x3434, 0xc084, 0xc061, 0x3ee8, 0xc08e,
    0xbf63, 0x419f, 0x3cca, 0xbcd2, 0x3d5e, 0x3076, 0x42d5, 0xbdfa,
    0x39ac, 0x314e, 0xb34c, 0x3da1, 0xc24a, 0x283d, 0x3b9c, 0x2fc2,
    0xc300, 0xba79, 0x41bb, 0xb4e9, 0x44ff, 0x3f37, 0x4343, 0x3c47,
    0x3f52, 0xbbdb, 0x3b78, 0x3e04, 0x4316, 0x3ed5, 0x40aa, 0x3400,
    0x4016, 0x402b, 0x3e0e, 0x3cc3, 0x4343, 0xb4e0, 0xc462, 0xbec5,
    0xc425, 0x4407, 0x4198, 0xb13c, 0x4099, 0xc0a5, 0xbac6, 0xb0ec,
    0x3f77, 0xc231, 0xc455, 0x29bd, 0x4782, 0xbd18, 0x41ba, 0xc01c,
    0xab41, 0x4046, 0xbf21, 0x34ee, 0x3968, 0x41a8, 0x4416, 0xc235,
    0x26d4, 0x39b0, 0xb27d, 0xbb69, 0x3a5c, 0xc398, 0xb518, 0x39ce,
    0x3cbb, 0xbcad, 0x3c3e, 0x40cf, 0x40ab, 0xc439, 0x3040, 0xc032,
    0xc368, 0xc2b6, 0xc29f, 0xc31b, 0x3f23, 0xbb43, 0xbbb5, 0xc036,
    0x3c58, 0xb8eb, 0xc466, 0xbae9, 0x3fee, 0xbdeb, 0x426d, 0x3c8a,
    0xc48d, 0xbefd, 0xbc8c, 0xac70, 0xc3ad, 0xac51, 0x3c8f, 0xbdea,
    0xba36, 0x361c, 0x3bb2, 0xbd37, 0x334a, 0x416d, 0x39ce, 0x3cba,
    0xa24d, 0xc14b, 0x359c, 0x4703, 0x312a, 0xb9b0, 0xbafa, 0xbfb9,
    0xc124, 0xc00b, 0x4194, 0x3ff8, 0x3756, 0x41f8, 0xbba0, 0x2cd8,
    0x401d, 0xbe33, 0xc15c, 0x3c84, 0xb21d, 0x3c16, 0xbc74, 0xc126,
    0xae10, 0xb66b, 0xbe3f, 0xbf03, 0x3e49, 0xbf14, 0x3fa7, 0xbe2e,
    0xb00f, 0x3952, 0x3fe5, 0xb630, 0x420e, 0x3bff, 0xc1e2, 0xc06d,
    0xc1e6, 0xa940, 0x4032, 0xbed0, 0xbd87, 0x3ce5, 0xc160, 0x4362,
    0x3e6e, 0xc5b7, 0xc4fd, 0xb829, 0xbf3b, 0xc10d, 0x41ef, 0x3fe6,
    0xb8fc, 0xbda1, 0xb79f, 0xba4b, 0xc59e, 0xbd52, 0x38ee, 0x4079,
    0x3b16, 0x4114, 0xbc0c, 0x402b, 0x3f60, 0xbc8b, 0x3edb, 0xbc65,
    0x4040, 0xaeef, 0xbae8, 0xb5f3, 0x41c8, 0x321d, 0x38ed, 0x4078,
    0x3e55, 0xbfe0, 0xbe99, 0xb5e6, 0x40d9, 0xc263, 0x4307, 0xbdf7,
    0xbc48, 0x3dd1, 0xc089, 0xc029, 0xb718, 0xc0b9, 0x3b0b, 0xc212,
    0xc52a, 0xbd14, 0xb978, 0xc15e, 0xc2bf, 0xc45e, 0xc3ea, 0x431d,
    0x44c5, 0x4114, 0x3c4d, 0x3523, 0x3a0d, 0xb5df, 0xb67b, 0x4110,
    0xac03, 0x3c61, 0xb04a, 0xb623, 0xb992, 0x3a2a, 0xb996, 0x42a5,
    0x3984, 0xbcd3, 0xc0c2, 0x4559, 0x431b, 0x40e2, 0xb8dd, 0x41b4,
    0xc22a, 0x40d2, 0xc14c, 0x3da9, 0x4075, 0xc45a, 0xc149, 0x4442,
    0xc2f7, 0xbf78, 0xbea2, 0xc178, 0x372e, 0x36f9, 0x3662, 0xa1c1,
    0xac51, 0xc446, 0x419c, 0xbe4d, 0x41d4, 0xbd69, 0xbf4b, 0x4219,
    0x4180, 0x3867, 0x2f79, 0xb897, 0x3d87, 0xb9f4, 0x3bd8, 0xc381,
    0x4360, 0x2f27, 0xbe96, 0x3dce, 0xbcd4, 0xc120, 0x38fb, 0xb526,
    0x432d, 0x32db, 0x3f7e, 0x4076, 0x43ac, 0xbc97, 0xb566, 0xbd11,
    0xb098, 0xb825, 0xc3fa, 0x3a4d, 0xb047, 0x4199, 0xaccc, 0x4015,
    0x42e6, 0xba8e, 0xbca5, 0xc245, 0x3c31, 0xc10f, 0xc088, 0x354d,
    0x34bb, 0x40dd, 0x40f7, 0xc3b5, 0xc040, 0xbec4, 0x3d61, 0xc1ad,
    0x3541, 0xbc38, 0x448f, 0x447e, 0xc135, 0xc2b7, 0x3dc4, 0x43bf,
    0x3ac8, 0xbbee, 0xb961, 0x4268, 0xbd54, 0x3ed0, 0xbc34, 0x4429,
    0xc106, 0xbb45, 0x3df4, 0xbd67, 0xc075, 0x3eae, 0xc682, 0x3fbf,
    0x3360, 0x42d5, 0xb955, 0x3ce6, 0xbfca, 0x3f7d, 0x3938, 0x41d0,
    0x4240, 0xb09e, 0xb8eb, 0xbce5, 0xbe30, 0xc5b2, 0x40be, 0xbfe7,
    0xc1d4, 0xb2a2, 0xc32a, 0xa85a, 0xbc91, 0xc0fa, 0xc446, 0xbda3,
    0xbe29, 0xc05b, 0xb485, 0xc0d0, 0x3bba, 0x3bf2, 0xb8ba, 0x3d04,
    0xbb96, 0xc29b, 0xbce6, 0xb852, 0xc40d, 0x38e7, 0x3daa, 0xc246,
    0xc280, 0xbada, 0x33a2, 0xb826, 0xbffc, 0x3cbd, 0xc0c3, 0xc0c7,
    0xad47, 0xc347, 0x3c82, 0xbeac, 0xb5f3, 0x3fdc, 0x4477, 0xc1fb,
    0x4442, 0xc4c5, 0x3e42, 0xbe14, 0x39a7, 0xb7d1, 0xc1a1, 0xb684,
    0x2cd6, 0x3cc6, 0xc397, 0xbdba, 0xb607, 0x4122, 0x4027, 0x42ff,
    0x318e, 0xb888, 0x436a, 0x38a2, 0x4153, 0xbcd9, 0x4021, 0xb4a2,
    0x4499, 0xb918, 0x36b9, 0x3404, 0x3f0a, 0xb070, 0x4064, 0xb4d4,
    0x3701, 0x34f6, 0xbec2, 0xb17f, 0xc023, 0xbbca, 0xbcf7, 0x3c85,
    0xb9ab, 0xbfe5, 0x3936, 0xbeec, 0x42da, 0xb3a1, 0xafdc, 0xc28b,
    0xbdb4, 0xb51f, 0x3ec3, 0x432c, 0xb714, 0x4206, 0xc031, 0x44b5,
    0x2fc7, 0x4050, 0xbbda, 0xbe6c, 0x3b3a, 0xbd1d, 0xc194, 0x4457,
    0xb7e7, 0xb1ab, 0xb494, 0xb9f4, 0xbabc, 0x40a5, 0xb832, 0x39a4,
    0x382e, 0xb2fa, 0xbe5a, 0xba9f, 0x3f99, 0xbfc0, 0xbdf3, 0x43b0,
    0x3cab, 0x3849, 0xc57f, 0xb47e, 0xbde2, 0x3da2, 0x36ab, 0x38c6,
    0x3bd4, 0x37f2, 0xc2ed, 0xc15f, 0x4460, 0x3e4f, 0xc321, 0x3503,
    0xad6b, 0x38df, 0xbaaf, 0x38c0, 0xbd6f, 0x2c0d, 0x438b, 0x2f30,
    0xc418, 0xba8f, 0xba2d, 0xc1ab, 0xb6c3, 0xbe31, 0xbe8a, 0x3c6d,
    0x40c4, 0x3e70, 0x3a3d, 0xc32e, 0xbb97, 0xb193, 0xb4c4, 0x413b,
    0x3b73, 0x39bd, 0xb7b6, 0xbdd1, 0x4101, 0x3c1c, 0xbbf6, 0x38b0,
    0xba52, 0xb79c, 0xbe88, 0x4056, 0x3246, 0x39e5, 0x3f22, 0x4049,
    0xb898, 0xc435, 0xc183, 0x40aa, 0x3eb4, 0x302c, 0xbc4c, 0x38b5,
    0x40d2, 0xbb08, 0x4059, 0x41ff, 0x3abe, 0x39b9, 0xbbac, 0xc0b0,
    0xb9b9, 0xc0fe, 0x4131, 0x3ecb, 0xb61c, 0x3ea8, 0xb7e1, 0xc0c7,
    0xbc9d, 0xb666, 0x4153, 0x38bf, 0x3cca, 0x4285, 0x34a5, 0xac1f,
    0x42b3, 0x3d67, 0x3af1, 0x3579, 0x3b93, 0x3e11, 0xc277, 0x4063,
    0xbaeb, 0xb75a, 0xb4de, 0xb7c8, 0xc286, 0xba60, 0x3ed9, 0xb98d,
    0x2f72, 0xba55, 0x3373, 0x3e78, 0x3cf9, 0x385f, 0xb908, 0xc187,
    0x433a, 0x3ab6, 0x4292, 0x2254, 0x3588, 0xc007, 0x345a, 0x4045,
    0x3e62, 0x4145, 0x4003, 0x4340, 0xc0ca, 0x3113, 0x3a38, 0xc12d,
    0xbbc1, 0xb69b, 0xb9fe, 0xc2c8, 0xbc81, 0xc43b, 0x3e2d, 0x3a99,
    0x401b, 0x3e7d, 0x3ab5, 0x376a, 0xbfee, 0x339c, 0x440f, 0x3fac,
    0x3939, 0x3f60, 0x36f1, 0x3e46, 0xbc17, 0x4184, 0xbe64, 0xbcb2,
    0x4171, 0xb8a6, 0xbce8, 0xc095, 0xb0d5, 0x32a8, 0x385a, 0x3ecb,
    0xbc5e, 0xbb36, 0xbc5e, 0xc31a, 0xc277, 0x3f8a, 0xb5a2, 0x2b83,
    0xbed6, 0x2f69, 0x40e8, 0xc236, 0xc19c, 0xb991, 0xc178, 0x3a25,
    0x4443, 0xbea0, 0xc1e5, 0x3b46, 0xc35a, 0xab0c, 0xbd94, 0x3bc6,
    0x3ce5, 0xb8e0, 0xb304, 0xc337, 0xc2fb, 0xb92a, 0xbf1b, 0xbc6c,
    0xc4a5, 0x3d2f, 0x342f, 0x4131, 0xbf22, 0xb6fb, 0xc51d, 0x3584,
    0x3e53, 0xb637, 0x450e, 0x43ac, 0x3f70, 0x3873, 0xbc09, 0x41d8,
    0xb835, 0xc0fa, 0x3cfd, 0x443f, 0x41ff, 0xb771, 0x42bc, 0x4356,
    0xba27, 0xb4c5, 0xc2a8, 0x3ebb, 0xbc5d, 0xbd62, 0xbc24, 0x2d44,
    0x3e2e, 0xc11a, 0x3980, 0xabe4, 0xc0f0, 0x45bd, 0xba4e, 0xb56f,
    0xba65, 0xc158, 0xbf0b, 0x31d9, 0x430c, 0xbdd5, 0x4478, 0x3f7f,
    0x3e57, 0xc15e, 0x3ced, 0xb5a4, 0xb8d8, 0xb8b0, 0x41e5, 0xbefa,
    0xb3d3, 0x2fd7, 0xbc37, 0xc5e3, 0x448a, 0xc3d9, 0xc196, 0xbad4,
    0xb4e6, 0xc4d2, 0x41dc, 0x2c31, 0x3a72, 0xc186, 0xc63e, 0x3d48,
    0x3a19, 0x35a8, 0xbc30, 0xbbca, 0x4238, 0xbde8, 0x4196, 0x3df5,
    0xbde5, 0xaf6f, 0xc074, 0xb806, 0xbdf0, 0x4161, 0x3acc, 0x4325,
    0xaad1, 0xc1d9, 0x4329, 0xb52e, 0xbb54, 0xbe09, 0x40ce, 0x401d,
    0x3ec5, 0xc499, 0xb33f, 0x3606, 0xc4d1, 0x325d, 0xc0c5, 0x3686,
    0x3943, 0x40e9, 0x3ac1, 0xc1d6, 0xb81e, 0xb552, 0xc0b6, 0x3b91,
    0xbea6, 0xbcda, 0x4407, 0xc1bc, 0x34a6, 0x3b9a, 0xb6e8, 0x40df,
    0x4040, 0xc4e9, 0xbc9f, 0x2262, 0xbf1c, 0xbef1, 0xc419, 0xb8d5,
    0xc4c1, 0xc0d2, 0xbe90, 0xbaba, 0xb89d, 0xb40a, 0xc3bb, 0x40ee,
    0x3e27, 0x407e, 0xc1e6, 0xbdb9, 0xba1b, 0xb87e, 0x4177, 0x4350,
    0xc2f9, 0x3cfb, 0x2303, 0x373f, 0x4231, 0x3f78, 0xc334, 0xc465,
    0x458a, 0xbd83, 0x384a, 0xc0e0, 0xc061, 0x379a, 0xc554, 0x4189,
    0x388b, 0xbff6, 0xc04b, 0xbc85, 0x4083, 0xa425, 0x3ff0, 0xc330,
    0x3e30, 0xb4b6, 0xb965, 0x36d9, 0x37c3, 0x3a0f, 0x41b0, 0xbb0a,
    0x4095, 0x406a, 0x446a, 0x3c6d, 0xb65e, 0x409b, 0xbae7, 0xc10b,
    0x4288, 0xc1ec, 0x37da, 0xc298, 0xb6ef, 0xb8f9, 0xbff5, 0xb504,
    0x2a76, 0x3339, 0x35bb, 0x44cf, 0xb65b, 0xbe09, 0x32a8, 0xbd9f,
    0xb8d9, 0xb91b, 0x3d8e, 0xbd73, 0x37b4, 0x3a40, 0x41e6, 0xc001,
    0x2eb5, 0xc175, 0x4094, 0xbdbb, 0x3e77, 0x4078, 0xbd20, 0xaed3,
    0x455e, 0x42a9, 0xbe25, 0x445a, 0x3c9f, 0xc14a, 0x3c34, 0xb538,
    0xbd73, 0xb951, 0xb15a, 0x379c, 0xbf49, 0x36b2, 0xc00e, 0x38ef,
    0x3f68, 0x3f65, 0xc03c, 0x3904, 0x2eff, 0x365c, 0xbf04, 0xb11a,
    0x4407, 0x268c, 0xbfdc, 0x418c, 0xbc19, 0xba79, 0xbc31, 0x3ce0,
    0xbd7d, 0x3e59, 0xbc32, 0x418b, 0x39b0, 0x338c, 0xb7dd, 0xba3e,
    0xc1bb, 0xc113, 0xc251, 0x44e3, 0xbbec, 0xbf5a, 0x455d, 0xc572,
    0x3d31, 0xc478, 0x4623, 0x3c24, 0xc17d, 0x4017, 0xc031, 0xa561,
    0xb937, 0x37b6, 0x4626, 0x38e6, 0xb774, 0xb654, 0x3e53, 0xbad7,
    0x43cc, 0x361f, 0xbfdc, 0xc306, 0xbbe4, 0x4000, 0x3d84, 0x3a39,
    0x3e79, 0xbb9c, 0xb0a9, 0x3cc6, 0x3a98, 0xbdd8, 0x3c13, 0xc1da,
    0xb565, 0xbdd0, 0xbfae, 0xbc2d, 0xc0ac, 0xbe80, 0xb9dd, 0x2ffe,
    0xc287, 0xba36, 0xc2b0, 0xb570, 0xba55, 0xc1fb, 0x4227, 0xc30d,
    0x3d7f, 0xc34c, 0x416f, 0xba34, 0xbd41, 0xc137, 0x3a37, 0x391c,
    0x3535, 0x42ac, 0x3df6, 0xbf1b, 0xbd4e, 0xb7fc, 0x3bc5, 0x412e,
    0xc0c4, 0x3c5b, 0x3071, 0xbeb4, 0x4064, 0xc071, 0xc1cd, 0x3e41,
    0x3cf6, 0xbd0f, 0x41ab, 0x43d2, 0xb463, 0x42f6, 0xc217, 0x3e0a,
    0xb2a9, 0xbe4d, 0x41ba, 0xc4c2, 0xb821, 0xc4ff, 0x9c05, 0xbc3b,
    0x3faf, 0xc2d3, 0xb8eb, 0xb476, 0xbb0d, 0x4633, 0x3a11, 0x2bbd,
    0x40fc, 0xb146, 0x3ad6, 0x36cf, 0xc34e, 0x3bd8, 0x3b50, 0xc194,
    0xbfb2, 0x4200, 0xbe40, 0x39c9, 0x3c55, 0x3d11, 0xbdb1, 0xbaaf,
    0x445c, 0xbfb5, 0x2e7c, 0x3d3d, 0x388a, 0xc00f, 0x3ff0, 0x2cfa,
    0xc00b, 0xbc72, 0x3c98, 0x383f, 0xbbe0, 0x38ea, 0xbd36, 0x3d0a,
    0xb1ef, 0x3b47, 0x4424, 0x3bf6, 0xc055, 0x43d4, 0x38c5, 0xbe65,
    0x396b, 0x384d, 0x40e8, 0xbec7, 0x44bd, 0xbc93, 0x38d1, 0xb292,
    0xbabd, 0xbe28, 0x345a, 0x4106, 0x3d82, 0x3444, 0xb876, 0xb1da,
    0xb41c, 0xc25f, 0xbfac, 0x3418, 0xbda8, 0xc16c, 0xbb2c, 0x402b,
    0xc164, 0x3cad, 0x4168, 0xb8d7, 0xbb45, 0x2e5d, 0x3a84, 0xbeed,
    0x371f, 0xc090, 0xc019, 0x3d39, 0x3c68, 0x3781, 0xb709, 0x3f4e,
    0xc0ce, 0xbca5, 0xbc69, 0xbbab, 0x442b, 0x38e6, 0xbc49, 0xc097,
    0xbbbc, 0x41c2, 0x4021, 0xc2bd, 0x4317, 0x3ca0, 0x3e64, 0x4195,
    0xc146, 0x3e98, 0x3d30, 0x34c4, 0x307d, 0xbc08, 0xbe40, 0xb91b,
    0xb297, 0xb8ad, 0x4066, 0x4096, 0xbd68, 0xb78e, 0x3de6, 0x3631,
    0x4102, 0xba78, 0xc0dd, 0xbd81, 0xb4ad, 0xb7f0, 0x3d0b, 0x335c,
    0x40af, 0xc021, 0x41fb, 0x3da5, 0xba77, 0x3b55, 0xb521, 0x3129,
    0x2fbe, 0x3b6f, 0xb463, 0xb979, 0xb4db, 0xc271, 0x35ad, 0xbd38,
    0x41bf, 0xc0ca, 0x4296, 0xc6c8, 0xc245, 0xbea0, 0xc0e1, 0x3803,
    0xb406, 0x43b9, 0x36c8, 0x38ac, 0x3c6d, 0x38c1, 0x3167, 0xc4da,
    0xbdc2, 0x3f9b, 0x41fe, 0x3f33, 0xb8e6, 0x3d54, 0xbfc1, 0x3e7c,
    0xbcbf, 0x3d67, 0x2cf0, 0xb49e, 0x37d3, 0xbdbe, 0x3955, 0x3a5e,
    0xc019, 0xbffc, 0xc45d, 0x401c, 0xc41e, 0xc2c5, 0xc38f, 0x417e,
    0x4399, 0x37e9, 0x3d0a, 0xc1a1, 0x34c9, 0x32d7, 0x44db, 0x4418,
    0xc3a5, 0xbc70, 0x40e5, 0x3f17, 0x40a4, 0x3d79, 0x4048, 0xbb5d,
    0xbdd6, 0x429c, 0x3f9f, 0x3927, 0x4152, 0xb3f2, 0x3c88, 0xc224,
    0xc16f, 0x4443, 0x3fb6, 0xac06, 0xbd90, 0x3fa3, 0xbfb0, 0xc110,
    0x4068, 0x42c5, 0xc104, 0xbf47, 0x4336, 0x3cc5, 0xb47e, 0x39d0,
    0x360b, 0x30e2, 0xbb4d, 0x40fe, 0xbc81, 0xbdec, 0x3df9, 0xc3b0,
    0xb9db, 0x3da8, 0xbf10, 0xc472, 0xc263, 0x3d0c, 0xc448, 0x3d9f,
    0x426e, 0x3f8e, 0xc4ff, 0x4035, 0xbd87, 0x3977, 0xb7e6, 0xc494,
    0xc16c, 0x3e6f, 0x400c, 0xc326, 0x367d, 0xc42e, 0xb7d9, 0x3da4,
    0x3bb3, 0xb98e, 0xbd85, 0xbabd, 0x3e85, 0xbc2e, 0xc412, 0x3b55,
    0xbe84, 0xc586, 0xbe1f, 0xc091, 0x45fe, 0xc1e8, 0x4488, 0xb8cc,
    0x37f7, 0x39a2, 0xbeac, 0x32d7, 0x4514, 0x30e6, 0x40f5, 0x3af8,
    0xb9a4, 0xc054, 0xbf58, 0x3d38, 0x4328, 0x441f, 0x408a, 0x38b8,
    0x3cc9, 0x41aa, 0xc1b5, 0xc703, 0x383d, 0x38ea, 0xbca1, 0xb79b,
    0xbf65, 0x3bb7, 0xc064, 0xc4a1, 0xc31c, 0x35e2, 0x3520, 0x400c,
    0x42a7, 0x3158, 0xc2a9, 0x446f, 0x3d62, 0xba14, 0x3c58, 0xbda4,
    0xb4b1, 0x3e56, 0xbe8e, 0x40f7, 0x3a2f, 0x3ba9, 0x3d32, 0xb8b5,
    0xbe22, 0x4048, 0xbca6, 0x340e, 0xb5f3, 0x365c, 0xc1b5, 0x3d0d,
    0xc107, 0xbae4, 0x34cf, 0x3dd5, 0x4003, 0xbe06, 0x44a6, 0xba2d,
    0x2e4a, 0xb1da, 0x4446, 0xc243, 0x3d7c, 0x3af8, 0x3c2d, 0xbef6,
    0x41c3, 0xbd7a, 0x3092, 0xbd5a, 0x3f5c, 0x423f, 0x41f1, 0x3839,
    0xc0df, 0xbfaf, 0xc00a, 0xc1b7, 0xb409, 0xa6b1, 0xba96, 0x42b6,
    0xc18c, 0xc152, 0xbc1a, 0xb09a, 0x4053, 0x3ef9, 0x428e, 0x3d0c,
    0x3e33, 0xb833, 0x38b1, 0x2b0f, 0x3dc7, 0xbccc, 0xbb26, 0x3f25,
    0xba85, 0xbd12, 0xc270, 0x4221, 0xb370, 0xbe62, 0x33e4, 0x3964,
    0xb5b8, 0xb4f6, 0x3d1b, 0xb129, 0xc11a, 0xc633, 0x418d, 0xb84d,
    0xbd79, 0x3a48, 0x3c8e, 0x2902, 0xbe05, 0xbde2, 0x4369, 0x40e3,
    0xb1f3, 0xbeb0, 0xba8c, 0x3c9d, 0xc42a, 0x4240, 0x3c98, 0x36ea,
    0x3a2a, 0xb8c5, 0xc5a5, 0x4085, 0xae58, 0x2c1a, 0x3127, 0xc07b,
    0x3b9a, 0x3d50, 0x3ee0, 0x40f0, 0xbe9b, 0x3cdd, 0xc40d, 0xb560,
    0xc363, 0xb52e, 0x3e4d, 0xb59e, 0x40c5, 0xc180, 0x4184, 0x40ec,
    0xc164, 0x3e6d, 0x3ece, 0x354f, 0x469a, 0xc004, 0x4252, 0x4336,
    0x3c99, 0x3427, 0x448f, 0x3ccf, 0xc22a, 0x4148, 0xb316, 0x40b3,
    0xb815, 0xc045, 0xc46d, 0xb41a, 0x44a7, 0x44e5, 0xbcbd, 0xbc99,
    0x3ae9, 0xc1b8, 0xb84a, 0x4189, 0x3e08, 0x3919, 0x3566, 0x3dcd,
    0x3c39, 0x3fab, 0x3ea7, 0xb88b, 0x3c22, 0x3bc2, 0x43ab, 0xb090,
    0xc1c3, 0xb4ba, 0xc187, 0xc481, 0x4649, 0xbd45, 0x3c15, 0x3c7d,
    0x3b42, 0xbdf9, 0x4144, 0xb9d5, 0xac78, 0x4152, 0x3e4d, 0xc15d,
    0xbd6f, 0xb3b6, 0x3d12, 0x3a93, 0x4150, 0x3b04, 0xbc1a, 0x2bef,
    0x38a3, 0xc040, 0x4395, 0x4031, 0xbd15, 0xc02d, 0x3c8c, 0x410b,
    0xaf89, 0x3103, 0x4116, 0x35c9, 0x406f, 0x3c67, 0x41d7, 0xc0c6,
    0x3d30, 0xbd69, 0xbbfc, 0x4006, 0xbfb8, 0xc16c, 0x3acf, 0x4120,
    0x3e58, 0x44a1, 0xbcf9, 0x45a2, 0xc004, 0x3da3, 0xb03e, 0xb83f,
    0xbe1a, 0xb30b, 0xc22b, 0xc124, 0x427e, 0x3c23, 0x3b3b, 0xbc9a,
    0x3eaa, 0x257e, 0xc2fa, 0xbfa9, 0xc0a5, 0x420f, 0x38b0, 0x3819,
    0x43c5, 0x2e38, 0x3ca1, 0x4461, 0x386d, 0xbd79, 0x4131, 0xbcef,
    0xc2ae, 0xba73, 0xbe16, 0xbdd8, 0x4120, 0x3461, 0x41b2, 0xc17e,
    0x42db, 0x3012, 0xc138, 0x123f, 0xb95d, 0x42db, 0xbe4c, 0xb660,
    0x3ec1, 0x4433, 0x32ba, 0x4294, 0xbb02, 0xc0df, 0xb0d5, 0x39ee,
    0x40b4, 0xb7c8, 0xc2f2, 0xb816, 0x3b6a, 0x3b1c, 0x354c, 0xc555,
    0x39cb, 0x3828, 0x40a0, 0xbf1e, 0x4083, 0x3e4c, 0x3eb0, 0x3030,
    0xc4a6, 0xc344, 0x42cd, 0xb64f, 0x3c57, 0x3a06, 0xc471, 0x326c,
    0x406f, 0x3d59, 0xc3d7, 0x3c20, 0xc04a, 0xaf4f, 0xc069, 0x340d,
    0x41e4, 0x4132, 0x3c95, 0xba04, 0xb5f5, 0x400b, 0x3708, 0x40dc,
    0xb718, 0x3f0d, 0xb4da, 0xb86f, 0xbee5, 0xb446, 0xc381, 0xad1c,
    0xbf2b, 0xc034, 0x41b3, 0xbb1f, 0xbf25, 0x3125, 0xb99d, 0xb94b,
    0xb676, 0x44e1, 0x3589, 0xbb40, 0xb63c, 0x3e73, 0x3efb, 0x3d0a,
    0x442e, 0xb7d3, 0xbe0a, 0x3a46, 0x457a, 0xbd9e, 0x3c31, 0xc1db,
    0x3c83, 0x4087, 0xb91b, 0xbcd4, 0x400e, 0xb643, 0x4451, 0x40fc,
    0xc027, 0x3a58, 0xb088, 0xc49c, 0x3f90, 0xc1ae, 0x41aa, 0x3c0c,
    0x42fe, 0x4206, 0xbe4f, 0x3e4e, 0x3620, 0xbf72, 0xbe56, 0xc497,
    0xc272, 0xbed9, 0xc408, 0xc55f, 0x299e, 0xc33f, 0xc121, 0x40d3,
    0x3356, 0xb905, 0x446d, 0x3fcf, 0xb312, 0xb826, 0xb7bd, 0x4100,
    0x376c, 0xb43a, 0xc36f, 0xc0c5, 0xc2d7, 0x390f, 0x40d8, 0xc0a0,
    0xc22e, 0x3d66, 0x4420, 0x455c, 0xafaa, 0x3a1f, 0x44f3, 0xbb2a,
    0x4209, 0xbdd4, 0x40d2, 0xc0da, 0x36a3, 0xbc0f, 0xc4fa, 0xbb31,
    0x3dca, 0xb7cb, 0x3e00, 0x3a50, 0xbd9e, 0x4006, 0x31c2, 0x38db,
    0xbc0d, 0xbfb3, 0x23d1, 0x3b9e, 0x37d2, 0xbfce, 0x3878, 0xb8ff,
    0xbe61, 0xc237, 0x447f, 0xc1c6, 0xbc2b, 0xc60d, 0xbcb6, 0x3ab2,
    0x3c5d, 0xc18e, 0xc134, 0xb58e, 0xbc61, 0x3b62, 0x3963, 0x3951,
    0xbc3d, 0xc059, 0xc03c, 0x4148, 0x41c9, 0xc26d, 0xb7ba, 0xa1c3,
    0xc1c6, 0x438d, 0x3a2f, 0xc40e, 0xbfe1, 0xb88e, 0x4089, 0x3f65,
    0x41ee, 0xc03b, 0x3d00, 0xc0b2, 0x3d9b, 0x3fe4, 0xc396, 0xb506,
    0x4337, 0xaafb, 0xc363, 0x412c, 0x3c24, 0xc483, 0xb9a5, 0xc122,
    0xbc7b, 0xbd59, 0x2c51, 0x433e, 0x3db4, 0xbec7, 0x4033, 0xb7d9,
    0xb8d1, 0xb588, 0xb44f, 0xb7ce, 0x3103, 0xb327, 0x3a84, 0x3c48,
    0xc207, 0xb056, 0x3c8b, 0xba2e, 0xb429, 0xba75, 0xb609, 0x3989,
    0x31a8, 0xc09d, 0xb9ce, 0x3be9, 0x3df7, 0x3eef, 0xbee7, 0xc1d6,
    0xbd82, 0x3b03, 0x3c21, 0x422f, 0x9bf8, 0x4307, 0xbef1, 0x42c7,
    0xb833, 0xbf66, 0x3d49, 0x4197, 0xbf10, 0x4490, 0xb886, 0xbe95,
    0xbb28, 0x3a71, 0x437f, 0x4003, 0x3eb6, 0x3b0e, 0xc486, 0x3e17,
    0x3921, 0xbbb5, 0x3c8b, 0x42ed, 0xc0f6, 0x3f82, 0x402c, 0xba14,
    0xbbd5, 0x4156, 0xb6f4, 0x3c1e, 0xbe9b, 0xc10d, 0x41be, 0xc598,
    0x3889, 0x405e, 0xb5f7, 0xc126, 0x3ec6, 0xbc3e, 0x439a, 0x3ebb,
    0xbcfd, 0x35bb, 0x37be, 0xc0a9, 0xc4b6, 0x3d6b, 0xc683, 0xbf40,
    0x3698, 0x43e5, 0x3b10, 0x395a, 0x3ed3, 0x36ac, 0xc0ba, 0xc027,
    0xc491, 0x40ac, 0x3e64, 0x43ba, 0xbe24, 0xc015, 0x24a0, 0xc33d,
    0xc1fa, 0xc250, 0xc11c, 0xc293, 0xc4ab, 0xc2d7, 0xc04b, 0x3f27,
    0x40c0, 0xbb59, 0xc1ce, 0x3c6f, 0x40f6, 0xbdef, 0x42df, 0x3fee,
    0xb663, 0x659a, 0x4154, 0x415d, 0x3a4e, 0x3c95, 0xb516, 0xbd29,
    0x3f55, 0xbf77, 0xbf69, 0xbffa, 0x422b, 0xc089, 0xc366, 0xb811,
    0x4317, 0x3eb7, 0x3a9d, 0xb41c, 0x4407, 0x432e, 0x2f2e, 0xa96a,
    0xbde5, 0xbc8b, 0xc16f, 0x415c, 0xc39f, 0x41bc, 0xc1e5, 0xbc5f,
    0x4301, 0xbeec, 0x3f51, 0xc0a8, 0xc064, 0x4525, 0x425d, 0x3acd,
    0x34fc, 0x3ab3, 0x30bb, 0xb5df, 0xbe8f, 0x3e1c, 0xc2ed, 0x423a,
    0xbd12, 0x4117, 0x4331, 0xc221, 0xaaee, 0x415b, 0xbe34, 0xc1d9,
    0x44ca, 0x3c84, 0xc186, 0x3899, 0x44ec, 0xc508, 0x3cea, 0xb2d3,
    0xbc8e, 0x2628, 0x3d67, 0xc142, 0xbaa4, 0x2de5, 0x3745, 0x3b87,
    0x44c6, 0xc427, 0x3962, 0xb51a, 0x426e, 0xbcd3, 0x3845, 0xc2c0,
    0x420d, 0xc10e, 0xc162, 0xb626, 0xb29d, 0x3c5a, 0xc036, 0x3e9a,
    0xc2f9, 0xb855, 0xc14d, 0x38e9, 0xb476, 0x36a9, 0x35c9, 0xc49c,
    0x378e, 0xb741, 0x386b, 0xbe52, 0x39b8, 0xbd52, 0xbd4e, 0x40b1,
    0x3e1b, 0x42a5, 0x4229, 0xc6a7, 0xc463, 0x4270, 0xb145, 0x395d,
    0xc0c7, 0xc612, 0x4050, 0xc10f, 0xb7cd, 0x2f49, 0xb565, 0xb926,
    0x36f5, 0xb7ed, 0xc3dc, 0x4332, 0xc261, 0x4316, 0x307b, 0xbca7,
    0x3c7b, 0xb849, 0xbac9, 0xb4a8, 0xb893, 0xbb50, 0xb7f0, 0xb873,
    0xc0f4, 0xc180, 0x4155, 0xb1b3, 0x382a, 0x43e7, 0x4064, 0x3638,
    0xc23d, 0xbc33, 0xbc2f, 0x1eb9, 0xba24, 0xc173, 0xbc4e, 0xbd6f,
    0xb867, 0xbd48, 0x3cd8, 0xc117, 0x37c3, 0x39de, 0x2fb4, 0xbc4f,
    0x3bf4, 0x3e58, 0xbdf2, 0xc502, 0xc0e2, 0x4072, 0x1f18, 0x443b,
    0xc0b7, 0x443e, 0x43a7, 0xbe6d, 0x1f31, 0xba92, 0x42f9, 0xbd72,
    0x4214, 0x3c23, 0x3ea3, 0xb8a7, 0x3b52, 0xbe21, 0x4416, 0x3c96,
    0xbd5a, 0xbde8, 0x3fc1, 0x4063, 0xb8cf, 0x39a7, 0x3f06, 0x3b95,
    0xc32c, 0x2f3b, 0xbfc5, 0xb580, 0x4283, 0xaa2f, 0xbc4a, 0x431c,
    0xbd60, 0xbecb, 0xc043, 0x3f82, 0xb823, 0x4484, 0xc1c5, 0x3d3d,
    0x4174, 0xbd01, 0x3d28, 0xbc17, 0xc01f, 0xbcf7, 0x3a36, 0xa346,
    0x30da, 0x4212, 0x41ed, 0x3166, 0xc566, 0xbf85, 0xbd41, 0x3db7,
    0xbacc, 0x37a8, 0xbff8, 0x36b0, 0xc0f5, 0xc1ae, 0x3c52, 0x4016,
    0xbcf8, 0xc2fe, 0x3d13, 0x37fd, 0xb8d0, 0xc16e, 0x3f11, 0x451e,
    0x405e, 0x4563, 0x412b, 0x3e8c, 0xc459, 0x4271, 0xbbbb, 0xc4f5,
    0xb7a5, 0xc3dd, 0xaba7, 0x3f4a, 0x441e, 0xc0a4, 0xc102, 0x32e9,
    0x42ca, 0xbac8, 0xadb4, 0xbd2d, 0xbe49, 0xc053, 0xc005, 0xbcec,
    0xc6e0, 0x162f, 0xc088, 0xc1d1, 0xc3c4, 0x4063, 0x3b22, 0xbd5c,
    0x40d8, 0xb40d, 0xbb3f, 0xc174, 0xb382, 0xbd55, 0x2cdf, 0xb9fc,
    0xb722, 0x1fe0, 0x2d05, 0x3f82, 0x386d, 0xc408, 0x3f21, 0xbf0c,
    0x3759, 0x3154, 0xc2fe, 0x3acd, 0x3ff3, 0x3c03, 0x342e, 0x3c8c,
    0x37c8, 0xc25e, 0xc138, 0x3dd3, 0x4214, 0x4287, 0x359c, 0xc0f9,
    0xbe7c, 0x4107, 0x40ef, 0x3b7a, 0xc4de, 0xb8b2, 0x3ec0, 0xb9f8,
    0xb5a9, 0xbd09, 0xbe88, 0x2ddf, 0xc477, 0x3f88, 0x3a0a, 0x417a,
    0xbe82, 0x3b3f, 0x3c44, 0xbb5e, 0x3e2d, 0xbdcc, 0xc3f4, 0xb4f3,
    0xc35e, 0x3cde, 0x424c, 0x40e8, 0x30d4, 0xb5fb, 0xbe5e, 0xbfa2,
    0xc515, 0xb371, 0x42ef, 0xb8a7, 0x3da2, 0x3e6f, 0xbe80, 0x38c5,
    0xc189, 0x249c, 0x4572, 0xc575, 0x3117, 0x4164, 0x464c, 0xc01a,
    0xa3d5, 0x3cd9, 0x3bcb, 0xbc30, 0x3896, 0x45aa, 0x439e, 0x410d,
    0xbdad, 0xb29e, 0xbdeb, 0x3bc9, 0xbeea, 0x414f, 0x425a, 0x3e50,
    0xb96f, 0xb51a, 0x3e06, 0x425e, 0x2ed9, 0xb8bb, 0x4038, 0xbdb4,
    0xbed5, 0x420b, 0x419e, 0xb35b, 0x426f, 0x34c3, 0x39ea, 0x4261,
    0xb02f, 0xc1cf, 0x40ba, 0x2c3d, 0xbc94, 0xbbdd, 0x417f, 0xc440,
    0xbc6c, 0xc575, 0x3d20, 0xc475, 0xc085, 0x429e, 0x32ec, 0xbdbb,
    0x23ab, 0xc11e, 0x440d, 0x3bb6, 0x3e0e, 0xbf55, 0x4465, 0x28c5,
    0x4328, 0xbafc, 0xb933, 0x447b, 0xc46a, 0x4542, 0xbe3f, 0x3d11,
    0x434d, 0x42fd, 0xba1f, 0xb833, 0xb9b1, 0x42ce, 0x4266, 0x3f8f,
    0x401b, 0x401f, 0x2ca1, 0x4050, 0x3465, 0xbe4d, 0x40e4, 0x42a0,
    0x3b6a, 0xbcbc, 0x35ed, 0x41d0, 0x3812, 0x40bf, 0x3ccc, 0x3ca4,
    0xc47b, 0xc1ac, 0x41a5, 0xbb0c, 0x3ce4, 0xc465, 0x3b6c, 0x38d0,
    0x3abf, 0xbfd4, 0x3cd6, 0xc0df, 0x3fe5, 0xaef7, 0x40ef, 0x394b,
    0xc440, 0x3808, 0x3946, 0x3ee0, 0xc401, 0xbe93, 0x4644, 0x425a,
    0xc0e8, 0x34c8, 0xc04f, 0x39b1, 0xbf5f, 0xc52d, 0x3d90, 0x4006,
    0xb93d, 0xc0f0, 0xc07a, 0x386c, 0xbb4d, 0xc4c8, 0x411f, 0xbefa,
    0x40db, 0x3bbd, 0x3a24, 0xbe5e, 0xbbd8, 0xbb0b, 0xbd63, 0xbc89,
    0xb9e2, 0x413e, 0xc38b, 0x4194, 0xbeb2, 0x3063, 0x407c, 0x35d0,
    0x3aad, 0xaf85, 0x35e4, 0x41be, 0xc25e, 0xc1a1, 0x34f3, 0x2925,
    0xc00f, 0xc0f0, 0x3f20, 0x3a90, 0x3e73, 0x366b, 0xbe6c, 0x3e5f,
    0xbc72, 0x4090, 0x412e, 0xb6d7, 0x3ebc, 0x3c42, 0x43ac, 0x3d1b,
    0x3d3b, 0xc08c, 0xb822, 0xbb75, 0xb920, 0x3ec8, 0xb5dc, 0x3dc9,
    0x3125, 0xbe4e, 0x3787, 0xc30c, 0x40fc, 0xb4e2, 0x35cb, 0xb3ec,
    0x418d, 0xb51e, 0xc05a, 0xc5b1, 0x3f9f, 0x437c, 0xb2aa, 0x44de,
    0xba29, 0x3e4b, 0x3641, 0xc2aa, 0x372b, 0xb8f9, 0xb600, 0xc112,
    0x4007, 0x3216, 0xb92e, 0x4023, 0x45cf, 0x3c37, 0xc188, 0x3f6f,
    0xc1b2, 0xb91f, 0x404b, 0xb89a, 0x3c24, 0xc240, 0x4478, 0x38e8,
    0x38ce, 0x35b7, 0xba96, 0xc223, 0xb9bc, 0x4046, 0x3c5e, 0x3caa,
    0xbb09, 0xc16a, 0xc044, 0x46af, 0x34e7, 0xb938, 0x4034, 0x3d13,
    0x403e, 0x4440, 0x4271, 0xac1e, 0xc09a, 0xbd45, 0xc098, 0xc40c,
    0xc178, 0x41a0, 0x3fc2, 0xc05d, 0xba82, 0xba1a, 0x4174, 0x3b1e,
    0x3d8a, 0x342c, 0xbe3e, 0x3806, 0xc25f, 0x424b, 0xb51b, 0x3fbd,
    0x4596, 0x427f, 0xbf71, 0x3d82, 0x3fa4, 0x3086, 0xbb98, 0x3f0e,
    0xc12e, 0xc14e, 0xc1c0, 0xbe66, 0xbc2d, 0x3c68, 0x4163, 0xc0e2,
    0x3fba, 0xbd4e, 0x3e8e, 0x4258, 0xc11c, 0xc116, 0x4187, 0xbdc3,
    0x41e8, 0x4118, 0xbfa4, 0xb59b, 0xbcf8, 0xbde3, 0xc0b2, 0x40bd,
    0x3f73, 0x4330, 0xc088, 0x3cbe, 0xaca3, 0x3df7, 0xc211, 0x40f1,
    0x4080, 0xbfaa, 0xbe37, 0x425f, 0x40e8, 0xbd0d, 0x41f3, 0xbce0,
    0x3ee7, 0x407c, 0xbbe2, 0xc438, 0x3d6c, 0x3d67, 0x40c9, 0xb843,
    0xba5c, 0x3e08, 0xc18b, 0xc356, 0xc25d, 0x3ef5, 0x3627, 0x4361,
    0xc0cc, 0xb0ff, 0x3ca4, 0x40d0, 0xb564, 0xb967, 0x3fd8, 0x47ba,
    0xbc1c, 0xbbab, 0xbf8d, 0x4028, 0x458f, 0xb765, 0x4072, 0x3420,
    0x4304, 0x2e1d, 0x3067, 0xabca, 0xbf60, 0xc184, 0xc2ac, 0x44bc,
    0xb54b, 0x37b4, 0x3d50, 0x3966, 0x4108, 0x3004, 0xbc32, 0x3783,
    0x40fe, 0x4315, 0x3f43, 0x4174, 0x4466, 0xc2d2, 0x40c1, 0x3a58,
    0xaa53, 0xc208, 0x36af, 0xc1a9, 0x3eb9, 0x3d8e, 0xbc43, 0x2d53,
    0x3e0c, 0xba02, 0xc1e5, 0xc191, 0xc664, 0x3caa, 0xbdc7, 0x401e,
    0xb8e1, 0xb9ac, 0x36f3, 0xc34d, 0xc029, 0xbe97, 0x3440, 0xc221,
    0xc403, 0x420e, 0x3233, 0x417f, 0x42ce, 0x3d7e, 0x3373, 0x3f13,
    0x3c3b, 0xc4ec, 0x34c6, 0x339e, 0x3836, 0xb92e, 0x3d6d, 0x3380,
    0xbc64, 0xc33e, 0xb08f, 0x2bb7, 0xc008, 0xc34d, 0x36c9, 0x3909,
    0xbf9f, 0xbd8f, 0xbc3b, 0x3f30, 0xc5fb, 0xbe04, 0xbf11, 0x36c2,
    0x38dc, 0xc4bd, 0xb84c, 0x35d5, 0x4001, 0x3ed1, 0x410a, 0x3fef,
    0xc484, 0xc002, 0xbcfa, 0xa82f, 0xb2d2, 0x4571, 0x3ea6, 0xc0ee,
    0x3ff8, 0xc4f0, 0xbb62, 0x381b, 0x404a, 0xb303, 0x459b, 0x426d,
    0xc10b, 0xba35, 0xc085, 0xc567, 0x3ecd, 0x2ff6, 0xbf8c, 0x4241,
    0x3ae8, 0x3a0a, 0x3dca, 0xb792, 0xbdc6, 0x3b66, 0x40b8, 0x3acf,
    0x427a, 0x3972, 0xc0eb, 0x4458, 0x4018, 0x22ce, 0x3ac0, 0xba5a,
    0x4128, 0x38e2, 0x3783, 0xb1a6, 0x3c18, 0x4177, 0x3a84, 0x3a2b,
    0xbabc, 0xbf4f, 0x3c74, 0xc43d, 0x3889, 0x384c, 0x4004, 0x2abb,
    0xc57d, 0xb60a, 0xc1cc, 0x3563, 0x3f1c, 0xb916, 0xb8c3, 0xc364,
    0x3a6c, 0x411e, 0x382f, 0xb4ec, 0x3cb3, 0xbd31, 0x4147, 0xc032,
    0xc43b, 0x3ced, 0xc351, 0x4549, 0xc3f1, 0xc011, 0x41e7, 0x3e81,
    0xb877, 0x41a5, 0x3894, 0x4473, 0xc03f, 0x30dc, 0xbce8, 0xc07e,
    0x40ca, 0x3d34, 0x3a8d, 0xbddc, 0x4427, 0x442f, 0x3ad4, 0x3afe,
    0x3f11, 0x3dfb, 0x412f, 0xba59, 0x44b8, 0xbe1e, 0xc394, 0x38d8,
    0x419b, 0xc470, 0x3c3a, 0xb8e1, 0xbf95, 0x3e45, 0x408f, 0xc147,
    0xbb8f, 0xc414, 0x3c8f, 0x40d4, 0xb7d9, 0xb20d, 0x429a, 0xc052,
    0xc26d, 0x4271, 0x3f89, 0x4197, 0xbcd9, 0xc3e0, 0x26ef, 0xbc29,
    0x3d32, 0xaf72, 0x3ba9, 0x3a31, 0x3476, 0x2bb7, 0x3d6c, 0xb95e,
    0x3ebe, 0xb9ed, 0xb912, 0x4085, 0xbcd6, 0xbdf1, 0xb941, 0x421c,
    0xbe88, 0xb30c, 0x39b9, 0xb869, 0x3ddf, 0xa650, 0xc31b, 0xbcad,
    0x4116, 0xbe2b, 0x43a3, 0x3ee9, 0xbd76, 0x3b55, 0x32c0, 0xc50a,
    0xbbd0, 0x4244, 0xa66b, 0x3df1, 0x433e, 0x40fd, 0xc25c, 0x461b,
    0xc5da, 0x40d3, 0x3db9, 0x43ee, 0x3f67, 0xc2f7, 0x3ae0, 0x44ab,
    0xc090, 0xbe33, 0xa020, 0xbc68, 0x3cf8, 0xbf8a, 0x3de2, 0x4050,
    0xc1b8, 0x3297, 0xbd62, 0x417b, 0xb8e1, 0xb8f1, 0x3ce0, 0xc24e,
    0x2631, 0xc100, 0xc5b2, 0xc56b, 0xbc72, 0xc4b5, 0x4251, 0x443c,
    0xbd45, 0xc08c, 0xb8c3, 0x43ed, 0xbfbd, 0x3a76, 0xbac9, 0x4083,
    0x4266, 0x32c6, 0xb403, 0xc09d, 0x409a, 0xb15d, 0x35bb, 0x4197,
    0xbf29, 0xc525, 0x3ca5, 0xb6db, 0xbd03, 0xc3e6, 0x3890, 0xb8cb,
    0x3fb9, 0xb9f4, 0x3b59, 0x3de6, 0xc43f, 0xc07f, 0xbd3d, 0x41c9,
    0x42fc, 0x351f, 0xbf43, 0xacf3, 0x2e72, 0xc333, 0xb980, 0xbbe4,
    0xc2c4, 0xc2e4, 0x3f1f, 0xc0d1, 0x3f26, 0xc329, 0x4119, 0x464c
    };

static const uint16_t ref_cfft_noisy_4096[8192] = {
    0x441e, 0x0, 0x4119, 0xc64c, 0x3f26, 0x4329, 0x3f1f, 0x40d1,
    0xc2c4, 0x42e4, 0xb980, 0x3be4, 0x2e72, 0x4333, 0xbf43, 0x2cf3,
    0x42fc, 0xb51f, 0xbd3d, 0xc1c9, 0xc43f, 0x407f, 0x3b59, 0xbde6,
    0x3fb9, 0x39f4, 0x3890, 0x38cb, 0xbd03, 0x43e6, 0x3ca5, 0x36db,
    0xbf29, 0x4525, 0x35bb, 0xc197, 0x409a, 0x315d, 0xb403, 0x409d,
    0x4266, 0xb2c6, 0xbac9, 0xc083, 0xbfbd, 0xba76, 0xb8c3, 0xc3ed,
    0xbd45, 0x408c, 0x4251, 0xc43c, 0xbc72, 0x44b5, 0xc5b2, 0x456b,
    0x2631, 0x4100, 0x3ce0, 0x424e, 0xb8e1, 0x38f1, 0xbd62, 0xc17b,
    0xc1b8, 0xb297, 0x3de2, 0xc050, 0x3cf8, 0x3f8a, 0xa020, 0x3c68,
    0xc090, 0x3e33, 0x3ae0, 0xc4ab, 0x3f67, 0x42f7, 0x3db9, 0xc3ee,
    0xc5da, 0xc0d3, 0xc25c, 0xc61b, 0x433e, 0xc0fd, 0xa66b, 0xbdf1,
    0xbbd0, 0xc244, 0x32c0, 0x450a, 0xbd76, 0xbb55, 0x43a3, 0xbee9,
    0x4116, 0x3e2b, 0xc31b, 0x3cad, 0x3ddf, 0x2650, 0x39b9, 0x3869,
    0xbe88, 0x330c, 0xb941, 0xc21c, 0xbcd6, 0x3df1, 0xb912, 0xc085,
    0x3ebe, 0x39ed, 0x3d6c, 0x395e, 0x3476, 0xabb7, 0x3ba9, 0xba31,
    0x3d32, 0x2f72, 0x26ef, 0x3c29, 0xbcd9, 0x43e0, 0x3f89, 0xc197,
    0xc26d, 0xc271, 0x429a, 0x4052, 0xb7d9, 0x320d, 0x3c8f, 0xc0d4,
    0xbb8f, 0x4414, 0x408f, 0x4147, 0xbf95, 0xbe45, 0x3c3a, 0x38e1,
    0x419b, 0x4470, 0xc394, 0xb8d8, 0x44b8, 0x3e1e, 0x412f, 0x3a59,
    0x3f11, 0xbdfb, 0x3ad4, 0xbafe, 0x4427, 0xc42f, 0x3a8d, 0x3ddc,
    0x40ca, 0xbd34, 0xbce8, 0x407e, 0xc03f, 0xb0dc, 0x3894, 0xc473,
    0xb877, 0xc1a5, 0x41e7, 0xbe81, 0xc3f1, 0x4011, 0xc351, 0xc549,
    0xc43b, 0xbced, 0x4147, 0x4032, 0x3cb3, 0x3d31, 0x382f, 0x34ec,
    0x3a6c, 0xc11e, 0xb8c3, 0x4364, 0x3f1c, 0x3916, 0xc1cc, 0xb563,
    0xc57d, 0x360a, 0x4004, 0xaabb, 0x3889, 0xb84c, 0x3c74, 0x443d,
    0xbabc, 0x3f4f, 0x3a84, 0xba2b, 0x3c18, 0xc177, 0x3783, 0x31a6,
    0x4128, 0xb8e2, 0x3ac0, 0x3a5a, 0x4018, 0xa2ce, 0xc0eb, 0xc458,
    0x427a, 0xb972, 0x40b8, 0xbacf, 0xbdc6, 0xbb66, 0x3dca, 0x3792,
    0x3ae8, 0xba0a, 0xbf8c, 0xc241, 0x3ecd, 0xaff6, 0xc085, 0x4567,
    0xc10b, 0x3a35, 0x459b, 0xc26d, 0x404a, 0x3303, 0xbb62, 0xb81b,
    0x3ff8, 0x44f0, 0x3ea6, 0x40ee, 0xb2d2, 0xc571, 0xbcfa, 0x282f,
    0xc484, 0x4002, 0x410a, 0xbfef, 0x4001, 0xbed1, 0xb84c, 0xb5d5,
    0x38dc, 0x44bd, 0xbf11, 0xb6c2, 0xc5fb, 0x3e04, 0xbc3b, 0xbf30,
    0xbf9f, 0x3d8f, 0x36c9, 0xb909, 0xc008, 0x434d, 0xb08f, 0xabb7,
    0xbc64, 0x433e, 0x3d6d, 0xb380, 0x3836, 0x392e, 0x34c6, 0xb39e,
    0x3c3b, 0x44ec, 0x3373, 0xbf13, 0x42ce, 0xbd7e, 0x3233, 0xc17f,
    0xc403, 0xc20e, 0x3440, 0x4221, 0xc029, 0x3e97, 0x36f3, 0x434d,
    0xb8e1, 0x39ac, 0xbdc7, 0xc01e, 0xc664, 0xbcaa, 0xc1e5, 0x4191,
    0x3e0c, 0x3a02, 0xbc43, 0xad53, 0x3eb9, 0xbd8e, 0x36af, 0x41a9,
    0xaa53, 0x4208, 0x40c1, 0xba58, 0x4466, 0x42d2, 0x3f43, 0xc174,
    0x40fe, 0xc315, 0xbc32, 0xb783, 0x4108, 0xb004, 0x3d50, 0xb966,
    0xb54b, 0xb7b4, 0xc2ac, 0xc4bc, 0xbf60, 0x4184, 0x3067, 0x2bca,
    0x4304, 0xae1d, 0x4072, 0xb420, 0x458f, 0x3765, 0xbf8d, 0xc028,
    0xbc1c, 0x3bab, 0x3fd8, 0xc7ba, 0xb564, 0x3967, 0x3ca4, 0xc0d0,
    0xc0cc, 0x30ff, 0x3627, 0xc361, 0xc25d, 0xbef5, 0xc18b, 0x4356,
    0xba5c, 0xbe08, 0x40c9, 0x3843, 0x3d6c, 0xbd67, 0xbbe2, 0x4438,
    0x3ee7, 0xc07c, 0x41f3, 0x3ce0, 0x40e8, 0x3d0d, 0xbe37, 0xc25f,
    0x4080, 0x3faa, 0xc211, 0xc0f1, 0xaca3, 0xbdf7, 0xc088, 0xbcbe,
    0x3f73, 0xc330, 0xc0b2, 0xc0bd, 0xbcf8, 0x3de3, 0xbfa4, 0x359b,
    0x41e8, 0xc118, 0x4187, 0x3dc3, 0xc11c, 0x4116, 0x3e8e, 0xc258,
    0x3fba, 0x3d4e, 0x4163, 0x40e2, 0xbc2d, 0xbc68, 0xc1c0, 0x3e66,
    0xc12e, 0x414e, 0xbb98, 0xbf0e, 0x3fa4, 0xb086, 0xbf71, 0xbd82,
    0x4596, 0xc27f, 0xb51b, 0xbfbd, 0xc25f, 0xc24b, 0xbe3e, 0xb806,
    0x3d8a, 0xb42c, 0x4174, 0xbb1e, 0xba82, 0x3a1a, 0x3fc2, 0x405d,
    0xc178, 0xc1a0, 0xc098, 0x440c, 0xc09a, 0x3d45, 0x4271, 0x2c1e,
    0x403e, 0xc440, 0x4034, 0xbd13, 0x34e7, 0x3938, 0xc044, 0xc6af,
    0xbb09, 0x416a, 0x3c5e, 0xbcaa, 0xb9bc, 0xc046, 0xba96, 0x4223,
    0x38ce, 0xb5b7, 0x4478, 0xb8e8, 0x3c24, 0x4240, 0x404b, 0x389a,
    0xc1b2, 0x391f, 0xc188, 0xbf6f, 0x45cf, 0xbc37, 0xb92e, 0xc023,
    0x4007, 0xb216, 0xb600, 0x4112, 0x372b, 0x38f9, 0x3641, 0x42aa,
    0xba29, 0xbe4b, 0xb2aa, 0xc4de, 0x3f9f, 0xc37c, 0xc05a, 0x45b1,
    0x418d, 0x351e, 0x35cb, 0x33ec, 0x40fc, 0x34e2, 0x3787, 0x430c,
    0x3125, 0x3e4e, 0xb5dc, 0xbdc9, 0xb920, 0xbec8, 0xb822, 0x3b75,
    0x3d3b, 0x408c, 0x43ac, 0xbd1b, 0x3ebc, 0xbc42, 0x412e, 0x36d7,
    0xbc72, 0xc090, 0xbe6c, 0xbe5f, 0x3e73, 0xb66b, 0x3f20, 0xba90,
    0xc00f, 0x40f0, 0x34f3, 0xa925, 0xc25e, 0x41a1, 0x35e4, 0xc1be,
    0x3aad, 0x2f85, 0x407c, 0xb5d0, 0xbeb2, 0xb063, 0xc38b, 0xc194,
    0xb9e2, 0xc13e, 0xbd63, 0x3c89, 0xbbd8, 0x3b0b, 0x3a24, 0x3e5e,
    0x40db, 0xbbbd, 0x411f, 0x3efa, 0xbb4d, 0x44c8, 0xc07a, 0xb86c,
    0xb93d, 0x40f0, 0x3d90, 0xc006, 0xbf5f, 0x452d, 0xc04f, 0xb9b1,
    0xc0e8, 0xb4c8, 0x4644, 0xc25a, 0xc401, 0x3e93, 0x3946, 0xbee0,
    0xc440, 0xb808, 0x40ef, 0xb94b, 0x3fe5, 0x2ef7, 0x3cd6, 0x40df,
    0x3abf, 0x3fd4, 0x3b6c, 0xb8d0, 0x3ce4, 0x4465, 0x41a5, 0x3b0c,
    0xc47b, 0x41ac, 0x3ccc, 0xbca4, 0x3812, 0xc0bf, 0x35ed, 0xc1d0,
    0x3b6a, 0x3cbc, 0x40e4, 0xc2a0, 0x3465, 0x3e4d, 0x2ca1, 0xc050,
    0x401b, 0xc01f, 0x4266, 0xbf8f, 0xb9b1, 0xc2ce, 0xba1f, 0x3833,
    0x434d, 0xc2fd, 0xbe3f, 0xbd11, 0xc46a, 0xc542, 0xb933, 0xc47b,
    0x4328, 0x3afc, 0x4465, 0xa8c5, 0x3e0e, 0x3f55, 0x440d, 0xbbb6,
    0x23ab, 0x411e, 0x32ec, 0x3dbb, 0xc085, 0xc29e, 0x3d20, 0x4475,
    0xbc6c, 0x4575, 0x417f, 0x4440, 0xbc94, 0x3bdd, 0x40ba, 0xac3d,
    0xb02f, 0x41cf, 0x39ea, 0xc261, 0x426f, 0xb4c3, 0x419e, 0x335b,
    0xbed5, 0xc20b, 0x4038, 0x3db4, 0x2ed9, 0x38bb, 0x3e06, 0xc25e,
    0xb96f, 0x351a, 0x425a, 0xbe50, 0xbeea, 0xc14f, 0xbdeb, 0xbbc9,
    0xbdad, 0x329e, 0x439e, 0xc10d, 0x3896, 0xc5aa, 0x3bcb, 0x3c30,
    0xa3d5, 0xbcd9, 0x464c, 0x401a, 0x3117, 0xc164, 0x4572, 0x4575,
    0xc189, 0xa49c, 0xbe80, 0xb8c5, 0x3da2, 0xbe6f, 0x42ef, 0x38a7,
    0xc515, 0x3371, 0xbe5e, 0x3fa2, 0x30d4, 0x35fb, 0x424c, 0xc0e8,
    0xc35e, 0xbcde, 0xc3f4, 0x34f3, 0x3e2d, 0x3dcc, 0x3c44, 0x3b5e,
    0xbe82, 0xbb3f, 0x3a0a, 0xc17a, 0xc477, 0xbf88, 0xbe88, 0xaddf,
    0xb5a9, 0x3d09, 0x3ec0, 0x39f8, 0xc4de, 0x38b2, 0x40ef, 0xbb7a,
    0xbe7c, 0xc107, 0x359c, 0x40f9, 0x4214, 0xc287, 0xc138, 0xbdd3,
    0x37c8, 0x425e, 0x342e, 0xbc8c, 0x3ff3, 0xbc03, 0xc2fe, 0xbacd,
    0x3759, 0xb154, 0x3f21, 0x3f0c, 0x386d, 0x4408, 0x2d05, 0xbf82,
    0xb722, 0x9fe0, 0x2cdf, 0x39fc, 0xb382, 0x3d55, 0xbb3f, 0x4174,
    0x40d8, 0x340d, 0x3b22, 0x3d5c, 0xc3c4, 0xc063, 0xc088, 0x41d1,
    0xc6e0, 0x962f, 0xc005, 0x3cec, 0xbe49, 0x4053, 0xadb4, 0x3d2d,
    0x42ca, 0x3ac8, 0xc102, 0xb2e9, 0x441e, 0x40a4, 0xaba7, 0xbf4a,
    0xb7a5, 0x43dd, 0xbbbb, 0x44f5, 0xc459, 0xc271, 0x412b, 0xbe8c,
    0x405e, 0xc563, 0x3f11, 0xc51e, 0xb8d0, 0x416e, 0x3d13, 0xb7fd,
    0xbcf8, 0x42fe, 0x3c52, 0xc016, 0xc0f5, 0x41ae, 0xbff8, 0xb6b0,
    0xbacc, 0xb7a8, 0xbd41, 0xbdb7, 0xc566, 0x3f85, 0x41ed, 0xb166,
    0x30da, 0xc212, 0x3a36, 0x2346, 0xc01f, 0x3cf7, 0x3d28, 0x3c17,
    0x4174, 0x3d01, 0xc1c5, 0xbd3d, 0xb823, 0xc484, 0xc043, 0xbf82,
    0xbd60, 0x3ecb, 0xbc4a, 0xc31c, 0x4283, 0x2a2f, 0xbfc5, 0x3580,
    0xc32c, 0xaf3b, 0x3f06, 0xbb95, 0xb8cf, 0xb9a7, 0x3fc1, 0xc063,
    0xbd5a, 0x3de8, 0x4416, 0xbc96, 0x3b52, 0x3e21, 0x3ea3, 0x38a7,
    0x4214, 0xbc23, 0x42f9, 0x3d72, 0x1f31, 0x3a92, 0x43a7, 0x3e6d,
    0xc0b7, 0xc43e, 0x1f18, 0xc43b, 0xc0e2, 0xc072, 0xbdf2, 0x4502,
    0x3bf4, 0xbe58, 0x2fb4, 0x3c4f, 0x37c3, 0xb9de, 0x3cd8, 0x4117,
    0xb867, 0x3d48, 0xbc4e, 0x3d6f, 0xba24, 0x4173, 0xbc2f, 0x9eb9,
    0xc23d, 0x3c33, 0x4064, 0xb638, 0x382a, 0xc3e7, 0x4155, 0x31b3,
    0xc0f4, 0x4180, 0xb7f0, 0x3873, 0xb893, 0x3b50, 0xbac9, 0x34a8,
    0x3c7b, 0x3849, 0x307b, 0x3ca7, 0xc261, 0xc316, 0xc3dc, 0xc332,
    0x36f5, 0x37ed, 0xb565, 0x3926, 0xb7cd, 0xaf49, 0x4050, 0x410f,
    0xc0c7, 0x4612, 0xb145, 0xb95d, 0xc463, 0xc270, 0x4229, 0x46a7,
    0x3e1b, 0xc2a5, 0xbd4e, 0xc0b1, 0x39b8, 0x3d52, 0x386b, 0x3e52,
    0x378e, 0x3741, 0x35c9, 0x449c, 0xb476, 0xb6a9, 0xc14d, 0xb8e9,
    0xc2f9, 0x3855, 0xc036, 0xbe9a, 0xb29d, 0xbc5a, 0xc162, 0x3626,
    0x420d, 0x410e, 0x3845, 0x42c0, 0x426e, 0x3cd3, 0x3962, 0x351a,
    0x44c6, 0x4427, 0x3745, 0xbb87, 0xbaa4, 0xade5, 0x3d67, 0x4142,
    0xbc8e, 0xa628, 0x3cea, 0x32d3, 0x44ec, 0x4508, 0xc186, 0xb899,
    0x44ca, 0xbc84, 0xbe34, 0x41d9, 0xaaee, 0xc15b, 0x4331, 0x4221,
    0xbd12, 0xc117, 0xc2ed, 0xc23a, 0xbe8f, 0xbe1c, 0x30bb, 0x35df,
    0x34fc, 0xbab3, 0x425d, 0xbacd, 0xc064, 0xc525, 0x3f51, 0x40a8,
    0x4301, 0x3eec, 0xc1e5, 0x3c5f, 0xc39f, 0xc1bc, 0xc16f, 0xc15c,
    0xbde5, 0x3c8b, 0x2f2e, 0x296a, 0x4407, 0xc32e, 0x3a9d, 0x341c,
    0x4317, 0xbeb7, 0xc366, 0x3811, 0x422b, 0x4089, 0xbf69, 0x3ffa,
    0x3f55, 0x3f77, 0xb516, 0x3d29, 0x3a4e, 0xbc95, 0x4154, 0xc15d,
    0xb663, 0xe59a, 0x42df, 0xbfee, 0x40f6, 0x3def, 0xc1ce, 0xbc6f,
    0x40c0, 0x3b59, 0xc04b, 0xbf27, 0xc4ab, 0x42d7, 0xc11c, 0x4293,
    0xc1fa, 0x4250, 0x24a0, 0x433d, 0xbe24, 0x4015, 0x3e64, 0xc3ba,
    0xc491, 0xc0ac, 0xc0ba, 0x4027, 0x3ed3, 0xb6ac, 0x3b10, 0xb95a,
    0x3698, 0xc3e5, 0xc683, 0x3f40, 0xc4b6, 0xbd6b, 0x37be, 0x40a9,
    0xbcfd, 0xb5bb, 0x439a, 0xbebb, 0x3ec6, 0x3c3e, 0xb5f7, 0x4126,
    0x3889, 0xc05e, 0x41be, 0x4598, 0xbe9b, 0x410d, 0xb6f4, 0xbc1e,
    0xbbd5, 0xc156, 0x402c, 0x3a14, 0xc0f6, 0xbf82, 0x3c8b, 0xc2ed,
    0x3921, 0x3bb5, 0xc486, 0xbe17, 0x3eb6, 0xbb0e, 0x437f, 0xc003,
    0xbb28, 0xba71, 0xb886, 0x3e95, 0xbf10, 0xc490, 0x3d49, 0xc197,
    0xb833, 0x3f66, 0xbef1, 0xc2c7, 0x9bf8, 0xc307, 0x3c21, 0xc22f,
    0xbd82, 0xbb03, 0xbee7, 0x41d6, 0x3df7, 0xbeef, 0xb9ce, 0xbbe9,
    0x31a8, 0x409d, 0xb609, 0xb989, 0xb429, 0x3a75, 0x3c8b, 0x3a2e,
    0xc207, 0x3056, 0x3a84, 0xbc48, 0x3103, 0x3327, 0xb44f, 0x37ce,
    0xb8d1, 0x3588, 0x4033, 0x37d9, 0x3db4, 0x3ec7, 0x2c51, 0xc33e,
    0xbc7b, 0x3d59, 0xb9a5, 0x4122, 0x3c24, 0x4483, 0xc363, 0xc12c,
    0x4337, 0x2afb, 0xc396, 0x3506, 0x3d9b, 0xbfe4, 0x3d00, 0x40b2,
    0x41ee, 0x403b, 0x4089, 0xbf65, 0xbfe1, 0x388e, 0x3a2f, 0x440e,
    0xc1c6, 0xc38d, 0xb7ba, 0x21c3, 0x41c9, 0x426d, 0xc03c, 0xc148,
    0xbc3d, 0x4059, 0x3963, 0xb951, 0xbc61, 0xbb62, 0xc134, 0x358e,
    0x3c5d, 0x418e, 0xbcb6, 0xbab2, 0xbc2b, 0x460d, 0x447f, 0x41c6,
    0xbe61, 0x4237, 0x3878, 0x38ff, 0x37d2, 0x3fce, 0x23d1, 0xbb9e,
    0xbc0d, 0x3fb3, 0x31c2, 0xb8db, 0xbd9e, 0xc006, 0x3e00, 0xba50,
    0x3dca, 0x37cb, 0xc4fa, 0x3b31, 0x36a3, 0x3c0f, 0x40d2, 0x40da,
    0x4209, 0x3dd4, 0x44f3, 0x3b2a, 0xafaa, 0xba1f, 0x4420, 0xc55c,
    0xc22e, 0xbd66, 0x40d8, 0x40a0, 0xc2d7, 0xb90f, 0xc36f, 0x40c5,
    0x376c, 0x343a, 0xb7bd, 0xc100, 0xb312, 0x3826, 0x446d, 0xbfcf,
    0x3356, 0x3905, 0xc121, 0xc0d3, 0x299e, 0x433f, 0xc408, 0x455f,
    0xc272, 0x3ed9, 0xbe56, 0x4497, 0x3620, 0x3f72, 0xbe4f, 0xbe4e,
    0x42fe, 0xc206, 0x41aa, 0xbc0c, 0x3f90, 0x41ae, 0xb088, 0x449c,
    0xc027, 0xba58, 0x4451, 0xc0fc, 0x400e, 0x3643, 0xb91b, 0x3cd4,
    0x3c83, 0xc087, 0x3c31, 0x41db, 0x457a, 0x3d9e, 0xbe0a, 0xba46,
    0x442e, 0x37d3, 0x3efb, 0xbd0a, 0xb63c, 0xbe73, 0x3589, 0x3b40,
    0xb676, 0xc4e1, 0xb99d, 0x394b, 0xbf25, 0xb125, 0x41b3, 0x3b1f,
    0xbf2b, 0x4034, 0xc381, 0x2d1c, 0xbee5, 0x3446, 0xb4da, 0x386f,
    0xb718, 0xbf0d, 0x3708, 0xc0dc, 0xb5f5, 0xc00b, 0x3c95, 0x3a04,
    0x41e4, 0xc132, 0xc069, 0xb40d, 0xc04a, 0x2f4f, 0xc3d7, 0xbc20,
    0x406f, 0xbd59, 0xc471, 0xb26c, 0x3c57, 0xba06, 0x42cd, 0x364f,
    0xc4a6, 0x4344, 0x3eb0, 0xb030, 0x4083, 0xbe4c, 0x40a0, 0x3f1e,
    0x39cb, 0xb828, 0x354c, 0x4555, 0x3b6a, 0xbb1c, 0xc2f2, 0x3816,
    0x40b4, 0x37c8, 0xb0d5, 0xb9ee, 0xbb02, 0x40df, 0x32ba, 0xc294,
    0x3ec1, 0xc433, 0xbe4c, 0x3660, 0xb95d, 0xc2db, 0xc138, 0x923f,
    0x42db, 0xb012, 0x41b2, 0x417e, 0x4120, 0xb461, 0xbe16, 0x3dd8,
    0xc2ae, 0x3a73, 0x4131, 0x3cef, 0x386d, 0x3d79, 0x3ca1, 0xc461,
    0x43c5, 0xae38, 0x38b0, 0xb819, 0xc0a5, 0xc20f, 0xc2fa, 0x3fa9,
    0x3eaa, 0xa57e, 0x3b3b, 0x3c9a, 0x427e, 0xbc23, 0xc22b, 0x4124,
    0xbe1a, 0x330b, 0xb03e, 0x383f, 0xc004, 0xbda3, 0xbcf9, 0xc5a2,
    0x3e58, 0xc4a1, 0x3acf, 0xc120, 0xbfb8, 0x416c, 0xbbfc, 0xc006,
    0x3d30, 0x3d69, 0x41d7, 0x40c6, 0x406f, 0xbc67, 0x4116, 0xb5c9,
    0xaf89, 0xb103, 0x3c8c, 0xc10b, 0xbd15, 0x402d, 0x4395, 0xc031,
    0x38a3, 0x4040, 0xbc1a, 0xabef, 0x4150, 0xbb04, 0x3d12, 0xba93,
    0xbd6f, 0x33b6, 0x3e4d, 0x415d, 0xac78, 0xc152, 0x4144, 0x39d5,
    0x3b42, 0x3df9, 0x3c15, 0xbc7d, 0x4649, 0x3d45, 0xc187, 0x4481,
    0xc1c3, 0x34ba, 0x43ab, 0x3090, 0x3c22, 0xbbc2, 0x3ea7, 0x388b,
    0x3c39, 0xbfab, 0x3566, 0xbdcd, 0x3e08, 0xb919, 0xb84a, 0xc189,
    0x3ae9, 0x41b8, 0xbcbd, 0x3c99, 0x44a7, 0xc4e5, 0xc46d, 0x341a,
    0xb815, 0x4045, 0xb316, 0xc0b3, 0xc22a, 0xc148, 0x448f, 0xbccf,
    0x3c99, 0xb427, 0x4252, 0xc336, 0x469a, 0x4004, 0x3ece, 0xb54f,
    0xc164, 0xbe6d, 0x4184, 0xc0ec, 0x40c5, 0x4180, 0x3e4d, 0x359e,
    0xc363, 0x352e, 0xc40d, 0x3560, 0xbe9b, 0xbcdd, 0x3ee0, 0xc0f0,
    0x3b9a, 0xbd50, 0x3127, 0x407b, 0xae58, 0xac1a, 0xc5a5, 0xc085,
    0x3a2a, 0x38c5, 0x3c98, 0xb6ea, 0xc42a, 0xc240, 0xba8c, 0xbc9d,
    0xb1f3, 0x3eb0, 0x4369, 0xc0e3, 0xbe05, 0x3de2, 0x3c8e, 0xa902,
    0xbd79, 0xba48, 0x418d, 0x384d, 0xc11a, 0x4633, 0x3d1b, 0x3129,
    0xb5b8, 0x34f6, 0x33e4, 0xb964, 0xb370, 0x3e62, 0xc270, 0xc221,
    0xba85, 0x3d12, 0xbb26, 0xbf25, 0x3dc7, 0x3ccc, 0x38b1, 0xab0f,
    0x3e33, 0x3833, 0x428e, 0xbd0c, 0x4053, 0xbef9, 0xbc1a, 0x309a,
    0xc18c, 0x4152, 0xba96, 0xc2b6, 0xb409, 0x26b1, 0xc00a, 0x41b7,
    0xc0df, 0x3faf, 0x41f1, 0xb839, 0x3f5c, 0xc23f, 0x3092, 0x3d5a,
    0x41c3, 0x3d7a, 0x3c2d, 0x3ef6, 0x3d7c, 0xbaf8, 0x4446, 0x4243,
    0x2e4a, 0x31da, 0x44a6, 0x3a2d, 0x4003, 0x3e06, 0x34cf, 0xbdd5,
    0xc107, 0x3ae4, 0xc1b5, 0xbd0d, 0xb5f3, 0xb65c, 0xbca6, 0xb40e,
    0xbe22, 0xc048, 0x3d32, 0x38b5, 0x3a2f, 0xbba9, 0xbe8e, 0xc0f7,
    0xb4b1, 0xbe56, 0x3c58, 0x3da4, 0x3d62, 0x3a14, 0xc2a9, 0xc46f,
    0x42a7, 0xb158, 0x3520, 0xc00c, 0xc31c, 0xb5e2, 0xc064, 0x44a1,
    0xbf65, 0xbbb7, 0xbca1, 0x379b, 0x383d, 0xb8ea, 0xc1b5, 0x4703,
    0x3cc9, 0xc1aa, 0x408a, 0xb8b8, 0x4328, 0xc41f, 0xbf58, 0xbd38,
    0xb9a4, 0x4054, 0x40f5, 0xbaf8, 0x4514, 0xb0e6, 0xbeac, 0xb2d7,
    0x37f7, 0xb9a2, 0x4488, 0x38cc, 0x45fe, 0x41e8, 0xbe1f, 0x4091,
    0xbe84, 0x4586, 0xc412, 0xbb55, 0x3e85, 0x3c2e, 0xbd85, 0x3abd,
    0x3bb3, 0x398e, 0xb7d9, 0xbda4, 0x367d, 0x442e, 0x400c, 0x4326,
    0xc16c, 0xbe6f, 0xb7e6, 0x4494, 0xbd87, 0xb977, 0xc4ff, 0xc035,
    0x426e, 0xbf8e, 0xc448, 0xbd9f, 0xc263, 0xbd0c, 0xbf10, 0x4472,
    0xb9db, 0xbda8, 0x3df9, 0x43b0, 0xbc81, 0x3dec, 0xbb4d, 0xc0fe,
    0x360b, 0xb0e2, 0xb47e, 0xb9d0, 0x4336, 0xbcc5, 0xc104, 0x3f47,
    0x4068, 0xc2c5, 0xbfb0, 0x4110, 0xbd90, 0xbfa3, 0x3fb6, 0x2c06,
    0xc16f, 0xc443, 0x3c88, 0x4224, 0x4152, 0x33f2, 0x3f9f, 0xb927,
    0xbdd6, 0xc29c, 0x4048, 0x3b5d, 0x40a4, 0xbd79, 0x40e5, 0xbf17,
    0xc3a5, 0x3c70, 0x44db, 0xc418, 0x34c9, 0xb2d7, 0x3d0a, 0x41a1,
    0x4399, 0xb7e9, 0xc38f, 0xc17e, 0xc41e, 0x42c5, 0xc45d, 0xc01c,
    0xc019, 0x3ffc, 0x3955, 0xba5e, 0x37d3, 0x3dbe, 0x2cf0, 0x349e,
    0xbcbf, 0xbd67, 0xbfc1, 0xbe7c, 0xb8e6, 0xbd54, 0x41fe, 0xbf33,
    0xbdc2, 0xbf9b, 0x3167, 0x44da, 0x3c6d, 0xb8c1, 0x36c8, 0xb8ac,
    0xb406, 0xc3b9, 0xc0e1, 0xb803, 0xc245, 0x3ea0, 0x4296, 0x46c8,
    0x41bf, 0x40ca, 0x35ad, 0x3d38, 0xb4db, 0x4271, 0xb463, 0x3979,
    0x2fbe, 0xbb6f, 0xb521, 0xb129, 0xba77, 0xbb55, 0x41fb, 0xbda5,
    0x40af, 0x4021, 0x3d0b, 0xb35c, 0xb4ad, 0x37f0, 0xc0dd, 0x3d81,
    0x4102, 0x3a78, 0x3de6, 0xb631, 0xbd68, 0x378e, 0x4066, 0xc096,
    0xb297, 0x38ad, 0xbe40, 0x391b, 0x307d, 0x3c08, 0x3d30, 0xb4c4,
    0xc146, 0xbe98, 0x3e64, 0xc195, 0x4317, 0xbca0, 0x4021, 0x42bd,
    0xbbbc, 0xc1c2, 0xbc49, 0x4097, 0x442b, 0xb8e6, 0xbc69, 0x3bab,
    0xc0ce, 0x3ca5, 0xb709, 0xbf4e, 0x3c68, 0xb781, 0xc019, 0xbd39,
    0x371f, 0x4090, 0x3a84, 0x3eed, 0xbb45, 0xae5d, 0x4168, 0x38d7,
    0xc164, 0xbcad, 0xbb2c, 0xc02b, 0xbda8, 0x416c, 0xbfac, 0xb418,
    0xb41c, 0x425f, 0xb876, 0x31da, 0x3d82, 0xb444, 0x345a, 0xc106,
    0xbabd, 0x3e28, 0x38d1, 0x3292, 0x44bd, 0x3c93, 0x40e8, 0x3ec7,
    0x396b, 0xb84d, 0x38c5, 0x3e65, 0xc055, 0xc3d4, 0x4424, 0xbbf6,
    0xb1ef, 0xbb47, 0xbd36, 0xbd0a, 0xbbe0, 0xb8ea, 0x3c98, 0xb83f,
    0xc00b, 0x3c72, 0x3ff0, 0xacfa, 0x388a, 0x400f, 0x2e7c, 0xbd3d,
    0x445c, 0x3fb5, 0xbdb1, 0x3aaf, 0x3c55, 0xbd11, 0xbe40, 0xb9c9,
    0xbfb2, 0xc200, 0x3b50, 0x4194, 0xc34e, 0xbbd8, 0x3ad6, 0xb6cf,
    0x40fc, 0x3146, 0x3a11, 0xabbd, 0xbb0d, 0xc633, 0xb8eb, 0x3476,
    0x3faf, 0x42d3, 0x9c05, 0x3c3b, 0xb821, 0x44ff, 0x41ba, 0x44c2,
    0xb2a9, 0x3e4d, 0xc217, 0xbe0a, 0xb463, 0xc2f6, 0x41ab, 0xc3d2,
    0x3cf6, 0x3d0f, 0xc1cd, 0xbe41, 0x4064, 0x4071, 0x3071, 0x3eb4,
    0xc0c4, 0xbc5b, 0x3bc5, 0xc12e, 0xbd4e, 0x37fc, 0x3df6, 0x3f1b,
    0x3535, 0xc2ac, 0x3a37, 0xb91c, 0xbd41, 0x4137, 0x416f, 0x3a34,
    0x3d7f, 0x434c, 0x4227, 0x430d, 0xba55, 0x41fb, 0xc2b0, 0x3570,
    0xc287, 0x3a36, 0xb9dd, 0xaffe, 0xc0ac, 0x3e80, 0xbfae, 0x3c2d,
    0xb565, 0x3dd0, 0x3c13, 0x41da, 0x3a98, 0x3dd8, 0xb0a9, 0xbcc6,
    0x3e79, 0x3b9c, 0x3d84, 0xba39, 0xbbe4, 0xc000, 0xbfdc, 0x4306,
    0x43cc, 0xb61f, 0x3e53, 0x3ad7, 0xb774, 0x3654, 0x4626, 0xb8e6,
    0xb937, 0xb7b6, 0xc031, 0x2561, 0xc17d, 0xc017, 0x4623, 0xbc24,
    0x3d31, 0x4478, 0x455d, 0x4572, 0xbbec, 0x3f5a, 0xc251, 0xc4e3,
    0xc1bb, 0x4113, 0xb7dd, 0x3a3e, 0x39b0, 0xb38c, 0xbc32, 0xc18b,
    0xbd7d, 0xbe59, 0xbc31, 0xbce0, 0xbc19, 0x3a79, 0xbfdc, 0xc18c,
    0x4407, 0xa68c, 0xbf04, 0x311a, 0x2eff, 0xb65c, 0xc03c, 0xb904,
    0x3f68, 0xbf65, 0xc00e, 0xb8ef, 0xbf49, 0xb6b2, 0xb15a, 0xb79c,
    0xbd73, 0x3951, 0x3c34, 0x3538, 0x3c9f, 0x414a, 0xbe25, 0xc45a,
    0x455e, 0xc2a9, 0xbd20, 0x2ed3, 0x3e77, 0xc078, 0x4094, 0x3dbb,
    0x2eb5, 0x4175, 0x41e6, 0x4001, 0x37b4, 0xba40, 0x3d8e, 0x3d73,
    0xb8d9, 0x391b, 0x32a8, 0x3d9f, 0xb65b, 0x3e09, 0x35bb, 0xc4cf,
    0x2a76, 0xb339, 0xbff5, 0x3504, 0xb6ef, 0x38f9, 0x37da, 0x4298,
    0x4288, 0x41ec, 0xbae7, 0x410b, 0xb65e, 0xc09b, 0x446a, 0xbc6d,
    0x4095, 0xc06a, 0x41b0, 0x3b0a, 0x37c3, 0xba0f, 0xb965, 0xb6d9,
    0x3e30, 0x34b6, 0x3ff0, 0x4330, 0x4083, 0x2425, 0xc04b, 0x3c85,
    0x388b, 0x3ff6, 0xc554, 0xc189, 0xc061, 0xb79a, 0x384a, 0x40e0,
    0x458a, 0x3d83, 0xc334, 0x4465, 0x4231, 0xbf78, 0x2303, 0xb73f,
    0xc2f9, 0xbcfb, 0x4177, 0xc350, 0xba1b, 0x387e, 0xc1e6, 0x3db9,
    0x3e27, 0xc07e, 0xc3bb, 0xc0ee, 0xb89d, 0x340a, 0xbe90, 0x3aba,
    0xc4c1, 0x40d2, 0xc419, 0x38d5, 0xbf1c, 0x3ef1, 0xbc9f, 0xa262,
    0x4040, 0x44e9, 0xb6e8, 0xc0df, 0x34a6, 0xbb9a, 0x4407, 0x41bc,
    0xbea6, 0x3cda, 0xc0b6, 0xbb91, 0xb81e, 0x3552, 0x3ac1, 0x41d6,
    0x3943, 0xc0e9, 0xc0c5, 0xb686, 0xc4d1, 0xb25d, 0xb33f, 0xb606,
    0x3ec5, 0x4499, 0x40ce, 0xc01d, 0xbb54, 0x3e09, 0x4329, 0x352e,
    0xaad1, 0x41d9, 0x3acc, 0xc325, 0xbdf0, 0xc161, 0xc074, 0x3806,
    0xbde5, 0x2f6f, 0x4196, 0xbdf5, 0x4238, 0x3de8, 0xbc30, 0x3bca,
    0x3a19, 0xb5a8, 0xc63e, 0xbd48, 0x3a72, 0x4186, 0x41dc, 0xac31,
    0xb4e6, 0x44d2, 0xc196, 0x3ad4, 0x448a, 0x43d9, 0xbc37, 0x45e3,
    0xb3d3, 0xafd7, 0x41e5, 0x3efa, 0xb8d8, 0x38b0, 0x3ced, 0x35a4,
    0x3e57, 0x415e, 0x4478, 0xbf7f, 0x430c, 0x3dd5, 0xbf0b, 0xb1d9,
    0xba65, 0x4158, 0xba4e, 0x356f, 0xc0f0, 0xc5bd, 0x3980, 0x2be4,
    0x3e2e, 0x411a, 0xbc24, 0xad44, 0xbc5d, 0x3d62, 0xc2a8, 0xbebb,
    0xba27, 0x34c5, 0x42bc, 0xc356, 0x41ff, 0x3771, 0x3cfd, 0xc43f,
    0xb835, 0x40fa, 0xbc09, 0xc1d8, 0x3f70, 0xb873, 0x450e, 0xc3ac,
    0x3e53, 0x3637, 0xc51d, 0xb584, 0xbf22, 0x36fb, 0x342f, 0xc131,
    0xc4a5, 0xbd2f, 0xbf1b, 0x3c6c, 0xc2fb, 0x392a, 0xb304, 0x4337,
    0x3ce5, 0x38e0, 0xbd94, 0xbbc6, 0xc35a, 0x2b0c, 0xc1e5, 0xbb46,
    0x4443, 0x3ea0, 0xc178, 0xba25, 0xc19c, 0x3991, 0x40e8, 0x4236,
    0xbed6, 0xaf69, 0xb5a2, 0xab83, 0xc277, 0xbf8a, 0xbc5e, 0x431a,
    0xbc5e, 0x3b36, 0x385a, 0xbecb, 0xb0d5, 0xb2a8, 0xbce8, 0x4095,
    0x4171, 0x38a6, 0xbe64, 0x3cb2, 0xbc17, 0xc184, 0x36f1, 0xbe46,
    0x3939, 0xbf60, 0x440f, 0xbfac, 0xbfee, 0xb39c, 0x3ab5, 0xb76a,
    0x401b, 0xbe7d, 0x3e2d, 0xba99, 0xbc81, 0x443b, 0xb9fe, 0x42c8,
    0xbbc1, 0x369b, 0x3a38, 0x412d, 0xc0ca, 0xb113, 0x4003, 0xc340,
    0x3e62, 0xc145, 0x345a, 0xc045, 0x3588, 0x4007, 0x4292, 0xa254,
    0x433a, 0xbab6, 0xb908, 0x4187, 0x3cf9, 0xb85f, 0x3373, 0xbe78,
    0x2f72, 0x3a55, 0x3ed9, 0x398d, 0xc286, 0x3a60, 0xb4de, 0x37c8,
    0xbaeb, 0x375a, 0xc277, 0xc063, 0x3b93, 0xbe11, 0x3af1, 0xb579,
    0x42b3, 0xbd67, 0x34a5, 0x2c1f, 0x3cca, 0xc285, 0x4153, 0xb8bf,
    0xbc9d, 0x3666, 0xb7e1, 0x40c7, 0xb61c, 0xbea8, 0x4131, 0xbecb,
    0xb9b9, 0x40fe, 0xbbac, 0x40b0, 0x3abe, 0xb9b9, 0x4059, 0xc1ff,
    0x40d2, 0x3b08, 0xbc4c, 0xb8b5, 0x3eb4, 0xb02c, 0xc183, 0xc0aa,
    0xb898, 0x4435, 0x3f22, 0xc049, 0x3246, 0xb9e5, 0xbe88, 0xc056,
    0xba52, 0x379c, 0xbbf6, 0xb8b0, 0x4101, 0xbc1c, 0xb7b6, 0x3dd1,
    0x3b73, 0xb9bd, 0xb4c4, 0xc13b, 0xbb97, 0x3193, 0x3a3d, 0x432e,
    0x40c4, 0xbe70, 0xbe8a, 0xbc6d, 0xb6c3, 0x3e31, 0xba2d, 0x41ab,
    0xc418, 0x3a8f, 0x438b, 0xaf30, 0xbd6f, 0xac0d, 0xbaaf, 0xb8c0,
    0xad6b, 0xb8df, 0xc321, 0xb503, 0x4460, 0xbe4f, 0xc2ed, 0x415f,
    0x3bd4, 0xb7f2, 0x36ab, 0xb8c6, 0xbde2, 0xbda2, 0xc57f, 0x347e,
    0x3cab, 0xb849, 0xbdf3, 0xc3b0, 0x3f99, 0x3fc0, 0xbe5a, 0x3a9f,
    0x382e, 0x32fa, 0xb832, 0xb9a4, 0xbabc, 0xc0a5, 0xb494, 0x39f4,
    0xb7e7, 0x31ab, 0xc194, 0xc457, 0x3b3a, 0x3d1d, 0xbbda, 0x3e6c,
    0x2fc7, 0xc050, 0xc031, 0xc4b5, 0xb714, 0xc206, 0x3ec3, 0xc32c,
    0xbdb4, 0x351f, 0xafdc, 0x428b, 0x42da, 0x33a1, 0x3936, 0x3eec,
    0xb9ab, 0x3fe5, 0xbcf7, 0xbc85, 0xc023, 0x3bca, 0xbec2, 0x317f,
    0x3701, 0xb4f6, 0x4064, 0x34d4, 0x3f0a, 0x3070, 0x36b9, 0xb404,
    0x4499, 0x3918, 0x4021, 0x34a2, 0x4153, 0x3cd9, 0x436a, 0xb8a2,
    0x318e, 0x3888, 0x4027, 0xc2ff, 0xb607, 0xc122, 0xc397, 0x3dba,
    0x2cd6, 0xbcc6, 0xc1a1, 0x3684, 0x39a7, 0x37d1, 0x3e42, 0x3e14,
    0x4442, 0x44c5, 0x4477, 0x41fb, 0xb5f3, 0xbfdc, 0x3c82, 0x3eac,
    0xad47, 0x4347, 0xc0c3, 0x40c7, 0xbffc, 0xbcbd, 0x33a2, 0x3826,
    0xc280, 0x3ada, 0x3daa, 0x4246, 0xc40d, 0xb8e7, 0xbce6, 0x3852,
    0xbb96, 0x429b, 0xb8ba, 0xbd04, 0x3bba, 0xbbf2, 0xb485, 0x40d0,
    0xbe29, 0x405b, 0xc446, 0x3da3, 0xbc91, 0x40fa, 0xc32a, 0x285a,
    0xc1d4, 0x32a2, 0x40be, 0x3fe7, 0xbe30, 0x45b2, 0xb8eb, 0x3ce5,
    0x4240, 0x309e, 0x3938, 0xc1d0, 0xbfca, 0xbf7d, 0xb955, 0xbce6,
    0x3360, 0xc2d5, 0xc682, 0xbfbf, 0xc075, 0xbeae, 0x3df4, 0x3d67,
    0xc106, 0x3b45, 0xbc34, 0xc429, 0xbd54, 0xbed0, 0xb961, 0xc268,
    0x3ac8, 0x3bee, 0x3dc4, 0xc3bf, 0xc135, 0x42b7, 0x448f, 0xc47e,
    0x3541, 0x3c38, 0x3d61, 0x41ad, 0xc040, 0x3ec4, 0x40f7, 0x43b5,
    0x34bb, 0xc0dd, 0xc088, 0xb54d, 0x3c31, 0x410f, 0xbca5, 0x4245,
    0x42e6, 0x3a8e, 0xaccc, 0xc015, 0xb047, 0xc199, 0xc3fa, 0xba4d,
    0xb098, 0x3825, 0xb566, 0x3d11, 0x43ac, 0x3c97, 0x3f7e, 0xc076,
    0x432d, 0xb2db, 0x38fb, 0x3526, 0xbcd4, 0x4120, 0xbe96, 0xbdce,
    0x4360, 0xaf27, 0x3bd8, 0x4381, 0x3d87, 0x39f4, 0x2f79, 0x3897,
    0x4180, 0xb867, 0xbf4b, 0xc219, 0x41d4, 0x3d69, 0x419c, 0x3e4d,
    0xac51, 0x4446, 0x3662, 0x21c1, 0x372e, 0xb6f9, 0xbea2, 0x4178,
    0xc2f7, 0x3f78, 0xc149, 0xc442, 0x4075, 0x445a, 0xc14c, 0xbda9,
    0xc22a, 0xc0d2, 0xb8dd, 0xc1b4, 0x431b, 0xc0e2, 0xc0c2, 0xc559,
    0x3984, 0x3cd3, 0xb996, 0xc2a5, 0xb992, 0xba2a, 0xb04a, 0x3623,
    0xac03, 0xbc61, 0xb67b, 0xc110, 0x3a0d, 0x35df, 0x3c4d, 0xb523,
    0x44c5, 0xc114, 0xc3ea, 0xc31d, 0xc2bf, 0x445e, 0xb978, 0x415e,
    0xc52a, 0x3d14, 0x3b0b, 0x4212, 0xb718, 0x40b9, 0xc089, 0x4029,
    0xbc48, 0xbdd1, 0x4307, 0x3df7, 0x40d9, 0x4263, 0xbe99, 0x35e6,
    0x3e55, 0x3fe0, 0x38ed, 0xc078, 0x41c8, 0xb21d, 0xbae8, 0x35f3,
    0x4040, 0x2eef, 0x3edb, 0x3c65, 0x3f60, 0x3c8b, 0xbc0c, 0xc02b,
    0x3b16, 0xc114, 0x38ee, 0xc079, 0xc59e, 0x3d52, 0xb79f, 0x3a4b,
    0xb8fc, 0x3da1, 0x41ef, 0xbfe6, 0xbf3b, 0x410d, 0xc4fd, 0x3829,
    0x3e6e, 0x45b7, 0xc160, 0xc362, 0xbd87, 0xbce5, 0x4032, 0x3ed0,
    0xc1e6, 0x2940, 0xc1e2, 0x406d, 0x420e, 0xbbff, 0x3fe5, 0x3630,
    0xb00f, 0xb952, 0x3fa7, 0x3e2e, 0x3e49, 0x3f14, 0xbe3f, 0x3f03,
    0xae10, 0x366b, 0xbc74, 0x4126, 0xb21d, 0xbc16, 0xc15c, 0xbc84,
    0x401d, 0x3e33, 0xbba0, 0xacd8, 0x3756, 0xc1f8, 0x4194, 0xbff8,
    0xc124, 0x400b, 0xbafa, 0x3fb9, 0x312a, 0x39b0, 0x359c, 0xc703,
    0xa24d, 0x414b, 0x39ce, 0xbcba, 0x334a, 0xc16d, 0x3bb2, 0x3d37,
    0xba36, 0xb61c, 0x3c8f, 0x3dea, 0xc3ad, 0x2c51, 0xbc8c, 0x2c70,
    0xc48d, 0x3efd, 0x426d, 0xbc8a, 0x3fee, 0x3deb, 0xc466, 0x3ae9,
    0x3c58, 0x38eb, 0xbbb5, 0x4036, 0x3f23, 0x3b43, 0xc29f, 0x431b,
    0xc368, 0x42b6, 0x3040, 0x4032, 0x40ab, 0x4439, 0x3c3e, 0xc0cf,
    0x3cbb, 0x3cad, 0xb518, 0xb9ce, 0x3a5c, 0x4398, 0xb27d, 0x3b69,
    0x26d4, 0xb9b0, 0x4416, 0x4235, 0x3968, 0xc1a8, 0xbf21, 0xb4ee,
    0xab41, 0xc046, 0x41ba, 0x401c, 0x4782, 0x3d18, 0xc455, 0xa9bd,
    0x3f77, 0x4231, 0xbac6, 0x30ec, 0x4099, 0x40a5, 0x4198, 0x313c,
    0xc425, 0xc407, 0xc462, 0x3ec5, 0x4343, 0x34e0, 0x3e0e, 0xbcc3,
    0x4016, 0xc02b, 0x40aa, 0xb400, 0x4316, 0xbed5, 0x3b78, 0xbe04,
    0x3f52, 0x3bdb, 0x4343, 0xbc47, 0x44ff, 0xbf37, 0x41bb, 0x34e9,
    0xc300, 0x3a79, 0x3b9c, 0xafc2, 0xc24a, 0xa83d, 0xb34c, 0xbda1,
    0x39ac, 0xb14e, 0x42d5, 0x3dfa, 0x3d5e, 0xb076, 0x3cca, 0x3cd2,
    0xbf63, 0xc19f, 0x3ee8, 0x408e, 0xc084, 0x4061, 0xc045, 0xb434,
    0xc239, 0x39a6, 0x3798, 0x3789, 0x391f, 0x414c, 0xbc34, 0xaefa,
    0xc39a, 0xbc79, 0xc197, 0xbe53, 0x4356, 0xb961, 0x4055, 0xc10b,
    0x3850, 0x3e86, 0xb8a0, 0xc02e, 0x4298, 0x40b7, 0xacb7, 0xbe4e,
    0x3c14, 0x3da9, 0xb8ea, 0x288b, 0x3c54, 0xb7c2, 0xc07b, 0x3d3c,
    0xc01a, 0xbf83, 0x4106, 0x33be, 0x3048, 0xc58f, 0xb41f, 0x45c1,
    0x404b, 0x3865, 0x3e56, 0x42c4, 0x4266, 0x3c14, 0x2ee9, 0xb058,
    0x34d4, 0x295f, 0xb2f7, 0x42de, 0x4047, 0x41ae, 0x3f59, 0x3807,
    0xb4c7, 0x3c7c, 0xbc17, 0xc1a8, 0x2c17, 0x4052, 0x3e68, 0x3cb3,
    0xb16e, 0xbafa, 0xbbf2, 0x419a, 0xc444, 0x3f86, 0xbeee, 0xbed0,
    0xc199, 0xbe33, 0xbc06, 0xc341, 0xb66a, 0xbd4e, 0xc0f2, 0xc1a3,
    0x3f43, 0xb824, 0xbe06, 0xc084, 0xc38a, 0x2c85, 0x40d2, 0x28ed,
    0x410e, 0xbbff, 0x3859, 0xb954, 0xbd95, 0xc197, 0x40b6, 0xb1b3,
    0xb1e5, 0xc2d1, 0x3a78, 0x2b57, 0x3d36, 0xbf52, 0x4409, 0xc2df,
    0x3f94, 0xc031, 0xc263, 0xbdb0, 0xbbc9, 0xbcb1, 0x4234, 0xc085,
    0x40e8, 0xbd4e, 0xc173, 0x383f, 0xb59e, 0x3a8c, 0xbfba, 0x44c2,
    0xb6c2, 0xbb82, 0x4569, 0x39df, 0x4174, 0x4471, 0x410d, 0xc3c9,
    0xc051, 0xa919, 0xc2a2, 0xc429, 0xbd5c, 0x44fe, 0x44eb, 0x3d84,
    0xc304, 0x3924, 0xc480, 0xc036, 0xc2db, 0xb943, 0x3d2f, 0xbc05,
    0x35e5, 0x43ac, 0xb904, 0x3717, 0x32cb, 0xbea8, 0x437c, 0x3e1b,
    0x354a, 0xc01a, 0xaf9f, 0xbc9f, 0xc25b, 0x3cca, 0x25e5, 0xb444,
    0xc03f, 0xc21d, 0x4294, 0xbeb1, 0x3e44, 0x4323, 0xbb35, 0xbf1c,
    0x3e77, 0x3458, 0xbdc4, 0x4433, 0xc1f1, 0x2c2a, 0xbb52, 0xb557,
    0x3c5b, 0x2ae6, 0x3075, 0x3d62, 0x3c6c, 0xbbae, 0x38a0, 0xc0e8,
    0x3d1a, 0xbc67, 0xbd32, 0xb96d, 0xc0a7, 0x3593, 0x42cb, 0xba72,
    0xbed8, 0xc204, 0xc10d, 0xb813, 0xb8b3, 0x4485, 0xc109, 0xc344,
    0xb4b5, 0x42d5, 0x427d, 0xc33c, 0xc09e, 0xbcd9, 0x3ff8, 0x3eff,
    0xbaaa, 0xc036, 0x3fe0, 0x3f73, 0x3df7, 0x4136, 0xc112, 0x3e14,
    0xc0f7, 0xb613, 0xc29a, 0x448b, 0xbea0, 0xb594, 0x3d43, 0x32a1,
    0x37bf, 0xbdb9, 0x410b, 0x39e0, 0x3d4e, 0x43e7, 0xc10a, 0xb5f6,
    0x4120, 0xc05e, 0x4463, 0x3f5b, 0xbcba, 0xc113, 0x3edb, 0xabb8,
    0xbfcf, 0x4056, 0xbec4, 0x3a8a, 0x440e, 0xb23a, 0x33b1, 0x43f5,
    0x40b6, 0x4011, 0xbb8e, 0xb6dd, 0x42c3, 0x3662, 0x2e4a, 0xc43f,
    0x3f76, 0xbe3d, 0x3a6d, 0x4052, 0x3e87, 0x3d61, 0x3d6f, 0x442d,
    0x387b, 0xbd5a, 0x4043, 0x4113, 0xb4e0, 0x4218, 0x45ad, 0x3a95,
    0xc2ab, 0xc2d6, 0xb522, 0xc24b, 0x38be, 0x4098, 0x411f, 0xbaaf,
    0x2130, 0xc24e, 0xbec0, 0xba8c, 0xc752, 0xbd52, 0x4213, 0xc127,
    0x43e4, 0xba0d, 0x357c, 0x37b2, 0xbf84, 0x3cda, 0xb624, 0xc4a9,
    0x41c1, 0xbe37, 0xbce4, 0x3aa4, 0x403a, 0x36c3, 0xbcd7, 0xb49b,
    0x3c58, 0x408c, 0x4433, 0x4043, 0xc063, 0x3fc2, 0x4106, 0xc281,
    0x3cd1, 0xc0be, 0x3c1b, 0xbb63, 0x425e, 0x44f6, 0x391e, 0xadeb,
    0x3c78, 0x3ebd, 0xbc7f, 0x3d00, 0xc2b9, 0x3a9a, 0xbebb, 0x3423,
    0xb9de, 0x4143, 0x3dec, 0xbc6f, 0x3846, 0xbf38, 0x3d5f, 0xc31d,
    0xbc67, 0xb912, 0x365c, 0xbc42, 0xc2ac, 0xc267, 0x3e3a, 0xc0c2,
    0x3d2e, 0xc2b9, 0x3ec4, 0xb2d9, 0xb7e8, 0x358d, 0x4472, 0x40c5,
    0xc2ab, 0xc1ff, 0x400d, 0xbb0f, 0xb2c9, 0x43fc, 0xbd97, 0xb82c,
    0x42da, 0x3d23, 0x381a, 0xb91e, 0x4271, 0xbdbd, 0x42bc, 0xc02d,
    0xc3dc, 0x3e18, 0xbd4d, 0xc4e0, 0xbd45, 0x4126, 0xb0ce, 0x40cd,
    0x35c5, 0x363f, 0x4028, 0xc153, 0x4062, 0x3f3b, 0x44f9, 0xbe31,
    0xb641, 0xc445, 0x39f3, 0xbca8, 0x2d8c, 0xbcab, 0xbfb0, 0xb10e,
    0x40e6, 0xbf91, 0x3f3e, 0x3bf3, 0x37de, 0x4297, 0xb8f3, 0x3b37,
    0x403c, 0xbae0, 0x4339, 0xac80, 0x3840, 0xb0ea, 0x30af, 0x43e0,
    0x267f, 0xbf0b, 0xb4d9, 0x3b98, 0xc4bf, 0x417c, 0x3d37, 0xc1a5,
    0x416a, 0xb1c8, 0x4092, 0x3506, 0x4048, 0x292c, 0x3dd6, 0xb873,
    0x4151, 0xc096, 0x28a6, 0xbc03, 0x426e, 0x450b, 0xb34f, 0x42d5,
    0x3d36, 0x2ab5, 0xc3f7, 0x40e1, 0x4200, 0x2925, 0xb62a, 0xb8b6,
    0x4048, 0xbfbf, 0x1fd7, 0xc1b7, 0xc0db, 0xc17b, 0xbd84, 0xbbcd,
    0x33c4, 0xc248, 0x3cd6, 0xc081, 0xbc88, 0xbd0d, 0xbdc4, 0xc456,
    0x4464, 0xb984, 0x4406, 0x4402, 0xc0f8, 0xbfc6, 0xb90b, 0xb74b,
    0x3e4b, 0x3eae, 0x4098, 0xbe40, 0xbe8e, 0x3d65, 0xb563, 0x4432,
    0x3f87, 0x3cc9, 0xc235, 0xbdca, 0x3edc, 0xbffd, 0x41fa, 0x4465,
    0xc04c, 0xc070, 0xbd19, 0xb592, 0xc049, 0x411f, 0x44b9, 0xb973,
    0x3cdc, 0x3819, 0xb81b, 0x4078, 0x3bec, 0x47e6, 0xbcc4, 0x3e15,
    0x3be9, 0xbdcb, 0xc02c, 0xb885, 0xbf20, 0xba3a, 0x42ba, 0x2c6a,
    0xbcf4, 0x41ac, 0x36bf, 0x447f, 0xc23e, 0x42c7, 0xc023, 0x3b76,
    0x42fc, 0xbaf7, 0xb78b, 0xc5da, 0xc122, 0xb79f, 0xc380, 0x4022,
    0xc144, 0x35ee, 0xc39c, 0xb4b5, 0xbb7d, 0xc209, 0xb9a1, 0x422a,
    0x3edc, 0xb9ab, 0xbde1, 0x3ef6, 0xbfa4, 0xb011, 0x34a5, 0xc2a5,
    0x394d, 0x3f48, 0xc019, 0xb694, 0x3e2b, 0xbd57, 0xc045, 0x34a0,
    0xbec7, 0xbc2f, 0x2ed5, 0x44cc, 0xc17c, 0xbcb5, 0xc07f, 0xae0b,
    0x42ce, 0x37e0, 0xc3ee, 0xaaac, 0xbf54, 0x39d0, 0xc0f6, 0xbcf4,
    0x4253, 0xb78e, 0x3bcf, 0xbeeb, 0x44a4, 0xbfd6, 0x3da8, 0x420f,
    0x4498, 0xbf26, 0xc322, 0x4241, 0x3f08, 0xbae9, 0x3cec, 0x3f5d,
    0x39f9, 0x4276, 0x3fcb, 0xbebf, 0xc07f, 0x414b, 0x3ca6, 0xbd56,
    0x3c3a, 0x2eb0, 0xb17d, 0xb80b, 0xb2bc, 0x3cff, 0x430e, 0xbc85,
    0xc023, 0x40a3, 0xc48c, 0xbc8f, 0x4603, 0xb3b9, 0xc2ea, 0x45a7,
    0xc4bb, 0xba72, 0xc40b, 0xb706, 0xc04b, 0xb82c, 0x3f1b, 0x33c0,
    0xbcda, 0xc23d, 0x3dd3, 0x42b6, 0xc00e, 0x32dd, 0x3b47, 0xbdfa,
    0x390a, 0xc44c, 0x41f4, 0xbc73, 0xc098, 0xbb69, 0xc1e0, 0xbfba,
    0xc217, 0x329f, 0x403f, 0xbc07, 0x3d44, 0x3e87, 0xc0ee, 0xba9f,
    0xbe7c, 0xb636, 0x40ef, 0x413e, 0x30c4, 0xc6cb, 0xb5e3, 0x4186,
    0x3cf1, 0x420c, 0x4214, 0xc1e3, 0xc2b4, 0x3c43, 0x3fcb, 0x439e,
    0x3db5, 0x45a1, 0x22ab, 0x452e, 0xc04f, 0x3a87, 0x4480, 0xbd98,
    0x3f68, 0x3763, 0xa628, 0x2dec, 0x3de5, 0x4419, 0xbefe, 0xc2a8,
    0xbcb9, 0x400d, 0x3044, 0x3b14, 0x435b, 0x3d02, 0xad2c, 0xc257,
    0x3c22, 0xbc03, 0x4169, 0xbd40, 0x31ee, 0x42b6, 0x295e, 0x3f6e,
    0x391f, 0xbb1d, 0xb99d, 0xc049, 0xbcad, 0x4119, 0xbb87, 0xc6b8,
    0x3ca6, 0x41a4, 0xbe79, 0x3621, 0xbdb0, 0x3267, 0x3f1b, 0xbec6,
    0x3fc8, 0x3e21, 0x3b27, 0x3371, 0xbefc, 0x368f, 0xc01f, 0xbd61,
    0xad0d, 0xbbc2, 0xbe43, 0xb6f2, 0x3a5b, 0x3feb, 0xbf48, 0x3e14,
    0x42f0, 0xc057, 0xbe1f, 0xc02c, 0x3c43, 0x3c2d, 0x3e30, 0xb0eb,
    0x389a, 0xbc75, 0x4359, 0xc00b, 0xbfd0, 0x40e9, 0x444f, 0x449e,
    0xbfed, 0xbf33, 0xc0ad, 0xb40a, 0xb6ff, 0xa6a2, 0x2d32, 0xbc41,
    0xc10a, 0x38bb, 0x3cb5, 0xbe62, 0x31c5, 0xba9f, 0xbd08, 0xc439,
    0x38d7, 0x3dc5, 0x2dc3, 0x41f2, 0xc030, 0x41c9, 0xb4bc, 0x36e1,
    0xb874, 0xbd18, 0xb040, 0x3eb8, 0x45d3, 0xb9b1, 0x44e0, 0x43a3,
    0x3b66, 0xbe30, 0x404b, 0xbc48, 0xc02a, 0x4188, 0x355c, 0xbc77,
    0x405b, 0x404c, 0x3af5, 0xc731, 0x4389, 0xbba9, 0xb889, 0x3b49,
    0xbeec, 0x3f9e, 0x3ad8, 0xb8dc, 0x4128, 0xbcc3, 0xbb00, 0xc1c4,
    0xc00a, 0x401a, 0xbeb1, 0xb8f0, 0x4131, 0xc27c, 0xb80f, 0xbea8,
    0x3c61, 0xc1e9, 0x3c6a, 0xc520, 0x3709, 0xc574, 0xb680, 0xb578,
    0x3c7a, 0x3747, 0x3897, 0xc098, 0x3d7e, 0x4015, 0x44bd, 0xbfa6,
    0xc476, 0xaeb4, 0x3a1a, 0xc0b6, 0x3f57, 0xb8bb, 0xbd08, 0x3eaf,
    0xb85f, 0xb323, 0x3e14, 0x3d15, 0x3cfd, 0x4567, 0x326d, 0xc172,
    0x398b, 0xb7af, 0x342b, 0x38ee, 0x3681, 0x31e4, 0xb188, 0xadf0,
    0x371a, 0xbee8, 0x3c17, 0x4569, 0xc4f5, 0xbd66, 0xbe9a, 0xbe70,
    0x3b3d, 0x43fa, 0x411d, 0xc056, 0xbeee, 0xb755, 0x458c, 0xb8b5,
    0xc4d7, 0xbcd4, 0x3dc4, 0xc1d9, 0x446c, 0xbe3c, 0xb49c, 0xb9cc,
    0xc3b0, 0x40f0, 0xbdf9, 0x4536, 0x408e, 0x3b41, 0xbee3, 0x3797,
    0xa6b8, 0xc2d2, 0x4587, 0xbd57, 0x4206, 0x422a, 0xc2b3, 0x4151,
    0xc042, 0x3d73, 0x4069, 0x40f0, 0xc02f, 0x4325, 0xb03a, 0xbcc4,
    0xb472, 0xbe97, 0xb696, 0xc054, 0xb181, 0xb776, 0x371d, 0xc270,
    0x3f31, 0xbae4, 0x1931, 0xb7ab, 0x3f43, 0xc465, 0x3fd4, 0x40e7,
    0x4129, 0xc0f6, 0xbc3f, 0x3a9d, 0xbcc9, 0xbf6d, 0xbd6f, 0xc278,
    0xc44a, 0xc410, 0xc185, 0xb728, 0x3729, 0xa594, 0xc22f, 0xc36e,
    0x4042, 0xc136, 0xc293, 0x44e0, 0x44fa, 0x3648, 0xbd31, 0x3b46,
    0x4167, 0xbd15, 0x3a28, 0x3dcc, 0xbe04, 0x4337, 0x38ce, 0xc44e,
    0xc20b, 0x448a, 0xb9ea, 0xbb29, 0xb8d8, 0xbe46, 0xc17b, 0xbae6,
    0x42ba, 0xc394, 0xc389, 0x3857, 0x40cd, 0x41c6, 0xc05a, 0x401b,
    0xb887, 0x3f89, 0xc456, 0xb899, 0x2952, 0xbed9, 0x42a5, 0xb929,
    0x4189, 0x4082, 0x401a, 0x4156, 0x4073, 0x9d97, 0x43c3, 0xbc7c,
    0xa0fc, 0x4035, 0xbf02, 0xc124, 0xbd0d, 0xbce1, 0xb8e2, 0xb749,
    0xc430, 0x3cfb, 0x35e0, 0x421f, 0xc1ce, 0x3dd0, 0x3d00, 0xc24a,
    0xbcb4, 0xbe18, 0x3dd2, 0x3b5c, 0xc043, 0x412e, 0x407a, 0x3f1a,
    0xba9d, 0xc023, 0xbe59, 0x4100, 0xbb0d, 0xbcdf, 0xc0b0, 0x39a7,
    0xc07c, 0xbb60, 0xb00c, 0x3622, 0xbc5b, 0xbe03, 0xc29d, 0x3af8,
    0x3a74, 0xbdc2, 0x38c0, 0x40f2, 0xc0a9, 0xbc17, 0xc276, 0xbd82,
    0x3d15, 0xbf5a, 0xc0e6, 0x2ef6, 0xba0d, 0x38f4, 0xbcef, 0xbeb1,
    0x3fd7, 0xbfba, 0x3366, 0xbd49, 0xbe6f, 0x3f6d, 0xc0b7, 0x3c5c,
    0xc1f7, 0xb67b, 0xc1a9, 0x35fe, 0xbe2e, 0xc3de, 0xc434, 0x4056,
    0xc11e, 0x35b6, 0x410a, 0x4107, 0x35be, 0x4151, 0xb6ad, 0xb42c,
    0xc42d, 0xc46c, 0x403c, 0x3fbe, 0x3a91, 0x4091, 0xc1fc, 0x3a27,
    0xbd9a, 0xb887, 0xa87c, 0xc0fe, 0xbd72, 0xc2a3, 0xb0e3, 0x3974,
    0x37a4, 0x43a8, 0x4059, 0x4442, 0x4001, 0x2f08, 0xb7b1, 0xb4fd,
    0xc199, 0x3d19, 0xc270, 0x403b, 0xbef1, 0xc06c, 0xa829, 0xc116,
    0x3985, 0x459a, 0xbdcc, 0xc00d, 0xb603, 0xc3cb, 0x35e4, 0xb5ba,
    0x3e99, 0xbda1, 0xc18c, 0x3989, 0x9c4c, 0x4526, 0x20aa, 0x3b83,
    0xbe27, 0xbecc, 0xb3a8, 0x3f2c, 0xc0b8, 0xc1de, 0xbe66, 0xbfbe,
    0x39c0, 0xc1c7, 0x2de9, 0xadaa, 0x37b2, 0x3c9c, 0xad52, 0x3c4b,
    0x3c76, 0x449a, 0xbb52, 0xbe8d, 0x3cd1, 0xbf5e, 0x3ea3, 0x40fe,
    0x41c4, 0xb241, 0x3b86, 0x3e9f, 0x43ad, 0xbd71, 0x391d, 0x3d78,
    0x30b0, 0x35af, 0xb807, 0x3c4b, 0x3662, 0xc314, 0xc13c, 0x3dc7,
    0x448a, 0x343b, 0x388e, 0x3e50, 0x4248, 0x408e, 0x4213, 0xc368,
    0x4216, 0x435f, 0xba92, 0xb56d, 0x3c47, 0x407d, 0xc2e5, 0xb73d,
    0xb3f0, 0xbc4f, 0xc140, 0xb99f, 0xb98f, 0xc0cd, 0x2a88, 0xbe0c,
    0xb24b, 0x0, 0x2a88, 0x3e0c, 0xb98f, 0x40cd, 0xc140, 0x399f,
    0xb3f0, 0x3c4f, 0xc2e5, 0x373d, 0x3c47, 0xc07d, 0xba92, 0x356d,
    0x4216, 0xc35f, 0x4213, 0x4368, 0x4248, 0xc08e, 0x388e, 0xbe50,
    0x448a, 0xb43b, 0xc13c, 0xbdc7, 0x3662, 0x4314, 0xb807, 0xbc4b,
    0x30b0, 0xb5af, 0x391d, 0xbd78, 0x43ad, 0x3d71, 0x3b86, 0xbe9f,
    0x41c4, 0x3241, 0x3ea3, 0xc0fe, 0x3cd1, 0x3f5e, 0xbb52, 0x3e8d,
    0x3c76, 0xc49a, 0xad52, 0xbc4b, 0x37b2, 0xbc9c, 0x2de9, 0x2daa,
    0x39c0, 0x41c7, 0xbe66, 0x3fbe, 0xc0b8, 0x41de, 0xb3a8, 0xbf2c,
    0xbe27, 0x3ecc, 0x20aa, 0xbb83, 0x9c4c, 0xc526, 0xc18c, 0xb989,
    0x3e99, 0x3da1, 0x35e4, 0x35ba, 0xb603, 0x43cb, 0xbdcc, 0x400d,
    0x3985, 0xc59a, 0xa829, 0x4116, 0xbef1, 0x406c, 0xc270, 0xc03b,
    0xc199, 0xbd19, 0xb7b1, 0x34fd, 0x4001, 0xaf08, 0x4059, 0xc442,
    0x37a4, 0xc3a8, 0xb0e3, 0xb974, 0xbd72, 0x42a3, 0xa87c, 0x40fe,
    0xbd9a, 0x3887, 0xc1fc, 0xba27, 0x3a91, 0xc091, 0x403c, 0xbfbe,
    0xc42d, 0x446c, 0xb6ad, 0x342c, 0x35be, 0xc151, 0x410a, 0xc107,
    0xc11e, 0xb5b6, 0xc434, 0xc056, 0xbe2e, 0x43de, 0xc1a9, 0xb5fe,
    0xc1f7, 0x367b, 0xc0b7, 0xbc5c, 0xbe6f, 0xbf6d, 0x3366, 0x3d49,
    0x3fd7, 0x3fba, 0xbcef, 0x3eb1, 0xba0d, 0xb8f4, 0xc0e6, 0xaef6,
    0x3d15, 0x3f5a, 0xc276, 0x3d82, 0xc0a9, 0x3c17, 0x38c0, 0xc0f2,
    0x3a74, 0x3dc2, 0xc29d, 0xbaf8, 0xbc5b, 0x3e03, 0xb00c, 0xb622,
    0xc07c, 0x3b60, 0xc0b0, 0xb9a7, 0xbb0d, 0x3cdf, 0xbe59, 0xc100,
    0xba9d, 0x4023, 0x407a, 0xbf1a, 0xc043, 0xc12e, 0x3dd2, 0xbb5c,
    0xbcb4, 0x3e18, 0x3d00, 0x424a, 0xc1ce, 0xbdd0, 0x35e0, 0xc21f,
    0xc430, 0xbcfb, 0xb8e2, 0x3749, 0xbd0d, 0x3ce1, 0xbf02, 0x4124,
    0xa0fc, 0xc035, 0x43c3, 0x3c7c, 0x4073, 0x1d97, 0x401a, 0xc156,
    0x4189, 0xc082, 0x42a5, 0x3929, 0x2952, 0x3ed9, 0xc456, 0x3899,
    0xb887, 0xbf89, 0xc05a, 0xc01b, 0x40cd, 0xc1c6, 0xc389, 0xb857,
    0x42ba, 0x4394, 0xc17b, 0x3ae6, 0xb8d8, 0x3e46, 0xb9ea, 0x3b29,
    0xc20b, 0xc48a, 0x38ce, 0x444e, 0xbe04, 0xc337, 0x3a28, 0xbdcc,
    0x4167, 0x3d15, 0xbd31, 0xbb46, 0x44fa, 0xb648, 0xc293, 0xc4e0,
    0x4042, 0x4136, 0xc22f, 0x436e, 0x3729, 0x2594, 0xc185, 0x3728,
    0xc44a, 0x4410, 0xbd6f, 0x4278, 0xbcc9, 0x3f6d, 0xbc3f, 0xba9d,
    0x4129, 0x40f6, 0x3fd4, 0xc0e7, 0x3f43, 0x4465, 0x1931, 0x37ab,
    0x3f31, 0x3ae4, 0x371d, 0x4270, 0xb181, 0x3776, 0xb696, 0x4054,
    0xb472, 0x3e97, 0xb03a, 0x3cc4, 0xc02f, 0xc325, 0x4069, 0xc0f0,
    0xc042, 0xbd73, 0xc2b3, 0xc151, 0x4206, 0xc22a, 0x4587, 0x3d57,
    0xa6b8, 0x42d2, 0xbee3, 0xb797, 0x408e, 0xbb41, 0xbdf9, 0xc536,
    0xc3b0, 0xc0f0, 0xb49c, 0x39cc, 0x446c, 0x3e3c, 0x3dc4, 0x41d9,
    0xc4d7, 0x3cd4, 0x458c, 0x38b5, 0xbeee, 0x3755, 0x411d, 0x4056,
    0x3b3d, 0xc3fa, 0xbe9a, 0x3e70, 0xc4f5, 0x3d66, 0x3c17, 0xc569,
    0x371a, 0x3ee8, 0xb188, 0x2df0, 0x3681, 0xb1e4, 0x342b, 0xb8ee,
    0x398b, 0x37af, 0x326d, 0x4172, 0x3cfd, 0xc567, 0x3e14, 0xbd15,
    0xb85f, 0x3323, 0xbd08, 0xbeaf, 0x3f57, 0x38bb, 0x3a1a, 0x40b6,
    0xc476, 0x2eb4, 0x44bd, 0x3fa6, 0x3d7e, 0xc015, 0x3897, 0x4098,
    0x3c7a, 0xb747, 0xb680, 0x3578, 0x3709, 0x4574, 0x3c6a, 0x4520,
    0x3c61, 0x41e9, 0xb80f, 0x3ea8, 0x4131, 0x427c, 0xbeb1, 0x38f0,
    0xc00a, 0xc01a, 0xbb00, 0x41c4, 0x4128, 0x3cc3, 0x3ad8, 0x38dc,
    0xbeec, 0xbf9e, 0xb889, 0xbb49, 0x4389, 0x3ba9, 0x3af5, 0x4731,
    0x405b, 0xc04c, 0x355c, 0x3c77, 0xc02a, 0xc188, 0x404b, 0x3c48,
    0x3b66, 0x3e30, 0x44e0, 0xc3a3, 0x45d3, 0x39b1, 0xb040, 0xbeb8,
    0xb874, 0x3d18, 0xb4bc, 0xb6e1, 0xc030, 0xc1c9, 0x2dc3, 0xc1f2,
    0x38d7, 0xbdc5, 0xbd08, 0x4439, 0x31c5, 0x3a9f, 0x3cb5, 0x3e62,
    0xc10a, 0xb8bb, 0x2d32, 0x3c41, 0xb6ff, 0x26a2, 0xc0ad, 0x340a,
    0xbfed, 0x3f33, 0x444f, 0xc49e, 0xbfd0, 0xc0e9, 0x4359, 0x400b,
    0x389a, 0x3c75, 0x3e30, 0x30eb, 0x3c43, 0xbc2d, 0xbe1f, 0x402c,
    0x42f0, 0x4057, 0xbf48, 0xbe14, 0x3a5b, 0xbfeb, 0xbe43, 0x36f2,
    0xad0d, 0x3bc2, 0xc01f, 0x3d61, 0xbefc, 0xb68f, 0x3b27, 0xb371,
    0x3fc8, 0xbe21, 0x3f1b, 0x3ec6, 0xbdb0, 0xb267, 0xbe79, 0xb621,
    0x3ca6, 0xc1a4, 0xbb87, 0x46b8, 0xbcad, 0xc119, 0xb99d, 0x4049,
    0x391f, 0x3b1d, 0x295e, 0xbf6e, 0x31ee, 0xc2b6, 0x4169, 0x3d40,
    0x3c22, 0x3c03, 0xad2c, 0x4257, 0x435b, 0xbd02, 0x3044, 0xbb14,
    0xbcb9, 0xc00d, 0xbefe, 0x42a8, 0x3de5, 0xc419, 0xa628, 0xadec,
    0x3f68, 0xb763, 0x4480, 0x3d98, 0xc04f, 0xba87, 0x22ab, 0xc52e,
    0x3db5, 0xc5a1, 0x3fcb, 0xc39e, 0xc2b4, 0xbc43, 0x4214, 0x41e3,
    0x3cf1, 0xc20c, 0xb5e3, 0xc186, 0x30c4, 0x46cb, 0x40ef, 0xc13e,
    0xbe7c, 0x3636, 0xc0ee, 0x3a9f, 0x3d44, 0xbe87, 0x403f, 0x3c07,
    0xc217, 0xb29f, 0xc1e0, 0x3fba, 0xc098, 0x3b69, 0x41f4, 0x3c73,
    0x390a, 0x444c, 0x3b47, 0x3dfa, 0xc00e, 0xb2dd, 0x3dd3, 0xc2b6,
    0xbcda, 0x423d, 0x3f1b, 0xb3c0, 0xc04b, 0x382c, 0xc40b, 0x3706,
    0xc4bb, 0x3a72, 0xc2ea, 0xc5a7, 0x4603, 0x33b9, 0xc48c, 0x3c8f,
    0xc023, 0xc0a3, 0x430e, 0x3c85, 0xb2bc, 0xbcff, 0xb17d, 0x380b,
    0x3c3a, 0xaeb0, 0x3ca6, 0x3d56, 0xc07f, 0xc14b, 0x3fcb, 0x3ebf,
    0x39f9, 0xc276, 0x3cec, 0xbf5d, 0x3f08, 0x3ae9, 0xc322, 0xc241,
    0x4498, 0x3f26, 0x3da8, 0xc20f, 0x44a4, 0x3fd6, 0x3bcf, 0x3eeb,
    0x4253, 0x378e, 0xc0f6, 0x3cf4, 0xbf54, 0xb9d0, 0xc3ee, 0x2aac,
    0x42ce, 0xb7e0, 0xc07f, 0x2e0b, 0xc17c, 0x3cb5, 0x2ed5, 0xc4cc,
    0xbec7, 0x3c2f, 0xc045, 0xb4a0, 0x3e2b, 0x3d57, 0xc019, 0x3694,
    0x394d, 0xbf48, 0x34a5, 0x42a5, 0xbfa4, 0x3011, 0xbde1, 0xbef6,
    0x3edc, 0x39ab, 0xb9a1, 0xc22a, 0xbb7d, 0x4209, 0xc39c, 0x34b5,
    0xc144, 0xb5ee, 0xc380, 0xc022, 0xc122, 0x379f, 0xb78b, 0x45da,
    0x42fc, 0x3af7, 0xc023, 0xbb76, 0xc23e, 0xc2c7, 0x36bf, 0xc47f,
    0xbcf4, 0xc1ac, 0x42ba, 0xac6a, 0xbf20, 0x3a3a, 0xc02c, 0x3885,
    0x3be9, 0x3dcb, 0xbcc4, 0xbe15, 0x3bec, 0xc7e6, 0xb81b, 0xc078,
    0x3cdc, 0xb819, 0x44b9, 0x3973, 0xc049, 0xc11f, 0xbd19, 0x3592,
    0xc04c, 0x4070, 0x41fa, 0xc465, 0x3edc, 0x3ffd, 0xc235, 0x3dca,
    0x3f87, 0xbcc9, 0xb563, 0xc432, 0xbe8e, 0xbd65, 0x4098, 0x3e40,
    0x3e4b, 0xbeae, 0xb90b, 0x374b, 0xc0f8, 0x3fc6, 0x4406, 0xc402,
    0x4464, 0x3984, 0xbdc4, 0x4456, 0xbc88, 0x3d0d, 0x3cd6, 0x4081,
    0x33c4, 0x4248, 0xbd84, 0x3bcd, 0xc0db, 0x417b, 0x1fd7, 0x41b7,
    0x4048, 0x3fbf, 0xb62a, 0x38b6, 0x4200, 0xa925, 0xc3f7, 0xc0e1,
    0x3d36, 0xaab5, 0xb34f, 0xc2d5, 0x426e, 0xc50b, 0x28a6, 0x3c03,
    0x4151, 0x4096, 0x3dd6, 0x3873, 0x4048, 0xa92c, 0x4092, 0xb506,
    0x416a, 0x31c8, 0x3d37, 0x41a5, 0xc4bf, 0xc17c, 0xb4d9, 0xbb98,
    0x267f, 0x3f0b, 0x30af, 0xc3e0, 0x3840, 0x30ea, 0x4339, 0x2c80,
    0x403c, 0x3ae0, 0xb8f3, 0xbb37, 0x37de, 0xc297, 0x3f3e, 0xbbf3,
    0x40e6, 0x3f91, 0xbfb0, 0x310e, 0x2d8c, 0x3cab, 0x39f3, 0x3ca8,
    0xb641, 0x4445, 0x44f9, 0x3e31, 0x4062, 0xbf3b, 0x4028, 0x4153,
    0x35c5, 0xb63f, 0xb0ce, 0xc0cd, 0xbd45, 0xc126, 0xbd4d, 0x44e0,
    0xc3dc, 0xbe18, 0x42bc, 0x402d, 0x4271, 0x3dbd, 0x381a, 0x391e,
    0x42da, 0xbd23, 0xbd97, 0x382c, 0xb2c9, 0xc3fc, 0x400d, 0x3b0f,
    0xc2ab, 0x41ff, 0x4472, 0xc0c5, 0xb7e8, 0xb58d, 0x3ec4, 0x32d9,
    0x3d2e, 0x42b9, 0x3e3a, 0x40c2, 0xc2ac, 0x4267, 0x365c, 0x3c42,
    0xbc67, 0x3912, 0x3d5f, 0x431d, 0x3846, 0x3f38, 0x3dec, 0x3c6f,
    0xb9de, 0xc143, 0xbebb, 0xb423, 0xc2b9, 0xba9a, 0xbc7f, 0xbd00,
    0x3c78, 0xbebd, 0x391e, 0x2deb, 0x425e, 0xc4f6, 0x3c1b, 0x3b63,
    0x3cd1, 0x40be, 0x4106, 0x4281, 0xc063, 0xbfc2, 0x4433, 0xc043,
    0x3c58, 0xc08c, 0xbcd7, 0x349b, 0x403a, 0xb6c3, 0xbce4, 0xbaa4,
    0x41c1, 0x3e37, 0xb624, 0x44a9, 0xbf84, 0xbcda, 0x357c, 0xb7b2,
    0x43e4, 0x3a0d, 0x4213, 0x4127, 0xc752, 0x3d52, 0xbec0, 0x3a8c,
    0x2130, 0x424e, 0x411f, 0x3aaf, 0x38be, 0xc098, 0xb522, 0x424b,
    0xc2ab, 0x42d6, 0x45ad, 0xba95, 0xb4e0, 0xc218, 0x4043, 0xc113,
    0x387b, 0x3d5a, 0x3d6f, 0xc42d, 0x3e87, 0xbd61, 0x3a6d, 0xc052,
    0x3f76, 0x3e3d, 0x2e4a, 0x443f, 0x42c3, 0xb662, 0xbb8e, 0x36dd,
    0x40b6, 0xc011, 0x33b1, 0xc3f5, 0x440e, 0x323a, 0xbec4, 0xba8a,
    0xbfcf, 0xc056, 0x3edb, 0x2bb8, 0xbcba, 0x4113, 0x4463, 0xbf5b,
    0x4120, 0x405e, 0xc10a, 0x35f6, 0x3d4e, 0xc3e7, 0x410b, 0xb9e0,
    0x37bf, 0x3db9, 0x3d43, 0xb2a1, 0xbea0, 0x3594, 0xc29a, 0xc48b,
    0xc0f7, 0x3613, 0xc112, 0xbe14, 0x3df7, 0xc136, 0x3fe0, 0xbf73,
    0xbaaa, 0x4036, 0x3ff8, 0xbeff, 0xc09e, 0x3cd9, 0x427d, 0x433c,
    0xb4b5, 0xc2d5, 0xc109, 0x4344, 0xb8b3, 0xc485, 0xc10d, 0x3813,
    0xbed8, 0x4204, 0x42cb, 0x3a72, 0xc0a7, 0xb593, 0xbd32, 0x396d,
    0x3d1a, 0x3c67, 0x38a0, 0x40e8, 0x3c6c, 0x3bae, 0x3075, 0xbd62,
    0x3c5b, 0xaae6, 0xbb52, 0x3557, 0xc1f1, 0xac2a, 0xbdc4, 0xc433,
    0x3e77, 0xb458, 0xbb35, 0x3f1c, 0x3e44, 0xc323, 0x4294, 0x3eb1,
    0xc03f, 0x421d, 0x25e5, 0x3444, 0xc25b, 0xbcca, 0xaf9f, 0x3c9f,
    0x354a, 0x401a, 0x437c, 0xbe1b, 0x32cb, 0x3ea8, 0xb904, 0xb717,
    0x35e5, 0xc3ac, 0x3d2f, 0x3c05, 0xc2db, 0x3943, 0xc480, 0x4036,
    0xc304, 0xb924, 0x44eb, 0xbd84, 0xbd5c, 0xc4fe, 0xc2a2, 0x4429,
    0xc051, 0x2919, 0x410d, 0x43c9, 0x4174, 0xc471, 0x4569, 0xb9df,
    0xb6c2, 0x3b82, 0xbfba, 0xc4c2, 0xb59e, 0xba8c, 0xc173, 0xb83f,
    0x40e8, 0x3d4e, 0x4234, 0x4085, 0xbbc9, 0x3cb1, 0xc263, 0x3db0,
    0x3f94, 0x4031, 0x4409, 0x42df, 0x3d36, 0x3f52, 0x3a78, 0xab57,
    0xb1e5, 0x42d1, 0x40b6, 0x31b3, 0xbd95, 0x4197, 0x3859, 0x3954,
    0x410e, 0x3bff, 0x40d2, 0xa8ed, 0xc38a, 0xac85, 0xbe06, 0x4084,
    0x3f43, 0x3824, 0xc0f2, 0x41a3, 0xb66a, 0x3d4e, 0xbc06, 0x4341,
    0xc199, 0x3e33, 0xbeee, 0x3ed0, 0xc444, 0xbf86, 0xbbf2, 0xc19a,
    0xb16e, 0x3afa, 0x3e68, 0xbcb3, 0x2c17, 0xc052, 0xbc17, 0x41a8,
    0xb4c7, 0xbc7c, 0x3f59, 0xb807, 0x4047, 0xc1ae, 0xb2f7, 0xc2de,
    0x34d4, 0xa95f, 0x2ee9, 0x3058, 0x4266, 0xbc14, 0x3e56, 0xc2c4,
    0x404b, 0xb865, 0xb41f, 0xc5c1, 0x3048, 0x458f, 0x4106, 0xb3be,
    0xc01a, 0x3f83, 0xc07b, 0xbd3c, 0x3c54, 0x37c2, 0xb8ea, 0xa88b,
    0x3c14, 0xbda9, 0xacb7, 0x3e4e, 0x4298, 0xc0b7, 0xb8a0, 0x402e,
    0x3850, 0xbe86, 0x4055, 0x410b, 0x4356, 0x3961, 0xc197, 0x3e53,
    0xc39a, 0x3c79, 0xbc34, 0x2efa, 0x391f, 0xc14c, 0x3798, 0xb789,
    0xc239, 0xb9a6, 0xc045, 0x3434, 0xc084, 0xc061, 0x3ee8, 0xc08e,
    0xbf63, 0x419f, 0x3cca, 0xbcd2, 0x3d5e, 0x3076, 0x42d5, 0xbdfa,
    0x39ac, 0x314e, 0xb34c, 0x3da1, 0xc24a, 0x283d, 0x3b9c, 0x2fc2,
    0xc300, 0xba79, 0x41bb, 0xb4e9, 0x44ff, 0x3f37, 0x4343, 0x3c47,
    0x3f52, 0xbbdb, 0x3b78, 0x3e04, 0x4316, 0x3ed5, 0x40aa, 0x3400,
    0x4016, 0x402b, 0x3e0e, 0x3cc3, 0x4343, 0xb4e0, 0xc462, 0xbec5,
    0xc425, 0x4407, 0x4198, 0xb13c, 0x4099, 0xc0a5, 0xbac6, 0xb0ec,
    0x3f77, 0xc231, 0xc455, 0x29bd, 0x4782, 0xbd18, 0x41ba, 0xc01c,
    0xab41, 0x4046, 0xbf21, 0x34ee, 0x3968, 0x41a8, 0x4416, 0xc235,
    0x26d4, 0x39b0, 0xb27d, 0xbb69, 0x3a5c, 0xc398, 0xb518, 0x39ce,
    0x3cbb, 0xbcad, 0x3c3e, 0x40cf, 0x40ab, 0xc439, 0x3040, 0xc032,
    0xc368, 0xc2b6, 0xc29f, 0xc31b, 0x3f23, 0xbb43, 0xbbb5, 0xc036,
    0x3c58, 0xb8eb, 0xc466, 0xbae9, 0x3fee, 0xbdeb, 0x426d, 0x3c8a,
    0xc48d, 0xbefd, 0xbc8c, 0xac70, 0xc3ad, 0xac51, 0x3c8f, 0xbdea,
    0xba36, 0x361c, 0x3bb2, 0xbd37, 0x334a, 0x416d, 0x39ce, 0x3cba,
    0xa24d, 0xc14b, 0x359c, 0x4703, 0x312a, 0xb9b0, 0xbafa, 0xbfb9,
    0xc124, 0xc00b, 0x4194, 0x3ff8, 0x3756, 0x41f8, 0xbba0, 0x2cd8,
    0x401d, 0xbe33, 0xc15c, 0x3c84, 0xb21d, 0x3c16, 0xbc74, 0xc126,
    0xae10, 0xb66b, 0xbe3f, 0xbf03, 0x3e49, 0xbf14, 0x3fa7, 0xbe2e,
    0xb00f, 0x3952, 0x3fe5, 0xb630, 0x420e, 0x3bff, 0xc1e2, 0xc06d,
    0xc1e6, 0xa940, 0x4032, 0xbed0, 0xbd87, 0x3ce5, 0xc160, 0x4362,
    0x3e6e, 0xc5b7, 0xc4fd, 0xb829, 0xbf3b, 0xc10d, 0x41ef, 0x3fe6,
    0xb8fc, 0xbda1, 0xb79f, 0xba4b, 0xc59e, 0xbd52, 0x38ee, 0x4079,
    0x3b16, 0x4114, 0xbc0c, 0x402b, 0x3f60, 0xbc8b, 0x3edb, 0xbc65,
    0x4040, 0xaeef, 0xbae8, 0xb5f3, 0x41c8, 0x321d, 0x38ed, 0x4078,
    0x3e55, 0xbfe0, 0xbe99, 0xb5e6, 0x40d9, 0xc263, 0x4307, 0xbdf7,
    0xbc48, 0x3dd1, 0xc089, 0xc029, 0xb718, 0xc0b9, 0x3b0b, 0xc212,
    0xc52a, 0xbd14, 0xb978, 0xc15e, 0xc2bf, 0xc45e, 0xc3ea, 0x431d,
    0x44c5, 0x4114, 0x3c4d, 0x3523, 0x3a0d, 0xb5df, 0xb67b, 0x4110,
    0xac03, 0x3c61, 0xb04a, 0xb623, 0xb992, 0x3a2a, 0xb996, 0x42a5,
    0x3984, 0xbcd3, 0xc0c2, 0x4559, 0x431b, 0x40e2, 0xb8dd, 0x41b4,
    0xc22a, 0x40d2, 0xc14c, 0x3da9, 0x4075, 0xc45a, 0xc149, 0x4442,
    0xc2f7, 0xbf78, 0xbea2, 0xc178, 0x372e, 0x36f9, 0x3662, 0xa1c1,
    0xac51, 0xc446, 0x419c, 0xbe4d, 0x41d4, 0xbd69, 0xbf4b, 0x4219,
    0x4180, 0x3867, 0x2f79, 0xb897, 0x3d87, 0xb9f4, 0x3bd8, 0xc381,
    0x4360, 0x2f27, 0xbe96, 0x3dce, 0xbcd4, 0xc120, 0x38fb, 0xb526,
    0x432d, 0x32db, 0x3f7e, 0x4076, 0x43ac, 0xbc97, 0xb566, 0xbd11,
    0xb098, 0xb825, 0xc3fa, 0x3a4d, 0xb047, 0x4199, 0xaccc, 0x4015,
    0x42e6, 0xba8e, 0xbca5, 0xc245, 0x3c31, 0xc10f, 0xc088, 0x354d,
    0x34bb, 0x40dd, 0x40f7, 0xc3b5, 0xc040, 0xbec4, 0x3d61, 0xc1ad,
    0x3541, 0xbc38, 0x448f, 0x447e, 0xc135, 0xc2b7, 0x3dc4, 0x43bf,
    0x3ac8, 0xbbee, 0xb961, 0x4268, 0xbd54, 0x3ed0, 0xbc34, 0x4429,
    0xc106, 0xbb45, 0x3df4, 0xbd67, 0xc075, 0x3eae, 0xc682, 0x3fbf,
    0x3360, 0x42d5, 0xb955, 0x3ce6, 0xbfca, 0x3f7d, 0x3938, 0x41d0,
    0x4240, 0xb09e, 0xb8eb, 0xbce5, 0xbe30, 0xc5b2, 0x40be, 0xbfe7,
    0xc1d4, 0xb2a2, 0xc32a, 0xa85a, 0xbc91, 0xc0fa, 0xc446, 0xbda3,
    0xbe29, 0xc05b, 0xb485, 0xc0d0, 0x3bba, 0x3bf2, 0xb8ba, 0x3d04,
    0xbb96, 0xc29b, 0xbce6, 0xb852, 0xc40d, 0x38e7, 0x3daa, 0xc246,
    0xc280, 0xbada, 0x33a2, 0xb826, 0xbffc, 0x3cbd, 0xc0c3, 0xc0c7,
    0xad47, 0xc347, 0x3c82, 0xbeac, 0xb5f3, 0x3fdc, 0x4477, 0xc1fb,
    0x4442, 0xc4c5, 0x3e42, 0xbe14, 0x39a7, 0xb7d1, 0xc1a1, 0xb684,
    0x2cd6, 0x3cc6, 0xc397, 0xbdba, 0xb607, 0x4122, 0x4027, 0x42ff,
    0x318e, 0xb888, 0x436a, 0x38a2, 0x4153, 0xbcd9, 0x4021, 0xb4a2,
    0x4499, 0xb918, 0x36b9, 0x3404, 0x3f0a, 0xb070, 0x4064, 0xb4d4,
    0x3701, 0x34f6, 0xbec2, 0xb17f, 0xc023, 0xbbca, 0xbcf7, 0x3c85,
    0xb9ab, 0xbfe5, 0x3936, 0xbeec, 0x42da, 0xb3a1, 0xafdc, 0xc28b,
    0xbdb4, 0xb51f, 0x3ec3, 0x432c, 0xb714, 0x4206, 0xc031, 0x44b5,
    0x2fc7, 0x4050, 0xbbda, 0xbe6c, 0x3b3a, 0xbd1d, 0xc194, 0x4457,
    0xb7e7, 0xb1ab, 0xb494, 0xb9f4, 0xbabc, 0x40a5, 0xb832, 0x39a4,
    0x382e, 0xb2fa, 0xbe5a, 0xba9f, 0x3f99, 0xbfc0, 0xbdf3, 0x43b0,
    0x3cab, 0x3849, 0xc57f, 0xb47e, 0xbde2, 0x3da2, 0x36ab, 0x38c6,
    0x3bd4, 0x37f2, 0xc2ed, 0xc15f, 0x4460, 0x3e4f, 0xc321, 0x3503,
    0xad6b, 0x38df, 0xbaaf, 0x38c0, 0xbd6f, 0x2c0d, 0x438b, 0x2f30,
    0xc418, 0xba8f, 0xba2d, 0xc1ab, 0xb6c3, 0xbe31, 0xbe8a, 0x3c6d,
    0x40c4, 0x3e70, 0x3a3d, 0xc32e, 0xbb97, 0xb193, 0xb4c4, 0x413b,
    0x3b73, 0x39bd, 0xb7b6, 0xbdd1, 0x4101, 0x3c1c, 0xbbf6, 0x38b0,
    0xba52, 0xb79c, 0xbe88, 0x4056, 0x3246, 0x39e5, 0x3f22, 0x4049,
    0xb898, 0xc435, 0xc183, 0x40aa, 0x3eb4, 0x302c, 0xbc4c, 0x38b5,
    0x40d2, 0xbb08, 0x4059, 0x41ff, 0x3abe, 0x39b9, 0xbbac, 0xc0b0,
    0xb9b9, 0xc0fe, 0x4131, 0x3ecb, 0xb61c, 0x3ea8, 0xb7e1, 0xc0c7,
    0xbc9d, 0xb666, 0x4153, 0x38bf, 0x3cca, 0x4285, 0x34a5, 0xac1f,
    0x42b3, 0x3d67, 0x3af1, 0x3579, 0x3b93, 0x3e11, 0xc277, 0x4063,
    0xbaeb, 0xb75a, 0xb4de, 0xb7c8, 0xc286, 0xba60, 0x3ed9, 0xb98d,
    0x2f72, 0xba55, 0x3373, 0x3e78, 0x3cf9, 0x385f, 0xb908, 0xc187,
    0x433a, 0x3ab6, 0x4292, 0x2254, 0x3588, 0xc007, 0x345a, 0x4045,
    0x3e62, 0x4145, 0x4003, 0x4340, 0xc0ca, 0x3113, 0x3a38, 0xc12d,
    0xbbc1, 0xb69b, 0xb9fe, 0xc2c8, 0xbc81, 0xc43b, 0x3e2d, 0x3a99,
    0x401b, 0x3e7d, 0x3ab5, 0x376a, 0xbfee, 0x339c, 0x440f, 0x3fac,
    0x3939, 0x3f60, 0x36f1, 0x3e46, 0xbc17, 0x4184, 0xbe64, 0xbcb2,
    0x4171, 0xb8a6, 0xbce8, 0xc095, 0xb0d5, 0x32a8, 0x385a, 0x3ecb,
    0xbc5e, 0xbb36, 0xbc5e, 0xc31a, 0xc277, 0x3f8a, 0xb5a2, 0x2b83,
    0xbed6, 0x2f69, 0x40e8, 0xc236, 0xc19c, 0xb991, 0xc178, 0x3a25,
    0x4443, 0xbea0, 0xc1e5, 0x3b46, 0xc35a, 0xab0c, 0xbd94, 0x3bc6,
    0x3ce5, 0xb8e0, 0xb304, 0xc337, 0xc2fb, 0xb92a, 0xbf1b, 0xbc6c,
    0xc4a5, 0x3d2f, 0x342f, 0x4131, 0xbf22, 0xb6fb, 0xc51d, 0x3584,
    0x3e53, 0xb637, 0x450e, 0x43ac, 0x3f70, 0x3873, 0xbc09, 0x41d8,
    0xb835, 0xc0fa, 0x3cfd, 0x443f, 0x41ff, 0xb771, 0x42bc, 0x4356,
    0xba27, 0xb4c5, 0xc2a8, 0x3ebb, 0xbc5d, 0xbd62, 0xbc24, 0x2d44,
    0x3e2e, 0xc11a, 0x3980, 0xabe4, 0xc0f0, 0x45bd, 0xba4e, 0xb56f,
    0xba65, 0xc158, 0xbf0b, 0x31d9, 0x430c, 0xbdd5, 0x4478, 0x3f7f,
    0x3e57, 0xc15e, 0x3ced, 0xb5a4, 0xb8d8, 0xb8b0, 0x41e5, 0xbefa,
    0xb3d3, 0x2fd7, 0xbc37, 0xc5e3, 0x448a, 0xc3d9, 0xc196, 0xbad4,
    0xb4e6, 0xc4d2, 0x41dc, 0x2c31, 0x3a72, 0xc186, 0xc63e, 0x3d48,
    0x3a19, 0x35a8, 0xbc30, 0xbbca, 0x4238, 0xbde8, 0x4196, 0x3df5,
    0xbde5, 0xaf6f, 0xc074, 0xb806, 0xbdf0, 0x4161, 0x3acc, 0x4325,
    0xaad1, 0xc1d9, 0x4329, 0xb52e, 0xbb54, 0xbe09, 0x40ce, 0x401d,
    0x3ec5, 0xc499, 0xb33f, 0x3606, 0xc4d1, 0x325d, 0xc0c5, 0x3686,
    0x3943, 0x40e9, 0x3ac1, 0xc1d6, 0xb81e, 0xb552, 0xc0b6, 0x3b91,
    0xbea6, 0xbcda, 0x4407, 0xc1bc, 0x34a6, 0x3b9a, 0xb6e8, 0x40df,
    0x4040, 0xc4e9, 0xbc9f, 0x2262, 0xbf1c, 0xbef1, 0xc419, 0xb8d5,
    0xc4c1, 0xc0d2, 0xbe90, 0xbaba, 0xb89d, 0xb40a, 0xc3bb, 0x40ee,
    0x3e27, 0x407e, 0xc1e6, 0xbdb9, 0xba1b, 0xb87e, 0x4177, 0x4350,
    0xc2f9, 0x3cfb, 0x2303, 0x373f, 0x4231, 0x3f78, 0xc334, 0xc465,
    0x458a, 0xbd83, 0x384a, 0xc0e0, 0xc061, 0x379a, 0xc554, 0x4189,
    0x388b, 0xbff6, 0xc04b, 0xbc85, 0x4083, 0xa425, 0x3ff0, 0xc330,
    0x3e30, 0xb4b6, 0xb965, 0x36d9, 0x37c3, 0x3a0f, 0x41b0, 0xbb0a,
    0x4095, 0x406a, 0x446a, 0x3c6d, 0xb65e, 0x409b, 0xbae7, 0xc10b,
    0x4288, 0xc1ec, 0x37da, 0xc298, 0xb6ef, 0xb8f9, 0xbff5, 0xb504,
    0x2a76, 0x3339, 0x35bb, 0x44cf, 0xb65b, 0xbe09, 0x32a8, 0xbd9f,
    0xb8d9, 0xb91b, 0x3d8e, 0xbd73, 0x37b4, 0x3a40, 0x41e6, 0xc001,
    0x2eb5, 0xc175, 0x4094, 0xbdbb, 0x3e77, 0x4078, 0xbd20, 0xaed3,
    0x455e, 0x42a9, 0xbe25, 0x445a, 0x3c9f, 0xc14a, 0x3c34, 0xb538,
    0xbd73, 0xb951, 0xb15a, 0x379c, 0xbf49, 0x36b2, 0xc00e, 0x38ef,
    0x3f68, 0x3f65, 0xc03c, 0x3904, 0x2eff, 0x365c, 0xbf04, 0xb11a,
    0x4407, 0x268c, 0xbfdc, 0x418c, 0xbc19, 0xba79, 0xbc31, 0x3ce0,
    0xbd7d, 0x3e59, 0xbc32, 0x418b, 0x39b0, 0x338c, 0xb7dd, 0xba3e,
    0xc1bb, 0xc113, 0xc251, 0x44e3, 0xbbec, 0xbf5a, 0x455d, 0xc572,
    0x3d31, 0xc478, 0x4623, 0x3c24, 0xc17d, 0x4017, 0xc031, 0xa561,
    0xb937, 0x37b6, 0x4626, 0x38e6, 0xb774, 0xb654, 0x3e53, 0xbad7,
    0x43cc, 0x361f, 0xbfdc, 0xc306, 0xbbe4, 0x4000, 0x3d84, 0x3a39,
    0x3e79, 0xbb9c, 0xb0a9, 0x3cc6, 0x3a98, 0xbdd8, 0x3c13, 0xc1da,
    0xb565, 0xbdd0, 0xbfae, 0xbc2d, 0xc0ac, 0xbe80, 0xb9dd, 0x2ffe,
    0xc287, 0xba36, 0xc2b0, 0xb570, 0xba55, 0xc1fb, 0x4227, 0xc30d,
    0x3d7f, 0xc34c, 0x416f, 0xba34, 0xbd41, 0xc137, 0x3a37, 0x391c,
    0x3535, 0x42ac, 0x3df6, 0xbf1b, 0xbd4e, 0xb7fc, 0x3bc5, 0x412e,
    0xc0c4, 0x3c5b, 0x3071, 0xbeb4, 0x4064, 0xc071, 0xc1cd, 0x3e41,
    0x3cf6, 0xbd0f, 0x41ab, 0x43d2, 0xb463, 0x42f6, 0xc217, 0x3e0a,
    0xb2a9, 0xbe4d, 0x41ba, 0xc4c2, 0xb821, 0xc4ff, 0x9c05, 0xbc3b,
    0x3faf, 0xc2d3, 0xb8eb, 0xb476, 0xbb0d, 0x4633, 0x3a11, 0x2bbd,
    0x40fc, 0xb146, 0x3ad6, 0x36cf, 0xc34e, 0x3bd8, 0x3b50, 0xc194,
    0xbfb2, 0x4200, 0xbe40, 0x39c9, 0x3c55, 0x3d11, 0xbdb1, 0xbaaf,
    0x445c, 0xbfb5, 0x2e7c, 0x3d3d, 0x388a, 0xc00f, 0x3ff0, 0x2cfa,
    0xc00b, 0xbc72, 0x3c98, 0x383f, 0xbbe0, 0x38ea, 0xbd36, 0x3d0a,
    0xb1ef, 0x3b47, 0x4424, 0x3bf6, 0xc055, 0x43d4, 0x38c5, 0xbe65,
    0x396b, 0x384d, 0x40e8, 0xbec7, 0x44bd, 0xbc93, 0x38d1, 0xb292,
    0xbabd, 0xbe28, 0x345a, 0x4106, 0x3d82, 0x3444, 0xb876, 0xb1da,
    0xb41c, 0xc25f, 0xbfac, 0x3418, 0xbda8, 0xc16c, 0xbb2c, 0x402b,
    0xc164, 0x3cad, 0x4168, 0xb8d7, 0xbb45, 0x2e5d, 0x3a84, 0xbeed,
    0x371f, 0xc090, 0xc019, 0x3d39, 0x3c68, 0x3781, 0xb709, 0x3f4e,
    0xc0ce, 0xbca5, 0xbc69, 0xbbab, 0x442b, 0x38e6, 0xbc49, 0xc097,
    0xbbbc, 0x41c2, 0x4021, 0xc2bd, 0x4317, 0x3ca0, 0x3e64, 0x4195,
    0xc146, 0x3e98, 0x3d30, 0x34c4, 0x307d, 0xbc08, 0xbe40, 0xb91b,
    0xb297, 0xb8ad, 0x4066, 0x4096, 0xbd68, 0xb78e, 0x3de6, 0x3631,
    0x4102, 0xba78, 0xc0dd, 0xbd81, 0xb4ad, 0xb7f0, 0x3d0b, 0x335c,
    0x40af, 0xc021, 0x41fb, 0x3da5, 0xba77, 0x3b55, 0xb521, 0x3129,
    0x2fbe, 0x3b6f, 0xb463, 0xb979, 0xb4db, 0xc271, 0x35ad, 0xbd38,
    0x41bf, 0xc0ca, 0x4296, 0xc6c8, 0xc245, 0xbea0, 0xc0e1, 0x3803,
    0xb406, 0x43b9, 0x36c8, 0x38ac, 0x3c6d, 0x38c1, 0x3167, 0xc4da,
    0xbdc2, 0x3f9b, 0x41fe, 0x3f33, 0xb8e6, 0x3d54, 0xbfc1, 0x3e7c,
    0xbcbf, 0x3d67, 0x2cf0, 0xb49e, 0x37d3, 0xbdbe, 0x3955, 0x3a5e,
    0xc019, 0xbffc, 0xc45d, 0x401c, 0xc41e, 0xc2c5, 0xc38f, 0x417e,
    0x4399, 0x37e9, 0x3d0a, 0xc1a1, 0x34c9, 0x32d7, 0x44db, 0x4418,
    0xc3a5, 0xbc70, 0x40e5, 0x3f17, 0x40a4, 0x3d79, 0x4048, 0xbb5d,
    0xbdd6, 0x429c, 0x3f9f, 0x3927, 0x4152, 0xb3f2, 0x3c88, 0xc224,
    0xc16f, 0x4443, 0x3fb6, 0xac06, 0xbd90, 0x3fa3, 0xbfb0, 0xc110,
    0x4068, 0x42c5, 0xc104, 0xbf47, 0x4336, 0x3cc5, 0xb47e, 0x39d0,
    0x360b, 0x30e2, 0xbb4d, 0x40fe, 0xbc81, 0xbdec, 0x3df9, 0xc3b0,
    0xb9db, 0x3da8, 0xbf10, 0xc472, 0xc263, 0x3d0c, 0xc448, 0x3d9f,
    0x426e, 0x3f8e, 0xc4ff, 0x4035, 0xbd87, 0x3977, 0xb7e6, 0xc494,
    0xc16c, 0x3e6f, 0x400c, 0xc326, 0x367d, 0xc42e, 0xb7d9, 0x3da4,
    0x3bb3, 0xb98e, 0xbd85, 0xbabd, 0x3e85, 0xbc2e, 0xc412, 0x3b55,
    0xbe84, 0xc586, 0xbe1f, 0xc091, 0x45fe, 0xc1e8, 0x4488, 0xb8cc,
    0x37f7, 0x39a2, 0xbeac, 0x32d7, 0x4514, 0x30e6, 0x40f5, 0x3af8,
    0xb9a4, 0xc054, 0xbf58, 0x3d38, 0x4328, 0x441f, 0x408a, 0x38b8,
    0x3cc9, 0x41aa, 0xc1b5, 0xc703, 0x383d, 0x38ea, 0xbca1, 0xb79b,
    0xbf65, 0x3bb7, 0xc064, 0xc4a1, 0xc31c, 0x35e2, 0x3520, 0x400c,
    0x42a7, 0x3158, 0xc2a9, 0x446f, 0x3d62, 0xba14, 0x3c58, 0xbda4,
    0xb4b1, 0x3e56, 0xbe8e, 0x40f7, 0x3a2f, 0x3ba9, 0x3d32, 0xb8b5,
    0xbe22, 0x4048, 0xbca6, 0x340e, 0xb5f3, 0x365c, 0xc1b5, 0x3d0d,
    0xc107, 0xbae4, 0x34cf, 0x3dd5, 0x4003, 0xbe06, 0x44a6, 0xba2d,
    0x2e4a, 0xb1da, 0x4446, 0xc243, 0x3d7c, 0x3af8, 0x3c2d, 0xbef6,
    0x41c3, 0xbd7a, 0x3092, 0xbd5a, 0x3f5c, 0x423f, 0x41f1, 0x3839,
    0xc0df, 0xbfaf, 0xc00a, 0xc1b7, 0xb409, 0xa6b1, 0xba96, 0x42b6,
    0xc18c, 0xc152, 0xbc1a, 0xb09a, 0x4053, 0x3ef9, 0x428e, 0x3d0c,
    0x3e33, 0xb833, 0x38b1, 0x2b0f, 0x3dc7, 0xbccc, 0xbb26, 0x3f25,
    0xba85, 0xbd12, 0xc270, 0x4221, 0xb370, 0xbe62, 0x33e4, 0x3964,
    0xb5b8, 0xb4f6, 0x3d1b, 0xb129, 0xc11a, 0xc633, 0x418d, 0xb84d,
    0xbd79, 0x3a48, 0x3c8e, 0x2902, 0xbe05, 0xbde2, 0x4369, 0x40e3,
    0xb1f3, 0xbeb0, 0xba8c, 0x3c9d, 0xc42a, 0x4240, 0x3c98, 0x36ea,
    0x3a2a, 0xb8c5, 0xc5a5, 0x4085, 0xae58, 0x2c1a, 0x3127, 0xc07b,
    0x3b9a, 0x3d50, 0x3ee0, 0x40f0, 0xbe9b, 0x3cdd, 0xc40d, 0xb560,
    0xc363, 0xb52e, 0x3e4d, 0xb59e, 0x40c5, 0xc180, 0x4184, 0x40ec,
    0xc164, 0x3e6d, 0x3ece, 0x354f, 0x469a, 0xc004, 0x4252, 0x4336,
    0x3c99, 0x3427, 0x448f, 0x3ccf, 0xc22a, 0x4148, 0xb316, 0x40b3,
    0xb815, 0xc045, 0xc46d, 0xb41a, 0x44a7, 0x44e5, 0xbcbd, 0xbc99,
    0x3ae9, 0xc1b8, 0xb84a, 0x4189, 0x3e08, 0x3919, 0x3566, 0x3dcd,
    0x3c39, 0x3fab, 0x3ea7, 0xb88b, 0x3c22, 0x3bc2, 0x43ab, 0xb090,
    0xc1c3, 0xb4ba, 0xc187, 0xc481, 0x4649, 0xbd45, 0x3c15, 0x3c7d,
    0x3b42, 0xbdf9, 0x4144, 0xb9d5, 0xac78, 0x4152, 0x3e4d, 0xc15d,
    0xbd6f, 0xb3b6, 0x3d12, 0x3a93, 0x4150, 0x3b04, 0xbc1a, 0x2bef,
    0x38a3, 0xc040, 0x4395, 0x4031, 0xbd15, 0xc02d, 0x3c8c, 0x410b,
    0xaf89, 0x3103, 0x4116, 0x35c9, 0x406f, 0x3c67, 0x41d7, 0xc0c6,
    0x3d30, 0xbd69, 0xbbfc, 0x4006, 0xbfb8, 0xc16c, 0x3acf, 0x4120,
    0x3e58, 0x44a1, 0xbcf9, 0x45a2, 0xc004, 0x3da3, 0xb03e, 0xb83f,
    0xbe1a, 0xb30b, 0xc22b, 0xc124, 0x427e, 0x3c23, 0x3b3b, 0xbc9a,
    0x3eaa, 0x257e, 0xc2fa, 0xbfa9, 0xc0a5, 0x420f, 0x38b0, 0x3819,
    0x43c5, 0x2e38, 0x3ca1, 0x4461, 0x386d, 0xbd79, 0x4131, 0xbcef,
    0xc2ae, 0xba73, 0xbe16, 0xbdd8, 0x4120, 0x3461, 0x41b2, 0xc17e,
    0x42db, 0x3012, 0xc138, 0x123f, 0xb95d, 0x42db, 0xbe4c, 0xb660,
    0x3ec1, 0x4433, 0x32ba, 0x4294, 0xbb02, 0xc0df, 0xb0d5, 0x39ee,
    0x40b4, 0xb7c8, 0xc2f2, 0xb816, 0x3b6a, 0x3b1c, 0x354c, 0xc555,
    0x39cb, 0x3828, 0x40a0, 0xbf1e, 0x4083, 0x3e4c, 0x3eb0, 0x3030,
    0xc4a6, 0xc344, 0x42cd, 0xb64f, 0x3c57, 0x3a06, 0xc471, 0x326c,
    0x406f, 0x3d59, 0xc3d7, 0x3c20, 0xc04a, 0xaf4f, 0xc069, 0x340d,
    0x41e4, 0x4132, 0x3c95, 0xba04, 0xb5f5, 0x400b, 0x3708, 0x40dc,
    0xb718, 0x3f0d, 0xb4da, 0xb86f, 0xbee5, 0xb446, 0xc381, 0xad1c,
    0xbf2b, 0xc034, 0x41b3, 0xbb1f, 0xbf25, 0x3125, 0xb99d, 0xb94b,
    0xb676, 0x44e1, 0x3589, 0xbb40, 0xb63c, 0x3e73, 0x3efb, 0x3d0a,
    0x442e, 0xb7d3, 0xbe0a, 0x3a46, 0x457a, 0xbd9e, 0x3c31, 0xc1db,
    0x3c83, 0x4087, 0xb91b, 0xbcd4, 0x400e, 0xb643, 0x4451, 0x40fc,
    0xc027, 0x3a58, 0xb088, 0xc49c, 0x3f90, 0xc1ae, 0x41aa, 0x3c0c,
    0x42fe, 0x4206, 0xbe4f, 0x3e4e, 0x3620, 0xbf72, 0xbe56, 0xc497,
    0xc272, 0xbed9, 0xc408, 0xc55f, 0x299e, 0xc33f, 0xc121, 0x40d3,
    0x3356, 0xb905, 0x446d, 0x3fcf, 0xb312, 0xb826, 0xb7bd, 0x4100,
    0x376c, 0xb43a, 0xc36f, 0xc0c5, 0xc2d7, 0x390f, 0x40d8, 0xc0a0,
    0xc22e, 0x3d66, 0x4420, 0x455c, 0xafaa, 0x3a1f, 0x44f3, 0xbb2a,
    0x4209, 0xbdd4, 0x40d2, 0xc0da, 0x36a3, 0xbc0f, 0xc4fa, 0xbb31,
    0x3dca, 0xb7cb, 0x3e00, 0x3a50, 0xbd9e, 0x4006, 0x31c2, 0x38db,
    0xbc0d, 0xbfb3, 0x23d1, 0x3b9e, 0x37d2, 0xbfce, 0x3878, 0xb8ff,
    0xbe61, 0xc237, 0x447f, 0xc1c6, 0xbc2b, 0xc60d, 0xbcb6, 0x3ab2,
    0x3c5d, 0xc18e, 0xc134, 0xb58e, 0xbc61, 0x3b62, 0x3963, 0x3951,
    0xbc3d, 0xc059, 0xc03c, 0x4148, 0x41c9, 0xc26d, 0xb7ba, 0xa1c3,
    0xc1c6, 0x438d, 0x3a2f, 0xc40e, 0xbfe1, 0xb88e, 0x4089, 0x3f65,
    0x41ee, 0xc03b, 0x3d00, 0xc0b2, 0x3d9b, 0x3fe4, 0xc396, 0xb506,
    0x4337, 0xaafb, 0xc363, 0x412c, 0x3c24, 0xc483, 0xb9a5, 0xc122,
    0xbc7b, 0xbd59, 0x2c51, 0x433e, 0x3db4, 0xbec7, 0x4033, 0xb7d9,
    0xb8d1, 0xb588, 0xb44f, 0xb7ce, 0x3103, 0xb327, 0x3a84, 0x3c48,
    0xc207, 0xb056, 0x3c8b, 0xba2e, 0xb429, 0xba75, 0xb609, 0x3989,
    0x31a8, 0xc09d, 0xb9ce, 0x3be9, 0x3df7, 0x3eef, 0xbee7, 0xc1d6,
    0xbd82, 0x3b03, 0x3c21, 0x422f, 0x9bf8, 0x4307, 0xbef1, 0x42c7,
    0xb833, 0xbf66, 0x3d49, 0x4197, 0xbf10, 0x4490, 0xb886, 0xbe95,
    0xbb28, 0x3a71, 0x437f, 0x4003, 0x3eb6, 0x3b0e, 0xc486, 0x3e17,
    0x3921, 0xbbb5, 0x3c8b, 0x42ed, 0xc0f6, 0x3f82, 0x402c, 0xba14,
    0xbbd5, 0x4156, 0xb6f4, 0x3c1e, 0xbe9b, 0xc10d, 0x41be, 0xc598,
    0x3889, 0x405e, 0xb5f7, 0xc126, 0x3ec6, 0xbc3e, 0x439a, 0x3ebb,
    0xbcfd, 0x35bb, 0x37be, 0xc0a9, 0xc4b6, 0x3d6b, 0xc683, 0xbf40,
    0x3698, 0x43e5, 0x3b10, 0x395a, 0x3ed3, 0x36ac, 0xc0ba, 0xc027,
    0xc491, 0x40ac, 0x3e64, 0x43ba, 0xbe24, 0xc015, 0x24a0, 0xc33d,
    0xc1fa, 0xc250, 0xc11c, 0xc293, 0xc4ab, 0xc2d7, 0xc04b, 0x3f27,
    0x40c0, 0xbb59, 0xc1ce, 0x3c6f, 0x40f6, 0xbdef, 0x42df, 0x3fee,
    0xb663, 0x659a, 0x4154, 0x415d, 0x3a4e, 0x3c95, 0xb516, 0xbd29,
    0x3f55, 0xbf77, 0xbf69, 0xbffa, 0x422b, 0xc089, 0xc366, 0xb811,
    0x4317, 0x3eb7, 0x3a9d, 0xb41c, 0x4407, 0x432e, 0x2f2e, 0xa96a,
    0xbde5, 0xbc8b, 0xc16f, 0x415c, 0xc39f, 0x41bc, 0xc1e5, 0xbc5f,
    0x4301, 0xbeec, 0x3f51, 0xc0a8, 0xc064, 0x4525, 0x425d, 0x3acd,
    0x34fc, 0x3ab3, 0x30bb, 0xb5df, 0xbe8f, 0x3e1c, 0xc2ed, 0x423a,
    0xbd12, 0x4117, 0x4331, 0xc221, 0xaaee, 0x415b, 0xbe34, 0xc1d9,
    0x44ca, 0x3c84, 0xc186, 0x3899, 0x44ec, 0xc508, 0x3cea, 0xb2d3,
    0xbc8e, 0x2628, 0x3d67, 0xc142, 0xbaa4, 0x2de5, 0x3745, 0x3b87,
    0x44c6, 0xc427, 0x3962, 0xb51a, 0x426e, 0xbcd3, 0x3845, 0xc2c0,
    0x420d, 0xc10e, 0xc162, 0xb626, 0xb29d, 0x3c5a, 0xc036, 0x3e9a,
    0xc2f9, 0xb855, 0xc14d, 0x38e9, 0xb476, 0x36a9, 0x35c9, 0xc49c,
    0x378e, 0xb741, 0x386b, 0xbe52, 0x39b8, 0xbd52, 0xbd4e, 0x40b1,
    0x3e1b, 0x42a5, 0x4229, 0xc6a7, 0xc463, 0x4270, 0xb145, 0x395d,
    0xc0c7, 0xc612, 0x4050, 0xc10f, 0xb7cd, 0x2f49, 0xb565, 0xb926,
    0x36f5, 0xb7ed, 0xc3dc, 0x4332, 0xc261, 0x4316, 0x307b, 0xbca7,
    0x3c7b, 0xb849, 0xbac9, 0xb4a8, 0xb893, 0xbb50, 0xb7f0, 0xb873,
    0xc0f4, 0xc180, 0x4155, 0xb1b3, 0x382a, 0x43e7, 0x4064, 0x3638,
    0xc23d, 0xbc33, 0xbc2f, 0x1eb9, 0xba24, 0xc173, 0xbc4e, 0xbd6f,
    0xb867, 0xbd48, 0x3cd8, 0xc117, 0x37c3, 0x39de, 0x2fb4, 0xbc4f,
    0x3bf4, 0x3e58, 0xbdf2, 0xc502, 0xc0e2, 0x4072, 0x1f18, 0x443b,
    0xc0b7, 0x443e, 0x43a7, 0xbe6d, 0x1f31, 0xba92, 0x42f9, 0xbd72,
    0x4214, 0x3c23, 0x3ea3, 0xb8a7, 0x3b52, 0xbe21, 0x4416, 0x3c96,
    0xbd5a, 0xbde8, 0x3fc1, 0x4063, 0xb8cf, 0x39a7, 0x3f06, 0x3b95,
    0xc32c, 0x2f3b, 0xbfc5, 0xb580, 0x4283, 0xaa2f, 0xbc4a, 0x431c,
    0xbd60, 0xbecb, 0xc043, 0x3f82, 0xb823, 0x4484, 0xc1c5, 0x3d3d,
    0x4174, 0xbd01, 0x3d28, 0xbc17, 0xc01f, 0xbcf7, 0x3a36, 0xa346,
    0x30da, 0x4212, 0x41ed, 0x3166, 0xc566, 0xbf85, 0xbd41, 0x3db7,
    0xbacc, 0x37a8, 0xbff8, 0x36b0, 0xc0f5, 0xc1ae, 0x3c52, 0x4016,
    0xbcf8, 0xc2fe, 0x3d13, 0x37fd, 0xb8d0, 0xc16e, 0x3f11, 0x451e,
    0x405e, 0x4563, 0x412b, 0x3e8c, 0xc459, 0x4271, 0xbbbb, 0xc4f5,
    0xb7a5, 0xc3dd, 0xaba7, 0x3f4a, 0x441e, 0xc0a4, 0xc102, 0x32e9,
    0x42ca, 0xbac8, 0xadb4, 0xbd2d, 0xbe49, 0xc053, 0xc005, 0xbcec,
    0xc6e0, 0x162f, 0xc088, 0xc1d1, 0xc3c4, 0x4063, 0x3b22, 0xbd5c,
    0x40d8, 0xb40d, 0xbb3f, 0xc174, 0xb382, 0xbd55, 0x2cdf, 0xb9fc,
    0xb722, 0x1fe0, 0x2d05, 0x3f82, 0x386d, 0xc408, 0x3f21, 0xbf0c,
    0x3759, 0x3154, 0xc2fe, 0x3acd, 0x3ff3, 0x3c03, 0x342e, 0x3c8c,
    0x37c8, 0xc25e, 0xc138, 0x3dd3, 0x4214, 0x4287, 0x359c, 0xc0f9,
    0xbe7c, 0x4107, 0x40ef, 0x3b7a, 0xc4de, 0xb8b2, 0x3ec0, 0xb9f8,
    0xb5a9, 0xbd09, 0xbe88, 0x2ddf, 0xc477, 0x3f88, 0x3a0a, 0x417a,
    0xbe82, 0x3b3f, 0x3c44, 0xbb5e, 0x3e2d, 0xbdcc, 0xc3f4, 0xb4f3,
    0xc35e, 0x3cde, 0x424c, 0x40e8, 0x30d4, 0xb5fb, 0xbe5e, 0xbfa2,
    0xc515, 0xb371, 0x42ef, 0xb8a7, 0x3da2, 0x3e6f, 0xbe80, 0x38c5,
    0xc189, 0x249c, 0x4572, 0xc575, 0x3117, 0x4164, 0x464c, 0xc01a,
    0xa3d5, 0x3cd9, 0x3bcb, 0xbc30, 0x3896, 0x45aa, 0x439e, 0x410d,
    0xbdad, 0xb29e, 0xbdeb, 0x3bc9, 0xbeea, 0x414f, 0x425a, 0x3e50,
    0xb96f, 0xb51a, 0x3e06, 0x425e, 0x2ed9, 0xb8bb, 0x4038, 0xbdb4,
    0xbed5, 0x420b, 0x419e, 0xb35b, 0x426f, 0x34c3, 0x39ea, 0x4261,
    0xb02f, 0xc1cf, 0x40ba, 0x2c3d, 0xbc94, 0xbbdd, 0x417f, 0xc440,
    0xbc6c, 0xc575, 0x3d20, 0xc475, 0xc085, 0x429e, 0x32ec, 0xbdbb,
    0x23ab, 0xc11e, 0x440d, 0x3bb6, 0x3e0e, 0xbf55, 0x4465, 0x28c5,
    0x4328, 0xbafc, 0xb933, 0x447b, 0xc46a, 0x4542, 0xbe3f, 0x3d11,
    0x434d, 0x42fd, 0xba1f, 0xb833, 0xb9b1, 0x42ce, 0x4266, 0x3f8f,
    0x401b, 0x401f, 0x2ca1, 0x4050, 0x3465, 0xbe4d, 0x40e4, 0x42a0,
    0x3b6a, 0xbcbc, 0x35ed, 0x41d0, 0x3812, 0x40bf, 0x3ccc, 0x3ca4,
    0xc47b, 0xc1ac, 0x41a5, 0xbb0c, 0x3ce4, 0xc465, 0x3b6c, 0x38d0,
    0x3abf, 0xbfd4, 0x3cd6, 0xc0df, 0x3fe5, 0xaef7, 0x40ef, 0x394b,
    0xc440, 0x3808, 0x3946, 0x3ee0, 0xc401, 0xbe93, 0x4644, 0x425a,
    0xc0e8, 0x34c8, 0xc04f, 0x39b1, 0xbf5f, 0xc52d, 0x3d90, 0x4006,
    0xb93d, 0xc0f0, 0xc07a, 0x386c, 0xbb4d, 0xc4c8, 0x411f, 0xbefa,
    0x40db, 0x3bbd, 0x3a24, 0xbe5e, 0xbbd8, 0xbb0b, 0xbd63, 0xbc89,
    0xb9e2, 0x413e, 0xc38b, 0x4194, 0xbeb2, 0x3063, 0x407c, 0x35d0,
    0x3aad, 0xaf85, 0x35e4, 0x41be, 0xc25e, 0xc1a1, 0x34f3, 0x2925,
    0xc00f, 0xc0f0, 0x3f20, 0x3a90, 0x3e73, 0x366b, 0xbe6c, 0x3e5f,
    0xbc72, 0x4090, 0x412e, 0xb6d7, 0x3ebc, 0x3c42, 0x43ac, 0x3d1b,
    0x3d3b, 0xc08c, 0xb822, 0xbb75, 0xb920, 0x3ec8, 0xb5dc, 0x3dc9,
    0x3125, 0xbe4e, 0x3787, 0xc30c, 0x40fc, 0xb4e2, 0x35cb, 0xb3ec,
    0x418d, 0xb51e, 0xc05a, 0xc5b1, 0x3f9f, 0x437c, 0xb2aa, 0x44de,
    0xba29, 0x3e4b, 0x3641, 0xc2aa, 0x372b, 0xb8f9, 0xb600, 0xc112,
    0x4007, 0x3216, 0xb92e, 0x4023, 0x45cf, 0x3c37, 0xc188, 0x3f6f,
    0xc1b2, 0xb91f, 0x404b, 0xb89a, 0x3c24, 0xc240, 0x4478, 0x38e8,
    0x38ce, 0x35b7, 0xba96, 0xc223, 0xb9bc, 0x4046, 0x3c5e, 0x3caa,
    0xbb09, 0xc16a, 0xc044, 0x46af, 0x34e7, 0xb938, 0x4034, 0x3d13,
    0x403e, 0x4440, 0x4271, 0xac1e, 0xc09a, 0xbd45, 0xc098, 0xc40c,
    0xc178, 0x41a0, 0x3fc2, 0xc05d, 0xba82, 0xba1a, 0x4174, 0x3b1e,
    0x3d8a, 0x342c, 0xbe3e, 0x3806, 0xc25f, 0x424b, 0xb51b, 0x3fbd,
    0x4596, 0x427f, 0xbf71, 0x3d82, 0x3fa4, 0x3086, 0xbb98, 0x3f0e,
    0xc12e, 0xc14e, 0xc1c0, 0xbe66, 0xbc2d, 0x3c68, 0x4163, 0xc0e2,
    0x3fba, 0xbd4e, 0x3e8e, 0x4258, 0xc11c, 0xc116, 0x4187, 0xbdc3,
    0x41e8, 0x4118, 0xbfa4, 0xb59b, 0xbcf8, 0xbde3, 0xc0b2, 0x40bd,
    0x3f73, 0x4330, 0xc088, 0x3cbe, 0xaca3, 0x3df7, 0xc211, 0x40f1,
    0x4080, 0xbfaa, 0xbe37, 0x425f, 0x40e8, 0xbd0d, 0x41f3, 0xbce0,
    0x3ee7, 0x407c, 0xbbe2, 0xc438, 0x3d6c, 0x3d67, 0x40c9, 0xb843,
    0xba5c, 0x3e08, 0xc18b, 0xc356, 0xc25d, 0x3ef5, 0x3627, 0x4361,
    0xc0cc, 0xb0ff, 0x3ca4, 0x40d0, 0xb564, 0xb967, 0x3fd8, 0x47ba,
    0xbc1c, 0xbbab, 0xbf8d, 0x4028, 0x458f, 0xb765, 0x4072, 0x3420,
    0x4304, 0x2e1d, 0x3067, 0xabca, 0xbf60, 0xc184, 0xc2ac, 0x44bc,
    0xb54b, 0x37b4, 0x3d50, 0x3966, 0x4108, 0x3004, 0xbc32, 0x3783,
    0x40fe, 0x4315, 0x3f43, 0x4174, 0x4466, 0xc2d2, 0x40c1, 0x3a58,
    0xaa53, 0xc208, 0x36af, 0xc1a9, 0x3eb9, 0x3d8e, 0xbc43, 0x2d53,
    0x3e0c, 0xba02, 0xc1e5, 0xc191, 0xc664, 0x3caa, 0xbdc7, 0x401e,
    0xb8e1, 0xb9ac, 0x36f3, 0xc34d, 0xc029, 0xbe97, 0x3440, 0xc221,
    0xc403, 0x420e, 0x3233, 0x417f, 0x42ce, 0x3d7e, 0x3373, 0x3f13,
    0x3c3b, 0xc4ec, 0x34c6, 0x339e, 0x3836, 0xb92e, 0x3d6d, 0x3380,
    0xbc64, 0xc33e, 0xb08f, 0x2bb7, 0xc008, 0xc34d, 0x36c9, 0x3909,
    0xbf9f, 0xbd8f, 0xbc3b, 0x3f30, 0xc5fb, 0xbe04, 0xbf11, 0x36c2,
    0x38dc, 0xc4bd, 0xb84c, 0x35d5, 0x4001, 0x3ed1, 0x410a, 0x3fef,
    0xc484, 0xc002, 0xbcfa, 0xa82f, 0xb2d2, 0x4571, 0x3ea6, 0xc0ee,
    0x3ff8, 0xc4f0, 0xbb62, 0x381b, 0x404a, 0xb303, 0x459b, 0x426d,
    0xc10b, 0xba35, 0xc085, 0xc567, 0x3ecd, 0x2ff6, 0xbf8c, 0x4241,
    0x3ae8, 0x3a0a, 0x3dca, 0xb792, 0xbdc6, 0x3b66, 0x40b8, 0x3acf,
    0x427a, 0x3972, 0xc0eb, 0x4458, 0x4018, 0x22ce, 0x3ac0, 0xba5a,
    0x4128, 0x38e2, 0x3783, 0xb1a6, 0x3c18, 0x4177, 0x3a84, 0x3a2b,
    0xbabc, 0xbf4f, 0x3c74, 0xc43d, 0x3889, 0x384c, 0x4004, 0x2abb,
    0xc57d, 0xb60a, 0xc1cc, 0x3563, 0x3f1c, 0xb916, 0xb8c3, 0xc364,
    0x3a6c, 0x411e, 0x382f, 0xb4ec, 0x3cb3, 0xbd31, 0x4147, 0xc032,
    0xc43b, 0x3ced, 0xc351, 0x4549, 0xc3f1, 0xc011, 0x41e7, 0x3e81,
    0xb877, 0x41a5, 0x3894, 0x4473, 0xc03f, 0x30dc, 0xbce8, 0xc07e,
    0x40ca, 0x3d34, 0x3a8d, 0xbddc, 0x4427, 0x442f, 0x3ad4, 0x3afe,
    0x3f11, 0x3dfb, 0x412f, 0xba59, 0x44b8, 0xbe1e, 0xc394, 0x38d8,
    0x419b, 0xc470, 0x3c3a, 0xb8e1, 0xbf95, 0x3e45, 0x408f, 0xc147,
    0xbb8f, 0xc414, 0x3c8f, 0x40d4, 0xb7d9, 0xb20d, 0x429a, 0xc052,
    0xc26d, 0x4271, 0x3f89, 0x4197, 0xbcd9, 0xc3e0, 0x26ef, 0xbc29,
    0x3d32, 0xaf72, 0x3ba9, 0x3a31, 0x3476, 0x2bb7, 0x3d6c, 0xb95e,
    0x3ebe, 0xb9ed, 0xb912, 0x4085, 0xbcd6, 0xbdf1, 0xb941, 0x421c,
    0xbe88, 0xb30c, 0x39b9, 0xb869, 0x3ddf, 0xa650, 0xc31b, 0xbcad,
    0x4116, 0xbe2b, 0x43a3, 0x3ee9, 0xbd76, 0x3b55, 0x32c0, 0xc50a,
    0xbbd0, 0x4244, 0xa66b, 0x3df1, 0x433e, 0x40fd, 0xc25c, 0x461b,
    0xc5da, 0x40d3, 0x3db9, 0x43ee, 0x3f67, 0xc2f7, 0x3ae0, 0x44ab,
    0xc090, 0xbe33, 0xa020, 0xbc68, 0x3cf8, 0xbf8a, 0x3de2, 0x4050,
    0xc1b8, 0x3297, 0xbd62, 0x417b, 0xb8e1, 0xb8f1, 0x3ce0, 0xc24e,
    0x2631, 0xc100, 0xc5b2, 0xc56b, 0xbc72, 0xc4b5, 0x4251, 0x443c,
    0xbd45, 0xc08c, 0xb8c3, 0x43ed, 0xbfbd, 0x3a76, 0xbac9, 0x4083,
    0x4266, 0x32c6, 0xb403, 0xc09d, 0x409a, 0xb15d, 0x35bb, 0x4197,
    0xbf29, 0xc525, 0x3ca5, 0xb6db, 0xbd03, 0xc3e6, 0x3890, 0xb8cb,
    0x3fb9, 0xb9f4, 0x3b59, 0x3de6, 0xc43f, 0xc07f, 0xbd3d, 0x41c9,
    0x42fc, 0x351f, 0xbf43, 0xacf3, 0x2e72, 0xc333, 0xb980, 0xbbe4,
    0xc2c4, 0xc2e4, 0x3f1f, 0xc0d1, 0x3f26, 0xc329, 0x4119, 0x464c
    };

static const uint16_t in_cfft_step_16[32] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0
    };

static const uint16_t in_cifft_step_16[32] = {
    0x4733, 0x0, 0xbb33, 0x4486, 0x0, 0x0, 0xbb33, 0x3d63,
    0x0, 0x0, 0xbb33, 0x38d0, 0x0, 0x0, 0xbb33, 0x31bb,
    0x0, 0x0, 0xbb33, 0xb1bb, 0x0, 0x0, 0xbb33, 0xb8d0,
    0x0, 0x0, 0xbb33, 0xbd63, 0x0, 0x0, 0xbb33, 0xc486
    };

static const uint16_t ref_cfft_step_16[32] = {
    0x4733, 0x0, 0xbb33, 0x4486, 0x0, 0x0, 0xbb33, 0x3d63,
    0x0, 0x0, 0xbb33, 0x38d0, 0x0, 0x0, 0xbb33, 0x31bb,
    0x0, 0x0, 0xbb33, 0xb1bb, 0x0, 0x0, 0xbb33, 0xb8d0,
    0x0, 0x0, 0xbb33, 0xbd63, 0x0, 0x0, 0xbb33, 0xc486
    };

static const uint16_t in_cfft_step_32[64] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0
    };

static const uint16_t in_cifft_step_32[64] = {
    0x4b33, 0x0, 0xbb33, 0x4892, 0x0, 0x0, 0xbb33, 0x41ef,
    0x0, 0x0, 0xbb33, 0x3ebc, 0x0, 0x0, 0xbb33, 0x3c63,
    0x0, 0x0, 0xbb33, 0x39e9, 0x0, 0x0, 0xbb33, 0x37b2,
    0x0, 0x0, 0xbb33, 0x345e, 0x0, 0x0, 0xbb33, 0x2dac,
    0x0, 0x0, 0xbb33, 0xadac, 0x0, 0x0, 0xbb33, 0xb45e,
    0x0, 0x0, 0xbb33, 0xb7b2, 0x0, 0x0, 0xbb33, 0xb9e9,
    0x0, 0x0, 0xbb33, 0xbc63, 0x0, 0x0, 0xbb33, 0xbebc,
    0x0, 0x0, 0xbb33, 0xc1ef, 0x0, 0x0, 0xbb33, 0xc892
    };

static const uint16_t ref_cfft_step_32[64] = {
    0x4b33, 0x0, 0xbb33, 0x4892, 0x0, 0x0, 0xbb33, 0x41ef,
    0x0, 0x0, 0xbb33, 0x3ebc, 0x0, 0x0, 0xbb33, 0x3c63,
    0x0, 0x0, 0xbb33, 0x39e9, 0x0, 0x0, 0xbb33, 0x37b2,
    0x0, 0x0, 0xbb33, 0x345e, 0x0, 0x0, 0xbb33, 0x2dac,
    0x0, 0x0, 0xbb33, 0xadac, 0x0, 0x0, 0xbb33, 0xb45e,
    0x0, 0x0, 0xbb33, 0xb7b2, 0x0, 0x0, 0xbb33, 0xb9e9,
    0x0, 0x0, 0xbb33, 0xbc63, 0x0, 0x0, 0xbb33, 0xbebc,
    0x0, 0x0, 0xbb33, 0xc1ef, 0x0, 0x0, 0xbb33, 0xc892
    };

static const uint16_t in_cfft_step_64[128] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0
    };

static const uint16_t in_cifft_step_64[128] = {
    0x4f33, 0x0, 0xbb33, 0x4c94, 0x0, 0x0, 0xbb33, 0x4611,
    0x0, 0x0, 0xbb33, 0x4330, 0x0, 0x0, 0xbb33, 0x4108,
    0x0, 0x0, 0xbb33, 0x3f9d, 0x0, 0x0, 0xbb33, 0x3e02,
    0x0, 0x0, 0xbb33, 0x3cdb, 0x0, 0x0, 0xbb33, 0x3bf2,
    0x0, 0x0, 0xbb33, 0x3a87, 0x0, 0x0, 0xbb33, 0x3957,
    0x0, 0x0, 0xbb33, 0x3851, 0x0, 0x0, 0xbb33, 0x36d0,
    0x0, 0x0, 0xbb33, 0x3527, 0x0, 0x0, 0xbb33, 0x3337,
    0x0, 0x0, 0xbb33, 0x3046, 0x0, 0x0, 0xbb33, 0x29a9,
    0x0, 0x0, 0xbb33, 0xa9a9, 0x0, 0x0, 0xbb33, 0xb046,
    0x0, 0x0, 0xbb33, 0xb337, 0x0, 0x0, 0xbb33, 0xb527,
    0x0, 0x0, 0xbb33, 0xb6d0, 0x0, 0x0, 0xbb33, 0xb851,
    0x0, 0x0, 0xbb33, 0xb957, 0x0, 0x0, 0xbb33, 0xba87,
    0x0, 0x0, 0xbb33, 0xbbf2, 0x0, 0x0, 0xbb33, 0xbcdb,
    0x0, 0x0, 0xbb33, 0xbe02, 0x0, 0x0, 0xbb33, 0xbf9d,
    0x0, 0x0, 0xbb33, 0xc108, 0x0, 0x0, 0xbb33, 0xc330,
    0x0, 0x0, 0xbb33, 0xc611, 0x0, 0x0, 0xbb33, 0xcc94
    };

static const uint16_t ref_cfft_step_64[128] = {
    0x4f33, 0x0, 0xbb33, 0x4c94, 0x0, 0x0, 0xbb33, 0x4611,
    0x0, 0x0, 0xbb33, 0x4330, 0x0, 0x0, 0xbb33, 0x4108,
    0x0, 0x0, 0xbb33, 0x3f9d, 0x0, 0x0, 0xbb33, 0x3e02,
    0x0, 0x0, 0xbb33, 0x3cdb, 0x0, 0x0, 0xbb33, 0x3bf2,
    0x0, 0x0, 0xbb33, 0x3a87, 0x0, 0x0, 0xbb33, 0x3957,
    0x0, 0x0, 0xbb33, 0x3851, 0x0, 0x0, 0xbb33, 0x36d0,
    0x0, 0x0, 0xbb33, 0x3527, 0x0, 0x0, 0xbb33, 0x3337,
    0x0, 0x0, 0xbb33, 0x3046, 0x0, 0x0, 0xbb33, 0x29a9,
    0x0, 0x0, 0xbb33, 0xa9a9, 0x0, 0x0, 0xbb33, 0xb046,
    0x0, 0x0, 0xbb33, 0xb337, 0x0, 0x0, 0xbb33, 0xb527,
    0x0, 0x0, 0xbb33, 0xb6d0, 0x0, 0x0, 0xbb33, 0xb851,
    0x0, 0x0, 0xbb33, 0xb957, 0x0, 0x0, 0xbb33, 0xba87,
    0x0, 0x0, 0xbb33, 0xbbf2, 0x0, 0x0, 0xbb33, 0xbcdb,
    0x0, 0x0, 0xbb33, 0xbe02, 0x0, 0x0, 0xbb33, 0xbf9d,
    0x0, 0x0, 0xbb33, 0xc108, 0x0, 0x0, 0xbb33, 0xc330,
    0x0, 0x0, 0xbb33, 0xc611, 0x0, 0x0, 0xbb33, 0xcc94
    };

static const uint16_t in_cfft_step_128[256] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0
    };

static const uint16_t in_cifft_step_128[256] = {
    0x5333, 0x0, 0xbb33, 0x5095, 0x0, 0x0, 0xbb33, 0x4a1a,
    0x0, 0x0, 0xbb33, 0x474c, 0x0, 0x0, 0xbb33, 0x4530,
    0x0, 0x0, 0xbb33, 0x4402, 0x0, 0x0, 0xbb33, 0x4281,
    0x0, 0x0, 0xbb33, 0x4173, 0x0, 0x0, 0xbb33, 0x40ab,
    0x0, 0x0, 0xbb33, 0x4010, 0x0, 0x0, 0xbb33, 0x3f27,
    0x0, 0x0, 0xbb33, 0x3e5b, 0x0, 0x0, 0xbb33, 0x3daf,
    0x0, 0x0, 0xbb33, 0x3d1d, 0x0, 0x0, 0xbb33, 0x3c9d,
    0x0, 0x0, 0xbb33, 0x3c2c, 0x0, 0x0, 0xbb33, 0x3b90,
    0x0, 0x0, 0xbb33, 0x3adb, 0x0, 0x0, 0xbb33, 0x3a36,
    0x0, 0x0, 0xbb33, 0x399e, 0x0, 0x0, 0xbb33, 0x3912,
    0x0, 0x0, 0xbb33, 0x388f, 0x0, 0x0, 0xbb33, 0x3814,
    0x0, 0x0, 0xbb33, 0x3740, 0x0, 0x0, 0xbb33, 0x3662,
    0x0, 0x0, 0xbb33, 0x358e, 0x0, 0x0, 0xbb33, 0x34c2,
    0x0, 0x0, 0xbb33, 0x33f8, 0x0, 0x0, 0xbb33, 0x3278,
    0x0, 0x0, 0xbb33, 0x30ff, 0x0, 0x0, 0xbb33, 0x2f1b,
    0x0, 0x0, 0xbb33, 0x2c40, 0x0, 0x0, 0xbb33, 0x25a8,
    0x0, 0x0, 0xbb33, 0xa5a8, 0x0, 0x0, 0xbb33, 0xac40,
    0x0, 0x0, 0xbb33, 0xaf1b, 0x0, 0x0, 0xbb33, 0xb0ff,
    0x0, 0x0, 0xbb33, 0xb278, 0x0, 0x0, 0xbb33, 0xb3f8,
    0x0, 0x0, 0xbb33, 0xb4c2, 0x0, 0x0, 0xbb33, 0xb58e,
    0x0, 0x0, 0xbb33, 0xb662, 0x0, 0x0, 0xbb33, 0xb740,
    0x0, 0x0, 0xbb33, 0xb814, 0x0, 0x0, 0xbb33, 0xb88f,
    0x0, 0x0, 0xbb33, 0xb912, 0x0, 0x0, 0xbb33, 0xb99e,
    0x0, 0x0, 0xbb33, 0xba36, 0x0, 0x0, 0xbb33, 0xbadb,
    0x0, 0x0, 0xbb33, 0xbb90, 0x0, 0x0, 0xbb33, 0xbc2c,
    0x0, 0x0, 0xbb33, 0xbc9d, 0x0, 0x0, 0xbb33, 0xbd1d,
    0x0, 0x0, 0xbb33, 0xbdaf, 0x0, 0x0, 0xbb33, 0xbe5b,
    0x0, 0x0, 0xbb33, 0xbf27, 0x0, 0x0, 0xbb33, 0xc010,
    0x0, 0x0, 0xbb33, 0xc0ab, 0x0, 0x0, 0xbb33, 0xc173,
    0x0, 0x0, 0xbb33, 0xc281, 0x0, 0x0, 0xbb33, 0xc402,
    0x0, 0x0, 0xbb33, 0xc530, 0x0, 0x0, 0xbb33, 0xc74c,
    0x0, 0x0, 0xbb33, 0xca1a, 0x0, 0x0, 0xbb33, 0xd095
    };

static const uint16_t ref_cfft_step_128[256] = {
    0x5333, 0x0, 0xbb33, 0x5095, 0x0, 0x0, 0xbb33, 0x4a1a,
    0x0, 0x0, 0xbb33, 0x474c, 0x0, 0x0, 0xbb33, 0x4530,
    0x0, 0x0, 0xbb33, 0x4402, 0x0, 0x0, 0xbb33, 0x4281,
    0x0, 0x0, 0xbb33, 0x4173, 0x0, 0x0, 0xbb33, 0x40ab,
    0x0, 0x0, 0xbb33, 0x4010, 0x0, 0x0, 0xbb33, 0x3f27,
    0x0, 0x0, 0xbb33, 0x3e5b, 0x0, 0x0, 0xbb33, 0x3daf,
    0x0, 0x0, 0xbb33, 0x3d1d, 0x0, 0x0, 0xbb33, 0x3c9d,
    0x0, 0x0, 0xbb33, 0x3c2c, 0x0, 0x0, 0xbb33, 0x3b90,
    0x0, 0x0, 0xbb33, 0x3adb, 0x0, 0x0, 0xbb33, 0x3a36,
    0x0, 0x0, 0xbb33, 0x399e, 0x0, 0x0, 0xbb33, 0x3912,
    0x0, 0x0, 0xbb33, 0x388f, 0x0, 0x0, 0xbb33, 0x3814,
    0x0, 0x0, 0xbb33, 0x3740, 0x0, 0x0, 0xbb33, 0x3662,
    0x0, 0x0, 0xbb33, 0x358e, 0x0, 0x0, 0xbb33, 0x34c2,
    0x0, 0x0, 0xbb33, 0x33f8, 0x0, 0x0, 0xbb33, 0x3278,
    0x0, 0x0, 0xbb33, 0x30ff, 0x0, 0x0, 0xbb33, 0x2f1b,
    0x0, 0x0, 0xbb33, 0x2c40, 0x0, 0x0, 0xbb33, 0x25a8,
    0x0, 0x0, 0xbb33, 0xa5a8, 0x0, 0x0, 0xbb33, 0xac40,
    0x0, 0x0, 0xbb33, 0xaf1b, 0x0, 0x0, 0xbb33, 0xb0ff,
    0x0, 0x0, 0xbb33, 0xb278, 0x0, 0x0, 0xbb33, 0xb3f8,
    0x0, 0x0, 0xbb33, 0xb4c2, 0x0, 0x0, 0xbb33, 0xb58e,
    0x0, 0x0, 0xbb33, 0xb662, 0x0, 0x0, 0xbb33, 0xb740,
    0x0, 0x0, 0xbb33, 0xb814, 0x0, 0x0, 0xbb33, 0xb88f,
    0x0, 0x0, 0xbb33, 0xb912, 0x0, 0x0, 0xbb33, 0xb99e,
    0x0, 0x0, 0xbb33, 0xba36, 0x0, 0x0, 0xbb33, 0xbadb,
    0x0, 0x0, 0xbb33, 0xbb90, 0x0, 0x0, 0xbb33, 0xbc2c,
    0x0, 0x0, 0xbb33, 0xbc9d, 0x0, 0x0, 0xbb33, 0xbd1d,
    0x0, 0x0, 0xbb33, 0xbdaf, 0x0, 0x0, 0xbb33, 0xbe5b,
    0x0, 0x0, 0xbb33, 0xbf27, 0x0, 0x0, 0xbb33, 0xc010,
    0x0, 0x0, 0xbb33, 0xc0ab, 0x0, 0x0, 0xbb33, 0xc173,
    0x0, 0x0, 0xbb33, 0xc281, 0x0, 0x0, 0xbb33, 0xc402,
    0x0, 0x0, 0xbb33, 0xc530, 0x0, 0x0, 0xbb33, 0xc74c,
    0x0, 0x0, 0xbb33, 0xca1a, 0x0, 0x0, 0xbb33, 0xd095
    };

static const uint16_t in_cfft_step_256[512] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0
    };

static const uint16_t in_cifft_step_256[512] = {
    0x5733, 0x0, 0xbb33, 0x5495, 0x0, 0x0, 0xbb33, 0x4e1c,
    0x0, 0x0, 0xbb33, 0x4b53, 0x0, 0x0, 0xbb33, 0x493a,
    0x0, 0x0, 0xbb33, 0x480f, 0x0, 0x0, 0xbb33, 0x46a0,
    0x0, 0x0, 0xbb33, 0x4598, 0x0, 0x0, 0xbb33, 0x44d5,
    0x0, 0x0, 0xbb33, 0x4440, 0x0, 0x0, 0xbb33, 0x4394,
    0x0, 0x0, 0xbb33, 0x42d4, 0x0, 0x0, 0xbb33, 0x4235,
    0x0, 0x0, 0xbb33, 0x41af, 0x0, 0x0, 0xbb33, 0x413b,
    0x0, 0x0, 0xbb33, 0x40d8, 0x0, 0x0, 0xbb33, 0x4080,
    0x0, 0x0, 0xbb33, 0x4033, 0x0, 0x0, 0xbb33, 0x3fdc,
    0x0, 0x0, 0xbb33, 0x3f60, 0x0, 0x0, 0xbb33, 0x3ef0,
    0x0, 0x0, 0xbb33, 0x3e8a, 0x0, 0x0, 0xbb33, 0x3e2d,
    0x0, 0x0, 0xbb33, 0x3dd8, 0x0, 0x0, 0xbb33, 0x3d89,
    0x0, 0x0, 0xbb33, 0x3d3f, 0x0, 0x0, 0xbb33, 0x3cfb,
    0x0, 0x0, 0xbb33, 0x3cbb, 0x0, 0x0, 0xbb33, 0x3c80,
    0x0, 0x0, 0xbb33, 0x3c47, 0x0, 0x0, 0xbb33, 0x3c12,
    0x0, 0x0, 0xbb33, 0x3bc0, 0x0, 0x0, 0xbb33, 0x3b61,
    0x0, 0x0, 0xbb33, 0x3b07, 0x0, 0x0, 0xbb33, 0x3ab0,
    0x0, 0x0, 0xbb33, 0x3a5e, 0x0, 0x0, 0xbb33, 0x3a0f,
    0x0, 0x0, 0xbb33, 0x39c3, 0x0, 0x0, 0xbb33, 0x397a,
    0x0, 0x0, 0xbb33, 0x3934, 0x0, 0x0, 0xbb33, 0x38f1,
    0x0, 0x0, 0xbb33, 0x38af, 0x0, 0x0, 0xbb33, 0x3870,
    0x0, 0x0, 0xbb33, 0x3832, 0x0, 0x0, 0xbb33, 0x37ed,
    0x0, 0x0, 0xbb33, 0x3779, 0x0, 0x0, 0xbb33, 0x3707,
    0x0, 0x0, 0xbb33, 0x3698, 0x0, 0x0, 0xbb33, 0x362c,
    0x0, 0x0, 0xbb33, 0x35c2, 0x0, 0x0, 0xbb33, 0x355a,
    0x0, 0x0, 0xbb33, 0x34f4, 0x0, 0x0, 0xbb33, 0x3490,
    0x0, 0x0, 0xbb33, 0x342d, 0x0, 0x0, 0xbb33, 0x3397,
    0x0, 0x0, 0xbb33, 0x32d7, 0x0, 0x0, 0xbb33, 0x3219,
    0x0, 0x0, 0xbb33, 0x315d, 0x0, 0x0, 0xbb33, 0x30a2,
    0x0, 0x0, 0xbb33, 0x2fd3, 0x0, 0x0, 0xbb33, 0x2e63,
    0x0, 0x0, 0xbb33, 0x2cf6, 0x0, 0x0, 0xbb33, 0x2b14,
    0x0, 0x0, 0xbb33, 0x283e, 0x0, 0x0, 0xbb33, 0x21a8,
    0x0, 0x0, 0xbb33, 0xa1a8, 0x0, 0x0, 0xbb33, 0xa83e,
    0x0, 0x0, 0xbb33, 0xab14, 0x0, 0x0, 0xbb33, 0xacf6,
    0x0, 0x0, 0xbb33, 0xae63, 0x0, 0x0, 0xbb33, 0xafd3,
    0x0, 0x0, 0xbb33, 0xb0a2, 0x0, 0x0, 0xbb33, 0xb15d,
    0x0, 0x0, 0xbb33, 0xb219, 0x0, 0x0, 0xbb33, 0xb2d7,
    0x0, 0x0, 0xbb33, 0xb397, 0x0, 0x0, 0xbb33, 0xb42d,
    0x0, 0x0, 0xbb33, 0xb490, 0x0, 0x0, 0xbb33, 0xb4f4,
    0x0, 0x0, 0xbb33, 0xb55a, 0x0, 0x0, 0xbb33, 0xb5c2,
    0x0, 0x0, 0xbb33, 0xb62c, 0x0, 0x0, 0xbb33, 0xb698,
    0x0, 0x0, 0xbb33, 0xb707, 0x0, 0x0, 0xbb33, 0xb779,
    0x0, 0x0, 0xbb33, 0xb7ed, 0x0, 0x0, 0xbb33, 0xb832,
    0x0, 0x0, 0xbb33, 0xb870, 0x0, 0x0, 0xbb33, 0xb8af,
    0x0, 0x0, 0xbb33, 0xb8f1, 0x0, 0x0, 0xbb33, 0xb934,
    0x0, 0x0, 0xbb33, 0xb97a, 0x0, 0x0, 0xbb33, 0xb9c3,
    0x0, 0x0, 0xbb33, 0xba0f, 0x0, 0x0, 0xbb33, 0xba5e,
    0x0, 0x0, 0xbb33, 0xbab0, 0x0, 0x0, 0xbb33, 0xbb07,
    0x0, 0x0, 0xbb33, 0xbb61, 0x0, 0x0, 0xbb33, 0xbbc0,
    0x0, 0x0, 0xbb33, 0xbc12, 0x0, 0x0, 0xbb33, 0xbc47,
    0x0, 0x0, 0xbb33, 0xbc80, 0x0, 0x0, 0xbb33, 0xbcbb,
    0x0, 0x0, 0xbb33, 0xbcfb, 0x0, 0x0, 0xbb33, 0xbd3f,
    0x0, 0x0, 0xbb33, 0xbd89, 0x0, 0x0, 0xbb33, 0xbdd8,
    0x0, 0x0, 0xbb33, 0xbe2d, 0x0, 0x0, 0xbb33, 0xbe8a,
    0x0, 0x0, 0xbb33, 0xbef0, 0x0, 0x0, 0xbb33, 0xbf60,
    0x0, 0x0, 0xbb33, 0xbfdc, 0x0, 0x0, 0xbb33, 0xc033,
    0x0, 0x0, 0xbb33, 0xc080, 0x0, 0x0, 0xbb33, 0xc0d8,
    0x0, 0x0, 0xbb33, 0xc13b, 0x0, 0x0, 0xbb33, 0xc1af,
    0x0, 0x0, 0xbb33, 0xc235, 0x0, 0x0, 0xbb33, 0xc2d4,
    0x0, 0x0, 0xbb33, 0xc394, 0x0, 0x0, 0xbb33, 0xc440,
    0x0, 0x0, 0xbb33, 0xc4d5, 0x0, 0x0, 0xbb33, 0xc598,
    0x0, 0x0, 0xbb33, 0xc6a0, 0x0, 0x0, 0xbb33, 0xc80f,
    0x0, 0x0, 0xbb33, 0xc93a, 0x0, 0x0, 0xbb33, 0xcb53,
    0x0, 0x0, 0xbb33, 0xce1c, 0x0, 0x0, 0xbb33, 0xd495
    };

static const uint16_t ref_cfft_step_256[512] = {
    0x5733, 0x0, 0xbb33, 0x5495, 0x0, 0x0, 0xbb33, 0x4e1c,
    0x0, 0x0, 0xbb33, 0x4b53, 0x0, 0x0, 0xbb33, 0x493a,
    0x0, 0x0, 0xbb33, 0x480f, 0x0, 0x0, 0xbb33, 0x46a0,
    0x0, 0x0, 0xbb33, 0x4598, 0x0, 0x0, 0xbb33, 0x44d5,
    0x0, 0x0, 0xbb33, 0x4440, 0x0, 0x0, 0xbb33, 0x4394,
    0x0, 0x0, 0xbb33, 0x42d4, 0x0, 0x0, 0xbb33, 0x4235,
    0x0, 0x0, 0xbb33, 0x41af, 0x0, 0x0, 0xbb33, 0x413b,
    0x0, 0x0, 0xbb33, 0x40d8, 0x0, 0x0, 0xbb33, 0x4080,
    0x0, 0x0, 0xbb33, 0x4033, 0x0, 0x0, 0xbb33, 0x3fdc,
    0x0, 0x0, 0xbb33, 0x3f60, 0x0, 0x0, 0xbb33, 0x3ef0,
    0x0, 0x0, 0xbb33, 0x3e8a, 0x0, 0x0, 0xbb33, 0x3e2d,
    0x0, 0x0, 0xbb33, 0x3dd8, 0x0, 0x0, 0xbb33, 0x3d89,
    0x0, 0x0, 0xbb33, 0x3d3f, 0x0, 0x0, 0xbb33, 0x3cfb,
    0x0, 0x0, 0xbb33, 0x3cbb, 0x0, 0x0, 0xbb33, 0x3c80,
    0x0, 0x0, 0xbb33, 0x3c47, 0x0, 0x0, 0xbb33, 0x3c12,
    0x0, 0x0, 0xbb33, 0x3bc0, 0x0, 0x0, 0xbb33, 0x3b61,
    0x0, 0x0, 0xbb33, 0x3b07, 0x0, 0x0, 0xbb33, 0x3ab0,
    0x0, 0x0, 0xbb33, 0x3a5e, 0x0, 0x0, 0xbb33, 0x3a0f,
    0x0, 0x0, 0xbb33, 0x39c3, 0x0, 0x0, 0xbb33, 0x397a,
    0x0, 0x0, 0xbb33, 0x3934, 0x0, 0x0, 0xbb33, 0x38f1,
    0x0, 0x0, 0xbb33, 0x38af, 0x0, 0x0, 0xbb33, 0x3870,
    0x0, 0x0, 0xbb33, 0x3832, 0x0, 0x0, 0xbb33, 0x37ed,
    0x0, 0x0, 0xbb33, 0x3779, 0x0, 0x0, 0xbb33, 0x3707,
    0x0, 0x0, 0xbb33, 0x3698, 0x0, 0x0, 0xbb33, 0x362c,
    0x0, 0x0, 0xbb33, 0x35c2, 0x0, 0x0, 0xbb33, 0x355a,
    0x0, 0x0, 0xbb33, 0x34f4, 0x0, 0x0, 0xbb33, 0x3490,
    0x0, 0x0, 0xbb33, 0x342d, 0x0, 0x0, 0xbb33, 0x3397,
    0x0, 0x0, 0xbb33, 0x32d7, 0x0, 0x0, 0xbb33, 0x3219,
    0x0, 0x0, 0xbb33, 0x315d, 0x0, 0x0, 0xbb33, 0x30a2,
    0x0, 0x0, 0xbb33, 0x2fd3, 0x0, 0x0, 0xbb33, 0x2e63,
    0x0, 0x0, 0xbb33, 0x2cf6, 0x0, 0x0, 0xbb33, 0x2b14,
    0x0, 0x0, 0xbb33, 0x283e, 0x0, 0x0, 0xbb33, 0x21a8,
    0x0, 0x0, 0xbb33, 0xa1a8, 0x0, 0x0, 0xbb33, 0xa83e,
    0x0, 0x0, 0xbb33, 0xab14, 0x0, 0x0, 0xbb33, 0xacf6,
    0x0, 0x0, 0xbb33, 0xae63, 0x0, 0x0, 0xbb33, 0xafd3,
    0x0, 0x0, 0xbb33, 0xb0a2, 0x0, 0x0, 0xbb33, 0xb15d,
    0x0, 0x0, 0xbb33, 0xb219, 0x0, 0x0, 0xbb33, 0xb2d7,
    0x0, 0x0, 0xbb33, 0xb397, 0x0, 0x0, 0xbb33, 0xb42d,
    0x0, 0x0, 0xbb33, 0xb490, 0x0, 0x0, 0xbb33, 0xb4f4,
    0x0, 0x0, 0xbb33, 0xb55a, 0x0, 0x0, 0xbb33, 0xb5c2,
    0x0, 0x0, 0xbb33, 0xb62c, 0x0, 0x0, 0xbb33, 0xb698,
    0x0, 0x0, 0xbb33, 0xb707, 0x0, 0x0, 0xbb33, 0xb779,
    0x0, 0x0, 0xbb33, 0xb7ed, 0x0, 0x0, 0xbb33, 0xb832,
    0x0, 0x0, 0xbb33, 0xb870, 0x0, 0x0, 0xbb33, 0xb8af,
    0x0, 0x0, 0xbb33, 0xb8f1, 0x0, 0x0, 0xbb33, 0xb934,
    0x0, 0x0, 0xbb33, 0xb97a, 0x0, 0x0, 0xbb33, 0xb9c3,
    0x0, 0x0, 0xbb33, 0xba0f, 0x0, 0x0, 0xbb33, 0xba5e,
    0x0, 0x0, 0xbb33, 0xbab0, 0x0, 0x0, 0xbb33, 0xbb07,
    0x0, 0x0, 0xbb33, 0xbb61, 0x0, 0x0, 0xbb33, 0xbbc0,
    0x0, 0x0, 0xbb33, 0xbc12, 0x0, 0x0, 0xbb33, 0xbc47,
    0x0, 0x0, 0xbb33, 0xbc80, 0x0, 0x0, 0xbb33, 0xbcbb,
    0x0, 0x0, 0xbb33, 0xbcfb, 0x0, 0x0, 0xbb33, 0xbd3f,
    0x0, 0x0, 0xbb33, 0xbd89, 0x0, 0x0, 0xbb33, 0xbdd8,
    0x0, 0x0, 0xbb33, 0xbe2d, 0x0, 0x0, 0xbb33, 0xbe8a,
    0x0, 0x0, 0xbb33, 0xbef0, 0x0, 0x0, 0xbb33, 0xbf60,
    0x0, 0x0, 0xbb33, 0xbfdc, 0x0, 0x0, 0xbb33, 0xc033,
    0x0, 0x0, 0xbb33, 0xc080, 0x0, 0x0, 0xbb33, 0xc0d8,
    0x0, 0x0, 0xbb33, 0xc13b, 0x0, 0x0, 0xbb33, 0xc1af,
    0x0, 0x0, 0xbb33, 0xc235, 0x0, 0x0, 0xbb33, 0xc2d4,
    0x0, 0x0, 0xbb33, 0xc394, 0x0, 0x0, 0xbb33, 0xc440,
    0x0, 0x0, 0xbb33, 0xc4d5, 0x0, 0x0, 0xbb33, 0xc598,
    0x0, 0x0, 0xbb33, 0xc6a0, 0x0, 0x0, 0xbb33, 0xc80f,
    0x0, 0x0, 0xbb33, 0xc93a, 0x0, 0x0, 0xbb33, 0xcb53,
    0x0, 0x0, 0xbb33, 0xce1c, 0x0, 0x0, 0xbb33, 0xd495
    };

static const uint16_t in_cfft_step_512[1024] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0
    };

static const uint16_t in_cifft_step_512[1024] = {
    0x5b33, 0x0, 0xbb33, 0x5895, 0x0, 0x0, 0xbb33, 0x521c,
    0x0, 0x0, 0xbb33, 0x4f55, 0x0, 0x0, 0xbb33, 0x4d3c,
    0x0, 0x0, 0xbb33, 0x4c12, 0x0, 0x0, 0xbb33, 0x4aa8,
    0x0, 0x0, 0xbb33, 0x49a1, 0x0, 0x0, 0xbb33, 0x48e0,
    0x0, 0x0, 0xbb33, 0x484c, 0x0, 0x0, 0xbb33, 0x47af,
    0x0, 0x0, 0xbb33, 0x46f2, 0x0, 0x0, 0xbb33, 0x4656,
    0x0, 0x0, 0xbb33, 0x45d2, 0x0, 0x0, 0xbb33, 0x4562,
    0x0, 0x0, 0xbb33, 0x4501, 0x0, 0x0, 0xbb33, 0x44ad,
    0x0, 0x0, 0xbb33, 0x4462, 0x0, 0x0, 0xbb33, 0x4420,
    0x0, 0x0, 0xbb33, 0x43cb, 0x0, 0x0, 0xbb33, 0x4361,
    0x0, 0x0, 0xbb33, 0x4301, 0x0, 0x0, 0xbb33, 0x42aa,
    0x0, 0x0, 0xbb33, 0x425a, 0x0, 0x0, 0xbb33, 0x4211,
    0x0, 0x0, 0xbb33, 0x41ce, 0x0, 0x0, 0xbb33, 0x4190,
    0x0, 0x0, 0xbb33, 0x4157, 0x0, 0x0, 0xbb33, 0x4121,
    0x0, 0x0, 0xbb33, 0x40ef, 0x0, 0x0, 0xbb33, 0x40c1,
    0x0, 0x0, 0xbb33, 0x4095, 0x0, 0x0, 0xbb33, 0x406c,
    0x0, 0x0, 0xbb33, 0x4045, 0x0, 0x0, 0xbb33, 0x4021,
    0x0, 0x0, 0xbb33, 0x3ffd, 0x0, 0x0, 0xbb33, 0x3fbc,
    0x0, 0x0, 0xbb33, 0x3f7e, 0x0, 0x0, 0xbb33, 0x3f43,
    0x0, 0x0, 0xbb33, 0x3f0b, 0x0, 0x0, 0xbb33, 0x3ed6,
    0x0, 0x0, 0xbb33, 0x3ea3, 0x0, 0x0, 0xbb33, 0x3e72,
    0x0, 0x0, 0xbb33, 0x3e44, 0x0, 0x0, 0xbb33, 0x3e17,
    0x0, 0x0, 0xbb33, 0x3dec, 0x0, 0x0, 0xbb33, 0x3dc3,
    0x0, 0x0, 0xbb33, 0x3d9c, 0x0, 0x0, 0xbb33, 0x3d76,
    0x0, 0x0, 0xbb33, 0x3d51, 0x0, 0x0, 0xbb33, 0x3d2e,
    0x0, 0x0, 0xbb33, 0x3d0c, 0x0, 0x0, 0xbb33, 0x3ceb,
    0x0, 0x0, 0xbb33, 0x3ccb, 0x0, 0x0, 0xbb33, 0x3cac,
    0x0, 0x0, 0xbb33, 0x3c8e, 0x0, 0x0, 0xbb33, 0x3c71,
    0x0, 0x0, 0xbb33, 0x3c55, 0x0, 0x0, 0xbb33, 0x3c3a,
    0x0, 0x0, 0xbb33, 0x3c1f, 0x0, 0x0, 0xbb33, 0x3c05,
    0x0, 0x0, 0xbb33, 0x3bd9, 0x0, 0x0, 0xbb33, 0x3ba8,
    0x0, 0x0, 0xbb33, 0x3b78, 0x0, 0x0, 0xbb33, 0x3b4a,
    0x0, 0x0, 0xbb33, 0x3b1d, 0x0, 0x0, 0xbb33, 0x3af1,
    0x0, 0x0, 0xbb33, 0x3ac5, 0x0, 0x0, 0xbb33, 0x3a9b,
    0x0, 0x0, 0xbb33, 0x3a72, 0x0, 0x0, 0xbb33, 0x3a4a,
    0x0, 0x0, 0xbb33, 0x3a22, 0x0, 0x0, 0xbb33, 0x39fc,
    0x0, 0x0, 0xbb33, 0x39d6, 0x0, 0x0, 0xbb33, 0x39b1,
    0x0, 0x0, 0xbb33, 0x398c, 0x0, 0x0, 0xbb33, 0x3969,
    0x0, 0x0, 0xbb33, 0x3946, 0x0, 0x0, 0xbb33, 0x3923,
    0x0, 0x0, 0xbb33, 0x3901, 0x0, 0x0, 0xbb33, 0x38e0,
    0x0, 0x0, 0xbb33, 0x38bf, 0x0, 0x0, 0xbb33, 0x389f,
    0x0, 0x0, 0xbb33, 0x387f, 0x0, 0x0, 0xbb33, 0x3860,
    0x0, 0x0, 0xbb33, 0x3841, 0x0, 0x0, 0xbb33, 0x3823,
    0x0, 0x0, 0xbb33, 0x3805, 0x0, 0x0, 0xbb33, 0x37d0,
    0x0, 0x0, 0xbb33, 0x3795, 0x0, 0x0, 0xbb33, 0x375c,
    0x0, 0x0, 0xbb33, 0x3723, 0x0, 0x0, 0xbb33, 0x36eb,
    0x0, 0x0, 0xbb33, 0x36b4, 0x0, 0x0, 0xbb33, 0x367d,
    0x0, 0x0, 0xbb33, 0x3647, 0x0, 0x0, 0xbb33, 0x3612,
    0x0, 0x0, 0xbb33, 0x35dd, 0x0, 0x0, 0xbb33, 0x35a8,
    0x0, 0x0, 0xbb33, 0x3574, 0x0, 0x0, 0xbb33, 0x3541,
    0x0, 0x0, 0xbb33, 0x350e, 0x0, 0x0, 0xbb33, 0x34db,
    0x0, 0x0, 0xbb33, 0x34a9, 0x0, 0x0, 0xbb33, 0x3477,
    0x0, 0x0, 0xbb33, 0x3446, 0x0, 0x0, 0xbb33, 0x3415,
    0x0, 0x0, 0xbb33, 0x33c8, 0x0, 0x0, 0xbb33, 0x3367,
    0x0, 0x0, 0xbb33, 0x3307, 0x0, 0x0, 0xbb33, 0x32a7,
    0x0, 0x0, 0xbb33, 0x3248, 0x0, 0x0, 0xbb33, 0x31ea,
    0x0, 0x0, 0xbb33, 0x318c, 0x0, 0x0, 0xbb33, 0x312e,
    0x0, 0x0, 0xbb33, 0x30d1, 0x0, 0x0, 0xbb33, 0x3074,
    0x0, 0x0, 0xbb33, 0x3017, 0x0, 0x0, 0xbb33, 0x2f77,
    0x0, 0x0, 0xbb33, 0x2ebf, 0x0, 0x0, 0xbb33, 0x2e08,
    0x0, 0x0, 0xbb33, 0x2d51, 0x0, 0x0, 0xbb33, 0x2c9b,
    0x0, 0x0, 0xbb33, 0x2bca, 0x0, 0x0, 0xbb33, 0x2a5e,
    0x0, 0x0, 0xbb33, 0x28f3, 0x0, 0x0, 0xbb33, 0x2712,
    0x0, 0x0, 0xbb33, 0x243e, 0x0, 0x0, 0xbb33, 0x1da8,
    0x0, 0x0, 0xbb33, 0x9da8, 0x0, 0x0, 0xbb33, 0xa43e,
    0x0, 0x0, 0xbb33, 0xa712, 0x0, 0x0, 0xbb33, 0xa8f3,
    0x0, 0x0, 0xbb33, 0xaa5e, 0x0, 0x0, 0xbb33, 0xabca,
    0x0, 0x0, 0xbb33, 0xac9b, 0x0, 0x0, 0xbb33, 0xad51,
    0x0, 0x0, 0xbb33, 0xae08, 0x0, 0x0, 0xbb33, 0xaebf,
    0x0, 0x0, 0xbb33, 0xaf77, 0x0, 0x0, 0xbb33, 0xb017,
    0x0, 0x0, 0xbb33, 0xb074, 0x0, 0x0, 0xbb33, 0xb0d1,
    0x0, 0x0, 0xbb33, 0xb12e, 0x0, 0x0, 0xbb33, 0xb18c,
    0x0, 0x0, 0xbb33, 0xb1ea, 0x0, 0x0, 0xbb33, 0xb248,
    0x0, 0x0, 0xbb33, 0xb2a7, 0x0, 0x0, 0xbb33, 0xb307,
    0x0, 0x0, 0xbb33, 0xb367, 0x0, 0x0, 0xbb33, 0xb3c8,
    0x0, 0x0, 0xbb33, 0xb415, 0x0, 0x0, 0xbb33, 0xb446,
    0x0, 0x0, 0xbb33, 0xb477, 0x0, 0x0, 0xbb33, 0xb4a9,
    0x0, 0x0, 0xbb33, 0xb4db, 0x0, 0x0, 0xbb33, 0xb50e,
    0x0, 0x0, 0xbb33, 0xb541, 0x0, 0x0, 0xbb33, 0xb574,
    0x0, 0x0, 0xbb33, 0xb5a8, 0x0, 0x0, 0xbb33, 0xb5dd,
    0x0, 0x0, 0xbb33, 0xb612, 0x0, 0x0, 0xbb33, 0xb647,
    0x0, 0x0, 0xbb33, 0xb67d, 0x0, 0x0, 0xbb33, 0xb6b4,
    0x0, 0x0, 0xbb33, 0xb6eb, 0x0, 0x0, 0xbb33, 0xb723,
    0x0, 0x0, 0xbb33, 0xb75c, 0x0, 0x0, 0xbb33, 0xb795,
    0x0, 0x0, 0xbb33, 0xb7d0, 0x0, 0x0, 0xbb33, 0xb805,
    0x0, 0x0, 0xbb33, 0xb823, 0x0, 0x0, 0xbb33, 0xb841,
    0x0, 0x0, 0xbb33, 0xb860, 0x0, 0x0, 0xbb33, 0xb87f,
    0x0, 0x0, 0xbb33, 0xb89f, 0x0, 0x0, 0xbb33, 0xb8bf,
    0x0, 0x0, 0xbb33, 0xb8e0, 0x0, 0x0, 0xbb33, 0xb901,
    0x0, 0x0, 0xbb33, 0xb923, 0x0, 0x0, 0xbb33, 0xb946,
    0x0, 0x0, 0xbb33, 0xb969, 0x0, 0x0, 0xbb33, 0xb98c,
    0x0, 0x0, 0xbb33, 0xb9b1, 0x0, 0x0, 0xbb33, 0xb9d6,
    0x0, 0x0, 0xbb33, 0xb9fc, 0x0, 0x0, 0xbb33, 0xba22,
    0x0, 0x0, 0xbb33, 0xba4a, 0x0, 0x0, 0xbb33, 0xba72,
    0x0, 0x0, 0xbb33, 0xba9b, 0x0, 0x0, 0xbb33, 0xbac5,
    0x0, 0x0, 0xbb33, 0xbaf1, 0x0, 0x0, 0xbb33, 0xbb1d,
    0x0, 0x0, 0xbb33, 0xbb4a, 0x0, 0x0, 0xbb33, 0xbb78,
    0x0, 0x0, 0xbb33, 0xbba8, 0x0, 0x0, 0xbb33, 0xbbd9,
    0x0, 0x0, 0xbb33, 0xbc05, 0x0, 0x0, 0xbb33, 0xbc1f,
    0x0, 0x0, 0xbb33, 0xbc3a, 0x0, 0x0, 0xbb33, 0xbc55,
    0x0, 0x0, 0xbb33, 0xbc71, 0x0, 0x0, 0xbb33, 0xbc8e,
    0x0, 0x0, 0xbb33, 0xbcac, 0x0, 0x0, 0xbb33, 0xbccb,
    0x0, 0x0, 0xbb33, 0xbceb, 0x0, 0x0, 0xbb33, 0xbd0c,
    0x0, 0x0, 0xbb33, 0xbd2e, 0x0, 0x0, 0xbb33, 0xbd51,
    0x0, 0x0, 0xbb33, 0xbd76, 0x0, 0x0, 0xbb33, 0xbd9c,
    0x0, 0x0, 0xbb33, 0xbdc3, 0x0, 0x0, 0xbb33, 0xbdec,
    0x0, 0x0, 0xbb33, 0xbe17, 0x0, 0x0, 0xbb33, 0xbe44,
    0x0, 0x0, 0xbb33, 0xbe72, 0x0, 0x0, 0xbb33, 0xbea3,
    0x0, 0x0, 0xbb33, 0xbed6, 0x0, 0x0, 0xbb33, 0xbf0b,
    0x0, 0x0, 0xbb33, 0xbf43, 0x0, 0x0, 0xbb33, 0xbf7e,
    0x0, 0x0, 0xbb33, 0xbfbc, 0x0, 0x0, 0xbb33, 0xbffd,
    0x0, 0x0, 0xbb33, 0xc021, 0x0, 0x0, 0xbb33, 0xc045,
    0x0, 0x0, 0xbb33, 0xc06c, 0x0, 0x0, 0xbb33, 0xc095,
    0x0, 0x0, 0xbb33, 0xc0c1, 0x0, 0x0, 0xbb33, 0xc0ef,
    0x0, 0x0, 0xbb33, 0xc121, 0x0, 0x0, 0xbb33, 0xc157,
    0x0, 0x0, 0xbb33, 0xc190, 0x0, 0x0, 0xbb33, 0xc1ce,
    0x0, 0x0, 0xbb33, 0xc211, 0x0, 0x0, 0xbb33, 0xc25a,
    0x0, 0x0, 0xbb33, 0xc2aa, 0x0, 0x0, 0xbb33, 0xc301,
    0x0, 0x0, 0xbb33, 0xc361, 0x0, 0x0, 0xbb33, 0xc3cb,
    0x0, 0x0, 0xbb33, 0xc420, 0x0, 0x0, 0xbb33, 0xc462,
    0x0, 0x0, 0xbb33, 0xc4ad, 0x0, 0x0, 0xbb33, 0xc501,
    0x0, 0x0, 0xbb33, 0xc562, 0x0, 0x0, 0xbb33, 0xc5d2,
    0x0, 0x0, 0xbb33, 0xc656, 0x0, 0x0, 0xbb33, 0xc6f2,
    0x0, 0x0, 0xbb33, 0xc7af, 0x0, 0x0, 0xbb33, 0xc84c,
    0x0, 0x0, 0xbb33, 0xc8e0, 0x0, 0x0, 0xbb33, 0xc9a1,
    0x0, 0x0, 0xbb33, 0xcaa8, 0x0, 0x0, 0xbb33, 0xcc12,
    0x0, 0x0, 0xbb33, 0xcd3c, 0x0, 0x0, 0xbb33, 0xcf55,
    0x0, 0x0, 0xbb33, 0xd21c, 0x0, 0x0, 0xbb33, 0xd895
    };

static const uint16_t ref_cfft_step_512[1024] = {
    0x5b33, 0x0, 0xbb33, 0x5895, 0x0, 0x0, 0xbb33, 0x521c,
    0x0, 0x0, 0xbb33, 0x4f55, 0x0, 0x0, 0xbb33, 0x4d3c,
    0x0, 0x0, 0xbb33, 0x4c12, 0x0, 0x0, 0xbb33, 0x4aa8,
    0x0, 0x0, 0xbb33, 0x49a1, 0x0, 0x0, 0xbb33, 0x48e0,
    0x0, 0x0, 0xbb33, 0x484c, 0x0, 0x0, 0xbb33, 0x47af,
    0x0, 0x0, 0xbb33, 0x46f2, 0x0, 0x0, 0xbb33, 0x4656,
    0x0, 0x0, 0xbb33, 0x45d2, 0x0, 0x0, 0xbb33, 0x4562,
    0x0, 0x0, 0xbb33, 0x4501, 0x0, 0x0, 0xbb33, 0x44ad,
    0x0, 0x0, 0xbb33, 0x4462, 0x0, 0x0, 0xbb33, 0x4420,
    0x0, 0x0, 0xbb33, 0x43cb, 0x0, 0x0, 0xbb33, 0x4361,
    0x0, 0x0, 0xbb33, 0x4301, 0x0, 0x0, 0xbb33, 0x42aa,
    0x0, 0x0, 0xbb33, 0x425a, 0x0, 0x0, 0xbb33, 0x4211,
    0x0, 0x0, 0xbb33, 0x41ce, 0x0, 0x0, 0xbb33, 0x4190,
    0x0, 0x0, 0xbb33, 0x4157, 0x0, 0x0, 0xbb33, 0x4121,
    0x0, 0x0, 0xbb33, 0x40ef, 0x0, 0x0, 0xbb33, 0x40c1,
    0x0, 0x0, 0xbb33, 0x4095, 0x0, 0x0, 0xbb33, 0x406c,
    0x0, 0x0, 0xbb33, 0x4045, 0x0, 0x0, 0xbb33, 0x4021,
    0x0, 0x0, 0xbb33, 0x3ffd, 0x0, 0x0, 0xbb33, 0x3fbc,
    0x0, 0x0, 0xbb33, 0x3f7e, 0x0, 0x0, 0xbb33, 0x3f43,
    0x0, 0x0, 0xbb33, 0x3f0b, 0x0, 0x0, 0xbb33, 0x3ed6,
    0x0, 0x0, 0xbb33, 0x3ea3, 0x0, 0x0, 0xbb33, 0x3e72,
    0x0, 0x0, 0xbb33, 0x3e44, 0x0, 0x0, 0xbb33, 0x3e17,
    0x0, 0x0, 0xbb33, 0x3dec, 0x0, 0x0, 0xbb33, 0x3dc3,
    0x0, 0x0, 0xbb33, 0x3d9c, 0x0, 0x0, 0xbb33, 0x3d76,
    0x0, 0x0, 0xbb33, 0x3d51, 0x0, 0x0, 0xbb33, 0x3d2e,
    0x0, 0x0, 0xbb33, 0x3d0c, 0x0, 0x0, 0xbb33, 0x3ceb,
    0x0, 0x0, 0xbb33, 0x3ccb, 0x0, 0x0, 0xbb33, 0x3cac,
    0x0, 0x0, 0xbb33, 0x3c8e, 0x0, 0x0, 0xbb33, 0x3c71,
    0x0, 0x0, 0xbb33, 0x3c55, 0x0, 0x0, 0xbb33, 0x3c3a,
    0x0, 0x0, 0xbb33, 0x3c1f, 0x0, 0x0, 0xbb33, 0x3c05,
    0x0, 0x0, 0xbb33, 0x3bd9, 0x0, 0x0, 0xbb33, 0x3ba8,
    0x0, 0x0, 0xbb33, 0x3b78, 0x0, 0x0, 0xbb33, 0x3b4a,
    0x0, 0x0, 0xbb33, 0x3b1d, 0x0, 0x0, 0xbb33, 0x3af1,
    0x0, 0x0, 0xbb33, 0x3ac5, 0x0, 0x0, 0xbb33, 0x3a9b,
    0x0, 0x0, 0xbb33, 0x3a72, 0x0, 0x0, 0xbb33, 0x3a4a,
    0x0, 0x0, 0xbb33, 0x3a22, 0x0, 0x0, 0xbb33, 0x39fc,
    0x0, 0x0, 0xbb33, 0x39d6, 0x0, 0x0, 0xbb33, 0x39b1,
    0x0, 0x0, 0xbb33, 0x398c, 0x0, 0x0, 0xbb33, 0x3969,
    0x0, 0x0, 0xbb33, 0x3946, 0x0, 0x0, 0xbb33, 0x3923,
    0x0, 0x0, 0xbb33, 0x3901, 0x0, 0x0, 0xbb33, 0x38e0,
    0x0, 0x0, 0xbb33, 0x38bf, 0x0, 0x0, 0xbb33, 0x389f,
    0x0, 0x0, 0xbb33, 0x387f, 0x0, 0x0, 0xbb33, 0x3860,
    0x0, 0x0, 0xbb33, 0x3841, 0x0, 0x0, 0xbb33, 0x3823,
    0x0, 0x0, 0xbb33, 0x3805, 0x0, 0x0, 0xbb33, 0x37d0,
    0x0, 0x0, 0xbb33, 0x3795, 0x0, 0x0, 0xbb33, 0x375c,
    0x0, 0x0, 0xbb33, 0x3723, 0x0, 0x0, 0xbb33, 0x36eb,
    0x0, 0x0, 0xbb33, 0x36b4, 0x0, 0x0, 0xbb33, 0x367d,
    0x0, 0x0, 0xbb33, 0x3647, 0x0, 0x0, 0xbb33, 0x3612,
    0x0, 0x0, 0xbb33, 0x35dd, 0x0, 0x0, 0xbb33, 0x35a8,
    0x0, 0x0, 0xbb33, 0x3574, 0x0, 0x0, 0xbb33, 0x3541,
    0x0, 0x0, 0xbb33, 0x350e, 0x0, 0x0, 0xbb33, 0x34db,
    0x0, 0x0, 0xbb33, 0x34a9, 0x0, 0x0, 0xbb33, 0x3477,
    0x0, 0x0, 0xbb33, 0x3446, 0x0, 0x0, 0xbb33, 0x3415,
    0x0, 0x0, 0xbb33, 0x33c8, 0x0, 0x0, 0xbb33, 0x3367,
    0x0, 0x0, 0xbb33, 0x3307, 0x0, 0x0, 0xbb33, 0x32a7,
    0x0, 0x0, 0xbb33, 0x3248, 0x0, 0x0, 0xbb33, 0x31ea,
    0x0, 0x0, 0xbb33, 0x318c, 0x0, 0x0, 0xbb33, 0x312e,
    0x0, 0x0, 0xbb33, 0x30d1, 0x0, 0x0, 0xbb33, 0x3074,
    0x0, 0x0, 0xbb33, 0x3017, 0x0, 0x0, 0xbb33, 0x2f77,
    0x0, 0x0, 0xbb33, 0x2ebf, 0x0, 0x0, 0xbb33, 0x2e08,
    0x0, 0x0, 0xbb33, 0x2d51, 0x0, 0x0, 0xbb33, 0x2c9b,
    0x0, 0x0, 0xbb33, 0x2bca, 0x0, 0x0, 0xbb33, 0x2a5e,
    0x0, 0x0, 0xbb33, 0x28f3, 0x0, 0x0, 0xbb33, 0x2712,
    0x0, 0x0, 0xbb33, 0x243e, 0x0, 0x0, 0xbb33, 0x1da8,
    0x0, 0x0, 0xbb33, 0x9da8, 0x0, 0x0, 0xbb33, 0xa43e,
    0x0, 0x0, 0xbb33, 0xa712, 0x0, 0x0, 0xbb33, 0xa8f3,
    0x0, 0x0, 0xbb33, 0xaa5e, 0x0, 0x0, 0xbb33, 0xabca,
    0x0, 0x0, 0xbb33, 0xac9b, 0x0, 0x0, 0xbb33, 0xad51,
    0x0, 0x0, 0xbb33, 0xae08, 0x0, 0x0, 0xbb33, 0xaebf,
    0x0, 0x0, 0xbb33, 0xaf77, 0x0, 0x0, 0xbb33, 0xb017,
    0x0, 0x0, 0xbb33, 0xb074, 0x0, 0x0, 0xbb33, 0xb0d1,
    0x0, 0x0, 0xbb33, 0xb12e, 0x0, 0x0, 0xbb33, 0xb18c,
    0x0, 0x0, 0xbb33, 0xb1ea, 0x0, 0x0, 0xbb33, 0xb248,
    0x0, 0x0, 0xbb33, 0xb2a7, 0x0, 0x0, 0xbb33, 0xb307,
    0x0, 0x0, 0xbb33, 0xb367, 0x0, 0x0, 0xbb33, 0xb3c8,
    0x0, 0x0, 0xbb33, 0xb415, 0x0, 0x0, 0xbb33, 0xb446,
    0x0, 0x0, 0xbb33, 0xb477, 0x0, 0x0, 0xbb33, 0xb4a9,
    0x0, 0x0, 0xbb33, 0xb4db, 0x0, 0x0, 0xbb33, 0xb50e,
    0x0, 0x0, 0xbb33, 0xb541, 0x0, 0x0, 0xbb33, 0xb574,
    0x0, 0x0, 0xbb33, 0xb5a8, 0x0, 0x0, 0xbb33, 0xb5dd,
    0x0, 0x0, 0xbb33, 0xb612, 0x0, 0x0, 0xbb33, 0xb647,
    0x0, 0x0, 0xbb33, 0xb67d, 0x0, 0x0, 0xbb33, 0xb6b4,
    0x0, 0x0, 0xbb33, 0xb6eb, 0x0, 0x0, 0xbb33, 0xb723,
    0x0, 0x0, 0xbb33, 0xb75c, 0x0, 0x0, 0xbb33, 0xb795,
    0x0, 0x0, 0xbb33, 0xb7d0, 0x0, 0x0, 0xbb33, 0xb805,
    0x0, 0x0, 0xbb33, 0xb823, 0x0, 0x0, 0xbb33, 0xb841,
    0x0, 0x0, 0xbb33, 0xb860, 0x0, 0x0, 0xbb33, 0xb87f,
    0x0, 0x0, 0xbb33, 0xb89f, 0x0, 0x0, 0xbb33, 0xb8bf,
    0x0, 0x0, 0xbb33, 0xb8e0, 0x0, 0x0, 0xbb33, 0xb901,
    0x0, 0x0, 0xbb33, 0xb923, 0x0, 0x0, 0xbb33, 0xb946,
    0x0, 0x0, 0xbb33, 0xb969, 0x0, 0x0, 0xbb33, 0xb98c,
    0x0, 0x0, 0xbb33, 0xb9b1, 0x0, 0x0, 0xbb33, 0xb9d6,
    0x0, 0x0, 0xbb33, 0xb9fc, 0x0, 0x0, 0xbb33, 0xba22,
    0x0, 0x0, 0xbb33, 0xba4a, 0x0, 0x0, 0xbb33, 0xba72,
    0x0, 0x0, 0xbb33, 0xba9b, 0x0, 0x0, 0xbb33, 0xbac5,
    0x0, 0x0, 0xbb33, 0xbaf1, 0x0, 0x0, 0xbb33, 0xbb1d,
    0x0, 0x0, 0xbb33, 0xbb4a, 0x0, 0x0, 0xbb33, 0xbb78,
    0x0, 0x0, 0xbb33, 0xbba8, 0x0, 0x0, 0xbb33, 0xbbd9,
    0x0, 0x0, 0xbb33, 0xbc05, 0x0, 0x0, 0xbb33, 0xbc1f,
    0x0, 0x0, 0xbb33, 0xbc3a, 0x0, 0x0, 0xbb33, 0xbc55,
    0x0, 0x0, 0xbb33, 0xbc71, 0x0, 0x0, 0xbb33, 0xbc8e,
    0x0, 0x0, 0xbb33, 0xbcac, 0x0, 0x0, 0xbb33, 0xbccb,
    0x0, 0x0, 0xbb33, 0xbceb, 0x0, 0x0, 0xbb33, 0xbd0c,
    0x0, 0x0, 0xbb33, 0xbd2e, 0x0, 0x0, 0xbb33, 0xbd51,
    0x0, 0x0, 0xbb33, 0xbd76, 0x0, 0x0, 0xbb33, 0xbd9c,
    0x0, 0x0, 0xbb33, 0xbdc3, 0x0, 0x0, 0xbb33, 0xbdec,
    0x0, 0x0, 0xbb33, 0xbe17, 0x0, 0x0, 0xbb33, 0xbe44,
    0x0, 0x0, 0xbb33, 0xbe72, 0x0, 0x0, 0xbb33, 0xbea3,
    0x0, 0x0, 0xbb33, 0xbed6, 0x0, 0x0, 0xbb33, 0xbf0b,
    0x0, 0x0, 0xbb33, 0xbf43, 0x0, 0x0, 0xbb33, 0xbf7e,
    0x0, 0x0, 0xbb33, 0xbfbc, 0x0, 0x0, 0xbb33, 0xbffd,
    0x0, 0x0, 0xbb33, 0xc021, 0x0, 0x0, 0xbb33, 0xc045,
    0x0, 0x0, 0xbb33, 0xc06c, 0x0, 0x0, 0xbb33, 0xc095,
    0x0, 0x0, 0xbb33, 0xc0c1, 0x0, 0x0, 0xbb33, 0xc0ef,
    0x0, 0x0, 0xbb33, 0xc121, 0x0, 0x0, 0xbb33, 0xc157,
    0x0, 0x0, 0xbb33, 0xc190, 0x0, 0x0, 0xbb33, 0xc1ce,
    0x0, 0x0, 0xbb33, 0xc211, 0x0, 0x0, 0xbb33, 0xc25a,
    0x0, 0x0, 0xbb33, 0xc2aa, 0x0, 0x0, 0xbb33, 0xc301,
    0x0, 0x0, 0xbb33, 0xc361, 0x0, 0x0, 0xbb33, 0xc3cb,
    0x0, 0x0, 0xbb33, 0xc420, 0x0, 0x0, 0xbb33, 0xc462,
    0x0, 0x0, 0xbb33, 0xc4ad, 0x0, 0x0, 0xbb33, 0xc501,
    0x0, 0x0, 0xbb33, 0xc562, 0x0, 0x0, 0xbb33, 0xc5d2,
    0x0, 0x0, 0xbb33, 0xc656, 0x0, 0x0, 0xbb33, 0xc6f2,
    0x0, 0x0, 0xbb33, 0xc7af, 0x0, 0x0, 0xbb33, 0xc84c,
    0x0, 0x0, 0xbb33, 0xc8e0, 0x0, 0x0, 0xbb33, 0xc9a1,
    0x0, 0x0, 0xbb33, 0xcaa8, 0x0, 0x0, 0xbb33, 0xcc12,
    0x0, 0x0, 0xbb33, 0xcd3c, 0x0, 0x0, 0xbb33, 0xcf55,
    0x0, 0x0, 0xbb33, 0xd21c, 0x0, 0x0, 0xbb33, 0xd895
    };

static const uint16_t in_cfft_step_1024[2048] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0
    };

static const uint16_t in_cifft_step_1024[2048] = {
    0x5f33, 0x0, 0xbb33, 0x5c95, 0x0, 0x0, 0xbb33, 0x561d,
    0x0, 0x0, 0xbb33, 0x5355, 0x0, 0x0, 0xbb33, 0x513d,
    0x0, 0x0, 0xbb33, 0x5013, 0x0, 0x0, 0xbb33, 0x4eaa,
    0x0, 0x0, 0xbb33, 0x4da3, 0x0, 0x0, 0xbb33, 0x4ce3,
    0x0, 0x0, 0xbb33, 0x4c4f, 0x0, 0x0, 0xbb33, 0x4bb6,
    0x0, 0x0, 0xbb33, 0x4afa, 0x0, 0x0, 0xbb33, 0x4a5e,
    0x0, 0x0, 0xbb33, 0x49db, 0x0, 0x0, 0xbb33, 0x496c,
    0x0, 0x0, 0xbb33, 0x490b, 0x0, 0x0, 0xbb33, 0x48b8,
    0x0, 0x0, 0xbb33, 0x486e, 0x0, 0x0, 0xbb33, 0x482d,
    0x0, 0x0, 0xbb33, 0x47e5, 0x0, 0x0, 0xbb33, 0x477c,
    0x0, 0x0, 0xbb33, 0x471e, 0x0, 0x0, 0xbb33, 0x46c8,
    0x0, 0x0, 0xbb33, 0x467a, 0x0, 0x0, 0xbb33, 0x4633,
    0x0, 0x0, 0xbb33, 0x45f1, 0x0, 0x0, 0xbb33, 0x45b4,
    0x0, 0x0, 0xbb33, 0x457c, 0x0, 0x0, 0xbb33, 0x4548,
    0x0, 0x0, 0xbb33, 0x4518, 0x0, 0x0, 0xbb33, 0x44eb,
    0x0, 0x0, 0xbb33, 0x44c1, 0x0, 0x0, 0xbb33, 0x4499,
    0x0, 0x0, 0xbb33, 0x4474, 0x0, 0x0, 0xbb33, 0x4451,
    0x0, 0x0, 0xbb33, 0x4430, 0x0, 0x0, 0xbb33, 0x4411,
    0x0, 0x0, 0xbb33, 0x43e7, 0x0, 0x0, 0xbb33, 0x43af,
    0x0, 0x0, 0xbb33, 0x437a, 0x0, 0x0, 0xbb33, 0x4348,
    0x0, 0x0, 0xbb33, 0x4318, 0x0, 0x0, 0xbb33, 0x42ea,
    0x0, 0x0, 0xbb33, 0x42bf, 0x0, 0x0, 0xbb33, 0x4295,
    0x0, 0x0, 0xbb33, 0x426d, 0x0, 0x0, 0xbb33, 0x4247,
    0x0, 0x0, 0xbb33, 0x4223, 0x0, 0x0, 0xbb33, 0x4200,
    0x0, 0x0, 0xbb33, 0x41de, 0x0, 0x0, 0xbb33, 0x41be,
    0x0, 0x0, 0xbb33, 0x419f, 0x0, 0x0, 0xbb33, 0x4181,
    0x0, 0x0, 0xbb33, 0x4165, 0x0, 0x0, 0xbb33, 0x4149,
    0x0, 0x0, 0xbb33, 0x412e, 0x0, 0x0, 0xbb33, 0x4114,
    0x0, 0x0, 0xbb33, 0x40fb, 0x0, 0x0, 0xbb33, 0x40e3,
    0x0, 0x0, 0xbb33, 0x40cc, 0x0, 0x0, 0xbb33, 0x40b6,
    0x0, 0x0, 0xbb33, 0x40a0, 0x0, 0x0, 0xbb33, 0x408b,
    0x0, 0x0, 0xbb33, 0x4076, 0x0, 0x0, 0xbb33, 0x4062,
    0x0, 0x0, 0xbb33, 0x404f, 0x0, 0x0, 0xbb33, 0x403c,
    0x0, 0x0, 0xbb33, 0x402a, 0x0, 0x0, 0xbb33, 0x4018,
    0x0, 0x0, 0xbb33, 0x4007, 0x0, 0x0, 0xbb33, 0x3fec,
    0x0, 0x0, 0xbb33, 0x3fcc, 0x0, 0x0, 0xbb33, 0x3fac,
    0x0, 0x0, 0xbb33, 0x3f8d, 0x0, 0x0, 0xbb33, 0x3f6f,
    0x0, 0x0, 0xbb33, 0x3f52, 0x0, 0x0, 0xbb33, 0x3f35,
    0x0, 0x0, 0xbb33, 0x3f19, 0x0, 0x0, 0xbb33, 0x3efe,
    0x0, 0x0, 0xbb33, 0x3ee3, 0x0, 0x0, 0xbb33, 0x3ec9,
    0x0, 0x0, 0xbb33, 0x3eb0, 0x0, 0x0, 0xbb33, 0x3e97,
    0x0, 0x0, 0xbb33, 0x3e7e, 0x0, 0x0, 0xbb33, 0x3e67,
    0x0, 0x0, 0xbb33, 0x3e4f, 0x0, 0x0, 0xbb33, 0x3e38,
    0x0, 0x0, 0xbb33, 0x3e22, 0x0, 0x0, 0xbb33, 0x3e0c,
    0x0, 0x0, 0xbb33, 0x3df7, 0x0, 0x0, 0xbb33, 0x3de2,
    0x0, 0x0, 0xbb33, 0x3dcd, 0x0, 0x0, 0xbb33, 0x3db9,
    0x0, 0x0, 0xbb33, 0x3da6, 0x0, 0x0, 0xbb33, 0x3d92,
    0x0, 0x0, 0xbb33, 0x3d7f, 0x0, 0x0, 0xbb33, 0x3d6c,
    0x0, 0x0, 0xbb33, 0x3d5a, 0x0, 0x0, 0xbb33, 0x3d48,
    0x0, 0x0, 0xbb33, 0x3d36, 0x0, 0x0, 0xbb33, 0x3d25,
    0x0, 0x0, 0xbb33, 0x3d14, 0x0, 0x0, 0xbb33, 0x3d03,
    0x0, 0x0, 0xbb33, 0x3cf3, 0x0, 0x0, 0xbb33, 0x3ce3,
    0x0, 0x0, 0xbb33, 0x3cd3, 0x0, 0x0, 0xbb33, 0x3cc3,
    0x0, 0x0, 0xbb33, 0x3cb4, 0x0, 0x0, 0xbb33, 0x3ca4,
    0x0, 0x0, 0xbb33, 0x3c95, 0x0, 0x0, 0xbb33, 0x3c87,
    0x0, 0x0, 0xbb33, 0x3c78, 0x0, 0x0, 0xbb33, 0x3c6a,
    0x0, 0x0, 0xbb33, 0x3c5c, 0x0, 0x0, 0xbb33, 0x3c4e,
    0x0, 0x0, 0xbb33, 0x3c40, 0x0, 0x0, 0xbb33, 0x3c33,
    0x0, 0x0, 0xbb33, 0x3c26, 0x0, 0x0, 0xbb33, 0x3c19,
    0x0, 0x0, 0xbb33, 0x3c0c, 0x0, 0x0, 0xbb33, 0x3bfe,
    0x0, 0x0, 0xbb33, 0x3be5, 0x0, 0x0, 0xbb33, 0x3bcc,
    0x0, 0x0, 0xbb33, 0x3bb4, 0x0, 0x0, 0xbb33, 0x3b9c,
    0x0, 0x0, 0xbb33, 0x3b84, 0x0, 0x0, 0xbb33, 0x3b6d,
    0x0, 0x0, 0xbb33, 0x3b55, 0x0, 0x0, 0xbb33, 0x3b3f,
    0x0, 0x0, 0xbb33, 0x3b28, 0x0, 0x0, 0xbb33, 0x3b12,
    0x0, 0x0, 0xbb33, 0x3afc, 0x0, 0x0, 0xbb33, 0x3ae6,
    0x0, 0x0, 0xbb33, 0x3ad0, 0x0, 0x0, 0xbb33, 0x3abb,
    0x0, 0x0, 0xbb33, 0x3aa6, 0x0, 0x0, 0xbb33, 0x3a91,
    0x0, 0x0, 0xbb33, 0x3a7c, 0x0, 0x0, 0xbb33, 0x3a68,
    0x0, 0x0, 0xbb33, 0x3a54, 0x0, 0x0, 0xbb33, 0x3a40,
    0x0, 0x0, 0xbb33, 0x3a2c, 0x0, 0x0, 0xbb33, 0x3a19,
    0x0, 0x0, 0xbb33, 0x3a05, 0x0, 0x0, 0xbb33, 0x39f2,
    0x0, 0x0, 0xbb33, 0x39df, 0x0, 0x0, 0xbb33, 0x39cc,
    0x0, 0x0, 0xbb33, 0x39ba, 0x0, 0x0, 0xbb33, 0x39a8,
    0x0, 0x0, 0xbb33, 0x3995, 0x0, 0x0, 0xbb33, 0x3983,
    0x0, 0x0, 0xbb33, 0x3971, 0x0, 0x0, 0xbb33, 0x3960,
    0x0, 0x0, 0xbb33, 0x394e, 0x0, 0x0, 0xbb33, 0x393d,
    0x0, 0x0, 0xbb33, 0x392c, 0x0, 0x0, 0xbb33, 0x391b,
    0x0, 0x0, 0xbb33, 0x390a, 0x0, 0x0, 0xbb33, 0x38f9,
    0x0, 0x0, 0xbb33, 0x38e8, 0x0, 0x0, 0xbb33, 0x38d8,
    0x0, 0x0, 0xbb33, 0x38c7, 0x0, 0x0, 0xbb33, 0x38b7,
    0x0, 0x0, 0xbb33, 0x38a7, 0x0, 0x0, 0xbb33, 0x3897,
    0x0, 0x0, 0xbb33, 0x3887, 0x0, 0x0, 0xbb33, 0x3878,
    0x0, 0x0, 0xbb33, 0x3868, 0x0, 0x0, 0xbb33, 0x3858,
    0x0, 0x0, 0xbb33, 0x3849, 0x0, 0x0, 0xbb33, 0x383a,
    0x0, 0x0, 0xbb33, 0x382b, 0x0, 0x0, 0xbb33, 0x381c,
    0x0, 0x0, 0xbb33, 0x380d, 0x0, 0x0, 0xbb33, 0x37fc,
    0x0, 0x0, 0xbb33, 0x37de, 0x0, 0x0, 0xbb33, 0x37c1,
    0x0, 0x0, 0xbb33, 0x37a4, 0x0, 0x0, 0xbb33, 0x3787,
    0x0, 0x0, 0xbb33, 0x376a, 0x0, 0x0, 0xbb33, 0x374e,
    0x0, 0x0, 0xbb33, 0x3731, 0x0, 0x0, 0xbb33, 0x3715,
    0x0, 0x0, 0xbb33, 0x36f9, 0x0, 0x0, 0xbb33, 0x36dd,
    0x0, 0x0, 0xbb33, 0x36c2, 0x0, 0x0, 0xbb33, 0x36a6,
    0x0, 0x0, 0xbb33, 0x368b, 0x0, 0x0, 0xbb33, 0x3670,
    0x0, 0x0, 0xbb33, 0x3655, 0x0, 0x0, 0xbb33, 0x363a,
    0x0, 0x0, 0xbb33, 0x361f, 0x0, 0x0, 0xbb33, 0x3604,
    0x0, 0x0, 0xbb33, 0x35ea, 0x0, 0x0, 0xbb33, 0x35cf,
    0x0, 0x0, 0xbb33, 0x35b5, 0x0, 0x0, 0xbb33, 0x359b,
    0x0, 0x0, 0xbb33, 0x3581, 0x0, 0x0, 0xbb33, 0x3567,
    0x0, 0x0, 0xbb33, 0x354d, 0x0, 0x0, 0xbb33, 0x3534,
    0x0, 0x0, 0xbb33, 0x351a, 0x0, 0x0, 0xbb33, 0x3501,
    0x0, 0x0, 0xbb33, 0x34e8, 0x0, 0x0, 0xbb33, 0x34ce,
    0x0, 0x0, 0xbb33, 0x34b5, 0x0, 0x0, 0xbb33, 0x349c,
    0x0, 0x0, 0xbb33, 0x3483, 0x0, 0x0, 0xbb33, 0x346b,
    0x0, 0x0, 0xbb33, 0x3452, 0x0, 0x0, 0xbb33, 0x3439,
    0x0, 0x0, 0xbb33, 0x3421, 0x0, 0x0, 0xbb33, 0x3408,
    0x0, 0x0, 0xbb33, 0x33e0, 0x0, 0x0, 0xbb33, 0x33af,
    0x0, 0x0, 0xbb33, 0x337f, 0x0, 0x0, 0xbb33, 0x334f,
    0x0, 0x0, 0xbb33, 0x331f, 0x0, 0x0, 0xbb33, 0x32ef,
    0x0, 0x0, 0xbb33, 0x32bf, 0x0, 0x0, 0xbb33, 0x328f,
    0x0, 0x0, 0xbb33, 0x3260, 0x0, 0x0, 0xbb33, 0x3230,
    0x0, 0x0, 0xbb33, 0x3201, 0x0, 0x0, 0xbb33, 0x31d2,
    0x0, 0x0, 0xbb33, 0x31a3, 0x0, 0x0, 0xbb33, 0x3174,
    0x0, 0x0, 0xbb33, 0x3145, 0x0, 0x0, 0xbb33, 0x3117,
    0x0, 0x0, 0xbb33, 0x30e8, 0x0, 0x0, 0xbb33, 0x30ba,
    0x0, 0x0, 0xbb33, 0x308b, 0x0, 0x0, 0xbb33, 0x305d,
    0x0, 0x0, 0xbb33, 0x302f, 0x0, 0x0, 0xbb33, 0x3000,
    0x0, 0x0, 0xbb33, 0x2fa5, 0x0, 0x0, 0xbb33, 0x2f49,
    0x0, 0x0, 0xbb33, 0x2eed, 0x0, 0x0, 0xbb33, 0x2e91,
    0x0, 0x0, 0xbb33, 0x2e35, 0x0, 0x0, 0xbb33, 0x2dda,
    0x0, 0x0, 0xbb33, 0x2d7f, 0x0, 0x0, 0xbb33, 0x2d23,
    0x0, 0x0, 0xbb33, 0x2cc8, 0x0, 0x0, 0xbb33, 0x2c6d,
    0x0, 0x0, 0xbb33, 0x2c12, 0x0, 0x0, 0xbb33, 0x2b6f,
    0x0, 0x0, 0xbb33, 0x2ab9, 0x0, 0x0, 0xbb33, 0x2a04,
    0x0, 0x0, 0xbb33, 0x294e, 0x0, 0x0, 0xbb33, 0x2899,
    0x0, 0x0, 0xbb33, 0x27c7, 0x0, 0x0, 0xbb33, 0x265d,
    0x0, 0x0, 0xbb33, 0x24f3, 0x0, 0x0, 0xbb33, 0x2312,
    0x0, 0x0, 0xbb33, 0x203e, 0x0, 0x0, 0xbb33, 0x19a8,
    0x0, 0x0, 0xbb33, 0x99a8, 0x0, 0x0, 0xbb33, 0xa03e,
    0x0, 0x0, 0xbb33, 0xa312, 0x0, 0x0, 0xbb33, 0xa4f3,
    0x0, 0x0, 0xbb33, 0xa65d, 0x0, 0x0, 0xbb33, 0xa7c7,
    0x0, 0x0, 0xbb33, 0xa899, 0x0, 0x0, 0xbb33, 0xa94e,
    0x0, 0x0, 0xbb33, 0xaa04, 0x0, 0x0, 0xbb33, 0xaab9,
    0x0, 0x0, 0xbb33, 0xab6f, 0x0, 0x0, 0xbb33, 0xac12,
    0x0, 0x0, 0xbb33, 0xac6d, 0x0, 0x0, 0xbb33, 0xacc8,
    0x0, 0x0, 0xbb33, 0xad23, 0x0, 0x0, 0xbb33, 0xad7f,
    0x0, 0x0, 0xbb33, 0xadda, 0x0, 0x0, 0xbb33, 0xae35,
    0x0, 0x0, 0xbb33, 0xae91, 0x0, 0x0, 0xbb33, 0xaeed,
    0x0, 0x0, 0xbb33, 0xaf49, 0x0, 0x0, 0xbb33, 0xafa5,
    0x0, 0x0, 0xbb33, 0xb000, 0x0, 0x0, 0xbb33, 0xb02f,
    0x0, 0x0, 0xbb33, 0xb05d, 0x0, 0x0, 0xbb33, 0xb08b,
    0x0, 0x0, 0xbb33, 0xb0ba, 0x0, 0x0, 0xbb33, 0xb0e8,
    0x0, 0x0, 0xbb33, 0xb117, 0x0, 0x0, 0xbb33, 0xb145,
    0x0, 0x0, 0xbb33, 0xb174, 0x0, 0x0, 0xbb33, 0xb1a3,
    0x0, 0x0, 0xbb33, 0xb1d2, 0x0, 0x0, 0xbb33, 0xb201,
    0x0, 0x0, 0xbb33, 0xb230, 0x0, 0x0, 0xbb33, 0xb260,
    0x0, 0x0, 0xbb33, 0xb28f, 0x0, 0x0, 0xbb33, 0xb2bf,
    0x0, 0x0, 0xbb33, 0xb2ef, 0x0, 0x0, 0xbb33, 0xb31f,
    0x0, 0x0, 0xbb33, 0xb34f, 0x0, 0x0, 0xbb33, 0xb37f,
    0x0, 0x0, 0xbb33, 0xb3af, 0x0, 0x0, 0xbb33, 0xb3e0,
    0x0, 0x0, 0xbb33, 0xb408, 0x0, 0x0, 0xbb33, 0xb421,
    0x0, 0x0, 0xbb33, 0xb439, 0x0, 0x0, 0xbb33, 0xb452,
    0x0, 0x0, 0xbb33, 0xb46b, 0x0, 0x0, 0xbb33, 0xb483,
    0x0, 0x0, 0xbb33, 0xb49c, 0x0, 0x0, 0xbb33, 0xb4b5,
    0x0, 0x0, 0xbb33, 0xb4ce, 0x0, 0x0, 0xbb33, 0xb4e8,
    0x0, 0x0, 0xbb33, 0xb501, 0x0, 0x0, 0xbb33, 0xb51a,
    0x0, 0x0, 0xbb33, 0xb534, 0x0, 0x0, 0xbb33, 0xb54d,
    0x0, 0x0, 0xbb33, 0xb567, 0x0, 0x0, 0xbb33, 0xb581,
    0x0, 0x0, 0xbb33, 0xb59b, 0x0, 0x0, 0xbb33, 0xb5b5,
    0x0, 0x0, 0xbb33, 0xb5cf, 0x0, 0x0, 0xbb33, 0xb5ea,
    0x0, 0x0, 0xbb33, 0xb604, 0x0, 0x0, 0xbb33, 0xb61f,
    0x0, 0x0, 0xbb33, 0xb63a, 0x0, 0x0, 0xbb33, 0xb655,
    0x0, 0x0, 0xbb33, 0xb670, 0x0, 0x0, 0xbb33, 0xb68b,
    0x0, 0x0, 0xbb33, 0xb6a6, 0x0, 0x0, 0xbb33, 0xb6c2,
    0x0, 0x0, 0xbb33, 0xb6dd, 0x0, 0x0, 0xbb33, 0xb6f9,
    0x0, 0x0, 0xbb33, 0xb715, 0x0, 0x0, 0xbb33, 0xb731,
    0x0, 0x0, 0xbb33, 0xb74e, 0x0, 0x0, 0xbb33, 0xb76a,
    0x0, 0x0, 0xbb33, 0xb787, 0x0, 0x0, 0xbb33, 0xb7a4,
    0x0, 0x0, 0xbb33, 0xb7c1, 0x0, 0x0, 0xbb33, 0xb7de,
    0x0, 0x0, 0xbb33, 0xb7fc, 0x0, 0x0, 0xbb33, 0xb80d,
    0x0, 0x0, 0xbb33, 0xb81c, 0x0, 0x0, 0xbb33, 0xb82b,
    0x0, 0x0, 0xbb33, 0xb83a, 0x0, 0x0, 0xbb33, 0xb849,
    0x0, 0x0, 0xbb33, 0xb858, 0x0, 0x0, 0xbb33, 0xb868,
    0x0, 0x0, 0xbb33, 0xb878, 0x0, 0x0, 0xbb33, 0xb887,
    0x0, 0x0, 0xbb33, 0xb897, 0x0, 0x0, 0xbb33, 0xb8a7,
    0x0, 0x0, 0xbb33, 0xb8b7, 0x0, 0x0, 0xbb33, 0xb8c7,
    0x0, 0x0, 0xbb33, 0xb8d8, 0x0, 0x0, 0xbb33, 0xb8e8,
    0x0, 0x0, 0xbb33, 0xb8f9, 0x0, 0x0, 0xbb33, 0xb90a,
    0x0, 0x0, 0xbb33, 0xb91b, 0x0, 0x0, 0xbb33, 0xb92c,
    0x0, 0x0, 0xbb33, 0xb93d, 0x0, 0x0, 0xbb33, 0xb94e,
    0x0, 0x0, 0xbb33, 0xb960, 0x0, 0x0, 0xbb33, 0xb971,
    0x0, 0x0, 0xbb33, 0xb983, 0x0, 0x0, 0xbb33, 0xb995,
    0x0, 0x0, 0xbb33, 0xb9a8, 0x0, 0x0, 0xbb33, 0xb9ba,
    0x0, 0x0, 0xbb33, 0xb9cc, 0x0, 0x0, 0xbb33, 0xb9df,
    0x0, 0x0, 0xbb33, 0xb9f2, 0x0, 0x0, 0xbb33, 0xba05,
    0x0, 0x0, 0xbb33, 0xba19, 0x0, 0x0, 0xbb33, 0xba2c,
    0x0, 0x0, 0xbb33, 0xba40, 0x0, 0x0, 0xbb33, 0xba54,
    0x0, 0x0, 0xbb33, 0xba68, 0x0, 0x0, 0xbb33, 0xba7c,
    0x0, 0x0, 0xbb33, 0xba91, 0x0, 0x0, 0xbb33, 0xbaa6,
    0x0, 0x0, 0xbb33, 0xbabb, 0x0, 0x0, 0xbb33, 0xbad0,
    0x0, 0x0, 0xbb33, 0xbae6, 0x0, 0x0, 0xbb33, 0xbafc,
    0x0, 0x0, 0xbb33, 0xbb12, 0x0, 0x0, 0xbb33, 0xbb28,
    0x0, 0x0, 0xbb33, 0xbb3f, 0x0, 0x0, 0xbb33, 0xbb55,
    0x0, 0x0, 0xbb33, 0xbb6d, 0x0, 0x0, 0xbb33, 0xbb84,
    0x0, 0x0, 0xbb33, 0xbb9c, 0x0, 0x0, 0xbb33, 0xbbb4,
    0x0, 0x0, 0xbb33, 0xbbcc, 0x0, 0x0, 0xbb33, 0xbbe5,
    0x0, 0x0, 0xbb33, 0xbbfe, 0x0, 0x0, 0xbb33, 0xbc0c,
    0x0, 0x0, 0xbb33, 0xbc19, 0x0, 0x0, 0xbb33, 0xbc26,
    0x0, 0x0, 0xbb33, 0xbc33, 0x0, 0x0, 0xbb33, 0xbc40,
    0x0, 0x0, 0xbb33, 0xbc4e, 0x0, 0x0, 0xbb33, 0xbc5c,
    0x0, 0x0, 0xbb33, 0xbc6a, 0x0, 0x0, 0xbb33, 0xbc78,
    0x0, 0x0, 0xbb33, 0xbc87, 0x0, 0x0, 0xbb33, 0xbc95,
    0x0, 0x0, 0xbb33, 0xbca4, 0x0, 0x0, 0xbb33, 0xbcb4,
    0x0, 0x0, 0xbb33, 0xbcc3, 0x0, 0x0, 0xbb33, 0xbcd3,
    0x0, 0x0, 0xbb33, 0xbce3, 0x0, 0x0, 0xbb33, 0xbcf3,
    0x0, 0x0, 0xbb33, 0xbd03, 0x0, 0x0, 0xbb33, 0xbd14,
    0x0, 0x0, 0xbb33, 0xbd25, 0x0, 0x0, 0xbb33, 0xbd36,
    0x0, 0x0, 0xbb33, 0xbd48, 0x0, 0x0, 0xbb33, 0xbd5a,
    0x0, 0x0, 0xbb33, 0xbd6c, 0x0, 0x0, 0xbb33, 0xbd7f,
    0x0, 0x0, 0xbb33, 0xbd92, 0x0, 0x0, 0xbb33, 0xbda6,
    0x0, 0x0, 0xbb33, 0xbdb9, 0x0, 0x0, 0xbb33, 0xbdcd,
    0x0, 0x0, 0xbb33, 0xbde2, 0x0, 0x0, 0xbb33, 0xbdf7,
    0x0, 0x0, 0xbb33, 0xbe0c, 0x0, 0x0, 0xbb33, 0xbe22,
    0x0, 0x0, 0xbb33, 0xbe38, 0x0, 0x0, 0xbb33, 0xbe4f,
    0x0, 0x0, 0xbb33, 0xbe67, 0x0, 0x0, 0xbb33, 0xbe7e,
    0x0, 0x0, 0xbb33, 0xbe97, 0x0, 0x0, 0xbb33, 0xbeb0,
    0x0, 0x0, 0xbb33, 0xbec9, 0x0, 0x0, 0xbb33, 0xbee3,
    0x0, 0x0, 0xbb33, 0xbefe, 0x0, 0x0, 0xbb33, 0xbf19,
    0x0, 0x0, 0xbb33, 0xbf35, 0x0, 0x0, 0xbb33, 0xbf52,
    0x0, 0x0, 0xbb33, 0xbf6f, 0x0, 0x0, 0xbb33, 0xbf8d,
    0x0, 0x0, 0xbb33, 0xbfac, 0x0, 0x0, 0xbb33, 0xbfcc,
    0x0, 0x0, 0xbb33, 0xbfec, 0x0, 0x0, 0xbb33, 0xc007,
    0x0, 0x0, 0xbb33, 0xc018, 0x0, 0x0, 0xbb33, 0xc02a,
    0x0, 0x0, 0xbb33, 0xc03c, 0x0, 0x0, 0xbb33, 0xc04f,
    0x0, 0x0, 0xbb33, 0xc062, 0x0, 0x0, 0xbb33, 0xc076,
    0x0, 0x0, 0xbb33, 0xc08b, 0x0, 0x0, 0xbb33, 0xc0a0,
    0x0, 0x0, 0xbb33, 0xc0b6, 0x0, 0x0, 0xbb33, 0xc0cc,
    0x0, 0x0, 0xbb33, 0xc0e3, 0x0, 0x0, 0xbb33, 0xc0fb,
    0x0, 0x0, 0xbb33, 0xc114, 0x0, 0x0, 0xbb33, 0xc12e,
    0x0, 0x0, 0xbb33, 0xc149, 0x0, 0x0, 0xbb33, 0xc165,
    0x0, 0x0, 0xbb33, 0xc181, 0x0, 0x0, 0xbb33, 0xc19f,
    0x0, 0x0, 0xbb33, 0xc1be, 0x0, 0x0, 0xbb33, 0xc1de,
    0x0, 0x0, 0xbb33, 0xc200, 0x0, 0x0, 0xbb33, 0xc223,
    0x0, 0x0, 0xbb33, 0xc247, 0x0, 0x0, 0xbb33, 0xc26d,
    0x0, 0x0, 0xbb33, 0xc295, 0x0, 0x0, 0xbb33, 0xc2bf,
    0x0, 0x0, 0xbb33, 0xc2ea, 0x0, 0x0, 0xbb33, 0xc318,
    0x0, 0x0, 0xbb33, 0xc348, 0x0, 0x0, 0xbb33, 0xc37a,
    0x0, 0x0, 0xbb33, 0xc3af, 0x0, 0x0, 0xbb33, 0xc3e7,
    0x0, 0x0, 0xbb33, 0xc411, 0x0, 0x0, 0xbb33, 0xc430,
    0x0, 0x0, 0xbb33, 0xc451, 0x0, 0x0, 0xbb33, 0xc474,
    0x0, 0x0, 0xbb33, 0xc499, 0x0, 0x0, 0xbb33, 0xc4c1,
    0x0, 0x0, 0xbb33, 0xc4eb, 0x0, 0x0, 0xbb33, 0xc518,
    0x0, 0x0, 0xbb33, 0xc548, 0x0, 0x0, 0xbb33, 0xc57c,
    0x0, 0x0, 0xbb33, 0xc5b4, 0x0, 0x0, 0xbb33, 0xc5f1,
    0x0, 0x0, 0xbb33, 0xc633, 0x0, 0x0, 0xbb33, 0xc67a,
    0x0, 0x0, 0xbb33, 0xc6c8, 0x0, 0x0, 0xbb33, 0xc71e,
    0x0, 0x0, 0xbb33, 0xc77c, 0x0, 0x0, 0xbb33, 0xc7e5,
    0x0, 0x0, 0xbb33, 0xc82d, 0x0, 0x0, 0xbb33, 0xc86e,
    0x0, 0x0, 0xbb33, 0xc8b8, 0x0, 0x0, 0xbb33, 0xc90b,
    0x0, 0x0, 0xbb33, 0xc96c, 0x0, 0x0, 0xbb33, 0xc9db,
    0x0, 0x0, 0xbb33, 0xca5e, 0x0, 0x0, 0xbb33, 0xcafa,
    0x0, 0x0, 0xbb33, 0xcbb6, 0x0, 0x0, 0xbb33, 0xcc4f,
    0x0, 0x0, 0xbb33, 0xcce3, 0x0, 0x0, 0xbb33, 0xcda3,
    0x0, 0x0, 0xbb33, 0xceaa, 0x0, 0x0, 0xbb33, 0xd013,
    0x0, 0x0, 0xbb33, 0xd13d, 0x0, 0x0, 0xbb33, 0xd355,
    0x0, 0x0, 0xbb33, 0xd61d, 0x0, 0x0, 0xbb33, 0xdc95
    };

static const uint16_t ref_cfft_step_1024[2048] = {
    0x5f33, 0x0, 0xbb33, 0x5c95, 0x0, 0x0, 0xbb33, 0x561d,
    0x0, 0x0, 0xbb33, 0x5355, 0x0, 0x0, 0xbb33, 0x513d,
    0x0, 0x0, 0xbb33, 0x5013, 0x0, 0x0, 0xbb33, 0x4eaa,
    0x0, 0x0, 0xbb33, 0x4da3, 0x0, 0x0, 0xbb33, 0x4ce3,
    0x0, 0x0, 0xbb33, 0x4c4f, 0x0, 0x0, 0xbb33, 0x4bb6,
    0x0, 0x0, 0xbb33, 0x4afa, 0x0, 0x0, 0xbb33, 0x4a5e,
    0x0, 0x0, 0xbb33, 0x49db, 0x0, 0x0, 0xbb33, 0x496c,
    0x0, 0x0, 0xbb33, 0x490b, 0x0, 0x0, 0xbb33, 0x48b8,
    0x0, 0x0, 0xbb33, 0x486e, 0x0, 0x0, 0xbb33, 0x482d,
    0x0, 0x0, 0xbb33, 0x47e5, 0x0, 0x0, 0xbb33, 0x477c,
    0x0, 0x0, 0xbb33, 0x471e, 0x0, 0x0, 0xbb33, 0x46c8,
    0x0, 0x0, 0xbb33, 0x467a, 0x0, 0x0, 0xbb33, 0x4633,
    0x0, 0x0, 0xbb33, 0x45f1, 0x0, 0x0, 0xbb33, 0x45b4,
    0x0, 0x0, 0xbb33, 0x457c, 0x0, 0x0, 0xbb33, 0x4548,
    0x0, 0x0, 0xbb33, 0x4518, 0x0, 0x0, 0xbb33, 0x44eb,
    0x0, 0x0, 0xbb33, 0x44c1, 0x0, 0x0, 0xbb33, 0x4499,
    0x0, 0x0, 0xbb33, 0x4474, 0x0, 0x0, 0xbb33, 0x4451,
    0x0, 0x0, 0xbb33, 0x4430, 0x0, 0x0, 0xbb33, 0x4411,
    0x0, 0x0, 0xbb33, 0x43e7, 0x0, 0x0, 0xbb33, 0x43af,
    0x0, 0x0, 0xbb33, 0x437a, 0x0, 0x0, 0xbb33, 0x4348,
    0x0, 0x0, 0xbb33, 0x4318, 0x0, 0x0, 0xbb33, 0x42ea,
    0x0, 0x0, 0xbb33, 0x42bf, 0x0, 0x0, 0xbb33, 0x4295,
    0x0, 0x0, 0xbb33, 0x426d, 0x0, 0x0, 0xbb33, 0x4247,
    0x0, 0x0, 0xbb33, 0x4223, 0x0, 0x0, 0xbb33, 0x4200,
    0x0, 0x0, 0xbb33, 0x41de, 0x0, 0x0, 0xbb33, 0x41be,
    0x0, 0x0, 0xbb33, 0x419f, 0x0, 0x0, 0xbb33, 0x4181,
    0x0, 0x0, 0xbb33, 0x4165, 0x0, 0x0, 0xbb33, 0x4149,
    0x0, 0x0, 0xbb33, 0x412e, 0x0, 0x0, 0xbb33, 0x4114,
    0x0, 0x0, 0xbb33, 0x40fb, 0x0, 0x0, 0xbb33, 0x40e3,
    0x0, 0x0, 0xbb33, 0x40cc, 0x0, 0x0, 0xbb33, 0x40b6,
    0x0, 0x0, 0xbb33, 0x40a0, 0x0, 0x0, 0xbb33, 0x408b,
    0x0, 0x0, 0xbb33, 0x4076, 0x0, 0x0, 0xbb33, 0x4062,
    0x0, 0x0, 0xbb33, 0x404f, 0x0, 0x0, 0xbb33, 0x403c,
    0x0, 0x0, 0xbb33, 0x402a, 0x0, 0x0, 0xbb33, 0x4018,
    0x0, 0x0, 0xbb33, 0x4007, 0x0, 0x0, 0xbb33, 0x3fec,
    0x0, 0x0, 0xbb33, 0x3fcc, 0x0, 0x0, 0xbb33, 0x3fac,
    0x0, 0x0, 0xbb33, 0x3f8d, 0x0, 0x0, 0xbb33, 0x3f6f,
    0x0, 0x0, 0xbb33, 0x3f52, 0x0, 0x0, 0xbb33, 0x3f35,
    0x0, 0x0, 0xbb33, 0x3f19, 0x0, 0x0, 0xbb33, 0x3efe,
    0x0, 0x0, 0xbb33, 0x3ee3, 0x0, 0x0, 0xbb33, 0x3ec9,
    0x0, 0x0, 0xbb33, 0x3eb0, 0x0, 0x0, 0xbb33, 0x3e97,
    0x0, 0x0, 0xbb33, 0x3e7e, 0x0, 0x0, 0xbb33, 0x3e67,
    0x0, 0x0, 0xbb33, 0x3e4f, 0x0, 0x0, 0xbb33, 0x3e38,
    0x0, 0x0, 0xbb33, 0x3e22, 0x0, 0x0, 0xbb33, 0x3e0c,
    0x0, 0x0, 0xbb33, 0x3df7, 0x0, 0x0, 0xbb33, 0x3de2,
    0x0, 0x0, 0xbb33, 0x3dcd, 0x0, 0x0, 0xbb33, 0x3db9,
    0x0, 0x0, 0xbb33, 0x3da6, 0x0, 0x0, 0xbb33, 0x3d92,
    0x0, 0x0, 0xbb33, 0x3d7f, 0x0, 0x0, 0xbb33, 0x3d6c,
    0x0, 0x0, 0xbb33, 0x3d5a, 0x0, 0x0, 0xbb33, 0x3d48,
    0x0, 0x0, 0xbb33, 0x3d36, 0x0, 0x0, 0xbb33, 0x3d25,
    0x0, 0x0, 0xbb33, 0x3d14, 0x0, 0x0, 0xbb33, 0x3d03,
    0x0, 0x0, 0xbb33, 0x3cf3, 0x0, 0x0, 0xbb33, 0x3ce3,
    0x0, 0x0, 0xbb33, 0x3cd3, 0x0, 0x0, 0xbb33, 0x3cc3,
    0x0, 0x0, 0xbb33, 0x3cb4, 0x0, 0x0, 0xbb33, 0x3ca4,
    0x0, 0x0, 0xbb33, 0x3c95, 0x0, 0x0, 0xbb33, 0x3c87,
    0x0, 0x0, 0xbb33, 0x3c78, 0x0, 0x0, 0xbb33, 0x3c6a,
    0x0, 0x0, 0xbb33, 0x3c5c, 0x0, 0x0, 0xbb33, 0x3c4e,
    0x0, 0x0, 0xbb33, 0x3c40, 0x0, 0x0, 0xbb33, 0x3c33,
    0x0, 0x0, 0xbb33, 0x3c26, 0x0, 0x0, 0xbb33, 0x3c19,
    0x0, 0x0, 0xbb33, 0x3c0c, 0x0, 0x0, 0xbb33, 0x3bfe,
    0x0, 0x0, 0xbb33, 0x3be5, 0x0, 0x0, 0xbb33, 0x3bcc,
    0x0, 0x0, 0xbb33, 0x3bb4, 0x0, 0x0, 0xbb33, 0x3b9c,
    0x0, 0x0, 0xbb33, 0x3b84, 0x0, 0x0, 0xbb33, 0x3b6d,
    0x0, 0x0, 0xbb33, 0x3b55, 0x0, 0x0, 0xbb33, 0x3b3f,
    0x0, 0x0, 0xbb33, 0x3b28, 0x0, 0x0, 0xbb33, 0x3b12,
    0x0, 0x0, 0xbb33, 0x3afc, 0x0, 0x0, 0xbb33, 0x3ae6,
    0x0, 0x0, 0xbb33, 0x3ad0, 0x0, 0x0, 0xbb33, 0x3abb,
    0x0, 0x0, 0xbb33, 0x3aa6, 0x0, 0x0, 0xbb33, 0x3a91,
    0x0, 0x0, 0xbb33, 0x3a7c, 0x0, 0x0, 0xbb33, 0x3a68,
    0x0, 0x0, 0xbb33, 0x3a54, 0x0, 0x0, 0xbb33, 0x3a40,
    0x0, 0x0, 0xbb33, 0x3a2c, 0x0, 0x0, 0xbb33, 0x3a19,
    0x0, 0x0, 0xbb33, 0x3a05, 0x0, 0x0, 0xbb33, 0x39f2,
    0x0, 0x0, 0xbb33, 0x39df, 0x0, 0x0, 0xbb33, 0x39cc,
    0x0, 0x0, 0xbb33, 0x39ba, 0x0, 0x0, 0xbb33, 0x39a8,
    0x0, 0x0, 0xbb33, 0x3995, 0x0, 0x0, 0xbb33, 0x3983,
    0x0, 0x0, 0xbb33, 0x3971, 0x0, 0x0, 0xbb33, 0x3960,
    0x0, 0x0, 0xbb33, 0x394e, 0x0, 0x0, 0xbb33, 0x393d,
    0x0, 0x0, 0xbb33, 0x392c, 0x0, 0x0, 0xbb33, 0x391b,
    0x0, 0x0, 0xbb33, 0x390a, 0x0, 0x0, 0xbb33, 0x38f9,
    0x0, 0x0, 0xbb33, 0x38e8, 0x0, 0x0, 0xbb33, 0x38d8,
    0x0, 0x0, 0xbb33, 0x38c7, 0x0, 0x0, 0xbb33, 0x38b7,
    0x0, 0x0, 0xbb33, 0x38a7, 0x0, 0x0, 0xbb33, 0x3897,
    0x0, 0x0, 0xbb33, 0x3887, 0x0, 0x0, 0xbb33, 0x3878,
    0x0, 0x0, 0xbb33, 0x3868, 0x0, 0x0, 0xbb33, 0x3858,
    0x0, 0x0, 0xbb33, 0x3849, 0x0, 0x0, 0xbb33, 0x383a,
    0x0, 0x0, 0xbb33, 0x382b, 0x0, 0x0, 0xbb33, 0x381c,
    0x0, 0x0, 0xbb33, 0x380d, 0x0, 0x0, 0xbb33, 0x37fc,
    0x0, 0x0, 0xbb33, 0x37de, 0x0, 0x0, 0xbb33, 0x37c1,
    0x0, 0x0, 0xbb33, 0x37a4, 0x0, 0x0, 0xbb33, 0x3787,
    0x0, 0x0, 0xbb33, 0x376a, 0x0, 0x0, 0xbb33, 0x374e,
    0x0, 0x0, 0xbb33, 0x3731, 0x0, 0x0, 0xbb33, 0x3715,
    0x0, 0x0, 0xbb33, 0x36f9, 0x0, 0x0, 0xbb33, 0x36dd,
    0x0, 0x0, 0xbb33, 0x36c2, 0x0, 0x0, 0xbb33, 0x36a6,
    0x0, 0x0, 0xbb33, 0x368b, 0x0, 0x0, 0xbb33, 0x3670,
    0x0, 0x0, 0xbb33, 0x3655, 0x0, 0x0, 0xbb33, 0x363a,
    0x0, 0x0, 0xbb33, 0x361f, 0x0, 0x0, 0xbb33, 0x3604,
    0x0, 0x0, 0xbb33, 0x35ea, 0x0, 0x0, 0xbb33, 0x35cf,
    0x0, 0x0, 0xbb33, 0x35b5, 0x0, 0x0, 0xbb33, 0x359b,
    0x0, 0x0, 0xbb33, 0x3581, 0x0, 0x0, 0xbb33, 0x3567,
    0x0, 0x0, 0xbb33, 0x354d, 0x0, 0x0, 0xbb33, 0x3534,
    0x0, 0x0, 0xbb33, 0x351a, 0x0, 0x0, 0xbb33, 0x3501,
    0x0, 0x0, 0xbb33, 0x34e8, 0x0, 0x0, 0xbb33, 0x34ce,
    0x0, 0x0, 0xbb33, 0x34b5, 0x0, 0x0, 0xbb33, 0x349c,
    0x0, 0x0, 0xbb33, 0x3483, 0x0, 0x0, 0xbb33, 0x346b,
    0x0, 0x0, 0xbb33, 0x3452, 0x0, 0x0, 0xbb33, 0x3439,
    0x0, 0x0, 0xbb33, 0x3421, 0x0, 0x0, 0xbb33, 0x3408,
    0x0, 0x0, 0xbb33, 0x33e0, 0x0, 0x0, 0xbb33, 0x33af,
    0x0, 0x0, 0xbb33, 0x337f, 0x0, 0x0, 0xbb33, 0x334f,
    0x0, 0x0, 0xbb33, 0x331f, 0x0, 0x0, 0xbb33, 0x32ef,
    0x0, 0x0, 0xbb33, 0x32bf, 0x0, 0x0, 0xbb33, 0x328f,
    0x0, 0x0, 0xbb33, 0x3260, 0x0, 0x0, 0xbb33, 0x3230,
    0x0, 0x0, 0xbb33, 0x3201, 0x0, 0x0, 0xbb33, 0x31d2,
    0x0, 0x0, 0xbb33, 0x31a3, 0x0, 0x0, 0xbb33, 0x3174,
    0x0, 0x0, 0xbb33, 0x3145, 0x0, 0x0, 0xbb33, 0x3117,
    0x0, 0x0, 0xbb33, 0x30e8, 0x0, 0x0, 0xbb33, 0x30ba,
    0x0, 0x0, 0xbb33, 0x308b, 0x0, 0x0, 0xbb33, 0x305d,
    0x0, 0x0, 0xbb33, 0x302f, 0x0, 0x0, 0xbb33, 0x3000,
    0x0, 0x0, 0xbb33, 0x2fa5, 0x0, 0x0, 0xbb33, 0x2f49,
    0x0, 0x0, 0xbb33, 0x2eed, 0x0, 0x0, 0xbb33, 0x2e91,
    0x0, 0x0, 0xbb33, 0x2e35, 0x0, 0x0, 0xbb33, 0x2dda,
    0x0, 0x0, 0xbb33, 0x2d7f, 0x0, 0x0, 0xbb33, 0x2d23,
    0x0, 0x0, 0xbb33, 0x2cc8, 0x0, 0x0, 0xbb33, 0x2c6d,
    0x0, 0x0, 0xbb33, 0x2c12, 0x0, 0x0, 0xbb33, 0x2b6f,
    0x0, 0x0, 0xbb33, 0x2ab9, 0x0, 0x0, 0xbb33, 0x2a04,
    0x0, 0x0, 0xbb33, 0x294e, 0x0, 0x0, 0xbb33, 0x2899,
    0x0, 0x0, 0xbb33, 0x27c7, 0x0, 0x0, 0xbb33, 0x265d,
    0x0, 0x0, 0xbb33, 0x24f3, 0x0, 0x0, 0xbb33, 0x2312,
    0x0, 0x0, 0xbb33, 0x203e, 0x0, 0x0, 0xbb33, 0x19a8,
    0x0, 0x0, 0xbb33, 0x99a8, 0x0, 0x0, 0xbb33, 0xa03e,
    0x0, 0x0, 0xbb33, 0xa312, 0x0, 0x0, 0xbb33, 0xa4f3,
    0x0, 0x0, 0xbb33, 0xa65d, 0x0, 0x0, 0xbb33, 0xa7c7,
    0x0, 0x0, 0xbb33, 0xa899, 0x0, 0x0, 0xbb33, 0xa94e,
    0x0, 0x0, 0xbb33, 0xaa04, 0x0, 0x0, 0xbb33, 0xaab9,
    0x0, 0x0, 0xbb33, 0xab6f, 0x0, 0x0, 0xbb33, 0xac12,
    0x0, 0x0, 0xbb33, 0xac6d, 0x0, 0x0, 0xbb33, 0xacc8,
    0x0, 0x0, 0xbb33, 0xad23, 0x0, 0x0, 0xbb33, 0xad7f,
    0x0, 0x0, 0xbb33, 0xadda, 0x0, 0x0, 0xbb33, 0xae35,
    0x0, 0x0, 0xbb33, 0xae91, 0x0, 0x0, 0xbb33, 0xaeed,
    0x0, 0x0, 0xbb33, 0xaf49, 0x0, 0x0, 0xbb33, 0xafa5,
    0x0, 0x0, 0xbb33, 0xb000, 0x0, 0x0, 0xbb33, 0xb02f,
    0x0, 0x0, 0xbb33, 0xb05d, 0x0, 0x0, 0xbb33, 0xb08b,
    0x0, 0x0, 0xbb33, 0xb0ba, 0x0, 0x0, 0xbb33, 0xb0e8,
    0x0, 0x0, 0xbb33, 0xb117, 0x0, 0x0, 0xbb33, 0xb145,
    0x0, 0x0, 0xbb33, 0xb174, 0x0, 0x0, 0xbb33, 0xb1a3,
    0x0, 0x0, 0xbb33, 0xb1d2, 0x0, 0x0, 0xbb33, 0xb201,
    0x0, 0x0, 0xbb33, 0xb230, 0x0, 0x0, 0xbb33, 0xb260,
    0x0, 0x0, 0xbb33, 0xb28f, 0x0, 0x0, 0xbb33, 0xb2bf,
    0x0, 0x0, 0xbb33, 0xb2ef, 0x0, 0x0, 0xbb33, 0xb31f,
    0x0, 0x0, 0xbb33, 0xb34f, 0x0, 0x0, 0xbb33, 0xb37f,
    0x0, 0x0, 0xbb33, 0xb3af, 0x0, 0x0, 0xbb33, 0xb3e0,
    0x0, 0x0, 0xbb33, 0xb408, 0x0, 0x0, 0xbb33, 0xb421,
    0x0, 0x0, 0xbb33, 0xb439, 0x0, 0x0, 0xbb33, 0xb452,
    0x0, 0x0, 0xbb33, 0xb46b, 0x0, 0x0, 0xbb33, 0xb483,
    0x0, 0x0, 0xbb33, 0xb49c, 0x0, 0x0, 0xbb33, 0xb4b5,
    0x0, 0x0, 0xbb33, 0xb4ce, 0x0, 0x0, 0xbb33, 0xb4e8,
    0x0, 0x0, 0xbb33, 0xb501, 0x0, 0x0, 0xbb33, 0xb51a,
    0x0, 0x0, 0xbb33, 0xb534, 0x0, 0x0, 0xbb33, 0xb54d,
    0x0, 0x0, 0xbb33, 0xb567, 0x0, 0x0, 0xbb33, 0xb581,
    0x0, 0x0, 0xbb33, 0xb59b, 0x0, 0x0, 0xbb33, 0xb5b5,
    0x0, 0x0, 0xbb33, 0xb5cf, 0x0, 0x0, 0xbb33, 0xb5ea,
    0x0, 0x0, 0xbb33, 0xb604, 0x0, 0x0, 0xbb33, 0xb61f,
    0x0, 0x0, 0xbb33, 0xb63a, 0x0, 0x0, 0xbb33, 0xb655,
    0x0, 0x0, 0xbb33, 0xb670, 0x0, 0x0, 0xbb33, 0xb68b,
    0x0, 0x0, 0xbb33, 0xb6a6, 0x0, 0x0, 0xbb33, 0xb6c2,
    0x0, 0x0, 0xbb33, 0xb6dd, 0x0, 0x0, 0xbb33, 0xb6f9,
    0x0, 0x0, 0xbb33, 0xb715, 0x0, 0x0, 0xbb33, 0xb731,
    0x0, 0x0, 0xbb33, 0xb74e, 0x0, 0x0, 0xbb33, 0xb76a,
    0x0, 0x0, 0xbb33, 0xb787, 0x0, 0x0, 0xbb33, 0xb7a4,
    0x0, 0x0, 0xbb33, 0xb7c1, 0x0, 0x0, 0xbb33, 0xb7de,
    0x0, 0x0, 0xbb33, 0xb7fc, 0x0, 0x0, 0xbb33, 0xb80d,
    0x0, 0x0, 0xbb33, 0xb81c, 0x0, 0x0, 0xbb33, 0xb82b,
    0x0, 0x0, 0xbb33, 0xb83a, 0x0, 0x0, 0xbb33, 0xb849,
    0x0, 0x0, 0xbb33, 0xb858, 0x0, 0x0, 0xbb33, 0xb868,
    0x0, 0x0, 0xbb33, 0xb878, 0x0, 0x0, 0xbb33, 0xb887,
    0x0, 0x0, 0xbb33, 0xb897, 0x0, 0x0, 0xbb33, 0xb8a7,
    0x0, 0x0, 0xbb33, 0xb8b7, 0x0, 0x0, 0xbb33, 0xb8c7,
    0x0, 0x0, 0xbb33, 0xb8d8, 0x0, 0x0, 0xbb33, 0xb8e8,
    0x0, 0x0, 0xbb33, 0xb8f9, 0x0, 0x0, 0xbb33, 0xb90a,
    0x0, 0x0, 0xbb33, 0xb91b, 0x0, 0x0, 0xbb33, 0xb92c,
    0x0, 0x0, 0xbb33, 0xb93d, 0x0, 0x0, 0xbb33, 0xb94e,
    0x0, 0x0, 0xbb33, 0xb960, 0x0, 0x0, 0xbb33, 0xb971,
    0x0, 0x0, 0xbb33, 0xb983, 0x0, 0x0, 0xbb33, 0xb995,
    0x0, 0x0, 0xbb33, 0xb9a8, 0x0, 0x0, 0xbb33, 0xb9ba,
    0x0, 0x0, 0xbb33, 0xb9cc, 0x0, 0x0, 0xbb33, 0xb9df,
    0x0, 0x0, 0xbb33, 0xb9f2, 0x0, 0x0, 0xbb33, 0xba05,
    0x0, 0x0, 0xbb33, 0xba19, 0x0, 0x0, 0xbb33, 0xba2c,
    0x0, 0x0, 0xbb33, 0xba40, 0x0, 0x0, 0xbb33, 0xba54,
    0x0, 0x0, 0xbb33, 0xba68, 0x0, 0x0, 0xbb33, 0xba7c,
    0x0, 0x0, 0xbb33, 0xba91, 0x0, 0x0, 0xbb33, 0xbaa6,
    0x0, 0x0, 0xbb33, 0xbabb, 0x0, 0x0, 0xbb33, 0xbad0,
    0x0, 0x0, 0xbb33, 0xbae6, 0x0, 0x0, 0xbb33, 0xbafc,
    0x0, 0x0, 0xbb33, 0xbb12, 0x0, 0x0, 0xbb33, 0xbb28,
    0x0, 0x0, 0xbb33, 0xbb3f, 0x0, 0x0, 0xbb33, 0xbb55,
    0x0, 0x0, 0xbb33, 0xbb6d, 0x0, 0x0, 0xbb33, 0xbb84,
    0x0, 0x0, 0xbb33, 0xbb9c, 0x0, 0x0, 0xbb33, 0xbbb4,
    0x0, 0x0, 0xbb33, 0xbbcc, 0x0, 0x0, 0xbb33, 0xbbe5,
    0x0, 0x0, 0xbb33, 0xbbfe, 0x0, 0x0, 0xbb33, 0xbc0c,
    0x0, 0x0, 0xbb33, 0xbc19, 0x0, 0x0, 0xbb33, 0xbc26,
    0x0, 0x0, 0xbb33, 0xbc33, 0x0, 0x0, 0xbb33, 0xbc40,
    0x0, 0x0, 0xbb33, 0xbc4e, 0x0, 0x0, 0xbb33, 0xbc5c,
    0x0, 0x0, 0xbb33, 0xbc6a, 0x0, 0x0, 0xbb33, 0xbc78,
    0x0, 0x0, 0xbb33, 0xbc87, 0x0, 0x0, 0xbb33, 0xbc95,
    0x0, 0x0, 0xbb33, 0xbca4, 0x0, 0x0, 0xbb33, 0xbcb4,
    0x0, 0x0, 0xbb33, 0xbcc3, 0x0, 0x0, 0xbb33, 0xbcd3,
    0x0, 0x0, 0xbb33, 0xbce3, 0x0, 0x0, 0xbb33, 0xbcf3,
    0x0, 0x0, 0xbb33, 0xbd03, 0x0, 0x0, 0xbb33, 0xbd14,
    0x0, 0x0, 0xbb33, 0xbd25, 0x0, 0x0, 0xbb33, 0xbd36,
    0x0, 0x0, 0xbb33, 0xbd48, 0x0, 0x0, 0xbb33, 0xbd5a,
    0x0, 0x0, 0xbb33, 0xbd6c, 0x0, 0x0, 0xbb33, 0xbd7f,
    0x0, 0x0, 0xbb33, 0xbd92, 0x0, 0x0, 0xbb33, 0xbda6,
    0x0, 0x0, 0xbb33, 0xbdb9, 0x0, 0x0, 0xbb33, 0xbdcd,
    0x0, 0x0, 0xbb33, 0xbde2, 0x0, 0x0, 0xbb33, 0xbdf7,
    0x0, 0x0, 0xbb33, 0xbe0c, 0x0, 0x0, 0xbb33, 0xbe22,
    0x0, 0x0, 0xbb33, 0xbe38, 0x0, 0x0, 0xbb33, 0xbe4f,
    0x0, 0x0, 0xbb33, 0xbe67, 0x0, 0x0, 0xbb33, 0xbe7e,
    0x0, 0x0, 0xbb33, 0xbe97, 0x0, 0x0, 0xbb33, 0xbeb0,
    0x0, 0x0, 0xbb33, 0xbec9, 0x0, 0x0, 0xbb33, 0xbee3,
    0x0, 0x0, 0xbb33, 0xbefe, 0x0, 0x0, 0xbb33, 0xbf19,
    0x0, 0x0, 0xbb33, 0xbf35, 0x0, 0x0, 0xbb33, 0xbf52,
    0x0, 0x0, 0xbb33, 0xbf6f, 0x0, 0x0, 0xbb33, 0xbf8d,
    0x0, 0x0, 0xbb33, 0xbfac, 0x0, 0x0, 0xbb33, 0xbfcc,
    0x0, 0x0, 0xbb33, 0xbfec, 0x0, 0x0, 0xbb33, 0xc007,
    0x0, 0x0, 0xbb33, 0xc018, 0x0, 0x0, 0xbb33, 0xc02a,
    0x0, 0x0, 0xbb33, 0xc03c, 0x0, 0x0, 0xbb33, 0xc04f,
    0x0, 0x0, 0xbb33, 0xc062, 0x0, 0x0, 0xbb33, 0xc076,
    0x0, 0x0, 0xbb33, 0xc08b, 0x0, 0x0, 0xbb33, 0xc0a0,
    0x0, 0x0, 0xbb33, 0xc0b6, 0x0, 0x0, 0xbb33, 0xc0cc,
    0x0, 0x0, 0xbb33, 0xc0e3, 0x0, 0x0, 0xbb33, 0xc0fb,
    0x0, 0x0, 0xbb33, 0xc114, 0x0, 0x0, 0xbb33, 0xc12e,
    0x0, 0x0, 0xbb33, 0xc149, 0x0, 0x0, 0xbb33, 0xc165,
    0x0, 0x0, 0xbb33, 0xc181, 0x0, 0x0, 0xbb33, 0xc19f,
    0x0, 0x0, 0xbb33, 0xc1be, 0x0, 0x0, 0xbb33, 0xc1de,
    0x0, 0x0, 0xbb33, 0xc200, 0x0, 0x0, 0xbb33, 0xc223,
    0x0, 0x0, 0xbb33, 0xc247, 0x0, 0x0, 0xbb33, 0xc26d,
    0x0, 0x0, 0xbb33, 0xc295, 0x0, 0x0, 0xbb33, 0xc2bf,
    0x0, 0x0, 0xbb33, 0xc2ea, 0x0, 0x0, 0xbb33, 0xc318,
    0x0, 0x0, 0xbb33, 0xc348, 0x0, 0x0, 0xbb33, 0xc37a,
    0x0, 0x0, 0xbb33, 0xc3af, 0x0, 0x0, 0xbb33, 0xc3e7,
    0x0, 0x0, 0xbb33, 0xc411, 0x0, 0x0, 0xbb33, 0xc430,
    0x0, 0x0, 0xbb33, 0xc451, 0x0, 0x0, 0xbb33, 0xc474,
    0x0, 0x0, 0xbb33, 0xc499, 0x0, 0x0, 0xbb33, 0xc4c1,
    0x0, 0x0, 0xbb33, 0xc4eb, 0x0, 0x0, 0xbb33, 0xc518,
    0x0, 0x0, 0xbb33, 0xc548, 0x0, 0x0, 0xbb33, 0xc57c,
    0x0, 0x0, 0xbb33, 0xc5b4, 0x0, 0x0, 0xbb33, 0xc5f1,
    0x0, 0x0, 0xbb33, 0xc633, 0x0, 0x0, 0xbb33, 0xc67a,
    0x0, 0x0, 0xbb33, 0xc6c8, 0x0, 0x0, 0xbb33, 0xc71e,
    0x0, 0x0, 0xbb33, 0xc77c, 0x0, 0x0, 0xbb33, 0xc7e5,
    0x0, 0x0, 0xbb33, 0xc82d, 0x0, 0x0, 0xbb33, 0xc86e,
    0x0, 0x0, 0xbb33, 0xc8b8, 0x0, 0x0, 0xbb33, 0xc90b,
    0x0, 0x0, 0xbb33, 0xc96c, 0x0, 0x0, 0xbb33, 0xc9db,
    0x0, 0x0, 0xbb33, 0xca5e, 0x0, 0x0, 0xbb33, 0xcafa,
    0x0, 0x0, 0xbb33, 0xcbb6, 0x0, 0x0, 0xbb33, 0xcc4f,
    0x0, 0x0, 0xbb33, 0xcce3, 0x0, 0x0, 0xbb33, 0xcda3,
    0x0, 0x0, 0xbb33, 0xceaa, 0x0, 0x0, 0xbb33, 0xd013,
    0x0, 0x0, 0xbb33, 0xd13d, 0x0, 0x0, 0xbb33, 0xd355,
    0x0, 0x0, 0xbb33, 0xd61d, 0x0, 0x0, 0xbb33, 0xdc95
    };

static const uint16_t in_cfft_step_2048[4096] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0
    };

static const uint16_t in_cifft_step_2048[4096] = {
    0x6333, 0x0, 0xbb33, 0x6095, 0x0, 0x0, 0xbb33, 0x5a1d,
    0x0, 0x0, 0xbb33, 0x5755, 0x0, 0x0, 0xbb33, 0x553d,
    0x0, 0x0, 0xbb33, 0x5413, 0x0, 0x0, 0xbb33, 0x52ab,
    0x0, 0x0, 0xbb33, 0x51a4, 0x0, 0x0, 0xbb33, 0x50e3,
    0x0, 0x0, 0xbb33, 0x5050, 0x0, 0x0, 0xbb33, 0x4fb8,
    0x0, 0x0, 0xbb33, 0x4efb, 0x0, 0x0, 0xbb33, 0x4e60,
    0x0, 0x0, 0xbb33, 0x4ddd, 0x0, 0x0, 0xbb33, 0x4d6e,
    0x0, 0x0, 0xbb33, 0x4d0e, 0x0, 0x0, 0xbb33, 0x4cba,
    0x0, 0x0, 0xbb33, 0x4c71, 0x0, 0x0, 0xbb33, 0x4c30,
    0x0, 0x0, 0xbb33, 0x4bec, 0x0, 0x0, 0xbb33, 0x4b83,
    0x0, 0x0, 0xbb33, 0x4b25, 0x0, 0x0, 0xbb33, 0x4ad0,
    0x0, 0x0, 0xbb33, 0x4a82, 0x0, 0x0, 0xbb33, 0x4a3b,
    0x0, 0x0, 0xbb33, 0x49fa, 0x0, 0x0, 0xbb33, 0x49be,
    0x0, 0x0, 0xbb33, 0x4986, 0x0, 0x0, 0xbb33, 0x4952,
    0x0, 0x0, 0xbb33, 0x4922, 0x0, 0x0, 0xbb33, 0x48f5,
    0x0, 0x0, 0xbb33, 0x48cc, 0x0, 0x0, 0xbb33, 0x48a4,
    0x0, 0x0, 0xbb33, 0x4880, 0x0, 0x0, 0xbb33, 0x485d,
    0x0, 0x0, 0xbb33, 0x483c, 0x0, 0x0, 0xbb33, 0x481e,
    0x0, 0x0, 0xbb33, 0x4800, 0x0, 0x0, 0xbb33, 0x47ca,
    0x0, 0x0, 0xbb33, 0x4796, 0x0, 0x0, 0xbb33, 0x4764,
    0x0, 0x0, 0xbb33, 0x4735, 0x0, 0x0, 0xbb33, 0x4708,
    0x0, 0x0, 0xbb33, 0x46dd, 0x0, 0x0, 0xbb33, 0x46b4,
    0x0, 0x0, 0xbb33, 0x468d, 0x0, 0x0, 0xbb33, 0x4668,
    0x0, 0x0, 0xbb33, 0x4644, 0x0, 0x0, 0xbb33, 0x4622,
    0x0, 0x0, 0xbb33, 0x4601, 0x0, 0x0, 0xbb33, 0x45e1,
    0x0, 0x0, 0xbb33, 0x45c3, 0x0, 0x0, 0xbb33, 0x45a6,
    0x0, 0x0, 0xbb33, 0x458a, 0x0, 0x0, 0xbb33, 0x456f,
    0x0, 0x0, 0xbb33, 0x4555, 0x0, 0x0, 0xbb33, 0x453c,
    0x0, 0x0, 0xbb33, 0x4524, 0x0, 0x0, 0xbb33, 0x450c,
    0x0, 0x0, 0xbb33, 0x44f6, 0x0, 0x0, 0xbb33, 0x44e0,
    0x0, 0x0, 0xbb33, 0x44cb, 0x0, 0x0, 0xbb33, 0x44b7,
    0x0, 0x0, 0xbb33, 0x44a3, 0x0, 0x0, 0xbb33, 0x4490,
    0x0, 0x0, 0xbb33, 0x447d, 0x0, 0x0, 0xbb33, 0x446b,
    0x0, 0x0, 0xbb33, 0x445a, 0x0, 0x0, 0xbb33, 0x4449,
    0x0, 0x0, 0xbb33, 0x4438, 0x0, 0x0, 0xbb33, 0x4428,
    0x0, 0x0, 0xbb33, 0x4419, 0x0, 0x0, 0xbb33, 0x4409,
    0x0, 0x0, 0xbb33, 0x43f5, 0x0, 0x0, 0xbb33, 0x43d9,
    0x0, 0x0, 0xbb33, 0x43bd, 0x0, 0x0, 0xbb33, 0x43a2,
    0x0, 0x0, 0xbb33, 0x4387, 0x0, 0x0, 0xbb33, 0x436d,
    0x0, 0x0, 0xbb33, 0x4354, 0x0, 0x0, 0xbb33, 0x433c,
    0x0, 0x0, 0xbb33, 0x4324, 0x0, 0x0, 0xbb33, 0x430c,
    0x0, 0x0, 0xbb33, 0x42f6, 0x0, 0x0, 0xbb33, 0x42df,
    0x0, 0x0, 0xbb33, 0x42c9, 0x0, 0x0, 0xbb33, 0x42b4,
    0x0, 0x0, 0xbb33, 0x429f, 0x0, 0x0, 0xbb33, 0x428b,
    0x0, 0x0, 0xbb33, 0x4277, 0x0, 0x0, 0xbb33, 0x4264,
    0x0, 0x0, 0xbb33, 0x4251, 0x0, 0x0, 0xbb33, 0x423e,
    0x0, 0x0, 0xbb33, 0x422c, 0x0, 0x0, 0xbb33, 0x421a,
    0x0, 0x0, 0xbb33, 0x4209, 0x0, 0x0, 0xbb33, 0x41f7,
    0x0, 0x0, 0xbb33, 0x41e7, 0x0, 0x0, 0xbb33, 0x41d6,
    0x0, 0x0, 0xbb33, 0x41c6, 0x0, 0x0, 0xbb33, 0x41b6,
    0x0, 0x0, 0xbb33, 0x41a7, 0x0, 0x0, 0xbb33, 0x4198,
    0x0, 0x0, 0xbb33, 0x4189, 0x0, 0x0, 0xbb33, 0x417a,
    0x0, 0x0, 0xbb33, 0x416c, 0x0, 0x0, 0xbb33, 0x415e,
    0x0, 0x0, 0xbb33, 0x4150, 0x0, 0x0, 0xbb33, 0x4142,
    0x0, 0x0, 0xbb33, 0x4135, 0x0, 0x0, 0xbb33, 0x4128,
    0x0, 0x0, 0xbb33, 0x411b, 0x0, 0x0, 0xbb33, 0x410e,
    0x0, 0x0, 0xbb33, 0x4102, 0x0, 0x0, 0xbb33, 0x40f5,
    0x0, 0x0, 0xbb33, 0x40e9, 0x0, 0x0, 0xbb33, 0x40de,
    0x0, 0x0, 0xbb33, 0x40d2, 0x0, 0x0, 0xbb33, 0x40c6,
    0x0, 0x0, 0xbb33, 0x40bb, 0x0, 0x0, 0xbb33, 0x40b0,
    0x0, 0x0, 0xbb33, 0x40a5, 0x0, 0x0, 0xbb33, 0x409a,
    0x0, 0x0, 0xbb33, 0x4090, 0x0, 0x0, 0xbb33, 0x4085,
    0x0, 0x0, 0xbb33, 0x407b, 0x0, 0x0, 0xbb33, 0x4071,
    0x0, 0x0, 0xbb33, 0x4067, 0x0, 0x0, 0xbb33, 0x405d,
    0x0, 0x0, 0xbb33, 0x4054, 0x0, 0x0, 0xbb33, 0x404a,
    0x0, 0x0, 0xbb33, 0x4041, 0x0, 0x0, 0xbb33, 0x4038,
    0x0, 0x0, 0xbb33, 0x402e, 0x0, 0x0, 0xbb33, 0x4025,
    0x0, 0x0, 0xbb33, 0x401d, 0x0, 0x0, 0xbb33, 0x4014,
    0x0, 0x0, 0xbb33, 0x400b, 0x0, 0x0, 0xbb33, 0x4003,
    0x0, 0x0, 0xbb33, 0x3ff5, 0x0, 0x0, 0xbb33, 0x3fe4,
    0x0, 0x0, 0xbb33, 0x3fd4, 0x0, 0x0, 0xbb33, 0x3fc4,
    0x0, 0x0, 0xbb33, 0x3fb4, 0x0, 0x0, 0xbb33, 0x3fa4,
    0x0, 0x0, 0xbb33, 0x3f95, 0x0, 0x0, 0xbb33, 0x3f86,
    0x0, 0x0, 0xbb33, 0x3f77, 0x0, 0x0, 0xbb33, 0x3f68,
    0x0, 0x0, 0xbb33, 0x3f59, 0x0, 0x0, 0xbb33, 0x3f4a,
    0x0, 0x0, 0xbb33, 0x3f3c, 0x0, 0x0, 0xbb33, 0x3f2e,
    0x0, 0x0, 0xbb33, 0x3f20, 0x0, 0x0, 0xbb33, 0x3f12,
    0x0, 0x0, 0xbb33, 0x3f04, 0x0, 0x0, 0xbb33, 0x3ef7,
    0x0, 0x0, 0xbb33, 0x3eea, 0x0, 0x0, 0xbb33, 0x3edc,
    0x0, 0x0, 0xbb33, 0x3ecf, 0x0, 0x0, 0xbb33, 0x3ec3,
    0x0, 0x0, 0xbb33, 0x3eb6, 0x0, 0x0, 0xbb33, 0x3ea9,
    0x0, 0x0, 0xbb33, 0x3e9d, 0x0, 0x0, 0xbb33, 0x3e91,
    0x0, 0x0, 0xbb33, 0x3e84, 0x0, 0x0, 0xbb33, 0x3e78,
    0x0, 0x0, 0xbb33, 0x3e6c, 0x0, 0x0, 0xbb33, 0x3e61,
    0x0, 0x0, 0xbb33, 0x3e55, 0x0, 0x0, 0xbb33, 0x3e4a,
    0x0, 0x0, 0xbb33, 0x3e3e, 0x0, 0x0, 0xbb33, 0x3e33,
    0x0, 0x0, 0xbb33, 0x3e28, 0x0, 0x0, 0xbb33, 0x3e1d,
    0x0, 0x0, 0xbb33, 0x3e12, 0x0, 0x0, 0xbb33, 0x3e07,
    0x0, 0x0, 0xbb33, 0x3dfc, 0x0, 0x0, 0xbb33, 0x3df2,
    0x0, 0x0, 0xbb33, 0x3de7, 0x0, 0x0, 0xbb33, 0x3ddd,
    0x0, 0x0, 0xbb33, 0x3dd3, 0x0, 0x0, 0xbb33, 0x3dc8,
    0x0, 0x0, 0xbb33, 0x3dbe, 0x0, 0x0, 0xbb33, 0x3db4,
    0x0, 0x0, 0xbb33, 0x3daa, 0x0, 0x0, 0xbb33, 0x3da1,
    0x0, 0x0, 0xbb33, 0x3d97, 0x0, 0x0, 0xbb33, 0x3d8d,
    0x0, 0x0, 0xbb33, 0x3d84, 0x0, 0x0, 0xbb33, 0x3d7a,
    0x0, 0x0, 0xbb33, 0x3d71, 0x0, 0x0, 0xbb33, 0x3d68,
    0x0, 0x0, 0xbb33, 0x3d5f, 0x0, 0x0, 0xbb33, 0x3d56,
    0x0, 0x0, 0xbb33, 0x3d4d, 0x0, 0x0, 0xbb33, 0x3d44,
    0x0, 0x0, 0xbb33, 0x3d3b, 0x0, 0x0, 0xbb33, 0x3d32,
    0x0, 0x0, 0xbb33, 0x3d29, 0x0, 0x0, 0xbb33, 0x3d21,
    0x0, 0x0, 0xbb33, 0x3d18, 0x0, 0x0, 0xbb33, 0x3d10,
    0x0, 0x0, 0xbb33, 0x3d07, 0x0, 0x0, 0xbb33, 0x3cff,
    0x0, 0x0, 0xbb33, 0x3cf7, 0x0, 0x0, 0xbb33, 0x3cef,
    0x0, 0x0, 0xbb33, 0x3ce7, 0x0, 0x0, 0xbb33, 0x3cdf,
    0x0, 0x0, 0xbb33, 0x3cd7, 0x0, 0x0, 0xbb33, 0x3ccf,
    0x0, 0x0, 0xbb33, 0x3cc7, 0x0, 0x0, 0xbb33, 0x3cbf,
    0x0, 0x0, 0xbb33, 0x3cb7, 0x0, 0x0, 0xbb33, 0x3cb0,
    0x0, 0x0, 0xbb33, 0x3ca8, 0x0, 0x0, 0xbb33, 0x3ca1,
    0x0, 0x0, 0xbb33, 0x3c99, 0x0, 0x0, 0xbb33, 0x3c92,
    0x0, 0x0, 0xbb33, 0x3c8a, 0x0, 0x0, 0xbb33, 0x3c83,
    0x0, 0x0, 0xbb33, 0x3c7c, 0x0, 0x0, 0xbb33, 0x3c75,
    0x0, 0x0, 0xbb33, 0x3c6e, 0x0, 0x0, 0xbb33, 0x3c66,
    0x0, 0x0, 0xbb33, 0x3c5f, 0x0, 0x0, 0xbb33, 0x3c58,
    0x0, 0x0, 0xbb33, 0x3c52, 0x0, 0x0, 0xbb33, 0x3c4b,
    0x0, 0x0, 0xbb33, 0x3c44, 0x0, 0x0, 0xbb33, 0x3c3d,
    0x0, 0x0, 0xbb33, 0x3c36, 0x0, 0x0, 0xbb33, 0x3c30,
    0x0, 0x0, 0xbb33, 0x3c29, 0x0, 0x0, 0xbb33, 0x3c23,
    0x0, 0x0, 0xbb33, 0x3c1c, 0x0, 0x0, 0xbb33, 0x3c15,
    0x0, 0x0, 0xbb33, 0x3c0f, 0x0, 0x0, 0xbb33, 0x3c09,
    0x0, 0x0, 0xbb33, 0x3c02, 0x0, 0x0, 0xbb33, 0x3bf8,
    0x0, 0x0, 0xbb33, 0x3beb, 0x0, 0x0, 0xbb33, 0x3bdf,
    0x0, 0x0, 0xbb33, 0x3bd3, 0x0, 0x0, 0xbb33, 0x3bc6,
    0x0, 0x0, 0xbb33, 0x3bba, 0x0, 0x0, 0xbb33, 0x3bae,
    0x0, 0x0, 0xbb33, 0x3ba2, 0x0, 0x0, 0xbb33, 0x3b96,
    0x0, 0x0, 0xbb33, 0x3b8a, 0x0, 0x0, 0xbb33, 0x3b7e,
    0x0, 0x0, 0xbb33, 0x3b72, 0x0, 0x0, 0xbb33, 0x3b67,
    0x0, 0x0, 0xbb33, 0x3b5b, 0x0, 0x0, 0xbb33, 0x3b50,
    0x0, 0x0, 0xbb33, 0x3b44, 0x0, 0x0, 0xbb33, 0x3b39,
    0x0, 0x0, 0xbb33, 0x3b2e, 0x0, 0x0, 0xbb33, 0x3b22,
    0x0, 0x0, 0xbb33, 0x3b17, 0x0, 0x0, 0xbb33, 0x3b0c,
    0x0, 0x0, 0xbb33, 0x3b01, 0x0, 0x0, 0xbb33, 0x3af6,
    0x0, 0x0, 0xbb33, 0x3aeb, 0x0, 0x0, 0xbb33, 0x3ae0,
    0x0, 0x0, 0xbb33, 0x3ad5, 0x0, 0x0, 0xbb33, 0x3acb,
    0x0, 0x0, 0xbb33, 0x3ac0, 0x0, 0x0, 0xbb33, 0x3ab6,
    0x0, 0x0, 0xbb33, 0x3aab, 0x0, 0x0, 0xbb33, 0x3aa1,
    0x0, 0x0, 0xbb33, 0x3a96, 0x0, 0x0, 0xbb33, 0x3a8c,
    0x0, 0x0, 0xbb33, 0x3a81, 0x0, 0x0, 0xbb33, 0x3a77,
    0x0, 0x0, 0xbb33, 0x3a6d, 0x0, 0x0, 0xbb33, 0x3a63,
    0x0, 0x0, 0xbb33, 0x3a59, 0x0, 0x0, 0xbb33, 0x3a4f,
    0x0, 0x0, 0xbb33, 0x3a45, 0x0, 0x0, 0xbb33, 0x3a3b,
    0x0, 0x0, 0xbb33, 0x3a31, 0x0, 0x0, 0xbb33, 0x3a27,
    0x0, 0x0, 0xbb33, 0x3a1d, 0x0, 0x0, 0xbb33, 0x3a14,
    0x0, 0x0, 0xbb33, 0x3a0a, 0x0, 0x0, 0xbb33, 0x3a00,
    0x0, 0x0, 0xbb33, 0x39f7, 0x0, 0x0, 0xbb33, 0x39ed,
    0x0, 0x0, 0xbb33, 0x39e4, 0x0, 0x0, 0xbb33, 0x39db,
    0x0, 0x0, 0xbb33, 0x39d1, 0x0, 0x0, 0xbb33, 0x39c8,
    0x0, 0x0, 0xbb33, 0x39bf, 0x0, 0x0, 0xbb33, 0x39b5,
    0x0, 0x0, 0xbb33, 0x39ac, 0x0, 0x0, 0xbb33, 0x39a3,
    0x0, 0x0, 0xbb33, 0x399a, 0x0, 0x0, 0xbb33, 0x3991,
    0x0, 0x0, 0xbb33, 0x3988, 0x0, 0x0, 0xbb33, 0x397f,
    0x0, 0x0, 0xbb33, 0x3976, 0x0, 0x0, 0xbb33, 0x396d,
    0x0, 0x0, 0xbb33, 0x3964, 0x0, 0x0, 0xbb33, 0x395b,
    0x0, 0x0, 0xbb33, 0x3953, 0x0, 0x0, 0xbb33, 0x394a,
    0x0, 0x0, 0xbb33, 0x3941, 0x0, 0x0, 0xbb33, 0x3939,
    0x0, 0x0, 0xbb33, 0x3930, 0x0, 0x0, 0xbb33, 0x3927,
    0x0, 0x0, 0xbb33, 0x391f, 0x0, 0x0, 0xbb33, 0x3916,
    0x0, 0x0, 0xbb33, 0x390e, 0x0, 0x0, 0xbb33, 0x3905,
    0x0, 0x0, 0xbb33, 0x38fd, 0x0, 0x0, 0xbb33, 0x38f5,
    0x0, 0x0, 0xbb33, 0x38ec, 0x0, 0x0, 0xbb33, 0x38e4,
    0x0, 0x0, 0xbb33, 0x38dc, 0x0, 0x0, 0xbb33, 0x38d4,
    0x0, 0x0, 0xbb33, 0x38cc, 0x0, 0x0, 0xbb33, 0x38c3,
    0x0, 0x0, 0xbb33, 0x38bb, 0x0, 0x0, 0xbb33, 0x38b3,
    0x0, 0x0, 0xbb33, 0x38ab, 0x0, 0x0, 0xbb33, 0x38a3,
    0x0, 0x0, 0xbb33, 0x389b, 0x0, 0x0, 0xbb33, 0x3893,
    0x0, 0x0, 0xbb33, 0x388b, 0x0, 0x0, 0xbb33, 0x3883,
    0x0, 0x0, 0xbb33, 0x387b, 0x0, 0x0, 0xbb33, 0x3874,
    0x0, 0x0, 0xbb33, 0x386c, 0x0, 0x0, 0xbb33, 0x3864,
    0x0, 0x0, 0xbb33, 0x385c, 0x0, 0x0, 0xbb33, 0x3855,
    0x0, 0x0, 0xbb33, 0x384d, 0x0, 0x0, 0xbb33, 0x3845,
    0x0, 0x0, 0xbb33, 0x383e, 0x0, 0x0, 0xbb33, 0x3836,
    0x0, 0x0, 0xbb33, 0x382e, 0x0, 0x0, 0xbb33, 0x3827,
    0x0, 0x0, 0xbb33, 0x381f, 0x0, 0x0, 0xbb33, 0x3818,
    0x0, 0x0, 0xbb33, 0x3810, 0x0, 0x0, 0xbb33, 0x3809,
    0x0, 0x0, 0xbb33, 0x3802, 0x0, 0x0, 0xbb33, 0x37f4,
    0x0, 0x0, 0xbb33, 0x37e6, 0x0, 0x0, 0xbb33, 0x37d7,
    0x0, 0x0, 0xbb33, 0x37c8, 0x0, 0x0, 0xbb33, 0x37ba,
    0x0, 0x0, 0xbb33, 0x37ab, 0x0, 0x0, 0xbb33, 0x379d,
    0x0, 0x0, 0xbb33, 0x378e, 0x0, 0x0, 0xbb33, 0x3780,
    0x0, 0x0, 0xbb33, 0x3771, 0x0, 0x0, 0xbb33, 0x3763,
    0x0, 0x0, 0xbb33, 0x3755, 0x0, 0x0, 0xbb33, 0x3747,
    0x0, 0x0, 0xbb33, 0x3738, 0x0, 0x0, 0xbb33, 0x372a,
    0x0, 0x0, 0xbb33, 0x371c, 0x0, 0x0, 0xbb33, 0x370e,
    0x0, 0x0, 0xbb33, 0x3700, 0x0, 0x0, 0xbb33, 0x36f2,
    0x0, 0x0, 0xbb33, 0x36e4, 0x0, 0x0, 0xbb33, 0x36d6,
    0x0, 0x0, 0xbb33, 0x36c9, 0x0, 0x0, 0xbb33, 0x36bb,
    0x0, 0x0, 0xbb33, 0x36ad, 0x0, 0x0, 0xbb33, 0x369f,
    0x0, 0x0, 0xbb33, 0x3692, 0x0, 0x0, 0xbb33, 0x3684,
    0x0, 0x0, 0xbb33, 0x3676, 0x0, 0x0, 0xbb33, 0x3669,
    0x0, 0x0, 0xbb33, 0x365b, 0x0, 0x0, 0xbb33, 0x364e,
    0x0, 0x0, 0xbb33, 0x3640, 0x0, 0x0, 0xbb33, 0x3633,
    0x0, 0x0, 0xbb33, 0x3626, 0x0, 0x0, 0xbb33, 0x3618,
    0x0, 0x0, 0xbb33, 0x360b, 0x0, 0x0, 0xbb33, 0x35fe,
    0x0, 0x0, 0xbb33, 0x35f0, 0x0, 0x0, 0xbb33, 0x35e3,
    0x0, 0x0, 0xbb33, 0x35d6, 0x0, 0x0, 0xbb33, 0x35c9,
    0x0, 0x0, 0xbb33, 0x35bc, 0x0, 0x0, 0xbb33, 0x35af,
    0x0, 0x0, 0xbb33, 0x35a2, 0x0, 0x0, 0xbb33, 0x3595,
    0x0, 0x0, 0xbb33, 0x3588, 0x0, 0x0, 0xbb33, 0x357b,
    0x0, 0x0, 0xbb33, 0x356e, 0x0, 0x0, 0xbb33, 0x3561,
    0x0, 0x0, 0xbb33, 0x3554, 0x0, 0x0, 0xbb33, 0x3547,
    0x0, 0x0, 0xbb33, 0x353a, 0x0, 0x0, 0xbb33, 0x352d,
    0x0, 0x0, 0xbb33, 0x3521, 0x0, 0x0, 0xbb33, 0x3514,
    0x0, 0x0, 0xbb33, 0x3507, 0x0, 0x0, 0xbb33, 0x34fb,
    0x0, 0x0, 0xbb33, 0x34ee, 0x0, 0x0, 0xbb33, 0x34e1,
    0x0, 0x0, 0xbb33, 0x34d5, 0x0, 0x0, 0xbb33, 0x34c8,
    0x0, 0x0, 0xbb33, 0x34bc, 0x0, 0x0, 0xbb33, 0x34af,
    0x0, 0x0, 0xbb33, 0x34a3, 0x0, 0x0, 0xbb33, 0x3496,
    0x0, 0x0, 0xbb33, 0x348a, 0x0, 0x0, 0xbb33, 0x347d,
    0x0, 0x0, 0xbb33, 0x3471, 0x0, 0x0, 0xbb33, 0x3464,
    0x0, 0x0, 0xbb33, 0x3458, 0x0, 0x0, 0xbb33, 0x344c,
    0x0, 0x0, 0xbb33, 0x343f, 0x0, 0x0, 0xbb33, 0x3433,
    0x0, 0x0, 0xbb33, 0x3427, 0x0, 0x0, 0xbb33, 0x341b,
    0x0, 0x0, 0xbb33, 0x340e, 0x0, 0x0, 0xbb33, 0x3402,
    0x0, 0x0, 0xbb33, 0x33ec, 0x0, 0x0, 0xbb33, 0x33d4,
    0x0, 0x0, 0xbb33, 0x33bc, 0x0, 0x0, 0xbb33, 0x33a3,
    0x0, 0x0, 0xbb33, 0x338b, 0x0, 0x0, 0xbb33, 0x3373,
    0x0, 0x0, 0xbb33, 0x335b, 0x0, 0x0, 0xbb33, 0x3343,
    0x0, 0x0, 0xbb33, 0x332b, 0x0, 0x0, 0xbb33, 0x3313,
    0x0, 0x0, 0xbb33, 0x32fb, 0x0, 0x0, 0xbb33, 0x32e3,
    0x0, 0x0, 0xbb33, 0x32cb, 0x0, 0x0, 0xbb33, 0x32b3,
    0x0, 0x0, 0xbb33, 0x329b, 0x0, 0x0, 0xbb33, 0x3284,
    0x0, 0x0, 0xbb33, 0x326c, 0x0, 0x0, 0xbb33, 0x3254,
    0x0, 0x0, 0xbb33, 0x323c, 0x0, 0x0, 0xbb33, 0x3225,
    0x0, 0x0, 0xbb33, 0x320d, 0x0, 0x0, 0xbb33, 0x31f5,
    0x0, 0x0, 0xbb33, 0x31de, 0x0, 0x0, 0xbb33, 0x31c6,
    0x0, 0x0, 0xbb33, 0x31af, 0x0, 0x0, 0xbb33, 0x3197,
    0x0, 0x0, 0xbb33, 0x3180, 0x0, 0x0, 0xbb33, 0x3168,
    0x0, 0x0, 0xbb33, 0x3151, 0x0, 0x0, 0xbb33, 0x313a,
    0x0, 0x0, 0xbb33, 0x3122, 0x0, 0x0, 0xbb33, 0x310b,
    0x0, 0x0, 0xbb33, 0x30f4, 0x0, 0x0, 0xbb33, 0x30dc,
    0x0, 0x0, 0xbb33, 0x30c5, 0x0, 0x0, 0xbb33, 0x30ae,
    0x0, 0x0, 0xbb33, 0x3097, 0x0, 0x0, 0xbb33, 0x3080,
    0x0, 0x0, 0xbb33, 0x3068, 0x0, 0x0, 0xbb33, 0x3051,
    0x0, 0x0, 0xbb33, 0x303a, 0x0, 0x0, 0xbb33, 0x3023,
    0x0, 0x0, 0xbb33, 0x300c, 0x0, 0x0, 0xbb33, 0x2fea,
    0x0, 0x0, 0xbb33, 0x2fbc, 0x0, 0x0, 0xbb33, 0x2f8e,
    0x0, 0x0, 0xbb33, 0x2f60, 0x0, 0x0, 0xbb33, 0x2f32,
    0x0, 0x0, 0xbb33, 0x2f04, 0x0, 0x0, 0xbb33, 0x2ed6,
    0x0, 0x0, 0xbb33, 0x2ea8, 0x0, 0x0, 0xbb33, 0x2e7a,
    0x0, 0x0, 0xbb33, 0x2e4c, 0x0, 0x0, 0xbb33, 0x2e1f,
    0x0, 0x0, 0xbb33, 0x2df1, 0x0, 0x0, 0xbb33, 0x2dc3,
    0x0, 0x0, 0xbb33, 0x2d95, 0x0, 0x0, 0xbb33, 0x2d68,
    0x0, 0x0, 0xbb33, 0x2d3a, 0x0, 0x0, 0xbb33, 0x2d0d,
    0x0, 0x0, 0xbb33, 0x2cdf, 0x0, 0x0, 0xbb33, 0x2cb1,
    0x0, 0x0, 0xbb33, 0x2c84, 0x0, 0x0, 0xbb33, 0x2c56,
    0x0, 0x0, 0xbb33, 0x2c29, 0x0, 0x0, 0xbb33, 0x2bf7,
    0x0, 0x0, 0xbb33, 0x2b9c, 0x0, 0x0, 0xbb33, 0x2b41,
    0x0, 0x0, 0xbb33, 0x2ae6, 0x0, 0x0, 0xbb33, 0x2a8c,
    0x0, 0x0, 0xbb33, 0x2a31, 0x0, 0x0, 0xbb33, 0x29d6,
    0x0, 0x0, 0xbb33, 0x297b, 0x0, 0x0, 0xbb33, 0x2921,
    0x0, 0x0, 0xbb33, 0x28c6, 0x0, 0x0, 0xbb33, 0x286c,
    0x0, 0x0, 0xbb33, 0x2811, 0x0, 0x0, 0xbb33, 0x276d,
    0x0, 0x0, 0xbb33, 0x26b8, 0x0, 0x0, 0xbb33, 0x2602,
    0x0, 0x0, 0xbb33, 0x254d, 0x0, 0x0, 0xbb33, 0x2498,
    0x0, 0x0, 0xbb33, 0x23c7, 0x0, 0x0, 0xbb33, 0x225d,
    0x0, 0x0, 0xbb33, 0x20f3, 0x0, 0x0, 0xbb33, 0x1f12,
    0x0, 0x0, 0xbb33, 0x1c3e, 0x0, 0x0, 0xbb33, 0x15a8,
    0x0, 0x0, 0xbb33, 0x95a8, 0x0, 0x0, 0xbb33, 0x9c3e,
    0x0, 0x0, 0xbb33, 0x9f12, 0x0, 0x0, 0xbb33, 0xa0f3,
    0x0, 0x0, 0xbb33, 0xa25d, 0x0, 0x0, 0xbb33, 0xa3c7,
    0x0, 0x0, 0xbb33, 0xa498, 0x0, 0x0, 0xbb33, 0xa54d,
    0x0, 0x0, 0xbb33, 0xa602, 0x0, 0x0, 0xbb33, 0xa6b8,
    0x0, 0x0, 0xbb33, 0xa76d, 0x0, 0x0, 0xbb33, 0xa811,
    0x0, 0x0, 0xbb33, 0xa86c, 0x0, 0x0, 0xbb33, 0xa8c6,
    0x0, 0x0, 0xbb33, 0xa921, 0x0, 0x0, 0xbb33, 0xa97b,
    0x0, 0x0, 0xbb33, 0xa9d6, 0x0, 0x0, 0xbb33, 0xaa31,
    0x0, 0x0, 0xbb33, 0xaa8c, 0x0, 0x0, 0xbb33, 0xaae6,
    0x0, 0x0, 0xbb33, 0xab41, 0x0, 0x0, 0xbb33, 0xab9c,
    0x0, 0x0, 0xbb33, 0xabf7, 0x0, 0x0, 0xbb33, 0xac29,
    0x0, 0x0, 0xbb33, 0xac56, 0x0, 0x0, 0xbb33, 0xac84,
    0x0, 0x0, 0xbb33, 0xacb1, 0x0, 0x0, 0xbb33, 0xacdf,
    0x0, 0x0, 0xbb33, 0xad0d, 0x0, 0x0, 0xbb33, 0xad3a,
    0x0, 0x0, 0xbb33, 0xad68, 0x0, 0x0, 0xbb33, 0xad95,
    0x0, 0x0, 0xbb33, 0xadc3, 0x0, 0x0, 0xbb33, 0xadf1,
    0x0, 0x0, 0xbb33, 0xae1f, 0x0, 0x0, 0xbb33, 0xae4c,
    0x0, 0x0, 0xbb33, 0xae7a, 0x0, 0x0, 0xbb33, 0xaea8,
    0x0, 0x0, 0xbb33, 0xaed6, 0x0, 0x0, 0xbb33, 0xaf04,
    0x0, 0x0, 0xbb33, 0xaf32, 0x0, 0x0, 0xbb33, 0xaf60,
    0x0, 0x0, 0xbb33, 0xaf8e, 0x0, 0x0, 0xbb33, 0xafbc,
    0x0, 0x0, 0xbb33, 0xafea, 0x0, 0x0, 0xbb33, 0xb00c,
    0x0, 0x0, 0xbb33, 0xb023, 0x0, 0x0, 0xbb33, 0xb03a,
    0x0, 0x0, 0xbb33, 0xb051, 0x0, 0x0, 0xbb33, 0xb068,
    0x0, 0x0, 0xbb33, 0xb080, 0x0, 0x0, 0xbb33, 0xb097,
    0x0, 0x0, 0xbb33, 0xb0ae, 0x0, 0x0, 0xbb33, 0xb0c5,
    0x0, 0x0, 0xbb33, 0xb0dc, 0x0, 0x0, 0xbb33, 0xb0f4,
    0x0, 0x0, 0xbb33, 0xb10b, 0x0, 0x0, 0xbb33, 0xb122,
    0x0, 0x0, 0xbb33, 0xb13a, 0x0, 0x0, 0xbb33, 0xb151,
    0x0, 0x0, 0xbb33, 0xb168, 0x0, 0x0, 0xbb33, 0xb180,
    0x0, 0x0, 0xbb33, 0xb197, 0x0, 0x0, 0xbb33, 0xb1af,
    0x0, 0x0, 0xbb33, 0xb1c6, 0x0, 0x0, 0xbb33, 0xb1de,
    0x0, 0x0, 0xbb33, 0xb1f5, 0x0, 0x0, 0xbb33, 0xb20d,
    0x0, 0x0, 0xbb33, 0xb225, 0x0, 0x0, 0xbb33, 0xb23c,
    0x0, 0x0, 0xbb33, 0xb254, 0x0, 0x0, 0xbb33, 0xb26c,
    0x0, 0x0, 0xbb33, 0xb284, 0x0, 0x0, 0xbb33, 0xb29b,
    0x0, 0x0, 0xbb33, 0xb2b3, 0x0, 0x0, 0xbb33, 0xb2cb,
    0x0, 0x0, 0xbb33, 0xb2e3, 0x0, 0x0, 0xbb33, 0xb2fb,
    0x0, 0x0, 0xbb33, 0xb313, 0x0, 0x0, 0xbb33, 0xb32b,
    0x0, 0x0, 0xbb33, 0xb343, 0x0, 0x0, 0xbb33, 0xb35b,
    0x0, 0x0, 0xbb33, 0xb373, 0x0, 0x0, 0xbb33, 0xb38b,
    0x0, 0x0, 0xbb33, 0xb3a3, 0x0, 0x0, 0xbb33, 0xb3bc,
    0x0, 0x0, 0xbb33, 0xb3d4, 0x0, 0x0, 0xbb33, 0xb3ec,
    0x0, 0x0, 0xbb33, 0xb402, 0x0, 0x0, 0xbb33, 0xb40e,
    0x0, 0x0, 0xbb33, 0xb41b, 0x0, 0x0, 0xbb33, 0xb427,
    0x0, 0x0, 0xbb33, 0xb433, 0x0, 0x0, 0xbb33, 0xb43f,
    0x0, 0x0, 0xbb33, 0xb44c, 0x0, 0x0, 0xbb33, 0xb458,
    0x0, 0x0, 0xbb33, 0xb464, 0x0, 0x0, 0xbb33, 0xb471,
    0x0, 0x0, 0xbb33, 0xb47d, 0x0, 0x0, 0xbb33, 0xb48a,
    0x0, 0x0, 0xbb33, 0xb496, 0x0, 0x0, 0xbb33, 0xb4a3,
    0x0, 0x0, 0xbb33, 0xb4af, 0x0, 0x0, 0xbb33, 0xb4bc,
    0x0, 0x0, 0xbb33, 0xb4c8, 0x0, 0x0, 0xbb33, 0xb4d5,
    0x0, 0x0, 0xbb33, 0xb4e1, 0x0, 0x0, 0xbb33, 0xb4ee,
    0x0, 0x0, 0xbb33, 0xb4fb, 0x0, 0x0, 0xbb33, 0xb507,
    0x0, 0x0, 0xbb33, 0xb514, 0x0, 0x0, 0xbb33, 0xb521,
    0x0, 0x0, 0xbb33, 0xb52d, 0x0, 0x0, 0xbb33, 0xb53a,
    0x0, 0x0, 0xbb33, 0xb547, 0x0, 0x0, 0xbb33, 0xb554,
    0x0, 0x0, 0xbb33, 0xb561, 0x0, 0x0, 0xbb33, 0xb56e,
    0x0, 0x0, 0xbb33, 0xb57b, 0x0, 0x0, 0xbb33, 0xb588,
    0x0, 0x0, 0xbb33, 0xb595, 0x0, 0x0, 0xbb33, 0xb5a2,
    0x0, 0x0, 0xbb33, 0xb5af, 0x0, 0x0, 0xbb33, 0xb5bc,
    0x0, 0x0, 0xbb33, 0xb5c9, 0x0, 0x0, 0xbb33, 0xb5d6,
    0x0, 0x0, 0xbb33, 0xb5e3, 0x0, 0x0, 0xbb33, 0xb5f0,
    0x0, 0x0, 0xbb33, 0xb5fe, 0x0, 0x0, 0xbb33, 0xb60b,
    0x0, 0x0, 0xbb33, 0xb618, 0x0, 0x0, 0xbb33, 0xb626,
    0x0, 0x0, 0xbb33, 0xb633, 0x0, 0x0, 0xbb33, 0xb640,
    0x0, 0x0, 0xbb33, 0xb64e, 0x0, 0x0, 0xbb33, 0xb65b,
    0x0, 0x0, 0xbb33, 0xb669, 0x0, 0x0, 0xbb33, 0xb676,
    0x0, 0x0, 0xbb33, 0xb684, 0x0, 0x0, 0xbb33, 0xb692,
    0x0, 0x0, 0xbb33, 0xb69f, 0x0, 0x0, 0xbb33, 0xb6ad,
    0x0, 0x0, 0xbb33, 0xb6bb, 0x0, 0x0, 0xbb33, 0xb6c9,
    0x0, 0x0, 0xbb33, 0xb6d6, 0x0, 0x0, 0xbb33, 0xb6e4,
    0x0, 0x0, 0xbb33, 0xb6f2, 0x0, 0x0, 0xbb33, 0xb700,
    0x0, 0x0, 0xbb33, 0xb70e, 0x0, 0x0, 0xbb33, 0xb71c,
    0x0, 0x0, 0xbb33, 0xb72a, 0x0, 0x0, 0xbb33, 0xb738,
    0x0, 0x0, 0xbb33, 0xb747, 0x0, 0x0, 0xbb33, 0xb755,
    0x0, 0x0, 0xbb33, 0xb763, 0x0, 0x0, 0xbb33, 0xb771,
    0x0, 0x0, 0xbb33, 0xb780, 0x0, 0x0, 0xbb33, 0xb78e,
    0x0, 0x0, 0xbb33, 0xb79d, 0x0, 0x0, 0xbb33, 0xb7ab,
    0x0, 0x0, 0xbb33, 0xb7ba, 0x0, 0x0, 0xbb33, 0xb7c8,
    0x0, 0x0, 0xbb33, 0xb7d7, 0x0, 0x0, 0xbb33, 0xb7e6,
    0x0, 0x0, 0xbb33, 0xb7f4, 0x0, 0x0, 0xbb33, 0xb802,
    0x0, 0x0, 0xbb33, 0xb809, 0x0, 0x0, 0xbb33, 0xb810,
    0x0, 0x0, 0xbb33, 0xb818, 0x0, 0x0, 0xbb33, 0xb81f,
    0x0, 0x0, 0xbb33, 0xb827, 0x0, 0x0, 0xbb33, 0xb82e,
    0x0, 0x0, 0xbb33, 0xb836, 0x0, 0x0, 0xbb33, 0xb83e,
    0x0, 0x0, 0xbb33, 0xb845, 0x0, 0x0, 0xbb33, 0xb84d,
    0x0, 0x0, 0xbb33, 0xb855, 0x0, 0x0, 0xbb33, 0xb85c,
    0x0, 0x0, 0xbb33, 0xb864, 0x0, 0x0, 0xbb33, 0xb86c,
    0x0, 0x0, 0xbb33, 0xb874, 0x0, 0x0, 0xbb33, 0xb87b,
    0x0, 0x0, 0xbb33, 0xb883, 0x0, 0x0, 0xbb33, 0xb88b,
    0x0, 0x0, 0xbb33, 0xb893, 0x0, 0x0, 0xbb33, 0xb89b,
    0x0, 0x0, 0xbb33, 0xb8a3, 0x0, 0x0, 0xbb33, 0xb8ab,
    0x0, 0x0, 0xbb33, 0xb8b3, 0x0, 0x0, 0xbb33, 0xb8bb,
    0x0, 0x0, 0xbb33, 0xb8c3, 0x0, 0x0, 0xbb33, 0xb8cc,
    0x0, 0x0, 0xbb33, 0xb8d4, 0x0, 0x0, 0xbb33, 0xb8dc,
    0x0, 0x0, 0xbb33, 0xb8e4, 0x0, 0x0, 0xbb33, 0xb8ec,
    0x0, 0x0, 0xbb33, 0xb8f5, 0x0, 0x0, 0xbb33, 0xb8fd,
    0x0, 0x0, 0xbb33, 0xb905, 0x0, 0x0, 0xbb33, 0xb90e,
    0x0, 0x0, 0xbb33, 0xb916, 0x0, 0x0, 0xbb33, 0xb91f,
    0x0, 0x0, 0xbb33, 0xb927, 0x0, 0x0, 0xbb33, 0xb930,
    0x0, 0x0, 0xbb33, 0xb939, 0x0, 0x0, 0xbb33, 0xb941,
    0x0, 0x0, 0xbb33, 0xb94a, 0x0, 0x0, 0xbb33, 0xb953,
    0x0, 0x0, 0xbb33, 0xb95b, 0x0, 0x0, 0xbb33, 0xb964,
    0x0, 0x0, 0xbb33, 0xb96d, 0x0, 0x0, 0xbb33, 0xb976,
    0x0, 0x0, 0xbb33, 0xb97f, 0x0, 0x0, 0xbb33, 0xb988,
    0x0, 0x0, 0xbb33, 0xb991, 0x0, 0x0, 0xbb33, 0xb99a,
    0x0, 0x0, 0xbb33, 0xb9a3, 0x0, 0x0, 0xbb33, 0xb9ac,
    0x0, 0x0, 0xbb33, 0xb9b5, 0x0, 0x0, 0xbb33, 0xb9bf,
    0x0, 0x0, 0xbb33, 0xb9c8, 0x0, 0x0, 0xbb33, 0xb9d1,
    0x0, 0x0, 0xbb33, 0xb9db, 0x0, 0x0, 0xbb33, 0xb9e4,
    0x0, 0x0, 0xbb33, 0xb9ed, 0x0, 0x0, 0xbb33, 0xb9f7,
    0x0, 0x0, 0xbb33, 0xba00, 0x0, 0x0, 0xbb33, 0xba0a,
    0x0, 0x0, 0xbb33, 0xba14, 0x0, 0x0, 0xbb33, 0xba1d,
    0x0, 0x0, 0xbb33, 0xba27, 0x0, 0x0, 0xbb33, 0xba31,
    0x0, 0x0, 0xbb33, 0xba3b, 0x0, 0x0, 0xbb33, 0xba45,
    0x0, 0x0, 0xbb33, 0xba4f, 0x0, 0x0, 0xbb33, 0xba59,
    0x0, 0x0, 0xbb33, 0xba63, 0x0, 0x0, 0xbb33, 0xba6d,
    0x0, 0x0, 0xbb33, 0xba77, 0x0, 0x0, 0xbb33, 0xba81,
    0x0, 0x0, 0xbb33, 0xba8c, 0x0, 0x0, 0xbb33, 0xba96,
    0x0, 0x0, 0xbb33, 0xbaa1, 0x0, 0x0, 0xbb33, 0xbaab,
    0x0, 0x0, 0xbb33, 0xbab6, 0x0, 0x0, 0xbb33, 0xbac0,
    0x0, 0x0, 0xbb33, 0xbacb, 0x0, 0x0, 0xbb33, 0xbad5,
    0x0, 0x0, 0xbb33, 0xbae0, 0x0, 0x0, 0xbb33, 0xbaeb,
    0x0, 0x0, 0xbb33, 0xbaf6, 0x0, 0x0, 0xbb33, 0xbb01,
    0x0, 0x0, 0xbb33, 0xbb0c, 0x0, 0x0, 0xbb33, 0xbb17,
    0x0, 0x0, 0xbb33, 0xbb22, 0x0, 0x0, 0xbb33, 0xbb2e,
    0x0, 0x0, 0xbb33, 0xbb39, 0x0, 0x0, 0xbb33, 0xbb44,
    0x0, 0x0, 0xbb33, 0xbb50, 0x0, 0x0, 0xbb33, 0xbb5b,
    0x0, 0x0, 0xbb33, 0xbb67, 0x0, 0x0, 0xbb33, 0xbb72,
    0x0, 0x0, 0xbb33, 0xbb7e, 0x0, 0x0, 0xbb33, 0xbb8a,
    0x0, 0x0, 0xbb33, 0xbb96, 0x0, 0x0, 0xbb33, 0xbba2,
    0x0, 0x0, 0xbb33, 0xbbae, 0x0, 0x0, 0xbb33, 0xbbba,
    0x0, 0x0, 0xbb33, 0xbbc6, 0x0, 0x0, 0xbb33, 0xbbd3,
    0x0, 0x0, 0xbb33, 0xbbdf, 0x0, 0x0, 0xbb33, 0xbbeb,
    0x0, 0x0, 0xbb33, 0xbbf8, 0x0, 0x0, 0xbb33, 0xbc02,
    0x0, 0x0, 0xbb33, 0xbc09, 0x0, 0x0, 0xbb33, 0xbc0f,
    0x0, 0x0, 0xbb33, 0xbc15, 0x0, 0x0, 0xbb33, 0xbc1c,
    0x0, 0x0, 0xbb33, 0xbc23, 0x0, 0x0, 0xbb33, 0xbc29,
    0x0, 0x0, 0xbb33, 0xbc30, 0x0, 0x0, 0xbb33, 0xbc36,
    0x0, 0x0, 0xbb33, 0xbc3d, 0x0, 0x0, 0xbb33, 0xbc44,
    0x0, 0x0, 0xbb33, 0xbc4b, 0x0, 0x0, 0xbb33, 0xbc52,
    0x0, 0x0, 0xbb33, 0xbc58, 0x0, 0x0, 0xbb33, 0xbc5f,
    0x0, 0x0, 0xbb33, 0xbc66, 0x0, 0x0, 0xbb33, 0xbc6e,
    0x0, 0x0, 0xbb33, 0xbc75, 0x0, 0x0, 0xbb33, 0xbc7c,
    0x0, 0x0, 0xbb33, 0xbc83, 0x0, 0x0, 0xbb33, 0xbc8a,
    0x0, 0x0, 0xbb33, 0xbc92, 0x0, 0x0, 0xbb33, 0xbc99,
    0x0, 0x0, 0xbb33, 0xbca1, 0x0, 0x0, 0xbb33, 0xbca8,
    0x0, 0x0, 0xbb33, 0xbcb0, 0x0, 0x0, 0xbb33, 0xbcb7,
    0x0, 0x0, 0xbb33, 0xbcbf, 0x0, 0x0, 0xbb33, 0xbcc7,
    0x0, 0x0, 0xbb33, 0xbccf, 0x0, 0x0, 0xbb33, 0xbcd7,
    0x0, 0x0, 0xbb33, 0xbcdf, 0x0, 0x0, 0xbb33, 0xbce7,
    0x0, 0x0, 0xbb33, 0xbcef, 0x0, 0x0, 0xbb33, 0xbcf7,
    0x0, 0x0, 0xbb33, 0xbcff, 0x0, 0x0, 0xbb33, 0xbd07,
    0x0, 0x0, 0xbb33, 0xbd10, 0x0, 0x0, 0xbb33, 0xbd18,
    0x0, 0x0, 0xbb33, 0xbd21, 0x0, 0x0, 0xbb33, 0xbd29,
    0x0, 0x0, 0xbb33, 0xbd32, 0x0, 0x0, 0xbb33, 0xbd3b,
    0x0, 0x0, 0xbb33, 0xbd44, 0x0, 0x0, 0xbb33, 0xbd4d,
    0x0, 0x0, 0xbb33, 0xbd56, 0x0, 0x0, 0xbb33, 0xbd5f,
    0x0, 0x0, 0xbb33, 0xbd68, 0x0, 0x0, 0xbb33, 0xbd71,
    0x0, 0x0, 0xbb33, 0xbd7a, 0x0, 0x0, 0xbb33, 0xbd84,
    0x0, 0x0, 0xbb33, 0xbd8d, 0x0, 0x0, 0xbb33, 0xbd97,
    0x0, 0x0, 0xbb33, 0xbda1, 0x0, 0x0, 0xbb33, 0xbdaa,
    0x0, 0x0, 0xbb33, 0xbdb4, 0x0, 0x0, 0xbb33, 0xbdbe,
    0x0, 0x0, 0xbb33, 0xbdc8, 0x0, 0x0, 0xbb33, 0xbdd3,
    0x0, 0x0, 0xbb33, 0xbddd, 0x0, 0x0, 0xbb33, 0xbde7,
    0x0, 0x0, 0xbb33, 0xbdf2, 0x0, 0x0, 0xbb33, 0xbdfc,
    0x0, 0x0, 0xbb33, 0xbe07, 0x0, 0x0, 0xbb33, 0xbe12,
    0x0, 0x0, 0xbb33, 0xbe1d, 0x0, 0x0, 0xbb33, 0xbe28,
    0x0, 0x0, 0xbb33, 0xbe33, 0x0, 0x0, 0xbb33, 0xbe3e,
    0x0, 0x0, 0xbb33, 0xbe4a, 0x0, 0x0, 0xbb33, 0xbe55,
    0x0, 0x0, 0xbb33, 0xbe61, 0x0, 0x0, 0xbb33, 0xbe6c,
    0x0, 0x0, 0xbb33, 0xbe78, 0x0, 0x0, 0xbb33, 0xbe84,
    0x0, 0x0, 0xbb33, 0xbe91, 0x0, 0x0, 0xbb33, 0xbe9d,
    0x0, 0x0, 0xbb33, 0xbea9, 0x0, 0x0, 0xbb33, 0xbeb6,
    0x0, 0x0, 0xbb33, 0xbec3, 0x0, 0x0, 0xbb33, 0xbecf,
    0x0, 0x0, 0xbb33, 0xbedc, 0x0, 0x0, 0xbb33, 0xbeea,
    0x0, 0x0, 0xbb33, 0xbef7, 0x0, 0x0, 0xbb33, 0xbf04,
    0x0, 0x0, 0xbb33, 0xbf12, 0x0, 0x0, 0xbb33, 0xbf20,
    0x0, 0x0, 0xbb33, 0xbf2e, 0x0, 0x0, 0xbb33, 0xbf3c,
    0x0, 0x0, 0xbb33, 0xbf4a, 0x0, 0x0, 0xbb33, 0xbf59,
    0x0, 0x0, 0xbb33, 0xbf68, 0x0, 0x0, 0xbb33, 0xbf77,
    0x0, 0x0, 0xbb33, 0xbf86, 0x0, 0x0, 0xbb33, 0xbf95,
    0x0, 0x0, 0xbb33, 0xbfa4, 0x0, 0x0, 0xbb33, 0xbfb4,
    0x0, 0x0, 0xbb33, 0xbfc4, 0x0, 0x0, 0xbb33, 0xbfd4,
    0x0, 0x0, 0xbb33, 0xbfe4, 0x0, 0x0, 0xbb33, 0xbff5,
    0x0, 0x0, 0xbb33, 0xc003, 0x0, 0x0, 0xbb33, 0xc00b,
    0x0, 0x0, 0xbb33, 0xc014, 0x0, 0x0, 0xbb33, 0xc01d,
    0x0, 0x0, 0xbb33, 0xc025, 0x0, 0x0, 0xbb33, 0xc02e,
    0x0, 0x0, 0xbb33, 0xc038, 0x0, 0x0, 0xbb33, 0xc041,
    0x0, 0x0, 0xbb33, 0xc04a, 0x0, 0x0, 0xbb33, 0xc054,
    0x0, 0x0, 0xbb33, 0xc05d, 0x0, 0x0, 0xbb33, 0xc067,
    0x0, 0x0, 0xbb33, 0xc071, 0x0, 0x0, 0xbb33, 0xc07b,
    0x0, 0x0, 0xbb33, 0xc085, 0x0, 0x0, 0xbb33, 0xc090,
    0x0, 0x0, 0xbb33, 0xc09a, 0x0, 0x0, 0xbb33, 0xc0a5,
    0x0, 0x0, 0xbb33, 0xc0b0, 0x0, 0x0, 0xbb33, 0xc0bb,
    0x0, 0x0, 0xbb33, 0xc0c6, 0x0, 0x0, 0xbb33, 0xc0d2,
    0x0, 0x0, 0xbb33, 0xc0de, 0x0, 0x0, 0xbb33, 0xc0e9,
    0x0, 0x0, 0xbb33, 0xc0f5, 0x0, 0x0, 0xbb33, 0xc102,
    0x0, 0x0, 0xbb33, 0xc10e, 0x0, 0x0, 0xbb33, 0xc11b,
    0x0, 0x0, 0xbb33, 0xc128, 0x0, 0x0, 0xbb33, 0xc135,
    0x0, 0x0, 0xbb33, 0xc142, 0x0, 0x0, 0xbb33, 0xc150,
    0x0, 0x0, 0xbb33, 0xc15e, 0x0, 0x0, 0xbb33, 0xc16c,
    0x0, 0x0, 0xbb33, 0xc17a, 0x0, 0x0, 0xbb33, 0xc189,
    0x0, 0x0, 0xbb33, 0xc198, 0x0, 0x0, 0xbb33, 0xc1a7,
    0x0, 0x0, 0xbb33, 0xc1b6, 0x0, 0x0, 0xbb33, 0xc1c6,
    0x0, 0x0, 0xbb33, 0xc1d6, 0x0, 0x0, 0xbb33, 0xc1e7,
    0x0, 0x0, 0xbb33, 0xc1f7, 0x0, 0x0, 0xbb33, 0xc209,
    0x0, 0x0, 0xbb33, 0xc21a, 0x0, 0x0, 0xbb33, 0xc22c,
    0x0, 0x0, 0xbb33, 0xc23e, 0x0, 0x0, 0xbb33, 0xc251,
    0x0, 0x0, 0xbb33, 0xc264, 0x0, 0x0, 0xbb33, 0xc277,
    0x0, 0x0, 0xbb33, 0xc28b, 0x0, 0x0, 0xbb33, 0xc29f,
    0x0, 0x0, 0xbb33, 0xc2b4, 0x0, 0x0, 0xbb33, 0xc2c9,
    0x0, 0x0, 0xbb33, 0xc2df, 0x0, 0x0, 0xbb33, 0xc2f6,
    0x0, 0x0, 0xbb33, 0xc30c, 0x0, 0x0, 0xbb33, 0xc324,
    0x0, 0x0, 0xbb33, 0xc33c, 0x0, 0x0, 0xbb33, 0xc354,
    0x0, 0x0, 0xbb33, 0xc36d, 0x0, 0x0, 0xbb33, 0xc387,
    0x0, 0x0, 0xbb33, 0xc3a2, 0x0, 0x0, 0xbb33, 0xc3bd,
    0x0, 0x0, 0xbb33, 0xc3d9, 0x0, 0x0, 0xbb33, 0xc3f5,
    0x0, 0x0, 0xbb33, 0xc409, 0x0, 0x0, 0xbb33, 0xc419,
    0x0, 0x0, 0xbb33, 0xc428, 0x0, 0x0, 0xbb33, 0xc438,
    0x0, 0x0, 0xbb33, 0xc449, 0x0, 0x0, 0xbb33, 0xc45a,
    0x0, 0x0, 0xbb33, 0xc46b, 0x0, 0x0, 0xbb33, 0xc47d,
    0x0, 0x0, 0xbb33, 0xc490, 0x0, 0x0, 0xbb33, 0xc4a3,
    0x0, 0x0, 0xbb33, 0xc4b7, 0x0, 0x0, 0xbb33, 0xc4cb,
    0x0, 0x0, 0xbb33, 0xc4e0, 0x0, 0x0, 0xbb33, 0xc4f6,
    0x0, 0x0, 0xbb33, 0xc50c, 0x0, 0x0, 0xbb33, 0xc524,
    0x0, 0x0, 0xbb33, 0xc53c, 0x0, 0x0, 0xbb33, 0xc555,
    0x0, 0x0, 0xbb33, 0xc56f, 0x0, 0x0, 0xbb33, 0xc58a,
    0x0, 0x0, 0xbb33, 0xc5a6, 0x0, 0x0, 0xbb33, 0xc5c3,
    0x0, 0x0, 0xbb33, 0xc5e1, 0x0, 0x0, 0xbb33, 0xc601,
    0x0, 0x0, 0xbb33, 0xc622, 0x0, 0x0, 0xbb33, 0xc644,
    0x0, 0x0, 0xbb33, 0xc668, 0x0, 0x0, 0xbb33, 0xc68d,
    0x0, 0x0, 0xbb33, 0xc6b4, 0x0, 0x0, 0xbb33, 0xc6dd,
    0x0, 0x0, 0xbb33, 0xc708, 0x0, 0x0, 0xbb33, 0xc735,
    0x0, 0x0, 0xbb33, 0xc764, 0x0, 0x0, 0xbb33, 0xc796,
    0x0, 0x0, 0xbb33, 0xc7ca, 0x0, 0x0, 0xbb33, 0xc800,
    0x0, 0x0, 0xbb33, 0xc81e, 0x0, 0x0, 0xbb33, 0xc83c,
    0x0, 0x0, 0xbb33, 0xc85d, 0x0, 0x0, 0xbb33, 0xc880,
    0x0, 0x0, 0xbb33, 0xc8a4, 0x0, 0x0, 0xbb33, 0xc8cc,
    0x0, 0x0, 0xbb33, 0xc8f5, 0x0, 0x0, 0xbb33, 0xc922,
    0x0, 0x0, 0xbb33, 0xc952, 0x0, 0x0, 0xbb33, 0xc986,
    0x0, 0x0, 0xbb33, 0xc9be, 0x0, 0x0, 0xbb33, 0xc9fa,
    0x0, 0x0, 0xbb33, 0xca3b, 0x0, 0x0, 0xbb33, 0xca82,
    0x0, 0x0, 0xbb33, 0xcad0, 0x0, 0x0, 0xbb33, 0xcb25,
    0x0, 0x0, 0xbb33, 0xcb83, 0x0, 0x0, 0xbb33, 0xcbec,
    0x0, 0x0, 0xbb33, 0xcc30, 0x0, 0x0, 0xbb33, 0xcc71,
    0x0, 0x0, 0xbb33, 0xccba, 0x0, 0x0, 0xbb33, 0xcd0e,
    0x0, 0x0, 0xbb33, 0xcd6e, 0x0, 0x0, 0xbb33, 0xcddd,
    0x0, 0x0, 0xbb33, 0xce60, 0x0, 0x0, 0xbb33, 0xcefb,
    0x0, 0x0, 0xbb33, 0xcfb8, 0x0, 0x0, 0xbb33, 0xd050,
    0x0, 0x0, 0xbb33, 0xd0e3, 0x0, 0x0, 0xbb33, 0xd1a4,
    0x0, 0x0, 0xbb33, 0xd2ab, 0x0, 0x0, 0xbb33, 0xd413,
    0x0, 0x0, 0xbb33, 0xd53d, 0x0, 0x0, 0xbb33, 0xd755,
    0x0, 0x0, 0xbb33, 0xda1d, 0x0, 0x0, 0xbb33, 0xe095
    };

static const uint16_t ref_cfft_step_2048[4096] = {
    0x6333, 0x0, 0xbb33, 0x6095, 0x0, 0x0, 0xbb33, 0x5a1d,
    0x0, 0x0, 0xbb33, 0x5755, 0x0, 0x0, 0xbb33, 0x553d,
    0x0, 0x0, 0xbb33, 0x5413, 0x0, 0x0, 0xbb33, 0x52ab,
    0x0, 0x0, 0xbb33, 0x51a4, 0x0, 0x0, 0xbb33, 0x50e3,
    0x0, 0x0, 0xbb33, 0x5050, 0x0, 0x0, 0xbb33, 0x4fb8,
    0x0, 0x0, 0xbb33, 0x4efb, 0x0, 0x0, 0xbb33, 0x4e60,
    0x0, 0x0, 0xbb33, 0x4ddd, 0x0, 0x0, 0xbb33, 0x4d6e,
    0x0, 0x0, 0xbb33, 0x4d0e, 0x0, 0x0, 0xbb33, 0x4cba,
    0x0, 0x0, 0xbb33, 0x4c71, 0x0, 0x0, 0xbb33, 0x4c30,
    0x0, 0x0, 0xbb33, 0x4bec, 0x0, 0x0, 0xbb33, 0x4b83,
    0x0, 0x0, 0xbb33, 0x4b25, 0x0, 0x0, 0xbb33, 0x4ad0,
    0x0, 0x0, 0xbb33, 0x4a82, 0x0, 0x0, 0xbb33, 0x4a3b,
    0x0, 0x0, 0xbb33, 0x49fa, 0x0, 0x0, 0xbb33, 0x49be,
    0x0, 0x0, 0xbb33, 0x4986, 0x0, 0x0, 0xbb33, 0x4952,
    0x0, 0x0, 0xbb33, 0x4922, 0x0, 0x0, 0xbb33, 0x48f5,
    0x0, 0x0, 0xbb33, 0x48cc, 0x0, 0x0, 0xbb33, 0x48a4,
    0x0, 0x0, 0xbb33, 0x4880, 0x0, 0x0, 0xbb33, 0x485d,
    0x0, 0x0, 0xbb33, 0x483c, 0x0, 0x0, 0xbb33, 0x481e,
    0x0, 0x0, 0xbb33, 0x4800, 0x0, 0x0, 0xbb33, 0x47ca,
    0x0, 0x0, 0xbb33, 0x4796, 0x0, 0x0, 0xbb33, 0x4764,
    0x0, 0x0, 0xbb33, 0x4735, 0x0, 0x0, 0xbb33, 0x4708,
    0x0, 0x0, 0xbb33, 0x46dd, 0x0, 0x0, 0xbb33, 0x46b4,
    0x0, 0x0, 0xbb33, 0x468d, 0x0, 0x0, 0xbb33, 0x4668,
    0x0, 0x0, 0xbb33, 0x4644, 0x0, 0x0, 0xbb33, 0x4622,
    0x0, 0x0, 0xbb33, 0x4601, 0x0, 0x0, 0xbb33, 0x45e1,
    0x0, 0x0, 0xbb33, 0x45c3, 0x0, 0x0, 0xbb33, 0x45a6,
    0x0, 0x0, 0xbb33, 0x458a, 0x0, 0x0, 0xbb33, 0x456f,
    0x0, 0x0, 0xbb33, 0x4555, 0x0, 0x0, 0xbb33, 0x453c,
    0x0, 0x0, 0xbb33, 0x4524, 0x0, 0x0, 0xbb33, 0x450c,
    0x0, 0x0, 0xbb33, 0x44f6, 0x0, 0x0, 0xbb33, 0x44e0,
    0x0, 0x0, 0xbb33, 0x44cb, 0x0, 0x0, 0xbb33, 0x44b7,
    0x0, 0x0, 0xbb33, 0x44a3, 0x0, 0x0, 0xbb33, 0x4490,
    0x0, 0x0, 0xbb33, 0x447d, 0x0, 0x0, 0xbb33, 0x446b,
    0x0, 0x0, 0xbb33, 0x445a, 0x0, 0x0, 0xbb33, 0x4449,
    0x0, 0x0, 0xbb33, 0x4438, 0x0, 0x0, 0xbb33, 0x4428,
    0x0, 0x0, 0xbb33, 0x4419, 0x0, 0x0, 0xbb33, 0x4409,
    0x0, 0x0, 0xbb33, 0x43f5, 0x0, 0x0, 0xbb33, 0x43d9,
    0x0, 0x0, 0xbb33, 0x43bd, 0x0, 0x0, 0xbb33, 0x43a2,
    0x0, 0x0, 0xbb33, 0x4387, 0x0, 0x0, 0xbb33, 0x436d,
    0x0, 0x0, 0xbb33, 0x4354, 0x0, 0x0, 0xbb33, 0x433c,
    0x0, 0x0, 0xbb33, 0x4324, 0x0, 0x0, 0xbb33, 0x430c,
    0x0, 0x0, 0xbb33, 0x42f6, 0x0, 0x0, 0xbb33, 0x42df,
    0x0, 0x0, 0xbb33, 0x42c9, 0x0, 0x0, 0xbb33, 0x42b4,
    0x0, 0x0, 0xbb33, 0x429f, 0x0, 0x0, 0xbb33, 0x428b,
    0x0, 0x0, 0xbb33, 0x4277, 0x0, 0x0, 0xbb33, 0x4264,
    0x0, 0x0, 0xbb33, 0x4251, 0x0, 0x0, 0xbb33, 0x423e,
    0x0, 0x0, 0xbb33, 0x422c, 0x0, 0x0, 0xbb33, 0x421a,
    0x0, 0x0, 0xbb33, 0x4209, 0x0, 0x0, 0xbb33, 0x41f7,
    0x0, 0x0, 0xbb33, 0x41e7, 0x0, 0x0, 0xbb33, 0x41d6,
    0x0, 0x0, 0xbb33, 0x41c6, 0x0, 0x0, 0xbb33, 0x41b6,
    0x0, 0x0, 0xbb33, 0x41a7, 0x0, 0x0, 0xbb33, 0x4198,
    0x0, 0x0, 0xbb33, 0x4189, 0x0, 0x0, 0xbb33, 0x417a,
    0x0, 0x0, 0xbb33, 0x416c, 0x0, 0x0, 0xbb33, 0x415e,
    0x0, 0x0, 0xbb33, 0x4150, 0x0, 0x0, 0xbb33, 0x4142,
    0x0, 0x0, 0xbb33, 0x4135, 0x0, 0x0, 0xbb33, 0x4128,
    0x0, 0x0, 0xbb33, 0x411b, 0x0, 0x0, 0xbb33, 0x410e,
    0x0, 0x0, 0xbb33, 0x4102, 0x0, 0x0, 0xbb33, 0x40f5,
    0x0, 0x0, 0xbb33, 0x40e9, 0x0, 0x0, 0xbb33, 0x40de,
    0x0, 0x0, 0xbb33, 0x40d2, 0x0, 0x0, 0xbb33, 0x40c6,
    0x0, 0x0, 0xbb33, 0x40bb, 0x0, 0x0, 0xbb33, 0x40b0,
    0x0, 0x0, 0xbb33, 0x40a5, 0x0, 0x0, 0xbb33, 0x409a,
    0x0, 0x0, 0xbb33, 0x4090, 0x0, 0x0, 0xbb33, 0x4085,
    0x0, 0x0, 0xbb33, 0x407b, 0x0, 0x0, 0xbb33, 0x4071,
    0x0, 0x0, 0xbb33, 0x4067, 0x0, 0x0, 0xbb33, 0x405d,
    0x0, 0x0, 0xbb33, 0x4054, 0x0, 0x0, 0xbb33, 0x404a,
    0x0, 0x0, 0xbb33, 0x4041, 0x0, 0x0, 0xbb33, 0x4038,
    0x0, 0x0, 0xbb33, 0x402e, 0x0, 0x0, 0xbb33, 0x4025,
    0x0, 0x0, 0xbb33, 0x401d, 0x0, 0x0, 0xbb33, 0x4014,
    0x0, 0x0, 0xbb33, 0x400b, 0x0, 0x0, 0xbb33, 0x4003,
    0x0, 0x0, 0xbb33, 0x3ff5, 0x0, 0x0, 0xbb33, 0x3fe4,
    0x0, 0x0, 0xbb33, 0x3fd4, 0x0, 0x0, 0xbb33, 0x3fc4,
    0x0, 0x0, 0xbb33, 0x3fb4, 0x0, 0x0, 0xbb33, 0x3fa4,
    0x0, 0x0, 0xbb33, 0x3f95, 0x0, 0x0, 0xbb33, 0x3f86,
    0x0, 0x0, 0xbb33, 0x3f77, 0x0, 0x0, 0xbb33, 0x3f68,
    0x0, 0x0, 0xbb33, 0x3f59, 0x0, 0x0, 0xbb33, 0x3f4a,
    0x0, 0x0, 0xbb33, 0x3f3c, 0x0, 0x0, 0xbb33, 0x3f2e,
    0x0, 0x0, 0xbb33, 0x3f20, 0x0, 0x0, 0xbb33, 0x3f12,
    0x0, 0x0, 0xbb33, 0x3f04, 0x0, 0x0, 0xbb33, 0x3ef7,
    0x0, 0x0, 0xbb33, 0x3eea, 0x0, 0x0, 0xbb33, 0x3edc,
    0x0, 0x0, 0xbb33, 0x3ecf, 0x0, 0x0, 0xbb33, 0x3ec3,
    0x0, 0x0, 0xbb33, 0x3eb6, 0x0, 0x0, 0xbb33, 0x3ea9,
    0x0, 0x0, 0xbb33, 0x3e9d, 0x0, 0x0, 0xbb33, 0x3e91,
    0x0, 0x0, 0xbb33, 0x3e84, 0x0, 0x0, 0xbb33, 0x3e78,
    0x0, 0x0, 0xbb33, 0x3e6c, 0x0, 0x0, 0xbb33, 0x3e61,
    0x0, 0x0, 0xbb33, 0x3e55, 0x0, 0x0, 0xbb33, 0x3e4a,
    0x0, 0x0, 0xbb33, 0x3e3e, 0x0, 0x0, 0xbb33, 0x3e33,
    0x0, 0x0, 0xbb33, 0x3e28, 0x0, 0x0, 0xbb33, 0x3e1d,
    0x0, 0x0, 0xbb33, 0x3e12, 0x0, 0x0, 0xbb33, 0x3e07,
    0x0, 0x0, 0xbb33, 0x3dfc, 0x0, 0x0, 0xbb33, 0x3df2,
    0x0, 0x0, 0xbb33, 0x3de7, 0x0, 0x0, 0xbb33, 0x3ddd,
    0x0, 0x0, 0xbb33, 0x3dd3, 0x0, 0x0, 0xbb33, 0x3dc8,
    0x0, 0x0, 0xbb33, 0x3dbe, 0x0, 0x0, 0xbb33, 0x3db4,
    0x0, 0x0, 0xbb33, 0x3daa, 0x0, 0x0, 0xbb33, 0x3da1,
    0x0, 0x0, 0xbb33, 0x3d97, 0x0, 0x0, 0xbb33, 0x3d8d,
    0x0, 0x0, 0xbb33, 0x3d84, 0x0, 0x0, 0xbb33, 0x3d7a,
    0x0, 0x0, 0xbb33, 0x3d71, 0x0, 0x0, 0xbb33, 0x3d68,
    0x0, 0x0, 0xbb33, 0x3d5f, 0x0, 0x0, 0xbb33, 0x3d56,
    0x0, 0x0, 0xbb33, 0x3d4d, 0x0, 0x0, 0xbb33, 0x3d44,
    0x0, 0x0, 0xbb33, 0x3d3b, 0x0, 0x0, 0xbb33, 0x3d32,
    0x0, 0x0, 0xbb33, 0x3d29, 0x0, 0x0, 0xbb33, 0x3d21,
    0x0, 0x0, 0xbb33, 0x3d18, 0x0, 0x0, 0xbb33, 0x3d10,
    0x0, 0x0, 0xbb33, 0x3d07, 0x0, 0x0, 0xbb33, 0x3cff,
    0x0, 0x0, 0xbb33, 0x3cf7, 0x0, 0x0, 0xbb33, 0x3cef,
    0x0, 0x0, 0xbb33, 0x3ce7, 0x0, 0x0, 0xbb33, 0x3cdf,
    0x0, 0x0, 0xbb33, 0x3cd7, 0x0, 0x0, 0xbb33, 0x3ccf,
    0x0, 0x0, 0xbb33, 0x3cc7, 0x0, 0x0, 0xbb33, 0x3cbf,
    0x0, 0x0, 0xbb33, 0x3cb7, 0x0, 0x0, 0xbb33, 0x3cb0,
    0x0, 0x0, 0xbb33, 0x3ca8, 0x0, 0x0, 0xbb33, 0x3ca1,
    0x0, 0x0, 0xbb33, 0x3c99, 0x0, 0x0, 0xbb33, 0x3c92,
    0x0, 0x0, 0xbb33, 0x3c8a, 0x0, 0x0, 0xbb33, 0x3c83,
    0x0, 0x0, 0xbb33, 0x3c7c, 0x0, 0x0, 0xbb33, 0x3c75,
    0x0, 0x0, 0xbb33, 0x3c6e, 0x0, 0x0, 0xbb33, 0x3c66,
    0x0, 0x0, 0xbb33, 0x3c5f, 0x0, 0x0, 0xbb33, 0x3c58,
    0x0, 0x0, 0xbb33, 0x3c52, 0x0, 0x0, 0xbb33, 0x3c4b,
    0x0, 0x0, 0xbb33, 0x3c44, 0x0, 0x0, 0xbb33, 0x3c3d,
    0x0, 0x0, 0xbb33, 0x3c36, 0x0, 0x0, 0xbb33, 0x3c30,
    0x0, 0x0, 0xbb33, 0x3c29, 0x0, 0x0, 0xbb33, 0x3c23,
    0x0, 0x0, 0xbb33, 0x3c1c, 0x0, 0x0, 0xbb33, 0x3c15,
    0x0, 0x0, 0xbb33, 0x3c0f, 0x0, 0x0, 0xbb33, 0x3c09,
    0x0, 0x0, 0xbb33, 0x3c02, 0x0, 0x0, 0xbb33, 0x3bf8,
    0x0, 0x0, 0xbb33, 0x3beb, 0x0, 0x0, 0xbb33, 0x3bdf,
    0x0, 0x0, 0xbb33, 0x3bd3, 0x0, 0x0, 0xbb33, 0x3bc6,
    0x0, 0x0, 0xbb33, 0x3bba, 0x0, 0x0, 0xbb33, 0x3bae,
    0x0, 0x0, 0xbb33, 0x3ba2, 0x0, 0x0, 0xbb33, 0x3b96,
    0x0, 0x0, 0xbb33, 0x3b8a, 0x0, 0x0, 0xbb33, 0x3b7e,
    0x0, 0x0, 0xbb33, 0x3b72, 0x0, 0x0, 0xbb33, 0x3b67,
    0x0, 0x0, 0xbb33, 0x3b5b, 0x0, 0x0, 0xbb33, 0x3b50,
    0x0, 0x0, 0xbb33, 0x3b44, 0x0, 0x0, 0xbb33, 0x3b39,
    0x0, 0x0, 0xbb33, 0x3b2e, 0x0, 0x0, 0xbb33, 0x3b22,
    0x0, 0x0, 0xbb33, 0x3b17, 0x0, 0x0, 0xbb33, 0x3b0c,
    0x0, 0x0, 0xbb33, 0x3b01, 0x0, 0x0, 0xbb33, 0x3af6,
    0x0, 0x0, 0xbb33, 0x3aeb, 0x0, 0x0, 0xbb33, 0x3ae0,
    0x0, 0x0, 0xbb33, 0x3ad5, 0x0, 0x0, 0xbb33, 0x3acb,
    0x0, 0x0, 0xbb33, 0x3ac0, 0x0, 0x0, 0xbb33, 0x3ab6,
    0x0, 0x0, 0xbb33, 0x3aab, 0x0, 0x0, 0xbb33, 0x3aa1,
    0x0, 0x0, 0xbb33, 0x3a96, 0x0, 0x0, 0xbb33, 0x3a8c,
    0x0, 0x0, 0xbb33, 0x3a81, 0x0, 0x0, 0xbb33, 0x3a77,
    0x0, 0x0, 0xbb33, 0x3a6d, 0x0, 0x0, 0xbb33, 0x3a63,
    0x0, 0x0, 0xbb33, 0x3a59, 0x0, 0x0, 0xbb33, 0x3a4f,
    0x0, 0x0, 0xbb33, 0x3a45, 0x0, 0x0, 0xbb33, 0x3a3b,
    0x0, 0x0, 0xbb33, 0x3a31, 0x0, 0x0, 0xbb33, 0x3a27,
    0x0, 0x0, 0xbb33, 0x3a1d, 0x0, 0x0, 0xbb33, 0x3a14,
    0x0, 0x0, 0xbb33, 0x3a0a, 0x0, 0x0, 0xbb33, 0x3a00,
    0x0, 0x0, 0xbb33, 0x39f7, 0x0, 0x0, 0xbb33, 0x39ed,
    0x0, 0x0, 0xbb33, 0x39e4, 0x0, 0x0, 0xbb33, 0x39db,
    0x0, 0x0, 0xbb33, 0x39d1, 0x0, 0x0, 0xbb33, 0x39c8,
    0x0, 0x0, 0xbb33, 0x39bf, 0x0, 0x0, 0xbb33, 0x39b5,
    0x0, 0x0, 0xbb33, 0x39ac, 0x0, 0x0, 0xbb33, 0x39a3,
    0x0, 0x0, 0xbb33, 0x399a, 0x0, 0x0, 0xbb33, 0x3991,
    0x0, 0x0, 0xbb33, 0x3988, 0x0, 0x0, 0xbb33, 0x397f,
    0x0, 0x0, 0xbb33, 0x3976, 0x0, 0x0, 0xbb33, 0x396d,
    0x0, 0x0, 0xbb33, 0x3964, 0x0, 0x0, 0xbb33, 0x395b,
    0x0, 0x0, 0xbb33, 0x3953, 0x0, 0x0, 0xbb33, 0x394a,
    0x0, 0x0, 0xbb33, 0x3941, 0x0, 0x0, 0xbb33, 0x3939,
    0x0, 0x0, 0xbb33, 0x3930, 0x0, 0x0, 0xbb33, 0x3927,
    0x0, 0x0, 0xbb33, 0x391f, 0x0, 0x0, 0xbb33, 0x3916,
    0x0, 0x0, 0xbb33, 0x390e, 0x0, 0x0, 0xbb33, 0x3905,
    0x0, 0x0, 0xbb33, 0x38fd, 0x0, 0x0, 0xbb33, 0x38f5,
    0x0, 0x0, 0xbb33, 0x38ec, 0x0, 0x0, 0xbb33, 0x38e4,
    0x0, 0x0, 0xbb33, 0x38dc, 0x0, 0x0, 0xbb33, 0x38d4,
    0x0, 0x0, 0xbb33, 0x38cc, 0x0, 0x0, 0xbb33, 0x38c3,
    0x0, 0x0, 0xbb33, 0x38bb, 0x0, 0x0, 0xbb33, 0x38b3,
    0x0, 0x0, 0xbb33, 0x38ab, 0x0, 0x0, 0xbb33, 0x38a3,
    0x0, 0x0, 0xbb33, 0x389b, 0x0, 0x0, 0xbb33, 0x3893,
    0x0, 0x0, 0xbb33, 0x388b, 0x0, 0x0, 0xbb33, 0x3883,
    0x0, 0x0, 0xbb33, 0x387b, 0x0, 0x0, 0xbb33, 0x3874,
    0x0, 0x0, 0xbb33, 0x386c, 0x0, 0x0, 0xbb33, 0x3864,
    0x0, 0x0, 0xbb33, 0x385c, 0x0, 0x0, 0xbb33, 0x3855,
    0x0, 0x0, 0xbb33, 0x384d, 0x0, 0x0, 0xbb33, 0x3845,
    0x0, 0x0, 0xbb33, 0x383e, 0x0, 0x0, 0xbb33, 0x3836,
    0x0, 0x0, 0xbb33, 0x382e, 0x0, 0x0, 0xbb33, 0x3827,
    0x0, 0x0, 0xbb33, 0x381f, 0x0, 0x0, 0xbb33, 0x3818,
    0x0, 0x0, 0xbb33, 0x3810, 0x0, 0x0, 0xbb33, 0x3809,
    0x0, 0x0, 0xbb33, 0x3802, 0x0, 0x0, 0xbb33, 0x37f4,
    0x0, 0x0, 0xbb33, 0x37e6, 0x0, 0x0, 0xbb33, 0x37d7,
    0x0, 0x0, 0xbb33, 0x37c8, 0x0, 0x0, 0xbb33, 0x37ba,
    0x0, 0x0, 0xbb33, 0x37ab, 0x0, 0x0, 0xbb33, 0x379d,
    0x0, 0x0, 0xbb33, 0x378e, 0x0, 0x0, 0xbb33, 0x3780,
    0x0, 0x0, 0xbb33, 0x3771, 0x0, 0x0, 0xbb33, 0x3763,
    0x0, 0x0, 0xbb33, 0x3755, 0x0, 0x0, 0xbb33, 0x3747,
    0x0, 0x0, 0xbb33, 0x3738, 0x0, 0x0, 0xbb33, 0x372a,
    0x0, 0x0, 0xbb33, 0x371c, 0x0, 0x0, 0xbb33, 0x370e,
    0x0, 0x0, 0xbb33, 0x3700, 0x0, 0x0, 0xbb33, 0x36f2,
    0x0, 0x0, 0xbb33, 0x36e4, 0x0, 0x0, 0xbb33, 0x36d6,
    0x0, 0x0, 0xbb33, 0x36c9, 0x0, 0x0, 0xbb33, 0x36bb,
    0x0, 0x0, 0xbb33, 0x36ad, 0x0, 0x0, 0xbb33, 0x369f,
    0x0, 0x0, 0xbb33, 0x3692, 0x0, 0x0, 0xbb33, 0x3684,
    0x0, 0x0, 0xbb33, 0x3676, 0x0, 0x0, 0xbb33, 0x3669,
    0x0, 0x0, 0xbb33, 0x365b, 0x0, 0x0, 0xbb33, 0x364e,
    0x0, 0x0, 0xbb33, 0x3640, 0x0, 0x0, 0xbb33, 0x3633,
    0x0, 0x0, 0xbb33, 0x3626, 0x0, 0x0, 0xbb33, 0x3618,
    0x0, 0x0, 0xbb33, 0x360b, 0x0, 0x0, 0xbb33, 0x35fe,
    0x0, 0x0, 0xbb33, 0x35f0, 0x0, 0x0, 0xbb33, 0x35e3,
    0x0, 0x0, 0xbb33, 0x35d6, 0x0, 0x0, 0xbb33, 0x35c9,
    0x0, 0x0, 0xbb33, 0x35bc, 0x0, 0x0, 0xbb33, 0x35af,
    0x0, 0x0, 0xbb33, 0x35a2, 0x0, 0x0, 0xbb33, 0x3595,
    0x0, 0x0, 0xbb33, 0x3588, 0x0, 0x0, 0xbb33, 0x357b,
    0x0, 0x0, 0xbb33, 0x356e, 0x0, 0x0, 0xbb33, 0x3561,
    0x0, 0x0, 0xbb33, 0x3554, 0x0, 0x0, 0xbb33, 0x3547,
    0x0, 0x0, 0xbb33, 0x353a, 0x0, 0x0, 0xbb33, 0x352d,
    0x0, 0x0, 0xbb33, 0x3521, 0x0, 0x0, 0xbb33, 0x3514,
    0x0, 0x0, 0xbb33, 0x3507, 0x0, 0x0, 0xbb33, 0x34fb,
    0x0, 0x0, 0xbb33, 0x34ee, 0x0, 0x0, 0xbb33, 0x34e1,
    0x0, 0x0, 0xbb33, 0x34d5, 0x0, 0x0, 0xbb33, 0x34c8,
    0x0, 0x0, 0xbb33, 0x34bc, 0x0, 0x0, 0xbb33, 0x34af,
    0x0, 0x0, 0xbb33, 0x34a3, 0x0, 0x0, 0xbb33, 0x3496,
    0x0, 0x0, 0xbb33, 0x348a, 0x0, 0x0, 0xbb33, 0x347d,
    0x0, 0x0, 0xbb33, 0x3471, 0x0, 0x0, 0xbb33, 0x3464,
    0x0, 0x0, 0xbb33, 0x3458, 0x0, 0x0, 0xbb33, 0x344c,
    0x0, 0x0, 0xbb33, 0x343f, 0x0, 0x0, 0xbb33, 0x3433,
    0x0, 0x0, 0xbb33, 0x3427, 0x0, 0x0, 0xbb33, 0x341b,
    0x0, 0x0, 0xbb33, 0x340e, 0x0, 0x0, 0xbb33, 0x3402,
    0x0, 0x0, 0xbb33, 0x33ec, 0x0, 0x0, 0xbb33, 0x33d4,
    0x0, 0x0, 0xbb33, 0x33bc, 0x0, 0x0, 0xbb33, 0x33a3,
    0x0, 0x0, 0xbb33, 0x338b, 0x0, 0x0, 0xbb33, 0x3373,
    0x0, 0x0, 0xbb33, 0x335b, 0x0, 0x0, 0xbb33, 0x3343,
    0x0, 0x0, 0xbb33, 0x332b, 0x0, 0x0, 0xbb33, 0x3313,
    0x0, 0x0, 0xbb33, 0x32fb, 0x0, 0x0, 0xbb33, 0x32e3,
    0x0, 0x0, 0xbb33, 0x32cb, 0x0, 0x0, 0xbb33, 0x32b3,
    0x0, 0x0, 0xbb33, 0x329b, 0x0, 0x0, 0xbb33, 0x3284,
    0x0, 0x0, 0xbb33, 0x326c, 0x0, 0x0, 0xbb33, 0x3254,
    0x0, 0x0, 0xbb33, 0x323c, 0x0, 0x0, 0xbb33, 0x3225,
    0x0, 0x0, 0xbb33, 0x320d, 0x0, 0x0, 0xbb33, 0x31f5,
    0x0, 0x0, 0xbb33, 0x31de, 0x0, 0x0, 0xbb33, 0x31c6,
    0x0, 0x0, 0xbb33, 0x31af, 0x0, 0x0, 0xbb33, 0x3197,
    0x0, 0x0, 0xbb33, 0x3180, 0x0, 0x0, 0xbb33, 0x3168,
    0x0, 0x0, 0xbb33, 0x3151, 0x0, 0x0, 0xbb33, 0x313a,
    0x0, 0x0, 0xbb33, 0x3122, 0x0, 0x0, 0xbb33, 0x310b,
    0x0, 0x0, 0xbb33, 0x30f4, 0x0, 0x0, 0xbb33, 0x30dc,
    0x0, 0x0, 0xbb33, 0x30c5, 0x0, 0x0, 0xbb33, 0x30ae,
    0x0, 0x0, 0xbb33, 0x3097, 0x0, 0x0, 0xbb33, 0x3080,
    0x0, 0x0, 0xbb33, 0x3068, 0x0, 0x0, 0xbb33, 0x3051,
    0x0, 0x0, 0xbb33, 0x303a, 0x0, 0x0, 0xbb33, 0x3023,
    0x0, 0x0, 0xbb33, 0x300c, 0x0, 0x0, 0xbb33, 0x2fea,
    0x0, 0x0, 0xbb33, 0x2fbc, 0x0, 0x0, 0xbb33, 0x2f8e,
    0x0, 0x0, 0xbb33, 0x2f60, 0x0, 0x0, 0xbb33, 0x2f32,
    0x0, 0x0, 0xbb33, 0x2f04, 0x0, 0x0, 0xbb33, 0x2ed6,
    0x0, 0x0, 0xbb33, 0x2ea8, 0x0, 0x0, 0xbb33, 0x2e7a,
    0x0, 0x0, 0xbb33, 0x2e4c, 0x0, 0x0, 0xbb33, 0x2e1f,
    0x0, 0x0, 0xbb33, 0x2df1, 0x0, 0x0, 0xbb33, 0x2dc3,
    0x0, 0x0, 0xbb33, 0x2d95, 0x0, 0x0, 0xbb33, 0x2d68,
    0x0, 0x0, 0xbb33, 0x2d3a, 0x0, 0x0, 0xbb33, 0x2d0d,
    0x0, 0x0, 0xbb33, 0x2cdf, 0x0, 0x0, 0xbb33, 0x2cb1,
    0x0, 0x0, 0xbb33, 0x2c84, 0x0, 0x0, 0xbb33, 0x2c56,
    0x0, 0x0, 0xbb33, 0x2c29, 0x0, 0x0, 0xbb33, 0x2bf7,
    0x0, 0x0, 0xbb33, 0x2b9c, 0x0, 0x0, 0xbb33, 0x2b41,
    0x0, 0x0, 0xbb33, 0x2ae6, 0x0, 0x0, 0xbb33, 0x2a8c,
    0x0, 0x0, 0xbb33, 0x2a31, 0x0, 0x0, 0xbb33, 0x29d6,
    0x0, 0x0, 0xbb33, 0x297b, 0x0, 0x0, 0xbb33, 0x2921,
    0x0, 0x0, 0xbb33, 0x28c6, 0x0, 0x0, 0xbb33, 0x286c,
    0x0, 0x0, 0xbb33, 0x2811, 0x0, 0x0, 0xbb33, 0x276d,
    0x0, 0x0, 0xbb33, 0x26b8, 0x0, 0x0, 0xbb33, 0x2602,
    0x0, 0x0, 0xbb33, 0x254d, 0x0, 0x0, 0xbb33, 0x2498,
    0x0, 0x0, 0xbb33, 0x23c7, 0x0, 0x0, 0xbb33, 0x225d,
    0x0, 0x0, 0xbb33, 0x20f3, 0x0, 0x0, 0xbb33, 0x1f12,
    0x0, 0x0, 0xbb33, 0x1c3e, 0x0, 0x0, 0xbb33, 0x15a8,
    0x0, 0x0, 0xbb33, 0x95a8, 0x0, 0x0, 0xbb33, 0x9c3e,
    0x0, 0x0, 0xbb33, 0x9f12, 0x0, 0x0, 0xbb33, 0xa0f3,
    0x0, 0x0, 0xbb33, 0xa25d, 0x0, 0x0, 0xbb33, 0xa3c7,
    0x0, 0x0, 0xbb33, 0xa498, 0x0, 0x0, 0xbb33, 0xa54d,
    0x0, 0x0, 0xbb33, 0xa602, 0x0, 0x0, 0xbb33, 0xa6b8,
    0x0, 0x0, 0xbb33, 0xa76d, 0x0, 0x0, 0xbb33, 0xa811,
    0x0, 0x0, 0xbb33, 0xa86c, 0x0, 0x0, 0xbb33, 0xa8c6,
    0x0, 0x0, 0xbb33, 0xa921, 0x0, 0x0, 0xbb33, 0xa97b,
    0x0, 0x0, 0xbb33, 0xa9d6, 0x0, 0x0, 0xbb33, 0xaa31,
    0x0, 0x0, 0xbb33, 0xaa8c, 0x0, 0x0, 0xbb33, 0xaae6,
    0x0, 0x0, 0xbb33, 0xab41, 0x0, 0x0, 0xbb33, 0xab9c,
    0x0, 0x0, 0xbb33, 0xabf7, 0x0, 0x0, 0xbb33, 0xac29,
    0x0, 0x0, 0xbb33, 0xac56, 0x0, 0x0, 0xbb33, 0xac84,
    0x0, 0x0, 0xbb33, 0xacb1, 0x0, 0x0, 0xbb33, 0xacdf,
    0x0, 0x0, 0xbb33, 0xad0d, 0x0, 0x0, 0xbb33, 0xad3a,
    0x0, 0x0, 0xbb33, 0xad68, 0x0, 0x0, 0xbb33, 0xad95,
    0x0, 0x0, 0xbb33, 0xadc3, 0x0, 0x0, 0xbb33, 0xadf1,
    0x0, 0x0, 0xbb33, 0xae1f, 0x0, 0x0, 0xbb33, 0xae4c,
    0x0, 0x0, 0xbb33, 0xae7a, 0x0, 0x0, 0xbb33, 0xaea8,
    0x0, 0x0, 0xbb33, 0xaed6, 0x0, 0x0, 0xbb33, 0xaf04,
    0x0, 0x0, 0xbb33, 0xaf32, 0x0, 0x0, 0xbb33, 0xaf60,
    0x0, 0x0, 0xbb33, 0xaf8e, 0x0, 0x0, 0xbb33, 0xafbc,
    0x0, 0x0, 0xbb33, 0xafea, 0x0, 0x0, 0xbb33, 0xb00c,
    0x0, 0x0, 0xbb33, 0xb023, 0x0, 0x0, 0xbb33, 0xb03a,
    0x0, 0x0, 0xbb33, 0xb051, 0x0, 0x0, 0xbb33, 0xb068,
    0x0, 0x0, 0xbb33, 0xb080, 0x0, 0x0, 0xbb33, 0xb097,
    0x0, 0x0, 0xbb33, 0xb0ae, 0x0, 0x0, 0xbb33, 0xb0c5,
    0x0, 0x0, 0xbb33, 0xb0dc, 0x0, 0x0, 0xbb33, 0xb0f4,
    0x0, 0x0, 0xbb33, 0xb10b, 0x0, 0x0, 0xbb33, 0xb122,
    0x0, 0x0, 0xbb33, 0xb13a, 0x0, 0x0, 0xbb33, 0xb151,
    0x0, 0x0, 0xbb33, 0xb168, 0x0, 0x0, 0xbb33, 0xb180,
    0x0, 0x0, 0xbb33, 0xb197, 0x0, 0x0, 0xbb33, 0xb1af,
    0x0, 0x0, 0xbb33, 0xb1c6, 0x0, 0x0, 0xbb33, 0xb1de,
    0x0, 0x0, 0xbb33, 0xb1f5, 0x0, 0x0, 0xbb33, 0xb20d,
    0x0, 0x0, 0xbb33, 0xb225, 0x0, 0x0, 0xbb33, 0xb23c,
    0x0, 0x0, 0xbb33, 0xb254, 0x0, 0x0, 0xbb33, 0xb26c,
    0x0, 0x0, 0xbb33, 0xb284, 0x0, 0x0, 0xbb33, 0xb29b,
    0x0, 0x0, 0xbb33, 0xb2b3, 0x0, 0x0, 0xbb33, 0xb2cb,
    0x0, 0x0, 0xbb33, 0xb2e3, 0x0, 0x0, 0xbb33, 0xb2fb,
    0x0, 0x0, 0xbb33, 0xb313, 0x0, 0x0, 0xbb33, 0xb32b,
    0x0, 0x0, 0xbb33, 0xb343, 0x0, 0x0, 0xbb33, 0xb35b,
    0x0, 0x0, 0xbb33, 0xb373, 0x0, 0x0, 0xbb33, 0xb38b,
    0x0, 0x0, 0xbb33, 0xb3a3, 0x0, 0x0, 0xbb33, 0xb3bc,
    0x0, 0x0, 0xbb33, 0xb3d4, 0x0, 0x0, 0xbb33, 0xb3ec,
    0x0, 0x0, 0xbb33, 0xb402, 0x0, 0x0, 0xbb33, 0xb40e,
    0x0, 0x0, 0xbb33, 0xb41b, 0x0, 0x0, 0xbb33, 0xb427,
    0x0, 0x0, 0xbb33, 0xb433, 0x0, 0x0, 0xbb33, 0xb43f,
    0x0, 0x0, 0xbb33, 0xb44c, 0x0, 0x0, 0xbb33, 0xb458,
    0x0, 0x0, 0xbb33, 0xb464, 0x0, 0x0, 0xbb33, 0xb471,
    0x0, 0x0, 0xbb33, 0xb47d, 0x0, 0x0, 0xbb33, 0xb48a,
    0x0, 0x0, 0xbb33, 0xb496, 0x0, 0x0, 0xbb33, 0xb4a3,
    0x0, 0x0, 0xbb33, 0xb4af, 0x0, 0x0, 0xbb33, 0xb4bc,
    0x0, 0x0, 0xbb33, 0xb4c8, 0x0, 0x0, 0xbb33, 0xb4d5,
    0x0, 0x0, 0xbb33, 0xb4e1, 0x0, 0x0, 0xbb33, 0xb4ee,
    0x0, 0x0, 0xbb33, 0xb4fb, 0x0, 0x0, 0xbb33, 0xb507,
    0x0, 0x0, 0xbb33, 0xb514, 0x0, 0x0, 0xbb33, 0xb521,
    0x0, 0x0, 0xbb33, 0xb52d, 0x0, 0x0, 0xbb33, 0xb53a,
    0x0, 0x0, 0xbb33, 0xb547, 0x0, 0x0, 0xbb33, 0xb554,
    0x0, 0x0, 0xbb33, 0xb561, 0x0, 0x0, 0xbb33, 0xb56e,
    0x0, 0x0, 0xbb33, 0xb57b, 0x0, 0x0, 0xbb33, 0xb588,
    0x0, 0x0, 0xbb33, 0xb595, 0x0, 0x0, 0xbb33, 0xb5a2,
    0x0, 0x0, 0xbb33, 0xb5af, 0x0, 0x0, 0xbb33, 0xb5bc,
    0x0, 0x0, 0xbb33, 0xb5c9, 0x0, 0x0, 0xbb33, 0xb5d6,
    0x0, 0x0, 0xbb33, 0xb5e3, 0x0, 0x0, 0xbb33, 0xb5f0,
    0x0, 0x0, 0xbb33, 0xb5fe, 0x0, 0x0, 0xbb33, 0xb60b,
    0x0, 0x0, 0xbb33, 0xb618, 0x0, 0x0, 0xbb33, 0xb626,
    0x0, 0x0, 0xbb33, 0xb633, 0x0, 0x0, 0xbb33, 0xb640,
    0x0, 0x0, 0xbb33, 0xb64e, 0x0, 0x0, 0xbb33, 0xb65b,
    0x0, 0x0, 0xbb33, 0xb669, 0x0, 0x0, 0xbb33, 0xb676,
    0x0, 0x0, 0xbb33, 0xb684, 0x0, 0x0, 0xbb33, 0xb692,
    0x0, 0x0, 0xbb33, 0xb69f, 0x0, 0x0, 0xbb33, 0xb6ad,
    0x0, 0x0, 0xbb33, 0xb6bb, 0x0, 0x0, 0xbb33, 0xb6c9,
    0x0, 0x0, 0xbb33, 0xb6d6, 0x0, 0x0, 0xbb33, 0xb6e4,
    0x0, 0x0, 0xbb33, 0xb6f2, 0x0, 0x0, 0xbb33, 0xb700,
    0x0, 0x0, 0xbb33, 0xb70e, 0x0, 0x0, 0xbb33, 0xb71c,
    0x0, 0x0, 0xbb33, 0xb72a, 0x0, 0x0, 0xbb33, 0xb738,
    0x0, 0x0, 0xbb33, 0xb747, 0x0, 0x0, 0xbb33, 0xb755,
    0x0, 0x0, 0xbb33, 0xb763, 0x0, 0x0, 0xbb33, 0xb771,
    0x0, 0x0, 0xbb33, 0xb780, 0x0, 0x0, 0xbb33, 0xb78e,
    0x0, 0x0, 0xbb33, 0xb79d, 0x0, 0x0, 0xbb33, 0xb7ab,
    0x0, 0x0, 0xbb33, 0xb7ba, 0x0, 0x0, 0xbb33, 0xb7c8,
    0x0, 0x0, 0xbb33, 0xb7d7, 0x0, 0x0, 0xbb33, 0xb7e6,
    0x0, 0x0, 0xbb33, 0xb7f4, 0x0, 0x0, 0xbb33, 0xb802,
    0x0, 0x0, 0xbb33, 0xb809, 0x0, 0x0, 0xbb33, 0xb810,
    0x0, 0x0, 0xbb33, 0xb818, 0x0, 0x0, 0xbb33, 0xb81f,
    0x0, 0x0, 0xbb33, 0xb827, 0x0, 0x0, 0xbb33, 0xb82e,
    0x0, 0x0, 0xbb33, 0xb836, 0x0, 0x0, 0xbb33, 0xb83e,
    0x0, 0x0, 0xbb33, 0xb845, 0x0, 0x0, 0xbb33, 0xb84d,
    0x0, 0x0, 0xbb33, 0xb855, 0x0, 0x0, 0xbb33, 0xb85c,
    0x0, 0x0, 0xbb33, 0xb864, 0x0, 0x0, 0xbb33, 0xb86c,
    0x0, 0x0, 0xbb33, 0xb874, 0x0, 0x0, 0xbb33, 0xb87b,
    0x0, 0x0, 0xbb33, 0xb883, 0x0, 0x0, 0xbb33, 0xb88b,
    0x0, 0x0, 0xbb33, 0xb893, 0x0, 0x0, 0xbb33, 0xb89b,
    0x0, 0x0, 0xbb33, 0xb8a3, 0x0, 0x0, 0xbb33, 0xb8ab,
    0x0, 0x0, 0xbb33, 0xb8b3, 0x0, 0x0, 0xbb33, 0xb8bb,
    0x0, 0x0, 0xbb33, 0xb8c3, 0x0, 0x0, 0xbb33, 0xb8cc,
    0x0, 0x0, 0xbb33, 0xb8d4, 0x0, 0x0, 0xbb33, 0xb8dc,
    0x0, 0x0, 0xbb33, 0xb8e4, 0x0, 0x0, 0xbb33, 0xb8ec,
    0x0, 0x0, 0xbb33, 0xb8f5, 0x0, 0x0, 0xbb33, 0xb8fd,
    0x0, 0x0, 0xbb33, 0xb905, 0x0, 0x0, 0xbb33, 0xb90e,
    0x0, 0x0, 0xbb33, 0xb916, 0x0, 0x0, 0xbb33, 0xb91f,
    0x0, 0x0, 0xbb33, 0xb927, 0x0, 0x0, 0xbb33, 0xb930,
    0x0, 0x0, 0xbb33, 0xb939, 0x0, 0x0, 0xbb33, 0xb941,
    0x0, 0x0, 0xbb33, 0xb94a, 0x0, 0x0, 0xbb33, 0xb953,
    0x0, 0x0, 0xbb33, 0xb95b, 0x0, 0x0, 0xbb33, 0xb964,
    0x0, 0x0, 0xbb33, 0xb96d, 0x0, 0x0, 0xbb33, 0xb976,
    0x0, 0x0, 0xbb33, 0xb97f, 0x0, 0x0, 0xbb33, 0xb988,
    0x0, 0x0, 0xbb33, 0xb991, 0x0, 0x0, 0xbb33, 0xb99a,
    0x0, 0x0, 0xbb33, 0xb9a3, 0x0, 0x0, 0xbb33, 0xb9ac,
    0x0, 0x0, 0xbb33, 0xb9b5, 0x0, 0x0, 0xbb33, 0xb9bf,
    0x0, 0x0, 0xbb33, 0xb9c8, 0x0, 0x0, 0xbb33, 0xb9d1,
    0x0, 0x0, 0xbb33, 0xb9db, 0x0, 0x0, 0xbb33, 0xb9e4,
    0x0, 0x0, 0xbb33, 0xb9ed, 0x0, 0x0, 0xbb33, 0xb9f7,
    0x0, 0x0, 0xbb33, 0xba00, 0x0, 0x0, 0xbb33, 0xba0a,
    0x0, 0x0, 0xbb33, 0xba14, 0x0, 0x0, 0xbb33, 0xba1d,
    0x0, 0x0, 0xbb33, 0xba27, 0x0, 0x0, 0xbb33, 0xba31,
    0x0, 0x0, 0xbb33, 0xba3b, 0x0, 0x0, 0xbb33, 0xba45,
    0x0, 0x0, 0xbb33, 0xba4f, 0x0, 0x0, 0xbb33, 0xba59,
    0x0, 0x0, 0xbb33, 0xba63, 0x0, 0x0, 0xbb33, 0xba6d,
    0x0, 0x0, 0xbb33, 0xba77, 0x0, 0x0, 0xbb33, 0xba81,
    0x0, 0x0, 0xbb33, 0xba8c, 0x0, 0x0, 0xbb33, 0xba96,
    0x0, 0x0, 0xbb33, 0xbaa1, 0x0, 0x0, 0xbb33, 0xbaab,
    0x0, 0x0, 0xbb33, 0xbab6, 0x0, 0x0, 0xbb33, 0xbac0,
    0x0, 0x0, 0xbb33, 0xbacb, 0x0, 0x0, 0xbb33, 0xbad5,
    0x0, 0x0, 0xbb33, 0xbae0, 0x0, 0x0, 0xbb33, 0xbaeb,
    0x0, 0x0, 0xbb33, 0xbaf6, 0x0, 0x0, 0xbb33, 0xbb01,
    0x0, 0x0, 0xbb33, 0xbb0c, 0x0, 0x0, 0xbb33, 0xbb17,
    0x0, 0x0, 0xbb33, 0xbb22, 0x0, 0x0, 0xbb33, 0xbb2e,
    0x0, 0x0, 0xbb33, 0xbb39, 0x0, 0x0, 0xbb33, 0xbb44,
    0x0, 0x0, 0xbb33, 0xbb50, 0x0, 0x0, 0xbb33, 0xbb5b,
    0x0, 0x0, 0xbb33, 0xbb67, 0x0, 0x0, 0xbb33, 0xbb72,
    0x0, 0x0, 0xbb33, 0xbb7e, 0x0, 0x0, 0xbb33, 0xbb8a,
    0x0, 0x0, 0xbb33, 0xbb96, 0x0, 0x0, 0xbb33, 0xbba2,
    0x0, 0x0, 0xbb33, 0xbbae, 0x0, 0x0, 0xbb33, 0xbbba,
    0x0, 0x0, 0xbb33, 0xbbc6, 0x0, 0x0, 0xbb33, 0xbbd3,
    0x0, 0x0, 0xbb33, 0xbbdf, 0x0, 0x0, 0xbb33, 0xbbeb,
    0x0, 0x0, 0xbb33, 0xbbf8, 0x0, 0x0, 0xbb33, 0xbc02,
    0x0, 0x0, 0xbb33, 0xbc09, 0x0, 0x0, 0xbb33, 0xbc0f,
    0x0, 0x0, 0xbb33, 0xbc15, 0x0, 0x0, 0xbb33, 0xbc1c,
    0x0, 0x0, 0xbb33, 0xbc23, 0x0, 0x0, 0xbb33, 0xbc29,
    0x0, 0x0, 0xbb33, 0xbc30, 0x0, 0x0, 0xbb33, 0xbc36,
    0x0, 0x0, 0xbb33, 0xbc3d, 0x0, 0x0, 0xbb33, 0xbc44,
    0x0, 0x0, 0xbb33, 0xbc4b, 0x0, 0x0, 0xbb33, 0xbc52,
    0x0, 0x0, 0xbb33, 0xbc58, 0x0, 0x0, 0xbb33, 0xbc5f,
    0x0, 0x0, 0xbb33, 0xbc66, 0x0, 0x0, 0xbb33, 0xbc6e,
    0x0, 0x0, 0xbb33, 0xbc75, 0x0, 0x0, 0xbb33, 0xbc7c,
    0x0, 0x0, 0xbb33, 0xbc83, 0x0, 0x0, 0xbb33, 0xbc8a,
    0x0, 0x0, 0xbb33, 0xbc92, 0x0, 0x0, 0xbb33, 0xbc99,
    0x0, 0x0, 0xbb33, 0xbca1, 0x0, 0x0, 0xbb33, 0xbca8,
    0x0, 0x0, 0xbb33, 0xbcb0, 0x0, 0x0, 0xbb33, 0xbcb7,
    0x0, 0x0, 0xbb33, 0xbcbf, 0x0, 0x0, 0xbb33, 0xbcc7,
    0x0, 0x0, 0xbb33, 0xbccf, 0x0, 0x0, 0xbb33, 0xbcd7,
    0x0, 0x0, 0xbb33, 0xbcdf, 0x0, 0x0, 0xbb33, 0xbce7,
    0x0, 0x0, 0xbb33, 0xbcef, 0x0, 0x0, 0xbb33, 0xbcf7,
    0x0, 0x0, 0xbb33, 0xbcff, 0x0, 0x0, 0xbb33, 0xbd07,
    0x0, 0x0, 0xbb33, 0xbd10, 0x0, 0x0, 0xbb33, 0xbd18,
    0x0, 0x0, 0xbb33, 0xbd21, 0x0, 0x0, 0xbb33, 0xbd29,
    0x0, 0x0, 0xbb33, 0xbd32, 0x0, 0x0, 0xbb33, 0xbd3b,
    0x0, 0x0, 0xbb33, 0xbd44, 0x0, 0x0, 0xbb33, 0xbd4d,
    0x0, 0x0, 0xbb33, 0xbd56, 0x0, 0x0, 0xbb33, 0xbd5f,
    0x0, 0x0, 0xbb33, 0xbd68, 0x0, 0x0, 0xbb33, 0xbd71,
    0x0, 0x0, 0xbb33, 0xbd7a, 0x0, 0x0, 0xbb33, 0xbd84,
    0x0, 0x0, 0xbb33, 0xbd8d, 0x0, 0x0, 0xbb33, 0xbd97,
    0x0, 0x0, 0xbb33, 0xbda1, 0x0, 0x0, 0xbb33, 0xbdaa,
    0x0, 0x0, 0xbb33, 0xbdb4, 0x0, 0x0, 0xbb33, 0xbdbe,
    0x0, 0x0, 0xbb33, 0xbdc8, 0x0, 0x0, 0xbb33, 0xbdd3,
    0x0, 0x0, 0xbb33, 0xbddd, 0x0, 0x0, 0xbb33, 0xbde7,
    0x0, 0x0, 0xbb33, 0xbdf2, 0x0, 0x0, 0xbb33, 0xbdfc,
    0x0, 0x0, 0xbb33, 0xbe07, 0x0, 0x0, 0xbb33, 0xbe12,
    0x0, 0x0, 0xbb33, 0xbe1d, 0x0, 0x0, 0xbb33, 0xbe28,
    0x0, 0x0, 0xbb33, 0xbe33, 0x0, 0x0, 0xbb33, 0xbe3e,
    0x0, 0x0, 0xbb33, 0xbe4a, 0x0, 0x0, 0xbb33, 0xbe55,
    0x0, 0x0, 0xbb33, 0xbe61, 0x0, 0x0, 0xbb33, 0xbe6c,
    0x0, 0x0, 0xbb33, 0xbe78, 0x0, 0x0, 0xbb33, 0xbe84,
    0x0, 0x0, 0xbb33, 0xbe91, 0x0, 0x0, 0xbb33, 0xbe9d,
    0x0, 0x0, 0xbb33, 0xbea9, 0x0, 0x0, 0xbb33, 0xbeb6,
    0x0, 0x0, 0xbb33, 0xbec3, 0x0, 0x0, 0xbb33, 0xbecf,
    0x0, 0x0, 0xbb33, 0xbedc, 0x0, 0x0, 0xbb33, 0xbeea,
    0x0, 0x0, 0xbb33, 0xbef7, 0x0, 0x0, 0xbb33, 0xbf04,
    0x0, 0x0, 0xbb33, 0xbf12, 0x0, 0x0, 0xbb33, 0xbf20,
    0x0, 0x0, 0xbb33, 0xbf2e, 0x0, 0x0, 0xbb33, 0xbf3c,
    0x0, 0x0, 0xbb33, 0xbf4a, 0x0, 0x0, 0xbb33, 0xbf59,
    0x0, 0x0, 0xbb33, 0xbf68, 0x0, 0x0, 0xbb33, 0xbf77,
    0x0, 0x0, 0xbb33, 0xbf86, 0x0, 0x0, 0xbb33, 0xbf95,
    0x0, 0x0, 0xbb33, 0xbfa4, 0x0, 0x0, 0xbb33, 0xbfb4,
    0x0, 0x0, 0xbb33, 0xbfc4, 0x0, 0x0, 0xbb33, 0xbfd4,
    0x0, 0x0, 0xbb33, 0xbfe4, 0x0, 0x0, 0xbb33, 0xbff5,
    0x0, 0x0, 0xbb33, 0xc003, 0x0, 0x0, 0xbb33, 0xc00b,
    0x0, 0x0, 0xbb33, 0xc014, 0x0, 0x0, 0xbb33, 0xc01d,
    0x0, 0x0, 0xbb33, 0xc025, 0x0, 0x0, 0xbb33, 0xc02e,
    0x0, 0x0, 0xbb33, 0xc038, 0x0, 0x0, 0xbb33, 0xc041,
    0x0, 0x0, 0xbb33, 0xc04a, 0x0, 0x0, 0xbb33, 0xc054,
    0x0, 0x0, 0xbb33, 0xc05d, 0x0, 0x0, 0xbb33, 0xc067,
    0x0, 0x0, 0xbb33, 0xc071, 0x0, 0x0, 0xbb33, 0xc07b,
    0x0, 0x0, 0xbb33, 0xc085, 0x0, 0x0, 0xbb33, 0xc090,
    0x0, 0x0, 0xbb33, 0xc09a, 0x0, 0x0, 0xbb33, 0xc0a5,
    0x0, 0x0, 0xbb33, 0xc0b0, 0x0, 0x0, 0xbb33, 0xc0bb,
    0x0, 0x0, 0xbb33, 0xc0c6, 0x0, 0x0, 0xbb33, 0xc0d2,
    0x0, 0x0, 0xbb33, 0xc0de, 0x0, 0x0, 0xbb33, 0xc0e9,
    0x0, 0x0, 0xbb33, 0xc0f5, 0x0, 0x0, 0xbb33, 0xc102,
    0x0, 0x0, 0xbb33, 0xc10e, 0x0, 0x0, 0xbb33, 0xc11b,
    0x0, 0x0, 0xbb33, 0xc128, 0x0, 0x0, 0xbb33, 0xc135,
    0x0, 0x0, 0xbb33, 0xc142, 0x0, 0x0, 0xbb33, 0xc150,
    0x0, 0x0, 0xbb33, 0xc15e, 0x0, 0x0, 0xbb33, 0xc16c,
    0x0, 0x0, 0xbb33, 0xc17a, 0x0, 0x0, 0xbb33, 0xc189,
    0x0, 0x0, 0xbb33, 0xc198, 0x0, 0x0, 0xbb33, 0xc1a7,
    0x0, 0x0, 0xbb33, 0xc1b6, 0x0, 0x0, 0xbb33, 0xc1c6,
    0x0, 0x0, 0xbb33, 0xc1d6, 0x0, 0x0, 0xbb33, 0xc1e7,
    0x0, 0x0, 0xbb33, 0xc1f7, 0x0, 0x0, 0xbb33, 0xc209,
    0x0, 0x0, 0xbb33, 0xc21a, 0x0, 0x0, 0xbb33, 0xc22c,
    0x0, 0x0, 0xbb33, 0xc23e, 0x0, 0x0, 0xbb33, 0xc251,
    0x0, 0x0, 0xbb33, 0xc264, 0x0, 0x0, 0xbb33, 0xc277,
    0x0, 0x0, 0xbb33, 0xc28b, 0x0, 0x0, 0xbb33, 0xc29f,
    0x0, 0x0, 0xbb33, 0xc2b4, 0x0, 0x0, 0xbb33, 0xc2c9,
    0x0, 0x0, 0xbb33, 0xc2df, 0x0, 0x0, 0xbb33, 0xc2f6,
    0x0, 0x0, 0xbb33, 0xc30c, 0x0, 0x0, 0xbb33, 0xc324,
    0x0, 0x0, 0xbb33, 0xc33c, 0x0, 0x0, 0xbb33, 0xc354,
    0x0, 0x0, 0xbb33, 0xc36d, 0x0, 0x0, 0xbb33, 0xc387,
    0x0, 0x0, 0xbb33, 0xc3a2, 0x0, 0x0, 0xbb33, 0xc3bd,
    0x0, 0x0, 0xbb33, 0xc3d9, 0x0, 0x0, 0xbb33, 0xc3f5,
    0x0, 0x0, 0xbb33, 0xc409, 0x0, 0x0, 0xbb33, 0xc419,
    0x0, 0x0, 0xbb33, 0xc428, 0x0, 0x0, 0xbb33, 0xc438,
    0x0, 0x0, 0xbb33, 0xc449, 0x0, 0x0, 0xbb33, 0xc45a,
    0x0, 0x0, 0xbb33, 0xc46b, 0x0, 0x0, 0xbb33, 0xc47d,
    0x0, 0x0, 0xbb33, 0xc490, 0x0, 0x0, 0xbb33, 0xc4a3,
    0x0, 0x0, 0xbb33, 0xc4b7, 0x0, 0x0, 0xbb33, 0xc4cb,
    0x0, 0x0, 0xbb33, 0xc4e0, 0x0, 0x0, 0xbb33, 0xc4f6,
    0x0, 0x0, 0xbb33, 0xc50c, 0x0, 0x0, 0xbb33, 0xc524,
    0x0, 0x0, 0xbb33, 0xc53c, 0x0, 0x0, 0xbb33, 0xc555,
    0x0, 0x0, 0xbb33, 0xc56f, 0x0, 0x0, 0xbb33, 0xc58a,
    0x0, 0x0, 0xbb33, 0xc5a6, 0x0, 0x0, 0xbb33, 0xc5c3,
    0x0, 0x0, 0xbb33, 0xc5e1, 0x0, 0x0, 0xbb33, 0xc601,
    0x0, 0x0, 0xbb33, 0xc622, 0x0, 0x0, 0xbb33, 0xc644,
    0x0, 0x0, 0xbb33, 0xc668, 0x0, 0x0, 0xbb33, 0xc68d,
    0x0, 0x0, 0xbb33, 0xc6b4, 0x0, 0x0, 0xbb33, 0xc6dd,
    0x0, 0x0, 0xbb33, 0xc708, 0x0, 0x0, 0xbb33, 0xc735,
    0x0, 0x0, 0xbb33, 0xc764, 0x0, 0x0, 0xbb33, 0xc796,
    0x0, 0x0, 0xbb33, 0xc7ca, 0x0, 0x0, 0xbb33, 0xc800,
    0x0, 0x0, 0xbb33, 0xc81e, 0x0, 0x0, 0xbb33, 0xc83c,
    0x0, 0x0, 0xbb33, 0xc85d, 0x0, 0x0, 0xbb33, 0xc880,
    0x0, 0x0, 0xbb33, 0xc8a4, 0x0, 0x0, 0xbb33, 0xc8cc,
    0x0, 0x0, 0xbb33, 0xc8f5, 0x0, 0x0, 0xbb33, 0xc922,
    0x0, 0x0, 0xbb33, 0xc952, 0x0, 0x0, 0xbb33, 0xc986,
    0x0, 0x0, 0xbb33, 0xc9be, 0x0, 0x0, 0xbb33, 0xc9fa,
    0x0, 0x0, 0xbb33, 0xca3b, 0x0, 0x0, 0xbb33, 0xca82,
    0x0, 0x0, 0xbb33, 0xcad0, 0x0, 0x0, 0xbb33, 0xcb25,
    0x0, 0x0, 0xbb33, 0xcb83, 0x0, 0x0, 0xbb33, 0xcbec,
    0x0, 0x0, 0xbb33, 0xcc30, 0x0, 0x0, 0xbb33, 0xcc71,
    0x0, 0x0, 0xbb33, 0xccba, 0x0, 0x0, 0xbb33, 0xcd0e,
    0x0, 0x0, 0xbb33, 0xcd6e, 0x0, 0x0, 0xbb33, 0xcddd,
    0x0, 0x0, 0xbb33, 0xce60, 0x0, 0x0, 0xbb33, 0xcefb,
    0x0, 0x0, 0xbb33, 0xcfb8, 0x0, 0x0, 0xbb33, 0xd050,
    0x0, 0x0, 0xbb33, 0xd0e3, 0x0, 0x0, 0xbb33, 0xd1a4,
    0x0, 0x0, 0xbb33, 0xd2ab, 0x0, 0x0, 0xbb33, 0xd413,
    0x0, 0x0, 0xbb33, 0xd53d, 0x0, 0x0, 0xbb33, 0xd755,
    0x0, 0x0, 0xbb33, 0xda1d, 0x0, 0x0, 0xbb33, 0xe095
    };

static const uint16_t in_cfft_step_4096[8192] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0,
    0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0, 0x3b33, 0x0
    };

static const uint16_t in_cifft_step_4096[8192] = {
    0x6733, 0x0, 0xbb33, 0x6495, 0x0, 0x0, 0xbb33, 0x5e1d,
    0x0, 0x0, 0xbb33, 0x5b55, 0x0, 0x0, 0xbb33, 0x593d,
    0x0, 0x0, 0xbb33, 0x5813, 0x0, 0x0, 0xbb33, 0x56ab,
    0x0, 0x0, 0xbb33, 0x55a4, 0x0, 0x0, 0xbb33, 0x54e4,
    0x0, 0x0, 0xbb33, 0x5450, 0x0, 0x0, 0xbb33, 0x53b8,
    0x0, 0x0, 0xbb33, 0x52fc, 0x0, 0x0, 0xbb33, 0x5260,
    0x0, 0x0, 0xbb33, 0x51de, 0x0, 0x0, 0xbb33, 0x516f,
    0x0, 0x0, 0xbb33, 0x510f, 0x0, 0x0, 0xbb33, 0x50bb,
    0x0, 0x0, 0xbb33, 0x5072, 0x0, 0x0, 0xbb33, 0x5031,
    0x0, 0x0, 0xbb33, 0x4fed, 0x0, 0x0, 0xbb33, 0x4f85,
    0x0, 0x0, 0xbb33, 0x4f27, 0x0, 0x0, 0xbb33, 0x4ed2,
    0x0, 0x0, 0xbb33, 0x4e84, 0x0, 0x0, 0xbb33, 0x4e3d,
    0x0, 0x0, 0xbb33, 0x4dfc, 0x0, 0x0, 0xbb33, 0x4dc0,
    0x0, 0x0, 0xbb33, 0x4d88, 0x0, 0x0, 0xbb33, 0x4d55,
    0x0, 0x0, 0xbb33, 0x4d25, 0x0, 0x0, 0xbb33, 0x4cf8,
    0x0, 0x0, 0xbb33, 0x4cce, 0x0, 0x0, 0xbb33, 0x4ca7,
    0x0, 0x0, 0xbb33, 0x4c82, 0x0, 0x0, 0xbb33, 0x4c60,
    0x0, 0x0, 0xbb33, 0x4c3f, 0x0, 0x0, 0xbb33, 0x4c21,
    0x0, 0x0, 0xbb33, 0x4c04, 0x0, 0x0, 0xbb33, 0x4bd0,
    0x0, 0x0, 0xbb33, 0x4b9c, 0x0, 0x0, 0xbb33, 0x4b6b,
    0x0, 0x0, 0xbb33, 0x4b3c, 0x0, 0x0, 0xbb33, 0x4b0f,
    0x0, 0x0, 0xbb33, 0x4ae5, 0x0, 0x0, 0xbb33, 0x4abc,
    0x0, 0x0, 0xbb33, 0x4a95, 0x0, 0x0, 0xbb33, 0x4a70,
    0x0, 0x0, 0xbb33, 0x4a4c, 0x0, 0x0, 0xbb33, 0x4a2a,
    0x0, 0x0, 0xbb33, 0x4a0a, 0x0, 0x0, 0xbb33, 0x49ea,
    0x0, 0x0, 0xbb33, 0x49cc, 0x0, 0x0, 0xbb33, 0x49af,
    0x0, 0x0, 0xbb33, 0x4993, 0x0, 0x0, 0xbb33, 0x4979,
    0x0, 0x0, 0xbb33, 0x495f, 0x0, 0x0, 0xbb33, 0x4946,
    0x0, 0x0, 0xbb33, 0x492e, 0x0, 0x0, 0xbb33, 0x4917,
    0x0, 0x0, 0xbb33, 0x4900, 0x0, 0x0, 0xbb33, 0x48eb,
    0x0, 0x0, 0xbb33, 0x48d6, 0x0, 0x0, 0xbb33, 0x48c1,
    0x0, 0x0, 0xbb33, 0x48ae, 0x0, 0x0, 0xbb33, 0x489b,
    0x0, 0x0, 0xbb33, 0x4889, 0x0, 0x0, 0xbb33, 0x4877,
    0x0, 0x0, 0xbb33, 0x4865, 0x0, 0x0, 0xbb33, 0x4855,
    0x0, 0x0, 0xbb33, 0x4844, 0x0, 0x0, 0xbb33, 0x4834,
    0x0, 0x0, 0xbb33, 0x4825, 0x0, 0x0, 0xbb33, 0x4816,
    0x0, 0x0, 0xbb33, 0x4808, 0x0, 0x0, 0xbb33, 0x47f3,
    0x0, 0x0, 0xbb33, 0x47d7, 0x0, 0x0, 0xbb33, 0x47bc,
    0x0, 0x0, 0xbb33, 0x47a2, 0x0, 0x0, 0xbb33, 0x4789,
    0x0, 0x0, 0xbb33, 0x4770, 0x0, 0x0, 0xbb33, 0x4758,
    0x0, 0x0, 0xbb33, 0x4740, 0x0, 0x0, 0xbb33, 0x4729,
    0x0, 0x0, 0xbb33, 0x4713, 0x0, 0x0, 0xbb33, 0x46fd,
    0x0, 0x0, 0xbb33, 0x46e8, 0x0, 0x0, 0xbb33, 0x46d3,
    0x0, 0x0, 0xbb33, 0x46be, 0x0, 0x0, 0xbb33, 0x46aa,
    0x0, 0x0, 0xbb33, 0x4697, 0x0, 0x0, 0xbb33, 0x4684,
    0x0, 0x0, 0xbb33, 0x4671, 0x0, 0x0, 0xbb33, 0x465f,
    0x0, 0x0, 0xbb33, 0x464d, 0x0, 0x0, 0xbb33, 0x463b,
    0x0, 0x0, 0xbb33, 0x462a, 0x0, 0x0, 0xbb33, 0x4619,
    0x0, 0x0, 0xbb33, 0x4609, 0x0, 0x0, 0xbb33, 0x45f9,
    0x0, 0x0, 0xbb33, 0x45e9, 0x0, 0x0, 0xbb33, 0x45da,
    0x0, 0x0, 0xbb33, 0x45cb, 0x0, 0x0, 0xbb33, 0x45bc,
    0x0, 0x0, 0xbb33, 0x45ad, 0x0, 0x0, 0xbb33, 0x459f,
    0x0, 0x0, 0xbb33, 0x4591, 0x0, 0x0, 0xbb33, 0x4583,
    0x0, 0x0, 0xbb33, 0x4576, 0x0, 0x0, 0xbb33, 0x4568,
    0x0, 0x0, 0xbb33, 0x455c, 0x0, 0x0, 0xbb33, 0x454f,
    0x0, 0x0, 0xbb33, 0x4542, 0x0, 0x0, 0xbb33, 0x4536,
    0x0, 0x0, 0xbb33, 0x452a, 0x0, 0x0, 0xbb33, 0x451e,
    0x0, 0x0, 0xbb33, 0x4512, 0x0, 0x0, 0xbb33, 0x4507,
    0x0, 0x0, 0xbb33, 0x44fb, 0x0, 0x0, 0xbb33, 0x44f0,
    0x0, 0x0, 0xbb33, 0x44e5, 0x0, 0x0, 0xbb33, 0x44db,
    0x0, 0x0, 0xbb33, 0x44d0, 0x0, 0x0, 0xbb33, 0x44c6,
    0x0, 0x0, 0xbb33, 0x44bc, 0x0, 0x0, 0xbb33, 0x44b2,
    0x0, 0x0, 0xbb33, 0x44a8, 0x0, 0x0, 0xbb33, 0x449e,
    0x0, 0x0, 0xbb33, 0x4494, 0x0, 0x0, 0xbb33, 0x448b,
    0x0, 0x0, 0xbb33, 0x4482, 0x0, 0x0, 0xbb33, 0x4479,
    0x0, 0x0, 0xbb33, 0x4470, 0x0, 0x0, 0xbb33, 0x4467,
    0x0, 0x0, 0xbb33, 0x445e, 0x0, 0x0, 0xbb33, 0x4455,
    0x0, 0x0, 0xbb33, 0x444d, 0x0, 0x0, 0xbb33, 0x4444,
    0x0, 0x0, 0xbb33, 0x443c, 0x0, 0x0, 0xbb33, 0x4434,
    0x0, 0x0, 0xbb33, 0x442c, 0x0, 0x0, 0xbb33, 0x4424,
    0x0, 0x0, 0xbb33, 0x441c, 0x0, 0x0, 0xbb33, 0x4415,
    0x0, 0x0, 0xbb33, 0x440d, 0x0, 0x0, 0xbb33, 0x4406,
    0x0, 0x0, 0xbb33, 0x43fd, 0x0, 0x0, 0xbb33, 0x43ee,
    0x0, 0x0, 0xbb33, 0x43e0, 0x0, 0x0, 0xbb33, 0x43d2,
    0x0, 0x0, 0xbb33, 0x43c4, 0x0, 0x0, 0xbb33, 0x43b6,
    0x0, 0x0, 0xbb33, 0x43a8, 0x0, 0x0, 0xbb33, 0x439b,
    0x0, 0x0, 0xbb33, 0x438e, 0x0, 0x0, 0xbb33, 0x4381,
    0x0, 0x0, 0xbb33, 0x4374, 0x0, 0x0, 0xbb33, 0x4367,
    0x0, 0x0, 0xbb33, 0x435a, 0x0, 0x0, 0xbb33, 0x434e,
    0x0, 0x0, 0xbb33, 0x4342, 0x0, 0x0, 0xbb33, 0x4336,
    0x0, 0x0, 0xbb33, 0x432a, 0x0, 0x0, 0xbb33, 0x431e,
    0x0, 0x0, 0xbb33, 0x4312, 0x0, 0x0, 0xbb33, 0x4307,
    0x0, 0x0, 0xbb33, 0x42fb, 0x0, 0x0, 0xbb33, 0x42f0,
    0x0, 0x0, 0xbb33, 0x42e5, 0x0, 0x0, 0xbb33, 0x42da,
    0x0, 0x0, 0xbb33, 0x42cf, 0x0, 0x0, 0xbb33, 0x42c4,
    0x0, 0x0, 0xbb33, 0x42b9, 0x0, 0x0, 0xbb33, 0x42af,
    0x0, 0x0, 0xbb33, 0x42a5, 0x0, 0x0, 0xbb33, 0x429a,
    0x0, 0x0, 0xbb33, 0x4290, 0x0, 0x0, 0xbb33, 0x4286,
    0x0, 0x0, 0xbb33, 0x427c, 0x0, 0x0, 0xbb33, 0x4272,
    0x0, 0x0, 0xbb33, 0x4269, 0x0, 0x0, 0xbb33, 0x425f,
    0x0, 0x0, 0xbb33, 0x4255, 0x0, 0x0, 0xbb33, 0x424c,
    0x0, 0x0, 0xbb33, 0x4243, 0x0, 0x0, 0xbb33, 0x423a,
    0x0, 0x0, 0xbb33, 0x4230, 0x0, 0x0, 0xbb33, 0x4227,
    0x0, 0x0, 0xbb33, 0x421f, 0x0, 0x0, 0xbb33, 0x4216,
    0x0, 0x0, 0xbb33, 0x420d, 0x0, 0x0, 0xbb33, 0x4204,
    0x0, 0x0, 0xbb33, 0x41fc, 0x0, 0x0, 0xbb33, 0x41f3,
    0x0, 0x0, 0xbb33, 0x41eb, 0x0, 0x0, 0xbb33, 0x41e3,
    0x0, 0x0, 0xbb33, 0x41da, 0x0, 0x0, 0xbb33, 0x41d2,
    0x0, 0x0, 0xbb33, 0x41ca, 0x0, 0x0, 0xbb33, 0x41c2,
    0x0, 0x0, 0xbb33, 0x41ba, 0x0, 0x0, 0xbb33, 0x41b2,
    0x0, 0x0, 0xbb33, 0x41ab, 0x0, 0x0, 0xbb33, 0x41a3,
    0x0, 0x0, 0xbb33, 0x419b, 0x0, 0x0, 0xbb33, 0x4194,
    0x0, 0x0, 0xbb33, 0x418c, 0x0, 0x0, 0xbb33, 0x4185,
    0x0, 0x0, 0xbb33, 0x417e, 0x0, 0x0, 0xbb33, 0x4176,
    0x0, 0x0, 0xbb33, 0x416f, 0x0, 0x0, 0xbb33, 0x4168,
    0x0, 0x0, 0xbb33, 0x4161, 0x0, 0x0, 0xbb33, 0x415a,
    0x0, 0x0, 0xbb33, 0x4153, 0x0, 0x0, 0xbb33, 0x414c,
    0x0, 0x0, 0xbb33, 0x4146, 0x0, 0x0, 0xbb33, 0x413f,
    0x0, 0x0, 0xbb33, 0x4138, 0x0, 0x0, 0xbb33, 0x4131,
    0x0, 0x0, 0xbb33, 0x412b, 0x0, 0x0, 0xbb33, 0x4124,
    0x0, 0x0, 0xbb33, 0x411e, 0x0, 0x0, 0xbb33, 0x4118,
    0x0, 0x0, 0xbb33, 0x4111, 0x0, 0x0, 0xbb33, 0x410b,
    0x0, 0x0, 0xbb33, 0x4105, 0x0, 0x0, 0xbb33, 0x40ff,
    0x0, 0x0, 0xbb33, 0x40f8, 0x0, 0x0, 0xbb33, 0x40f2,
    0x0, 0x0, 0xbb33, 0x40ec, 0x0, 0x0, 0xbb33, 0x40e6,
    0x0, 0x0, 0xbb33, 0x40e0, 0x0, 0x0, 0xbb33, 0x40db,
    0x0, 0x0, 0xbb33, 0x40d5, 0x0, 0x0, 0xbb33, 0x40cf,
    0x0, 0x0, 0xbb33, 0x40c9, 0x0, 0x0, 0xbb33, 0x40c4,
    0x0, 0x0, 0xbb33, 0x40be, 0x0, 0x0, 0xbb33, 0x40b8,
    0x0, 0x0, 0xbb33, 0x40b3, 0x0, 0x0, 0xbb33, 0x40ad,
    0x0, 0x0, 0xbb33, 0x40a8, 0x0, 0x0, 0xbb33, 0x40a2,
    0x0, 0x0, 0xbb33, 0x409d, 0x0, 0x0, 0xbb33, 0x4098,
    0x0, 0x0, 0xbb33, 0x4092, 0x0, 0x0, 0xbb33, 0x408d,
    0x0, 0x0, 0xbb33, 0x4088, 0x0, 0x0, 0xbb33, 0x4083,
    0x0, 0x0, 0xbb33, 0x407e, 0x0, 0x0, 0xbb33, 0x4079,
    0x0, 0x0, 0xbb33, 0x4074, 0x0, 0x0, 0xbb33, 0x406f,
    0x0, 0x0, 0xbb33, 0x406a, 0x0, 0x0, 0xbb33, 0x4065,
    0x0, 0x0, 0xbb33, 0x4060, 0x0, 0x0, 0xbb33, 0x405b,
    0x0, 0x0, 0xbb33, 0x4056, 0x0, 0x0, 0xbb33, 0x4051,
    0x0, 0x0, 0xbb33, 0x404d, 0x0, 0x0, 0xbb33, 0x4048,
    0x0, 0x0, 0xbb33, 0x4043, 0x0, 0x0, 0xbb33, 0x403e,
    0x0, 0x0, 0xbb33, 0x403a, 0x0, 0x0, 0xbb33, 0x4035,
    0x0, 0x0, 0xbb33, 0x4031, 0x0, 0x0, 0xbb33, 0x402c,
    0x0, 0x0, 0xbb33, 0x4028, 0x0, 0x0, 0xbb33, 0x4023,
    0x0, 0x0, 0xbb33, 0x401f, 0x0, 0x0, 0xbb33, 0x401a,
    0x0, 0x0, 0xbb33, 0x4016, 0x0, 0x0, 0xbb33, 0x4012,
    0x0, 0x0, 0xbb33, 0x400d, 0x0, 0x0, 0xbb33, 0x4009,
    0x0, 0x0, 0xbb33, 0x4005, 0x0, 0x0, 0xbb33, 0x4001,
    0x0, 0x0, 0xbb33, 0x3ff9, 0x0, 0x0, 0xbb33, 0x3ff1,
    0x0, 0x0, 0xbb33, 0x3fe8, 0x0, 0x0, 0xbb33, 0x3fe0,
    0x0, 0x0, 0xbb33, 0x3fd8, 0x0, 0x0, 0xbb33, 0x3fd0,
    0x0, 0x0, 0xbb33, 0x3fc8, 0x0, 0x0, 0xbb33, 0x3fc0,
    0x0, 0x0, 0xbb33, 0x3fb8, 0x0, 0x0, 0xbb33, 0x3fb0,
    0x0, 0x0, 0xbb33, 0x3fa8, 0x0, 0x0, 0xbb33, 0x3fa0,
    0x0, 0x0, 0xbb33, 0x3f99, 0x0, 0x0, 0xbb33, 0x3f91,
    0x0, 0x0, 0xbb33, 0x3f89, 0x0, 0x0, 0xbb33, 0x3f82,
    0x0, 0x0, 0xbb33, 0x3f7a, 0x0, 0x0, 0xbb33, 0x3f73,
    0x0, 0x0, 0xbb33, 0x3f6b, 0x0, 0x0, 0xbb33, 0x3f64,
    0x0, 0x0, 0xbb33, 0x3f5d, 0x0, 0x0, 0xbb33, 0x3f55,
    0x0, 0x0, 0xbb33, 0x3f4e, 0x0, 0x0, 0xbb33, 0x3f47,
    0x0, 0x0, 0xbb33, 0x3f40, 0x0, 0x0, 0xbb33, 0x3f39,
    0x0, 0x0, 0xbb33, 0x3f31, 0x0, 0x0, 0xbb33, 0x3f2a,
    0x0, 0x0, 0xbb33, 0x3f23, 0x0, 0x0, 0xbb33, 0x3f1c,
    0x0, 0x0, 0xbb33, 0x3f16, 0x0, 0x0, 0xbb33, 0x3f0f,
    0x0, 0x0, 0xbb33, 0x3f08, 0x0, 0x0, 0xbb33, 0x3f01,
    0x0, 0x0, 0xbb33, 0x3efa, 0x0, 0x0, 0xbb33, 0x3ef4,
    0x0, 0x0, 0xbb33, 0x3eed, 0x0, 0x0, 0xbb33, 0x3ee6,
    0x0, 0x0, 0xbb33, 0x3ee0, 0x0, 0x0, 0xbb33, 0x3ed9,
    0x0, 0x0, 0xbb33, 0x3ed3, 0x0, 0x0, 0xbb33, 0x3ecc,
    0x0, 0x0, 0xbb33, 0x3ec6, 0x0, 0x0, 0xbb33, 0x3ebf,
    0x0, 0x0, 0xbb33, 0x3eb9, 0x0, 0x0, 0xbb33, 0x3eb3,
    0x0, 0x0, 0xbb33, 0x3eac, 0x0, 0x0, 0xbb33, 0x3ea6,
    0x0, 0x0, 0xbb33, 0x3ea0, 0x0, 0x0, 0xbb33, 0x3e9a,
    0x0, 0x0, 0xbb33, 0x3e94, 0x0, 0x0, 0xbb33, 0x3e8d,
    0x0, 0x0, 0xbb33, 0x3e87, 0x0, 0x0, 0xbb33, 0x3e81,
    0x0, 0x0, 0xbb33, 0x3e7b, 0x0, 0x0, 0xbb33, 0x3e75,
    0x0, 0x0, 0xbb33, 0x3e6f, 0x0, 0x0, 0xbb33, 0x3e69,
    0x0, 0x0, 0xbb33, 0x3e64, 0x0, 0x0, 0xbb33, 0x3e5e,
    0x0, 0x0, 0xbb33, 0x3e58, 0x0, 0x0, 0xbb33, 0x3e52,
    0x0, 0x0, 0xbb33, 0x3e4c, 0x0, 0x0, 0xbb33, 0x3e47,
    0x0, 0x0, 0xbb33, 0x3e41, 0x0, 0x0, 0xbb33, 0x3e3b,
    0x0, 0x0, 0xbb33, 0x3e36, 0x0, 0x0, 0xbb33, 0x3e30,
    0x0, 0x0, 0xbb33, 0x3e2b, 0x0, 0x0, 0xbb33, 0x3e25,
    0x0, 0x0, 0xbb33, 0x3e1f, 0x0, 0x0, 0xbb33, 0x3e1a,
    0x0, 0x0, 0xbb33, 0x3e14, 0x0, 0x0, 0xbb33, 0x3e0f,
    0x0, 0x0, 0xbb33, 0x3e0a, 0x0, 0x0, 0xbb33, 0x3e04,
    0x0, 0x0, 0xbb33, 0x3dff, 0x0, 0x0, 0xbb33, 0x3dfa,
    0x0, 0x0, 0xbb33, 0x3df4, 0x0, 0x0, 0xbb33, 0x3def,
    0x0, 0x0, 0xbb33, 0x3dea, 0x0, 0x0, 0xbb33, 0x3de5,
    0x0, 0x0, 0xbb33, 0x3ddf, 0x0, 0x0, 0xbb33, 0x3dda,
    0x0, 0x0, 0xbb33, 0x3dd5, 0x0, 0x0, 0xbb33, 0x3dd0,
    0x0, 0x0, 0xbb33, 0x3dcb, 0x0, 0x0, 0xbb33, 0x3dc6,
    0x0, 0x0, 0xbb33, 0x3dc1, 0x0, 0x0, 0xbb33, 0x3dbc,
    0x0, 0x0, 0xbb33, 0x3db7, 0x0, 0x0, 0xbb33, 0x3db2,
    0x0, 0x0, 0xbb33, 0x3dad, 0x0, 0x0, 0xbb33, 0x3da8,
    0x0, 0x0, 0xbb33, 0x3da3, 0x0, 0x0, 0xbb33, 0x3d9e,
    0x0, 0x0, 0xbb33, 0x3d99, 0x0, 0x0, 0xbb33, 0x3d95,
    0x0, 0x0, 0xbb33, 0x3d90, 0x0, 0x0, 0xbb33, 0x3d8b,
    0x0, 0x0, 0xbb33, 0x3d86, 0x0, 0x0, 0xbb33, 0x3d81,
    0x0, 0x0, 0xbb33, 0x3d7d, 0x0, 0x0, 0xbb33, 0x3d78,
    0x0, 0x0, 0xbb33, 0x3d73, 0x0, 0x0, 0xbb33, 0x3d6f,
    0x0, 0x0, 0xbb33, 0x3d6a, 0x0, 0x0, 0xbb33, 0x3d66,
    0x0, 0x0, 0xbb33, 0x3d61, 0x0, 0x0, 0xbb33, 0x3d5c,
    0x0, 0x0, 0xbb33, 0x3d58, 0x0, 0x0, 0xbb33, 0x3d53,
    0x0, 0x0, 0xbb33, 0x3d4f, 0x0, 0x0, 0xbb33, 0x3d4a,
    0x0, 0x0, 0xbb33, 0x3d46, 0x0, 0x0, 0xbb33, 0x3d42,
    0x0, 0x0, 0xbb33, 0x3d3d, 0x0, 0x0, 0xbb33, 0x3d39,
    0x0, 0x0, 0xbb33, 0x3d34, 0x0, 0x0, 0xbb33, 0x3d30,
    0x0, 0x0, 0xbb33, 0x3d2c, 0x0, 0x0, 0xbb33, 0x3d27,
    0x0, 0x0, 0xbb33, 0x3d23, 0x0, 0x0, 0xbb33, 0x3d1f,
    0x0, 0x0, 0xbb33, 0x3d1a, 0x0, 0x0, 0xbb33, 0x3d16,
    0x0, 0x0, 0xbb33, 0x3d12, 0x0, 0x0, 0xbb33, 0x3d0e,
    0x0, 0x0, 0xbb33, 0x3d0a, 0x0, 0x0, 0xbb33, 0x3d05,
    0x0, 0x0, 0xbb33, 0x3d01, 0x0, 0x0, 0xbb33, 0x3cfd,
    0x0, 0x0, 0xbb33, 0x3cf9, 0x0, 0x0, 0xbb33, 0x3cf5,
    0x0, 0x0, 0xbb33, 0x3cf1, 0x0, 0x0, 0xbb33, 0x3ced,
    0x0, 0x0, 0xbb33, 0x3ce9, 0x0, 0x0, 0xbb33, 0x3ce5,
    0x0, 0x0, 0xbb33, 0x3ce1, 0x0, 0x0, 0xbb33, 0x3cdd,
    0x0, 0x0, 0xbb33, 0x3cd9, 0x0, 0x0, 0xbb33, 0x3cd5,
    0x0, 0x0, 0xbb33, 0x3cd1, 0x0, 0x0, 0xbb33, 0x3ccd,
    0x0, 0x0, 0xbb33, 0x3cc9, 0x0, 0x0, 0xbb33, 0x3cc5,
    0x0, 0x0, 0xbb33, 0x3cc1, 0x0, 0x0, 0xbb33, 0x3cbd,
    0x0, 0x0, 0xbb33, 0x3cb9, 0x0, 0x0, 0xbb33, 0x3cb6,
    0x0, 0x0, 0xbb33, 0x3cb2, 0x0, 0x0, 0xbb33, 0x3cae,
    0x0, 0x0, 0xbb33, 0x3caa, 0x0, 0x0, 0xbb33, 0x3ca6,
    0x0, 0x0, 0xbb33, 0x3ca3, 0x0, 0x0, 0xbb33, 0x3c9f,
    0x0, 0x0, 0xbb33, 0x3c9b, 0x0, 0x0, 0xbb33, 0x3c97,
    0x0, 0x0, 0xbb33, 0x3c94, 0x0, 0x0, 0xbb33, 0x3c90,
    0x0, 0x0, 0xbb33, 0x3c8c, 0x0, 0x0, 0xbb33, 0x3c89,
    0x0, 0x0, 0xbb33, 0x3c85, 0x0, 0x0, 0xbb33, 0x3c81,
    0x0, 0x0, 0xbb33, 0x3c7e, 0x0, 0x0, 0xbb33, 0x3c7a,
    0x0, 0x0, 0xbb33, 0x3c76, 0x0, 0x0, 0xbb33, 0x3c73,
    0x0, 0x0, 0xbb33, 0x3c6f, 0x0, 0x0, 0xbb33, 0x3c6c,
    0x0, 0x0, 0xbb33, 0x3c68, 0x0, 0x0, 0xbb33, 0x3c65,
    0x0, 0x0, 0xbb33, 0x3c61, 0x0, 0x0, 0xbb33, 0x3c5e,
    0x0, 0x0, 0xbb33, 0x3c5a, 0x0, 0x0, 0xbb33, 0x3c57,
    0x0, 0x0, 0xbb33, 0x3c53, 0x0, 0x0, 0xbb33, 0x3c50,
    0x0, 0x0, 0xbb33, 0x3c4c, 0x0, 0x0, 0xbb33, 0x3c49,
    0x0, 0x0, 0xbb33, 0x3c46, 0x0, 0x0, 0xbb33, 0x3c42,
    0x0, 0x0, 0xbb33, 0x3c3f, 0x0, 0x0, 0xbb33, 0x3c3b,
    0x0, 0x0, 0xbb33, 0x3c38, 0x0, 0x0, 0xbb33, 0x3c35,
    0x0, 0x0, 0xbb33, 0x3c31, 0x0, 0x0, 0xbb33, 0x3c2e,
    0x0, 0x0, 0xbb33, 0x3c2b, 0x0, 0x0, 0xbb33, 0x3c27,
    0x0, 0x0, 0xbb33, 0x3c24, 0x0, 0x0, 0xbb33, 0x3c21,
    0x0, 0x0, 0xbb33, 0x3c1e, 0x0, 0x0, 0xbb33, 0x3c1a,
    0x0, 0x0, 0xbb33, 0x3c17, 0x0, 0x0, 0xbb33, 0x3c14,
    0x0, 0x0, 0xbb33, 0x3c11, 0x0, 0x0, 0xbb33, 0x3c0d,
    0x0, 0x0, 0xbb33, 0x3c0a, 0x0, 0x0, 0xbb33, 0x3c07,
    0x0, 0x0, 0xbb33, 0x3c04, 0x0, 0x0, 0xbb33, 0x3c01,
    0x0, 0x0, 0xbb33, 0x3bfb, 0x0, 0x0, 0xbb33, 0x3bf5,
    0x0, 0x0, 0xbb33, 0x3bef, 0x0, 0x0, 0xbb33, 0x3be8,
    0x0, 0x0, 0xbb33, 0x3be2, 0x0, 0x0, 0xbb33, 0x3bdc,
    0x0, 0x0, 0xbb33, 0x3bd6, 0x0, 0x0, 0xbb33, 0x3bcf,
    0x0, 0x0, 0xbb33, 0x3bc9, 0x0, 0x0, 0xbb33, 0x3bc3,
    0x0, 0x0, 0xbb33, 0x3bbd, 0x0, 0x0, 0xbb33, 0x3bb7,
    0x0, 0x0, 0xbb33, 0x3bb1, 0x0, 0x0, 0xbb33, 0x3bab,
    0x0, 0x0, 0xbb33, 0x3ba5, 0x0, 0x0, 0xbb33, 0x3b9f,
    0x0, 0x0, 0xbb33, 0x3b99, 0x0, 0x0, 0xbb33, 0x3b93,
    0x0, 0x0, 0xbb33, 0x3b8d, 0x0, 0x0, 0xbb33, 0x3b87,
    0x0, 0x0, 0xbb33, 0x3b81, 0x0, 0x0, 0xbb33, 0x3b7b,
    0x0, 0x0, 0xbb33, 0x3b75, 0x0, 0x0, 0xbb33, 0x3b70,
    0x0, 0x0, 0xbb33, 0x3b6a, 0x0, 0x0, 0xbb33, 0x3b64,
    0x0, 0x0, 0xbb33, 0x3b5e, 0x0, 0x0, 0xbb33, 0x3b58,
    0x0, 0x0, 0xbb33, 0x3b53, 0x0, 0x0, 0xbb33, 0x3b4d,
    0x0, 0x0, 0xbb33, 0x3b47, 0x0, 0x0, 0xbb33, 0x3b41,
    0x0, 0x0, 0xbb33, 0x3b3c, 0x0, 0x0, 0xbb33, 0x3b36,
    0x0, 0x0, 0xbb33, 0x3b30, 0x0, 0x0, 0xbb33, 0x3b2b,
    0x0, 0x0, 0xbb33, 0x3b25, 0x0, 0x0, 0xbb33, 0x3b20,
    0x0, 0x0, 0xbb33, 0x3b1a, 0x0, 0x0, 0xbb33, 0x3b14,
    0x0, 0x0, 0xbb33, 0x3b0f, 0x0, 0x0, 0xbb33, 0x3b09,
    0x0, 0x0, 0xbb33, 0x3b04, 0x0, 0x0, 0xbb33, 0x3afe,
    0x0, 0x0, 0xbb33, 0x3af9, 0x0, 0x0, 0xbb33, 0x3af3,
    0x0, 0x0, 0xbb33, 0x3aee, 0x0, 0x0, 0xbb33, 0x3ae8,
    0x0, 0x0, 0xbb33, 0x3ae3, 0x0, 0x0, 0xbb33, 0x3ade,
    0x0, 0x0, 0xbb33, 0x3ad8, 0x0, 0x0, 0xbb33, 0x3ad3,
    0x0, 0x0, 0xbb33, 0x3acd, 0x0, 0x0, 0xbb33, 0x3ac8,
    0x0, 0x0, 0xbb33, 0x3ac3, 0x0, 0x0, 0xbb33, 0x3abd,
    0x0, 0x0, 0xbb33, 0x3ab8, 0x0, 0x0, 0xbb33, 0x3ab3,
    0x0, 0x0, 0xbb33, 0x3aae, 0x0, 0x0, 0xbb33, 0x3aa8,
    0x0, 0x0, 0xbb33, 0x3aa3, 0x0, 0x0, 0xbb33, 0x3a9e,
    0x0, 0x0, 0xbb33, 0x3a99, 0x0, 0x0, 0xbb33, 0x3a93,
    0x0, 0x0, 0xbb33, 0x3a8e, 0x0, 0x0, 0xbb33, 0x3a89,
    0x0, 0x0, 0xbb33, 0x3a84, 0x0, 0x0, 0xbb33, 0x3a7f,
    0x0, 0x0, 0xbb33, 0x3a7a, 0x0, 0x0, 0xbb33, 0x3a75,
    0x0, 0x0, 0xbb33, 0x3a70, 0x0, 0x0, 0xbb33, 0x3a6a,
    0x0, 0x0, 0xbb33, 0x3a65, 0x0, 0x0, 0xbb33, 0x3a60,
    0x0, 0x0, 0xbb33, 0x3a5b, 0x0, 0x0, 0xbb33, 0x3a56,
    0x0, 0x0, 0xbb33, 0x3a51, 0x0, 0x0, 0xbb33, 0x3a4c,
    0x0, 0x0, 0xbb33, 0x3a47, 0x0, 0x0, 0xbb33, 0x3a42,
    0x0, 0x0, 0xbb33, 0x3a3d, 0x0, 0x0, 0xbb33, 0x3a38,
    0x0, 0x0, 0xbb33, 0x3a33, 0x0, 0x0, 0xbb33, 0x3a2f,
    0x0, 0x0, 0xbb33, 0x3a2a, 0x0, 0x0, 0xbb33, 0x3a25,
    0x0, 0x0, 0xbb33, 0x3a20, 0x0, 0x0, 0xbb33, 0x3a1b,
    0x0, 0x0, 0xbb33, 0x3a16, 0x0, 0x0, 0xbb33, 0x3a11,
    0x0, 0x0, 0xbb33, 0x3a0d, 0x0, 0x0, 0xbb33, 0x3a08,
    0x0, 0x0, 0xbb33, 0x3a03, 0x0, 0x0, 0xbb33, 0x39fe,
    0x0, 0x0, 0xbb33, 0x39f9, 0x0, 0x0, 0xbb33, 0x39f5,
    0x0, 0x0, 0xbb33, 0x39f0, 0x0, 0x0, 0xbb33, 0x39eb,
    0x0, 0x0, 0xbb33, 0x39e6, 0x0, 0x0, 0xbb33, 0x39e2,
    0x0, 0x0, 0xbb33, 0x39dd, 0x0, 0x0, 0xbb33, 0x39d8,
    0x0, 0x0, 0xbb33, 0x39d4, 0x0, 0x0, 0xbb33, 0x39cf,
    0x0, 0x0, 0xbb33, 0x39ca, 0x0, 0x0, 0xbb33, 0x39c6,
    0x0, 0x0, 0xbb33, 0x39c1, 0x0, 0x0, 0xbb33, 0x39bc,
    0x0, 0x0, 0xbb33, 0x39b8, 0x0, 0x0, 0xbb33, 0x39b3,
    0x0, 0x0, 0xbb33, 0x39ae, 0x0, 0x0, 0xbb33, 0x39aa,
    0x0, 0x0, 0xbb33, 0x39a5, 0x0, 0x0, 0xbb33, 0x39a1,
    0x0, 0x0, 0xbb33, 0x399c, 0x0, 0x0, 0xbb33, 0x3998,
    0x0, 0x0, 0xbb33, 0x3993, 0x0, 0x0, 0xbb33, 0x398f,
    0x0, 0x0, 0xbb33, 0x398a, 0x0, 0x0, 0xbb33, 0x3986,
    0x0, 0x0, 0xbb33, 0x3981, 0x0, 0x0, 0xbb33, 0x397d,
    0x0, 0x0, 0xbb33, 0x3978, 0x0, 0x0, 0xbb33, 0x3974,
    0x0, 0x0, 0xbb33, 0x396f, 0x0, 0x0, 0xbb33, 0x396b,
    0x0, 0x0, 0xbb33, 0x3966, 0x0, 0x0, 0xbb33, 0x3962,
    0x0, 0x0, 0xbb33, 0x395e, 0x0, 0x0, 0xbb33, 0x3959,
    0x0, 0x0, 0xbb33, 0x3955, 0x0, 0x0, 0xbb33, 0x3950,
    0x0, 0x0, 0xbb33, 0x394c, 0x0, 0x0, 0xbb33, 0x3948,
    0x0, 0x0, 0xbb33, 0x3943, 0x0, 0x0, 0xbb33, 0x393f,
    0x0, 0x0, 0xbb33, 0x393b, 0x0, 0x0, 0xbb33, 0x3936,
    0x0, 0x0, 0xbb33, 0x3932, 0x0, 0x0, 0xbb33, 0x392e,
    0x0, 0x0, 0xbb33, 0x392a, 0x0, 0x0, 0xbb33, 0x3925,
    0x0, 0x0, 0xbb33, 0x3921, 0x0, 0x0, 0xbb33, 0x391d,
    0x0, 0x0, 0xbb33, 0x3918, 0x0, 0x0, 0xbb33, 0x3914,
    0x0, 0x0, 0xbb33, 0x3910, 0x0, 0x0, 0xbb33, 0x390c,
    0x0, 0x0, 0xbb33, 0x3908, 0x0, 0x0, 0xbb33, 0x3903,
    0x0, 0x0, 0xbb33, 0x38ff, 0x0, 0x0, 0xbb33, 0x38fb,
    0x0, 0x0, 0xbb33, 0x38f7, 0x0, 0x0, 0xbb33, 0x38f3,
    0x0, 0x0, 0xbb33, 0x38ee, 0x0, 0x0, 0xbb33, 0x38ea,
    0x0, 0x0, 0xbb33, 0x38e6, 0x0, 0x0, 0xbb33, 0x38e2,
    0x0, 0x0, 0xbb33, 0x38de, 0x0, 0x0, 0xbb33, 0x38da,
    0x0, 0x0, 0xbb33, 0x38d6, 0x0, 0x0, 0xbb33, 0x38d2,
    0x0, 0x0, 0xbb33, 0x38ce, 0x0, 0x0, 0xbb33, 0x38c9,
    0x0, 0x0, 0xbb33, 0x38c5, 0x0, 0x0, 0xbb33, 0x38c1,
    0x0, 0x0, 0xbb33, 0x38bd, 0x0, 0x0, 0xbb33, 0x38b9,
    0x0, 0x0, 0xbb33, 0x38b5, 0x0, 0x0, 0xbb33, 0x38b1,
    0x0, 0x0, 0xbb33, 0x38ad, 0x0, 0x0, 0xbb33, 0x38a9,
    0x0, 0x0, 0xbb33, 0x38a5, 0x0, 0x0, 0xbb33, 0x38a1,
    0x0, 0x0, 0xbb33, 0x389d, 0x0, 0x0, 0xbb33, 0x3899,
    0x0, 0x0, 0xbb33, 0x3895, 0x0, 0x0, 0xbb33, 0x3891,
    0x0, 0x0, 0xbb33, 0x388d, 0x0, 0x0, 0xbb33, 0x3889,
    0x0, 0x0, 0xbb33, 0x3885, 0x0, 0x0, 0xbb33, 0x3881,
    0x0, 0x0, 0xbb33, 0x387d, 0x0, 0x0, 0xbb33, 0x387a,
    0x0, 0x0, 0xbb33, 0x3876, 0x0, 0x0, 0xbb33, 0x3872,
    0x0, 0x0, 0xbb33, 0x386e, 0x0, 0x0, 0xbb33, 0x386a,
    0x0, 0x0, 0xbb33, 0x3866, 0x0, 0x0, 0xbb33, 0x3862,
    0x0, 0x0, 0xbb33, 0x385e, 0x0, 0x0, 0xbb33, 0x385a,
    0x0, 0x0, 0xbb33, 0x3857, 0x0, 0x0, 0xbb33, 0x3853,
    0x0, 0x0, 0xbb33, 0x384f, 0x0, 0x0, 0xbb33, 0x384b,
    0x0, 0x0, 0xbb33, 0x3847, 0x0, 0x0, 0xbb33, 0x3843,
    0x0, 0x0, 0xbb33, 0x3840, 0x0, 0x0, 0xbb33, 0x383c,
    0x0, 0x0, 0xbb33, 0x3838, 0x0, 0x0, 0xbb33, 0x3834,
    0x0, 0x0, 0xbb33, 0x3830, 0x0, 0x0, 0xbb33, 0x382d,
    0x0, 0x0, 0xbb33, 0x3829, 0x0, 0x0, 0xbb33, 0x3825,
    0x0, 0x0, 0xbb33, 0x3821, 0x0, 0x0, 0xbb33, 0x381e,
    0x0, 0x0, 0xbb33, 0x381a, 0x0, 0x0, 0xbb33, 0x3816,
    0x0, 0x0, 0xbb33, 0x3812, 0x0, 0x0, 0xbb33, 0x380f,
    0x0, 0x0, 0xbb33, 0x380b, 0x0, 0x0, 0xbb33, 0x3807,
    0x0, 0x0, 0xbb33, 0x3803, 0x0, 0x0, 0xbb33, 0x37ff,
    0x0, 0x0, 0xbb33, 0x37f8, 0x0, 0x0, 0xbb33, 0x37f1,
    0x0, 0x0, 0xbb33, 0x37e9, 0x0, 0x0, 0xbb33, 0x37e2,
    0x0, 0x0, 0xbb33, 0x37db, 0x0, 0x0, 0xbb33, 0x37d3,
    0x0, 0x0, 0xbb33, 0x37cc, 0x0, 0x0, 0xbb33, 0x37c5,
    0x0, 0x0, 0xbb33, 0x37bd, 0x0, 0x0, 0xbb33, 0x37b6,
    0x0, 0x0, 0xbb33, 0x37af, 0x0, 0x0, 0xbb33, 0x37a8,
    0x0, 0x0, 0xbb33, 0x37a0, 0x0, 0x0, 0xbb33, 0x3799,
    0x0, 0x0, 0xbb33, 0x3792, 0x0, 0x0, 0xbb33, 0x378b,
    0x0, 0x0, 0xbb33, 0x3783, 0x0, 0x0, 0xbb33, 0x377c,
    0x0, 0x0, 0xbb33, 0x3775, 0x0, 0x0, 0xbb33, 0x376e,
    0x0, 0x0, 0xbb33, 0x3767, 0x0, 0x0, 0xbb33, 0x3760,
    0x0, 0x0, 0xbb33, 0x3758, 0x0, 0x0, 0xbb33, 0x3751,
    0x0, 0x0, 0xbb33, 0x374a, 0x0, 0x0, 0xbb33, 0x3743,
    0x0, 0x0, 0xbb33, 0x373c, 0x0, 0x0, 0xbb33, 0x3735,
    0x0, 0x0, 0xbb33, 0x372e, 0x0, 0x0, 0xbb33, 0x3727,
    0x0, 0x0, 0xbb33, 0x3720, 0x0, 0x0, 0xbb33, 0x3719,
    0x0, 0x0, 0xbb33, 0x3712, 0x0, 0x0, 0xbb33, 0x370b,
    0x0, 0x0, 0xbb33, 0x3704, 0x0, 0x0, 0xbb33, 0x36fd,
    0x0, 0x0, 0xbb33, 0x36f6, 0x0, 0x0, 0xbb33, 0x36ef,
    0x0, 0x0, 0xbb33, 0x36e8, 0x0, 0x0, 0xbb33, 0x36e1,
    0x0, 0x0, 0xbb33, 0x36da, 0x0, 0x0, 0xbb33, 0x36d3,
    0x0, 0x0, 0xbb33, 0x36cc, 0x0, 0x0, 0xbb33, 0x36c5,
    0x0, 0x0, 0xbb33, 0x36be, 0x0, 0x0, 0xbb33, 0x36b7,
    0x0, 0x0, 0xbb33, 0x36b0, 0x0, 0x0, 0xbb33, 0x36aa,
    0x0, 0x0, 0xbb33, 0x36a3, 0x0, 0x0, 0xbb33, 0x369c,
    0x0, 0x0, 0xbb33, 0x3695, 0x0, 0x0, 0xbb33, 0x368e,
    0x0, 0x0, 0xbb33, 0x3687, 0x0, 0x0, 0xbb33, 0x3681,
    0x0, 0x0, 0xbb33, 0x367a, 0x0, 0x0, 0xbb33, 0x3673,
    0x0, 0x0, 0xbb33, 0x366c, 0x0, 0x0, 0xbb33, 0x3665,
    0x0, 0x0, 0xbb33, 0x365f, 0x0, 0x0, 0xbb33, 0x3658,
    0x0, 0x0, 0xbb33, 0x3651, 0x0, 0x0, 0xbb33, 0x364a,
    0x0, 0x0, 0xbb33, 0x3644, 0x0, 0x0, 0xbb33, 0x363d,
    0x0, 0x0, 0xbb33, 0x3636, 0x0, 0x0, 0xbb33, 0x3630,
    0x0, 0x0, 0xbb33, 0x3629, 0x0, 0x0, 0xbb33, 0x3622,
    0x0, 0x0, 0xbb33, 0x361c, 0x0, 0x0, 0xbb33, 0x3615,
    0x0, 0x0, 0xbb33, 0x360e, 0x0, 0x0, 0xbb33, 0x3608,
    0x0, 0x0, 0xbb33, 0x3601, 0x0, 0x0, 0xbb33, 0x35fa,
    0x0, 0x0, 0xbb33, 0x35f4, 0x0, 0x0, 0xbb33, 0x35ed,
    0x0, 0x0, 0xbb33, 0x35e6, 0x0, 0x0, 0xbb33, 0x35e0,
    0x0, 0x0, 0xbb33, 0x35d9, 0x0, 0x0, 0xbb33, 0x35d3,
    0x0, 0x0, 0xbb33, 0x35cc, 0x0, 0x0, 0xbb33, 0x35c6,
    0x0, 0x0, 0xbb33, 0x35bf, 0x0, 0x0, 0xbb33, 0x35b8,
    0x0, 0x0, 0xbb33, 0x35b2, 0x0, 0x0, 0xbb33, 0x35ab,
    0x0, 0x0, 0xbb33, 0x35a5, 0x0, 0x0, 0xbb33, 0x359e,
    0x0, 0x0, 0xbb33, 0x3598, 0x0, 0x0, 0xbb33, 0x3591,
    0x0, 0x0, 0xbb33, 0x358b, 0x0, 0x0, 0xbb33, 0x3584,
    0x0, 0x0, 0xbb33, 0x357e, 0x0, 0x0, 0xbb33, 0x3577,
    0x0, 0x0, 0xbb33, 0x3571, 0x0, 0x0, 0xbb33, 0x356a,
    0x0, 0x0, 0xbb33, 0x3564, 0x0, 0x0, 0xbb33, 0x355d,
    0x0, 0x0, 0xbb33, 0x3557, 0x0, 0x0, 0xbb33, 0x3551,
    0x0, 0x0, 0xbb33, 0x354a, 0x0, 0x0, 0xbb33, 0x3544,
    0x0, 0x0, 0xbb33, 0x353d, 0x0, 0x0, 0xbb33, 0x3537,
    0x0, 0x0, 0xbb33, 0x3531, 0x0, 0x0, 0xbb33, 0x352a,
    0x0, 0x0, 0xbb33, 0x3524, 0x0, 0x0, 0xbb33, 0x351d,
    0x0, 0x0, 0xbb33, 0x3517, 0x0, 0x0, 0xbb33, 0x3511,
    0x0, 0x0, 0xbb33, 0x350a, 0x0, 0x0, 0xbb33, 0x3504,
    0x0, 0x0, 0xbb33, 0x34fe, 0x0, 0x0, 0xbb33, 0x34f7,
    0x0, 0x0, 0xbb33, 0x34f1, 0x0, 0x0, 0xbb33, 0x34eb,
    0x0, 0x0, 0xbb33, 0x34e4, 0x0, 0x0, 0xbb33, 0x34de,
    0x0, 0x0, 0xbb33, 0x34d8, 0x0, 0x0, 0xbb33, 0x34d2,
    0x0, 0x0, 0xbb33, 0x34cb, 0x0, 0x0, 0xbb33, 0x34c5,
    0x0, 0x0, 0xbb33, 0x34bf, 0x0, 0x0, 0xbb33, 0x34b8,
    0x0, 0x0, 0xbb33, 0x34b2, 0x0, 0x0, 0xbb33, 0x34ac,
    0x0, 0x0, 0xbb33, 0x34a6, 0x0, 0x0, 0xbb33, 0x349f,
    0x0, 0x0, 0xbb33, 0x3499, 0x0, 0x0, 0xbb33, 0x3493,
    0x0, 0x0, 0xbb33, 0x348d, 0x0, 0x0, 0xbb33, 0x3487,
    0x0, 0x0, 0xbb33, 0x3480, 0x0, 0x0, 0xbb33, 0x347a,
    0x0, 0x0, 0xbb33, 0x3474, 0x0, 0x0, 0xbb33, 0x346e,
    0x0, 0x0, 0xbb33, 0x3468, 0x0, 0x0, 0xbb33, 0x3461,
    0x0, 0x0, 0xbb33, 0x345b, 0x0, 0x0, 0xbb33, 0x3455,
    0x0, 0x0, 0xbb33, 0x344f, 0x0, 0x0, 0xbb33, 0x3449,
    0x0, 0x0, 0xbb33, 0x3443, 0x0, 0x0, 0xbb33, 0x343c,
    0x0, 0x0, 0xbb33, 0x3436, 0x0, 0x0, 0xbb33, 0x3430,
    0x0, 0x0, 0xbb33, 0x342a, 0x0, 0x0, 0xbb33, 0x3424,
    0x0, 0x0, 0xbb33, 0x341e, 0x0, 0x0, 0xbb33, 0x3418,
    0x0, 0x0, 0xbb33, 0x3412, 0x0, 0x0, 0xbb33, 0x340b,
    0x0, 0x0, 0xbb33, 0x3405, 0x0, 0x0, 0xbb33, 0x33fe,
    0x0, 0x0, 0xbb33, 0x33f2, 0x0, 0x0, 0xbb33, 0x33e6,
    0x0, 0x0, 0xbb33, 0x33da, 0x0, 0x0, 0xbb33, 0x33ce,
    0x0, 0x0, 0xbb33, 0x33c2, 0x0, 0x0, 0xbb33, 0x33b6,
    0x0, 0x0, 0xbb33, 0x33a9, 0x0, 0x0, 0xbb33, 0x339d,
    0x0, 0x0, 0xbb33, 0x3391, 0x0, 0x0, 0xbb33, 0x3385,
    0x0, 0x0, 0xbb33, 0x3379, 0x0, 0x0, 0xbb33, 0x336d,
    0x0, 0x0, 0xbb33, 0x3361, 0x0, 0x0, 0xbb33, 0x3355,
    0x0, 0x0, 0xbb33, 0x3349, 0x0, 0x0, 0xbb33, 0x333d,
    0x0, 0x0, 0xbb33, 0x3331, 0x0, 0x0, 0xbb33, 0x3325,
    0x0, 0x0, 0xbb33, 0x3319, 0x0, 0x0, 0xbb33, 0x330d,
    0x0, 0x0, 0xbb33, 0x3301, 0x0, 0x0, 0xbb33, 0x32f5,
    0x0, 0x0, 0xbb33, 0x32e9, 0x0, 0x0, 0xbb33, 0x32dd,
    0x0, 0x0, 0xbb33, 0x32d1, 0x0, 0x0, 0xbb33, 0x32c5,
    0x0, 0x0, 0xbb33, 0x32b9, 0x0, 0x0, 0xbb33, 0x32ad,
    0x0, 0x0, 0xbb33, 0x32a1, 0x0, 0x0, 0xbb33, 0x3295,
    0x0, 0x0, 0xbb33, 0x3289, 0x0, 0x0, 0xbb33, 0x327e,
    0x0, 0x0, 0xbb33, 0x3272, 0x0, 0x0, 0xbb33, 0x3266,
    0x0, 0x0, 0xbb33, 0x325a, 0x0, 0x0, 0xbb33, 0x324e,
    0x0, 0x0, 0xbb33, 0x3242, 0x0, 0x0, 0xbb33, 0x3236,
    0x0, 0x0, 0xbb33, 0x322b, 0x0, 0x0, 0xbb33, 0x321f,
    0x0, 0x0, 0xbb33, 0x3213, 0x0, 0x0, 0xbb33, 0x3207,
    0x0, 0x0, 0xbb33, 0x31fb, 0x0, 0x0, 0xbb33, 0x31f0,
    0x0, 0x0, 0xbb33, 0x31e4, 0x0, 0x0, 0xbb33, 0x31d8,
    0x0, 0x0, 0xbb33, 0x31cc, 0x0, 0x0, 0xbb33, 0x31c0,
    0x0, 0x0, 0xbb33, 0x31b5, 0x0, 0x0, 0xbb33, 0x31a9,
    0x0, 0x0, 0xbb33, 0x319d, 0x0, 0x0, 0xbb33, 0x3191,
    0x0, 0x0, 0xbb33, 0x3186, 0x0, 0x0, 0xbb33, 0x317a,
    0x0, 0x0, 0xbb33, 0x316e, 0x0, 0x0, 0xbb33, 0x3163,
    0x0, 0x0, 0xbb33, 0x3157, 0x0, 0x0, 0xbb33, 0x314b,
    0x0, 0x0, 0xbb33, 0x313f, 0x0, 0x0, 0xbb33, 0x3134,
    0x0, 0x0, 0xbb33, 0x3128, 0x0, 0x0, 0xbb33, 0x311c,
    0x0, 0x0, 0xbb33, 0x3111, 0x0, 0x0, 0xbb33, 0x3105,
    0x0, 0x0, 0xbb33, 0x30f9, 0x0, 0x0, 0xbb33, 0x30ee,
    0x0, 0x0, 0xbb33, 0x30e2, 0x0, 0x0, 0xbb33, 0x30d7,
    0x0, 0x0, 0xbb33, 0x30cb, 0x0, 0x0, 0xbb33, 0x30bf,
    0x0, 0x0, 0xbb33, 0x30b4, 0x0, 0x0, 0xbb33, 0x30a8,
    0x0, 0x0, 0xbb33, 0x309c, 0x0, 0x0, 0xbb33, 0x3091,
    0x0, 0x0, 0xbb33, 0x3085, 0x0, 0x0, 0xbb33, 0x307a,
    0x0, 0x0, 0xbb33, 0x306e, 0x0, 0x0, 0xbb33, 0x3063,
    0x0, 0x0, 0xbb33, 0x3057, 0x0, 0x0, 0xbb33, 0x304b,
    0x0, 0x0, 0xbb33, 0x3040, 0x0, 0x0, 0xbb33, 0x3034,
    0x0, 0x0, 0xbb33, 0x3029, 0x0, 0x0, 0xbb33, 0x301d,
    0x0, 0x0, 0xbb33, 0x3012, 0x0, 0x0, 0xbb33, 0x3006,
    0x0, 0x0, 0xbb33, 0x2ff5, 0x0, 0x0, 0xbb33, 0x2fde,
    0x0, 0x0, 0xbb33, 0x2fc7, 0x0, 0x0, 0xbb33, 0x2fb0,
    0x0, 0x0, 0xbb33, 0x2f99, 0x0, 0x0, 0xbb33, 0x2f82,
    0x0, 0x0, 0xbb33, 0x2f6b, 0x0, 0x0, 0xbb33, 0x2f54,
    0x0, 0x0, 0xbb33, 0x2f3d, 0x0, 0x0, 0xbb33, 0x2f26,
    0x0, 0x0, 0xbb33, 0x2f0f, 0x0, 0x0, 0xbb33, 0x2ef8,
    0x0, 0x0, 0xbb33, 0x2ee1, 0x0, 0x0, 0xbb33, 0x2eca,
    0x0, 0x0, 0xbb33, 0x2eb3, 0x0, 0x0, 0xbb33, 0x2e9d,
    0x0, 0x0, 0xbb33, 0x2e86, 0x0, 0x0, 0xbb33, 0x2e6f,
    0x0, 0x0, 0xbb33, 0x2e58, 0x0, 0x0, 0xbb33, 0x2e41,
    0x0, 0x0, 0xbb33, 0x2e2a, 0x0, 0x0, 0xbb33, 0x2e13,
    0x0, 0x0, 0xbb33, 0x2dfc, 0x0, 0x0, 0xbb33, 0x2de5,
    0x0, 0x0, 0xbb33, 0x2dcf, 0x0, 0x0, 0xbb33, 0x2db8,
    0x0, 0x0, 0xbb33, 0x2da1, 0x0, 0x0, 0xbb33, 0x2d8a,
    0x0, 0x0, 0xbb33, 0x2d73, 0x0, 0x0, 0xbb33, 0x2d5c,
    0x0, 0x0, 0xbb33, 0x2d46, 0x0, 0x0, 0xbb33, 0x2d2f,
    0x0, 0x0, 0xbb33, 0x2d18, 0x0, 0x0, 0xbb33, 0x2d01,
    0x0, 0x0, 0xbb33, 0x2cea, 0x0, 0x0, 0xbb33, 0x2cd4,
    0x0, 0x0, 0xbb33, 0x2cbd, 0x0, 0x0, 0xbb33, 0x2ca6,
    0x0, 0x0, 0xbb33, 0x2c8f, 0x0, 0x0, 0xbb33, 0x2c79,
    0x0, 0x0, 0xbb33, 0x2c62, 0x0, 0x0, 0xbb33, 0x2c4b,
    0x0, 0x0, 0xbb33, 0x2c34, 0x0, 0x0, 0xbb33, 0x2c1e,
    0x0, 0x0, 0xbb33, 0x2c07, 0x0, 0x0, 0xbb33, 0x2be0,
    0x0, 0x0, 0xbb33, 0x2bb3, 0x0, 0x0, 0xbb33, 0x2b85,
    0x0, 0x0, 0xbb33, 0x2b58, 0x0, 0x0, 0xbb33, 0x2b2b,
    0x0, 0x0, 0xbb33, 0x2afd, 0x0, 0x0, 0xbb33, 0x2ad0,
    0x0, 0x0, 0xbb33, 0x2aa2, 0x0, 0x0, 0xbb33, 0x2a75,
    0x0, 0x0, 0xbb33, 0x2a48, 0x0, 0x0, 0xbb33, 0x2a1a,
    0x0, 0x0, 0xbb33, 0x29ed, 0x0, 0x0, 0xbb33, 0x29bf,
    0x0, 0x0, 0xbb33, 0x2992, 0x0, 0x0, 0xbb33, 0x2965,
    0x0, 0x0, 0xbb33, 0x2937, 0x0, 0x0, 0xbb33, 0x290a,
    0x0, 0x0, 0xbb33, 0x28dd, 0x0, 0x0, 0xbb33, 0x28af,
    0x0, 0x0, 0xbb33, 0x2882, 0x0, 0x0, 0xbb33, 0x2855,
    0x0, 0x0, 0xbb33, 0x2828, 0x0, 0x0, 0xbb33, 0x27f5,
    0x0, 0x0, 0xbb33, 0x279a, 0x0, 0x0, 0xbb33, 0x273f,
    0x0, 0x0, 0xbb33, 0x26e5, 0x0, 0x0, 0xbb33, 0x268a,
    0x0, 0x0, 0xbb33, 0x2630, 0x0, 0x0, 0xbb33, 0x25d5,
    0x0, 0x0, 0xbb33, 0x257b, 0x0, 0x0, 0xbb33, 0x2520,
    0x0, 0x0, 0xbb33, 0x24c6, 0x0, 0x0, 0xbb33, 0x246b,
    0x0, 0x0, 0xbb33, 0x2411, 0x0, 0x0, 0xbb33, 0x236c,
    0x0, 0x0, 0xbb33, 0x22b7, 0x0, 0x0, 0xbb33, 0x2202,
    0x0, 0x0, 0xbb33, 0x214d, 0x0, 0x0, 0xbb33, 0x2098,
    0x0, 0x0, 0xbb33, 0x1fc7, 0x0, 0x0, 0xbb33, 0x1e5d,
    0x0, 0x0, 0xbb33, 0x1cf3, 0x0, 0x0, 0xbb33, 0x1b12,
    0x0, 0x0, 0xbb33, 0x183e, 0x0, 0x0, 0xbb33, 0x11a8,
    0x0, 0x0, 0xbb33, 0x91a8, 0x0, 0x0, 0xbb33, 0x983e,
    0x0, 0x0, 0xbb33, 0x9b12, 0x0, 0x0, 0xbb33, 0x9cf3,
    0x0, 0x0, 0xbb33, 0x9e5d, 0x0, 0x0, 0xbb33, 0x9fc7,
    0x0, 0x0, 0xbb33, 0xa098, 0x0, 0x0, 0xbb33, 0xa14d,
    0x0, 0x0, 0xbb33, 0xa202, 0x0, 0x0, 0xbb33, 0xa2b7,
    0x0, 0x0, 0xbb33, 0xa36c, 0x0, 0x0, 0xbb33, 0xa411,
    0x0, 0x0, 0xbb33, 0xa46b, 0x0, 0x0, 0xbb33, 0xa4c6,
    0x0, 0x0, 0xbb33, 0xa520, 0x0, 0x0, 0xbb33, 0xa57b,
    0x0, 0x0, 0xbb33, 0xa5d5, 0x0, 0x0, 0xbb33, 0xa630,
    0x0, 0x0, 0xbb33, 0xa68a, 0x0, 0x0, 0xbb33, 0xa6e5,
    0x0, 0x0, 0xbb33, 0xa73f, 0x0, 0x0, 0xbb33, 0xa79a,
    0x0, 0x0, 0xbb33, 0xa7f5, 0x0, 0x0, 0xbb33, 0xa828,
    0x0, 0x0, 0xbb33, 0xa855, 0x0, 0x0, 0xbb33, 0xa882,
    0x0, 0x0, 0xbb33, 0xa8af, 0x0, 0x0, 0xbb33, 0xa8dd,
    0x0, 0x0, 0xbb33, 0xa90a, 0x0, 0x0, 0xbb33, 0xa937,
    0x0, 0x0, 0xbb33, 0xa965, 0x0, 0x0, 0xbb33, 0xa992,
    0x0, 0x0, 0xbb33, 0xa9bf, 0x0, 0x0, 0xbb33, 0xa9ed,
    0x0, 0x0, 0xbb33, 0xaa1a, 0x0, 0x0, 0xbb33, 0xaa48,
    0x0, 0x0, 0xbb33, 0xaa75, 0x0, 0x0, 0xbb33, 0xaaa2,
    0x0, 0x0, 0xbb33, 0xaad0, 0x0, 0x0, 0xbb33, 0xaafd,
    0x0, 0x0, 0xbb33, 0xab2b, 0x0, 0x0, 0xbb33, 0xab58,
    0x0, 0x0, 0xbb33, 0xab85, 0x0, 0x0, 0xbb33, 0xabb3,
    0x0, 0x0, 0xbb33, 0xabe0, 0x0, 0x0, 0xbb33, 0xac07,
    0x0, 0x0, 0xbb33, 0xac1e, 0x0, 0x0, 0xbb33, 0xac34,
    0x0, 0x0, 0xbb33, 0xac4b, 0x0, 0x0, 0xbb33, 0xac62,
    0x0, 0x0, 0xbb33, 0xac79, 0x0, 0x0, 0xbb33, 0xac8f,
    0x0, 0x0, 0xbb33, 0xaca6, 0x0, 0x0, 0xbb33, 0xacbd,
    0x0, 0x0, 0xbb33, 0xacd4, 0x0, 0x0, 0xbb33, 0xacea,
    0x0, 0x0, 0xbb33, 0xad01, 0x0, 0x0, 0xbb33, 0xad18,
    0x0, 0x0, 0xbb33, 0xad2f, 0x0, 0x0, 0xbb33, 0xad46,
    0x0, 0x0, 0xbb33, 0xad5c, 0x0, 0x0, 0xbb33, 0xad73,
    0x0, 0x0, 0xbb33, 0xad8a, 0x0, 0x0, 0xbb33, 0xada1,
    0x0, 0x0, 0xbb33, 0xadb8, 0x0, 0x0, 0xbb33, 0xadcf,
    0x0, 0x0, 0xbb33, 0xade5, 0x0, 0x0, 0xbb33, 0xadfc,
    0x0, 0x0, 0xbb33, 0xae13, 0x0, 0x0, 0xbb33, 0xae2a,
    0x0, 0x0, 0xbb33, 0xae41, 0x0, 0x0, 0xbb33, 0xae58,
    0x0, 0x0, 0xbb33, 0xae6f, 0x0, 0x0, 0xbb33, 0xae86,
    0x0, 0x0, 0xbb33, 0xae9d, 0x0, 0x0, 0xbb33, 0xaeb3,
    0x0, 0x0, 0xbb33, 0xaeca, 0x0, 0x0, 0xbb33, 0xaee1,
    0x0, 0x0, 0xbb33, 0xaef8, 0x0, 0x0, 0xbb33, 0xaf0f,
    0x0, 0x0, 0xbb33, 0xaf26, 0x0, 0x0, 0xbb33, 0xaf3d,
    0x0, 0x0, 0xbb33, 0xaf54, 0x0, 0x0, 0xbb33, 0xaf6b,
    0x0, 0x0, 0xbb33, 0xaf82, 0x0, 0x0, 0xbb33, 0xaf99,
    0x0, 0x0, 0xbb33, 0xafb0, 0x0, 0x0, 0xbb33, 0xafc7,
    0x0, 0x0, 0xbb33, 0xafde, 0x0, 0x0, 0xbb33, 0xaff5,
    0x0, 0x0, 0xbb33, 0xb006, 0x0, 0x0, 0xbb33, 0xb012,
    0x0, 0x0, 0xbb33, 0xb01d, 0x0, 0x0, 0xbb33, 0xb029,
    0x0, 0x0, 0xbb33, 0xb034, 0x0, 0x0, 0xbb33, 0xb040,
    0x0, 0x0, 0xbb33, 0xb04b, 0x0, 0x0, 0xbb33, 0xb057,
    0x0, 0x0, 0xbb33, 0xb063, 0x0, 0x0, 0xbb33, 0xb06e,
    0x0, 0x0, 0xbb33, 0xb07a, 0x0, 0x0, 0xbb33, 0xb085,
    0x0, 0x0, 0xbb33, 0xb091, 0x0, 0x0, 0xbb33, 0xb09c,
    0x0, 0x0, 0xbb33, 0xb0a8, 0x0, 0x0, 0xbb33, 0xb0b4,
    0x0, 0x0, 0xbb33, 0xb0bf, 0x0, 0x0, 0xbb33, 0xb0cb,
    0x0, 0x0, 0xbb33, 0xb0d7, 0x0, 0x0, 0xbb33, 0xb0e2,
    0x0, 0x0, 0xbb33, 0xb0ee, 0x0, 0x0, 0xbb33, 0xb0f9,
    0x0, 0x0, 0xbb33, 0xb105, 0x0, 0x0, 0xbb33, 0xb111,
    0x0, 0x0, 0xbb33, 0xb11c, 0x0, 0x0, 0xbb33, 0xb128,
    0x0, 0x0, 0xbb33, 0xb134, 0x0, 0x0, 0xbb33, 0xb13f,
    0x0, 0x0, 0xbb33, 0xb14b, 0x0, 0x0, 0xbb33, 0xb157,
    0x0, 0x0, 0xbb33, 0xb163, 0x0, 0x0, 0xbb33, 0xb16e,
    0x0, 0x0, 0xbb33, 0xb17a, 0x0, 0x0, 0xbb33, 0xb186,
    0x0, 0x0, 0xbb33, 0xb191, 0x0, 0x0, 0xbb33, 0xb19d,
    0x0, 0x0, 0xbb33, 0xb1a9, 0x0, 0x0, 0xbb33, 0xb1b5,
    0x0, 0x0, 0xbb33, 0xb1c0, 0x0, 0x0, 0xbb33, 0xb1cc,
    0x0, 0x0, 0xbb33, 0xb1d8, 0x0, 0x0, 0xbb33, 0xb1e4,
    0x0, 0x0, 0xbb33, 0xb1f0, 0x0, 0x0, 0xbb33, 0xb1fb,
    0x0, 0x0, 0xbb33, 0xb207, 0x0, 0x0, 0xbb33, 0xb213,
    0x0, 0x0, 0xbb33, 0xb21f, 0x0, 0x0, 0xbb33, 0xb22b,
    0x0, 0x0, 0xbb33, 0xb236, 0x0, 0x0, 0xbb33, 0xb242,
    0x0, 0x0, 0xbb33, 0xb24e, 0x0, 0x0, 0xbb33, 0xb25a,
    0x0, 0x0, 0xbb33, 0xb266, 0x0, 0x0, 0xbb33, 0xb272,
    0x0, 0x0, 0xbb33, 0xb27e, 0x0, 0x0, 0xbb33, 0xb289,
    0x0, 0x0, 0xbb33, 0xb295, 0x0, 0x0, 0xbb33, 0xb2a1,
    0x0, 0x0, 0xbb33, 0xb2ad, 0x0, 0x0, 0xbb33, 0xb2b9,
    0x0, 0x0, 0xbb33, 0xb2c5, 0x0, 0x0, 0xbb33, 0xb2d1,
    0x0, 0x0, 0xbb33, 0xb2dd, 0x0, 0x0, 0xbb33, 0xb2e9,
    0x0, 0x0, 0xbb33, 0xb2f5, 0x0, 0x0, 0xbb33, 0xb301,
    0x0, 0x0, 0xbb33, 0xb30d, 0x0, 0x0, 0xbb33, 0xb319,
    0x0, 0x0, 0xbb33, 0xb325, 0x0, 0x0, 0xbb33, 0xb331,
    0x0, 0x0, 0xbb33, 0xb33d, 0x0, 0x0, 0xbb33, 0xb349,
    0x0, 0x0, 0xbb33, 0xb355, 0x0, 0x0, 0xbb33, 0xb361,
    0x0, 0x0, 0xbb33, 0xb36d, 0x0, 0x0, 0xbb33, 0xb379,
    0x0, 0x0, 0xbb33, 0xb385, 0x0, 0x0, 0xbb33, 0xb391,
    0x0, 0x0, 0xbb33, 0xb39d, 0x0, 0x0, 0xbb33, 0xb3a9,
    0x0, 0x0, 0xbb33, 0xb3b6, 0x0, 0x0, 0xbb33, 0xb3c2,
    0x0, 0x0, 0xbb33, 0xb3ce, 0x0, 0x0, 0xbb33, 0xb3da,
    0x0, 0x0, 0xbb33, 0xb3e6, 0x0, 0x0, 0xbb33, 0xb3f2,
    0x0, 0x0, 0xbb33, 0xb3fe, 0x0, 0x0, 0xbb33, 0xb405,
    0x0, 0x0, 0xbb33, 0xb40b, 0x0, 0x0, 0xbb33, 0xb412,
    0x0, 0x0, 0xbb33, 0xb418, 0x0, 0x0, 0xbb33, 0xb41e,
    0x0, 0x0, 0xbb33, 0xb424, 0x0, 0x0, 0xbb33, 0xb42a,
    0x0, 0x0, 0xbb33, 0xb430, 0x0, 0x0, 0xbb33, 0xb436,
    0x0, 0x0, 0xbb33, 0xb43c, 0x0, 0x0, 0xbb33, 0xb443,
    0x0, 0x0, 0xbb33, 0xb449, 0x0, 0x0, 0xbb33, 0xb44f,
    0x0, 0x0, 0xbb33, 0xb455, 0x0, 0x0, 0xbb33, 0xb45b,
    0x0, 0x0, 0xbb33, 0xb461, 0x0, 0x0, 0xbb33, 0xb468,
    0x0, 0x0, 0xbb33, 0xb46e, 0x0, 0x0, 0xbb33, 0xb474,
    0x0, 0x0, 0xbb33, 0xb47a, 0x0, 0x0, 0xbb33, 0xb480,
    0x0, 0x0, 0xbb33, 0xb487, 0x0, 0x0, 0xbb33, 0xb48d,
    0x0, 0x0, 0xbb33, 0xb493, 0x0, 0x0, 0xbb33, 0xb499,
    0x0, 0x0, 0xbb33, 0xb49f, 0x0, 0x0, 0xbb33, 0xb4a6,
    0x0, 0x0, 0xbb33, 0xb4ac, 0x0, 0x0, 0xbb33, 0xb4b2,
    0x0, 0x0, 0xbb33, 0xb4b8, 0x0, 0x0, 0xbb33, 0xb4bf,
    0x0, 0x0, 0xbb33, 0xb4c5, 0x0, 0x0, 0xbb33, 0xb4cb,
    0x0, 0x0, 0xbb33, 0xb4d2, 0x0, 0x0, 0xbb33, 0xb4d8,
    0x0, 0x0, 0xbb33, 0xb4de, 0x0, 0x0, 0xbb33, 0xb4e4,
    0x0, 0x0, 0xbb33, 0xb4eb, 0x0, 0x0, 0xbb33, 0xb4f1,
    0x0, 0x0, 0xbb33, 0xb4f7, 0x0, 0x0, 0xbb33, 0xb4fe,
    0x0, 0x0, 0xbb33, 0xb504, 0x0, 0x0, 0xbb33, 0xb50a,
    0x0, 0x0, 0xbb33, 0xb511, 0x0, 0x0, 0xbb33, 0xb517,
    0x0, 0x0, 0xbb33, 0xb51d, 0x0, 0x0, 0xbb33, 0xb524,
    0x0, 0x0, 0xbb33, 0xb52a, 0x0, 0x0, 0xbb33, 0xb531,
    0x0, 0x0, 0xbb33, 0xb537, 0x0, 0x0, 0xbb33, 0xb53d,
    0x0, 0x0, 0xbb33, 0xb544, 0x0, 0x0, 0xbb33, 0xb54a,
    0x0, 0x0, 0xbb33, 0xb551, 0x0, 0x0, 0xbb33, 0xb557,
    0x0, 0x0, 0xbb33, 0xb55d, 0x0, 0x0, 0xbb33, 0xb564,
    0x0, 0x0, 0xbb33, 0xb56a, 0x0, 0x0, 0xbb33, 0xb571,
    0x0, 0x0, 0xbb33, 0xb577, 0x0, 0x0, 0xbb33, 0xb57e,
    0x0, 0x0, 0xbb33, 0xb584, 0x0, 0x0, 0xbb33, 0xb58b,
    0x0, 0x0, 0xbb33, 0xb591, 0x0, 0x0, 0xbb33, 0xb598,
    0x0, 0x0, 0xbb33, 0xb59e, 0x0, 0x0, 0xbb33, 0xb5a5,
    0x0, 0x0, 0xbb33, 0xb5ab, 0x0, 0x0, 0xbb33, 0xb5b2,
    0x0, 0x0, 0xbb33, 0xb5b8, 0x0, 0x0, 0xbb33, 0xb5bf,
    0x0, 0x0, 0xbb33, 0xb5c6, 0x0, 0x0, 0xbb33, 0xb5cc,
    0x0, 0x0, 0xbb33, 0xb5d3, 0x0, 0x0, 0xbb33, 0xb5d9,
    0x0, 0x0, 0xbb33, 0xb5e0, 0x0, 0x0, 0xbb33, 0xb5e6,
    0x0, 0x0, 0xbb33, 0xb5ed, 0x0, 0x0, 0xbb33, 0xb5f4,
    0x0, 0x0, 0xbb33, 0xb5fa, 0x0, 0x0, 0xbb33, 0xb601,
    0x0, 0x0, 0xbb33, 0xb608, 0x0, 0x0, 0xbb33, 0xb60e,
    0x0, 0x0, 0xbb33, 0xb615, 0x0, 0x0, 0xbb33, 0xb61c,
    0x0, 0x0, 0xbb33, 0xb622, 0x0, 0x0, 0xbb33, 0xb629,
    0x0, 0x0, 0xbb33, 0xb630, 0x0, 0x0, 0xbb33, 0xb636,
    0x0, 0x0, 0xbb33, 0xb63d, 0x0, 0x0, 0xbb33, 0xb644,
    0x0, 0x0, 0xbb33, 0xb64a, 0x0, 0x0, 0xbb33, 0xb651,
    0x0, 0x0, 0xbb33, 0xb658, 0x0, 0x0, 0xbb33, 0xb65f,
    0x0, 0x0, 0xbb33, 0xb665, 0x0, 0x0, 0xbb33, 0xb66c,
    0x0, 0x0, 0xbb33, 0xb673, 0x0, 0x0, 0xbb33, 0xb67a,
    0x0, 0x0, 0xbb33, 0xb681, 0x0, 0x0, 0xbb33, 0xb687,
    0x0, 0x0, 0xbb33, 0xb68e, 0x0, 0x0, 0xbb33, 0xb695,
    0x0, 0x0, 0xbb33, 0xb69c, 0x0, 0x0, 0xbb33, 0xb6a3,
    0x0, 0x0, 0xbb33, 0xb6aa, 0x0, 0x0, 0xbb33, 0xb6b0,
    0x0, 0x0, 0xbb33, 0xb6b7, 0x0, 0x0, 0xbb33, 0xb6be,
    0x0, 0x0, 0xbb33, 0xb6c5, 0x0, 0x0, 0xbb33, 0xb6cc,
    0x0, 0x0, 0xbb33, 0xb6d3, 0x0, 0x0, 0xbb33, 0xb6da,
    0x0, 0x0, 0xbb33, 0xb6e1, 0x0, 0x0, 0xbb33, 0xb6e8,
    0x0, 0x0, 0xbb33, 0xb6ef, 0x0, 0x0, 0xbb33, 0xb6f6,
    0x0, 0x0, 0xbb33, 0xb6fd, 0x0, 0x0, 0xbb33, 0xb704,
    0x0, 0x0, 0xbb33, 0xb70b, 0x0, 0x0, 0xbb33, 0xb712,
    0x0, 0x0, 0xbb33, 0xb719, 0x0, 0x0, 0xbb33, 0xb720,
    0x0, 0x0, 0xbb33, 0xb727, 0x0, 0x0, 0xbb33, 0xb72e,
    0x0, 0x0, 0xbb33, 0xb735, 0x0, 0x0, 0xbb33, 0xb73c,
    0x0, 0x0, 0xbb33, 0xb743, 0x0, 0x0, 0xbb33, 0xb74a,
    0x0, 0x0, 0xbb33, 0xb751, 0x0, 0x0, 0xbb33, 0xb758,
    0x0, 0x0, 0xbb33, 0xb760, 0x0, 0x0, 0xbb33, 0xb767,
    0x0, 0x0, 0xbb33, 0xb76e, 0x0, 0x0, 0xbb33, 0xb775,
    0x0, 0x0, 0xbb33, 0xb77c, 0x0, 0x0, 0xbb33, 0xb783,
    0x0, 0x0, 0xbb33, 0xb78b, 0x0, 0x0, 0xbb33, 0xb792,
    0x0, 0x0, 0xbb33, 0xb799, 0x0, 0x0, 0xbb33, 0xb7a0,
    0x0, 0x0, 0xbb33, 0xb7a8, 0x0, 0x0, 0xbb33, 0xb7af,
    0x0, 0x0, 0xbb33, 0xb7b6, 0x0, 0x0, 0xbb33, 0xb7bd,
    0x0, 0x0, 0xbb33, 0xb7c5, 0x0, 0x0, 0xbb33, 0xb7cc,
    0x0, 0x0, 0xbb33, 0xb7d3, 0x0, 0x0, 0xbb33, 0xb7db,
    0x0, 0x0, 0xbb33, 0xb7e2, 0x0, 0x0, 0xbb33, 0xb7e9,
    0x0, 0x0, 0xbb33, 0xb7f1, 0x0, 0x0, 0xbb33, 0xb7f8,
    0x0, 0x0, 0xbb33, 0xb7ff, 0x0, 0x0, 0xbb33, 0xb803,
    0x0, 0x0, 0xbb33, 0xb807, 0x0, 0x0, 0xbb33, 0xb80b,
    0x0, 0x0, 0xbb33, 0xb80f, 0x0, 0x0, 0xbb33, 0xb812,
    0x0, 0x0, 0xbb33, 0xb816, 0x0, 0x0, 0xbb33, 0xb81a,
    0x0, 0x0, 0xbb33, 0xb81e, 0x0, 0x0, 0xbb33, 0xb821,
    0x0, 0x0, 0xbb33, 0xb825, 0x0, 0x0, 0xbb33, 0xb829,
    0x0, 0x0, 0xbb33, 0xb82d, 0x0, 0x0, 0xbb33, 0xb830,
    0x0, 0x0, 0xbb33, 0xb834, 0x0, 0x0, 0xbb33, 0xb838,
    0x0, 0x0, 0xbb33, 0xb83c, 0x0, 0x0, 0xbb33, 0xb840,
    0x0, 0x0, 0xbb33, 0xb843, 0x0, 0x0, 0xbb33, 0xb847,
    0x0, 0x0, 0xbb33, 0xb84b, 0x0, 0x0, 0xbb33, 0xb84f,
    0x0, 0x0, 0xbb33, 0xb853, 0x0, 0x0, 0xbb33, 0xb857,
    0x0, 0x0, 0xbb33, 0xb85a, 0x0, 0x0, 0xbb33, 0xb85e,
    0x0, 0x0, 0xbb33, 0xb862, 0x0, 0x0, 0xbb33, 0xb866,
    0x0, 0x0, 0xbb33, 0xb86a, 0x0, 0x0, 0xbb33, 0xb86e,
    0x0, 0x0, 0xbb33, 0xb872, 0x0, 0x0, 0xbb33, 0xb876,
    0x0, 0x0, 0xbb33, 0xb87a, 0x0, 0x0, 0xbb33, 0xb87d,
    0x0, 0x0, 0xbb33, 0xb881, 0x0, 0x0, 0xbb33, 0xb885,
    0x0, 0x0, 0xbb33, 0xb889, 0x0, 0x0, 0xbb33, 0xb88d,
    0x0, 0x0, 0xbb33, 0xb891, 0x0, 0x0, 0xbb33, 0xb895,
    0x0, 0x0, 0xbb33, 0xb899, 0x0, 0x0, 0xbb33, 0xb89d,
    0x0, 0x0, 0xbb33, 0xb8a1, 0x0, 0x0, 0xbb33, 0xb8a5,
    0x0, 0x0, 0xbb33, 0xb8a9, 0x0, 0x0, 0xbb33, 0xb8ad,
    0x0, 0x0, 0xbb33, 0xb8b1, 0x0, 0x0, 0xbb33, 0xb8b5,
    0x0, 0x0, 0xbb33, 0xb8b9, 0x0, 0x0, 0xbb33, 0xb8bd,
    0x0, 0x0, 0xbb33, 0xb8c1, 0x0, 0x0, 0xbb33, 0xb8c5,
    0x0, 0x0, 0xbb33, 0xb8c9, 0x0, 0x0, 0xbb33, 0xb8ce,
    0x0, 0x0, 0xbb33, 0xb8d2, 0x0, 0x0, 0xbb33, 0xb8d6,
    0x0, 0x0, 0xbb33, 0xb8da, 0x0, 0x0, 0xbb33, 0xb8de,
    0x0, 0x0, 0xbb33, 0xb8e2, 0x0, 0x0, 0xbb33, 0xb8e6,
    0x0, 0x0, 0xbb33, 0xb8ea, 0x0, 0x0, 0xbb33, 0xb8ee,
    0x0, 0x0, 0xbb33, 0xb8f3, 0x0, 0x0, 0xbb33, 0xb8f7,
    0x0, 0x0, 0xbb33, 0xb8fb, 0x0, 0x0, 0xbb33, 0xb8ff,
    0x0, 0x0, 0xbb33, 0xb903, 0x0, 0x0, 0xbb33, 0xb908,
    0x0, 0x0, 0xbb33, 0xb90c, 0x0, 0x0, 0xbb33, 0xb910,
    0x0, 0x0, 0xbb33, 0xb914, 0x0, 0x0, 0xbb33, 0xb918,
    0x0, 0x0, 0xbb33, 0xb91d, 0x0, 0x0, 0xbb33, 0xb921,
    0x0, 0x0, 0xbb33, 0xb925, 0x0, 0x0, 0xbb33, 0xb92a,
    0x0, 0x0, 0xbb33, 0xb92e, 0x0, 0x0, 0xbb33, 0xb932,
    0x0, 0x0, 0xbb33, 0xb936, 0x0, 0x0, 0xbb33, 0xb93b,
    0x0, 0x0, 0xbb33, 0xb93f, 0x0, 0x0, 0xbb33, 0xb943,
    0x0, 0x0, 0xbb33, 0xb948, 0x0, 0x0, 0xbb33, 0xb94c,
    0x0, 0x0, 0xbb33, 0xb950, 0x0, 0x0, 0xbb33, 0xb955,
    0x0, 0x0, 0xbb33, 0xb959, 0x0, 0x0, 0xbb33, 0xb95e,
    0x0, 0x0, 0xbb33, 0xb962, 0x0, 0x0, 0xbb33, 0xb966,
    0x0, 0x0, 0xbb33, 0xb96b, 0x0, 0x0, 0xbb33, 0xb96f,
    0x0, 0x0, 0xbb33, 0xb974, 0x0, 0x0, 0xbb33, 0xb978,
    0x0, 0x0, 0xbb33, 0xb97d, 0x0, 0x0, 0xbb33, 0xb981,
    0x0, 0x0, 0xbb33, 0xb986, 0x0, 0x0, 0xbb33, 0xb98a,
    0x0, 0x0, 0xbb33, 0xb98f, 0x0, 0x0, 0xbb33, 0xb993,
    0x0, 0x0, 0xbb33, 0xb998, 0x0, 0x0, 0xbb33, 0xb99c,
    0x0, 0x0, 0xbb33, 0xb9a1, 0x0, 0x0, 0xbb33, 0xb9a5,
    0x0, 0x0, 0xbb33, 0xb9aa, 0x0, 0x0, 0xbb33, 0xb9ae,
    0x0, 0x0, 0xbb33, 0xb9b3, 0x0, 0x0, 0xbb33, 0xb9b8,
    0x0, 0x0, 0xbb33, 0xb9bc, 0x0, 0x0, 0xbb33, 0xb9c1,
    0x0, 0x0, 0xbb33, 0xb9c6, 0x0, 0x0, 0xbb33, 0xb9ca,
    0x0, 0x0, 0xbb33, 0xb9cf, 0x0, 0x0, 0xbb33, 0xb9d4,
    0x0, 0x0, 0xbb33, 0xb9d8, 0x0, 0x0, 0xbb33, 0xb9dd,
    0x0, 0x0, 0xbb33, 0xb9e2, 0x0, 0x0, 0xbb33, 0xb9e6,
    0x0, 0x0, 0xbb33, 0xb9eb, 0x0, 0x0, 0xbb33, 0xb9f0,
    0x0, 0x0, 0xbb33, 0xb9f5, 0x0, 0x0, 0xbb33, 0xb9f9,
    0x0, 0x0, 0xbb33, 0xb9fe, 0x0, 0x0, 0xbb33, 0xba03,
    0x0, 0x0, 0xbb33, 0xba08, 0x0, 0x0, 0xbb33, 0xba0d,
    0x0, 0x0, 0xbb33, 0xba11, 0x0, 0x0, 0xbb33, 0xba16,
    0x0, 0x0, 0xbb33, 0xba1b, 0x0, 0x0, 0xbb33, 0xba20,
    0x0, 0x0, 0xbb33, 0xba25, 0x0, 0x0, 0xbb33, 0xba2a,
    0x0, 0x0, 0xbb33, 0xba2f, 0x0, 0x0, 0xbb33, 0xba33,
    0x0, 0x0, 0xbb33, 0xba38, 0x0, 0x0, 0xbb33, 0xba3d,
    0x0, 0x0, 0xbb33, 0xba42, 0x0, 0x0, 0xbb33, 0xba47,
    0x0, 0x0, 0xbb33, 0xba4c, 0x0, 0x0, 0xbb33, 0xba51,
    0x0, 0x0, 0xbb33, 0xba56, 0x0, 0x0, 0xbb33, 0xba5b,
    0x0, 0x0, 0xbb33, 0xba60, 0x0, 0x0, 0xbb33, 0xba65,
    0x0, 0x0, 0xbb33, 0xba6a, 0x0, 0x0, 0xbb33, 0xba70,
    0x0, 0x0, 0xbb33, 0xba75, 0x0, 0x0, 0xbb33, 0xba7a,
    0x0, 0x0, 0xbb33, 0xba7f, 0x0, 0x0, 0xbb33, 0xba84,
    0x0, 0x0, 0xbb33, 0xba89, 0x0, 0x0, 0xbb33, 0xba8e,
    0x0, 0x0, 0xbb33, 0xba93, 0x0, 0x0, 0xbb33, 0xba99,
    0x0, 0x0, 0xbb33, 0xba9e, 0x0, 0x0, 0xbb33, 0xbaa3,
    0x0, 0x0, 0xbb33, 0xbaa8, 0x0, 0x0, 0xbb33, 0xbaae,
    0x0, 0x0, 0xbb33, 0xbab3, 0x0, 0x0, 0xbb33, 0xbab8,
    0x0, 0x0, 0xbb33, 0xbabd, 0x0, 0x0, 0xbb33, 0xbac3,
    0x0, 0x0, 0xbb33, 0xbac8, 0x0, 0x0, 0xbb33, 0xbacd,
    0x0, 0x0, 0xbb33, 0xbad3, 0x0, 0x0, 0xbb33, 0xbad8,
    0x0, 0x0, 0xbb33, 0xbade, 0x0, 0x0, 0xbb33, 0xbae3,
    0x0, 0x0, 0xbb33, 0xbae8, 0x0, 0x0, 0xbb33, 0xbaee,
    0x0, 0x0, 0xbb33, 0xbaf3, 0x0, 0x0, 0xbb33, 0xbaf9,
    0x0, 0x0, 0xbb33, 0xbafe, 0x0, 0x0, 0xbb33, 0xbb04,
    0x0, 0x0, 0xbb33, 0xbb09, 0x0, 0x0, 0xbb33, 0xbb0f,
    0x0, 0x0, 0xbb33, 0xbb14, 0x0, 0x0, 0xbb33, 0xbb1a,
    0x0, 0x0, 0xbb33, 0xbb20, 0x0, 0x0, 0xbb33, 0xbb25,
    0x0, 0x0, 0xbb33, 0xbb2b, 0x0, 0x0, 0xbb33, 0xbb30,
    0x0, 0x0, 0xbb33, 0xbb36, 0x0, 0x0, 0xbb33, 0xbb3c,
    0x0, 0x0, 0xbb33, 0xbb41, 0x0, 0x0, 0xbb33, 0xbb47,
    0x0, 0x0, 0xbb33, 0xbb4d, 0x0, 0x0, 0xbb33, 0xbb53,
    0x0, 0x0, 0xbb33, 0xbb58, 0x0, 0x0, 0xbb33, 0xbb5e,
    0x0, 0x0, 0xbb33, 0xbb64, 0x0, 0x0, 0xbb33, 0xbb6a,
    0x0, 0x0, 0xbb33, 0xbb70, 0x0, 0x0, 0xbb33, 0xbb75,
    0x0, 0x0, 0xbb33, 0xbb7b, 0x0, 0x0, 0xbb33, 0xbb81,
    0x0, 0x0, 0xbb33, 0xbb87, 0x0, 0x0, 0xbb33, 0xbb8d,
    0x0, 0x0, 0xbb33, 0xbb93, 0x0, 0x0, 0xbb33, 0xbb99,
    0x0, 0x0, 0xbb33, 0xbb9f, 0x0, 0x0, 0xbb33, 0xbba5,
    0x0, 0x0, 0xbb33, 0xbbab, 0x0, 0x0, 0xbb33, 0xbbb1,
    0x0, 0x0, 0xbb33, 0xbbb7, 0x0, 0x0, 0xbb33, 0xbbbd,
    0x0, 0x0, 0xbb33, 0xbbc3, 0x0, 0x0, 0xbb33, 0xbbc9,
    0x0, 0x0, 0xbb33, 0xbbcf, 0x0, 0x0, 0xbb33, 0xbbd6,
    0x0, 0x0, 0xbb33, 0xbbdc, 0x0, 0x0, 0xbb33, 0xbbe2,
    0x0, 0x0, 0xbb33, 0xbbe8, 0x0, 0x0, 0xbb33, 0xbbef,
    0x0, 0x0, 0xbb33, 0xbbf5, 0x0, 0x0, 0xbb33, 0xbbfb,
    0x0, 0x0, 0xbb33, 0xbc01, 0x0, 0x0, 0xbb33, 0xbc04,
    0x0, 0x0, 0xbb33, 0xbc07, 0x0, 0x0, 0xbb33, 0xbc0a,
    0x0, 0x0, 0xbb33, 0xbc0d, 0x0, 0x0, 0xbb33, 0xbc11,
    0x0, 0x0, 0xbb33, 0xbc14, 0x0, 0x0, 0xbb33, 0xbc17,
    0x0, 0x0, 0xbb33, 0xbc1a, 0x0, 0x0, 0xbb33, 0xbc1e,
    0x0, 0x0, 0xbb33, 0xbc21, 0x0, 0x0, 0xbb33, 0xbc24,
    0x0, 0x0, 0xbb33, 0xbc27, 0x0, 0x0, 0xbb33, 0xbc2b,
    0x0, 0x0, 0xbb33, 0xbc2e, 0x0, 0x0, 0xbb33, 0xbc31,
    0x0, 0x0, 0xbb33, 0xbc35, 0x0, 0x0, 0xbb33, 0xbc38,
    0x0, 0x0, 0xbb33, 0xbc3b, 0x0, 0x0, 0xbb33, 0xbc3f,
    0x0, 0x0, 0xbb33, 0xbc42, 0x0, 0x0, 0xbb33, 0xbc46,
    0x0, 0x0, 0xbb33, 0xbc49, 0x0, 0x0, 0xbb33, 0xbc4c,
    0x0, 0x0, 0xbb33, 0xbc50, 0x0, 0x0, 0xbb33, 0xbc53,
    0x0, 0x0, 0xbb33, 0xbc57, 0x0, 0x0, 0xbb33, 0xbc5a,
    0x0, 0x0, 0xbb33, 0xbc5e, 0x0, 0x0, 0xbb33, 0xbc61,
    0x0, 0x0, 0xbb33, 0xbc65, 0x0, 0x0, 0xbb33, 0xbc68,
    0x0, 0x0, 0xbb33, 0xbc6c, 0x0, 0x0, 0xbb33, 0xbc6f,
    0x0, 0x0, 0xbb33, 0xbc73, 0x0, 0x0, 0xbb33, 0xbc76,
    0x0, 0x0, 0xbb33, 0xbc7a, 0x0, 0x0, 0xbb33, 0xbc7e,
    0x0, 0x0, 0xbb33, 0xbc81, 0x0, 0x0, 0xbb33, 0xbc85,
    0x0, 0x0, 0xbb33, 0xbc89, 0x0, 0x0, 0xbb33, 0xbc8c,
    0x0, 0x0, 0xbb33, 0xbc90, 0x0, 0x0, 0xbb33, 0xbc94,
    0x0, 0x0, 0xbb33, 0xbc97, 0x0, 0x0, 0xbb33, 0xbc9b,
    0x0, 0x0, 0xbb33, 0xbc9f, 0x0, 0x0, 0xbb33, 0xbca3,
    0x0, 0x0, 0xbb33, 0xbca6, 0x0, 0x0, 0xbb33, 0xbcaa,
    0x0, 0x0, 0xbb33, 0xbcae, 0x0, 0x0, 0xbb33, 0xbcb2,
    0x0, 0x0, 0xbb33, 0xbcb6, 0x0, 0x0, 0xbb33, 0xbcb9,
    0x0, 0x0, 0xbb33, 0xbcbd, 0x0, 0x0, 0xbb33, 0xbcc1,
    0x0, 0x0, 0xbb33, 0xbcc5, 0x0, 0x0, 0xbb33, 0xbcc9,
    0x0, 0x0, 0xbb33, 0xbccd, 0x0, 0x0, 0xbb33, 0xbcd1,
    0x0, 0x0, 0xbb33, 0xbcd5, 0x0, 0x0, 0xbb33, 0xbcd9,
    0x0, 0x0, 0xbb33, 0xbcdd, 0x0, 0x0, 0xbb33, 0xbce1,
    0x0, 0x0, 0xbb33, 0xbce5, 0x0, 0x0, 0xbb33, 0xbce9,
    0x0, 0x0, 0xbb33, 0xbced, 0x0, 0x0, 0xbb33, 0xbcf1,
    0x0, 0x0, 0xbb33, 0xbcf5, 0x0, 0x0, 0xbb33, 0xbcf9,
    0x0, 0x0, 0xbb33, 0xbcfd, 0x0, 0x0, 0xbb33, 0xbd01,
    0x0, 0x0, 0xbb33, 0xbd05, 0x0, 0x0, 0xbb33, 0xbd0a,
    0x0, 0x0, 0xbb33, 0xbd0e, 0x0, 0x0, 0xbb33, 0xbd12,
    0x0, 0x0, 0xbb33, 0xbd16, 0x0, 0x0, 0xbb33, 0xbd1a,
    0x0, 0x0, 0xbb33, 0xbd1f, 0x0, 0x0, 0xbb33, 0xbd23,
    0x0, 0x0, 0xbb33, 0xbd27, 0x0, 0x0, 0xbb33, 0xbd2c,
    0x0, 0x0, 0xbb33, 0xbd30, 0x0, 0x0, 0xbb33, 0xbd34,
    0x0, 0x0, 0xbb33, 0xbd39, 0x0, 0x0, 0xbb33, 0xbd3d,
    0x0, 0x0, 0xbb33, 0xbd42, 0x0, 0x0, 0xbb33, 0xbd46,
    0x0, 0x0, 0xbb33, 0xbd4a, 0x0, 0x0, 0xbb33, 0xbd4f,
    0x0, 0x0, 0xbb33, 0xbd53, 0x0, 0x0, 0xbb33, 0xbd58,
    0x0, 0x0, 0xbb33, 0xbd5c, 0x0, 0x0, 0xbb33, 0xbd61,
    0x0, 0x0, 0xbb33, 0xbd66, 0x0, 0x0, 0xbb33, 0xbd6a,
    0x0, 0x0, 0xbb33, 0xbd6f, 0x0, 0x0, 0xbb33, 0xbd73,
    0x0, 0x0, 0xbb33, 0xbd78, 0x0, 0x0, 0xbb33, 0xbd7d,
    0x0, 0x0, 0xbb33, 0xbd81, 0x0, 0x0, 0xbb33, 0xbd86,
    0x0, 0x0, 0xbb33, 0xbd8b, 0x0, 0x0, 0xbb33, 0xbd90,
    0x0, 0x0, 0xbb33, 0xbd95, 0x0, 0x0, 0xbb33, 0xbd99,
    0x0, 0x0, 0xbb33, 0xbd9e, 0x0, 0x0, 0xbb33, 0xbda3,
    0x0, 0x0, 0xbb33, 0xbda8, 0x0, 0x0, 0xbb33, 0xbdad,
    0x0, 0x0, 0xbb33, 0xbdb2, 0x0, 0x0, 0xbb33, 0xbdb7,
    0x0, 0x0, 0xbb33, 0xbdbc, 0x0, 0x0, 0xbb33, 0xbdc1,
    0x0, 0x0, 0xbb33, 0xbdc6, 0x0, 0x0, 0xbb33, 0xbdcb,
    0x0, 0x0, 0xbb33, 0xbdd0, 0x0, 0x0, 0xbb33, 0xbdd5,
    0x0, 0x0, 0xbb33, 0xbdda, 0x0, 0x0, 0xbb33, 0xbddf,
    0x0, 0x0, 0xbb33, 0xbde5, 0x0, 0x0, 0xbb33, 0xbdea,
    0x0, 0x0, 0xbb33, 0xbdef, 0x0, 0x0, 0xbb33, 0xbdf4,
    0x0, 0x0, 0xbb33, 0xbdfa, 0x0, 0x0, 0xbb33, 0xbdff,
    0x0, 0x0, 0xbb33, 0xbe04, 0x0, 0x0, 0xbb33, 0xbe0a,
    0x0, 0x0, 0xbb33, 0xbe0f, 0x0, 0x0, 0xbb33, 0xbe14,
    0x0, 0x0, 0xbb33, 0xbe1a, 0x0, 0x0, 0xbb33, 0xbe1f,
    0x0, 0x0, 0xbb33, 0xbe25, 0x0, 0x0, 0xbb33, 0xbe2b,
    0x0, 0x0, 0xbb33, 0xbe30, 0x0, 0x0, 0xbb33, 0xbe36,
    0x0, 0x0, 0xbb33, 0xbe3b, 0x0, 0x0, 0xbb33, 0xbe41,
    0x0, 0x0, 0xbb33, 0xbe47, 0x0, 0x0, 0xbb33, 0xbe4c,
    0x0, 0x0, 0xbb33, 0xbe52, 0x0, 0x0, 0xbb33, 0xbe58,
    0x0, 0x0, 0xbb33, 0xbe5e, 0x0, 0x0, 0xbb33, 0xbe64,
    0x0, 0x0, 0xbb33, 0xbe69, 0x0, 0x0, 0xbb33, 0xbe6f,
    0x0, 0x0, 0xbb33, 0xbe75, 0x0, 0x0, 0xbb33, 0xbe7b,
    0x0, 0x0, 0xbb33, 0xbe81, 0x0, 0x0, 0xbb33, 0xbe87,
    0x0, 0x0, 0xbb33, 0xbe8d, 0x0, 0x0, 0xbb33, 0xbe94,
    0x0, 0x0, 0xbb33, 0xbe9a, 0x0, 0x0, 0xbb33, 0xbea0,
    0x0, 0x0, 0xbb33, 0xbea6, 0x0, 0x0, 0xbb33, 0xbeac,
    0x0, 0x0, 0xbb33, 0xbeb3, 0x0, 0x0, 0xbb33, 0xbeb9,
    0x0, 0x0, 0xbb33, 0xbebf, 0x0, 0x0, 0xbb33, 0xbec6,
    0x0, 0x0, 0xbb33, 0xbecc, 0x0, 0x0, 0xbb33, 0xbed3,
    0x0, 0x0, 0xbb33, 0xbed9, 0x0, 0x0, 0xbb33, 0xbee0,
    0x0, 0x0, 0xbb33, 0xbee6, 0x0, 0x0, 0xbb33, 0xbeed,
    0x0, 0x0, 0xbb33, 0xbef4, 0x0, 0x0, 0xbb33, 0xbefa,
    0x0, 0x0, 0xbb33, 0xbf01, 0x0, 0x0, 0xbb33, 0xbf08,
    0x0, 0x0, 0xbb33, 0xbf0f, 0x0, 0x0, 0xbb33, 0xbf16,
    0x0, 0x0, 0xbb33, 0xbf1c, 0x0, 0x0, 0xbb33, 0xbf23,
    0x0, 0x0, 0xbb33, 0xbf2a, 0x0, 0x0, 0xbb33, 0xbf31,
    0x0, 0x0, 0xbb33, 0xbf39, 0x0, 0x0, 0xbb33, 0xbf40,
    0x0, 0x0, 0xbb33, 0xbf47, 0x0, 0x0, 0xbb33, 0xbf4e,
    0x0, 0x0, 0xbb33, 0xbf55, 0x0, 0x0, 0xbb33, 0xbf5d,
    0x0, 0x0, 0xbb33, 0xbf64, 0x0, 0x0, 0xbb33, 0xbf6b,
    0x0, 0x0, 0xbb33, 0xbf73, 0x0, 0x0, 0xbb33, 0xbf7a,
    0x0, 0x0, 0xbb33, 0xbf82, 0x0, 0x0, 0xbb33, 0xbf89,
    0x0, 0x0, 0xbb33, 0xbf91, 0x0, 0x0, 0xbb33, 0xbf99,
    0x0, 0x0, 0xbb33, 0xbfa0, 0x0, 0x0, 0xbb33, 0xbfa8,
    0x0, 0x0, 0xbb33, 0xbfb0, 0x0, 0x0, 0xbb33, 0xbfb8,
    0x0, 0x0, 0xbb33, 0xbfc0, 0x0, 0x0, 0xbb33, 0xbfc8,
    0x0, 0x0, 0xbb33, 0xbfd0, 0x0, 0x0, 0xbb33, 0xbfd8,
    0x0, 0x0, 0xbb33, 0xbfe0, 0x0, 0x0, 0xbb33, 0xbfe8,
    0x0, 0x0, 0xbb33, 0xbff1, 0x0, 0x0, 0xbb33, 0xbff9,
    0x0, 0x0, 0xbb33, 0xc001, 0x0, 0x0, 0xbb33, 0xc005,
    0x0, 0x0, 0xbb33, 0xc009, 0x0, 0x0, 0xbb33, 0xc00d,
    0x0, 0x0, 0xbb33, 0xc012, 0x0, 0x0, 0xbb33, 0xc016,
    0x0, 0x0, 0xbb33, 0xc01a, 0x0, 0x0, 0xbb33, 0xc01f,
    0x0, 0x0, 0xbb33, 0xc023, 0x0, 0x0, 0xbb33, 0xc028,
    0x0, 0x0, 0xbb33, 0xc02c, 0x0, 0x0, 0xbb33, 0xc031,
    0x0, 0x0, 0xbb33, 0xc035, 0x0, 0x0, 0xbb33, 0xc03a,
    0x0, 0x0, 0xbb33, 0xc03e, 0x0, 0x0, 0xbb33, 0xc043,
    0x0, 0x0, 0xbb33, 0xc048, 0x0, 0x0, 0xbb33, 0xc04d,
    0x0, 0x0, 0xbb33, 0xc051, 0x0, 0x0, 0xbb33, 0xc056,
    0x0, 0x0, 0xbb33, 0xc05b, 0x0, 0x0, 0xbb33, 0xc060,
    0x0, 0x0, 0xbb33, 0xc065, 0x0, 0x0, 0xbb33, 0xc06a,
    0x0, 0x0, 0xbb33, 0xc06f, 0x0, 0x0, 0xbb33, 0xc074,
    0x0, 0x0, 0xbb33, 0xc079, 0x0, 0x0, 0xbb33, 0xc07e,
    0x0, 0x0, 0xbb33, 0xc083, 0x0, 0x0, 0xbb33, 0xc088,
    0x0, 0x0, 0xbb33, 0xc08d, 0x0, 0x0, 0xbb33, 0xc092,
    0x0, 0x0, 0xbb33, 0xc098, 0x0, 0x0, 0xbb33, 0xc09d,
    0x0, 0x0, 0xbb33, 0xc0a2, 0x0, 0x0, 0xbb33, 0xc0a8,
    0x0, 0x0, 0xbb33, 0xc0ad, 0x0, 0x0, 0xbb33, 0xc0b3,
    0x0, 0x0, 0xbb33, 0xc0b8, 0x0, 0x0, 0xbb33, 0xc0be,
    0x0, 0x0, 0xbb33, 0xc0c4, 0x0, 0x0, 0xbb33, 0xc0c9,
    0x0, 0x0, 0xbb33, 0xc0cf, 0x0, 0x0, 0xbb33, 0xc0d5,
    0x0, 0x0, 0xbb33, 0xc0db, 0x0, 0x0, 0xbb33, 0xc0e0,
    0x0, 0x0, 0xbb33, 0xc0e6, 0x0, 0x0, 0xbb33, 0xc0ec,
    0x0, 0x0, 0xbb33, 0xc0f2, 0x0, 0x0, 0xbb33, 0xc0f8,
    0x0, 0x0, 0xbb33, 0xc0ff, 0x0, 0x0, 0xbb33, 0xc105,
    0x0, 0x0, 0xbb33, 0xc10b, 0x0, 0x0, 0xbb33, 0xc111,
    0x0, 0x0, 0xbb33, 0xc118, 0x0, 0x0, 0xbb33, 0xc11e,
    0x0, 0x0, 0xbb33, 0xc124, 0x0, 0x0, 0xbb33, 0xc12b,
    0x0, 0x0, 0xbb33, 0xc131, 0x0, 0x0, 0xbb33, 0xc138,
    0x0, 0x0, 0xbb33, 0xc13f, 0x0, 0x0, 0xbb33, 0xc146,
    0x0, 0x0, 0xbb33, 0xc14c, 0x0, 0x0, 0xbb33, 0xc153,
    0x0, 0x0, 0xbb33, 0xc15a, 0x0, 0x0, 0xbb33, 0xc161,
    0x0, 0x0, 0xbb33, 0xc168, 0x0, 0x0, 0xbb33, 0xc16f,
    0x0, 0x0, 0xbb33, 0xc176, 0x0, 0x0, 0xbb33, 0xc17e,
    0x0, 0x0, 0xbb33, 0xc185, 0x0, 0x0, 0xbb33, 0xc18c,
    0x0, 0x0, 0xbb33, 0xc194, 0x0, 0x0, 0xbb33, 0xc19b,
    0x0, 0x0, 0xbb33, 0xc1a3, 0x0, 0x0, 0xbb33, 0xc1ab,
    0x0, 0x0, 0xbb33, 0xc1b2, 0x0, 0x0, 0xbb33, 0xc1ba,
    0x0, 0x0, 0xbb33, 0xc1c2, 0x0, 0x0, 0xbb33, 0xc1ca,
    0x0, 0x0, 0xbb33, 0xc1d2, 0x0, 0x0, 0xbb33, 0xc1da,
    0x0, 0x0, 0xbb33, 0xc1e3, 0x0, 0x0, 0xbb33, 0xc1eb,
    0x0, 0x0, 0xbb33, 0xc1f3, 0x0, 0x0, 0xbb33, 0xc1fc,
    0x0, 0x0, 0xbb33, 0xc204, 0x0, 0x0, 0xbb33, 0xc20d,
    0x0, 0x0, 0xbb33, 0xc216, 0x0, 0x0, 0xbb33, 0xc21f,
    0x0, 0x0, 0xbb33, 0xc227, 0x0, 0x0, 0xbb33, 0xc230,
    0x0, 0x0, 0xbb33, 0xc23a, 0x0, 0x0, 0xbb33, 0xc243,
    0x0, 0x0, 0xbb33, 0xc24c, 0x0, 0x0, 0xbb33, 0xc255,
    0x0, 0x0, 0xbb33, 0xc25f, 0x0, 0x0, 0xbb33, 0xc269,
    0x0, 0x0, 0xbb33, 0xc272, 0x0, 0x0, 0xbb33, 0xc27c,
    0x0, 0x0, 0xbb33, 0xc286, 0x0, 0x0, 0xbb33, 0xc290,
    0x0, 0x0, 0xbb33, 0xc29a, 0x0, 0x0, 0xbb33, 0xc2a5,
    0x0, 0x0, 0xbb33, 0xc2af, 0x0, 0x0, 0xbb33, 0xc2b9,
    0x0, 0x0, 0xbb33, 0xc2c4, 0x0, 0x0, 0xbb33, 0xc2cf,
    0x0, 0x0, 0xbb33, 0xc2da, 0x0, 0x0, 0xbb33, 0xc2e5,
    0x0, 0x0, 0xbb33, 0xc2f0, 0x0, 0x0, 0xbb33, 0xc2fb,
    0x0, 0x0, 0xbb33, 0xc307, 0x0, 0x0, 0xbb33, 0xc312,
    0x0, 0x0, 0xbb33, 0xc31e, 0x0, 0x0, 0xbb33, 0xc32a,
    0x0, 0x0, 0xbb33, 0xc336, 0x0, 0x0, 0xbb33, 0xc342,
    0x0, 0x0, 0xbb33, 0xc34e, 0x0, 0x0, 0xbb33, 0xc35a,
    0x0, 0x0, 0xbb33, 0xc367, 0x0, 0x0, 0xbb33, 0xc374,
    0x0, 0x0, 0xbb33, 0xc381, 0x0, 0x0, 0xbb33, 0xc38e,
    0x0, 0x0, 0xbb33, 0xc39b, 0x0, 0x0, 0xbb33, 0xc3a8,
    0x0, 0x0, 0xbb33, 0xc3b6, 0x0, 0x0, 0xbb33, 0xc3c4,
    0x0, 0x0, 0xbb33, 0xc3d2, 0x0, 0x0, 0xbb33, 0xc3e0,
    0x0, 0x0, 0xbb33, 0xc3ee, 0x0, 0x0, 0xbb33, 0xc3fd,
    0x0, 0x0, 0xbb33, 0xc406, 0x0, 0x0, 0xbb33, 0xc40d,
    0x0, 0x0, 0xbb33, 0xc415, 0x0, 0x0, 0xbb33, 0xc41c,
    0x0, 0x0, 0xbb33, 0xc424, 0x0, 0x0, 0xbb33, 0xc42c,
    0x0, 0x0, 0xbb33, 0xc434, 0x0, 0x0, 0xbb33, 0xc43c,
    0x0, 0x0, 0xbb33, 0xc444, 0x0, 0x0, 0xbb33, 0xc44d,
    0x0, 0x0, 0xbb33, 0xc455, 0x0, 0x0, 0xbb33, 0xc45e,
    0x0, 0x0, 0xbb33, 0xc467, 0x0, 0x0, 0xbb33, 0xc470,
    0x0, 0x0, 0xbb33, 0xc479, 0x0, 0x0, 0xbb33, 0xc482,
    0x0, 0x0, 0xbb33, 0xc48b, 0x0, 0x0, 0xbb33, 0xc494,
    0x0, 0x0, 0xbb33, 0xc49e, 0x0, 0x0, 0xbb33, 0xc4a8,
    0x0, 0x0, 0xbb33, 0xc4b2, 0x0, 0x0, 0xbb33, 0xc4bc,
    0x0, 0x0, 0xbb33, 0xc4c6, 0x0, 0x0, 0xbb33, 0xc4d0,
    0x0, 0x0, 0xbb33, 0xc4db, 0x0, 0x0, 0xbb33, 0xc4e5,
    0x0, 0x0, 0xbb33, 0xc4f0, 0x0, 0x0, 0xbb33, 0xc4fb,
    0x0, 0x0, 0xbb33, 0xc507, 0x0, 0x0, 0xbb33, 0xc512,
    0x0, 0x0, 0xbb33, 0xc51e, 0x0, 0x0, 0xbb33, 0xc52a,
    0x0, 0x0, 0xbb33, 0xc536, 0x0, 0x0, 0xbb33, 0xc542,
    0x0, 0x0, 0xbb33, 0xc54f, 0x0, 0x0, 0xbb33, 0xc55c,
    0x0, 0x0, 0xbb33, 0xc568, 0x0, 0x0, 0xbb33, 0xc576,
    0x0, 0x0, 0xbb33, 0xc583, 0x0, 0x0, 0xbb33, 0xc591,
    0x0, 0x0, 0xbb33, 0xc59f, 0x0, 0x0, 0xbb33, 0xc5ad,
    0x0, 0x0, 0xbb33, 0xc5bc, 0x0, 0x0, 0xbb33, 0xc5cb,
    0x0, 0x0, 0xbb33, 0xc5da, 0x0, 0x0, 0xbb33, 0xc5e9,
    0x0, 0x0, 0xbb33, 0xc5f9, 0x0, 0x0, 0xbb33, 0xc609,
    0x0, 0x0, 0xbb33, 0xc619, 0x0, 0x0, 0xbb33, 0xc62a,
    0x0, 0x0, 0xbb33, 0xc63b, 0x0, 0x0, 0xbb33, 0xc64d,
    0x0, 0x0, 0xbb33, 0xc65f, 0x0, 0x0, 0xbb33, 0xc671,
    0x0, 0x0, 0xbb33, 0xc684, 0x0, 0x0, 0xbb33, 0xc697,
    0x0, 0x0, 0xbb33, 0xc6aa, 0x0, 0x0, 0xbb33, 0xc6be,
    0x0, 0x0, 0xbb33, 0xc6d3, 0x0, 0x0, 0xbb33, 0xc6e8,
    0x0, 0x0, 0xbb33, 0xc6fd, 0x0, 0x0, 0xbb33, 0xc713,
    0x0, 0x0, 0xbb33, 0xc729, 0x0, 0x0, 0xbb33, 0xc740,
    0x0, 0x0, 0xbb33, 0xc758, 0x0, 0x0, 0xbb33, 0xc770,
    0x0, 0x0, 0xbb33, 0xc789, 0x0, 0x0, 0xbb33, 0xc7a2,
    0x0, 0x0, 0xbb33, 0xc7bc, 0x0, 0x0, 0xbb33, 0xc7d7,
    0x0, 0x0, 0xbb33, 0xc7f3, 0x0, 0x0, 0xbb33, 0xc808,
    0x0, 0x0, 0xbb33, 0xc816, 0x0, 0x0, 0xbb33, 0xc825,
    0x0, 0x0, 0xbb33, 0xc834, 0x0, 0x0, 0xbb33, 0xc844,
    0x0, 0x0, 0xbb33, 0xc855, 0x0, 0x0, 0xbb33, 0xc865,
    0x0, 0x0, 0xbb33, 0xc877, 0x0, 0x0, 0xbb33, 0xc889,
    0x0, 0x0, 0xbb33, 0xc89b, 0x0, 0x0, 0xbb33, 0xc8ae,
    0x0, 0x0, 0xbb33, 0xc8c1, 0x0, 0x0, 0xbb33, 0xc8d6,
    0x0, 0x0, 0xbb33, 0xc8eb, 0x0, 0x0, 0xbb33, 0xc900,
    0x0, 0x0, 0xbb33, 0xc917, 0x0, 0x0, 0xbb33, 0xc92e,
    0x0, 0x0, 0xbb33, 0xc946, 0x0, 0x0, 0xbb33, 0xc95f,
    0x0, 0x0, 0xbb33, 0xc979, 0x0, 0x0, 0xbb33, 0xc993,
    0x0, 0x0, 0xbb33, 0xc9af, 0x0, 0x0, 0xbb33, 0xc9cc,
    0x0, 0x0, 0xbb33, 0xc9ea, 0x0, 0x0, 0xbb33, 0xca0a,
    0x0, 0x0, 0xbb33, 0xca2a, 0x0, 0x0, 0xbb33, 0xca4c,
    0x0, 0x0, 0xbb33, 0xca70, 0x0, 0x0, 0xbb33, 0xca95,
    0x0, 0x0, 0xbb33, 0xcabc, 0x0, 0x0, 0xbb33, 0xcae5,
    0x0, 0x0, 0xbb33, 0xcb0f, 0x0, 0x0, 0xbb33, 0xcb3c,
    0x0, 0x0, 0xbb33, 0xcb6b, 0x0, 0x0, 0xbb33, 0xcb9c,
    0x0, 0x0, 0xbb33, 0xcbd0, 0x0, 0x0, 0xbb33, 0xcc04,
    0x0, 0x0, 0xbb33, 0xcc21, 0x0, 0x0, 0xbb33, 0xcc3f,
    0x0, 0x0, 0xbb33, 0xcc60, 0x0, 0x0, 0xbb33, 0xcc82,
    0x0, 0x0, 0xbb33, 0xcca7, 0x0, 0x0, 0xbb33, 0xccce,
    0x0, 0x0, 0xbb33, 0xccf8, 0x0, 0x0, 0xbb33, 0xcd25,
    0x0, 0x0, 0xbb33, 0xcd55, 0x0, 0x0, 0xbb33, 0xcd88,
    0x0, 0x0, 0xbb33, 0xcdc0, 0x0, 0x0, 0xbb33, 0xcdfc,
    0x0, 0x0, 0xbb33, 0xce3d, 0x0, 0x0, 0xbb33, 0xce84,
    0x0, 0x0, 0xbb33, 0xced2, 0x0, 0x0, 0xbb33, 0xcf27,
    0x0, 0x0, 0xbb33, 0xcf85, 0x0, 0x0, 0xbb33, 0xcfed,
    0x0, 0x0, 0xbb33, 0xd031, 0x0, 0x0, 0xbb33, 0xd072,
    0x0, 0x0, 0xbb33, 0xd0bb, 0x0, 0x0, 0xbb33, 0xd10f,
    0x0, 0x0, 0xbb33, 0xd16f, 0x0, 0x0, 0xbb33, 0xd1de,
    0x0, 0x0, 0xbb33, 0xd260, 0x0, 0x0, 0xbb33, 0xd2fc,
    0x0, 0x0, 0xbb33, 0xd3b8, 0x0, 0x0, 0xbb33, 0xd450,
    0x0, 0x0, 0xbb33, 0xd4e4, 0x0, 0x0, 0xbb33, 0xd5a4,
    0x0, 0x0, 0xbb33, 0xd6ab, 0x0, 0x0, 0xbb33, 0xd813,
    0x0, 0x0, 0xbb33, 0xd93d, 0x0, 0x0, 0xbb33, 0xdb55,
    0x0, 0x0, 0xbb33, 0xde1d, 0x0, 0x0, 0xbb33, 0xe495
    };

static const uint16_t ref_cfft_step_4096[8192] = {
    0x6733, 0x0, 0xbb33, 0x6495, 0x0, 0x0, 0xbb33, 0x5e1d,
    0x0, 0x0, 0xbb33, 0x5b55, 0x0, 0x0, 0xbb33, 0x593d,
    0x0, 0x0, 0xbb33, 0x5813, 0x0, 0x0, 0xbb33, 0x56ab,
    0x0, 0x0, 0xbb33, 0x55a4, 0x0, 0x0, 0xbb33, 0x54e4,
    0x0, 0x0, 0xbb33, 0x5450, 0x0, 0x0, 0xbb33, 0x53b8,
    0x0, 0x0, 0xbb33, 0x52fc, 0x0, 0x0, 0xbb33, 0x5260,
    0x0, 0x0, 0xbb33, 0x51de, 0x0, 0x0, 0xbb33, 0x516f,
    0x0, 0x0, 0xbb33, 0x510f, 0x0, 0x0, 0xbb33, 0x50bb,
    0x0, 0x0, 0xbb33, 0x5072, 0x0, 0x0, 0xbb33, 0x5031,
    0x0, 0x0, 0xbb33, 0x4fed, 0x0, 0x0, 0xbb33, 0x4f85,
    0x0, 0x0, 0xbb33, 0x4f27, 0x0, 0x0, 0xbb33, 0x4ed2,
    0x0, 0x0, 0xbb33, 0x4e84, 0x0, 0x0, 0xbb33, 0x4e3d,
    0x0, 0x0, 0xbb33, 0x4dfc, 0x0, 0x0, 0xbb33, 0x4dc0,
    0x0, 0x0, 0xbb33, 0x4d88, 0x0, 0x0, 0xbb33, 0x4d55,
    0x0, 0x0, 0xbb33, 0x4d25, 0x0, 0x0, 0xbb33, 0x4cf8,
    0x0, 0x0, 0xbb33, 0x4cce, 0x0, 0x0, 0xbb33, 0x4ca7,
    0x0, 0x0, 0xbb33, 0x4c82, 0x0, 0x0, 0xbb33, 0x4c60,
    0x0, 0x0, 0xbb33, 0x4c3f, 0x0, 0x0, 0xbb33, 0x4c21,
    0x0, 0x0, 0xbb33, 0x4c04, 0x0, 0x0, 0xbb33, 0x4bd0,
    0x0, 0x0, 0xbb33, 0x4b9c, 0x0, 0x0, 0xbb33, 0x4b6b,
    0x0, 0x0, 0xbb33, 0x4b3c, 0x0, 0x0, 0xbb33, 0x4b0f,
    0x0, 0x0, 0xbb33, 0x4ae5, 0x0, 0x0, 0xbb33, 0x4abc,
    0x0, 0x0, 0xbb33, 0x4a95, 0x0, 0x0, 0xbb33, 0x4a70,
    0x0, 0x0, 0xbb33, 0x4a4c, 0x0, 0x0, 0xbb33, 0x4a2a,
    0x0, 0x0, 0xbb33, 0x4a0a, 0x0, 0x0, 0xbb33, 0x49ea,
    0x0, 0x0, 0xbb33, 0x49cc, 0x0, 0x0, 0xbb33, 0x49af,
    0x0, 0x0, 0xbb33, 0x4993, 0x0, 0x0, 0xbb33, 0x4979,
    0x0, 0x0, 0xbb33, 0x495f, 0x0, 0x0, 0xbb33, 0x4946,
    0x0, 0x0, 0xbb33, 0x492e, 0x0, 0x0, 0xbb33, 0x4917,
    0x0, 0x0, 0xbb33, 0x4900, 0x0, 0x0, 0xbb33, 0x48eb,
    0x0, 0x0, 0xbb33, 0x48d6, 0x0, 0x0, 0xbb33, 0x48c1,
    0x0, 0x0, 0xbb33, 0x48ae, 0x0, 0x0, 0xbb33, 0x489b,
    0x0, 0x0, 0xbb33, 0x4889, 0x0, 0x0, 0xbb33, 0x4877,
    0x0, 0x0, 0xbb33, 0x4865, 0x0, 0x0, 0xbb33, 0x4855,
    0x0, 0x0, 0xbb33, 0x4844, 0x0, 0x0, 0xbb33, 0x4834,
    0x0, 0x0, 0xbb33, 0x4825, 0x0, 0x0, 0xbb33, 0x4816,
    0x0, 0x0, 0xbb33, 0x4808, 0x0, 0x0, 0xbb33, 0x47f3,
    0x0, 0x0, 0xbb33, 0x47d7, 0x0, 0x0, 0xbb33, 0x47bc,
    0x0, 0x0, 0xbb33, 0x47a2, 0x0, 0x0, 0xbb33, 0x4789,
    0x0, 0x0, 0xbb33, 0x4770, 0x0, 0x0, 0xbb33, 0x4758,
    0x0, 0x0, 0xbb33, 0x4740, 0x0, 0x0, 0xbb33, 0x4729,
    0x0, 0x0, 0xbb33, 0x4713, 0x0, 0x0, 0xbb33, 0x46fd,
    0x0, 0x0, 0xbb33, 0x46e8, 0x0, 0x0, 0xbb33, 0x46d3,
    0x0, 0x0, 0xbb33, 0x46be, 0x0, 0x0, 0xbb33, 0x46aa,
    0x0, 0x0, 0xbb33, 0x4697, 0x0, 0x0, 0xbb33, 0x4684,
    0x0, 0x0, 0xbb33, 0x4671, 0x0, 0x0, 0xbb33, 0x465f,
    0x0, 0x0, 0xbb33, 0x464d, 0x0, 0x0, 0xbb33, 0x463b,
    0x0, 0x0, 0xbb33, 0x462a, 0x0, 0x0, 0xbb33, 0x4619,
    0x0, 0x0, 0xbb33, 0x4609, 0x0, 0x0, 0xbb33, 0x45f9,
    0x0, 0x0, 0xbb33, 0x45e9, 0x0, 0x0, 0xbb33, 0x45da,
    0x0, 0x0, 0xbb33, 0x45cb, 0x0, 0x0, 0xbb33, 0x45bc,
    0x0, 0x0, 0xbb33, 0x45ad, 0x0, 0x0, 0xbb33, 0x459f,
    0x0, 0x0, 0xbb33, 0x4591, 0x0, 0x0, 0xbb33, 0x4583,
    0x0, 0x0, 0xbb33, 0x4576, 0x0, 0x0, 0xbb33, 0x4568,
    0x0, 0x0, 0xbb33, 0x455c, 0x0, 0x0, 0xbb33, 0x454f,
    0x0, 0x0, 0xbb33, 0x4542, 0x0, 0x0, 0xbb33, 0x4536,
    0x0, 0x0, 0xbb33, 0x452a, 0x0, 0x0, 0xbb33, 0x451e,
    0x0, 0x0, 0xbb33, 0x4512, 0x0, 0x0, 0xbb33, 0x4507,
    0x0, 0x0, 0xbb33, 0x44fb, 0x0, 0x0, 0xbb33, 0x44f0,
    0x0, 0x0, 0xbb33, 0x44e5, 0x0, 0x0, 0xbb33, 0x44db,
    0x0, 0x0, 0xbb33, 0x44d0, 0x0, 0x0, 0xbb33, 0x44c6,
    0x0, 0x0, 0xbb33, 0x44bc, 0x0, 0x0, 0xbb33, 0x44b2,
    0x0, 0x0, 0xbb33, 0x44a8, 0x0, 0x0, 0xbb33, 0x449e,
    0x0, 0x0, 0xbb33, 0x4494, 0x0, 0x0, 0xbb33, 0x448b,
    0x0, 0x0, 0xbb33, 0x4482, 0x0, 0x0, 0xbb33, 0x4479,
    0x0, 0x0, 0xbb33, 0x4470, 0x0, 0x0, 0xbb33, 0x4467,
    0x0, 0x0, 0xbb33, 0x445e, 0x0, 0x0, 0xbb33, 0x4455,
    0x0, 0x0, 0xbb33, 0x444d, 0x0, 0x0, 0xbb33, 0x4444,
    0x0, 0x0, 0xbb33, 0x443c, 0x0, 0x0, 0xbb33, 0x4434,
    0x0, 0x0, 0xbb33, 0x442c, 0x0, 0x0, 0xbb33, 0x4424,
    0x0, 0x0, 0xbb33, 0x441c, 0x0, 0x0, 0xbb33, 0x4415,
    0x0, 0x0, 0xbb33, 0x440d, 0x0, 0x0, 0xbb33, 0x4406,
    0x0, 0x0, 0xbb33, 0x43fd, 0x0, 0x0, 0xbb33, 0x43ee,
    0x0, 0x0, 0xbb33, 0x43e0, 0x0, 0x0, 0xbb33, 0x43d2,
    0x0, 0x0, 0xbb33, 0x43c4, 0x0, 0x0, 0xbb33, 0x43b6,
    0x0, 0x0, 0xbb33, 0x43a8, 0x0, 0x0, 0xbb33, 0x439b,
    0x0, 0x0, 0xbb33, 0x438e, 0x0, 0x0, 0xbb33, 0x4381,
    0x0, 0x0, 0xbb33, 0x4374, 0x0, 0x0, 0xbb33, 0x4367,
    0x0, 0x0, 0xbb33, 0x435a, 0x0, 0x0, 0xbb33, 0x434e,
    0x0, 0x0, 0xbb33, 0x4342, 0x0, 0x0, 0xbb33, 0x4336,
    0x0, 0x0, 0xbb33, 0x432a, 0x0, 0x0, 0xbb33, 0x431e,
    0x0, 0x0, 0xbb33, 0x4312, 0x0, 0x0, 0xbb33, 0x4307,
    0x0, 0x0, 0xbb33, 0x42fb, 0x0, 0x0, 0xbb33, 0x42f0,
    0x0, 0x0, 0xbb33, 0x42e5, 0x0, 0x0, 0xbb33, 0x42da,
    0x0, 0x0, 0xbb33, 0x42cf, 0x0, 0x0, 0xbb33, 0x42c4,
    0x0, 0x0, 0xbb33, 0x42b9, 0x0, 0x0, 0xbb33, 0x42af,
    0x0, 0x0, 0xbb33, 0x42a5, 0x0, 0x0, 0xbb33, 0x429a,
    0x0, 0x0, 0xbb33, 0x4290, 0x0, 0x0, 0xbb33, 0x4286,
    0x0, 0x0, 0xbb33, 0x427c, 0x0, 0x0, 0xbb33, 0x4272,
    0x0, 0x0, 0xbb33, 0x4269, 0x0, 0x0, 0xbb33, 0x425f,
    0x0, 0x0, 0xbb33, 0x4255, 0x0, 0x0, 0xbb33, 0x424c,
    0x0, 0x0, 0xbb33, 0x4243, 0x0, 0x0, 0xbb33, 0x423a,
    0x0, 0x0, 0xbb33, 0x4230, 0x0, 0x0, 0xbb33, 0x4227,
    0x0, 0x0, 0xbb33, 0x421f, 0x0, 0x0, 0xbb33, 0x4216,
    0x0, 0x0, 0xbb33, 0x420d, 0x0, 0x0, 0xbb33, 0x4204,
    0x0, 0x0, 0xbb33, 0x41fc, 0x0, 0x0, 0xbb33, 0x41f3,
    0x0, 0x0, 0xbb33, 0x41eb, 0x0, 0x0, 0xbb33, 0x41e3,
    0x0, 0x0, 0xbb33, 0x41da, 0x0, 0x0, 0xbb33, 0x41d2,
    0x0, 0x0, 0xbb33, 0x41ca, 0x0, 0x0, 0xbb33, 0x41c2,
    0x0, 0x0, 0xbb33, 0x41ba, 0x0, 0x0, 0xbb33, 0x41b2,
    0x0, 0x0, 0xbb33, 0x41ab, 0x0, 0x0, 0xbb33, 0x41a3,
    0x0, 0x0, 0xbb33, 0x419b, 0x0, 0x0, 0xbb33, 0x4194,
    0x0, 0x0, 0xbb33, 0x418c, 0x0, 0x0, 0xbb33, 0x4185,
    0x0, 0x0, 0xbb33, 0x417e, 0x0, 0x0, 0xbb33, 0x4176,
    0x0, 0x0, 0xbb33, 0x416f, 0x0, 0x0, 0xbb33, 0x4168,
    0x0, 0x0, 0xbb33, 0x4161, 0x0, 0x0, 0xbb33, 0x415a,
    0x0, 0x0, 0xbb33, 0x4153, 0x0, 0x0, 0xbb33, 0x414c,
    0x0, 0x0, 0xbb33, 0x4146, 0x0, 0x0, 0xbb33, 0x413f,
    0x0, 0x0, 0xbb33, 0x4138, 0x0, 0x0, 0xbb33, 0x4131,
    0x0, 0x0, 0xbb33, 0x412b, 0x0, 0x0, 0xbb33, 0x4124,
    0x0, 0x0, 0xbb33, 0x411e, 0x0, 0x0, 0xbb33, 0x4118,
    0x0, 0x0, 0xbb33, 0x4111, 0x0, 0x0, 0xbb33, 0x410b,
    0x0, 0x0, 0xbb33, 0x4105, 0x0, 0x0, 0xbb33, 0x40ff,
    0x0, 0x0, 0xbb33, 0x40f8, 0x0, 0x0, 0xbb33, 0x40f2,
    0x0, 0x0, 0xbb33, 0x40ec, 0x0, 0x0, 0xbb33, 0x40e6,
    0x0, 0x0, 0xbb33, 0x40e0, 0x0, 0x0, 0xbb33, 0x40db,
    0x0, 0x0, 0xbb33, 0x40d5, 0x0, 0x0, 0xbb33, 0x40cf,
    0x0, 0x0, 0xbb33, 0x40c9, 0x0, 0x0, 0xbb33, 0x40c4,
    0x0, 0x0, 0xbb33, 0x40be, 0x0, 0x0, 0xbb33, 0x40b8,
    0x0, 0x0, 0xbb33, 0x40b3, 0x0, 0x0, 0xbb33, 0x40ad,
    0x0, 0x0, 0xbb33, 0x40a8, 0x0, 0x0, 0xbb33, 0x40a2,
    0x0, 0x0, 0xbb33, 0x409d, 0x0, 0x0, 0xbb33, 0x4098,
    0x0, 0x0, 0xbb33, 0x4092, 0x0, 0x0, 0xbb33, 0x408d,
    0x0, 0x0, 0xbb33, 0x4088, 0x0, 0x0, 0xbb33, 0x4083,
    0x0, 0x0, 0xbb33, 0x407e, 0x0, 0x0, 0xbb33, 0x4079,
    0x0, 0x0, 0xbb33, 0x4074, 0x0, 0x0, 0xbb33, 0x406f,
    0x0, 0x0, 0xbb33, 0x406a, 0x0, 0x0, 0xbb33, 0x4065,
    0x0, 0x0, 0xbb33, 0x4060, 0x0, 0x0, 0xbb33, 0x405b,
    0x0, 0x0, 0xbb33, 0x4056, 0x0, 0x0, 0xbb33, 0x4051,
    0x0, 0x0, 0xbb33, 0x404d, 0x0, 0x0, 0xbb33, 0x4048,
    0x0, 0x0, 0xbb33, 0x4043, 0x0, 0x0, 0xbb33, 0x403e,
    0x0, 0x0, 0xbb33, 0x403a, 0x0, 0x0, 0xbb33, 0x4035,
    0x0, 0x0, 0xbb33, 0x4031, 0x0, 0x0, 0xbb33, 0x402c,
    0x0, 0x0, 0xbb33, 0x4028, 0x0, 0x0, 0xbb33, 0x4023,
    0x0, 0x0, 0xbb33, 0x401f, 0x0, 0x0, 0xbb33, 0x401a,
    0x0, 0x0, 0xbb33, 0x4016, 0x0, 0x0, 0xbb33, 0x4012,
    0x0, 0x0, 0xbb33, 0x400d, 0x0, 0x0, 0xbb33, 0x4009,
    0x0, 0x0, 0xbb33, 0x4005, 0x0, 0x0, 0xbb33, 0x4001,
    0x0, 0x0, 0xbb33, 0x3ff9, 0x0, 0x0, 0xbb33, 0x3ff1,
    0x0, 0x0, 0xbb33, 0x3fe8, 0x0, 0x0, 0xbb33, 0x3fe0,
    0x0, 0x0, 0xbb33, 0x3fd8, 0x0, 0x0, 0xbb33, 0x3fd0,
    0x0, 0x0, 0xbb33, 0x3fc8, 0x0, 0x0, 0xbb33, 0x3fc0,
    0x0, 0x0, 0xbb33, 0x3fb8, 0x0, 0x0, 0xbb33, 0x3fb0,
    0x0, 0x0, 0xbb33, 0x3fa8, 0x0, 0x0, 0xbb33, 0x3fa0,
    0x0, 0x0, 0xbb33, 0x3f99, 0x0, 0x0, 0xbb33, 0x3f91,
    0x0, 0x0, 0xbb33, 0x3f89, 0x0, 0x0, 0xbb33, 0x3f82,
    0x0, 0x0, 0xbb33, 0x3f7a, 0x0, 0x0, 0xbb33, 0x3f73,
    0x0, 0x0, 0xbb33, 0x3f6b, 0x0, 0x0, 0xbb33, 0x3f64,
    0x0, 0x0, 0xbb33, 0x3f5d, 0x0, 0x0, 0xbb33, 0x3f55,
    0x0, 0x0, 0xbb33, 0x3f4e, 0x0, 0x0, 0xbb33, 0x3f47,
    0x0, 0x0, 0xbb33, 0x3f40, 0x0, 0x0, 0xbb33, 0x3f39,
    0x0, 0x0, 0xbb33, 0x3f31, 0x0, 0x0, 0xbb33, 0x3f2a,
    0x0, 0x0, 0xbb33, 0x3f23, 0x0, 0x0, 0xbb33, 0x3f1c,
    0x0, 0x0, 0xbb33, 0x3f16, 0x0, 0x0, 0xbb33, 0x3f0f,
    0x0, 0x0, 0xbb33, 0x3f08, 0x0, 0x0, 0xbb33, 0x3f01,
    0x0, 0x0, 0xbb33, 0x3efa, 0x0, 0x0, 0xbb33, 0x3ef4,
    0x0, 0x0, 0xbb33, 0x3eed, 0x0, 0x0, 0xbb33, 0x3ee6,
    0x0, 0x0, 0xbb33, 0x3ee0, 0x0, 0x0, 0xbb33, 0x3ed9,
    0x0, 0x0, 0xbb33, 0x3ed3, 0x0, 0x0, 0xbb33, 0x3ecc,
    0x0, 0x0, 0xbb33, 0x3ec6, 0x0, 0x0, 0xbb33, 0x3ebf,
    0x0, 0x0, 0xbb33, 0x3eb9, 0x0, 0x0, 0xbb33, 0x3eb3,
    0x0, 0x0, 0xbb33, 0x3eac, 0x0, 0x0, 0xbb33, 0x3ea6,
    0x0, 0x0, 0xbb33, 0x3ea0, 0x0, 0x0, 0xbb33, 0x3e9a,
    0x0, 0x0, 0xbb33, 0x3e94, 0x0, 0x0, 0xbb33, 0x3e8d,
    0x0, 0x0, 0xbb33, 0x3e87, 0x0, 0x0, 0xbb33, 0x3e81,
    0x0, 0x0, 0xbb33, 0x3e7b, 0x0, 0x0, 0xbb33, 0x3e75,
    0x0, 0x0, 0xbb33, 0x3e6f, 0x0, 0x0, 0xbb33, 0x3e69,
    0x0, 0x0, 0xbb33, 0x3e64, 0x0, 0x0, 0xbb33, 0x3e5e,
    0x0, 0x0, 0xbb33, 0x3e58, 0x0, 0x0, 0xbb33, 0x3e52,
    0x0, 0x0, 0xbb33, 0x3e4c, 0x0, 0x0, 0xbb33, 0x3e47,
    0x0, 0x0, 0xbb33, 0x3e41, 0x0, 0x0, 0xbb33, 0x3e3b,
    0x0, 0x0, 0xbb33, 0x3e36, 0x0, 0x0, 0xbb33, 0x3e30,
    0x0, 0x0, 0xbb33, 0x3e2b, 0x0, 0x0, 0xbb33, 0x3e25,
    0x0, 0x0, 0xbb33, 0x3e1f, 0x0, 0x0, 0xbb33, 0x3e1a,
    0x0, 0x0, 0xbb33, 0x3e14, 0x0, 0x0, 0xbb33, 0x3e0f,
    0x0, 0x0, 0xbb33, 0x3e0a, 0x0, 0x0, 0xbb33, 0x3e04,
    0x0, 0x0, 0xbb33, 0x3dff, 0x0, 0x0, 0xbb33, 0x3dfa,
    0x0, 0x0, 0xbb33, 0x3df4, 0x0, 0x0, 0xbb33, 0x3def,
    0x0, 0x0, 0xbb33, 0x3dea, 0x0, 0x0, 0xbb33, 0x3de5,
    0x0, 0x0, 0xbb33, 0x3ddf, 0x0, 0x0, 0xbb33, 0x3dda,
    0x0, 0x0, 0xbb33, 0x3dd5, 0x0, 0x0, 0xbb33, 0x3dd0,
    0x0, 0x0, 0xbb33, 0x3dcb, 0x0, 0x0, 0xbb33, 0x3dc6,
    0x0, 0x0, 0xbb33, 0x3dc1, 0x0, 0x0, 0xbb33, 0x3dbc,
    0x0, 0x0, 0xbb33, 0x3db7, 0x0, 0x0, 0xbb33, 0x3db2,
    0x0, 0x0, 0xbb33, 0x3dad, 0x0, 0x0, 0xbb33, 0x3da8,
    0x0, 0x0, 0xbb33, 0x3da3, 0x0, 0x0, 0xbb33, 0x3d9e,
    0x0, 0x0, 0xbb33, 0x3d99, 0x0, 0x0, 0xbb33, 0x3d95,
    0x0, 0x0, 0xbb33, 0x3d90, 0x0, 0x0, 0xbb33, 0x3d8b,
    0x0, 0x0, 0xbb33, 0x3d86, 0x0, 0x0, 0xbb33, 0x3d81,
    0x0, 0x0, 0xbb33, 0x3d7d, 0x0, 0x0, 0xbb33, 0x3d78,
    0x0, 0x0, 0xbb33, 0x3d73, 0x0, 0x0, 0xbb33, 0x3d6f,
    0x0, 0x0, 0xbb33, 0x3d6a, 0x0, 0x0, 0xbb33, 0x3d66,
    0x0, 0x0, 0xbb33, 0x3d61, 0x0, 0x0, 0xbb33, 0x3d5c,
    0x0, 0x0, 0xbb33, 0x3d58, 0x0, 0x0, 0xbb33, 0x3d53,
    0x0, 0x0, 0xbb33, 0x3d4f, 0x0, 0x0, 0xbb33, 0x3d4a,
    0x0, 0x0, 0xbb33, 0x3d46, 0x0, 0x0, 0xbb33, 0x3d42,
    0x0, 0x0, 0xbb33, 0x3d3d, 0x0, 0x0, 0xbb33, 0x3d39,
    0x0, 0x0, 0xbb33, 0x3d34, 0x0, 0x0, 0xbb33, 0x3d30,
    0x0, 0x0, 0xbb33, 0x3d2c, 0x0, 0x0, 0xbb33, 0x3d27,
    0x0, 0x0, 0xbb33, 0x3d23, 0x0, 0x0, 0xbb33, 0x3d1f,
    0x0, 0x0, 0xbb33, 0x3d1a, 0x0, 0x0, 0xbb33, 0x3d16,
    0x0, 0x0, 0xbb33, 0x3d12, 0x0, 0x0, 0xbb33, 0x3d0e,
    0x0, 0x0, 0xbb33, 0x3d0a, 0x0, 0x0, 0xbb33, 0x3d05,
    0x0, 0x0, 0xbb33, 0x3d01, 0x0, 0x0, 0xbb33, 0x3cfd,
    0x0, 0x0, 0xbb33, 0x3cf9, 0x0, 0x0, 0xbb33, 0x3cf5,
    0x0, 0x0, 0xbb33, 0x3cf1, 0x0, 0x0, 0xbb33, 0x3ced,
    0x0, 0x0, 0xbb33, 0x3ce9, 0x0, 0x0, 0xbb33, 0x3ce5,
    0x0, 0x0, 0xbb33, 0x3ce1, 0x0, 0x0, 0xbb33, 0x3cdd,
    0x0, 0x0, 0xbb33, 0x3cd9, 0x0, 0x0, 0xbb33, 0x3cd5,
    0x0, 0x0, 0xbb33, 0x3cd1, 0x0, 0x0, 0xbb33, 0x3ccd,
    0x0, 0x0, 0xbb33, 0x3cc9, 0x0, 0x0, 0xbb33, 0x3cc5,
    0x0, 0x0, 0xbb33, 0x3cc1, 0x0, 0x0, 0xbb33, 0x3cbd,
    0x0, 0x0, 0xbb33, 0x3cb9, 0x0, 0x0, 0xbb33, 0x3cb6,
    0x0, 0x0, 0xbb33, 0x3cb2, 0x0, 0x0, 0xbb33, 0x3cae,
    0x0, 0x0, 0xbb33, 0x3caa, 0x0, 0x0, 0xbb33, 0x3ca6,
    0x0, 0x0, 0xbb33, 0x3ca3, 0x0, 0x0, 0xbb33, 0x3c9f,
    0x0, 0x0, 0xbb33, 0x3c9b, 0x0, 0x0, 0xbb33, 0x3c97,
    0x0, 0x0, 0xbb33, 0x3c94, 0x0, 0x0, 0xbb33, 0x3c90,
    0x0, 0x0, 0xbb33, 0x3c8c, 0x0, 0x0, 0xbb33, 0x3c89,
    0x0, 0x0, 0xbb33, 0x3c85, 0x0, 0x0, 0xbb33, 0x3c81,
    0x0, 0x0, 0xbb33, 0x3c7e, 0x0, 0x0, 0xbb33, 0x3c7a,
    0x0, 0x0, 0xbb33, 0x3c76, 0x0, 0x0, 0xbb33, 0x3c73,
    0x0, 0x0, 0xbb33, 0x3c6f, 0x0, 0x0, 0xbb33, 0x3c6c,
    0x0, 0x0, 0xbb33, 0x3c68, 0x0, 0x0, 0xbb33, 0x3c65,
    0x0, 0x0, 0xbb33, 0x3c61, 0x0, 0x0, 0xbb33, 0x3c5e,
    0x0, 0x0, 0xbb33, 0x3c5a, 0x0, 0x0, 0xbb33, 0x3c57,
    0x0, 0x0, 0xbb33, 0x3c53, 0x0, 0x0, 0xbb33, 0x3c50,
    0x0, 0x0, 0xbb33, 0x3c4c, 0x0, 0x0, 0xbb33, 0x3c49,
    0x0, 0x0, 0xbb33, 0x3c46, 0x0, 0x0, 0xbb33, 0x3c42,
    0x0, 0x0, 0xbb33, 0x3c3f, 0x0, 0x0, 0xbb33, 0x3c3b,
    0x0, 0x0, 0xbb33, 0x3c38, 0x0, 0x0, 0xbb33, 0x3c35,
    0x0, 0x0, 0xbb33, 0x3c31, 0x0, 0x0, 0xbb33, 0x3c2e,
    0x0, 0x0, 0xbb33, 0x3c2b, 0x0, 0x0, 0xbb33, 0x3c27,
    0x0, 0x0, 0xbb33, 0x3c24, 0x0, 0x0, 0xbb33, 0x3c21,
    0x0, 0x0, 0xbb33, 0x3c1e, 0x0, 0x0, 0xbb33, 0x3c1a,
    0x0, 0x0, 0xbb33, 0x3c17, 0x0, 0x0, 0xbb33, 0x3c14,
    0x0, 0x0, 0xbb33, 0x3c11, 0x0, 0x0, 0xbb33, 0x3c0d,
    0x0, 0x0, 0xbb33, 0x3c0a, 0x0, 0x0, 0xbb33, 0x3c07,
    0x0, 0x0, 0xbb33, 0x3c04, 0x0, 0x0, 0xbb33, 0x3c01,
    0x0, 0x0, 0xbb33, 0x3bfb, 0x0, 0x0, 0xbb33, 0x3bf5,
    0x0, 0x0, 0xbb33, 0x3bef, 0x0, 0x0, 0xbb33, 0x3be8,
    0x0, 0x0, 0xbb33, 0x3be2, 0x0, 0x0, 0xbb33, 0x3bdc,
    0x0, 0x0, 0xbb33, 0x3bd6, 0x0, 0x0, 0xbb33, 0x3bcf,
    0x0, 0x0, 0xbb33, 0x3bc9, 0x0, 0x0, 0xbb33, 0x3bc3,
    0x0, 0x0, 0xbb33, 0x3bbd, 0x0, 0x0, 0xbb33, 0x3bb7,
    0x0, 0x0, 0xbb33, 0x3bb1, 0x0, 0x0, 0xbb33, 0x3bab,
    0x0, 0x0, 0xbb33, 0x3ba5, 0x0, 0x0, 0xbb33, 0x3b9f,
    0x0, 0x0, 0xbb33, 0x3b99, 0x0, 0x0, 0xbb33, 0x3b93,
    0x0, 0x0, 0xbb33, 0x3b8d, 0x0, 0x0, 0xbb33, 0x3b87,
    0x0, 0x0, 0xbb33, 0x3b81, 0x0, 0x0, 0xbb33, 0x3b7b,
    0x0, 0x0, 0xbb33, 0x3b75, 0x0, 0x0, 0xbb33, 0x3b70,
    0x0, 0x0, 0xbb33, 0x3b6a, 0x0, 0x0, 0xbb33, 0x3b64,
    0x0, 0x0, 0xbb33, 0x3b5e, 0x0, 0x0, 0xbb33, 0x3b58,
    0x0, 0x0, 0xbb33, 0x3b53, 0x0, 0x0, 0xbb33, 0x3b4d,
    0x0, 0x0, 0xbb33, 0x3b47, 0x0, 0x0, 0xbb33, 0x3b41,
    0x0, 0x0, 0xbb33, 0x3b3c, 0x0, 0x0, 0xbb33, 0x3b36,
    0x0, 0x0, 0xbb33, 0x3b30, 0x0, 0x0, 0xbb33, 0x3b2b,
    0x0, 0x0, 0xbb33, 0x3b25, 0x0, 0x0, 0xbb33, 0x3b20,
    0x0, 0x0, 0xbb33, 0x3b1a, 0x0, 0x0, 0xbb33, 0x3b14,
    0x0, 0x0, 0xbb33, 0x3b0f, 0x0, 0x0, 0xbb33, 0x3b09,
    0x0, 0x0, 0xbb33, 0x3b04, 0x0, 0x0, 0xbb33, 0x3afe,
    0x0, 0x0, 0xbb33, 0x3af9, 0x0, 0x0, 0xbb33, 0x3af3,
    0x0, 0x0, 0xbb33, 0x3aee, 0x0, 0x0, 0xbb33, 0x3ae8,
    0x0, 0x0, 0xbb33, 0x3ae3, 0x0, 0x0, 0xbb33, 0x3ade,
    0x0, 0x0, 0xbb33, 0x3ad8, 0x0, 0x0, 0xbb33, 0x3ad3,
    0x0, 0x0, 0xbb33, 0x3acd, 0x0, 0x0, 0xbb33, 0x3ac8,
    0x0, 0x0, 0xbb33, 0x3ac3, 0x0, 0x0, 0xbb33, 0x3abd,
    0x0, 0x0, 0xbb33, 0x3ab8, 0x0, 0x0, 0xbb33, 0x3ab3,
    0x0, 0x0, 0xbb33, 0x3aae, 0x0, 0x0, 0xbb33, 0x3aa8,
    0x0, 0x0, 0xbb33, 0x3aa3, 0x0, 0x0, 0xbb33, 0x3a9e,
    0x0, 0x0, 0xbb33, 0x3a99, 0x0, 0x0, 0xbb33, 0x3a93,
    0x0, 0x0, 0xbb33, 0x3a8e, 0x0, 0x0, 0xbb33, 0x3a89,
    0x0, 0x0, 0xbb33, 0x3a84, 0x0, 0x0, 0xbb33, 0x3a7f,
    0x0, 0x0, 0xbb33, 0x3a7a, 0x0, 0x0, 0xbb33, 0x3a75,
    0x0, 0x0, 0xbb33, 0x3a70, 0x0, 0x0, 0xbb33, 0x3a6a,
    0x0, 0x0, 0xbb33, 0x3a65, 0x0, 0x0, 0xbb33, 0x3a60,
    0x0, 0x0, 0xbb33, 0x3a5b, 0x0, 0x0, 0xbb33, 0x3a56,
    0x0, 0x0, 0xbb33, 0x3a51, 0x0, 0x0, 0xbb33, 0x3a4c,
    0x0, 0x0, 0xbb33, 0x3a47, 0x0, 0x0, 0xbb33, 0x3a42,
    0x0, 0x0, 0xbb33, 0x3a3d, 0x0, 0x0, 0xbb33, 0x3a38,
    0x0, 0x0, 0xbb33, 0x3a33, 0x0, 0x0, 0xbb33, 0x3a2f,
    0x0, 0x0, 0xbb33, 0x3a2a, 0x0, 0x0, 0xbb33, 0x3a25,
    0x0, 0x0, 0xbb33, 0x3a20, 0x0, 0x0, 0xbb33, 0x3a1b,
    0x0, 0x0, 0xbb33, 0x3a16, 0x0, 0x0, 0xbb33, 0x3a11,
    0x0, 0x0, 0xbb33, 0x3a0d, 0x0, 0x0, 0xbb33, 0x3a08,
    0x0, 0x0, 0xbb33, 0x3a03, 0x0, 0x0, 0xbb33, 0x39fe,
    0x0, 0x0, 0xbb33, 0x39f9, 0x0, 0x0, 0xbb33, 0x39f5,
    0x0, 0x0, 0xbb33, 0x39f0, 0x0, 0x0, 0xbb33, 0x39eb,
    0x0, 0x0, 0xbb33, 0x39e6, 0x0, 0x0, 0xbb33, 0x39e2,
    0x0, 0x0, 0xbb33, 0x39dd, 0x0, 0x0, 0xbb33, 0x39d8,
    0x0, 0x0, 0xbb33, 0x39d4, 0x0, 0x0, 0xbb33, 0x39cf,
    0x0, 0x0, 0xbb33, 0x39ca, 0x0, 0x0, 0xbb33, 0x39c6,
    0x0, 0x0, 0xbb33, 0x39c1, 0x0, 0x0, 0xbb33, 0x39bc,
    0x0, 0x0, 0xbb33, 0x39b8, 0x0, 0x0, 0xbb33, 0x39b3,
    0x0, 0x0, 0xbb33, 0x39ae, 0x0, 0x0, 0xbb33, 0x39aa,
    0x0, 0x0, 0xbb33, 0x39a5, 0x0, 0x0, 0xbb33, 0x39a1,
    0x0, 0x0, 0xbb33, 0x399c, 0x0, 0x0, 0xbb33, 0x3998,
    0x0, 0x0, 0xbb33, 0x3993, 0x0, 0x0, 0xbb33, 0x398f,
    0x0, 0x0, 0xbb33, 0x398a, 0x0, 0x0, 0xbb33, 0x3986,
    0x0, 0x0, 0xbb33, 0x3981, 0x0, 0x0, 0xbb33, 0x397d,
    0x0, 0x0, 0xbb33, 0x3978, 0x0, 0x0, 0xbb33, 0x3974,
    0x0, 0x0, 0xbb33, 0x396f, 0x0, 0x0, 0xbb33, 0x396b,
    0x0, 0x0, 0xbb33, 0x3966, 0x0, 0x0, 0xbb33, 0x3962,
    0x0, 0x0, 0xbb33, 0x395e, 0x0, 0x0, 0xbb33, 0x3959,
    0x0, 0x0, 0xbb33, 0x3955, 0x0, 0x0, 0xbb33, 0x3950,
    0x0, 0x0, 0xbb33, 0x394c, 0x0, 0x0, 0xbb33, 0x3948,
    0x0, 0x0, 0xbb33, 0x3943, 0x0, 0x0, 0xbb33, 0x393f,
    0x0, 0x0, 0xbb33, 0x393b, 0x0, 0x0, 0xbb33, 0x3936,
    0x0, 0x0, 0xbb33, 0x3932, 0x0, 0x0, 0xbb33, 0x392e,
    0x0, 0x0, 0xbb33, 0x392a, 0x0, 0x0, 0xbb33, 0x3925,
    0x0, 0x0, 0xbb33, 0x3921, 0x0, 0x0, 0xbb33, 0x391d,
    0x0, 0x0, 0xbb33, 0x3918, 0x0, 0x0, 0xbb33, 0x3914,
    0x0, 0x0, 0xbb33, 0x3910, 0x0, 0x0, 0xbb33, 0x390c,
    0x0, 0x0, 0xbb33, 0x3908, 0x0, 0x0, 0xbb33, 0x3903,
    0x0, 0x0, 0xbb33, 0x38ff, 0x0, 0x0, 0xbb33, 0x38fb,
    0x0, 0x0, 0xbb33, 0x38f7, 0x0, 0x0, 0xbb33, 0x38f3,
    0x0, 0x0, 0xbb33, 0x38ee, 0x0, 0x0, 0xbb33, 0x38ea,
    0x0, 0x0, 0xbb33, 0x38e6, 0x0, 0x0, 0xbb33, 0x38e2,
    0x0, 0x0, 0xbb33, 0x38de, 0x0, 0x0, 0xbb33, 0x38da,
    0x0, 0x0, 0xbb33, 0x38d6, 0x0, 0x0, 0xbb33, 0x38d2,
    0x0, 0x0, 0xbb33, 0x38ce, 0x0, 0x0, 0xbb33, 0x38c9,
    0x0, 0x0, 0xbb33, 0x38c5, 0x0, 0x0, 0xbb33, 0x38c1,
    0x0, 0x0, 0xbb33, 0x38bd, 0x0, 0x0, 0xbb33, 0x38b9,
    0x0, 0x0, 0xbb33, 0x38b5, 0x0, 0x0, 0xbb33, 0x38b1,
    0x0, 0x0, 0xbb33, 0x38ad, 0x0, 0x0, 0xbb33, 0x38a9,
    0x0, 0x0, 0xbb33, 0x38a5, 0x0, 0x0, 0xbb33, 0x38a1,
    0x0, 0x0, 0xbb33, 0x389d, 0x0, 0x0, 0xbb33, 0x3899,
    0x0, 0x0, 0xbb33, 0x3895, 0x0, 0x0, 0xbb33, 0x3891,
    0x0, 0x0, 0xbb33, 0x388d, 0x0, 0x0, 0xbb33, 0x3889,
    0x0, 0x0, 0xbb33, 0x3885, 0x0, 0x0, 0xbb33, 0x3881,
    0x0, 0x0, 0xbb33, 0x387d, 0x0, 0x0, 0xbb33, 0x387a,
    0x0, 0x0, 0xbb33, 0x3876, 0x0, 0x0, 0xbb33, 0x3872,
    0x0, 0x0, 0xbb33, 0x386e, 0x0, 0x0, 0xbb33, 0x386a,
    0x0, 0x0, 0xbb33, 0x3866, 0x0, 0x0, 0xbb33, 0x3862,
    0x0, 0x0, 0xbb33, 0x385e, 0x0, 0x0, 0xbb33, 0x385a,
    0x0, 0x0, 0xbb33, 0x3857, 0x0, 0x0, 0xbb33, 0x3853,
    0x0, 0x0, 0xbb33, 0x384f, 0x0, 0x0, 0xbb33, 0x384b,
    0x0, 0x0, 0xbb33, 0x3847, 0x0, 0x0, 0xbb33, 0x3843,
    0x0, 0x0, 0xbb33, 0x3840, 0x0, 0x0, 0xbb33, 0x383c,
    0x0, 0x0, 0xbb33, 0x3838, 0x0, 0x0, 0xbb33, 0x3834,
    0x0, 0x0, 0xbb33, 0x3830, 0x0, 0x0, 0xbb33, 0x382d,
    0x0, 0x0, 0xbb33, 0x3829, 0x0, 0x0, 0xbb33, 0x3825,
    0x0, 0x0, 0xbb33, 0x3821, 0x0, 0x0, 0xbb33, 0x381e,
    0x0, 0x0, 0xbb33, 0x381a, 0x0, 0x0, 0xbb33, 0x3816,
    0x0, 0x0, 0xbb33, 0x3812, 0x0, 0x0, 0xbb33, 0x380f,
    0x0, 0x0, 0xbb33, 0x380b, 0x0, 0x0, 0xbb33, 0x3807,
    0x0, 0x0, 0xbb33, 0x3803, 0x0, 0x0, 0xbb33, 0x37ff,
    0x0, 0x0, 0xbb33, 0x37f8, 0x0, 0x0, 0xbb33, 0x37f1,
    0x0, 0x0, 0xbb33, 0x37e9, 0x0, 0x0, 0xbb33, 0x37e2,
    0x0, 0x0, 0xbb33, 0x37db, 0x0, 0x0, 0xbb33, 0x37d3,
    0x0, 0x0, 0xbb33, 0x37cc, 0x0, 0x0, 0xbb33, 0x37c5,
    0x0, 0x0, 0xbb33, 0x37bd, 0x0, 0x0, 0xbb33, 0x37b6,
    0x0, 0x0, 0xbb33, 0x37af, 0x0, 0x0, 0xbb33, 0x37a8,
    0x0, 0x0, 0xbb33, 0x37a0, 0x0, 0x0, 0xbb33, 0x3799,
    0x0, 0x0, 0xbb33, 0x3792, 0x0, 0x0, 0xbb33, 0x378b,
    0x0, 0x0, 0xbb33, 0x3783, 0x0, 0x0, 0xbb33, 0x377c,
    0x0, 0x0, 0xbb33, 0x3775, 0x0, 0x0, 0xbb33, 0x376e,
    0x0, 0x0, 0xbb33, 0x3767, 0x0, 0x0, 0xbb33, 0x3760,
    0x0, 0x0, 0xbb33, 0x3758, 0x0, 0x0, 0xbb33, 0x3751,
    0x0, 0x0, 0xbb33, 0x374a, 0x0, 0x0, 0xbb33, 0x3743,
    0x0, 0x0, 0xbb33, 0x373c, 0x0, 0x0, 0xbb33, 0x3735,
    0x0, 0x0, 0xbb33, 0x372e, 0x0, 0x0, 0xbb33, 0x3727,
    0x0, 0x0, 0xbb33, 0x3720, 0x0, 0x0, 0xbb33, 0x3719,
    0x0, 0x0, 0xbb33, 0x3712, 0x0, 0x0, 0xbb33, 0x370b,
    0x0, 0x0, 0xbb33, 0x3704, 0x0, 0x0, 0xbb33, 0x36fd,
    0x0, 0x0, 0xbb33, 0x36f6, 0x0, 0x0, 0xbb33, 0x36ef,
    0x0, 0x0, 0xbb33, 0x36e8, 0x0, 0x0, 0xbb33, 0x36e1,
    0x0, 0x0, 0xbb33, 0x36da, 0x0, 0x0, 0xbb33, 0x36d3,
    0x0, 0x0, 0xbb33, 0x36cc, 0x0, 0x0, 0xbb33, 0x36c5,
    0x0, 0x0, 0xbb33, 0x36be, 0x0, 0x0, 0xbb33, 0x36b7,
    0x0, 0x0, 0xbb33, 0x36b0, 0x0, 0x0, 0xbb33, 0x36aa,
    0x0, 0x0, 0xbb33, 0x36a3, 0x0, 0x0, 0xbb33, 0x369c,
    0x0, 0x0, 0xbb33, 0x3695, 0x0, 0x0, 0xbb33, 0x368e,
    0x0, 0x0, 0xbb33, 0x3687, 0x0, 0x0, 0xbb33, 0x3681,
    0x0, 0x0, 0xbb33, 0x367a, 0x0, 0x0, 0xbb33, 0x3673,
    0x0, 0x0, 0xbb33, 0x366c, 0x0, 0x0, 0xbb33, 0x3665,
    0x0, 0x0, 0xbb33, 0x365f, 0x0, 0x0, 0xbb33, 0x3658,
    0x0, 0x0, 0xbb33, 0x3651, 0x0, 0x0, 0xbb33, 0x364a,
    0x0, 0x0, 0xbb33, 0x3644, 0x0, 0x0, 0xbb33, 0x363d,
    0x0, 0x0, 0xbb33, 0x3636, 0x0, 0x0, 0xbb33, 0x3630,
    0x0, 0x0, 0xbb33, 0x3629, 0x0, 0x0, 0xbb33, 0x3622,
    0x0, 0x0, 0xbb33, 0x361c, 0x0, 0x0, 0xbb33, 0x3615,
    0x0, 0x0, 0xbb33, 0x360e, 0x0, 0x0, 0xbb33, 0x3608,
    0x0, 0x0, 0xbb33, 0x3601, 0x0, 0x0, 0xbb33, 0x35fa,
    0x0, 0x0, 0xbb33, 0x35f4, 0x0, 0x0, 0xbb33, 0x35ed,
    0x0, 0x0, 0xbb33, 0x35e6, 0x0, 0x0, 0xbb33, 0x35e0,
    0x0, 0x0, 0xbb33, 0x35d9, 0x0, 0x0, 0xbb33, 0x35d3,
    0x0, 0x0, 0xbb33, 0x35cc, 0x0, 0x0, 0xbb33, 0x35c6,
    0x0, 0x0, 0xbb33, 0x35bf, 0x0, 0x0, 0xbb33, 0x35b8,
    0x0, 0x0, 0xbb33, 0x35b2, 0x0, 0x0, 0xbb33, 0x35ab,
    0x0, 0x0, 0xbb33, 0x35a5, 0x0, 0x0, 0xbb33, 0x359e,
    0x0, 0x0, 0xbb33, 0x3598, 0x0, 0x0, 0xbb33, 0x3591,
    0x0, 0x0, 0xbb33, 0x358b, 0x0, 0x0, 0xbb33, 0x3584,
    0x0, 0x0, 0xbb33, 0x357e, 0x0, 0x0, 0xbb33, 0x3577,
    0x0, 0x0, 0xbb33, 0x3571, 0x0, 0x0, 0xbb33, 0x356a,
    0x0, 0x0, 0xbb33, 0x3564, 0x0, 0x0, 0xbb33, 0x355d,
    0x0, 0x0, 0xbb33, 0x3557, 0x0, 0x0, 0xbb33, 0x3551,
    0x0, 0x0, 0xbb33, 0x354a, 0x0, 0x0, 0xbb33, 0x3544,
    0x0, 0x0, 0xbb33, 0x353d, 0x0, 0x0, 0xbb33, 0x3537,
    0x0, 0x0, 0xbb33, 0x3531, 0x0, 0x0, 0xbb33, 0x352a,
    0x0, 0x0, 0xbb33, 0x3524, 0x0, 0x0, 0xbb33, 0x351d,
    0x0, 0x0, 0xbb33, 0x3517, 0x0, 0x0, 0xbb33, 0x3511,
    0x0, 0x0, 0xbb33, 0x350a, 0x0, 0x0, 0xbb33, 0x3504,
    0x0, 0x0, 0xbb33, 0x34fe, 0x0, 0x0, 0xbb33, 0x34f7,
    0x0, 0x0, 0xbb33, 0x34f1, 0x0, 0x0, 0xbb33, 0x34eb,
    0x0, 0x0, 0xbb33, 0x34e4, 0x0, 0x0, 0xbb33, 0x34de,
    0x0, 0x0, 0xbb33, 0x34d8, 0x0, 0x0, 0xbb33, 0x34d2,
    0x0, 0x0, 0xbb33, 0x34cb, 0x0, 0x0, 0xbb33, 0x34c5,
    0x0, 0x0, 0xbb33, 0x34bf, 0x0, 0x0, 0xbb33, 0x34b8,
    0x0, 0x0, 0xbb33, 0x34b2, 0x0, 0x0, 0xbb33, 0x34ac,
    0x0, 0x0, 0xbb33, 0x34a6, 0x0, 0x0, 0xbb33, 0x349f,
    0x0, 0x0, 0xbb33, 0x3499, 0x0, 0x0, 0xbb33, 0x3493,
    0x0, 0x0, 0xbb33, 0x348d, 0x0, 0x0, 0xbb33, 0x3487,
    0x0, 0x0, 0xbb33, 0x3480, 0x0, 0x0, 0xbb33, 0x347a,
    0x0, 0x0, 0xbb33, 0x3474, 0x0, 0x0, 0xbb33, 0x346e,
    0x0, 0x0, 0xbb33, 0x3468, 0x0, 0x0, 0xbb33, 0x3461,
    0x0, 0x0, 0xbb33, 0x345b, 0x0, 0x0, 0xbb33, 0x3455,
    0x0, 0x0, 0xbb33, 0x344f, 0x0, 0x0, 0xbb33, 0x3449,
    0x0, 0x0, 0xbb33, 0x3443, 0x0, 0x0, 0xbb33, 0x343c,
    0x0, 0x0, 0xbb33, 0x3436, 0x0, 0x0, 0xbb33, 0x3430,
    0x0, 0x0, 0xbb33, 0x342a, 0x0, 0x0, 0xbb33, 0x3424,
    0x0, 0x0, 0xbb33, 0x341e, 0x0, 0x0, 0xbb33, 0x3418,
    0x0, 0x0, 0xbb33, 0x3412, 0x0, 0x0, 0xbb33, 0x340b,
    0x0, 0x0, 0xbb33, 0x3405, 0x0, 0x0, 0xbb33, 0x33fe,
    0x0, 0x0, 0xbb33, 0x33f2, 0x0, 0x0, 0xbb33, 0x33e6,
    0x0, 0x0, 0xbb33, 0x33da, 0x0, 0x0, 0xbb33, 0x33ce,
    0x0, 0x0, 0xbb33, 0x33c2, 0x0, 0x0, 0xbb33, 0x33b6,
    0x0, 0x0, 0xbb33, 0x33a9, 0x0, 0x0, 0xbb33, 0x339d,
    0x0, 0x0, 0xbb33, 0x3391, 0x0, 0x0, 0xbb33, 0x3385,
    0x0, 0x0, 0xbb33, 0x3379, 0x0, 0x0, 0xbb33, 0x336d,
    0x0, 0x0, 0xbb33, 0x3361, 0x0, 0x0, 0xbb33, 0x3355,
    0x0, 0x0, 0xbb33, 0x3349, 0x0, 0x0, 0xbb33, 0x333d,
    0x0, 0x0, 0xbb33, 0x3331, 0x0, 0x0, 0xbb33, 0x3325,
    0x0, 0x0, 0xbb33, 0x3319, 0x0, 0x0, 0xbb33, 0x330d,
    0x0, 0x0, 0xbb33, 0x3301, 0x0, 0x0, 0xbb33, 0x32f5,
    0x0, 0x0, 0xbb33, 0x32e9, 0x0, 0x0, 0xbb33, 0x32dd,
    0x0, 0x0, 0xbb33, 0x32d1, 0x0, 0x0, 0xbb33, 0x32c5,
    0x0, 0x0, 0xbb33, 0x32b9, 0x0, 0x0, 0xbb33, 0x32ad,
    0x0, 0x0, 0xbb33, 0x32a1, 0x0, 0x0, 0xbb33, 0x3295,
    0x0, 0x0, 0xbb33, 0x3289, 0x0, 0x0, 0xbb33, 0x327e,
    0x0, 0x0, 0xbb33, 0x3272, 0x0, 0x0, 0xbb33, 0x3266,
    0x0, 0x0, 0xbb33, 0x325a, 0x0, 0x0, 0xbb33, 0x324e,
    0x0, 0x0, 0xbb33, 0x3242, 0x0, 0x0, 0xbb33, 0x3236,
    0x0, 0x0, 0xbb33, 0x322b, 0x0, 0x0, 0xbb33, 0x321f,
    0x0, 0x0, 0xbb33, 0x3213, 0x0, 0x0, 0xbb33, 0x3207,
    0x0, 0x0, 0xbb33, 0x31fb, 0x0, 0x0, 0xbb33, 0x31f0,
    0x0, 0x0, 0xbb33, 0x31e4, 0x0, 0x0, 0xbb33, 0x31d8,
    0x0, 0x0, 0xbb33, 0x31cc, 0x0, 0x0, 0xbb33, 0x31c0,
    0x0, 0x0, 0xbb33, 0x31b5, 0x0, 0x0, 0xbb33, 0x31a9,
    0x0, 0x0, 0xbb33, 0x319d, 0x0, 0x0, 0xbb33, 0x3191,
    0x0, 0x0, 0xbb33, 0x3186, 0x0, 0x0, 0xbb33, 0x317a,
    0x0, 0x0, 0xbb33, 0x316e, 0x0, 0x0, 0xbb33, 0x3163,
    0x0, 0x0, 0xbb33, 0x3157, 0x0, 0x0, 0xbb33, 0x314b,
    0x0, 0x0, 0xbb33, 0x313f, 0x0, 0x0, 0xbb33, 0x3134,
    0x0, 0x0, 0xbb33, 0x3128, 0x0, 0x0, 0xbb33, 0x311c,
    0x0, 0x0, 0xbb33, 0x3111, 0x0, 0x0, 0xbb33, 0x3105,
    0x0, 0x0, 0xbb33, 0x30f9, 0x0, 0x0, 0xbb33, 0x30ee,
    0x0, 0x0, 0xbb33, 0x30e2, 0x0, 0x0, 0xbb33, 0x30d7,
    0x0, 0x0, 0xbb33, 0x30cb, 0x0, 0x0, 0xbb33, 0x30bf,
    0x0, 0x0, 0xbb33, 0x30b4, 0x0, 0x0, 0xbb33, 0x30a8,
    0x0, 0x0, 0xbb33, 0x309c, 0x0, 0x0, 0xbb33, 0x3091,
    0x0, 0x0, 0xbb33, 0x3085, 0x0, 0x0, 0xbb33, 0x307a,
    0x0, 0x0, 0xbb33, 0x306e, 0x0, 0x0, 0xbb33, 0x3063,
    0x0, 0x0, 0xbb33, 0x3057, 0x0, 0x0, 0xbb33, 0x304b,
    0x0, 0x0, 0xbb33, 0x3040, 0x0, 0x0, 0xbb33, 0x3034,
    0x0, 0x0, 0xbb33, 0x3029, 0x0, 0x0, 0xbb33, 0x301d,
    0x0, 0x0, 0xbb33, 0x3012, 0x0, 0x0, 0xbb33, 0x3006,
    0x0, 0x0, 0xbb33, 0x2ff5, 0x0, 0x0, 0xbb33, 0x2fde,
    0x0, 0x0, 0xbb33, 0x2fc7, 0x0, 0x0, 0xbb33, 0x2fb0,
    0x0, 0x0, 0xbb33, 0x2f99, 0x0, 0x0, 0xbb33, 0x2f82,
    0x0, 0x0, 0xbb33, 0x2f6b, 0x0, 0x0, 0xbb33, 0x2f54,
    0x0, 0x0, 0xbb33, 0x2f3d, 0x0, 0x0, 0xbb33, 0x2f26,
    0x0, 0x0, 0xbb33, 0x2f0f, 0x0, 0x0, 0xbb33, 0x2ef8,
    0x0, 0x0, 0xbb33, 0x2ee1, 0x0, 0x0, 0xbb33, 0x2eca,
    0x0, 0x0, 0xbb33, 0x2eb3, 0x0, 0x0, 0xbb33, 0x2e9d,
    0x0, 0x0, 0xbb33, 0x2e86, 0x0, 0x0, 0xbb33, 0x2e6f,
    0x0, 0x0, 0xbb33, 0x2e58, 0x0, 0x0, 0xbb33, 0x2e41,
    0x0, 0x0, 0xbb33, 0x2e2a, 0x0, 0x0, 0xbb33, 0x2e13,
    0x0, 0x0, 0xbb33, 0x2dfc, 0x0, 0x0, 0xbb33, 0x2de5,
    0x0, 0x0, 0xbb33, 0x2dcf, 0x0, 0x0, 0xbb33, 0x2db8,
    0x0, 0x0, 0xbb33, 0x2da1, 0x0, 0x0, 0xbb33, 0x2d8a,
    0x0, 0x0, 0xbb33, 0x2d73, 0x0, 0x0, 0xbb33, 0x2d5c,
    0x0, 0x0, 0xbb33, 0x2d46, 0x0, 0x0, 0xbb33, 0x2d2f,
    0x0, 0x0, 0xbb33, 0x2d18, 0x0, 0x0, 0xbb33, 0x2d01,
    0x0, 0x0, 0xbb33, 0x2cea, 0x0, 0x0, 0xbb33, 0x2cd4,
    0x0, 0x0, 0xbb33, 0x2cbd, 0x0, 0x0, 0xbb33, 0x2ca6,
    0x0, 0x0, 0xbb33, 0x2c8f, 0x0, 0x0, 0xbb33, 0x2c79,
    0x0, 0x0, 0xbb33, 0x2c62, 0x0, 0x0, 0xbb33, 0x2c4b,
    0x0, 0x0, 0xbb33, 0x2c34, 0x0, 0x0, 0xbb33, 0x2c1e,
    0x0, 0x0, 0xbb33, 0x2c07, 0x0, 0x0, 0xbb33, 0x2be0,
    0x0, 0x0, 0xbb33, 0x2bb3, 0x0, 0x0, 0xbb33, 0x2b85,
    0x0, 0x0, 0xbb33, 0x2b58, 0x0, 0x0, 0xbb33, 0x2b2b,
    0x0, 0x0, 0xbb33, 0x2afd, 0x0, 0x0, 0xbb33, 0x2ad0,
    0x0, 0x0, 0xbb33, 0x2aa2, 0x0, 0x0, 0xbb33, 0x2a75,
    0x0, 0x0, 0xbb33, 0x2a48, 0x0, 0x0, 0xbb33, 0x2a1a,
    0x0, 0x0, 0xbb33, 0x29ed, 0x0, 0x0, 0xbb33, 0x29bf,
    0x0, 0x0, 0xbb33, 0x2992, 0x0, 0x0, 0xbb33, 0x2965,
    0x0, 0x0, 0xbb33, 0x2937, 0x0, 0x0, 0xbb33, 0x290a,
    0x0, 0x0, 0xbb33, 0x28dd, 0x0, 0x0, 0xbb33, 0x28af,
    0x0, 0x0, 0xbb33, 0x2882, 0x0, 0x0, 0xbb33, 0x2855,
    0x0, 0x0, 0xbb33, 0x2828, 0x0, 0x0, 0xbb33, 0x27f5,
    0x0, 0x0, 0xbb33, 0x279a, 0x0, 0x0, 0xbb33, 0x273f,
    0x0, 0x0, 0xbb33, 0x26e5, 0x0, 0x0, 0xbb33, 0x268a,
    0x0, 0x0, 0xbb33, 0x2630, 0x0, 0x0, 0xbb33, 0x25d5,
    0x0, 0x0, 0xbb33, 0x257b, 0x0, 0x0, 0xbb33, 0x2520,
    0x0, 0x0, 0xbb33, 0x24c6, 0x0, 0x0, 0xbb33, 0x246b,
    0x0, 0x0, 0xbb33, 0x2411, 0x0, 0x0, 0xbb33, 0x236c,
    0x0, 0x0, 0xbb33, 0x22b7, 0x0, 0x0, 0xbb33, 0x2202,
    0x0, 0x0, 0xbb33, 0x214d, 0x0, 0x0, 0xbb33, 0x2098,
    0x0, 0x0, 0xbb33, 0x1fc7, 0x0, 0x0, 0xbb33, 0x1e5d,
    0x0, 0x0, 0xbb33, 0x1cf3, 0x0, 0x0, 0xbb33, 0x1b12,
    0x0, 0x0, 0xbb33, 0x183e, 0x0, 0x0, 0xbb33, 0x11a8,
    0x0, 0x0, 0xbb33, 0x91a8, 0x0, 0x0, 0xbb33, 0x983e,
    0x0, 0x0, 0xbb33, 0x9b12, 0x0, 0x0, 0xbb33, 0x9cf3,
    0x0, 0x0, 0xbb33, 0x9e5d, 0x0, 0x0, 0xbb33, 0x9fc7,
    0x0, 0x0, 0xbb33, 0xa098, 0x0, 0x0, 0xbb33, 0xa14d,
    0x0, 0x0, 0xbb33, 0xa202, 0x0, 0x0, 0xbb33, 0xa2b7,
    0x0, 0x0, 0xbb33, 0xa36c, 0x0, 0x0, 0xbb33, 0xa411,
    0x0, 0x0, 0xbb33, 0xa46b, 0x0, 0x0, 0xbb33, 0xa4c6,
    0x0, 0x0, 0xbb33, 0xa520, 0x0, 0x0, 0xbb33, 0xa57b,
    0x0, 0x0, 0xbb33, 0xa5d5, 0x0, 0x0, 0xbb33, 0xa630,
    0x0, 0x0, 0xbb33, 0xa68a, 0x0, 0x0, 0xbb33, 0xa6e5,
    0x0, 0x0, 0xbb33, 0xa73f, 0x0, 0x0, 0xbb33, 0xa79a,
    0x0, 0x0, 0xbb33, 0xa7f5, 0x0, 0x0, 0xbb33, 0xa828,
    0x0, 0x0, 0xbb33, 0xa855, 0x0, 0x0, 0xbb33, 0xa882,
    0x0, 0x0, 0xbb33, 0xa8af, 0x0, 0x0, 0xbb33, 0xa8dd,
    0x0, 0x0, 0xbb33, 0xa90a, 0x0, 0x0, 0xbb33, 0xa937,
    0x0, 0x0, 0xbb33, 0xa965, 0x0, 0x0, 0xbb33, 0xa992,
    0x0, 0x0, 0xbb33, 0xa9bf, 0x0, 0x0, 0xbb33, 0xa9ed,
    0x0, 0x0, 0xbb33, 0xaa1a, 0x0, 0x0, 0xbb33, 0xaa48,
    0x0, 0x0, 0xbb33, 0xaa75, 0x0, 0x0, 0xbb33, 0xaaa2,
    0x0, 0x0, 0xbb33, 0xaad0, 0x0, 0x0, 0xbb33, 0xaafd,
    0x0, 0x0, 0xbb33, 0xab2b, 0x0, 0x0, 0xbb33, 0xab58,
    0x0, 0x0, 0xbb33, 0xab85, 0x0, 0x0, 0xbb33, 0xabb3,
    0x0, 0x0, 0xbb33, 0xabe0, 0x0, 0x0, 0xbb33, 0xac07,
    0x0, 0x0, 0xbb33, 0xac1e, 0x0, 0x0, 0xbb33, 0xac34,
    0x0, 0x0, 0xbb33, 0xac4b, 0x0, 0x0, 0xbb33, 0xac62,
    0x0, 0x0, 0xbb33, 0xac79, 0x0, 0x0, 0xbb33, 0xac8f,
    0x0, 0x0, 0xbb33, 0xaca6, 0x0, 0x0, 0xbb33, 0xacbd,
    0x0, 0x0, 0xbb33, 0xacd4, 0x0, 0x0, 0xbb33, 0xacea,
    0x0, 0x0, 0xbb33, 0xad01, 0x0, 0x0, 0xbb33, 0xad18,
    0x0, 0x0, 0xbb33, 0xad2f, 0x0, 0x0, 0xbb33, 0xad46,
    0x0, 0x0, 0xbb33, 0xad5c, 0x0, 0x0, 0xbb33, 0xad73,
    0x0, 0x0, 0xbb33, 0xad8a, 0x0, 0x0, 0xbb33, 0xada1,
    0x0, 0x0, 0xbb33, 0xadb8, 0x0, 0x0, 0xbb33, 0xadcf,
    0x0, 0x0, 0xbb33, 0xade5, 0x0, 0x0, 0xbb33, 0xadfc,
    0x0, 0x0, 0xbb33, 0xae13, 0x0, 0x0, 0xbb33, 0xae2a,
    0x0, 0x0, 0xbb33, 0xae41, 0x0, 0x0, 0xbb33, 0xae58,
    0x0, 0x0, 0xbb33, 0xae6f, 0x0, 0x0, 0xbb33, 0xae86,
    0x0, 0x0, 0xbb33, 0xae9d, 0x0, 0x0, 0xbb33, 0xaeb3,
    0x0, 0x0, 0xbb33, 0xaeca, 0x0, 0x0, 0xbb33, 0xaee1,
    0x0, 0x0, 0xbb33, 0xaef8, 0x0, 0x0, 0xbb33, 0xaf0f,
    0x0, 0x0, 0xbb33, 0xaf26, 0x0, 0x0, 0xbb33, 0xaf3d,
    0x0, 0x0, 0xbb33, 0xaf54, 0x0, 0x0, 0xbb33, 0xaf6b,
    0x0, 0x0, 0xbb33, 0xaf82, 0x0, 0x0, 0xbb33, 0xaf99,
    0x0, 0x0, 0xbb33, 0xafb0, 0x0, 0x0, 0xbb33, 0xafc7,
    0x0, 0x0, 0xbb33, 0xafde, 0x0, 0x0, 0xbb33, 0xaff5,
    0x0, 0x0, 0xbb33, 0xb006, 0x0, 0x0, 0xbb33, 0xb012,
    0x0, 0x0, 0xbb33, 0xb01d, 0x0, 0x0, 0xbb33, 0xb029,
    0x0, 0x0, 0xbb33, 0xb034, 0x0, 0x0, 0xbb33, 0xb040,
    0x0, 0x0, 0xbb33, 0xb04b, 0x0, 0x0, 0xbb33, 0xb057,
    0x0, 0x0, 0xbb33, 0xb063, 0x0, 0x0, 0xbb33, 0xb06e,
    0x0, 0x0, 0xbb33, 0xb07a, 0x0, 0x0, 0xbb33, 0xb085,
    0x0, 0x0, 0xbb33, 0xb091, 0x0, 0x0, 0xbb33, 0xb09c,
    0x0, 0x0, 0xbb33, 0xb0a8, 0x0, 0x0, 0xbb33, 0xb0b4,
    0x0, 0x0, 0xbb33, 0xb0bf, 0x0, 0x0, 0xbb33, 0xb0cb,
    0x0, 0x0, 0xbb33, 0xb0d7, 0x0, 0x0, 0xbb33, 0xb0e2,
    0x0, 0x0, 0xbb33, 0xb0ee, 0x0, 0x0, 0xbb33, 0xb0f9,
    0x0, 0x0, 0xbb33, 0xb105, 0x0, 0x0, 0xbb33, 0xb111,
    0x0, 0x0, 0xbb33, 0xb11c, 0x0, 0x0, 0xbb33, 0xb128,
    0x0, 0x0, 0xbb33, 0xb134, 0x0, 0x0, 0xbb33, 0xb13f,
    0x0, 0x0, 0xbb33, 0xb14b, 0x0, 0x0, 0xbb33, 0xb157,
    0x0, 0x0, 0xbb33, 0xb163, 0x0, 0x0, 0xbb33, 0xb16e,
    0x0, 0x0, 0xbb33, 0xb17a, 0x0, 0x0, 0xbb33, 0xb186,
    0x0, 0x0, 0xbb33, 0xb191, 0x0, 0x0, 0xbb33, 0xb19d,
    0x0, 0x0, 0xbb33, 0xb1a9, 0x0, 0x0, 0xbb33, 0xb1b5,
    0x0, 0x0, 0xbb33, 0xb1c0, 0x0, 0x0, 0xbb33, 0xb1cc,
    0x0, 0x0, 0xbb33, 0xb1d8, 0x0, 0x0, 0xbb33, 0xb1e4,
    0x0, 0x0, 0xbb33, 0xb1f0, 0x0, 0x0, 0xbb33, 0xb1fb,
    0x0, 0x0, 0xbb33, 0xb207, 0x0, 0x0, 0xbb33, 0xb213,
    0x0, 0x0, 0xbb33, 0xb21f, 0x0, 0x0, 0xbb33, 0xb22b,
    0x0, 0x0, 0xbb33, 0xb236, 0x0, 0x0, 0xbb33, 0xb242,
    0x0, 0x0, 0xbb33, 0xb24e, 0x0, 0x0, 0xbb33, 0xb25a,
    0x0, 0x0, 0xbb33, 0xb266, 0x0, 0x0, 0xbb33, 0xb272,
    0x0, 0x0, 0xbb33, 0xb27e, 0x0, 0x0, 0xbb33, 0xb289,
    0x0, 0x0, 0xbb33, 0xb295, 0x0, 0x0, 0xbb33, 0xb2a1,
    0x0, 0x0, 0xbb33, 0xb2ad, 0x0, 0x0, 0xbb33, 0xb2b9,
    0x0, 0x0, 0xbb33, 0xb2c5, 0x0, 0x0, 0xbb33, 0xb2d1,
    0x0, 0x0, 0xbb33, 0xb2dd, 0x0, 0x0, 0xbb33, 0xb2e9,
    0x0, 0x0, 0xbb33, 0xb2f5, 0x0, 0x0, 0xbb33, 0xb301,
    0x0, 0x0, 0xbb33, 0xb30d, 0x0, 0x0, 0xbb33, 0xb319,
    0x0, 0x0, 0xbb33, 0xb325, 0x0, 0x0, 0xbb33, 0xb331,
    0x0, 0x0, 0xbb33, 0xb33d, 0x0, 0x0, 0xbb33, 0xb349,
    0x0, 0x0, 0xbb33, 0xb355, 0x0, 0x0, 0xbb33, 0xb361,
    0x0, 0x0, 0xbb33, 0xb36d, 0x0, 0x0, 0xbb33, 0xb379,
    0x0, 0x0, 0xbb33, 0xb385, 0x0, 0x0, 0xbb33, 0xb391,
    0x0, 0x0, 0xbb33, 0xb39d, 0x0, 0x0, 0xbb33, 0xb3a9,
    0x0, 0x0, 0xbb33, 0xb3b6, 0x0, 0x0, 0xbb33, 0xb3c2,
    0x0, 0x0, 0xbb33, 0xb3ce, 0x0, 0x0, 0xbb33, 0xb3da,
    0x0, 0x0, 0xbb33, 0xb3e6, 0x0, 0x0, 0xbb33, 0xb3f2,
    0x0, 0x0, 0xbb33, 0xb3fe, 0x0, 0x0, 0xbb33, 0xb405,
    0x0, 0x0, 0xbb33, 0xb40b, 0x0, 0x0, 0xbb33, 0xb412,
    0x0, 0x0, 0xbb33, 0xb418, 0x0, 0x0, 0xbb33, 0xb41e,
    0x0, 0x0, 0xbb33, 0xb424, 0x0, 0x0, 0xbb33, 0xb42a,
    0x0, 0x0, 0xbb33, 0xb430, 0x0, 0x0, 0xbb33, 0xb436,
    0x0, 0x0, 0xbb33, 0xb43c, 0x0, 0x0, 0xbb33, 0xb443,
    0x0, 0x0, 0xbb33, 0xb449, 0x0, 0x0, 0xbb33, 0xb44f,
    0x0, 0x0, 0xbb33, 0xb455, 0x0, 0x0, 0xbb33, 0xb45b,
    0x0, 0x0, 0xbb33, 0xb461, 0x0, 0x0, 0xbb33, 0xb468,
    0x0, 0x0, 0xbb33, 0xb46e, 0x0, 0x0, 0xbb33, 0xb474,
    0x0, 0x0, 0xbb33, 0xb47a, 0x0, 0x0, 0xbb33, 0xb480,
    0x0, 0x0, 0xbb33, 0xb487, 0x0, 0x0, 0xbb33, 0xb48d,
    0x0, 0x0, 0xbb33, 0xb493, 0x0, 0x0, 0xbb33, 0xb499,
    0x0, 0x0, 0xbb33, 0xb49f, 0x0, 0x0, 0xbb33, 0xb4a6,
    0x0, 0x0, 0xbb33, 0xb4ac, 0x0, 0x0, 0xbb33, 0xb4b2,
    0x0, 0x0, 0xbb33, 0xb4b8, 0x0, 0x0, 0xbb33, 0xb4bf,
    0x0, 0x0, 0xbb33, 0xb4c5, 0x0, 0x0, 0xbb33, 0xb4cb,
    0x0, 0x0, 0xbb33, 0xb4d2, 0x0, 0x0, 0xbb33, 0xb4d8,
    0x0, 0x0, 0xbb33, 0xb4de, 0x0, 0x0, 0xbb33, 0xb4e4,
    0x0, 0x0, 0xbb33, 0xb4eb, 0x0, 0x0, 0xbb33, 0xb4f1,
    0x0, 0x0, 0xbb33, 0xb4f7, 0x0, 0x0, 0xbb33, 0xb4fe,
    0x0, 0x0, 0xbb33, 0xb504, 0x0, 0x0, 0xbb33, 0xb50a,
    0x0, 0x0, 0xbb33, 0xb511, 0x0, 0x0, 0xbb33, 0xb517,
    0x0, 0x0, 0xbb33, 0xb51d, 0x0, 0x0, 0xbb33, 0xb524,
    0x0, 0x0, 0xbb33, 0xb52a, 0x0, 0x0, 0xbb33, 0xb531,
    0x0, 0x0, 0xbb33, 0xb537, 0x0, 0x0, 0xbb33, 0xb53d,
    0x0, 0x0, 0xbb33, 0xb544, 0x0, 0x0, 0xbb33, 0xb54a,
    0x0, 0x0, 0xbb33, 0xb551, 0x0, 0x0, 0xbb33, 0xb557,
    0x0, 0x0, 0xbb33, 0xb55d, 0x0, 0x0, 0xbb33, 0xb564,
    0x0, 0x0, 0xbb33, 0xb56a, 0x0, 0x0, 0xbb33, 0xb571,
    0x0, 0x0, 0xbb33, 0xb577, 0x0, 0x0, 0xbb33, 0xb57e,
    0x0, 0x0, 0xbb33, 0xb584, 0x0, 0x0, 0xbb33, 0xb58b,
    0x0, 0x0, 0xbb33, 0xb591, 0x0, 0x0, 0xbb33, 0xb598,
    0x0, 0x0, 0xbb33, 0xb59e, 0x0, 0x0, 0xbb33, 0xb5a5,
    0x0, 0x0, 0xbb33, 0xb5ab, 0x0, 0x0, 0xbb33, 0xb5b2,
    0x0, 0x0, 0xbb33, 0xb5b8, 0x0, 0x0, 0xbb33, 0xb5bf,
    0x0, 0x0, 0xbb33, 0xb5c6, 0x0, 0x0, 0xbb33, 0xb5cc,
    0x0, 0x0, 0xbb33, 0xb5d3, 0x0, 0x0, 0xbb33, 0xb5d9,
    0x0, 0x0, 0xbb33, 0xb5e0, 0x0, 0x0, 0xbb33, 0xb5e6,
    0x0, 0x0, 0xbb33, 0xb5ed, 0x0, 0x0, 0xbb33, 0xb5f4,
    0x0, 0x0, 0xbb33, 0xb5fa, 0x0, 0x0, 0xbb33, 0xb601,
    0x0, 0x0, 0xbb33, 0xb608, 0x0, 0x0, 0xbb33, 0xb60e,
    0x0, 0x0, 0xbb33, 0xb615, 0x0, 0x0, 0xbb33, 0xb61c,
    0x0, 0x0, 0xbb33, 0xb622, 0x0, 0x0, 0xbb33, 0xb629,
    0x0, 0x0, 0xbb33, 0xb630, 0x0, 0x0, 0xbb33, 0xb636,
    0x0, 0x0, 0xbb33, 0xb63d, 0x0, 0x0, 0xbb33, 0xb644,
    0x0, 0x0, 0xbb33, 0xb64a, 0x0, 0x0, 0xbb33, 0xb651,
    0x0, 0x0, 0xbb33, 0xb658, 0x0, 0x0, 0xbb33, 0xb65f,
    0x0, 0x0, 0xbb33, 0xb665, 0x0, 0x0, 0xbb33, 0xb66c,
    0x0, 0x0, 0xbb33, 0xb673, 0x0, 0x0, 0xbb33, 0xb67a,
    0x0, 0x0, 0xbb33, 0xb681, 0x0, 0x0, 0xbb33, 0xb687,
    0x0, 0x0, 0xbb33, 0xb68e, 0x0, 0x0, 0xbb33, 0xb695,
    0x0, 0x0, 0xbb33, 0xb69c, 0x0, 0x0, 0xbb33, 0xb6a3,
    0x0, 0x0, 0xbb33, 0xb6aa, 0x0, 0x0, 0xbb33, 0xb6b0,
    0x0, 0x0, 0xbb33, 0xb6b7, 0x0, 0x0, 0xbb33, 0xb6be,
    0x0, 0x0, 0xbb33, 0xb6c5, 0x0, 0x0, 0xbb33, 0xb6cc,
    0x0, 0x0, 0xbb33, 0xb6d3, 0x0, 0x0, 0xbb33, 0xb6da,
    0x0, 0x0, 0xbb33, 0xb6e1, 0x0, 0x0, 0xbb33, 0xb6e8,
    0x0, 0x0, 0xbb33, 0xb6ef, 0x0, 0x0, 0xbb33, 0xb6f6,
    0x0, 0x0, 0xbb33, 0xb6fd, 0x0, 0x0, 0xbb33, 0xb704,
    0x0, 0x0, 0xbb33, 0xb70b, 0x0, 0x0, 0xbb33, 0xb712,
    0x0, 0x0, 0xbb33, 0xb719, 0x0, 0x0, 0xbb33, 0xb720,
    0x0, 0x0, 0xbb33, 0xb727, 0x0, 0x0, 0xbb33, 0xb72e,
    0x0, 0x0, 0xbb33, 0xb735, 0x0, 0x0, 0xbb33, 0xb73c,
    0x0, 0x0, 0xbb33, 0xb743, 0x0, 0x0, 0xbb33, 0xb74a,
    0x0, 0x0, 0xbb33, 0xb751, 0x0, 0x0, 0xbb33, 0xb758,
    0x0, 0x0, 0xbb33, 0xb760, 0x0, 0x0, 0xbb33, 0xb767,
    0x0, 0x0, 0xbb33, 0xb76e, 0x0, 0x0, 0xbb33, 0xb775,
    0x0, 0x0, 0xbb33, 0xb77c, 0x0, 0x0, 0xbb33, 0xb783,
    0x0, 0x0, 0xbb33, 0xb78b, 0x0, 0x0, 0xbb33, 0xb792,
    0x0, 0x0, 0xbb33, 0xb799, 0x0, 0x0, 0xbb33, 0xb7a0,
    0x0, 0x0, 0xbb33, 0xb7a8, 0x0, 0x0, 0xbb33, 0xb7af,
    0x0, 0x0, 0xbb33, 0xb7b6, 0x0, 0x0, 0xbb33, 0xb7bd,
    0x0, 0x0, 0xbb33, 0xb7c5, 0x0, 0x0, 0xbb33, 0xb7cc,
    0x0, 0x0, 0xbb33, 0xb7d3, 0x0, 0x0, 0xbb33, 0xb7db,
    0x0, 0x0, 0xbb33, 0xb7e2, 0x0, 0x0, 0xbb33, 0xb7e9,
    0x0, 0x0, 0xbb33, 0xb7f1, 0x0, 0x0, 0xbb33, 0xb7f8,
    0x0, 0x0, 0xbb33, 0xb7ff, 0x0, 0x0, 0xbb33, 0xb803,
    0x0, 0x0, 0xbb33, 0xb807, 0x0, 0x0, 0xbb33, 0xb80b,
    0x0, 0x0, 0xbb33, 0xb80f, 0x0, 0x0, 0xbb33, 0xb812,
    0x0, 0x0, 0xbb33, 0xb816, 0x0, 0x0, 0xbb33, 0xb81a,
    0x0, 0x0, 0xbb33, 0xb81e, 0x0, 0x0, 0xbb33, 0xb821,
    0x0, 0x0, 0xbb33, 0xb825, 0x0, 0x0, 0xbb33, 0xb829,
    0x0, 0x0, 0xbb33, 0xb82d, 0x0, 0x0, 0xbb33, 0xb830,
    0x0, 0x0, 0xbb33, 0xb834, 0x0, 0x0, 0xbb33, 0xb838,
    0x0, 0x0, 0xbb33, 0xb83c, 0x0, 0x0, 0xbb33, 0xb840,
    0x0, 0x0, 0xbb33, 0xb843, 0x0, 0x0, 0xbb33, 0xb847,
    0x0, 0x0, 0xbb33, 0xb84b, 0x0, 0x0, 0xbb33, 0xb84f,
    0x0, 0x0, 0xbb33, 0xb853, 0x0, 0x0, 0xbb33, 0xb857,
    0x0, 0x0, 0xbb33, 0xb85a, 0x0, 0x0, 0xbb33, 0xb85e,
    0x0, 0x0, 0xbb33, 0xb862, 0x0, 0x0, 0xbb33, 0xb866,
    0x0, 0x0, 0xbb33, 0xb86a, 0x0, 0x0, 0xbb33, 0xb86e,
    0x0, 0x0, 0xbb33, 0xb872, 0x0, 0x0, 0xbb33, 0xb876,
    0x0, 0x0, 0xbb33, 0xb87a, 0x0, 0x0, 0xbb33, 0xb87d,
    0x0, 0x0, 0xbb33, 0xb881, 0x0, 0x0, 0xbb33, 0xb885,
    0x0, 0x0, 0xbb33, 0xb889, 0x0, 0x0, 0xbb33, 0xb88d,
    0x0, 0x0, 0xbb33, 0xb891, 0x0, 0x0, 0xbb33, 0xb895,
    0x0, 0x0, 0xbb33, 0xb899, 0x0, 0x0, 0xbb33, 0xb89d,
    0x0, 0x0, 0xbb33, 0xb8a1, 0x0, 0x0, 0xbb33, 0xb8a5,
    0x0, 0x0, 0xbb33, 0xb8a9, 0x0, 0x0, 0xbb33, 0xb8ad,
    0x0, 0x0, 0xbb33, 0xb8b1, 0x0, 0x0, 0xbb33, 0xb8b5,
    0x0, 0x0, 0xbb33, 0xb8b9, 0x0, 0x0, 0xbb33, 0xb8bd,
    0x0, 0x0, 0xbb33, 0xb8c1, 0x0, 0x0, 0xbb33, 0xb8c5,
    0x0, 0x0, 0xbb33, 0xb8c9, 0x0, 0x0, 0xbb33, 0xb8ce,
    0x0, 0x0, 0xbb33, 0xb8d2, 0x0, 0x0, 0xbb33, 0xb8d6,
    0x0, 0x0, 0xbb33, 0xb8da, 0x0, 0x0, 0xbb33, 0xb8de,
    0x0, 0x0, 0xbb33, 0xb8e2, 0x0, 0x0, 0xbb33, 0xb8e6,
    0x0, 0x0, 0xbb33, 0xb8ea, 0x0, 0x0, 0xbb33, 0xb8ee,
    0x0, 0x0, 0xbb33, 0xb8f3, 0x0, 0x0, 0xbb33, 0xb8f7,
    0x0, 0x0, 0xbb33, 0xb8fb, 0x0, 0x0, 0xbb33, 0xb8ff,
    0x0, 0x0, 0xbb33, 0xb903, 0x0, 0x0, 0xbb33, 0xb908,
    0x0, 0x0, 0xbb33, 0xb90c, 0x0, 0x0, 0xbb33, 0xb910,
    0x0, 0x0, 0xbb33, 0xb914, 0x0, 0x0, 0xbb33, 0xb918,
    0x0, 0x0, 0xbb33, 0xb91d, 0x0, 0x0, 0xbb33, 0xb921,
    0x0, 0x0, 0xbb33, 0xb925, 0x0, 0x0, 0xbb33, 0xb92a,
    0x0, 0x0, 0xbb33, 0xb92e, 0x0, 0x0, 0xbb33, 0xb932,
    0x0, 0x0, 0xbb33, 0xb936, 0x0, 0x0, 0xbb33, 0xb93b,
    0x0, 0x0, 0xbb33, 0xb93f, 0x0, 0x0, 0xbb33, 0xb943,
    0x0, 0x0, 0xbb33, 0xb948, 0x0, 0x0, 0xbb33, 0xb94c,
    0x0, 0x0, 0xbb33, 0xb950, 0x0, 0x0, 0xbb33, 0xb955,
    0x0, 0x0, 0xbb33, 0xb959, 0x0, 0x0, 0xbb33, 0xb95e,
    0x0, 0x0, 0xbb33, 0xb962, 0x0, 0x0, 0xbb33, 0xb966,
    0x0, 0x0, 0xbb33, 0xb96b, 0x0, 0x0, 0xbb33, 0xb96f,
    0x0, 0x0, 0xbb33, 0xb974, 0x0, 0x0, 0xbb33, 0xb978,
    0x0, 0x0, 0xbb33, 0xb97d, 0x0, 0x0, 0xbb33, 0xb981,
    0x0, 0x0, 0xbb33, 0xb986, 0x0, 0x0, 0xbb33, 0xb98a,
    0x0, 0x0, 0xbb33, 0xb98f, 0x0, 0x0, 0xbb33, 0xb993,
    0x0, 0x0, 0xbb33, 0xb998, 0x0, 0x0, 0xbb33, 0xb99c,
    0x0, 0x0, 0xbb33, 0xb9a1, 0x0, 0x0, 0xbb33, 0xb9a5,
    0x0, 0x0, 0xbb33, 0xb9aa, 0x0, 0x0, 0xbb33, 0xb9ae,
    0x0, 0x0, 0xbb33, 0xb9b3, 0x0, 0x0, 0xbb33, 0xb9b8,
    0x0, 0x0, 0xbb33, 0xb9bc, 0x0, 0x0, 0xbb33, 0xb9c1,
    0x0, 0x0, 0xbb33, 0xb9c6, 0x0, 0x0, 0xbb33, 0xb9ca,
    0x0, 0x0, 0xbb33, 0xb9cf, 0x0, 0x0, 0xbb33, 0xb9d4,
    0x0, 0x0, 0xbb33, 0xb9d8, 0x0, 0x0, 0xbb33, 0xb9dd,
    0x0, 0x0, 0xbb33, 0xb9e2, 0x0, 0x0, 0xbb33, 0xb9e6,
    0x0, 0x0, 0xbb33, 0xb9eb, 0x0, 0x0, 0xbb33, 0xb9f0,
    0x0, 0x0, 0xbb33, 0xb9f5, 0x0, 0x0, 0xbb33, 0xb9f9,
    0x0, 0x0, 0xbb33, 0xb9fe, 0x0, 0x0, 0xbb33, 0xba03,
    0x0, 0x0, 0xbb33, 0xba08, 0x0, 0x0, 0xbb33, 0xba0d,
    0x0, 0x0, 0xbb33, 0xba11, 0x0, 0x0, 0xbb33, 0xba16,
    0x0, 0x0, 0xbb33, 0xba1b, 0x0, 0x0, 0xbb33, 0xba20,
    0x0, 0x0, 0xbb33, 0xba25, 0x0, 0x0, 0xbb33, 0xba2a,
    0x0, 0x0, 0xbb33, 0xba2f, 0x0, 0x0, 0xbb33, 0xba33,
    0x0, 0x0, 0xbb33, 0xba38, 0x0, 0x0, 0xbb33, 0xba3d,
    0x0, 0x0, 0xbb33, 0xba42, 0x0, 0x0, 0xbb33, 0xba47,
    0x0, 0x0, 0xbb33, 0xba4c, 0x0, 0x0, 0xbb33, 0xba51,
    0x0, 0x0, 0xbb33, 0xba56, 0x0, 0x0, 0xbb33, 0xba5b,
    0x0, 0x0, 0xbb33, 0xba60, 0x0, 0x0, 0xbb33, 0xba65,
    0x0, 0x0, 0xbb33, 0xba6a, 0x0, 0x0, 0xbb33, 0xba70,
    0x0, 0x0, 0xbb33, 0xba75, 0x0, 0x0, 0xbb33, 0xba7a,
    0x0, 0x0, 0xbb33, 0xba7f, 0x0, 0x0, 0xbb33, 0xba84,
    0x0, 0x0, 0xbb33, 0xba89, 0x0, 0x0, 0xbb33, 0xba8e,
    0x0, 0x0, 0xbb33, 0xba93, 0x0, 0x0, 0xbb33, 0xba99,
    0x0, 0x0, 0xbb33, 0xba9e, 0x0, 0x0, 0xbb33, 0xbaa3,
    0x0, 0x0, 0xbb33, 0xbaa8, 0x0, 0x0, 0xbb33, 0xbaae,
    0x0, 0x0, 0xbb33, 0xbab3, 0x0, 0x0, 0xbb33, 0xbab8,
    0x0, 0x0, 0xbb33, 0xbabd, 0x0, 0x0, 0xbb33, 0xbac3,
    0x0, 0x0, 0xbb33, 0xbac8, 0x0, 0x0, 0xbb33, 0xbacd,
    0x0, 0x0, 0xbb33, 0xbad3, 0x0, 0x0, 0xbb33, 0xbad8,
    0x0, 0x0, 0xbb33, 0xbade, 0x0, 0x0, 0xbb33, 0xbae3,
    0x0, 0x0, 0xbb33, 0xbae8, 0x0, 0x0, 0xbb33, 0xbaee,
    0x0, 0x0, 0xbb33, 0xbaf3, 0x0, 0x0, 0xbb33, 0xbaf9,
    0x0, 0x0, 0xbb33, 0xbafe, 0x0, 0x0, 0xbb33, 0xbb04,
    0x0, 0x0, 0xbb33, 0xbb09, 0x0, 0x0, 0xbb33, 0xbb0f,
    0x0, 0x0, 0xbb33, 0xbb14, 0x0, 0x0, 0xbb33, 0xbb1a,
    0x0, 0x0, 0xbb33, 0xbb20, 0x0, 0x0, 0xbb33, 0xbb25,
    0x0, 0x0, 0xbb33, 0xbb2b, 0x0, 0x0, 0xbb33, 0xbb30,
    0x0, 0x0, 0xbb33, 0xbb36, 0x0, 0x0, 0xbb33, 0xbb3c,
    0x0, 0x0, 0xbb33, 0xbb41, 0x0, 0x0, 0xbb33, 0xbb47,
    0x0, 0x0, 0xbb33, 0xbb4d, 0x0, 0x0, 0xbb33, 0xbb53,
    0x0, 0x0, 0xbb33, 0xbb58, 0x0, 0x0, 0xbb33, 0xbb5e,
    0x0, 0x0, 0xbb33, 0xbb64, 0x0, 0x0, 0xbb33, 0xbb6a,
    0x0, 0x0, 0xbb33, 0xbb70, 0x0, 0x0, 0xbb33, 0xbb75,
    0x0, 0x0, 0xbb33, 0xbb7b, 0x0, 0x0, 0xbb33, 0xbb81,
    0x0, 0x0, 0xbb33, 0xbb87, 0x0, 0x0, 0xbb33, 0xbb8d,
    0x0, 0x0, 0xbb33, 0xbb93, 0x0, 0x0, 0xbb33, 0xbb99,
    0x0, 0x0, 0xbb33, 0xbb9f, 0x0, 0x0, 0xbb33, 0xbba5,
    0x0, 0x0, 0xbb33, 0xbbab, 0x0, 0x0, 0xbb33, 0xbbb1,
    0x0, 0x0, 0xbb33, 0xbbb7, 0x0, 0x0, 0xbb33, 0xbbbd,
    0x0, 0x0, 0xbb33, 0xbbc3, 0x0, 0x0, 0xbb33, 0xbbc9,
    0x0, 0x0, 0xbb33, 0xbbcf, 0x0, 0x0, 0xbb33, 0xbbd6,
    0x0, 0x0, 0xbb33, 0xbbdc, 0x0, 0x0, 0xbb33, 0xbbe2,
    0x0, 0x0, 0xbb33, 0xbbe8, 0x0, 0x0, 0xbb33, 0xbbef,
    0x0, 0x0, 0xbb33, 0xbbf5, 0x0, 0x0, 0xbb33, 0xbbfb,
    0x0, 0x0, 0xbb33, 0xbc01, 0x0, 0x0, 0xbb33, 0xbc04,
    0x0, 0x0, 0xbb33, 0xbc07, 0x0, 0x0, 0xbb33, 0xbc0a,
    0x0, 0x0, 0xbb33, 0xbc0d, 0x0, 0x0, 0xbb33, 0xbc11,
    0x0, 0x0, 0xbb33, 0xbc14, 0x0, 0x0, 0xbb33, 0xbc17,
    0x0, 0x0, 0xbb33, 0xbc1a, 0x0, 0x0, 0xbb33, 0xbc1e,
    0x0, 0x0, 0xbb33, 0xbc21, 0x0, 0x0, 0xbb33, 0xbc24,
    0x0, 0x0, 0xbb33, 0xbc27, 0x0, 0x0, 0xbb33, 0xbc2b,
    0x0, 0x0, 0xbb33, 0xbc2e, 0x0, 0x0, 0xbb33, 0xbc31,
    0x0, 0x0, 0xbb33, 0xbc35, 0x0, 0x0, 0xbb33, 0xbc38,
    0x0, 0x0, 0xbb33, 0xbc3b, 0x0, 0x0, 0xbb33, 0xbc3f,
    0x0, 0x0, 0xbb33, 0xbc42, 0x0, 0x0, 0xbb33, 0xbc46,
    0x0, 0x0, 0xbb33, 0xbc49, 0x0, 0x0, 0xbb33, 0xbc4c,
    0x0, 0x0, 0xbb33, 0xbc50, 0x0, 0x0, 0xbb33, 0xbc53,
    0x0, 0x0, 0xbb33, 0xbc57, 0x0, 0x0, 0xbb33, 0xbc5a,
    0x0, 0x0, 0xbb33, 0xbc5e, 0x0, 0x0, 0xbb33, 0xbc61,
    0x0, 0x0, 0xbb33, 0xbc65, 0x0, 0x0, 0xbb33, 0xbc68,
    0x0, 0x0, 0xbb33, 0xbc6c, 0x0, 0x0, 0xbb33, 0xbc6f,
    0x0, 0x0, 0xbb33, 0xbc73, 0x0, 0x0, 0xbb33, 0xbc76,
    0x0, 0x0, 0xbb33, 0xbc7a, 0x0, 0x0, 0xbb33, 0xbc7e,
    0x0, 0x0, 0xbb33, 0xbc81, 0x0, 0x0, 0xbb33, 0xbc85,
    0x0, 0x0, 0xbb33, 0xbc89, 0x0, 0x0, 0xbb33, 0xbc8c,
    0x0, 0x0, 0xbb33, 0xbc90, 0x0, 0x0, 0xbb33, 0xbc94,
    0x0, 0x0, 0xbb33, 0xbc97, 0x0, 0x0, 0xbb33, 0xbc9b,
    0x0, 0x0, 0xbb33, 0xbc9f, 0x0, 0x0, 0xbb33, 0xbca3,
    0x0, 0x0, 0xbb33, 0xbca6, 0x0, 0x0, 0xbb33, 0xbcaa,
    0x0, 0x0, 0xbb33, 0xbcae, 0x0, 0x0, 0xbb33, 0xbcb2,
    0x0, 0x0, 0xbb33, 0xbcb6, 0x0, 0x0, 0xbb33, 0xbcb9,
    0x0, 0x0, 0xbb33, 0xbcbd, 0x0, 0x0, 0xbb33, 0xbcc1,
    0x0, 0x0, 0xbb33, 0xbcc5, 0x0, 0x0, 0xbb33, 0xbcc9,
    0x0, 0x0, 0xbb33, 0xbccd, 0x0, 0x0, 0xbb33, 0xbcd1,
    0x0, 0x0, 0xbb33, 0xbcd5, 0x0, 0x0, 0xbb33, 0xbcd9,
    0x0, 0x0, 0xbb33, 0xbcdd, 0x0, 0x0, 0xbb33, 0xbce1,
    0x0, 0x0, 0xbb33, 0xbce5, 0x0, 0x0, 0xbb33, 0xbce9,
    0x0, 0x0, 0xbb33, 0xbced, 0x0, 0x0, 0xbb33, 0xbcf1,
    0x0, 0x0, 0xbb33, 0xbcf5, 0x0, 0x0, 0xbb33, 0xbcf9,
    0x0, 0x0, 0xbb33, 0xbcfd, 0x0, 0x0, 0xbb33, 0xbd01,
    0x0, 0x0, 0xbb33, 0xbd05, 0x0, 0x0, 0xbb33, 0xbd0a,
    0x0, 0x0, 0xbb33, 0xbd0e, 0x0, 0x0, 0xbb33, 0xbd12,
    0x0, 0x0, 0xbb33, 0xbd16, 0x0, 0x0, 0xbb33, 0xbd1a,
    0x0, 0x0, 0xbb33, 0xbd1f, 0x0, 0x0, 0xbb33, 0xbd23,
    0x0, 0x0, 0xbb33, 0xbd27, 0x0, 0x0, 0xbb33, 0xbd2c,
    0x0, 0x0, 0xbb33, 0xbd30, 0x0, 0x0, 0xbb33, 0xbd34,
    0x0, 0x0, 0xbb33, 0xbd39, 0x0, 0x0, 0xbb33, 0xbd3d,
    0x0, 0x0, 0xbb33, 0xbd42, 0x0, 0x0, 0xbb33, 0xbd46,
    0x0, 0x0, 0xbb33, 0xbd4a, 0x0, 0x0, 0xbb33, 0xbd4f,
    0x0, 0x0, 0xbb33, 0xbd53, 0x0, 0x0, 0xbb33, 0xbd58,
    0x0, 0x0, 0xbb33, 0xbd5c, 0x0, 0x0, 0xbb33, 0xbd61,
    0x0, 0x0, 0xbb33, 0xbd66, 0x0, 0x0, 0xbb33, 0xbd6a,
    0x0, 0x0, 0xbb33, 0xbd6f, 0x0, 0x0, 0xbb33, 0xbd73,
    0x0, 0x0, 0xbb33, 0xbd78, 0x0, 0x0, 0xbb33, 0xbd7d,
    0x0, 0x0, 0xbb33, 0xbd81, 0x0, 0x0, 0xbb33, 0xbd86,
    0x0, 0x0, 0xbb33, 0xbd8b, 0x0, 0x0, 0xbb33, 0xbd90,
    0x0, 0x0, 0xbb33, 0xbd95, 0x0, 0x0, 0xbb33, 0xbd99,
    0x0, 0x0, 0xbb33, 0xbd9e, 0x0, 0x0, 0xbb33, 0xbda3,
    0x0, 0x0, 0xbb33, 0xbda8, 0x0, 0x0, 0xbb33, 0xbdad,
    0x0, 0x0, 0xbb33, 0xbdb2, 0x0, 0x0, 0xbb33, 0xbdb7,
    0x0, 0x0, 0xbb33, 0xbdbc, 0x0, 0x0, 0xbb33, 0xbdc1,
    0x0, 0x0, 0xbb33, 0xbdc6, 0x0, 0x0, 0xbb33, 0xbdcb,
    0x0, 0x0, 0xbb33, 0xbdd0, 0x0, 0x0, 0xbb33, 0xbdd5,
    0x0, 0x0, 0xbb33, 0xbdda, 0x0, 0x0, 0xbb33, 0xbddf,
    0x0, 0x0, 0xbb33, 0xbde5, 0x0, 0x0, 0xbb33, 0xbdea,
    0x0, 0x0, 0xbb33, 0xbdef, 0x0, 0x0, 0xbb33, 0xbdf4,
    0x0, 0x0, 0xbb33, 0xbdfa, 0x0, 0x0, 0xbb33, 0xbdff,
    0x0, 0x0, 0xbb33, 0xbe04, 0x0, 0x0, 0xbb33, 0xbe0a,
    0x0, 0x0, 0xbb33, 0xbe0f, 0x0, 0x0, 0xbb33, 0xbe14,
    0x0, 0x0, 0xbb33, 0xbe1a, 0x0, 0x0, 0xbb33, 0xbe1f,
    0x0, 0x0, 0xbb33, 0xbe25, 0x0, 0x0, 0xbb33, 0xbe2b,
    0x0, 0x0, 0xbb33, 0xbe30, 0x0, 0x0, 0xbb33, 0xbe36,
    0x0, 0x0, 0xbb33, 0xbe3b, 0x0, 0x0, 0xbb33, 0xbe41,
    0x0, 0x0, 0xbb33, 0xbe47, 0x0, 0x0, 0xbb33, 0xbe4c,
    0x0, 0x0, 0xbb33, 0xbe52, 0x0, 0x0, 0xbb33, 0xbe58,
    0x0, 0x0, 0xbb33, 0xbe5e, 0x0, 0x0, 0xbb33, 0xbe64,
    0x0, 0x0, 0xbb33, 0xbe69, 0x0, 0x0, 0xbb33, 0xbe6f,
    0x0, 0x0, 0xbb33, 0xbe75, 0x0, 0x0, 0xbb33, 0xbe7b,
    0x0, 0x0, 0xbb33, 0xbe81, 0x0, 0x0, 0xbb33, 0xbe87,
    0x0, 0x0, 0xbb33, 0xbe8d, 0x0, 0x0, 0xbb33, 0xbe94,
    0x0, 0x0, 0xbb33, 0xbe9a, 0x0, 0x0, 0xbb33, 0xbea0,
    0x0, 0x0, 0xbb33, 0xbea6, 0x0, 0x0, 0xbb33, 0xbeac,
    0x0, 0x0, 0xbb33, 0xbeb3, 0x0, 0x0, 0xbb33, 0xbeb9,
    0x0, 0x0, 0xbb33, 0xbebf, 0x0, 0x0, 0xbb33, 0xbec6,
    0x0, 0x0, 0xbb33, 0xbecc, 0x0, 0x0, 0xbb33, 0xbed3,
    0x0, 0x0, 0xbb33, 0xbed9, 0x0, 0x0, 0xbb33, 0xbee0,
    0x0, 0x0, 0xbb33, 0xbee6, 0x0, 0x0, 0xbb33, 0xbeed,
    0x0, 0x0, 0xbb33, 0xbef4, 0x0, 0x0, 0xbb33, 0xbefa,
    0x0, 0x0, 0xbb33, 0xbf01, 0x0, 0x0, 0xbb33, 0xbf08,
    0x0, 0x0, 0xbb33, 0xbf0f, 0x0, 0x0, 0xbb33, 0xbf16,
    0x0, 0x0, 0xbb33, 0xbf1c, 0x0, 0x0, 0xbb33, 0xbf23,
    0x0, 0x0, 0xbb33, 0xbf2a, 0x0, 0x0, 0xbb33, 0xbf31,
    0x0, 0x0, 0xbb33, 0xbf39, 0x0, 0x0, 0xbb33, 0xbf40,
    0x0, 0x0, 0xbb33, 0xbf47, 0x0, 0x0, 0xbb33, 0xbf4e,
    0x0, 0x0, 0xbb33, 0xbf55, 0x0, 0x0, 0xbb33, 0xbf5d,
    0x0, 0x0, 0xbb33, 0xbf64, 0x0, 0x0, 0xbb33, 0xbf6b,
    0x0, 0x0, 0xbb33, 0xbf73, 0x0, 0x0, 0xbb33, 0xbf7a,
    0x0, 0x0, 0xbb33, 0xbf82, 0x0, 0x0, 0xbb33, 0xbf89,
    0x0, 0x0, 0xbb33, 0xbf91, 0x0, 0x0, 0xbb33, 0xbf99,
    0x0, 0x0, 0xbb33, 0xbfa0, 0x0, 0x0, 0xbb33, 0xbfa8,
    0x0, 0x0, 0xbb33, 0xbfb0, 0x0, 0x0, 0xbb33, 0xbfb8,
    0x0, 0x0, 0xbb33, 0xbfc0, 0x0, 0x0, 0xbb33, 0xbfc8,
    0x0, 0x0, 0xbb33, 0xbfd0, 0x0, 0x0, 0xbb33, 0xbfd8,
    0x0, 0x0, 0xbb33, 0xbfe0, 0x0, 0x0, 0xbb33, 0xbfe8,
    0x0, 0x0, 0xbb33, 0xbff1, 0x0, 0x0, 0xbb33, 0xbff9,
    0x0, 0x0, 0xbb33, 0xc001, 0x0, 0x0, 0xbb33, 0xc005,
    0x0, 0x0, 0xbb33, 0xc009, 0x0, 0x0, 0xbb33, 0xc00d,
    0x0, 0x0, 0xbb33, 0xc012, 0x0, 0x0, 0xbb33, 0xc016,
    0x0, 0x0, 0xbb33, 0xc01a, 0x0, 0x0, 0xbb33, 0xc01f,
    0x0, 0x0, 0xbb33, 0xc023, 0x0, 0x0, 0xbb33, 0xc028,
    0x0, 0x0, 0xbb33, 0xc02c, 0x0, 0x0, 0xbb33, 0xc031,
    0x0, 0x0, 0xbb33, 0xc035, 0x0, 0x0, 0xbb33, 0xc03a,
    0x0, 0x0, 0xbb33, 0xc03e, 0x0, 0x0, 0xbb33, 0xc043,
    0x0, 0x0, 0xbb33, 0xc048, 0x0, 0x0, 0xbb33, 0xc04d,
    0x0, 0x0, 0xbb33, 0xc051, 0x0, 0x0, 0xbb33, 0xc056,
    0x0, 0x0, 0xbb33, 0xc05b, 0x0, 0x0, 0xbb33, 0xc060,
    0x0, 0x0, 0xbb33, 0xc065, 0x0, 0x0, 0xbb33, 0xc06a,
    0x0, 0x0, 0xbb33, 0xc06f, 0x0, 0x0, 0xbb33, 0xc074,
    0x0, 0x0, 0xbb33, 0xc079, 0x0, 0x0, 0xbb33, 0xc07e,
    0x0, 0x0, 0xbb33, 0xc083, 0x0, 0x0, 0xbb33, 0xc088,
    0x0, 0x0, 0xbb33, 0xc08d, 0x0, 0x0, 0xbb33, 0xc092,
    0x0, 0x0, 0xbb33, 0xc098, 0x0, 0x0, 0xbb33, 0xc09d,
    0x0, 0x0, 0xbb33, 0xc0a2, 0x0, 0x0, 0xbb33, 0xc0a8,
    0x0, 0x0, 0xbb33, 0xc0ad, 0x0, 0x0, 0xbb33, 0xc0b3,
    0x0, 0x0, 0xbb33, 0xc0b8, 0x0, 0x0, 0xbb33, 0xc0be,
    0x0, 0x0, 0xbb33, 0xc0c4, 0x0, 0x0, 0xbb33, 0xc0c9,
    0x0, 0x0, 0xbb33, 0xc0cf, 0x0, 0x0, 0xbb33, 0xc0d5,
    0x0, 0x0, 0xbb33, 0xc0db, 0x0, 0x0, 0xbb33, 0xc0e0,
    0x0, 0x0, 0xbb33, 0xc0e6, 0x0, 0x0, 0xbb33, 0xc0ec,
    0x0, 0x0, 0xbb33, 0xc0f2, 0x0, 0x0, 0xbb33, 0xc0f8,
    0x0, 0x0, 0xbb33, 0xc0ff, 0x0, 0x0, 0xbb33, 0xc105,
    0x0, 0x0, 0xbb33, 0xc10b, 0x0, 0x0, 0xbb33, 0xc111,
    0x0, 0x0, 0xbb33, 0xc118, 0x0, 0x0, 0xbb33, 0xc11e,
    0x0, 0x0, 0xbb33, 0xc124, 0x0, 0x0, 0xbb33, 0xc12b,
    0x0, 0x0, 0xbb33, 0xc131, 0x0, 0x0, 0xbb33, 0xc138,
    0x0, 0x0, 0xbb33, 0xc13f, 0x0, 0x0, 0xbb33, 0xc146,
    0x0, 0x0, 0xbb33, 0xc14c, 0x0, 0x0, 0xbb33, 0xc153,
    0x0, 0x0, 0xbb33, 0xc15a, 0x0, 0x0, 0xbb33, 0xc161,
    0x0, 0x0, 0xbb33, 0xc168, 0x0, 0x0, 0xbb33, 0xc16f,
    0x0, 0x0, 0xbb33, 0xc176, 0x0, 0x0, 0xbb33, 0xc17e,
    0x0, 0x0, 0xbb33, 0xc185, 0x0, 0x0, 0xbb33, 0xc18c,
    0x0, 0x0, 0xbb33, 0xc194, 0x0, 0x0, 0xbb33, 0xc19b,
    0x0, 0x0, 0xbb33, 0xc1a3, 0x0, 0x0, 0xbb33, 0xc1ab,
    0x0, 0x0, 0xbb33, 0xc1b2, 0x0, 0x0, 0xbb33, 0xc1ba,
    0x0, 0x0, 0xbb33, 0xc1c2, 0x0, 0x0, 0xbb33, 0xc1ca,
    0x0, 0x0, 0xbb33, 0xc1d2, 0x0, 0x0, 0xbb33, 0xc1da,
    0x0, 0x0, 0xbb33, 0xc1e3, 0x0, 0x0, 0xbb33, 0xc1eb,
    0x0, 0x0, 0xbb33, 0xc1f3, 0x0, 0x0, 0xbb33, 0xc1fc,
    0x0, 0x0, 0xbb33, 0xc204, 0x0, 0x0, 0xbb33, 0xc20d,
    0x0, 0x0, 0xbb33, 0xc216, 0x0, 0x0, 0xbb33, 0xc21f,
    0x0, 0x0, 0xbb33, 0xc227, 0x0, 0x0, 0xbb33, 0xc230,
    0x0, 0x0, 0xbb33, 0xc23a, 0x0, 0x0, 0xbb33, 0xc243,
    0x0, 0x0, 0xbb33, 0xc24c, 0x0, 0x0, 0xbb33, 0xc255,
    0x0, 0x0, 0xbb33, 0xc25f, 0x0, 0x0, 0xbb33, 0xc269,
    0x0, 0x0, 0xbb33, 0xc272, 0x0, 0x0, 0xbb33, 0xc27c,
    0x0, 0x0, 0xbb33, 0xc286, 0x0, 0x0, 0xbb33, 0xc290,
    0x0, 0x0, 0xbb33, 0xc29a, 0x0, 0x0, 0xbb33, 0xc2a5,
    0x0, 0x0, 0xbb33, 0xc2af, 0x0, 0x0, 0xbb33, 0xc2b9,
    0x0, 0x0, 0xbb33, 0xc2c4, 0x0, 0x0, 0xbb33, 0xc2cf,
    0x0, 0x0, 0xbb33, 0xc2da, 0x0, 0x0, 0xbb33, 0xc2e5,
    0x0, 0x0, 0xbb33, 0xc2f0, 0x0, 0x0, 0xbb33, 0xc2fb,
    0x0, 0x0, 0xbb33, 0xc307, 0x0, 0x0, 0xbb33, 0xc312,
    0x0, 0x0, 0xbb33, 0xc31e, 0x0, 0x0, 0xbb33, 0xc32a,
    0x0, 0x0, 0xbb33, 0xc336, 0x0, 0x0, 0xbb33, 0xc342,
    0x0, 0x0, 0xbb33, 0xc34e, 0x0, 0x0, 0xbb33, 0xc35a,
    0x0, 0x0, 0xbb33, 0xc367, 0x0, 0x0, 0xbb33, 0xc374,
    0x0, 0x0, 0xbb33, 0xc381, 0x0, 0x0, 0xbb33, 0xc38e,
    0x0, 0x0, 0xbb33, 0xc39b, 0x0, 0x0, 0xbb33, 0xc3a8,
    0x0, 0x0, 0xbb33, 0xc3b6, 0x0, 0x0, 0xbb33, 0xc3c4,
    0x0, 0x0, 0xbb33, 0xc3d2, 0x0, 0x0, 0xbb33, 0xc3e0,
    0x0, 0x0, 0xbb33, 0xc3ee, 0x0, 0x0, 0xbb33, 0xc3fd,
    0x0, 0x0, 0xbb33, 0xc406, 0x0, 0x0, 0xbb33, 0xc40d,
    0x0, 0x0, 0xbb33, 0xc415, 0x0, 0x0, 0xbb33, 0xc41c,
    0x0, 0x0, 0xbb33, 0xc424, 0x0, 0x0, 0xbb33, 0xc42c,
    0x0, 0x0, 0xbb33, 0xc434, 0x0, 0x0, 0xbb33, 0xc43c,
    0x0, 0x0, 0xbb33, 0xc444, 0x0, 0x0, 0xbb33, 0xc44d,
    0x0, 0x0, 0xbb33, 0xc455, 0x0, 0x0, 0xbb33, 0xc45e,
    0x0, 0x0, 0xbb33, 0xc467, 0x0, 0x0, 0xbb33, 0xc470,
    0x0, 0x0, 0xbb33, 0xc479, 0x0, 0x0, 0xbb33, 0xc482,
    0x0, 0x0, 0xbb33, 0xc48b, 0x0, 0x0, 0xbb33, 0xc494,
    0x0, 0x0, 0xbb33, 0xc49e, 0x0, 0x0, 0xbb33, 0xc4a8,
    0x0, 0x0, 0xbb33, 0xc4b2, 0x0, 0x0, 0xbb33, 0xc4bc,
    0x0, 0x0, 0xbb33, 0xc4c6, 0x0, 0x0, 0xbb33, 0xc4d0,
    0x0, 0x0, 0xbb33, 0xc4db, 0x0, 0x0, 0xbb33, 0xc4e5,
    0x0, 0x0, 0xbb33, 0xc4f0, 0x0, 0x0, 0xbb33, 0xc4fb,
    0x0, 0x0, 0xbb33, 0xc507, 0x0, 0x0, 0xbb33, 0xc512,
    0x0, 0x0, 0xbb33, 0xc51e, 0x0, 0x0, 0xbb33, 0xc52a,
    0x0, 0x0, 0xbb33, 0xc536, 0x0, 0x0, 0xbb33, 0xc542,
    0x0, 0x0, 0xbb33, 0xc54f, 0x0, 0x0, 0xbb33, 0xc55c,
    0x0, 0x0, 0xbb33, 0xc568, 0x0, 0x0, 0xbb33, 0xc576,
    0x0, 0x0, 0xbb33, 0xc583, 0x0, 0x0, 0xbb33, 0xc591,
    0x0, 0x0, 0xbb33, 0xc59f, 0x0, 0x0, 0xbb33, 0xc5ad,
    0x0, 0x0, 0xbb33, 0xc5bc, 0x0, 0x0, 0xbb33, 0xc5cb,
    0x0, 0x0, 0xbb33, 0xc5da, 0x0, 0x0, 0xbb33, 0xc5e9,
    0x0, 0x0, 0xbb33, 0xc5f9, 0x0, 0x0, 0xbb33, 0xc609,
    0x0, 0x0, 0xbb33, 0xc619, 0x0, 0x0, 0xbb33, 0xc62a,
    0x0, 0x0, 0xbb33, 0xc63b, 0x0, 0x0, 0xbb33, 0xc64d,
    0x0, 0x0, 0xbb33, 0xc65f, 0x0, 0x0, 0xbb33, 0xc671,
    0x0, 0x0, 0xbb33, 0xc684, 0x0, 0x0, 0xbb33, 0xc697,
    0x0, 0x0, 0xbb33, 0xc6aa, 0x0, 0x0, 0xbb33, 0xc6be,
    0x0, 0x0, 0xbb33, 0xc6d3, 0x0, 0x0, 0xbb33, 0xc6e8,
    0x0, 0x0, 0xbb33, 0xc6fd, 0x0, 0x0, 0xbb33, 0xc713,
    0x0, 0x0, 0xbb33, 0xc729, 0x0, 0x0, 0xbb33, 0xc740,
    0x0, 0x0, 0xbb33, 0xc758, 0x0, 0x0, 0xbb33, 0xc770,
    0x0, 0x0, 0xbb33, 0xc789, 0x0, 0x0, 0xbb33, 0xc7a2,
    0x0, 0x0, 0xbb33, 0xc7bc, 0x0, 0x0, 0xbb33, 0xc7d7,
    0x0, 0x0, 0xbb33, 0xc7f3, 0x0, 0x0, 0xbb33, 0xc808,
    0x0, 0x0, 0xbb33, 0xc816, 0x0, 0x0, 0xbb33, 0xc825,
    0x0, 0x0, 0xbb33, 0xc834, 0x0, 0x0, 0xbb33, 0xc844,
    0x0, 0x0, 0xbb33, 0xc855, 0x0, 0x0, 0xbb33, 0xc865,
    0x0, 0x0, 0xbb33, 0xc877, 0x0, 0x0, 0xbb33, 0xc889,
    0x0, 0x0, 0xbb33, 0xc89b, 0x0, 0x0, 0xbb33, 0xc8ae,
    0x0, 0x0, 0xbb33, 0xc8c1, 0x0, 0x0, 0xbb33, 0xc8d6,
    0x0, 0x0, 0xbb33, 0xc8eb, 0x0, 0x0, 0xbb33, 0xc900,
    0x0, 0x0, 0xbb33, 0xc917, 0x0, 0x0, 0xbb33, 0xc92e,
    0x0, 0x0, 0xbb33, 0xc946, 0x0, 0x0, 0xbb33, 0xc95f,
    0x0, 0x0, 0xbb33, 0xc979, 0x0, 0x0, 0xbb33, 0xc993,
    0x0, 0x0, 0xbb33, 0xc9af, 0x0, 0x0, 0xbb33, 0xc9cc,
    0x0, 0x0, 0xbb33, 0xc9ea, 0x0, 0x0, 0xbb33, 0xca0a,
    0x0, 0x0, 0xbb33, 0xca2a, 0x0, 0x0, 0xbb33, 0xca4c,
    0x0, 0x0, 0xbb33, 0xca70, 0x0, 0x0, 0xbb33, 0xca95,
    0x0, 0x0, 0xbb33, 0xcabc, 0x0, 0x0, 0xbb33, 0xcae5,
    0x0, 0x0, 0xbb33, 0xcb0f, 0x0, 0x0, 0xbb33, 0xcb3c,
    0x0, 0x0, 0xbb33, 0xcb6b, 0x0, 0x0, 0xbb33, 0xcb9c,
    0x0, 0x0, 0xbb33, 0xcbd0, 0x0, 0x0, 0xbb33, 0xcc04,
    0x0, 0x0, 0xbb33, 0xcc21, 0x0, 0x0, 0xbb33, 0xcc3f,
    0x0, 0x0, 0xbb33, 0xcc60, 0x0, 0x0, 0xbb33, 0xcc82,
    0x0, 0x0, 0xbb33, 0xcca7, 0x0, 0x0, 0xbb33, 0xccce,
    0x0, 0x0, 0xbb33, 0xccf8, 0x0, 0x0, 0xbb33, 0xcd25,
    0x0, 0x0, 0xbb33, 0xcd55, 0x0, 0x0, 0xbb33, 0xcd88,
    0x0, 0x0, 0xbb33, 0xcdc0, 0x0, 0x0, 0xbb33, 0xcdfc,
    0x0, 0x0, 0xbb33, 0xce3d, 0x0, 0x0, 0xbb33, 0xce84,
    0x0, 0x0, 0xbb33, 0xced2, 0x0, 0x0, 0xbb33, 0xcf27,
    0x0, 0x0, 0xbb33, 0xcf85, 0x0, 0x0, 0xbb33, 0xcfed,
    0x0, 0x0, 0xbb33, 0xd031, 0x0, 0x0, 0xbb33, 0xd072,
    0x0, 0x0, 0xbb33, 0xd0bb, 0x0, 0x0, 0xbb33, 0xd10f,
    0x0, 0x0, 0xbb33, 0xd16f, 0x0, 0x0, 0xbb33, 0xd1de,
    0x0, 0x0, 0xbb33, 0xd260, 0x0, 0x0, 0xbb33, 0xd2fc,
    0x0, 0x0, 0xbb33, 0xd3b8, 0x0, 0x0, 0xbb33, 0xd450,
    0x0, 0x0, 0xbb33, 0xd4e4, 0x0, 0x0, 0xbb33, 0xd5a4,
    0x0, 0x0, 0xbb33, 0xd6ab, 0x0, 0x0, 0xbb33, 0xd813,
    0x0, 0x0, 0xbb33, 0xd93d, 0x0, 0x0, 0xbb33, 0xdb55,
    0x0, 0x0, 0xbb33, 0xde1d, 0x0, 0x0, 0xbb33, 0xe495
    };

