static const q15_t in_cfft_noisy_16[32] = {
    0xFA9D, 0x0000, 0x3EEA, 0x0000, 0x5CA6, 0x0000, 0x49F5, 0x0000,
    0x01E9, 0x0000, 0xCB2E, 0x0000, 0xA381, 0x0000, 0xC409, 0x0000,
    0x031C, 0x0000, 0x3E09, 0x0000, 0x555A, 0x0000, 0x4000, 0x0000,
    0xFF1A, 0x0000, 0xC05C, 0x0000, 0xA3F8, 0x0000, 0xBFCA, 0x0000
    };

static const q15_t in_cifft_noisy_16[32] = {
    0x00E8, 0x0000, 0xFF99, 0xFE33, 0xFEE1, 0xD317, 0xFF18, 0x0013,
    0x0054, 0x0055, 0xFF28, 0x0054, 0x00B6, 0x0067, 0x0007, 0xFF28,
    0xFE1F, 0x0000, 0x0007, 0x00D8, 0x00B6, 0xFF99, 0xFF28, 0xFFAC,
    0x0054, 0xFFAB, 0xFF18, 0xFFED, 0xFEE1, 0x2CE9, 0xFF99, 0x01CD
    };

static const q15_t ref_cfft_noisy_16[32] = {
    0x00E8, 0x0000, 0xFF99, 0xFE33, 0xFEE1, 0xD317, 0xFF18, 0x0013,
    0x0054, 0x0055, 0xFF28, 0x0054, 0x00B6, 0x0067, 0x0007, 0xFF28,
    0xFE1F, 0x0000, 0x0007, 0x00D8, 0x00B6, 0xFF99, 0xFF28, 0xFFAC,
    0x0054, 0xFFAB, 0xFF18, 0xFFED, 0xFEE1, 0x2CE9, 0xFF99, 0x01CD
    };

static const q15_t in_cfft_noisy_32[64] = {
    0x0624, 0x0000, 0x3B86, 0x0000, 0x6255, 0x0000, 0x3C6D, 0x0000,
    0xF810, 0x0000, 0xC22C, 0x0000, 0xA798, 0x0000, 0xC1F6, 0x0000,
    0xF5AA, 0x0000, 0x49EE, 0x0000, 0x5CD9, 0x0000, 0x427A, 0x0000,
    0xF255, 0x0000, 0xC41B, 0x0000, 0xA4B6, 0x0000, 0xBD9D, 0x0000,
    0x0541, 0x0000, 0x3973, 0x0000, 0x593B, 0x0000, 0x3AB5, 0x0000,
    0xF5C1, 0x0000, 0xBE4A, 0x0000, 0xA1E7, 0x0000, 0xC9EC, 0x0000,
    0x05F3, 0x0000, 0x45BD, 0x0000, 0x5789, 0x0000, 0x3B32, 0x0000,
    0x04C3, 0x0000, 0xC5D7, 0x0000, 0xB626, 0x0000, 0xBF51, 0x0000
    };

static const q15_t in_cifft_noisy_32[64] = {
    0x0067, 0x0000, 0x0154, 0x0078, 0xFFDE, 0x011E, 0x0045, 0x000C,
    0x0161, 0xD394, 0xFEE3, 0x00EC, 0xFF5E, 0x0015, 0xFFF6, 0xFEB0,
    0xFEBD, 0xFF75, 0xFF78, 0x00DB, 0x0089, 0x0036, 0xFFA4, 0xFFE0,
    0x00C0, 0x004E, 0xFF7C, 0xFF9C, 0x0234, 0x0017, 0x012F, 0xFF2D,
    0xFF9C, 0x0000, 0x012F, 0x00D3, 0x0234, 0xFFE9, 0xFF7C, 0x0064,
    0x00C0, 0xFFB2, 0xFFA4, 0x0020, 0x0089, 0xFFCA, 0xFF78, 0xFF25,
    0xFEBD, 0x008B, 0xFFF6, 0x0150, 0xFF5E, 0xFFEB, 0xFEE3, 0xFF14,
    0x0161, 0x2C6C, 0x0045, 0xFFF4, 0xFFDE, 0xFEE2, 0x0154, 0xFF88
    };

static const q15_t ref_cfft_noisy_32[64] = {
    0x0067, 0x0000, 0x0154, 0x0078, 0xFFDE, 0x011E, 0x0045, 0x000C,
    0x0161, 0xD394, 0xFEE3, 0x00EC, 0xFF5E, 0x0015, 0xFFF6, 0xFEB0,
    0xFEBD, 0xFF75, 0xFF78, 0x00DB, 0x0089, 0x0036, 0xFFA4, 0xFFE0,
    0x00C0, 0x004E, 0xFF7C, 0xFF9C, 0x0234, 0x0017, 0x012F, 0xFF2D,
    0xFF9C, 0x0000, 0x012F, 0x00D3, 0x0234, 0xFFE9, 0xFF7C, 0x0064,
    0x00C0, 0xFFB2, 0xFFA4, 0x0020, 0x0089, 0xFFCA, 0xFF78, 0xFF25,
    0xFEBD, 0x008B, 0xFFF6, 0x0150, 0xFF5E, 0xFFEB, 0xFEE3, 0xFF14,
    0x0161, 0x2C6C, 0x0045, 0xFFF4, 0xFFDE, 0xFEE2, 0x0154, 0xFF88
    };

static const q15_t in_cfft_noisy_64[128] = {
    0xFB98, 0x0000, 0x4279, 0x0000, 0x56C1, 0x0000, 0x3905, 0x0000,
    0xFE9D, 0x0000, 0xBDDA, 0x0000, 0xAC98, 0x0000, 0xC19A, 0x0000,
    0x0E6D, 0x0000, 0x42C5, 0x0000, 0x5FDF, 0x0000, 0x390F, 0x0000,
    0xFCB6, 0x0000, 0xBFD4, 0x0000, 0xA96E, 0x0000, 0xC7A0, 0x0000,
    0x04CD, 0x0000, 0x3BD5, 0x0000, 0x5B05, 0x0000, 0x3CCE, 0x0000,
    0x0587, 0x0000, 0xC2BE, 0x0000, 0xA8FE, 0x0000, 0xC12C, 0x0000,
    0x02A7, 0x0000, 0x44BB, 0x0000, 0x576C, 0x0000, 0x3C36, 0x0000,
    0xFE3D, 0x0000, 0xBE44, 0x0000, 0xA6DE, 0x0000, 0xCC9F, 0x0000,
    0xFE3B, 0x0000, 0x3EF1, 0x0000, 0x681E, 0x0000, 0x40D2, 0x0000,
    0xFBF6, 0x0000, 0xBF51, 0x0000, 0x9F9F, 0x0000, 0xBC7B, 0x0000,
    0xFEEA, 0x0000, 0x3A25, 0x0000, 0x5677, 0x0000, 0x3DB3, 0x0000,
    0x0A14, 0x0000, 0xC72E, 0x0000, 0xA704, 0x0000, 0xC187, 0x0000,
    0x041B, 0x0000, 0x422D, 0x0000, 0x568F, 0x0000, 0x4C5E, 0x0000,
    0xF560, 0x0000, 0xC57A, 0x0000, 0xA86B, 0x0000, 0xC766, 0x0000,
    0xF82B, 0x0000, 0x3A4D, 0x0000, 0x5C42, 0x0000, 0x329E, 0x0000,
    0x000D, 0x0000, 0xCE7F, 0x0000, 0xA442, 0x0000, 0xB8A8, 0x0000
    };

static const q15_t in_cifft_noisy_64[128] = {
    0x00AD, 0x0000, 0xFFBE, 0xFFAD, 0xFF6A, 0xFFF1, 0xFF74, 0xFF60,
    0x0063, 0xFFF5, 0xFF23, 0x00B8, 0x0069, 0x0005, 0xFFF1, 0x012D,
    0x006B, 0xD3AC, 0x001A, 0xFFAB, 0xFFAD, 0xFF8C, 0xFF1B, 0xFFC7,
    0xFF4D, 0xFFD1, 0x00B9, 0xFF7D, 0xFF90, 0xFFE8, 0xFFF3, 0xFF76,
    0xFFC7, 0xFFA5, 0xFFDD, 0xFF4B, 0xFFA3, 0xFF4C, 0x00DA, 0xFED2,
    0x006F, 0x007D, 0x00B0, 0xFFD1, 0xFFBA, 0x0084, 0x004A, 0xFFA4,
    0x0018, 0x00B7, 0x002D, 0x0023, 0xFFA3, 0x0031, 0xFEDF, 0xFFA3,
    0xFF8A, 0xFFA9, 0x0065, 0xFFCB, 0x000F, 0x00D9, 0x000E, 0x00E2,
    0x001C, 0x0000, 0x000E, 0xFF1E, 0x000F, 0xFF27, 0x0065, 0x0035,
    0xFF8A, 0x0057, 0xFEDF, 0x005D, 0xFFA3, 0xFFCF, 0x002D, 0xFFDD,
    0x0018, 0xFF49, 0x004A, 0x005C, 0xFFBA, 0xFF7C, 0x00B0, 0x002F,
    0x006F, 0xFF83, 0x00DA, 0x012E, 0xFFA3, 0x00B4, 0xFFDD, 0x00B5,
    0xFFC7, 0x005B, 0xFFF3, 0x008A, 0xFF90, 0x0018, 0x00B9, 0x0083,
    0xFF4D, 0x002F, 0xFF1B, 0x0039, 0xFFAD, 0x0074, 0x001A, 0x0055,
    0x006B, 0x2C54, 0xFFF1, 0xFED3, 0x0069, 0xFFFB, 0xFF23, 0xFF48,
    0x0063, 0x000B, 0xFF74, 0x00A0, 0xFF6A, 0x000F, 0xFFBE, 0x0053
    };

static const q15_t ref_cfft_noisy_64[128] = {
    0x00AD, 0x0000, 0xFFBE, 0xFFAD, 0xFF6A, 0xFFF1, 0xFF74, 0xFF60,
    0x0063, 0xFFF5, 0xFF23, 0x00B8, 0x0069, 0x0005, 0xFFF1, 0x012D,
    0x006B, 0xD3AC, 0x001A, 0xFFAB, 0xFFAD, 0xFF8C, 0xFF1B, 0xFFC7,
    0xFF4D, 0xFFD1, 0x00B9, 0xFF7D, 0xFF90, 0xFFE8, 0xFFF3, 0xFF76,
    0xFFC7, 0xFFA5, 0xFFDD, 0xFF4B, 0xFFA3, 0xFF4C, 0x00DA, 0xFED2,
    0x006F, 0x007D, 0x00B0, 0xFFD1, 0xFFBA, 0x0084, 0x004A, 0xFFA4,
    0x0018, 0x00B7, 0x002D, 0x0023, 0xFFA3, 0x0031, 0xFEDF, 0xFFA3,
    0xFF8A, 0xFFA9, 0x0065, 0xFFCB, 0x000F, 0x00D9, 0x000E, 0x00E2,
    0x001C, 0x0000, 0x000E, 0xFF1E, 0x000F, 0xFF27, 0x0065, 0x0035,
    0xFF8A, 0x0057, 0xFEDF, 0x005D, 0xFFA3, 0xFFCF, 0x002D, 0xFFDD,
    0x0018, 0xFF49, 0x004A, 0x005C, 0xFFBA, 0xFF7C, 0x00B0, 0x002F,
    0x006F, 0xFF83, 0x00DA, 0x012E, 0xFFA3, 0x00B4, 0xFFDD, 0x00B5,
    0xFFC7, 0x005B, 0xFFF3, 0x008A, 0xFF90, 0x0018, 0x00B9, 0x0083,
    0xFF4D, 0x002F, 0xFF1B, 0x0039, 0xFFAD, 0x0074, 0x001A, 0x0055,
    0x006B, 0x2C54, 0xFFF1, 0xFED3, 0x0069, 0xFFFB, 0xFF23, 0xFF48,
    0x0063, 0x000B, 0xFF74, 0x00A0, 0xFF6A, 0x000F, 0xFFBE, 0x0053
    };

static const q15_t in_cfft_noisy_128[256] = {
    0xFEDB, 0x0000, 0x43DA, 0x0000, 0x54A0, 0x0000, 0x4144, 0x0000,
    0xFD34, 0x0000, 0xC70D, 0x0000, 0xA576, 0x0000, 0xC6C1, 0x0000,
    0xFF6E, 0x0000, 0x3C77, 0x0000, 0x5B36, 0x0000, 0x4738, 0x0000,
    0x0698, 0x0000, 0xC5B3, 0x0000, 0xAAD5, 0x0000, 0xC478, 0x0000,
    0xFC9D, 0x0000, 0x429F, 0x0000, 0x5AD1, 0x0000, 0x3F54, 0x0000,
    0x064F, 0x0000, 0xBB0D, 0x0000, 0xA7C1, 0x0000, 0xB76B, 0x0000,
    0xF807, 0x0000, 0x39E8, 0x0000, 0x54E4, 0x0000, 0x3487, 0x0000,
    0xFB59, 0x0000, 0xC240, 0x0000, 0xA6D6, 0x0000, 0xB8D2, 0x0000,
    0x001E, 0x0000, 0x3DFE, 0x0000, 0x4CA1, 0x0000, 0x4001, 0x0000,
    0x01AC, 0x0000, 0xC375, 0x0000, 0xA740, 0x0000, 0xBF51, 0x0000,
    0x05E4, 0x0000, 0x426C, 0x0000, 0x5E1D, 0x0000, 0x3A98, 0x0000,
    0x01D8, 0x0000, 0xC6CD, 0x0000, 0xABA7, 0x0000, 0xBAE3, 0x0000,
    0xFEEB, 0x0000, 0x4006, 0x0000, 0x5BE0, 0x0000, 0x424B, 0x0000,
    0x043E, 0x0000, 0xC774, 0x0000, 0xA8A7, 0x0000, 0xBCAB, 0x0000,
    0x01AE, 0x0000, 0x4274, 0x0000, 0x5838, 0x0000, 0x3765, 0x0000,
    0xF9E1, 0x0000, 0xC0BC, 0x0000, 0xA864, 0x0000, 0xC1F6, 0x0000,
    0xF7F2, 0x0000, 0x498C, 0x0000, 0x5792, 0x0000, 0x4E23, 0x0000,
    0xFFD8, 0x0000, 0xBC28, 0x0000, 0xA6CB, 0x0000, 0xC129, 0x0000,
    0xF654, 0x0000, 0x3D7F, 0x0000, 0x4D59, 0x0000, 0x4098, 0x0000,
    0x11B2, 0x0000, 0xC1DE, 0x0000, 0xAB13, 0x0000, 0xC578, 0x0000,
    0xFCFC, 0x0000, 0x4475, 0x0000, 0x5B2A, 0x0000, 0x3AEE, 0x0000,
    0x0215, 0x0000, 0xB88F, 0x0000, 0xAC39, 0x0000, 0xC8A8, 0x0000,
    0x01A1, 0x0000, 0x4F06, 0x0000, 0x5AAB, 0x0000, 0x4300, 0x0000,
    0x0429, 0x0000, 0xC89A, 0x0000, 0xA863, 0x0000, 0xBBD9, 0x0000,
    0xFC13, 0x0000, 0x418F, 0x0000, 0x4D40, 0x0000, 0x3B55, 0x0000,
    0x07D5, 0x0000, 0xB4A4, 0x0000, 0xA67F, 0x0000, 0xB870, 0x0000,
    0xFB6D, 0x0000, 0x4C63, 0x0000, 0x61C6, 0x0000, 0x3435, 0x0000,
    0x05A2, 0x0000, 0xC30A, 0x0000, 0x9C4B, 0x0000, 0xC387, 0x0000,
    0x009B, 0x0000, 0x3E7F, 0x0000, 0x55FE, 0x0000, 0x3C81, 0x0000,
    0xFF26, 0x0000, 0xC404, 0x0000, 0xAFE6, 0x0000, 0xB7B1, 0x0000,
    0xFBA3, 0x0000, 0x37BD, 0x0000, 0x6335, 0x0000, 0x4513, 0x0000,
    0x0383, 0x0000, 0xC7E2, 0x0000, 0xB0ED, 0x0000, 0xBB27, 0x0000
    };

static const q15_t in_cifft_noisy_128[256] = {
    0x0064, 0x0000, 0xFFF2, 0x0048, 0x0084, 0xFFCE, 0x00E9, 0xFF7D,
    0xFF82, 0xFFE3, 0xFF64, 0x0020, 0x003B, 0x0026, 0x0068, 0x0099,
    0x0012, 0x0069, 0xFF71, 0x002E, 0x009D, 0xFF6E, 0xFF9C, 0x00C9,
    0x001E, 0xFFF5, 0x0038, 0x0075, 0xFF90, 0xFFF2, 0xFF98, 0xFFE8,
    0xFF55, 0xD377, 0x0009, 0x002B, 0xFFD5, 0x0023, 0xFFCE, 0x001C,
    0xFFF0, 0x001F, 0xFFC7, 0xFF66, 0x0099, 0xFF78, 0x0062, 0xFFF4,
    0xFFBE, 0x0012, 0x00A7, 0x001D, 0xFF97, 0xFFD8, 0x0044, 0xFFF0,
    0xFFC0, 0x005A, 0x0013, 0xFFF8, 0xFF1D, 0x006F, 0xFFE5, 0xFFE2,
    0xFFF6, 0xFF3E, 0xFFDB, 0x000B, 0x0023, 0x0044, 0xFFCC, 0x0007,
    0x0023, 0xFF74, 0xFFF0, 0xFF8E, 0xFF9E, 0xFFBE, 0x0055, 0xFF8E,
    0x00A5, 0xFFD1, 0xFFCD, 0x000F, 0xFF81, 0x0053, 0xFF69, 0xFFD4,
    0x0051, 0xFF47, 0x004D, 0xFFF6, 0x0089, 0xFFA0, 0x0022, 0x00D8,
    0xFF58, 0xFF49, 0x006A, 0xFFAB, 0x0002, 0x0076, 0x0066, 0x000B,
    0x0053, 0xFFC4, 0x002D, 0xFFFC, 0xFFCE, 0xFFE0, 0x0029, 0x0009,
    0xFF7C, 0xFFD6, 0xFF9F, 0x000B, 0x000E, 0xFF57, 0x0094, 0xFFB6,
    0xFF86, 0xFFA5, 0x001A, 0xFFCC, 0xFF9C, 0xFF9F, 0x0050, 0x001A,
    0xFFFA, 0x0000, 0x0050, 0xFFE6, 0xFF9C, 0x0061, 0x001A, 0x0034,
    0xFF86, 0x005B, 0x0094, 0x004A, 0x000E, 0x00A9, 0xFF9F, 0xFFF5,
    0xFF7C, 0x002A, 0x0029, 0xFFF7, 0xFFCE, 0x0020, 0x002D, 0x0004,
    0x0053, 0x003C, 0x0066, 0xFFF5, 0x0002, 0xFF8A, 0x006A, 0x0055,
    0xFF58, 0x00B7, 0x0022, 0xFF28, 0x0089, 0x0060, 0x004D, 0x000A,
    0x0051, 0x00B9, 0xFF69, 0x002C, 0xFF81, 0xFFAD, 0xFFCD, 0xFFF1,
    0x00A5, 0x002F, 0x0055, 0x0072, 0xFF9E, 0x0042, 0xFFF0, 0x0072,
    0x0023, 0x008C, 0xFFCC, 0xFFF9, 0x0023, 0xFFBC, 0xFFDB, 0xFFF5,
    0xFFF6, 0x00C2, 0xFFE5, 0x001E, 0xFF1D, 0xFF91, 0x0013, 0x0008,
    0xFFC0, 0xFFA6, 0x0044, 0x0010, 0xFF97, 0x0028, 0x00A7, 0xFFE3,
    0xFFBE, 0xFFEE, 0x0062, 0x000C, 0x0099, 0x0088, 0xFFC7, 0x009A,
    0xFFF0, 0xFFE1, 0xFFCE, 0xFFE4, 0xFFD5, 0xFFDD, 0x0009, 0xFFD5,
    0xFF55, 0x2C89, 0xFF98, 0x0018, 0xFF90, 0x000E, 0x0038, 0xFF8B,
    0x001E, 0x000B, 0xFF9C, 0xFF37, 0x009D, 0x0092, 0xFF71, 0xFFD2,
    0x0012, 0xFF97, 0x0068, 0xFF67, 0x003B, 0xFFDA, 0xFF64, 0xFFE0,
    0xFF82, 0x001D, 0x00E9, 0x0083, 0x0084, 0x0032, 0xFFF2, 0xFFB8
    };

static const q15_t ref_cfft_noisy_128[256] = {
    0x0064, 0x0000, 0xFFF2, 0x0048, 0x0084, 0xFFCE, 0x00E9, 0xFF7D,
    0xFF82, 0xFFE3, 0xFF64, 0x0020, 0x003B, 0x0026, 0x0068, 0x0099,
    0x0012, 0x0069, 0xFF71, 0x002E, 0x009D, 0xFF6E, 0xFF9C, 0x00C9,
    0x001E, 0xFFF5, 0x0038, 0x0075, 0xFF90, 0xFFF2, 0xFF98, 0xFFE8,
    0xFF55, 0xD377, 0x0009, 0x002B, 0xFFD5, 0x0023, 0xFFCE, 0x001C,
    0xFFF0, 0x001F, 0xFFC7, 0xFF66, 0x0099, 0xFF78, 0x0062, 0xFFF4,
    0xFFBE, 0x0012, 0x00A7, 0x001D, 0xFF97, 0xFFD8, 0x0044, 0xFFF0,
    0xFFC0, 0x005A, 0x0013, 0xFFF8, 0xFF1D, 0x006F, 0xFFE5, 0xFFE2,
    0xFFF6, 0xFF3E, 0xFFDB, 0x000B, 0x0023, 0x0044, 0xFFCC, 0x0007,
    0x0023, 0xFF74, 0xFFF0, 0xFF8E, 0xFF9E, 0xFFBE, 0x0055, 0xFF8E,
    0x00A5, 0xFFD1, 0xFFCD, 0x000F, 0xFF81, 0x0053, 0xFF69, 0xFFD4,
    0x0051, 0xFF47, 0x004D, 0xFFF6, 0x0089, 0xFFA0, 0x0022, 0x00D8,
    0xFF58, 0xFF49, 0x006A, 0xFFAB, 0x0002, 0x0076, 0x0066, 0x000B,
    0x0053, 0xFFC4, 0x002D, 0xFFFC, 0xFFCE, 0xFFE0, 0x0029, 0x0009,
    0xFF7C, 0xFFD6, 0xFF9F, 0x000B, 0x000E, 0xFF57, 0x0094, 0xFFB6,
    0xFF86, 0xFFA5, 0x001A, 0xFFCC, 0xFF9C, 0xFF9F, 0x0050, 0x001A,
    0xFFFA, 0x0000, 0x0050, 0xFFE6, 0xFF9C, 0x0061, 0x001A, 0x0034,
    0xFF86, 0x005B, 0x0094, 0x004A, 0x000E, 0x00A9, 0xFF9F, 0xFFF5,
    0xFF7C, 0x002A, 0x0029, 0xFFF7, 0xFFCE, 0x0020, 0x002D, 0x0004,
    0x0053, 0x003C, 0x0066, 0xFFF5, 0x0002, 0xFF8A, 0x006A, 0x0055,
    0xFF58, 0x00B7, 0x0022, 0xFF28, 0x0089, 0x0060, 0x004D, 0x000A,
    0x0051, 0x00B9, 0xFF69, 0x002C, 0xFF81, 0xFFAD, 0xFFCD, 0xFFF1,
    0x00A5, 0x002F, 0x0055, 0x0072, 0xFF9E, 0x0042, 0xFFF0, 0x0072,
    0x0023, 0x008C, 0xFFCC, 0xFFF9, 0x0023, 0xFFBC, 0xFFDB, 0xFFF5,
    0xFFF6, 0x00C2, 0xFFE5, 0x001E, 0xFF1D, 0xFF91, 0x0013, 0x0008,
    0xFFC0, 0xFFA6, 0x0044, 0x0010, 0xFF97, 0x0028, 0x00A7, 0xFFE3,
    0xFFBE, 0xFFEE, 0x0062, 0x000C, 0x0099, 0x0088, 0xFFC7, 0x009A,
    0xFFF0, 0xFFE1, 0xFFCE, 0xFFE4, 0xFFD5, 0xFFDD, 0x0009, 0xFFD5,
    0xFF55, 0x2C89, 0xFF98, 0x0018, 0xFF90, 0x000E, 0x0038, 0xFF8B,
    0x001E, 0x000B, 0xFF9C, 0xFF37, 0x009D, 0x0092, 0xFF71, 0xFFD2,
    0x0012, 0xFF97, 0x0068, 0xFF67, 0x003B, 0xFFDA, 0xFF64, 0xFFE0,
    0xFF82, 0x001D, 0x00E9, 0x0083, 0x0084, 0x0032, 0xFFF2, 0xFFB8
    };

static const q15_t in_cfft_noisy_256[512] = {
    0x04E8, 0x0000, 0x3B40, 0x0000, 0x562D, 0x0000, 0x33B2, 0x0000,
    0x04C3, 0x0000, 0xC3F6, 0x0000, 0xAD00, 0x0000, 0xBCBE, 0x0000,
    0x03A8, 0x0000, 0x33CD, 0x0000, 0x5BBF, 0x0000, 0x4091, 0x0000,
    0x022E, 0x0000, 0xC43E, 0x0000, 0x9B36, 0x0000, 0xB264, 0x0000,
    0x0962, 0x0000, 0x3B61, 0x0000, 0x5CA3, 0x0000, 0x4369, 0x0000,
    0xFCA4, 0x0000, 0xCC1B, 0x0000, 0xA9DA, 0x0000, 0xBF68, 0x0000,
    0xF96A, 0x0000, 0x3C16, 0x0000, 0x5575, 0x0000, 0x3E45, 0x0000,
    0xF92A, 0x0000, 0xC504, 0x0000, 0xA1D3, 0x0000, 0xBF0E, 0x0000,
    0xFC1C, 0x0000, 0x47E9, 0x0000, 0x6150, 0x0000, 0x35E6, 0x0000,
    0xF7DE, 0x0000, 0xBCB9, 0x0000, 0xA1ED, 0x0000, 0xC1FD, 0x0000,
    0x0579, 0x0000, 0x441C, 0x0000, 0x57F1, 0x0000, 0x3AB2, 0x0000,
    0xF1E5, 0x0000, 0xBBDD, 0x0000, 0xA7A7, 0x0000, 0xC00E, 0x0000,
    0x07A6, 0x0000, 0x3914, 0x0000, 0x4F89, 0x0000, 0x3315, 0x0000,
    0xF7C6, 0x0000, 0xC149, 0x0000, 0xA7A7, 0x0000, 0xC35B, 0x0000,
    0x0196, 0x0000, 0x3A70, 0x0000, 0x651C, 0x0000, 0x41A2, 0x0000,
    0x00DD, 0x0000, 0xB9AC, 0x0000, 0xAB5D, 0x0000, 0xC38D, 0x0000,
    0x0021, 0x0000, 0x403B, 0x0000, 0x6233, 0x0000, 0x4B6D, 0x0000,
    0x067C, 0x0000, 0xB4AA, 0x0000, 0x9DDD, 0x0000, 0xBFC3, 0x0000,
    0x0088, 0x0000, 0x4699, 0x0000, 0x5A23, 0x0000, 0x434F, 0x0000,
    0xF681, 0x0000, 0xC1CB, 0x0000, 0xA30E, 0x0000, 0xB996, 0x0000,
    0x00CF, 0x0000, 0x3D05, 0x0000, 0x4A45, 0x0000, 0x3E1F, 0x0000,
    0x038F, 0x0000, 0xC4C0, 0x0000, 0xB0F2, 0x0000, 0xC408, 0x0000,
    0xFD43, 0x0000, 0x3E02, 0x0000, 0x5618, 0x0000, 0x3C90, 0x0000,
    0xFFA2, 0x0000, 0xC9F2, 0x0000, 0xA730, 0x0000, 0xC3A2, 0x0000,
    0xFA63, 0x0000, 0x40D7, 0x0000, 0x4E59, 0x0000, 0x4675, 0x0000,
    0x007D, 0x0000, 0xC6E0, 0x0000, 0xAC66, 0x0000, 0xC527, 0x0000,
    0xF7B8, 0x0000, 0x3871, 0x0000, 0x5DD7, 0x0000, 0x3ED5, 0x0000,
    0xF963, 0x0000, 0xC6F5, 0x0000, 0xA9AE, 0x0000, 0xC5A4, 0x0000,
    0x08BE, 0x0000, 0x3D46, 0x0000, 0x5689, 0x0000, 0x3EFB, 0x0000,
    0x0922, 0x0000, 0xC274, 0x0000, 0xAB14, 0x0000, 0xC931, 0x0000,
    0x0550, 0x0000, 0x3F62, 0x0000, 0x5705, 0x0000, 0x357E, 0x0000,
    0x0069, 0x0000, 0xBB8F, 0x0000, 0x9AC1, 0x0000, 0xB9FE, 0x0000,
    0xFA29, 0x0000, 0x3C5A, 0x0000, 0x6433, 0x0000, 0x32ED, 0x0000,
    0xFA04, 0x0000, 0xC4A2, 0x0000, 0x9F00, 0x0000, 0xCEE7, 0x0000,
    0xFDA0, 0x0000, 0x354B, 0x0000, 0x5F9A, 0x0000, 0x44A7, 0x0000,
    0xF321, 0x0000, 0xBAA9, 0x0000, 0xA1DB, 0x0000, 0xC3E5, 0x0000,
    0x07BA, 0x0000, 0x39C1, 0x0000, 0x4C11, 0x0000, 0x39C7, 0x0000,
    0x08A3, 0x0000, 0xB44D, 0x0000, 0xAB9A, 0x0000, 0xBB70, 0x0000,
    0xFC7B, 0x0000, 0x4B34, 0x0000, 0x5933, 0x0000, 0x387E, 0x0000,
    0x03E4, 0x0000, 0xC5D7, 0x0000, 0xA822, 0x0000, 0xC30F, 0x0000,
    0x0198, 0x0000, 0x397F, 0x0000, 0x57D3, 0x0000, 0x3080, 0x0000,
    0x021D, 0x0000, 0xC361, 0x0000, 0xA2BC, 0x0000, 0xB62C, 0x0000,
    0x0181, 0x0000, 0x34CE, 0x0000, 0x64C6, 0x0000, 0x4735, 0x0000,
    0x0356, 0x0000, 0xBC8E, 0x0000, 0x9EA4, 0x0000, 0xBEDC, 0x0000,
    0x03B8, 0x0000, 0x3A0C, 0x0000, 0x5E1A, 0x0000, 0x3BA6, 0x0000,
    0x0747, 0x0000, 0xBE4F, 0x0000, 0xA2F0, 0x0000, 0xBE73, 0x0000,
    0x0245, 0x0000, 0x38E9, 0x0000, 0x595B, 0x0000, 0x475C, 0x0000,
    0x0646, 0x0000, 0xBE00, 0x0000, 0xA0C3, 0x0000, 0xC06A, 0x0000,
    0x02F6, 0x0000, 0x3C63, 0x0000, 0x5D97, 0x0000, 0x3A0A, 0x0000,
    0xF66C, 0x0000, 0xBC72, 0x0000, 0xAA76, 0x0000, 0xBF5D, 0x0000,
    0xFB14, 0x0000, 0x3F4C, 0x0000, 0x5D7F, 0x0000, 0x4317, 0x0000,
    0xF96D, 0x0000, 0xBD22, 0x0000, 0xA9A8, 0x0000, 0xBFED, 0x0000,
    0x0365, 0x0000, 0x3D34, 0x0000, 0x5722, 0x0000, 0x42A9, 0x0000,
    0x12C8, 0x0000, 0xB834, 0x0000, 0xB0DC, 0x0000, 0xB5F0, 0x0000,
    0xFD93, 0x0000, 0x4523, 0x0000, 0x608E, 0x0000, 0x3E8D, 0x0000,
    0x0523, 0x0000, 0xBCA3, 0x0000, 0xA5E6, 0x0000, 0xC76E, 0x0000,
    0xFBCD, 0x0000, 0x4A34, 0x0000, 0x4EC9, 0x0000, 0x39FE, 0x0000,
    0x07FA, 0x0000, 0xBBD9, 0x0000, 0xABC9, 0x0000, 0xC30F, 0x0000,
    0xFD93, 0x0000, 0x3BB4, 0x0000, 0x53B7, 0x0000, 0x3E31, 0x0000,
    0x07F9, 0x0000, 0xC0B5, 0x0000, 0xACAC, 0x0000, 0xBC20, 0x0000,
    0x020D, 0x0000, 0x3AA0, 0x0000, 0x5FC1, 0x0000, 0x398E, 0x0000,
    0x0896, 0x0000, 0xCB93, 0x0000, 0xA568, 0x0000, 0xBEEB, 0x0000,
    0x00CE, 0x0000, 0x3FD0, 0x0000, 0x5D7F, 0x0000, 0x3E99, 0x0000,
    0x03FB, 0x0000, 0xC2D7, 0x0000, 0xA442, 0x0000, 0xB60E, 0x0000
    };

static const q15_t in_cifft_noisy_256[512] = {
    0xFF9B, 0x0000, 0x001B, 0x000F, 0xFFFA, 0x008A, 0x0023, 0xFFFA,
    0xFFED, 0x0027, 0x0019, 0xFFA9, 0xFFAD, 0x001E, 0x0028, 0x0053,
    0xFFF9, 0x0061, 0xFFEF, 0xFFC9, 0xFF8B, 0xFFDC, 0x0013, 0x0064,
    0xFFEF, 0xFFD3, 0x003B, 0x0032, 0xFFA9, 0xFFB0, 0x004C, 0xFFE3,
    0xFFAC, 0xFFEF, 0xFFDE, 0x0009, 0x000F, 0xFFB7, 0xFFB3, 0x0012,
    0xFFB1, 0xFFFC, 0xFFEE, 0x002E, 0xFFAE, 0x000E, 0x004A, 0x0050,
    0x003A, 0x0011, 0xFFC5, 0x0014, 0xFFF4, 0xFFE8, 0x005B, 0x0014,
    0x0034, 0xFF8B, 0xFF57, 0xFFEA, 0x0028, 0x00A9, 0xFFAC, 0x001F,
    0xFFF7, 0xD367, 0x0000, 0xFF9E, 0xFF97, 0x000B, 0xFF79, 0x003E,
    0xFFED, 0xFFB5, 0xFFD6, 0x0098, 0x0040, 0x0013, 0x00A0, 0xFF62,
    0xFFDA, 0xFF9D, 0x0012, 0x0060, 0x0050, 0x006B, 0x0003, 0x0076,
    0xFFE4, 0xFFC9, 0x0079, 0x000A, 0x0035, 0xFFDA, 0x000F, 0xFF92,
    0x00B7, 0x0011, 0x0002, 0x0010, 0xFFE7, 0xFFA1, 0xFFB3, 0xFFE0,
    0x000B, 0xFFBE, 0x005B, 0x005F, 0xFFEF, 0xFFA4, 0xFFBC, 0x005D,
    0xFF81, 0xFF8B, 0x0089, 0x006E, 0xFFC1, 0xFFD3, 0xFFD3, 0x000F,
    0x0009, 0x0043, 0x0052, 0xFFB7, 0x003F, 0xFFB1, 0x0015, 0xFF85,
    0x0025, 0xFFEC, 0xFFF2, 0xFFDE, 0x000E, 0xFFB4, 0x0036, 0xFFF5,
    0x0008, 0x0059, 0xFFEC, 0xFFCC, 0x006A, 0xFFA4, 0xFFF4, 0xFFC4,
    0x0001, 0x0006, 0x0003, 0xFFFA, 0xFFF6, 0xFFF0, 0x004A, 0x0020,
    0xFFD7, 0x0059, 0xFFF0, 0x001B, 0xFFEB, 0xFFB4, 0x0001, 0x003A,
    0x004B, 0xFF8E, 0xFFB3, 0xFFF8, 0x0024, 0x002C, 0x002E, 0xFFF8,
    0xFFCB, 0xFF96, 0x0053, 0xFFD8, 0xFFA2, 0xFFD9, 0x005D, 0xFF9B,
    0xFF51, 0x007B, 0x000E, 0xFF97, 0xFFFA, 0x003B, 0x001D, 0xFFC0,
    0x0095, 0x0062, 0x0019, 0x0069, 0xFF99, 0x00A9, 0x001A, 0x001B,
    0x000C, 0x003E, 0x001C, 0xFF8A, 0x006F, 0xFFFC, 0x0072, 0xFF9D,
    0xFFEC, 0x004F, 0x000E, 0xFFDB, 0x0011, 0x0018, 0xFF84, 0xFFC3,
    0xFFBB, 0xFFE7, 0xFFBD, 0x0053, 0x001A, 0xFFD1, 0xFFF5, 0xFFC4,
    0x0024, 0xFFD8, 0x0000, 0xFFEF, 0x0010, 0x0027, 0x0042, 0x0007,
    0x0009, 0x0072, 0xFFD4, 0xFFE4, 0x003C, 0xFFC1, 0xFFF6, 0x0002,
    0x008C, 0xFFF9, 0xFFED, 0x0041, 0xFFB0, 0x005F, 0xFFEA, 0x0064,
    0xFFB8, 0xFFC8, 0xFFF7, 0x001B, 0x0044, 0xFFF9, 0x0048, 0x0080,
    0x0065, 0xFFC3, 0x0028, 0xFFB8, 0x000D, 0x0033, 0x0052, 0xFF62,
    0x00BF, 0x0000, 0x0052, 0x009E, 0x000D, 0xFFCD, 0x0028, 0x0048,
    0x0065, 0x003D, 0x0048, 0xFF80, 0x0044, 0x0007, 0xFFF7, 0xFFE5,
    0xFFB8, 0x0038, 0xFFEA, 0xFF9C, 0xFFB0, 0xFFA1, 0xFFED, 0xFFBF,
    0x008C, 0x0007, 0xFFF6, 0xFFFE, 0x003C, 0x003F, 0xFFD4, 0x001C,
    0x0009, 0xFF8E, 0x0042, 0xFFF9, 0x0010, 0xFFD9, 0x0000, 0x0011,
    0x0024, 0x0028, 0xFFF5, 0x003C, 0x001A, 0x002F, 0xFFBD, 0xFFAD,
    0xFFBB, 0x0019, 0xFF84, 0x003D, 0x0011, 0xFFE8, 0x000E, 0x0025,
    0xFFEC, 0xFFB1, 0x0072, 0x0063, 0x006F, 0x0004, 0x001C, 0x0076,
    0x000C, 0xFFC2, 0x001A, 0xFFE5, 0xFF99, 0xFF57, 0x0019, 0xFF97,
    0x0095, 0xFF9E, 0x001D, 0x0040, 0xFFFA, 0xFFC5, 0x000E, 0x0069,
    0xFF51, 0xFF85, 0x005D, 0x0065, 0xFFA2, 0x0027, 0x0053, 0x0028,
    0xFFCB, 0x006A, 0x002E, 0x0008, 0x0024, 0xFFD4, 0xFFB3, 0x0008,
    0x004B, 0x0072, 0x0001, 0xFFC6, 0xFFEB, 0x004C, 0xFFF0, 0xFFE5,
    0xFFD7, 0xFFA7, 0x004A, 0xFFE0, 0xFFF6, 0x0010, 0x0003, 0x0006,
    0x0001, 0xFFFA, 0xFFF4, 0x003C, 0x006A, 0x005C, 0xFFEC, 0x0034,
    0x0008, 0xFFA7, 0x0036, 0x000B, 0x000E, 0x004C, 0xFFF2, 0x0022,
    0x0025, 0x0014, 0x0015, 0x007B, 0x003F, 0x004F, 0x0052, 0x0049,
    0x0009, 0xFFBD, 0xFFD3, 0xFFF1, 0xFFC1, 0x002D, 0x0089, 0xFF92,
    0xFF81, 0x0075, 0xFFBC, 0xFFA3, 0xFFEF, 0x005C, 0x005B, 0xFFA1,
    0x000B, 0x0042, 0xFFB3, 0x0020, 0xFFE7, 0x005F, 0x0002, 0xFFF0,
    0x00B7, 0xFFEF, 0x000F, 0x006E, 0x0035, 0x0026, 0x0079, 0xFFF6,
    0xFFE4, 0x0037, 0x0003, 0xFF8A, 0x0050, 0xFF95, 0x0012, 0xFFA0,
    0xFFDA, 0x0063, 0x00A0, 0x009E, 0x0040, 0xFFED, 0xFFD6, 0xFF68,
    0xFFED, 0x004B, 0xFF79, 0xFFC2, 0xFF97, 0xFFF5, 0x0000, 0x0062,
    0xFFF7, 0x2C99, 0xFFAC, 0xFFE1, 0x0028, 0xFF57, 0xFF57, 0x0016,
    0x0034, 0x0075, 0x005B, 0xFFEC, 0xFFF4, 0x0018, 0xFFC5, 0xFFEC,
    0x003A, 0xFFEF, 0x004A, 0xFFB0, 0xFFAE, 0xFFF2, 0xFFEE, 0xFFD2,
    0xFFB1, 0x0004, 0xFFB3, 0xFFEE, 0x000F, 0x0049, 0xFFDE, 0xFFF7,
    0xFFAC, 0x0011, 0x004C, 0x001D, 0xFFA9, 0x0050, 0x003B, 0xFFCE,
    0xFFEF, 0x002D, 0x0013, 0xFF9C, 0xFF8B, 0x0024, 0xFFEF, 0x0037,
    0xFFF9, 0xFF9F, 0x0028, 0xFFAD, 0xFFAD, 0xFFE2, 0x0019, 0x0057,
    0xFFED, 0xFFD9, 0x0023, 0x0006, 0xFFFA, 0xFF76, 0x001B, 0xFFF1
    };

static const q15_t ref_cfft_noisy_256[512] = {
    0xFF9B, 0x0000, 0x001B, 0x000F, 0xFFFA, 0x008A, 0x0023, 0xFFFA,
    0xFFED, 0x0027, 0x0019, 0xFFA9, 0xFFAD, 0x001E, 0x0028, 0x0053,
    0xFFF9, 0x0061, 0xFFEF, 0xFFC9, 0xFF8B, 0xFFDC, 0x0013, 0x0064,
    0xFFEF, 0xFFD3, 0x003B, 0x0032, 0xFFA9, 0xFFB0, 0x004C, 0xFFE3,
    0xFFAC, 0xFFEF, 0xFFDE, 0x0009, 0x000F, 0xFFB7, 0xFFB3, 0x0012,
    0xFFB1, 0xFFFC, 0xFFEE, 0x002E, 0xFFAE, 0x000E, 0x004A, 0x0050,
    0x003A, 0x0011, 0xFFC5, 0x0014, 0xFFF4, 0xFFE8, 0x005B, 0x0014,
    0x0034, 0xFF8B, 0xFF57, 0xFFEA, 0x0028, 0x00A9, 0xFFAC, 0x001F,
    0xFFF7, 0xD367, 0x0000, 0xFF9E, 0xFF97, 0x000B, 0xFF79, 0x003E,
    0xFFED, 0xFFB5, 0xFFD6, 0x0098, 0x0040, 0x0013, 0x00A0, 0xFF62,
    0xFFDA, 0xFF9D, 0x0012, 0x0060, 0x0050, 0x006B, 0x0003, 0x0076,
    0xFFE4, 0xFFC9, 0x0079, 0x000A, 0x0035, 0xFFDA, 0x000F, 0xFF92,
    0x00B7, 0x0011, 0x0002, 0x0010, 0xFFE7, 0xFFA1, 0xFFB3, 0xFFE0,
    0x000B, 0xFFBE, 0x005B, 0x005F, 0xFFEF, 0xFFA4, 0xFFBC, 0x005D,
    0xFF81, 0xFF8B, 0x0089, 0x006E, 0xFFC1, 0xFFD3, 0xFFD3, 0x000F,
    0x0009, 0x0043, 0x0052, 0xFFB7, 0x003F, 0xFFB1, 0x0015, 0xFF85,
    0x0025, 0xFFEC, 0xFFF2, 0xFFDE, 0x000E, 0xFFB4, 0x0036, 0xFFF5,
    0x0008, 0x0059, 0xFFEC, 0xFFCC, 0x006A, 0xFFA4, 0xFFF4, 0xFFC4,
    0x0001, 0x0006, 0x0003, 0xFFFA, 0xFFF6, 0xFFF0, 0x004A, 0x0020,
    0xFFD7, 0x0059, 0xFFF0, 0x001B, 0xFFEB, 0xFFB4, 0x0001, 0x003A,
    0x004B, 0xFF8E, 0xFFB3, 0xFFF8, 0x0024, 0x002C, 0x002E, 0xFFF8,
    0xFFCB, 0xFF96, 0x0053, 0xFFD8, 0xFFA2, 0xFFD9, 0x005D, 0xFF9B,
    0xFF51, 0x007B, 0x000E, 0xFF97, 0xFFFA, 0x003B, 0x001D, 0xFFC0,
    0x0095, 0x0062, 0x0019, 0x0069, 0xFF99, 0x00A9, 0x001A, 0x001B,
    0x000C, 0x003E, 0x001C, 0xFF8A, 0x006F, 0xFFFC, 0x0072, 0xFF9D,
    0xFFEC, 0x004F, 0x000E, 0xFFDB, 0x0011, 0x0018, 0xFF84, 0xFFC3,
    0xFFBB, 0xFFE7, 0xFFBD, 0x0053, 0x001A, 0xFFD1, 0xFFF5, 0xFFC4,
    0x0024, 0xFFD8, 0x0000, 0xFFEF, 0x0010, 0x0027, 0x0042, 0x0007,
    0x0009, 0x0072, 0xFFD4, 0xFFE4, 0x003C, 0xFFC1, 0xFFF6, 0x0002,
    0x008C, 0xFFF9, 0xFFED, 0x0041, 0xFFB0, 0x005F, 0xFFEA, 0x0064,
    0xFFB8, 0xFFC8, 0xFFF7, 0x001B, 0x0044, 0xFFF9, 0x0048, 0x0080,
    0x0065, 0xFFC3, 0x0028, 0xFFB8, 0x000D, 0x0033, 0x0052, 0xFF62,
    0x00BF, 0x0000, 0x0052, 0x009E, 0x000D, 0xFFCD, 0x0028, 0x0048,
    0x0065, 0x003D, 0x0048, 0xFF80, 0x0044, 0x0007, 0xFFF7, 0xFFE5,
    0xFFB8, 0x0038, 0xFFEA, 0xFF9C, 0xFFB0, 0xFFA1, 0xFFED, 0xFFBF,
    0x008C, 0x0007, 0xFFF6, 0xFFFE, 0x003C, 0x003F, 0xFFD4, 0x001C,
    0x0009, 0xFF8E, 0x0042, 0xFFF9, 0x0010, 0xFFD9, 0x0000, 0x0011,
    0x0024, 0x0028, 0xFFF5, 0x003C, 0x001A, 0x002F, 0xFFBD, 0xFFAD,
    0xFFBB, 0x0019, 0xFF84, 0x003D, 0x0011, 0xFFE8, 0x000E, 0x0025,
    0xFFEC, 0xFFB1, 0x0072, 0x0063, 0x006F, 0x0004, 0x001C, 0x0076,
    0x000C, 0xFFC2, 0x001A, 0xFFE5, 0xFF99, 0xFF57, 0x0019, 0xFF97,
    0x0095, 0xFF9E, 0x001D, 0x0040, 0xFFFA, 0xFFC5, 0x000E, 0x0069,
    0xFF51, 0xFF85, 0x005D, 0x0065, 0xFFA2, 0x0027, 0x0053, 0x0028,
    0xFFCB, 0x006A, 0x002E, 0x0008, 0x0024, 0xFFD4, 0xFFB3, 0x0008,
    0x004B, 0x0072, 0x0001, 0xFFC6, 0xFFEB, 0x004C, 0xFFF0, 0xFFE5,
    0xFFD7, 0xFFA7, 0x004A, 0xFFE0, 0xFFF6, 0x0010, 0x0003, 0x0006,
    0x0001, 0xFFFA, 0xFFF4, 0x003C, 0x006A, 0x005C, 0xFFEC, 0x0034,
    0x0008, 0xFFA7, 0x0036, 0x000B, 0x000E, 0x004C, 0xFFF2, 0x0022,
    0x0025, 0x0014, 0x0015, 0x007B, 0x003F, 0x004F, 0x0052, 0x0049,
    0x0009, 0xFFBD, 0xFFD3, 0xFFF1, 0xFFC1, 0x002D, 0x0089, 0xFF92,
    0xFF81, 0x0075, 0xFFBC, 0xFFA3, 0xFFEF, 0x005C, 0x005B, 0xFFA1,
    0x000B, 0x0042, 0xFFB3, 0x0020, 0xFFE7, 0x005F, 0x0002, 0xFFF0,
    0x00B7, 0xFFEF, 0x000F, 0x006E, 0x0035, 0x0026, 0x0079, 0xFFF6,
    0xFFE4, 0x0037, 0x0003, 0xFF8A, 0x0050, 0xFF95, 0x0012, 0xFFA0,
    0xFFDA, 0x0063, 0x00A0, 0x009E, 0x0040, 0xFFED, 0xFFD6, 0xFF68,
    0xFFED, 0x004B, 0xFF79, 0xFFC2, 0xFF97, 0xFFF5, 0x0000, 0x0062,
    0xFFF7, 0x2C99, 0xFFAC, 0xFFE1, 0x0028, 0xFF57, 0xFF57, 0x0016,
    0x0034, 0x0075, 0x005B, 0xFFEC, 0xFFF4, 0x0018, 0xFFC5, 0xFFEC,
    0x003A, 0xFFEF, 0x004A, 0xFFB0, 0xFFAE, 0xFFF2, 0xFFEE, 0xFFD2,
    0xFFB1, 0x0004, 0xFFB3, 0xFFEE, 0x000F, 0x0049, 0xFFDE, 0xFFF7,
    0xFFAC, 0x0011, 0x004C, 0x001D, 0xFFA9, 0x0050, 0x003B, 0xFFCE,
    0xFFEF, 0x002D, 0x0013, 0xFF9C, 0xFF8B, 0x0024, 0xFFEF, 0x0037,
    0xFFF9, 0xFF9F, 0x0028, 0xFFAD, 0xFFAD, 0xFFE2, 0x0019, 0x0057,
    0xFFED, 0xFFD9, 0x0023, 0x0006, 0xFFFA, 0xFF76, 0x001B, 0xFFF1
    };

static const q15_t in_cfft_noisy_512[1024] = {
    0xFA7C, 0x0000, 0x3E27, 0x0000, 0x5BDA, 0x0000, 0x3BD9, 0x0000,
    0xFB4E, 0x0000, 0xB349, 0x0000, 0xA469, 0x0000, 0xBCE5, 0x0000,
    0x0179, 0x0000, 0x3E6C, 0x0000, 0x59C5, 0x0000, 0x4110, 0x0000,
    0x00A4, 0x0000, 0xC3AB, 0x0000, 0xAFF3, 0x0000, 0xB4F5, 0x0000,
    0x0980, 0x0000, 0x3497, 0x0000, 0x5C8F, 0x0000, 0x48EE, 0x0000,
    0xFC7A, 0x0000, 0xCB15, 0x0000, 0xAE9C, 0x0000, 0xB5F6, 0x0000,
    0xFEBA, 0x0000, 0x4344, 0x0000, 0x53D8, 0x0000, 0x4B92, 0x0000,
    0x0483, 0x0000, 0xC232, 0x0000, 0xA6B9, 0x0000, 0xBC50, 0x0000,
    0x00CF, 0x0000, 0x36BB, 0x0000, 0x5398, 0x0000, 0x4868, 0x0000,
    0xFAA0, 0x0000, 0xC153, 0x0000, 0xB3F0, 0x0000, 0xB4F4, 0x0000,
    0xF9CA, 0x0000, 0x3DC8, 0x0000, 0x5190, 0x0000, 0x4940, 0x0000,
    0x077A, 0x0000, 0xBE48, 0x0000, 0x98EF, 0x0000, 0xC36D, 0x0000,
    0x0610, 0x0000, 0x4797, 0x0000, 0x5CDF, 0x0000, 0x310A, 0x0000,
    0x0092, 0x0000, 0xBC8F, 0x0000, 0xAFA4, 0x0000, 0xC710, 0x0000,
    0xFA0C, 0x0000, 0x4544, 0x0000, 0x54E8, 0x0000, 0x37DA, 0x0000,
    0x0916, 0x0000, 0xC3D5, 0x0000, 0xA344, 0x0000, 0xC3B0, 0x0000,
    0xFC9F, 0x0000, 0x4385, 0x0000, 0x5633, 0x0000, 0x307D, 0x0000,
    0xF82C, 0x0000, 0xBB40, 0x0000, 0x9FAE, 0x0000, 0xC65B, 0x0000,
    0x0255, 0x0000, 0x4477, 0x0000, 0x5877, 0x0000, 0x3DD8, 0x0000,
    0x06D6, 0x0000, 0xC8F9, 0x0000, 0xACFB, 0x0000, 0xBDA6, 0x0000,
    0xFE08, 0x0000, 0x42F5, 0x0000, 0x5A18, 0x0000, 0x513B, 0x0000,
    0x0D8C, 0x0000, 0xC503, 0x0000, 0xA95C, 0x0000, 0xB472, 0x0000,
    0xFD9C, 0x0000, 0x44DB, 0x0000, 0x569E, 0x0000, 0x42E6, 0x0000,
    0xF8E5, 0x0000, 0xC71A, 0x0000, 0xA789, 0x0000, 0xB43A, 0x0000,
    0x0CDC, 0x0000, 0x3BB9, 0x0000, 0x58D8, 0x0000, 0x3B0C, 0x0000,
    0x02AC, 0x0000, 0xD097, 0x0000, 0xA05C, 0x0000, 0xBFDE, 0x0000,
    0xFC4B, 0x0000, 0x405C, 0x0000, 0x5C21, 0x0000, 0x3748, 0x0000,
    0xFF86, 0x0000, 0xC084, 0x0000, 0xAC7E, 0x0000, 0xBDC2, 0x0000,
    0x015B, 0x0000, 0x41E9, 0x0000, 0x5A85, 0x0000, 0x35D5, 0x0000,
    0xFAE2, 0x0000, 0xBE92, 0x0000, 0xB12F, 0x0000, 0xC36F, 0x0000,
    0x0626, 0x0000, 0x3F2C, 0x0000, 0x5C3A, 0x0000, 0x377A, 0x0000,
    0x0555, 0x0000, 0xC329, 0x0000, 0xA56F, 0x0000, 0xAF68, 0x0000,
    0xFA25, 0x0000, 0x3D16, 0x0000, 0x5624, 0x0000, 0x3F6A, 0x0000,
    0x063D, 0x0000, 0xC4D8, 0x0000, 0xAD02, 0x0000, 0xB91E, 0x0000,
    0x037A, 0x0000, 0x4414, 0x0000, 0x59E9, 0x0000, 0x3C19, 0x0000,
    0x040D, 0x0000, 0xBE73, 0x0000, 0xAE5B, 0x0000, 0xC420, 0x0000,
    0xEE6E, 0x0000, 0x3E63, 0x0000, 0x50AF, 0x0000, 0x4749, 0x0000,
    0x02C9, 0x0000, 0xCB38, 0x0000, 0xA5F2, 0x0000, 0xC855, 0x0000,
    0xFD72, 0x0000, 0x385E, 0x0000, 0x5BF6, 0x0000, 0x3F6A, 0x0000,
    0xFAFB, 0x0000, 0xBE10, 0x0000, 0xAEF1, 0x0000, 0xBBD7, 0x0000,
    0xF916, 0x0000, 0x4386, 0x0000, 0x5855, 0x0000, 0x3214, 0x0000,
    0x0E11, 0x0000, 0xBECB, 0x0000, 0xB50A, 0x0000, 0xC604, 0x0000,
    0x05A3, 0x0000, 0x414E, 0x0000, 0x61B1, 0x0000, 0x3E09, 0x0000,
    0xFBC9, 0x0000, 0xBD38, 0x0000, 0xA59A, 0x0000, 0xBBE5, 0x0000,
    0xF37B, 0x0000, 0x383C, 0x0000, 0x54D0, 0x0000, 0x4B94, 0x0000,
    0x0E92, 0x0000, 0xC901, 0x0000, 0x9DD0, 0x0000, 0xC63F, 0x0000,
    0xFDF9, 0x0000, 0x4300, 0x0000, 0x5AE6, 0x0000, 0x3BF3, 0x0000,
    0xFC17, 0x0000, 0xC578, 0x0000, 0xA725, 0x0000, 0xBAB1, 0x0000,
    0x0446, 0x0000, 0x3E6F, 0x0000, 0x58D3, 0x0000, 0x45FB, 0x0000,
    0x0FC1, 0x0000, 0xBDE9, 0x0000, 0xA604, 0x0000, 0xC63A, 0x0000,
    0xFF67, 0x0000, 0x4A04, 0x0000, 0x636F, 0x0000, 0x4889, 0x0000,
    0xFDD4, 0x0000, 0xC90C, 0x0000, 0xA8A2, 0x0000, 0xBC41, 0x0000,
    0x05EF, 0x0000, 0x3AAF, 0x0000, 0x55AD, 0x0000, 0x37EB, 0x0000,
    0xFF44, 0x0000, 0xC55E, 0x0000, 0xA6B3, 0x0000, 0xB9BC, 0x0000,
    0xFAB0, 0x0000, 0x3E16, 0x0000, 0x568B, 0x0000, 0x4E4A, 0x0000,
    0xF333, 0x0000, 0xBF3A, 0x0000, 0xAD9C, 0x0000, 0xD25D, 0x0000,
    0xFEAD, 0x0000, 0x3BB7, 0x0000, 0x5046, 0x0000, 0x410E, 0x0000,
    0x06A4, 0x0000, 0xC549, 0x0000, 0xAC1C, 0x0000, 0xBE3D, 0x0000,
    0x05E1, 0x0000, 0x38D4, 0x0000, 0x5C21, 0x0000, 0x4AC0, 0x0000,
    0x038B, 0x0000, 0xB4F1, 0x0000, 0xA54C, 0x0000, 0xC7A8, 0x0000,
    0x0293, 0x0000, 0x4017, 0x0000, 0x596D, 0x0000, 0x44ED, 0x0000,
    0xFCB5, 0x0000, 0xB46A, 0x0000, 0x9FF2, 0x0000, 0xB97C, 0x0000,
    0x02EA, 0x0000, 0x402F, 0x0000, 0x50EF, 0x0000, 0x457F, 0x0000,
    0x04FA, 0x0000, 0xB898, 0x0000, 0xA0E4, 0x0000, 0xB506, 0x0000,
    0x01BE, 0x0000, 0x46B3, 0x0000, 0x5698, 0x0000, 0x3F78, 0x0000,
    0x028F, 0x0000, 0xC1FD, 0x0000, 0x9996, 0x0000, 0xBB66, 0x0000,
    0xFD77, 0x0000, 0x40E3, 0x0000, 0x5C93, 0x0000, 0x3ED0, 0x0000,
    0xF93D, 0x0000, 0xB9C8, 0x0000, 0xA3DE, 0x0000, 0xCA82, 0x0000,
    0x0292, 0x0000, 0x4141, 0x0000, 0x5493, 0x0000, 0x34FD, 0x0000,
    0x07ED, 0x0000, 0xB932, 0x0000, 0xA846, 0x0000, 0xB671, 0x0000,
    0x0161, 0x0000, 0x39FC, 0x0000, 0x5D00, 0x0000, 0x4167, 0x0000,
    0x0170, 0x0000, 0xC234, 0x0000, 0xA384, 0x0000, 0xBE98, 0x0000,
    0x0293, 0x0000, 0x408E, 0x0000, 0x4BBD, 0x0000, 0x3B4A, 0x0000,
    0x001F, 0x0000, 0xB931, 0x0000, 0xA949, 0x0000, 0xC778, 0x0000,
    0x08D4, 0x0000, 0x3C57, 0x0000, 0x6454, 0x0000, 0x3CB2, 0x0000,
    0x01AB, 0x0000, 0xBFED, 0x0000, 0x9D8A, 0x0000, 0xBEAE, 0x0000,
    0x06A8, 0x0000, 0x3CEA, 0x0000, 0x5F9B, 0x0000, 0x410A, 0x0000,
    0x08EF, 0x0000, 0xC193, 0x0000, 0x96A6, 0x0000, 0xB814, 0x0000,
    0x08CD, 0x0000, 0x42ED, 0x0000, 0x5B1A, 0x0000, 0x3865, 0x0000,
    0x01F1, 0x0000, 0xC462, 0x0000, 0xA366, 0x0000, 0xC5AF, 0x0000,
    0x03E9, 0x0000, 0x4036, 0x0000, 0x50A1, 0x0000, 0x3A82, 0x0000,
    0xFE59, 0x0000, 0xB94B, 0x0000, 0x9B17, 0x0000, 0xBDA9, 0x0000,
    0x01C4, 0x0000, 0x45E6, 0x0000, 0x537C, 0x0000, 0x4268, 0x0000,
    0xFAA0, 0x0000, 0xC0BC, 0x0000, 0xA4A0, 0x0000, 0xBDAA, 0x0000,
    0xFB8C, 0x0000, 0x47F3, 0x0000, 0x53D1, 0x0000, 0x3681, 0x0000,
    0xFB18, 0x0000, 0xBBDC, 0x0000, 0xA65E, 0x0000, 0xC897, 0x0000,
    0xFFB9, 0x0000, 0x43F1, 0x0000, 0x5506, 0x0000, 0x4E1F, 0x0000,
    0xF2C6, 0x0000, 0xCE2B, 0x0000, 0xAAE7, 0x0000, 0xC487, 0x0000,
    0x119B, 0x0000, 0x3D9B, 0x0000, 0x5386, 0x0000, 0x3AFA, 0x0000,
    0x01A9, 0x0000, 0xBD97, 0x0000, 0xA178, 0x0000, 0xC4D7, 0x0000,
    0xFE48, 0x0000, 0x3FFE, 0x0000, 0x5751, 0x0000, 0x3B50, 0x0000,
    0x008E, 0x0000, 0xC4B1, 0x0000, 0xAEC7, 0x0000, 0xC33E, 0x0000,
    0xEE93, 0x0000, 0x424C, 0x0000, 0x5F2A, 0x0000, 0x3775, 0x0000,
    0x0DC5, 0x0000, 0xC844, 0x0000, 0x9C05, 0x0000, 0xC199, 0x0000,
    0x149D, 0x0000, 0x3E8A, 0x0000, 0x5B3B, 0x0000, 0x3811, 0x0000,
    0x019A, 0x0000, 0xBDE6, 0x0000, 0xAB52, 0x0000, 0xC8EE, 0x0000,
    0x0F91, 0x0000, 0x4249, 0x0000, 0x57CB, 0x0000, 0x4871, 0x0000,
    0xFCE0, 0x0000, 0xC09C, 0x0000, 0xA7E8, 0x0000, 0xBFC8, 0x0000,
    0xFFC6, 0x0000, 0x3F55, 0x0000, 0x4DB4, 0x0000, 0x4435, 0x0000,
    0xEE74, 0x0000, 0xBD7A, 0x0000, 0x9B1F, 0x0000, 0xC442, 0x0000,
    0xFBA3, 0x0000, 0x3783, 0x0000, 0x4F0C, 0x0000, 0x3DAD, 0x0000,
    0x054E, 0x0000, 0xBAFA, 0x0000, 0xAA0F, 0x0000, 0xC13F, 0x0000,
    0xF6F3, 0x0000, 0x3DAE, 0x0000, 0x6006, 0x0000, 0x3A6C, 0x0000,
    0xF3E8, 0x0000, 0xC374, 0x0000, 0xA6AD, 0x0000, 0xC722, 0x0000,
    0xFD44, 0x0000, 0x44AB, 0x0000, 0x633A, 0x0000, 0x3E64, 0x0000,
    0xFA97, 0x0000, 0xB669, 0x0000, 0xA8DC, 0x0000, 0xBC06, 0x0000,
    0xF62E, 0x0000, 0x42D1, 0x0000, 0x5D6D, 0x0000, 0x3E69, 0x0000,
    0x04C1, 0x0000, 0xCA95, 0x0000, 0xA7DC, 0x0000, 0xBE91, 0x0000,
    0x01CB, 0x0000, 0x36DF, 0x0000, 0x5481, 0x0000, 0x3900, 0x0000,
    0x0B3C, 0x0000, 0xBAB3, 0x0000, 0xAD3C, 0x0000, 0xC561, 0x0000,
    0x0085, 0x0000, 0x3D82, 0x0000, 0x5E5E, 0x0000, 0x3721, 0x0000,
    0x06AF, 0x0000, 0xC391, 0x0000, 0xA6A1, 0x0000, 0xBF80, 0x0000,
    0xFC9F, 0x0000, 0x3E5A, 0x0000, 0x5A18, 0x0000, 0x3E9A, 0x0000,
    0x0DF8, 0x0000, 0xB8D5, 0x0000, 0x9E62, 0x0000, 0xCADD, 0x0000,
    0x0209, 0x0000, 0x3465, 0x0000, 0x62CD, 0x0000, 0x3F01, 0x0000,
    0xFE8F, 0x0000, 0xC086, 0x0000, 0xA367, 0x0000, 0xBB4A, 0x0000,
    0xFAAE, 0x0000, 0x4864, 0x0000, 0x663E, 0x0000, 0x4001, 0x0000,
    0xF71B, 0x0000, 0xBE67, 0x0000, 0xA6DC, 0x0000, 0xC07A, 0x0000,
    0xF32C, 0x0000, 0x4394, 0x0000, 0x4FCA, 0x0000, 0x3A35, 0x0000,
    0x03BF, 0x0000, 0xC29E, 0x0000, 0xB25F, 0x0000, 0xBB0E, 0x0000,
    0xFA60, 0x0000, 0x36C3, 0x0000, 0x5FD8, 0x0000, 0x42FA, 0x0000,
    0xF52C, 0x0000, 0xB74B, 0x0000, 0xAC02, 0x0000, 0xC67E, 0x0000,
    0x066C, 0x0000, 0x4C87, 0x0000, 0x5DE2, 0x0000, 0x3B40, 0x0000,
    0xF823, 0x0000, 0xC1FC, 0x0000, 0xA808, 0x0000, 0xC2B0, 0x0000,
    0xFB5C, 0x0000, 0x3E3C, 0x0000, 0x5F33, 0x0000, 0x472F, 0x0000,
    0x017B, 0x0000, 0xBFE9, 0x0000, 0x9E07, 0x0000, 0xBF4F, 0x0000,
    0xFE0C, 0x0000, 0x3BC5, 0x0000, 0x5CC5, 0x0000, 0x3AE0, 0x0000,
    0xF982, 0x0000, 0xB84B, 0x0000, 0xA449, 0x0000, 0xC770, 0x0000
    };

static const q15_t in_cifft_noisy_512[1024] = {
    0xFFFA, 0x0000, 0xFFF7, 0xFFC6, 0xFFD1, 0x0019, 0x0020, 0xFFCC,
    0xFFC4, 0x0032, 0xFFFD, 0x0016, 0xFFE4, 0xFFBD, 0x004E, 0xFFDA,
    0xFFDD, 0x0028, 0xFFAF, 0xFFFC, 0xFFC8, 0x001D, 0xFFEC, 0xFFED,
    0xFFFA, 0x0009, 0xFFFA, 0x0035, 0xFF75, 0xFFA6, 0xFFF6, 0xFFE4,
    0xFFF2, 0xFFF8, 0xFFA3, 0x006C, 0x0016, 0xFFFE, 0x0020, 0xFFD5,
    0x0029, 0x0004, 0x0009, 0xFFE1, 0xFFFA, 0x000D, 0xFFD9, 0xFFF3,
    0xFFEB, 0x0012, 0x003E, 0x003A, 0x001E, 0xFFFF, 0xFFCE, 0x0000,
    0x0028, 0xFFAD, 0xFFC5, 0x0018, 0xFFEF, 0x0056, 0x003D, 0xFFB0,
    0xFFDA, 0x001C, 0xFFE8, 0x0039, 0x005F, 0x000C, 0xFFD3, 0xFFD2,
    0xFFF2, 0x0004, 0x0047, 0xFFF8, 0x000E, 0x000C, 0xFFB2, 0x001D,
    0x000D, 0xFFD3, 0xFFFB, 0x0006, 0x0074, 0xFFDC, 0x007C, 0xFFE5,
    0xFFF3, 0xFFE0, 0x0048, 0x005D, 0xFFBD, 0x0022, 0x0018, 0xFFDC,
    0x004C, 0x0055, 0x001D, 0x0028, 0xFFDD, 0x0059, 0xFFFA, 0x0000,
    0xFFC6, 0xFFB7, 0xFFC0, 0x0022, 0xFFF7, 0x0002, 0x0080, 0x001D,
    0x001D, 0xFFA1, 0x000B, 0x0006, 0xFFF6, 0xFFA1, 0xFFF4, 0xFFC1,
    0x0013, 0xFFD8, 0xFFEB, 0x000B, 0x000D, 0xFFDD, 0xFFCE, 0xFFAF,
    0xFFF1, 0xD337, 0x0002, 0x0075, 0x0002, 0xFF74, 0x001D, 0x001A,
    0x001C, 0x002D, 0x0020, 0x0009, 0x0004, 0x001C, 0xFFDC, 0x006D,
    0x0026, 0xFFD7, 0x0040, 0x004C, 0x0048, 0xFFA0, 0xFFF8, 0xFF9D,
    0x002E, 0xFFDA, 0x000D, 0x0028, 0xFFCC, 0x0020, 0x0002, 0xFFDE,
    0x0019, 0xFFF9, 0xFFF3, 0xFFFC, 0xFFE9, 0xFFE8, 0x003F, 0xFFDB,
    0xFFD4, 0xFFDD, 0x0063, 0x0020, 0x003D, 0xFFCF, 0x0090, 0xFF7F,
    0xFFA0, 0x0012, 0xFFC8, 0x0015, 0xFFDF, 0x0034, 0x0029, 0x0096,
    0x000C, 0x0051, 0xFFAA, 0x006B, 0x0050, 0x0011, 0xFFC6, 0xFFCC,
    0xFFEA, 0x0059, 0xFFBC, 0xFF8A, 0xFFF7, 0xFFC8, 0xFFDC, 0xFFDB,
    0xFFFD, 0xFFEF, 0xFFDB, 0x001C, 0xFFEB, 0x001A, 0x0012, 0x003A,
    0xFFC7, 0xFFE2, 0x0027, 0x0017, 0x0019, 0xFFF5, 0xFFA6, 0x001E,
    0x0063, 0xFFA4, 0xFFF9, 0xFFFF, 0xFFDC, 0x0029, 0xFFFB, 0x0042,
    0xFFFE, 0xFFF0, 0xFFCA, 0x0004, 0xFFDD, 0x0006, 0x0028, 0x0036,
    0xFFF8, 0x000B, 0x0011, 0x0001, 0x003A, 0xFFAE, 0xFFE3, 0x0026,
    0x006A, 0xFFC4, 0xFFE0, 0x0052, 0x0024, 0x0022, 0xFFE9, 0xFFF1,
    0xFFD0, 0x002A, 0xFFAE, 0x0024, 0x0052, 0x00AB, 0xFFD1, 0xFFD1,
    0x001E, 0xFFE1, 0xFF69, 0x0000, 0xFFC3, 0xFFEC, 0x0014, 0xFFF4,
    0xFFF3, 0x0015, 0x0005, 0xFFFC, 0xFFCC, 0xFFD9, 0x0030, 0xFFDF,
    0x0069, 0x0010, 0xFFF5, 0x0059, 0xFFA2, 0x0028, 0xFFEC, 0x0007,
    0xFFFA, 0xFFCF, 0xFFE9, 0x001D, 0x0009, 0x002D, 0x0026, 0xFFF6,
    0x0039, 0x0004, 0xFFBC, 0x0027, 0x000C, 0xFFFB, 0x002D, 0x0045,
    0xFFE3, 0x0036, 0xFFC2, 0x0029, 0xFFE0, 0xFF89, 0xFFF1, 0xFFEA,
    0x0011, 0xFFF4, 0xFFE0, 0xFF93, 0x0046, 0xFFE5, 0x001E, 0x0003,
    0xFFA9, 0x005C, 0xFFBB, 0xFFD8, 0xFFC8, 0x0035, 0x0020, 0x004D,
    0x001B, 0xFFA7, 0x0048, 0x0063, 0x002D, 0x0051, 0x000C, 0xFFFA,
    0xFFCE, 0xFFFC, 0x0068, 0x000F, 0xFFD5, 0xFFA2, 0xFFDB, 0x0004,
    0xFFD8, 0xFFEF, 0x0000, 0xFF9A, 0x0005, 0x0009, 0xFFDB, 0xFFF9,
    0x0033, 0xFFFB, 0x0029, 0xFFF3, 0xFFA3, 0x0015, 0xFFED, 0x000E,
    0x0020, 0xFFD7, 0xFFDE, 0x0054, 0xFFB2, 0xFFCC, 0x003A, 0xFFB7,
    0x002B, 0xFFF1, 0xFFE9, 0x000F, 0xFFAF, 0x001B, 0xFFD8, 0x0023,
    0xFFFA, 0x0070, 0xFFDB, 0x0073, 0xFFD7, 0x0029, 0x0086, 0x0041,
    0x0038, 0xFFB0, 0x0048, 0x0029, 0x002F, 0x000B, 0x0030, 0x0006,
    0xFFE8, 0xFFCF, 0xFFBE, 0xFFF7, 0x000A, 0xFFB5, 0xFFEE, 0xFFCE,
    0x0035, 0xFFF5, 0x0027, 0xFFF6, 0x0004, 0xFFC8, 0xFFD6, 0xFFF3,
    0xFF78, 0x0002, 0xFFCB, 0x0021, 0x0002, 0x0092, 0xFFB2, 0x000E,
    0x0028, 0xFFA3, 0xFFC1, 0xFFF8, 0xFFDA, 0x0015, 0xFFC6, 0xFFFB,
    0x001C, 0xFFF1, 0x0005, 0xFFF2, 0xFFEB, 0xFFA4, 0xFFB3, 0x0028,
    0xFFEC, 0x005C, 0xFFE0, 0x002F, 0x002C, 0x001A, 0xFFE6, 0x0045,
    0xFFD8, 0xFFE2, 0x0002, 0xFFEE, 0x001C, 0x0041, 0xFFFE, 0x0010,
    0xFFD8, 0xFF8D, 0xFFD3, 0x000D, 0xFFFF, 0x0007, 0x005A, 0x0007,
    0xFFFF, 0x0052, 0xFFF9, 0xFFE0, 0x0002, 0xFFFF, 0x005F, 0xFFE1,
    0xFFEB, 0x0018, 0x0022, 0x0012, 0x0018, 0xFFE1, 0xFF86, 0xFFFE,
    0x0005, 0xFFAE, 0xFFB0, 0x0024, 0x001A, 0xFFFF, 0xFFAB, 0xFFA8,
    0x0020, 0xFFE0, 0x0038, 0x0036, 0xFFF1, 0xFFEB, 0xFFCF, 0x000A,
    0x0017, 0x000B, 0x0047, 0xFFEC, 0xFF98, 0x0040, 0x001F, 0x006D,
    0x0005, 0xFFD8, 0xFFEE, 0x001B, 0xFFEB, 0x0048, 0xFFFB, 0x0012,
    0x0028, 0xFF97, 0x0044, 0x0033, 0xFFE2, 0x0060, 0x000A, 0x000E,
    0x001B, 0x0043, 0xFFD5, 0xFFA5, 0x0010, 0xFFEC, 0x001D, 0x0021,
    0x0022, 0x0000, 0x001D, 0xFFDF, 0x0010, 0x0014, 0xFFD5, 0x005B,
    0x001B, 0xFFBD, 0x000A, 0xFFF2, 0xFFE2, 0xFFA0, 0x0044, 0xFFCD,
    0x0028, 0x0069, 0xFFFB, 0xFFEE, 0xFFEB, 0xFFB8, 0xFFEE, 0xFFE5,
    0x0005, 0x0028, 0x001F, 0xFF93, 0xFF98, 0xFFC0, 0x0047, 0x0014,
    0x0017, 0xFFF5, 0xFFCF, 0xFFF6, 0xFFF1, 0x0015, 0x0038, 0xFFCA,
    0x0020, 0x0020, 0xFFAB, 0x0058, 0x001A, 0x0001, 0xFFB0, 0xFFDC,
    0x0005, 0x0052, 0xFF86, 0x0002, 0x0018, 0x001F, 0x0022, 0xFFEE,
    0xFFEB, 0xFFE8, 0x005F, 0x001F, 0x0002, 0x0001, 0xFFF9, 0x0020,
    0xFFFF, 0xFFAE, 0x005A, 0xFFF9, 0xFFFF, 0xFFF9, 0xFFD3, 0xFFF3,
    0xFFD8, 0x0073, 0xFFFE, 0xFFF0, 0x001C, 0xFFBF, 0x0002, 0x0012,
    0xFFD8, 0x001E, 0xFFE6, 0xFFBB, 0x002C, 0xFFE6, 0xFFE0, 0xFFD1,
    0xFFEC, 0xFFA4, 0xFFB3, 0xFFD8, 0xFFEB, 0x005C, 0x0005, 0x000E,
    0x001C, 0x000F, 0xFFC6, 0x0005, 0xFFDA, 0xFFEB, 0xFFC1, 0x0008,
    0x0028, 0x005D, 0xFFB2, 0xFFF2, 0x0002, 0xFF6E, 0xFFCB, 0xFFDF,
    0xFF78, 0xFFFE, 0xFFD6, 0x000D, 0x0004, 0x0038, 0x0027, 0x000A,
    0x0035, 0x000B, 0xFFEE, 0x0032, 0x000A, 0x004B, 0xFFBE, 0x0009,
    0xFFE8, 0x0031, 0x0030, 0xFFFA, 0x002F, 0xFFF5, 0x0048, 0xFFD7,
    0x0038, 0x0050, 0x0086, 0xFFBF, 0xFFD7, 0xFFD7, 0xFFDB, 0xFF8D,
    0xFFFA, 0xFF90, 0xFFD8, 0xFFDD, 0xFFAF, 0xFFE5, 0xFFE9, 0xFFF1,
    0x002B, 0x000F, 0x003A, 0x0049, 0xFFB2, 0x0034, 0xFFDE, 0xFFAC,
    0x0020, 0x0029, 0xFFED, 0xFFF2, 0xFFA3, 0xFFEB, 0x0029, 0x000D,
    0x0033, 0x0005, 0xFFDB, 0x0007, 0x0005, 0xFFF7, 0x0000, 0x0066,
    0xFFD8, 0x0011, 0xFFDB, 0xFFFC, 0xFFD5, 0x005E, 0x0068, 0xFFF1,
    0xFFCE, 0x0004, 0x000C, 0x0006, 0x002D, 0xFFAF, 0x0048, 0xFF9D,
    0x001B, 0x0059, 0x0020, 0xFFB3, 0xFFC8, 0xFFCB, 0xFFBB, 0x0028,
    0xFFA9, 0xFFA4, 0x001E, 0xFFFD, 0x0046, 0x001B, 0xFFE0, 0x006D,
    0x0011, 0x000C, 0xFFF1, 0x0016, 0xFFE0, 0x0077, 0xFFC2, 0xFFD7,
    0xFFE3, 0xFFCA, 0x002D, 0xFFBB, 0x000C, 0x0005, 0xFFBC, 0xFFD9,
    0x0039, 0xFFFC, 0x0026, 0x000A, 0x0009, 0xFFD3, 0xFFE9, 0xFFE3,
    0xFFFA, 0x0031, 0xFFEC, 0xFFF9, 0xFFA2, 0xFFD8, 0xFFF5, 0xFFA7,
    0x0069, 0xFFF0, 0x0030, 0x0021, 0xFFCC, 0x0027, 0x0005, 0x0004,
    0xFFF3, 0xFFEB, 0x0014, 0x000C, 0xFFC3, 0x0014, 0xFF69, 0x0000,
    0x001E, 0x001F, 0xFFD1, 0x002F, 0x0052, 0xFF55, 0xFFAE, 0xFFDC,
    0xFFD0, 0xFFD6, 0xFFE9, 0x000F, 0x0024, 0xFFDE, 0xFFE0, 0xFFAE,
    0x006A, 0x003C, 0xFFE3, 0xFFDA, 0x003A, 0x0052, 0x0011, 0xFFFF,
    0xFFF8, 0xFFF5, 0x0028, 0xFFCA, 0xFFDD, 0xFFFA, 0xFFCA, 0xFFFC,
    0xFFFE, 0x0010, 0xFFFB, 0xFFBE, 0xFFDC, 0xFFD7, 0xFFF9, 0x0001,
    0x0063, 0x005C, 0xFFA6, 0xFFE2, 0x0019, 0x000B, 0x0027, 0xFFE9,
    0xFFC7, 0x001E, 0x0012, 0xFFC6, 0xFFEB, 0xFFE6, 0xFFDB, 0xFFE4,
    0xFFFD, 0x0011, 0xFFDC, 0x0025, 0xFFF7, 0x0038, 0xFFBC, 0x0076,
    0xFFEA, 0xFFA7, 0xFFC6, 0x0034, 0x0050, 0xFFEF, 0xFFAA, 0xFF95,
    0x000C, 0xFFAF, 0x0029, 0xFF6A, 0xFFDF, 0xFFCC, 0xFFC8, 0xFFEB,
    0xFFA0, 0xFFEE, 0x0090, 0x0081, 0x003D, 0x0031, 0x0063, 0xFFE0,
    0xFFD4, 0x0023, 0x003F, 0x0025, 0xFFE9, 0x0018, 0xFFF3, 0x0004,
    0x0019, 0x0007, 0x0002, 0x0022, 0xFFCC, 0xFFE0, 0x000D, 0xFFD8,
    0x002E, 0x0026, 0xFFF8, 0x0063, 0x0048, 0x0060, 0x0040, 0xFFB4,
    0x0026, 0x0029, 0xFFDC, 0xFF93, 0x0004, 0xFFE4, 0x0020, 0xFFF7,
    0x001C, 0xFFD3, 0x001D, 0xFFE6, 0x0002, 0x008C, 0x0002, 0xFF8B,
    0xFFF1, 0x2CC9, 0xFFCE, 0x0051, 0x000D, 0x0023, 0xFFEB, 0xFFF5,
    0x0013, 0x0028, 0xFFF4, 0x003F, 0xFFF6, 0x005F, 0x000B, 0xFFFA,
    0x001D, 0x005F, 0x0080, 0xFFE3, 0xFFF7, 0xFFFE, 0xFFC0, 0xFFDE,
    0xFFC6, 0x0049, 0xFFFA, 0x0000, 0xFFDD, 0xFFA7, 0x001D, 0xFFD8,
    0x004C, 0xFFAB, 0x0018, 0x0024, 0xFFBD, 0xFFDE, 0x0048, 0xFFA3,
    0xFFF3, 0x0020, 0x007C, 0x001B, 0x0074, 0x0024, 0xFFFB, 0xFFFA,
    0x000D, 0x002D, 0xFFB2, 0xFFE3, 0x000E, 0xFFF4, 0x0047, 0x0008,
    0xFFF2, 0xFFFC, 0xFFD3, 0x002E, 0x005F, 0xFFF4, 0xFFE8, 0xFFC7,
    0xFFDA, 0xFFE4, 0x003D, 0x0050, 0xFFEF, 0xFFAA, 0xFFC5, 0xFFE8,
    0x0028, 0x0053, 0xFFCE, 0x0000, 0x001E, 0x0001, 0x003E, 0xFFC6,
    0xFFEB, 0xFFEE, 0xFFD9, 0x000D, 0xFFFA, 0xFFF3, 0x0009, 0x001F,
    0x0029, 0xFFFC, 0x0020, 0x002B, 0x0016, 0x0002, 0xFFA3, 0xFF94,
    0xFFF2, 0x0008, 0xFFF6, 0x001C, 0xFF75, 0x005A, 0xFFFA, 0xFFCB,
    0xFFFA, 0xFFF7, 0xFFEC, 0x0013, 0xFFC8, 0xFFE3, 0xFFAF, 0x0004,
    0xFFDD, 0xFFD8, 0x004E, 0x0026, 0xFFE4, 0x0043, 0xFFFD, 0xFFEA,
    0xFFC4, 0xFFCE, 0x0020, 0x0034, 0xFFD1, 0xFFE7, 0xFFF7, 0x003A
    };

static const q15_t ref_cfft_noisy_512[1024] = {
    0xFFFA, 0x0000, 0xFFF7, 0xFFC6, 0xFFD1, 0x0019, 0x0020, 0xFFCC,
    0xFFC4, 0x0032, 0xFFFD, 0x0016, 0xFFE4, 0xFFBD, 0x004E, 0xFFDA,
    0xFFDD, 0x0028, 0xFFAF, 0xFFFC, 0xFFC8, 0x001D, 0xFFEC, 0xFFED,
    0xFFFA, 0x0009, 0xFFFA, 0x0035, 0xFF75, 0xFFA6, 0xFFF6, 0xFFE4,
    0xFFF2, 0xFFF8, 0xFFA3, 0x006C, 0x0016, 0xFFFE, 0x0020, 0xFFD5,
    0x0029, 0x0004, 0x0009, 0xFFE1, 0xFFFA, 0x000D, 0xFFD9, 0xFFF3,
    0xFFEB, 0x0012, 0x003E, 0x003A, 0x001E, 0xFFFF, 0xFFCE, 0x0000,
    0x0028, 0xFFAD, 0xFFC5, 0x0018, 0xFFEF, 0x0056, 0x003D, 0xFFB0,
    0xFFDA, 0x001C, 0xFFE8, 0x0039, 0x005F, 0x000C, 0xFFD3, 0xFFD2,
    0xFFF2, 0x0004, 0x0047, 0xFFF8, 0x000E, 0x000C, 0xFFB2, 0x001D,
    0x000D, 0xFFD3, 0xFFFB, 0x0006, 0x0074, 0xFFDC, 0x007C, 0xFFE5,
    0xFFF3, 0xFFE0, 0x0048, 0x005D, 0xFFBD, 0x0022, 0x0018, 0xFFDC,
    0x004C, 0x0055, 0x001D, 0x0028, 0xFFDD, 0x0059, 0xFFFA, 0x0000,
    0xFFC6, 0xFFB7, 0xFFC0, 0x0022, 0xFFF7, 0x0002, 0x0080, 0x001D,
    0x001D, 0xFFA1, 0x000B, 0x0006, 0xFFF6, 0xFFA1, 0xFFF4, 0xFFC1,
    0x0013, 0xFFD8, 0xFFEB, 0x000B, 0x000D, 0xFFDD, 0xFFCE, 0xFFAF,
    0xFFF1, 0xD337, 0x0002, 0x0075, 0x0002, 0xFF74, 0x001D, 0x001A,
    0x001C, 0x002D, 0x0020, 0x0009, 0x0004, 0x001C, 0xFFDC, 0x006D,
    0x0026, 0xFFD7, 0x0040, 0x004C, 0x0048, 0xFFA0, 0xFFF8, 0xFF9D,
    0x002E, 0xFFDA, 0x000D, 0x0028, 0xFFCC, 0x0020, 0x0002, 0xFFDE,
    0x0019, 0xFFF9, 0xFFF3, 0xFFFC, 0xFFE9, 0xFFE8, 0x003F, 0xFFDB,
    0xFFD4, 0xFFDD, 0x0063, 0x0020, 0x003D, 0xFFCF, 0x0090, 0xFF7F,
    0xFFA0, 0x0012, 0xFFC8, 0x0015, 0xFFDF, 0x0034, 0x0029, 0x0096,
    0x000C, 0x0051, 0xFFAA, 0x006B, 0x0050, 0x0011, 0xFFC6, 0xFFCC,
    0xFFEA, 0x0059, 0xFFBC, 0xFF8A, 0xFFF7, 0xFFC8, 0xFFDC, 0xFFDB,
    0xFFFD, 0xFFEF, 0xFFDB, 0x001C, 0xFFEB, 0x001A, 0x0012, 0x003A,
    0xFFC7, 0xFFE2, 0x0027, 0x0017, 0x0019, 0xFFF5, 0xFFA6, 0x001E,
    0x0063, 0xFFA4, 0xFFF9, 0xFFFF, 0xFFDC, 0x0029, 0xFFFB, 0x0042,
    0xFFFE, 0xFFF0, 0xFFCA, 0x0004, 0xFFDD, 0x0006, 0x0028, 0x0036,
    0xFFF8, 0x000B, 0x0011, 0x0001, 0x003A, 0xFFAE, 0xFFE3, 0x0026,
    0x006A, 0xFFC4, 0xFFE0, 0x0052, 0x0024, 0x0022, 0xFFE9, 0xFFF1,
    0xFFD0, 0x002A, 0xFFAE, 0x0024, 0x0052, 0x00AB, 0xFFD1, 0xFFD1,
    0x001E, 0xFFE1, 0xFF69, 0x0000, 0xFFC3, 0xFFEC, 0x0014, 0xFFF4,
    0xFFF3, 0x0015, 0x0005, 0xFFFC, 0xFFCC, 0xFFD9, 0x0030, 0xFFDF,
    0x0069, 0x0010, 0xFFF5, 0x0059, 0xFFA2, 0x0028, 0xFFEC, 0x0007,
    0xFFFA, 0xFFCF, 0xFFE9, 0x001D, 0x0009, 0x002D, 0x0026, 0xFFF6,
    0x0039, 0x0004, 0xFFBC, 0x0027, 0x000C, 0xFFFB, 0x002D, 0x0045,
    0xFFE3, 0x0036, 0xFFC2, 0x0029, 0xFFE0, 0xFF89, 0xFFF1, 0xFFEA,
    0x0011, 0xFFF4, 0xFFE0, 0xFF93, 0x0046, 0xFFE5, 0x001E, 0x0003,
    0xFFA9, 0x005C, 0xFFBB, 0xFFD8, 0xFFC8, 0x0035, 0x0020, 0x004D,
    0x001B, 0xFFA7, 0x0048, 0x0063, 0x002D, 0x0051, 0x000C, 0xFFFA,
    0xFFCE, 0xFFFC, 0x0068, 0x000F, 0xFFD5, 0xFFA2, 0xFFDB, 0x0004,
    0xFFD8, 0xFFEF, 0x0000, 0xFF9A, 0x0005, 0x0009, 0xFFDB, 0xFFF9,
    0x0033, 0xFFFB, 0x0029, 0xFFF3, 0xFFA3, 0x0015, 0xFFED, 0x000E,
    0x0020, 0xFFD7, 0xFFDE, 0x0054, 0xFFB2, 0xFFCC, 0x003A, 0xFFB7,
    0x002B, 0xFFF1, 0xFFE9, 0x000F, 0xFFAF, 0x001B, 0xFFD8, 0x0023,
    0xFFFA, 0x0070, 0xFFDB, 0x0073, 0xFFD7, 0x0029, 0x0086, 0x0041,
    0x0038, 0xFFB0, 0x0048, 0x0029, 0x002F, 0x000B, 0x0030, 0x0006,
    0xFFE8, 0xFFCF, 0xFFBE, 0xFFF7, 0x000A, 0xFFB5, 0xFFEE, 0xFFCE,
    0x0035, 0xFFF5, 0x0027, 0xFFF6, 0x0004, 0xFFC8, 0xFFD6, 0xFFF3,
    0xFF78, 0x0002, 0xFFCB, 0x0021, 0x0002, 0x0092, 0xFFB2, 0x000E,
    0x0028, 0xFFA3, 0xFFC1, 0xFFF8, 0xFFDA, 0x0015, 0xFFC6, 0xFFFB,
    0x001C, 0xFFF1, 0x0005, 0xFFF2, 0xFFEB, 0xFFA4, 0xFFB3, 0x0028,
    0xFFEC, 0x005C, 0xFFE0, 0x002F, 0x002C, 0x001A, 0xFFE6, 0x0045,
    0xFFD8, 0xFFE2, 0x0002, 0xFFEE, 0x001C, 0x0041, 0xFFFE, 0x0010,
    0xFFD8, 0xFF8D, 0xFFD3, 0x000D, 0xFFFF, 0x0007, 0x005A, 0x0007,
    0xFFFF, 0x0052, 0xFFF9, 0xFFE0, 0x0002, 0xFFFF, 0x005F, 0xFFE1,
    0xFFEB, 0x0018, 0x0022, 0x0012, 0x0018, 0xFFE1, 0xFF86, 0xFFFE,
    0x0005, 0xFFAE, 0xFFB0, 0x0024, 0x001A, 0xFFFF, 0xFFAB, 0xFFA8,
    0x0020, 0xFFE0, 0x0038, 0x0036, 0xFFF1, 0xFFEB, 0xFFCF, 0x000A,
    0x0017, 0x000B, 0x0047, 0xFFEC, 0xFF98, 0x0040, 0x001F, 0x006D,
    0x0005, 0xFFD8, 0xFFEE, 0x001B, 0xFFEB, 0x0048, 0xFFFB, 0x0012,
    0x0028, 0xFF97, 0x0044, 0x0033, 0xFFE2, 0x0060, 0x000A, 0x000E,
    0x001B, 0x0043, 0xFFD5, 0xFFA5, 0x0010, 0xFFEC, 0x001D, 0x0021,
    0x0022, 0x0000, 0x001D, 0xFFDF, 0x0010, 0x0014, 0xFFD5, 0x005B,
    0x001B, 0xFFBD, 0x000A, 0xFFF2, 0xFFE2, 0xFFA0, 0x0044, 0xFFCD,
    0x0028, 0x0069, 0xFFFB, 0xFFEE, 0xFFEB, 0xFFB8, 0xFFEE, 0xFFE5,
    0x0005, 0x0028, 0x001F, 0xFF93, 0xFF98, 0xFFC0, 0x0047, 0x0014,
    0x0017, 0xFFF5, 0xFFCF, 0xFFF6, 0xFFF1, 0x0015, 0x0038, 0xFFCA,
    0x0020, 0x0020, 0xFFAB, 0x0058, 0x001A, 0x0001, 0xFFB0, 0xFFDC,
    0x0005, 0x0052, 0xFF86, 0x0002, 0x0018, 0x001F, 0x0022, 0xFFEE,
    0xFFEB, 0xFFE8, 0x005F, 0x001F, 0x0002, 0x0001, 0xFFF9, 0x0020,
    0xFFFF, 0xFFAE, 0x005A, 0xFFF9, 0xFFFF, 0xFFF9, 0xFFD3, 0xFFF3,
    0xFFD8, 0x0073, 0xFFFE, 0xFFF0, 0x001C, 0xFFBF, 0x0002, 0x0012,
    0xFFD8, 0x001E, 0xFFE6, 0xFFBB, 0x002C, 0xFFE6, 0xFFE0, 0xFFD1,
    0xFFEC, 0xFFA4, 0xFFB3, 0xFFD8, 0xFFEB, 0x005C, 0x0005, 0x000E,
    0x001C, 0x000F, 0xFFC6, 0x0005, 0xFFDA, 0xFFEB, 0xFFC1, 0x0008,
    0x0028, 0x005D, 0xFFB2, 0xFFF2, 0x0002, 0xFF6E, 0xFFCB, 0xFFDF,
    0xFF78, 0xFFFE, 0xFFD6, 0x000D, 0x0004, 0x0038, 0x0027, 0x000A,
    0x0035, 0x000B, 0xFFEE, 0x0032, 0x000A, 0x004B, 0xFFBE, 0x0009,
    0xFFE8, 0x0031, 0x0030, 0xFFFA, 0x002F, 0xFFF5, 0x0048, 0xFFD7,
    0x0038, 0x0050, 0x0086, 0xFFBF, 0xFFD7, 0xFFD7, 0xFFDB, 0xFF8D,
    0xFFFA, 0xFF90, 0xFFD8, 0xFFDD, 0xFFAF, 0xFFE5, 0xFFE9, 0xFFF1,
    0x002B, 0x000F, 0x003A, 0x0049, 0xFFB2, 0x0034, 0xFFDE, 0xFFAC,
    0x0020, 0x0029, 0xFFED, 0xFFF2, 0xFFA3, 0xFFEB, 0x0029, 0x000D,
    0x0033, 0x0005, 0xFFDB, 0x0007, 0x0005, 0xFFF7, 0x0000, 0x0066,
    0xFFD8, 0x0011, 0xFFDB, 0xFFFC, 0xFFD5, 0x005E, 0x0068, 0xFFF1,
    0xFFCE, 0x0004, 0x000C, 0x0006, 0x002D, 0xFFAF, 0x0048, 0xFF9D,
    0x001B, 0x0059, 0x0020, 0xFFB3, 0xFFC8, 0xFFCB, 0xFFBB, 0x0028,
    0xFFA9, 0xFFA4, 0x001E, 0xFFFD, 0x0046, 0x001B, 0xFFE0, 0x006D,
    0x0011, 0x000C, 0xFFF1, 0x0016, 0xFFE0, 0x0077, 0xFFC2, 0xFFD7,
    0xFFE3, 0xFFCA, 0x002D, 0xFFBB, 0x000C, 0x0005, 0xFFBC, 0xFFD9,
    0x0039, 0xFFFC, 0x0026, 0x000A, 0x0009, 0xFFD3, 0xFFE9, 0xFFE3,
    0xFFFA, 0x0031, 0xFFEC, 0xFFF9, 0xFFA2, 0xFFD8, 0xFFF5, 0xFFA7,
    0x0069, 0xFFF0, 0x0030, 0x0021, 0xFFCC, 0x0027, 0x0005, 0x0004,
    0xFFF3, 0xFFEB, 0x0014, 0x000C, 0xFFC3, 0x0014, 0xFF69, 0x0000,
    0x001E, 0x001F, 0xFFD1, 0x002F, 0x0052, 0xFF55, 0xFFAE, 0xFFDC,
    0xFFD0, 0xFFD6, 0xFFE9, 0x000F, 0x0024, 0xFFDE, 0xFFE0, 0xFFAE,
    0x006A, 0x003C, 0xFFE3, 0xFFDA, 0x003A, 0x0052, 0x0011, 0xFFFF,
    0xFFF8, 0xFFF5, 0x0028, 0xFFCA, 0xFFDD, 0xFFFA, 0xFFCA, 0xFFFC,
    0xFFFE, 0x0010, 0xFFFB, 0xFFBE, 0xFFDC, 0xFFD7, 0xFFF9, 0x0001,
    0x0063, 0x005C, 0xFFA6, 0xFFE2, 0x0019, 0x000B, 0x0027, 0xFFE9,
    0xFFC7, 0x001E, 0x0012, 0xFFC6, 0xFFEB, 0xFFE6, 0xFFDB, 0xFFE4,
    0xFFFD, 0x0011, 0xFFDC, 0x0025, 0xFFF7, 0x0038, 0xFFBC, 0x0076,
    0xFFEA, 0xFFA7, 0xFFC6, 0x0034, 0x0050, 0xFFEF, 0xFFAA, 0xFF95,
    0x000C, 0xFFAF, 0x0029, 0xFF6A, 0xFFDF, 0xFFCC, 0xFFC8, 0xFFEB,
    0xFFA0, 0xFFEE, 0x0090, 0x0081, 0x003D, 0x0031, 0x0063, 0xFFE0,
    0xFFD4, 0x0023, 0x003F, 0x0025, 0xFFE9, 0x0018, 0xFFF3, 0x0004,
    0x0019, 0x0007, 0x0002, 0x0022, 0xFFCC, 0xFFE0, 0x000D, 0xFFD8,
    0x002E, 0x0026, 0xFFF8, 0x0063, 0x0048, 0x0060, 0x0040, 0xFFB4,
    0x0026, 0x0029, 0xFFDC, 0xFF93, 0x0004, 0xFFE4, 0x0020, 0xFFF7,
    0x001C, 0xFFD3, 0x001D, 0xFFE6, 0x0002, 0x008C, 0x0002, 0xFF8B,
    0xFFF1, 0x2CC9, 0xFFCE, 0x0051, 0x000D, 0x0023, 0xFFEB, 0xFFF5,
    0x0013, 0x0028, 0xFFF4, 0x003F, 0xFFF6, 0x005F, 0x000B, 0xFFFA,
    0x001D, 0x005F, 0x0080, 0xFFE3, 0xFFF7, 0xFFFE, 0xFFC0, 0xFFDE,
    0xFFC6, 0x0049, 0xFFFA, 0x0000, 0xFFDD, 0xFFA7, 0x001D, 0xFFD8,
    0x004C, 0xFFAB, 0x0018, 0x0024, 0xFFBD, 0xFFDE, 0x0048, 0xFFA3,
    0xFFF3, 0x0020, 0x007C, 0x001B, 0x0074, 0x0024, 0xFFFB, 0xFFFA,
    0x000D, 0x002D, 0xFFB2, 0xFFE3, 0x000E, 0xFFF4, 0x0047, 0x0008,
    0xFFF2, 0xFFFC, 0xFFD3, 0x002E, 0x005F, 0xFFF4, 0xFFE8, 0xFFC7,
    0xFFDA, 0xFFE4, 0x003D, 0x0050, 0xFFEF, 0xFFAA, 0xFFC5, 0xFFE8,
    0x0028, 0x0053, 0xFFCE, 0x0000, 0x001E, 0x0001, 0x003E, 0xFFC6,
    0xFFEB, 0xFFEE, 0xFFD9, 0x000D, 0xFFFA, 0xFFF3, 0x0009, 0x001F,
    0x0029, 0xFFFC, 0x0020, 0x002B, 0x0016, 0x0002, 0xFFA3, 0xFF94,
    0xFFF2, 0x0008, 0xFFF6, 0x001C, 0xFF75, 0x005A, 0xFFFA, 0xFFCB,
    0xFFFA, 0xFFF7, 0xFFEC, 0x0013, 0xFFC8, 0xFFE3, 0xFFAF, 0x0004,
    0xFFDD, 0xFFD8, 0x004E, 0x0026, 0xFFE4, 0x0043, 0xFFFD, 0xFFEA,
    0xFFC4, 0xFFCE, 0x0020, 0x0034, 0xFFD1, 0xFFE7, 0xFFF7, 0x003A
    };

static const q15_t in_cfft_noisy_1024[2048] = {
    0xFCA5, 0x0000, 0x4581, 0x0000, 0x6074, 0x0000, 0x406B, 0x0000,
    0x042E, 0x0000, 0xBB1A, 0x0000, 0xAEB2, 0x0000, 0xC405, 0x0000,
    0x01BD, 0x0000, 0x3EAB, 0x0000, 0x5716, 0x0000, 0x39EE, 0x0000,
    0x0476, 0x0000, 0xBFC8, 0x0000, 0xA46C, 0x0000, 0xC995, 0x0000,
    0xFD24, 0x0000, 0x43B6, 0x0000, 0x54E1, 0x0000, 0x3C77, 0x0000,
    0xFAEF, 0x0000, 0xBFFC, 0x0000, 0xAB43, 0x0000, 0xBEC6, 0x0000,
    0xF9C5, 0x0000, 0x38F4, 0x0000, 0x686C, 0x0000, 0x4104, 0x0000,
    0xFC0F, 0x0000, 0xBE5E, 0x0000, 0x9D64, 0x0000, 0xBFD4, 0x0000,
    0xFF97, 0x0000, 0x3A8B, 0x0000, 0x5F56, 0x0000, 0x3CE1, 0x0000,
    0x0516, 0x0000, 0xB9ED, 0x0000, 0xB1A0, 0x0000, 0xC551, 0x0000,
    0xF6D6, 0x0000, 0x4094, 0x0000, 0x6568, 0x0000, 0x3D34, 0x0000,
    0x08A3, 0x0000, 0xC88D, 0x0000, 0xA7F3, 0x0000, 0xBB0A, 0x0000,
    0xFAA1, 0x0000, 0x3EC0, 0x0000, 0x5DE2, 0x0000, 0x415E, 0x0000,
    0x0505, 0x0000, 0xC59E, 0x0000, 0xA890, 0x0000, 0xBD07, 0x0000,
    0xFF85, 0x0000, 0x45AD, 0x0000, 0x5DD5, 0x0000, 0x3B9D, 0x0000,
    0xFCA8, 0x0000, 0xB8F1, 0x0000, 0xAD37, 0x0000, 0xC14C, 0x0000,
    0xFB8D, 0x0000, 0x3B0C, 0x0000, 0x5ADB, 0x0000, 0x4C5C, 0x0000,
    0xFAE2, 0x0000, 0xC3A2, 0x0000, 0xA7AB, 0x0000, 0xAC36, 0x0000,
    0xF892, 0x0000, 0x3FEF, 0x0000, 0x5F89, 0x0000, 0x4D88, 0x0000,
    0xFA10, 0x0000, 0xB4BF, 0x0000, 0xA59E, 0x0000, 0xC533, 0x0000,
    0x01DC, 0x0000, 0x36A7, 0x0000, 0x581D, 0x0000, 0x3949, 0x0000,
    0xF5B8, 0x0000, 0xC18E, 0x0000, 0xA91C, 0x0000, 0xBBCC, 0x0000,
    0x00BA, 0x0000, 0x39DF, 0x0000, 0x54FF, 0x0000, 0x4610, 0x0000,
    0x0783, 0x0000, 0xC55B, 0x0000, 0xA6FE, 0x0000, 0xCE47, 0x0000,
    0x044A, 0x0000, 0x4305, 0x0000, 0x5B74, 0x0000, 0x451E, 0x0000,
    0x0969, 0x0000, 0xC948, 0x0000, 0xA973, 0x0000, 0xB90C, 0x0000,
    0x036B, 0x0000, 0x4336, 0x0000, 0x5082, 0x0000, 0x3C3C, 0x0000,
    0x010B, 0x0000, 0xC379, 0x0000, 0x9FE8, 0x0000, 0xBCA2, 0x0000,
    0x0440, 0x0000, 0x376B, 0x0000, 0x6234, 0x0000, 0x3A38, 0x0000,
    0xFAF0, 0x0000, 0xB6DD, 0x0000, 0xAA75, 0x0000, 0xBBD2, 0x0000,
    0x0214, 0x0000, 0x3A61, 0x0000, 0x4320, 0x0000, 0x3A70, 0x0000,
    0x07D7, 0x0000, 0xBC57, 0x0000, 0x9F24, 0x0000, 0xC56E, 0x0000,
    0xFEE1, 0x0000, 0x3F6C, 0x0000, 0x6827, 0x0000, 0x480E, 0x0000,
    0xF8A8, 0x0000, 0xC324, 0x0000, 0x9DDD, 0x0000, 0xCC8F, 0x0000,
    0x023C, 0x0000, 0x3E48, 0x0000, 0x57CB, 0x0000, 0x3B27, 0x0000,
    0x078A, 0x0000, 0xBC0C, 0x0000, 0xACBE, 0x0000, 0xC0D7, 0x0000,
    0xFEEC, 0x0000, 0x4430, 0x0000, 0x5199, 0x0000, 0x4140, 0x0000,
    0xF3EA, 0x0000, 0xC575, 0x0000, 0xAD73, 0x0000, 0xC709, 0x0000,
    0x016F, 0x0000, 0x3AA8, 0x0000, 0x582F, 0x0000, 0x4BA9, 0x0000,
    0x0866, 0x0000, 0xBE69, 0x0000, 0xA4E8, 0x0000, 0xB915, 0x0000,
    0x09F6, 0x0000, 0x3540, 0x0000, 0x60C2, 0x0000, 0x4B39, 0x0000,
    0xF3F1, 0x0000, 0xBE24, 0x0000, 0xA1EE, 0x0000, 0xCA13, 0x0000,
    0x0887, 0x0000, 0x402B, 0x0000, 0x659A, 0x0000, 0x454E, 0x0000,
    0xF57A, 0x0000, 0xBF85, 0x0000, 0xA925, 0x0000, 0xC011, 0x0000,
    0x0D29, 0x0000, 0x51DD, 0x0000, 0x5924, 0x0000, 0x38A5, 0x0000,
    0xF9BE, 0x0000, 0xB7CF, 0x0000, 0xA571, 0x0000, 0xBC53, 0x0000,
    0x1011, 0x0000, 0x3F3F, 0x0000, 0x5AAA, 0x0000, 0x3FC8, 0x0000,
    0x0012, 0x0000, 0xC375, 0x0000, 0xA5CC, 0x0000, 0xBFD3, 0x0000,
    0xFDE3, 0x0000, 0x44A7, 0x0000, 0x5615, 0x0000, 0x427F, 0x0000,
    0x0BB6, 0x0000, 0xBDC6, 0x0000, 0xA1A7, 0x0000, 0xC5B1, 0x0000,
    0xFEE1, 0x0000, 0x489A, 0x0000, 0x5932, 0x0000, 0x42DD, 0x0000,
    0xF515, 0x0000, 0xCA19, 0x0000, 0xA1EA, 0x0000, 0xCBE4, 0x0000,
    0x070A, 0x0000, 0x4802, 0x0000, 0x5B02, 0x0000, 0x4779, 0x0000,
    0xFF91, 0x0000, 0xBB11, 0x0000, 0xB094, 0x0000, 0xBC2A, 0x0000,
    0xEE8C, 0x0000, 0x486E, 0x0000, 0x588F, 0x0000, 0x39C0, 0x0000,
    0xF83C, 0x0000, 0xBE79, 0x0000, 0xAC37, 0x0000, 0xAE9D, 0x0000,
    0x00DF, 0x0000, 0x3BFF, 0x0000, 0x5214, 0x0000, 0x4BD2, 0x0000,
    0xFC50, 0x0000, 0xC55C, 0x0000, 0xA32E, 0x0000, 0xC939, 0x0000,
    0xF6D6, 0x0000, 0x3E19, 0x0000, 0x5F7C, 0x0000, 0x3EB1, 0x0000,
    0xFFAF, 0x0000, 0xBF38, 0x0000, 0xAB85, 0x0000, 0xC460, 0x0000,
    0xF923, 0x0000, 0x3BB1, 0x0000, 0x5141, 0x0000, 0x409D, 0x0000,
    0x0632, 0x0000, 0xB7B0, 0x0000, 0x9F6B, 0x0000, 0xC729, 0x0000,
    0x070E, 0x0000, 0x3998, 0x0000, 0x5C7C, 0x0000, 0x3612, 0x0000,
    0xF9F0, 0x0000, 0xC191, 0x0000, 0xA2CB, 0x0000, 0xC493, 0x0000,
    0xFF3A, 0x0000, 0x3E8A, 0x0000, 0x5ADA, 0x0000, 0x390A, 0x0000,
    0xFEF9, 0x0000, 0xC3A7, 0x0000, 0xA78A, 0x0000, 0xC285, 0x0000,
    0x0136, 0x0000, 0x49D6, 0x0000, 0x5735, 0x0000, 0x3DB9, 0x0000,
    0xFC57, 0x0000, 0xC2E9, 0x0000, 0xAF99, 0x0000, 0xC9F0, 0x0000,
    0x056B, 0x0000, 0x522E, 0x0000, 0x499D, 0x0000, 0x3B03, 0x0000,
    0x037E, 0x0000, 0xBD98, 0x0000, 0xA924, 0x0000, 0xBD76, 0x0000,
    0xFBE3, 0x0000, 0x3BA0, 0x0000, 0x60C2, 0x0000, 0x42B9, 0x0000,
    0x0486, 0x0000, 0xB9C0, 0x0000, 0xB5D6, 0x0000, 0xC733, 0x0000,
    0x01E9, 0x0000, 0x4428, 0x0000, 0x57A2, 0x0000, 0x3F9F, 0x0000,
    0xF6B7, 0x0000, 0xC5DF, 0x0000, 0xA47B, 0x0000, 0xBE74, 0x0000,
    0x0547, 0x0000, 0x499E, 0x0000, 0x617B, 0x0000, 0x3A26, 0x0000,
    0xFC30, 0x0000, 0xC460, 0x0000, 0x9FEE, 0x0000, 0xC563, 0x0000,
    0x0248, 0x0000, 0x45B8, 0x0000, 0x4C4B, 0x0000, 0x3BB0, 0x0000,
    0x054B, 0x0000, 0xC2C3, 0x0000, 0x9DBF, 0x0000, 0xBC7D, 0x0000,
    0x0181, 0x0000, 0x405F, 0x0000, 0x5555, 0x0000, 0x4CAE, 0x0000,
    0x0460, 0x0000, 0xBEF9, 0x0000, 0xA521, 0x0000, 0xBFB1, 0x0000,
    0x06EA, 0x0000, 0x4557, 0x0000, 0x6334, 0x0000, 0x3F07, 0x0000,
    0x0D08, 0x0000, 0xBAAD, 0x0000, 0xA8B1, 0x0000, 0xB685, 0x0000,
    0xF8D7, 0x0000, 0x32A5, 0x0000, 0x5B82, 0x0000, 0x3B8F, 0x0000,
    0xFD4C, 0x0000, 0xC93C, 0x0000, 0xB180, 0x0000, 0xCD46, 0x0000,
    0xF53A, 0x0000, 0x3D82, 0x0000, 0x576C, 0x0000, 0x3CE8, 0x0000,
    0xF900, 0x0000, 0xB8C0, 0x0000, 0xAC25, 0x0000, 0xBCFB, 0x0000,
    0x05EF, 0x0000, 0x46F0, 0x0000, 0x5C07, 0x0000, 0x3BE8, 0x0000,
    0x072D, 0x0000, 0xC012, 0x0000, 0xA959, 0x0000, 0xB95B, 0x0000,
    0xFABA, 0x0000, 0x4164, 0x0000, 0x4AA6, 0x0000, 0x4434, 0x0000,
    0xFF58, 0x0000, 0xC5E9, 0x0000, 0xB09B, 0x0000, 0xC5D4, 0x0000,
    0x0741, 0x0000, 0x3BD1, 0x0000, 0x54C1, 0x0000, 0x35F6, 0x0000,
    0x011D, 0x0000, 0xBA91, 0x0000, 0xB0D4, 0x0000, 0xCAA0, 0x0000,
    0xFD65, 0x0000, 0x4913, 0x0000, 0x5515, 0x0000, 0x3D6E, 0x0000,
    0xFFB1, 0x0000, 0xC078, 0x0000, 0xA8F4, 0x0000, 0xC336, 0x0000,
    0xF62E, 0x0000, 0x4460, 0x0000, 0x5A85, 0x0000, 0x49C7, 0x0000,
    0x00DE, 0x0000, 0xB980, 0x0000, 0xA719, 0x0000, 0xBDB2, 0x0000,
    0xF5C0, 0x0000, 0x48DA, 0x0000, 0x4DDE, 0x0000, 0x4853, 0x0000,
    0x0925, 0x0000, 0xC3E1, 0x0000, 0xA509, 0x0000, 0xC3C6, 0x0000,
    0xFADC, 0x0000, 0x388D, 0x0000, 0x5BF2, 0x0000, 0x4859, 0x0000,
    0xFC61, 0x0000, 0xBA2C, 0x0000, 0xA567, 0x0000, 0xC64F, 0x0000,
    0xF5AF, 0x0000, 0x43E9, 0x0000, 0x59D9, 0x0000, 0x3AD3, 0x0000,
    0xFA46, 0x0000, 0xB0B9, 0x0000, 0xA3CC, 0x0000, 0xC6F9, 0x0000,
    0x014A, 0x0000, 0x32D9, 0x0000, 0x5E83, 0x0000, 0x40FE, 0x0000,
    0x0BCE, 0x0000, 0xB815, 0x0000, 0xA453, 0x0000, 0xC2F1, 0x0000,
    0x05A4, 0x0000, 0x3C47, 0x0000, 0x5696, 0x0000, 0x4444, 0x0000,
    0xFB3D, 0x0000, 0xC5DD, 0x0000, 0xA596, 0x0000, 0xBBDA, 0x0000,
    0xFFD9, 0x0000, 0x47D0, 0x0000, 0x5180, 0x0000, 0x3642, 0x0000,
    0xFC1F, 0x0000, 0xC7EF, 0x0000, 0x9B9D, 0x0000, 0xC368, 0x0000,
    0xFA42, 0x0000, 0x48F5, 0x0000, 0x5CF9, 0x0000, 0x42F8, 0x0000,
    0xF842, 0x0000, 0xC664, 0x0000, 0xA16B, 0x0000, 0xBEF9, 0x0000,
    0x0171, 0x0000, 0x4DFA, 0x0000, 0x57C4, 0x0000, 0x395F, 0x0000,
    0x0156, 0x0000, 0xC3F7, 0x0000, 0xB1E4, 0x0000, 0xCC0A, 0x0000,
    0xFE5E, 0x0000, 0x4322, 0x0000, 0x5DBF, 0x0000, 0x36CF, 0x0000,
    0x03A5, 0x0000, 0xB50B, 0x0000, 0xA722, 0x0000, 0xC0A9, 0x0000,
    0xFF61, 0x0000, 0x3DCF, 0x0000, 0x51D7, 0x0000, 0x3D09, 0x0000,
    0xFD55, 0x0000, 0xBA55, 0x0000, 0xA46A, 0x0000, 0xC1C4, 0x0000,
    0x05E3, 0x0000, 0x4A89, 0x0000, 0x5F8F, 0x0000, 0x401A, 0x0000,
    0xFAC3, 0x0000, 0xC0F1, 0x0000, 0xA238, 0x0000, 0xB130, 0x0000,
    0xF94A, 0x0000, 0x432E, 0x0000, 0x4CD3, 0x0000, 0x39AE, 0x0000,
    0xFEF4, 0x0000, 0xC234, 0x0000, 0xA014, 0x0000, 0xBB46, 0x0000,
    0xEF8C, 0x0000, 0x3DB3, 0x0000, 0x5CA2, 0x0000, 0x3CBB, 0x0000,
    0x01D4, 0x0000, 0xC512, 0x0000, 0xA66C, 0x0000, 0xC236, 0x0000,
    0x0659, 0x0000, 0x43E2, 0x0000, 0x6060, 0x0000, 0x452F, 0x0000,
    0xF5D3, 0x0000, 0xC420, 0x0000, 0xB214, 0x0000, 0xC6F5, 0x0000,
    0x02A9, 0x0000, 0x3951, 0x0000, 0x55DC, 0x0000, 0x4706, 0x0000,
    0x0705, 0x0000, 0xBCF6, 0x0000, 0x9D15, 0x0000, 0xC48F, 0x0000,
    0xF64D, 0x0000, 0x38B3, 0x0000, 0x577A, 0x0000, 0x41A9, 0x0000,
    0xF9D0, 0x0000, 0xC3D2, 0x0000, 0x9F09, 0x0000, 0xC44F, 0x0000,
    0x0701, 0x0000, 0x3A67, 0x0000, 0x522B, 0x0000, 0x43D7, 0x0000,
    0xFE05, 0x0000, 0xC498, 0x0000, 0xA502, 0x0000, 0xC184, 0x0000,
    0x003E, 0x0000, 0x387C, 0x0000, 0x5953, 0x0000, 0x3F73, 0x0000,
    0x082D, 0x0000, 0xCA54, 0x0000, 0xAABF, 0x0000, 0xC887, 0x0000,
    0x012A, 0x0000, 0x4D52, 0x0000, 0x5CC1, 0x0000, 0x3A37, 0x0000,
    0xFC5D, 0x0000, 0xC855, 0x0000, 0xA4E6, 0x0000, 0xC023, 0x0000,
    0x0AAF, 0x0000, 0x3F5D, 0x0000, 0x5D6E, 0x0000, 0x3C81, 0x0000,
    0x03D2, 0x0000, 0xB676, 0x0000, 0xA206, 0x0000, 0xBFB7, 0x0000,
    0xF979, 0x0000, 0x4207, 0x0000, 0x52F1, 0x0000, 0x440E, 0x0000,
    0xFB1A, 0x0000, 0xBFDA, 0x0000, 0xAEDC, 0x0000, 0xBF77, 0x0000,
    0xFDF6, 0x0000, 0x37C3, 0x0000, 0x58C9, 0x0000, 0x414B, 0x0000,
    0x053C, 0x0000, 0xB84B, 0x0000, 0xA97B, 0x0000, 0xC18D, 0x0000,
    0x00BE, 0x0000, 0x3F81, 0x0000, 0x5724, 0x0000, 0x40B9, 0x0000,
    0xF1B6, 0x0000, 0xCB42, 0x0000, 0xAFE3, 0x0000, 0xBF5F, 0x0000,
    0x0438, 0x0000, 0x36B4, 0x0000, 0x58DF, 0x0000, 0x49CB, 0x0000,
    0xFAB2, 0x0000, 0xC9AF, 0x0000, 0xA8F4, 0x0000, 0xBB04, 0x0000,
    0x0578, 0x0000, 0x3BA9, 0x0000, 0x5E77, 0x0000, 0x48DB, 0x0000,
    0xFC27, 0x0000, 0xC1CA, 0x0000, 0xA503, 0x0000, 0xB975, 0x0000,
    0xFBD3, 0x0000, 0x3689, 0x0000, 0x55DD, 0x0000, 0x3A13, 0x0000,
    0x0003, 0x0000, 0xB731, 0x0000, 0xA0D4, 0x0000, 0xB8E7, 0x0000,
    0x039D, 0x0000, 0x39D1, 0x0000, 0x4683, 0x0000, 0x3E7E, 0x0000,
    0x00DB, 0x0000, 0xC122, 0x0000, 0xAE0A, 0x0000, 0xBEC5, 0x0000,
    0x07BA, 0x0000, 0x3B18, 0x0000, 0x6024, 0x0000, 0x42E0, 0x0000,
    0xFA7D, 0x0000, 0xB4F7, 0x0000, 0xAA28, 0x0000, 0xB8AA, 0x0000,
    0x0F1A, 0x0000, 0x345F, 0x0000, 0x626C, 0x0000, 0x4220, 0x0000,
    0xFA80, 0x0000, 0xC04C, 0x0000, 0xB223, 0x0000, 0xC68B, 0x0000,
    0xFB71, 0x0000, 0x3EDF, 0x0000, 0x4DAE, 0x0000, 0x38B6, 0x0000,
    0xFBD6, 0x0000, 0xBFF0, 0x0000, 0xA66D, 0x0000, 0xC46A, 0x0000,
    0x01E5, 0x0000, 0x477A, 0x0000, 0x5073, 0x0000, 0x3D4A, 0x0000,
    0x0112, 0x0000, 0xBF73, 0x0000, 0x9A56, 0x0000, 0xBF9F, 0x0000,
    0xFBE0, 0x0000, 0x387E, 0x0000, 0x5583, 0x0000, 0x3F49, 0x0000,
    0xFC0C, 0x0000, 0xCBC3, 0x0000, 0xA492, 0x0000, 0xC2FA, 0x0000,
    0xFF26, 0x0000, 0x41F4, 0x0000, 0x58B3, 0x0000, 0x41E1, 0x0000,
    0xF95B, 0x0000, 0xB0C6, 0x0000, 0xA613, 0x0000, 0xC2F0, 0x0000,
    0x0457, 0x0000, 0x3D4C, 0x0000, 0x5A28, 0x0000, 0x38C8, 0x0000,
    0xFF52, 0x0000, 0xCA4F, 0x0000, 0xA22E, 0x0000, 0xCC26, 0x0000,
    0xF9B3, 0x0000, 0x379D, 0x0000, 0x5450, 0x0000, 0x3A59, 0x0000,
    0xF5D9, 0x0000, 0xC434, 0x0000, 0xADEC, 0x0000, 0xC20B, 0x0000,
    0x04F2, 0x0000, 0x3830, 0x0000, 0x58AF, 0x0000, 0x5580, 0x0000,
    0x0A2C, 0x0000, 0xB39C, 0x0000, 0xA19E, 0x0000, 0xCAC3, 0x0000,
    0xFB89, 0x0000, 0x3FBB, 0x0000, 0x5D17, 0x0000, 0x49C3, 0x0000,
    0xFA31, 0x0000, 0xBAF3, 0x0000, 0xB8FD, 0x0000, 0xC8EA, 0x0000,
    0xFDC7, 0x0000, 0x4236, 0x0000, 0x597A, 0x0000, 0x436B, 0x0000,
    0xF974, 0x0000, 0xC7FF, 0x0000, 0xA4ED, 0x0000, 0xBFCD, 0x0000,
    0x00CB, 0x0000, 0x3904, 0x0000, 0x484F, 0x0000, 0x40C5, 0x0000,
    0xF4B4, 0x0000, 0xC2B2, 0x0000, 0x9CB1, 0x0000, 0xB828, 0x0000,
    0xF895, 0x0000, 0x3DCB, 0x0000, 0x548A, 0x0000, 0x4BA1, 0x0000,
    0x04A8, 0x0000, 0xD15A, 0x0000, 0xA293, 0x0000, 0xC2B3, 0x0000,
    0xF42F, 0x0000, 0x3B1B, 0x0000, 0x6028, 0x0000, 0x414F, 0x0000,
    0x0A30, 0x0000, 0xC5A7, 0x0000, 0xAAA0, 0x0000, 0xBF78, 0x0000,
    0xFF57, 0x0000, 0x430E, 0x0000, 0x526F, 0x0000, 0x4967, 0x0000,
    0xFFD5, 0x0000, 0xBFA4, 0x0000, 0xB00C, 0x0000, 0xBAD0, 0x0000,
    0xF416, 0x0000, 0x4599, 0x0000, 0x5547, 0x0000, 0x3DB7, 0x0000,
    0xF5DD, 0x0000, 0xC1D2, 0x0000, 0xA06F, 0x0000, 0xC3DB, 0x0000,
    0xFA9F, 0x0000, 0x2D23, 0x0000, 0x57F0, 0x0000, 0x3E25, 0x0000,
    0x03A1, 0x0000, 0xC2DE, 0x0000, 0xAC4E, 0x0000, 0xB84F, 0x0000,
    0x072F, 0x0000, 0x4364, 0x0000, 0x5FE8, 0x0000, 0x425D, 0x0000,
    0xF044, 0x0000, 0xC224, 0x0000, 0xA139, 0x0000, 0xCA73, 0x0000,
    0xFE9B, 0x0000, 0x3B28, 0x0000, 0x5E56, 0x0000, 0x3F82, 0x0000,
    0x0929, 0x0000, 0xBE1A, 0x0000, 0xA668, 0x0000, 0xBB99, 0x0000,
    0x04B2, 0x0000, 0x3D67, 0x0000, 0x4C13, 0x0000, 0x42EA, 0x0000,
    0x021E, 0x0000, 0xB57A, 0x0000, 0xB37D, 0x0000, 0xB875, 0x0000,
    0xFEA9, 0x0000, 0x42F3, 0x0000, 0x6BB3, 0x0000, 0x40BF, 0x0000,
    0x0302, 0x0000, 0xCA59, 0x0000, 0xA5AB, 0x0000, 0xCBD2, 0x0000,
    0xFF65, 0x0000, 0x398F, 0x0000, 0x541D, 0x0000, 0x41FD, 0x0000,
    0xFB46, 0x0000, 0xBE69, 0x0000, 0x9E5E, 0x0000, 0xBC7E, 0x0000,
    0xFFF8, 0x0000, 0x3B94, 0x0000, 0x5054, 0x0000, 0x492A, 0x0000,
    0xFF2B, 0x0000, 0xBD88, 0x0000, 0x9C38, 0x0000, 0xC33A, 0x0000,
    0x03A5, 0x0000, 0x41B0, 0x0000, 0x55E5, 0x0000, 0x4024, 0x0000,
    0x02EC, 0x0000, 0xC3FC, 0x0000, 0xA996, 0x0000, 0xBDBC, 0x0000,
    0x0428, 0x0000, 0x44E8, 0x0000, 0x6081, 0x0000, 0x415A, 0x0000,
    0xFE82, 0x0000, 0xC403, 0x0000, 0x9C8D, 0x0000, 0xBDBB, 0x0000,
    0x0090, 0x0000, 0x4766, 0x0000, 0x55F2, 0x0000, 0x3F62, 0x0000,
    0x098B, 0x0000, 0xC6C4, 0x0000, 0xA566, 0x0000, 0xC81A, 0x0000,
    0x02BF, 0x0000, 0x4BF8, 0x0000, 0x57C8, 0x0000, 0x3C88, 0x0000,
    0xFF30, 0x0000, 0xC8E9, 0x0000, 0xA0E5, 0x0000, 0xC069, 0x0000,
    0x008F, 0x0000, 0x40FD, 0x0000, 0x5D57, 0x0000, 0x37BD, 0x0000,
    0xFBF1, 0x0000, 0xC626, 0x0000, 0xA829, 0x0000, 0xB844, 0x0000,
    0xF72A, 0x0000, 0x4168, 0x0000, 0x5F96, 0x0000, 0x36EF, 0x0000,
    0xF94C, 0x0000, 0xB4B1, 0x0000, 0xABCB, 0x0000, 0xCDB0, 0x0000,
    0x038C, 0x0000, 0x43C3, 0x0000, 0x5A7D, 0x0000, 0x42CD, 0x0000,
    0x042F, 0x0000, 0xBFD3, 0x0000, 0xAE09, 0x0000, 0xCEC7, 0x0000,
    0x0045, 0x0000, 0x3B11, 0x0000, 0x5CDF, 0x0000, 0x3E92, 0x0000,
    0x05DF, 0x0000, 0xC34D, 0x0000, 0x9DEE, 0x0000, 0xC502, 0x0000,
    0x0671, 0x0000, 0x3FD2, 0x0000, 0x5FD5, 0x0000, 0x413F, 0x0000,
    0xFF2A, 0x0000, 0xC8BC, 0x0000, 0xA381, 0x0000, 0xC2D5, 0x0000,
    0x0717, 0x0000, 0x3B66, 0x0000, 0x5DD0, 0x0000, 0x3642, 0x0000,
    0xFE55, 0x0000, 0xC97B, 0x0000, 0x9CAB, 0x0000, 0xBAE5, 0x0000,
    0xF8F6, 0x0000, 0x42AF, 0x0000, 0x5E9A, 0x0000, 0x4825, 0x0000,
    0x0416, 0x0000, 0xC835, 0x0000, 0xA4DC, 0x0000, 0xC893, 0x0000,
    0x0146, 0x0000, 0x3534, 0x0000, 0x64B3, 0x0000, 0x366F, 0x0000,
    0xFD2C, 0x0000, 0xBE9B, 0x0000, 0xA2BB, 0x0000, 0xB9D5, 0x0000,
    0x0B68, 0x0000, 0x449A, 0x0000, 0x5FF6, 0x0000, 0x3B76, 0x0000,
    0xFF54, 0x0000, 0xC5EB, 0x0000, 0xA690, 0x0000, 0xCBD7, 0x0000,
    0x0119, 0x0000, 0x3F71, 0x0000, 0x63BD, 0x0000, 0x41D8, 0x0000,
    0x04A9, 0x0000, 0xBF50, 0x0000, 0x912C, 0x0000, 0xBE38, 0x0000,
    0xFF32, 0x0000, 0x3B7C, 0x0000, 0x531A, 0x0000, 0x476D, 0x0000,
    0x01FC, 0x0000, 0xD076, 0x0000, 0xA4E3, 0x0000, 0xC5A6, 0x0000,
    0x03B5, 0x0000, 0x3B47, 0x0000, 0x60A9, 0x0000, 0x4223, 0x0000,
    0xF0E6, 0x0000, 0xC1D1, 0x0000, 0xAE3C, 0x0000, 0xB965, 0x0000,
    0xFB85, 0x0000, 0x398F, 0x0000, 0x577E, 0x0000, 0x3031, 0x0000,
    0xEA2D, 0x0000, 0xBDF5, 0x0000, 0xA1A7, 0x0000, 0xBE47, 0x0000,
    0xFC77, 0x0000, 0x40CA, 0x0000, 0x5235, 0x0000, 0x3A1A, 0x0000,
    0xF94A, 0x0000, 0xC4B3, 0x0000, 0xA702, 0x0000, 0xBF5E, 0x0000,
    0xF926, 0x0000, 0x42A9, 0x0000, 0x5AC8, 0x0000, 0x471F, 0x0000,
    0x03F9, 0x0000, 0xC621, 0x0000, 0xA78D, 0x0000, 0xB643, 0x0000,
    0x0AD7, 0x0000, 0x4AE3, 0x0000, 0x5383, 0x0000, 0x49A3, 0x0000,
    0xFBDF, 0x0000, 0xC987, 0x0000, 0xA4D2, 0x0000, 0xCC9D, 0x0000,
    0xFECE, 0x0000, 0x3C02, 0x0000, 0x57FC, 0x0000, 0x4564, 0x0000,
    0x0035, 0x0000, 0xC4C4, 0x0000, 0xADDF, 0x0000, 0xC0E3, 0x0000,
    0x0C90, 0x0000, 0x4B2C, 0x0000, 0x5191, 0x0000, 0x4091, 0x0000,
    0xF86D, 0x0000, 0xBB7E, 0x0000, 0xA87D, 0x0000, 0xC5E0, 0x0000,
    0xF627, 0x0000, 0x38F3, 0x0000, 0x58D6, 0x0000, 0x44AF, 0x0000,
    0xFE0D, 0x0000, 0xC1ED, 0x0000, 0xAB12, 0x0000, 0xBBAF, 0x0000,
    0x0985, 0x0000, 0x4C11, 0x0000, 0x5450, 0x0000, 0x40C7, 0x0000,
    0xFBDA, 0x0000, 0xC86D, 0x0000, 0xAD27, 0x0000, 0xC68B, 0x0000,
    0x0A30, 0x0000, 0x3701, 0x0000, 0x5715, 0x0000, 0x4092, 0x0000,
    0xF338, 0x0000, 0xBAA3, 0x0000, 0xA2EB, 0x0000, 0xBF36, 0x0000,
    0x08BE, 0x0000, 0x4926, 0x0000, 0x58D3, 0x0000, 0x452E, 0x0000,
    0xF77B, 0x0000, 0xBD32, 0x0000, 0xADBF, 0x0000, 0xC658, 0x0000,
    0xF8E7, 0x0000, 0x3CCD, 0x0000, 0x5DA9, 0x0000, 0x3F91, 0x0000,
    0xFE0A, 0x0000, 0xBD5F, 0x0000, 0xA82E, 0x0000, 0xC027, 0x0000,
    0x00E2, 0x0000, 0x3A3C, 0x0000, 0x6479, 0x0000, 0x3E3D, 0x0000,
    0xFB6D, 0x0000, 0xC3BB, 0x0000, 0xAAB9, 0x0000, 0xBE41, 0x0000,
    0x0267, 0x0000, 0x3EC0, 0x0000, 0x554D, 0x0000, 0x39F9, 0x0000,
    0xF8E2, 0x0000, 0xC088, 0x0000, 0xB7A7, 0x0000, 0xBF85, 0x0000,
    0xFE05, 0x0000, 0x3D09, 0x0000, 0x561B, 0x0000, 0x452F, 0x0000,
    0x0171, 0x0000, 0xB81F, 0x0000, 0xA7A9, 0x0000, 0xC79C, 0x0000
    };

static const q15_t in_cifft_noisy_1024[2048] = {
    0x002D, 0x0000, 0x0035, 0xFFF1, 0xFFE0, 0x001B, 0xFFEB, 0x0001,
    0x0018, 0xFFF5, 0x0004, 0x0015, 0x003C, 0x0012, 0xFFF3, 0x0012,
    0xFFDF, 0xFFD2, 0xFFCD, 0x0018, 0xFFE4, 0xFFFD, 0x0015, 0xFFF1,
    0x0022, 0xFFC2, 0xFFF0, 0xFFFF, 0x0032, 0xFFF9, 0x000B, 0x000B,
    0xFFFD, 0x0029, 0xFFE7, 0x0006, 0xFFEC, 0x0052, 0x0002, 0x0014,
    0x000E, 0x0008, 0x0005, 0xFFF1, 0x002D, 0xFF98, 0x007F, 0xFFF3,
    0xFFEC, 0xFFFD, 0x001F, 0x000A, 0xFFD8, 0xFFCC, 0x0018, 0x0023,
    0xFF9F, 0x0018, 0x0031, 0x002B, 0xFFE4, 0x0028, 0x0000, 0xFFBF,
    0x0031, 0xFFA5, 0x0002, 0xFFFD, 0xFFEA, 0xFFEA, 0x003E, 0xFFEF,
    0xFFEA, 0xFFEF, 0xFFCE, 0x0029, 0xFFDF, 0xFFE8, 0x004F, 0x0035,
    0xFFF3, 0xFFF2, 0xFFE6, 0x0013, 0x0034, 0xFFD7, 0x000D, 0xFFEF,
    0x0038, 0x0049, 0xFFE5, 0x0008, 0xFFF6, 0x0010, 0xFFD2, 0xFFE3,
    0x0017, 0x0020, 0xFFC5, 0xFFE2, 0xFFE8, 0xFFCA, 0xFFFF, 0xFFE1,
    0x0018, 0x001D, 0x003D, 0x0008, 0x0041, 0x0014, 0x001B, 0xFFD4,
    0xFFCC, 0xFFE4, 0x0008, 0xFFFA, 0x000A, 0xFFD7, 0x000C, 0xFFE8,
    0x0038, 0x0024, 0xFFF0, 0x0061, 0xFFE8, 0xFFFF, 0xFFD3, 0x001C,
    0x0004, 0x0014, 0xFFE0, 0xFFC5, 0x0016, 0xFFD5, 0x0000, 0x0026,
    0xFFE7, 0x0016, 0xFFDD, 0xFFCA, 0xFFE8, 0x0025, 0x001B, 0xFFF6,
    0x0018, 0x0021, 0xFFD1, 0xFFF8, 0x0023, 0xFFCB, 0x000A, 0x0019,
    0xFFDE, 0x0007, 0x000B, 0xFFF5, 0xFFF7, 0xFFFA, 0x001A, 0xFFF1,
    0x004C, 0xFFE9, 0xFFB3, 0xFFCD, 0x003E, 0xFFF7, 0x000E, 0xFFF1,
    0xFFE7, 0xFFA0, 0x0008, 0x0030, 0x001A, 0x0031, 0xFFE6, 0xFFEC,
    0xFFF7, 0x0008, 0x000A, 0x000A, 0xFFF0, 0xFFD8, 0xFFCF, 0x000D,
    0x0045, 0x0029, 0xFFD6, 0xFFF6, 0x0003, 0x0012, 0x001C, 0xFFD0,
    0xFF96, 0xFFB0, 0x0020, 0xFFF1, 0x0012, 0xFFBB, 0x002B, 0xFFDC,
    0x0001, 0xFFFE, 0x001E, 0x0004, 0xFFB2, 0x0014, 0x0015, 0x0021,
    0xFFF0, 0xFFF2, 0xFFF7, 0xFFE6, 0xFFFB, 0xFFDC, 0x0017, 0x0026,
    0x002A, 0x0030, 0xFFF2, 0x0006, 0x001F, 0x0020, 0x0024, 0x001A,
    0xFFED, 0x0004, 0xFFF0, 0x0002, 0x000E, 0x0026, 0xFFCF, 0xFFE7,
    0x0000, 0x003D, 0x0048, 0xFFE9, 0xFFD5, 0x0009, 0xFFBF, 0x0005,
    0x0020, 0x0030, 0x0037, 0xFFFA, 0x0008, 0xFFC0, 0x003F, 0xFFDD,
    0xFFF6, 0xFFE1, 0x0005, 0xFFF6, 0xFFF9, 0xFFF2, 0x001E, 0x0005,
    0x002D, 0xD34B, 0x0007, 0xFFC9, 0x0003, 0x0021, 0xFFBC, 0x0054,
    0x0006, 0x0019, 0x0026, 0x0001, 0xFFE7, 0x0048, 0xFFF3, 0xFFED,
    0xFFF4, 0x0005, 0x0007, 0x002A, 0x0012, 0xFFFC, 0x001B, 0x003F,
    0x0018, 0xFFF4, 0xFFCB, 0xFFD6, 0xFFEF, 0xFFEB, 0x0031, 0x000B,
    0xFFF8, 0x0001, 0x0020, 0xFFE4, 0xFFF6, 0xFFF4, 0xFFD4, 0xFFEC,
    0xFFEA, 0x0017, 0xFFF5, 0xFFF0, 0xFFF8, 0x0044, 0x0016, 0x000B,
    0x0020, 0xFFDC, 0xFFFE, 0xFFF1, 0xFFE2, 0xFFBF, 0x0020, 0x0016,
    0x0023, 0x002B, 0xFFFE, 0xFFDF, 0x0029, 0x0005, 0xFFD0, 0xFFFD,
    0xFFB4, 0xFFC8, 0xFFE7, 0x0033, 0xFFD7, 0x0031, 0x0035, 0xFFC9,
    0x0027, 0xFFE4, 0x001D, 0xFFF6, 0x002B, 0xFFDF, 0xFFD1, 0xFFEC,
    0xFFF6, 0xFFD7, 0xFFDE, 0xFFE4, 0x0004, 0xFFC6, 0xFFBA, 0x0006,
    0x0018, 0x0001, 0xFFB2, 0x0014, 0xFFE2, 0xFFA3, 0xFFF0, 0xFFEE,
    0x0005, 0x0039, 0xFFEF, 0x000E, 0x0017, 0x0043, 0x0015, 0xFFE2,
    0x0006, 0x0008, 0x000F, 0xFFFB, 0x003B, 0xFFC2, 0xFFFD, 0xFFD4,
    0x0022, 0xFFF5, 0xFFFC, 0xFFAD, 0x0020, 0xFFEF, 0xFFFD, 0x0000,
    0x0010, 0x0080, 0x002D, 0x0018, 0x002C, 0x0013, 0xFFD8, 0x0005,
    0x0023, 0xFFF7, 0x0016, 0x0020, 0xFFC1, 0xFFF9, 0xFFE8, 0x0004,
    0x0018, 0xFFE8, 0x0026, 0xFFF1, 0xFFEA, 0xFFA7, 0x0026, 0xFFAF,
    0x0000, 0xFFB1, 0x0001, 0x0004, 0xFFE6, 0x004B, 0x001C, 0xFFE1,
    0x000F, 0x0024, 0xFFED, 0x0005, 0x0013, 0xFFBD, 0x0049, 0xFFEF,
    0xFFE0, 0x0018, 0xFFF1, 0xFFFE, 0xFFEF, 0x0016, 0x0004, 0x0025,
    0xFFE4, 0xFFDA, 0xFFEB, 0x0013, 0x0032, 0xFFFD, 0x0018, 0xFFF6,
    0xFFF3, 0x001E, 0xFFFA, 0xFFF9, 0x0012, 0x0017, 0xFFE9, 0x0027,
    0xFFCD, 0xFFF5, 0xFFFD, 0x0000, 0x000A, 0xFFEF, 0x0021, 0x003E,
    0xFFEE, 0x0032, 0xFFED, 0xFFEB, 0x0009, 0x001E, 0x0021, 0xFFF2,
    0xFFDE, 0x0011, 0xFFCB, 0x0031, 0xFFFB, 0xFFF0, 0xFFE9, 0x0026,
    0x0057, 0xFFEA, 0x000A, 0x0016, 0x003F, 0x0020, 0xFFDE, 0x0026,
    0x0015, 0x0009, 0xFFD2, 0xFF72, 0x0020, 0x002F, 0x0014, 0x0010,
    0xFFFE, 0x0001, 0xFFD7, 0xFFF3, 0xFFD5, 0x0006, 0x0004, 0x0025,
    0x0061, 0x0062, 0xFFC0, 0x0014, 0x001C, 0xFFEB, 0xFFFD, 0xFFD3,
    0x0015, 0x003A, 0x0024, 0xFFF6, 0xFFDF, 0xFFEB, 0x0008, 0xFFF7,
    0xFFF4, 0xFFEE, 0xFFD0, 0x0025, 0xFFA8, 0x000D, 0xFFEA, 0xFFF8,
    0xFFD4, 0x002A, 0xFFDF, 0xFFF8, 0x0018, 0x000E, 0xFFD9, 0x001B,
    0xFFE0, 0xFFDC, 0xFFD9, 0x0026, 0xFFFC, 0x0045, 0xFFE3, 0xFFF8,
    0x0014, 0x0026, 0xFFF4, 0xFFFA, 0x0010, 0xFFE3, 0x001A, 0xFFD4,
    0xFFD1, 0xFFE6, 0x0016, 0xFFF4, 0x0028, 0xFFF6, 0xFFF5, 0x0025,
    0x003D, 0x0019, 0x001E, 0x000A, 0xFFBB, 0xFFE5, 0x001F, 0xFFEA,
    0xFFF5, 0xFFFE, 0x0022, 0xFFB4, 0x0009, 0xFFFE, 0x0042, 0xFFD5,
    0xFFD6, 0xFFF3, 0xFFF3, 0x0043, 0x004F, 0x005B, 0xFFDD, 0xFFE2,
    0xFFDE, 0xFFDD, 0xFFE8, 0x0032, 0xFFD4, 0xFFF5, 0xFFFA, 0xFFFC,
    0x000C, 0x0043, 0x0009, 0xFFF6, 0x002E, 0x0027, 0xFFB3, 0xFFF7,
    0xFFE0, 0xFFE5, 0x0021, 0xFFFB, 0x000E, 0xFFFC, 0xFFDA, 0x0007,
    0x0033, 0x0002, 0x001E, 0xFFE6, 0xFFE5, 0xFFED, 0xFFED, 0x000E,
    0xFFE0, 0x0018, 0x0015, 0xFFEE, 0x0012, 0xFFEF, 0xFFD3, 0x0011,
    0xFFE4, 0xFFD0, 0xFFEF, 0x0051, 0x0008, 0x001A, 0xFFE3, 0xFFE6,
    0xFFFF, 0x0011, 0xFFBD, 0x002F, 0xFFCA, 0x0001, 0x0009, 0x0024,
    0x0001, 0xFFC0, 0x001F, 0x0012, 0x0043, 0xFFF7, 0x004A, 0xFFFB,
    0x001B, 0xFFF1, 0xFFCA, 0xFFFF, 0xFFBE, 0x0054, 0x001B, 0x0013,
    0x000C, 0x001F, 0xFFF7, 0x0030, 0xFFF5, 0x002B, 0x0016, 0x0017,
    0x0015, 0xFFD2, 0x002F, 0xFFCA, 0xFFC9, 0xFFBB, 0xFFD9, 0xFFC7,
    0x0027, 0xFFF0, 0xFFED, 0x0041, 0x0023, 0xFFD0, 0xFFEA, 0xFFE6,
    0x0016, 0x0024, 0xFFBC, 0xFFFA, 0x0004, 0x0004, 0x0021, 0x000E,
    0xFFF7, 0x0023, 0xFFC0, 0x0042, 0x0019, 0xFFEC, 0x0020, 0x0024,
    0x0015, 0x002A, 0xFFEF, 0xFFBF, 0x0036, 0x0016, 0xFFBA, 0x0006,
    0x0028, 0x0045, 0xFFE1, 0x0027, 0xFFC9, 0x0011, 0x0008, 0xFFD9,
    0x001C, 0x0038, 0xFFF8, 0xFFE0, 0xFFFF, 0xFFFF, 0xFFCA, 0x0000,
    0xFFEA, 0xFFFF, 0xFFDC, 0x000F, 0xFFF4, 0xFFD4, 0x0013, 0xFFF6,
    0xFFDE, 0xFFEE, 0xFFF6, 0xFFCD, 0xFFE3, 0xFFA7, 0x0015, 0x001C,
    0x0007, 0x0027, 0xFFE6, 0xFFCA, 0xFFDF, 0xFFEC, 0xFFD8, 0x000A,
    0x0017, 0x0009, 0x001F, 0xFFDD, 0x0002, 0xFFF5, 0x0001, 0xFFFB,
    0xFFED, 0x0004, 0xFFEF, 0xFFF4, 0x000D, 0xFFE6, 0xFFD6, 0x000D,
    0x002F, 0xFFD5, 0xFFE9, 0xFFD8, 0xFFD0, 0xFFD2, 0x000E, 0xFFD4,
    0xFFD7, 0x001E, 0x000F, 0x0031, 0xFFE9, 0x0028, 0xFF95, 0xFFD2,
    0xFFC5, 0xFFE4, 0xFFCC, 0xFF8A, 0x002F, 0x002C, 0x0047, 0xFFE1,
    0x0031, 0xFFD1, 0xFFE3, 0x0053, 0x0001, 0xFFC3, 0xFFE9, 0xFFF4,
    0x0004, 0x0006, 0x0014, 0x002F, 0xFFEE, 0x001E, 0x0011, 0x0018,
    0xFFE4, 0x0032, 0xFFDC, 0x0005, 0x0014, 0x0035, 0xFFE5, 0xFFD3,
    0x001F, 0x0026, 0x0036, 0xFFE2, 0x0009, 0xFFEA, 0xFFD3, 0xFFB0,
    0xFFD9, 0x000E, 0x0007, 0xFFF2, 0x003A, 0xFFDE, 0xFFDC, 0xFFF7,
    0xFFE3, 0xFFDE, 0xFFE8, 0x0001, 0xFFFE, 0xFFFA, 0xFFC0, 0x0013,
    0x0025, 0xFFEC, 0x001E, 0x0060, 0xFFFF, 0x0004, 0x001F, 0xFFDA,
    0x0009, 0x0031, 0xFFFA, 0xFFE7, 0xFFA7, 0x0011, 0x0011, 0x002E,
    0x0015, 0x000F, 0xFFCD, 0xFFC1, 0x0019, 0xFFD9, 0x0003, 0x0016,
    0x0004, 0x0016, 0x0010, 0x0030, 0xFFFB, 0xFFF9, 0x0029, 0x0027,
    0x001F, 0x0011, 0x0018, 0xFFFA, 0xFFF9, 0xFFCF, 0xFFE7, 0xFFE6,
    0x0018, 0x0039, 0x000E, 0x001E, 0x0035, 0xFFC8, 0xFFF9, 0xFFF5,
    0xFFF3, 0x002C, 0x0019, 0xFFFB, 0x002A, 0xFFD7, 0xFFDD, 0xFFFA,
    0xFFB0, 0xFFFC, 0xFFA1, 0xFFF3, 0x0024, 0x001C, 0x0008, 0x0053,
    0xFFF0, 0xFFB3, 0xFFF9, 0xFFC7, 0x0026, 0xFFF2, 0xFFE5, 0x0005,
    0x0017, 0xFFF1, 0xFFD8, 0x001B, 0xFFFD, 0x0030, 0x001D, 0x001D,
    0xFFA6, 0xFFE1, 0x0004, 0x001B, 0x0001, 0xFFFC, 0xFFD9, 0x001C,
    0xFFD5, 0x0024, 0x000E, 0x0000, 0xFFA9, 0x0002, 0x0030, 0xFFC4,
    0xFFF2, 0xFFFE, 0xFFF2, 0x0002, 0x000A, 0x0037, 0xFFF9, 0x0014,
    0x0001, 0x002B, 0x0010, 0x001F, 0xFFFD, 0xFFB1, 0xFFDA, 0xFFD6,
    0xFFF1, 0x0051, 0xFFFC, 0xFFC4, 0x000A, 0x0004, 0x000C, 0x001A,
    0x001A, 0xFFF9, 0xFFFC, 0xFFE5, 0x0028, 0x000C, 0xFFE0, 0x002B,
    0xFFD8, 0x0012, 0x000C, 0x0025, 0x0003, 0x0021, 0x0011, 0xFFF1,
    0x0008, 0xFFE5, 0x0034, 0x000F, 0xFFF9, 0x0047, 0xFFE7, 0x000C,
    0x0021, 0xFFE5, 0xFFC7, 0xFFD3, 0xFFEC, 0x0028, 0x0019, 0x0031,
    0x0011, 0x0001, 0x0035, 0xFFD4, 0xFFE8, 0x0046, 0x001B, 0xFFF9,
    0xFFBD, 0xFFC5, 0xFFFB, 0x000A, 0x0026, 0xFFC6, 0xFFE0, 0x000B,
    0x0018, 0xFFDF, 0xFFF8, 0x002A, 0x0009, 0x0004, 0x0023, 0xFFC6,
    0xFFD5, 0x0002, 0x0019, 0xFFB9, 0xFFD7, 0x0025, 0xFFDD, 0x0018,
    0x001F, 0xFFE1, 0x0005, 0xFFF4, 0xFFE3, 0x0014, 0xFFF1, 0xFFFB,
    0xFFFE, 0xFFCC, 0x004A, 0x001B, 0x0004, 0x0007, 0x001C, 0xFFE8,
    0x0011, 0x0061, 0x000B, 0x000A, 0x0025, 0x001F, 0x001E, 0x0013,
    0xFF8C, 0x0000, 0x001E, 0xFFED, 0x0025, 0xFFE1, 0x000B, 0xFFF6,
    0x0011, 0xFF9F, 0x001C, 0x0018, 0x0004, 0xFFF9, 0x004A, 0xFFE5,
    0xFFFE, 0x0034, 0xFFF1, 0x0005, 0xFFE3, 0xFFEC, 0x0005, 0x000C,
    0x001F, 0x001F, 0xFFDD, 0xFFE8, 0xFFD7, 0xFFDB, 0x0019, 0x0047,
    0xFFD5, 0xFFFE, 0x0023, 0x003A, 0x0009, 0xFFFC, 0xFFF8, 0xFFD6,
    0x0018, 0x0021, 0xFFE0, 0xFFF5, 0x0026, 0x003A, 0xFFFB, 0xFFF6,
    0xFFBD, 0x003B, 0x001B, 0x0007, 0xFFE8, 0xFFBA, 0x0035, 0x002C,
    0x0011, 0xFFFF, 0x0019, 0xFFCF, 0xFFEC, 0xFFD8, 0xFFC7, 0x002D,
    0x0021, 0x001B, 0xFFE7, 0xFFF4, 0xFFF9, 0xFFB9, 0x0034, 0xFFF1,
    0x0008, 0x001B, 0x0011, 0x000F, 0x0003, 0xFFDF, 0x000C, 0xFFDB,
    0xFFD8, 0xFFEE, 0xFFE0, 0xFFD5, 0x0028, 0xFFF4, 0xFFFC, 0x001B,
    0x001A, 0x0007, 0x000C, 0xFFE6, 0x000A, 0xFFFC, 0xFFFC, 0x003C,
    0xFFF1, 0xFFAF, 0xFFDA, 0x002A, 0xFFFD, 0x004F, 0x0010, 0xFFE1,
    0x0001, 0xFFD5, 0xFFF9, 0xFFEC, 0x000A, 0xFFC9, 0xFFF2, 0xFFFE,
    0xFFF2, 0x0002, 0x0030, 0x003C, 0xFFA9, 0xFFFE, 0x000E, 0x0000,
    0xFFD5, 0xFFDC, 0xFFD9, 0xFFE4, 0x0001, 0x0004, 0x0004, 0xFFE5,
    0xFFA6, 0x001F, 0x001D, 0xFFE3, 0xFFFD, 0xFFD0, 0xFFD8, 0xFFE5,
    0x0017, 0x000F, 0xFFE5, 0xFFFB, 0x0026, 0x000E, 0xFFF9, 0x0039,
    0xFFF0, 0x004D, 0x0008, 0xFFAD, 0x0024, 0xFFE4, 0xFFA1, 0x000D,
    0xFFB0, 0x0004, 0xFFDD, 0x0006, 0x002A, 0x0029, 0x0019, 0x0005,
    0xFFF3, 0xFFD4, 0xFFF9, 0x000B, 0x0035, 0x0038, 0x000E, 0xFFE2,
    0x0018, 0xFFC7, 0xFFE7, 0x001A, 0xFFF9, 0x0031, 0x0018, 0x0006,
    0x001F, 0xFFEF, 0x0029, 0xFFD9, 0xFFFB, 0x0007, 0x0010, 0xFFD0,
    0x0004, 0xFFEA, 0x0003, 0xFFEA, 0x0019, 0x0027, 0xFFCD, 0x003F,
    0x0015, 0xFFF1, 0x0011, 0xFFD2, 0xFFA7, 0xFFEF, 0xFFFA, 0x0019,
    0x0009, 0xFFCF, 0x001F, 0x0026, 0xFFFF, 0xFFFC, 0x001E, 0xFFA0,
    0x0025, 0x0014, 0xFFC0, 0xFFED, 0xFFFE, 0x0006, 0xFFE8, 0xFFFF,
    0xFFE3, 0x0022, 0xFFDC, 0x0009, 0x003A, 0x0022, 0x0007, 0x000E,
    0xFFD9, 0xFFF2, 0xFFD3, 0x0050, 0x0009, 0x0016, 0x0036, 0x001E,
    0x001F, 0xFFDA, 0xFFE5, 0x002D, 0x0014, 0xFFCB, 0xFFDC, 0xFFFB,
    0xFFE4, 0xFFCE, 0x0011, 0xFFE8, 0xFFEE, 0xFFE2, 0x0014, 0xFFD1,
    0x0004, 0xFFFA, 0xFFE9, 0x000C, 0x0001, 0x003D, 0xFFE3, 0xFFAD,
    0x0031, 0x002F, 0x0047, 0x001F, 0x002F, 0xFFD4, 0xFFCC, 0x0076,
    0xFFC5, 0x001C, 0xFF95, 0x002E, 0xFFE9, 0xFFD8, 0x000F, 0xFFCF,
    0xFFD7, 0xFFE2, 0x000E, 0x002C, 0xFFD0, 0x002E, 0xFFE9, 0x0028,
    0x002F, 0x002B, 0xFFD6, 0xFFF3, 0x000D, 0x001A, 0xFFEF, 0x000C,
    0xFFED, 0xFFFC, 0x0001, 0x0005, 0x0002, 0x000B, 0x001F, 0x0023,
    0x0017, 0xFFF7, 0xFFD8, 0xFFF6, 0xFFDF, 0x0014, 0xFFE6, 0x0036,
    0x0007, 0xFFD9, 0x0015, 0xFFE4, 0xFFE3, 0x0059, 0xFFF6, 0x0033,
    0xFFDE, 0x0012, 0x0013, 0x000A, 0xFFF4, 0x002C, 0xFFDC, 0xFFF1,
    0xFFEA, 0x0001, 0xFFCA, 0x0000, 0xFFFF, 0x0001, 0xFFF8, 0x0020,
    0x001C, 0xFFC8, 0x0008, 0x0027, 0xFFC9, 0xFFEF, 0xFFE1, 0xFFD9,
    0x0028, 0xFFBB, 0xFFBA, 0xFFFA, 0x0036, 0xFFEA, 0xFFEF, 0x0041,
    0x0015, 0xFFD6, 0x0020, 0xFFDC, 0x0019, 0x0014, 0xFFC0, 0xFFBE,
    0xFFF7, 0xFFDD, 0x0021, 0xFFF2, 0x0004, 0xFFFC, 0xFFBC, 0x0006,
    0x0016, 0xFFDC, 0xFFEA, 0x001A, 0x0023, 0x0030, 0xFFED, 0xFFBF,
    0x0027, 0x0010, 0xFFD9, 0x0039, 0xFFC9, 0x0045, 0x002F, 0x0036,
    0x0015, 0x002E, 0x0016, 0xFFE9, 0xFFF5, 0xFFD5, 0xFFF7, 0xFFD0,
    0x000C, 0xFFE1, 0x001B, 0xFFED, 0xFFBE, 0xFFAC, 0xFFCA, 0x0001,
    0x001B, 0x000F, 0x004A, 0x0005, 0x0043, 0x0009, 0x001F, 0xFFEE,
    0x0001, 0x0040, 0x0009, 0xFFDC, 0xFFCA, 0xFFFF, 0xFFBD, 0xFFD1,
    0xFFFF, 0xFFEF, 0xFFE3, 0x001A, 0x0008, 0xFFE6, 0xFFEF, 0xFFAF,
    0xFFE4, 0x0030, 0xFFD3, 0xFFEF, 0x0012, 0x0011, 0x0015, 0x0012,
    0xFFE0, 0xFFE8, 0xFFED, 0xFFF2, 0xFFE5, 0x0013, 0x001E, 0x001A,
    0x0033, 0xFFFE, 0xFFDA, 0xFFF9, 0x000E, 0x0004, 0x0021, 0x0005,
    0xFFE0, 0x001B, 0xFFB3, 0x0009, 0x002E, 0xFFD9, 0x0009, 0x000A,
    0x000C, 0xFFBD, 0xFFFA, 0x0004, 0xFFD4, 0x000B, 0xFFE8, 0xFFCE,
    0xFFDE, 0x0023, 0xFFDD, 0x001E, 0x004F, 0xFFA5, 0xFFF3, 0xFFBD,
    0xFFD6, 0x000D, 0x0042, 0x002B, 0x0009, 0x0002, 0x0022, 0x004C,
    0xFFF5, 0x0002, 0x001F, 0x0016, 0xFFBB, 0x001B, 0x001E, 0xFFF6,
    0x003D, 0xFFE7, 0xFFF5, 0xFFDB, 0x0028, 0x000A, 0x0016, 0x000C,
    0xFFD1, 0x001A, 0x001A, 0x002C, 0x0010, 0x001D, 0xFFF4, 0x0006,
    0x0014, 0xFFDA, 0xFFE3, 0x0008, 0xFFFC, 0xFFBB, 0xFFD9, 0xFFDA,
    0xFFE0, 0x0024, 0xFFD9, 0xFFE5, 0x0018, 0xFFF2, 0xFFDF, 0x0008,
    0xFFD4, 0xFFD6, 0xFFEA, 0x0008, 0xFFA8, 0xFFF3, 0xFFD0, 0xFFDB,
    0xFFF4, 0x0012, 0x0008, 0x0009, 0xFFDF, 0x0015, 0x0024, 0x000A,
    0x0015, 0xFFC6, 0xFFFD, 0x002D, 0x001C, 0x0015, 0xFFC0, 0xFFEC,
    0x0061, 0xFF9E, 0x0004, 0xFFDB, 0xFFD5, 0xFFFA, 0xFFD7, 0x000D,
    0xFFFE, 0xFFFF, 0x0014, 0xFFF0, 0x0020, 0xFFD1, 0xFFD2, 0x008E,
    0x0015, 0xFFF7, 0xFFDE, 0xFFDA, 0x003F, 0xFFE0, 0x000A, 0xFFEA,
    0x0057, 0x0016, 0xFFE9, 0xFFDA, 0xFFFB, 0x0010, 0xFFCB, 0xFFCF,
    0xFFDE, 0xFFEF, 0x0021, 0x000E, 0x0009, 0xFFE2, 0xFFED, 0x0015,
    0xFFEE, 0xFFCE, 0x0021, 0xFFC2, 0x000A, 0x0011, 0xFFFD, 0x0000,
    0xFFCD, 0x000B, 0xFFE9, 0xFFD9, 0x0012, 0xFFE9, 0xFFFA, 0x0007,
    0xFFF3, 0xFFE2, 0x0018, 0x000A, 0x0032, 0x0003, 0xFFEB, 0xFFED,
    0xFFE4, 0x0026, 0x0004, 0xFFDB, 0xFFEF, 0xFFEA, 0xFFF1, 0x0002,
    0xFFE0, 0xFFE8, 0x0049, 0x0011, 0x0013, 0x0043, 0xFFED, 0xFFFB,
    0x000F, 0xFFDC, 0x001C, 0x001F, 0xFFE6, 0xFFB5, 0x0001, 0xFFFC,
    0x0000, 0x004F, 0x0026, 0x0051, 0xFFEA, 0x0059, 0x0026, 0x000F,
    0x0018, 0x0018, 0xFFE8, 0xFFFC, 0xFFC1, 0x0007, 0x0016, 0xFFE0,
    0x0023, 0x0009, 0xFFD8, 0xFFFB, 0x002C, 0xFFED, 0x002D, 0xFFE8,
    0x0010, 0xFF80, 0xFFFD, 0x0000, 0x0020, 0x0011, 0xFFFC, 0x0053,
    0x0022, 0x000B, 0xFFFD, 0x002C, 0x003B, 0x003E, 0x000F, 0x0005,
    0x0006, 0xFFF8, 0x0015, 0x001E, 0x0017, 0xFFBD, 0xFFEF, 0xFFF2,
    0x0005, 0xFFC7, 0xFFF0, 0x0012, 0xFFE2, 0x005D, 0xFFB2, 0xFFEC,
    0x0018, 0xFFFF, 0xFFBA, 0xFFFA, 0x0004, 0x003A, 0xFFDE, 0x001C,
    0xFFF6, 0x0029, 0xFFD1, 0x0014, 0x002B, 0x0021, 0x001D, 0x000A,
    0x0027, 0x001C, 0x0035, 0x0037, 0xFFD7, 0xFFCF, 0xFFE7, 0xFFCD,
    0xFFB4, 0x0038, 0xFFD0, 0x0003, 0x0029, 0xFFFB, 0xFFFE, 0x0021,
    0x0023, 0xFFD5, 0x0020, 0xFFEA, 0xFFE2, 0x0041, 0xFFFE, 0x000F,
    0x0020, 0x0024, 0x0016, 0xFFF5, 0xFFF8, 0xFFBC, 0xFFF5, 0x0010,
    0xFFEA, 0xFFE9, 0xFFD4, 0x0014, 0xFFF6, 0x000C, 0x0020, 0x001C,
    0xFFF8, 0xFFFF, 0x0031, 0xFFF5, 0xFFEF, 0x0015, 0xFFCB, 0x002A,
    0x0018, 0x000C, 0x001B, 0xFFC1, 0x0012, 0x0004, 0x0007, 0xFFD6,
    0xFFF4, 0xFFFB, 0xFFF3, 0x0013, 0xFFE7, 0xFFB8, 0x0026, 0xFFFF,
    0x0006, 0xFFE7, 0xFFBC, 0xFFAC, 0x0003, 0xFFDF, 0x0007, 0x0037,
    0x002D, 0x2CB5, 0x001E, 0xFFFB, 0xFFF9, 0x000E, 0x0005, 0x000A,
    0xFFF6, 0x001F, 0x003F, 0x0023, 0x0008, 0x0040, 0x0037, 0x0006,
    0x0020, 0xFFD0, 0xFFBF, 0xFFFB, 0xFFD5, 0xFFF7, 0x0048, 0x0017,
    0x0000, 0xFFC3, 0xFFCF, 0x0019, 0x000E, 0xFFDA, 0xFFF0, 0xFFFE,
    0xFFED, 0xFFFC, 0x0024, 0xFFE6, 0x001F, 0xFFE0, 0xFFF2, 0xFFFA,
    0x002A, 0xFFD0, 0x0017, 0xFFDA, 0xFFFB, 0x0024, 0xFFF7, 0x001A,
    0xFFF0, 0x000E, 0x0015, 0xFFDF, 0xFFB2, 0xFFEC, 0x001E, 0xFFFC,
    0x0001, 0x0002, 0x002B, 0x0024, 0x0012, 0x0045, 0x0020, 0x000F,
    0xFF96, 0x0050, 0x001C, 0x0030, 0x0003, 0xFFEE, 0xFFD6, 0x000A,
    0x0045, 0xFFD7, 0xFFCF, 0xFFF3, 0xFFF0, 0x0028, 0x000A, 0xFFF6,
    0xFFF7, 0xFFF8, 0xFFE6, 0x0014, 0x001A, 0xFFCF, 0x0008, 0xFFD0,
    0xFFE7, 0x0060, 0x000E, 0x000F, 0x003E, 0x0009, 0xFFB3, 0x0033,
    0x004C, 0x0017, 0x001A, 0x000F, 0xFFF7, 0x0006, 0x000B, 0x000B,
    0xFFDE, 0xFFF9, 0x000A, 0xFFE7, 0x0023, 0x0035, 0xFFD1, 0x0008,
    0x0018, 0xFFDF, 0x001B, 0x000A, 0xFFE8, 0xFFDB, 0xFFDD, 0x0036,
    0xFFE7, 0xFFEA, 0x0000, 0xFFDA, 0x0016, 0x002B, 0xFFE0, 0x003B,
    0x0004, 0xFFEC, 0xFFD3, 0xFFE4, 0xFFE8, 0x0001, 0xFFF0, 0xFF9F,
    0x0038, 0xFFDC, 0x000C, 0x0018, 0x000A, 0x0029, 0x0008, 0x0006,
    0xFFCC, 0x001C, 0x001B, 0x002C, 0x0041, 0xFFEC, 0x003D, 0xFFF8,
    0x0018, 0xFFE3, 0xFFFF, 0x001F, 0xFFE8, 0x0036, 0xFFC5, 0x001E,
    0x0017, 0xFFE0, 0xFFD2, 0x001D, 0xFFF6, 0xFFF0, 0xFFE5, 0xFFF8,
    0x0038, 0xFFB7, 0x000D, 0x0011, 0x0034, 0x0029, 0xFFE6, 0xFFED,
    0xFFF3, 0x000E, 0x004F, 0xFFCB, 0xFFDF, 0x0018, 0xFFCE, 0xFFD7,
    0xFFEA, 0x0011, 0x003E, 0x0011, 0xFFEA, 0x0016, 0x0002, 0x0003,
    0x0031, 0x005B, 0x0000, 0x0041, 0xFFE4, 0xFFD8, 0x0031, 0xFFD5,
    0xFF9F, 0xFFE8, 0x0018, 0xFFDD, 0xFFD8, 0x0034, 0x001F, 0xFFF6,
    0xFFEC, 0x0003, 0x007F, 0x000D, 0x002D, 0x0068, 0x0005, 0x000F,
    0x000E, 0xFFF8, 0x0002, 0xFFEC, 0xFFEC, 0xFFAE, 0xFFE7, 0xFFFA,
    0xFFFD, 0xFFD7, 0x000B, 0xFFF5, 0x0032, 0x0007, 0xFFF0, 0x0001,
    0x0022, 0x003E, 0x0015, 0x000F, 0xFFE4, 0x0003, 0xFFCD, 0xFFE8,
    0xFFDF, 0x002E, 0xFFF3, 0xFFEE, 0x003C, 0xFFEE, 0x0004, 0xFFEB,
    0x0018, 0x000B, 0xFFEB, 0xFFFF, 0xFFE0, 0xFFE5, 0x0035, 0x000F
    };

static const q15_t ref_cfft_noisy_1024[2048] = {
    0x002D, 0x0000, 0x0035, 0xFFF1, 0xFFE0, 0x001B, 0xFFEB, 0x0001,
    0x0018, 0xFFF5, 0x0004, 0x0015, 0x003C, 0x0012, 0xFFF3, 0x0012,
    0xFFDF, 0xFFD2, 0xFFCD, 0x0018, 0xFFE4, 0xFFFD, 0x0015, 0xFFF1,
    0x0022, 0xFFC2, 0xFFF0, 0xFFFF, 0x0032, 0xFFF9, 0x000B, 0x000B,
    0xFFFD, 0x0029, 0xFFE7, 0x0006, 0xFFEC, 0x0052, 0x0002, 0x0014,
    0x000E, 0x0008, 0x0005, 0xFFF1, 0x002D, 0xFF98, 0x007F, 0xFFF3,
    0xFFEC, 0xFFFD, 0x001F, 0x000A, 0xFFD8, 0xFFCC, 0x0018, 0x0023,
    0xFF9F, 0x0018, 0x0031, 0x002B, 0xFFE4, 0x0028, 0x0000, 0xFFBF,
    0x0031, 0xFFA5, 0x0002, 0xFFFD, 0xFFEA, 0xFFEA, 0x003E, 0xFFEF,
    0xFFEA, 0xFFEF, 0xFFCE, 0x0029, 0xFFDF, 0xFFE8, 0x004F, 0x0035,
    0xFFF3, 0xFFF2, 0xFFE6, 0x0013, 0x0034, 0xFFD7, 0x000D, 0xFFEF,
    0x0038, 0x0049, 0xFFE5, 0x0008, 0xFFF6, 0x0010, 0xFFD2, 0xFFE3,
    0x0017, 0x0020, 0xFFC5, 0xFFE2, 0xFFE8, 0xFFCA, 0xFFFF, 0xFFE1,
    0x0018, 0x001D, 0x003D, 0x0008, 0x0041, 0x0014, 0x001B, 0xFFD4,
    0xFFCC, 0xFFE4, 0x0008, 0xFFFA, 0x000A, 0xFFD7, 0x000C, 0xFFE8,
    0x0038, 0x0024, 0xFFF0, 0x0061, 0xFFE8, 0xFFFF, 0xFFD3, 0x001C,
    0x0004, 0x0014, 0xFFE0, 0xFFC5, 0x0016, 0xFFD5, 0x0000, 0x0026,
    0xFFE7, 0x0016, 0xFFDD, 0xFFCA, 0xFFE8, 0x0025, 0x001B, 0xFFF6,
    0x0018, 0x0021, 0xFFD1, 0xFFF8, 0x0023, 0xFFCB, 0x000A, 0x0019,
    0xFFDE, 0x0007, 0x000B, 0xFFF5, 0xFFF7, 0xFFFA, 0x001A, 0xFFF1,
    0x004C, 0xFFE9, 0xFFB3, 0xFFCD, 0x003E, 0xFFF7, 0x000E, 0xFFF1,
    0xFFE7, 0xFFA0, 0x0008, 0x0030, 0x001A, 0x0031, 0xFFE6, 0xFFEC,
    0xFFF7, 0x0008, 0x000A, 0x000A, 0xFFF0, 0xFFD8, 0xFFCF, 0x000D,
    0x0045, 0x0029, 0xFFD6, 0xFFF6, 0x0003, 0x0012, 0x001C, 0xFFD0,
    0xFF96, 0xFFB0, 0x0020, 0xFFF1, 0x0012, 0xFFBB, 0x002B, 0xFFDC,
    0x0001, 0xFFFE, 0x001E, 0x0004, 0xFFB2, 0x0014, 0x0015, 0x0021,
    0xFFF0, 0xFFF2, 0xFFF7, 0xFFE6, 0xFFFB, 0xFFDC, 0x0017, 0x0026,
    0x002A, 0x0030, 0xFFF2, 0x0006, 0x001F, 0x0020, 0x0024, 0x001A,
    0xFFED, 0x0004, 0xFFF0, 0x0002, 0x000E, 0x0026, 0xFFCF, 0xFFE7,
    0x0000, 0x003D, 0x0048, 0xFFE9, 0xFFD5, 0x0009, 0xFFBF, 0x0005,
    0x0020, 0x0030, 0x0037, 0xFFFA, 0x0008, 0xFFC0, 0x003F, 0xFFDD,
    0xFFF6, 0xFFE1, 0x0005, 0xFFF6, 0xFFF9, 0xFFF2, 0x001E, 0x0005,
    0x002D, 0xD34B, 0x0007, 0xFFC9, 0x0003, 0x0021, 0xFFBC, 0x0054,
    0x0006, 0x0019, 0x0026, 0x0001, 0xFFE7, 0x0048, 0xFFF3, 0xFFED,
    0xFFF4, 0x0005, 0x0007, 0x002A, 0x0012, 0xFFFC, 0x001B, 0x003F,
    0x0018, 0xFFF4, 0xFFCB, 0xFFD6, 0xFFEF, 0xFFEB, 0x0031, 0x000B,
    0xFFF8, 0x0001, 0x0020, 0xFFE4, 0xFFF6, 0xFFF4, 0xFFD4, 0xFFEC,
    0xFFEA, 0x0017, 0xFFF5, 0xFFF0, 0xFFF8, 0x0044, 0x0016, 0x000B,
    0x0020, 0xFFDC, 0xFFFE, 0xFFF1, 0xFFE2, 0xFFBF, 0x0020, 0x0016,
    0x0023, 0x002B, 0xFFFE, 0xFFDF, 0x0029, 0x0005, 0xFFD0, 0xFFFD,
    0xFFB4, 0xFFC8, 0xFFE7, 0x0033, 0xFFD7, 0x0031, 0x0035, 0xFFC9,
    0x0027, 0xFFE4, 0x001D, 0xFFF6, 0x002B, 0xFFDF, 0xFFD1, 0xFFEC,
    0xFFF6, 0xFFD7, 0xFFDE, 0xFFE4, 0x0004, 0xFFC6, 0xFFBA, 0x0006,
    0x0018, 0x0001, 0xFFB2, 0x0014, 0xFFE2, 0xFFA3, 0xFFF0, 0xFFEE,
    0x0005, 0x0039, 0xFFEF, 0x000E, 0x0017, 0x0043, 0x0015, 0xFFE2,
    0x0006, 0x0008, 0x000F, 0xFFFB, 0x003B, 0xFFC2, 0xFFFD, 0xFFD4,
    0x0022, 0xFFF5, 0xFFFC, 0xFFAD, 0x0020, 0xFFEF, 0xFFFD, 0x0000,
    0x0010, 0x0080, 0x002D, 0x0018, 0x002C, 0x0013, 0xFFD8, 0x0005,
    0x0023, 0xFFF7, 0x0016, 0x0020, 0xFFC1, 0xFFF9, 0xFFE8, 0x0004,
    0x0018, 0xFFE8, 0x0026, 0xFFF1, 0xFFEA, 0xFFA7, 0x0026, 0xFFAF,
    0x0000, 0xFFB1, 0x0001, 0x0004, 0xFFE6, 0x004B, 0x001C, 0xFFE1,
    0x000F, 0x0024, 0xFFED, 0x0005, 0x0013, 0xFFBD, 0x0049, 0xFFEF,
    0xFFE0, 0x0018, 0xFFF1, 0xFFFE, 0xFFEF, 0x0016, 0x0004, 0x0025,
    0xFFE4, 0xFFDA, 0xFFEB, 0x0013, 0x0032, 0xFFFD, 0x0018, 0xFFF6,
    0xFFF3, 0x001E, 0xFFFA, 0xFFF9, 0x0012, 0x0017, 0xFFE9, 0x0027,
    0xFFCD, 0xFFF5, 0xFFFD, 0x0000, 0x000A, 0xFFEF, 0x0021, 0x003E,
    0xFFEE, 0x0032, 0xFFED, 0xFFEB, 0x0009, 0x001E, 0x0021, 0xFFF2,
    0xFFDE, 0x0011, 0xFFCB, 0x0031, 0xFFFB, 0xFFF0, 0xFFE9, 0x0026,
    0x0057, 0xFFEA, 0x000A, 0x0016, 0x003F, 0x0020, 0xFFDE, 0x0026,
    0x0015, 0x0009, 0xFFD2, 0xFF72, 0x0020, 0x002F, 0x0014, 0x0010,
    0xFFFE, 0x0001, 0xFFD7, 0xFFF3, 0xFFD5, 0x0006, 0x0004, 0x0025,
    0x0061, 0x0062, 0xFFC0, 0x0014, 0x001C, 0xFFEB, 0xFFFD, 0xFFD3,
    0x0015, 0x003A, 0x0024, 0xFFF6, 0xFFDF, 0xFFEB, 0x0008, 0xFFF7,
    0xFFF4, 0xFFEE, 0xFFD0, 0x0025, 0xFFA8, 0x000D, 0xFFEA, 0xFFF8,
    0xFFD4, 0x002A, 0xFFDF, 0xFFF8, 0x0018, 0x000E, 0xFFD9, 0x001B,
    0xFFE0, 0xFFDC, 0xFFD9, 0x0026, 0xFFFC, 0x0045, 0xFFE3, 0xFFF8,
    0x0014, 0x0026, 0xFFF4, 0xFFFA, 0x0010, 0xFFE3, 0x001A, 0xFFD4,
    0xFFD1, 0xFFE6, 0x0016, 0xFFF4, 0x0028, 0xFFF6, 0xFFF5, 0x0025,
    0x003D, 0x0019, 0x001E, 0x000A, 0xFFBB, 0xFFE5, 0x001F, 0xFFEA,
    0xFFF5, 0xFFFE, 0x0022, 0xFFB4, 0x0009, 0xFFFE, 0x0042, 0xFFD5,
    0xFFD6, 0xFFF3, 0xFFF3, 0x0043, 0x004F, 0x005B, 0xFFDD, 0xFFE2,
    0xFFDE, 0xFFDD, 0xFFE8, 0x0032, 0xFFD4, 0xFFF5, 0xFFFA, 0xFFFC,
    0x000C, 0x0043, 0x0009, 0xFFF6, 0x002E, 0x0027, 0xFFB3, 0xFFF7,
    0xFFE0, 0xFFE5, 0x0021, 0xFFFB, 0x000E, 0xFFFC, 0xFFDA, 0x0007,
    0x0033, 0x0002, 0x001E, 0xFFE6, 0xFFE5, 0xFFED, 0xFFED, 0x000E,
    0xFFE0, 0x0018, 0x0015, 0xFFEE, 0x0012, 0xFFEF, 0xFFD3, 0x0011,
    0xFFE4, 0xFFD0, 0xFFEF, 0x0051, 0x0008, 0x001A, 0xFFE3, 0xFFE6,
    0xFFFF, 0x0011, 0xFFBD, 0x002F, 0xFFCA, 0x0001, 0x0009, 0x0024,
    0x0001, 0xFFC0, 0x001F, 0x0012, 0x0043, 0xFFF7, 0x004A, 0xFFFB,
    0x001B, 0xFFF1, 0xFFCA, 0xFFFF, 0xFFBE, 0x0054, 0x001B, 0x0013,
    0x000C, 0x001F, 0xFFF7, 0x0030, 0xFFF5, 0x002B, 0x0016, 0x0017,
    0x0015, 0xFFD2, 0x002F, 0xFFCA, 0xFFC9, 0xFFBB, 0xFFD9, 0xFFC7,
    0x0027, 0xFFF0, 0xFFED, 0x0041, 0x0023, 0xFFD0, 0xFFEA, 0xFFE6,
    0x0016, 0x0024, 0xFFBC, 0xFFFA, 0x0004, 0x0004, 0x0021, 0x000E,
    0xFFF7, 0x0023, 0xFFC0, 0x0042, 0x0019, 0xFFEC, 0x0020, 0x0024,
    0x0015, 0x002A, 0xFFEF, 0xFFBF, 0x0036, 0x0016, 0xFFBA, 0x0006,
    0x0028, 0x0045, 0xFFE1, 0x0027, 0xFFC9, 0x0011, 0x0008, 0xFFD9,
    0x001C, 0x0038, 0xFFF8, 0xFFE0, 0xFFFF, 0xFFFF, 0xFFCA, 0x0000,
    0xFFEA, 0xFFFF, 0xFFDC, 0x000F, 0xFFF4, 0xFFD4, 0x0013, 0xFFF6,
    0xFFDE, 0xFFEE, 0xFFF6, 0xFFCD, 0xFFE3, 0xFFA7, 0x0015, 0x001C,
    0x0007, 0x0027, 0xFFE6, 0xFFCA, 0xFFDF, 0xFFEC, 0xFFD8, 0x000A,
    0x0017, 0x0009, 0x001F, 0xFFDD, 0x0002, 0xFFF5, 0x0001, 0xFFFB,
    0xFFED, 0x0004, 0xFFEF, 0xFFF4, 0x000D, 0xFFE6, 0xFFD6, 0x000D,
    0x002F, 0xFFD5, 0xFFE9, 0xFFD8, 0xFFD0, 0xFFD2, 0x000E, 0xFFD4,
    0xFFD7, 0x001E, 0x000F, 0x0031, 0xFFE9, 0x0028, 0xFF95, 0xFFD2,
    0xFFC5, 0xFFE4, 0xFFCC, 0xFF8A, 0x002F, 0x002C, 0x0047, 0xFFE1,
    0x0031, 0xFFD1, 0xFFE3, 0x0053, 0x0001, 0xFFC3, 0xFFE9, 0xFFF4,
    0x0004, 0x0006, 0x0014, 0x002F, 0xFFEE, 0x001E, 0x0011, 0x0018,
    0xFFE4, 0x0032, 0xFFDC, 0x0005, 0x0014, 0x0035, 0xFFE5, 0xFFD3,
    0x001F, 0x0026, 0x0036, 0xFFE2, 0x0009, 0xFFEA, 0xFFD3, 0xFFB0,
    0xFFD9, 0x000E, 0x0007, 0xFFF2, 0x003A, 0xFFDE, 0xFFDC, 0xFFF7,
    0xFFE3, 0xFFDE, 0xFFE8, 0x0001, 0xFFFE, 0xFFFA, 0xFFC0, 0x0013,
    0x0025, 0xFFEC, 0x001E, 0x0060, 0xFFFF, 0x0004, 0x001F, 0xFFDA,
    0x0009, 0x0031, 0xFFFA, 0xFFE7, 0xFFA7, 0x0011, 0x0011, 0x002E,
    0x0015, 0x000F, 0xFFCD, 0xFFC1, 0x0019, 0xFFD9, 0x0003, 0x0016,
    0x0004, 0x0016, 0x0010, 0x0030, 0xFFFB, 0xFFF9, 0x0029, 0x0027,
    0x001F, 0x0011, 0x0018, 0xFFFA, 0xFFF9, 0xFFCF, 0xFFE7, 0xFFE6,
    0x0018, 0x0039, 0x000E, 0x001E, 0x0035, 0xFFC8, 0xFFF9, 0xFFF5,
    0xFFF3, 0x002C, 0x0019, 0xFFFB, 0x002A, 0xFFD7, 0xFFDD, 0xFFFA,
    0xFFB0, 0xFFFC, 0xFFA1, 0xFFF3, 0x0024, 0x001C, 0x0008, 0x0053,
    0xFFF0, 0xFFB3, 0xFFF9, 0xFFC7, 0x0026, 0xFFF2, 0xFFE5, 0x0005,
    0x0017, 0xFFF1, 0xFFD8, 0x001B, 0xFFFD, 0x0030, 0x001D, 0x001D,
    0xFFA6, 0xFFE1, 0x0004, 0x001B, 0x0001, 0xFFFC, 0xFFD9, 0x001C,
    0xFFD5, 0x0024, 0x000E, 0x0000, 0xFFA9, 0x0002, 0x0030, 0xFFC4,
    0xFFF2, 0xFFFE, 0xFFF2, 0x0002, 0x000A, 0x0037, 0xFFF9, 0x0014,
    0x0001, 0x002B, 0x0010, 0x001F, 0xFFFD, 0xFFB1, 0xFFDA, 0xFFD6,
    0xFFF1, 0x0051, 0xFFFC, 0xFFC4, 0x000A, 0x0004, 0x000C, 0x001A,
    0x001A, 0xFFF9, 0xFFFC, 0xFFE5, 0x0028, 0x000C, 0xFFE0, 0x002B,
    0xFFD8, 0x0012, 0x000C, 0x0025, 0x0003, 0x0021, 0x0011, 0xFFF1,
    0x0008, 0xFFE5, 0x0034, 0x000F, 0xFFF9, 0x0047, 0xFFE7, 0x000C,
    0x0021, 0xFFE5, 0xFFC7, 0xFFD3, 0xFFEC, 0x0028, 0x0019, 0x0031,
    0x0011, 0x0001, 0x0035, 0xFFD4, 0xFFE8, 0x0046, 0x001B, 0xFFF9,
    0xFFBD, 0xFFC5, 0xFFFB, 0x000A, 0x0026, 0xFFC6, 0xFFE0, 0x000B,
    0x0018, 0xFFDF, 0xFFF8, 0x002A, 0x0009, 0x0004, 0x0023, 0xFFC6,
    0xFFD5, 0x0002, 0x0019, 0xFFB9, 0xFFD7, 0x0025, 0xFFDD, 0x0018,
    0x001F, 0xFFE1, 0x0005, 0xFFF4, 0xFFE3, 0x0014, 0xFFF1, 0xFFFB,
    0xFFFE, 0xFFCC, 0x004A, 0x001B, 0x0004, 0x0007, 0x001C, 0xFFE8,
    0x0011, 0x0061, 0x000B, 0x000A, 0x0025, 0x001F, 0x001E, 0x0013,
    0xFF8C, 0x0000, 0x001E, 0xFFED, 0x0025, 0xFFE1, 0x000B, 0xFFF6,
    0x0011, 0xFF9F, 0x001C, 0x0018, 0x0004, 0xFFF9, 0x004A, 0xFFE5,
    0xFFFE, 0x0034, 0xFFF1, 0x0005, 0xFFE3, 0xFFEC, 0x0005, 0x000C,
    0x001F, 0x001F, 0xFFDD, 0xFFE8, 0xFFD7, 0xFFDB, 0x0019, 0x0047,
    0xFFD5, 0xFFFE, 0x0023, 0x003A, 0x0009, 0xFFFC, 0xFFF8, 0xFFD6,
    0x0018, 0x0021, 0xFFE0, 0xFFF5, 0x0026, 0x003A, 0xFFFB, 0xFFF6,
    0xFFBD, 0x003B, 0x001B, 0x0007, 0xFFE8, 0xFFBA, 0x0035, 0x002C,
    0x0011, 0xFFFF, 0x0019, 0xFFCF, 0xFFEC, 0xFFD8, 0xFFC7, 0x002D,
    0x0021, 0x001B, 0xFFE7, 0xFFF4, 0xFFF9, 0xFFB9, 0x0034, 0xFFF1,
    0x0008, 0x001B, 0x0011, 0x000F, 0x0003, 0xFFDF, 0x000C, 0xFFDB,
    0xFFD8, 0xFFEE, 0xFFE0, 0xFFD5, 0x0028, 0xFFF4, 0xFFFC, 0x001B,
    0x001A, 0x0007, 0x000C, 0xFFE6, 0x000A, 0xFFFC, 0xFFFC, 0x003C,
    0xFFF1, 0xFFAF, 0xFFDA, 0x002A, 0xFFFD, 0x004F, 0x0010, 0xFFE1,
    0x0001, 0xFFD5, 0xFFF9, 0xFFEC, 0x000A, 0xFFC9, 0xFFF2, 0xFFFE,
    0xFFF2, 0x0002, 0x0030, 0x003C, 0xFFA9, 0xFFFE, 0x000E, 0x0000,
    0xFFD5, 0xFFDC, 0xFFD9, 0xFFE4, 0x0001, 0x0004, 0x0004, 0xFFE5,
    0xFFA6, 0x001F, 0x001D, 0xFFE3, 0xFFFD, 0xFFD0, 0xFFD8, 0xFFE5,
    0x0017, 0x000F, 0xFFE5, 0xFFFB, 0x0026, 0x000E, 0xFFF9, 0x0039,
    0xFFF0, 0x004D, 0x0008, 0xFFAD, 0x0024, 0xFFE4, 0xFFA1, 0x000D,
    0xFFB0, 0x0004, 0xFFDD, 0x0006, 0x002A, 0x0029, 0x0019, 0x0005,
    0xFFF3, 0xFFD4, 0xFFF9, 0x000B, 0x0035, 0x0038, 0x000E, 0xFFE2,
    0x0018, 0xFFC7, 0xFFE7, 0x001A, 0xFFF9, 0x0031, 0x0018, 0x0006,
    0x001F, 0xFFEF, 0x0029, 0xFFD9, 0xFFFB, 0x0007, 0x0010, 0xFFD0,
    0x0004, 0xFFEA, 0x0003, 0xFFEA, 0x0019, 0x0027, 0xFFCD, 0x003F,
    0x0015, 0xFFF1, 0x0011, 0xFFD2, 0xFFA7, 0xFFEF, 0xFFFA, 0x0019,
    0x0009, 0xFFCF, 0x001F, 0x0026, 0xFFFF, 0xFFFC, 0x001E, 0xFFA0,
    0x0025, 0x0014, 0xFFC0, 0xFFED, 0xFFFE, 0x0006, 0xFFE8, 0xFFFF,
    0xFFE3, 0x0022, 0xFFDC, 0x0009, 0x003A, 0x0022, 0x0007, 0x000E,
    0xFFD9, 0xFFF2, 0xFFD3, 0x0050, 0x0009, 0x0016, 0x0036, 0x001E,
    0x001F, 0xFFDA, 0xFFE5, 0x002D, 0x0014, 0xFFCB, 0xFFDC, 0xFFFB,
    0xFFE4, 0xFFCE, 0x0011, 0xFFE8, 0xFFEE, 0xFFE2, 0x0014, 0xFFD1,
    0x0004, 0xFFFA, 0xFFE9, 0x000C, 0x0001, 0x003D, 0xFFE3, 0xFFAD,
    0x0031, 0x002F, 0x0047, 0x001F, 0x002F, 0xFFD4, 0xFFCC, 0x0076,
    0xFFC5, 0x001C, 0xFF95, 0x002E, 0xFFE9, 0xFFD8, 0x000F, 0xFFCF,
    0xFFD7, 0xFFE2, 0x000E, 0x002C, 0xFFD0, 0x002E, 0xFFE9, 0x0028,
    0x002F, 0x002B, 0xFFD6, 0xFFF3, 0x000D, 0x001A, 0xFFEF, 0x000C,
    0xFFED, 0xFFFC, 0x0001, 0x0005, 0x0002, 0x000B, 0x001F, 0x0023,
    0x0017, 0xFFF7, 0xFFD8, 0xFFF6, 0xFFDF, 0x0014, 0xFFE6, 0x0036,
    0x0007, 0xFFD9, 0x0015, 0xFFE4, 0xFFE3, 0x0059, 0xFFF6, 0x0033,
    0xFFDE, 0x0012, 0x0013, 0x000A, 0xFFF4, 0x002C, 0xFFDC, 0xFFF1,
    0xFFEA, 0x0001, 0xFFCA, 0x0000, 0xFFFF, 0x0001, 0xFFF8, 0x0020,
    0x001C, 0xFFC8, 0x0008, 0x0027, 0xFFC9, 0xFFEF, 0xFFE1, 0xFFD9,
    0x0028, 0xFFBB, 0xFFBA, 0xFFFA, 0x0036, 0xFFEA, 0xFFEF, 0x0041,
    0x0015, 0xFFD6, 0x0020, 0xFFDC, 0x0019, 0x0014, 0xFFC0, 0xFFBE,
    0xFFF7, 0xFFDD, 0x0021, 0xFFF2, 0x0004, 0xFFFC, 0xFFBC, 0x0006,
    0x0016, 0xFFDC, 0xFFEA, 0x001A, 0x0023, 0x0030, 0xFFED, 0xFFBF,
    0x0027, 0x0010, 0xFFD9, 0x0039, 0xFFC9, 0x0045, 0x002F, 0x0036,
    0x0015, 0x002E, 0x0016, 0xFFE9, 0xFFF5, 0xFFD5, 0xFFF7, 0xFFD0,
    0x000C, 0xFFE1, 0x001B, 0xFFED, 0xFFBE, 0xFFAC, 0xFFCA, 0x0001,
    0x001B, 0x000F, 0x004A, 0x0005, 0x0043, 0x0009, 0x001F, 0xFFEE,
    0x0001, 0x0040, 0x0009, 0xFFDC, 0xFFCA, 0xFFFF, 0xFFBD, 0xFFD1,
    0xFFFF, 0xFFEF, 0xFFE3, 0x001A, 0x0008, 0xFFE6, 0xFFEF, 0xFFAF,
    0xFFE4, 0x0030, 0xFFD3, 0xFFEF, 0x0012, 0x0011, 0x0015, 0x0012,
    0xFFE0, 0xFFE8, 0xFFED, 0xFFF2, 0xFFE5, 0x0013, 0x001E, 0x001A,
    0x0033, 0xFFFE, 0xFFDA, 0xFFF9, 0x000E, 0x0004, 0x0021, 0x0005,
    0xFFE0, 0x001B, 0xFFB3, 0x0009, 0x002E, 0xFFD9, 0x0009, 0x000A,
    0x000C, 0xFFBD, 0xFFFA, 0x0004, 0xFFD4, 0x000B, 0xFFE8, 0xFFCE,
    0xFFDE, 0x0023, 0xFFDD, 0x001E, 0x004F, 0xFFA5, 0xFFF3, 0xFFBD,
    0xFFD6, 0x000D, 0x0042, 0x002B, 0x0009, 0x0002, 0x0022, 0x004C,
    0xFFF5, 0x0002, 0x001F, 0x0016, 0xFFBB, 0x001B, 0x001E, 0xFFF6,
    0x003D, 0xFFE7, 0xFFF5, 0xFFDB, 0x0028, 0x000A, 0x0016, 0x000C,
    0xFFD1, 0x001A, 0x001A, 0x002C, 0x0010, 0x001D, 0xFFF4, 0x0006,
    0x0014, 0xFFDA, 0xFFE3, 0x0008, 0xFFFC, 0xFFBB, 0xFFD9, 0xFFDA,
    0xFFE0, 0x0024, 0xFFD9, 0xFFE5, 0x0018, 0xFFF2, 0xFFDF, 0x0008,
    0xFFD4, 0xFFD6, 0xFFEA, 0x0008, 0xFFA8, 0xFFF3, 0xFFD0, 0xFFDB,
    0xFFF4, 0x0012, 0x0008, 0x0009, 0xFFDF, 0x0015, 0x0024, 0x000A,
    0x0015, 0xFFC6, 0xFFFD, 0x002D, 0x001C, 0x0015, 0xFFC0, 0xFFEC,
    0x0061, 0xFF9E, 0x0004, 0xFFDB, 0xFFD5, 0xFFFA, 0xFFD7, 0x000D,
    0xFFFE, 0xFFFF, 0x0014, 0xFFF0, 0x0020, 0xFFD1, 0xFFD2, 0x008E,
    0x0015, 0xFFF7, 0xFFDE, 0xFFDA, 0x003F, 0xFFE0, 0x000A, 0xFFEA,
    0x0057, 0x0016, 0xFFE9, 0xFFDA, 0xFFFB, 0x0010, 0xFFCB, 0xFFCF,
    0xFFDE, 0xFFEF, 0x0021, 0x000E, 0x0009, 0xFFE2, 0xFFED, 0x0015,
    0xFFEE, 0xFFCE, 0x0021, 0xFFC2, 0x000A, 0x0011, 0xFFFD, 0x0000,
    0xFFCD, 0x000B, 0xFFE9, 0xFFD9, 0x0012, 0xFFE9, 0xFFFA, 0x0007,
    0xFFF3, 0xFFE2, 0x0018, 0x000A, 0x0032, 0x0003, 0xFFEB, 0xFFED,
    0xFFE4, 0x0026, 0x0004, 0xFFDB, 0xFFEF, 0xFFEA, 0xFFF1, 0x0002,
    0xFFE0, 0xFFE8, 0x0049, 0x0011, 0x0013, 0x0043, 0xFFED, 0xFFFB,
    0x000F, 0xFFDC, 0x001C, 0x001F, 0xFFE6, 0xFFB5, 0x0001, 0xFFFC,
    0x0000, 0x004F, 0x0026, 0x0051, 0xFFEA, 0x0059, 0x0026, 0x000F,
    0x0018, 0x0018, 0xFFE8, 0xFFFC, 0xFFC1, 0x0007, 0x0016, 0xFFE0,
    0x0023, 0x0009, 0xFFD8, 0xFFFB, 0x002C, 0xFFED, 0x002D, 0xFFE8,
    0x0010, 0xFF80, 0xFFFD, 0x0000, 0x0020, 0x0011, 0xFFFC, 0x0053,
    0x0022, 0x000B, 0xFFFD, 0x002C, 0x003B, 0x003E, 0x000F, 0x0005,
    0x0006, 0xFFF8, 0x0015, 0x001E, 0x0017, 0xFFBD, 0xFFEF, 0xFFF2,
    0x0005, 0xFFC7, 0xFFF0, 0x0012, 0xFFE2, 0x005D, 0xFFB2, 0xFFEC,
    0x0018, 0xFFFF, 0xFFBA, 0xFFFA, 0x0004, 0x003A, 0xFFDE, 0x001C,
    0xFFF6, 0x0029, 0xFFD1, 0x0014, 0x002B, 0x0021, 0x001D, 0x000A,
    0x0027, 0x001C, 0x0035, 0x0037, 0xFFD7, 0xFFCF, 0xFFE7, 0xFFCD,
    0xFFB4, 0x0038, 0xFFD0, 0x0003, 0x0029, 0xFFFB, 0xFFFE, 0x0021,
    0x0023, 0xFFD5, 0x0020, 0xFFEA, 0xFFE2, 0x0041, 0xFFFE, 0x000F,
    0x0020, 0x0024, 0x0016, 0xFFF5, 0xFFF8, 0xFFBC, 0xFFF5, 0x0010,
    0xFFEA, 0xFFE9, 0xFFD4, 0x0014, 0xFFF6, 0x000C, 0x0020, 0x001C,
    0xFFF8, 0xFFFF, 0x0031, 0xFFF5, 0xFFEF, 0x0015, 0xFFCB, 0x002A,
    0x0018, 0x000C, 0x001B, 0xFFC1, 0x0012, 0x0004, 0x0007, 0xFFD6,
    0xFFF4, 0xFFFB, 0xFFF3, 0x0013, 0xFFE7, 0xFFB8, 0x0026, 0xFFFF,
    0x0006, 0xFFE7, 0xFFBC, 0xFFAC, 0x0003, 0xFFDF, 0x0007, 0x0037,
    0x002D, 0x2CB5, 0x001E, 0xFFFB, 0xFFF9, 0x000E, 0x0005, 0x000A,
    0xFFF6, 0x001F, 0x003F, 0x0023, 0x0008, 0x0040, 0x0037, 0x0006,
    0x0020, 0xFFD0, 0xFFBF, 0xFFFB, 0xFFD5, 0xFFF7, 0x0048, 0x0017,
    0x0000, 0xFFC3, 0xFFCF, 0x0019, 0x000E, 0xFFDA, 0xFFF0, 0xFFFE,
    0xFFED, 0xFFFC, 0x0024, 0xFFE6, 0x001F, 0xFFE0, 0xFFF2, 0xFFFA,
    0x002A, 0xFFD0, 0x0017, 0xFFDA, 0xFFFB, 0x0024, 0xFFF7, 0x001A,
    0xFFF0, 0x000E, 0x0015, 0xFFDF, 0xFFB2, 0xFFEC, 0x001E, 0xFFFC,
    0x0001, 0x0002, 0x002B, 0x0024, 0x0012, 0x0045, 0x0020, 0x000F,
    0xFF96, 0x0050, 0x001C, 0x0030, 0x0003, 0xFFEE, 0xFFD6, 0x000A,
    0x0045, 0xFFD7, 0xFFCF, 0xFFF3, 0xFFF0, 0x0028, 0x000A, 0xFFF6,
    0xFFF7, 0xFFF8, 0xFFE6, 0x0014, 0x001A, 0xFFCF, 0x0008, 0xFFD0,
    0xFFE7, 0x0060, 0x000E, 0x000F, 0x003E, 0x0009, 0xFFB3, 0x0033,
    0x004C, 0x0017, 0x001A, 0x000F, 0xFFF7, 0x0006, 0x000B, 0x000B,
    0xFFDE, 0xFFF9, 0x000A, 0xFFE7, 0x0023, 0x0035, 0xFFD1, 0x0008,
    0x0018, 0xFFDF, 0x001B, 0x000A, 0xFFE8, 0xFFDB, 0xFFDD, 0x0036,
    0xFFE7, 0xFFEA, 0x0000, 0xFFDA, 0x0016, 0x002B, 0xFFE0, 0x003B,
    0x0004, 0xFFEC, 0xFFD3, 0xFFE4, 0xFFE8, 0x0001, 0xFFF0, 0xFF9F,
    0x0038, 0xFFDC, 0x000C, 0x0018, 0x000A, 0x0029, 0x0008, 0x0006,
    0xFFCC, 0x001C, 0x001B, 0x002C, 0x0041, 0xFFEC, 0x003D, 0xFFF8,
    0x0018, 0xFFE3, 0xFFFF, 0x001F, 0xFFE8, 0x0036, 0xFFC5, 0x001E,
    0x0017, 0xFFE0, 0xFFD2, 0x001D, 0xFFF6, 0xFFF0, 0xFFE5, 0xFFF8,
    0x0038, 0xFFB7, 0x000D, 0x0011, 0x0034, 0x0029, 0xFFE6, 0xFFED,
    0xFFF3, 0x000E, 0x004F, 0xFFCB, 0xFFDF, 0x0018, 0xFFCE, 0xFFD7,
    0xFFEA, 0x0011, 0x003E, 0x0011, 0xFFEA, 0x0016, 0x0002, 0x0003,
    0x0031, 0x005B, 0x0000, 0x0041, 0xFFE4, 0xFFD8, 0x0031, 0xFFD5,
    0xFF9F, 0xFFE8, 0x0018, 0xFFDD, 0xFFD8, 0x0034, 0x001F, 0xFFF6,
    0xFFEC, 0x0003, 0x007F, 0x000D, 0x002D, 0x0068, 0x0005, 0x000F,
    0x000E, 0xFFF8, 0x0002, 0xFFEC, 0xFFEC, 0xFFAE, 0xFFE7, 0xFFFA,
    0xFFFD, 0xFFD7, 0x000B, 0xFFF5, 0x0032, 0x0007, 0xFFF0, 0x0001,
    0x0022, 0x003E, 0x0015, 0x000F, 0xFFE4, 0x0003, 0xFFCD, 0xFFE8,
    0xFFDF, 0x002E, 0xFFF3, 0xFFEE, 0x003C, 0xFFEE, 0x0004, 0xFFEB,
    0x0018, 0x000B, 0xFFEB, 0xFFFF, 0xFFE0, 0xFFE5, 0x0035, 0x000F
    };

static const q15_t in_cfft_noisy_2048[4096] = {
    0x0252, 0x0000, 0x3EC1, 0x0000, 0x5C48, 0x0000, 0x3855, 0x0000,
    0x0343, 0x0000, 0xCAC3, 0x0000, 0xA705, 0x0000, 0xC378, 0x0000,
    0x0773, 0x0000, 0x4097, 0x0000, 0x57A9, 0x0000, 0x3B66, 0x0000,
    0xFE72, 0x0000, 0xBB8A, 0x0000, 0xA25B, 0x0000, 0xC6D9, 0x0000,
    0xFFF7, 0x0000, 0x3D33, 0x0000, 0x5547, 0x0000, 0x421C, 0x0000,
    0xF9C1, 0x0000, 0xCCBA, 0x0000, 0xACD8, 0x0000, 0xBC55, 0x0000,
    0xFD97, 0x0000, 0x41B6, 0x0000, 0x55F4, 0x0000, 0x47D0, 0x0000,
    0x004A, 0x0000, 0xBB4B, 0x0000, 0xA7D9, 0x0000, 0xB4E3, 0x0000,
    0x020B, 0x0000, 0x4010, 0x0000, 0x59D6, 0x0000, 0x3F15, 0x0000,
    0x0BEF, 0x0000, 0xBF64, 0x0000, 0xA213, 0x0000, 0xBD77, 0x0000,
    0xFA2B, 0x0000, 0x41B2, 0x0000, 0x50FF, 0x0000, 0x4386, 0x0000,
    0xF964, 0x0000, 0xC30E, 0x0000, 0xA551, 0x0000, 0xC7F6, 0x0000,
    0x0224, 0x0000, 0x4DCB, 0x0000, 0x5F91, 0x0000, 0x37A0, 0x0000,
    0x03D9, 0x0000, 0xBD7F, 0x0000, 0xA272, 0x0000, 0xC0C7, 0x0000,
    0xF46B, 0x0000, 0x43A5, 0x0000, 0x533A, 0x0000, 0x4CE4, 0x0000,
    0x0B9E, 0x0000, 0xC0B0, 0x0000, 0xA649, 0x0000, 0xCAAF, 0x0000,
    0xFEAE, 0x0000, 0x4378, 0x0000, 0x5432, 0x0000, 0x4706, 0x0000,
    0xF90A, 0x0000, 0xC814, 0x0000, 0xAD4C, 0x0000, 0xB5AA, 0x0000,
    0x05A9, 0x0000, 0x3559, 0x0000, 0x5A05, 0x0000, 0x38F2, 0x0000,
    0xEF55, 0x0000, 0xC219, 0x0000, 0xA443, 0x0000, 0xC488, 0x0000,
    0xFC46, 0x0000, 0x39CF, 0x0000, 0x59EF, 0x0000, 0x3301, 0x0000,
    0x072E, 0x0000, 0xC358, 0x0000, 0xAC8E, 0x0000, 0xC370, 0x0000,
    0x04B0, 0x0000, 0x3D76, 0x0000, 0x5EEC, 0x0000, 0x4139, 0x0000,
    0x0ABE, 0x0000, 0xB83B, 0x0000, 0xAAC7, 0x0000, 0xC189, 0x0000,
    0x0143, 0x0000, 0x3B7F, 0x0000, 0x5FDE, 0x0000, 0x30B5, 0x0000,
    0xFAE7, 0x0000, 0xC199, 0x0000, 0xA812, 0x0000, 0xB7DB, 0x0000,
    0x0A66, 0x0000, 0x4325, 0x0000, 0x5239, 0x0000, 0x44FB, 0x0000,
    0x048F, 0x0000, 0xC50A, 0x0000, 0xA555, 0x0000, 0xC71B, 0x0000,
    0xFE64, 0x0000, 0x463F, 0x0000, 0x590C, 0x0000, 0x4B6F, 0x0000,
    0x01FB, 0x0000, 0xC38C, 0x0000, 0x9F13, 0x0000, 0xC441, 0x0000,
    0xFD93, 0x0000, 0x3BF6, 0x0000, 0x6616, 0x0000, 0x3F8B, 0x0000,
    0x0013, 0x0000, 0xBC93, 0x0000, 0xA37D, 0x0000, 0xC057, 0x0000,
    0xFEAC, 0x0000, 0x3B72, 0x0000, 0x5596, 0x0000, 0x472F, 0x0000,
    0x02C2, 0x0000, 0xC659, 0x0000, 0x9FBF, 0x0000, 0xC3D6, 0x0000,
    0xEAFC, 0x0000, 0x3D7F, 0x0000, 0x6120, 0x0000, 0x41E5, 0x0000,
    0x059F, 0x0000, 0xB376, 0x0000, 0xA026, 0x0000, 0xB7E7, 0x0000,
    0xFB14, 0x0000, 0x32BC, 0x0000, 0x5261, 0x0000, 0x4430, 0x0000,
    0x0320, 0x0000, 0xBA37, 0x0000, 0xA9E3, 0x0000, 0xC619, 0x0000,
    0xFF5F, 0x0000, 0x4822, 0x0000, 0x586D, 0x0000, 0x43AF, 0x0000,
    0xFB5A, 0x0000, 0xC7A5, 0x0000, 0xA5B7, 0x0000, 0xBBFF, 0x0000,
    0xFC72, 0x0000, 0x3060, 0x0000, 0x547F, 0x0000, 0x35FE, 0x0000,
    0x0A25, 0x0000, 0xC5D2, 0x0000, 0xB038, 0x0000, 0xB7BF, 0x0000,
    0xF6FC, 0x0000, 0x3DC3, 0x0000, 0x55FE, 0x0000, 0x3AD7, 0x0000,
    0xFCB2, 0x0000, 0xB6D9, 0x0000, 0xAC6B, 0x0000, 0xC048, 0x0000,
    0xFDEF, 0x0000, 0x35C8, 0x0000, 0x596E, 0x0000, 0x39B9, 0x0000,
    0x0F66, 0x0000, 0xBE99, 0x0000, 0xA97E, 0x0000, 0xC1A9, 0x0000,
    0xFEA3, 0x0000, 0x3C1F, 0x0000, 0x58B7, 0x0000, 0x45BB, 0x0000,
    0xFF64, 0x0000, 0xB9DF, 0x0000, 0xB587, 0x0000, 0xB989, 0x0000,
    0xF945, 0x0000, 0x47E8, 0x0000, 0x4F76, 0x0000, 0x412D, 0x0000,
    0xFEFD, 0x0000, 0xC083, 0x0000, 0xB0E5, 0x0000, 0xB6F0, 0x0000,
    0xF93D, 0x0000, 0x4540, 0x0000, 0x5850, 0x0000, 0x3B0A, 0x0000,
    0x0E00, 0x0000, 0xBE48, 0x0000, 0xA731, 0x0000, 0xBDE3, 0x0000,
    0xFCF6, 0x0000, 0x330E, 0x0000, 0x567A, 0x0000, 0x399A, 0x0000,
    0x0641, 0x0000, 0xBC06, 0x0000, 0x9DF6, 0x0000, 0xC793, 0x0000,
    0xFE1D, 0x0000, 0x31BC, 0x0000, 0x5D4F, 0x0000, 0x49F2, 0x0000,
    0xFECF, 0x0000, 0xC438, 0x0000, 0xA308, 0x0000, 0xB824, 0x0000,
    0xF498, 0x0000, 0x3D1E, 0x0000, 0x5606, 0x0000, 0x417F, 0x0000,
    0x021F, 0x0000, 0xC4C4, 0x0000, 0xAE66, 0x0000, 0xC9B5, 0x0000,
    0x05C5, 0x0000, 0x364F, 0x0000, 0x4CBC, 0x0000, 0x4A40, 0x0000,
    0x0696, 0x0000, 0xC332, 0x0000, 0xA82B, 0x0000, 0xC126, 0x0000,
    0x0151, 0x0000, 0x39C5, 0x0000, 0x5360, 0x0000, 0x43EF, 0x0000,
    0xFFB0, 0x0000, 0xC2AE, 0x0000, 0xA1C9, 0x0000, 0xB5EC, 0x0000,
    0xF972, 0x0000, 0x2EC8, 0x0000, 0x5490, 0x0000, 0x4380, 0x0000,
    0xFF12, 0x0000, 0xBEB5, 0x0000, 0x9FC4, 0x0000, 0xC64A, 0x0000,
    0xFB08, 0x0000, 0x3ABE, 0x0000, 0x521E, 0x0000, 0x46E9, 0x0000,
    0xFAB7, 0x0000, 0xB75A, 0x0000, 0xA0EF, 0x0000, 0xBF0A, 0x0000,
    0xFE04, 0x0000, 0x3A41, 0x0000, 0x4C22, 0x0000, 0x4488, 0x0000,
    0x0402, 0x0000, 0xC34F, 0x0000, 0xA05A, 0x0000, 0xB986, 0x0000,
    0x03B1, 0x0000, 0x3CE5, 0x0000, 0x549A, 0x0000, 0x3848, 0x0000,
    0xF6E4, 0x0000, 0xBFF3, 0x0000, 0x99A1, 0x0000, 0xC7DD, 0x0000,
    0x01D3, 0x0000, 0x3EAA, 0x0000, 0x607E, 0x0000, 0x4D9C, 0x0000,
    0xFAC9, 0x0000, 0xC544, 0x0000, 0xA356, 0x0000, 0xC685, 0x0000,
    0x061C, 0x0000, 0x3E6E, 0x0000, 0x6153, 0x0000, 0x427B, 0x0000,
    0xFCC9, 0x0000, 0xC176, 0x0000, 0xA189, 0x0000, 0xAD1B, 0x0000,
    0xFFF4, 0x0000, 0x47A9, 0x0000, 0x4BD9, 0x0000, 0x3B9D, 0x0000,
    0x0951, 0x0000, 0xBF25, 0x0000, 0xA5B4, 0x0000, 0xC031, 0x0000,
    0x0516, 0x0000, 0x495A, 0x0000, 0x59BD, 0x0000, 0x46EC, 0x0000,
    0xFC87, 0x0000, 0xC82E, 0x0000, 0xAD7F, 0x0000, 0xB95D, 0x0000,
    0x0254, 0x0000, 0x42E0, 0x0000, 0x605A, 0x0000, 0x3D21, 0x0000,
    0x0906, 0x0000, 0xC542, 0x0000, 0xAD6B, 0x0000, 0xC19C, 0x0000,
    0xFF50, 0x0000, 0x3F35, 0x0000, 0x59F4, 0x0000, 0x380D, 0x0000,
    0x0015, 0x0000, 0xBC78, 0x0000, 0xA392, 0x0000, 0xC6A8, 0x0000,
    0xFDAC, 0x0000, 0x4F69, 0x0000, 0x525B, 0x0000, 0x431B, 0x0000,
    0xFD0D, 0x0000, 0xC2CC, 0x0000, 0xA277, 0x0000, 0xB8FA, 0x0000,
    0x00F6, 0x0000, 0x3D15, 0x0000, 0x543F, 0x0000, 0x3C70, 0x0000,
    0xF574, 0x0000, 0xB32E, 0x0000, 0xA76E, 0x0000, 0xBA19, 0x0000,
    0x0312, 0x0000, 0x3151, 0x0000, 0x5F77, 0x0000, 0x447A, 0x0000,
    0xFF32, 0x0000, 0xC4EA, 0x0000, 0xA175, 0x0000, 0xC1FA, 0x0000,
    0x0558, 0x0000, 0x3C7C, 0x0000, 0x65BB, 0x0000, 0x3AD7, 0x0000,
    0x06F6, 0x0000, 0xC3D1, 0x0000, 0xAF1E, 0x0000, 0xBBA4, 0x0000,
    0xF860, 0x0000, 0x47E4, 0x0000, 0x5AE0, 0x0000, 0x3E9F, 0x0000,
    0xFC99, 0x0000, 0xB9A9, 0x0000, 0xA41F, 0x0000, 0xCF55, 0x0000,
    0xF109, 0x0000, 0x3330, 0x0000, 0x6AB9, 0x0000, 0x46DB, 0x0000,
    0x0817, 0x0000, 0xBEC1, 0x0000, 0xA923, 0x0000, 0xB9A7, 0x0000,
    0x0898, 0x0000, 0x3A4D, 0x0000, 0x5BC2, 0x0000, 0x3A39, 0x0000,
    0xF568, 0x0000, 0xC4D1, 0x0000, 0xA2EF, 0x0000, 0xBEE8, 0x0000,
    0xFE6D, 0x0000, 0x2C54, 0x0000, 0x5BA4, 0x0000, 0x377A, 0x0000,
    0x0DA2, 0x0000, 0xBD54, 0x0000, 0xAA6F, 0x0000, 0xB3A9, 0x0000,
    0x070E, 0x0000, 0x4145, 0x0000, 0x55E3, 0x0000, 0x39A3, 0x0000,
    0x0191, 0x0000, 0xB561, 0x0000, 0x9EDC, 0x0000, 0xC95E, 0x0000,
    0x045D, 0x0000, 0x3E4E, 0x0000, 0x55AF, 0x0000, 0x405C, 0x0000,
    0x053C, 0x0000, 0xBFE4, 0x0000, 0xAD87, 0x0000, 0xBE30, 0x0000,
    0x0ED6, 0x0000, 0x424B, 0x0000, 0x5B97, 0x0000, 0x4209, 0x0000,
    0x076F, 0x0000, 0xC3E4, 0x0000, 0xA2A3, 0x0000, 0xB8FE, 0x0000,
    0x0051, 0x0000, 0x4540, 0x0000, 0x591B, 0x0000, 0x386F, 0x0000,
    0x0109, 0x0000, 0xB97F, 0x0000, 0xA787, 0x0000, 0xBFB6, 0x0000,
    0xFF2E, 0x0000, 0x3C6A, 0x0000, 0x5EA2, 0x0000, 0x42E9, 0x0000,
    0xF263, 0x0000, 0xC0D3, 0x0000, 0xAB14, 0x0000, 0xC081, 0x0000,
    0x05F3, 0x0000, 0x3E4B, 0x0000, 0x5D98, 0x0000, 0x3934, 0x0000,
    0x01D9, 0x0000, 0xB83C, 0x0000, 0xAFC2, 0x0000, 0xBAD7, 0x0000,
    0x028E, 0x0000, 0x3617, 0x0000, 0x4E76, 0x0000, 0x371E, 0x0000,
    0x01E9, 0x0000, 0xB916, 0x0000, 0xA208, 0x0000, 0xB750, 0x0000,
    0x061D, 0x0000, 0x45D5, 0x0000, 0x5676, 0x0000, 0x38EC, 0x0000,
    0x00CD, 0x0000, 0xCB2F, 0x0000, 0xA48D, 0x0000, 0xBCB3, 0x0000,
    0xFF91, 0x0000, 0x38E7, 0x0000, 0x5880, 0x0000, 0x38D5, 0x0000,
    0xF727, 0x0000, 0xB531, 0x0000, 0xA6A5, 0x0000, 0xC930, 0x0000,
    0xF9DC, 0x0000, 0x2FE7, 0x0000, 0x5602, 0x0000, 0x378E, 0x0000,
    0x0689, 0x0000, 0xC180, 0x0000, 0xAA4C, 0x0000, 0xC15C, 0x0000,
    0x04EB, 0x0000, 0x3E23, 0x0000, 0x5837, 0x0000, 0x4451, 0x0000,
    0x07AE, 0x0000, 0xBDB3, 0x0000, 0x994C, 0x0000, 0xCA63, 0x0000,
    0x0712, 0x0000, 0x370A, 0x0000, 0x5162, 0x0000, 0x4294, 0x0000,
    0xF8D7, 0x0000, 0xC65C, 0x0000, 0xA5C4, 0x0000, 0xBB85, 0x0000,
    0xFEED, 0x0000, 0x3C20, 0x0000, 0x5356, 0x0000, 0x4364, 0x0000,
    0xFF42, 0x0000, 0xC20F, 0x0000, 0xA7F1, 0x0000, 0xC4F1, 0x0000,
    0xFD28, 0x0000, 0x4B86, 0x0000, 0x55A3, 0x0000, 0x377E, 0x0000,
    0x0D1C, 0x0000, 0xC226, 0x0000, 0xA2CF, 0x0000, 0xC057, 0x0000,
    0x0564, 0x0000, 0x468B, 0x0000, 0x58B8, 0x0000, 0x47E3, 0x0000,
    0x05EE, 0x0000, 0xC7A7, 0x0000, 0xA70E, 0x0000, 0xC6E6, 0x0000,
    0xFCB2, 0x0000, 0x46A1, 0x0000, 0x46F7, 0x0000, 0x3AF7, 0x0000,
    0xF9F8, 0x0000, 0xB767, 0x0000, 0xA348, 0x0000, 0xB89C, 0x0000,
    0xF95D, 0x0000, 0x37FA, 0x0000, 0x5DEA, 0x0000, 0x3A3D, 0x0000,
    0xF662, 0x0000, 0xBF6F, 0x0000, 0xAA8B, 0x0000, 0xBE29, 0x0000,
    0xFAF9, 0x0000, 0x4735, 0x0000, 0x5320, 0x0000, 0x3D30, 0x0000,
    0x016F, 0x0000, 0xD00F, 0x0000, 0xA780, 0x0000, 0xC12F, 0x0000,
    0xFEA7, 0x0000, 0x35EC, 0x0000, 0x6050, 0x0000, 0x3F3D, 0x0000,
    0x045F, 0x0000, 0xB94C, 0x0000, 0xA3ED, 0x0000, 0xB84E, 0x0000,
    0xFD56, 0x0000, 0x3C00, 0x0000, 0x5034, 0x0000, 0x46C2, 0x0000,
    0xF93A, 0x0000, 0xD1B8, 0x0000, 0x9EF9, 0x0000, 0xC14E, 0x0000,
    0xFD45, 0x0000, 0x382D, 0x0000, 0x63E3, 0x0000, 0x43F3, 0x0000,
    0xFCAA, 0x0000, 0xBA76, 0x0000, 0xA053, 0x0000, 0xC30B, 0x0000,
    0x0307, 0x0000, 0x398B, 0x0000, 0x52D9, 0x0000, 0x3CA2, 0x0000,
    0xF795, 0x0000, 0xB180, 0x0000, 0xAA4F, 0x0000, 0xC3BF, 0x0000,
    0xFD16, 0x0000, 0x3CEA, 0x0000, 0x5059, 0x0000, 0x368D, 0x0000,
    0x00B5, 0x0000, 0xB031, 0x0000, 0xAE3C, 0x0000, 0xBE94, 0x0000,
    0x0178, 0x0000, 0x4375, 0x0000, 0x59D4, 0x0000, 0x3A35, 0x0000,
    0xFDEF, 0x0000, 0xC32F, 0x0000, 0xA7C1, 0x0000, 0xBCCC, 0x0000,
    0x0061, 0x0000, 0x3E4A, 0x0000, 0x5935, 0x0000, 0x377C, 0x0000,
    0xF8FF, 0x0000, 0xB8A1, 0x0000, 0xA3F3, 0x0000, 0xB996, 0x0000,
    0xFC33, 0x0000, 0x3DD8, 0x0000, 0x52B8, 0x0000, 0x4023, 0x0000,
    0x09C4, 0x0000, 0xAC46, 0x0000, 0x9F5A, 0x0000, 0xC215, 0x0000,
    0xFBA9, 0x0000, 0x4D1A, 0x0000, 0x6836, 0x0000, 0x3DE6, 0x0000,
    0xFE1A, 0x0000, 0xC6BF, 0x0000, 0xA610, 0x0000, 0xCE5A, 0x0000,
    0x0904, 0x0000, 0x41A6, 0x0000, 0x56AD, 0x0000, 0x3FBD, 0x0000,
    0x026B, 0x0000, 0xC6F9, 0x0000, 0xB0B6, 0x0000, 0xBE2E, 0x0000,
    0x08D6, 0x0000, 0x42CB, 0x0000, 0x5906, 0x0000, 0x46A2, 0x0000,
    0xFF22, 0x0000, 0xB642, 0x0000, 0xA413, 0x0000, 0xB7F7, 0x0000,
    0x06D4, 0x0000, 0x42B9, 0x0000, 0x56AD, 0x0000, 0x44D7, 0x0000,
    0xF11C, 0x0000, 0xBA23, 0x0000, 0xA4B6, 0x0000, 0xC70B, 0x0000,
    0x0476, 0x0000, 0x3E7A, 0x0000, 0x5AD3, 0x0000, 0x30E1, 0x0000,
    0x02AF, 0x0000, 0xC6F0, 0x0000, 0xA4C7, 0x0000, 0xBAAB, 0x0000,
    0x0058, 0x0000, 0x427C, 0x0000, 0x56B7, 0x0000, 0x3CF8, 0x0000,
    0xFE7E, 0x0000, 0xBBF3, 0x0000, 0xA116, 0x0000, 0xCE53, 0x0000,
    0xFE13, 0x0000, 0x3DA5, 0x0000, 0x543D, 0x0000, 0x4A14, 0x0000,
    0xFE7E, 0x0000, 0xC330, 0x0000, 0x9A66, 0x0000, 0xC90A, 0x0000,
    0xFCD2, 0x0000, 0x40B7, 0x0000, 0x54D0, 0x0000, 0x35FB, 0x0000,
    0xF393, 0x0000, 0xBDCE, 0x0000, 0xA384, 0x0000, 0xC8F3, 0x0000,
    0xFB4F, 0x0000, 0x4459, 0x0000, 0x4F65, 0x0000, 0x3874, 0x0000,
    0x01C0, 0x0000, 0xBED2, 0x0000, 0x9F92, 0x0000, 0xC8B5, 0x0000,
    0xFD5F, 0x0000, 0x43E7, 0x0000, 0x5662, 0x0000, 0x3E35, 0x0000,
    0x011C, 0x0000, 0xBDD5, 0x0000, 0xAB9B, 0x0000, 0xBC39, 0x0000,
    0x05B3, 0x0000, 0x3AAD, 0x0000, 0x4A69, 0x0000, 0x3E15, 0x0000,
    0x0304, 0x0000, 0xC04A, 0x0000, 0x9F69, 0x0000, 0xBD77, 0x0000,
    0xF830, 0x0000, 0x3923, 0x0000, 0x5A63, 0x0000, 0x47C7, 0x0000,
    0xFCE8, 0x0000, 0xB8F9, 0x0000, 0xA195, 0x0000, 0xC1F0, 0x0000,
    0x09BE, 0x0000, 0x3E91, 0x0000, 0x5CC2, 0x0000, 0x4019, 0x0000,
    0xFDC5, 0x0000, 0xC3B4, 0x0000, 0xA61A, 0x0000, 0xCD3C, 0x0000,
    0x0023, 0x0000, 0x433C, 0x0000, 0x52D7, 0x0000, 0x390A, 0x0000,
    0xF254, 0x0000, 0xBB82, 0x0000, 0x9F85, 0x0000, 0xC240, 0x0000,
    0xF39F, 0x0000, 0x3BD0, 0x0000, 0x5CEC, 0x0000, 0x4C20, 0x0000,
    0xFE0E, 0x0000, 0xC08F, 0x0000, 0xA697, 0x0000, 0xC52A, 0x0000,
    0xFA03, 0x0000, 0x380F, 0x0000, 0x5BEB, 0x0000, 0x4109, 0x0000,
    0x059C, 0x0000, 0xC695, 0x0000, 0xA5DD, 0x0000, 0xB814, 0x0000,
    0x013A, 0x0000, 0x35AB, 0x0000, 0x5719, 0x0000, 0x45D7, 0x0000,
    0xF81B, 0x0000, 0xBC39, 0x0000, 0xAB2D, 0x0000, 0xBAFE, 0x0000,
    0x04AC, 0x0000, 0x40A6, 0x0000, 0x5F76, 0x0000, 0x3E35, 0x0000,
    0x0137, 0x0000, 0xBAE8, 0x0000, 0xA032, 0x0000, 0xC2D9, 0x0000,
    0xFC8B, 0x0000, 0x40A6, 0x0000, 0x5BC9, 0x0000, 0x4026, 0x0000,
    0xFD2E, 0x0000, 0xC32F, 0x0000, 0xA89E, 0x0000, 0xC1B0, 0x0000,
    0x0BB9, 0x0000, 0x4544, 0x0000, 0x583B, 0x0000, 0x3F1E, 0x0000,
    0xFE69, 0x0000, 0xC237, 0x0000, 0xAF31, 0x0000, 0xBDAB, 0x0000,
    0x03D4, 0x0000, 0x3FCA, 0x0000, 0x5DA8, 0x0000, 0x4289, 0x0000,
    0x0558, 0x0000, 0xBF15, 0x0000, 0x982C, 0x0000, 0xC57D, 0x0000,
    0x0A5C, 0x0000, 0x36B0, 0x0000, 0x580D, 0x0000, 0x3E88, 0x0000,
    0xFF2C, 0x0000, 0xC419, 0x0000, 0xABBE, 0x0000, 0xBCCD, 0x0000,
    0xFE7C, 0x0000, 0x4380, 0x0000, 0x55FA, 0x0000, 0x3F84, 0x0000,
    0x0AB5, 0x0000, 0xC0AC, 0x0000, 0xAAB2, 0x0000, 0xC319, 0x0000,
    0x0020, 0x0000, 0x40F7, 0x0000, 0x564D, 0x0000, 0x3280, 0x0000,
    0xFBB9, 0x0000, 0xBBBC, 0x0000, 0x9F2D, 0x0000, 0xC2FE, 0x0000,
    0xFE5F, 0x0000, 0x477A, 0x0000, 0x4D3E, 0x0000, 0x3FE3, 0x0000,
    0x003E, 0x0000, 0xC740, 0x0000, 0xA301, 0x0000, 0xBB85, 0x0000,
    0x06DC, 0x0000, 0x3960, 0x0000, 0x56A9, 0x0000, 0x39E6, 0x0000,
    0xF611, 0x0000, 0xC7FA, 0x0000, 0xAE43, 0x0000, 0xBE49, 0x0000,
    0xFAEA, 0x0000, 0x3D06, 0x0000, 0x5910, 0x0000, 0x4CCA, 0x0000,
    0x081B, 0x0000, 0xC643, 0x0000, 0xB3D0, 0x0000, 0xB7EE, 0x0000,
    0xF886, 0x0000, 0x3CFF, 0x0000, 0x56A0, 0x0000, 0x3663, 0x0000,
    0x0176, 0x0000, 0xBD02, 0x0000, 0xA9EB, 0x0000, 0xC07A, 0x0000,
    0x0130, 0x0000, 0x3FD2, 0x0000, 0x5EE4, 0x0000, 0x39E5, 0x0000,
    0xFCC9, 0x0000, 0xC18B, 0x0000, 0xA4EF, 0x0000, 0xBF72, 0x0000,
    0xF8FF, 0x0000, 0x4331, 0x0000, 0x56F1, 0x0000, 0x3351, 0x0000,
    0x0643, 0x0000, 0xBDF2, 0x0000, 0xA39B, 0x0000, 0xB805, 0x0000,
    0xF3EC, 0x0000, 0x4169, 0x0000, 0x5236, 0x0000, 0x4010, 0x0000,
    0x046B, 0x0000, 0xC1FB, 0x0000, 0xA389, 0x0000, 0xC256, 0x0000,
    0x0383, 0x0000, 0x4C4A, 0x0000, 0x5951, 0x0000, 0x45F9, 0x0000,
    0x0177, 0x0000, 0xBF6B, 0x0000, 0xA7E9, 0x0000, 0xBC98, 0x0000,
    0x0448, 0x0000, 0x3F60, 0x0000, 0x60EF, 0x0000, 0x3A23, 0x0000,
    0x0341, 0x0000, 0xBFA4, 0x0000, 0x9947, 0x0000, 0xBB6B, 0x0000,
    0x0EFE, 0x0000, 0x3A4D, 0x0000, 0x5239, 0x0000, 0x34E6, 0x0000,
    0x081B, 0x0000, 0xBD26, 0x0000, 0x9B83, 0x0000, 0xC18F, 0x0000,
    0xFA7E, 0x0000, 0x3B6F, 0x0000, 0x589D, 0x0000, 0x383B, 0x0000,
    0xFF5B, 0x0000, 0xB5D4, 0x0000, 0xA24C, 0x0000, 0xBEAD, 0x0000,
    0x019D, 0x0000, 0x3EF7, 0x0000, 0x5DB0, 0x0000, 0x3CE9, 0x0000,
    0xFC8B, 0x0000, 0xB9CF, 0x0000, 0xAD2D, 0x0000, 0xB9CA, 0x0000,
    0xEF9C, 0x0000, 0x457F, 0x0000, 0x6580, 0x0000, 0x3FDD, 0x0000,
    0xFE3C, 0x0000, 0xC893, 0x0000, 0xB181, 0x0000, 0xBD9E, 0x0000,
    0x0A8D, 0x0000, 0x3BD9, 0x0000, 0x5AC3, 0x0000, 0x4687, 0x0000,
    0x07C4, 0x0000, 0xC2BF, 0x0000, 0x9D6D, 0x0000, 0xC7BB, 0x0000,
    0x001E, 0x0000, 0x4434, 0x0000, 0x6028, 0x0000, 0x4593, 0x0000,
    0xF554, 0x0000, 0xBC3F, 0x0000, 0xA5BC, 0x0000, 0xBDAD, 0x0000,
    0xF8F1, 0x0000, 0x3832, 0x0000, 0x5FC1, 0x0000, 0x420E, 0x0000,
    0xFBA9, 0x0000, 0xB16F, 0x0000, 0xA0C2, 0x0000, 0xCA46, 0x0000,
    0xF864, 0x0000, 0x4252, 0x0000, 0x4C5D, 0x0000, 0x381F, 0x0000,
    0xFE17, 0x0000, 0xC5AC, 0x0000, 0x9699, 0x0000, 0xC75E, 0x0000,
    0xFFD9, 0x0000, 0x4161, 0x0000, 0x4F89, 0x0000, 0x3DCE, 0x0000,
    0xF703, 0x0000, 0xB8BB, 0x0000, 0xB3E0, 0x0000, 0xCC36, 0x0000,
    0x0B77, 0x0000, 0x4121, 0x0000, 0x5D39, 0x0000, 0x431D, 0x0000,
    0xFF01, 0x0000, 0xC729, 0x0000, 0x9911, 0x0000, 0xC727, 0x0000,
    0xFBDB, 0x0000, 0x4AF5, 0x0000, 0x5DF1, 0x0000, 0x446B, 0x0000,
    0xF772, 0x0000, 0xB8C8, 0x0000, 0xA237, 0x0000, 0xC24C, 0x0000,
    0x1247, 0x0000, 0x415B, 0x0000, 0x5631, 0x0000, 0x3AC7, 0x0000,
    0x00FA, 0x0000, 0xCD4D, 0x0000, 0x9CA9, 0x0000, 0xBC09, 0x0000,
    0x02A0, 0x0000, 0x47E0, 0x0000, 0x52C1, 0x0000, 0x38D7, 0x0000,
    0xFC76, 0x0000, 0xC3FC, 0x0000, 0x9F90, 0x0000, 0xC4F7, 0x0000,
    0x094C, 0x0000, 0x4744, 0x0000, 0x58A1, 0x0000, 0x3611, 0x0000,
    0xFFD3, 0x0000, 0xC420, 0x0000, 0xA9DB, 0x0000, 0xC2DE, 0x0000,
    0xFDF0, 0x0000, 0x321F, 0x0000, 0x578F, 0x0000, 0x4645, 0x0000,
    0xFF97, 0x0000, 0xBDE0, 0x0000, 0xA930, 0x0000, 0xBC78, 0x0000,
    0x0D9F, 0x0000, 0x4950, 0x0000, 0x5BAB, 0x0000, 0x4466, 0x0000,
    0x0168, 0x0000, 0xC904, 0x0000, 0xA8F0, 0x0000, 0xCB71, 0x0000,
    0x0723, 0x0000, 0x49EC, 0x0000, 0x5B4C, 0x0000, 0x36AA, 0x0000,
    0x1129, 0x0000, 0xBA5C, 0x0000, 0xAB63, 0x0000, 0xC09C, 0x0000,
    0xFD88, 0x0000, 0x426D, 0x0000, 0x5FC7, 0x0000, 0x3EE1, 0x0000,
    0xFCC6, 0x0000, 0xBECA, 0x0000, 0xA3B7, 0x0000, 0xC417, 0x0000,
    0xFA9C, 0x0000, 0x3DDA, 0x0000, 0x5C2D, 0x0000, 0x3A4C, 0x0000,
    0xFC59, 0x0000, 0xBE5B, 0x0000, 0xA8DC, 0x0000, 0xC3B7, 0x0000,
    0x00F5, 0x0000, 0x3D3E, 0x0000, 0x57B1, 0x0000, 0x3B6C, 0x0000,
    0x052A, 0x0000, 0xC474, 0x0000, 0xA5ED, 0x0000, 0xCE33, 0x0000,
    0xF704, 0x0000, 0x42EB, 0x0000, 0x579A, 0x0000, 0x3CAD, 0x0000,
    0xF461, 0x0000, 0xC5AA, 0x0000, 0xA343, 0x0000, 0xC045, 0x0000,
    0x0733, 0x0000, 0x37E6, 0x0000, 0x5872, 0x0000, 0x39F2, 0x0000,
    0x0022, 0x0000, 0xBF48, 0x0000, 0x9C62, 0x0000, 0xC604, 0x0000,
    0xFD3A, 0x0000, 0x388A, 0x0000, 0x6550, 0x0000, 0x43CB, 0x0000,
    0x0AB6, 0x0000, 0xBCA4, 0x0000, 0xA857, 0x0000, 0xBD21, 0x0000,
    0xEE95, 0x0000, 0x4038, 0x0000, 0x5037, 0x0000, 0x359B, 0x0000,
    0x0EF8, 0x0000, 0xBFD9, 0x0000, 0xA67A, 0x0000, 0xC650, 0x0000,
    0xFC62, 0x0000, 0x3E98, 0x0000, 0x5C39, 0x0000, 0x4180, 0x0000,
    0xFDB9, 0x0000, 0xBAB0, 0x0000, 0xA9AF, 0x0000, 0xC759, 0x0000,
    0xFE20, 0x0000, 0x426E, 0x0000, 0x4DA2, 0x0000, 0x4D72, 0x0000,
    0xF2F8, 0x0000, 0xBFEF, 0x0000, 0xA962, 0x0000, 0xC1B3, 0x0000,
    0x0E59, 0x0000, 0x3D00, 0x0000, 0x6389, 0x0000, 0x3BFF, 0x0000,
    0xF773, 0x0000, 0xC3B8, 0x0000, 0xA619, 0x0000, 0xBE36, 0x0000,
    0xFD0D, 0x0000, 0x4A21, 0x0000, 0x5E5D, 0x0000, 0x41F5, 0x0000,
    0x0C14, 0x0000, 0xC44A, 0x0000, 0xA8A1, 0x0000, 0xC214, 0x0000,
    0xF41B, 0x0000, 0x42DE, 0x0000, 0x5158, 0x0000, 0x3D8C, 0x0000,
    0xFFE5, 0x0000, 0xBE3D, 0x0000, 0xACF9, 0x0000, 0xBB42, 0x0000,
    0xFD71, 0x0000, 0x3FCB, 0x0000, 0x4B68, 0x0000, 0x36FE, 0x0000,
    0xFA9D, 0x0000, 0xC5A5, 0x0000, 0x971C, 0x0000, 0xB78B, 0x0000,
    0x09DE, 0x0000, 0x4196, 0x0000, 0x553E, 0x0000, 0x403E, 0x0000,
    0x0333, 0x0000, 0xC954, 0x0000, 0xA720, 0x0000, 0xBCAA, 0x0000,
    0xFA59, 0x0000, 0x3909, 0x0000, 0x510D, 0x0000, 0x3E36, 0x0000,
    0xF8E9, 0x0000, 0xB9DA, 0x0000, 0xA1D3, 0x0000, 0xC1AD, 0x0000,
    0xFDD7, 0x0000, 0x3643, 0x0000, 0x5FA1, 0x0000, 0x4A35, 0x0000,
    0xFA97, 0x0000, 0xBEBE, 0x0000, 0xA3FF, 0x0000, 0xC367, 0x0000,
    0xFE97, 0x0000, 0x4179, 0x0000, 0x60B7, 0x0000, 0x44EB, 0x0000,
    0xFB3B, 0x0000, 0xBE65, 0x0000, 0xA885, 0x0000, 0xBD13, 0x0000,
    0xFE8B, 0x0000, 0x369E, 0x0000, 0x5C02, 0x0000, 0x451D, 0x0000,
    0xFBD5, 0x0000, 0xB9C0, 0x0000, 0xB025, 0x0000, 0xC338, 0x0000,
    0xFCFA, 0x0000, 0x3EFA, 0x0000, 0x5961, 0x0000, 0x3EA6, 0x0000,
    0xFA4A, 0x0000, 0xB93B, 0x0000, 0xA5CF, 0x0000, 0xC4AA, 0x0000,
    0xFD9B, 0x0000, 0x35E9, 0x0000, 0x5AC7, 0x0000, 0x49E4, 0x0000,
    0x07FB, 0x0000, 0xC28F, 0x0000, 0xA5CB, 0x0000, 0xC4D9, 0x0000,
    0x08F2, 0x0000, 0x3F77, 0x0000, 0x57FC, 0x0000, 0x3DF0, 0x0000,
    0xFD4F, 0x0000, 0xB75E, 0x0000, 0xA4C8, 0x0000, 0xC68E, 0x0000,
    0xF912, 0x0000, 0x4331, 0x0000, 0x5D40, 0x0000, 0x376F, 0x0000,
    0x038E, 0x0000, 0xC724, 0x0000, 0xAA77, 0x0000, 0xB871, 0x0000,
    0xFE63, 0x0000, 0x441E, 0x0000, 0x65D5, 0x0000, 0x50FF, 0x0000,
    0xFCEA, 0x0000, 0xBBDD, 0x0000, 0xA35F, 0x0000, 0xB422, 0x0000,
    0xFBBA, 0x0000, 0x4B81, 0x0000, 0x548D, 0x0000, 0x47E0, 0x0000,
    0x01ED, 0x0000, 0xC7BF, 0x0000, 0xA71B, 0x0000, 0xBCC9, 0x0000,
    0x05B7, 0x0000, 0x3C9E, 0x0000, 0x5AB2, 0x0000, 0x3A79, 0x0000,
    0x0877, 0x0000, 0xAD36, 0x0000, 0xAA2E, 0x0000, 0xC592, 0x0000,
    0xF663, 0x0000, 0x3465, 0x0000, 0x5258, 0x0000, 0x4B9D, 0x0000,
    0x02D9, 0x0000, 0xC2E3, 0x0000, 0xA9BE, 0x0000, 0xC520, 0x0000,
    0xFB72, 0x0000, 0x491A, 0x0000, 0x562B, 0x0000, 0x3B2C, 0x0000,
    0xFAF2, 0x0000, 0xB76C, 0x0000, 0xA8E1, 0x0000, 0xC3E3, 0x0000,
    0xFC95, 0x0000, 0x39FE, 0x0000, 0x663F, 0x0000, 0x44BC, 0x0000,
    0xFC79, 0x0000, 0xB85C, 0x0000, 0x9BA9, 0x0000, 0xC167, 0x0000,
    0xFC04, 0x0000, 0x3BDB, 0x0000, 0x5E1D, 0x0000, 0x42D5, 0x0000,
    0x001B, 0x0000, 0xC37C, 0x0000, 0xA42F, 0x0000, 0xBE08, 0x0000,
    0x0A99, 0x0000, 0x4390, 0x0000, 0x4CDC, 0x0000, 0x3B27, 0x0000,
    0x0121, 0x0000, 0xBE36, 0x0000, 0xAAB4, 0x0000, 0xBA3E, 0x0000,
    0xFF78, 0x0000, 0x3EE9, 0x0000, 0x5FAF, 0x0000, 0x4032, 0x0000,
    0xF516, 0x0000, 0xBE23, 0x0000, 0xA709, 0x0000, 0xC278, 0x0000,
    0x0AF5, 0x0000, 0x3F21, 0x0000, 0x6120, 0x0000, 0x495E, 0x0000,
    0x03F2, 0x0000, 0xC4B3, 0x0000, 0xA6C1, 0x0000, 0xCE64, 0x0000,
    0x00A3, 0x0000, 0x479E, 0x0000, 0x5AFE, 0x0000, 0x3E3C, 0x0000,
    0x02BB, 0x0000, 0xCABC, 0x0000, 0xA433, 0x0000, 0xC907, 0x0000,
    0x05FB, 0x0000, 0x4446, 0x0000, 0x5A15, 0x0000, 0x37CE, 0x0000,
    0xF8EC, 0x0000, 0xBCC5, 0x0000, 0xA138, 0x0000, 0xB8F8, 0x0000,
    0xF93D, 0x0000, 0x44FE, 0x0000, 0x5501, 0x0000, 0x45D8, 0x0000,
    0x0407, 0x0000, 0xC384, 0x0000, 0xB075, 0x0000, 0xC8A4, 0x0000,
    0x0223, 0x0000, 0x3EFF, 0x0000, 0x5927, 0x0000, 0x36E6, 0x0000,
    0x07D2, 0x0000, 0xBD5B, 0x0000, 0x9F6B, 0x0000, 0xBFD8, 0x0000,
    0xFC5E, 0x0000, 0x3DD2, 0x0000, 0x5AB6, 0x0000, 0x45E0, 0x0000,
    0x0275, 0x0000, 0xBDFB, 0x0000, 0xA4C1, 0x0000, 0xC6B1, 0x0000,
    0xF9EF, 0x0000, 0x3D98, 0x0000, 0x4990, 0x0000, 0x4118, 0x0000,
    0xF920, 0x0000, 0xC08A, 0x0000, 0xA909, 0x0000, 0xBB55, 0x0000,
    0x07B9, 0x0000, 0x3C05, 0x0000, 0x6378, 0x0000, 0x4007, 0x0000,
    0xF97D, 0x0000, 0xC8B2, 0x0000, 0xA27F, 0x0000, 0xC60A, 0x0000,
    0xFAD3, 0x0000, 0x3BCD, 0x0000, 0x64D7, 0x0000, 0x3A06, 0x0000,
    0x02F5, 0x0000, 0xB8E1, 0x0000, 0xA31D, 0x0000, 0xC622, 0x0000,
    0xFDF2, 0x0000, 0x3751, 0x0000, 0x5A04, 0x0000, 0x4192, 0x0000,
    0xF755, 0x0000, 0xBF7E, 0x0000, 0xA114, 0x0000, 0xB791, 0x0000,
    0x02EE, 0x0000, 0x3E27, 0x0000, 0x5C26, 0x0000, 0x4606, 0x0000,
    0xFF8F, 0x0000, 0xC4B4, 0x0000, 0xAB0B, 0x0000, 0xC246, 0x0000,
    0x002E, 0x0000, 0x3713, 0x0000, 0x5EEA, 0x0000, 0x39FA, 0x0000,
    0x044B, 0x0000, 0xC179, 0x0000, 0xA970, 0x0000, 0xBB30, 0x0000,
    0xF842, 0x0000, 0x407E, 0x0000, 0x593E, 0x0000, 0x3AD8, 0x0000,
    0x0E98, 0x0000, 0xC5C5, 0x0000, 0xA962, 0x0000, 0xC7C7, 0x0000,
    0xFE94, 0x0000, 0x4468, 0x0000, 0x58B5, 0x0000, 0x3AD7, 0x0000,
    0x0513, 0x0000, 0xB783, 0x0000, 0x9E99, 0x0000, 0xB9E0, 0x0000,
    0xF8EF, 0x0000, 0x38A0, 0x0000, 0x6416, 0x0000, 0x422C, 0x0000,
    0xFB96, 0x0000, 0xC6A4, 0x0000, 0xA815, 0x0000, 0xBB8E, 0x0000,
    0xFDE8, 0x0000, 0x4679, 0x0000, 0x6A08, 0x0000, 0x3C7B, 0x0000,
    0xFBDD, 0x0000, 0xC3B7, 0x0000, 0xB39A, 0x0000, 0xC565, 0x0000,
    0xFFFD, 0x0000, 0x41E6, 0x0000, 0x5AB5, 0x0000, 0x42DD, 0x0000,
    0x030C, 0x0000, 0xBA82, 0x0000, 0xA43A, 0x0000, 0xC65C, 0x0000,
    0xF75F, 0x0000, 0x41C7, 0x0000, 0x5947, 0x0000, 0x4768, 0x0000,
    0xF4A0, 0x0000, 0xBF0F, 0x0000, 0xA83B, 0x0000, 0xC2FC, 0x0000,
    0xFE31, 0x0000, 0x3B59, 0x0000, 0x686C, 0x0000, 0x3F17, 0x0000,
    0x0D02, 0x0000, 0xBC0C, 0x0000, 0xACD7, 0x0000, 0xC581, 0x0000,
    0xFAE0, 0x0000, 0x3CA2, 0x0000, 0x59DB, 0x0000, 0x389E, 0x0000,
    0x0269, 0x0000, 0xC950, 0x0000, 0xA15C, 0x0000, 0xC44B, 0x0000,
    0xFA40, 0x0000, 0x3E23, 0x0000, 0x588E, 0x0000, 0x40EB, 0x0000,
    0xFD06, 0x0000, 0xBFAD, 0x0000, 0xA427, 0x0000, 0xBCCF, 0x0000,
    0xFEE2, 0x0000, 0x3F9E, 0x0000, 0x5BF2, 0x0000, 0x3CC7, 0x0000,
    0xF88D, 0x0000, 0xB911, 0x0000, 0xA5DB, 0x0000, 0xB71B, 0x0000,
    0x0643, 0x0000, 0x42F2, 0x0000, 0x59C2, 0x0000, 0x4618, 0x0000,
    0xFE9C, 0x0000, 0xC669, 0x0000, 0xA276, 0x0000, 0xBF72, 0x0000,
    0xFAAC, 0x0000, 0x3A93, 0x0000, 0x5492, 0x0000, 0x386C, 0x0000,
    0x0F72, 0x0000, 0xC209, 0x0000, 0x9EA9, 0x0000, 0xC7B8, 0x0000,
    0x0676, 0x0000, 0x3CA0, 0x0000, 0x5837, 0x0000, 0x4114, 0x0000,
    0xFEFA, 0x0000, 0xB8FE, 0x0000, 0x9D8A, 0x0000, 0xBE35, 0x0000,
    0x06BF, 0x0000, 0x3D06, 0x0000, 0x631D, 0x0000, 0x4856, 0x0000,
    0x0519, 0x0000, 0xBBB3, 0x0000, 0x9BE6, 0x0000, 0xAFC0, 0x0000,
    0x01DE, 0x0000, 0x3AC0, 0x0000, 0x5ECA, 0x0000, 0x4039, 0x0000,
    0xFC6A, 0x0000, 0xB348, 0x0000, 0xB1CB, 0x0000, 0xBE53, 0x0000,
    0x0158, 0x0000, 0x4409, 0x0000, 0x5340, 0x0000, 0x42F4, 0x0000,
    0x01FA, 0x0000, 0xC9F5, 0x0000, 0xA9A5, 0x0000, 0xB508, 0x0000,
    0xFFAB, 0x0000, 0x431D, 0x0000, 0x590F, 0x0000, 0x4D83, 0x0000,
    0x0201, 0x0000, 0xCD50, 0x0000, 0xA547, 0x0000, 0xBD33, 0x0000,
    0xFFEA, 0x0000, 0x3BC2, 0x0000, 0x54A8, 0x0000, 0x39DE, 0x0000,
    0xF8AE, 0x0000, 0xC0B0, 0x0000, 0xAC2D, 0x0000, 0xC16E, 0x0000,
    0x0562, 0x0000, 0x4103, 0x0000, 0x58EB, 0x0000, 0x3F3E, 0x0000,
    0xF78C, 0x0000, 0xBF14, 0x0000, 0xA693, 0x0000, 0xB13A, 0x0000,
    0xF941, 0x0000, 0x3541, 0x0000, 0x5BF8, 0x0000, 0x4158, 0x0000,
    0x01FC, 0x0000, 0xB4E0, 0x0000, 0xAC27, 0x0000, 0xC088, 0x0000,
    0x0CD3, 0x0000, 0x412B, 0x0000, 0x58E8, 0x0000, 0x4FF6, 0x0000,
    0xFED5, 0x0000, 0xC1BA, 0x0000, 0xA049, 0x0000, 0xC7F5, 0x0000,
    0x03D0, 0x0000, 0x49E8, 0x0000, 0x5403, 0x0000, 0x3DD2, 0x0000,
    0x0529, 0x0000, 0xBCAE, 0x0000, 0x9F49, 0x0000, 0xCB10, 0x0000,
    0xFE65, 0x0000, 0x4536, 0x0000, 0x5690, 0x0000, 0x368B, 0x0000,
    0x012F, 0x0000, 0xC292, 0x0000, 0xAACC, 0x0000, 0xC214, 0x0000,
    0xFED7, 0x0000, 0x3B46, 0x0000, 0x5386, 0x0000, 0x37E3, 0x0000,
    0x03FB, 0x0000, 0xC571, 0x0000, 0xB21C, 0x0000, 0xC22B, 0x0000,
    0x04B8, 0x0000, 0x45CB, 0x0000, 0x4C04, 0x0000, 0x4414, 0x0000,
    0xFEE4, 0x0000, 0xC323, 0x0000, 0xA67D, 0x0000, 0xBDAF, 0x0000,
    0xFE5B, 0x0000, 0x3928, 0x0000, 0x49F9, 0x0000, 0x4982, 0x0000,
    0x076F, 0x0000, 0xC0E0, 0x0000, 0xA592, 0x0000, 0xC8B2, 0x0000,
    0xFAF4, 0x0000, 0x36F9, 0x0000, 0x5DFD, 0x0000, 0x3DE1, 0x0000,
    0xF957, 0x0000, 0xB23F, 0x0000, 0xA29C, 0x0000, 0xC2B7, 0x0000,
    0xFA84, 0x0000, 0x409B, 0x0000, 0x5FEA, 0x0000, 0x3D8E, 0x0000,
    0xFD1A, 0x0000, 0xB590, 0x0000, 0xA7BE, 0x0000, 0xBA4D, 0x0000,
    0x0BF4, 0x0000, 0x38DE, 0x0000, 0x5A62, 0x0000, 0x3F24, 0x0000,
    0xFE5A, 0x0000, 0xBF2B, 0x0000, 0xA423, 0x0000, 0xC263, 0x0000,
    0xFD86, 0x0000, 0x4ADE, 0x0000, 0x536D, 0x0000, 0x3D0B, 0x0000,
    0xF5A4, 0x0000, 0xBDA7, 0x0000, 0x9C74, 0x0000, 0xC4EC, 0x0000,
    0x0214, 0x0000, 0x3D08, 0x0000, 0x5C51, 0x0000, 0x3F44, 0x0000,
    0xFF84, 0x0000, 0xBF5E, 0x0000, 0xA4B8, 0x0000, 0xC7C9, 0x0000,
    0x07CF, 0x0000, 0x3F2A, 0x0000, 0x53C3, 0x0000, 0x4132, 0x0000,
    0x08F3, 0x0000, 0xBDB8, 0x0000, 0xA23D, 0x0000, 0xB919, 0x0000,
    0x02E4, 0x0000, 0x407D, 0x0000, 0x5114, 0x0000, 0x4226, 0x0000,
    0xF973, 0x0000, 0xB6C1, 0x0000, 0xAF58, 0x0000, 0xBC90, 0x0000,
    0x0369, 0x0000, 0x4525, 0x0000, 0x5BFA, 0x0000, 0x3D7E, 0x0000,
    0x01B2, 0x0000, 0xC3EB, 0x0000, 0xA852, 0x0000, 0xC324, 0x0000,
    0x0100, 0x0000, 0x3E8A, 0x0000, 0x65AA, 0x0000, 0x40DE, 0x0000,
    0x0447, 0x0000, 0xC143, 0x0000, 0xA994, 0x0000, 0xB20F, 0x0000,
    0xFBBB, 0x0000, 0x38DE, 0x0000, 0x6743, 0x0000, 0x4205, 0x0000,
    0xFFD6, 0x0000, 0xB803, 0x0000, 0x9E4F, 0x0000, 0xBF4E, 0x0000,
    0x0445, 0x0000, 0x3DFC, 0x0000, 0x5B67, 0x0000, 0x3E38, 0x0000,
    0x032A, 0x0000, 0xC459, 0x0000, 0xA3DD, 0x0000, 0xC6B8, 0x0000,
    0x0A74, 0x0000, 0x4056, 0x0000, 0x5E61, 0x0000, 0x36A9, 0x0000,
    0x006B, 0x0000, 0xCDF3, 0x0000, 0x9E1D, 0x0000, 0xC19F, 0x0000,
    0x0573, 0x0000, 0x49C7, 0x0000, 0x5FAF, 0x0000, 0x4548, 0x0000,
    0x0926, 0x0000, 0xBB3E, 0x0000, 0x9F55, 0x0000, 0xC131, 0x0000,
    0xFEDD, 0x0000, 0x441B, 0x0000, 0x514F, 0x0000, 0x3A2D, 0x0000,
    0x054F, 0x0000, 0xB456, 0x0000, 0xABB8, 0x0000, 0xB79A, 0x0000,
    0x021B, 0x0000, 0x3E55, 0x0000, 0x5805, 0x0000, 0x46D8, 0x0000,
    0x01B5, 0x0000, 0xC8DB, 0x0000, 0xA7E7, 0x0000, 0xBFA8, 0x0000,
    0x002A, 0x0000, 0x3B8E, 0x0000, 0x5415, 0x0000, 0x45D0, 0x0000,
    0x0708, 0x0000, 0xBA56, 0x0000, 0xACCF, 0x0000, 0xC391, 0x0000,
    0xFA98, 0x0000, 0x38FA, 0x0000, 0x5CAC, 0x0000, 0x40FE, 0x0000,
    0xF09D, 0x0000, 0xCAEE, 0x0000, 0xAC8B, 0x0000, 0xBDF6, 0x0000,
    0xFF8B, 0x0000, 0x459B, 0x0000, 0x58A2, 0x0000, 0x377A, 0x0000,
    0x0696, 0x0000, 0xC173, 0x0000, 0x94DD, 0x0000, 0xC1BB, 0x0000,
    0x0309, 0x0000, 0x3FD8, 0x0000, 0x5254, 0x0000, 0x3815, 0x0000,
    0xFB74, 0x0000, 0xB890, 0x0000, 0xA542, 0x0000, 0xBE9E, 0x0000,
    0x0071, 0x0000, 0x42A3, 0x0000, 0x5FF5, 0x0000, 0x4612, 0x0000,
    0x061B, 0x0000, 0xC494, 0x0000, 0xAD30, 0x0000, 0xBF7D, 0x0000,
    0x0D56, 0x0000, 0x386B, 0x0000, 0x5D57, 0x0000, 0x4114, 0x0000,
    0x0318, 0x0000, 0xC976, 0x0000, 0xB0EF, 0x0000, 0xB592, 0x0000,
    0x0890, 0x0000, 0x3852, 0x0000, 0x5DB6, 0x0000, 0x4315, 0x0000,
    0x02B7, 0x0000, 0xCA75, 0x0000, 0xA821, 0x0000, 0xC3DF, 0x0000,
    0xFB18, 0x0000, 0x4CFD, 0x0000, 0x5F26, 0x0000, 0x440A, 0x0000,
    0xFD84, 0x0000, 0xB80A, 0x0000, 0xAEB6, 0x0000, 0xBD64, 0x0000,
    0xF8DD, 0x0000, 0x3D12, 0x0000, 0x594D, 0x0000, 0x3C8D, 0x0000,
    0xF76F, 0x0000, 0xC038, 0x0000, 0xA2B6, 0x0000, 0xC535, 0x0000,
    0xFA85, 0x0000, 0x41DB, 0x0000, 0x56B9, 0x0000, 0x3B3E, 0x0000,
    0xFEE0, 0x0000, 0xC302, 0x0000, 0xADFA, 0x0000, 0xC0C5, 0x0000,
    0x0419, 0x0000, 0x395A, 0x0000, 0x58B8, 0x0000, 0x3BEE, 0x0000,
    0x04E2, 0x0000, 0xCE1F, 0x0000, 0xA410, 0x0000, 0xB881, 0x0000,
    0xFADA, 0x0000, 0x3998, 0x0000, 0x5D2E, 0x0000, 0x4069, 0x0000,
    0xF7C5, 0x0000, 0xB6F3, 0x0000, 0xAC2E, 0x0000, 0xC1A6, 0x0000,
    0x0577, 0x0000, 0x4214, 0x0000, 0x6409, 0x0000, 0x4CCE, 0x0000,
    0xF635, 0x0000, 0xC667, 0x0000, 0xA5C3, 0x0000, 0xC51E, 0x0000,
    0xF94F, 0x0000, 0x48C6, 0x0000, 0x52E9, 0x0000, 0x4E7D, 0x0000,
    0xFA0E, 0x0000, 0xCA08, 0x0000, 0xAB13, 0x0000, 0xB9C4, 0x0000,
    0xFA24, 0x0000, 0x3FEE, 0x0000, 0x532B, 0x0000, 0x3A61, 0x0000,
    0xFB96, 0x0000, 0xBF2D, 0x0000, 0xA910, 0x0000, 0xC4B1, 0x0000,
    0xF4A6, 0x0000, 0x323A, 0x0000, 0x56EF, 0x0000, 0x3FBF, 0x0000,
    0xF963, 0x0000, 0xC33B, 0x0000, 0xA8AB, 0x0000, 0xB72E, 0x0000,
    0x04BA, 0x0000, 0x39BA, 0x0000, 0x54C1, 0x0000, 0x39A4, 0x0000,
    0xFB61, 0x0000, 0xC19D, 0x0000, 0xA780, 0x0000, 0xC455, 0x0000,
    0xFF47, 0x0000, 0x34EB, 0x0000, 0x5E27, 0x0000, 0x4CFF, 0x0000,
    0x0194, 0x0000, 0xBD7E, 0x0000, 0xA6A9, 0x0000, 0xBC22, 0x0000,
    0xFD4A, 0x0000, 0x4316, 0x0000, 0x5C1B, 0x0000, 0x399A, 0x0000,
    0x0078, 0x0000, 0xC1D1, 0x0000, 0xA6DB, 0x0000, 0xC91F, 0x0000,
    0xF8FA, 0x0000, 0x3796, 0x0000, 0x55C6, 0x0000, 0x31F0, 0x0000,
    0x0662, 0x0000, 0xBA4B, 0x0000, 0xA7A1, 0x0000, 0xC082, 0x0000,
    0xFD11, 0x0000, 0x41F0, 0x0000, 0x5F18, 0x0000, 0x3835, 0x0000,
    0x056F, 0x0000, 0xC460, 0x0000, 0xB5F9, 0x0000, 0xB993, 0x0000,
    0x0CFA, 0x0000, 0x4A64, 0x0000, 0x65B9, 0x0000, 0x301C, 0x0000,
    0xF7D2, 0x0000, 0xBE8C, 0x0000, 0x9EB1, 0x0000, 0xC0F3, 0x0000,
    0x0924, 0x0000, 0x42CB, 0x0000, 0x54DB, 0x0000, 0x468E, 0x0000,
    0x0629, 0x0000, 0xBE4D, 0x0000, 0x9DC8, 0x0000, 0xB900, 0x0000,
    0x0C43, 0x0000, 0x3AD0, 0x0000, 0x5F1E, 0x0000, 0x4122, 0x0000,
    0x035A, 0x0000, 0xC6DB, 0x0000, 0xA29B, 0x0000, 0xC0F2, 0x0000,
    0x0DB5, 0x0000, 0x3DDE, 0x0000, 0x4F47, 0x0000, 0x3888, 0x0000,
    0xF96C, 0x0000, 0xC4BC, 0x0000, 0xAAD5, 0x0000, 0xC6E5, 0x0000,
    0xFE87, 0x0000, 0x41B5, 0x0000, 0x5F27, 0x0000, 0x3607, 0x0000,
    0xF880, 0x0000, 0xBAAE, 0x0000, 0xB08F, 0x0000, 0xC0FF, 0x0000,
    0x0192, 0x0000, 0x4116, 0x0000, 0x5E9B, 0x0000, 0x3C85, 0x0000,
    0xF919, 0x0000, 0xBA8A, 0x0000, 0xA62A, 0x0000, 0xC3B4, 0x0000,
    0xF7B3, 0x0000, 0x41E5, 0x0000, 0x5FF2, 0x0000, 0x35EE, 0x0000,
    0xF436, 0x0000, 0xBE98, 0x0000, 0x9D62, 0x0000, 0xC570, 0x0000,
    0x0092, 0x0000, 0x35C6, 0x0000, 0x5B4E, 0x0000, 0x3F8C, 0x0000,
    0xFE2A, 0x0000, 0xC2E9, 0x0000, 0x9D89, 0x0000, 0xC4EC, 0x0000,
    0xFE8A, 0x0000, 0x3EF6, 0x0000, 0x531C, 0x0000, 0x3F45, 0x0000,
    0x01BC, 0x0000, 0xBD7A, 0x0000, 0xA6C2, 0x0000, 0xCA09, 0x0000,
    0xFE66, 0x0000, 0x433F, 0x0000, 0x5D23, 0x0000, 0x3E87, 0x0000,
    0xF338, 0x0000, 0xB767, 0x0000, 0xA5C6, 0x0000, 0xC14A, 0x0000,
    0xF486, 0x0000, 0x3708, 0x0000, 0x5724, 0x0000, 0x45D1, 0x0000,
    0xF712, 0x0000, 0xC030, 0x0000, 0xAB3F, 0x0000, 0xBE63, 0x0000,
    0xFD79, 0x0000, 0x40AD, 0x0000, 0x573D, 0x0000, 0x4136, 0x0000,
    0x0A75, 0x0000, 0xC4A1, 0x0000, 0xA37A, 0x0000, 0xC3EC, 0x0000,
    0x00BB, 0x0000, 0x4969, 0x0000, 0x5469, 0x0000, 0x3345, 0x0000,
    0xFEF8, 0x0000, 0xBFEF, 0x0000, 0xAB2C, 0x0000, 0xB432, 0x0000,
    0xFD81, 0x0000, 0x44AB, 0x0000, 0x5AC7, 0x0000, 0x3A60, 0x0000,
    0x00D5, 0x0000, 0xB817, 0x0000, 0xA06B, 0x0000, 0xBE8F, 0x0000,
    0x0A2B, 0x0000, 0x49AF, 0x0000, 0x6361, 0x0000, 0x3B90, 0x0000,
    0xF60E, 0x0000, 0xC2B9, 0x0000, 0x9ED6, 0x0000, 0xC204, 0x0000,
    0x0071, 0x0000, 0x3807, 0x0000, 0x5860, 0x0000, 0x3BF1, 0x0000,
    0x07C5, 0x0000, 0xC0AF, 0x0000, 0x9F5F, 0x0000, 0xC300, 0x0000,
    0x00B2, 0x0000, 0x3B8A, 0x0000, 0x5C09, 0x0000, 0x3FA1, 0x0000,
    0x02E3, 0x0000, 0xC49F, 0x0000, 0xA718, 0x0000, 0xBED6, 0x0000,
    0xF698, 0x0000, 0x2E2B, 0x0000, 0x58B1, 0x0000, 0x4758, 0x0000,
    0xFB86, 0x0000, 0xBB2D, 0x0000, 0xA442, 0x0000, 0xC14C, 0x0000,
    0x03FD, 0x0000, 0x365E, 0x0000, 0x5B6C, 0x0000, 0x3D76, 0x0000,
    0x0374, 0x0000, 0xC409, 0x0000, 0x9A69, 0x0000, 0xB39C, 0x0000,
    0xF9D5, 0x0000, 0x3ADA, 0x0000, 0x6243, 0x0000, 0x3763, 0x0000,
    0x0319, 0x0000, 0xC27D, 0x0000, 0xAE2F, 0x0000, 0xC55C, 0x0000,
    0xFE68, 0x0000, 0x44F3, 0x0000, 0x5929, 0x0000, 0x2DBE, 0x0000,
    0x00ED, 0x0000, 0xBEF8, 0x0000, 0xA85F, 0x0000, 0xC270, 0x0000,
    0xFEE0, 0x0000, 0x4946, 0x0000, 0x55AC, 0x0000, 0x3A24, 0x0000,
    0x0083, 0x0000, 0xC5E4, 0x0000, 0xA9DE, 0x0000, 0xBED0, 0x0000,
    0xF771, 0x0000, 0x3DDD, 0x0000, 0x5D49, 0x0000, 0x3C13, 0x0000,
    0xF0C9, 0x0000, 0xC1A9, 0x0000, 0xA35D, 0x0000, 0xBAFB, 0x0000,
    0xFAD3, 0x0000, 0x3A4C, 0x0000, 0x5E2D, 0x0000, 0x4326, 0x0000,
    0xF6E5, 0x0000, 0xBEAF, 0x0000, 0xAE51, 0x0000, 0xC9AF, 0x0000,
    0x033A, 0x0000, 0x4A59, 0x0000, 0x5F57, 0x0000, 0x39E4, 0x0000,
    0xFBF8, 0x0000, 0xD03F, 0x0000, 0xB2B6, 0x0000, 0xBC14, 0x0000,
    0x022A, 0x0000, 0x3CDD, 0x0000, 0x52A8, 0x0000, 0x39C8, 0x0000,
    0xFCCC, 0x0000, 0xBF00, 0x0000, 0xA3D2, 0x0000, 0xB3E1, 0x0000
    };

static const q15_t in_cifft_noisy_2048[4096] = {
    0xFFB0, 0x0000, 0xFFEB, 0x0032, 0x000A, 0xFFFA, 0xFFF1, 0xFFF3,
    0xFFFB, 0xFFFA, 0x0018, 0xFFE4, 0x002B, 0xFFF8, 0xFFFC, 0xFFDF,
    0x0006, 0x0000, 0xFFE3, 0xFFD8, 0x000A, 0x000E, 0x0007, 0xFFEF,
    0x0008, 0x0016, 0x0010, 0x0008, 0xFFF3, 0xFFEA, 0xFFF1, 0x0004,
    0x0002, 0x002A, 0xFFE6, 0xFFE1, 0xFFF2, 0xFFE7, 0x0032, 0x0029,
    0x0029, 0xFFFA, 0x003C, 0xFFF0, 0xFFD4, 0xFFFE, 0x000B, 0xFFF3,
    0xFFF1, 0x001C, 0xFFFC, 0x0001, 0xFFE7, 0x001E, 0x0003, 0xFFF6,
    0xFFE9, 0xFFF8, 0xFFFB, 0x000D, 0x0006, 0xFFE3, 0x0003, 0xFFF3,
    0xFFE9, 0x004F, 0x0003, 0x001C, 0x0017, 0x000F, 0x0007, 0xFFCF,
    0x000D, 0xFFFD, 0x0014, 0xFFFD, 0x000B, 0x0003, 0x0004, 0x000E,
    0xFFF3, 0x000F, 0x0013, 0xFFEB, 0xFFDD, 0xFFCA, 0x0015, 0x0022,
    0x0023, 0xFFEB, 0x0009, 0x002A, 0x001C, 0xFFC4, 0xFFCC, 0x001D,
    0xFFE0, 0xFFE3, 0xFFDB, 0x0006, 0x002C, 0x002A, 0x0005, 0xFFFD,
    0x0004, 0x0021, 0x0011, 0xFFF5, 0xFFF8, 0xFFF5, 0xFFE3, 0xFFFE,
    0xFFEC, 0x0002, 0x0020, 0x0017, 0xFFE0, 0xFFF7, 0xFFBF, 0x0003,
    0x0012, 0x000D, 0x001A, 0x000E, 0xFFE2, 0x0034, 0xFFBF, 0x0021,
    0x0009, 0x001B, 0xFFEC, 0x0001, 0xFFF8, 0xFFD5, 0x0008, 0xFFF8,
    0x0005, 0x0008, 0xFFF8, 0xFFFA, 0x0027, 0x0020, 0xFFF8, 0xFFCC,
    0x0007, 0x0002, 0xFFF2, 0x0013, 0xFFE9, 0xFFDB, 0xFFE3, 0xFFC9,
    0x000A, 0x0032, 0x0001, 0x0001, 0xFFF3, 0x0006, 0xFFDD, 0xFFF3,
    0xFFF3, 0xFFF4, 0x0002, 0x0008, 0xFFF6, 0xFFB3, 0xFFC2, 0xFFE6,
    0xFFB9, 0x000F, 0x0039, 0xFFFA, 0xFFF5, 0x0017, 0x0004, 0xFFEA,
    0x0010, 0x000F, 0x0011, 0xFFF2, 0xFFEF, 0x0007, 0x0026, 0x0030,
    0xFFF8, 0x0022, 0xFFE6, 0xFFF5, 0x001B, 0xFFE7, 0x0007, 0xFFC0,
    0x0007, 0xFFDF, 0xFFF9, 0xFFC9, 0xFFF5, 0x0004, 0xFFF9, 0x000B,
    0x0015, 0xFFEE, 0xFFD0, 0xFFB8, 0xFFD7, 0xFFC0, 0x001B, 0x0009,
    0x0003, 0x0013, 0xFFFD, 0xFFF1, 0x0010, 0xFFD5, 0xFFE1, 0xFFFD,
    0x0017, 0xFFFE, 0x0022, 0x000B, 0xFFEE, 0x000F, 0xFFEE, 0x0004,
    0xFFF2, 0xFFEC, 0xFFF4, 0x0005, 0x000C, 0xFFDE, 0xFFE9, 0xFFFB,
    0x0004, 0xFFFE, 0xFFFF, 0xFFCC, 0xFFED, 0x001A, 0xFFE9, 0xFFDD,
    0x002A, 0x002D, 0x0004, 0xFFF8, 0x0028, 0xFFFF, 0x000A, 0xFFDA,
    0x0016, 0xFFCD, 0xFFF9, 0x0009, 0x0019, 0xFFF7, 0xFFF1, 0xFFF0,
    0x0001, 0x000B, 0x001E, 0x0011, 0xFFE2, 0x000A, 0x001F, 0xFFFA,
    0x0000, 0xFFF2, 0x0008, 0x0012, 0xFFF5, 0xFFFA, 0x0014, 0xFFFB,
    0x0026, 0x0027, 0xFFF2, 0xFFE3, 0x0008, 0xFFCA, 0xFFE0, 0x0013,
    0xFFE7, 0xFFEB, 0xFFED, 0x0038, 0xFFD2, 0xFFE8, 0xFFE8, 0xFFCB,
    0x0006, 0x000C, 0xFFD6, 0xFFEF, 0xFFF3, 0xFFE4, 0xFFF0, 0xFFFF,
    0xFFF0, 0x000A, 0x000F, 0x0012, 0xFFE8, 0xFFD1, 0xFFFA, 0x0002,
    0xFFFA, 0xFFF3, 0xFFF5, 0xFFEE, 0x000D, 0xFFDE, 0x000B, 0x0011,
    0xFFD7, 0x000E, 0x0002, 0x0011, 0xFFD7, 0x0020, 0xFFF7, 0x000F,
    0x0018, 0x0002, 0x003B, 0xFFF0, 0x0007, 0x0000, 0x0004, 0xFFF4,
    0xFFFE, 0xFFE6, 0x0026, 0x0007, 0xFFD7, 0x0046, 0x000F, 0xFFD7,
    0x0015, 0x003B, 0x0013, 0x0024, 0x0011, 0xFFF6, 0xFFD2, 0xFFF8,
    0x0023, 0x000B, 0xFFF8, 0x000A, 0xFFFD, 0xFFEE, 0x001A, 0xFFF3,
    0x000E, 0x000C, 0x000F, 0x0004, 0xFFF1, 0xFFF0, 0xFFFE, 0xFFF8,
    0xFFEA, 0xFFF7, 0x0006, 0xFFF9, 0xFFF2, 0xFFE9, 0xFFF6, 0x0017,
    0xFFE9, 0xFFCC, 0xFFFA, 0xFFF9, 0x0004, 0x0025, 0xFFE3, 0xFFD7,
    0xFFFE, 0x0011, 0xFFFC, 0xFFE5, 0xFFEB, 0xFFEB, 0xFFFB, 0xFFE1,
    0xFFE9, 0x000C, 0xFFE2, 0xFFEB, 0x0000, 0xFFFE, 0x0022, 0xFFE8,
    0xFFF0, 0x001B, 0x001F, 0xFFDC, 0x0027, 0x002F, 0x0007, 0x0017,
    0x000E, 0x0026, 0xFFE4, 0x0019, 0xFFD8, 0x0009, 0xFFC9, 0x0001,
    0x0029, 0xFFE4, 0x000D, 0xFFF3, 0x0024, 0x001E, 0xFFFB, 0xFFE1,
    0xFFFC, 0x000D, 0xFFFF, 0x000B, 0x001D, 0x000E, 0xFFDB, 0xFFF9,
    0x0028, 0x0020, 0xFFD6, 0xFFEF, 0x0024, 0xFFD6, 0x000D, 0xFFFD,
    0x000A, 0x0006, 0x000C, 0x0018, 0xFFF2, 0xFFFF, 0x0016, 0x000D,
    0x0010, 0x0015, 0x0005, 0xFFFA, 0xFFE6, 0xFFFC, 0xFFF4, 0x0029,
    0xFFDA, 0x0013, 0xFFE6, 0xFFE9, 0x000E, 0xFFE1, 0xFFF0, 0x0006,
    0xFFE3, 0xFFE8, 0xFFDF, 0x0015, 0xFFEF, 0x0014, 0x0004, 0x002A,
    0x0014, 0xFFFB, 0x000B, 0xFFEF, 0x001B, 0x0017, 0x0021, 0xFFE7,
    0x001C, 0xFFF5, 0x0012, 0xFFEA, 0x000F, 0x0000, 0x0013, 0xFFEF,
    0xFFF7, 0xFFFF, 0xFFFE, 0x0007, 0x0005, 0xFFCF, 0x0028, 0xFFF1,
    0xFFFC, 0x0009, 0xFFEE, 0x0017, 0xFFFA, 0x0011, 0x001B, 0x001C,
    0x0003, 0x003F, 0x0001, 0x002D, 0xFFF5, 0xFFDC, 0xFFF8, 0xFFE9,
    0x001A, 0xFFEF, 0x0008, 0xFFDD, 0x0004, 0xFFD2, 0xFFCE, 0x0018,
    0x0009, 0xD32B, 0xFFF9, 0x0013, 0xFFF1, 0x0040, 0xFFFF, 0x0020,
    0x0028, 0x001B, 0x000E, 0xFFFF, 0x0015, 0x001D, 0xFFEE, 0xFFAB,
    0xFFE6, 0x0026, 0xFFE8, 0xFFF6, 0x0010, 0xFFFB, 0x0017, 0xFFF5,
    0xFFE8, 0x001C, 0x0036, 0x0029, 0xFFFE, 0xFFE6, 0x0001, 0x0000,
    0xFFF5, 0x0014, 0xFFCF, 0xFFFA, 0xFFF4, 0x0017, 0x000F, 0x000E,
    0xFFF1, 0xFFFC, 0x0009, 0x0008, 0x000D, 0xFFFD, 0x0008, 0x002B,
    0x0004, 0x001A, 0xFFFB, 0xFFFF, 0x000E, 0x001E, 0x0005, 0x0006,
    0x0007, 0x0034, 0xFFF9, 0xFFE4, 0xFFFC, 0xFFE1, 0x001A, 0x0001,
    0xFFF8, 0x0033, 0xFFDC, 0xFFDF, 0xFFFA, 0xFFF2, 0xFFF8, 0x0010,
    0x001B, 0x0011, 0xFFE0, 0xFFF8, 0x000D, 0xFFDF, 0x000D, 0xFFED,
    0x0020, 0x0013, 0xFFFC, 0xFFE3, 0x0000, 0xFFF3, 0x0024, 0x0012,
    0x0008, 0xFFF4, 0xFFFA, 0xFFC4, 0x001C, 0x0027, 0x002D, 0x0005,
    0xFFE6, 0x000F, 0xFFF3, 0x0020, 0xFFEE, 0xFFFD, 0xFFEC, 0x0013,
    0x0018, 0xFFFA, 0xFFFA, 0x000E, 0x000C, 0x0009, 0x0020, 0x000E,
    0xFFDF, 0xFFF2, 0xFFCB, 0xFFFF, 0xFFFB, 0xFFDE, 0xFFEE, 0xFFD7,
    0xFFF6, 0x0004, 0xFFE3, 0x0027, 0x0012, 0xFFDB, 0xFFDB, 0xFFF7,
    0xFFEF, 0xFFFE, 0x000D, 0xFFD5, 0xFFF1, 0x0008, 0x000C, 0x0003,
    0xFFDF, 0xFFE8, 0x0004, 0xFFE4, 0xFFE1, 0x001D, 0xFFE5, 0xFFFC,
    0x0008, 0xFFDC, 0xFFE2, 0xFFE4, 0xFFED, 0x000C, 0xFFE1, 0x0001,
    0xFFE8, 0x0010, 0xFFEA, 0x000B, 0xFFE5, 0xFFE7, 0x0019, 0xFFFC,
    0x0010, 0x001D, 0x0026, 0x001D, 0x0008, 0xFFE5, 0xFFEC, 0xFFD0,
    0x0006, 0x0012, 0x000E, 0xFFF6, 0xFFD4, 0xFFE6, 0xFFFC, 0xFFD5,
    0x002E, 0xFFD8, 0xFFFB, 0xFFE5, 0xFFFE, 0x000A, 0x001A, 0x0018,
    0xFFE1, 0xFFF7, 0x0005, 0x0012, 0xFFFE, 0x000C, 0x000E, 0x000B,
    0xFFC4, 0x0013, 0x0019, 0xFFFB, 0x001E, 0xFFFC, 0xFFF4, 0xFFF4,
    0xFFE2, 0xFFE0, 0xFFFD, 0x0032, 0x0017, 0xFFED, 0xFFF2, 0x000F,
    0xFFEF, 0xFFD9, 0x0001, 0x000F, 0xFFFD, 0xFFEB, 0xFFEA, 0x0003,
    0x002A, 0xFFDF, 0x002F, 0xFFF2, 0xFFF6, 0xFFF2, 0xFFE8, 0x001D,
    0x0020, 0x0018, 0xFFC3, 0x000C, 0x0005, 0x0012, 0x0000, 0xFFDE,
    0x0003, 0x001A, 0x000C, 0x0007, 0x0025, 0x0014, 0xFFF2, 0xFFFC,
    0x000E, 0xFFFA, 0xFFF3, 0xFFD3, 0xFFD7, 0xFFF0, 0x0013, 0x0016,
    0x0008, 0x000E, 0x0038, 0xFFFA, 0xFFDF, 0x0006, 0x0013, 0x001B,
    0x002F, 0xFFFE, 0x001B, 0xFFE3, 0x0022, 0xFFF9, 0x000D, 0x0007,
    0x0018, 0xFFF0, 0x0041, 0x0011, 0xFFF3, 0xFFE0, 0x000E, 0x0026,
    0x0010, 0xFFF9, 0xFFDF, 0x0001, 0xFFC7, 0xFFF6, 0xFFEA, 0x000A,
    0x000C, 0x0008, 0xFFF5, 0xFFEA, 0x0016, 0x000C, 0x0015, 0xFFE7,
    0xFFE4, 0x0014, 0x000D, 0xFFF1, 0x0005, 0xFFF4, 0x0007, 0xFFE1,
    0xFFBE, 0xFFE3, 0x000C, 0x0009, 0x0002, 0xFFF9, 0x0027, 0xFFEF,
    0x002B, 0xFFFD, 0xFFF6, 0x000E, 0x000B, 0x0001, 0xFFEC, 0x001C,
    0x0029, 0xFFE6, 0x001D, 0xFFF0, 0x0021, 0x0016, 0xFFF7, 0x000F,
    0x0000, 0xFFFD, 0x0015, 0x000E, 0x0002, 0x0036, 0x0023, 0xFFE5,
    0xFFE5, 0x0003, 0x0004, 0xFFE9, 0x0009, 0xFFEE, 0xFFD9, 0x0016,
    0x0017, 0x0010, 0x0001, 0x0003, 0xFFF4, 0xFFEF, 0x0015, 0x000F,
    0xFFDD, 0x000A, 0xFFF2, 0x0010, 0x000A, 0x0008, 0xFFCB, 0xFFE4,
    0xFFF7, 0x001D, 0xFFC9, 0x000E, 0xFFF0, 0xFFED, 0x0000, 0xFFEE,
    0x0009, 0xFFE0, 0x0020, 0xFFF4, 0xFFE9, 0xFFD0, 0xFFF6, 0x0017,
    0xFFCE, 0x0012, 0xFFFD, 0x002A, 0x0009, 0xFFF9, 0x003B, 0x0015,
    0x0026, 0xFFD9, 0xFFF4, 0x002D, 0xFFDE, 0x0002, 0x0033, 0x001E,
    0x0010, 0xFFFF, 0xFFDC, 0xFFE9, 0x0000, 0x0021, 0xFFE5, 0xFFF0,
    0x0020, 0xFFFE, 0xFFD8, 0xFFEE, 0xFFE3, 0xFFDC, 0xFFF6, 0x0006,
    0x001F, 0xFFFB, 0x0026, 0xFFE6, 0x0033, 0x0000, 0xFFFE, 0x0007,
    0xFFEF, 0x0012, 0xFFF0, 0xFFE5, 0x0007, 0x0007, 0xFFDC, 0xFFF7,
    0xFFCF, 0x0012, 0x0012, 0xFFE2, 0x0007, 0xFFF2, 0xFFFE, 0xFFF3,
    0xFFF3, 0xFFFA, 0x0007, 0x0011, 0x0025, 0xFFE8, 0x0025, 0xFFF7,
    0xFFFC, 0xFFFB, 0xFFF9, 0xFFEB, 0xFFF9, 0x0004, 0x0011, 0xFFFB,
    0x000B, 0xFFDB, 0x002C, 0xFFD9, 0x0003, 0x0035, 0xFFEF, 0xFFEE,
    0x000F, 0xFFFE, 0x0015, 0x0013, 0x0015, 0x0018, 0xFFF9, 0x0028,
    0x0004, 0xFFF0, 0xFFE9, 0x0030, 0x0014, 0x000E, 0xFFEA, 0x001E,
    0xFFFB, 0xFFD8, 0xFFED, 0xFFF1, 0xFFE8, 0x003B, 0x0025, 0xFFCB,
    0xFFFF, 0xFFF5, 0xFFFB, 0xFFED, 0xFFD2, 0x001F, 0x0027, 0x002A,
    0x0000, 0x0041, 0x0002, 0xFFFB, 0xFFE9, 0xFFFF, 0x000E, 0xFFE8,
    0xFFC2, 0xFFDD, 0xFFEE, 0xFFFB, 0x000E, 0x0013, 0xFFFF, 0x002D,
    0x001E, 0xFFE6, 0xFFE4, 0xFFFD, 0xFFF5, 0xFFDA, 0x0014, 0xFFD9,
    0xFFF5, 0xFFF4, 0xFFF1, 0x001A, 0xFFC8, 0xFFF0, 0xFFF2, 0x000D,
    0x000B, 0x0013, 0xFFF7, 0xFFD0, 0x0007, 0xFFF3, 0xFFF2, 0xFFDE,
    0x0033, 0xFFF1, 0xFFF2, 0xFFF2, 0xFFE9, 0xFFFC, 0x0002, 0xFFE7,
    0xFFF7, 0xFFFB, 0x0000, 0xFFFA, 0x000C, 0xFFBE, 0x0002, 0xFFF7,
    0x0006, 0x0010, 0xFFFF, 0xFFE5, 0xFFE0, 0x0013, 0xFFEE, 0xFFE8,
    0x0002, 0x0009, 0x0002, 0xFFF2, 0xFFF8, 0x000B, 0x002B, 0xFFB5,
    0x000C, 0xFFDB, 0x001D, 0xFFE4, 0x0009, 0xFFE0, 0xFFF3, 0xFFFB,
    0x0035, 0x0006, 0xFFD8, 0x0018, 0x0027, 0xFFEE, 0x0008, 0x000B,
    0xFFCE, 0xFFF6, 0xFFF1, 0x001B, 0x000A, 0xFFF5, 0x0026, 0x001E,
    0xFFF6, 0xFFED, 0x0002, 0x002A, 0xFFD9, 0xFFFC, 0xFFF3, 0x0011,
    0x0020, 0xFFF3, 0x0000, 0x0008, 0xFFE8, 0xFFF7, 0xFFE0, 0xFFBE,
    0x001D, 0xFFCE, 0x0058, 0xFFE0, 0x0000, 0xFFED, 0x0017, 0xFFE3,
    0x0006, 0x0035, 0x0015, 0xFFF7, 0xFFF7, 0x0007, 0xFFEF, 0xFFF4,
    0x002D, 0x0007, 0xFFFC, 0xFFED, 0x0009, 0xFFE5, 0xFFF9, 0x0005,
    0x0010, 0xFFCA, 0x0023, 0xFFFA, 0x0006, 0x0007, 0xFFF7, 0xFFFE,
    0xFFFF, 0x0010, 0x0032, 0xFFF5, 0xFFFB, 0x0011, 0x0014, 0x0029,
    0x000D, 0xFFEA, 0x0015, 0xFFFC, 0x0001, 0xFFDC, 0xFFD8, 0xFFFF,
    0x0022, 0xFFD5, 0xFFDD, 0x002E, 0xFFE8, 0x002B, 0xFFEC, 0x0002,
    0x0026, 0x0016, 0x001A, 0xFFE4, 0x002E, 0xFFDF, 0xFFF1, 0xFFF5,
    0xFFFF, 0x0032, 0x003B, 0xFFF0, 0x0005, 0xFFE4, 0xFFEA, 0x0005,
    0x0017, 0xFFE3, 0x0019, 0x0026, 0xFFF2, 0xFFEC, 0xFFE7, 0x0010,
    0x000F, 0xFFDA, 0x0001, 0xFFDB, 0x0006, 0xFFF0, 0x0003, 0xFFF4,
    0xFFCC, 0x0002, 0xFFE6, 0xFFE6, 0xFFF4, 0x0019, 0xFFF5, 0x0015,
    0xFFE1, 0x001B, 0x001F, 0x0011, 0xFFEC, 0xFFF4, 0x0005, 0xFFD2,
    0xFFF0, 0x0000, 0x0018, 0xFFFA, 0xFFEE, 0x0037, 0xFFF8, 0x0032,
    0xFFE6, 0xFFFF, 0x0004, 0xFFE8, 0x0011, 0xFFF5, 0x000F, 0xFFF2,
    0xFFFB, 0xFFDD, 0xFFF9, 0x001B, 0xFFFC, 0x0008, 0x0029, 0xFFF0,
    0x0003, 0x001A, 0xFFEC, 0xFFEA, 0xFFC0, 0x002A, 0xFFFA, 0x0013,
    0x0019, 0xFFF0, 0x0003, 0xFFFE, 0x000E, 0x000E, 0x0009, 0x0036,
    0xFFED, 0x000B, 0x0007, 0x0008, 0xFFFB, 0x0003, 0x0028, 0x0004,
    0xFFEF, 0x000E, 0x0006, 0xFFE0, 0xFFFC, 0xFFF7, 0xFFF6, 0xFFD4,
    0xFFDA, 0x0000, 0x0003, 0x0000, 0xFFE2, 0x000F, 0x0012, 0x0017,
    0xFFF2, 0x0006, 0xFFF3, 0xFFF4, 0xFFF7, 0xFFF9, 0xFFE6, 0xFFF9,
    0x0003, 0x0038, 0xFFC5, 0x0016, 0xFFE4, 0x0013, 0xFFF2, 0xFFC3,
    0xFFFD, 0x000E, 0xFFCB, 0xFFF9, 0x0013, 0x0031, 0x001D, 0xFFFB,
    0xFFE6, 0xFFFC, 0xFFF8, 0x0007, 0xFFFE, 0x0008, 0xFFF9, 0x0009,
    0xFFDD, 0xFFE9, 0x001A, 0x000F, 0x0019, 0xFFE1, 0x0006, 0xFFF2,
    0x001D, 0x0011, 0xFFFD, 0xFFEA, 0x0008, 0x0026, 0xFFF7, 0xFFE8,
    0xFFE8, 0xFFDE, 0xFFD8, 0x0026, 0x000D, 0x000D, 0xFFF4, 0x001B,
    0xFFF1, 0x0010, 0xFFDB, 0xFFE2, 0xFFF7, 0x0020, 0x000B, 0x0010,
    0x0002, 0xFFE5, 0x0018, 0x000C, 0x0012, 0xFFEE, 0x0024, 0xFFE9,
    0x0001, 0xFFFC, 0xFFFE, 0xFFF9, 0x0003, 0x000C, 0x0002, 0xFFF5,
    0x0006, 0xFFF0, 0xFFEC, 0x0012, 0x000E, 0xFFE8, 0xFFD5, 0x0016,
    0xFFF1, 0x0005, 0x0036, 0xFFFB, 0xFFF7, 0x0007, 0x0025, 0xFFF6,
    0x0016, 0xFFF1, 0xFFEF, 0xFFC6, 0x0006, 0x001F, 0x0023, 0x0002,
    0x000A, 0x000F, 0x0000, 0xFFDB, 0xFFD9, 0x000D, 0x0024, 0x0011,
    0x0022, 0xFFDC, 0x0001, 0xFFF6, 0xFFE2, 0xFFF8, 0x0003, 0xFFE2,
    0xFFE7, 0xFFF0, 0x0010, 0x0012, 0xFFD1, 0xFFEE, 0x0002, 0xFFD3,
    0xFFFA, 0x000A, 0x0011, 0x0040, 0x0004, 0x000D, 0x000C, 0x0018,
    0x0007, 0x000F, 0x0029, 0xFFDA, 0xFFD6, 0xFFFB, 0xFFE2, 0xFFED,
    0xFFF4, 0x000A, 0x0019, 0x0005, 0xFFEF, 0xFFF9, 0xFFFE, 0x0020,
    0x001A, 0xFFF5, 0x000E, 0xFFED, 0x0000, 0x0026, 0xFFDA, 0xFFCB,
    0x0005, 0xFFDD, 0xFFF5, 0x000D, 0xFFE9, 0x0001, 0xFFE4, 0x000B,
    0x0019, 0x001D, 0xFFCC, 0x000C, 0xFFE5, 0xFFD8, 0xFFFA, 0xFFE4,
    0xFFFC, 0x002A, 0x0019, 0xFFEC, 0x001B, 0x0004, 0xFFD1, 0xFFFE,
    0xFFF1, 0xFFFE, 0xFFB3, 0x001D, 0xFFE7, 0x0004, 0xFFFF, 0xFFFF,
    0x0021, 0xFFE9, 0xFFF4, 0x0009, 0xFFFE, 0xFFFB, 0x0014, 0xFFD3,
    0xFFE9, 0xFFD7, 0x0011, 0x000B, 0x0021, 0x0038, 0xFFFF, 0x0009,
    0x0004, 0x002B, 0xFFF0, 0x0015, 0x0023, 0x000F, 0x001D, 0xFFE5,
    0xFFE3, 0x000C, 0x001E, 0xFFFC, 0x0004, 0x000F, 0x0017, 0xFFF5,
    0xFFF7, 0x0014, 0xFFEB, 0xFFF9, 0xFFFA, 0xFFFE, 0x000B, 0x0012,
    0x000C, 0x000D, 0x0027, 0xFFE2, 0x002B, 0xFFE6, 0x0014, 0xFFF5,
    0xFFDC, 0xFFF7, 0x002C, 0xFFF9, 0xFFF5, 0x0005, 0x0002, 0x0018,
    0x000C, 0xFFE2, 0x0019, 0xFFE1, 0x001D, 0x002F, 0xFFFA, 0xFFF1,
    0x0016, 0xFFFE, 0x0005, 0x0004, 0xFFFC, 0x000E, 0x0017, 0xFFF4,
    0x0003, 0xFFF8, 0x000B, 0x0007, 0xFFE1, 0x0017, 0xFFE0, 0x000B,
    0xFFD1, 0xFFFF, 0x0014, 0x0010, 0xFFF9, 0x000E, 0x0020, 0xFFDD,
    0x001C, 0xFFFE, 0x000D, 0xFFF0, 0xFFE7, 0xFFEF, 0x0003, 0xFFF6,
    0xFFCF, 0x0003, 0xFFFE, 0xFFF1, 0xFFF1, 0x000D, 0xFFFC, 0x0004,
    0xFFE6, 0x001B, 0x0010, 0xFFE7, 0x000E, 0x0010, 0x0019, 0xFFF2,
    0x000B, 0xFFEE, 0xFFD8, 0xFFE4, 0x0029, 0x000F, 0x003E, 0x000E,
    0x001A, 0xFFE8, 0x000F, 0x0017, 0x0007, 0x0036, 0xFFED, 0xFFFB,
    0x0005, 0x0000, 0x0008, 0x0016, 0x0024, 0x0008, 0xFFEB, 0xFFF5,
    0xFFFD, 0xFFEA, 0x0028, 0xFFEA, 0x0002, 0x0034, 0xFFE8, 0x0017,
    0x0010, 0xFFFB, 0xFFD1, 0xFFF8, 0x001C, 0x000E, 0x0006, 0xFFDF,
    0xFFEF, 0x000D, 0xFFF9, 0xFFFC, 0xFFFB, 0xFFF3, 0x0004, 0xFFE5,
    0xFFE6, 0x0011, 0xFFCD, 0x0034, 0xFFF6, 0x0002, 0xFFA6, 0x002C,
    0x001A, 0xFFF0, 0xFFF2, 0x000D, 0x0037, 0x0023, 0xFFE2, 0x0018,
    0x0020, 0x000C, 0x001D, 0x0011, 0x001D, 0xFFE0, 0x0001, 0xFFFE,
    0x0006, 0xFFD8, 0xFFF7, 0x0019, 0xFFCF, 0x0012, 0x0030, 0x000C,
    0x0042, 0xFF98, 0x001E, 0xFFE5, 0x0002, 0xFFF2, 0x0000, 0xFFEF,
    0x0005, 0xFFFA, 0x0022, 0xFFF4, 0x0020, 0x0008, 0x001F, 0x000B,
    0xFFEE, 0xFFC2, 0x0038, 0x001D, 0xFFBE, 0x002D, 0x0014, 0xFFF8,
    0xFFFC, 0x0023, 0xFFD7, 0xFFE1, 0xFFF1, 0x000F, 0x0011, 0x0015,
    0xFFDA, 0x0018, 0x0000, 0x000B, 0x0002, 0x0009, 0x000D, 0xFFF2,
    0x0005, 0x0019, 0x0019, 0x0034, 0x0010, 0xFFF1, 0xFFF9, 0x000E,
    0xFFFB, 0xFFFC, 0x0027, 0xFFF2, 0x0028, 0xFFF6, 0xFFED, 0x000F,
    0xFFFB, 0xFFE9, 0x0002, 0x0025, 0x000D, 0xFFEF, 0x0010, 0x002D,
    0x001D, 0xFFE6, 0xFFFE, 0x0004, 0xFFF8, 0xFFFB, 0xFFF8, 0xFFE9,
    0x0000, 0xFFD7, 0x000D, 0x0007, 0xFFEC, 0xFFDD, 0x000B, 0x0009,
    0xFFEE, 0x001B, 0xFFF3, 0xFFE7, 0x0005, 0x0002, 0xFFF2, 0x0024,
    0xFFCD, 0x000C, 0x001C, 0xFFF4, 0x000B, 0xFFE5, 0x0021, 0x0017,
    0x0004, 0x0009, 0xFFF9, 0xFFF8, 0xFFF7, 0xFFED, 0xFFEF, 0x000F,
    0x000A, 0x000B, 0xFFF6, 0x0005, 0x0004, 0x000B, 0x0003, 0xFFEB,
    0xFFF1, 0xFFF4, 0x0007, 0xFFE8, 0x0016, 0x000C, 0x001A, 0x0007,
    0xFFF3, 0x001C, 0xFFE7, 0xFFD1, 0xFFD1, 0x0026, 0x0006, 0xFFF3,
    0x0015, 0xFFF3, 0x0014, 0x0001, 0x0008, 0x0022, 0xFFE6, 0xFFF1,
    0xFFE8, 0x0025, 0x000F, 0x0004, 0x0011, 0x0005, 0x001F, 0xFFC6,
    0xFFDB, 0xFFEA, 0x0007, 0x002B, 0x0001, 0x0023, 0x001B, 0xFFEF,
    0x0003, 0xFFDD, 0xFFF4, 0x001B, 0x001A, 0x0006, 0x001A, 0x0019,
    0x0022, 0xFFF7, 0x002C, 0x004F, 0xFFEE, 0xFFDE, 0xFFEB, 0xFFCD,
    0xFFF0, 0xFFE3, 0x0000, 0xFFDB, 0x0039, 0x0004, 0xFFE7, 0xFFD1,
    0xFFD2, 0xFFE2, 0x0008, 0xFFFF, 0xFFED, 0x000D, 0x000A, 0xFFF5,
    0xFFC8, 0x0006, 0x002B, 0x0034, 0xFFD6, 0xFFC0, 0x0015, 0x000D,
    0xFFF0, 0x0012, 0x0026, 0xFFEA, 0x0006, 0xFFDD, 0x0019, 0x0000,
    0xFFE3, 0xFFEC, 0xFFE0, 0xFFF1, 0x000A, 0xFFFC, 0xFFCF, 0x0037,
    0xFFD3, 0x0001, 0xFFFB, 0x0028, 0x0002, 0x0011, 0xFFFD, 0xFFEB,
    0xFFFA, 0x000A, 0xFFFF, 0xFFF2, 0x001C, 0x0013, 0x0003, 0x0015,
    0x0027, 0x002E, 0x000B, 0xFFF3, 0xFFFD, 0xFFD5, 0xFFFA, 0x0003,
    0xFFF5, 0x0001, 0x0029, 0x0000, 0x000A, 0xFFFF, 0xFFF5, 0x000F,
    0x000D, 0xFFF8, 0xFFFD, 0xFFFB, 0xFFFA, 0x001A, 0xFFF1, 0xFFEF,
    0x0010, 0x0025, 0xFFFC, 0x003F, 0x0017, 0xFFFB, 0x0013, 0xFFFC,
    0xFFEF, 0xFFEA, 0x0015, 0x0003, 0x0000, 0x001D, 0x000A, 0x0002,
    0x0005, 0xFFC7, 0x0014, 0x000E, 0xFFF3, 0x002B, 0xFFF9, 0xFFFF,
    0x0004, 0xFFE5, 0x0036, 0xFFF8, 0x000E, 0x0008, 0x0003, 0xFFE1,
    0xFFFA, 0xFFDA, 0x0006, 0x0022, 0xFFDE, 0x001B, 0xFFFA, 0x0008,
    0xFFE7, 0xFFE6, 0x000B, 0xFFEF, 0x0007, 0xFFFC, 0x000D, 0xFFF4,
    0x0040, 0x0023, 0x001A, 0x000E, 0xFFE5, 0xFFFB, 0x0011, 0xFFD3,
    0xFFDC, 0xFFD8, 0x0023, 0x0000, 0x002F, 0xFFEA, 0x000C, 0xFFEA,
    0xFFF1, 0x0018, 0x0006, 0xFFCC, 0x0009, 0xFFE2, 0x0009, 0x000F,
    0xFFFB, 0x0012, 0x0008, 0xFFE6, 0xFFE8, 0x000D, 0x000B, 0x0023,
    0xFFF3, 0xFFFE, 0xFFE4, 0x0007, 0xFFFE, 0x0005, 0xFFF4, 0x0011,
    0xFFFF, 0x002E, 0x001A, 0x000C, 0x0002, 0x0008, 0x001D, 0x0008,
    0x0009, 0x001C, 0x001F, 0x000D, 0xFFFE, 0x0003, 0x0029, 0xFFDE,
    0x001C, 0xFFEA, 0x001B, 0x0007, 0x000C, 0xFFF4, 0xFFF9, 0x0025,
    0xFFC6, 0xFFEF, 0xFFC5, 0x0010, 0x001F, 0xFFF3, 0xFFD0, 0xFFE8,
    0xFFFF, 0xFFF7, 0x001F, 0x0009, 0x0048, 0xFFD1, 0xFFF3, 0xFFDE,
    0xFFD5, 0x000A, 0xFFE3, 0xFFEE, 0xFFF2, 0x001F, 0x0023, 0x0009,
    0xFFF9, 0xFFDE, 0xFFEF, 0x0000, 0xFFE3, 0x000F, 0x0022, 0xFFFA,
    0x000E, 0x0000, 0x0022, 0x0006, 0xFFE3, 0xFFF1, 0xFFEF, 0x0000,
    0xFFF9, 0x0022, 0x0023, 0xFFF7, 0xFFF2, 0xFFE1, 0xFFE3, 0x0012,
    0xFFD5, 0xFFF6, 0xFFF3, 0x0022, 0x0048, 0x002F, 0x001F, 0xFFF7,
    0xFFFF, 0x0009, 0xFFD0, 0x0018, 0x001F, 0x000D, 0xFFC5, 0xFFF0,
    0xFFC6, 0x0011, 0xFFF9, 0xFFDB, 0x000C, 0x000C, 0x001B, 0xFFF9,
    0x001C, 0x0016, 0x0029, 0x0022, 0xFFFE, 0xFFFD, 0x001F, 0xFFF3,
    0x0009, 0xFFE4, 0x001D, 0xFFF8, 0x0002, 0xFFF8, 0x001A, 0xFFF4,
    0xFFFF, 0xFFD2, 0xFFF4, 0xFFEF, 0xFFFE, 0xFFFB, 0xFFE4, 0xFFF9,
    0xFFF3, 0x0002, 0x000B, 0xFFDD, 0xFFE8, 0xFFF3, 0x0008, 0x001A,
    0xFFFB, 0xFFEE, 0x0009, 0xFFF1, 0x0009, 0x001E, 0x0006, 0x0034,
    0xFFF1, 0xFFE8, 0x000C, 0x0016, 0x002F, 0x0016, 0x0023, 0x0000,
    0xFFDC, 0x0028, 0x0011, 0x002D, 0xFFE5, 0x0005, 0x001A, 0xFFF2,
    0x0040, 0xFFDD, 0x000D, 0x000C, 0x0007, 0x0004, 0x000B, 0x0011,
    0xFFE7, 0x001A, 0xFFFA, 0xFFF8, 0xFFDE, 0xFFE5, 0x0006, 0xFFDE,
    0xFFFA, 0x0026, 0x0003, 0x001F, 0x000E, 0xFFF8, 0x0036, 0x0008,
    0x0004, 0x001B, 0xFFF9, 0x0001, 0xFFF3, 0xFFD5, 0x0014, 0xFFF2,
    0x0005, 0x0039, 0x000A, 0xFFFE, 0x0000, 0xFFE3, 0x0015, 0xFFFD,
    0xFFEF, 0x0016, 0x0013, 0x0004, 0x0017, 0x0005, 0xFFFC, 0xFFC1,
    0x0010, 0xFFDB, 0xFFF1, 0x0011, 0xFFFA, 0xFFE6, 0xFFFD, 0x0005,
    0x000D, 0x0008, 0xFFF5, 0xFFF1, 0x000A, 0x0001, 0x0029, 0x0000,
    0xFFF5, 0xFFFF, 0xFFFA, 0xFFFD, 0xFFFD, 0x002B, 0x000B, 0x000D,
    0x0027, 0xFFD2, 0x0003, 0xFFEB, 0x001C, 0xFFED, 0xFFFF, 0x000E,
    0xFFFA, 0xFFF6, 0xFFFD, 0x0015, 0x0002, 0xFFEF, 0xFFFB, 0xFFD8,
    0xFFD3, 0xFFFF, 0xFFCF, 0xFFC9, 0x000A, 0x0004, 0xFFE0, 0x000F,
    0xFFE3, 0x0014, 0x0019, 0x0000, 0x0006, 0x0023, 0x0026, 0x0016,
    0xFFF0, 0xFFEE, 0x0015, 0xFFF3, 0xFFD6, 0x0040, 0x002B, 0xFFCC,
    0xFFC8, 0xFFFA, 0x000A, 0x000B, 0xFFED, 0xFFF3, 0x0008, 0x0001,
    0xFFD2, 0x001E, 0xFFE7, 0x002F, 0x0039, 0xFFFC, 0x0000, 0x0025,
    0xFFF0, 0x001D, 0xFFEB, 0x0033, 0xFFEE, 0x0022, 0x002C, 0xFFB1,
    0x0022, 0x0009, 0x001A, 0xFFE7, 0x001A, 0xFFFA, 0xFFF4, 0xFFE5,
    0x0003, 0x0023, 0x001B, 0x0011, 0x0001, 0xFFDD, 0x0007, 0xFFD5,
    0xFFDB, 0x0016, 0x001F, 0x003A, 0x0011, 0xFFFB, 0x000F, 0xFFFC,
    0xFFE8, 0xFFDB, 0xFFE6, 0x000F, 0x0008, 0xFFDE, 0x0014, 0xFFFF,
    0x0015, 0x000D, 0x0006, 0x000D, 0xFFD1, 0xFFDA, 0xFFE7, 0x002F,
    0xFFF3, 0xFFE4, 0x001A, 0xFFF9, 0x0016, 0xFFF4, 0x0007, 0x0018,
    0xFFF1, 0x000C, 0x0003, 0x0015, 0x0004, 0xFFF5, 0xFFF6, 0xFFFB,
    0x000A, 0xFFF5, 0xFFEF, 0xFFF1, 0xFFF7, 0x0013, 0xFFF9, 0x0008,
    0x0004, 0xFFF7, 0x0021, 0xFFE9, 0x000B, 0x001B, 0x001C, 0x000C,
    0xFFCD, 0xFFF4, 0xFFF2, 0xFFDC, 0x0005, 0xFFFE, 0xFFF3, 0x0019,
    0xFFEE, 0xFFE5, 0x000B, 0xFFF7, 0xFFEC, 0x0023, 0x000D, 0xFFF9,
    0x0000, 0x0029, 0xFFF8, 0x0017, 0xFFF8, 0x0005, 0xFFFE, 0xFFFC,
    0x001D, 0x001A, 0x0010, 0xFFD3, 0x000D, 0x0011, 0x0002, 0xFFDB,
    0xFFFB, 0x0017, 0xFFED, 0xFFF1, 0x0028, 0x000A, 0x0027, 0x000E,
    0xFFFB, 0x0004, 0xFFF9, 0xFFF2, 0x0010, 0x000F, 0x0019, 0xFFCC,
    0x0005, 0xFFE7, 0x000D, 0x000E, 0x0002, 0xFFF7, 0x0000, 0xFFF5,
    0xFFDA, 0xFFE8, 0x0011, 0xFFEB, 0xFFF1, 0xFFF1, 0xFFD7, 0x001F,
    0xFFFC, 0xFFDD, 0x0014, 0x0008, 0xFFBE, 0xFFD3, 0x0038, 0xFFE3,
    0xFFEE, 0x003E, 0x001F, 0xFFF5, 0x0020, 0xFFF8, 0x0022, 0x000C,
    0x0005, 0x0006, 0x0000, 0x0011, 0x0002, 0x000E, 0x001E, 0x001B,
    0x0042, 0x0068, 0x0030, 0xFFF4, 0xFFCF, 0xFFEE, 0xFFF7, 0xFFE7,
    0x0006, 0x0028, 0x0001, 0x0002, 0x001D, 0x0020, 0x001D, 0xFFEF,
    0x0020, 0xFFF4, 0xFFE2, 0xFFE8, 0x0037, 0xFFDD, 0xFFF2, 0xFFF3,
    0x001A, 0x0010, 0xFFA6, 0xFFD4, 0xFFF6, 0xFFFE, 0xFFCD, 0xFFCC,
    0xFFE6, 0xFFEF, 0x0004, 0x001B, 0xFFFB, 0x000D, 0xFFF9, 0x0004,
    0xFFEF, 0xFFF3, 0x0006, 0x0021, 0x001C, 0xFFF2, 0xFFD1, 0x0008,
    0x0010, 0x0005, 0xFFE8, 0xFFE9, 0x0002, 0xFFCC, 0x0028, 0x0016,
    0xFFFD, 0x0016, 0xFFEB, 0x000B, 0x0024, 0xFFF8, 0x0008, 0xFFEA,
    0x0005, 0x0000, 0xFFED, 0x0005, 0x0007, 0xFFCA, 0x000F, 0xFFE9,
    0x001A, 0x0018, 0x003E, 0xFFF2, 0x0029, 0xFFF1, 0xFFD8, 0x001C,
    0x000B, 0x0012, 0x0019, 0x000E, 0x000E, 0xFFF0, 0x0010, 0x0019,
    0xFFE6, 0xFFE5, 0xFFFC, 0xFFFC, 0xFFF1, 0xFFF3, 0xFFFE, 0x000F,
    0xFFCF, 0xFFFD, 0x0003, 0x000A, 0xFFE7, 0x0011, 0x000D, 0x0010,
    0x001C, 0x0002, 0x0020, 0x0023, 0xFFF9, 0xFFF2, 0x0014, 0xFFF0,
    0xFFD1, 0x0001, 0xFFE0, 0xFFF5, 0xFFE1, 0xFFE9, 0x000B, 0xFFF9,
    0x0003, 0x0008, 0x0017, 0x000C, 0xFFFC, 0xFFF2, 0x0005, 0xFFFC,
    0x0016, 0x0002, 0xFFFA, 0x000F, 0x001D, 0xFFD1, 0x0019, 0x001F,
    0x000C, 0x001E, 0x0002, 0xFFE8, 0xFFF5, 0xFFFB, 0x002C, 0x0007,
    0xFFDC, 0x0009, 0x0014, 0x000B, 0x002B, 0x001A, 0x0027, 0x001E,
    0x000C, 0xFFF3, 0x000B, 0xFFEE, 0xFFFA, 0x0002, 0xFFEB, 0x0007,
    0xFFF7, 0xFFEC, 0x0017, 0x000B, 0x0004, 0xFFF1, 0x001E, 0x0004,
    0xFFE3, 0xFFF4, 0x001D, 0x001B, 0x0023, 0xFFF1, 0xFFF0, 0xFFEB,
    0x0004, 0xFFD5, 0xFFFF, 0xFFF7, 0x0021, 0xFFC8, 0x0011, 0xFFF5,
    0xFFE9, 0x0029, 0x0014, 0x002D, 0xFFFE, 0x0005, 0xFFF4, 0xFFF7,
    0x0021, 0x0017, 0xFFFF, 0x0001, 0xFFE7, 0xFFFC, 0xFFB3, 0xFFE3,
    0xFFF1, 0x0002, 0xFFD1, 0x0002, 0x001B, 0xFFFC, 0x0019, 0x0014,
    0xFFFC, 0xFFD6, 0xFFFA, 0x001C, 0xFFE5, 0x0028, 0xFFCC, 0xFFF4,
    0x0019, 0xFFE3, 0xFFE4, 0xFFF5, 0xFFE9, 0xFFFF, 0xFFF5, 0xFFF3,
    0x0005, 0x0023, 0xFFDA, 0x0035, 0x0000, 0xFFDA, 0x000E, 0x0013,
    0x001A, 0x000B, 0xFFFE, 0xFFE0, 0xFFEF, 0x0007, 0x0019, 0xFFFB,
    0xFFF4, 0xFFF6, 0xFFE2, 0x0013, 0xFFD6, 0x0005, 0x0029, 0x0026,
    0x0007, 0xFFF1, 0x000C, 0xFFE8, 0x0004, 0xFFF3, 0x0011, 0xFFC0,
    0xFFFA, 0xFFF6, 0x0002, 0x002D, 0xFFD1, 0x0012, 0x0010, 0xFFEE,
    0xFFE7, 0x0010, 0x0003, 0x001E, 0xFFE2, 0x0008, 0x0001, 0x000A,
    0x0022, 0x0024, 0x0024, 0xFFEF, 0xFFD9, 0xFFF3, 0x0000, 0x0025,
    0x000A, 0xFFF1, 0x0023, 0xFFFE, 0x0006, 0xFFE1, 0xFFEF, 0x003A,
    0x0016, 0x000F, 0x0025, 0x000A, 0xFFF7, 0xFFF9, 0x0036, 0x0005,
    0xFFF1, 0xFFFB, 0xFFD5, 0xFFEA, 0x000E, 0x0018, 0xFFEC, 0xFFEE,
    0x0006, 0x0010, 0x0002, 0x000B, 0x0003, 0xFFF4, 0xFFFE, 0x0007,
    0x0001, 0x0004, 0x0024, 0x0017, 0x0012, 0x0012, 0x0018, 0xFFF4,
    0x0002, 0x001B, 0x000B, 0xFFF0, 0xFFF7, 0xFFE0, 0xFFDB, 0x001E,
    0xFFF1, 0xFFF0, 0xFFF4, 0xFFE5, 0x000D, 0xFFF3, 0xFFD8, 0xFFDA,
    0xFFE8, 0x0022, 0xFFF7, 0x0018, 0x0008, 0xFFDA, 0xFFFD, 0x0016,
    0x001D, 0xFFEF, 0x0006, 0x000E, 0x0019, 0x001F, 0x001A, 0xFFF1,
    0xFFDD, 0x0017, 0xFFF9, 0xFFF7, 0xFFFE, 0xFFF8, 0xFFF8, 0xFFF9,
    0xFFE6, 0x0004, 0x001D, 0x0005, 0x0013, 0xFFCF, 0xFFCB, 0x0007,
    0xFFFD, 0xFFF2, 0xFFF2, 0x003D, 0xFFE4, 0xFFED, 0xFFC5, 0xFFEA,
    0x0003, 0xFFC8, 0xFFE6, 0x0007, 0xFFF7, 0x0007, 0xFFF3, 0x000C,
    0xFFF2, 0xFFFA, 0x0012, 0xFFE9, 0xFFE2, 0xFFF1, 0x0003, 0x0000,
    0xFFDA, 0x0000, 0xFFF6, 0x002C, 0xFFFC, 0x0009, 0x0006, 0x0020,
    0xFFEF, 0xFFF2, 0x0028, 0xFFFC, 0xFFFB, 0xFFFD, 0x0007, 0xFFF8,
    0xFFED, 0xFFF5, 0x0009, 0xFFCA, 0x000E, 0xFFF2, 0x0003, 0x0002,
    0x0019, 0x0010, 0xFFFA, 0xFFED, 0xFFC0, 0xFFD6, 0xFFEC, 0x0016,
    0x0003, 0xFFE6, 0x0029, 0x0010, 0xFFFC, 0xFFF8, 0xFFF9, 0xFFE5,
    0xFFFB, 0x0023, 0x000F, 0x000E, 0x0011, 0x000B, 0x0004, 0x0018,
    0xFFE6, 0x0001, 0xFFF8, 0xFFCE, 0xFFEE, 0xFFC9, 0x0018, 0x0006,
    0xFFF0, 0x0000, 0x0005, 0x002E, 0xFFEC, 0x000C, 0x001F, 0xFFEF,
    0xFFE1, 0xFFE5, 0xFFF5, 0xFFEB, 0xFFF4, 0xFFE7, 0xFFE6, 0x001A,
    0xFFCC, 0xFFFE, 0x0003, 0x000C, 0x0006, 0x0010, 0x0001, 0x0025,
    0x000F, 0x0026, 0xFFE7, 0xFFF0, 0xFFF2, 0x0014, 0x0019, 0xFFDA,
    0x0017, 0x001D, 0xFFEA, 0xFFFB, 0x0005, 0x001C, 0x003B, 0x0010,
    0xFFFF, 0xFFCE, 0xFFF1, 0x000B, 0x002E, 0x0021, 0x001A, 0x001C,
    0x0026, 0xFFEA, 0xFFEC, 0xFFFE, 0xFFE8, 0xFFD5, 0xFFDD, 0xFFD2,
    0x0022, 0x002B, 0xFFD8, 0x0001, 0x0001, 0x0024, 0x0015, 0x0004,
    0x000D, 0x0016, 0x0014, 0xFFD7, 0xFFFB, 0xFFEF, 0x0032, 0x000B,
    0xFFFF, 0xFFF0, 0xFFF7, 0x0002, 0x0006, 0xFFF9, 0x0023, 0x0006,
    0x0010, 0x0036, 0xFFF9, 0xFFFB, 0x0009, 0x001B, 0xFFFC, 0x0013,
    0x002D, 0xFFF9, 0xFFEF, 0x000C, 0xFFF7, 0xFFF9, 0x0015, 0x0009,
    0x0006, 0xFFCB, 0x0017, 0x001D, 0x0000, 0x0013, 0x0058, 0x0020,
    0x001D, 0x0032, 0xFFE0, 0x0042, 0xFFE8, 0x0009, 0x0000, 0xFFF8,
    0x0020, 0x000D, 0xFFF3, 0xFFEF, 0xFFD9, 0x0004, 0x0002, 0xFFD6,
    0xFFF6, 0x0013, 0x0026, 0xFFE2, 0x000A, 0x000B, 0xFFF1, 0xFFE5,
    0xFFCE, 0x000A, 0x0008, 0xFFF5, 0x0027, 0x0012, 0xFFD8, 0xFFE8,
    0x0035, 0xFFFA, 0xFFF3, 0x0005, 0x0009, 0x0020, 0x001D, 0x001C,
    0x000C, 0x0025, 0x002B, 0x004B, 0xFFF8, 0xFFF5, 0x0002, 0x000E,
    0x0002, 0xFFF7, 0xFFEE, 0x0018, 0xFFE0, 0xFFED, 0xFFFF, 0x001B,
    0x0006, 0xFFF0, 0x0002, 0x0009, 0x000C, 0x0042, 0x0000, 0x0006,
    0xFFF7, 0x0005, 0x0002, 0x0019, 0xFFE9, 0x0004, 0xFFF2, 0x000E,
    0x0033, 0x000F, 0xFFF2, 0x0022, 0x0007, 0x000D, 0xFFF7, 0x0030,
    0x000B, 0xFFED, 0xFFF2, 0xFFF3, 0xFFC8, 0x0010, 0xFFF1, 0xFFE6,
    0xFFF5, 0x000C, 0x0014, 0x0027, 0xFFF5, 0x0026, 0xFFE4, 0x0003,
    0x001E, 0x001A, 0xFFFF, 0xFFD3, 0x000E, 0xFFED, 0xFFEE, 0x0005,
    0xFFC2, 0x0023, 0x000E, 0x0018, 0xFFE9, 0x0001, 0x0002, 0x0005,
    0x0000, 0xFFBF, 0x0027, 0xFFD6, 0xFFD2, 0xFFE1, 0xFFFB, 0x0013,
    0xFFFF, 0x000B, 0x0025, 0x0035, 0xFFE8, 0xFFC5, 0xFFED, 0x000F,
    0xFFFB, 0x0028, 0xFFEA, 0xFFE2, 0x0014, 0xFFF2, 0xFFE9, 0xFFD0,
    0x0004, 0x0010, 0xFFF9, 0xFFD8, 0x0015, 0xFFE8, 0x0015, 0xFFED,
    0x000F, 0x0002, 0xFFEF, 0x0012, 0x0003, 0xFFCB, 0x002C, 0x0027,
    0x000B, 0x0025, 0x0011, 0x0005, 0xFFF9, 0xFFFC, 0xFFF9, 0x0015,
    0xFFFC, 0x0005, 0x0025, 0x0009, 0x0025, 0x0018, 0x0007, 0xFFEF,
    0xFFF3, 0x0006, 0xFFFE, 0x000D, 0x0007, 0x000E, 0x0012, 0x001E,
    0xFFCF, 0xFFEE, 0xFFDC, 0x0009, 0x0007, 0xFFF9, 0xFFF0, 0x001B,
    0xFFEF, 0xFFEE, 0xFFFE, 0xFFF9, 0x0033, 0x0000, 0x0026, 0x001A,
    0x001F, 0x0005, 0xFFF6, 0xFFFA, 0xFFE3, 0x0024, 0xFFD8, 0x0012,
    0x0020, 0x0002, 0xFFE5, 0x0010, 0x0000, 0xFFDF, 0xFFDC, 0x0017,
    0x0010, 0x0001, 0x0033, 0xFFE2, 0xFFDE, 0xFFFE, 0xFFF4, 0xFFD3,
    0x0026, 0x0027, 0x003B, 0xFFEB, 0x0009, 0x0007, 0xFFFD, 0xFFD6,
    0xFFCE, 0xFFEE, 0xFFF6, 0xFFE9, 0xFFE9, 0x0030, 0x0020, 0x000C,
    0x0009, 0x0020, 0x0000, 0x0012, 0xFFF0, 0x0013, 0xFFC9, 0xFFF2,
    0xFFF7, 0xFFE3, 0xFFCB, 0x001C, 0x000A, 0xFFF8, 0xFFF2, 0xFFF0,
    0xFFDD, 0xFFF6, 0x0015, 0xFFF1, 0xFFF4, 0x0011, 0x0001, 0xFFFD,
    0x0017, 0xFFF0, 0xFFD9, 0xFFEA, 0x0009, 0x0012, 0x0004, 0x0017,
    0xFFE5, 0xFFFD, 0x0023, 0x001B, 0x0002, 0xFFCA, 0x0015, 0xFFF2,
    0x0000, 0x0003, 0xFFF7, 0xFFF1, 0x0021, 0xFFEA, 0x001D, 0x0010,
    0x0029, 0x001A, 0xFFEC, 0xFFE4, 0x000B, 0xFFFF, 0xFFF6, 0xFFF2,
    0x002B, 0x0003, 0x0027, 0x0011, 0x0002, 0x0007, 0x000C, 0xFFF7,
    0xFFBE, 0x001D, 0x0007, 0x001F, 0x0005, 0x000C, 0x000D, 0x000F,
    0xFFE4, 0xFFEC, 0x0015, 0x0019, 0x0016, 0xFFF4, 0xFFF5, 0x0016,
    0x000C, 0xFFF8, 0xFFEA, 0xFFF6, 0xFFC7, 0x000A, 0xFFDF, 0xFFFF,
    0x0010, 0x0007, 0x000E, 0xFFDA, 0xFFF3, 0x0020, 0x0041, 0xFFEF,
    0x0018, 0x0010, 0x000D, 0xFFF9, 0x0022, 0x0007, 0x001B, 0x001D,
    0x002F, 0x0002, 0x0013, 0xFFE5, 0xFFDF, 0xFFFA, 0x0038, 0x0006,
    0x0008, 0xFFF2, 0x0013, 0xFFEA, 0xFFD7, 0x0010, 0xFFF3, 0x002D,
    0x000E, 0x0006, 0xFFF2, 0x0004, 0x0025, 0xFFEC, 0x000C, 0xFFF9,
    0x0003, 0xFFE6, 0x0000, 0x0022, 0x0005, 0xFFEE, 0xFFC3, 0xFFF4,
    0x0020, 0xFFE8, 0xFFE8, 0xFFE3, 0xFFF6, 0x000E, 0x002F, 0x000E,
    0x002A, 0x0021, 0xFFEA, 0xFFFD, 0xFFFD, 0x0015, 0x0001, 0xFFF1,
    0xFFEF, 0x0027, 0xFFF2, 0xFFF1, 0x0017, 0x0013, 0xFFFD, 0xFFCE,
    0xFFE2, 0x0020, 0xFFF4, 0x000C, 0x001E, 0x0004, 0x0019, 0x0005,
    0xFFC4, 0xFFED, 0x000E, 0xFFF5, 0xFFFE, 0xFFF4, 0x0005, 0xFFEE,
    0xFFE1, 0x0009, 0x001A, 0xFFE8, 0xFFFE, 0xFFF6, 0xFFFB, 0x001B,
    0x002E, 0x0028, 0xFFFC, 0x002B, 0xFFD4, 0x001A, 0x000E, 0x000A,
    0x0006, 0xFFEE, 0xFFEC, 0x0030, 0x0008, 0x001B, 0x0026, 0xFFE3,
    0x0010, 0xFFE3, 0x0019, 0x0004, 0xFFE5, 0x0019, 0xFFEA, 0xFFF5,
    0xFFE8, 0xFFF0, 0xFFE1, 0xFFFF, 0xFFED, 0xFFF4, 0xFFE2, 0x001C,
    0x0008, 0x0024, 0xFFE5, 0x0004, 0xFFE1, 0xFFE3, 0x0004, 0x001C,
    0xFFDF, 0x0018, 0x000C, 0xFFFD, 0xFFF1, 0xFFF8, 0x000D, 0x002B,
    0xFFEF, 0x0002, 0xFFDB, 0x0009, 0x0012, 0x0025, 0xFFE3, 0xFFD9,
    0xFFF6, 0xFFFC, 0xFFEE, 0x0029, 0xFFFB, 0x0022, 0xFFCB, 0x0001,
    0xFFDF, 0x000E, 0x0020, 0xFFF2, 0x000C, 0xFFF7, 0xFFFA, 0xFFF2,
    0x0018, 0x0006, 0xFFEC, 0xFFED, 0xFFEE, 0x0003, 0xFFF3, 0xFFE0,
    0xFFE6, 0xFFF1, 0x002D, 0xFFFB, 0x001C, 0xFFD9, 0xFFFA, 0x003C,
    0x0008, 0x000C, 0x0024, 0xFFEE, 0x0000, 0x000D, 0xFFFC, 0x001D,
    0x0020, 0xFFED, 0x000D, 0x0013, 0x000D, 0x0021, 0xFFE0, 0x0008,
    0x001B, 0xFFEF, 0xFFF8, 0xFFF0, 0xFFFA, 0x000E, 0xFFDC, 0x0021,
    0xFFF8, 0xFFCD, 0x001A, 0xFFFF, 0xFFFC, 0x001F, 0xFFF9, 0x001C,
    0x0007, 0xFFCC, 0x0005, 0xFFFA, 0x000E, 0xFFE2, 0xFFFB, 0x0001,
    0x0004, 0xFFE6, 0x0008, 0xFFD5, 0x000D, 0x0003, 0x0009, 0xFFF8,
    0xFFF1, 0x0004, 0x000F, 0xFFF2, 0xFFF4, 0xFFE9, 0xFFCF, 0x0006,
    0xFFF5, 0xFFEC, 0x0001, 0x0000, 0xFFFE, 0x001A, 0x0036, 0xFFD7,
    0xFFE8, 0xFFE4, 0x0017, 0x000B, 0x0010, 0x0005, 0xFFE8, 0x000A,
    0xFFE6, 0xFFDA, 0xFFEE, 0x0055, 0x0015, 0xFFE3, 0x000E, 0x0001,
    0x0028, 0xFFE5, 0xFFFF, 0xFFE0, 0xFFF1, 0xFFC0, 0xFFF9, 0xFFED,
    0x0009, 0x2CD5, 0xFFCE, 0xFFE8, 0x0004, 0x002E, 0x0008, 0x0023,
    0x001A, 0x0011, 0xFFF8, 0x0017, 0xFFF5, 0x0024, 0x0001, 0xFFD3,
    0x0003, 0xFFC1, 0x001B, 0xFFE4, 0xFFFA, 0xFFEF, 0xFFEE, 0xFFE9,
    0xFFFC, 0xFFF7, 0x0028, 0x000F, 0x0005, 0x0031, 0xFFFE, 0xFFF9,
    0xFFF7, 0x0001, 0x0013, 0x0011, 0x000F, 0x0000, 0x0012, 0x0016,
    0x001C, 0x000B, 0x0021, 0x0019, 0x001B, 0xFFE9, 0x000B, 0x0011,
    0x0014, 0x0005, 0x0004, 0xFFD6, 0xFFEF, 0xFFEC, 0xFFDF, 0xFFEB,
    0xFFE3, 0x0018, 0xFFF0, 0xFFFA, 0x000E, 0x001F, 0xFFE6, 0x0017,
    0xFFDA, 0xFFED, 0xFFF4, 0xFFD7, 0xFFE6, 0x0004, 0x0005, 0x0006,
    0x0010, 0xFFEB, 0x0016, 0xFFF3, 0xFFF2, 0x0001, 0x000C, 0xFFE8,
    0x000A, 0xFFFA, 0x000D, 0x0003, 0x0024, 0x002A, 0xFFD6, 0x0011,
    0x0028, 0xFFE0, 0xFFDB, 0x0007, 0x001D, 0xFFF2, 0xFFFF, 0xFFF5,
    0xFFFC, 0xFFF3, 0xFFFB, 0x001F, 0x0024, 0xFFE2, 0x000D, 0x000D,
    0x0029, 0x001C, 0xFFC9, 0xFFFF, 0xFFD8, 0xFFF7, 0xFFE4, 0xFFE7,
    0x000E, 0xFFDA, 0x0007, 0xFFE9, 0x0027, 0xFFD1, 0x001F, 0x0024,
    0xFFF0, 0xFFE5, 0x0022, 0x0018, 0x0000, 0x0002, 0xFFE2, 0x0015,
    0xFFE9, 0xFFF4, 0xFFFB, 0x001F, 0xFFEB, 0x0015, 0xFFFC, 0x001B,
    0xFFFE, 0xFFEF, 0xFFE3, 0x0029, 0x0004, 0xFFDB, 0xFFFA, 0x0007,
    0xFFE9, 0x0034, 0xFFF6, 0xFFE9, 0xFFF2, 0x0017, 0x0006, 0x0007,
    0xFFEA, 0x0009, 0xFFFE, 0x0008, 0xFFF1, 0x0010, 0x000F, 0xFFFC,
    0x000E, 0xFFF4, 0x001A, 0x000D, 0xFFFD, 0x0012, 0xFFF8, 0xFFF6,
    0x0023, 0xFFF5, 0xFFD2, 0x0008, 0x0011, 0x000A, 0x0013, 0xFFDC,
    0x0015, 0xFFC5, 0x000F, 0x0029, 0xFFD7, 0xFFBA, 0x0026, 0xFFF9,
    0xFFFE, 0x001A, 0x0004, 0x000C, 0x0007, 0x0000, 0x003B, 0x0010,
    0x0018, 0xFFFE, 0xFFF7, 0xFFF1, 0xFFD7, 0xFFE0, 0x0002, 0xFFEF,
    0xFFD7, 0xFFF2, 0x000B, 0xFFEF, 0x000D, 0x0022, 0xFFF5, 0x0012,
    0xFFFA, 0x000D, 0xFFFA, 0xFFFE, 0xFFE8, 0x002F, 0x000F, 0xFFEE,
    0xFFF0, 0xFFF6, 0xFFF0, 0x0001, 0xFFF3, 0x001C, 0xFFD6, 0x0011,
    0x0006, 0xFFF4, 0xFFE8, 0x0035, 0xFFD2, 0x0018, 0xFFED, 0xFFC8,
    0xFFE7, 0x0015, 0xFFE0, 0xFFED, 0x0008, 0x0036, 0xFFF2, 0x001D,
    0x0026, 0xFFD9, 0x0014, 0x0005, 0xFFF5, 0x0006, 0x0008, 0xFFEE,
    0x0000, 0x000E, 0x001F, 0x0006, 0xFFE2, 0xFFF6, 0x001E, 0xFFEF,
    0x0001, 0xFFF5, 0xFFF1, 0x0010, 0x0019, 0x0009, 0xFFF9, 0xFFF7,
    0x0016, 0x0033, 0x000A, 0x0026, 0x0028, 0x0001, 0x0004, 0x0008,
    0x002A, 0xFFD3, 0xFFE9, 0x0023, 0xFFED, 0xFFE6, 0xFFFF, 0x0034,
    0x0004, 0x0002, 0xFFE9, 0x0005, 0x000C, 0x0022, 0xFFF4, 0xFFFB,
    0xFFF2, 0x0014, 0xFFEE, 0xFFFC, 0xFFEE, 0xFFF1, 0x0022, 0xFFF5,
    0x0017, 0x0002, 0xFFE1, 0x0003, 0x0010, 0x002B, 0xFFFD, 0x000F,
    0x0003, 0xFFED, 0x001B, 0xFFF7, 0xFFD7, 0x0040, 0xFFD0, 0x0048,
    0x0015, 0x0012, 0xFFF9, 0xFFF5, 0xFFF5, 0xFFFC, 0xFFF9, 0x0037,
    0x0007, 0x0021, 0x0007, 0x0040, 0x001B, 0x0019, 0xFFE6, 0x000B,
    0xFFF8, 0xFFDE, 0x0026, 0xFFD0, 0xFFEF, 0xFFF9, 0x0011, 0x000E,
    0x0010, 0xFFF1, 0x0004, 0x0016, 0xFFF5, 0xFFE9, 0x0039, 0x0006,
    0xFFB9, 0xFFF1, 0xFFC2, 0x001A, 0xFFF6, 0x004D, 0x0002, 0xFFF8,
    0xFFF3, 0x000C, 0xFFDD, 0x000D, 0xFFF3, 0xFFFA, 0x0001, 0xFFFF,
    0x000A, 0xFFCE, 0xFFE3, 0x0037, 0xFFE9, 0x0025, 0xFFF2, 0xFFED,
    0x0007, 0xFFFE, 0xFFF8, 0x0034, 0x0027, 0xFFE0, 0xFFF8, 0x0006,
    0x0005, 0xFFF8, 0x0008, 0x0008, 0xFFF8, 0x002B, 0xFFEC, 0xFFFF,
    0x0009, 0xFFE5, 0xFFBF, 0xFFDF, 0xFFE2, 0xFFCC, 0x001A, 0xFFF2,
    0x0012, 0xFFF3, 0xFFBF, 0xFFFD, 0xFFE0, 0x0009, 0x0020, 0xFFE9,
    0xFFEC, 0xFFFE, 0xFFE3, 0x0002, 0xFFF8, 0x000B, 0x0011, 0x000B,
    0x0004, 0xFFDF, 0x0005, 0x0003, 0x002C, 0xFFD6, 0xFFDB, 0xFFFA,
    0xFFE0, 0x001D, 0xFFCC, 0xFFE3, 0x001C, 0x003C, 0x0009, 0xFFD6,
    0x0023, 0x0015, 0x0015, 0xFFDE, 0xFFDD, 0x0036, 0x0013, 0x0015,
    0xFFF3, 0xFFF1, 0x0004, 0xFFF2, 0x000B, 0xFFFD, 0x0014, 0x0003,
    0x000D, 0x0003, 0x0007, 0x0031, 0x0017, 0xFFF1, 0x0003, 0xFFE4,
    0xFFE9, 0xFFB1, 0x0003, 0x000D, 0x0006, 0x001D, 0xFFFB, 0xFFF3,
    0xFFE9, 0x0008, 0x0003, 0x000A, 0xFFE7, 0xFFE2, 0xFFFC, 0xFFFF,
    0xFFF1, 0xFFE4, 0x000B, 0x000D, 0xFFD4, 0x0002, 0x003C, 0x0010,
    0x0029, 0x0006, 0x0032, 0xFFD7, 0xFFF2, 0x0019, 0xFFE6, 0x001F,
    0x0002, 0xFFD6, 0xFFF1, 0xFFFC, 0xFFF3, 0x0016, 0x0010, 0xFFF8,
    0x0008, 0xFFEA, 0x0007, 0x0011, 0x000A, 0xFFF2, 0xFFE3, 0x0028,
    0x0006, 0x0000, 0xFFFC, 0x0021, 0x002B, 0x0008, 0x0018, 0x001C,
    0xFFFB, 0x0006, 0xFFF1, 0x000D, 0x000A, 0x0006, 0xFFEB, 0xFFCE
    };

static const q15_t ref_cfft_noisy_2048[4096] = {
    0xFFB0, 0x0000, 0xFFEB, 0x0032, 0x000A, 0xFFFA, 0xFFF1, 0xFFF3,
    0xFFFB, 0xFFFA, 0x0018, 0xFFE4, 0x002B, 0xFFF8, 0xFFFC, 0xFFDF,
    0x0006, 0x0000, 0xFFE3, 0xFFD8, 0x000A, 0x000E, 0x0007, 0xFFEF,
    0x0008, 0x0016, 0x0010, 0x0008, 0xFFF3, 0xFFEA, 0xFFF1, 0x0004,
    0x0002, 0x002A, 0xFFE6, 0xFFE1, 0xFFF2, 0xFFE7, 0x0032, 0x0029,
    0x0029, 0xFFFA, 0x003C, 0xFFF0, 0xFFD4, 0xFFFE, 0x000B, 0xFFF3,
    0xFFF1, 0x001C, 0xFFFC, 0x0001, 0xFFE7, 0x001E, 0x0003, 0xFFF6,
    0xFFE9, 0xFFF8, 0xFFFB, 0x000D, 0x0006, 0xFFE3, 0x0003, 0xFFF3,
    0xFFE9, 0x004F, 0x0003, 0x001C, 0x0017, 0x000F, 0x0007, 0xFFCF,
    0x000D, 0xFFFD, 0x0014, 0xFFFD, 0x000B, 0x0003, 0x0004, 0x000E,
    0xFFF3, 0x000F, 0x0013, 0xFFEB, 0xFFDD, 0xFFCA, 0x0015, 0x0022,
    0x0023, 0xFFEB, 0x0009, 0x002A, 0x001C, 0xFFC4, 0xFFCC, 0x001D,
    0xFFE0, 0xFFE3, 0xFFDB, 0x0006, 0x002C, 0x002A, 0x0005, 0xFFFD,
    0x0004, 0x0021, 0x0011, 0xFFF5, 0xFFF8, 0xFFF5, 0xFFE3, 0xFFFE,
    0xFFEC, 0x0002, 0x0020, 0x0017, 0xFFE0, 0xFFF7, 0xFFBF, 0x0003,
    0x0012, 0x000D, 0x001A, 0x000E, 0xFFE2, 0x0034, 0xFFBF, 0x0021,
    0x0009, 0x001B, 0xFFEC, 0x0001, 0xFFF8, 0xFFD5, 0x0008, 0xFFF8,
    0x0005, 0x0008, 0xFFF8, 0xFFFA, 0x0027, 0x0020, 0xFFF8, 0xFFCC,
    0x0007, 0x0002, 0xFFF2, 0x0013, 0xFFE9, 0xFFDB, 0xFFE3, 0xFFC9,
    0x000A, 0x0032, 0x0001, 0x0001, 0xFFF3, 0x0006, 0xFFDD, 0xFFF3,
    0xFFF3, 0xFFF4, 0x0002, 0x0008, 0xFFF6, 0xFFB3, 0xFFC2, 0xFFE6,
    0xFFB9, 0x000F, 0x0039, 0xFFFA, 0xFFF5, 0x0017, 0x0004, 0xFFEA,
    0x0010, 0x000F, 0x0011, 0xFFF2, 0xFFEF, 0x0007, 0x0026, 0x0030,
    0xFFF8, 0x0022, 0xFFE6, 0xFFF5, 0x001B, 0xFFE7, 0x0007, 0xFFC0,
    0x0007, 0xFFDF, 0xFFF9, 0xFFC9, 0xFFF5, 0x0004, 0xFFF9, 0x000B,
    0x0015, 0xFFEE, 0xFFD0, 0xFFB8, 0xFFD7, 0xFFC0, 0x001B, 0x0009,
    0x0003, 0x0013, 0xFFFD, 0xFFF1, 0x0010, 0xFFD5, 0xFFE1, 0xFFFD,
    0x0017, 0xFFFE, 0x0022, 0x000B, 0xFFEE, 0x000F, 0xFFEE, 0x0004,
    0xFFF2, 0xFFEC, 0xFFF4, 0x0005, 0x000C, 0xFFDE, 0xFFE9, 0xFFFB,
    0x0004, 0xFFFE, 0xFFFF, 0xFFCC, 0xFFED, 0x001A, 0xFFE9, 0xFFDD,
    0x002A, 0x002D, 0x0004, 0xFFF8, 0x0028, 0xFFFF, 0x000A, 0xFFDA,
    0x0016, 0xFFCD, 0xFFF9, 0x0009, 0x0019, 0xFFF7, 0xFFF1, 0xFFF0,
    0x0001, 0x000B, 0x001E, 0x0011, 0xFFE2, 0x000A, 0x001F, 0xFFFA,
    0x0000, 0xFFF2, 0x0008, 0x0012, 0xFFF5, 0xFFFA, 0x0014, 0xFFFB,
    0x0026, 0x0027, 0xFFF2, 0xFFE3, 0x0008, 0xFFCA, 0xFFE0, 0x0013,
    0xFFE7, 0xFFEB, 0xFFED, 0x0038, 0xFFD2, 0xFFE8, 0xFFE8, 0xFFCB,
    0x0006, 0x000C, 0xFFD6, 0xFFEF, 0xFFF3, 0xFFE4, 0xFFF0, 0xFFFF,
    0xFFF0, 0x000A, 0x000F, 0x0012, 0xFFE8, 0xFFD1, 0xFFFA, 0x0002,
    0xFFFA, 0xFFF3, 0xFFF5, 0xFFEE, 0x000D, 0xFFDE, 0x000B, 0x0011,
    0xFFD7, 0x000E, 0x0002, 0x0011, 0xFFD7, 0x0020, 0xFFF7, 0x000F,
    0x0018, 0x0002, 0x003B, 0xFFF0, 0x0007, 0x0000, 0x0004, 0xFFF4,
    0xFFFE, 0xFFE6, 0x0026, 0x0007, 0xFFD7, 0x0046, 0x000F, 0xFFD7,
    0x0015, 0x003B, 0x0013, 0x0024, 0x0011, 0xFFF6, 0xFFD2, 0xFFF8,
    0x0023, 0x000B, 0xFFF8, 0x000A, 0xFFFD, 0xFFEE, 0x001A, 0xFFF3,
    0x000E, 0x000C, 0x000F, 0x0004, 0xFFF1, 0xFFF0, 0xFFFE, 0xFFF8,
    0xFFEA, 0xFFF7, 0x0006, 0xFFF9, 0xFFF2, 0xFFE9, 0xFFF6, 0x0017,
    0xFFE9, 0xFFCC, 0xFFFA, 0xFFF9, 0x0004, 0x0025, 0xFFE3, 0xFFD7,
    0xFFFE, 0x0011, 0xFFFC, 0xFFE5, 0xFFEB, 0xFFEB, 0xFFFB, 0xFFE1,
    0xFFE9, 0x000C, 0xFFE2, 0xFFEB, 0x0000, 0xFFFE, 0x0022, 0xFFE8,
    0xFFF0, 0x001B, 0x001F, 0xFFDC, 0x0027, 0x002F, 0x0007, 0x0017,
    0x000E, 0x0026, 0xFFE4, 0x0019, 0xFFD8, 0x0009, 0xFFC9, 0x0001,
    0x0029, 0xFFE4, 0x000D, 0xFFF3, 0x0024, 0x001E, 0xFFFB, 0xFFE1,
    0xFFFC, 0x000D, 0xFFFF, 0x000B, 0x001D, 0x000E, 0xFFDB, 0xFFF9,
    0x0028, 0x0020, 0xFFD6, 0xFFEF, 0x0024, 0xFFD6, 0x000D, 0xFFFD,
    0x000A, 0x0006, 0x000C, 0x0018, 0xFFF2, 0xFFFF, 0x0016, 0x000D,
    0x0010, 0x0015, 0x0005, 0xFFFA, 0xFFE6, 0xFFFC, 0xFFF4, 0x0029,
    0xFFDA, 0x0013, 0xFFE6, 0xFFE9, 0x000E, 0xFFE1, 0xFFF0, 0x0006,
    0xFFE3, 0xFFE8, 0xFFDF, 0x0015, 0xFFEF, 0x0014, 0x0004, 0x002A,
    0x0014, 0xFFFB, 0x000B, 0xFFEF, 0x001B, 0x0017, 0x0021, 0xFFE7,
    0x001C, 0xFFF5, 0x0012, 0xFFEA, 0x000F, 0x0000, 0x0013, 0xFFEF,
    0xFFF7, 0xFFFF, 0xFFFE, 0x0007, 0x0005, 0xFFCF, 0x0028, 0xFFF1,
    0xFFFC, 0x0009, 0xFFEE, 0x0017, 0xFFFA, 0x0011, 0x001B, 0x001C,
    0x0003, 0x003F, 0x0001, 0x002D, 0xFFF5, 0xFFDC, 0xFFF8, 0xFFE9,
    0x001A, 0xFFEF, 0x0008, 0xFFDD, 0x0004, 0xFFD2, 0xFFCE, 0x0018,
    0x0009, 0xD32B, 0xFFF9, 0x0013, 0xFFF1, 0x0040, 0xFFFF, 0x0020,
    0x0028, 0x001B, 0x000E, 0xFFFF, 0x0015, 0x001D, 0xFFEE, 0xFFAB,
    0xFFE6, 0x0026, 0xFFE8, 0xFFF6, 0x0010, 0xFFFB, 0x0017, 0xFFF5,
    0xFFE8, 0x001C, 0x0036, 0x0029, 0xFFFE, 0xFFE6, 0x0001, 0x0000,
    0xFFF5, 0x0014, 0xFFCF, 0xFFFA, 0xFFF4, 0x0017, 0x000F, 0x000E,
    0xFFF1, 0xFFFC, 0x0009, 0x0008, 0x000D, 0xFFFD, 0x0008, 0x002B,
    0x0004, 0x001A, 0xFFFB, 0xFFFF, 0x000E, 0x001E, 0x0005, 0x0006,
    0x0007, 0x0034, 0xFFF9, 0xFFE4, 0xFFFC, 0xFFE1, 0x001A, 0x0001,
    0xFFF8, 0x0033, 0xFFDC, 0xFFDF, 0xFFFA, 0xFFF2, 0xFFF8, 0x0010,
    0x001B, 0x0011, 0xFFE0, 0xFFF8, 0x000D, 0xFFDF, 0x000D, 0xFFED,
    0x0020, 0x0013, 0xFFFC, 0xFFE3, 0x0000, 0xFFF3, 0x0024, 0x0012,
    0x0008, 0xFFF4, 0xFFFA, 0xFFC4, 0x001C, 0x0027, 0x002D, 0x0005,
    0xFFE6, 0x000F, 0xFFF3, 0x0020, 0xFFEE, 0xFFFD, 0xFFEC, 0x0013,
    0x0018, 0xFFFA, 0xFFFA, 0x000E, 0x000C, 0x0009, 0x0020, 0x000E,
    0xFFDF, 0xFFF2, 0xFFCB, 0xFFFF, 0xFFFB, 0xFFDE, 0xFFEE, 0xFFD7,
    0xFFF6, 0x0004, 0xFFE3, 0x0027, 0x0012, 0xFFDB, 0xFFDB, 0xFFF7,
    0xFFEF, 0xFFFE, 0x000D, 0xFFD5, 0xFFF1, 0x0008, 0x000C, 0x0003,
    0xFFDF, 0xFFE8, 0x0004, 0xFFE4, 0xFFE1, 0x001D, 0xFFE5, 0xFFFC,
    0x0008, 0xFFDC, 0xFFE2, 0xFFE4, 0xFFED, 0x000C, 0xFFE1, 0x0001,
    0xFFE8, 0x0010, 0xFFEA, 0x000B, 0xFFE5, 0xFFE7, 0x0019, 0xFFFC,
    0x0010, 0x001D, 0x0026, 0x001D, 0x0008, 0xFFE5, 0xFFEC, 0xFFD0,
    0x0006, 0x0012, 0x000E, 0xFFF6, 0xFFD4, 0xFFE6, 0xFFFC, 0xFFD5,
    0x002E, 0xFFD8, 0xFFFB, 0xFFE5, 0xFFFE, 0x000A, 0x001A, 0x0018,
    0xFFE1, 0xFFF7, 0x0005, 0x0012, 0xFFFE, 0x000C, 0x000E, 0x000B,
    0xFFC4, 0x0013, 0x0019, 0xFFFB, 0x001E, 0xFFFC, 0xFFF4, 0xFFF4,
    0xFFE2, 0xFFE0, 0xFFFD, 0x0032, 0x0017, 0xFFED, 0xFFF2, 0x000F,
    0xFFEF, 0xFFD9, 0x0001, 0x000F, 0xFFFD, 0xFFEB, 0xFFEA, 0x0003,
    0x002A, 0xFFDF, 0x002F, 0xFFF2, 0xFFF6, 0xFFF2, 0xFFE8, 0x001D,
    0x0020, 0x0018, 0xFFC3, 0x000C, 0x0005, 0x0012, 0x0000, 0xFFDE,
    0x0003, 0x001A, 0x000C, 0x0007, 0x0025, 0x0014, 0xFFF2, 0xFFFC,
    0x000E, 0xFFFA, 0xFFF3, 0xFFD3, 0xFFD7, 0xFFF0, 0x0013, 0x0016,
    0x0008, 0x000E, 0x0038, 0xFFFA, 0xFFDF, 0x0006, 0x0013, 0x001B,
    0x002F, 0xFFFE, 0x001B, 0xFFE3, 0x0022, 0xFFF9, 0x000D, 0x0007,
    0x0018, 0xFFF0, 0x0041, 0x0011, 0xFFF3, 0xFFE0, 0x000E, 0x0026,
    0x0010, 0xFFF9, 0xFFDF, 0x0001, 0xFFC7, 0xFFF6, 0xFFEA, 0x000A,
    0x000C, 0x0008, 0xFFF5, 0xFFEA, 0x0016, 0x000C, 0x0015, 0xFFE7,
    0xFFE4, 0x0014, 0x000D, 0xFFF1, 0x0005, 0xFFF4, 0x0007, 0xFFE1,
    0xFFBE, 0xFFE3, 0x000C, 0x0009, 0x0002, 0xFFF9, 0x0027, 0xFFEF,
    0x002B, 0xFFFD, 0xFFF6, 0x000E, 0x000B, 0x0001, 0xFFEC, 0x001C,
    0x0029, 0xFFE6, 0x001D, 0xFFF0, 0x0021, 0x0016, 0xFFF7, 0x000F,
    0x0000, 0xFFFD, 0x0015, 0x000E, 0x0002, 0x0036, 0x0023, 0xFFE5,
    0xFFE5, 0x0003, 0x0004, 0xFFE9, 0x0009, 0xFFEE, 0xFFD9, 0x0016,
    0x0017, 0x0010, 0x0001, 0x0003, 0xFFF4, 0xFFEF, 0x0015, 0x000F,
    0xFFDD, 0x000A, 0xFFF2, 0x0010, 0x000A, 0x0008, 0xFFCB, 0xFFE4,
    0xFFF7, 0x001D, 0xFFC9, 0x000E, 0xFFF0, 0xFFED, 0x0000, 0xFFEE,
    0x0009, 0xFFE0, 0x0020, 0xFFF4, 0xFFE9, 0xFFD0, 0xFFF6, 0x0017,
    0xFFCE, 0x0012, 0xFFFD, 0x002A, 0x0009, 0xFFF9, 0x003B, 0x0015,
    0x0026, 0xFFD9, 0xFFF4, 0x002D, 0xFFDE, 0x0002, 0x0033, 0x001E,
    0x0010, 0xFFFF, 0xFFDC, 0xFFE9, 0x0000, 0x0021, 0xFFE5, 0xFFF0,
    0x0020, 0xFFFE, 0xFFD8, 0xFFEE, 0xFFE3, 0xFFDC, 0xFFF6, 0x0006,
    0x001F, 0xFFFB, 0x0026, 0xFFE6, 0x0033, 0x0000, 0xFFFE, 0x0007,
    0xFFEF, 0x0012, 0xFFF0, 0xFFE5, 0x0007, 0x0007, 0xFFDC, 0xFFF7,
    0xFFCF, 0x0012, 0x0012, 0xFFE2, 0x0007, 0xFFF2, 0xFFFE, 0xFFF3,
    0xFFF3, 0xFFFA, 0x0007, 0x0011, 0x0025, 0xFFE8, 0x0025, 0xFFF7,
    0xFFFC, 0xFFFB, 0xFFF9, 0xFFEB, 0xFFF9, 0x0004, 0x0011, 0xFFFB,
    0x000B, 0xFFDB, 0x002C, 0xFFD9, 0x0003, 0x0035, 0xFFEF, 0xFFEE,
    0x000F, 0xFFFE, 0x0015, 0x0013, 0x0015, 0x0018, 0xFFF9, 0x0028,
    0x0004, 0xFFF0, 0xFFE9, 0x0030, 0x0014, 0x000E, 0xFFEA, 0x001E,
    0xFFFB, 0xFFD8, 0xFFED, 0xFFF1, 0xFFE8, 0x003B, 0x0025, 0xFFCB,
    0xFFFF, 0xFFF5, 0xFFFB, 0xFFED, 0xFFD2, 0x001F, 0x0027, 0x002A,
    0x0000, 0x0041, 0x0002, 0xFFFB, 0xFFE9, 0xFFFF, 0x000E, 0xFFE8,
    0xFFC2, 0xFFDD, 0xFFEE, 0xFFFB, 0x000E, 0x0013, 0xFFFF, 0x002D,
    0x001E, 0xFFE6, 0xFFE4, 0xFFFD, 0xFFF5, 0xFFDA, 0x0014, 0xFFD9,
    0xFFF5, 0xFFF4, 0xFFF1, 0x001A, 0xFFC8, 0xFFF0, 0xFFF2, 0x000D,
    0x000B, 0x0013, 0xFFF7, 0xFFD0, 0x0007, 0xFFF3, 0xFFF2, 0xFFDE,
    0x0033, 0xFFF1, 0xFFF2, 0xFFF2, 0xFFE9, 0xFFFC, 0x0002, 0xFFE7,
    0xFFF7, 0xFFFB, 0x0000, 0xFFFA, 0x000C, 0xFFBE, 0x0002, 0xFFF7,
    0x0006, 0x0010, 0xFFFF, 0xFFE5, 0xFFE0, 0x0013, 0xFFEE, 0xFFE8,
    0x0002, 0x0009, 0x0002, 0xFFF2, 0xFFF8, 0x000B, 0x002B, 0xFFB5,
    0x000C, 0xFFDB, 0x001D, 0xFFE4, 0x0009, 0xFFE0, 0xFFF3, 0xFFFB,
    0x0035, 0x0006, 0xFFD8, 0x0018, 0x0027, 0xFFEE, 0x0008, 0x000B,
    0xFFCE, 0xFFF6, 0xFFF1, 0x001B, 0x000A, 0xFFF5, 0x0026, 0x001E,
    0xFFF6, 0xFFED, 0x0002, 0x002A, 0xFFD9, 0xFFFC, 0xFFF3, 0x0011,
    0x0020, 0xFFF3, 0x0000, 0x0008, 0xFFE8, 0xFFF7, 0xFFE0, 0xFFBE,
    0x001D, 0xFFCE, 0x0058, 0xFFE0, 0x0000, 0xFFED, 0x0017, 0xFFE3,
    0x0006, 0x0035, 0x0015, 0xFFF7, 0xFFF7, 0x0007, 0xFFEF, 0xFFF4,
    0x002D, 0x0007, 0xFFFC, 0xFFED, 0x0009, 0xFFE5, 0xFFF9, 0x0005,
    0x0010, 0xFFCA, 0x0023, 0xFFFA, 0x0006, 0x0007, 0xFFF7, 0xFFFE,
    0xFFFF, 0x0010, 0x0032, 0xFFF5, 0xFFFB, 0x0011, 0x0014, 0x0029,
    0x000D, 0xFFEA, 0x0015, 0xFFFC, 0x0001, 0xFFDC, 0xFFD8, 0xFFFF,
    0x0022, 0xFFD5, 0xFFDD, 0x002E, 0xFFE8, 0x002B, 0xFFEC, 0x0002,
    0x0026, 0x0016, 0x001A, 0xFFE4, 0x002E, 0xFFDF, 0xFFF1, 0xFFF5,
    0xFFFF, 0x0032, 0x003B, 0xFFF0, 0x0005, 0xFFE4, 0xFFEA, 0x0005,
    0x0017, 0xFFE3, 0x0019, 0x0026, 0xFFF2, 0xFFEC, 0xFFE7, 0x0010,
    0x000F, 0xFFDA, 0x0001, 0xFFDB, 0x0006, 0xFFF0, 0x0003, 0xFFF4,
    0xFFCC, 0x0002, 0xFFE6, 0xFFE6, 0xFFF4, 0x0019, 0xFFF5, 0x0015,
    0xFFE1, 0x001B, 0x001F, 0x0011, 0xFFEC, 0xFFF4, 0x0005, 0xFFD2,
    0xFFF0, 0x0000, 0x0018, 0xFFFA, 0xFFEE, 0x0037, 0xFFF8, 0x0032,
    0xFFE6, 0xFFFF, 0x0004, 0xFFE8, 0x0011, 0xFFF5, 0x000F, 0xFFF2,
    0xFFFB, 0xFFDD, 0xFFF9, 0x001B, 0xFFFC, 0x0008, 0x0029, 0xFFF0,
    0x0003, 0x001A, 0xFFEC, 0xFFEA, 0xFFC0, 0x002A, 0xFFFA, 0x0013,
    0x0019, 0xFFF0, 0x0003, 0xFFFE, 0x000E, 0x000E, 0x0009, 0x0036,
    0xFFED, 0x000B, 0x0007, 0x0008, 0xFFFB, 0x0003, 0x0028, 0x0004,
    0xFFEF, 0x000E, 0x0006, 0xFFE0, 0xFFFC, 0xFFF7, 0xFFF6, 0xFFD4,
    0xFFDA, 0x0000, 0x0003, 0x0000, 0xFFE2, 0x000F, 0x0012, 0x0017,
    0xFFF2, 0x0006, 0xFFF3, 0xFFF4, 0xFFF7, 0xFFF9, 0xFFE6, 0xFFF9,
    0x0003, 0x0038, 0xFFC5, 0x0016, 0xFFE4, 0x0013, 0xFFF2, 0xFFC3,
    0xFFFD, 0x000E, 0xFFCB, 0xFFF9, 0x0013, 0x0031, 0x001D, 0xFFFB,
    0xFFE6, 0xFFFC, 0xFFF8, 0x0007, 0xFFFE, 0x0008, 0xFFF9, 0x0009,
    0xFFDD, 0xFFE9, 0x001A, 0x000F, 0x0019, 0xFFE1, 0x0006, 0xFFF2,
    0x001D, 0x0011, 0xFFFD, 0xFFEA, 0x0008, 0x0026, 0xFFF7, 0xFFE8,
    0xFFE8, 0xFFDE, 0xFFD8, 0x0026, 0x000D, 0x000D, 0xFFF4, 0x001B,
    0xFFF1, 0x0010, 0xFFDB, 0xFFE2, 0xFFF7, 0x0020, 0x000B, 0x0010,
    0x0002, 0xFFE5, 0x0018, 0x000C, 0x0012, 0xFFEE, 0x0024, 0xFFE9,
    0x0001, 0xFFFC, 0xFFFE, 0xFFF9, 0x0003, 0x000C, 0x0002, 0xFFF5,
    0x0006, 0xFFF0, 0xFFEC, 0x0012, 0x000E, 0xFFE8, 0xFFD5, 0x0016,
    0xFFF1, 0x0005, 0x0036, 0xFFFB, 0xFFF7, 0x0007, 0x0025, 0xFFF6,
    0x0016, 0xFFF1, 0xFFEF, 0xFFC6, 0x0006, 0x001F, 0x0023, 0x0002,
    0x000A, 0x000F, 0x0000, 0xFFDB, 0xFFD9, 0x000D, 0x0024, 0x0011,
    0x0022, 0xFFDC, 0x0001, 0xFFF6, 0xFFE2, 0xFFF8, 0x0003, 0xFFE2,
    0xFFE7, 0xFFF0, 0x0010, 0x0012, 0xFFD1, 0xFFEE, 0x0002, 0xFFD3,
    0xFFFA, 0x000A, 0x0011, 0x0040, 0x0004, 0x000D, 0x000C, 0x0018,
    0x0007, 0x000F, 0x0029, 0xFFDA, 0xFFD6, 0xFFFB, 0xFFE2, 0xFFED,
    0xFFF4, 0x000A, 0x0019, 0x0005, 0xFFEF, 0xFFF9, 0xFFFE, 0x0020,
    0x001A, 0xFFF5, 0x000E, 0xFFED, 0x0000, 0x0026, 0xFFDA, 0xFFCB,
    0x0005, 0xFFDD, 0xFFF5, 0x000D, 0xFFE9, 0x0001, 0xFFE4, 0x000B,
    0x0019, 0x001D, 0xFFCC, 0x000C, 0xFFE5, 0xFFD8, 0xFFFA, 0xFFE4,
    0xFFFC, 0x002A, 0x0019, 0xFFEC, 0x001B, 0x0004, 0xFFD1, 0xFFFE,
    0xFFF1, 0xFFFE, 0xFFB3, 0x001D, 0xFFE7, 0x0004, 0xFFFF, 0xFFFF,
    0x0021, 0xFFE9, 0xFFF4, 0x0009, 0xFFFE, 0xFFFB, 0x0014, 0xFFD3,
    0xFFE9, 0xFFD7, 0x0011, 0x000B, 0x0021, 0x0038, 0xFFFF, 0x0009,
    0x0004, 0x002B, 0xFFF0, 0x0015, 0x0023, 0x000F, 0x001D, 0xFFE5,
    0xFFE3, 0x000C, 0x001E, 0xFFFC, 0x0004, 0x000F, 0x0017, 0xFFF5,
    0xFFF7, 0x0014, 0xFFEB, 0xFFF9, 0xFFFA, 0xFFFE, 0x000B, 0x0012,
    0x000C, 0x000D, 0x0027, 0xFFE2, 0x002B, 0xFFE6, 0x0014, 0xFFF5,
    0xFFDC, 0xFFF7, 0x002C, 0xFFF9, 0xFFF5, 0x0005, 0x0002, 0x0018,
    0x000C, 0xFFE2, 0x0019, 0xFFE1, 0x001D, 0x002F, 0xFFFA, 0xFFF1,
    0x0016, 0xFFFE, 0x0005, 0x0004, 0xFFFC, 0x000E, 0x0017, 0xFFF4,
    0x0003, 0xFFF8, 0x000B, 0x0007, 0xFFE1, 0x0017, 0xFFE0, 0x000B,
    0xFFD1, 0xFFFF, 0x0014, 0x0010, 0xFFF9, 0x000E, 0x0020, 0xFFDD,
    0x001C, 0xFFFE, 0x000D, 0xFFF0, 0xFFE7, 0xFFEF, 0x0003, 0xFFF6,
    0xFFCF, 0x0003, 0xFFFE, 0xFFF1, 0xFFF1, 0x000D, 0xFFFC, 0x0004,
    0xFFE6, 0x001B, 0x0010, 0xFFE7, 0x000E, 0x0010, 0x0019, 0xFFF2,
    0x000B, 0xFFEE, 0xFFD8, 0xFFE4, 0x0029, 0x000F, 0x003E, 0x000E,
    0x001A, 0xFFE8, 0x000F, 0x0017, 0x0007, 0x0036, 0xFFED, 0xFFFB,
    0x0005, 0x0000, 0x0008, 0x0016, 0x0024, 0x0008, 0xFFEB, 0xFFF5,
    0xFFFD, 0xFFEA, 0x0028, 0xFFEA, 0x0002, 0x0034, 0xFFE8, 0x0017,
    0x0010, 0xFFFB, 0xFFD1, 0xFFF8, 0x001C, 0x000E, 0x0006, 0xFFDF,
    0xFFEF, 0x000D, 0xFFF9, 0xFFFC, 0xFFFB, 0xFFF3, 0x0004, 0xFFE5,
    0xFFE6, 0x0011, 0xFFCD, 0x0034, 0xFFF6, 0x0002, 0xFFA6, 0x002C,
    0x001A, 0xFFF0, 0xFFF2, 0x000D, 0x0037, 0x0023, 0xFFE2, 0x0018,
    0x0020, 0x000C, 0x001D, 0x0011, 0x001D, 0xFFE0, 0x0001, 0xFFFE,
    0x0006, 0xFFD8, 0xFFF7, 0x0019, 0xFFCF, 0x0012, 0x0030, 0x000C,
    0x0042, 0xFF98, 0x001E, 0xFFE5, 0x0002, 0xFFF2, 0x0000, 0xFFEF,
    0x0005, 0xFFFA, 0x0022, 0xFFF4, 0x0020, 0x0008, 0x001F, 0x000B,
    0xFFEE, 0xFFC2, 0x0038, 0x001D, 0xFFBE, 0x002D, 0x0014, 0xFFF8,
    0xFFFC, 0x0023, 0xFFD7, 0xFFE1, 0xFFF1, 0x000F, 0x0011, 0x0015,
    0xFFDA, 0x0018, 0x0000, 0x000B, 0x0002, 0x0009, 0x000D, 0xFFF2,
    0x0005, 0x0019, 0x0019, 0x0034, 0x0010, 0xFFF1, 0xFFF9, 0x000E,
    0xFFFB, 0xFFFC, 0x0027, 0xFFF2, 0x0028, 0xFFF6, 0xFFED, 0x000F,
    0xFFFB, 0xFFE9, 0x0002, 0x0025, 0x000D, 0xFFEF, 0x0010, 0x002D,
    0x001D, 0xFFE6, 0xFFFE, 0x0004, 0xFFF8, 0xFFFB, 0xFFF8, 0xFFE9,
    0x0000, 0xFFD7, 0x000D, 0x0007, 0xFFEC, 0xFFDD, 0x000B, 0x0009,
    0xFFEE, 0x001B, 0xFFF3, 0xFFE7, 0x0005, 0x0002, 0xFFF2, 0x0024,
    0xFFCD, 0x000C, 0x001C, 0xFFF4, 0x000B, 0xFFE5, 0x0021, 0x0017,
    0x0004, 0x0009, 0xFFF9, 0xFFF8, 0xFFF7, 0xFFED, 0xFFEF, 0x000F,
    0x000A, 0x000B, 0xFFF6, 0x0005, 0x0004, 0x000B, 0x0003, 0xFFEB,
    0xFFF1, 0xFFF4, 0x0007, 0xFFE8, 0x0016, 0x000C, 0x001A, 0x0007,
    0xFFF3, 0x001C, 0xFFE7, 0xFFD1, 0xFFD1, 0x0026, 0x0006, 0xFFF3,
    0x0015, 0xFFF3, 0x0014, 0x0001, 0x0008, 0x0022, 0xFFE6, 0xFFF1,
    0xFFE8, 0x0025, 0x000F, 0x0004, 0x0011, 0x0005, 0x001F, 0xFFC6,
    0xFFDB, 0xFFEA, 0x0007, 0x002B, 0x0001, 0x0023, 0x001B, 0xFFEF,
    0x0003, 0xFFDD, 0xFFF4, 0x001B, 0x001A, 0x0006, 0x001A, 0x0019,
    0x0022, 0xFFF7, 0x002C, 0x004F, 0xFFEE, 0xFFDE, 0xFFEB, 0xFFCD,
    0xFFF0, 0xFFE3, 0x0000, 0xFFDB, 0x0039, 0x0004, 0xFFE7, 0xFFD1,
    0xFFD2, 0xFFE2, 0x0008, 0xFFFF, 0xFFED, 0x000D, 0x000A, 0xFFF5,
    0xFFC8, 0x0006, 0x002B, 0x0034, 0xFFD6, 0xFFC0, 0x0015, 0x000D,
    0xFFF0, 0x0012, 0x0026, 0xFFEA, 0x0006, 0xFFDD, 0x0019, 0x0000,
    0xFFE3, 0xFFEC, 0xFFE0, 0xFFF1, 0x000A, 0xFFFC, 0xFFCF, 0x0037,
    0xFFD3, 0x0001, 0xFFFB, 0x0028, 0x0002, 0x0011, 0xFFFD, 0xFFEB,
    0xFFFA, 0x000A, 0xFFFF, 0xFFF2, 0x001C, 0x0013, 0x0003, 0x0015,
    0x0027, 0x002E, 0x000B, 0xFFF3, 0xFFFD, 0xFFD5, 0xFFFA, 0x0003,
    0xFFF5, 0x0001, 0x0029, 0x0000, 0x000A, 0xFFFF, 0xFFF5, 0x000F,
    0x000D, 0xFFF8, 0xFFFD, 0xFFFB, 0xFFFA, 0x001A, 0xFFF1, 0xFFEF,
    0x0010, 0x0025, 0xFFFC, 0x003F, 0x0017, 0xFFFB, 0x0013, 0xFFFC,
    0xFFEF, 0xFFEA, 0x0015, 0x0003, 0x0000, 0x001D, 0x000A, 0x0002,
    0x0005, 0xFFC7, 0x0014, 0x000E, 0xFFF3, 0x002B, 0xFFF9, 0xFFFF,
    0x0004, 0xFFE5, 0x0036, 0xFFF8, 0x000E, 0x0008, 0x0003, 0xFFE1,
    0xFFFA, 0xFFDA, 0x0006, 0x0022, 0xFFDE, 0x001B, 0xFFFA, 0x0008,
    0xFFE7, 0xFFE6, 0x000B, 0xFFEF, 0x0007, 0xFFFC, 0x000D, 0xFFF4,
    0x0040, 0x0023, 0x001A, 0x000E, 0xFFE5, 0xFFFB, 0x0011, 0xFFD3,
    0xFFDC, 0xFFD8, 0x0023, 0x0000, 0x002F, 0xFFEA, 0x000C, 0xFFEA,
    0xFFF1, 0x0018, 0x0006, 0xFFCC, 0x0009, 0xFFE2, 0x0009, 0x000F,
    0xFFFB, 0x0012, 0x0008, 0xFFE6, 0xFFE8, 0x000D, 0x000B, 0x0023,
    0xFFF3, 0xFFFE, 0xFFE4, 0x0007, 0xFFFE, 0x0005, 0xFFF4, 0x0011,
    0xFFFF, 0x002E, 0x001A, 0x000C, 0x0002, 0x0008, 0x001D, 0x0008,
    0x0009, 0x001C, 0x001F, 0x000D, 0xFFFE, 0x0003, 0x0029, 0xFFDE,
    0x001C, 0xFFEA, 0x001B, 0x0007, 0x000C, 0xFFF4, 0xFFF9, 0x0025,
    0xFFC6, 0xFFEF, 0xFFC5, 0x0010, 0x001F, 0xFFF3, 0xFFD0, 0xFFE8,
    0xFFFF, 0xFFF7, 0x001F, 0x0009, 0x0048, 0xFFD1, 0xFFF3, 0xFFDE,
    0xFFD5, 0x000A, 0xFFE3, 0xFFEE, 0xFFF2, 0x001F, 0x0023, 0x0009,
    0xFFF9, 0xFFDE, 0xFFEF, 0x0000, 0xFFE3, 0x000F, 0x0022, 0xFFFA,
    0x000E, 0x0000, 0x0022, 0x0006, 0xFFE3, 0xFFF1, 0xFFEF, 0x0000,
    0xFFF9, 0x0022, 0x0023, 0xFFF7, 0xFFF2, 0xFFE1, 0xFFE3, 0x0012,
    0xFFD5, 0xFFF6, 0xFFF3, 0x0022, 0x0048, 0x002F, 0x001F, 0xFFF7,
    0xFFFF, 0x0009, 0xFFD0, 0x0018, 0x001F, 0x000D, 0xFFC5, 0xFFF0,
    0xFFC6, 0x0011, 0xFFF9, 0xFFDB, 0x000C, 0x000C, 0x001B, 0xFFF9,
    0x001C, 0x0016, 0x0029, 0x0022, 0xFFFE, 0xFFFD, 0x001F, 0xFFF3,
    0x0009, 0xFFE4, 0x001D, 0xFFF8, 0x0002, 0xFFF8, 0x001A, 0xFFF4,
    0xFFFF, 0xFFD2, 0xFFF4, 0xFFEF, 0xFFFE, 0xFFFB, 0xFFE4, 0xFFF9,
    0xFFF3, 0x0002, 0x000B, 0xFFDD, 0xFFE8, 0xFFF3, 0x0008, 0x001A,
    0xFFFB, 0xFFEE, 0x0009, 0xFFF1, 0x0009, 0x001E, 0x0006, 0x0034,
    0xFFF1, 0xFFE8, 0x000C, 0x0016, 0x002F, 0x0016, 0x0023, 0x0000,
    0xFFDC, 0x0028, 0x0011, 0x002D, 0xFFE5, 0x0005, 0x001A, 0xFFF2,
    0x0040, 0xFFDD, 0x000D, 0x000C, 0x0007, 0x0004, 0x000B, 0x0011,
    0xFFE7, 0x001A, 0xFFFA, 0xFFF8, 0xFFDE, 0xFFE5, 0x0006, 0xFFDE,
    0xFFFA, 0x0026, 0x0003, 0x001F, 0x000E, 0xFFF8, 0x0036, 0x0008,
    0x0004, 0x001B, 0xFFF9, 0x0001, 0xFFF3, 0xFFD5, 0x0014, 0xFFF2,
    0x0005, 0x0039, 0x000A, 0xFFFE, 0x0000, 0xFFE3, 0x0015, 0xFFFD,
    0xFFEF, 0x0016, 0x0013, 0x0004, 0x0017, 0x0005, 0xFFFC, 0xFFC1,
    0x0010, 0xFFDB, 0xFFF1, 0x0011, 0xFFFA, 0xFFE6, 0xFFFD, 0x0005,
    0x000D, 0x0008, 0xFFF5, 0xFFF1, 0x000A, 0x0001, 0x0029, 0x0000,
    0xFFF5, 0xFFFF, 0xFFFA, 0xFFFD, 0xFFFD, 0x002B, 0x000B, 0x000D,
    0x0027, 0xFFD2, 0x0003, 0xFFEB, 0x001C, 0xFFED, 0xFFFF, 0x000E,
    0xFFFA, 0xFFF6, 0xFFFD, 0x0015, 0x0002, 0xFFEF, 0xFFFB, 0xFFD8,
    0xFFD3, 0xFFFF, 0xFFCF, 0xFFC9, 0x000A, 0x0004, 0xFFE0, 0x000F,
    0xFFE3, 0x0014, 0x0019, 0x0000, 0x0006, 0x0023, 0x0026, 0x0016,
    0xFFF0, 0xFFEE, 0x0015, 0xFFF3, 0xFFD6, 0x0040, 0x002B, 0xFFCC,
    0xFFC8, 0xFFFA, 0x000A, 0x000B, 0xFFED, 0xFFF3, 0x0008, 0x0001,
    0xFFD2, 0x001E, 0xFFE7, 0x002F, 0x0039, 0xFFFC, 0x0000, 0x0025,
    0xFFF0, 0x001D, 0xFFEB, 0x0033, 0xFFEE, 0x0022, 0x002C, 0xFFB1,
    0x0022, 0x0009, 0x001A, 0xFFE7, 0x001A, 0xFFFA, 0xFFF4, 0xFFE5,
    0x0003, 0x0023, 0x001B, 0x0011, 0x0001, 0xFFDD, 0x0007, 0xFFD5,
    0xFFDB, 0x0016, 0x001F, 0x003A, 0x0011, 0xFFFB, 0x000F, 0xFFFC,
    0xFFE8, 0xFFDB, 0xFFE6, 0x000F, 0x0008, 0xFFDE, 0x0014, 0xFFFF,
    0x0015, 0x000D, 0x0006, 0x000D, 0xFFD1, 0xFFDA, 0xFFE7, 0x002F,
    0xFFF3, 0xFFE4, 0x001A, 0xFFF9, 0x0016, 0xFFF4, 0x0007, 0x0018,
    0xFFF1, 0x000C, 0x0003, 0x0015, 0x0004, 0xFFF5, 0xFFF6, 0xFFFB,
    0x000A, 0xFFF5, 0xFFEF, 0xFFF1, 0xFFF7, 0x0013, 0xFFF9, 0x0008,
    0x0004, 0xFFF7, 0x0021, 0xFFE9, 0x000B, 0x001B, 0x001C, 0x000C,
    0xFFCD, 0xFFF4, 0xFFF2, 0xFFDC, 0x0005, 0xFFFE, 0xFFF3, 0x0019,
    0xFFEE, 0xFFE5, 0x000B, 0xFFF7, 0xFFEC, 0x0023, 0x000D, 0xFFF9,
    0x0000, 0x0029, 0xFFF8, 0x0017, 0xFFF8, 0x0005, 0xFFFE, 0xFFFC,
    0x001D, 0x001A, 0x0010, 0xFFD3, 0x000D, 0x0011, 0x0002, 0xFFDB,
    0xFFFB, 0x0017, 0xFFED, 0xFFF1, 0x0028, 0x000A, 0x0027, 0x000E,
    0xFFFB, 0x0004, 0xFFF9, 0xFFF2, 0x0010, 0x000F, 0x0019, 0xFFCC,
    0x0005, 0xFFE7, 0x000D, 0x000E, 0x0002, 0xFFF7, 0x0000, 0xFFF5,
    0xFFDA, 0xFFE8, 0x0011, 0xFFEB, 0xFFF1, 0xFFF1, 0xFFD7, 0x001F,
    0xFFFC, 0xFFDD, 0x0014, 0x0008, 0xFFBE, 0xFFD3, 0x0038, 0xFFE3,
    0xFFEE, 0x003E, 0x001F, 0xFFF5, 0x0020, 0xFFF8, 0x0022, 0x000C,
    0x0005, 0x0006, 0x0000, 0x0011, 0x0002, 0x000E, 0x001E, 0x001B,
    0x0042, 0x0068, 0x0030, 0xFFF4, 0xFFCF, 0xFFEE, 0xFFF7, 0xFFE7,
    0x0006, 0x0028, 0x0001, 0x0002, 0x001D, 0x0020, 0x001D, 0xFFEF,
    0x0020, 0xFFF4, 0xFFE2, 0xFFE8, 0x0037, 0xFFDD, 0xFFF2, 0xFFF3,
    0x001A, 0x0010, 0xFFA6, 0xFFD4, 0xFFF6, 0xFFFE, 0xFFCD, 0xFFCC,
    0xFFE6, 0xFFEF, 0x0004, 0x001B, 0xFFFB, 0x000D, 0xFFF9, 0x0004,
    0xFFEF, 0xFFF3, 0x0006, 0x0021, 0x001C, 0xFFF2, 0xFFD1, 0x0008,
    0x0010, 0x0005, 0xFFE8, 0xFFE9, 0x0002, 0xFFCC, 0x0028, 0x0016,
    0xFFFD, 0x0016, 0xFFEB, 0x000B, 0x0024, 0xFFF8, 0x0008, 0xFFEA,
    0x0005, 0x0000, 0xFFED, 0x0005, 0x0007, 0xFFCA, 0x000F, 0xFFE9,
    0x001A, 0x0018, 0x003E, 0xFFF2, 0x0029, 0xFFF1, 0xFFD8, 0x001C,
    0x000B, 0x0012, 0x0019, 0x000E, 0x000E, 0xFFF0, 0x0010, 0x0019,
    0xFFE6, 0xFFE5, 0xFFFC, 0xFFFC, 0xFFF1, 0xFFF3, 0xFFFE, 0x000F,
    0xFFCF, 0xFFFD, 0x0003, 0x000A, 0xFFE7, 0x0011, 0x000D, 0x0010,
    0x001C, 0x0002, 0x0020, 0x0023, 0xFFF9, 0xFFF2, 0x0014, 0xFFF0,
    0xFFD1, 0x0001, 0xFFE0, 0xFFF5, 0xFFE1, 0xFFE9, 0x000B, 0xFFF9,
    0x0003, 0x0008, 0x0017, 0x000C, 0xFFFC, 0xFFF2, 0x0005, 0xFFFC,
    0x0016, 0x0002, 0xFFFA, 0x000F, 0x001D, 0xFFD1, 0x0019, 0x001F,
    0x000C, 0x001E, 0x0002, 0xFFE8, 0xFFF5, 0xFFFB, 0x002C, 0x0007,
    0xFFDC, 0x0009, 0x0014, 0x000B, 0x002B, 0x001A, 0x0027, 0x001E,
    0x000C, 0xFFF3, 0x000B, 0xFFEE, 0xFFFA, 0x0002, 0xFFEB, 0x0007,
    0xFFF7, 0xFFEC, 0x0017, 0x000B, 0x0004, 0xFFF1, 0x001E, 0x0004,
    0xFFE3, 0xFFF4, 0x001D, 0x001B, 0x0023, 0xFFF1, 0xFFF0, 0xFFEB,
    0x0004, 0xFFD5, 0xFFFF, 0xFFF7, 0x0021, 0xFFC8, 0x0011, 0xFFF5,
    0xFFE9, 0x0029, 0x0014, 0x002D, 0xFFFE, 0x0005, 0xFFF4, 0xFFF7,
    0x0021, 0x0017, 0xFFFF, 0x0001, 0xFFE7, 0xFFFC, 0xFFB3, 0xFFE3,
    0xFFF1, 0x0002, 0xFFD1, 0x0002, 0x001B, 0xFFFC, 0x0019, 0x0014,
    0xFFFC, 0xFFD6, 0xFFFA, 0x001C, 0xFFE5, 0x0028, 0xFFCC, 0xFFF4,
    0x0019, 0xFFE3, 0xFFE4, 0xFFF5, 0xFFE9, 0xFFFF, 0xFFF5, 0xFFF3,
    0x0005, 0x0023, 0xFFDA, 0x0035, 0x0000, 0xFFDA, 0x000E, 0x0013,
    0x001A, 0x000B, 0xFFFE, 0xFFE0, 0xFFEF, 0x0007, 0x0019, 0xFFFB,
    0xFFF4, 0xFFF6, 0xFFE2, 0x0013, 0xFFD6, 0x0005, 0x0029, 0x0026,
    0x0007, 0xFFF1, 0x000C, 0xFFE8, 0x0004, 0xFFF3, 0x0011, 0xFFC0,
    0xFFFA, 0xFFF6, 0x0002, 0x002D, 0xFFD1, 0x0012, 0x0010, 0xFFEE,
    0xFFE7, 0x0010, 0x0003, 0x001E, 0xFFE2, 0x0008, 0x0001, 0x000A,
    0x0022, 0x0024, 0x0024, 0xFFEF, 0xFFD9, 0xFFF3, 0x0000, 0x0025,
    0x000A, 0xFFF1, 0x0023, 0xFFFE, 0x0006, 0xFFE1, 0xFFEF, 0x003A,
    0x0016, 0x000F, 0x0025, 0x000A, 0xFFF7, 0xFFF9, 0x0036, 0x0005,
    0xFFF1, 0xFFFB, 0xFFD5, 0xFFEA, 0x000E, 0x0018, 0xFFEC, 0xFFEE,
    0x0006, 0x0010, 0x0002, 0x000B, 0x0003, 0xFFF4, 0xFFFE, 0x0007,
    0x0001, 0x0004, 0x0024, 0x0017, 0x0012, 0x0012, 0x0018, 0xFFF4,
    0x0002, 0x001B, 0x000B, 0xFFF0, 0xFFF7, 0xFFE0, 0xFFDB, 0x001E,
    0xFFF1, 0xFFF0, 0xFFF4, 0xFFE5, 0x000D, 0xFFF3, 0xFFD8, 0xFFDA,
    0xFFE8, 0x0022, 0xFFF7, 0x0018, 0x0008, 0xFFDA, 0xFFFD, 0x0016,
    0x001D, 0xFFEF, 0x0006, 0x000E, 0x0019, 0x001F, 0x001A, 0xFFF1,
    0xFFDD, 0x0017, 0xFFF9, 0xFFF7, 0xFFFE, 0xFFF8, 0xFFF8, 0xFFF9,
    0xFFE6, 0x0004, 0x001D, 0x0005, 0x0013, 0xFFCF, 0xFFCB, 0x0007,
    0xFFFD, 0xFFF2, 0xFFF2, 0x003D, 0xFFE4, 0xFFED, 0xFFC5, 0xFFEA,
    0x0003, 0xFFC8, 0xFFE6, 0x0007, 0xFFF7, 0x0007, 0xFFF3, 0x000C,
    0xFFF2, 0xFFFA, 0x0012, 0xFFE9, 0xFFE2, 0xFFF1, 0x0003, 0x0000,
    0xFFDA, 0x0000, 0xFFF6, 0x002C, 0xFFFC, 0x0009, 0x0006, 0x0020,
    0xFFEF, 0xFFF2, 0x0028, 0xFFFC, 0xFFFB, 0xFFFD, 0x0007, 0xFFF8,
    0xFFED, 0xFFF5, 0x0009, 0xFFCA, 0x000E, 0xFFF2, 0x0003, 0x0002,
    0x0019, 0x0010, 0xFFFA, 0xFFED, 0xFFC0, 0xFFD6, 0xFFEC, 0x0016,
    0x0003, 0xFFE6, 0x0029, 0x0010, 0xFFFC, 0xFFF8, 0xFFF9, 0xFFE5,
    0xFFFB, 0x0023, 0x000F, 0x000E, 0x0011, 0x000B, 0x0004, 0x0018,
    0xFFE6, 0x0001, 0xFFF8, 0xFFCE, 0xFFEE, 0xFFC9, 0x0018, 0x0006,
    0xFFF0, 0x0000, 0x0005, 0x002E, 0xFFEC, 0x000C, 0x001F, 0xFFEF,
    0xFFE1, 0xFFE5, 0xFFF5, 0xFFEB, 0xFFF4, 0xFFE7, 0xFFE6, 0x001A,
    0xFFCC, 0xFFFE, 0x0003, 0x000C, 0x0006, 0x0010, 0x0001, 0x0025,
    0x000F, 0x0026, 0xFFE7, 0xFFF0, 0xFFF2, 0x0014, 0x0019, 0xFFDA,
    0x0017, 0x001D, 0xFFEA, 0xFFFB, 0x0005, 0x001C, 0x003B, 0x0010,
    0xFFFF, 0xFFCE, 0xFFF1, 0x000B, 0x002E, 0x0021, 0x001A, 0x001C,
    0x0026, 0xFFEA, 0xFFEC, 0xFFFE, 0xFFE8, 0xFFD5, 0xFFDD, 0xFFD2,
    0x0022, 0x002B, 0xFFD8, 0x0001, 0x0001, 0x0024, 0x0015, 0x0004,
    0x000D, 0x0016, 0x0014, 0xFFD7, 0xFFFB, 0xFFEF, 0x0032, 0x000B,
    0xFFFF, 0xFFF0, 0xFFF7, 0x0002, 0x0006, 0xFFF9, 0x0023, 0x0006,
    0x0010, 0x0036, 0xFFF9, 0xFFFB, 0x0009, 0x001B, 0xFFFC, 0x0013,
    0x002D, 0xFFF9, 0xFFEF, 0x000C, 0xFFF7, 0xFFF9, 0x0015, 0x0009,
    0x0006, 0xFFCB, 0x0017, 0x001D, 0x0000, 0x0013, 0x0058, 0x0020,
    0x001D, 0x0032, 0xFFE0, 0x0042, 0xFFE8, 0x0009, 0x0000, 0xFFF8,
    0x0020, 0x000D, 0xFFF3, 0xFFEF, 0xFFD9, 0x0004, 0x0002, 0xFFD6,
    0xFFF6, 0x0013, 0x0026, 0xFFE2, 0x000A, 0x000B, 0xFFF1, 0xFFE5,
    0xFFCE, 0x000A, 0x0008, 0xFFF5, 0x0027, 0x0012, 0xFFD8, 0xFFE8,
    0x0035, 0xFFFA, 0xFFF3, 0x0005, 0x0009, 0x0020, 0x001D, 0x001C,
    0x000C, 0x0025, 0x002B, 0x004B, 0xFFF8, 0xFFF5, 0x0002, 0x000E,
    0x0002, 0xFFF7, 0xFFEE, 0x0018, 0xFFE0, 0xFFED, 0xFFFF, 0x001B,
    0x0006, 0xFFF0, 0x0002, 0x0009, 0x000C, 0x0042, 0x0000, 0x0006,
    0xFFF7, 0x0005, 0x0002, 0x0019, 0xFFE9, 0x0004, 0xFFF2, 0x000E,
    0x0033, 0x000F, 0xFFF2, 0x0022, 0x0007, 0x000D, 0xFFF7, 0x0030,
    0x000B, 0xFFED, 0xFFF2, 0xFFF3, 0xFFC8, 0x0010, 0xFFF1, 0xFFE6,
    0xFFF5, 0x000C, 0x0014, 0x0027, 0xFFF5, 0x0026, 0xFFE4, 0x0003,
    0x001E, 0x001A, 0xFFFF, 0xFFD3, 0x000E, 0xFFED, 0xFFEE, 0x0005,
    0xFFC2, 0x0023, 0x000E, 0x0018, 0xFFE9, 0x0001, 0x0002, 0x0005,
    0x0000, 0xFFBF, 0x0027, 0xFFD6, 0xFFD2, 0xFFE1, 0xFFFB, 0x0013,
    0xFFFF, 0x000B, 0x0025, 0x0035, 0xFFE8, 0xFFC5, 0xFFED, 0x000F,
    0xFFFB, 0x0028, 0xFFEA, 0xFFE2, 0x0014, 0xFFF2, 0xFFE9, 0xFFD0,
    0x0004, 0x0010, 0xFFF9, 0xFFD8, 0x0015, 0xFFE8, 0x0015, 0xFFED,
    0x000F, 0x0002, 0xFFEF, 0x0012, 0x0003, 0xFFCB, 0x002C, 0x0027,
    0x000B, 0x0025, 0x0011, 0x0005, 0xFFF9, 0xFFFC, 0xFFF9, 0x0015,
    0xFFFC, 0x0005, 0x0025, 0x0009, 0x0025, 0x0018, 0x0007, 0xFFEF,
    0xFFF3, 0x0006, 0xFFFE, 0x000D, 0x0007, 0x000E, 0x0012, 0x001E,
    0xFFCF, 0xFFEE, 0xFFDC, 0x0009, 0x0007, 0xFFF9, 0xFFF0, 0x001B,
    0xFFEF, 0xFFEE, 0xFFFE, 0xFFF9, 0x0033, 0x0000, 0x0026, 0x001A,
    0x001F, 0x0005, 0xFFF6, 0xFFFA, 0xFFE3, 0x0024, 0xFFD8, 0x0012,
    0x0020, 0x0002, 0xFFE5, 0x0010, 0x0000, 0xFFDF, 0xFFDC, 0x0017,
    0x0010, 0x0001, 0x0033, 0xFFE2, 0xFFDE, 0xFFFE, 0xFFF4, 0xFFD3,
    0x0026, 0x0027, 0x003B, 0xFFEB, 0x0009, 0x0007, 0xFFFD, 0xFFD6,
    0xFFCE, 0xFFEE, 0xFFF6, 0xFFE9, 0xFFE9, 0x0030, 0x0020, 0x000C,
    0x0009, 0x0020, 0x0000, 0x0012, 0xFFF0, 0x0013, 0xFFC9, 0xFFF2,
    0xFFF7, 0xFFE3, 0xFFCB, 0x001C, 0x000A, 0xFFF8, 0xFFF2, 0xFFF0,
    0xFFDD, 0xFFF6, 0x0015, 0xFFF1, 0xFFF4, 0x0011, 0x0001, 0xFFFD,
    0x0017, 0xFFF0, 0xFFD9, 0xFFEA, 0x0009, 0x0012, 0x0004, 0x0017,
    0xFFE5, 0xFFFD, 0x0023, 0x001B, 0x0002, 0xFFCA, 0x0015, 0xFFF2,
    0x0000, 0x0003, 0xFFF7, 0xFFF1, 0x0021, 0xFFEA, 0x001D, 0x0010,
    0x0029, 0x001A, 0xFFEC, 0xFFE4, 0x000B, 0xFFFF, 0xFFF6, 0xFFF2,
    0x002B, 0x0003, 0x0027, 0x0011, 0x0002, 0x0007, 0x000C, 0xFFF7,
    0xFFBE, 0x001D, 0x0007, 0x001F, 0x0005, 0x000C, 0x000D, 0x000F,
    0xFFE4, 0xFFEC, 0x0015, 0x0019, 0x0016, 0xFFF4, 0xFFF5, 0x0016,
    0x000C, 0xFFF8, 0xFFEA, 0xFFF6, 0xFFC7, 0x000A, 0xFFDF, 0xFFFF,
    0x0010, 0x0007, 0x000E, 0xFFDA, 0xFFF3, 0x0020, 0x0041, 0xFFEF,
    0x0018, 0x0010, 0x000D, 0xFFF9, 0x0022, 0x0007, 0x001B, 0x001D,
    0x002F, 0x0002, 0x0013, 0xFFE5, 0xFFDF, 0xFFFA, 0x0038, 0x0006,
    0x0008, 0xFFF2, 0x0013, 0xFFEA, 0xFFD7, 0x0010, 0xFFF3, 0x002D,
    0x000E, 0x0006, 0xFFF2, 0x0004, 0x0025, 0xFFEC, 0x000C, 0xFFF9,
    0x0003, 0xFFE6, 0x0000, 0x0022, 0x0005, 0xFFEE, 0xFFC3, 0xFFF4,
    0x0020, 0xFFE8, 0xFFE8, 0xFFE3, 0xFFF6, 0x000E, 0x002F, 0x000E,
    0x002A, 0x0021, 0xFFEA, 0xFFFD, 0xFFFD, 0x0015, 0x0001, 0xFFF1,
    0xFFEF, 0x0027, 0xFFF2, 0xFFF1, 0x0017, 0x0013, 0xFFFD, 0xFFCE,
    0xFFE2, 0x0020, 0xFFF4, 0x000C, 0x001E, 0x0004, 0x0019, 0x0005,
    0xFFC4, 0xFFED, 0x000E, 0xFFF5, 0xFFFE, 0xFFF4, 0x0005, 0xFFEE,
    0xFFE1, 0x0009, 0x001A, 0xFFE8, 0xFFFE, 0xFFF6, 0xFFFB, 0x001B,
    0x002E, 0x0028, 0xFFFC, 0x002B, 0xFFD4, 0x001A, 0x000E, 0x000A,
    0x0006, 0xFFEE, 0xFFEC, 0x0030, 0x0008, 0x001B, 0x0026, 0xFFE3,
    0x0010, 0xFFE3, 0x0019, 0x0004, 0xFFE5, 0x0019, 0xFFEA, 0xFFF5,
    0xFFE8, 0xFFF0, 0xFFE1, 0xFFFF, 0xFFED, 0xFFF4, 0xFFE2, 0x001C,
    0x0008, 0x0024, 0xFFE5, 0x0004, 0xFFE1, 0xFFE3, 0x0004, 0x001C,
    0xFFDF, 0x0018, 0x000C, 0xFFFD, 0xFFF1, 0xFFF8, 0x000D, 0x002B,
    0xFFEF, 0x0002, 0xFFDB, 0x0009, 0x0012, 0x0025, 0xFFE3, 0xFFD9,
    0xFFF6, 0xFFFC, 0xFFEE, 0x0029, 0xFFFB, 0x0022, 0xFFCB, 0x0001,
    0xFFDF, 0x000E, 0x0020, 0xFFF2, 0x000C, 0xFFF7, 0xFFFA, 0xFFF2,
    0x0018, 0x0006, 0xFFEC, 0xFFED, 0xFFEE, 0x0003, 0xFFF3, 0xFFE0,
    0xFFE6, 0xFFF1, 0x002D, 0xFFFB, 0x001C, 0xFFD9, 0xFFFA, 0x003C,
    0x0008, 0x000C, 0x0024, 0xFFEE, 0x0000, 0x000D, 0xFFFC, 0x001D,
    0x0020, 0xFFED, 0x000D, 0x0013, 0x000D, 0x0021, 0xFFE0, 0x0008,
    0x001B, 0xFFEF, 0xFFF8, 0xFFF0, 0xFFFA, 0x000E, 0xFFDC, 0x0021,
    0xFFF8, 0xFFCD, 0x001A, 0xFFFF, 0xFFFC, 0x001F, 0xFFF9, 0x001C,
    0x0007, 0xFFCC, 0x0005, 0xFFFA, 0x000E, 0xFFE2, 0xFFFB, 0x0001,
    0x0004, 0xFFE6, 0x0008, 0xFFD5, 0x000D, 0x0003, 0x0009, 0xFFF8,
    0xFFF1, 0x0004, 0x000F, 0xFFF2, 0xFFF4, 0xFFE9, 0xFFCF, 0x0006,
    0xFFF5, 0xFFEC, 0x0001, 0x0000, 0xFFFE, 0x001A, 0x0036, 0xFFD7,
    0xFFE8, 0xFFE4, 0x0017, 0x000B, 0x0010, 0x0005, 0xFFE8, 0x000A,
    0xFFE6, 0xFFDA, 0xFFEE, 0x0055, 0x0015, 0xFFE3, 0x000E, 0x0001,
    0x0028, 0xFFE5, 0xFFFF, 0xFFE0, 0xFFF1, 0xFFC0, 0xFFF9, 0xFFED,
    0x0009, 0x2CD5, 0xFFCE, 0xFFE8, 0x0004, 0x002E, 0x0008, 0x0023,
    0x001A, 0x0011, 0xFFF8, 0x0017, 0xFFF5, 0x0024, 0x0001, 0xFFD3,
    0x0003, 0xFFC1, 0x001B, 0xFFE4, 0xFFFA, 0xFFEF, 0xFFEE, 0xFFE9,
    0xFFFC, 0xFFF7, 0x0028, 0x000F, 0x0005, 0x0031, 0xFFFE, 0xFFF9,
    0xFFF7, 0x0001, 0x0013, 0x0011, 0x000F, 0x0000, 0x0012, 0x0016,
    0x001C, 0x000B, 0x0021, 0x0019, 0x001B, 0xFFE9, 0x000B, 0x0011,
    0x0014, 0x0005, 0x0004, 0xFFD6, 0xFFEF, 0xFFEC, 0xFFDF, 0xFFEB,
    0xFFE3, 0x0018, 0xFFF0, 0xFFFA, 0x000E, 0x001F, 0xFFE6, 0x0017,
    0xFFDA, 0xFFED, 0xFFF4, 0xFFD7, 0xFFE6, 0x0004, 0x0005, 0x0006,
    0x0010, 0xFFEB, 0x0016, 0xFFF3, 0xFFF2, 0x0001, 0x000C, 0xFFE8,
    0x000A, 0xFFFA, 0x000D, 0x0003, 0x0024, 0x002A, 0xFFD6, 0x0011,
    0x0028, 0xFFE0, 0xFFDB, 0x0007, 0x001D, 0xFFF2, 0xFFFF, 0xFFF5,
    0xFFFC, 0xFFF3, 0xFFFB, 0x001F, 0x0024, 0xFFE2, 0x000D, 0x000D,
    0x0029, 0x001C, 0xFFC9, 0xFFFF, 0xFFD8, 0xFFF7, 0xFFE4, 0xFFE7,
    0x000E, 0xFFDA, 0x0007, 0xFFE9, 0x0027, 0xFFD1, 0x001F, 0x0024,
    0xFFF0, 0xFFE5, 0x0022, 0x0018, 0x0000, 0x0002, 0xFFE2, 0x0015,
    0xFFE9, 0xFFF4, 0xFFFB, 0x001F, 0xFFEB, 0x0015, 0xFFFC, 0x001B,
    0xFFFE, 0xFFEF, 0xFFE3, 0x0029, 0x0004, 0xFFDB, 0xFFFA, 0x0007,
    0xFFE9, 0x0034, 0xFFF6, 0xFFE9, 0xFFF2, 0x0017, 0x0006, 0x0007,
    0xFFEA, 0x0009, 0xFFFE, 0x0008, 0xFFF1, 0x0010, 0x000F, 0xFFFC,
    0x000E, 0xFFF4, 0x001A, 0x000D, 0xFFFD, 0x0012, 0xFFF8, 0xFFF6,
    0x0023, 0xFFF5, 0xFFD2, 0x0008, 0x0011, 0x000A, 0x0013, 0xFFDC,
    0x0015, 0xFFC5, 0x000F, 0x0029, 0xFFD7, 0xFFBA, 0x0026, 0xFFF9,
    0xFFFE, 0x001A, 0x0004, 0x000C, 0x0007, 0x0000, 0x003B, 0x0010,
    0x0018, 0xFFFE, 0xFFF7, 0xFFF1, 0xFFD7, 0xFFE0, 0x0002, 0xFFEF,
    0xFFD7, 0xFFF2, 0x000B, 0xFFEF, 0x000D, 0x0022, 0xFFF5, 0x0012,
    0xFFFA, 0x000D, 0xFFFA, 0xFFFE, 0xFFE8, 0x002F, 0x000F, 0xFFEE,
    0xFFF0, 0xFFF6, 0xFFF0, 0x0001, 0xFFF3, 0x001C, 0xFFD6, 0x0011,
    0x0006, 0xFFF4, 0xFFE8, 0x0035, 0xFFD2, 0x0018, 0xFFED, 0xFFC8,
    0xFFE7, 0x0015, 0xFFE0, 0xFFED, 0x0008, 0x0036, 0xFFF2, 0x001D,
    0x0026, 0xFFD9, 0x0014, 0x0005, 0xFFF5, 0x0006, 0x0008, 0xFFEE,
    0x0000, 0x000E, 0x001F, 0x0006, 0xFFE2, 0xFFF6, 0x001E, 0xFFEF,
    0x0001, 0xFFF5, 0xFFF1, 0x0010, 0x0019, 0x0009, 0xFFF9, 0xFFF7,
    0x0016, 0x0033, 0x000A, 0x0026, 0x0028, 0x0001, 0x0004, 0x0008,
    0x002A, 0xFFD3, 0xFFE9, 0x0023, 0xFFED, 0xFFE6, 0xFFFF, 0x0034,
    0x0004, 0x0002, 0xFFE9, 0x0005, 0x000C, 0x0022, 0xFFF4, 0xFFFB,
    0xFFF2, 0x0014, 0xFFEE, 0xFFFC, 0xFFEE, 0xFFF1, 0x0022, 0xFFF5,
    0x0017, 0x0002, 0xFFE1, 0x0003, 0x0010, 0x002B, 0xFFFD, 0x000F,
    0x0003, 0xFFED, 0x001B, 0xFFF7, 0xFFD7, 0x0040, 0xFFD0, 0x0048,
    0x0015, 0x0012, 0xFFF9, 0xFFF5, 0xFFF5, 0xFFFC, 0xFFF9, 0x0037,
    0x0007, 0x0021, 0x0007, 0x0040, 0x001B, 0x0019, 0xFFE6, 0x000B,
    0xFFF8, 0xFFDE, 0x0026, 0xFFD0, 0xFFEF, 0xFFF9, 0x0011, 0x000E,
    0x0010, 0xFFF1, 0x0004, 0x0016, 0xFFF5, 0xFFE9, 0x0039, 0x0006,
    0xFFB9, 0xFFF1, 0xFFC2, 0x001A, 0xFFF6, 0x004D, 0x0002, 0xFFF8,
    0xFFF3, 0x000C, 0xFFDD, 0x000D, 0xFFF3, 0xFFFA, 0x0001, 0xFFFF,
    0x000A, 0xFFCE, 0xFFE3, 0x0037, 0xFFE9, 0x0025, 0xFFF2, 0xFFED,
    0x0007, 0xFFFE, 0xFFF8, 0x0034, 0x0027, 0xFFE0, 0xFFF8, 0x0006,
    0x0005, 0xFFF8, 0x0008, 0x0008, 0xFFF8, 0x002B, 0xFFEC, 0xFFFF,
    0x0009, 0xFFE5, 0xFFBF, 0xFFDF, 0xFFE2, 0xFFCC, 0x001A, 0xFFF2,
    0x0012, 0xFFF3, 0xFFBF, 0xFFFD, 0xFFE0, 0x0009, 0x0020, 0xFFE9,
    0xFFEC, 0xFFFE, 0xFFE3, 0x0002, 0xFFF8, 0x000B, 0x0011, 0x000B,
    0x0004, 0xFFDF, 0x0005, 0x0003, 0x002C, 0xFFD6, 0xFFDB, 0xFFFA,
    0xFFE0, 0x001D, 0xFFCC, 0xFFE3, 0x001C, 0x003C, 0x0009, 0xFFD6,
    0x0023, 0x0015, 0x0015, 0xFFDE, 0xFFDD, 0x0036, 0x0013, 0x0015,
    0xFFF3, 0xFFF1, 0x0004, 0xFFF2, 0x000B, 0xFFFD, 0x0014, 0x0003,
    0x000D, 0x0003, 0x0007, 0x0031, 0x0017, 0xFFF1, 0x0003, 0xFFE4,
    0xFFE9, 0xFFB1, 0x0003, 0x000D, 0x0006, 0x001D, 0xFFFB, 0xFFF3,
    0xFFE9, 0x0008, 0x0003, 0x000A, 0xFFE7, 0xFFE2, 0xFFFC, 0xFFFF,
    0xFFF1, 0xFFE4, 0x000B, 0x000D, 0xFFD4, 0x0002, 0x003C, 0x0010,
    0x0029, 0x0006, 0x0032, 0xFFD7, 0xFFF2, 0x0019, 0xFFE6, 0x001F,
    0x0002, 0xFFD6, 0xFFF1, 0xFFFC, 0xFFF3, 0x0016, 0x0010, 0xFFF8,
    0x0008, 0xFFEA, 0x0007, 0x0011, 0x000A, 0xFFF2, 0xFFE3, 0x0028,
    0x0006, 0x0000, 0xFFFC, 0x0021, 0x002B, 0x0008, 0x0018, 0x001C,
    0xFFFB, 0x0006, 0xFFF1, 0x000D, 0x000A, 0x0006, 0xFFEB, 0xFFCE
    };

static const q15_t in_cfft_noisy_4096[8192] = {
    0x0992, 0x0000, 0x3CEE, 0x0000, 0x5AFC, 0x0000, 0x4498, 0x0000,
    0xFC69, 0x0000, 0xCC53, 0x0000, 0xA535, 0x0000, 0xC375, 0x0000,
    0xFEC8, 0x0000, 0x3825, 0x0000, 0x4F98, 0x0000, 0x45F6, 0x0000,
    0xFF7C, 0x0000, 0xC3CC, 0x0000, 0xA7A5, 0x0000, 0xBE60, 0x0000,
    0xFE78, 0x0000, 0x422A, 0x0000, 0x62BE, 0x0000, 0x357E, 0x0000,
    0x05BF, 0x0000, 0xB068, 0x0000, 0xAAAC, 0x0000, 0xBA77, 0x0000,
    0x023F, 0x0000, 0x4ACD, 0x0000, 0x5A07, 0x0000, 0x3E39, 0x0000,
    0x0A7E, 0x0000, 0xB8FF, 0x0000, 0xA474, 0x0000, 0xBF07, 0x0000,
    0xFE59, 0x0000, 0x3CFA, 0x0000, 0x5B1E, 0x0000, 0x362D, 0x0000,
    0xFD0A, 0x0000, 0xB9AD, 0x0000, 0xA43A, 0x0000, 0xBE0A, 0x0000,
    0x0A7C, 0x0000, 0x446B, 0x0000, 0x56DE, 0x0000, 0x3921, 0x0000,
    0x0160, 0x0000, 0xBFDD, 0x0000, 0xA6CD, 0x0000, 0xB919, 0x0000,
    0x03A9, 0x0000, 0x451F, 0x0000, 0x5627, 0x0000, 0x4CEB, 0x0000,
    0x0B98, 0x0000, 0xC3F7, 0x0000, 0xA6CD, 0x0000, 0xBB4B, 0x0000,
    0x011B, 0x0000, 0x3911, 0x0000, 0x580B, 0x0000, 0x45E7, 0x0000,
    0xF975, 0x0000, 0xBBA2, 0x0000, 0xAD5A, 0x0000, 0xBFF9, 0x0000,
    0xF3FA, 0x0000, 0x3951, 0x0000, 0x5A87, 0x0000, 0x4164, 0x0000,
    0x05BD, 0x0000, 0xBF40, 0x0000, 0xA4FD, 0x0000, 0xC48B, 0x0000,
    0xF31C, 0x0000, 0x4842, 0x0000, 0x601E, 0x0000, 0x3A90, 0x0000,
    0xF917, 0x0000, 0xD278, 0x0000, 0xA467, 0x0000, 0xC0A5, 0x0000,
    0xF431, 0x0000, 0x344B, 0x0000, 0x62A2, 0x0000, 0x3D88, 0x0000,
    0x07FF, 0x0000, 0xC19D, 0x0000, 0xA7AE, 0x0000, 0xB685, 0x0000,
    0xFF64, 0x0000, 0x31C2, 0x0000, 0x5A54, 0x0000, 0x3A60, 0x0000,
    0xF7FE, 0x0000, 0xB627, 0x0000, 0x9C33, 0x0000, 0xCA44, 0x0000,
    0xFC5F, 0x0000, 0x40E0, 0x0000, 0x5B43, 0x0000, 0x4196, 0x0000,
    0x02FD, 0x0000, 0xC0C7, 0x0000, 0xAF91, 0x0000, 0xC0DE, 0x0000,
    0xFDC9, 0x0000, 0x4527, 0x0000, 0x51E7, 0x0000, 0x4105, 0x0000,
    0xFAF0, 0x0000, 0xC3AC, 0x0000, 0xB202, 0x0000, 0xC2FB, 0x0000,
    0xF4C9, 0x0000, 0x49A7, 0x0000, 0x6A45, 0x0000, 0x4076, 0x0000,
    0x0313, 0x0000, 0xC2FD, 0x0000, 0x9EC3, 0x0000, 0xC0D1, 0x0000,
    0x00BA, 0x0000, 0x3FC1, 0x0000, 0x5859, 0x0000, 0x46D0, 0x0000,
    0x00EE, 0x0000, 0xBDC1, 0x0000, 0xA5D4, 0x0000, 0xC256, 0x0000,
    0x108A, 0x0000, 0x4733, 0x0000, 0x51D9, 0x0000, 0x3ACB, 0x0000,
    0xF1C4, 0x0000, 0xB756, 0x0000, 0xA0C4, 0x0000, 0xC52D, 0x0000,
    0x0284, 0x0000, 0x4198, 0x0000, 0x4CCD, 0x0000, 0x3F64, 0x0000,
    0xFC28, 0x0000, 0xBB85, 0x0000, 0x97AB, 0x0000, 0xD0F5, 0x0000,
    0xFA50, 0x0000, 0x3DAE, 0x0000, 0x580E, 0x0000, 0x3926, 0x0000,
    0x0294, 0x0000, 0xC4C5, 0x0000, 0xAA44, 0x0000, 0xBACF, 0x0000,
    0x0780, 0x0000, 0x3F31, 0x0000, 0x5E5E, 0x0000, 0x491E, 0x0000,
    0xFFE0, 0x0000, 0xBC5F, 0x0000, 0xA817, 0x0000, 0xBF9C, 0x0000,
    0xFE66, 0x0000, 0x46A9, 0x0000, 0x53E2, 0x0000, 0x4153, 0x0000,
    0xFE68, 0x0000, 0xC014, 0x0000, 0xA949, 0x0000, 0xC1CF, 0x0000,
    0xFF94, 0x0000, 0x3CBE, 0x0000, 0x6028, 0x0000, 0x3BA7, 0x0000,
    0xF56B, 0x0000, 0xBC6D, 0x0000, 0xA28F, 0x0000, 0xC45A, 0x0000,
    0x01C4, 0x0000, 0x455C, 0x0000, 0x5CBF, 0x0000, 0x3FE5, 0x0000,
    0x02E7, 0x0000, 0xC2D2, 0x0000, 0xA466, 0x0000, 0xB940, 0x0000,
    0xF65E, 0x0000, 0x3725, 0x0000, 0x558E, 0x0000, 0x313F, 0x0000,
    0xFC4B, 0x0000, 0xBF61, 0x0000, 0x97CE, 0x0000, 0xC39B, 0x0000,
    0xFEB0, 0x0000, 0x3D59, 0x0000, 0x57F3, 0x0000, 0x4103, 0x0000,
    0x0120, 0x0000, 0xC2EB, 0x0000, 0x9AB3, 0x0000, 0xC209, 0x0000,
    0xFEFA, 0x0000, 0x3EF0, 0x0000, 0x64F7, 0x0000, 0x4AD5, 0x0000,
    0xFF5A, 0x0000, 0xC63D, 0x0000, 0xACEC, 0x0000, 0xC04D, 0x0000,
    0x05E1, 0x0000, 0x3F80, 0x0000, 0x5A58, 0x0000, 0x43D4, 0x0000,
    0x0A58, 0x0000, 0xBA09, 0x0000, 0xAE9A, 0x0000, 0xC476, 0x0000,
    0xFA76, 0x0000, 0x36B6, 0x0000, 0x5A67, 0x0000, 0x410C, 0x0000,
    0x01ED, 0x0000, 0xCD52, 0x0000, 0xA3F7, 0x0000, 0xBD08, 0x0000,
    0x04A6, 0x0000, 0x40B7, 0x0000, 0x5442, 0x0000, 0x400E, 0x0000,
    0x0063, 0x0000, 0xBB93, 0x0000, 0xA6A6, 0x0000, 0xC4E5, 0x0000,
    0x0A78, 0x0000, 0x49BE, 0x0000, 0x5909, 0x0000, 0x42BB, 0x0000,
    0xF6F7, 0x0000, 0xC433, 0x0000, 0xA7C8, 0x0000, 0xC5F0, 0x0000,
    0x0AFA, 0x0000, 0x458D, 0x0000, 0x6096, 0x0000, 0x4AE6, 0x0000,
    0x05CE, 0x0000, 0xB7AC, 0x0000, 0xA1E0, 0x0000, 0xC035, 0x0000,
    0xFE10, 0x0000, 0x3391, 0x0000, 0x5ED0, 0x0000, 0x4242, 0x0000,
    0xF8C7, 0x0000, 0xB475, 0x0000, 0xAC26, 0x0000, 0xC059, 0x0000,
    0xF68B, 0x0000, 0x3DE0, 0x0000, 0x579B, 0x0000, 0x4AE0, 0x0000,
    0xFE77, 0x0000, 0xC748, 0x0000, 0xB0E8, 0x0000, 0xCA4E, 0x0000,
    0xFD38, 0x0000, 0x4D63, 0x0000, 0x62CF, 0x0000, 0x455D, 0x0000,
    0xFB2C, 0x0000, 0xC7B4, 0x0000, 0xA8DC, 0x0000, 0xBD28, 0x0000,
    0xF7B8, 0x0000, 0x3EFB, 0x0000, 0x545B, 0x0000, 0x441A, 0x0000,
    0x04C7, 0x0000, 0xBC8A, 0x0000, 0x98B7, 0x0000, 0xB5C5, 0x0000,
    0x077B, 0x0000, 0x4C02, 0x0000, 0x5808, 0x0000, 0x4199, 0x0000,
    0xFEF7, 0x0000, 0xC163, 0x0000, 0xA5D2, 0x0000, 0xB3B0, 0x0000,
    0x04FA, 0x0000, 0x41EE, 0x0000, 0x6180, 0x0000, 0x3376, 0x0000,
    0xF7BC, 0x0000, 0xBF46, 0x0000, 0xAC7B, 0x0000, 0xBCB8, 0x0000,
    0xFE39, 0x0000, 0x3D4A, 0x0000, 0x5128, 0x0000, 0x3BE9, 0x0000,
    0xF91A, 0x0000, 0xBFAC, 0x0000, 0x9D31, 0x0000, 0xB86B, 0x0000,
    0xFCA4, 0x0000, 0x486F, 0x0000, 0x509F, 0x0000, 0x448B, 0x0000,
    0xFBD3, 0x0000, 0xC254, 0x0000, 0xA726, 0x0000, 0xC29B, 0x0000,
    0x038B, 0x0000, 0x4639, 0x0000, 0x52A3, 0x0000, 0x48B1, 0x0000,
    0xFE07, 0x0000, 0xBBBA, 0x0000, 0xAAAF, 0x0000, 0xBE53, 0x0000,
    0x0526, 0x0000, 0x3F97, 0x0000, 0x546C, 0x0000, 0x4084, 0x0000,
    0xEF64, 0x0000, 0xBD7B, 0x0000, 0xA05A, 0x0000, 0xC1C2, 0x0000,
    0x068D, 0x0000, 0x41CF, 0x0000, 0x5651, 0x0000, 0x42D9, 0x0000,
    0x00CA, 0x0000, 0xB678, 0x0000, 0xA1F6, 0x0000, 0xC4F2, 0x0000,
    0x007C, 0x0000, 0x4934, 0x0000, 0x605F, 0x0000, 0x40F7, 0x0000,
    0xF654, 0x0000, 0xC574, 0x0000, 0xA53A, 0x0000, 0xBA9D, 0x0000,
    0x00D5, 0x0000, 0x395A, 0x0000, 0x54DD, 0x0000, 0x3DAB, 0x0000,
    0xFAA4, 0x0000, 0xB636, 0x0000, 0xA41F, 0x0000, 0xC42A, 0x0000,
    0x02D1, 0x0000, 0x41EB, 0x0000, 0x5C58, 0x0000, 0x405F, 0x0000,
    0xFAE1, 0x0000, 0xC98B, 0x0000, 0xACDB, 0x0000, 0xC125, 0x0000,
    0x05EA, 0x0000, 0x37AC, 0x0000, 0x52D7, 0x0000, 0x3F31, 0x0000,
    0x018D, 0x0000, 0xBDD7, 0x0000, 0x9DF8, 0x0000, 0xBC87, 0x0000,
    0xF6CA, 0x0000, 0x3C42, 0x0000, 0x5C75, 0x0000, 0x3BB3, 0x0000,
    0x08AC, 0x0000, 0xBA97, 0x0000, 0xA2B3, 0x0000, 0xBA60, 0x0000,
    0x0683, 0x0000, 0x4748, 0x0000, 0x546C, 0x0000, 0x332E, 0x0000,
    0x01FB, 0x0000, 0xB084, 0x0000, 0xAE10, 0x0000, 0xCA43, 0x0000,
    0xFBCA, 0x0000, 0x42B3, 0x0000, 0x58EA, 0x0000, 0x429D, 0x0000,
    0xF7A4, 0x0000, 0xC48A, 0x0000, 0xA77B, 0x0000, 0xBEB0, 0x0000,
    0x0B5A, 0x0000, 0x39D1, 0x0000, 0x52A0, 0x0000, 0x46A5, 0x0000,
    0x05BB, 0x0000, 0xBCE0, 0x0000, 0xA92A, 0x0000, 0xBEE4, 0x0000,
    0xFABA, 0x0000, 0x3B88, 0x0000, 0x55A7, 0x0000, 0x425B, 0x0000,
    0xF9B7, 0x0000, 0xC6F8, 0x0000, 0xAAAD, 0x0000, 0xC678, 0x0000,
    0x03CF, 0x0000, 0x39ED, 0x0000, 0x6096, 0x0000, 0x4AEC, 0x0000,
    0x074F, 0x0000, 0xC193, 0x0000, 0xAB38, 0x0000, 0xBC29, 0x0000,
    0x0602, 0x0000, 0x44CB, 0x0000, 0x57A6, 0x0000, 0x4021, 0x0000,
    0xFC12, 0x0000, 0xBBEC, 0x0000, 0xADF7, 0x0000, 0xC145, 0x0000,
    0x0F74, 0x0000, 0x3997, 0x0000, 0x5A42, 0x0000, 0x326B, 0x0000,
    0xFD9D, 0x0000, 0xB913, 0x0000, 0xA5F0, 0x0000, 0xCFF0, 0x0000,
    0x0697, 0x0000, 0x3F5B, 0x0000, 0x5B97, 0x0000, 0x413F, 0x0000,
    0x036D, 0x0000, 0xC529, 0x0000, 0xAFAC, 0x0000, 0xC8F6, 0x0000,
    0xF9A5, 0x0000, 0x4A27, 0x0000, 0x5286, 0x0000, 0x4241, 0x0000,
    0xFE66, 0x0000, 0xBA9C, 0x0000, 0xB4B9, 0x0000, 0xC08E, 0x0000,
    0x0A6E, 0x0000, 0x4060, 0x0000, 0x600E, 0x0000, 0x4752, 0x0000,
    0xFFD0, 0x0000, 0xBCA2, 0x0000, 0xA5D4, 0x0000, 0xC2F9, 0x0000,
    0x00B7, 0x0000, 0x3038, 0x0000, 0x6402, 0x0000, 0x4321, 0x0000,
    0xF894, 0x0000, 0xBAAD, 0x0000, 0x9F38, 0x0000, 0xCB85, 0x0000,
    0x0453, 0x0000, 0x439F, 0x0000, 0x5043, 0x0000, 0x4680, 0x0000,
    0xF629, 0x0000, 0xBA01, 0x0000, 0xA7D4, 0x0000, 0xBD86, 0x0000,
    0xFCD8, 0x0000, 0x3934, 0x0000, 0x566C, 0x0000, 0x3E8E, 0x0000,
    0x0000, 0x0000, 0xBB13, 0x0000, 0xA35B, 0x0000, 0xBE96, 0x0000,
    0x025D, 0x0000, 0x4491, 0x0000, 0x56CD, 0x0000, 0x435C, 0x0000,
    0x04BE, 0x0000, 0xC1A9, 0x0000, 0xA30C, 0x0000, 0xBAFC, 0x0000,
    0xFEBF, 0x0000, 0x3E8A, 0x0000, 0x5C46, 0x0000, 0x410B, 0x0000,
    0x0453, 0x0000, 0xC9A9, 0x0000, 0x9DB8, 0x0000, 0xB9C7, 0x0000,
    0x0106, 0x0000, 0x4707, 0x0000, 0x5D62, 0x0000, 0x39F1, 0x0000,
    0x09B6, 0x0000, 0xC477, 0x0000, 0xAE5D, 0x0000, 0xC202, 0x0000,
    0xF639, 0x0000, 0x3C48, 0x0000, 0x58D7, 0x0000, 0x3520, 0x0000,
    0xF3FD, 0x0000, 0xB537, 0x0000, 0xAF11, 0x0000, 0xC51D, 0x0000,
    0x01EB, 0x0000, 0x4240, 0x0000, 0x590C, 0x0000, 0x3D3B, 0x0000,
    0x00BC, 0x0000, 0xC251, 0x0000, 0xAF53, 0x0000, 0xBD2F, 0x0000,
    0xF3CC, 0x0000, 0x3E18, 0x0000, 0x616E, 0x0000, 0x3C2E, 0x0000,
    0x030B, 0x0000, 0xC57E, 0x0000, 0xA0E2, 0x0000, 0xBEBA, 0x0000,
    0x0151, 0x0000, 0x4540, 0x0000, 0x5D42, 0x0000, 0x4461, 0x0000,
    0xFEE0, 0x0000, 0xC4E6, 0x0000, 0xAA48, 0x0000, 0xBBAC, 0x0000,
    0x00A5, 0x0000, 0x4802, 0x0000, 0x6400, 0x0000, 0x3993, 0x0000,
    0x08CE, 0x0000, 0xB8F4, 0x0000, 0xA747, 0x0000, 0xC80E, 0x0000,
    0x0922, 0x0000, 0x39CE, 0x0000, 0x57C8, 0x0000, 0x4645, 0x0000,
    0x0222, 0x0000, 0xBE17, 0x0000, 0xA57D, 0x0000, 0xBD98, 0x0000,
    0x022B, 0x0000, 0x4B47, 0x0000, 0x5805, 0x0000, 0x4055, 0x0000,
    0x0A3F, 0x0000, 0xC9E8, 0x0000, 0xAAA2, 0x0000, 0xC3D7, 0x0000,
    0xFC7E, 0x0000, 0x3460, 0x0000, 0x59DB, 0x0000, 0x408E, 0x0000,
    0x0611, 0x0000, 0xBEE8, 0x0000, 0x9863, 0x0000, 0xCEF8, 0x0000,
    0xFA45, 0x0000, 0x38F0, 0x0000, 0x5CDB, 0x0000, 0x42F8, 0x0000,
    0xFD81, 0x0000, 0xB84A, 0x0000, 0xA2DC, 0x0000, 0xC8ED, 0x0000,
    0x00CA, 0x0000, 0x49F5, 0x0000, 0x5C4F, 0x0000, 0x49DA, 0x0000,
    0xFD13, 0x0000, 0xC29A, 0x0000, 0xA883, 0x0000, 0xC9D2, 0x0000,
    0xF975, 0x0000, 0x4544, 0x0000, 0x5DE7, 0x0000, 0x4B3F, 0x0000,
    0xF697, 0x0000, 0xB82F, 0x0000, 0xB1FA, 0x0000, 0xBEA1, 0x0000,
    0x00E9, 0x0000, 0x3C22, 0x0000, 0x538D, 0x0000, 0x4659, 0x0000,
    0x0A68, 0x0000, 0xBDFB, 0x0000, 0xA88A, 0x0000, 0xC575, 0x0000,
    0xFCCE, 0x0000, 0x3A01, 0x0000, 0x4F1E, 0x0000, 0x461D, 0x0000,
    0x019F, 0x0000, 0xC3E3, 0x0000, 0xA00D, 0x0000, 0xC3EA, 0x0000,
    0xFE89, 0x0000, 0x45CC, 0x0000, 0x5243, 0x0000, 0x3555, 0x0000,
    0x0713, 0x0000, 0xC41C, 0x0000, 0xADBC, 0x0000, 0xC71A, 0x0000,
    0xFCCD, 0x0000, 0x3DE4, 0x0000, 0x565A, 0x0000, 0x41C0, 0x0000,
    0x030F, 0x0000, 0xC39E, 0x0000, 0xA537, 0x0000, 0xB7A3, 0x0000,
    0xF615, 0x0000, 0x32B7, 0x0000, 0x5AAE, 0x0000, 0x3DA6, 0x0000,
    0x03D9, 0x0000, 0xBE05, 0x0000, 0xB13B, 0x0000, 0xC7B6, 0x0000,
    0x0622, 0x0000, 0x48C0, 0x0000, 0x5519, 0x0000, 0x3ECC, 0x0000,
    0x072A, 0x0000, 0xB784, 0x0000, 0xADFD, 0x0000, 0xC04F, 0x0000,
    0x034B, 0x0000, 0x3D66, 0x0000, 0x5BF4, 0x0000, 0x3B5D, 0x0000,
    0x02F7, 0x0000, 0xC504, 0x0000, 0xA0FB, 0x0000, 0xBD1A, 0x0000,
    0xFFDD, 0x0000, 0x4382, 0x0000, 0x58DA, 0x0000, 0x4CD0, 0x0000,
    0x032F, 0x0000, 0xC0CF, 0x0000, 0xAE5E, 0x0000, 0xBF95, 0x0000,
    0xF7CA, 0x0000, 0x3BCE, 0x0000, 0x4E6C, 0x0000, 0x3DBB, 0x0000,
    0x0730, 0x0000, 0xC8E4, 0x0000, 0xA9CD, 0x0000, 0xC40E, 0x0000,
    0xFB41, 0x0000, 0x3D84, 0x0000, 0x5692, 0x0000, 0x4371, 0x0000,
    0x0309, 0x0000, 0xC75C, 0x0000, 0xA529, 0x0000, 0xBE68, 0x0000,
    0xFED7, 0x0000, 0x4C4B, 0x0000, 0x5868, 0x0000, 0x4610, 0x0000,
    0x04A6, 0x0000, 0xBC76, 0x0000, 0xA734, 0x0000, 0xBC87, 0x0000,
    0xFB83, 0x0000, 0x3DEE, 0x0000, 0x540B, 0x0000, 0x409C, 0x0000,
    0x0004, 0x0000, 0xC2D1, 0x0000, 0xACCA, 0x0000, 0xBE65, 0x0000,
    0xFDA8, 0x0000, 0x3B23, 0x0000, 0x5560, 0x0000, 0x4555, 0x0000,
    0x0294, 0x0000, 0xC7AB, 0x0000, 0xA6E5, 0x0000, 0xBCD7, 0x0000,
    0xFA19, 0x0000, 0x4A47, 0x0000, 0x6215, 0x0000, 0x451D, 0x0000,
    0x0579, 0x0000, 0xC3E7, 0x0000, 0xAC6B, 0x0000, 0xBB16, 0x0000,
    0x0137, 0x0000, 0x3D7D, 0x0000, 0x59CB, 0x0000, 0x3D70, 0x0000,
    0x0719, 0x0000, 0xB649, 0x0000, 0xB3F3, 0x0000, 0xC596, 0x0000,
    0xF48C, 0x0000, 0x430B, 0x0000, 0x6903, 0x0000, 0x3A1A, 0x0000,
    0xFD10, 0x0000, 0xBBB3, 0x0000, 0xA2CA, 0x0000, 0xBE94, 0x0000,
    0xFA64, 0x0000, 0x450C, 0x0000, 0x5FF1, 0x0000, 0x3FD9, 0x0000,
    0x054C, 0x0000, 0xBFC7, 0x0000, 0xAC03, 0x0000, 0xC854, 0x0000,
    0x0252, 0x0000, 0x3FBF, 0x0000, 0x595B, 0x0000, 0x443F, 0x0000,
    0x08DC, 0x0000, 0xC1EB, 0x0000, 0xA6AC, 0x0000, 0xBBAF, 0x0000,
    0xEFCF, 0x0000, 0x3D93, 0x0000, 0x5978, 0x0000, 0x39AC, 0x0000,
    0xFE38, 0x0000, 0xC5B0, 0x0000, 0xA4F7, 0x0000, 0xBDC6, 0x0000,
    0xF133, 0x0000, 0x415F, 0x0000, 0x5CDC, 0x0000, 0x4427, 0x0000,
    0x05AD, 0x0000, 0xBAF3, 0x0000, 0xAFFA, 0x0000, 0xC7DD, 0x0000,
    0xF737, 0x0000, 0x484C, 0x0000, 0x5841, 0x0000, 0x421B, 0x0000,
    0xFCAC, 0x0000, 0xC343, 0x0000, 0xA33C, 0x0000, 0xB878, 0x0000,
    0xEF9F, 0x0000, 0x3FC8, 0x0000, 0x5325, 0x0000, 0x3C97, 0x0000,
    0xFE1E, 0x0000, 0xB7CD, 0x0000, 0xA39E, 0x0000, 0xB710, 0x0000,
    0x059F, 0x0000, 0x3E75, 0x0000, 0x60D4, 0x0000, 0x3A95, 0x0000,
    0x06F3, 0x0000, 0xC4FA, 0x0000, 0xA697, 0x0000, 0xC81D, 0x0000,
    0x0FC9, 0x0000, 0x3A48, 0x0000, 0x611B, 0x0000, 0x4260, 0x0000,
    0xF85D, 0x0000, 0xC13B, 0x0000, 0xAA6F, 0x0000, 0xBF03, 0x0000,
    0x09E8, 0x0000, 0x45B8, 0x0000, 0x551A, 0x0000, 0x3ECD, 0x0000,
    0xFC7D, 0x0000, 0xB531, 0x0000, 0xA760, 0x0000, 0xBB11, 0x0000,
    0xFE99, 0x0000, 0x4243, 0x0000, 0x58B6, 0x0000, 0x3686, 0x0000,
    0xF71E, 0x0000, 0xB40C, 0x0000, 0xA89E, 0x0000, 0xC370, 0x0000,
    0xF458, 0x0000, 0x49D1, 0x0000, 0x5A53, 0x0000, 0x458C, 0x0000,
    0xFE61, 0x0000, 0xC709, 0x0000, 0xAAAF, 0x0000, 0xCCF7, 0x0000,
    0x0146, 0x0000, 0x3CBA, 0x0000, 0x5AA0, 0x0000, 0x395B, 0x0000,
    0x00AE, 0x0000, 0xC558, 0x0000, 0xA47F, 0x0000, 0xBD84, 0x0000,
    0x0D79, 0x0000, 0x4011, 0x0000, 0x5A79, 0x0000, 0x3CFE, 0x0000,
    0xF679, 0x0000, 0xBAFD, 0x0000, 0xA265, 0x0000, 0xCB3E, 0x0000,
    0xFAE2, 0x0000, 0x440D, 0x0000, 0x5A24, 0x0000, 0x376A, 0x0000,
    0x04CF, 0x0000, 0xBA32, 0x0000, 0x9D47, 0x0000, 0xC348, 0x0000,
    0x00FA, 0x0000, 0x3CA4, 0x0000, 0x5D4D, 0x0000, 0x3E4A, 0x0000,
    0x055B, 0x0000, 0xBAE6, 0x0000, 0xA84E, 0x0000, 0xCB6A, 0x0000,
    0x08AF, 0x0000, 0x467F, 0x0000, 0x5342, 0x0000, 0x3E75, 0x0000,
    0x0422, 0x0000, 0xB339, 0x0000, 0x9C1C, 0x0000, 0xC2CD, 0x0000,
    0x010E, 0x0000, 0x42A6, 0x0000, 0x5EB2, 0x0000, 0x3A3D, 0x0000,
    0x00CE, 0x0000, 0xC1CB, 0x0000, 0xA92E, 0x0000, 0xC601, 0x0000,
    0x0500, 0x0000, 0x385B, 0x0000, 0x5922, 0x0000, 0x46E1, 0x0000,
    0xFC74, 0x0000, 0xC532, 0x0000, 0xB227, 0x0000, 0xC878, 0x0000,
    0x045F, 0x0000, 0x396B, 0x0000, 0x522E, 0x0000, 0x3B5F, 0x0000,
    0xFC66, 0x0000, 0xB830, 0x0000, 0xA46D, 0x0000, 0xB0A9, 0x0000,
    0x141C, 0x0000, 0x4A0D, 0x0000, 0x6363, 0x0000, 0x3BD5, 0x0000,
    0x024E, 0x0000, 0xCA2A, 0x0000, 0xA45B, 0x0000, 0xBA63, 0x0000,
    0xFA5D, 0x0000, 0x44D4, 0x0000, 0x5D81, 0x0000, 0x41F0, 0x0000,
    0x019B, 0x0000, 0xBBE9, 0x0000, 0xA54B, 0x0000, 0xC350, 0x0000,
    0x01E6, 0x0000, 0x4405, 0x0000, 0x4983, 0x0000, 0x4585, 0x0000,
    0x082E, 0x0000, 0xB970, 0x0000, 0xA08F, 0x0000, 0xB654, 0x0000,
    0xF92C, 0x0000, 0x3306, 0x0000, 0x5A45, 0x0000, 0x3F59, 0x0000,
    0x02A2, 0x0000, 0xB629, 0x0000, 0xA704, 0x0000, 0xC51D, 0x0000,
    0xF796, 0x0000, 0x3EF3, 0x0000, 0x55B3, 0x0000, 0x417E, 0x0000,
    0xFFBC, 0x0000, 0xBE98, 0x0000, 0xACE7, 0x0000, 0xBE5A, 0x0000,
    0xFCEB, 0x0000, 0x415F, 0x0000, 0x5309, 0x0000, 0x3805, 0x0000,
    0xF982, 0x0000, 0xC4E1, 0x0000, 0xA96E, 0x0000, 0xB7CB, 0x0000,
    0x04FB, 0x0000, 0x3F81, 0x0000, 0x53F2, 0x0000, 0x4709, 0x0000,
    0x001B, 0x0000, 0xBEA1, 0x0000, 0x9B29, 0x0000, 0xC204, 0x0000,
    0xFC56, 0x0000, 0x37D2, 0x0000, 0x5003, 0x0000, 0x3F21, 0x0000,
    0x01C7, 0x0000, 0xC58A, 0x0000, 0xA64B, 0x0000, 0xB920, 0x0000,
    0xF486, 0x0000, 0x3E32, 0x0000, 0x544B, 0x0000, 0x3E31, 0x0000,
    0xFC63, 0x0000, 0xC7D8, 0x0000, 0xA4F0, 0x0000, 0xC939, 0x0000,
    0xFDC0, 0x0000, 0x3EA8, 0x0000, 0x60B2, 0x0000, 0x375F, 0x0000,
    0x01BC, 0x0000, 0xC7D2, 0x0000, 0xAA98, 0x0000, 0xBFCE, 0x0000,
    0xFCF0, 0x0000, 0x4988, 0x0000, 0x5693, 0x0000, 0x48BE, 0x0000,
    0x09EA, 0x0000, 0xC47D, 0x0000, 0xA640, 0x0000, 0xC0E6, 0x0000,
    0x0175, 0x0000, 0x3F06, 0x0000, 0x55BC, 0x0000, 0x3BF8, 0x0000,
    0x03AD, 0x0000, 0xBFA4, 0x0000, 0xA457, 0x0000, 0xBC1B, 0x0000,
    0x04A0, 0x0000, 0x3E3E, 0x0000, 0x57C0, 0x0000, 0x46B4, 0x0000,
    0xFC91, 0x0000, 0xC0FC, 0x0000, 0xB0AB, 0x0000, 0xC135, 0x0000,
    0xFEF5, 0x0000, 0x416E, 0x0000, 0x60D4, 0x0000, 0x40B6, 0x0000,
    0xFFD6, 0x0000, 0xC3D0, 0x0000, 0xB862, 0x0000, 0xC404, 0x0000,
    0x028C, 0x0000, 0x3EBF, 0x0000, 0x617B, 0x0000, 0x4314, 0x0000,
    0xFF07, 0x0000, 0xBFBB, 0x0000, 0x9E50, 0x0000, 0xC562, 0x0000,
    0xFF21, 0x0000, 0x4545, 0x0000, 0x5B67, 0x0000, 0x444A, 0x0000,
    0xF8F8, 0x0000, 0xCDFB, 0x0000, 0xA88F, 0x0000, 0xB9D7, 0x0000,
    0x00E6, 0x0000, 0x365B, 0x0000, 0x5686, 0x0000, 0x4662, 0x0000,
    0xFC8A, 0x0000, 0xC8A2, 0x0000, 0xB4B0, 0x0000, 0xC182, 0x0000,
    0xFF8D, 0x0000, 0x3D0F, 0x0000, 0x551D, 0x0000, 0x3FAD, 0x0000,
    0x0AE5, 0x0000, 0xB682, 0x0000, 0xAAFC, 0x0000, 0xBA3C, 0x0000,
    0xF87C, 0x0000, 0x546B, 0x0000, 0x4E26, 0x0000, 0x3EF4, 0x0000,
    0x086F, 0x0000, 0xC3A8, 0x0000, 0xAE7B, 0x0000, 0xC3BB, 0x0000,
    0x0314, 0x0000, 0x433E, 0x0000, 0x4BC2, 0x0000, 0x49A9, 0x0000,
    0xF9D8, 0x0000, 0xBA30, 0x0000, 0x9BDC, 0x0000, 0xBE35, 0x0000,
    0xFD78, 0x0000, 0x3E39, 0x0000, 0x606F, 0x0000, 0x3AD2, 0x0000,
    0xF9B6, 0x0000, 0xB97A, 0x0000, 0xA7E7, 0x0000, 0xBFFD, 0x0000,
    0x0790, 0x0000, 0x3948, 0x0000, 0x5C5E, 0x0000, 0x4DFC, 0x0000,
    0x0474, 0x0000, 0xC200, 0x0000, 0xB172, 0x0000, 0xBB9D, 0x0000,
    0x0902, 0x0000, 0x4B3E, 0x0000, 0x620B, 0x0000, 0x4616, 0x0000,
    0x0281, 0x0000, 0xC5CB, 0x0000, 0xA96C, 0x0000, 0xBDC8, 0x0000,
    0x06E7, 0x0000, 0x45B8, 0x0000, 0x5FCC, 0x0000, 0x4258, 0x0000,
    0xFFB8, 0x0000, 0xB5BC, 0x0000, 0xAC2B, 0x0000, 0xBFB0, 0x0000,
    0xFFDB, 0x0000, 0x4276, 0x0000, 0x58AC, 0x0000, 0x453D, 0x0000,
    0xF8D4, 0x0000, 0xB908, 0x0000, 0xA6C0, 0x0000, 0xC174, 0x0000,
    0xF8EC, 0x0000, 0x3E6E, 0x0000, 0x5E2C, 0x0000, 0x4167, 0x0000,
    0xFD65, 0x0000, 0xC008, 0x0000, 0xAE07, 0x0000, 0xB89A, 0x0000,
    0x00A7, 0x0000, 0x460B, 0x0000, 0x50D7, 0x0000, 0x3F8A, 0x0000,
    0x072C, 0x0000, 0xC19A, 0x0000, 0xA336, 0x0000, 0xC99D, 0x0000,
    0x0ADB, 0x0000, 0x43F3, 0x0000, 0x5610, 0x0000, 0x3C70, 0x0000,
    0xFD01, 0x0000, 0xBF7A, 0x0000, 0xA943, 0x0000, 0xBD10, 0x0000,
    0xFED7, 0x0000, 0x3BDD, 0x0000, 0x57F8, 0x0000, 0x3C9B, 0x0000,
    0xFCA7, 0x0000, 0xC8A1, 0x0000, 0x9F88, 0x0000, 0xC4E3, 0x0000,
    0xFC22, 0x0000, 0x3F4C, 0x0000, 0x5B58, 0x0000, 0x419E, 0x0000,
    0x0599, 0x0000, 0xBD41, 0x0000, 0xA498, 0x0000, 0xC066, 0x0000,
    0xFFE2, 0x0000, 0x4421, 0x0000, 0x5209, 0x0000, 0x395F, 0x0000,
    0xFC92, 0x0000, 0xBB29, 0x0000, 0xADF9, 0x0000, 0xC267, 0x0000,
    0xFEC5, 0x0000, 0x3DA7, 0x0000, 0x62CD, 0x0000, 0x3C7E, 0x0000,
    0x031F, 0x0000, 0xC181, 0x0000, 0xA0F0, 0x0000, 0xC4CC, 0x0000,
    0xF698, 0x0000, 0x456B, 0x0000, 0x5BF9, 0x0000, 0x465F, 0x0000,
    0x0039, 0x0000, 0xC1DF, 0x0000, 0xAB09, 0x0000, 0xB9BD, 0x0000,
    0x0BE3, 0x0000, 0x3D7C, 0x0000, 0x59D8, 0x0000, 0x41F7, 0x0000,
    0x036B, 0x0000, 0xC1DD, 0x0000, 0xAE66, 0x0000, 0xC029, 0x0000,
    0x053F, 0x0000, 0x3B7C, 0x0000, 0x5617, 0x0000, 0x42AE, 0x0000,
    0x028A, 0x0000, 0xBC92, 0x0000, 0xA10B, 0x0000, 0xC0BF, 0x0000,
    0x0301, 0x0000, 0x3810, 0x0000, 0x57E5, 0x0000, 0x3A40, 0x0000,
    0x0E42, 0x0000, 0xC701, 0x0000, 0xA770, 0x0000, 0xCF08, 0x0000,
    0x030D, 0x0000, 0x4139, 0x0000, 0x4910, 0x0000, 0x4471, 0x0000,
    0xF6D6, 0x0000, 0xBF9E, 0x0000, 0xA694, 0x0000, 0xB84C, 0x0000,
    0x0103, 0x0000, 0x4B36, 0x0000, 0x607D, 0x0000, 0x354E, 0x0000,
    0xF925, 0x0000, 0xC07B, 0x0000, 0xA16C, 0x0000, 0xCB89, 0x0000,
    0x00AD, 0x0000, 0x4790, 0x0000, 0x5EBB, 0x0000, 0x4055, 0x0000,
    0x0DAB, 0x0000, 0xC582, 0x0000, 0xA316, 0x0000, 0xC528, 0x0000,
    0x05F2, 0x0000, 0x47BC, 0x0000, 0x6199, 0x0000, 0x3EFC, 0x0000,
    0xFCDF, 0x0000, 0xC7B0, 0x0000, 0xA8B6, 0x0000, 0xB705, 0x0000,
    0xFCA9, 0x0000, 0x3F5C, 0x0000, 0x53A7, 0x0000, 0x403C, 0x0000,
    0x03AD, 0x0000, 0xCA68, 0x0000, 0x968B, 0x0000, 0xC132, 0x0000,
    0xFCA4, 0x0000, 0x3A9A, 0x0000, 0x5D45, 0x0000, 0x3BD6, 0x0000,
    0xFABA, 0x0000, 0xBC7B, 0x0000, 0xB1FB, 0x0000, 0xC1F1, 0x0000,
    0xFD5E, 0x0000, 0x3430, 0x0000, 0x5574, 0x0000, 0x4112, 0x0000,
    0xFA98, 0x0000, 0xC2F3, 0x0000, 0xAD4B, 0x0000, 0xB241, 0x0000,
    0x0471, 0x0000, 0x4642, 0x0000, 0x5D46, 0x0000, 0x3B5E, 0x0000,
    0xFF78, 0x0000, 0xCA62, 0x0000, 0xA7BE, 0x0000, 0xC672, 0x0000,
    0xF1E2, 0x0000, 0x3C6C, 0x0000, 0x4E48, 0x0000, 0x3973, 0x0000,
    0xFEA6, 0x0000, 0xC5E6, 0x0000, 0xACA0, 0x0000, 0xBB4D, 0x0000,
    0x0495, 0x0000, 0x3819, 0x0000, 0x56C2, 0x0000, 0x36FB, 0x0000,
    0x0384, 0x0000, 0xC7CD, 0x0000, 0xAABA, 0x0000, 0xC333, 0x0000,
    0x0091, 0x0000, 0x4B49, 0x0000, 0x60CC, 0x0000, 0x3FED, 0x0000,
    0xFD8B, 0x0000, 0xC4F3, 0x0000, 0xABD5, 0x0000, 0xB844, 0x0000,
    0xF908, 0x0000, 0x3869, 0x0000, 0x5F85, 0x0000, 0x43F3, 0x0000,
    0xFD56, 0x0000, 0xB740, 0x0000, 0xB356, 0x0000, 0xC8AF, 0x0000,
    0x10FE, 0x0000, 0x420A, 0x0000, 0x52CF, 0x0000, 0x401A, 0x0000,
    0xFE88, 0x0000, 0xBC7B, 0x0000, 0xA3C0, 0x0000, 0xC171, 0x0000,
    0xFA84, 0x0000, 0x3CDB, 0x0000, 0x5DC5, 0x0000, 0x3CB4, 0x0000,
    0x04F1, 0x0000, 0xBAC9, 0x0000, 0x9F2D, 0x0000, 0xC6F2, 0x0000,
    0xF821, 0x0000, 0x4564, 0x0000, 0x5538, 0x0000, 0x4289, 0x0000,
    0xF8CE, 0x0000, 0xC328, 0x0000, 0xAEC9, 0x0000, 0xC4AE, 0x0000,
    0x006C, 0x0000, 0x3FB1, 0x0000, 0x5651, 0x0000, 0x4026, 0x0000,
    0x02C3, 0x0000, 0xB60B, 0x0000, 0xA516, 0x0000, 0xB9A6, 0x0000,
    0xF7B1, 0x0000, 0x3B52, 0x0000, 0x52C7, 0x0000, 0x4579, 0x0000,
    0x0336, 0x0000, 0xCAA0, 0x0000, 0xA22D, 0x0000, 0xBEFB, 0x0000,
    0x040A, 0x0000, 0x3A67, 0x0000, 0x5938, 0x0000, 0x410E, 0x0000,
    0xFEFC, 0x0000, 0xC7C7, 0x0000, 0xAA6A, 0x0000, 0xBCAF, 0x0000,
    0xFD67, 0x0000, 0x419D, 0x0000, 0x4A1B, 0x0000, 0x4A5B, 0x0000,
    0x043A, 0x0000, 0xBA31, 0x0000, 0xADB2, 0x0000, 0xC7EB, 0x0000,
    0xFDFA, 0x0000, 0x3F11, 0x0000, 0x5C0F, 0x0000, 0x414A, 0x0000,
    0x05A0, 0x0000, 0xC23F, 0x0000, 0xA98B, 0x0000, 0xBD08, 0x0000,
    0xFA91, 0x0000, 0x3FE4, 0x0000, 0x57BF, 0x0000, 0x4100, 0x0000,
    0xFC84, 0x0000, 0xC2C8, 0x0000, 0xA4B8, 0x0000, 0xC1BA, 0x0000,
    0x0514, 0x0000, 0x3D62, 0x0000, 0x5A7C, 0x0000, 0x418E, 0x0000,
    0xEFE4, 0x0000, 0xB958, 0x0000, 0xA1CB, 0x0000, 0xC55B, 0x0000,
    0x0735, 0x0000, 0x38B0, 0x0000, 0x4DEC, 0x0000, 0x34AE, 0x0000,
    0xFB8D, 0x0000, 0xC20D, 0x0000, 0xA941, 0x0000, 0xC1AC, 0x0000,
    0x01AA, 0x0000, 0x3876, 0x0000, 0x6408, 0x0000, 0x418E, 0x0000,
    0x0E75, 0x0000, 0xC41F, 0x0000, 0xADBB, 0x0000, 0xB93D, 0x0000,
    0xFCF7, 0x0000, 0x3A75, 0x0000, 0x5760, 0x0000, 0x3DDA, 0x0000,
    0x0519, 0x0000, 0xCC93, 0x0000, 0x9FAC, 0x0000, 0xBADE, 0x0000,
    0xFBFA, 0x0000, 0x41A8, 0x0000, 0x656F, 0x0000, 0x3B5F, 0x0000,
    0x09A7, 0x0000, 0xC582, 0x0000, 0xA6E2, 0x0000, 0xB2C7, 0x0000,
    0x0A82, 0x0000, 0x4456, 0x0000, 0x69E9, 0x0000, 0x3919, 0x0000,
    0x00D3, 0x0000, 0xC0BC, 0x0000, 0xABFC, 0x0000, 0xBBE6, 0x0000,
    0xF674, 0x0000, 0x42AC, 0x0000, 0x5B4F, 0x0000, 0x4515, 0x0000,
    0x046F, 0x0000, 0xCAFA, 0x0000, 0xA6E3, 0x0000, 0xC65F, 0x0000,
    0x0C48, 0x0000, 0x38CB, 0x0000, 0x53CC, 0x0000, 0x3C52, 0x0000,
    0xF635, 0x0000, 0xCC58, 0x0000, 0xA96C, 0x0000, 0xB98C, 0x0000,
    0xFFFA, 0x0000, 0x42B5, 0x0000, 0x5B24, 0x0000, 0x366F, 0x0000,
    0xFF19, 0x0000, 0xC35A, 0x0000, 0xA632, 0x0000, 0xBD83, 0x0000,
    0xFCEF, 0x0000, 0x41D8, 0x0000, 0x573E, 0x0000, 0x49BA, 0x0000,
    0x039C, 0x0000, 0xB90C, 0x0000, 0xA058, 0x0000, 0xC0E6, 0x0000,
    0x0128, 0x0000, 0x399D, 0x0000, 0x501F, 0x0000, 0x41C8, 0x0000,
    0x0A91, 0x0000, 0xBD4D, 0x0000, 0x9B1B, 0x0000, 0xBF0F, 0x0000,
    0xFA4C, 0x0000, 0x3C11, 0x0000, 0x58A8, 0x0000, 0x4AD5, 0x0000,
    0xFC21, 0x0000, 0xB67B, 0x0000, 0xAC38, 0x0000, 0xC7F9, 0x0000,
    0x0377, 0x0000, 0x4455, 0x0000, 0x5BAC, 0x0000, 0x4607, 0x0000,
    0xFD86, 0x0000, 0xC4F2, 0x0000, 0xABDE, 0x0000, 0xBEE5, 0x0000,
    0x0657, 0x0000, 0x456B, 0x0000, 0x5B7E, 0x0000, 0x4DAA, 0x0000,
    0xFC3B, 0x0000, 0xC0E2, 0x0000, 0xB25B, 0x0000, 0xC5BA, 0x0000,
    0x0A51, 0x0000, 0x3786, 0x0000, 0x5D53, 0x0000, 0x3B0B, 0x0000,
    0x0419, 0x0000, 0xC023, 0x0000, 0xAE17, 0x0000, 0xC223, 0x0000,
    0xFAAD, 0x0000, 0x36EB, 0x0000, 0x59EE, 0x0000, 0x3FA5, 0x0000,
    0x05BA, 0x0000, 0xC675, 0x0000, 0xA39E, 0x0000, 0xBADB, 0x0000,
    0xF97F, 0x0000, 0x3D09, 0x0000, 0x58C2, 0x0000, 0x3B18, 0x0000,
    0x041C, 0x0000, 0xC9DC, 0x0000, 0xA5A3, 0x0000, 0xD011, 0x0000,
    0xFEFF, 0x0000, 0x33FA, 0x0000, 0x58B9, 0x0000, 0x3DD4, 0x0000,
    0x057A, 0x0000, 0xD072, 0x0000, 0xABDA, 0x0000, 0xBCB1, 0x0000,
    0x0945, 0x0000, 0x427F, 0x0000, 0x6110, 0x0000, 0x4460, 0x0000,
    0x01EF, 0x0000, 0xC6E7, 0x0000, 0xA5D0, 0x0000, 0xC557, 0x0000,
    0xFB5C, 0x0000, 0x4A3E, 0x0000, 0x5DAF, 0x0000, 0x3EEC, 0x0000,
    0xFB2C, 0x0000, 0xC379, 0x0000, 0xAC26, 0x0000, 0xC35D, 0x0000,
    0x0210, 0x0000, 0x3AFE, 0x0000, 0x5D52, 0x0000, 0x4370, 0x0000,
    0x0253, 0x0000, 0xCED9, 0x0000, 0x9E68, 0x0000, 0xCEEC, 0x0000,
    0x1211, 0x0000, 0x4923, 0x0000, 0x542D, 0x0000, 0x393E, 0x0000,
    0xFDC0, 0x0000, 0xB4CD, 0x0000, 0xA834, 0x0000, 0xC2D3, 0x0000,
    0xFA6E, 0x0000, 0x492A, 0x0000, 0x6354, 0x0000, 0x40FE, 0x0000,
    0x018E, 0x0000, 0xBA37, 0x0000, 0xA8E4, 0x0000, 0xBF3B, 0x0000,
    0xF7D0, 0x0000, 0x40B4, 0x0000, 0x57E2, 0x0000, 0x4907, 0x0000,
    0x016C, 0x0000, 0xBEBD, 0x0000, 0x9AA9, 0x0000, 0xC484, 0x0000,
    0x01C2, 0x0000, 0x43B1, 0x0000, 0x5FEA, 0x0000, 0x46C6, 0x0000,
    0xFF1C, 0x0000, 0xBD7C, 0x0000, 0xA077, 0x0000, 0xC4EA, 0x0000,
    0x0083, 0x0000, 0x43D6, 0x0000, 0x5A28, 0x0000, 0x3FFC, 0x0000,
    0xEF33, 0x0000, 0xB825, 0x0000, 0xA56F, 0x0000, 0xC49E, 0x0000,
    0xFADC, 0x0000, 0x459D, 0x0000, 0x5717, 0x0000, 0x4186, 0x0000,
    0x0035, 0x0000, 0xBA92, 0x0000, 0xAB29, 0x0000, 0xC6E0, 0x0000,
    0xFE4B, 0x0000, 0x4608, 0x0000, 0x5602, 0x0000, 0x4A2A, 0x0000,
    0x00D5, 0x0000, 0xC180, 0x0000, 0xA754, 0x0000, 0xC1A4, 0x0000,
    0xFA24, 0x0000, 0x3A07, 0x0000, 0x5FA9, 0x0000, 0x3645, 0x0000,
    0xF5D9, 0x0000, 0xC790, 0x0000, 0xA5CF, 0x0000, 0xB8B9, 0x0000,
    0x0BFB, 0x0000, 0x38CF, 0x0000, 0x5471, 0x0000, 0x428D, 0x0000,
    0xFEA2, 0x0000, 0xC50A, 0x0000, 0xAA0F, 0x0000, 0xC24D, 0x0000,
    0xFA5B, 0x0000, 0x4424, 0x0000, 0x5E9C, 0x0000, 0x4088, 0x0000,
    0xFA11, 0x0000, 0xC287, 0x0000, 0xA0CD, 0x0000, 0xBDAC, 0x0000,
    0x00F6, 0x0000, 0x3C92, 0x0000, 0x616A, 0x0000, 0x428A, 0x0000,
    0x0101, 0x0000, 0xC0F5, 0x0000, 0xA62D, 0x0000, 0xB2E9, 0x0000,
    0x03DD, 0x0000, 0x3739, 0x0000, 0x632B, 0x0000, 0x3CF2, 0x0000,
    0x0408, 0x0000, 0xBCB6, 0x0000, 0xAAB0, 0x0000, 0xC60A, 0x0000,
    0xF91F, 0x0000, 0x3FD5, 0x0000, 0x5CAE, 0x0000, 0x3D83, 0x0000,
    0x0DC6, 0x0000, 0xBF0E, 0x0000, 0x9BE4, 0x0000, 0xBFBA, 0x0000,
    0x032E, 0x0000, 0x3A3D, 0x0000, 0x5FD5, 0x0000, 0x41C5, 0x0000,
    0x01B3, 0x0000, 0xC338, 0x0000, 0xA5B3, 0x0000, 0xC31B, 0x0000,
    0xFDC5, 0x0000, 0x45F1, 0x0000, 0x5929, 0x0000, 0x3C19, 0x0000,
    0xFDEF, 0x0000, 0xC1DB, 0x0000, 0xA40B, 0x0000, 0xBF4F, 0x0000,
    0x008C, 0x0000, 0x44B6, 0x0000, 0x5685, 0x0000, 0x460E, 0x0000,
    0x01FE, 0x0000, 0xC8BE, 0x0000, 0xAD37, 0x0000, 0xC39B, 0x0000,
    0xFEE9, 0x0000, 0x4057, 0x0000, 0x5411, 0x0000, 0x3063, 0x0000,
    0x06D5, 0x0000, 0xC003, 0x0000, 0xA587, 0x0000, 0xC191, 0x0000,
    0x05C5, 0x0000, 0x4218, 0x0000, 0x5D61, 0x0000, 0x3AC8, 0x0000,
    0x03AF, 0x0000, 0xBD2D, 0x0000, 0xAE24, 0x0000, 0xBDE6, 0x0000,
    0xF47C, 0x0000, 0x449E, 0x0000, 0x5A7F, 0x0000, 0x4B61, 0x0000,
    0x014B, 0x0000, 0xC862, 0x0000, 0x9FD7, 0x0000, 0xC624, 0x0000,
    0xFCC9, 0x0000, 0x408E, 0x0000, 0x69EE, 0x0000, 0x432C, 0x0000,
    0x0673, 0x0000, 0xBF3E, 0x0000, 0xA44E, 0x0000, 0xB8E9, 0x0000,
    0x0450, 0x0000, 0x437D, 0x0000, 0x6050, 0x0000, 0x3DA0, 0x0000,
    0xFAEA, 0x0000, 0xC22E, 0x0000, 0xB50A, 0x0000, 0xC3C6, 0x0000,
    0x0665, 0x0000, 0x38DF, 0x0000, 0x56E9, 0x0000, 0x4016, 0x0000,
    0x0521, 0x0000, 0xC13B, 0x0000, 0x9A04, 0x0000, 0xC0F6, 0x0000,
    0xF6B6, 0x0000, 0x3CC1, 0x0000, 0x5346, 0x0000, 0x47F7, 0x0000,
    0x080C, 0x0000, 0xC20B, 0x0000, 0xA250, 0x0000, 0xB2FB, 0x0000,
    0xF5AD, 0x0000, 0x39F5, 0x0000, 0x5C6A, 0x0000, 0x3ED5, 0x0000,
    0xFA47, 0x0000, 0xC138, 0x0000, 0xA5A9, 0x0000, 0xCB77, 0x0000,
    0xFB2F, 0x0000, 0x4654, 0x0000, 0x628E, 0x0000, 0x3E1A, 0x0000,
    0x0081, 0x0000, 0xC647, 0x0000, 0xB227, 0x0000, 0xBDA2, 0x0000,
    0x0C83, 0x0000, 0x3EBB, 0x0000, 0x5F88, 0x0000, 0x400A, 0x0000,
    0x03D8, 0x0000, 0xCEC0, 0x0000, 0xA90D, 0x0000, 0xB792, 0x0000,
    0xFD2E, 0x0000, 0x3483, 0x0000, 0x5A69, 0x0000, 0x4279, 0x0000,
    0x0513, 0x0000, 0xBC1D, 0x0000, 0xA42A, 0x0000, 0xC251, 0x0000,
    0x0785, 0x0000, 0x4165, 0x0000, 0x5B3E, 0x0000, 0x380D, 0x0000,
    0x017B, 0x0000, 0xC6CD, 0x0000, 0xA486, 0x0000, 0xC48F, 0x0000,
    0xF52F, 0x0000, 0x3C72, 0x0000, 0x572F, 0x0000, 0x3A37, 0x0000,
    0xFAD4, 0x0000, 0xBE03, 0x0000, 0x9B7C, 0x0000, 0xC358, 0x0000,
    0x01D2, 0x0000, 0x3D2C, 0x0000, 0x6292, 0x0000, 0x3E2E, 0x0000,
    0x0835, 0x0000, 0xB5EC, 0x0000, 0xA847, 0x0000, 0xC588, 0x0000,
    0x063A, 0x0000, 0x3BCD, 0x0000, 0x6609, 0x0000, 0x3834, 0x0000,
    0xF6DC, 0x0000, 0xBEA2, 0x0000, 0x9D88, 0x0000, 0xBCE3, 0x0000,
    0xFB0B, 0x0000, 0x34EE, 0x0000, 0x56DA, 0x0000, 0x4A28, 0x0000,
    0x02FC, 0x0000, 0xC034, 0x0000, 0xAC30, 0x0000, 0xB4B9, 0x0000,
    0x01AA, 0x0000, 0x3EA8, 0x0000, 0x570D, 0x0000, 0x42F6, 0x0000,
    0xFFBF, 0x0000, 0xC215, 0x0000, 0xA86A, 0x0000, 0xB361, 0x0000,
    0xF6CE, 0x0000, 0x47E4, 0x0000, 0x5838, 0x0000, 0x3A8A, 0x0000,
    0xFC11, 0x0000, 0xC4CD, 0x0000, 0xA99C, 0x0000, 0xB803, 0x0000,
    0x0920, 0x0000, 0x3C96, 0x0000, 0x56D3, 0x0000, 0x3B00, 0x0000,
    0xFE40, 0x0000, 0xB0F3, 0x0000, 0x9F9B, 0x0000, 0xC142, 0x0000,
    0x030C, 0x0000, 0x3FB8, 0x0000, 0x6036, 0x0000, 0x45EE, 0x0000,
    0x00C1, 0x0000, 0xC6DD, 0x0000, 0xA2D0, 0x0000, 0xC416, 0x0000,
    0x07DE, 0x0000, 0x431E, 0x0000, 0x50DD, 0x0000, 0x3FB3, 0x0000,
    0x0231, 0x0000, 0xC055, 0x0000, 0xA83A, 0x0000, 0xC399, 0x0000,
    0x0710, 0x0000, 0x46FE, 0x0000, 0x5948, 0x0000, 0x3867, 0x0000,
    0xF896, 0x0000, 0xC119, 0x0000, 0xA4C0, 0x0000, 0xC0D3, 0x0000,
    0xFEA0, 0x0000, 0x39F1, 0x0000, 0x5416, 0x0000, 0x4798, 0x0000,
    0x03D3, 0x0000, 0xC3EC, 0x0000, 0xA69A, 0x0000, 0xC7F1, 0x0000,
    0xFB77, 0x0000, 0x45B3, 0x0000, 0x6871, 0x0000, 0x3E75, 0x0000,
    0x0B0C, 0x0000, 0xBFA7, 0x0000, 0x9C19, 0x0000, 0xC65C, 0x0000,
    0xEF63, 0x0000, 0x32F9, 0x0000, 0x60B7, 0x0000, 0x3DEF, 0x0000,
    0xFF79, 0x0000, 0xC29C, 0x0000, 0xAA1C, 0x0000, 0xC39B, 0x0000,
    0xFFE1, 0x0000, 0x48B9, 0x0000, 0x59A4, 0x0000, 0x3975, 0x0000,
    0xFD0B, 0x0000, 0xC8DC, 0x0000, 0xA756, 0x0000, 0xC7D0, 0x0000,
    0x009C, 0x0000, 0x3ECD, 0x0000, 0x540D, 0x0000, 0x45E5, 0x0000,
    0x0002, 0x0000, 0xC657, 0x0000, 0xA65B, 0x0000, 0xBAB8, 0x0000,
    0x005E, 0x0000, 0x3641, 0x0000, 0x547E, 0x0000, 0x3A14, 0x0000,
    0xFED4, 0x0000, 0xB9C6, 0x0000, 0xA585, 0x0000, 0xCB2B, 0x0000,
    0x05CF, 0x0000, 0x42DE, 0x0000, 0x5D63, 0x0000, 0x3B4D, 0x0000,
    0xFBCD, 0x0000, 0xC067, 0x0000, 0xA543, 0x0000, 0xC475, 0x0000,
    0xFB59, 0x0000, 0x4176, 0x0000, 0x5663, 0x0000, 0x4962, 0x0000,
    0xF514, 0x0000, 0xBF10, 0x0000, 0x9F22, 0x0000, 0xB864, 0x0000,
    0xFB56, 0x0000, 0x3BA6, 0x0000, 0x5303, 0x0000, 0x41A6, 0x0000,
    0x00F8, 0x0000, 0xCCA2, 0x0000, 0xA979, 0x0000, 0xBDF2, 0x0000,
    0xFB9B, 0x0000, 0x42F1, 0x0000, 0x57A1, 0x0000, 0x3992, 0x0000,
    0xFA0D, 0x0000, 0xB849, 0x0000, 0xB6B3, 0x0000, 0xC952, 0x0000,
    0x0177, 0x0000, 0x4240, 0x0000, 0x5E65, 0x0000, 0x3893, 0x0000,
    0x08EF, 0x0000, 0xBD6E, 0x0000, 0x9DF0, 0x0000, 0xCC09, 0x0000,
    0x00A1, 0x0000, 0x3F27, 0x0000, 0x5EBA, 0x0000, 0x4575, 0x0000,
    0x02A1, 0x0000, 0xC806, 0x0000, 0xA5E7, 0x0000, 0xC8C5, 0x0000,
    0x09D8, 0x0000, 0x4302, 0x0000, 0x5F0C, 0x0000, 0x4991, 0x0000,
    0xFED8, 0x0000, 0xC9C6, 0x0000, 0xA8F0, 0x0000, 0xBF15, 0x0000,
    0xF7D8, 0x0000, 0x380B, 0x0000, 0x50ED, 0x0000, 0x3B46, 0x0000,
    0xF9F8, 0x0000, 0xCC07, 0x0000, 0x9C91, 0x0000, 0xC139, 0x0000,
    0xFF2F, 0x0000, 0x371E, 0x0000, 0x5ACA, 0x0000, 0x40CD, 0x0000,
    0xF7F6, 0x0000, 0xCB5C, 0x0000, 0xA5B9, 0x0000, 0xD11C, 0x0000,
    0x02B4, 0x0000, 0x3867, 0x0000, 0x554C, 0x0000, 0x360A, 0x0000,
    0x02D9, 0x0000, 0xC873, 0x0000, 0x9CAB, 0x0000, 0xC26F, 0x0000,
    0x0725, 0x0000, 0x4174, 0x0000, 0x5117, 0x0000, 0x3849, 0x0000,
    0xFEAF, 0x0000, 0xB7FA, 0x0000, 0xA74D, 0x0000, 0xC1A2, 0x0000,
    0x01B4, 0x0000, 0x3E5A, 0x0000, 0x5E3E, 0x0000, 0x3352, 0x0000,
    0x0145, 0x0000, 0xC6BA, 0x0000, 0xADDC, 0x0000, 0xCD0D, 0x0000,
    0x0719, 0x0000, 0x3F21, 0x0000, 0x5C82, 0x0000, 0x3D41, 0x0000,
    0x01D0, 0x0000, 0xC3D4, 0x0000, 0xA204, 0x0000, 0xC119, 0x0000,
    0x054B, 0x0000, 0x4200, 0x0000, 0x5099, 0x0000, 0x4017, 0x0000,
    0xF9C2, 0x0000, 0xC00B, 0x0000, 0xA16D, 0x0000, 0xCABA, 0x0000,
    0xF8A4, 0x0000, 0x35B0, 0x0000, 0x55C5, 0x0000, 0x4453, 0x0000,
    0xFFB0, 0x0000, 0xC036, 0x0000, 0xAB47, 0x0000, 0xC3B7, 0x0000,
    0x08C6, 0x0000, 0x41E3, 0x0000, 0x56FF, 0x0000, 0x4C6E, 0x0000,
    0x027A, 0x0000, 0xBB3F, 0x0000, 0xA57E, 0x0000, 0xC634, 0x0000,
    0x0320, 0x0000, 0x3C0F, 0x0000, 0x62EE, 0x0000, 0x3526, 0x0000,
    0x0751, 0x0000, 0xBACC, 0x0000, 0xB5BD, 0x0000, 0xC29D, 0x0000,
    0x05E6, 0x0000, 0x3E56, 0x0000, 0x5655, 0x0000, 0x3CEC, 0x0000,
    0xFB66, 0x0000, 0xC1E6, 0x0000, 0xA2EB, 0x0000, 0xBE6A, 0x0000,
    0x0022, 0x0000, 0x42E9, 0x0000, 0x57F5, 0x0000, 0x3F31, 0x0000,
    0xFAF4, 0x0000, 0xC9AF, 0x0000, 0xA71E, 0x0000, 0xCBD0, 0x0000,
    0xFCB1, 0x0000, 0x39D9, 0x0000, 0x5E58, 0x0000, 0x4260, 0x0000,
    0x09E0, 0x0000, 0xCBB6, 0x0000, 0xA915, 0x0000, 0xC008, 0x0000,
    0x00C6, 0x0000, 0x3698, 0x0000, 0x5960, 0x0000, 0x3A15, 0x0000,
    0x072C, 0x0000, 0xC5E3, 0x0000, 0xB83C, 0x0000, 0xC8A4, 0x0000,
    0x00B9, 0x0000, 0x4744, 0x0000, 0x6756, 0x0000, 0x389B, 0x0000,
    0xFFE5, 0x0000, 0xBADE, 0x0000, 0xA02C, 0x0000, 0xBD53, 0x0000,
    0x0829, 0x0000, 0x4C07, 0x0000, 0x5A1F, 0x0000, 0x3AFB, 0x0000,
    0x0094, 0x0000, 0xCADC, 0x0000, 0xACE2, 0x0000, 0xC02F, 0x0000,
    0x0DE9, 0x0000, 0x392A, 0x0000, 0x5BB7, 0x0000, 0x3597, 0x0000,
    0x025E, 0x0000, 0xB49B, 0x0000, 0xA47D, 0x0000, 0xC379, 0x0000,
    0x02E9, 0x0000, 0x4A16, 0x0000, 0x6602, 0x0000, 0x4168, 0x0000,
    0x0BFE, 0x0000, 0xC112, 0x0000, 0x9BA8, 0x0000, 0xC0F2, 0x0000,
    0xFC40, 0x0000, 0x2F78, 0x0000, 0x5986, 0x0000, 0x3BAF, 0x0000,
    0xFF01, 0x0000, 0xB9F4, 0x0000, 0xB03E, 0x0000, 0xBFE3, 0x0000,
    0xFACD, 0x0000, 0x3C9B, 0x0000, 0x557C, 0x0000, 0x3B65, 0x0000,
    0xFC4B, 0x0000, 0xB296, 0x0000, 0xA394, 0x0000, 0xC42D, 0x0000,
    0xF803, 0x0000, 0x437C, 0x0000, 0x55AD, 0x0000, 0x474A, 0x0000,
    0x0943, 0x0000, 0xC341, 0x0000, 0x9D8D, 0x0000, 0xB84F, 0x0000,
    0x07BB, 0x0000, 0x3F3D, 0x0000, 0x6296, 0x0000, 0x3C98, 0x0000,
    0xF7AD, 0x0000, 0xB86D, 0x0000, 0xA1A3, 0x0000, 0xBF6C, 0x0000,
    0xF783, 0x0000, 0x3981, 0x0000, 0x56B0, 0x0000, 0x35B2, 0x0000,
    0x0491, 0x0000, 0xB6B0, 0x0000, 0x9ADE, 0x0000, 0xBFC0, 0x0000,
    0x0E55, 0x0000, 0x3909, 0x0000, 0x5B1C, 0x0000, 0x3E4D, 0x0000,
    0x0529, 0x0000, 0xB984, 0x0000, 0xA047, 0x0000, 0xC1FE, 0x0000,
    0xF6C4, 0x0000, 0x4516, 0x0000, 0x58A6, 0x0000, 0x441E, 0x0000,
    0x040B, 0x0000, 0xBA02, 0x0000, 0xAB63, 0x0000, 0xBFED, 0x0000,
    0x017E, 0x0000, 0x3C26, 0x0000, 0x586D, 0x0000, 0x3C19, 0x0000,
    0xF9E1, 0x0000, 0xBB67, 0x0000, 0x9CDC, 0x0000, 0xC410, 0x0000,
    0xFC63, 0x0000, 0x42B6, 0x0000, 0x5985, 0x0000, 0x3B4C, 0x0000,
    0x0CDD, 0x0000, 0xBF2B, 0x0000, 0xA733, 0x0000, 0xBCEA, 0x0000,
    0xFF07, 0x0000, 0x387D, 0x0000, 0x562A, 0x0000, 0x37CD, 0x0000,
    0xF459, 0x0000, 0xC45A, 0x0000, 0xA8CE, 0x0000, 0xC8A5, 0x0000,
    0xFFCA, 0x0000, 0x39D4, 0x0000, 0x5014, 0x0000, 0x4532, 0x0000,
    0xFC00, 0x0000, 0xC99E, 0x0000, 0xA5C7, 0x0000, 0xBF14, 0x0000,
    0x0954, 0x0000, 0x3CA6, 0x0000, 0x5990, 0x0000, 0x3C29, 0x0000,
    0xFD19, 0x0000, 0xC016, 0x0000, 0xA403, 0x0000, 0xB84B, 0x0000,
    0xFC84, 0x0000, 0x4773, 0x0000, 0x510A, 0x0000, 0x3EF6, 0x0000,
    0x0455, 0x0000, 0xC1F5, 0x0000, 0xA545, 0x0000, 0xC32E, 0x0000,
    0x0135, 0x0000, 0x3DF5, 0x0000, 0x5573, 0x0000, 0x384B, 0x0000,
    0x0E8C, 0x0000, 0xBCA9, 0x0000, 0xA453, 0x0000, 0xCA7D, 0x0000,
    0x0452, 0x0000, 0x3D86, 0x0000, 0x51F0, 0x0000, 0x37B0, 0x0000,
    0x085C, 0x0000, 0xBDD1, 0x0000, 0xAB34, 0x0000, 0xBE3B, 0x0000,
    0x01E6, 0x0000, 0x4A26, 0x0000, 0x5F12, 0x0000, 0x3CB4, 0x0000,
    0xFF6F, 0x0000, 0xBB1D, 0x0000, 0xAB82, 0x0000, 0xBD79, 0x0000,
    0xF672, 0x0000, 0x34C5, 0x0000, 0x5545, 0x0000, 0x3472, 0x0000,
    0xFA71, 0x0000, 0xC013, 0x0000, 0x94E7, 0x0000, 0xC1D3, 0x0000,
    0x0CED, 0x0000, 0x4405, 0x0000, 0x5A60, 0x0000, 0x391D, 0x0000,
    0xFC0E, 0x0000, 0xC7FB, 0x0000, 0xA358, 0x0000, 0xC097, 0x0000,
    0xF842, 0x0000, 0x3E06, 0x0000, 0x5A15, 0x0000, 0x3346, 0x0000,
    0x035E, 0x0000, 0xC9CC, 0x0000, 0xA449, 0x0000, 0xB92A, 0x0000,
    0x0516, 0x0000, 0x4297, 0x0000, 0x591A, 0x0000, 0x420A, 0x0000,
    0x01A6, 0x0000, 0xC0AA, 0x0000, 0xA65C, 0x0000, 0xBD8D, 0x0000,
    0xFB9E, 0x0000, 0x3839, 0x0000, 0x5BFE, 0x0000, 0x4828, 0x0000,
    0x063E, 0x0000, 0xBDC9, 0x0000, 0x9D1F, 0x0000, 0xBB8F, 0x0000,
    0xFDB4, 0x0000, 0x431B, 0x0000, 0x5D42, 0x0000, 0x43EB, 0x0000,
    0x0293, 0x0000, 0xC92F, 0x0000, 0xAA26, 0x0000, 0xBA93, 0x0000,
    0xFC58, 0x0000, 0x4A74, 0x0000, 0x61BE, 0x0000, 0x420B, 0x0000,
    0x00FB, 0x0000, 0xB7A9, 0x0000, 0xABDF, 0x0000, 0xBB20, 0x0000,
    0xFB9B, 0x0000, 0x4261, 0x0000, 0x560D, 0x0000, 0x43BE, 0x0000,
    0xF871, 0x0000, 0xBCAC, 0x0000, 0xAE84, 0x0000, 0xB9AE, 0x0000,
    0xFE07, 0x0000, 0x3DBE, 0x0000, 0x5E95, 0x0000, 0x3450, 0x0000,
    0xFB18, 0x0000, 0xC690, 0x0000, 0xA8D9, 0x0000, 0xBCD9, 0x0000,
    0x034D, 0x0000, 0x3AE5, 0x0000, 0x6594, 0x0000, 0x3CCC, 0x0000,
    0xFC7A, 0x0000, 0xB609, 0x0000, 0xAD71, 0x0000, 0xC528, 0x0000,
    0xF959, 0x0000, 0x3A18, 0x0000, 0x5718, 0x0000, 0x4E91, 0x0000,
    0x0620, 0x0000, 0xCEB7, 0x0000, 0x984D, 0x0000, 0xC6A5, 0x0000,
    0xFD6F, 0x0000, 0x3EC4, 0x0000, 0x6561, 0x0000, 0x3833, 0x0000,
    0x0EDC, 0x0000, 0xBDE0, 0x0000, 0xA1A7, 0x0000, 0xBFF9, 0x0000,
    0x0B0B, 0x0000, 0x37AF, 0x0000, 0x54C3, 0x0000, 0x3C93, 0x0000,
    0x00FD, 0x0000, 0xC44C, 0x0000, 0xA55E, 0x0000, 0xC848, 0x0000,
    0xFC6E, 0x0000, 0x42B1, 0x0000, 0x5899, 0x0000, 0x4162, 0x0000,
    0x0A58, 0x0000, 0xBB41, 0x0000, 0xA830, 0x0000, 0xB59F, 0x0000,
    0xF767, 0x0000, 0x390C, 0x0000, 0x537A, 0x0000, 0x3F4D, 0x0000,
    0xFD16, 0x0000, 0xBC63, 0x0000, 0xA0E9, 0x0000, 0xB788, 0x0000,
    0xFA37, 0x0000, 0x30C1, 0x0000, 0x5D89, 0x0000, 0x3641, 0x0000,
    0xF8FF, 0x0000, 0xB178, 0x0000, 0xA1B6, 0x0000, 0xCD7D, 0x0000,
    0xFEF2, 0x0000, 0x446B, 0x0000, 0x54D4, 0x0000, 0x4405, 0x0000,
    0xFE67, 0x0000, 0xBD66, 0x0000, 0xA977, 0x0000, 0xC78C, 0x0000,
    0x0029, 0x0000, 0x3A58, 0x0000, 0x51C1, 0x0000, 0x3AEB, 0x0000,
    0x07B6, 0x0000, 0xBC50, 0x0000, 0xA41A, 0x0000, 0xCDC2, 0x0000,
    0xFE2F, 0x0000, 0x41AF, 0x0000, 0x5B1E, 0x0000, 0x412D, 0x0000,
    0x07DF, 0x0000, 0xC7B1, 0x0000, 0xAD6A, 0x0000, 0xC914, 0x0000,
    0x0049, 0x0000, 0x3820, 0x0000, 0x565A, 0x0000, 0x3FF0, 0x0000,
    0x0169, 0x0000, 0xBEAB, 0x0000, 0xA6CF, 0x0000, 0xCBA3, 0x0000,
    0xEC98, 0x0000, 0x467E, 0x0000, 0x5417, 0x0000, 0x42FF, 0x0000,
    0xFBE5, 0x0000, 0xC716, 0x0000, 0xA36E, 0x0000, 0xC4B1, 0x0000,
    0xF987, 0x0000, 0x4877, 0x0000, 0x5FAD, 0x0000, 0x3ACC, 0x0000,
    0xFD73, 0x0000, 0xBC19, 0x0000, 0xA5E4, 0x0000, 0xC34D, 0x0000,
    0xFF87, 0x0000, 0x32D7, 0x0000, 0x5A2D, 0x0000, 0x459B, 0x0000,
    0x0A58, 0x0000, 0xB9D2, 0x0000, 0xA3C3, 0x0000, 0xBBE1, 0x0000,
    0xFE00, 0x0000, 0x40AF, 0x0000, 0x58EE, 0x0000, 0x434C, 0x0000,
    0xFD61, 0x0000, 0xC20D, 0x0000, 0xA997, 0x0000, 0xD029, 0x0000,
    0xFD5D, 0x0000, 0x406A, 0x0000, 0x5D25, 0x0000, 0x364F, 0x0000,
    0xF983, 0x0000, 0xC3F5, 0x0000, 0xA442, 0x0000, 0xC70F, 0x0000,
    0x01DC, 0x0000, 0x41BE, 0x0000, 0x5861, 0x0000, 0x41EA, 0x0000,
    0xF0B0, 0x0000, 0xC17F, 0x0000, 0xA94B, 0x0000, 0xADC6, 0x0000,
    0xF742, 0x0000, 0x3AF0, 0x0000, 0x62DE, 0x0000, 0x3D2A, 0x0000,
    0x0202, 0x0000, 0xC643, 0x0000, 0xA5CB, 0x0000, 0xB975, 0x0000,
    0xF861, 0x0000, 0x3E71, 0x0000, 0x5B37, 0x0000, 0x394E, 0x0000,
    0x0596, 0x0000, 0xBBCF, 0x0000, 0xA6EE, 0x0000, 0xC2FF, 0x0000,
    0xF8C8, 0x0000, 0x36DD, 0x0000, 0x550E, 0x0000, 0x425E, 0x0000,
    0xF8E7, 0x0000, 0xC448, 0x0000, 0x9C0F, 0x0000, 0xC431, 0x0000,
    0xF895, 0x0000, 0x3739, 0x0000, 0x5B58, 0x0000, 0x3DC0, 0x0000,
    0xF6A8, 0x0000, 0xC0F0, 0x0000, 0xA787, 0x0000, 0xC2E9, 0x0000,
    0xFD46, 0x0000, 0x4B10, 0x0000, 0x54D3, 0x0000, 0x4274, 0x0000,
    0x0450, 0x0000, 0xB2A5, 0x0000, 0xAFAA, 0x0000, 0xBC7C, 0x0000,
    0xF89F, 0x0000, 0x2F6C, 0x0000, 0x4D09, 0x0000, 0x4877, 0x0000,
    0x052D, 0x0000, 0xC7AD, 0x0000, 0xABC8, 0x0000, 0xC5CD, 0x0000,
    0x02EF, 0x0000, 0x3E84, 0x0000, 0x5FDD, 0x0000, 0x335D, 0x0000,
    0xF72C, 0x0000, 0xBE81, 0x0000, 0xA931, 0x0000, 0xCB12, 0x0000,
    0xFA5D, 0x0000, 0x32AE, 0x0000, 0x5645, 0x0000, 0x3F48, 0x0000,
    0xF374, 0x0000, 0xD66F, 0x0000, 0xA39F, 0x0000, 0xBBB6, 0x0000,
    0x00C1, 0x0000, 0x3DC5, 0x0000, 0x55C4, 0x0000, 0x3F62, 0x0000,
    0x06A7, 0x0000, 0xC884, 0x0000, 0xAB13, 0x0000, 0xC167, 0x0000,
    0x02E9, 0x0000, 0x3A19, 0x0000, 0x5B70, 0x0000, 0x3DEE, 0x0000,
    0x0079, 0x0000, 0xBB6F, 0x0000, 0xB992, 0x0000, 0xCA14, 0x0000,
    0xF0B0, 0x0000, 0x431C, 0x0000, 0x555D, 0x0000, 0x4E70, 0x0000,
    0xFBFD, 0x0000, 0xBE85, 0x0000, 0xA712, 0x0000, 0xBD3A, 0x0000,
    0xFC44, 0x0000, 0x3CAB, 0x0000, 0x55B2, 0x0000, 0x3979, 0x0000,
    0xFBCA, 0x0000, 0xC8BF, 0x0000, 0xA14D, 0x0000, 0xC06F, 0x0000,
    0xFF23, 0x0000, 0x407C, 0x0000, 0x6509, 0x0000, 0x4745, 0x0000,
    0x048E, 0x0000, 0xCB63, 0x0000, 0xA32F, 0x0000, 0xBD15, 0x0000,
    0xFE91, 0x0000, 0x41D5, 0x0000, 0x6027, 0x0000, 0x4047, 0x0000,
    0xFCEE, 0x0000, 0xBDDE, 0x0000, 0xA362, 0x0000, 0xC095, 0x0000,
    0x0559, 0x0000, 0x3E47, 0x0000, 0x4F5F, 0x0000, 0x39D3, 0x0000,
    0x01D6, 0x0000, 0xC5DD, 0x0000, 0xA630, 0x0000, 0xC442, 0x0000,
    0x001A, 0x0000, 0x3F92, 0x0000, 0x6B5C, 0x0000, 0x47A8, 0x0000,
    0xFE4A, 0x0000, 0xC3D4, 0x0000, 0x97C7, 0x0000, 0xC4F8, 0x0000,
    0xF60E, 0x0000, 0x3F6A, 0x0000, 0x57B9, 0x0000, 0x4928, 0x0000,
    0x0161, 0x0000, 0xBDFE, 0x0000, 0xA0BA, 0x0000, 0xC176, 0x0000,
    0x0DE2, 0x0000, 0x3C34, 0x0000, 0x632F, 0x0000, 0x4800, 0x0000,
    0xF996, 0x0000, 0xC5B7, 0x0000, 0xA9FD, 0x0000, 0xB84D, 0x0000,
    0xF87A, 0x0000, 0x3EF5, 0x0000, 0x6064, 0x0000, 0x4602, 0x0000,
    0x0088, 0x0000, 0xC03B, 0x0000, 0xA504, 0x0000, 0xC991, 0x0000,
    0x064A, 0x0000, 0x3BF2, 0x0000, 0x574C, 0x0000, 0x49E4, 0x0000,
    0x0574, 0x0000, 0xC7FD, 0x0000, 0xA2E2, 0x0000, 0xC794, 0x0000,
    0xFD9E, 0x0000, 0x35A2, 0x0000, 0x5C20, 0x0000, 0x3F82, 0x0000,
    0xF86E, 0x0000, 0xC361, 0x0000, 0xA1B7, 0x0000, 0xC676, 0x0000,
    0x0164, 0x0000, 0x3D85, 0x0000, 0x5CFE, 0x0000, 0x41A5, 0x0000,
    0x007A, 0x0000, 0xC0CE, 0x0000, 0xA591, 0x0000, 0xD09C, 0x0000,
    0xFB3D, 0x0000, 0x40D5, 0x0000, 0x658B, 0x0000, 0x42D3, 0x0000,
    0x01B2, 0x0000, 0xB7C4, 0x0000, 0xABD6, 0x0000, 0xB80A, 0x0000,
    0xF927, 0x0000, 0x3C91, 0x0000, 0x5CD2, 0x0000, 0x3947, 0x0000,
    0xFB66, 0x0000, 0xC054, 0x0000, 0xA63B, 0x0000, 0xB7F9, 0x0000,
    0xF670, 0x0000, 0x3CE2, 0x0000, 0x53E2, 0x0000, 0x3508, 0x0000,
    0xFC5F, 0x0000, 0xBB29, 0x0000, 0xB30F, 0x0000, 0xBBED, 0x0000,
    0xFBA3, 0x0000, 0x3670, 0x0000, 0x4DBE, 0x0000, 0x41D5, 0x0000,
    0x0327, 0x0000, 0xC898, 0x0000, 0xA3BF, 0x0000, 0xC266, 0x0000,
    0xFA2F, 0x0000, 0x40AE, 0x0000, 0x4E58, 0x0000, 0x3C3A, 0x0000,
    0x0E30, 0x0000, 0xBC53, 0x0000, 0x9F64, 0x0000, 0xBBF4, 0x0000,
    0x0364, 0x0000, 0x3E9C, 0x0000, 0x4E78, 0x0000, 0x37A8, 0x0000,
    0xFABD, 0x0000, 0xB959, 0x0000, 0xA831, 0x0000, 0xB834, 0x0000,
    0x0805, 0x0000, 0x3D42, 0x0000, 0x5BEE, 0x0000, 0x3CBC, 0x0000,
    0xF674, 0x0000, 0xC5B7, 0x0000, 0xA248, 0x0000, 0xBF61, 0x0000,
    0xFC3E, 0x0000, 0x3FCA, 0x0000, 0x5DC2, 0x0000, 0x3F55, 0x0000,
    0xF777, 0x0000, 0xCB2F, 0x0000, 0xAB97, 0x0000, 0xCA5C, 0x0000,
    0x04E3, 0x0000, 0x37BB, 0x0000, 0x65BF, 0x0000, 0x3AD4, 0x0000,
    0x0086, 0x0000, 0xC097, 0x0000, 0xA480, 0x0000, 0xC616, 0x0000,
    0x06F6, 0x0000, 0x3F91, 0x0000, 0x5C8E, 0x0000, 0x4122, 0x0000,
    0x0418, 0x0000, 0xBD79, 0x0000, 0xA8EE, 0x0000, 0xC895, 0x0000,
    0x00AA, 0x0000, 0x4837, 0x0000, 0x4F84, 0x0000, 0x3DDC, 0x0000,
    0xFAA6, 0x0000, 0xC3C7, 0x0000, 0xA11B, 0x0000, 0xBDC4, 0x0000,
    0x057B, 0x0000, 0x37AC, 0x0000, 0x69B2, 0x0000, 0x38BC, 0x0000,
    0xFA30, 0x0000, 0xC028, 0x0000, 0xA5C4, 0x0000, 0xC808, 0x0000,
    0x04AD, 0x0000, 0x4959, 0x0000, 0x5A49, 0x0000, 0x4212, 0x0000,
    0x072A, 0x0000, 0xD088, 0x0000, 0xB051, 0x0000, 0xBDAE, 0x0000,
    0xF44C, 0x0000, 0x3E15, 0x0000, 0x6605, 0x0000, 0x3FF3, 0x0000,
    0xFE4E, 0x0000, 0xC10D, 0x0000, 0xA1A4, 0x0000, 0xB895, 0x0000,
    0xFF9D, 0x0000, 0x3DEA, 0x0000, 0x5809, 0x0000, 0x3E42, 0x0000,
    0xF63F, 0x0000, 0xC04E, 0x0000, 0xAA5C, 0x0000, 0xAD9B, 0x0000,
    0xFECA, 0x0000, 0x3EE9, 0x0000, 0x5FC2, 0x0000, 0x427A, 0x0000,
    0xFE6F, 0x0000, 0xC1BB, 0x0000, 0xAB32, 0x0000, 0xBA89, 0x0000,
    0xF9DA, 0x0000, 0x3563, 0x0000, 0x5893, 0x0000, 0x45DA, 0x0000,
    0x06A6, 0x0000, 0xC409, 0x0000, 0xA91F, 0x0000, 0xBF04, 0x0000,
    0x0370, 0x0000, 0x3A31, 0x0000, 0x5EEE, 0x0000, 0x46E3, 0x0000,
    0x07E5, 0x0000, 0xCC72, 0x0000, 0xA4D3, 0x0000, 0xBF2C, 0x0000,
    0x00A5, 0x0000, 0x3A18, 0x0000, 0x5EDA, 0x0000, 0x40BA, 0x0000,
    0x01A3, 0x0000, 0xC204, 0x0000, 0xAC82, 0x0000, 0xC3E4, 0x0000,
    0xFB10, 0x0000, 0x35E6, 0x0000, 0x57AD, 0x0000, 0x40DA, 0x0000,
    0xFD29, 0x0000, 0xCB20, 0x0000, 0xAC86, 0x0000, 0xC7D0, 0x0000,
    0xFFE8, 0x0000, 0x452C, 0x0000, 0x5C83, 0x0000, 0x41CA, 0x0000,
    0x04DD, 0x0000, 0xCAD7, 0x0000, 0xA359, 0x0000, 0xC32C, 0x0000,
    0xFE41, 0x0000, 0x3B15, 0x0000, 0x59A1, 0x0000, 0x3D2A, 0x0000,
    0xFEC1, 0x0000, 0xC47F, 0x0000, 0xA2DC, 0x0000, 0xBE26, 0x0000,
    0xFA85, 0x0000, 0x4761, 0x0000, 0x5E6D, 0x0000, 0x3898, 0x0000,
    0x078B, 0x0000, 0xBFEF, 0x0000, 0xA6D7, 0x0000, 0xBD38, 0x0000,
    0x033F, 0x0000, 0x43B8, 0x0000, 0x5518, 0x0000, 0x3ECB, 0x0000,
    0xEED1, 0x0000, 0xB53C, 0x0000, 0xAA66, 0x0000, 0xB3FB, 0x0000,
    0xFCE3, 0x0000, 0x3E1F, 0x0000, 0x5314, 0x0000, 0x313D, 0x0000,
    0xFCD1, 0x0000, 0xBFE5, 0x0000, 0x9F84, 0x0000, 0xC2C5, 0x0000,
    0x0587, 0x0000, 0x3BE1, 0x0000, 0x5DA5, 0x0000, 0x4A71, 0x0000,
    0xFCCE, 0x0000, 0xC36E, 0x0000, 0xAB57, 0x0000, 0xC43D, 0x0000,
    0x0406, 0x0000, 0x3A0C, 0x0000, 0x5E3A, 0x0000, 0x39C4, 0x0000,
    0xFEB6, 0x0000, 0xC0F9, 0x0000, 0xB13D, 0x0000, 0xC466, 0x0000,
    0xF7F4, 0x0000, 0x3C58, 0x0000, 0x5A67, 0x0000, 0x41B0, 0x0000,
    0xFC78, 0x0000, 0xC295, 0x0000, 0xA8CF, 0x0000, 0xB4B8, 0x0000,
    0xFC86, 0x0000, 0x45EA, 0x0000, 0x6257, 0x0000, 0x365A, 0x0000,
    0xFFD7, 0x0000, 0xBB1B, 0x0000, 0xA415, 0x0000, 0xBE3D, 0x0000,
    0x06DE, 0x0000, 0x47CB, 0x0000, 0x586A, 0x0000, 0x310B, 0x0000,
    0x03BF, 0x0000, 0xC471, 0x0000, 0xAED6, 0x0000, 0xC566, 0x0000,
    0x0C6E, 0x0000, 0x4711, 0x0000, 0x4E02, 0x0000, 0x403F, 0x0000,
    0x016A, 0x0000, 0xBEDD, 0x0000, 0xA204, 0x0000, 0xC3CA, 0x0000,
    0x05FE, 0x0000, 0x4C23, 0x0000, 0x5BD2, 0x0000, 0x3D83, 0x0000,
    0x0076, 0x0000, 0xB8E8, 0x0000, 0xA4CA, 0x0000, 0xBB36, 0x0000,
    0xFA59, 0x0000, 0x46A8, 0x0000, 0x52E4, 0x0000, 0x45AF, 0x0000,
    0xF867, 0x0000, 0xC210, 0x0000, 0xAA1B, 0x0000, 0xC03A, 0x0000,
    0x01AE, 0x0000, 0x351E, 0x0000, 0x5673, 0x0000, 0x41AB, 0x0000,
    0x0723, 0x0000, 0xCA0B, 0x0000, 0xACD2, 0x0000, 0xBEE2, 0x0000,
    0x0060, 0x0000, 0x3AFC, 0x0000, 0x4DB3, 0x0000, 0x3E78, 0x0000,
    0x0200, 0x0000, 0xBD61, 0x0000, 0xACFE, 0x0000, 0xC032, 0x0000,
    0xF4FE, 0x0000, 0x3CF6, 0x0000, 0x5B86, 0x0000, 0x4029, 0x0000,
    0x0650, 0x0000, 0xBF2C, 0x0000, 0xA05A, 0x0000, 0xBF80, 0x0000,
    0xFEB4, 0x0000, 0x3EA5, 0x0000, 0x4F8B, 0x0000, 0x462D, 0x0000,
    0xEE1D, 0x0000, 0xC799, 0x0000, 0xA8AF, 0x0000, 0xBA29, 0x0000,
    0xF0DE, 0x0000, 0x3A51, 0x0000, 0x5366, 0x0000, 0x4195, 0x0000,
    0xFF10, 0x0000, 0xB810, 0x0000, 0x9F82, 0x0000, 0xBC9F, 0x0000,
    0xF836, 0x0000, 0x37DE, 0x0000, 0x55F2, 0x0000, 0x3D9A, 0x0000,
    0xF3FB, 0x0000, 0xBE43, 0x0000, 0xA96D, 0x0000, 0xBEBE, 0x0000,
    0x01E4, 0x0000, 0x3E4B, 0x0000, 0x550B, 0x0000, 0x440F, 0x0000,
    0xFA66, 0x0000, 0xC436, 0x0000, 0x9A7E, 0x0000, 0xC727, 0x0000,
    0x0018, 0x0000, 0x44C4, 0x0000, 0x580D, 0x0000, 0x3F18, 0x0000,
    0xFCF0, 0x0000, 0xC318, 0x0000, 0xAEDD, 0x0000, 0xBE18, 0x0000,
    0x08C4, 0x0000, 0x4066, 0x0000, 0x5849, 0x0000, 0x433A, 0x0000,
    0x069D, 0x0000, 0xB901, 0x0000, 0xAB2A, 0x0000, 0xA71D, 0x0000,
    0x0228, 0x0000, 0x3DFB, 0x0000, 0x5FD7, 0x0000, 0x4BA0, 0x0000,
    0x06C8, 0x0000, 0xBF78, 0x0000, 0x9A93, 0x0000, 0xBE21, 0x0000,
    0xFAB0, 0x0000, 0x3CF3, 0x0000, 0x518A, 0x0000, 0x3CA3, 0x0000,
    0xFE8E, 0x0000, 0xC6E8, 0x0000, 0xA2EA, 0x0000, 0xB9AF, 0x0000,
    0x0223, 0x0000, 0x36D6, 0x0000, 0x5E5E, 0x0000, 0x40ED, 0x0000,
    0xFADD, 0x0000, 0xB2B1, 0x0000, 0xA9DA, 0x0000, 0xAAFF, 0x0000,
    0x01A1, 0x0000, 0x41E0, 0x0000, 0x5E4F, 0x0000, 0x401D, 0x0000,
    0xF9BB, 0x0000, 0xC2C7, 0x0000, 0xA213, 0x0000, 0xC868, 0x0000,
    0xFDBC, 0x0000, 0x3645, 0x0000, 0x5F84, 0x0000, 0x3BA7, 0x0000,
    0xFA10, 0x0000, 0xC048, 0x0000, 0x94ED, 0x0000, 0xC68F, 0x0000,
    0xFE89, 0x0000, 0x45BA, 0x0000, 0x5635, 0x0000, 0x4B93, 0x0000,
    0x0157, 0x0000, 0xBBE4, 0x0000, 0x9F99, 0x0000, 0xC5B6, 0x0000,
    0x0880, 0x0000, 0x3D1B, 0x0000, 0x5D28, 0x0000, 0x37CB, 0x0000,
    0x00BE, 0x0000, 0xC10F, 0x0000, 0xAD7B, 0x0000, 0xC455, 0x0000,
    0x0660, 0x0000, 0x4335, 0x0000, 0x4C76, 0x0000, 0x4018, 0x0000,
    0xFE69, 0x0000, 0xBC3C, 0x0000, 0xA00E, 0x0000, 0xC188, 0x0000,
    0xFCBA, 0x0000, 0x42AE, 0x0000, 0x5992, 0x0000, 0x35E0, 0x0000,
    0x073D, 0x0000, 0xC312, 0x0000, 0xA970, 0x0000, 0xBB55, 0x0000,
    0xF9D4, 0x0000, 0x402C, 0x0000, 0x5DA8, 0x0000, 0x3C5A, 0x0000,
    0x0067, 0x0000, 0xB8A2, 0x0000, 0xA5CA, 0x0000, 0xBB9F, 0x0000,
    0xFE6F, 0x0000, 0x3D49, 0x0000, 0x5A88, 0x0000, 0x3CFA, 0x0000,
    0x00D4, 0x0000, 0xC912, 0x0000, 0xA74C, 0x0000, 0xBDE2, 0x0000,
    0xF68E, 0x0000, 0x4623, 0x0000, 0x57B4, 0x0000, 0x3847, 0x0000,
    0x0061, 0x0000, 0xCDC2, 0x0000, 0xAE46, 0x0000, 0xBE90, 0x0000,
    0x0173, 0x0000, 0x34BE, 0x0000, 0x5BCB, 0x0000, 0x424C, 0x0000,
    0x0A2B, 0x0000, 0xC486, 0x0000, 0xA712, 0x0000, 0xC2EA, 0x0000,
    0xF14C, 0x0000, 0x38DF, 0x0000, 0x621E, 0x0000, 0x3E77, 0x0000,
    0x09AE, 0x0000, 0xB18A, 0x0000, 0xA7CC, 0x0000, 0xCAA0, 0x0000,
    0xFB7D, 0x0000, 0x4366, 0x0000, 0x6083, 0x0000, 0x3EBE, 0x0000,
    0xFC74, 0x0000, 0xC8E1, 0x0000, 0xA6A4, 0x0000, 0xBD88, 0x0000,
    0x05DE, 0x0000, 0x42DF, 0x0000, 0x580E, 0x0000, 0x4970, 0x0000,
    0x010D, 0x0000, 0xBCE3, 0x0000, 0x96F0, 0x0000, 0xB805, 0x0000,
    0xF9B7, 0x0000, 0x3CC8, 0x0000, 0x4EC7, 0x0000, 0x3F93, 0x0000,
    0xFC79, 0x0000, 0xCB46, 0x0000, 0xA7A8, 0x0000, 0xCC08, 0x0000,
    0x004A, 0x0000, 0x416C, 0x0000, 0x66C6, 0x0000, 0x3410, 0x0000,
    0x0805, 0x0000, 0xBE67, 0x0000, 0x9954, 0x0000, 0xB78A, 0x0000,
    0x02D4, 0x0000, 0x3E7E, 0x0000, 0x50A1, 0x0000, 0x4291, 0x0000,
    0x0250, 0x0000, 0xBB06, 0x0000, 0x995E, 0x0000, 0xC10E, 0x0000,
    0x05AC, 0x0000, 0x402E, 0x0000, 0x4F7C, 0x0000, 0x3BAE, 0x0000,
    0xFA07, 0x0000, 0xC311, 0x0000, 0xA47A, 0x0000, 0xC597, 0x0000,
    0xFFD3, 0x0000, 0x3BCC, 0x0000, 0x5BE6, 0x0000, 0x4192, 0x0000,
    0x0781, 0x0000, 0xBA8D, 0x0000, 0xA7F2, 0x0000, 0xBE6B, 0x0000,
    0x093A, 0x0000, 0x39BD, 0x0000, 0x47A0, 0x0000, 0x4007, 0x0000,
    0x03F8, 0x0000, 0xB4BB, 0x0000, 0xA9F1, 0x0000, 0xBA2E, 0x0000,
    0xFDC5, 0x0000, 0x3927, 0x0000, 0x5842, 0x0000, 0x4408, 0x0000,
    0xFAE4, 0x0000, 0xBDDE, 0x0000, 0xAA44, 0x0000, 0xCED2, 0x0000,
    0x080E, 0x0000, 0x3868, 0x0000, 0x5796, 0x0000, 0x3849, 0x0000,
    0x016D, 0x0000, 0xC4A1, 0x0000, 0x9FA1, 0x0000, 0xBE89, 0x0000,
    0x0471, 0x0000, 0x3BF2, 0x0000, 0x5B1C, 0x0000, 0x3766, 0x0000,
    0xFCC8, 0x0000, 0xCCE2, 0x0000, 0xA3A6, 0x0000, 0xC1DD, 0x0000,
    0x0118, 0x0000, 0x4709, 0x0000, 0x52CD, 0x0000, 0x33F2, 0x0000,
    0x001D, 0x0000, 0xBFA3, 0x0000, 0x9EFE, 0x0000, 0xBD9D, 0x0000,
    0x09E5, 0x0000, 0x36F4, 0x0000, 0x5A6F, 0x0000, 0x3F81, 0x0000,
    0xFADC, 0x0000, 0xBCD4, 0x0000, 0xA6A0, 0x0000, 0xB520, 0x0000,
    0xFF66, 0x0000, 0x40DB, 0x0000, 0x5EEC, 0x0000, 0x47F4, 0x0000,
    0x0372, 0x0000, 0xBD92, 0x0000, 0xA96C, 0x0000, 0xC2D7, 0x0000,
    0x0A78, 0x0000, 0x3BF8, 0x0000, 0x5E91, 0x0000, 0x3839, 0x0000,
    0x0711, 0x0000, 0xBE87, 0x0000, 0xB011, 0x0000, 0xC563, 0x0000,
    0x02A6, 0x0000, 0x3BCB, 0x0000, 0x5F01, 0x0000, 0x4239, 0x0000,
    0x0B1F, 0x0000, 0xD2C2, 0x0000, 0xA19F, 0x0000, 0xC5C5, 0x0000,
    0x0285, 0x0000, 0x49A7, 0x0000, 0x5C85, 0x0000, 0x3D46, 0x0000,
    0xFFB2, 0x0000, 0xB6CC, 0x0000, 0x9A46, 0x0000, 0xBEB4, 0x0000,
    0xFE2C, 0x0000, 0x42F2, 0x0000, 0x52BF, 0x0000, 0x3DD5, 0x0000,
    0xFAD0, 0x0000, 0xBE9A, 0x0000, 0xB2DF, 0x0000, 0xC83A, 0x0000,
    0xFCC5, 0x0000, 0x5110, 0x0000, 0x5B88, 0x0000, 0x375E, 0x0000,
    0xF288, 0x0000, 0xB198, 0x0000, 0xA437, 0x0000, 0xC94C, 0x0000,
    0xF9A7, 0x0000, 0x3DB9, 0x0000, 0x56E0, 0x0000, 0x4139, 0x0000,
    0x0B78, 0x0000, 0xCC4B, 0x0000, 0xA620, 0x0000, 0xB948, 0x0000,
    0x02AE, 0x0000, 0x3AB3, 0x0000, 0x5BCB, 0x0000, 0x3439, 0x0000,
    0xF61E, 0x0000, 0xBCA4, 0x0000, 0xB08B, 0x0000, 0xB850, 0x0000,
    0xFC84, 0x0000, 0x3D54, 0x0000, 0x60C0, 0x0000, 0x3A53, 0x0000,
    0x05B6, 0x0000, 0xC099, 0x0000, 0x9E4C, 0x0000, 0xB88F, 0x0000,
    0xFC1A, 0x0000, 0x421F, 0x0000, 0x5775, 0x0000, 0x38F7, 0x0000,
    0xF92C, 0x0000, 0xBD5A, 0x0000, 0xA501, 0x0000, 0xB55B, 0x0000,
    0xFA50, 0x0000, 0x3CAF, 0x0000, 0x5A20, 0x0000, 0x3B9A, 0x0000,
    0x043D, 0x0000, 0xBC86, 0x0000, 0xA871, 0x0000, 0xC015, 0x0000,
    0xFCB6, 0x0000, 0x3E0C, 0x0000, 0x54E2, 0x0000, 0x372E, 0x0000,
    0xFD1F, 0x0000, 0xB792, 0x0000, 0xAA68, 0x0000, 0xBAD5, 0x0000,
    0xFE21, 0x0000, 0x442D, 0x0000, 0x5B7E, 0x0000, 0x3CBE, 0x0000,
    0x0802, 0x0000, 0xB9FF, 0x0000, 0xA20F, 0x0000, 0xBE96, 0x0000,
    0xF7BF, 0x0000, 0x42CE, 0x0000, 0x5C1A, 0x0000, 0x4F68, 0x0000,
    0x0670, 0x0000, 0xBEFA, 0x0000, 0xAE27, 0x0000, 0xCF8F, 0x0000,
    0xFDDF, 0x0000, 0x4423, 0x0000, 0x60F8, 0x0000, 0x4BB9, 0x0000,
    0xFE45, 0x0000, 0xD09E, 0x0000, 0x9948, 0x0000, 0xC54D, 0x0000,
    0xFDC3, 0x0000, 0x39BB, 0x0000, 0x5EC7, 0x0000, 0x41CD, 0x0000,
    0x07A5, 0x0000, 0xBD80, 0x0000, 0xA930, 0x0000, 0xC076, 0x0000,
    0xF844, 0x0000, 0x4758, 0x0000, 0x5220, 0x0000, 0x3DA1, 0x0000,
    0xFAB5, 0x0000, 0xBD06, 0x0000, 0xA0A1, 0x0000, 0xBBE5, 0x0000,
    0xFAE2, 0x0000, 0x470D, 0x0000, 0x55C7, 0x0000, 0x38C4, 0x0000,
    0xFD11, 0x0000, 0xB756, 0x0000, 0xAADC, 0x0000, 0xBE8A, 0x0000,
    0x02D8, 0x0000, 0x41D0, 0x0000, 0x5144, 0x0000, 0x44FE, 0x0000,
    0x0608, 0x0000, 0xC53E, 0x0000, 0xA926, 0x0000, 0xCEB0, 0x0000,
    0xF816, 0x0000, 0x4544, 0x0000, 0x5811, 0x0000, 0x44AB, 0x0000,
    0x0508, 0x0000, 0xBC5A, 0x0000, 0xA494, 0x0000, 0xBDE8, 0x0000,
    0x0EF6, 0x0000, 0x3C4B, 0x0000, 0x5BB0, 0x0000, 0x3686, 0x0000,
    0xFB15, 0x0000, 0xC48F, 0x0000, 0x9B54, 0x0000, 0xC5D5, 0x0000,
    0xF7DD, 0x0000, 0x435C, 0x0000, 0x50EB, 0x0000, 0x33A1, 0x0000,
    0x0B2C, 0x0000, 0xB552, 0x0000, 0xA039, 0x0000, 0xBDBC, 0x0000,
    0xFC63, 0x0000, 0x3B99, 0x0000, 0x4FAC, 0x0000, 0x3BA1, 0x0000,
    0x014C, 0x0000, 0xB5FF, 0x0000, 0xAD76, 0x0000, 0xCAFF, 0x0000,
    0xFB4D, 0x0000, 0x3B5F, 0x0000, 0x572A, 0x0000, 0x3339, 0x0000,
    0x07B7, 0x0000, 0xBFDA, 0x0000, 0xA7CF, 0x0000, 0xBFC7, 0x0000,
    0x00AE, 0x0000, 0x3CBF, 0x0000, 0x5994, 0x0000, 0x42C9, 0x0000,
    0xF790, 0x0000, 0xC149, 0x0000, 0xA51D, 0x0000, 0xBF32, 0x0000,
    0x0045, 0x0000, 0x464E, 0x0000, 0x488A, 0x0000, 0x4025, 0x0000,
    0x072C, 0x0000, 0xBB16, 0x0000, 0xA8CF, 0x0000, 0xB85A, 0x0000,
    0xFA50, 0x0000, 0x49B3, 0x0000, 0x5929, 0x0000, 0x4388, 0x0000,
    0xF6C2, 0x0000, 0xBD4D, 0x0000, 0xA9F2, 0x0000, 0xBF16, 0x0000,
    0x07D5, 0x0000, 0x3B22, 0x0000, 0x5676, 0x0000, 0x38EB, 0x0000,
    0xFE89, 0x0000, 0xBD33, 0x0000, 0xA8C9, 0x0000, 0xC883, 0x0000,
    0xFD7A, 0x0000, 0x4052, 0x0000, 0x56D2, 0x0000, 0x3A80, 0x0000,
    0xFDFD, 0x0000, 0xBFA3, 0x0000, 0xA73C, 0x0000, 0xBF19, 0x0000,
    0xF85C, 0x0000, 0x433A, 0x0000, 0x663E, 0x0000, 0x3FB5, 0x0000,
    0x0229, 0x0000, 0xBEE1, 0x0000, 0xA3B7, 0x0000, 0xC067, 0x0000,
    0xFC3D, 0x0000, 0x411B, 0x0000, 0x65DC, 0x0000, 0x37E5, 0x0000,
    0xFDF5, 0x0000, 0xBE61, 0x0000, 0xA1D5, 0x0000, 0xB70E, 0x0000,
    0xFA59, 0x0000, 0x419E, 0x0000, 0x56D2, 0x0000, 0x36C0, 0x0000,
    0x02C5, 0x0000, 0xC855, 0x0000, 0xAB3B, 0x0000, 0xBFD6, 0x0000,
    0xFEA6, 0x0000, 0x491C, 0x0000, 0x4C8C, 0x0000, 0x3DDE, 0x0000,
    0x034A, 0x0000, 0xBC46, 0x0000, 0xA582, 0x0000, 0xB693, 0x0000,
    0xFB9F, 0x0000, 0x40C1, 0x0000, 0x4FF7, 0x0000, 0x3F6E, 0x0000,
    0xFD43, 0x0000, 0xC1EE, 0x0000, 0xAA5C, 0x0000, 0xC94D, 0x0000,
    0xFBD5, 0x0000, 0x3E9F, 0x0000, 0x5A07, 0x0000, 0x4172, 0x0000,
    0xFD1A, 0x0000, 0xBEFE, 0x0000, 0xA622, 0x0000, 0xB69B, 0x0000,
    0x0166, 0x0000, 0x476E, 0x0000, 0x5528, 0x0000, 0x37AB, 0x0000,
    0xF336, 0x0000, 0xC00C, 0x0000, 0xA3D4, 0x0000, 0xC264, 0x0000,
    0xF958, 0x0000, 0x4110, 0x0000, 0x5CD4, 0x0000, 0x3659, 0x0000,
    0x0560, 0x0000, 0xB9E7, 0x0000, 0xA65E, 0x0000, 0xBEDE, 0x0000,
    0x01C3, 0x0000, 0x3E5E, 0x0000, 0x5A55, 0x0000, 0x473B, 0x0000,
    0x06E4, 0x0000, 0xB2EE, 0x0000, 0xA6E1, 0x0000, 0xC542, 0x0000,
    0x126E, 0x0000, 0x3F8C, 0x0000, 0x5FF8, 0x0000, 0x4E72, 0x0000,
    0x06C6, 0x0000, 0xC8F7, 0x0000, 0x9F0D, 0x0000, 0xCC3B, 0x0000,
    0xF4FD, 0x0000, 0x3AF7, 0x0000, 0x6081, 0x0000, 0x40B5, 0x0000,
    0x038A, 0x0000, 0xB6EA, 0x0000, 0xAED3, 0x0000, 0xC8B6, 0x0000,
    0x0361, 0x0000, 0x384F, 0x0000, 0x5892, 0x0000, 0x3F0B, 0x0000,
    0x008C, 0x0000, 0xBC6E, 0x0000, 0xA749, 0x0000, 0xC385, 0x0000,
    0x0672, 0x0000, 0x3963, 0x0000, 0x5C3C, 0x0000, 0x3F5F, 0x0000,
    0xFD3E, 0x0000, 0xC5FF, 0x0000, 0x9DC6, 0x0000, 0xCD34, 0x0000,
    0x0289, 0x0000, 0x3AA7, 0x0000, 0x5E18, 0x0000, 0x3E3D, 0x0000,
    0x03B8, 0x0000, 0xC1CB, 0x0000, 0x9D2F, 0x0000, 0xBB8C, 0x0000,
    0xFADA, 0x0000, 0x3DD0, 0x0000, 0x55E5, 0x0000, 0x511B, 0x0000,
    0x007D, 0x0000, 0xC3C1, 0x0000, 0xA6C5, 0x0000, 0xC367, 0x0000,
    0x04BE, 0x0000, 0x4318, 0x0000, 0x5C5B, 0x0000, 0x3971, 0x0000,
    0xFCC4, 0x0000, 0xC301, 0x0000, 0xAAEA, 0x0000, 0xC3D1, 0x0000,
    0x0517, 0x0000, 0x4176, 0x0000, 0x5594, 0x0000, 0x4A86, 0x0000,
    0x0253, 0x0000, 0xC233, 0x0000, 0xA854, 0x0000, 0xB0A7, 0x0000,
    0xFBFD, 0x0000, 0x4555, 0x0000, 0x6855, 0x0000, 0x3FDD, 0x0000,
    0x013B, 0x0000, 0xBED0, 0x0000, 0xA8EA, 0x0000, 0xC0E7, 0x0000,
    0x0A0B, 0x0000, 0x387E, 0x0000, 0x5ACC, 0x0000, 0x3732, 0x0000,
    0x0272, 0x0000, 0xAFFF, 0x0000, 0xA1C0, 0x0000, 0xBBC7, 0x0000,
    0x02D6, 0x0000, 0x3210, 0x0000, 0x5517, 0x0000, 0x4164, 0x0000,
    0x0331, 0x0000, 0xC10D, 0x0000, 0xA284, 0x0000, 0xC9E6, 0x0000,
    0xF9AE, 0x0000, 0x3DC5, 0x0000, 0x5BD8, 0x0000, 0x4336, 0x0000,
    0x0054, 0x0000, 0xC673, 0x0000, 0xAAD8, 0x0000, 0xC6A0, 0x0000,
    0x0415, 0x0000, 0x43E0, 0x0000, 0x5D68, 0x0000, 0x37AB, 0x0000,
    0x06CB, 0x0000, 0xB6D8, 0x0000, 0xA662, 0x0000, 0xB7AB, 0x0000,
    0x0485, 0x0000, 0x4317, 0x0000, 0x580E, 0x0000, 0x3F4F, 0x0000,
    0x06B0, 0x0000, 0xC404, 0x0000, 0xA231, 0x0000, 0xB7D6, 0x0000,
    0x00EE, 0x0000, 0x40ED, 0x0000, 0x5437, 0x0000, 0x36A9, 0x0000,
    0xF7B7, 0x0000, 0xBEB8, 0x0000, 0x9F45, 0x0000, 0xBF64, 0x0000,
    0xFFAD, 0x0000, 0x44AD, 0x0000, 0x59E8, 0x0000, 0x41B1, 0x0000,
    0x01F9, 0x0000, 0xC5FC, 0x0000, 0xAD1E, 0x0000, 0xCA33, 0x0000,
    0xF811, 0x0000, 0x437B, 0x0000, 0x533C, 0x0000, 0x395E, 0x0000,
    0xFD8D, 0x0000, 0xB87C, 0x0000, 0x9ADB, 0x0000, 0xCA97, 0x0000,
    0xFEB2, 0x0000, 0x3601, 0x0000, 0x5AEC, 0x0000, 0x3D1E, 0x0000,
    0x0399, 0x0000, 0xBCFE, 0x0000, 0xAA69, 0x0000, 0xC0EF, 0x0000,
    0xFB95, 0x0000, 0x46F7, 0x0000, 0x559A, 0x0000, 0x386E, 0x0000,
    0xFD56, 0x0000, 0xC294, 0x0000, 0xAF0F, 0x0000, 0xB4EF, 0x0000,
    0xFBDB, 0x0000, 0x3C62, 0x0000, 0x53D6, 0x0000, 0x4258, 0x0000,
    0xF14C, 0x0000, 0xC2CA, 0x0000, 0xAB87, 0x0000, 0xC7AD, 0x0000,
    0x0044, 0x0000, 0x3994, 0x0000, 0x587C, 0x0000, 0x3C0D, 0x0000,
    0x036F, 0x0000, 0xC567, 0x0000, 0xA631, 0x0000, 0xBC68, 0x0000,
    0x07DD, 0x0000, 0x41F4, 0x0000, 0x4FAC, 0x0000, 0x43C5, 0x0000,
    0xFAE7, 0x0000, 0xCA53, 0x0000, 0xA898, 0x0000, 0xBCB2, 0x0000,
    0xFA7D, 0x0000, 0x4192, 0x0000, 0x5929, 0x0000, 0x4459, 0x0000,
    0x020A, 0x0000, 0xB866, 0x0000, 0xA820, 0x0000, 0xBE17, 0x0000,
    0x0800, 0x0000, 0x3EB2, 0x0000, 0x5ABE, 0x0000, 0x33F7, 0x0000,
    0xF8CF, 0x0000, 0xC026, 0x0000, 0xB0BF, 0x0000, 0xCB8A, 0x0000,
    0x06C1, 0x0000, 0x44CA, 0x0000, 0x62E0, 0x0000, 0x4164, 0x0000,
    0xFA6A, 0x0000, 0xC0F6, 0x0000, 0xB5AE, 0x0000, 0xC41B, 0x0000,
    0x036A, 0x0000, 0x374F, 0x0000, 0x60FB, 0x0000, 0x3E6E, 0x0000,
    0x001D, 0x0000, 0xC892, 0x0000, 0x9BFB, 0x0000, 0xBC31, 0x0000,
    0x001D, 0x0000, 0x3D92, 0x0000, 0x5652, 0x0000, 0x45C8, 0x0000,
    0x080B, 0x0000, 0xC0D4, 0x0000, 0xA63E, 0x0000, 0xBC68, 0x0000,
    0x01DF, 0x0000, 0x3BEA, 0x0000, 0x59C1, 0x0000, 0x4104, 0x0000,
    0x035E, 0x0000, 0xAE61, 0x0000, 0xAD6E, 0x0000, 0xC403, 0x0000,
    0x07D1, 0x0000, 0x3FB4, 0x0000, 0x56FF, 0x0000, 0x4649, 0x0000,
    0x0880, 0x0000, 0xBE63, 0x0000, 0xA6DA, 0x0000, 0xC68F, 0x0000,
    0x067D, 0x0000, 0x3D6E, 0x0000, 0x509B, 0x0000, 0x4131, 0x0000,
    0x03FB, 0x0000, 0xC30A, 0x0000, 0x9FE1, 0x0000, 0xB5C5, 0x0000,
    0x061E, 0x0000, 0x3337, 0x0000, 0x596D, 0x0000, 0x4652, 0x0000,
    0x0721, 0x0000, 0xBAB1, 0x0000, 0xA95B, 0x0000, 0xB533, 0x0000,
    0x04C7, 0x0000, 0x386C, 0x0000, 0x568D, 0x0000, 0x3A23, 0x0000,
    0xFF32, 0x0000, 0xBC6B, 0x0000, 0xAF68, 0x0000, 0xC977, 0x0000,
    0x0426, 0x0000, 0x4371, 0x0000, 0x5E95, 0x0000, 0x36A1, 0x0000,
    0xFB4A, 0x0000, 0xB6EE, 0x0000, 0xA950, 0x0000, 0xBF6E, 0x0000,
    0x0D55, 0x0000, 0x401F, 0x0000, 0x69C6, 0x0000, 0x3B6D, 0x0000,
    0xF8CB, 0x0000, 0xB2FD, 0x0000, 0x9E2A, 0x0000, 0xBF55, 0x0000,
    0x00A0, 0x0000, 0x3D2D, 0x0000, 0x637C, 0x0000, 0x3D70, 0x0000,
    0xFF46, 0x0000, 0xC17A, 0x0000, 0x9E59, 0x0000, 0xBCA8, 0x0000,
    0xF3B8, 0x0000, 0x3F1B, 0x0000, 0x60C6, 0x0000, 0x4F96, 0x0000,
    0xF887, 0x0000, 0xBA52, 0x0000, 0x9E64, 0x0000, 0xBDF8, 0x0000,
    0xFC95, 0x0000, 0x40FA, 0x0000, 0x5A76, 0x0000, 0x4330, 0x0000,
    0xFBBA, 0x0000, 0xC920, 0x0000, 0x9973, 0x0000, 0xC3B2, 0x0000,
    0xFF8E, 0x0000, 0x4086, 0x0000, 0x6297, 0x0000, 0x3E07, 0x0000,
    0x07F4, 0x0000, 0xBAB7, 0x0000, 0x9C9A, 0x0000, 0xBAF1, 0x0000,
    0x0773, 0x0000, 0x3B2D, 0x0000, 0x699A, 0x0000, 0x44BD, 0x0000,
    0x00A5, 0x0000, 0xC146, 0x0000, 0xA8A3, 0x0000, 0xC945, 0x0000,
    0x0777, 0x0000, 0x437D, 0x0000, 0x58DE, 0x0000, 0x4475, 0x0000,
    0x0B5D, 0x0000, 0xC76D, 0x0000, 0xA168, 0x0000, 0xC598, 0x0000,
    0x0326, 0x0000, 0x4595, 0x0000, 0x5ED7, 0x0000, 0x3FFB, 0x0000,
    0xFB51, 0x0000, 0xCC82, 0x0000, 0xADEA, 0x0000, 0xBA2A, 0x0000,
    0x0BF5, 0x0000, 0x468C, 0x0000, 0x5DFC, 0x0000, 0x3CD1, 0x0000,
    0x059C, 0x0000, 0xB81A, 0x0000, 0xAAEA, 0x0000, 0xBA8F, 0x0000,
    0x093A, 0x0000, 0x4785, 0x0000, 0x627A, 0x0000, 0x3E24, 0x0000,
    0xFA83, 0x0000, 0xB6E7, 0x0000, 0xBBEB, 0x0000, 0xBD64, 0x0000,
    0xF09A, 0x0000, 0x3BA6, 0x0000, 0x5945, 0x0000, 0x3C9E, 0x0000,
    0x0A1D, 0x0000, 0xD25F, 0x0000, 0xAB83, 0x0000, 0xBEDD, 0x0000,
    0xFC8C, 0x0000, 0x4256, 0x0000, 0x567A, 0x0000, 0x3DF4, 0x0000,
    0x0537, 0x0000, 0xB260, 0x0000, 0xA58A, 0x0000, 0xBA5E, 0x0000,
    0x02AD, 0x0000, 0x4267, 0x0000, 0x61B2, 0x0000, 0x3F67, 0x0000,
    0x0638, 0x0000, 0xCAEB, 0x0000, 0xA5EB, 0x0000, 0xC503, 0x0000,
    0x0137, 0x0000, 0x427F, 0x0000, 0x5A35, 0x0000, 0x43B1, 0x0000,
    0xFA85, 0x0000, 0xBD44, 0x0000, 0xAC3D, 0x0000, 0xB74D, 0x0000,
    0x0596, 0x0000, 0x410C, 0x0000, 0x638D, 0x0000, 0x41E2, 0x0000,
    0xF5E3, 0x0000, 0xCA0C, 0x0000, 0x94A7, 0x0000, 0xBF3F, 0x0000,
    0xFE1A, 0x0000, 0x382D, 0x0000, 0x5965, 0x0000, 0x44F0, 0x0000,
    0xFFAA, 0x0000, 0xC639, 0x0000, 0xB603, 0x0000, 0xC9FB, 0x0000,
    0xF945, 0x0000, 0x41F7, 0x0000, 0x5D22, 0x0000, 0x4648, 0x0000,
    0x05F0, 0x0000, 0xB81A, 0x0000, 0xA9AB, 0x0000, 0xB87F, 0x0000,
    0xF7E9, 0x0000, 0x4357, 0x0000, 0x5B93, 0x0000, 0x3913, 0x0000,
    0x018C, 0x0000, 0xC60F, 0x0000, 0xA83B, 0x0000, 0xC6AF, 0x0000,
    0xFC90, 0x0000, 0x440E, 0x0000, 0x6179, 0x0000, 0x4E8A, 0x0000,
    0x0324, 0x0000, 0xBE61, 0x0000, 0xA111, 0x0000, 0xCF44, 0x0000,
    0xFEEA, 0x0000, 0x3FB2, 0x0000, 0x52A7, 0x0000, 0x3FC2, 0x0000,
    0x009A, 0x0000, 0xC0E5, 0x0000, 0xA78A, 0x0000, 0xC28A, 0x0000,
    0xFE94, 0x0000, 0x41B2, 0x0000, 0x61A8, 0x0000, 0x43F1, 0x0000,
    0xFA1D, 0x0000, 0xC146, 0x0000, 0xAC37, 0x0000, 0xB7C0, 0x0000,
    0x00AF, 0x0000, 0x3E52, 0x0000, 0x592A, 0x0000, 0x3329, 0x0000,
    0x0097, 0x0000, 0xC66D, 0x0000, 0xA56C, 0x0000, 0xBECA, 0x0000,
    0xFB35, 0x0000, 0x3EF1, 0x0000, 0x6014, 0x0000, 0x3819, 0x0000,
    0xFD0E, 0x0000, 0xBAC0, 0x0000, 0xA4A8, 0x0000, 0xC88E, 0x0000,
    0x01CC, 0x0000, 0x4369, 0x0000, 0x5983, 0x0000, 0x459A, 0x0000,
    0xFC18, 0x0000, 0xC3CA, 0x0000, 0xAC2B, 0x0000, 0xB8B6, 0x0000,
    0x02D5, 0x0000, 0x4092, 0x0000, 0x60F8, 0x0000, 0x3B89, 0x0000,
    0xF229, 0x0000, 0xC5FB, 0x0000, 0x9B8A, 0x0000, 0xC276, 0x0000,
    0xFD64, 0x0000, 0x3F68, 0x0000, 0x6669, 0x0000, 0x3E51, 0x0000,
    0xFC01, 0x0000, 0xBBCF, 0x0000, 0xAAA8, 0x0000, 0xCCD1, 0x0000,
    0x01A8, 0x0000, 0x3CAE, 0x0000, 0x5A25, 0x0000, 0x42C4, 0x0000,
    0xFCAC, 0x0000, 0xC35A, 0x0000, 0xA391, 0x0000, 0xB787, 0x0000,
    0x05F6, 0x0000, 0x4CCF, 0x0000, 0x5821, 0x0000, 0x4846, 0x0000,
    0xFD61, 0x0000, 0xB70E, 0x0000, 0xAA65, 0x0000, 0xC69F, 0x0000,
    0xFF66, 0x0000, 0x3BD0, 0x0000, 0x589D, 0x0000, 0x3A2C, 0x0000,
    0x07B8, 0x0000, 0xC54A, 0x0000, 0xA407, 0x0000, 0xC97B, 0x0000,
    0x0AC7, 0x0000, 0x3DB8, 0x0000, 0x5BD3, 0x0000, 0x47B7, 0x0000,
    0xFDC6, 0x0000, 0xCA04, 0x0000, 0xA10C, 0x0000, 0xC398, 0x0000,
    0xFFB7, 0x0000, 0x4576, 0x0000, 0x5C6F, 0x0000, 0x38ED, 0x0000,
    0x1011, 0x0000, 0xC28C, 0x0000, 0xA474, 0x0000, 0xC243, 0x0000,
    0x086D, 0x0000, 0x418A, 0x0000, 0x5DDC, 0x0000, 0x3300, 0x0000,
    0xFCC2, 0x0000, 0xBD3B, 0x0000, 0xA940, 0x0000, 0xC28F, 0x0000,
    0x047A, 0x0000, 0x4606, 0x0000, 0x4D8F, 0x0000, 0x3FD0, 0x0000,
    0x08D0, 0x0000, 0xC391, 0x0000, 0xABA8, 0x0000, 0xC135, 0x0000,
    0xF41D, 0x0000, 0x4345, 0x0000, 0x479C, 0x0000, 0x4260, 0x0000,
    0x076F, 0x0000, 0xC71B, 0x0000, 0xA897, 0x0000, 0xC854, 0x0000,
    0x106A, 0x0000, 0x3C8D, 0x0000, 0x55D4, 0x0000, 0x341D, 0x0000,
    0xFB1A, 0x0000, 0xBF82, 0x0000, 0xA61C, 0x0000, 0xC02B, 0x0000,
    0xF8C0, 0x0000, 0x499A, 0x0000, 0x5F94, 0x0000, 0x3D12, 0x0000,
    0x0006, 0x0000, 0xC0C6, 0x0000, 0xA2D9, 0x0000, 0xC591, 0x0000,
    0xF464, 0x0000, 0x3BF0, 0x0000, 0x5C59, 0x0000, 0x3483, 0x0000,
    0x02C8, 0x0000, 0xC67C, 0x0000, 0xA134, 0x0000, 0xC979, 0x0000,
    0x000D, 0x0000, 0x43C6, 0x0000, 0x5471, 0x0000, 0x32E9, 0x0000,
    0xFF39, 0x0000, 0xCA59, 0x0000, 0xA02D, 0x0000, 0xC14A, 0x0000,
    0xFC29, 0x0000, 0x39F2, 0x0000, 0x61EC, 0x0000, 0x4121, 0x0000,
    0xFEA4, 0x0000, 0xC1F0, 0x0000, 0x9F8D, 0x0000, 0xD210, 0x0000,
    0x00DF, 0x0000, 0x4155, 0x0000, 0x5142, 0x0000, 0x3D98, 0x0000,
    0xFA65, 0x0000, 0xC572, 0x0000, 0xA9E5, 0x0000, 0xBB79, 0x0000,
    0x09C6, 0x0000, 0x3ADD, 0x0000, 0x5E57, 0x0000, 0x40A9, 0x0000,
    0xEED8, 0x0000, 0xCC19, 0x0000, 0xA501, 0x0000, 0xC55F, 0x0000,
    0xFD48, 0x0000, 0x4541, 0x0000, 0x5AB1, 0x0000, 0x3BCA, 0x0000,
    0x0284, 0x0000, 0xB861, 0x0000, 0xA0F7, 0x0000, 0xC6FB, 0x0000,
    0x05D5, 0x0000, 0x4235, 0x0000, 0x6376, 0x0000, 0x3EE7, 0x0000,
    0xF984, 0x0000, 0xCDBD, 0x0000, 0xAE9C, 0x0000, 0xB547, 0x0000,
    0x0990, 0x0000, 0x4497, 0x0000, 0x5BBF, 0x0000, 0x416C, 0x0000,
    0x0829, 0x0000, 0xC992, 0x0000, 0xAB2D, 0x0000, 0xCDC5, 0x0000,
    0x025B, 0x0000, 0x3DFE, 0x0000, 0x58E6, 0x0000, 0x3BAA, 0x0000,
    0xF656, 0x0000, 0xCD3A, 0x0000, 0xA52F, 0x0000, 0xBB7F, 0x0000,
    0x07D6, 0x0000, 0x46D9, 0x0000, 0x4C24, 0x0000, 0x3AAD, 0x0000,
    0x05A4, 0x0000, 0xC9F2, 0x0000, 0xA744, 0x0000, 0xC399, 0x0000,
    0x0626, 0x0000, 0x3A4F, 0x0000, 0x6010, 0x0000, 0x3C68, 0x0000,
    0xFC09, 0x0000, 0xBE22, 0x0000, 0xABF4, 0x0000, 0xBF85, 0x0000,
    0x011D, 0x0000, 0x484E, 0x0000, 0x57D4, 0x0000, 0x44EA, 0x0000,
    0x0A42, 0x0000, 0xC28B, 0x0000, 0xAD72, 0x0000, 0xB72F, 0x0000,
    0xFD03, 0x0000, 0x37E0, 0x0000, 0x57C6, 0x0000, 0x3B7F, 0x0000,
    0x01CF, 0x0000, 0xC488, 0x0000, 0xA65B, 0x0000, 0xB5D3, 0x0000,
    0xFF6E, 0x0000, 0x3A5D, 0x0000, 0x5D4B, 0x0000, 0x39CE, 0x0000,
    0x045C, 0x0000, 0xB918, 0x0000, 0xA38A, 0x0000, 0xC85D, 0x0000,
    0x0083, 0x0000, 0x4399, 0x0000, 0x5525, 0x0000, 0x4536, 0x0000,
    0x034B, 0x0000, 0xBEB7, 0x0000, 0xA955, 0x0000, 0xBE70, 0x0000,
    0xF9C0, 0x0000, 0x3974, 0x0000, 0x5375, 0x0000, 0x4736, 0x0000,
    0xFCAF, 0x0000, 0xBE75, 0x0000, 0xA4C2, 0x0000, 0xC6D9, 0x0000
    };

static const q15_t in_cifft_noisy_4096[8192] = {
    0x0021, 0x0000, 0x0014, 0xFFCE, 0x000E, 0x001D, 0x000E, 0x0013,
    0xFFE5, 0x001C, 0xFFFB, 0x0008, 0x0001, 0x001D, 0xFFF1, 0x0001,
    0x001C, 0xFFFD, 0xFFF6, 0xFFE9, 0xFFDE, 0x0012, 0x0007, 0xFFF4,
    0x000F, 0x0006, 0x0005, 0x0005, 0xFFF6, 0x0020, 0x0009, 0x0003,
    0xFFF2, 0x0029, 0x0003, 0xFFEA, 0x0012, 0x0001, 0xFFFE, 0x0012,
    0x001A, 0xFFFE, 0xFFF9, 0xFFEE, 0xFFF1, 0xFFFA, 0xFFFB, 0xFFE0,
    0xFFF5, 0x0012, 0x0019, 0xFFDE, 0xFFF7, 0x0026, 0xFFD2, 0x002B,
    0x0000, 0x0014, 0x000A, 0x0019, 0xFFFB, 0x0005, 0xFFF5, 0xFFEA,
    0xFFE9, 0xFFFE, 0x000C, 0xFFEF, 0x000A, 0x000F, 0x0000, 0x0009,
    0xFFEE, 0x000C, 0x0007, 0xFFDB, 0x000F, 0x001C, 0x000B, 0xFFE0,
    0xFFD1, 0xFFED, 0xFFE7, 0xFFCF, 0x001D, 0xFFEC, 0x0000, 0xFFF4,
    0xFFF8, 0xFFE7, 0x0002, 0x0028, 0xFFF5, 0xFFF9, 0x001F, 0xFFF2,
    0x0014, 0x000C, 0xFFE4, 0x0009, 0x000C, 0x0000, 0x0006, 0x0004,
    0xFFF3, 0x0002, 0xFFFB, 0xFFE8, 0xFFF6, 0x000C, 0xFFFB, 0xFFEE,
    0x000D, 0x0006, 0x000B, 0x0005, 0x0002, 0x0000, 0x0008, 0xFFFA,
    0x000A, 0x0001, 0x0000, 0x0008, 0xFFF6, 0x001F, 0x000F, 0xFFEA,
    0xFFE6, 0xFFE6, 0x001A, 0x0011, 0xFFFC, 0x0002, 0x0009, 0xFFED,
    0xFFF8, 0x0021, 0x0012, 0x0015, 0xFFF1, 0xFFF3, 0x0008, 0x0005,
    0x0016, 0x0023, 0xFFE2, 0xFFFB, 0x0026, 0x000C, 0x0015, 0x0006,
    0x000E, 0xFFF4, 0x0007, 0xFFF9, 0x0021, 0xFFDF, 0x0007, 0x000C,
    0x0013, 0xFFF6, 0xFFF6, 0x0012, 0xFFEF, 0xFFFF, 0x0005, 0xFFDC,
    0xFFFC, 0xFFE9, 0x0018, 0xFFF3, 0xFFE0, 0x0010, 0xFFE3, 0xFFD6,
    0xFFDE, 0xFFF6, 0x0015, 0x0011, 0x0009, 0x000A, 0x0004, 0x0002,
    0x0006, 0xFFEC, 0xFFFB, 0x001E, 0x000E, 0x0005, 0xFFE9, 0xFFFD,
    0xFFD4, 0x0003, 0x0010, 0x0000, 0x0005, 0xFFFC, 0x0009, 0x0022,
    0xFFF9, 0x000F, 0x0007, 0xFFFA, 0x0008, 0xFFEA, 0x0004, 0x0001,
    0x0015, 0xFFFB, 0x0007, 0x0006, 0x0010, 0x0000, 0xFFEC, 0xFFDD,
    0x001A, 0xFFFB, 0x0013, 0xFFF9, 0xFFF4, 0xFFF9, 0x000C, 0x0004,
    0x0007, 0xFFFA, 0xFFF1, 0xFFE7, 0x000E, 0xFFFF, 0xFFEE, 0x002B,
    0xFFEC, 0x0006, 0x002D, 0xFFE6, 0x0011, 0x0002, 0xFFF9, 0xFFFC,
    0x0010, 0x0028, 0x000D, 0x0014, 0xFFFE, 0xFFD4, 0xFFF6, 0x0000,
    0xFFDC, 0x0010, 0x0014, 0xFFF0, 0x0010, 0xFFF2, 0xFFFC, 0xFFFD,
    0x0005, 0x0026, 0xFFF2, 0xFFFD, 0xFFD0, 0x000C, 0xFFF8, 0xFFF2,
    0xFFF1, 0x000B, 0x0003, 0xFFFB, 0xFFF0, 0x001D, 0xFFFF, 0x0000,
    0xFFF7, 0x001D, 0x000B, 0xFFFE, 0x0004, 0x0005, 0x0002, 0xFFFE,
    0x0008, 0x0027, 0x0002, 0xFFF2, 0x001B, 0xFFF5, 0x0002, 0xFFEA,
    0xFFE0, 0xFFE8, 0x0002, 0x0019, 0xFFEF, 0x000D, 0x0003, 0x001D,
    0xFFFB, 0x0006, 0xFFF4, 0xFFF0, 0xFFCD, 0xFFF7, 0xFFE8, 0x0016,
    0x000C, 0x0006, 0xFFF7, 0xFFFF, 0x000D, 0xFFF5, 0x0003, 0x0017,
    0x0000, 0x0018, 0x0013, 0xFFFA, 0x0023, 0x001B, 0x000F, 0xFFEA,
    0x0014, 0xFFE4, 0xFFF8, 0xFFFC, 0x0014, 0xFFFF, 0x000B, 0xFFFB,
    0xFFFD, 0xFFFC, 0xFFE5, 0xFFDA, 0xFFF1, 0x0016, 0x0001, 0x0000,
    0x001C, 0xFFFF, 0x0012, 0xFFFE, 0x002C, 0x0004, 0xFFF1, 0xFFEF,
    0xFFF8, 0x0008, 0x0010, 0xFFC2, 0xFFFD, 0x0005, 0x0009, 0xFFED,
    0xFFED, 0x0001, 0x0003, 0xFFE2, 0xFFE7, 0xFFF2, 0xFFEA, 0x001D,
    0xFFFA, 0xFFF4, 0x0013, 0x0004, 0x000B, 0xFFF5, 0xFFF8, 0x0022,
    0x000E, 0xFFEE, 0x0018, 0x000A, 0x0014, 0x000A, 0xFFF4, 0xFFE7,
    0x0012, 0x000F, 0xFFE8, 0xFFEC, 0xFFFF, 0xFFF4, 0xFFEE, 0xFFF7,
    0x000F, 0xFFE3, 0xFFED, 0xFFED, 0xFFF6, 0x000C, 0xFFF1, 0x0003,
    0x0018, 0xFFEC, 0x0016, 0x000C, 0xFFEC, 0x0014, 0x000D, 0xFFE7,
    0x000F, 0x000B, 0x0016, 0x0014, 0xFFF8, 0xFFF7, 0xFFE9, 0x000D,
    0xFFEB, 0x0015, 0xFFF8, 0xFFF2, 0x000F, 0xFFFF, 0xFFF1, 0xFFF5,
    0x002D, 0xFFE6, 0xFFFD, 0xFFF1, 0xFFE7, 0xFFE7, 0xFFF4, 0xFFFC,
    0x000B, 0xFFFE, 0x0016, 0xFFF9, 0xFFF9, 0x0006, 0x0010, 0x0011,
    0xFFEA, 0xFFEA, 0xFFEE, 0x0020, 0xFFEE, 0x000B, 0x001A, 0x0001,
    0x0011, 0xFFDE, 0x0011, 0xFFF6, 0x0002, 0x0005, 0xFFEF, 0xFFCB,
    0xFFF9, 0x0016, 0x0009, 0xFFF7, 0xFFFA, 0xFFEF, 0xFFF9, 0x0019,
    0x0005, 0xFFFD, 0x0024, 0xFFFB, 0x0008, 0x0019, 0x0011, 0x0005,
    0xFFE9, 0x0005, 0xFFEA, 0xFFF1, 0x002E, 0xFFF8, 0xFFFB, 0xFFEF,
    0x0010, 0xFFFE, 0xFFFD, 0x0014, 0x0004, 0x0005, 0x0003, 0x001B,
    0xFFFA, 0xFFF3, 0xFFFE, 0xFFD9, 0x000F, 0xFFE2, 0xFFEF, 0x002E,
    0x0016, 0x0003, 0x0003, 0x0002, 0x0014, 0x0002, 0x0004, 0x001C,
    0x0001, 0x000D, 0xFFFD, 0xFFF4, 0xFFFB, 0xFFF2, 0xFFFC, 0x0007,
    0x000A, 0x0012, 0x001F, 0xFFF6, 0x000D, 0xFFF7, 0x0015, 0x0003,
    0xFFF7, 0xFFEE, 0xFFF3, 0xFFF3, 0x000D, 0xFFFD, 0x000E, 0xFFF9,
    0xFFF0, 0x0014, 0x0002, 0x0000, 0xFFE7, 0x0017, 0x0003, 0xFFE9,
    0x0007, 0x0001, 0x0012, 0xFFFD, 0xFFF3, 0xFFFF, 0xFFE2, 0xFFEA,
    0xFFFA, 0xFFEB, 0xFFF5, 0x0009, 0xFFF8, 0x0007, 0x0006, 0x000D,
    0x0013, 0xFFF8, 0x0014, 0x000E, 0xFFF9, 0x0026, 0xFFEE, 0xFFFC,
    0xFFFB, 0x0014, 0x000B, 0xFFF0, 0xFFF1, 0x0029, 0xFFEF, 0xFFFA,
    0xFFEC, 0xFFFE, 0x0032, 0xFFE7, 0xFFE0, 0x000D, 0x0005, 0xFFF2,
    0xFFDE, 0xFFFC, 0x0014, 0xFFFB, 0x0010, 0x0001, 0x000A, 0x0013,
    0x0007, 0x0010, 0x0007, 0xFFFB, 0x000A, 0x0023, 0x0017, 0x0007,
    0xFFDC, 0x0017, 0x000A, 0xFFF7, 0x0004, 0xFFED, 0x0003, 0xFFE9,
    0x0007, 0x0009, 0x0014, 0xFFE5, 0x0002, 0x000D, 0x0001, 0xFFEF,
    0x0010, 0xFFF0, 0x001A, 0xFFF1, 0xFFFA, 0xFFE5, 0xFFFA, 0x0004,
    0x001D, 0xFFE4, 0xFFF4, 0xFFF6, 0xFFDD, 0xFFD6, 0xFFFB, 0xFFDC,
    0x001D, 0x0007, 0x0023, 0x0000, 0x000C, 0x000F, 0x0020, 0xFFF8,
    0x0000, 0x0014, 0x0002, 0x000B, 0xFFEE, 0xFFE6, 0x000A, 0x0024,
    0xFFF7, 0x002C, 0x0016, 0x0022, 0xFFF7, 0x0008, 0x0013, 0xFFFF,
    0xFFFF, 0x0017, 0x0006, 0xFFE6, 0x001A, 0xFFFE, 0x0016, 0x0002,
    0xFFF2, 0xFFE8, 0x0011, 0x000B, 0x0001, 0x0005, 0x000C, 0xFFE7,
    0xFFFB, 0x0003, 0x0019, 0xFFF3, 0xFFF2, 0xFFEB, 0xFFF4, 0xFFF8,
    0xFFF5, 0x0002, 0x001E, 0xFFEC, 0x0005, 0xFFD3, 0x0008, 0x0008,
    0x0000, 0xFFF6, 0x0032, 0x0010, 0x0001, 0xFFEA, 0x002C, 0x002C,
    0xFFEA, 0x0000, 0xFFF3, 0xFFFB, 0x000B, 0xFFF3, 0x001C, 0x0005,
    0xFFD7, 0x0002, 0xFFF3, 0x000F, 0x0001, 0x0003, 0x0019, 0xFFEC,
    0xFFE3, 0xFFF6, 0xFFE0, 0x0002, 0x000C, 0x000C, 0x0009, 0x0007,
    0xFFF3, 0xFFF9, 0x0006, 0xFFEA, 0xFFDC, 0xFFF1, 0xFFF3, 0xFFFF,
    0xFFFD, 0x000A, 0x000E, 0x0006, 0xFFD9, 0x0005, 0x0014, 0xFFF9,
    0xFFF3, 0xFFEC, 0x0003, 0x0014, 0x0018, 0xFFE6, 0xFFEB, 0xFFF4,
    0x0004, 0x0019, 0x0002, 0xFFF7, 0x0010, 0xFFF8, 0xFFE4, 0xFFF9,
    0x0004, 0xFFFF, 0x000E, 0x000E, 0x0004, 0x0020, 0x0001, 0xFFF1,
    0xFFFC, 0x0000, 0x0001, 0x0006, 0xFFFE, 0x000B, 0xFFF9, 0x0016,
    0x0013, 0x0002, 0x0007, 0x000B, 0xFFE1, 0xFFEE, 0xFFEE, 0x0017,
    0xFFC9, 0x0000, 0xFFF0, 0x000A, 0xFFF3, 0x0011, 0xFFFF, 0x000A,
    0x001B, 0x0007, 0xFFEC, 0xFFFE, 0x0021, 0x0013, 0x0000, 0xFFF1,
    0xFFFC, 0x001F, 0xFFF8, 0x0028, 0xFFDD, 0xFFE6, 0x0015, 0xFFF3,
    0x0011, 0xFFD5, 0x000E, 0xFFD7, 0xFFFB, 0x0016, 0x000A, 0xFFFC,
    0xFFF6, 0x001C, 0x0009, 0xFFF0, 0xFFEC, 0x0017, 0xFFF0, 0xFFFD,
    0xFFF9, 0xFFFC, 0xFFF5, 0xFFF5, 0xFFD5, 0x000F, 0x0018, 0xFFFF,
    0x0001, 0xFFE8, 0x0006, 0x0000, 0xFFF0, 0x000A, 0x000A, 0x0008,
    0x0016, 0x000A, 0xFFE9, 0xFFF6, 0xFFFC, 0xFFDC, 0xFFEF, 0xFFF1,
    0xFFF5, 0x000E, 0xFFF7, 0xFFE4, 0x001A, 0x0000, 0xFFF0, 0x0003,
    0xFFE3, 0xFFFF, 0x000E, 0xFFF8, 0xFFFB, 0xFFFA, 0x0010, 0xFFEE,
    0xFFF5, 0x000C, 0x0021, 0xFFF7, 0x0007, 0x000C, 0x000D, 0x0005,
    0x0018, 0xFFF8, 0x001C, 0x000B, 0x0000, 0x0007, 0x001F, 0x000D,
    0xFFED, 0xFFDE, 0x0000, 0xFFDE, 0xFFEC, 0xFFEE, 0xFFF4, 0x0028,
    0x0008, 0xFFF3, 0x0001, 0x0009, 0x0004, 0xFFFA, 0x000A, 0x0014,
    0xFFFC, 0x000B, 0xFFF7, 0x000B, 0xFFFA, 0x0016, 0xFFF8, 0x0000,
    0xFFE7, 0x0008, 0x0012, 0xFFFD, 0x0004, 0xFFE0, 0x0015, 0x0001,
    0xFFEC, 0x0016, 0xFFFC, 0x0004, 0xFFFB, 0x0007, 0xFFF9, 0x0002,
    0x0009, 0x0004, 0x0001, 0x0009, 0xFFE6, 0xFFE4, 0xFFE1, 0xFFE3,
    0x0003, 0x0004, 0xFFFD, 0x0005, 0xFFFC, 0xFFFF, 0x0011, 0x0014,
    0xFFED, 0x0031, 0xFFFF, 0xFFFB, 0xFFDD, 0xFFE6, 0x0019, 0x0035,
    0x000C, 0xFFE5, 0xFFF5, 0xFFED, 0x0006, 0x000B, 0x0004, 0x000D,
    0x0004, 0x0004, 0x0003, 0x0025, 0xFFFE, 0xFFFD, 0xFFEB, 0xFFFB,
    0xFFE4, 0x0004, 0xFFEF, 0xFFF3, 0xFFFE, 0xFFF7, 0xFFEA, 0x0003,
    0x0018, 0x0014, 0x0004, 0x001B, 0x001A, 0x000A, 0x0005, 0x0003,
    0x0026, 0x0021, 0x0004, 0xFFF8, 0xFFF9, 0xFFFF, 0x000B, 0x0015,
    0xFFF7, 0x0000, 0x000A, 0x0002, 0x0027, 0x0028, 0xFFEA, 0xFFFB,
    0x0026, 0xFFF7, 0xFFF4, 0x0017, 0x0000, 0xFFEB, 0x001D, 0x0019,
    0xFFF6, 0xFFEC, 0xFFE4, 0xFFE7, 0xFFF3, 0xFFF4, 0x0001, 0x0003,
    0x0002, 0xFFF9, 0x0019, 0xFFF9, 0xFFEE, 0xFFD7, 0x000F, 0x0013,
    0x001C, 0x000E, 0xFFE8, 0x0009, 0xFFE2, 0xFFE9, 0xFFEA, 0xFFEB,
    0xFFF4, 0x0009, 0x0001, 0x0000, 0x0020, 0xFFE3, 0x0007, 0x0002,
    0x001C, 0xFFF3, 0xFFE2, 0x0004, 0x0019, 0x0012, 0xFFF1, 0x0010,
    0x000F, 0x000F, 0xFFFD, 0x000A, 0x0006, 0xFFF7, 0x0015, 0xFFEB,
    0xFFFD, 0xD332, 0x001B, 0xFFF0, 0x0014, 0x000C, 0xFFE9, 0xFFF7,
    0x0013, 0x0007, 0xFFEF, 0xFFF2, 0xFFDB, 0x001B, 0xFFEC, 0x001A,
    0xFFE8, 0x0019, 0x0000, 0x001D, 0xFFF4, 0x0010, 0x000D, 0xFFE1,
    0xFFDB, 0xFFED, 0xFFED, 0x0011, 0x000E, 0xFFFD, 0x0007, 0xFFFB,
    0x0003, 0xFFE0, 0xFFCC, 0x000E, 0xFFDA, 0xFFF5, 0x0004, 0x0013,
    0xFFF6, 0xFFFD, 0x001E, 0xFFF3, 0x000E, 0x0008, 0xFFFD, 0x0015,
    0x0005, 0xFFEF, 0x0017, 0x002D, 0xFFF3, 0x0014, 0xFFFD, 0xFFF8,
    0xFFF8, 0xFFEB, 0x0011, 0x0006, 0xFFEC, 0xFFF1, 0x0009, 0xFFE4,
    0x0005, 0x0008, 0xFFDC, 0xFFF4, 0x000D, 0xFFF9, 0x001E, 0xFFF0,
    0xFFF9, 0xFFFA, 0xFFFB, 0x000D, 0xFFF2, 0xFFDC, 0x000B, 0xFFEA,
    0xFFFC, 0x000F, 0xFFF2, 0xFFE5, 0x0000, 0xFFE4, 0x0008, 0xFFE7,
    0xFFF5, 0xFFF9, 0xFFF2, 0x0017, 0x000C, 0xFFF2, 0xFFFA, 0xFFF8,
    0x0001, 0x0012, 0xFFFD, 0xFFFA, 0xFFFE, 0x0006, 0x0009, 0x0006,
    0xFFE8, 0x0001, 0x0007, 0xFFF7, 0x0001, 0x0002, 0xFFFE, 0x0004,
    0xFFFB, 0x0003, 0x0011, 0x0004, 0x000B, 0x000E, 0x0001, 0xFFE3,
    0xFFF7, 0x000B, 0xFFFA, 0x0015, 0x0008, 0x0024, 0xFFE2, 0xFFEB,
    0x001D, 0x0000, 0xFFE2, 0x0003, 0x000B, 0xFFF0, 0x000A, 0x0013,
    0x0018, 0x0011, 0x0012, 0xFFF1, 0xFFF0, 0x0005, 0x0006, 0x0020,
    0xFFE9, 0xFFE2, 0xFFFC, 0x0000, 0x0017, 0x001A, 0xFFEF, 0xFFEB,
    0xFFF8, 0x0011, 0x0005, 0xFFFB, 0xFFF7, 0xFFF9, 0xFFEB, 0x0003,
    0x0009, 0x0016, 0xFFF7, 0xFFF9, 0xFFF8, 0x0030, 0x0024, 0x0017,
    0xFFF3, 0x0019, 0x0004, 0x0005, 0x0004, 0x0010, 0x0000, 0xFFF8,
    0xFFF8, 0x000F, 0x0001, 0xFFFB, 0xFFF5, 0xFFF0, 0x000C, 0xFFFA,
    0x000C, 0x0004, 0xFFD8, 0x0007, 0x0003, 0x0008, 0x0013, 0x0013,
    0x0018, 0x000C, 0x0028, 0x0007, 0xFFFF, 0xFFFA, 0x0021, 0xFFD5,
    0xFFE7, 0xFFF5, 0x0013, 0x0013, 0xFFE5, 0xFFFB, 0xFFE2, 0x0013,
    0x0004, 0x0002, 0xFFFC, 0xFFEC, 0xFFFE, 0x0004, 0x0023, 0xFFF0,
    0x0002, 0x0005, 0xFFEB, 0xFFED, 0x0000, 0x001D, 0xFFE0, 0x002B,
    0xFFE6, 0x000E, 0xFFF3, 0x0025, 0x0003, 0x000F, 0xFFF3, 0xFFF3,
    0x001C, 0xFFE8, 0x0017, 0xFFF8, 0x000F, 0x0017, 0xFFFF, 0x0025,
    0xFFEF, 0xFFFA, 0x0023, 0xFFEC, 0x0010, 0x0003, 0xFFFB, 0x000A,
    0x0009, 0xFFEE, 0x0008, 0x0017, 0x002C, 0x000B, 0xFFF4, 0xFFFA,
    0x0021, 0x0004, 0x000E, 0xFFF6, 0xFFFD, 0xFFF3, 0x0003, 0x0007,
    0xFFFD, 0xFFD9, 0xFFFA, 0x0005, 0xFFF2, 0xFFFF, 0x0017, 0x0007,
    0xFFF2, 0x0011, 0xFFE2, 0x0001, 0xFFF2, 0x0002, 0xFFFE, 0x0004,
    0xFFFC, 0xFFF2, 0x0004, 0xFFED, 0xFFFD, 0xFFF0, 0x0009, 0x0006,
    0x0018, 0xFFEB, 0xFFEE, 0xFFFE, 0xFFEF, 0x0001, 0xFFE1, 0xFFF8,
    0x0012, 0xFFF5, 0xFFDC, 0xFFFE, 0x0009, 0xFFFA, 0x001B, 0x0003,
    0xFFDB, 0x001D, 0x000D, 0xFFFF, 0x0012, 0xFFF3, 0x0013, 0x000E,
    0x0006, 0xFFFC, 0x0003, 0x002B, 0x0007, 0xFFF9, 0xFFE4, 0x0004,
    0x0013, 0x0004, 0xFFFF, 0xFFFA, 0xFFF9, 0x0013, 0x0002, 0xFFE6,
    0x000E, 0xFFDE, 0xFFF3, 0x0003, 0xFFFB, 0xFFE5, 0xFFEB, 0x0000,
    0x001B, 0xFFFF, 0x0017, 0x0016, 0x0014, 0xFFFE, 0xFFF4, 0x000C,
    0xFFE5, 0x0006, 0x0015, 0x000A, 0x0004, 0x000B, 0x0009, 0xFFDD,
    0x001F, 0xFFFF, 0x0005, 0xFFFC, 0xFFED, 0xFFE8, 0xFFE4, 0x000F,
    0x000D, 0x0000, 0x0007, 0x0009, 0x001A, 0xFFF8, 0xFFE7, 0x0015,
    0xFFF4, 0x0002, 0xFFFF, 0x0004, 0xFFF0, 0xFFF5, 0xFFF6, 0xFFD3,
    0x000D, 0xFFDB, 0x0007, 0xFFEB, 0xFFF1, 0x0016, 0xFFF8, 0xFFF0,
    0x000A, 0x000B, 0x0017, 0x0013, 0x0012, 0xFFF7, 0x0014, 0xFFFD,
    0xFFFF, 0xFFFF, 0x0009, 0xFFEC, 0xFFF6, 0x0011, 0x001E, 0xFFEF,
    0x0005, 0x0011, 0xFFF8, 0x0000, 0x0015, 0xFFF9, 0x000A, 0xFFF9,
    0xFFF5, 0x0002, 0x000D, 0x0015, 0xFFFF, 0xFFEB, 0x0015, 0x0006,
    0x0007, 0x000C, 0x0008, 0xFFF7, 0x0032, 0x000B, 0xFFEA, 0x0024,
    0xFFE9, 0x0002, 0x001F, 0x0001, 0x0008, 0xFFF8, 0x000D, 0x0005,
    0x0008, 0xFFF1, 0x0003, 0xFFF4, 0x000C, 0xFFFB, 0xFFFC, 0xFFEA,
    0x0007, 0x0017, 0xFFF7, 0x0009, 0x0025, 0xFFD9, 0xFFDD, 0x0002,
    0xFFFC, 0x0011, 0xFFFE, 0xFFED, 0xFFE7, 0xFFEB, 0x0024, 0xFFF6,
    0x0009, 0xFFFE, 0x0019, 0xFFE3, 0x0035, 0x0010, 0x000E, 0xFFFD,
    0xFFEA, 0xFFF3, 0x0016, 0xFFEC, 0x0013, 0x0016, 0x000D, 0x0003,
    0xFFE2, 0x0003, 0xFFE0, 0x0003, 0xFFF3, 0xFFF6, 0x000E, 0xFFEC,
    0x0008, 0xFFF5, 0x0001, 0x0012, 0xFFFF, 0xFFFF, 0xFFD3, 0xFFEE,
    0x0006, 0x0005, 0x0009, 0xFFFD, 0xFFDF, 0xFFE7, 0xFFF9, 0xFFF7,
    0xFFFF, 0x000D, 0x001E, 0xFFEC, 0xFFF4, 0x000C, 0x0009, 0x0000,
    0xFFF5, 0xFFFA, 0x0016, 0x0004, 0xFFEC, 0x0032, 0x000A, 0x0001,
    0xFFFD, 0x0002, 0x0002, 0xFFFB, 0xFFFE, 0x000D, 0xFFE6, 0xFFE7,
    0xFFF9, 0x000A, 0xFFF9, 0xFFF2, 0x000C, 0x000A, 0x0005, 0x0000,
    0x000C, 0x0004, 0x001A, 0xFFF6, 0x0011, 0xFFF2, 0xFFF8, 0x0001,
    0xFFEA, 0x0015, 0xFFF9, 0xFFE5, 0xFFFE, 0x0000, 0xFFF0, 0x0017,
    0xFFED, 0x000F, 0x0018, 0xFFFC, 0x000F, 0xFFE7, 0x0001, 0x000B,
    0x0017, 0x000B, 0x0008, 0x000E, 0x000B, 0xFFF9, 0x0022, 0x0019,
    0x0001, 0x0001, 0x0025, 0x0006, 0x0010, 0x000C, 0x0002, 0xFFF4,
    0xFFEC, 0x0007, 0xFFE9, 0xFFF6, 0xFFFD, 0xFFFD, 0xFFF7, 0xFFFE,
    0xFFF4, 0xFFEF, 0x000A, 0x0005, 0x0006, 0xFFF8, 0xFFF3, 0xFFEC,
    0xFFFE, 0xFFF3, 0x0009, 0x000B, 0x000B, 0x0006, 0xFFE5, 0xFFDD,
    0x001B, 0xFFFF, 0x0003, 0xFFF0, 0xFFE4, 0xFFFD, 0xFFEE, 0x0025,
    0xFFF1, 0xFFF8, 0xFFF7, 0x0004, 0x0004, 0xFFFB, 0xFFE9, 0x0038,
    0x000A, 0xFFE9, 0x0012, 0xFFFB, 0x001D, 0xFFDF, 0xFFF1, 0xFFF6,
    0xFFFA, 0x0011, 0x0014, 0xFFF9, 0x0029, 0xFFFF, 0xFFF3, 0xFFFE,
    0x0004, 0xFFFA, 0x0024, 0x0005, 0x0030, 0x0018, 0xFFF4, 0x0012,
    0xFFF3, 0x002C, 0xFFDF, 0xFFF9, 0x000D, 0x0008, 0xFFF5, 0x0007,
    0x0008, 0x0006, 0xFFFC, 0xFFF5, 0x0003, 0x0021, 0x0010, 0x001D,
    0xFFEA, 0xFFF3, 0xFFFC, 0x0025, 0xFFF5, 0xFFFB, 0xFFD8, 0xFFEF,
    0x001A, 0xFFF1, 0xFFDE, 0xFFF5, 0xFFE6, 0xFFF6, 0xFFF2, 0x0024,
    0xFFFA, 0xFFF5, 0x000C, 0x001F, 0xFFF7, 0x000C, 0xFFF9, 0xFFEC,
    0x0003, 0xFFFF, 0xFFFE, 0xFFFA, 0x001D, 0xFFF6, 0xFFEC, 0x000F,
    0x0012, 0xFFE5, 0xFFF1, 0x0014, 0xFFF5, 0xFFF1, 0x000F, 0x0001,
    0xFFEA, 0xFFDE, 0x0009, 0x0019, 0x0015, 0x0002, 0x000F, 0xFFFB,
    0xFFF4, 0xFFE6, 0x0011, 0x0007, 0x0013, 0xFFF5, 0x0014, 0xFFF2,
    0xFFE1, 0x0009, 0x0027, 0xFFDF, 0x0002, 0xFFFE, 0x000A, 0x0017,
    0x001E, 0xFFFC, 0xFFE2, 0xFFEA, 0xFFDF, 0x001B, 0xFFDD, 0xFFF0,
    0xFFF0, 0x0010, 0x0005, 0xFFFA, 0x0004, 0x000B, 0x0001, 0x0002,
    0xFFF7, 0xFFF5, 0xFFF0, 0xFFF3, 0xFFFB, 0xFFF5, 0x0018, 0xFFF2,
    0xFFF4, 0xFFF1, 0x0001, 0x0027, 0x0009, 0xFFFB, 0x0003, 0xFFFB,
    0xFFFE, 0xFFE1, 0xFFEC, 0xFFFC, 0xFFE7, 0x000D, 0x001A, 0x0036,
    0x0017, 0x0013, 0x0003, 0x000A, 0xFFFE, 0x001A, 0xFFFE, 0x0005,
    0x0001, 0xFFF9, 0xFFFD, 0xFFFF, 0xFFFA, 0xFFF9, 0x0018, 0xFFF5,
    0x0013, 0x0011, 0x000A, 0xFFFE, 0xFFFE, 0x0004, 0xFFED, 0x000B,
    0x0014, 0x0006, 0x000C, 0xFFFD, 0xFFF5, 0x0004, 0x0012, 0xFFEE,
    0xFFFE, 0x0005, 0xFFF3, 0x0005, 0x0001, 0x0008, 0x000A, 0xFFFE,
    0xFFEB, 0xFFF3, 0x000D, 0xFFEA, 0x001C, 0xFFF7, 0x0011, 0x001B,
    0xFFF8, 0xFFE9, 0xFFF7, 0x0012, 0x0021, 0xFFFB, 0xFFF7, 0x0008,
    0xFFED, 0x0009, 0xFFFC, 0xFFF1, 0x0009, 0xFFFC, 0xFFF0, 0xFFF6,
    0x0004, 0x0012, 0x0007, 0x000E, 0xFFF9, 0xFFFF, 0x0016, 0x0005,
    0xFFEA, 0xFFF7, 0xFFF9, 0xFFEF, 0xFFF5, 0x0016, 0xFFF1, 0xFFFE,
    0xFFFE, 0x0019, 0xFFFC, 0x0001, 0x000B, 0xFFFE, 0x0002, 0xFFEC,
    0xFFF9, 0x000C, 0x0005, 0x0002, 0x0026, 0x0009, 0x0014, 0x000E,
    0x0005, 0xFFFC, 0x0005, 0x000D, 0xFFEF, 0xFFE1, 0x0021, 0xFFF8,
    0xFFFF, 0xFFF9, 0xFFF6, 0xFFF6, 0xFFF8, 0xFFFB, 0x0009, 0xFFFC,
    0xFFF0, 0x0009, 0x0010, 0xFFFF, 0x0005, 0x0010, 0x0001, 0xFFF6,
    0x0023, 0x000F, 0xFFF5, 0x0007, 0x0009, 0xFFF6, 0xFFF4, 0xFFFA,
    0xFFF1, 0xFFE8, 0x0007, 0x0016, 0xFFE3, 0xFFF8, 0x0007, 0xFFFD,
    0x0014, 0x0001, 0x0006, 0x0000, 0xFFF9, 0xFFCE, 0xFFFB, 0x0002,
    0x000F, 0x001B, 0x0000, 0x0008, 0xFFFC, 0x0028, 0x0017, 0x0026,
    0xFFFE, 0x000D, 0xFFE8, 0xFFF4, 0xFFFE, 0xFFE4, 0x0017, 0xFFE1,
    0x000A, 0x000A, 0xFFE9, 0xFFF3, 0x0012, 0x0012, 0x0001, 0x000D,
    0xFFED, 0xFFF7, 0x0008, 0xFFEB, 0xFFF5, 0x0004, 0x000C, 0x000E,
    0x0003, 0xFFE5, 0x0006, 0xFFFB, 0xFFF5, 0x0015, 0x0016, 0x0006,
    0x000B, 0x001D, 0x0019, 0x001C, 0xFFFA, 0x0018, 0xFFE5, 0x0003,
    0xFFE6, 0x0006, 0xFFFA, 0xFFFF, 0xFFED, 0x000D, 0xFFF1, 0x0008,
    0xFFFD, 0x000C, 0x0008, 0x0017, 0x0007, 0x000C, 0xFFFF, 0xFFF6,
    0x000D, 0x0008, 0x000B, 0xFFFA, 0xFFF8, 0xFFF0, 0xFFF0, 0x001C,
    0x001F, 0xFFFD, 0x000D, 0x0007, 0xFFFC, 0x0003, 0x0031, 0xFFFB,
    0xFFFB, 0xFFFC, 0xFFEF, 0x0000, 0xFFEA, 0xFFF0, 0x0031, 0xFFF8,
    0x000A, 0x0024, 0x002B, 0x002C, 0xFFF8, 0x000F, 0xFFE7, 0xFFD9,
    0xFFE9, 0x0014, 0xFFFC, 0x0006, 0x0006, 0xFFFE, 0xFFF8, 0xFFEA,
    0xFFF5, 0xFFF3, 0xFFF8, 0xFFF6, 0xFFF8, 0x0006, 0xFFF0, 0xFFEA,
    0x0020, 0x0000, 0xFFF2, 0x0001, 0x0001, 0xFFFD, 0xFFEF, 0xFFFB,
    0x000F, 0xFFF1, 0xFFF0, 0xFFFB, 0xFFF1, 0xFFFD, 0xFFFF, 0xFFFC,
    0xFFF5, 0x0005, 0x0008, 0x0003, 0x0009, 0x0015, 0xFFF4, 0xFFDD,
    0x002B, 0xFFE5, 0xFFF6, 0x0001, 0x000D, 0xFFEE, 0x0012, 0x000B,
    0x0001, 0x0016, 0x0018, 0x0010, 0x0004, 0xFFFA, 0x000B, 0x000B,
    0xFFFB, 0x0005, 0x0002, 0x000B, 0xFFFD, 0x000C, 0x0003, 0xFFDA,
    0x0000, 0xFFFE, 0xFFF0, 0x0003, 0xFFFD, 0x0005, 0x0004, 0x001A,
    0x001A, 0x0018, 0xFFF9, 0x0014, 0xFFFD, 0xFFEE, 0x0023, 0xFFF7,
    0x0012, 0xFFEE, 0x0017, 0x0007, 0x0004, 0xFFFA, 0xFFFB, 0xFFFD,
    0x000C, 0x0002, 0x0010, 0x001D, 0x0012, 0x0000, 0xFFEF, 0x0009,
    0x0005, 0x0010, 0xFFD5, 0xFFEA, 0xFFEE, 0xFFFC, 0x0004, 0x0014,
    0x002C, 0x000B, 0xFFE3, 0x0023, 0x0019, 0xFFF1, 0x0000, 0xFFFC,
    0xFFE4, 0xFFF6, 0x0016, 0xFFE3, 0xFFFA, 0x0004, 0xFFE8, 0x000B,
    0x000C, 0xFFEE, 0xFFE1, 0xFFEC, 0xFFFB, 0x0002, 0xFFF3, 0x0007,
    0xFFDA, 0x0013, 0xFFDF, 0x0005, 0xFFF2, 0x000E, 0xFFF7, 0x0000,
    0x0011, 0x0027, 0xFFFD, 0xFFED, 0x0002, 0xFFF8, 0x0020, 0x0017,
    0xFFF3, 0x000A, 0xFFED, 0xFFF8, 0xFFFC, 0x0003, 0x0007, 0x0017,
    0x0005, 0xFFEC, 0xFFED, 0xFFFD, 0xFFD9, 0xFFFE, 0xFFFE, 0xFFFD,
    0x000E, 0x0025, 0x0013, 0xFFF0, 0xFFF9, 0x000C, 0x001D, 0x0003,
    0x0000, 0x0017, 0x0007, 0xFFE3, 0xFFF4, 0xFFEA, 0xFFEE, 0x0004,
    0xFFF4, 0x0001, 0x0016, 0xFFF4, 0x0019, 0x000C, 0xFFF8, 0x0008,
    0x0006, 0xFFFD, 0xFFCE, 0xFFF5, 0x0006, 0x0016, 0x0017, 0xFFFF,
    0xFFFE, 0x0027, 0xFFEA, 0x0007, 0x0024, 0x001F, 0xFFF8, 0x002F,
    0xFFFE, 0xFFFF, 0x0018, 0x000E, 0xFFFB, 0x0005, 0x000A, 0x0003,
    0x000D, 0x0015, 0x0024, 0xFFF1, 0x001C, 0x000C, 0xFFF2, 0xFFFF,
    0xFFFA, 0x0015, 0xFFFA, 0x0003, 0xFFEC, 0xFFD2, 0x0006, 0x0000,
    0x000C, 0x0014, 0xFFF8, 0xFFFF, 0xFFF7, 0x000B, 0xFFE5, 0xFFF3,
    0xFFFA, 0x0002, 0x001B, 0xFFE3, 0x0018, 0x0004, 0x000A, 0xFFDE,
    0xFFFC, 0x0014, 0xFFF8, 0xFFE9, 0x000F, 0xFFFC, 0x0028, 0xFFE1,
    0x000D, 0x0003, 0xFFD7, 0xFFFD, 0xFFF2, 0x0003, 0x0002, 0xFFEB,
    0xFFDB, 0xFFF6, 0xFFF2, 0x0009, 0xFFE4, 0x0005, 0xFFFE, 0x001D,
    0x000A, 0x0005, 0xFFF5, 0xFFF8, 0xFFE3, 0x0000, 0xFFE8, 0xFFF9,
    0x0022, 0x000D, 0xFFEA, 0xFFFA, 0xFFEA, 0x0006, 0x0014, 0x0019,
    0xFFF2, 0xFFFF, 0xFFFD, 0x0000, 0xFFE6, 0xFFF1, 0xFFF7, 0x001C,
    0xFFF7, 0x0007, 0x0004, 0xFFF2, 0xFFFF, 0xFFFE, 0xFFF6, 0x0012,
    0x0016, 0x0005, 0xFFF3, 0x0009, 0xFFF8, 0xFFEA, 0x0003, 0xFFF3,
    0x0005, 0xFFF1, 0x0020, 0xFFF1, 0xFFF0, 0xFFFE, 0x0007, 0xFFFC,
    0x0010, 0xFFF3, 0x000C, 0xFFF9, 0xFFF7, 0x0022, 0xFFFA, 0x001B,
    0xFFF8, 0x0003, 0x0006, 0x0015, 0xFFED, 0xFFFF, 0x0010, 0xFFE3,
    0x000D, 0xFFEB, 0x0002, 0xFFEF, 0x0003, 0x0010, 0x001A, 0x0000,
    0x001D, 0xFFF9, 0xFFFB, 0x0016, 0x000A, 0xFFFC, 0x0002, 0xFFF3,
    0x0001, 0x0006, 0x000E, 0x0006, 0xFFE6, 0x0006, 0xFFFE, 0x0004,
    0xFFF9, 0x0004, 0xFFE6, 0xFFEE, 0x0008, 0xFFF4, 0x0007, 0xFFFD,
    0x001B, 0xFFF5, 0x0002, 0x0001, 0x000A, 0xFFE6, 0x0015, 0xFFFB,
    0xFFF7, 0x0003, 0xFFFC, 0x0013, 0xFFFD, 0xFFF3, 0x0015, 0xFFF2,
    0xFFFA, 0x0014, 0xFFF8, 0x0013, 0x0007, 0xFFFA, 0x0011, 0xFFE8,
    0x0013, 0x0007, 0xFFF7, 0xFFFB, 0x000D, 0xFFFF, 0xFFEA, 0xFFED,
    0xFFFB, 0x0022, 0x000E, 0xFFEF, 0x0002, 0xFFFA, 0xFFF3, 0xFFEF,
    0xFFFA, 0x0004, 0xFFF8, 0xFFFB, 0x0014, 0xFFF8, 0xFFFC, 0x000C,
    0x0007, 0xFFFA, 0xFFFE, 0xFFEB, 0xFFF8, 0x0001, 0x0006, 0x001D,
    0x0013, 0xFFF3, 0xFFF3, 0xFFF7, 0xFFFD, 0x000C, 0xFFFA, 0x0017,
    0xFFDF, 0x0007, 0x001E, 0xFFFF, 0xFFF5, 0xFFFF, 0xFFF9, 0xFFFB,
    0xFFFF, 0xFFFB, 0xFFE3, 0xFFFD, 0x0023, 0xFFF3, 0xFFE4, 0x0015,
    0x0008, 0xFFFC, 0x0003, 0xFFFB, 0xFFF4, 0xFFF5, 0xFFD4, 0x0002,
    0x0009, 0xFFFC, 0xFFF4, 0xFFE1, 0x000F, 0x000F, 0xFFF3, 0x0007,
    0x0004, 0x0002, 0xFFFC, 0xFFFA, 0xFFF9, 0xFFED, 0xFFFE, 0x0006,
    0xFFFC, 0x0001, 0xFFEA, 0xFFDD, 0x0007, 0x000A, 0xFFF8, 0x000D,
    0x0001, 0xFFEF, 0xFFEF, 0xFFDA, 0xFFFC, 0xFFE8, 0x000E, 0xFFE3,
    0xFFF5, 0x0003, 0xFFFF, 0x001A, 0x001B, 0x0002, 0x0005, 0x000E,
    0xFFFA, 0x0010, 0xFFF6, 0xFFF7, 0xFFEF, 0x0008, 0xFFF2, 0x0001,
    0x0004, 0xFFFE, 0x0012, 0x0002, 0x000E, 0x0001, 0x0003, 0xFFFE,
    0x0025, 0x0005, 0x0011, 0x0002, 0x0015, 0x000A, 0x001E, 0xFFFB,
    0x0001, 0x0005, 0x0011, 0xFFE4, 0xFFFD, 0xFFEB, 0xFFE2, 0x000B,
    0x0001, 0xFFF6, 0xFFE9, 0x0003, 0x0006, 0x0004, 0x000D, 0x000C,
    0x0022, 0x0026, 0x0024, 0x0018, 0xFFFD, 0xFFF0, 0x0009, 0x000D,
    0xFFFF, 0x001D, 0xFFED, 0x0013, 0xFFF0, 0xFFF7, 0x0002, 0x0004,
    0xFFE6, 0x0007, 0x000B, 0x0019, 0xFFE0, 0xFFFB, 0xFFF6, 0x0004,
    0xFFF8, 0x001A, 0xFFFB, 0xFFF6, 0x0008, 0xFFF8, 0xFFFE, 0x0013,
    0xFFF4, 0x0011, 0xFFDE, 0x000B, 0xFFF7, 0x0014, 0xFFE3, 0x0000,
    0xFFE9, 0x0002, 0x0013, 0x0010, 0xFFF4, 0x002E, 0xFFFB, 0x000A,
    0x0019, 0x0001, 0x0005, 0xFFE9, 0xFFF0, 0xFFF1, 0xFFFB, 0xFFF6,
    0x0002, 0xFFE5, 0xFFCC, 0xFFF1, 0xFFEE, 0xFFF3, 0x000C, 0x000B,
    0xFFEC, 0x0007, 0xFFF8, 0xFFDF, 0xFFF5, 0xFFF2, 0xFFFB, 0xFFE6,
    0x0007, 0x0008, 0x000C, 0xFFE1, 0xFFEB, 0x001B, 0x0024, 0xFFDC,
    0x0003, 0x0008, 0x000B, 0x0017, 0xFFEF, 0x000E, 0x0014, 0x001F,
    0x0002, 0xFFED, 0xFFEE, 0xFFFD, 0x0008, 0x0014, 0xFFF7, 0x0019,
    0x001C, 0x0007, 0xFFFF, 0xFFF0, 0xFFFF, 0xFFEA, 0xFFE0, 0xFFFA,
    0xFFFF, 0x0004, 0xFFFD, 0x000A, 0x001F, 0x0009, 0x000F, 0xFFEE,
    0x001D, 0xFFFE, 0x0005, 0x0003, 0xFFF6, 0x0015, 0xFFF3, 0xFFF4,
    0x001D, 0xFFFF, 0x0008, 0x001E, 0x000B, 0x0006, 0x0001, 0x0005,
    0x0016, 0xFFFC, 0xFFF1, 0xFFE8, 0x0017, 0x000B, 0x0016, 0x000D,
    0xFFFF, 0x0022, 0x0003, 0x0000, 0x0004, 0xFFFD, 0xFFF3, 0x0016,
    0xFFE4, 0x000F, 0xFFEB, 0xFFDE, 0x0012, 0x0023, 0xFFEB, 0xFFF5,
    0xFFE7, 0xFFED, 0xFFFB, 0xFFE9, 0x001C, 0xFFEC, 0xFFED, 0xFFD5,
    0x0006, 0x000A, 0xFFFA, 0xFFE5, 0xFFFA, 0xFFFA, 0xFFFF, 0x0003,
    0xFFFF, 0xFFF7, 0xFFFD, 0xFFEC, 0x0006, 0x0003, 0x0009, 0xFFFD,
    0x0026, 0xFFEC, 0xFFE0, 0xFFE4, 0xFFE5, 0x0023, 0xFFFB, 0x0015,
    0xFFD7, 0x000A, 0x0007, 0x0018, 0xFFFC, 0x0013, 0xFFEE, 0x0011,
    0xFFF7, 0xFFF4, 0x001C, 0x000C, 0x0013, 0x001A, 0xFFF3, 0x0003,
    0x000D, 0x0010, 0x0005, 0xFFEE, 0x0017, 0xFFFE, 0xFFF9, 0x0003,
    0x0011, 0x0001, 0x000E, 0x0009, 0x000F, 0x0009, 0xFFF8, 0xFFEF,
    0x0007, 0xFFEC, 0x0005, 0xFFEE, 0xFFD3, 0x000B, 0xFFFC, 0x0006,
    0xFFFB, 0x000B, 0x0018, 0xFFF0, 0xFFF2, 0x0014, 0xFFD8, 0x0004,
    0x000D, 0x002E, 0xFFEA, 0xFFE2, 0xFFF5, 0xFFF6, 0x0011, 0x000E,
    0xFFE8, 0x0000, 0xFFE8, 0x0012, 0x0018, 0xFFF8, 0x0010, 0x0003,
    0xFFFF, 0xFFFB, 0x000F, 0x000C, 0x000D, 0x000E, 0xFFF4, 0x000E,
    0xFFFF, 0x0003, 0xFFF7, 0x0015, 0xFFFE, 0xFFF8, 0xFFEB, 0xFFF7,
    0x0010, 0x000C, 0xFFF8, 0xFFFF, 0x0004, 0xFFE8, 0x0016, 0xFFF0,
    0xFFEB, 0x0010, 0xFFF9, 0x000F, 0x0001, 0x0006, 0x0003, 0xFFC8,
    0x0000, 0x0015, 0x0006, 0xFFF7, 0x0002, 0xFFEA, 0x0008, 0x000A,
    0xFFFA, 0xFFFD, 0x0009, 0x000C, 0xFFE1, 0x0001, 0xFFF7, 0x0001,
    0xFFDC, 0x000E, 0x001A, 0xFFF7, 0x0010, 0x000C, 0xFFDD, 0x0007,
    0x0009, 0x0005, 0xFFF8, 0x0011, 0x000E, 0x0007, 0xFFE6, 0x001C,
    0xFFE2, 0x001B, 0x0001, 0x0011, 0x0013, 0x0022, 0x0008, 0xFFED,
    0x0009, 0x0009, 0xFFFD, 0xFFFA, 0x0006, 0x001E, 0xFFFE, 0x0007,
    0x0000, 0xFFFA, 0x0021, 0x0019, 0x0005, 0xFFE9, 0xFFF2, 0xFFFE,
    0x0000, 0xFFEF, 0x0017, 0x0010, 0x003C, 0x000A, 0xFFDD, 0x0000,
    0x000F, 0x0019, 0xFFF9, 0x0001, 0x0012, 0x0013, 0x0016, 0x0001,
    0xFFDF, 0xFFE0, 0xFFDD, 0x000E, 0x001D, 0x0002, 0x000C, 0xFFF6,
    0x0010, 0xFFEF, 0x0013, 0xFFFE, 0x001C, 0xFFF2, 0x0007, 0xFFF4,
    0x000F, 0x0008, 0x001D, 0xFFF7, 0x0028, 0xFFF2, 0x0017, 0x0002,
    0xFFE4, 0x0006, 0x0008, 0xFFFF, 0xFFE7, 0x0000, 0xFFFE, 0xFFF5,
    0x0006, 0xFFFF, 0x001B, 0x000C, 0x000B, 0xFFFF, 0x000A, 0x000A,
    0xFFF1, 0xFFEA, 0x000E, 0x0012, 0xFFEE, 0x0012, 0xFFEF, 0xFFFE,
    0xFFE7, 0x0006, 0x0004, 0x0004, 0x0005, 0x0015, 0xFFF8, 0xFFFF,
    0xFFE2, 0xFFF7, 0xFFEA, 0xFFF3, 0x001D, 0xFFFB, 0x0011, 0xFFEC,
    0x0004, 0x000D, 0xFFFB, 0xFFEF, 0x001A, 0x0013, 0xFFFF, 0xFFF3,
    0x0008, 0x000B, 0xFFFB, 0x0000, 0x0009, 0xFFFC, 0xFFEE, 0x000A,
    0xFFF0, 0xFFF1, 0x0014, 0x0002, 0x0001, 0xFFD4, 0xFFFE, 0x002E,
    0x0011, 0x0004, 0x000D, 0x001B, 0x001A, 0x0008, 0x0001, 0xFFFF,
    0x0002, 0x0000, 0xFFFE, 0x001B, 0x0011, 0x0017, 0x000F, 0x0004,
    0xFFFE, 0x0009, 0xFFF8, 0xFFE9, 0x0001, 0x0011, 0x000D, 0x0009,
    0xFFFF, 0xFFF9, 0xFFF8, 0x0016, 0xFFDE, 0x000F, 0xFFF2, 0xFFF2,
    0xFFEA, 0xFFF4, 0xFFF8, 0xFFE3, 0xFFFD, 0xFFF5, 0xFFEC, 0xFFE9,
    0x000F, 0xFFFC, 0xFFF4, 0xFFEE, 0xFFE2, 0x0001, 0x0013, 0x0000,
    0x0014, 0xFFF8, 0x0004, 0xFFFB, 0xFFF5, 0xFFEA, 0x0013, 0xFFFF,
    0xFFFF, 0xFFE5, 0x0006, 0x0000, 0x000A, 0xFFF1, 0x0020, 0xFFE5,
    0x000F, 0xFFEF, 0xFFE6, 0xFFF5, 0xFFF8, 0xFFF7, 0x0019, 0xFFEE,
    0x0014, 0xFFF5, 0xFFEA, 0x0004, 0xFFFD, 0x0007, 0xFFF1, 0x0026,
    0xFFFD, 0xFFF8, 0x002B, 0x0006, 0x0016, 0x0024, 0x0014, 0xFFE1,
    0xFFEF, 0x0000, 0xFFE5, 0xFFDF, 0xFFF5, 0x0028, 0x0027, 0x000B,
    0xFFE4, 0x0005, 0xFFDC, 0xFFEF, 0xFFE5, 0xFFFB, 0x000A, 0xFFF8,
    0x0003, 0x001F, 0xFFFB, 0x0004, 0x0002, 0xFFF3, 0x001E, 0x000C,
    0x0003, 0xFFF0, 0xFFFF, 0xFFF7, 0xFFE7, 0x000A, 0x0000, 0xFFFE,
    0xFFEF, 0xFFE8, 0x001A, 0xFFF3, 0x000D, 0x001D, 0xFFF9, 0xFFF2,
    0x000D, 0x0002, 0xFFF4, 0x0022, 0xFFE8, 0x0001, 0xFFF9, 0xFFFD,
    0x0009, 0x0000, 0x0001, 0x000B, 0x0009, 0xFFF8, 0x0005, 0xFFEC,
    0x000A, 0xFFF7, 0xFFF6, 0xFFFB, 0xFFED, 0x0003, 0x001B, 0xFFFA,
    0xFFF2, 0xFFE8, 0xFFEC, 0xFFFC, 0xFFFB, 0x0024, 0xFFEC, 0xFFE3,
    0xFFFE, 0x001B, 0x001A, 0xFFE3, 0xFFEE, 0xFFF6, 0x0010, 0x000E,
    0xFFF9, 0xFFEF, 0x0010, 0x000F, 0x000C, 0x0015, 0xFFEC, 0x000C,
    0xFFEC, 0xFFFD, 0xFFE6, 0x0024, 0xFFF3, 0xFFFD, 0x000B, 0x0002,
    0x0004, 0xFFF5, 0x0014, 0x0006, 0x000B, 0x0020, 0xFFEC, 0xFFFD,
    0x0015, 0xFFEF, 0x0023, 0x000F, 0xFFF7, 0xFFEC, 0x000E, 0x0000,
    0xFFF0, 0x0011, 0xFFF2, 0x0007, 0x0020, 0xFFFE, 0x0002, 0x0020,
    0x0013, 0x0010, 0xFFF8, 0xFFFD, 0x001B, 0x0003, 0x0001, 0xFFDE,
    0x000F, 0xFFF4, 0x0006, 0x0011, 0x000D, 0x000B, 0x000B, 0x0021,
    0x0004, 0xFFF5, 0x0011, 0x0014, 0xFFFE, 0x0018, 0x002D, 0x0007,
    0xFFE5, 0xFFE5, 0xFFFD, 0xFFE7, 0x0005, 0x0012, 0x0014, 0xFFF9,
    0x0000, 0xFFE7, 0xFFF3, 0xFFF9, 0xFFC5, 0xFFF5, 0x0018, 0xFFEB,
    0x0020, 0xFFFA, 0x0003, 0x0004, 0xFFF1, 0x000A, 0xFFFD, 0xFFDB,
    0x0017, 0xFFF4, 0xFFF6, 0x0007, 0x0011, 0x0003, 0xFFF6, 0xFFFE,
    0x0009, 0x0012, 0x0022, 0x0011, 0xFFEE, 0x0010, 0x0014, 0xFFE6,
    0x000A, 0xFFED, 0x0008, 0xFFF9, 0x0019, 0x0028, 0x0005, 0xFFFF,
    0x0009, 0x000D, 0xFFF7, 0x000A, 0xFFE5, 0x0007, 0xFFF3, 0x0002,
    0xFFFA, 0x0015, 0x000C, 0xFFF7, 0x0004, 0xFFF2, 0x000B, 0xFFE4,
    0xFFF7, 0xFFFB, 0x0003, 0xFFF7, 0xFFE5, 0xFFE6, 0x000C, 0xFFED,
    0x000A, 0xFFE5, 0x000E, 0xFFFE, 0xFFFC, 0x0003, 0x0024, 0x0013,
    0xFFE5, 0xFFE8, 0x0010, 0xFFF9, 0xFFFE, 0x0020, 0xFFF5, 0xFFFC,
    0x001B, 0x000A, 0x0004, 0xFFFB, 0x001A, 0xFFF5, 0x001B, 0xFFEF,
    0xFFE1, 0x000C, 0xFFF5, 0xFFD9, 0xFFF5, 0x0015, 0xFFFF, 0x0013,
    0x0003, 0x0003, 0x0011, 0xFFEB, 0x0012, 0x000E, 0x0028, 0xFFF4,
    0xFFFD, 0xFFDE, 0x0006, 0xFFF7, 0x0001, 0xFFF7, 0xFFF1, 0xFFFF,
    0x0014, 0xFFF1, 0x000E, 0x0008, 0x0004, 0x001A, 0xFFFB, 0x0007,
    0x0011, 0xFFF9, 0x001D, 0xFFFF, 0x0004, 0xFFFF, 0x0001, 0x0020,
    0x0000, 0xFFF2, 0xFFFE, 0x0008, 0xFFDA, 0x0016, 0x000A, 0xFFE9,
    0x0016, 0xFFFF, 0x0012, 0x0003, 0x0011, 0x0000, 0x000C, 0xFFFC,
    0x0015, 0xFFEE, 0x0000, 0xFFF8, 0x001A, 0x0028, 0xFFFE, 0x001B,
    0x000A, 0x0000, 0xFFE0, 0x0014, 0x0018, 0x0000, 0xFFFD, 0xFFFB,
    0x0011, 0xFFF1, 0x0000, 0xFFE9, 0xFFED, 0xFFEA, 0xFFF5, 0xFFF8,
    0x0002, 0xFFE7, 0x000A, 0xFFEE, 0xFFF7, 0xFFF6, 0xFFF4, 0xFFDD,
    0x0023, 0xFFFA, 0x0020, 0x0020, 0xFFEC, 0xFFF0, 0xFFFB, 0xFFFC,
    0x000D, 0x000D, 0x0012, 0xFFF4, 0xFFF3, 0x000B, 0xFFFD, 0x0022,
    0x000F, 0x000A, 0xFFE7, 0xFFF4, 0x000E, 0xFFF0, 0x0018, 0x0023,
    0xFFEF, 0xFFEE, 0xFFF6, 0xFFFD, 0xFFEF, 0x0014, 0x0026, 0xFFFB,
    0x000A, 0x0004, 0xFFFC, 0x0012, 0x0008, 0x003F, 0xFFF6, 0x000C,
    0x0008, 0xFFF4, 0xFFEF, 0xFFFB, 0xFFF2, 0xFFFA, 0x001B, 0x0001,
    0xFFF6, 0x0017, 0x0003, 0x0024, 0xFFE7, 0x001B, 0xFFEF, 0x0007,
    0x001C, 0xFFF9, 0xFFFC, 0xFFD1, 0xFFEB, 0xFFFC, 0xFFE2, 0x0011,
    0xFFEB, 0x0003, 0xFFE2, 0xFFFE, 0xFFF9, 0xFFE8, 0xFFFA, 0x0019,
    0x000E, 0xFFFA, 0xFFF4, 0x000E, 0xFFF1, 0xFFFF, 0x0002, 0xFFE5,
    0x0005, 0x000F, 0xFFF0, 0xFFFD, 0x000C, 0xFFF5, 0xFFEF, 0x0002,
    0xFFF2, 0xFFF8, 0x0001, 0x0026, 0xFFEA, 0xFFF7, 0xFFEE, 0xFFFF,
    0x001B, 0x0004, 0xFFE0, 0x0000, 0xFFF1, 0x0006, 0xFFEC, 0xFFF6,
    0x0019, 0xFFFC, 0x0008, 0xFFF2, 0x0025, 0xFFF0, 0x000B, 0x0018,
    0x0025, 0xFFF2, 0xFFE3, 0x0019, 0x000E, 0xFFF9, 0x000A, 0x000F,
    0x0006, 0x001A, 0x0010, 0xFFF3, 0xFFEE, 0x0015, 0x0009, 0xFFF5,
    0x0008, 0x0001, 0xFFFF, 0xFFFC, 0xFFFE, 0x000A, 0x001C, 0xFFF7,
    0xFFEF, 0x0013, 0xFFDC, 0xFFF7, 0x0030, 0xFFFE, 0xFFE4, 0x002D,
    0xFFDA, 0xFFFA, 0xFFE0, 0xFFFC, 0xFFEF, 0xFFFC, 0x000E, 0x0002,
    0xFFF6, 0xFFE7, 0x000C, 0x001B, 0xFFF0, 0x0002, 0x0007, 0xFFF4,
    0x0005, 0xFFDE, 0x0018, 0xFFF7, 0xFFEE, 0xFFF9, 0xFFE9, 0xFFF1,
    0xFFE8, 0x0002, 0x0011, 0xFFF8, 0x000B, 0x000D, 0xFFEC, 0xFFF9,
    0xFFF3, 0xFFFD, 0x0014, 0x0015, 0x0001, 0xFFCA, 0xFFFD, 0x0016,
    0x000A, 0x0018, 0x0018, 0xFFE8, 0xFFE5, 0x0009, 0x0010, 0x001E,
    0x000B, 0x002D, 0x0000, 0x0029, 0xFFEF, 0x0007, 0x0024, 0xFFF5,
    0x000F, 0x0004, 0x0000, 0x0001, 0x000C, 0x0021, 0xFFF2, 0xFFE5,
    0xFFF7, 0x0010, 0x0001, 0x0007, 0x001D, 0x000A, 0xFFFF, 0xFFE7,
    0x0008, 0xFFF8, 0x0016, 0xFFF5, 0x0001, 0x001B, 0x0000, 0x000F,
    0x0005, 0xFFF9, 0xFFFA, 0xFFEF, 0xFFF7, 0x0014, 0xFFF8, 0xFFCA,
    0x0009, 0x0017, 0xFFF3, 0x0003, 0xFFF5, 0x0002, 0x000E, 0xFFF2,
    0x0010, 0x000C, 0x0007, 0x0002, 0xFFF2, 0x0003, 0xFFF0, 0xFFF5,
    0xFFFF, 0xFFF8, 0xFFF3, 0xFFFD, 0x0006, 0x0010, 0xFFF1, 0x000C,
    0x001C, 0xFFEF, 0xFFF4, 0xFFEF, 0x0009, 0x0008, 0x000C, 0xFFFF,
    0x0005, 0xFFF7, 0x001D, 0xFFF0, 0xFFF0, 0x0014, 0x0022, 0x0025,
    0xFFF0, 0xFFF2, 0xFFED, 0xFFFE, 0xFFFD, 0x0000, 0x0001, 0xFFF7,
    0xFFEC, 0x0005, 0x0009, 0xFFF3, 0x0001, 0xFFF9, 0xFFF6, 0xFFDE,
    0x0005, 0x000C, 0x0001, 0x0018, 0xFFEF, 0x0017, 0xFFFE, 0x0003,
    0xFFFC, 0xFFF6, 0xFFFF, 0x000D, 0x002F, 0xFFFA, 0x0027, 0x001F,
    0x0007, 0xFFF4, 0x0011, 0xFFF7, 0xFFEF, 0x0016, 0x0003, 0xFFF7,
    0x0011, 0x0011, 0x0007, 0xFFC6, 0x001E, 0xFFF8, 0xFFFB, 0x0007,
    0xFFF2, 0x000F, 0x0007, 0xFFFB, 0x0015, 0xFFF6, 0xFFF9, 0xFFE9,
    0xFFF0, 0x0010, 0xFFF3, 0xFFFB, 0x0015, 0xFFE6, 0xFFFC, 0xFFF3,
    0x0009, 0xFFE8, 0x0009, 0xFFD7, 0x0004, 0xFFD4, 0xFFFD, 0xFFFD,
    0x0009, 0x0004, 0x0005, 0xFFEE, 0x000B, 0x0010, 0x0026, 0xFFF1,
    0xFFDC, 0xFFFF, 0x0006, 0xFFED, 0x000F, 0xFFFB, 0xFFF6, 0x000D,
    0xFFFC, 0xFFFE, 0x000C, 0x000A, 0x000A, 0x002B, 0x0002, 0xFFEA,
    0x0006, 0xFFFC, 0x0002, 0x0005, 0x0003, 0x0001, 0xFFFF, 0xFFFF,
    0x0004, 0xFFF2, 0x0008, 0x002B, 0xFFD8, 0xFFF5, 0xFFF3, 0xFFF3,
    0x0007, 0x0020, 0x0014, 0xFFEF, 0xFFF2, 0xFFFC, 0x002C, 0xFFFB,
    0xFFD9, 0xFFF6, 0x000C, 0xFFE9, 0x0023, 0xFFF4, 0xFFFE, 0xFFFA,
    0xFFE1, 0x0014, 0xFFF4, 0x002A, 0x0012, 0x0007, 0xFFF2, 0x0004,
    0x0000, 0xFFE5, 0x002C, 0xFFF5, 0x0018, 0x0019, 0xFFE5, 0x0015,
    0xFFEF, 0x000B, 0x0012, 0x0014, 0xFFEF, 0x001D, 0xFFFF, 0xFFF6,
    0xFFFE, 0xFFF3, 0xFFFD, 0xFFEF, 0xFFFF, 0xFFFC, 0x0004, 0xFFE6,
    0x000E, 0xFFF9, 0x0000, 0xFFFC, 0x000F, 0xFFDD, 0x0010, 0x0014,
    0x0015, 0xFFEC, 0xFFF8, 0x0007, 0xFFF6, 0xFFF1, 0xFFF5, 0xFFE6,
    0xFFDE, 0xFFE0, 0xFFEA, 0xFFFC, 0x0004, 0x0000, 0xFFE7, 0xFFE2,
    0x0011, 0xFFEB, 0xFFE6, 0x0027, 0x0028, 0x0003, 0xFFF6, 0x0007,
    0x0016, 0xFFF6, 0x0006, 0x000C, 0xFFF4, 0x001D, 0x0005, 0xFFDE,
    0xFFE8, 0x0024, 0xFFFA, 0xFFF9, 0xFFFB, 0xFFF3, 0xFFEA, 0xFFF9,
    0x001B, 0xFFE2, 0xFFE2, 0x0004, 0x0013, 0x0017, 0xFFEF, 0x0010,
    0xFFFB, 0x000F, 0xFFDD, 0xFFFB, 0x0000, 0xFFF2, 0x001B, 0xFFFB,
    0x0016, 0x0012, 0x0010, 0x0015, 0x0012, 0x0000, 0x001F, 0xFFF7,
    0x0000, 0x0011, 0xFFF2, 0xFFEB, 0xFFF6, 0xFFF6, 0xFFFB, 0xFFFC,
    0xFFDF, 0x000A, 0x0003, 0x0018, 0xFFE9, 0x000C, 0x000A, 0xFFE7,
    0xFFF7, 0xFFF4, 0x000C, 0x0007, 0xFFEF, 0x0015, 0x0012, 0x000E,
    0xFFF9, 0xFFEF, 0xFFF3, 0x0014, 0xFFF9, 0xFFF6, 0xFFED, 0x0006,
    0xFFEE, 0xFFF9, 0xFFFF, 0x0003, 0xFFF7, 0xFFF4, 0xFFE6, 0x0007,
    0x0006, 0xFFF4, 0x0005, 0x0014, 0xFFED, 0xFFF8, 0xFFE6, 0xFFF5,
    0x000A, 0xFFF1, 0xFFEC, 0x0001, 0xFFFA, 0x0005, 0xFFF6, 0xFFF3,
    0x0010, 0xFFF1, 0x0002, 0xFFF5, 0xFFF3, 0x000F, 0xFFED, 0x0009,
    0xFFE8, 0xFFFD, 0xFFE9, 0x0003, 0xFFF4, 0xFFE1, 0xFFDE, 0x0011,
    0xFFEC, 0x0003, 0x0014, 0x0014, 0x0003, 0x0015, 0xFFFD, 0xFFFE,
    0xFFDF, 0xFFDD, 0x0011, 0x000F, 0x0007, 0x0012, 0xFFE8, 0x0006,
    0xFFF5, 0xFFFB, 0x0000, 0xFFEC, 0xFFF5, 0xFFE5, 0xFFFF, 0x0005,
    0x0004, 0x001F, 0x0011, 0x0022, 0x0010, 0x0001, 0xFFFC, 0xFFFE,
    0xFFEA, 0x000A, 0xFFE6, 0x0011, 0xFFF2, 0xFFEE, 0x0000, 0xFFEC,
    0x0006, 0x002D, 0xFFF4, 0xFFF0, 0xFFFD, 0xFFE1, 0x0003, 0xFFFD,
    0x000D, 0xFFF5, 0xFFEA, 0x0006, 0x0000, 0x0029, 0x0000, 0x0008,
    0xFFF4, 0xFFF2, 0xFFFE, 0x000E, 0xFFED, 0xFFE9, 0xFFF3, 0xFFF1,
    0x0006, 0xFFE9, 0x0001, 0xFFFF, 0x0004, 0x0009, 0xFFFF, 0x0009,
    0x0009, 0x0025, 0xFFF9, 0xFFF3, 0x000A, 0xFFF1, 0x000D, 0x0014,
    0x0017, 0xFFFE, 0x0008, 0x000D, 0x001F, 0xFFF5, 0x0005, 0x000B,
    0x0001, 0x0003, 0xFFFC, 0x0009, 0x0003, 0xFFE4, 0xFFEB, 0x000C,
    0x0024, 0x0002, 0x0005, 0x000D, 0x0019, 0x0012, 0x0018, 0xFFE2,
    0x0018, 0x001D, 0xFFF9, 0xFFFD, 0x0009, 0x0012, 0xFFE4, 0xFFFC,
    0xFFFE, 0xFFF7, 0xFFEB, 0xFFFA, 0xFFFA, 0xFFED, 0x0000, 0xFFF4,
    0xFFFE, 0x0000, 0x0000, 0x000C, 0xFFFA, 0x0013, 0xFFEB, 0x0006,
    0xFFFE, 0x0009, 0xFFE4, 0x0004, 0x0009, 0xFFEE, 0xFFF9, 0x0003,
    0x0018, 0xFFE3, 0x0018, 0x001E, 0x0019, 0xFFEE, 0x0005, 0xFFF3,
    0x0024, 0xFFFE, 0xFFEB, 0xFFF4, 0x0003, 0x001C, 0xFFFC, 0xFFF7,
    0x0001, 0xFFFD, 0x0005, 0xFFF5, 0x001F, 0x000B, 0x0008, 0xFFF3,
    0x0017, 0x0002, 0x000D, 0xFFEC, 0x000A, 0x000F, 0xFFF9, 0x000D,
    0x0009, 0xFFDB, 0xFFFF, 0xFFF7, 0x0004, 0xFFF7, 0x0001, 0x0001,
    0x0006, 0x0017, 0xFFF3, 0x000F, 0xFFED, 0x0017, 0xFFFE, 0xFFF2,
    0xFFF4, 0x000E, 0x0000, 0xFFF8, 0x0000, 0xFFD7, 0xFFEA, 0xFFFA,
    0x000D, 0x000B, 0x0003, 0x0003, 0xFFFD, 0x001F, 0xFFF4, 0x0010,
    0x0006, 0xFFD3, 0x0000, 0x0014, 0xFFF2, 0x0012, 0xFFE6, 0xFFEF,
    0xFFEA, 0xFFF6, 0xFFFC, 0x0002, 0x0010, 0xFFFF, 0x0011, 0xFFDE,
    0x0004, 0xFFE1, 0xFFFF, 0xFFFB, 0xFFF5, 0x001B, 0x0000, 0x0014,
    0xFFF5, 0x0005, 0xFFE8, 0xFFFA, 0x0007, 0xFFEE, 0x0011, 0xFFF1,
    0xFFDF, 0x0023, 0xFFFD, 0x0002, 0x0003, 0xFFEB, 0x0014, 0xFFEC,
    0xFFEC, 0xFFFD, 0xFFDE, 0xFFEF, 0xFFF4, 0x001F, 0xFFE9, 0xFFFD,
    0xFFE8, 0x0003, 0xFFED, 0xFFF7, 0xFFF3, 0xFFF1, 0x0002, 0x000B,
    0x0010, 0x000F, 0xFFF6, 0x000D, 0xFFFA, 0xFFFB, 0xFFEC, 0xFFFF,
    0x000A, 0x000F, 0xFFE6, 0x000B, 0xFFED, 0x0008, 0x0005, 0xFFEC,
    0x0006, 0x000C, 0xFFE6, 0xFFF9, 0xFFF7, 0x000C, 0xFFFF, 0xFFFD,
    0xFFEE, 0x0007, 0xFFED, 0xFFFA, 0xFFF9, 0x000A, 0xFFF3, 0xFFEC,
    0xFFF9, 0x0011, 0x0012, 0xFFF2, 0xFFEF, 0xFFEB, 0x000C, 0xFFF9,
    0xFFF7, 0x000C, 0x000A, 0x0019, 0xFFE9, 0xFFF4, 0x0003, 0xFFE8,
    0xFFDF, 0xFFF6, 0xFFFB, 0x0004, 0xFFF6, 0x000A, 0xFFF2, 0x0015,
    0x0000, 0xFFEF, 0x001F, 0x0009, 0x0012, 0x0000, 0x0010, 0xFFEB,
    0x0016, 0xFFEE, 0x001B, 0x0005, 0x0000, 0x000E, 0xFFDD, 0x0005,
    0xFFFB, 0xFFF1, 0xFFEF, 0xFFF0, 0x0013, 0xFFE9, 0xFFE2, 0xFFFC,
    0x001B, 0x001E, 0xFFEA, 0x0007, 0xFFFB, 0x000D, 0xFFFA, 0x0007,
    0xFFE8, 0xFFDC, 0x0005, 0x0022, 0xFFF4, 0xFFE3, 0x0006, 0xFFF4,
    0x0016, 0x000A, 0xFFF6, 0xFFF9, 0x0028, 0xFFFD, 0xFFE6, 0xFFD9,
    0x0011, 0x0015, 0xFFE7, 0x001E, 0x0004, 0x0000, 0xFFEA, 0x0004,
    0xFFDE, 0x0020, 0xFFF5, 0x001A, 0xFFF6, 0x000F, 0xFFF8, 0xFFF9,
    0x0015, 0x0014, 0x0010, 0xFFEC, 0x000F, 0x0023, 0x0000, 0x0004,
    0x000E, 0x0007, 0x0004, 0x001A, 0xFFFF, 0x0004, 0xFFFD, 0x0011,
    0xFFFE, 0x000D, 0xFFFF, 0x000A, 0xFFEF, 0xFFE3, 0x0012, 0xFFEC,
    0xFFEF, 0xFFF5, 0xFFE5, 0xFFEB, 0x0018, 0xFFE7, 0x002C, 0x000B,
    0x0000, 0x001B, 0xFFF2, 0xFFFC, 0x0012, 0xFFF9, 0xFFF4, 0xFFD6,
    0xFFE1, 0xFFEC, 0xFFFE, 0x0006, 0x0023, 0x000C, 0x000C, 0x0017,
    0xFFD9, 0x000A, 0x002C, 0x0005, 0xFFF2, 0x0004, 0x0014, 0x0011,
    0x0007, 0xFFE0, 0xFFF3, 0x000D, 0xFFD8, 0x000B, 0x0008, 0xFFD5,
    0x0004, 0x000E, 0xFFFF, 0x0001, 0x0003, 0xFFFF, 0x0002, 0xFFFB,
    0x0006, 0x0004, 0x0002, 0x0016, 0x000A, 0xFFD5, 0x000C, 0xFFF6,
    0xFFFC, 0x0002, 0xFFF6, 0xFFF3, 0x000F, 0x0005, 0x0006, 0x0013,
    0xFFDC, 0x0001, 0x0026, 0x000F, 0x000B, 0xFFF0, 0x0005, 0x0012,
    0x0009, 0xFFFC, 0xFFFD, 0x0003, 0x0004, 0x002C, 0x0009, 0x0029,
    0x0009, 0x0018, 0xFFFC, 0x000D, 0x0015, 0x001A, 0xFFF3, 0x0005,
    0xFFF0, 0xFFF0, 0xFFF9, 0x0017, 0x0015, 0x000A, 0x0007, 0x0005,
    0xFFF2, 0xFFF1, 0xFFFB, 0xFFF9, 0x001E, 0x0008, 0x0007, 0x003A,
    0x0011, 0xFFEF, 0x0003, 0x0009, 0xFFEF, 0xFFEA, 0x0011, 0x0009,
    0x0007, 0x000C, 0x0027, 0xFFE1, 0x002F, 0x0006, 0xFFFF, 0xFFF3,
    0xFFFC, 0x000A, 0xFFFE, 0xFFFD, 0xFFEF, 0xFFE9, 0x0001, 0xFFE8,
    0x0005, 0xFFF4, 0xFFF6, 0x0022, 0x0001, 0x0007, 0x0009, 0x000D,
    0xFFEC, 0xFFFB, 0x0001, 0x0009, 0xFFFD, 0x0000, 0xFFED, 0x0002,
    0xFFF0, 0x000E, 0x0022, 0xFFDB, 0xFFF0, 0xFFEC, 0x001D, 0x0010,
    0x0005, 0x0009, 0x000C, 0x0001, 0x0009, 0xFFF8, 0xFFF4, 0x0011,
    0x001C, 0x0011, 0xFFF1, 0xFFF4, 0x0006, 0xFFF0, 0xFFF3, 0x0003,
    0xFFFF, 0x0008, 0xFFF0, 0x000B, 0xFFF2, 0xFFFD, 0x0007, 0xFFFE,
    0x0010, 0xFFF4, 0x000E, 0x000E, 0xFFF5, 0xFFFE, 0xFFF3, 0xFFFD,
    0x0009, 0xFFE9, 0xFFF8, 0x0036, 0xFFF7, 0xFFEC, 0xFFFA, 0x0011,
    0x0005, 0x0007, 0x0000, 0xFFF1, 0x0001, 0xFFE5, 0x0016, 0x000B,
    0x0008, 0x0008, 0xFFFF, 0x0019, 0x001D, 0xFFF6, 0x0001, 0xFFF9,
    0xFFF7, 0xFFF0, 0xFFF2, 0x001B, 0x000C, 0xFFDF, 0x0000, 0xFFFF,
    0x000F, 0xFFFC, 0x0024, 0x000B, 0xFFEF, 0xFFF9, 0x0000, 0xFFD7,
    0x000B, 0xFFD3, 0x0010, 0xFFE2, 0xFFE5, 0xFFF7, 0x0018, 0x0018,
    0x000A, 0xFFE8, 0xFFFD, 0xFFEA, 0x0001, 0x0036, 0x0014, 0xFFEB,
    0xFFF3, 0x0003, 0xFFEC, 0x0007, 0x000B, 0xFFF3, 0x0011, 0x0008,
    0xFFE8, 0xFFFE, 0xFFE9, 0x000F, 0xFFEE, 0x0007, 0x0018, 0x0009,
    0x0005, 0x0022, 0x0007, 0x000C, 0xFFF0, 0xFFFE, 0x000C, 0xFFE5,
    0xFFF6, 0x0019, 0x000E, 0xFFFE, 0xFFEF, 0x0004, 0xFFE0, 0x0004,
    0xFFDA, 0x0006, 0xFFE4, 0xFFD3, 0x0030, 0x0002, 0xFFDC, 0x0009,
    0xFFEF, 0xFFED, 0x001C, 0x0009, 0xFFFE, 0xFFF6, 0xFFFF, 0x0004,
    0x0008, 0xFFFF, 0x0009, 0x000B, 0xFFEE, 0xFFEB, 0x0010, 0x000D,
    0x0006, 0xFFE6, 0x000A, 0xFFF1, 0x000E, 0x0007, 0xFFE3, 0xFFE7,
    0x0025, 0x000E, 0x000B, 0xFFE8, 0x0025, 0x0010, 0x0008, 0x000E,
    0x0019, 0x0004, 0xFFEC, 0x000A, 0xFFF1, 0xFFFA, 0xFFE0, 0x0000,
    0x001B, 0xFFFC, 0xFFEE, 0x0001, 0xFFEA, 0x0009, 0x0001, 0xFFDA,
    0xFFF2, 0x0008, 0xFFEF, 0xFFFE, 0x000C, 0x000B, 0xFFF0, 0x0003,
    0x0005, 0xFFF1, 0x0002, 0x001B, 0xFFF1, 0x0001, 0xFFF4, 0xFFF2,
    0x000E, 0x0006, 0xFFFA, 0xFFE7, 0xFFF9, 0x0018, 0xFFE2, 0x0002,
    0xFFEB, 0xFFFD, 0xFFE2, 0xFFEF, 0xFFEB, 0x0004, 0xFFFC, 0x002F,
    0x001C, 0x0007, 0xFFEF, 0xFFF9, 0xFFE7, 0xFFE5, 0x0003, 0xFFDC,
    0xFFF6, 0xFFE9, 0x001B, 0xFFFF, 0xFFF2, 0x0006, 0xFFEF, 0x0005,
    0x0008, 0x000C, 0xFFF6, 0xFFF4, 0x0008, 0xFFC1, 0xFFFC, 0xFFEE,
    0x000A, 0xFFFC, 0x0026, 0x0005, 0xFFEF, 0xFFEC, 0xFFF6, 0x0003,
    0xFFEF, 0x0012, 0x0018, 0xFFDD, 0x000E, 0x0010, 0xFFE7, 0x000C,
    0x000F, 0xFFF6, 0xFFFD, 0xFFDE, 0xFFF3, 0xFFF5, 0x0012, 0x000C,
    0x000D, 0xFFF3, 0xFFFB, 0x0004, 0xFFEC, 0x0010, 0x0020, 0xFFE0,
    0x0023, 0x0006, 0xFFF4, 0x0023, 0xFFF7, 0x000A, 0x000A, 0x0012,
    0x0002, 0x0019, 0xFFF5, 0x0008, 0xFFED, 0x0016, 0x0000, 0x0017,
    0x0011, 0x000F, 0xFFFD, 0x0005, 0x0018, 0x0000, 0xFFE0, 0xFFEC,
    0x000A, 0x0000, 0xFFFE, 0xFFE5, 0x001A, 0xFFD8, 0x0000, 0x0008,
    0x0015, 0x0012, 0x000C, 0x0004, 0x0011, 0x0000, 0x0012, 0xFFFD,
    0x0016, 0x0001, 0x000A, 0x0017, 0xFFDA, 0xFFEA, 0xFFFE, 0xFFF8,
    0x0000, 0x000E, 0x0001, 0xFFE0, 0x0004, 0x0001, 0x001D, 0x0001,
    0x0011, 0x0007, 0xFFFB, 0xFFF9, 0x0004, 0xFFE6, 0x000E, 0xFFF8,
    0x0014, 0x000F, 0xFFF1, 0x0001, 0x0001, 0x0009, 0x0006, 0x0009,
    0xFFFD, 0x0022, 0x0028, 0x000C, 0x0012, 0xFFF2, 0x0011, 0x0015,
    0x0003, 0xFFFD, 0xFFFF, 0xFFED, 0xFFF5, 0xFFEB, 0xFFF5, 0x0027,
    0xFFE1, 0xFFF4, 0x001B, 0x0011, 0x001A, 0x000B, 0x0004, 0x0005,
    0x001B, 0xFFF6, 0xFFF5, 0x0004, 0xFFFE, 0xFFE0, 0x0010, 0x0007,
    0xFFE5, 0x0018, 0x0024, 0xFFED, 0xFFFC, 0xFFFD, 0x000E, 0x0002,
    0x000A, 0x001B, 0x000C, 0x0013, 0xFFE5, 0x001A, 0x0003, 0x0009,
    0xFFF7, 0x0005, 0x000B, 0x001C, 0x0004, 0x000E, 0x000C, 0x0009,
    0xFFFA, 0xFFEB, 0xFFF3, 0xFFFE, 0xFFE5, 0xFFF9, 0xFFF7, 0xFFF6,
    0x0009, 0xFFF3, 0x0005, 0x0001, 0x0019, 0xFFD8, 0x0008, 0x0007,
    0x000A, 0x0013, 0x0014, 0x001A, 0xFFEE, 0xFFF0, 0x0022, 0xFFEF,
    0x0009, 0xFFEE, 0xFFF6, 0x0002, 0x0011, 0xFFFD, 0xFFF6, 0xFFF9,
    0x0017, 0x000C, 0xFFFD, 0x0025, 0xFFF1, 0xFFF6, 0x0003, 0xFFFC,
    0x0020, 0x0006, 0x0018, 0x0015, 0xFFC5, 0x000B, 0xFFF3, 0x0007,
    0x0000, 0x0019, 0x0014, 0x0007, 0x0005, 0xFFEE, 0xFFFD, 0x0019,
    0xFFE5, 0x001B, 0x002D, 0xFFF9, 0xFFFE, 0xFFE8, 0x0011, 0xFFEC,
    0x0004, 0x000B, 0x000B, 0xFFDF, 0x000D, 0xFFF5, 0x0006, 0xFFEF,
    0x000F, 0x000C, 0x0001, 0x0022, 0x001B, 0xFFFD, 0xFFF8, 0x0003,
    0x0013, 0xFFF0, 0x0002, 0xFFE0, 0x0020, 0x0002, 0xFFF2, 0xFFF9,
    0xFFF0, 0xFFEF, 0x000E, 0x0000, 0xFFF7, 0x0014, 0x0023, 0xFFF1,
    0x0015, 0x0011, 0xFFEC, 0x0003, 0x000B, 0xFFE0, 0x0014, 0xFFFA,
    0x0004, 0x000B, 0x000B, 0xFFFE, 0xFFF3, 0x0003, 0xFFE6, 0xFFDC,
    0xFFEC, 0x0003, 0xFFEC, 0xFFF4, 0x000C, 0xFFEB, 0x0010, 0xFFF1,
    0xFFF9, 0x0011, 0x0010, 0xFFF2, 0xFFEE, 0x000A, 0x001A, 0x001D,
    0xFFFE, 0xFFE5, 0xFFEC, 0x001D, 0xFFFB, 0xFFDC, 0xFFEC, 0x0004,
    0xFFF2, 0x0018, 0x001B, 0x0006, 0xFFED, 0xFFFD, 0xFFF6, 0x0005,
    0x000A, 0x0009, 0x0005, 0x0014, 0x0009, 0x0008, 0x0001, 0xFFF5,
    0x0009, 0x0000, 0xFFF9, 0x0003, 0xFFE8, 0xFFFF, 0xFFF4, 0xFFDE,
    0x000D, 0xFFFE, 0xFFF9, 0x000E, 0x000D, 0xFFE3, 0x001A, 0x000D,
    0xFFEF, 0x0018, 0x0000, 0x0002, 0xFFE7, 0xFFF6, 0xFFFF, 0x0009,
    0x0003, 0x0010, 0x001E, 0xFFF4, 0x0002, 0x000D, 0xFFFB, 0xFFFC,
    0x0003, 0xFFE1, 0x000A, 0x0008, 0xFFE5, 0x0005, 0xFFDC, 0x0011,
    0xFFE4, 0xFFFB, 0x0027, 0xFFF5, 0xFFF5, 0xFFD8, 0xFFE5, 0x0021,
    0xFFEF, 0x0000, 0x0014, 0x001F, 0x0016, 0xFFDC, 0x002B, 0xFFFA,
    0xFFFD, 0x0008, 0xFFF1, 0xFFDA, 0xFFFD, 0xFFF9, 0xFFEA, 0xFFFC,
    0x0014, 0x000B, 0x0019, 0x0012, 0xFFF8, 0x0009, 0xFFE6, 0x000B,
    0x000F, 0x0011, 0x0020, 0x001B, 0x000A, 0x000F, 0x0006, 0x0000,
    0xFFFF, 0x001B, 0x0013, 0x0001, 0xFFF5, 0x0016, 0x0004, 0x0005,
    0x0014, 0x0008, 0x0013, 0x0000, 0xFFE2, 0xFFFF, 0xFFF4, 0x0012,
    0x000F, 0x0004, 0xFFEC, 0x0017, 0xFFFD, 0x000B, 0xFFF8, 0x001D,
    0xFFEA, 0x000C, 0xFFF2, 0x000E, 0xFFDE, 0xFFF1, 0xFFF8, 0xFFEA,
    0xFFFF, 0x0007, 0x000D, 0xFFF7, 0x0001, 0xFFEF, 0xFFF8, 0x0017,
    0xFFFE, 0xFFF7, 0x000F, 0xFFFC, 0x0011, 0xFFE9, 0xFFFE, 0xFFE5,
    0x0002, 0x0000, 0x0001, 0x0001, 0x001A, 0xFFF8, 0x000D, 0xFFE5,
    0x0011, 0xFFFC, 0xFFFE, 0xFFD2, 0x0001, 0x002C, 0x0014, 0xFFFE,
    0xFFF0, 0x000F, 0xFFEE, 0xFFF6, 0x0009, 0x0004, 0xFFFB, 0x0000,
    0x0008, 0xFFF5, 0xFFFF, 0x000D, 0x001A, 0xFFED, 0xFFFB, 0x0011,
    0x0004, 0xFFF3, 0x0011, 0x0014, 0x001D, 0x0005, 0xFFEA, 0x000D,
    0xFFE2, 0x0009, 0xFFF8, 0x0001, 0x0005, 0xFFEB, 0x0004, 0xFFFC,
    0xFFE7, 0xFFFA, 0xFFEF, 0x0002, 0xFFEE, 0xFFEE, 0x000E, 0xFFEE,
    0xFFF1, 0x0016, 0x000A, 0xFFF6, 0x000B, 0x0001, 0x001B, 0xFFF4,
    0x0006, 0x0001, 0xFFFE, 0x000B, 0xFFE7, 0x0000, 0x0008, 0x0001,
    0xFFE4, 0xFFFA, 0x0017, 0xFFFE, 0x0028, 0x000E, 0x001D, 0x0009,
    0x000F, 0xFFF8, 0x0007, 0x000C, 0x001C, 0x000E, 0x0013, 0x0002,
    0x0010, 0x0011, 0x000C, 0x000A, 0x001D, 0xFFFE, 0xFFDD, 0xFFF2,
    0xFFDF, 0x0020, 0x0016, 0xFFFF, 0x0012, 0xFFED, 0xFFF9, 0xFFFF,
    0x000F, 0xFFE7, 0xFFDD, 0x0000, 0x003C, 0xFFF6, 0x0017, 0xFFF0,
    0x0000, 0x0011, 0xFFF2, 0x0002, 0x0005, 0x0017, 0x0021, 0xFFE7,
    0x0000, 0x0006, 0xFFFE, 0xFFF9, 0x0006, 0xFFE2, 0xFFFD, 0x0006,
    0x0009, 0xFFF7, 0x0008, 0x0013, 0x0013, 0xFFDE, 0x0001, 0xFFEF,
    0xFFE2, 0xFFE5, 0xFFE6, 0xFFE4, 0x000E, 0xFFF9, 0xFFF8, 0xFFEF,
    0x0009, 0xFFFB, 0xFFDD, 0xFFF9, 0x0010, 0xFFF4, 0x001A, 0x0009,
    0xFFDC, 0xFFF2, 0xFFF7, 0xFFFF, 0xFFE1, 0xFFFF, 0x0009, 0xFFF4,
    0xFFFA, 0x0003, 0x0008, 0xFFF6, 0x0002, 0x0016, 0x0006, 0x0009,
    0x0000, 0xFFEB, 0x0003, 0x0038, 0x0001, 0xFFFA, 0xFFF9, 0xFFF1,
    0xFFEB, 0xFFF0, 0x0016, 0x0010, 0x0004, 0x0018, 0xFFF8, 0x0001,
    0x0010, 0xFFF4, 0xFFEB, 0x0009, 0xFFFE, 0x0008, 0xFFF7, 0xFFEB,
    0xFFFF, 0xFFFD, 0xFFF4, 0xFFF2, 0x000D, 0xFFF2, 0x000F, 0xFFF4,
    0xFFFF, 0x0005, 0x0010, 0xFFFD, 0x0018, 0x0008, 0xFFE8, 0xFFEE,
    0xFFE8, 0x0000, 0x0011, 0xFFF2, 0xFFF5, 0x000A, 0xFFEA, 0x001E,
    0x000D, 0xFFD2, 0xFFD8, 0xFFFC, 0xFFF2, 0xFFEC, 0x0018, 0x0010,
    0xFFFB, 0xFFF5, 0xFFFC, 0xFFFA, 0xFFD3, 0xFFF5, 0x0005, 0x0012,
    0x0007, 0x0014, 0xFFF8, 0x0011, 0x000F, 0xFFF7, 0x000E, 0xFFF7,
    0x0011, 0xFFFF, 0xFFF9, 0xFFFD, 0x0017, 0x0002, 0x0005, 0x0012,
    0x000D, 0xFFF0, 0xFFF3, 0xFFFD, 0x0013, 0xFFE6, 0x001C, 0xFFF4,
    0xFFF7, 0x000C, 0xFFEE, 0xFFEF, 0xFFFC, 0xFFED, 0x0007, 0xFFE8,
    0xFFD7, 0xFFF6, 0xFFFB, 0xFFEB, 0xFFE5, 0xFFDD, 0xFFE0, 0x001C,
    0x0026, 0x0014, 0x0009, 0x0003, 0x0006, 0xFFFD, 0xFFFD, 0x0014,
    0xFFFF, 0x0009, 0xFFFF, 0xFFFD, 0xFFFA, 0x0006, 0xFFFA, 0x001B,
    0x0006, 0xFFF6, 0xFFED, 0x002B, 0x001C, 0x0014, 0xFFFB, 0x0017,
    0xFFE7, 0x0013, 0xFFEB, 0x000B, 0x0012, 0xFFDD, 0xFFEB, 0x0022,
    0xFFE4, 0xFFF1, 0xFFF3, 0xFFEA, 0x0004, 0x0003, 0x0003, 0x0000,
    0xFFFF, 0xFFDE, 0x0016, 0xFFF3, 0x0017, 0xFFF5, 0xFFF1, 0x0018,
    0x0016, 0x0004, 0x0001, 0xFFFB, 0x000B, 0xFFFA, 0x0008, 0xFFE2,
    0x001D, 0x0001, 0xFFF3, 0x000C, 0xFFF6, 0xFFEB, 0x0005, 0xFFFD,
    0x001D, 0x0002, 0x000F, 0x0012, 0x001F, 0xFFF7, 0xFFFD, 0xFFF6,
    0xFFFF, 0xFFFC, 0xFFE0, 0x0006, 0xFFFF, 0x0016, 0xFFFF, 0x0010,
    0x001C, 0xFFF9, 0xFFF7, 0xFFE7, 0x0008, 0xFFEC, 0xFFEE, 0x0003,
    0x0002, 0x0013, 0x0014, 0xFFE1, 0xFFEF, 0xFFF2, 0x000B, 0xFFE9,
    0x0003, 0xFFF8, 0x0024, 0x0024, 0xFFEB, 0xFFE5, 0x000C, 0x001F,
    0x0007, 0xFFF8, 0xFFFB, 0x001A, 0xFFF5, 0x000E, 0xFFF8, 0x0021,
    0xFFEC, 0xFFF9, 0x000C, 0xFFF5, 0xFFEE, 0x000D, 0xFFCC, 0x000F,
    0x0002, 0x001B, 0xFFFB, 0x000A, 0xFFF0, 0x000F, 0x0005, 0x0017,
    0x0019, 0xFFFF, 0xFFFB, 0xFFF6, 0xFFF4, 0xFFD2, 0x0013, 0xFFF0,
    0xFFE9, 0xFFFE, 0xFFE3, 0x0000, 0xFFF7, 0xFFEC, 0xFFDE, 0xFFF5,
    0xFFF4, 0xFFEF, 0xFFFE, 0xFFED, 0x0008, 0x0008, 0xFFFB, 0x000A,
    0xFFF8, 0xFFE6, 0xFFF6, 0xFFFC, 0xFFE0, 0x0005, 0x000B, 0xFFE7,
    0xFFE6, 0xFFF9, 0x0002, 0xFFFC, 0xFFF0, 0x0009, 0xFFED, 0xFFED,
    0xFFFF, 0xFFE3, 0x0009, 0xFFF3, 0xFFFD, 0x0010, 0x0024, 0xFFE8,
    0x0022, 0xFFDA, 0x000D, 0xFFF4, 0x0006, 0xFFFC, 0xFFE9, 0xFFFD,
    0x0001, 0x000A, 0xFFE2, 0xFFF5, 0xFFFD, 0x0015, 0x0011, 0x001C,
    0x0001, 0xFFFB, 0x001E, 0x0005, 0x0015, 0xFFF6, 0x0011, 0xFFFE,
    0x0025, 0xFFFB, 0x0003, 0x0002, 0x000E, 0xFFFF, 0x0012, 0xFFFE,
    0x0004, 0x0002, 0xFFF2, 0xFFFF, 0xFFEF, 0xFFF8, 0xFFF6, 0x0009,
    0xFFFA, 0xFFF0, 0x0005, 0xFFF2, 0x001B, 0xFFFE, 0xFFFF, 0xFFE6,
    0xFFF5, 0xFFFD, 0x000E, 0x001D, 0xFFFC, 0x0018, 0xFFEF, 0x0026,
    0x0001, 0x0011, 0xFFF8, 0xFFF3, 0x0007, 0xFFF6, 0xFFEA, 0x0023,
    0xFFFC, 0xFFFF, 0xFFFE, 0xFFFA, 0xFFF9, 0x0013, 0xFFFC, 0x0006,
    0x0004, 0xFFFE, 0xFFF3, 0xFFF9, 0x000F, 0xFFF1, 0xFFF4, 0x001F,
    0x0009, 0x0004, 0xFFD4, 0xFFFE, 0xFFF4, 0x000B, 0x0003, 0x0005,
    0x0008, 0x0004, 0xFFE4, 0xFFEB, 0x0023, 0x000D, 0xFFE3, 0x0003,
    0xFFFF, 0x0005, 0xFFF9, 0x0005, 0xFFF5, 0x0001, 0x001E, 0x0001,
    0xFFDF, 0xFFF9, 0xFFFA, 0xFFE9, 0xFFFD, 0xFFF4, 0xFFF3, 0x0009,
    0x0013, 0x000D, 0x0006, 0xFFE3, 0xFFF8, 0xFFFF, 0xFFFE, 0x0015,
    0x0007, 0x0006, 0xFFFC, 0xFFF4, 0x0014, 0x0008, 0xFFF8, 0x0005,
    0xFFFA, 0xFFFC, 0xFFF3, 0x0011, 0x0002, 0x0006, 0x000E, 0x0011,
    0xFFFB, 0xFFDE, 0xFFEA, 0x0013, 0x000D, 0x0001, 0xFFF7, 0x0005,
    0x0013, 0xFFF9, 0x0011, 0x0018, 0x0007, 0x0006, 0xFFF8, 0xFFED,
    0xFFFA, 0xFFEC, 0x0015, 0x000E, 0xFFFD, 0x000D, 0xFFFC, 0xFFED,
    0xFFF7, 0xFFFD, 0x0015, 0x0005, 0x000A, 0x001A, 0x0002, 0xFFFF,
    0x001B, 0x000B, 0x0007, 0x0003, 0x0008, 0x000C, 0xFFE6, 0x0012,
    0xFFF9, 0xFFFC, 0xFFFE, 0xFFFC, 0xFFE6, 0xFFFA, 0x000E, 0xFFFA,
    0x0001, 0xFFFA, 0x0002, 0x000D, 0x000A, 0x0004, 0xFFFB, 0xFFEA,
    0x001D, 0x0007, 0x001A, 0x0000, 0x0003, 0xFFF0, 0x0002, 0x0011,
    0x000D, 0x0015, 0x0010, 0x001D, 0xFFED, 0x0001, 0x0006, 0xFFEB,
    0xFFF8, 0xFFFD, 0xFFFA, 0xFFE5, 0xFFF7, 0xFFDE, 0x000C, 0x0007,
    0x0010, 0x000D, 0x0007, 0x0004, 0xFFF0, 0x0002, 0x0020, 0x000F,
    0x0005, 0x000F, 0x0003, 0x000D, 0xFFF8, 0x0016, 0xFFF3, 0xFFF7,
    0x0016, 0xFFFB, 0xFFF6, 0xFFEE, 0xFFFF, 0x0002, 0x0004, 0x000E,
    0xFFF7, 0xFFF9, 0xFFF7, 0xFFE4, 0xFFE6, 0x000F, 0xFFFD, 0x0000,
    0xFFF2, 0x0001, 0x0014, 0xFFE7, 0xFFEA, 0xFFFA, 0xFFEA, 0x0006,
    0x0022, 0xFFF3, 0xFFE8, 0x0007, 0xFFE3, 0x0000, 0xFFF5, 0x0008,
    0x000A, 0xFFFB, 0xFFFE, 0xFFE3, 0xFFE4, 0xFFFB, 0xFFF2, 0xFFF7,
    0xFFDB, 0x000A, 0x0002, 0x0015, 0xFFF2, 0xFFFD, 0xFFD7, 0x0003,
    0x000D, 0xFFFD, 0x0028, 0x001F, 0x000F, 0x0004, 0xFFF8, 0x0017,
    0xFFFC, 0xFFEC, 0x000A, 0x0022, 0x0018, 0xFFFC, 0x001B, 0x001D,
    0xFFFA, 0xFFFE, 0xFFE5, 0x000D, 0xFFF7, 0xFFF5, 0xFFF8, 0x0001,
    0x000C, 0xFFEC, 0x0006, 0x0000, 0xFFEC, 0x002E, 0xFFFA, 0xFFFD,
    0xFFFA, 0xFFEB, 0xFFF2, 0x0001, 0x001C, 0xFFF4, 0x0024, 0x000F,
    0x000D, 0xFFEB, 0x000A, 0xFFFD, 0xFFFB, 0xFFFB, 0x0018, 0xFFF2,
    0xFFFE, 0x0001, 0xFFF8, 0xFFD1, 0x0024, 0xFFE1, 0xFFEA, 0xFFF9,
    0xFFFE, 0xFFD9, 0x0017, 0x0001, 0x0006, 0xFFEA, 0xFFCE, 0x000B,
    0x0006, 0x0003, 0xFFF8, 0xFFF8, 0x0019, 0xFFF4, 0x0016, 0x000C,
    0xFFF4, 0xFFFF, 0xFFEE, 0xFFFC, 0xFFF4, 0x0016, 0x0007, 0x001D,
    0x0000, 0xFFE9, 0x001D, 0xFFFD, 0xFFF9, 0xFFF4, 0x0013, 0x0010,
    0x000E, 0xFFDB, 0xFFFE, 0x0003, 0xFFD9, 0x0002, 0xFFED, 0x0003,
    0x0005, 0x0014, 0x0007, 0xFFE9, 0xFFFC, 0xFFFD, 0xFFED, 0x0008,
    0xFFF3, 0xFFF6, 0x0020, 0xFFE9, 0x0002, 0x0008, 0xFFFD, 0x0013,
    0x0011, 0xFFD9, 0xFFF7, 0x0000, 0xFFF2, 0xFFF2, 0xFFDF, 0xFFFB,
    0xFFDA, 0xFFED, 0xFFF3, 0xFFF9, 0xFFFB, 0xFFFE, 0xFFE1, 0x0014,
    0x000C, 0x0012, 0xFFE8, 0xFFF5, 0xFFFA, 0xFFFC, 0x0016, 0x001D,
    0xFFE4, 0x000A, 0x0000, 0x0004, 0x0019, 0x000F, 0xFFE3, 0xFFDD,
    0x002C, 0xFFF5, 0x0004, 0xFFEC, 0xFFEE, 0x0004, 0xFFD5, 0x0016,
    0x0005, 0xFFF0, 0xFFEF, 0xFFF7, 0x0012, 0x0000, 0x0010, 0xFFE3,
    0x000C, 0xFFFE, 0xFFFB, 0x0003, 0x0004, 0x0006, 0x0017, 0xFFF9,
    0x0012, 0x0012, 0x0023, 0x0009, 0xFFFD, 0x0012, 0xFFF9, 0xFFEC,
    0x001A, 0xFFE8, 0x0004, 0xFFE6, 0xFFFD, 0xFFFB, 0xFFF0, 0xFFFD,
    0x0000, 0x0002, 0x0003, 0x0026, 0xFFFD, 0xFFF4, 0x0002, 0xFFF5,
    0xFFFB, 0xFFFB, 0x000B, 0xFFF5, 0x0004, 0x0006, 0x0018, 0xFFF0,
    0x0001, 0xFFEA, 0x0012, 0xFFF5, 0x000D, 0x0012, 0xFFF6, 0xFFFF,
    0x002B, 0x001B, 0xFFF4, 0x0023, 0x0009, 0xFFEB, 0x0008, 0xFFFD,
    0xFFF5, 0xFFFB, 0xFFFF, 0x0004, 0xFFF1, 0x0003, 0xFFF0, 0x0005,
    0x000F, 0x000F, 0xFFEF, 0x0005, 0x0001, 0x0003, 0xFFF2, 0xFFFF,
    0x0020, 0x0000, 0xFFF0, 0x0016, 0xFFF8, 0xFFFA, 0xFFF8, 0x000A,
    0xFFF5, 0x000D, 0xFFF8, 0x0016, 0x0006, 0x0002, 0xFFFC, 0xFFFA,
    0xFFE9, 0xFFEC, 0xFFE7, 0x0027, 0xFFF8, 0xFFF1, 0x002B, 0xFFD4,
    0x000A, 0xFFDC, 0x0031, 0x0008, 0xFFEA, 0x0010, 0xFFEF, 0x0000,
    0xFFFB, 0x0004, 0x0031, 0x0005, 0xFFFC, 0xFFFD, 0x000D, 0xFFF9,
    0x001F, 0x0003, 0xFFF0, 0xFFE4, 0xFFF8, 0x0010, 0x000B, 0x0006,
    0x000D, 0xFFF8, 0xFFFF, 0x000A, 0x0007, 0xFFF4, 0x0008, 0xFFE9,
    0xFFFD, 0xFFF4, 0xFFF1, 0xFFF8, 0xFFED, 0xFFF3, 0xFFFA, 0x0001,
    0xFFE6, 0xFFFA, 0xFFE5, 0xFFFD, 0xFFFA, 0xFFE8, 0x0019, 0xFFE4,
    0x000B, 0xFFE3, 0x0016, 0xFFFA, 0xFFF5, 0xFFEB, 0x0006, 0x0005,
    0x0003, 0x001B, 0x000C, 0xFFF2, 0xFFF5, 0xFFFC, 0x0008, 0x0015,
    0xFFED, 0x0009, 0x0001, 0xFFF3, 0x0012, 0xFFEE, 0xFFE9, 0x000D,
    0x000A, 0xFFF6, 0x0017, 0x001F, 0xFFFE, 0x001C, 0xFFE8, 0x000C,
    0xFFFE, 0xFFF3, 0x0017, 0xFFDA, 0xFFFC, 0xFFD8, 0x0000, 0xFFF8,
    0x000F, 0xFFE5, 0xFFFB, 0xFFFE, 0xFFF9, 0x0032, 0x0006, 0x0000,
    0x0014, 0xFFFF, 0x0007, 0x0003, 0xFFE3, 0x0008, 0x0007, 0xFFEA,
    0xFFF1, 0x0018, 0xFFF4, 0x0006, 0x0009, 0x000A, 0xFFF5, 0xFFF9,
    0x0023, 0xFFF1, 0x0001, 0x000A, 0x0005, 0xFFF0, 0x0010, 0x0001,
    0xFFF0, 0xFFF7, 0x0009, 0x0004, 0xFFF8, 0x0005, 0xFFF6, 0x000A,
    0xFFFF, 0x0007, 0x0021, 0x0008, 0xFFEF, 0x001F, 0x0005, 0xFFF3,
    0x0005, 0x0004, 0x0014, 0xFFF2, 0x0026, 0xFFF7, 0x0005, 0xFFFE,
    0xFFF9, 0xFFF4, 0x0002, 0x0014, 0x000B, 0x0002, 0xFFFC, 0xFFFF,
    0xFFFE, 0xFFE7, 0xFFF1, 0x0002, 0xFFF5, 0xFFEA, 0xFFF9, 0x0011,
    0xFFEA, 0x0009, 0x0016, 0xFFFB, 0xFFF9, 0x0001, 0x0007, 0xFFF2,
    0x0004, 0xFFEE, 0xFFF0, 0x000A, 0x0009, 0x0004, 0xFFFC, 0x000F,
    0xFFED, 0xFFF7, 0xFFF7, 0xFFF8, 0x0021, 0x0005, 0xFFF7, 0xFFEE,
    0xFFF8, 0x0017, 0x0011, 0xFFE5, 0x001C, 0x0009, 0x000D, 0x0016,
    0xFFEB, 0x000D, 0x000A, 0x0002, 0x0001, 0xFFF8, 0xFFF3, 0xFFFB,
    0xFFFE, 0xFFFB, 0x0012, 0x0012, 0xFFF5, 0xFFFC, 0x000C, 0x0003,
    0x0014, 0xFFFA, 0xFFED, 0xFFF5, 0xFFFE, 0xFFFC, 0x000A, 0x0002,
    0x0013, 0xFFEF, 0x0018, 0x000B, 0xFFFA, 0x0007, 0xFFFD, 0x0001,
    0x0001, 0x0007, 0xFFFE, 0xFFFB, 0xFFFE, 0xFFE6, 0x0003, 0xFFF6,
    0x0017, 0xFFED, 0x001A, 0xFFCA, 0xFFE7, 0xFFF3, 0xFFEC, 0x0004,
    0xFFFE, 0x001F, 0x0003, 0x0005, 0x0009, 0x0005, 0x0001, 0xFFD9,
    0xFFF4, 0x000F, 0x0018, 0x000E, 0xFFFB, 0x000B, 0xFFF0, 0x000D,
    0xFFF7, 0x000B, 0x0001, 0xFFFE, 0x0004, 0xFFF5, 0x0005, 0x0006,
    0xFFF0, 0xFFF0, 0xFFDD, 0x0010, 0xFFDF, 0xFFE5, 0xFFE2, 0x0016,
    0x001E, 0x0004, 0x000A, 0xFFE9, 0x0002, 0x0002, 0x0027, 0x0021,
    0xFFE1, 0xFFF7, 0x0014, 0x000E, 0x0013, 0x000B, 0x0011, 0xFFF9,
    0xFFF4, 0x001A, 0x000F, 0x0005, 0x0015, 0xFFFE, 0x0009, 0xFFE7,
    0xFFEA, 0x0022, 0x000F, 0xFFFF, 0xFFF5, 0x000F, 0xFFF1, 0xFFEC,
    0x0012, 0x001B, 0xFFEC, 0xFFF1, 0x001D, 0x000A, 0xFFFE, 0x0006,
    0x0003, 0x0001, 0xFFF9, 0x0014, 0xFFF7, 0xFFF4, 0x000C, 0xFFE1,
    0xFFFA, 0x000B, 0xFFF2, 0xFFDC, 0xFFE6, 0x000A, 0xFFDE, 0x000B,
    0x001A, 0x000F, 0xFFD8, 0x0011, 0xFFF5, 0x0005, 0xFFFC, 0xFFDB,
    0xFFEA, 0x000D, 0x0010, 0xFFE3, 0x0003, 0xFFDF, 0xFFFC, 0x000B,
    0x0008, 0xFFFA, 0xFFF5, 0xFFF9, 0x000D, 0xFFF8, 0xFFDF, 0x0007,
    0xFFF3, 0xFFD4, 0xFFF4, 0xFFEE, 0x0030, 0xFFE8, 0x0024, 0xFFFB,
    0x0004, 0x0006, 0xFFF3, 0x0002, 0x0029, 0x0001, 0x0014, 0x0007,
    0xFFFA, 0xFFEF, 0xFFF1, 0x000A, 0x001D, 0x0021, 0x0012, 0x0005,
    0x000A, 0x0017, 0xFFE9, 0xFFC8, 0x0004, 0x0005, 0xFFF7, 0xFFFC,
    0xFFF1, 0x0008, 0xFFEE, 0xFFDB, 0xFFE4, 0x0003, 0x0003, 0x0010,
    0x001B, 0x0001, 0xFFE5, 0x0023, 0x000B, 0xFFFA, 0x0009, 0xFFF5,
    0xFFFE, 0x000D, 0xFFF3, 0x0014, 0x0006, 0x0008, 0x000A, 0xFFFB,
    0xFFF4, 0x0011, 0xFFF7, 0x0002, 0xFFFD, 0x0003, 0xFFE9, 0x000A,
    0xFFEC, 0xFFF9, 0x0002, 0x000C, 0x0010, 0xFFF4, 0x0025, 0xFFFA,
    0x0001, 0xFFFF, 0x0022, 0xFFE7, 0x000B, 0x0007, 0x0008, 0xFFF2,
    0x0017, 0xFFF5, 0x0001, 0xFFF5, 0x000F, 0x0019, 0x0018, 0x0004,
    0xFFED, 0xFFF1, 0xFFF0, 0xFFE9, 0xFFFE, 0x0000, 0xFFF9, 0x001B,
    0xFFEA, 0xFFEB, 0xFFF8, 0xFFFF, 0x0011, 0x000E, 0x001A, 0x000A,
    0x000C, 0xFFFC, 0x0005, 0x0000, 0x000C, 0xFFF6, 0xFFF9, 0x000E,
    0xFFF9, 0xFFF6, 0xFFE6, 0x0019, 0xFFFE, 0xFFF3, 0x0002, 0x0005,
    0xFFFD, 0xFFFE, 0x000A, 0xFFFF, 0xFFEC, 0xFFCE, 0x0016, 0xFFFC,
    0xFFF5, 0x0006, 0x0009, 0x0000, 0xFFF4, 0xFFF4, 0x001E, 0x0014,
    0xFFFF, 0xFFF3, 0xFFF9, 0x0009, 0xFFDF, 0x0019, 0x0009, 0x0003,
    0x0006, 0xFFFB, 0xFFD3, 0x0012, 0xFFFF, 0x0001, 0x0001, 0xFFEE,
    0x0008, 0x000B, 0x000E, 0x0014, 0xFFF3, 0x000A, 0xFFE0, 0xFFFD,
    0xFFE2, 0xFFFD, 0x000D, 0xFFFD, 0x0013, 0xFFEA, 0x0016, 0x0014,
    0xFFEA, 0x000D, 0x000E, 0x0003, 0x0035, 0xFFF0, 0x0019, 0x001D,
    0x0009, 0x0002, 0x0024, 0x000A, 0xFFE7, 0x0015, 0xFFFE, 0x0013,
    0xFFFC, 0xFFEF, 0xFFDD, 0xFFFE, 0x0025, 0x0027, 0xFFF7, 0xFFF7,
    0x0007, 0xFFE9, 0xFFFC, 0x0016, 0x000C, 0x0005, 0x0003, 0x000C,
    0x0008, 0x000F, 0x000D, 0xFFFB, 0x0008, 0x0008, 0x001F, 0xFFFF,
    0xFFE9, 0xFFFE, 0xFFEA, 0xFFDC, 0x0032, 0xFFF5, 0x0008, 0x0009,
    0x0007, 0xFFF4, 0x0015, 0xFFFA, 0xFFFF, 0x0015, 0x000D, 0xFFEB,
    0xFFF5, 0xFFFE, 0x000A, 0x0007, 0x0015, 0x0007, 0xFFF8, 0x0000,
    0x0005, 0xFFEF, 0x001E, 0x0011, 0xFFF6, 0xFFEF, 0x0009, 0x0014,
    0xFFFF, 0x0001, 0x0014, 0x0003, 0x0012, 0x0009, 0x0017, 0xFFED,
    0x000A, 0xFFF5, 0xFFF8, 0x0010, 0xFFF1, 0xFFEA, 0x0007, 0x0015,
    0x000D, 0x0025, 0xFFF6, 0x002D, 0xFFF0, 0x000B, 0xFFFF, 0xFFFC,
    0xFFF4, 0xFFFE, 0xFFE7, 0xFFEB, 0x001A, 0x0008, 0x0007, 0xFFF7,
    0x000D, 0x0000, 0xFFE4, 0xFFF1, 0xFFED, 0x0018, 0x0005, 0x0004,
    0x001F, 0x0001, 0x0009, 0x0023, 0x0004, 0xFFF5, 0x0015, 0xFFF6,
    0xFFE5, 0xFFFA, 0xFFF4, 0xFFF4, 0x0014, 0x0002, 0x0017, 0xFFEA,
    0x001B, 0x0001, 0xFFEB, 0x0000, 0xFFFB, 0x001B, 0xFFF3, 0xFFFD,
    0x000E, 0x0022, 0x0002, 0x001A, 0xFFF9, 0xFFED, 0xFFFF, 0x0006,
    0x0013, 0xFFFC, 0xFFE4, 0xFFFC, 0x0007, 0x0007, 0x0003, 0xFFD5,
    0x0006, 0x0004, 0x0013, 0xFFF2, 0x0012, 0x000D, 0x000D, 0x0001,
    0xFFDB, 0xFFE3, 0x001B, 0xFFFD, 0x0009, 0x0006, 0xFFDC, 0x0002,
    0x0012, 0x000B, 0xFFE1, 0x0008, 0xFFEF, 0xFFFF, 0xFFEE, 0x0002,
    0x0018, 0x0015, 0x0009, 0xFFFA, 0xFFFD, 0x0010, 0x0004, 0x0013,
    0xFFFC, 0x000E, 0xFFFE, 0xFFFC, 0xFFF2, 0xFFFE, 0xFFE2, 0xFFFF,
    0xFFF2, 0xFFEF, 0x0017, 0xFFF9, 0xFFF2, 0x0001, 0xFFFA, 0xFFFB,
    0xFFFD, 0x0027, 0x0003, 0xFFF9, 0xFFFD, 0x000D, 0x000E, 0x000A,
    0x0021, 0xFFFC, 0xFFF4, 0x0006, 0x002C, 0xFFF5, 0x0008, 0xFFE9,
    0x0009, 0x0012, 0xFFFB, 0xFFF6, 0x0010, 0xFFFD, 0x0023, 0x0014,
    0xFFEF, 0x0006, 0xFFFF, 0xFFDB, 0x000F, 0xFFE9, 0x0017, 0x0008,
    0x001C, 0x0018, 0xFFF3, 0x000D, 0x0003, 0xFFF1, 0xFFF3, 0xFFDB,
    0xFFE6, 0xFFF2, 0xFFE0, 0xFFD5, 0x0000, 0xFFE3, 0xFFEB, 0x0013,
    0x0002, 0xFFFB, 0x0023, 0x0010, 0xFFFE, 0xFFFC, 0xFFFC, 0x0014,
    0x0004, 0xFFFE, 0xFFE2, 0xFFED, 0xFFE5, 0x0005, 0x0013, 0xFFED,
    0xFFE7, 0x000B, 0x0021, 0x002B, 0xFFFF, 0x0006, 0x0028, 0xFFF9,
    0x0018, 0xFFF4, 0x0013, 0xFFED, 0x0003, 0xFFF8, 0xFFD8, 0xFFF9,
    0x000C, 0xFFFC, 0x000C, 0x0006, 0xFFF5, 0x0010, 0x0001, 0x0005,
    0xFFF8, 0xFFF1, 0x0000, 0x0008, 0x0004, 0xFFF0, 0x0004, 0xFFFB,
    0xFFF3, 0xFFE7, 0x0024, 0xFFE9, 0xFFF8, 0xFFD0, 0xFFF7, 0x0007,
    0x0009, 0xFFEA, 0xFFEB, 0xFFFD, 0xFFF7, 0x0007, 0x0005, 0x0005,
    0xFFF8, 0xFFEF, 0xFFEF, 0x0015, 0x0017, 0xFFE6, 0xFFFC, 0x0000,
    0xFFE9, 0x001E, 0x0006, 0xFFE0, 0xFFF0, 0xFFFB, 0x0012, 0x000F,
    0x0018, 0xFFEF, 0x000A, 0xFFED, 0x000B, 0x0010, 0xFFE2, 0xFFFD,
    0x001D, 0x0000, 0xFFE2, 0x0015, 0x0008, 0xFFDC, 0xFFFA, 0xFFEB,
    0xFFF7, 0xFFF5, 0x0001, 0x001D, 0x000B, 0xFFF2, 0x0011, 0xFFFC,
    0xFFFB, 0xFFFD, 0xFFFE, 0xFFFC, 0x0001, 0xFFFE, 0x0007, 0x0009,
    0xFFE8, 0xFFFF, 0x0009, 0xFFFA, 0xFFFE, 0xFFFA, 0xFFFD, 0x0006,
    0x0001, 0xFFEE, 0xFFFA, 0x0008, 0x000C, 0x000E, 0xFFF2, 0xFFE9,
    0xFFF5, 0x0007, 0x0008, 0x0019, 0x0000, 0x001C, 0xFFF2, 0x001B,
    0xFFFC, 0xFFF1, 0x000B, 0x0016, 0xFFF2, 0x0024, 0xFFFB, 0xFFF3,
    0xFFF9, 0x0006, 0x001E, 0x0010, 0x000D, 0x0007, 0xFFDC, 0x000C,
    0x0005, 0xFFF8, 0x0009, 0x001C, 0xFFEC, 0x000F, 0x0011, 0xFFFA,
    0xFFF8, 0x0015, 0xFFFD, 0x0008, 0xFFF3, 0xFFEC, 0x0017, 0xFFD3,
    0x0005, 0x0011, 0xFFFD, 0xFFEB, 0x000E, 0xFFF8, 0x001E, 0x000D,
    0xFFF6, 0x0003, 0x0004, 0xFFED, 0xFFDA, 0x000B, 0xFFCC, 0xFFF2,
    0x0003, 0x0020, 0x0007, 0x0005, 0x000E, 0x0003, 0xFFED, 0xFFEF,
    0xFFDB, 0x0013, 0x000D, 0x001F, 0xFFF4, 0xFFF0, 0x0000, 0xFFE3,
    0xFFE8, 0xFFE7, 0xFFEC, 0xFFE6, 0xFFDB, 0xFFE5, 0xFFEF, 0x000E,
    0x0013, 0xFFF9, 0xFFE9, 0x0009, 0x0014, 0xFFF4, 0x001B, 0x0010,
    0xFFFD, 0x2CCE, 0x0015, 0x0015, 0x0006, 0x0009, 0xFFFD, 0xFFF6,
    0x000F, 0xFFF1, 0xFFF1, 0xFFF0, 0x0019, 0xFFEE, 0xFFE2, 0xFFFC,
    0x001C, 0x000D, 0x0007, 0xFFFE, 0x0020, 0x001D, 0x0001, 0x0000,
    0xFFF4, 0xFFF7, 0xFFEA, 0x0015, 0xFFE2, 0x0017, 0xFFE8, 0xFFF7,
    0x001C, 0xFFF2, 0x000F, 0xFFED, 0xFFEE, 0x0029, 0x0019, 0x0007,
    0x0002, 0x0007, 0x0001, 0xFFFD, 0xFFF3, 0x000C, 0xFFE4, 0x0019,
    0xFFF6, 0x0014, 0x001D, 0xFFE7, 0x0000, 0x0015, 0xFFF4, 0xFFE9,
    0x0026, 0x0009, 0xFFEA, 0x0005, 0x0027, 0xFFD8, 0x000A, 0xFFFE,
    0xFFF7, 0x0000, 0x000B, 0xFFEB, 0xFFF9, 0x0001, 0x0004, 0x0008,
    0x0026, 0xFFDF, 0x0005, 0xFFFD, 0x001A, 0xFFF6, 0x0004, 0xFFE5,
    0x0018, 0xFFEC, 0xFFEA, 0xFFFD, 0xFFFE, 0x0009, 0xFFEF, 0x000D,
    0xFFE4, 0xFFFC, 0xFFEB, 0x0005, 0xFFFE, 0x0003, 0x0003, 0xFFDB,
    0x0004, 0xFFFC, 0x0004, 0xFFF3, 0x0006, 0xFFF5, 0xFFF5, 0x0013,
    0x000C, 0x001B, 0x0019, 0xFFCB, 0xFFDD, 0x001A, 0xFFFF, 0x0005,
    0xFFED, 0xFFCF, 0x0011, 0xFFEC, 0xFFFC, 0x0001, 0xFFFD, 0xFFFB,
    0x0003, 0xFFFC, 0xFFE1, 0x001D, 0xFFE6, 0x001C, 0x0001, 0xFFF7,
    0x0009, 0xFFFC, 0xFFF9, 0xFFFE, 0xFFFB, 0xFFF9, 0xFFFC, 0xFFFC,
    0xFFEC, 0xFFEA, 0x0015, 0xFFFF, 0x0004, 0x0020, 0x0012, 0x0003,
    0xFFE7, 0xFFF8, 0xFFF8, 0x0000, 0xFFFA, 0xFFEA, 0xFFF7, 0xFFF5,
    0xFFFC, 0xFFF5, 0x000A, 0xFFEC, 0x0004, 0x0006, 0x0001, 0xFFF7,
    0x0008, 0x000D, 0xFFF4, 0xFFD8, 0xFFEC, 0x0012, 0x0000, 0x0022,
    0xFFED, 0x0022, 0x001F, 0xFFF3, 0x0000, 0xFFF9, 0x001C, 0xFFF5,
    0x0018, 0x0008, 0x000D, 0xFFFB, 0x0007, 0xFFF4, 0x0021, 0x0009,
    0xFFF5, 0xFFF4, 0x0010, 0x0012, 0xFFFB, 0x0006, 0x000E, 0x0008,
    0xFFE3, 0x0001, 0xFFF0, 0xFFFD, 0x001A, 0x0000, 0xFFF7, 0x001C,
    0xFFF5, 0xFFF2, 0xFFEF, 0x000F, 0xFFFC, 0x0024, 0xFFE9, 0x000A,
    0x0016, 0xFFF6, 0x000A, 0xFFF8, 0xFFF0, 0xFFF6, 0x0006, 0x0000,
    0x0001, 0x0018, 0x0018, 0x0001, 0xFFD5, 0xFFF1, 0xFFF5, 0x000B,
    0xFFF9, 0x0004, 0xFFF0, 0x0003, 0xFFEC, 0xFFE9, 0x0009, 0x0010,
    0xFFF6, 0xFFE4, 0x000A, 0x0004, 0xFFFB, 0xFFEA, 0x000E, 0x0029,
    0x0011, 0x002B, 0x0015, 0x000D, 0xFFDD, 0x001A, 0xFFF8, 0xFFD8,
    0xFFFC, 0xFFE1, 0x0000, 0x000F, 0x0021, 0xFFED, 0xFFEC, 0x0002,
    0x001B, 0xFFF9, 0xFFFF, 0xFFF6, 0xFFF3, 0xFFEF, 0xFFF0, 0xFFF6,
    0xFFC9, 0x0000, 0xFFEE, 0xFFE9, 0xFFE1, 0x0012, 0x0007, 0xFFF5,
    0x0013, 0xFFFE, 0xFFF9, 0xFFEA, 0xFFFE, 0xFFF5, 0x0001, 0xFFFA,
    0xFFFC, 0x0000, 0x0001, 0x000F, 0x0004, 0xFFE0, 0x000E, 0xFFF2,
    0x0004, 0x0001, 0xFFE4, 0x0007, 0x0010, 0x0008, 0x0002, 0x0009,
    0x0004, 0xFFE7, 0xFFEB, 0x000C, 0x0018, 0x001A, 0x0003, 0xFFEC,
    0xFFF3, 0x0014, 0x0014, 0x0007, 0xFFD9, 0xFFFB, 0x000E, 0xFFFA,
    0xFFFD, 0xFFF6, 0xFFF3, 0x0001, 0xFFDC, 0x000F, 0x0006, 0x0016,
    0xFFF3, 0x0007, 0x0009, 0xFFF9, 0x000C, 0xFFF4, 0xFFE0, 0xFFFE,
    0xFFE3, 0x000A, 0x0019, 0x0014, 0x0001, 0xFFFD, 0xFFF3, 0xFFF1,
    0xFFD7, 0xFFFE, 0x001C, 0xFFFB, 0x000B, 0x000D, 0xFFF3, 0x0005,
    0xFFEA, 0x0000, 0x002C, 0xFFD4, 0x0001, 0x0016, 0x0032, 0xFFF0,
    0x0000, 0x000A, 0x0008, 0xFFF8, 0x0005, 0x002D, 0x001E, 0x0014,
    0xFFF5, 0xFFFE, 0xFFF4, 0x0008, 0xFFF2, 0x0015, 0x0019, 0x000D,
    0xFFFB, 0xFFFD, 0x000C, 0x0019, 0x0001, 0xFFFB, 0x0011, 0xFFF5,
    0xFFF2, 0x0018, 0x0016, 0xFFFE, 0x001A, 0x0002, 0x0006, 0x001A,
    0xFFFF, 0xFFE9, 0x0013, 0x0001, 0xFFF7, 0xFFF8, 0x0016, 0xFFDE,
    0xFFF7, 0xFFD4, 0x000A, 0xFFDC, 0xFFEE, 0x001A, 0x0002, 0xFFF5,
    0x0000, 0xFFEC, 0x0020, 0x0008, 0x000C, 0xFFF1, 0x0023, 0x0000,
    0x001D, 0xFFF9, 0xFFFB, 0x0024, 0xFFDD, 0x002A, 0xFFF4, 0x000A,
    0x001D, 0x001C, 0xFFFA, 0xFFFC, 0xFFFA, 0x001B, 0x001A, 0x000F,
    0x0010, 0x0010, 0x0001, 0x0011, 0x0002, 0xFFF3, 0x0014, 0x001B,
    0x0007, 0xFFF7, 0x0003, 0x0017, 0x0004, 0x0013, 0x000A, 0x0009,
    0xFFDC, 0xFFE9, 0x0017, 0xFFF9, 0x000A, 0xFFDD, 0x0007, 0x0005,
    0x0007, 0xFFF0, 0x000A, 0xFFED, 0x0010, 0xFFFF, 0x0014, 0x0005,
    0xFFDE, 0x0004, 0x0005, 0x000E, 0xFFE0, 0xFFF3, 0x0032, 0x0019,
    0xFFEC, 0x0002, 0xFFEF, 0x0006, 0xFFF1, 0xFFD7, 0x000B, 0x0010,
    0xFFFB, 0xFFEC, 0xFFEE, 0x0004, 0xFFF9, 0xFFDA, 0x0014, 0xFFF2,
    0x0013, 0x0008, 0x0006, 0xFFF3, 0xFFF8, 0xFFF9, 0xFFF5, 0xFFF7,
    0xFFFA, 0x0015, 0xFFE2, 0x0016, 0xFFF3, 0x0001, 0x0012, 0x0003,
    0x0007, 0xFFFF, 0x0003, 0x0017, 0xFFE7, 0xFFE9, 0x0002, 0x0000,
    0xFFF0, 0xFFEC, 0x000E, 0x0007, 0x000D, 0x0003, 0xFFF3, 0x000D,
    0xFFF7, 0x0012, 0x0015, 0xFFFD, 0x000D, 0x0009, 0x001F, 0x000A,
    0x000A, 0xFFEE, 0xFFFC, 0xFFF9, 0xFFFB, 0x000E, 0xFFFD, 0x000C,
    0x0001, 0xFFF3, 0x0004, 0xFFE4, 0x0014, 0xFFFE, 0x0003, 0xFFFE,
    0x0016, 0xFFFD, 0xFFEF, 0xFFD2, 0x000F, 0x001E, 0xFFFE, 0x0027,
    0xFFFA, 0x000D, 0x0003, 0xFFE5, 0x0004, 0xFFFB, 0xFFFD, 0xFFEC,
    0x0010, 0x0002, 0xFFFB, 0x0011, 0x002E, 0x0008, 0xFFEA, 0x000F,
    0xFFE9, 0xFFFB, 0x0011, 0xFFFB, 0x0008, 0xFFE7, 0x0024, 0x0005,
    0x0005, 0x0003, 0xFFF9, 0xFFE7, 0xFFFA, 0x0011, 0x0009, 0x0009,
    0xFFF9, 0xFFEA, 0xFFEF, 0x0035, 0x0002, 0xFFFB, 0x0011, 0x000A,
    0x0011, 0x0022, 0x001A, 0xFFFF, 0xFFEE, 0xFFF5, 0xFFEE, 0xFFE0,
    0xFFEA, 0x0016, 0x0010, 0xFFEF, 0xFFF9, 0xFFFA, 0x0016, 0x0007,
    0x000B, 0x0002, 0xFFF4, 0x0004, 0xFFE7, 0x0019, 0xFFFD, 0x000F,
    0x002D, 0x001A, 0xFFF1, 0x000B, 0x000F, 0x0001, 0xFFF8, 0x000E,
    0xFFEB, 0xFFEB, 0xFFE9, 0xFFF3, 0xFFF8, 0x0009, 0x0016, 0xFFEC,
    0x000F, 0xFFF5, 0x000D, 0x0019, 0xFFEC, 0xFFEC, 0x0016, 0xFFF4,
    0x0018, 0x0014, 0xFFF1, 0xFFFD, 0xFFF6, 0xFFF4, 0xFFED, 0x0013,
    0x000F, 0x001D, 0xFFEE, 0x0009, 0xFFFF, 0x000C, 0xFFE8, 0x0014,
    0x0012, 0xFFF1, 0xFFF4, 0x0019, 0x0014, 0xFFF6, 0x0018, 0xFFF6,
    0x000E, 0x0012, 0xFFF8, 0xFFDE, 0x000B, 0x000B, 0x0013, 0xFFFC,
    0xFFFA, 0x000C, 0xFFEA, 0xFFE3, 0xFFE7, 0x000E, 0x0003, 0x001E,
    0xFFED, 0xFFFF, 0x0009, 0x0013, 0xFFFD, 0xFFFB, 0x0010, 0x003E,
    0xFFF8, 0xFFF8, 0xFFF1, 0x0011, 0x002C, 0xFFFC, 0x0012, 0x0002,
    0x001C, 0x0001, 0x0001, 0x0000, 0xFFF1, 0xFFEA, 0xFFE5, 0x0026,
    0xFFFD, 0x0004, 0x000B, 0x0005, 0x0014, 0x0001, 0xFFF8, 0x0004,
    0x0014, 0x001C, 0x000F, 0x0016, 0x0023, 0xFFE5, 0x0013, 0x0006,
    0x0000, 0xFFE8, 0x0003, 0xFFE9, 0x000D, 0x000B, 0xFFF7, 0x0001,
    0x000C, 0xFFFA, 0xFFE8, 0xFFEA, 0xFFCD, 0x0009, 0xFFF4, 0x0010,
    0xFFFB, 0xFFFA, 0x0003, 0xFFE3, 0xFFEF, 0xFFF3, 0x0002, 0xFFE7,
    0xFFE0, 0x0018, 0x0002, 0x0016, 0x001B, 0x000B, 0x0002, 0x000E,
    0x0008, 0xFFD9, 0x0002, 0x0002, 0x0004, 0xFFFB, 0x000B, 0x0002,
    0xFFF7, 0xFFE3, 0xFFFF, 0x0000, 0xFFF0, 0xFFE3, 0x0003, 0x0005,
    0xFFF1, 0xFFF5, 0xFFF8, 0x000E, 0xFFD0, 0xFFF4, 0xFFF2, 0x0003,
    0x0005, 0xFFDA, 0xFFFC, 0x0003, 0x0010, 0x000E, 0x0014, 0x0010,
    0xFFDC, 0xFFF0, 0xFFF6, 0x0000, 0xFFFE, 0x002C, 0x000D, 0xFFEC,
    0x0010, 0xFFD8, 0xFFF9, 0x0004, 0x0011, 0xFFFE, 0x002D, 0x001A,
    0xFFEC, 0xFFFA, 0xFFEE, 0xFFD5, 0x000E, 0x0001, 0xFFF1, 0x0019,
    0x0007, 0x0006, 0x000C, 0xFFFC, 0xFFF4, 0x0007, 0x0013, 0x0007,
    0x001A, 0x0005, 0xFFEC, 0x0023, 0x0010, 0x0000, 0x0007, 0xFFFA,
    0x0015, 0x0005, 0x0004, 0xFFFF, 0x0008, 0x0016, 0x0007, 0x0006,
    0xFFF9, 0xFFF1, 0x0009, 0xFFDE, 0x0005, 0x0004, 0x0010, 0x0000,
    0xFFD4, 0xFFFD, 0xFFE9, 0x0003, 0x000E, 0xFFFB, 0xFFFB, 0xFFE2,
    0x0006, 0x0014, 0x0004, 0xFFFE, 0x0009, 0xFFF6, 0x0015, 0xFFEF,
    0xFFDE, 0x000A, 0xFFE3, 0x002A, 0xFFE0, 0xFFF0, 0x0018, 0x000D,
    0xFFFC, 0x0017, 0x0005, 0x0024, 0xFFEF, 0x0001, 0xFFF6, 0xFFEE,
    0x0013, 0x000A, 0x0007, 0xFFF4, 0x0021, 0x0021, 0x0007, 0x0007,
    0x000E, 0x000C, 0x0015, 0xFFFA, 0x0026, 0xFFF4, 0xFFE2, 0x0005,
    0x0016, 0xFFDD, 0x0008, 0xFFFB, 0xFFF1, 0x000D, 0x0012, 0xFFEB,
    0xFFF8, 0xFFDF, 0x0009, 0x0013, 0xFFFC, 0xFFFE, 0x001A, 0xFFEF,
    0xFFE6, 0x001A, 0x000F, 0x0016, 0xFFF6, 0xFFE1, 0x0000, 0xFFF8,
    0x000A, 0xFFFF, 0x0008, 0x0006, 0x0002, 0x0000, 0x000B, 0xFFFB,
    0x000D, 0xFFFA, 0xFFFB, 0x0012, 0xFFF6, 0xFFF4, 0xFFFB, 0x0018,
    0xFFF3, 0xFFFE, 0x0006, 0xFFFC, 0x000C, 0x0000, 0xFFE4, 0xFFF7,
    0x0014, 0xFFF4, 0x001F, 0x000E, 0xFFF5, 0x0007, 0x0002, 0xFFD8,
    0xFFF8, 0x0019, 0x0000, 0x000C, 0x001D, 0x0014, 0xFFE7, 0x0031,
    0xFFD1, 0x0013, 0x000B, 0x0020, 0x000F, 0xFFE4, 0x0007, 0x0025,
    0xFFEE, 0xFFF4, 0x0000, 0xFFF7, 0x000A, 0xFFF1, 0x000C, 0x0011,
    0xFFE9, 0x0002, 0xFFF5, 0x0016, 0xFFFB, 0xFFFB, 0x000A, 0xFFE7,
    0x0000, 0xFFEC, 0xFFD2, 0xFFD5, 0xFFF7, 0xFFDA, 0x0019, 0x0022,
    0xFFF5, 0xFFEE, 0xFFFB, 0x0020, 0xFFF1, 0x0006, 0xFFF9, 0x0012,
    0x001A, 0x0002, 0xFFFE, 0xFFEE, 0x0012, 0xFFFF, 0x0003, 0x0016,
    0xFFF2, 0xFFD7, 0x0009, 0xFFFD, 0xFFF6, 0xFFE0, 0x0005, 0xFFFB,
    0x000F, 0xFFFA, 0x0007, 0x000C, 0xFFDE, 0xFFEE, 0xFFF6, 0x0017,
    0x001C, 0x0003, 0xFFF1, 0xFFFF, 0x0001, 0xFFE3, 0xFFFB, 0xFFF8,
    0xFFE5, 0xFFE4, 0x000E, 0xFFED, 0x000E, 0xFFE3, 0x0014, 0x0032
    };

static const q15_t ref_cfft_noisy_4096[8192] = {
    0x0021, 0x0000, 0x0014, 0xFFCE, 0x000E, 0x001D, 0x000E, 0x0013,
    0xFFE5, 0x001C, 0xFFFB, 0x0008, 0x0001, 0x001D, 0xFFF1, 0x0001,
    0x001C, 0xFFFD, 0xFFF6, 0xFFE9, 0xFFDE, 0x0012, 0x0007, 0xFFF4,
    0x000F, 0x0006, 0x0005, 0x0005, 0xFFF6, 0x0020, 0x0009, 0x0003,
    0xFFF2, 0x0029, 0x0003, 0xFFEA, 0x0012, 0x0001, 0xFFFE, 0x0012,
    0x001A, 0xFFFE, 0xFFF9, 0xFFEE, 0xFFF1, 0xFFFA, 0xFFFB, 0xFFE0,
    0xFFF5, 0x0012, 0x0019, 0xFFDE, 0xFFF7, 0x0026, 0xFFD2, 0x002B,
    0x0000, 0x0014, 0x000A, 0x0019, 0xFFFB, 0x0005, 0xFFF5, 0xFFEA,
    0xFFE9, 0xFFFE, 0x000C, 0xFFEF, 0x000A, 0x000F, 0x0000, 0x0009,
    0xFFEE, 0x000C, 0x0007, 0xFFDB, 0x000F, 0x001C, 0x000B, 0xFFE0,
    0xFFD1, 0xFFED, 0xFFE7, 0xFFCF, 0x001D, 0xFFEC, 0x0000, 0xFFF4,
    0xFFF8, 0xFFE7, 0x0002, 0x0028, 0xFFF5, 0xFFF9, 0x001F, 0xFFF2,
    0x0014, 0x000C, 0xFFE4, 0x0009, 0x000C, 0x0000, 0x0006, 0x0004,
    0xFFF3, 0x0002, 0xFFFB, 0xFFE8, 0xFFF6, 0x000C, 0xFFFB, 0xFFEE,
    0x000D, 0x0006, 0x000B, 0x0005, 0x0002, 0x0000, 0x0008, 0xFFFA,
    0x000A, 0x0001, 0x0000, 0x0008, 0xFFF6, 0x001F, 0x000F, 0xFFEA,
    0xFFE6, 0xFFE6, 0x001A, 0x0011, 0xFFFC, 0x0002, 0x0009, 0xFFED,
    0xFFF8, 0x0021, 0x0012, 0x0015, 0xFFF1, 0xFFF3, 0x0008, 0x0005,
    0x0016, 0x0023, 0xFFE2, 0xFFFB, 0x0026, 0x000C, 0x0015, 0x0006,
    0x000E, 0xFFF4, 0x0007, 0xFFF9, 0x0021, 0xFFDF, 0x0007, 0x000C,
    0x0013, 0xFFF6, 0xFFF6, 0x0012, 0xFFEF, 0xFFFF, 0x0005, 0xFFDC,
    0xFFFC, 0xFFE9, 0x0018, 0xFFF3, 0xFFE0, 0x0010, 0xFFE3, 0xFFD6,
    0xFFDE, 0xFFF6, 0x0015, 0x0011, 0x0009, 0x000A, 0x0004, 0x0002,
    0x0006, 0xFFEC, 0xFFFB, 0x001E, 0x000E, 0x0005, 0xFFE9, 0xFFFD,
    0xFFD4, 0x0003, 0x0010, 0x0000, 0x0005, 0xFFFC, 0x0009, 0x0022,
    0xFFF9, 0x000F, 0x0007, 0xFFFA, 0x0008, 0xFFEA, 0x0004, 0x0001,
    0x0015, 0xFFFB, 0x0007, 0x0006, 0x0010, 0x0000, 0xFFEC, 0xFFDD,
    0x001A, 0xFFFB, 0x0013, 0xFFF9, 0xFFF4, 0xFFF9, 0x000C, 0x0004,
    0x0007, 0xFFFA, 0xFFF1, 0xFFE7, 0x000E, 0xFFFF, 0xFFEE, 0x002B,
    0xFFEC, 0x0006, 0x002D, 0xFFE6, 0x0011, 0x0002, 0xFFF9, 0xFFFC,
    0x0010, 0x0028, 0x000D, 0x0014, 0xFFFE, 0xFFD4, 0xFFF6, 0x0000,
    0xFFDC, 0x0010, 0x0014, 0xFFF0, 0x0010, 0xFFF2, 0xFFFC, 0xFFFD,
    0x0005, 0x0026, 0xFFF2, 0xFFFD, 0xFFD0, 0x000C, 0xFFF8, 0xFFF2,
    0xFFF1, 0x000B, 0x0003, 0xFFFB, 0xFFF0, 0x001D, 0xFFFF, 0x0000,
    0xFFF7, 0x001D, 0x000B, 0xFFFE, 0x0004, 0x0005, 0x0002, 0xFFFE,
    0x0008, 0x0027, 0x0002, 0xFFF2, 0x001B, 0xFFF5, 0x0002, 0xFFEA,
    0xFFE0, 0xFFE8, 0x0002, 0x0019, 0xFFEF, 0x000D, 0x0003, 0x001D,
    0xFFFB, 0x0006, 0xFFF4, 0xFFF0, 0xFFCD, 0xFFF7, 0xFFE8, 0x0016,
    0x000C, 0x0006, 0xFFF7, 0xFFFF, 0x000D, 0xFFF5, 0x0003, 0x0017,
    0x0000, 0x0018, 0x0013, 0xFFFA, 0x0023, 0x001B, 0x000F, 0xFFEA,
    0x0014, 0xFFE4, 0xFFF8, 0xFFFC, 0x0014, 0xFFFF, 0x000B, 0xFFFB,
    0xFFFD, 0xFFFC, 0xFFE5, 0xFFDA, 0xFFF1, 0x0016, 0x0001, 0x0000,
    0x001C, 0xFFFF, 0x0012, 0xFFFE, 0x002C, 0x0004, 0xFFF1, 0xFFEF,
    0xFFF8, 0x0008, 0x0010, 0xFFC2, 0xFFFD, 0x0005, 0x0009, 0xFFED,
    0xFFED, 0x0001, 0x0003, 0xFFE2, 0xFFE7, 0xFFF2, 0xFFEA, 0x001D,
    0xFFFA, 0xFFF4, 0x0013, 0x0004, 0x000B, 0xFFF5, 0xFFF8, 0x0022,
    0x000E, 0xFFEE, 0x0018, 0x000A, 0x0014, 0x000A, 0xFFF4, 0xFFE7,
    0x0012, 0x000F, 0xFFE8, 0xFFEC, 0xFFFF, 0xFFF4, 0xFFEE, 0xFFF7,
    0x000F, 0xFFE3, 0xFFED, 0xFFED, 0xFFF6, 0x000C, 0xFFF1, 0x0003,
    0x0018, 0xFFEC, 0x0016, 0x000C, 0xFFEC, 0x0014, 0x000D, 0xFFE7,
    0x000F, 0x000B, 0x0016, 0x0014, 0xFFF8, 0xFFF7, 0xFFE9, 0x000D,
    0xFFEB, 0x0015, 0xFFF8, 0xFFF2, 0x000F, 0xFFFF, 0xFFF1, 0xFFF5,
    0x002D, 0xFFE6, 0xFFFD, 0xFFF1, 0xFFE7, 0xFFE7, 0xFFF4, 0xFFFC,
    0x000B, 0xFFFE, 0x0016, 0xFFF9, 0xFFF9, 0x0006, 0x0010, 0x0011,
    0xFFEA, 0xFFEA, 0xFFEE, 0x0020, 0xFFEE, 0x000B, 0x001A, 0x0001,
    0x0011, 0xFFDE, 0x0011, 0xFFF6, 0x0002, 0x0005, 0xFFEF, 0xFFCB,
    0xFFF9, 0x0016, 0x0009, 0xFFF7, 0xFFFA, 0xFFEF, 0xFFF9, 0x0019,
    0x0005, 0xFFFD, 0x0024, 0xFFFB, 0x0008, 0x0019, 0x0011, 0x0005,
    0xFFE9, 0x0005, 0xFFEA, 0xFFF1, 0x002E, 0xFFF8, 0xFFFB, 0xFFEF,
    0x0010, 0xFFFE, 0xFFFD, 0x0014, 0x0004, 0x0005, 0x0003, 0x001B,
    0xFFFA, 0xFFF3, 0xFFFE, 0xFFD9, 0x000F, 0xFFE2, 0xFFEF, 0x002E,
    0x0016, 0x0003, 0x0003, 0x0002, 0x0014, 0x0002, 0x0004, 0x001C,
    0x0001, 0x000D, 0xFFFD, 0xFFF4, 0xFFFB, 0xFFF2, 0xFFFC, 0x0007,
    0x000A, 0x0012, 0x001F, 0xFFF6, 0x000D, 0xFFF7, 0x0015, 0x0003,
    0xFFF7, 0xFFEE, 0xFFF3, 0xFFF3, 0x000D, 0xFFFD, 0x000E, 0xFFF9,
    0xFFF0, 0x0014, 0x0002, 0x0000, 0xFFE7, 0x0017, 0x0003, 0xFFE9,
    0x0007, 0x0001, 0x0012, 0xFFFD, 0xFFF3, 0xFFFF, 0xFFE2, 0xFFEA,
    0xFFFA, 0xFFEB, 0xFFF5, 0x0009, 0xFFF8, 0x0007, 0x0006, 0x000D,
    0x0013, 0xFFF8, 0x0014, 0x000E, 0xFFF9, 0x0026, 0xFFEE, 0xFFFC,
    0xFFFB, 0x0014, 0x000B, 0xFFF0, 0xFFF1, 0x0029, 0xFFEF, 0xFFFA,
    0xFFEC, 0xFFFE, 0x0032, 0xFFE7, 0xFFE0, 0x000D, 0x0005, 0xFFF2,
    0xFFDE, 0xFFFC, 0x0014, 0xFFFB, 0x0010, 0x0001, 0x000A, 0x0013,
    0x0007, 0x0010, 0x0007, 0xFFFB, 0x000A, 0x0023, 0x0017, 0x0007,
    0xFFDC, 0x0017, 0x000A, 0xFFF7, 0x0004, 0xFFED, 0x0003, 0xFFE9,
    0x0007, 0x0009, 0x0014, 0xFFE5, 0x0002, 0x000D, 0x0001, 0xFFEF,
    0x0010, 0xFFF0, 0x001A, 0xFFF1, 0xFFFA, 0xFFE5, 0xFFFA, 0x0004,
    0x001D, 0xFFE4, 0xFFF4, 0xFFF6, 0xFFDD, 0xFFD6, 0xFFFB, 0xFFDC,
    0x001D, 0x0007, 0x0023, 0x0000, 0x000C, 0x000F, 0x0020, 0xFFF8,
    0x0000, 0x0014, 0x0002, 0x000B, 0xFFEE, 0xFFE6, 0x000A, 0x0024,
    0xFFF7, 0x002C, 0x0016, 0x0022, 0xFFF7, 0x0008, 0x0013, 0xFFFF,
    0xFFFF, 0x0017, 0x0006, 0xFFE6, 0x001A, 0xFFFE, 0x0016, 0x0002,
    0xFFF2, 0xFFE8, 0x0011, 0x000B, 0x0001, 0x0005, 0x000C, 0xFFE7,
    0xFFFB, 0x0003, 0x0019, 0xFFF3, 0xFFF2, 0xFFEB, 0xFFF4, 0xFFF8,
    0xFFF5, 0x0002, 0x001E, 0xFFEC, 0x0005, 0xFFD3, 0x0008, 0x0008,
    0x0000, 0xFFF6, 0x0032, 0x0010, 0x0001, 0xFFEA, 0x002C, 0x002C,
    0xFFEA, 0x0000, 0xFFF3, 0xFFFB, 0x000B, 0xFFF3, 0x001C, 0x0005,
    0xFFD7, 0x0002, 0xFFF3, 0x000F, 0x0001, 0x0003, 0x0019, 0xFFEC,
    0xFFE3, 0xFFF6, 0xFFE0, 0x0002, 0x000C, 0x000C, 0x0009, 0x0007,
    0xFFF3, 0xFFF9, 0x0006, 0xFFEA, 0xFFDC, 0xFFF1, 0xFFF3, 0xFFFF,
    0xFFFD, 0x000A, 0x000E, 0x0006, 0xFFD9, 0x0005, 0x0014, 0xFFF9,
    0xFFF3, 0xFFEC, 0x0003, 0x0014, 0x0018, 0xFFE6, 0xFFEB, 0xFFF4,
    0x0004, 0x0019, 0x0002, 0xFFF7, 0x0010, 0xFFF8, 0xFFE4, 0xFFF9,
    0x0004, 0xFFFF, 0x000E, 0x000E, 0x0004, 0x0020, 0x0001, 0xFFF1,
    0xFFFC, 0x0000, 0x0001, 0x0006, 0xFFFE, 0x000B, 0xFFF9, 0x0016,
    0x0013, 0x0002, 0x0007, 0x000B, 0xFFE1, 0xFFEE, 0xFFEE, 0x0017,
    0xFFC9, 0x0000, 0xFFF0, 0x000A, 0xFFF3, 0x0011, 0xFFFF, 0x000A,
    0x001B, 0x0007, 0xFFEC, 0xFFFE, 0x0021, 0x0013, 0x0000, 0xFFF1,
    0xFFFC, 0x001F, 0xFFF8, 0x0028, 0xFFDD, 0xFFE6, 0x0015, 0xFFF3,
    0x0011, 0xFFD5, 0x000E, 0xFFD7, 0xFFFB, 0x0016, 0x000A, 0xFFFC,
    0xFFF6, 0x001C, 0x0009, 0xFFF0, 0xFFEC, 0x0017, 0xFFF0, 0xFFFD,
    0xFFF9, 0xFFFC, 0xFFF5, 0xFFF5, 0xFFD5, 0x000F, 0x0018, 0xFFFF,
    0x0001, 0xFFE8, 0x0006, 0x0000, 0xFFF0, 0x000A, 0x000A, 0x0008,
    0x0016, 0x000A, 0xFFE9, 0xFFF6, 0xFFFC, 0xFFDC, 0xFFEF, 0xFFF1,
    0xFFF5, 0x000E, 0xFFF7, 0xFFE4, 0x001A, 0x0000, 0xFFF0, 0x0003,
    0xFFE3, 0xFFFF, 0x000E, 0xFFF8, 0xFFFB, 0xFFFA, 0x0010, 0xFFEE,
    0xFFF5, 0x000C, 0x0021, 0xFFF7, 0x0007, 0x000C, 0x000D, 0x0005,
    0x0018, 0xFFF8, 0x001C, 0x000B, 0x0000, 0x0007, 0x001F, 0x000D,
    0xFFED, 0xFFDE, 0x0000, 0xFFDE, 0xFFEC, 0xFFEE, 0xFFF4, 0x0028,
    0x0008, 0xFFF3, 0x0001, 0x0009, 0x0004, 0xFFFA, 0x000A, 0x0014,
    0xFFFC, 0x000B, 0xFFF7, 0x000B, 0xFFFA, 0x0016, 0xFFF8, 0x0000,
    0xFFE7, 0x0008, 0x0012, 0xFFFD, 0x0004, 0xFFE0, 0x0015, 0x0001,
    0xFFEC, 0x0016, 0xFFFC, 0x0004, 0xFFFB, 0x0007, 0xFFF9, 0x0002,
    0x0009, 0x0004, 0x0001, 0x0009, 0xFFE6, 0xFFE4, 0xFFE1, 0xFFE3,
    0x0003, 0x0004, 0xFFFD, 0x0005, 0xFFFC, 0xFFFF, 0x0011, 0x0014,
    0xFFED, 0x0031, 0xFFFF, 0xFFFB, 0xFFDD, 0xFFE6, 0x0019, 0x0035,
    0x000C, 0xFFE5, 0xFFF5, 0xFFED, 0x0006, 0x000B, 0x0004, 0x000D,
    0x0004, 0x0004, 0x0003, 0x0025, 0xFFFE, 0xFFFD, 0xFFEB, 0xFFFB,
    0xFFE4, 0x0004, 0xFFEF, 0xFFF3, 0xFFFE, 0xFFF7, 0xFFEA, 0x0003,
    0x0018, 0x0014, 0x0004, 0x001B, 0x001A, 0x000A, 0x0005, 0x0003,
    0x0026, 0x0021, 0x0004, 0xFFF8, 0xFFF9, 0xFFFF, 0x000B, 0x0015,
    0xFFF7, 0x0000, 0x000A, 0x0002, 0x0027, 0x0028, 0xFFEA, 0xFFFB,
    0x0026, 0xFFF7, 0xFFF4, 0x0017, 0x0000, 0xFFEB, 0x001D, 0x0019,
    0xFFF6, 0xFFEC, 0xFFE4, 0xFFE7, 0xFFF3, 0xFFF4, 0x0001, 0x0003,
    0x0002, 0xFFF9, 0x0019, 0xFFF9, 0xFFEE, 0xFFD7, 0x000F, 0x0013,
    0x001C, 0x000E, 0xFFE8, 0x0009, 0xFFE2, 0xFFE9, 0xFFEA, 0xFFEB,
    0xFFF4, 0x0009, 0x0001, 0x0000, 0x0020, 0xFFE3, 0x0007, 0x0002,
    0x001C, 0xFFF3, 0xFFE2, 0x0004, 0x0019, 0x0012, 0xFFF1, 0x0010,
    0x000F, 0x000F, 0xFFFD, 0x000A, 0x0006, 0xFFF7, 0x0015, 0xFFEB,
    0xFFFD, 0xD332, 0x001B, 0xFFF0, 0x0014, 0x000C, 0xFFE9, 0xFFF7,
    0x0013, 0x0007, 0xFFEF, 0xFFF2, 0xFFDB, 0x001B, 0xFFEC, 0x001A,
    0xFFE8, 0x0019, 0x0000, 0x001D, 0xFFF4, 0x0010, 0x000D, 0xFFE1,
    0xFFDB, 0xFFED, 0xFFED, 0x0011, 0x000E, 0xFFFD, 0x0007, 0xFFFB,
    0x0003, 0xFFE0, 0xFFCC, 0x000E, 0xFFDA, 0xFFF5, 0x0004, 0x0013,
    0xFFF6, 0xFFFD, 0x001E, 0xFFF3, 0x000E, 0x0008, 0xFFFD, 0x0015,
    0x0005, 0xFFEF, 0x0017, 0x002D, 0xFFF3, 0x0014, 0xFFFD, 0xFFF8,
    0xFFF8, 0xFFEB, 0x0011, 0x0006, 0xFFEC, 0xFFF1, 0x0009, 0xFFE4,
    0x0005, 0x0008, 0xFFDC, 0xFFF4, 0x000D, 0xFFF9, 0x001E, 0xFFF0,
    0xFFF9, 0xFFFA, 0xFFFB, 0x000D, 0xFFF2, 0xFFDC, 0x000B, 0xFFEA,
    0xFFFC, 0x000F, 0xFFF2, 0xFFE5, 0x0000, 0xFFE4, 0x0008, 0xFFE7,
    0xFFF5, 0xFFF9, 0xFFF2, 0x0017, 0x000C, 0xFFF2, 0xFFFA, 0xFFF8,
    0x0001, 0x0012, 0xFFFD, 0xFFFA, 0xFFFE, 0x0006, 0x0009, 0x0006,
    0xFFE8, 0x0001, 0x0007, 0xFFF7, 0x0001, 0x0002, 0xFFFE, 0x0004,
    0xFFFB, 0x0003, 0x0011, 0x0004, 0x000B, 0x000E, 0x0001, 0xFFE3,
    0xFFF7, 0x000B, 0xFFFA, 0x0015, 0x0008, 0x0024, 0xFFE2, 0xFFEB,
    0x001D, 0x0000, 0xFFE2, 0x0003, 0x000B, 0xFFF0, 0x000A, 0x0013,
    0x0018, 0x0011, 0x0012, 0xFFF1, 0xFFF0, 0x0005, 0x0006, 0x0020,
    0xFFE9, 0xFFE2, 0xFFFC, 0x0000, 0x0017, 0x001A, 0xFFEF, 0xFFEB,
    0xFFF8, 0x0011, 0x0005, 0xFFFB, 0xFFF7, 0xFFF9, 0xFFEB, 0x0003,
    0x0009, 0x0016, 0xFFF7, 0xFFF9, 0xFFF8, 0x0030, 0x0024, 0x0017,
    0xFFF3, 0x0019, 0x0004, 0x0005, 0x0004, 0x0010, 0x0000, 0xFFF8,
    0xFFF8, 0x000F, 0x0001, 0xFFFB, 0xFFF5, 0xFFF0, 0x000C, 0xFFFA,
    0x000C, 0x0004, 0xFFD8, 0x0007, 0x0003, 0x0008, 0x0013, 0x0013,
    0x0018, 0x000C, 0x0028, 0x0007, 0xFFFF, 0xFFFA, 0x0021, 0xFFD5,
    0xFFE7, 0xFFF5, 0x0013, 0x0013, 0xFFE5, 0xFFFB, 0xFFE2, 0x0013,
    0x0004, 0x0002, 0xFFFC, 0xFFEC, 0xFFFE, 0x0004, 0x0023, 0xFFF0,
    0x0002, 0x0005, 0xFFEB, 0xFFED, 0x0000, 0x001D, 0xFFE0, 0x002B,
    0xFFE6, 0x000E, 0xFFF3, 0x0025, 0x0003, 0x000F, 0xFFF3, 0xFFF3,
    0x001C, 0xFFE8, 0x0017, 0xFFF8, 0x000F, 0x0017, 0xFFFF, 0x0025,
    0xFFEF, 0xFFFA, 0x0023, 0xFFEC, 0x0010, 0x0003, 0xFFFB, 0x000A,
    0x0009, 0xFFEE, 0x0008, 0x0017, 0x002C, 0x000B, 0xFFF4, 0xFFFA,
    0x0021, 0x0004, 0x000E, 0xFFF6, 0xFFFD, 0xFFF3, 0x0003, 0x0007,
    0xFFFD, 0xFFD9, 0xFFFA, 0x0005, 0xFFF2, 0xFFFF, 0x0017, 0x0007,
    0xFFF2, 0x0011, 0xFFE2, 0x0001, 0xFFF2, 0x0002, 0xFFFE, 0x0004,
    0xFFFC, 0xFFF2, 0x0004, 0xFFED, 0xFFFD, 0xFFF0, 0x0009, 0x0006,
    0x0018, 0xFFEB, 0xFFEE, 0xFFFE, 0xFFEF, 0x0001, 0xFFE1, 0xFFF8,
    0x0012, 0xFFF5, 0xFFDC, 0xFFFE, 0x0009, 0xFFFA, 0x001B, 0x0003,
    0xFFDB, 0x001D, 0x000D, 0xFFFF, 0x0012, 0xFFF3, 0x0013, 0x000E,
    0x0006, 0xFFFC, 0x0003, 0x002B, 0x0007, 0xFFF9, 0xFFE4, 0x0004,
    0x0013, 0x0004, 0xFFFF, 0xFFFA, 0xFFF9, 0x0013, 0x0002, 0xFFE6,
    0x000E, 0xFFDE, 0xFFF3, 0x0003, 0xFFFB, 0xFFE5, 0xFFEB, 0x0000,
    0x001B, 0xFFFF, 0x0017, 0x0016, 0x0014, 0xFFFE, 0xFFF4, 0x000C,
    0xFFE5, 0x0006, 0x0015, 0x000A, 0x0004, 0x000B, 0x0009, 0xFFDD,
    0x001F, 0xFFFF, 0x0005, 0xFFFC, 0xFFED, 0xFFE8, 0xFFE4, 0x000F,
    0x000D, 0x0000, 0x0007, 0x0009, 0x001A, 0xFFF8, 0xFFE7, 0x0015,
    0xFFF4, 0x0002, 0xFFFF, 0x0004, 0xFFF0, 0xFFF5, 0xFFF6, 0xFFD3,
    0x000D, 0xFFDB, 0x0007, 0xFFEB, 0xFFF1, 0x0016, 0xFFF8, 0xFFF0,
    0x000A, 0x000B, 0x0017, 0x0013, 0x0012, 0xFFF7, 0x0014, 0xFFFD,
    0xFFFF, 0xFFFF, 0x0009, 0xFFEC, 0xFFF6, 0x0011, 0x001E, 0xFFEF,
    0x0005, 0x0011, 0xFFF8, 0x0000, 0x0015, 0xFFF9, 0x000A, 0xFFF9,
    0xFFF5, 0x0002, 0x000D, 0x0015, 0xFFFF, 0xFFEB, 0x0015, 0x0006,
    0x0007, 0x000C, 0x0008, 0xFFF7, 0x0032, 0x000B, 0xFFEA, 0x0024,
    0xFFE9, 0x0002, 0x001F, 0x0001, 0x0008, 0xFFF8, 0x000D, 0x0005,
    0x0008, 0xFFF1, 0x0003, 0xFFF4, 0x000C, 0xFFFB, 0xFFFC, 0xFFEA,
    0x0007, 0x0017, 0xFFF7, 0x0009, 0x0025, 0xFFD9, 0xFFDD, 0x0002,
    0xFFFC, 0x0011, 0xFFFE, 0xFFED, 0xFFE7, 0xFFEB, 0x0024, 0xFFF6,
    0x0009, 0xFFFE, 0x0019, 0xFFE3, 0x0035, 0x0010, 0x000E, 0xFFFD,
    0xFFEA, 0xFFF3, 0x0016, 0xFFEC, 0x0013, 0x0016, 0x000D, 0x0003,
    0xFFE2, 0x0003, 0xFFE0, 0x0003, 0xFFF3, 0xFFF6, 0x000E, 0xFFEC,
    0x0008, 0xFFF5, 0x0001, 0x0012, 0xFFFF, 0xFFFF, 0xFFD3, 0xFFEE,
    0x0006, 0x0005, 0x0009, 0xFFFD, 0xFFDF, 0xFFE7, 0xFFF9, 0xFFF7,
    0xFFFF, 0x000D, 0x001E, 0xFFEC, 0xFFF4, 0x000C, 0x0009, 0x0000,
    0xFFF5, 0xFFFA, 0x0016, 0x0004, 0xFFEC, 0x0032, 0x000A, 0x0001,
    0xFFFD, 0x0002, 0x0002, 0xFFFB, 0xFFFE, 0x000D, 0xFFE6, 0xFFE7,
    0xFFF9, 0x000A, 0xFFF9, 0xFFF2, 0x000C, 0x000A, 0x0005, 0x0000,
    0x000C, 0x0004, 0x001A, 0xFFF6, 0x0011, 0xFFF2, 0xFFF8, 0x0001,
    0xFFEA, 0x0015, 0xFFF9, 0xFFE5, 0xFFFE, 0x0000, 0xFFF0, 0x0017,
    0xFFED, 0x000F, 0x0018, 0xFFFC, 0x000F, 0xFFE7, 0x0001, 0x000B,
    0x0017, 0x000B, 0x0008, 0x000E, 0x000B, 0xFFF9, 0x0022, 0x0019,
    0x0001, 0x0001, 0x0025, 0x0006, 0x0010, 0x000C, 0x0002, 0xFFF4,
    0xFFEC, 0x0007, 0xFFE9, 0xFFF6, 0xFFFD, 0xFFFD, 0xFFF7, 0xFFFE,
    0xFFF4, 0xFFEF, 0x000A, 0x0005, 0x0006, 0xFFF8, 0xFFF3, 0xFFEC,
    0xFFFE, 0xFFF3, 0x0009, 0x000B, 0x000B, 0x0006, 0xFFE5, 0xFFDD,
    0x001B, 0xFFFF, 0x0003, 0xFFF0, 0xFFE4, 0xFFFD, 0xFFEE, 0x0025,
    0xFFF1, 0xFFF8, 0xFFF7, 0x0004, 0x0004, 0xFFFB, 0xFFE9, 0x0038,
    0x000A, 0xFFE9, 0x0012, 0xFFFB, 0x001D, 0xFFDF, 0xFFF1, 0xFFF6,
    0xFFFA, 0x0011, 0x0014, 0xFFF9, 0x0029, 0xFFFF, 0xFFF3, 0xFFFE,
    0x0004, 0xFFFA, 0x0024, 0x0005, 0x0030, 0x0018, 0xFFF4, 0x0012,
    0xFFF3, 0x002C, 0xFFDF, 0xFFF9, 0x000D, 0x0008, 0xFFF5, 0x0007,
    0x0008, 0x0006, 0xFFFC, 0xFFF5, 0x0003, 0x0021, 0x0010, 0x001D,
    0xFFEA, 0xFFF3, 0xFFFC, 0x0025, 0xFFF5, 0xFFFB, 0xFFD8, 0xFFEF,
    0x001A, 0xFFF1, 0xFFDE, 0xFFF5, 0xFFE6, 0xFFF6, 0xFFF2, 0x0024,
    0xFFFA, 0xFFF5, 0x000C, 0x001F, 0xFFF7, 0x000C, 0xFFF9, 0xFFEC,
    0x0003, 0xFFFF, 0xFFFE, 0xFFFA, 0x001D, 0xFFF6, 0xFFEC, 0x000F,
    0x0012, 0xFFE5, 0xFFF1, 0x0014, 0xFFF5, 0xFFF1, 0x000F, 0x0001,
    0xFFEA, 0xFFDE, 0x0009, 0x0019, 0x0015, 0x0002, 0x000F, 0xFFFB,
    0xFFF4, 0xFFE6, 0x0011, 0x0007, 0x0013, 0xFFF5, 0x0014, 0xFFF2,
    0xFFE1, 0x0009, 0x0027, 0xFFDF, 0x0002, 0xFFFE, 0x000A, 0x0017,
    0x001E, 0xFFFC, 0xFFE2, 0xFFEA, 0xFFDF, 0x001B, 0xFFDD, 0xFFF0,
    0xFFF0, 0x0010, 0x0005, 0xFFFA, 0x0004, 0x000B, 0x0001, 0x0002,
    0xFFF7, 0xFFF5, 0xFFF0, 0xFFF3, 0xFFFB, 0xFFF5, 0x0018, 0xFFF2,
    0xFFF4, 0xFFF1, 0x0001, 0x0027, 0x0009, 0xFFFB, 0x0003, 0xFFFB,
    0xFFFE, 0xFFE1, 0xFFEC, 0xFFFC, 0xFFE7, 0x000D, 0x001A, 0x0036,
    0x0017, 0x0013, 0x0003, 0x000A, 0xFFFE, 0x001A, 0xFFFE, 0x0005,
    0x0001, 0xFFF9, 0xFFFD, 0xFFFF, 0xFFFA, 0xFFF9, 0x0018, 0xFFF5,
    0x0013, 0x0011, 0x000A, 0xFFFE, 0xFFFE, 0x0004, 0xFFED, 0x000B,
    0x0014, 0x0006, 0x000C, 0xFFFD, 0xFFF5, 0x0004, 0x0012, 0xFFEE,
    0xFFFE, 0x0005, 0xFFF3, 0x0005, 0x0001, 0x0008, 0x000A, 0xFFFE,
    0xFFEB, 0xFFF3, 0x000D, 0xFFEA, 0x001C, 0xFFF7, 0x0011, 0x001B,
    0xFFF8, 0xFFE9, 0xFFF7, 0x0012, 0x0021, 0xFFFB, 0xFFF7, 0x0008,
    0xFFED, 0x0009, 0xFFFC, 0xFFF1, 0x0009, 0xFFFC, 0xFFF0, 0xFFF6,
    0x0004, 0x0012, 0x0007, 0x000E, 0xFFF9, 0xFFFF, 0x0016, 0x0005,
    0xFFEA, 0xFFF7, 0xFFF9, 0xFFEF, 0xFFF5, 0x0016, 0xFFF1, 0xFFFE,
    0xFFFE, 0x0019, 0xFFFC, 0x0001, 0x000B, 0xFFFE, 0x0002, 0xFFEC,
    0xFFF9, 0x000C, 0x0005, 0x0002, 0x0026, 0x0009, 0x0014, 0x000E,
    0x0005, 0xFFFC, 0x0005, 0x000D, 0xFFEF, 0xFFE1, 0x0021, 0xFFF8,
    0xFFFF, 0xFFF9, 0xFFF6, 0xFFF6, 0xFFF8, 0xFFFB, 0x0009, 0xFFFC,
    0xFFF0, 0x0009, 0x0010, 0xFFFF, 0x0005, 0x0010, 0x0001, 0xFFF6,
    0x0023, 0x000F, 0xFFF5, 0x0007, 0x0009, 0xFFF6, 0xFFF4, 0xFFFA,
    0xFFF1, 0xFFE8, 0x0007, 0x0016, 0xFFE3, 0xFFF8, 0x0007, 0xFFFD,
    0x0014, 0x0001, 0x0006, 0x0000, 0xFFF9, 0xFFCE, 0xFFFB, 0x0002,
    0x000F, 0x001B, 0x0000, 0x0008, 0xFFFC, 0x0028, 0x0017, 0x0026,
    0xFFFE, 0x000D, 0xFFE8, 0xFFF4, 0xFFFE, 0xFFE4, 0x0017, 0xFFE1,
    0x000A, 0x000A, 0xFFE9, 0xFFF3, 0x0012, 0x0012, 0x0001, 0x000D,
    0xFFED, 0xFFF7, 0x0008, 0xFFEB, 0xFFF5, 0x0004, 0x000C, 0x000E,
    0x0003, 0xFFE5, 0x0006, 0xFFFB, 0xFFF5, 0x0015, 0x0016, 0x0006,
    0x000B, 0x001D, 0x0019, 0x001C, 0xFFFA, 0x0018, 0xFFE5, 0x0003,
    0xFFE6, 0x0006, 0xFFFA, 0xFFFF, 0xFFED, 0x000D, 0xFFF1, 0x0008,
    0xFFFD, 0x000C, 0x0008, 0x0017, 0x0007, 0x000C, 0xFFFF, 0xFFF6,
    0x000D, 0x0008, 0x000B, 0xFFFA, 0xFFF8, 0xFFF0, 0xFFF0, 0x001C,
    0x001F, 0xFFFD, 0x000D, 0x0007, 0xFFFC, 0x0003, 0x0031, 0xFFFB,
    0xFFFB, 0xFFFC, 0xFFEF, 0x0000, 0xFFEA, 0xFFF0, 0x0031, 0xFFF8,
    0x000A, 0x0024, 0x002B, 0x002C, 0xFFF8, 0x000F, 0xFFE7, 0xFFD9,
    0xFFE9, 0x0014, 0xFFFC, 0x0006, 0x0006, 0xFFFE, 0xFFF8, 0xFFEA,
    0xFFF5, 0xFFF3, 0xFFF8, 0xFFF6, 0xFFF8, 0x0006, 0xFFF0, 0xFFEA,
    0x0020, 0x0000, 0xFFF2, 0x0001, 0x0001, 0xFFFD, 0xFFEF, 0xFFFB,
    0x000F, 0xFFF1, 0xFFF0, 0xFFFB, 0xFFF1, 0xFFFD, 0xFFFF, 0xFFFC,
    0xFFF5, 0x0005, 0x0008, 0x0003, 0x0009, 0x0015, 0xFFF4, 0xFFDD,
    0x002B, 0xFFE5, 0xFFF6, 0x0001, 0x000D, 0xFFEE, 0x0012, 0x000B,
    0x0001, 0x0016, 0x0018, 0x0010, 0x0004, 0xFFFA, 0x000B, 0x000B,
    0xFFFB, 0x0005, 0x0002, 0x000B, 0xFFFD, 0x000C, 0x0003, 0xFFDA,
    0x0000, 0xFFFE, 0xFFF0, 0x0003, 0xFFFD, 0x0005, 0x0004, 0x001A,
    0x001A, 0x0018, 0xFFF9, 0x0014, 0xFFFD, 0xFFEE, 0x0023, 0xFFF7,
    0x0012, 0xFFEE, 0x0017, 0x0007, 0x0004, 0xFFFA, 0xFFFB, 0xFFFD,
    0x000C, 0x0002, 0x0010, 0x001D, 0x0012, 0x0000, 0xFFEF, 0x0009,
    0x0005, 0x0010, 0xFFD5, 0xFFEA, 0xFFEE, 0xFFFC, 0x0004, 0x0014,
    0x002C, 0x000B, 0xFFE3, 0x0023, 0x0019, 0xFFF1, 0x0000, 0xFFFC,
    0xFFE4, 0xFFF6, 0x0016, 0xFFE3, 0xFFFA, 0x0004, 0xFFE8, 0x000B,
    0x000C, 0xFFEE, 0xFFE1, 0xFFEC, 0xFFFB, 0x0002, 0xFFF3, 0x0007,
    0xFFDA, 0x0013, 0xFFDF, 0x0005, 0xFFF2, 0x000E, 0xFFF7, 0x0000,
    0x0011, 0x0027, 0xFFFD, 0xFFED, 0x0002, 0xFFF8, 0x0020, 0x0017,
    0xFFF3, 0x000A, 0xFFED, 0xFFF8, 0xFFFC, 0x0003, 0x0007, 0x0017,
    0x0005, 0xFFEC, 0xFFED, 0xFFFD, 0xFFD9, 0xFFFE, 0xFFFE, 0xFFFD,
    0x000E, 0x0025, 0x0013, 0xFFF0, 0xFFF9, 0x000C, 0x001D, 0x0003,
    0x0000, 0x0017, 0x0007, 0xFFE3, 0xFFF4, 0xFFEA, 0xFFEE, 0x0004,
    0xFFF4, 0x0001, 0x0016, 0xFFF4, 0x0019, 0x000C, 0xFFF8, 0x0008,
    0x0006, 0xFFFD, 0xFFCE, 0xFFF5, 0x0006, 0x0016, 0x0017, 0xFFFF,
    0xFFFE, 0x0027, 0xFFEA, 0x0007, 0x0024, 0x001F, 0xFFF8, 0x002F,
    0xFFFE, 0xFFFF, 0x0018, 0x000E, 0xFFFB, 0x0005, 0x000A, 0x0003,
    0x000D, 0x0015, 0x0024, 0xFFF1, 0x001C, 0x000C, 0xFFF2, 0xFFFF,
    0xFFFA, 0x0015, 0xFFFA, 0x0003, 0xFFEC, 0xFFD2, 0x0006, 0x0000,
    0x000C, 0x0014, 0xFFF8, 0xFFFF, 0xFFF7, 0x000B, 0xFFE5, 0xFFF3,
    0xFFFA, 0x0002, 0x001B, 0xFFE3, 0x0018, 0x0004, 0x000A, 0xFFDE,
    0xFFFC, 0x0014, 0xFFF8, 0xFFE9, 0x000F, 0xFFFC, 0x0028, 0xFFE1,
    0x000D, 0x0003, 0xFFD7, 0xFFFD, 0xFFF2, 0x0003, 0x0002, 0xFFEB,
    0xFFDB, 0xFFF6, 0xFFF2, 0x0009, 0xFFE4, 0x0005, 0xFFFE, 0x001D,
    0x000A, 0x0005, 0xFFF5, 0xFFF8, 0xFFE3, 0x0000, 0xFFE8, 0xFFF9,
    0x0022, 0x000D, 0xFFEA, 0xFFFA, 0xFFEA, 0x0006, 0x0014, 0x0019,
    0xFFF2, 0xFFFF, 0xFFFD, 0x0000, 0xFFE6, 0xFFF1, 0xFFF7, 0x001C,
    0xFFF7, 0x0007, 0x0004, 0xFFF2, 0xFFFF, 0xFFFE, 0xFFF6, 0x0012,
    0x0016, 0x0005, 0xFFF3, 0x0009, 0xFFF8, 0xFFEA, 0x0003, 0xFFF3,
    0x0005, 0xFFF1, 0x0020, 0xFFF1, 0xFFF0, 0xFFFE, 0x0007, 0xFFFC,
    0x0010, 0xFFF3, 0x000C, 0xFFF9, 0xFFF7, 0x0022, 0xFFFA, 0x001B,
    0xFFF8, 0x0003, 0x0006, 0x0015, 0xFFED, 0xFFFF, 0x0010, 0xFFE3,
    0x000D, 0xFFEB, 0x0002, 0xFFEF, 0x0003, 0x0010, 0x001A, 0x0000,
    0x001D, 0xFFF9, 0xFFFB, 0x0016, 0x000A, 0xFFFC, 0x0002, 0xFFF3,
    0x0001, 0x0006, 0x000E, 0x0006, 0xFFE6, 0x0006, 0xFFFE, 0x0004,
    0xFFF9, 0x0004, 0xFFE6, 0xFFEE, 0x0008, 0xFFF4, 0x0007, 0xFFFD,
    0x001B, 0xFFF5, 0x0002, 0x0001, 0x000A, 0xFFE6, 0x0015, 0xFFFB,
    0xFFF7, 0x0003, 0xFFFC, 0x0013, 0xFFFD, 0xFFF3, 0x0015, 0xFFF2,
    0xFFFA, 0x0014, 0xFFF8, 0x0013, 0x0007, 0xFFFA, 0x0011, 0xFFE8,
    0x0013, 0x0007, 0xFFF7, 0xFFFB, 0x000D, 0xFFFF, 0xFFEA, 0xFFED,
    0xFFFB, 0x0022, 0x000E, 0xFFEF, 0x0002, 0xFFFA, 0xFFF3, 0xFFEF,
    0xFFFA, 0x0004, 0xFFF8, 0xFFFB, 0x0014, 0xFFF8, 0xFFFC, 0x000C,
    0x0007, 0xFFFA, 0xFFFE, 0xFFEB, 0xFFF8, 0x0001, 0x0006, 0x001D,
    0x0013, 0xFFF3, 0xFFF3, 0xFFF7, 0xFFFD, 0x000C, 0xFFFA, 0x0017,
    0xFFDF, 0x0007, 0x001E, 0xFFFF, 0xFFF5, 0xFFFF, 0xFFF9, 0xFFFB,
    0xFFFF, 0xFFFB, 0xFFE3, 0xFFFD, 0x0023, 0xFFF3, 0xFFE4, 0x0015,
    0x0008, 0xFFFC, 0x0003, 0xFFFB, 0xFFF4, 0xFFF5, 0xFFD4, 0x0002,
    0x0009, 0xFFFC, 0xFFF4, 0xFFE1, 0x000F, 0x000F, 0xFFF3, 0x0007,
    0x0004, 0x0002, 0xFFFC, 0xFFFA, 0xFFF9, 0xFFED, 0xFFFE, 0x0006,
    0xFFFC, 0x0001, 0xFFEA, 0xFFDD, 0x0007, 0x000A, 0xFFF8, 0x000D,
    0x0001, 0xFFEF, 0xFFEF, 0xFFDA, 0xFFFC, 0xFFE8, 0x000E, 0xFFE3,
    0xFFF5, 0x0003, 0xFFFF, 0x001A, 0x001B, 0x0002, 0x0005, 0x000E,
    0xFFFA, 0x0010, 0xFFF6, 0xFFF7, 0xFFEF, 0x0008, 0xFFF2, 0x0001,
    0x0004, 0xFFFE, 0x0012, 0x0002, 0x000E, 0x0001, 0x0003, 0xFFFE,
    0x0025, 0x0005, 0x0011, 0x0002, 0x0015, 0x000A, 0x001E, 0xFFFB,
    0x0001, 0x0005, 0x0011, 0xFFE4, 0xFFFD, 0xFFEB, 0xFFE2, 0x000B,
    0x0001, 0xFFF6, 0xFFE9, 0x0003, 0x0006, 0x0004, 0x000D, 0x000C,
    0x0022, 0x0026, 0x0024, 0x0018, 0xFFFD, 0xFFF0, 0x0009, 0x000D,
    0xFFFF, 0x001D, 0xFFED, 0x0013, 0xFFF0, 0xFFF7, 0x0002, 0x0004,
    0xFFE6, 0x0007, 0x000B, 0x0019, 0xFFE0, 0xFFFB, 0xFFF6, 0x0004,
    0xFFF8, 0x001A, 0xFFFB, 0xFFF6, 0x0008, 0xFFF8, 0xFFFE, 0x0013,
    0xFFF4, 0x0011, 0xFFDE, 0x000B, 0xFFF7, 0x0014, 0xFFE3, 0x0000,
    0xFFE9, 0x0002, 0x0013, 0x0010, 0xFFF4, 0x002E, 0xFFFB, 0x000A,
    0x0019, 0x0001, 0x0005, 0xFFE9, 0xFFF0, 0xFFF1, 0xFFFB, 0xFFF6,
    0x0002, 0xFFE5, 0xFFCC, 0xFFF1, 0xFFEE, 0xFFF3, 0x000C, 0x000B,
    0xFFEC, 0x0007, 0xFFF8, 0xFFDF, 0xFFF5, 0xFFF2, 0xFFFB, 0xFFE6,
    0x0007, 0x0008, 0x000C, 0xFFE1, 0xFFEB, 0x001B, 0x0024, 0xFFDC,
    0x0003, 0x0008, 0x000B, 0x0017, 0xFFEF, 0x000E, 0x0014, 0x001F,
    0x0002, 0xFFED, 0xFFEE, 0xFFFD, 0x0008, 0x0014, 0xFFF7, 0x0019,
    0x001C, 0x0007, 0xFFFF, 0xFFF0, 0xFFFF, 0xFFEA, 0xFFE0, 0xFFFA,
    0xFFFF, 0x0004, 0xFFFD, 0x000A, 0x001F, 0x0009, 0x000F, 0xFFEE,
    0x001D, 0xFFFE, 0x0005, 0x0003, 0xFFF6, 0x0015, 0xFFF3, 0xFFF4,
    0x001D, 0xFFFF, 0x0008, 0x001E, 0x000B, 0x0006, 0x0001, 0x0005,
    0x0016, 0xFFFC, 0xFFF1, 0xFFE8, 0x0017, 0x000B, 0x0016, 0x000D,
    0xFFFF, 0x0022, 0x0003, 0x0000, 0x0004, 0xFFFD, 0xFFF3, 0x0016,
    0xFFE4, 0x000F, 0xFFEB, 0xFFDE, 0x0012, 0x0023, 0xFFEB, 0xFFF5,
    0xFFE7, 0xFFED, 0xFFFB, 0xFFE9, 0x001C, 0xFFEC, 0xFFED, 0xFFD5,
    0x0006, 0x000A, 0xFFFA, 0xFFE5, 0xFFFA, 0xFFFA, 0xFFFF, 0x0003,
    0xFFFF, 0xFFF7, 0xFFFD, 0xFFEC, 0x0006, 0x0003, 0x0009, 0xFFFD,
    0x0026, 0xFFEC, 0xFFE0, 0xFFE4, 0xFFE5, 0x0023, 0xFFFB, 0x0015,
    0xFFD7, 0x000A, 0x0007, 0x0018, 0xFFFC, 0x0013, 0xFFEE, 0x0011,
    0xFFF7, 0xFFF4, 0x001C, 0x000C, 0x0013, 0x001A, 0xFFF3, 0x0003,
    0x000D, 0x0010, 0x0005, 0xFFEE, 0x0017, 0xFFFE, 0xFFF9, 0x0003,
    0x0011, 0x0001, 0x000E, 0x0009, 0x000F, 0x0009, 0xFFF8, 0xFFEF,
    0x0007, 0xFFEC, 0x0005, 0xFFEE, 0xFFD3, 0x000B, 0xFFFC, 0x0006,
    0xFFFB, 0x000B, 0x0018, 0xFFF0, 0xFFF2, 0x0014, 0xFFD8, 0x0004,
    0x000D, 0x002E, 0xFFEA, 0xFFE2, 0xFFF5, 0xFFF6, 0x0011, 0x000E,
    0xFFE8, 0x0000, 0xFFE8, 0x0012, 0x0018, 0xFFF8, 0x0010, 0x0003,
    0xFFFF, 0xFFFB, 0x000F, 0x000C, 0x000D, 0x000E, 0xFFF4, 0x000E,
    0xFFFF, 0x0003, 0xFFF7, 0x0015, 0xFFFE, 0xFFF8, 0xFFEB, 0xFFF7,
    0x0010, 0x000C, 0xFFF8, 0xFFFF, 0x0004, 0xFFE8, 0x0016, 0xFFF0,
    0xFFEB, 0x0010, 0xFFF9, 0x000F, 0x0001, 0x0006, 0x0003, 0xFFC8,
    0x0000, 0x0015, 0x0006, 0xFFF7, 0x0002, 0xFFEA, 0x0008, 0x000A,
    0xFFFA, 0xFFFD, 0x0009, 0x000C, 0xFFE1, 0x0001, 0xFFF7, 0x0001,
    0xFFDC, 0x000E, 0x001A, 0xFFF7, 0x0010, 0x000C, 0xFFDD, 0x0007,
    0x0009, 0x0005, 0xFFF8, 0x0011, 0x000E, 0x0007, 0xFFE6, 0x001C,
    0xFFE2, 0x001B, 0x0001, 0x0011, 0x0013, 0x0022, 0x0008, 0xFFED,
    0x0009, 0x0009, 0xFFFD, 0xFFFA, 0x0006, 0x001E, 0xFFFE, 0x0007,
    0x0000, 0xFFFA, 0x0021, 0x0019, 0x0005, 0xFFE9, 0xFFF2, 0xFFFE,
    0x0000, 0xFFEF, 0x0017, 0x0010, 0x003C, 0x000A, 0xFFDD, 0x0000,
    0x000F, 0x0019, 0xFFF9, 0x0001, 0x0012, 0x0013, 0x0016, 0x0001,
    0xFFDF, 0xFFE0, 0xFFDD, 0x000E, 0x001D, 0x0002, 0x000C, 0xFFF6,
    0x0010, 0xFFEF, 0x0013, 0xFFFE, 0x001C, 0xFFF2, 0x0007, 0xFFF4,
    0x000F, 0x0008, 0x001D, 0xFFF7, 0x0028, 0xFFF2, 0x0017, 0x0002,
    0xFFE4, 0x0006, 0x0008, 0xFFFF, 0xFFE7, 0x0000, 0xFFFE, 0xFFF5,
    0x0006, 0xFFFF, 0x001B, 0x000C, 0x000B, 0xFFFF, 0x000A, 0x000A,
    0xFFF1, 0xFFEA, 0x000E, 0x0012, 0xFFEE, 0x0012, 0xFFEF, 0xFFFE,
    0xFFE7, 0x0006, 0x0004, 0x0004, 0x0005, 0x0015, 0xFFF8, 0xFFFF,
    0xFFE2, 0xFFF7, 0xFFEA, 0xFFF3, 0x001D, 0xFFFB, 0x0011, 0xFFEC,
    0x0004, 0x000D, 0xFFFB, 0xFFEF, 0x001A, 0x0013, 0xFFFF, 0xFFF3,
    0x0008, 0x000B, 0xFFFB, 0x0000, 0x0009, 0xFFFC, 0xFFEE, 0x000A,
    0xFFF0, 0xFFF1, 0x0014, 0x0002, 0x0001, 0xFFD4, 0xFFFE, 0x002E,
    0x0011, 0x0004, 0x000D, 0x001B, 0x001A, 0x0008, 0x0001, 0xFFFF,
    0x0002, 0x0000, 0xFFFE, 0x001B, 0x0011, 0x0017, 0x000F, 0x0004,
    0xFFFE, 0x0009, 0xFFF8, 0xFFE9, 0x0001, 0x0011, 0x000D, 0x0009,
    0xFFFF, 0xFFF9, 0xFFF8, 0x0016, 0xFFDE, 0x000F, 0xFFF2, 0xFFF2,
    0xFFEA, 0xFFF4, 0xFFF8, 0xFFE3, 0xFFFD, 0xFFF5, 0xFFEC, 0xFFE9,
    0x000F, 0xFFFC, 0xFFF4, 0xFFEE, 0xFFE2, 0x0001, 0x0013, 0x0000,
    0x0014, 0xFFF8, 0x0004, 0xFFFB, 0xFFF5, 0xFFEA, 0x0013, 0xFFFF,
    0xFFFF, 0xFFE5, 0x0006, 0x0000, 0x000A, 0xFFF1, 0x0020, 0xFFE5,
    0x000F, 0xFFEF, 0xFFE6, 0xFFF5, 0xFFF8, 0xFFF7, 0x0019, 0xFFEE,
    0x0014, 0xFFF5, 0xFFEA, 0x0004, 0xFFFD, 0x0007, 0xFFF1, 0x0026,
    0xFFFD, 0xFFF8, 0x002B, 0x0006, 0x0016, 0x0024, 0x0014, 0xFFE1,
    0xFFEF, 0x0000, 0xFFE5, 0xFFDF, 0xFFF5, 0x0028, 0x0027, 0x000B,
    0xFFE4, 0x0005, 0xFFDC, 0xFFEF, 0xFFE5, 0xFFFB, 0x000A, 0xFFF8,
    0x0003, 0x001F, 0xFFFB, 0x0004, 0x0002, 0xFFF3, 0x001E, 0x000C,
    0x0003, 0xFFF0, 0xFFFF, 0xFFF7, 0xFFE7, 0x000A, 0x0000, 0xFFFE,
    0xFFEF, 0xFFE8, 0x001A, 0xFFF3, 0x000D, 0x001D, 0xFFF9, 0xFFF2,
    0x000D, 0x0002, 0xFFF4, 0x0022, 0xFFE8, 0x0001, 0xFFF9, 0xFFFD,
    0x0009, 0x0000, 0x0001, 0x000B, 0x0009, 0xFFF8, 0x0005, 0xFFEC,
    0x000A, 0xFFF7, 0xFFF6, 0xFFFB, 0xFFED, 0x0003, 0x001B, 0xFFFA,
    0xFFF2, 0xFFE8, 0xFFEC, 0xFFFC, 0xFFFB, 0x0024, 0xFFEC, 0xFFE3,
    0xFFFE, 0x001B, 0x001A, 0xFFE3, 0xFFEE, 0xFFF6, 0x0010, 0x000E,
    0xFFF9, 0xFFEF, 0x0010, 0x000F, 0x000C, 0x0015, 0xFFEC, 0x000C,
    0xFFEC, 0xFFFD, 0xFFE6, 0x0024, 0xFFF3, 0xFFFD, 0x000B, 0x0002,
    0x0004, 0xFFF5, 0x0014, 0x0006, 0x000B, 0x0020, 0xFFEC, 0xFFFD,
    0x0015, 0xFFEF, 0x0023, 0x000F, 0xFFF7, 0xFFEC, 0x000E, 0x0000,
    0xFFF0, 0x0011, 0xFFF2, 0x0007, 0x0020, 0xFFFE, 0x0002, 0x0020,
    0x0013, 0x0010, 0xFFF8, 0xFFFD, 0x001B, 0x0003, 0x0001, 0xFFDE,
    0x000F, 0xFFF4, 0x0006, 0x0011, 0x000D, 0x000B, 0x000B, 0x0021,
    0x0004, 0xFFF5, 0x0011, 0x0014, 0xFFFE, 0x0018, 0x002D, 0x0007,
    0xFFE5, 0xFFE5, 0xFFFD, 0xFFE7, 0x0005, 0x0012, 0x0014, 0xFFF9,
    0x0000, 0xFFE7, 0xFFF3, 0xFFF9, 0xFFC5, 0xFFF5, 0x0018, 0xFFEB,
    0x0020, 0xFFFA, 0x0003, 0x0004, 0xFFF1, 0x000A, 0xFFFD, 0xFFDB,
    0x0017, 0xFFF4, 0xFFF6, 0x0007, 0x0011, 0x0003, 0xFFF6, 0xFFFE,
    0x0009, 0x0012, 0x0022, 0x0011, 0xFFEE, 0x0010, 0x0014, 0xFFE6,
    0x000A, 0xFFED, 0x0008, 0xFFF9, 0x0019, 0x0028, 0x0005, 0xFFFF,
    0x0009, 0x000D, 0xFFF7, 0x000A, 0xFFE5, 0x0007, 0xFFF3, 0x0002,
    0xFFFA, 0x0015, 0x000C, 0xFFF7, 0x0004, 0xFFF2, 0x000B, 0xFFE4,
    0xFFF7, 0xFFFB, 0x0003, 0xFFF7, 0xFFE5, 0xFFE6, 0x000C, 0xFFED,
    0x000A, 0xFFE5, 0x000E, 0xFFFE, 0xFFFC, 0x0003, 0x0024, 0x0013,
    0xFFE5, 0xFFE8, 0x0010, 0xFFF9, 0xFFFE, 0x0020, 0xFFF5, 0xFFFC,
    0x001B, 0x000A, 0x0004, 0xFFFB, 0x001A, 0xFFF5, 0x001B, 0xFFEF,
    0xFFE1, 0x000C, 0xFFF5, 0xFFD9, 0xFFF5, 0x0015, 0xFFFF, 0x0013,
    0x0003, 0x0003, 0x0011, 0xFFEB, 0x0012, 0x000E, 0x0028, 0xFFF4,
    0xFFFD, 0xFFDE, 0x0006, 0xFFF7, 0x0001, 0xFFF7, 0xFFF1, 0xFFFF,
    0x0014, 0xFFF1, 0x000E, 0x0008, 0x0004, 0x001A, 0xFFFB, 0x0007,
    0x0011, 0xFFF9, 0x001D, 0xFFFF, 0x0004, 0xFFFF, 0x0001, 0x0020,
    0x0000, 0xFFF2, 0xFFFE, 0x0008, 0xFFDA, 0x0016, 0x000A, 0xFFE9,
    0x0016, 0xFFFF, 0x0012, 0x0003, 0x0011, 0x0000, 0x000C, 0xFFFC,
    0x0015, 0xFFEE, 0x0000, 0xFFF8, 0x001A, 0x0028, 0xFFFE, 0x001B,
    0x000A, 0x0000, 0xFFE0, 0x0014, 0x0018, 0x0000, 0xFFFD, 0xFFFB,
    0x0011, 0xFFF1, 0x0000, 0xFFE9, 0xFFED, 0xFFEA, 0xFFF5, 0xFFF8,
    0x0002, 0xFFE7, 0x000A, 0xFFEE, 0xFFF7, 0xFFF6, 0xFFF4, 0xFFDD,
    0x0023, 0xFFFA, 0x0020, 0x0020, 0xFFEC, 0xFFF0, 0xFFFB, 0xFFFC,
    0x000D, 0x000D, 0x0012, 0xFFF4, 0xFFF3, 0x000B, 0xFFFD, 0x0022,
    0x000F, 0x000A, 0xFFE7, 0xFFF4, 0x000E, 0xFFF0, 0x0018, 0x0023,
    0xFFEF, 0xFFEE, 0xFFF6, 0xFFFD, 0xFFEF, 0x0014, 0x0026, 0xFFFB,
    0x000A, 0x0004, 0xFFFC, 0x0012, 0x0008, 0x003F, 0xFFF6, 0x000C,
    0x0008, 0xFFF4, 0xFFEF, 0xFFFB, 0xFFF2, 0xFFFA, 0x001B, 0x0001,
    0xFFF6, 0x0017, 0x0003, 0x0024, 0xFFE7, 0x001B, 0xFFEF, 0x0007,
    0x001C, 0xFFF9, 0xFFFC, 0xFFD1, 0xFFEB, 0xFFFC, 0xFFE2, 0x0011,
    0xFFEB, 0x0003, 0xFFE2, 0xFFFE, 0xFFF9, 0xFFE8, 0xFFFA, 0x0019,
    0x000E, 0xFFFA, 0xFFF4, 0x000E, 0xFFF1, 0xFFFF, 0x0002, 0xFFE5,
    0x0005, 0x000F, 0xFFF0, 0xFFFD, 0x000C, 0xFFF5, 0xFFEF, 0x0002,
    0xFFF2, 0xFFF8, 0x0001, 0x0026, 0xFFEA, 0xFFF7, 0xFFEE, 0xFFFF,
    0x001B, 0x0004, 0xFFE0, 0x0000, 0xFFF1, 0x0006, 0xFFEC, 0xFFF6,
    0x0019, 0xFFFC, 0x0008, 0xFFF2, 0x0025, 0xFFF0, 0x000B, 0x0018,
    0x0025, 0xFFF2, 0xFFE3, 0x0019, 0x000E, 0xFFF9, 0x000A, 0x000F,
    0x0006, 0x001A, 0x0010, 0xFFF3, 0xFFEE, 0x0015, 0x0009, 0xFFF5,
    0x0008, 0x0001, 0xFFFF, 0xFFFC, 0xFFFE, 0x000A, 0x001C, 0xFFF7,
    0xFFEF, 0x0013, 0xFFDC, 0xFFF7, 0x0030, 0xFFFE, 0xFFE4, 0x002D,
    0xFFDA, 0xFFFA, 0xFFE0, 0xFFFC, 0xFFEF, 0xFFFC, 0x000E, 0x0002,
    0xFFF6, 0xFFE7, 0x000C, 0x001B, 0xFFF0, 0x0002, 0x0007, 0xFFF4,
    0x0005, 0xFFDE, 0x0018, 0xFFF7, 0xFFEE, 0xFFF9, 0xFFE9, 0xFFF1,
    0xFFE8, 0x0002, 0x0011, 0xFFF8, 0x000B, 0x000D, 0xFFEC, 0xFFF9,
    0xFFF3, 0xFFFD, 0x0014, 0x0015, 0x0001, 0xFFCA, 0xFFFD, 0x0016,
    0x000A, 0x0018, 0x0018, 0xFFE8, 0xFFE5, 0x0009, 0x0010, 0x001E,
    0x000B, 0x002D, 0x0000, 0x0029, 0xFFEF, 0x0007, 0x0024, 0xFFF5,
    0x000F, 0x0004, 0x0000, 0x0001, 0x000C, 0x0021, 0xFFF2, 0xFFE5,
    0xFFF7, 0x0010, 0x0001, 0x0007, 0x001D, 0x000A, 0xFFFF, 0xFFE7,
    0x0008, 0xFFF8, 0x0016, 0xFFF5, 0x0001, 0x001B, 0x0000, 0x000F,
    0x0005, 0xFFF9, 0xFFFA, 0xFFEF, 0xFFF7, 0x0014, 0xFFF8, 0xFFCA,
    0x0009, 0x0017, 0xFFF3, 0x0003, 0xFFF5, 0x0002, 0x000E, 0xFFF2,
    0x0010, 0x000C, 0x0007, 0x0002, 0xFFF2, 0x0003, 0xFFF0, 0xFFF5,
    0xFFFF, 0xFFF8, 0xFFF3, 0xFFFD, 0x0006, 0x0010, 0xFFF1, 0x000C,
    0x001C, 0xFFEF, 0xFFF4, 0xFFEF, 0x0009, 0x0008, 0x000C, 0xFFFF,
    0x0005, 0xFFF7, 0x001D, 0xFFF0, 0xFFF0, 0x0014, 0x0022, 0x0025,
    0xFFF0, 0xFFF2, 0xFFED, 0xFFFE, 0xFFFD, 0x0000, 0x0001, 0xFFF7,
    0xFFEC, 0x0005, 0x0009, 0xFFF3, 0x0001, 0xFFF9, 0xFFF6, 0xFFDE,
    0x0005, 0x000C, 0x0001, 0x0018, 0xFFEF, 0x0017, 0xFFFE, 0x0003,
    0xFFFC, 0xFFF6, 0xFFFF, 0x000D, 0x002F, 0xFFFA, 0x0027, 0x001F,
    0x0007, 0xFFF4, 0x0011, 0xFFF7, 0xFFEF, 0x0016, 0x0003, 0xFFF7,
    0x0011, 0x0011, 0x0007, 0xFFC6, 0x001E, 0xFFF8, 0xFFFB, 0x0007,
    0xFFF2, 0x000F, 0x0007, 0xFFFB, 0x0015, 0xFFF6, 0xFFF9, 0xFFE9,
    0xFFF0, 0x0010, 0xFFF3, 0xFFFB, 0x0015, 0xFFE6, 0xFFFC, 0xFFF3,
    0x0009, 0xFFE8, 0x0009, 0xFFD7, 0x0004, 0xFFD4, 0xFFFD, 0xFFFD,
    0x0009, 0x0004, 0x0005, 0xFFEE, 0x000B, 0x0010, 0x0026, 0xFFF1,
    0xFFDC, 0xFFFF, 0x0006, 0xFFED, 0x000F, 0xFFFB, 0xFFF6, 0x000D,
    0xFFFC, 0xFFFE, 0x000C, 0x000A, 0x000A, 0x002B, 0x0002, 0xFFEA,
    0x0006, 0xFFFC, 0x0002, 0x0005, 0x0003, 0x0001, 0xFFFF, 0xFFFF,
    0x0004, 0xFFF2, 0x0008, 0x002B, 0xFFD8, 0xFFF5, 0xFFF3, 0xFFF3,
    0x0007, 0x0020, 0x0014, 0xFFEF, 0xFFF2, 0xFFFC, 0x002C, 0xFFFB,
    0xFFD9, 0xFFF6, 0x000C, 0xFFE9, 0x0023, 0xFFF4, 0xFFFE, 0xFFFA,
    0xFFE1, 0x0014, 0xFFF4, 0x002A, 0x0012, 0x0007, 0xFFF2, 0x0004,
    0x0000, 0xFFE5, 0x002C, 0xFFF5, 0x0018, 0x0019, 0xFFE5, 0x0015,
    0xFFEF, 0x000B, 0x0012, 0x0014, 0xFFEF, 0x001D, 0xFFFF, 0xFFF6,
    0xFFFE, 0xFFF3, 0xFFFD, 0xFFEF, 0xFFFF, 0xFFFC, 0x0004, 0xFFE6,
    0x000E, 0xFFF9, 0x0000, 0xFFFC, 0x000F, 0xFFDD, 0x0010, 0x0014,
    0x0015, 0xFFEC, 0xFFF8, 0x0007, 0xFFF6, 0xFFF1, 0xFFF5, 0xFFE6,
    0xFFDE, 0xFFE0, 0xFFEA, 0xFFFC, 0x0004, 0x0000, 0xFFE7, 0xFFE2,
    0x0011, 0xFFEB, 0xFFE6, 0x0027, 0x0028, 0x0003, 0xFFF6, 0x0007,
    0x0016, 0xFFF6, 0x0006, 0x000C, 0xFFF4, 0x001D, 0x0005, 0xFFDE,
    0xFFE8, 0x0024, 0xFFFA, 0xFFF9, 0xFFFB, 0xFFF3, 0xFFEA, 0xFFF9,
    0x001B, 0xFFE2, 0xFFE2, 0x0004, 0x0013, 0x0017, 0xFFEF, 0x0010,
    0xFFFB, 0x000F, 0xFFDD, 0xFFFB, 0x0000, 0xFFF2, 0x001B, 0xFFFB,
    0x0016, 0x0012, 0x0010, 0x0015, 0x0012, 0x0000, 0x001F, 0xFFF7,
    0x0000, 0x0011, 0xFFF2, 0xFFEB, 0xFFF6, 0xFFF6, 0xFFFB, 0xFFFC,
    0xFFDF, 0x000A, 0x0003, 0x0018, 0xFFE9, 0x000C, 0x000A, 0xFFE7,
    0xFFF7, 0xFFF4, 0x000C, 0x0007, 0xFFEF, 0x0015, 0x0012, 0x000E,
    0xFFF9, 0xFFEF, 0xFFF3, 0x0014, 0xFFF9, 0xFFF6, 0xFFED, 0x0006,
    0xFFEE, 0xFFF9, 0xFFFF, 0x0003, 0xFFF7, 0xFFF4, 0xFFE6, 0x0007,
    0x0006, 0xFFF4, 0x0005, 0x0014, 0xFFED, 0xFFF8, 0xFFE6, 0xFFF5,
    0x000A, 0xFFF1, 0xFFEC, 0x0001, 0xFFFA, 0x0005, 0xFFF6, 0xFFF3,
    0x0010, 0xFFF1, 0x0002, 0xFFF5, 0xFFF3, 0x000F, 0xFFED, 0x0009,
    0xFFE8, 0xFFFD, 0xFFE9, 0x0003, 0xFFF4, 0xFFE1, 0xFFDE, 0x0011,
    0xFFEC, 0x0003, 0x0014, 0x0014, 0x0003, 0x0015, 0xFFFD, 0xFFFE,
    0xFFDF, 0xFFDD, 0x0011, 0x000F, 0x0007, 0x0012, 0xFFE8, 0x0006,
    0xFFF5, 0xFFFB, 0x0000, 0xFFEC, 0xFFF5, 0xFFE5, 0xFFFF, 0x0005,
    0x0004, 0x001F, 0x0011, 0x0022, 0x0010, 0x0001, 0xFFFC, 0xFFFE,
    0xFFEA, 0x000A, 0xFFE6, 0x0011, 0xFFF2, 0xFFEE, 0x0000, 0xFFEC,
    0x0006, 0x002D, 0xFFF4, 0xFFF0, 0xFFFD, 0xFFE1, 0x0003, 0xFFFD,
    0x000D, 0xFFF5, 0xFFEA, 0x0006, 0x0000, 0x0029, 0x0000, 0x0008,
    0xFFF4, 0xFFF2, 0xFFFE, 0x000E, 0xFFED, 0xFFE9, 0xFFF3, 0xFFF1,
    0x0006, 0xFFE9, 0x0001, 0xFFFF, 0x0004, 0x0009, 0xFFFF, 0x0009,
    0x0009, 0x0025, 0xFFF9, 0xFFF3, 0x000A, 0xFFF1, 0x000D, 0x0014,
    0x0017, 0xFFFE, 0x0008, 0x000D, 0x001F, 0xFFF5, 0x0005, 0x000B,
    0x0001, 0x0003, 0xFFFC, 0x0009, 0x0003, 0xFFE4, 0xFFEB, 0x000C,
    0x0024, 0x0002, 0x0005, 0x000D, 0x0019, 0x0012, 0x0018, 0xFFE2,
    0x0018, 0x001D, 0xFFF9, 0xFFFD, 0x0009, 0x0012, 0xFFE4, 0xFFFC,
    0xFFFE, 0xFFF7, 0xFFEB, 0xFFFA, 0xFFFA, 0xFFED, 0x0000, 0xFFF4,
    0xFFFE, 0x0000, 0x0000, 0x000C, 0xFFFA, 0x0013, 0xFFEB, 0x0006,
    0xFFFE, 0x0009, 0xFFE4, 0x0004, 0x0009, 0xFFEE, 0xFFF9, 0x0003,
    0x0018, 0xFFE3, 0x0018, 0x001E, 0x0019, 0xFFEE, 0x0005, 0xFFF3,
    0x0024, 0xFFFE, 0xFFEB, 0xFFF4, 0x0003, 0x001C, 0xFFFC, 0xFFF7,
    0x0001, 0xFFFD, 0x0005, 0xFFF5, 0x001F, 0x000B, 0x0008, 0xFFF3,
    0x0017, 0x0002, 0x000D, 0xFFEC, 0x000A, 0x000F, 0xFFF9, 0x000D,
    0x0009, 0xFFDB, 0xFFFF, 0xFFF7, 0x0004, 0xFFF7, 0x0001, 0x0001,
    0x0006, 0x0017, 0xFFF3, 0x000F, 0xFFED, 0x0017, 0xFFFE, 0xFFF2,
    0xFFF4, 0x000E, 0x0000, 0xFFF8, 0x0000, 0xFFD7, 0xFFEA, 0xFFFA,
    0x000D, 0x000B, 0x0003, 0x0003, 0xFFFD, 0x001F, 0xFFF4, 0x0010,
    0x0006, 0xFFD3, 0x0000, 0x0014, 0xFFF2, 0x0012, 0xFFE6, 0xFFEF,
    0xFFEA, 0xFFF6, 0xFFFC, 0x0002, 0x0010, 0xFFFF, 0x0011, 0xFFDE,
    0x0004, 0xFFE1, 0xFFFF, 0xFFFB, 0xFFF5, 0x001B, 0x0000, 0x0014,
    0xFFF5, 0x0005, 0xFFE8, 0xFFFA, 0x0007, 0xFFEE, 0x0011, 0xFFF1,
    0xFFDF, 0x0023, 0xFFFD, 0x0002, 0x0003, 0xFFEB, 0x0014, 0xFFEC,
    0xFFEC, 0xFFFD, 0xFFDE, 0xFFEF, 0xFFF4, 0x001F, 0xFFE9, 0xFFFD,
    0xFFE8, 0x0003, 0xFFED, 0xFFF7, 0xFFF3, 0xFFF1, 0x0002, 0x000B,
    0x0010, 0x000F, 0xFFF6, 0x000D, 0xFFFA, 0xFFFB, 0xFFEC, 0xFFFF,
    0x000A, 0x000F, 0xFFE6, 0x000B, 0xFFED, 0x0008, 0x0005, 0xFFEC,
    0x0006, 0x000C, 0xFFE6, 0xFFF9, 0xFFF7, 0x000C, 0xFFFF, 0xFFFD,
    0xFFEE, 0x0007, 0xFFED, 0xFFFA, 0xFFF9, 0x000A, 0xFFF3, 0xFFEC,
    0xFFF9, 0x0011, 0x0012, 0xFFF2, 0xFFEF, 0xFFEB, 0x000C, 0xFFF9,
    0xFFF7, 0x000C, 0x000A, 0x0019, 0xFFE9, 0xFFF4, 0x0003, 0xFFE8,
    0xFFDF, 0xFFF6, 0xFFFB, 0x0004, 0xFFF6, 0x000A, 0xFFF2, 0x0015,
    0x0000, 0xFFEF, 0x001F, 0x0009, 0x0012, 0x0000, 0x0010, 0xFFEB,
    0x0016, 0xFFEE, 0x001B, 0x0005, 0x0000, 0x000E, 0xFFDD, 0x0005,
    0xFFFB, 0xFFF1, 0xFFEF, 0xFFF0, 0x0013, 0xFFE9, 0xFFE2, 0xFFFC,
    0x001B, 0x001E, 0xFFEA, 0x0007, 0xFFFB, 0x000D, 0xFFFA, 0x0007,
    0xFFE8, 0xFFDC, 0x0005, 0x0022, 0xFFF4, 0xFFE3, 0x0006, 0xFFF4,
    0x0016, 0x000A, 0xFFF6, 0xFFF9, 0x0028, 0xFFFD, 0xFFE6, 0xFFD9,
    0x0011, 0x0015, 0xFFE7, 0x001E, 0x0004, 0x0000, 0xFFEA, 0x0004,
    0xFFDE, 0x0020, 0xFFF5, 0x001A, 0xFFF6, 0x000F, 0xFFF8, 0xFFF9,
    0x0015, 0x0014, 0x0010, 0xFFEC, 0x000F, 0x0023, 0x0000, 0x0004,
    0x000E, 0x0007, 0x0004, 0x001A, 0xFFFF, 0x0004, 0xFFFD, 0x0011,
    0xFFFE, 0x000D, 0xFFFF, 0x000A, 0xFFEF, 0xFFE3, 0x0012, 0xFFEC,
    0xFFEF, 0xFFF5, 0xFFE5, 0xFFEB, 0x0018, 0xFFE7, 0x002C, 0x000B,
    0x0000, 0x001B, 0xFFF2, 0xFFFC, 0x0012, 0xFFF9, 0xFFF4, 0xFFD6,
    0xFFE1, 0xFFEC, 0xFFFE, 0x0006, 0x0023, 0x000C, 0x000C, 0x0017,
    0xFFD9, 0x000A, 0x002C, 0x0005, 0xFFF2, 0x0004, 0x0014, 0x0011,
    0x0007, 0xFFE0, 0xFFF3, 0x000D, 0xFFD8, 0x000B, 0x0008, 0xFFD5,
    0x0004, 0x000E, 0xFFFF, 0x0001, 0x0003, 0xFFFF, 0x0002, 0xFFFB,
    0x0006, 0x0004, 0x0002, 0x0016, 0x000A, 0xFFD5, 0x000C, 0xFFF6,
    0xFFFC, 0x0002, 0xFFF6, 0xFFF3, 0x000F, 0x0005, 0x0006, 0x0013,
    0xFFDC, 0x0001, 0x0026, 0x000F, 0x000B, 0xFFF0, 0x0005, 0x0012,
    0x0009, 0xFFFC, 0xFFFD, 0x0003, 0x0004, 0x002C, 0x0009, 0x0029,
    0x0009, 0x0018, 0xFFFC, 0x000D, 0x0015, 0x001A, 0xFFF3, 0x0005,
    0xFFF0, 0xFFF0, 0xFFF9, 0x0017, 0x0015, 0x000A, 0x0007, 0x0005,
    0xFFF2, 0xFFF1, 0xFFFB, 0xFFF9, 0x001E, 0x0008, 0x0007, 0x003A,
    0x0011, 0xFFEF, 0x0003, 0x0009, 0xFFEF, 0xFFEA, 0x0011, 0x0009,
    0x0007, 0x000C, 0x0027, 0xFFE1, 0x002F, 0x0006, 0xFFFF, 0xFFF3,
    0xFFFC, 0x000A, 0xFFFE, 0xFFFD, 0xFFEF, 0xFFE9, 0x0001, 0xFFE8,
    0x0005, 0xFFF4, 0xFFF6, 0x0022, 0x0001, 0x0007, 0x0009, 0x000D,
    0xFFEC, 0xFFFB, 0x0001, 0x0009, 0xFFFD, 0x0000, 0xFFED, 0x0002,
    0xFFF0, 0x000E, 0x0022, 0xFFDB, 0xFFF0, 0xFFEC, 0x001D, 0x0010,
    0x0005, 0x0009, 0x000C, 0x0001, 0x0009, 0xFFF8, 0xFFF4, 0x0011,
    0x001C, 0x0011, 0xFFF1, 0xFFF4, 0x0006, 0xFFF0, 0xFFF3, 0x0003,
    0xFFFF, 0x0008, 0xFFF0, 0x000B, 0xFFF2, 0xFFFD, 0x0007, 0xFFFE,
    0x0010, 0xFFF4, 0x000E, 0x000E, 0xFFF5, 0xFFFE, 0xFFF3, 0xFFFD,
    0x0009, 0xFFE9, 0xFFF8, 0x0036, 0xFFF7, 0xFFEC, 0xFFFA, 0x0011,
    0x0005, 0x0007, 0x0000, 0xFFF1, 0x0001, 0xFFE5, 0x0016, 0x000B,
    0x0008, 0x0008, 0xFFFF, 0x0019, 0x001D, 0xFFF6, 0x0001, 0xFFF9,
    0xFFF7, 0xFFF0, 0xFFF2, 0x001B, 0x000C, 0xFFDF, 0x0000, 0xFFFF,
    0x000F, 0xFFFC, 0x0024, 0x000B, 0xFFEF, 0xFFF9, 0x0000, 0xFFD7,
    0x000B, 0xFFD3, 0x0010, 0xFFE2, 0xFFE5, 0xFFF7, 0x0018, 0x0018,
    0x000A, 0xFFE8, 0xFFFD, 0xFFEA, 0x0001, 0x0036, 0x0014, 0xFFEB,
    0xFFF3, 0x0003, 0xFFEC, 0x0007, 0x000B, 0xFFF3, 0x0011, 0x0008,
    0xFFE8, 0xFFFE, 0xFFE9, 0x000F, 0xFFEE, 0x0007, 0x0018, 0x0009,
    0x0005, 0x0022, 0x0007, 0x000C, 0xFFF0, 0xFFFE, 0x000C, 0xFFE5,
    0xFFF6, 0x0019, 0x000E, 0xFFFE, 0xFFEF, 0x0004, 0xFFE0, 0x0004,
    0xFFDA, 0x0006, 0xFFE4, 0xFFD3, 0x0030, 0x0002, 0xFFDC, 0x0009,
    0xFFEF, 0xFFED, 0x001C, 0x0009, 0xFFFE, 0xFFF6, 0xFFFF, 0x0004,
    0x0008, 0xFFFF, 0x0009, 0x000B, 0xFFEE, 0xFFEB, 0x0010, 0x000D,
    0x0006, 0xFFE6, 0x000A, 0xFFF1, 0x000E, 0x0007, 0xFFE3, 0xFFE7,
    0x0025, 0x000E, 0x000B, 0xFFE8, 0x0025, 0x0010, 0x0008, 0x000E,
    0x0019, 0x0004, 0xFFEC, 0x000A, 0xFFF1, 0xFFFA, 0xFFE0, 0x0000,
    0x001B, 0xFFFC, 0xFFEE, 0x0001, 0xFFEA, 0x0009, 0x0001, 0xFFDA,
    0xFFF2, 0x0008, 0xFFEF, 0xFFFE, 0x000C, 0x000B, 0xFFF0, 0x0003,
    0x0005, 0xFFF1, 0x0002, 0x001B, 0xFFF1, 0x0001, 0xFFF4, 0xFFF2,
    0x000E, 0x0006, 0xFFFA, 0xFFE7, 0xFFF9, 0x0018, 0xFFE2, 0x0002,
    0xFFEB, 0xFFFD, 0xFFE2, 0xFFEF, 0xFFEB, 0x0004, 0xFFFC, 0x002F,
    0x001C, 0x0007, 0xFFEF, 0xFFF9, 0xFFE7, 0xFFE5, 0x0003, 0xFFDC,
    0xFFF6, 0xFFE9, 0x001B, 0xFFFF, 0xFFF2, 0x0006, 0xFFEF, 0x0005,
    0x0008, 0x000C, 0xFFF6, 0xFFF4, 0x0008, 0xFFC1, 0xFFFC, 0xFFEE,
    0x000A, 0xFFFC, 0x0026, 0x0005, 0xFFEF, 0xFFEC, 0xFFF6, 0x0003,
    0xFFEF, 0x0012, 0x0018, 0xFFDD, 0x000E, 0x0010, 0xFFE7, 0x000C,
    0x000F, 0xFFF6, 0xFFFD, 0xFFDE, 0xFFF3, 0xFFF5, 0x0012, 0x000C,
    0x000D, 0xFFF3, 0xFFFB, 0x0004, 0xFFEC, 0x0010, 0x0020, 0xFFE0,
    0x0023, 0x0006, 0xFFF4, 0x0023, 0xFFF7, 0x000A, 0x000A, 0x0012,
    0x0002, 0x0019, 0xFFF5, 0x0008, 0xFFED, 0x0016, 0x0000, 0x0017,
    0x0011, 0x000F, 0xFFFD, 0x0005, 0x0018, 0x0000, 0xFFE0, 0xFFEC,
    0x000A, 0x0000, 0xFFFE, 0xFFE5, 0x001A, 0xFFD8, 0x0000, 0x0008,
    0x0015, 0x0012, 0x000C, 0x0004, 0x0011, 0x0000, 0x0012, 0xFFFD,
    0x0016, 0x0001, 0x000A, 0x0017, 0xFFDA, 0xFFEA, 0xFFFE, 0xFFF8,
    0x0000, 0x000E, 0x0001, 0xFFE0, 0x0004, 0x0001, 0x001D, 0x0001,
    0x0011, 0x0007, 0xFFFB, 0xFFF9, 0x0004, 0xFFE6, 0x000E, 0xFFF8,
    0x0014, 0x000F, 0xFFF1, 0x0001, 0x0001, 0x0009, 0x0006, 0x0009,
    0xFFFD, 0x0022, 0x0028, 0x000C, 0x0012, 0xFFF2, 0x0011, 0x0015,
    0x0003, 0xFFFD, 0xFFFF, 0xFFED, 0xFFF5, 0xFFEB, 0xFFF5, 0x0027,
    0xFFE1, 0xFFF4, 0x001B, 0x0011, 0x001A, 0x000B, 0x0004, 0x0005,
    0x001B, 0xFFF6, 0xFFF5, 0x0004, 0xFFFE, 0xFFE0, 0x0010, 0x0007,
    0xFFE5, 0x0018, 0x0024, 0xFFED, 0xFFFC, 0xFFFD, 0x000E, 0x0002,
    0x000A, 0x001B, 0x000C, 0x0013, 0xFFE5, 0x001A, 0x0003, 0x0009,
    0xFFF7, 0x0005, 0x000B, 0x001C, 0x0004, 0x000E, 0x000C, 0x0009,
    0xFFFA, 0xFFEB, 0xFFF3, 0xFFFE, 0xFFE5, 0xFFF9, 0xFFF7, 0xFFF6,
    0x0009, 0xFFF3, 0x0005, 0x0001, 0x0019, 0xFFD8, 0x0008, 0x0007,
    0x000A, 0x0013, 0x0014, 0x001A, 0xFFEE, 0xFFF0, 0x0022, 0xFFEF,
    0x0009, 0xFFEE, 0xFFF6, 0x0002, 0x0011, 0xFFFD, 0xFFF6, 0xFFF9,
    0x0017, 0x000C, 0xFFFD, 0x0025, 0xFFF1, 0xFFF6, 0x0003, 0xFFFC,
    0x0020, 0x0006, 0x0018, 0x0015, 0xFFC5, 0x000B, 0xFFF3, 0x0007,
    0x0000, 0x0019, 0x0014, 0x0007, 0x0005, 0xFFEE, 0xFFFD, 0x0019,
    0xFFE5, 0x001B, 0x002D, 0xFFF9, 0xFFFE, 0xFFE8, 0x0011, 0xFFEC,
    0x0004, 0x000B, 0x000B, 0xFFDF, 0x000D, 0xFFF5, 0x0006, 0xFFEF,
    0x000F, 0x000C, 0x0001, 0x0022, 0x001B, 0xFFFD, 0xFFF8, 0x0003,
    0x0013, 0xFFF0, 0x0002, 0xFFE0, 0x0020, 0x0002, 0xFFF2, 0xFFF9,
    0xFFF0, 0xFFEF, 0x000E, 0x0000, 0xFFF7, 0x0014, 0x0023, 0xFFF1,
    0x0015, 0x0011, 0xFFEC, 0x0003, 0x000B, 0xFFE0, 0x0014, 0xFFFA,
    0x0004, 0x000B, 0x000B, 0xFFFE, 0xFFF3, 0x0003, 0xFFE6, 0xFFDC,
    0xFFEC, 0x0003, 0xFFEC, 0xFFF4, 0x000C, 0xFFEB, 0x0010, 0xFFF1,
    0xFFF9, 0x0011, 0x0010, 0xFFF2, 0xFFEE, 0x000A, 0x001A, 0x001D,
    0xFFFE, 0xFFE5, 0xFFEC, 0x001D, 0xFFFB, 0xFFDC, 0xFFEC, 0x0004,
    0xFFF2, 0x0018, 0x001B, 0x0006, 0xFFED, 0xFFFD, 0xFFF6, 0x0005,
    0x000A, 0x0009, 0x0005, 0x0014, 0x0009, 0x0008, 0x0001, 0xFFF5,
    0x0009, 0x0000, 0xFFF9, 0x0003, 0xFFE8, 0xFFFF, 0xFFF4, 0xFFDE,
    0x000D, 0xFFFE, 0xFFF9, 0x000E, 0x000D, 0xFFE3, 0x001A, 0x000D,
    0xFFEF, 0x0018, 0x0000, 0x0002, 0xFFE7, 0xFFF6, 0xFFFF, 0x0009,
    0x0003, 0x0010, 0x001E, 0xFFF4, 0x0002, 0x000D, 0xFFFB, 0xFFFC,
    0x0003, 0xFFE1, 0x000A, 0x0008, 0xFFE5, 0x0005, 0xFFDC, 0x0011,
    0xFFE4, 0xFFFB, 0x0027, 0xFFF5, 0xFFF5, 0xFFD8, 0xFFE5, 0x0021,
    0xFFEF, 0x0000, 0x0014, 0x001F, 0x0016, 0xFFDC, 0x002B, 0xFFFA,
    0xFFFD, 0x0008, 0xFFF1, 0xFFDA, 0xFFFD, 0xFFF9, 0xFFEA, 0xFFFC,
    0x0014, 0x000B, 0x0019, 0x0012, 0xFFF8, 0x0009, 0xFFE6, 0x000B,
    0x000F, 0x0011, 0x0020, 0x001B, 0x000A, 0x000F, 0x0006, 0x0000,
    0xFFFF, 0x001B, 0x0013, 0x0001, 0xFFF5, 0x0016, 0x0004, 0x0005,
    0x0014, 0x0008, 0x0013, 0x0000, 0xFFE2, 0xFFFF, 0xFFF4, 0x0012,
    0x000F, 0x0004, 0xFFEC, 0x0017, 0xFFFD, 0x000B, 0xFFF8, 0x001D,
    0xFFEA, 0x000C, 0xFFF2, 0x000E, 0xFFDE, 0xFFF1, 0xFFF8, 0xFFEA,
    0xFFFF, 0x0007, 0x000D, 0xFFF7, 0x0001, 0xFFEF, 0xFFF8, 0x0017,
    0xFFFE, 0xFFF7, 0x000F, 0xFFFC, 0x0011, 0xFFE9, 0xFFFE, 0xFFE5,
    0x0002, 0x0000, 0x0001, 0x0001, 0x001A, 0xFFF8, 0x000D, 0xFFE5,
    0x0011, 0xFFFC, 0xFFFE, 0xFFD2, 0x0001, 0x002C, 0x0014, 0xFFFE,
    0xFFF0, 0x000F, 0xFFEE, 0xFFF6, 0x0009, 0x0004, 0xFFFB, 0x0000,
    0x0008, 0xFFF5, 0xFFFF, 0x000D, 0x001A, 0xFFED, 0xFFFB, 0x0011,
    0x0004, 0xFFF3, 0x0011, 0x0014, 0x001D, 0x0005, 0xFFEA, 0x000D,
    0xFFE2, 0x0009, 0xFFF8, 0x0001, 0x0005, 0xFFEB, 0x0004, 0xFFFC,
    0xFFE7, 0xFFFA, 0xFFEF, 0x0002, 0xFFEE, 0xFFEE, 0x000E, 0xFFEE,
    0xFFF1, 0x0016, 0x000A, 0xFFF6, 0x000B, 0x0001, 0x001B, 0xFFF4,
    0x0006, 0x0001, 0xFFFE, 0x000B, 0xFFE7, 0x0000, 0x0008, 0x0001,
    0xFFE4, 0xFFFA, 0x0017, 0xFFFE, 0x0028, 0x000E, 0x001D, 0x0009,
    0x000F, 0xFFF8, 0x0007, 0x000C, 0x001C, 0x000E, 0x0013, 0x0002,
    0x0010, 0x0011, 0x000C, 0x000A, 0x001D, 0xFFFE, 0xFFDD, 0xFFF2,
    0xFFDF, 0x0020, 0x0016, 0xFFFF, 0x0012, 0xFFED, 0xFFF9, 0xFFFF,
    0x000F, 0xFFE7, 0xFFDD, 0x0000, 0x003C, 0xFFF6, 0x0017, 0xFFF0,
    0x0000, 0x0011, 0xFFF2, 0x0002, 0x0005, 0x0017, 0x0021, 0xFFE7,
    0x0000, 0x0006, 0xFFFE, 0xFFF9, 0x0006, 0xFFE2, 0xFFFD, 0x0006,
    0x0009, 0xFFF7, 0x0008, 0x0013, 0x0013, 0xFFDE, 0x0001, 0xFFEF,
    0xFFE2, 0xFFE5, 0xFFE6, 0xFFE4, 0x000E, 0xFFF9, 0xFFF8, 0xFFEF,
    0x0009, 0xFFFB, 0xFFDD, 0xFFF9, 0x0010, 0xFFF4, 0x001A, 0x0009,
    0xFFDC, 0xFFF2, 0xFFF7, 0xFFFF, 0xFFE1, 0xFFFF, 0x0009, 0xFFF4,
    0xFFFA, 0x0003, 0x0008, 0xFFF6, 0x0002, 0x0016, 0x0006, 0x0009,
    0x0000, 0xFFEB, 0x0003, 0x0038, 0x0001, 0xFFFA, 0xFFF9, 0xFFF1,
    0xFFEB, 0xFFF0, 0x0016, 0x0010, 0x0004, 0x0018, 0xFFF8, 0x0001,
    0x0010, 0xFFF4, 0xFFEB, 0x0009, 0xFFFE, 0x0008, 0xFFF7, 0xFFEB,
    0xFFFF, 0xFFFD, 0xFFF4, 0xFFF2, 0x000D, 0xFFF2, 0x000F, 0xFFF4,
    0xFFFF, 0x0005, 0x0010, 0xFFFD, 0x0018, 0x0008, 0xFFE8, 0xFFEE,
    0xFFE8, 0x0000, 0x0011, 0xFFF2, 0xFFF5, 0x000A, 0xFFEA, 0x001E,
    0x000D, 0xFFD2, 0xFFD8, 0xFFFC, 0xFFF2, 0xFFEC, 0x0018, 0x0010,
    0xFFFB, 0xFFF5, 0xFFFC, 0xFFFA, 0xFFD3, 0xFFF5, 0x0005, 0x0012,
    0x0007, 0x0014, 0xFFF8, 0x0011, 0x000F, 0xFFF7, 0x000E, 0xFFF7,
    0x0011, 0xFFFF, 0xFFF9, 0xFFFD, 0x0017, 0x0002, 0x0005, 0x0012,
    0x000D, 0xFFF0, 0xFFF3, 0xFFFD, 0x0013, 0xFFE6, 0x001C, 0xFFF4,
    0xFFF7, 0x000C, 0xFFEE, 0xFFEF, 0xFFFC, 0xFFED, 0x0007, 0xFFE8,
    0xFFD7, 0xFFF6, 0xFFFB, 0xFFEB, 0xFFE5, 0xFFDD, 0xFFE0, 0x001C,
    0x0026, 0x0014, 0x0009, 0x0003, 0x0006, 0xFFFD, 0xFFFD, 0x0014,
    0xFFFF, 0x0009, 0xFFFF, 0xFFFD, 0xFFFA, 0x0006, 0xFFFA, 0x001B,
    0x0006, 0xFFF6, 0xFFED, 0x002B, 0x001C, 0x0014, 0xFFFB, 0x0017,
    0xFFE7, 0x0013, 0xFFEB, 0x000B, 0x0012, 0xFFDD, 0xFFEB, 0x0022,
    0xFFE4, 0xFFF1, 0xFFF3, 0xFFEA, 0x0004, 0x0003, 0x0003, 0x0000,
    0xFFFF, 0xFFDE, 0x0016, 0xFFF3, 0x0017, 0xFFF5, 0xFFF1, 0x0018,
    0x0016, 0x0004, 0x0001, 0xFFFB, 0x000B, 0xFFFA, 0x0008, 0xFFE2,
    0x001D, 0x0001, 0xFFF3, 0x000C, 0xFFF6, 0xFFEB, 0x0005, 0xFFFD,
    0x001D, 0x0002, 0x000F, 0x0012, 0x001F, 0xFFF7, 0xFFFD, 0xFFF6,
    0xFFFF, 0xFFFC, 0xFFE0, 0x0006, 0xFFFF, 0x0016, 0xFFFF, 0x0010,
    0x001C, 0xFFF9, 0xFFF7, 0xFFE7, 0x0008, 0xFFEC, 0xFFEE, 0x0003,
    0x0002, 0x0013, 0x0014, 0xFFE1, 0xFFEF, 0xFFF2, 0x000B, 0xFFE9,
    0x0003, 0xFFF8, 0x0024, 0x0024, 0xFFEB, 0xFFE5, 0x000C, 0x001F,
    0x0007, 0xFFF8, 0xFFFB, 0x001A, 0xFFF5, 0x000E, 0xFFF8, 0x0021,
    0xFFEC, 0xFFF9, 0x000C, 0xFFF5, 0xFFEE, 0x000D, 0xFFCC, 0x000F,
    0x0002, 0x001B, 0xFFFB, 0x000A, 0xFFF0, 0x000F, 0x0005, 0x0017,
    0x0019, 0xFFFF, 0xFFFB, 0xFFF6, 0xFFF4, 0xFFD2, 0x0013, 0xFFF0,
    0xFFE9, 0xFFFE, 0xFFE3, 0x0000, 0xFFF7, 0xFFEC, 0xFFDE, 0xFFF5,
    0xFFF4, 0xFFEF, 0xFFFE, 0xFFED, 0x0008, 0x0008, 0xFFFB, 0x000A,
    0xFFF8, 0xFFE6, 0xFFF6, 0xFFFC, 0xFFE0, 0x0005, 0x000B, 0xFFE7,
    0xFFE6, 0xFFF9, 0x0002, 0xFFFC, 0xFFF0, 0x0009, 0xFFED, 0xFFED,
    0xFFFF, 0xFFE3, 0x0009, 0xFFF3, 0xFFFD, 0x0010, 0x0024, 0xFFE8,
    0x0022, 0xFFDA, 0x000D, 0xFFF4, 0x0006, 0xFFFC, 0xFFE9, 0xFFFD,
    0x0001, 0x000A, 0xFFE2, 0xFFF5, 0xFFFD, 0x0015, 0x0011, 0x001C,
    0x0001, 0xFFFB, 0x001E, 0x0005, 0x0015, 0xFFF6, 0x0011, 0xFFFE,
    0x0025, 0xFFFB, 0x0003, 0x0002, 0x000E, 0xFFFF, 0x0012, 0xFFFE,
    0x0004, 0x0002, 0xFFF2, 0xFFFF, 0xFFEF, 0xFFF8, 0xFFF6, 0x0009,
    0xFFFA, 0xFFF0, 0x0005, 0xFFF2, 0x001B, 0xFFFE, 0xFFFF, 0xFFE6,
    0xFFF5, 0xFFFD, 0x000E, 0x001D, 0xFFFC, 0x0018, 0xFFEF, 0x0026,
    0x0001, 0x0011, 0xFFF8, 0xFFF3, 0x0007, 0xFFF6, 0xFFEA, 0x0023,
    0xFFFC, 0xFFFF, 0xFFFE, 0xFFFA, 0xFFF9, 0x0013, 0xFFFC, 0x0006,
    0x0004, 0xFFFE, 0xFFF3, 0xFFF9, 0x000F, 0xFFF1, 0xFFF4, 0x001F,
    0x0009, 0x0004, 0xFFD4, 0xFFFE, 0xFFF4, 0x000B, 0x0003, 0x0005,
    0x0008, 0x0004, 0xFFE4, 0xFFEB, 0x0023, 0x000D, 0xFFE3, 0x0003,
    0xFFFF, 0x0005, 0xFFF9, 0x0005, 0xFFF5, 0x0001, 0x001E, 0x0001,
    0xFFDF, 0xFFF9, 0xFFFA, 0xFFE9, 0xFFFD, 0xFFF4, 0xFFF3, 0x0009,
    0x0013, 0x000D, 0x0006, 0xFFE3, 0xFFF8, 0xFFFF, 0xFFFE, 0x0015,
    0x0007, 0x0006, 0xFFFC, 0xFFF4, 0x0014, 0x0008, 0xFFF8, 0x0005,
    0xFFFA, 0xFFFC, 0xFFF3, 0x0011, 0x0002, 0x0006, 0x000E, 0x0011,
    0xFFFB, 0xFFDE, 0xFFEA, 0x0013, 0x000D, 0x0001, 0xFFF7, 0x0005,
    0x0013, 0xFFF9, 0x0011, 0x0018, 0x0007, 0x0006, 0xFFF8, 0xFFED,
    0xFFFA, 0xFFEC, 0x0015, 0x000E, 0xFFFD, 0x000D, 0xFFFC, 0xFFED,
    0xFFF7, 0xFFFD, 0x0015, 0x0005, 0x000A, 0x001A, 0x0002, 0xFFFF,
    0x001B, 0x000B, 0x0007, 0x0003, 0x0008, 0x000C, 0xFFE6, 0x0012,
    0xFFF9, 0xFFFC, 0xFFFE, 0xFFFC, 0xFFE6, 0xFFFA, 0x000E, 0xFFFA,
    0x0001, 0xFFFA, 0x0002, 0x000D, 0x000A, 0x0004, 0xFFFB, 0xFFEA,
    0x001D, 0x0007, 0x001A, 0x0000, 0x0003, 0xFFF0, 0x0002, 0x0011,
    0x000D, 0x0015, 0x0010, 0x001D, 0xFFED, 0x0001, 0x0006, 0xFFEB,
    0xFFF8, 0xFFFD, 0xFFFA, 0xFFE5, 0xFFF7, 0xFFDE, 0x000C, 0x0007,
    0x0010, 0x000D, 0x0007, 0x0004, 0xFFF0, 0x0002, 0x0020, 0x000F,
    0x0005, 0x000F, 0x0003, 0x000D, 0xFFF8, 0x0016, 0xFFF3, 0xFFF7,
    0x0016, 0xFFFB, 0xFFF6, 0xFFEE, 0xFFFF, 0x0002, 0x0004, 0x000E,
    0xFFF7, 0xFFF9, 0xFFF7, 0xFFE4, 0xFFE6, 0x000F, 0xFFFD, 0x0000,
    0xFFF2, 0x0001, 0x0014, 0xFFE7, 0xFFEA, 0xFFFA, 0xFFEA, 0x0006,
    0x0022, 0xFFF3, 0xFFE8, 0x0007, 0xFFE3, 0x0000, 0xFFF5, 0x0008,
    0x000A, 0xFFFB, 0xFFFE, 0xFFE3, 0xFFE4, 0xFFFB, 0xFFF2, 0xFFF7,
    0xFFDB, 0x000A, 0x0002, 0x0015, 0xFFF2, 0xFFFD, 0xFFD7, 0x0003,
    0x000D, 0xFFFD, 0x0028, 0x001F, 0x000F, 0x0004, 0xFFF8, 0x0017,
    0xFFFC, 0xFFEC, 0x000A, 0x0022, 0x0018, 0xFFFC, 0x001B, 0x001D,
    0xFFFA, 0xFFFE, 0xFFE5, 0x000D, 0xFFF7, 0xFFF5, 0xFFF8, 0x0001,
    0x000C, 0xFFEC, 0x0006, 0x0000, 0xFFEC, 0x002E, 0xFFFA, 0xFFFD,
    0xFFFA, 0xFFEB, 0xFFF2, 0x0001, 0x001C, 0xFFF4, 0x0024, 0x000F,
    0x000D, 0xFFEB, 0x000A, 0xFFFD, 0xFFFB, 0xFFFB, 0x0018, 0xFFF2,
    0xFFFE, 0x0001, 0xFFF8, 0xFFD1, 0x0024, 0xFFE1, 0xFFEA, 0xFFF9,
    0xFFFE, 0xFFD9, 0x0017, 0x0001, 0x0006, 0xFFEA, 0xFFCE, 0x000B,
    0x0006, 0x0003, 0xFFF8, 0xFFF8, 0x0019, 0xFFF4, 0x0016, 0x000C,
    0xFFF4, 0xFFFF, 0xFFEE, 0xFFFC, 0xFFF4, 0x0016, 0x0007, 0x001D,
    0x0000, 0xFFE9, 0x001D, 0xFFFD, 0xFFF9, 0xFFF4, 0x0013, 0x0010,
    0x000E, 0xFFDB, 0xFFFE, 0x0003, 0xFFD9, 0x0002, 0xFFED, 0x0003,
    0x0005, 0x0014, 0x0007, 0xFFE9, 0xFFFC, 0xFFFD, 0xFFED, 0x0008,
    0xFFF3, 0xFFF6, 0x0020, 0xFFE9, 0x0002, 0x0008, 0xFFFD, 0x0013,
    0x0011, 0xFFD9, 0xFFF7, 0x0000, 0xFFF2, 0xFFF2, 0xFFDF, 0xFFFB,
    0xFFDA, 0xFFED, 0xFFF3, 0xFFF9, 0xFFFB, 0xFFFE, 0xFFE1, 0x0014,
    0x000C, 0x0012, 0xFFE8, 0xFFF5, 0xFFFA, 0xFFFC, 0x0016, 0x001D,
    0xFFE4, 0x000A, 0x0000, 0x0004, 0x0019, 0x000F, 0xFFE3, 0xFFDD,
    0x002C, 0xFFF5, 0x0004, 0xFFEC, 0xFFEE, 0x0004, 0xFFD5, 0x0016,
    0x0005, 0xFFF0, 0xFFEF, 0xFFF7, 0x0012, 0x0000, 0x0010, 0xFFE3,
    0x000C, 0xFFFE, 0xFFFB, 0x0003, 0x0004, 0x0006, 0x0017, 0xFFF9,
    0x0012, 0x0012, 0x0023, 0x0009, 0xFFFD, 0x0012, 0xFFF9, 0xFFEC,
    0x001A, 0xFFE8, 0x0004, 0xFFE6, 0xFFFD, 0xFFFB, 0xFFF0, 0xFFFD,
    0x0000, 0x0002, 0x0003, 0x0026, 0xFFFD, 0xFFF4, 0x0002, 0xFFF5,
    0xFFFB, 0xFFFB, 0x000B, 0xFFF5, 0x0004, 0x0006, 0x0018, 0xFFF0,
    0x0001, 0xFFEA, 0x0012, 0xFFF5, 0x000D, 0x0012, 0xFFF6, 0xFFFF,
    0x002B, 0x001B, 0xFFF4, 0x0023, 0x0009, 0xFFEB, 0x0008, 0xFFFD,
    0xFFF5, 0xFFFB, 0xFFFF, 0x0004, 0xFFF1, 0x0003, 0xFFF0, 0x0005,
    0x000F, 0x000F, 0xFFEF, 0x0005, 0x0001, 0x0003, 0xFFF2, 0xFFFF,
    0x0020, 0x0000, 0xFFF0, 0x0016, 0xFFF8, 0xFFFA, 0xFFF8, 0x000A,
    0xFFF5, 0x000D, 0xFFF8, 0x0016, 0x0006, 0x0002, 0xFFFC, 0xFFFA,
    0xFFE9, 0xFFEC, 0xFFE7, 0x0027, 0xFFF8, 0xFFF1, 0x002B, 0xFFD4,
    0x000A, 0xFFDC, 0x0031, 0x0008, 0xFFEA, 0x0010, 0xFFEF, 0x0000,
    0xFFFB, 0x0004, 0x0031, 0x0005, 0xFFFC, 0xFFFD, 0x000D, 0xFFF9,
    0x001F, 0x0003, 0xFFF0, 0xFFE4, 0xFFF8, 0x0010, 0x000B, 0x0006,
    0x000D, 0xFFF8, 0xFFFF, 0x000A, 0x0007, 0xFFF4, 0x0008, 0xFFE9,
    0xFFFD, 0xFFF4, 0xFFF1, 0xFFF8, 0xFFED, 0xFFF3, 0xFFFA, 0x0001,
    0xFFE6, 0xFFFA, 0xFFE5, 0xFFFD, 0xFFFA, 0xFFE8, 0x0019, 0xFFE4,
    0x000B, 0xFFE3, 0x0016, 0xFFFA, 0xFFF5, 0xFFEB, 0x0006, 0x0005,
    0x0003, 0x001B, 0x000C, 0xFFF2, 0xFFF5, 0xFFFC, 0x0008, 0x0015,
    0xFFED, 0x0009, 0x0001, 0xFFF3, 0x0012, 0xFFEE, 0xFFE9, 0x000D,
    0x000A, 0xFFF6, 0x0017, 0x001F, 0xFFFE, 0x001C, 0xFFE8, 0x000C,
    0xFFFE, 0xFFF3, 0x0017, 0xFFDA, 0xFFFC, 0xFFD8, 0x0000, 0xFFF8,
    0x000F, 0xFFE5, 0xFFFB, 0xFFFE, 0xFFF9, 0x0032, 0x0006, 0x0000,
    0x0014, 0xFFFF, 0x0007, 0x0003, 0xFFE3, 0x0008, 0x0007, 0xFFEA,
    0xFFF1, 0x0018, 0xFFF4, 0x0006, 0x0009, 0x000A, 0xFFF5, 0xFFF9,
    0x0023, 0xFFF1, 0x0001, 0x000A, 0x0005, 0xFFF0, 0x0010, 0x0001,
    0xFFF0, 0xFFF7, 0x0009, 0x0004, 0xFFF8, 0x0005, 0xFFF6, 0x000A,
    0xFFFF, 0x0007, 0x0021, 0x0008, 0xFFEF, 0x001F, 0x0005, 0xFFF3,
    0x0005, 0x0004, 0x0014, 0xFFF2, 0x0026, 0xFFF7, 0x0005, 0xFFFE,
    0xFFF9, 0xFFF4, 0x0002, 0x0014, 0x000B, 0x0002, 0xFFFC, 0xFFFF,
    0xFFFE, 0xFFE7, 0xFFF1, 0x0002, 0xFFF5, 0xFFEA, 0xFFF9, 0x0011,
    0xFFEA, 0x0009, 0x0016, 0xFFFB, 0xFFF9, 0x0001, 0x0007, 0xFFF2,
    0x0004, 0xFFEE, 0xFFF0, 0x000A, 0x0009, 0x0004, 0xFFFC, 0x000F,
    0xFFED, 0xFFF7, 0xFFF7, 0xFFF8, 0x0021, 0x0005, 0xFFF7, 0xFFEE,
    0xFFF8, 0x0017, 0x0011, 0xFFE5, 0x001C, 0x0009, 0x000D, 0x0016,
    0xFFEB, 0x000D, 0x000A, 0x0002, 0x0001, 0xFFF8, 0xFFF3, 0xFFFB,
    0xFFFE, 0xFFFB, 0x0012, 0x0012, 0xFFF5, 0xFFFC, 0x000C, 0x0003,
    0x0014, 0xFFFA, 0xFFED, 0xFFF5, 0xFFFE, 0xFFFC, 0x000A, 0x0002,
    0x0013, 0xFFEF, 0x0018, 0x000B, 0xFFFA, 0x0007, 0xFFFD, 0x0001,
    0x0001, 0x0007, 0xFFFE, 0xFFFB, 0xFFFE, 0xFFE6, 0x0003, 0xFFF6,
    0x0017, 0xFFED, 0x001A, 0xFFCA, 0xFFE7, 0xFFF3, 0xFFEC, 0x0004,
    0xFFFE, 0x001F, 0x0003, 0x0005, 0x0009, 0x0005, 0x0001, 0xFFD9,
    0xFFF4, 0x000F, 0x0018, 0x000E, 0xFFFB, 0x000B, 0xFFF0, 0x000D,
    0xFFF7, 0x000B, 0x0001, 0xFFFE, 0x0004, 0xFFF5, 0x0005, 0x0006,
    0xFFF0, 0xFFF0, 0xFFDD, 0x0010, 0xFFDF, 0xFFE5, 0xFFE2, 0x0016,
    0x001E, 0x0004, 0x000A, 0xFFE9, 0x0002, 0x0002, 0x0027, 0x0021,
    0xFFE1, 0xFFF7, 0x0014, 0x000E, 0x0013, 0x000B, 0x0011, 0xFFF9,
    0xFFF4, 0x001A, 0x000F, 0x0005, 0x0015, 0xFFFE, 0x0009, 0xFFE7,
    0xFFEA, 0x0022, 0x000F, 0xFFFF, 0xFFF5, 0x000F, 0xFFF1, 0xFFEC,
    0x0012, 0x001B, 0xFFEC, 0xFFF1, 0x001D, 0x000A, 0xFFFE, 0x0006,
    0x0003, 0x0001, 0xFFF9, 0x0014, 0xFFF7, 0xFFF4, 0x000C, 0xFFE1,
    0xFFFA, 0x000B, 0xFFF2, 0xFFDC, 0xFFE6, 0x000A, 0xFFDE, 0x000B,
    0x001A, 0x000F, 0xFFD8, 0x0011, 0xFFF5, 0x0005, 0xFFFC, 0xFFDB,
    0xFFEA, 0x000D, 0x0010, 0xFFE3, 0x0003, 0xFFDF, 0xFFFC, 0x000B,
    0x0008, 0xFFFA, 0xFFF5, 0xFFF9, 0x000D, 0xFFF8, 0xFFDF, 0x0007,
    0xFFF3, 0xFFD4, 0xFFF4, 0xFFEE, 0x0030, 0xFFE8, 0x0024, 0xFFFB,
    0x0004, 0x0006, 0xFFF3, 0x0002, 0x0029, 0x0001, 0x0014, 0x0007,
    0xFFFA, 0xFFEF, 0xFFF1, 0x000A, 0x001D, 0x0021, 0x0012, 0x0005,
    0x000A, 0x0017, 0xFFE9, 0xFFC8, 0x0004, 0x0005, 0xFFF7, 0xFFFC,
    0xFFF1, 0x0008, 0xFFEE, 0xFFDB, 0xFFE4, 0x0003, 0x0003, 0x0010,
    0x001B, 0x0001, 0xFFE5, 0x0023, 0x000B, 0xFFFA, 0x0009, 0xFFF5,
    0xFFFE, 0x000D, 0xFFF3, 0x0014, 0x0006, 0x0008, 0x000A, 0xFFFB,
    0xFFF4, 0x0011, 0xFFF7, 0x0002, 0xFFFD, 0x0003, 0xFFE9, 0x000A,
    0xFFEC, 0xFFF9, 0x0002, 0x000C, 0x0010, 0xFFF4, 0x0025, 0xFFFA,
    0x0001, 0xFFFF, 0x0022, 0xFFE7, 0x000B, 0x0007, 0x0008, 0xFFF2,
    0x0017, 0xFFF5, 0x0001, 0xFFF5, 0x000F, 0x0019, 0x0018, 0x0004,
    0xFFED, 0xFFF1, 0xFFF0, 0xFFE9, 0xFFFE, 0x0000, 0xFFF9, 0x001B,
    0xFFEA, 0xFFEB, 0xFFF8, 0xFFFF, 0x0011, 0x000E, 0x001A, 0x000A,
    0x000C, 0xFFFC, 0x0005, 0x0000, 0x000C, 0xFFF6, 0xFFF9, 0x000E,
    0xFFF9, 0xFFF6, 0xFFE6, 0x0019, 0xFFFE, 0xFFF3, 0x0002, 0x0005,
    0xFFFD, 0xFFFE, 0x000A, 0xFFFF, 0xFFEC, 0xFFCE, 0x0016, 0xFFFC,
    0xFFF5, 0x0006, 0x0009, 0x0000, 0xFFF4, 0xFFF4, 0x001E, 0x0014,
    0xFFFF, 0xFFF3, 0xFFF9, 0x0009, 0xFFDF, 0x0019, 0x0009, 0x0003,
    0x0006, 0xFFFB, 0xFFD3, 0x0012, 0xFFFF, 0x0001, 0x0001, 0xFFEE,
    0x0008, 0x000B, 0x000E, 0x0014, 0xFFF3, 0x000A, 0xFFE0, 0xFFFD,
    0xFFE2, 0xFFFD, 0x000D, 0xFFFD, 0x0013, 0xFFEA, 0x0016, 0x0014,
    0xFFEA, 0x000D, 0x000E, 0x0003, 0x0035, 0xFFF0, 0x0019, 0x001D,
    0x0009, 0x0002, 0x0024, 0x000A, 0xFFE7, 0x0015, 0xFFFE, 0x0013,
    0xFFFC, 0xFFEF, 0xFFDD, 0xFFFE, 0x0025, 0x0027, 0xFFF7, 0xFFF7,
    0x0007, 0xFFE9, 0xFFFC, 0x0016, 0x000C, 0x0005, 0x0003, 0x000C,
    0x0008, 0x000F, 0x000D, 0xFFFB, 0x0008, 0x0008, 0x001F, 0xFFFF,
    0xFFE9, 0xFFFE, 0xFFEA, 0xFFDC, 0x0032, 0xFFF5, 0x0008, 0x0009,
    0x0007, 0xFFF4, 0x0015, 0xFFFA, 0xFFFF, 0x0015, 0x000D, 0xFFEB,
    0xFFF5, 0xFFFE, 0x000A, 0x0007, 0x0015, 0x0007, 0xFFF8, 0x0000,
    0x0005, 0xFFEF, 0x001E, 0x0011, 0xFFF6, 0xFFEF, 0x0009, 0x0014,
    0xFFFF, 0x0001, 0x0014, 0x0003, 0x0012, 0x0009, 0x0017, 0xFFED,
    0x000A, 0xFFF5, 0xFFF8, 0x0010, 0xFFF1, 0xFFEA, 0x0007, 0x0015,
    0x000D, 0x0025, 0xFFF6, 0x002D, 0xFFF0, 0x000B, 0xFFFF, 0xFFFC,
    0xFFF4, 0xFFFE, 0xFFE7, 0xFFEB, 0x001A, 0x0008, 0x0007, 0xFFF7,
    0x000D, 0x0000, 0xFFE4, 0xFFF1, 0xFFED, 0x0018, 0x0005, 0x0004,
    0x001F, 0x0001, 0x0009, 0x0023, 0x0004, 0xFFF5, 0x0015, 0xFFF6,
    0xFFE5, 0xFFFA, 0xFFF4, 0xFFF4, 0x0014, 0x0002, 0x0017, 0xFFEA,
    0x001B, 0x0001, 0xFFEB, 0x0000, 0xFFFB, 0x001B, 0xFFF3, 0xFFFD,
    0x000E, 0x0022, 0x0002, 0x001A, 0xFFF9, 0xFFED, 0xFFFF, 0x0006,
    0x0013, 0xFFFC, 0xFFE4, 0xFFFC, 0x0007, 0x0007, 0x0003, 0xFFD5,
    0x0006, 0x0004, 0x0013, 0xFFF2, 0x0012, 0x000D, 0x000D, 0x0001,
    0xFFDB, 0xFFE3, 0x001B, 0xFFFD, 0x0009, 0x0006, 0xFFDC, 0x0002,
    0x0012, 0x000B, 0xFFE1, 0x0008, 0xFFEF, 0xFFFF, 0xFFEE, 0x0002,
    0x0018, 0x0015, 0x0009, 0xFFFA, 0xFFFD, 0x0010, 0x0004, 0x0013,
    0xFFFC, 0x000E, 0xFFFE, 0xFFFC, 0xFFF2, 0xFFFE, 0xFFE2, 0xFFFF,
    0xFFF2, 0xFFEF, 0x0017, 0xFFF9, 0xFFF2, 0x0001, 0xFFFA, 0xFFFB,
    0xFFFD, 0x0027, 0x0003, 0xFFF9, 0xFFFD, 0x000D, 0x000E, 0x000A,
    0x0021, 0xFFFC, 0xFFF4, 0x0006, 0x002C, 0xFFF5, 0x0008, 0xFFE9,
    0x0009, 0x0012, 0xFFFB, 0xFFF6, 0x0010, 0xFFFD, 0x0023, 0x0014,
    0xFFEF, 0x0006, 0xFFFF, 0xFFDB, 0x000F, 0xFFE9, 0x0017, 0x0008,
    0x001C, 0x0018, 0xFFF3, 0x000D, 0x0003, 0xFFF1, 0xFFF3, 0xFFDB,
    0xFFE6, 0xFFF2, 0xFFE0, 0xFFD5, 0x0000, 0xFFE3, 0xFFEB, 0x0013,
    0x0002, 0xFFFB, 0x0023, 0x0010, 0xFFFE, 0xFFFC, 0xFFFC, 0x0014,
    0x0004, 0xFFFE, 0xFFE2, 0xFFED, 0xFFE5, 0x0005, 0x0013, 0xFFED,
    0xFFE7, 0x000B, 0x0021, 0x002B, 0xFFFF, 0x0006, 0x0028, 0xFFF9,
    0x0018, 0xFFF4, 0x0013, 0xFFED, 0x0003, 0xFFF8, 0xFFD8, 0xFFF9,
    0x000C, 0xFFFC, 0x000C, 0x0006, 0xFFF5, 0x0010, 0x0001, 0x0005,
    0xFFF8, 0xFFF1, 0x0000, 0x0008, 0x0004, 0xFFF0, 0x0004, 0xFFFB,
    0xFFF3, 0xFFE7, 0x0024, 0xFFE9, 0xFFF8, 0xFFD0, 0xFFF7, 0x0007,
    0x0009, 0xFFEA, 0xFFEB, 0xFFFD, 0xFFF7, 0x0007, 0x0005, 0x0005,
    0xFFF8, 0xFFEF, 0xFFEF, 0x0015, 0x0017, 0xFFE6, 0xFFFC, 0x0000,
    0xFFE9, 0x001E, 0x0006, 0xFFE0, 0xFFF0, 0xFFFB, 0x0012, 0x000F,
    0x0018, 0xFFEF, 0x000A, 0xFFED, 0x000B, 0x0010, 0xFFE2, 0xFFFD,
    0x001D, 0x0000, 0xFFE2, 0x0015, 0x0008, 0xFFDC, 0xFFFA, 0xFFEB,
    0xFFF7, 0xFFF5, 0x0001, 0x001D, 0x000B, 0xFFF2, 0x0011, 0xFFFC,
    0xFFFB, 0xFFFD, 0xFFFE, 0xFFFC, 0x0001, 0xFFFE, 0x0007, 0x0009,
    0xFFE8, 0xFFFF, 0x0009, 0xFFFA, 0xFFFE, 0xFFFA, 0xFFFD, 0x0006,
    0x0001, 0xFFEE, 0xFFFA, 0x0008, 0x000C, 0x000E, 0xFFF2, 0xFFE9,
    0xFFF5, 0x0007, 0x0008, 0x0019, 0x0000, 0x001C, 0xFFF2, 0x001B,
    0xFFFC, 0xFFF1, 0x000B, 0x0016, 0xFFF2, 0x0024, 0xFFFB, 0xFFF3,
    0xFFF9, 0x0006, 0x001E, 0x0010, 0x000D, 0x0007, 0xFFDC, 0x000C,
    0x0005, 0xFFF8, 0x0009, 0x001C, 0xFFEC, 0x000F, 0x0011, 0xFFFA,
    0xFFF8, 0x0015, 0xFFFD, 0x0008, 0xFFF3, 0xFFEC, 0x0017, 0xFFD3,
    0x0005, 0x0011, 0xFFFD, 0xFFEB, 0x000E, 0xFFF8, 0x001E, 0x000D,
    0xFFF6, 0x0003, 0x0004, 0xFFED, 0xFFDA, 0x000B, 0xFFCC, 0xFFF2,
    0x0003, 0x0020, 0x0007, 0x0005, 0x000E, 0x0003, 0xFFED, 0xFFEF,
    0xFFDB, 0x0013, 0x000D, 0x001F, 0xFFF4, 0xFFF0, 0x0000, 0xFFE3,
    0xFFE8, 0xFFE7, 0xFFEC, 0xFFE6, 0xFFDB, 0xFFE5, 0xFFEF, 0x000E,
    0x0013, 0xFFF9, 0xFFE9, 0x0009, 0x0014, 0xFFF4, 0x001B, 0x0010,
    0xFFFD, 0x2CCE, 0x0015, 0x0015, 0x0006, 0x0009, 0xFFFD, 0xFFF6,
    0x000F, 0xFFF1, 0xFFF1, 0xFFF0, 0x0019, 0xFFEE, 0xFFE2, 0xFFFC,
    0x001C, 0x000D, 0x0007, 0xFFFE, 0x0020, 0x001D, 0x0001, 0x0000,
    0xFFF4, 0xFFF7, 0xFFEA, 0x0015, 0xFFE2, 0x0017, 0xFFE8, 0xFFF7,
    0x001C, 0xFFF2, 0x000F, 0xFFED, 0xFFEE, 0x0029, 0x0019, 0x0007,
    0x0002, 0x0007, 0x0001, 0xFFFD, 0xFFF3, 0x000C, 0xFFE4, 0x0019,
    0xFFF6, 0x0014, 0x001D, 0xFFE7, 0x0000, 0x0015, 0xFFF4, 0xFFE9,
    0x0026, 0x0009, 0xFFEA, 0x0005, 0x0027, 0xFFD8, 0x000A, 0xFFFE,
    0xFFF7, 0x0000, 0x000B, 0xFFEB, 0xFFF9, 0x0001, 0x0004, 0x0008,
    0x0026, 0xFFDF, 0x0005, 0xFFFD, 0x001A, 0xFFF6, 0x0004, 0xFFE5,
    0x0018, 0xFFEC, 0xFFEA, 0xFFFD, 0xFFFE, 0x0009, 0xFFEF, 0x000D,
    0xFFE4, 0xFFFC, 0xFFEB, 0x0005, 0xFFFE, 0x0003, 0x0003, 0xFFDB,
    0x0004, 0xFFFC, 0x0004, 0xFFF3, 0x0006, 0xFFF5, 0xFFF5, 0x0013,
    0x000C, 0x001B, 0x0019, 0xFFCB, 0xFFDD, 0x001A, 0xFFFF, 0x0005,
    0xFFED, 0xFFCF, 0x0011, 0xFFEC, 0xFFFC, 0x0001, 0xFFFD, 0xFFFB,
    0x0003, 0xFFFC, 0xFFE1, 0x001D, 0xFFE6, 0x001C, 0x0001, 0xFFF7,
    0x0009, 0xFFFC, 0xFFF9, 0xFFFE, 0xFFFB, 0xFFF9, 0xFFFC, 0xFFFC,
    0xFFEC, 0xFFEA, 0x0015, 0xFFFF, 0x0004, 0x0020, 0x0012, 0x0003,
    0xFFE7, 0xFFF8, 0xFFF8, 0x0000, 0xFFFA, 0xFFEA, 0xFFF7, 0xFFF5,
    0xFFFC, 0xFFF5, 0x000A, 0xFFEC, 0x0004, 0x0006, 0x0001, 0xFFF7,
    0x0008, 0x000D, 0xFFF4, 0xFFD8, 0xFFEC, 0x0012, 0x0000, 0x0022,
    0xFFED, 0x0022, 0x001F, 0xFFF3, 0x0000, 0xFFF9, 0x001C, 0xFFF5,
    0x0018, 0x0008, 0x000D, 0xFFFB, 0x0007, 0xFFF4, 0x0021, 0x0009,
    0xFFF5, 0xFFF4, 0x0010, 0x0012, 0xFFFB, 0x0006, 0x000E, 0x0008,
    0xFFE3, 0x0001, 0xFFF0, 0xFFFD, 0x001A, 0x0000, 0xFFF7, 0x001C,
    0xFFF5, 0xFFF2, 0xFFEF, 0x000F, 0xFFFC, 0x0024, 0xFFE9, 0x000A,
    0x0016, 0xFFF6, 0x000A, 0xFFF8, 0xFFF0, 0xFFF6, 0x0006, 0x0000,
    0x0001, 0x0018, 0x0018, 0x0001, 0xFFD5, 0xFFF1, 0xFFF5, 0x000B,
    0xFFF9, 0x0004, 0xFFF0, 0x0003, 0xFFEC, 0xFFE9, 0x0009, 0x0010,
    0xFFF6, 0xFFE4, 0x000A, 0x0004, 0xFFFB, 0xFFEA, 0x000E, 0x0029,
    0x0011, 0x002B, 0x0015, 0x000D, 0xFFDD, 0x001A, 0xFFF8, 0xFFD8,
    0xFFFC, 0xFFE1, 0x0000, 0x000F, 0x0021, 0xFFED, 0xFFEC, 0x0002,
    0x001B, 0xFFF9, 0xFFFF, 0xFFF6, 0xFFF3, 0xFFEF, 0xFFF0, 0xFFF6,
    0xFFC9, 0x0000, 0xFFEE, 0xFFE9, 0xFFE1, 0x0012, 0x0007, 0xFFF5,
    0x0013, 0xFFFE, 0xFFF9, 0xFFEA, 0xFFFE, 0xFFF5, 0x0001, 0xFFFA,
    0xFFFC, 0x0000, 0x0001, 0x000F, 0x0004, 0xFFE0, 0x000E, 0xFFF2,
    0x0004, 0x0001, 0xFFE4, 0x0007, 0x0010, 0x0008, 0x0002, 0x0009,
    0x0004, 0xFFE7, 0xFFEB, 0x000C, 0x0018, 0x001A, 0x0003, 0xFFEC,
    0xFFF3, 0x0014, 0x0014, 0x0007, 0xFFD9, 0xFFFB, 0x000E, 0xFFFA,
    0xFFFD, 0xFFF6, 0xFFF3, 0x0001, 0xFFDC, 0x000F, 0x0006, 0x0016,
    0xFFF3, 0x0007, 0x0009, 0xFFF9, 0x000C, 0xFFF4, 0xFFE0, 0xFFFE,
    0xFFE3, 0x000A, 0x0019, 0x0014, 0x0001, 0xFFFD, 0xFFF3, 0xFFF1,
    0xFFD7, 0xFFFE, 0x001C, 0xFFFB, 0x000B, 0x000D, 0xFFF3, 0x0005,
    0xFFEA, 0x0000, 0x002C, 0xFFD4, 0x0001, 0x0016, 0x0032, 0xFFF0,
    0x0000, 0x000A, 0x0008, 0xFFF8, 0x0005, 0x002D, 0x001E, 0x0014,
    0xFFF5, 0xFFFE, 0xFFF4, 0x0008, 0xFFF2, 0x0015, 0x0019, 0x000D,
    0xFFFB, 0xFFFD, 0x000C, 0x0019, 0x0001, 0xFFFB, 0x0011, 0xFFF5,
    0xFFF2, 0x0018, 0x0016, 0xFFFE, 0x001A, 0x0002, 0x0006, 0x001A,
    0xFFFF, 0xFFE9, 0x0013, 0x0001, 0xFFF7, 0xFFF8, 0x0016, 0xFFDE,
    0xFFF7, 0xFFD4, 0x000A, 0xFFDC, 0xFFEE, 0x001A, 0x0002, 0xFFF5,
    0x0000, 0xFFEC, 0x0020, 0x0008, 0x000C, 0xFFF1, 0x0023, 0x0000,
    0x001D, 0xFFF9, 0xFFFB, 0x0024, 0xFFDD, 0x002A, 0xFFF4, 0x000A,
    0x001D, 0x001C, 0xFFFA, 0xFFFC, 0xFFFA, 0x001B, 0x001A, 0x000F,
    0x0010, 0x0010, 0x0001, 0x0011, 0x0002, 0xFFF3, 0x0014, 0x001B,
    0x0007, 0xFFF7, 0x0003, 0x0017, 0x0004, 0x0013, 0x000A, 0x0009,
    0xFFDC, 0xFFE9, 0x0017, 0xFFF9, 0x000A, 0xFFDD, 0x0007, 0x0005,
    0x0007, 0xFFF0, 0x000A, 0xFFED, 0x0010, 0xFFFF, 0x0014, 0x0005,
    0xFFDE, 0x0004, 0x0005, 0x000E, 0xFFE0, 0xFFF3, 0x0032, 0x0019,
    0xFFEC, 0x0002, 0xFFEF, 0x0006, 0xFFF1, 0xFFD7, 0x000B, 0x0010,
    0xFFFB, 0xFFEC, 0xFFEE, 0x0004, 0xFFF9, 0xFFDA, 0x0014, 0xFFF2,
    0x0013, 0x0008, 0x0006, 0xFFF3, 0xFFF8, 0xFFF9, 0xFFF5, 0xFFF7,
    0xFFFA, 0x0015, 0xFFE2, 0x0016, 0xFFF3, 0x0001, 0x0012, 0x0003,
    0x0007, 0xFFFF, 0x0003, 0x0017, 0xFFE7, 0xFFE9, 0x0002, 0x0000,
    0xFFF0, 0xFFEC, 0x000E, 0x0007, 0x000D, 0x0003, 0xFFF3, 0x000D,
    0xFFF7, 0x0012, 0x0015, 0xFFFD, 0x000D, 0x0009, 0x001F, 0x000A,
    0x000A, 0xFFEE, 0xFFFC, 0xFFF9, 0xFFFB, 0x000E, 0xFFFD, 0x000C,
    0x0001, 0xFFF3, 0x0004, 0xFFE4, 0x0014, 0xFFFE, 0x0003, 0xFFFE,
    0x0016, 0xFFFD, 0xFFEF, 0xFFD2, 0x000F, 0x001E, 0xFFFE, 0x0027,
    0xFFFA, 0x000D, 0x0003, 0xFFE5, 0x0004, 0xFFFB, 0xFFFD, 0xFFEC,
    0x0010, 0x0002, 0xFFFB, 0x0011, 0x002E, 0x0008, 0xFFEA, 0x000F,
    0xFFE9, 0xFFFB, 0x0011, 0xFFFB, 0x0008, 0xFFE7, 0x0024, 0x0005,
    0x0005, 0x0003, 0xFFF9, 0xFFE7, 0xFFFA, 0x0011, 0x0009, 0x0009,
    0xFFF9, 0xFFEA, 0xFFEF, 0x0035, 0x0002, 0xFFFB, 0x0011, 0x000A,
    0x0011, 0x0022, 0x001A, 0xFFFF, 0xFFEE, 0xFFF5, 0xFFEE, 0xFFE0,
    0xFFEA, 0x0016, 0x0010, 0xFFEF, 0xFFF9, 0xFFFA, 0x0016, 0x0007,
    0x000B, 0x0002, 0xFFF4, 0x0004, 0xFFE7, 0x0019, 0xFFFD, 0x000F,
    0x002D, 0x001A, 0xFFF1, 0x000B, 0x000F, 0x0001, 0xFFF8, 0x000E,
    0xFFEB, 0xFFEB, 0xFFE9, 0xFFF3, 0xFFF8, 0x0009, 0x0016, 0xFFEC,
    0x000F, 0xFFF5, 0x000D, 0x0019, 0xFFEC, 0xFFEC, 0x0016, 0xFFF4,
    0x0018, 0x0014, 0xFFF1, 0xFFFD, 0xFFF6, 0xFFF4, 0xFFED, 0x0013,
    0x000F, 0x001D, 0xFFEE, 0x0009, 0xFFFF, 0x000C, 0xFFE8, 0x0014,
    0x0012, 0xFFF1, 0xFFF4, 0x0019, 0x0014, 0xFFF6, 0x0018, 0xFFF6,
    0x000E, 0x0012, 0xFFF8, 0xFFDE, 0x000B, 0x000B, 0x0013, 0xFFFC,
    0xFFFA, 0x000C, 0xFFEA, 0xFFE3, 0xFFE7, 0x000E, 0x0003, 0x001E,
    0xFFED, 0xFFFF, 0x0009, 0x0013, 0xFFFD, 0xFFFB, 0x0010, 0x003E,
    0xFFF8, 0xFFF8, 0xFFF1, 0x0011, 0x002C, 0xFFFC, 0x0012, 0x0002,
    0x001C, 0x0001, 0x0001, 0x0000, 0xFFF1, 0xFFEA, 0xFFE5, 0x0026,
    0xFFFD, 0x0004, 0x000B, 0x0005, 0x0014, 0x0001, 0xFFF8, 0x0004,
    0x0014, 0x001C, 0x000F, 0x0016, 0x0023, 0xFFE5, 0x0013, 0x0006,
    0x0000, 0xFFE8, 0x0003, 0xFFE9, 0x000D, 0x000B, 0xFFF7, 0x0001,
    0x000C, 0xFFFA, 0xFFE8, 0xFFEA, 0xFFCD, 0x0009, 0xFFF4, 0x0010,
    0xFFFB, 0xFFFA, 0x0003, 0xFFE3, 0xFFEF, 0xFFF3, 0x0002, 0xFFE7,
    0xFFE0, 0x0018, 0x0002, 0x0016, 0x001B, 0x000B, 0x0002, 0x000E,
    0x0008, 0xFFD9, 0x0002, 0x0002, 0x0004, 0xFFFB, 0x000B, 0x0002,
    0xFFF7, 0xFFE3, 0xFFFF, 0x0000, 0xFFF0, 0xFFE3, 0x0003, 0x0005,
    0xFFF1, 0xFFF5, 0xFFF8, 0x000E, 0xFFD0, 0xFFF4, 0xFFF2, 0x0003,
    0x0005, 0xFFDA, 0xFFFC, 0x0003, 0x0010, 0x000E, 0x0014, 0x0010,
    0xFFDC, 0xFFF0, 0xFFF6, 0x0000, 0xFFFE, 0x002C, 0x000D, 0xFFEC,
    0x0010, 0xFFD8, 0xFFF9, 0x0004, 0x0011, 0xFFFE, 0x002D, 0x001A,
    0xFFEC, 0xFFFA, 0xFFEE, 0xFFD5, 0x000E, 0x0001, 0xFFF1, 0x0019,
    0x0007, 0x0006, 0x000C, 0xFFFC, 0xFFF4, 0x0007, 0x0013, 0x0007,
    0x001A, 0x0005, 0xFFEC, 0x0023, 0x0010, 0x0000, 0x0007, 0xFFFA,
    0x0015, 0x0005, 0x0004, 0xFFFF, 0x0008, 0x0016, 0x0007, 0x0006,
    0xFFF9, 0xFFF1, 0x0009, 0xFFDE, 0x0005, 0x0004, 0x0010, 0x0000,
    0xFFD4, 0xFFFD, 0xFFE9, 0x0003, 0x000E, 0xFFFB, 0xFFFB, 0xFFE2,
    0x0006, 0x0014, 0x0004, 0xFFFE, 0x0009, 0xFFF6, 0x0015, 0xFFEF,
    0xFFDE, 0x000A, 0xFFE3, 0x002A, 0xFFE0, 0xFFF0, 0x0018, 0x000D,
    0xFFFC, 0x0017, 0x0005, 0x0024, 0xFFEF, 0x0001, 0xFFF6, 0xFFEE,
    0x0013, 0x000A, 0x0007, 0xFFF4, 0x0021, 0x0021, 0x0007, 0x0007,
    0x000E, 0x000C, 0x0015, 0xFFFA, 0x0026, 0xFFF4, 0xFFE2, 0x0005,
    0x0016, 0xFFDD, 0x0008, 0xFFFB, 0xFFF1, 0x000D, 0x0012, 0xFFEB,
    0xFFF8, 0xFFDF, 0x0009, 0x0013, 0xFFFC, 0xFFFE, 0x001A, 0xFFEF,
    0xFFE6, 0x001A, 0x000F, 0x0016, 0xFFF6, 0xFFE1, 0x0000, 0xFFF8,
    0x000A, 0xFFFF, 0x0008, 0x0006, 0x0002, 0x0000, 0x000B, 0xFFFB,
    0x000D, 0xFFFA, 0xFFFB, 0x0012, 0xFFF6, 0xFFF4, 0xFFFB, 0x0018,
    0xFFF3, 0xFFFE, 0x0006, 0xFFFC, 0x000C, 0x0000, 0xFFE4, 0xFFF7,
    0x0014, 0xFFF4, 0x001F, 0x000E, 0xFFF5, 0x0007, 0x0002, 0xFFD8,
    0xFFF8, 0x0019, 0x0000, 0x000C, 0x001D, 0x0014, 0xFFE7, 0x0031,
    0xFFD1, 0x0013, 0x000B, 0x0020, 0x000F, 0xFFE4, 0x0007, 0x0025,
    0xFFEE, 0xFFF4, 0x0000, 0xFFF7, 0x000A, 0xFFF1, 0x000C, 0x0011,
    0xFFE9, 0x0002, 0xFFF5, 0x0016, 0xFFFB, 0xFFFB, 0x000A, 0xFFE7,
    0x0000, 0xFFEC, 0xFFD2, 0xFFD5, 0xFFF7, 0xFFDA, 0x0019, 0x0022,
    0xFFF5, 0xFFEE, 0xFFFB, 0x0020, 0xFFF1, 0x0006, 0xFFF9, 0x0012,
    0x001A, 0x0002, 0xFFFE, 0xFFEE, 0x0012, 0xFFFF, 0x0003, 0x0016,
    0xFFF2, 0xFFD7, 0x0009, 0xFFFD, 0xFFF6, 0xFFE0, 0x0005, 0xFFFB,
    0x000F, 0xFFFA, 0x0007, 0x000C, 0xFFDE, 0xFFEE, 0xFFF6, 0x0017,
    0x001C, 0x0003, 0xFFF1, 0xFFFF, 0x0001, 0xFFE3, 0xFFFB, 0xFFF8,
    0xFFE5, 0xFFE4, 0x000E, 0xFFED, 0x000E, 0xFFE3, 0x0014, 0x0032
    };

static const q15_t in_cfft_step_16[32] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_16[32] = {
    0x399A, 0x0000, 0xF8CD, 0x2432, 0x0000, 0x0000, 0xF8CD, 0x0AC7,
    0x0000, 0x0000, 0xF8CD, 0x04D0, 0x0000, 0x0000, 0xF8CD, 0x016F,
    0x0000, 0x0000, 0xF8CD, 0xFE91, 0x0000, 0x0000, 0xF8CD, 0xFB30,
    0x0000, 0x0000, 0xF8CD, 0xF539, 0x0000, 0x0000, 0xF8CD, 0xDBCE
    };

static const q15_t ref_cfft_step_16[32] = {
    0x399A, 0x0000, 0xF8CD, 0x2432, 0x0000, 0x0000, 0xF8CD, 0x0AC7,
    0x0000, 0x0000, 0xF8CD, 0x04D0, 0x0000, 0x0000, 0xF8CD, 0x016F,
    0x0000, 0x0000, 0xF8CD, 0xFE91, 0x0000, 0x0000, 0xF8CD, 0xFB30,
    0x0000, 0x0000, 0xF8CD, 0xF539, 0x0000, 0x0000, 0xF8CD, 0xDBCE
    };

static const q15_t in_cfft_step_32[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_32[64] = {
    0x399A, 0x0000, 0xFC66, 0x248D, 0x0000, 0x0000, 0xFC66, 0x0BDE,
    0x0000, 0x0000, 0xFC66, 0x06BC, 0x0000, 0x0000, 0xFC66, 0x0463,
    0x0000, 0x0000, 0xFC66, 0x02F4, 0x0000, 0x0000, 0xFC66, 0x01ED,
    0x0000, 0x0000, 0xFC66, 0x0118, 0x0000, 0x0000, 0xFC66, 0x005B,
    0x0000, 0x0000, 0xFC66, 0xFFA5, 0x0000, 0x0000, 0xFC66, 0xFEE8,
    0x0000, 0x0000, 0xFC66, 0xFE13, 0x0000, 0x0000, 0xFC66, 0xFD0C,
    0x0000, 0x0000, 0xFC66, 0xFB9D, 0x0000, 0x0000, 0xFC66, 0xF944,
    0x0000, 0x0000, 0xFC66, 0xF422, 0x0000, 0x0000, 0xFC66, 0xDB73
    };

static const q15_t ref_cfft_step_32[64] = {
    0x399A, 0x0000, 0xFC66, 0x248D, 0x0000, 0x0000, 0xFC66, 0x0BDE,
    0x0000, 0x0000, 0xFC66, 0x06BC, 0x0000, 0x0000, 0xFC66, 0x0463,
    0x0000, 0x0000, 0xFC66, 0x02F4, 0x0000, 0x0000, 0xFC66, 0x01ED,
    0x0000, 0x0000, 0xFC66, 0x0118, 0x0000, 0x0000, 0xFC66, 0x005B,
    0x0000, 0x0000, 0xFC66, 0xFFA5, 0x0000, 0x0000, 0xFC66, 0xFEE8,
    0x0000, 0x0000, 0xFC66, 0xFE13, 0x0000, 0x0000, 0xFC66, 0xFD0C,
    0x0000, 0x0000, 0xFC66, 0xFB9D, 0x0000, 0x0000, 0xFC66, 0xF944,
    0x0000, 0x0000, 0xFC66, 0xF422, 0x0000, 0x0000, 0xFC66, 0xDB73
    };

static const q15_t in_cfft_step_64[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_64[128] = {
    0x399A, 0x0000, 0xFE33, 0x24A4, 0x0000, 0x0000, 0xFE33, 0x0C22,
    0x0000, 0x0000, 0xFE33, 0x0730, 0x0000, 0x0000, 0xFE33, 0x0508,
    0x0000, 0x0000, 0xFE33, 0x03CE, 0x0000, 0x0000, 0xFE33, 0x0301,
    0x0000, 0x0000, 0xFE33, 0x026D, 0x0000, 0x0000, 0xFE33, 0x01FC,
    0x0000, 0x0000, 0xFE33, 0x01A2, 0x0000, 0x0000, 0xFE33, 0x0156,
    0x0000, 0x0000, 0xFE33, 0x0114, 0x0000, 0x0000, 0xFE33, 0x00DA,
    0x0000, 0x0000, 0xFE33, 0x00A5, 0x0000, 0x0000, 0xFE33, 0x0073,
    0x0000, 0x0000, 0xFE33, 0x0044, 0x0000, 0x0000, 0xFE33, 0x0017,
    0x0000, 0x0000, 0xFE33, 0xFFE9, 0x0000, 0x0000, 0xFE33, 0xFFBC,
    0x0000, 0x0000, 0xFE33, 0xFF8D, 0x0000, 0x0000, 0xFE33, 0xFF5B,
    0x0000, 0x0000, 0xFE33, 0xFF26, 0x0000, 0x0000, 0xFE33, 0xFEEC,
    0x0000, 0x0000, 0xFE33, 0xFEAA, 0x0000, 0x0000, 0xFE33, 0xFE5E,
    0x0000, 0x0000, 0xFE33, 0xFE04, 0x0000, 0x0000, 0xFE33, 0xFD93,
    0x0000, 0x0000, 0xFE33, 0xFCFF, 0x0000, 0x0000, 0xFE33, 0xFC32,
    0x0000, 0x0000, 0xFE33, 0xFAF8, 0x0000, 0x0000, 0xFE33, 0xF8D0,
    0x0000, 0x0000, 0xFE33, 0xF3DE, 0x0000, 0x0000, 0xFE33, 0xDB5C
    };

static const q15_t ref_cfft_step_64[128] = {
    0x399A, 0x0000, 0xFE33, 0x24A4, 0x0000, 0x0000, 0xFE33, 0x0C22,
    0x0000, 0x0000, 0xFE33, 0x0730, 0x0000, 0x0000, 0xFE33, 0x0508,
    0x0000, 0x0000, 0xFE33, 0x03CE, 0x0000, 0x0000, 0xFE33, 0x0301,
    0x0000, 0x0000, 0xFE33, 0x026D, 0x0000, 0x0000, 0xFE33, 0x01FC,
    0x0000, 0x0000, 0xFE33, 0x01A2, 0x0000, 0x0000, 0xFE33, 0x0156,
    0x0000, 0x0000, 0xFE33, 0x0114, 0x0000, 0x0000, 0xFE33, 0x00DA,
    0x0000, 0x0000, 0xFE33, 0x00A5, 0x0000, 0x0000, 0xFE33, 0x0073,
    0x0000, 0x0000, 0xFE33, 0x0044, 0x0000, 0x0000, 0xFE33, 0x0017,
    0x0000, 0x0000, 0xFE33, 0xFFE9, 0x0000, 0x0000, 0xFE33, 0xFFBC,
    0x0000, 0x0000, 0xFE33, 0xFF8D, 0x0000, 0x0000, 0xFE33, 0xFF5B,
    0x0000, 0x0000, 0xFE33, 0xFF26, 0x0000, 0x0000, 0xFE33, 0xFEEC,
    0x0000, 0x0000, 0xFE33, 0xFEAA, 0x0000, 0x0000, 0xFE33, 0xFE5E,
    0x0000, 0x0000, 0xFE33, 0xFE04, 0x0000, 0x0000, 0xFE33, 0xFD93,
    0x0000, 0x0000, 0xFE33, 0xFCFF, 0x0000, 0x0000, 0xFE33, 0xFC32,
    0x0000, 0x0000, 0xFE33, 0xFAF8, 0x0000, 0x0000, 0xFE33, 0xF8D0,
    0x0000, 0x0000, 0xFE33, 0xF3DE, 0x0000, 0x0000, 0xFE33, 0xDB5C
    };

static const q15_t in_cfft_step_128[256] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_128[256] = {
    0x399A, 0x0000, 0xFF1A, 0x24A9, 0x0000, 0x0000, 0xFF1A, 0x0C33,
    0x0000, 0x0000, 0xFF1A, 0x074C, 0x0000, 0x0000, 0xFF1A, 0x0530,
    0x0000, 0x0000, 0xFF1A, 0x0402, 0x0000, 0x0000, 0xFF1A, 0x0341,
    0x0000, 0x0000, 0xFF1A, 0x02B9, 0x0000, 0x0000, 0xFF1A, 0x0255,
    0x0000, 0x0000, 0xFF1A, 0x0208, 0x0000, 0x0000, 0xFF1A, 0x01CA,
    0x0000, 0x0000, 0xFF1A, 0x0197, 0x0000, 0x0000, 0xFF1A, 0x016C,
    0x0000, 0x0000, 0xFF1A, 0x0147, 0x0000, 0x0000, 0xFF1A, 0x0127,
    0x0000, 0x0000, 0xFF1A, 0x010B, 0x0000, 0x0000, 0xFF1A, 0x00F2,
    0x0000, 0x0000, 0xFF1A, 0x00DB, 0x0000, 0x0000, 0xFF1A, 0x00C7,
    0x0000, 0x0000, 0xFF1A, 0x00B4, 0x0000, 0x0000, 0xFF1A, 0x00A2,
    0x0000, 0x0000, 0xFF1A, 0x0092, 0x0000, 0x0000, 0xFF1A, 0x0083,
    0x0000, 0x0000, 0xFF1A, 0x0074, 0x0000, 0x0000, 0xFF1A, 0x0066,
    0x0000, 0x0000, 0xFF1A, 0x0059, 0x0000, 0x0000, 0xFF1A, 0x004C,
    0x0000, 0x0000, 0xFF1A, 0x0040, 0x0000, 0x0000, 0xFF1A, 0x0034,
    0x0000, 0x0000, 0xFF1A, 0x0028, 0x0000, 0x0000, 0xFF1A, 0x001C,
    0x0000, 0x0000, 0xFF1A, 0x0011, 0x0000, 0x0000, 0xFF1A, 0x0006,
    0x0000, 0x0000, 0xFF1A, 0xFFFA, 0x0000, 0x0000, 0xFF1A, 0xFFEF,
    0x0000, 0x0000, 0xFF1A, 0xFFE4, 0x0000, 0x0000, 0xFF1A, 0xFFD8,
    0x0000, 0x0000, 0xFF1A, 0xFFCC, 0x0000, 0x0000, 0xFF1A, 0xFFC0,
    0x0000, 0x0000, 0xFF1A, 0xFFB4, 0x0000, 0x0000, 0xFF1A, 0xFFA7,
    0x0000, 0x0000, 0xFF1A, 0xFF9A, 0x0000, 0x0000, 0xFF1A, 0xFF8C,
    0x0000, 0x0000, 0xFF1A, 0xFF7D, 0x0000, 0x0000, 0xFF1A, 0xFF6E,
    0x0000, 0x0000, 0xFF1A, 0xFF5E, 0x0000, 0x0000, 0xFF1A, 0xFF4C,
    0x0000, 0x0000, 0xFF1A, 0xFF39, 0x0000, 0x0000, 0xFF1A, 0xFF25,
    0x0000, 0x0000, 0xFF1A, 0xFF0E, 0x0000, 0x0000, 0xFF1A, 0xFEF5,
    0x0000, 0x0000, 0xFF1A, 0xFED9, 0x0000, 0x0000, 0xFF1A, 0xFEB9,
    0x0000, 0x0000, 0xFF1A, 0xFE94, 0x0000, 0x0000, 0xFF1A, 0xFE69,
    0x0000, 0x0000, 0xFF1A, 0xFE36, 0x0000, 0x0000, 0xFF1A, 0xFDF8,
    0x0000, 0x0000, 0xFF1A, 0xFDAB, 0x0000, 0x0000, 0xFF1A, 0xFD47,
    0x0000, 0x0000, 0xFF1A, 0xFCBF, 0x0000, 0x0000, 0xFF1A, 0xFBFE,
    0x0000, 0x0000, 0xFF1A, 0xFAD0, 0x0000, 0x0000, 0xFF1A, 0xF8B4,
    0x0000, 0x0000, 0xFF1A, 0xF3CD, 0x0000, 0x0000, 0xFF1A, 0xDB57
    };

static const q15_t ref_cfft_step_128[256] = {
    0x399A, 0x0000, 0xFF1A, 0x24A9, 0x0000, 0x0000, 0xFF1A, 0x0C33,
    0x0000, 0x0000, 0xFF1A, 0x074C, 0x0000, 0x0000, 0xFF1A, 0x0530,
    0x0000, 0x0000, 0xFF1A, 0x0402, 0x0000, 0x0000, 0xFF1A, 0x0341,
    0x0000, 0x0000, 0xFF1A, 0x02B9, 0x0000, 0x0000, 0xFF1A, 0x0255,
    0x0000, 0x0000, 0xFF1A, 0x0208, 0x0000, 0x0000, 0xFF1A, 0x01CA,
    0x0000, 0x0000, 0xFF1A, 0x0197, 0x0000, 0x0000, 0xFF1A, 0x016C,
    0x0000, 0x0000, 0xFF1A, 0x0147, 0x0000, 0x0000, 0xFF1A, 0x0127,
    0x0000, 0x0000, 0xFF1A, 0x010B, 0x0000, 0x0000, 0xFF1A, 0x00F2,
    0x0000, 0x0000, 0xFF1A, 0x00DB, 0x0000, 0x0000, 0xFF1A, 0x00C7,
    0x0000, 0x0000, 0xFF1A, 0x00B4, 0x0000, 0x0000, 0xFF1A, 0x00A2,
    0x0000, 0x0000, 0xFF1A, 0x0092, 0x0000, 0x0000, 0xFF1A, 0x0083,
    0x0000, 0x0000, 0xFF1A, 0x0074, 0x0000, 0x0000, 0xFF1A, 0x0066,
    0x0000, 0x0000, 0xFF1A, 0x0059, 0x0000, 0x0000, 0xFF1A, 0x004C,
    0x0000, 0x0000, 0xFF1A, 0x0040, 0x0000, 0x0000, 0xFF1A, 0x0034,
    0x0000, 0x0000, 0xFF1A, 0x0028, 0x0000, 0x0000, 0xFF1A, 0x001C,
    0x0000, 0x0000, 0xFF1A, 0x0011, 0x0000, 0x0000, 0xFF1A, 0x0006,
    0x0000, 0x0000, 0xFF1A, 0xFFFA, 0x0000, 0x0000, 0xFF1A, 0xFFEF,
    0x0000, 0x0000, 0xFF1A, 0xFFE4, 0x0000, 0x0000, 0xFF1A, 0xFFD8,
    0x0000, 0x0000, 0xFF1A, 0xFFCC, 0x0000, 0x0000, 0xFF1A, 0xFFC0,
    0x0000, 0x0000, 0xFF1A, 0xFFB4, 0x0000, 0x0000, 0xFF1A, 0xFFA7,
    0x0000, 0x0000, 0xFF1A, 0xFF9A, 0x0000, 0x0000, 0xFF1A, 0xFF8C,
    0x0000, 0x0000, 0xFF1A, 0xFF7D, 0x0000, 0x0000, 0xFF1A, 0xFF6E,
    0x0000, 0x0000, 0xFF1A, 0xFF5E, 0x0000, 0x0000, 0xFF1A, 0xFF4C,
    0x0000, 0x0000, 0xFF1A, 0xFF39, 0x0000, 0x0000, 0xFF1A, 0xFF25,
    0x0000, 0x0000, 0xFF1A, 0xFF0E, 0x0000, 0x0000, 0xFF1A, 0xFEF5,
    0x0000, 0x0000, 0xFF1A, 0xFED9, 0x0000, 0x0000, 0xFF1A, 0xFEB9,
    0x0000, 0x0000, 0xFF1A, 0xFE94, 0x0000, 0x0000, 0xFF1A, 0xFE69,
    0x0000, 0x0000, 0xFF1A, 0xFE36, 0x0000, 0x0000, 0xFF1A, 0xFDF8,
    0x0000, 0x0000, 0xFF1A, 0xFDAB, 0x0000, 0x0000, 0xFF1A, 0xFD47,
    0x0000, 0x0000, 0xFF1A, 0xFCBF, 0x0000, 0x0000, 0xFF1A, 0xFBFE,
    0x0000, 0x0000, 0xFF1A, 0xFAD0, 0x0000, 0x0000, 0xFF1A, 0xF8B4,
    0x0000, 0x0000, 0xFF1A, 0xF3CD, 0x0000, 0x0000, 0xFF1A, 0xDB57
    };

static const q15_t in_cfft_step_256[512] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_256[512] = {
    0x399A, 0x0000, 0xFF8D, 0x24AB, 0x0000, 0x0000, 0xFF8D, 0x0C38,
    0x0000, 0x0000, 0xFF8D, 0x0753, 0x0000, 0x0000, 0xFF8D, 0x053A,
    0x0000, 0x0000, 0xFF8D, 0x040F, 0x0000, 0x0000, 0xFF8D, 0x0350,
    0x0000, 0x0000, 0xFF8D, 0x02CC, 0x0000, 0x0000, 0xFF8D, 0x026B,
    0x0000, 0x0000, 0xFF8D, 0x0220, 0x0000, 0x0000, 0xFF8D, 0x01E5,
    0x0000, 0x0000, 0xFF8D, 0x01B5, 0x0000, 0x0000, 0xFF8D, 0x018D,
    0x0000, 0x0000, 0xFF8D, 0x016C, 0x0000, 0x0000, 0xFF8D, 0x014F,
    0x0000, 0x0000, 0xFF8D, 0x0136, 0x0000, 0x0000, 0xFF8D, 0x0120,
    0x0000, 0x0000, 0xFF8D, 0x010D, 0x0000, 0x0000, 0xFF8D, 0x00FC,
    0x0000, 0x0000, 0xFF8D, 0x00EC, 0x0000, 0x0000, 0xFF8D, 0x00DE,
    0x0000, 0x0000, 0xFF8D, 0x00D1, 0x0000, 0x0000, 0xFF8D, 0x00C6,
    0x0000, 0x0000, 0xFF8D, 0x00BB, 0x0000, 0x0000, 0xFF8D, 0x00B1,
    0x0000, 0x0000, 0xFF8D, 0x00A8, 0x0000, 0x0000, 0xFF8D, 0x009F,
    0x0000, 0x0000, 0xFF8D, 0x0097, 0x0000, 0x0000, 0xFF8D, 0x0090,
    0x0000, 0x0000, 0xFF8D, 0x0089, 0x0000, 0x0000, 0xFF8D, 0x0082,
    0x0000, 0x0000, 0xFF8D, 0x007C, 0x0000, 0x0000, 0xFF8D, 0x0076,
    0x0000, 0x0000, 0xFF8D, 0x0070, 0x0000, 0x0000, 0xFF8D, 0x006B,
    0x0000, 0x0000, 0xFF8D, 0x0066, 0x0000, 0x0000, 0xFF8D, 0x0061,
    0x0000, 0x0000, 0xFF8D, 0x005C, 0x0000, 0x0000, 0xFF8D, 0x0058,
    0x0000, 0x0000, 0xFF8D, 0x0053, 0x0000, 0x0000, 0xFF8D, 0x004F,
    0x0000, 0x0000, 0xFF8D, 0x004B, 0x0000, 0x0000, 0xFF8D, 0x0047,
    0x0000, 0x0000, 0xFF8D, 0x0043, 0x0000, 0x0000, 0xFF8D, 0x003F,
    0x0000, 0x0000, 0xFF8D, 0x003C, 0x0000, 0x0000, 0xFF8D, 0x0038,
    0x0000, 0x0000, 0xFF8D, 0x0035, 0x0000, 0x0000, 0xFF8D, 0x0031,
    0x0000, 0x0000, 0xFF8D, 0x002E, 0x0000, 0x0000, 0xFF8D, 0x002B,
    0x0000, 0x0000, 0xFF8D, 0x0028, 0x0000, 0x0000, 0xFF8D, 0x0024,
    0x0000, 0x0000, 0xFF8D, 0x0021, 0x0000, 0x0000, 0xFF8D, 0x001E,
    0x0000, 0x0000, 0xFF8D, 0x001B, 0x0000, 0x0000, 0xFF8D, 0x0018,
    0x0000, 0x0000, 0xFF8D, 0x0015, 0x0000, 0x0000, 0xFF8D, 0x0013,
    0x0000, 0x0000, 0xFF8D, 0x0010, 0x0000, 0x0000, 0xFF8D, 0x000D,
    0x0000, 0x0000, 0xFF8D, 0x000A, 0x0000, 0x0000, 0xFF8D, 0x0007,
    0x0000, 0x0000, 0xFF8D, 0x0004, 0x0000, 0x0000, 0xFF8D, 0x0001,
    0x0000, 0x0000, 0xFF8D, 0xFFFF, 0x0000, 0x0000, 0xFF8D, 0xFFFC,
    0x0000, 0x0000, 0xFF8D, 0xFFF9, 0x0000, 0x0000, 0xFF8D, 0xFFF6,
    0x0000, 0x0000, 0xFF8D, 0xFFF3, 0x0000, 0x0000, 0xFF8D, 0xFFF0,
    0x0000, 0x0000, 0xFF8D, 0xFFED, 0x0000, 0x0000, 0xFF8D, 0xFFEB,
    0x0000, 0x0000, 0xFF8D, 0xFFE8, 0x0000, 0x0000, 0xFF8D, 0xFFE5,
    0x0000, 0x0000, 0xFF8D, 0xFFE2, 0x0000, 0x0000, 0xFF8D, 0xFFDF,
    0x0000, 0x0000, 0xFF8D, 0xFFDC, 0x0000, 0x0000, 0xFF8D, 0xFFD8,
    0x0000, 0x0000, 0xFF8D, 0xFFD5, 0x0000, 0x0000, 0xFF8D, 0xFFD2,
    0x0000, 0x0000, 0xFF8D, 0xFFCF, 0x0000, 0x0000, 0xFF8D, 0xFFCB,
    0x0000, 0x0000, 0xFF8D, 0xFFC8, 0x0000, 0x0000, 0xFF8D, 0xFFC4,
    0x0000, 0x0000, 0xFF8D, 0xFFC1, 0x0000, 0x0000, 0xFF8D, 0xFFBD,
    0x0000, 0x0000, 0xFF8D, 0xFFB9, 0x0000, 0x0000, 0xFF8D, 0xFFB5,
    0x0000, 0x0000, 0xFF8D, 0xFFB1, 0x0000, 0x0000, 0xFF8D, 0xFFAD,
    0x0000, 0x0000, 0xFF8D, 0xFFA8, 0x0000, 0x0000, 0xFF8D, 0xFFA4,
    0x0000, 0x0000, 0xFF8D, 0xFF9F, 0x0000, 0x0000, 0xFF8D, 0xFF9A,
    0x0000, 0x0000, 0xFF8D, 0xFF95, 0x0000, 0x0000, 0xFF8D, 0xFF90,
    0x0000, 0x0000, 0xFF8D, 0xFF8A, 0x0000, 0x0000, 0xFF8D, 0xFF84,
    0x0000, 0x0000, 0xFF8D, 0xFF7E, 0x0000, 0x0000, 0xFF8D, 0xFF77,
    0x0000, 0x0000, 0xFF8D, 0xFF70, 0x0000, 0x0000, 0xFF8D, 0xFF69,
    0x0000, 0x0000, 0xFF8D, 0xFF61, 0x0000, 0x0000, 0xFF8D, 0xFF58,
    0x0000, 0x0000, 0xFF8D, 0xFF4F, 0x0000, 0x0000, 0xFF8D, 0xFF45,
    0x0000, 0x0000, 0xFF8D, 0xFF3A, 0x0000, 0x0000, 0xFF8D, 0xFF2F,
    0x0000, 0x0000, 0xFF8D, 0xFF22, 0x0000, 0x0000, 0xFF8D, 0xFF14,
    0x0000, 0x0000, 0xFF8D, 0xFF04, 0x0000, 0x0000, 0xFF8D, 0xFEF3,
    0x0000, 0x0000, 0xFF8D, 0xFEE0, 0x0000, 0x0000, 0xFF8D, 0xFECA,
    0x0000, 0x0000, 0xFF8D, 0xFEB1, 0x0000, 0x0000, 0xFF8D, 0xFE94,
    0x0000, 0x0000, 0xFF8D, 0xFE73, 0x0000, 0x0000, 0xFF8D, 0xFE4B,
    0x0000, 0x0000, 0xFF8D, 0xFE1B, 0x0000, 0x0000, 0xFF8D, 0xFDE0,
    0x0000, 0x0000, 0xFF8D, 0xFD95, 0x0000, 0x0000, 0xFF8D, 0xFD34,
    0x0000, 0x0000, 0xFF8D, 0xFCB0, 0x0000, 0x0000, 0xFF8D, 0xFBF1,
    0x0000, 0x0000, 0xFF8D, 0xFAC6, 0x0000, 0x0000, 0xFF8D, 0xF8AD,
    0x0000, 0x0000, 0xFF8D, 0xF3C8, 0x0000, 0x0000, 0xFF8D, 0xDB55
    };

static const q15_t ref_cfft_step_256[512] = {
    0x399A, 0x0000, 0xFF8D, 0x24AB, 0x0000, 0x0000, 0xFF8D, 0x0C38,
    0x0000, 0x0000, 0xFF8D, 0x0753, 0x0000, 0x0000, 0xFF8D, 0x053A,
    0x0000, 0x0000, 0xFF8D, 0x040F, 0x0000, 0x0000, 0xFF8D, 0x0350,
    0x0000, 0x0000, 0xFF8D, 0x02CC, 0x0000, 0x0000, 0xFF8D, 0x026B,
    0x0000, 0x0000, 0xFF8D, 0x0220, 0x0000, 0x0000, 0xFF8D, 0x01E5,
    0x0000, 0x0000, 0xFF8D, 0x01B5, 0x0000, 0x0000, 0xFF8D, 0x018D,
    0x0000, 0x0000, 0xFF8D, 0x016C, 0x0000, 0x0000, 0xFF8D, 0x014F,
    0x0000, 0x0000, 0xFF8D, 0x0136, 0x0000, 0x0000, 0xFF8D, 0x0120,
    0x0000, 0x0000, 0xFF8D, 0x010D, 0x0000, 0x0000, 0xFF8D, 0x00FC,
    0x0000, 0x0000, 0xFF8D, 0x00EC, 0x0000, 0x0000, 0xFF8D, 0x00DE,
    0x0000, 0x0000, 0xFF8D, 0x00D1, 0x0000, 0x0000, 0xFF8D, 0x00C6,
    0x0000, 0x0000, 0xFF8D, 0x00BB, 0x0000, 0x0000, 0xFF8D, 0x00B1,
    0x0000, 0x0000, 0xFF8D, 0x00A8, 0x0000, 0x0000, 0xFF8D, 0x009F,
    0x0000, 0x0000, 0xFF8D, 0x0097, 0x0000, 0x0000, 0xFF8D, 0x0090,
    0x0000, 0x0000, 0xFF8D, 0x0089, 0x0000, 0x0000, 0xFF8D, 0x0082,
    0x0000, 0x0000, 0xFF8D, 0x007C, 0x0000, 0x0000, 0xFF8D, 0x0076,
    0x0000, 0x0000, 0xFF8D, 0x0070, 0x0000, 0x0000, 0xFF8D, 0x006B,
    0x0000, 0x0000, 0xFF8D, 0x0066, 0x0000, 0x0000, 0xFF8D, 0x0061,
    0x0000, 0x0000, 0xFF8D, 0x005C, 0x0000, 0x0000, 0xFF8D, 0x0058,
    0x0000, 0x0000, 0xFF8D, 0x0053, 0x0000, 0x0000, 0xFF8D, 0x004F,
    0x0000, 0x0000, 0xFF8D, 0x004B, 0x0000, 0x0000, 0xFF8D, 0x0047,
    0x0000, 0x0000, 0xFF8D, 0x0043, 0x0000, 0x0000, 0xFF8D, 0x003F,
    0x0000, 0x0000, 0xFF8D, 0x003C, 0x0000, 0x0000, 0xFF8D, 0x0038,
    0x0000, 0x0000, 0xFF8D, 0x0035, 0x0000, 0x0000, 0xFF8D, 0x0031,
    0x0000, 0x0000, 0xFF8D, 0x002E, 0x0000, 0x0000, 0xFF8D, 0x002B,
    0x0000, 0x0000, 0xFF8D, 0x0028, 0x0000, 0x0000, 0xFF8D, 0x0024,
    0x0000, 0x0000, 0xFF8D, 0x0021, 0x0000, 0x0000, 0xFF8D, 0x001E,
    0x0000, 0x0000, 0xFF8D, 0x001B, 0x0000, 0x0000, 0xFF8D, 0x0018,
    0x0000, 0x0000, 0xFF8D, 0x0015, 0x0000, 0x0000, 0xFF8D, 0x0013,
    0x0000, 0x0000, 0xFF8D, 0x0010, 0x0000, 0x0000, 0xFF8D, 0x000D,
    0x0000, 0x0000, 0xFF8D, 0x000A, 0x0000, 0x0000, 0xFF8D, 0x0007,
    0x0000, 0x0000, 0xFF8D, 0x0004, 0x0000, 0x0000, 0xFF8D, 0x0001,
    0x0000, 0x0000, 0xFF8D, 0xFFFF, 0x0000, 0x0000, 0xFF8D, 0xFFFC,
    0x0000, 0x0000, 0xFF8D, 0xFFF9, 0x0000, 0x0000, 0xFF8D, 0xFFF6,
    0x0000, 0x0000, 0xFF8D, 0xFFF3, 0x0000, 0x0000, 0xFF8D, 0xFFF0,
    0x0000, 0x0000, 0xFF8D, 0xFFED, 0x0000, 0x0000, 0xFF8D, 0xFFEB,
    0x0000, 0x0000, 0xFF8D, 0xFFE8, 0x0000, 0x0000, 0xFF8D, 0xFFE5,
    0x0000, 0x0000, 0xFF8D, 0xFFE2, 0x0000, 0x0000, 0xFF8D, 0xFFDF,
    0x0000, 0x0000, 0xFF8D, 0xFFDC, 0x0000, 0x0000, 0xFF8D, 0xFFD8,
    0x0000, 0x0000, 0xFF8D, 0xFFD5, 0x0000, 0x0000, 0xFF8D, 0xFFD2,
    0x0000, 0x0000, 0xFF8D, 0xFFCF, 0x0000, 0x0000, 0xFF8D, 0xFFCB,
    0x0000, 0x0000, 0xFF8D, 0xFFC8, 0x0000, 0x0000, 0xFF8D, 0xFFC4,
    0x0000, 0x0000, 0xFF8D, 0xFFC1, 0x0000, 0x0000, 0xFF8D, 0xFFBD,
    0x0000, 0x0000, 0xFF8D, 0xFFB9, 0x0000, 0x0000, 0xFF8D, 0xFFB5,
    0x0000, 0x0000, 0xFF8D, 0xFFB1, 0x0000, 0x0000, 0xFF8D, 0xFFAD,
    0x0000, 0x0000, 0xFF8D, 0xFFA8, 0x0000, 0x0000, 0xFF8D, 0xFFA4,
    0x0000, 0x0000, 0xFF8D, 0xFF9F, 0x0000, 0x0000, 0xFF8D, 0xFF9A,
    0x0000, 0x0000, 0xFF8D, 0xFF95, 0x0000, 0x0000, 0xFF8D, 0xFF90,
    0x0000, 0x0000, 0xFF8D, 0xFF8A, 0x0000, 0x0000, 0xFF8D, 0xFF84,
    0x0000, 0x0000, 0xFF8D, 0xFF7E, 0x0000, 0x0000, 0xFF8D, 0xFF77,
    0x0000, 0x0000, 0xFF8D, 0xFF70, 0x0000, 0x0000, 0xFF8D, 0xFF69,
    0x0000, 0x0000, 0xFF8D, 0xFF61, 0x0000, 0x0000, 0xFF8D, 0xFF58,
    0x0000, 0x0000, 0xFF8D, 0xFF4F, 0x0000, 0x0000, 0xFF8D, 0xFF45,
    0x0000, 0x0000, 0xFF8D, 0xFF3A, 0x0000, 0x0000, 0xFF8D, 0xFF2F,
    0x0000, 0x0000, 0xFF8D, 0xFF22, 0x0000, 0x0000, 0xFF8D, 0xFF14,
    0x0000, 0x0000, 0xFF8D, 0xFF04, 0x0000, 0x0000, 0xFF8D, 0xFEF3,
    0x0000, 0x0000, 0xFF8D, 0xFEE0, 0x0000, 0x0000, 0xFF8D, 0xFECA,
    0x0000, 0x0000, 0xFF8D, 0xFEB1, 0x0000, 0x0000, 0xFF8D, 0xFE94,
    0x0000, 0x0000, 0xFF8D, 0xFE73, 0x0000, 0x0000, 0xFF8D, 0xFE4B,
    0x0000, 0x0000, 0xFF8D, 0xFE1B, 0x0000, 0x0000, 0xFF8D, 0xFDE0,
    0x0000, 0x0000, 0xFF8D, 0xFD95, 0x0000, 0x0000, 0xFF8D, 0xFD34,
    0x0000, 0x0000, 0xFF8D, 0xFCB0, 0x0000, 0x0000, 0xFF8D, 0xFBF1,
    0x0000, 0x0000, 0xFF8D, 0xFAC6, 0x0000, 0x0000, 0xFF8D, 0xF8AD,
    0x0000, 0x0000, 0xFF8D, 0xF3C8, 0x0000, 0x0000, 0xFF8D, 0xDB55
    };

static const q15_t in_cfft_step_512[1024] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_512[1024] = {
    0x399A, 0x0000, 0xFFC6, 0x24AB, 0x0000, 0x0000, 0xFFC6, 0x0C39,
    0x0000, 0x0000, 0xFFC6, 0x0755, 0x0000, 0x0000, 0xFFC6, 0x053C,
    0x0000, 0x0000, 0xFFC6, 0x0412, 0x0000, 0x0000, 0xFFC6, 0x0354,
    0x0000, 0x0000, 0xFFC6, 0x02D1, 0x0000, 0x0000, 0xFFC6, 0x0270,
    0x0000, 0x0000, 0xFFC6, 0x0226, 0x0000, 0x0000, 0xFFC6, 0x01EC,
    0x0000, 0x0000, 0xFFC6, 0x01BD, 0x0000, 0x0000, 0xFFC6, 0x0195,
    0x0000, 0x0000, 0xFFC6, 0x0175, 0x0000, 0x0000, 0xFFC6, 0x0158,
    0x0000, 0x0000, 0xFFC6, 0x0140, 0x0000, 0x0000, 0xFFC6, 0x012B,
    0x0000, 0x0000, 0xFFC6, 0x0119, 0x0000, 0x0000, 0xFFC6, 0x0108,
    0x0000, 0x0000, 0xFFC6, 0x00F9, 0x0000, 0x0000, 0xFFC6, 0x00EC,
    0x0000, 0x0000, 0xFFC6, 0x00E0, 0x0000, 0x0000, 0xFFC6, 0x00D5,
    0x0000, 0x0000, 0xFFC6, 0x00CB, 0x0000, 0x0000, 0xFFC6, 0x00C2,
    0x0000, 0x0000, 0xFFC6, 0x00BA, 0x0000, 0x0000, 0xFFC6, 0x00B2,
    0x0000, 0x0000, 0xFFC6, 0x00AB, 0x0000, 0x0000, 0xFFC6, 0x00A4,
    0x0000, 0x0000, 0xFFC6, 0x009E, 0x0000, 0x0000, 0xFFC6, 0x0098,
    0x0000, 0x0000, 0xFFC6, 0x0093, 0x0000, 0x0000, 0xFFC6, 0x008E,
    0x0000, 0x0000, 0xFFC6, 0x0089, 0x0000, 0x0000, 0xFFC6, 0x0084,
    0x0000, 0x0000, 0xFFC6, 0x0080, 0x0000, 0x0000, 0xFFC6, 0x007C,
    0x0000, 0x0000, 0xFFC6, 0x0078, 0x0000, 0x0000, 0xFFC6, 0x0074,
    0x0000, 0x0000, 0xFFC6, 0x0071, 0x0000, 0x0000, 0xFFC6, 0x006D,
    0x0000, 0x0000, 0xFFC6, 0x006A, 0x0000, 0x0000, 0xFFC6, 0x0067,
    0x0000, 0x0000, 0xFFC6, 0x0064, 0x0000, 0x0000, 0xFFC6, 0x0061,
    0x0000, 0x0000, 0xFFC6, 0x005F, 0x0000, 0x0000, 0xFFC6, 0x005C,
    0x0000, 0x0000, 0xFFC6, 0x005A, 0x0000, 0x0000, 0xFFC6, 0x0057,
    0x0000, 0x0000, 0xFFC6, 0x0055, 0x0000, 0x0000, 0xFFC6, 0x0053,
    0x0000, 0x0000, 0xFFC6, 0x0051, 0x0000, 0x0000, 0xFFC6, 0x004F,
    0x0000, 0x0000, 0xFFC6, 0x004D, 0x0000, 0x0000, 0xFFC6, 0x004B,
    0x0000, 0x0000, 0xFFC6, 0x0049, 0x0000, 0x0000, 0xFFC6, 0x0047,
    0x0000, 0x0000, 0xFFC6, 0x0045, 0x0000, 0x0000, 0xFFC6, 0x0044,
    0x0000, 0x0000, 0xFFC6, 0x0042, 0x0000, 0x0000, 0xFFC6, 0x0040,
    0x0000, 0x0000, 0xFFC6, 0x003F, 0x0000, 0x0000, 0xFFC6, 0x003D,
    0x0000, 0x0000, 0xFFC6, 0x003C, 0x0000, 0x0000, 0xFFC6, 0x003A,
    0x0000, 0x0000, 0xFFC6, 0x0039, 0x0000, 0x0000, 0xFFC6, 0x0038,
    0x0000, 0x0000, 0xFFC6, 0x0036, 0x0000, 0x0000, 0xFFC6, 0x0035,
    0x0000, 0x0000, 0xFFC6, 0x0034, 0x0000, 0x0000, 0xFFC6, 0x0032,
    0x0000, 0x0000, 0xFFC6, 0x0031, 0x0000, 0x0000, 0xFFC6, 0x0030,
    0x0000, 0x0000, 0xFFC6, 0x002F, 0x0000, 0x0000, 0xFFC6, 0x002E,
    0x0000, 0x0000, 0xFFC6, 0x002C, 0x0000, 0x0000, 0xFFC6, 0x002B,
    0x0000, 0x0000, 0xFFC6, 0x002A, 0x0000, 0x0000, 0xFFC6, 0x0029,
    0x0000, 0x0000, 0xFFC6, 0x0028, 0x0000, 0x0000, 0xFFC6, 0x0027,
    0x0000, 0x0000, 0xFFC6, 0x0026, 0x0000, 0x0000, 0xFFC6, 0x0025,
    0x0000, 0x0000, 0xFFC6, 0x0024, 0x0000, 0x0000, 0xFFC6, 0x0023,
    0x0000, 0x0000, 0xFFC6, 0x0022, 0x0000, 0x0000, 0xFFC6, 0x0021,
    0x0000, 0x0000, 0xFFC6, 0x0020, 0x0000, 0x0000, 0xFFC6, 0x001F,
    0x0000, 0x0000, 0xFFC6, 0x001E, 0x0000, 0x0000, 0xFFC6, 0x001D,
    0x0000, 0x0000, 0xFFC6, 0x001D, 0x0000, 0x0000, 0xFFC6, 0x001C,
    0x0000, 0x0000, 0xFFC6, 0x001B, 0x0000, 0x0000, 0xFFC6, 0x001A,
    0x0000, 0x0000, 0xFFC6, 0x0019, 0x0000, 0x0000, 0xFFC6, 0x0018,
    0x0000, 0x0000, 0xFFC6, 0x0017, 0x0000, 0x0000, 0xFFC6, 0x0017,
    0x0000, 0x0000, 0xFFC6, 0x0016, 0x0000, 0x0000, 0xFFC6, 0x0015,
    0x0000, 0x0000, 0xFFC6, 0x0014, 0x0000, 0x0000, 0xFFC6, 0x0013,
    0x0000, 0x0000, 0xFFC6, 0x0013, 0x0000, 0x0000, 0xFFC6, 0x0012,
    0x0000, 0x0000, 0xFFC6, 0x0011, 0x0000, 0x0000, 0xFFC6, 0x0010,
    0x0000, 0x0000, 0xFFC6, 0x0010, 0x0000, 0x0000, 0xFFC6, 0x000F,
    0x0000, 0x0000, 0xFFC6, 0x000E, 0x0000, 0x0000, 0xFFC6, 0x000D,
    0x0000, 0x0000, 0xFFC6, 0x000D, 0x0000, 0x0000, 0xFFC6, 0x000C,
    0x0000, 0x0000, 0xFFC6, 0x000B, 0x0000, 0x0000, 0xFFC6, 0x000A,
    0x0000, 0x0000, 0xFFC6, 0x000A, 0x0000, 0x0000, 0xFFC6, 0x0009,
    0x0000, 0x0000, 0xFFC6, 0x0008, 0x0000, 0x0000, 0xFFC6, 0x0007,
    0x0000, 0x0000, 0xFFC6, 0x0007, 0x0000, 0x0000, 0xFFC6, 0x0006,
    0x0000, 0x0000, 0xFFC6, 0x0005, 0x0000, 0x0000, 0xFFC6, 0x0005,
    0x0000, 0x0000, 0xFFC6, 0x0004, 0x0000, 0x0000, 0xFFC6, 0x0003,
    0x0000, 0x0000, 0xFFC6, 0x0002, 0x0000, 0x0000, 0xFFC6, 0x0002,
    0x0000, 0x0000, 0xFFC6, 0x0001, 0x0000, 0x0000, 0xFFC6, 0x0000,
    0x0000, 0x0000, 0xFFC6, 0x0000, 0x0000, 0x0000, 0xFFC6, 0xFFFF,
    0x0000, 0x0000, 0xFFC6, 0xFFFE, 0x0000, 0x0000, 0xFFC6, 0xFFFE,
    0x0000, 0x0000, 0xFFC6, 0xFFFD, 0x0000, 0x0000, 0xFFC6, 0xFFFC,
    0x0000, 0x0000, 0xFFC6, 0xFFFB, 0x0000, 0x0000, 0xFFC6, 0xFFFB,
    0x0000, 0x0000, 0xFFC6, 0xFFFA, 0x0000, 0x0000, 0xFFC6, 0xFFF9,
    0x0000, 0x0000, 0xFFC6, 0xFFF9, 0x0000, 0x0000, 0xFFC6, 0xFFF8,
    0x0000, 0x0000, 0xFFC6, 0xFFF7, 0x0000, 0x0000, 0xFFC6, 0xFFF6,
    0x0000, 0x0000, 0xFFC6, 0xFFF6, 0x0000, 0x0000, 0xFFC6, 0xFFF5,
    0x0000, 0x0000, 0xFFC6, 0xFFF4, 0x0000, 0x0000, 0xFFC6, 0xFFF3,
    0x0000, 0x0000, 0xFFC6, 0xFFF3, 0x0000, 0x0000, 0xFFC6, 0xFFF2,
    0x0000, 0x0000, 0xFFC6, 0xFFF1, 0x0000, 0x0000, 0xFFC6, 0xFFF0,
    0x0000, 0x0000, 0xFFC6, 0xFFF0, 0x0000, 0x0000, 0xFFC6, 0xFFEF,
    0x0000, 0x0000, 0xFFC6, 0xFFEE, 0x0000, 0x0000, 0xFFC6, 0xFFED,
    0x0000, 0x0000, 0xFFC6, 0xFFED, 0x0000, 0x0000, 0xFFC6, 0xFFEC,
    0x0000, 0x0000, 0xFFC6, 0xFFEB, 0x0000, 0x0000, 0xFFC6, 0xFFEA,
    0x0000, 0x0000, 0xFFC6, 0xFFE9, 0x0000, 0x0000, 0xFFC6, 0xFFE9,
    0x0000, 0x0000, 0xFFC6, 0xFFE8, 0x0000, 0x0000, 0xFFC6, 0xFFE7,
    0x0000, 0x0000, 0xFFC6, 0xFFE6, 0x0000, 0x0000, 0xFFC6, 0xFFE5,
    0x0000, 0x0000, 0xFFC6, 0xFFE4, 0x0000, 0x0000, 0xFFC6, 0xFFE3,
    0x0000, 0x0000, 0xFFC6, 0xFFE3, 0x0000, 0x0000, 0xFFC6, 0xFFE2,
    0x0000, 0x0000, 0xFFC6, 0xFFE1, 0x0000, 0x0000, 0xFFC6, 0xFFE0,
    0x0000, 0x0000, 0xFFC6, 0xFFDF, 0x0000, 0x0000, 0xFFC6, 0xFFDE,
    0x0000, 0x0000, 0xFFC6, 0xFFDD, 0x0000, 0x0000, 0xFFC6, 0xFFDC,
    0x0000, 0x0000, 0xFFC6, 0xFFDB, 0x0000, 0x0000, 0xFFC6, 0xFFDA,
    0x0000, 0x0000, 0xFFC6, 0xFFD9, 0x0000, 0x0000, 0xFFC6, 0xFFD8,
    0x0000, 0x0000, 0xFFC6, 0xFFD7, 0x0000, 0x0000, 0xFFC6, 0xFFD6,
    0x0000, 0x0000, 0xFFC6, 0xFFD5, 0x0000, 0x0000, 0xFFC6, 0xFFD4,
    0x0000, 0x0000, 0xFFC6, 0xFFD2, 0x0000, 0x0000, 0xFFC6, 0xFFD1,
    0x0000, 0x0000, 0xFFC6, 0xFFD0, 0x0000, 0x0000, 0xFFC6, 0xFFCF,
    0x0000, 0x0000, 0xFFC6, 0xFFCE, 0x0000, 0x0000, 0xFFC6, 0xFFCC,
    0x0000, 0x0000, 0xFFC6, 0xFFCB, 0x0000, 0x0000, 0xFFC6, 0xFFCA,
    0x0000, 0x0000, 0xFFC6, 0xFFC8, 0x0000, 0x0000, 0xFFC6, 0xFFC7,
    0x0000, 0x0000, 0xFFC6, 0xFFC6, 0x0000, 0x0000, 0xFFC6, 0xFFC4,
    0x0000, 0x0000, 0xFFC6, 0xFFC3, 0x0000, 0x0000, 0xFFC6, 0xFFC1,
    0x0000, 0x0000, 0xFFC6, 0xFFC0, 0x0000, 0x0000, 0xFFC6, 0xFFBE,
    0x0000, 0x0000, 0xFFC6, 0xFFBC, 0x0000, 0x0000, 0xFFC6, 0xFFBB,
    0x0000, 0x0000, 0xFFC6, 0xFFB9, 0x0000, 0x0000, 0xFFC6, 0xFFB7,
    0x0000, 0x0000, 0xFFC6, 0xFFB5, 0x0000, 0x0000, 0xFFC6, 0xFFB3,
    0x0000, 0x0000, 0xFFC6, 0xFFB1, 0x0000, 0x0000, 0xFFC6, 0xFFAF,
    0x0000, 0x0000, 0xFFC6, 0xFFAD, 0x0000, 0x0000, 0xFFC6, 0xFFAB,
    0x0000, 0x0000, 0xFFC6, 0xFFA9, 0x0000, 0x0000, 0xFFC6, 0xFFA6,
    0x0000, 0x0000, 0xFFC6, 0xFFA4, 0x0000, 0x0000, 0xFFC6, 0xFFA1,
    0x0000, 0x0000, 0xFFC6, 0xFF9F, 0x0000, 0x0000, 0xFFC6, 0xFF9C,
    0x0000, 0x0000, 0xFFC6, 0xFF99, 0x0000, 0x0000, 0xFFC6, 0xFF96,
    0x0000, 0x0000, 0xFFC6, 0xFF93, 0x0000, 0x0000, 0xFFC6, 0xFF8F,
    0x0000, 0x0000, 0xFFC6, 0xFF8C, 0x0000, 0x0000, 0xFFC6, 0xFF88,
    0x0000, 0x0000, 0xFFC6, 0xFF84, 0x0000, 0x0000, 0xFFC6, 0xFF80,
    0x0000, 0x0000, 0xFFC6, 0xFF7C, 0x0000, 0x0000, 0xFFC6, 0xFF77,
    0x0000, 0x0000, 0xFFC6, 0xFF72, 0x0000, 0x0000, 0xFFC6, 0xFF6D,
    0x0000, 0x0000, 0xFFC6, 0xFF68, 0x0000, 0x0000, 0xFFC6, 0xFF62,
    0x0000, 0x0000, 0xFFC6, 0xFF5C, 0x0000, 0x0000, 0xFFC6, 0xFF55,
    0x0000, 0x0000, 0xFFC6, 0xFF4E, 0x0000, 0x0000, 0xFFC6, 0xFF46,
    0x0000, 0x0000, 0xFFC6, 0xFF3E, 0x0000, 0x0000, 0xFFC6, 0xFF35,
    0x0000, 0x0000, 0xFFC6, 0xFF2B, 0x0000, 0x0000, 0xFFC6, 0xFF20,
    0x0000, 0x0000, 0xFFC6, 0xFF14, 0x0000, 0x0000, 0xFFC6, 0xFF07,
    0x0000, 0x0000, 0xFFC6, 0xFEF8, 0x0000, 0x0000, 0xFFC6, 0xFEE7,
    0x0000, 0x0000, 0xFFC6, 0xFED5, 0x0000, 0x0000, 0xFFC6, 0xFEC0,
    0x0000, 0x0000, 0xFFC6, 0xFEA8, 0x0000, 0x0000, 0xFFC6, 0xFE8B,
    0x0000, 0x0000, 0xFFC6, 0xFE6B, 0x0000, 0x0000, 0xFFC6, 0xFE43,
    0x0000, 0x0000, 0xFFC6, 0xFE14, 0x0000, 0x0000, 0xFFC6, 0xFDDA,
    0x0000, 0x0000, 0xFFC6, 0xFD90, 0x0000, 0x0000, 0xFFC6, 0xFD2F,
    0x0000, 0x0000, 0xFFC6, 0xFCAC, 0x0000, 0x0000, 0xFFC6, 0xFBEE,
    0x0000, 0x0000, 0xFFC6, 0xFAC4, 0x0000, 0x0000, 0xFFC6, 0xF8AB,
    0x0000, 0x0000, 0xFFC6, 0xF3C7, 0x0000, 0x0000, 0xFFC6, 0xDB55
    };

static const q15_t ref_cfft_step_512[1024] = {
    0x399A, 0x0000, 0xFFC6, 0x24AB, 0x0000, 0x0000, 0xFFC6, 0x0C39,
    0x0000, 0x0000, 0xFFC6, 0x0755, 0x0000, 0x0000, 0xFFC6, 0x053C,
    0x0000, 0x0000, 0xFFC6, 0x0412, 0x0000, 0x0000, 0xFFC6, 0x0354,
    0x0000, 0x0000, 0xFFC6, 0x02D1, 0x0000, 0x0000, 0xFFC6, 0x0270,
    0x0000, 0x0000, 0xFFC6, 0x0226, 0x0000, 0x0000, 0xFFC6, 0x01EC,
    0x0000, 0x0000, 0xFFC6, 0x01BD, 0x0000, 0x0000, 0xFFC6, 0x0195,
    0x0000, 0x0000, 0xFFC6, 0x0175, 0x0000, 0x0000, 0xFFC6, 0x0158,
    0x0000, 0x0000, 0xFFC6, 0x0140, 0x0000, 0x0000, 0xFFC6, 0x012B,
    0x0000, 0x0000, 0xFFC6, 0x0119, 0x0000, 0x0000, 0xFFC6, 0x0108,
    0x0000, 0x0000, 0xFFC6, 0x00F9, 0x0000, 0x0000, 0xFFC6, 0x00EC,
    0x0000, 0x0000, 0xFFC6, 0x00E0, 0x0000, 0x0000, 0xFFC6, 0x00D5,
    0x0000, 0x0000, 0xFFC6, 0x00CB, 0x0000, 0x0000, 0xFFC6, 0x00C2,
    0x0000, 0x0000, 0xFFC6, 0x00BA, 0x0000, 0x0000, 0xFFC6, 0x00B2,
    0x0000, 0x0000, 0xFFC6, 0x00AB, 0x0000, 0x0000, 0xFFC6, 0x00A4,
    0x0000, 0x0000, 0xFFC6, 0x009E, 0x0000, 0x0000, 0xFFC6, 0x0098,
    0x0000, 0x0000, 0xFFC6, 0x0093, 0x0000, 0x0000, 0xFFC6, 0x008E,
    0x0000, 0x0000, 0xFFC6, 0x0089, 0x0000, 0x0000, 0xFFC6, 0x0084,
    0x0000, 0x0000, 0xFFC6, 0x0080, 0x0000, 0x0000, 0xFFC6, 0x007C,
    0x0000, 0x0000, 0xFFC6, 0x0078, 0x0000, 0x0000, 0xFFC6, 0x0074,
    0x0000, 0x0000, 0xFFC6, 0x0071, 0x0000, 0x0000, 0xFFC6, 0x006D,
    0x0000, 0x0000, 0xFFC6, 0x006A, 0x0000, 0x0000, 0xFFC6, 0x0067,
    0x0000, 0x0000, 0xFFC6, 0x0064, 0x0000, 0x0000, 0xFFC6, 0x0061,
    0x0000, 0x0000, 0xFFC6, 0x005F, 0x0000, 0x0000, 0xFFC6, 0x005C,
    0x0000, 0x0000, 0xFFC6, 0x005A, 0x0000, 0x0000, 0xFFC6, 0x0057,
    0x0000, 0x0000, 0xFFC6, 0x0055, 0x0000, 0x0000, 0xFFC6, 0x0053,
    0x0000, 0x0000, 0xFFC6, 0x0051, 0x0000, 0x0000, 0xFFC6, 0x004F,
    0x0000, 0x0000, 0xFFC6, 0x004D, 0x0000, 0x0000, 0xFFC6, 0x004B,
    0x0000, 0x0000, 0xFFC6, 0x0049, 0x0000, 0x0000, 0xFFC6, 0x0047,
    0x0000, 0x0000, 0xFFC6, 0x0045, 0x0000, 0x0000, 0xFFC6, 0x0044,
    0x0000, 0x0000, 0xFFC6, 0x0042, 0x0000, 0x0000, 0xFFC6, 0x0040,
    0x0000, 0x0000, 0xFFC6, 0x003F, 0x0000, 0x0000, 0xFFC6, 0x003D,
    0x0000, 0x0000, 0xFFC6, 0x003C, 0x0000, 0x0000, 0xFFC6, 0x003A,
    0x0000, 0x0000, 0xFFC6, 0x0039, 0x0000, 0x0000, 0xFFC6, 0x0038,
    0x0000, 0x0000, 0xFFC6, 0x0036, 0x0000, 0x0000, 0xFFC6, 0x0035,
    0x0000, 0x0000, 0xFFC6, 0x0034, 0x0000, 0x0000, 0xFFC6, 0x0032,
    0x0000, 0x0000, 0xFFC6, 0x0031, 0x0000, 0x0000, 0xFFC6, 0x0030,
    0x0000, 0x0000, 0xFFC6, 0x002F, 0x0000, 0x0000, 0xFFC6, 0x002E,
    0x0000, 0x0000, 0xFFC6, 0x002C, 0x0000, 0x0000, 0xFFC6, 0x002B,
    0x0000, 0x0000, 0xFFC6, 0x002A, 0x0000, 0x0000, 0xFFC6, 0x0029,
    0x0000, 0x0000, 0xFFC6, 0x0028, 0x0000, 0x0000, 0xFFC6, 0x0027,
    0x0000, 0x0000, 0xFFC6, 0x0026, 0x0000, 0x0000, 0xFFC6, 0x0025,
    0x0000, 0x0000, 0xFFC6, 0x0024, 0x0000, 0x0000, 0xFFC6, 0x0023,
    0x0000, 0x0000, 0xFFC6, 0x0022, 0x0000, 0x0000, 0xFFC6, 0x0021,
    0x0000, 0x0000, 0xFFC6, 0x0020, 0x0000, 0x0000, 0xFFC6, 0x001F,
    0x0000, 0x0000, 0xFFC6, 0x001E, 0x0000, 0x0000, 0xFFC6, 0x001D,
    0x0000, 0x0000, 0xFFC6, 0x001D, 0x0000, 0x0000, 0xFFC6, 0x001C,
    0x0000, 0x0000, 0xFFC6, 0x001B, 0x0000, 0x0000, 0xFFC6, 0x001A,
    0x0000, 0x0000, 0xFFC6, 0x0019, 0x0000, 0x0000, 0xFFC6, 0x0018,
    0x0000, 0x0000, 0xFFC6, 0x0017, 0x0000, 0x0000, 0xFFC6, 0x0017,
    0x0000, 0x0000, 0xFFC6, 0x0016, 0x0000, 0x0000, 0xFFC6, 0x0015,
    0x0000, 0x0000, 0xFFC6, 0x0014, 0x0000, 0x0000, 0xFFC6, 0x0013,
    0x0000, 0x0000, 0xFFC6, 0x0013, 0x0000, 0x0000, 0xFFC6, 0x0012,
    0x0000, 0x0000, 0xFFC6, 0x0011, 0x0000, 0x0000, 0xFFC6, 0x0010,
    0x0000, 0x0000, 0xFFC6, 0x0010, 0x0000, 0x0000, 0xFFC6, 0x000F,
    0x0000, 0x0000, 0xFFC6, 0x000E, 0x0000, 0x0000, 0xFFC6, 0x000D,
    0x0000, 0x0000, 0xFFC6, 0x000D, 0x0000, 0x0000, 0xFFC6, 0x000C,
    0x0000, 0x0000, 0xFFC6, 0x000B, 0x0000, 0x0000, 0xFFC6, 0x000A,
    0x0000, 0x0000, 0xFFC6, 0x000A, 0x0000, 0x0000, 0xFFC6, 0x0009,
    0x0000, 0x0000, 0xFFC6, 0x0008, 0x0000, 0x0000, 0xFFC6, 0x0007,
    0x0000, 0x0000, 0xFFC6, 0x0007, 0x0000, 0x0000, 0xFFC6, 0x0006,
    0x0000, 0x0000, 0xFFC6, 0x0005, 0x0000, 0x0000, 0xFFC6, 0x0005,
    0x0000, 0x0000, 0xFFC6, 0x0004, 0x0000, 0x0000, 0xFFC6, 0x0003,
    0x0000, 0x0000, 0xFFC6, 0x0002, 0x0000, 0x0000, 0xFFC6, 0x0002,
    0x0000, 0x0000, 0xFFC6, 0x0001, 0x0000, 0x0000, 0xFFC6, 0x0000,
    0x0000, 0x0000, 0xFFC6, 0x0000, 0x0000, 0x0000, 0xFFC6, 0xFFFF,
    0x0000, 0x0000, 0xFFC6, 0xFFFE, 0x0000, 0x0000, 0xFFC6, 0xFFFE,
    0x0000, 0x0000, 0xFFC6, 0xFFFD, 0x0000, 0x0000, 0xFFC6, 0xFFFC,
    0x0000, 0x0000, 0xFFC6, 0xFFFB, 0x0000, 0x0000, 0xFFC6, 0xFFFB,
    0x0000, 0x0000, 0xFFC6, 0xFFFA, 0x0000, 0x0000, 0xFFC6, 0xFFF9,
    0x0000, 0x0000, 0xFFC6, 0xFFF9, 0x0000, 0x0000, 0xFFC6, 0xFFF8,
    0x0000, 0x0000, 0xFFC6, 0xFFF7, 0x0000, 0x0000, 0xFFC6, 0xFFF6,
    0x0000, 0x0000, 0xFFC6, 0xFFF6, 0x0000, 0x0000, 0xFFC6, 0xFFF5,
    0x0000, 0x0000, 0xFFC6, 0xFFF4, 0x0000, 0x0000, 0xFFC6, 0xFFF3,
    0x0000, 0x0000, 0xFFC6, 0xFFF3, 0x0000, 0x0000, 0xFFC6, 0xFFF2,
    0x0000, 0x0000, 0xFFC6, 0xFFF1, 0x0000, 0x0000, 0xFFC6, 0xFFF0,
    0x0000, 0x0000, 0xFFC6, 0xFFF0, 0x0000, 0x0000, 0xFFC6, 0xFFEF,
    0x0000, 0x0000, 0xFFC6, 0xFFEE, 0x0000, 0x0000, 0xFFC6, 0xFFED,
    0x0000, 0x0000, 0xFFC6, 0xFFED, 0x0000, 0x0000, 0xFFC6, 0xFFEC,
    0x0000, 0x0000, 0xFFC6, 0xFFEB, 0x0000, 0x0000, 0xFFC6, 0xFFEA,
    0x0000, 0x0000, 0xFFC6, 0xFFE9, 0x0000, 0x0000, 0xFFC6, 0xFFE9,
    0x0000, 0x0000, 0xFFC6, 0xFFE8, 0x0000, 0x0000, 0xFFC6, 0xFFE7,
    0x0000, 0x0000, 0xFFC6, 0xFFE6, 0x0000, 0x0000, 0xFFC6, 0xFFE5,
    0x0000, 0x0000, 0xFFC6, 0xFFE4, 0x0000, 0x0000, 0xFFC6, 0xFFE3,
    0x0000, 0x0000, 0xFFC6, 0xFFE3, 0x0000, 0x0000, 0xFFC6, 0xFFE2,
    0x0000, 0x0000, 0xFFC6, 0xFFE1, 0x0000, 0x0000, 0xFFC6, 0xFFE0,
    0x0000, 0x0000, 0xFFC6, 0xFFDF, 0x0000, 0x0000, 0xFFC6, 0xFFDE,
    0x0000, 0x0000, 0xFFC6, 0xFFDD, 0x0000, 0x0000, 0xFFC6, 0xFFDC,
    0x0000, 0x0000, 0xFFC6, 0xFFDB, 0x0000, 0x0000, 0xFFC6, 0xFFDA,
    0x0000, 0x0000, 0xFFC6, 0xFFD9, 0x0000, 0x0000, 0xFFC6, 0xFFD8,
    0x0000, 0x0000, 0xFFC6, 0xFFD7, 0x0000, 0x0000, 0xFFC6, 0xFFD6,
    0x0000, 0x0000, 0xFFC6, 0xFFD5, 0x0000, 0x0000, 0xFFC6, 0xFFD4,
    0x0000, 0x0000, 0xFFC6, 0xFFD2, 0x0000, 0x0000, 0xFFC6, 0xFFD1,
    0x0000, 0x0000, 0xFFC6, 0xFFD0, 0x0000, 0x0000, 0xFFC6, 0xFFCF,
    0x0000, 0x0000, 0xFFC6, 0xFFCE, 0x0000, 0x0000, 0xFFC6, 0xFFCC,
    0x0000, 0x0000, 0xFFC6, 0xFFCB, 0x0000, 0x0000, 0xFFC6, 0xFFCA,
    0x0000, 0x0000, 0xFFC6, 0xFFC8, 0x0000, 0x0000, 0xFFC6, 0xFFC7,
    0x0000, 0x0000, 0xFFC6, 0xFFC6, 0x0000, 0x0000, 0xFFC6, 0xFFC4,
    0x0000, 0x0000, 0xFFC6, 0xFFC3, 0x0000, 0x0000, 0xFFC6, 0xFFC1,
    0x0000, 0x0000, 0xFFC6, 0xFFC0, 0x0000, 0x0000, 0xFFC6, 0xFFBE,
    0x0000, 0x0000, 0xFFC6, 0xFFBC, 0x0000, 0x0000, 0xFFC6, 0xFFBB,
    0x0000, 0x0000, 0xFFC6, 0xFFB9, 0x0000, 0x0000, 0xFFC6, 0xFFB7,
    0x0000, 0x0000, 0xFFC6, 0xFFB5, 0x0000, 0x0000, 0xFFC6, 0xFFB3,
    0x0000, 0x0000, 0xFFC6, 0xFFB1, 0x0000, 0x0000, 0xFFC6, 0xFFAF,
    0x0000, 0x0000, 0xFFC6, 0xFFAD, 0x0000, 0x0000, 0xFFC6, 0xFFAB,
    0x0000, 0x0000, 0xFFC6, 0xFFA9, 0x0000, 0x0000, 0xFFC6, 0xFFA6,
    0x0000, 0x0000, 0xFFC6, 0xFFA4, 0x0000, 0x0000, 0xFFC6, 0xFFA1,
    0x0000, 0x0000, 0xFFC6, 0xFF9F, 0x0000, 0x0000, 0xFFC6, 0xFF9C,
    0x0000, 0x0000, 0xFFC6, 0xFF99, 0x0000, 0x0000, 0xFFC6, 0xFF96,
    0x0000, 0x0000, 0xFFC6, 0xFF93, 0x0000, 0x0000, 0xFFC6, 0xFF8F,
    0x0000, 0x0000, 0xFFC6, 0xFF8C, 0x0000, 0x0000, 0xFFC6, 0xFF88,
    0x0000, 0x0000, 0xFFC6, 0xFF84, 0x0000, 0x0000, 0xFFC6, 0xFF80,
    0x0000, 0x0000, 0xFFC6, 0xFF7C, 0x0000, 0x0000, 0xFFC6, 0xFF77,
    0x0000, 0x0000, 0xFFC6, 0xFF72, 0x0000, 0x0000, 0xFFC6, 0xFF6D,
    0x0000, 0x0000, 0xFFC6, 0xFF68, 0x0000, 0x0000, 0xFFC6, 0xFF62,
    0x0000, 0x0000, 0xFFC6, 0xFF5C, 0x0000, 0x0000, 0xFFC6, 0xFF55,
    0x0000, 0x0000, 0xFFC6, 0xFF4E, 0x0000, 0x0000, 0xFFC6, 0xFF46,
    0x0000, 0x0000, 0xFFC6, 0xFF3E, 0x0000, 0x0000, 0xFFC6, 0xFF35,
    0x0000, 0x0000, 0xFFC6, 0xFF2B, 0x0000, 0x0000, 0xFFC6, 0xFF20,
    0x0000, 0x0000, 0xFFC6, 0xFF14, 0x0000, 0x0000, 0xFFC6, 0xFF07,
    0x0000, 0x0000, 0xFFC6, 0xFEF8, 0x0000, 0x0000, 0xFFC6, 0xFEE7,
    0x0000, 0x0000, 0xFFC6, 0xFED5, 0x0000, 0x0000, 0xFFC6, 0xFEC0,
    0x0000, 0x0000, 0xFFC6, 0xFEA8, 0x0000, 0x0000, 0xFFC6, 0xFE8B,
    0x0000, 0x0000, 0xFFC6, 0xFE6B, 0x0000, 0x0000, 0xFFC6, 0xFE43,
    0x0000, 0x0000, 0xFFC6, 0xFE14, 0x0000, 0x0000, 0xFFC6, 0xFDDA,
    0x0000, 0x0000, 0xFFC6, 0xFD90, 0x0000, 0x0000, 0xFFC6, 0xFD2F,
    0x0000, 0x0000, 0xFFC6, 0xFCAC, 0x0000, 0x0000, 0xFFC6, 0xFBEE,
    0x0000, 0x0000, 0xFFC6, 0xFAC4, 0x0000, 0x0000, 0xFFC6, 0xF8AB,
    0x0000, 0x0000, 0xFFC6, 0xF3C7, 0x0000, 0x0000, 0xFFC6, 0xDB55
    };

static const q15_t in_cfft_step_1024[2048] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_1024[2048] = {
    0x399A, 0x0000, 0xFFE3, 0x24AB, 0x0000, 0x0000, 0xFFE3, 0x0C39,
    0x0000, 0x0000, 0xFFE3, 0x0755, 0x0000, 0x0000, 0xFFE3, 0x053D,
    0x0000, 0x0000, 0xFFE3, 0x0413, 0x0000, 0x0000, 0xFFE3, 0x0355,
    0x0000, 0x0000, 0xFFE3, 0x02D2, 0x0000, 0x0000, 0xFFE3, 0x0271,
    0x0000, 0x0000, 0xFFE3, 0x0228, 0x0000, 0x0000, 0xFFE3, 0x01EE,
    0x0000, 0x0000, 0xFFE3, 0x01BE, 0x0000, 0x0000, 0xFFE3, 0x0197,
    0x0000, 0x0000, 0xFFE3, 0x0177, 0x0000, 0x0000, 0xFFE3, 0x015B,
    0x0000, 0x0000, 0xFFE3, 0x0143, 0x0000, 0x0000, 0xFFE3, 0x012E,
    0x0000, 0x0000, 0xFFE3, 0x011B, 0x0000, 0x0000, 0xFFE3, 0x010B,
    0x0000, 0x0000, 0xFFE3, 0x00FD, 0x0000, 0x0000, 0xFFE3, 0x00F0,
    0x0000, 0x0000, 0xFFE3, 0x00E4, 0x0000, 0x0000, 0xFFE3, 0x00D9,
    0x0000, 0x0000, 0xFFE3, 0x00CF, 0x0000, 0x0000, 0xFFE3, 0x00C6,
    0x0000, 0x0000, 0xFFE3, 0x00BE, 0x0000, 0x0000, 0xFFE3, 0x00B7,
    0x0000, 0x0000, 0xFFE3, 0x00B0, 0x0000, 0x0000, 0xFFE3, 0x00A9,
    0x0000, 0x0000, 0xFFE3, 0x00A3, 0x0000, 0x0000, 0xFFE3, 0x009D,
    0x0000, 0x0000, 0xFFE3, 0x0098, 0x0000, 0x0000, 0xFFE3, 0x0093,
    0x0000, 0x0000, 0xFFE3, 0x008F, 0x0000, 0x0000, 0xFFE3, 0x008A,
    0x0000, 0x0000, 0xFFE3, 0x0086, 0x0000, 0x0000, 0xFFE3, 0x0082,
    0x0000, 0x0000, 0xFFE3, 0x007E, 0x0000, 0x0000, 0xFFE3, 0x007B,
    0x0000, 0x0000, 0xFFE3, 0x0078, 0x0000, 0x0000, 0xFFE3, 0x0074,
    0x0000, 0x0000, 0xFFE3, 0x0071, 0x0000, 0x0000, 0xFFE3, 0x006F,
    0x0000, 0x0000, 0xFFE3, 0x006C, 0x0000, 0x0000, 0xFFE3, 0x0069,
    0x0000, 0x0000, 0xFFE3, 0x0067, 0x0000, 0x0000, 0xFFE3, 0x0064,
    0x0000, 0x0000, 0xFFE3, 0x0062, 0x0000, 0x0000, 0xFFE3, 0x0060,
    0x0000, 0x0000, 0xFFE3, 0x005E, 0x0000, 0x0000, 0xFFE3, 0x005C,
    0x0000, 0x0000, 0xFFE3, 0x005A, 0x0000, 0x0000, 0xFFE3, 0x0058,
    0x0000, 0x0000, 0xFFE3, 0x0056, 0x0000, 0x0000, 0xFFE3, 0x0055,
    0x0000, 0x0000, 0xFFE3, 0x0053, 0x0000, 0x0000, 0xFFE3, 0x0051,
    0x0000, 0x0000, 0xFFE3, 0x0050, 0x0000, 0x0000, 0xFFE3, 0x004E,
    0x0000, 0x0000, 0xFFE3, 0x004D, 0x0000, 0x0000, 0xFFE3, 0x004B,
    0x0000, 0x0000, 0xFFE3, 0x004A, 0x0000, 0x0000, 0xFFE3, 0x0049,
    0x0000, 0x0000, 0xFFE3, 0x0047, 0x0000, 0x0000, 0xFFE3, 0x0046,
    0x0000, 0x0000, 0xFFE3, 0x0045, 0x0000, 0x0000, 0xFFE3, 0x0044,
    0x0000, 0x0000, 0xFFE3, 0x0043, 0x0000, 0x0000, 0xFFE3, 0x0042,
    0x0000, 0x0000, 0xFFE3, 0x0040, 0x0000, 0x0000, 0xFFE3, 0x003F,
    0x0000, 0x0000, 0xFFE3, 0x003E, 0x0000, 0x0000, 0xFFE3, 0x003D,
    0x0000, 0x0000, 0xFFE3, 0x003C, 0x0000, 0x0000, 0xFFE3, 0x003B,
    0x0000, 0x0000, 0xFFE3, 0x003B, 0x0000, 0x0000, 0xFFE3, 0x003A,
    0x0000, 0x0000, 0xFFE3, 0x0039, 0x0000, 0x0000, 0xFFE3, 0x0038,
    0x0000, 0x0000, 0xFFE3, 0x0037, 0x0000, 0x0000, 0xFFE3, 0x0036,
    0x0000, 0x0000, 0xFFE3, 0x0035, 0x0000, 0x0000, 0xFFE3, 0x0035,
    0x0000, 0x0000, 0xFFE3, 0x0034, 0x0000, 0x0000, 0xFFE3, 0x0033,
    0x0000, 0x0000, 0xFFE3, 0x0032, 0x0000, 0x0000, 0xFFE3, 0x0032,
    0x0000, 0x0000, 0xFFE3, 0x0031, 0x0000, 0x0000, 0xFFE3, 0x0030,
    0x0000, 0x0000, 0xFFE3, 0x0030, 0x0000, 0x0000, 0xFFE3, 0x002F,
    0x0000, 0x0000, 0xFFE3, 0x002E, 0x0000, 0x0000, 0xFFE3, 0x002E,
    0x0000, 0x0000, 0xFFE3, 0x002D, 0x0000, 0x0000, 0xFFE3, 0x002D,
    0x0000, 0x0000, 0xFFE3, 0x002C, 0x0000, 0x0000, 0xFFE3, 0x002B,
    0x0000, 0x0000, 0xFFE3, 0x002B, 0x0000, 0x0000, 0xFFE3, 0x002A,
    0x0000, 0x0000, 0xFFE3, 0x002A, 0x0000, 0x0000, 0xFFE3, 0x0029,
    0x0000, 0x0000, 0xFFE3, 0x0029, 0x0000, 0x0000, 0xFFE3, 0x0028,
    0x0000, 0x0000, 0xFFE3, 0x0028, 0x0000, 0x0000, 0xFFE3, 0x0027,
    0x0000, 0x0000, 0xFFE3, 0x0027, 0x0000, 0x0000, 0xFFE3, 0x0026,
    0x0000, 0x0000, 0xFFE3, 0x0026, 0x0000, 0x0000, 0xFFE3, 0x0025,
    0x0000, 0x0000, 0xFFE3, 0x0025, 0x0000, 0x0000, 0xFFE3, 0x0024,
    0x0000, 0x0000, 0xFFE3, 0x0024, 0x0000, 0x0000, 0xFFE3, 0x0023,
    0x0000, 0x0000, 0xFFE3, 0x0023, 0x0000, 0x0000, 0xFFE3, 0x0022,
    0x0000, 0x0000, 0xFFE3, 0x0022, 0x0000, 0x0000, 0xFFE3, 0x0022,
    0x0000, 0x0000, 0xFFE3, 0x0021, 0x0000, 0x0000, 0xFFE3, 0x0021,
    0x0000, 0x0000, 0xFFE3, 0x0020, 0x0000, 0x0000, 0xFFE3, 0x0020,
    0x0000, 0x0000, 0xFFE3, 0x0020, 0x0000, 0x0000, 0xFFE3, 0x001F,
    0x0000, 0x0000, 0xFFE3, 0x001F, 0x0000, 0x0000, 0xFFE3, 0x001E,
    0x0000, 0x0000, 0xFFE3, 0x001E, 0x0000, 0x0000, 0xFFE3, 0x001E,
    0x0000, 0x0000, 0xFFE3, 0x001D, 0x0000, 0x0000, 0xFFE3, 0x001D,
    0x0000, 0x0000, 0xFFE3, 0x001D, 0x0000, 0x0000, 0xFFE3, 0x001C,
    0x0000, 0x0000, 0xFFE3, 0x001C, 0x0000, 0x0000, 0xFFE3, 0x001C,
    0x0000, 0x0000, 0xFFE3, 0x001B, 0x0000, 0x0000, 0xFFE3, 0x001B,
    0x0000, 0x0000, 0xFFE3, 0x001B, 0x0000, 0x0000, 0xFFE3, 0x001A,
    0x0000, 0x0000, 0xFFE3, 0x001A, 0x0000, 0x0000, 0xFFE3, 0x001A,
    0x0000, 0x0000, 0xFFE3, 0x0019, 0x0000, 0x0000, 0xFFE3, 0x0019,
    0x0000, 0x0000, 0xFFE3, 0x0019, 0x0000, 0x0000, 0xFFE3, 0x0018,
    0x0000, 0x0000, 0xFFE3, 0x0018, 0x0000, 0x0000, 0xFFE3, 0x0018,
    0x0000, 0x0000, 0xFFE3, 0x0017, 0x0000, 0x0000, 0xFFE3, 0x0017,
    0x0000, 0x0000, 0xFFE3, 0x0017, 0x0000, 0x0000, 0xFFE3, 0x0017,
    0x0000, 0x0000, 0xFFE3, 0x0016, 0x0000, 0x0000, 0xFFE3, 0x0016,
    0x0000, 0x0000, 0xFFE3, 0x0016, 0x0000, 0x0000, 0xFFE3, 0x0015,
    0x0000, 0x0000, 0xFFE3, 0x0015, 0x0000, 0x0000, 0xFFE3, 0x0015,
    0x0000, 0x0000, 0xFFE3, 0x0015, 0x0000, 0x0000, 0xFFE3, 0x0014,
    0x0000, 0x0000, 0xFFE3, 0x0014, 0x0000, 0x0000, 0xFFE3, 0x0014,
    0x0000, 0x0000, 0xFFE3, 0x0014, 0x0000, 0x0000, 0xFFE3, 0x0013,
    0x0000, 0x0000, 0xFFE3, 0x0013, 0x0000, 0x0000, 0xFFE3, 0x0013,
    0x0000, 0x0000, 0xFFE3, 0x0013, 0x0000, 0x0000, 0xFFE3, 0x0012,
    0x0000, 0x0000, 0xFFE3, 0x0012, 0x0000, 0x0000, 0xFFE3, 0x0012,
    0x0000, 0x0000, 0xFFE3, 0x0012, 0x0000, 0x0000, 0xFFE3, 0x0011,
    0x0000, 0x0000, 0xFFE3, 0x0011, 0x0000, 0x0000, 0xFFE3, 0x0011,
    0x0000, 0x0000, 0xFFE3, 0x0011, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x0010, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x0010, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x000F, 0x0000, 0x0000, 0xFFE3, 0x000F,
    0x0000, 0x0000, 0xFFE3, 0x000F, 0x0000, 0x0000, 0xFFE3, 0x000F,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000E,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000E,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000D,
    0x0000, 0x0000, 0xFFE3, 0x000D, 0x0000, 0x0000, 0xFFE3, 0x000D,
    0x0000, 0x0000, 0xFFE3, 0x000D, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000C, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000C, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000B,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000B,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x000A, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x000A, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0009,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0009,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0008, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0008, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0006,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0006,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0004, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0004, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0001,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0001,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFF, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFF, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFC,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFC,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFFA, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFFA, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF8,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF8,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF7, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF7, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF6,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF6,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF5, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF5, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF4,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF4,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF3,
    0x0000, 0x0000, 0xFFE3, 0xFFF3, 0x0000, 0x0000, 0xFFE3, 0xFFF3,
    0x0000, 0x0000, 0xFFE3, 0xFFF3, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF2, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF2, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF1, 0x0000, 0x0000, 0xFFE3, 0xFFF1,
    0x0000, 0x0000, 0xFFE3, 0xFFF1, 0x0000, 0x0000, 0xFFE3, 0xFFF1,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFF0,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFF0,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFEF,
    0x0000, 0x0000, 0xFFE3, 0xFFEF, 0x0000, 0x0000, 0xFFE3, 0xFFEF,
    0x0000, 0x0000, 0xFFE3, 0xFFEF, 0x0000, 0x0000, 0xFFE3, 0xFFEE,
    0x0000, 0x0000, 0xFFE3, 0xFFEE, 0x0000, 0x0000, 0xFFE3, 0xFFEE,
    0x0000, 0x0000, 0xFFE3, 0xFFEE, 0x0000, 0x0000, 0xFFE3, 0xFFED,
    0x0000, 0x0000, 0xFFE3, 0xFFED, 0x0000, 0x0000, 0xFFE3, 0xFFED,
    0x0000, 0x0000, 0xFFE3, 0xFFED, 0x0000, 0x0000, 0xFFE3, 0xFFEC,
    0x0000, 0x0000, 0xFFE3, 0xFFEC, 0x0000, 0x0000, 0xFFE3, 0xFFEC,
    0x0000, 0x0000, 0xFFE3, 0xFFEC, 0x0000, 0x0000, 0xFFE3, 0xFFEB,
    0x0000, 0x0000, 0xFFE3, 0xFFEB, 0x0000, 0x0000, 0xFFE3, 0xFFEB,
    0x0000, 0x0000, 0xFFE3, 0xFFEB, 0x0000, 0x0000, 0xFFE3, 0xFFEA,
    0x0000, 0x0000, 0xFFE3, 0xFFEA, 0x0000, 0x0000, 0xFFE3, 0xFFEA,
    0x0000, 0x0000, 0xFFE3, 0xFFE9, 0x0000, 0x0000, 0xFFE3, 0xFFE9,
    0x0000, 0x0000, 0xFFE3, 0xFFE9, 0x0000, 0x0000, 0xFFE3, 0xFFE9,
    0x0000, 0x0000, 0xFFE3, 0xFFE8, 0x0000, 0x0000, 0xFFE3, 0xFFE8,
    0x0000, 0x0000, 0xFFE3, 0xFFE8, 0x0000, 0x0000, 0xFFE3, 0xFFE7,
    0x0000, 0x0000, 0xFFE3, 0xFFE7, 0x0000, 0x0000, 0xFFE3, 0xFFE7,
    0x0000, 0x0000, 0xFFE3, 0xFFE6, 0x0000, 0x0000, 0xFFE3, 0xFFE6,
    0x0000, 0x0000, 0xFFE3, 0xFFE6, 0x0000, 0x0000, 0xFFE3, 0xFFE5,
    0x0000, 0x0000, 0xFFE3, 0xFFE5, 0x0000, 0x0000, 0xFFE3, 0xFFE5,
    0x0000, 0x0000, 0xFFE3, 0xFFE4, 0x0000, 0x0000, 0xFFE3, 0xFFE4,
    0x0000, 0x0000, 0xFFE3, 0xFFE4, 0x0000, 0x0000, 0xFFE3, 0xFFE3,
    0x0000, 0x0000, 0xFFE3, 0xFFE3, 0x0000, 0x0000, 0xFFE3, 0xFFE3,
    0x0000, 0x0000, 0xFFE3, 0xFFE2, 0x0000, 0x0000, 0xFFE3, 0xFFE2,
    0x0000, 0x0000, 0xFFE3, 0xFFE2, 0x0000, 0x0000, 0xFFE3, 0xFFE1,
    0x0000, 0x0000, 0xFFE3, 0xFFE1, 0x0000, 0x0000, 0xFFE3, 0xFFE0,
    0x0000, 0x0000, 0xFFE3, 0xFFE0, 0x0000, 0x0000, 0xFFE3, 0xFFE0,
    0x0000, 0x0000, 0xFFE3, 0xFFDF, 0x0000, 0x0000, 0xFFE3, 0xFFDF,
    0x0000, 0x0000, 0xFFE3, 0xFFDE, 0x0000, 0x0000, 0xFFE3, 0xFFDE,
    0x0000, 0x0000, 0xFFE3, 0xFFDE, 0x0000, 0x0000, 0xFFE3, 0xFFDD,
    0x0000, 0x0000, 0xFFE3, 0xFFDD, 0x0000, 0x0000, 0xFFE3, 0xFFDC,
    0x0000, 0x0000, 0xFFE3, 0xFFDC, 0x0000, 0x0000, 0xFFE3, 0xFFDB,
    0x0000, 0x0000, 0xFFE3, 0xFFDB, 0x0000, 0x0000, 0xFFE3, 0xFFDA,
    0x0000, 0x0000, 0xFFE3, 0xFFDA, 0x0000, 0x0000, 0xFFE3, 0xFFD9,
    0x0000, 0x0000, 0xFFE3, 0xFFD9, 0x0000, 0x0000, 0xFFE3, 0xFFD8,
    0x0000, 0x0000, 0xFFE3, 0xFFD8, 0x0000, 0x0000, 0xFFE3, 0xFFD7,
    0x0000, 0x0000, 0xFFE3, 0xFFD7, 0x0000, 0x0000, 0xFFE3, 0xFFD6,
    0x0000, 0x0000, 0xFFE3, 0xFFD6, 0x0000, 0x0000, 0xFFE3, 0xFFD5,
    0x0000, 0x0000, 0xFFE3, 0xFFD5, 0x0000, 0x0000, 0xFFE3, 0xFFD4,
    0x0000, 0x0000, 0xFFE3, 0xFFD3, 0x0000, 0x0000, 0xFFE3, 0xFFD3,
    0x0000, 0x0000, 0xFFE3, 0xFFD2, 0x0000, 0x0000, 0xFFE3, 0xFFD2,
    0x0000, 0x0000, 0xFFE3, 0xFFD1, 0x0000, 0x0000, 0xFFE3, 0xFFD0,
    0x0000, 0x0000, 0xFFE3, 0xFFD0, 0x0000, 0x0000, 0xFFE3, 0xFFCF,
    0x0000, 0x0000, 0xFFE3, 0xFFCE, 0x0000, 0x0000, 0xFFE3, 0xFFCE,
    0x0000, 0x0000, 0xFFE3, 0xFFCD, 0x0000, 0x0000, 0xFFE3, 0xFFCC,
    0x0000, 0x0000, 0xFFE3, 0xFFCB, 0x0000, 0x0000, 0xFFE3, 0xFFCB,
    0x0000, 0x0000, 0xFFE3, 0xFFCA, 0x0000, 0x0000, 0xFFE3, 0xFFC9,
    0x0000, 0x0000, 0xFFE3, 0xFFC8, 0x0000, 0x0000, 0xFFE3, 0xFFC7,
    0x0000, 0x0000, 0xFFE3, 0xFFC6, 0x0000, 0x0000, 0xFFE3, 0xFFC5,
    0x0000, 0x0000, 0xFFE3, 0xFFC5, 0x0000, 0x0000, 0xFFE3, 0xFFC4,
    0x0000, 0x0000, 0xFFE3, 0xFFC3, 0x0000, 0x0000, 0xFFE3, 0xFFC2,
    0x0000, 0x0000, 0xFFE3, 0xFFC1, 0x0000, 0x0000, 0xFFE3, 0xFFC0,
    0x0000, 0x0000, 0xFFE3, 0xFFBE, 0x0000, 0x0000, 0xFFE3, 0xFFBD,
    0x0000, 0x0000, 0xFFE3, 0xFFBC, 0x0000, 0x0000, 0xFFE3, 0xFFBB,
    0x0000, 0x0000, 0xFFE3, 0xFFBA, 0x0000, 0x0000, 0xFFE3, 0xFFB9,
    0x0000, 0x0000, 0xFFE3, 0xFFB7, 0x0000, 0x0000, 0xFFE3, 0xFFB6,
    0x0000, 0x0000, 0xFFE3, 0xFFB5, 0x0000, 0x0000, 0xFFE3, 0xFFB3,
    0x0000, 0x0000, 0xFFE3, 0xFFB2, 0x0000, 0x0000, 0xFFE3, 0xFFB0,
    0x0000, 0x0000, 0xFFE3, 0xFFAF, 0x0000, 0x0000, 0xFFE3, 0xFFAD,
    0x0000, 0x0000, 0xFFE3, 0xFFAB, 0x0000, 0x0000, 0xFFE3, 0xFFAA,
    0x0000, 0x0000, 0xFFE3, 0xFFA8, 0x0000, 0x0000, 0xFFE3, 0xFFA6,
    0x0000, 0x0000, 0xFFE3, 0xFFA4, 0x0000, 0x0000, 0xFFE3, 0xFFA2,
    0x0000, 0x0000, 0xFFE3, 0xFFA0, 0x0000, 0x0000, 0xFFE3, 0xFF9E,
    0x0000, 0x0000, 0xFFE3, 0xFF9C, 0x0000, 0x0000, 0xFFE3, 0xFF99,
    0x0000, 0x0000, 0xFFE3, 0xFF97, 0x0000, 0x0000, 0xFFE3, 0xFF94,
    0x0000, 0x0000, 0xFFE3, 0xFF91, 0x0000, 0x0000, 0xFFE3, 0xFF8F,
    0x0000, 0x0000, 0xFFE3, 0xFF8C, 0x0000, 0x0000, 0xFFE3, 0xFF88,
    0x0000, 0x0000, 0xFFE3, 0xFF85, 0x0000, 0x0000, 0xFFE3, 0xFF82,
    0x0000, 0x0000, 0xFFE3, 0xFF7E, 0x0000, 0x0000, 0xFFE3, 0xFF7A,
    0x0000, 0x0000, 0xFFE3, 0xFF76, 0x0000, 0x0000, 0xFFE3, 0xFF71,
    0x0000, 0x0000, 0xFFE3, 0xFF6D, 0x0000, 0x0000, 0xFFE3, 0xFF68,
    0x0000, 0x0000, 0xFFE3, 0xFF63, 0x0000, 0x0000, 0xFFE3, 0xFF5D,
    0x0000, 0x0000, 0xFFE3, 0xFF57, 0x0000, 0x0000, 0xFFE3, 0xFF50,
    0x0000, 0x0000, 0xFFE3, 0xFF49, 0x0000, 0x0000, 0xFFE3, 0xFF42,
    0x0000, 0x0000, 0xFFE3, 0xFF3A, 0x0000, 0x0000, 0xFFE3, 0xFF31,
    0x0000, 0x0000, 0xFFE3, 0xFF27, 0x0000, 0x0000, 0xFFE3, 0xFF1C,
    0x0000, 0x0000, 0xFFE3, 0xFF10, 0x0000, 0x0000, 0xFFE3, 0xFF03,
    0x0000, 0x0000, 0xFFE3, 0xFEF5, 0x0000, 0x0000, 0xFFE3, 0xFEE5,
    0x0000, 0x0000, 0xFFE3, 0xFED2, 0x0000, 0x0000, 0xFFE3, 0xFEBD,
    0x0000, 0x0000, 0xFFE3, 0xFEA5, 0x0000, 0x0000, 0xFFE3, 0xFE89,
    0x0000, 0x0000, 0xFFE3, 0xFE69, 0x0000, 0x0000, 0xFFE3, 0xFE42,
    0x0000, 0x0000, 0xFFE3, 0xFE12, 0x0000, 0x0000, 0xFFE3, 0xFDD8,
    0x0000, 0x0000, 0xFFE3, 0xFD8F, 0x0000, 0x0000, 0xFFE3, 0xFD2E,
    0x0000, 0x0000, 0xFFE3, 0xFCAB, 0x0000, 0x0000, 0xFFE3, 0xFBED,
    0x0000, 0x0000, 0xFFE3, 0xFAC3, 0x0000, 0x0000, 0xFFE3, 0xF8AB,
    0x0000, 0x0000, 0xFFE3, 0xF3C7, 0x0000, 0x0000, 0xFFE3, 0xDB55
    };

static const q15_t ref_cfft_step_1024[2048] = {
    0x399A, 0x0000, 0xFFE3, 0x24AB, 0x0000, 0x0000, 0xFFE3, 0x0C39,
    0x0000, 0x0000, 0xFFE3, 0x0755, 0x0000, 0x0000, 0xFFE3, 0x053D,
    0x0000, 0x0000, 0xFFE3, 0x0413, 0x0000, 0x0000, 0xFFE3, 0x0355,
    0x0000, 0x0000, 0xFFE3, 0x02D2, 0x0000, 0x0000, 0xFFE3, 0x0271,
    0x0000, 0x0000, 0xFFE3, 0x0228, 0x0000, 0x0000, 0xFFE3, 0x01EE,
    0x0000, 0x0000, 0xFFE3, 0x01BE, 0x0000, 0x0000, 0xFFE3, 0x0197,
    0x0000, 0x0000, 0xFFE3, 0x0177, 0x0000, 0x0000, 0xFFE3, 0x015B,
    0x0000, 0x0000, 0xFFE3, 0x0143, 0x0000, 0x0000, 0xFFE3, 0x012E,
    0x0000, 0x0000, 0xFFE3, 0x011B, 0x0000, 0x0000, 0xFFE3, 0x010B,
    0x0000, 0x0000, 0xFFE3, 0x00FD, 0x0000, 0x0000, 0xFFE3, 0x00F0,
    0x0000, 0x0000, 0xFFE3, 0x00E4, 0x0000, 0x0000, 0xFFE3, 0x00D9,
    0x0000, 0x0000, 0xFFE3, 0x00CF, 0x0000, 0x0000, 0xFFE3, 0x00C6,
    0x0000, 0x0000, 0xFFE3, 0x00BE, 0x0000, 0x0000, 0xFFE3, 0x00B7,
    0x0000, 0x0000, 0xFFE3, 0x00B0, 0x0000, 0x0000, 0xFFE3, 0x00A9,
    0x0000, 0x0000, 0xFFE3, 0x00A3, 0x0000, 0x0000, 0xFFE3, 0x009D,
    0x0000, 0x0000, 0xFFE3, 0x0098, 0x0000, 0x0000, 0xFFE3, 0x0093,
    0x0000, 0x0000, 0xFFE3, 0x008F, 0x0000, 0x0000, 0xFFE3, 0x008A,
    0x0000, 0x0000, 0xFFE3, 0x0086, 0x0000, 0x0000, 0xFFE3, 0x0082,
    0x0000, 0x0000, 0xFFE3, 0x007E, 0x0000, 0x0000, 0xFFE3, 0x007B,
    0x0000, 0x0000, 0xFFE3, 0x0078, 0x0000, 0x0000, 0xFFE3, 0x0074,
    0x0000, 0x0000, 0xFFE3, 0x0071, 0x0000, 0x0000, 0xFFE3, 0x006F,
    0x0000, 0x0000, 0xFFE3, 0x006C, 0x0000, 0x0000, 0xFFE3, 0x0069,
    0x0000, 0x0000, 0xFFE3, 0x0067, 0x0000, 0x0000, 0xFFE3, 0x0064,
    0x0000, 0x0000, 0xFFE3, 0x0062, 0x0000, 0x0000, 0xFFE3, 0x0060,
    0x0000, 0x0000, 0xFFE3, 0x005E, 0x0000, 0x0000, 0xFFE3, 0x005C,
    0x0000, 0x0000, 0xFFE3, 0x005A, 0x0000, 0x0000, 0xFFE3, 0x0058,
    0x0000, 0x0000, 0xFFE3, 0x0056, 0x0000, 0x0000, 0xFFE3, 0x0055,
    0x0000, 0x0000, 0xFFE3, 0x0053, 0x0000, 0x0000, 0xFFE3, 0x0051,
    0x0000, 0x0000, 0xFFE3, 0x0050, 0x0000, 0x0000, 0xFFE3, 0x004E,
    0x0000, 0x0000, 0xFFE3, 0x004D, 0x0000, 0x0000, 0xFFE3, 0x004B,
    0x0000, 0x0000, 0xFFE3, 0x004A, 0x0000, 0x0000, 0xFFE3, 0x0049,
    0x0000, 0x0000, 0xFFE3, 0x0047, 0x0000, 0x0000, 0xFFE3, 0x0046,
    0x0000, 0x0000, 0xFFE3, 0x0045, 0x0000, 0x0000, 0xFFE3, 0x0044,
    0x0000, 0x0000, 0xFFE3, 0x0043, 0x0000, 0x0000, 0xFFE3, 0x0042,
    0x0000, 0x0000, 0xFFE3, 0x0040, 0x0000, 0x0000, 0xFFE3, 0x003F,
    0x0000, 0x0000, 0xFFE3, 0x003E, 0x0000, 0x0000, 0xFFE3, 0x003D,
    0x0000, 0x0000, 0xFFE3, 0x003C, 0x0000, 0x0000, 0xFFE3, 0x003B,
    0x0000, 0x0000, 0xFFE3, 0x003B, 0x0000, 0x0000, 0xFFE3, 0x003A,
    0x0000, 0x0000, 0xFFE3, 0x0039, 0x0000, 0x0000, 0xFFE3, 0x0038,
    0x0000, 0x0000, 0xFFE3, 0x0037, 0x0000, 0x0000, 0xFFE3, 0x0036,
    0x0000, 0x0000, 0xFFE3, 0x0035, 0x0000, 0x0000, 0xFFE3, 0x0035,
    0x0000, 0x0000, 0xFFE3, 0x0034, 0x0000, 0x0000, 0xFFE3, 0x0033,
    0x0000, 0x0000, 0xFFE3, 0x0032, 0x0000, 0x0000, 0xFFE3, 0x0032,
    0x0000, 0x0000, 0xFFE3, 0x0031, 0x0000, 0x0000, 0xFFE3, 0x0030,
    0x0000, 0x0000, 0xFFE3, 0x0030, 0x0000, 0x0000, 0xFFE3, 0x002F,
    0x0000, 0x0000, 0xFFE3, 0x002E, 0x0000, 0x0000, 0xFFE3, 0x002E,
    0x0000, 0x0000, 0xFFE3, 0x002D, 0x0000, 0x0000, 0xFFE3, 0x002D,
    0x0000, 0x0000, 0xFFE3, 0x002C, 0x0000, 0x0000, 0xFFE3, 0x002B,
    0x0000, 0x0000, 0xFFE3, 0x002B, 0x0000, 0x0000, 0xFFE3, 0x002A,
    0x0000, 0x0000, 0xFFE3, 0x002A, 0x0000, 0x0000, 0xFFE3, 0x0029,
    0x0000, 0x0000, 0xFFE3, 0x0029, 0x0000, 0x0000, 0xFFE3, 0x0028,
    0x0000, 0x0000, 0xFFE3, 0x0028, 0x0000, 0x0000, 0xFFE3, 0x0027,
    0x0000, 0x0000, 0xFFE3, 0x0027, 0x0000, 0x0000, 0xFFE3, 0x0026,
    0x0000, 0x0000, 0xFFE3, 0x0026, 0x0000, 0x0000, 0xFFE3, 0x0025,
    0x0000, 0x0000, 0xFFE3, 0x0025, 0x0000, 0x0000, 0xFFE3, 0x0024,
    0x0000, 0x0000, 0xFFE3, 0x0024, 0x0000, 0x0000, 0xFFE3, 0x0023,
    0x0000, 0x0000, 0xFFE3, 0x0023, 0x0000, 0x0000, 0xFFE3, 0x0022,
    0x0000, 0x0000, 0xFFE3, 0x0022, 0x0000, 0x0000, 0xFFE3, 0x0022,
    0x0000, 0x0000, 0xFFE3, 0x0021, 0x0000, 0x0000, 0xFFE3, 0x0021,
    0x0000, 0x0000, 0xFFE3, 0x0020, 0x0000, 0x0000, 0xFFE3, 0x0020,
    0x0000, 0x0000, 0xFFE3, 0x0020, 0x0000, 0x0000, 0xFFE3, 0x001F,
    0x0000, 0x0000, 0xFFE3, 0x001F, 0x0000, 0x0000, 0xFFE3, 0x001E,
    0x0000, 0x0000, 0xFFE3, 0x001E, 0x0000, 0x0000, 0xFFE3, 0x001E,
    0x0000, 0x0000, 0xFFE3, 0x001D, 0x0000, 0x0000, 0xFFE3, 0x001D,
    0x0000, 0x0000, 0xFFE3, 0x001D, 0x0000, 0x0000, 0xFFE3, 0x001C,
    0x0000, 0x0000, 0xFFE3, 0x001C, 0x0000, 0x0000, 0xFFE3, 0x001C,
    0x0000, 0x0000, 0xFFE3, 0x001B, 0x0000, 0x0000, 0xFFE3, 0x001B,
    0x0000, 0x0000, 0xFFE3, 0x001B, 0x0000, 0x0000, 0xFFE3, 0x001A,
    0x0000, 0x0000, 0xFFE3, 0x001A, 0x0000, 0x0000, 0xFFE3, 0x001A,
    0x0000, 0x0000, 0xFFE3, 0x0019, 0x0000, 0x0000, 0xFFE3, 0x0019,
    0x0000, 0x0000, 0xFFE3, 0x0019, 0x0000, 0x0000, 0xFFE3, 0x0018,
    0x0000, 0x0000, 0xFFE3, 0x0018, 0x0000, 0x0000, 0xFFE3, 0x0018,
    0x0000, 0x0000, 0xFFE3, 0x0017, 0x0000, 0x0000, 0xFFE3, 0x0017,
    0x0000, 0x0000, 0xFFE3, 0x0017, 0x0000, 0x0000, 0xFFE3, 0x0017,
    0x0000, 0x0000, 0xFFE3, 0x0016, 0x0000, 0x0000, 0xFFE3, 0x0016,
    0x0000, 0x0000, 0xFFE3, 0x0016, 0x0000, 0x0000, 0xFFE3, 0x0015,
    0x0000, 0x0000, 0xFFE3, 0x0015, 0x0000, 0x0000, 0xFFE3, 0x0015,
    0x0000, 0x0000, 0xFFE3, 0x0015, 0x0000, 0x0000, 0xFFE3, 0x0014,
    0x0000, 0x0000, 0xFFE3, 0x0014, 0x0000, 0x0000, 0xFFE3, 0x0014,
    0x0000, 0x0000, 0xFFE3, 0x0014, 0x0000, 0x0000, 0xFFE3, 0x0013,
    0x0000, 0x0000, 0xFFE3, 0x0013, 0x0000, 0x0000, 0xFFE3, 0x0013,
    0x0000, 0x0000, 0xFFE3, 0x0013, 0x0000, 0x0000, 0xFFE3, 0x0012,
    0x0000, 0x0000, 0xFFE3, 0x0012, 0x0000, 0x0000, 0xFFE3, 0x0012,
    0x0000, 0x0000, 0xFFE3, 0x0012, 0x0000, 0x0000, 0xFFE3, 0x0011,
    0x0000, 0x0000, 0xFFE3, 0x0011, 0x0000, 0x0000, 0xFFE3, 0x0011,
    0x0000, 0x0000, 0xFFE3, 0x0011, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x0010, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x0010, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x000F, 0x0000, 0x0000, 0xFFE3, 0x000F,
    0x0000, 0x0000, 0xFFE3, 0x000F, 0x0000, 0x0000, 0xFFE3, 0x000F,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000E,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000E,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000D,
    0x0000, 0x0000, 0xFFE3, 0x000D, 0x0000, 0x0000, 0xFFE3, 0x000D,
    0x0000, 0x0000, 0xFFE3, 0x000D, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000C, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000C, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000B,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000B,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x000A, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x000A, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0009,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0009,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0008, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0008, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0006,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0006,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0004, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0004, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0001,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0001,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFF, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFF, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFC,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFC,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFFA, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFFA, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF8,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF8,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF7, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF7, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF6,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF6,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF5, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF5, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF4,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF4,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF3,
    0x0000, 0x0000, 0xFFE3, 0xFFF3, 0x0000, 0x0000, 0xFFE3, 0xFFF3,
    0x0000, 0x0000, 0xFFE3, 0xFFF3, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF2, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF2, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF1, 0x0000, 0x0000, 0xFFE3, 0xFFF1,
    0x0000, 0x0000, 0xFFE3, 0xFFF1, 0x0000, 0x0000, 0xFFE3, 0xFFF1,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFF0,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFF0,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFEF,
    0x0000, 0x0000, 0xFFE3, 0xFFEF, 0x0000, 0x0000, 0xFFE3, 0xFFEF,
    0x0000, 0x0000, 0xFFE3, 0xFFEF, 0x0000, 0x0000, 0xFFE3, 0xFFEE,
    0x0000, 0x0000, 0xFFE3, 0xFFEE, 0x0000, 0x0000, 0xFFE3, 0xFFEE,
    0x0000, 0x0000, 0xFFE3, 0xFFEE, 0x0000, 0x0000, 0xFFE3, 0xFFED,
    0x0000, 0x0000, 0xFFE3, 0xFFED, 0x0000, 0x0000, 0xFFE3, 0xFFED,
    0x0000, 0x0000, 0xFFE3, 0xFFED, 0x0000, 0x0000, 0xFFE3, 0xFFEC,
    0x0000, 0x0000, 0xFFE3, 0xFFEC, 0x0000, 0x0000, 0xFFE3, 0xFFEC,
    0x0000, 0x0000, 0xFFE3, 0xFFEC, 0x0000, 0x0000, 0xFFE3, 0xFFEB,
    0x0000, 0x0000, 0xFFE3, 0xFFEB, 0x0000, 0x0000, 0xFFE3, 0xFFEB,
    0x0000, 0x0000, 0xFFE3, 0xFFEB, 0x0000, 0x0000, 0xFFE3, 0xFFEA,
    0x0000, 0x0000, 0xFFE3, 0xFFEA, 0x0000, 0x0000, 0xFFE3, 0xFFEA,
    0x0000, 0x0000, 0xFFE3, 0xFFE9, 0x0000, 0x0000, 0xFFE3, 0xFFE9,
    0x0000, 0x0000, 0xFFE3, 0xFFE9, 0x0000, 0x0000, 0xFFE3, 0xFFE9,
    0x0000, 0x0000, 0xFFE3, 0xFFE8, 0x0000, 0x0000, 0xFFE3, 0xFFE8,
    0x0000, 0x0000, 0xFFE3, 0xFFE8, 0x0000, 0x0000, 0xFFE3, 0xFFE7,
    0x0000, 0x0000, 0xFFE3, 0xFFE7, 0x0000, 0x0000, 0xFFE3, 0xFFE7,
    0x0000, 0x0000, 0xFFE3, 0xFFE6, 0x0000, 0x0000, 0xFFE3, 0xFFE6,
    0x0000, 0x0000, 0xFFE3, 0xFFE6, 0x0000, 0x0000, 0xFFE3, 0xFFE5,
    0x0000, 0x0000, 0xFFE3, 0xFFE5, 0x0000, 0x0000, 0xFFE3, 0xFFE5,
    0x0000, 0x0000, 0xFFE3, 0xFFE4, 0x0000, 0x0000, 0xFFE3, 0xFFE4,
    0x0000, 0x0000, 0xFFE3, 0xFFE4, 0x0000, 0x0000, 0xFFE3, 0xFFE3,
    0x0000, 0x0000, 0xFFE3, 0xFFE3, 0x0000, 0x0000, 0xFFE3, 0xFFE3,
    0x0000, 0x0000, 0xFFE3, 0xFFE2, 0x0000, 0x0000, 0xFFE3, 0xFFE2,
    0x0000, 0x0000, 0xFFE3, 0xFFE2, 0x0000, 0x0000, 0xFFE3, 0xFFE1,
    0x0000, 0x0000, 0xFFE3, 0xFFE1, 0x0000, 0x0000, 0xFFE3, 0xFFE0,
    0x0000, 0x0000, 0xFFE3, 0xFFE0, 0x0000, 0x0000, 0xFFE3, 0xFFE0,
    0x0000, 0x0000, 0xFFE3, 0xFFDF, 0x0000, 0x0000, 0xFFE3, 0xFFDF,
    0x0000, 0x0000, 0xFFE3, 0xFFDE, 0x0000, 0x0000, 0xFFE3, 0xFFDE,
    0x0000, 0x0000, 0xFFE3, 0xFFDE, 0x0000, 0x0000, 0xFFE3, 0xFFDD,
    0x0000, 0x0000, 0xFFE3, 0xFFDD, 0x0000, 0x0000, 0xFFE3, 0xFFDC,
    0x0000, 0x0000, 0xFFE3, 0xFFDC, 0x0000, 0x0000, 0xFFE3, 0xFFDB,
    0x0000, 0x0000, 0xFFE3, 0xFFDB, 0x0000, 0x0000, 0xFFE3, 0xFFDA,
    0x0000, 0x0000, 0xFFE3, 0xFFDA, 0x0000, 0x0000, 0xFFE3, 0xFFD9,
    0x0000, 0x0000, 0xFFE3, 0xFFD9, 0x0000, 0x0000, 0xFFE3, 0xFFD8,
    0x0000, 0x0000, 0xFFE3, 0xFFD8, 0x0000, 0x0000, 0xFFE3, 0xFFD7,
    0x0000, 0x0000, 0xFFE3, 0xFFD7, 0x0000, 0x0000, 0xFFE3, 0xFFD6,
    0x0000, 0x0000, 0xFFE3, 0xFFD6, 0x0000, 0x0000, 0xFFE3, 0xFFD5,
    0x0000, 0x0000, 0xFFE3, 0xFFD5, 0x0000, 0x0000, 0xFFE3, 0xFFD4,
    0x0000, 0x0000, 0xFFE3, 0xFFD3, 0x0000, 0x0000, 0xFFE3, 0xFFD3,
    0x0000, 0x0000, 0xFFE3, 0xFFD2, 0x0000, 0x0000, 0xFFE3, 0xFFD2,
    0x0000, 0x0000, 0xFFE3, 0xFFD1, 0x0000, 0x0000, 0xFFE3, 0xFFD0,
    0x0000, 0x0000, 0xFFE3, 0xFFD0, 0x0000, 0x0000, 0xFFE3, 0xFFCF,
    0x0000, 0x0000, 0xFFE3, 0xFFCE, 0x0000, 0x0000, 0xFFE3, 0xFFCE,
    0x0000, 0x0000, 0xFFE3, 0xFFCD, 0x0000, 0x0000, 0xFFE3, 0xFFCC,
    0x0000, 0x0000, 0xFFE3, 0xFFCB, 0x0000, 0x0000, 0xFFE3, 0xFFCB,
    0x0000, 0x0000, 0xFFE3, 0xFFCA, 0x0000, 0x0000, 0xFFE3, 0xFFC9,
    0x0000, 0x0000, 0xFFE3, 0xFFC8, 0x0000, 0x0000, 0xFFE3, 0xFFC7,
    0x0000, 0x0000, 0xFFE3, 0xFFC6, 0x0000, 0x0000, 0xFFE3, 0xFFC5,
    0x0000, 0x0000, 0xFFE3, 0xFFC5, 0x0000, 0x0000, 0xFFE3, 0xFFC4,
    0x0000, 0x0000, 0xFFE3, 0xFFC3, 0x0000, 0x0000, 0xFFE3, 0xFFC2,
    0x0000, 0x0000, 0xFFE3, 0xFFC1, 0x0000, 0x0000, 0xFFE3, 0xFFC0,
    0x0000, 0x0000, 0xFFE3, 0xFFBE, 0x0000, 0x0000, 0xFFE3, 0xFFBD,
    0x0000, 0x0000, 0xFFE3, 0xFFBC, 0x0000, 0x0000, 0xFFE3, 0xFFBB,
    0x0000, 0x0000, 0xFFE3, 0xFFBA, 0x0000, 0x0000, 0xFFE3, 0xFFB9,
    0x0000, 0x0000, 0xFFE3, 0xFFB7, 0x0000, 0x0000, 0xFFE3, 0xFFB6,
    0x0000, 0x0000, 0xFFE3, 0xFFB5, 0x0000, 0x0000, 0xFFE3, 0xFFB3,
    0x0000, 0x0000, 0xFFE3, 0xFFB2, 0x0000, 0x0000, 0xFFE3, 0xFFB0,
    0x0000, 0x0000, 0xFFE3, 0xFFAF, 0x0000, 0x0000, 0xFFE3, 0xFFAD,
    0x0000, 0x0000, 0xFFE3, 0xFFAB, 0x0000, 0x0000, 0xFFE3, 0xFFAA,
    0x0000, 0x0000, 0xFFE3, 0xFFA8, 0x0000, 0x0000, 0xFFE3, 0xFFA6,
    0x0000, 0x0000, 0xFFE3, 0xFFA4, 0x0000, 0x0000, 0xFFE3, 0xFFA2,
    0x0000, 0x0000, 0xFFE3, 0xFFA0, 0x0000, 0x0000, 0xFFE3, 0xFF9E,
    0x0000, 0x0000, 0xFFE3, 0xFF9C, 0x0000, 0x0000, 0xFFE3, 0xFF99,
    0x0000, 0x0000, 0xFFE3, 0xFF97, 0x0000, 0x0000, 0xFFE3, 0xFF94,
    0x0000, 0x0000, 0xFFE3, 0xFF91, 0x0000, 0x0000, 0xFFE3, 0xFF8F,
    0x0000, 0x0000, 0xFFE3, 0xFF8C, 0x0000, 0x0000, 0xFFE3, 0xFF88,
    0x0000, 0x0000, 0xFFE3, 0xFF85, 0x0000, 0x0000, 0xFFE3, 0xFF82,
    0x0000, 0x0000, 0xFFE3, 0xFF7E, 0x0000, 0x0000, 0xFFE3, 0xFF7A,
    0x0000, 0x0000, 0xFFE3, 0xFF76, 0x0000, 0x0000, 0xFFE3, 0xFF71,
    0x0000, 0x0000, 0xFFE3, 0xFF6D, 0x0000, 0x0000, 0xFFE3, 0xFF68,
    0x0000, 0x0000, 0xFFE3, 0xFF63, 0x0000, 0x0000, 0xFFE3, 0xFF5D,
    0x0000, 0x0000, 0xFFE3, 0xFF57, 0x0000, 0x0000, 0xFFE3, 0xFF50,
    0x0000, 0x0000, 0xFFE3, 0xFF49, 0x0000, 0x0000, 0xFFE3, 0xFF42,
    0x0000, 0x0000, 0xFFE3, 0xFF3A, 0x0000, 0x0000, 0xFFE3, 0xFF31,
    0x0000, 0x0000, 0xFFE3, 0xFF27, 0x0000, 0x0000, 0xFFE3, 0xFF1C,
    0x0000, 0x0000, 0xFFE3, 0xFF10, 0x0000, 0x0000, 0xFFE3, 0xFF03,
    0x0000, 0x0000, 0xFFE3, 0xFEF5, 0x0000, 0x0000, 0xFFE3, 0xFEE5,
    0x0000, 0x0000, 0xFFE3, 0xFED2, 0x0000, 0x0000, 0xFFE3, 0xFEBD,
    0x0000, 0x0000, 0xFFE3, 0xFEA5, 0x0000, 0x0000, 0xFFE3, 0xFE89,
    0x0000, 0x0000, 0xFFE3, 0xFE69, 0x0000, 0x0000, 0xFFE3, 0xFE42,
    0x0000, 0x0000, 0xFFE3, 0xFE12, 0x0000, 0x0000, 0xFFE3, 0xFDD8,
    0x0000, 0x0000, 0xFFE3, 0xFD8F, 0x0000, 0x0000, 0xFFE3, 0xFD2E,
    0x0000, 0x0000, 0xFFE3, 0xFCAB, 0x0000, 0x0000, 0xFFE3, 0xFBED,
    0x0000, 0x0000, 0xFFE3, 0xFAC3, 0x0000, 0x0000, 0xFFE3, 0xF8AB,
    0x0000, 0x0000, 0xFFE3, 0xF3C7, 0x0000, 0x0000, 0xFFE3, 0xDB55
    };

static const q15_t in_cfft_step_2048[4096] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_2048[4096] = {
    0x399A, 0x0000, 0xFFF2, 0x24AB, 0x0000, 0x0000, 0xFFF2, 0x0C39,
    0x0000, 0x0000, 0xFFF2, 0x0755, 0x0000, 0x0000, 0xFFF2, 0x053D,
    0x0000, 0x0000, 0xFFF2, 0x0413, 0x0000, 0x0000, 0xFFF2, 0x0355,
    0x0000, 0x0000, 0xFFF2, 0x02D2, 0x0000, 0x0000, 0xFFF2, 0x0272,
    0x0000, 0x0000, 0xFFF2, 0x0228, 0x0000, 0x0000, 0xFFF2, 0x01EE,
    0x0000, 0x0000, 0xFFF2, 0x01BF, 0x0000, 0x0000, 0xFFF2, 0x0198,
    0x0000, 0x0000, 0xFFF2, 0x0177, 0x0000, 0x0000, 0xFFF2, 0x015B,
    0x0000, 0x0000, 0xFFF2, 0x0143, 0x0000, 0x0000, 0xFFF2, 0x012F,
    0x0000, 0x0000, 0xFFF2, 0x011C, 0x0000, 0x0000, 0xFFF2, 0x010C,
    0x0000, 0x0000, 0xFFF2, 0x00FD, 0x0000, 0x0000, 0xFFF2, 0x00F0,
    0x0000, 0x0000, 0xFFF2, 0x00E5, 0x0000, 0x0000, 0xFFF2, 0x00DA,
    0x0000, 0x0000, 0xFFF2, 0x00D0, 0x0000, 0x0000, 0xFFF2, 0x00C7,
    0x0000, 0x0000, 0xFFF2, 0x00BF, 0x0000, 0x0000, 0xFFF2, 0x00B8,
    0x0000, 0x0000, 0xFFF2, 0x00B1, 0x0000, 0x0000, 0xFFF2, 0x00AA,
    0x0000, 0x0000, 0xFFF2, 0x00A4, 0x0000, 0x0000, 0xFFF2, 0x009F,
    0x0000, 0x0000, 0xFFF2, 0x0099, 0x0000, 0x0000, 0xFFF2, 0x0095,
    0x0000, 0x0000, 0xFFF2, 0x0090, 0x0000, 0x0000, 0xFFF2, 0x008C,
    0x0000, 0x0000, 0xFFF2, 0x0088, 0x0000, 0x0000, 0xFFF2, 0x0084,
    0x0000, 0x0000, 0xFFF2, 0x0080, 0x0000, 0x0000, 0xFFF2, 0x007D,
    0x0000, 0x0000, 0xFFF2, 0x0079, 0x0000, 0x0000, 0xFFF2, 0x0076,
    0x0000, 0x0000, 0xFFF2, 0x0073, 0x0000, 0x0000, 0xFFF2, 0x0070,
    0x0000, 0x0000, 0xFFF2, 0x006E, 0x0000, 0x0000, 0xFFF2, 0x006B,
    0x0000, 0x0000, 0xFFF2, 0x0069, 0x0000, 0x0000, 0xFFF2, 0x0066,
    0x0000, 0x0000, 0xFFF2, 0x0064, 0x0000, 0x0000, 0xFFF2, 0x0062,
    0x0000, 0x0000, 0xFFF2, 0x0060, 0x0000, 0x0000, 0xFFF2, 0x005E,
    0x0000, 0x0000, 0xFFF2, 0x005C, 0x0000, 0x0000, 0xFFF2, 0x005A,
    0x0000, 0x0000, 0xFFF2, 0x0059, 0x0000, 0x0000, 0xFFF2, 0x0057,
    0x0000, 0x0000, 0xFFF2, 0x0055, 0x0000, 0x0000, 0xFFF2, 0x0054,
    0x0000, 0x0000, 0xFFF2, 0x0052, 0x0000, 0x0000, 0xFFF2, 0x0051,
    0x0000, 0x0000, 0xFFF2, 0x004F, 0x0000, 0x0000, 0xFFF2, 0x004E,
    0x0000, 0x0000, 0xFFF2, 0x004D, 0x0000, 0x0000, 0xFFF2, 0x004B,
    0x0000, 0x0000, 0xFFF2, 0x004A, 0x0000, 0x0000, 0xFFF2, 0x0049,
    0x0000, 0x0000, 0xFFF2, 0x0048, 0x0000, 0x0000, 0xFFF2, 0x0047,
    0x0000, 0x0000, 0xFFF2, 0x0046, 0x0000, 0x0000, 0xFFF2, 0x0045,
    0x0000, 0x0000, 0xFFF2, 0x0044, 0x0000, 0x0000, 0xFFF2, 0x0043,
    0x0000, 0x0000, 0xFFF2, 0x0042, 0x0000, 0x0000, 0xFFF2, 0x0041,
    0x0000, 0x0000, 0xFFF2, 0x0040, 0x0000, 0x0000, 0xFFF2, 0x003F,
    0x0000, 0x0000, 0xFFF2, 0x003E, 0x0000, 0x0000, 0xFFF2, 0x003D,
    0x0000, 0x0000, 0xFFF2, 0x003C, 0x0000, 0x0000, 0xFFF2, 0x003B,
    0x0000, 0x0000, 0xFFF2, 0x003B, 0x0000, 0x0000, 0xFFF2, 0x003A,
    0x0000, 0x0000, 0xFFF2, 0x0039, 0x0000, 0x0000, 0xFFF2, 0x0038,
    0x0000, 0x0000, 0xFFF2, 0x0038, 0x0000, 0x0000, 0xFFF2, 0x0037,
    0x0000, 0x0000, 0xFFF2, 0x0036, 0x0000, 0x0000, 0xFFF2, 0x0036,
    0x0000, 0x0000, 0xFFF2, 0x0035, 0x0000, 0x0000, 0xFFF2, 0x0034,
    0x0000, 0x0000, 0xFFF2, 0x0034, 0x0000, 0x0000, 0xFFF2, 0x0033,
    0x0000, 0x0000, 0xFFF2, 0x0033, 0x0000, 0x0000, 0xFFF2, 0x0032,
    0x0000, 0x0000, 0xFFF2, 0x0031, 0x0000, 0x0000, 0xFFF2, 0x0031,
    0x0000, 0x0000, 0xFFF2, 0x0030, 0x0000, 0x0000, 0xFFF2, 0x0030,
    0x0000, 0x0000, 0xFFF2, 0x002F, 0x0000, 0x0000, 0xFFF2, 0x002F,
    0x0000, 0x0000, 0xFFF2, 0x002E, 0x0000, 0x0000, 0xFFF2, 0x002E,
    0x0000, 0x0000, 0xFFF2, 0x002D, 0x0000, 0x0000, 0xFFF2, 0x002D,
    0x0000, 0x0000, 0xFFF2, 0x002C, 0x0000, 0x0000, 0xFFF2, 0x002C,
    0x0000, 0x0000, 0xFFF2, 0x002B, 0x0000, 0x0000, 0xFFF2, 0x002B,
    0x0000, 0x0000, 0xFFF2, 0x002A, 0x0000, 0x0000, 0xFFF2, 0x002A,
    0x0000, 0x0000, 0xFFF2, 0x002A, 0x0000, 0x0000, 0xFFF2, 0x0029,
    0x0000, 0x0000, 0xFFF2, 0x0029, 0x0000, 0x0000, 0xFFF2, 0x0028,
    0x0000, 0x0000, 0xFFF2, 0x0028, 0x0000, 0x0000, 0xFFF2, 0x0028,
    0x0000, 0x0000, 0xFFF2, 0x0027, 0x0000, 0x0000, 0xFFF2, 0x0027,
    0x0000, 0x0000, 0xFFF2, 0x0027, 0x0000, 0x0000, 0xFFF2, 0x0026,
    0x0000, 0x0000, 0xFFF2, 0x0026, 0x0000, 0x0000, 0xFFF2, 0x0026,
    0x0000, 0x0000, 0xFFF2, 0x0025, 0x0000, 0x0000, 0xFFF2, 0x0025,
    0x0000, 0x0000, 0xFFF2, 0x0024, 0x0000, 0x0000, 0xFFF2, 0x0024,
    0x0000, 0x0000, 0xFFF2, 0x0024, 0x0000, 0x0000, 0xFFF2, 0x0024,
    0x0000, 0x0000, 0xFFF2, 0x0023, 0x0000, 0x0000, 0xFFF2, 0x0023,
    0x0000, 0x0000, 0xFFF2, 0x0023, 0x0000, 0x0000, 0xFFF2, 0x0022,
    0x0000, 0x0000, 0xFFF2, 0x0022, 0x0000, 0x0000, 0xFFF2, 0x0022,
    0x0000, 0x0000, 0xFFF2, 0x0021, 0x0000, 0x0000, 0xFFF2, 0x0021,
    0x0000, 0x0000, 0xFFF2, 0x0021, 0x0000, 0x0000, 0xFFF2, 0x0021,
    0x0000, 0x0000, 0xFFF2, 0x0020, 0x0000, 0x0000, 0xFFF2, 0x0020,
    0x0000, 0x0000, 0xFFF2, 0x0020, 0x0000, 0x0000, 0xFFF2, 0x0020,
    0x0000, 0x0000, 0xFFF2, 0x001F, 0x0000, 0x0000, 0xFFF2, 0x001F,
    0x0000, 0x0000, 0xFFF2, 0x001F, 0x0000, 0x0000, 0xFFF2, 0x001F,
    0x0000, 0x0000, 0xFFF2, 0x001E, 0x0000, 0x0000, 0xFFF2, 0x001E,
    0x0000, 0x0000, 0xFFF2, 0x001E, 0x0000, 0x0000, 0xFFF2, 0x001E,
    0x0000, 0x0000, 0xFFF2, 0x001D, 0x0000, 0x0000, 0xFFF2, 0x001D,
    0x0000, 0x0000, 0xFFF2, 0x001D, 0x0000, 0x0000, 0xFFF2, 0x001D,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001C,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001C,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001B, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001B, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0019,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0019,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE7, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE7, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE5,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE5,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE4, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE4, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE3, 0x0000, 0x0000, 0xFFF2, 0xFFE3,
    0x0000, 0x0000, 0xFFF2, 0xFFE3, 0x0000, 0x0000, 0xFFF2, 0xFFE3,
    0x0000, 0x0000, 0xFFF2, 0xFFE2, 0x0000, 0x0000, 0xFFF2, 0xFFE2,
    0x0000, 0x0000, 0xFFF2, 0xFFE2, 0x0000, 0x0000, 0xFFF2, 0xFFE2,
    0x0000, 0x0000, 0xFFF2, 0xFFE1, 0x0000, 0x0000, 0xFFF2, 0xFFE1,
    0x0000, 0x0000, 0xFFF2, 0xFFE1, 0x0000, 0x0000, 0xFFF2, 0xFFE1,
    0x0000, 0x0000, 0xFFF2, 0xFFE0, 0x0000, 0x0000, 0xFFF2, 0xFFE0,
    0x0000, 0x0000, 0xFFF2, 0xFFE0, 0x0000, 0x0000, 0xFFF2, 0xFFE0,
    0x0000, 0x0000, 0xFFF2, 0xFFDF, 0x0000, 0x0000, 0xFFF2, 0xFFDF,
    0x0000, 0x0000, 0xFFF2, 0xFFDF, 0x0000, 0x0000, 0xFFF2, 0xFFDF,
    0x0000, 0x0000, 0xFFF2, 0xFFDE, 0x0000, 0x0000, 0xFFF2, 0xFFDE,
    0x0000, 0x0000, 0xFFF2, 0xFFDE, 0x0000, 0x0000, 0xFFF2, 0xFFDD,
    0x0000, 0x0000, 0xFFF2, 0xFFDD, 0x0000, 0x0000, 0xFFF2, 0xFFDD,
    0x0000, 0x0000, 0xFFF2, 0xFFDC, 0x0000, 0x0000, 0xFFF2, 0xFFDC,
    0x0000, 0x0000, 0xFFF2, 0xFFDC, 0x0000, 0x0000, 0xFFF2, 0xFFDC,
    0x0000, 0x0000, 0xFFF2, 0xFFDB, 0x0000, 0x0000, 0xFFF2, 0xFFDB,
    0x0000, 0x0000, 0xFFF2, 0xFFDA, 0x0000, 0x0000, 0xFFF2, 0xFFDA,
    0x0000, 0x0000, 0xFFF2, 0xFFDA, 0x0000, 0x0000, 0xFFF2, 0xFFD9,
    0x0000, 0x0000, 0xFFF2, 0xFFD9, 0x0000, 0x0000, 0xFFF2, 0xFFD9,
    0x0000, 0x0000, 0xFFF2, 0xFFD8, 0x0000, 0x0000, 0xFFF2, 0xFFD8,
    0x0000, 0x0000, 0xFFF2, 0xFFD8, 0x0000, 0x0000, 0xFFF2, 0xFFD7,
    0x0000, 0x0000, 0xFFF2, 0xFFD7, 0x0000, 0x0000, 0xFFF2, 0xFFD6,
    0x0000, 0x0000, 0xFFF2, 0xFFD6, 0x0000, 0x0000, 0xFFF2, 0xFFD6,
    0x0000, 0x0000, 0xFFF2, 0xFFD5, 0x0000, 0x0000, 0xFFF2, 0xFFD5,
    0x0000, 0x0000, 0xFFF2, 0xFFD4, 0x0000, 0x0000, 0xFFF2, 0xFFD4,
    0x0000, 0x0000, 0xFFF2, 0xFFD3, 0x0000, 0x0000, 0xFFF2, 0xFFD3,
    0x0000, 0x0000, 0xFFF2, 0xFFD2, 0x0000, 0x0000, 0xFFF2, 0xFFD2,
    0x0000, 0x0000, 0xFFF2, 0xFFD1, 0x0000, 0x0000, 0xFFF2, 0xFFD1,
    0x0000, 0x0000, 0xFFF2, 0xFFD0, 0x0000, 0x0000, 0xFFF2, 0xFFD0,
    0x0000, 0x0000, 0xFFF2, 0xFFCF, 0x0000, 0x0000, 0xFFF2, 0xFFCF,
    0x0000, 0x0000, 0xFFF2, 0xFFCE, 0x0000, 0x0000, 0xFFF2, 0xFFCD,
    0x0000, 0x0000, 0xFFF2, 0xFFCD, 0x0000, 0x0000, 0xFFF2, 0xFFCC,
    0x0000, 0x0000, 0xFFF2, 0xFFCC, 0x0000, 0x0000, 0xFFF2, 0xFFCB,
    0x0000, 0x0000, 0xFFF2, 0xFFCA, 0x0000, 0x0000, 0xFFF2, 0xFFCA,
    0x0000, 0x0000, 0xFFF2, 0xFFC9, 0x0000, 0x0000, 0xFFF2, 0xFFC8,
    0x0000, 0x0000, 0xFFF2, 0xFFC8, 0x0000, 0x0000, 0xFFF2, 0xFFC7,
    0x0000, 0x0000, 0xFFF2, 0xFFC6, 0x0000, 0x0000, 0xFFF2, 0xFFC5,
    0x0000, 0x0000, 0xFFF2, 0xFFC5, 0x0000, 0x0000, 0xFFF2, 0xFFC4,
    0x0000, 0x0000, 0xFFF2, 0xFFC3, 0x0000, 0x0000, 0xFFF2, 0xFFC2,
    0x0000, 0x0000, 0xFFF2, 0xFFC1, 0x0000, 0x0000, 0xFFF2, 0xFFC0,
    0x0000, 0x0000, 0xFFF2, 0xFFBF, 0x0000, 0x0000, 0xFFF2, 0xFFBE,
    0x0000, 0x0000, 0xFFF2, 0xFFBD, 0x0000, 0x0000, 0xFFF2, 0xFFBC,
    0x0000, 0x0000, 0xFFF2, 0xFFBB, 0x0000, 0x0000, 0xFFF2, 0xFFBA,
    0x0000, 0x0000, 0xFFF2, 0xFFB9, 0x0000, 0x0000, 0xFFF2, 0xFFB8,
    0x0000, 0x0000, 0xFFF2, 0xFFB7, 0x0000, 0x0000, 0xFFF2, 0xFFB6,
    0x0000, 0x0000, 0xFFF2, 0xFFB5, 0x0000, 0x0000, 0xFFF2, 0xFFB3,
    0x0000, 0x0000, 0xFFF2, 0xFFB2, 0x0000, 0x0000, 0xFFF2, 0xFFB1,
    0x0000, 0x0000, 0xFFF2, 0xFFAF, 0x0000, 0x0000, 0xFFF2, 0xFFAE,
    0x0000, 0x0000, 0xFFF2, 0xFFAC, 0x0000, 0x0000, 0xFFF2, 0xFFAB,
    0x0000, 0x0000, 0xFFF2, 0xFFA9, 0x0000, 0x0000, 0xFFF2, 0xFFA7,
    0x0000, 0x0000, 0xFFF2, 0xFFA6, 0x0000, 0x0000, 0xFFF2, 0xFFA4,
    0x0000, 0x0000, 0xFFF2, 0xFFA2, 0x0000, 0x0000, 0xFFF2, 0xFFA0,
    0x0000, 0x0000, 0xFFF2, 0xFF9E, 0x0000, 0x0000, 0xFFF2, 0xFF9C,
    0x0000, 0x0000, 0xFFF2, 0xFF9A, 0x0000, 0x0000, 0xFFF2, 0xFF97,
    0x0000, 0x0000, 0xFFF2, 0xFF95, 0x0000, 0x0000, 0xFFF2, 0xFF92,
    0x0000, 0x0000, 0xFFF2, 0xFF90, 0x0000, 0x0000, 0xFFF2, 0xFF8D,
    0x0000, 0x0000, 0xFFF2, 0xFF8A, 0x0000, 0x0000, 0xFFF2, 0xFF87,
    0x0000, 0x0000, 0xFFF2, 0xFF83, 0x0000, 0x0000, 0xFFF2, 0xFF80,
    0x0000, 0x0000, 0xFFF2, 0xFF7C, 0x0000, 0x0000, 0xFFF2, 0xFF78,
    0x0000, 0x0000, 0xFFF2, 0xFF74, 0x0000, 0x0000, 0xFFF2, 0xFF70,
    0x0000, 0x0000, 0xFFF2, 0xFF6B, 0x0000, 0x0000, 0xFFF2, 0xFF67,
    0x0000, 0x0000, 0xFFF2, 0xFF61, 0x0000, 0x0000, 0xFFF2, 0xFF5C,
    0x0000, 0x0000, 0xFFF2, 0xFF56, 0x0000, 0x0000, 0xFFF2, 0xFF4F,
    0x0000, 0x0000, 0xFFF2, 0xFF48, 0x0000, 0x0000, 0xFFF2, 0xFF41,
    0x0000, 0x0000, 0xFFF2, 0xFF39, 0x0000, 0x0000, 0xFFF2, 0xFF30,
    0x0000, 0x0000, 0xFFF2, 0xFF26, 0x0000, 0x0000, 0xFFF2, 0xFF1B,
    0x0000, 0x0000, 0xFFF2, 0xFF10, 0x0000, 0x0000, 0xFFF2, 0xFF03,
    0x0000, 0x0000, 0xFFF2, 0xFEF4, 0x0000, 0x0000, 0xFFF2, 0xFEE4,
    0x0000, 0x0000, 0xFFF2, 0xFED1, 0x0000, 0x0000, 0xFFF2, 0xFEBD,
    0x0000, 0x0000, 0xFFF2, 0xFEA5, 0x0000, 0x0000, 0xFFF2, 0xFE89,
    0x0000, 0x0000, 0xFFF2, 0xFE68, 0x0000, 0x0000, 0xFFF2, 0xFE41,
    0x0000, 0x0000, 0xFFF2, 0xFE12, 0x0000, 0x0000, 0xFFF2, 0xFDD8,
    0x0000, 0x0000, 0xFFF2, 0xFD8E, 0x0000, 0x0000, 0xFFF2, 0xFD2E,
    0x0000, 0x0000, 0xFFF2, 0xFCAB, 0x0000, 0x0000, 0xFFF2, 0xFBED,
    0x0000, 0x0000, 0xFFF2, 0xFAC3, 0x0000, 0x0000, 0xFFF2, 0xF8AB,
    0x0000, 0x0000, 0xFFF2, 0xF3C7, 0x0000, 0x0000, 0xFFF2, 0xDB55
    };

static const q15_t ref_cfft_step_2048[4096] = {
    0x399A, 0x0000, 0xFFF2, 0x24AB, 0x0000, 0x0000, 0xFFF2, 0x0C39,
    0x0000, 0x0000, 0xFFF2, 0x0755, 0x0000, 0x0000, 0xFFF2, 0x053D,
    0x0000, 0x0000, 0xFFF2, 0x0413, 0x0000, 0x0000, 0xFFF2, 0x0355,
    0x0000, 0x0000, 0xFFF2, 0x02D2, 0x0000, 0x0000, 0xFFF2, 0x0272,
    0x0000, 0x0000, 0xFFF2, 0x0228, 0x0000, 0x0000, 0xFFF2, 0x01EE,
    0x0000, 0x0000, 0xFFF2, 0x01BF, 0x0000, 0x0000, 0xFFF2, 0x0198,
    0x0000, 0x0000, 0xFFF2, 0x0177, 0x0000, 0x0000, 0xFFF2, 0x015B,
    0x0000, 0x0000, 0xFFF2, 0x0143, 0x0000, 0x0000, 0xFFF2, 0x012F,
    0x0000, 0x0000, 0xFFF2, 0x011C, 0x0000, 0x0000, 0xFFF2, 0x010C,
    0x0000, 0x0000, 0xFFF2, 0x00FD, 0x0000, 0x0000, 0xFFF2, 0x00F0,
    0x0000, 0x0000, 0xFFF2, 0x00E5, 0x0000, 0x0000, 0xFFF2, 0x00DA,
    0x0000, 0x0000, 0xFFF2, 0x00D0, 0x0000, 0x0000, 0xFFF2, 0x00C7,
    0x0000, 0x0000, 0xFFF2, 0x00BF, 0x0000, 0x0000, 0xFFF2, 0x00B8,
    0x0000, 0x0000, 0xFFF2, 0x00B1, 0x0000, 0x0000, 0xFFF2, 0x00AA,
    0x0000, 0x0000, 0xFFF2, 0x00A4, 0x0000, 0x0000, 0xFFF2, 0x009F,
    0x0000, 0x0000, 0xFFF2, 0x0099, 0x0000, 0x0000, 0xFFF2, 0x0095,
    0x0000, 0x0000, 0xFFF2, 0x0090, 0x0000, 0x0000, 0xFFF2, 0x008C,
    0x0000, 0x0000, 0xFFF2, 0x0088, 0x0000, 0x0000, 0xFFF2, 0x0084,
    0x0000, 0x0000, 0xFFF2, 0x0080, 0x0000, 0x0000, 0xFFF2, 0x007D,
    0x0000, 0x0000, 0xFFF2, 0x0079, 0x0000, 0x0000, 0xFFF2, 0x0076,
    0x0000, 0x0000, 0xFFF2, 0x0073, 0x0000, 0x0000, 0xFFF2, 0x0070,
    0x0000, 0x0000, 0xFFF2, 0x006E, 0x0000, 0x0000, 0xFFF2, 0x006B,
    0x0000, 0x0000, 0xFFF2, 0x0069, 0x0000, 0x0000, 0xFFF2, 0x0066,
    0x0000, 0x0000, 0xFFF2, 0x0064, 0x0000, 0x0000, 0xFFF2, 0x0062,
    0x0000, 0x0000, 0xFFF2, 0x0060, 0x0000, 0x0000, 0xFFF2, 0x005E,
    0x0000, 0x0000, 0xFFF2, 0x005C, 0x0000, 0x0000, 0xFFF2, 0x005A,
    0x0000, 0x0000, 0xFFF2, 0x0059, 0x0000, 0x0000, 0xFFF2, 0x0057,
    0x0000, 0x0000, 0xFFF2, 0x0055, 0x0000, 0x0000, 0xFFF2, 0x0054,
    0x0000, 0x0000, 0xFFF2, 0x0052, 0x0000, 0x0000, 0xFFF2, 0x0051,
    0x0000, 0x0000, 0xFFF2, 0x004F, 0x0000, 0x0000, 0xFFF2, 0x004E,
    0x0000, 0x0000, 0xFFF2, 0x004D, 0x0000, 0x0000, 0xFFF2, 0x004B,
    0x0000, 0x0000, 0xFFF2, 0x004A, 0x0000, 0x0000, 0xFFF2, 0x0049,
    0x0000, 0x0000, 0xFFF2, 0x0048, 0x0000, 0x0000, 0xFFF2, 0x0047,
    0x0000, 0x0000, 0xFFF2, 0x0046, 0x0000, 0x0000, 0xFFF2, 0x0045,
    0x0000, 0x0000, 0xFFF2, 0x0044, 0x0000, 0x0000, 0xFFF2, 0x0043,
    0x0000, 0x0000, 0xFFF2, 0x0042, 0x0000, 0x0000, 0xFFF2, 0x0041,
    0x0000, 0x0000, 0xFFF2, 0x0040, 0x0000, 0x0000, 0xFFF2, 0x003F,
    0x0000, 0x0000, 0xFFF2, 0x003E, 0x0000, 0x0000, 0xFFF2, 0x003D,
    0x0000, 0x0000, 0xFFF2, 0x003C, 0x0000, 0x0000, 0xFFF2, 0x003B,
    0x0000, 0x0000, 0xFFF2, 0x003B, 0x0000, 0x0000, 0xFFF2, 0x003A,
    0x0000, 0x0000, 0xFFF2, 0x0039, 0x0000, 0x0000, 0xFFF2, 0x0038,
    0x0000, 0x0000, 0xFFF2, 0x0038, 0x0000, 0x0000, 0xFFF2, 0x0037,
    0x0000, 0x0000, 0xFFF2, 0x0036, 0x0000, 0x0000, 0xFFF2, 0x0036,
    0x0000, 0x0000, 0xFFF2, 0x0035, 0x0000, 0x0000, 0xFFF2, 0x0034,
    0x0000, 0x0000, 0xFFF2, 0x0034, 0x0000, 0x0000, 0xFFF2, 0x0033,
    0x0000, 0x0000, 0xFFF2, 0x0033, 0x0000, 0x0000, 0xFFF2, 0x0032,
    0x0000, 0x0000, 0xFFF2, 0x0031, 0x0000, 0x0000, 0xFFF2, 0x0031,
    0x0000, 0x0000, 0xFFF2, 0x0030, 0x0000, 0x0000, 0xFFF2, 0x0030,
    0x0000, 0x0000, 0xFFF2, 0x002F, 0x0000, 0x0000, 0xFFF2, 0x002F,
    0x0000, 0x0000, 0xFFF2, 0x002E, 0x0000, 0x0000, 0xFFF2, 0x002E,
    0x0000, 0x0000, 0xFFF2, 0x002D, 0x0000, 0x0000, 0xFFF2, 0x002D,
    0x0000, 0x0000, 0xFFF2, 0x002C, 0x0000, 0x0000, 0xFFF2, 0x002C,
    0x0000, 0x0000, 0xFFF2, 0x002B, 0x0000, 0x0000, 0xFFF2, 0x002B,
    0x0000, 0x0000, 0xFFF2, 0x002A, 0x0000, 0x0000, 0xFFF2, 0x002A,
    0x0000, 0x0000, 0xFFF2, 0x002A, 0x0000, 0x0000, 0xFFF2, 0x0029,
    0x0000, 0x0000, 0xFFF2, 0x0029, 0x0000, 0x0000, 0xFFF2, 0x0028,
    0x0000, 0x0000, 0xFFF2, 0x0028, 0x0000, 0x0000, 0xFFF2, 0x0028,
    0x0000, 0x0000, 0xFFF2, 0x0027, 0x0000, 0x0000, 0xFFF2, 0x0027,
    0x0000, 0x0000, 0xFFF2, 0x0027, 0x0000, 0x0000, 0xFFF2, 0x0026,
    0x0000, 0x0000, 0xFFF2, 0x0026, 0x0000, 0x0000, 0xFFF2, 0x0026,
    0x0000, 0x0000, 0xFFF2, 0x0025, 0x0000, 0x0000, 0xFFF2, 0x0025,
    0x0000, 0x0000, 0xFFF2, 0x0024, 0x0000, 0x0000, 0xFFF2, 0x0024,
    0x0000, 0x0000, 0xFFF2, 0x0024, 0x0000, 0x0000, 0xFFF2, 0x0024,
    0x0000, 0x0000, 0xFFF2, 0x0023, 0x0000, 0x0000, 0xFFF2, 0x0023,
    0x0000, 0x0000, 0xFFF2, 0x0023, 0x0000, 0x0000, 0xFFF2, 0x0022,
    0x0000, 0x0000, 0xFFF2, 0x0022, 0x0000, 0x0000, 0xFFF2, 0x0022,
    0x0000, 0x0000, 0xFFF2, 0x0021, 0x0000, 0x0000, 0xFFF2, 0x0021,
    0x0000, 0x0000, 0xFFF2, 0x0021, 0x0000, 0x0000, 0xFFF2, 0x0021,
    0x0000, 0x0000, 0xFFF2, 0x0020, 0x0000, 0x0000, 0xFFF2, 0x0020,
    0x0000, 0x0000, 0xFFF2, 0x0020, 0x0000, 0x0000, 0xFFF2, 0x0020,
    0x0000, 0x0000, 0xFFF2, 0x001F, 0x0000, 0x0000, 0xFFF2, 0x001F,
    0x0000, 0x0000, 0xFFF2, 0x001F, 0x0000, 0x0000, 0xFFF2, 0x001F,
    0x0000, 0x0000, 0xFFF2, 0x001E, 0x0000, 0x0000, 0xFFF2, 0x001E,
    0x0000, 0x0000, 0xFFF2, 0x001E, 0x0000, 0x0000, 0xFFF2, 0x001E,
    0x0000, 0x0000, 0xFFF2, 0x001D, 0x0000, 0x0000, 0xFFF2, 0x001D,
    0x0000, 0x0000, 0xFFF2, 0x001D, 0x0000, 0x0000, 0xFFF2, 0x001D,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001C,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001C,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001B, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001B, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0019,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0019,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE7, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE7, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE5,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE5,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE4, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE4, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE3, 0x0000, 0x0000, 0xFFF2, 0xFFE3,
    0x0000, 0x0000, 0xFFF2, 0xFFE3, 0x0000, 0x0000, 0xFFF2, 0xFFE3,
    0x0000, 0x0000, 0xFFF2, 0xFFE2, 0x0000, 0x0000, 0xFFF2, 0xFFE2,
    0x0000, 0x0000, 0xFFF2, 0xFFE2, 0x0000, 0x0000, 0xFFF2, 0xFFE2,
    0x0000, 0x0000, 0xFFF2, 0xFFE1, 0x0000, 0x0000, 0xFFF2, 0xFFE1,
    0x0000, 0x0000, 0xFFF2, 0xFFE1, 0x0000, 0x0000, 0xFFF2, 0xFFE1,
    0x0000, 0x0000, 0xFFF2, 0xFFE0, 0x0000, 0x0000, 0xFFF2, 0xFFE0,
    0x0000, 0x0000, 0xFFF2, 0xFFE0, 0x0000, 0x0000, 0xFFF2, 0xFFE0,
    0x0000, 0x0000, 0xFFF2, 0xFFDF, 0x0000, 0x0000, 0xFFF2, 0xFFDF,
    0x0000, 0x0000, 0xFFF2, 0xFFDF, 0x0000, 0x0000, 0xFFF2, 0xFFDF,
    0x0000, 0x0000, 0xFFF2, 0xFFDE, 0x0000, 0x0000, 0xFFF2, 0xFFDE,
    0x0000, 0x0000, 0xFFF2, 0xFFDE, 0x0000, 0x0000, 0xFFF2, 0xFFDD,
    0x0000, 0x0000, 0xFFF2, 0xFFDD, 0x0000, 0x0000, 0xFFF2, 0xFFDD,
    0x0000, 0x0000, 0xFFF2, 0xFFDC, 0x0000, 0x0000, 0xFFF2, 0xFFDC,
    0x0000, 0x0000, 0xFFF2, 0xFFDC, 0x0000, 0x0000, 0xFFF2, 0xFFDC,
    0x0000, 0x0000, 0xFFF2, 0xFFDB, 0x0000, 0x0000, 0xFFF2, 0xFFDB,
    0x0000, 0x0000, 0xFFF2, 0xFFDA, 0x0000, 0x0000, 0xFFF2, 0xFFDA,
    0x0000, 0x0000, 0xFFF2, 0xFFDA, 0x0000, 0x0000, 0xFFF2, 0xFFD9,
    0x0000, 0x0000, 0xFFF2, 0xFFD9, 0x0000, 0x0000, 0xFFF2, 0xFFD9,
    0x0000, 0x0000, 0xFFF2, 0xFFD8, 0x0000, 0x0000, 0xFFF2, 0xFFD8,
    0x0000, 0x0000, 0xFFF2, 0xFFD8, 0x0000, 0x0000, 0xFFF2, 0xFFD7,
    0x0000, 0x0000, 0xFFF2, 0xFFD7, 0x0000, 0x0000, 0xFFF2, 0xFFD6,
    0x0000, 0x0000, 0xFFF2, 0xFFD6, 0x0000, 0x0000, 0xFFF2, 0xFFD6,
    0x0000, 0x0000, 0xFFF2, 0xFFD5, 0x0000, 0x0000, 0xFFF2, 0xFFD5,
    0x0000, 0x0000, 0xFFF2, 0xFFD4, 0x0000, 0x0000, 0xFFF2, 0xFFD4,
    0x0000, 0x0000, 0xFFF2, 0xFFD3, 0x0000, 0x0000, 0xFFF2, 0xFFD3,
    0x0000, 0x0000, 0xFFF2, 0xFFD2, 0x0000, 0x0000, 0xFFF2, 0xFFD2,
    0x0000, 0x0000, 0xFFF2, 0xFFD1, 0x0000, 0x0000, 0xFFF2, 0xFFD1,
    0x0000, 0x0000, 0xFFF2, 0xFFD0, 0x0000, 0x0000, 0xFFF2, 0xFFD0,
    0x0000, 0x0000, 0xFFF2, 0xFFCF, 0x0000, 0x0000, 0xFFF2, 0xFFCF,
    0x0000, 0x0000, 0xFFF2, 0xFFCE, 0x0000, 0x0000, 0xFFF2, 0xFFCD,
    0x0000, 0x0000, 0xFFF2, 0xFFCD, 0x0000, 0x0000, 0xFFF2, 0xFFCC,
    0x0000, 0x0000, 0xFFF2, 0xFFCC, 0x0000, 0x0000, 0xFFF2, 0xFFCB,
    0x0000, 0x0000, 0xFFF2, 0xFFCA, 0x0000, 0x0000, 0xFFF2, 0xFFCA,
    0x0000, 0x0000, 0xFFF2, 0xFFC9, 0x0000, 0x0000, 0xFFF2, 0xFFC8,
    0x0000, 0x0000, 0xFFF2, 0xFFC8, 0x0000, 0x0000, 0xFFF2, 0xFFC7,
    0x0000, 0x0000, 0xFFF2, 0xFFC6, 0x0000, 0x0000, 0xFFF2, 0xFFC5,
    0x0000, 0x0000, 0xFFF2, 0xFFC5, 0x0000, 0x0000, 0xFFF2, 0xFFC4,
    0x0000, 0x0000, 0xFFF2, 0xFFC3, 0x0000, 0x0000, 0xFFF2, 0xFFC2,
    0x0000, 0x0000, 0xFFF2, 0xFFC1, 0x0000, 0x0000, 0xFFF2, 0xFFC0,
    0x0000, 0x0000, 0xFFF2, 0xFFBF, 0x0000, 0x0000, 0xFFF2, 0xFFBE,
    0x0000, 0x0000, 0xFFF2, 0xFFBD, 0x0000, 0x0000, 0xFFF2, 0xFFBC,
    0x0000, 0x0000, 0xFFF2, 0xFFBB, 0x0000, 0x0000, 0xFFF2, 0xFFBA,
    0x0000, 0x0000, 0xFFF2, 0xFFB9, 0x0000, 0x0000, 0xFFF2, 0xFFB8,
    0x0000, 0x0000, 0xFFF2, 0xFFB7, 0x0000, 0x0000, 0xFFF2, 0xFFB6,
    0x0000, 0x0000, 0xFFF2, 0xFFB5, 0x0000, 0x0000, 0xFFF2, 0xFFB3,
    0x0000, 0x0000, 0xFFF2, 0xFFB2, 0x0000, 0x0000, 0xFFF2, 0xFFB1,
    0x0000, 0x0000, 0xFFF2, 0xFFAF, 0x0000, 0x0000, 0xFFF2, 0xFFAE,
    0x0000, 0x0000, 0xFFF2, 0xFFAC, 0x0000, 0x0000, 0xFFF2, 0xFFAB,
    0x0000, 0x0000, 0xFFF2, 0xFFA9, 0x0000, 0x0000, 0xFFF2, 0xFFA7,
    0x0000, 0x0000, 0xFFF2, 0xFFA6, 0x0000, 0x0000, 0xFFF2, 0xFFA4,
    0x0000, 0x0000, 0xFFF2, 0xFFA2, 0x0000, 0x0000, 0xFFF2, 0xFFA0,
    0x0000, 0x0000, 0xFFF2, 0xFF9E, 0x0000, 0x0000, 0xFFF2, 0xFF9C,
    0x0000, 0x0000, 0xFFF2, 0xFF9A, 0x0000, 0x0000, 0xFFF2, 0xFF97,
    0x0000, 0x0000, 0xFFF2, 0xFF95, 0x0000, 0x0000, 0xFFF2, 0xFF92,
    0x0000, 0x0000, 0xFFF2, 0xFF90, 0x0000, 0x0000, 0xFFF2, 0xFF8D,
    0x0000, 0x0000, 0xFFF2, 0xFF8A, 0x0000, 0x0000, 0xFFF2, 0xFF87,
    0x0000, 0x0000, 0xFFF2, 0xFF83, 0x0000, 0x0000, 0xFFF2, 0xFF80,
    0x0000, 0x0000, 0xFFF2, 0xFF7C, 0x0000, 0x0000, 0xFFF2, 0xFF78,
    0x0000, 0x0000, 0xFFF2, 0xFF74, 0x0000, 0x0000, 0xFFF2, 0xFF70,
    0x0000, 0x0000, 0xFFF2, 0xFF6B, 0x0000, 0x0000, 0xFFF2, 0xFF67,
    0x0000, 0x0000, 0xFFF2, 0xFF61, 0x0000, 0x0000, 0xFFF2, 0xFF5C,
    0x0000, 0x0000, 0xFFF2, 0xFF56, 0x0000, 0x0000, 0xFFF2, 0xFF4F,
    0x0000, 0x0000, 0xFFF2, 0xFF48, 0x0000, 0x0000, 0xFFF2, 0xFF41,
    0x0000, 0x0000, 0xFFF2, 0xFF39, 0x0000, 0x0000, 0xFFF2, 0xFF30,
    0x0000, 0x0000, 0xFFF2, 0xFF26, 0x0000, 0x0000, 0xFFF2, 0xFF1B,
    0x0000, 0x0000, 0xFFF2, 0xFF10, 0x0000, 0x0000, 0xFFF2, 0xFF03,
    0x0000, 0x0000, 0xFFF2, 0xFEF4, 0x0000, 0x0000, 0xFFF2, 0xFEE4,
    0x0000, 0x0000, 0xFFF2, 0xFED1, 0x0000, 0x0000, 0xFFF2, 0xFEBD,
    0x0000, 0x0000, 0xFFF2, 0xFEA5, 0x0000, 0x0000, 0xFFF2, 0xFE89,
    0x0000, 0x0000, 0xFFF2, 0xFE68, 0x0000, 0x0000, 0xFFF2, 0xFE41,
    0x0000, 0x0000, 0xFFF2, 0xFE12, 0x0000, 0x0000, 0xFFF2, 0xFDD8,
    0x0000, 0x0000, 0xFFF2, 0xFD8E, 0x0000, 0x0000, 0xFFF2, 0xFD2E,
    0x0000, 0x0000, 0xFFF2, 0xFCAB, 0x0000, 0x0000, 0xFFF2, 0xFBED,
    0x0000, 0x0000, 0xFFF2, 0xFAC3, 0x0000, 0x0000, 0xFFF2, 0xF8AB,
    0x0000, 0x0000, 0xFFF2, 0xF3C7, 0x0000, 0x0000, 0xFFF2, 0xDB55
    };

static const q15_t in_cfft_step_4096[8192] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000,
    0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000, 0x7333, 0x0000
    };

static const q15_t in_cifft_step_4096[8192] = {
    0x399A, 0x0000, 0xFFF9, 0x24AB, 0x0000, 0x0000, 0xFFF9, 0x0C39,
    0x0000, 0x0000, 0xFFF9, 0x0755, 0x0000, 0x0000, 0xFFF9, 0x053D,
    0x0000, 0x0000, 0xFFF9, 0x0413, 0x0000, 0x0000, 0xFFF9, 0x0355,
    0x0000, 0x0000, 0xFFF9, 0x02D2, 0x0000, 0x0000, 0xFFF9, 0x0272,
    0x0000, 0x0000, 0xFFF9, 0x0228, 0x0000, 0x0000, 0xFFF9, 0x01EE,
    0x0000, 0x0000, 0xFFF9, 0x01BF, 0x0000, 0x0000, 0xFFF9, 0x0198,
    0x0000, 0x0000, 0xFFF9, 0x0177, 0x0000, 0x0000, 0xFFF9, 0x015C,
    0x0000, 0x0000, 0xFFF9, 0x0144, 0x0000, 0x0000, 0xFFF9, 0x012F,
    0x0000, 0x0000, 0xFFF9, 0x011C, 0x0000, 0x0000, 0xFFF9, 0x010C,
    0x0000, 0x0000, 0xFFF9, 0x00FE, 0x0000, 0x0000, 0xFFF9, 0x00F1,
    0x0000, 0x0000, 0xFFF9, 0x00E5, 0x0000, 0x0000, 0xFFF9, 0x00DA,
    0x0000, 0x0000, 0xFFF9, 0x00D1, 0x0000, 0x0000, 0xFFF9, 0x00C8,
    0x0000, 0x0000, 0xFFF9, 0x00BF, 0x0000, 0x0000, 0xFFF9, 0x00B8,
    0x0000, 0x0000, 0xFFF9, 0x00B1, 0x0000, 0x0000, 0xFFF9, 0x00AB,
    0x0000, 0x0000, 0xFFF9, 0x00A5, 0x0000, 0x0000, 0xFFF9, 0x009F,
    0x0000, 0x0000, 0xFFF9, 0x009A, 0x0000, 0x0000, 0xFFF9, 0x0095,
    0x0000, 0x0000, 0xFFF9, 0x0090, 0x0000, 0x0000, 0xFFF9, 0x008C,
    0x0000, 0x0000, 0xFFF9, 0x0088, 0x0000, 0x0000, 0xFFF9, 0x0084,
    0x0000, 0x0000, 0xFFF9, 0x0080, 0x0000, 0x0000, 0xFFF9, 0x007D,
    0x0000, 0x0000, 0xFFF9, 0x007A, 0x0000, 0x0000, 0xFFF9, 0x0077,
    0x0000, 0x0000, 0xFFF9, 0x0074, 0x0000, 0x0000, 0xFFF9, 0x0071,
    0x0000, 0x0000, 0xFFF9, 0x006E, 0x0000, 0x0000, 0xFFF9, 0x006C,
    0x0000, 0x0000, 0xFFF9, 0x0069, 0x0000, 0x0000, 0xFFF9, 0x0067,
    0x0000, 0x0000, 0xFFF9, 0x0065, 0x0000, 0x0000, 0xFFF9, 0x0063,
    0x0000, 0x0000, 0xFFF9, 0x0061, 0x0000, 0x0000, 0xFFF9, 0x005F,
    0x0000, 0x0000, 0xFFF9, 0x005D, 0x0000, 0x0000, 0xFFF9, 0x005B,
    0x0000, 0x0000, 0xFFF9, 0x0059, 0x0000, 0x0000, 0xFFF9, 0x0058,
    0x0000, 0x0000, 0xFFF9, 0x0056, 0x0000, 0x0000, 0xFFF9, 0x0054,
    0x0000, 0x0000, 0xFFF9, 0x0053, 0x0000, 0x0000, 0xFFF9, 0x0051,
    0x0000, 0x0000, 0xFFF9, 0x0050, 0x0000, 0x0000, 0xFFF9, 0x004F,
    0x0000, 0x0000, 0xFFF9, 0x004D, 0x0000, 0x0000, 0xFFF9, 0x004C,
    0x0000, 0x0000, 0xFFF9, 0x004B, 0x0000, 0x0000, 0xFFF9, 0x004A,
    0x0000, 0x0000, 0xFFF9, 0x0049, 0x0000, 0x0000, 0xFFF9, 0x0047,
    0x0000, 0x0000, 0xFFF9, 0x0046, 0x0000, 0x0000, 0xFFF9, 0x0045,
    0x0000, 0x0000, 0xFFF9, 0x0044, 0x0000, 0x0000, 0xFFF9, 0x0043,
    0x0000, 0x0000, 0xFFF9, 0x0042, 0x0000, 0x0000, 0xFFF9, 0x0041,
    0x0000, 0x0000, 0xFFF9, 0x0040, 0x0000, 0x0000, 0xFFF9, 0x0040,
    0x0000, 0x0000, 0xFFF9, 0x003F, 0x0000, 0x0000, 0xFFF9, 0x003E,
    0x0000, 0x0000, 0xFFF9, 0x003D, 0x0000, 0x0000, 0xFFF9, 0x003C,
    0x0000, 0x0000, 0xFFF9, 0x003C, 0x0000, 0x0000, 0xFFF9, 0x003B,
    0x0000, 0x0000, 0xFFF9, 0x003A, 0x0000, 0x0000, 0xFFF9, 0x0039,
    0x0000, 0x0000, 0xFFF9, 0x0039, 0x0000, 0x0000, 0xFFF9, 0x0038,
    0x0000, 0x0000, 0xFFF9, 0x0037, 0x0000, 0x0000, 0xFFF9, 0x0037,
    0x0000, 0x0000, 0xFFF9, 0x0036, 0x0000, 0x0000, 0xFFF9, 0x0035,
    0x0000, 0x0000, 0xFFF9, 0x0035, 0x0000, 0x0000, 0xFFF9, 0x0034,
    0x0000, 0x0000, 0xFFF9, 0x0034, 0x0000, 0x0000, 0xFFF9, 0x0033,
    0x0000, 0x0000, 0xFFF9, 0x0032, 0x0000, 0x0000, 0xFFF9, 0x0032,
    0x0000, 0x0000, 0xFFF9, 0x0031, 0x0000, 0x0000, 0xFFF9, 0x0031,
    0x0000, 0x0000, 0xFFF9, 0x0030, 0x0000, 0x0000, 0xFFF9, 0x0030,
    0x0000, 0x0000, 0xFFF9, 0x002F, 0x0000, 0x0000, 0xFFF9, 0x002F,
    0x0000, 0x0000, 0xFFF9, 0x002E, 0x0000, 0x0000, 0xFFF9, 0x002E,
    0x0000, 0x0000, 0xFFF9, 0x002D, 0x0000, 0x0000, 0xFFF9, 0x002D,
    0x0000, 0x0000, 0xFFF9, 0x002D, 0x0000, 0x0000, 0xFFF9, 0x002C,
    0x0000, 0x0000, 0xFFF9, 0x002C, 0x0000, 0x0000, 0xFFF9, 0x002B,
    0x0000, 0x0000, 0xFFF9, 0x002B, 0x0000, 0x0000, 0xFFF9, 0x002A,
    0x0000, 0x0000, 0xFFF9, 0x002A, 0x0000, 0x0000, 0xFFF9, 0x002A,
    0x0000, 0x0000, 0xFFF9, 0x0029, 0x0000, 0x0000, 0xFFF9, 0x0029,
    0x0000, 0x0000, 0xFFF9, 0x0029, 0x0000, 0x0000, 0xFFF9, 0x0028,
    0x0000, 0x0000, 0xFFF9, 0x0028, 0x0000, 0x0000, 0xFFF9, 0x0028,
    0x0000, 0x0000, 0xFFF9, 0x0027, 0x0000, 0x0000, 0xFFF9, 0x0027,
    0x0000, 0x0000, 0xFFF9, 0x0027, 0x0000, 0x0000, 0xFFF9, 0x0026,
    0x0000, 0x0000, 0xFFF9, 0x0026, 0x0000, 0x0000, 0xFFF9, 0x0026,
    0x0000, 0x0000, 0xFFF9, 0x0025, 0x0000, 0x0000, 0xFFF9, 0x0025,
    0x0000, 0x0000, 0xFFF9, 0x0025, 0x0000, 0x0000, 0xFFF9, 0x0024,
    0x0000, 0x0000, 0xFFF9, 0x0024, 0x0000, 0x0000, 0xFFF9, 0x0024,
    0x0000, 0x0000, 0xFFF9, 0x0023, 0x0000, 0x0000, 0xFFF9, 0x0023,
    0x0000, 0x0000, 0xFFF9, 0x0023, 0x0000, 0x0000, 0xFFF9, 0x0023,
    0x0000, 0x0000, 0xFFF9, 0x0022, 0x0000, 0x0000, 0xFFF9, 0x0022,
    0x0000, 0x0000, 0xFFF9, 0x0022, 0x0000, 0x0000, 0xFFF9, 0x0022,
    0x0000, 0x0000, 0xFFF9, 0x0021, 0x0000, 0x0000, 0xFFF9, 0x0021,
    0x0000, 0x0000, 0xFFF9, 0x0021, 0x0000, 0x0000, 0xFFF9, 0x0021,
    0x0000, 0x0000, 0xFFF9, 0x0020, 0x0000, 0x0000, 0xFFF9, 0x0020,
    0x0000, 0x0000, 0xFFF9, 0x0020, 0x0000, 0x0000, 0xFFF9, 0x0020,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001F,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001F,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001E, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001E, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001D,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001D,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE3, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE3, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE2,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE2,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE1, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE1, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE0, 0x0000, 0x0000, 0xFFF9, 0xFFE0,
    0x0000, 0x0000, 0xFFF9, 0xFFE0, 0x0000, 0x0000, 0xFFF9, 0xFFE0,
    0x0000, 0x0000, 0xFFF9, 0xFFDF, 0x0000, 0x0000, 0xFFF9, 0xFFDF,
    0x0000, 0x0000, 0xFFF9, 0xFFDF, 0x0000, 0x0000, 0xFFF9, 0xFFDF,
    0x0000, 0x0000, 0xFFF9, 0xFFDE, 0x0000, 0x0000, 0xFFF9, 0xFFDE,
    0x0000, 0x0000, 0xFFF9, 0xFFDE, 0x0000, 0x0000, 0xFFF9, 0xFFDE,
    0x0000, 0x0000, 0xFFF9, 0xFFDD, 0x0000, 0x0000, 0xFFF9, 0xFFDD,
    0x0000, 0x0000, 0xFFF9, 0xFFDD, 0x0000, 0x0000, 0xFFF9, 0xFFDD,
    0x0000, 0x0000, 0xFFF9, 0xFFDC, 0x0000, 0x0000, 0xFFF9, 0xFFDC,
    0x0000, 0x0000, 0xFFF9, 0xFFDC, 0x0000, 0x0000, 0xFFF9, 0xFFDB,
    0x0000, 0x0000, 0xFFF9, 0xFFDB, 0x0000, 0x0000, 0xFFF9, 0xFFDB,
    0x0000, 0x0000, 0xFFF9, 0xFFDA, 0x0000, 0x0000, 0xFFF9, 0xFFDA,
    0x0000, 0x0000, 0xFFF9, 0xFFDA, 0x0000, 0x0000, 0xFFF9, 0xFFD9,
    0x0000, 0x0000, 0xFFF9, 0xFFD9, 0x0000, 0x0000, 0xFFF9, 0xFFD9,
    0x0000, 0x0000, 0xFFF9, 0xFFD8, 0x0000, 0x0000, 0xFFF9, 0xFFD8,
    0x0000, 0x0000, 0xFFF9, 0xFFD8, 0x0000, 0x0000, 0xFFF9, 0xFFD7,
    0x0000, 0x0000, 0xFFF9, 0xFFD7, 0x0000, 0x0000, 0xFFF9, 0xFFD7,
    0x0000, 0x0000, 0xFFF9, 0xFFD6, 0x0000, 0x0000, 0xFFF9, 0xFFD6,
    0x0000, 0x0000, 0xFFF9, 0xFFD6, 0x0000, 0x0000, 0xFFF9, 0xFFD5,
    0x0000, 0x0000, 0xFFF9, 0xFFD5, 0x0000, 0x0000, 0xFFF9, 0xFFD4,
    0x0000, 0x0000, 0xFFF9, 0xFFD4, 0x0000, 0x0000, 0xFFF9, 0xFFD3,
    0x0000, 0x0000, 0xFFF9, 0xFFD3, 0x0000, 0x0000, 0xFFF9, 0xFFD3,
    0x0000, 0x0000, 0xFFF9, 0xFFD2, 0x0000, 0x0000, 0xFFF9, 0xFFD2,
    0x0000, 0x0000, 0xFFF9, 0xFFD1, 0x0000, 0x0000, 0xFFF9, 0xFFD1,
    0x0000, 0x0000, 0xFFF9, 0xFFD0, 0x0000, 0x0000, 0xFFF9, 0xFFD0,
    0x0000, 0x0000, 0xFFF9, 0xFFCF, 0x0000, 0x0000, 0xFFF9, 0xFFCF,
    0x0000, 0x0000, 0xFFF9, 0xFFCE, 0x0000, 0x0000, 0xFFF9, 0xFFCE,
    0x0000, 0x0000, 0xFFF9, 0xFFCD, 0x0000, 0x0000, 0xFFF9, 0xFFCC,
    0x0000, 0x0000, 0xFFF9, 0xFFCC, 0x0000, 0x0000, 0xFFF9, 0xFFCB,
    0x0000, 0x0000, 0xFFF9, 0xFFCB, 0x0000, 0x0000, 0xFFF9, 0xFFCA,
    0x0000, 0x0000, 0xFFF9, 0xFFC9, 0x0000, 0x0000, 0xFFF9, 0xFFC9,
    0x0000, 0x0000, 0xFFF9, 0xFFC8, 0x0000, 0x0000, 0xFFF9, 0xFFC7,
    0x0000, 0x0000, 0xFFF9, 0xFFC7, 0x0000, 0x0000, 0xFFF9, 0xFFC6,
    0x0000, 0x0000, 0xFFF9, 0xFFC5, 0x0000, 0x0000, 0xFFF9, 0xFFC4,
    0x0000, 0x0000, 0xFFF9, 0xFFC4, 0x0000, 0x0000, 0xFFF9, 0xFFC3,
    0x0000, 0x0000, 0xFFF9, 0xFFC2, 0x0000, 0x0000, 0xFFF9, 0xFFC1,
    0x0000, 0x0000, 0xFFF9, 0xFFC0, 0x0000, 0x0000, 0xFFF9, 0xFFC0,
    0x0000, 0x0000, 0xFFF9, 0xFFBF, 0x0000, 0x0000, 0xFFF9, 0xFFBE,
    0x0000, 0x0000, 0xFFF9, 0xFFBD, 0x0000, 0x0000, 0xFFF9, 0xFFBC,
    0x0000, 0x0000, 0xFFF9, 0xFFBB, 0x0000, 0x0000, 0xFFF9, 0xFFBA,
    0x0000, 0x0000, 0xFFF9, 0xFFB9, 0x0000, 0x0000, 0xFFF9, 0xFFB7,
    0x0000, 0x0000, 0xFFF9, 0xFFB6, 0x0000, 0x0000, 0xFFF9, 0xFFB5,
    0x0000, 0x0000, 0xFFF9, 0xFFB4, 0x0000, 0x0000, 0xFFF9, 0xFFB3,
    0x0000, 0x0000, 0xFFF9, 0xFFB1, 0x0000, 0x0000, 0xFFF9, 0xFFB0,
    0x0000, 0x0000, 0xFFF9, 0xFFAF, 0x0000, 0x0000, 0xFFF9, 0xFFAD,
    0x0000, 0x0000, 0xFFF9, 0xFFAC, 0x0000, 0x0000, 0xFFF9, 0xFFAA,
    0x0000, 0x0000, 0xFFF9, 0xFFA8, 0x0000, 0x0000, 0xFFF9, 0xFFA7,
    0x0000, 0x0000, 0xFFF9, 0xFFA5, 0x0000, 0x0000, 0xFFF9, 0xFFA3,
    0x0000, 0x0000, 0xFFF9, 0xFFA1, 0x0000, 0x0000, 0xFFF9, 0xFF9F,
    0x0000, 0x0000, 0xFFF9, 0xFF9D, 0x0000, 0x0000, 0xFFF9, 0xFF9B,
    0x0000, 0x0000, 0xFFF9, 0xFF99, 0x0000, 0x0000, 0xFFF9, 0xFF97,
    0x0000, 0x0000, 0xFFF9, 0xFF94, 0x0000, 0x0000, 0xFFF9, 0xFF92,
    0x0000, 0x0000, 0xFFF9, 0xFF8F, 0x0000, 0x0000, 0xFFF9, 0xFF8C,
    0x0000, 0x0000, 0xFFF9, 0xFF89, 0x0000, 0x0000, 0xFFF9, 0xFF86,
    0x0000, 0x0000, 0xFFF9, 0xFF83, 0x0000, 0x0000, 0xFFF9, 0xFF80,
    0x0000, 0x0000, 0xFFF9, 0xFF7C, 0x0000, 0x0000, 0xFFF9, 0xFF78,
    0x0000, 0x0000, 0xFFF9, 0xFF74, 0x0000, 0x0000, 0xFFF9, 0xFF70,
    0x0000, 0x0000, 0xFFF9, 0xFF6B, 0x0000, 0x0000, 0xFFF9, 0xFF66,
    0x0000, 0x0000, 0xFFF9, 0xFF61, 0x0000, 0x0000, 0xFFF9, 0xFF5B,
    0x0000, 0x0000, 0xFFF9, 0xFF55, 0x0000, 0x0000, 0xFFF9, 0xFF4F,
    0x0000, 0x0000, 0xFFF9, 0xFF48, 0x0000, 0x0000, 0xFFF9, 0xFF41,
    0x0000, 0x0000, 0xFFF9, 0xFF38, 0x0000, 0x0000, 0xFFF9, 0xFF2F,
    0x0000, 0x0000, 0xFFF9, 0xFF26, 0x0000, 0x0000, 0xFFF9, 0xFF1B,
    0x0000, 0x0000, 0xFFF9, 0xFF0F, 0x0000, 0x0000, 0xFFF9, 0xFF02,
    0x0000, 0x0000, 0xFFF9, 0xFEF4, 0x0000, 0x0000, 0xFFF9, 0xFEE4,
    0x0000, 0x0000, 0xFFF9, 0xFED1, 0x0000, 0x0000, 0xFFF9, 0xFEBC,
    0x0000, 0x0000, 0xFFF9, 0xFEA4, 0x0000, 0x0000, 0xFFF9, 0xFE89,
    0x0000, 0x0000, 0xFFF9, 0xFE68, 0x0000, 0x0000, 0xFFF9, 0xFE41,
    0x0000, 0x0000, 0xFFF9, 0xFE12, 0x0000, 0x0000, 0xFFF9, 0xFDD8,
    0x0000, 0x0000, 0xFFF9, 0xFD8E, 0x0000, 0x0000, 0xFFF9, 0xFD2E,
    0x0000, 0x0000, 0xFFF9, 0xFCAB, 0x0000, 0x0000, 0xFFF9, 0xFBED,
    0x0000, 0x0000, 0xFFF9, 0xFAC3, 0x0000, 0x0000, 0xFFF9, 0xF8AB,
    0x0000, 0x0000, 0xFFF9, 0xF3C7, 0x0000, 0x0000, 0xFFF9, 0xDB55
    };

static const q15_t ref_cfft_step_4096[8192] = {
    0x399A, 0x0000, 0xFFF9, 0x24AB, 0x0000, 0x0000, 0xFFF9, 0x0C39,
    0x0000, 0x0000, 0xFFF9, 0x0755, 0x0000, 0x0000, 0xFFF9, 0x053D,
    0x0000, 0x0000, 0xFFF9, 0x0413, 0x0000, 0x0000, 0xFFF9, 0x0355,
    0x0000, 0x0000, 0xFFF9, 0x02D2, 0x0000, 0x0000, 0xFFF9, 0x0272,
    0x0000, 0x0000, 0xFFF9, 0x0228, 0x0000, 0x0000, 0xFFF9, 0x01EE,
    0x0000, 0x0000, 0xFFF9, 0x01BF, 0x0000, 0x0000, 0xFFF9, 0x0198,
    0x0000, 0x0000, 0xFFF9, 0x0177, 0x0000, 0x0000, 0xFFF9, 0x015C,
    0x0000, 0x0000, 0xFFF9, 0x0144, 0x0000, 0x0000, 0xFFF9, 0x012F,
    0x0000, 0x0000, 0xFFF9, 0x011C, 0x0000, 0x0000, 0xFFF9, 0x010C,
    0x0000, 0x0000, 0xFFF9, 0x00FE, 0x0000, 0x0000, 0xFFF9, 0x00F1,
    0x0000, 0x0000, 0xFFF9, 0x00E5, 0x0000, 0x0000, 0xFFF9, 0x00DA,
    0x0000, 0x0000, 0xFFF9, 0x00D1, 0x0000, 0x0000, 0xFFF9, 0x00C8,
    0x0000, 0x0000, 0xFFF9, 0x00BF, 0x0000, 0x0000, 0xFFF9, 0x00B8,
    0x0000, 0x0000, 0xFFF9, 0x00B1, 0x0000, 0x0000, 0xFFF9, 0x00AB,
    0x0000, 0x0000, 0xFFF9, 0x00A5, 0x0000, 0x0000, 0xFFF9, 0x009F,
    0x0000, 0x0000, 0xFFF9, 0x009A, 0x0000, 0x0000, 0xFFF9, 0x0095,
    0x0000, 0x0000, 0xFFF9, 0x0090, 0x0000, 0x0000, 0xFFF9, 0x008C,
    0x0000, 0x0000, 0xFFF9, 0x0088, 0x0000, 0x0000, 0xFFF9, 0x0084,
    0x0000, 0x0000, 0xFFF9, 0x0080, 0x0000, 0x0000, 0xFFF9, 0x007D,
    0x0000, 0x0000, 0xFFF9, 0x007A, 0x0000, 0x0000, 0xFFF9, 0x0077,
    0x0000, 0x0000, 0xFFF9, 0x0074, 0x0000, 0x0000, 0xFFF9, 0x0071,
    0x0000, 0x0000, 0xFFF9, 0x006E, 0x0000, 0x0000, 0xFFF9, 0x006C,
    0x0000, 0x0000, 0xFFF9, 0x0069, 0x0000, 0x0000, 0xFFF9, 0x0067,
    0x0000, 0x0000, 0xFFF9, 0x0065, 0x0000, 0x0000, 0xFFF9, 0x0063,
    0x0000, 0x0000, 0xFFF9, 0x0061, 0x0000, 0x0000, 0xFFF9, 0x005F,
    0x0000, 0x0000, 0xFFF9, 0x005D, 0x0000, 0x0000, 0xFFF9, 0x005B,
    0x0000, 0x0000, 0xFFF9, 0x0059, 0x0000, 0x0000, 0xFFF9, 0x0058,
    0x0000, 0x0000, 0xFFF9, 0x0056, 0x0000, 0x0000, 0xFFF9, 0x0054,
    0x0000, 0x0000, 0xFFF9, 0x0053, 0x0000, 0x0000, 0xFFF9, 0x0051,
    0x0000, 0x0000, 0xFFF9, 0x0050, 0x0000, 0x0000, 0xFFF9, 0x004F,
    0x0000, 0x0000, 0xFFF9, 0x004D, 0x0000, 0x0000, 0xFFF9, 0x004C,
    0x0000, 0x0000, 0xFFF9, 0x004B, 0x0000, 0x0000, 0xFFF9, 0x004A,
    0x0000, 0x0000, 0xFFF9, 0x0049, 0x0000, 0x0000, 0xFFF9, 0x0047,
    0x0000, 0x0000, 0xFFF9, 0x0046, 0x0000, 0x0000, 0xFFF9, 0x0045,
    0x0000, 0x0000, 0xFFF9, 0x0044, 0x0000, 0x0000, 0xFFF9, 0x0043,
    0x0000, 0x0000, 0xFFF9, 0x0042, 0x0000, 0x0000, 0xFFF9, 0x0041,
    0x0000, 0x0000, 0xFFF9, 0x0040, 0x0000, 0x0000, 0xFFF9, 0x0040,
    0x0000, 0x0000, 0xFFF9, 0x003F, 0x0000, 0x0000, 0xFFF9, 0x003E,
    0x0000, 0x0000, 0xFFF9, 0x003D, 0x0000, 0x0000, 0xFFF9, 0x003C,
    0x0000, 0x0000, 0xFFF9, 0x003C, 0x0000, 0x0000, 0xFFF9, 0x003B,
    0x0000, 0x0000, 0xFFF9, 0x003A, 0x0000, 0x0000, 0xFFF9, 0x0039,
    0x0000, 0x0000, 0xFFF9, 0x0039, 0x0000, 0x0000, 0xFFF9, 0x0038,
    0x0000, 0x0000, 0xFFF9, 0x0037, 0x0000, 0x0000, 0xFFF9, 0x0037,
    0x0000, 0x0000, 0xFFF9, 0x0036, 0x0000, 0x0000, 0xFFF9, 0x0035,
    0x0000, 0x0000, 0xFFF9, 0x0035, 0x0000, 0x0000, 0xFFF9, 0x0034,
    0x0000, 0x0000, 0xFFF9, 0x0034, 0x0000, 0x0000, 0xFFF9, 0x0033,
    0x0000, 0x0000, 0xFFF9, 0x0032, 0x0000, 0x0000, 0xFFF9, 0x0032,
    0x0000, 0x0000, 0xFFF9, 0x0031, 0x0000, 0x0000, 0xFFF9, 0x0031,
    0x0000, 0x0000, 0xFFF9, 0x0030, 0x0000, 0x0000, 0xFFF9, 0x0030,
    0x0000, 0x0000, 0xFFF9, 0x002F, 0x0000, 0x0000, 0xFFF9, 0x002F,
    0x0000, 0x0000, 0xFFF9, 0x002E, 0x0000, 0x0000, 0xFFF9, 0x002E,
    0x0000, 0x0000, 0xFFF9, 0x002D, 0x0000, 0x0000, 0xFFF9, 0x002D,
    0x0000, 0x0000, 0xFFF9, 0x002D, 0x0000, 0x0000, 0xFFF9, 0x002C,
    0x0000, 0x0000, 0xFFF9, 0x002C, 0x0000, 0x0000, 0xFFF9, 0x002B,
    0x0000, 0x0000, 0xFFF9, 0x002B, 0x0000, 0x0000, 0xFFF9, 0x002A,
    0x0000, 0x0000, 0xFFF9, 0x002A, 0x0000, 0x0000, 0xFFF9, 0x002A,
    0x0000, 0x0000, 0xFFF9, 0x0029, 0x0000, 0x0000, 0xFFF9, 0x0029,
    0x0000, 0x0000, 0xFFF9, 0x0029, 0x0000, 0x0000, 0xFFF9, 0x0028,
    0x0000, 0x0000, 0xFFF9, 0x0028, 0x0000, 0x0000, 0xFFF9, 0x0028,
    0x0000, 0x0000, 0xFFF9, 0x0027, 0x0000, 0x0000, 0xFFF9, 0x0027,
    0x0000, 0x0000, 0xFFF9, 0x0027, 0x0000, 0x0000, 0xFFF9, 0x0026,
    0x0000, 0x0000, 0xFFF9, 0x0026, 0x0000, 0x0000, 0xFFF9, 0x0026,
    0x0000, 0x0000, 0xFFF9, 0x0025, 0x0000, 0x0000, 0xFFF9, 0x0025,
    0x0000, 0x0000, 0xFFF9, 0x0025, 0x0000, 0x0000, 0xFFF9, 0x0024,
    0x0000, 0x0000, 0xFFF9, 0x0024, 0x0000, 0x0000, 0xFFF9, 0x0024,
    0x0000, 0x0000, 0xFFF9, 0x0023, 0x0000, 0x0000, 0xFFF9, 0x0023,
    0x0000, 0x0000, 0xFFF9, 0x0023, 0x0000, 0x0000, 0xFFF9, 0x0023,
    0x0000, 0x0000, 0xFFF9, 0x0022, 0x0000, 0x0000, 0xFFF9, 0x0022,
    0x0000, 0x0000, 0xFFF9, 0x0022, 0x0000, 0x0000, 0xFFF9, 0x0022,
    0x0000, 0x0000, 0xFFF9, 0x0021, 0x0000, 0x0000, 0xFFF9, 0x0021,
    0x0000, 0x0000, 0xFFF9, 0x0021, 0x0000, 0x0000, 0xFFF9, 0x0021,
    0x0000, 0x0000, 0xFFF9, 0x0020, 0x0000, 0x0000, 0xFFF9, 0x0020,
    0x0000, 0x0000, 0xFFF9, 0x0020, 0x0000, 0x0000, 0xFFF9, 0x0020,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001F,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001F,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001E, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001E, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001D,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001D,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE3, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE3, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE2,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE2,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE1, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE1, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE0, 0x0000, 0x0000, 0xFFF9, 0xFFE0,
    0x0000, 0x0000, 0xFFF9, 0xFFE0, 0x0000, 0x0000, 0xFFF9, 0xFFE0,
    0x0000, 0x0000, 0xFFF9, 0xFFDF, 0x0000, 0x0000, 0xFFF9, 0xFFDF,
    0x0000, 0x0000, 0xFFF9, 0xFFDF, 0x0000, 0x0000, 0xFFF9, 0xFFDF,
    0x0000, 0x0000, 0xFFF9, 0xFFDE, 0x0000, 0x0000, 0xFFF9, 0xFFDE,
    0x0000, 0x0000, 0xFFF9, 0xFFDE, 0x0000, 0x0000, 0xFFF9, 0xFFDE,
    0x0000, 0x0000, 0xFFF9, 0xFFDD, 0x0000, 0x0000, 0xFFF9, 0xFFDD,
    0x0000, 0x0000, 0xFFF9, 0xFFDD, 0x0000, 0x0000, 0xFFF9, 0xFFDD,
    0x0000, 0x0000, 0xFFF9, 0xFFDC, 0x0000, 0x0000, 0xFFF9, 0xFFDC,
    0x0000, 0x0000, 0xFFF9, 0xFFDC, 0x0000, 0x0000, 0xFFF9, 0xFFDB,
    0x0000, 0x0000, 0xFFF9, 0xFFDB, 0x0000, 0x0000, 0xFFF9, 0xFFDB,
    0x0000, 0x0000, 0xFFF9, 0xFFDA, 0x0000, 0x0000, 0xFFF9, 0xFFDA,
    0x0000, 0x0000, 0xFFF9, 0xFFDA, 0x0000, 0x0000, 0xFFF9, 0xFFD9,
    0x0000, 0x0000, 0xFFF9, 0xFFD9, 0x0000, 0x0000, 0xFFF9, 0xFFD9,
    0x0000, 0x0000, 0xFFF9, 0xFFD8, 0x0000, 0x0000, 0xFFF9, 0xFFD8,
    0x0000, 0x0000, 0xFFF9, 0xFFD8, 0x0000, 0x0000, 0xFFF9, 0xFFD7,
    0x0000, 0x0000, 0xFFF9, 0xFFD7, 0x0000, 0x0000, 0xFFF9, 0xFFD7,
    0x0000, 0x0000, 0xFFF9, 0xFFD6, 0x0000, 0x0000, 0xFFF9, 0xFFD6,
    0x0000, 0x0000, 0xFFF9, 0xFFD6, 0x0000, 0x0000, 0xFFF9, 0xFFD5,
    0x0000, 0x0000, 0xFFF9, 0xFFD5, 0x0000, 0x0000, 0xFFF9, 0xFFD4,
    0x0000, 0x0000, 0xFFF9, 0xFFD4, 0x0000, 0x0000, 0xFFF9, 0xFFD3,
    0x0000, 0x0000, 0xFFF9, 0xFFD3, 0x0000, 0x0000, 0xFFF9, 0xFFD3,
    0x0000, 0x0000, 0xFFF9, 0xFFD2, 0x0000, 0x0000, 0xFFF9, 0xFFD2,
    0x0000, 0x0000, 0xFFF9, 0xFFD1, 0x0000, 0x0000, 0xFFF9, 0xFFD1,
    0x0000, 0x0000, 0xFFF9, 0xFFD0, 0x0000, 0x0000, 0xFFF9, 0xFFD0,
    0x0000, 0x0000, 0xFFF9, 0xFFCF, 0x0000, 0x0000, 0xFFF9, 0xFFCF,
    0x0000, 0x0000, 0xFFF9, 0xFFCE, 0x0000, 0x0000, 0xFFF9, 0xFFCE,
    0x0000, 0x0000, 0xFFF9, 0xFFCD, 0x0000, 0x0000, 0xFFF9, 0xFFCC,
    0x0000, 0x0000, 0xFFF9, 0xFFCC, 0x0000, 0x0000, 0xFFF9, 0xFFCB,
    0x0000, 0x0000, 0xFFF9, 0xFFCB, 0x0000, 0x0000, 0xFFF9, 0xFFCA,
    0x0000, 0x0000, 0xFFF9, 0xFFC9, 0x0000, 0x0000, 0xFFF9, 0xFFC9,
    0x0000, 0x0000, 0xFFF9, 0xFFC8, 0x0000, 0x0000, 0xFFF9, 0xFFC7,
    0x0000, 0x0000, 0xFFF9, 0xFFC7, 0x0000, 0x0000, 0xFFF9, 0xFFC6,
    0x0000, 0x0000, 0xFFF9, 0xFFC5, 0x0000, 0x0000, 0xFFF9, 0xFFC4,
    0x0000, 0x0000, 0xFFF9, 0xFFC4, 0x0000, 0x0000, 0xFFF9, 0xFFC3,
    0x0000, 0x0000, 0xFFF9, 0xFFC2, 0x0000, 0x0000, 0xFFF9, 0xFFC1,
    0x0000, 0x0000, 0xFFF9, 0xFFC0, 0x0000, 0x0000, 0xFFF9, 0xFFC0,
    0x0000, 0x0000, 0xFFF9, 0xFFBF, 0x0000, 0x0000, 0xFFF9, 0xFFBE,
    0x0000, 0x0000, 0xFFF9, 0xFFBD, 0x0000, 0x0000, 0xFFF9, 0xFFBC,
    0x0000, 0x0000, 0xFFF9, 0xFFBB, 0x0000, 0x0000, 0xFFF9, 0xFFBA,
    0x0000, 0x0000, 0xFFF9, 0xFFB9, 0x0000, 0x0000, 0xFFF9, 0xFFB7,
    0x0000, 0x0000, 0xFFF9, 0xFFB6, 0x0000, 0x0000, 0xFFF9, 0xFFB5,
    0x0000, 0x0000, 0xFFF9, 0xFFB4, 0x0000, 0x0000, 0xFFF9, 0xFFB3,
    0x0000, 0x0000, 0xFFF9, 0xFFB1, 0x0000, 0x0000, 0xFFF9, 0xFFB0,
    0x0000, 0x0000, 0xFFF9, 0xFFAF, 0x0000, 0x0000, 0xFFF9, 0xFFAD,
    0x0000, 0x0000, 0xFFF9, 0xFFAC, 0x0000, 0x0000, 0xFFF9, 0xFFAA,
    0x0000, 0x0000, 0xFFF9, 0xFFA8, 0x0000, 0x0000, 0xFFF9, 0xFFA7,
    0x0000, 0x0000, 0xFFF9, 0xFFA5, 0x0000, 0x0000, 0xFFF9, 0xFFA3,
    0x0000, 0x0000, 0xFFF9, 0xFFA1, 0x0000, 0x0000, 0xFFF9, 0xFF9F,
    0x0000, 0x0000, 0xFFF9, 0xFF9D, 0x0000, 0x0000, 0xFFF9, 0xFF9B,
    0x0000, 0x0000, 0xFFF9, 0xFF99, 0x0000, 0x0000, 0xFFF9, 0xFF97,
    0x0000, 0x0000, 0xFFF9, 0xFF94, 0x0000, 0x0000, 0xFFF9, 0xFF92,
    0x0000, 0x0000, 0xFFF9, 0xFF8F, 0x0000, 0x0000, 0xFFF9, 0xFF8C,
    0x0000, 0x0000, 0xFFF9, 0xFF89, 0x0000, 0x0000, 0xFFF9, 0xFF86,
    0x0000, 0x0000, 0xFFF9, 0xFF83, 0x0000, 0x0000, 0xFFF9, 0xFF80,
    0x0000, 0x0000, 0xFFF9, 0xFF7C, 0x0000, 0x0000, 0xFFF9, 0xFF78,
    0x0000, 0x0000, 0xFFF9, 0xFF74, 0x0000, 0x0000, 0xFFF9, 0xFF70,
    0x0000, 0x0000, 0xFFF9, 0xFF6B, 0x0000, 0x0000, 0xFFF9, 0xFF66,
    0x0000, 0x0000, 0xFFF9, 0xFF61, 0x0000, 0x0000, 0xFFF9, 0xFF5B,
    0x0000, 0x0000, 0xFFF9, 0xFF55, 0x0000, 0x0000, 0xFFF9, 0xFF4F,
    0x0000, 0x0000, 0xFFF9, 0xFF48, 0x0000, 0x0000, 0xFFF9, 0xFF41,
    0x0000, 0x0000, 0xFFF9, 0xFF38, 0x0000, 0x0000, 0xFFF9, 0xFF2F,
    0x0000, 0x0000, 0xFFF9, 0xFF26, 0x0000, 0x0000, 0xFFF9, 0xFF1B,
    0x0000, 0x0000, 0xFFF9, 0xFF0F, 0x0000, 0x0000, 0xFFF9, 0xFF02,
    0x0000, 0x0000, 0xFFF9, 0xFEF4, 0x0000, 0x0000, 0xFFF9, 0xFEE4,
    0x0000, 0x0000, 0xFFF9, 0xFED1, 0x0000, 0x0000, 0xFFF9, 0xFEBC,
    0x0000, 0x0000, 0xFFF9, 0xFEA4, 0x0000, 0x0000, 0xFFF9, 0xFE89,
    0x0000, 0x0000, 0xFFF9, 0xFE68, 0x0000, 0x0000, 0xFFF9, 0xFE41,
    0x0000, 0x0000, 0xFFF9, 0xFE12, 0x0000, 0x0000, 0xFFF9, 0xFDD8,
    0x0000, 0x0000, 0xFFF9, 0xFD8E, 0x0000, 0x0000, 0xFFF9, 0xFD2E,
    0x0000, 0x0000, 0xFFF9, 0xFCAB, 0x0000, 0x0000, 0xFFF9, 0xFBED,
    0x0000, 0x0000, 0xFFF9, 0xFAC3, 0x0000, 0x0000, 0xFFF9, 0xF8AB,
    0x0000, 0x0000, 0xFFF9, 0xF3C7, 0x0000, 0x0000, 0xFFF9, 0xDB55
    };

