static const q15_t in_rfft_noisy_32[32] = {
    0x0624, 0x3B86, 0x6255, 0x3C6D, 0xF810, 0xC22C, 0xA798, 0xC1F6,
    0xF5AA, 0x49EE, 0x5CD9, 0x427A, 0xF255, 0xC41B, 0xA4B6, 0xBD9D,
    0x0541, 0x3973, 0x593B, 0x3AB5, 0xF5C1, 0xBE4A, 0xA1E7, 0xC9EC,
    0x05F3, 0x45BD, 0x5789, 0x3B32, 0x04C3, 0xC5D7, 0xB626, 0xBF51
    };

static const q15_t in_rifft_noisy_32[66] = {
    0x0067, 0x0000, 0x0154, 0x0078, 0xFFDE, 0x011E, 0x0045, 0x000C,
    0x0161, 0xD394, 0xFEE3, 0x00EC, 0xFF5E, 0x0015, 0xFFF6, 0xFEB0,
    0xFEBD, 0xFF75, 0xFF78, 0x00DB, 0x0089, 0x0036, 0xFFA4, 0xFFE0,
    0x00C0, 0x004E, 0xFF7C, 0xFF9C, 0x0234, 0x0017, 0x012F, 0xFF2D,
    0xFF9C, 0x0000, 0x012F, 0x00D3, 0x0234, 0xFFE9, 0xFF7C, 0x0064,
    0x00C0, 0xFFB2, 0xFFA4, 0x0020, 0x0089, 0xFFCA, 0xFF78, 0xFF25,
    0xFEBD, 0x008B, 0xFFF6, 0x0150, 0xFF5E, 0xFFEB, 0xFEE3, 0xFF14,
    0x0161, 0x2C6C, 0x0045, 0xFFF4, 0xFFDE, 0xFEE2, 0x0154, 0xFF88,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_noisy_32[33] = {
    0x0067, 0x0000, 0x0154, 0x0078, 0xFFDE, 0x011E, 0x0045, 0x000C,
    0x0161, 0xD394, 0xFEE3, 0x00EC, 0xFF5E, 0x0015, 0xFFF6, 0xFEB0,
    0xFEBD, 0xFF75, 0xFF78, 0x00DB, 0x0089, 0x0036, 0xFFA4, 0xFFE0,
    0x00C0, 0x004E, 0xFF7C, 0xFF9C, 0x0234, 0x0017, 0x012F, 0xFF2D,
    0xFF9C
    };

static const q15_t in_rfft_noisy_64[64] = {
    0xFB98, 0x4279, 0x56C1, 0x3905, 0xFE9D, 0xBDDA, 0xAC98, 0xC19A,
    0x0E6D, 0x42C5, 0x5FDF, 0x390F, 0xFCB6, 0xBFD4, 0xA96E, 0xC7A0,
    0x04CD, 0x3BD5, 0x5B05, 0x3CCE, 0x0587, 0xC2BE, 0xA8FE, 0xC12C,
    0x02A7, 0x44BB, 0x576C, 0x3C36, 0xFE3D, 0xBE44, 0xA6DE, 0xCC9F,
    0xFE3B, 0x3EF1, 0x681E, 0x40D2, 0xFBF6, 0xBF51, 0x9F9F, 0xBC7B,
    0xFEEA, 0x3A25, 0x5677, 0x3DB3, 0x0A14, 0xC72E, 0xA704, 0xC187,
    0x041B, 0x422D, 0x568F, 0x4C5E, 0xF560, 0xC57A, 0xA86B, 0xC766,
    0xF82B, 0x3A4D, 0x5C42, 0x329E, 0x000D, 0xCE7F, 0xA442, 0xB8A8
    };

static const q15_t in_rifft_noisy_64[130] = {
    0x00AD, 0x0000, 0xFFBE, 0xFFAD, 0xFF6A, 0xFFF1, 0xFF74, 0xFF60,
    0x0063, 0xFFF5, 0xFF23, 0x00B8, 0x0069, 0x0005, 0xFFF1, 0x012D,
    0x006B, 0xD3AC, 0x001A, 0xFFAB, 0xFFAD, 0xFF8C, 0xFF1B, 0xFFC7,
    0xFF4D, 0xFFD1, 0x00B9, 0xFF7D, 0xFF90, 0xFFE8, 0xFFF3, 0xFF76,
    0xFFC7, 0xFFA5, 0xFFDD, 0xFF4B, 0xFFA3, 0xFF4C, 0x00DA, 0xFED2,
    0x006F, 0x007D, 0x00B0, 0xFFD1, 0xFFBA, 0x0084, 0x004A, 0xFFA4,
    0x0018, 0x00B7, 0x002D, 0x0023, 0xFFA3, 0x0031, 0xFEDF, 0xFFA3,
    0xFF8A, 0xFFA9, 0x0065, 0xFFCB, 0x000F, 0x00D9, 0x000E, 0x00E2,
    0x001C, 0x0000, 0x000E, 0xFF1E, 0x000F, 0xFF27, 0x0065, 0x0035,
    0xFF8A, 0x0057, 0xFEDF, 0x005D, 0xFFA3, 0xFFCF, 0x002D, 0xFFDD,
    0x0018, 0xFF49, 0x004A, 0x005C, 0xFFBA, 0xFF7C, 0x00B0, 0x002F,
    0x006F, 0xFF83, 0x00DA, 0x012E, 0xFFA3, 0x00B4, 0xFFDD, 0x00B5,
    0xFFC7, 0x005B, 0xFFF3, 0x008A, 0xFF90, 0x0018, 0x00B9, 0x0083,
    0xFF4D, 0x002F, 0xFF1B, 0x0039, 0xFFAD, 0x0074, 0x001A, 0x0055,
    0x006B, 0x2C54, 0xFFF1, 0xFED3, 0x0069, 0xFFFB, 0xFF23, 0xFF48,
    0x0063, 0x000B, 0xFF74, 0x00A0, 0xFF6A, 0x000F, 0xFFBE, 0x0053,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_noisy_64[65] = {
    0x00AD, 0x0000, 0xFFBE, 0xFFAD, 0xFF6A, 0xFFF1, 0xFF74, 0xFF60,
    0x0063, 0xFFF5, 0xFF23, 0x00B8, 0x0069, 0x0005, 0xFFF1, 0x012D,
    0x006B, 0xD3AC, 0x001A, 0xFFAB, 0xFFAD, 0xFF8C, 0xFF1B, 0xFFC7,
    0xFF4D, 0xFFD1, 0x00B9, 0xFF7D, 0xFF90, 0xFFE8, 0xFFF3, 0xFF76,
    0xFFC7, 0xFFA5, 0xFFDD, 0xFF4B, 0xFFA3, 0xFF4C, 0x00DA, 0xFED2,
    0x006F, 0x007D, 0x00B0, 0xFFD1, 0xFFBA, 0x0084, 0x004A, 0xFFA4,
    0x0018, 0x00B7, 0x002D, 0x0023, 0xFFA3, 0x0031, 0xFEDF, 0xFFA3,
    0xFF8A, 0xFFA9, 0x0065, 0xFFCB, 0x000F, 0x00D9, 0x000E, 0x00E2,
    0x001C
    };

static const q15_t in_rfft_noisy_128[128] = {
    0xFEDB, 0x43DA, 0x54A0, 0x4144, 0xFD34, 0xC70D, 0xA576, 0xC6C1,
    0xFF6E, 0x3C77, 0x5B36, 0x4738, 0x0698, 0xC5B3, 0xAAD5, 0xC478,
    0xFC9D, 0x429F, 0x5AD1, 0x3F54, 0x064F, 0xBB0D, 0xA7C1, 0xB76B,
    0xF807, 0x39E8, 0x54E4, 0x3487, 0xFB59, 0xC240, 0xA6D6, 0xB8D2,
    0x001E, 0x3DFE, 0x4CA1, 0x4001, 0x01AC, 0xC375, 0xA740, 0xBF51,
    0x05E4, 0x426C, 0x5E1D, 0x3A98, 0x01D8, 0xC6CD, 0xABA7, 0xBAE3,
    0xFEEB, 0x4006, 0x5BE0, 0x424B, 0x043E, 0xC774, 0xA8A7, 0xBCAB,
    0x01AE, 0x4274, 0x5838, 0x3765, 0xF9E1, 0xC0BC, 0xA864, 0xC1F6,
    0xF7F2, 0x498C, 0x5792, 0x4E23, 0xFFD8, 0xBC28, 0xA6CB, 0xC129,
    0xF654, 0x3D7F, 0x4D59, 0x4098, 0x11B2, 0xC1DE, 0xAB13, 0xC578,
    0xFCFC, 0x4475, 0x5B2A, 0x3AEE, 0x0215, 0xB88F, 0xAC39, 0xC8A8,
    0x01A1, 0x4F06, 0x5AAB, 0x4300, 0x0429, 0xC89A, 0xA863, 0xBBD9,
    0xFC13, 0x418F, 0x4D40, 0x3B55, 0x07D5, 0xB4A4, 0xA67F, 0xB870,
    0xFB6D, 0x4C63, 0x61C6, 0x3435, 0x05A2, 0xC30A, 0x9C4B, 0xC387,
    0x009B, 0x3E7F, 0x55FE, 0x3C81, 0xFF26, 0xC404, 0xAFE6, 0xB7B1,
    0xFBA3, 0x37BD, 0x6335, 0x4513, 0x0383, 0xC7E2, 0xB0ED, 0xBB27
    };

static const q15_t in_rifft_noisy_128[258] = {
    0x0064, 0x0000, 0xFFF2, 0x0048, 0x0084, 0xFFCE, 0x00E9, 0xFF7D,
    0xFF82, 0xFFE3, 0xFF64, 0x0020, 0x003B, 0x0026, 0x0068, 0x0099,
    0x0012, 0x0069, 0xFF71, 0x002E, 0x009D, 0xFF6E, 0xFF9C, 0x00C9,
    0x001E, 0xFFF5, 0x0038, 0x0075, 0xFF90, 0xFFF2, 0xFF98, 0xFFE8,
    0xFF55, 0xD377, 0x0009, 0x002B, 0xFFD5, 0x0023, 0xFFCE, 0x001C,
    0xFFF0, 0x001F, 0xFFC7, 0xFF66, 0x0099, 0xFF78, 0x0062, 0xFFF4,
    0xFFBE, 0x0012, 0x00A7, 0x001D, 0xFF97, 0xFFD8, 0x0044, 0xFFF0,
    0xFFC0, 0x005A, 0x0013, 0xFFF8, 0xFF1D, 0x006F, 0xFFE5, 0xFFE2,
    0xFFF6, 0xFF3E, 0xFFDB, 0x000B, 0x0023, 0x0044, 0xFFCC, 0x0007,
    0x0023, 0xFF74, 0xFFF0, 0xFF8E, 0xFF9E, 0xFFBE, 0x0055, 0xFF8E,
    0x00A5, 0xFFD1, 0xFFCD, 0x000F, 0xFF81, 0x0053, 0xFF69, 0xFFD4,
    0x0051, 0xFF47, 0x004D, 0xFFF6, 0x0089, 0xFFA0, 0x0022, 0x00D8,
    0xFF58, 0xFF49, 0x006A, 0xFFAB, 0x0002, 0x0076, 0x0066, 0x000B,
    0x0053, 0xFFC4, 0x002D, 0xFFFC, 0xFFCE, 0xFFE0, 0x0029, 0x0009,
    0xFF7C, 0xFFD6, 0xFF9F, 0x000B, 0x000E, 0xFF57, 0x0094, 0xFFB6,
    0xFF86, 0xFFA5, 0x001A, 0xFFCC, 0xFF9C, 0xFF9F, 0x0050, 0x001A,
    0xFFFA, 0x0000, 0x0050, 0xFFE6, 0xFF9C, 0x0061, 0x001A, 0x0034,
    0xFF86, 0x005B, 0x0094, 0x004A, 0x000E, 0x00A9, 0xFF9F, 0xFFF5,
    0xFF7C, 0x002A, 0x0029, 0xFFF7, 0xFFCE, 0x0020, 0x002D, 0x0004,
    0x0053, 0x003C, 0x0066, 0xFFF5, 0x0002, 0xFF8A, 0x006A, 0x0055,
    0xFF58, 0x00B7, 0x0022, 0xFF28, 0x0089, 0x0060, 0x004D, 0x000A,
    0x0051, 0x00B9, 0xFF69, 0x002C, 0xFF81, 0xFFAD, 0xFFCD, 0xFFF1,
    0x00A5, 0x002F, 0x0055, 0x0072, 0xFF9E, 0x0042, 0xFFF0, 0x0072,
    0x0023, 0x008C, 0xFFCC, 0xFFF9, 0x0023, 0xFFBC, 0xFFDB, 0xFFF5,
    0xFFF6, 0x00C2, 0xFFE5, 0x001E, 0xFF1D, 0xFF91, 0x0013, 0x0008,
    0xFFC0, 0xFFA6, 0x0044, 0x0010, 0xFF97, 0x0028, 0x00A7, 0xFFE3,
    0xFFBE, 0xFFEE, 0x0062, 0x000C, 0x0099, 0x0088, 0xFFC7, 0x009A,
    0xFFF0, 0xFFE1, 0xFFCE, 0xFFE4, 0xFFD5, 0xFFDD, 0x0009, 0xFFD5,
    0xFF55, 0x2C89, 0xFF98, 0x0018, 0xFF90, 0x000E, 0x0038, 0xFF8B,
    0x001E, 0x000B, 0xFF9C, 0xFF37, 0x009D, 0x0092, 0xFF71, 0xFFD2,
    0x0012, 0xFF97, 0x0068, 0xFF67, 0x003B, 0xFFDA, 0xFF64, 0xFFE0,
    0xFF82, 0x001D, 0x00E9, 0x0083, 0x0084, 0x0032, 0xFFF2, 0xFFB8,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_noisy_128[129] = {
    0x0064, 0x0000, 0xFFF2, 0x0048, 0x0084, 0xFFCE, 0x00E9, 0xFF7D,
    0xFF82, 0xFFE3, 0xFF64, 0x0020, 0x003B, 0x0026, 0x0068, 0x0099,
    0x0012, 0x0069, 0xFF71, 0x002E, 0x009D, 0xFF6E, 0xFF9C, 0x00C9,
    0x001E, 0xFFF5, 0x0038, 0x0075, 0xFF90, 0xFFF2, 0xFF98, 0xFFE8,
    0xFF55, 0xD377, 0x0009, 0x002B, 0xFFD5, 0x0023, 0xFFCE, 0x001C,
    0xFFF0, 0x001F, 0xFFC7, 0xFF66, 0x0099, 0xFF78, 0x0062, 0xFFF4,
    0xFFBE, 0x0012, 0x00A7, 0x001D, 0xFF97, 0xFFD8, 0x0044, 0xFFF0,
    0xFFC0, 0x005A, 0x0013, 0xFFF8, 0xFF1D, 0x006F, 0xFFE5, 0xFFE2,
    0xFFF6, 0xFF3E, 0xFFDB, 0x000B, 0x0023, 0x0044, 0xFFCC, 0x0007,
    0x0023, 0xFF74, 0xFFF0, 0xFF8E, 0xFF9E, 0xFFBE, 0x0055, 0xFF8E,
    0x00A5, 0xFFD1, 0xFFCD, 0x000F, 0xFF81, 0x0053, 0xFF69, 0xFFD4,
    0x0051, 0xFF47, 0x004D, 0xFFF6, 0x0089, 0xFFA0, 0x0022, 0x00D8,
    0xFF58, 0xFF49, 0x006A, 0xFFAB, 0x0002, 0x0076, 0x0066, 0x000B,
    0x0053, 0xFFC4, 0x002D, 0xFFFC, 0xFFCE, 0xFFE0, 0x0029, 0x0009,
    0xFF7C, 0xFFD6, 0xFF9F, 0x000B, 0x000E, 0xFF57, 0x0094, 0xFFB6,
    0xFF86, 0xFFA5, 0x001A, 0xFFCC, 0xFF9C, 0xFF9F, 0x0050, 0x001A,
    0xFFFA
    };

static const q15_t in_rfft_noisy_256[256] = {
    0x04E8, 0x3B40, 0x562D, 0x33B2, 0x04C3, 0xC3F6, 0xAD00, 0xBCBE,
    0x03A8, 0x33CD, 0x5BBF, 0x4091, 0x022E, 0xC43E, 0x9B36, 0xB264,
    0x0962, 0x3B61, 0x5CA3, 0x4369, 0xFCA4, 0xCC1B, 0xA9DA, 0xBF68,
    0xF96A, 0x3C16, 0x5575, 0x3E45, 0xF92A, 0xC504, 0xA1D3, 0xBF0E,
    0xFC1C, 0x47E9, 0x6150, 0x35E6, 0xF7DE, 0xBCB9, 0xA1ED, 0xC1FD,
    0x0579, 0x441C, 0x57F1, 0x3AB2, 0xF1E5, 0xBBDD, 0xA7A7, 0xC00E,
    0x07A6, 0x3914, 0x4F89, 0x3315, 0xF7C6, 0xC149, 0xA7A7, 0xC35B,
    0x0196, 0x3A70, 0x651C, 0x41A2, 0x00DD, 0xB9AC, 0xAB5D, 0xC38D,
    0x0021, 0x403B, 0x6233, 0x4B6D, 0x067C, 0xB4AA, 0x9DDD, 0xBFC3,
    0x0088, 0x4699, 0x5A23, 0x434F, 0xF681, 0xC1CB, 0xA30E, 0xB996,
    0x00CF, 0x3D05, 0x4A45, 0x3E1F, 0x038F, 0xC4C0, 0xB0F2, 0xC408,
    0xFD43, 0x3E02, 0x5618, 0x3C90, 0xFFA2, 0xC9F2, 0xA730, 0xC3A2,
    0xFA63, 0x40D7, 0x4E59, 0x4675, 0x007D, 0xC6E0, 0xAC66, 0xC527,
    0xF7B8, 0x3871, 0x5DD7, 0x3ED5, 0xF963, 0xC6F5, 0xA9AE, 0xC5A4,
    0x08BE, 0x3D46, 0x5689, 0x3EFB, 0x0922, 0xC274, 0xAB14, 0xC931,
    0x0550, 0x3F62, 0x5705, 0x357E, 0x0069, 0xBB8F, 0x9AC1, 0xB9FE,
    0xFA29, 0x3C5A, 0x6433, 0x32ED, 0xFA04, 0xC4A2, 0x9F00, 0xCEE7,
    0xFDA0, 0x354B, 0x5F9A, 0x44A7, 0xF321, 0xBAA9, 0xA1DB, 0xC3E5,
    0x07BA, 0x39C1, 0x4C11, 0x39C7, 0x08A3, 0xB44D, 0xAB9A, 0xBB70,
    0xFC7B, 0x4B34, 0x5933, 0x387E, 0x03E4, 0xC5D7, 0xA822, 0xC30F,
    0x0198, 0x397F, 0x57D3, 0x3080, 0x021D, 0xC361, 0xA2BC, 0xB62C,
    0x0181, 0x34CE, 0x64C6, 0x4735, 0x0356, 0xBC8E, 0x9EA4, 0xBEDC,
    0x03B8, 0x3A0C, 0x5E1A, 0x3BA6, 0x0747, 0xBE4F, 0xA2F0, 0xBE73,
    0x0245, 0x38E9, 0x595B, 0x475C, 0x0646, 0xBE00, 0xA0C3, 0xC06A,
    0x02F6, 0x3C63, 0x5D97, 0x3A0A, 0xF66C, 0xBC72, 0xAA76, 0xBF5D,
    0xFB14, 0x3F4C, 0x5D7F, 0x4317, 0xF96D, 0xBD22, 0xA9A8, 0xBFED,
    0x0365, 0x3D34, 0x5722, 0x42A9, 0x12C8, 0xB834, 0xB0DC, 0xB5F0,
    0xFD93, 0x4523, 0x608E, 0x3E8D, 0x0523, 0xBCA3, 0xA5E6, 0xC76E,
    0xFBCD, 0x4A34, 0x4EC9, 0x39FE, 0x07FA, 0xBBD9, 0xABC9, 0xC30F,
    0xFD93, 0x3BB4, 0x53B7, 0x3E31, 0x07F9, 0xC0B5, 0xACAC, 0xBC20,
    0x020D, 0x3AA0, 0x5FC1, 0x398E, 0x0896, 0xCB93, 0xA568, 0xBEEB,
    0x00CE, 0x3FD0, 0x5D7F, 0x3E99, 0x03FB, 0xC2D7, 0xA442, 0xB60E
    };

static const q15_t in_rifft_noisy_256[514] = {
    0xFF9B, 0x0000, 0x001B, 0x000F, 0xFFFA, 0x008A, 0x0023, 0xFFFA,
    0xFFED, 0x0027, 0x0019, 0xFFA9, 0xFFAD, 0x001E, 0x0028, 0x0053,
    0xFFF9, 0x0061, 0xFFEF, 0xFFC9, 0xFF8B, 0xFFDC, 0x0013, 0x0064,
    0xFFEF, 0xFFD3, 0x003B, 0x0032, 0xFFA9, 0xFFB0, 0x004C, 0xFFE3,
    0xFFAC, 0xFFEF, 0xFFDE, 0x0009, 0x000F, 0xFFB7, 0xFFB3, 0x0012,
    0xFFB1, 0xFFFC, 0xFFEE, 0x002E, 0xFFAE, 0x000E, 0x004A, 0x0050,
    0x003A, 0x0011, 0xFFC5, 0x0014, 0xFFF4, 0xFFE8, 0x005B, 0x0014,
    0x0034, 0xFF8B, 0xFF57, 0xFFEA, 0x0028, 0x00A9, 0xFFAC, 0x001F,
    0xFFF7, 0xD367, 0x0000, 0xFF9E, 0xFF97, 0x000B, 0xFF79, 0x003E,
    0xFFED, 0xFFB5, 0xFFD6, 0x0098, 0x0040, 0x0013, 0x00A0, 0xFF62,
    0xFFDA, 0xFF9D, 0x0012, 0x0060, 0x0050, 0x006B, 0x0003, 0x0076,
    0xFFE4, 0xFFC9, 0x0079, 0x000A, 0x0035, 0xFFDA, 0x000F, 0xFF92,
    0x00B7, 0x0011, 0x0002, 0x0010, 0xFFE7, 0xFFA1, 0xFFB3, 0xFFE0,
    0x000B, 0xFFBE, 0x005B, 0x005F, 0xFFEF, 0xFFA4, 0xFFBC, 0x005D,
    0xFF81, 0xFF8B, 0x0089, 0x006E, 0xFFC1, 0xFFD3, 0xFFD3, 0x000F,
    0x0009, 0x0043, 0x0052, 0xFFB7, 0x003F, 0xFFB1, 0x0015, 0xFF85,
    0x0025, 0xFFEC, 0xFFF2, 0xFFDE, 0x000E, 0xFFB4, 0x0036, 0xFFF5,
    0x0008, 0x0059, 0xFFEC, 0xFFCC, 0x006A, 0xFFA4, 0xFFF4, 0xFFC4,
    0x0001, 0x0006, 0x0003, 0xFFFA, 0xFFF6, 0xFFF0, 0x004A, 0x0020,
    0xFFD7, 0x0059, 0xFFF0, 0x001B, 0xFFEB, 0xFFB4, 0x0001, 0x003A,
    0x004B, 0xFF8E, 0xFFB3, 0xFFF8, 0x0024, 0x002C, 0x002E, 0xFFF8,
    0xFFCB, 0xFF96, 0x0053, 0xFFD8, 0xFFA2, 0xFFD9, 0x005D, 0xFF9B,
    0xFF51, 0x007B, 0x000E, 0xFF97, 0xFFFA, 0x003B, 0x001D, 0xFFC0,
    0x0095, 0x0062, 0x0019, 0x0069, 0xFF99, 0x00A9, 0x001A, 0x001B,
    0x000C, 0x003E, 0x001C, 0xFF8A, 0x006F, 0xFFFC, 0x0072, 0xFF9D,
    0xFFEC, 0x004F, 0x000E, 0xFFDB, 0x0011, 0x0018, 0xFF84, 0xFFC3,
    0xFFBB, 0xFFE7, 0xFFBD, 0x0053, 0x001A, 0xFFD1, 0xFFF5, 0xFFC4,
    0x0024, 0xFFD8, 0x0000, 0xFFEF, 0x0010, 0x0027, 0x0042, 0x0007,
    0x0009, 0x0072, 0xFFD4, 0xFFE4, 0x003C, 0xFFC1, 0xFFF6, 0x0002,
    0x008C, 0xFFF9, 0xFFED, 0x0041, 0xFFB0, 0x005F, 0xFFEA, 0x0064,
    0xFFB8, 0xFFC8, 0xFFF7, 0x001B, 0x0044, 0xFFF9, 0x0048, 0x0080,
    0x0065, 0xFFC3, 0x0028, 0xFFB8, 0x000D, 0x0033, 0x0052, 0xFF62,
    0x00BF, 0x0000, 0x0052, 0x009E, 0x000D, 0xFFCD, 0x0028, 0x0048,
    0x0065, 0x003D, 0x0048, 0xFF80, 0x0044, 0x0007, 0xFFF7, 0xFFE5,
    0xFFB8, 0x0038, 0xFFEA, 0xFF9C, 0xFFB0, 0xFFA1, 0xFFED, 0xFFBF,
    0x008C, 0x0007, 0xFFF6, 0xFFFE, 0x003C, 0x003F, 0xFFD4, 0x001C,
    0x0009, 0xFF8E, 0x0042, 0xFFF9, 0x0010, 0xFFD9, 0x0000, 0x0011,
    0x0024, 0x0028, 0xFFF5, 0x003C, 0x001A, 0x002F, 0xFFBD, 0xFFAD,
    0xFFBB, 0x0019, 0xFF84, 0x003D, 0x0011, 0xFFE8, 0x000E, 0x0025,
    0xFFEC, 0xFFB1, 0x0072, 0x0063, 0x006F, 0x0004, 0x001C, 0x0076,
    0x000C, 0xFFC2, 0x001A, 0xFFE5, 0xFF99, 0xFF57, 0x0019, 0xFF97,
    0x0095, 0xFF9E, 0x001D, 0x0040, 0xFFFA, 0xFFC5, 0x000E, 0x0069,
    0xFF51, 0xFF85, 0x005D, 0x0065, 0xFFA2, 0x0027, 0x0053, 0x0028,
    0xFFCB, 0x006A, 0x002E, 0x0008, 0x0024, 0xFFD4, 0xFFB3, 0x0008,
    0x004B, 0x0072, 0x0001, 0xFFC6, 0xFFEB, 0x004C, 0xFFF0, 0xFFE5,
    0xFFD7, 0xFFA7, 0x004A, 0xFFE0, 0xFFF6, 0x0010, 0x0003, 0x0006,
    0x0001, 0xFFFA, 0xFFF4, 0x003C, 0x006A, 0x005C, 0xFFEC, 0x0034,
    0x0008, 0xFFA7, 0x0036, 0x000B, 0x000E, 0x004C, 0xFFF2, 0x0022,
    0x0025, 0x0014, 0x0015, 0x007B, 0x003F, 0x004F, 0x0052, 0x0049,
    0x0009, 0xFFBD, 0xFFD3, 0xFFF1, 0xFFC1, 0x002D, 0x0089, 0xFF92,
    0xFF81, 0x0075, 0xFFBC, 0xFFA3, 0xFFEF, 0x005C, 0x005B, 0xFFA1,
    0x000B, 0x0042, 0xFFB3, 0x0020, 0xFFE7, 0x005F, 0x0002, 0xFFF0,
    0x00B7, 0xFFEF, 0x000F, 0x006E, 0x0035, 0x0026, 0x0079, 0xFFF6,
    0xFFE4, 0x0037, 0x0003, 0xFF8A, 0x0050, 0xFF95, 0x0012, 0xFFA0,
    0xFFDA, 0x0063, 0x00A0, 0x009E, 0x0040, 0xFFED, 0xFFD6, 0xFF68,
    0xFFED, 0x004B, 0xFF79, 0xFFC2, 0xFF97, 0xFFF5, 0x0000, 0x0062,
    0xFFF7, 0x2C99, 0xFFAC, 0xFFE1, 0x0028, 0xFF57, 0xFF57, 0x0016,
    0x0034, 0x0075, 0x005B, 0xFFEC, 0xFFF4, 0x0018, 0xFFC5, 0xFFEC,
    0x003A, 0xFFEF, 0x004A, 0xFFB0, 0xFFAE, 0xFFF2, 0xFFEE, 0xFFD2,
    0xFFB1, 0x0004, 0xFFB3, 0xFFEE, 0x000F, 0x0049, 0xFFDE, 0xFFF7,
    0xFFAC, 0x0011, 0x004C, 0x001D, 0xFFA9, 0x0050, 0x003B, 0xFFCE,
    0xFFEF, 0x002D, 0x0013, 0xFF9C, 0xFF8B, 0x0024, 0xFFEF, 0x0037,
    0xFFF9, 0xFF9F, 0x0028, 0xFFAD, 0xFFAD, 0xFFE2, 0x0019, 0x0057,
    0xFFED, 0xFFD9, 0x0023, 0x0006, 0xFFFA, 0xFF76, 0x001B, 0xFFF1,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_noisy_256[257] = {
    0xFF9B, 0x0000, 0x001B, 0x000F, 0xFFFA, 0x008A, 0x0023, 0xFFFA,
    0xFFED, 0x0027, 0x0019, 0xFFA9, 0xFFAD, 0x001E, 0x0028, 0x0053,
    0xFFF9, 0x0061, 0xFFEF, 0xFFC9, 0xFF8B, 0xFFDC, 0x0013, 0x0064,
    0xFFEF, 0xFFD3, 0x003B, 0x0032, 0xFFA9, 0xFFB0, 0x004C, 0xFFE3,
    0xFFAC, 0xFFEF, 0xFFDE, 0x0009, 0x000F, 0xFFB7, 0xFFB3, 0x0012,
    0xFFB1, 0xFFFC, 0xFFEE, 0x002E, 0xFFAE, 0x000E, 0x004A, 0x0050,
    0x003A, 0x0011, 0xFFC5, 0x0014, 0xFFF4, 0xFFE8, 0x005B, 0x0014,
    0x0034, 0xFF8B, 0xFF57, 0xFFEA, 0x0028, 0x00A9, 0xFFAC, 0x001F,
    0xFFF7, 0xD367, 0x0000, 0xFF9E, 0xFF97, 0x000B, 0xFF79, 0x003E,
    0xFFED, 0xFFB5, 0xFFD6, 0x0098, 0x0040, 0x0013, 0x00A0, 0xFF62,
    0xFFDA, 0xFF9D, 0x0012, 0x0060, 0x0050, 0x006B, 0x0003, 0x0076,
    0xFFE4, 0xFFC9, 0x0079, 0x000A, 0x0035, 0xFFDA, 0x000F, 0xFF92,
    0x00B7, 0x0011, 0x0002, 0x0010, 0xFFE7, 0xFFA1, 0xFFB3, 0xFFE0,
    0x000B, 0xFFBE, 0x005B, 0x005F, 0xFFEF, 0xFFA4, 0xFFBC, 0x005D,
    0xFF81, 0xFF8B, 0x0089, 0x006E, 0xFFC1, 0xFFD3, 0xFFD3, 0x000F,
    0x0009, 0x0043, 0x0052, 0xFFB7, 0x003F, 0xFFB1, 0x0015, 0xFF85,
    0x0025, 0xFFEC, 0xFFF2, 0xFFDE, 0x000E, 0xFFB4, 0x0036, 0xFFF5,
    0x0008, 0x0059, 0xFFEC, 0xFFCC, 0x006A, 0xFFA4, 0xFFF4, 0xFFC4,
    0x0001, 0x0006, 0x0003, 0xFFFA, 0xFFF6, 0xFFF0, 0x004A, 0x0020,
    0xFFD7, 0x0059, 0xFFF0, 0x001B, 0xFFEB, 0xFFB4, 0x0001, 0x003A,
    0x004B, 0xFF8E, 0xFFB3, 0xFFF8, 0x0024, 0x002C, 0x002E, 0xFFF8,
    0xFFCB, 0xFF96, 0x0053, 0xFFD8, 0xFFA2, 0xFFD9, 0x005D, 0xFF9B,
    0xFF51, 0x007B, 0x000E, 0xFF97, 0xFFFA, 0x003B, 0x001D, 0xFFC0,
    0x0095, 0x0062, 0x0019, 0x0069, 0xFF99, 0x00A9, 0x001A, 0x001B,
    0x000C, 0x003E, 0x001C, 0xFF8A, 0x006F, 0xFFFC, 0x0072, 0xFF9D,
    0xFFEC, 0x004F, 0x000E, 0xFFDB, 0x0011, 0x0018, 0xFF84, 0xFFC3,
    0xFFBB, 0xFFE7, 0xFFBD, 0x0053, 0x001A, 0xFFD1, 0xFFF5, 0xFFC4,
    0x0024, 0xFFD8, 0x0000, 0xFFEF, 0x0010, 0x0027, 0x0042, 0x0007,
    0x0009, 0x0072, 0xFFD4, 0xFFE4, 0x003C, 0xFFC1, 0xFFF6, 0x0002,
    0x008C, 0xFFF9, 0xFFED, 0x0041, 0xFFB0, 0x005F, 0xFFEA, 0x0064,
    0xFFB8, 0xFFC8, 0xFFF7, 0x001B, 0x0044, 0xFFF9, 0x0048, 0x0080,
    0x0065, 0xFFC3, 0x0028, 0xFFB8, 0x000D, 0x0033, 0x0052, 0xFF62,
    0x00BF
    };

static const q15_t in_rfft_noisy_512[512] = {
    0xFA7C, 0x3E27, 0x5BDA, 0x3BD9, 0xFB4E, 0xB349, 0xA469, 0xBCE5,
    0x0179, 0x3E6C, 0x59C5, 0x4110, 0x00A4, 0xC3AB, 0xAFF3, 0xB4F5,
    0x0980, 0x3497, 0x5C8F, 0x48EE, 0xFC7A, 0xCB15, 0xAE9C, 0xB5F6,
    0xFEBA, 0x4344, 0x53D8, 0x4B92, 0x0483, 0xC232, 0xA6B9, 0xBC50,
    0x00CF, 0x36BB, 0x5398, 0x4868, 0xFAA0, 0xC153, 0xB3F0, 0xB4F4,
    0xF9CA, 0x3DC8, 0x5190, 0x4940, 0x077A, 0xBE48, 0x98EF, 0xC36D,
    0x0610, 0x4797, 0x5CDF, 0x310A, 0x0092, 0xBC8F, 0xAFA4, 0xC710,
    0xFA0C, 0x4544, 0x54E8, 0x37DA, 0x0916, 0xC3D5, 0xA344, 0xC3B0,
    0xFC9F, 0x4385, 0x5633, 0x307D, 0xF82C, 0xBB40, 0x9FAE, 0xC65B,
    0x0255, 0x4477, 0x5877, 0x3DD8, 0x06D6, 0xC8F9, 0xACFB, 0xBDA6,
    0xFE08, 0x42F5, 0x5A18, 0x513B, 0x0D8C, 0xC503, 0xA95C, 0xB472,
    0xFD9C, 0x44DB, 0x569E, 0x42E6, 0xF8E5, 0xC71A, 0xA789, 0xB43A,
    0x0CDC, 0x3BB9, 0x58D8, 0x3B0C, 0x02AC, 0xD097, 0xA05C, 0xBFDE,
    0xFC4B, 0x405C, 0x5C21, 0x3748, 0xFF86, 0xC084, 0xAC7E, 0xBDC2,
    0x015B, 0x41E9, 0x5A85, 0x35D5, 0xFAE2, 0xBE92, 0xB12F, 0xC36F,
    0x0626, 0x3F2C, 0x5C3A, 0x377A, 0x0555, 0xC329, 0xA56F, 0xAF68,
    0xFA25, 0x3D16, 0x5624, 0x3F6A, 0x063D, 0xC4D8, 0xAD02, 0xB91E,
    0x037A, 0x4414, 0x59E9, 0x3C19, 0x040D, 0xBE73, 0xAE5B, 0xC420,
    0xEE6E, 0x3E63, 0x50AF, 0x4749, 0x02C9, 0xCB38, 0xA5F2, 0xC855,
    0xFD72, 0x385E, 0x5BF6, 0x3F6A, 0xFAFB, 0xBE10, 0xAEF1, 0xBBD7,
    0xF916, 0x4386, 0x5855, 0x3214, 0x0E11, 0xBECB, 0xB50A, 0xC604,
    0x05A3, 0x414E, 0x61B1, 0x3E09, 0xFBC9, 0xBD38, 0xA59A, 0xBBE5,
    0xF37B, 0x383C, 0x54D0, 0x4B94, 0x0E92, 0xC901, 0x9DD0, 0xC63F,
    0xFDF9, 0x4300, 0x5AE6, 0x3BF3, 0xFC17, 0xC578, 0xA725, 0xBAB1,
    0x0446, 0x3E6F, 0x58D3, 0x45FB, 0x0FC1, 0xBDE9, 0xA604, 0xC63A,
    0xFF67, 0x4A04, 0x636F, 0x4889, 0xFDD4, 0xC90C, 0xA8A2, 0xBC41,
    0x05EF, 0x3AAF, 0x55AD, 0x37EB, 0xFF44, 0xC55E, 0xA6B3, 0xB9BC,
    0xFAB0, 0x3E16, 0x568B, 0x4E4A, 0xF333, 0xBF3A, 0xAD9C, 0xD25D,
    0xFEAD, 0x3BB7, 0x5046, 0x410E, 0x06A4, 0xC549, 0xAC1C, 0xBE3D,
    0x05E1, 0x38D4, 0x5C21, 0x4AC0, 0x038B, 0xB4F1, 0xA54C, 0xC7A8,
    0x0293, 0x4017, 0x596D, 0x44ED, 0xFCB5, 0xB46A, 0x9FF2, 0xB97C,
    0x02EA, 0x402F, 0x50EF, 0x457F, 0x04FA, 0xB898, 0xA0E4, 0xB506,
    0x01BE, 0x46B3, 0x5698, 0x3F78, 0x028F, 0xC1FD, 0x9996, 0xBB66,
    0xFD77, 0x40E3, 0x5C93, 0x3ED0, 0xF93D, 0xB9C8, 0xA3DE, 0xCA82,
    0x0292, 0x4141, 0x5493, 0x34FD, 0x07ED, 0xB932, 0xA846, 0xB671,
    0x0161, 0x39FC, 0x5D00, 0x4167, 0x0170, 0xC234, 0xA384, 0xBE98,
    0x0293, 0x408E, 0x4BBD, 0x3B4A, 0x001F, 0xB931, 0xA949, 0xC778,
    0x08D4, 0x3C57, 0x6454, 0x3CB2, 0x01AB, 0xBFED, 0x9D8A, 0xBEAE,
    0x06A8, 0x3CEA, 0x5F9B, 0x410A, 0x08EF, 0xC193, 0x96A6, 0xB814,
    0x08CD, 0x42ED, 0x5B1A, 0x3865, 0x01F1, 0xC462, 0xA366, 0xC5AF,
    0x03E9, 0x4036, 0x50A1, 0x3A82, 0xFE59, 0xB94B, 0x9B17, 0xBDA9,
    0x01C4, 0x45E6, 0x537C, 0x4268, 0xFAA0, 0xC0BC, 0xA4A0, 0xBDAA,
    0xFB8C, 0x47F3, 0x53D1, 0x3681, 0xFB18, 0xBBDC, 0xA65E, 0xC897,
    0xFFB9, 0x43F1, 0x5506, 0x4E1F, 0xF2C6, 0xCE2B, 0xAAE7, 0xC487,
    0x119B, 0x3D9B, 0x5386, 0x3AFA, 0x01A9, 0xBD97, 0xA178, 0xC4D7,
    0xFE48, 0x3FFE, 0x5751, 0x3B50, 0x008E, 0xC4B1, 0xAEC7, 0xC33E,
    0xEE93, 0x424C, 0x5F2A, 0x3775, 0x0DC5, 0xC844, 0x9C05, 0xC199,
    0x149D, 0x3E8A, 0x5B3B, 0x3811, 0x019A, 0xBDE6, 0xAB52, 0xC8EE,
    0x0F91, 0x4249, 0x57CB, 0x4871, 0xFCE0, 0xC09C, 0xA7E8, 0xBFC8,
    0xFFC6, 0x3F55, 0x4DB4, 0x4435, 0xEE74, 0xBD7A, 0x9B1F, 0xC442,
    0xFBA3, 0x3783, 0x4F0C, 0x3DAD, 0x054E, 0xBAFA, 0xAA0F, 0xC13F,
    0xF6F3, 0x3DAE, 0x6006, 0x3A6C, 0xF3E8, 0xC374, 0xA6AD, 0xC722,
    0xFD44, 0x44AB, 0x633A, 0x3E64, 0xFA97, 0xB669, 0xA8DC, 0xBC06,
    0xF62E, 0x42D1, 0x5D6D, 0x3E69, 0x04C1, 0xCA95, 0xA7DC, 0xBE91,
    0x01CB, 0x36DF, 0x5481, 0x3900, 0x0B3C, 0xBAB3, 0xAD3C, 0xC561,
    0x0085, 0x3D82, 0x5E5E, 0x3721, 0x06AF, 0xC391, 0xA6A1, 0xBF80,
    0xFC9F, 0x3E5A, 0x5A18, 0x3E9A, 0x0DF8, 0xB8D5, 0x9E62, 0xCADD,
    0x0209, 0x3465, 0x62CD, 0x3F01, 0xFE8F, 0xC086, 0xA367, 0xBB4A,
    0xFAAE, 0x4864, 0x663E, 0x4001, 0xF71B, 0xBE67, 0xA6DC, 0xC07A,
    0xF32C, 0x4394, 0x4FCA, 0x3A35, 0x03BF, 0xC29E, 0xB25F, 0xBB0E,
    0xFA60, 0x36C3, 0x5FD8, 0x42FA, 0xF52C, 0xB74B, 0xAC02, 0xC67E,
    0x066C, 0x4C87, 0x5DE2, 0x3B40, 0xF823, 0xC1FC, 0xA808, 0xC2B0,
    0xFB5C, 0x3E3C, 0x5F33, 0x472F, 0x017B, 0xBFE9, 0x9E07, 0xBF4F,
    0xFE0C, 0x3BC5, 0x5CC5, 0x3AE0, 0xF982, 0xB84B, 0xA449, 0xC770
    };

static const q15_t in_rifft_noisy_512[1026] = {
    0xFFFA, 0x0000, 0xFFF7, 0xFFC6, 0xFFD1, 0x0019, 0x0020, 0xFFCC,
    0xFFC4, 0x0032, 0xFFFD, 0x0016, 0xFFE4, 0xFFBD, 0x004E, 0xFFDA,
    0xFFDD, 0x0028, 0xFFAF, 0xFFFC, 0xFFC8, 0x001D, 0xFFEC, 0xFFED,
    0xFFFA, 0x0009, 0xFFFA, 0x0035, 0xFF75, 0xFFA6, 0xFFF6, 0xFFE4,
    0xFFF2, 0xFFF8, 0xFFA3, 0x006C, 0x0016, 0xFFFE, 0x0020, 0xFFD5,
    0x0029, 0x0004, 0x0009, 0xFFE1, 0xFFFA, 0x000D, 0xFFD9, 0xFFF3,
    0xFFEB, 0x0012, 0x003E, 0x003A, 0x001E, 0xFFFF, 0xFFCE, 0x0000,
    0x0028, 0xFFAD, 0xFFC5, 0x0018, 0xFFEF, 0x0056, 0x003D, 0xFFB0,
    0xFFDA, 0x001C, 0xFFE8, 0x0039, 0x005F, 0x000C, 0xFFD3, 0xFFD2,
    0xFFF2, 0x0004, 0x0047, 0xFFF8, 0x000E, 0x000C, 0xFFB2, 0x001D,
    0x000D, 0xFFD3, 0xFFFB, 0x0006, 0x0074, 0xFFDC, 0x007C, 0xFFE5,
    0xFFF3, 0xFFE0, 0x0048, 0x005D, 0xFFBD, 0x0022, 0x0018, 0xFFDC,
    0x004C, 0x0055, 0x001D, 0x0028, 0xFFDD, 0x0059, 0xFFFA, 0x0000,
    0xFFC6, 0xFFB7, 0xFFC0, 0x0022, 0xFFF7, 0x0002, 0x0080, 0x001D,
    0x001D, 0xFFA1, 0x000B, 0x0006, 0xFFF6, 0xFFA1, 0xFFF4, 0xFFC1,
    0x0013, 0xFFD8, 0xFFEB, 0x000B, 0x000D, 0xFFDD, 0xFFCE, 0xFFAF,
    0xFFF1, 0xD337, 0x0002, 0x0075, 0x0002, 0xFF74, 0x001D, 0x001A,
    0x001C, 0x002D, 0x0020, 0x0009, 0x0004, 0x001C, 0xFFDC, 0x006D,
    0x0026, 0xFFD7, 0x0040, 0x004C, 0x0048, 0xFFA0, 0xFFF8, 0xFF9D,
    0x002E, 0xFFDA, 0x000D, 0x0028, 0xFFCC, 0x0020, 0x0002, 0xFFDE,
    0x0019, 0xFFF9, 0xFFF3, 0xFFFC, 0xFFE9, 0xFFE8, 0x003F, 0xFFDB,
    0xFFD4, 0xFFDD, 0x0063, 0x0020, 0x003D, 0xFFCF, 0x0090, 0xFF7F,
    0xFFA0, 0x0012, 0xFFC8, 0x0015, 0xFFDF, 0x0034, 0x0029, 0x0096,
    0x000C, 0x0051, 0xFFAA, 0x006B, 0x0050, 0x0011, 0xFFC6, 0xFFCC,
    0xFFEA, 0x0059, 0xFFBC, 0xFF8A, 0xFFF7, 0xFFC8, 0xFFDC, 0xFFDB,
    0xFFFD, 0xFFEF, 0xFFDB, 0x001C, 0xFFEB, 0x001A, 0x0012, 0x003A,
    0xFFC7, 0xFFE2, 0x0027, 0x0017, 0x0019, 0xFFF5, 0xFFA6, 0x001E,
    0x0063, 0xFFA4, 0xFFF9, 0xFFFF, 0xFFDC, 0x0029, 0xFFFB, 0x0042,
    0xFFFE, 0xFFF0, 0xFFCA, 0x0004, 0xFFDD, 0x0006, 0x0028, 0x0036,
    0xFFF8, 0x000B, 0x0011, 0x0001, 0x003A, 0xFFAE, 0xFFE3, 0x0026,
    0x006A, 0xFFC4, 0xFFE0, 0x0052, 0x0024, 0x0022, 0xFFE9, 0xFFF1,
    0xFFD0, 0x002A, 0xFFAE, 0x0024, 0x0052, 0x00AB, 0xFFD1, 0xFFD1,
    0x001E, 0xFFE1, 0xFF69, 0x0000, 0xFFC3, 0xFFEC, 0x0014, 0xFFF4,
    0xFFF3, 0x0015, 0x0005, 0xFFFC, 0xFFCC, 0xFFD9, 0x0030, 0xFFDF,
    0x0069, 0x0010, 0xFFF5, 0x0059, 0xFFA2, 0x0028, 0xFFEC, 0x0007,
    0xFFFA, 0xFFCF, 0xFFE9, 0x001D, 0x0009, 0x002D, 0x0026, 0xFFF6,
    0x0039, 0x0004, 0xFFBC, 0x0027, 0x000C, 0xFFFB, 0x002D, 0x0045,
    0xFFE3, 0x0036, 0xFFC2, 0x0029, 0xFFE0, 0xFF89, 0xFFF1, 0xFFEA,
    0x0011, 0xFFF4, 0xFFE0, 0xFF93, 0x0046, 0xFFE5, 0x001E, 0x0003,
    0xFFA9, 0x005C, 0xFFBB, 0xFFD8, 0xFFC8, 0x0035, 0x0020, 0x004D,
    0x001B, 0xFFA7, 0x0048, 0x0063, 0x002D, 0x0051, 0x000C, 0xFFFA,
    0xFFCE, 0xFFFC, 0x0068, 0x000F, 0xFFD5, 0xFFA2, 0xFFDB, 0x0004,
    0xFFD8, 0xFFEF, 0x0000, 0xFF9A, 0x0005, 0x0009, 0xFFDB, 0xFFF9,
    0x0033, 0xFFFB, 0x0029, 0xFFF3, 0xFFA3, 0x0015, 0xFFED, 0x000E,
    0x0020, 0xFFD7, 0xFFDE, 0x0054, 0xFFB2, 0xFFCC, 0x003A, 0xFFB7,
    0x002B, 0xFFF1, 0xFFE9, 0x000F, 0xFFAF, 0x001B, 0xFFD8, 0x0023,
    0xFFFA, 0x0070, 0xFFDB, 0x0073, 0xFFD7, 0x0029, 0x0086, 0x0041,
    0x0038, 0xFFB0, 0x0048, 0x0029, 0x002F, 0x000B, 0x0030, 0x0006,
    0xFFE8, 0xFFCF, 0xFFBE, 0xFFF7, 0x000A, 0xFFB5, 0xFFEE, 0xFFCE,
    0x0035, 0xFFF5, 0x0027, 0xFFF6, 0x0004, 0xFFC8, 0xFFD6, 0xFFF3,
    0xFF78, 0x0002, 0xFFCB, 0x0021, 0x0002, 0x0092, 0xFFB2, 0x000E,
    0x0028, 0xFFA3, 0xFFC1, 0xFFF8, 0xFFDA, 0x0015, 0xFFC6, 0xFFFB,
    0x001C, 0xFFF1, 0x0005, 0xFFF2, 0xFFEB, 0xFFA4, 0xFFB3, 0x0028,
    0xFFEC, 0x005C, 0xFFE0, 0x002F, 0x002C, 0x001A, 0xFFE6, 0x0045,
    0xFFD8, 0xFFE2, 0x0002, 0xFFEE, 0x001C, 0x0041, 0xFFFE, 0x0010,
    0xFFD8, 0xFF8D, 0xFFD3, 0x000D, 0xFFFF, 0x0007, 0x005A, 0x0007,
    0xFFFF, 0x0052, 0xFFF9, 0xFFE0, 0x0002, 0xFFFF, 0x005F, 0xFFE1,
    0xFFEB, 0x0018, 0x0022, 0x0012, 0x0018, 0xFFE1, 0xFF86, 0xFFFE,
    0x0005, 0xFFAE, 0xFFB0, 0x0024, 0x001A, 0xFFFF, 0xFFAB, 0xFFA8,
    0x0020, 0xFFE0, 0x0038, 0x0036, 0xFFF1, 0xFFEB, 0xFFCF, 0x000A,
    0x0017, 0x000B, 0x0047, 0xFFEC, 0xFF98, 0x0040, 0x001F, 0x006D,
    0x0005, 0xFFD8, 0xFFEE, 0x001B, 0xFFEB, 0x0048, 0xFFFB, 0x0012,
    0x0028, 0xFF97, 0x0044, 0x0033, 0xFFE2, 0x0060, 0x000A, 0x000E,
    0x001B, 0x0043, 0xFFD5, 0xFFA5, 0x0010, 0xFFEC, 0x001D, 0x0021,
    0x0022, 0x0000, 0x001D, 0xFFDF, 0x0010, 0x0014, 0xFFD5, 0x005B,
    0x001B, 0xFFBD, 0x000A, 0xFFF2, 0xFFE2, 0xFFA0, 0x0044, 0xFFCD,
    0x0028, 0x0069, 0xFFFB, 0xFFEE, 0xFFEB, 0xFFB8, 0xFFEE, 0xFFE5,
    0x0005, 0x0028, 0x001F, 0xFF93, 0xFF98, 0xFFC0, 0x0047, 0x0014,
    0x0017, 0xFFF5, 0xFFCF, 0xFFF6, 0xFFF1, 0x0015, 0x0038, 0xFFCA,
    0x0020, 0x0020, 0xFFAB, 0x0058, 0x001A, 0x0001, 0xFFB0, 0xFFDC,
    0x0005, 0x0052, 0xFF86, 0x0002, 0x0018, 0x001F, 0x0022, 0xFFEE,
    0xFFEB, 0xFFE8, 0x005F, 0x001F, 0x0002, 0x0001, 0xFFF9, 0x0020,
    0xFFFF, 0xFFAE, 0x005A, 0xFFF9, 0xFFFF, 0xFFF9, 0xFFD3, 0xFFF3,
    0xFFD8, 0x0073, 0xFFFE, 0xFFF0, 0x001C, 0xFFBF, 0x0002, 0x0012,
    0xFFD8, 0x001E, 0xFFE6, 0xFFBB, 0x002C, 0xFFE6, 0xFFE0, 0xFFD1,
    0xFFEC, 0xFFA4, 0xFFB3, 0xFFD8, 0xFFEB, 0x005C, 0x0005, 0x000E,
    0x001C, 0x000F, 0xFFC6, 0x0005, 0xFFDA, 0xFFEB, 0xFFC1, 0x0008,
    0x0028, 0x005D, 0xFFB2, 0xFFF2, 0x0002, 0xFF6E, 0xFFCB, 0xFFDF,
    0xFF78, 0xFFFE, 0xFFD6, 0x000D, 0x0004, 0x0038, 0x0027, 0x000A,
    0x0035, 0x000B, 0xFFEE, 0x0032, 0x000A, 0x004B, 0xFFBE, 0x0009,
    0xFFE8, 0x0031, 0x0030, 0xFFFA, 0x002F, 0xFFF5, 0x0048, 0xFFD7,
    0x0038, 0x0050, 0x0086, 0xFFBF, 0xFFD7, 0xFFD7, 0xFFDB, 0xFF8D,
    0xFFFA, 0xFF90, 0xFFD8, 0xFFDD, 0xFFAF, 0xFFE5, 0xFFE9, 0xFFF1,
    0x002B, 0x000F, 0x003A, 0x0049, 0xFFB2, 0x0034, 0xFFDE, 0xFFAC,
    0x0020, 0x0029, 0xFFED, 0xFFF2, 0xFFA3, 0xFFEB, 0x0029, 0x000D,
    0x0033, 0x0005, 0xFFDB, 0x0007, 0x0005, 0xFFF7, 0x0000, 0x0066,
    0xFFD8, 0x0011, 0xFFDB, 0xFFFC, 0xFFD5, 0x005E, 0x0068, 0xFFF1,
    0xFFCE, 0x0004, 0x000C, 0x0006, 0x002D, 0xFFAF, 0x0048, 0xFF9D,
    0x001B, 0x0059, 0x0020, 0xFFB3, 0xFFC8, 0xFFCB, 0xFFBB, 0x0028,
    0xFFA9, 0xFFA4, 0x001E, 0xFFFD, 0x0046, 0x001B, 0xFFE0, 0x006D,
    0x0011, 0x000C, 0xFFF1, 0x0016, 0xFFE0, 0x0077, 0xFFC2, 0xFFD7,
    0xFFE3, 0xFFCA, 0x002D, 0xFFBB, 0x000C, 0x0005, 0xFFBC, 0xFFD9,
    0x0039, 0xFFFC, 0x0026, 0x000A, 0x0009, 0xFFD3, 0xFFE9, 0xFFE3,
    0xFFFA, 0x0031, 0xFFEC, 0xFFF9, 0xFFA2, 0xFFD8, 0xFFF5, 0xFFA7,
    0x0069, 0xFFF0, 0x0030, 0x0021, 0xFFCC, 0x0027, 0x0005, 0x0004,
    0xFFF3, 0xFFEB, 0x0014, 0x000C, 0xFFC3, 0x0014, 0xFF69, 0x0000,
    0x001E, 0x001F, 0xFFD1, 0x002F, 0x0052, 0xFF55, 0xFFAE, 0xFFDC,
    0xFFD0, 0xFFD6, 0xFFE9, 0x000F, 0x0024, 0xFFDE, 0xFFE0, 0xFFAE,
    0x006A, 0x003C, 0xFFE3, 0xFFDA, 0x003A, 0x0052, 0x0011, 0xFFFF,
    0xFFF8, 0xFFF5, 0x0028, 0xFFCA, 0xFFDD, 0xFFFA, 0xFFCA, 0xFFFC,
    0xFFFE, 0x0010, 0xFFFB, 0xFFBE, 0xFFDC, 0xFFD7, 0xFFF9, 0x0001,
    0x0063, 0x005C, 0xFFA6, 0xFFE2, 0x0019, 0x000B, 0x0027, 0xFFE9,
    0xFFC7, 0x001E, 0x0012, 0xFFC6, 0xFFEB, 0xFFE6, 0xFFDB, 0xFFE4,
    0xFFFD, 0x0011, 0xFFDC, 0x0025, 0xFFF7, 0x0038, 0xFFBC, 0x0076,
    0xFFEA, 0xFFA7, 0xFFC6, 0x0034, 0x0050, 0xFFEF, 0xFFAA, 0xFF95,
    0x000C, 0xFFAF, 0x0029, 0xFF6A, 0xFFDF, 0xFFCC, 0xFFC8, 0xFFEB,
    0xFFA0, 0xFFEE, 0x0090, 0x0081, 0x003D, 0x0031, 0x0063, 0xFFE0,
    0xFFD4, 0x0023, 0x003F, 0x0025, 0xFFE9, 0x0018, 0xFFF3, 0x0004,
    0x0019, 0x0007, 0x0002, 0x0022, 0xFFCC, 0xFFE0, 0x000D, 0xFFD8,
    0x002E, 0x0026, 0xFFF8, 0x0063, 0x0048, 0x0060, 0x0040, 0xFFB4,
    0x0026, 0x0029, 0xFFDC, 0xFF93, 0x0004, 0xFFE4, 0x0020, 0xFFF7,
    0x001C, 0xFFD3, 0x001D, 0xFFE6, 0x0002, 0x008C, 0x0002, 0xFF8B,
    0xFFF1, 0x2CC9, 0xFFCE, 0x0051, 0x000D, 0x0023, 0xFFEB, 0xFFF5,
    0x0013, 0x0028, 0xFFF4, 0x003F, 0xFFF6, 0x005F, 0x000B, 0xFFFA,
    0x001D, 0x005F, 0x0080, 0xFFE3, 0xFFF7, 0xFFFE, 0xFFC0, 0xFFDE,
    0xFFC6, 0x0049, 0xFFFA, 0x0000, 0xFFDD, 0xFFA7, 0x001D, 0xFFD8,
    0x004C, 0xFFAB, 0x0018, 0x0024, 0xFFBD, 0xFFDE, 0x0048, 0xFFA3,
    0xFFF3, 0x0020, 0x007C, 0x001B, 0x0074, 0x0024, 0xFFFB, 0xFFFA,
    0x000D, 0x002D, 0xFFB2, 0xFFE3, 0x000E, 0xFFF4, 0x0047, 0x0008,
    0xFFF2, 0xFFFC, 0xFFD3, 0x002E, 0x005F, 0xFFF4, 0xFFE8, 0xFFC7,
    0xFFDA, 0xFFE4, 0x003D, 0x0050, 0xFFEF, 0xFFAA, 0xFFC5, 0xFFE8,
    0x0028, 0x0053, 0xFFCE, 0x0000, 0x001E, 0x0001, 0x003E, 0xFFC6,
    0xFFEB, 0xFFEE, 0xFFD9, 0x000D, 0xFFFA, 0xFFF3, 0x0009, 0x001F,
    0x0029, 0xFFFC, 0x0020, 0x002B, 0x0016, 0x0002, 0xFFA3, 0xFF94,
    0xFFF2, 0x0008, 0xFFF6, 0x001C, 0xFF75, 0x005A, 0xFFFA, 0xFFCB,
    0xFFFA, 0xFFF7, 0xFFEC, 0x0013, 0xFFC8, 0xFFE3, 0xFFAF, 0x0004,
    0xFFDD, 0xFFD8, 0x004E, 0x0026, 0xFFE4, 0x0043, 0xFFFD, 0xFFEA,
    0xFFC4, 0xFFCE, 0x0020, 0x0034, 0xFFD1, 0xFFE7, 0xFFF7, 0x003A,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_noisy_512[513] = {
    0xFFFA, 0x0000, 0xFFF7, 0xFFC6, 0xFFD1, 0x0019, 0x0020, 0xFFCC,
    0xFFC4, 0x0032, 0xFFFD, 0x0016, 0xFFE4, 0xFFBD, 0x004E, 0xFFDA,
    0xFFDD, 0x0028, 0xFFAF, 0xFFFC, 0xFFC8, 0x001D, 0xFFEC, 0xFFED,
    0xFFFA, 0x0009, 0xFFFA, 0x0035, 0xFF75, 0xFFA6, 0xFFF6, 0xFFE4,
    0xFFF2, 0xFFF8, 0xFFA3, 0x006C, 0x0016, 0xFFFE, 0x0020, 0xFFD5,
    0x0029, 0x0004, 0x0009, 0xFFE1, 0xFFFA, 0x000D, 0xFFD9, 0xFFF3,
    0xFFEB, 0x0012, 0x003E, 0x003A, 0x001E, 0xFFFF, 0xFFCE, 0x0000,
    0x0028, 0xFFAD, 0xFFC5, 0x0018, 0xFFEF, 0x0056, 0x003D, 0xFFB0,
    0xFFDA, 0x001C, 0xFFE8, 0x0039, 0x005F, 0x000C, 0xFFD3, 0xFFD2,
    0xFFF2, 0x0004, 0x0047, 0xFFF8, 0x000E, 0x000C, 0xFFB2, 0x001D,
    0x000D, 0xFFD3, 0xFFFB, 0x0006, 0x0074, 0xFFDC, 0x007C, 0xFFE5,
    0xFFF3, 0xFFE0, 0x0048, 0x005D, 0xFFBD, 0x0022, 0x0018, 0xFFDC,
    0x004C, 0x0055, 0x001D, 0x0028, 0xFFDD, 0x0059, 0xFFFA, 0x0000,
    0xFFC6, 0xFFB7, 0xFFC0, 0x0022, 0xFFF7, 0x0002, 0x0080, 0x001D,
    0x001D, 0xFFA1, 0x000B, 0x0006, 0xFFF6, 0xFFA1, 0xFFF4, 0xFFC1,
    0x0013, 0xFFD8, 0xFFEB, 0x000B, 0x000D, 0xFFDD, 0xFFCE, 0xFFAF,
    0xFFF1, 0xD337, 0x0002, 0x0075, 0x0002, 0xFF74, 0x001D, 0x001A,
    0x001C, 0x002D, 0x0020, 0x0009, 0x0004, 0x001C, 0xFFDC, 0x006D,
    0x0026, 0xFFD7, 0x0040, 0x004C, 0x0048, 0xFFA0, 0xFFF8, 0xFF9D,
    0x002E, 0xFFDA, 0x000D, 0x0028, 0xFFCC, 0x0020, 0x0002, 0xFFDE,
    0x0019, 0xFFF9, 0xFFF3, 0xFFFC, 0xFFE9, 0xFFE8, 0x003F, 0xFFDB,
    0xFFD4, 0xFFDD, 0x0063, 0x0020, 0x003D, 0xFFCF, 0x0090, 0xFF7F,
    0xFFA0, 0x0012, 0xFFC8, 0x0015, 0xFFDF, 0x0034, 0x0029, 0x0096,
    0x000C, 0x0051, 0xFFAA, 0x006B, 0x0050, 0x0011, 0xFFC6, 0xFFCC,
    0xFFEA, 0x0059, 0xFFBC, 0xFF8A, 0xFFF7, 0xFFC8, 0xFFDC, 0xFFDB,
    0xFFFD, 0xFFEF, 0xFFDB, 0x001C, 0xFFEB, 0x001A, 0x0012, 0x003A,
    0xFFC7, 0xFFE2, 0x0027, 0x0017, 0x0019, 0xFFF5, 0xFFA6, 0x001E,
    0x0063, 0xFFA4, 0xFFF9, 0xFFFF, 0xFFDC, 0x0029, 0xFFFB, 0x0042,
    0xFFFE, 0xFFF0, 0xFFCA, 0x0004, 0xFFDD, 0x0006, 0x0028, 0x0036,
    0xFFF8, 0x000B, 0x0011, 0x0001, 0x003A, 0xFFAE, 0xFFE3, 0x0026,
    0x006A, 0xFFC4, 0xFFE0, 0x0052, 0x0024, 0x0022, 0xFFE9, 0xFFF1,
    0xFFD0, 0x002A, 0xFFAE, 0x0024, 0x0052, 0x00AB, 0xFFD1, 0xFFD1,
    0x001E, 0xFFE1, 0xFF69, 0x0000, 0xFFC3, 0xFFEC, 0x0014, 0xFFF4,
    0xFFF3, 0x0015, 0x0005, 0xFFFC, 0xFFCC, 0xFFD9, 0x0030, 0xFFDF,
    0x0069, 0x0010, 0xFFF5, 0x0059, 0xFFA2, 0x0028, 0xFFEC, 0x0007,
    0xFFFA, 0xFFCF, 0xFFE9, 0x001D, 0x0009, 0x002D, 0x0026, 0xFFF6,
    0x0039, 0x0004, 0xFFBC, 0x0027, 0x000C, 0xFFFB, 0x002D, 0x0045,
    0xFFE3, 0x0036, 0xFFC2, 0x0029, 0xFFE0, 0xFF89, 0xFFF1, 0xFFEA,
    0x0011, 0xFFF4, 0xFFE0, 0xFF93, 0x0046, 0xFFE5, 0x001E, 0x0003,
    0xFFA9, 0x005C, 0xFFBB, 0xFFD8, 0xFFC8, 0x0035, 0x0020, 0x004D,
    0x001B, 0xFFA7, 0x0048, 0x0063, 0x002D, 0x0051, 0x000C, 0xFFFA,
    0xFFCE, 0xFFFC, 0x0068, 0x000F, 0xFFD5, 0xFFA2, 0xFFDB, 0x0004,
    0xFFD8, 0xFFEF, 0x0000, 0xFF9A, 0x0005, 0x0009, 0xFFDB, 0xFFF9,
    0x0033, 0xFFFB, 0x0029, 0xFFF3, 0xFFA3, 0x0015, 0xFFED, 0x000E,
    0x0020, 0xFFD7, 0xFFDE, 0x0054, 0xFFB2, 0xFFCC, 0x003A, 0xFFB7,
    0x002B, 0xFFF1, 0xFFE9, 0x000F, 0xFFAF, 0x001B, 0xFFD8, 0x0023,
    0xFFFA, 0x0070, 0xFFDB, 0x0073, 0xFFD7, 0x0029, 0x0086, 0x0041,
    0x0038, 0xFFB0, 0x0048, 0x0029, 0x002F, 0x000B, 0x0030, 0x0006,
    0xFFE8, 0xFFCF, 0xFFBE, 0xFFF7, 0x000A, 0xFFB5, 0xFFEE, 0xFFCE,
    0x0035, 0xFFF5, 0x0027, 0xFFF6, 0x0004, 0xFFC8, 0xFFD6, 0xFFF3,
    0xFF78, 0x0002, 0xFFCB, 0x0021, 0x0002, 0x0092, 0xFFB2, 0x000E,
    0x0028, 0xFFA3, 0xFFC1, 0xFFF8, 0xFFDA, 0x0015, 0xFFC6, 0xFFFB,
    0x001C, 0xFFF1, 0x0005, 0xFFF2, 0xFFEB, 0xFFA4, 0xFFB3, 0x0028,
    0xFFEC, 0x005C, 0xFFE0, 0x002F, 0x002C, 0x001A, 0xFFE6, 0x0045,
    0xFFD8, 0xFFE2, 0x0002, 0xFFEE, 0x001C, 0x0041, 0xFFFE, 0x0010,
    0xFFD8, 0xFF8D, 0xFFD3, 0x000D, 0xFFFF, 0x0007, 0x005A, 0x0007,
    0xFFFF, 0x0052, 0xFFF9, 0xFFE0, 0x0002, 0xFFFF, 0x005F, 0xFFE1,
    0xFFEB, 0x0018, 0x0022, 0x0012, 0x0018, 0xFFE1, 0xFF86, 0xFFFE,
    0x0005, 0xFFAE, 0xFFB0, 0x0024, 0x001A, 0xFFFF, 0xFFAB, 0xFFA8,
    0x0020, 0xFFE0, 0x0038, 0x0036, 0xFFF1, 0xFFEB, 0xFFCF, 0x000A,
    0x0017, 0x000B, 0x0047, 0xFFEC, 0xFF98, 0x0040, 0x001F, 0x006D,
    0x0005, 0xFFD8, 0xFFEE, 0x001B, 0xFFEB, 0x0048, 0xFFFB, 0x0012,
    0x0028, 0xFF97, 0x0044, 0x0033, 0xFFE2, 0x0060, 0x000A, 0x000E,
    0x001B, 0x0043, 0xFFD5, 0xFFA5, 0x0010, 0xFFEC, 0x001D, 0x0021,
    0x0022
    };

static const q15_t in_rfft_noisy_1024[1024] = {
    0xFCA5, 0x4581, 0x6074, 0x406B, 0x042E, 0xBB1A, 0xAEB2, 0xC405,
    0x01BD, 0x3EAB, 0x5716, 0x39EE, 0x0476, 0xBFC8, 0xA46C, 0xC995,
    0xFD24, 0x43B6, 0x54E1, 0x3C77, 0xFAEF, 0xBFFC, 0xAB43, 0xBEC6,
    0xF9C5, 0x38F4, 0x686C, 0x4104, 0xFC0F, 0xBE5E, 0x9D64, 0xBFD4,
    0xFF97, 0x3A8B, 0x5F56, 0x3CE1, 0x0516, 0xB9ED, 0xB1A0, 0xC551,
    0xF6D6, 0x4094, 0x6568, 0x3D34, 0x08A3, 0xC88D, 0xA7F3, 0xBB0A,
    0xFAA1, 0x3EC0, 0x5DE2, 0x415E, 0x0505, 0xC59E, 0xA890, 0xBD07,
    0xFF85, 0x45AD, 0x5DD5, 0x3B9D, 0xFCA8, 0xB8F1, 0xAD37, 0xC14C,
    0xFB8D, 0x3B0C, 0x5ADB, 0x4C5C, 0xFAE2, 0xC3A2, 0xA7AB, 0xAC36,
    0xF892, 0x3FEF, 0x5F89, 0x4D88, 0xFA10, 0xB4BF, 0xA59E, 0xC533,
    0x01DC, 0x36A7, 0x581D, 0x3949, 0xF5B8, 0xC18E, 0xA91C, 0xBBCC,
    0x00BA, 0x39DF, 0x54FF, 0x4610, 0x0783, 0xC55B, 0xA6FE, 0xCE47,
    0x044A, 0x4305, 0x5B74, 0x451E, 0x0969, 0xC948, 0xA973, 0xB90C,
    0x036B, 0x4336, 0x5082, 0x3C3C, 0x010B, 0xC379, 0x9FE8, 0xBCA2,
    0x0440, 0x376B, 0x6234, 0x3A38, 0xFAF0, 0xB6DD, 0xAA75, 0xBBD2,
    0x0214, 0x3A61, 0x4320, 0x3A70, 0x07D7, 0xBC57, 0x9F24, 0xC56E,
    0xFEE1, 0x3F6C, 0x6827, 0x480E, 0xF8A8, 0xC324, 0x9DDD, 0xCC8F,
    0x023C, 0x3E48, 0x57CB, 0x3B27, 0x078A, 0xBC0C, 0xACBE, 0xC0D7,
    0xFEEC, 0x4430, 0x5199, 0x4140, 0xF3EA, 0xC575, 0xAD73, 0xC709,
    0x016F, 0x3AA8, 0x582F, 0x4BA9, 0x0866, 0xBE69, 0xA4E8, 0xB915,
    0x09F6, 0x3540, 0x60C2, 0x4B39, 0xF3F1, 0xBE24, 0xA1EE, 0xCA13,
    0x0887, 0x402B, 0x659A, 0x454E, 0xF57A, 0xBF85, 0xA925, 0xC011,
    0x0D29, 0x51DD, 0x5924, 0x38A5, 0xF9BE, 0xB7CF, 0xA571, 0xBC53,
    0x1011, 0x3F3F, 0x5AAA, 0x3FC8, 0x0012, 0xC375, 0xA5CC, 0xBFD3,
    0xFDE3, 0x44A7, 0x5615, 0x427F, 0x0BB6, 0xBDC6, 0xA1A7, 0xC5B1,
    0xFEE1, 0x489A, 0x5932, 0x42DD, 0xF515, 0xCA19, 0xA1EA, 0xCBE4,
    0x070A, 0x4802, 0x5B02, 0x4779, 0xFF91, 0xBB11, 0xB094, 0xBC2A,
    0xEE8C, 0x486E, 0x588F, 0x39C0, 0xF83C, 0xBE79, 0xAC37, 0xAE9D,
    0x00DF, 0x3BFF, 0x5214, 0x4BD2, 0xFC50, 0xC55C, 0xA32E, 0xC939,
    0xF6D6, 0x3E19, 0x5F7C, 0x3EB1, 0xFFAF, 0xBF38, 0xAB85, 0xC460,
    0xF923, 0x3BB1, 0x5141, 0x409D, 0x0632, 0xB7B0, 0x9F6B, 0xC729,
    0x070E, 0x3998, 0x5C7C, 0x3612, 0xF9F0, 0xC191, 0xA2CB, 0xC493,
    0xFF3A, 0x3E8A, 0x5ADA, 0x390A, 0xFEF9, 0xC3A7, 0xA78A, 0xC285,
    0x0136, 0x49D6, 0x5735, 0x3DB9, 0xFC57, 0xC2E9, 0xAF99, 0xC9F0,
    0x056B, 0x522E, 0x499D, 0x3B03, 0x037E, 0xBD98, 0xA924, 0xBD76,
    0xFBE3, 0x3BA0, 0x60C2, 0x42B9, 0x0486, 0xB9C0, 0xB5D6, 0xC733,
    0x01E9, 0x4428, 0x57A2, 0x3F9F, 0xF6B7, 0xC5DF, 0xA47B, 0xBE74,
    0x0547, 0x499E, 0x617B, 0x3A26, 0xFC30, 0xC460, 0x9FEE, 0xC563,
    0x0248, 0x45B8, 0x4C4B, 0x3BB0, 0x054B, 0xC2C3, 0x9DBF, 0xBC7D,
    0x0181, 0x405F, 0x5555, 0x4CAE, 0x0460, 0xBEF9, 0xA521, 0xBFB1,
    0x06EA, 0x4557, 0x6334, 0x3F07, 0x0D08, 0xBAAD, 0xA8B1, 0xB685,
    0xF8D7, 0x32A5, 0x5B82, 0x3B8F, 0xFD4C, 0xC93C, 0xB180, 0xCD46,
    0xF53A, 0x3D82, 0x576C, 0x3CE8, 0xF900, 0xB8C0, 0xAC25, 0xBCFB,
    0x05EF, 0x46F0, 0x5C07, 0x3BE8, 0x072D, 0xC012, 0xA959, 0xB95B,
    0xFABA, 0x4164, 0x4AA6, 0x4434, 0xFF58, 0xC5E9, 0xB09B, 0xC5D4,
    0x0741, 0x3BD1, 0x54C1, 0x35F6, 0x011D, 0xBA91, 0xB0D4, 0xCAA0,
    0xFD65, 0x4913, 0x5515, 0x3D6E, 0xFFB1, 0xC078, 0xA8F4, 0xC336,
    0xF62E, 0x4460, 0x5A85, 0x49C7, 0x00DE, 0xB980, 0xA719, 0xBDB2,
    0xF5C0, 0x48DA, 0x4DDE, 0x4853, 0x0925, 0xC3E1, 0xA509, 0xC3C6,
    0xFADC, 0x388D, 0x5BF2, 0x4859, 0xFC61, 0xBA2C, 0xA567, 0xC64F,
    0xF5AF, 0x43E9, 0x59D9, 0x3AD3, 0xFA46, 0xB0B9, 0xA3CC, 0xC6F9,
    0x014A, 0x32D9, 0x5E83, 0x40FE, 0x0BCE, 0xB815, 0xA453, 0xC2F1,
    0x05A4, 0x3C47, 0x5696, 0x4444, 0xFB3D, 0xC5DD, 0xA596, 0xBBDA,
    0xFFD9, 0x47D0, 0x5180, 0x3642, 0xFC1F, 0xC7EF, 0x9B9D, 0xC368,
    0xFA42, 0x48F5, 0x5CF9, 0x42F8, 0xF842, 0xC664, 0xA16B, 0xBEF9,
    0x0171, 0x4DFA, 0x57C4, 0x395F, 0x0156, 0xC3F7, 0xB1E4, 0xCC0A,
    0xFE5E, 0x4322, 0x5DBF, 0x36CF, 0x03A5, 0xB50B, 0xA722, 0xC0A9,
    0xFF61, 0x3DCF, 0x51D7, 0x3D09, 0xFD55, 0xBA55, 0xA46A, 0xC1C4,
    0x05E3, 0x4A89, 0x5F8F, 0x401A, 0xFAC3, 0xC0F1, 0xA238, 0xB130,
    0xF94A, 0x432E, 0x4CD3, 0x39AE, 0xFEF4, 0xC234, 0xA014, 0xBB46,
    0xEF8C, 0x3DB3, 0x5CA2, 0x3CBB, 0x01D4, 0xC512, 0xA66C, 0xC236,
    0x0659, 0x43E2, 0x6060, 0x452F, 0xF5D3, 0xC420, 0xB214, 0xC6F5,
    0x02A9, 0x3951, 0x55DC, 0x4706, 0x0705, 0xBCF6, 0x9D15, 0xC48F,
    0xF64D, 0x38B3, 0x577A, 0x41A9, 0xF9D0, 0xC3D2, 0x9F09, 0xC44F,
    0x0701, 0x3A67, 0x522B, 0x43D7, 0xFE05, 0xC498, 0xA502, 0xC184,
    0x003E, 0x387C, 0x5953, 0x3F73, 0x082D, 0xCA54, 0xAABF, 0xC887,
    0x012A, 0x4D52, 0x5CC1, 0x3A37, 0xFC5D, 0xC855, 0xA4E6, 0xC023,
    0x0AAF, 0x3F5D, 0x5D6E, 0x3C81, 0x03D2, 0xB676, 0xA206, 0xBFB7,
    0xF979, 0x4207, 0x52F1, 0x440E, 0xFB1A, 0xBFDA, 0xAEDC, 0xBF77,
    0xFDF6, 0x37C3, 0x58C9, 0x414B, 0x053C, 0xB84B, 0xA97B, 0xC18D,
    0x00BE, 0x3F81, 0x5724, 0x40B9, 0xF1B6, 0xCB42, 0xAFE3, 0xBF5F,
    0x0438, 0x36B4, 0x58DF, 0x49CB, 0xFAB2, 0xC9AF, 0xA8F4, 0xBB04,
    0x0578, 0x3BA9, 0x5E77, 0x48DB, 0xFC27, 0xC1CA, 0xA503, 0xB975,
    0xFBD3, 0x3689, 0x55DD, 0x3A13, 0x0003, 0xB731, 0xA0D4, 0xB8E7,
    0x039D, 0x39D1, 0x4683, 0x3E7E, 0x00DB, 0xC122, 0xAE0A, 0xBEC5,
    0x07BA, 0x3B18, 0x6024, 0x42E0, 0xFA7D, 0xB4F7, 0xAA28, 0xB8AA,
    0x0F1A, 0x345F, 0x626C, 0x4220, 0xFA80, 0xC04C, 0xB223, 0xC68B,
    0xFB71, 0x3EDF, 0x4DAE, 0x38B6, 0xFBD6, 0xBFF0, 0xA66D, 0xC46A,
    0x01E5, 0x477A, 0x5073, 0x3D4A, 0x0112, 0xBF73, 0x9A56, 0xBF9F,
    0xFBE0, 0x387E, 0x5583, 0x3F49, 0xFC0C, 0xCBC3, 0xA492, 0xC2FA,
    0xFF26, 0x41F4, 0x58B3, 0x41E1, 0xF95B, 0xB0C6, 0xA613, 0xC2F0,
    0x0457, 0x3D4C, 0x5A28, 0x38C8, 0xFF52, 0xCA4F, 0xA22E, 0xCC26,
    0xF9B3, 0x379D, 0x5450, 0x3A59, 0xF5D9, 0xC434, 0xADEC, 0xC20B,
    0x04F2, 0x3830, 0x58AF, 0x5580, 0x0A2C, 0xB39C, 0xA19E, 0xCAC3,
    0xFB89, 0x3FBB, 0x5D17, 0x49C3, 0xFA31, 0xBAF3, 0xB8FD, 0xC8EA,
    0xFDC7, 0x4236, 0x597A, 0x436B, 0xF974, 0xC7FF, 0xA4ED, 0xBFCD,
    0x00CB, 0x3904, 0x484F, 0x40C5, 0xF4B4, 0xC2B2, 0x9CB1, 0xB828,
    0xF895, 0x3DCB, 0x548A, 0x4BA1, 0x04A8, 0xD15A, 0xA293, 0xC2B3,
    0xF42F, 0x3B1B, 0x6028, 0x414F, 0x0A30, 0xC5A7, 0xAAA0, 0xBF78,
    0xFF57, 0x430E, 0x526F, 0x4967, 0xFFD5, 0xBFA4, 0xB00C, 0xBAD0,
    0xF416, 0x4599, 0x5547, 0x3DB7, 0xF5DD, 0xC1D2, 0xA06F, 0xC3DB,
    0xFA9F, 0x2D23, 0x57F0, 0x3E25, 0x03A1, 0xC2DE, 0xAC4E, 0xB84F,
    0x072F, 0x4364, 0x5FE8, 0x425D, 0xF044, 0xC224, 0xA139, 0xCA73,
    0xFE9B, 0x3B28, 0x5E56, 0x3F82, 0x0929, 0xBE1A, 0xA668, 0xBB99,
    0x04B2, 0x3D67, 0x4C13, 0x42EA, 0x021E, 0xB57A, 0xB37D, 0xB875,
    0xFEA9, 0x42F3, 0x6BB3, 0x40BF, 0x0302, 0xCA59, 0xA5AB, 0xCBD2,
    0xFF65, 0x398F, 0x541D, 0x41FD, 0xFB46, 0xBE69, 0x9E5E, 0xBC7E,
    0xFFF8, 0x3B94, 0x5054, 0x492A, 0xFF2B, 0xBD88, 0x9C38, 0xC33A,
    0x03A5, 0x41B0, 0x55E5, 0x4024, 0x02EC, 0xC3FC, 0xA996, 0xBDBC,
    0x0428, 0x44E8, 0x6081, 0x415A, 0xFE82, 0xC403, 0x9C8D, 0xBDBB,
    0x0090, 0x4766, 0x55F2, 0x3F62, 0x098B, 0xC6C4, 0xA566, 0xC81A,
    0x02BF, 0x4BF8, 0x57C8, 0x3C88, 0xFF30, 0xC8E9, 0xA0E5, 0xC069,
    0x008F, 0x40FD, 0x5D57, 0x37BD, 0xFBF1, 0xC626, 0xA829, 0xB844,
    0xF72A, 0x4168, 0x5F96, 0x36EF, 0xF94C, 0xB4B1, 0xABCB, 0xCDB0,
    0x038C, 0x43C3, 0x5A7D, 0x42CD, 0x042F, 0xBFD3, 0xAE09, 0xCEC7,
    0x0045, 0x3B11, 0x5CDF, 0x3E92, 0x05DF, 0xC34D, 0x9DEE, 0xC502,
    0x0671, 0x3FD2, 0x5FD5, 0x413F, 0xFF2A, 0xC8BC, 0xA381, 0xC2D5,
    0x0717, 0x3B66, 0x5DD0, 0x3642, 0xFE55, 0xC97B, 0x9CAB, 0xBAE5,
    0xF8F6, 0x42AF, 0x5E9A, 0x4825, 0x0416, 0xC835, 0xA4DC, 0xC893,
    0x0146, 0x3534, 0x64B3, 0x366F, 0xFD2C, 0xBE9B, 0xA2BB, 0xB9D5,
    0x0B68, 0x449A, 0x5FF6, 0x3B76, 0xFF54, 0xC5EB, 0xA690, 0xCBD7,
    0x0119, 0x3F71, 0x63BD, 0x41D8, 0x04A9, 0xBF50, 0x912C, 0xBE38,
    0xFF32, 0x3B7C, 0x531A, 0x476D, 0x01FC, 0xD076, 0xA4E3, 0xC5A6,
    0x03B5, 0x3B47, 0x60A9, 0x4223, 0xF0E6, 0xC1D1, 0xAE3C, 0xB965,
    0xFB85, 0x398F, 0x577E, 0x3031, 0xEA2D, 0xBDF5, 0xA1A7, 0xBE47,
    0xFC77, 0x40CA, 0x5235, 0x3A1A, 0xF94A, 0xC4B3, 0xA702, 0xBF5E,
    0xF926, 0x42A9, 0x5AC8, 0x471F, 0x03F9, 0xC621, 0xA78D, 0xB643,
    0x0AD7, 0x4AE3, 0x5383, 0x49A3, 0xFBDF, 0xC987, 0xA4D2, 0xCC9D,
    0xFECE, 0x3C02, 0x57FC, 0x4564, 0x0035, 0xC4C4, 0xADDF, 0xC0E3,
    0x0C90, 0x4B2C, 0x5191, 0x4091, 0xF86D, 0xBB7E, 0xA87D, 0xC5E0,
    0xF627, 0x38F3, 0x58D6, 0x44AF, 0xFE0D, 0xC1ED, 0xAB12, 0xBBAF,
    0x0985, 0x4C11, 0x5450, 0x40C7, 0xFBDA, 0xC86D, 0xAD27, 0xC68B,
    0x0A30, 0x3701, 0x5715, 0x4092, 0xF338, 0xBAA3, 0xA2EB, 0xBF36,
    0x08BE, 0x4926, 0x58D3, 0x452E, 0xF77B, 0xBD32, 0xADBF, 0xC658,
    0xF8E7, 0x3CCD, 0x5DA9, 0x3F91, 0xFE0A, 0xBD5F, 0xA82E, 0xC027,
    0x00E2, 0x3A3C, 0x6479, 0x3E3D, 0xFB6D, 0xC3BB, 0xAAB9, 0xBE41,
    0x0267, 0x3EC0, 0x554D, 0x39F9, 0xF8E2, 0xC088, 0xB7A7, 0xBF85,
    0xFE05, 0x3D09, 0x561B, 0x452F, 0x0171, 0xB81F, 0xA7A9, 0xC79C
    };

static const q15_t in_rifft_noisy_1024[2050] = {
    0x002D, 0x0000, 0x0035, 0xFFF1, 0xFFE0, 0x001B, 0xFFEB, 0x0001,
    0x0018, 0xFFF5, 0x0004, 0x0015, 0x003C, 0x0012, 0xFFF3, 0x0012,
    0xFFDF, 0xFFD2, 0xFFCD, 0x0018, 0xFFE4, 0xFFFD, 0x0015, 0xFFF1,
    0x0022, 0xFFC2, 0xFFF0, 0xFFFF, 0x0032, 0xFFF9, 0x000B, 0x000B,
    0xFFFD, 0x0029, 0xFFE7, 0x0006, 0xFFEC, 0x0052, 0x0002, 0x0014,
    0x000E, 0x0008, 0x0005, 0xFFF1, 0x002D, 0xFF98, 0x007F, 0xFFF3,
    0xFFEC, 0xFFFD, 0x001F, 0x000A, 0xFFD8, 0xFFCC, 0x0018, 0x0023,
    0xFF9F, 0x0018, 0x0031, 0x002B, 0xFFE4, 0x0028, 0x0000, 0xFFBF,
    0x0031, 0xFFA5, 0x0002, 0xFFFD, 0xFFEA, 0xFFEA, 0x003E, 0xFFEF,
    0xFFEA, 0xFFEF, 0xFFCE, 0x0029, 0xFFDF, 0xFFE8, 0x004F, 0x0035,
    0xFFF3, 0xFFF2, 0xFFE6, 0x0013, 0x0034, 0xFFD7, 0x000D, 0xFFEF,
    0x0038, 0x0049, 0xFFE5, 0x0008, 0xFFF6, 0x0010, 0xFFD2, 0xFFE3,
    0x0017, 0x0020, 0xFFC5, 0xFFE2, 0xFFE8, 0xFFCA, 0xFFFF, 0xFFE1,
    0x0018, 0x001D, 0x003D, 0x0008, 0x0041, 0x0014, 0x001B, 0xFFD4,
    0xFFCC, 0xFFE4, 0x0008, 0xFFFA, 0x000A, 0xFFD7, 0x000C, 0xFFE8,
    0x0038, 0x0024, 0xFFF0, 0x0061, 0xFFE8, 0xFFFF, 0xFFD3, 0x001C,
    0x0004, 0x0014, 0xFFE0, 0xFFC5, 0x0016, 0xFFD5, 0x0000, 0x0026,
    0xFFE7, 0x0016, 0xFFDD, 0xFFCA, 0xFFE8, 0x0025, 0x001B, 0xFFF6,
    0x0018, 0x0021, 0xFFD1, 0xFFF8, 0x0023, 0xFFCB, 0x000A, 0x0019,
    0xFFDE, 0x0007, 0x000B, 0xFFF5, 0xFFF7, 0xFFFA, 0x001A, 0xFFF1,
    0x004C, 0xFFE9, 0xFFB3, 0xFFCD, 0x003E, 0xFFF7, 0x000E, 0xFFF1,
    0xFFE7, 0xFFA0, 0x0008, 0x0030, 0x001A, 0x0031, 0xFFE6, 0xFFEC,
    0xFFF7, 0x0008, 0x000A, 0x000A, 0xFFF0, 0xFFD8, 0xFFCF, 0x000D,
    0x0045, 0x0029, 0xFFD6, 0xFFF6, 0x0003, 0x0012, 0x001C, 0xFFD0,
    0xFF96, 0xFFB0, 0x0020, 0xFFF1, 0x0012, 0xFFBB, 0x002B, 0xFFDC,
    0x0001, 0xFFFE, 0x001E, 0x0004, 0xFFB2, 0x0014, 0x0015, 0x0021,
    0xFFF0, 0xFFF2, 0xFFF7, 0xFFE6, 0xFFFB, 0xFFDC, 0x0017, 0x0026,
    0x002A, 0x0030, 0xFFF2, 0x0006, 0x001F, 0x0020, 0x0024, 0x001A,
    0xFFED, 0x0004, 0xFFF0, 0x0002, 0x000E, 0x0026, 0xFFCF, 0xFFE7,
    0x0000, 0x003D, 0x0048, 0xFFE9, 0xFFD5, 0x0009, 0xFFBF, 0x0005,
    0x0020, 0x0030, 0x0037, 0xFFFA, 0x0008, 0xFFC0, 0x003F, 0xFFDD,
    0xFFF6, 0xFFE1, 0x0005, 0xFFF6, 0xFFF9, 0xFFF2, 0x001E, 0x0005,
    0x002D, 0xD34B, 0x0007, 0xFFC9, 0x0003, 0x0021, 0xFFBC, 0x0054,
    0x0006, 0x0019, 0x0026, 0x0001, 0xFFE7, 0x0048, 0xFFF3, 0xFFED,
    0xFFF4, 0x0005, 0x0007, 0x002A, 0x0012, 0xFFFC, 0x001B, 0x003F,
    0x0018, 0xFFF4, 0xFFCB, 0xFFD6, 0xFFEF, 0xFFEB, 0x0031, 0x000B,
    0xFFF8, 0x0001, 0x0020, 0xFFE4, 0xFFF6, 0xFFF4, 0xFFD4, 0xFFEC,
    0xFFEA, 0x0017, 0xFFF5, 0xFFF0, 0xFFF8, 0x0044, 0x0016, 0x000B,
    0x0020, 0xFFDC, 0xFFFE, 0xFFF1, 0xFFE2, 0xFFBF, 0x0020, 0x0016,
    0x0023, 0x002B, 0xFFFE, 0xFFDF, 0x0029, 0x0005, 0xFFD0, 0xFFFD,
    0xFFB4, 0xFFC8, 0xFFE7, 0x0033, 0xFFD7, 0x0031, 0x0035, 0xFFC9,
    0x0027, 0xFFE4, 0x001D, 0xFFF6, 0x002B, 0xFFDF, 0xFFD1, 0xFFEC,
    0xFFF6, 0xFFD7, 0xFFDE, 0xFFE4, 0x0004, 0xFFC6, 0xFFBA, 0x0006,
    0x0018, 0x0001, 0xFFB2, 0x0014, 0xFFE2, 0xFFA3, 0xFFF0, 0xFFEE,
    0x0005, 0x0039, 0xFFEF, 0x000E, 0x0017, 0x0043, 0x0015, 0xFFE2,
    0x0006, 0x0008, 0x000F, 0xFFFB, 0x003B, 0xFFC2, 0xFFFD, 0xFFD4,
    0x0022, 0xFFF5, 0xFFFC, 0xFFAD, 0x0020, 0xFFEF, 0xFFFD, 0x0000,
    0x0010, 0x0080, 0x002D, 0x0018, 0x002C, 0x0013, 0xFFD8, 0x0005,
    0x0023, 0xFFF7, 0x0016, 0x0020, 0xFFC1, 0xFFF9, 0xFFE8, 0x0004,
    0x0018, 0xFFE8, 0x0026, 0xFFF1, 0xFFEA, 0xFFA7, 0x0026, 0xFFAF,
    0x0000, 0xFFB1, 0x0001, 0x0004, 0xFFE6, 0x004B, 0x001C, 0xFFE1,
    0x000F, 0x0024, 0xFFED, 0x0005, 0x0013, 0xFFBD, 0x0049, 0xFFEF,
    0xFFE0, 0x0018, 0xFFF1, 0xFFFE, 0xFFEF, 0x0016, 0x0004, 0x0025,
    0xFFE4, 0xFFDA, 0xFFEB, 0x0013, 0x0032, 0xFFFD, 0x0018, 0xFFF6,
    0xFFF3, 0x001E, 0xFFFA, 0xFFF9, 0x0012, 0x0017, 0xFFE9, 0x0027,
    0xFFCD, 0xFFF5, 0xFFFD, 0x0000, 0x000A, 0xFFEF, 0x0021, 0x003E,
    0xFFEE, 0x0032, 0xFFED, 0xFFEB, 0x0009, 0x001E, 0x0021, 0xFFF2,
    0xFFDE, 0x0011, 0xFFCB, 0x0031, 0xFFFB, 0xFFF0, 0xFFE9, 0x0026,
    0x0057, 0xFFEA, 0x000A, 0x0016, 0x003F, 0x0020, 0xFFDE, 0x0026,
    0x0015, 0x0009, 0xFFD2, 0xFF72, 0x0020, 0x002F, 0x0014, 0x0010,
    0xFFFE, 0x0001, 0xFFD7, 0xFFF3, 0xFFD5, 0x0006, 0x0004, 0x0025,
    0x0061, 0x0062, 0xFFC0, 0x0014, 0x001C, 0xFFEB, 0xFFFD, 0xFFD3,
    0x0015, 0x003A, 0x0024, 0xFFF6, 0xFFDF, 0xFFEB, 0x0008, 0xFFF7,
    0xFFF4, 0xFFEE, 0xFFD0, 0x0025, 0xFFA8, 0x000D, 0xFFEA, 0xFFF8,
    0xFFD4, 0x002A, 0xFFDF, 0xFFF8, 0x0018, 0x000E, 0xFFD9, 0x001B,
    0xFFE0, 0xFFDC, 0xFFD9, 0x0026, 0xFFFC, 0x0045, 0xFFE3, 0xFFF8,
    0x0014, 0x0026, 0xFFF4, 0xFFFA, 0x0010, 0xFFE3, 0x001A, 0xFFD4,
    0xFFD1, 0xFFE6, 0x0016, 0xFFF4, 0x0028, 0xFFF6, 0xFFF5, 0x0025,
    0x003D, 0x0019, 0x001E, 0x000A, 0xFFBB, 0xFFE5, 0x001F, 0xFFEA,
    0xFFF5, 0xFFFE, 0x0022, 0xFFB4, 0x0009, 0xFFFE, 0x0042, 0xFFD5,
    0xFFD6, 0xFFF3, 0xFFF3, 0x0043, 0x004F, 0x005B, 0xFFDD, 0xFFE2,
    0xFFDE, 0xFFDD, 0xFFE8, 0x0032, 0xFFD4, 0xFFF5, 0xFFFA, 0xFFFC,
    0x000C, 0x0043, 0x0009, 0xFFF6, 0x002E, 0x0027, 0xFFB3, 0xFFF7,
    0xFFE0, 0xFFE5, 0x0021, 0xFFFB, 0x000E, 0xFFFC, 0xFFDA, 0x0007,
    0x0033, 0x0002, 0x001E, 0xFFE6, 0xFFE5, 0xFFED, 0xFFED, 0x000E,
    0xFFE0, 0x0018, 0x0015, 0xFFEE, 0x0012, 0xFFEF, 0xFFD3, 0x0011,
    0xFFE4, 0xFFD0, 0xFFEF, 0x0051, 0x0008, 0x001A, 0xFFE3, 0xFFE6,
    0xFFFF, 0x0011, 0xFFBD, 0x002F, 0xFFCA, 0x0001, 0x0009, 0x0024,
    0x0001, 0xFFC0, 0x001F, 0x0012, 0x0043, 0xFFF7, 0x004A, 0xFFFB,
    0x001B, 0xFFF1, 0xFFCA, 0xFFFF, 0xFFBE, 0x0054, 0x001B, 0x0013,
    0x000C, 0x001F, 0xFFF7, 0x0030, 0xFFF5, 0x002B, 0x0016, 0x0017,
    0x0015, 0xFFD2, 0x002F, 0xFFCA, 0xFFC9, 0xFFBB, 0xFFD9, 0xFFC7,
    0x0027, 0xFFF0, 0xFFED, 0x0041, 0x0023, 0xFFD0, 0xFFEA, 0xFFE6,
    0x0016, 0x0024, 0xFFBC, 0xFFFA, 0x0004, 0x0004, 0x0021, 0x000E,
    0xFFF7, 0x0023, 0xFFC0, 0x0042, 0x0019, 0xFFEC, 0x0020, 0x0024,
    0x0015, 0x002A, 0xFFEF, 0xFFBF, 0x0036, 0x0016, 0xFFBA, 0x0006,
    0x0028, 0x0045, 0xFFE1, 0x0027, 0xFFC9, 0x0011, 0x0008, 0xFFD9,
    0x001C, 0x0038, 0xFFF8, 0xFFE0, 0xFFFF, 0xFFFF, 0xFFCA, 0x0000,
    0xFFEA, 0xFFFF, 0xFFDC, 0x000F, 0xFFF4, 0xFFD4, 0x0013, 0xFFF6,
    0xFFDE, 0xFFEE, 0xFFF6, 0xFFCD, 0xFFE3, 0xFFA7, 0x0015, 0x001C,
    0x0007, 0x0027, 0xFFE6, 0xFFCA, 0xFFDF, 0xFFEC, 0xFFD8, 0x000A,
    0x0017, 0x0009, 0x001F, 0xFFDD, 0x0002, 0xFFF5, 0x0001, 0xFFFB,
    0xFFED, 0x0004, 0xFFEF, 0xFFF4, 0x000D, 0xFFE6, 0xFFD6, 0x000D,
    0x002F, 0xFFD5, 0xFFE9, 0xFFD8, 0xFFD0, 0xFFD2, 0x000E, 0xFFD4,
    0xFFD7, 0x001E, 0x000F, 0x0031, 0xFFE9, 0x0028, 0xFF95, 0xFFD2,
    0xFFC5, 0xFFE4, 0xFFCC, 0xFF8A, 0x002F, 0x002C, 0x0047, 0xFFE1,
    0x0031, 0xFFD1, 0xFFE3, 0x0053, 0x0001, 0xFFC3, 0xFFE9, 0xFFF4,
    0x0004, 0x0006, 0x0014, 0x002F, 0xFFEE, 0x001E, 0x0011, 0x0018,
    0xFFE4, 0x0032, 0xFFDC, 0x0005, 0x0014, 0x0035, 0xFFE5, 0xFFD3,
    0x001F, 0x0026, 0x0036, 0xFFE2, 0x0009, 0xFFEA, 0xFFD3, 0xFFB0,
    0xFFD9, 0x000E, 0x0007, 0xFFF2, 0x003A, 0xFFDE, 0xFFDC, 0xFFF7,
    0xFFE3, 0xFFDE, 0xFFE8, 0x0001, 0xFFFE, 0xFFFA, 0xFFC0, 0x0013,
    0x0025, 0xFFEC, 0x001E, 0x0060, 0xFFFF, 0x0004, 0x001F, 0xFFDA,
    0x0009, 0x0031, 0xFFFA, 0xFFE7, 0xFFA7, 0x0011, 0x0011, 0x002E,
    0x0015, 0x000F, 0xFFCD, 0xFFC1, 0x0019, 0xFFD9, 0x0003, 0x0016,
    0x0004, 0x0016, 0x0010, 0x0030, 0xFFFB, 0xFFF9, 0x0029, 0x0027,
    0x001F, 0x0011, 0x0018, 0xFFFA, 0xFFF9, 0xFFCF, 0xFFE7, 0xFFE6,
    0x0018, 0x0039, 0x000E, 0x001E, 0x0035, 0xFFC8, 0xFFF9, 0xFFF5,
    0xFFF3, 0x002C, 0x0019, 0xFFFB, 0x002A, 0xFFD7, 0xFFDD, 0xFFFA,
    0xFFB0, 0xFFFC, 0xFFA1, 0xFFF3, 0x0024, 0x001C, 0x0008, 0x0053,
    0xFFF0, 0xFFB3, 0xFFF9, 0xFFC7, 0x0026, 0xFFF2, 0xFFE5, 0x0005,
    0x0017, 0xFFF1, 0xFFD8, 0x001B, 0xFFFD, 0x0030, 0x001D, 0x001D,
    0xFFA6, 0xFFE1, 0x0004, 0x001B, 0x0001, 0xFFFC, 0xFFD9, 0x001C,
    0xFFD5, 0x0024, 0x000E, 0x0000, 0xFFA9, 0x0002, 0x0030, 0xFFC4,
    0xFFF2, 0xFFFE, 0xFFF2, 0x0002, 0x000A, 0x0037, 0xFFF9, 0x0014,
    0x0001, 0x002B, 0x0010, 0x001F, 0xFFFD, 0xFFB1, 0xFFDA, 0xFFD6,
    0xFFF1, 0x0051, 0xFFFC, 0xFFC4, 0x000A, 0x0004, 0x000C, 0x001A,
    0x001A, 0xFFF9, 0xFFFC, 0xFFE5, 0x0028, 0x000C, 0xFFE0, 0x002B,
    0xFFD8, 0x0012, 0x000C, 0x0025, 0x0003, 0x0021, 0x0011, 0xFFF1,
    0x0008, 0xFFE5, 0x0034, 0x000F, 0xFFF9, 0x0047, 0xFFE7, 0x000C,
    0x0021, 0xFFE5, 0xFFC7, 0xFFD3, 0xFFEC, 0x0028, 0x0019, 0x0031,
    0x0011, 0x0001, 0x0035, 0xFFD4, 0xFFE8, 0x0046, 0x001B, 0xFFF9,
    0xFFBD, 0xFFC5, 0xFFFB, 0x000A, 0x0026, 0xFFC6, 0xFFE0, 0x000B,
    0x0018, 0xFFDF, 0xFFF8, 0x002A, 0x0009, 0x0004, 0x0023, 0xFFC6,
    0xFFD5, 0x0002, 0x0019, 0xFFB9, 0xFFD7, 0x0025, 0xFFDD, 0x0018,
    0x001F, 0xFFE1, 0x0005, 0xFFF4, 0xFFE3, 0x0014, 0xFFF1, 0xFFFB,
    0xFFFE, 0xFFCC, 0x004A, 0x001B, 0x0004, 0x0007, 0x001C, 0xFFE8,
    0x0011, 0x0061, 0x000B, 0x000A, 0x0025, 0x001F, 0x001E, 0x0013,
    0xFF8C, 0x0000, 0x001E, 0xFFED, 0x0025, 0xFFE1, 0x000B, 0xFFF6,
    0x0011, 0xFF9F, 0x001C, 0x0018, 0x0004, 0xFFF9, 0x004A, 0xFFE5,
    0xFFFE, 0x0034, 0xFFF1, 0x0005, 0xFFE3, 0xFFEC, 0x0005, 0x000C,
    0x001F, 0x001F, 0xFFDD, 0xFFE8, 0xFFD7, 0xFFDB, 0x0019, 0x0047,
    0xFFD5, 0xFFFE, 0x0023, 0x003A, 0x0009, 0xFFFC, 0xFFF8, 0xFFD6,
    0x0018, 0x0021, 0xFFE0, 0xFFF5, 0x0026, 0x003A, 0xFFFB, 0xFFF6,
    0xFFBD, 0x003B, 0x001B, 0x0007, 0xFFE8, 0xFFBA, 0x0035, 0x002C,
    0x0011, 0xFFFF, 0x0019, 0xFFCF, 0xFFEC, 0xFFD8, 0xFFC7, 0x002D,
    0x0021, 0x001B, 0xFFE7, 0xFFF4, 0xFFF9, 0xFFB9, 0x0034, 0xFFF1,
    0x0008, 0x001B, 0x0011, 0x000F, 0x0003, 0xFFDF, 0x000C, 0xFFDB,
    0xFFD8, 0xFFEE, 0xFFE0, 0xFFD5, 0x0028, 0xFFF4, 0xFFFC, 0x001B,
    0x001A, 0x0007, 0x000C, 0xFFE6, 0x000A, 0xFFFC, 0xFFFC, 0x003C,
    0xFFF1, 0xFFAF, 0xFFDA, 0x002A, 0xFFFD, 0x004F, 0x0010, 0xFFE1,
    0x0001, 0xFFD5, 0xFFF9, 0xFFEC, 0x000A, 0xFFC9, 0xFFF2, 0xFFFE,
    0xFFF2, 0x0002, 0x0030, 0x003C, 0xFFA9, 0xFFFE, 0x000E, 0x0000,
    0xFFD5, 0xFFDC, 0xFFD9, 0xFFE4, 0x0001, 0x0004, 0x0004, 0xFFE5,
    0xFFA6, 0x001F, 0x001D, 0xFFE3, 0xFFFD, 0xFFD0, 0xFFD8, 0xFFE5,
    0x0017, 0x000F, 0xFFE5, 0xFFFB, 0x0026, 0x000E, 0xFFF9, 0x0039,
    0xFFF0, 0x004D, 0x0008, 0xFFAD, 0x0024, 0xFFE4, 0xFFA1, 0x000D,
    0xFFB0, 0x0004, 0xFFDD, 0x0006, 0x002A, 0x0029, 0x0019, 0x0005,
    0xFFF3, 0xFFD4, 0xFFF9, 0x000B, 0x0035, 0x0038, 0x000E, 0xFFE2,
    0x0018, 0xFFC7, 0xFFE7, 0x001A, 0xFFF9, 0x0031, 0x0018, 0x0006,
    0x001F, 0xFFEF, 0x0029, 0xFFD9, 0xFFFB, 0x0007, 0x0010, 0xFFD0,
    0x0004, 0xFFEA, 0x0003, 0xFFEA, 0x0019, 0x0027, 0xFFCD, 0x003F,
    0x0015, 0xFFF1, 0x0011, 0xFFD2, 0xFFA7, 0xFFEF, 0xFFFA, 0x0019,
    0x0009, 0xFFCF, 0x001F, 0x0026, 0xFFFF, 0xFFFC, 0x001E, 0xFFA0,
    0x0025, 0x0014, 0xFFC0, 0xFFED, 0xFFFE, 0x0006, 0xFFE8, 0xFFFF,
    0xFFE3, 0x0022, 0xFFDC, 0x0009, 0x003A, 0x0022, 0x0007, 0x000E,
    0xFFD9, 0xFFF2, 0xFFD3, 0x0050, 0x0009, 0x0016, 0x0036, 0x001E,
    0x001F, 0xFFDA, 0xFFE5, 0x002D, 0x0014, 0xFFCB, 0xFFDC, 0xFFFB,
    0xFFE4, 0xFFCE, 0x0011, 0xFFE8, 0xFFEE, 0xFFE2, 0x0014, 0xFFD1,
    0x0004, 0xFFFA, 0xFFE9, 0x000C, 0x0001, 0x003D, 0xFFE3, 0xFFAD,
    0x0031, 0x002F, 0x0047, 0x001F, 0x002F, 0xFFD4, 0xFFCC, 0x0076,
    0xFFC5, 0x001C, 0xFF95, 0x002E, 0xFFE9, 0xFFD8, 0x000F, 0xFFCF,
    0xFFD7, 0xFFE2, 0x000E, 0x002C, 0xFFD0, 0x002E, 0xFFE9, 0x0028,
    0x002F, 0x002B, 0xFFD6, 0xFFF3, 0x000D, 0x001A, 0xFFEF, 0x000C,
    0xFFED, 0xFFFC, 0x0001, 0x0005, 0x0002, 0x000B, 0x001F, 0x0023,
    0x0017, 0xFFF7, 0xFFD8, 0xFFF6, 0xFFDF, 0x0014, 0xFFE6, 0x0036,
    0x0007, 0xFFD9, 0x0015, 0xFFE4, 0xFFE3, 0x0059, 0xFFF6, 0x0033,
    0xFFDE, 0x0012, 0x0013, 0x000A, 0xFFF4, 0x002C, 0xFFDC, 0xFFF1,
    0xFFEA, 0x0001, 0xFFCA, 0x0000, 0xFFFF, 0x0001, 0xFFF8, 0x0020,
    0x001C, 0xFFC8, 0x0008, 0x0027, 0xFFC9, 0xFFEF, 0xFFE1, 0xFFD9,
    0x0028, 0xFFBB, 0xFFBA, 0xFFFA, 0x0036, 0xFFEA, 0xFFEF, 0x0041,
    0x0015, 0xFFD6, 0x0020, 0xFFDC, 0x0019, 0x0014, 0xFFC0, 0xFFBE,
    0xFFF7, 0xFFDD, 0x0021, 0xFFF2, 0x0004, 0xFFFC, 0xFFBC, 0x0006,
    0x0016, 0xFFDC, 0xFFEA, 0x001A, 0x0023, 0x0030, 0xFFED, 0xFFBF,
    0x0027, 0x0010, 0xFFD9, 0x0039, 0xFFC9, 0x0045, 0x002F, 0x0036,
    0x0015, 0x002E, 0x0016, 0xFFE9, 0xFFF5, 0xFFD5, 0xFFF7, 0xFFD0,
    0x000C, 0xFFE1, 0x001B, 0xFFED, 0xFFBE, 0xFFAC, 0xFFCA, 0x0001,
    0x001B, 0x000F, 0x004A, 0x0005, 0x0043, 0x0009, 0x001F, 0xFFEE,
    0x0001, 0x0040, 0x0009, 0xFFDC, 0xFFCA, 0xFFFF, 0xFFBD, 0xFFD1,
    0xFFFF, 0xFFEF, 0xFFE3, 0x001A, 0x0008, 0xFFE6, 0xFFEF, 0xFFAF,
    0xFFE4, 0x0030, 0xFFD3, 0xFFEF, 0x0012, 0x0011, 0x0015, 0x0012,
    0xFFE0, 0xFFE8, 0xFFED, 0xFFF2, 0xFFE5, 0x0013, 0x001E, 0x001A,
    0x0033, 0xFFFE, 0xFFDA, 0xFFF9, 0x000E, 0x0004, 0x0021, 0x0005,
    0xFFE0, 0x001B, 0xFFB3, 0x0009, 0x002E, 0xFFD9, 0x0009, 0x000A,
    0x000C, 0xFFBD, 0xFFFA, 0x0004, 0xFFD4, 0x000B, 0xFFE8, 0xFFCE,
    0xFFDE, 0x0023, 0xFFDD, 0x001E, 0x004F, 0xFFA5, 0xFFF3, 0xFFBD,
    0xFFD6, 0x000D, 0x0042, 0x002B, 0x0009, 0x0002, 0x0022, 0x004C,
    0xFFF5, 0x0002, 0x001F, 0x0016, 0xFFBB, 0x001B, 0x001E, 0xFFF6,
    0x003D, 0xFFE7, 0xFFF5, 0xFFDB, 0x0028, 0x000A, 0x0016, 0x000C,
    0xFFD1, 0x001A, 0x001A, 0x002C, 0x0010, 0x001D, 0xFFF4, 0x0006,
    0x0014, 0xFFDA, 0xFFE3, 0x0008, 0xFFFC, 0xFFBB, 0xFFD9, 0xFFDA,
    0xFFE0, 0x0024, 0xFFD9, 0xFFE5, 0x0018, 0xFFF2, 0xFFDF, 0x0008,
    0xFFD4, 0xFFD6, 0xFFEA, 0x0008, 0xFFA8, 0xFFF3, 0xFFD0, 0xFFDB,
    0xFFF4, 0x0012, 0x0008, 0x0009, 0xFFDF, 0x0015, 0x0024, 0x000A,
    0x0015, 0xFFC6, 0xFFFD, 0x002D, 0x001C, 0x0015, 0xFFC0, 0xFFEC,
    0x0061, 0xFF9E, 0x0004, 0xFFDB, 0xFFD5, 0xFFFA, 0xFFD7, 0x000D,
    0xFFFE, 0xFFFF, 0x0014, 0xFFF0, 0x0020, 0xFFD1, 0xFFD2, 0x008E,
    0x0015, 0xFFF7, 0xFFDE, 0xFFDA, 0x003F, 0xFFE0, 0x000A, 0xFFEA,
    0x0057, 0x0016, 0xFFE9, 0xFFDA, 0xFFFB, 0x0010, 0xFFCB, 0xFFCF,
    0xFFDE, 0xFFEF, 0x0021, 0x000E, 0x0009, 0xFFE2, 0xFFED, 0x0015,
    0xFFEE, 0xFFCE, 0x0021, 0xFFC2, 0x000A, 0x0011, 0xFFFD, 0x0000,
    0xFFCD, 0x000B, 0xFFE9, 0xFFD9, 0x0012, 0xFFE9, 0xFFFA, 0x0007,
    0xFFF3, 0xFFE2, 0x0018, 0x000A, 0x0032, 0x0003, 0xFFEB, 0xFFED,
    0xFFE4, 0x0026, 0x0004, 0xFFDB, 0xFFEF, 0xFFEA, 0xFFF1, 0x0002,
    0xFFE0, 0xFFE8, 0x0049, 0x0011, 0x0013, 0x0043, 0xFFED, 0xFFFB,
    0x000F, 0xFFDC, 0x001C, 0x001F, 0xFFE6, 0xFFB5, 0x0001, 0xFFFC,
    0x0000, 0x004F, 0x0026, 0x0051, 0xFFEA, 0x0059, 0x0026, 0x000F,
    0x0018, 0x0018, 0xFFE8, 0xFFFC, 0xFFC1, 0x0007, 0x0016, 0xFFE0,
    0x0023, 0x0009, 0xFFD8, 0xFFFB, 0x002C, 0xFFED, 0x002D, 0xFFE8,
    0x0010, 0xFF80, 0xFFFD, 0x0000, 0x0020, 0x0011, 0xFFFC, 0x0053,
    0x0022, 0x000B, 0xFFFD, 0x002C, 0x003B, 0x003E, 0x000F, 0x0005,
    0x0006, 0xFFF8, 0x0015, 0x001E, 0x0017, 0xFFBD, 0xFFEF, 0xFFF2,
    0x0005, 0xFFC7, 0xFFF0, 0x0012, 0xFFE2, 0x005D, 0xFFB2, 0xFFEC,
    0x0018, 0xFFFF, 0xFFBA, 0xFFFA, 0x0004, 0x003A, 0xFFDE, 0x001C,
    0xFFF6, 0x0029, 0xFFD1, 0x0014, 0x002B, 0x0021, 0x001D, 0x000A,
    0x0027, 0x001C, 0x0035, 0x0037, 0xFFD7, 0xFFCF, 0xFFE7, 0xFFCD,
    0xFFB4, 0x0038, 0xFFD0, 0x0003, 0x0029, 0xFFFB, 0xFFFE, 0x0021,
    0x0023, 0xFFD5, 0x0020, 0xFFEA, 0xFFE2, 0x0041, 0xFFFE, 0x000F,
    0x0020, 0x0024, 0x0016, 0xFFF5, 0xFFF8, 0xFFBC, 0xFFF5, 0x0010,
    0xFFEA, 0xFFE9, 0xFFD4, 0x0014, 0xFFF6, 0x000C, 0x0020, 0x001C,
    0xFFF8, 0xFFFF, 0x0031, 0xFFF5, 0xFFEF, 0x0015, 0xFFCB, 0x002A,
    0x0018, 0x000C, 0x001B, 0xFFC1, 0x0012, 0x0004, 0x0007, 0xFFD6,
    0xFFF4, 0xFFFB, 0xFFF3, 0x0013, 0xFFE7, 0xFFB8, 0x0026, 0xFFFF,
    0x0006, 0xFFE7, 0xFFBC, 0xFFAC, 0x0003, 0xFFDF, 0x0007, 0x0037,
    0x002D, 0x2CB5, 0x001E, 0xFFFB, 0xFFF9, 0x000E, 0x0005, 0x000A,
    0xFFF6, 0x001F, 0x003F, 0x0023, 0x0008, 0x0040, 0x0037, 0x0006,
    0x0020, 0xFFD0, 0xFFBF, 0xFFFB, 0xFFD5, 0xFFF7, 0x0048, 0x0017,
    0x0000, 0xFFC3, 0xFFCF, 0x0019, 0x000E, 0xFFDA, 0xFFF0, 0xFFFE,
    0xFFED, 0xFFFC, 0x0024, 0xFFE6, 0x001F, 0xFFE0, 0xFFF2, 0xFFFA,
    0x002A, 0xFFD0, 0x0017, 0xFFDA, 0xFFFB, 0x0024, 0xFFF7, 0x001A,
    0xFFF0, 0x000E, 0x0015, 0xFFDF, 0xFFB2, 0xFFEC, 0x001E, 0xFFFC,
    0x0001, 0x0002, 0x002B, 0x0024, 0x0012, 0x0045, 0x0020, 0x000F,
    0xFF96, 0x0050, 0x001C, 0x0030, 0x0003, 0xFFEE, 0xFFD6, 0x000A,
    0x0045, 0xFFD7, 0xFFCF, 0xFFF3, 0xFFF0, 0x0028, 0x000A, 0xFFF6,
    0xFFF7, 0xFFF8, 0xFFE6, 0x0014, 0x001A, 0xFFCF, 0x0008, 0xFFD0,
    0xFFE7, 0x0060, 0x000E, 0x000F, 0x003E, 0x0009, 0xFFB3, 0x0033,
    0x004C, 0x0017, 0x001A, 0x000F, 0xFFF7, 0x0006, 0x000B, 0x000B,
    0xFFDE, 0xFFF9, 0x000A, 0xFFE7, 0x0023, 0x0035, 0xFFD1, 0x0008,
    0x0018, 0xFFDF, 0x001B, 0x000A, 0xFFE8, 0xFFDB, 0xFFDD, 0x0036,
    0xFFE7, 0xFFEA, 0x0000, 0xFFDA, 0x0016, 0x002B, 0xFFE0, 0x003B,
    0x0004, 0xFFEC, 0xFFD3, 0xFFE4, 0xFFE8, 0x0001, 0xFFF0, 0xFF9F,
    0x0038, 0xFFDC, 0x000C, 0x0018, 0x000A, 0x0029, 0x0008, 0x0006,
    0xFFCC, 0x001C, 0x001B, 0x002C, 0x0041, 0xFFEC, 0x003D, 0xFFF8,
    0x0018, 0xFFE3, 0xFFFF, 0x001F, 0xFFE8, 0x0036, 0xFFC5, 0x001E,
    0x0017, 0xFFE0, 0xFFD2, 0x001D, 0xFFF6, 0xFFF0, 0xFFE5, 0xFFF8,
    0x0038, 0xFFB7, 0x000D, 0x0011, 0x0034, 0x0029, 0xFFE6, 0xFFED,
    0xFFF3, 0x000E, 0x004F, 0xFFCB, 0xFFDF, 0x0018, 0xFFCE, 0xFFD7,
    0xFFEA, 0x0011, 0x003E, 0x0011, 0xFFEA, 0x0016, 0x0002, 0x0003,
    0x0031, 0x005B, 0x0000, 0x0041, 0xFFE4, 0xFFD8, 0x0031, 0xFFD5,
    0xFF9F, 0xFFE8, 0x0018, 0xFFDD, 0xFFD8, 0x0034, 0x001F, 0xFFF6,
    0xFFEC, 0x0003, 0x007F, 0x000D, 0x002D, 0x0068, 0x0005, 0x000F,
    0x000E, 0xFFF8, 0x0002, 0xFFEC, 0xFFEC, 0xFFAE, 0xFFE7, 0xFFFA,
    0xFFFD, 0xFFD7, 0x000B, 0xFFF5, 0x0032, 0x0007, 0xFFF0, 0x0001,
    0x0022, 0x003E, 0x0015, 0x000F, 0xFFE4, 0x0003, 0xFFCD, 0xFFE8,
    0xFFDF, 0x002E, 0xFFF3, 0xFFEE, 0x003C, 0xFFEE, 0x0004, 0xFFEB,
    0x0018, 0x000B, 0xFFEB, 0xFFFF, 0xFFE0, 0xFFE5, 0x0035, 0x000F,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_noisy_1024[1025] = {
    0x002D, 0x0000, 0x0035, 0xFFF1, 0xFFE0, 0x001B, 0xFFEB, 0x0001,
    0x0018, 0xFFF5, 0x0004, 0x0015, 0x003C, 0x0012, 0xFFF3, 0x0012,
    0xFFDF, 0xFFD2, 0xFFCD, 0x0018, 0xFFE4, 0xFFFD, 0x0015, 0xFFF1,
    0x0022, 0xFFC2, 0xFFF0, 0xFFFF, 0x0032, 0xFFF9, 0x000B, 0x000B,
    0xFFFD, 0x0029, 0xFFE7, 0x0006, 0xFFEC, 0x0052, 0x0002, 0x0014,
    0x000E, 0x0008, 0x0005, 0xFFF1, 0x002D, 0xFF98, 0x007F, 0xFFF3,
    0xFFEC, 0xFFFD, 0x001F, 0x000A, 0xFFD8, 0xFFCC, 0x0018, 0x0023,
    0xFF9F, 0x0018, 0x0031, 0x002B, 0xFFE4, 0x0028, 0x0000, 0xFFBF,
    0x0031, 0xFFA5, 0x0002, 0xFFFD, 0xFFEA, 0xFFEA, 0x003E, 0xFFEF,
    0xFFEA, 0xFFEF, 0xFFCE, 0x0029, 0xFFDF, 0xFFE8, 0x004F, 0x0035,
    0xFFF3, 0xFFF2, 0xFFE6, 0x0013, 0x0034, 0xFFD7, 0x000D, 0xFFEF,
    0x0038, 0x0049, 0xFFE5, 0x0008, 0xFFF6, 0x0010, 0xFFD2, 0xFFE3,
    0x0017, 0x0020, 0xFFC5, 0xFFE2, 0xFFE8, 0xFFCA, 0xFFFF, 0xFFE1,
    0x0018, 0x001D, 0x003D, 0x0008, 0x0041, 0x0014, 0x001B, 0xFFD4,
    0xFFCC, 0xFFE4, 0x0008, 0xFFFA, 0x000A, 0xFFD7, 0x000C, 0xFFE8,
    0x0038, 0x0024, 0xFFF0, 0x0061, 0xFFE8, 0xFFFF, 0xFFD3, 0x001C,
    0x0004, 0x0014, 0xFFE0, 0xFFC5, 0x0016, 0xFFD5, 0x0000, 0x0026,
    0xFFE7, 0x0016, 0xFFDD, 0xFFCA, 0xFFE8, 0x0025, 0x001B, 0xFFF6,
    0x0018, 0x0021, 0xFFD1, 0xFFF8, 0x0023, 0xFFCB, 0x000A, 0x0019,
    0xFFDE, 0x0007, 0x000B, 0xFFF5, 0xFFF7, 0xFFFA, 0x001A, 0xFFF1,
    0x004C, 0xFFE9, 0xFFB3, 0xFFCD, 0x003E, 0xFFF7, 0x000E, 0xFFF1,
    0xFFE7, 0xFFA0, 0x0008, 0x0030, 0x001A, 0x0031, 0xFFE6, 0xFFEC,
    0xFFF7, 0x0008, 0x000A, 0x000A, 0xFFF0, 0xFFD8, 0xFFCF, 0x000D,
    0x0045, 0x0029, 0xFFD6, 0xFFF6, 0x0003, 0x0012, 0x001C, 0xFFD0,
    0xFF96, 0xFFB0, 0x0020, 0xFFF1, 0x0012, 0xFFBB, 0x002B, 0xFFDC,
    0x0001, 0xFFFE, 0x001E, 0x0004, 0xFFB2, 0x0014, 0x0015, 0x0021,
    0xFFF0, 0xFFF2, 0xFFF7, 0xFFE6, 0xFFFB, 0xFFDC, 0x0017, 0x0026,
    0x002A, 0x0030, 0xFFF2, 0x0006, 0x001F, 0x0020, 0x0024, 0x001A,
    0xFFED, 0x0004, 0xFFF0, 0x0002, 0x000E, 0x0026, 0xFFCF, 0xFFE7,
    0x0000, 0x003D, 0x0048, 0xFFE9, 0xFFD5, 0x0009, 0xFFBF, 0x0005,
    0x0020, 0x0030, 0x0037, 0xFFFA, 0x0008, 0xFFC0, 0x003F, 0xFFDD,
    0xFFF6, 0xFFE1, 0x0005, 0xFFF6, 0xFFF9, 0xFFF2, 0x001E, 0x0005,
    0x002D, 0xD34B, 0x0007, 0xFFC9, 0x0003, 0x0021, 0xFFBC, 0x0054,
    0x0006, 0x0019, 0x0026, 0x0001, 0xFFE7, 0x0048, 0xFFF3, 0xFFED,
    0xFFF4, 0x0005, 0x0007, 0x002A, 0x0012, 0xFFFC, 0x001B, 0x003F,
    0x0018, 0xFFF4, 0xFFCB, 0xFFD6, 0xFFEF, 0xFFEB, 0x0031, 0x000B,
    0xFFF8, 0x0001, 0x0020, 0xFFE4, 0xFFF6, 0xFFF4, 0xFFD4, 0xFFEC,
    0xFFEA, 0x0017, 0xFFF5, 0xFFF0, 0xFFF8, 0x0044, 0x0016, 0x000B,
    0x0020, 0xFFDC, 0xFFFE, 0xFFF1, 0xFFE2, 0xFFBF, 0x0020, 0x0016,
    0x0023, 0x002B, 0xFFFE, 0xFFDF, 0x0029, 0x0005, 0xFFD0, 0xFFFD,
    0xFFB4, 0xFFC8, 0xFFE7, 0x0033, 0xFFD7, 0x0031, 0x0035, 0xFFC9,
    0x0027, 0xFFE4, 0x001D, 0xFFF6, 0x002B, 0xFFDF, 0xFFD1, 0xFFEC,
    0xFFF6, 0xFFD7, 0xFFDE, 0xFFE4, 0x0004, 0xFFC6, 0xFFBA, 0x0006,
    0x0018, 0x0001, 0xFFB2, 0x0014, 0xFFE2, 0xFFA3, 0xFFF0, 0xFFEE,
    0x0005, 0x0039, 0xFFEF, 0x000E, 0x0017, 0x0043, 0x0015, 0xFFE2,
    0x0006, 0x0008, 0x000F, 0xFFFB, 0x003B, 0xFFC2, 0xFFFD, 0xFFD4,
    0x0022, 0xFFF5, 0xFFFC, 0xFFAD, 0x0020, 0xFFEF, 0xFFFD, 0x0000,
    0x0010, 0x0080, 0x002D, 0x0018, 0x002C, 0x0013, 0xFFD8, 0x0005,
    0x0023, 0xFFF7, 0x0016, 0x0020, 0xFFC1, 0xFFF9, 0xFFE8, 0x0004,
    0x0018, 0xFFE8, 0x0026, 0xFFF1, 0xFFEA, 0xFFA7, 0x0026, 0xFFAF,
    0x0000, 0xFFB1, 0x0001, 0x0004, 0xFFE6, 0x004B, 0x001C, 0xFFE1,
    0x000F, 0x0024, 0xFFED, 0x0005, 0x0013, 0xFFBD, 0x0049, 0xFFEF,
    0xFFE0, 0x0018, 0xFFF1, 0xFFFE, 0xFFEF, 0x0016, 0x0004, 0x0025,
    0xFFE4, 0xFFDA, 0xFFEB, 0x0013, 0x0032, 0xFFFD, 0x0018, 0xFFF6,
    0xFFF3, 0x001E, 0xFFFA, 0xFFF9, 0x0012, 0x0017, 0xFFE9, 0x0027,
    0xFFCD, 0xFFF5, 0xFFFD, 0x0000, 0x000A, 0xFFEF, 0x0021, 0x003E,
    0xFFEE, 0x0032, 0xFFED, 0xFFEB, 0x0009, 0x001E, 0x0021, 0xFFF2,
    0xFFDE, 0x0011, 0xFFCB, 0x0031, 0xFFFB, 0xFFF0, 0xFFE9, 0x0026,
    0x0057, 0xFFEA, 0x000A, 0x0016, 0x003F, 0x0020, 0xFFDE, 0x0026,
    0x0015, 0x0009, 0xFFD2, 0xFF72, 0x0020, 0x002F, 0x0014, 0x0010,
    0xFFFE, 0x0001, 0xFFD7, 0xFFF3, 0xFFD5, 0x0006, 0x0004, 0x0025,
    0x0061, 0x0062, 0xFFC0, 0x0014, 0x001C, 0xFFEB, 0xFFFD, 0xFFD3,
    0x0015, 0x003A, 0x0024, 0xFFF6, 0xFFDF, 0xFFEB, 0x0008, 0xFFF7,
    0xFFF4, 0xFFEE, 0xFFD0, 0x0025, 0xFFA8, 0x000D, 0xFFEA, 0xFFF8,
    0xFFD4, 0x002A, 0xFFDF, 0xFFF8, 0x0018, 0x000E, 0xFFD9, 0x001B,
    0xFFE0, 0xFFDC, 0xFFD9, 0x0026, 0xFFFC, 0x0045, 0xFFE3, 0xFFF8,
    0x0014, 0x0026, 0xFFF4, 0xFFFA, 0x0010, 0xFFE3, 0x001A, 0xFFD4,
    0xFFD1, 0xFFE6, 0x0016, 0xFFF4, 0x0028, 0xFFF6, 0xFFF5, 0x0025,
    0x003D, 0x0019, 0x001E, 0x000A, 0xFFBB, 0xFFE5, 0x001F, 0xFFEA,
    0xFFF5, 0xFFFE, 0x0022, 0xFFB4, 0x0009, 0xFFFE, 0x0042, 0xFFD5,
    0xFFD6, 0xFFF3, 0xFFF3, 0x0043, 0x004F, 0x005B, 0xFFDD, 0xFFE2,
    0xFFDE, 0xFFDD, 0xFFE8, 0x0032, 0xFFD4, 0xFFF5, 0xFFFA, 0xFFFC,
    0x000C, 0x0043, 0x0009, 0xFFF6, 0x002E, 0x0027, 0xFFB3, 0xFFF7,
    0xFFE0, 0xFFE5, 0x0021, 0xFFFB, 0x000E, 0xFFFC, 0xFFDA, 0x0007,
    0x0033, 0x0002, 0x001E, 0xFFE6, 0xFFE5, 0xFFED, 0xFFED, 0x000E,
    0xFFE0, 0x0018, 0x0015, 0xFFEE, 0x0012, 0xFFEF, 0xFFD3, 0x0011,
    0xFFE4, 0xFFD0, 0xFFEF, 0x0051, 0x0008, 0x001A, 0xFFE3, 0xFFE6,
    0xFFFF, 0x0011, 0xFFBD, 0x002F, 0xFFCA, 0x0001, 0x0009, 0x0024,
    0x0001, 0xFFC0, 0x001F, 0x0012, 0x0043, 0xFFF7, 0x004A, 0xFFFB,
    0x001B, 0xFFF1, 0xFFCA, 0xFFFF, 0xFFBE, 0x0054, 0x001B, 0x0013,
    0x000C, 0x001F, 0xFFF7, 0x0030, 0xFFF5, 0x002B, 0x0016, 0x0017,
    0x0015, 0xFFD2, 0x002F, 0xFFCA, 0xFFC9, 0xFFBB, 0xFFD9, 0xFFC7,
    0x0027, 0xFFF0, 0xFFED, 0x0041, 0x0023, 0xFFD0, 0xFFEA, 0xFFE6,
    0x0016, 0x0024, 0xFFBC, 0xFFFA, 0x0004, 0x0004, 0x0021, 0x000E,
    0xFFF7, 0x0023, 0xFFC0, 0x0042, 0x0019, 0xFFEC, 0x0020, 0x0024,
    0x0015, 0x002A, 0xFFEF, 0xFFBF, 0x0036, 0x0016, 0xFFBA, 0x0006,
    0x0028, 0x0045, 0xFFE1, 0x0027, 0xFFC9, 0x0011, 0x0008, 0xFFD9,
    0x001C, 0x0038, 0xFFF8, 0xFFE0, 0xFFFF, 0xFFFF, 0xFFCA, 0x0000,
    0xFFEA, 0xFFFF, 0xFFDC, 0x000F, 0xFFF4, 0xFFD4, 0x0013, 0xFFF6,
    0xFFDE, 0xFFEE, 0xFFF6, 0xFFCD, 0xFFE3, 0xFFA7, 0x0015, 0x001C,
    0x0007, 0x0027, 0xFFE6, 0xFFCA, 0xFFDF, 0xFFEC, 0xFFD8, 0x000A,
    0x0017, 0x0009, 0x001F, 0xFFDD, 0x0002, 0xFFF5, 0x0001, 0xFFFB,
    0xFFED, 0x0004, 0xFFEF, 0xFFF4, 0x000D, 0xFFE6, 0xFFD6, 0x000D,
    0x002F, 0xFFD5, 0xFFE9, 0xFFD8, 0xFFD0, 0xFFD2, 0x000E, 0xFFD4,
    0xFFD7, 0x001E, 0x000F, 0x0031, 0xFFE9, 0x0028, 0xFF95, 0xFFD2,
    0xFFC5, 0xFFE4, 0xFFCC, 0xFF8A, 0x002F, 0x002C, 0x0047, 0xFFE1,
    0x0031, 0xFFD1, 0xFFE3, 0x0053, 0x0001, 0xFFC3, 0xFFE9, 0xFFF4,
    0x0004, 0x0006, 0x0014, 0x002F, 0xFFEE, 0x001E, 0x0011, 0x0018,
    0xFFE4, 0x0032, 0xFFDC, 0x0005, 0x0014, 0x0035, 0xFFE5, 0xFFD3,
    0x001F, 0x0026, 0x0036, 0xFFE2, 0x0009, 0xFFEA, 0xFFD3, 0xFFB0,
    0xFFD9, 0x000E, 0x0007, 0xFFF2, 0x003A, 0xFFDE, 0xFFDC, 0xFFF7,
    0xFFE3, 0xFFDE, 0xFFE8, 0x0001, 0xFFFE, 0xFFFA, 0xFFC0, 0x0013,
    0x0025, 0xFFEC, 0x001E, 0x0060, 0xFFFF, 0x0004, 0x001F, 0xFFDA,
    0x0009, 0x0031, 0xFFFA, 0xFFE7, 0xFFA7, 0x0011, 0x0011, 0x002E,
    0x0015, 0x000F, 0xFFCD, 0xFFC1, 0x0019, 0xFFD9, 0x0003, 0x0016,
    0x0004, 0x0016, 0x0010, 0x0030, 0xFFFB, 0xFFF9, 0x0029, 0x0027,
    0x001F, 0x0011, 0x0018, 0xFFFA, 0xFFF9, 0xFFCF, 0xFFE7, 0xFFE6,
    0x0018, 0x0039, 0x000E, 0x001E, 0x0035, 0xFFC8, 0xFFF9, 0xFFF5,
    0xFFF3, 0x002C, 0x0019, 0xFFFB, 0x002A, 0xFFD7, 0xFFDD, 0xFFFA,
    0xFFB0, 0xFFFC, 0xFFA1, 0xFFF3, 0x0024, 0x001C, 0x0008, 0x0053,
    0xFFF0, 0xFFB3, 0xFFF9, 0xFFC7, 0x0026, 0xFFF2, 0xFFE5, 0x0005,
    0x0017, 0xFFF1, 0xFFD8, 0x001B, 0xFFFD, 0x0030, 0x001D, 0x001D,
    0xFFA6, 0xFFE1, 0x0004, 0x001B, 0x0001, 0xFFFC, 0xFFD9, 0x001C,
    0xFFD5, 0x0024, 0x000E, 0x0000, 0xFFA9, 0x0002, 0x0030, 0xFFC4,
    0xFFF2, 0xFFFE, 0xFFF2, 0x0002, 0x000A, 0x0037, 0xFFF9, 0x0014,
    0x0001, 0x002B, 0x0010, 0x001F, 0xFFFD, 0xFFB1, 0xFFDA, 0xFFD6,
    0xFFF1, 0x0051, 0xFFFC, 0xFFC4, 0x000A, 0x0004, 0x000C, 0x001A,
    0x001A, 0xFFF9, 0xFFFC, 0xFFE5, 0x0028, 0x000C, 0xFFE0, 0x002B,
    0xFFD8, 0x0012, 0x000C, 0x0025, 0x0003, 0x0021, 0x0011, 0xFFF1,
    0x0008, 0xFFE5, 0x0034, 0x000F, 0xFFF9, 0x0047, 0xFFE7, 0x000C,
    0x0021, 0xFFE5, 0xFFC7, 0xFFD3, 0xFFEC, 0x0028, 0x0019, 0x0031,
    0x0011, 0x0001, 0x0035, 0xFFD4, 0xFFE8, 0x0046, 0x001B, 0xFFF9,
    0xFFBD, 0xFFC5, 0xFFFB, 0x000A, 0x0026, 0xFFC6, 0xFFE0, 0x000B,
    0x0018, 0xFFDF, 0xFFF8, 0x002A, 0x0009, 0x0004, 0x0023, 0xFFC6,
    0xFFD5, 0x0002, 0x0019, 0xFFB9, 0xFFD7, 0x0025, 0xFFDD, 0x0018,
    0x001F, 0xFFE1, 0x0005, 0xFFF4, 0xFFE3, 0x0014, 0xFFF1, 0xFFFB,
    0xFFFE, 0xFFCC, 0x004A, 0x001B, 0x0004, 0x0007, 0x001C, 0xFFE8,
    0x0011, 0x0061, 0x000B, 0x000A, 0x0025, 0x001F, 0x001E, 0x0013,
    0xFF8C
    };

static const q15_t in_rfft_noisy_2048[2048] = {
    0x0252, 0x3EC1, 0x5C48, 0x3855, 0x0343, 0xCAC3, 0xA705, 0xC378,
    0x0773, 0x4097, 0x57A9, 0x3B66, 0xFE72, 0xBB8A, 0xA25B, 0xC6D9,
    0xFFF7, 0x3D33, 0x5547, 0x421C, 0xF9C1, 0xCCBA, 0xACD8, 0xBC55,
    0xFD97, 0x41B6, 0x55F4, 0x47D0, 0x004A, 0xBB4B, 0xA7D9, 0xB4E3,
    0x020B, 0x4010, 0x59D6, 0x3F15, 0x0BEF, 0xBF64, 0xA213, 0xBD77,
    0xFA2B, 0x41B2, 0x50FF, 0x4386, 0xF964, 0xC30E, 0xA551, 0xC7F6,
    0x0224, 0x4DCB, 0x5F91, 0x37A0, 0x03D9, 0xBD7F, 0xA272, 0xC0C7,
    0xF46B, 0x43A5, 0x533A, 0x4CE4, 0x0B9E, 0xC0B0, 0xA649, 0xCAAF,
    0xFEAE, 0x4378, 0x5432, 0x4706, 0xF90A, 0xC814, 0xAD4C, 0xB5AA,
    0x05A9, 0x3559, 0x5A05, 0x38F2, 0xEF55, 0xC219, 0xA443, 0xC488,
    0xFC46, 0x39CF, 0x59EF, 0x3301, 0x072E, 0xC358, 0xAC8E, 0xC370,
    0x04B0, 0x3D76, 0x5EEC, 0x4139, 0x0ABE, 0xB83B, 0xAAC7, 0xC189,
    0x0143, 0x3B7F, 0x5FDE, 0x30B5, 0xFAE7, 0xC199, 0xA812, 0xB7DB,
    0x0A66, 0x4325, 0x5239, 0x44FB, 0x048F, 0xC50A, 0xA555, 0xC71B,
    0xFE64, 0x463F, 0x590C, 0x4B6F, 0x01FB, 0xC38C, 0x9F13, 0xC441,
    0xFD93, 0x3BF6, 0x6616, 0x3F8B, 0x0013, 0xBC93, 0xA37D, 0xC057,
    0xFEAC, 0x3B72, 0x5596, 0x472F, 0x02C2, 0xC659, 0x9FBF, 0xC3D6,
    0xEAFC, 0x3D7F, 0x6120, 0x41E5, 0x059F, 0xB376, 0xA026, 0xB7E7,
    0xFB14, 0x32BC, 0x5261, 0x4430, 0x0320, 0xBA37, 0xA9E3, 0xC619,
    0xFF5F, 0x4822, 0x586D, 0x43AF, 0xFB5A, 0xC7A5, 0xA5B7, 0xBBFF,
    0xFC72, 0x3060, 0x547F, 0x35FE, 0x0A25, 0xC5D2, 0xB038, 0xB7BF,
    0xF6FC, 0x3DC3, 0x55FE, 0x3AD7, 0xFCB2, 0xB6D9, 0xAC6B, 0xC048,
    0xFDEF, 0x35C8, 0x596E, 0x39B9, 0x0F66, 0xBE99, 0xA97E, 0xC1A9,
    0xFEA3, 0x3C1F, 0x58B7, 0x45BB, 0xFF64, 0xB9DF, 0xB587, 0xB989,
    0xF945, 0x47E8, 0x4F76, 0x412D, 0xFEFD, 0xC083, 0xB0E5, 0xB6F0,
    0xF93D, 0x4540, 0x5850, 0x3B0A, 0x0E00, 0xBE48, 0xA731, 0xBDE3,
    0xFCF6, 0x330E, 0x567A, 0x399A, 0x0641, 0xBC06, 0x9DF6, 0xC793,
    0xFE1D, 0x31BC, 0x5D4F, 0x49F2, 0xFECF, 0xC438, 0xA308, 0xB824,
    0xF498, 0x3D1E, 0x5606, 0x417F, 0x021F, 0xC4C4, 0xAE66, 0xC9B5,
    0x05C5, 0x364F, 0x4CBC, 0x4A40, 0x0696, 0xC332, 0xA82B, 0xC126,
    0x0151, 0x39C5, 0x5360, 0x43EF, 0xFFB0, 0xC2AE, 0xA1C9, 0xB5EC,
    0xF972, 0x2EC8, 0x5490, 0x4380, 0xFF12, 0xBEB5, 0x9FC4, 0xC64A,
    0xFB08, 0x3ABE, 0x521E, 0x46E9, 0xFAB7, 0xB75A, 0xA0EF, 0xBF0A,
    0xFE04, 0x3A41, 0x4C22, 0x4488, 0x0402, 0xC34F, 0xA05A, 0xB986,
    0x03B1, 0x3CE5, 0x549A, 0x3848, 0xF6E4, 0xBFF3, 0x99A1, 0xC7DD,
    0x01D3, 0x3EAA, 0x607E, 0x4D9C, 0xFAC9, 0xC544, 0xA356, 0xC685,
    0x061C, 0x3E6E, 0x6153, 0x427B, 0xFCC9, 0xC176, 0xA189, 0xAD1B,
    0xFFF4, 0x47A9, 0x4BD9, 0x3B9D, 0x0951, 0xBF25, 0xA5B4, 0xC031,
    0x0516, 0x495A, 0x59BD, 0x46EC, 0xFC87, 0xC82E, 0xAD7F, 0xB95D,
    0x0254, 0x42E0, 0x605A, 0x3D21, 0x0906, 0xC542, 0xAD6B, 0xC19C,
    0xFF50, 0x3F35, 0x59F4, 0x380D, 0x0015, 0xBC78, 0xA392, 0xC6A8,
    0xFDAC, 0x4F69, 0x525B, 0x431B, 0xFD0D, 0xC2CC, 0xA277, 0xB8FA,
    0x00F6, 0x3D15, 0x543F, 0x3C70, 0xF574, 0xB32E, 0xA76E, 0xBA19,
    0x0312, 0x3151, 0x5F77, 0x447A, 0xFF32, 0xC4EA, 0xA175, 0xC1FA,
    0x0558, 0x3C7C, 0x65BB, 0x3AD7, 0x06F6, 0xC3D1, 0xAF1E, 0xBBA4,
    0xF860, 0x47E4, 0x5AE0, 0x3E9F, 0xFC99, 0xB9A9, 0xA41F, 0xCF55,
    0xF109, 0x3330, 0x6AB9, 0x46DB, 0x0817, 0xBEC1, 0xA923, 0xB9A7,
    0x0898, 0x3A4D, 0x5BC2, 0x3A39, 0xF568, 0xC4D1, 0xA2EF, 0xBEE8,
    0xFE6D, 0x2C54, 0x5BA4, 0x377A, 0x0DA2, 0xBD54, 0xAA6F, 0xB3A9,
    0x070E, 0x4145, 0x55E3, 0x39A3, 0x0191, 0xB561, 0x9EDC, 0xC95E,
    0x045D, 0x3E4E, 0x55AF, 0x405C, 0x053C, 0xBFE4, 0xAD87, 0xBE30,
    0x0ED6, 0x424B, 0x5B97, 0x4209, 0x076F, 0xC3E4, 0xA2A3, 0xB8FE,
    0x0051, 0x4540, 0x591B, 0x386F, 0x0109, 0xB97F, 0xA787, 0xBFB6,
    0xFF2E, 0x3C6A, 0x5EA2, 0x42E9, 0xF263, 0xC0D3, 0xAB14, 0xC081,
    0x05F3, 0x3E4B, 0x5D98, 0x3934, 0x01D9, 0xB83C, 0xAFC2, 0xBAD7,
    0x028E, 0x3617, 0x4E76, 0x371E, 0x01E9, 0xB916, 0xA208, 0xB750,
    0x061D, 0x45D5, 0x5676, 0x38EC, 0x00CD, 0xCB2F, 0xA48D, 0xBCB3,
    0xFF91, 0x38E7, 0x5880, 0x38D5, 0xF727, 0xB531, 0xA6A5, 0xC930,
    0xF9DC, 0x2FE7, 0x5602, 0x378E, 0x0689, 0xC180, 0xAA4C, 0xC15C,
    0x04EB, 0x3E23, 0x5837, 0x4451, 0x07AE, 0xBDB3, 0x994C, 0xCA63,
    0x0712, 0x370A, 0x5162, 0x4294, 0xF8D7, 0xC65C, 0xA5C4, 0xBB85,
    0xFEED, 0x3C20, 0x5356, 0x4364, 0xFF42, 0xC20F, 0xA7F1, 0xC4F1,
    0xFD28, 0x4B86, 0x55A3, 0x377E, 0x0D1C, 0xC226, 0xA2CF, 0xC057,
    0x0564, 0x468B, 0x58B8, 0x47E3, 0x05EE, 0xC7A7, 0xA70E, 0xC6E6,
    0xFCB2, 0x46A1, 0x46F7, 0x3AF7, 0xF9F8, 0xB767, 0xA348, 0xB89C,
    0xF95D, 0x37FA, 0x5DEA, 0x3A3D, 0xF662, 0xBF6F, 0xAA8B, 0xBE29,
    0xFAF9, 0x4735, 0x5320, 0x3D30, 0x016F, 0xD00F, 0xA780, 0xC12F,
    0xFEA7, 0x35EC, 0x6050, 0x3F3D, 0x045F, 0xB94C, 0xA3ED, 0xB84E,
    0xFD56, 0x3C00, 0x5034, 0x46C2, 0xF93A, 0xD1B8, 0x9EF9, 0xC14E,
    0xFD45, 0x382D, 0x63E3, 0x43F3, 0xFCAA, 0xBA76, 0xA053, 0xC30B,
    0x0307, 0x398B, 0x52D9, 0x3CA2, 0xF795, 0xB180, 0xAA4F, 0xC3BF,
    0xFD16, 0x3CEA, 0x5059, 0x368D, 0x00B5, 0xB031, 0xAE3C, 0xBE94,
    0x0178, 0x4375, 0x59D4, 0x3A35, 0xFDEF, 0xC32F, 0xA7C1, 0xBCCC,
    0x0061, 0x3E4A, 0x5935, 0x377C, 0xF8FF, 0xB8A1, 0xA3F3, 0xB996,
    0xFC33, 0x3DD8, 0x52B8, 0x4023, 0x09C4, 0xAC46, 0x9F5A, 0xC215,
    0xFBA9, 0x4D1A, 0x6836, 0x3DE6, 0xFE1A, 0xC6BF, 0xA610, 0xCE5A,
    0x0904, 0x41A6, 0x56AD, 0x3FBD, 0x026B, 0xC6F9, 0xB0B6, 0xBE2E,
    0x08D6, 0x42CB, 0x5906, 0x46A2, 0xFF22, 0xB642, 0xA413, 0xB7F7,
    0x06D4, 0x42B9, 0x56AD, 0x44D7, 0xF11C, 0xBA23, 0xA4B6, 0xC70B,
    0x0476, 0x3E7A, 0x5AD3, 0x30E1, 0x02AF, 0xC6F0, 0xA4C7, 0xBAAB,
    0x0058, 0x427C, 0x56B7, 0x3CF8, 0xFE7E, 0xBBF3, 0xA116, 0xCE53,
    0xFE13, 0x3DA5, 0x543D, 0x4A14, 0xFE7E, 0xC330, 0x9A66, 0xC90A,
    0xFCD2, 0x40B7, 0x54D0, 0x35FB, 0xF393, 0xBDCE, 0xA384, 0xC8F3,
    0xFB4F, 0x4459, 0x4F65, 0x3874, 0x01C0, 0xBED2, 0x9F92, 0xC8B5,
    0xFD5F, 0x43E7, 0x5662, 0x3E35, 0x011C, 0xBDD5, 0xAB9B, 0xBC39,
    0x05B3, 0x3AAD, 0x4A69, 0x3E15, 0x0304, 0xC04A, 0x9F69, 0xBD77,
    0xF830, 0x3923, 0x5A63, 0x47C7, 0xFCE8, 0xB8F9, 0xA195, 0xC1F0,
    0x09BE, 0x3E91, 0x5CC2, 0x4019, 0xFDC5, 0xC3B4, 0xA61A, 0xCD3C,
    0x0023, 0x433C, 0x52D7, 0x390A, 0xF254, 0xBB82, 0x9F85, 0xC240,
    0xF39F, 0x3BD0, 0x5CEC, 0x4C20, 0xFE0E, 0xC08F, 0xA697, 0xC52A,
    0xFA03, 0x380F, 0x5BEB, 0x4109, 0x059C, 0xC695, 0xA5DD, 0xB814,
    0x013A, 0x35AB, 0x5719, 0x45D7, 0xF81B, 0xBC39, 0xAB2D, 0xBAFE,
    0x04AC, 0x40A6, 0x5F76, 0x3E35, 0x0137, 0xBAE8, 0xA032, 0xC2D9,
    0xFC8B, 0x40A6, 0x5BC9, 0x4026, 0xFD2E, 0xC32F, 0xA89E, 0xC1B0,
    0x0BB9, 0x4544, 0x583B, 0x3F1E, 0xFE69, 0xC237, 0xAF31, 0xBDAB,
    0x03D4, 0x3FCA, 0x5DA8, 0x4289, 0x0558, 0xBF15, 0x982C, 0xC57D,
    0x0A5C, 0x36B0, 0x580D, 0x3E88, 0xFF2C, 0xC419, 0xABBE, 0xBCCD,
    0xFE7C, 0x4380, 0x55FA, 0x3F84, 0x0AB5, 0xC0AC, 0xAAB2, 0xC319,
    0x0020, 0x40F7, 0x564D, 0x3280, 0xFBB9, 0xBBBC, 0x9F2D, 0xC2FE,
    0xFE5F, 0x477A, 0x4D3E, 0x3FE3, 0x003E, 0xC740, 0xA301, 0xBB85,
    0x06DC, 0x3960, 0x56A9, 0x39E6, 0xF611, 0xC7FA, 0xAE43, 0xBE49,
    0xFAEA, 0x3D06, 0x5910, 0x4CCA, 0x081B, 0xC643, 0xB3D0, 0xB7EE,
    0xF886, 0x3CFF, 0x56A0, 0x3663, 0x0176, 0xBD02, 0xA9EB, 0xC07A,
    0x0130, 0x3FD2, 0x5EE4, 0x39E5, 0xFCC9, 0xC18B, 0xA4EF, 0xBF72,
    0xF8FF, 0x4331, 0x56F1, 0x3351, 0x0643, 0xBDF2, 0xA39B, 0xB805,
    0xF3EC, 0x4169, 0x5236, 0x4010, 0x046B, 0xC1FB, 0xA389, 0xC256,
    0x0383, 0x4C4A, 0x5951, 0x45F9, 0x0177, 0xBF6B, 0xA7E9, 0xBC98,
    0x0448, 0x3F60, 0x60EF, 0x3A23, 0x0341, 0xBFA4, 0x9947, 0xBB6B,
    0x0EFE, 0x3A4D, 0x5239, 0x34E6, 0x081B, 0xBD26, 0x9B83, 0xC18F,
    0xFA7E, 0x3B6F, 0x589D, 0x383B, 0xFF5B, 0xB5D4, 0xA24C, 0xBEAD,
    0x019D, 0x3EF7, 0x5DB0, 0x3CE9, 0xFC8B, 0xB9CF, 0xAD2D, 0xB9CA,
    0xEF9C, 0x457F, 0x6580, 0x3FDD, 0xFE3C, 0xC893, 0xB181, 0xBD9E,
    0x0A8D, 0x3BD9, 0x5AC3, 0x4687, 0x07C4, 0xC2BF, 0x9D6D, 0xC7BB,
    0x001E, 0x4434, 0x6028, 0x4593, 0xF554, 0xBC3F, 0xA5BC, 0xBDAD,
    0xF8F1, 0x3832, 0x5FC1, 0x420E, 0xFBA9, 0xB16F, 0xA0C2, 0xCA46,
    0xF864, 0x4252, 0x4C5D, 0x381F, 0xFE17, 0xC5AC, 0x9699, 0xC75E,
    0xFFD9, 0x4161, 0x4F89, 0x3DCE, 0xF703, 0xB8BB, 0xB3E0, 0xCC36,
    0x0B77, 0x4121, 0x5D39, 0x431D, 0xFF01, 0xC729, 0x9911, 0xC727,
    0xFBDB, 0x4AF5, 0x5DF1, 0x446B, 0xF772, 0xB8C8, 0xA237, 0xC24C,
    0x1247, 0x415B, 0x5631, 0x3AC7, 0x00FA, 0xCD4D, 0x9CA9, 0xBC09,
    0x02A0, 0x47E0, 0x52C1, 0x38D7, 0xFC76, 0xC3FC, 0x9F90, 0xC4F7,
    0x094C, 0x4744, 0x58A1, 0x3611, 0xFFD3, 0xC420, 0xA9DB, 0xC2DE,
    0xFDF0, 0x321F, 0x578F, 0x4645, 0xFF97, 0xBDE0, 0xA930, 0xBC78,
    0x0D9F, 0x4950, 0x5BAB, 0x4466, 0x0168, 0xC904, 0xA8F0, 0xCB71,
    0x0723, 0x49EC, 0x5B4C, 0x36AA, 0x1129, 0xBA5C, 0xAB63, 0xC09C,
    0xFD88, 0x426D, 0x5FC7, 0x3EE1, 0xFCC6, 0xBECA, 0xA3B7, 0xC417,
    0xFA9C, 0x3DDA, 0x5C2D, 0x3A4C, 0xFC59, 0xBE5B, 0xA8DC, 0xC3B7,
    0x00F5, 0x3D3E, 0x57B1, 0x3B6C, 0x052A, 0xC474, 0xA5ED, 0xCE33,
    0xF704, 0x42EB, 0x579A, 0x3CAD, 0xF461, 0xC5AA, 0xA343, 0xC045,
    0x0733, 0x37E6, 0x5872, 0x39F2, 0x0022, 0xBF48, 0x9C62, 0xC604,
    0xFD3A, 0x388A, 0x6550, 0x43CB, 0x0AB6, 0xBCA4, 0xA857, 0xBD21,
    0xEE95, 0x4038, 0x5037, 0x359B, 0x0EF8, 0xBFD9, 0xA67A, 0xC650,
    0xFC62, 0x3E98, 0x5C39, 0x4180, 0xFDB9, 0xBAB0, 0xA9AF, 0xC759,
    0xFE20, 0x426E, 0x4DA2, 0x4D72, 0xF2F8, 0xBFEF, 0xA962, 0xC1B3,
    0x0E59, 0x3D00, 0x6389, 0x3BFF, 0xF773, 0xC3B8, 0xA619, 0xBE36,
    0xFD0D, 0x4A21, 0x5E5D, 0x41F5, 0x0C14, 0xC44A, 0xA8A1, 0xC214,
    0xF41B, 0x42DE, 0x5158, 0x3D8C, 0xFFE5, 0xBE3D, 0xACF9, 0xBB42,
    0xFD71, 0x3FCB, 0x4B68, 0x36FE, 0xFA9D, 0xC5A5, 0x971C, 0xB78B,
    0x09DE, 0x4196, 0x553E, 0x403E, 0x0333, 0xC954, 0xA720, 0xBCAA,
    0xFA59, 0x3909, 0x510D, 0x3E36, 0xF8E9, 0xB9DA, 0xA1D3, 0xC1AD,
    0xFDD7, 0x3643, 0x5FA1, 0x4A35, 0xFA97, 0xBEBE, 0xA3FF, 0xC367,
    0xFE97, 0x4179, 0x60B7, 0x44EB, 0xFB3B, 0xBE65, 0xA885, 0xBD13,
    0xFE8B, 0x369E, 0x5C02, 0x451D, 0xFBD5, 0xB9C0, 0xB025, 0xC338,
    0xFCFA, 0x3EFA, 0x5961, 0x3EA6, 0xFA4A, 0xB93B, 0xA5CF, 0xC4AA,
    0xFD9B, 0x35E9, 0x5AC7, 0x49E4, 0x07FB, 0xC28F, 0xA5CB, 0xC4D9,
    0x08F2, 0x3F77, 0x57FC, 0x3DF0, 0xFD4F, 0xB75E, 0xA4C8, 0xC68E,
    0xF912, 0x4331, 0x5D40, 0x376F, 0x038E, 0xC724, 0xAA77, 0xB871,
    0xFE63, 0x441E, 0x65D5, 0x50FF, 0xFCEA, 0xBBDD, 0xA35F, 0xB422,
    0xFBBA, 0x4B81, 0x548D, 0x47E0, 0x01ED, 0xC7BF, 0xA71B, 0xBCC9,
    0x05B7, 0x3C9E, 0x5AB2, 0x3A79, 0x0877, 0xAD36, 0xAA2E, 0xC592,
    0xF663, 0x3465, 0x5258, 0x4B9D, 0x02D9, 0xC2E3, 0xA9BE, 0xC520,
    0xFB72, 0x491A, 0x562B, 0x3B2C, 0xFAF2, 0xB76C, 0xA8E1, 0xC3E3,
    0xFC95, 0x39FE, 0x663F, 0x44BC, 0xFC79, 0xB85C, 0x9BA9, 0xC167,
    0xFC04, 0x3BDB, 0x5E1D, 0x42D5, 0x001B, 0xC37C, 0xA42F, 0xBE08,
    0x0A99, 0x4390, 0x4CDC, 0x3B27, 0x0121, 0xBE36, 0xAAB4, 0xBA3E,
    0xFF78, 0x3EE9, 0x5FAF, 0x4032, 0xF516, 0xBE23, 0xA709, 0xC278,
    0x0AF5, 0x3F21, 0x6120, 0x495E, 0x03F2, 0xC4B3, 0xA6C1, 0xCE64,
    0x00A3, 0x479E, 0x5AFE, 0x3E3C, 0x02BB, 0xCABC, 0xA433, 0xC907,
    0x05FB, 0x4446, 0x5A15, 0x37CE, 0xF8EC, 0xBCC5, 0xA138, 0xB8F8,
    0xF93D, 0x44FE, 0x5501, 0x45D8, 0x0407, 0xC384, 0xB075, 0xC8A4,
    0x0223, 0x3EFF, 0x5927, 0x36E6, 0x07D2, 0xBD5B, 0x9F6B, 0xBFD8,
    0xFC5E, 0x3DD2, 0x5AB6, 0x45E0, 0x0275, 0xBDFB, 0xA4C1, 0xC6B1,
    0xF9EF, 0x3D98, 0x4990, 0x4118, 0xF920, 0xC08A, 0xA909, 0xBB55,
    0x07B9, 0x3C05, 0x6378, 0x4007, 0xF97D, 0xC8B2, 0xA27F, 0xC60A,
    0xFAD3, 0x3BCD, 0x64D7, 0x3A06, 0x02F5, 0xB8E1, 0xA31D, 0xC622,
    0xFDF2, 0x3751, 0x5A04, 0x4192, 0xF755, 0xBF7E, 0xA114, 0xB791,
    0x02EE, 0x3E27, 0x5C26, 0x4606, 0xFF8F, 0xC4B4, 0xAB0B, 0xC246,
    0x002E, 0x3713, 0x5EEA, 0x39FA, 0x044B, 0xC179, 0xA970, 0xBB30,
    0xF842, 0x407E, 0x593E, 0x3AD8, 0x0E98, 0xC5C5, 0xA962, 0xC7C7,
    0xFE94, 0x4468, 0x58B5, 0x3AD7, 0x0513, 0xB783, 0x9E99, 0xB9E0,
    0xF8EF, 0x38A0, 0x6416, 0x422C, 0xFB96, 0xC6A4, 0xA815, 0xBB8E,
    0xFDE8, 0x4679, 0x6A08, 0x3C7B, 0xFBDD, 0xC3B7, 0xB39A, 0xC565,
    0xFFFD, 0x41E6, 0x5AB5, 0x42DD, 0x030C, 0xBA82, 0xA43A, 0xC65C,
    0xF75F, 0x41C7, 0x5947, 0x4768, 0xF4A0, 0xBF0F, 0xA83B, 0xC2FC,
    0xFE31, 0x3B59, 0x686C, 0x3F17, 0x0D02, 0xBC0C, 0xACD7, 0xC581,
    0xFAE0, 0x3CA2, 0x59DB, 0x389E, 0x0269, 0xC950, 0xA15C, 0xC44B,
    0xFA40, 0x3E23, 0x588E, 0x40EB, 0xFD06, 0xBFAD, 0xA427, 0xBCCF,
    0xFEE2, 0x3F9E, 0x5BF2, 0x3CC7, 0xF88D, 0xB911, 0xA5DB, 0xB71B,
    0x0643, 0x42F2, 0x59C2, 0x4618, 0xFE9C, 0xC669, 0xA276, 0xBF72,
    0xFAAC, 0x3A93, 0x5492, 0x386C, 0x0F72, 0xC209, 0x9EA9, 0xC7B8,
    0x0676, 0x3CA0, 0x5837, 0x4114, 0xFEFA, 0xB8FE, 0x9D8A, 0xBE35,
    0x06BF, 0x3D06, 0x631D, 0x4856, 0x0519, 0xBBB3, 0x9BE6, 0xAFC0,
    0x01DE, 0x3AC0, 0x5ECA, 0x4039, 0xFC6A, 0xB348, 0xB1CB, 0xBE53,
    0x0158, 0x4409, 0x5340, 0x42F4, 0x01FA, 0xC9F5, 0xA9A5, 0xB508,
    0xFFAB, 0x431D, 0x590F, 0x4D83, 0x0201, 0xCD50, 0xA547, 0xBD33,
    0xFFEA, 0x3BC2, 0x54A8, 0x39DE, 0xF8AE, 0xC0B0, 0xAC2D, 0xC16E,
    0x0562, 0x4103, 0x58EB, 0x3F3E, 0xF78C, 0xBF14, 0xA693, 0xB13A,
    0xF941, 0x3541, 0x5BF8, 0x4158, 0x01FC, 0xB4E0, 0xAC27, 0xC088,
    0x0CD3, 0x412B, 0x58E8, 0x4FF6, 0xFED5, 0xC1BA, 0xA049, 0xC7F5,
    0x03D0, 0x49E8, 0x5403, 0x3DD2, 0x0529, 0xBCAE, 0x9F49, 0xCB10,
    0xFE65, 0x4536, 0x5690, 0x368B, 0x012F, 0xC292, 0xAACC, 0xC214,
    0xFED7, 0x3B46, 0x5386, 0x37E3, 0x03FB, 0xC571, 0xB21C, 0xC22B,
    0x04B8, 0x45CB, 0x4C04, 0x4414, 0xFEE4, 0xC323, 0xA67D, 0xBDAF,
    0xFE5B, 0x3928, 0x49F9, 0x4982, 0x076F, 0xC0E0, 0xA592, 0xC8B2,
    0xFAF4, 0x36F9, 0x5DFD, 0x3DE1, 0xF957, 0xB23F, 0xA29C, 0xC2B7,
    0xFA84, 0x409B, 0x5FEA, 0x3D8E, 0xFD1A, 0xB590, 0xA7BE, 0xBA4D,
    0x0BF4, 0x38DE, 0x5A62, 0x3F24, 0xFE5A, 0xBF2B, 0xA423, 0xC263,
    0xFD86, 0x4ADE, 0x536D, 0x3D0B, 0xF5A4, 0xBDA7, 0x9C74, 0xC4EC,
    0x0214, 0x3D08, 0x5C51, 0x3F44, 0xFF84, 0xBF5E, 0xA4B8, 0xC7C9,
    0x07CF, 0x3F2A, 0x53C3, 0x4132, 0x08F3, 0xBDB8, 0xA23D, 0xB919,
    0x02E4, 0x407D, 0x5114, 0x4226, 0xF973, 0xB6C1, 0xAF58, 0xBC90,
    0x0369, 0x4525, 0x5BFA, 0x3D7E, 0x01B2, 0xC3EB, 0xA852, 0xC324,
    0x0100, 0x3E8A, 0x65AA, 0x40DE, 0x0447, 0xC143, 0xA994, 0xB20F,
    0xFBBB, 0x38DE, 0x6743, 0x4205, 0xFFD6, 0xB803, 0x9E4F, 0xBF4E,
    0x0445, 0x3DFC, 0x5B67, 0x3E38, 0x032A, 0xC459, 0xA3DD, 0xC6B8,
    0x0A74, 0x4056, 0x5E61, 0x36A9, 0x006B, 0xCDF3, 0x9E1D, 0xC19F,
    0x0573, 0x49C7, 0x5FAF, 0x4548, 0x0926, 0xBB3E, 0x9F55, 0xC131,
    0xFEDD, 0x441B, 0x514F, 0x3A2D, 0x054F, 0xB456, 0xABB8, 0xB79A,
    0x021B, 0x3E55, 0x5805, 0x46D8, 0x01B5, 0xC8DB, 0xA7E7, 0xBFA8,
    0x002A, 0x3B8E, 0x5415, 0x45D0, 0x0708, 0xBA56, 0xACCF, 0xC391,
    0xFA98, 0x38FA, 0x5CAC, 0x40FE, 0xF09D, 0xCAEE, 0xAC8B, 0xBDF6,
    0xFF8B, 0x459B, 0x58A2, 0x377A, 0x0696, 0xC173, 0x94DD, 0xC1BB,
    0x0309, 0x3FD8, 0x5254, 0x3815, 0xFB74, 0xB890, 0xA542, 0xBE9E,
    0x0071, 0x42A3, 0x5FF5, 0x4612, 0x061B, 0xC494, 0xAD30, 0xBF7D,
    0x0D56, 0x386B, 0x5D57, 0x4114, 0x0318, 0xC976, 0xB0EF, 0xB592,
    0x0890, 0x3852, 0x5DB6, 0x4315, 0x02B7, 0xCA75, 0xA821, 0xC3DF,
    0xFB18, 0x4CFD, 0x5F26, 0x440A, 0xFD84, 0xB80A, 0xAEB6, 0xBD64,
    0xF8DD, 0x3D12, 0x594D, 0x3C8D, 0xF76F, 0xC038, 0xA2B6, 0xC535,
    0xFA85, 0x41DB, 0x56B9, 0x3B3E, 0xFEE0, 0xC302, 0xADFA, 0xC0C5,
    0x0419, 0x395A, 0x58B8, 0x3BEE, 0x04E2, 0xCE1F, 0xA410, 0xB881,
    0xFADA, 0x3998, 0x5D2E, 0x4069, 0xF7C5, 0xB6F3, 0xAC2E, 0xC1A6,
    0x0577, 0x4214, 0x6409, 0x4CCE, 0xF635, 0xC667, 0xA5C3, 0xC51E,
    0xF94F, 0x48C6, 0x52E9, 0x4E7D, 0xFA0E, 0xCA08, 0xAB13, 0xB9C4,
    0xFA24, 0x3FEE, 0x532B, 0x3A61, 0xFB96, 0xBF2D, 0xA910, 0xC4B1,
    0xF4A6, 0x323A, 0x56EF, 0x3FBF, 0xF963, 0xC33B, 0xA8AB, 0xB72E,
    0x04BA, 0x39BA, 0x54C1, 0x39A4, 0xFB61, 0xC19D, 0xA780, 0xC455,
    0xFF47, 0x34EB, 0x5E27, 0x4CFF, 0x0194, 0xBD7E, 0xA6A9, 0xBC22,
    0xFD4A, 0x4316, 0x5C1B, 0x399A, 0x0078, 0xC1D1, 0xA6DB, 0xC91F,
    0xF8FA, 0x3796, 0x55C6, 0x31F0, 0x0662, 0xBA4B, 0xA7A1, 0xC082,
    0xFD11, 0x41F0, 0x5F18, 0x3835, 0x056F, 0xC460, 0xB5F9, 0xB993,
    0x0CFA, 0x4A64, 0x65B9, 0x301C, 0xF7D2, 0xBE8C, 0x9EB1, 0xC0F3,
    0x0924, 0x42CB, 0x54DB, 0x468E, 0x0629, 0xBE4D, 0x9DC8, 0xB900,
    0x0C43, 0x3AD0, 0x5F1E, 0x4122, 0x035A, 0xC6DB, 0xA29B, 0xC0F2,
    0x0DB5, 0x3DDE, 0x4F47, 0x3888, 0xF96C, 0xC4BC, 0xAAD5, 0xC6E5,
    0xFE87, 0x41B5, 0x5F27, 0x3607, 0xF880, 0xBAAE, 0xB08F, 0xC0FF,
    0x0192, 0x4116, 0x5E9B, 0x3C85, 0xF919, 0xBA8A, 0xA62A, 0xC3B4,
    0xF7B3, 0x41E5, 0x5FF2, 0x35EE, 0xF436, 0xBE98, 0x9D62, 0xC570,
    0x0092, 0x35C6, 0x5B4E, 0x3F8C, 0xFE2A, 0xC2E9, 0x9D89, 0xC4EC,
    0xFE8A, 0x3EF6, 0x531C, 0x3F45, 0x01BC, 0xBD7A, 0xA6C2, 0xCA09,
    0xFE66, 0x433F, 0x5D23, 0x3E87, 0xF338, 0xB767, 0xA5C6, 0xC14A,
    0xF486, 0x3708, 0x5724, 0x45D1, 0xF712, 0xC030, 0xAB3F, 0xBE63,
    0xFD79, 0x40AD, 0x573D, 0x4136, 0x0A75, 0xC4A1, 0xA37A, 0xC3EC,
    0x00BB, 0x4969, 0x5469, 0x3345, 0xFEF8, 0xBFEF, 0xAB2C, 0xB432,
    0xFD81, 0x44AB, 0x5AC7, 0x3A60, 0x00D5, 0xB817, 0xA06B, 0xBE8F,
    0x0A2B, 0x49AF, 0x6361, 0x3B90, 0xF60E, 0xC2B9, 0x9ED6, 0xC204,
    0x0071, 0x3807, 0x5860, 0x3BF1, 0x07C5, 0xC0AF, 0x9F5F, 0xC300,
    0x00B2, 0x3B8A, 0x5C09, 0x3FA1, 0x02E3, 0xC49F, 0xA718, 0xBED6,
    0xF698, 0x2E2B, 0x58B1, 0x4758, 0xFB86, 0xBB2D, 0xA442, 0xC14C,
    0x03FD, 0x365E, 0x5B6C, 0x3D76, 0x0374, 0xC409, 0x9A69, 0xB39C,
    0xF9D5, 0x3ADA, 0x6243, 0x3763, 0x0319, 0xC27D, 0xAE2F, 0xC55C,
    0xFE68, 0x44F3, 0x5929, 0x2DBE, 0x00ED, 0xBEF8, 0xA85F, 0xC270,
    0xFEE0, 0x4946, 0x55AC, 0x3A24, 0x0083, 0xC5E4, 0xA9DE, 0xBED0,
    0xF771, 0x3DDD, 0x5D49, 0x3C13, 0xF0C9, 0xC1A9, 0xA35D, 0xBAFB,
    0xFAD3, 0x3A4C, 0x5E2D, 0x4326, 0xF6E5, 0xBEAF, 0xAE51, 0xC9AF,
    0x033A, 0x4A59, 0x5F57, 0x39E4, 0xFBF8, 0xD03F, 0xB2B6, 0xBC14,
    0x022A, 0x3CDD, 0x52A8, 0x39C8, 0xFCCC, 0xBF00, 0xA3D2, 0xB3E1
    };

static const q15_t in_rifft_noisy_2048[4098] = {
    0xFFB0, 0x0000, 0xFFEB, 0x0032, 0x000A, 0xFFFA, 0xFFF1, 0xFFF3,
    0xFFFB, 0xFFFA, 0x0018, 0xFFE4, 0x002B, 0xFFF8, 0xFFFC, 0xFFDF,
    0x0006, 0x0000, 0xFFE3, 0xFFD8, 0x000A, 0x000E, 0x0007, 0xFFEF,
    0x0008, 0x0016, 0x0010, 0x0008, 0xFFF3, 0xFFEA, 0xFFF1, 0x0004,
    0x0002, 0x002A, 0xFFE6, 0xFFE1, 0xFFF2, 0xFFE7, 0x0032, 0x0029,
    0x0029, 0xFFFA, 0x003C, 0xFFF0, 0xFFD4, 0xFFFE, 0x000B, 0xFFF3,
    0xFFF1, 0x001C, 0xFFFC, 0x0001, 0xFFE7, 0x001E, 0x0003, 0xFFF6,
    0xFFE9, 0xFFF8, 0xFFFB, 0x000D, 0x0006, 0xFFE3, 0x0003, 0xFFF3,
    0xFFE9, 0x004F, 0x0003, 0x001C, 0x0017, 0x000F, 0x0007, 0xFFCF,
    0x000D, 0xFFFD, 0x0014, 0xFFFD, 0x000B, 0x0003, 0x0004, 0x000E,
    0xFFF3, 0x000F, 0x0013, 0xFFEB, 0xFFDD, 0xFFCA, 0x0015, 0x0022,
    0x0023, 0xFFEB, 0x0009, 0x002A, 0x001C, 0xFFC4, 0xFFCC, 0x001D,
    0xFFE0, 0xFFE3, 0xFFDB, 0x0006, 0x002C, 0x002A, 0x0005, 0xFFFD,
    0x0004, 0x0021, 0x0011, 0xFFF5, 0xFFF8, 0xFFF5, 0xFFE3, 0xFFFE,
    0xFFEC, 0x0002, 0x0020, 0x0017, 0xFFE0, 0xFFF7, 0xFFBF, 0x0003,
    0x0012, 0x000D, 0x001A, 0x000E, 0xFFE2, 0x0034, 0xFFBF, 0x0021,
    0x0009, 0x001B, 0xFFEC, 0x0001, 0xFFF8, 0xFFD5, 0x0008, 0xFFF8,
    0x0005, 0x0008, 0xFFF8, 0xFFFA, 0x0027, 0x0020, 0xFFF8, 0xFFCC,
    0x0007, 0x0002, 0xFFF2, 0x0013, 0xFFE9, 0xFFDB, 0xFFE3, 0xFFC9,
    0x000A, 0x0032, 0x0001, 0x0001, 0xFFF3, 0x0006, 0xFFDD, 0xFFF3,
    0xFFF3, 0xFFF4, 0x0002, 0x0008, 0xFFF6, 0xFFB3, 0xFFC2, 0xFFE6,
    0xFFB9, 0x000F, 0x0039, 0xFFFA, 0xFFF5, 0x0017, 0x0004, 0xFFEA,
    0x0010, 0x000F, 0x0011, 0xFFF2, 0xFFEF, 0x0007, 0x0026, 0x0030,
    0xFFF8, 0x0022, 0xFFE6, 0xFFF5, 0x001B, 0xFFE7, 0x0007, 0xFFC0,
    0x0007, 0xFFDF, 0xFFF9, 0xFFC9, 0xFFF5, 0x0004, 0xFFF9, 0x000B,
    0x0015, 0xFFEE, 0xFFD0, 0xFFB8, 0xFFD7, 0xFFC0, 0x001B, 0x0009,
    0x0003, 0x0013, 0xFFFD, 0xFFF1, 0x0010, 0xFFD5, 0xFFE1, 0xFFFD,
    0x0017, 0xFFFE, 0x0022, 0x000B, 0xFFEE, 0x000F, 0xFFEE, 0x0004,
    0xFFF2, 0xFFEC, 0xFFF4, 0x0005, 0x000C, 0xFFDE, 0xFFE9, 0xFFFB,
    0x0004, 0xFFFE, 0xFFFF, 0xFFCC, 0xFFED, 0x001A, 0xFFE9, 0xFFDD,
    0x002A, 0x002D, 0x0004, 0xFFF8, 0x0028, 0xFFFF, 0x000A, 0xFFDA,
    0x0016, 0xFFCD, 0xFFF9, 0x0009, 0x0019, 0xFFF7, 0xFFF1, 0xFFF0,
    0x0001, 0x000B, 0x001E, 0x0011, 0xFFE2, 0x000A, 0x001F, 0xFFFA,
    0x0000, 0xFFF2, 0x0008, 0x0012, 0xFFF5, 0xFFFA, 0x0014, 0xFFFB,
    0x0026, 0x0027, 0xFFF2, 0xFFE3, 0x0008, 0xFFCA, 0xFFE0, 0x0013,
    0xFFE7, 0xFFEB, 0xFFED, 0x0038, 0xFFD2, 0xFFE8, 0xFFE8, 0xFFCB,
    0x0006, 0x000C, 0xFFD6, 0xFFEF, 0xFFF3, 0xFFE4, 0xFFF0, 0xFFFF,
    0xFFF0, 0x000A, 0x000F, 0x0012, 0xFFE8, 0xFFD1, 0xFFFA, 0x0002,
    0xFFFA, 0xFFF3, 0xFFF5, 0xFFEE, 0x000D, 0xFFDE, 0x000B, 0x0011,
    0xFFD7, 0x000E, 0x0002, 0x0011, 0xFFD7, 0x0020, 0xFFF7, 0x000F,
    0x0018, 0x0002, 0x003B, 0xFFF0, 0x0007, 0x0000, 0x0004, 0xFFF4,
    0xFFFE, 0xFFE6, 0x0026, 0x0007, 0xFFD7, 0x0046, 0x000F, 0xFFD7,
    0x0015, 0x003B, 0x0013, 0x0024, 0x0011, 0xFFF6, 0xFFD2, 0xFFF8,
    0x0023, 0x000B, 0xFFF8, 0x000A, 0xFFFD, 0xFFEE, 0x001A, 0xFFF3,
    0x000E, 0x000C, 0x000F, 0x0004, 0xFFF1, 0xFFF0, 0xFFFE, 0xFFF8,
    0xFFEA, 0xFFF7, 0x0006, 0xFFF9, 0xFFF2, 0xFFE9, 0xFFF6, 0x0017,
    0xFFE9, 0xFFCC, 0xFFFA, 0xFFF9, 0x0004, 0x0025, 0xFFE3, 0xFFD7,
    0xFFFE, 0x0011, 0xFFFC, 0xFFE5, 0xFFEB, 0xFFEB, 0xFFFB, 0xFFE1,
    0xFFE9, 0x000C, 0xFFE2, 0xFFEB, 0x0000, 0xFFFE, 0x0022, 0xFFE8,
    0xFFF0, 0x001B, 0x001F, 0xFFDC, 0x0027, 0x002F, 0x0007, 0x0017,
    0x000E, 0x0026, 0xFFE4, 0x0019, 0xFFD8, 0x0009, 0xFFC9, 0x0001,
    0x0029, 0xFFE4, 0x000D, 0xFFF3, 0x0024, 0x001E, 0xFFFB, 0xFFE1,
    0xFFFC, 0x000D, 0xFFFF, 0x000B, 0x001D, 0x000E, 0xFFDB, 0xFFF9,
    0x0028, 0x0020, 0xFFD6, 0xFFEF, 0x0024, 0xFFD6, 0x000D, 0xFFFD,
    0x000A, 0x0006, 0x000C, 0x0018, 0xFFF2, 0xFFFF, 0x0016, 0x000D,
    0x0010, 0x0015, 0x0005, 0xFFFA, 0xFFE6, 0xFFFC, 0xFFF4, 0x0029,
    0xFFDA, 0x0013, 0xFFE6, 0xFFE9, 0x000E, 0xFFE1, 0xFFF0, 0x0006,
    0xFFE3, 0xFFE8, 0xFFDF, 0x0015, 0xFFEF, 0x0014, 0x0004, 0x002A,
    0x0014, 0xFFFB, 0x000B, 0xFFEF, 0x001B, 0x0017, 0x0021, 0xFFE7,
    0x001C, 0xFFF5, 0x0012, 0xFFEA, 0x000F, 0x0000, 0x0013, 0xFFEF,
    0xFFF7, 0xFFFF, 0xFFFE, 0x0007, 0x0005, 0xFFCF, 0x0028, 0xFFF1,
    0xFFFC, 0x0009, 0xFFEE, 0x0017, 0xFFFA, 0x0011, 0x001B, 0x001C,
    0x0003, 0x003F, 0x0001, 0x002D, 0xFFF5, 0xFFDC, 0xFFF8, 0xFFE9,
    0x001A, 0xFFEF, 0x0008, 0xFFDD, 0x0004, 0xFFD2, 0xFFCE, 0x0018,
    0x0009, 0xD32B, 0xFFF9, 0x0013, 0xFFF1, 0x0040, 0xFFFF, 0x0020,
    0x0028, 0x001B, 0x000E, 0xFFFF, 0x0015, 0x001D, 0xFFEE, 0xFFAB,
    0xFFE6, 0x0026, 0xFFE8, 0xFFF6, 0x0010, 0xFFFB, 0x0017, 0xFFF5,
    0xFFE8, 0x001C, 0x0036, 0x0029, 0xFFFE, 0xFFE6, 0x0001, 0x0000,
    0xFFF5, 0x0014, 0xFFCF, 0xFFFA, 0xFFF4, 0x0017, 0x000F, 0x000E,
    0xFFF1, 0xFFFC, 0x0009, 0x0008, 0x000D, 0xFFFD, 0x0008, 0x002B,
    0x0004, 0x001A, 0xFFFB, 0xFFFF, 0x000E, 0x001E, 0x0005, 0x0006,
    0x0007, 0x0034, 0xFFF9, 0xFFE4, 0xFFFC, 0xFFE1, 0x001A, 0x0001,
    0xFFF8, 0x0033, 0xFFDC, 0xFFDF, 0xFFFA, 0xFFF2, 0xFFF8, 0x0010,
    0x001B, 0x0011, 0xFFE0, 0xFFF8, 0x000D, 0xFFDF, 0x000D, 0xFFED,
    0x0020, 0x0013, 0xFFFC, 0xFFE3, 0x0000, 0xFFF3, 0x0024, 0x0012,
    0x0008, 0xFFF4, 0xFFFA, 0xFFC4, 0x001C, 0x0027, 0x002D, 0x0005,
    0xFFE6, 0x000F, 0xFFF3, 0x0020, 0xFFEE, 0xFFFD, 0xFFEC, 0x0013,
    0x0018, 0xFFFA, 0xFFFA, 0x000E, 0x000C, 0x0009, 0x0020, 0x000E,
    0xFFDF, 0xFFF2, 0xFFCB, 0xFFFF, 0xFFFB, 0xFFDE, 0xFFEE, 0xFFD7,
    0xFFF6, 0x0004, 0xFFE3, 0x0027, 0x0012, 0xFFDB, 0xFFDB, 0xFFF7,
    0xFFEF, 0xFFFE, 0x000D, 0xFFD5, 0xFFF1, 0x0008, 0x000C, 0x0003,
    0xFFDF, 0xFFE8, 0x0004, 0xFFE4, 0xFFE1, 0x001D, 0xFFE5, 0xFFFC,
    0x0008, 0xFFDC, 0xFFE2, 0xFFE4, 0xFFED, 0x000C, 0xFFE1, 0x0001,
    0xFFE8, 0x0010, 0xFFEA, 0x000B, 0xFFE5, 0xFFE7, 0x0019, 0xFFFC,
    0x0010, 0x001D, 0x0026, 0x001D, 0x0008, 0xFFE5, 0xFFEC, 0xFFD0,
    0x0006, 0x0012, 0x000E, 0xFFF6, 0xFFD4, 0xFFE6, 0xFFFC, 0xFFD5,
    0x002E, 0xFFD8, 0xFFFB, 0xFFE5, 0xFFFE, 0x000A, 0x001A, 0x0018,
    0xFFE1, 0xFFF7, 0x0005, 0x0012, 0xFFFE, 0x000C, 0x000E, 0x000B,
    0xFFC4, 0x0013, 0x0019, 0xFFFB, 0x001E, 0xFFFC, 0xFFF4, 0xFFF4,
    0xFFE2, 0xFFE0, 0xFFFD, 0x0032, 0x0017, 0xFFED, 0xFFF2, 0x000F,
    0xFFEF, 0xFFD9, 0x0001, 0x000F, 0xFFFD, 0xFFEB, 0xFFEA, 0x0003,
    0x002A, 0xFFDF, 0x002F, 0xFFF2, 0xFFF6, 0xFFF2, 0xFFE8, 0x001D,
    0x0020, 0x0018, 0xFFC3, 0x000C, 0x0005, 0x0012, 0x0000, 0xFFDE,
    0x0003, 0x001A, 0x000C, 0x0007, 0x0025, 0x0014, 0xFFF2, 0xFFFC,
    0x000E, 0xFFFA, 0xFFF3, 0xFFD3, 0xFFD7, 0xFFF0, 0x0013, 0x0016,
    0x0008, 0x000E, 0x0038, 0xFFFA, 0xFFDF, 0x0006, 0x0013, 0x001B,
    0x002F, 0xFFFE, 0x001B, 0xFFE3, 0x0022, 0xFFF9, 0x000D, 0x0007,
    0x0018, 0xFFF0, 0x0041, 0x0011, 0xFFF3, 0xFFE0, 0x000E, 0x0026,
    0x0010, 0xFFF9, 0xFFDF, 0x0001, 0xFFC7, 0xFFF6, 0xFFEA, 0x000A,
    0x000C, 0x0008, 0xFFF5, 0xFFEA, 0x0016, 0x000C, 0x0015, 0xFFE7,
    0xFFE4, 0x0014, 0x000D, 0xFFF1, 0x0005, 0xFFF4, 0x0007, 0xFFE1,
    0xFFBE, 0xFFE3, 0x000C, 0x0009, 0x0002, 0xFFF9, 0x0027, 0xFFEF,
    0x002B, 0xFFFD, 0xFFF6, 0x000E, 0x000B, 0x0001, 0xFFEC, 0x001C,
    0x0029, 0xFFE6, 0x001D, 0xFFF0, 0x0021, 0x0016, 0xFFF7, 0x000F,
    0x0000, 0xFFFD, 0x0015, 0x000E, 0x0002, 0x0036, 0x0023, 0xFFE5,
    0xFFE5, 0x0003, 0x0004, 0xFFE9, 0x0009, 0xFFEE, 0xFFD9, 0x0016,
    0x0017, 0x0010, 0x0001, 0x0003, 0xFFF4, 0xFFEF, 0x0015, 0x000F,
    0xFFDD, 0x000A, 0xFFF2, 0x0010, 0x000A, 0x0008, 0xFFCB, 0xFFE4,
    0xFFF7, 0x001D, 0xFFC9, 0x000E, 0xFFF0, 0xFFED, 0x0000, 0xFFEE,
    0x0009, 0xFFE0, 0x0020, 0xFFF4, 0xFFE9, 0xFFD0, 0xFFF6, 0x0017,
    0xFFCE, 0x0012, 0xFFFD, 0x002A, 0x0009, 0xFFF9, 0x003B, 0x0015,
    0x0026, 0xFFD9, 0xFFF4, 0x002D, 0xFFDE, 0x0002, 0x0033, 0x001E,
    0x0010, 0xFFFF, 0xFFDC, 0xFFE9, 0x0000, 0x0021, 0xFFE5, 0xFFF0,
    0x0020, 0xFFFE, 0xFFD8, 0xFFEE, 0xFFE3, 0xFFDC, 0xFFF6, 0x0006,
    0x001F, 0xFFFB, 0x0026, 0xFFE6, 0x0033, 0x0000, 0xFFFE, 0x0007,
    0xFFEF, 0x0012, 0xFFF0, 0xFFE5, 0x0007, 0x0007, 0xFFDC, 0xFFF7,
    0xFFCF, 0x0012, 0x0012, 0xFFE2, 0x0007, 0xFFF2, 0xFFFE, 0xFFF3,
    0xFFF3, 0xFFFA, 0x0007, 0x0011, 0x0025, 0xFFE8, 0x0025, 0xFFF7,
    0xFFFC, 0xFFFB, 0xFFF9, 0xFFEB, 0xFFF9, 0x0004, 0x0011, 0xFFFB,
    0x000B, 0xFFDB, 0x002C, 0xFFD9, 0x0003, 0x0035, 0xFFEF, 0xFFEE,
    0x000F, 0xFFFE, 0x0015, 0x0013, 0x0015, 0x0018, 0xFFF9, 0x0028,
    0x0004, 0xFFF0, 0xFFE9, 0x0030, 0x0014, 0x000E, 0xFFEA, 0x001E,
    0xFFFB, 0xFFD8, 0xFFED, 0xFFF1, 0xFFE8, 0x003B, 0x0025, 0xFFCB,
    0xFFFF, 0xFFF5, 0xFFFB, 0xFFED, 0xFFD2, 0x001F, 0x0027, 0x002A,
    0x0000, 0x0041, 0x0002, 0xFFFB, 0xFFE9, 0xFFFF, 0x000E, 0xFFE8,
    0xFFC2, 0xFFDD, 0xFFEE, 0xFFFB, 0x000E, 0x0013, 0xFFFF, 0x002D,
    0x001E, 0xFFE6, 0xFFE4, 0xFFFD, 0xFFF5, 0xFFDA, 0x0014, 0xFFD9,
    0xFFF5, 0xFFF4, 0xFFF1, 0x001A, 0xFFC8, 0xFFF0, 0xFFF2, 0x000D,
    0x000B, 0x0013, 0xFFF7, 0xFFD0, 0x0007, 0xFFF3, 0xFFF2, 0xFFDE,
    0x0033, 0xFFF1, 0xFFF2, 0xFFF2, 0xFFE9, 0xFFFC, 0x0002, 0xFFE7,
    0xFFF7, 0xFFFB, 0x0000, 0xFFFA, 0x000C, 0xFFBE, 0x0002, 0xFFF7,
    0x0006, 0x0010, 0xFFFF, 0xFFE5, 0xFFE0, 0x0013, 0xFFEE, 0xFFE8,
    0x0002, 0x0009, 0x0002, 0xFFF2, 0xFFF8, 0x000B, 0x002B, 0xFFB5,
    0x000C, 0xFFDB, 0x001D, 0xFFE4, 0x0009, 0xFFE0, 0xFFF3, 0xFFFB,
    0x0035, 0x0006, 0xFFD8, 0x0018, 0x0027, 0xFFEE, 0x0008, 0x000B,
    0xFFCE, 0xFFF6, 0xFFF1, 0x001B, 0x000A, 0xFFF5, 0x0026, 0x001E,
    0xFFF6, 0xFFED, 0x0002, 0x002A, 0xFFD9, 0xFFFC, 0xFFF3, 0x0011,
    0x0020, 0xFFF3, 0x0000, 0x0008, 0xFFE8, 0xFFF7, 0xFFE0, 0xFFBE,
    0x001D, 0xFFCE, 0x0058, 0xFFE0, 0x0000, 0xFFED, 0x0017, 0xFFE3,
    0x0006, 0x0035, 0x0015, 0xFFF7, 0xFFF7, 0x0007, 0xFFEF, 0xFFF4,
    0x002D, 0x0007, 0xFFFC, 0xFFED, 0x0009, 0xFFE5, 0xFFF9, 0x0005,
    0x0010, 0xFFCA, 0x0023, 0xFFFA, 0x0006, 0x0007, 0xFFF7, 0xFFFE,
    0xFFFF, 0x0010, 0x0032, 0xFFF5, 0xFFFB, 0x0011, 0x0014, 0x0029,
    0x000D, 0xFFEA, 0x0015, 0xFFFC, 0x0001, 0xFFDC, 0xFFD8, 0xFFFF,
    0x0022, 0xFFD5, 0xFFDD, 0x002E, 0xFFE8, 0x002B, 0xFFEC, 0x0002,
    0x0026, 0x0016, 0x001A, 0xFFE4, 0x002E, 0xFFDF, 0xFFF1, 0xFFF5,
    0xFFFF, 0x0032, 0x003B, 0xFFF0, 0x0005, 0xFFE4, 0xFFEA, 0x0005,
    0x0017, 0xFFE3, 0x0019, 0x0026, 0xFFF2, 0xFFEC, 0xFFE7, 0x0010,
    0x000F, 0xFFDA, 0x0001, 0xFFDB, 0x0006, 0xFFF0, 0x0003, 0xFFF4,
    0xFFCC, 0x0002, 0xFFE6, 0xFFE6, 0xFFF4, 0x0019, 0xFFF5, 0x0015,
    0xFFE1, 0x001B, 0x001F, 0x0011, 0xFFEC, 0xFFF4, 0x0005, 0xFFD2,
    0xFFF0, 0x0000, 0x0018, 0xFFFA, 0xFFEE, 0x0037, 0xFFF8, 0x0032,
    0xFFE6, 0xFFFF, 0x0004, 0xFFE8, 0x0011, 0xFFF5, 0x000F, 0xFFF2,
    0xFFFB, 0xFFDD, 0xFFF9, 0x001B, 0xFFFC, 0x0008, 0x0029, 0xFFF0,
    0x0003, 0x001A, 0xFFEC, 0xFFEA, 0xFFC0, 0x002A, 0xFFFA, 0x0013,
    0x0019, 0xFFF0, 0x0003, 0xFFFE, 0x000E, 0x000E, 0x0009, 0x0036,
    0xFFED, 0x000B, 0x0007, 0x0008, 0xFFFB, 0x0003, 0x0028, 0x0004,
    0xFFEF, 0x000E, 0x0006, 0xFFE0, 0xFFFC, 0xFFF7, 0xFFF6, 0xFFD4,
    0xFFDA, 0x0000, 0x0003, 0x0000, 0xFFE2, 0x000F, 0x0012, 0x0017,
    0xFFF2, 0x0006, 0xFFF3, 0xFFF4, 0xFFF7, 0xFFF9, 0xFFE6, 0xFFF9,
    0x0003, 0x0038, 0xFFC5, 0x0016, 0xFFE4, 0x0013, 0xFFF2, 0xFFC3,
    0xFFFD, 0x000E, 0xFFCB, 0xFFF9, 0x0013, 0x0031, 0x001D, 0xFFFB,
    0xFFE6, 0xFFFC, 0xFFF8, 0x0007, 0xFFFE, 0x0008, 0xFFF9, 0x0009,
    0xFFDD, 0xFFE9, 0x001A, 0x000F, 0x0019, 0xFFE1, 0x0006, 0xFFF2,
    0x001D, 0x0011, 0xFFFD, 0xFFEA, 0x0008, 0x0026, 0xFFF7, 0xFFE8,
    0xFFE8, 0xFFDE, 0xFFD8, 0x0026, 0x000D, 0x000D, 0xFFF4, 0x001B,
    0xFFF1, 0x0010, 0xFFDB, 0xFFE2, 0xFFF7, 0x0020, 0x000B, 0x0010,
    0x0002, 0xFFE5, 0x0018, 0x000C, 0x0012, 0xFFEE, 0x0024, 0xFFE9,
    0x0001, 0xFFFC, 0xFFFE, 0xFFF9, 0x0003, 0x000C, 0x0002, 0xFFF5,
    0x0006, 0xFFF0, 0xFFEC, 0x0012, 0x000E, 0xFFE8, 0xFFD5, 0x0016,
    0xFFF1, 0x0005, 0x0036, 0xFFFB, 0xFFF7, 0x0007, 0x0025, 0xFFF6,
    0x0016, 0xFFF1, 0xFFEF, 0xFFC6, 0x0006, 0x001F, 0x0023, 0x0002,
    0x000A, 0x000F, 0x0000, 0xFFDB, 0xFFD9, 0x000D, 0x0024, 0x0011,
    0x0022, 0xFFDC, 0x0001, 0xFFF6, 0xFFE2, 0xFFF8, 0x0003, 0xFFE2,
    0xFFE7, 0xFFF0, 0x0010, 0x0012, 0xFFD1, 0xFFEE, 0x0002, 0xFFD3,
    0xFFFA, 0x000A, 0x0011, 0x0040, 0x0004, 0x000D, 0x000C, 0x0018,
    0x0007, 0x000F, 0x0029, 0xFFDA, 0xFFD6, 0xFFFB, 0xFFE2, 0xFFED,
    0xFFF4, 0x000A, 0x0019, 0x0005, 0xFFEF, 0xFFF9, 0xFFFE, 0x0020,
    0x001A, 0xFFF5, 0x000E, 0xFFED, 0x0000, 0x0026, 0xFFDA, 0xFFCB,
    0x0005, 0xFFDD, 0xFFF5, 0x000D, 0xFFE9, 0x0001, 0xFFE4, 0x000B,
    0x0019, 0x001D, 0xFFCC, 0x000C, 0xFFE5, 0xFFD8, 0xFFFA, 0xFFE4,
    0xFFFC, 0x002A, 0x0019, 0xFFEC, 0x001B, 0x0004, 0xFFD1, 0xFFFE,
    0xFFF1, 0xFFFE, 0xFFB3, 0x001D, 0xFFE7, 0x0004, 0xFFFF, 0xFFFF,
    0x0021, 0xFFE9, 0xFFF4, 0x0009, 0xFFFE, 0xFFFB, 0x0014, 0xFFD3,
    0xFFE9, 0xFFD7, 0x0011, 0x000B, 0x0021, 0x0038, 0xFFFF, 0x0009,
    0x0004, 0x002B, 0xFFF0, 0x0015, 0x0023, 0x000F, 0x001D, 0xFFE5,
    0xFFE3, 0x000C, 0x001E, 0xFFFC, 0x0004, 0x000F, 0x0017, 0xFFF5,
    0xFFF7, 0x0014, 0xFFEB, 0xFFF9, 0xFFFA, 0xFFFE, 0x000B, 0x0012,
    0x000C, 0x000D, 0x0027, 0xFFE2, 0x002B, 0xFFE6, 0x0014, 0xFFF5,
    0xFFDC, 0xFFF7, 0x002C, 0xFFF9, 0xFFF5, 0x0005, 0x0002, 0x0018,
    0x000C, 0xFFE2, 0x0019, 0xFFE1, 0x001D, 0x002F, 0xFFFA, 0xFFF1,
    0x0016, 0xFFFE, 0x0005, 0x0004, 0xFFFC, 0x000E, 0x0017, 0xFFF4,
    0x0003, 0xFFF8, 0x000B, 0x0007, 0xFFE1, 0x0017, 0xFFE0, 0x000B,
    0xFFD1, 0xFFFF, 0x0014, 0x0010, 0xFFF9, 0x000E, 0x0020, 0xFFDD,
    0x001C, 0xFFFE, 0x000D, 0xFFF0, 0xFFE7, 0xFFEF, 0x0003, 0xFFF6,
    0xFFCF, 0x0003, 0xFFFE, 0xFFF1, 0xFFF1, 0x000D, 0xFFFC, 0x0004,
    0xFFE6, 0x001B, 0x0010, 0xFFE7, 0x000E, 0x0010, 0x0019, 0xFFF2,
    0x000B, 0xFFEE, 0xFFD8, 0xFFE4, 0x0029, 0x000F, 0x003E, 0x000E,
    0x001A, 0xFFE8, 0x000F, 0x0017, 0x0007, 0x0036, 0xFFED, 0xFFFB,
    0x0005, 0x0000, 0x0008, 0x0016, 0x0024, 0x0008, 0xFFEB, 0xFFF5,
    0xFFFD, 0xFFEA, 0x0028, 0xFFEA, 0x0002, 0x0034, 0xFFE8, 0x0017,
    0x0010, 0xFFFB, 0xFFD1, 0xFFF8, 0x001C, 0x000E, 0x0006, 0xFFDF,
    0xFFEF, 0x000D, 0xFFF9, 0xFFFC, 0xFFFB, 0xFFF3, 0x0004, 0xFFE5,
    0xFFE6, 0x0011, 0xFFCD, 0x0034, 0xFFF6, 0x0002, 0xFFA6, 0x002C,
    0x001A, 0xFFF0, 0xFFF2, 0x000D, 0x0037, 0x0023, 0xFFE2, 0x0018,
    0x0020, 0x000C, 0x001D, 0x0011, 0x001D, 0xFFE0, 0x0001, 0xFFFE,
    0x0006, 0xFFD8, 0xFFF7, 0x0019, 0xFFCF, 0x0012, 0x0030, 0x000C,
    0x0042, 0xFF98, 0x001E, 0xFFE5, 0x0002, 0xFFF2, 0x0000, 0xFFEF,
    0x0005, 0xFFFA, 0x0022, 0xFFF4, 0x0020, 0x0008, 0x001F, 0x000B,
    0xFFEE, 0xFFC2, 0x0038, 0x001D, 0xFFBE, 0x002D, 0x0014, 0xFFF8,
    0xFFFC, 0x0023, 0xFFD7, 0xFFE1, 0xFFF1, 0x000F, 0x0011, 0x0015,
    0xFFDA, 0x0018, 0x0000, 0x000B, 0x0002, 0x0009, 0x000D, 0xFFF2,
    0x0005, 0x0019, 0x0019, 0x0034, 0x0010, 0xFFF1, 0xFFF9, 0x000E,
    0xFFFB, 0xFFFC, 0x0027, 0xFFF2, 0x0028, 0xFFF6, 0xFFED, 0x000F,
    0xFFFB, 0xFFE9, 0x0002, 0x0025, 0x000D, 0xFFEF, 0x0010, 0x002D,
    0x001D, 0xFFE6, 0xFFFE, 0x0004, 0xFFF8, 0xFFFB, 0xFFF8, 0xFFE9,
    0x0000, 0xFFD7, 0x000D, 0x0007, 0xFFEC, 0xFFDD, 0x000B, 0x0009,
    0xFFEE, 0x001B, 0xFFF3, 0xFFE7, 0x0005, 0x0002, 0xFFF2, 0x0024,
    0xFFCD, 0x000C, 0x001C, 0xFFF4, 0x000B, 0xFFE5, 0x0021, 0x0017,
    0x0004, 0x0009, 0xFFF9, 0xFFF8, 0xFFF7, 0xFFED, 0xFFEF, 0x000F,
    0x000A, 0x000B, 0xFFF6, 0x0005, 0x0004, 0x000B, 0x0003, 0xFFEB,
    0xFFF1, 0xFFF4, 0x0007, 0xFFE8, 0x0016, 0x000C, 0x001A, 0x0007,
    0xFFF3, 0x001C, 0xFFE7, 0xFFD1, 0xFFD1, 0x0026, 0x0006, 0xFFF3,
    0x0015, 0xFFF3, 0x0014, 0x0001, 0x0008, 0x0022, 0xFFE6, 0xFFF1,
    0xFFE8, 0x0025, 0x000F, 0x0004, 0x0011, 0x0005, 0x001F, 0xFFC6,
    0xFFDB, 0xFFEA, 0x0007, 0x002B, 0x0001, 0x0023, 0x001B, 0xFFEF,
    0x0003, 0xFFDD, 0xFFF4, 0x001B, 0x001A, 0x0006, 0x001A, 0x0019,
    0x0022, 0xFFF7, 0x002C, 0x004F, 0xFFEE, 0xFFDE, 0xFFEB, 0xFFCD,
    0xFFF0, 0xFFE3, 0x0000, 0xFFDB, 0x0039, 0x0004, 0xFFE7, 0xFFD1,
    0xFFD2, 0xFFE2, 0x0008, 0xFFFF, 0xFFED, 0x000D, 0x000A, 0xFFF5,
    0xFFC8, 0x0006, 0x002B, 0x0034, 0xFFD6, 0xFFC0, 0x0015, 0x000D,
    0xFFF0, 0x0012, 0x0026, 0xFFEA, 0x0006, 0xFFDD, 0x0019, 0x0000,
    0xFFE3, 0xFFEC, 0xFFE0, 0xFFF1, 0x000A, 0xFFFC, 0xFFCF, 0x0037,
    0xFFD3, 0x0001, 0xFFFB, 0x0028, 0x0002, 0x0011, 0xFFFD, 0xFFEB,
    0xFFFA, 0x000A, 0xFFFF, 0xFFF2, 0x001C, 0x0013, 0x0003, 0x0015,
    0x0027, 0x002E, 0x000B, 0xFFF3, 0xFFFD, 0xFFD5, 0xFFFA, 0x0003,
    0xFFF5, 0x0001, 0x0029, 0x0000, 0x000A, 0xFFFF, 0xFFF5, 0x000F,
    0x000D, 0xFFF8, 0xFFFD, 0xFFFB, 0xFFFA, 0x001A, 0xFFF1, 0xFFEF,
    0x0010, 0x0025, 0xFFFC, 0x003F, 0x0017, 0xFFFB, 0x0013, 0xFFFC,
    0xFFEF, 0xFFEA, 0x0015, 0x0003, 0x0000, 0x001D, 0x000A, 0x0002,
    0x0005, 0xFFC7, 0x0014, 0x000E, 0xFFF3, 0x002B, 0xFFF9, 0xFFFF,
    0x0004, 0xFFE5, 0x0036, 0xFFF8, 0x000E, 0x0008, 0x0003, 0xFFE1,
    0xFFFA, 0xFFDA, 0x0006, 0x0022, 0xFFDE, 0x001B, 0xFFFA, 0x0008,
    0xFFE7, 0xFFE6, 0x000B, 0xFFEF, 0x0007, 0xFFFC, 0x000D, 0xFFF4,
    0x0040, 0x0023, 0x001A, 0x000E, 0xFFE5, 0xFFFB, 0x0011, 0xFFD3,
    0xFFDC, 0xFFD8, 0x0023, 0x0000, 0x002F, 0xFFEA, 0x000C, 0xFFEA,
    0xFFF1, 0x0018, 0x0006, 0xFFCC, 0x0009, 0xFFE2, 0x0009, 0x000F,
    0xFFFB, 0x0012, 0x0008, 0xFFE6, 0xFFE8, 0x000D, 0x000B, 0x0023,
    0xFFF3, 0xFFFE, 0xFFE4, 0x0007, 0xFFFE, 0x0005, 0xFFF4, 0x0011,
    0xFFFF, 0x002E, 0x001A, 0x000C, 0x0002, 0x0008, 0x001D, 0x0008,
    0x0009, 0x001C, 0x001F, 0x000D, 0xFFFE, 0x0003, 0x0029, 0xFFDE,
    0x001C, 0xFFEA, 0x001B, 0x0007, 0x000C, 0xFFF4, 0xFFF9, 0x0025,
    0xFFC6, 0xFFEF, 0xFFC5, 0x0010, 0x001F, 0xFFF3, 0xFFD0, 0xFFE8,
    0xFFFF, 0xFFF7, 0x001F, 0x0009, 0x0048, 0xFFD1, 0xFFF3, 0xFFDE,
    0xFFD5, 0x000A, 0xFFE3, 0xFFEE, 0xFFF2, 0x001F, 0x0023, 0x0009,
    0xFFF9, 0xFFDE, 0xFFEF, 0x0000, 0xFFE3, 0x000F, 0x0022, 0xFFFA,
    0x000E, 0x0000, 0x0022, 0x0006, 0xFFE3, 0xFFF1, 0xFFEF, 0x0000,
    0xFFF9, 0x0022, 0x0023, 0xFFF7, 0xFFF2, 0xFFE1, 0xFFE3, 0x0012,
    0xFFD5, 0xFFF6, 0xFFF3, 0x0022, 0x0048, 0x002F, 0x001F, 0xFFF7,
    0xFFFF, 0x0009, 0xFFD0, 0x0018, 0x001F, 0x000D, 0xFFC5, 0xFFF0,
    0xFFC6, 0x0011, 0xFFF9, 0xFFDB, 0x000C, 0x000C, 0x001B, 0xFFF9,
    0x001C, 0x0016, 0x0029, 0x0022, 0xFFFE, 0xFFFD, 0x001F, 0xFFF3,
    0x0009, 0xFFE4, 0x001D, 0xFFF8, 0x0002, 0xFFF8, 0x001A, 0xFFF4,
    0xFFFF, 0xFFD2, 0xFFF4, 0xFFEF, 0xFFFE, 0xFFFB, 0xFFE4, 0xFFF9,
    0xFFF3, 0x0002, 0x000B, 0xFFDD, 0xFFE8, 0xFFF3, 0x0008, 0x001A,
    0xFFFB, 0xFFEE, 0x0009, 0xFFF1, 0x0009, 0x001E, 0x0006, 0x0034,
    0xFFF1, 0xFFE8, 0x000C, 0x0016, 0x002F, 0x0016, 0x0023, 0x0000,
    0xFFDC, 0x0028, 0x0011, 0x002D, 0xFFE5, 0x0005, 0x001A, 0xFFF2,
    0x0040, 0xFFDD, 0x000D, 0x000C, 0x0007, 0x0004, 0x000B, 0x0011,
    0xFFE7, 0x001A, 0xFFFA, 0xFFF8, 0xFFDE, 0xFFE5, 0x0006, 0xFFDE,
    0xFFFA, 0x0026, 0x0003, 0x001F, 0x000E, 0xFFF8, 0x0036, 0x0008,
    0x0004, 0x001B, 0xFFF9, 0x0001, 0xFFF3, 0xFFD5, 0x0014, 0xFFF2,
    0x0005, 0x0039, 0x000A, 0xFFFE, 0x0000, 0xFFE3, 0x0015, 0xFFFD,
    0xFFEF, 0x0016, 0x0013, 0x0004, 0x0017, 0x0005, 0xFFFC, 0xFFC1,
    0x0010, 0xFFDB, 0xFFF1, 0x0011, 0xFFFA, 0xFFE6, 0xFFFD, 0x0005,
    0x000D, 0x0008, 0xFFF5, 0xFFF1, 0x000A, 0x0001, 0x0029, 0x0000,
    0xFFF5, 0xFFFF, 0xFFFA, 0xFFFD, 0xFFFD, 0x002B, 0x000B, 0x000D,
    0x0027, 0xFFD2, 0x0003, 0xFFEB, 0x001C, 0xFFED, 0xFFFF, 0x000E,
    0xFFFA, 0xFFF6, 0xFFFD, 0x0015, 0x0002, 0xFFEF, 0xFFFB, 0xFFD8,
    0xFFD3, 0xFFFF, 0xFFCF, 0xFFC9, 0x000A, 0x0004, 0xFFE0, 0x000F,
    0xFFE3, 0x0014, 0x0019, 0x0000, 0x0006, 0x0023, 0x0026, 0x0016,
    0xFFF0, 0xFFEE, 0x0015, 0xFFF3, 0xFFD6, 0x0040, 0x002B, 0xFFCC,
    0xFFC8, 0xFFFA, 0x000A, 0x000B, 0xFFED, 0xFFF3, 0x0008, 0x0001,
    0xFFD2, 0x001E, 0xFFE7, 0x002F, 0x0039, 0xFFFC, 0x0000, 0x0025,
    0xFFF0, 0x001D, 0xFFEB, 0x0033, 0xFFEE, 0x0022, 0x002C, 0xFFB1,
    0x0022, 0x0009, 0x001A, 0xFFE7, 0x001A, 0xFFFA, 0xFFF4, 0xFFE5,
    0x0003, 0x0023, 0x001B, 0x0011, 0x0001, 0xFFDD, 0x0007, 0xFFD5,
    0xFFDB, 0x0016, 0x001F, 0x003A, 0x0011, 0xFFFB, 0x000F, 0xFFFC,
    0xFFE8, 0xFFDB, 0xFFE6, 0x000F, 0x0008, 0xFFDE, 0x0014, 0xFFFF,
    0x0015, 0x000D, 0x0006, 0x000D, 0xFFD1, 0xFFDA, 0xFFE7, 0x002F,
    0xFFF3, 0xFFE4, 0x001A, 0xFFF9, 0x0016, 0xFFF4, 0x0007, 0x0018,
    0xFFF1, 0x000C, 0x0003, 0x0015, 0x0004, 0xFFF5, 0xFFF6, 0xFFFB,
    0x000A, 0xFFF5, 0xFFEF, 0xFFF1, 0xFFF7, 0x0013, 0xFFF9, 0x0008,
    0x0004, 0xFFF7, 0x0021, 0xFFE9, 0x000B, 0x001B, 0x001C, 0x000C,
    0xFFCD, 0xFFF4, 0xFFF2, 0xFFDC, 0x0005, 0xFFFE, 0xFFF3, 0x0019,
    0xFFEE, 0xFFE5, 0x000B, 0xFFF7, 0xFFEC, 0x0023, 0x000D, 0xFFF9,
    0x0000, 0x0029, 0xFFF8, 0x0017, 0xFFF8, 0x0005, 0xFFFE, 0xFFFC,
    0x001D, 0x001A, 0x0010, 0xFFD3, 0x000D, 0x0011, 0x0002, 0xFFDB,
    0xFFFB, 0x0017, 0xFFED, 0xFFF1, 0x0028, 0x000A, 0x0027, 0x000E,
    0xFFFB, 0x0004, 0xFFF9, 0xFFF2, 0x0010, 0x000F, 0x0019, 0xFFCC,
    0x0005, 0xFFE7, 0x000D, 0x000E, 0x0002, 0xFFF7, 0x0000, 0xFFF5,
    0xFFDA, 0xFFE8, 0x0011, 0xFFEB, 0xFFF1, 0xFFF1, 0xFFD7, 0x001F,
    0xFFFC, 0xFFDD, 0x0014, 0x0008, 0xFFBE, 0xFFD3, 0x0038, 0xFFE3,
    0xFFEE, 0x003E, 0x001F, 0xFFF5, 0x0020, 0xFFF8, 0x0022, 0x000C,
    0x0005, 0x0006, 0x0000, 0x0011, 0x0002, 0x000E, 0x001E, 0x001B,
    0x0042, 0x0068, 0x0030, 0xFFF4, 0xFFCF, 0xFFEE, 0xFFF7, 0xFFE7,
    0x0006, 0x0028, 0x0001, 0x0002, 0x001D, 0x0020, 0x001D, 0xFFEF,
    0x0020, 0xFFF4, 0xFFE2, 0xFFE8, 0x0037, 0xFFDD, 0xFFF2, 0xFFF3,
    0x001A, 0x0010, 0xFFA6, 0xFFD4, 0xFFF6, 0xFFFE, 0xFFCD, 0xFFCC,
    0xFFE6, 0xFFEF, 0x0004, 0x001B, 0xFFFB, 0x000D, 0xFFF9, 0x0004,
    0xFFEF, 0xFFF3, 0x0006, 0x0021, 0x001C, 0xFFF2, 0xFFD1, 0x0008,
    0x0010, 0x0005, 0xFFE8, 0xFFE9, 0x0002, 0xFFCC, 0x0028, 0x0016,
    0xFFFD, 0x0016, 0xFFEB, 0x000B, 0x0024, 0xFFF8, 0x0008, 0xFFEA,
    0x0005, 0x0000, 0xFFED, 0x0005, 0x0007, 0xFFCA, 0x000F, 0xFFE9,
    0x001A, 0x0018, 0x003E, 0xFFF2, 0x0029, 0xFFF1, 0xFFD8, 0x001C,
    0x000B, 0x0012, 0x0019, 0x000E, 0x000E, 0xFFF0, 0x0010, 0x0019,
    0xFFE6, 0xFFE5, 0xFFFC, 0xFFFC, 0xFFF1, 0xFFF3, 0xFFFE, 0x000F,
    0xFFCF, 0xFFFD, 0x0003, 0x000A, 0xFFE7, 0x0011, 0x000D, 0x0010,
    0x001C, 0x0002, 0x0020, 0x0023, 0xFFF9, 0xFFF2, 0x0014, 0xFFF0,
    0xFFD1, 0x0001, 0xFFE0, 0xFFF5, 0xFFE1, 0xFFE9, 0x000B, 0xFFF9,
    0x0003, 0x0008, 0x0017, 0x000C, 0xFFFC, 0xFFF2, 0x0005, 0xFFFC,
    0x0016, 0x0002, 0xFFFA, 0x000F, 0x001D, 0xFFD1, 0x0019, 0x001F,
    0x000C, 0x001E, 0x0002, 0xFFE8, 0xFFF5, 0xFFFB, 0x002C, 0x0007,
    0xFFDC, 0x0009, 0x0014, 0x000B, 0x002B, 0x001A, 0x0027, 0x001E,
    0x000C, 0xFFF3, 0x000B, 0xFFEE, 0xFFFA, 0x0002, 0xFFEB, 0x0007,
    0xFFF7, 0xFFEC, 0x0017, 0x000B, 0x0004, 0xFFF1, 0x001E, 0x0004,
    0xFFE3, 0xFFF4, 0x001D, 0x001B, 0x0023, 0xFFF1, 0xFFF0, 0xFFEB,
    0x0004, 0xFFD5, 0xFFFF, 0xFFF7, 0x0021, 0xFFC8, 0x0011, 0xFFF5,
    0xFFE9, 0x0029, 0x0014, 0x002D, 0xFFFE, 0x0005, 0xFFF4, 0xFFF7,
    0x0021, 0x0017, 0xFFFF, 0x0001, 0xFFE7, 0xFFFC, 0xFFB3, 0xFFE3,
    0xFFF1, 0x0002, 0xFFD1, 0x0002, 0x001B, 0xFFFC, 0x0019, 0x0014,
    0xFFFC, 0xFFD6, 0xFFFA, 0x001C, 0xFFE5, 0x0028, 0xFFCC, 0xFFF4,
    0x0019, 0xFFE3, 0xFFE4, 0xFFF5, 0xFFE9, 0xFFFF, 0xFFF5, 0xFFF3,
    0x0005, 0x0023, 0xFFDA, 0x0035, 0x0000, 0xFFDA, 0x000E, 0x0013,
    0x001A, 0x000B, 0xFFFE, 0xFFE0, 0xFFEF, 0x0007, 0x0019, 0xFFFB,
    0xFFF4, 0xFFF6, 0xFFE2, 0x0013, 0xFFD6, 0x0005, 0x0029, 0x0026,
    0x0007, 0xFFF1, 0x000C, 0xFFE8, 0x0004, 0xFFF3, 0x0011, 0xFFC0,
    0xFFFA, 0xFFF6, 0x0002, 0x002D, 0xFFD1, 0x0012, 0x0010, 0xFFEE,
    0xFFE7, 0x0010, 0x0003, 0x001E, 0xFFE2, 0x0008, 0x0001, 0x000A,
    0x0022, 0x0024, 0x0024, 0xFFEF, 0xFFD9, 0xFFF3, 0x0000, 0x0025,
    0x000A, 0xFFF1, 0x0023, 0xFFFE, 0x0006, 0xFFE1, 0xFFEF, 0x003A,
    0x0016, 0x000F, 0x0025, 0x000A, 0xFFF7, 0xFFF9, 0x0036, 0x0005,
    0xFFF1, 0xFFFB, 0xFFD5, 0xFFEA, 0x000E, 0x0018, 0xFFEC, 0xFFEE,
    0x0006, 0x0010, 0x0002, 0x000B, 0x0003, 0xFFF4, 0xFFFE, 0x0007,
    0x0001, 0x0004, 0x0024, 0x0017, 0x0012, 0x0012, 0x0018, 0xFFF4,
    0x0002, 0x001B, 0x000B, 0xFFF0, 0xFFF7, 0xFFE0, 0xFFDB, 0x001E,
    0xFFF1, 0xFFF0, 0xFFF4, 0xFFE5, 0x000D, 0xFFF3, 0xFFD8, 0xFFDA,
    0xFFE8, 0x0022, 0xFFF7, 0x0018, 0x0008, 0xFFDA, 0xFFFD, 0x0016,
    0x001D, 0xFFEF, 0x0006, 0x000E, 0x0019, 0x001F, 0x001A, 0xFFF1,
    0xFFDD, 0x0017, 0xFFF9, 0xFFF7, 0xFFFE, 0xFFF8, 0xFFF8, 0xFFF9,
    0xFFE6, 0x0004, 0x001D, 0x0005, 0x0013, 0xFFCF, 0xFFCB, 0x0007,
    0xFFFD, 0xFFF2, 0xFFF2, 0x003D, 0xFFE4, 0xFFED, 0xFFC5, 0xFFEA,
    0x0003, 0xFFC8, 0xFFE6, 0x0007, 0xFFF7, 0x0007, 0xFFF3, 0x000C,
    0xFFF2, 0xFFFA, 0x0012, 0xFFE9, 0xFFE2, 0xFFF1, 0x0003, 0x0000,
    0xFFDA, 0x0000, 0xFFF6, 0x002C, 0xFFFC, 0x0009, 0x0006, 0x0020,
    0xFFEF, 0xFFF2, 0x0028, 0xFFFC, 0xFFFB, 0xFFFD, 0x0007, 0xFFF8,
    0xFFED, 0xFFF5, 0x0009, 0xFFCA, 0x000E, 0xFFF2, 0x0003, 0x0002,
    0x0019, 0x0010, 0xFFFA, 0xFFED, 0xFFC0, 0xFFD6, 0xFFEC, 0x0016,
    0x0003, 0xFFE6, 0x0029, 0x0010, 0xFFFC, 0xFFF8, 0xFFF9, 0xFFE5,
    0xFFFB, 0x0023, 0x000F, 0x000E, 0x0011, 0x000B, 0x0004, 0x0018,
    0xFFE6, 0x0001, 0xFFF8, 0xFFCE, 0xFFEE, 0xFFC9, 0x0018, 0x0006,
    0xFFF0, 0x0000, 0x0005, 0x002E, 0xFFEC, 0x000C, 0x001F, 0xFFEF,
    0xFFE1, 0xFFE5, 0xFFF5, 0xFFEB, 0xFFF4, 0xFFE7, 0xFFE6, 0x001A,
    0xFFCC, 0xFFFE, 0x0003, 0x000C, 0x0006, 0x0010, 0x0001, 0x0025,
    0x000F, 0x0026, 0xFFE7, 0xFFF0, 0xFFF2, 0x0014, 0x0019, 0xFFDA,
    0x0017, 0x001D, 0xFFEA, 0xFFFB, 0x0005, 0x001C, 0x003B, 0x0010,
    0xFFFF, 0xFFCE, 0xFFF1, 0x000B, 0x002E, 0x0021, 0x001A, 0x001C,
    0x0026, 0xFFEA, 0xFFEC, 0xFFFE, 0xFFE8, 0xFFD5, 0xFFDD, 0xFFD2,
    0x0022, 0x002B, 0xFFD8, 0x0001, 0x0001, 0x0024, 0x0015, 0x0004,
    0x000D, 0x0016, 0x0014, 0xFFD7, 0xFFFB, 0xFFEF, 0x0032, 0x000B,
    0xFFFF, 0xFFF0, 0xFFF7, 0x0002, 0x0006, 0xFFF9, 0x0023, 0x0006,
    0x0010, 0x0036, 0xFFF9, 0xFFFB, 0x0009, 0x001B, 0xFFFC, 0x0013,
    0x002D, 0xFFF9, 0xFFEF, 0x000C, 0xFFF7, 0xFFF9, 0x0015, 0x0009,
    0x0006, 0xFFCB, 0x0017, 0x001D, 0x0000, 0x0013, 0x0058, 0x0020,
    0x001D, 0x0032, 0xFFE0, 0x0042, 0xFFE8, 0x0009, 0x0000, 0xFFF8,
    0x0020, 0x000D, 0xFFF3, 0xFFEF, 0xFFD9, 0x0004, 0x0002, 0xFFD6,
    0xFFF6, 0x0013, 0x0026, 0xFFE2, 0x000A, 0x000B, 0xFFF1, 0xFFE5,
    0xFFCE, 0x000A, 0x0008, 0xFFF5, 0x0027, 0x0012, 0xFFD8, 0xFFE8,
    0x0035, 0xFFFA, 0xFFF3, 0x0005, 0x0009, 0x0020, 0x001D, 0x001C,
    0x000C, 0x0025, 0x002B, 0x004B, 0xFFF8, 0xFFF5, 0x0002, 0x000E,
    0x0002, 0xFFF7, 0xFFEE, 0x0018, 0xFFE0, 0xFFED, 0xFFFF, 0x001B,
    0x0006, 0xFFF0, 0x0002, 0x0009, 0x000C, 0x0042, 0x0000, 0x0006,
    0xFFF7, 0x0005, 0x0002, 0x0019, 0xFFE9, 0x0004, 0xFFF2, 0x000E,
    0x0033, 0x000F, 0xFFF2, 0x0022, 0x0007, 0x000D, 0xFFF7, 0x0030,
    0x000B, 0xFFED, 0xFFF2, 0xFFF3, 0xFFC8, 0x0010, 0xFFF1, 0xFFE6,
    0xFFF5, 0x000C, 0x0014, 0x0027, 0xFFF5, 0x0026, 0xFFE4, 0x0003,
    0x001E, 0x001A, 0xFFFF, 0xFFD3, 0x000E, 0xFFED, 0xFFEE, 0x0005,
    0xFFC2, 0x0023, 0x000E, 0x0018, 0xFFE9, 0x0001, 0x0002, 0x0005,
    0x0000, 0xFFBF, 0x0027, 0xFFD6, 0xFFD2, 0xFFE1, 0xFFFB, 0x0013,
    0xFFFF, 0x000B, 0x0025, 0x0035, 0xFFE8, 0xFFC5, 0xFFED, 0x000F,
    0xFFFB, 0x0028, 0xFFEA, 0xFFE2, 0x0014, 0xFFF2, 0xFFE9, 0xFFD0,
    0x0004, 0x0010, 0xFFF9, 0xFFD8, 0x0015, 0xFFE8, 0x0015, 0xFFED,
    0x000F, 0x0002, 0xFFEF, 0x0012, 0x0003, 0xFFCB, 0x002C, 0x0027,
    0x000B, 0x0025, 0x0011, 0x0005, 0xFFF9, 0xFFFC, 0xFFF9, 0x0015,
    0xFFFC, 0x0005, 0x0025, 0x0009, 0x0025, 0x0018, 0x0007, 0xFFEF,
    0xFFF3, 0x0006, 0xFFFE, 0x000D, 0x0007, 0x000E, 0x0012, 0x001E,
    0xFFCF, 0xFFEE, 0xFFDC, 0x0009, 0x0007, 0xFFF9, 0xFFF0, 0x001B,
    0xFFEF, 0xFFEE, 0xFFFE, 0xFFF9, 0x0033, 0x0000, 0x0026, 0x001A,
    0x001F, 0x0005, 0xFFF6, 0xFFFA, 0xFFE3, 0x0024, 0xFFD8, 0x0012,
    0x0020, 0x0002, 0xFFE5, 0x0010, 0x0000, 0xFFDF, 0xFFDC, 0x0017,
    0x0010, 0x0001, 0x0033, 0xFFE2, 0xFFDE, 0xFFFE, 0xFFF4, 0xFFD3,
    0x0026, 0x0027, 0x003B, 0xFFEB, 0x0009, 0x0007, 0xFFFD, 0xFFD6,
    0xFFCE, 0xFFEE, 0xFFF6, 0xFFE9, 0xFFE9, 0x0030, 0x0020, 0x000C,
    0x0009, 0x0020, 0x0000, 0x0012, 0xFFF0, 0x0013, 0xFFC9, 0xFFF2,
    0xFFF7, 0xFFE3, 0xFFCB, 0x001C, 0x000A, 0xFFF8, 0xFFF2, 0xFFF0,
    0xFFDD, 0xFFF6, 0x0015, 0xFFF1, 0xFFF4, 0x0011, 0x0001, 0xFFFD,
    0x0017, 0xFFF0, 0xFFD9, 0xFFEA, 0x0009, 0x0012, 0x0004, 0x0017,
    0xFFE5, 0xFFFD, 0x0023, 0x001B, 0x0002, 0xFFCA, 0x0015, 0xFFF2,
    0x0000, 0x0003, 0xFFF7, 0xFFF1, 0x0021, 0xFFEA, 0x001D, 0x0010,
    0x0029, 0x001A, 0xFFEC, 0xFFE4, 0x000B, 0xFFFF, 0xFFF6, 0xFFF2,
    0x002B, 0x0003, 0x0027, 0x0011, 0x0002, 0x0007, 0x000C, 0xFFF7,
    0xFFBE, 0x001D, 0x0007, 0x001F, 0x0005, 0x000C, 0x000D, 0x000F,
    0xFFE4, 0xFFEC, 0x0015, 0x0019, 0x0016, 0xFFF4, 0xFFF5, 0x0016,
    0x000C, 0xFFF8, 0xFFEA, 0xFFF6, 0xFFC7, 0x000A, 0xFFDF, 0xFFFF,
    0x0010, 0x0007, 0x000E, 0xFFDA, 0xFFF3, 0x0020, 0x0041, 0xFFEF,
    0x0018, 0x0010, 0x000D, 0xFFF9, 0x0022, 0x0007, 0x001B, 0x001D,
    0x002F, 0x0002, 0x0013, 0xFFE5, 0xFFDF, 0xFFFA, 0x0038, 0x0006,
    0x0008, 0xFFF2, 0x0013, 0xFFEA, 0xFFD7, 0x0010, 0xFFF3, 0x002D,
    0x000E, 0x0006, 0xFFF2, 0x0004, 0x0025, 0xFFEC, 0x000C, 0xFFF9,
    0x0003, 0xFFE6, 0x0000, 0x0022, 0x0005, 0xFFEE, 0xFFC3, 0xFFF4,
    0x0020, 0xFFE8, 0xFFE8, 0xFFE3, 0xFFF6, 0x000E, 0x002F, 0x000E,
    0x002A, 0x0021, 0xFFEA, 0xFFFD, 0xFFFD, 0x0015, 0x0001, 0xFFF1,
    0xFFEF, 0x0027, 0xFFF2, 0xFFF1, 0x0017, 0x0013, 0xFFFD, 0xFFCE,
    0xFFE2, 0x0020, 0xFFF4, 0x000C, 0x001E, 0x0004, 0x0019, 0x0005,
    0xFFC4, 0xFFED, 0x000E, 0xFFF5, 0xFFFE, 0xFFF4, 0x0005, 0xFFEE,
    0xFFE1, 0x0009, 0x001A, 0xFFE8, 0xFFFE, 0xFFF6, 0xFFFB, 0x001B,
    0x002E, 0x0028, 0xFFFC, 0x002B, 0xFFD4, 0x001A, 0x000E, 0x000A,
    0x0006, 0xFFEE, 0xFFEC, 0x0030, 0x0008, 0x001B, 0x0026, 0xFFE3,
    0x0010, 0xFFE3, 0x0019, 0x0004, 0xFFE5, 0x0019, 0xFFEA, 0xFFF5,
    0xFFE8, 0xFFF0, 0xFFE1, 0xFFFF, 0xFFED, 0xFFF4, 0xFFE2, 0x001C,
    0x0008, 0x0024, 0xFFE5, 0x0004, 0xFFE1, 0xFFE3, 0x0004, 0x001C,
    0xFFDF, 0x0018, 0x000C, 0xFFFD, 0xFFF1, 0xFFF8, 0x000D, 0x002B,
    0xFFEF, 0x0002, 0xFFDB, 0x0009, 0x0012, 0x0025, 0xFFE3, 0xFFD9,
    0xFFF6, 0xFFFC, 0xFFEE, 0x0029, 0xFFFB, 0x0022, 0xFFCB, 0x0001,
    0xFFDF, 0x000E, 0x0020, 0xFFF2, 0x000C, 0xFFF7, 0xFFFA, 0xFFF2,
    0x0018, 0x0006, 0xFFEC, 0xFFED, 0xFFEE, 0x0003, 0xFFF3, 0xFFE0,
    0xFFE6, 0xFFF1, 0x002D, 0xFFFB, 0x001C, 0xFFD9, 0xFFFA, 0x003C,
    0x0008, 0x000C, 0x0024, 0xFFEE, 0x0000, 0x000D, 0xFFFC, 0x001D,
    0x0020, 0xFFED, 0x000D, 0x0013, 0x000D, 0x0021, 0xFFE0, 0x0008,
    0x001B, 0xFFEF, 0xFFF8, 0xFFF0, 0xFFFA, 0x000E, 0xFFDC, 0x0021,
    0xFFF8, 0xFFCD, 0x001A, 0xFFFF, 0xFFFC, 0x001F, 0xFFF9, 0x001C,
    0x0007, 0xFFCC, 0x0005, 0xFFFA, 0x000E, 0xFFE2, 0xFFFB, 0x0001,
    0x0004, 0xFFE6, 0x0008, 0xFFD5, 0x000D, 0x0003, 0x0009, 0xFFF8,
    0xFFF1, 0x0004, 0x000F, 0xFFF2, 0xFFF4, 0xFFE9, 0xFFCF, 0x0006,
    0xFFF5, 0xFFEC, 0x0001, 0x0000, 0xFFFE, 0x001A, 0x0036, 0xFFD7,
    0xFFE8, 0xFFE4, 0x0017, 0x000B, 0x0010, 0x0005, 0xFFE8, 0x000A,
    0xFFE6, 0xFFDA, 0xFFEE, 0x0055, 0x0015, 0xFFE3, 0x000E, 0x0001,
    0x0028, 0xFFE5, 0xFFFF, 0xFFE0, 0xFFF1, 0xFFC0, 0xFFF9, 0xFFED,
    0x0009, 0x2CD5, 0xFFCE, 0xFFE8, 0x0004, 0x002E, 0x0008, 0x0023,
    0x001A, 0x0011, 0xFFF8, 0x0017, 0xFFF5, 0x0024, 0x0001, 0xFFD3,
    0x0003, 0xFFC1, 0x001B, 0xFFE4, 0xFFFA, 0xFFEF, 0xFFEE, 0xFFE9,
    0xFFFC, 0xFFF7, 0x0028, 0x000F, 0x0005, 0x0031, 0xFFFE, 0xFFF9,
    0xFFF7, 0x0001, 0x0013, 0x0011, 0x000F, 0x0000, 0x0012, 0x0016,
    0x001C, 0x000B, 0x0021, 0x0019, 0x001B, 0xFFE9, 0x000B, 0x0011,
    0x0014, 0x0005, 0x0004, 0xFFD6, 0xFFEF, 0xFFEC, 0xFFDF, 0xFFEB,
    0xFFE3, 0x0018, 0xFFF0, 0xFFFA, 0x000E, 0x001F, 0xFFE6, 0x0017,
    0xFFDA, 0xFFED, 0xFFF4, 0xFFD7, 0xFFE6, 0x0004, 0x0005, 0x0006,
    0x0010, 0xFFEB, 0x0016, 0xFFF3, 0xFFF2, 0x0001, 0x000C, 0xFFE8,
    0x000A, 0xFFFA, 0x000D, 0x0003, 0x0024, 0x002A, 0xFFD6, 0x0011,
    0x0028, 0xFFE0, 0xFFDB, 0x0007, 0x001D, 0xFFF2, 0xFFFF, 0xFFF5,
    0xFFFC, 0xFFF3, 0xFFFB, 0x001F, 0x0024, 0xFFE2, 0x000D, 0x000D,
    0x0029, 0x001C, 0xFFC9, 0xFFFF, 0xFFD8, 0xFFF7, 0xFFE4, 0xFFE7,
    0x000E, 0xFFDA, 0x0007, 0xFFE9, 0x0027, 0xFFD1, 0x001F, 0x0024,
    0xFFF0, 0xFFE5, 0x0022, 0x0018, 0x0000, 0x0002, 0xFFE2, 0x0015,
    0xFFE9, 0xFFF4, 0xFFFB, 0x001F, 0xFFEB, 0x0015, 0xFFFC, 0x001B,
    0xFFFE, 0xFFEF, 0xFFE3, 0x0029, 0x0004, 0xFFDB, 0xFFFA, 0x0007,
    0xFFE9, 0x0034, 0xFFF6, 0xFFE9, 0xFFF2, 0x0017, 0x0006, 0x0007,
    0xFFEA, 0x0009, 0xFFFE, 0x0008, 0xFFF1, 0x0010, 0x000F, 0xFFFC,
    0x000E, 0xFFF4, 0x001A, 0x000D, 0xFFFD, 0x0012, 0xFFF8, 0xFFF6,
    0x0023, 0xFFF5, 0xFFD2, 0x0008, 0x0011, 0x000A, 0x0013, 0xFFDC,
    0x0015, 0xFFC5, 0x000F, 0x0029, 0xFFD7, 0xFFBA, 0x0026, 0xFFF9,
    0xFFFE, 0x001A, 0x0004, 0x000C, 0x0007, 0x0000, 0x003B, 0x0010,
    0x0018, 0xFFFE, 0xFFF7, 0xFFF1, 0xFFD7, 0xFFE0, 0x0002, 0xFFEF,
    0xFFD7, 0xFFF2, 0x000B, 0xFFEF, 0x000D, 0x0022, 0xFFF5, 0x0012,
    0xFFFA, 0x000D, 0xFFFA, 0xFFFE, 0xFFE8, 0x002F, 0x000F, 0xFFEE,
    0xFFF0, 0xFFF6, 0xFFF0, 0x0001, 0xFFF3, 0x001C, 0xFFD6, 0x0011,
    0x0006, 0xFFF4, 0xFFE8, 0x0035, 0xFFD2, 0x0018, 0xFFED, 0xFFC8,
    0xFFE7, 0x0015, 0xFFE0, 0xFFED, 0x0008, 0x0036, 0xFFF2, 0x001D,
    0x0026, 0xFFD9, 0x0014, 0x0005, 0xFFF5, 0x0006, 0x0008, 0xFFEE,
    0x0000, 0x000E, 0x001F, 0x0006, 0xFFE2, 0xFFF6, 0x001E, 0xFFEF,
    0x0001, 0xFFF5, 0xFFF1, 0x0010, 0x0019, 0x0009, 0xFFF9, 0xFFF7,
    0x0016, 0x0033, 0x000A, 0x0026, 0x0028, 0x0001, 0x0004, 0x0008,
    0x002A, 0xFFD3, 0xFFE9, 0x0023, 0xFFED, 0xFFE6, 0xFFFF, 0x0034,
    0x0004, 0x0002, 0xFFE9, 0x0005, 0x000C, 0x0022, 0xFFF4, 0xFFFB,
    0xFFF2, 0x0014, 0xFFEE, 0xFFFC, 0xFFEE, 0xFFF1, 0x0022, 0xFFF5,
    0x0017, 0x0002, 0xFFE1, 0x0003, 0x0010, 0x002B, 0xFFFD, 0x000F,
    0x0003, 0xFFED, 0x001B, 0xFFF7, 0xFFD7, 0x0040, 0xFFD0, 0x0048,
    0x0015, 0x0012, 0xFFF9, 0xFFF5, 0xFFF5, 0xFFFC, 0xFFF9, 0x0037,
    0x0007, 0x0021, 0x0007, 0x0040, 0x001B, 0x0019, 0xFFE6, 0x000B,
    0xFFF8, 0xFFDE, 0x0026, 0xFFD0, 0xFFEF, 0xFFF9, 0x0011, 0x000E,
    0x0010, 0xFFF1, 0x0004, 0x0016, 0xFFF5, 0xFFE9, 0x0039, 0x0006,
    0xFFB9, 0xFFF1, 0xFFC2, 0x001A, 0xFFF6, 0x004D, 0x0002, 0xFFF8,
    0xFFF3, 0x000C, 0xFFDD, 0x000D, 0xFFF3, 0xFFFA, 0x0001, 0xFFFF,
    0x000A, 0xFFCE, 0xFFE3, 0x0037, 0xFFE9, 0x0025, 0xFFF2, 0xFFED,
    0x0007, 0xFFFE, 0xFFF8, 0x0034, 0x0027, 0xFFE0, 0xFFF8, 0x0006,
    0x0005, 0xFFF8, 0x0008, 0x0008, 0xFFF8, 0x002B, 0xFFEC, 0xFFFF,
    0x0009, 0xFFE5, 0xFFBF, 0xFFDF, 0xFFE2, 0xFFCC, 0x001A, 0xFFF2,
    0x0012, 0xFFF3, 0xFFBF, 0xFFFD, 0xFFE0, 0x0009, 0x0020, 0xFFE9,
    0xFFEC, 0xFFFE, 0xFFE3, 0x0002, 0xFFF8, 0x000B, 0x0011, 0x000B,
    0x0004, 0xFFDF, 0x0005, 0x0003, 0x002C, 0xFFD6, 0xFFDB, 0xFFFA,
    0xFFE0, 0x001D, 0xFFCC, 0xFFE3, 0x001C, 0x003C, 0x0009, 0xFFD6,
    0x0023, 0x0015, 0x0015, 0xFFDE, 0xFFDD, 0x0036, 0x0013, 0x0015,
    0xFFF3, 0xFFF1, 0x0004, 0xFFF2, 0x000B, 0xFFFD, 0x0014, 0x0003,
    0x000D, 0x0003, 0x0007, 0x0031, 0x0017, 0xFFF1, 0x0003, 0xFFE4,
    0xFFE9, 0xFFB1, 0x0003, 0x000D, 0x0006, 0x001D, 0xFFFB, 0xFFF3,
    0xFFE9, 0x0008, 0x0003, 0x000A, 0xFFE7, 0xFFE2, 0xFFFC, 0xFFFF,
    0xFFF1, 0xFFE4, 0x000B, 0x000D, 0xFFD4, 0x0002, 0x003C, 0x0010,
    0x0029, 0x0006, 0x0032, 0xFFD7, 0xFFF2, 0x0019, 0xFFE6, 0x001F,
    0x0002, 0xFFD6, 0xFFF1, 0xFFFC, 0xFFF3, 0x0016, 0x0010, 0xFFF8,
    0x0008, 0xFFEA, 0x0007, 0x0011, 0x000A, 0xFFF2, 0xFFE3, 0x0028,
    0x0006, 0x0000, 0xFFFC, 0x0021, 0x002B, 0x0008, 0x0018, 0x001C,
    0xFFFB, 0x0006, 0xFFF1, 0x000D, 0x000A, 0x0006, 0xFFEB, 0xFFCE,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_noisy_2048[2049] = {
    0xFFB0, 0x0000, 0xFFEB, 0x0032, 0x000A, 0xFFFA, 0xFFF1, 0xFFF3,
    0xFFFB, 0xFFFA, 0x0018, 0xFFE4, 0x002B, 0xFFF8, 0xFFFC, 0xFFDF,
    0x0006, 0x0000, 0xFFE3, 0xFFD8, 0x000A, 0x000E, 0x0007, 0xFFEF,
    0x0008, 0x0016, 0x0010, 0x0008, 0xFFF3, 0xFFEA, 0xFFF1, 0x0004,
    0x0002, 0x002A, 0xFFE6, 0xFFE1, 0xFFF2, 0xFFE7, 0x0032, 0x0029,
    0x0029, 0xFFFA, 0x003C, 0xFFF0, 0xFFD4, 0xFFFE, 0x000B, 0xFFF3,
    0xFFF1, 0x001C, 0xFFFC, 0x0001, 0xFFE7, 0x001E, 0x0003, 0xFFF6,
    0xFFE9, 0xFFF8, 0xFFFB, 0x000D, 0x0006, 0xFFE3, 0x0003, 0xFFF3,
    0xFFE9, 0x004F, 0x0003, 0x001C, 0x0017, 0x000F, 0x0007, 0xFFCF,
    0x000D, 0xFFFD, 0x0014, 0xFFFD, 0x000B, 0x0003, 0x0004, 0x000E,
    0xFFF3, 0x000F, 0x0013, 0xFFEB, 0xFFDD, 0xFFCA, 0x0015, 0x0022,
    0x0023, 0xFFEB, 0x0009, 0x002A, 0x001C, 0xFFC4, 0xFFCC, 0x001D,
    0xFFE0, 0xFFE3, 0xFFDB, 0x0006, 0x002C, 0x002A, 0x0005, 0xFFFD,
    0x0004, 0x0021, 0x0011, 0xFFF5, 0xFFF8, 0xFFF5, 0xFFE3, 0xFFFE,
    0xFFEC, 0x0002, 0x0020, 0x0017, 0xFFE0, 0xFFF7, 0xFFBF, 0x0003,
    0x0012, 0x000D, 0x001A, 0x000E, 0xFFE2, 0x0034, 0xFFBF, 0x0021,
    0x0009, 0x001B, 0xFFEC, 0x0001, 0xFFF8, 0xFFD5, 0x0008, 0xFFF8,
    0x0005, 0x0008, 0xFFF8, 0xFFFA, 0x0027, 0x0020, 0xFFF8, 0xFFCC,
    0x0007, 0x0002, 0xFFF2, 0x0013, 0xFFE9, 0xFFDB, 0xFFE3, 0xFFC9,
    0x000A, 0x0032, 0x0001, 0x0001, 0xFFF3, 0x0006, 0xFFDD, 0xFFF3,
    0xFFF3, 0xFFF4, 0x0002, 0x0008, 0xFFF6, 0xFFB3, 0xFFC2, 0xFFE6,
    0xFFB9, 0x000F, 0x0039, 0xFFFA, 0xFFF5, 0x0017, 0x0004, 0xFFEA,
    0x0010, 0x000F, 0x0011, 0xFFF2, 0xFFEF, 0x0007, 0x0026, 0x0030,
    0xFFF8, 0x0022, 0xFFE6, 0xFFF5, 0x001B, 0xFFE7, 0x0007, 0xFFC0,
    0x0007, 0xFFDF, 0xFFF9, 0xFFC9, 0xFFF5, 0x0004, 0xFFF9, 0x000B,
    0x0015, 0xFFEE, 0xFFD0, 0xFFB8, 0xFFD7, 0xFFC0, 0x001B, 0x0009,
    0x0003, 0x0013, 0xFFFD, 0xFFF1, 0x0010, 0xFFD5, 0xFFE1, 0xFFFD,
    0x0017, 0xFFFE, 0x0022, 0x000B, 0xFFEE, 0x000F, 0xFFEE, 0x0004,
    0xFFF2, 0xFFEC, 0xFFF4, 0x0005, 0x000C, 0xFFDE, 0xFFE9, 0xFFFB,
    0x0004, 0xFFFE, 0xFFFF, 0xFFCC, 0xFFED, 0x001A, 0xFFE9, 0xFFDD,
    0x002A, 0x002D, 0x0004, 0xFFF8, 0x0028, 0xFFFF, 0x000A, 0xFFDA,
    0x0016, 0xFFCD, 0xFFF9, 0x0009, 0x0019, 0xFFF7, 0xFFF1, 0xFFF0,
    0x0001, 0x000B, 0x001E, 0x0011, 0xFFE2, 0x000A, 0x001F, 0xFFFA,
    0x0000, 0xFFF2, 0x0008, 0x0012, 0xFFF5, 0xFFFA, 0x0014, 0xFFFB,
    0x0026, 0x0027, 0xFFF2, 0xFFE3, 0x0008, 0xFFCA, 0xFFE0, 0x0013,
    0xFFE7, 0xFFEB, 0xFFED, 0x0038, 0xFFD2, 0xFFE8, 0xFFE8, 0xFFCB,
    0x0006, 0x000C, 0xFFD6, 0xFFEF, 0xFFF3, 0xFFE4, 0xFFF0, 0xFFFF,
    0xFFF0, 0x000A, 0x000F, 0x0012, 0xFFE8, 0xFFD1, 0xFFFA, 0x0002,
    0xFFFA, 0xFFF3, 0xFFF5, 0xFFEE, 0x000D, 0xFFDE, 0x000B, 0x0011,
    0xFFD7, 0x000E, 0x0002, 0x0011, 0xFFD7, 0x0020, 0xFFF7, 0x000F,
    0x0018, 0x0002, 0x003B, 0xFFF0, 0x0007, 0x0000, 0x0004, 0xFFF4,
    0xFFFE, 0xFFE6, 0x0026, 0x0007, 0xFFD7, 0x0046, 0x000F, 0xFFD7,
    0x0015, 0x003B, 0x0013, 0x0024, 0x0011, 0xFFF6, 0xFFD2, 0xFFF8,
    0x0023, 0x000B, 0xFFF8, 0x000A, 0xFFFD, 0xFFEE, 0x001A, 0xFFF3,
    0x000E, 0x000C, 0x000F, 0x0004, 0xFFF1, 0xFFF0, 0xFFFE, 0xFFF8,
    0xFFEA, 0xFFF7, 0x0006, 0xFFF9, 0xFFF2, 0xFFE9, 0xFFF6, 0x0017,
    0xFFE9, 0xFFCC, 0xFFFA, 0xFFF9, 0x0004, 0x0025, 0xFFE3, 0xFFD7,
    0xFFFE, 0x0011, 0xFFFC, 0xFFE5, 0xFFEB, 0xFFEB, 0xFFFB, 0xFFE1,
    0xFFE9, 0x000C, 0xFFE2, 0xFFEB, 0x0000, 0xFFFE, 0x0022, 0xFFE8,
    0xFFF0, 0x001B, 0x001F, 0xFFDC, 0x0027, 0x002F, 0x0007, 0x0017,
    0x000E, 0x0026, 0xFFE4, 0x0019, 0xFFD8, 0x0009, 0xFFC9, 0x0001,
    0x0029, 0xFFE4, 0x000D, 0xFFF3, 0x0024, 0x001E, 0xFFFB, 0xFFE1,
    0xFFFC, 0x000D, 0xFFFF, 0x000B, 0x001D, 0x000E, 0xFFDB, 0xFFF9,
    0x0028, 0x0020, 0xFFD6, 0xFFEF, 0x0024, 0xFFD6, 0x000D, 0xFFFD,
    0x000A, 0x0006, 0x000C, 0x0018, 0xFFF2, 0xFFFF, 0x0016, 0x000D,
    0x0010, 0x0015, 0x0005, 0xFFFA, 0xFFE6, 0xFFFC, 0xFFF4, 0x0029,
    0xFFDA, 0x0013, 0xFFE6, 0xFFE9, 0x000E, 0xFFE1, 0xFFF0, 0x0006,
    0xFFE3, 0xFFE8, 0xFFDF, 0x0015, 0xFFEF, 0x0014, 0x0004, 0x002A,
    0x0014, 0xFFFB, 0x000B, 0xFFEF, 0x001B, 0x0017, 0x0021, 0xFFE7,
    0x001C, 0xFFF5, 0x0012, 0xFFEA, 0x000F, 0x0000, 0x0013, 0xFFEF,
    0xFFF7, 0xFFFF, 0xFFFE, 0x0007, 0x0005, 0xFFCF, 0x0028, 0xFFF1,
    0xFFFC, 0x0009, 0xFFEE, 0x0017, 0xFFFA, 0x0011, 0x001B, 0x001C,
    0x0003, 0x003F, 0x0001, 0x002D, 0xFFF5, 0xFFDC, 0xFFF8, 0xFFE9,
    0x001A, 0xFFEF, 0x0008, 0xFFDD, 0x0004, 0xFFD2, 0xFFCE, 0x0018,
    0x0009, 0xD32B, 0xFFF9, 0x0013, 0xFFF1, 0x0040, 0xFFFF, 0x0020,
    0x0028, 0x001B, 0x000E, 0xFFFF, 0x0015, 0x001D, 0xFFEE, 0xFFAB,
    0xFFE6, 0x0026, 0xFFE8, 0xFFF6, 0x0010, 0xFFFB, 0x0017, 0xFFF5,
    0xFFE8, 0x001C, 0x0036, 0x0029, 0xFFFE, 0xFFE6, 0x0001, 0x0000,
    0xFFF5, 0x0014, 0xFFCF, 0xFFFA, 0xFFF4, 0x0017, 0x000F, 0x000E,
    0xFFF1, 0xFFFC, 0x0009, 0x0008, 0x000D, 0xFFFD, 0x0008, 0x002B,
    0x0004, 0x001A, 0xFFFB, 0xFFFF, 0x000E, 0x001E, 0x0005, 0x0006,
    0x0007, 0x0034, 0xFFF9, 0xFFE4, 0xFFFC, 0xFFE1, 0x001A, 0x0001,
    0xFFF8, 0x0033, 0xFFDC, 0xFFDF, 0xFFFA, 0xFFF2, 0xFFF8, 0x0010,
    0x001B, 0x0011, 0xFFE0, 0xFFF8, 0x000D, 0xFFDF, 0x000D, 0xFFED,
    0x0020, 0x0013, 0xFFFC, 0xFFE3, 0x0000, 0xFFF3, 0x0024, 0x0012,
    0x0008, 0xFFF4, 0xFFFA, 0xFFC4, 0x001C, 0x0027, 0x002D, 0x0005,
    0xFFE6, 0x000F, 0xFFF3, 0x0020, 0xFFEE, 0xFFFD, 0xFFEC, 0x0013,
    0x0018, 0xFFFA, 0xFFFA, 0x000E, 0x000C, 0x0009, 0x0020, 0x000E,
    0xFFDF, 0xFFF2, 0xFFCB, 0xFFFF, 0xFFFB, 0xFFDE, 0xFFEE, 0xFFD7,
    0xFFF6, 0x0004, 0xFFE3, 0x0027, 0x0012, 0xFFDB, 0xFFDB, 0xFFF7,
    0xFFEF, 0xFFFE, 0x000D, 0xFFD5, 0xFFF1, 0x0008, 0x000C, 0x0003,
    0xFFDF, 0xFFE8, 0x0004, 0xFFE4, 0xFFE1, 0x001D, 0xFFE5, 0xFFFC,
    0x0008, 0xFFDC, 0xFFE2, 0xFFE4, 0xFFED, 0x000C, 0xFFE1, 0x0001,
    0xFFE8, 0x0010, 0xFFEA, 0x000B, 0xFFE5, 0xFFE7, 0x0019, 0xFFFC,
    0x0010, 0x001D, 0x0026, 0x001D, 0x0008, 0xFFE5, 0xFFEC, 0xFFD0,
    0x0006, 0x0012, 0x000E, 0xFFF6, 0xFFD4, 0xFFE6, 0xFFFC, 0xFFD5,
    0x002E, 0xFFD8, 0xFFFB, 0xFFE5, 0xFFFE, 0x000A, 0x001A, 0x0018,
    0xFFE1, 0xFFF7, 0x0005, 0x0012, 0xFFFE, 0x000C, 0x000E, 0x000B,
    0xFFC4, 0x0013, 0x0019, 0xFFFB, 0x001E, 0xFFFC, 0xFFF4, 0xFFF4,
    0xFFE2, 0xFFE0, 0xFFFD, 0x0032, 0x0017, 0xFFED, 0xFFF2, 0x000F,
    0xFFEF, 0xFFD9, 0x0001, 0x000F, 0xFFFD, 0xFFEB, 0xFFEA, 0x0003,
    0x002A, 0xFFDF, 0x002F, 0xFFF2, 0xFFF6, 0xFFF2, 0xFFE8, 0x001D,
    0x0020, 0x0018, 0xFFC3, 0x000C, 0x0005, 0x0012, 0x0000, 0xFFDE,
    0x0003, 0x001A, 0x000C, 0x0007, 0x0025, 0x0014, 0xFFF2, 0xFFFC,
    0x000E, 0xFFFA, 0xFFF3, 0xFFD3, 0xFFD7, 0xFFF0, 0x0013, 0x0016,
    0x0008, 0x000E, 0x0038, 0xFFFA, 0xFFDF, 0x0006, 0x0013, 0x001B,
    0x002F, 0xFFFE, 0x001B, 0xFFE3, 0x0022, 0xFFF9, 0x000D, 0x0007,
    0x0018, 0xFFF0, 0x0041, 0x0011, 0xFFF3, 0xFFE0, 0x000E, 0x0026,
    0x0010, 0xFFF9, 0xFFDF, 0x0001, 0xFFC7, 0xFFF6, 0xFFEA, 0x000A,
    0x000C, 0x0008, 0xFFF5, 0xFFEA, 0x0016, 0x000C, 0x0015, 0xFFE7,
    0xFFE4, 0x0014, 0x000D, 0xFFF1, 0x0005, 0xFFF4, 0x0007, 0xFFE1,
    0xFFBE, 0xFFE3, 0x000C, 0x0009, 0x0002, 0xFFF9, 0x0027, 0xFFEF,
    0x002B, 0xFFFD, 0xFFF6, 0x000E, 0x000B, 0x0001, 0xFFEC, 0x001C,
    0x0029, 0xFFE6, 0x001D, 0xFFF0, 0x0021, 0x0016, 0xFFF7, 0x000F,
    0x0000, 0xFFFD, 0x0015, 0x000E, 0x0002, 0x0036, 0x0023, 0xFFE5,
    0xFFE5, 0x0003, 0x0004, 0xFFE9, 0x0009, 0xFFEE, 0xFFD9, 0x0016,
    0x0017, 0x0010, 0x0001, 0x0003, 0xFFF4, 0xFFEF, 0x0015, 0x000F,
    0xFFDD, 0x000A, 0xFFF2, 0x0010, 0x000A, 0x0008, 0xFFCB, 0xFFE4,
    0xFFF7, 0x001D, 0xFFC9, 0x000E, 0xFFF0, 0xFFED, 0x0000, 0xFFEE,
    0x0009, 0xFFE0, 0x0020, 0xFFF4, 0xFFE9, 0xFFD0, 0xFFF6, 0x0017,
    0xFFCE, 0x0012, 0xFFFD, 0x002A, 0x0009, 0xFFF9, 0x003B, 0x0015,
    0x0026, 0xFFD9, 0xFFF4, 0x002D, 0xFFDE, 0x0002, 0x0033, 0x001E,
    0x0010, 0xFFFF, 0xFFDC, 0xFFE9, 0x0000, 0x0021, 0xFFE5, 0xFFF0,
    0x0020, 0xFFFE, 0xFFD8, 0xFFEE, 0xFFE3, 0xFFDC, 0xFFF6, 0x0006,
    0x001F, 0xFFFB, 0x0026, 0xFFE6, 0x0033, 0x0000, 0xFFFE, 0x0007,
    0xFFEF, 0x0012, 0xFFF0, 0xFFE5, 0x0007, 0x0007, 0xFFDC, 0xFFF7,
    0xFFCF, 0x0012, 0x0012, 0xFFE2, 0x0007, 0xFFF2, 0xFFFE, 0xFFF3,
    0xFFF3, 0xFFFA, 0x0007, 0x0011, 0x0025, 0xFFE8, 0x0025, 0xFFF7,
    0xFFFC, 0xFFFB, 0xFFF9, 0xFFEB, 0xFFF9, 0x0004, 0x0011, 0xFFFB,
    0x000B, 0xFFDB, 0x002C, 0xFFD9, 0x0003, 0x0035, 0xFFEF, 0xFFEE,
    0x000F, 0xFFFE, 0x0015, 0x0013, 0x0015, 0x0018, 0xFFF9, 0x0028,
    0x0004, 0xFFF0, 0xFFE9, 0x0030, 0x0014, 0x000E, 0xFFEA, 0x001E,
    0xFFFB, 0xFFD8, 0xFFED, 0xFFF1, 0xFFE8, 0x003B, 0x0025, 0xFFCB,
    0xFFFF, 0xFFF5, 0xFFFB, 0xFFED, 0xFFD2, 0x001F, 0x0027, 0x002A,
    0x0000, 0x0041, 0x0002, 0xFFFB, 0xFFE9, 0xFFFF, 0x000E, 0xFFE8,
    0xFFC2, 0xFFDD, 0xFFEE, 0xFFFB, 0x000E, 0x0013, 0xFFFF, 0x002D,
    0x001E, 0xFFE6, 0xFFE4, 0xFFFD, 0xFFF5, 0xFFDA, 0x0014, 0xFFD9,
    0xFFF5, 0xFFF4, 0xFFF1, 0x001A, 0xFFC8, 0xFFF0, 0xFFF2, 0x000D,
    0x000B, 0x0013, 0xFFF7, 0xFFD0, 0x0007, 0xFFF3, 0xFFF2, 0xFFDE,
    0x0033, 0xFFF1, 0xFFF2, 0xFFF2, 0xFFE9, 0xFFFC, 0x0002, 0xFFE7,
    0xFFF7, 0xFFFB, 0x0000, 0xFFFA, 0x000C, 0xFFBE, 0x0002, 0xFFF7,
    0x0006, 0x0010, 0xFFFF, 0xFFE5, 0xFFE0, 0x0013, 0xFFEE, 0xFFE8,
    0x0002, 0x0009, 0x0002, 0xFFF2, 0xFFF8, 0x000B, 0x002B, 0xFFB5,
    0x000C, 0xFFDB, 0x001D, 0xFFE4, 0x0009, 0xFFE0, 0xFFF3, 0xFFFB,
    0x0035, 0x0006, 0xFFD8, 0x0018, 0x0027, 0xFFEE, 0x0008, 0x000B,
    0xFFCE, 0xFFF6, 0xFFF1, 0x001B, 0x000A, 0xFFF5, 0x0026, 0x001E,
    0xFFF6, 0xFFED, 0x0002, 0x002A, 0xFFD9, 0xFFFC, 0xFFF3, 0x0011,
    0x0020, 0xFFF3, 0x0000, 0x0008, 0xFFE8, 0xFFF7, 0xFFE0, 0xFFBE,
    0x001D, 0xFFCE, 0x0058, 0xFFE0, 0x0000, 0xFFED, 0x0017, 0xFFE3,
    0x0006, 0x0035, 0x0015, 0xFFF7, 0xFFF7, 0x0007, 0xFFEF, 0xFFF4,
    0x002D, 0x0007, 0xFFFC, 0xFFED, 0x0009, 0xFFE5, 0xFFF9, 0x0005,
    0x0010, 0xFFCA, 0x0023, 0xFFFA, 0x0006, 0x0007, 0xFFF7, 0xFFFE,
    0xFFFF, 0x0010, 0x0032, 0xFFF5, 0xFFFB, 0x0011, 0x0014, 0x0029,
    0x000D, 0xFFEA, 0x0015, 0xFFFC, 0x0001, 0xFFDC, 0xFFD8, 0xFFFF,
    0x0022, 0xFFD5, 0xFFDD, 0x002E, 0xFFE8, 0x002B, 0xFFEC, 0x0002,
    0x0026, 0x0016, 0x001A, 0xFFE4, 0x002E, 0xFFDF, 0xFFF1, 0xFFF5,
    0xFFFF, 0x0032, 0x003B, 0xFFF0, 0x0005, 0xFFE4, 0xFFEA, 0x0005,
    0x0017, 0xFFE3, 0x0019, 0x0026, 0xFFF2, 0xFFEC, 0xFFE7, 0x0010,
    0x000F, 0xFFDA, 0x0001, 0xFFDB, 0x0006, 0xFFF0, 0x0003, 0xFFF4,
    0xFFCC, 0x0002, 0xFFE6, 0xFFE6, 0xFFF4, 0x0019, 0xFFF5, 0x0015,
    0xFFE1, 0x001B, 0x001F, 0x0011, 0xFFEC, 0xFFF4, 0x0005, 0xFFD2,
    0xFFF0, 0x0000, 0x0018, 0xFFFA, 0xFFEE, 0x0037, 0xFFF8, 0x0032,
    0xFFE6, 0xFFFF, 0x0004, 0xFFE8, 0x0011, 0xFFF5, 0x000F, 0xFFF2,
    0xFFFB, 0xFFDD, 0xFFF9, 0x001B, 0xFFFC, 0x0008, 0x0029, 0xFFF0,
    0x0003, 0x001A, 0xFFEC, 0xFFEA, 0xFFC0, 0x002A, 0xFFFA, 0x0013,
    0x0019, 0xFFF0, 0x0003, 0xFFFE, 0x000E, 0x000E, 0x0009, 0x0036,
    0xFFED, 0x000B, 0x0007, 0x0008, 0xFFFB, 0x0003, 0x0028, 0x0004,
    0xFFEF, 0x000E, 0x0006, 0xFFE0, 0xFFFC, 0xFFF7, 0xFFF6, 0xFFD4,
    0xFFDA, 0x0000, 0x0003, 0x0000, 0xFFE2, 0x000F, 0x0012, 0x0017,
    0xFFF2, 0x0006, 0xFFF3, 0xFFF4, 0xFFF7, 0xFFF9, 0xFFE6, 0xFFF9,
    0x0003, 0x0038, 0xFFC5, 0x0016, 0xFFE4, 0x0013, 0xFFF2, 0xFFC3,
    0xFFFD, 0x000E, 0xFFCB, 0xFFF9, 0x0013, 0x0031, 0x001D, 0xFFFB,
    0xFFE6, 0xFFFC, 0xFFF8, 0x0007, 0xFFFE, 0x0008, 0xFFF9, 0x0009,
    0xFFDD, 0xFFE9, 0x001A, 0x000F, 0x0019, 0xFFE1, 0x0006, 0xFFF2,
    0x001D, 0x0011, 0xFFFD, 0xFFEA, 0x0008, 0x0026, 0xFFF7, 0xFFE8,
    0xFFE8, 0xFFDE, 0xFFD8, 0x0026, 0x000D, 0x000D, 0xFFF4, 0x001B,
    0xFFF1, 0x0010, 0xFFDB, 0xFFE2, 0xFFF7, 0x0020, 0x000B, 0x0010,
    0x0002, 0xFFE5, 0x0018, 0x000C, 0x0012, 0xFFEE, 0x0024, 0xFFE9,
    0x0001, 0xFFFC, 0xFFFE, 0xFFF9, 0x0003, 0x000C, 0x0002, 0xFFF5,
    0x0006, 0xFFF0, 0xFFEC, 0x0012, 0x000E, 0xFFE8, 0xFFD5, 0x0016,
    0xFFF1, 0x0005, 0x0036, 0xFFFB, 0xFFF7, 0x0007, 0x0025, 0xFFF6,
    0x0016, 0xFFF1, 0xFFEF, 0xFFC6, 0x0006, 0x001F, 0x0023, 0x0002,
    0x000A, 0x000F, 0x0000, 0xFFDB, 0xFFD9, 0x000D, 0x0024, 0x0011,
    0x0022, 0xFFDC, 0x0001, 0xFFF6, 0xFFE2, 0xFFF8, 0x0003, 0xFFE2,
    0xFFE7, 0xFFF0, 0x0010, 0x0012, 0xFFD1, 0xFFEE, 0x0002, 0xFFD3,
    0xFFFA, 0x000A, 0x0011, 0x0040, 0x0004, 0x000D, 0x000C, 0x0018,
    0x0007, 0x000F, 0x0029, 0xFFDA, 0xFFD6, 0xFFFB, 0xFFE2, 0xFFED,
    0xFFF4, 0x000A, 0x0019, 0x0005, 0xFFEF, 0xFFF9, 0xFFFE, 0x0020,
    0x001A, 0xFFF5, 0x000E, 0xFFED, 0x0000, 0x0026, 0xFFDA, 0xFFCB,
    0x0005, 0xFFDD, 0xFFF5, 0x000D, 0xFFE9, 0x0001, 0xFFE4, 0x000B,
    0x0019, 0x001D, 0xFFCC, 0x000C, 0xFFE5, 0xFFD8, 0xFFFA, 0xFFE4,
    0xFFFC, 0x002A, 0x0019, 0xFFEC, 0x001B, 0x0004, 0xFFD1, 0xFFFE,
    0xFFF1, 0xFFFE, 0xFFB3, 0x001D, 0xFFE7, 0x0004, 0xFFFF, 0xFFFF,
    0x0021, 0xFFE9, 0xFFF4, 0x0009, 0xFFFE, 0xFFFB, 0x0014, 0xFFD3,
    0xFFE9, 0xFFD7, 0x0011, 0x000B, 0x0021, 0x0038, 0xFFFF, 0x0009,
    0x0004, 0x002B, 0xFFF0, 0x0015, 0x0023, 0x000F, 0x001D, 0xFFE5,
    0xFFE3, 0x000C, 0x001E, 0xFFFC, 0x0004, 0x000F, 0x0017, 0xFFF5,
    0xFFF7, 0x0014, 0xFFEB, 0xFFF9, 0xFFFA, 0xFFFE, 0x000B, 0x0012,
    0x000C, 0x000D, 0x0027, 0xFFE2, 0x002B, 0xFFE6, 0x0014, 0xFFF5,
    0xFFDC, 0xFFF7, 0x002C, 0xFFF9, 0xFFF5, 0x0005, 0x0002, 0x0018,
    0x000C, 0xFFE2, 0x0019, 0xFFE1, 0x001D, 0x002F, 0xFFFA, 0xFFF1,
    0x0016, 0xFFFE, 0x0005, 0x0004, 0xFFFC, 0x000E, 0x0017, 0xFFF4,
    0x0003, 0xFFF8, 0x000B, 0x0007, 0xFFE1, 0x0017, 0xFFE0, 0x000B,
    0xFFD1, 0xFFFF, 0x0014, 0x0010, 0xFFF9, 0x000E, 0x0020, 0xFFDD,
    0x001C, 0xFFFE, 0x000D, 0xFFF0, 0xFFE7, 0xFFEF, 0x0003, 0xFFF6,
    0xFFCF, 0x0003, 0xFFFE, 0xFFF1, 0xFFF1, 0x000D, 0xFFFC, 0x0004,
    0xFFE6, 0x001B, 0x0010, 0xFFE7, 0x000E, 0x0010, 0x0019, 0xFFF2,
    0x000B, 0xFFEE, 0xFFD8, 0xFFE4, 0x0029, 0x000F, 0x003E, 0x000E,
    0x001A, 0xFFE8, 0x000F, 0x0017, 0x0007, 0x0036, 0xFFED, 0xFFFB,
    0x0005, 0x0000, 0x0008, 0x0016, 0x0024, 0x0008, 0xFFEB, 0xFFF5,
    0xFFFD, 0xFFEA, 0x0028, 0xFFEA, 0x0002, 0x0034, 0xFFE8, 0x0017,
    0x0010, 0xFFFB, 0xFFD1, 0xFFF8, 0x001C, 0x000E, 0x0006, 0xFFDF,
    0xFFEF, 0x000D, 0xFFF9, 0xFFFC, 0xFFFB, 0xFFF3, 0x0004, 0xFFE5,
    0xFFE6, 0x0011, 0xFFCD, 0x0034, 0xFFF6, 0x0002, 0xFFA6, 0x002C,
    0x001A, 0xFFF0, 0xFFF2, 0x000D, 0x0037, 0x0023, 0xFFE2, 0x0018,
    0x0020, 0x000C, 0x001D, 0x0011, 0x001D, 0xFFE0, 0x0001, 0xFFFE,
    0x0006, 0xFFD8, 0xFFF7, 0x0019, 0xFFCF, 0x0012, 0x0030, 0x000C,
    0x0042, 0xFF98, 0x001E, 0xFFE5, 0x0002, 0xFFF2, 0x0000, 0xFFEF,
    0x0005, 0xFFFA, 0x0022, 0xFFF4, 0x0020, 0x0008, 0x001F, 0x000B,
    0xFFEE, 0xFFC2, 0x0038, 0x001D, 0xFFBE, 0x002D, 0x0014, 0xFFF8,
    0xFFFC, 0x0023, 0xFFD7, 0xFFE1, 0xFFF1, 0x000F, 0x0011, 0x0015,
    0xFFDA, 0x0018, 0x0000, 0x000B, 0x0002, 0x0009, 0x000D, 0xFFF2,
    0x0005, 0x0019, 0x0019, 0x0034, 0x0010, 0xFFF1, 0xFFF9, 0x000E,
    0xFFFB, 0xFFFC, 0x0027, 0xFFF2, 0x0028, 0xFFF6, 0xFFED, 0x000F,
    0xFFFB, 0xFFE9, 0x0002, 0x0025, 0x000D, 0xFFEF, 0x0010, 0x002D,
    0x001D, 0xFFE6, 0xFFFE, 0x0004, 0xFFF8, 0xFFFB, 0xFFF8, 0xFFE9,
    0x0000, 0xFFD7, 0x000D, 0x0007, 0xFFEC, 0xFFDD, 0x000B, 0x0009,
    0xFFEE, 0x001B, 0xFFF3, 0xFFE7, 0x0005, 0x0002, 0xFFF2, 0x0024,
    0xFFCD, 0x000C, 0x001C, 0xFFF4, 0x000B, 0xFFE5, 0x0021, 0x0017,
    0x0004, 0x0009, 0xFFF9, 0xFFF8, 0xFFF7, 0xFFED, 0xFFEF, 0x000F,
    0x000A, 0x000B, 0xFFF6, 0x0005, 0x0004, 0x000B, 0x0003, 0xFFEB,
    0xFFF1, 0xFFF4, 0x0007, 0xFFE8, 0x0016, 0x000C, 0x001A, 0x0007,
    0xFFF3, 0x001C, 0xFFE7, 0xFFD1, 0xFFD1, 0x0026, 0x0006, 0xFFF3,
    0x0015, 0xFFF3, 0x0014, 0x0001, 0x0008, 0x0022, 0xFFE6, 0xFFF1,
    0xFFE8, 0x0025, 0x000F, 0x0004, 0x0011, 0x0005, 0x001F, 0xFFC6,
    0xFFDB, 0xFFEA, 0x0007, 0x002B, 0x0001, 0x0023, 0x001B, 0xFFEF,
    0x0003, 0xFFDD, 0xFFF4, 0x001B, 0x001A, 0x0006, 0x001A, 0x0019,
    0x0022, 0xFFF7, 0x002C, 0x004F, 0xFFEE, 0xFFDE, 0xFFEB, 0xFFCD,
    0xFFF0, 0xFFE3, 0x0000, 0xFFDB, 0x0039, 0x0004, 0xFFE7, 0xFFD1,
    0xFFD2, 0xFFE2, 0x0008, 0xFFFF, 0xFFED, 0x000D, 0x000A, 0xFFF5,
    0xFFC8, 0x0006, 0x002B, 0x0034, 0xFFD6, 0xFFC0, 0x0015, 0x000D,
    0xFFF0, 0x0012, 0x0026, 0xFFEA, 0x0006, 0xFFDD, 0x0019, 0x0000,
    0xFFE3, 0xFFEC, 0xFFE0, 0xFFF1, 0x000A, 0xFFFC, 0xFFCF, 0x0037,
    0xFFD3, 0x0001, 0xFFFB, 0x0028, 0x0002, 0x0011, 0xFFFD, 0xFFEB,
    0xFFFA, 0x000A, 0xFFFF, 0xFFF2, 0x001C, 0x0013, 0x0003, 0x0015,
    0x0027, 0x002E, 0x000B, 0xFFF3, 0xFFFD, 0xFFD5, 0xFFFA, 0x0003,
    0xFFF5, 0x0001, 0x0029, 0x0000, 0x000A, 0xFFFF, 0xFFF5, 0x000F,
    0x000D, 0xFFF8, 0xFFFD, 0xFFFB, 0xFFFA, 0x001A, 0xFFF1, 0xFFEF,
    0x0010, 0x0025, 0xFFFC, 0x003F, 0x0017, 0xFFFB, 0x0013, 0xFFFC,
    0xFFEF, 0xFFEA, 0x0015, 0x0003, 0x0000, 0x001D, 0x000A, 0x0002,
    0x0005, 0xFFC7, 0x0014, 0x000E, 0xFFF3, 0x002B, 0xFFF9, 0xFFFF,
    0x0004, 0xFFE5, 0x0036, 0xFFF8, 0x000E, 0x0008, 0x0003, 0xFFE1,
    0xFFFA, 0xFFDA, 0x0006, 0x0022, 0xFFDE, 0x001B, 0xFFFA, 0x0008,
    0xFFE7, 0xFFE6, 0x000B, 0xFFEF, 0x0007, 0xFFFC, 0x000D, 0xFFF4,
    0x0040, 0x0023, 0x001A, 0x000E, 0xFFE5, 0xFFFB, 0x0011, 0xFFD3,
    0xFFDC, 0xFFD8, 0x0023, 0x0000, 0x002F, 0xFFEA, 0x000C, 0xFFEA,
    0xFFF1, 0x0018, 0x0006, 0xFFCC, 0x0009, 0xFFE2, 0x0009, 0x000F,
    0xFFFB, 0x0012, 0x0008, 0xFFE6, 0xFFE8, 0x000D, 0x000B, 0x0023,
    0xFFF3, 0xFFFE, 0xFFE4, 0x0007, 0xFFFE, 0x0005, 0xFFF4, 0x0011,
    0xFFFF, 0x002E, 0x001A, 0x000C, 0x0002, 0x0008, 0x001D, 0x0008,
    0x0009, 0x001C, 0x001F, 0x000D, 0xFFFE, 0x0003, 0x0029, 0xFFDE,
    0x001C, 0xFFEA, 0x001B, 0x0007, 0x000C, 0xFFF4, 0xFFF9, 0x0025,
    0xFFC6, 0xFFEF, 0xFFC5, 0x0010, 0x001F, 0xFFF3, 0xFFD0, 0xFFE8,
    0xFFFF, 0xFFF7, 0x001F, 0x0009, 0x0048, 0xFFD1, 0xFFF3, 0xFFDE,
    0xFFD5, 0x000A, 0xFFE3, 0xFFEE, 0xFFF2, 0x001F, 0x0023, 0x0009,
    0xFFF9, 0xFFDE, 0xFFEF, 0x0000, 0xFFE3, 0x000F, 0x0022, 0xFFFA,
    0x000E
    };

static const q15_t in_rfft_noisy_4096[4096] = {
    0x0992, 0x3CEE, 0x5AFC, 0x4498, 0xFC69, 0xCC53, 0xA535, 0xC375,
    0xFEC8, 0x3825, 0x4F98, 0x45F6, 0xFF7C, 0xC3CC, 0xA7A5, 0xBE60,
    0xFE78, 0x422A, 0x62BE, 0x357E, 0x05BF, 0xB068, 0xAAAC, 0xBA77,
    0x023F, 0x4ACD, 0x5A07, 0x3E39, 0x0A7E, 0xB8FF, 0xA474, 0xBF07,
    0xFE59, 0x3CFA, 0x5B1E, 0x362D, 0xFD0A, 0xB9AD, 0xA43A, 0xBE0A,
    0x0A7C, 0x446B, 0x56DE, 0x3921, 0x0160, 0xBFDD, 0xA6CD, 0xB919,
    0x03A9, 0x451F, 0x5627, 0x4CEB, 0x0B98, 0xC3F7, 0xA6CD, 0xBB4B,
    0x011B, 0x3911, 0x580B, 0x45E7, 0xF975, 0xBBA2, 0xAD5A, 0xBFF9,
    0xF3FA, 0x3951, 0x5A87, 0x4164, 0x05BD, 0xBF40, 0xA4FD, 0xC48B,
    0xF31C, 0x4842, 0x601E, 0x3A90, 0xF917, 0xD278, 0xA467, 0xC0A5,
    0xF431, 0x344B, 0x62A2, 0x3D88, 0x07FF, 0xC19D, 0xA7AE, 0xB685,
    0xFF64, 0x31C2, 0x5A54, 0x3A60, 0xF7FE, 0xB627, 0x9C33, 0xCA44,
    0xFC5F, 0x40E0, 0x5B43, 0x4196, 0x02FD, 0xC0C7, 0xAF91, 0xC0DE,
    0xFDC9, 0x4527, 0x51E7, 0x4105, 0xFAF0, 0xC3AC, 0xB202, 0xC2FB,
    0xF4C9, 0x49A7, 0x6A45, 0x4076, 0x0313, 0xC2FD, 0x9EC3, 0xC0D1,
    0x00BA, 0x3FC1, 0x5859, 0x46D0, 0x00EE, 0xBDC1, 0xA5D4, 0xC256,
    0x108A, 0x4733, 0x51D9, 0x3ACB, 0xF1C4, 0xB756, 0xA0C4, 0xC52D,
    0x0284, 0x4198, 0x4CCD, 0x3F64, 0xFC28, 0xBB85, 0x97AB, 0xD0F5,
    0xFA50, 0x3DAE, 0x580E, 0x3926, 0x0294, 0xC4C5, 0xAA44, 0xBACF,
    0x0780, 0x3F31, 0x5E5E, 0x491E, 0xFFE0, 0xBC5F, 0xA817, 0xBF9C,
    0xFE66, 0x46A9, 0x53E2, 0x4153, 0xFE68, 0xC014, 0xA949, 0xC1CF,
    0xFF94, 0x3CBE, 0x6028, 0x3BA7, 0xF56B, 0xBC6D, 0xA28F, 0xC45A,
    0x01C4, 0x455C, 0x5CBF, 0x3FE5, 0x02E7, 0xC2D2, 0xA466, 0xB940,
    0xF65E, 0x3725, 0x558E, 0x313F, 0xFC4B, 0xBF61, 0x97CE, 0xC39B,
    0xFEB0, 0x3D59, 0x57F3, 0x4103, 0x0120, 0xC2EB, 0x9AB3, 0xC209,
    0xFEFA, 0x3EF0, 0x64F7, 0x4AD5, 0xFF5A, 0xC63D, 0xACEC, 0xC04D,
    0x05E1, 0x3F80, 0x5A58, 0x43D4, 0x0A58, 0xBA09, 0xAE9A, 0xC476,
    0xFA76, 0x36B6, 0x5A67, 0x410C, 0x01ED, 0xCD52, 0xA3F7, 0xBD08,
    0x04A6, 0x40B7, 0x5442, 0x400E, 0x0063, 0xBB93, 0xA6A6, 0xC4E5,
    0x0A78, 0x49BE, 0x5909, 0x42BB, 0xF6F7, 0xC433, 0xA7C8, 0xC5F0,
    0x0AFA, 0x458D, 0x6096, 0x4AE6, 0x05CE, 0xB7AC, 0xA1E0, 0xC035,
    0xFE10, 0x3391, 0x5ED0, 0x4242, 0xF8C7, 0xB475, 0xAC26, 0xC059,
    0xF68B, 0x3DE0, 0x579B, 0x4AE0, 0xFE77, 0xC748, 0xB0E8, 0xCA4E,
    0xFD38, 0x4D63, 0x62CF, 0x455D, 0xFB2C, 0xC7B4, 0xA8DC, 0xBD28,
    0xF7B8, 0x3EFB, 0x545B, 0x441A, 0x04C7, 0xBC8A, 0x98B7, 0xB5C5,
    0x077B, 0x4C02, 0x5808, 0x4199, 0xFEF7, 0xC163, 0xA5D2, 0xB3B0,
    0x04FA, 0x41EE, 0x6180, 0x3376, 0xF7BC, 0xBF46, 0xAC7B, 0xBCB8,
    0xFE39, 0x3D4A, 0x5128, 0x3BE9, 0xF91A, 0xBFAC, 0x9D31, 0xB86B,
    0xFCA4, 0x486F, 0x509F, 0x448B, 0xFBD3, 0xC254, 0xA726, 0xC29B,
    0x038B, 0x4639, 0x52A3, 0x48B1, 0xFE07, 0xBBBA, 0xAAAF, 0xBE53,
    0x0526, 0x3F97, 0x546C, 0x4084, 0xEF64, 0xBD7B, 0xA05A, 0xC1C2,
    0x068D, 0x41CF, 0x5651, 0x42D9, 0x00CA, 0xB678, 0xA1F6, 0xC4F2,
    0x007C, 0x4934, 0x605F, 0x40F7, 0xF654, 0xC574, 0xA53A, 0xBA9D,
    0x00D5, 0x395A, 0x54DD, 0x3DAB, 0xFAA4, 0xB636, 0xA41F, 0xC42A,
    0x02D1, 0x41EB, 0x5C58, 0x405F, 0xFAE1, 0xC98B, 0xACDB, 0xC125,
    0x05EA, 0x37AC, 0x52D7, 0x3F31, 0x018D, 0xBDD7, 0x9DF8, 0xBC87,
    0xF6CA, 0x3C42, 0x5C75, 0x3BB3, 0x08AC, 0xBA97, 0xA2B3, 0xBA60,
    0x0683, 0x4748, 0x546C, 0x332E, 0x01FB, 0xB084, 0xAE10, 0xCA43,
    0xFBCA, 0x42B3, 0x58EA, 0x429D, 0xF7A4, 0xC48A, 0xA77B, 0xBEB0,
    0x0B5A, 0x39D1, 0x52A0, 0x46A5, 0x05BB, 0xBCE0, 0xA92A, 0xBEE4,
    0xFABA, 0x3B88, 0x55A7, 0x425B, 0xF9B7, 0xC6F8, 0xAAAD, 0xC678,
    0x03CF, 0x39ED, 0x6096, 0x4AEC, 0x074F, 0xC193, 0xAB38, 0xBC29,
    0x0602, 0x44CB, 0x57A6, 0x4021, 0xFC12, 0xBBEC, 0xADF7, 0xC145,
    0x0F74, 0x3997, 0x5A42, 0x326B, 0xFD9D, 0xB913, 0xA5F0, 0xCFF0,
    0x0697, 0x3F5B, 0x5B97, 0x413F, 0x036D, 0xC529, 0xAFAC, 0xC8F6,
    0xF9A5, 0x4A27, 0x5286, 0x4241, 0xFE66, 0xBA9C, 0xB4B9, 0xC08E,
    0x0A6E, 0x4060, 0x600E, 0x4752, 0xFFD0, 0xBCA2, 0xA5D4, 0xC2F9,
    0x00B7, 0x3038, 0x6402, 0x4321, 0xF894, 0xBAAD, 0x9F38, 0xCB85,
    0x0453, 0x439F, 0x5043, 0x4680, 0xF629, 0xBA01, 0xA7D4, 0xBD86,
    0xFCD8, 0x3934, 0x566C, 0x3E8E, 0x0000, 0xBB13, 0xA35B, 0xBE96,
    0x025D, 0x4491, 0x56CD, 0x435C, 0x04BE, 0xC1A9, 0xA30C, 0xBAFC,
    0xFEBF, 0x3E8A, 0x5C46, 0x410B, 0x0453, 0xC9A9, 0x9DB8, 0xB9C7,
    0x0106, 0x4707, 0x5D62, 0x39F1, 0x09B6, 0xC477, 0xAE5D, 0xC202,
    0xF639, 0x3C48, 0x58D7, 0x3520, 0xF3FD, 0xB537, 0xAF11, 0xC51D,
    0x01EB, 0x4240, 0x590C, 0x3D3B, 0x00BC, 0xC251, 0xAF53, 0xBD2F,
    0xF3CC, 0x3E18, 0x616E, 0x3C2E, 0x030B, 0xC57E, 0xA0E2, 0xBEBA,
    0x0151, 0x4540, 0x5D42, 0x4461, 0xFEE0, 0xC4E6, 0xAA48, 0xBBAC,
    0x00A5, 0x4802, 0x6400, 0x3993, 0x08CE, 0xB8F4, 0xA747, 0xC80E,
    0x0922, 0x39CE, 0x57C8, 0x4645, 0x0222, 0xBE17, 0xA57D, 0xBD98,
    0x022B, 0x4B47, 0x5805, 0x4055, 0x0A3F, 0xC9E8, 0xAAA2, 0xC3D7,
    0xFC7E, 0x3460, 0x59DB, 0x408E, 0x0611, 0xBEE8, 0x9863, 0xCEF8,
    0xFA45, 0x38F0, 0x5CDB, 0x42F8, 0xFD81, 0xB84A, 0xA2DC, 0xC8ED,
    0x00CA, 0x49F5, 0x5C4F, 0x49DA, 0xFD13, 0xC29A, 0xA883, 0xC9D2,
    0xF975, 0x4544, 0x5DE7, 0x4B3F, 0xF697, 0xB82F, 0xB1FA, 0xBEA1,
    0x00E9, 0x3C22, 0x538D, 0x4659, 0x0A68, 0xBDFB, 0xA88A, 0xC575,
    0xFCCE, 0x3A01, 0x4F1E, 0x461D, 0x019F, 0xC3E3, 0xA00D, 0xC3EA,
    0xFE89, 0x45CC, 0x5243, 0x3555, 0x0713, 0xC41C, 0xADBC, 0xC71A,
    0xFCCD, 0x3DE4, 0x565A, 0x41C0, 0x030F, 0xC39E, 0xA537, 0xB7A3,
    0xF615, 0x32B7, 0x5AAE, 0x3DA6, 0x03D9, 0xBE05, 0xB13B, 0xC7B6,
    0x0622, 0x48C0, 0x5519, 0x3ECC, 0x072A, 0xB784, 0xADFD, 0xC04F,
    0x034B, 0x3D66, 0x5BF4, 0x3B5D, 0x02F7, 0xC504, 0xA0FB, 0xBD1A,
    0xFFDD, 0x4382, 0x58DA, 0x4CD0, 0x032F, 0xC0CF, 0xAE5E, 0xBF95,
    0xF7CA, 0x3BCE, 0x4E6C, 0x3DBB, 0x0730, 0xC8E4, 0xA9CD, 0xC40E,
    0xFB41, 0x3D84, 0x5692, 0x4371, 0x0309, 0xC75C, 0xA529, 0xBE68,
    0xFED7, 0x4C4B, 0x5868, 0x4610, 0x04A6, 0xBC76, 0xA734, 0xBC87,
    0xFB83, 0x3DEE, 0x540B, 0x409C, 0x0004, 0xC2D1, 0xACCA, 0xBE65,
    0xFDA8, 0x3B23, 0x5560, 0x4555, 0x0294, 0xC7AB, 0xA6E5, 0xBCD7,
    0xFA19, 0x4A47, 0x6215, 0x451D, 0x0579, 0xC3E7, 0xAC6B, 0xBB16,
    0x0137, 0x3D7D, 0x59CB, 0x3D70, 0x0719, 0xB649, 0xB3F3, 0xC596,
    0xF48C, 0x430B, 0x6903, 0x3A1A, 0xFD10, 0xBBB3, 0xA2CA, 0xBE94,
    0xFA64, 0x450C, 0x5FF1, 0x3FD9, 0x054C, 0xBFC7, 0xAC03, 0xC854,
    0x0252, 0x3FBF, 0x595B, 0x443F, 0x08DC, 0xC1EB, 0xA6AC, 0xBBAF,
    0xEFCF, 0x3D93, 0x5978, 0x39AC, 0xFE38, 0xC5B0, 0xA4F7, 0xBDC6,
    0xF133, 0x415F, 0x5CDC, 0x4427, 0x05AD, 0xBAF3, 0xAFFA, 0xC7DD,
    0xF737, 0x484C, 0x5841, 0x421B, 0xFCAC, 0xC343, 0xA33C, 0xB878,
    0xEF9F, 0x3FC8, 0x5325, 0x3C97, 0xFE1E, 0xB7CD, 0xA39E, 0xB710,
    0x059F, 0x3E75, 0x60D4, 0x3A95, 0x06F3, 0xC4FA, 0xA697, 0xC81D,
    0x0FC9, 0x3A48, 0x611B, 0x4260, 0xF85D, 0xC13B, 0xAA6F, 0xBF03,
    0x09E8, 0x45B8, 0x551A, 0x3ECD, 0xFC7D, 0xB531, 0xA760, 0xBB11,
    0xFE99, 0x4243, 0x58B6, 0x3686, 0xF71E, 0xB40C, 0xA89E, 0xC370,
    0xF458, 0x49D1, 0x5A53, 0x458C, 0xFE61, 0xC709, 0xAAAF, 0xCCF7,
    0x0146, 0x3CBA, 0x5AA0, 0x395B, 0x00AE, 0xC558, 0xA47F, 0xBD84,
    0x0D79, 0x4011, 0x5A79, 0x3CFE, 0xF679, 0xBAFD, 0xA265, 0xCB3E,
    0xFAE2, 0x440D, 0x5A24, 0x376A, 0x04CF, 0xBA32, 0x9D47, 0xC348,
    0x00FA, 0x3CA4, 0x5D4D, 0x3E4A, 0x055B, 0xBAE6, 0xA84E, 0xCB6A,
    0x08AF, 0x467F, 0x5342, 0x3E75, 0x0422, 0xB339, 0x9C1C, 0xC2CD,
    0x010E, 0x42A6, 0x5EB2, 0x3A3D, 0x00CE, 0xC1CB, 0xA92E, 0xC601,
    0x0500, 0x385B, 0x5922, 0x46E1, 0xFC74, 0xC532, 0xB227, 0xC878,
    0x045F, 0x396B, 0x522E, 0x3B5F, 0xFC66, 0xB830, 0xA46D, 0xB0A9,
    0x141C, 0x4A0D, 0x6363, 0x3BD5, 0x024E, 0xCA2A, 0xA45B, 0xBA63,
    0xFA5D, 0x44D4, 0x5D81, 0x41F0, 0x019B, 0xBBE9, 0xA54B, 0xC350,
    0x01E6, 0x4405, 0x4983, 0x4585, 0x082E, 0xB970, 0xA08F, 0xB654,
    0xF92C, 0x3306, 0x5A45, 0x3F59, 0x02A2, 0xB629, 0xA704, 0xC51D,
    0xF796, 0x3EF3, 0x55B3, 0x417E, 0xFFBC, 0xBE98, 0xACE7, 0xBE5A,
    0xFCEB, 0x415F, 0x5309, 0x3805, 0xF982, 0xC4E1, 0xA96E, 0xB7CB,
    0x04FB, 0x3F81, 0x53F2, 0x4709, 0x001B, 0xBEA1, 0x9B29, 0xC204,
    0xFC56, 0x37D2, 0x5003, 0x3F21, 0x01C7, 0xC58A, 0xA64B, 0xB920,
    0xF486, 0x3E32, 0x544B, 0x3E31, 0xFC63, 0xC7D8, 0xA4F0, 0xC939,
    0xFDC0, 0x3EA8, 0x60B2, 0x375F, 0x01BC, 0xC7D2, 0xAA98, 0xBFCE,
    0xFCF0, 0x4988, 0x5693, 0x48BE, 0x09EA, 0xC47D, 0xA640, 0xC0E6,
    0x0175, 0x3F06, 0x55BC, 0x3BF8, 0x03AD, 0xBFA4, 0xA457, 0xBC1B,
    0x04A0, 0x3E3E, 0x57C0, 0x46B4, 0xFC91, 0xC0FC, 0xB0AB, 0xC135,
    0xFEF5, 0x416E, 0x60D4, 0x40B6, 0xFFD6, 0xC3D0, 0xB862, 0xC404,
    0x028C, 0x3EBF, 0x617B, 0x4314, 0xFF07, 0xBFBB, 0x9E50, 0xC562,
    0xFF21, 0x4545, 0x5B67, 0x444A, 0xF8F8, 0xCDFB, 0xA88F, 0xB9D7,
    0x00E6, 0x365B, 0x5686, 0x4662, 0xFC8A, 0xC8A2, 0xB4B0, 0xC182,
    0xFF8D, 0x3D0F, 0x551D, 0x3FAD, 0x0AE5, 0xB682, 0xAAFC, 0xBA3C,
    0xF87C, 0x546B, 0x4E26, 0x3EF4, 0x086F, 0xC3A8, 0xAE7B, 0xC3BB,
    0x0314, 0x433E, 0x4BC2, 0x49A9, 0xF9D8, 0xBA30, 0x9BDC, 0xBE35,
    0xFD78, 0x3E39, 0x606F, 0x3AD2, 0xF9B6, 0xB97A, 0xA7E7, 0xBFFD,
    0x0790, 0x3948, 0x5C5E, 0x4DFC, 0x0474, 0xC200, 0xB172, 0xBB9D,
    0x0902, 0x4B3E, 0x620B, 0x4616, 0x0281, 0xC5CB, 0xA96C, 0xBDC8,
    0x06E7, 0x45B8, 0x5FCC, 0x4258, 0xFFB8, 0xB5BC, 0xAC2B, 0xBFB0,
    0xFFDB, 0x4276, 0x58AC, 0x453D, 0xF8D4, 0xB908, 0xA6C0, 0xC174,
    0xF8EC, 0x3E6E, 0x5E2C, 0x4167, 0xFD65, 0xC008, 0xAE07, 0xB89A,
    0x00A7, 0x460B, 0x50D7, 0x3F8A, 0x072C, 0xC19A, 0xA336, 0xC99D,
    0x0ADB, 0x43F3, 0x5610, 0x3C70, 0xFD01, 0xBF7A, 0xA943, 0xBD10,
    0xFED7, 0x3BDD, 0x57F8, 0x3C9B, 0xFCA7, 0xC8A1, 0x9F88, 0xC4E3,
    0xFC22, 0x3F4C, 0x5B58, 0x419E, 0x0599, 0xBD41, 0xA498, 0xC066,
    0xFFE2, 0x4421, 0x5209, 0x395F, 0xFC92, 0xBB29, 0xADF9, 0xC267,
    0xFEC5, 0x3DA7, 0x62CD, 0x3C7E, 0x031F, 0xC181, 0xA0F0, 0xC4CC,
    0xF698, 0x456B, 0x5BF9, 0x465F, 0x0039, 0xC1DF, 0xAB09, 0xB9BD,
    0x0BE3, 0x3D7C, 0x59D8, 0x41F7, 0x036B, 0xC1DD, 0xAE66, 0xC029,
    0x053F, 0x3B7C, 0x5617, 0x42AE, 0x028A, 0xBC92, 0xA10B, 0xC0BF,
    0x0301, 0x3810, 0x57E5, 0x3A40, 0x0E42, 0xC701, 0xA770, 0xCF08,
    0x030D, 0x4139, 0x4910, 0x4471, 0xF6D6, 0xBF9E, 0xA694, 0xB84C,
    0x0103, 0x4B36, 0x607D, 0x354E, 0xF925, 0xC07B, 0xA16C, 0xCB89,
    0x00AD, 0x4790, 0x5EBB, 0x4055, 0x0DAB, 0xC582, 0xA316, 0xC528,
    0x05F2, 0x47BC, 0x6199, 0x3EFC, 0xFCDF, 0xC7B0, 0xA8B6, 0xB705,
    0xFCA9, 0x3F5C, 0x53A7, 0x403C, 0x03AD, 0xCA68, 0x968B, 0xC132,
    0xFCA4, 0x3A9A, 0x5D45, 0x3BD6, 0xFABA, 0xBC7B, 0xB1FB, 0xC1F1,
    0xFD5E, 0x3430, 0x5574, 0x4112, 0xFA98, 0xC2F3, 0xAD4B, 0xB241,
    0x0471, 0x4642, 0x5D46, 0x3B5E, 0xFF78, 0xCA62, 0xA7BE, 0xC672,
    0xF1E2, 0x3C6C, 0x4E48, 0x3973, 0xFEA6, 0xC5E6, 0xACA0, 0xBB4D,
    0x0495, 0x3819, 0x56C2, 0x36FB, 0x0384, 0xC7CD, 0xAABA, 0xC333,
    0x0091, 0x4B49, 0x60CC, 0x3FED, 0xFD8B, 0xC4F3, 0xABD5, 0xB844,
    0xF908, 0x3869, 0x5F85, 0x43F3, 0xFD56, 0xB740, 0xB356, 0xC8AF,
    0x10FE, 0x420A, 0x52CF, 0x401A, 0xFE88, 0xBC7B, 0xA3C0, 0xC171,
    0xFA84, 0x3CDB, 0x5DC5, 0x3CB4, 0x04F1, 0xBAC9, 0x9F2D, 0xC6F2,
    0xF821, 0x4564, 0x5538, 0x4289, 0xF8CE, 0xC328, 0xAEC9, 0xC4AE,
    0x006C, 0x3FB1, 0x5651, 0x4026, 0x02C3, 0xB60B, 0xA516, 0xB9A6,
    0xF7B1, 0x3B52, 0x52C7, 0x4579, 0x0336, 0xCAA0, 0xA22D, 0xBEFB,
    0x040A, 0x3A67, 0x5938, 0x410E, 0xFEFC, 0xC7C7, 0xAA6A, 0xBCAF,
    0xFD67, 0x419D, 0x4A1B, 0x4A5B, 0x043A, 0xBA31, 0xADB2, 0xC7EB,
    0xFDFA, 0x3F11, 0x5C0F, 0x414A, 0x05A0, 0xC23F, 0xA98B, 0xBD08,
    0xFA91, 0x3FE4, 0x57BF, 0x4100, 0xFC84, 0xC2C8, 0xA4B8, 0xC1BA,
    0x0514, 0x3D62, 0x5A7C, 0x418E, 0xEFE4, 0xB958, 0xA1CB, 0xC55B,
    0x0735, 0x38B0, 0x4DEC, 0x34AE, 0xFB8D, 0xC20D, 0xA941, 0xC1AC,
    0x01AA, 0x3876, 0x6408, 0x418E, 0x0E75, 0xC41F, 0xADBB, 0xB93D,
    0xFCF7, 0x3A75, 0x5760, 0x3DDA, 0x0519, 0xCC93, 0x9FAC, 0xBADE,
    0xFBFA, 0x41A8, 0x656F, 0x3B5F, 0x09A7, 0xC582, 0xA6E2, 0xB2C7,
    0x0A82, 0x4456, 0x69E9, 0x3919, 0x00D3, 0xC0BC, 0xABFC, 0xBBE6,
    0xF674, 0x42AC, 0x5B4F, 0x4515, 0x046F, 0xCAFA, 0xA6E3, 0xC65F,
    0x0C48, 0x38CB, 0x53CC, 0x3C52, 0xF635, 0xCC58, 0xA96C, 0xB98C,
    0xFFFA, 0x42B5, 0x5B24, 0x366F, 0xFF19, 0xC35A, 0xA632, 0xBD83,
    0xFCEF, 0x41D8, 0x573E, 0x49BA, 0x039C, 0xB90C, 0xA058, 0xC0E6,
    0x0128, 0x399D, 0x501F, 0x41C8, 0x0A91, 0xBD4D, 0x9B1B, 0xBF0F,
    0xFA4C, 0x3C11, 0x58A8, 0x4AD5, 0xFC21, 0xB67B, 0xAC38, 0xC7F9,
    0x0377, 0x4455, 0x5BAC, 0x4607, 0xFD86, 0xC4F2, 0xABDE, 0xBEE5,
    0x0657, 0x456B, 0x5B7E, 0x4DAA, 0xFC3B, 0xC0E2, 0xB25B, 0xC5BA,
    0x0A51, 0x3786, 0x5D53, 0x3B0B, 0x0419, 0xC023, 0xAE17, 0xC223,
    0xFAAD, 0x36EB, 0x59EE, 0x3FA5, 0x05BA, 0xC675, 0xA39E, 0xBADB,
    0xF97F, 0x3D09, 0x58C2, 0x3B18, 0x041C, 0xC9DC, 0xA5A3, 0xD011,
    0xFEFF, 0x33FA, 0x58B9, 0x3DD4, 0x057A, 0xD072, 0xABDA, 0xBCB1,
    0x0945, 0x427F, 0x6110, 0x4460, 0x01EF, 0xC6E7, 0xA5D0, 0xC557,
    0xFB5C, 0x4A3E, 0x5DAF, 0x3EEC, 0xFB2C, 0xC379, 0xAC26, 0xC35D,
    0x0210, 0x3AFE, 0x5D52, 0x4370, 0x0253, 0xCED9, 0x9E68, 0xCEEC,
    0x1211, 0x4923, 0x542D, 0x393E, 0xFDC0, 0xB4CD, 0xA834, 0xC2D3,
    0xFA6E, 0x492A, 0x6354, 0x40FE, 0x018E, 0xBA37, 0xA8E4, 0xBF3B,
    0xF7D0, 0x40B4, 0x57E2, 0x4907, 0x016C, 0xBEBD, 0x9AA9, 0xC484,
    0x01C2, 0x43B1, 0x5FEA, 0x46C6, 0xFF1C, 0xBD7C, 0xA077, 0xC4EA,
    0x0083, 0x43D6, 0x5A28, 0x3FFC, 0xEF33, 0xB825, 0xA56F, 0xC49E,
    0xFADC, 0x459D, 0x5717, 0x4186, 0x0035, 0xBA92, 0xAB29, 0xC6E0,
    0xFE4B, 0x4608, 0x5602, 0x4A2A, 0x00D5, 0xC180, 0xA754, 0xC1A4,
    0xFA24, 0x3A07, 0x5FA9, 0x3645, 0xF5D9, 0xC790, 0xA5CF, 0xB8B9,
    0x0BFB, 0x38CF, 0x5471, 0x428D, 0xFEA2, 0xC50A, 0xAA0F, 0xC24D,
    0xFA5B, 0x4424, 0x5E9C, 0x4088, 0xFA11, 0xC287, 0xA0CD, 0xBDAC,
    0x00F6, 0x3C92, 0x616A, 0x428A, 0x0101, 0xC0F5, 0xA62D, 0xB2E9,
    0x03DD, 0x3739, 0x632B, 0x3CF2, 0x0408, 0xBCB6, 0xAAB0, 0xC60A,
    0xF91F, 0x3FD5, 0x5CAE, 0x3D83, 0x0DC6, 0xBF0E, 0x9BE4, 0xBFBA,
    0x032E, 0x3A3D, 0x5FD5, 0x41C5, 0x01B3, 0xC338, 0xA5B3, 0xC31B,
    0xFDC5, 0x45F1, 0x5929, 0x3C19, 0xFDEF, 0xC1DB, 0xA40B, 0xBF4F,
    0x008C, 0x44B6, 0x5685, 0x460E, 0x01FE, 0xC8BE, 0xAD37, 0xC39B,
    0xFEE9, 0x4057, 0x5411, 0x3063, 0x06D5, 0xC003, 0xA587, 0xC191,
    0x05C5, 0x4218, 0x5D61, 0x3AC8, 0x03AF, 0xBD2D, 0xAE24, 0xBDE6,
    0xF47C, 0x449E, 0x5A7F, 0x4B61, 0x014B, 0xC862, 0x9FD7, 0xC624,
    0xFCC9, 0x408E, 0x69EE, 0x432C, 0x0673, 0xBF3E, 0xA44E, 0xB8E9,
    0x0450, 0x437D, 0x6050, 0x3DA0, 0xFAEA, 0xC22E, 0xB50A, 0xC3C6,
    0x0665, 0x38DF, 0x56E9, 0x4016, 0x0521, 0xC13B, 0x9A04, 0xC0F6,
    0xF6B6, 0x3CC1, 0x5346, 0x47F7, 0x080C, 0xC20B, 0xA250, 0xB2FB,
    0xF5AD, 0x39F5, 0x5C6A, 0x3ED5, 0xFA47, 0xC138, 0xA5A9, 0xCB77,
    0xFB2F, 0x4654, 0x628E, 0x3E1A, 0x0081, 0xC647, 0xB227, 0xBDA2,
    0x0C83, 0x3EBB, 0x5F88, 0x400A, 0x03D8, 0xCEC0, 0xA90D, 0xB792,
    0xFD2E, 0x3483, 0x5A69, 0x4279, 0x0513, 0xBC1D, 0xA42A, 0xC251,
    0x0785, 0x4165, 0x5B3E, 0x380D, 0x017B, 0xC6CD, 0xA486, 0xC48F,
    0xF52F, 0x3C72, 0x572F, 0x3A37, 0xFAD4, 0xBE03, 0x9B7C, 0xC358,
    0x01D2, 0x3D2C, 0x6292, 0x3E2E, 0x0835, 0xB5EC, 0xA847, 0xC588,
    0x063A, 0x3BCD, 0x6609, 0x3834, 0xF6DC, 0xBEA2, 0x9D88, 0xBCE3,
    0xFB0B, 0x34EE, 0x56DA, 0x4A28, 0x02FC, 0xC034, 0xAC30, 0xB4B9,
    0x01AA, 0x3EA8, 0x570D, 0x42F6, 0xFFBF, 0xC215, 0xA86A, 0xB361,
    0xF6CE, 0x47E4, 0x5838, 0x3A8A, 0xFC11, 0xC4CD, 0xA99C, 0xB803,
    0x0920, 0x3C96, 0x56D3, 0x3B00, 0xFE40, 0xB0F3, 0x9F9B, 0xC142,
    0x030C, 0x3FB8, 0x6036, 0x45EE, 0x00C1, 0xC6DD, 0xA2D0, 0xC416,
    0x07DE, 0x431E, 0x50DD, 0x3FB3, 0x0231, 0xC055, 0xA83A, 0xC399,
    0x0710, 0x46FE, 0x5948, 0x3867, 0xF896, 0xC119, 0xA4C0, 0xC0D3,
    0xFEA0, 0x39F1, 0x5416, 0x4798, 0x03D3, 0xC3EC, 0xA69A, 0xC7F1,
    0xFB77, 0x45B3, 0x6871, 0x3E75, 0x0B0C, 0xBFA7, 0x9C19, 0xC65C,
    0xEF63, 0x32F9, 0x60B7, 0x3DEF, 0xFF79, 0xC29C, 0xAA1C, 0xC39B,
    0xFFE1, 0x48B9, 0x59A4, 0x3975, 0xFD0B, 0xC8DC, 0xA756, 0xC7D0,
    0x009C, 0x3ECD, 0x540D, 0x45E5, 0x0002, 0xC657, 0xA65B, 0xBAB8,
    0x005E, 0x3641, 0x547E, 0x3A14, 0xFED4, 0xB9C6, 0xA585, 0xCB2B,
    0x05CF, 0x42DE, 0x5D63, 0x3B4D, 0xFBCD, 0xC067, 0xA543, 0xC475,
    0xFB59, 0x4176, 0x5663, 0x4962, 0xF514, 0xBF10, 0x9F22, 0xB864,
    0xFB56, 0x3BA6, 0x5303, 0x41A6, 0x00F8, 0xCCA2, 0xA979, 0xBDF2,
    0xFB9B, 0x42F1, 0x57A1, 0x3992, 0xFA0D, 0xB849, 0xB6B3, 0xC952,
    0x0177, 0x4240, 0x5E65, 0x3893, 0x08EF, 0xBD6E, 0x9DF0, 0xCC09,
    0x00A1, 0x3F27, 0x5EBA, 0x4575, 0x02A1, 0xC806, 0xA5E7, 0xC8C5,
    0x09D8, 0x4302, 0x5F0C, 0x4991, 0xFED8, 0xC9C6, 0xA8F0, 0xBF15,
    0xF7D8, 0x380B, 0x50ED, 0x3B46, 0xF9F8, 0xCC07, 0x9C91, 0xC139,
    0xFF2F, 0x371E, 0x5ACA, 0x40CD, 0xF7F6, 0xCB5C, 0xA5B9, 0xD11C,
    0x02B4, 0x3867, 0x554C, 0x360A, 0x02D9, 0xC873, 0x9CAB, 0xC26F,
    0x0725, 0x4174, 0x5117, 0x3849, 0xFEAF, 0xB7FA, 0xA74D, 0xC1A2,
    0x01B4, 0x3E5A, 0x5E3E, 0x3352, 0x0145, 0xC6BA, 0xADDC, 0xCD0D,
    0x0719, 0x3F21, 0x5C82, 0x3D41, 0x01D0, 0xC3D4, 0xA204, 0xC119,
    0x054B, 0x4200, 0x5099, 0x4017, 0xF9C2, 0xC00B, 0xA16D, 0xCABA,
    0xF8A4, 0x35B0, 0x55C5, 0x4453, 0xFFB0, 0xC036, 0xAB47, 0xC3B7,
    0x08C6, 0x41E3, 0x56FF, 0x4C6E, 0x027A, 0xBB3F, 0xA57E, 0xC634,
    0x0320, 0x3C0F, 0x62EE, 0x3526, 0x0751, 0xBACC, 0xB5BD, 0xC29D,
    0x05E6, 0x3E56, 0x5655, 0x3CEC, 0xFB66, 0xC1E6, 0xA2EB, 0xBE6A,
    0x0022, 0x42E9, 0x57F5, 0x3F31, 0xFAF4, 0xC9AF, 0xA71E, 0xCBD0,
    0xFCB1, 0x39D9, 0x5E58, 0x4260, 0x09E0, 0xCBB6, 0xA915, 0xC008,
    0x00C6, 0x3698, 0x5960, 0x3A15, 0x072C, 0xC5E3, 0xB83C, 0xC8A4,
    0x00B9, 0x4744, 0x6756, 0x389B, 0xFFE5, 0xBADE, 0xA02C, 0xBD53,
    0x0829, 0x4C07, 0x5A1F, 0x3AFB, 0x0094, 0xCADC, 0xACE2, 0xC02F,
    0x0DE9, 0x392A, 0x5BB7, 0x3597, 0x025E, 0xB49B, 0xA47D, 0xC379,
    0x02E9, 0x4A16, 0x6602, 0x4168, 0x0BFE, 0xC112, 0x9BA8, 0xC0F2,
    0xFC40, 0x2F78, 0x5986, 0x3BAF, 0xFF01, 0xB9F4, 0xB03E, 0xBFE3,
    0xFACD, 0x3C9B, 0x557C, 0x3B65, 0xFC4B, 0xB296, 0xA394, 0xC42D,
    0xF803, 0x437C, 0x55AD, 0x474A, 0x0943, 0xC341, 0x9D8D, 0xB84F,
    0x07BB, 0x3F3D, 0x6296, 0x3C98, 0xF7AD, 0xB86D, 0xA1A3, 0xBF6C,
    0xF783, 0x3981, 0x56B0, 0x35B2, 0x0491, 0xB6B0, 0x9ADE, 0xBFC0,
    0x0E55, 0x3909, 0x5B1C, 0x3E4D, 0x0529, 0xB984, 0xA047, 0xC1FE,
    0xF6C4, 0x4516, 0x58A6, 0x441E, 0x040B, 0xBA02, 0xAB63, 0xBFED,
    0x017E, 0x3C26, 0x586D, 0x3C19, 0xF9E1, 0xBB67, 0x9CDC, 0xC410,
    0xFC63, 0x42B6, 0x5985, 0x3B4C, 0x0CDD, 0xBF2B, 0xA733, 0xBCEA,
    0xFF07, 0x387D, 0x562A, 0x37CD, 0xF459, 0xC45A, 0xA8CE, 0xC8A5,
    0xFFCA, 0x39D4, 0x5014, 0x4532, 0xFC00, 0xC99E, 0xA5C7, 0xBF14,
    0x0954, 0x3CA6, 0x5990, 0x3C29, 0xFD19, 0xC016, 0xA403, 0xB84B,
    0xFC84, 0x4773, 0x510A, 0x3EF6, 0x0455, 0xC1F5, 0xA545, 0xC32E,
    0x0135, 0x3DF5, 0x5573, 0x384B, 0x0E8C, 0xBCA9, 0xA453, 0xCA7D,
    0x0452, 0x3D86, 0x51F0, 0x37B0, 0x085C, 0xBDD1, 0xAB34, 0xBE3B,
    0x01E6, 0x4A26, 0x5F12, 0x3CB4, 0xFF6F, 0xBB1D, 0xAB82, 0xBD79,
    0xF672, 0x34C5, 0x5545, 0x3472, 0xFA71, 0xC013, 0x94E7, 0xC1D3,
    0x0CED, 0x4405, 0x5A60, 0x391D, 0xFC0E, 0xC7FB, 0xA358, 0xC097,
    0xF842, 0x3E06, 0x5A15, 0x3346, 0x035E, 0xC9CC, 0xA449, 0xB92A,
    0x0516, 0x4297, 0x591A, 0x420A, 0x01A6, 0xC0AA, 0xA65C, 0xBD8D,
    0xFB9E, 0x3839, 0x5BFE, 0x4828, 0x063E, 0xBDC9, 0x9D1F, 0xBB8F,
    0xFDB4, 0x431B, 0x5D42, 0x43EB, 0x0293, 0xC92F, 0xAA26, 0xBA93,
    0xFC58, 0x4A74, 0x61BE, 0x420B, 0x00FB, 0xB7A9, 0xABDF, 0xBB20,
    0xFB9B, 0x4261, 0x560D, 0x43BE, 0xF871, 0xBCAC, 0xAE84, 0xB9AE,
    0xFE07, 0x3DBE, 0x5E95, 0x3450, 0xFB18, 0xC690, 0xA8D9, 0xBCD9,
    0x034D, 0x3AE5, 0x6594, 0x3CCC, 0xFC7A, 0xB609, 0xAD71, 0xC528,
    0xF959, 0x3A18, 0x5718, 0x4E91, 0x0620, 0xCEB7, 0x984D, 0xC6A5,
    0xFD6F, 0x3EC4, 0x6561, 0x3833, 0x0EDC, 0xBDE0, 0xA1A7, 0xBFF9,
    0x0B0B, 0x37AF, 0x54C3, 0x3C93, 0x00FD, 0xC44C, 0xA55E, 0xC848,
    0xFC6E, 0x42B1, 0x5899, 0x4162, 0x0A58, 0xBB41, 0xA830, 0xB59F,
    0xF767, 0x390C, 0x537A, 0x3F4D, 0xFD16, 0xBC63, 0xA0E9, 0xB788,
    0xFA37, 0x30C1, 0x5D89, 0x3641, 0xF8FF, 0xB178, 0xA1B6, 0xCD7D,
    0xFEF2, 0x446B, 0x54D4, 0x4405, 0xFE67, 0xBD66, 0xA977, 0xC78C,
    0x0029, 0x3A58, 0x51C1, 0x3AEB, 0x07B6, 0xBC50, 0xA41A, 0xCDC2,
    0xFE2F, 0x41AF, 0x5B1E, 0x412D, 0x07DF, 0xC7B1, 0xAD6A, 0xC914,
    0x0049, 0x3820, 0x565A, 0x3FF0, 0x0169, 0xBEAB, 0xA6CF, 0xCBA3,
    0xEC98, 0x467E, 0x5417, 0x42FF, 0xFBE5, 0xC716, 0xA36E, 0xC4B1,
    0xF987, 0x4877, 0x5FAD, 0x3ACC, 0xFD73, 0xBC19, 0xA5E4, 0xC34D,
    0xFF87, 0x32D7, 0x5A2D, 0x459B, 0x0A58, 0xB9D2, 0xA3C3, 0xBBE1,
    0xFE00, 0x40AF, 0x58EE, 0x434C, 0xFD61, 0xC20D, 0xA997, 0xD029,
    0xFD5D, 0x406A, 0x5D25, 0x364F, 0xF983, 0xC3F5, 0xA442, 0xC70F,
    0x01DC, 0x41BE, 0x5861, 0x41EA, 0xF0B0, 0xC17F, 0xA94B, 0xADC6,
    0xF742, 0x3AF0, 0x62DE, 0x3D2A, 0x0202, 0xC643, 0xA5CB, 0xB975,
    0xF861, 0x3E71, 0x5B37, 0x394E, 0x0596, 0xBBCF, 0xA6EE, 0xC2FF,
    0xF8C8, 0x36DD, 0x550E, 0x425E, 0xF8E7, 0xC448, 0x9C0F, 0xC431,
    0xF895, 0x3739, 0x5B58, 0x3DC0, 0xF6A8, 0xC0F0, 0xA787, 0xC2E9,
    0xFD46, 0x4B10, 0x54D3, 0x4274, 0x0450, 0xB2A5, 0xAFAA, 0xBC7C,
    0xF89F, 0x2F6C, 0x4D09, 0x4877, 0x052D, 0xC7AD, 0xABC8, 0xC5CD,
    0x02EF, 0x3E84, 0x5FDD, 0x335D, 0xF72C, 0xBE81, 0xA931, 0xCB12,
    0xFA5D, 0x32AE, 0x5645, 0x3F48, 0xF374, 0xD66F, 0xA39F, 0xBBB6,
    0x00C1, 0x3DC5, 0x55C4, 0x3F62, 0x06A7, 0xC884, 0xAB13, 0xC167,
    0x02E9, 0x3A19, 0x5B70, 0x3DEE, 0x0079, 0xBB6F, 0xB992, 0xCA14,
    0xF0B0, 0x431C, 0x555D, 0x4E70, 0xFBFD, 0xBE85, 0xA712, 0xBD3A,
    0xFC44, 0x3CAB, 0x55B2, 0x3979, 0xFBCA, 0xC8BF, 0xA14D, 0xC06F,
    0xFF23, 0x407C, 0x6509, 0x4745, 0x048E, 0xCB63, 0xA32F, 0xBD15,
    0xFE91, 0x41D5, 0x6027, 0x4047, 0xFCEE, 0xBDDE, 0xA362, 0xC095,
    0x0559, 0x3E47, 0x4F5F, 0x39D3, 0x01D6, 0xC5DD, 0xA630, 0xC442,
    0x001A, 0x3F92, 0x6B5C, 0x47A8, 0xFE4A, 0xC3D4, 0x97C7, 0xC4F8,
    0xF60E, 0x3F6A, 0x57B9, 0x4928, 0x0161, 0xBDFE, 0xA0BA, 0xC176,
    0x0DE2, 0x3C34, 0x632F, 0x4800, 0xF996, 0xC5B7, 0xA9FD, 0xB84D,
    0xF87A, 0x3EF5, 0x6064, 0x4602, 0x0088, 0xC03B, 0xA504, 0xC991,
    0x064A, 0x3BF2, 0x574C, 0x49E4, 0x0574, 0xC7FD, 0xA2E2, 0xC794,
    0xFD9E, 0x35A2, 0x5C20, 0x3F82, 0xF86E, 0xC361, 0xA1B7, 0xC676,
    0x0164, 0x3D85, 0x5CFE, 0x41A5, 0x007A, 0xC0CE, 0xA591, 0xD09C,
    0xFB3D, 0x40D5, 0x658B, 0x42D3, 0x01B2, 0xB7C4, 0xABD6, 0xB80A,
    0xF927, 0x3C91, 0x5CD2, 0x3947, 0xFB66, 0xC054, 0xA63B, 0xB7F9,
    0xF670, 0x3CE2, 0x53E2, 0x3508, 0xFC5F, 0xBB29, 0xB30F, 0xBBED,
    0xFBA3, 0x3670, 0x4DBE, 0x41D5, 0x0327, 0xC898, 0xA3BF, 0xC266,
    0xFA2F, 0x40AE, 0x4E58, 0x3C3A, 0x0E30, 0xBC53, 0x9F64, 0xBBF4,
    0x0364, 0x3E9C, 0x4E78, 0x37A8, 0xFABD, 0xB959, 0xA831, 0xB834,
    0x0805, 0x3D42, 0x5BEE, 0x3CBC, 0xF674, 0xC5B7, 0xA248, 0xBF61,
    0xFC3E, 0x3FCA, 0x5DC2, 0x3F55, 0xF777, 0xCB2F, 0xAB97, 0xCA5C,
    0x04E3, 0x37BB, 0x65BF, 0x3AD4, 0x0086, 0xC097, 0xA480, 0xC616,
    0x06F6, 0x3F91, 0x5C8E, 0x4122, 0x0418, 0xBD79, 0xA8EE, 0xC895,
    0x00AA, 0x4837, 0x4F84, 0x3DDC, 0xFAA6, 0xC3C7, 0xA11B, 0xBDC4,
    0x057B, 0x37AC, 0x69B2, 0x38BC, 0xFA30, 0xC028, 0xA5C4, 0xC808,
    0x04AD, 0x4959, 0x5A49, 0x4212, 0x072A, 0xD088, 0xB051, 0xBDAE,
    0xF44C, 0x3E15, 0x6605, 0x3FF3, 0xFE4E, 0xC10D, 0xA1A4, 0xB895,
    0xFF9D, 0x3DEA, 0x5809, 0x3E42, 0xF63F, 0xC04E, 0xAA5C, 0xAD9B,
    0xFECA, 0x3EE9, 0x5FC2, 0x427A, 0xFE6F, 0xC1BB, 0xAB32, 0xBA89,
    0xF9DA, 0x3563, 0x5893, 0x45DA, 0x06A6, 0xC409, 0xA91F, 0xBF04,
    0x0370, 0x3A31, 0x5EEE, 0x46E3, 0x07E5, 0xCC72, 0xA4D3, 0xBF2C,
    0x00A5, 0x3A18, 0x5EDA, 0x40BA, 0x01A3, 0xC204, 0xAC82, 0xC3E4,
    0xFB10, 0x35E6, 0x57AD, 0x40DA, 0xFD29, 0xCB20, 0xAC86, 0xC7D0,
    0xFFE8, 0x452C, 0x5C83, 0x41CA, 0x04DD, 0xCAD7, 0xA359, 0xC32C,
    0xFE41, 0x3B15, 0x59A1, 0x3D2A, 0xFEC1, 0xC47F, 0xA2DC, 0xBE26,
    0xFA85, 0x4761, 0x5E6D, 0x3898, 0x078B, 0xBFEF, 0xA6D7, 0xBD38,
    0x033F, 0x43B8, 0x5518, 0x3ECB, 0xEED1, 0xB53C, 0xAA66, 0xB3FB,
    0xFCE3, 0x3E1F, 0x5314, 0x313D, 0xFCD1, 0xBFE5, 0x9F84, 0xC2C5,
    0x0587, 0x3BE1, 0x5DA5, 0x4A71, 0xFCCE, 0xC36E, 0xAB57, 0xC43D,
    0x0406, 0x3A0C, 0x5E3A, 0x39C4, 0xFEB6, 0xC0F9, 0xB13D, 0xC466,
    0xF7F4, 0x3C58, 0x5A67, 0x41B0, 0xFC78, 0xC295, 0xA8CF, 0xB4B8,
    0xFC86, 0x45EA, 0x6257, 0x365A, 0xFFD7, 0xBB1B, 0xA415, 0xBE3D,
    0x06DE, 0x47CB, 0x586A, 0x310B, 0x03BF, 0xC471, 0xAED6, 0xC566,
    0x0C6E, 0x4711, 0x4E02, 0x403F, 0x016A, 0xBEDD, 0xA204, 0xC3CA,
    0x05FE, 0x4C23, 0x5BD2, 0x3D83, 0x0076, 0xB8E8, 0xA4CA, 0xBB36,
    0xFA59, 0x46A8, 0x52E4, 0x45AF, 0xF867, 0xC210, 0xAA1B, 0xC03A,
    0x01AE, 0x351E, 0x5673, 0x41AB, 0x0723, 0xCA0B, 0xACD2, 0xBEE2,
    0x0060, 0x3AFC, 0x4DB3, 0x3E78, 0x0200, 0xBD61, 0xACFE, 0xC032,
    0xF4FE, 0x3CF6, 0x5B86, 0x4029, 0x0650, 0xBF2C, 0xA05A, 0xBF80,
    0xFEB4, 0x3EA5, 0x4F8B, 0x462D, 0xEE1D, 0xC799, 0xA8AF, 0xBA29,
    0xF0DE, 0x3A51, 0x5366, 0x4195, 0xFF10, 0xB810, 0x9F82, 0xBC9F,
    0xF836, 0x37DE, 0x55F2, 0x3D9A, 0xF3FB, 0xBE43, 0xA96D, 0xBEBE,
    0x01E4, 0x3E4B, 0x550B, 0x440F, 0xFA66, 0xC436, 0x9A7E, 0xC727,
    0x0018, 0x44C4, 0x580D, 0x3F18, 0xFCF0, 0xC318, 0xAEDD, 0xBE18,
    0x08C4, 0x4066, 0x5849, 0x433A, 0x069D, 0xB901, 0xAB2A, 0xA71D,
    0x0228, 0x3DFB, 0x5FD7, 0x4BA0, 0x06C8, 0xBF78, 0x9A93, 0xBE21,
    0xFAB0, 0x3CF3, 0x518A, 0x3CA3, 0xFE8E, 0xC6E8, 0xA2EA, 0xB9AF,
    0x0223, 0x36D6, 0x5E5E, 0x40ED, 0xFADD, 0xB2B1, 0xA9DA, 0xAAFF,
    0x01A1, 0x41E0, 0x5E4F, 0x401D, 0xF9BB, 0xC2C7, 0xA213, 0xC868,
    0xFDBC, 0x3645, 0x5F84, 0x3BA7, 0xFA10, 0xC048, 0x94ED, 0xC68F,
    0xFE89, 0x45BA, 0x5635, 0x4B93, 0x0157, 0xBBE4, 0x9F99, 0xC5B6,
    0x0880, 0x3D1B, 0x5D28, 0x37CB, 0x00BE, 0xC10F, 0xAD7B, 0xC455,
    0x0660, 0x4335, 0x4C76, 0x4018, 0xFE69, 0xBC3C, 0xA00E, 0xC188,
    0xFCBA, 0x42AE, 0x5992, 0x35E0, 0x073D, 0xC312, 0xA970, 0xBB55,
    0xF9D4, 0x402C, 0x5DA8, 0x3C5A, 0x0067, 0xB8A2, 0xA5CA, 0xBB9F,
    0xFE6F, 0x3D49, 0x5A88, 0x3CFA, 0x00D4, 0xC912, 0xA74C, 0xBDE2,
    0xF68E, 0x4623, 0x57B4, 0x3847, 0x0061, 0xCDC2, 0xAE46, 0xBE90,
    0x0173, 0x34BE, 0x5BCB, 0x424C, 0x0A2B, 0xC486, 0xA712, 0xC2EA,
    0xF14C, 0x38DF, 0x621E, 0x3E77, 0x09AE, 0xB18A, 0xA7CC, 0xCAA0,
    0xFB7D, 0x4366, 0x6083, 0x3EBE, 0xFC74, 0xC8E1, 0xA6A4, 0xBD88,
    0x05DE, 0x42DF, 0x580E, 0x4970, 0x010D, 0xBCE3, 0x96F0, 0xB805,
    0xF9B7, 0x3CC8, 0x4EC7, 0x3F93, 0xFC79, 0xCB46, 0xA7A8, 0xCC08,
    0x004A, 0x416C, 0x66C6, 0x3410, 0x0805, 0xBE67, 0x9954, 0xB78A,
    0x02D4, 0x3E7E, 0x50A1, 0x4291, 0x0250, 0xBB06, 0x995E, 0xC10E,
    0x05AC, 0x402E, 0x4F7C, 0x3BAE, 0xFA07, 0xC311, 0xA47A, 0xC597,
    0xFFD3, 0x3BCC, 0x5BE6, 0x4192, 0x0781, 0xBA8D, 0xA7F2, 0xBE6B,
    0x093A, 0x39BD, 0x47A0, 0x4007, 0x03F8, 0xB4BB, 0xA9F1, 0xBA2E,
    0xFDC5, 0x3927, 0x5842, 0x4408, 0xFAE4, 0xBDDE, 0xAA44, 0xCED2,
    0x080E, 0x3868, 0x5796, 0x3849, 0x016D, 0xC4A1, 0x9FA1, 0xBE89,
    0x0471, 0x3BF2, 0x5B1C, 0x3766, 0xFCC8, 0xCCE2, 0xA3A6, 0xC1DD,
    0x0118, 0x4709, 0x52CD, 0x33F2, 0x001D, 0xBFA3, 0x9EFE, 0xBD9D,
    0x09E5, 0x36F4, 0x5A6F, 0x3F81, 0xFADC, 0xBCD4, 0xA6A0, 0xB520,
    0xFF66, 0x40DB, 0x5EEC, 0x47F4, 0x0372, 0xBD92, 0xA96C, 0xC2D7,
    0x0A78, 0x3BF8, 0x5E91, 0x3839, 0x0711, 0xBE87, 0xB011, 0xC563,
    0x02A6, 0x3BCB, 0x5F01, 0x4239, 0x0B1F, 0xD2C2, 0xA19F, 0xC5C5,
    0x0285, 0x49A7, 0x5C85, 0x3D46, 0xFFB2, 0xB6CC, 0x9A46, 0xBEB4,
    0xFE2C, 0x42F2, 0x52BF, 0x3DD5, 0xFAD0, 0xBE9A, 0xB2DF, 0xC83A,
    0xFCC5, 0x5110, 0x5B88, 0x375E, 0xF288, 0xB198, 0xA437, 0xC94C,
    0xF9A7, 0x3DB9, 0x56E0, 0x4139, 0x0B78, 0xCC4B, 0xA620, 0xB948,
    0x02AE, 0x3AB3, 0x5BCB, 0x3439, 0xF61E, 0xBCA4, 0xB08B, 0xB850,
    0xFC84, 0x3D54, 0x60C0, 0x3A53, 0x05B6, 0xC099, 0x9E4C, 0xB88F,
    0xFC1A, 0x421F, 0x5775, 0x38F7, 0xF92C, 0xBD5A, 0xA501, 0xB55B,
    0xFA50, 0x3CAF, 0x5A20, 0x3B9A, 0x043D, 0xBC86, 0xA871, 0xC015,
    0xFCB6, 0x3E0C, 0x54E2, 0x372E, 0xFD1F, 0xB792, 0xAA68, 0xBAD5,
    0xFE21, 0x442D, 0x5B7E, 0x3CBE, 0x0802, 0xB9FF, 0xA20F, 0xBE96,
    0xF7BF, 0x42CE, 0x5C1A, 0x4F68, 0x0670, 0xBEFA, 0xAE27, 0xCF8F,
    0xFDDF, 0x4423, 0x60F8, 0x4BB9, 0xFE45, 0xD09E, 0x9948, 0xC54D,
    0xFDC3, 0x39BB, 0x5EC7, 0x41CD, 0x07A5, 0xBD80, 0xA930, 0xC076,
    0xF844, 0x4758, 0x5220, 0x3DA1, 0xFAB5, 0xBD06, 0xA0A1, 0xBBE5,
    0xFAE2, 0x470D, 0x55C7, 0x38C4, 0xFD11, 0xB756, 0xAADC, 0xBE8A,
    0x02D8, 0x41D0, 0x5144, 0x44FE, 0x0608, 0xC53E, 0xA926, 0xCEB0,
    0xF816, 0x4544, 0x5811, 0x44AB, 0x0508, 0xBC5A, 0xA494, 0xBDE8,
    0x0EF6, 0x3C4B, 0x5BB0, 0x3686, 0xFB15, 0xC48F, 0x9B54, 0xC5D5,
    0xF7DD, 0x435C, 0x50EB, 0x33A1, 0x0B2C, 0xB552, 0xA039, 0xBDBC,
    0xFC63, 0x3B99, 0x4FAC, 0x3BA1, 0x014C, 0xB5FF, 0xAD76, 0xCAFF,
    0xFB4D, 0x3B5F, 0x572A, 0x3339, 0x07B7, 0xBFDA, 0xA7CF, 0xBFC7,
    0x00AE, 0x3CBF, 0x5994, 0x42C9, 0xF790, 0xC149, 0xA51D, 0xBF32,
    0x0045, 0x464E, 0x488A, 0x4025, 0x072C, 0xBB16, 0xA8CF, 0xB85A,
    0xFA50, 0x49B3, 0x5929, 0x4388, 0xF6C2, 0xBD4D, 0xA9F2, 0xBF16,
    0x07D5, 0x3B22, 0x5676, 0x38EB, 0xFE89, 0xBD33, 0xA8C9, 0xC883,
    0xFD7A, 0x4052, 0x56D2, 0x3A80, 0xFDFD, 0xBFA3, 0xA73C, 0xBF19,
    0xF85C, 0x433A, 0x663E, 0x3FB5, 0x0229, 0xBEE1, 0xA3B7, 0xC067,
    0xFC3D, 0x411B, 0x65DC, 0x37E5, 0xFDF5, 0xBE61, 0xA1D5, 0xB70E,
    0xFA59, 0x419E, 0x56D2, 0x36C0, 0x02C5, 0xC855, 0xAB3B, 0xBFD6,
    0xFEA6, 0x491C, 0x4C8C, 0x3DDE, 0x034A, 0xBC46, 0xA582, 0xB693,
    0xFB9F, 0x40C1, 0x4FF7, 0x3F6E, 0xFD43, 0xC1EE, 0xAA5C, 0xC94D,
    0xFBD5, 0x3E9F, 0x5A07, 0x4172, 0xFD1A, 0xBEFE, 0xA622, 0xB69B,
    0x0166, 0x476E, 0x5528, 0x37AB, 0xF336, 0xC00C, 0xA3D4, 0xC264,
    0xF958, 0x4110, 0x5CD4, 0x3659, 0x0560, 0xB9E7, 0xA65E, 0xBEDE,
    0x01C3, 0x3E5E, 0x5A55, 0x473B, 0x06E4, 0xB2EE, 0xA6E1, 0xC542,
    0x126E, 0x3F8C, 0x5FF8, 0x4E72, 0x06C6, 0xC8F7, 0x9F0D, 0xCC3B,
    0xF4FD, 0x3AF7, 0x6081, 0x40B5, 0x038A, 0xB6EA, 0xAED3, 0xC8B6,
    0x0361, 0x384F, 0x5892, 0x3F0B, 0x008C, 0xBC6E, 0xA749, 0xC385,
    0x0672, 0x3963, 0x5C3C, 0x3F5F, 0xFD3E, 0xC5FF, 0x9DC6, 0xCD34,
    0x0289, 0x3AA7, 0x5E18, 0x3E3D, 0x03B8, 0xC1CB, 0x9D2F, 0xBB8C,
    0xFADA, 0x3DD0, 0x55E5, 0x511B, 0x007D, 0xC3C1, 0xA6C5, 0xC367,
    0x04BE, 0x4318, 0x5C5B, 0x3971, 0xFCC4, 0xC301, 0xAAEA, 0xC3D1,
    0x0517, 0x4176, 0x5594, 0x4A86, 0x0253, 0xC233, 0xA854, 0xB0A7,
    0xFBFD, 0x4555, 0x6855, 0x3FDD, 0x013B, 0xBED0, 0xA8EA, 0xC0E7,
    0x0A0B, 0x387E, 0x5ACC, 0x3732, 0x0272, 0xAFFF, 0xA1C0, 0xBBC7,
    0x02D6, 0x3210, 0x5517, 0x4164, 0x0331, 0xC10D, 0xA284, 0xC9E6,
    0xF9AE, 0x3DC5, 0x5BD8, 0x4336, 0x0054, 0xC673, 0xAAD8, 0xC6A0,
    0x0415, 0x43E0, 0x5D68, 0x37AB, 0x06CB, 0xB6D8, 0xA662, 0xB7AB,
    0x0485, 0x4317, 0x580E, 0x3F4F, 0x06B0, 0xC404, 0xA231, 0xB7D6,
    0x00EE, 0x40ED, 0x5437, 0x36A9, 0xF7B7, 0xBEB8, 0x9F45, 0xBF64,
    0xFFAD, 0x44AD, 0x59E8, 0x41B1, 0x01F9, 0xC5FC, 0xAD1E, 0xCA33,
    0xF811, 0x437B, 0x533C, 0x395E, 0xFD8D, 0xB87C, 0x9ADB, 0xCA97,
    0xFEB2, 0x3601, 0x5AEC, 0x3D1E, 0x0399, 0xBCFE, 0xAA69, 0xC0EF,
    0xFB95, 0x46F7, 0x559A, 0x386E, 0xFD56, 0xC294, 0xAF0F, 0xB4EF,
    0xFBDB, 0x3C62, 0x53D6, 0x4258, 0xF14C, 0xC2CA, 0xAB87, 0xC7AD,
    0x0044, 0x3994, 0x587C, 0x3C0D, 0x036F, 0xC567, 0xA631, 0xBC68,
    0x07DD, 0x41F4, 0x4FAC, 0x43C5, 0xFAE7, 0xCA53, 0xA898, 0xBCB2,
    0xFA7D, 0x4192, 0x5929, 0x4459, 0x020A, 0xB866, 0xA820, 0xBE17,
    0x0800, 0x3EB2, 0x5ABE, 0x33F7, 0xF8CF, 0xC026, 0xB0BF, 0xCB8A,
    0x06C1, 0x44CA, 0x62E0, 0x4164, 0xFA6A, 0xC0F6, 0xB5AE, 0xC41B,
    0x036A, 0x374F, 0x60FB, 0x3E6E, 0x001D, 0xC892, 0x9BFB, 0xBC31,
    0x001D, 0x3D92, 0x5652, 0x45C8, 0x080B, 0xC0D4, 0xA63E, 0xBC68,
    0x01DF, 0x3BEA, 0x59C1, 0x4104, 0x035E, 0xAE61, 0xAD6E, 0xC403,
    0x07D1, 0x3FB4, 0x56FF, 0x4649, 0x0880, 0xBE63, 0xA6DA, 0xC68F,
    0x067D, 0x3D6E, 0x509B, 0x4131, 0x03FB, 0xC30A, 0x9FE1, 0xB5C5,
    0x061E, 0x3337, 0x596D, 0x4652, 0x0721, 0xBAB1, 0xA95B, 0xB533,
    0x04C7, 0x386C, 0x568D, 0x3A23, 0xFF32, 0xBC6B, 0xAF68, 0xC977,
    0x0426, 0x4371, 0x5E95, 0x36A1, 0xFB4A, 0xB6EE, 0xA950, 0xBF6E,
    0x0D55, 0x401F, 0x69C6, 0x3B6D, 0xF8CB, 0xB2FD, 0x9E2A, 0xBF55,
    0x00A0, 0x3D2D, 0x637C, 0x3D70, 0xFF46, 0xC17A, 0x9E59, 0xBCA8,
    0xF3B8, 0x3F1B, 0x60C6, 0x4F96, 0xF887, 0xBA52, 0x9E64, 0xBDF8,
    0xFC95, 0x40FA, 0x5A76, 0x4330, 0xFBBA, 0xC920, 0x9973, 0xC3B2,
    0xFF8E, 0x4086, 0x6297, 0x3E07, 0x07F4, 0xBAB7, 0x9C9A, 0xBAF1,
    0x0773, 0x3B2D, 0x699A, 0x44BD, 0x00A5, 0xC146, 0xA8A3, 0xC945,
    0x0777, 0x437D, 0x58DE, 0x4475, 0x0B5D, 0xC76D, 0xA168, 0xC598,
    0x0326, 0x4595, 0x5ED7, 0x3FFB, 0xFB51, 0xCC82, 0xADEA, 0xBA2A,
    0x0BF5, 0x468C, 0x5DFC, 0x3CD1, 0x059C, 0xB81A, 0xAAEA, 0xBA8F,
    0x093A, 0x4785, 0x627A, 0x3E24, 0xFA83, 0xB6E7, 0xBBEB, 0xBD64,
    0xF09A, 0x3BA6, 0x5945, 0x3C9E, 0x0A1D, 0xD25F, 0xAB83, 0xBEDD,
    0xFC8C, 0x4256, 0x567A, 0x3DF4, 0x0537, 0xB260, 0xA58A, 0xBA5E,
    0x02AD, 0x4267, 0x61B2, 0x3F67, 0x0638, 0xCAEB, 0xA5EB, 0xC503,
    0x0137, 0x427F, 0x5A35, 0x43B1, 0xFA85, 0xBD44, 0xAC3D, 0xB74D,
    0x0596, 0x410C, 0x638D, 0x41E2, 0xF5E3, 0xCA0C, 0x94A7, 0xBF3F,
    0xFE1A, 0x382D, 0x5965, 0x44F0, 0xFFAA, 0xC639, 0xB603, 0xC9FB,
    0xF945, 0x41F7, 0x5D22, 0x4648, 0x05F0, 0xB81A, 0xA9AB, 0xB87F,
    0xF7E9, 0x4357, 0x5B93, 0x3913, 0x018C, 0xC60F, 0xA83B, 0xC6AF,
    0xFC90, 0x440E, 0x6179, 0x4E8A, 0x0324, 0xBE61, 0xA111, 0xCF44,
    0xFEEA, 0x3FB2, 0x52A7, 0x3FC2, 0x009A, 0xC0E5, 0xA78A, 0xC28A,
    0xFE94, 0x41B2, 0x61A8, 0x43F1, 0xFA1D, 0xC146, 0xAC37, 0xB7C0,
    0x00AF, 0x3E52, 0x592A, 0x3329, 0x0097, 0xC66D, 0xA56C, 0xBECA,
    0xFB35, 0x3EF1, 0x6014, 0x3819, 0xFD0E, 0xBAC0, 0xA4A8, 0xC88E,
    0x01CC, 0x4369, 0x5983, 0x459A, 0xFC18, 0xC3CA, 0xAC2B, 0xB8B6,
    0x02D5, 0x4092, 0x60F8, 0x3B89, 0xF229, 0xC5FB, 0x9B8A, 0xC276,
    0xFD64, 0x3F68, 0x6669, 0x3E51, 0xFC01, 0xBBCF, 0xAAA8, 0xCCD1,
    0x01A8, 0x3CAE, 0x5A25, 0x42C4, 0xFCAC, 0xC35A, 0xA391, 0xB787,
    0x05F6, 0x4CCF, 0x5821, 0x4846, 0xFD61, 0xB70E, 0xAA65, 0xC69F,
    0xFF66, 0x3BD0, 0x589D, 0x3A2C, 0x07B8, 0xC54A, 0xA407, 0xC97B,
    0x0AC7, 0x3DB8, 0x5BD3, 0x47B7, 0xFDC6, 0xCA04, 0xA10C, 0xC398,
    0xFFB7, 0x4576, 0x5C6F, 0x38ED, 0x1011, 0xC28C, 0xA474, 0xC243,
    0x086D, 0x418A, 0x5DDC, 0x3300, 0xFCC2, 0xBD3B, 0xA940, 0xC28F,
    0x047A, 0x4606, 0x4D8F, 0x3FD0, 0x08D0, 0xC391, 0xABA8, 0xC135,
    0xF41D, 0x4345, 0x479C, 0x4260, 0x076F, 0xC71B, 0xA897, 0xC854,
    0x106A, 0x3C8D, 0x55D4, 0x341D, 0xFB1A, 0xBF82, 0xA61C, 0xC02B,
    0xF8C0, 0x499A, 0x5F94, 0x3D12, 0x0006, 0xC0C6, 0xA2D9, 0xC591,
    0xF464, 0x3BF0, 0x5C59, 0x3483, 0x02C8, 0xC67C, 0xA134, 0xC979,
    0x000D, 0x43C6, 0x5471, 0x32E9, 0xFF39, 0xCA59, 0xA02D, 0xC14A,
    0xFC29, 0x39F2, 0x61EC, 0x4121, 0xFEA4, 0xC1F0, 0x9F8D, 0xD210,
    0x00DF, 0x4155, 0x5142, 0x3D98, 0xFA65, 0xC572, 0xA9E5, 0xBB79,
    0x09C6, 0x3ADD, 0x5E57, 0x40A9, 0xEED8, 0xCC19, 0xA501, 0xC55F,
    0xFD48, 0x4541, 0x5AB1, 0x3BCA, 0x0284, 0xB861, 0xA0F7, 0xC6FB,
    0x05D5, 0x4235, 0x6376, 0x3EE7, 0xF984, 0xCDBD, 0xAE9C, 0xB547,
    0x0990, 0x4497, 0x5BBF, 0x416C, 0x0829, 0xC992, 0xAB2D, 0xCDC5,
    0x025B, 0x3DFE, 0x58E6, 0x3BAA, 0xF656, 0xCD3A, 0xA52F, 0xBB7F,
    0x07D6, 0x46D9, 0x4C24, 0x3AAD, 0x05A4, 0xC9F2, 0xA744, 0xC399,
    0x0626, 0x3A4F, 0x6010, 0x3C68, 0xFC09, 0xBE22, 0xABF4, 0xBF85,
    0x011D, 0x484E, 0x57D4, 0x44EA, 0x0A42, 0xC28B, 0xAD72, 0xB72F,
    0xFD03, 0x37E0, 0x57C6, 0x3B7F, 0x01CF, 0xC488, 0xA65B, 0xB5D3,
    0xFF6E, 0x3A5D, 0x5D4B, 0x39CE, 0x045C, 0xB918, 0xA38A, 0xC85D,
    0x0083, 0x4399, 0x5525, 0x4536, 0x034B, 0xBEB7, 0xA955, 0xBE70,
    0xF9C0, 0x3974, 0x5375, 0x4736, 0xFCAF, 0xBE75, 0xA4C2, 0xC6D9
    };

static const q15_t in_rifft_noisy_4096[8194] = {
    0x0021, 0x0000, 0x0014, 0xFFCE, 0x000E, 0x001D, 0x000E, 0x0013,
    0xFFE5, 0x001C, 0xFFFB, 0x0008, 0x0001, 0x001D, 0xFFF1, 0x0001,
    0x001C, 0xFFFD, 0xFFF6, 0xFFE9, 0xFFDE, 0x0012, 0x0007, 0xFFF4,
    0x000F, 0x0006, 0x0005, 0x0005, 0xFFF6, 0x0020, 0x0009, 0x0003,
    0xFFF2, 0x0029, 0x0003, 0xFFEA, 0x0012, 0x0001, 0xFFFE, 0x0012,
    0x001A, 0xFFFE, 0xFFF9, 0xFFEE, 0xFFF1, 0xFFFA, 0xFFFB, 0xFFE0,
    0xFFF5, 0x0012, 0x0019, 0xFFDE, 0xFFF7, 0x0026, 0xFFD2, 0x002B,
    0x0000, 0x0014, 0x000A, 0x0019, 0xFFFB, 0x0005, 0xFFF5, 0xFFEA,
    0xFFE9, 0xFFFE, 0x000C, 0xFFEF, 0x000A, 0x000F, 0x0000, 0x0009,
    0xFFEE, 0x000C, 0x0007, 0xFFDB, 0x000F, 0x001C, 0x000B, 0xFFE0,
    0xFFD1, 0xFFED, 0xFFE7, 0xFFCF, 0x001D, 0xFFEC, 0x0000, 0xFFF4,
    0xFFF8, 0xFFE7, 0x0002, 0x0028, 0xFFF5, 0xFFF9, 0x001F, 0xFFF2,
    0x0014, 0x000C, 0xFFE4, 0x0009, 0x000C, 0x0000, 0x0006, 0x0004,
    0xFFF3, 0x0002, 0xFFFB, 0xFFE8, 0xFFF6, 0x000C, 0xFFFB, 0xFFEE,
    0x000D, 0x0006, 0x000B, 0x0005, 0x0002, 0x0000, 0x0008, 0xFFFA,
    0x000A, 0x0001, 0x0000, 0x0008, 0xFFF6, 0x001F, 0x000F, 0xFFEA,
    0xFFE6, 0xFFE6, 0x001A, 0x0011, 0xFFFC, 0x0002, 0x0009, 0xFFED,
    0xFFF8, 0x0021, 0x0012, 0x0015, 0xFFF1, 0xFFF3, 0x0008, 0x0005,
    0x0016, 0x0023, 0xFFE2, 0xFFFB, 0x0026, 0x000C, 0x0015, 0x0006,
    0x000E, 0xFFF4, 0x0007, 0xFFF9, 0x0021, 0xFFDF, 0x0007, 0x000C,
    0x0013, 0xFFF6, 0xFFF6, 0x0012, 0xFFEF, 0xFFFF, 0x0005, 0xFFDC,
    0xFFFC, 0xFFE9, 0x0018, 0xFFF3, 0xFFE0, 0x0010, 0xFFE3, 0xFFD6,
    0xFFDE, 0xFFF6, 0x0015, 0x0011, 0x0009, 0x000A, 0x0004, 0x0002,
    0x0006, 0xFFEC, 0xFFFB, 0x001E, 0x000E, 0x0005, 0xFFE9, 0xFFFD,
    0xFFD4, 0x0003, 0x0010, 0x0000, 0x0005, 0xFFFC, 0x0009, 0x0022,
    0xFFF9, 0x000F, 0x0007, 0xFFFA, 0x0008, 0xFFEA, 0x0004, 0x0001,
    0x0015, 0xFFFB, 0x0007, 0x0006, 0x0010, 0x0000, 0xFFEC, 0xFFDD,
    0x001A, 0xFFFB, 0x0013, 0xFFF9, 0xFFF4, 0xFFF9, 0x000C, 0x0004,
    0x0007, 0xFFFA, 0xFFF1, 0xFFE7, 0x000E, 0xFFFF, 0xFFEE, 0x002B,
    0xFFEC, 0x0006, 0x002D, 0xFFE6, 0x0011, 0x0002, 0xFFF9, 0xFFFC,
    0x0010, 0x0028, 0x000D, 0x0014, 0xFFFE, 0xFFD4, 0xFFF6, 0x0000,
    0xFFDC, 0x0010, 0x0014, 0xFFF0, 0x0010, 0xFFF2, 0xFFFC, 0xFFFD,
    0x0005, 0x0026, 0xFFF2, 0xFFFD, 0xFFD0, 0x000C, 0xFFF8, 0xFFF2,
    0xFFF1, 0x000B, 0x0003, 0xFFFB, 0xFFF0, 0x001D, 0xFFFF, 0x0000,
    0xFFF7, 0x001D, 0x000B, 0xFFFE, 0x0004, 0x0005, 0x0002, 0xFFFE,
    0x0008, 0x0027, 0x0002, 0xFFF2, 0x001B, 0xFFF5, 0x0002, 0xFFEA,
    0xFFE0, 0xFFE8, 0x0002, 0x0019, 0xFFEF, 0x000D, 0x0003, 0x001D,
    0xFFFB, 0x0006, 0xFFF4, 0xFFF0, 0xFFCD, 0xFFF7, 0xFFE8, 0x0016,
    0x000C, 0x0006, 0xFFF7, 0xFFFF, 0x000D, 0xFFF5, 0x0003, 0x0017,
    0x0000, 0x0018, 0x0013, 0xFFFA, 0x0023, 0x001B, 0x000F, 0xFFEA,
    0x0014, 0xFFE4, 0xFFF8, 0xFFFC, 0x0014, 0xFFFF, 0x000B, 0xFFFB,
    0xFFFD, 0xFFFC, 0xFFE5, 0xFFDA, 0xFFF1, 0x0016, 0x0001, 0x0000,
    0x001C, 0xFFFF, 0x0012, 0xFFFE, 0x002C, 0x0004, 0xFFF1, 0xFFEF,
    0xFFF8, 0x0008, 0x0010, 0xFFC2, 0xFFFD, 0x0005, 0x0009, 0xFFED,
    0xFFED, 0x0001, 0x0003, 0xFFE2, 0xFFE7, 0xFFF2, 0xFFEA, 0x001D,
    0xFFFA, 0xFFF4, 0x0013, 0x0004, 0x000B, 0xFFF5, 0xFFF8, 0x0022,
    0x000E, 0xFFEE, 0x0018, 0x000A, 0x0014, 0x000A, 0xFFF4, 0xFFE7,
    0x0012, 0x000F, 0xFFE8, 0xFFEC, 0xFFFF, 0xFFF4, 0xFFEE, 0xFFF7,
    0x000F, 0xFFE3, 0xFFED, 0xFFED, 0xFFF6, 0x000C, 0xFFF1, 0x0003,
    0x0018, 0xFFEC, 0x0016, 0x000C, 0xFFEC, 0x0014, 0x000D, 0xFFE7,
    0x000F, 0x000B, 0x0016, 0x0014, 0xFFF8, 0xFFF7, 0xFFE9, 0x000D,
    0xFFEB, 0x0015, 0xFFF8, 0xFFF2, 0x000F, 0xFFFF, 0xFFF1, 0xFFF5,
    0x002D, 0xFFE6, 0xFFFD, 0xFFF1, 0xFFE7, 0xFFE7, 0xFFF4, 0xFFFC,
    0x000B, 0xFFFE, 0x0016, 0xFFF9, 0xFFF9, 0x0006, 0x0010, 0x0011,
    0xFFEA, 0xFFEA, 0xFFEE, 0x0020, 0xFFEE, 0x000B, 0x001A, 0x0001,
    0x0011, 0xFFDE, 0x0011, 0xFFF6, 0x0002, 0x0005, 0xFFEF, 0xFFCB,
    0xFFF9, 0x0016, 0x0009, 0xFFF7, 0xFFFA, 0xFFEF, 0xFFF9, 0x0019,
    0x0005, 0xFFFD, 0x0024, 0xFFFB, 0x0008, 0x0019, 0x0011, 0x0005,
    0xFFE9, 0x0005, 0xFFEA, 0xFFF1, 0x002E, 0xFFF8, 0xFFFB, 0xFFEF,
    0x0010, 0xFFFE, 0xFFFD, 0x0014, 0x0004, 0x0005, 0x0003, 0x001B,
    0xFFFA, 0xFFF3, 0xFFFE, 0xFFD9, 0x000F, 0xFFE2, 0xFFEF, 0x002E,
    0x0016, 0x0003, 0x0003, 0x0002, 0x0014, 0x0002, 0x0004, 0x001C,
    0x0001, 0x000D, 0xFFFD, 0xFFF4, 0xFFFB, 0xFFF2, 0xFFFC, 0x0007,
    0x000A, 0x0012, 0x001F, 0xFFF6, 0x000D, 0xFFF7, 0x0015, 0x0003,
    0xFFF7, 0xFFEE, 0xFFF3, 0xFFF3, 0x000D, 0xFFFD, 0x000E, 0xFFF9,
    0xFFF0, 0x0014, 0x0002, 0x0000, 0xFFE7, 0x0017, 0x0003, 0xFFE9,
    0x0007, 0x0001, 0x0012, 0xFFFD, 0xFFF3, 0xFFFF, 0xFFE2, 0xFFEA,
    0xFFFA, 0xFFEB, 0xFFF5, 0x0009, 0xFFF8, 0x0007, 0x0006, 0x000D,
    0x0013, 0xFFF8, 0x0014, 0x000E, 0xFFF9, 0x0026, 0xFFEE, 0xFFFC,
    0xFFFB, 0x0014, 0x000B, 0xFFF0, 0xFFF1, 0x0029, 0xFFEF, 0xFFFA,
    0xFFEC, 0xFFFE, 0x0032, 0xFFE7, 0xFFE0, 0x000D, 0x0005, 0xFFF2,
    0xFFDE, 0xFFFC, 0x0014, 0xFFFB, 0x0010, 0x0001, 0x000A, 0x0013,
    0x0007, 0x0010, 0x0007, 0xFFFB, 0x000A, 0x0023, 0x0017, 0x0007,
    0xFFDC, 0x0017, 0x000A, 0xFFF7, 0x0004, 0xFFED, 0x0003, 0xFFE9,
    0x0007, 0x0009, 0x0014, 0xFFE5, 0x0002, 0x000D, 0x0001, 0xFFEF,
    0x0010, 0xFFF0, 0x001A, 0xFFF1, 0xFFFA, 0xFFE5, 0xFFFA, 0x0004,
    0x001D, 0xFFE4, 0xFFF4, 0xFFF6, 0xFFDD, 0xFFD6, 0xFFFB, 0xFFDC,
    0x001D, 0x0007, 0x0023, 0x0000, 0x000C, 0x000F, 0x0020, 0xFFF8,
    0x0000, 0x0014, 0x0002, 0x000B, 0xFFEE, 0xFFE6, 0x000A, 0x0024,
    0xFFF7, 0x002C, 0x0016, 0x0022, 0xFFF7, 0x0008, 0x0013, 0xFFFF,
    0xFFFF, 0x0017, 0x0006, 0xFFE6, 0x001A, 0xFFFE, 0x0016, 0x0002,
    0xFFF2, 0xFFE8, 0x0011, 0x000B, 0x0001, 0x0005, 0x000C, 0xFFE7,
    0xFFFB, 0x0003, 0x0019, 0xFFF3, 0xFFF2, 0xFFEB, 0xFFF4, 0xFFF8,
    0xFFF5, 0x0002, 0x001E, 0xFFEC, 0x0005, 0xFFD3, 0x0008, 0x0008,
    0x0000, 0xFFF6, 0x0032, 0x0010, 0x0001, 0xFFEA, 0x002C, 0x002C,
    0xFFEA, 0x0000, 0xFFF3, 0xFFFB, 0x000B, 0xFFF3, 0x001C, 0x0005,
    0xFFD7, 0x0002, 0xFFF3, 0x000F, 0x0001, 0x0003, 0x0019, 0xFFEC,
    0xFFE3, 0xFFF6, 0xFFE0, 0x0002, 0x000C, 0x000C, 0x0009, 0x0007,
    0xFFF3, 0xFFF9, 0x0006, 0xFFEA, 0xFFDC, 0xFFF1, 0xFFF3, 0xFFFF,
    0xFFFD, 0x000A, 0x000E, 0x0006, 0xFFD9, 0x0005, 0x0014, 0xFFF9,
    0xFFF3, 0xFFEC, 0x0003, 0x0014, 0x0018, 0xFFE6, 0xFFEB, 0xFFF4,
    0x0004, 0x0019, 0x0002, 0xFFF7, 0x0010, 0xFFF8, 0xFFE4, 0xFFF9,
    0x0004, 0xFFFF, 0x000E, 0x000E, 0x0004, 0x0020, 0x0001, 0xFFF1,
    0xFFFC, 0x0000, 0x0001, 0x0006, 0xFFFE, 0x000B, 0xFFF9, 0x0016,
    0x0013, 0x0002, 0x0007, 0x000B, 0xFFE1, 0xFFEE, 0xFFEE, 0x0017,
    0xFFC9, 0x0000, 0xFFF0, 0x000A, 0xFFF3, 0x0011, 0xFFFF, 0x000A,
    0x001B, 0x0007, 0xFFEC, 0xFFFE, 0x0021, 0x0013, 0x0000, 0xFFF1,
    0xFFFC, 0x001F, 0xFFF8, 0x0028, 0xFFDD, 0xFFE6, 0x0015, 0xFFF3,
    0x0011, 0xFFD5, 0x000E, 0xFFD7, 0xFFFB, 0x0016, 0x000A, 0xFFFC,
    0xFFF6, 0x001C, 0x0009, 0xFFF0, 0xFFEC, 0x0017, 0xFFF0, 0xFFFD,
    0xFFF9, 0xFFFC, 0xFFF5, 0xFFF5, 0xFFD5, 0x000F, 0x0018, 0xFFFF,
    0x0001, 0xFFE8, 0x0006, 0x0000, 0xFFF0, 0x000A, 0x000A, 0x0008,
    0x0016, 0x000A, 0xFFE9, 0xFFF6, 0xFFFC, 0xFFDC, 0xFFEF, 0xFFF1,
    0xFFF5, 0x000E, 0xFFF7, 0xFFE4, 0x001A, 0x0000, 0xFFF0, 0x0003,
    0xFFE3, 0xFFFF, 0x000E, 0xFFF8, 0xFFFB, 0xFFFA, 0x0010, 0xFFEE,
    0xFFF5, 0x000C, 0x0021, 0xFFF7, 0x0007, 0x000C, 0x000D, 0x0005,
    0x0018, 0xFFF8, 0x001C, 0x000B, 0x0000, 0x0007, 0x001F, 0x000D,
    0xFFED, 0xFFDE, 0x0000, 0xFFDE, 0xFFEC, 0xFFEE, 0xFFF4, 0x0028,
    0x0008, 0xFFF3, 0x0001, 0x0009, 0x0004, 0xFFFA, 0x000A, 0x0014,
    0xFFFC, 0x000B, 0xFFF7, 0x000B, 0xFFFA, 0x0016, 0xFFF8, 0x0000,
    0xFFE7, 0x0008, 0x0012, 0xFFFD, 0x0004, 0xFFE0, 0x0015, 0x0001,
    0xFFEC, 0x0016, 0xFFFC, 0x0004, 0xFFFB, 0x0007, 0xFFF9, 0x0002,
    0x0009, 0x0004, 0x0001, 0x0009, 0xFFE6, 0xFFE4, 0xFFE1, 0xFFE3,
    0x0003, 0x0004, 0xFFFD, 0x0005, 0xFFFC, 0xFFFF, 0x0011, 0x0014,
    0xFFED, 0x0031, 0xFFFF, 0xFFFB, 0xFFDD, 0xFFE6, 0x0019, 0x0035,
    0x000C, 0xFFE5, 0xFFF5, 0xFFED, 0x0006, 0x000B, 0x0004, 0x000D,
    0x0004, 0x0004, 0x0003, 0x0025, 0xFFFE, 0xFFFD, 0xFFEB, 0xFFFB,
    0xFFE4, 0x0004, 0xFFEF, 0xFFF3, 0xFFFE, 0xFFF7, 0xFFEA, 0x0003,
    0x0018, 0x0014, 0x0004, 0x001B, 0x001A, 0x000A, 0x0005, 0x0003,
    0x0026, 0x0021, 0x0004, 0xFFF8, 0xFFF9, 0xFFFF, 0x000B, 0x0015,
    0xFFF7, 0x0000, 0x000A, 0x0002, 0x0027, 0x0028, 0xFFEA, 0xFFFB,
    0x0026, 0xFFF7, 0xFFF4, 0x0017, 0x0000, 0xFFEB, 0x001D, 0x0019,
    0xFFF6, 0xFFEC, 0xFFE4, 0xFFE7, 0xFFF3, 0xFFF4, 0x0001, 0x0003,
    0x0002, 0xFFF9, 0x0019, 0xFFF9, 0xFFEE, 0xFFD7, 0x000F, 0x0013,
    0x001C, 0x000E, 0xFFE8, 0x0009, 0xFFE2, 0xFFE9, 0xFFEA, 0xFFEB,
    0xFFF4, 0x0009, 0x0001, 0x0000, 0x0020, 0xFFE3, 0x0007, 0x0002,
    0x001C, 0xFFF3, 0xFFE2, 0x0004, 0x0019, 0x0012, 0xFFF1, 0x0010,
    0x000F, 0x000F, 0xFFFD, 0x000A, 0x0006, 0xFFF7, 0x0015, 0xFFEB,
    0xFFFD, 0xD332, 0x001B, 0xFFF0, 0x0014, 0x000C, 0xFFE9, 0xFFF7,
    0x0013, 0x0007, 0xFFEF, 0xFFF2, 0xFFDB, 0x001B, 0xFFEC, 0x001A,
    0xFFE8, 0x0019, 0x0000, 0x001D, 0xFFF4, 0x0010, 0x000D, 0xFFE1,
    0xFFDB, 0xFFED, 0xFFED, 0x0011, 0x000E, 0xFFFD, 0x0007, 0xFFFB,
    0x0003, 0xFFE0, 0xFFCC, 0x000E, 0xFFDA, 0xFFF5, 0x0004, 0x0013,
    0xFFF6, 0xFFFD, 0x001E, 0xFFF3, 0x000E, 0x0008, 0xFFFD, 0x0015,
    0x0005, 0xFFEF, 0x0017, 0x002D, 0xFFF3, 0x0014, 0xFFFD, 0xFFF8,
    0xFFF8, 0xFFEB, 0x0011, 0x0006, 0xFFEC, 0xFFF1, 0x0009, 0xFFE4,
    0x0005, 0x0008, 0xFFDC, 0xFFF4, 0x000D, 0xFFF9, 0x001E, 0xFFF0,
    0xFFF9, 0xFFFA, 0xFFFB, 0x000D, 0xFFF2, 0xFFDC, 0x000B, 0xFFEA,
    0xFFFC, 0x000F, 0xFFF2, 0xFFE5, 0x0000, 0xFFE4, 0x0008, 0xFFE7,
    0xFFF5, 0xFFF9, 0xFFF2, 0x0017, 0x000C, 0xFFF2, 0xFFFA, 0xFFF8,
    0x0001, 0x0012, 0xFFFD, 0xFFFA, 0xFFFE, 0x0006, 0x0009, 0x0006,
    0xFFE8, 0x0001, 0x0007, 0xFFF7, 0x0001, 0x0002, 0xFFFE, 0x0004,
    0xFFFB, 0x0003, 0x0011, 0x0004, 0x000B, 0x000E, 0x0001, 0xFFE3,
    0xFFF7, 0x000B, 0xFFFA, 0x0015, 0x0008, 0x0024, 0xFFE2, 0xFFEB,
    0x001D, 0x0000, 0xFFE2, 0x0003, 0x000B, 0xFFF0, 0x000A, 0x0013,
    0x0018, 0x0011, 0x0012, 0xFFF1, 0xFFF0, 0x0005, 0x0006, 0x0020,
    0xFFE9, 0xFFE2, 0xFFFC, 0x0000, 0x0017, 0x001A, 0xFFEF, 0xFFEB,
    0xFFF8, 0x0011, 0x0005, 0xFFFB, 0xFFF7, 0xFFF9, 0xFFEB, 0x0003,
    0x0009, 0x0016, 0xFFF7, 0xFFF9, 0xFFF8, 0x0030, 0x0024, 0x0017,
    0xFFF3, 0x0019, 0x0004, 0x0005, 0x0004, 0x0010, 0x0000, 0xFFF8,
    0xFFF8, 0x000F, 0x0001, 0xFFFB, 0xFFF5, 0xFFF0, 0x000C, 0xFFFA,
    0x000C, 0x0004, 0xFFD8, 0x0007, 0x0003, 0x0008, 0x0013, 0x0013,
    0x0018, 0x000C, 0x0028, 0x0007, 0xFFFF, 0xFFFA, 0x0021, 0xFFD5,
    0xFFE7, 0xFFF5, 0x0013, 0x0013, 0xFFE5, 0xFFFB, 0xFFE2, 0x0013,
    0x0004, 0x0002, 0xFFFC, 0xFFEC, 0xFFFE, 0x0004, 0x0023, 0xFFF0,
    0x0002, 0x0005, 0xFFEB, 0xFFED, 0x0000, 0x001D, 0xFFE0, 0x002B,
    0xFFE6, 0x000E, 0xFFF3, 0x0025, 0x0003, 0x000F, 0xFFF3, 0xFFF3,
    0x001C, 0xFFE8, 0x0017, 0xFFF8, 0x000F, 0x0017, 0xFFFF, 0x0025,
    0xFFEF, 0xFFFA, 0x0023, 0xFFEC, 0x0010, 0x0003, 0xFFFB, 0x000A,
    0x0009, 0xFFEE, 0x0008, 0x0017, 0x002C, 0x000B, 0xFFF4, 0xFFFA,
    0x0021, 0x0004, 0x000E, 0xFFF6, 0xFFFD, 0xFFF3, 0x0003, 0x0007,
    0xFFFD, 0xFFD9, 0xFFFA, 0x0005, 0xFFF2, 0xFFFF, 0x0017, 0x0007,
    0xFFF2, 0x0011, 0xFFE2, 0x0001, 0xFFF2, 0x0002, 0xFFFE, 0x0004,
    0xFFFC, 0xFFF2, 0x0004, 0xFFED, 0xFFFD, 0xFFF0, 0x0009, 0x0006,
    0x0018, 0xFFEB, 0xFFEE, 0xFFFE, 0xFFEF, 0x0001, 0xFFE1, 0xFFF8,
    0x0012, 0xFFF5, 0xFFDC, 0xFFFE, 0x0009, 0xFFFA, 0x001B, 0x0003,
    0xFFDB, 0x001D, 0x000D, 0xFFFF, 0x0012, 0xFFF3, 0x0013, 0x000E,
    0x0006, 0xFFFC, 0x0003, 0x002B, 0x0007, 0xFFF9, 0xFFE4, 0x0004,
    0x0013, 0x0004, 0xFFFF, 0xFFFA, 0xFFF9, 0x0013, 0x0002, 0xFFE6,
    0x000E, 0xFFDE, 0xFFF3, 0x0003, 0xFFFB, 0xFFE5, 0xFFEB, 0x0000,
    0x001B, 0xFFFF, 0x0017, 0x0016, 0x0014, 0xFFFE, 0xFFF4, 0x000C,
    0xFFE5, 0x0006, 0x0015, 0x000A, 0x0004, 0x000B, 0x0009, 0xFFDD,
    0x001F, 0xFFFF, 0x0005, 0xFFFC, 0xFFED, 0xFFE8, 0xFFE4, 0x000F,
    0x000D, 0x0000, 0x0007, 0x0009, 0x001A, 0xFFF8, 0xFFE7, 0x0015,
    0xFFF4, 0x0002, 0xFFFF, 0x0004, 0xFFF0, 0xFFF5, 0xFFF6, 0xFFD3,
    0x000D, 0xFFDB, 0x0007, 0xFFEB, 0xFFF1, 0x0016, 0xFFF8, 0xFFF0,
    0x000A, 0x000B, 0x0017, 0x0013, 0x0012, 0xFFF7, 0x0014, 0xFFFD,
    0xFFFF, 0xFFFF, 0x0009, 0xFFEC, 0xFFF6, 0x0011, 0x001E, 0xFFEF,
    0x0005, 0x0011, 0xFFF8, 0x0000, 0x0015, 0xFFF9, 0x000A, 0xFFF9,
    0xFFF5, 0x0002, 0x000D, 0x0015, 0xFFFF, 0xFFEB, 0x0015, 0x0006,
    0x0007, 0x000C, 0x0008, 0xFFF7, 0x0032, 0x000B, 0xFFEA, 0x0024,
    0xFFE9, 0x0002, 0x001F, 0x0001, 0x0008, 0xFFF8, 0x000D, 0x0005,
    0x0008, 0xFFF1, 0x0003, 0xFFF4, 0x000C, 0xFFFB, 0xFFFC, 0xFFEA,
    0x0007, 0x0017, 0xFFF7, 0x0009, 0x0025, 0xFFD9, 0xFFDD, 0x0002,
    0xFFFC, 0x0011, 0xFFFE, 0xFFED, 0xFFE7, 0xFFEB, 0x0024, 0xFFF6,
    0x0009, 0xFFFE, 0x0019, 0xFFE3, 0x0035, 0x0010, 0x000E, 0xFFFD,
    0xFFEA, 0xFFF3, 0x0016, 0xFFEC, 0x0013, 0x0016, 0x000D, 0x0003,
    0xFFE2, 0x0003, 0xFFE0, 0x0003, 0xFFF3, 0xFFF6, 0x000E, 0xFFEC,
    0x0008, 0xFFF5, 0x0001, 0x0012, 0xFFFF, 0xFFFF, 0xFFD3, 0xFFEE,
    0x0006, 0x0005, 0x0009, 0xFFFD, 0xFFDF, 0xFFE7, 0xFFF9, 0xFFF7,
    0xFFFF, 0x000D, 0x001E, 0xFFEC, 0xFFF4, 0x000C, 0x0009, 0x0000,
    0xFFF5, 0xFFFA, 0x0016, 0x0004, 0xFFEC, 0x0032, 0x000A, 0x0001,
    0xFFFD, 0x0002, 0x0002, 0xFFFB, 0xFFFE, 0x000D, 0xFFE6, 0xFFE7,
    0xFFF9, 0x000A, 0xFFF9, 0xFFF2, 0x000C, 0x000A, 0x0005, 0x0000,
    0x000C, 0x0004, 0x001A, 0xFFF6, 0x0011, 0xFFF2, 0xFFF8, 0x0001,
    0xFFEA, 0x0015, 0xFFF9, 0xFFE5, 0xFFFE, 0x0000, 0xFFF0, 0x0017,
    0xFFED, 0x000F, 0x0018, 0xFFFC, 0x000F, 0xFFE7, 0x0001, 0x000B,
    0x0017, 0x000B, 0x0008, 0x000E, 0x000B, 0xFFF9, 0x0022, 0x0019,
    0x0001, 0x0001, 0x0025, 0x0006, 0x0010, 0x000C, 0x0002, 0xFFF4,
    0xFFEC, 0x0007, 0xFFE9, 0xFFF6, 0xFFFD, 0xFFFD, 0xFFF7, 0xFFFE,
    0xFFF4, 0xFFEF, 0x000A, 0x0005, 0x0006, 0xFFF8, 0xFFF3, 0xFFEC,
    0xFFFE, 0xFFF3, 0x0009, 0x000B, 0x000B, 0x0006, 0xFFE5, 0xFFDD,
    0x001B, 0xFFFF, 0x0003, 0xFFF0, 0xFFE4, 0xFFFD, 0xFFEE, 0x0025,
    0xFFF1, 0xFFF8, 0xFFF7, 0x0004, 0x0004, 0xFFFB, 0xFFE9, 0x0038,
    0x000A, 0xFFE9, 0x0012, 0xFFFB, 0x001D, 0xFFDF, 0xFFF1, 0xFFF6,
    0xFFFA, 0x0011, 0x0014, 0xFFF9, 0x0029, 0xFFFF, 0xFFF3, 0xFFFE,
    0x0004, 0xFFFA, 0x0024, 0x0005, 0x0030, 0x0018, 0xFFF4, 0x0012,
    0xFFF3, 0x002C, 0xFFDF, 0xFFF9, 0x000D, 0x0008, 0xFFF5, 0x0007,
    0x0008, 0x0006, 0xFFFC, 0xFFF5, 0x0003, 0x0021, 0x0010, 0x001D,
    0xFFEA, 0xFFF3, 0xFFFC, 0x0025, 0xFFF5, 0xFFFB, 0xFFD8, 0xFFEF,
    0x001A, 0xFFF1, 0xFFDE, 0xFFF5, 0xFFE6, 0xFFF6, 0xFFF2, 0x0024,
    0xFFFA, 0xFFF5, 0x000C, 0x001F, 0xFFF7, 0x000C, 0xFFF9, 0xFFEC,
    0x0003, 0xFFFF, 0xFFFE, 0xFFFA, 0x001D, 0xFFF6, 0xFFEC, 0x000F,
    0x0012, 0xFFE5, 0xFFF1, 0x0014, 0xFFF5, 0xFFF1, 0x000F, 0x0001,
    0xFFEA, 0xFFDE, 0x0009, 0x0019, 0x0015, 0x0002, 0x000F, 0xFFFB,
    0xFFF4, 0xFFE6, 0x0011, 0x0007, 0x0013, 0xFFF5, 0x0014, 0xFFF2,
    0xFFE1, 0x0009, 0x0027, 0xFFDF, 0x0002, 0xFFFE, 0x000A, 0x0017,
    0x001E, 0xFFFC, 0xFFE2, 0xFFEA, 0xFFDF, 0x001B, 0xFFDD, 0xFFF0,
    0xFFF0, 0x0010, 0x0005, 0xFFFA, 0x0004, 0x000B, 0x0001, 0x0002,
    0xFFF7, 0xFFF5, 0xFFF0, 0xFFF3, 0xFFFB, 0xFFF5, 0x0018, 0xFFF2,
    0xFFF4, 0xFFF1, 0x0001, 0x0027, 0x0009, 0xFFFB, 0x0003, 0xFFFB,
    0xFFFE, 0xFFE1, 0xFFEC, 0xFFFC, 0xFFE7, 0x000D, 0x001A, 0x0036,
    0x0017, 0x0013, 0x0003, 0x000A, 0xFFFE, 0x001A, 0xFFFE, 0x0005,
    0x0001, 0xFFF9, 0xFFFD, 0xFFFF, 0xFFFA, 0xFFF9, 0x0018, 0xFFF5,
    0x0013, 0x0011, 0x000A, 0xFFFE, 0xFFFE, 0x0004, 0xFFED, 0x000B,
    0x0014, 0x0006, 0x000C, 0xFFFD, 0xFFF5, 0x0004, 0x0012, 0xFFEE,
    0xFFFE, 0x0005, 0xFFF3, 0x0005, 0x0001, 0x0008, 0x000A, 0xFFFE,
    0xFFEB, 0xFFF3, 0x000D, 0xFFEA, 0x001C, 0xFFF7, 0x0011, 0x001B,
    0xFFF8, 0xFFE9, 0xFFF7, 0x0012, 0x0021, 0xFFFB, 0xFFF7, 0x0008,
    0xFFED, 0x0009, 0xFFFC, 0xFFF1, 0x0009, 0xFFFC, 0xFFF0, 0xFFF6,
    0x0004, 0x0012, 0x0007, 0x000E, 0xFFF9, 0xFFFF, 0x0016, 0x0005,
    0xFFEA, 0xFFF7, 0xFFF9, 0xFFEF, 0xFFF5, 0x0016, 0xFFF1, 0xFFFE,
    0xFFFE, 0x0019, 0xFFFC, 0x0001, 0x000B, 0xFFFE, 0x0002, 0xFFEC,
    0xFFF9, 0x000C, 0x0005, 0x0002, 0x0026, 0x0009, 0x0014, 0x000E,
    0x0005, 0xFFFC, 0x0005, 0x000D, 0xFFEF, 0xFFE1, 0x0021, 0xFFF8,
    0xFFFF, 0xFFF9, 0xFFF6, 0xFFF6, 0xFFF8, 0xFFFB, 0x0009, 0xFFFC,
    0xFFF0, 0x0009, 0x0010, 0xFFFF, 0x0005, 0x0010, 0x0001, 0xFFF6,
    0x0023, 0x000F, 0xFFF5, 0x0007, 0x0009, 0xFFF6, 0xFFF4, 0xFFFA,
    0xFFF1, 0xFFE8, 0x0007, 0x0016, 0xFFE3, 0xFFF8, 0x0007, 0xFFFD,
    0x0014, 0x0001, 0x0006, 0x0000, 0xFFF9, 0xFFCE, 0xFFFB, 0x0002,
    0x000F, 0x001B, 0x0000, 0x0008, 0xFFFC, 0x0028, 0x0017, 0x0026,
    0xFFFE, 0x000D, 0xFFE8, 0xFFF4, 0xFFFE, 0xFFE4, 0x0017, 0xFFE1,
    0x000A, 0x000A, 0xFFE9, 0xFFF3, 0x0012, 0x0012, 0x0001, 0x000D,
    0xFFED, 0xFFF7, 0x0008, 0xFFEB, 0xFFF5, 0x0004, 0x000C, 0x000E,
    0x0003, 0xFFE5, 0x0006, 0xFFFB, 0xFFF5, 0x0015, 0x0016, 0x0006,
    0x000B, 0x001D, 0x0019, 0x001C, 0xFFFA, 0x0018, 0xFFE5, 0x0003,
    0xFFE6, 0x0006, 0xFFFA, 0xFFFF, 0xFFED, 0x000D, 0xFFF1, 0x0008,
    0xFFFD, 0x000C, 0x0008, 0x0017, 0x0007, 0x000C, 0xFFFF, 0xFFF6,
    0x000D, 0x0008, 0x000B, 0xFFFA, 0xFFF8, 0xFFF0, 0xFFF0, 0x001C,
    0x001F, 0xFFFD, 0x000D, 0x0007, 0xFFFC, 0x0003, 0x0031, 0xFFFB,
    0xFFFB, 0xFFFC, 0xFFEF, 0x0000, 0xFFEA, 0xFFF0, 0x0031, 0xFFF8,
    0x000A, 0x0024, 0x002B, 0x002C, 0xFFF8, 0x000F, 0xFFE7, 0xFFD9,
    0xFFE9, 0x0014, 0xFFFC, 0x0006, 0x0006, 0xFFFE, 0xFFF8, 0xFFEA,
    0xFFF5, 0xFFF3, 0xFFF8, 0xFFF6, 0xFFF8, 0x0006, 0xFFF0, 0xFFEA,
    0x0020, 0x0000, 0xFFF2, 0x0001, 0x0001, 0xFFFD, 0xFFEF, 0xFFFB,
    0x000F, 0xFFF1, 0xFFF0, 0xFFFB, 0xFFF1, 0xFFFD, 0xFFFF, 0xFFFC,
    0xFFF5, 0x0005, 0x0008, 0x0003, 0x0009, 0x0015, 0xFFF4, 0xFFDD,
    0x002B, 0xFFE5, 0xFFF6, 0x0001, 0x000D, 0xFFEE, 0x0012, 0x000B,
    0x0001, 0x0016, 0x0018, 0x0010, 0x0004, 0xFFFA, 0x000B, 0x000B,
    0xFFFB, 0x0005, 0x0002, 0x000B, 0xFFFD, 0x000C, 0x0003, 0xFFDA,
    0x0000, 0xFFFE, 0xFFF0, 0x0003, 0xFFFD, 0x0005, 0x0004, 0x001A,
    0x001A, 0x0018, 0xFFF9, 0x0014, 0xFFFD, 0xFFEE, 0x0023, 0xFFF7,
    0x0012, 0xFFEE, 0x0017, 0x0007, 0x0004, 0xFFFA, 0xFFFB, 0xFFFD,
    0x000C, 0x0002, 0x0010, 0x001D, 0x0012, 0x0000, 0xFFEF, 0x0009,
    0x0005, 0x0010, 0xFFD5, 0xFFEA, 0xFFEE, 0xFFFC, 0x0004, 0x0014,
    0x002C, 0x000B, 0xFFE3, 0x0023, 0x0019, 0xFFF1, 0x0000, 0xFFFC,
    0xFFE4, 0xFFF6, 0x0016, 0xFFE3, 0xFFFA, 0x0004, 0xFFE8, 0x000B,
    0x000C, 0xFFEE, 0xFFE1, 0xFFEC, 0xFFFB, 0x0002, 0xFFF3, 0x0007,
    0xFFDA, 0x0013, 0xFFDF, 0x0005, 0xFFF2, 0x000E, 0xFFF7, 0x0000,
    0x0011, 0x0027, 0xFFFD, 0xFFED, 0x0002, 0xFFF8, 0x0020, 0x0017,
    0xFFF3, 0x000A, 0xFFED, 0xFFF8, 0xFFFC, 0x0003, 0x0007, 0x0017,
    0x0005, 0xFFEC, 0xFFED, 0xFFFD, 0xFFD9, 0xFFFE, 0xFFFE, 0xFFFD,
    0x000E, 0x0025, 0x0013, 0xFFF0, 0xFFF9, 0x000C, 0x001D, 0x0003,
    0x0000, 0x0017, 0x0007, 0xFFE3, 0xFFF4, 0xFFEA, 0xFFEE, 0x0004,
    0xFFF4, 0x0001, 0x0016, 0xFFF4, 0x0019, 0x000C, 0xFFF8, 0x0008,
    0x0006, 0xFFFD, 0xFFCE, 0xFFF5, 0x0006, 0x0016, 0x0017, 0xFFFF,
    0xFFFE, 0x0027, 0xFFEA, 0x0007, 0x0024, 0x001F, 0xFFF8, 0x002F,
    0xFFFE, 0xFFFF, 0x0018, 0x000E, 0xFFFB, 0x0005, 0x000A, 0x0003,
    0x000D, 0x0015, 0x0024, 0xFFF1, 0x001C, 0x000C, 0xFFF2, 0xFFFF,
    0xFFFA, 0x0015, 0xFFFA, 0x0003, 0xFFEC, 0xFFD2, 0x0006, 0x0000,
    0x000C, 0x0014, 0xFFF8, 0xFFFF, 0xFFF7, 0x000B, 0xFFE5, 0xFFF3,
    0xFFFA, 0x0002, 0x001B, 0xFFE3, 0x0018, 0x0004, 0x000A, 0xFFDE,
    0xFFFC, 0x0014, 0xFFF8, 0xFFE9, 0x000F, 0xFFFC, 0x0028, 0xFFE1,
    0x000D, 0x0003, 0xFFD7, 0xFFFD, 0xFFF2, 0x0003, 0x0002, 0xFFEB,
    0xFFDB, 0xFFF6, 0xFFF2, 0x0009, 0xFFE4, 0x0005, 0xFFFE, 0x001D,
    0x000A, 0x0005, 0xFFF5, 0xFFF8, 0xFFE3, 0x0000, 0xFFE8, 0xFFF9,
    0x0022, 0x000D, 0xFFEA, 0xFFFA, 0xFFEA, 0x0006, 0x0014, 0x0019,
    0xFFF2, 0xFFFF, 0xFFFD, 0x0000, 0xFFE6, 0xFFF1, 0xFFF7, 0x001C,
    0xFFF7, 0x0007, 0x0004, 0xFFF2, 0xFFFF, 0xFFFE, 0xFFF6, 0x0012,
    0x0016, 0x0005, 0xFFF3, 0x0009, 0xFFF8, 0xFFEA, 0x0003, 0xFFF3,
    0x0005, 0xFFF1, 0x0020, 0xFFF1, 0xFFF0, 0xFFFE, 0x0007, 0xFFFC,
    0x0010, 0xFFF3, 0x000C, 0xFFF9, 0xFFF7, 0x0022, 0xFFFA, 0x001B,
    0xFFF8, 0x0003, 0x0006, 0x0015, 0xFFED, 0xFFFF, 0x0010, 0xFFE3,
    0x000D, 0xFFEB, 0x0002, 0xFFEF, 0x0003, 0x0010, 0x001A, 0x0000,
    0x001D, 0xFFF9, 0xFFFB, 0x0016, 0x000A, 0xFFFC, 0x0002, 0xFFF3,
    0x0001, 0x0006, 0x000E, 0x0006, 0xFFE6, 0x0006, 0xFFFE, 0x0004,
    0xFFF9, 0x0004, 0xFFE6, 0xFFEE, 0x0008, 0xFFF4, 0x0007, 0xFFFD,
    0x001B, 0xFFF5, 0x0002, 0x0001, 0x000A, 0xFFE6, 0x0015, 0xFFFB,
    0xFFF7, 0x0003, 0xFFFC, 0x0013, 0xFFFD, 0xFFF3, 0x0015, 0xFFF2,
    0xFFFA, 0x0014, 0xFFF8, 0x0013, 0x0007, 0xFFFA, 0x0011, 0xFFE8,
    0x0013, 0x0007, 0xFFF7, 0xFFFB, 0x000D, 0xFFFF, 0xFFEA, 0xFFED,
    0xFFFB, 0x0022, 0x000E, 0xFFEF, 0x0002, 0xFFFA, 0xFFF3, 0xFFEF,
    0xFFFA, 0x0004, 0xFFF8, 0xFFFB, 0x0014, 0xFFF8, 0xFFFC, 0x000C,
    0x0007, 0xFFFA, 0xFFFE, 0xFFEB, 0xFFF8, 0x0001, 0x0006, 0x001D,
    0x0013, 0xFFF3, 0xFFF3, 0xFFF7, 0xFFFD, 0x000C, 0xFFFA, 0x0017,
    0xFFDF, 0x0007, 0x001E, 0xFFFF, 0xFFF5, 0xFFFF, 0xFFF9, 0xFFFB,
    0xFFFF, 0xFFFB, 0xFFE3, 0xFFFD, 0x0023, 0xFFF3, 0xFFE4, 0x0015,
    0x0008, 0xFFFC, 0x0003, 0xFFFB, 0xFFF4, 0xFFF5, 0xFFD4, 0x0002,
    0x0009, 0xFFFC, 0xFFF4, 0xFFE1, 0x000F, 0x000F, 0xFFF3, 0x0007,
    0x0004, 0x0002, 0xFFFC, 0xFFFA, 0xFFF9, 0xFFED, 0xFFFE, 0x0006,
    0xFFFC, 0x0001, 0xFFEA, 0xFFDD, 0x0007, 0x000A, 0xFFF8, 0x000D,
    0x0001, 0xFFEF, 0xFFEF, 0xFFDA, 0xFFFC, 0xFFE8, 0x000E, 0xFFE3,
    0xFFF5, 0x0003, 0xFFFF, 0x001A, 0x001B, 0x0002, 0x0005, 0x000E,
    0xFFFA, 0x0010, 0xFFF6, 0xFFF7, 0xFFEF, 0x0008, 0xFFF2, 0x0001,
    0x0004, 0xFFFE, 0x0012, 0x0002, 0x000E, 0x0001, 0x0003, 0xFFFE,
    0x0025, 0x0005, 0x0011, 0x0002, 0x0015, 0x000A, 0x001E, 0xFFFB,
    0x0001, 0x0005, 0x0011, 0xFFE4, 0xFFFD, 0xFFEB, 0xFFE2, 0x000B,
    0x0001, 0xFFF6, 0xFFE9, 0x0003, 0x0006, 0x0004, 0x000D, 0x000C,
    0x0022, 0x0026, 0x0024, 0x0018, 0xFFFD, 0xFFF0, 0x0009, 0x000D,
    0xFFFF, 0x001D, 0xFFED, 0x0013, 0xFFF0, 0xFFF7, 0x0002, 0x0004,
    0xFFE6, 0x0007, 0x000B, 0x0019, 0xFFE0, 0xFFFB, 0xFFF6, 0x0004,
    0xFFF8, 0x001A, 0xFFFB, 0xFFF6, 0x0008, 0xFFF8, 0xFFFE, 0x0013,
    0xFFF4, 0x0011, 0xFFDE, 0x000B, 0xFFF7, 0x0014, 0xFFE3, 0x0000,
    0xFFE9, 0x0002, 0x0013, 0x0010, 0xFFF4, 0x002E, 0xFFFB, 0x000A,
    0x0019, 0x0001, 0x0005, 0xFFE9, 0xFFF0, 0xFFF1, 0xFFFB, 0xFFF6,
    0x0002, 0xFFE5, 0xFFCC, 0xFFF1, 0xFFEE, 0xFFF3, 0x000C, 0x000B,
    0xFFEC, 0x0007, 0xFFF8, 0xFFDF, 0xFFF5, 0xFFF2, 0xFFFB, 0xFFE6,
    0x0007, 0x0008, 0x000C, 0xFFE1, 0xFFEB, 0x001B, 0x0024, 0xFFDC,
    0x0003, 0x0008, 0x000B, 0x0017, 0xFFEF, 0x000E, 0x0014, 0x001F,
    0x0002, 0xFFED, 0xFFEE, 0xFFFD, 0x0008, 0x0014, 0xFFF7, 0x0019,
    0x001C, 0x0007, 0xFFFF, 0xFFF0, 0xFFFF, 0xFFEA, 0xFFE0, 0xFFFA,
    0xFFFF, 0x0004, 0xFFFD, 0x000A, 0x001F, 0x0009, 0x000F, 0xFFEE,
    0x001D, 0xFFFE, 0x0005, 0x0003, 0xFFF6, 0x0015, 0xFFF3, 0xFFF4,
    0x001D, 0xFFFF, 0x0008, 0x001E, 0x000B, 0x0006, 0x0001, 0x0005,
    0x0016, 0xFFFC, 0xFFF1, 0xFFE8, 0x0017, 0x000B, 0x0016, 0x000D,
    0xFFFF, 0x0022, 0x0003, 0x0000, 0x0004, 0xFFFD, 0xFFF3, 0x0016,
    0xFFE4, 0x000F, 0xFFEB, 0xFFDE, 0x0012, 0x0023, 0xFFEB, 0xFFF5,
    0xFFE7, 0xFFED, 0xFFFB, 0xFFE9, 0x001C, 0xFFEC, 0xFFED, 0xFFD5,
    0x0006, 0x000A, 0xFFFA, 0xFFE5, 0xFFFA, 0xFFFA, 0xFFFF, 0x0003,
    0xFFFF, 0xFFF7, 0xFFFD, 0xFFEC, 0x0006, 0x0003, 0x0009, 0xFFFD,
    0x0026, 0xFFEC, 0xFFE0, 0xFFE4, 0xFFE5, 0x0023, 0xFFFB, 0x0015,
    0xFFD7, 0x000A, 0x0007, 0x0018, 0xFFFC, 0x0013, 0xFFEE, 0x0011,
    0xFFF7, 0xFFF4, 0x001C, 0x000C, 0x0013, 0x001A, 0xFFF3, 0x0003,
    0x000D, 0x0010, 0x0005, 0xFFEE, 0x0017, 0xFFFE, 0xFFF9, 0x0003,
    0x0011, 0x0001, 0x000E, 0x0009, 0x000F, 0x0009, 0xFFF8, 0xFFEF,
    0x0007, 0xFFEC, 0x0005, 0xFFEE, 0xFFD3, 0x000B, 0xFFFC, 0x0006,
    0xFFFB, 0x000B, 0x0018, 0xFFF0, 0xFFF2, 0x0014, 0xFFD8, 0x0004,
    0x000D, 0x002E, 0xFFEA, 0xFFE2, 0xFFF5, 0xFFF6, 0x0011, 0x000E,
    0xFFE8, 0x0000, 0xFFE8, 0x0012, 0x0018, 0xFFF8, 0x0010, 0x0003,
    0xFFFF, 0xFFFB, 0x000F, 0x000C, 0x000D, 0x000E, 0xFFF4, 0x000E,
    0xFFFF, 0x0003, 0xFFF7, 0x0015, 0xFFFE, 0xFFF8, 0xFFEB, 0xFFF7,
    0x0010, 0x000C, 0xFFF8, 0xFFFF, 0x0004, 0xFFE8, 0x0016, 0xFFF0,
    0xFFEB, 0x0010, 0xFFF9, 0x000F, 0x0001, 0x0006, 0x0003, 0xFFC8,
    0x0000, 0x0015, 0x0006, 0xFFF7, 0x0002, 0xFFEA, 0x0008, 0x000A,
    0xFFFA, 0xFFFD, 0x0009, 0x000C, 0xFFE1, 0x0001, 0xFFF7, 0x0001,
    0xFFDC, 0x000E, 0x001A, 0xFFF7, 0x0010, 0x000C, 0xFFDD, 0x0007,
    0x0009, 0x0005, 0xFFF8, 0x0011, 0x000E, 0x0007, 0xFFE6, 0x001C,
    0xFFE2, 0x001B, 0x0001, 0x0011, 0x0013, 0x0022, 0x0008, 0xFFED,
    0x0009, 0x0009, 0xFFFD, 0xFFFA, 0x0006, 0x001E, 0xFFFE, 0x0007,
    0x0000, 0xFFFA, 0x0021, 0x0019, 0x0005, 0xFFE9, 0xFFF2, 0xFFFE,
    0x0000, 0xFFEF, 0x0017, 0x0010, 0x003C, 0x000A, 0xFFDD, 0x0000,
    0x000F, 0x0019, 0xFFF9, 0x0001, 0x0012, 0x0013, 0x0016, 0x0001,
    0xFFDF, 0xFFE0, 0xFFDD, 0x000E, 0x001D, 0x0002, 0x000C, 0xFFF6,
    0x0010, 0xFFEF, 0x0013, 0xFFFE, 0x001C, 0xFFF2, 0x0007, 0xFFF4,
    0x000F, 0x0008, 0x001D, 0xFFF7, 0x0028, 0xFFF2, 0x0017, 0x0002,
    0xFFE4, 0x0006, 0x0008, 0xFFFF, 0xFFE7, 0x0000, 0xFFFE, 0xFFF5,
    0x0006, 0xFFFF, 0x001B, 0x000C, 0x000B, 0xFFFF, 0x000A, 0x000A,
    0xFFF1, 0xFFEA, 0x000E, 0x0012, 0xFFEE, 0x0012, 0xFFEF, 0xFFFE,
    0xFFE7, 0x0006, 0x0004, 0x0004, 0x0005, 0x0015, 0xFFF8, 0xFFFF,
    0xFFE2, 0xFFF7, 0xFFEA, 0xFFF3, 0x001D, 0xFFFB, 0x0011, 0xFFEC,
    0x0004, 0x000D, 0xFFFB, 0xFFEF, 0x001A, 0x0013, 0xFFFF, 0xFFF3,
    0x0008, 0x000B, 0xFFFB, 0x0000, 0x0009, 0xFFFC, 0xFFEE, 0x000A,
    0xFFF0, 0xFFF1, 0x0014, 0x0002, 0x0001, 0xFFD4, 0xFFFE, 0x002E,
    0x0011, 0x0004, 0x000D, 0x001B, 0x001A, 0x0008, 0x0001, 0xFFFF,
    0x0002, 0x0000, 0xFFFE, 0x001B, 0x0011, 0x0017, 0x000F, 0x0004,
    0xFFFE, 0x0009, 0xFFF8, 0xFFE9, 0x0001, 0x0011, 0x000D, 0x0009,
    0xFFFF, 0xFFF9, 0xFFF8, 0x0016, 0xFFDE, 0x000F, 0xFFF2, 0xFFF2,
    0xFFEA, 0xFFF4, 0xFFF8, 0xFFE3, 0xFFFD, 0xFFF5, 0xFFEC, 0xFFE9,
    0x000F, 0xFFFC, 0xFFF4, 0xFFEE, 0xFFE2, 0x0001, 0x0013, 0x0000,
    0x0014, 0xFFF8, 0x0004, 0xFFFB, 0xFFF5, 0xFFEA, 0x0013, 0xFFFF,
    0xFFFF, 0xFFE5, 0x0006, 0x0000, 0x000A, 0xFFF1, 0x0020, 0xFFE5,
    0x000F, 0xFFEF, 0xFFE6, 0xFFF5, 0xFFF8, 0xFFF7, 0x0019, 0xFFEE,
    0x0014, 0xFFF5, 0xFFEA, 0x0004, 0xFFFD, 0x0007, 0xFFF1, 0x0026,
    0xFFFD, 0xFFF8, 0x002B, 0x0006, 0x0016, 0x0024, 0x0014, 0xFFE1,
    0xFFEF, 0x0000, 0xFFE5, 0xFFDF, 0xFFF5, 0x0028, 0x0027, 0x000B,
    0xFFE4, 0x0005, 0xFFDC, 0xFFEF, 0xFFE5, 0xFFFB, 0x000A, 0xFFF8,
    0x0003, 0x001F, 0xFFFB, 0x0004, 0x0002, 0xFFF3, 0x001E, 0x000C,
    0x0003, 0xFFF0, 0xFFFF, 0xFFF7, 0xFFE7, 0x000A, 0x0000, 0xFFFE,
    0xFFEF, 0xFFE8, 0x001A, 0xFFF3, 0x000D, 0x001D, 0xFFF9, 0xFFF2,
    0x000D, 0x0002, 0xFFF4, 0x0022, 0xFFE8, 0x0001, 0xFFF9, 0xFFFD,
    0x0009, 0x0000, 0x0001, 0x000B, 0x0009, 0xFFF8, 0x0005, 0xFFEC,
    0x000A, 0xFFF7, 0xFFF6, 0xFFFB, 0xFFED, 0x0003, 0x001B, 0xFFFA,
    0xFFF2, 0xFFE8, 0xFFEC, 0xFFFC, 0xFFFB, 0x0024, 0xFFEC, 0xFFE3,
    0xFFFE, 0x001B, 0x001A, 0xFFE3, 0xFFEE, 0xFFF6, 0x0010, 0x000E,
    0xFFF9, 0xFFEF, 0x0010, 0x000F, 0x000C, 0x0015, 0xFFEC, 0x000C,
    0xFFEC, 0xFFFD, 0xFFE6, 0x0024, 0xFFF3, 0xFFFD, 0x000B, 0x0002,
    0x0004, 0xFFF5, 0x0014, 0x0006, 0x000B, 0x0020, 0xFFEC, 0xFFFD,
    0x0015, 0xFFEF, 0x0023, 0x000F, 0xFFF7, 0xFFEC, 0x000E, 0x0000,
    0xFFF0, 0x0011, 0xFFF2, 0x0007, 0x0020, 0xFFFE, 0x0002, 0x0020,
    0x0013, 0x0010, 0xFFF8, 0xFFFD, 0x001B, 0x0003, 0x0001, 0xFFDE,
    0x000F, 0xFFF4, 0x0006, 0x0011, 0x000D, 0x000B, 0x000B, 0x0021,
    0x0004, 0xFFF5, 0x0011, 0x0014, 0xFFFE, 0x0018, 0x002D, 0x0007,
    0xFFE5, 0xFFE5, 0xFFFD, 0xFFE7, 0x0005, 0x0012, 0x0014, 0xFFF9,
    0x0000, 0xFFE7, 0xFFF3, 0xFFF9, 0xFFC5, 0xFFF5, 0x0018, 0xFFEB,
    0x0020, 0xFFFA, 0x0003, 0x0004, 0xFFF1, 0x000A, 0xFFFD, 0xFFDB,
    0x0017, 0xFFF4, 0xFFF6, 0x0007, 0x0011, 0x0003, 0xFFF6, 0xFFFE,
    0x0009, 0x0012, 0x0022, 0x0011, 0xFFEE, 0x0010, 0x0014, 0xFFE6,
    0x000A, 0xFFED, 0x0008, 0xFFF9, 0x0019, 0x0028, 0x0005, 0xFFFF,
    0x0009, 0x000D, 0xFFF7, 0x000A, 0xFFE5, 0x0007, 0xFFF3, 0x0002,
    0xFFFA, 0x0015, 0x000C, 0xFFF7, 0x0004, 0xFFF2, 0x000B, 0xFFE4,
    0xFFF7, 0xFFFB, 0x0003, 0xFFF7, 0xFFE5, 0xFFE6, 0x000C, 0xFFED,
    0x000A, 0xFFE5, 0x000E, 0xFFFE, 0xFFFC, 0x0003, 0x0024, 0x0013,
    0xFFE5, 0xFFE8, 0x0010, 0xFFF9, 0xFFFE, 0x0020, 0xFFF5, 0xFFFC,
    0x001B, 0x000A, 0x0004, 0xFFFB, 0x001A, 0xFFF5, 0x001B, 0xFFEF,
    0xFFE1, 0x000C, 0xFFF5, 0xFFD9, 0xFFF5, 0x0015, 0xFFFF, 0x0013,
    0x0003, 0x0003, 0x0011, 0xFFEB, 0x0012, 0x000E, 0x0028, 0xFFF4,
    0xFFFD, 0xFFDE, 0x0006, 0xFFF7, 0x0001, 0xFFF7, 0xFFF1, 0xFFFF,
    0x0014, 0xFFF1, 0x000E, 0x0008, 0x0004, 0x001A, 0xFFFB, 0x0007,
    0x0011, 0xFFF9, 0x001D, 0xFFFF, 0x0004, 0xFFFF, 0x0001, 0x0020,
    0x0000, 0xFFF2, 0xFFFE, 0x0008, 0xFFDA, 0x0016, 0x000A, 0xFFE9,
    0x0016, 0xFFFF, 0x0012, 0x0003, 0x0011, 0x0000, 0x000C, 0xFFFC,
    0x0015, 0xFFEE, 0x0000, 0xFFF8, 0x001A, 0x0028, 0xFFFE, 0x001B,
    0x000A, 0x0000, 0xFFE0, 0x0014, 0x0018, 0x0000, 0xFFFD, 0xFFFB,
    0x0011, 0xFFF1, 0x0000, 0xFFE9, 0xFFED, 0xFFEA, 0xFFF5, 0xFFF8,
    0x0002, 0xFFE7, 0x000A, 0xFFEE, 0xFFF7, 0xFFF6, 0xFFF4, 0xFFDD,
    0x0023, 0xFFFA, 0x0020, 0x0020, 0xFFEC, 0xFFF0, 0xFFFB, 0xFFFC,
    0x000D, 0x000D, 0x0012, 0xFFF4, 0xFFF3, 0x000B, 0xFFFD, 0x0022,
    0x000F, 0x000A, 0xFFE7, 0xFFF4, 0x000E, 0xFFF0, 0x0018, 0x0023,
    0xFFEF, 0xFFEE, 0xFFF6, 0xFFFD, 0xFFEF, 0x0014, 0x0026, 0xFFFB,
    0x000A, 0x0004, 0xFFFC, 0x0012, 0x0008, 0x003F, 0xFFF6, 0x000C,
    0x0008, 0xFFF4, 0xFFEF, 0xFFFB, 0xFFF2, 0xFFFA, 0x001B, 0x0001,
    0xFFF6, 0x0017, 0x0003, 0x0024, 0xFFE7, 0x001B, 0xFFEF, 0x0007,
    0x001C, 0xFFF9, 0xFFFC, 0xFFD1, 0xFFEB, 0xFFFC, 0xFFE2, 0x0011,
    0xFFEB, 0x0003, 0xFFE2, 0xFFFE, 0xFFF9, 0xFFE8, 0xFFFA, 0x0019,
    0x000E, 0xFFFA, 0xFFF4, 0x000E, 0xFFF1, 0xFFFF, 0x0002, 0xFFE5,
    0x0005, 0x000F, 0xFFF0, 0xFFFD, 0x000C, 0xFFF5, 0xFFEF, 0x0002,
    0xFFF2, 0xFFF8, 0x0001, 0x0026, 0xFFEA, 0xFFF7, 0xFFEE, 0xFFFF,
    0x001B, 0x0004, 0xFFE0, 0x0000, 0xFFF1, 0x0006, 0xFFEC, 0xFFF6,
    0x0019, 0xFFFC, 0x0008, 0xFFF2, 0x0025, 0xFFF0, 0x000B, 0x0018,
    0x0025, 0xFFF2, 0xFFE3, 0x0019, 0x000E, 0xFFF9, 0x000A, 0x000F,
    0x0006, 0x001A, 0x0010, 0xFFF3, 0xFFEE, 0x0015, 0x0009, 0xFFF5,
    0x0008, 0x0001, 0xFFFF, 0xFFFC, 0xFFFE, 0x000A, 0x001C, 0xFFF7,
    0xFFEF, 0x0013, 0xFFDC, 0xFFF7, 0x0030, 0xFFFE, 0xFFE4, 0x002D,
    0xFFDA, 0xFFFA, 0xFFE0, 0xFFFC, 0xFFEF, 0xFFFC, 0x000E, 0x0002,
    0xFFF6, 0xFFE7, 0x000C, 0x001B, 0xFFF0, 0x0002, 0x0007, 0xFFF4,
    0x0005, 0xFFDE, 0x0018, 0xFFF7, 0xFFEE, 0xFFF9, 0xFFE9, 0xFFF1,
    0xFFE8, 0x0002, 0x0011, 0xFFF8, 0x000B, 0x000D, 0xFFEC, 0xFFF9,
    0xFFF3, 0xFFFD, 0x0014, 0x0015, 0x0001, 0xFFCA, 0xFFFD, 0x0016,
    0x000A, 0x0018, 0x0018, 0xFFE8, 0xFFE5, 0x0009, 0x0010, 0x001E,
    0x000B, 0x002D, 0x0000, 0x0029, 0xFFEF, 0x0007, 0x0024, 0xFFF5,
    0x000F, 0x0004, 0x0000, 0x0001, 0x000C, 0x0021, 0xFFF2, 0xFFE5,
    0xFFF7, 0x0010, 0x0001, 0x0007, 0x001D, 0x000A, 0xFFFF, 0xFFE7,
    0x0008, 0xFFF8, 0x0016, 0xFFF5, 0x0001, 0x001B, 0x0000, 0x000F,
    0x0005, 0xFFF9, 0xFFFA, 0xFFEF, 0xFFF7, 0x0014, 0xFFF8, 0xFFCA,
    0x0009, 0x0017, 0xFFF3, 0x0003, 0xFFF5, 0x0002, 0x000E, 0xFFF2,
    0x0010, 0x000C, 0x0007, 0x0002, 0xFFF2, 0x0003, 0xFFF0, 0xFFF5,
    0xFFFF, 0xFFF8, 0xFFF3, 0xFFFD, 0x0006, 0x0010, 0xFFF1, 0x000C,
    0x001C, 0xFFEF, 0xFFF4, 0xFFEF, 0x0009, 0x0008, 0x000C, 0xFFFF,
    0x0005, 0xFFF7, 0x001D, 0xFFF0, 0xFFF0, 0x0014, 0x0022, 0x0025,
    0xFFF0, 0xFFF2, 0xFFED, 0xFFFE, 0xFFFD, 0x0000, 0x0001, 0xFFF7,
    0xFFEC, 0x0005, 0x0009, 0xFFF3, 0x0001, 0xFFF9, 0xFFF6, 0xFFDE,
    0x0005, 0x000C, 0x0001, 0x0018, 0xFFEF, 0x0017, 0xFFFE, 0x0003,
    0xFFFC, 0xFFF6, 0xFFFF, 0x000D, 0x002F, 0xFFFA, 0x0027, 0x001F,
    0x0007, 0xFFF4, 0x0011, 0xFFF7, 0xFFEF, 0x0016, 0x0003, 0xFFF7,
    0x0011, 0x0011, 0x0007, 0xFFC6, 0x001E, 0xFFF8, 0xFFFB, 0x0007,
    0xFFF2, 0x000F, 0x0007, 0xFFFB, 0x0015, 0xFFF6, 0xFFF9, 0xFFE9,
    0xFFF0, 0x0010, 0xFFF3, 0xFFFB, 0x0015, 0xFFE6, 0xFFFC, 0xFFF3,
    0x0009, 0xFFE8, 0x0009, 0xFFD7, 0x0004, 0xFFD4, 0xFFFD, 0xFFFD,
    0x0009, 0x0004, 0x0005, 0xFFEE, 0x000B, 0x0010, 0x0026, 0xFFF1,
    0xFFDC, 0xFFFF, 0x0006, 0xFFED, 0x000F, 0xFFFB, 0xFFF6, 0x000D,
    0xFFFC, 0xFFFE, 0x000C, 0x000A, 0x000A, 0x002B, 0x0002, 0xFFEA,
    0x0006, 0xFFFC, 0x0002, 0x0005, 0x0003, 0x0001, 0xFFFF, 0xFFFF,
    0x0004, 0xFFF2, 0x0008, 0x002B, 0xFFD8, 0xFFF5, 0xFFF3, 0xFFF3,
    0x0007, 0x0020, 0x0014, 0xFFEF, 0xFFF2, 0xFFFC, 0x002C, 0xFFFB,
    0xFFD9, 0xFFF6, 0x000C, 0xFFE9, 0x0023, 0xFFF4, 0xFFFE, 0xFFFA,
    0xFFE1, 0x0014, 0xFFF4, 0x002A, 0x0012, 0x0007, 0xFFF2, 0x0004,
    0x0000, 0xFFE5, 0x002C, 0xFFF5, 0x0018, 0x0019, 0xFFE5, 0x0015,
    0xFFEF, 0x000B, 0x0012, 0x0014, 0xFFEF, 0x001D, 0xFFFF, 0xFFF6,
    0xFFFE, 0xFFF3, 0xFFFD, 0xFFEF, 0xFFFF, 0xFFFC, 0x0004, 0xFFE6,
    0x000E, 0xFFF9, 0x0000, 0xFFFC, 0x000F, 0xFFDD, 0x0010, 0x0014,
    0x0015, 0xFFEC, 0xFFF8, 0x0007, 0xFFF6, 0xFFF1, 0xFFF5, 0xFFE6,
    0xFFDE, 0xFFE0, 0xFFEA, 0xFFFC, 0x0004, 0x0000, 0xFFE7, 0xFFE2,
    0x0011, 0xFFEB, 0xFFE6, 0x0027, 0x0028, 0x0003, 0xFFF6, 0x0007,
    0x0016, 0xFFF6, 0x0006, 0x000C, 0xFFF4, 0x001D, 0x0005, 0xFFDE,
    0xFFE8, 0x0024, 0xFFFA, 0xFFF9, 0xFFFB, 0xFFF3, 0xFFEA, 0xFFF9,
    0x001B, 0xFFE2, 0xFFE2, 0x0004, 0x0013, 0x0017, 0xFFEF, 0x0010,
    0xFFFB, 0x000F, 0xFFDD, 0xFFFB, 0x0000, 0xFFF2, 0x001B, 0xFFFB,
    0x0016, 0x0012, 0x0010, 0x0015, 0x0012, 0x0000, 0x001F, 0xFFF7,
    0x0000, 0x0011, 0xFFF2, 0xFFEB, 0xFFF6, 0xFFF6, 0xFFFB, 0xFFFC,
    0xFFDF, 0x000A, 0x0003, 0x0018, 0xFFE9, 0x000C, 0x000A, 0xFFE7,
    0xFFF7, 0xFFF4, 0x000C, 0x0007, 0xFFEF, 0x0015, 0x0012, 0x000E,
    0xFFF9, 0xFFEF, 0xFFF3, 0x0014, 0xFFF9, 0xFFF6, 0xFFED, 0x0006,
    0xFFEE, 0xFFF9, 0xFFFF, 0x0003, 0xFFF7, 0xFFF4, 0xFFE6, 0x0007,
    0x0006, 0xFFF4, 0x0005, 0x0014, 0xFFED, 0xFFF8, 0xFFE6, 0xFFF5,
    0x000A, 0xFFF1, 0xFFEC, 0x0001, 0xFFFA, 0x0005, 0xFFF6, 0xFFF3,
    0x0010, 0xFFF1, 0x0002, 0xFFF5, 0xFFF3, 0x000F, 0xFFED, 0x0009,
    0xFFE8, 0xFFFD, 0xFFE9, 0x0003, 0xFFF4, 0xFFE1, 0xFFDE, 0x0011,
    0xFFEC, 0x0003, 0x0014, 0x0014, 0x0003, 0x0015, 0xFFFD, 0xFFFE,
    0xFFDF, 0xFFDD, 0x0011, 0x000F, 0x0007, 0x0012, 0xFFE8, 0x0006,
    0xFFF5, 0xFFFB, 0x0000, 0xFFEC, 0xFFF5, 0xFFE5, 0xFFFF, 0x0005,
    0x0004, 0x001F, 0x0011, 0x0022, 0x0010, 0x0001, 0xFFFC, 0xFFFE,
    0xFFEA, 0x000A, 0xFFE6, 0x0011, 0xFFF2, 0xFFEE, 0x0000, 0xFFEC,
    0x0006, 0x002D, 0xFFF4, 0xFFF0, 0xFFFD, 0xFFE1, 0x0003, 0xFFFD,
    0x000D, 0xFFF5, 0xFFEA, 0x0006, 0x0000, 0x0029, 0x0000, 0x0008,
    0xFFF4, 0xFFF2, 0xFFFE, 0x000E, 0xFFED, 0xFFE9, 0xFFF3, 0xFFF1,
    0x0006, 0xFFE9, 0x0001, 0xFFFF, 0x0004, 0x0009, 0xFFFF, 0x0009,
    0x0009, 0x0025, 0xFFF9, 0xFFF3, 0x000A, 0xFFF1, 0x000D, 0x0014,
    0x0017, 0xFFFE, 0x0008, 0x000D, 0x001F, 0xFFF5, 0x0005, 0x000B,
    0x0001, 0x0003, 0xFFFC, 0x0009, 0x0003, 0xFFE4, 0xFFEB, 0x000C,
    0x0024, 0x0002, 0x0005, 0x000D, 0x0019, 0x0012, 0x0018, 0xFFE2,
    0x0018, 0x001D, 0xFFF9, 0xFFFD, 0x0009, 0x0012, 0xFFE4, 0xFFFC,
    0xFFFE, 0xFFF7, 0xFFEB, 0xFFFA, 0xFFFA, 0xFFED, 0x0000, 0xFFF4,
    0xFFFE, 0x0000, 0x0000, 0x000C, 0xFFFA, 0x0013, 0xFFEB, 0x0006,
    0xFFFE, 0x0009, 0xFFE4, 0x0004, 0x0009, 0xFFEE, 0xFFF9, 0x0003,
    0x0018, 0xFFE3, 0x0018, 0x001E, 0x0019, 0xFFEE, 0x0005, 0xFFF3,
    0x0024, 0xFFFE, 0xFFEB, 0xFFF4, 0x0003, 0x001C, 0xFFFC, 0xFFF7,
    0x0001, 0xFFFD, 0x0005, 0xFFF5, 0x001F, 0x000B, 0x0008, 0xFFF3,
    0x0017, 0x0002, 0x000D, 0xFFEC, 0x000A, 0x000F, 0xFFF9, 0x000D,
    0x0009, 0xFFDB, 0xFFFF, 0xFFF7, 0x0004, 0xFFF7, 0x0001, 0x0001,
    0x0006, 0x0017, 0xFFF3, 0x000F, 0xFFED, 0x0017, 0xFFFE, 0xFFF2,
    0xFFF4, 0x000E, 0x0000, 0xFFF8, 0x0000, 0xFFD7, 0xFFEA, 0xFFFA,
    0x000D, 0x000B, 0x0003, 0x0003, 0xFFFD, 0x001F, 0xFFF4, 0x0010,
    0x0006, 0xFFD3, 0x0000, 0x0014, 0xFFF2, 0x0012, 0xFFE6, 0xFFEF,
    0xFFEA, 0xFFF6, 0xFFFC, 0x0002, 0x0010, 0xFFFF, 0x0011, 0xFFDE,
    0x0004, 0xFFE1, 0xFFFF, 0xFFFB, 0xFFF5, 0x001B, 0x0000, 0x0014,
    0xFFF5, 0x0005, 0xFFE8, 0xFFFA, 0x0007, 0xFFEE, 0x0011, 0xFFF1,
    0xFFDF, 0x0023, 0xFFFD, 0x0002, 0x0003, 0xFFEB, 0x0014, 0xFFEC,
    0xFFEC, 0xFFFD, 0xFFDE, 0xFFEF, 0xFFF4, 0x001F, 0xFFE9, 0xFFFD,
    0xFFE8, 0x0003, 0xFFED, 0xFFF7, 0xFFF3, 0xFFF1, 0x0002, 0x000B,
    0x0010, 0x000F, 0xFFF6, 0x000D, 0xFFFA, 0xFFFB, 0xFFEC, 0xFFFF,
    0x000A, 0x000F, 0xFFE6, 0x000B, 0xFFED, 0x0008, 0x0005, 0xFFEC,
    0x0006, 0x000C, 0xFFE6, 0xFFF9, 0xFFF7, 0x000C, 0xFFFF, 0xFFFD,
    0xFFEE, 0x0007, 0xFFED, 0xFFFA, 0xFFF9, 0x000A, 0xFFF3, 0xFFEC,
    0xFFF9, 0x0011, 0x0012, 0xFFF2, 0xFFEF, 0xFFEB, 0x000C, 0xFFF9,
    0xFFF7, 0x000C, 0x000A, 0x0019, 0xFFE9, 0xFFF4, 0x0003, 0xFFE8,
    0xFFDF, 0xFFF6, 0xFFFB, 0x0004, 0xFFF6, 0x000A, 0xFFF2, 0x0015,
    0x0000, 0xFFEF, 0x001F, 0x0009, 0x0012, 0x0000, 0x0010, 0xFFEB,
    0x0016, 0xFFEE, 0x001B, 0x0005, 0x0000, 0x000E, 0xFFDD, 0x0005,
    0xFFFB, 0xFFF1, 0xFFEF, 0xFFF0, 0x0013, 0xFFE9, 0xFFE2, 0xFFFC,
    0x001B, 0x001E, 0xFFEA, 0x0007, 0xFFFB, 0x000D, 0xFFFA, 0x0007,
    0xFFE8, 0xFFDC, 0x0005, 0x0022, 0xFFF4, 0xFFE3, 0x0006, 0xFFF4,
    0x0016, 0x000A, 0xFFF6, 0xFFF9, 0x0028, 0xFFFD, 0xFFE6, 0xFFD9,
    0x0011, 0x0015, 0xFFE7, 0x001E, 0x0004, 0x0000, 0xFFEA, 0x0004,
    0xFFDE, 0x0020, 0xFFF5, 0x001A, 0xFFF6, 0x000F, 0xFFF8, 0xFFF9,
    0x0015, 0x0014, 0x0010, 0xFFEC, 0x000F, 0x0023, 0x0000, 0x0004,
    0x000E, 0x0007, 0x0004, 0x001A, 0xFFFF, 0x0004, 0xFFFD, 0x0011,
    0xFFFE, 0x000D, 0xFFFF, 0x000A, 0xFFEF, 0xFFE3, 0x0012, 0xFFEC,
    0xFFEF, 0xFFF5, 0xFFE5, 0xFFEB, 0x0018, 0xFFE7, 0x002C, 0x000B,
    0x0000, 0x001B, 0xFFF2, 0xFFFC, 0x0012, 0xFFF9, 0xFFF4, 0xFFD6,
    0xFFE1, 0xFFEC, 0xFFFE, 0x0006, 0x0023, 0x000C, 0x000C, 0x0017,
    0xFFD9, 0x000A, 0x002C, 0x0005, 0xFFF2, 0x0004, 0x0014, 0x0011,
    0x0007, 0xFFE0, 0xFFF3, 0x000D, 0xFFD8, 0x000B, 0x0008, 0xFFD5,
    0x0004, 0x000E, 0xFFFF, 0x0001, 0x0003, 0xFFFF, 0x0002, 0xFFFB,
    0x0006, 0x0004, 0x0002, 0x0016, 0x000A, 0xFFD5, 0x000C, 0xFFF6,
    0xFFFC, 0x0002, 0xFFF6, 0xFFF3, 0x000F, 0x0005, 0x0006, 0x0013,
    0xFFDC, 0x0001, 0x0026, 0x000F, 0x000B, 0xFFF0, 0x0005, 0x0012,
    0x0009, 0xFFFC, 0xFFFD, 0x0003, 0x0004, 0x002C, 0x0009, 0x0029,
    0x0009, 0x0018, 0xFFFC, 0x000D, 0x0015, 0x001A, 0xFFF3, 0x0005,
    0xFFF0, 0xFFF0, 0xFFF9, 0x0017, 0x0015, 0x000A, 0x0007, 0x0005,
    0xFFF2, 0xFFF1, 0xFFFB, 0xFFF9, 0x001E, 0x0008, 0x0007, 0x003A,
    0x0011, 0xFFEF, 0x0003, 0x0009, 0xFFEF, 0xFFEA, 0x0011, 0x0009,
    0x0007, 0x000C, 0x0027, 0xFFE1, 0x002F, 0x0006, 0xFFFF, 0xFFF3,
    0xFFFC, 0x000A, 0xFFFE, 0xFFFD, 0xFFEF, 0xFFE9, 0x0001, 0xFFE8,
    0x0005, 0xFFF4, 0xFFF6, 0x0022, 0x0001, 0x0007, 0x0009, 0x000D,
    0xFFEC, 0xFFFB, 0x0001, 0x0009, 0xFFFD, 0x0000, 0xFFED, 0x0002,
    0xFFF0, 0x000E, 0x0022, 0xFFDB, 0xFFF0, 0xFFEC, 0x001D, 0x0010,
    0x0005, 0x0009, 0x000C, 0x0001, 0x0009, 0xFFF8, 0xFFF4, 0x0011,
    0x001C, 0x0011, 0xFFF1, 0xFFF4, 0x0006, 0xFFF0, 0xFFF3, 0x0003,
    0xFFFF, 0x0008, 0xFFF0, 0x000B, 0xFFF2, 0xFFFD, 0x0007, 0xFFFE,
    0x0010, 0xFFF4, 0x000E, 0x000E, 0xFFF5, 0xFFFE, 0xFFF3, 0xFFFD,
    0x0009, 0xFFE9, 0xFFF8, 0x0036, 0xFFF7, 0xFFEC, 0xFFFA, 0x0011,
    0x0005, 0x0007, 0x0000, 0xFFF1, 0x0001, 0xFFE5, 0x0016, 0x000B,
    0x0008, 0x0008, 0xFFFF, 0x0019, 0x001D, 0xFFF6, 0x0001, 0xFFF9,
    0xFFF7, 0xFFF0, 0xFFF2, 0x001B, 0x000C, 0xFFDF, 0x0000, 0xFFFF,
    0x000F, 0xFFFC, 0x0024, 0x000B, 0xFFEF, 0xFFF9, 0x0000, 0xFFD7,
    0x000B, 0xFFD3, 0x0010, 0xFFE2, 0xFFE5, 0xFFF7, 0x0018, 0x0018,
    0x000A, 0xFFE8, 0xFFFD, 0xFFEA, 0x0001, 0x0036, 0x0014, 0xFFEB,
    0xFFF3, 0x0003, 0xFFEC, 0x0007, 0x000B, 0xFFF3, 0x0011, 0x0008,
    0xFFE8, 0xFFFE, 0xFFE9, 0x000F, 0xFFEE, 0x0007, 0x0018, 0x0009,
    0x0005, 0x0022, 0x0007, 0x000C, 0xFFF0, 0xFFFE, 0x000C, 0xFFE5,
    0xFFF6, 0x0019, 0x000E, 0xFFFE, 0xFFEF, 0x0004, 0xFFE0, 0x0004,
    0xFFDA, 0x0006, 0xFFE4, 0xFFD3, 0x0030, 0x0002, 0xFFDC, 0x0009,
    0xFFEF, 0xFFED, 0x001C, 0x0009, 0xFFFE, 0xFFF6, 0xFFFF, 0x0004,
    0x0008, 0xFFFF, 0x0009, 0x000B, 0xFFEE, 0xFFEB, 0x0010, 0x000D,
    0x0006, 0xFFE6, 0x000A, 0xFFF1, 0x000E, 0x0007, 0xFFE3, 0xFFE7,
    0x0025, 0x000E, 0x000B, 0xFFE8, 0x0025, 0x0010, 0x0008, 0x000E,
    0x0019, 0x0004, 0xFFEC, 0x000A, 0xFFF1, 0xFFFA, 0xFFE0, 0x0000,
    0x001B, 0xFFFC, 0xFFEE, 0x0001, 0xFFEA, 0x0009, 0x0001, 0xFFDA,
    0xFFF2, 0x0008, 0xFFEF, 0xFFFE, 0x000C, 0x000B, 0xFFF0, 0x0003,
    0x0005, 0xFFF1, 0x0002, 0x001B, 0xFFF1, 0x0001, 0xFFF4, 0xFFF2,
    0x000E, 0x0006, 0xFFFA, 0xFFE7, 0xFFF9, 0x0018, 0xFFE2, 0x0002,
    0xFFEB, 0xFFFD, 0xFFE2, 0xFFEF, 0xFFEB, 0x0004, 0xFFFC, 0x002F,
    0x001C, 0x0007, 0xFFEF, 0xFFF9, 0xFFE7, 0xFFE5, 0x0003, 0xFFDC,
    0xFFF6, 0xFFE9, 0x001B, 0xFFFF, 0xFFF2, 0x0006, 0xFFEF, 0x0005,
    0x0008, 0x000C, 0xFFF6, 0xFFF4, 0x0008, 0xFFC1, 0xFFFC, 0xFFEE,
    0x000A, 0xFFFC, 0x0026, 0x0005, 0xFFEF, 0xFFEC, 0xFFF6, 0x0003,
    0xFFEF, 0x0012, 0x0018, 0xFFDD, 0x000E, 0x0010, 0xFFE7, 0x000C,
    0x000F, 0xFFF6, 0xFFFD, 0xFFDE, 0xFFF3, 0xFFF5, 0x0012, 0x000C,
    0x000D, 0xFFF3, 0xFFFB, 0x0004, 0xFFEC, 0x0010, 0x0020, 0xFFE0,
    0x0023, 0x0006, 0xFFF4, 0x0023, 0xFFF7, 0x000A, 0x000A, 0x0012,
    0x0002, 0x0019, 0xFFF5, 0x0008, 0xFFED, 0x0016, 0x0000, 0x0017,
    0x0011, 0x000F, 0xFFFD, 0x0005, 0x0018, 0x0000, 0xFFE0, 0xFFEC,
    0x000A, 0x0000, 0xFFFE, 0xFFE5, 0x001A, 0xFFD8, 0x0000, 0x0008,
    0x0015, 0x0012, 0x000C, 0x0004, 0x0011, 0x0000, 0x0012, 0xFFFD,
    0x0016, 0x0001, 0x000A, 0x0017, 0xFFDA, 0xFFEA, 0xFFFE, 0xFFF8,
    0x0000, 0x000E, 0x0001, 0xFFE0, 0x0004, 0x0001, 0x001D, 0x0001,
    0x0011, 0x0007, 0xFFFB, 0xFFF9, 0x0004, 0xFFE6, 0x000E, 0xFFF8,
    0x0014, 0x000F, 0xFFF1, 0x0001, 0x0001, 0x0009, 0x0006, 0x0009,
    0xFFFD, 0x0022, 0x0028, 0x000C, 0x0012, 0xFFF2, 0x0011, 0x0015,
    0x0003, 0xFFFD, 0xFFFF, 0xFFED, 0xFFF5, 0xFFEB, 0xFFF5, 0x0027,
    0xFFE1, 0xFFF4, 0x001B, 0x0011, 0x001A, 0x000B, 0x0004, 0x0005,
    0x001B, 0xFFF6, 0xFFF5, 0x0004, 0xFFFE, 0xFFE0, 0x0010, 0x0007,
    0xFFE5, 0x0018, 0x0024, 0xFFED, 0xFFFC, 0xFFFD, 0x000E, 0x0002,
    0x000A, 0x001B, 0x000C, 0x0013, 0xFFE5, 0x001A, 0x0003, 0x0009,
    0xFFF7, 0x0005, 0x000B, 0x001C, 0x0004, 0x000E, 0x000C, 0x0009,
    0xFFFA, 0xFFEB, 0xFFF3, 0xFFFE, 0xFFE5, 0xFFF9, 0xFFF7, 0xFFF6,
    0x0009, 0xFFF3, 0x0005, 0x0001, 0x0019, 0xFFD8, 0x0008, 0x0007,
    0x000A, 0x0013, 0x0014, 0x001A, 0xFFEE, 0xFFF0, 0x0022, 0xFFEF,
    0x0009, 0xFFEE, 0xFFF6, 0x0002, 0x0011, 0xFFFD, 0xFFF6, 0xFFF9,
    0x0017, 0x000C, 0xFFFD, 0x0025, 0xFFF1, 0xFFF6, 0x0003, 0xFFFC,
    0x0020, 0x0006, 0x0018, 0x0015, 0xFFC5, 0x000B, 0xFFF3, 0x0007,
    0x0000, 0x0019, 0x0014, 0x0007, 0x0005, 0xFFEE, 0xFFFD, 0x0019,
    0xFFE5, 0x001B, 0x002D, 0xFFF9, 0xFFFE, 0xFFE8, 0x0011, 0xFFEC,
    0x0004, 0x000B, 0x000B, 0xFFDF, 0x000D, 0xFFF5, 0x0006, 0xFFEF,
    0x000F, 0x000C, 0x0001, 0x0022, 0x001B, 0xFFFD, 0xFFF8, 0x0003,
    0x0013, 0xFFF0, 0x0002, 0xFFE0, 0x0020, 0x0002, 0xFFF2, 0xFFF9,
    0xFFF0, 0xFFEF, 0x000E, 0x0000, 0xFFF7, 0x0014, 0x0023, 0xFFF1,
    0x0015, 0x0011, 0xFFEC, 0x0003, 0x000B, 0xFFE0, 0x0014, 0xFFFA,
    0x0004, 0x000B, 0x000B, 0xFFFE, 0xFFF3, 0x0003, 0xFFE6, 0xFFDC,
    0xFFEC, 0x0003, 0xFFEC, 0xFFF4, 0x000C, 0xFFEB, 0x0010, 0xFFF1,
    0xFFF9, 0x0011, 0x0010, 0xFFF2, 0xFFEE, 0x000A, 0x001A, 0x001D,
    0xFFFE, 0xFFE5, 0xFFEC, 0x001D, 0xFFFB, 0xFFDC, 0xFFEC, 0x0004,
    0xFFF2, 0x0018, 0x001B, 0x0006, 0xFFED, 0xFFFD, 0xFFF6, 0x0005,
    0x000A, 0x0009, 0x0005, 0x0014, 0x0009, 0x0008, 0x0001, 0xFFF5,
    0x0009, 0x0000, 0xFFF9, 0x0003, 0xFFE8, 0xFFFF, 0xFFF4, 0xFFDE,
    0x000D, 0xFFFE, 0xFFF9, 0x000E, 0x000D, 0xFFE3, 0x001A, 0x000D,
    0xFFEF, 0x0018, 0x0000, 0x0002, 0xFFE7, 0xFFF6, 0xFFFF, 0x0009,
    0x0003, 0x0010, 0x001E, 0xFFF4, 0x0002, 0x000D, 0xFFFB, 0xFFFC,
    0x0003, 0xFFE1, 0x000A, 0x0008, 0xFFE5, 0x0005, 0xFFDC, 0x0011,
    0xFFE4, 0xFFFB, 0x0027, 0xFFF5, 0xFFF5, 0xFFD8, 0xFFE5, 0x0021,
    0xFFEF, 0x0000, 0x0014, 0x001F, 0x0016, 0xFFDC, 0x002B, 0xFFFA,
    0xFFFD, 0x0008, 0xFFF1, 0xFFDA, 0xFFFD, 0xFFF9, 0xFFEA, 0xFFFC,
    0x0014, 0x000B, 0x0019, 0x0012, 0xFFF8, 0x0009, 0xFFE6, 0x000B,
    0x000F, 0x0011, 0x0020, 0x001B, 0x000A, 0x000F, 0x0006, 0x0000,
    0xFFFF, 0x001B, 0x0013, 0x0001, 0xFFF5, 0x0016, 0x0004, 0x0005,
    0x0014, 0x0008, 0x0013, 0x0000, 0xFFE2, 0xFFFF, 0xFFF4, 0x0012,
    0x000F, 0x0004, 0xFFEC, 0x0017, 0xFFFD, 0x000B, 0xFFF8, 0x001D,
    0xFFEA, 0x000C, 0xFFF2, 0x000E, 0xFFDE, 0xFFF1, 0xFFF8, 0xFFEA,
    0xFFFF, 0x0007, 0x000D, 0xFFF7, 0x0001, 0xFFEF, 0xFFF8, 0x0017,
    0xFFFE, 0xFFF7, 0x000F, 0xFFFC, 0x0011, 0xFFE9, 0xFFFE, 0xFFE5,
    0x0002, 0x0000, 0x0001, 0x0001, 0x001A, 0xFFF8, 0x000D, 0xFFE5,
    0x0011, 0xFFFC, 0xFFFE, 0xFFD2, 0x0001, 0x002C, 0x0014, 0xFFFE,
    0xFFF0, 0x000F, 0xFFEE, 0xFFF6, 0x0009, 0x0004, 0xFFFB, 0x0000,
    0x0008, 0xFFF5, 0xFFFF, 0x000D, 0x001A, 0xFFED, 0xFFFB, 0x0011,
    0x0004, 0xFFF3, 0x0011, 0x0014, 0x001D, 0x0005, 0xFFEA, 0x000D,
    0xFFE2, 0x0009, 0xFFF8, 0x0001, 0x0005, 0xFFEB, 0x0004, 0xFFFC,
    0xFFE7, 0xFFFA, 0xFFEF, 0x0002, 0xFFEE, 0xFFEE, 0x000E, 0xFFEE,
    0xFFF1, 0x0016, 0x000A, 0xFFF6, 0x000B, 0x0001, 0x001B, 0xFFF4,
    0x0006, 0x0001, 0xFFFE, 0x000B, 0xFFE7, 0x0000, 0x0008, 0x0001,
    0xFFE4, 0xFFFA, 0x0017, 0xFFFE, 0x0028, 0x000E, 0x001D, 0x0009,
    0x000F, 0xFFF8, 0x0007, 0x000C, 0x001C, 0x000E, 0x0013, 0x0002,
    0x0010, 0x0011, 0x000C, 0x000A, 0x001D, 0xFFFE, 0xFFDD, 0xFFF2,
    0xFFDF, 0x0020, 0x0016, 0xFFFF, 0x0012, 0xFFED, 0xFFF9, 0xFFFF,
    0x000F, 0xFFE7, 0xFFDD, 0x0000, 0x003C, 0xFFF6, 0x0017, 0xFFF0,
    0x0000, 0x0011, 0xFFF2, 0x0002, 0x0005, 0x0017, 0x0021, 0xFFE7,
    0x0000, 0x0006, 0xFFFE, 0xFFF9, 0x0006, 0xFFE2, 0xFFFD, 0x0006,
    0x0009, 0xFFF7, 0x0008, 0x0013, 0x0013, 0xFFDE, 0x0001, 0xFFEF,
    0xFFE2, 0xFFE5, 0xFFE6, 0xFFE4, 0x000E, 0xFFF9, 0xFFF8, 0xFFEF,
    0x0009, 0xFFFB, 0xFFDD, 0xFFF9, 0x0010, 0xFFF4, 0x001A, 0x0009,
    0xFFDC, 0xFFF2, 0xFFF7, 0xFFFF, 0xFFE1, 0xFFFF, 0x0009, 0xFFF4,
    0xFFFA, 0x0003, 0x0008, 0xFFF6, 0x0002, 0x0016, 0x0006, 0x0009,
    0x0000, 0xFFEB, 0x0003, 0x0038, 0x0001, 0xFFFA, 0xFFF9, 0xFFF1,
    0xFFEB, 0xFFF0, 0x0016, 0x0010, 0x0004, 0x0018, 0xFFF8, 0x0001,
    0x0010, 0xFFF4, 0xFFEB, 0x0009, 0xFFFE, 0x0008, 0xFFF7, 0xFFEB,
    0xFFFF, 0xFFFD, 0xFFF4, 0xFFF2, 0x000D, 0xFFF2, 0x000F, 0xFFF4,
    0xFFFF, 0x0005, 0x0010, 0xFFFD, 0x0018, 0x0008, 0xFFE8, 0xFFEE,
    0xFFE8, 0x0000, 0x0011, 0xFFF2, 0xFFF5, 0x000A, 0xFFEA, 0x001E,
    0x000D, 0xFFD2, 0xFFD8, 0xFFFC, 0xFFF2, 0xFFEC, 0x0018, 0x0010,
    0xFFFB, 0xFFF5, 0xFFFC, 0xFFFA, 0xFFD3, 0xFFF5, 0x0005, 0x0012,
    0x0007, 0x0014, 0xFFF8, 0x0011, 0x000F, 0xFFF7, 0x000E, 0xFFF7,
    0x0011, 0xFFFF, 0xFFF9, 0xFFFD, 0x0017, 0x0002, 0x0005, 0x0012,
    0x000D, 0xFFF0, 0xFFF3, 0xFFFD, 0x0013, 0xFFE6, 0x001C, 0xFFF4,
    0xFFF7, 0x000C, 0xFFEE, 0xFFEF, 0xFFFC, 0xFFED, 0x0007, 0xFFE8,
    0xFFD7, 0xFFF6, 0xFFFB, 0xFFEB, 0xFFE5, 0xFFDD, 0xFFE0, 0x001C,
    0x0026, 0x0014, 0x0009, 0x0003, 0x0006, 0xFFFD, 0xFFFD, 0x0014,
    0xFFFF, 0x0009, 0xFFFF, 0xFFFD, 0xFFFA, 0x0006, 0xFFFA, 0x001B,
    0x0006, 0xFFF6, 0xFFED, 0x002B, 0x001C, 0x0014, 0xFFFB, 0x0017,
    0xFFE7, 0x0013, 0xFFEB, 0x000B, 0x0012, 0xFFDD, 0xFFEB, 0x0022,
    0xFFE4, 0xFFF1, 0xFFF3, 0xFFEA, 0x0004, 0x0003, 0x0003, 0x0000,
    0xFFFF, 0xFFDE, 0x0016, 0xFFF3, 0x0017, 0xFFF5, 0xFFF1, 0x0018,
    0x0016, 0x0004, 0x0001, 0xFFFB, 0x000B, 0xFFFA, 0x0008, 0xFFE2,
    0x001D, 0x0001, 0xFFF3, 0x000C, 0xFFF6, 0xFFEB, 0x0005, 0xFFFD,
    0x001D, 0x0002, 0x000F, 0x0012, 0x001F, 0xFFF7, 0xFFFD, 0xFFF6,
    0xFFFF, 0xFFFC, 0xFFE0, 0x0006, 0xFFFF, 0x0016, 0xFFFF, 0x0010,
    0x001C, 0xFFF9, 0xFFF7, 0xFFE7, 0x0008, 0xFFEC, 0xFFEE, 0x0003,
    0x0002, 0x0013, 0x0014, 0xFFE1, 0xFFEF, 0xFFF2, 0x000B, 0xFFE9,
    0x0003, 0xFFF8, 0x0024, 0x0024, 0xFFEB, 0xFFE5, 0x000C, 0x001F,
    0x0007, 0xFFF8, 0xFFFB, 0x001A, 0xFFF5, 0x000E, 0xFFF8, 0x0021,
    0xFFEC, 0xFFF9, 0x000C, 0xFFF5, 0xFFEE, 0x000D, 0xFFCC, 0x000F,
    0x0002, 0x001B, 0xFFFB, 0x000A, 0xFFF0, 0x000F, 0x0005, 0x0017,
    0x0019, 0xFFFF, 0xFFFB, 0xFFF6, 0xFFF4, 0xFFD2, 0x0013, 0xFFF0,
    0xFFE9, 0xFFFE, 0xFFE3, 0x0000, 0xFFF7, 0xFFEC, 0xFFDE, 0xFFF5,
    0xFFF4, 0xFFEF, 0xFFFE, 0xFFED, 0x0008, 0x0008, 0xFFFB, 0x000A,
    0xFFF8, 0xFFE6, 0xFFF6, 0xFFFC, 0xFFE0, 0x0005, 0x000B, 0xFFE7,
    0xFFE6, 0xFFF9, 0x0002, 0xFFFC, 0xFFF0, 0x0009, 0xFFED, 0xFFED,
    0xFFFF, 0xFFE3, 0x0009, 0xFFF3, 0xFFFD, 0x0010, 0x0024, 0xFFE8,
    0x0022, 0xFFDA, 0x000D, 0xFFF4, 0x0006, 0xFFFC, 0xFFE9, 0xFFFD,
    0x0001, 0x000A, 0xFFE2, 0xFFF5, 0xFFFD, 0x0015, 0x0011, 0x001C,
    0x0001, 0xFFFB, 0x001E, 0x0005, 0x0015, 0xFFF6, 0x0011, 0xFFFE,
    0x0025, 0xFFFB, 0x0003, 0x0002, 0x000E, 0xFFFF, 0x0012, 0xFFFE,
    0x0004, 0x0002, 0xFFF2, 0xFFFF, 0xFFEF, 0xFFF8, 0xFFF6, 0x0009,
    0xFFFA, 0xFFF0, 0x0005, 0xFFF2, 0x001B, 0xFFFE, 0xFFFF, 0xFFE6,
    0xFFF5, 0xFFFD, 0x000E, 0x001D, 0xFFFC, 0x0018, 0xFFEF, 0x0026,
    0x0001, 0x0011, 0xFFF8, 0xFFF3, 0x0007, 0xFFF6, 0xFFEA, 0x0023,
    0xFFFC, 0xFFFF, 0xFFFE, 0xFFFA, 0xFFF9, 0x0013, 0xFFFC, 0x0006,
    0x0004, 0xFFFE, 0xFFF3, 0xFFF9, 0x000F, 0xFFF1, 0xFFF4, 0x001F,
    0x0009, 0x0004, 0xFFD4, 0xFFFE, 0xFFF4, 0x000B, 0x0003, 0x0005,
    0x0008, 0x0004, 0xFFE4, 0xFFEB, 0x0023, 0x000D, 0xFFE3, 0x0003,
    0xFFFF, 0x0005, 0xFFF9, 0x0005, 0xFFF5, 0x0001, 0x001E, 0x0001,
    0xFFDF, 0xFFF9, 0xFFFA, 0xFFE9, 0xFFFD, 0xFFF4, 0xFFF3, 0x0009,
    0x0013, 0x000D, 0x0006, 0xFFE3, 0xFFF8, 0xFFFF, 0xFFFE, 0x0015,
    0x0007, 0x0006, 0xFFFC, 0xFFF4, 0x0014, 0x0008, 0xFFF8, 0x0005,
    0xFFFA, 0xFFFC, 0xFFF3, 0x0011, 0x0002, 0x0006, 0x000E, 0x0011,
    0xFFFB, 0xFFDE, 0xFFEA, 0x0013, 0x000D, 0x0001, 0xFFF7, 0x0005,
    0x0013, 0xFFF9, 0x0011, 0x0018, 0x0007, 0x0006, 0xFFF8, 0xFFED,
    0xFFFA, 0xFFEC, 0x0015, 0x000E, 0xFFFD, 0x000D, 0xFFFC, 0xFFED,
    0xFFF7, 0xFFFD, 0x0015, 0x0005, 0x000A, 0x001A, 0x0002, 0xFFFF,
    0x001B, 0x000B, 0x0007, 0x0003, 0x0008, 0x000C, 0xFFE6, 0x0012,
    0xFFF9, 0xFFFC, 0xFFFE, 0xFFFC, 0xFFE6, 0xFFFA, 0x000E, 0xFFFA,
    0x0001, 0xFFFA, 0x0002, 0x000D, 0x000A, 0x0004, 0xFFFB, 0xFFEA,
    0x001D, 0x0007, 0x001A, 0x0000, 0x0003, 0xFFF0, 0x0002, 0x0011,
    0x000D, 0x0015, 0x0010, 0x001D, 0xFFED, 0x0001, 0x0006, 0xFFEB,
    0xFFF8, 0xFFFD, 0xFFFA, 0xFFE5, 0xFFF7, 0xFFDE, 0x000C, 0x0007,
    0x0010, 0x000D, 0x0007, 0x0004, 0xFFF0, 0x0002, 0x0020, 0x000F,
    0x0005, 0x000F, 0x0003, 0x000D, 0xFFF8, 0x0016, 0xFFF3, 0xFFF7,
    0x0016, 0xFFFB, 0xFFF6, 0xFFEE, 0xFFFF, 0x0002, 0x0004, 0x000E,
    0xFFF7, 0xFFF9, 0xFFF7, 0xFFE4, 0xFFE6, 0x000F, 0xFFFD, 0x0000,
    0xFFF2, 0x0001, 0x0014, 0xFFE7, 0xFFEA, 0xFFFA, 0xFFEA, 0x0006,
    0x0022, 0xFFF3, 0xFFE8, 0x0007, 0xFFE3, 0x0000, 0xFFF5, 0x0008,
    0x000A, 0xFFFB, 0xFFFE, 0xFFE3, 0xFFE4, 0xFFFB, 0xFFF2, 0xFFF7,
    0xFFDB, 0x000A, 0x0002, 0x0015, 0xFFF2, 0xFFFD, 0xFFD7, 0x0003,
    0x000D, 0xFFFD, 0x0028, 0x001F, 0x000F, 0x0004, 0xFFF8, 0x0017,
    0xFFFC, 0xFFEC, 0x000A, 0x0022, 0x0018, 0xFFFC, 0x001B, 0x001D,
    0xFFFA, 0xFFFE, 0xFFE5, 0x000D, 0xFFF7, 0xFFF5, 0xFFF8, 0x0001,
    0x000C, 0xFFEC, 0x0006, 0x0000, 0xFFEC, 0x002E, 0xFFFA, 0xFFFD,
    0xFFFA, 0xFFEB, 0xFFF2, 0x0001, 0x001C, 0xFFF4, 0x0024, 0x000F,
    0x000D, 0xFFEB, 0x000A, 0xFFFD, 0xFFFB, 0xFFFB, 0x0018, 0xFFF2,
    0xFFFE, 0x0001, 0xFFF8, 0xFFD1, 0x0024, 0xFFE1, 0xFFEA, 0xFFF9,
    0xFFFE, 0xFFD9, 0x0017, 0x0001, 0x0006, 0xFFEA, 0xFFCE, 0x000B,
    0x0006, 0x0003, 0xFFF8, 0xFFF8, 0x0019, 0xFFF4, 0x0016, 0x000C,
    0xFFF4, 0xFFFF, 0xFFEE, 0xFFFC, 0xFFF4, 0x0016, 0x0007, 0x001D,
    0x0000, 0xFFE9, 0x001D, 0xFFFD, 0xFFF9, 0xFFF4, 0x0013, 0x0010,
    0x000E, 0xFFDB, 0xFFFE, 0x0003, 0xFFD9, 0x0002, 0xFFED, 0x0003,
    0x0005, 0x0014, 0x0007, 0xFFE9, 0xFFFC, 0xFFFD, 0xFFED, 0x0008,
    0xFFF3, 0xFFF6, 0x0020, 0xFFE9, 0x0002, 0x0008, 0xFFFD, 0x0013,
    0x0011, 0xFFD9, 0xFFF7, 0x0000, 0xFFF2, 0xFFF2, 0xFFDF, 0xFFFB,
    0xFFDA, 0xFFED, 0xFFF3, 0xFFF9, 0xFFFB, 0xFFFE, 0xFFE1, 0x0014,
    0x000C, 0x0012, 0xFFE8, 0xFFF5, 0xFFFA, 0xFFFC, 0x0016, 0x001D,
    0xFFE4, 0x000A, 0x0000, 0x0004, 0x0019, 0x000F, 0xFFE3, 0xFFDD,
    0x002C, 0xFFF5, 0x0004, 0xFFEC, 0xFFEE, 0x0004, 0xFFD5, 0x0016,
    0x0005, 0xFFF0, 0xFFEF, 0xFFF7, 0x0012, 0x0000, 0x0010, 0xFFE3,
    0x000C, 0xFFFE, 0xFFFB, 0x0003, 0x0004, 0x0006, 0x0017, 0xFFF9,
    0x0012, 0x0012, 0x0023, 0x0009, 0xFFFD, 0x0012, 0xFFF9, 0xFFEC,
    0x001A, 0xFFE8, 0x0004, 0xFFE6, 0xFFFD, 0xFFFB, 0xFFF0, 0xFFFD,
    0x0000, 0x0002, 0x0003, 0x0026, 0xFFFD, 0xFFF4, 0x0002, 0xFFF5,
    0xFFFB, 0xFFFB, 0x000B, 0xFFF5, 0x0004, 0x0006, 0x0018, 0xFFF0,
    0x0001, 0xFFEA, 0x0012, 0xFFF5, 0x000D, 0x0012, 0xFFF6, 0xFFFF,
    0x002B, 0x001B, 0xFFF4, 0x0023, 0x0009, 0xFFEB, 0x0008, 0xFFFD,
    0xFFF5, 0xFFFB, 0xFFFF, 0x0004, 0xFFF1, 0x0003, 0xFFF0, 0x0005,
    0x000F, 0x000F, 0xFFEF, 0x0005, 0x0001, 0x0003, 0xFFF2, 0xFFFF,
    0x0020, 0x0000, 0xFFF0, 0x0016, 0xFFF8, 0xFFFA, 0xFFF8, 0x000A,
    0xFFF5, 0x000D, 0xFFF8, 0x0016, 0x0006, 0x0002, 0xFFFC, 0xFFFA,
    0xFFE9, 0xFFEC, 0xFFE7, 0x0027, 0xFFF8, 0xFFF1, 0x002B, 0xFFD4,
    0x000A, 0xFFDC, 0x0031, 0x0008, 0xFFEA, 0x0010, 0xFFEF, 0x0000,
    0xFFFB, 0x0004, 0x0031, 0x0005, 0xFFFC, 0xFFFD, 0x000D, 0xFFF9,
    0x001F, 0x0003, 0xFFF0, 0xFFE4, 0xFFF8, 0x0010, 0x000B, 0x0006,
    0x000D, 0xFFF8, 0xFFFF, 0x000A, 0x0007, 0xFFF4, 0x0008, 0xFFE9,
    0xFFFD, 0xFFF4, 0xFFF1, 0xFFF8, 0xFFED, 0xFFF3, 0xFFFA, 0x0001,
    0xFFE6, 0xFFFA, 0xFFE5, 0xFFFD, 0xFFFA, 0xFFE8, 0x0019, 0xFFE4,
    0x000B, 0xFFE3, 0x0016, 0xFFFA, 0xFFF5, 0xFFEB, 0x0006, 0x0005,
    0x0003, 0x001B, 0x000C, 0xFFF2, 0xFFF5, 0xFFFC, 0x0008, 0x0015,
    0xFFED, 0x0009, 0x0001, 0xFFF3, 0x0012, 0xFFEE, 0xFFE9, 0x000D,
    0x000A, 0xFFF6, 0x0017, 0x001F, 0xFFFE, 0x001C, 0xFFE8, 0x000C,
    0xFFFE, 0xFFF3, 0x0017, 0xFFDA, 0xFFFC, 0xFFD8, 0x0000, 0xFFF8,
    0x000F, 0xFFE5, 0xFFFB, 0xFFFE, 0xFFF9, 0x0032, 0x0006, 0x0000,
    0x0014, 0xFFFF, 0x0007, 0x0003, 0xFFE3, 0x0008, 0x0007, 0xFFEA,
    0xFFF1, 0x0018, 0xFFF4, 0x0006, 0x0009, 0x000A, 0xFFF5, 0xFFF9,
    0x0023, 0xFFF1, 0x0001, 0x000A, 0x0005, 0xFFF0, 0x0010, 0x0001,
    0xFFF0, 0xFFF7, 0x0009, 0x0004, 0xFFF8, 0x0005, 0xFFF6, 0x000A,
    0xFFFF, 0x0007, 0x0021, 0x0008, 0xFFEF, 0x001F, 0x0005, 0xFFF3,
    0x0005, 0x0004, 0x0014, 0xFFF2, 0x0026, 0xFFF7, 0x0005, 0xFFFE,
    0xFFF9, 0xFFF4, 0x0002, 0x0014, 0x000B, 0x0002, 0xFFFC, 0xFFFF,
    0xFFFE, 0xFFE7, 0xFFF1, 0x0002, 0xFFF5, 0xFFEA, 0xFFF9, 0x0011,
    0xFFEA, 0x0009, 0x0016, 0xFFFB, 0xFFF9, 0x0001, 0x0007, 0xFFF2,
    0x0004, 0xFFEE, 0xFFF0, 0x000A, 0x0009, 0x0004, 0xFFFC, 0x000F,
    0xFFED, 0xFFF7, 0xFFF7, 0xFFF8, 0x0021, 0x0005, 0xFFF7, 0xFFEE,
    0xFFF8, 0x0017, 0x0011, 0xFFE5, 0x001C, 0x0009, 0x000D, 0x0016,
    0xFFEB, 0x000D, 0x000A, 0x0002, 0x0001, 0xFFF8, 0xFFF3, 0xFFFB,
    0xFFFE, 0xFFFB, 0x0012, 0x0012, 0xFFF5, 0xFFFC, 0x000C, 0x0003,
    0x0014, 0xFFFA, 0xFFED, 0xFFF5, 0xFFFE, 0xFFFC, 0x000A, 0x0002,
    0x0013, 0xFFEF, 0x0018, 0x000B, 0xFFFA, 0x0007, 0xFFFD, 0x0001,
    0x0001, 0x0007, 0xFFFE, 0xFFFB, 0xFFFE, 0xFFE6, 0x0003, 0xFFF6,
    0x0017, 0xFFED, 0x001A, 0xFFCA, 0xFFE7, 0xFFF3, 0xFFEC, 0x0004,
    0xFFFE, 0x001F, 0x0003, 0x0005, 0x0009, 0x0005, 0x0001, 0xFFD9,
    0xFFF4, 0x000F, 0x0018, 0x000E, 0xFFFB, 0x000B, 0xFFF0, 0x000D,
    0xFFF7, 0x000B, 0x0001, 0xFFFE, 0x0004, 0xFFF5, 0x0005, 0x0006,
    0xFFF0, 0xFFF0, 0xFFDD, 0x0010, 0xFFDF, 0xFFE5, 0xFFE2, 0x0016,
    0x001E, 0x0004, 0x000A, 0xFFE9, 0x0002, 0x0002, 0x0027, 0x0021,
    0xFFE1, 0xFFF7, 0x0014, 0x000E, 0x0013, 0x000B, 0x0011, 0xFFF9,
    0xFFF4, 0x001A, 0x000F, 0x0005, 0x0015, 0xFFFE, 0x0009, 0xFFE7,
    0xFFEA, 0x0022, 0x000F, 0xFFFF, 0xFFF5, 0x000F, 0xFFF1, 0xFFEC,
    0x0012, 0x001B, 0xFFEC, 0xFFF1, 0x001D, 0x000A, 0xFFFE, 0x0006,
    0x0003, 0x0001, 0xFFF9, 0x0014, 0xFFF7, 0xFFF4, 0x000C, 0xFFE1,
    0xFFFA, 0x000B, 0xFFF2, 0xFFDC, 0xFFE6, 0x000A, 0xFFDE, 0x000B,
    0x001A, 0x000F, 0xFFD8, 0x0011, 0xFFF5, 0x0005, 0xFFFC, 0xFFDB,
    0xFFEA, 0x000D, 0x0010, 0xFFE3, 0x0003, 0xFFDF, 0xFFFC, 0x000B,
    0x0008, 0xFFFA, 0xFFF5, 0xFFF9, 0x000D, 0xFFF8, 0xFFDF, 0x0007,
    0xFFF3, 0xFFD4, 0xFFF4, 0xFFEE, 0x0030, 0xFFE8, 0x0024, 0xFFFB,
    0x0004, 0x0006, 0xFFF3, 0x0002, 0x0029, 0x0001, 0x0014, 0x0007,
    0xFFFA, 0xFFEF, 0xFFF1, 0x000A, 0x001D, 0x0021, 0x0012, 0x0005,
    0x000A, 0x0017, 0xFFE9, 0xFFC8, 0x0004, 0x0005, 0xFFF7, 0xFFFC,
    0xFFF1, 0x0008, 0xFFEE, 0xFFDB, 0xFFE4, 0x0003, 0x0003, 0x0010,
    0x001B, 0x0001, 0xFFE5, 0x0023, 0x000B, 0xFFFA, 0x0009, 0xFFF5,
    0xFFFE, 0x000D, 0xFFF3, 0x0014, 0x0006, 0x0008, 0x000A, 0xFFFB,
    0xFFF4, 0x0011, 0xFFF7, 0x0002, 0xFFFD, 0x0003, 0xFFE9, 0x000A,
    0xFFEC, 0xFFF9, 0x0002, 0x000C, 0x0010, 0xFFF4, 0x0025, 0xFFFA,
    0x0001, 0xFFFF, 0x0022, 0xFFE7, 0x000B, 0x0007, 0x0008, 0xFFF2,
    0x0017, 0xFFF5, 0x0001, 0xFFF5, 0x000F, 0x0019, 0x0018, 0x0004,
    0xFFED, 0xFFF1, 0xFFF0, 0xFFE9, 0xFFFE, 0x0000, 0xFFF9, 0x001B,
    0xFFEA, 0xFFEB, 0xFFF8, 0xFFFF, 0x0011, 0x000E, 0x001A, 0x000A,
    0x000C, 0xFFFC, 0x0005, 0x0000, 0x000C, 0xFFF6, 0xFFF9, 0x000E,
    0xFFF9, 0xFFF6, 0xFFE6, 0x0019, 0xFFFE, 0xFFF3, 0x0002, 0x0005,
    0xFFFD, 0xFFFE, 0x000A, 0xFFFF, 0xFFEC, 0xFFCE, 0x0016, 0xFFFC,
    0xFFF5, 0x0006, 0x0009, 0x0000, 0xFFF4, 0xFFF4, 0x001E, 0x0014,
    0xFFFF, 0xFFF3, 0xFFF9, 0x0009, 0xFFDF, 0x0019, 0x0009, 0x0003,
    0x0006, 0xFFFB, 0xFFD3, 0x0012, 0xFFFF, 0x0001, 0x0001, 0xFFEE,
    0x0008, 0x000B, 0x000E, 0x0014, 0xFFF3, 0x000A, 0xFFE0, 0xFFFD,
    0xFFE2, 0xFFFD, 0x000D, 0xFFFD, 0x0013, 0xFFEA, 0x0016, 0x0014,
    0xFFEA, 0x000D, 0x000E, 0x0003, 0x0035, 0xFFF0, 0x0019, 0x001D,
    0x0009, 0x0002, 0x0024, 0x000A, 0xFFE7, 0x0015, 0xFFFE, 0x0013,
    0xFFFC, 0xFFEF, 0xFFDD, 0xFFFE, 0x0025, 0x0027, 0xFFF7, 0xFFF7,
    0x0007, 0xFFE9, 0xFFFC, 0x0016, 0x000C, 0x0005, 0x0003, 0x000C,
    0x0008, 0x000F, 0x000D, 0xFFFB, 0x0008, 0x0008, 0x001F, 0xFFFF,
    0xFFE9, 0xFFFE, 0xFFEA, 0xFFDC, 0x0032, 0xFFF5, 0x0008, 0x0009,
    0x0007, 0xFFF4, 0x0015, 0xFFFA, 0xFFFF, 0x0015, 0x000D, 0xFFEB,
    0xFFF5, 0xFFFE, 0x000A, 0x0007, 0x0015, 0x0007, 0xFFF8, 0x0000,
    0x0005, 0xFFEF, 0x001E, 0x0011, 0xFFF6, 0xFFEF, 0x0009, 0x0014,
    0xFFFF, 0x0001, 0x0014, 0x0003, 0x0012, 0x0009, 0x0017, 0xFFED,
    0x000A, 0xFFF5, 0xFFF8, 0x0010, 0xFFF1, 0xFFEA, 0x0007, 0x0015,
    0x000D, 0x0025, 0xFFF6, 0x002D, 0xFFF0, 0x000B, 0xFFFF, 0xFFFC,
    0xFFF4, 0xFFFE, 0xFFE7, 0xFFEB, 0x001A, 0x0008, 0x0007, 0xFFF7,
    0x000D, 0x0000, 0xFFE4, 0xFFF1, 0xFFED, 0x0018, 0x0005, 0x0004,
    0x001F, 0x0001, 0x0009, 0x0023, 0x0004, 0xFFF5, 0x0015, 0xFFF6,
    0xFFE5, 0xFFFA, 0xFFF4, 0xFFF4, 0x0014, 0x0002, 0x0017, 0xFFEA,
    0x001B, 0x0001, 0xFFEB, 0x0000, 0xFFFB, 0x001B, 0xFFF3, 0xFFFD,
    0x000E, 0x0022, 0x0002, 0x001A, 0xFFF9, 0xFFED, 0xFFFF, 0x0006,
    0x0013, 0xFFFC, 0xFFE4, 0xFFFC, 0x0007, 0x0007, 0x0003, 0xFFD5,
    0x0006, 0x0004, 0x0013, 0xFFF2, 0x0012, 0x000D, 0x000D, 0x0001,
    0xFFDB, 0xFFE3, 0x001B, 0xFFFD, 0x0009, 0x0006, 0xFFDC, 0x0002,
    0x0012, 0x000B, 0xFFE1, 0x0008, 0xFFEF, 0xFFFF, 0xFFEE, 0x0002,
    0x0018, 0x0015, 0x0009, 0xFFFA, 0xFFFD, 0x0010, 0x0004, 0x0013,
    0xFFFC, 0x000E, 0xFFFE, 0xFFFC, 0xFFF2, 0xFFFE, 0xFFE2, 0xFFFF,
    0xFFF2, 0xFFEF, 0x0017, 0xFFF9, 0xFFF2, 0x0001, 0xFFFA, 0xFFFB,
    0xFFFD, 0x0027, 0x0003, 0xFFF9, 0xFFFD, 0x000D, 0x000E, 0x000A,
    0x0021, 0xFFFC, 0xFFF4, 0x0006, 0x002C, 0xFFF5, 0x0008, 0xFFE9,
    0x0009, 0x0012, 0xFFFB, 0xFFF6, 0x0010, 0xFFFD, 0x0023, 0x0014,
    0xFFEF, 0x0006, 0xFFFF, 0xFFDB, 0x000F, 0xFFE9, 0x0017, 0x0008,
    0x001C, 0x0018, 0xFFF3, 0x000D, 0x0003, 0xFFF1, 0xFFF3, 0xFFDB,
    0xFFE6, 0xFFF2, 0xFFE0, 0xFFD5, 0x0000, 0xFFE3, 0xFFEB, 0x0013,
    0x0002, 0xFFFB, 0x0023, 0x0010, 0xFFFE, 0xFFFC, 0xFFFC, 0x0014,
    0x0004, 0xFFFE, 0xFFE2, 0xFFED, 0xFFE5, 0x0005, 0x0013, 0xFFED,
    0xFFE7, 0x000B, 0x0021, 0x002B, 0xFFFF, 0x0006, 0x0028, 0xFFF9,
    0x0018, 0xFFF4, 0x0013, 0xFFED, 0x0003, 0xFFF8, 0xFFD8, 0xFFF9,
    0x000C, 0xFFFC, 0x000C, 0x0006, 0xFFF5, 0x0010, 0x0001, 0x0005,
    0xFFF8, 0xFFF1, 0x0000, 0x0008, 0x0004, 0xFFF0, 0x0004, 0xFFFB,
    0xFFF3, 0xFFE7, 0x0024, 0xFFE9, 0xFFF8, 0xFFD0, 0xFFF7, 0x0007,
    0x0009, 0xFFEA, 0xFFEB, 0xFFFD, 0xFFF7, 0x0007, 0x0005, 0x0005,
    0xFFF8, 0xFFEF, 0xFFEF, 0x0015, 0x0017, 0xFFE6, 0xFFFC, 0x0000,
    0xFFE9, 0x001E, 0x0006, 0xFFE0, 0xFFF0, 0xFFFB, 0x0012, 0x000F,
    0x0018, 0xFFEF, 0x000A, 0xFFED, 0x000B, 0x0010, 0xFFE2, 0xFFFD,
    0x001D, 0x0000, 0xFFE2, 0x0015, 0x0008, 0xFFDC, 0xFFFA, 0xFFEB,
    0xFFF7, 0xFFF5, 0x0001, 0x001D, 0x000B, 0xFFF2, 0x0011, 0xFFFC,
    0xFFFB, 0xFFFD, 0xFFFE, 0xFFFC, 0x0001, 0xFFFE, 0x0007, 0x0009,
    0xFFE8, 0xFFFF, 0x0009, 0xFFFA, 0xFFFE, 0xFFFA, 0xFFFD, 0x0006,
    0x0001, 0xFFEE, 0xFFFA, 0x0008, 0x000C, 0x000E, 0xFFF2, 0xFFE9,
    0xFFF5, 0x0007, 0x0008, 0x0019, 0x0000, 0x001C, 0xFFF2, 0x001B,
    0xFFFC, 0xFFF1, 0x000B, 0x0016, 0xFFF2, 0x0024, 0xFFFB, 0xFFF3,
    0xFFF9, 0x0006, 0x001E, 0x0010, 0x000D, 0x0007, 0xFFDC, 0x000C,
    0x0005, 0xFFF8, 0x0009, 0x001C, 0xFFEC, 0x000F, 0x0011, 0xFFFA,
    0xFFF8, 0x0015, 0xFFFD, 0x0008, 0xFFF3, 0xFFEC, 0x0017, 0xFFD3,
    0x0005, 0x0011, 0xFFFD, 0xFFEB, 0x000E, 0xFFF8, 0x001E, 0x000D,
    0xFFF6, 0x0003, 0x0004, 0xFFED, 0xFFDA, 0x000B, 0xFFCC, 0xFFF2,
    0x0003, 0x0020, 0x0007, 0x0005, 0x000E, 0x0003, 0xFFED, 0xFFEF,
    0xFFDB, 0x0013, 0x000D, 0x001F, 0xFFF4, 0xFFF0, 0x0000, 0xFFE3,
    0xFFE8, 0xFFE7, 0xFFEC, 0xFFE6, 0xFFDB, 0xFFE5, 0xFFEF, 0x000E,
    0x0013, 0xFFF9, 0xFFE9, 0x0009, 0x0014, 0xFFF4, 0x001B, 0x0010,
    0xFFFD, 0x2CCE, 0x0015, 0x0015, 0x0006, 0x0009, 0xFFFD, 0xFFF6,
    0x000F, 0xFFF1, 0xFFF1, 0xFFF0, 0x0019, 0xFFEE, 0xFFE2, 0xFFFC,
    0x001C, 0x000D, 0x0007, 0xFFFE, 0x0020, 0x001D, 0x0001, 0x0000,
    0xFFF4, 0xFFF7, 0xFFEA, 0x0015, 0xFFE2, 0x0017, 0xFFE8, 0xFFF7,
    0x001C, 0xFFF2, 0x000F, 0xFFED, 0xFFEE, 0x0029, 0x0019, 0x0007,
    0x0002, 0x0007, 0x0001, 0xFFFD, 0xFFF3, 0x000C, 0xFFE4, 0x0019,
    0xFFF6, 0x0014, 0x001D, 0xFFE7, 0x0000, 0x0015, 0xFFF4, 0xFFE9,
    0x0026, 0x0009, 0xFFEA, 0x0005, 0x0027, 0xFFD8, 0x000A, 0xFFFE,
    0xFFF7, 0x0000, 0x000B, 0xFFEB, 0xFFF9, 0x0001, 0x0004, 0x0008,
    0x0026, 0xFFDF, 0x0005, 0xFFFD, 0x001A, 0xFFF6, 0x0004, 0xFFE5,
    0x0018, 0xFFEC, 0xFFEA, 0xFFFD, 0xFFFE, 0x0009, 0xFFEF, 0x000D,
    0xFFE4, 0xFFFC, 0xFFEB, 0x0005, 0xFFFE, 0x0003, 0x0003, 0xFFDB,
    0x0004, 0xFFFC, 0x0004, 0xFFF3, 0x0006, 0xFFF5, 0xFFF5, 0x0013,
    0x000C, 0x001B, 0x0019, 0xFFCB, 0xFFDD, 0x001A, 0xFFFF, 0x0005,
    0xFFED, 0xFFCF, 0x0011, 0xFFEC, 0xFFFC, 0x0001, 0xFFFD, 0xFFFB,
    0x0003, 0xFFFC, 0xFFE1, 0x001D, 0xFFE6, 0x001C, 0x0001, 0xFFF7,
    0x0009, 0xFFFC, 0xFFF9, 0xFFFE, 0xFFFB, 0xFFF9, 0xFFFC, 0xFFFC,
    0xFFEC, 0xFFEA, 0x0015, 0xFFFF, 0x0004, 0x0020, 0x0012, 0x0003,
    0xFFE7, 0xFFF8, 0xFFF8, 0x0000, 0xFFFA, 0xFFEA, 0xFFF7, 0xFFF5,
    0xFFFC, 0xFFF5, 0x000A, 0xFFEC, 0x0004, 0x0006, 0x0001, 0xFFF7,
    0x0008, 0x000D, 0xFFF4, 0xFFD8, 0xFFEC, 0x0012, 0x0000, 0x0022,
    0xFFED, 0x0022, 0x001F, 0xFFF3, 0x0000, 0xFFF9, 0x001C, 0xFFF5,
    0x0018, 0x0008, 0x000D, 0xFFFB, 0x0007, 0xFFF4, 0x0021, 0x0009,
    0xFFF5, 0xFFF4, 0x0010, 0x0012, 0xFFFB, 0x0006, 0x000E, 0x0008,
    0xFFE3, 0x0001, 0xFFF0, 0xFFFD, 0x001A, 0x0000, 0xFFF7, 0x001C,
    0xFFF5, 0xFFF2, 0xFFEF, 0x000F, 0xFFFC, 0x0024, 0xFFE9, 0x000A,
    0x0016, 0xFFF6, 0x000A, 0xFFF8, 0xFFF0, 0xFFF6, 0x0006, 0x0000,
    0x0001, 0x0018, 0x0018, 0x0001, 0xFFD5, 0xFFF1, 0xFFF5, 0x000B,
    0xFFF9, 0x0004, 0xFFF0, 0x0003, 0xFFEC, 0xFFE9, 0x0009, 0x0010,
    0xFFF6, 0xFFE4, 0x000A, 0x0004, 0xFFFB, 0xFFEA, 0x000E, 0x0029,
    0x0011, 0x002B, 0x0015, 0x000D, 0xFFDD, 0x001A, 0xFFF8, 0xFFD8,
    0xFFFC, 0xFFE1, 0x0000, 0x000F, 0x0021, 0xFFED, 0xFFEC, 0x0002,
    0x001B, 0xFFF9, 0xFFFF, 0xFFF6, 0xFFF3, 0xFFEF, 0xFFF0, 0xFFF6,
    0xFFC9, 0x0000, 0xFFEE, 0xFFE9, 0xFFE1, 0x0012, 0x0007, 0xFFF5,
    0x0013, 0xFFFE, 0xFFF9, 0xFFEA, 0xFFFE, 0xFFF5, 0x0001, 0xFFFA,
    0xFFFC, 0x0000, 0x0001, 0x000F, 0x0004, 0xFFE0, 0x000E, 0xFFF2,
    0x0004, 0x0001, 0xFFE4, 0x0007, 0x0010, 0x0008, 0x0002, 0x0009,
    0x0004, 0xFFE7, 0xFFEB, 0x000C, 0x0018, 0x001A, 0x0003, 0xFFEC,
    0xFFF3, 0x0014, 0x0014, 0x0007, 0xFFD9, 0xFFFB, 0x000E, 0xFFFA,
    0xFFFD, 0xFFF6, 0xFFF3, 0x0001, 0xFFDC, 0x000F, 0x0006, 0x0016,
    0xFFF3, 0x0007, 0x0009, 0xFFF9, 0x000C, 0xFFF4, 0xFFE0, 0xFFFE,
    0xFFE3, 0x000A, 0x0019, 0x0014, 0x0001, 0xFFFD, 0xFFF3, 0xFFF1,
    0xFFD7, 0xFFFE, 0x001C, 0xFFFB, 0x000B, 0x000D, 0xFFF3, 0x0005,
    0xFFEA, 0x0000, 0x002C, 0xFFD4, 0x0001, 0x0016, 0x0032, 0xFFF0,
    0x0000, 0x000A, 0x0008, 0xFFF8, 0x0005, 0x002D, 0x001E, 0x0014,
    0xFFF5, 0xFFFE, 0xFFF4, 0x0008, 0xFFF2, 0x0015, 0x0019, 0x000D,
    0xFFFB, 0xFFFD, 0x000C, 0x0019, 0x0001, 0xFFFB, 0x0011, 0xFFF5,
    0xFFF2, 0x0018, 0x0016, 0xFFFE, 0x001A, 0x0002, 0x0006, 0x001A,
    0xFFFF, 0xFFE9, 0x0013, 0x0001, 0xFFF7, 0xFFF8, 0x0016, 0xFFDE,
    0xFFF7, 0xFFD4, 0x000A, 0xFFDC, 0xFFEE, 0x001A, 0x0002, 0xFFF5,
    0x0000, 0xFFEC, 0x0020, 0x0008, 0x000C, 0xFFF1, 0x0023, 0x0000,
    0x001D, 0xFFF9, 0xFFFB, 0x0024, 0xFFDD, 0x002A, 0xFFF4, 0x000A,
    0x001D, 0x001C, 0xFFFA, 0xFFFC, 0xFFFA, 0x001B, 0x001A, 0x000F,
    0x0010, 0x0010, 0x0001, 0x0011, 0x0002, 0xFFF3, 0x0014, 0x001B,
    0x0007, 0xFFF7, 0x0003, 0x0017, 0x0004, 0x0013, 0x000A, 0x0009,
    0xFFDC, 0xFFE9, 0x0017, 0xFFF9, 0x000A, 0xFFDD, 0x0007, 0x0005,
    0x0007, 0xFFF0, 0x000A, 0xFFED, 0x0010, 0xFFFF, 0x0014, 0x0005,
    0xFFDE, 0x0004, 0x0005, 0x000E, 0xFFE0, 0xFFF3, 0x0032, 0x0019,
    0xFFEC, 0x0002, 0xFFEF, 0x0006, 0xFFF1, 0xFFD7, 0x000B, 0x0010,
    0xFFFB, 0xFFEC, 0xFFEE, 0x0004, 0xFFF9, 0xFFDA, 0x0014, 0xFFF2,
    0x0013, 0x0008, 0x0006, 0xFFF3, 0xFFF8, 0xFFF9, 0xFFF5, 0xFFF7,
    0xFFFA, 0x0015, 0xFFE2, 0x0016, 0xFFF3, 0x0001, 0x0012, 0x0003,
    0x0007, 0xFFFF, 0x0003, 0x0017, 0xFFE7, 0xFFE9, 0x0002, 0x0000,
    0xFFF0, 0xFFEC, 0x000E, 0x0007, 0x000D, 0x0003, 0xFFF3, 0x000D,
    0xFFF7, 0x0012, 0x0015, 0xFFFD, 0x000D, 0x0009, 0x001F, 0x000A,
    0x000A, 0xFFEE, 0xFFFC, 0xFFF9, 0xFFFB, 0x000E, 0xFFFD, 0x000C,
    0x0001, 0xFFF3, 0x0004, 0xFFE4, 0x0014, 0xFFFE, 0x0003, 0xFFFE,
    0x0016, 0xFFFD, 0xFFEF, 0xFFD2, 0x000F, 0x001E, 0xFFFE, 0x0027,
    0xFFFA, 0x000D, 0x0003, 0xFFE5, 0x0004, 0xFFFB, 0xFFFD, 0xFFEC,
    0x0010, 0x0002, 0xFFFB, 0x0011, 0x002E, 0x0008, 0xFFEA, 0x000F,
    0xFFE9, 0xFFFB, 0x0011, 0xFFFB, 0x0008, 0xFFE7, 0x0024, 0x0005,
    0x0005, 0x0003, 0xFFF9, 0xFFE7, 0xFFFA, 0x0011, 0x0009, 0x0009,
    0xFFF9, 0xFFEA, 0xFFEF, 0x0035, 0x0002, 0xFFFB, 0x0011, 0x000A,
    0x0011, 0x0022, 0x001A, 0xFFFF, 0xFFEE, 0xFFF5, 0xFFEE, 0xFFE0,
    0xFFEA, 0x0016, 0x0010, 0xFFEF, 0xFFF9, 0xFFFA, 0x0016, 0x0007,
    0x000B, 0x0002, 0xFFF4, 0x0004, 0xFFE7, 0x0019, 0xFFFD, 0x000F,
    0x002D, 0x001A, 0xFFF1, 0x000B, 0x000F, 0x0001, 0xFFF8, 0x000E,
    0xFFEB, 0xFFEB, 0xFFE9, 0xFFF3, 0xFFF8, 0x0009, 0x0016, 0xFFEC,
    0x000F, 0xFFF5, 0x000D, 0x0019, 0xFFEC, 0xFFEC, 0x0016, 0xFFF4,
    0x0018, 0x0014, 0xFFF1, 0xFFFD, 0xFFF6, 0xFFF4, 0xFFED, 0x0013,
    0x000F, 0x001D, 0xFFEE, 0x0009, 0xFFFF, 0x000C, 0xFFE8, 0x0014,
    0x0012, 0xFFF1, 0xFFF4, 0x0019, 0x0014, 0xFFF6, 0x0018, 0xFFF6,
    0x000E, 0x0012, 0xFFF8, 0xFFDE, 0x000B, 0x000B, 0x0013, 0xFFFC,
    0xFFFA, 0x000C, 0xFFEA, 0xFFE3, 0xFFE7, 0x000E, 0x0003, 0x001E,
    0xFFED, 0xFFFF, 0x0009, 0x0013, 0xFFFD, 0xFFFB, 0x0010, 0x003E,
    0xFFF8, 0xFFF8, 0xFFF1, 0x0011, 0x002C, 0xFFFC, 0x0012, 0x0002,
    0x001C, 0x0001, 0x0001, 0x0000, 0xFFF1, 0xFFEA, 0xFFE5, 0x0026,
    0xFFFD, 0x0004, 0x000B, 0x0005, 0x0014, 0x0001, 0xFFF8, 0x0004,
    0x0014, 0x001C, 0x000F, 0x0016, 0x0023, 0xFFE5, 0x0013, 0x0006,
    0x0000, 0xFFE8, 0x0003, 0xFFE9, 0x000D, 0x000B, 0xFFF7, 0x0001,
    0x000C, 0xFFFA, 0xFFE8, 0xFFEA, 0xFFCD, 0x0009, 0xFFF4, 0x0010,
    0xFFFB, 0xFFFA, 0x0003, 0xFFE3, 0xFFEF, 0xFFF3, 0x0002, 0xFFE7,
    0xFFE0, 0x0018, 0x0002, 0x0016, 0x001B, 0x000B, 0x0002, 0x000E,
    0x0008, 0xFFD9, 0x0002, 0x0002, 0x0004, 0xFFFB, 0x000B, 0x0002,
    0xFFF7, 0xFFE3, 0xFFFF, 0x0000, 0xFFF0, 0xFFE3, 0x0003, 0x0005,
    0xFFF1, 0xFFF5, 0xFFF8, 0x000E, 0xFFD0, 0xFFF4, 0xFFF2, 0x0003,
    0x0005, 0xFFDA, 0xFFFC, 0x0003, 0x0010, 0x000E, 0x0014, 0x0010,
    0xFFDC, 0xFFF0, 0xFFF6, 0x0000, 0xFFFE, 0x002C, 0x000D, 0xFFEC,
    0x0010, 0xFFD8, 0xFFF9, 0x0004, 0x0011, 0xFFFE, 0x002D, 0x001A,
    0xFFEC, 0xFFFA, 0xFFEE, 0xFFD5, 0x000E, 0x0001, 0xFFF1, 0x0019,
    0x0007, 0x0006, 0x000C, 0xFFFC, 0xFFF4, 0x0007, 0x0013, 0x0007,
    0x001A, 0x0005, 0xFFEC, 0x0023, 0x0010, 0x0000, 0x0007, 0xFFFA,
    0x0015, 0x0005, 0x0004, 0xFFFF, 0x0008, 0x0016, 0x0007, 0x0006,
    0xFFF9, 0xFFF1, 0x0009, 0xFFDE, 0x0005, 0x0004, 0x0010, 0x0000,
    0xFFD4, 0xFFFD, 0xFFE9, 0x0003, 0x000E, 0xFFFB, 0xFFFB, 0xFFE2,
    0x0006, 0x0014, 0x0004, 0xFFFE, 0x0009, 0xFFF6, 0x0015, 0xFFEF,
    0xFFDE, 0x000A, 0xFFE3, 0x002A, 0xFFE0, 0xFFF0, 0x0018, 0x000D,
    0xFFFC, 0x0017, 0x0005, 0x0024, 0xFFEF, 0x0001, 0xFFF6, 0xFFEE,
    0x0013, 0x000A, 0x0007, 0xFFF4, 0x0021, 0x0021, 0x0007, 0x0007,
    0x000E, 0x000C, 0x0015, 0xFFFA, 0x0026, 0xFFF4, 0xFFE2, 0x0005,
    0x0016, 0xFFDD, 0x0008, 0xFFFB, 0xFFF1, 0x000D, 0x0012, 0xFFEB,
    0xFFF8, 0xFFDF, 0x0009, 0x0013, 0xFFFC, 0xFFFE, 0x001A, 0xFFEF,
    0xFFE6, 0x001A, 0x000F, 0x0016, 0xFFF6, 0xFFE1, 0x0000, 0xFFF8,
    0x000A, 0xFFFF, 0x0008, 0x0006, 0x0002, 0x0000, 0x000B, 0xFFFB,
    0x000D, 0xFFFA, 0xFFFB, 0x0012, 0xFFF6, 0xFFF4, 0xFFFB, 0x0018,
    0xFFF3, 0xFFFE, 0x0006, 0xFFFC, 0x000C, 0x0000, 0xFFE4, 0xFFF7,
    0x0014, 0xFFF4, 0x001F, 0x000E, 0xFFF5, 0x0007, 0x0002, 0xFFD8,
    0xFFF8, 0x0019, 0x0000, 0x000C, 0x001D, 0x0014, 0xFFE7, 0x0031,
    0xFFD1, 0x0013, 0x000B, 0x0020, 0x000F, 0xFFE4, 0x0007, 0x0025,
    0xFFEE, 0xFFF4, 0x0000, 0xFFF7, 0x000A, 0xFFF1, 0x000C, 0x0011,
    0xFFE9, 0x0002, 0xFFF5, 0x0016, 0xFFFB, 0xFFFB, 0x000A, 0xFFE7,
    0x0000, 0xFFEC, 0xFFD2, 0xFFD5, 0xFFF7, 0xFFDA, 0x0019, 0x0022,
    0xFFF5, 0xFFEE, 0xFFFB, 0x0020, 0xFFF1, 0x0006, 0xFFF9, 0x0012,
    0x001A, 0x0002, 0xFFFE, 0xFFEE, 0x0012, 0xFFFF, 0x0003, 0x0016,
    0xFFF2, 0xFFD7, 0x0009, 0xFFFD, 0xFFF6, 0xFFE0, 0x0005, 0xFFFB,
    0x000F, 0xFFFA, 0x0007, 0x000C, 0xFFDE, 0xFFEE, 0xFFF6, 0x0017,
    0x001C, 0x0003, 0xFFF1, 0xFFFF, 0x0001, 0xFFE3, 0xFFFB, 0xFFF8,
    0xFFE5, 0xFFE4, 0x000E, 0xFFED, 0x000E, 0xFFE3, 0x0014, 0x0032,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_noisy_4096[4097] = {
    0x0021, 0x0000, 0x0014, 0xFFCE, 0x000E, 0x001D, 0x000E, 0x0013,
    0xFFE5, 0x001C, 0xFFFB, 0x0008, 0x0001, 0x001D, 0xFFF1, 0x0001,
    0x001C, 0xFFFD, 0xFFF6, 0xFFE9, 0xFFDE, 0x0012, 0x0007, 0xFFF4,
    0x000F, 0x0006, 0x0005, 0x0005, 0xFFF6, 0x0020, 0x0009, 0x0003,
    0xFFF2, 0x0029, 0x0003, 0xFFEA, 0x0012, 0x0001, 0xFFFE, 0x0012,
    0x001A, 0xFFFE, 0xFFF9, 0xFFEE, 0xFFF1, 0xFFFA, 0xFFFB, 0xFFE0,
    0xFFF5, 0x0012, 0x0019, 0xFFDE, 0xFFF7, 0x0026, 0xFFD2, 0x002B,
    0x0000, 0x0014, 0x000A, 0x0019, 0xFFFB, 0x0005, 0xFFF5, 0xFFEA,
    0xFFE9, 0xFFFE, 0x000C, 0xFFEF, 0x000A, 0x000F, 0x0000, 0x0009,
    0xFFEE, 0x000C, 0x0007, 0xFFDB, 0x000F, 0x001C, 0x000B, 0xFFE0,
    0xFFD1, 0xFFED, 0xFFE7, 0xFFCF, 0x001D, 0xFFEC, 0x0000, 0xFFF4,
    0xFFF8, 0xFFE7, 0x0002, 0x0028, 0xFFF5, 0xFFF9, 0x001F, 0xFFF2,
    0x0014, 0x000C, 0xFFE4, 0x0009, 0x000C, 0x0000, 0x0006, 0x0004,
    0xFFF3, 0x0002, 0xFFFB, 0xFFE8, 0xFFF6, 0x000C, 0xFFFB, 0xFFEE,
    0x000D, 0x0006, 0x000B, 0x0005, 0x0002, 0x0000, 0x0008, 0xFFFA,
    0x000A, 0x0001, 0x0000, 0x0008, 0xFFF6, 0x001F, 0x000F, 0xFFEA,
    0xFFE6, 0xFFE6, 0x001A, 0x0011, 0xFFFC, 0x0002, 0x0009, 0xFFED,
    0xFFF8, 0x0021, 0x0012, 0x0015, 0xFFF1, 0xFFF3, 0x0008, 0x0005,
    0x0016, 0x0023, 0xFFE2, 0xFFFB, 0x0026, 0x000C, 0x0015, 0x0006,
    0x000E, 0xFFF4, 0x0007, 0xFFF9, 0x0021, 0xFFDF, 0x0007, 0x000C,
    0x0013, 0xFFF6, 0xFFF6, 0x0012, 0xFFEF, 0xFFFF, 0x0005, 0xFFDC,
    0xFFFC, 0xFFE9, 0x0018, 0xFFF3, 0xFFE0, 0x0010, 0xFFE3, 0xFFD6,
    0xFFDE, 0xFFF6, 0x0015, 0x0011, 0x0009, 0x000A, 0x0004, 0x0002,
    0x0006, 0xFFEC, 0xFFFB, 0x001E, 0x000E, 0x0005, 0xFFE9, 0xFFFD,
    0xFFD4, 0x0003, 0x0010, 0x0000, 0x0005, 0xFFFC, 0x0009, 0x0022,
    0xFFF9, 0x000F, 0x0007, 0xFFFA, 0x0008, 0xFFEA, 0x0004, 0x0001,
    0x0015, 0xFFFB, 0x0007, 0x0006, 0x0010, 0x0000, 0xFFEC, 0xFFDD,
    0x001A, 0xFFFB, 0x0013, 0xFFF9, 0xFFF4, 0xFFF9, 0x000C, 0x0004,
    0x0007, 0xFFFA, 0xFFF1, 0xFFE7, 0x000E, 0xFFFF, 0xFFEE, 0x002B,
    0xFFEC, 0x0006, 0x002D, 0xFFE6, 0x0011, 0x0002, 0xFFF9, 0xFFFC,
    0x0010, 0x0028, 0x000D, 0x0014, 0xFFFE, 0xFFD4, 0xFFF6, 0x0000,
    0xFFDC, 0x0010, 0x0014, 0xFFF0, 0x0010, 0xFFF2, 0xFFFC, 0xFFFD,
    0x0005, 0x0026, 0xFFF2, 0xFFFD, 0xFFD0, 0x000C, 0xFFF8, 0xFFF2,
    0xFFF1, 0x000B, 0x0003, 0xFFFB, 0xFFF0, 0x001D, 0xFFFF, 0x0000,
    0xFFF7, 0x001D, 0x000B, 0xFFFE, 0x0004, 0x0005, 0x0002, 0xFFFE,
    0x0008, 0x0027, 0x0002, 0xFFF2, 0x001B, 0xFFF5, 0x0002, 0xFFEA,
    0xFFE0, 0xFFE8, 0x0002, 0x0019, 0xFFEF, 0x000D, 0x0003, 0x001D,
    0xFFFB, 0x0006, 0xFFF4, 0xFFF0, 0xFFCD, 0xFFF7, 0xFFE8, 0x0016,
    0x000C, 0x0006, 0xFFF7, 0xFFFF, 0x000D, 0xFFF5, 0x0003, 0x0017,
    0x0000, 0x0018, 0x0013, 0xFFFA, 0x0023, 0x001B, 0x000F, 0xFFEA,
    0x0014, 0xFFE4, 0xFFF8, 0xFFFC, 0x0014, 0xFFFF, 0x000B, 0xFFFB,
    0xFFFD, 0xFFFC, 0xFFE5, 0xFFDA, 0xFFF1, 0x0016, 0x0001, 0x0000,
    0x001C, 0xFFFF, 0x0012, 0xFFFE, 0x002C, 0x0004, 0xFFF1, 0xFFEF,
    0xFFF8, 0x0008, 0x0010, 0xFFC2, 0xFFFD, 0x0005, 0x0009, 0xFFED,
    0xFFED, 0x0001, 0x0003, 0xFFE2, 0xFFE7, 0xFFF2, 0xFFEA, 0x001D,
    0xFFFA, 0xFFF4, 0x0013, 0x0004, 0x000B, 0xFFF5, 0xFFF8, 0x0022,
    0x000E, 0xFFEE, 0x0018, 0x000A, 0x0014, 0x000A, 0xFFF4, 0xFFE7,
    0x0012, 0x000F, 0xFFE8, 0xFFEC, 0xFFFF, 0xFFF4, 0xFFEE, 0xFFF7,
    0x000F, 0xFFE3, 0xFFED, 0xFFED, 0xFFF6, 0x000C, 0xFFF1, 0x0003,
    0x0018, 0xFFEC, 0x0016, 0x000C, 0xFFEC, 0x0014, 0x000D, 0xFFE7,
    0x000F, 0x000B, 0x0016, 0x0014, 0xFFF8, 0xFFF7, 0xFFE9, 0x000D,
    0xFFEB, 0x0015, 0xFFF8, 0xFFF2, 0x000F, 0xFFFF, 0xFFF1, 0xFFF5,
    0x002D, 0xFFE6, 0xFFFD, 0xFFF1, 0xFFE7, 0xFFE7, 0xFFF4, 0xFFFC,
    0x000B, 0xFFFE, 0x0016, 0xFFF9, 0xFFF9, 0x0006, 0x0010, 0x0011,
    0xFFEA, 0xFFEA, 0xFFEE, 0x0020, 0xFFEE, 0x000B, 0x001A, 0x0001,
    0x0011, 0xFFDE, 0x0011, 0xFFF6, 0x0002, 0x0005, 0xFFEF, 0xFFCB,
    0xFFF9, 0x0016, 0x0009, 0xFFF7, 0xFFFA, 0xFFEF, 0xFFF9, 0x0019,
    0x0005, 0xFFFD, 0x0024, 0xFFFB, 0x0008, 0x0019, 0x0011, 0x0005,
    0xFFE9, 0x0005, 0xFFEA, 0xFFF1, 0x002E, 0xFFF8, 0xFFFB, 0xFFEF,
    0x0010, 0xFFFE, 0xFFFD, 0x0014, 0x0004, 0x0005, 0x0003, 0x001B,
    0xFFFA, 0xFFF3, 0xFFFE, 0xFFD9, 0x000F, 0xFFE2, 0xFFEF, 0x002E,
    0x0016, 0x0003, 0x0003, 0x0002, 0x0014, 0x0002, 0x0004, 0x001C,
    0x0001, 0x000D, 0xFFFD, 0xFFF4, 0xFFFB, 0xFFF2, 0xFFFC, 0x0007,
    0x000A, 0x0012, 0x001F, 0xFFF6, 0x000D, 0xFFF7, 0x0015, 0x0003,
    0xFFF7, 0xFFEE, 0xFFF3, 0xFFF3, 0x000D, 0xFFFD, 0x000E, 0xFFF9,
    0xFFF0, 0x0014, 0x0002, 0x0000, 0xFFE7, 0x0017, 0x0003, 0xFFE9,
    0x0007, 0x0001, 0x0012, 0xFFFD, 0xFFF3, 0xFFFF, 0xFFE2, 0xFFEA,
    0xFFFA, 0xFFEB, 0xFFF5, 0x0009, 0xFFF8, 0x0007, 0x0006, 0x000D,
    0x0013, 0xFFF8, 0x0014, 0x000E, 0xFFF9, 0x0026, 0xFFEE, 0xFFFC,
    0xFFFB, 0x0014, 0x000B, 0xFFF0, 0xFFF1, 0x0029, 0xFFEF, 0xFFFA,
    0xFFEC, 0xFFFE, 0x0032, 0xFFE7, 0xFFE0, 0x000D, 0x0005, 0xFFF2,
    0xFFDE, 0xFFFC, 0x0014, 0xFFFB, 0x0010, 0x0001, 0x000A, 0x0013,
    0x0007, 0x0010, 0x0007, 0xFFFB, 0x000A, 0x0023, 0x0017, 0x0007,
    0xFFDC, 0x0017, 0x000A, 0xFFF7, 0x0004, 0xFFED, 0x0003, 0xFFE9,
    0x0007, 0x0009, 0x0014, 0xFFE5, 0x0002, 0x000D, 0x0001, 0xFFEF,
    0x0010, 0xFFF0, 0x001A, 0xFFF1, 0xFFFA, 0xFFE5, 0xFFFA, 0x0004,
    0x001D, 0xFFE4, 0xFFF4, 0xFFF6, 0xFFDD, 0xFFD6, 0xFFFB, 0xFFDC,
    0x001D, 0x0007, 0x0023, 0x0000, 0x000C, 0x000F, 0x0020, 0xFFF8,
    0x0000, 0x0014, 0x0002, 0x000B, 0xFFEE, 0xFFE6, 0x000A, 0x0024,
    0xFFF7, 0x002C, 0x0016, 0x0022, 0xFFF7, 0x0008, 0x0013, 0xFFFF,
    0xFFFF, 0x0017, 0x0006, 0xFFE6, 0x001A, 0xFFFE, 0x0016, 0x0002,
    0xFFF2, 0xFFE8, 0x0011, 0x000B, 0x0001, 0x0005, 0x000C, 0xFFE7,
    0xFFFB, 0x0003, 0x0019, 0xFFF3, 0xFFF2, 0xFFEB, 0xFFF4, 0xFFF8,
    0xFFF5, 0x0002, 0x001E, 0xFFEC, 0x0005, 0xFFD3, 0x0008, 0x0008,
    0x0000, 0xFFF6, 0x0032, 0x0010, 0x0001, 0xFFEA, 0x002C, 0x002C,
    0xFFEA, 0x0000, 0xFFF3, 0xFFFB, 0x000B, 0xFFF3, 0x001C, 0x0005,
    0xFFD7, 0x0002, 0xFFF3, 0x000F, 0x0001, 0x0003, 0x0019, 0xFFEC,
    0xFFE3, 0xFFF6, 0xFFE0, 0x0002, 0x000C, 0x000C, 0x0009, 0x0007,
    0xFFF3, 0xFFF9, 0x0006, 0xFFEA, 0xFFDC, 0xFFF1, 0xFFF3, 0xFFFF,
    0xFFFD, 0x000A, 0x000E, 0x0006, 0xFFD9, 0x0005, 0x0014, 0xFFF9,
    0xFFF3, 0xFFEC, 0x0003, 0x0014, 0x0018, 0xFFE6, 0xFFEB, 0xFFF4,
    0x0004, 0x0019, 0x0002, 0xFFF7, 0x0010, 0xFFF8, 0xFFE4, 0xFFF9,
    0x0004, 0xFFFF, 0x000E, 0x000E, 0x0004, 0x0020, 0x0001, 0xFFF1,
    0xFFFC, 0x0000, 0x0001, 0x0006, 0xFFFE, 0x000B, 0xFFF9, 0x0016,
    0x0013, 0x0002, 0x0007, 0x000B, 0xFFE1, 0xFFEE, 0xFFEE, 0x0017,
    0xFFC9, 0x0000, 0xFFF0, 0x000A, 0xFFF3, 0x0011, 0xFFFF, 0x000A,
    0x001B, 0x0007, 0xFFEC, 0xFFFE, 0x0021, 0x0013, 0x0000, 0xFFF1,
    0xFFFC, 0x001F, 0xFFF8, 0x0028, 0xFFDD, 0xFFE6, 0x0015, 0xFFF3,
    0x0011, 0xFFD5, 0x000E, 0xFFD7, 0xFFFB, 0x0016, 0x000A, 0xFFFC,
    0xFFF6, 0x001C, 0x0009, 0xFFF0, 0xFFEC, 0x0017, 0xFFF0, 0xFFFD,
    0xFFF9, 0xFFFC, 0xFFF5, 0xFFF5, 0xFFD5, 0x000F, 0x0018, 0xFFFF,
    0x0001, 0xFFE8, 0x0006, 0x0000, 0xFFF0, 0x000A, 0x000A, 0x0008,
    0x0016, 0x000A, 0xFFE9, 0xFFF6, 0xFFFC, 0xFFDC, 0xFFEF, 0xFFF1,
    0xFFF5, 0x000E, 0xFFF7, 0xFFE4, 0x001A, 0x0000, 0xFFF0, 0x0003,
    0xFFE3, 0xFFFF, 0x000E, 0xFFF8, 0xFFFB, 0xFFFA, 0x0010, 0xFFEE,
    0xFFF5, 0x000C, 0x0021, 0xFFF7, 0x0007, 0x000C, 0x000D, 0x0005,
    0x0018, 0xFFF8, 0x001C, 0x000B, 0x0000, 0x0007, 0x001F, 0x000D,
    0xFFED, 0xFFDE, 0x0000, 0xFFDE, 0xFFEC, 0xFFEE, 0xFFF4, 0x0028,
    0x0008, 0xFFF3, 0x0001, 0x0009, 0x0004, 0xFFFA, 0x000A, 0x0014,
    0xFFFC, 0x000B, 0xFFF7, 0x000B, 0xFFFA, 0x0016, 0xFFF8, 0x0000,
    0xFFE7, 0x0008, 0x0012, 0xFFFD, 0x0004, 0xFFE0, 0x0015, 0x0001,
    0xFFEC, 0x0016, 0xFFFC, 0x0004, 0xFFFB, 0x0007, 0xFFF9, 0x0002,
    0x0009, 0x0004, 0x0001, 0x0009, 0xFFE6, 0xFFE4, 0xFFE1, 0xFFE3,
    0x0003, 0x0004, 0xFFFD, 0x0005, 0xFFFC, 0xFFFF, 0x0011, 0x0014,
    0xFFED, 0x0031, 0xFFFF, 0xFFFB, 0xFFDD, 0xFFE6, 0x0019, 0x0035,
    0x000C, 0xFFE5, 0xFFF5, 0xFFED, 0x0006, 0x000B, 0x0004, 0x000D,
    0x0004, 0x0004, 0x0003, 0x0025, 0xFFFE, 0xFFFD, 0xFFEB, 0xFFFB,
    0xFFE4, 0x0004, 0xFFEF, 0xFFF3, 0xFFFE, 0xFFF7, 0xFFEA, 0x0003,
    0x0018, 0x0014, 0x0004, 0x001B, 0x001A, 0x000A, 0x0005, 0x0003,
    0x0026, 0x0021, 0x0004, 0xFFF8, 0xFFF9, 0xFFFF, 0x000B, 0x0015,
    0xFFF7, 0x0000, 0x000A, 0x0002, 0x0027, 0x0028, 0xFFEA, 0xFFFB,
    0x0026, 0xFFF7, 0xFFF4, 0x0017, 0x0000, 0xFFEB, 0x001D, 0x0019,
    0xFFF6, 0xFFEC, 0xFFE4, 0xFFE7, 0xFFF3, 0xFFF4, 0x0001, 0x0003,
    0x0002, 0xFFF9, 0x0019, 0xFFF9, 0xFFEE, 0xFFD7, 0x000F, 0x0013,
    0x001C, 0x000E, 0xFFE8, 0x0009, 0xFFE2, 0xFFE9, 0xFFEA, 0xFFEB,
    0xFFF4, 0x0009, 0x0001, 0x0000, 0x0020, 0xFFE3, 0x0007, 0x0002,
    0x001C, 0xFFF3, 0xFFE2, 0x0004, 0x0019, 0x0012, 0xFFF1, 0x0010,
    0x000F, 0x000F, 0xFFFD, 0x000A, 0x0006, 0xFFF7, 0x0015, 0xFFEB,
    0xFFFD, 0xD332, 0x001B, 0xFFF0, 0x0014, 0x000C, 0xFFE9, 0xFFF7,
    0x0013, 0x0007, 0xFFEF, 0xFFF2, 0xFFDB, 0x001B, 0xFFEC, 0x001A,
    0xFFE8, 0x0019, 0x0000, 0x001D, 0xFFF4, 0x0010, 0x000D, 0xFFE1,
    0xFFDB, 0xFFED, 0xFFED, 0x0011, 0x000E, 0xFFFD, 0x0007, 0xFFFB,
    0x0003, 0xFFE0, 0xFFCC, 0x000E, 0xFFDA, 0xFFF5, 0x0004, 0x0013,
    0xFFF6, 0xFFFD, 0x001E, 0xFFF3, 0x000E, 0x0008, 0xFFFD, 0x0015,
    0x0005, 0xFFEF, 0x0017, 0x002D, 0xFFF3, 0x0014, 0xFFFD, 0xFFF8,
    0xFFF8, 0xFFEB, 0x0011, 0x0006, 0xFFEC, 0xFFF1, 0x0009, 0xFFE4,
    0x0005, 0x0008, 0xFFDC, 0xFFF4, 0x000D, 0xFFF9, 0x001E, 0xFFF0,
    0xFFF9, 0xFFFA, 0xFFFB, 0x000D, 0xFFF2, 0xFFDC, 0x000B, 0xFFEA,
    0xFFFC, 0x000F, 0xFFF2, 0xFFE5, 0x0000, 0xFFE4, 0x0008, 0xFFE7,
    0xFFF5, 0xFFF9, 0xFFF2, 0x0017, 0x000C, 0xFFF2, 0xFFFA, 0xFFF8,
    0x0001, 0x0012, 0xFFFD, 0xFFFA, 0xFFFE, 0x0006, 0x0009, 0x0006,
    0xFFE8, 0x0001, 0x0007, 0xFFF7, 0x0001, 0x0002, 0xFFFE, 0x0004,
    0xFFFB, 0x0003, 0x0011, 0x0004, 0x000B, 0x000E, 0x0001, 0xFFE3,
    0xFFF7, 0x000B, 0xFFFA, 0x0015, 0x0008, 0x0024, 0xFFE2, 0xFFEB,
    0x001D, 0x0000, 0xFFE2, 0x0003, 0x000B, 0xFFF0, 0x000A, 0x0013,
    0x0018, 0x0011, 0x0012, 0xFFF1, 0xFFF0, 0x0005, 0x0006, 0x0020,
    0xFFE9, 0xFFE2, 0xFFFC, 0x0000, 0x0017, 0x001A, 0xFFEF, 0xFFEB,
    0xFFF8, 0x0011, 0x0005, 0xFFFB, 0xFFF7, 0xFFF9, 0xFFEB, 0x0003,
    0x0009, 0x0016, 0xFFF7, 0xFFF9, 0xFFF8, 0x0030, 0x0024, 0x0017,
    0xFFF3, 0x0019, 0x0004, 0x0005, 0x0004, 0x0010, 0x0000, 0xFFF8,
    0xFFF8, 0x000F, 0x0001, 0xFFFB, 0xFFF5, 0xFFF0, 0x000C, 0xFFFA,
    0x000C, 0x0004, 0xFFD8, 0x0007, 0x0003, 0x0008, 0x0013, 0x0013,
    0x0018, 0x000C, 0x0028, 0x0007, 0xFFFF, 0xFFFA, 0x0021, 0xFFD5,
    0xFFE7, 0xFFF5, 0x0013, 0x0013, 0xFFE5, 0xFFFB, 0xFFE2, 0x0013,
    0x0004, 0x0002, 0xFFFC, 0xFFEC, 0xFFFE, 0x0004, 0x0023, 0xFFF0,
    0x0002, 0x0005, 0xFFEB, 0xFFED, 0x0000, 0x001D, 0xFFE0, 0x002B,
    0xFFE6, 0x000E, 0xFFF3, 0x0025, 0x0003, 0x000F, 0xFFF3, 0xFFF3,
    0x001C, 0xFFE8, 0x0017, 0xFFF8, 0x000F, 0x0017, 0xFFFF, 0x0025,
    0xFFEF, 0xFFFA, 0x0023, 0xFFEC, 0x0010, 0x0003, 0xFFFB, 0x000A,
    0x0009, 0xFFEE, 0x0008, 0x0017, 0x002C, 0x000B, 0xFFF4, 0xFFFA,
    0x0021, 0x0004, 0x000E, 0xFFF6, 0xFFFD, 0xFFF3, 0x0003, 0x0007,
    0xFFFD, 0xFFD9, 0xFFFA, 0x0005, 0xFFF2, 0xFFFF, 0x0017, 0x0007,
    0xFFF2, 0x0011, 0xFFE2, 0x0001, 0xFFF2, 0x0002, 0xFFFE, 0x0004,
    0xFFFC, 0xFFF2, 0x0004, 0xFFED, 0xFFFD, 0xFFF0, 0x0009, 0x0006,
    0x0018, 0xFFEB, 0xFFEE, 0xFFFE, 0xFFEF, 0x0001, 0xFFE1, 0xFFF8,
    0x0012, 0xFFF5, 0xFFDC, 0xFFFE, 0x0009, 0xFFFA, 0x001B, 0x0003,
    0xFFDB, 0x001D, 0x000D, 0xFFFF, 0x0012, 0xFFF3, 0x0013, 0x000E,
    0x0006, 0xFFFC, 0x0003, 0x002B, 0x0007, 0xFFF9, 0xFFE4, 0x0004,
    0x0013, 0x0004, 0xFFFF, 0xFFFA, 0xFFF9, 0x0013, 0x0002, 0xFFE6,
    0x000E, 0xFFDE, 0xFFF3, 0x0003, 0xFFFB, 0xFFE5, 0xFFEB, 0x0000,
    0x001B, 0xFFFF, 0x0017, 0x0016, 0x0014, 0xFFFE, 0xFFF4, 0x000C,
    0xFFE5, 0x0006, 0x0015, 0x000A, 0x0004, 0x000B, 0x0009, 0xFFDD,
    0x001F, 0xFFFF, 0x0005, 0xFFFC, 0xFFED, 0xFFE8, 0xFFE4, 0x000F,
    0x000D, 0x0000, 0x0007, 0x0009, 0x001A, 0xFFF8, 0xFFE7, 0x0015,
    0xFFF4, 0x0002, 0xFFFF, 0x0004, 0xFFF0, 0xFFF5, 0xFFF6, 0xFFD3,
    0x000D, 0xFFDB, 0x0007, 0xFFEB, 0xFFF1, 0x0016, 0xFFF8, 0xFFF0,
    0x000A, 0x000B, 0x0017, 0x0013, 0x0012, 0xFFF7, 0x0014, 0xFFFD,
    0xFFFF, 0xFFFF, 0x0009, 0xFFEC, 0xFFF6, 0x0011, 0x001E, 0xFFEF,
    0x0005, 0x0011, 0xFFF8, 0x0000, 0x0015, 0xFFF9, 0x000A, 0xFFF9,
    0xFFF5, 0x0002, 0x000D, 0x0015, 0xFFFF, 0xFFEB, 0x0015, 0x0006,
    0x0007, 0x000C, 0x0008, 0xFFF7, 0x0032, 0x000B, 0xFFEA, 0x0024,
    0xFFE9, 0x0002, 0x001F, 0x0001, 0x0008, 0xFFF8, 0x000D, 0x0005,
    0x0008, 0xFFF1, 0x0003, 0xFFF4, 0x000C, 0xFFFB, 0xFFFC, 0xFFEA,
    0x0007, 0x0017, 0xFFF7, 0x0009, 0x0025, 0xFFD9, 0xFFDD, 0x0002,
    0xFFFC, 0x0011, 0xFFFE, 0xFFED, 0xFFE7, 0xFFEB, 0x0024, 0xFFF6,
    0x0009, 0xFFFE, 0x0019, 0xFFE3, 0x0035, 0x0010, 0x000E, 0xFFFD,
    0xFFEA, 0xFFF3, 0x0016, 0xFFEC, 0x0013, 0x0016, 0x000D, 0x0003,
    0xFFE2, 0x0003, 0xFFE0, 0x0003, 0xFFF3, 0xFFF6, 0x000E, 0xFFEC,
    0x0008, 0xFFF5, 0x0001, 0x0012, 0xFFFF, 0xFFFF, 0xFFD3, 0xFFEE,
    0x0006, 0x0005, 0x0009, 0xFFFD, 0xFFDF, 0xFFE7, 0xFFF9, 0xFFF7,
    0xFFFF, 0x000D, 0x001E, 0xFFEC, 0xFFF4, 0x000C, 0x0009, 0x0000,
    0xFFF5, 0xFFFA, 0x0016, 0x0004, 0xFFEC, 0x0032, 0x000A, 0x0001,
    0xFFFD, 0x0002, 0x0002, 0xFFFB, 0xFFFE, 0x000D, 0xFFE6, 0xFFE7,
    0xFFF9, 0x000A, 0xFFF9, 0xFFF2, 0x000C, 0x000A, 0x0005, 0x0000,
    0x000C, 0x0004, 0x001A, 0xFFF6, 0x0011, 0xFFF2, 0xFFF8, 0x0001,
    0xFFEA, 0x0015, 0xFFF9, 0xFFE5, 0xFFFE, 0x0000, 0xFFF0, 0x0017,
    0xFFED, 0x000F, 0x0018, 0xFFFC, 0x000F, 0xFFE7, 0x0001, 0x000B,
    0x0017, 0x000B, 0x0008, 0x000E, 0x000B, 0xFFF9, 0x0022, 0x0019,
    0x0001, 0x0001, 0x0025, 0x0006, 0x0010, 0x000C, 0x0002, 0xFFF4,
    0xFFEC, 0x0007, 0xFFE9, 0xFFF6, 0xFFFD, 0xFFFD, 0xFFF7, 0xFFFE,
    0xFFF4, 0xFFEF, 0x000A, 0x0005, 0x0006, 0xFFF8, 0xFFF3, 0xFFEC,
    0xFFFE, 0xFFF3, 0x0009, 0x000B, 0x000B, 0x0006, 0xFFE5, 0xFFDD,
    0x001B, 0xFFFF, 0x0003, 0xFFF0, 0xFFE4, 0xFFFD, 0xFFEE, 0x0025,
    0xFFF1, 0xFFF8, 0xFFF7, 0x0004, 0x0004, 0xFFFB, 0xFFE9, 0x0038,
    0x000A, 0xFFE9, 0x0012, 0xFFFB, 0x001D, 0xFFDF, 0xFFF1, 0xFFF6,
    0xFFFA, 0x0011, 0x0014, 0xFFF9, 0x0029, 0xFFFF, 0xFFF3, 0xFFFE,
    0x0004, 0xFFFA, 0x0024, 0x0005, 0x0030, 0x0018, 0xFFF4, 0x0012,
    0xFFF3, 0x002C, 0xFFDF, 0xFFF9, 0x000D, 0x0008, 0xFFF5, 0x0007,
    0x0008, 0x0006, 0xFFFC, 0xFFF5, 0x0003, 0x0021, 0x0010, 0x001D,
    0xFFEA, 0xFFF3, 0xFFFC, 0x0025, 0xFFF5, 0xFFFB, 0xFFD8, 0xFFEF,
    0x001A, 0xFFF1, 0xFFDE, 0xFFF5, 0xFFE6, 0xFFF6, 0xFFF2, 0x0024,
    0xFFFA, 0xFFF5, 0x000C, 0x001F, 0xFFF7, 0x000C, 0xFFF9, 0xFFEC,
    0x0003, 0xFFFF, 0xFFFE, 0xFFFA, 0x001D, 0xFFF6, 0xFFEC, 0x000F,
    0x0012, 0xFFE5, 0xFFF1, 0x0014, 0xFFF5, 0xFFF1, 0x000F, 0x0001,
    0xFFEA, 0xFFDE, 0x0009, 0x0019, 0x0015, 0x0002, 0x000F, 0xFFFB,
    0xFFF4, 0xFFE6, 0x0011, 0x0007, 0x0013, 0xFFF5, 0x0014, 0xFFF2,
    0xFFE1, 0x0009, 0x0027, 0xFFDF, 0x0002, 0xFFFE, 0x000A, 0x0017,
    0x001E, 0xFFFC, 0xFFE2, 0xFFEA, 0xFFDF, 0x001B, 0xFFDD, 0xFFF0,
    0xFFF0, 0x0010, 0x0005, 0xFFFA, 0x0004, 0x000B, 0x0001, 0x0002,
    0xFFF7, 0xFFF5, 0xFFF0, 0xFFF3, 0xFFFB, 0xFFF5, 0x0018, 0xFFF2,
    0xFFF4, 0xFFF1, 0x0001, 0x0027, 0x0009, 0xFFFB, 0x0003, 0xFFFB,
    0xFFFE, 0xFFE1, 0xFFEC, 0xFFFC, 0xFFE7, 0x000D, 0x001A, 0x0036,
    0x0017, 0x0013, 0x0003, 0x000A, 0xFFFE, 0x001A, 0xFFFE, 0x0005,
    0x0001, 0xFFF9, 0xFFFD, 0xFFFF, 0xFFFA, 0xFFF9, 0x0018, 0xFFF5,
    0x0013, 0x0011, 0x000A, 0xFFFE, 0xFFFE, 0x0004, 0xFFED, 0x000B,
    0x0014, 0x0006, 0x000C, 0xFFFD, 0xFFF5, 0x0004, 0x0012, 0xFFEE,
    0xFFFE, 0x0005, 0xFFF3, 0x0005, 0x0001, 0x0008, 0x000A, 0xFFFE,
    0xFFEB, 0xFFF3, 0x000D, 0xFFEA, 0x001C, 0xFFF7, 0x0011, 0x001B,
    0xFFF8, 0xFFE9, 0xFFF7, 0x0012, 0x0021, 0xFFFB, 0xFFF7, 0x0008,
    0xFFED, 0x0009, 0xFFFC, 0xFFF1, 0x0009, 0xFFFC, 0xFFF0, 0xFFF6,
    0x0004, 0x0012, 0x0007, 0x000E, 0xFFF9, 0xFFFF, 0x0016, 0x0005,
    0xFFEA, 0xFFF7, 0xFFF9, 0xFFEF, 0xFFF5, 0x0016, 0xFFF1, 0xFFFE,
    0xFFFE, 0x0019, 0xFFFC, 0x0001, 0x000B, 0xFFFE, 0x0002, 0xFFEC,
    0xFFF9, 0x000C, 0x0005, 0x0002, 0x0026, 0x0009, 0x0014, 0x000E,
    0x0005, 0xFFFC, 0x0005, 0x000D, 0xFFEF, 0xFFE1, 0x0021, 0xFFF8,
    0xFFFF, 0xFFF9, 0xFFF6, 0xFFF6, 0xFFF8, 0xFFFB, 0x0009, 0xFFFC,
    0xFFF0, 0x0009, 0x0010, 0xFFFF, 0x0005, 0x0010, 0x0001, 0xFFF6,
    0x0023, 0x000F, 0xFFF5, 0x0007, 0x0009, 0xFFF6, 0xFFF4, 0xFFFA,
    0xFFF1, 0xFFE8, 0x0007, 0x0016, 0xFFE3, 0xFFF8, 0x0007, 0xFFFD,
    0x0014, 0x0001, 0x0006, 0x0000, 0xFFF9, 0xFFCE, 0xFFFB, 0x0002,
    0x000F, 0x001B, 0x0000, 0x0008, 0xFFFC, 0x0028, 0x0017, 0x0026,
    0xFFFE, 0x000D, 0xFFE8, 0xFFF4, 0xFFFE, 0xFFE4, 0x0017, 0xFFE1,
    0x000A, 0x000A, 0xFFE9, 0xFFF3, 0x0012, 0x0012, 0x0001, 0x000D,
    0xFFED, 0xFFF7, 0x0008, 0xFFEB, 0xFFF5, 0x0004, 0x000C, 0x000E,
    0x0003, 0xFFE5, 0x0006, 0xFFFB, 0xFFF5, 0x0015, 0x0016, 0x0006,
    0x000B, 0x001D, 0x0019, 0x001C, 0xFFFA, 0x0018, 0xFFE5, 0x0003,
    0xFFE6, 0x0006, 0xFFFA, 0xFFFF, 0xFFED, 0x000D, 0xFFF1, 0x0008,
    0xFFFD, 0x000C, 0x0008, 0x0017, 0x0007, 0x000C, 0xFFFF, 0xFFF6,
    0x000D, 0x0008, 0x000B, 0xFFFA, 0xFFF8, 0xFFF0, 0xFFF0, 0x001C,
    0x001F, 0xFFFD, 0x000D, 0x0007, 0xFFFC, 0x0003, 0x0031, 0xFFFB,
    0xFFFB, 0xFFFC, 0xFFEF, 0x0000, 0xFFEA, 0xFFF0, 0x0031, 0xFFF8,
    0x000A, 0x0024, 0x002B, 0x002C, 0xFFF8, 0x000F, 0xFFE7, 0xFFD9,
    0xFFE9, 0x0014, 0xFFFC, 0x0006, 0x0006, 0xFFFE, 0xFFF8, 0xFFEA,
    0xFFF5, 0xFFF3, 0xFFF8, 0xFFF6, 0xFFF8, 0x0006, 0xFFF0, 0xFFEA,
    0x0020, 0x0000, 0xFFF2, 0x0001, 0x0001, 0xFFFD, 0xFFEF, 0xFFFB,
    0x000F, 0xFFF1, 0xFFF0, 0xFFFB, 0xFFF1, 0xFFFD, 0xFFFF, 0xFFFC,
    0xFFF5, 0x0005, 0x0008, 0x0003, 0x0009, 0x0015, 0xFFF4, 0xFFDD,
    0x002B, 0xFFE5, 0xFFF6, 0x0001, 0x000D, 0xFFEE, 0x0012, 0x000B,
    0x0001, 0x0016, 0x0018, 0x0010, 0x0004, 0xFFFA, 0x000B, 0x000B,
    0xFFFB, 0x0005, 0x0002, 0x000B, 0xFFFD, 0x000C, 0x0003, 0xFFDA,
    0x0000, 0xFFFE, 0xFFF0, 0x0003, 0xFFFD, 0x0005, 0x0004, 0x001A,
    0x001A, 0x0018, 0xFFF9, 0x0014, 0xFFFD, 0xFFEE, 0x0023, 0xFFF7,
    0x0012, 0xFFEE, 0x0017, 0x0007, 0x0004, 0xFFFA, 0xFFFB, 0xFFFD,
    0x000C, 0x0002, 0x0010, 0x001D, 0x0012, 0x0000, 0xFFEF, 0x0009,
    0x0005, 0x0010, 0xFFD5, 0xFFEA, 0xFFEE, 0xFFFC, 0x0004, 0x0014,
    0x002C, 0x000B, 0xFFE3, 0x0023, 0x0019, 0xFFF1, 0x0000, 0xFFFC,
    0xFFE4, 0xFFF6, 0x0016, 0xFFE3, 0xFFFA, 0x0004, 0xFFE8, 0x000B,
    0x000C, 0xFFEE, 0xFFE1, 0xFFEC, 0xFFFB, 0x0002, 0xFFF3, 0x0007,
    0xFFDA, 0x0013, 0xFFDF, 0x0005, 0xFFF2, 0x000E, 0xFFF7, 0x0000,
    0x0011, 0x0027, 0xFFFD, 0xFFED, 0x0002, 0xFFF8, 0x0020, 0x0017,
    0xFFF3, 0x000A, 0xFFED, 0xFFF8, 0xFFFC, 0x0003, 0x0007, 0x0017,
    0x0005, 0xFFEC, 0xFFED, 0xFFFD, 0xFFD9, 0xFFFE, 0xFFFE, 0xFFFD,
    0x000E, 0x0025, 0x0013, 0xFFF0, 0xFFF9, 0x000C, 0x001D, 0x0003,
    0x0000, 0x0017, 0x0007, 0xFFE3, 0xFFF4, 0xFFEA, 0xFFEE, 0x0004,
    0xFFF4, 0x0001, 0x0016, 0xFFF4, 0x0019, 0x000C, 0xFFF8, 0x0008,
    0x0006, 0xFFFD, 0xFFCE, 0xFFF5, 0x0006, 0x0016, 0x0017, 0xFFFF,
    0xFFFE, 0x0027, 0xFFEA, 0x0007, 0x0024, 0x001F, 0xFFF8, 0x002F,
    0xFFFE, 0xFFFF, 0x0018, 0x000E, 0xFFFB, 0x0005, 0x000A, 0x0003,
    0x000D, 0x0015, 0x0024, 0xFFF1, 0x001C, 0x000C, 0xFFF2, 0xFFFF,
    0xFFFA, 0x0015, 0xFFFA, 0x0003, 0xFFEC, 0xFFD2, 0x0006, 0x0000,
    0x000C, 0x0014, 0xFFF8, 0xFFFF, 0xFFF7, 0x000B, 0xFFE5, 0xFFF3,
    0xFFFA, 0x0002, 0x001B, 0xFFE3, 0x0018, 0x0004, 0x000A, 0xFFDE,
    0xFFFC, 0x0014, 0xFFF8, 0xFFE9, 0x000F, 0xFFFC, 0x0028, 0xFFE1,
    0x000D, 0x0003, 0xFFD7, 0xFFFD, 0xFFF2, 0x0003, 0x0002, 0xFFEB,
    0xFFDB, 0xFFF6, 0xFFF2, 0x0009, 0xFFE4, 0x0005, 0xFFFE, 0x001D,
    0x000A, 0x0005, 0xFFF5, 0xFFF8, 0xFFE3, 0x0000, 0xFFE8, 0xFFF9,
    0x0022, 0x000D, 0xFFEA, 0xFFFA, 0xFFEA, 0x0006, 0x0014, 0x0019,
    0xFFF2, 0xFFFF, 0xFFFD, 0x0000, 0xFFE6, 0xFFF1, 0xFFF7, 0x001C,
    0xFFF7, 0x0007, 0x0004, 0xFFF2, 0xFFFF, 0xFFFE, 0xFFF6, 0x0012,
    0x0016, 0x0005, 0xFFF3, 0x0009, 0xFFF8, 0xFFEA, 0x0003, 0xFFF3,
    0x0005, 0xFFF1, 0x0020, 0xFFF1, 0xFFF0, 0xFFFE, 0x0007, 0xFFFC,
    0x0010, 0xFFF3, 0x000C, 0xFFF9, 0xFFF7, 0x0022, 0xFFFA, 0x001B,
    0xFFF8, 0x0003, 0x0006, 0x0015, 0xFFED, 0xFFFF, 0x0010, 0xFFE3,
    0x000D, 0xFFEB, 0x0002, 0xFFEF, 0x0003, 0x0010, 0x001A, 0x0000,
    0x001D, 0xFFF9, 0xFFFB, 0x0016, 0x000A, 0xFFFC, 0x0002, 0xFFF3,
    0x0001, 0x0006, 0x000E, 0x0006, 0xFFE6, 0x0006, 0xFFFE, 0x0004,
    0xFFF9, 0x0004, 0xFFE6, 0xFFEE, 0x0008, 0xFFF4, 0x0007, 0xFFFD,
    0x001B, 0xFFF5, 0x0002, 0x0001, 0x000A, 0xFFE6, 0x0015, 0xFFFB,
    0xFFF7, 0x0003, 0xFFFC, 0x0013, 0xFFFD, 0xFFF3, 0x0015, 0xFFF2,
    0xFFFA, 0x0014, 0xFFF8, 0x0013, 0x0007, 0xFFFA, 0x0011, 0xFFE8,
    0x0013, 0x0007, 0xFFF7, 0xFFFB, 0x000D, 0xFFFF, 0xFFEA, 0xFFED,
    0xFFFB, 0x0022, 0x000E, 0xFFEF, 0x0002, 0xFFFA, 0xFFF3, 0xFFEF,
    0xFFFA, 0x0004, 0xFFF8, 0xFFFB, 0x0014, 0xFFF8, 0xFFFC, 0x000C,
    0x0007, 0xFFFA, 0xFFFE, 0xFFEB, 0xFFF8, 0x0001, 0x0006, 0x001D,
    0x0013, 0xFFF3, 0xFFF3, 0xFFF7, 0xFFFD, 0x000C, 0xFFFA, 0x0017,
    0xFFDF, 0x0007, 0x001E, 0xFFFF, 0xFFF5, 0xFFFF, 0xFFF9, 0xFFFB,
    0xFFFF, 0xFFFB, 0xFFE3, 0xFFFD, 0x0023, 0xFFF3, 0xFFE4, 0x0015,
    0x0008, 0xFFFC, 0x0003, 0xFFFB, 0xFFF4, 0xFFF5, 0xFFD4, 0x0002,
    0x0009, 0xFFFC, 0xFFF4, 0xFFE1, 0x000F, 0x000F, 0xFFF3, 0x0007,
    0x0004, 0x0002, 0xFFFC, 0xFFFA, 0xFFF9, 0xFFED, 0xFFFE, 0x0006,
    0xFFFC, 0x0001, 0xFFEA, 0xFFDD, 0x0007, 0x000A, 0xFFF8, 0x000D,
    0x0001, 0xFFEF, 0xFFEF, 0xFFDA, 0xFFFC, 0xFFE8, 0x000E, 0xFFE3,
    0xFFF5, 0x0003, 0xFFFF, 0x001A, 0x001B, 0x0002, 0x0005, 0x000E,
    0xFFFA, 0x0010, 0xFFF6, 0xFFF7, 0xFFEF, 0x0008, 0xFFF2, 0x0001,
    0x0004, 0xFFFE, 0x0012, 0x0002, 0x000E, 0x0001, 0x0003, 0xFFFE,
    0x0025, 0x0005, 0x0011, 0x0002, 0x0015, 0x000A, 0x001E, 0xFFFB,
    0x0001, 0x0005, 0x0011, 0xFFE4, 0xFFFD, 0xFFEB, 0xFFE2, 0x000B,
    0x0001, 0xFFF6, 0xFFE9, 0x0003, 0x0006, 0x0004, 0x000D, 0x000C,
    0x0022, 0x0026, 0x0024, 0x0018, 0xFFFD, 0xFFF0, 0x0009, 0x000D,
    0xFFFF, 0x001D, 0xFFED, 0x0013, 0xFFF0, 0xFFF7, 0x0002, 0x0004,
    0xFFE6, 0x0007, 0x000B, 0x0019, 0xFFE0, 0xFFFB, 0xFFF6, 0x0004,
    0xFFF8, 0x001A, 0xFFFB, 0xFFF6, 0x0008, 0xFFF8, 0xFFFE, 0x0013,
    0xFFF4, 0x0011, 0xFFDE, 0x000B, 0xFFF7, 0x0014, 0xFFE3, 0x0000,
    0xFFE9, 0x0002, 0x0013, 0x0010, 0xFFF4, 0x002E, 0xFFFB, 0x000A,
    0x0019, 0x0001, 0x0005, 0xFFE9, 0xFFF0, 0xFFF1, 0xFFFB, 0xFFF6,
    0x0002, 0xFFE5, 0xFFCC, 0xFFF1, 0xFFEE, 0xFFF3, 0x000C, 0x000B,
    0xFFEC, 0x0007, 0xFFF8, 0xFFDF, 0xFFF5, 0xFFF2, 0xFFFB, 0xFFE6,
    0x0007, 0x0008, 0x000C, 0xFFE1, 0xFFEB, 0x001B, 0x0024, 0xFFDC,
    0x0003, 0x0008, 0x000B, 0x0017, 0xFFEF, 0x000E, 0x0014, 0x001F,
    0x0002, 0xFFED, 0xFFEE, 0xFFFD, 0x0008, 0x0014, 0xFFF7, 0x0019,
    0x001C, 0x0007, 0xFFFF, 0xFFF0, 0xFFFF, 0xFFEA, 0xFFE0, 0xFFFA,
    0xFFFF, 0x0004, 0xFFFD, 0x000A, 0x001F, 0x0009, 0x000F, 0xFFEE,
    0x001D, 0xFFFE, 0x0005, 0x0003, 0xFFF6, 0x0015, 0xFFF3, 0xFFF4,
    0x001D, 0xFFFF, 0x0008, 0x001E, 0x000B, 0x0006, 0x0001, 0x0005,
    0x0016, 0xFFFC, 0xFFF1, 0xFFE8, 0x0017, 0x000B, 0x0016, 0x000D,
    0xFFFF, 0x0022, 0x0003, 0x0000, 0x0004, 0xFFFD, 0xFFF3, 0x0016,
    0xFFE4, 0x000F, 0xFFEB, 0xFFDE, 0x0012, 0x0023, 0xFFEB, 0xFFF5,
    0xFFE7, 0xFFED, 0xFFFB, 0xFFE9, 0x001C, 0xFFEC, 0xFFED, 0xFFD5,
    0x0006, 0x000A, 0xFFFA, 0xFFE5, 0xFFFA, 0xFFFA, 0xFFFF, 0x0003,
    0xFFFF, 0xFFF7, 0xFFFD, 0xFFEC, 0x0006, 0x0003, 0x0009, 0xFFFD,
    0x0026, 0xFFEC, 0xFFE0, 0xFFE4, 0xFFE5, 0x0023, 0xFFFB, 0x0015,
    0xFFD7, 0x000A, 0x0007, 0x0018, 0xFFFC, 0x0013, 0xFFEE, 0x0011,
    0xFFF7, 0xFFF4, 0x001C, 0x000C, 0x0013, 0x001A, 0xFFF3, 0x0003,
    0x000D, 0x0010, 0x0005, 0xFFEE, 0x0017, 0xFFFE, 0xFFF9, 0x0003,
    0x0011, 0x0001, 0x000E, 0x0009, 0x000F, 0x0009, 0xFFF8, 0xFFEF,
    0x0007, 0xFFEC, 0x0005, 0xFFEE, 0xFFD3, 0x000B, 0xFFFC, 0x0006,
    0xFFFB, 0x000B, 0x0018, 0xFFF0, 0xFFF2, 0x0014, 0xFFD8, 0x0004,
    0x000D, 0x002E, 0xFFEA, 0xFFE2, 0xFFF5, 0xFFF6, 0x0011, 0x000E,
    0xFFE8, 0x0000, 0xFFE8, 0x0012, 0x0018, 0xFFF8, 0x0010, 0x0003,
    0xFFFF, 0xFFFB, 0x000F, 0x000C, 0x000D, 0x000E, 0xFFF4, 0x000E,
    0xFFFF, 0x0003, 0xFFF7, 0x0015, 0xFFFE, 0xFFF8, 0xFFEB, 0xFFF7,
    0x0010, 0x000C, 0xFFF8, 0xFFFF, 0x0004, 0xFFE8, 0x0016, 0xFFF0,
    0xFFEB, 0x0010, 0xFFF9, 0x000F, 0x0001, 0x0006, 0x0003, 0xFFC8,
    0x0000, 0x0015, 0x0006, 0xFFF7, 0x0002, 0xFFEA, 0x0008, 0x000A,
    0xFFFA, 0xFFFD, 0x0009, 0x000C, 0xFFE1, 0x0001, 0xFFF7, 0x0001,
    0xFFDC, 0x000E, 0x001A, 0xFFF7, 0x0010, 0x000C, 0xFFDD, 0x0007,
    0x0009, 0x0005, 0xFFF8, 0x0011, 0x000E, 0x0007, 0xFFE6, 0x001C,
    0xFFE2, 0x001B, 0x0001, 0x0011, 0x0013, 0x0022, 0x0008, 0xFFED,
    0x0009, 0x0009, 0xFFFD, 0xFFFA, 0x0006, 0x001E, 0xFFFE, 0x0007,
    0x0000, 0xFFFA, 0x0021, 0x0019, 0x0005, 0xFFE9, 0xFFF2, 0xFFFE,
    0x0000, 0xFFEF, 0x0017, 0x0010, 0x003C, 0x000A, 0xFFDD, 0x0000,
    0x000F, 0x0019, 0xFFF9, 0x0001, 0x0012, 0x0013, 0x0016, 0x0001,
    0xFFDF, 0xFFE0, 0xFFDD, 0x000E, 0x001D, 0x0002, 0x000C, 0xFFF6,
    0x0010, 0xFFEF, 0x0013, 0xFFFE, 0x001C, 0xFFF2, 0x0007, 0xFFF4,
    0x000F, 0x0008, 0x001D, 0xFFF7, 0x0028, 0xFFF2, 0x0017, 0x0002,
    0xFFE4, 0x0006, 0x0008, 0xFFFF, 0xFFE7, 0x0000, 0xFFFE, 0xFFF5,
    0x0006, 0xFFFF, 0x001B, 0x000C, 0x000B, 0xFFFF, 0x000A, 0x000A,
    0xFFF1, 0xFFEA, 0x000E, 0x0012, 0xFFEE, 0x0012, 0xFFEF, 0xFFFE,
    0xFFE7, 0x0006, 0x0004, 0x0004, 0x0005, 0x0015, 0xFFF8, 0xFFFF,
    0xFFE2, 0xFFF7, 0xFFEA, 0xFFF3, 0x001D, 0xFFFB, 0x0011, 0xFFEC,
    0x0004, 0x000D, 0xFFFB, 0xFFEF, 0x001A, 0x0013, 0xFFFF, 0xFFF3,
    0x0008, 0x000B, 0xFFFB, 0x0000, 0x0009, 0xFFFC, 0xFFEE, 0x000A,
    0xFFF0, 0xFFF1, 0x0014, 0x0002, 0x0001, 0xFFD4, 0xFFFE, 0x002E,
    0x0011, 0x0004, 0x000D, 0x001B, 0x001A, 0x0008, 0x0001, 0xFFFF,
    0x0002, 0x0000, 0xFFFE, 0x001B, 0x0011, 0x0017, 0x000F, 0x0004,
    0xFFFE, 0x0009, 0xFFF8, 0xFFE9, 0x0001, 0x0011, 0x000D, 0x0009,
    0xFFFF, 0xFFF9, 0xFFF8, 0x0016, 0xFFDE, 0x000F, 0xFFF2, 0xFFF2,
    0xFFEA, 0xFFF4, 0xFFF8, 0xFFE3, 0xFFFD, 0xFFF5, 0xFFEC, 0xFFE9,
    0x000F, 0xFFFC, 0xFFF4, 0xFFEE, 0xFFE2, 0x0001, 0x0013, 0x0000,
    0x0014, 0xFFF8, 0x0004, 0xFFFB, 0xFFF5, 0xFFEA, 0x0013, 0xFFFF,
    0xFFFF, 0xFFE5, 0x0006, 0x0000, 0x000A, 0xFFF1, 0x0020, 0xFFE5,
    0x000F, 0xFFEF, 0xFFE6, 0xFFF5, 0xFFF8, 0xFFF7, 0x0019, 0xFFEE,
    0x0014, 0xFFF5, 0xFFEA, 0x0004, 0xFFFD, 0x0007, 0xFFF1, 0x0026,
    0xFFFD, 0xFFF8, 0x002B, 0x0006, 0x0016, 0x0024, 0x0014, 0xFFE1,
    0xFFEF, 0x0000, 0xFFE5, 0xFFDF, 0xFFF5, 0x0028, 0x0027, 0x000B,
    0xFFE4, 0x0005, 0xFFDC, 0xFFEF, 0xFFE5, 0xFFFB, 0x000A, 0xFFF8,
    0x0003, 0x001F, 0xFFFB, 0x0004, 0x0002, 0xFFF3, 0x001E, 0x000C,
    0x0003, 0xFFF0, 0xFFFF, 0xFFF7, 0xFFE7, 0x000A, 0x0000, 0xFFFE,
    0xFFEF, 0xFFE8, 0x001A, 0xFFF3, 0x000D, 0x001D, 0xFFF9, 0xFFF2,
    0x000D, 0x0002, 0xFFF4, 0x0022, 0xFFE8, 0x0001, 0xFFF9, 0xFFFD,
    0x0009, 0x0000, 0x0001, 0x000B, 0x0009, 0xFFF8, 0x0005, 0xFFEC,
    0x000A, 0xFFF7, 0xFFF6, 0xFFFB, 0xFFED, 0x0003, 0x001B, 0xFFFA,
    0xFFF2, 0xFFE8, 0xFFEC, 0xFFFC, 0xFFFB, 0x0024, 0xFFEC, 0xFFE3,
    0xFFFE, 0x001B, 0x001A, 0xFFE3, 0xFFEE, 0xFFF6, 0x0010, 0x000E,
    0xFFF9, 0xFFEF, 0x0010, 0x000F, 0x000C, 0x0015, 0xFFEC, 0x000C,
    0xFFEC, 0xFFFD, 0xFFE6, 0x0024, 0xFFF3, 0xFFFD, 0x000B, 0x0002,
    0x0004, 0xFFF5, 0x0014, 0x0006, 0x000B, 0x0020, 0xFFEC, 0xFFFD,
    0x0015, 0xFFEF, 0x0023, 0x000F, 0xFFF7, 0xFFEC, 0x000E, 0x0000,
    0xFFF0, 0x0011, 0xFFF2, 0x0007, 0x0020, 0xFFFE, 0x0002, 0x0020,
    0x0013, 0x0010, 0xFFF8, 0xFFFD, 0x001B, 0x0003, 0x0001, 0xFFDE,
    0x000F, 0xFFF4, 0x0006, 0x0011, 0x000D, 0x000B, 0x000B, 0x0021,
    0x0004, 0xFFF5, 0x0011, 0x0014, 0xFFFE, 0x0018, 0x002D, 0x0007,
    0xFFE5, 0xFFE5, 0xFFFD, 0xFFE7, 0x0005, 0x0012, 0x0014, 0xFFF9,
    0x0000, 0xFFE7, 0xFFF3, 0xFFF9, 0xFFC5, 0xFFF5, 0x0018, 0xFFEB,
    0x0020, 0xFFFA, 0x0003, 0x0004, 0xFFF1, 0x000A, 0xFFFD, 0xFFDB,
    0x0017, 0xFFF4, 0xFFF6, 0x0007, 0x0011, 0x0003, 0xFFF6, 0xFFFE,
    0x0009, 0x0012, 0x0022, 0x0011, 0xFFEE, 0x0010, 0x0014, 0xFFE6,
    0x000A, 0xFFED, 0x0008, 0xFFF9, 0x0019, 0x0028, 0x0005, 0xFFFF,
    0x0009, 0x000D, 0xFFF7, 0x000A, 0xFFE5, 0x0007, 0xFFF3, 0x0002,
    0xFFFA, 0x0015, 0x000C, 0xFFF7, 0x0004, 0xFFF2, 0x000B, 0xFFE4,
    0xFFF7, 0xFFFB, 0x0003, 0xFFF7, 0xFFE5, 0xFFE6, 0x000C, 0xFFED,
    0x000A, 0xFFE5, 0x000E, 0xFFFE, 0xFFFC, 0x0003, 0x0024, 0x0013,
    0xFFE5, 0xFFE8, 0x0010, 0xFFF9, 0xFFFE, 0x0020, 0xFFF5, 0xFFFC,
    0x001B, 0x000A, 0x0004, 0xFFFB, 0x001A, 0xFFF5, 0x001B, 0xFFEF,
    0xFFE1, 0x000C, 0xFFF5, 0xFFD9, 0xFFF5, 0x0015, 0xFFFF, 0x0013,
    0x0003, 0x0003, 0x0011, 0xFFEB, 0x0012, 0x000E, 0x0028, 0xFFF4,
    0xFFFD, 0xFFDE, 0x0006, 0xFFF7, 0x0001, 0xFFF7, 0xFFF1, 0xFFFF,
    0x0014, 0xFFF1, 0x000E, 0x0008, 0x0004, 0x001A, 0xFFFB, 0x0007,
    0x0011, 0xFFF9, 0x001D, 0xFFFF, 0x0004, 0xFFFF, 0x0001, 0x0020,
    0x0000, 0xFFF2, 0xFFFE, 0x0008, 0xFFDA, 0x0016, 0x000A, 0xFFE9,
    0x0016, 0xFFFF, 0x0012, 0x0003, 0x0011, 0x0000, 0x000C, 0xFFFC,
    0x0015, 0xFFEE, 0x0000, 0xFFF8, 0x001A, 0x0028, 0xFFFE, 0x001B,
    0x000A, 0x0000, 0xFFE0, 0x0014, 0x0018, 0x0000, 0xFFFD, 0xFFFB,
    0x0011, 0xFFF1, 0x0000, 0xFFE9, 0xFFED, 0xFFEA, 0xFFF5, 0xFFF8,
    0x0002, 0xFFE7, 0x000A, 0xFFEE, 0xFFF7, 0xFFF6, 0xFFF4, 0xFFDD,
    0x0023, 0xFFFA, 0x0020, 0x0020, 0xFFEC, 0xFFF0, 0xFFFB, 0xFFFC,
    0x000D, 0x000D, 0x0012, 0xFFF4, 0xFFF3, 0x000B, 0xFFFD, 0x0022,
    0x000F, 0x000A, 0xFFE7, 0xFFF4, 0x000E, 0xFFF0, 0x0018, 0x0023,
    0xFFEF, 0xFFEE, 0xFFF6, 0xFFFD, 0xFFEF, 0x0014, 0x0026, 0xFFFB,
    0x000A, 0x0004, 0xFFFC, 0x0012, 0x0008, 0x003F, 0xFFF6, 0x000C,
    0x0008, 0xFFF4, 0xFFEF, 0xFFFB, 0xFFF2, 0xFFFA, 0x001B, 0x0001,
    0xFFF6, 0x0017, 0x0003, 0x0024, 0xFFE7, 0x001B, 0xFFEF, 0x0007,
    0x001C, 0xFFF9, 0xFFFC, 0xFFD1, 0xFFEB, 0xFFFC, 0xFFE2, 0x0011,
    0xFFEB, 0x0003, 0xFFE2, 0xFFFE, 0xFFF9, 0xFFE8, 0xFFFA, 0x0019,
    0x000E, 0xFFFA, 0xFFF4, 0x000E, 0xFFF1, 0xFFFF, 0x0002, 0xFFE5,
    0x0005, 0x000F, 0xFFF0, 0xFFFD, 0x000C, 0xFFF5, 0xFFEF, 0x0002,
    0xFFF2, 0xFFF8, 0x0001, 0x0026, 0xFFEA, 0xFFF7, 0xFFEE, 0xFFFF,
    0x001B, 0x0004, 0xFFE0, 0x0000, 0xFFF1, 0x0006, 0xFFEC, 0xFFF6,
    0x0019, 0xFFFC, 0x0008, 0xFFF2, 0x0025, 0xFFF0, 0x000B, 0x0018,
    0x0025, 0xFFF2, 0xFFE3, 0x0019, 0x000E, 0xFFF9, 0x000A, 0x000F,
    0x0006, 0x001A, 0x0010, 0xFFF3, 0xFFEE, 0x0015, 0x0009, 0xFFF5,
    0x0008, 0x0001, 0xFFFF, 0xFFFC, 0xFFFE, 0x000A, 0x001C, 0xFFF7,
    0xFFEF, 0x0013, 0xFFDC, 0xFFF7, 0x0030, 0xFFFE, 0xFFE4, 0x002D,
    0xFFDA, 0xFFFA, 0xFFE0, 0xFFFC, 0xFFEF, 0xFFFC, 0x000E, 0x0002,
    0xFFF6, 0xFFE7, 0x000C, 0x001B, 0xFFF0, 0x0002, 0x0007, 0xFFF4,
    0x0005, 0xFFDE, 0x0018, 0xFFF7, 0xFFEE, 0xFFF9, 0xFFE9, 0xFFF1,
    0xFFE8, 0x0002, 0x0011, 0xFFF8, 0x000B, 0x000D, 0xFFEC, 0xFFF9,
    0xFFF3, 0xFFFD, 0x0014, 0x0015, 0x0001, 0xFFCA, 0xFFFD, 0x0016,
    0x000A, 0x0018, 0x0018, 0xFFE8, 0xFFE5, 0x0009, 0x0010, 0x001E,
    0x000B, 0x002D, 0x0000, 0x0029, 0xFFEF, 0x0007, 0x0024, 0xFFF5,
    0x000F, 0x0004, 0x0000, 0x0001, 0x000C, 0x0021, 0xFFF2, 0xFFE5,
    0xFFF7, 0x0010, 0x0001, 0x0007, 0x001D, 0x000A, 0xFFFF, 0xFFE7,
    0x0008, 0xFFF8, 0x0016, 0xFFF5, 0x0001, 0x001B, 0x0000, 0x000F,
    0x0005, 0xFFF9, 0xFFFA, 0xFFEF, 0xFFF7, 0x0014, 0xFFF8, 0xFFCA,
    0x0009, 0x0017, 0xFFF3, 0x0003, 0xFFF5, 0x0002, 0x000E, 0xFFF2,
    0x0010, 0x000C, 0x0007, 0x0002, 0xFFF2, 0x0003, 0xFFF0, 0xFFF5,
    0xFFFF, 0xFFF8, 0xFFF3, 0xFFFD, 0x0006, 0x0010, 0xFFF1, 0x000C,
    0x001C, 0xFFEF, 0xFFF4, 0xFFEF, 0x0009, 0x0008, 0x000C, 0xFFFF,
    0x0005, 0xFFF7, 0x001D, 0xFFF0, 0xFFF0, 0x0014, 0x0022, 0x0025,
    0xFFF0, 0xFFF2, 0xFFED, 0xFFFE, 0xFFFD, 0x0000, 0x0001, 0xFFF7,
    0xFFEC, 0x0005, 0x0009, 0xFFF3, 0x0001, 0xFFF9, 0xFFF6, 0xFFDE,
    0x0005, 0x000C, 0x0001, 0x0018, 0xFFEF, 0x0017, 0xFFFE, 0x0003,
    0xFFFC, 0xFFF6, 0xFFFF, 0x000D, 0x002F, 0xFFFA, 0x0027, 0x001F,
    0x0007, 0xFFF4, 0x0011, 0xFFF7, 0xFFEF, 0x0016, 0x0003, 0xFFF7,
    0x0011, 0x0011, 0x0007, 0xFFC6, 0x001E, 0xFFF8, 0xFFFB, 0x0007,
    0xFFF2, 0x000F, 0x0007, 0xFFFB, 0x0015, 0xFFF6, 0xFFF9, 0xFFE9,
    0xFFF0, 0x0010, 0xFFF3, 0xFFFB, 0x0015, 0xFFE6, 0xFFFC, 0xFFF3,
    0x0009, 0xFFE8, 0x0009, 0xFFD7, 0x0004, 0xFFD4, 0xFFFD, 0xFFFD,
    0x0009, 0x0004, 0x0005, 0xFFEE, 0x000B, 0x0010, 0x0026, 0xFFF1,
    0xFFDC, 0xFFFF, 0x0006, 0xFFED, 0x000F, 0xFFFB, 0xFFF6, 0x000D,
    0xFFFC, 0xFFFE, 0x000C, 0x000A, 0x000A, 0x002B, 0x0002, 0xFFEA,
    0x0006, 0xFFFC, 0x0002, 0x0005, 0x0003, 0x0001, 0xFFFF, 0xFFFF,
    0x0004, 0xFFF2, 0x0008, 0x002B, 0xFFD8, 0xFFF5, 0xFFF3, 0xFFF3,
    0x0007, 0x0020, 0x0014, 0xFFEF, 0xFFF2, 0xFFFC, 0x002C, 0xFFFB,
    0xFFD9, 0xFFF6, 0x000C, 0xFFE9, 0x0023, 0xFFF4, 0xFFFE, 0xFFFA,
    0xFFE1, 0x0014, 0xFFF4, 0x002A, 0x0012, 0x0007, 0xFFF2, 0x0004,
    0x0000, 0xFFE5, 0x002C, 0xFFF5, 0x0018, 0x0019, 0xFFE5, 0x0015,
    0xFFEF, 0x000B, 0x0012, 0x0014, 0xFFEF, 0x001D, 0xFFFF, 0xFFF6,
    0xFFFE, 0xFFF3, 0xFFFD, 0xFFEF, 0xFFFF, 0xFFFC, 0x0004, 0xFFE6,
    0x000E, 0xFFF9, 0x0000, 0xFFFC, 0x000F, 0xFFDD, 0x0010, 0x0014,
    0x0015, 0xFFEC, 0xFFF8, 0x0007, 0xFFF6, 0xFFF1, 0xFFF5, 0xFFE6,
    0xFFDE, 0xFFE0, 0xFFEA, 0xFFFC, 0x0004, 0x0000, 0xFFE7, 0xFFE2,
    0x0011, 0xFFEB, 0xFFE6, 0x0027, 0x0028, 0x0003, 0xFFF6, 0x0007,
    0x0016, 0xFFF6, 0x0006, 0x000C, 0xFFF4, 0x001D, 0x0005, 0xFFDE,
    0xFFE8, 0x0024, 0xFFFA, 0xFFF9, 0xFFFB, 0xFFF3, 0xFFEA, 0xFFF9,
    0x001B, 0xFFE2, 0xFFE2, 0x0004, 0x0013, 0x0017, 0xFFEF, 0x0010,
    0xFFFB, 0x000F, 0xFFDD, 0xFFFB, 0x0000, 0xFFF2, 0x001B, 0xFFFB,
    0x0016, 0x0012, 0x0010, 0x0015, 0x0012, 0x0000, 0x001F, 0xFFF7,
    0x0000, 0x0011, 0xFFF2, 0xFFEB, 0xFFF6, 0xFFF6, 0xFFFB, 0xFFFC,
    0xFFDF, 0x000A, 0x0003, 0x0018, 0xFFE9, 0x000C, 0x000A, 0xFFE7,
    0xFFF7, 0xFFF4, 0x000C, 0x0007, 0xFFEF, 0x0015, 0x0012, 0x000E,
    0xFFF9, 0xFFEF, 0xFFF3, 0x0014, 0xFFF9, 0xFFF6, 0xFFED, 0x0006,
    0xFFEE, 0xFFF9, 0xFFFF, 0x0003, 0xFFF7, 0xFFF4, 0xFFE6, 0x0007,
    0x0006, 0xFFF4, 0x0005, 0x0014, 0xFFED, 0xFFF8, 0xFFE6, 0xFFF5,
    0x000A, 0xFFF1, 0xFFEC, 0x0001, 0xFFFA, 0x0005, 0xFFF6, 0xFFF3,
    0x0010, 0xFFF1, 0x0002, 0xFFF5, 0xFFF3, 0x000F, 0xFFED, 0x0009,
    0xFFE8, 0xFFFD, 0xFFE9, 0x0003, 0xFFF4, 0xFFE1, 0xFFDE, 0x0011,
    0xFFEC, 0x0003, 0x0014, 0x0014, 0x0003, 0x0015, 0xFFFD, 0xFFFE,
    0xFFDF, 0xFFDD, 0x0011, 0x000F, 0x0007, 0x0012, 0xFFE8, 0x0006,
    0xFFF5, 0xFFFB, 0x0000, 0xFFEC, 0xFFF5, 0xFFE5, 0xFFFF, 0x0005,
    0x0004, 0x001F, 0x0011, 0x0022, 0x0010, 0x0001, 0xFFFC, 0xFFFE,
    0xFFEA, 0x000A, 0xFFE6, 0x0011, 0xFFF2, 0xFFEE, 0x0000, 0xFFEC,
    0x0006, 0x002D, 0xFFF4, 0xFFF0, 0xFFFD, 0xFFE1, 0x0003, 0xFFFD,
    0x000D, 0xFFF5, 0xFFEA, 0x0006, 0x0000, 0x0029, 0x0000, 0x0008,
    0xFFF4, 0xFFF2, 0xFFFE, 0x000E, 0xFFED, 0xFFE9, 0xFFF3, 0xFFF1,
    0x0006, 0xFFE9, 0x0001, 0xFFFF, 0x0004, 0x0009, 0xFFFF, 0x0009,
    0x0009, 0x0025, 0xFFF9, 0xFFF3, 0x000A, 0xFFF1, 0x000D, 0x0014,
    0x0017, 0xFFFE, 0x0008, 0x000D, 0x001F, 0xFFF5, 0x0005, 0x000B,
    0x0001, 0x0003, 0xFFFC, 0x0009, 0x0003, 0xFFE4, 0xFFEB, 0x000C,
    0x0024, 0x0002, 0x0005, 0x000D, 0x0019, 0x0012, 0x0018, 0xFFE2,
    0x0018, 0x001D, 0xFFF9, 0xFFFD, 0x0009, 0x0012, 0xFFE4, 0xFFFC,
    0xFFFE, 0xFFF7, 0xFFEB, 0xFFFA, 0xFFFA, 0xFFED, 0x0000, 0xFFF4,
    0xFFFE
    };

static const q15_t in_rfft_step_32[32] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333
    };

static const q15_t in_rifft_step_32[66] = {
    0x399A, 0x0000, 0xFC66, 0x248D, 0x0000, 0x0000, 0xFC66, 0x0BDE,
    0x0000, 0x0000, 0xFC66, 0x06BC, 0x0000, 0x0000, 0xFC66, 0x0463,
    0x0000, 0x0000, 0xFC66, 0x02F4, 0x0000, 0x0000, 0xFC66, 0x01ED,
    0x0000, 0x0000, 0xFC66, 0x0118, 0x0000, 0x0000, 0xFC66, 0x005B,
    0x0000, 0x0000, 0xFC66, 0xFFA5, 0x0000, 0x0000, 0xFC66, 0xFEE8,
    0x0000, 0x0000, 0xFC66, 0xFE13, 0x0000, 0x0000, 0xFC66, 0xFD0C,
    0x0000, 0x0000, 0xFC66, 0xFB9D, 0x0000, 0x0000, 0xFC66, 0xF944,
    0x0000, 0x0000, 0xFC66, 0xF422, 0x0000, 0x0000, 0xFC66, 0xDB73,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_step_32[33] = {
    0x399A, 0x0000, 0xFC66, 0x248D, 0x0000, 0x0000, 0xFC66, 0x0BDE,
    0x0000, 0x0000, 0xFC66, 0x06BC, 0x0000, 0x0000, 0xFC66, 0x0463,
    0x0000, 0x0000, 0xFC66, 0x02F4, 0x0000, 0x0000, 0xFC66, 0x01ED,
    0x0000, 0x0000, 0xFC66, 0x0118, 0x0000, 0x0000, 0xFC66, 0x005B,
    0x0000
    };

static const q15_t in_rfft_step_64[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333
    };

static const q15_t in_rifft_step_64[130] = {
    0x399A, 0x0000, 0xFE33, 0x24A4, 0x0000, 0x0000, 0xFE33, 0x0C22,
    0x0000, 0x0000, 0xFE33, 0x0730, 0x0000, 0x0000, 0xFE33, 0x0508,
    0x0000, 0x0000, 0xFE33, 0x03CE, 0x0000, 0x0000, 0xFE33, 0x0301,
    0x0000, 0x0000, 0xFE33, 0x026D, 0x0000, 0x0000, 0xFE33, 0x01FC,
    0x0000, 0x0000, 0xFE33, 0x01A2, 0x0000, 0x0000, 0xFE33, 0x0156,
    0x0000, 0x0000, 0xFE33, 0x0114, 0x0000, 0x0000, 0xFE33, 0x00DA,
    0x0000, 0x0000, 0xFE33, 0x00A5, 0x0000, 0x0000, 0xFE33, 0x0073,
    0x0000, 0x0000, 0xFE33, 0x0044, 0x0000, 0x0000, 0xFE33, 0x0017,
    0x0000, 0x0000, 0xFE33, 0xFFE9, 0x0000, 0x0000, 0xFE33, 0xFFBC,
    0x0000, 0x0000, 0xFE33, 0xFF8D, 0x0000, 0x0000, 0xFE33, 0xFF5B,
    0x0000, 0x0000, 0xFE33, 0xFF26, 0x0000, 0x0000, 0xFE33, 0xFEEC,
    0x0000, 0x0000, 0xFE33, 0xFEAA, 0x0000, 0x0000, 0xFE33, 0xFE5E,
    0x0000, 0x0000, 0xFE33, 0xFE04, 0x0000, 0x0000, 0xFE33, 0xFD93,
    0x0000, 0x0000, 0xFE33, 0xFCFF, 0x0000, 0x0000, 0xFE33, 0xFC32,
    0x0000, 0x0000, 0xFE33, 0xFAF8, 0x0000, 0x0000, 0xFE33, 0xF8D0,
    0x0000, 0x0000, 0xFE33, 0xF3DE, 0x0000, 0x0000, 0xFE33, 0xDB5C,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_step_64[65] = {
    0x399A, 0x0000, 0xFE33, 0x24A4, 0x0000, 0x0000, 0xFE33, 0x0C22,
    0x0000, 0x0000, 0xFE33, 0x0730, 0x0000, 0x0000, 0xFE33, 0x0508,
    0x0000, 0x0000, 0xFE33, 0x03CE, 0x0000, 0x0000, 0xFE33, 0x0301,
    0x0000, 0x0000, 0xFE33, 0x026D, 0x0000, 0x0000, 0xFE33, 0x01FC,
    0x0000, 0x0000, 0xFE33, 0x01A2, 0x0000, 0x0000, 0xFE33, 0x0156,
    0x0000, 0x0000, 0xFE33, 0x0114, 0x0000, 0x0000, 0xFE33, 0x00DA,
    0x0000, 0x0000, 0xFE33, 0x00A5, 0x0000, 0x0000, 0xFE33, 0x0073,
    0x0000, 0x0000, 0xFE33, 0x0044, 0x0000, 0x0000, 0xFE33, 0x0017,
    0x0000
    };

static const q15_t in_rfft_step_128[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333
    };

static const q15_t in_rifft_step_128[258] = {
    0x399A, 0x0000, 0xFF1A, 0x24A9, 0x0000, 0x0000, 0xFF1A, 0x0C33,
    0x0000, 0x0000, 0xFF1A, 0x074C, 0x0000, 0x0000, 0xFF1A, 0x0530,
    0x0000, 0x0000, 0xFF1A, 0x0402, 0x0000, 0x0000, 0xFF1A, 0x0341,
    0x0000, 0x0000, 0xFF1A, 0x02B9, 0x0000, 0x0000, 0xFF1A, 0x0255,
    0x0000, 0x0000, 0xFF1A, 0x0208, 0x0000, 0x0000, 0xFF1A, 0x01CA,
    0x0000, 0x0000, 0xFF1A, 0x0197, 0x0000, 0x0000, 0xFF1A, 0x016C,
    0x0000, 0x0000, 0xFF1A, 0x0147, 0x0000, 0x0000, 0xFF1A, 0x0127,
    0x0000, 0x0000, 0xFF1A, 0x010B, 0x0000, 0x0000, 0xFF1A, 0x00F2,
    0x0000, 0x0000, 0xFF1A, 0x00DB, 0x0000, 0x0000, 0xFF1A, 0x00C7,
    0x0000, 0x0000, 0xFF1A, 0x00B4, 0x0000, 0x0000, 0xFF1A, 0x00A2,
    0x0000, 0x0000, 0xFF1A, 0x0092, 0x0000, 0x0000, 0xFF1A, 0x0083,
    0x0000, 0x0000, 0xFF1A, 0x0074, 0x0000, 0x0000, 0xFF1A, 0x0066,
    0x0000, 0x0000, 0xFF1A, 0x0059, 0x0000, 0x0000, 0xFF1A, 0x004C,
    0x0000, 0x0000, 0xFF1A, 0x0040, 0x0000, 0x0000, 0xFF1A, 0x0034,
    0x0000, 0x0000, 0xFF1A, 0x0028, 0x0000, 0x0000, 0xFF1A, 0x001C,
    0x0000, 0x0000, 0xFF1A, 0x0011, 0x0000, 0x0000, 0xFF1A, 0x0006,
    0x0000, 0x0000, 0xFF1A, 0xFFFA, 0x0000, 0x0000, 0xFF1A, 0xFFEF,
    0x0000, 0x0000, 0xFF1A, 0xFFE4, 0x0000, 0x0000, 0xFF1A, 0xFFD8,
    0x0000, 0x0000, 0xFF1A, 0xFFCC, 0x0000, 0x0000, 0xFF1A, 0xFFC0,
    0x0000, 0x0000, 0xFF1A, 0xFFB4, 0x0000, 0x0000, 0xFF1A, 0xFFA7,
    0x0000, 0x0000, 0xFF1A, 0xFF9A, 0x0000, 0x0000, 0xFF1A, 0xFF8C,
    0x0000, 0x0000, 0xFF1A, 0xFF7D, 0x0000, 0x0000, 0xFF1A, 0xFF6E,
    0x0000, 0x0000, 0xFF1A, 0xFF5E, 0x0000, 0x0000, 0xFF1A, 0xFF4C,
    0x0000, 0x0000, 0xFF1A, 0xFF39, 0x0000, 0x0000, 0xFF1A, 0xFF25,
    0x0000, 0x0000, 0xFF1A, 0xFF0E, 0x0000, 0x0000, 0xFF1A, 0xFEF5,
    0x0000, 0x0000, 0xFF1A, 0xFED9, 0x0000, 0x0000, 0xFF1A, 0xFEB9,
    0x0000, 0x0000, 0xFF1A, 0xFE94, 0x0000, 0x0000, 0xFF1A, 0xFE69,
    0x0000, 0x0000, 0xFF1A, 0xFE36, 0x0000, 0x0000, 0xFF1A, 0xFDF8,
    0x0000, 0x0000, 0xFF1A, 0xFDAB, 0x0000, 0x0000, 0xFF1A, 0xFD47,
    0x0000, 0x0000, 0xFF1A, 0xFCBF, 0x0000, 0x0000, 0xFF1A, 0xFBFE,
    0x0000, 0x0000, 0xFF1A, 0xFAD0, 0x0000, 0x0000, 0xFF1A, 0xF8B4,
    0x0000, 0x0000, 0xFF1A, 0xF3CD, 0x0000, 0x0000, 0xFF1A, 0xDB57,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_step_128[129] = {
    0x399A, 0x0000, 0xFF1A, 0x24A9, 0x0000, 0x0000, 0xFF1A, 0x0C33,
    0x0000, 0x0000, 0xFF1A, 0x074C, 0x0000, 0x0000, 0xFF1A, 0x0530,
    0x0000, 0x0000, 0xFF1A, 0x0402, 0x0000, 0x0000, 0xFF1A, 0x0341,
    0x0000, 0x0000, 0xFF1A, 0x02B9, 0x0000, 0x0000, 0xFF1A, 0x0255,
    0x0000, 0x0000, 0xFF1A, 0x0208, 0x0000, 0x0000, 0xFF1A, 0x01CA,
    0x0000, 0x0000, 0xFF1A, 0x0197, 0x0000, 0x0000, 0xFF1A, 0x016C,
    0x0000, 0x0000, 0xFF1A, 0x0147, 0x0000, 0x0000, 0xFF1A, 0x0127,
    0x0000, 0x0000, 0xFF1A, 0x010B, 0x0000, 0x0000, 0xFF1A, 0x00F2,
    0x0000, 0x0000, 0xFF1A, 0x00DB, 0x0000, 0x0000, 0xFF1A, 0x00C7,
    0x0000, 0x0000, 0xFF1A, 0x00B4, 0x0000, 0x0000, 0xFF1A, 0x00A2,
    0x0000, 0x0000, 0xFF1A, 0x0092, 0x0000, 0x0000, 0xFF1A, 0x0083,
    0x0000, 0x0000, 0xFF1A, 0x0074, 0x0000, 0x0000, 0xFF1A, 0x0066,
    0x0000, 0x0000, 0xFF1A, 0x0059, 0x0000, 0x0000, 0xFF1A, 0x004C,
    0x0000, 0x0000, 0xFF1A, 0x0040, 0x0000, 0x0000, 0xFF1A, 0x0034,
    0x0000, 0x0000, 0xFF1A, 0x0028, 0x0000, 0x0000, 0xFF1A, 0x001C,
    0x0000, 0x0000, 0xFF1A, 0x0011, 0x0000, 0x0000, 0xFF1A, 0x0006,
    0x0000
    };

static const q15_t in_rfft_step_256[256] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333
    };

static const q15_t in_rifft_step_256[514] = {
    0x399A, 0x0000, 0xFF8D, 0x24AB, 0x0000, 0x0000, 0xFF8D, 0x0C38,
    0x0000, 0x0000, 0xFF8D, 0x0753, 0x0000, 0x0000, 0xFF8D, 0x053A,
    0x0000, 0x0000, 0xFF8D, 0x040F, 0x0000, 0x0000, 0xFF8D, 0x0350,
    0x0000, 0x0000, 0xFF8D, 0x02CC, 0x0000, 0x0000, 0xFF8D, 0x026B,
    0x0000, 0x0000, 0xFF8D, 0x0220, 0x0000, 0x0000, 0xFF8D, 0x01E5,
    0x0000, 0x0000, 0xFF8D, 0x01B5, 0x0000, 0x0000, 0xFF8D, 0x018D,
    0x0000, 0x0000, 0xFF8D, 0x016C, 0x0000, 0x0000, 0xFF8D, 0x014F,
    0x0000, 0x0000, 0xFF8D, 0x0136, 0x0000, 0x0000, 0xFF8D, 0x0120,
    0x0000, 0x0000, 0xFF8D, 0x010D, 0x0000, 0x0000, 0xFF8D, 0x00FC,
    0x0000, 0x0000, 0xFF8D, 0x00EC, 0x0000, 0x0000, 0xFF8D, 0x00DE,
    0x0000, 0x0000, 0xFF8D, 0x00D1, 0x0000, 0x0000, 0xFF8D, 0x00C6,
    0x0000, 0x0000, 0xFF8D, 0x00BB, 0x0000, 0x0000, 0xFF8D, 0x00B1,
    0x0000, 0x0000, 0xFF8D, 0x00A8, 0x0000, 0x0000, 0xFF8D, 0x009F,
    0x0000, 0x0000, 0xFF8D, 0x0097, 0x0000, 0x0000, 0xFF8D, 0x0090,
    0x0000, 0x0000, 0xFF8D, 0x0089, 0x0000, 0x0000, 0xFF8D, 0x0082,
    0x0000, 0x0000, 0xFF8D, 0x007C, 0x0000, 0x0000, 0xFF8D, 0x0076,
    0x0000, 0x0000, 0xFF8D, 0x0070, 0x0000, 0x0000, 0xFF8D, 0x006B,
    0x0000, 0x0000, 0xFF8D, 0x0066, 0x0000, 0x0000, 0xFF8D, 0x0061,
    0x0000, 0x0000, 0xFF8D, 0x005C, 0x0000, 0x0000, 0xFF8D, 0x0058,
    0x0000, 0x0000, 0xFF8D, 0x0053, 0x0000, 0x0000, 0xFF8D, 0x004F,
    0x0000, 0x0000, 0xFF8D, 0x004B, 0x0000, 0x0000, 0xFF8D, 0x0047,
    0x0000, 0x0000, 0xFF8D, 0x0043, 0x0000, 0x0000, 0xFF8D, 0x003F,
    0x0000, 0x0000, 0xFF8D, 0x003C, 0x0000, 0x0000, 0xFF8D, 0x0038,
    0x0000, 0x0000, 0xFF8D, 0x0035, 0x0000, 0x0000, 0xFF8D, 0x0031,
    0x0000, 0x0000, 0xFF8D, 0x002E, 0x0000, 0x0000, 0xFF8D, 0x002B,
    0x0000, 0x0000, 0xFF8D, 0x0028, 0x0000, 0x0000, 0xFF8D, 0x0024,
    0x0000, 0x0000, 0xFF8D, 0x0021, 0x0000, 0x0000, 0xFF8D, 0x001E,
    0x0000, 0x0000, 0xFF8D, 0x001B, 0x0000, 0x0000, 0xFF8D, 0x0018,
    0x0000, 0x0000, 0xFF8D, 0x0015, 0x0000, 0x0000, 0xFF8D, 0x0013,
    0x0000, 0x0000, 0xFF8D, 0x0010, 0x0000, 0x0000, 0xFF8D, 0x000D,
    0x0000, 0x0000, 0xFF8D, 0x000A, 0x0000, 0x0000, 0xFF8D, 0x0007,
    0x0000, 0x0000, 0xFF8D, 0x0004, 0x0000, 0x0000, 0xFF8D, 0x0001,
    0x0000, 0x0000, 0xFF8D, 0xFFFF, 0x0000, 0x0000, 0xFF8D, 0xFFFC,
    0x0000, 0x0000, 0xFF8D, 0xFFF9, 0x0000, 0x0000, 0xFF8D, 0xFFF6,
    0x0000, 0x0000, 0xFF8D, 0xFFF3, 0x0000, 0x0000, 0xFF8D, 0xFFF0,
    0x0000, 0x0000, 0xFF8D, 0xFFED, 0x0000, 0x0000, 0xFF8D, 0xFFEB,
    0x0000, 0x0000, 0xFF8D, 0xFFE8, 0x0000, 0x0000, 0xFF8D, 0xFFE5,
    0x0000, 0x0000, 0xFF8D, 0xFFE2, 0x0000, 0x0000, 0xFF8D, 0xFFDF,
    0x0000, 0x0000, 0xFF8D, 0xFFDC, 0x0000, 0x0000, 0xFF8D, 0xFFD8,
    0x0000, 0x0000, 0xFF8D, 0xFFD5, 0x0000, 0x0000, 0xFF8D, 0xFFD2,
    0x0000, 0x0000, 0xFF8D, 0xFFCF, 0x0000, 0x0000, 0xFF8D, 0xFFCB,
    0x0000, 0x0000, 0xFF8D, 0xFFC8, 0x0000, 0x0000, 0xFF8D, 0xFFC4,
    0x0000, 0x0000, 0xFF8D, 0xFFC1, 0x0000, 0x0000, 0xFF8D, 0xFFBD,
    0x0000, 0x0000, 0xFF8D, 0xFFB9, 0x0000, 0x0000, 0xFF8D, 0xFFB5,
    0x0000, 0x0000, 0xFF8D, 0xFFB1, 0x0000, 0x0000, 0xFF8D, 0xFFAD,
    0x0000, 0x0000, 0xFF8D, 0xFFA8, 0x0000, 0x0000, 0xFF8D, 0xFFA4,
    0x0000, 0x0000, 0xFF8D, 0xFF9F, 0x0000, 0x0000, 0xFF8D, 0xFF9A,
    0x0000, 0x0000, 0xFF8D, 0xFF95, 0x0000, 0x0000, 0xFF8D, 0xFF90,
    0x0000, 0x0000, 0xFF8D, 0xFF8A, 0x0000, 0x0000, 0xFF8D, 0xFF84,
    0x0000, 0x0000, 0xFF8D, 0xFF7E, 0x0000, 0x0000, 0xFF8D, 0xFF77,
    0x0000, 0x0000, 0xFF8D, 0xFF70, 0x0000, 0x0000, 0xFF8D, 0xFF69,
    0x0000, 0x0000, 0xFF8D, 0xFF61, 0x0000, 0x0000, 0xFF8D, 0xFF58,
    0x0000, 0x0000, 0xFF8D, 0xFF4F, 0x0000, 0x0000, 0xFF8D, 0xFF45,
    0x0000, 0x0000, 0xFF8D, 0xFF3A, 0x0000, 0x0000, 0xFF8D, 0xFF2F,
    0x0000, 0x0000, 0xFF8D, 0xFF22, 0x0000, 0x0000, 0xFF8D, 0xFF14,
    0x0000, 0x0000, 0xFF8D, 0xFF04, 0x0000, 0x0000, 0xFF8D, 0xFEF3,
    0x0000, 0x0000, 0xFF8D, 0xFEE0, 0x0000, 0x0000, 0xFF8D, 0xFECA,
    0x0000, 0x0000, 0xFF8D, 0xFEB1, 0x0000, 0x0000, 0xFF8D, 0xFE94,
    0x0000, 0x0000, 0xFF8D, 0xFE73, 0x0000, 0x0000, 0xFF8D, 0xFE4B,
    0x0000, 0x0000, 0xFF8D, 0xFE1B, 0x0000, 0x0000, 0xFF8D, 0xFDE0,
    0x0000, 0x0000, 0xFF8D, 0xFD95, 0x0000, 0x0000, 0xFF8D, 0xFD34,
    0x0000, 0x0000, 0xFF8D, 0xFCB0, 0x0000, 0x0000, 0xFF8D, 0xFBF1,
    0x0000, 0x0000, 0xFF8D, 0xFAC6, 0x0000, 0x0000, 0xFF8D, 0xF8AD,
    0x0000, 0x0000, 0xFF8D, 0xF3C8, 0x0000, 0x0000, 0xFF8D, 0xDB55,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_step_256[257] = {
    0x399A, 0x0000, 0xFF8D, 0x24AB, 0x0000, 0x0000, 0xFF8D, 0x0C38,
    0x0000, 0x0000, 0xFF8D, 0x0753, 0x0000, 0x0000, 0xFF8D, 0x053A,
    0x0000, 0x0000, 0xFF8D, 0x040F, 0x0000, 0x0000, 0xFF8D, 0x0350,
    0x0000, 0x0000, 0xFF8D, 0x02CC, 0x0000, 0x0000, 0xFF8D, 0x026B,
    0x0000, 0x0000, 0xFF8D, 0x0220, 0x0000, 0x0000, 0xFF8D, 0x01E5,
    0x0000, 0x0000, 0xFF8D, 0x01B5, 0x0000, 0x0000, 0xFF8D, 0x018D,
    0x0000, 0x0000, 0xFF8D, 0x016C, 0x0000, 0x0000, 0xFF8D, 0x014F,
    0x0000, 0x0000, 0xFF8D, 0x0136, 0x0000, 0x0000, 0xFF8D, 0x0120,
    0x0000, 0x0000, 0xFF8D, 0x010D, 0x0000, 0x0000, 0xFF8D, 0x00FC,
    0x0000, 0x0000, 0xFF8D, 0x00EC, 0x0000, 0x0000, 0xFF8D, 0x00DE,
    0x0000, 0x0000, 0xFF8D, 0x00D1, 0x0000, 0x0000, 0xFF8D, 0x00C6,
    0x0000, 0x0000, 0xFF8D, 0x00BB, 0x0000, 0x0000, 0xFF8D, 0x00B1,
    0x0000, 0x0000, 0xFF8D, 0x00A8, 0x0000, 0x0000, 0xFF8D, 0x009F,
    0x0000, 0x0000, 0xFF8D, 0x0097, 0x0000, 0x0000, 0xFF8D, 0x0090,
    0x0000, 0x0000, 0xFF8D, 0x0089, 0x0000, 0x0000, 0xFF8D, 0x0082,
    0x0000, 0x0000, 0xFF8D, 0x007C, 0x0000, 0x0000, 0xFF8D, 0x0076,
    0x0000, 0x0000, 0xFF8D, 0x0070, 0x0000, 0x0000, 0xFF8D, 0x006B,
    0x0000, 0x0000, 0xFF8D, 0x0066, 0x0000, 0x0000, 0xFF8D, 0x0061,
    0x0000, 0x0000, 0xFF8D, 0x005C, 0x0000, 0x0000, 0xFF8D, 0x0058,
    0x0000, 0x0000, 0xFF8D, 0x0053, 0x0000, 0x0000, 0xFF8D, 0x004F,
    0x0000, 0x0000, 0xFF8D, 0x004B, 0x0000, 0x0000, 0xFF8D, 0x0047,
    0x0000, 0x0000, 0xFF8D, 0x0043, 0x0000, 0x0000, 0xFF8D, 0x003F,
    0x0000, 0x0000, 0xFF8D, 0x003C, 0x0000, 0x0000, 0xFF8D, 0x0038,
    0x0000, 0x0000, 0xFF8D, 0x0035, 0x0000, 0x0000, 0xFF8D, 0x0031,
    0x0000, 0x0000, 0xFF8D, 0x002E, 0x0000, 0x0000, 0xFF8D, 0x002B,
    0x0000, 0x0000, 0xFF8D, 0x0028, 0x0000, 0x0000, 0xFF8D, 0x0024,
    0x0000, 0x0000, 0xFF8D, 0x0021, 0x0000, 0x0000, 0xFF8D, 0x001E,
    0x0000, 0x0000, 0xFF8D, 0x001B, 0x0000, 0x0000, 0xFF8D, 0x0018,
    0x0000, 0x0000, 0xFF8D, 0x0015, 0x0000, 0x0000, 0xFF8D, 0x0013,
    0x0000, 0x0000, 0xFF8D, 0x0010, 0x0000, 0x0000, 0xFF8D, 0x000D,
    0x0000, 0x0000, 0xFF8D, 0x000A, 0x0000, 0x0000, 0xFF8D, 0x0007,
    0x0000, 0x0000, 0xFF8D, 0x0004, 0x0000, 0x0000, 0xFF8D, 0x0001,
    0x0000
    };

static const q15_t in_rfft_step_512[512] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333
    };

static const q15_t in_rifft_step_512[1026] = {
    0x399A, 0x0000, 0xFFC6, 0x24AB, 0x0000, 0x0000, 0xFFC6, 0x0C39,
    0x0000, 0x0000, 0xFFC6, 0x0755, 0x0000, 0x0000, 0xFFC6, 0x053C,
    0x0000, 0x0000, 0xFFC6, 0x0412, 0x0000, 0x0000, 0xFFC6, 0x0354,
    0x0000, 0x0000, 0xFFC6, 0x02D1, 0x0000, 0x0000, 0xFFC6, 0x0270,
    0x0000, 0x0000, 0xFFC6, 0x0226, 0x0000, 0x0000, 0xFFC6, 0x01EC,
    0x0000, 0x0000, 0xFFC6, 0x01BD, 0x0000, 0x0000, 0xFFC6, 0x0195,
    0x0000, 0x0000, 0xFFC6, 0x0175, 0x0000, 0x0000, 0xFFC6, 0x0158,
    0x0000, 0x0000, 0xFFC6, 0x0140, 0x0000, 0x0000, 0xFFC6, 0x012B,
    0x0000, 0x0000, 0xFFC6, 0x0119, 0x0000, 0x0000, 0xFFC6, 0x0108,
    0x0000, 0x0000, 0xFFC6, 0x00F9, 0x0000, 0x0000, 0xFFC6, 0x00EC,
    0x0000, 0x0000, 0xFFC6, 0x00E0, 0x0000, 0x0000, 0xFFC6, 0x00D5,
    0x0000, 0x0000, 0xFFC6, 0x00CB, 0x0000, 0x0000, 0xFFC6, 0x00C2,
    0x0000, 0x0000, 0xFFC6, 0x00BA, 0x0000, 0x0000, 0xFFC6, 0x00B2,
    0x0000, 0x0000, 0xFFC6, 0x00AB, 0x0000, 0x0000, 0xFFC6, 0x00A4,
    0x0000, 0x0000, 0xFFC6, 0x009E, 0x0000, 0x0000, 0xFFC6, 0x0098,
    0x0000, 0x0000, 0xFFC6, 0x0093, 0x0000, 0x0000, 0xFFC6, 0x008E,
    0x0000, 0x0000, 0xFFC6, 0x0089, 0x0000, 0x0000, 0xFFC6, 0x0084,
    0x0000, 0x0000, 0xFFC6, 0x0080, 0x0000, 0x0000, 0xFFC6, 0x007C,
    0x0000, 0x0000, 0xFFC6, 0x0078, 0x0000, 0x0000, 0xFFC6, 0x0074,
    0x0000, 0x0000, 0xFFC6, 0x0071, 0x0000, 0x0000, 0xFFC6, 0x006D,
    0x0000, 0x0000, 0xFFC6, 0x006A, 0x0000, 0x0000, 0xFFC6, 0x0067,
    0x0000, 0x0000, 0xFFC6, 0x0064, 0x0000, 0x0000, 0xFFC6, 0x0061,
    0x0000, 0x0000, 0xFFC6, 0x005F, 0x0000, 0x0000, 0xFFC6, 0x005C,
    0x0000, 0x0000, 0xFFC6, 0x005A, 0x0000, 0x0000, 0xFFC6, 0x0057,
    0x0000, 0x0000, 0xFFC6, 0x0055, 0x0000, 0x0000, 0xFFC6, 0x0053,
    0x0000, 0x0000, 0xFFC6, 0x0051, 0x0000, 0x0000, 0xFFC6, 0x004F,
    0x0000, 0x0000, 0xFFC6, 0x004D, 0x0000, 0x0000, 0xFFC6, 0x004B,
    0x0000, 0x0000, 0xFFC6, 0x0049, 0x0000, 0x0000, 0xFFC6, 0x0047,
    0x0000, 0x0000, 0xFFC6, 0x0045, 0x0000, 0x0000, 0xFFC6, 0x0044,
    0x0000, 0x0000, 0xFFC6, 0x0042, 0x0000, 0x0000, 0xFFC6, 0x0040,
    0x0000, 0x0000, 0xFFC6, 0x003F, 0x0000, 0x0000, 0xFFC6, 0x003D,
    0x0000, 0x0000, 0xFFC6, 0x003C, 0x0000, 0x0000, 0xFFC6, 0x003A,
    0x0000, 0x0000, 0xFFC6, 0x0039, 0x0000, 0x0000, 0xFFC6, 0x0038,
    0x0000, 0x0000, 0xFFC6, 0x0036, 0x0000, 0x0000, 0xFFC6, 0x0035,
    0x0000, 0x0000, 0xFFC6, 0x0034, 0x0000, 0x0000, 0xFFC6, 0x0032,
    0x0000, 0x0000, 0xFFC6, 0x0031, 0x0000, 0x0000, 0xFFC6, 0x0030,
    0x0000, 0x0000, 0xFFC6, 0x002F, 0x0000, 0x0000, 0xFFC6, 0x002E,
    0x0000, 0x0000, 0xFFC6, 0x002C, 0x0000, 0x0000, 0xFFC6, 0x002B,
    0x0000, 0x0000, 0xFFC6, 0x002A, 0x0000, 0x0000, 0xFFC6, 0x0029,
    0x0000, 0x0000, 0xFFC6, 0x0028, 0x0000, 0x0000, 0xFFC6, 0x0027,
    0x0000, 0x0000, 0xFFC6, 0x0026, 0x0000, 0x0000, 0xFFC6, 0x0025,
    0x0000, 0x0000, 0xFFC6, 0x0024, 0x0000, 0x0000, 0xFFC6, 0x0023,
    0x0000, 0x0000, 0xFFC6, 0x0022, 0x0000, 0x0000, 0xFFC6, 0x0021,
    0x0000, 0x0000, 0xFFC6, 0x0020, 0x0000, 0x0000, 0xFFC6, 0x001F,
    0x0000, 0x0000, 0xFFC6, 0x001E, 0x0000, 0x0000, 0xFFC6, 0x001D,
    0x0000, 0x0000, 0xFFC6, 0x001D, 0x0000, 0x0000, 0xFFC6, 0x001C,
    0x0000, 0x0000, 0xFFC6, 0x001B, 0x0000, 0x0000, 0xFFC6, 0x001A,
    0x0000, 0x0000, 0xFFC6, 0x0019, 0x0000, 0x0000, 0xFFC6, 0x0018,
    0x0000, 0x0000, 0xFFC6, 0x0017, 0x0000, 0x0000, 0xFFC6, 0x0017,
    0x0000, 0x0000, 0xFFC6, 0x0016, 0x0000, 0x0000, 0xFFC6, 0x0015,
    0x0000, 0x0000, 0xFFC6, 0x0014, 0x0000, 0x0000, 0xFFC6, 0x0013,
    0x0000, 0x0000, 0xFFC6, 0x0013, 0x0000, 0x0000, 0xFFC6, 0x0012,
    0x0000, 0x0000, 0xFFC6, 0x0011, 0x0000, 0x0000, 0xFFC6, 0x0010,
    0x0000, 0x0000, 0xFFC6, 0x0010, 0x0000, 0x0000, 0xFFC6, 0x000F,
    0x0000, 0x0000, 0xFFC6, 0x000E, 0x0000, 0x0000, 0xFFC6, 0x000D,
    0x0000, 0x0000, 0xFFC6, 0x000D, 0x0000, 0x0000, 0xFFC6, 0x000C,
    0x0000, 0x0000, 0xFFC6, 0x000B, 0x0000, 0x0000, 0xFFC6, 0x000A,
    0x0000, 0x0000, 0xFFC6, 0x000A, 0x0000, 0x0000, 0xFFC6, 0x0009,
    0x0000, 0x0000, 0xFFC6, 0x0008, 0x0000, 0x0000, 0xFFC6, 0x0007,
    0x0000, 0x0000, 0xFFC6, 0x0007, 0x0000, 0x0000, 0xFFC6, 0x0006,
    0x0000, 0x0000, 0xFFC6, 0x0005, 0x0000, 0x0000, 0xFFC6, 0x0005,
    0x0000, 0x0000, 0xFFC6, 0x0004, 0x0000, 0x0000, 0xFFC6, 0x0003,
    0x0000, 0x0000, 0xFFC6, 0x0002, 0x0000, 0x0000, 0xFFC6, 0x0002,
    0x0000, 0x0000, 0xFFC6, 0x0001, 0x0000, 0x0000, 0xFFC6, 0x0000,
    0x0000, 0x0000, 0xFFC6, 0x0000, 0x0000, 0x0000, 0xFFC6, 0xFFFF,
    0x0000, 0x0000, 0xFFC6, 0xFFFE, 0x0000, 0x0000, 0xFFC6, 0xFFFE,
    0x0000, 0x0000, 0xFFC6, 0xFFFD, 0x0000, 0x0000, 0xFFC6, 0xFFFC,
    0x0000, 0x0000, 0xFFC6, 0xFFFB, 0x0000, 0x0000, 0xFFC6, 0xFFFB,
    0x0000, 0x0000, 0xFFC6, 0xFFFA, 0x0000, 0x0000, 0xFFC6, 0xFFF9,
    0x0000, 0x0000, 0xFFC6, 0xFFF9, 0x0000, 0x0000, 0xFFC6, 0xFFF8,
    0x0000, 0x0000, 0xFFC6, 0xFFF7, 0x0000, 0x0000, 0xFFC6, 0xFFF6,
    0x0000, 0x0000, 0xFFC6, 0xFFF6, 0x0000, 0x0000, 0xFFC6, 0xFFF5,
    0x0000, 0x0000, 0xFFC6, 0xFFF4, 0x0000, 0x0000, 0xFFC6, 0xFFF3,
    0x0000, 0x0000, 0xFFC6, 0xFFF3, 0x0000, 0x0000, 0xFFC6, 0xFFF2,
    0x0000, 0x0000, 0xFFC6, 0xFFF1, 0x0000, 0x0000, 0xFFC6, 0xFFF0,
    0x0000, 0x0000, 0xFFC6, 0xFFF0, 0x0000, 0x0000, 0xFFC6, 0xFFEF,
    0x0000, 0x0000, 0xFFC6, 0xFFEE, 0x0000, 0x0000, 0xFFC6, 0xFFED,
    0x0000, 0x0000, 0xFFC6, 0xFFED, 0x0000, 0x0000, 0xFFC6, 0xFFEC,
    0x0000, 0x0000, 0xFFC6, 0xFFEB, 0x0000, 0x0000, 0xFFC6, 0xFFEA,
    0x0000, 0x0000, 0xFFC6, 0xFFE9, 0x0000, 0x0000, 0xFFC6, 0xFFE9,
    0x0000, 0x0000, 0xFFC6, 0xFFE8, 0x0000, 0x0000, 0xFFC6, 0xFFE7,
    0x0000, 0x0000, 0xFFC6, 0xFFE6, 0x0000, 0x0000, 0xFFC6, 0xFFE5,
    0x0000, 0x0000, 0xFFC6, 0xFFE4, 0x0000, 0x0000, 0xFFC6, 0xFFE3,
    0x0000, 0x0000, 0xFFC6, 0xFFE3, 0x0000, 0x0000, 0xFFC6, 0xFFE2,
    0x0000, 0x0000, 0xFFC6, 0xFFE1, 0x0000, 0x0000, 0xFFC6, 0xFFE0,
    0x0000, 0x0000, 0xFFC6, 0xFFDF, 0x0000, 0x0000, 0xFFC6, 0xFFDE,
    0x0000, 0x0000, 0xFFC6, 0xFFDD, 0x0000, 0x0000, 0xFFC6, 0xFFDC,
    0x0000, 0x0000, 0xFFC6, 0xFFDB, 0x0000, 0x0000, 0xFFC6, 0xFFDA,
    0x0000, 0x0000, 0xFFC6, 0xFFD9, 0x0000, 0x0000, 0xFFC6, 0xFFD8,
    0x0000, 0x0000, 0xFFC6, 0xFFD7, 0x0000, 0x0000, 0xFFC6, 0xFFD6,
    0x0000, 0x0000, 0xFFC6, 0xFFD5, 0x0000, 0x0000, 0xFFC6, 0xFFD4,
    0x0000, 0x0000, 0xFFC6, 0xFFD2, 0x0000, 0x0000, 0xFFC6, 0xFFD1,
    0x0000, 0x0000, 0xFFC6, 0xFFD0, 0x0000, 0x0000, 0xFFC6, 0xFFCF,
    0x0000, 0x0000, 0xFFC6, 0xFFCE, 0x0000, 0x0000, 0xFFC6, 0xFFCC,
    0x0000, 0x0000, 0xFFC6, 0xFFCB, 0x0000, 0x0000, 0xFFC6, 0xFFCA,
    0x0000, 0x0000, 0xFFC6, 0xFFC8, 0x0000, 0x0000, 0xFFC6, 0xFFC7,
    0x0000, 0x0000, 0xFFC6, 0xFFC6, 0x0000, 0x0000, 0xFFC6, 0xFFC4,
    0x0000, 0x0000, 0xFFC6, 0xFFC3, 0x0000, 0x0000, 0xFFC6, 0xFFC1,
    0x0000, 0x0000, 0xFFC6, 0xFFC0, 0x0000, 0x0000, 0xFFC6, 0xFFBE,
    0x0000, 0x0000, 0xFFC6, 0xFFBC, 0x0000, 0x0000, 0xFFC6, 0xFFBB,
    0x0000, 0x0000, 0xFFC6, 0xFFB9, 0x0000, 0x0000, 0xFFC6, 0xFFB7,
    0x0000, 0x0000, 0xFFC6, 0xFFB5, 0x0000, 0x0000, 0xFFC6, 0xFFB3,
    0x0000, 0x0000, 0xFFC6, 0xFFB1, 0x0000, 0x0000, 0xFFC6, 0xFFAF,
    0x0000, 0x0000, 0xFFC6, 0xFFAD, 0x0000, 0x0000, 0xFFC6, 0xFFAB,
    0x0000, 0x0000, 0xFFC6, 0xFFA9, 0x0000, 0x0000, 0xFFC6, 0xFFA6,
    0x0000, 0x0000, 0xFFC6, 0xFFA4, 0x0000, 0x0000, 0xFFC6, 0xFFA1,
    0x0000, 0x0000, 0xFFC6, 0xFF9F, 0x0000, 0x0000, 0xFFC6, 0xFF9C,
    0x0000, 0x0000, 0xFFC6, 0xFF99, 0x0000, 0x0000, 0xFFC6, 0xFF96,
    0x0000, 0x0000, 0xFFC6, 0xFF93, 0x0000, 0x0000, 0xFFC6, 0xFF8F,
    0x0000, 0x0000, 0xFFC6, 0xFF8C, 0x0000, 0x0000, 0xFFC6, 0xFF88,
    0x0000, 0x0000, 0xFFC6, 0xFF84, 0x0000, 0x0000, 0xFFC6, 0xFF80,
    0x0000, 0x0000, 0xFFC6, 0xFF7C, 0x0000, 0x0000, 0xFFC6, 0xFF77,
    0x0000, 0x0000, 0xFFC6, 0xFF72, 0x0000, 0x0000, 0xFFC6, 0xFF6D,
    0x0000, 0x0000, 0xFFC6, 0xFF68, 0x0000, 0x0000, 0xFFC6, 0xFF62,
    0x0000, 0x0000, 0xFFC6, 0xFF5C, 0x0000, 0x0000, 0xFFC6, 0xFF55,
    0x0000, 0x0000, 0xFFC6, 0xFF4E, 0x0000, 0x0000, 0xFFC6, 0xFF46,
    0x0000, 0x0000, 0xFFC6, 0xFF3E, 0x0000, 0x0000, 0xFFC6, 0xFF35,
    0x0000, 0x0000, 0xFFC6, 0xFF2B, 0x0000, 0x0000, 0xFFC6, 0xFF20,
    0x0000, 0x0000, 0xFFC6, 0xFF14, 0x0000, 0x0000, 0xFFC6, 0xFF07,
    0x0000, 0x0000, 0xFFC6, 0xFEF8, 0x0000, 0x0000, 0xFFC6, 0xFEE7,
    0x0000, 0x0000, 0xFFC6, 0xFED5, 0x0000, 0x0000, 0xFFC6, 0xFEC0,
    0x0000, 0x0000, 0xFFC6, 0xFEA8, 0x0000, 0x0000, 0xFFC6, 0xFE8B,
    0x0000, 0x0000, 0xFFC6, 0xFE6B, 0x0000, 0x0000, 0xFFC6, 0xFE43,
    0x0000, 0x0000, 0xFFC6, 0xFE14, 0x0000, 0x0000, 0xFFC6, 0xFDDA,
    0x0000, 0x0000, 0xFFC6, 0xFD90, 0x0000, 0x0000, 0xFFC6, 0xFD2F,
    0x0000, 0x0000, 0xFFC6, 0xFCAC, 0x0000, 0x0000, 0xFFC6, 0xFBEE,
    0x0000, 0x0000, 0xFFC6, 0xFAC4, 0x0000, 0x0000, 0xFFC6, 0xF8AB,
    0x0000, 0x0000, 0xFFC6, 0xF3C7, 0x0000, 0x0000, 0xFFC6, 0xDB55,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_step_512[513] = {
    0x399A, 0x0000, 0xFFC6, 0x24AB, 0x0000, 0x0000, 0xFFC6, 0x0C39,
    0x0000, 0x0000, 0xFFC6, 0x0755, 0x0000, 0x0000, 0xFFC6, 0x053C,
    0x0000, 0x0000, 0xFFC6, 0x0412, 0x0000, 0x0000, 0xFFC6, 0x0354,
    0x0000, 0x0000, 0xFFC6, 0x02D1, 0x0000, 0x0000, 0xFFC6, 0x0270,
    0x0000, 0x0000, 0xFFC6, 0x0226, 0x0000, 0x0000, 0xFFC6, 0x01EC,
    0x0000, 0x0000, 0xFFC6, 0x01BD, 0x0000, 0x0000, 0xFFC6, 0x0195,
    0x0000, 0x0000, 0xFFC6, 0x0175, 0x0000, 0x0000, 0xFFC6, 0x0158,
    0x0000, 0x0000, 0xFFC6, 0x0140, 0x0000, 0x0000, 0xFFC6, 0x012B,
    0x0000, 0x0000, 0xFFC6, 0x0119, 0x0000, 0x0000, 0xFFC6, 0x0108,
    0x0000, 0x0000, 0xFFC6, 0x00F9, 0x0000, 0x0000, 0xFFC6, 0x00EC,
    0x0000, 0x0000, 0xFFC6, 0x00E0, 0x0000, 0x0000, 0xFFC6, 0x00D5,
    0x0000, 0x0000, 0xFFC6, 0x00CB, 0x0000, 0x0000, 0xFFC6, 0x00C2,
    0x0000, 0x0000, 0xFFC6, 0x00BA, 0x0000, 0x0000, 0xFFC6, 0x00B2,
    0x0000, 0x0000, 0xFFC6, 0x00AB, 0x0000, 0x0000, 0xFFC6, 0x00A4,
    0x0000, 0x0000, 0xFFC6, 0x009E, 0x0000, 0x0000, 0xFFC6, 0x0098,
    0x0000, 0x0000, 0xFFC6, 0x0093, 0x0000, 0x0000, 0xFFC6, 0x008E,
    0x0000, 0x0000, 0xFFC6, 0x0089, 0x0000, 0x0000, 0xFFC6, 0x0084,
    0x0000, 0x0000, 0xFFC6, 0x0080, 0x0000, 0x0000, 0xFFC6, 0x007C,
    0x0000, 0x0000, 0xFFC6, 0x0078, 0x0000, 0x0000, 0xFFC6, 0x0074,
    0x0000, 0x0000, 0xFFC6, 0x0071, 0x0000, 0x0000, 0xFFC6, 0x006D,
    0x0000, 0x0000, 0xFFC6, 0x006A, 0x0000, 0x0000, 0xFFC6, 0x0067,
    0x0000, 0x0000, 0xFFC6, 0x0064, 0x0000, 0x0000, 0xFFC6, 0x0061,
    0x0000, 0x0000, 0xFFC6, 0x005F, 0x0000, 0x0000, 0xFFC6, 0x005C,
    0x0000, 0x0000, 0xFFC6, 0x005A, 0x0000, 0x0000, 0xFFC6, 0x0057,
    0x0000, 0x0000, 0xFFC6, 0x0055, 0x0000, 0x0000, 0xFFC6, 0x0053,
    0x0000, 0x0000, 0xFFC6, 0x0051, 0x0000, 0x0000, 0xFFC6, 0x004F,
    0x0000, 0x0000, 0xFFC6, 0x004D, 0x0000, 0x0000, 0xFFC6, 0x004B,
    0x0000, 0x0000, 0xFFC6, 0x0049, 0x0000, 0x0000, 0xFFC6, 0x0047,
    0x0000, 0x0000, 0xFFC6, 0x0045, 0x0000, 0x0000, 0xFFC6, 0x0044,
    0x0000, 0x0000, 0xFFC6, 0x0042, 0x0000, 0x0000, 0xFFC6, 0x0040,
    0x0000, 0x0000, 0xFFC6, 0x003F, 0x0000, 0x0000, 0xFFC6, 0x003D,
    0x0000, 0x0000, 0xFFC6, 0x003C, 0x0000, 0x0000, 0xFFC6, 0x003A,
    0x0000, 0x0000, 0xFFC6, 0x0039, 0x0000, 0x0000, 0xFFC6, 0x0038,
    0x0000, 0x0000, 0xFFC6, 0x0036, 0x0000, 0x0000, 0xFFC6, 0x0035,
    0x0000, 0x0000, 0xFFC6, 0x0034, 0x0000, 0x0000, 0xFFC6, 0x0032,
    0x0000, 0x0000, 0xFFC6, 0x0031, 0x0000, 0x0000, 0xFFC6, 0x0030,
    0x0000, 0x0000, 0xFFC6, 0x002F, 0x0000, 0x0000, 0xFFC6, 0x002E,
    0x0000, 0x0000, 0xFFC6, 0x002C, 0x0000, 0x0000, 0xFFC6, 0x002B,
    0x0000, 0x0000, 0xFFC6, 0x002A, 0x0000, 0x0000, 0xFFC6, 0x0029,
    0x0000, 0x0000, 0xFFC6, 0x0028, 0x0000, 0x0000, 0xFFC6, 0x0027,
    0x0000, 0x0000, 0xFFC6, 0x0026, 0x0000, 0x0000, 0xFFC6, 0x0025,
    0x0000, 0x0000, 0xFFC6, 0x0024, 0x0000, 0x0000, 0xFFC6, 0x0023,
    0x0000, 0x0000, 0xFFC6, 0x0022, 0x0000, 0x0000, 0xFFC6, 0x0021,
    0x0000, 0x0000, 0xFFC6, 0x0020, 0x0000, 0x0000, 0xFFC6, 0x001F,
    0x0000, 0x0000, 0xFFC6, 0x001E, 0x0000, 0x0000, 0xFFC6, 0x001D,
    0x0000, 0x0000, 0xFFC6, 0x001D, 0x0000, 0x0000, 0xFFC6, 0x001C,
    0x0000, 0x0000, 0xFFC6, 0x001B, 0x0000, 0x0000, 0xFFC6, 0x001A,
    0x0000, 0x0000, 0xFFC6, 0x0019, 0x0000, 0x0000, 0xFFC6, 0x0018,
    0x0000, 0x0000, 0xFFC6, 0x0017, 0x0000, 0x0000, 0xFFC6, 0x0017,
    0x0000, 0x0000, 0xFFC6, 0x0016, 0x0000, 0x0000, 0xFFC6, 0x0015,
    0x0000, 0x0000, 0xFFC6, 0x0014, 0x0000, 0x0000, 0xFFC6, 0x0013,
    0x0000, 0x0000, 0xFFC6, 0x0013, 0x0000, 0x0000, 0xFFC6, 0x0012,
    0x0000, 0x0000, 0xFFC6, 0x0011, 0x0000, 0x0000, 0xFFC6, 0x0010,
    0x0000, 0x0000, 0xFFC6, 0x0010, 0x0000, 0x0000, 0xFFC6, 0x000F,
    0x0000, 0x0000, 0xFFC6, 0x000E, 0x0000, 0x0000, 0xFFC6, 0x000D,
    0x0000, 0x0000, 0xFFC6, 0x000D, 0x0000, 0x0000, 0xFFC6, 0x000C,
    0x0000, 0x0000, 0xFFC6, 0x000B, 0x0000, 0x0000, 0xFFC6, 0x000A,
    0x0000, 0x0000, 0xFFC6, 0x000A, 0x0000, 0x0000, 0xFFC6, 0x0009,
    0x0000, 0x0000, 0xFFC6, 0x0008, 0x0000, 0x0000, 0xFFC6, 0x0007,
    0x0000, 0x0000, 0xFFC6, 0x0007, 0x0000, 0x0000, 0xFFC6, 0x0006,
    0x0000, 0x0000, 0xFFC6, 0x0005, 0x0000, 0x0000, 0xFFC6, 0x0005,
    0x0000, 0x0000, 0xFFC6, 0x0004, 0x0000, 0x0000, 0xFFC6, 0x0003,
    0x0000, 0x0000, 0xFFC6, 0x0002, 0x0000, 0x0000, 0xFFC6, 0x0002,
    0x0000, 0x0000, 0xFFC6, 0x0001, 0x0000, 0x0000, 0xFFC6, 0x0000,
    0x0000
    };

static const q15_t in_rfft_step_1024[1024] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333
    };

static const q15_t in_rifft_step_1024[2050] = {
    0x399A, 0x0000, 0xFFE3, 0x24AB, 0x0000, 0x0000, 0xFFE3, 0x0C39,
    0x0000, 0x0000, 0xFFE3, 0x0755, 0x0000, 0x0000, 0xFFE3, 0x053D,
    0x0000, 0x0000, 0xFFE3, 0x0413, 0x0000, 0x0000, 0xFFE3, 0x0355,
    0x0000, 0x0000, 0xFFE3, 0x02D2, 0x0000, 0x0000, 0xFFE3, 0x0271,
    0x0000, 0x0000, 0xFFE3, 0x0228, 0x0000, 0x0000, 0xFFE3, 0x01EE,
    0x0000, 0x0000, 0xFFE3, 0x01BE, 0x0000, 0x0000, 0xFFE3, 0x0197,
    0x0000, 0x0000, 0xFFE3, 0x0177, 0x0000, 0x0000, 0xFFE3, 0x015B,
    0x0000, 0x0000, 0xFFE3, 0x0143, 0x0000, 0x0000, 0xFFE3, 0x012E,
    0x0000, 0x0000, 0xFFE3, 0x011B, 0x0000, 0x0000, 0xFFE3, 0x010B,
    0x0000, 0x0000, 0xFFE3, 0x00FD, 0x0000, 0x0000, 0xFFE3, 0x00F0,
    0x0000, 0x0000, 0xFFE3, 0x00E4, 0x0000, 0x0000, 0xFFE3, 0x00D9,
    0x0000, 0x0000, 0xFFE3, 0x00CF, 0x0000, 0x0000, 0xFFE3, 0x00C6,
    0x0000, 0x0000, 0xFFE3, 0x00BE, 0x0000, 0x0000, 0xFFE3, 0x00B7,
    0x0000, 0x0000, 0xFFE3, 0x00B0, 0x0000, 0x0000, 0xFFE3, 0x00A9,
    0x0000, 0x0000, 0xFFE3, 0x00A3, 0x0000, 0x0000, 0xFFE3, 0x009D,
    0x0000, 0x0000, 0xFFE3, 0x0098, 0x0000, 0x0000, 0xFFE3, 0x0093,
    0x0000, 0x0000, 0xFFE3, 0x008F, 0x0000, 0x0000, 0xFFE3, 0x008A,
    0x0000, 0x0000, 0xFFE3, 0x0086, 0x0000, 0x0000, 0xFFE3, 0x0082,
    0x0000, 0x0000, 0xFFE3, 0x007E, 0x0000, 0x0000, 0xFFE3, 0x007B,
    0x0000, 0x0000, 0xFFE3, 0x0078, 0x0000, 0x0000, 0xFFE3, 0x0074,
    0x0000, 0x0000, 0xFFE3, 0x0071, 0x0000, 0x0000, 0xFFE3, 0x006F,
    0x0000, 0x0000, 0xFFE3, 0x006C, 0x0000, 0x0000, 0xFFE3, 0x0069,
    0x0000, 0x0000, 0xFFE3, 0x0067, 0x0000, 0x0000, 0xFFE3, 0x0064,
    0x0000, 0x0000, 0xFFE3, 0x0062, 0x0000, 0x0000, 0xFFE3, 0x0060,
    0x0000, 0x0000, 0xFFE3, 0x005E, 0x0000, 0x0000, 0xFFE3, 0x005C,
    0x0000, 0x0000, 0xFFE3, 0x005A, 0x0000, 0x0000, 0xFFE3, 0x0058,
    0x0000, 0x0000, 0xFFE3, 0x0056, 0x0000, 0x0000, 0xFFE3, 0x0055,
    0x0000, 0x0000, 0xFFE3, 0x0053, 0x0000, 0x0000, 0xFFE3, 0x0051,
    0x0000, 0x0000, 0xFFE3, 0x0050, 0x0000, 0x0000, 0xFFE3, 0x004E,
    0x0000, 0x0000, 0xFFE3, 0x004D, 0x0000, 0x0000, 0xFFE3, 0x004B,
    0x0000, 0x0000, 0xFFE3, 0x004A, 0x0000, 0x0000, 0xFFE3, 0x0049,
    0x0000, 0x0000, 0xFFE3, 0x0047, 0x0000, 0x0000, 0xFFE3, 0x0046,
    0x0000, 0x0000, 0xFFE3, 0x0045, 0x0000, 0x0000, 0xFFE3, 0x0044,
    0x0000, 0x0000, 0xFFE3, 0x0043, 0x0000, 0x0000, 0xFFE3, 0x0042,
    0x0000, 0x0000, 0xFFE3, 0x0040, 0x0000, 0x0000, 0xFFE3, 0x003F,
    0x0000, 0x0000, 0xFFE3, 0x003E, 0x0000, 0x0000, 0xFFE3, 0x003D,
    0x0000, 0x0000, 0xFFE3, 0x003C, 0x0000, 0x0000, 0xFFE3, 0x003B,
    0x0000, 0x0000, 0xFFE3, 0x003B, 0x0000, 0x0000, 0xFFE3, 0x003A,
    0x0000, 0x0000, 0xFFE3, 0x0039, 0x0000, 0x0000, 0xFFE3, 0x0038,
    0x0000, 0x0000, 0xFFE3, 0x0037, 0x0000, 0x0000, 0xFFE3, 0x0036,
    0x0000, 0x0000, 0xFFE3, 0x0035, 0x0000, 0x0000, 0xFFE3, 0x0035,
    0x0000, 0x0000, 0xFFE3, 0x0034, 0x0000, 0x0000, 0xFFE3, 0x0033,
    0x0000, 0x0000, 0xFFE3, 0x0032, 0x0000, 0x0000, 0xFFE3, 0x0032,
    0x0000, 0x0000, 0xFFE3, 0x0031, 0x0000, 0x0000, 0xFFE3, 0x0030,
    0x0000, 0x0000, 0xFFE3, 0x0030, 0x0000, 0x0000, 0xFFE3, 0x002F,
    0x0000, 0x0000, 0xFFE3, 0x002E, 0x0000, 0x0000, 0xFFE3, 0x002E,
    0x0000, 0x0000, 0xFFE3, 0x002D, 0x0000, 0x0000, 0xFFE3, 0x002D,
    0x0000, 0x0000, 0xFFE3, 0x002C, 0x0000, 0x0000, 0xFFE3, 0x002B,
    0x0000, 0x0000, 0xFFE3, 0x002B, 0x0000, 0x0000, 0xFFE3, 0x002A,
    0x0000, 0x0000, 0xFFE3, 0x002A, 0x0000, 0x0000, 0xFFE3, 0x0029,
    0x0000, 0x0000, 0xFFE3, 0x0029, 0x0000, 0x0000, 0xFFE3, 0x0028,
    0x0000, 0x0000, 0xFFE3, 0x0028, 0x0000, 0x0000, 0xFFE3, 0x0027,
    0x0000, 0x0000, 0xFFE3, 0x0027, 0x0000, 0x0000, 0xFFE3, 0x0026,
    0x0000, 0x0000, 0xFFE3, 0x0026, 0x0000, 0x0000, 0xFFE3, 0x0025,
    0x0000, 0x0000, 0xFFE3, 0x0025, 0x0000, 0x0000, 0xFFE3, 0x0024,
    0x0000, 0x0000, 0xFFE3, 0x0024, 0x0000, 0x0000, 0xFFE3, 0x0023,
    0x0000, 0x0000, 0xFFE3, 0x0023, 0x0000, 0x0000, 0xFFE3, 0x0022,
    0x0000, 0x0000, 0xFFE3, 0x0022, 0x0000, 0x0000, 0xFFE3, 0x0022,
    0x0000, 0x0000, 0xFFE3, 0x0021, 0x0000, 0x0000, 0xFFE3, 0x0021,
    0x0000, 0x0000, 0xFFE3, 0x0020, 0x0000, 0x0000, 0xFFE3, 0x0020,
    0x0000, 0x0000, 0xFFE3, 0x0020, 0x0000, 0x0000, 0xFFE3, 0x001F,
    0x0000, 0x0000, 0xFFE3, 0x001F, 0x0000, 0x0000, 0xFFE3, 0x001E,
    0x0000, 0x0000, 0xFFE3, 0x001E, 0x0000, 0x0000, 0xFFE3, 0x001E,
    0x0000, 0x0000, 0xFFE3, 0x001D, 0x0000, 0x0000, 0xFFE3, 0x001D,
    0x0000, 0x0000, 0xFFE3, 0x001D, 0x0000, 0x0000, 0xFFE3, 0x001C,
    0x0000, 0x0000, 0xFFE3, 0x001C, 0x0000, 0x0000, 0xFFE3, 0x001C,
    0x0000, 0x0000, 0xFFE3, 0x001B, 0x0000, 0x0000, 0xFFE3, 0x001B,
    0x0000, 0x0000, 0xFFE3, 0x001B, 0x0000, 0x0000, 0xFFE3, 0x001A,
    0x0000, 0x0000, 0xFFE3, 0x001A, 0x0000, 0x0000, 0xFFE3, 0x001A,
    0x0000, 0x0000, 0xFFE3, 0x0019, 0x0000, 0x0000, 0xFFE3, 0x0019,
    0x0000, 0x0000, 0xFFE3, 0x0019, 0x0000, 0x0000, 0xFFE3, 0x0018,
    0x0000, 0x0000, 0xFFE3, 0x0018, 0x0000, 0x0000, 0xFFE3, 0x0018,
    0x0000, 0x0000, 0xFFE3, 0x0017, 0x0000, 0x0000, 0xFFE3, 0x0017,
    0x0000, 0x0000, 0xFFE3, 0x0017, 0x0000, 0x0000, 0xFFE3, 0x0017,
    0x0000, 0x0000, 0xFFE3, 0x0016, 0x0000, 0x0000, 0xFFE3, 0x0016,
    0x0000, 0x0000, 0xFFE3, 0x0016, 0x0000, 0x0000, 0xFFE3, 0x0015,
    0x0000, 0x0000, 0xFFE3, 0x0015, 0x0000, 0x0000, 0xFFE3, 0x0015,
    0x0000, 0x0000, 0xFFE3, 0x0015, 0x0000, 0x0000, 0xFFE3, 0x0014,
    0x0000, 0x0000, 0xFFE3, 0x0014, 0x0000, 0x0000, 0xFFE3, 0x0014,
    0x0000, 0x0000, 0xFFE3, 0x0014, 0x0000, 0x0000, 0xFFE3, 0x0013,
    0x0000, 0x0000, 0xFFE3, 0x0013, 0x0000, 0x0000, 0xFFE3, 0x0013,
    0x0000, 0x0000, 0xFFE3, 0x0013, 0x0000, 0x0000, 0xFFE3, 0x0012,
    0x0000, 0x0000, 0xFFE3, 0x0012, 0x0000, 0x0000, 0xFFE3, 0x0012,
    0x0000, 0x0000, 0xFFE3, 0x0012, 0x0000, 0x0000, 0xFFE3, 0x0011,
    0x0000, 0x0000, 0xFFE3, 0x0011, 0x0000, 0x0000, 0xFFE3, 0x0011,
    0x0000, 0x0000, 0xFFE3, 0x0011, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x0010, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x0010, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x000F, 0x0000, 0x0000, 0xFFE3, 0x000F,
    0x0000, 0x0000, 0xFFE3, 0x000F, 0x0000, 0x0000, 0xFFE3, 0x000F,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000E,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000E,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000D,
    0x0000, 0x0000, 0xFFE3, 0x000D, 0x0000, 0x0000, 0xFFE3, 0x000D,
    0x0000, 0x0000, 0xFFE3, 0x000D, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000C, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000C, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000B,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000B,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x000A, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x000A, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0009,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0009,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0008, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0008, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0006,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0006,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0004, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0004, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0001,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0001,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFF, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFF, 0x0000, 0x0000, 0xFFE3, 0xFFFF,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFE, 0x0000, 0x0000, 0xFFE3, 0xFFFE,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFD, 0x0000, 0x0000, 0xFFE3, 0xFFFD,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFC,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFC,
    0x0000, 0x0000, 0xFFE3, 0xFFFC, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFB,
    0x0000, 0x0000, 0xFFE3, 0xFFFB, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFFA, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFFA, 0x0000, 0x0000, 0xFFE3, 0xFFFA,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF9, 0x0000, 0x0000, 0xFFE3, 0xFFF9,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF8,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF8,
    0x0000, 0x0000, 0xFFE3, 0xFFF8, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF7, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF7, 0x0000, 0x0000, 0xFFE3, 0xFFF7,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF6,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF6,
    0x0000, 0x0000, 0xFFE3, 0xFFF6, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF5, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF5, 0x0000, 0x0000, 0xFFE3, 0xFFF5,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF4,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF4,
    0x0000, 0x0000, 0xFFE3, 0xFFF4, 0x0000, 0x0000, 0xFFE3, 0xFFF3,
    0x0000, 0x0000, 0xFFE3, 0xFFF3, 0x0000, 0x0000, 0xFFE3, 0xFFF3,
    0x0000, 0x0000, 0xFFE3, 0xFFF3, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF2, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF2, 0x0000, 0x0000, 0xFFE3, 0xFFF2,
    0x0000, 0x0000, 0xFFE3, 0xFFF1, 0x0000, 0x0000, 0xFFE3, 0xFFF1,
    0x0000, 0x0000, 0xFFE3, 0xFFF1, 0x0000, 0x0000, 0xFFE3, 0xFFF1,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFF0,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFF0,
    0x0000, 0x0000, 0xFFE3, 0xFFF0, 0x0000, 0x0000, 0xFFE3, 0xFFEF,
    0x0000, 0x0000, 0xFFE3, 0xFFEF, 0x0000, 0x0000, 0xFFE3, 0xFFEF,
    0x0000, 0x0000, 0xFFE3, 0xFFEF, 0x0000, 0x0000, 0xFFE3, 0xFFEE,
    0x0000, 0x0000, 0xFFE3, 0xFFEE, 0x0000, 0x0000, 0xFFE3, 0xFFEE,
    0x0000, 0x0000, 0xFFE3, 0xFFEE, 0x0000, 0x0000, 0xFFE3, 0xFFED,
    0x0000, 0x0000, 0xFFE3, 0xFFED, 0x0000, 0x0000, 0xFFE3, 0xFFED,
    0x0000, 0x0000, 0xFFE3, 0xFFED, 0x0000, 0x0000, 0xFFE3, 0xFFEC,
    0x0000, 0x0000, 0xFFE3, 0xFFEC, 0x0000, 0x0000, 0xFFE3, 0xFFEC,
    0x0000, 0x0000, 0xFFE3, 0xFFEC, 0x0000, 0x0000, 0xFFE3, 0xFFEB,
    0x0000, 0x0000, 0xFFE3, 0xFFEB, 0x0000, 0x0000, 0xFFE3, 0xFFEB,
    0x0000, 0x0000, 0xFFE3, 0xFFEB, 0x0000, 0x0000, 0xFFE3, 0xFFEA,
    0x0000, 0x0000, 0xFFE3, 0xFFEA, 0x0000, 0x0000, 0xFFE3, 0xFFEA,
    0x0000, 0x0000, 0xFFE3, 0xFFE9, 0x0000, 0x0000, 0xFFE3, 0xFFE9,
    0x0000, 0x0000, 0xFFE3, 0xFFE9, 0x0000, 0x0000, 0xFFE3, 0xFFE9,
    0x0000, 0x0000, 0xFFE3, 0xFFE8, 0x0000, 0x0000, 0xFFE3, 0xFFE8,
    0x0000, 0x0000, 0xFFE3, 0xFFE8, 0x0000, 0x0000, 0xFFE3, 0xFFE7,
    0x0000, 0x0000, 0xFFE3, 0xFFE7, 0x0000, 0x0000, 0xFFE3, 0xFFE7,
    0x0000, 0x0000, 0xFFE3, 0xFFE6, 0x0000, 0x0000, 0xFFE3, 0xFFE6,
    0x0000, 0x0000, 0xFFE3, 0xFFE6, 0x0000, 0x0000, 0xFFE3, 0xFFE5,
    0x0000, 0x0000, 0xFFE3, 0xFFE5, 0x0000, 0x0000, 0xFFE3, 0xFFE5,
    0x0000, 0x0000, 0xFFE3, 0xFFE4, 0x0000, 0x0000, 0xFFE3, 0xFFE4,
    0x0000, 0x0000, 0xFFE3, 0xFFE4, 0x0000, 0x0000, 0xFFE3, 0xFFE3,
    0x0000, 0x0000, 0xFFE3, 0xFFE3, 0x0000, 0x0000, 0xFFE3, 0xFFE3,
    0x0000, 0x0000, 0xFFE3, 0xFFE2, 0x0000, 0x0000, 0xFFE3, 0xFFE2,
    0x0000, 0x0000, 0xFFE3, 0xFFE2, 0x0000, 0x0000, 0xFFE3, 0xFFE1,
    0x0000, 0x0000, 0xFFE3, 0xFFE1, 0x0000, 0x0000, 0xFFE3, 0xFFE0,
    0x0000, 0x0000, 0xFFE3, 0xFFE0, 0x0000, 0x0000, 0xFFE3, 0xFFE0,
    0x0000, 0x0000, 0xFFE3, 0xFFDF, 0x0000, 0x0000, 0xFFE3, 0xFFDF,
    0x0000, 0x0000, 0xFFE3, 0xFFDE, 0x0000, 0x0000, 0xFFE3, 0xFFDE,
    0x0000, 0x0000, 0xFFE3, 0xFFDE, 0x0000, 0x0000, 0xFFE3, 0xFFDD,
    0x0000, 0x0000, 0xFFE3, 0xFFDD, 0x0000, 0x0000, 0xFFE3, 0xFFDC,
    0x0000, 0x0000, 0xFFE3, 0xFFDC, 0x0000, 0x0000, 0xFFE3, 0xFFDB,
    0x0000, 0x0000, 0xFFE3, 0xFFDB, 0x0000, 0x0000, 0xFFE3, 0xFFDA,
    0x0000, 0x0000, 0xFFE3, 0xFFDA, 0x0000, 0x0000, 0xFFE3, 0xFFD9,
    0x0000, 0x0000, 0xFFE3, 0xFFD9, 0x0000, 0x0000, 0xFFE3, 0xFFD8,
    0x0000, 0x0000, 0xFFE3, 0xFFD8, 0x0000, 0x0000, 0xFFE3, 0xFFD7,
    0x0000, 0x0000, 0xFFE3, 0xFFD7, 0x0000, 0x0000, 0xFFE3, 0xFFD6,
    0x0000, 0x0000, 0xFFE3, 0xFFD6, 0x0000, 0x0000, 0xFFE3, 0xFFD5,
    0x0000, 0x0000, 0xFFE3, 0xFFD5, 0x0000, 0x0000, 0xFFE3, 0xFFD4,
    0x0000, 0x0000, 0xFFE3, 0xFFD3, 0x0000, 0x0000, 0xFFE3, 0xFFD3,
    0x0000, 0x0000, 0xFFE3, 0xFFD2, 0x0000, 0x0000, 0xFFE3, 0xFFD2,
    0x0000, 0x0000, 0xFFE3, 0xFFD1, 0x0000, 0x0000, 0xFFE3, 0xFFD0,
    0x0000, 0x0000, 0xFFE3, 0xFFD0, 0x0000, 0x0000, 0xFFE3, 0xFFCF,
    0x0000, 0x0000, 0xFFE3, 0xFFCE, 0x0000, 0x0000, 0xFFE3, 0xFFCE,
    0x0000, 0x0000, 0xFFE3, 0xFFCD, 0x0000, 0x0000, 0xFFE3, 0xFFCC,
    0x0000, 0x0000, 0xFFE3, 0xFFCB, 0x0000, 0x0000, 0xFFE3, 0xFFCB,
    0x0000, 0x0000, 0xFFE3, 0xFFCA, 0x0000, 0x0000, 0xFFE3, 0xFFC9,
    0x0000, 0x0000, 0xFFE3, 0xFFC8, 0x0000, 0x0000, 0xFFE3, 0xFFC7,
    0x0000, 0x0000, 0xFFE3, 0xFFC6, 0x0000, 0x0000, 0xFFE3, 0xFFC5,
    0x0000, 0x0000, 0xFFE3, 0xFFC5, 0x0000, 0x0000, 0xFFE3, 0xFFC4,
    0x0000, 0x0000, 0xFFE3, 0xFFC3, 0x0000, 0x0000, 0xFFE3, 0xFFC2,
    0x0000, 0x0000, 0xFFE3, 0xFFC1, 0x0000, 0x0000, 0xFFE3, 0xFFC0,
    0x0000, 0x0000, 0xFFE3, 0xFFBE, 0x0000, 0x0000, 0xFFE3, 0xFFBD,
    0x0000, 0x0000, 0xFFE3, 0xFFBC, 0x0000, 0x0000, 0xFFE3, 0xFFBB,
    0x0000, 0x0000, 0xFFE3, 0xFFBA, 0x0000, 0x0000, 0xFFE3, 0xFFB9,
    0x0000, 0x0000, 0xFFE3, 0xFFB7, 0x0000, 0x0000, 0xFFE3, 0xFFB6,
    0x0000, 0x0000, 0xFFE3, 0xFFB5, 0x0000, 0x0000, 0xFFE3, 0xFFB3,
    0x0000, 0x0000, 0xFFE3, 0xFFB2, 0x0000, 0x0000, 0xFFE3, 0xFFB0,
    0x0000, 0x0000, 0xFFE3, 0xFFAF, 0x0000, 0x0000, 0xFFE3, 0xFFAD,
    0x0000, 0x0000, 0xFFE3, 0xFFAB, 0x0000, 0x0000, 0xFFE3, 0xFFAA,
    0x0000, 0x0000, 0xFFE3, 0xFFA8, 0x0000, 0x0000, 0xFFE3, 0xFFA6,
    0x0000, 0x0000, 0xFFE3, 0xFFA4, 0x0000, 0x0000, 0xFFE3, 0xFFA2,
    0x0000, 0x0000, 0xFFE3, 0xFFA0, 0x0000, 0x0000, 0xFFE3, 0xFF9E,
    0x0000, 0x0000, 0xFFE3, 0xFF9C, 0x0000, 0x0000, 0xFFE3, 0xFF99,
    0x0000, 0x0000, 0xFFE3, 0xFF97, 0x0000, 0x0000, 0xFFE3, 0xFF94,
    0x0000, 0x0000, 0xFFE3, 0xFF91, 0x0000, 0x0000, 0xFFE3, 0xFF8F,
    0x0000, 0x0000, 0xFFE3, 0xFF8C, 0x0000, 0x0000, 0xFFE3, 0xFF88,
    0x0000, 0x0000, 0xFFE3, 0xFF85, 0x0000, 0x0000, 0xFFE3, 0xFF82,
    0x0000, 0x0000, 0xFFE3, 0xFF7E, 0x0000, 0x0000, 0xFFE3, 0xFF7A,
    0x0000, 0x0000, 0xFFE3, 0xFF76, 0x0000, 0x0000, 0xFFE3, 0xFF71,
    0x0000, 0x0000, 0xFFE3, 0xFF6D, 0x0000, 0x0000, 0xFFE3, 0xFF68,
    0x0000, 0x0000, 0xFFE3, 0xFF63, 0x0000, 0x0000, 0xFFE3, 0xFF5D,
    0x0000, 0x0000, 0xFFE3, 0xFF57, 0x0000, 0x0000, 0xFFE3, 0xFF50,
    0x0000, 0x0000, 0xFFE3, 0xFF49, 0x0000, 0x0000, 0xFFE3, 0xFF42,
    0x0000, 0x0000, 0xFFE3, 0xFF3A, 0x0000, 0x0000, 0xFFE3, 0xFF31,
    0x0000, 0x0000, 0xFFE3, 0xFF27, 0x0000, 0x0000, 0xFFE3, 0xFF1C,
    0x0000, 0x0000, 0xFFE3, 0xFF10, 0x0000, 0x0000, 0xFFE3, 0xFF03,
    0x0000, 0x0000, 0xFFE3, 0xFEF5, 0x0000, 0x0000, 0xFFE3, 0xFEE5,
    0x0000, 0x0000, 0xFFE3, 0xFED2, 0x0000, 0x0000, 0xFFE3, 0xFEBD,
    0x0000, 0x0000, 0xFFE3, 0xFEA5, 0x0000, 0x0000, 0xFFE3, 0xFE89,
    0x0000, 0x0000, 0xFFE3, 0xFE69, 0x0000, 0x0000, 0xFFE3, 0xFE42,
    0x0000, 0x0000, 0xFFE3, 0xFE12, 0x0000, 0x0000, 0xFFE3, 0xFDD8,
    0x0000, 0x0000, 0xFFE3, 0xFD8F, 0x0000, 0x0000, 0xFFE3, 0xFD2E,
    0x0000, 0x0000, 0xFFE3, 0xFCAB, 0x0000, 0x0000, 0xFFE3, 0xFBED,
    0x0000, 0x0000, 0xFFE3, 0xFAC3, 0x0000, 0x0000, 0xFFE3, 0xF8AB,
    0x0000, 0x0000, 0xFFE3, 0xF3C7, 0x0000, 0x0000, 0xFFE3, 0xDB55,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_step_1024[1025] = {
    0x399A, 0x0000, 0xFFE3, 0x24AB, 0x0000, 0x0000, 0xFFE3, 0x0C39,
    0x0000, 0x0000, 0xFFE3, 0x0755, 0x0000, 0x0000, 0xFFE3, 0x053D,
    0x0000, 0x0000, 0xFFE3, 0x0413, 0x0000, 0x0000, 0xFFE3, 0x0355,
    0x0000, 0x0000, 0xFFE3, 0x02D2, 0x0000, 0x0000, 0xFFE3, 0x0271,
    0x0000, 0x0000, 0xFFE3, 0x0228, 0x0000, 0x0000, 0xFFE3, 0x01EE,
    0x0000, 0x0000, 0xFFE3, 0x01BE, 0x0000, 0x0000, 0xFFE3, 0x0197,
    0x0000, 0x0000, 0xFFE3, 0x0177, 0x0000, 0x0000, 0xFFE3, 0x015B,
    0x0000, 0x0000, 0xFFE3, 0x0143, 0x0000, 0x0000, 0xFFE3, 0x012E,
    0x0000, 0x0000, 0xFFE3, 0x011B, 0x0000, 0x0000, 0xFFE3, 0x010B,
    0x0000, 0x0000, 0xFFE3, 0x00FD, 0x0000, 0x0000, 0xFFE3, 0x00F0,
    0x0000, 0x0000, 0xFFE3, 0x00E4, 0x0000, 0x0000, 0xFFE3, 0x00D9,
    0x0000, 0x0000, 0xFFE3, 0x00CF, 0x0000, 0x0000, 0xFFE3, 0x00C6,
    0x0000, 0x0000, 0xFFE3, 0x00BE, 0x0000, 0x0000, 0xFFE3, 0x00B7,
    0x0000, 0x0000, 0xFFE3, 0x00B0, 0x0000, 0x0000, 0xFFE3, 0x00A9,
    0x0000, 0x0000, 0xFFE3, 0x00A3, 0x0000, 0x0000, 0xFFE3, 0x009D,
    0x0000, 0x0000, 0xFFE3, 0x0098, 0x0000, 0x0000, 0xFFE3, 0x0093,
    0x0000, 0x0000, 0xFFE3, 0x008F, 0x0000, 0x0000, 0xFFE3, 0x008A,
    0x0000, 0x0000, 0xFFE3, 0x0086, 0x0000, 0x0000, 0xFFE3, 0x0082,
    0x0000, 0x0000, 0xFFE3, 0x007E, 0x0000, 0x0000, 0xFFE3, 0x007B,
    0x0000, 0x0000, 0xFFE3, 0x0078, 0x0000, 0x0000, 0xFFE3, 0x0074,
    0x0000, 0x0000, 0xFFE3, 0x0071, 0x0000, 0x0000, 0xFFE3, 0x006F,
    0x0000, 0x0000, 0xFFE3, 0x006C, 0x0000, 0x0000, 0xFFE3, 0x0069,
    0x0000, 0x0000, 0xFFE3, 0x0067, 0x0000, 0x0000, 0xFFE3, 0x0064,
    0x0000, 0x0000, 0xFFE3, 0x0062, 0x0000, 0x0000, 0xFFE3, 0x0060,
    0x0000, 0x0000, 0xFFE3, 0x005E, 0x0000, 0x0000, 0xFFE3, 0x005C,
    0x0000, 0x0000, 0xFFE3, 0x005A, 0x0000, 0x0000, 0xFFE3, 0x0058,
    0x0000, 0x0000, 0xFFE3, 0x0056, 0x0000, 0x0000, 0xFFE3, 0x0055,
    0x0000, 0x0000, 0xFFE3, 0x0053, 0x0000, 0x0000, 0xFFE3, 0x0051,
    0x0000, 0x0000, 0xFFE3, 0x0050, 0x0000, 0x0000, 0xFFE3, 0x004E,
    0x0000, 0x0000, 0xFFE3, 0x004D, 0x0000, 0x0000, 0xFFE3, 0x004B,
    0x0000, 0x0000, 0xFFE3, 0x004A, 0x0000, 0x0000, 0xFFE3, 0x0049,
    0x0000, 0x0000, 0xFFE3, 0x0047, 0x0000, 0x0000, 0xFFE3, 0x0046,
    0x0000, 0x0000, 0xFFE3, 0x0045, 0x0000, 0x0000, 0xFFE3, 0x0044,
    0x0000, 0x0000, 0xFFE3, 0x0043, 0x0000, 0x0000, 0xFFE3, 0x0042,
    0x0000, 0x0000, 0xFFE3, 0x0040, 0x0000, 0x0000, 0xFFE3, 0x003F,
    0x0000, 0x0000, 0xFFE3, 0x003E, 0x0000, 0x0000, 0xFFE3, 0x003D,
    0x0000, 0x0000, 0xFFE3, 0x003C, 0x0000, 0x0000, 0xFFE3, 0x003B,
    0x0000, 0x0000, 0xFFE3, 0x003B, 0x0000, 0x0000, 0xFFE3, 0x003A,
    0x0000, 0x0000, 0xFFE3, 0x0039, 0x0000, 0x0000, 0xFFE3, 0x0038,
    0x0000, 0x0000, 0xFFE3, 0x0037, 0x0000, 0x0000, 0xFFE3, 0x0036,
    0x0000, 0x0000, 0xFFE3, 0x0035, 0x0000, 0x0000, 0xFFE3, 0x0035,
    0x0000, 0x0000, 0xFFE3, 0x0034, 0x0000, 0x0000, 0xFFE3, 0x0033,
    0x0000, 0x0000, 0xFFE3, 0x0032, 0x0000, 0x0000, 0xFFE3, 0x0032,
    0x0000, 0x0000, 0xFFE3, 0x0031, 0x0000, 0x0000, 0xFFE3, 0x0030,
    0x0000, 0x0000, 0xFFE3, 0x0030, 0x0000, 0x0000, 0xFFE3, 0x002F,
    0x0000, 0x0000, 0xFFE3, 0x002E, 0x0000, 0x0000, 0xFFE3, 0x002E,
    0x0000, 0x0000, 0xFFE3, 0x002D, 0x0000, 0x0000, 0xFFE3, 0x002D,
    0x0000, 0x0000, 0xFFE3, 0x002C, 0x0000, 0x0000, 0xFFE3, 0x002B,
    0x0000, 0x0000, 0xFFE3, 0x002B, 0x0000, 0x0000, 0xFFE3, 0x002A,
    0x0000, 0x0000, 0xFFE3, 0x002A, 0x0000, 0x0000, 0xFFE3, 0x0029,
    0x0000, 0x0000, 0xFFE3, 0x0029, 0x0000, 0x0000, 0xFFE3, 0x0028,
    0x0000, 0x0000, 0xFFE3, 0x0028, 0x0000, 0x0000, 0xFFE3, 0x0027,
    0x0000, 0x0000, 0xFFE3, 0x0027, 0x0000, 0x0000, 0xFFE3, 0x0026,
    0x0000, 0x0000, 0xFFE3, 0x0026, 0x0000, 0x0000, 0xFFE3, 0x0025,
    0x0000, 0x0000, 0xFFE3, 0x0025, 0x0000, 0x0000, 0xFFE3, 0x0024,
    0x0000, 0x0000, 0xFFE3, 0x0024, 0x0000, 0x0000, 0xFFE3, 0x0023,
    0x0000, 0x0000, 0xFFE3, 0x0023, 0x0000, 0x0000, 0xFFE3, 0x0022,
    0x0000, 0x0000, 0xFFE3, 0x0022, 0x0000, 0x0000, 0xFFE3, 0x0022,
    0x0000, 0x0000, 0xFFE3, 0x0021, 0x0000, 0x0000, 0xFFE3, 0x0021,
    0x0000, 0x0000, 0xFFE3, 0x0020, 0x0000, 0x0000, 0xFFE3, 0x0020,
    0x0000, 0x0000, 0xFFE3, 0x0020, 0x0000, 0x0000, 0xFFE3, 0x001F,
    0x0000, 0x0000, 0xFFE3, 0x001F, 0x0000, 0x0000, 0xFFE3, 0x001E,
    0x0000, 0x0000, 0xFFE3, 0x001E, 0x0000, 0x0000, 0xFFE3, 0x001E,
    0x0000, 0x0000, 0xFFE3, 0x001D, 0x0000, 0x0000, 0xFFE3, 0x001D,
    0x0000, 0x0000, 0xFFE3, 0x001D, 0x0000, 0x0000, 0xFFE3, 0x001C,
    0x0000, 0x0000, 0xFFE3, 0x001C, 0x0000, 0x0000, 0xFFE3, 0x001C,
    0x0000, 0x0000, 0xFFE3, 0x001B, 0x0000, 0x0000, 0xFFE3, 0x001B,
    0x0000, 0x0000, 0xFFE3, 0x001B, 0x0000, 0x0000, 0xFFE3, 0x001A,
    0x0000, 0x0000, 0xFFE3, 0x001A, 0x0000, 0x0000, 0xFFE3, 0x001A,
    0x0000, 0x0000, 0xFFE3, 0x0019, 0x0000, 0x0000, 0xFFE3, 0x0019,
    0x0000, 0x0000, 0xFFE3, 0x0019, 0x0000, 0x0000, 0xFFE3, 0x0018,
    0x0000, 0x0000, 0xFFE3, 0x0018, 0x0000, 0x0000, 0xFFE3, 0x0018,
    0x0000, 0x0000, 0xFFE3, 0x0017, 0x0000, 0x0000, 0xFFE3, 0x0017,
    0x0000, 0x0000, 0xFFE3, 0x0017, 0x0000, 0x0000, 0xFFE3, 0x0017,
    0x0000, 0x0000, 0xFFE3, 0x0016, 0x0000, 0x0000, 0xFFE3, 0x0016,
    0x0000, 0x0000, 0xFFE3, 0x0016, 0x0000, 0x0000, 0xFFE3, 0x0015,
    0x0000, 0x0000, 0xFFE3, 0x0015, 0x0000, 0x0000, 0xFFE3, 0x0015,
    0x0000, 0x0000, 0xFFE3, 0x0015, 0x0000, 0x0000, 0xFFE3, 0x0014,
    0x0000, 0x0000, 0xFFE3, 0x0014, 0x0000, 0x0000, 0xFFE3, 0x0014,
    0x0000, 0x0000, 0xFFE3, 0x0014, 0x0000, 0x0000, 0xFFE3, 0x0013,
    0x0000, 0x0000, 0xFFE3, 0x0013, 0x0000, 0x0000, 0xFFE3, 0x0013,
    0x0000, 0x0000, 0xFFE3, 0x0013, 0x0000, 0x0000, 0xFFE3, 0x0012,
    0x0000, 0x0000, 0xFFE3, 0x0012, 0x0000, 0x0000, 0xFFE3, 0x0012,
    0x0000, 0x0000, 0xFFE3, 0x0012, 0x0000, 0x0000, 0xFFE3, 0x0011,
    0x0000, 0x0000, 0xFFE3, 0x0011, 0x0000, 0x0000, 0xFFE3, 0x0011,
    0x0000, 0x0000, 0xFFE3, 0x0011, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x0010, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x0010, 0x0000, 0x0000, 0xFFE3, 0x0010,
    0x0000, 0x0000, 0xFFE3, 0x000F, 0x0000, 0x0000, 0xFFE3, 0x000F,
    0x0000, 0x0000, 0xFFE3, 0x000F, 0x0000, 0x0000, 0xFFE3, 0x000F,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000E,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000E,
    0x0000, 0x0000, 0xFFE3, 0x000E, 0x0000, 0x0000, 0xFFE3, 0x000D,
    0x0000, 0x0000, 0xFFE3, 0x000D, 0x0000, 0x0000, 0xFFE3, 0x000D,
    0x0000, 0x0000, 0xFFE3, 0x000D, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000C, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000C, 0x0000, 0x0000, 0xFFE3, 0x000C,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000B,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000B,
    0x0000, 0x0000, 0xFFE3, 0x000B, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x000A, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x000A, 0x0000, 0x0000, 0xFFE3, 0x000A,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0009,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0009,
    0x0000, 0x0000, 0xFFE3, 0x0009, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0008, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0008, 0x0000, 0x0000, 0xFFE3, 0x0008,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0007, 0x0000, 0x0000, 0xFFE3, 0x0007,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0006,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0006,
    0x0000, 0x0000, 0xFFE3, 0x0006, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0005,
    0x0000, 0x0000, 0xFFE3, 0x0005, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0004, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0004, 0x0000, 0x0000, 0xFFE3, 0x0004,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0003, 0x0000, 0x0000, 0xFFE3, 0x0003,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0002, 0x0000, 0x0000, 0xFFE3, 0x0002,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0001,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0001,
    0x0000, 0x0000, 0xFFE3, 0x0001, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000, 0x0000, 0xFFE3, 0x0000, 0x0000, 0x0000, 0xFFE3, 0x0000,
    0x0000
    };

static const q15_t in_rfft_step_2048[2048] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333
    };

static const q15_t in_rifft_step_2048[4098] = {
    0x399A, 0x0000, 0xFFF2, 0x24AB, 0x0000, 0x0000, 0xFFF2, 0x0C39,
    0x0000, 0x0000, 0xFFF2, 0x0755, 0x0000, 0x0000, 0xFFF2, 0x053D,
    0x0000, 0x0000, 0xFFF2, 0x0413, 0x0000, 0x0000, 0xFFF2, 0x0355,
    0x0000, 0x0000, 0xFFF2, 0x02D2, 0x0000, 0x0000, 0xFFF2, 0x0272,
    0x0000, 0x0000, 0xFFF2, 0x0228, 0x0000, 0x0000, 0xFFF2, 0x01EE,
    0x0000, 0x0000, 0xFFF2, 0x01BF, 0x0000, 0x0000, 0xFFF2, 0x0198,
    0x0000, 0x0000, 0xFFF2, 0x0177, 0x0000, 0x0000, 0xFFF2, 0x015B,
    0x0000, 0x0000, 0xFFF2, 0x0143, 0x0000, 0x0000, 0xFFF2, 0x012F,
    0x0000, 0x0000, 0xFFF2, 0x011C, 0x0000, 0x0000, 0xFFF2, 0x010C,
    0x0000, 0x0000, 0xFFF2, 0x00FD, 0x0000, 0x0000, 0xFFF2, 0x00F0,
    0x0000, 0x0000, 0xFFF2, 0x00E5, 0x0000, 0x0000, 0xFFF2, 0x00DA,
    0x0000, 0x0000, 0xFFF2, 0x00D0, 0x0000, 0x0000, 0xFFF2, 0x00C7,
    0x0000, 0x0000, 0xFFF2, 0x00BF, 0x0000, 0x0000, 0xFFF2, 0x00B8,
    0x0000, 0x0000, 0xFFF2, 0x00B1, 0x0000, 0x0000, 0xFFF2, 0x00AA,
    0x0000, 0x0000, 0xFFF2, 0x00A4, 0x0000, 0x0000, 0xFFF2, 0x009F,
    0x0000, 0x0000, 0xFFF2, 0x0099, 0x0000, 0x0000, 0xFFF2, 0x0095,
    0x0000, 0x0000, 0xFFF2, 0x0090, 0x0000, 0x0000, 0xFFF2, 0x008C,
    0x0000, 0x0000, 0xFFF2, 0x0088, 0x0000, 0x0000, 0xFFF2, 0x0084,
    0x0000, 0x0000, 0xFFF2, 0x0080, 0x0000, 0x0000, 0xFFF2, 0x007D,
    0x0000, 0x0000, 0xFFF2, 0x0079, 0x0000, 0x0000, 0xFFF2, 0x0076,
    0x0000, 0x0000, 0xFFF2, 0x0073, 0x0000, 0x0000, 0xFFF2, 0x0070,
    0x0000, 0x0000, 0xFFF2, 0x006E, 0x0000, 0x0000, 0xFFF2, 0x006B,
    0x0000, 0x0000, 0xFFF2, 0x0069, 0x0000, 0x0000, 0xFFF2, 0x0066,
    0x0000, 0x0000, 0xFFF2, 0x0064, 0x0000, 0x0000, 0xFFF2, 0x0062,
    0x0000, 0x0000, 0xFFF2, 0x0060, 0x0000, 0x0000, 0xFFF2, 0x005E,
    0x0000, 0x0000, 0xFFF2, 0x005C, 0x0000, 0x0000, 0xFFF2, 0x005A,
    0x0000, 0x0000, 0xFFF2, 0x0059, 0x0000, 0x0000, 0xFFF2, 0x0057,
    0x0000, 0x0000, 0xFFF2, 0x0055, 0x0000, 0x0000, 0xFFF2, 0x0054,
    0x0000, 0x0000, 0xFFF2, 0x0052, 0x0000, 0x0000, 0xFFF2, 0x0051,
    0x0000, 0x0000, 0xFFF2, 0x004F, 0x0000, 0x0000, 0xFFF2, 0x004E,
    0x0000, 0x0000, 0xFFF2, 0x004D, 0x0000, 0x0000, 0xFFF2, 0x004B,
    0x0000, 0x0000, 0xFFF2, 0x004A, 0x0000, 0x0000, 0xFFF2, 0x0049,
    0x0000, 0x0000, 0xFFF2, 0x0048, 0x0000, 0x0000, 0xFFF2, 0x0047,
    0x0000, 0x0000, 0xFFF2, 0x0046, 0x0000, 0x0000, 0xFFF2, 0x0045,
    0x0000, 0x0000, 0xFFF2, 0x0044, 0x0000, 0x0000, 0xFFF2, 0x0043,
    0x0000, 0x0000, 0xFFF2, 0x0042, 0x0000, 0x0000, 0xFFF2, 0x0041,
    0x0000, 0x0000, 0xFFF2, 0x0040, 0x0000, 0x0000, 0xFFF2, 0x003F,
    0x0000, 0x0000, 0xFFF2, 0x003E, 0x0000, 0x0000, 0xFFF2, 0x003D,
    0x0000, 0x0000, 0xFFF2, 0x003C, 0x0000, 0x0000, 0xFFF2, 0x003B,
    0x0000, 0x0000, 0xFFF2, 0x003B, 0x0000, 0x0000, 0xFFF2, 0x003A,
    0x0000, 0x0000, 0xFFF2, 0x0039, 0x0000, 0x0000, 0xFFF2, 0x0038,
    0x0000, 0x0000, 0xFFF2, 0x0038, 0x0000, 0x0000, 0xFFF2, 0x0037,
    0x0000, 0x0000, 0xFFF2, 0x0036, 0x0000, 0x0000, 0xFFF2, 0x0036,
    0x0000, 0x0000, 0xFFF2, 0x0035, 0x0000, 0x0000, 0xFFF2, 0x0034,
    0x0000, 0x0000, 0xFFF2, 0x0034, 0x0000, 0x0000, 0xFFF2, 0x0033,
    0x0000, 0x0000, 0xFFF2, 0x0033, 0x0000, 0x0000, 0xFFF2, 0x0032,
    0x0000, 0x0000, 0xFFF2, 0x0031, 0x0000, 0x0000, 0xFFF2, 0x0031,
    0x0000, 0x0000, 0xFFF2, 0x0030, 0x0000, 0x0000, 0xFFF2, 0x0030,
    0x0000, 0x0000, 0xFFF2, 0x002F, 0x0000, 0x0000, 0xFFF2, 0x002F,
    0x0000, 0x0000, 0xFFF2, 0x002E, 0x0000, 0x0000, 0xFFF2, 0x002E,
    0x0000, 0x0000, 0xFFF2, 0x002D, 0x0000, 0x0000, 0xFFF2, 0x002D,
    0x0000, 0x0000, 0xFFF2, 0x002C, 0x0000, 0x0000, 0xFFF2, 0x002C,
    0x0000, 0x0000, 0xFFF2, 0x002B, 0x0000, 0x0000, 0xFFF2, 0x002B,
    0x0000, 0x0000, 0xFFF2, 0x002A, 0x0000, 0x0000, 0xFFF2, 0x002A,
    0x0000, 0x0000, 0xFFF2, 0x002A, 0x0000, 0x0000, 0xFFF2, 0x0029,
    0x0000, 0x0000, 0xFFF2, 0x0029, 0x0000, 0x0000, 0xFFF2, 0x0028,
    0x0000, 0x0000, 0xFFF2, 0x0028, 0x0000, 0x0000, 0xFFF2, 0x0028,
    0x0000, 0x0000, 0xFFF2, 0x0027, 0x0000, 0x0000, 0xFFF2, 0x0027,
    0x0000, 0x0000, 0xFFF2, 0x0027, 0x0000, 0x0000, 0xFFF2, 0x0026,
    0x0000, 0x0000, 0xFFF2, 0x0026, 0x0000, 0x0000, 0xFFF2, 0x0026,
    0x0000, 0x0000, 0xFFF2, 0x0025, 0x0000, 0x0000, 0xFFF2, 0x0025,
    0x0000, 0x0000, 0xFFF2, 0x0024, 0x0000, 0x0000, 0xFFF2, 0x0024,
    0x0000, 0x0000, 0xFFF2, 0x0024, 0x0000, 0x0000, 0xFFF2, 0x0024,
    0x0000, 0x0000, 0xFFF2, 0x0023, 0x0000, 0x0000, 0xFFF2, 0x0023,
    0x0000, 0x0000, 0xFFF2, 0x0023, 0x0000, 0x0000, 0xFFF2, 0x0022,
    0x0000, 0x0000, 0xFFF2, 0x0022, 0x0000, 0x0000, 0xFFF2, 0x0022,
    0x0000, 0x0000, 0xFFF2, 0x0021, 0x0000, 0x0000, 0xFFF2, 0x0021,
    0x0000, 0x0000, 0xFFF2, 0x0021, 0x0000, 0x0000, 0xFFF2, 0x0021,
    0x0000, 0x0000, 0xFFF2, 0x0020, 0x0000, 0x0000, 0xFFF2, 0x0020,
    0x0000, 0x0000, 0xFFF2, 0x0020, 0x0000, 0x0000, 0xFFF2, 0x0020,
    0x0000, 0x0000, 0xFFF2, 0x001F, 0x0000, 0x0000, 0xFFF2, 0x001F,
    0x0000, 0x0000, 0xFFF2, 0x001F, 0x0000, 0x0000, 0xFFF2, 0x001F,
    0x0000, 0x0000, 0xFFF2, 0x001E, 0x0000, 0x0000, 0xFFF2, 0x001E,
    0x0000, 0x0000, 0xFFF2, 0x001E, 0x0000, 0x0000, 0xFFF2, 0x001E,
    0x0000, 0x0000, 0xFFF2, 0x001D, 0x0000, 0x0000, 0xFFF2, 0x001D,
    0x0000, 0x0000, 0xFFF2, 0x001D, 0x0000, 0x0000, 0xFFF2, 0x001D,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001C,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001C,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001B, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001B, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0019,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0019,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFF, 0x0000, 0x0000, 0xFFF2, 0xFFFF,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFE, 0x0000, 0x0000, 0xFFF2, 0xFFFE,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFD, 0x0000, 0x0000, 0xFFF2, 0xFFFD,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFC,
    0x0000, 0x0000, 0xFFF2, 0xFFFC, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFB,
    0x0000, 0x0000, 0xFFF2, 0xFFFB, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFFA, 0x0000, 0x0000, 0xFFF2, 0xFFFA,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF9,
    0x0000, 0x0000, 0xFFF2, 0xFFF9, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF8, 0x0000, 0x0000, 0xFFF2, 0xFFF8,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF7, 0x0000, 0x0000, 0xFFF2, 0xFFF7,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF6,
    0x0000, 0x0000, 0xFFF2, 0xFFF6, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF5, 0x0000, 0x0000, 0xFFF2, 0xFFF5,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF4,
    0x0000, 0x0000, 0xFFF2, 0xFFF4, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF3,
    0x0000, 0x0000, 0xFFF2, 0xFFF3, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF2,
    0x0000, 0x0000, 0xFFF2, 0xFFF2, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF1, 0x0000, 0x0000, 0xFFF2, 0xFFF1,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFF0, 0x0000, 0x0000, 0xFFF2, 0xFFF0,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEF, 0x0000, 0x0000, 0xFFF2, 0xFFEF,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFEE, 0x0000, 0x0000, 0xFFF2, 0xFFEE,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFED,
    0x0000, 0x0000, 0xFFF2, 0xFFED, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEC, 0x0000, 0x0000, 0xFFF2, 0xFFEC,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEB, 0x0000, 0x0000, 0xFFF2, 0xFFEB,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFEA, 0x0000, 0x0000, 0xFFF2, 0xFFEA,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE9,
    0x0000, 0x0000, 0xFFF2, 0xFFE9, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE8,
    0x0000, 0x0000, 0xFFF2, 0xFFE8, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE7, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE7, 0x0000, 0x0000, 0xFFF2, 0xFFE7,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE6, 0x0000, 0x0000, 0xFFF2, 0xFFE6,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE5,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE5,
    0x0000, 0x0000, 0xFFF2, 0xFFE5, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE4, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE4, 0x0000, 0x0000, 0xFFF2, 0xFFE4,
    0x0000, 0x0000, 0xFFF2, 0xFFE3, 0x0000, 0x0000, 0xFFF2, 0xFFE3,
    0x0000, 0x0000, 0xFFF2, 0xFFE3, 0x0000, 0x0000, 0xFFF2, 0xFFE3,
    0x0000, 0x0000, 0xFFF2, 0xFFE2, 0x0000, 0x0000, 0xFFF2, 0xFFE2,
    0x0000, 0x0000, 0xFFF2, 0xFFE2, 0x0000, 0x0000, 0xFFF2, 0xFFE2,
    0x0000, 0x0000, 0xFFF2, 0xFFE1, 0x0000, 0x0000, 0xFFF2, 0xFFE1,
    0x0000, 0x0000, 0xFFF2, 0xFFE1, 0x0000, 0x0000, 0xFFF2, 0xFFE1,
    0x0000, 0x0000, 0xFFF2, 0xFFE0, 0x0000, 0x0000, 0xFFF2, 0xFFE0,
    0x0000, 0x0000, 0xFFF2, 0xFFE0, 0x0000, 0x0000, 0xFFF2, 0xFFE0,
    0x0000, 0x0000, 0xFFF2, 0xFFDF, 0x0000, 0x0000, 0xFFF2, 0xFFDF,
    0x0000, 0x0000, 0xFFF2, 0xFFDF, 0x0000, 0x0000, 0xFFF2, 0xFFDF,
    0x0000, 0x0000, 0xFFF2, 0xFFDE, 0x0000, 0x0000, 0xFFF2, 0xFFDE,
    0x0000, 0x0000, 0xFFF2, 0xFFDE, 0x0000, 0x0000, 0xFFF2, 0xFFDD,
    0x0000, 0x0000, 0xFFF2, 0xFFDD, 0x0000, 0x0000, 0xFFF2, 0xFFDD,
    0x0000, 0x0000, 0xFFF2, 0xFFDC, 0x0000, 0x0000, 0xFFF2, 0xFFDC,
    0x0000, 0x0000, 0xFFF2, 0xFFDC, 0x0000, 0x0000, 0xFFF2, 0xFFDC,
    0x0000, 0x0000, 0xFFF2, 0xFFDB, 0x0000, 0x0000, 0xFFF2, 0xFFDB,
    0x0000, 0x0000, 0xFFF2, 0xFFDA, 0x0000, 0x0000, 0xFFF2, 0xFFDA,
    0x0000, 0x0000, 0xFFF2, 0xFFDA, 0x0000, 0x0000, 0xFFF2, 0xFFD9,
    0x0000, 0x0000, 0xFFF2, 0xFFD9, 0x0000, 0x0000, 0xFFF2, 0xFFD9,
    0x0000, 0x0000, 0xFFF2, 0xFFD8, 0x0000, 0x0000, 0xFFF2, 0xFFD8,
    0x0000, 0x0000, 0xFFF2, 0xFFD8, 0x0000, 0x0000, 0xFFF2, 0xFFD7,
    0x0000, 0x0000, 0xFFF2, 0xFFD7, 0x0000, 0x0000, 0xFFF2, 0xFFD6,
    0x0000, 0x0000, 0xFFF2, 0xFFD6, 0x0000, 0x0000, 0xFFF2, 0xFFD6,
    0x0000, 0x0000, 0xFFF2, 0xFFD5, 0x0000, 0x0000, 0xFFF2, 0xFFD5,
    0x0000, 0x0000, 0xFFF2, 0xFFD4, 0x0000, 0x0000, 0xFFF2, 0xFFD4,
    0x0000, 0x0000, 0xFFF2, 0xFFD3, 0x0000, 0x0000, 0xFFF2, 0xFFD3,
    0x0000, 0x0000, 0xFFF2, 0xFFD2, 0x0000, 0x0000, 0xFFF2, 0xFFD2,
    0x0000, 0x0000, 0xFFF2, 0xFFD1, 0x0000, 0x0000, 0xFFF2, 0xFFD1,
    0x0000, 0x0000, 0xFFF2, 0xFFD0, 0x0000, 0x0000, 0xFFF2, 0xFFD0,
    0x0000, 0x0000, 0xFFF2, 0xFFCF, 0x0000, 0x0000, 0xFFF2, 0xFFCF,
    0x0000, 0x0000, 0xFFF2, 0xFFCE, 0x0000, 0x0000, 0xFFF2, 0xFFCD,
    0x0000, 0x0000, 0xFFF2, 0xFFCD, 0x0000, 0x0000, 0xFFF2, 0xFFCC,
    0x0000, 0x0000, 0xFFF2, 0xFFCC, 0x0000, 0x0000, 0xFFF2, 0xFFCB,
    0x0000, 0x0000, 0xFFF2, 0xFFCA, 0x0000, 0x0000, 0xFFF2, 0xFFCA,
    0x0000, 0x0000, 0xFFF2, 0xFFC9, 0x0000, 0x0000, 0xFFF2, 0xFFC8,
    0x0000, 0x0000, 0xFFF2, 0xFFC8, 0x0000, 0x0000, 0xFFF2, 0xFFC7,
    0x0000, 0x0000, 0xFFF2, 0xFFC6, 0x0000, 0x0000, 0xFFF2, 0xFFC5,
    0x0000, 0x0000, 0xFFF2, 0xFFC5, 0x0000, 0x0000, 0xFFF2, 0xFFC4,
    0x0000, 0x0000, 0xFFF2, 0xFFC3, 0x0000, 0x0000, 0xFFF2, 0xFFC2,
    0x0000, 0x0000, 0xFFF2, 0xFFC1, 0x0000, 0x0000, 0xFFF2, 0xFFC0,
    0x0000, 0x0000, 0xFFF2, 0xFFBF, 0x0000, 0x0000, 0xFFF2, 0xFFBE,
    0x0000, 0x0000, 0xFFF2, 0xFFBD, 0x0000, 0x0000, 0xFFF2, 0xFFBC,
    0x0000, 0x0000, 0xFFF2, 0xFFBB, 0x0000, 0x0000, 0xFFF2, 0xFFBA,
    0x0000, 0x0000, 0xFFF2, 0xFFB9, 0x0000, 0x0000, 0xFFF2, 0xFFB8,
    0x0000, 0x0000, 0xFFF2, 0xFFB7, 0x0000, 0x0000, 0xFFF2, 0xFFB6,
    0x0000, 0x0000, 0xFFF2, 0xFFB5, 0x0000, 0x0000, 0xFFF2, 0xFFB3,
    0x0000, 0x0000, 0xFFF2, 0xFFB2, 0x0000, 0x0000, 0xFFF2, 0xFFB1,
    0x0000, 0x0000, 0xFFF2, 0xFFAF, 0x0000, 0x0000, 0xFFF2, 0xFFAE,
    0x0000, 0x0000, 0xFFF2, 0xFFAC, 0x0000, 0x0000, 0xFFF2, 0xFFAB,
    0x0000, 0x0000, 0xFFF2, 0xFFA9, 0x0000, 0x0000, 0xFFF2, 0xFFA7,
    0x0000, 0x0000, 0xFFF2, 0xFFA6, 0x0000, 0x0000, 0xFFF2, 0xFFA4,
    0x0000, 0x0000, 0xFFF2, 0xFFA2, 0x0000, 0x0000, 0xFFF2, 0xFFA0,
    0x0000, 0x0000, 0xFFF2, 0xFF9E, 0x0000, 0x0000, 0xFFF2, 0xFF9C,
    0x0000, 0x0000, 0xFFF2, 0xFF9A, 0x0000, 0x0000, 0xFFF2, 0xFF97,
    0x0000, 0x0000, 0xFFF2, 0xFF95, 0x0000, 0x0000, 0xFFF2, 0xFF92,
    0x0000, 0x0000, 0xFFF2, 0xFF90, 0x0000, 0x0000, 0xFFF2, 0xFF8D,
    0x0000, 0x0000, 0xFFF2, 0xFF8A, 0x0000, 0x0000, 0xFFF2, 0xFF87,
    0x0000, 0x0000, 0xFFF2, 0xFF83, 0x0000, 0x0000, 0xFFF2, 0xFF80,
    0x0000, 0x0000, 0xFFF2, 0xFF7C, 0x0000, 0x0000, 0xFFF2, 0xFF78,
    0x0000, 0x0000, 0xFFF2, 0xFF74, 0x0000, 0x0000, 0xFFF2, 0xFF70,
    0x0000, 0x0000, 0xFFF2, 0xFF6B, 0x0000, 0x0000, 0xFFF2, 0xFF67,
    0x0000, 0x0000, 0xFFF2, 0xFF61, 0x0000, 0x0000, 0xFFF2, 0xFF5C,
    0x0000, 0x0000, 0xFFF2, 0xFF56, 0x0000, 0x0000, 0xFFF2, 0xFF4F,
    0x0000, 0x0000, 0xFFF2, 0xFF48, 0x0000, 0x0000, 0xFFF2, 0xFF41,
    0x0000, 0x0000, 0xFFF2, 0xFF39, 0x0000, 0x0000, 0xFFF2, 0xFF30,
    0x0000, 0x0000, 0xFFF2, 0xFF26, 0x0000, 0x0000, 0xFFF2, 0xFF1B,
    0x0000, 0x0000, 0xFFF2, 0xFF10, 0x0000, 0x0000, 0xFFF2, 0xFF03,
    0x0000, 0x0000, 0xFFF2, 0xFEF4, 0x0000, 0x0000, 0xFFF2, 0xFEE4,
    0x0000, 0x0000, 0xFFF2, 0xFED1, 0x0000, 0x0000, 0xFFF2, 0xFEBD,
    0x0000, 0x0000, 0xFFF2, 0xFEA5, 0x0000, 0x0000, 0xFFF2, 0xFE89,
    0x0000, 0x0000, 0xFFF2, 0xFE68, 0x0000, 0x0000, 0xFFF2, 0xFE41,
    0x0000, 0x0000, 0xFFF2, 0xFE12, 0x0000, 0x0000, 0xFFF2, 0xFDD8,
    0x0000, 0x0000, 0xFFF2, 0xFD8E, 0x0000, 0x0000, 0xFFF2, 0xFD2E,
    0x0000, 0x0000, 0xFFF2, 0xFCAB, 0x0000, 0x0000, 0xFFF2, 0xFBED,
    0x0000, 0x0000, 0xFFF2, 0xFAC3, 0x0000, 0x0000, 0xFFF2, 0xF8AB,
    0x0000, 0x0000, 0xFFF2, 0xF3C7, 0x0000, 0x0000, 0xFFF2, 0xDB55,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_step_2048[2049] = {
    0x399A, 0x0000, 0xFFF2, 0x24AB, 0x0000, 0x0000, 0xFFF2, 0x0C39,
    0x0000, 0x0000, 0xFFF2, 0x0755, 0x0000, 0x0000, 0xFFF2, 0x053D,
    0x0000, 0x0000, 0xFFF2, 0x0413, 0x0000, 0x0000, 0xFFF2, 0x0355,
    0x0000, 0x0000, 0xFFF2, 0x02D2, 0x0000, 0x0000, 0xFFF2, 0x0272,
    0x0000, 0x0000, 0xFFF2, 0x0228, 0x0000, 0x0000, 0xFFF2, 0x01EE,
    0x0000, 0x0000, 0xFFF2, 0x01BF, 0x0000, 0x0000, 0xFFF2, 0x0198,
    0x0000, 0x0000, 0xFFF2, 0x0177, 0x0000, 0x0000, 0xFFF2, 0x015B,
    0x0000, 0x0000, 0xFFF2, 0x0143, 0x0000, 0x0000, 0xFFF2, 0x012F,
    0x0000, 0x0000, 0xFFF2, 0x011C, 0x0000, 0x0000, 0xFFF2, 0x010C,
    0x0000, 0x0000, 0xFFF2, 0x00FD, 0x0000, 0x0000, 0xFFF2, 0x00F0,
    0x0000, 0x0000, 0xFFF2, 0x00E5, 0x0000, 0x0000, 0xFFF2, 0x00DA,
    0x0000, 0x0000, 0xFFF2, 0x00D0, 0x0000, 0x0000, 0xFFF2, 0x00C7,
    0x0000, 0x0000, 0xFFF2, 0x00BF, 0x0000, 0x0000, 0xFFF2, 0x00B8,
    0x0000, 0x0000, 0xFFF2, 0x00B1, 0x0000, 0x0000, 0xFFF2, 0x00AA,
    0x0000, 0x0000, 0xFFF2, 0x00A4, 0x0000, 0x0000, 0xFFF2, 0x009F,
    0x0000, 0x0000, 0xFFF2, 0x0099, 0x0000, 0x0000, 0xFFF2, 0x0095,
    0x0000, 0x0000, 0xFFF2, 0x0090, 0x0000, 0x0000, 0xFFF2, 0x008C,
    0x0000, 0x0000, 0xFFF2, 0x0088, 0x0000, 0x0000, 0xFFF2, 0x0084,
    0x0000, 0x0000, 0xFFF2, 0x0080, 0x0000, 0x0000, 0xFFF2, 0x007D,
    0x0000, 0x0000, 0xFFF2, 0x0079, 0x0000, 0x0000, 0xFFF2, 0x0076,
    0x0000, 0x0000, 0xFFF2, 0x0073, 0x0000, 0x0000, 0xFFF2, 0x0070,
    0x0000, 0x0000, 0xFFF2, 0x006E, 0x0000, 0x0000, 0xFFF2, 0x006B,
    0x0000, 0x0000, 0xFFF2, 0x0069, 0x0000, 0x0000, 0xFFF2, 0x0066,
    0x0000, 0x0000, 0xFFF2, 0x0064, 0x0000, 0x0000, 0xFFF2, 0x0062,
    0x0000, 0x0000, 0xFFF2, 0x0060, 0x0000, 0x0000, 0xFFF2, 0x005E,
    0x0000, 0x0000, 0xFFF2, 0x005C, 0x0000, 0x0000, 0xFFF2, 0x005A,
    0x0000, 0x0000, 0xFFF2, 0x0059, 0x0000, 0x0000, 0xFFF2, 0x0057,
    0x0000, 0x0000, 0xFFF2, 0x0055, 0x0000, 0x0000, 0xFFF2, 0x0054,
    0x0000, 0x0000, 0xFFF2, 0x0052, 0x0000, 0x0000, 0xFFF2, 0x0051,
    0x0000, 0x0000, 0xFFF2, 0x004F, 0x0000, 0x0000, 0xFFF2, 0x004E,
    0x0000, 0x0000, 0xFFF2, 0x004D, 0x0000, 0x0000, 0xFFF2, 0x004B,
    0x0000, 0x0000, 0xFFF2, 0x004A, 0x0000, 0x0000, 0xFFF2, 0x0049,
    0x0000, 0x0000, 0xFFF2, 0x0048, 0x0000, 0x0000, 0xFFF2, 0x0047,
    0x0000, 0x0000, 0xFFF2, 0x0046, 0x0000, 0x0000, 0xFFF2, 0x0045,
    0x0000, 0x0000, 0xFFF2, 0x0044, 0x0000, 0x0000, 0xFFF2, 0x0043,
    0x0000, 0x0000, 0xFFF2, 0x0042, 0x0000, 0x0000, 0xFFF2, 0x0041,
    0x0000, 0x0000, 0xFFF2, 0x0040, 0x0000, 0x0000, 0xFFF2, 0x003F,
    0x0000, 0x0000, 0xFFF2, 0x003E, 0x0000, 0x0000, 0xFFF2, 0x003D,
    0x0000, 0x0000, 0xFFF2, 0x003C, 0x0000, 0x0000, 0xFFF2, 0x003B,
    0x0000, 0x0000, 0xFFF2, 0x003B, 0x0000, 0x0000, 0xFFF2, 0x003A,
    0x0000, 0x0000, 0xFFF2, 0x0039, 0x0000, 0x0000, 0xFFF2, 0x0038,
    0x0000, 0x0000, 0xFFF2, 0x0038, 0x0000, 0x0000, 0xFFF2, 0x0037,
    0x0000, 0x0000, 0xFFF2, 0x0036, 0x0000, 0x0000, 0xFFF2, 0x0036,
    0x0000, 0x0000, 0xFFF2, 0x0035, 0x0000, 0x0000, 0xFFF2, 0x0034,
    0x0000, 0x0000, 0xFFF2, 0x0034, 0x0000, 0x0000, 0xFFF2, 0x0033,
    0x0000, 0x0000, 0xFFF2, 0x0033, 0x0000, 0x0000, 0xFFF2, 0x0032,
    0x0000, 0x0000, 0xFFF2, 0x0031, 0x0000, 0x0000, 0xFFF2, 0x0031,
    0x0000, 0x0000, 0xFFF2, 0x0030, 0x0000, 0x0000, 0xFFF2, 0x0030,
    0x0000, 0x0000, 0xFFF2, 0x002F, 0x0000, 0x0000, 0xFFF2, 0x002F,
    0x0000, 0x0000, 0xFFF2, 0x002E, 0x0000, 0x0000, 0xFFF2, 0x002E,
    0x0000, 0x0000, 0xFFF2, 0x002D, 0x0000, 0x0000, 0xFFF2, 0x002D,
    0x0000, 0x0000, 0xFFF2, 0x002C, 0x0000, 0x0000, 0xFFF2, 0x002C,
    0x0000, 0x0000, 0xFFF2, 0x002B, 0x0000, 0x0000, 0xFFF2, 0x002B,
    0x0000, 0x0000, 0xFFF2, 0x002A, 0x0000, 0x0000, 0xFFF2, 0x002A,
    0x0000, 0x0000, 0xFFF2, 0x002A, 0x0000, 0x0000, 0xFFF2, 0x0029,
    0x0000, 0x0000, 0xFFF2, 0x0029, 0x0000, 0x0000, 0xFFF2, 0x0028,
    0x0000, 0x0000, 0xFFF2, 0x0028, 0x0000, 0x0000, 0xFFF2, 0x0028,
    0x0000, 0x0000, 0xFFF2, 0x0027, 0x0000, 0x0000, 0xFFF2, 0x0027,
    0x0000, 0x0000, 0xFFF2, 0x0027, 0x0000, 0x0000, 0xFFF2, 0x0026,
    0x0000, 0x0000, 0xFFF2, 0x0026, 0x0000, 0x0000, 0xFFF2, 0x0026,
    0x0000, 0x0000, 0xFFF2, 0x0025, 0x0000, 0x0000, 0xFFF2, 0x0025,
    0x0000, 0x0000, 0xFFF2, 0x0024, 0x0000, 0x0000, 0xFFF2, 0x0024,
    0x0000, 0x0000, 0xFFF2, 0x0024, 0x0000, 0x0000, 0xFFF2, 0x0024,
    0x0000, 0x0000, 0xFFF2, 0x0023, 0x0000, 0x0000, 0xFFF2, 0x0023,
    0x0000, 0x0000, 0xFFF2, 0x0023, 0x0000, 0x0000, 0xFFF2, 0x0022,
    0x0000, 0x0000, 0xFFF2, 0x0022, 0x0000, 0x0000, 0xFFF2, 0x0022,
    0x0000, 0x0000, 0xFFF2, 0x0021, 0x0000, 0x0000, 0xFFF2, 0x0021,
    0x0000, 0x0000, 0xFFF2, 0x0021, 0x0000, 0x0000, 0xFFF2, 0x0021,
    0x0000, 0x0000, 0xFFF2, 0x0020, 0x0000, 0x0000, 0xFFF2, 0x0020,
    0x0000, 0x0000, 0xFFF2, 0x0020, 0x0000, 0x0000, 0xFFF2, 0x0020,
    0x0000, 0x0000, 0xFFF2, 0x001F, 0x0000, 0x0000, 0xFFF2, 0x001F,
    0x0000, 0x0000, 0xFFF2, 0x001F, 0x0000, 0x0000, 0xFFF2, 0x001F,
    0x0000, 0x0000, 0xFFF2, 0x001E, 0x0000, 0x0000, 0xFFF2, 0x001E,
    0x0000, 0x0000, 0xFFF2, 0x001E, 0x0000, 0x0000, 0xFFF2, 0x001E,
    0x0000, 0x0000, 0xFFF2, 0x001D, 0x0000, 0x0000, 0xFFF2, 0x001D,
    0x0000, 0x0000, 0xFFF2, 0x001D, 0x0000, 0x0000, 0xFFF2, 0x001D,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001C,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001C,
    0x0000, 0x0000, 0xFFF2, 0x001C, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001B, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001B, 0x0000, 0x0000, 0xFFF2, 0x001B,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x001A, 0x0000, 0x0000, 0xFFF2, 0x001A,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0019,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0019,
    0x0000, 0x0000, 0xFFF2, 0x0019, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0018,
    0x0000, 0x0000, 0xFFF2, 0x0018, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0017, 0x0000, 0x0000, 0xFFF2, 0x0017,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0016, 0x0000, 0x0000, 0xFFF2, 0x0016,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0015, 0x0000, 0x0000, 0xFFF2, 0x0015,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0014,
    0x0000, 0x0000, 0xFFF2, 0x0014, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0013, 0x0000, 0x0000, 0xFFF2, 0x0013,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0012, 0x0000, 0x0000, 0xFFF2, 0x0012,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0011, 0x0000, 0x0000, 0xFFF2, 0x0011,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x0010, 0x0000, 0x0000, 0xFFF2, 0x0010,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000F,
    0x0000, 0x0000, 0xFFF2, 0x000F, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000E,
    0x0000, 0x0000, 0xFFF2, 0x000E, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000D,
    0x0000, 0x0000, 0xFFF2, 0x000D, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000C, 0x0000, 0x0000, 0xFFF2, 0x000C,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000B,
    0x0000, 0x0000, 0xFFF2, 0x000B, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x000A, 0x0000, 0x0000, 0xFFF2, 0x000A,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0009, 0x0000, 0x0000, 0xFFF2, 0x0009,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0008,
    0x0000, 0x0000, 0xFFF2, 0x0008, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0007, 0x0000, 0x0000, 0xFFF2, 0x0007,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0006,
    0x0000, 0x0000, 0xFFF2, 0x0006, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0005,
    0x0000, 0x0000, 0xFFF2, 0x0005, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0004, 0x0000, 0x0000, 0xFFF2, 0x0004,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0003, 0x0000, 0x0000, 0xFFF2, 0x0003,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0002, 0x0000, 0x0000, 0xFFF2, 0x0002,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0001,
    0x0000, 0x0000, 0xFFF2, 0x0001, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000, 0x0000, 0xFFF2, 0x0000, 0x0000, 0x0000, 0xFFF2, 0x0000,
    0x0000
    };

static const q15_t in_rfft_step_4096[4096] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333,
    0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333, 0x7333
    };

static const q15_t in_rifft_step_4096[8194] = {
    0x399A, 0x0000, 0xFFF9, 0x24AB, 0x0000, 0x0000, 0xFFF9, 0x0C39,
    0x0000, 0x0000, 0xFFF9, 0x0755, 0x0000, 0x0000, 0xFFF9, 0x053D,
    0x0000, 0x0000, 0xFFF9, 0x0413, 0x0000, 0x0000, 0xFFF9, 0x0355,
    0x0000, 0x0000, 0xFFF9, 0x02D2, 0x0000, 0x0000, 0xFFF9, 0x0272,
    0x0000, 0x0000, 0xFFF9, 0x0228, 0x0000, 0x0000, 0xFFF9, 0x01EE,
    0x0000, 0x0000, 0xFFF9, 0x01BF, 0x0000, 0x0000, 0xFFF9, 0x0198,
    0x0000, 0x0000, 0xFFF9, 0x0177, 0x0000, 0x0000, 0xFFF9, 0x015C,
    0x0000, 0x0000, 0xFFF9, 0x0144, 0x0000, 0x0000, 0xFFF9, 0x012F,
    0x0000, 0x0000, 0xFFF9, 0x011C, 0x0000, 0x0000, 0xFFF9, 0x010C,
    0x0000, 0x0000, 0xFFF9, 0x00FE, 0x0000, 0x0000, 0xFFF9, 0x00F1,
    0x0000, 0x0000, 0xFFF9, 0x00E5, 0x0000, 0x0000, 0xFFF9, 0x00DA,
    0x0000, 0x0000, 0xFFF9, 0x00D1, 0x0000, 0x0000, 0xFFF9, 0x00C8,
    0x0000, 0x0000, 0xFFF9, 0x00BF, 0x0000, 0x0000, 0xFFF9, 0x00B8,
    0x0000, 0x0000, 0xFFF9, 0x00B1, 0x0000, 0x0000, 0xFFF9, 0x00AB,
    0x0000, 0x0000, 0xFFF9, 0x00A5, 0x0000, 0x0000, 0xFFF9, 0x009F,
    0x0000, 0x0000, 0xFFF9, 0x009A, 0x0000, 0x0000, 0xFFF9, 0x0095,
    0x0000, 0x0000, 0xFFF9, 0x0090, 0x0000, 0x0000, 0xFFF9, 0x008C,
    0x0000, 0x0000, 0xFFF9, 0x0088, 0x0000, 0x0000, 0xFFF9, 0x0084,
    0x0000, 0x0000, 0xFFF9, 0x0080, 0x0000, 0x0000, 0xFFF9, 0x007D,
    0x0000, 0x0000, 0xFFF9, 0x007A, 0x0000, 0x0000, 0xFFF9, 0x0077,
    0x0000, 0x0000, 0xFFF9, 0x0074, 0x0000, 0x0000, 0xFFF9, 0x0071,
    0x0000, 0x0000, 0xFFF9, 0x006E, 0x0000, 0x0000, 0xFFF9, 0x006C,
    0x0000, 0x0000, 0xFFF9, 0x0069, 0x0000, 0x0000, 0xFFF9, 0x0067,
    0x0000, 0x0000, 0xFFF9, 0x0065, 0x0000, 0x0000, 0xFFF9, 0x0063,
    0x0000, 0x0000, 0xFFF9, 0x0061, 0x0000, 0x0000, 0xFFF9, 0x005F,
    0x0000, 0x0000, 0xFFF9, 0x005D, 0x0000, 0x0000, 0xFFF9, 0x005B,
    0x0000, 0x0000, 0xFFF9, 0x0059, 0x0000, 0x0000, 0xFFF9, 0x0058,
    0x0000, 0x0000, 0xFFF9, 0x0056, 0x0000, 0x0000, 0xFFF9, 0x0054,
    0x0000, 0x0000, 0xFFF9, 0x0053, 0x0000, 0x0000, 0xFFF9, 0x0051,
    0x0000, 0x0000, 0xFFF9, 0x0050, 0x0000, 0x0000, 0xFFF9, 0x004F,
    0x0000, 0x0000, 0xFFF9, 0x004D, 0x0000, 0x0000, 0xFFF9, 0x004C,
    0x0000, 0x0000, 0xFFF9, 0x004B, 0x0000, 0x0000, 0xFFF9, 0x004A,
    0x0000, 0x0000, 0xFFF9, 0x0049, 0x0000, 0x0000, 0xFFF9, 0x0047,
    0x0000, 0x0000, 0xFFF9, 0x0046, 0x0000, 0x0000, 0xFFF9, 0x0045,
    0x0000, 0x0000, 0xFFF9, 0x0044, 0x0000, 0x0000, 0xFFF9, 0x0043,
    0x0000, 0x0000, 0xFFF9, 0x0042, 0x0000, 0x0000, 0xFFF9, 0x0041,
    0x0000, 0x0000, 0xFFF9, 0x0040, 0x0000, 0x0000, 0xFFF9, 0x0040,
    0x0000, 0x0000, 0xFFF9, 0x003F, 0x0000, 0x0000, 0xFFF9, 0x003E,
    0x0000, 0x0000, 0xFFF9, 0x003D, 0x0000, 0x0000, 0xFFF9, 0x003C,
    0x0000, 0x0000, 0xFFF9, 0x003C, 0x0000, 0x0000, 0xFFF9, 0x003B,
    0x0000, 0x0000, 0xFFF9, 0x003A, 0x0000, 0x0000, 0xFFF9, 0x0039,
    0x0000, 0x0000, 0xFFF9, 0x0039, 0x0000, 0x0000, 0xFFF9, 0x0038,
    0x0000, 0x0000, 0xFFF9, 0x0037, 0x0000, 0x0000, 0xFFF9, 0x0037,
    0x0000, 0x0000, 0xFFF9, 0x0036, 0x0000, 0x0000, 0xFFF9, 0x0035,
    0x0000, 0x0000, 0xFFF9, 0x0035, 0x0000, 0x0000, 0xFFF9, 0x0034,
    0x0000, 0x0000, 0xFFF9, 0x0034, 0x0000, 0x0000, 0xFFF9, 0x0033,
    0x0000, 0x0000, 0xFFF9, 0x0032, 0x0000, 0x0000, 0xFFF9, 0x0032,
    0x0000, 0x0000, 0xFFF9, 0x0031, 0x0000, 0x0000, 0xFFF9, 0x0031,
    0x0000, 0x0000, 0xFFF9, 0x0030, 0x0000, 0x0000, 0xFFF9, 0x0030,
    0x0000, 0x0000, 0xFFF9, 0x002F, 0x0000, 0x0000, 0xFFF9, 0x002F,
    0x0000, 0x0000, 0xFFF9, 0x002E, 0x0000, 0x0000, 0xFFF9, 0x002E,
    0x0000, 0x0000, 0xFFF9, 0x002D, 0x0000, 0x0000, 0xFFF9, 0x002D,
    0x0000, 0x0000, 0xFFF9, 0x002D, 0x0000, 0x0000, 0xFFF9, 0x002C,
    0x0000, 0x0000, 0xFFF9, 0x002C, 0x0000, 0x0000, 0xFFF9, 0x002B,
    0x0000, 0x0000, 0xFFF9, 0x002B, 0x0000, 0x0000, 0xFFF9, 0x002A,
    0x0000, 0x0000, 0xFFF9, 0x002A, 0x0000, 0x0000, 0xFFF9, 0x002A,
    0x0000, 0x0000, 0xFFF9, 0x0029, 0x0000, 0x0000, 0xFFF9, 0x0029,
    0x0000, 0x0000, 0xFFF9, 0x0029, 0x0000, 0x0000, 0xFFF9, 0x0028,
    0x0000, 0x0000, 0xFFF9, 0x0028, 0x0000, 0x0000, 0xFFF9, 0x0028,
    0x0000, 0x0000, 0xFFF9, 0x0027, 0x0000, 0x0000, 0xFFF9, 0x0027,
    0x0000, 0x0000, 0xFFF9, 0x0027, 0x0000, 0x0000, 0xFFF9, 0x0026,
    0x0000, 0x0000, 0xFFF9, 0x0026, 0x0000, 0x0000, 0xFFF9, 0x0026,
    0x0000, 0x0000, 0xFFF9, 0x0025, 0x0000, 0x0000, 0xFFF9, 0x0025,
    0x0000, 0x0000, 0xFFF9, 0x0025, 0x0000, 0x0000, 0xFFF9, 0x0024,
    0x0000, 0x0000, 0xFFF9, 0x0024, 0x0000, 0x0000, 0xFFF9, 0x0024,
    0x0000, 0x0000, 0xFFF9, 0x0023, 0x0000, 0x0000, 0xFFF9, 0x0023,
    0x0000, 0x0000, 0xFFF9, 0x0023, 0x0000, 0x0000, 0xFFF9, 0x0023,
    0x0000, 0x0000, 0xFFF9, 0x0022, 0x0000, 0x0000, 0xFFF9, 0x0022,
    0x0000, 0x0000, 0xFFF9, 0x0022, 0x0000, 0x0000, 0xFFF9, 0x0022,
    0x0000, 0x0000, 0xFFF9, 0x0021, 0x0000, 0x0000, 0xFFF9, 0x0021,
    0x0000, 0x0000, 0xFFF9, 0x0021, 0x0000, 0x0000, 0xFFF9, 0x0021,
    0x0000, 0x0000, 0xFFF9, 0x0020, 0x0000, 0x0000, 0xFFF9, 0x0020,
    0x0000, 0x0000, 0xFFF9, 0x0020, 0x0000, 0x0000, 0xFFF9, 0x0020,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001F,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001F,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001E, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001E, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001D,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001D,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFF, 0x0000, 0x0000, 0xFFF9, 0xFFFF,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFE, 0x0000, 0x0000, 0xFFF9, 0xFFFE,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFD,
    0x0000, 0x0000, 0xFFF9, 0xFFFD, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFC, 0x0000, 0x0000, 0xFFF9, 0xFFFC,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFB,
    0x0000, 0x0000, 0xFFF9, 0xFFFB, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFFA,
    0x0000, 0x0000, 0xFFF9, 0xFFFA, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF9,
    0x0000, 0x0000, 0xFFF9, 0xFFF9, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF8, 0x0000, 0x0000, 0xFFF9, 0xFFF8,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF7,
    0x0000, 0x0000, 0xFFF9, 0xFFF7, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF6, 0x0000, 0x0000, 0xFFF9, 0xFFF6,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF5,
    0x0000, 0x0000, 0xFFF9, 0xFFF5, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF4,
    0x0000, 0x0000, 0xFFF9, 0xFFF4, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF3,
    0x0000, 0x0000, 0xFFF9, 0xFFF3, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF2, 0x0000, 0x0000, 0xFFF9, 0xFFF2,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF1,
    0x0000, 0x0000, 0xFFF9, 0xFFF1, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFF0, 0x0000, 0x0000, 0xFFF9, 0xFFF0,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEF, 0x0000, 0x0000, 0xFFF9, 0xFFEF,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFEE, 0x0000, 0x0000, 0xFFF9, 0xFFEE,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFED,
    0x0000, 0x0000, 0xFFF9, 0xFFED, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEC, 0x0000, 0x0000, 0xFFF9, 0xFFEC,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEB,
    0x0000, 0x0000, 0xFFF9, 0xFFEB, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFEA, 0x0000, 0x0000, 0xFFF9, 0xFFEA,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE9, 0x0000, 0x0000, 0xFFF9, 0xFFE9,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE8, 0x0000, 0x0000, 0xFFF9, 0xFFE8,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE7,
    0x0000, 0x0000, 0xFFF9, 0xFFE7, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE6,
    0x0000, 0x0000, 0xFFF9, 0xFFE6, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE5,
    0x0000, 0x0000, 0xFFF9, 0xFFE5, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE4,
    0x0000, 0x0000, 0xFFF9, 0xFFE4, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE3, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE3, 0x0000, 0x0000, 0xFFF9, 0xFFE3,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE2,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE2,
    0x0000, 0x0000, 0xFFF9, 0xFFE2, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE1, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE1, 0x0000, 0x0000, 0xFFF9, 0xFFE1,
    0x0000, 0x0000, 0xFFF9, 0xFFE0, 0x0000, 0x0000, 0xFFF9, 0xFFE0,
    0x0000, 0x0000, 0xFFF9, 0xFFE0, 0x0000, 0x0000, 0xFFF9, 0xFFE0,
    0x0000, 0x0000, 0xFFF9, 0xFFDF, 0x0000, 0x0000, 0xFFF9, 0xFFDF,
    0x0000, 0x0000, 0xFFF9, 0xFFDF, 0x0000, 0x0000, 0xFFF9, 0xFFDF,
    0x0000, 0x0000, 0xFFF9, 0xFFDE, 0x0000, 0x0000, 0xFFF9, 0xFFDE,
    0x0000, 0x0000, 0xFFF9, 0xFFDE, 0x0000, 0x0000, 0xFFF9, 0xFFDE,
    0x0000, 0x0000, 0xFFF9, 0xFFDD, 0x0000, 0x0000, 0xFFF9, 0xFFDD,
    0x0000, 0x0000, 0xFFF9, 0xFFDD, 0x0000, 0x0000, 0xFFF9, 0xFFDD,
    0x0000, 0x0000, 0xFFF9, 0xFFDC, 0x0000, 0x0000, 0xFFF9, 0xFFDC,
    0x0000, 0x0000, 0xFFF9, 0xFFDC, 0x0000, 0x0000, 0xFFF9, 0xFFDB,
    0x0000, 0x0000, 0xFFF9, 0xFFDB, 0x0000, 0x0000, 0xFFF9, 0xFFDB,
    0x0000, 0x0000, 0xFFF9, 0xFFDA, 0x0000, 0x0000, 0xFFF9, 0xFFDA,
    0x0000, 0x0000, 0xFFF9, 0xFFDA, 0x0000, 0x0000, 0xFFF9, 0xFFD9,
    0x0000, 0x0000, 0xFFF9, 0xFFD9, 0x0000, 0x0000, 0xFFF9, 0xFFD9,
    0x0000, 0x0000, 0xFFF9, 0xFFD8, 0x0000, 0x0000, 0xFFF9, 0xFFD8,
    0x0000, 0x0000, 0xFFF9, 0xFFD8, 0x0000, 0x0000, 0xFFF9, 0xFFD7,
    0x0000, 0x0000, 0xFFF9, 0xFFD7, 0x0000, 0x0000, 0xFFF9, 0xFFD7,
    0x0000, 0x0000, 0xFFF9, 0xFFD6, 0x0000, 0x0000, 0xFFF9, 0xFFD6,
    0x0000, 0x0000, 0xFFF9, 0xFFD6, 0x0000, 0x0000, 0xFFF9, 0xFFD5,
    0x0000, 0x0000, 0xFFF9, 0xFFD5, 0x0000, 0x0000, 0xFFF9, 0xFFD4,
    0x0000, 0x0000, 0xFFF9, 0xFFD4, 0x0000, 0x0000, 0xFFF9, 0xFFD3,
    0x0000, 0x0000, 0xFFF9, 0xFFD3, 0x0000, 0x0000, 0xFFF9, 0xFFD3,
    0x0000, 0x0000, 0xFFF9, 0xFFD2, 0x0000, 0x0000, 0xFFF9, 0xFFD2,
    0x0000, 0x0000, 0xFFF9, 0xFFD1, 0x0000, 0x0000, 0xFFF9, 0xFFD1,
    0x0000, 0x0000, 0xFFF9, 0xFFD0, 0x0000, 0x0000, 0xFFF9, 0xFFD0,
    0x0000, 0x0000, 0xFFF9, 0xFFCF, 0x0000, 0x0000, 0xFFF9, 0xFFCF,
    0x0000, 0x0000, 0xFFF9, 0xFFCE, 0x0000, 0x0000, 0xFFF9, 0xFFCE,
    0x0000, 0x0000, 0xFFF9, 0xFFCD, 0x0000, 0x0000, 0xFFF9, 0xFFCC,
    0x0000, 0x0000, 0xFFF9, 0xFFCC, 0x0000, 0x0000, 0xFFF9, 0xFFCB,
    0x0000, 0x0000, 0xFFF9, 0xFFCB, 0x0000, 0x0000, 0xFFF9, 0xFFCA,
    0x0000, 0x0000, 0xFFF9, 0xFFC9, 0x0000, 0x0000, 0xFFF9, 0xFFC9,
    0x0000, 0x0000, 0xFFF9, 0xFFC8, 0x0000, 0x0000, 0xFFF9, 0xFFC7,
    0x0000, 0x0000, 0xFFF9, 0xFFC7, 0x0000, 0x0000, 0xFFF9, 0xFFC6,
    0x0000, 0x0000, 0xFFF9, 0xFFC5, 0x0000, 0x0000, 0xFFF9, 0xFFC4,
    0x0000, 0x0000, 0xFFF9, 0xFFC4, 0x0000, 0x0000, 0xFFF9, 0xFFC3,
    0x0000, 0x0000, 0xFFF9, 0xFFC2, 0x0000, 0x0000, 0xFFF9, 0xFFC1,
    0x0000, 0x0000, 0xFFF9, 0xFFC0, 0x0000, 0x0000, 0xFFF9, 0xFFC0,
    0x0000, 0x0000, 0xFFF9, 0xFFBF, 0x0000, 0x0000, 0xFFF9, 0xFFBE,
    0x0000, 0x0000, 0xFFF9, 0xFFBD, 0x0000, 0x0000, 0xFFF9, 0xFFBC,
    0x0000, 0x0000, 0xFFF9, 0xFFBB, 0x0000, 0x0000, 0xFFF9, 0xFFBA,
    0x0000, 0x0000, 0xFFF9, 0xFFB9, 0x0000, 0x0000, 0xFFF9, 0xFFB7,
    0x0000, 0x0000, 0xFFF9, 0xFFB6, 0x0000, 0x0000, 0xFFF9, 0xFFB5,
    0x0000, 0x0000, 0xFFF9, 0xFFB4, 0x0000, 0x0000, 0xFFF9, 0xFFB3,
    0x0000, 0x0000, 0xFFF9, 0xFFB1, 0x0000, 0x0000, 0xFFF9, 0xFFB0,
    0x0000, 0x0000, 0xFFF9, 0xFFAF, 0x0000, 0x0000, 0xFFF9, 0xFFAD,
    0x0000, 0x0000, 0xFFF9, 0xFFAC, 0x0000, 0x0000, 0xFFF9, 0xFFAA,
    0x0000, 0x0000, 0xFFF9, 0xFFA8, 0x0000, 0x0000, 0xFFF9, 0xFFA7,
    0x0000, 0x0000, 0xFFF9, 0xFFA5, 0x0000, 0x0000, 0xFFF9, 0xFFA3,
    0x0000, 0x0000, 0xFFF9, 0xFFA1, 0x0000, 0x0000, 0xFFF9, 0xFF9F,
    0x0000, 0x0000, 0xFFF9, 0xFF9D, 0x0000, 0x0000, 0xFFF9, 0xFF9B,
    0x0000, 0x0000, 0xFFF9, 0xFF99, 0x0000, 0x0000, 0xFFF9, 0xFF97,
    0x0000, 0x0000, 0xFFF9, 0xFF94, 0x0000, 0x0000, 0xFFF9, 0xFF92,
    0x0000, 0x0000, 0xFFF9, 0xFF8F, 0x0000, 0x0000, 0xFFF9, 0xFF8C,
    0x0000, 0x0000, 0xFFF9, 0xFF89, 0x0000, 0x0000, 0xFFF9, 0xFF86,
    0x0000, 0x0000, 0xFFF9, 0xFF83, 0x0000, 0x0000, 0xFFF9, 0xFF80,
    0x0000, 0x0000, 0xFFF9, 0xFF7C, 0x0000, 0x0000, 0xFFF9, 0xFF78,
    0x0000, 0x0000, 0xFFF9, 0xFF74, 0x0000, 0x0000, 0xFFF9, 0xFF70,
    0x0000, 0x0000, 0xFFF9, 0xFF6B, 0x0000, 0x0000, 0xFFF9, 0xFF66,
    0x0000, 0x0000, 0xFFF9, 0xFF61, 0x0000, 0x0000, 0xFFF9, 0xFF5B,
    0x0000, 0x0000, 0xFFF9, 0xFF55, 0x0000, 0x0000, 0xFFF9, 0xFF4F,
    0x0000, 0x0000, 0xFFF9, 0xFF48, 0x0000, 0x0000, 0xFFF9, 0xFF41,
    0x0000, 0x0000, 0xFFF9, 0xFF38, 0x0000, 0x0000, 0xFFF9, 0xFF2F,
    0x0000, 0x0000, 0xFFF9, 0xFF26, 0x0000, 0x0000, 0xFFF9, 0xFF1B,
    0x0000, 0x0000, 0xFFF9, 0xFF0F, 0x0000, 0x0000, 0xFFF9, 0xFF02,
    0x0000, 0x0000, 0xFFF9, 0xFEF4, 0x0000, 0x0000, 0xFFF9, 0xFEE4,
    0x0000, 0x0000, 0xFFF9, 0xFED1, 0x0000, 0x0000, 0xFFF9, 0xFEBC,
    0x0000, 0x0000, 0xFFF9, 0xFEA4, 0x0000, 0x0000, 0xFFF9, 0xFE89,
    0x0000, 0x0000, 0xFFF9, 0xFE68, 0x0000, 0x0000, 0xFFF9, 0xFE41,
    0x0000, 0x0000, 0xFFF9, 0xFE12, 0x0000, 0x0000, 0xFFF9, 0xFDD8,
    0x0000, 0x0000, 0xFFF9, 0xFD8E, 0x0000, 0x0000, 0xFFF9, 0xFD2E,
    0x0000, 0x0000, 0xFFF9, 0xFCAB, 0x0000, 0x0000, 0xFFF9, 0xFBED,
    0x0000, 0x0000, 0xFFF9, 0xFAC3, 0x0000, 0x0000, 0xFFF9, 0xF8AB,
    0x0000, 0x0000, 0xFFF9, 0xF3C7, 0x0000, 0x0000, 0xFFF9, 0xDB55,
    0x0000, 0x0000
    };

static const q15_t ref_rfft_step_4096[4097] = {
    0x399A, 0x0000, 0xFFF9, 0x24AB, 0x0000, 0x0000, 0xFFF9, 0x0C39,
    0x0000, 0x0000, 0xFFF9, 0x0755, 0x0000, 0x0000, 0xFFF9, 0x053D,
    0x0000, 0x0000, 0xFFF9, 0x0413, 0x0000, 0x0000, 0xFFF9, 0x0355,
    0x0000, 0x0000, 0xFFF9, 0x02D2, 0x0000, 0x0000, 0xFFF9, 0x0272,
    0x0000, 0x0000, 0xFFF9, 0x0228, 0x0000, 0x0000, 0xFFF9, 0x01EE,
    0x0000, 0x0000, 0xFFF9, 0x01BF, 0x0000, 0x0000, 0xFFF9, 0x0198,
    0x0000, 0x0000, 0xFFF9, 0x0177, 0x0000, 0x0000, 0xFFF9, 0x015C,
    0x0000, 0x0000, 0xFFF9, 0x0144, 0x0000, 0x0000, 0xFFF9, 0x012F,
    0x0000, 0x0000, 0xFFF9, 0x011C, 0x0000, 0x0000, 0xFFF9, 0x010C,
    0x0000, 0x0000, 0xFFF9, 0x00FE, 0x0000, 0x0000, 0xFFF9, 0x00F1,
    0x0000, 0x0000, 0xFFF9, 0x00E5, 0x0000, 0x0000, 0xFFF9, 0x00DA,
    0x0000, 0x0000, 0xFFF9, 0x00D1, 0x0000, 0x0000, 0xFFF9, 0x00C8,
    0x0000, 0x0000, 0xFFF9, 0x00BF, 0x0000, 0x0000, 0xFFF9, 0x00B8,
    0x0000, 0x0000, 0xFFF9, 0x00B1, 0x0000, 0x0000, 0xFFF9, 0x00AB,
    0x0000, 0x0000, 0xFFF9, 0x00A5, 0x0000, 0x0000, 0xFFF9, 0x009F,
    0x0000, 0x0000, 0xFFF9, 0x009A, 0x0000, 0x0000, 0xFFF9, 0x0095,
    0x0000, 0x0000, 0xFFF9, 0x0090, 0x0000, 0x0000, 0xFFF9, 0x008C,
    0x0000, 0x0000, 0xFFF9, 0x0088, 0x0000, 0x0000, 0xFFF9, 0x0084,
    0x0000, 0x0000, 0xFFF9, 0x0080, 0x0000, 0x0000, 0xFFF9, 0x007D,
    0x0000, 0x0000, 0xFFF9, 0x007A, 0x0000, 0x0000, 0xFFF9, 0x0077,
    0x0000, 0x0000, 0xFFF9, 0x0074, 0x0000, 0x0000, 0xFFF9, 0x0071,
    0x0000, 0x0000, 0xFFF9, 0x006E, 0x0000, 0x0000, 0xFFF9, 0x006C,
    0x0000, 0x0000, 0xFFF9, 0x0069, 0x0000, 0x0000, 0xFFF9, 0x0067,
    0x0000, 0x0000, 0xFFF9, 0x0065, 0x0000, 0x0000, 0xFFF9, 0x0063,
    0x0000, 0x0000, 0xFFF9, 0x0061, 0x0000, 0x0000, 0xFFF9, 0x005F,
    0x0000, 0x0000, 0xFFF9, 0x005D, 0x0000, 0x0000, 0xFFF9, 0x005B,
    0x0000, 0x0000, 0xFFF9, 0x0059, 0x0000, 0x0000, 0xFFF9, 0x0058,
    0x0000, 0x0000, 0xFFF9, 0x0056, 0x0000, 0x0000, 0xFFF9, 0x0054,
    0x0000, 0x0000, 0xFFF9, 0x0053, 0x0000, 0x0000, 0xFFF9, 0x0051,
    0x0000, 0x0000, 0xFFF9, 0x0050, 0x0000, 0x0000, 0xFFF9, 0x004F,
    0x0000, 0x0000, 0xFFF9, 0x004D, 0x0000, 0x0000, 0xFFF9, 0x004C,
    0x0000, 0x0000, 0xFFF9, 0x004B, 0x0000, 0x0000, 0xFFF9, 0x004A,
    0x0000, 0x0000, 0xFFF9, 0x0049, 0x0000, 0x0000, 0xFFF9, 0x0047,
    0x0000, 0x0000, 0xFFF9, 0x0046, 0x0000, 0x0000, 0xFFF9, 0x0045,
    0x0000, 0x0000, 0xFFF9, 0x0044, 0x0000, 0x0000, 0xFFF9, 0x0043,
    0x0000, 0x0000, 0xFFF9, 0x0042, 0x0000, 0x0000, 0xFFF9, 0x0041,
    0x0000, 0x0000, 0xFFF9, 0x0040, 0x0000, 0x0000, 0xFFF9, 0x0040,
    0x0000, 0x0000, 0xFFF9, 0x003F, 0x0000, 0x0000, 0xFFF9, 0x003E,
    0x0000, 0x0000, 0xFFF9, 0x003D, 0x0000, 0x0000, 0xFFF9, 0x003C,
    0x0000, 0x0000, 0xFFF9, 0x003C, 0x0000, 0x0000, 0xFFF9, 0x003B,
    0x0000, 0x0000, 0xFFF9, 0x003A, 0x0000, 0x0000, 0xFFF9, 0x0039,
    0x0000, 0x0000, 0xFFF9, 0x0039, 0x0000, 0x0000, 0xFFF9, 0x0038,
    0x0000, 0x0000, 0xFFF9, 0x0037, 0x0000, 0x0000, 0xFFF9, 0x0037,
    0x0000, 0x0000, 0xFFF9, 0x0036, 0x0000, 0x0000, 0xFFF9, 0x0035,
    0x0000, 0x0000, 0xFFF9, 0x0035, 0x0000, 0x0000, 0xFFF9, 0x0034,
    0x0000, 0x0000, 0xFFF9, 0x0034, 0x0000, 0x0000, 0xFFF9, 0x0033,
    0x0000, 0x0000, 0xFFF9, 0x0032, 0x0000, 0x0000, 0xFFF9, 0x0032,
    0x0000, 0x0000, 0xFFF9, 0x0031, 0x0000, 0x0000, 0xFFF9, 0x0031,
    0x0000, 0x0000, 0xFFF9, 0x0030, 0x0000, 0x0000, 0xFFF9, 0x0030,
    0x0000, 0x0000, 0xFFF9, 0x002F, 0x0000, 0x0000, 0xFFF9, 0x002F,
    0x0000, 0x0000, 0xFFF9, 0x002E, 0x0000, 0x0000, 0xFFF9, 0x002E,
    0x0000, 0x0000, 0xFFF9, 0x002D, 0x0000, 0x0000, 0xFFF9, 0x002D,
    0x0000, 0x0000, 0xFFF9, 0x002D, 0x0000, 0x0000, 0xFFF9, 0x002C,
    0x0000, 0x0000, 0xFFF9, 0x002C, 0x0000, 0x0000, 0xFFF9, 0x002B,
    0x0000, 0x0000, 0xFFF9, 0x002B, 0x0000, 0x0000, 0xFFF9, 0x002A,
    0x0000, 0x0000, 0xFFF9, 0x002A, 0x0000, 0x0000, 0xFFF9, 0x002A,
    0x0000, 0x0000, 0xFFF9, 0x0029, 0x0000, 0x0000, 0xFFF9, 0x0029,
    0x0000, 0x0000, 0xFFF9, 0x0029, 0x0000, 0x0000, 0xFFF9, 0x0028,
    0x0000, 0x0000, 0xFFF9, 0x0028, 0x0000, 0x0000, 0xFFF9, 0x0028,
    0x0000, 0x0000, 0xFFF9, 0x0027, 0x0000, 0x0000, 0xFFF9, 0x0027,
    0x0000, 0x0000, 0xFFF9, 0x0027, 0x0000, 0x0000, 0xFFF9, 0x0026,
    0x0000, 0x0000, 0xFFF9, 0x0026, 0x0000, 0x0000, 0xFFF9, 0x0026,
    0x0000, 0x0000, 0xFFF9, 0x0025, 0x0000, 0x0000, 0xFFF9, 0x0025,
    0x0000, 0x0000, 0xFFF9, 0x0025, 0x0000, 0x0000, 0xFFF9, 0x0024,
    0x0000, 0x0000, 0xFFF9, 0x0024, 0x0000, 0x0000, 0xFFF9, 0x0024,
    0x0000, 0x0000, 0xFFF9, 0x0023, 0x0000, 0x0000, 0xFFF9, 0x0023,
    0x0000, 0x0000, 0xFFF9, 0x0023, 0x0000, 0x0000, 0xFFF9, 0x0023,
    0x0000, 0x0000, 0xFFF9, 0x0022, 0x0000, 0x0000, 0xFFF9, 0x0022,
    0x0000, 0x0000, 0xFFF9, 0x0022, 0x0000, 0x0000, 0xFFF9, 0x0022,
    0x0000, 0x0000, 0xFFF9, 0x0021, 0x0000, 0x0000, 0xFFF9, 0x0021,
    0x0000, 0x0000, 0xFFF9, 0x0021, 0x0000, 0x0000, 0xFFF9, 0x0021,
    0x0000, 0x0000, 0xFFF9, 0x0020, 0x0000, 0x0000, 0xFFF9, 0x0020,
    0x0000, 0x0000, 0xFFF9, 0x0020, 0x0000, 0x0000, 0xFFF9, 0x0020,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001F,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001F,
    0x0000, 0x0000, 0xFFF9, 0x001F, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001E, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001E, 0x0000, 0x0000, 0xFFF9, 0x001E,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001D,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001D,
    0x0000, 0x0000, 0xFFF9, 0x001D, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001C,
    0x0000, 0x0000, 0xFFF9, 0x001C, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001B,
    0x0000, 0x0000, 0xFFF9, 0x001B, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x001A,
    0x0000, 0x0000, 0xFFF9, 0x001A, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0019, 0x0000, 0x0000, 0xFFF9, 0x0019,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0018, 0x0000, 0x0000, 0xFFF9, 0x0018,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0017, 0x0000, 0x0000, 0xFFF9, 0x0017,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0016,
    0x0000, 0x0000, 0xFFF9, 0x0016, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0015, 0x0000, 0x0000, 0xFFF9, 0x0015,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0014,
    0x0000, 0x0000, 0xFFF9, 0x0014, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0013, 0x0000, 0x0000, 0xFFF9, 0x0013,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0012, 0x0000, 0x0000, 0xFFF9, 0x0012,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0011, 0x0000, 0x0000, 0xFFF9, 0x0011,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x0010,
    0x0000, 0x0000, 0xFFF9, 0x0010, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000F, 0x0000, 0x0000, 0xFFF9, 0x000F,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000E,
    0x0000, 0x0000, 0xFFF9, 0x000E, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000D,
    0x0000, 0x0000, 0xFFF9, 0x000D, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000C,
    0x0000, 0x0000, 0xFFF9, 0x000C, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000B, 0x0000, 0x0000, 0xFFF9, 0x000B,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x000A,
    0x0000, 0x0000, 0xFFF9, 0x000A, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0009, 0x0000, 0x0000, 0xFFF9, 0x0009,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0008,
    0x0000, 0x0000, 0xFFF9, 0x0008, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0007,
    0x0000, 0x0000, 0xFFF9, 0x0007, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0006,
    0x0000, 0x0000, 0xFFF9, 0x0006, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0005, 0x0000, 0x0000, 0xFFF9, 0x0005,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0004,
    0x0000, 0x0000, 0xFFF9, 0x0004, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0003, 0x0000, 0x0000, 0xFFF9, 0x0003,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0002, 0x0000, 0x0000, 0xFFF9, 0x0002,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0001,
    0x0000, 0x0000, 0xFFF9, 0x0001, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000, 0x0000, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFF9, 0x0000,
    0x0000
    };

