# SPDX-License-Identifier: Apache-2.0

if(CONFIG_BOARD_CTCC_NRF52840)
  board_runner_args(nrfjprog "--softreset")
  board_runner_args(pyocd "--target=nrf52840" "--frequency=4000000")
  include(${ZEPHYR_BASE}/boards/common/nrfutil.board.cmake)
  include(${ZEPHYR_BASE}/boards/common/nrfjprog.board.cmake)
  include(${ZEPHYR_BASE}/boards/common/pyocd.board.cmake)
elseif(CONFIG_BOARD_CTCC_NRF9161 OR CONFIG_BOARD_CTCC_NRF9161_NS)
  if(CONFIG_BOARD_CTCC_NRF9161_NS)
    set(TFM_PUBLIC_KEY_FORMAT "full")
  endif()
  if(CONFIG_TFM_FLASH_MERGED_BINARY)
    set_property(TARGET runners_yaml_props_target PROPERTY hex_file tfm_merged.hex)
  endif()
  board_runner_args(nrfjprog "--softreset")
  board_runner_args(pyocd "--target=nrf9161" "--frequency=4000000")
  include(${ZEPHYR_BASE}/boards/common/nrfutil.board.cmake)
  include(${ZEPHYR_BASE}/boards/common/nrfjprog.board.cmake)
  include(${ZEPHYR_BASE}/boards/common/pyocd.board.cmake)
endif()
