# SPDX-License-Identifier: Apache-2.0
# The contents of this file is based on include/zephyr/linker/kobject-data.ld
# Please keep in sync

if(CONFIG_USERSPACE)

  zephyr_linker_section(NAME kobject_data GROUP ${K_OBJECTS_GROUP} ALIGN_WITH_INPUT NOINPUT)

  zephyr_linker_section_configure(
    SECTION kobject_data
    SYMBOLS z_kobject_data_begin
    )

  if(CONFIG_DYNAMIC_OBJECTS)
    # generated by gperf, this avoids errors for the first build.
    # Also, we dont have KOBJECT_DATA_SZ for the first build
    zephyr_linker_section_configure(
      SECTION kobject_data
      SYMBOLS _thread_idx_map
      MIN_SIZE ${CONFIG_MAX_THREAD_BYTES}
      PASS NOT LINKER_ZEPHYR_PREBUILT LINKER_ZEPHYR_FINAL
      )
    zephyr_linker_section_configure(
      SECTION kobject_data
      SYMBOLS _kobject_data_area_start _kobject_data_area_end
      PASS NOT LINKER_ZEPHYR_PREBUILT LINKER_ZEPHYR_FINAL
      )
  endif()

  # During LINKER_KOBJECT_PREBUILT and LINKER_ZEPHYR_PREBUILT,
  # space needs to be reserved for the rodata that will be
  # produced by gperf during the final stages of linking.
  # The alignment and size are produced by
  # scripts/build/gen_kobject_placeholders.py. These are here
  # so the addresses to kobjects would remain the same
  # during the final stages of linking (LINKER_ZEPHYR_FINAL).
  if(CONFIG_DYNAMIC_OBJECTS)
    # in LINKER_ZEPHYR_PREBUILT there is no object file defining _thread_idx_map
    # so we must have a synthetic one. Note that the size is not set here,
    # since the space is provided in the section below:
    zephyr_linker_section_configure(
      SECTION kobject_data
      SYMBOLS _thread_idx_map
      PASS LINKER_ZEPHYR_PREBUILT
      )
  endif()

  zephyr_linker_section_configure(
    SECTION kobject_data
    INPUT
    ".kobject_data.data*"
    ".kobject_data.sdata*"
    PASS LINKER_ZEPHYR_PREBUILT LINKER_ZEPHYR_FINAL
    ALIGN @KOBJECT_DATA_ALIGN,undef:4@
    MIN_SIZE @KOBJECT_DATA_SZ@
    MAX_SIZE @KOBJECT_DATA_SZ@
    SYMBOLS _kobject_data_area_start _kobject_data_area_end
    )
endif()
