/*
 * Copyright (c) 2020 Hubert Miś
 *
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * @file
 * @brief FT8XX memory map
 */

#ifndef ZEPHYR_DRIVERS_MISC_FT8XX_FT8XX_MEMORY_H_
#define ZEPHYR_DRIVERS_MISC_FT8XX_FT8XX_MEMORY_H_

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @brief FT8xx memory addresses
 * @defgroup ft8xx_memory FT8xx memory map
 * @ingroup ft8xx_interface
 * @{
 */

/** Main parts of FT800 memory map */
enum ft800_memory_map_t {
	FT800_RAM_G         = 0x000000,
	FT800_ROM_CHIPID    = 0x0C0000,
	FT800_ROM_FONT      = 0x0BB23C,
	FT800_ROM_FONT_ADDR = 0x0FFFFC,
	FT800_RAM_DL        = 0x100000,
	FT800_RAM_PAL       = 0x102000,
	FT800_REG_          = 0x102400,
	FT800_RAM_CMD       = 0x108000
};

/** Main parts of FT810 memory map */
enum ft810_memory_map_t {
	FT810_RAM_G         = 0x000000,
	FT810_RAM_DL        = 0x300000,
	FT810_REG_          = 0x302000,
	FT810_RAM_CMD       = 0x308000
};

/** FT800 register addresses */
enum ft800_register_address_t {
	FT800_REG_ID         = 0x102400,
	FT800_REG_FRAMES     = 0x102404,
	FT800_REG_CLOCK      = 0x102408,
	FT800_REG_FREQUENCY  = 0x10240C,
	FT800_REG_RENDERMODE = 0x102410,
	FT800_REG_SNAPY      = 0x102414,
	FT800_REG_SNAPSHOT   = 0x102418,
	FT800_REG_CPURESET   = 0x10241C,
	FT800_REG_TAP_CRC    = 0x102420,
	FT800_REG_TAP_MASK   = 0x102424,
	FT800_REG_HCYCLE     = 0x102428,
	FT800_REG_HOFFSET    = 0x10242C,
	FT800_REG_HSIZE      = 0x102430,
	FT800_REG_HSYNC0     = 0x102434,
	FT800_REG_HSYNC1     = 0x102438,
	FT800_REG_VCYCLE     = 0x10243C,
	FT800_REG_VOFFSET    = 0x102440,
	FT800_REG_VSIZE      = 0x102444,
	FT800_REG_VSYNC0     = 0x102448,
	FT800_REG_VSYNC1     = 0x10244C,
	FT800_REG_DLSWAP     = 0x102450,
	FT800_REG_ROTATE     = 0x102454,
	FT800_REG_OUTBITS    = 0x102458,
	FT800_REG_DITHER     = 0x10245C,
	FT800_REG_SWIZZLE    = 0x102460,
	FT800_REG_CSPREAD    = 0x102464,
	FT800_REG_PCLK_POL   = 0x102468,
	FT800_REG_PCLK       = 0x10246C,
	FT800_REG_TAG_X      = 0x102470,
	FT800_REG_TAG_Y      = 0x102474,
	FT800_REG_TAG        = 0x102478,
	FT800_REG_VOL_PB     = 0x10247C,
	FT800_REG_VOL_SOUND  = 0x102480,
	FT800_REG_SOUND      = 0x102484,
	FT800_REG_PLAY       = 0x102488,
	FT800_REG_GPIO_DIR   = 0x10248C,
	FT800_REG_GPIO       = 0x102490,

	FT800_REG_INT_FLAGS  = 0x102498,
	FT800_REG_INT_EN     = 0x10249C,
	FT800_REG_INT_MASK   = 0x1024A0,
	FT800_REG_PLAYBACK_START = 0x1024A4,
	FT800_REG_PLAYBACK_LENGTH = 0x1024A8,
	FT800_REG_PLAYBACK_READPTR = 0x1024AC,
	FT800_REG_PLAYBACK_FREQ = 0x1024B0,
	FT800_REG_PLAYBACK_FORMAT = 0x1024B4,
	FT800_REG_PLAYBACK_LOOP = 0x1024B8,
	FT800_REG_PLAYBACK_PLAY = 0x1024BC,
	FT800_REG_PWM_HZ     = 0x1024C0,
	FT800_REG_PWM_DUTY   = 0x1024C4,
	FT800_REG_MACRO_0    = 0x1024C8,
	FT800_REG_MACRO_1    = 0x1024CC,

	FT800_REG_CMD_READ   = 0x1024E4,
	FT800_REG_CMD_WRITE  = 0x1024E8,
	FT800_REG_CMD_DL     = 0x1024EC,
	FT800_REG_TOUCH_MODE = 0x1024F0,
	FT800_REG_TOUCH_ADC_MODE = 0x1024F4,
	FT800_REG_TOUCH_CHARGE = 0x1024F8,
	FT800_REG_TOUCH_SETTLE = 0x1024FC,
	FT800_REG_TOUCH_OVERSAMPLE = 0x102500,
	FT800_REG_TOUCH_RZTHRESH = 0x102504,
	FT800_REG_TOUCH_RAW_XY = 0x102508,
	FT800_REG_TOUCH_RZ   = 0x10250C,
	FT800_REG_TOUCH_SCREEN_XY = 0x102510,
	FT800_REG_TOUCH_TAG_XY = 0x102514,
	FT800_REG_TOUCH_TAG  = 0x102518,
	FT800_REG_TOUCH_TRANSFORM_A = 0x10251C,
	FT800_REG_TOUCH_TRANSFORM_B = 0x102520,
	FT800_REG_TOUCH_TRANSFORM_C = 0x102524,
	FT800_REG_TOUCH_TRANSFORM_D = 0x102528,
	FT800_REG_TOUCH_TRANSFORM_E = 0x10252C,
	FT800_REG_TOUCH_TRANSFORM_F = 0x102530,

	FT800_REG_TOUCH_DIRECT_XY = 0x102574,
	FT800_REG_TOUCH_DIRECT_Z1Z2 = 0x102578,

	FT800_REG_TRACKER    = 0x109000
};

/** FT810 register addresses */
enum ft810_register_address_t {
	FT810_REG_TRIM       = 0x10256C,

	FT810_REG_ID         = 0x302000,
	FT810_REG_FRAMES     = 0x302004,
	FT810_REG_CLOCK      = 0x302008,
	FT810_REG_FREQUENCY  = 0x30200C,
	FT810_REG_RENDERMODE = 0x302010,
	FT810_REG_SNAPY      = 0x302014,
	FT810_REG_SNAPSHOT   = 0x302018,
	FT810_REG_CPURESET   = 0x302020,
	FT810_REG_TAP_CRC    = 0x302020,
	FT810_REG_TAP_MASK   = 0x302024,
	FT810_REG_HCYCLE     = 0x30202C,
	FT810_REG_HOFFSET    = 0x302030,
	FT810_REG_HSIZE      = 0x302034,
	FT810_REG_HSYNC0     = 0x302038,
	FT810_REG_HSYNC1     = 0x30203C,
	FT810_REG_VCYCLE     = 0x302040,
	FT810_REG_VOFFSET    = 0x302044,
	FT810_REG_VSIZE      = 0x302048,
	FT810_REG_VSYNC0     = 0x30204C,
	FT810_REG_VSYNC1     = 0x302050,
	FT810_REG_DLSWAP     = 0x302054,
	FT810_REG_ROTATE     = 0x302058,
	FT810_REG_OUTBITS    = 0x30205C,
	FT810_REG_DITHER     = 0x302060,
	FT810_REG_SWIZZLE    = 0x302064,
	FT810_REG_CSPREAD    = 0x302068,
	FT810_REG_PCLK_POL   = 0x30206C,
	FT810_REG_PCLK       = 0x302070,
	FT810_REG_TAG_X      = 0x302074,
	FT810_REG_TAG_Y      = 0x302078,
	FT810_REG_TAG        = 0x30207C,
	FT810_REG_VOL_PB     = 0x302080,
	FT810_REG_VOL_SOUND  = 0x302084,
	FT810_REG_SOUND      = 0x302088,
	FT810_REG_PLAY       = 0x30208C,
	FT810_REG_GPIO_DIR   = 0x302090,
	FT810_REG_GPIO       = 0x302094,
	FT810_REG_GPIOX_DIR  = 0x302098,
	FT810_REG_GPIOX      = 0x30209C,

	FT810_REG_INT_FLAGS  = 0x3020A8,
	FT810_REG_INT_EN     = 0x3020AC,
	FT810_REG_INT_MASK   = 0x3020B0,
	FT810_REG_PLAYBACK_START = 0x3020B4,
	FT810_REG_PLAYBACK_LENGTH = 0x3020B8,
	FT810_REG_PLAYBACK_READPTR = 0x3020BC,
	FT810_REG_PLAYBACK_FREQ = 0x3020C0,
	FT810_REG_PLAYBACK_FORMAT = 0x3020C4,
	FT810_REG_PLAYBACK_LOOP = 0x3020C8,
	FT810_REG_PLAYBACK_PLAY = 0x3020CC,
	FT810_REG_PWM_HZ     = 0x3020D0,
	FT810_REG_PWM_DUTY   = 0x3020D4,

	FT810_REG_CMD_READ   = 0x3020F8,
	FT810_REG_CMD_WRITE  = 0x3020FC,
	FT810_REG_CMD_DL     = 0x302100,
	FT810_REG_TOUCH_MODE = 0x302104,
	FT810_REG_TOUCH_ADC_MODE = 0x302108,
	FT810_REG_TOUCH_CHARGE = 0x30210C,
	FT810_REG_TOUCH_SETTLE = 0x302110,
	FT810_REG_TOUCH_OVERSAMPLE = 0x302114,
	FT810_REG_TOUCH_RZTHRESH = 0x302118,
	FT810_REG_TOUCH_RAW_XY = 0x30211C,
	FT810_REG_TOUCH_RZ   = 0x302120,
	FT810_REG_TOUCH_SCREEN_XY = 0x302124,
	FT810_REG_TOUCH_TAG_XY = 0x302128,
	FT810_REG_TOUCH_TAG  = 0x30212C,
	FT810_REG_TOUCH_TRANSFORM_A = 0x302150,
	FT810_REG_TOUCH_TRANSFORM_B = 0x302154,
	FT810_REG_TOUCH_TRANSFORM_C = 0x302158,
	FT810_REG_TOUCH_TRANSFORM_D = 0x30215C,
	FT810_REG_TOUCH_TRANSFORM_E = 0x302160,
	FT810_REG_TOUCH_TRANSFORM_F = 0x302164,
	FT810_REG_TOUCH_CONFIG = 0x302168,

	FT810_REG_SPI_WIDTH  = 0x302180,

	FT810_REG_TOUCH_DIRECT_XY = 0x30218C,
	FT810_REG_TOUCH_DIRECT_Z1Z2 = 0x302190,

	FT810_REG_CMDB_SPACE = 0x302574,
	FT810_REG_CMDB_WRITE = 0x302578,

	FT810_REG_TRACKER    = 0x309000,
	FT810_REG_TRACKER1   = 0x309004,
	FT810_REG_TRACKER2   = 0x309008,
	FT810_REG_TRACKER3   = 0x30900C,
	FT810_REG_TRACKER4   = 0x309010,
	FT810_REG_MEDIAFIFO_READ = 0x309014,
	FT810_REG_MEDIAFIFO_WRITE = 0x309018,
};

/**
 * @}
 */

#ifdef __cplusplus
}
#endif

#endif /* ZEPHYR_DRIVERS_MISC_FT8XX_FT8XX_MEMORY_H_ */
