/*
 * Copyright (c) 2022 Linaro Limited
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_STM32L0_CLOCK_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_STM32L0_CLOCK_H_

#include "stm32_common_clocks.h"

/** Bus gatting clocks */
#define STM32_CLOCK_BUS_IOP     0x02c
#define STM32_CLOCK_BUS_AHB1    0x030
#define STM32_CLOCK_BUS_APB2    0x034
#define STM32_CLOCK_BUS_APB1    0x038

#define STM32_PERIPH_BUS_MIN	STM32_CLOCK_BUS_IOP
#define STM32_PERIPH_BUS_MAX	STM32_CLOCK_BUS_APB1

/** Domain clocks */
/* RM0367, §7.3.20 Clock configuration register (RCC_CCIPR) */

/** System clock */
/* defined in stm32_common_clocks.h */

/** Fixed clocks  */
/* Low speed clocks defined in stm32_common_clocks.h */
#define STM32_SRC_HSE		(STM32_SRC_LSI + 1)
#define STM32_SRC_HSI		(STM32_SRC_HSE + 1)
#define STM32_SRC_HSI48		(STM32_SRC_HSI + 1)
/** Bus clock */
#define STM32_SRC_PCLK		(STM32_SRC_HSI48 + 1)
#define STM32_SRC_TIMPCLK1	(STM32_SRC_PCLK + 1)
#define STM32_SRC_TIMPCLK2	(STM32_SRC_TIMPCLK1 + 1)

/** @brief RCC_CCIPR register offset */
#define CCIPR_REG		0x4C

/** @brief RCC_CSR register offset */
#define CSR_REG		0x50

/** @brief Device domain clocks selection helpers */
/** CCIPR devices */
#define USART1_SEL(val)		STM32_DT_CLOCK_SELECT((val), 1, 0, CCIPR_REG)
#define USART2_SEL(val)		STM32_DT_CLOCK_SELECT((val), 3, 2, CCIPR_REG)
#define LPUART1_SEL(val)	STM32_DT_CLOCK_SELECT((val), 11, 10, CCIPR_REG)
#define I2C1_SEL(val)		STM32_DT_CLOCK_SELECT((val), 13, 12, CCIPR_REG)
#define I2C3_SEL(val)		STM32_DT_CLOCK_SELECT((val), 17, 16, CCIPR_REG)
#define LPTIM1_SEL(val)		STM32_DT_CLOCK_SELECT((val), 19, 18, CCIPR_REG)
#define HSI48_SEL(val)		STM32_DT_CLOCK_SELECT((val), 26, 26, CCIPR_REG)
/** CSR devices */
#define RTC_SEL(val)		STM32_DT_CLOCK_SELECT((val), 17, 16, CSR_REG)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_STM32L0_CLOCK_H_ */
