/*
 * Copyright (c) 2025 STMicroelectronics
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_STM32MP13_CLOCK_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_STM32MP13_CLOCK_H_

#include "stm32_common_clocks.h"

/** System clock */
/* defined in stm32_common_clocks.h */
/** Fixed clocks  */
#define STM32_SRC_HSE		(STM32_SRC_LSI + 1)
#define STM32_SRC_HSI		(STM32_SRC_HSE + 1)

/** PLL outputs */
#define STM32_SRC_PLL1_P	(STM32_SRC_HSI + 1)
#define STM32_SRC_PLL2_P	(STM32_SRC_PLL1_P + 1)
#define STM32_SRC_PLL2_Q	(STM32_SRC_PLL2_P + 1)
#define STM32_SRC_PLL2_R	(STM32_SRC_PLL2_Q + 1)
#define STM32_SRC_PLL3_P	(STM32_SRC_PLL2_R + 1)
#define STM32_SRC_PLL3_Q	(STM32_SRC_PLL3_P + 1)
#define STM32_SRC_PLL3_R	(STM32_SRC_PLL3_Q + 1)
#define STM32_SRC_PLL4_P	(STM32_SRC_PLL3_R + 1)
#define STM32_SRC_PLL4_Q	(STM32_SRC_PLL4_P + 1)
#define STM32_SRC_PLL4_R	(STM32_SRC_PLL4_Q + 1)

/** Bus clocks */
#define STM32_CLOCK_BUS_APB1    0x700
#define STM32_CLOCK_BUS_APB2    0x708
#define STM32_CLOCK_BUS_APB3    0x710
#define STM32_CLOCK_BUS_APB3_S  0x718
#define STM32_CLOCK_BUS_APB4    0x728
#define STM32_CLOCK_BUS_APB4_NS	0x738
#define STM32_CLOCK_BUS_APB5    0x740
#define STM32_CLOCK_BUS_APB6    0x748
#define STM32_CLOCK_BUS_AHB2    0x750
#define STM32_CLOCK_BUS_AHB4    0x768
#define STM32_CLOCK_BUS_AHB5    0x778
#define STM32_CLOCK_BUS_AHB6    0x780

#define STM32_PERIPH_BUS_MIN	STM32_CLOCK_BUS_APB1
#define STM32_PERIPH_BUS_MAX	STM32_CLOCK_BUS_AHB6

/** @brief Device domain clocks selection helpers */
#define MCO1CFGR_REG		0x460
#define MCO2CFGR_REG		0x464
#define I2C12CKSELR_REG		0x600
#define I2C345CKSELR_REG	0x604
#define SPI2S1CKSELR_REG	0x608
#define SPI2S23CKSELR_REG	0x60c
#define SPI45CKSELR_REG		0x610
#define UART12CKSELR_REG	0x614
#define UART35CKSELR_REG	0x618
#define UART4CKSELR_REG		0x61c
#define UART6CKSELR_REG		0x620
#define UART78CKSELR_REG	0x624
#define LPTIM1CKSELR_REG	0x628
#define LPTIM23CKSELR_REG	0x62c
#define LPTIM45CKSELR_REG	0x630
#define SAI1CKSELR_REG		0x634
#define SAI2CKSELR_REG		0x638
#define FDCANCKSELR_REG		0x63c
#define SPDIFCKSELR_REG		0x640
#define ADC12CKSELR_REG		0x644
#define SDMMC12CKSELR_REG	0x648
#define ETH12CKSELR_REG		0x64c
#define USBCKSELR_REG		0x650
#define QSPICKSELR_REG		0x654
#define FMCCKSELR_REG		0x658
#define RNG1CKSELR_REG		0x65c
#define STGENCKSELR_REG		0x660
#define DCMIPPCKSELR_REG	0x664
#define SAESCKSELR_REG		0x668

/** MCO1CFGR / MCO2CFGR devices */
#define MCO1_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, MCO1CFGR_REG)
#define MCO1_PRE(val)		STM32_DT_CLOCK_SELECT((val), 7, 4, MCO1CFGR_REG)
#define MCO2_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, MCO2CFGR_REG)
#define MCO2_PRE(val)		STM32_DT_CLOCK_SELECT((val), 7, 4, MCO2CFGR_REG)

#define MCOX_ON	BIT(12)

/* MCO1 source */
#define MCO1_SEL_HSI	0
#define MCO1_SEL_HSE	1
#define MCO1_SEL_CSI	2
#define MCO1_SEL_LSI	3
#define MCO1_SEL_LSE	4

/* MCO2 source */
#define MCO2_SEL_MPU	0
#define MCO2_SEL_AXI	1
#define MCO2_SEL_MLAHB	2
#define MCO2_SEL_PLL4	3
#define MCO2_SEL_HSE	4
#define MCO2_SEL_HSI	5

/* MCO prescaler : division factor */
#define MCO_PRE_DIV_1	0
#define MCO_PRE_DIV_2	1
#define MCO_PRE_DIV_3	2
#define MCO_PRE_DIV_4	3
#define MCO_PRE_DIV_5	4
#define MCO_PRE_DIV_6	5
#define MCO_PRE_DIV_7	6
#define MCO_PRE_DIV_8	7
#define MCO_PRE_DIV_9	8
#define MCO_PRE_DIV_10	9
#define MCO_PRE_DIV_11	10
#define MCO_PRE_DIV_12	11
#define MCO_PRE_DIV_13	12
#define MCO_PRE_DIV_14	13
#define MCO_PRE_DIV_15	14
#define MCO_PRE_DIV_16	15

#define I2C12_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, I2C12CKSELR_REG)
#define I2C3_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, I2C345CKSELR_REG)
#define I2C4_SEL(val)		STM32_DT_CLOCK_SELECT((val), 5, 3, I2C345CKSELR_REG)
#define I2C5_SEL(val)		STM32_DT_CLOCK_SELECT((val), 8, 6, I2C345CKSELR_REG)
#define SPI1_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, SPI2S1CKSELR_REG)
#define SPI23_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, SPI2S23CKSELR_REG)
#define SPI4_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, SPI45CKSELR_REG)
#define SPI5_SEL(val)		STM32_DT_CLOCK_SELECT((val), 5, 3, SPI45CKSELR_REG)
#define UART1_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, UART12CKSELR_REG)
#define UART2_SEL(val)		STM32_DT_CLOCK_SELECT((val), 5, 3, UART12CKSELR_REG)
#define UART35_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, UART35CKSELR_REG)
#define UART4_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, UART4CKSELR_REG)
#define UART6_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, UART6CKSELR_REG)
#define UART78_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, UART78CKSELR_REG)
#define LPTIME1_SEL(val)	STM32_DT_CLOCK_SELECT((val), 2, 0, LPTIM1CKSELR_REG)
#define LPTIME2_SEL(val)	STM32_DT_CLOCK_SELECT((val), 2, 0, LPTIM23CKSELR_REG)
#define LPTIME3_SEL(val)	STM32_DT_CLOCK_SELECT((val), 5, 3, LPTIM23CKSELR_REG)
#define LPTIME45_SEL(val)	STM32_DT_CLOCK_SELECT((val), 2, 0, LPTIM45CKSELR_REG)
#define SAI1_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, SAI1CKSELR_REG)
#define SAI2_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, SAI2CKSELR_REG)
#define FDCAN_SEL(val)		STM32_DT_CLOCK_SELECT((val), 1, 0, FDCANCKSELR_REG)
#define SPDIF_SEL(val)		STM32_DT_CLOCK_SELECT((val), 1, 0, SPDIFCKSELR_REG)
#define ADC1_SEL(val)		STM32_DT_CLOCK_SELECT((val), 1, 0, ADC12CKSELR_REG)
#define ADC2_SEL(val)		STM32_DT_CLOCK_SELECT((val), 3, 2, ADC12CKSELR_REG)
#define SDMMC1_SEL(val)		STM32_DT_CLOCK_SELECT((val), 2, 0, SDMMC12CKSELR_REG)
#define SDMMC2_SEL(val)		STM32_DT_CLOCK_SELECT((val), 5, 3, SDMMC12CKSELR_REG)
#define ETH1_SEL(val)		STM32_DT_CLOCK_SELECT((val), 1, 0, ETH12CKSELR_REG)
#define ETH2_SEL(val)		STM32_DT_CLOCK_SELECT((val), 9, 8, ETH12CKSELR_REG)
#define USBPHY_SEL(val)		STM32_DT_CLOCK_SELECT((val), 1, 0, USBCKSELR_REG)
#define USBOTG_SEL(val)		STM32_DT_CLOCK_SELECT((val), 4, 4, USBCKSELR_REG)
#define QSPI_SEL(val)		STM32_DT_CLOCK_SELECT((val), 1, 0, QSPICKSELR_REG)
#define FMC_SEL(val)		STM32_DT_CLOCK_SELECT((val), 1, 0, FMCCKSELR_REG)
#define RNG1_SEL(val)		STM32_DT_CLOCK_SELECT((val), 1, 0, RNG1CKSELR_REG)
#define STGEN_SEL(val)		STM32_DT_CLOCK_SELECT((val), 1, 0, STGENCKSELR_REG)
#define DCMIPP_SEL(val)		STM32_DT_CLOCK_SELECT((val), 1, 0, DCMIPPCKSELR_REG)
#define SAES_SEL(val)		STM32_DT_CLOCK_SELECT((val), 1, 0, SAESCKSELR_REG)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_STM32MP13_CLOCK_H_ */
