/*
 * Copyright (C) 2025 Savoir-faire Linux, Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_STM32MP2_CLOCK_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_STM32MP2_CLOCK_H_

#include "stm32_common_clocks.h"

/* Undefine the common clocks macro */
#undef STM32_CLOCK

/**
 * Pack RCC clock register offset and bit in two 32-bit values
 * as expected for the Device Tree `clocks` property on STM32.
 *
 * @param per STM32 Peripheral name (expands to STM32_CLOCK_PERIPH_{PER})
 * @param bit Clock bit
 */
#define STM32_CLOCK(per, bit) (STM32_CLOCK_PERIPH_##per) (1 << bit)

/* Clock reg */
#define STM32_CLK		1U
#define STM32_LP_CLK		2U

/* GPIO Peripheral */
#define STM32_CLOCK_PERIPH_GPIOA	0x52C
#define STM32_CLOCK_PERIPH_GPIOB	0x530
#define STM32_CLOCK_PERIPH_GPIOC	0x534
#define STM32_CLOCK_PERIPH_GPIOD	0x538
#define STM32_CLOCK_PERIPH_GPIOE	0x53C
#define STM32_CLOCK_PERIPH_GPIOF	0x540
#define STM32_CLOCK_PERIPH_GPIOG	0x544
#define STM32_CLOCK_PERIPH_GPIOH	0x548
#define STM32_CLOCK_PERIPH_GPIOI	0x54C
#define STM32_CLOCK_PERIPH_GPIOJ	0x550
#define STM32_CLOCK_PERIPH_GPIOK	0x554
#define STM32_CLOCK_PERIPH_GPIOZ	0x558

/* SPI Peripheral */
#define STM32_CLOCK_PERIPH_SPI1		0x758
#define STM32_CLOCK_PERIPH_SPI2		0x75C
#define STM32_CLOCK_PERIPH_SPI3		0x760
#define STM32_CLOCK_PERIPH_SPI4		0x764
#define STM32_CLOCK_PERIPH_SPI5		0x768
#define STM32_CLOCK_PERIPH_SPI6		0x76C
#define STM32_CLOCK_PERIPH_SPI7		0x770

/* USART/UART Peripheral */
#define STM32_CLOCK_PERIPH_USART1	0x77C
#define STM32_CLOCK_PERIPH_USART2	0x780
#define STM32_CLOCK_PERIPH_USART3	0x784
#define STM32_CLOCK_PERIPH_UART4	0x788
#define STM32_CLOCK_PERIPH_UART5	0x78C
#define STM32_CLOCK_PERIPH_USART6	0x790
#define STM32_CLOCK_PERIPH_UART7	0x794
#define STM32_CLOCK_PERIPH_UART8	0x798
#define STM32_CLOCK_PERIPH_UART9	0x79C

/* I2C Peripheral */
#define STM32_CLOCK_PERIPH_I2C1		0x7A0
#define STM32_CLOCK_PERIPH_I2C2		0x7A8
#define STM32_CLOCK_PERIPH_I2C3		0x7AC
#define STM32_CLOCK_PERIPH_I2C4		0x7B0
#define STM32_CLOCK_PERIPH_I2C5		0x7B4
#define STM32_CLOCK_PERIPH_I2C6		0x7B8
#define STM32_CLOCK_PERIPH_I2C7		0x7BC
#define STM32_CLOCK_PERIPH_I2C8		0x7C0

/* Watchdog Peripheral */
#define STM32_CLOCK_PERIPH_IWDG4	0x894
#define STM32_CLOCK_PERIPH_WWDG1	0x89C

#define STM32_CLOCK_PERIPH_MIN	STM32_CLOCK_PERIPH_GPIOA
#define STM32_CLOCK_PERIPH_MAX	STM32_CLOCK_PERIPH_WWDG1

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_STM32MP2_CLOCK_H_ */
