/*
 * Copyright (c) 2020 Teslabs Engineering S.L.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_MEMORY_CONTROLLER_STM32_FMC_SDRAM_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_MEMORY_CONTROLLER_STM32_FMC_SDRAM_H_

/* Number of column address bits */
#define STM32_FMC_SDRAM_NC_8 0x00000000UL
#define STM32_FMC_SDRAM_NC_9 0x00000001UL
#define STM32_FMC_SDRAM_NC_10 0x00000002UL
#define STM32_FMC_SDRAM_NC_11 0x00000003UL

/* Number of row address bits */
#define STM32_FMC_SDRAM_NR_11 0x00000000UL
#define STM32_FMC_SDRAM_NR_12 0x00000004UL
#define STM32_FMC_SDRAM_NR_13 0x00000008UL

/* Memory data bus width. */
#define STM32_FMC_SDRAM_MWID_8 0x00000000UL
#define STM32_FMC_SDRAM_MWID_16 0x00000010UL
#define STM32_FMC_SDRAM_MWID_32 0x00000020UL

/* Number of internal banks */
#define STM32_FMC_SDRAM_NB_2 0x00000000UL
#define STM32_FMC_SDRAM_NB_4 0x00000040UL

/* CAS Latency */
#define STM32_FMC_SDRAM_CAS_1 0x00000080UL
#define STM32_FMC_SDRAM_CAS_2 0x00000100UL
#define STM32_FMC_SDRAM_CAS_3 0x00000180UL

/* SDRAM clock configuration */
#define STM32_FMC_SDRAM_SDCLK_DISABLE 0x00000000UL
#define STM32_FMC_SDRAM_SDCLK_PERIOD_2 0x00000800UL
#define STM32_FMC_SDRAM_SDCLK_PERIOD_3 0x00000C00UL

/* Burst read */
#define STM32_FMC_SDRAM_RBURST_DISABLE 0x00000000UL
#define STM32_FMC_SDRAM_RBURST_ENABLE 0x00001000UL

/* Read pipe */
#define STM32_FMC_SDRAM_RPIPE_0 0x00000000UL
#define STM32_FMC_SDRAM_RPIPE_1 0x00002000UL
#define STM32_FMC_SDRAM_RPIPE_2 0x00004000UL

#endif
