/*
 * Copyright 2025 Arm Limited and/or its affiliates <open-source-office@arm.com>
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#define MPS2_ALT_FUNC_POS 0
#define MPS2_ALT_FUNC_MASK 0x3

#define MPS2_EXP_NUM_POS 2
#define MPS2_EXP_NUM_MASK 0x3F

#define MPS2_PINCTRL_FUNC_UART 0
#define MPS2_PINCTRL_FUNC_GPIO 1
#define MPS2_PINCTRL_FUNC_I2C 2
#define MPS2_PINCTRL_FUNC_SPI 3


#define MPS2_PINMUX(alt_func, exp_num) (exp_num << MPS2_EXP_NUM_POS | \
	alt_func << MPS2_ALT_FUNC_POS)



/*
 * This is the mapping from the ARM MPS2 Board pins to GPIO
 * controllers.
 *
 * D0 : EXT_0
 * D1 : EXT_4
 * D2 : EXT_2
 * D3 : EXT_3
 * D4 : EXT_1
 * D5 : EXT_6
 * D6 : EXT_7
 * D7 : EXT_8
 * D8 : EXT_9
 * D9 : EXT_10
 * D10 : EXT_12
 * D11 : EXT_13
 * D12 : EXT_14
 * D13 : EXT_11
 * D14 : EXT_15
 * D15 : EXT_5
 * D16 : EXT_16
 * D17 : EXT_17
 * D18 : EXT_18
 * D19 : EXT_19
 * D20 : EXT_20
 * D21 : EXT_21
 * D22 : EXT_22
 * D23 : EXT_23
 * D24 : EXT_24
 * D25 : EXT_25
 * D26 : EXT_26
 * D27 : EXT_30
 * D28 : EXT_28
 * D29 : EXT_29
 * D30 : EXT_27
 * D31 : EXT_32
 * D32 : EXT_33
 * D33 : EXT_34
 * D34 : EXT_35
 * D35 : EXT_36
 * D36 : EXT_38
 * D37 : EXT_39
 * D38 : EXT_40
 * D39 : EXT_44
 * D40 : EXT_41
 * D41 : EXT_31
 * D42 : EXT_37
 * D43 : EXT_42
 * D44 : EXT_43
 * D45 : EXT_45
 * D46 : EXT_46
 * D47 : EXT_47
 * D48 : EXT_48
 * D49 : EXT_49
 * D50 : EXT_50
 * D51 : EXT_51
 *
 * UART_3_RX : D0
 * UART_3_TX : D1
 * SPI_3_CS : D10
 * SPI_3_MOSI : D11
 * SPI_3_MISO : D12
 * SPI_3_SCLK : D13
 * I2C_3_SDA : D14
 * I2C_3_SCL : D15
 * UART_4_RX : D26
 * UART_4_TX : D30
 * SPI_4_CS : D36
 * SPI_4_MOSI : D37
 * SPI_4_MISO : D38
 * SPI_4_SCK : D39
 * I2C_4_SDA : D40
 * I2C_4_SCL : D41
 *
 */

/* GPIO 0 */
#define UART3_RXD_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_UART, 0)
#define UART3_TXD_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_UART, 4)
#define SBCON2_SCL_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_I2C, 5)
#define SBCON2_SDA_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_I2C, 15)
#define SPI3_SCK_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_SPI, 11)
#define SPI3_SS_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_SPI, 12)
#define SPI3_MOSI_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_SPI, 13)
#define SPI3_MISO_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_SPI, 14)

/* GPIO 1 */
#define SPI2_SS_EXP  MPS2_PINMUX(MPS2_PINCTRL_FUNC_SPI, 16)
#define SPI2_MISO_EXP  MPS2_PINMUX(MPS2_PINCTRL_FUNC_SPI, 17)
#define SPI2_MOSI_EXP  MPS2_PINMUX(MPS2_PINCTRL_FUNC_SPI, 18)
#define SPI2_SCK_EXP  MPS2_PINMUX(MPS2_PINCTRL_FUNC_SPI, 19)
#define UART4_RXD_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_UART, 26)
#define UART4_TXD_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_UART, 30)
#define SBCON3_SCL_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_I2C, 31)

/* GPIO 2 */
#define SBCON3_SDA_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_I2C, 41)
#define SPI4_SS_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_SPI, 38)
#define SPI4_MOSI_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_SPI, 39)
#define SPI4_MISO_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_SPI, 40)
#define SPI4_SCK_EXP MPS2_PINMUX(MPS2_PINCTRL_FUNC_SPI, 44)
