/*
 * Copyright (c) 2025 Silicon Laboratories Inc.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Pin Control for Silicon Labs XG24 devices
 *
 * This file was generated by the script gen_pinctrl.py in the hal_silabs module.
 * Do not manually edit.
 */

#ifndef ZEPHYR_DT_BINDINGS_PINCTRL_SILABS_XG24_PINCTRL_H_
#define ZEPHYR_DT_BINDINGS_PINCTRL_SILABS_XG24_PINCTRL_H_

#include <zephyr/dt-bindings/pinctrl/silabs-pinctrl-dbus.h>

#define SILABS_DBUS_ACMP0_ACMPOUT(port, pin) SILABS_DBUS(port, pin, 4, 1, 0, 1)

#define SILABS_DBUS_ACMP1_ACMPOUT(port, pin) SILABS_DBUS(port, pin, 7, 1, 0, 1)

#define SILABS_DBUS_CMU_CLKOUT0(port, pin) SILABS_DBUS(port, pin, 10, 1, 0, 2)
#define SILABS_DBUS_CMU_CLKOUT1(port, pin) SILABS_DBUS(port, pin, 10, 1, 1, 3)
#define SILABS_DBUS_CMU_CLKOUT2(port, pin) SILABS_DBUS(port, pin, 10, 1, 2, 4)
#define SILABS_DBUS_CMU_CLKIN0(port, pin)  SILABS_DBUS(port, pin, 10, 0, 0, 1)

#define SILABS_DBUS_EUSART0_CS(port, pin)   SILABS_DBUS(port, pin, 21, 1, 0, 1)
#define SILABS_DBUS_EUSART0_RTS(port, pin)  SILABS_DBUS(port, pin, 21, 1, 1, 3)
#define SILABS_DBUS_EUSART0_RX(port, pin)   SILABS_DBUS(port, pin, 21, 1, 2, 4)
#define SILABS_DBUS_EUSART0_SCLK(port, pin) SILABS_DBUS(port, pin, 21, 1, 3, 5)
#define SILABS_DBUS_EUSART0_TX(port, pin)   SILABS_DBUS(port, pin, 21, 1, 4, 6)
#define SILABS_DBUS_EUSART0_CTS(port, pin)  SILABS_DBUS(port, pin, 21, 0, 0, 2)

#define SILABS_DBUS_EUSART1_CS(port, pin)   SILABS_DBUS(port, pin, 29, 1, 0, 1)
#define SILABS_DBUS_EUSART1_RTS(port, pin)  SILABS_DBUS(port, pin, 29, 1, 1, 3)
#define SILABS_DBUS_EUSART1_RX(port, pin)   SILABS_DBUS(port, pin, 29, 1, 2, 4)
#define SILABS_DBUS_EUSART1_SCLK(port, pin) SILABS_DBUS(port, pin, 29, 1, 3, 5)
#define SILABS_DBUS_EUSART1_TX(port, pin)   SILABS_DBUS(port, pin, 29, 1, 4, 6)
#define SILABS_DBUS_EUSART1_CTS(port, pin)  SILABS_DBUS(port, pin, 29, 0, 0, 2)

#define SILABS_DBUS_PTI_DCLK(port, pin)   SILABS_DBUS(port, pin, 37, 1, 0, 1)
#define SILABS_DBUS_PTI_DFRAME(port, pin) SILABS_DBUS(port, pin, 37, 1, 1, 2)
#define SILABS_DBUS_PTI_DOUT(port, pin)   SILABS_DBUS(port, pin, 37, 1, 2, 3)

#define SILABS_DBUS_I2C0_SCL(port, pin) SILABS_DBUS(port, pin, 42, 1, 0, 1)
#define SILABS_DBUS_I2C0_SDA(port, pin) SILABS_DBUS(port, pin, 42, 1, 1, 2)

#define SILABS_DBUS_I2C1_SCL(port, pin) SILABS_DBUS(port, pin, 46, 1, 0, 1)
#define SILABS_DBUS_I2C1_SDA(port, pin) SILABS_DBUS(port, pin, 46, 1, 1, 2)

#define SILABS_DBUS_KEYSCAN_COLOUT0(port, pin)   SILABS_DBUS(port, pin, 50, 1, 0, 1)
#define SILABS_DBUS_KEYSCAN_COLOUT1(port, pin)   SILABS_DBUS(port, pin, 50, 1, 1, 2)
#define SILABS_DBUS_KEYSCAN_COLOUT2(port, pin)   SILABS_DBUS(port, pin, 50, 1, 2, 3)
#define SILABS_DBUS_KEYSCAN_COLOUT3(port, pin)   SILABS_DBUS(port, pin, 50, 1, 3, 4)
#define SILABS_DBUS_KEYSCAN_COLOUT4(port, pin)   SILABS_DBUS(port, pin, 50, 1, 4, 5)
#define SILABS_DBUS_KEYSCAN_COLOUT5(port, pin)   SILABS_DBUS(port, pin, 50, 1, 5, 6)
#define SILABS_DBUS_KEYSCAN_COLOUT6(port, pin)   SILABS_DBUS(port, pin, 50, 1, 6, 7)
#define SILABS_DBUS_KEYSCAN_COLOUT7(port, pin)   SILABS_DBUS(port, pin, 50, 1, 7, 8)
#define SILABS_DBUS_KEYSCAN_ROWSENSE0(port, pin) SILABS_DBUS(port, pin, 50, 0, 0, 9)
#define SILABS_DBUS_KEYSCAN_ROWSENSE1(port, pin) SILABS_DBUS(port, pin, 50, 0, 0, 10)
#define SILABS_DBUS_KEYSCAN_ROWSENSE2(port, pin) SILABS_DBUS(port, pin, 50, 0, 0, 11)
#define SILABS_DBUS_KEYSCAN_ROWSENSE3(port, pin) SILABS_DBUS(port, pin, 50, 0, 0, 12)
#define SILABS_DBUS_KEYSCAN_ROWSENSE4(port, pin) SILABS_DBUS(port, pin, 50, 0, 0, 13)
#define SILABS_DBUS_KEYSCAN_ROWSENSE5(port, pin) SILABS_DBUS(port, pin, 50, 0, 0, 14)

#define SILABS_DBUS_LETIMER0_OUT0(port, pin) SILABS_DBUS(port, pin, 66, 1, 0, 1)
#define SILABS_DBUS_LETIMER0_OUT1(port, pin) SILABS_DBUS(port, pin, 66, 1, 1, 2)

#define SILABS_DBUS_MODEM_ANT0(port, pin)        SILABS_DBUS(port, pin, 70, 1, 0, 1)
#define SILABS_DBUS_MODEM_ANT1(port, pin)        SILABS_DBUS(port, pin, 70, 1, 1, 2)
#define SILABS_DBUS_MODEM_ANTROLLOVER(port, pin) SILABS_DBUS(port, pin, 70, 1, 2, 3)
#define SILABS_DBUS_MODEM_ANTRR0(port, pin)      SILABS_DBUS(port, pin, 70, 1, 3, 4)
#define SILABS_DBUS_MODEM_ANTRR1(port, pin)      SILABS_DBUS(port, pin, 70, 1, 4, 5)
#define SILABS_DBUS_MODEM_ANTRR2(port, pin)      SILABS_DBUS(port, pin, 70, 1, 5, 6)
#define SILABS_DBUS_MODEM_ANTRR3(port, pin)      SILABS_DBUS(port, pin, 70, 1, 6, 7)
#define SILABS_DBUS_MODEM_ANTRR4(port, pin)      SILABS_DBUS(port, pin, 70, 1, 7, 8)
#define SILABS_DBUS_MODEM_ANTRR5(port, pin)      SILABS_DBUS(port, pin, 70, 1, 8, 9)
#define SILABS_DBUS_MODEM_ANTSWEN(port, pin)     SILABS_DBUS(port, pin, 70, 1, 9, 10)
#define SILABS_DBUS_MODEM_ANTSWUS(port, pin)     SILABS_DBUS(port, pin, 70, 1, 10, 11)
#define SILABS_DBUS_MODEM_ANTTRIG(port, pin)     SILABS_DBUS(port, pin, 70, 1, 11, 12)
#define SILABS_DBUS_MODEM_ANTTRIGSTOP(port, pin) SILABS_DBUS(port, pin, 70, 1, 12, 13)
#define SILABS_DBUS_MODEM_DCLK(port, pin)        SILABS_DBUS(port, pin, 70, 1, 13, 14)
#define SILABS_DBUS_MODEM_DOUT(port, pin)        SILABS_DBUS(port, pin, 70, 1, 14, 16)
#define SILABS_DBUS_MODEM_DIN(port, pin)         SILABS_DBUS(port, pin, 70, 0, 0, 15)

#define SILABS_DBUS_PCNT0_S0IN(port, pin) SILABS_DBUS(port, pin, 89, 0, 0, 0)
#define SILABS_DBUS_PCNT0_S1IN(port, pin) SILABS_DBUS(port, pin, 89, 0, 0, 1)

#define SILABS_DBUS_PRS0_ASYNCH0(port, pin)  SILABS_DBUS(port, pin, 92, 1, 0, 1)
#define SILABS_DBUS_PRS0_ASYNCH1(port, pin)  SILABS_DBUS(port, pin, 92, 1, 1, 2)
#define SILABS_DBUS_PRS0_ASYNCH2(port, pin)  SILABS_DBUS(port, pin, 92, 1, 2, 3)
#define SILABS_DBUS_PRS0_ASYNCH3(port, pin)  SILABS_DBUS(port, pin, 92, 1, 3, 4)
#define SILABS_DBUS_PRS0_ASYNCH4(port, pin)  SILABS_DBUS(port, pin, 92, 1, 4, 5)
#define SILABS_DBUS_PRS0_ASYNCH5(port, pin)  SILABS_DBUS(port, pin, 92, 1, 5, 6)
#define SILABS_DBUS_PRS0_ASYNCH6(port, pin)  SILABS_DBUS(port, pin, 92, 1, 6, 7)
#define SILABS_DBUS_PRS0_ASYNCH7(port, pin)  SILABS_DBUS(port, pin, 92, 1, 7, 8)
#define SILABS_DBUS_PRS0_ASYNCH8(port, pin)  SILABS_DBUS(port, pin, 92, 1, 8, 9)
#define SILABS_DBUS_PRS0_ASYNCH9(port, pin)  SILABS_DBUS(port, pin, 92, 1, 9, 10)
#define SILABS_DBUS_PRS0_ASYNCH10(port, pin) SILABS_DBUS(port, pin, 92, 1, 10, 11)
#define SILABS_DBUS_PRS0_ASYNCH11(port, pin) SILABS_DBUS(port, pin, 92, 1, 11, 12)
#define SILABS_DBUS_PRS0_ASYNCH12(port, pin) SILABS_DBUS(port, pin, 92, 1, 12, 13)
#define SILABS_DBUS_PRS0_ASYNCH13(port, pin) SILABS_DBUS(port, pin, 92, 1, 13, 14)
#define SILABS_DBUS_PRS0_ASYNCH14(port, pin) SILABS_DBUS(port, pin, 92, 1, 14, 15)
#define SILABS_DBUS_PRS0_ASYNCH15(port, pin) SILABS_DBUS(port, pin, 92, 1, 15, 16)
#define SILABS_DBUS_PRS0_SYNCH0(port, pin)   SILABS_DBUS(port, pin, 92, 1, 16, 17)
#define SILABS_DBUS_PRS0_SYNCH1(port, pin)   SILABS_DBUS(port, pin, 92, 1, 17, 18)
#define SILABS_DBUS_PRS0_SYNCH2(port, pin)   SILABS_DBUS(port, pin, 92, 1, 18, 19)
#define SILABS_DBUS_PRS0_SYNCH3(port, pin)   SILABS_DBUS(port, pin, 92, 1, 19, 20)

#define SILABS_DBUS_RAC_LNAEN(port, pin) SILABS_DBUS(port, pin, 114, 1, 0, 1)
#define SILABS_DBUS_RAC_PAEN(port, pin)  SILABS_DBUS(port, pin, 114, 1, 1, 2)

#define SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(port, pin) SILABS_DBUS(port, pin, 142, 0, 0, 0)

#define SILABS_DBUS_TIMER0_CC0(port, pin)   SILABS_DBUS(port, pin, 144, 1, 0, 1)
#define SILABS_DBUS_TIMER0_CC1(port, pin)   SILABS_DBUS(port, pin, 144, 1, 1, 2)
#define SILABS_DBUS_TIMER0_CC2(port, pin)   SILABS_DBUS(port, pin, 144, 1, 2, 3)
#define SILABS_DBUS_TIMER0_CDTI0(port, pin) SILABS_DBUS(port, pin, 144, 1, 3, 4)
#define SILABS_DBUS_TIMER0_CDTI1(port, pin) SILABS_DBUS(port, pin, 144, 1, 4, 5)
#define SILABS_DBUS_TIMER0_CDTI2(port, pin) SILABS_DBUS(port, pin, 144, 1, 5, 6)

#define SILABS_DBUS_TIMER1_CC0(port, pin)   SILABS_DBUS(port, pin, 152, 1, 0, 1)
#define SILABS_DBUS_TIMER1_CC1(port, pin)   SILABS_DBUS(port, pin, 152, 1, 1, 2)
#define SILABS_DBUS_TIMER1_CC2(port, pin)   SILABS_DBUS(port, pin, 152, 1, 2, 3)
#define SILABS_DBUS_TIMER1_CDTI0(port, pin) SILABS_DBUS(port, pin, 152, 1, 3, 4)
#define SILABS_DBUS_TIMER1_CDTI1(port, pin) SILABS_DBUS(port, pin, 152, 1, 4, 5)
#define SILABS_DBUS_TIMER1_CDTI2(port, pin) SILABS_DBUS(port, pin, 152, 1, 5, 6)

#define SILABS_DBUS_TIMER2_CC0(port, pin)   SILABS_DBUS(port, pin, 160, 1, 0, 1)
#define SILABS_DBUS_TIMER2_CC1(port, pin)   SILABS_DBUS(port, pin, 160, 1, 1, 2)
#define SILABS_DBUS_TIMER2_CC2(port, pin)   SILABS_DBUS(port, pin, 160, 1, 2, 3)
#define SILABS_DBUS_TIMER2_CDTI0(port, pin) SILABS_DBUS(port, pin, 160, 1, 3, 4)
#define SILABS_DBUS_TIMER2_CDTI1(port, pin) SILABS_DBUS(port, pin, 160, 1, 4, 5)
#define SILABS_DBUS_TIMER2_CDTI2(port, pin) SILABS_DBUS(port, pin, 160, 1, 5, 6)

#define SILABS_DBUS_TIMER3_CC0(port, pin)   SILABS_DBUS(port, pin, 168, 1, 0, 1)
#define SILABS_DBUS_TIMER3_CC1(port, pin)   SILABS_DBUS(port, pin, 168, 1, 1, 2)
#define SILABS_DBUS_TIMER3_CC2(port, pin)   SILABS_DBUS(port, pin, 168, 1, 2, 3)
#define SILABS_DBUS_TIMER3_CDTI0(port, pin) SILABS_DBUS(port, pin, 168, 1, 3, 4)
#define SILABS_DBUS_TIMER3_CDTI1(port, pin) SILABS_DBUS(port, pin, 168, 1, 4, 5)
#define SILABS_DBUS_TIMER3_CDTI2(port, pin) SILABS_DBUS(port, pin, 168, 1, 5, 6)

#define SILABS_DBUS_TIMER4_CC0(port, pin)   SILABS_DBUS(port, pin, 176, 1, 0, 1)
#define SILABS_DBUS_TIMER4_CC1(port, pin)   SILABS_DBUS(port, pin, 176, 1, 1, 2)
#define SILABS_DBUS_TIMER4_CC2(port, pin)   SILABS_DBUS(port, pin, 176, 1, 2, 3)
#define SILABS_DBUS_TIMER4_CDTI0(port, pin) SILABS_DBUS(port, pin, 176, 1, 3, 4)
#define SILABS_DBUS_TIMER4_CDTI1(port, pin) SILABS_DBUS(port, pin, 176, 1, 4, 5)
#define SILABS_DBUS_TIMER4_CDTI2(port, pin) SILABS_DBUS(port, pin, 176, 1, 5, 6)

#define SILABS_DBUS_USART0_CS(port, pin)  SILABS_DBUS(port, pin, 184, 1, 0, 1)
#define SILABS_DBUS_USART0_RTS(port, pin) SILABS_DBUS(port, pin, 184, 1, 1, 3)
#define SILABS_DBUS_USART0_RX(port, pin)  SILABS_DBUS(port, pin, 184, 1, 2, 4)
#define SILABS_DBUS_USART0_CLK(port, pin) SILABS_DBUS(port, pin, 184, 1, 3, 5)
#define SILABS_DBUS_USART0_TX(port, pin)  SILABS_DBUS(port, pin, 184, 1, 4, 6)
#define SILABS_DBUS_USART0_CTS(port, pin) SILABS_DBUS(port, pin, 184, 0, 0, 2)

#define GPIO_SWCLKTCK_PA1   SILABS_FIXED_ROUTE(0x0, 0x1, 0, 0)
#define GPIO_SWDIOTMS_PA2   SILABS_FIXED_ROUTE(0x0, 0x2, 0, 1)
#define GPIO_TDO_PA3        SILABS_FIXED_ROUTE(0x0, 0x3, 0, 2)
#define GPIO_TDI_PA4        SILABS_FIXED_ROUTE(0x0, 0x4, 0, 3)
#define GPIO_SWV_PA3        SILABS_FIXED_ROUTE(0x0, 0x3, 1, 0)
#define GPIO_TRACECLK_PA4   SILABS_FIXED_ROUTE(0x0, 0x4, 1, 1)
#define GPIO_TRACEDATA0_PA3 SILABS_FIXED_ROUTE(0x0, 0x3, 1, 2)
#define GPIO_TRACEDATA1_PA5 SILABS_FIXED_ROUTE(0x0, 0x5, 1, 3)
#define GPIO_TRACEDATA2_PA6 SILABS_FIXED_ROUTE(0x0, 0x6, 1, 4)
#define GPIO_TRACEDATA3_PA7 SILABS_FIXED_ROUTE(0x0, 0x7, 1, 5)

#define ACMP0_ACMPOUT_PA0 SILABS_DBUS_ACMP0_ACMPOUT(0x0, 0x0)
#define ACMP0_ACMPOUT_PA1 SILABS_DBUS_ACMP0_ACMPOUT(0x0, 0x1)
#define ACMP0_ACMPOUT_PA2 SILABS_DBUS_ACMP0_ACMPOUT(0x0, 0x2)
#define ACMP0_ACMPOUT_PA3 SILABS_DBUS_ACMP0_ACMPOUT(0x0, 0x3)
#define ACMP0_ACMPOUT_PA4 SILABS_DBUS_ACMP0_ACMPOUT(0x0, 0x4)
#define ACMP0_ACMPOUT_PA5 SILABS_DBUS_ACMP0_ACMPOUT(0x0, 0x5)
#define ACMP0_ACMPOUT_PA6 SILABS_DBUS_ACMP0_ACMPOUT(0x0, 0x6)
#define ACMP0_ACMPOUT_PA7 SILABS_DBUS_ACMP0_ACMPOUT(0x0, 0x7)
#define ACMP0_ACMPOUT_PA8 SILABS_DBUS_ACMP0_ACMPOUT(0x0, 0x8)
#define ACMP0_ACMPOUT_PA9 SILABS_DBUS_ACMP0_ACMPOUT(0x0, 0x9)
#define ACMP0_ACMPOUT_PB0 SILABS_DBUS_ACMP0_ACMPOUT(0x1, 0x0)
#define ACMP0_ACMPOUT_PB1 SILABS_DBUS_ACMP0_ACMPOUT(0x1, 0x1)
#define ACMP0_ACMPOUT_PB2 SILABS_DBUS_ACMP0_ACMPOUT(0x1, 0x2)
#define ACMP0_ACMPOUT_PB3 SILABS_DBUS_ACMP0_ACMPOUT(0x1, 0x3)
#define ACMP0_ACMPOUT_PB4 SILABS_DBUS_ACMP0_ACMPOUT(0x1, 0x4)
#define ACMP0_ACMPOUT_PB5 SILABS_DBUS_ACMP0_ACMPOUT(0x1, 0x5)
#define ACMP0_ACMPOUT_PC0 SILABS_DBUS_ACMP0_ACMPOUT(0x2, 0x0)
#define ACMP0_ACMPOUT_PC1 SILABS_DBUS_ACMP0_ACMPOUT(0x2, 0x1)
#define ACMP0_ACMPOUT_PC2 SILABS_DBUS_ACMP0_ACMPOUT(0x2, 0x2)
#define ACMP0_ACMPOUT_PC3 SILABS_DBUS_ACMP0_ACMPOUT(0x2, 0x3)
#define ACMP0_ACMPOUT_PC4 SILABS_DBUS_ACMP0_ACMPOUT(0x2, 0x4)
#define ACMP0_ACMPOUT_PC5 SILABS_DBUS_ACMP0_ACMPOUT(0x2, 0x5)
#define ACMP0_ACMPOUT_PC6 SILABS_DBUS_ACMP0_ACMPOUT(0x2, 0x6)
#define ACMP0_ACMPOUT_PC7 SILABS_DBUS_ACMP0_ACMPOUT(0x2, 0x7)
#define ACMP0_ACMPOUT_PC8 SILABS_DBUS_ACMP0_ACMPOUT(0x2, 0x8)
#define ACMP0_ACMPOUT_PC9 SILABS_DBUS_ACMP0_ACMPOUT(0x2, 0x9)
#define ACMP0_ACMPOUT_PD0 SILABS_DBUS_ACMP0_ACMPOUT(0x3, 0x0)
#define ACMP0_ACMPOUT_PD1 SILABS_DBUS_ACMP0_ACMPOUT(0x3, 0x1)
#define ACMP0_ACMPOUT_PD2 SILABS_DBUS_ACMP0_ACMPOUT(0x3, 0x2)
#define ACMP0_ACMPOUT_PD3 SILABS_DBUS_ACMP0_ACMPOUT(0x3, 0x3)
#define ACMP0_ACMPOUT_PD4 SILABS_DBUS_ACMP0_ACMPOUT(0x3, 0x4)
#define ACMP0_ACMPOUT_PD5 SILABS_DBUS_ACMP0_ACMPOUT(0x3, 0x5)

#define ACMP1_ACMPOUT_PA0 SILABS_DBUS_ACMP1_ACMPOUT(0x0, 0x0)
#define ACMP1_ACMPOUT_PA1 SILABS_DBUS_ACMP1_ACMPOUT(0x0, 0x1)
#define ACMP1_ACMPOUT_PA2 SILABS_DBUS_ACMP1_ACMPOUT(0x0, 0x2)
#define ACMP1_ACMPOUT_PA3 SILABS_DBUS_ACMP1_ACMPOUT(0x0, 0x3)
#define ACMP1_ACMPOUT_PA4 SILABS_DBUS_ACMP1_ACMPOUT(0x0, 0x4)
#define ACMP1_ACMPOUT_PA5 SILABS_DBUS_ACMP1_ACMPOUT(0x0, 0x5)
#define ACMP1_ACMPOUT_PA6 SILABS_DBUS_ACMP1_ACMPOUT(0x0, 0x6)
#define ACMP1_ACMPOUT_PA7 SILABS_DBUS_ACMP1_ACMPOUT(0x0, 0x7)
#define ACMP1_ACMPOUT_PA8 SILABS_DBUS_ACMP1_ACMPOUT(0x0, 0x8)
#define ACMP1_ACMPOUT_PA9 SILABS_DBUS_ACMP1_ACMPOUT(0x0, 0x9)
#define ACMP1_ACMPOUT_PB0 SILABS_DBUS_ACMP1_ACMPOUT(0x1, 0x0)
#define ACMP1_ACMPOUT_PB1 SILABS_DBUS_ACMP1_ACMPOUT(0x1, 0x1)
#define ACMP1_ACMPOUT_PB2 SILABS_DBUS_ACMP1_ACMPOUT(0x1, 0x2)
#define ACMP1_ACMPOUT_PB3 SILABS_DBUS_ACMP1_ACMPOUT(0x1, 0x3)
#define ACMP1_ACMPOUT_PB4 SILABS_DBUS_ACMP1_ACMPOUT(0x1, 0x4)
#define ACMP1_ACMPOUT_PB5 SILABS_DBUS_ACMP1_ACMPOUT(0x1, 0x5)
#define ACMP1_ACMPOUT_PC0 SILABS_DBUS_ACMP1_ACMPOUT(0x2, 0x0)
#define ACMP1_ACMPOUT_PC1 SILABS_DBUS_ACMP1_ACMPOUT(0x2, 0x1)
#define ACMP1_ACMPOUT_PC2 SILABS_DBUS_ACMP1_ACMPOUT(0x2, 0x2)
#define ACMP1_ACMPOUT_PC3 SILABS_DBUS_ACMP1_ACMPOUT(0x2, 0x3)
#define ACMP1_ACMPOUT_PC4 SILABS_DBUS_ACMP1_ACMPOUT(0x2, 0x4)
#define ACMP1_ACMPOUT_PC5 SILABS_DBUS_ACMP1_ACMPOUT(0x2, 0x5)
#define ACMP1_ACMPOUT_PC6 SILABS_DBUS_ACMP1_ACMPOUT(0x2, 0x6)
#define ACMP1_ACMPOUT_PC7 SILABS_DBUS_ACMP1_ACMPOUT(0x2, 0x7)
#define ACMP1_ACMPOUT_PC8 SILABS_DBUS_ACMP1_ACMPOUT(0x2, 0x8)
#define ACMP1_ACMPOUT_PC9 SILABS_DBUS_ACMP1_ACMPOUT(0x2, 0x9)
#define ACMP1_ACMPOUT_PD0 SILABS_DBUS_ACMP1_ACMPOUT(0x3, 0x0)
#define ACMP1_ACMPOUT_PD1 SILABS_DBUS_ACMP1_ACMPOUT(0x3, 0x1)
#define ACMP1_ACMPOUT_PD2 SILABS_DBUS_ACMP1_ACMPOUT(0x3, 0x2)
#define ACMP1_ACMPOUT_PD3 SILABS_DBUS_ACMP1_ACMPOUT(0x3, 0x3)
#define ACMP1_ACMPOUT_PD4 SILABS_DBUS_ACMP1_ACMPOUT(0x3, 0x4)
#define ACMP1_ACMPOUT_PD5 SILABS_DBUS_ACMP1_ACMPOUT(0x3, 0x5)

#define CMU_CLKOUT0_PC0 SILABS_DBUS_CMU_CLKOUT0(0x2, 0x0)
#define CMU_CLKOUT0_PC1 SILABS_DBUS_CMU_CLKOUT0(0x2, 0x1)
#define CMU_CLKOUT0_PC2 SILABS_DBUS_CMU_CLKOUT0(0x2, 0x2)
#define CMU_CLKOUT0_PC3 SILABS_DBUS_CMU_CLKOUT0(0x2, 0x3)
#define CMU_CLKOUT0_PC4 SILABS_DBUS_CMU_CLKOUT0(0x2, 0x4)
#define CMU_CLKOUT0_PC5 SILABS_DBUS_CMU_CLKOUT0(0x2, 0x5)
#define CMU_CLKOUT0_PC6 SILABS_DBUS_CMU_CLKOUT0(0x2, 0x6)
#define CMU_CLKOUT0_PC7 SILABS_DBUS_CMU_CLKOUT0(0x2, 0x7)
#define CMU_CLKOUT0_PC8 SILABS_DBUS_CMU_CLKOUT0(0x2, 0x8)
#define CMU_CLKOUT0_PC9 SILABS_DBUS_CMU_CLKOUT0(0x2, 0x9)
#define CMU_CLKOUT0_PD0 SILABS_DBUS_CMU_CLKOUT0(0x3, 0x0)
#define CMU_CLKOUT0_PD1 SILABS_DBUS_CMU_CLKOUT0(0x3, 0x1)
#define CMU_CLKOUT0_PD2 SILABS_DBUS_CMU_CLKOUT0(0x3, 0x2)
#define CMU_CLKOUT0_PD3 SILABS_DBUS_CMU_CLKOUT0(0x3, 0x3)
#define CMU_CLKOUT0_PD4 SILABS_DBUS_CMU_CLKOUT0(0x3, 0x4)
#define CMU_CLKOUT0_PD5 SILABS_DBUS_CMU_CLKOUT0(0x3, 0x5)
#define CMU_CLKOUT1_PC0 SILABS_DBUS_CMU_CLKOUT1(0x2, 0x0)
#define CMU_CLKOUT1_PC1 SILABS_DBUS_CMU_CLKOUT1(0x2, 0x1)
#define CMU_CLKOUT1_PC2 SILABS_DBUS_CMU_CLKOUT1(0x2, 0x2)
#define CMU_CLKOUT1_PC3 SILABS_DBUS_CMU_CLKOUT1(0x2, 0x3)
#define CMU_CLKOUT1_PC4 SILABS_DBUS_CMU_CLKOUT1(0x2, 0x4)
#define CMU_CLKOUT1_PC5 SILABS_DBUS_CMU_CLKOUT1(0x2, 0x5)
#define CMU_CLKOUT1_PC6 SILABS_DBUS_CMU_CLKOUT1(0x2, 0x6)
#define CMU_CLKOUT1_PC7 SILABS_DBUS_CMU_CLKOUT1(0x2, 0x7)
#define CMU_CLKOUT1_PC8 SILABS_DBUS_CMU_CLKOUT1(0x2, 0x8)
#define CMU_CLKOUT1_PC9 SILABS_DBUS_CMU_CLKOUT1(0x2, 0x9)
#define CMU_CLKOUT1_PD0 SILABS_DBUS_CMU_CLKOUT1(0x3, 0x0)
#define CMU_CLKOUT1_PD1 SILABS_DBUS_CMU_CLKOUT1(0x3, 0x1)
#define CMU_CLKOUT1_PD2 SILABS_DBUS_CMU_CLKOUT1(0x3, 0x2)
#define CMU_CLKOUT1_PD3 SILABS_DBUS_CMU_CLKOUT1(0x3, 0x3)
#define CMU_CLKOUT1_PD4 SILABS_DBUS_CMU_CLKOUT1(0x3, 0x4)
#define CMU_CLKOUT1_PD5 SILABS_DBUS_CMU_CLKOUT1(0x3, 0x5)
#define CMU_CLKOUT2_PA0 SILABS_DBUS_CMU_CLKOUT2(0x0, 0x0)
#define CMU_CLKOUT2_PA1 SILABS_DBUS_CMU_CLKOUT2(0x0, 0x1)
#define CMU_CLKOUT2_PA2 SILABS_DBUS_CMU_CLKOUT2(0x0, 0x2)
#define CMU_CLKOUT2_PA3 SILABS_DBUS_CMU_CLKOUT2(0x0, 0x3)
#define CMU_CLKOUT2_PA4 SILABS_DBUS_CMU_CLKOUT2(0x0, 0x4)
#define CMU_CLKOUT2_PA5 SILABS_DBUS_CMU_CLKOUT2(0x0, 0x5)
#define CMU_CLKOUT2_PA6 SILABS_DBUS_CMU_CLKOUT2(0x0, 0x6)
#define CMU_CLKOUT2_PA7 SILABS_DBUS_CMU_CLKOUT2(0x0, 0x7)
#define CMU_CLKOUT2_PA8 SILABS_DBUS_CMU_CLKOUT2(0x0, 0x8)
#define CMU_CLKOUT2_PA9 SILABS_DBUS_CMU_CLKOUT2(0x0, 0x9)
#define CMU_CLKOUT2_PB0 SILABS_DBUS_CMU_CLKOUT2(0x1, 0x0)
#define CMU_CLKOUT2_PB1 SILABS_DBUS_CMU_CLKOUT2(0x1, 0x1)
#define CMU_CLKOUT2_PB2 SILABS_DBUS_CMU_CLKOUT2(0x1, 0x2)
#define CMU_CLKOUT2_PB3 SILABS_DBUS_CMU_CLKOUT2(0x1, 0x3)
#define CMU_CLKOUT2_PB4 SILABS_DBUS_CMU_CLKOUT2(0x1, 0x4)
#define CMU_CLKOUT2_PB5 SILABS_DBUS_CMU_CLKOUT2(0x1, 0x5)
#define CMU_CLKIN0_PC0  SILABS_DBUS_CMU_CLKIN0(0x2, 0x0)
#define CMU_CLKIN0_PC1  SILABS_DBUS_CMU_CLKIN0(0x2, 0x1)
#define CMU_CLKIN0_PC2  SILABS_DBUS_CMU_CLKIN0(0x2, 0x2)
#define CMU_CLKIN0_PC3  SILABS_DBUS_CMU_CLKIN0(0x2, 0x3)
#define CMU_CLKIN0_PC4  SILABS_DBUS_CMU_CLKIN0(0x2, 0x4)
#define CMU_CLKIN0_PC5  SILABS_DBUS_CMU_CLKIN0(0x2, 0x5)
#define CMU_CLKIN0_PC6  SILABS_DBUS_CMU_CLKIN0(0x2, 0x6)
#define CMU_CLKIN0_PC7  SILABS_DBUS_CMU_CLKIN0(0x2, 0x7)
#define CMU_CLKIN0_PC8  SILABS_DBUS_CMU_CLKIN0(0x2, 0x8)
#define CMU_CLKIN0_PC9  SILABS_DBUS_CMU_CLKIN0(0x2, 0x9)
#define CMU_CLKIN0_PD0  SILABS_DBUS_CMU_CLKIN0(0x3, 0x0)
#define CMU_CLKIN0_PD1  SILABS_DBUS_CMU_CLKIN0(0x3, 0x1)
#define CMU_CLKIN0_PD2  SILABS_DBUS_CMU_CLKIN0(0x3, 0x2)
#define CMU_CLKIN0_PD3  SILABS_DBUS_CMU_CLKIN0(0x3, 0x3)
#define CMU_CLKIN0_PD4  SILABS_DBUS_CMU_CLKIN0(0x3, 0x4)
#define CMU_CLKIN0_PD5  SILABS_DBUS_CMU_CLKIN0(0x3, 0x5)

#define EUSART0_CS_PA0   SILABS_DBUS_EUSART0_CS(0x0, 0x0)
#define EUSART0_CS_PA1   SILABS_DBUS_EUSART0_CS(0x0, 0x1)
#define EUSART0_CS_PA2   SILABS_DBUS_EUSART0_CS(0x0, 0x2)
#define EUSART0_CS_PA3   SILABS_DBUS_EUSART0_CS(0x0, 0x3)
#define EUSART0_CS_PA4   SILABS_DBUS_EUSART0_CS(0x0, 0x4)
#define EUSART0_CS_PA5   SILABS_DBUS_EUSART0_CS(0x0, 0x5)
#define EUSART0_CS_PA6   SILABS_DBUS_EUSART0_CS(0x0, 0x6)
#define EUSART0_CS_PA7   SILABS_DBUS_EUSART0_CS(0x0, 0x7)
#define EUSART0_CS_PA8   SILABS_DBUS_EUSART0_CS(0x0, 0x8)
#define EUSART0_CS_PA9   SILABS_DBUS_EUSART0_CS(0x0, 0x9)
#define EUSART0_CS_PB0   SILABS_DBUS_EUSART0_CS(0x1, 0x0)
#define EUSART0_CS_PB1   SILABS_DBUS_EUSART0_CS(0x1, 0x1)
#define EUSART0_CS_PB2   SILABS_DBUS_EUSART0_CS(0x1, 0x2)
#define EUSART0_CS_PB3   SILABS_DBUS_EUSART0_CS(0x1, 0x3)
#define EUSART0_CS_PB4   SILABS_DBUS_EUSART0_CS(0x1, 0x4)
#define EUSART0_CS_PB5   SILABS_DBUS_EUSART0_CS(0x1, 0x5)
#define EUSART0_RTS_PA0  SILABS_DBUS_EUSART0_RTS(0x0, 0x0)
#define EUSART0_RTS_PA1  SILABS_DBUS_EUSART0_RTS(0x0, 0x1)
#define EUSART0_RTS_PA2  SILABS_DBUS_EUSART0_RTS(0x0, 0x2)
#define EUSART0_RTS_PA3  SILABS_DBUS_EUSART0_RTS(0x0, 0x3)
#define EUSART0_RTS_PA4  SILABS_DBUS_EUSART0_RTS(0x0, 0x4)
#define EUSART0_RTS_PA5  SILABS_DBUS_EUSART0_RTS(0x0, 0x5)
#define EUSART0_RTS_PA6  SILABS_DBUS_EUSART0_RTS(0x0, 0x6)
#define EUSART0_RTS_PA7  SILABS_DBUS_EUSART0_RTS(0x0, 0x7)
#define EUSART0_RTS_PA8  SILABS_DBUS_EUSART0_RTS(0x0, 0x8)
#define EUSART0_RTS_PA9  SILABS_DBUS_EUSART0_RTS(0x0, 0x9)
#define EUSART0_RTS_PB0  SILABS_DBUS_EUSART0_RTS(0x1, 0x0)
#define EUSART0_RTS_PB1  SILABS_DBUS_EUSART0_RTS(0x1, 0x1)
#define EUSART0_RTS_PB2  SILABS_DBUS_EUSART0_RTS(0x1, 0x2)
#define EUSART0_RTS_PB3  SILABS_DBUS_EUSART0_RTS(0x1, 0x3)
#define EUSART0_RTS_PB4  SILABS_DBUS_EUSART0_RTS(0x1, 0x4)
#define EUSART0_RTS_PB5  SILABS_DBUS_EUSART0_RTS(0x1, 0x5)
#define EUSART0_RX_PA0   SILABS_DBUS_EUSART0_RX(0x0, 0x0)
#define EUSART0_RX_PA1   SILABS_DBUS_EUSART0_RX(0x0, 0x1)
#define EUSART0_RX_PA2   SILABS_DBUS_EUSART0_RX(0x0, 0x2)
#define EUSART0_RX_PA3   SILABS_DBUS_EUSART0_RX(0x0, 0x3)
#define EUSART0_RX_PA4   SILABS_DBUS_EUSART0_RX(0x0, 0x4)
#define EUSART0_RX_PA5   SILABS_DBUS_EUSART0_RX(0x0, 0x5)
#define EUSART0_RX_PA6   SILABS_DBUS_EUSART0_RX(0x0, 0x6)
#define EUSART0_RX_PA7   SILABS_DBUS_EUSART0_RX(0x0, 0x7)
#define EUSART0_RX_PA8   SILABS_DBUS_EUSART0_RX(0x0, 0x8)
#define EUSART0_RX_PA9   SILABS_DBUS_EUSART0_RX(0x0, 0x9)
#define EUSART0_RX_PB0   SILABS_DBUS_EUSART0_RX(0x1, 0x0)
#define EUSART0_RX_PB1   SILABS_DBUS_EUSART0_RX(0x1, 0x1)
#define EUSART0_RX_PB2   SILABS_DBUS_EUSART0_RX(0x1, 0x2)
#define EUSART0_RX_PB3   SILABS_DBUS_EUSART0_RX(0x1, 0x3)
#define EUSART0_RX_PB4   SILABS_DBUS_EUSART0_RX(0x1, 0x4)
#define EUSART0_RX_PB5   SILABS_DBUS_EUSART0_RX(0x1, 0x5)
#define EUSART0_SCLK_PA0 SILABS_DBUS_EUSART0_SCLK(0x0, 0x0)
#define EUSART0_SCLK_PA1 SILABS_DBUS_EUSART0_SCLK(0x0, 0x1)
#define EUSART0_SCLK_PA2 SILABS_DBUS_EUSART0_SCLK(0x0, 0x2)
#define EUSART0_SCLK_PA3 SILABS_DBUS_EUSART0_SCLK(0x0, 0x3)
#define EUSART0_SCLK_PA4 SILABS_DBUS_EUSART0_SCLK(0x0, 0x4)
#define EUSART0_SCLK_PA5 SILABS_DBUS_EUSART0_SCLK(0x0, 0x5)
#define EUSART0_SCLK_PA6 SILABS_DBUS_EUSART0_SCLK(0x0, 0x6)
#define EUSART0_SCLK_PA7 SILABS_DBUS_EUSART0_SCLK(0x0, 0x7)
#define EUSART0_SCLK_PA8 SILABS_DBUS_EUSART0_SCLK(0x0, 0x8)
#define EUSART0_SCLK_PA9 SILABS_DBUS_EUSART0_SCLK(0x0, 0x9)
#define EUSART0_SCLK_PB0 SILABS_DBUS_EUSART0_SCLK(0x1, 0x0)
#define EUSART0_SCLK_PB1 SILABS_DBUS_EUSART0_SCLK(0x1, 0x1)
#define EUSART0_SCLK_PB2 SILABS_DBUS_EUSART0_SCLK(0x1, 0x2)
#define EUSART0_SCLK_PB3 SILABS_DBUS_EUSART0_SCLK(0x1, 0x3)
#define EUSART0_SCLK_PB4 SILABS_DBUS_EUSART0_SCLK(0x1, 0x4)
#define EUSART0_SCLK_PB5 SILABS_DBUS_EUSART0_SCLK(0x1, 0x5)
#define EUSART0_TX_PA0   SILABS_DBUS_EUSART0_TX(0x0, 0x0)
#define EUSART0_TX_PA1   SILABS_DBUS_EUSART0_TX(0x0, 0x1)
#define EUSART0_TX_PA2   SILABS_DBUS_EUSART0_TX(0x0, 0x2)
#define EUSART0_TX_PA3   SILABS_DBUS_EUSART0_TX(0x0, 0x3)
#define EUSART0_TX_PA4   SILABS_DBUS_EUSART0_TX(0x0, 0x4)
#define EUSART0_TX_PA5   SILABS_DBUS_EUSART0_TX(0x0, 0x5)
#define EUSART0_TX_PA6   SILABS_DBUS_EUSART0_TX(0x0, 0x6)
#define EUSART0_TX_PA7   SILABS_DBUS_EUSART0_TX(0x0, 0x7)
#define EUSART0_TX_PA8   SILABS_DBUS_EUSART0_TX(0x0, 0x8)
#define EUSART0_TX_PA9   SILABS_DBUS_EUSART0_TX(0x0, 0x9)
#define EUSART0_TX_PB0   SILABS_DBUS_EUSART0_TX(0x1, 0x0)
#define EUSART0_TX_PB1   SILABS_DBUS_EUSART0_TX(0x1, 0x1)
#define EUSART0_TX_PB2   SILABS_DBUS_EUSART0_TX(0x1, 0x2)
#define EUSART0_TX_PB3   SILABS_DBUS_EUSART0_TX(0x1, 0x3)
#define EUSART0_TX_PB4   SILABS_DBUS_EUSART0_TX(0x1, 0x4)
#define EUSART0_TX_PB5   SILABS_DBUS_EUSART0_TX(0x1, 0x5)
#define EUSART0_CTS_PA0  SILABS_DBUS_EUSART0_CTS(0x0, 0x0)
#define EUSART0_CTS_PA1  SILABS_DBUS_EUSART0_CTS(0x0, 0x1)
#define EUSART0_CTS_PA2  SILABS_DBUS_EUSART0_CTS(0x0, 0x2)
#define EUSART0_CTS_PA3  SILABS_DBUS_EUSART0_CTS(0x0, 0x3)
#define EUSART0_CTS_PA4  SILABS_DBUS_EUSART0_CTS(0x0, 0x4)
#define EUSART0_CTS_PA5  SILABS_DBUS_EUSART0_CTS(0x0, 0x5)
#define EUSART0_CTS_PA6  SILABS_DBUS_EUSART0_CTS(0x0, 0x6)
#define EUSART0_CTS_PA7  SILABS_DBUS_EUSART0_CTS(0x0, 0x7)
#define EUSART0_CTS_PA8  SILABS_DBUS_EUSART0_CTS(0x0, 0x8)
#define EUSART0_CTS_PA9  SILABS_DBUS_EUSART0_CTS(0x0, 0x9)
#define EUSART0_CTS_PB0  SILABS_DBUS_EUSART0_CTS(0x1, 0x0)
#define EUSART0_CTS_PB1  SILABS_DBUS_EUSART0_CTS(0x1, 0x1)
#define EUSART0_CTS_PB2  SILABS_DBUS_EUSART0_CTS(0x1, 0x2)
#define EUSART0_CTS_PB3  SILABS_DBUS_EUSART0_CTS(0x1, 0x3)
#define EUSART0_CTS_PB4  SILABS_DBUS_EUSART0_CTS(0x1, 0x4)
#define EUSART0_CTS_PB5  SILABS_DBUS_EUSART0_CTS(0x1, 0x5)

#define EUSART1_CS_PA0   SILABS_DBUS_EUSART1_CS(0x0, 0x0)
#define EUSART1_CS_PA1   SILABS_DBUS_EUSART1_CS(0x0, 0x1)
#define EUSART1_CS_PA2   SILABS_DBUS_EUSART1_CS(0x0, 0x2)
#define EUSART1_CS_PA3   SILABS_DBUS_EUSART1_CS(0x0, 0x3)
#define EUSART1_CS_PA4   SILABS_DBUS_EUSART1_CS(0x0, 0x4)
#define EUSART1_CS_PA5   SILABS_DBUS_EUSART1_CS(0x0, 0x5)
#define EUSART1_CS_PA6   SILABS_DBUS_EUSART1_CS(0x0, 0x6)
#define EUSART1_CS_PA7   SILABS_DBUS_EUSART1_CS(0x0, 0x7)
#define EUSART1_CS_PA8   SILABS_DBUS_EUSART1_CS(0x0, 0x8)
#define EUSART1_CS_PA9   SILABS_DBUS_EUSART1_CS(0x0, 0x9)
#define EUSART1_CS_PB0   SILABS_DBUS_EUSART1_CS(0x1, 0x0)
#define EUSART1_CS_PB1   SILABS_DBUS_EUSART1_CS(0x1, 0x1)
#define EUSART1_CS_PB2   SILABS_DBUS_EUSART1_CS(0x1, 0x2)
#define EUSART1_CS_PB3   SILABS_DBUS_EUSART1_CS(0x1, 0x3)
#define EUSART1_CS_PB4   SILABS_DBUS_EUSART1_CS(0x1, 0x4)
#define EUSART1_CS_PB5   SILABS_DBUS_EUSART1_CS(0x1, 0x5)
#define EUSART1_CS_PC0   SILABS_DBUS_EUSART1_CS(0x2, 0x0)
#define EUSART1_CS_PC1   SILABS_DBUS_EUSART1_CS(0x2, 0x1)
#define EUSART1_CS_PC2   SILABS_DBUS_EUSART1_CS(0x2, 0x2)
#define EUSART1_CS_PC3   SILABS_DBUS_EUSART1_CS(0x2, 0x3)
#define EUSART1_CS_PC4   SILABS_DBUS_EUSART1_CS(0x2, 0x4)
#define EUSART1_CS_PC5   SILABS_DBUS_EUSART1_CS(0x2, 0x5)
#define EUSART1_CS_PC6   SILABS_DBUS_EUSART1_CS(0x2, 0x6)
#define EUSART1_CS_PC7   SILABS_DBUS_EUSART1_CS(0x2, 0x7)
#define EUSART1_CS_PC8   SILABS_DBUS_EUSART1_CS(0x2, 0x8)
#define EUSART1_CS_PC9   SILABS_DBUS_EUSART1_CS(0x2, 0x9)
#define EUSART1_CS_PD0   SILABS_DBUS_EUSART1_CS(0x3, 0x0)
#define EUSART1_CS_PD1   SILABS_DBUS_EUSART1_CS(0x3, 0x1)
#define EUSART1_CS_PD2   SILABS_DBUS_EUSART1_CS(0x3, 0x2)
#define EUSART1_CS_PD3   SILABS_DBUS_EUSART1_CS(0x3, 0x3)
#define EUSART1_CS_PD4   SILABS_DBUS_EUSART1_CS(0x3, 0x4)
#define EUSART1_CS_PD5   SILABS_DBUS_EUSART1_CS(0x3, 0x5)
#define EUSART1_RTS_PA0  SILABS_DBUS_EUSART1_RTS(0x0, 0x0)
#define EUSART1_RTS_PA1  SILABS_DBUS_EUSART1_RTS(0x0, 0x1)
#define EUSART1_RTS_PA2  SILABS_DBUS_EUSART1_RTS(0x0, 0x2)
#define EUSART1_RTS_PA3  SILABS_DBUS_EUSART1_RTS(0x0, 0x3)
#define EUSART1_RTS_PA4  SILABS_DBUS_EUSART1_RTS(0x0, 0x4)
#define EUSART1_RTS_PA5  SILABS_DBUS_EUSART1_RTS(0x0, 0x5)
#define EUSART1_RTS_PA6  SILABS_DBUS_EUSART1_RTS(0x0, 0x6)
#define EUSART1_RTS_PA7  SILABS_DBUS_EUSART1_RTS(0x0, 0x7)
#define EUSART1_RTS_PA8  SILABS_DBUS_EUSART1_RTS(0x0, 0x8)
#define EUSART1_RTS_PA9  SILABS_DBUS_EUSART1_RTS(0x0, 0x9)
#define EUSART1_RTS_PB0  SILABS_DBUS_EUSART1_RTS(0x1, 0x0)
#define EUSART1_RTS_PB1  SILABS_DBUS_EUSART1_RTS(0x1, 0x1)
#define EUSART1_RTS_PB2  SILABS_DBUS_EUSART1_RTS(0x1, 0x2)
#define EUSART1_RTS_PB3  SILABS_DBUS_EUSART1_RTS(0x1, 0x3)
#define EUSART1_RTS_PB4  SILABS_DBUS_EUSART1_RTS(0x1, 0x4)
#define EUSART1_RTS_PB5  SILABS_DBUS_EUSART1_RTS(0x1, 0x5)
#define EUSART1_RTS_PC0  SILABS_DBUS_EUSART1_RTS(0x2, 0x0)
#define EUSART1_RTS_PC1  SILABS_DBUS_EUSART1_RTS(0x2, 0x1)
#define EUSART1_RTS_PC2  SILABS_DBUS_EUSART1_RTS(0x2, 0x2)
#define EUSART1_RTS_PC3  SILABS_DBUS_EUSART1_RTS(0x2, 0x3)
#define EUSART1_RTS_PC4  SILABS_DBUS_EUSART1_RTS(0x2, 0x4)
#define EUSART1_RTS_PC5  SILABS_DBUS_EUSART1_RTS(0x2, 0x5)
#define EUSART1_RTS_PC6  SILABS_DBUS_EUSART1_RTS(0x2, 0x6)
#define EUSART1_RTS_PC7  SILABS_DBUS_EUSART1_RTS(0x2, 0x7)
#define EUSART1_RTS_PC8  SILABS_DBUS_EUSART1_RTS(0x2, 0x8)
#define EUSART1_RTS_PC9  SILABS_DBUS_EUSART1_RTS(0x2, 0x9)
#define EUSART1_RTS_PD0  SILABS_DBUS_EUSART1_RTS(0x3, 0x0)
#define EUSART1_RTS_PD1  SILABS_DBUS_EUSART1_RTS(0x3, 0x1)
#define EUSART1_RTS_PD2  SILABS_DBUS_EUSART1_RTS(0x3, 0x2)
#define EUSART1_RTS_PD3  SILABS_DBUS_EUSART1_RTS(0x3, 0x3)
#define EUSART1_RTS_PD4  SILABS_DBUS_EUSART1_RTS(0x3, 0x4)
#define EUSART1_RTS_PD5  SILABS_DBUS_EUSART1_RTS(0x3, 0x5)
#define EUSART1_RX_PA0   SILABS_DBUS_EUSART1_RX(0x0, 0x0)
#define EUSART1_RX_PA1   SILABS_DBUS_EUSART1_RX(0x0, 0x1)
#define EUSART1_RX_PA2   SILABS_DBUS_EUSART1_RX(0x0, 0x2)
#define EUSART1_RX_PA3   SILABS_DBUS_EUSART1_RX(0x0, 0x3)
#define EUSART1_RX_PA4   SILABS_DBUS_EUSART1_RX(0x0, 0x4)
#define EUSART1_RX_PA5   SILABS_DBUS_EUSART1_RX(0x0, 0x5)
#define EUSART1_RX_PA6   SILABS_DBUS_EUSART1_RX(0x0, 0x6)
#define EUSART1_RX_PA7   SILABS_DBUS_EUSART1_RX(0x0, 0x7)
#define EUSART1_RX_PA8   SILABS_DBUS_EUSART1_RX(0x0, 0x8)
#define EUSART1_RX_PA9   SILABS_DBUS_EUSART1_RX(0x0, 0x9)
#define EUSART1_RX_PB0   SILABS_DBUS_EUSART1_RX(0x1, 0x0)
#define EUSART1_RX_PB1   SILABS_DBUS_EUSART1_RX(0x1, 0x1)
#define EUSART1_RX_PB2   SILABS_DBUS_EUSART1_RX(0x1, 0x2)
#define EUSART1_RX_PB3   SILABS_DBUS_EUSART1_RX(0x1, 0x3)
#define EUSART1_RX_PB4   SILABS_DBUS_EUSART1_RX(0x1, 0x4)
#define EUSART1_RX_PB5   SILABS_DBUS_EUSART1_RX(0x1, 0x5)
#define EUSART1_RX_PC0   SILABS_DBUS_EUSART1_RX(0x2, 0x0)
#define EUSART1_RX_PC1   SILABS_DBUS_EUSART1_RX(0x2, 0x1)
#define EUSART1_RX_PC2   SILABS_DBUS_EUSART1_RX(0x2, 0x2)
#define EUSART1_RX_PC3   SILABS_DBUS_EUSART1_RX(0x2, 0x3)
#define EUSART1_RX_PC4   SILABS_DBUS_EUSART1_RX(0x2, 0x4)
#define EUSART1_RX_PC5   SILABS_DBUS_EUSART1_RX(0x2, 0x5)
#define EUSART1_RX_PC6   SILABS_DBUS_EUSART1_RX(0x2, 0x6)
#define EUSART1_RX_PC7   SILABS_DBUS_EUSART1_RX(0x2, 0x7)
#define EUSART1_RX_PC8   SILABS_DBUS_EUSART1_RX(0x2, 0x8)
#define EUSART1_RX_PC9   SILABS_DBUS_EUSART1_RX(0x2, 0x9)
#define EUSART1_RX_PD0   SILABS_DBUS_EUSART1_RX(0x3, 0x0)
#define EUSART1_RX_PD1   SILABS_DBUS_EUSART1_RX(0x3, 0x1)
#define EUSART1_RX_PD2   SILABS_DBUS_EUSART1_RX(0x3, 0x2)
#define EUSART1_RX_PD3   SILABS_DBUS_EUSART1_RX(0x3, 0x3)
#define EUSART1_RX_PD4   SILABS_DBUS_EUSART1_RX(0x3, 0x4)
#define EUSART1_RX_PD5   SILABS_DBUS_EUSART1_RX(0x3, 0x5)
#define EUSART1_SCLK_PA0 SILABS_DBUS_EUSART1_SCLK(0x0, 0x0)
#define EUSART1_SCLK_PA1 SILABS_DBUS_EUSART1_SCLK(0x0, 0x1)
#define EUSART1_SCLK_PA2 SILABS_DBUS_EUSART1_SCLK(0x0, 0x2)
#define EUSART1_SCLK_PA3 SILABS_DBUS_EUSART1_SCLK(0x0, 0x3)
#define EUSART1_SCLK_PA4 SILABS_DBUS_EUSART1_SCLK(0x0, 0x4)
#define EUSART1_SCLK_PA5 SILABS_DBUS_EUSART1_SCLK(0x0, 0x5)
#define EUSART1_SCLK_PA6 SILABS_DBUS_EUSART1_SCLK(0x0, 0x6)
#define EUSART1_SCLK_PA7 SILABS_DBUS_EUSART1_SCLK(0x0, 0x7)
#define EUSART1_SCLK_PA8 SILABS_DBUS_EUSART1_SCLK(0x0, 0x8)
#define EUSART1_SCLK_PA9 SILABS_DBUS_EUSART1_SCLK(0x0, 0x9)
#define EUSART1_SCLK_PB0 SILABS_DBUS_EUSART1_SCLK(0x1, 0x0)
#define EUSART1_SCLK_PB1 SILABS_DBUS_EUSART1_SCLK(0x1, 0x1)
#define EUSART1_SCLK_PB2 SILABS_DBUS_EUSART1_SCLK(0x1, 0x2)
#define EUSART1_SCLK_PB3 SILABS_DBUS_EUSART1_SCLK(0x1, 0x3)
#define EUSART1_SCLK_PB4 SILABS_DBUS_EUSART1_SCLK(0x1, 0x4)
#define EUSART1_SCLK_PB5 SILABS_DBUS_EUSART1_SCLK(0x1, 0x5)
#define EUSART1_SCLK_PC0 SILABS_DBUS_EUSART1_SCLK(0x2, 0x0)
#define EUSART1_SCLK_PC1 SILABS_DBUS_EUSART1_SCLK(0x2, 0x1)
#define EUSART1_SCLK_PC2 SILABS_DBUS_EUSART1_SCLK(0x2, 0x2)
#define EUSART1_SCLK_PC3 SILABS_DBUS_EUSART1_SCLK(0x2, 0x3)
#define EUSART1_SCLK_PC4 SILABS_DBUS_EUSART1_SCLK(0x2, 0x4)
#define EUSART1_SCLK_PC5 SILABS_DBUS_EUSART1_SCLK(0x2, 0x5)
#define EUSART1_SCLK_PC6 SILABS_DBUS_EUSART1_SCLK(0x2, 0x6)
#define EUSART1_SCLK_PC7 SILABS_DBUS_EUSART1_SCLK(0x2, 0x7)
#define EUSART1_SCLK_PC8 SILABS_DBUS_EUSART1_SCLK(0x2, 0x8)
#define EUSART1_SCLK_PC9 SILABS_DBUS_EUSART1_SCLK(0x2, 0x9)
#define EUSART1_SCLK_PD0 SILABS_DBUS_EUSART1_SCLK(0x3, 0x0)
#define EUSART1_SCLK_PD1 SILABS_DBUS_EUSART1_SCLK(0x3, 0x1)
#define EUSART1_SCLK_PD2 SILABS_DBUS_EUSART1_SCLK(0x3, 0x2)
#define EUSART1_SCLK_PD3 SILABS_DBUS_EUSART1_SCLK(0x3, 0x3)
#define EUSART1_SCLK_PD4 SILABS_DBUS_EUSART1_SCLK(0x3, 0x4)
#define EUSART1_SCLK_PD5 SILABS_DBUS_EUSART1_SCLK(0x3, 0x5)
#define EUSART1_TX_PA0   SILABS_DBUS_EUSART1_TX(0x0, 0x0)
#define EUSART1_TX_PA1   SILABS_DBUS_EUSART1_TX(0x0, 0x1)
#define EUSART1_TX_PA2   SILABS_DBUS_EUSART1_TX(0x0, 0x2)
#define EUSART1_TX_PA3   SILABS_DBUS_EUSART1_TX(0x0, 0x3)
#define EUSART1_TX_PA4   SILABS_DBUS_EUSART1_TX(0x0, 0x4)
#define EUSART1_TX_PA5   SILABS_DBUS_EUSART1_TX(0x0, 0x5)
#define EUSART1_TX_PA6   SILABS_DBUS_EUSART1_TX(0x0, 0x6)
#define EUSART1_TX_PA7   SILABS_DBUS_EUSART1_TX(0x0, 0x7)
#define EUSART1_TX_PA8   SILABS_DBUS_EUSART1_TX(0x0, 0x8)
#define EUSART1_TX_PA9   SILABS_DBUS_EUSART1_TX(0x0, 0x9)
#define EUSART1_TX_PB0   SILABS_DBUS_EUSART1_TX(0x1, 0x0)
#define EUSART1_TX_PB1   SILABS_DBUS_EUSART1_TX(0x1, 0x1)
#define EUSART1_TX_PB2   SILABS_DBUS_EUSART1_TX(0x1, 0x2)
#define EUSART1_TX_PB3   SILABS_DBUS_EUSART1_TX(0x1, 0x3)
#define EUSART1_TX_PB4   SILABS_DBUS_EUSART1_TX(0x1, 0x4)
#define EUSART1_TX_PB5   SILABS_DBUS_EUSART1_TX(0x1, 0x5)
#define EUSART1_TX_PC0   SILABS_DBUS_EUSART1_TX(0x2, 0x0)
#define EUSART1_TX_PC1   SILABS_DBUS_EUSART1_TX(0x2, 0x1)
#define EUSART1_TX_PC2   SILABS_DBUS_EUSART1_TX(0x2, 0x2)
#define EUSART1_TX_PC3   SILABS_DBUS_EUSART1_TX(0x2, 0x3)
#define EUSART1_TX_PC4   SILABS_DBUS_EUSART1_TX(0x2, 0x4)
#define EUSART1_TX_PC5   SILABS_DBUS_EUSART1_TX(0x2, 0x5)
#define EUSART1_TX_PC6   SILABS_DBUS_EUSART1_TX(0x2, 0x6)
#define EUSART1_TX_PC7   SILABS_DBUS_EUSART1_TX(0x2, 0x7)
#define EUSART1_TX_PC8   SILABS_DBUS_EUSART1_TX(0x2, 0x8)
#define EUSART1_TX_PC9   SILABS_DBUS_EUSART1_TX(0x2, 0x9)
#define EUSART1_TX_PD0   SILABS_DBUS_EUSART1_TX(0x3, 0x0)
#define EUSART1_TX_PD1   SILABS_DBUS_EUSART1_TX(0x3, 0x1)
#define EUSART1_TX_PD2   SILABS_DBUS_EUSART1_TX(0x3, 0x2)
#define EUSART1_TX_PD3   SILABS_DBUS_EUSART1_TX(0x3, 0x3)
#define EUSART1_TX_PD4   SILABS_DBUS_EUSART1_TX(0x3, 0x4)
#define EUSART1_TX_PD5   SILABS_DBUS_EUSART1_TX(0x3, 0x5)
#define EUSART1_CTS_PA0  SILABS_DBUS_EUSART1_CTS(0x0, 0x0)
#define EUSART1_CTS_PA1  SILABS_DBUS_EUSART1_CTS(0x0, 0x1)
#define EUSART1_CTS_PA2  SILABS_DBUS_EUSART1_CTS(0x0, 0x2)
#define EUSART1_CTS_PA3  SILABS_DBUS_EUSART1_CTS(0x0, 0x3)
#define EUSART1_CTS_PA4  SILABS_DBUS_EUSART1_CTS(0x0, 0x4)
#define EUSART1_CTS_PA5  SILABS_DBUS_EUSART1_CTS(0x0, 0x5)
#define EUSART1_CTS_PA6  SILABS_DBUS_EUSART1_CTS(0x0, 0x6)
#define EUSART1_CTS_PA7  SILABS_DBUS_EUSART1_CTS(0x0, 0x7)
#define EUSART1_CTS_PA8  SILABS_DBUS_EUSART1_CTS(0x0, 0x8)
#define EUSART1_CTS_PA9  SILABS_DBUS_EUSART1_CTS(0x0, 0x9)
#define EUSART1_CTS_PB0  SILABS_DBUS_EUSART1_CTS(0x1, 0x0)
#define EUSART1_CTS_PB1  SILABS_DBUS_EUSART1_CTS(0x1, 0x1)
#define EUSART1_CTS_PB2  SILABS_DBUS_EUSART1_CTS(0x1, 0x2)
#define EUSART1_CTS_PB3  SILABS_DBUS_EUSART1_CTS(0x1, 0x3)
#define EUSART1_CTS_PB4  SILABS_DBUS_EUSART1_CTS(0x1, 0x4)
#define EUSART1_CTS_PB5  SILABS_DBUS_EUSART1_CTS(0x1, 0x5)
#define EUSART1_CTS_PC0  SILABS_DBUS_EUSART1_CTS(0x2, 0x0)
#define EUSART1_CTS_PC1  SILABS_DBUS_EUSART1_CTS(0x2, 0x1)
#define EUSART1_CTS_PC2  SILABS_DBUS_EUSART1_CTS(0x2, 0x2)
#define EUSART1_CTS_PC3  SILABS_DBUS_EUSART1_CTS(0x2, 0x3)
#define EUSART1_CTS_PC4  SILABS_DBUS_EUSART1_CTS(0x2, 0x4)
#define EUSART1_CTS_PC5  SILABS_DBUS_EUSART1_CTS(0x2, 0x5)
#define EUSART1_CTS_PC6  SILABS_DBUS_EUSART1_CTS(0x2, 0x6)
#define EUSART1_CTS_PC7  SILABS_DBUS_EUSART1_CTS(0x2, 0x7)
#define EUSART1_CTS_PC8  SILABS_DBUS_EUSART1_CTS(0x2, 0x8)
#define EUSART1_CTS_PC9  SILABS_DBUS_EUSART1_CTS(0x2, 0x9)
#define EUSART1_CTS_PD0  SILABS_DBUS_EUSART1_CTS(0x3, 0x0)
#define EUSART1_CTS_PD1  SILABS_DBUS_EUSART1_CTS(0x3, 0x1)
#define EUSART1_CTS_PD2  SILABS_DBUS_EUSART1_CTS(0x3, 0x2)
#define EUSART1_CTS_PD3  SILABS_DBUS_EUSART1_CTS(0x3, 0x3)
#define EUSART1_CTS_PD4  SILABS_DBUS_EUSART1_CTS(0x3, 0x4)
#define EUSART1_CTS_PD5  SILABS_DBUS_EUSART1_CTS(0x3, 0x5)

#define PTI_DCLK_PC0   SILABS_DBUS_PTI_DCLK(0x2, 0x0)
#define PTI_DCLK_PC1   SILABS_DBUS_PTI_DCLK(0x2, 0x1)
#define PTI_DCLK_PC2   SILABS_DBUS_PTI_DCLK(0x2, 0x2)
#define PTI_DCLK_PC3   SILABS_DBUS_PTI_DCLK(0x2, 0x3)
#define PTI_DCLK_PC4   SILABS_DBUS_PTI_DCLK(0x2, 0x4)
#define PTI_DCLK_PC5   SILABS_DBUS_PTI_DCLK(0x2, 0x5)
#define PTI_DCLK_PC6   SILABS_DBUS_PTI_DCLK(0x2, 0x6)
#define PTI_DCLK_PC7   SILABS_DBUS_PTI_DCLK(0x2, 0x7)
#define PTI_DCLK_PC8   SILABS_DBUS_PTI_DCLK(0x2, 0x8)
#define PTI_DCLK_PC9   SILABS_DBUS_PTI_DCLK(0x2, 0x9)
#define PTI_DCLK_PD0   SILABS_DBUS_PTI_DCLK(0x3, 0x0)
#define PTI_DCLK_PD1   SILABS_DBUS_PTI_DCLK(0x3, 0x1)
#define PTI_DCLK_PD2   SILABS_DBUS_PTI_DCLK(0x3, 0x2)
#define PTI_DCLK_PD3   SILABS_DBUS_PTI_DCLK(0x3, 0x3)
#define PTI_DCLK_PD4   SILABS_DBUS_PTI_DCLK(0x3, 0x4)
#define PTI_DCLK_PD5   SILABS_DBUS_PTI_DCLK(0x3, 0x5)
#define PTI_DFRAME_PC0 SILABS_DBUS_PTI_DFRAME(0x2, 0x0)
#define PTI_DFRAME_PC1 SILABS_DBUS_PTI_DFRAME(0x2, 0x1)
#define PTI_DFRAME_PC2 SILABS_DBUS_PTI_DFRAME(0x2, 0x2)
#define PTI_DFRAME_PC3 SILABS_DBUS_PTI_DFRAME(0x2, 0x3)
#define PTI_DFRAME_PC4 SILABS_DBUS_PTI_DFRAME(0x2, 0x4)
#define PTI_DFRAME_PC5 SILABS_DBUS_PTI_DFRAME(0x2, 0x5)
#define PTI_DFRAME_PC6 SILABS_DBUS_PTI_DFRAME(0x2, 0x6)
#define PTI_DFRAME_PC7 SILABS_DBUS_PTI_DFRAME(0x2, 0x7)
#define PTI_DFRAME_PC8 SILABS_DBUS_PTI_DFRAME(0x2, 0x8)
#define PTI_DFRAME_PC9 SILABS_DBUS_PTI_DFRAME(0x2, 0x9)
#define PTI_DFRAME_PD0 SILABS_DBUS_PTI_DFRAME(0x3, 0x0)
#define PTI_DFRAME_PD1 SILABS_DBUS_PTI_DFRAME(0x3, 0x1)
#define PTI_DFRAME_PD2 SILABS_DBUS_PTI_DFRAME(0x3, 0x2)
#define PTI_DFRAME_PD3 SILABS_DBUS_PTI_DFRAME(0x3, 0x3)
#define PTI_DFRAME_PD4 SILABS_DBUS_PTI_DFRAME(0x3, 0x4)
#define PTI_DFRAME_PD5 SILABS_DBUS_PTI_DFRAME(0x3, 0x5)
#define PTI_DOUT_PC0   SILABS_DBUS_PTI_DOUT(0x2, 0x0)
#define PTI_DOUT_PC1   SILABS_DBUS_PTI_DOUT(0x2, 0x1)
#define PTI_DOUT_PC2   SILABS_DBUS_PTI_DOUT(0x2, 0x2)
#define PTI_DOUT_PC3   SILABS_DBUS_PTI_DOUT(0x2, 0x3)
#define PTI_DOUT_PC4   SILABS_DBUS_PTI_DOUT(0x2, 0x4)
#define PTI_DOUT_PC5   SILABS_DBUS_PTI_DOUT(0x2, 0x5)
#define PTI_DOUT_PC6   SILABS_DBUS_PTI_DOUT(0x2, 0x6)
#define PTI_DOUT_PC7   SILABS_DBUS_PTI_DOUT(0x2, 0x7)
#define PTI_DOUT_PC8   SILABS_DBUS_PTI_DOUT(0x2, 0x8)
#define PTI_DOUT_PC9   SILABS_DBUS_PTI_DOUT(0x2, 0x9)
#define PTI_DOUT_PD0   SILABS_DBUS_PTI_DOUT(0x3, 0x0)
#define PTI_DOUT_PD1   SILABS_DBUS_PTI_DOUT(0x3, 0x1)
#define PTI_DOUT_PD2   SILABS_DBUS_PTI_DOUT(0x3, 0x2)
#define PTI_DOUT_PD3   SILABS_DBUS_PTI_DOUT(0x3, 0x3)
#define PTI_DOUT_PD4   SILABS_DBUS_PTI_DOUT(0x3, 0x4)
#define PTI_DOUT_PD5   SILABS_DBUS_PTI_DOUT(0x3, 0x5)

#define I2C0_SCL_PA0 SILABS_DBUS_I2C0_SCL(0x0, 0x0)
#define I2C0_SCL_PA1 SILABS_DBUS_I2C0_SCL(0x0, 0x1)
#define I2C0_SCL_PA2 SILABS_DBUS_I2C0_SCL(0x0, 0x2)
#define I2C0_SCL_PA3 SILABS_DBUS_I2C0_SCL(0x0, 0x3)
#define I2C0_SCL_PA4 SILABS_DBUS_I2C0_SCL(0x0, 0x4)
#define I2C0_SCL_PA5 SILABS_DBUS_I2C0_SCL(0x0, 0x5)
#define I2C0_SCL_PA6 SILABS_DBUS_I2C0_SCL(0x0, 0x6)
#define I2C0_SCL_PA7 SILABS_DBUS_I2C0_SCL(0x0, 0x7)
#define I2C0_SCL_PA8 SILABS_DBUS_I2C0_SCL(0x0, 0x8)
#define I2C0_SCL_PA9 SILABS_DBUS_I2C0_SCL(0x0, 0x9)
#define I2C0_SCL_PB0 SILABS_DBUS_I2C0_SCL(0x1, 0x0)
#define I2C0_SCL_PB1 SILABS_DBUS_I2C0_SCL(0x1, 0x1)
#define I2C0_SCL_PB2 SILABS_DBUS_I2C0_SCL(0x1, 0x2)
#define I2C0_SCL_PB3 SILABS_DBUS_I2C0_SCL(0x1, 0x3)
#define I2C0_SCL_PB4 SILABS_DBUS_I2C0_SCL(0x1, 0x4)
#define I2C0_SCL_PB5 SILABS_DBUS_I2C0_SCL(0x1, 0x5)
#define I2C0_SCL_PC0 SILABS_DBUS_I2C0_SCL(0x2, 0x0)
#define I2C0_SCL_PC1 SILABS_DBUS_I2C0_SCL(0x2, 0x1)
#define I2C0_SCL_PC2 SILABS_DBUS_I2C0_SCL(0x2, 0x2)
#define I2C0_SCL_PC3 SILABS_DBUS_I2C0_SCL(0x2, 0x3)
#define I2C0_SCL_PC4 SILABS_DBUS_I2C0_SCL(0x2, 0x4)
#define I2C0_SCL_PC5 SILABS_DBUS_I2C0_SCL(0x2, 0x5)
#define I2C0_SCL_PC6 SILABS_DBUS_I2C0_SCL(0x2, 0x6)
#define I2C0_SCL_PC7 SILABS_DBUS_I2C0_SCL(0x2, 0x7)
#define I2C0_SCL_PC8 SILABS_DBUS_I2C0_SCL(0x2, 0x8)
#define I2C0_SCL_PC9 SILABS_DBUS_I2C0_SCL(0x2, 0x9)
#define I2C0_SCL_PD0 SILABS_DBUS_I2C0_SCL(0x3, 0x0)
#define I2C0_SCL_PD1 SILABS_DBUS_I2C0_SCL(0x3, 0x1)
#define I2C0_SCL_PD2 SILABS_DBUS_I2C0_SCL(0x3, 0x2)
#define I2C0_SCL_PD3 SILABS_DBUS_I2C0_SCL(0x3, 0x3)
#define I2C0_SCL_PD4 SILABS_DBUS_I2C0_SCL(0x3, 0x4)
#define I2C0_SCL_PD5 SILABS_DBUS_I2C0_SCL(0x3, 0x5)
#define I2C0_SDA_PA0 SILABS_DBUS_I2C0_SDA(0x0, 0x0)
#define I2C0_SDA_PA1 SILABS_DBUS_I2C0_SDA(0x0, 0x1)
#define I2C0_SDA_PA2 SILABS_DBUS_I2C0_SDA(0x0, 0x2)
#define I2C0_SDA_PA3 SILABS_DBUS_I2C0_SDA(0x0, 0x3)
#define I2C0_SDA_PA4 SILABS_DBUS_I2C0_SDA(0x0, 0x4)
#define I2C0_SDA_PA5 SILABS_DBUS_I2C0_SDA(0x0, 0x5)
#define I2C0_SDA_PA6 SILABS_DBUS_I2C0_SDA(0x0, 0x6)
#define I2C0_SDA_PA7 SILABS_DBUS_I2C0_SDA(0x0, 0x7)
#define I2C0_SDA_PA8 SILABS_DBUS_I2C0_SDA(0x0, 0x8)
#define I2C0_SDA_PA9 SILABS_DBUS_I2C0_SDA(0x0, 0x9)
#define I2C0_SDA_PB0 SILABS_DBUS_I2C0_SDA(0x1, 0x0)
#define I2C0_SDA_PB1 SILABS_DBUS_I2C0_SDA(0x1, 0x1)
#define I2C0_SDA_PB2 SILABS_DBUS_I2C0_SDA(0x1, 0x2)
#define I2C0_SDA_PB3 SILABS_DBUS_I2C0_SDA(0x1, 0x3)
#define I2C0_SDA_PB4 SILABS_DBUS_I2C0_SDA(0x1, 0x4)
#define I2C0_SDA_PB5 SILABS_DBUS_I2C0_SDA(0x1, 0x5)
#define I2C0_SDA_PC0 SILABS_DBUS_I2C0_SDA(0x2, 0x0)
#define I2C0_SDA_PC1 SILABS_DBUS_I2C0_SDA(0x2, 0x1)
#define I2C0_SDA_PC2 SILABS_DBUS_I2C0_SDA(0x2, 0x2)
#define I2C0_SDA_PC3 SILABS_DBUS_I2C0_SDA(0x2, 0x3)
#define I2C0_SDA_PC4 SILABS_DBUS_I2C0_SDA(0x2, 0x4)
#define I2C0_SDA_PC5 SILABS_DBUS_I2C0_SDA(0x2, 0x5)
#define I2C0_SDA_PC6 SILABS_DBUS_I2C0_SDA(0x2, 0x6)
#define I2C0_SDA_PC7 SILABS_DBUS_I2C0_SDA(0x2, 0x7)
#define I2C0_SDA_PC8 SILABS_DBUS_I2C0_SDA(0x2, 0x8)
#define I2C0_SDA_PC9 SILABS_DBUS_I2C0_SDA(0x2, 0x9)
#define I2C0_SDA_PD0 SILABS_DBUS_I2C0_SDA(0x3, 0x0)
#define I2C0_SDA_PD1 SILABS_DBUS_I2C0_SDA(0x3, 0x1)
#define I2C0_SDA_PD2 SILABS_DBUS_I2C0_SDA(0x3, 0x2)
#define I2C0_SDA_PD3 SILABS_DBUS_I2C0_SDA(0x3, 0x3)
#define I2C0_SDA_PD4 SILABS_DBUS_I2C0_SDA(0x3, 0x4)
#define I2C0_SDA_PD5 SILABS_DBUS_I2C0_SDA(0x3, 0x5)

#define I2C1_SCL_PC0 SILABS_DBUS_I2C1_SCL(0x2, 0x0)
#define I2C1_SCL_PC1 SILABS_DBUS_I2C1_SCL(0x2, 0x1)
#define I2C1_SCL_PC2 SILABS_DBUS_I2C1_SCL(0x2, 0x2)
#define I2C1_SCL_PC3 SILABS_DBUS_I2C1_SCL(0x2, 0x3)
#define I2C1_SCL_PC4 SILABS_DBUS_I2C1_SCL(0x2, 0x4)
#define I2C1_SCL_PC5 SILABS_DBUS_I2C1_SCL(0x2, 0x5)
#define I2C1_SCL_PC6 SILABS_DBUS_I2C1_SCL(0x2, 0x6)
#define I2C1_SCL_PC7 SILABS_DBUS_I2C1_SCL(0x2, 0x7)
#define I2C1_SCL_PC8 SILABS_DBUS_I2C1_SCL(0x2, 0x8)
#define I2C1_SCL_PC9 SILABS_DBUS_I2C1_SCL(0x2, 0x9)
#define I2C1_SCL_PD0 SILABS_DBUS_I2C1_SCL(0x3, 0x0)
#define I2C1_SCL_PD1 SILABS_DBUS_I2C1_SCL(0x3, 0x1)
#define I2C1_SCL_PD2 SILABS_DBUS_I2C1_SCL(0x3, 0x2)
#define I2C1_SCL_PD3 SILABS_DBUS_I2C1_SCL(0x3, 0x3)
#define I2C1_SCL_PD4 SILABS_DBUS_I2C1_SCL(0x3, 0x4)
#define I2C1_SCL_PD5 SILABS_DBUS_I2C1_SCL(0x3, 0x5)
#define I2C1_SDA_PC0 SILABS_DBUS_I2C1_SDA(0x2, 0x0)
#define I2C1_SDA_PC1 SILABS_DBUS_I2C1_SDA(0x2, 0x1)
#define I2C1_SDA_PC2 SILABS_DBUS_I2C1_SDA(0x2, 0x2)
#define I2C1_SDA_PC3 SILABS_DBUS_I2C1_SDA(0x2, 0x3)
#define I2C1_SDA_PC4 SILABS_DBUS_I2C1_SDA(0x2, 0x4)
#define I2C1_SDA_PC5 SILABS_DBUS_I2C1_SDA(0x2, 0x5)
#define I2C1_SDA_PC6 SILABS_DBUS_I2C1_SDA(0x2, 0x6)
#define I2C1_SDA_PC7 SILABS_DBUS_I2C1_SDA(0x2, 0x7)
#define I2C1_SDA_PC8 SILABS_DBUS_I2C1_SDA(0x2, 0x8)
#define I2C1_SDA_PC9 SILABS_DBUS_I2C1_SDA(0x2, 0x9)
#define I2C1_SDA_PD0 SILABS_DBUS_I2C1_SDA(0x3, 0x0)
#define I2C1_SDA_PD1 SILABS_DBUS_I2C1_SDA(0x3, 0x1)
#define I2C1_SDA_PD2 SILABS_DBUS_I2C1_SDA(0x3, 0x2)
#define I2C1_SDA_PD3 SILABS_DBUS_I2C1_SDA(0x3, 0x3)
#define I2C1_SDA_PD4 SILABS_DBUS_I2C1_SDA(0x3, 0x4)
#define I2C1_SDA_PD5 SILABS_DBUS_I2C1_SDA(0x3, 0x5)

#define KEYSCAN_COLOUT0_PA0   SILABS_DBUS_KEYSCAN_COLOUT0(0x0, 0x0)
#define KEYSCAN_COLOUT0_PA1   SILABS_DBUS_KEYSCAN_COLOUT0(0x0, 0x1)
#define KEYSCAN_COLOUT0_PA2   SILABS_DBUS_KEYSCAN_COLOUT0(0x0, 0x2)
#define KEYSCAN_COLOUT0_PA3   SILABS_DBUS_KEYSCAN_COLOUT0(0x0, 0x3)
#define KEYSCAN_COLOUT0_PA4   SILABS_DBUS_KEYSCAN_COLOUT0(0x0, 0x4)
#define KEYSCAN_COLOUT0_PA5   SILABS_DBUS_KEYSCAN_COLOUT0(0x0, 0x5)
#define KEYSCAN_COLOUT0_PA6   SILABS_DBUS_KEYSCAN_COLOUT0(0x0, 0x6)
#define KEYSCAN_COLOUT0_PA7   SILABS_DBUS_KEYSCAN_COLOUT0(0x0, 0x7)
#define KEYSCAN_COLOUT0_PA8   SILABS_DBUS_KEYSCAN_COLOUT0(0x0, 0x8)
#define KEYSCAN_COLOUT0_PA9   SILABS_DBUS_KEYSCAN_COLOUT0(0x0, 0x9)
#define KEYSCAN_COLOUT0_PB0   SILABS_DBUS_KEYSCAN_COLOUT0(0x1, 0x0)
#define KEYSCAN_COLOUT0_PB1   SILABS_DBUS_KEYSCAN_COLOUT0(0x1, 0x1)
#define KEYSCAN_COLOUT0_PB2   SILABS_DBUS_KEYSCAN_COLOUT0(0x1, 0x2)
#define KEYSCAN_COLOUT0_PB3   SILABS_DBUS_KEYSCAN_COLOUT0(0x1, 0x3)
#define KEYSCAN_COLOUT0_PB4   SILABS_DBUS_KEYSCAN_COLOUT0(0x1, 0x4)
#define KEYSCAN_COLOUT0_PB5   SILABS_DBUS_KEYSCAN_COLOUT0(0x1, 0x5)
#define KEYSCAN_COLOUT0_PC0   SILABS_DBUS_KEYSCAN_COLOUT0(0x2, 0x0)
#define KEYSCAN_COLOUT0_PC1   SILABS_DBUS_KEYSCAN_COLOUT0(0x2, 0x1)
#define KEYSCAN_COLOUT0_PC2   SILABS_DBUS_KEYSCAN_COLOUT0(0x2, 0x2)
#define KEYSCAN_COLOUT0_PC3   SILABS_DBUS_KEYSCAN_COLOUT0(0x2, 0x3)
#define KEYSCAN_COLOUT0_PC4   SILABS_DBUS_KEYSCAN_COLOUT0(0x2, 0x4)
#define KEYSCAN_COLOUT0_PC5   SILABS_DBUS_KEYSCAN_COLOUT0(0x2, 0x5)
#define KEYSCAN_COLOUT0_PC6   SILABS_DBUS_KEYSCAN_COLOUT0(0x2, 0x6)
#define KEYSCAN_COLOUT0_PC7   SILABS_DBUS_KEYSCAN_COLOUT0(0x2, 0x7)
#define KEYSCAN_COLOUT0_PC8   SILABS_DBUS_KEYSCAN_COLOUT0(0x2, 0x8)
#define KEYSCAN_COLOUT0_PC9   SILABS_DBUS_KEYSCAN_COLOUT0(0x2, 0x9)
#define KEYSCAN_COLOUT0_PD0   SILABS_DBUS_KEYSCAN_COLOUT0(0x3, 0x0)
#define KEYSCAN_COLOUT0_PD1   SILABS_DBUS_KEYSCAN_COLOUT0(0x3, 0x1)
#define KEYSCAN_COLOUT0_PD2   SILABS_DBUS_KEYSCAN_COLOUT0(0x3, 0x2)
#define KEYSCAN_COLOUT0_PD3   SILABS_DBUS_KEYSCAN_COLOUT0(0x3, 0x3)
#define KEYSCAN_COLOUT0_PD4   SILABS_DBUS_KEYSCAN_COLOUT0(0x3, 0x4)
#define KEYSCAN_COLOUT0_PD5   SILABS_DBUS_KEYSCAN_COLOUT0(0x3, 0x5)
#define KEYSCAN_COLOUT1_PA0   SILABS_DBUS_KEYSCAN_COLOUT1(0x0, 0x0)
#define KEYSCAN_COLOUT1_PA1   SILABS_DBUS_KEYSCAN_COLOUT1(0x0, 0x1)
#define KEYSCAN_COLOUT1_PA2   SILABS_DBUS_KEYSCAN_COLOUT1(0x0, 0x2)
#define KEYSCAN_COLOUT1_PA3   SILABS_DBUS_KEYSCAN_COLOUT1(0x0, 0x3)
#define KEYSCAN_COLOUT1_PA4   SILABS_DBUS_KEYSCAN_COLOUT1(0x0, 0x4)
#define KEYSCAN_COLOUT1_PA5   SILABS_DBUS_KEYSCAN_COLOUT1(0x0, 0x5)
#define KEYSCAN_COLOUT1_PA6   SILABS_DBUS_KEYSCAN_COLOUT1(0x0, 0x6)
#define KEYSCAN_COLOUT1_PA7   SILABS_DBUS_KEYSCAN_COLOUT1(0x0, 0x7)
#define KEYSCAN_COLOUT1_PA8   SILABS_DBUS_KEYSCAN_COLOUT1(0x0, 0x8)
#define KEYSCAN_COLOUT1_PA9   SILABS_DBUS_KEYSCAN_COLOUT1(0x0, 0x9)
#define KEYSCAN_COLOUT1_PB0   SILABS_DBUS_KEYSCAN_COLOUT1(0x1, 0x0)
#define KEYSCAN_COLOUT1_PB1   SILABS_DBUS_KEYSCAN_COLOUT1(0x1, 0x1)
#define KEYSCAN_COLOUT1_PB2   SILABS_DBUS_KEYSCAN_COLOUT1(0x1, 0x2)
#define KEYSCAN_COLOUT1_PB3   SILABS_DBUS_KEYSCAN_COLOUT1(0x1, 0x3)
#define KEYSCAN_COLOUT1_PB4   SILABS_DBUS_KEYSCAN_COLOUT1(0x1, 0x4)
#define KEYSCAN_COLOUT1_PB5   SILABS_DBUS_KEYSCAN_COLOUT1(0x1, 0x5)
#define KEYSCAN_COLOUT1_PC0   SILABS_DBUS_KEYSCAN_COLOUT1(0x2, 0x0)
#define KEYSCAN_COLOUT1_PC1   SILABS_DBUS_KEYSCAN_COLOUT1(0x2, 0x1)
#define KEYSCAN_COLOUT1_PC2   SILABS_DBUS_KEYSCAN_COLOUT1(0x2, 0x2)
#define KEYSCAN_COLOUT1_PC3   SILABS_DBUS_KEYSCAN_COLOUT1(0x2, 0x3)
#define KEYSCAN_COLOUT1_PC4   SILABS_DBUS_KEYSCAN_COLOUT1(0x2, 0x4)
#define KEYSCAN_COLOUT1_PC5   SILABS_DBUS_KEYSCAN_COLOUT1(0x2, 0x5)
#define KEYSCAN_COLOUT1_PC6   SILABS_DBUS_KEYSCAN_COLOUT1(0x2, 0x6)
#define KEYSCAN_COLOUT1_PC7   SILABS_DBUS_KEYSCAN_COLOUT1(0x2, 0x7)
#define KEYSCAN_COLOUT1_PC8   SILABS_DBUS_KEYSCAN_COLOUT1(0x2, 0x8)
#define KEYSCAN_COLOUT1_PC9   SILABS_DBUS_KEYSCAN_COLOUT1(0x2, 0x9)
#define KEYSCAN_COLOUT1_PD0   SILABS_DBUS_KEYSCAN_COLOUT1(0x3, 0x0)
#define KEYSCAN_COLOUT1_PD1   SILABS_DBUS_KEYSCAN_COLOUT1(0x3, 0x1)
#define KEYSCAN_COLOUT1_PD2   SILABS_DBUS_KEYSCAN_COLOUT1(0x3, 0x2)
#define KEYSCAN_COLOUT1_PD3   SILABS_DBUS_KEYSCAN_COLOUT1(0x3, 0x3)
#define KEYSCAN_COLOUT1_PD4   SILABS_DBUS_KEYSCAN_COLOUT1(0x3, 0x4)
#define KEYSCAN_COLOUT1_PD5   SILABS_DBUS_KEYSCAN_COLOUT1(0x3, 0x5)
#define KEYSCAN_COLOUT2_PA0   SILABS_DBUS_KEYSCAN_COLOUT2(0x0, 0x0)
#define KEYSCAN_COLOUT2_PA1   SILABS_DBUS_KEYSCAN_COLOUT2(0x0, 0x1)
#define KEYSCAN_COLOUT2_PA2   SILABS_DBUS_KEYSCAN_COLOUT2(0x0, 0x2)
#define KEYSCAN_COLOUT2_PA3   SILABS_DBUS_KEYSCAN_COLOUT2(0x0, 0x3)
#define KEYSCAN_COLOUT2_PA4   SILABS_DBUS_KEYSCAN_COLOUT2(0x0, 0x4)
#define KEYSCAN_COLOUT2_PA5   SILABS_DBUS_KEYSCAN_COLOUT2(0x0, 0x5)
#define KEYSCAN_COLOUT2_PA6   SILABS_DBUS_KEYSCAN_COLOUT2(0x0, 0x6)
#define KEYSCAN_COLOUT2_PA7   SILABS_DBUS_KEYSCAN_COLOUT2(0x0, 0x7)
#define KEYSCAN_COLOUT2_PA8   SILABS_DBUS_KEYSCAN_COLOUT2(0x0, 0x8)
#define KEYSCAN_COLOUT2_PA9   SILABS_DBUS_KEYSCAN_COLOUT2(0x0, 0x9)
#define KEYSCAN_COLOUT2_PB0   SILABS_DBUS_KEYSCAN_COLOUT2(0x1, 0x0)
#define KEYSCAN_COLOUT2_PB1   SILABS_DBUS_KEYSCAN_COLOUT2(0x1, 0x1)
#define KEYSCAN_COLOUT2_PB2   SILABS_DBUS_KEYSCAN_COLOUT2(0x1, 0x2)
#define KEYSCAN_COLOUT2_PB3   SILABS_DBUS_KEYSCAN_COLOUT2(0x1, 0x3)
#define KEYSCAN_COLOUT2_PB4   SILABS_DBUS_KEYSCAN_COLOUT2(0x1, 0x4)
#define KEYSCAN_COLOUT2_PB5   SILABS_DBUS_KEYSCAN_COLOUT2(0x1, 0x5)
#define KEYSCAN_COLOUT2_PC0   SILABS_DBUS_KEYSCAN_COLOUT2(0x2, 0x0)
#define KEYSCAN_COLOUT2_PC1   SILABS_DBUS_KEYSCAN_COLOUT2(0x2, 0x1)
#define KEYSCAN_COLOUT2_PC2   SILABS_DBUS_KEYSCAN_COLOUT2(0x2, 0x2)
#define KEYSCAN_COLOUT2_PC3   SILABS_DBUS_KEYSCAN_COLOUT2(0x2, 0x3)
#define KEYSCAN_COLOUT2_PC4   SILABS_DBUS_KEYSCAN_COLOUT2(0x2, 0x4)
#define KEYSCAN_COLOUT2_PC5   SILABS_DBUS_KEYSCAN_COLOUT2(0x2, 0x5)
#define KEYSCAN_COLOUT2_PC6   SILABS_DBUS_KEYSCAN_COLOUT2(0x2, 0x6)
#define KEYSCAN_COLOUT2_PC7   SILABS_DBUS_KEYSCAN_COLOUT2(0x2, 0x7)
#define KEYSCAN_COLOUT2_PC8   SILABS_DBUS_KEYSCAN_COLOUT2(0x2, 0x8)
#define KEYSCAN_COLOUT2_PC9   SILABS_DBUS_KEYSCAN_COLOUT2(0x2, 0x9)
#define KEYSCAN_COLOUT2_PD0   SILABS_DBUS_KEYSCAN_COLOUT2(0x3, 0x0)
#define KEYSCAN_COLOUT2_PD1   SILABS_DBUS_KEYSCAN_COLOUT2(0x3, 0x1)
#define KEYSCAN_COLOUT2_PD2   SILABS_DBUS_KEYSCAN_COLOUT2(0x3, 0x2)
#define KEYSCAN_COLOUT2_PD3   SILABS_DBUS_KEYSCAN_COLOUT2(0x3, 0x3)
#define KEYSCAN_COLOUT2_PD4   SILABS_DBUS_KEYSCAN_COLOUT2(0x3, 0x4)
#define KEYSCAN_COLOUT2_PD5   SILABS_DBUS_KEYSCAN_COLOUT2(0x3, 0x5)
#define KEYSCAN_COLOUT3_PA0   SILABS_DBUS_KEYSCAN_COLOUT3(0x0, 0x0)
#define KEYSCAN_COLOUT3_PA1   SILABS_DBUS_KEYSCAN_COLOUT3(0x0, 0x1)
#define KEYSCAN_COLOUT3_PA2   SILABS_DBUS_KEYSCAN_COLOUT3(0x0, 0x2)
#define KEYSCAN_COLOUT3_PA3   SILABS_DBUS_KEYSCAN_COLOUT3(0x0, 0x3)
#define KEYSCAN_COLOUT3_PA4   SILABS_DBUS_KEYSCAN_COLOUT3(0x0, 0x4)
#define KEYSCAN_COLOUT3_PA5   SILABS_DBUS_KEYSCAN_COLOUT3(0x0, 0x5)
#define KEYSCAN_COLOUT3_PA6   SILABS_DBUS_KEYSCAN_COLOUT3(0x0, 0x6)
#define KEYSCAN_COLOUT3_PA7   SILABS_DBUS_KEYSCAN_COLOUT3(0x0, 0x7)
#define KEYSCAN_COLOUT3_PA8   SILABS_DBUS_KEYSCAN_COLOUT3(0x0, 0x8)
#define KEYSCAN_COLOUT3_PA9   SILABS_DBUS_KEYSCAN_COLOUT3(0x0, 0x9)
#define KEYSCAN_COLOUT3_PB0   SILABS_DBUS_KEYSCAN_COLOUT3(0x1, 0x0)
#define KEYSCAN_COLOUT3_PB1   SILABS_DBUS_KEYSCAN_COLOUT3(0x1, 0x1)
#define KEYSCAN_COLOUT3_PB2   SILABS_DBUS_KEYSCAN_COLOUT3(0x1, 0x2)
#define KEYSCAN_COLOUT3_PB3   SILABS_DBUS_KEYSCAN_COLOUT3(0x1, 0x3)
#define KEYSCAN_COLOUT3_PB4   SILABS_DBUS_KEYSCAN_COLOUT3(0x1, 0x4)
#define KEYSCAN_COLOUT3_PB5   SILABS_DBUS_KEYSCAN_COLOUT3(0x1, 0x5)
#define KEYSCAN_COLOUT3_PC0   SILABS_DBUS_KEYSCAN_COLOUT3(0x2, 0x0)
#define KEYSCAN_COLOUT3_PC1   SILABS_DBUS_KEYSCAN_COLOUT3(0x2, 0x1)
#define KEYSCAN_COLOUT3_PC2   SILABS_DBUS_KEYSCAN_COLOUT3(0x2, 0x2)
#define KEYSCAN_COLOUT3_PC3   SILABS_DBUS_KEYSCAN_COLOUT3(0x2, 0x3)
#define KEYSCAN_COLOUT3_PC4   SILABS_DBUS_KEYSCAN_COLOUT3(0x2, 0x4)
#define KEYSCAN_COLOUT3_PC5   SILABS_DBUS_KEYSCAN_COLOUT3(0x2, 0x5)
#define KEYSCAN_COLOUT3_PC6   SILABS_DBUS_KEYSCAN_COLOUT3(0x2, 0x6)
#define KEYSCAN_COLOUT3_PC7   SILABS_DBUS_KEYSCAN_COLOUT3(0x2, 0x7)
#define KEYSCAN_COLOUT3_PC8   SILABS_DBUS_KEYSCAN_COLOUT3(0x2, 0x8)
#define KEYSCAN_COLOUT3_PC9   SILABS_DBUS_KEYSCAN_COLOUT3(0x2, 0x9)
#define KEYSCAN_COLOUT3_PD0   SILABS_DBUS_KEYSCAN_COLOUT3(0x3, 0x0)
#define KEYSCAN_COLOUT3_PD1   SILABS_DBUS_KEYSCAN_COLOUT3(0x3, 0x1)
#define KEYSCAN_COLOUT3_PD2   SILABS_DBUS_KEYSCAN_COLOUT3(0x3, 0x2)
#define KEYSCAN_COLOUT3_PD3   SILABS_DBUS_KEYSCAN_COLOUT3(0x3, 0x3)
#define KEYSCAN_COLOUT3_PD4   SILABS_DBUS_KEYSCAN_COLOUT3(0x3, 0x4)
#define KEYSCAN_COLOUT3_PD5   SILABS_DBUS_KEYSCAN_COLOUT3(0x3, 0x5)
#define KEYSCAN_COLOUT4_PA0   SILABS_DBUS_KEYSCAN_COLOUT4(0x0, 0x0)
#define KEYSCAN_COLOUT4_PA1   SILABS_DBUS_KEYSCAN_COLOUT4(0x0, 0x1)
#define KEYSCAN_COLOUT4_PA2   SILABS_DBUS_KEYSCAN_COLOUT4(0x0, 0x2)
#define KEYSCAN_COLOUT4_PA3   SILABS_DBUS_KEYSCAN_COLOUT4(0x0, 0x3)
#define KEYSCAN_COLOUT4_PA4   SILABS_DBUS_KEYSCAN_COLOUT4(0x0, 0x4)
#define KEYSCAN_COLOUT4_PA5   SILABS_DBUS_KEYSCAN_COLOUT4(0x0, 0x5)
#define KEYSCAN_COLOUT4_PA6   SILABS_DBUS_KEYSCAN_COLOUT4(0x0, 0x6)
#define KEYSCAN_COLOUT4_PA7   SILABS_DBUS_KEYSCAN_COLOUT4(0x0, 0x7)
#define KEYSCAN_COLOUT4_PA8   SILABS_DBUS_KEYSCAN_COLOUT4(0x0, 0x8)
#define KEYSCAN_COLOUT4_PA9   SILABS_DBUS_KEYSCAN_COLOUT4(0x0, 0x9)
#define KEYSCAN_COLOUT4_PB0   SILABS_DBUS_KEYSCAN_COLOUT4(0x1, 0x0)
#define KEYSCAN_COLOUT4_PB1   SILABS_DBUS_KEYSCAN_COLOUT4(0x1, 0x1)
#define KEYSCAN_COLOUT4_PB2   SILABS_DBUS_KEYSCAN_COLOUT4(0x1, 0x2)
#define KEYSCAN_COLOUT4_PB3   SILABS_DBUS_KEYSCAN_COLOUT4(0x1, 0x3)
#define KEYSCAN_COLOUT4_PB4   SILABS_DBUS_KEYSCAN_COLOUT4(0x1, 0x4)
#define KEYSCAN_COLOUT4_PB5   SILABS_DBUS_KEYSCAN_COLOUT4(0x1, 0x5)
#define KEYSCAN_COLOUT4_PC0   SILABS_DBUS_KEYSCAN_COLOUT4(0x2, 0x0)
#define KEYSCAN_COLOUT4_PC1   SILABS_DBUS_KEYSCAN_COLOUT4(0x2, 0x1)
#define KEYSCAN_COLOUT4_PC2   SILABS_DBUS_KEYSCAN_COLOUT4(0x2, 0x2)
#define KEYSCAN_COLOUT4_PC3   SILABS_DBUS_KEYSCAN_COLOUT4(0x2, 0x3)
#define KEYSCAN_COLOUT4_PC4   SILABS_DBUS_KEYSCAN_COLOUT4(0x2, 0x4)
#define KEYSCAN_COLOUT4_PC5   SILABS_DBUS_KEYSCAN_COLOUT4(0x2, 0x5)
#define KEYSCAN_COLOUT4_PC6   SILABS_DBUS_KEYSCAN_COLOUT4(0x2, 0x6)
#define KEYSCAN_COLOUT4_PC7   SILABS_DBUS_KEYSCAN_COLOUT4(0x2, 0x7)
#define KEYSCAN_COLOUT4_PC8   SILABS_DBUS_KEYSCAN_COLOUT4(0x2, 0x8)
#define KEYSCAN_COLOUT4_PC9   SILABS_DBUS_KEYSCAN_COLOUT4(0x2, 0x9)
#define KEYSCAN_COLOUT4_PD0   SILABS_DBUS_KEYSCAN_COLOUT4(0x3, 0x0)
#define KEYSCAN_COLOUT4_PD1   SILABS_DBUS_KEYSCAN_COLOUT4(0x3, 0x1)
#define KEYSCAN_COLOUT4_PD2   SILABS_DBUS_KEYSCAN_COLOUT4(0x3, 0x2)
#define KEYSCAN_COLOUT4_PD3   SILABS_DBUS_KEYSCAN_COLOUT4(0x3, 0x3)
#define KEYSCAN_COLOUT4_PD4   SILABS_DBUS_KEYSCAN_COLOUT4(0x3, 0x4)
#define KEYSCAN_COLOUT4_PD5   SILABS_DBUS_KEYSCAN_COLOUT4(0x3, 0x5)
#define KEYSCAN_COLOUT5_PA0   SILABS_DBUS_KEYSCAN_COLOUT5(0x0, 0x0)
#define KEYSCAN_COLOUT5_PA1   SILABS_DBUS_KEYSCAN_COLOUT5(0x0, 0x1)
#define KEYSCAN_COLOUT5_PA2   SILABS_DBUS_KEYSCAN_COLOUT5(0x0, 0x2)
#define KEYSCAN_COLOUT5_PA3   SILABS_DBUS_KEYSCAN_COLOUT5(0x0, 0x3)
#define KEYSCAN_COLOUT5_PA4   SILABS_DBUS_KEYSCAN_COLOUT5(0x0, 0x4)
#define KEYSCAN_COLOUT5_PA5   SILABS_DBUS_KEYSCAN_COLOUT5(0x0, 0x5)
#define KEYSCAN_COLOUT5_PA6   SILABS_DBUS_KEYSCAN_COLOUT5(0x0, 0x6)
#define KEYSCAN_COLOUT5_PA7   SILABS_DBUS_KEYSCAN_COLOUT5(0x0, 0x7)
#define KEYSCAN_COLOUT5_PA8   SILABS_DBUS_KEYSCAN_COLOUT5(0x0, 0x8)
#define KEYSCAN_COLOUT5_PA9   SILABS_DBUS_KEYSCAN_COLOUT5(0x0, 0x9)
#define KEYSCAN_COLOUT5_PB0   SILABS_DBUS_KEYSCAN_COLOUT5(0x1, 0x0)
#define KEYSCAN_COLOUT5_PB1   SILABS_DBUS_KEYSCAN_COLOUT5(0x1, 0x1)
#define KEYSCAN_COLOUT5_PB2   SILABS_DBUS_KEYSCAN_COLOUT5(0x1, 0x2)
#define KEYSCAN_COLOUT5_PB3   SILABS_DBUS_KEYSCAN_COLOUT5(0x1, 0x3)
#define KEYSCAN_COLOUT5_PB4   SILABS_DBUS_KEYSCAN_COLOUT5(0x1, 0x4)
#define KEYSCAN_COLOUT5_PB5   SILABS_DBUS_KEYSCAN_COLOUT5(0x1, 0x5)
#define KEYSCAN_COLOUT5_PC0   SILABS_DBUS_KEYSCAN_COLOUT5(0x2, 0x0)
#define KEYSCAN_COLOUT5_PC1   SILABS_DBUS_KEYSCAN_COLOUT5(0x2, 0x1)
#define KEYSCAN_COLOUT5_PC2   SILABS_DBUS_KEYSCAN_COLOUT5(0x2, 0x2)
#define KEYSCAN_COLOUT5_PC3   SILABS_DBUS_KEYSCAN_COLOUT5(0x2, 0x3)
#define KEYSCAN_COLOUT5_PC4   SILABS_DBUS_KEYSCAN_COLOUT5(0x2, 0x4)
#define KEYSCAN_COLOUT5_PC5   SILABS_DBUS_KEYSCAN_COLOUT5(0x2, 0x5)
#define KEYSCAN_COLOUT5_PC6   SILABS_DBUS_KEYSCAN_COLOUT5(0x2, 0x6)
#define KEYSCAN_COLOUT5_PC7   SILABS_DBUS_KEYSCAN_COLOUT5(0x2, 0x7)
#define KEYSCAN_COLOUT5_PC8   SILABS_DBUS_KEYSCAN_COLOUT5(0x2, 0x8)
#define KEYSCAN_COLOUT5_PC9   SILABS_DBUS_KEYSCAN_COLOUT5(0x2, 0x9)
#define KEYSCAN_COLOUT5_PD0   SILABS_DBUS_KEYSCAN_COLOUT5(0x3, 0x0)
#define KEYSCAN_COLOUT5_PD1   SILABS_DBUS_KEYSCAN_COLOUT5(0x3, 0x1)
#define KEYSCAN_COLOUT5_PD2   SILABS_DBUS_KEYSCAN_COLOUT5(0x3, 0x2)
#define KEYSCAN_COLOUT5_PD3   SILABS_DBUS_KEYSCAN_COLOUT5(0x3, 0x3)
#define KEYSCAN_COLOUT5_PD4   SILABS_DBUS_KEYSCAN_COLOUT5(0x3, 0x4)
#define KEYSCAN_COLOUT5_PD5   SILABS_DBUS_KEYSCAN_COLOUT5(0x3, 0x5)
#define KEYSCAN_COLOUT6_PA0   SILABS_DBUS_KEYSCAN_COLOUT6(0x0, 0x0)
#define KEYSCAN_COLOUT6_PA1   SILABS_DBUS_KEYSCAN_COLOUT6(0x0, 0x1)
#define KEYSCAN_COLOUT6_PA2   SILABS_DBUS_KEYSCAN_COLOUT6(0x0, 0x2)
#define KEYSCAN_COLOUT6_PA3   SILABS_DBUS_KEYSCAN_COLOUT6(0x0, 0x3)
#define KEYSCAN_COLOUT6_PA4   SILABS_DBUS_KEYSCAN_COLOUT6(0x0, 0x4)
#define KEYSCAN_COLOUT6_PA5   SILABS_DBUS_KEYSCAN_COLOUT6(0x0, 0x5)
#define KEYSCAN_COLOUT6_PA6   SILABS_DBUS_KEYSCAN_COLOUT6(0x0, 0x6)
#define KEYSCAN_COLOUT6_PA7   SILABS_DBUS_KEYSCAN_COLOUT6(0x0, 0x7)
#define KEYSCAN_COLOUT6_PA8   SILABS_DBUS_KEYSCAN_COLOUT6(0x0, 0x8)
#define KEYSCAN_COLOUT6_PA9   SILABS_DBUS_KEYSCAN_COLOUT6(0x0, 0x9)
#define KEYSCAN_COLOUT6_PB0   SILABS_DBUS_KEYSCAN_COLOUT6(0x1, 0x0)
#define KEYSCAN_COLOUT6_PB1   SILABS_DBUS_KEYSCAN_COLOUT6(0x1, 0x1)
#define KEYSCAN_COLOUT6_PB2   SILABS_DBUS_KEYSCAN_COLOUT6(0x1, 0x2)
#define KEYSCAN_COLOUT6_PB3   SILABS_DBUS_KEYSCAN_COLOUT6(0x1, 0x3)
#define KEYSCAN_COLOUT6_PB4   SILABS_DBUS_KEYSCAN_COLOUT6(0x1, 0x4)
#define KEYSCAN_COLOUT6_PB5   SILABS_DBUS_KEYSCAN_COLOUT6(0x1, 0x5)
#define KEYSCAN_COLOUT6_PC0   SILABS_DBUS_KEYSCAN_COLOUT6(0x2, 0x0)
#define KEYSCAN_COLOUT6_PC1   SILABS_DBUS_KEYSCAN_COLOUT6(0x2, 0x1)
#define KEYSCAN_COLOUT6_PC2   SILABS_DBUS_KEYSCAN_COLOUT6(0x2, 0x2)
#define KEYSCAN_COLOUT6_PC3   SILABS_DBUS_KEYSCAN_COLOUT6(0x2, 0x3)
#define KEYSCAN_COLOUT6_PC4   SILABS_DBUS_KEYSCAN_COLOUT6(0x2, 0x4)
#define KEYSCAN_COLOUT6_PC5   SILABS_DBUS_KEYSCAN_COLOUT6(0x2, 0x5)
#define KEYSCAN_COLOUT6_PC6   SILABS_DBUS_KEYSCAN_COLOUT6(0x2, 0x6)
#define KEYSCAN_COLOUT6_PC7   SILABS_DBUS_KEYSCAN_COLOUT6(0x2, 0x7)
#define KEYSCAN_COLOUT6_PC8   SILABS_DBUS_KEYSCAN_COLOUT6(0x2, 0x8)
#define KEYSCAN_COLOUT6_PC9   SILABS_DBUS_KEYSCAN_COLOUT6(0x2, 0x9)
#define KEYSCAN_COLOUT6_PD0   SILABS_DBUS_KEYSCAN_COLOUT6(0x3, 0x0)
#define KEYSCAN_COLOUT6_PD1   SILABS_DBUS_KEYSCAN_COLOUT6(0x3, 0x1)
#define KEYSCAN_COLOUT6_PD2   SILABS_DBUS_KEYSCAN_COLOUT6(0x3, 0x2)
#define KEYSCAN_COLOUT6_PD3   SILABS_DBUS_KEYSCAN_COLOUT6(0x3, 0x3)
#define KEYSCAN_COLOUT6_PD4   SILABS_DBUS_KEYSCAN_COLOUT6(0x3, 0x4)
#define KEYSCAN_COLOUT6_PD5   SILABS_DBUS_KEYSCAN_COLOUT6(0x3, 0x5)
#define KEYSCAN_COLOUT7_PA0   SILABS_DBUS_KEYSCAN_COLOUT7(0x0, 0x0)
#define KEYSCAN_COLOUT7_PA1   SILABS_DBUS_KEYSCAN_COLOUT7(0x0, 0x1)
#define KEYSCAN_COLOUT7_PA2   SILABS_DBUS_KEYSCAN_COLOUT7(0x0, 0x2)
#define KEYSCAN_COLOUT7_PA3   SILABS_DBUS_KEYSCAN_COLOUT7(0x0, 0x3)
#define KEYSCAN_COLOUT7_PA4   SILABS_DBUS_KEYSCAN_COLOUT7(0x0, 0x4)
#define KEYSCAN_COLOUT7_PA5   SILABS_DBUS_KEYSCAN_COLOUT7(0x0, 0x5)
#define KEYSCAN_COLOUT7_PA6   SILABS_DBUS_KEYSCAN_COLOUT7(0x0, 0x6)
#define KEYSCAN_COLOUT7_PA7   SILABS_DBUS_KEYSCAN_COLOUT7(0x0, 0x7)
#define KEYSCAN_COLOUT7_PA8   SILABS_DBUS_KEYSCAN_COLOUT7(0x0, 0x8)
#define KEYSCAN_COLOUT7_PA9   SILABS_DBUS_KEYSCAN_COLOUT7(0x0, 0x9)
#define KEYSCAN_COLOUT7_PB0   SILABS_DBUS_KEYSCAN_COLOUT7(0x1, 0x0)
#define KEYSCAN_COLOUT7_PB1   SILABS_DBUS_KEYSCAN_COLOUT7(0x1, 0x1)
#define KEYSCAN_COLOUT7_PB2   SILABS_DBUS_KEYSCAN_COLOUT7(0x1, 0x2)
#define KEYSCAN_COLOUT7_PB3   SILABS_DBUS_KEYSCAN_COLOUT7(0x1, 0x3)
#define KEYSCAN_COLOUT7_PB4   SILABS_DBUS_KEYSCAN_COLOUT7(0x1, 0x4)
#define KEYSCAN_COLOUT7_PB5   SILABS_DBUS_KEYSCAN_COLOUT7(0x1, 0x5)
#define KEYSCAN_COLOUT7_PC0   SILABS_DBUS_KEYSCAN_COLOUT7(0x2, 0x0)
#define KEYSCAN_COLOUT7_PC1   SILABS_DBUS_KEYSCAN_COLOUT7(0x2, 0x1)
#define KEYSCAN_COLOUT7_PC2   SILABS_DBUS_KEYSCAN_COLOUT7(0x2, 0x2)
#define KEYSCAN_COLOUT7_PC3   SILABS_DBUS_KEYSCAN_COLOUT7(0x2, 0x3)
#define KEYSCAN_COLOUT7_PC4   SILABS_DBUS_KEYSCAN_COLOUT7(0x2, 0x4)
#define KEYSCAN_COLOUT7_PC5   SILABS_DBUS_KEYSCAN_COLOUT7(0x2, 0x5)
#define KEYSCAN_COLOUT7_PC6   SILABS_DBUS_KEYSCAN_COLOUT7(0x2, 0x6)
#define KEYSCAN_COLOUT7_PC7   SILABS_DBUS_KEYSCAN_COLOUT7(0x2, 0x7)
#define KEYSCAN_COLOUT7_PC8   SILABS_DBUS_KEYSCAN_COLOUT7(0x2, 0x8)
#define KEYSCAN_COLOUT7_PC9   SILABS_DBUS_KEYSCAN_COLOUT7(0x2, 0x9)
#define KEYSCAN_COLOUT7_PD0   SILABS_DBUS_KEYSCAN_COLOUT7(0x3, 0x0)
#define KEYSCAN_COLOUT7_PD1   SILABS_DBUS_KEYSCAN_COLOUT7(0x3, 0x1)
#define KEYSCAN_COLOUT7_PD2   SILABS_DBUS_KEYSCAN_COLOUT7(0x3, 0x2)
#define KEYSCAN_COLOUT7_PD3   SILABS_DBUS_KEYSCAN_COLOUT7(0x3, 0x3)
#define KEYSCAN_COLOUT7_PD4   SILABS_DBUS_KEYSCAN_COLOUT7(0x3, 0x4)
#define KEYSCAN_COLOUT7_PD5   SILABS_DBUS_KEYSCAN_COLOUT7(0x3, 0x5)
#define KEYSCAN_ROWSENSE0_PA0 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x0, 0x0)
#define KEYSCAN_ROWSENSE0_PA1 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x0, 0x1)
#define KEYSCAN_ROWSENSE0_PA2 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x0, 0x2)
#define KEYSCAN_ROWSENSE0_PA3 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x0, 0x3)
#define KEYSCAN_ROWSENSE0_PA4 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x0, 0x4)
#define KEYSCAN_ROWSENSE0_PA5 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x0, 0x5)
#define KEYSCAN_ROWSENSE0_PA6 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x0, 0x6)
#define KEYSCAN_ROWSENSE0_PA7 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x0, 0x7)
#define KEYSCAN_ROWSENSE0_PA8 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x0, 0x8)
#define KEYSCAN_ROWSENSE0_PA9 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x0, 0x9)
#define KEYSCAN_ROWSENSE0_PB0 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x1, 0x0)
#define KEYSCAN_ROWSENSE0_PB1 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x1, 0x1)
#define KEYSCAN_ROWSENSE0_PB2 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x1, 0x2)
#define KEYSCAN_ROWSENSE0_PB3 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x1, 0x3)
#define KEYSCAN_ROWSENSE0_PB4 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x1, 0x4)
#define KEYSCAN_ROWSENSE0_PB5 SILABS_DBUS_KEYSCAN_ROWSENSE0(0x1, 0x5)
#define KEYSCAN_ROWSENSE1_PA0 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x0, 0x0)
#define KEYSCAN_ROWSENSE1_PA1 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x0, 0x1)
#define KEYSCAN_ROWSENSE1_PA2 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x0, 0x2)
#define KEYSCAN_ROWSENSE1_PA3 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x0, 0x3)
#define KEYSCAN_ROWSENSE1_PA4 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x0, 0x4)
#define KEYSCAN_ROWSENSE1_PA5 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x0, 0x5)
#define KEYSCAN_ROWSENSE1_PA6 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x0, 0x6)
#define KEYSCAN_ROWSENSE1_PA7 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x0, 0x7)
#define KEYSCAN_ROWSENSE1_PA8 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x0, 0x8)
#define KEYSCAN_ROWSENSE1_PA9 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x0, 0x9)
#define KEYSCAN_ROWSENSE1_PB0 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x1, 0x0)
#define KEYSCAN_ROWSENSE1_PB1 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x1, 0x1)
#define KEYSCAN_ROWSENSE1_PB2 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x1, 0x2)
#define KEYSCAN_ROWSENSE1_PB3 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x1, 0x3)
#define KEYSCAN_ROWSENSE1_PB4 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x1, 0x4)
#define KEYSCAN_ROWSENSE1_PB5 SILABS_DBUS_KEYSCAN_ROWSENSE1(0x1, 0x5)
#define KEYSCAN_ROWSENSE2_PA0 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x0, 0x0)
#define KEYSCAN_ROWSENSE2_PA1 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x0, 0x1)
#define KEYSCAN_ROWSENSE2_PA2 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x0, 0x2)
#define KEYSCAN_ROWSENSE2_PA3 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x0, 0x3)
#define KEYSCAN_ROWSENSE2_PA4 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x0, 0x4)
#define KEYSCAN_ROWSENSE2_PA5 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x0, 0x5)
#define KEYSCAN_ROWSENSE2_PA6 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x0, 0x6)
#define KEYSCAN_ROWSENSE2_PA7 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x0, 0x7)
#define KEYSCAN_ROWSENSE2_PA8 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x0, 0x8)
#define KEYSCAN_ROWSENSE2_PA9 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x0, 0x9)
#define KEYSCAN_ROWSENSE2_PB0 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x1, 0x0)
#define KEYSCAN_ROWSENSE2_PB1 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x1, 0x1)
#define KEYSCAN_ROWSENSE2_PB2 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x1, 0x2)
#define KEYSCAN_ROWSENSE2_PB3 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x1, 0x3)
#define KEYSCAN_ROWSENSE2_PB4 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x1, 0x4)
#define KEYSCAN_ROWSENSE2_PB5 SILABS_DBUS_KEYSCAN_ROWSENSE2(0x1, 0x5)
#define KEYSCAN_ROWSENSE3_PA0 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x0, 0x0)
#define KEYSCAN_ROWSENSE3_PA1 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x0, 0x1)
#define KEYSCAN_ROWSENSE3_PA2 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x0, 0x2)
#define KEYSCAN_ROWSENSE3_PA3 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x0, 0x3)
#define KEYSCAN_ROWSENSE3_PA4 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x0, 0x4)
#define KEYSCAN_ROWSENSE3_PA5 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x0, 0x5)
#define KEYSCAN_ROWSENSE3_PA6 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x0, 0x6)
#define KEYSCAN_ROWSENSE3_PA7 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x0, 0x7)
#define KEYSCAN_ROWSENSE3_PA8 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x0, 0x8)
#define KEYSCAN_ROWSENSE3_PA9 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x0, 0x9)
#define KEYSCAN_ROWSENSE3_PB0 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x1, 0x0)
#define KEYSCAN_ROWSENSE3_PB1 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x1, 0x1)
#define KEYSCAN_ROWSENSE3_PB2 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x1, 0x2)
#define KEYSCAN_ROWSENSE3_PB3 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x1, 0x3)
#define KEYSCAN_ROWSENSE3_PB4 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x1, 0x4)
#define KEYSCAN_ROWSENSE3_PB5 SILABS_DBUS_KEYSCAN_ROWSENSE3(0x1, 0x5)
#define KEYSCAN_ROWSENSE4_PA0 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x0, 0x0)
#define KEYSCAN_ROWSENSE4_PA1 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x0, 0x1)
#define KEYSCAN_ROWSENSE4_PA2 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x0, 0x2)
#define KEYSCAN_ROWSENSE4_PA3 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x0, 0x3)
#define KEYSCAN_ROWSENSE4_PA4 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x0, 0x4)
#define KEYSCAN_ROWSENSE4_PA5 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x0, 0x5)
#define KEYSCAN_ROWSENSE4_PA6 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x0, 0x6)
#define KEYSCAN_ROWSENSE4_PA7 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x0, 0x7)
#define KEYSCAN_ROWSENSE4_PA8 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x0, 0x8)
#define KEYSCAN_ROWSENSE4_PA9 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x0, 0x9)
#define KEYSCAN_ROWSENSE4_PB0 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x1, 0x0)
#define KEYSCAN_ROWSENSE4_PB1 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x1, 0x1)
#define KEYSCAN_ROWSENSE4_PB2 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x1, 0x2)
#define KEYSCAN_ROWSENSE4_PB3 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x1, 0x3)
#define KEYSCAN_ROWSENSE4_PB4 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x1, 0x4)
#define KEYSCAN_ROWSENSE4_PB5 SILABS_DBUS_KEYSCAN_ROWSENSE4(0x1, 0x5)
#define KEYSCAN_ROWSENSE5_PA0 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x0, 0x0)
#define KEYSCAN_ROWSENSE5_PA1 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x0, 0x1)
#define KEYSCAN_ROWSENSE5_PA2 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x0, 0x2)
#define KEYSCAN_ROWSENSE5_PA3 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x0, 0x3)
#define KEYSCAN_ROWSENSE5_PA4 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x0, 0x4)
#define KEYSCAN_ROWSENSE5_PA5 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x0, 0x5)
#define KEYSCAN_ROWSENSE5_PA6 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x0, 0x6)
#define KEYSCAN_ROWSENSE5_PA7 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x0, 0x7)
#define KEYSCAN_ROWSENSE5_PA8 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x0, 0x8)
#define KEYSCAN_ROWSENSE5_PA9 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x0, 0x9)
#define KEYSCAN_ROWSENSE5_PB0 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x1, 0x0)
#define KEYSCAN_ROWSENSE5_PB1 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x1, 0x1)
#define KEYSCAN_ROWSENSE5_PB2 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x1, 0x2)
#define KEYSCAN_ROWSENSE5_PB3 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x1, 0x3)
#define KEYSCAN_ROWSENSE5_PB4 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x1, 0x4)
#define KEYSCAN_ROWSENSE5_PB5 SILABS_DBUS_KEYSCAN_ROWSENSE5(0x1, 0x5)

#define LETIMER0_OUT0_PA0 SILABS_DBUS_LETIMER0_OUT0(0x0, 0x0)
#define LETIMER0_OUT0_PA1 SILABS_DBUS_LETIMER0_OUT0(0x0, 0x1)
#define LETIMER0_OUT0_PA2 SILABS_DBUS_LETIMER0_OUT0(0x0, 0x2)
#define LETIMER0_OUT0_PA3 SILABS_DBUS_LETIMER0_OUT0(0x0, 0x3)
#define LETIMER0_OUT0_PA4 SILABS_DBUS_LETIMER0_OUT0(0x0, 0x4)
#define LETIMER0_OUT0_PA5 SILABS_DBUS_LETIMER0_OUT0(0x0, 0x5)
#define LETIMER0_OUT0_PA6 SILABS_DBUS_LETIMER0_OUT0(0x0, 0x6)
#define LETIMER0_OUT0_PA7 SILABS_DBUS_LETIMER0_OUT0(0x0, 0x7)
#define LETIMER0_OUT0_PA8 SILABS_DBUS_LETIMER0_OUT0(0x0, 0x8)
#define LETIMER0_OUT0_PA9 SILABS_DBUS_LETIMER0_OUT0(0x0, 0x9)
#define LETIMER0_OUT0_PB0 SILABS_DBUS_LETIMER0_OUT0(0x1, 0x0)
#define LETIMER0_OUT0_PB1 SILABS_DBUS_LETIMER0_OUT0(0x1, 0x1)
#define LETIMER0_OUT0_PB2 SILABS_DBUS_LETIMER0_OUT0(0x1, 0x2)
#define LETIMER0_OUT0_PB3 SILABS_DBUS_LETIMER0_OUT0(0x1, 0x3)
#define LETIMER0_OUT0_PB4 SILABS_DBUS_LETIMER0_OUT0(0x1, 0x4)
#define LETIMER0_OUT0_PB5 SILABS_DBUS_LETIMER0_OUT0(0x1, 0x5)
#define LETIMER0_OUT1_PA0 SILABS_DBUS_LETIMER0_OUT1(0x0, 0x0)
#define LETIMER0_OUT1_PA1 SILABS_DBUS_LETIMER0_OUT1(0x0, 0x1)
#define LETIMER0_OUT1_PA2 SILABS_DBUS_LETIMER0_OUT1(0x0, 0x2)
#define LETIMER0_OUT1_PA3 SILABS_DBUS_LETIMER0_OUT1(0x0, 0x3)
#define LETIMER0_OUT1_PA4 SILABS_DBUS_LETIMER0_OUT1(0x0, 0x4)
#define LETIMER0_OUT1_PA5 SILABS_DBUS_LETIMER0_OUT1(0x0, 0x5)
#define LETIMER0_OUT1_PA6 SILABS_DBUS_LETIMER0_OUT1(0x0, 0x6)
#define LETIMER0_OUT1_PA7 SILABS_DBUS_LETIMER0_OUT1(0x0, 0x7)
#define LETIMER0_OUT1_PA8 SILABS_DBUS_LETIMER0_OUT1(0x0, 0x8)
#define LETIMER0_OUT1_PA9 SILABS_DBUS_LETIMER0_OUT1(0x0, 0x9)
#define LETIMER0_OUT1_PB0 SILABS_DBUS_LETIMER0_OUT1(0x1, 0x0)
#define LETIMER0_OUT1_PB1 SILABS_DBUS_LETIMER0_OUT1(0x1, 0x1)
#define LETIMER0_OUT1_PB2 SILABS_DBUS_LETIMER0_OUT1(0x1, 0x2)
#define LETIMER0_OUT1_PB3 SILABS_DBUS_LETIMER0_OUT1(0x1, 0x3)
#define LETIMER0_OUT1_PB4 SILABS_DBUS_LETIMER0_OUT1(0x1, 0x4)
#define LETIMER0_OUT1_PB5 SILABS_DBUS_LETIMER0_OUT1(0x1, 0x5)

#define MODEM_ANT0_PA0        SILABS_DBUS_MODEM_ANT0(0x0, 0x0)
#define MODEM_ANT0_PA1        SILABS_DBUS_MODEM_ANT0(0x0, 0x1)
#define MODEM_ANT0_PA2        SILABS_DBUS_MODEM_ANT0(0x0, 0x2)
#define MODEM_ANT0_PA3        SILABS_DBUS_MODEM_ANT0(0x0, 0x3)
#define MODEM_ANT0_PA4        SILABS_DBUS_MODEM_ANT0(0x0, 0x4)
#define MODEM_ANT0_PA5        SILABS_DBUS_MODEM_ANT0(0x0, 0x5)
#define MODEM_ANT0_PA6        SILABS_DBUS_MODEM_ANT0(0x0, 0x6)
#define MODEM_ANT0_PA7        SILABS_DBUS_MODEM_ANT0(0x0, 0x7)
#define MODEM_ANT0_PA8        SILABS_DBUS_MODEM_ANT0(0x0, 0x8)
#define MODEM_ANT0_PA9        SILABS_DBUS_MODEM_ANT0(0x0, 0x9)
#define MODEM_ANT0_PB0        SILABS_DBUS_MODEM_ANT0(0x1, 0x0)
#define MODEM_ANT0_PB1        SILABS_DBUS_MODEM_ANT0(0x1, 0x1)
#define MODEM_ANT0_PB2        SILABS_DBUS_MODEM_ANT0(0x1, 0x2)
#define MODEM_ANT0_PB3        SILABS_DBUS_MODEM_ANT0(0x1, 0x3)
#define MODEM_ANT0_PB4        SILABS_DBUS_MODEM_ANT0(0x1, 0x4)
#define MODEM_ANT0_PB5        SILABS_DBUS_MODEM_ANT0(0x1, 0x5)
#define MODEM_ANT0_PC0        SILABS_DBUS_MODEM_ANT0(0x2, 0x0)
#define MODEM_ANT0_PC1        SILABS_DBUS_MODEM_ANT0(0x2, 0x1)
#define MODEM_ANT0_PC2        SILABS_DBUS_MODEM_ANT0(0x2, 0x2)
#define MODEM_ANT0_PC3        SILABS_DBUS_MODEM_ANT0(0x2, 0x3)
#define MODEM_ANT0_PC4        SILABS_DBUS_MODEM_ANT0(0x2, 0x4)
#define MODEM_ANT0_PC5        SILABS_DBUS_MODEM_ANT0(0x2, 0x5)
#define MODEM_ANT0_PC6        SILABS_DBUS_MODEM_ANT0(0x2, 0x6)
#define MODEM_ANT0_PC7        SILABS_DBUS_MODEM_ANT0(0x2, 0x7)
#define MODEM_ANT0_PC8        SILABS_DBUS_MODEM_ANT0(0x2, 0x8)
#define MODEM_ANT0_PC9        SILABS_DBUS_MODEM_ANT0(0x2, 0x9)
#define MODEM_ANT0_PD0        SILABS_DBUS_MODEM_ANT0(0x3, 0x0)
#define MODEM_ANT0_PD1        SILABS_DBUS_MODEM_ANT0(0x3, 0x1)
#define MODEM_ANT0_PD2        SILABS_DBUS_MODEM_ANT0(0x3, 0x2)
#define MODEM_ANT0_PD3        SILABS_DBUS_MODEM_ANT0(0x3, 0x3)
#define MODEM_ANT0_PD4        SILABS_DBUS_MODEM_ANT0(0x3, 0x4)
#define MODEM_ANT0_PD5        SILABS_DBUS_MODEM_ANT0(0x3, 0x5)
#define MODEM_ANT1_PA0        SILABS_DBUS_MODEM_ANT1(0x0, 0x0)
#define MODEM_ANT1_PA1        SILABS_DBUS_MODEM_ANT1(0x0, 0x1)
#define MODEM_ANT1_PA2        SILABS_DBUS_MODEM_ANT1(0x0, 0x2)
#define MODEM_ANT1_PA3        SILABS_DBUS_MODEM_ANT1(0x0, 0x3)
#define MODEM_ANT1_PA4        SILABS_DBUS_MODEM_ANT1(0x0, 0x4)
#define MODEM_ANT1_PA5        SILABS_DBUS_MODEM_ANT1(0x0, 0x5)
#define MODEM_ANT1_PA6        SILABS_DBUS_MODEM_ANT1(0x0, 0x6)
#define MODEM_ANT1_PA7        SILABS_DBUS_MODEM_ANT1(0x0, 0x7)
#define MODEM_ANT1_PA8        SILABS_DBUS_MODEM_ANT1(0x0, 0x8)
#define MODEM_ANT1_PA9        SILABS_DBUS_MODEM_ANT1(0x0, 0x9)
#define MODEM_ANT1_PB0        SILABS_DBUS_MODEM_ANT1(0x1, 0x0)
#define MODEM_ANT1_PB1        SILABS_DBUS_MODEM_ANT1(0x1, 0x1)
#define MODEM_ANT1_PB2        SILABS_DBUS_MODEM_ANT1(0x1, 0x2)
#define MODEM_ANT1_PB3        SILABS_DBUS_MODEM_ANT1(0x1, 0x3)
#define MODEM_ANT1_PB4        SILABS_DBUS_MODEM_ANT1(0x1, 0x4)
#define MODEM_ANT1_PB5        SILABS_DBUS_MODEM_ANT1(0x1, 0x5)
#define MODEM_ANT1_PC0        SILABS_DBUS_MODEM_ANT1(0x2, 0x0)
#define MODEM_ANT1_PC1        SILABS_DBUS_MODEM_ANT1(0x2, 0x1)
#define MODEM_ANT1_PC2        SILABS_DBUS_MODEM_ANT1(0x2, 0x2)
#define MODEM_ANT1_PC3        SILABS_DBUS_MODEM_ANT1(0x2, 0x3)
#define MODEM_ANT1_PC4        SILABS_DBUS_MODEM_ANT1(0x2, 0x4)
#define MODEM_ANT1_PC5        SILABS_DBUS_MODEM_ANT1(0x2, 0x5)
#define MODEM_ANT1_PC6        SILABS_DBUS_MODEM_ANT1(0x2, 0x6)
#define MODEM_ANT1_PC7        SILABS_DBUS_MODEM_ANT1(0x2, 0x7)
#define MODEM_ANT1_PC8        SILABS_DBUS_MODEM_ANT1(0x2, 0x8)
#define MODEM_ANT1_PC9        SILABS_DBUS_MODEM_ANT1(0x2, 0x9)
#define MODEM_ANT1_PD0        SILABS_DBUS_MODEM_ANT1(0x3, 0x0)
#define MODEM_ANT1_PD1        SILABS_DBUS_MODEM_ANT1(0x3, 0x1)
#define MODEM_ANT1_PD2        SILABS_DBUS_MODEM_ANT1(0x3, 0x2)
#define MODEM_ANT1_PD3        SILABS_DBUS_MODEM_ANT1(0x3, 0x3)
#define MODEM_ANT1_PD4        SILABS_DBUS_MODEM_ANT1(0x3, 0x4)
#define MODEM_ANT1_PD5        SILABS_DBUS_MODEM_ANT1(0x3, 0x5)
#define MODEM_ANTROLLOVER_PC0 SILABS_DBUS_MODEM_ANTROLLOVER(0x2, 0x0)
#define MODEM_ANTROLLOVER_PC1 SILABS_DBUS_MODEM_ANTROLLOVER(0x2, 0x1)
#define MODEM_ANTROLLOVER_PC2 SILABS_DBUS_MODEM_ANTROLLOVER(0x2, 0x2)
#define MODEM_ANTROLLOVER_PC3 SILABS_DBUS_MODEM_ANTROLLOVER(0x2, 0x3)
#define MODEM_ANTROLLOVER_PC4 SILABS_DBUS_MODEM_ANTROLLOVER(0x2, 0x4)
#define MODEM_ANTROLLOVER_PC5 SILABS_DBUS_MODEM_ANTROLLOVER(0x2, 0x5)
#define MODEM_ANTROLLOVER_PC6 SILABS_DBUS_MODEM_ANTROLLOVER(0x2, 0x6)
#define MODEM_ANTROLLOVER_PC7 SILABS_DBUS_MODEM_ANTROLLOVER(0x2, 0x7)
#define MODEM_ANTROLLOVER_PC8 SILABS_DBUS_MODEM_ANTROLLOVER(0x2, 0x8)
#define MODEM_ANTROLLOVER_PC9 SILABS_DBUS_MODEM_ANTROLLOVER(0x2, 0x9)
#define MODEM_ANTROLLOVER_PD0 SILABS_DBUS_MODEM_ANTROLLOVER(0x3, 0x0)
#define MODEM_ANTROLLOVER_PD1 SILABS_DBUS_MODEM_ANTROLLOVER(0x3, 0x1)
#define MODEM_ANTROLLOVER_PD2 SILABS_DBUS_MODEM_ANTROLLOVER(0x3, 0x2)
#define MODEM_ANTROLLOVER_PD3 SILABS_DBUS_MODEM_ANTROLLOVER(0x3, 0x3)
#define MODEM_ANTROLLOVER_PD4 SILABS_DBUS_MODEM_ANTROLLOVER(0x3, 0x4)
#define MODEM_ANTROLLOVER_PD5 SILABS_DBUS_MODEM_ANTROLLOVER(0x3, 0x5)
#define MODEM_ANTRR0_PC0      SILABS_DBUS_MODEM_ANTRR0(0x2, 0x0)
#define MODEM_ANTRR0_PC1      SILABS_DBUS_MODEM_ANTRR0(0x2, 0x1)
#define MODEM_ANTRR0_PC2      SILABS_DBUS_MODEM_ANTRR0(0x2, 0x2)
#define MODEM_ANTRR0_PC3      SILABS_DBUS_MODEM_ANTRR0(0x2, 0x3)
#define MODEM_ANTRR0_PC4      SILABS_DBUS_MODEM_ANTRR0(0x2, 0x4)
#define MODEM_ANTRR0_PC5      SILABS_DBUS_MODEM_ANTRR0(0x2, 0x5)
#define MODEM_ANTRR0_PC6      SILABS_DBUS_MODEM_ANTRR0(0x2, 0x6)
#define MODEM_ANTRR0_PC7      SILABS_DBUS_MODEM_ANTRR0(0x2, 0x7)
#define MODEM_ANTRR0_PC8      SILABS_DBUS_MODEM_ANTRR0(0x2, 0x8)
#define MODEM_ANTRR0_PC9      SILABS_DBUS_MODEM_ANTRR0(0x2, 0x9)
#define MODEM_ANTRR0_PD0      SILABS_DBUS_MODEM_ANTRR0(0x3, 0x0)
#define MODEM_ANTRR0_PD1      SILABS_DBUS_MODEM_ANTRR0(0x3, 0x1)
#define MODEM_ANTRR0_PD2      SILABS_DBUS_MODEM_ANTRR0(0x3, 0x2)
#define MODEM_ANTRR0_PD3      SILABS_DBUS_MODEM_ANTRR0(0x3, 0x3)
#define MODEM_ANTRR0_PD4      SILABS_DBUS_MODEM_ANTRR0(0x3, 0x4)
#define MODEM_ANTRR0_PD5      SILABS_DBUS_MODEM_ANTRR0(0x3, 0x5)
#define MODEM_ANTRR1_PC0      SILABS_DBUS_MODEM_ANTRR1(0x2, 0x0)
#define MODEM_ANTRR1_PC1      SILABS_DBUS_MODEM_ANTRR1(0x2, 0x1)
#define MODEM_ANTRR1_PC2      SILABS_DBUS_MODEM_ANTRR1(0x2, 0x2)
#define MODEM_ANTRR1_PC3      SILABS_DBUS_MODEM_ANTRR1(0x2, 0x3)
#define MODEM_ANTRR1_PC4      SILABS_DBUS_MODEM_ANTRR1(0x2, 0x4)
#define MODEM_ANTRR1_PC5      SILABS_DBUS_MODEM_ANTRR1(0x2, 0x5)
#define MODEM_ANTRR1_PC6      SILABS_DBUS_MODEM_ANTRR1(0x2, 0x6)
#define MODEM_ANTRR1_PC7      SILABS_DBUS_MODEM_ANTRR1(0x2, 0x7)
#define MODEM_ANTRR1_PC8      SILABS_DBUS_MODEM_ANTRR1(0x2, 0x8)
#define MODEM_ANTRR1_PC9      SILABS_DBUS_MODEM_ANTRR1(0x2, 0x9)
#define MODEM_ANTRR1_PD0      SILABS_DBUS_MODEM_ANTRR1(0x3, 0x0)
#define MODEM_ANTRR1_PD1      SILABS_DBUS_MODEM_ANTRR1(0x3, 0x1)
#define MODEM_ANTRR1_PD2      SILABS_DBUS_MODEM_ANTRR1(0x3, 0x2)
#define MODEM_ANTRR1_PD3      SILABS_DBUS_MODEM_ANTRR1(0x3, 0x3)
#define MODEM_ANTRR1_PD4      SILABS_DBUS_MODEM_ANTRR1(0x3, 0x4)
#define MODEM_ANTRR1_PD5      SILABS_DBUS_MODEM_ANTRR1(0x3, 0x5)
#define MODEM_ANTRR2_PC0      SILABS_DBUS_MODEM_ANTRR2(0x2, 0x0)
#define MODEM_ANTRR2_PC1      SILABS_DBUS_MODEM_ANTRR2(0x2, 0x1)
#define MODEM_ANTRR2_PC2      SILABS_DBUS_MODEM_ANTRR2(0x2, 0x2)
#define MODEM_ANTRR2_PC3      SILABS_DBUS_MODEM_ANTRR2(0x2, 0x3)
#define MODEM_ANTRR2_PC4      SILABS_DBUS_MODEM_ANTRR2(0x2, 0x4)
#define MODEM_ANTRR2_PC5      SILABS_DBUS_MODEM_ANTRR2(0x2, 0x5)
#define MODEM_ANTRR2_PC6      SILABS_DBUS_MODEM_ANTRR2(0x2, 0x6)
#define MODEM_ANTRR2_PC7      SILABS_DBUS_MODEM_ANTRR2(0x2, 0x7)
#define MODEM_ANTRR2_PC8      SILABS_DBUS_MODEM_ANTRR2(0x2, 0x8)
#define MODEM_ANTRR2_PC9      SILABS_DBUS_MODEM_ANTRR2(0x2, 0x9)
#define MODEM_ANTRR2_PD0      SILABS_DBUS_MODEM_ANTRR2(0x3, 0x0)
#define MODEM_ANTRR2_PD1      SILABS_DBUS_MODEM_ANTRR2(0x3, 0x1)
#define MODEM_ANTRR2_PD2      SILABS_DBUS_MODEM_ANTRR2(0x3, 0x2)
#define MODEM_ANTRR2_PD3      SILABS_DBUS_MODEM_ANTRR2(0x3, 0x3)
#define MODEM_ANTRR2_PD4      SILABS_DBUS_MODEM_ANTRR2(0x3, 0x4)
#define MODEM_ANTRR2_PD5      SILABS_DBUS_MODEM_ANTRR2(0x3, 0x5)
#define MODEM_ANTRR3_PC0      SILABS_DBUS_MODEM_ANTRR3(0x2, 0x0)
#define MODEM_ANTRR3_PC1      SILABS_DBUS_MODEM_ANTRR3(0x2, 0x1)
#define MODEM_ANTRR3_PC2      SILABS_DBUS_MODEM_ANTRR3(0x2, 0x2)
#define MODEM_ANTRR3_PC3      SILABS_DBUS_MODEM_ANTRR3(0x2, 0x3)
#define MODEM_ANTRR3_PC4      SILABS_DBUS_MODEM_ANTRR3(0x2, 0x4)
#define MODEM_ANTRR3_PC5      SILABS_DBUS_MODEM_ANTRR3(0x2, 0x5)
#define MODEM_ANTRR3_PC6      SILABS_DBUS_MODEM_ANTRR3(0x2, 0x6)
#define MODEM_ANTRR3_PC7      SILABS_DBUS_MODEM_ANTRR3(0x2, 0x7)
#define MODEM_ANTRR3_PC8      SILABS_DBUS_MODEM_ANTRR3(0x2, 0x8)
#define MODEM_ANTRR3_PC9      SILABS_DBUS_MODEM_ANTRR3(0x2, 0x9)
#define MODEM_ANTRR3_PD0      SILABS_DBUS_MODEM_ANTRR3(0x3, 0x0)
#define MODEM_ANTRR3_PD1      SILABS_DBUS_MODEM_ANTRR3(0x3, 0x1)
#define MODEM_ANTRR3_PD2      SILABS_DBUS_MODEM_ANTRR3(0x3, 0x2)
#define MODEM_ANTRR3_PD3      SILABS_DBUS_MODEM_ANTRR3(0x3, 0x3)
#define MODEM_ANTRR3_PD4      SILABS_DBUS_MODEM_ANTRR3(0x3, 0x4)
#define MODEM_ANTRR3_PD5      SILABS_DBUS_MODEM_ANTRR3(0x3, 0x5)
#define MODEM_ANTRR4_PC0      SILABS_DBUS_MODEM_ANTRR4(0x2, 0x0)
#define MODEM_ANTRR4_PC1      SILABS_DBUS_MODEM_ANTRR4(0x2, 0x1)
#define MODEM_ANTRR4_PC2      SILABS_DBUS_MODEM_ANTRR4(0x2, 0x2)
#define MODEM_ANTRR4_PC3      SILABS_DBUS_MODEM_ANTRR4(0x2, 0x3)
#define MODEM_ANTRR4_PC4      SILABS_DBUS_MODEM_ANTRR4(0x2, 0x4)
#define MODEM_ANTRR4_PC5      SILABS_DBUS_MODEM_ANTRR4(0x2, 0x5)
#define MODEM_ANTRR4_PC6      SILABS_DBUS_MODEM_ANTRR4(0x2, 0x6)
#define MODEM_ANTRR4_PC7      SILABS_DBUS_MODEM_ANTRR4(0x2, 0x7)
#define MODEM_ANTRR4_PC8      SILABS_DBUS_MODEM_ANTRR4(0x2, 0x8)
#define MODEM_ANTRR4_PC9      SILABS_DBUS_MODEM_ANTRR4(0x2, 0x9)
#define MODEM_ANTRR4_PD0      SILABS_DBUS_MODEM_ANTRR4(0x3, 0x0)
#define MODEM_ANTRR4_PD1      SILABS_DBUS_MODEM_ANTRR4(0x3, 0x1)
#define MODEM_ANTRR4_PD2      SILABS_DBUS_MODEM_ANTRR4(0x3, 0x2)
#define MODEM_ANTRR4_PD3      SILABS_DBUS_MODEM_ANTRR4(0x3, 0x3)
#define MODEM_ANTRR4_PD4      SILABS_DBUS_MODEM_ANTRR4(0x3, 0x4)
#define MODEM_ANTRR4_PD5      SILABS_DBUS_MODEM_ANTRR4(0x3, 0x5)
#define MODEM_ANTRR5_PC0      SILABS_DBUS_MODEM_ANTRR5(0x2, 0x0)
#define MODEM_ANTRR5_PC1      SILABS_DBUS_MODEM_ANTRR5(0x2, 0x1)
#define MODEM_ANTRR5_PC2      SILABS_DBUS_MODEM_ANTRR5(0x2, 0x2)
#define MODEM_ANTRR5_PC3      SILABS_DBUS_MODEM_ANTRR5(0x2, 0x3)
#define MODEM_ANTRR5_PC4      SILABS_DBUS_MODEM_ANTRR5(0x2, 0x4)
#define MODEM_ANTRR5_PC5      SILABS_DBUS_MODEM_ANTRR5(0x2, 0x5)
#define MODEM_ANTRR5_PC6      SILABS_DBUS_MODEM_ANTRR5(0x2, 0x6)
#define MODEM_ANTRR5_PC7      SILABS_DBUS_MODEM_ANTRR5(0x2, 0x7)
#define MODEM_ANTRR5_PC8      SILABS_DBUS_MODEM_ANTRR5(0x2, 0x8)
#define MODEM_ANTRR5_PC9      SILABS_DBUS_MODEM_ANTRR5(0x2, 0x9)
#define MODEM_ANTRR5_PD0      SILABS_DBUS_MODEM_ANTRR5(0x3, 0x0)
#define MODEM_ANTRR5_PD1      SILABS_DBUS_MODEM_ANTRR5(0x3, 0x1)
#define MODEM_ANTRR5_PD2      SILABS_DBUS_MODEM_ANTRR5(0x3, 0x2)
#define MODEM_ANTRR5_PD3      SILABS_DBUS_MODEM_ANTRR5(0x3, 0x3)
#define MODEM_ANTRR5_PD4      SILABS_DBUS_MODEM_ANTRR5(0x3, 0x4)
#define MODEM_ANTRR5_PD5      SILABS_DBUS_MODEM_ANTRR5(0x3, 0x5)
#define MODEM_ANTSWEN_PC0     SILABS_DBUS_MODEM_ANTSWEN(0x2, 0x0)
#define MODEM_ANTSWEN_PC1     SILABS_DBUS_MODEM_ANTSWEN(0x2, 0x1)
#define MODEM_ANTSWEN_PC2     SILABS_DBUS_MODEM_ANTSWEN(0x2, 0x2)
#define MODEM_ANTSWEN_PC3     SILABS_DBUS_MODEM_ANTSWEN(0x2, 0x3)
#define MODEM_ANTSWEN_PC4     SILABS_DBUS_MODEM_ANTSWEN(0x2, 0x4)
#define MODEM_ANTSWEN_PC5     SILABS_DBUS_MODEM_ANTSWEN(0x2, 0x5)
#define MODEM_ANTSWEN_PC6     SILABS_DBUS_MODEM_ANTSWEN(0x2, 0x6)
#define MODEM_ANTSWEN_PC7     SILABS_DBUS_MODEM_ANTSWEN(0x2, 0x7)
#define MODEM_ANTSWEN_PC8     SILABS_DBUS_MODEM_ANTSWEN(0x2, 0x8)
#define MODEM_ANTSWEN_PC9     SILABS_DBUS_MODEM_ANTSWEN(0x2, 0x9)
#define MODEM_ANTSWEN_PD0     SILABS_DBUS_MODEM_ANTSWEN(0x3, 0x0)
#define MODEM_ANTSWEN_PD1     SILABS_DBUS_MODEM_ANTSWEN(0x3, 0x1)
#define MODEM_ANTSWEN_PD2     SILABS_DBUS_MODEM_ANTSWEN(0x3, 0x2)
#define MODEM_ANTSWEN_PD3     SILABS_DBUS_MODEM_ANTSWEN(0x3, 0x3)
#define MODEM_ANTSWEN_PD4     SILABS_DBUS_MODEM_ANTSWEN(0x3, 0x4)
#define MODEM_ANTSWEN_PD5     SILABS_DBUS_MODEM_ANTSWEN(0x3, 0x5)
#define MODEM_ANTSWUS_PC0     SILABS_DBUS_MODEM_ANTSWUS(0x2, 0x0)
#define MODEM_ANTSWUS_PC1     SILABS_DBUS_MODEM_ANTSWUS(0x2, 0x1)
#define MODEM_ANTSWUS_PC2     SILABS_DBUS_MODEM_ANTSWUS(0x2, 0x2)
#define MODEM_ANTSWUS_PC3     SILABS_DBUS_MODEM_ANTSWUS(0x2, 0x3)
#define MODEM_ANTSWUS_PC4     SILABS_DBUS_MODEM_ANTSWUS(0x2, 0x4)
#define MODEM_ANTSWUS_PC5     SILABS_DBUS_MODEM_ANTSWUS(0x2, 0x5)
#define MODEM_ANTSWUS_PC6     SILABS_DBUS_MODEM_ANTSWUS(0x2, 0x6)
#define MODEM_ANTSWUS_PC7     SILABS_DBUS_MODEM_ANTSWUS(0x2, 0x7)
#define MODEM_ANTSWUS_PC8     SILABS_DBUS_MODEM_ANTSWUS(0x2, 0x8)
#define MODEM_ANTSWUS_PC9     SILABS_DBUS_MODEM_ANTSWUS(0x2, 0x9)
#define MODEM_ANTSWUS_PD0     SILABS_DBUS_MODEM_ANTSWUS(0x3, 0x0)
#define MODEM_ANTSWUS_PD1     SILABS_DBUS_MODEM_ANTSWUS(0x3, 0x1)
#define MODEM_ANTSWUS_PD2     SILABS_DBUS_MODEM_ANTSWUS(0x3, 0x2)
#define MODEM_ANTSWUS_PD3     SILABS_DBUS_MODEM_ANTSWUS(0x3, 0x3)
#define MODEM_ANTSWUS_PD4     SILABS_DBUS_MODEM_ANTSWUS(0x3, 0x4)
#define MODEM_ANTSWUS_PD5     SILABS_DBUS_MODEM_ANTSWUS(0x3, 0x5)
#define MODEM_ANTTRIG_PC0     SILABS_DBUS_MODEM_ANTTRIG(0x2, 0x0)
#define MODEM_ANTTRIG_PC1     SILABS_DBUS_MODEM_ANTTRIG(0x2, 0x1)
#define MODEM_ANTTRIG_PC2     SILABS_DBUS_MODEM_ANTTRIG(0x2, 0x2)
#define MODEM_ANTTRIG_PC3     SILABS_DBUS_MODEM_ANTTRIG(0x2, 0x3)
#define MODEM_ANTTRIG_PC4     SILABS_DBUS_MODEM_ANTTRIG(0x2, 0x4)
#define MODEM_ANTTRIG_PC5     SILABS_DBUS_MODEM_ANTTRIG(0x2, 0x5)
#define MODEM_ANTTRIG_PC6     SILABS_DBUS_MODEM_ANTTRIG(0x2, 0x6)
#define MODEM_ANTTRIG_PC7     SILABS_DBUS_MODEM_ANTTRIG(0x2, 0x7)
#define MODEM_ANTTRIG_PC8     SILABS_DBUS_MODEM_ANTTRIG(0x2, 0x8)
#define MODEM_ANTTRIG_PC9     SILABS_DBUS_MODEM_ANTTRIG(0x2, 0x9)
#define MODEM_ANTTRIG_PD0     SILABS_DBUS_MODEM_ANTTRIG(0x3, 0x0)
#define MODEM_ANTTRIG_PD1     SILABS_DBUS_MODEM_ANTTRIG(0x3, 0x1)
#define MODEM_ANTTRIG_PD2     SILABS_DBUS_MODEM_ANTTRIG(0x3, 0x2)
#define MODEM_ANTTRIG_PD3     SILABS_DBUS_MODEM_ANTTRIG(0x3, 0x3)
#define MODEM_ANTTRIG_PD4     SILABS_DBUS_MODEM_ANTTRIG(0x3, 0x4)
#define MODEM_ANTTRIG_PD5     SILABS_DBUS_MODEM_ANTTRIG(0x3, 0x5)
#define MODEM_ANTTRIGSTOP_PC0 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x2, 0x0)
#define MODEM_ANTTRIGSTOP_PC1 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x2, 0x1)
#define MODEM_ANTTRIGSTOP_PC2 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x2, 0x2)
#define MODEM_ANTTRIGSTOP_PC3 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x2, 0x3)
#define MODEM_ANTTRIGSTOP_PC4 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x2, 0x4)
#define MODEM_ANTTRIGSTOP_PC5 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x2, 0x5)
#define MODEM_ANTTRIGSTOP_PC6 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x2, 0x6)
#define MODEM_ANTTRIGSTOP_PC7 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x2, 0x7)
#define MODEM_ANTTRIGSTOP_PC8 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x2, 0x8)
#define MODEM_ANTTRIGSTOP_PC9 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x2, 0x9)
#define MODEM_ANTTRIGSTOP_PD0 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x3, 0x0)
#define MODEM_ANTTRIGSTOP_PD1 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x3, 0x1)
#define MODEM_ANTTRIGSTOP_PD2 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x3, 0x2)
#define MODEM_ANTTRIGSTOP_PD3 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x3, 0x3)
#define MODEM_ANTTRIGSTOP_PD4 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x3, 0x4)
#define MODEM_ANTTRIGSTOP_PD5 SILABS_DBUS_MODEM_ANTTRIGSTOP(0x3, 0x5)
#define MODEM_DCLK_PA0        SILABS_DBUS_MODEM_DCLK(0x0, 0x0)
#define MODEM_DCLK_PA1        SILABS_DBUS_MODEM_DCLK(0x0, 0x1)
#define MODEM_DCLK_PA2        SILABS_DBUS_MODEM_DCLK(0x0, 0x2)
#define MODEM_DCLK_PA3        SILABS_DBUS_MODEM_DCLK(0x0, 0x3)
#define MODEM_DCLK_PA4        SILABS_DBUS_MODEM_DCLK(0x0, 0x4)
#define MODEM_DCLK_PA5        SILABS_DBUS_MODEM_DCLK(0x0, 0x5)
#define MODEM_DCLK_PA6        SILABS_DBUS_MODEM_DCLK(0x0, 0x6)
#define MODEM_DCLK_PA7        SILABS_DBUS_MODEM_DCLK(0x0, 0x7)
#define MODEM_DCLK_PA8        SILABS_DBUS_MODEM_DCLK(0x0, 0x8)
#define MODEM_DCLK_PA9        SILABS_DBUS_MODEM_DCLK(0x0, 0x9)
#define MODEM_DCLK_PB0        SILABS_DBUS_MODEM_DCLK(0x1, 0x0)
#define MODEM_DCLK_PB1        SILABS_DBUS_MODEM_DCLK(0x1, 0x1)
#define MODEM_DCLK_PB2        SILABS_DBUS_MODEM_DCLK(0x1, 0x2)
#define MODEM_DCLK_PB3        SILABS_DBUS_MODEM_DCLK(0x1, 0x3)
#define MODEM_DCLK_PB4        SILABS_DBUS_MODEM_DCLK(0x1, 0x4)
#define MODEM_DCLK_PB5        SILABS_DBUS_MODEM_DCLK(0x1, 0x5)
#define MODEM_DOUT_PA0        SILABS_DBUS_MODEM_DOUT(0x0, 0x0)
#define MODEM_DOUT_PA1        SILABS_DBUS_MODEM_DOUT(0x0, 0x1)
#define MODEM_DOUT_PA2        SILABS_DBUS_MODEM_DOUT(0x0, 0x2)
#define MODEM_DOUT_PA3        SILABS_DBUS_MODEM_DOUT(0x0, 0x3)
#define MODEM_DOUT_PA4        SILABS_DBUS_MODEM_DOUT(0x0, 0x4)
#define MODEM_DOUT_PA5        SILABS_DBUS_MODEM_DOUT(0x0, 0x5)
#define MODEM_DOUT_PA6        SILABS_DBUS_MODEM_DOUT(0x0, 0x6)
#define MODEM_DOUT_PA7        SILABS_DBUS_MODEM_DOUT(0x0, 0x7)
#define MODEM_DOUT_PA8        SILABS_DBUS_MODEM_DOUT(0x0, 0x8)
#define MODEM_DOUT_PA9        SILABS_DBUS_MODEM_DOUT(0x0, 0x9)
#define MODEM_DOUT_PB0        SILABS_DBUS_MODEM_DOUT(0x1, 0x0)
#define MODEM_DOUT_PB1        SILABS_DBUS_MODEM_DOUT(0x1, 0x1)
#define MODEM_DOUT_PB2        SILABS_DBUS_MODEM_DOUT(0x1, 0x2)
#define MODEM_DOUT_PB3        SILABS_DBUS_MODEM_DOUT(0x1, 0x3)
#define MODEM_DOUT_PB4        SILABS_DBUS_MODEM_DOUT(0x1, 0x4)
#define MODEM_DOUT_PB5        SILABS_DBUS_MODEM_DOUT(0x1, 0x5)
#define MODEM_DIN_PA0         SILABS_DBUS_MODEM_DIN(0x0, 0x0)
#define MODEM_DIN_PA1         SILABS_DBUS_MODEM_DIN(0x0, 0x1)
#define MODEM_DIN_PA2         SILABS_DBUS_MODEM_DIN(0x0, 0x2)
#define MODEM_DIN_PA3         SILABS_DBUS_MODEM_DIN(0x0, 0x3)
#define MODEM_DIN_PA4         SILABS_DBUS_MODEM_DIN(0x0, 0x4)
#define MODEM_DIN_PA5         SILABS_DBUS_MODEM_DIN(0x0, 0x5)
#define MODEM_DIN_PA6         SILABS_DBUS_MODEM_DIN(0x0, 0x6)
#define MODEM_DIN_PA7         SILABS_DBUS_MODEM_DIN(0x0, 0x7)
#define MODEM_DIN_PA8         SILABS_DBUS_MODEM_DIN(0x0, 0x8)
#define MODEM_DIN_PA9         SILABS_DBUS_MODEM_DIN(0x0, 0x9)
#define MODEM_DIN_PB0         SILABS_DBUS_MODEM_DIN(0x1, 0x0)
#define MODEM_DIN_PB1         SILABS_DBUS_MODEM_DIN(0x1, 0x1)
#define MODEM_DIN_PB2         SILABS_DBUS_MODEM_DIN(0x1, 0x2)
#define MODEM_DIN_PB3         SILABS_DBUS_MODEM_DIN(0x1, 0x3)
#define MODEM_DIN_PB4         SILABS_DBUS_MODEM_DIN(0x1, 0x4)
#define MODEM_DIN_PB5         SILABS_DBUS_MODEM_DIN(0x1, 0x5)

#define PCNT0_S0IN_PA0 SILABS_DBUS_PCNT0_S0IN(0x0, 0x0)
#define PCNT0_S0IN_PA1 SILABS_DBUS_PCNT0_S0IN(0x0, 0x1)
#define PCNT0_S0IN_PA2 SILABS_DBUS_PCNT0_S0IN(0x0, 0x2)
#define PCNT0_S0IN_PA3 SILABS_DBUS_PCNT0_S0IN(0x0, 0x3)
#define PCNT0_S0IN_PA4 SILABS_DBUS_PCNT0_S0IN(0x0, 0x4)
#define PCNT0_S0IN_PA5 SILABS_DBUS_PCNT0_S0IN(0x0, 0x5)
#define PCNT0_S0IN_PA6 SILABS_DBUS_PCNT0_S0IN(0x0, 0x6)
#define PCNT0_S0IN_PA7 SILABS_DBUS_PCNT0_S0IN(0x0, 0x7)
#define PCNT0_S0IN_PA8 SILABS_DBUS_PCNT0_S0IN(0x0, 0x8)
#define PCNT0_S0IN_PA9 SILABS_DBUS_PCNT0_S0IN(0x0, 0x9)
#define PCNT0_S0IN_PB0 SILABS_DBUS_PCNT0_S0IN(0x1, 0x0)
#define PCNT0_S0IN_PB1 SILABS_DBUS_PCNT0_S0IN(0x1, 0x1)
#define PCNT0_S0IN_PB2 SILABS_DBUS_PCNT0_S0IN(0x1, 0x2)
#define PCNT0_S0IN_PB3 SILABS_DBUS_PCNT0_S0IN(0x1, 0x3)
#define PCNT0_S0IN_PB4 SILABS_DBUS_PCNT0_S0IN(0x1, 0x4)
#define PCNT0_S0IN_PB5 SILABS_DBUS_PCNT0_S0IN(0x1, 0x5)
#define PCNT0_S1IN_PA0 SILABS_DBUS_PCNT0_S1IN(0x0, 0x0)
#define PCNT0_S1IN_PA1 SILABS_DBUS_PCNT0_S1IN(0x0, 0x1)
#define PCNT0_S1IN_PA2 SILABS_DBUS_PCNT0_S1IN(0x0, 0x2)
#define PCNT0_S1IN_PA3 SILABS_DBUS_PCNT0_S1IN(0x0, 0x3)
#define PCNT0_S1IN_PA4 SILABS_DBUS_PCNT0_S1IN(0x0, 0x4)
#define PCNT0_S1IN_PA5 SILABS_DBUS_PCNT0_S1IN(0x0, 0x5)
#define PCNT0_S1IN_PA6 SILABS_DBUS_PCNT0_S1IN(0x0, 0x6)
#define PCNT0_S1IN_PA7 SILABS_DBUS_PCNT0_S1IN(0x0, 0x7)
#define PCNT0_S1IN_PA8 SILABS_DBUS_PCNT0_S1IN(0x0, 0x8)
#define PCNT0_S1IN_PA9 SILABS_DBUS_PCNT0_S1IN(0x0, 0x9)
#define PCNT0_S1IN_PB0 SILABS_DBUS_PCNT0_S1IN(0x1, 0x0)
#define PCNT0_S1IN_PB1 SILABS_DBUS_PCNT0_S1IN(0x1, 0x1)
#define PCNT0_S1IN_PB2 SILABS_DBUS_PCNT0_S1IN(0x1, 0x2)
#define PCNT0_S1IN_PB3 SILABS_DBUS_PCNT0_S1IN(0x1, 0x3)
#define PCNT0_S1IN_PB4 SILABS_DBUS_PCNT0_S1IN(0x1, 0x4)
#define PCNT0_S1IN_PB5 SILABS_DBUS_PCNT0_S1IN(0x1, 0x5)

#define PRS0_ASYNCH0_PA0  SILABS_DBUS_PRS0_ASYNCH0(0x0, 0x0)
#define PRS0_ASYNCH0_PA1  SILABS_DBUS_PRS0_ASYNCH0(0x0, 0x1)
#define PRS0_ASYNCH0_PA2  SILABS_DBUS_PRS0_ASYNCH0(0x0, 0x2)
#define PRS0_ASYNCH0_PA3  SILABS_DBUS_PRS0_ASYNCH0(0x0, 0x3)
#define PRS0_ASYNCH0_PA4  SILABS_DBUS_PRS0_ASYNCH0(0x0, 0x4)
#define PRS0_ASYNCH0_PA5  SILABS_DBUS_PRS0_ASYNCH0(0x0, 0x5)
#define PRS0_ASYNCH0_PA6  SILABS_DBUS_PRS0_ASYNCH0(0x0, 0x6)
#define PRS0_ASYNCH0_PA7  SILABS_DBUS_PRS0_ASYNCH0(0x0, 0x7)
#define PRS0_ASYNCH0_PA8  SILABS_DBUS_PRS0_ASYNCH0(0x0, 0x8)
#define PRS0_ASYNCH0_PA9  SILABS_DBUS_PRS0_ASYNCH0(0x0, 0x9)
#define PRS0_ASYNCH0_PB0  SILABS_DBUS_PRS0_ASYNCH0(0x1, 0x0)
#define PRS0_ASYNCH0_PB1  SILABS_DBUS_PRS0_ASYNCH0(0x1, 0x1)
#define PRS0_ASYNCH0_PB2  SILABS_DBUS_PRS0_ASYNCH0(0x1, 0x2)
#define PRS0_ASYNCH0_PB3  SILABS_DBUS_PRS0_ASYNCH0(0x1, 0x3)
#define PRS0_ASYNCH0_PB4  SILABS_DBUS_PRS0_ASYNCH0(0x1, 0x4)
#define PRS0_ASYNCH0_PB5  SILABS_DBUS_PRS0_ASYNCH0(0x1, 0x5)
#define PRS0_ASYNCH1_PA0  SILABS_DBUS_PRS0_ASYNCH1(0x0, 0x0)
#define PRS0_ASYNCH1_PA1  SILABS_DBUS_PRS0_ASYNCH1(0x0, 0x1)
#define PRS0_ASYNCH1_PA2  SILABS_DBUS_PRS0_ASYNCH1(0x0, 0x2)
#define PRS0_ASYNCH1_PA3  SILABS_DBUS_PRS0_ASYNCH1(0x0, 0x3)
#define PRS0_ASYNCH1_PA4  SILABS_DBUS_PRS0_ASYNCH1(0x0, 0x4)
#define PRS0_ASYNCH1_PA5  SILABS_DBUS_PRS0_ASYNCH1(0x0, 0x5)
#define PRS0_ASYNCH1_PA6  SILABS_DBUS_PRS0_ASYNCH1(0x0, 0x6)
#define PRS0_ASYNCH1_PA7  SILABS_DBUS_PRS0_ASYNCH1(0x0, 0x7)
#define PRS0_ASYNCH1_PA8  SILABS_DBUS_PRS0_ASYNCH1(0x0, 0x8)
#define PRS0_ASYNCH1_PA9  SILABS_DBUS_PRS0_ASYNCH1(0x0, 0x9)
#define PRS0_ASYNCH1_PB0  SILABS_DBUS_PRS0_ASYNCH1(0x1, 0x0)
#define PRS0_ASYNCH1_PB1  SILABS_DBUS_PRS0_ASYNCH1(0x1, 0x1)
#define PRS0_ASYNCH1_PB2  SILABS_DBUS_PRS0_ASYNCH1(0x1, 0x2)
#define PRS0_ASYNCH1_PB3  SILABS_DBUS_PRS0_ASYNCH1(0x1, 0x3)
#define PRS0_ASYNCH1_PB4  SILABS_DBUS_PRS0_ASYNCH1(0x1, 0x4)
#define PRS0_ASYNCH1_PB5  SILABS_DBUS_PRS0_ASYNCH1(0x1, 0x5)
#define PRS0_ASYNCH2_PA0  SILABS_DBUS_PRS0_ASYNCH2(0x0, 0x0)
#define PRS0_ASYNCH2_PA1  SILABS_DBUS_PRS0_ASYNCH2(0x0, 0x1)
#define PRS0_ASYNCH2_PA2  SILABS_DBUS_PRS0_ASYNCH2(0x0, 0x2)
#define PRS0_ASYNCH2_PA3  SILABS_DBUS_PRS0_ASYNCH2(0x0, 0x3)
#define PRS0_ASYNCH2_PA4  SILABS_DBUS_PRS0_ASYNCH2(0x0, 0x4)
#define PRS0_ASYNCH2_PA5  SILABS_DBUS_PRS0_ASYNCH2(0x0, 0x5)
#define PRS0_ASYNCH2_PA6  SILABS_DBUS_PRS0_ASYNCH2(0x0, 0x6)
#define PRS0_ASYNCH2_PA7  SILABS_DBUS_PRS0_ASYNCH2(0x0, 0x7)
#define PRS0_ASYNCH2_PA8  SILABS_DBUS_PRS0_ASYNCH2(0x0, 0x8)
#define PRS0_ASYNCH2_PA9  SILABS_DBUS_PRS0_ASYNCH2(0x0, 0x9)
#define PRS0_ASYNCH2_PB0  SILABS_DBUS_PRS0_ASYNCH2(0x1, 0x0)
#define PRS0_ASYNCH2_PB1  SILABS_DBUS_PRS0_ASYNCH2(0x1, 0x1)
#define PRS0_ASYNCH2_PB2  SILABS_DBUS_PRS0_ASYNCH2(0x1, 0x2)
#define PRS0_ASYNCH2_PB3  SILABS_DBUS_PRS0_ASYNCH2(0x1, 0x3)
#define PRS0_ASYNCH2_PB4  SILABS_DBUS_PRS0_ASYNCH2(0x1, 0x4)
#define PRS0_ASYNCH2_PB5  SILABS_DBUS_PRS0_ASYNCH2(0x1, 0x5)
#define PRS0_ASYNCH3_PA0  SILABS_DBUS_PRS0_ASYNCH3(0x0, 0x0)
#define PRS0_ASYNCH3_PA1  SILABS_DBUS_PRS0_ASYNCH3(0x0, 0x1)
#define PRS0_ASYNCH3_PA2  SILABS_DBUS_PRS0_ASYNCH3(0x0, 0x2)
#define PRS0_ASYNCH3_PA3  SILABS_DBUS_PRS0_ASYNCH3(0x0, 0x3)
#define PRS0_ASYNCH3_PA4  SILABS_DBUS_PRS0_ASYNCH3(0x0, 0x4)
#define PRS0_ASYNCH3_PA5  SILABS_DBUS_PRS0_ASYNCH3(0x0, 0x5)
#define PRS0_ASYNCH3_PA6  SILABS_DBUS_PRS0_ASYNCH3(0x0, 0x6)
#define PRS0_ASYNCH3_PA7  SILABS_DBUS_PRS0_ASYNCH3(0x0, 0x7)
#define PRS0_ASYNCH3_PA8  SILABS_DBUS_PRS0_ASYNCH3(0x0, 0x8)
#define PRS0_ASYNCH3_PA9  SILABS_DBUS_PRS0_ASYNCH3(0x0, 0x9)
#define PRS0_ASYNCH3_PB0  SILABS_DBUS_PRS0_ASYNCH3(0x1, 0x0)
#define PRS0_ASYNCH3_PB1  SILABS_DBUS_PRS0_ASYNCH3(0x1, 0x1)
#define PRS0_ASYNCH3_PB2  SILABS_DBUS_PRS0_ASYNCH3(0x1, 0x2)
#define PRS0_ASYNCH3_PB3  SILABS_DBUS_PRS0_ASYNCH3(0x1, 0x3)
#define PRS0_ASYNCH3_PB4  SILABS_DBUS_PRS0_ASYNCH3(0x1, 0x4)
#define PRS0_ASYNCH3_PB5  SILABS_DBUS_PRS0_ASYNCH3(0x1, 0x5)
#define PRS0_ASYNCH4_PA0  SILABS_DBUS_PRS0_ASYNCH4(0x0, 0x0)
#define PRS0_ASYNCH4_PA1  SILABS_DBUS_PRS0_ASYNCH4(0x0, 0x1)
#define PRS0_ASYNCH4_PA2  SILABS_DBUS_PRS0_ASYNCH4(0x0, 0x2)
#define PRS0_ASYNCH4_PA3  SILABS_DBUS_PRS0_ASYNCH4(0x0, 0x3)
#define PRS0_ASYNCH4_PA4  SILABS_DBUS_PRS0_ASYNCH4(0x0, 0x4)
#define PRS0_ASYNCH4_PA5  SILABS_DBUS_PRS0_ASYNCH4(0x0, 0x5)
#define PRS0_ASYNCH4_PA6  SILABS_DBUS_PRS0_ASYNCH4(0x0, 0x6)
#define PRS0_ASYNCH4_PA7  SILABS_DBUS_PRS0_ASYNCH4(0x0, 0x7)
#define PRS0_ASYNCH4_PA8  SILABS_DBUS_PRS0_ASYNCH4(0x0, 0x8)
#define PRS0_ASYNCH4_PA9  SILABS_DBUS_PRS0_ASYNCH4(0x0, 0x9)
#define PRS0_ASYNCH4_PB0  SILABS_DBUS_PRS0_ASYNCH4(0x1, 0x0)
#define PRS0_ASYNCH4_PB1  SILABS_DBUS_PRS0_ASYNCH4(0x1, 0x1)
#define PRS0_ASYNCH4_PB2  SILABS_DBUS_PRS0_ASYNCH4(0x1, 0x2)
#define PRS0_ASYNCH4_PB3  SILABS_DBUS_PRS0_ASYNCH4(0x1, 0x3)
#define PRS0_ASYNCH4_PB4  SILABS_DBUS_PRS0_ASYNCH4(0x1, 0x4)
#define PRS0_ASYNCH4_PB5  SILABS_DBUS_PRS0_ASYNCH4(0x1, 0x5)
#define PRS0_ASYNCH5_PA0  SILABS_DBUS_PRS0_ASYNCH5(0x0, 0x0)
#define PRS0_ASYNCH5_PA1  SILABS_DBUS_PRS0_ASYNCH5(0x0, 0x1)
#define PRS0_ASYNCH5_PA2  SILABS_DBUS_PRS0_ASYNCH5(0x0, 0x2)
#define PRS0_ASYNCH5_PA3  SILABS_DBUS_PRS0_ASYNCH5(0x0, 0x3)
#define PRS0_ASYNCH5_PA4  SILABS_DBUS_PRS0_ASYNCH5(0x0, 0x4)
#define PRS0_ASYNCH5_PA5  SILABS_DBUS_PRS0_ASYNCH5(0x0, 0x5)
#define PRS0_ASYNCH5_PA6  SILABS_DBUS_PRS0_ASYNCH5(0x0, 0x6)
#define PRS0_ASYNCH5_PA7  SILABS_DBUS_PRS0_ASYNCH5(0x0, 0x7)
#define PRS0_ASYNCH5_PA8  SILABS_DBUS_PRS0_ASYNCH5(0x0, 0x8)
#define PRS0_ASYNCH5_PA9  SILABS_DBUS_PRS0_ASYNCH5(0x0, 0x9)
#define PRS0_ASYNCH5_PB0  SILABS_DBUS_PRS0_ASYNCH5(0x1, 0x0)
#define PRS0_ASYNCH5_PB1  SILABS_DBUS_PRS0_ASYNCH5(0x1, 0x1)
#define PRS0_ASYNCH5_PB2  SILABS_DBUS_PRS0_ASYNCH5(0x1, 0x2)
#define PRS0_ASYNCH5_PB3  SILABS_DBUS_PRS0_ASYNCH5(0x1, 0x3)
#define PRS0_ASYNCH5_PB4  SILABS_DBUS_PRS0_ASYNCH5(0x1, 0x4)
#define PRS0_ASYNCH5_PB5  SILABS_DBUS_PRS0_ASYNCH5(0x1, 0x5)
#define PRS0_ASYNCH6_PC0  SILABS_DBUS_PRS0_ASYNCH6(0x2, 0x0)
#define PRS0_ASYNCH6_PC1  SILABS_DBUS_PRS0_ASYNCH6(0x2, 0x1)
#define PRS0_ASYNCH6_PC2  SILABS_DBUS_PRS0_ASYNCH6(0x2, 0x2)
#define PRS0_ASYNCH6_PC3  SILABS_DBUS_PRS0_ASYNCH6(0x2, 0x3)
#define PRS0_ASYNCH6_PC4  SILABS_DBUS_PRS0_ASYNCH6(0x2, 0x4)
#define PRS0_ASYNCH6_PC5  SILABS_DBUS_PRS0_ASYNCH6(0x2, 0x5)
#define PRS0_ASYNCH6_PC6  SILABS_DBUS_PRS0_ASYNCH6(0x2, 0x6)
#define PRS0_ASYNCH6_PC7  SILABS_DBUS_PRS0_ASYNCH6(0x2, 0x7)
#define PRS0_ASYNCH6_PC8  SILABS_DBUS_PRS0_ASYNCH6(0x2, 0x8)
#define PRS0_ASYNCH6_PC9  SILABS_DBUS_PRS0_ASYNCH6(0x2, 0x9)
#define PRS0_ASYNCH6_PD0  SILABS_DBUS_PRS0_ASYNCH6(0x3, 0x0)
#define PRS0_ASYNCH6_PD1  SILABS_DBUS_PRS0_ASYNCH6(0x3, 0x1)
#define PRS0_ASYNCH6_PD2  SILABS_DBUS_PRS0_ASYNCH6(0x3, 0x2)
#define PRS0_ASYNCH6_PD3  SILABS_DBUS_PRS0_ASYNCH6(0x3, 0x3)
#define PRS0_ASYNCH6_PD4  SILABS_DBUS_PRS0_ASYNCH6(0x3, 0x4)
#define PRS0_ASYNCH6_PD5  SILABS_DBUS_PRS0_ASYNCH6(0x3, 0x5)
#define PRS0_ASYNCH7_PC0  SILABS_DBUS_PRS0_ASYNCH7(0x2, 0x0)
#define PRS0_ASYNCH7_PC1  SILABS_DBUS_PRS0_ASYNCH7(0x2, 0x1)
#define PRS0_ASYNCH7_PC2  SILABS_DBUS_PRS0_ASYNCH7(0x2, 0x2)
#define PRS0_ASYNCH7_PC3  SILABS_DBUS_PRS0_ASYNCH7(0x2, 0x3)
#define PRS0_ASYNCH7_PC4  SILABS_DBUS_PRS0_ASYNCH7(0x2, 0x4)
#define PRS0_ASYNCH7_PC5  SILABS_DBUS_PRS0_ASYNCH7(0x2, 0x5)
#define PRS0_ASYNCH7_PC6  SILABS_DBUS_PRS0_ASYNCH7(0x2, 0x6)
#define PRS0_ASYNCH7_PC7  SILABS_DBUS_PRS0_ASYNCH7(0x2, 0x7)
#define PRS0_ASYNCH7_PC8  SILABS_DBUS_PRS0_ASYNCH7(0x2, 0x8)
#define PRS0_ASYNCH7_PC9  SILABS_DBUS_PRS0_ASYNCH7(0x2, 0x9)
#define PRS0_ASYNCH7_PD0  SILABS_DBUS_PRS0_ASYNCH7(0x3, 0x0)
#define PRS0_ASYNCH7_PD1  SILABS_DBUS_PRS0_ASYNCH7(0x3, 0x1)
#define PRS0_ASYNCH7_PD2  SILABS_DBUS_PRS0_ASYNCH7(0x3, 0x2)
#define PRS0_ASYNCH7_PD3  SILABS_DBUS_PRS0_ASYNCH7(0x3, 0x3)
#define PRS0_ASYNCH7_PD4  SILABS_DBUS_PRS0_ASYNCH7(0x3, 0x4)
#define PRS0_ASYNCH7_PD5  SILABS_DBUS_PRS0_ASYNCH7(0x3, 0x5)
#define PRS0_ASYNCH8_PC0  SILABS_DBUS_PRS0_ASYNCH8(0x2, 0x0)
#define PRS0_ASYNCH8_PC1  SILABS_DBUS_PRS0_ASYNCH8(0x2, 0x1)
#define PRS0_ASYNCH8_PC2  SILABS_DBUS_PRS0_ASYNCH8(0x2, 0x2)
#define PRS0_ASYNCH8_PC3  SILABS_DBUS_PRS0_ASYNCH8(0x2, 0x3)
#define PRS0_ASYNCH8_PC4  SILABS_DBUS_PRS0_ASYNCH8(0x2, 0x4)
#define PRS0_ASYNCH8_PC5  SILABS_DBUS_PRS0_ASYNCH8(0x2, 0x5)
#define PRS0_ASYNCH8_PC6  SILABS_DBUS_PRS0_ASYNCH8(0x2, 0x6)
#define PRS0_ASYNCH8_PC7  SILABS_DBUS_PRS0_ASYNCH8(0x2, 0x7)
#define PRS0_ASYNCH8_PC8  SILABS_DBUS_PRS0_ASYNCH8(0x2, 0x8)
#define PRS0_ASYNCH8_PC9  SILABS_DBUS_PRS0_ASYNCH8(0x2, 0x9)
#define PRS0_ASYNCH8_PD0  SILABS_DBUS_PRS0_ASYNCH8(0x3, 0x0)
#define PRS0_ASYNCH8_PD1  SILABS_DBUS_PRS0_ASYNCH8(0x3, 0x1)
#define PRS0_ASYNCH8_PD2  SILABS_DBUS_PRS0_ASYNCH8(0x3, 0x2)
#define PRS0_ASYNCH8_PD3  SILABS_DBUS_PRS0_ASYNCH8(0x3, 0x3)
#define PRS0_ASYNCH8_PD4  SILABS_DBUS_PRS0_ASYNCH8(0x3, 0x4)
#define PRS0_ASYNCH8_PD5  SILABS_DBUS_PRS0_ASYNCH8(0x3, 0x5)
#define PRS0_ASYNCH9_PC0  SILABS_DBUS_PRS0_ASYNCH9(0x2, 0x0)
#define PRS0_ASYNCH9_PC1  SILABS_DBUS_PRS0_ASYNCH9(0x2, 0x1)
#define PRS0_ASYNCH9_PC2  SILABS_DBUS_PRS0_ASYNCH9(0x2, 0x2)
#define PRS0_ASYNCH9_PC3  SILABS_DBUS_PRS0_ASYNCH9(0x2, 0x3)
#define PRS0_ASYNCH9_PC4  SILABS_DBUS_PRS0_ASYNCH9(0x2, 0x4)
#define PRS0_ASYNCH9_PC5  SILABS_DBUS_PRS0_ASYNCH9(0x2, 0x5)
#define PRS0_ASYNCH9_PC6  SILABS_DBUS_PRS0_ASYNCH9(0x2, 0x6)
#define PRS0_ASYNCH9_PC7  SILABS_DBUS_PRS0_ASYNCH9(0x2, 0x7)
#define PRS0_ASYNCH9_PC8  SILABS_DBUS_PRS0_ASYNCH9(0x2, 0x8)
#define PRS0_ASYNCH9_PC9  SILABS_DBUS_PRS0_ASYNCH9(0x2, 0x9)
#define PRS0_ASYNCH9_PD0  SILABS_DBUS_PRS0_ASYNCH9(0x3, 0x0)
#define PRS0_ASYNCH9_PD1  SILABS_DBUS_PRS0_ASYNCH9(0x3, 0x1)
#define PRS0_ASYNCH9_PD2  SILABS_DBUS_PRS0_ASYNCH9(0x3, 0x2)
#define PRS0_ASYNCH9_PD3  SILABS_DBUS_PRS0_ASYNCH9(0x3, 0x3)
#define PRS0_ASYNCH9_PD4  SILABS_DBUS_PRS0_ASYNCH9(0x3, 0x4)
#define PRS0_ASYNCH9_PD5  SILABS_DBUS_PRS0_ASYNCH9(0x3, 0x5)
#define PRS0_ASYNCH10_PC0 SILABS_DBUS_PRS0_ASYNCH10(0x2, 0x0)
#define PRS0_ASYNCH10_PC1 SILABS_DBUS_PRS0_ASYNCH10(0x2, 0x1)
#define PRS0_ASYNCH10_PC2 SILABS_DBUS_PRS0_ASYNCH10(0x2, 0x2)
#define PRS0_ASYNCH10_PC3 SILABS_DBUS_PRS0_ASYNCH10(0x2, 0x3)
#define PRS0_ASYNCH10_PC4 SILABS_DBUS_PRS0_ASYNCH10(0x2, 0x4)
#define PRS0_ASYNCH10_PC5 SILABS_DBUS_PRS0_ASYNCH10(0x2, 0x5)
#define PRS0_ASYNCH10_PC6 SILABS_DBUS_PRS0_ASYNCH10(0x2, 0x6)
#define PRS0_ASYNCH10_PC7 SILABS_DBUS_PRS0_ASYNCH10(0x2, 0x7)
#define PRS0_ASYNCH10_PC8 SILABS_DBUS_PRS0_ASYNCH10(0x2, 0x8)
#define PRS0_ASYNCH10_PC9 SILABS_DBUS_PRS0_ASYNCH10(0x2, 0x9)
#define PRS0_ASYNCH10_PD0 SILABS_DBUS_PRS0_ASYNCH10(0x3, 0x0)
#define PRS0_ASYNCH10_PD1 SILABS_DBUS_PRS0_ASYNCH10(0x3, 0x1)
#define PRS0_ASYNCH10_PD2 SILABS_DBUS_PRS0_ASYNCH10(0x3, 0x2)
#define PRS0_ASYNCH10_PD3 SILABS_DBUS_PRS0_ASYNCH10(0x3, 0x3)
#define PRS0_ASYNCH10_PD4 SILABS_DBUS_PRS0_ASYNCH10(0x3, 0x4)
#define PRS0_ASYNCH10_PD5 SILABS_DBUS_PRS0_ASYNCH10(0x3, 0x5)
#define PRS0_ASYNCH11_PC0 SILABS_DBUS_PRS0_ASYNCH11(0x2, 0x0)
#define PRS0_ASYNCH11_PC1 SILABS_DBUS_PRS0_ASYNCH11(0x2, 0x1)
#define PRS0_ASYNCH11_PC2 SILABS_DBUS_PRS0_ASYNCH11(0x2, 0x2)
#define PRS0_ASYNCH11_PC3 SILABS_DBUS_PRS0_ASYNCH11(0x2, 0x3)
#define PRS0_ASYNCH11_PC4 SILABS_DBUS_PRS0_ASYNCH11(0x2, 0x4)
#define PRS0_ASYNCH11_PC5 SILABS_DBUS_PRS0_ASYNCH11(0x2, 0x5)
#define PRS0_ASYNCH11_PC6 SILABS_DBUS_PRS0_ASYNCH11(0x2, 0x6)
#define PRS0_ASYNCH11_PC7 SILABS_DBUS_PRS0_ASYNCH11(0x2, 0x7)
#define PRS0_ASYNCH11_PC8 SILABS_DBUS_PRS0_ASYNCH11(0x2, 0x8)
#define PRS0_ASYNCH11_PC9 SILABS_DBUS_PRS0_ASYNCH11(0x2, 0x9)
#define PRS0_ASYNCH11_PD0 SILABS_DBUS_PRS0_ASYNCH11(0x3, 0x0)
#define PRS0_ASYNCH11_PD1 SILABS_DBUS_PRS0_ASYNCH11(0x3, 0x1)
#define PRS0_ASYNCH11_PD2 SILABS_DBUS_PRS0_ASYNCH11(0x3, 0x2)
#define PRS0_ASYNCH11_PD3 SILABS_DBUS_PRS0_ASYNCH11(0x3, 0x3)
#define PRS0_ASYNCH11_PD4 SILABS_DBUS_PRS0_ASYNCH11(0x3, 0x4)
#define PRS0_ASYNCH11_PD5 SILABS_DBUS_PRS0_ASYNCH11(0x3, 0x5)
#define PRS0_ASYNCH12_PA0 SILABS_DBUS_PRS0_ASYNCH12(0x0, 0x0)
#define PRS0_ASYNCH12_PA1 SILABS_DBUS_PRS0_ASYNCH12(0x0, 0x1)
#define PRS0_ASYNCH12_PA2 SILABS_DBUS_PRS0_ASYNCH12(0x0, 0x2)
#define PRS0_ASYNCH12_PA3 SILABS_DBUS_PRS0_ASYNCH12(0x0, 0x3)
#define PRS0_ASYNCH12_PA4 SILABS_DBUS_PRS0_ASYNCH12(0x0, 0x4)
#define PRS0_ASYNCH12_PA5 SILABS_DBUS_PRS0_ASYNCH12(0x0, 0x5)
#define PRS0_ASYNCH12_PA6 SILABS_DBUS_PRS0_ASYNCH12(0x0, 0x6)
#define PRS0_ASYNCH12_PA7 SILABS_DBUS_PRS0_ASYNCH12(0x0, 0x7)
#define PRS0_ASYNCH12_PA8 SILABS_DBUS_PRS0_ASYNCH12(0x0, 0x8)
#define PRS0_ASYNCH12_PA9 SILABS_DBUS_PRS0_ASYNCH12(0x0, 0x9)
#define PRS0_ASYNCH12_PB0 SILABS_DBUS_PRS0_ASYNCH12(0x1, 0x0)
#define PRS0_ASYNCH12_PB1 SILABS_DBUS_PRS0_ASYNCH12(0x1, 0x1)
#define PRS0_ASYNCH12_PB2 SILABS_DBUS_PRS0_ASYNCH12(0x1, 0x2)
#define PRS0_ASYNCH12_PB3 SILABS_DBUS_PRS0_ASYNCH12(0x1, 0x3)
#define PRS0_ASYNCH12_PB4 SILABS_DBUS_PRS0_ASYNCH12(0x1, 0x4)
#define PRS0_ASYNCH12_PB5 SILABS_DBUS_PRS0_ASYNCH12(0x1, 0x5)
#define PRS0_ASYNCH13_PA0 SILABS_DBUS_PRS0_ASYNCH13(0x0, 0x0)
#define PRS0_ASYNCH13_PA1 SILABS_DBUS_PRS0_ASYNCH13(0x0, 0x1)
#define PRS0_ASYNCH13_PA2 SILABS_DBUS_PRS0_ASYNCH13(0x0, 0x2)
#define PRS0_ASYNCH13_PA3 SILABS_DBUS_PRS0_ASYNCH13(0x0, 0x3)
#define PRS0_ASYNCH13_PA4 SILABS_DBUS_PRS0_ASYNCH13(0x0, 0x4)
#define PRS0_ASYNCH13_PA5 SILABS_DBUS_PRS0_ASYNCH13(0x0, 0x5)
#define PRS0_ASYNCH13_PA6 SILABS_DBUS_PRS0_ASYNCH13(0x0, 0x6)
#define PRS0_ASYNCH13_PA7 SILABS_DBUS_PRS0_ASYNCH13(0x0, 0x7)
#define PRS0_ASYNCH13_PA8 SILABS_DBUS_PRS0_ASYNCH13(0x0, 0x8)
#define PRS0_ASYNCH13_PA9 SILABS_DBUS_PRS0_ASYNCH13(0x0, 0x9)
#define PRS0_ASYNCH13_PB0 SILABS_DBUS_PRS0_ASYNCH13(0x1, 0x0)
#define PRS0_ASYNCH13_PB1 SILABS_DBUS_PRS0_ASYNCH13(0x1, 0x1)
#define PRS0_ASYNCH13_PB2 SILABS_DBUS_PRS0_ASYNCH13(0x1, 0x2)
#define PRS0_ASYNCH13_PB3 SILABS_DBUS_PRS0_ASYNCH13(0x1, 0x3)
#define PRS0_ASYNCH13_PB4 SILABS_DBUS_PRS0_ASYNCH13(0x1, 0x4)
#define PRS0_ASYNCH13_PB5 SILABS_DBUS_PRS0_ASYNCH13(0x1, 0x5)
#define PRS0_ASYNCH14_PA0 SILABS_DBUS_PRS0_ASYNCH14(0x0, 0x0)
#define PRS0_ASYNCH14_PA1 SILABS_DBUS_PRS0_ASYNCH14(0x0, 0x1)
#define PRS0_ASYNCH14_PA2 SILABS_DBUS_PRS0_ASYNCH14(0x0, 0x2)
#define PRS0_ASYNCH14_PA3 SILABS_DBUS_PRS0_ASYNCH14(0x0, 0x3)
#define PRS0_ASYNCH14_PA4 SILABS_DBUS_PRS0_ASYNCH14(0x0, 0x4)
#define PRS0_ASYNCH14_PA5 SILABS_DBUS_PRS0_ASYNCH14(0x0, 0x5)
#define PRS0_ASYNCH14_PA6 SILABS_DBUS_PRS0_ASYNCH14(0x0, 0x6)
#define PRS0_ASYNCH14_PA7 SILABS_DBUS_PRS0_ASYNCH14(0x0, 0x7)
#define PRS0_ASYNCH14_PA8 SILABS_DBUS_PRS0_ASYNCH14(0x0, 0x8)
#define PRS0_ASYNCH14_PA9 SILABS_DBUS_PRS0_ASYNCH14(0x0, 0x9)
#define PRS0_ASYNCH14_PB0 SILABS_DBUS_PRS0_ASYNCH14(0x1, 0x0)
#define PRS0_ASYNCH14_PB1 SILABS_DBUS_PRS0_ASYNCH14(0x1, 0x1)
#define PRS0_ASYNCH14_PB2 SILABS_DBUS_PRS0_ASYNCH14(0x1, 0x2)
#define PRS0_ASYNCH14_PB3 SILABS_DBUS_PRS0_ASYNCH14(0x1, 0x3)
#define PRS0_ASYNCH14_PB4 SILABS_DBUS_PRS0_ASYNCH14(0x1, 0x4)
#define PRS0_ASYNCH14_PB5 SILABS_DBUS_PRS0_ASYNCH14(0x1, 0x5)
#define PRS0_ASYNCH15_PA0 SILABS_DBUS_PRS0_ASYNCH15(0x0, 0x0)
#define PRS0_ASYNCH15_PA1 SILABS_DBUS_PRS0_ASYNCH15(0x0, 0x1)
#define PRS0_ASYNCH15_PA2 SILABS_DBUS_PRS0_ASYNCH15(0x0, 0x2)
#define PRS0_ASYNCH15_PA3 SILABS_DBUS_PRS0_ASYNCH15(0x0, 0x3)
#define PRS0_ASYNCH15_PA4 SILABS_DBUS_PRS0_ASYNCH15(0x0, 0x4)
#define PRS0_ASYNCH15_PA5 SILABS_DBUS_PRS0_ASYNCH15(0x0, 0x5)
#define PRS0_ASYNCH15_PA6 SILABS_DBUS_PRS0_ASYNCH15(0x0, 0x6)
#define PRS0_ASYNCH15_PA7 SILABS_DBUS_PRS0_ASYNCH15(0x0, 0x7)
#define PRS0_ASYNCH15_PA8 SILABS_DBUS_PRS0_ASYNCH15(0x0, 0x8)
#define PRS0_ASYNCH15_PA9 SILABS_DBUS_PRS0_ASYNCH15(0x0, 0x9)
#define PRS0_ASYNCH15_PB0 SILABS_DBUS_PRS0_ASYNCH15(0x1, 0x0)
#define PRS0_ASYNCH15_PB1 SILABS_DBUS_PRS0_ASYNCH15(0x1, 0x1)
#define PRS0_ASYNCH15_PB2 SILABS_DBUS_PRS0_ASYNCH15(0x1, 0x2)
#define PRS0_ASYNCH15_PB3 SILABS_DBUS_PRS0_ASYNCH15(0x1, 0x3)
#define PRS0_ASYNCH15_PB4 SILABS_DBUS_PRS0_ASYNCH15(0x1, 0x4)
#define PRS0_ASYNCH15_PB5 SILABS_DBUS_PRS0_ASYNCH15(0x1, 0x5)
#define PRS0_SYNCH0_PA0   SILABS_DBUS_PRS0_SYNCH0(0x0, 0x0)
#define PRS0_SYNCH0_PA1   SILABS_DBUS_PRS0_SYNCH0(0x0, 0x1)
#define PRS0_SYNCH0_PA2   SILABS_DBUS_PRS0_SYNCH0(0x0, 0x2)
#define PRS0_SYNCH0_PA3   SILABS_DBUS_PRS0_SYNCH0(0x0, 0x3)
#define PRS0_SYNCH0_PA4   SILABS_DBUS_PRS0_SYNCH0(0x0, 0x4)
#define PRS0_SYNCH0_PA5   SILABS_DBUS_PRS0_SYNCH0(0x0, 0x5)
#define PRS0_SYNCH0_PA6   SILABS_DBUS_PRS0_SYNCH0(0x0, 0x6)
#define PRS0_SYNCH0_PA7   SILABS_DBUS_PRS0_SYNCH0(0x0, 0x7)
#define PRS0_SYNCH0_PA8   SILABS_DBUS_PRS0_SYNCH0(0x0, 0x8)
#define PRS0_SYNCH0_PA9   SILABS_DBUS_PRS0_SYNCH0(0x0, 0x9)
#define PRS0_SYNCH0_PB0   SILABS_DBUS_PRS0_SYNCH0(0x1, 0x0)
#define PRS0_SYNCH0_PB1   SILABS_DBUS_PRS0_SYNCH0(0x1, 0x1)
#define PRS0_SYNCH0_PB2   SILABS_DBUS_PRS0_SYNCH0(0x1, 0x2)
#define PRS0_SYNCH0_PB3   SILABS_DBUS_PRS0_SYNCH0(0x1, 0x3)
#define PRS0_SYNCH0_PB4   SILABS_DBUS_PRS0_SYNCH0(0x1, 0x4)
#define PRS0_SYNCH0_PB5   SILABS_DBUS_PRS0_SYNCH0(0x1, 0x5)
#define PRS0_SYNCH0_PC0   SILABS_DBUS_PRS0_SYNCH0(0x2, 0x0)
#define PRS0_SYNCH0_PC1   SILABS_DBUS_PRS0_SYNCH0(0x2, 0x1)
#define PRS0_SYNCH0_PC2   SILABS_DBUS_PRS0_SYNCH0(0x2, 0x2)
#define PRS0_SYNCH0_PC3   SILABS_DBUS_PRS0_SYNCH0(0x2, 0x3)
#define PRS0_SYNCH0_PC4   SILABS_DBUS_PRS0_SYNCH0(0x2, 0x4)
#define PRS0_SYNCH0_PC5   SILABS_DBUS_PRS0_SYNCH0(0x2, 0x5)
#define PRS0_SYNCH0_PC6   SILABS_DBUS_PRS0_SYNCH0(0x2, 0x6)
#define PRS0_SYNCH0_PC7   SILABS_DBUS_PRS0_SYNCH0(0x2, 0x7)
#define PRS0_SYNCH0_PC8   SILABS_DBUS_PRS0_SYNCH0(0x2, 0x8)
#define PRS0_SYNCH0_PC9   SILABS_DBUS_PRS0_SYNCH0(0x2, 0x9)
#define PRS0_SYNCH0_PD0   SILABS_DBUS_PRS0_SYNCH0(0x3, 0x0)
#define PRS0_SYNCH0_PD1   SILABS_DBUS_PRS0_SYNCH0(0x3, 0x1)
#define PRS0_SYNCH0_PD2   SILABS_DBUS_PRS0_SYNCH0(0x3, 0x2)
#define PRS0_SYNCH0_PD3   SILABS_DBUS_PRS0_SYNCH0(0x3, 0x3)
#define PRS0_SYNCH0_PD4   SILABS_DBUS_PRS0_SYNCH0(0x3, 0x4)
#define PRS0_SYNCH0_PD5   SILABS_DBUS_PRS0_SYNCH0(0x3, 0x5)
#define PRS0_SYNCH1_PA0   SILABS_DBUS_PRS0_SYNCH1(0x0, 0x0)
#define PRS0_SYNCH1_PA1   SILABS_DBUS_PRS0_SYNCH1(0x0, 0x1)
#define PRS0_SYNCH1_PA2   SILABS_DBUS_PRS0_SYNCH1(0x0, 0x2)
#define PRS0_SYNCH1_PA3   SILABS_DBUS_PRS0_SYNCH1(0x0, 0x3)
#define PRS0_SYNCH1_PA4   SILABS_DBUS_PRS0_SYNCH1(0x0, 0x4)
#define PRS0_SYNCH1_PA5   SILABS_DBUS_PRS0_SYNCH1(0x0, 0x5)
#define PRS0_SYNCH1_PA6   SILABS_DBUS_PRS0_SYNCH1(0x0, 0x6)
#define PRS0_SYNCH1_PA7   SILABS_DBUS_PRS0_SYNCH1(0x0, 0x7)
#define PRS0_SYNCH1_PA8   SILABS_DBUS_PRS0_SYNCH1(0x0, 0x8)
#define PRS0_SYNCH1_PA9   SILABS_DBUS_PRS0_SYNCH1(0x0, 0x9)
#define PRS0_SYNCH1_PB0   SILABS_DBUS_PRS0_SYNCH1(0x1, 0x0)
#define PRS0_SYNCH1_PB1   SILABS_DBUS_PRS0_SYNCH1(0x1, 0x1)
#define PRS0_SYNCH1_PB2   SILABS_DBUS_PRS0_SYNCH1(0x1, 0x2)
#define PRS0_SYNCH1_PB3   SILABS_DBUS_PRS0_SYNCH1(0x1, 0x3)
#define PRS0_SYNCH1_PB4   SILABS_DBUS_PRS0_SYNCH1(0x1, 0x4)
#define PRS0_SYNCH1_PB5   SILABS_DBUS_PRS0_SYNCH1(0x1, 0x5)
#define PRS0_SYNCH1_PC0   SILABS_DBUS_PRS0_SYNCH1(0x2, 0x0)
#define PRS0_SYNCH1_PC1   SILABS_DBUS_PRS0_SYNCH1(0x2, 0x1)
#define PRS0_SYNCH1_PC2   SILABS_DBUS_PRS0_SYNCH1(0x2, 0x2)
#define PRS0_SYNCH1_PC3   SILABS_DBUS_PRS0_SYNCH1(0x2, 0x3)
#define PRS0_SYNCH1_PC4   SILABS_DBUS_PRS0_SYNCH1(0x2, 0x4)
#define PRS0_SYNCH1_PC5   SILABS_DBUS_PRS0_SYNCH1(0x2, 0x5)
#define PRS0_SYNCH1_PC6   SILABS_DBUS_PRS0_SYNCH1(0x2, 0x6)
#define PRS0_SYNCH1_PC7   SILABS_DBUS_PRS0_SYNCH1(0x2, 0x7)
#define PRS0_SYNCH1_PC8   SILABS_DBUS_PRS0_SYNCH1(0x2, 0x8)
#define PRS0_SYNCH1_PC9   SILABS_DBUS_PRS0_SYNCH1(0x2, 0x9)
#define PRS0_SYNCH1_PD0   SILABS_DBUS_PRS0_SYNCH1(0x3, 0x0)
#define PRS0_SYNCH1_PD1   SILABS_DBUS_PRS0_SYNCH1(0x3, 0x1)
#define PRS0_SYNCH1_PD2   SILABS_DBUS_PRS0_SYNCH1(0x3, 0x2)
#define PRS0_SYNCH1_PD3   SILABS_DBUS_PRS0_SYNCH1(0x3, 0x3)
#define PRS0_SYNCH1_PD4   SILABS_DBUS_PRS0_SYNCH1(0x3, 0x4)
#define PRS0_SYNCH1_PD5   SILABS_DBUS_PRS0_SYNCH1(0x3, 0x5)
#define PRS0_SYNCH2_PA0   SILABS_DBUS_PRS0_SYNCH2(0x0, 0x0)
#define PRS0_SYNCH2_PA1   SILABS_DBUS_PRS0_SYNCH2(0x0, 0x1)
#define PRS0_SYNCH2_PA2   SILABS_DBUS_PRS0_SYNCH2(0x0, 0x2)
#define PRS0_SYNCH2_PA3   SILABS_DBUS_PRS0_SYNCH2(0x0, 0x3)
#define PRS0_SYNCH2_PA4   SILABS_DBUS_PRS0_SYNCH2(0x0, 0x4)
#define PRS0_SYNCH2_PA5   SILABS_DBUS_PRS0_SYNCH2(0x0, 0x5)
#define PRS0_SYNCH2_PA6   SILABS_DBUS_PRS0_SYNCH2(0x0, 0x6)
#define PRS0_SYNCH2_PA7   SILABS_DBUS_PRS0_SYNCH2(0x0, 0x7)
#define PRS0_SYNCH2_PA8   SILABS_DBUS_PRS0_SYNCH2(0x0, 0x8)
#define PRS0_SYNCH2_PA9   SILABS_DBUS_PRS0_SYNCH2(0x0, 0x9)
#define PRS0_SYNCH2_PB0   SILABS_DBUS_PRS0_SYNCH2(0x1, 0x0)
#define PRS0_SYNCH2_PB1   SILABS_DBUS_PRS0_SYNCH2(0x1, 0x1)
#define PRS0_SYNCH2_PB2   SILABS_DBUS_PRS0_SYNCH2(0x1, 0x2)
#define PRS0_SYNCH2_PB3   SILABS_DBUS_PRS0_SYNCH2(0x1, 0x3)
#define PRS0_SYNCH2_PB4   SILABS_DBUS_PRS0_SYNCH2(0x1, 0x4)
#define PRS0_SYNCH2_PB5   SILABS_DBUS_PRS0_SYNCH2(0x1, 0x5)
#define PRS0_SYNCH2_PC0   SILABS_DBUS_PRS0_SYNCH2(0x2, 0x0)
#define PRS0_SYNCH2_PC1   SILABS_DBUS_PRS0_SYNCH2(0x2, 0x1)
#define PRS0_SYNCH2_PC2   SILABS_DBUS_PRS0_SYNCH2(0x2, 0x2)
#define PRS0_SYNCH2_PC3   SILABS_DBUS_PRS0_SYNCH2(0x2, 0x3)
#define PRS0_SYNCH2_PC4   SILABS_DBUS_PRS0_SYNCH2(0x2, 0x4)
#define PRS0_SYNCH2_PC5   SILABS_DBUS_PRS0_SYNCH2(0x2, 0x5)
#define PRS0_SYNCH2_PC6   SILABS_DBUS_PRS0_SYNCH2(0x2, 0x6)
#define PRS0_SYNCH2_PC7   SILABS_DBUS_PRS0_SYNCH2(0x2, 0x7)
#define PRS0_SYNCH2_PC8   SILABS_DBUS_PRS0_SYNCH2(0x2, 0x8)
#define PRS0_SYNCH2_PC9   SILABS_DBUS_PRS0_SYNCH2(0x2, 0x9)
#define PRS0_SYNCH2_PD0   SILABS_DBUS_PRS0_SYNCH2(0x3, 0x0)
#define PRS0_SYNCH2_PD1   SILABS_DBUS_PRS0_SYNCH2(0x3, 0x1)
#define PRS0_SYNCH2_PD2   SILABS_DBUS_PRS0_SYNCH2(0x3, 0x2)
#define PRS0_SYNCH2_PD3   SILABS_DBUS_PRS0_SYNCH2(0x3, 0x3)
#define PRS0_SYNCH2_PD4   SILABS_DBUS_PRS0_SYNCH2(0x3, 0x4)
#define PRS0_SYNCH2_PD5   SILABS_DBUS_PRS0_SYNCH2(0x3, 0x5)
#define PRS0_SYNCH3_PA0   SILABS_DBUS_PRS0_SYNCH3(0x0, 0x0)
#define PRS0_SYNCH3_PA1   SILABS_DBUS_PRS0_SYNCH3(0x0, 0x1)
#define PRS0_SYNCH3_PA2   SILABS_DBUS_PRS0_SYNCH3(0x0, 0x2)
#define PRS0_SYNCH3_PA3   SILABS_DBUS_PRS0_SYNCH3(0x0, 0x3)
#define PRS0_SYNCH3_PA4   SILABS_DBUS_PRS0_SYNCH3(0x0, 0x4)
#define PRS0_SYNCH3_PA5   SILABS_DBUS_PRS0_SYNCH3(0x0, 0x5)
#define PRS0_SYNCH3_PA6   SILABS_DBUS_PRS0_SYNCH3(0x0, 0x6)
#define PRS0_SYNCH3_PA7   SILABS_DBUS_PRS0_SYNCH3(0x0, 0x7)
#define PRS0_SYNCH3_PA8   SILABS_DBUS_PRS0_SYNCH3(0x0, 0x8)
#define PRS0_SYNCH3_PA9   SILABS_DBUS_PRS0_SYNCH3(0x0, 0x9)
#define PRS0_SYNCH3_PB0   SILABS_DBUS_PRS0_SYNCH3(0x1, 0x0)
#define PRS0_SYNCH3_PB1   SILABS_DBUS_PRS0_SYNCH3(0x1, 0x1)
#define PRS0_SYNCH3_PB2   SILABS_DBUS_PRS0_SYNCH3(0x1, 0x2)
#define PRS0_SYNCH3_PB3   SILABS_DBUS_PRS0_SYNCH3(0x1, 0x3)
#define PRS0_SYNCH3_PB4   SILABS_DBUS_PRS0_SYNCH3(0x1, 0x4)
#define PRS0_SYNCH3_PB5   SILABS_DBUS_PRS0_SYNCH3(0x1, 0x5)
#define PRS0_SYNCH3_PC0   SILABS_DBUS_PRS0_SYNCH3(0x2, 0x0)
#define PRS0_SYNCH3_PC1   SILABS_DBUS_PRS0_SYNCH3(0x2, 0x1)
#define PRS0_SYNCH3_PC2   SILABS_DBUS_PRS0_SYNCH3(0x2, 0x2)
#define PRS0_SYNCH3_PC3   SILABS_DBUS_PRS0_SYNCH3(0x2, 0x3)
#define PRS0_SYNCH3_PC4   SILABS_DBUS_PRS0_SYNCH3(0x2, 0x4)
#define PRS0_SYNCH3_PC5   SILABS_DBUS_PRS0_SYNCH3(0x2, 0x5)
#define PRS0_SYNCH3_PC6   SILABS_DBUS_PRS0_SYNCH3(0x2, 0x6)
#define PRS0_SYNCH3_PC7   SILABS_DBUS_PRS0_SYNCH3(0x2, 0x7)
#define PRS0_SYNCH3_PC8   SILABS_DBUS_PRS0_SYNCH3(0x2, 0x8)
#define PRS0_SYNCH3_PC9   SILABS_DBUS_PRS0_SYNCH3(0x2, 0x9)
#define PRS0_SYNCH3_PD0   SILABS_DBUS_PRS0_SYNCH3(0x3, 0x0)
#define PRS0_SYNCH3_PD1   SILABS_DBUS_PRS0_SYNCH3(0x3, 0x1)
#define PRS0_SYNCH3_PD2   SILABS_DBUS_PRS0_SYNCH3(0x3, 0x2)
#define PRS0_SYNCH3_PD3   SILABS_DBUS_PRS0_SYNCH3(0x3, 0x3)
#define PRS0_SYNCH3_PD4   SILABS_DBUS_PRS0_SYNCH3(0x3, 0x4)
#define PRS0_SYNCH3_PD5   SILABS_DBUS_PRS0_SYNCH3(0x3, 0x5)

#define HFXO0_BUFOUTREQINASYNC_PA0 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x0, 0x0)
#define HFXO0_BUFOUTREQINASYNC_PA1 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x0, 0x1)
#define HFXO0_BUFOUTREQINASYNC_PA2 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x0, 0x2)
#define HFXO0_BUFOUTREQINASYNC_PA3 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x0, 0x3)
#define HFXO0_BUFOUTREQINASYNC_PA4 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x0, 0x4)
#define HFXO0_BUFOUTREQINASYNC_PA5 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x0, 0x5)
#define HFXO0_BUFOUTREQINASYNC_PA6 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x0, 0x6)
#define HFXO0_BUFOUTREQINASYNC_PA7 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x0, 0x7)
#define HFXO0_BUFOUTREQINASYNC_PA8 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x0, 0x8)
#define HFXO0_BUFOUTREQINASYNC_PA9 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x0, 0x9)
#define HFXO0_BUFOUTREQINASYNC_PB0 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x1, 0x0)
#define HFXO0_BUFOUTREQINASYNC_PB1 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x1, 0x1)
#define HFXO0_BUFOUTREQINASYNC_PB2 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x1, 0x2)
#define HFXO0_BUFOUTREQINASYNC_PB3 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x1, 0x3)
#define HFXO0_BUFOUTREQINASYNC_PB4 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x1, 0x4)
#define HFXO0_BUFOUTREQINASYNC_PB5 SILABS_DBUS_HFXO0_BUFOUTREQINASYNC(0x1, 0x5)

#define TIMER0_CC0_PA0   SILABS_DBUS_TIMER0_CC0(0x0, 0x0)
#define TIMER0_CC0_PA1   SILABS_DBUS_TIMER0_CC0(0x0, 0x1)
#define TIMER0_CC0_PA2   SILABS_DBUS_TIMER0_CC0(0x0, 0x2)
#define TIMER0_CC0_PA3   SILABS_DBUS_TIMER0_CC0(0x0, 0x3)
#define TIMER0_CC0_PA4   SILABS_DBUS_TIMER0_CC0(0x0, 0x4)
#define TIMER0_CC0_PA5   SILABS_DBUS_TIMER0_CC0(0x0, 0x5)
#define TIMER0_CC0_PA6   SILABS_DBUS_TIMER0_CC0(0x0, 0x6)
#define TIMER0_CC0_PA7   SILABS_DBUS_TIMER0_CC0(0x0, 0x7)
#define TIMER0_CC0_PA8   SILABS_DBUS_TIMER0_CC0(0x0, 0x8)
#define TIMER0_CC0_PA9   SILABS_DBUS_TIMER0_CC0(0x0, 0x9)
#define TIMER0_CC0_PB0   SILABS_DBUS_TIMER0_CC0(0x1, 0x0)
#define TIMER0_CC0_PB1   SILABS_DBUS_TIMER0_CC0(0x1, 0x1)
#define TIMER0_CC0_PB2   SILABS_DBUS_TIMER0_CC0(0x1, 0x2)
#define TIMER0_CC0_PB3   SILABS_DBUS_TIMER0_CC0(0x1, 0x3)
#define TIMER0_CC0_PB4   SILABS_DBUS_TIMER0_CC0(0x1, 0x4)
#define TIMER0_CC0_PB5   SILABS_DBUS_TIMER0_CC0(0x1, 0x5)
#define TIMER0_CC0_PC0   SILABS_DBUS_TIMER0_CC0(0x2, 0x0)
#define TIMER0_CC0_PC1   SILABS_DBUS_TIMER0_CC0(0x2, 0x1)
#define TIMER0_CC0_PC2   SILABS_DBUS_TIMER0_CC0(0x2, 0x2)
#define TIMER0_CC0_PC3   SILABS_DBUS_TIMER0_CC0(0x2, 0x3)
#define TIMER0_CC0_PC4   SILABS_DBUS_TIMER0_CC0(0x2, 0x4)
#define TIMER0_CC0_PC5   SILABS_DBUS_TIMER0_CC0(0x2, 0x5)
#define TIMER0_CC0_PC6   SILABS_DBUS_TIMER0_CC0(0x2, 0x6)
#define TIMER0_CC0_PC7   SILABS_DBUS_TIMER0_CC0(0x2, 0x7)
#define TIMER0_CC0_PC8   SILABS_DBUS_TIMER0_CC0(0x2, 0x8)
#define TIMER0_CC0_PC9   SILABS_DBUS_TIMER0_CC0(0x2, 0x9)
#define TIMER0_CC0_PD0   SILABS_DBUS_TIMER0_CC0(0x3, 0x0)
#define TIMER0_CC0_PD1   SILABS_DBUS_TIMER0_CC0(0x3, 0x1)
#define TIMER0_CC0_PD2   SILABS_DBUS_TIMER0_CC0(0x3, 0x2)
#define TIMER0_CC0_PD3   SILABS_DBUS_TIMER0_CC0(0x3, 0x3)
#define TIMER0_CC0_PD4   SILABS_DBUS_TIMER0_CC0(0x3, 0x4)
#define TIMER0_CC0_PD5   SILABS_DBUS_TIMER0_CC0(0x3, 0x5)
#define TIMER0_CC1_PA0   SILABS_DBUS_TIMER0_CC1(0x0, 0x0)
#define TIMER0_CC1_PA1   SILABS_DBUS_TIMER0_CC1(0x0, 0x1)
#define TIMER0_CC1_PA2   SILABS_DBUS_TIMER0_CC1(0x0, 0x2)
#define TIMER0_CC1_PA3   SILABS_DBUS_TIMER0_CC1(0x0, 0x3)
#define TIMER0_CC1_PA4   SILABS_DBUS_TIMER0_CC1(0x0, 0x4)
#define TIMER0_CC1_PA5   SILABS_DBUS_TIMER0_CC1(0x0, 0x5)
#define TIMER0_CC1_PA6   SILABS_DBUS_TIMER0_CC1(0x0, 0x6)
#define TIMER0_CC1_PA7   SILABS_DBUS_TIMER0_CC1(0x0, 0x7)
#define TIMER0_CC1_PA8   SILABS_DBUS_TIMER0_CC1(0x0, 0x8)
#define TIMER0_CC1_PA9   SILABS_DBUS_TIMER0_CC1(0x0, 0x9)
#define TIMER0_CC1_PB0   SILABS_DBUS_TIMER0_CC1(0x1, 0x0)
#define TIMER0_CC1_PB1   SILABS_DBUS_TIMER0_CC1(0x1, 0x1)
#define TIMER0_CC1_PB2   SILABS_DBUS_TIMER0_CC1(0x1, 0x2)
#define TIMER0_CC1_PB3   SILABS_DBUS_TIMER0_CC1(0x1, 0x3)
#define TIMER0_CC1_PB4   SILABS_DBUS_TIMER0_CC1(0x1, 0x4)
#define TIMER0_CC1_PB5   SILABS_DBUS_TIMER0_CC1(0x1, 0x5)
#define TIMER0_CC1_PC0   SILABS_DBUS_TIMER0_CC1(0x2, 0x0)
#define TIMER0_CC1_PC1   SILABS_DBUS_TIMER0_CC1(0x2, 0x1)
#define TIMER0_CC1_PC2   SILABS_DBUS_TIMER0_CC1(0x2, 0x2)
#define TIMER0_CC1_PC3   SILABS_DBUS_TIMER0_CC1(0x2, 0x3)
#define TIMER0_CC1_PC4   SILABS_DBUS_TIMER0_CC1(0x2, 0x4)
#define TIMER0_CC1_PC5   SILABS_DBUS_TIMER0_CC1(0x2, 0x5)
#define TIMER0_CC1_PC6   SILABS_DBUS_TIMER0_CC1(0x2, 0x6)
#define TIMER0_CC1_PC7   SILABS_DBUS_TIMER0_CC1(0x2, 0x7)
#define TIMER0_CC1_PC8   SILABS_DBUS_TIMER0_CC1(0x2, 0x8)
#define TIMER0_CC1_PC9   SILABS_DBUS_TIMER0_CC1(0x2, 0x9)
#define TIMER0_CC1_PD0   SILABS_DBUS_TIMER0_CC1(0x3, 0x0)
#define TIMER0_CC1_PD1   SILABS_DBUS_TIMER0_CC1(0x3, 0x1)
#define TIMER0_CC1_PD2   SILABS_DBUS_TIMER0_CC1(0x3, 0x2)
#define TIMER0_CC1_PD3   SILABS_DBUS_TIMER0_CC1(0x3, 0x3)
#define TIMER0_CC1_PD4   SILABS_DBUS_TIMER0_CC1(0x3, 0x4)
#define TIMER0_CC1_PD5   SILABS_DBUS_TIMER0_CC1(0x3, 0x5)
#define TIMER0_CC2_PA0   SILABS_DBUS_TIMER0_CC2(0x0, 0x0)
#define TIMER0_CC2_PA1   SILABS_DBUS_TIMER0_CC2(0x0, 0x1)
#define TIMER0_CC2_PA2   SILABS_DBUS_TIMER0_CC2(0x0, 0x2)
#define TIMER0_CC2_PA3   SILABS_DBUS_TIMER0_CC2(0x0, 0x3)
#define TIMER0_CC2_PA4   SILABS_DBUS_TIMER0_CC2(0x0, 0x4)
#define TIMER0_CC2_PA5   SILABS_DBUS_TIMER0_CC2(0x0, 0x5)
#define TIMER0_CC2_PA6   SILABS_DBUS_TIMER0_CC2(0x0, 0x6)
#define TIMER0_CC2_PA7   SILABS_DBUS_TIMER0_CC2(0x0, 0x7)
#define TIMER0_CC2_PA8   SILABS_DBUS_TIMER0_CC2(0x0, 0x8)
#define TIMER0_CC2_PA9   SILABS_DBUS_TIMER0_CC2(0x0, 0x9)
#define TIMER0_CC2_PB0   SILABS_DBUS_TIMER0_CC2(0x1, 0x0)
#define TIMER0_CC2_PB1   SILABS_DBUS_TIMER0_CC2(0x1, 0x1)
#define TIMER0_CC2_PB2   SILABS_DBUS_TIMER0_CC2(0x1, 0x2)
#define TIMER0_CC2_PB3   SILABS_DBUS_TIMER0_CC2(0x1, 0x3)
#define TIMER0_CC2_PB4   SILABS_DBUS_TIMER0_CC2(0x1, 0x4)
#define TIMER0_CC2_PB5   SILABS_DBUS_TIMER0_CC2(0x1, 0x5)
#define TIMER0_CC2_PC0   SILABS_DBUS_TIMER0_CC2(0x2, 0x0)
#define TIMER0_CC2_PC1   SILABS_DBUS_TIMER0_CC2(0x2, 0x1)
#define TIMER0_CC2_PC2   SILABS_DBUS_TIMER0_CC2(0x2, 0x2)
#define TIMER0_CC2_PC3   SILABS_DBUS_TIMER0_CC2(0x2, 0x3)
#define TIMER0_CC2_PC4   SILABS_DBUS_TIMER0_CC2(0x2, 0x4)
#define TIMER0_CC2_PC5   SILABS_DBUS_TIMER0_CC2(0x2, 0x5)
#define TIMER0_CC2_PC6   SILABS_DBUS_TIMER0_CC2(0x2, 0x6)
#define TIMER0_CC2_PC7   SILABS_DBUS_TIMER0_CC2(0x2, 0x7)
#define TIMER0_CC2_PC8   SILABS_DBUS_TIMER0_CC2(0x2, 0x8)
#define TIMER0_CC2_PC9   SILABS_DBUS_TIMER0_CC2(0x2, 0x9)
#define TIMER0_CC2_PD0   SILABS_DBUS_TIMER0_CC2(0x3, 0x0)
#define TIMER0_CC2_PD1   SILABS_DBUS_TIMER0_CC2(0x3, 0x1)
#define TIMER0_CC2_PD2   SILABS_DBUS_TIMER0_CC2(0x3, 0x2)
#define TIMER0_CC2_PD3   SILABS_DBUS_TIMER0_CC2(0x3, 0x3)
#define TIMER0_CC2_PD4   SILABS_DBUS_TIMER0_CC2(0x3, 0x4)
#define TIMER0_CC2_PD5   SILABS_DBUS_TIMER0_CC2(0x3, 0x5)
#define TIMER0_CDTI0_PA0 SILABS_DBUS_TIMER0_CDTI0(0x0, 0x0)
#define TIMER0_CDTI0_PA1 SILABS_DBUS_TIMER0_CDTI0(0x0, 0x1)
#define TIMER0_CDTI0_PA2 SILABS_DBUS_TIMER0_CDTI0(0x0, 0x2)
#define TIMER0_CDTI0_PA3 SILABS_DBUS_TIMER0_CDTI0(0x0, 0x3)
#define TIMER0_CDTI0_PA4 SILABS_DBUS_TIMER0_CDTI0(0x0, 0x4)
#define TIMER0_CDTI0_PA5 SILABS_DBUS_TIMER0_CDTI0(0x0, 0x5)
#define TIMER0_CDTI0_PA6 SILABS_DBUS_TIMER0_CDTI0(0x0, 0x6)
#define TIMER0_CDTI0_PA7 SILABS_DBUS_TIMER0_CDTI0(0x0, 0x7)
#define TIMER0_CDTI0_PA8 SILABS_DBUS_TIMER0_CDTI0(0x0, 0x8)
#define TIMER0_CDTI0_PA9 SILABS_DBUS_TIMER0_CDTI0(0x0, 0x9)
#define TIMER0_CDTI0_PB0 SILABS_DBUS_TIMER0_CDTI0(0x1, 0x0)
#define TIMER0_CDTI0_PB1 SILABS_DBUS_TIMER0_CDTI0(0x1, 0x1)
#define TIMER0_CDTI0_PB2 SILABS_DBUS_TIMER0_CDTI0(0x1, 0x2)
#define TIMER0_CDTI0_PB3 SILABS_DBUS_TIMER0_CDTI0(0x1, 0x3)
#define TIMER0_CDTI0_PB4 SILABS_DBUS_TIMER0_CDTI0(0x1, 0x4)
#define TIMER0_CDTI0_PB5 SILABS_DBUS_TIMER0_CDTI0(0x1, 0x5)
#define TIMER0_CDTI0_PC0 SILABS_DBUS_TIMER0_CDTI0(0x2, 0x0)
#define TIMER0_CDTI0_PC1 SILABS_DBUS_TIMER0_CDTI0(0x2, 0x1)
#define TIMER0_CDTI0_PC2 SILABS_DBUS_TIMER0_CDTI0(0x2, 0x2)
#define TIMER0_CDTI0_PC3 SILABS_DBUS_TIMER0_CDTI0(0x2, 0x3)
#define TIMER0_CDTI0_PC4 SILABS_DBUS_TIMER0_CDTI0(0x2, 0x4)
#define TIMER0_CDTI0_PC5 SILABS_DBUS_TIMER0_CDTI0(0x2, 0x5)
#define TIMER0_CDTI0_PC6 SILABS_DBUS_TIMER0_CDTI0(0x2, 0x6)
#define TIMER0_CDTI0_PC7 SILABS_DBUS_TIMER0_CDTI0(0x2, 0x7)
#define TIMER0_CDTI0_PC8 SILABS_DBUS_TIMER0_CDTI0(0x2, 0x8)
#define TIMER0_CDTI0_PC9 SILABS_DBUS_TIMER0_CDTI0(0x2, 0x9)
#define TIMER0_CDTI0_PD0 SILABS_DBUS_TIMER0_CDTI0(0x3, 0x0)
#define TIMER0_CDTI0_PD1 SILABS_DBUS_TIMER0_CDTI0(0x3, 0x1)
#define TIMER0_CDTI0_PD2 SILABS_DBUS_TIMER0_CDTI0(0x3, 0x2)
#define TIMER0_CDTI0_PD3 SILABS_DBUS_TIMER0_CDTI0(0x3, 0x3)
#define TIMER0_CDTI0_PD4 SILABS_DBUS_TIMER0_CDTI0(0x3, 0x4)
#define TIMER0_CDTI0_PD5 SILABS_DBUS_TIMER0_CDTI0(0x3, 0x5)
#define TIMER0_CDTI1_PA0 SILABS_DBUS_TIMER0_CDTI1(0x0, 0x0)
#define TIMER0_CDTI1_PA1 SILABS_DBUS_TIMER0_CDTI1(0x0, 0x1)
#define TIMER0_CDTI1_PA2 SILABS_DBUS_TIMER0_CDTI1(0x0, 0x2)
#define TIMER0_CDTI1_PA3 SILABS_DBUS_TIMER0_CDTI1(0x0, 0x3)
#define TIMER0_CDTI1_PA4 SILABS_DBUS_TIMER0_CDTI1(0x0, 0x4)
#define TIMER0_CDTI1_PA5 SILABS_DBUS_TIMER0_CDTI1(0x0, 0x5)
#define TIMER0_CDTI1_PA6 SILABS_DBUS_TIMER0_CDTI1(0x0, 0x6)
#define TIMER0_CDTI1_PA7 SILABS_DBUS_TIMER0_CDTI1(0x0, 0x7)
#define TIMER0_CDTI1_PA8 SILABS_DBUS_TIMER0_CDTI1(0x0, 0x8)
#define TIMER0_CDTI1_PA9 SILABS_DBUS_TIMER0_CDTI1(0x0, 0x9)
#define TIMER0_CDTI1_PB0 SILABS_DBUS_TIMER0_CDTI1(0x1, 0x0)
#define TIMER0_CDTI1_PB1 SILABS_DBUS_TIMER0_CDTI1(0x1, 0x1)
#define TIMER0_CDTI1_PB2 SILABS_DBUS_TIMER0_CDTI1(0x1, 0x2)
#define TIMER0_CDTI1_PB3 SILABS_DBUS_TIMER0_CDTI1(0x1, 0x3)
#define TIMER0_CDTI1_PB4 SILABS_DBUS_TIMER0_CDTI1(0x1, 0x4)
#define TIMER0_CDTI1_PB5 SILABS_DBUS_TIMER0_CDTI1(0x1, 0x5)
#define TIMER0_CDTI1_PC0 SILABS_DBUS_TIMER0_CDTI1(0x2, 0x0)
#define TIMER0_CDTI1_PC1 SILABS_DBUS_TIMER0_CDTI1(0x2, 0x1)
#define TIMER0_CDTI1_PC2 SILABS_DBUS_TIMER0_CDTI1(0x2, 0x2)
#define TIMER0_CDTI1_PC3 SILABS_DBUS_TIMER0_CDTI1(0x2, 0x3)
#define TIMER0_CDTI1_PC4 SILABS_DBUS_TIMER0_CDTI1(0x2, 0x4)
#define TIMER0_CDTI1_PC5 SILABS_DBUS_TIMER0_CDTI1(0x2, 0x5)
#define TIMER0_CDTI1_PC6 SILABS_DBUS_TIMER0_CDTI1(0x2, 0x6)
#define TIMER0_CDTI1_PC7 SILABS_DBUS_TIMER0_CDTI1(0x2, 0x7)
#define TIMER0_CDTI1_PC8 SILABS_DBUS_TIMER0_CDTI1(0x2, 0x8)
#define TIMER0_CDTI1_PC9 SILABS_DBUS_TIMER0_CDTI1(0x2, 0x9)
#define TIMER0_CDTI1_PD0 SILABS_DBUS_TIMER0_CDTI1(0x3, 0x0)
#define TIMER0_CDTI1_PD1 SILABS_DBUS_TIMER0_CDTI1(0x3, 0x1)
#define TIMER0_CDTI1_PD2 SILABS_DBUS_TIMER0_CDTI1(0x3, 0x2)
#define TIMER0_CDTI1_PD3 SILABS_DBUS_TIMER0_CDTI1(0x3, 0x3)
#define TIMER0_CDTI1_PD4 SILABS_DBUS_TIMER0_CDTI1(0x3, 0x4)
#define TIMER0_CDTI1_PD5 SILABS_DBUS_TIMER0_CDTI1(0x3, 0x5)
#define TIMER0_CDTI2_PA0 SILABS_DBUS_TIMER0_CDTI2(0x0, 0x0)
#define TIMER0_CDTI2_PA1 SILABS_DBUS_TIMER0_CDTI2(0x0, 0x1)
#define TIMER0_CDTI2_PA2 SILABS_DBUS_TIMER0_CDTI2(0x0, 0x2)
#define TIMER0_CDTI2_PA3 SILABS_DBUS_TIMER0_CDTI2(0x0, 0x3)
#define TIMER0_CDTI2_PA4 SILABS_DBUS_TIMER0_CDTI2(0x0, 0x4)
#define TIMER0_CDTI2_PA5 SILABS_DBUS_TIMER0_CDTI2(0x0, 0x5)
#define TIMER0_CDTI2_PA6 SILABS_DBUS_TIMER0_CDTI2(0x0, 0x6)
#define TIMER0_CDTI2_PA7 SILABS_DBUS_TIMER0_CDTI2(0x0, 0x7)
#define TIMER0_CDTI2_PA8 SILABS_DBUS_TIMER0_CDTI2(0x0, 0x8)
#define TIMER0_CDTI2_PA9 SILABS_DBUS_TIMER0_CDTI2(0x0, 0x9)
#define TIMER0_CDTI2_PB0 SILABS_DBUS_TIMER0_CDTI2(0x1, 0x0)
#define TIMER0_CDTI2_PB1 SILABS_DBUS_TIMER0_CDTI2(0x1, 0x1)
#define TIMER0_CDTI2_PB2 SILABS_DBUS_TIMER0_CDTI2(0x1, 0x2)
#define TIMER0_CDTI2_PB3 SILABS_DBUS_TIMER0_CDTI2(0x1, 0x3)
#define TIMER0_CDTI2_PB4 SILABS_DBUS_TIMER0_CDTI2(0x1, 0x4)
#define TIMER0_CDTI2_PB5 SILABS_DBUS_TIMER0_CDTI2(0x1, 0x5)
#define TIMER0_CDTI2_PC0 SILABS_DBUS_TIMER0_CDTI2(0x2, 0x0)
#define TIMER0_CDTI2_PC1 SILABS_DBUS_TIMER0_CDTI2(0x2, 0x1)
#define TIMER0_CDTI2_PC2 SILABS_DBUS_TIMER0_CDTI2(0x2, 0x2)
#define TIMER0_CDTI2_PC3 SILABS_DBUS_TIMER0_CDTI2(0x2, 0x3)
#define TIMER0_CDTI2_PC4 SILABS_DBUS_TIMER0_CDTI2(0x2, 0x4)
#define TIMER0_CDTI2_PC5 SILABS_DBUS_TIMER0_CDTI2(0x2, 0x5)
#define TIMER0_CDTI2_PC6 SILABS_DBUS_TIMER0_CDTI2(0x2, 0x6)
#define TIMER0_CDTI2_PC7 SILABS_DBUS_TIMER0_CDTI2(0x2, 0x7)
#define TIMER0_CDTI2_PC8 SILABS_DBUS_TIMER0_CDTI2(0x2, 0x8)
#define TIMER0_CDTI2_PC9 SILABS_DBUS_TIMER0_CDTI2(0x2, 0x9)
#define TIMER0_CDTI2_PD0 SILABS_DBUS_TIMER0_CDTI2(0x3, 0x0)
#define TIMER0_CDTI2_PD1 SILABS_DBUS_TIMER0_CDTI2(0x3, 0x1)
#define TIMER0_CDTI2_PD2 SILABS_DBUS_TIMER0_CDTI2(0x3, 0x2)
#define TIMER0_CDTI2_PD3 SILABS_DBUS_TIMER0_CDTI2(0x3, 0x3)
#define TIMER0_CDTI2_PD4 SILABS_DBUS_TIMER0_CDTI2(0x3, 0x4)
#define TIMER0_CDTI2_PD5 SILABS_DBUS_TIMER0_CDTI2(0x3, 0x5)

#define TIMER1_CC0_PA0   SILABS_DBUS_TIMER1_CC0(0x0, 0x0)
#define TIMER1_CC0_PA1   SILABS_DBUS_TIMER1_CC0(0x0, 0x1)
#define TIMER1_CC0_PA2   SILABS_DBUS_TIMER1_CC0(0x0, 0x2)
#define TIMER1_CC0_PA3   SILABS_DBUS_TIMER1_CC0(0x0, 0x3)
#define TIMER1_CC0_PA4   SILABS_DBUS_TIMER1_CC0(0x0, 0x4)
#define TIMER1_CC0_PA5   SILABS_DBUS_TIMER1_CC0(0x0, 0x5)
#define TIMER1_CC0_PA6   SILABS_DBUS_TIMER1_CC0(0x0, 0x6)
#define TIMER1_CC0_PA7   SILABS_DBUS_TIMER1_CC0(0x0, 0x7)
#define TIMER1_CC0_PA8   SILABS_DBUS_TIMER1_CC0(0x0, 0x8)
#define TIMER1_CC0_PA9   SILABS_DBUS_TIMER1_CC0(0x0, 0x9)
#define TIMER1_CC0_PB0   SILABS_DBUS_TIMER1_CC0(0x1, 0x0)
#define TIMER1_CC0_PB1   SILABS_DBUS_TIMER1_CC0(0x1, 0x1)
#define TIMER1_CC0_PB2   SILABS_DBUS_TIMER1_CC0(0x1, 0x2)
#define TIMER1_CC0_PB3   SILABS_DBUS_TIMER1_CC0(0x1, 0x3)
#define TIMER1_CC0_PB4   SILABS_DBUS_TIMER1_CC0(0x1, 0x4)
#define TIMER1_CC0_PB5   SILABS_DBUS_TIMER1_CC0(0x1, 0x5)
#define TIMER1_CC0_PC0   SILABS_DBUS_TIMER1_CC0(0x2, 0x0)
#define TIMER1_CC0_PC1   SILABS_DBUS_TIMER1_CC0(0x2, 0x1)
#define TIMER1_CC0_PC2   SILABS_DBUS_TIMER1_CC0(0x2, 0x2)
#define TIMER1_CC0_PC3   SILABS_DBUS_TIMER1_CC0(0x2, 0x3)
#define TIMER1_CC0_PC4   SILABS_DBUS_TIMER1_CC0(0x2, 0x4)
#define TIMER1_CC0_PC5   SILABS_DBUS_TIMER1_CC0(0x2, 0x5)
#define TIMER1_CC0_PC6   SILABS_DBUS_TIMER1_CC0(0x2, 0x6)
#define TIMER1_CC0_PC7   SILABS_DBUS_TIMER1_CC0(0x2, 0x7)
#define TIMER1_CC0_PC8   SILABS_DBUS_TIMER1_CC0(0x2, 0x8)
#define TIMER1_CC0_PC9   SILABS_DBUS_TIMER1_CC0(0x2, 0x9)
#define TIMER1_CC0_PD0   SILABS_DBUS_TIMER1_CC0(0x3, 0x0)
#define TIMER1_CC0_PD1   SILABS_DBUS_TIMER1_CC0(0x3, 0x1)
#define TIMER1_CC0_PD2   SILABS_DBUS_TIMER1_CC0(0x3, 0x2)
#define TIMER1_CC0_PD3   SILABS_DBUS_TIMER1_CC0(0x3, 0x3)
#define TIMER1_CC0_PD4   SILABS_DBUS_TIMER1_CC0(0x3, 0x4)
#define TIMER1_CC0_PD5   SILABS_DBUS_TIMER1_CC0(0x3, 0x5)
#define TIMER1_CC1_PA0   SILABS_DBUS_TIMER1_CC1(0x0, 0x0)
#define TIMER1_CC1_PA1   SILABS_DBUS_TIMER1_CC1(0x0, 0x1)
#define TIMER1_CC1_PA2   SILABS_DBUS_TIMER1_CC1(0x0, 0x2)
#define TIMER1_CC1_PA3   SILABS_DBUS_TIMER1_CC1(0x0, 0x3)
#define TIMER1_CC1_PA4   SILABS_DBUS_TIMER1_CC1(0x0, 0x4)
#define TIMER1_CC1_PA5   SILABS_DBUS_TIMER1_CC1(0x0, 0x5)
#define TIMER1_CC1_PA6   SILABS_DBUS_TIMER1_CC1(0x0, 0x6)
#define TIMER1_CC1_PA7   SILABS_DBUS_TIMER1_CC1(0x0, 0x7)
#define TIMER1_CC1_PA8   SILABS_DBUS_TIMER1_CC1(0x0, 0x8)
#define TIMER1_CC1_PA9   SILABS_DBUS_TIMER1_CC1(0x0, 0x9)
#define TIMER1_CC1_PB0   SILABS_DBUS_TIMER1_CC1(0x1, 0x0)
#define TIMER1_CC1_PB1   SILABS_DBUS_TIMER1_CC1(0x1, 0x1)
#define TIMER1_CC1_PB2   SILABS_DBUS_TIMER1_CC1(0x1, 0x2)
#define TIMER1_CC1_PB3   SILABS_DBUS_TIMER1_CC1(0x1, 0x3)
#define TIMER1_CC1_PB4   SILABS_DBUS_TIMER1_CC1(0x1, 0x4)
#define TIMER1_CC1_PB5   SILABS_DBUS_TIMER1_CC1(0x1, 0x5)
#define TIMER1_CC1_PC0   SILABS_DBUS_TIMER1_CC1(0x2, 0x0)
#define TIMER1_CC1_PC1   SILABS_DBUS_TIMER1_CC1(0x2, 0x1)
#define TIMER1_CC1_PC2   SILABS_DBUS_TIMER1_CC1(0x2, 0x2)
#define TIMER1_CC1_PC3   SILABS_DBUS_TIMER1_CC1(0x2, 0x3)
#define TIMER1_CC1_PC4   SILABS_DBUS_TIMER1_CC1(0x2, 0x4)
#define TIMER1_CC1_PC5   SILABS_DBUS_TIMER1_CC1(0x2, 0x5)
#define TIMER1_CC1_PC6   SILABS_DBUS_TIMER1_CC1(0x2, 0x6)
#define TIMER1_CC1_PC7   SILABS_DBUS_TIMER1_CC1(0x2, 0x7)
#define TIMER1_CC1_PC8   SILABS_DBUS_TIMER1_CC1(0x2, 0x8)
#define TIMER1_CC1_PC9   SILABS_DBUS_TIMER1_CC1(0x2, 0x9)
#define TIMER1_CC1_PD0   SILABS_DBUS_TIMER1_CC1(0x3, 0x0)
#define TIMER1_CC1_PD1   SILABS_DBUS_TIMER1_CC1(0x3, 0x1)
#define TIMER1_CC1_PD2   SILABS_DBUS_TIMER1_CC1(0x3, 0x2)
#define TIMER1_CC1_PD3   SILABS_DBUS_TIMER1_CC1(0x3, 0x3)
#define TIMER1_CC1_PD4   SILABS_DBUS_TIMER1_CC1(0x3, 0x4)
#define TIMER1_CC1_PD5   SILABS_DBUS_TIMER1_CC1(0x3, 0x5)
#define TIMER1_CC2_PA0   SILABS_DBUS_TIMER1_CC2(0x0, 0x0)
#define TIMER1_CC2_PA1   SILABS_DBUS_TIMER1_CC2(0x0, 0x1)
#define TIMER1_CC2_PA2   SILABS_DBUS_TIMER1_CC2(0x0, 0x2)
#define TIMER1_CC2_PA3   SILABS_DBUS_TIMER1_CC2(0x0, 0x3)
#define TIMER1_CC2_PA4   SILABS_DBUS_TIMER1_CC2(0x0, 0x4)
#define TIMER1_CC2_PA5   SILABS_DBUS_TIMER1_CC2(0x0, 0x5)
#define TIMER1_CC2_PA6   SILABS_DBUS_TIMER1_CC2(0x0, 0x6)
#define TIMER1_CC2_PA7   SILABS_DBUS_TIMER1_CC2(0x0, 0x7)
#define TIMER1_CC2_PA8   SILABS_DBUS_TIMER1_CC2(0x0, 0x8)
#define TIMER1_CC2_PA9   SILABS_DBUS_TIMER1_CC2(0x0, 0x9)
#define TIMER1_CC2_PB0   SILABS_DBUS_TIMER1_CC2(0x1, 0x0)
#define TIMER1_CC2_PB1   SILABS_DBUS_TIMER1_CC2(0x1, 0x1)
#define TIMER1_CC2_PB2   SILABS_DBUS_TIMER1_CC2(0x1, 0x2)
#define TIMER1_CC2_PB3   SILABS_DBUS_TIMER1_CC2(0x1, 0x3)
#define TIMER1_CC2_PB4   SILABS_DBUS_TIMER1_CC2(0x1, 0x4)
#define TIMER1_CC2_PB5   SILABS_DBUS_TIMER1_CC2(0x1, 0x5)
#define TIMER1_CC2_PC0   SILABS_DBUS_TIMER1_CC2(0x2, 0x0)
#define TIMER1_CC2_PC1   SILABS_DBUS_TIMER1_CC2(0x2, 0x1)
#define TIMER1_CC2_PC2   SILABS_DBUS_TIMER1_CC2(0x2, 0x2)
#define TIMER1_CC2_PC3   SILABS_DBUS_TIMER1_CC2(0x2, 0x3)
#define TIMER1_CC2_PC4   SILABS_DBUS_TIMER1_CC2(0x2, 0x4)
#define TIMER1_CC2_PC5   SILABS_DBUS_TIMER1_CC2(0x2, 0x5)
#define TIMER1_CC2_PC6   SILABS_DBUS_TIMER1_CC2(0x2, 0x6)
#define TIMER1_CC2_PC7   SILABS_DBUS_TIMER1_CC2(0x2, 0x7)
#define TIMER1_CC2_PC8   SILABS_DBUS_TIMER1_CC2(0x2, 0x8)
#define TIMER1_CC2_PC9   SILABS_DBUS_TIMER1_CC2(0x2, 0x9)
#define TIMER1_CC2_PD0   SILABS_DBUS_TIMER1_CC2(0x3, 0x0)
#define TIMER1_CC2_PD1   SILABS_DBUS_TIMER1_CC2(0x3, 0x1)
#define TIMER1_CC2_PD2   SILABS_DBUS_TIMER1_CC2(0x3, 0x2)
#define TIMER1_CC2_PD3   SILABS_DBUS_TIMER1_CC2(0x3, 0x3)
#define TIMER1_CC2_PD4   SILABS_DBUS_TIMER1_CC2(0x3, 0x4)
#define TIMER1_CC2_PD5   SILABS_DBUS_TIMER1_CC2(0x3, 0x5)
#define TIMER1_CDTI0_PA0 SILABS_DBUS_TIMER1_CDTI0(0x0, 0x0)
#define TIMER1_CDTI0_PA1 SILABS_DBUS_TIMER1_CDTI0(0x0, 0x1)
#define TIMER1_CDTI0_PA2 SILABS_DBUS_TIMER1_CDTI0(0x0, 0x2)
#define TIMER1_CDTI0_PA3 SILABS_DBUS_TIMER1_CDTI0(0x0, 0x3)
#define TIMER1_CDTI0_PA4 SILABS_DBUS_TIMER1_CDTI0(0x0, 0x4)
#define TIMER1_CDTI0_PA5 SILABS_DBUS_TIMER1_CDTI0(0x0, 0x5)
#define TIMER1_CDTI0_PA6 SILABS_DBUS_TIMER1_CDTI0(0x0, 0x6)
#define TIMER1_CDTI0_PA7 SILABS_DBUS_TIMER1_CDTI0(0x0, 0x7)
#define TIMER1_CDTI0_PA8 SILABS_DBUS_TIMER1_CDTI0(0x0, 0x8)
#define TIMER1_CDTI0_PA9 SILABS_DBUS_TIMER1_CDTI0(0x0, 0x9)
#define TIMER1_CDTI0_PB0 SILABS_DBUS_TIMER1_CDTI0(0x1, 0x0)
#define TIMER1_CDTI0_PB1 SILABS_DBUS_TIMER1_CDTI0(0x1, 0x1)
#define TIMER1_CDTI0_PB2 SILABS_DBUS_TIMER1_CDTI0(0x1, 0x2)
#define TIMER1_CDTI0_PB3 SILABS_DBUS_TIMER1_CDTI0(0x1, 0x3)
#define TIMER1_CDTI0_PB4 SILABS_DBUS_TIMER1_CDTI0(0x1, 0x4)
#define TIMER1_CDTI0_PB5 SILABS_DBUS_TIMER1_CDTI0(0x1, 0x5)
#define TIMER1_CDTI0_PC0 SILABS_DBUS_TIMER1_CDTI0(0x2, 0x0)
#define TIMER1_CDTI0_PC1 SILABS_DBUS_TIMER1_CDTI0(0x2, 0x1)
#define TIMER1_CDTI0_PC2 SILABS_DBUS_TIMER1_CDTI0(0x2, 0x2)
#define TIMER1_CDTI0_PC3 SILABS_DBUS_TIMER1_CDTI0(0x2, 0x3)
#define TIMER1_CDTI0_PC4 SILABS_DBUS_TIMER1_CDTI0(0x2, 0x4)
#define TIMER1_CDTI0_PC5 SILABS_DBUS_TIMER1_CDTI0(0x2, 0x5)
#define TIMER1_CDTI0_PC6 SILABS_DBUS_TIMER1_CDTI0(0x2, 0x6)
#define TIMER1_CDTI0_PC7 SILABS_DBUS_TIMER1_CDTI0(0x2, 0x7)
#define TIMER1_CDTI0_PC8 SILABS_DBUS_TIMER1_CDTI0(0x2, 0x8)
#define TIMER1_CDTI0_PC9 SILABS_DBUS_TIMER1_CDTI0(0x2, 0x9)
#define TIMER1_CDTI0_PD0 SILABS_DBUS_TIMER1_CDTI0(0x3, 0x0)
#define TIMER1_CDTI0_PD1 SILABS_DBUS_TIMER1_CDTI0(0x3, 0x1)
#define TIMER1_CDTI0_PD2 SILABS_DBUS_TIMER1_CDTI0(0x3, 0x2)
#define TIMER1_CDTI0_PD3 SILABS_DBUS_TIMER1_CDTI0(0x3, 0x3)
#define TIMER1_CDTI0_PD4 SILABS_DBUS_TIMER1_CDTI0(0x3, 0x4)
#define TIMER1_CDTI0_PD5 SILABS_DBUS_TIMER1_CDTI0(0x3, 0x5)
#define TIMER1_CDTI1_PA0 SILABS_DBUS_TIMER1_CDTI1(0x0, 0x0)
#define TIMER1_CDTI1_PA1 SILABS_DBUS_TIMER1_CDTI1(0x0, 0x1)
#define TIMER1_CDTI1_PA2 SILABS_DBUS_TIMER1_CDTI1(0x0, 0x2)
#define TIMER1_CDTI1_PA3 SILABS_DBUS_TIMER1_CDTI1(0x0, 0x3)
#define TIMER1_CDTI1_PA4 SILABS_DBUS_TIMER1_CDTI1(0x0, 0x4)
#define TIMER1_CDTI1_PA5 SILABS_DBUS_TIMER1_CDTI1(0x0, 0x5)
#define TIMER1_CDTI1_PA6 SILABS_DBUS_TIMER1_CDTI1(0x0, 0x6)
#define TIMER1_CDTI1_PA7 SILABS_DBUS_TIMER1_CDTI1(0x0, 0x7)
#define TIMER1_CDTI1_PA8 SILABS_DBUS_TIMER1_CDTI1(0x0, 0x8)
#define TIMER1_CDTI1_PA9 SILABS_DBUS_TIMER1_CDTI1(0x0, 0x9)
#define TIMER1_CDTI1_PB0 SILABS_DBUS_TIMER1_CDTI1(0x1, 0x0)
#define TIMER1_CDTI1_PB1 SILABS_DBUS_TIMER1_CDTI1(0x1, 0x1)
#define TIMER1_CDTI1_PB2 SILABS_DBUS_TIMER1_CDTI1(0x1, 0x2)
#define TIMER1_CDTI1_PB3 SILABS_DBUS_TIMER1_CDTI1(0x1, 0x3)
#define TIMER1_CDTI1_PB4 SILABS_DBUS_TIMER1_CDTI1(0x1, 0x4)
#define TIMER1_CDTI1_PB5 SILABS_DBUS_TIMER1_CDTI1(0x1, 0x5)
#define TIMER1_CDTI1_PC0 SILABS_DBUS_TIMER1_CDTI1(0x2, 0x0)
#define TIMER1_CDTI1_PC1 SILABS_DBUS_TIMER1_CDTI1(0x2, 0x1)
#define TIMER1_CDTI1_PC2 SILABS_DBUS_TIMER1_CDTI1(0x2, 0x2)
#define TIMER1_CDTI1_PC3 SILABS_DBUS_TIMER1_CDTI1(0x2, 0x3)
#define TIMER1_CDTI1_PC4 SILABS_DBUS_TIMER1_CDTI1(0x2, 0x4)
#define TIMER1_CDTI1_PC5 SILABS_DBUS_TIMER1_CDTI1(0x2, 0x5)
#define TIMER1_CDTI1_PC6 SILABS_DBUS_TIMER1_CDTI1(0x2, 0x6)
#define TIMER1_CDTI1_PC7 SILABS_DBUS_TIMER1_CDTI1(0x2, 0x7)
#define TIMER1_CDTI1_PC8 SILABS_DBUS_TIMER1_CDTI1(0x2, 0x8)
#define TIMER1_CDTI1_PC9 SILABS_DBUS_TIMER1_CDTI1(0x2, 0x9)
#define TIMER1_CDTI1_PD0 SILABS_DBUS_TIMER1_CDTI1(0x3, 0x0)
#define TIMER1_CDTI1_PD1 SILABS_DBUS_TIMER1_CDTI1(0x3, 0x1)
#define TIMER1_CDTI1_PD2 SILABS_DBUS_TIMER1_CDTI1(0x3, 0x2)
#define TIMER1_CDTI1_PD3 SILABS_DBUS_TIMER1_CDTI1(0x3, 0x3)
#define TIMER1_CDTI1_PD4 SILABS_DBUS_TIMER1_CDTI1(0x3, 0x4)
#define TIMER1_CDTI1_PD5 SILABS_DBUS_TIMER1_CDTI1(0x3, 0x5)
#define TIMER1_CDTI2_PA0 SILABS_DBUS_TIMER1_CDTI2(0x0, 0x0)
#define TIMER1_CDTI2_PA1 SILABS_DBUS_TIMER1_CDTI2(0x0, 0x1)
#define TIMER1_CDTI2_PA2 SILABS_DBUS_TIMER1_CDTI2(0x0, 0x2)
#define TIMER1_CDTI2_PA3 SILABS_DBUS_TIMER1_CDTI2(0x0, 0x3)
#define TIMER1_CDTI2_PA4 SILABS_DBUS_TIMER1_CDTI2(0x0, 0x4)
#define TIMER1_CDTI2_PA5 SILABS_DBUS_TIMER1_CDTI2(0x0, 0x5)
#define TIMER1_CDTI2_PA6 SILABS_DBUS_TIMER1_CDTI2(0x0, 0x6)
#define TIMER1_CDTI2_PA7 SILABS_DBUS_TIMER1_CDTI2(0x0, 0x7)
#define TIMER1_CDTI2_PA8 SILABS_DBUS_TIMER1_CDTI2(0x0, 0x8)
#define TIMER1_CDTI2_PA9 SILABS_DBUS_TIMER1_CDTI2(0x0, 0x9)
#define TIMER1_CDTI2_PB0 SILABS_DBUS_TIMER1_CDTI2(0x1, 0x0)
#define TIMER1_CDTI2_PB1 SILABS_DBUS_TIMER1_CDTI2(0x1, 0x1)
#define TIMER1_CDTI2_PB2 SILABS_DBUS_TIMER1_CDTI2(0x1, 0x2)
#define TIMER1_CDTI2_PB3 SILABS_DBUS_TIMER1_CDTI2(0x1, 0x3)
#define TIMER1_CDTI2_PB4 SILABS_DBUS_TIMER1_CDTI2(0x1, 0x4)
#define TIMER1_CDTI2_PB5 SILABS_DBUS_TIMER1_CDTI2(0x1, 0x5)
#define TIMER1_CDTI2_PC0 SILABS_DBUS_TIMER1_CDTI2(0x2, 0x0)
#define TIMER1_CDTI2_PC1 SILABS_DBUS_TIMER1_CDTI2(0x2, 0x1)
#define TIMER1_CDTI2_PC2 SILABS_DBUS_TIMER1_CDTI2(0x2, 0x2)
#define TIMER1_CDTI2_PC3 SILABS_DBUS_TIMER1_CDTI2(0x2, 0x3)
#define TIMER1_CDTI2_PC4 SILABS_DBUS_TIMER1_CDTI2(0x2, 0x4)
#define TIMER1_CDTI2_PC5 SILABS_DBUS_TIMER1_CDTI2(0x2, 0x5)
#define TIMER1_CDTI2_PC6 SILABS_DBUS_TIMER1_CDTI2(0x2, 0x6)
#define TIMER1_CDTI2_PC7 SILABS_DBUS_TIMER1_CDTI2(0x2, 0x7)
#define TIMER1_CDTI2_PC8 SILABS_DBUS_TIMER1_CDTI2(0x2, 0x8)
#define TIMER1_CDTI2_PC9 SILABS_DBUS_TIMER1_CDTI2(0x2, 0x9)
#define TIMER1_CDTI2_PD0 SILABS_DBUS_TIMER1_CDTI2(0x3, 0x0)
#define TIMER1_CDTI2_PD1 SILABS_DBUS_TIMER1_CDTI2(0x3, 0x1)
#define TIMER1_CDTI2_PD2 SILABS_DBUS_TIMER1_CDTI2(0x3, 0x2)
#define TIMER1_CDTI2_PD3 SILABS_DBUS_TIMER1_CDTI2(0x3, 0x3)
#define TIMER1_CDTI2_PD4 SILABS_DBUS_TIMER1_CDTI2(0x3, 0x4)
#define TIMER1_CDTI2_PD5 SILABS_DBUS_TIMER1_CDTI2(0x3, 0x5)

#define TIMER2_CC0_PA0   SILABS_DBUS_TIMER2_CC0(0x0, 0x0)
#define TIMER2_CC0_PA1   SILABS_DBUS_TIMER2_CC0(0x0, 0x1)
#define TIMER2_CC0_PA2   SILABS_DBUS_TIMER2_CC0(0x0, 0x2)
#define TIMER2_CC0_PA3   SILABS_DBUS_TIMER2_CC0(0x0, 0x3)
#define TIMER2_CC0_PA4   SILABS_DBUS_TIMER2_CC0(0x0, 0x4)
#define TIMER2_CC0_PA5   SILABS_DBUS_TIMER2_CC0(0x0, 0x5)
#define TIMER2_CC0_PA6   SILABS_DBUS_TIMER2_CC0(0x0, 0x6)
#define TIMER2_CC0_PA7   SILABS_DBUS_TIMER2_CC0(0x0, 0x7)
#define TIMER2_CC0_PA8   SILABS_DBUS_TIMER2_CC0(0x0, 0x8)
#define TIMER2_CC0_PA9   SILABS_DBUS_TIMER2_CC0(0x0, 0x9)
#define TIMER2_CC0_PB0   SILABS_DBUS_TIMER2_CC0(0x1, 0x0)
#define TIMER2_CC0_PB1   SILABS_DBUS_TIMER2_CC0(0x1, 0x1)
#define TIMER2_CC0_PB2   SILABS_DBUS_TIMER2_CC0(0x1, 0x2)
#define TIMER2_CC0_PB3   SILABS_DBUS_TIMER2_CC0(0x1, 0x3)
#define TIMER2_CC0_PB4   SILABS_DBUS_TIMER2_CC0(0x1, 0x4)
#define TIMER2_CC0_PB5   SILABS_DBUS_TIMER2_CC0(0x1, 0x5)
#define TIMER2_CC1_PA0   SILABS_DBUS_TIMER2_CC1(0x0, 0x0)
#define TIMER2_CC1_PA1   SILABS_DBUS_TIMER2_CC1(0x0, 0x1)
#define TIMER2_CC1_PA2   SILABS_DBUS_TIMER2_CC1(0x0, 0x2)
#define TIMER2_CC1_PA3   SILABS_DBUS_TIMER2_CC1(0x0, 0x3)
#define TIMER2_CC1_PA4   SILABS_DBUS_TIMER2_CC1(0x0, 0x4)
#define TIMER2_CC1_PA5   SILABS_DBUS_TIMER2_CC1(0x0, 0x5)
#define TIMER2_CC1_PA6   SILABS_DBUS_TIMER2_CC1(0x0, 0x6)
#define TIMER2_CC1_PA7   SILABS_DBUS_TIMER2_CC1(0x0, 0x7)
#define TIMER2_CC1_PA8   SILABS_DBUS_TIMER2_CC1(0x0, 0x8)
#define TIMER2_CC1_PA9   SILABS_DBUS_TIMER2_CC1(0x0, 0x9)
#define TIMER2_CC1_PB0   SILABS_DBUS_TIMER2_CC1(0x1, 0x0)
#define TIMER2_CC1_PB1   SILABS_DBUS_TIMER2_CC1(0x1, 0x1)
#define TIMER2_CC1_PB2   SILABS_DBUS_TIMER2_CC1(0x1, 0x2)
#define TIMER2_CC1_PB3   SILABS_DBUS_TIMER2_CC1(0x1, 0x3)
#define TIMER2_CC1_PB4   SILABS_DBUS_TIMER2_CC1(0x1, 0x4)
#define TIMER2_CC1_PB5   SILABS_DBUS_TIMER2_CC1(0x1, 0x5)
#define TIMER2_CC2_PA0   SILABS_DBUS_TIMER2_CC2(0x0, 0x0)
#define TIMER2_CC2_PA1   SILABS_DBUS_TIMER2_CC2(0x0, 0x1)
#define TIMER2_CC2_PA2   SILABS_DBUS_TIMER2_CC2(0x0, 0x2)
#define TIMER2_CC2_PA3   SILABS_DBUS_TIMER2_CC2(0x0, 0x3)
#define TIMER2_CC2_PA4   SILABS_DBUS_TIMER2_CC2(0x0, 0x4)
#define TIMER2_CC2_PA5   SILABS_DBUS_TIMER2_CC2(0x0, 0x5)
#define TIMER2_CC2_PA6   SILABS_DBUS_TIMER2_CC2(0x0, 0x6)
#define TIMER2_CC2_PA7   SILABS_DBUS_TIMER2_CC2(0x0, 0x7)
#define TIMER2_CC2_PA8   SILABS_DBUS_TIMER2_CC2(0x0, 0x8)
#define TIMER2_CC2_PA9   SILABS_DBUS_TIMER2_CC2(0x0, 0x9)
#define TIMER2_CC2_PB0   SILABS_DBUS_TIMER2_CC2(0x1, 0x0)
#define TIMER2_CC2_PB1   SILABS_DBUS_TIMER2_CC2(0x1, 0x1)
#define TIMER2_CC2_PB2   SILABS_DBUS_TIMER2_CC2(0x1, 0x2)
#define TIMER2_CC2_PB3   SILABS_DBUS_TIMER2_CC2(0x1, 0x3)
#define TIMER2_CC2_PB4   SILABS_DBUS_TIMER2_CC2(0x1, 0x4)
#define TIMER2_CC2_PB5   SILABS_DBUS_TIMER2_CC2(0x1, 0x5)
#define TIMER2_CDTI0_PA0 SILABS_DBUS_TIMER2_CDTI0(0x0, 0x0)
#define TIMER2_CDTI0_PA1 SILABS_DBUS_TIMER2_CDTI0(0x0, 0x1)
#define TIMER2_CDTI0_PA2 SILABS_DBUS_TIMER2_CDTI0(0x0, 0x2)
#define TIMER2_CDTI0_PA3 SILABS_DBUS_TIMER2_CDTI0(0x0, 0x3)
#define TIMER2_CDTI0_PA4 SILABS_DBUS_TIMER2_CDTI0(0x0, 0x4)
#define TIMER2_CDTI0_PA5 SILABS_DBUS_TIMER2_CDTI0(0x0, 0x5)
#define TIMER2_CDTI0_PA6 SILABS_DBUS_TIMER2_CDTI0(0x0, 0x6)
#define TIMER2_CDTI0_PA7 SILABS_DBUS_TIMER2_CDTI0(0x0, 0x7)
#define TIMER2_CDTI0_PA8 SILABS_DBUS_TIMER2_CDTI0(0x0, 0x8)
#define TIMER2_CDTI0_PA9 SILABS_DBUS_TIMER2_CDTI0(0x0, 0x9)
#define TIMER2_CDTI0_PB0 SILABS_DBUS_TIMER2_CDTI0(0x1, 0x0)
#define TIMER2_CDTI0_PB1 SILABS_DBUS_TIMER2_CDTI0(0x1, 0x1)
#define TIMER2_CDTI0_PB2 SILABS_DBUS_TIMER2_CDTI0(0x1, 0x2)
#define TIMER2_CDTI0_PB3 SILABS_DBUS_TIMER2_CDTI0(0x1, 0x3)
#define TIMER2_CDTI0_PB4 SILABS_DBUS_TIMER2_CDTI0(0x1, 0x4)
#define TIMER2_CDTI0_PB5 SILABS_DBUS_TIMER2_CDTI0(0x1, 0x5)
#define TIMER2_CDTI1_PA0 SILABS_DBUS_TIMER2_CDTI1(0x0, 0x0)
#define TIMER2_CDTI1_PA1 SILABS_DBUS_TIMER2_CDTI1(0x0, 0x1)
#define TIMER2_CDTI1_PA2 SILABS_DBUS_TIMER2_CDTI1(0x0, 0x2)
#define TIMER2_CDTI1_PA3 SILABS_DBUS_TIMER2_CDTI1(0x0, 0x3)
#define TIMER2_CDTI1_PA4 SILABS_DBUS_TIMER2_CDTI1(0x0, 0x4)
#define TIMER2_CDTI1_PA5 SILABS_DBUS_TIMER2_CDTI1(0x0, 0x5)
#define TIMER2_CDTI1_PA6 SILABS_DBUS_TIMER2_CDTI1(0x0, 0x6)
#define TIMER2_CDTI1_PA7 SILABS_DBUS_TIMER2_CDTI1(0x0, 0x7)
#define TIMER2_CDTI1_PA8 SILABS_DBUS_TIMER2_CDTI1(0x0, 0x8)
#define TIMER2_CDTI1_PA9 SILABS_DBUS_TIMER2_CDTI1(0x0, 0x9)
#define TIMER2_CDTI1_PB0 SILABS_DBUS_TIMER2_CDTI1(0x1, 0x0)
#define TIMER2_CDTI1_PB1 SILABS_DBUS_TIMER2_CDTI1(0x1, 0x1)
#define TIMER2_CDTI1_PB2 SILABS_DBUS_TIMER2_CDTI1(0x1, 0x2)
#define TIMER2_CDTI1_PB3 SILABS_DBUS_TIMER2_CDTI1(0x1, 0x3)
#define TIMER2_CDTI1_PB4 SILABS_DBUS_TIMER2_CDTI1(0x1, 0x4)
#define TIMER2_CDTI1_PB5 SILABS_DBUS_TIMER2_CDTI1(0x1, 0x5)
#define TIMER2_CDTI2_PA0 SILABS_DBUS_TIMER2_CDTI2(0x0, 0x0)
#define TIMER2_CDTI2_PA1 SILABS_DBUS_TIMER2_CDTI2(0x0, 0x1)
#define TIMER2_CDTI2_PA2 SILABS_DBUS_TIMER2_CDTI2(0x0, 0x2)
#define TIMER2_CDTI2_PA3 SILABS_DBUS_TIMER2_CDTI2(0x0, 0x3)
#define TIMER2_CDTI2_PA4 SILABS_DBUS_TIMER2_CDTI2(0x0, 0x4)
#define TIMER2_CDTI2_PA5 SILABS_DBUS_TIMER2_CDTI2(0x0, 0x5)
#define TIMER2_CDTI2_PA6 SILABS_DBUS_TIMER2_CDTI2(0x0, 0x6)
#define TIMER2_CDTI2_PA7 SILABS_DBUS_TIMER2_CDTI2(0x0, 0x7)
#define TIMER2_CDTI2_PA8 SILABS_DBUS_TIMER2_CDTI2(0x0, 0x8)
#define TIMER2_CDTI2_PA9 SILABS_DBUS_TIMER2_CDTI2(0x0, 0x9)
#define TIMER2_CDTI2_PB0 SILABS_DBUS_TIMER2_CDTI2(0x1, 0x0)
#define TIMER2_CDTI2_PB1 SILABS_DBUS_TIMER2_CDTI2(0x1, 0x1)
#define TIMER2_CDTI2_PB2 SILABS_DBUS_TIMER2_CDTI2(0x1, 0x2)
#define TIMER2_CDTI2_PB3 SILABS_DBUS_TIMER2_CDTI2(0x1, 0x3)
#define TIMER2_CDTI2_PB4 SILABS_DBUS_TIMER2_CDTI2(0x1, 0x4)
#define TIMER2_CDTI2_PB5 SILABS_DBUS_TIMER2_CDTI2(0x1, 0x5)

#define TIMER3_CC0_PC0   SILABS_DBUS_TIMER3_CC0(0x2, 0x0)
#define TIMER3_CC0_PC1   SILABS_DBUS_TIMER3_CC0(0x2, 0x1)
#define TIMER3_CC0_PC2   SILABS_DBUS_TIMER3_CC0(0x2, 0x2)
#define TIMER3_CC0_PC3   SILABS_DBUS_TIMER3_CC0(0x2, 0x3)
#define TIMER3_CC0_PC4   SILABS_DBUS_TIMER3_CC0(0x2, 0x4)
#define TIMER3_CC0_PC5   SILABS_DBUS_TIMER3_CC0(0x2, 0x5)
#define TIMER3_CC0_PC6   SILABS_DBUS_TIMER3_CC0(0x2, 0x6)
#define TIMER3_CC0_PC7   SILABS_DBUS_TIMER3_CC0(0x2, 0x7)
#define TIMER3_CC0_PC8   SILABS_DBUS_TIMER3_CC0(0x2, 0x8)
#define TIMER3_CC0_PC9   SILABS_DBUS_TIMER3_CC0(0x2, 0x9)
#define TIMER3_CC0_PD0   SILABS_DBUS_TIMER3_CC0(0x3, 0x0)
#define TIMER3_CC0_PD1   SILABS_DBUS_TIMER3_CC0(0x3, 0x1)
#define TIMER3_CC0_PD2   SILABS_DBUS_TIMER3_CC0(0x3, 0x2)
#define TIMER3_CC0_PD3   SILABS_DBUS_TIMER3_CC0(0x3, 0x3)
#define TIMER3_CC0_PD4   SILABS_DBUS_TIMER3_CC0(0x3, 0x4)
#define TIMER3_CC0_PD5   SILABS_DBUS_TIMER3_CC0(0x3, 0x5)
#define TIMER3_CC1_PC0   SILABS_DBUS_TIMER3_CC1(0x2, 0x0)
#define TIMER3_CC1_PC1   SILABS_DBUS_TIMER3_CC1(0x2, 0x1)
#define TIMER3_CC1_PC2   SILABS_DBUS_TIMER3_CC1(0x2, 0x2)
#define TIMER3_CC1_PC3   SILABS_DBUS_TIMER3_CC1(0x2, 0x3)
#define TIMER3_CC1_PC4   SILABS_DBUS_TIMER3_CC1(0x2, 0x4)
#define TIMER3_CC1_PC5   SILABS_DBUS_TIMER3_CC1(0x2, 0x5)
#define TIMER3_CC1_PC6   SILABS_DBUS_TIMER3_CC1(0x2, 0x6)
#define TIMER3_CC1_PC7   SILABS_DBUS_TIMER3_CC1(0x2, 0x7)
#define TIMER3_CC1_PC8   SILABS_DBUS_TIMER3_CC1(0x2, 0x8)
#define TIMER3_CC1_PC9   SILABS_DBUS_TIMER3_CC1(0x2, 0x9)
#define TIMER3_CC1_PD0   SILABS_DBUS_TIMER3_CC1(0x3, 0x0)
#define TIMER3_CC1_PD1   SILABS_DBUS_TIMER3_CC1(0x3, 0x1)
#define TIMER3_CC1_PD2   SILABS_DBUS_TIMER3_CC1(0x3, 0x2)
#define TIMER3_CC1_PD3   SILABS_DBUS_TIMER3_CC1(0x3, 0x3)
#define TIMER3_CC1_PD4   SILABS_DBUS_TIMER3_CC1(0x3, 0x4)
#define TIMER3_CC1_PD5   SILABS_DBUS_TIMER3_CC1(0x3, 0x5)
#define TIMER3_CC2_PC0   SILABS_DBUS_TIMER3_CC2(0x2, 0x0)
#define TIMER3_CC2_PC1   SILABS_DBUS_TIMER3_CC2(0x2, 0x1)
#define TIMER3_CC2_PC2   SILABS_DBUS_TIMER3_CC2(0x2, 0x2)
#define TIMER3_CC2_PC3   SILABS_DBUS_TIMER3_CC2(0x2, 0x3)
#define TIMER3_CC2_PC4   SILABS_DBUS_TIMER3_CC2(0x2, 0x4)
#define TIMER3_CC2_PC5   SILABS_DBUS_TIMER3_CC2(0x2, 0x5)
#define TIMER3_CC2_PC6   SILABS_DBUS_TIMER3_CC2(0x2, 0x6)
#define TIMER3_CC2_PC7   SILABS_DBUS_TIMER3_CC2(0x2, 0x7)
#define TIMER3_CC2_PC8   SILABS_DBUS_TIMER3_CC2(0x2, 0x8)
#define TIMER3_CC2_PC9   SILABS_DBUS_TIMER3_CC2(0x2, 0x9)
#define TIMER3_CC2_PD0   SILABS_DBUS_TIMER3_CC2(0x3, 0x0)
#define TIMER3_CC2_PD1   SILABS_DBUS_TIMER3_CC2(0x3, 0x1)
#define TIMER3_CC2_PD2   SILABS_DBUS_TIMER3_CC2(0x3, 0x2)
#define TIMER3_CC2_PD3   SILABS_DBUS_TIMER3_CC2(0x3, 0x3)
#define TIMER3_CC2_PD4   SILABS_DBUS_TIMER3_CC2(0x3, 0x4)
#define TIMER3_CC2_PD5   SILABS_DBUS_TIMER3_CC2(0x3, 0x5)
#define TIMER3_CDTI0_PC0 SILABS_DBUS_TIMER3_CDTI0(0x2, 0x0)
#define TIMER3_CDTI0_PC1 SILABS_DBUS_TIMER3_CDTI0(0x2, 0x1)
#define TIMER3_CDTI0_PC2 SILABS_DBUS_TIMER3_CDTI0(0x2, 0x2)
#define TIMER3_CDTI0_PC3 SILABS_DBUS_TIMER3_CDTI0(0x2, 0x3)
#define TIMER3_CDTI0_PC4 SILABS_DBUS_TIMER3_CDTI0(0x2, 0x4)
#define TIMER3_CDTI0_PC5 SILABS_DBUS_TIMER3_CDTI0(0x2, 0x5)
#define TIMER3_CDTI0_PC6 SILABS_DBUS_TIMER3_CDTI0(0x2, 0x6)
#define TIMER3_CDTI0_PC7 SILABS_DBUS_TIMER3_CDTI0(0x2, 0x7)
#define TIMER3_CDTI0_PC8 SILABS_DBUS_TIMER3_CDTI0(0x2, 0x8)
#define TIMER3_CDTI0_PC9 SILABS_DBUS_TIMER3_CDTI0(0x2, 0x9)
#define TIMER3_CDTI0_PD0 SILABS_DBUS_TIMER3_CDTI0(0x3, 0x0)
#define TIMER3_CDTI0_PD1 SILABS_DBUS_TIMER3_CDTI0(0x3, 0x1)
#define TIMER3_CDTI0_PD2 SILABS_DBUS_TIMER3_CDTI0(0x3, 0x2)
#define TIMER3_CDTI0_PD3 SILABS_DBUS_TIMER3_CDTI0(0x3, 0x3)
#define TIMER3_CDTI0_PD4 SILABS_DBUS_TIMER3_CDTI0(0x3, 0x4)
#define TIMER3_CDTI0_PD5 SILABS_DBUS_TIMER3_CDTI0(0x3, 0x5)
#define TIMER3_CDTI1_PC0 SILABS_DBUS_TIMER3_CDTI1(0x2, 0x0)
#define TIMER3_CDTI1_PC1 SILABS_DBUS_TIMER3_CDTI1(0x2, 0x1)
#define TIMER3_CDTI1_PC2 SILABS_DBUS_TIMER3_CDTI1(0x2, 0x2)
#define TIMER3_CDTI1_PC3 SILABS_DBUS_TIMER3_CDTI1(0x2, 0x3)
#define TIMER3_CDTI1_PC4 SILABS_DBUS_TIMER3_CDTI1(0x2, 0x4)
#define TIMER3_CDTI1_PC5 SILABS_DBUS_TIMER3_CDTI1(0x2, 0x5)
#define TIMER3_CDTI1_PC6 SILABS_DBUS_TIMER3_CDTI1(0x2, 0x6)
#define TIMER3_CDTI1_PC7 SILABS_DBUS_TIMER3_CDTI1(0x2, 0x7)
#define TIMER3_CDTI1_PC8 SILABS_DBUS_TIMER3_CDTI1(0x2, 0x8)
#define TIMER3_CDTI1_PC9 SILABS_DBUS_TIMER3_CDTI1(0x2, 0x9)
#define TIMER3_CDTI1_PD0 SILABS_DBUS_TIMER3_CDTI1(0x3, 0x0)
#define TIMER3_CDTI1_PD1 SILABS_DBUS_TIMER3_CDTI1(0x3, 0x1)
#define TIMER3_CDTI1_PD2 SILABS_DBUS_TIMER3_CDTI1(0x3, 0x2)
#define TIMER3_CDTI1_PD3 SILABS_DBUS_TIMER3_CDTI1(0x3, 0x3)
#define TIMER3_CDTI1_PD4 SILABS_DBUS_TIMER3_CDTI1(0x3, 0x4)
#define TIMER3_CDTI1_PD5 SILABS_DBUS_TIMER3_CDTI1(0x3, 0x5)
#define TIMER3_CDTI2_PC0 SILABS_DBUS_TIMER3_CDTI2(0x2, 0x0)
#define TIMER3_CDTI2_PC1 SILABS_DBUS_TIMER3_CDTI2(0x2, 0x1)
#define TIMER3_CDTI2_PC2 SILABS_DBUS_TIMER3_CDTI2(0x2, 0x2)
#define TIMER3_CDTI2_PC3 SILABS_DBUS_TIMER3_CDTI2(0x2, 0x3)
#define TIMER3_CDTI2_PC4 SILABS_DBUS_TIMER3_CDTI2(0x2, 0x4)
#define TIMER3_CDTI2_PC5 SILABS_DBUS_TIMER3_CDTI2(0x2, 0x5)
#define TIMER3_CDTI2_PC6 SILABS_DBUS_TIMER3_CDTI2(0x2, 0x6)
#define TIMER3_CDTI2_PC7 SILABS_DBUS_TIMER3_CDTI2(0x2, 0x7)
#define TIMER3_CDTI2_PC8 SILABS_DBUS_TIMER3_CDTI2(0x2, 0x8)
#define TIMER3_CDTI2_PC9 SILABS_DBUS_TIMER3_CDTI2(0x2, 0x9)
#define TIMER3_CDTI2_PD0 SILABS_DBUS_TIMER3_CDTI2(0x3, 0x0)
#define TIMER3_CDTI2_PD1 SILABS_DBUS_TIMER3_CDTI2(0x3, 0x1)
#define TIMER3_CDTI2_PD2 SILABS_DBUS_TIMER3_CDTI2(0x3, 0x2)
#define TIMER3_CDTI2_PD3 SILABS_DBUS_TIMER3_CDTI2(0x3, 0x3)
#define TIMER3_CDTI2_PD4 SILABS_DBUS_TIMER3_CDTI2(0x3, 0x4)
#define TIMER3_CDTI2_PD5 SILABS_DBUS_TIMER3_CDTI2(0x3, 0x5)

#define TIMER4_CC0_PA0   SILABS_DBUS_TIMER4_CC0(0x0, 0x0)
#define TIMER4_CC0_PA1   SILABS_DBUS_TIMER4_CC0(0x0, 0x1)
#define TIMER4_CC0_PA2   SILABS_DBUS_TIMER4_CC0(0x0, 0x2)
#define TIMER4_CC0_PA3   SILABS_DBUS_TIMER4_CC0(0x0, 0x3)
#define TIMER4_CC0_PA4   SILABS_DBUS_TIMER4_CC0(0x0, 0x4)
#define TIMER4_CC0_PA5   SILABS_DBUS_TIMER4_CC0(0x0, 0x5)
#define TIMER4_CC0_PA6   SILABS_DBUS_TIMER4_CC0(0x0, 0x6)
#define TIMER4_CC0_PA7   SILABS_DBUS_TIMER4_CC0(0x0, 0x7)
#define TIMER4_CC0_PA8   SILABS_DBUS_TIMER4_CC0(0x0, 0x8)
#define TIMER4_CC0_PA9   SILABS_DBUS_TIMER4_CC0(0x0, 0x9)
#define TIMER4_CC0_PB0   SILABS_DBUS_TIMER4_CC0(0x1, 0x0)
#define TIMER4_CC0_PB1   SILABS_DBUS_TIMER4_CC0(0x1, 0x1)
#define TIMER4_CC0_PB2   SILABS_DBUS_TIMER4_CC0(0x1, 0x2)
#define TIMER4_CC0_PB3   SILABS_DBUS_TIMER4_CC0(0x1, 0x3)
#define TIMER4_CC0_PB4   SILABS_DBUS_TIMER4_CC0(0x1, 0x4)
#define TIMER4_CC0_PB5   SILABS_DBUS_TIMER4_CC0(0x1, 0x5)
#define TIMER4_CC1_PA0   SILABS_DBUS_TIMER4_CC1(0x0, 0x0)
#define TIMER4_CC1_PA1   SILABS_DBUS_TIMER4_CC1(0x0, 0x1)
#define TIMER4_CC1_PA2   SILABS_DBUS_TIMER4_CC1(0x0, 0x2)
#define TIMER4_CC1_PA3   SILABS_DBUS_TIMER4_CC1(0x0, 0x3)
#define TIMER4_CC1_PA4   SILABS_DBUS_TIMER4_CC1(0x0, 0x4)
#define TIMER4_CC1_PA5   SILABS_DBUS_TIMER4_CC1(0x0, 0x5)
#define TIMER4_CC1_PA6   SILABS_DBUS_TIMER4_CC1(0x0, 0x6)
#define TIMER4_CC1_PA7   SILABS_DBUS_TIMER4_CC1(0x0, 0x7)
#define TIMER4_CC1_PA8   SILABS_DBUS_TIMER4_CC1(0x0, 0x8)
#define TIMER4_CC1_PA9   SILABS_DBUS_TIMER4_CC1(0x0, 0x9)
#define TIMER4_CC1_PB0   SILABS_DBUS_TIMER4_CC1(0x1, 0x0)
#define TIMER4_CC1_PB1   SILABS_DBUS_TIMER4_CC1(0x1, 0x1)
#define TIMER4_CC1_PB2   SILABS_DBUS_TIMER4_CC1(0x1, 0x2)
#define TIMER4_CC1_PB3   SILABS_DBUS_TIMER4_CC1(0x1, 0x3)
#define TIMER4_CC1_PB4   SILABS_DBUS_TIMER4_CC1(0x1, 0x4)
#define TIMER4_CC1_PB5   SILABS_DBUS_TIMER4_CC1(0x1, 0x5)
#define TIMER4_CC2_PA0   SILABS_DBUS_TIMER4_CC2(0x0, 0x0)
#define TIMER4_CC2_PA1   SILABS_DBUS_TIMER4_CC2(0x0, 0x1)
#define TIMER4_CC2_PA2   SILABS_DBUS_TIMER4_CC2(0x0, 0x2)
#define TIMER4_CC2_PA3   SILABS_DBUS_TIMER4_CC2(0x0, 0x3)
#define TIMER4_CC2_PA4   SILABS_DBUS_TIMER4_CC2(0x0, 0x4)
#define TIMER4_CC2_PA5   SILABS_DBUS_TIMER4_CC2(0x0, 0x5)
#define TIMER4_CC2_PA6   SILABS_DBUS_TIMER4_CC2(0x0, 0x6)
#define TIMER4_CC2_PA7   SILABS_DBUS_TIMER4_CC2(0x0, 0x7)
#define TIMER4_CC2_PA8   SILABS_DBUS_TIMER4_CC2(0x0, 0x8)
#define TIMER4_CC2_PA9   SILABS_DBUS_TIMER4_CC2(0x0, 0x9)
#define TIMER4_CC2_PB0   SILABS_DBUS_TIMER4_CC2(0x1, 0x0)
#define TIMER4_CC2_PB1   SILABS_DBUS_TIMER4_CC2(0x1, 0x1)
#define TIMER4_CC2_PB2   SILABS_DBUS_TIMER4_CC2(0x1, 0x2)
#define TIMER4_CC2_PB3   SILABS_DBUS_TIMER4_CC2(0x1, 0x3)
#define TIMER4_CC2_PB4   SILABS_DBUS_TIMER4_CC2(0x1, 0x4)
#define TIMER4_CC2_PB5   SILABS_DBUS_TIMER4_CC2(0x1, 0x5)
#define TIMER4_CDTI0_PA0 SILABS_DBUS_TIMER4_CDTI0(0x0, 0x0)
#define TIMER4_CDTI0_PA1 SILABS_DBUS_TIMER4_CDTI0(0x0, 0x1)
#define TIMER4_CDTI0_PA2 SILABS_DBUS_TIMER4_CDTI0(0x0, 0x2)
#define TIMER4_CDTI0_PA3 SILABS_DBUS_TIMER4_CDTI0(0x0, 0x3)
#define TIMER4_CDTI0_PA4 SILABS_DBUS_TIMER4_CDTI0(0x0, 0x4)
#define TIMER4_CDTI0_PA5 SILABS_DBUS_TIMER4_CDTI0(0x0, 0x5)
#define TIMER4_CDTI0_PA6 SILABS_DBUS_TIMER4_CDTI0(0x0, 0x6)
#define TIMER4_CDTI0_PA7 SILABS_DBUS_TIMER4_CDTI0(0x0, 0x7)
#define TIMER4_CDTI0_PA8 SILABS_DBUS_TIMER4_CDTI0(0x0, 0x8)
#define TIMER4_CDTI0_PA9 SILABS_DBUS_TIMER4_CDTI0(0x0, 0x9)
#define TIMER4_CDTI0_PB0 SILABS_DBUS_TIMER4_CDTI0(0x1, 0x0)
#define TIMER4_CDTI0_PB1 SILABS_DBUS_TIMER4_CDTI0(0x1, 0x1)
#define TIMER4_CDTI0_PB2 SILABS_DBUS_TIMER4_CDTI0(0x1, 0x2)
#define TIMER4_CDTI0_PB3 SILABS_DBUS_TIMER4_CDTI0(0x1, 0x3)
#define TIMER4_CDTI0_PB4 SILABS_DBUS_TIMER4_CDTI0(0x1, 0x4)
#define TIMER4_CDTI0_PB5 SILABS_DBUS_TIMER4_CDTI0(0x1, 0x5)
#define TIMER4_CDTI1_PA0 SILABS_DBUS_TIMER4_CDTI1(0x0, 0x0)
#define TIMER4_CDTI1_PA1 SILABS_DBUS_TIMER4_CDTI1(0x0, 0x1)
#define TIMER4_CDTI1_PA2 SILABS_DBUS_TIMER4_CDTI1(0x0, 0x2)
#define TIMER4_CDTI1_PA3 SILABS_DBUS_TIMER4_CDTI1(0x0, 0x3)
#define TIMER4_CDTI1_PA4 SILABS_DBUS_TIMER4_CDTI1(0x0, 0x4)
#define TIMER4_CDTI1_PA5 SILABS_DBUS_TIMER4_CDTI1(0x0, 0x5)
#define TIMER4_CDTI1_PA6 SILABS_DBUS_TIMER4_CDTI1(0x0, 0x6)
#define TIMER4_CDTI1_PA7 SILABS_DBUS_TIMER4_CDTI1(0x0, 0x7)
#define TIMER4_CDTI1_PA8 SILABS_DBUS_TIMER4_CDTI1(0x0, 0x8)
#define TIMER4_CDTI1_PA9 SILABS_DBUS_TIMER4_CDTI1(0x0, 0x9)
#define TIMER4_CDTI1_PB0 SILABS_DBUS_TIMER4_CDTI1(0x1, 0x0)
#define TIMER4_CDTI1_PB1 SILABS_DBUS_TIMER4_CDTI1(0x1, 0x1)
#define TIMER4_CDTI1_PB2 SILABS_DBUS_TIMER4_CDTI1(0x1, 0x2)
#define TIMER4_CDTI1_PB3 SILABS_DBUS_TIMER4_CDTI1(0x1, 0x3)
#define TIMER4_CDTI1_PB4 SILABS_DBUS_TIMER4_CDTI1(0x1, 0x4)
#define TIMER4_CDTI1_PB5 SILABS_DBUS_TIMER4_CDTI1(0x1, 0x5)
#define TIMER4_CDTI2_PA0 SILABS_DBUS_TIMER4_CDTI2(0x0, 0x0)
#define TIMER4_CDTI2_PA1 SILABS_DBUS_TIMER4_CDTI2(0x0, 0x1)
#define TIMER4_CDTI2_PA2 SILABS_DBUS_TIMER4_CDTI2(0x0, 0x2)
#define TIMER4_CDTI2_PA3 SILABS_DBUS_TIMER4_CDTI2(0x0, 0x3)
#define TIMER4_CDTI2_PA4 SILABS_DBUS_TIMER4_CDTI2(0x0, 0x4)
#define TIMER4_CDTI2_PA5 SILABS_DBUS_TIMER4_CDTI2(0x0, 0x5)
#define TIMER4_CDTI2_PA6 SILABS_DBUS_TIMER4_CDTI2(0x0, 0x6)
#define TIMER4_CDTI2_PA7 SILABS_DBUS_TIMER4_CDTI2(0x0, 0x7)
#define TIMER4_CDTI2_PA8 SILABS_DBUS_TIMER4_CDTI2(0x0, 0x8)
#define TIMER4_CDTI2_PA9 SILABS_DBUS_TIMER4_CDTI2(0x0, 0x9)
#define TIMER4_CDTI2_PB0 SILABS_DBUS_TIMER4_CDTI2(0x1, 0x0)
#define TIMER4_CDTI2_PB1 SILABS_DBUS_TIMER4_CDTI2(0x1, 0x1)
#define TIMER4_CDTI2_PB2 SILABS_DBUS_TIMER4_CDTI2(0x1, 0x2)
#define TIMER4_CDTI2_PB3 SILABS_DBUS_TIMER4_CDTI2(0x1, 0x3)
#define TIMER4_CDTI2_PB4 SILABS_DBUS_TIMER4_CDTI2(0x1, 0x4)
#define TIMER4_CDTI2_PB5 SILABS_DBUS_TIMER4_CDTI2(0x1, 0x5)

#define USART0_CS_PA0  SILABS_DBUS_USART0_CS(0x0, 0x0)
#define USART0_CS_PA1  SILABS_DBUS_USART0_CS(0x0, 0x1)
#define USART0_CS_PA2  SILABS_DBUS_USART0_CS(0x0, 0x2)
#define USART0_CS_PA3  SILABS_DBUS_USART0_CS(0x0, 0x3)
#define USART0_CS_PA4  SILABS_DBUS_USART0_CS(0x0, 0x4)
#define USART0_CS_PA5  SILABS_DBUS_USART0_CS(0x0, 0x5)
#define USART0_CS_PA6  SILABS_DBUS_USART0_CS(0x0, 0x6)
#define USART0_CS_PA7  SILABS_DBUS_USART0_CS(0x0, 0x7)
#define USART0_CS_PA8  SILABS_DBUS_USART0_CS(0x0, 0x8)
#define USART0_CS_PA9  SILABS_DBUS_USART0_CS(0x0, 0x9)
#define USART0_CS_PB0  SILABS_DBUS_USART0_CS(0x1, 0x0)
#define USART0_CS_PB1  SILABS_DBUS_USART0_CS(0x1, 0x1)
#define USART0_CS_PB2  SILABS_DBUS_USART0_CS(0x1, 0x2)
#define USART0_CS_PB3  SILABS_DBUS_USART0_CS(0x1, 0x3)
#define USART0_CS_PB4  SILABS_DBUS_USART0_CS(0x1, 0x4)
#define USART0_CS_PB5  SILABS_DBUS_USART0_CS(0x1, 0x5)
#define USART0_CS_PC0  SILABS_DBUS_USART0_CS(0x2, 0x0)
#define USART0_CS_PC1  SILABS_DBUS_USART0_CS(0x2, 0x1)
#define USART0_CS_PC2  SILABS_DBUS_USART0_CS(0x2, 0x2)
#define USART0_CS_PC3  SILABS_DBUS_USART0_CS(0x2, 0x3)
#define USART0_CS_PC4  SILABS_DBUS_USART0_CS(0x2, 0x4)
#define USART0_CS_PC5  SILABS_DBUS_USART0_CS(0x2, 0x5)
#define USART0_CS_PC6  SILABS_DBUS_USART0_CS(0x2, 0x6)
#define USART0_CS_PC7  SILABS_DBUS_USART0_CS(0x2, 0x7)
#define USART0_CS_PC8  SILABS_DBUS_USART0_CS(0x2, 0x8)
#define USART0_CS_PC9  SILABS_DBUS_USART0_CS(0x2, 0x9)
#define USART0_CS_PD0  SILABS_DBUS_USART0_CS(0x3, 0x0)
#define USART0_CS_PD1  SILABS_DBUS_USART0_CS(0x3, 0x1)
#define USART0_CS_PD2  SILABS_DBUS_USART0_CS(0x3, 0x2)
#define USART0_CS_PD3  SILABS_DBUS_USART0_CS(0x3, 0x3)
#define USART0_CS_PD4  SILABS_DBUS_USART0_CS(0x3, 0x4)
#define USART0_CS_PD5  SILABS_DBUS_USART0_CS(0x3, 0x5)
#define USART0_RTS_PA0 SILABS_DBUS_USART0_RTS(0x0, 0x0)
#define USART0_RTS_PA1 SILABS_DBUS_USART0_RTS(0x0, 0x1)
#define USART0_RTS_PA2 SILABS_DBUS_USART0_RTS(0x0, 0x2)
#define USART0_RTS_PA3 SILABS_DBUS_USART0_RTS(0x0, 0x3)
#define USART0_RTS_PA4 SILABS_DBUS_USART0_RTS(0x0, 0x4)
#define USART0_RTS_PA5 SILABS_DBUS_USART0_RTS(0x0, 0x5)
#define USART0_RTS_PA6 SILABS_DBUS_USART0_RTS(0x0, 0x6)
#define USART0_RTS_PA7 SILABS_DBUS_USART0_RTS(0x0, 0x7)
#define USART0_RTS_PA8 SILABS_DBUS_USART0_RTS(0x0, 0x8)
#define USART0_RTS_PA9 SILABS_DBUS_USART0_RTS(0x0, 0x9)
#define USART0_RTS_PB0 SILABS_DBUS_USART0_RTS(0x1, 0x0)
#define USART0_RTS_PB1 SILABS_DBUS_USART0_RTS(0x1, 0x1)
#define USART0_RTS_PB2 SILABS_DBUS_USART0_RTS(0x1, 0x2)
#define USART0_RTS_PB3 SILABS_DBUS_USART0_RTS(0x1, 0x3)
#define USART0_RTS_PB4 SILABS_DBUS_USART0_RTS(0x1, 0x4)
#define USART0_RTS_PB5 SILABS_DBUS_USART0_RTS(0x1, 0x5)
#define USART0_RTS_PC0 SILABS_DBUS_USART0_RTS(0x2, 0x0)
#define USART0_RTS_PC1 SILABS_DBUS_USART0_RTS(0x2, 0x1)
#define USART0_RTS_PC2 SILABS_DBUS_USART0_RTS(0x2, 0x2)
#define USART0_RTS_PC3 SILABS_DBUS_USART0_RTS(0x2, 0x3)
#define USART0_RTS_PC4 SILABS_DBUS_USART0_RTS(0x2, 0x4)
#define USART0_RTS_PC5 SILABS_DBUS_USART0_RTS(0x2, 0x5)
#define USART0_RTS_PC6 SILABS_DBUS_USART0_RTS(0x2, 0x6)
#define USART0_RTS_PC7 SILABS_DBUS_USART0_RTS(0x2, 0x7)
#define USART0_RTS_PC8 SILABS_DBUS_USART0_RTS(0x2, 0x8)
#define USART0_RTS_PC9 SILABS_DBUS_USART0_RTS(0x2, 0x9)
#define USART0_RTS_PD0 SILABS_DBUS_USART0_RTS(0x3, 0x0)
#define USART0_RTS_PD1 SILABS_DBUS_USART0_RTS(0x3, 0x1)
#define USART0_RTS_PD2 SILABS_DBUS_USART0_RTS(0x3, 0x2)
#define USART0_RTS_PD3 SILABS_DBUS_USART0_RTS(0x3, 0x3)
#define USART0_RTS_PD4 SILABS_DBUS_USART0_RTS(0x3, 0x4)
#define USART0_RTS_PD5 SILABS_DBUS_USART0_RTS(0x3, 0x5)
#define USART0_RX_PA0  SILABS_DBUS_USART0_RX(0x0, 0x0)
#define USART0_RX_PA1  SILABS_DBUS_USART0_RX(0x0, 0x1)
#define USART0_RX_PA2  SILABS_DBUS_USART0_RX(0x0, 0x2)
#define USART0_RX_PA3  SILABS_DBUS_USART0_RX(0x0, 0x3)
#define USART0_RX_PA4  SILABS_DBUS_USART0_RX(0x0, 0x4)
#define USART0_RX_PA5  SILABS_DBUS_USART0_RX(0x0, 0x5)
#define USART0_RX_PA6  SILABS_DBUS_USART0_RX(0x0, 0x6)
#define USART0_RX_PA7  SILABS_DBUS_USART0_RX(0x0, 0x7)
#define USART0_RX_PA8  SILABS_DBUS_USART0_RX(0x0, 0x8)
#define USART0_RX_PA9  SILABS_DBUS_USART0_RX(0x0, 0x9)
#define USART0_RX_PB0  SILABS_DBUS_USART0_RX(0x1, 0x0)
#define USART0_RX_PB1  SILABS_DBUS_USART0_RX(0x1, 0x1)
#define USART0_RX_PB2  SILABS_DBUS_USART0_RX(0x1, 0x2)
#define USART0_RX_PB3  SILABS_DBUS_USART0_RX(0x1, 0x3)
#define USART0_RX_PB4  SILABS_DBUS_USART0_RX(0x1, 0x4)
#define USART0_RX_PB5  SILABS_DBUS_USART0_RX(0x1, 0x5)
#define USART0_RX_PC0  SILABS_DBUS_USART0_RX(0x2, 0x0)
#define USART0_RX_PC1  SILABS_DBUS_USART0_RX(0x2, 0x1)
#define USART0_RX_PC2  SILABS_DBUS_USART0_RX(0x2, 0x2)
#define USART0_RX_PC3  SILABS_DBUS_USART0_RX(0x2, 0x3)
#define USART0_RX_PC4  SILABS_DBUS_USART0_RX(0x2, 0x4)
#define USART0_RX_PC5  SILABS_DBUS_USART0_RX(0x2, 0x5)
#define USART0_RX_PC6  SILABS_DBUS_USART0_RX(0x2, 0x6)
#define USART0_RX_PC7  SILABS_DBUS_USART0_RX(0x2, 0x7)
#define USART0_RX_PC8  SILABS_DBUS_USART0_RX(0x2, 0x8)
#define USART0_RX_PC9  SILABS_DBUS_USART0_RX(0x2, 0x9)
#define USART0_RX_PD0  SILABS_DBUS_USART0_RX(0x3, 0x0)
#define USART0_RX_PD1  SILABS_DBUS_USART0_RX(0x3, 0x1)
#define USART0_RX_PD2  SILABS_DBUS_USART0_RX(0x3, 0x2)
#define USART0_RX_PD3  SILABS_DBUS_USART0_RX(0x3, 0x3)
#define USART0_RX_PD4  SILABS_DBUS_USART0_RX(0x3, 0x4)
#define USART0_RX_PD5  SILABS_DBUS_USART0_RX(0x3, 0x5)
#define USART0_CLK_PA0 SILABS_DBUS_USART0_CLK(0x0, 0x0)
#define USART0_CLK_PA1 SILABS_DBUS_USART0_CLK(0x0, 0x1)
#define USART0_CLK_PA2 SILABS_DBUS_USART0_CLK(0x0, 0x2)
#define USART0_CLK_PA3 SILABS_DBUS_USART0_CLK(0x0, 0x3)
#define USART0_CLK_PA4 SILABS_DBUS_USART0_CLK(0x0, 0x4)
#define USART0_CLK_PA5 SILABS_DBUS_USART0_CLK(0x0, 0x5)
#define USART0_CLK_PA6 SILABS_DBUS_USART0_CLK(0x0, 0x6)
#define USART0_CLK_PA7 SILABS_DBUS_USART0_CLK(0x0, 0x7)
#define USART0_CLK_PA8 SILABS_DBUS_USART0_CLK(0x0, 0x8)
#define USART0_CLK_PA9 SILABS_DBUS_USART0_CLK(0x0, 0x9)
#define USART0_CLK_PB0 SILABS_DBUS_USART0_CLK(0x1, 0x0)
#define USART0_CLK_PB1 SILABS_DBUS_USART0_CLK(0x1, 0x1)
#define USART0_CLK_PB2 SILABS_DBUS_USART0_CLK(0x1, 0x2)
#define USART0_CLK_PB3 SILABS_DBUS_USART0_CLK(0x1, 0x3)
#define USART0_CLK_PB4 SILABS_DBUS_USART0_CLK(0x1, 0x4)
#define USART0_CLK_PB5 SILABS_DBUS_USART0_CLK(0x1, 0x5)
#define USART0_CLK_PC0 SILABS_DBUS_USART0_CLK(0x2, 0x0)
#define USART0_CLK_PC1 SILABS_DBUS_USART0_CLK(0x2, 0x1)
#define USART0_CLK_PC2 SILABS_DBUS_USART0_CLK(0x2, 0x2)
#define USART0_CLK_PC3 SILABS_DBUS_USART0_CLK(0x2, 0x3)
#define USART0_CLK_PC4 SILABS_DBUS_USART0_CLK(0x2, 0x4)
#define USART0_CLK_PC5 SILABS_DBUS_USART0_CLK(0x2, 0x5)
#define USART0_CLK_PC6 SILABS_DBUS_USART0_CLK(0x2, 0x6)
#define USART0_CLK_PC7 SILABS_DBUS_USART0_CLK(0x2, 0x7)
#define USART0_CLK_PC8 SILABS_DBUS_USART0_CLK(0x2, 0x8)
#define USART0_CLK_PC9 SILABS_DBUS_USART0_CLK(0x2, 0x9)
#define USART0_CLK_PD0 SILABS_DBUS_USART0_CLK(0x3, 0x0)
#define USART0_CLK_PD1 SILABS_DBUS_USART0_CLK(0x3, 0x1)
#define USART0_CLK_PD2 SILABS_DBUS_USART0_CLK(0x3, 0x2)
#define USART0_CLK_PD3 SILABS_DBUS_USART0_CLK(0x3, 0x3)
#define USART0_CLK_PD4 SILABS_DBUS_USART0_CLK(0x3, 0x4)
#define USART0_CLK_PD5 SILABS_DBUS_USART0_CLK(0x3, 0x5)
#define USART0_TX_PA0  SILABS_DBUS_USART0_TX(0x0, 0x0)
#define USART0_TX_PA1  SILABS_DBUS_USART0_TX(0x0, 0x1)
#define USART0_TX_PA2  SILABS_DBUS_USART0_TX(0x0, 0x2)
#define USART0_TX_PA3  SILABS_DBUS_USART0_TX(0x0, 0x3)
#define USART0_TX_PA4  SILABS_DBUS_USART0_TX(0x0, 0x4)
#define USART0_TX_PA5  SILABS_DBUS_USART0_TX(0x0, 0x5)
#define USART0_TX_PA6  SILABS_DBUS_USART0_TX(0x0, 0x6)
#define USART0_TX_PA7  SILABS_DBUS_USART0_TX(0x0, 0x7)
#define USART0_TX_PA8  SILABS_DBUS_USART0_TX(0x0, 0x8)
#define USART0_TX_PA9  SILABS_DBUS_USART0_TX(0x0, 0x9)
#define USART0_TX_PB0  SILABS_DBUS_USART0_TX(0x1, 0x0)
#define USART0_TX_PB1  SILABS_DBUS_USART0_TX(0x1, 0x1)
#define USART0_TX_PB2  SILABS_DBUS_USART0_TX(0x1, 0x2)
#define USART0_TX_PB3  SILABS_DBUS_USART0_TX(0x1, 0x3)
#define USART0_TX_PB4  SILABS_DBUS_USART0_TX(0x1, 0x4)
#define USART0_TX_PB5  SILABS_DBUS_USART0_TX(0x1, 0x5)
#define USART0_TX_PC0  SILABS_DBUS_USART0_TX(0x2, 0x0)
#define USART0_TX_PC1  SILABS_DBUS_USART0_TX(0x2, 0x1)
#define USART0_TX_PC2  SILABS_DBUS_USART0_TX(0x2, 0x2)
#define USART0_TX_PC3  SILABS_DBUS_USART0_TX(0x2, 0x3)
#define USART0_TX_PC4  SILABS_DBUS_USART0_TX(0x2, 0x4)
#define USART0_TX_PC5  SILABS_DBUS_USART0_TX(0x2, 0x5)
#define USART0_TX_PC6  SILABS_DBUS_USART0_TX(0x2, 0x6)
#define USART0_TX_PC7  SILABS_DBUS_USART0_TX(0x2, 0x7)
#define USART0_TX_PC8  SILABS_DBUS_USART0_TX(0x2, 0x8)
#define USART0_TX_PC9  SILABS_DBUS_USART0_TX(0x2, 0x9)
#define USART0_TX_PD0  SILABS_DBUS_USART0_TX(0x3, 0x0)
#define USART0_TX_PD1  SILABS_DBUS_USART0_TX(0x3, 0x1)
#define USART0_TX_PD2  SILABS_DBUS_USART0_TX(0x3, 0x2)
#define USART0_TX_PD3  SILABS_DBUS_USART0_TX(0x3, 0x3)
#define USART0_TX_PD4  SILABS_DBUS_USART0_TX(0x3, 0x4)
#define USART0_TX_PD5  SILABS_DBUS_USART0_TX(0x3, 0x5)
#define USART0_CTS_PA0 SILABS_DBUS_USART0_CTS(0x0, 0x0)
#define USART0_CTS_PA1 SILABS_DBUS_USART0_CTS(0x0, 0x1)
#define USART0_CTS_PA2 SILABS_DBUS_USART0_CTS(0x0, 0x2)
#define USART0_CTS_PA3 SILABS_DBUS_USART0_CTS(0x0, 0x3)
#define USART0_CTS_PA4 SILABS_DBUS_USART0_CTS(0x0, 0x4)
#define USART0_CTS_PA5 SILABS_DBUS_USART0_CTS(0x0, 0x5)
#define USART0_CTS_PA6 SILABS_DBUS_USART0_CTS(0x0, 0x6)
#define USART0_CTS_PA7 SILABS_DBUS_USART0_CTS(0x0, 0x7)
#define USART0_CTS_PA8 SILABS_DBUS_USART0_CTS(0x0, 0x8)
#define USART0_CTS_PA9 SILABS_DBUS_USART0_CTS(0x0, 0x9)
#define USART0_CTS_PB0 SILABS_DBUS_USART0_CTS(0x1, 0x0)
#define USART0_CTS_PB1 SILABS_DBUS_USART0_CTS(0x1, 0x1)
#define USART0_CTS_PB2 SILABS_DBUS_USART0_CTS(0x1, 0x2)
#define USART0_CTS_PB3 SILABS_DBUS_USART0_CTS(0x1, 0x3)
#define USART0_CTS_PB4 SILABS_DBUS_USART0_CTS(0x1, 0x4)
#define USART0_CTS_PB5 SILABS_DBUS_USART0_CTS(0x1, 0x5)
#define USART0_CTS_PC0 SILABS_DBUS_USART0_CTS(0x2, 0x0)
#define USART0_CTS_PC1 SILABS_DBUS_USART0_CTS(0x2, 0x1)
#define USART0_CTS_PC2 SILABS_DBUS_USART0_CTS(0x2, 0x2)
#define USART0_CTS_PC3 SILABS_DBUS_USART0_CTS(0x2, 0x3)
#define USART0_CTS_PC4 SILABS_DBUS_USART0_CTS(0x2, 0x4)
#define USART0_CTS_PC5 SILABS_DBUS_USART0_CTS(0x2, 0x5)
#define USART0_CTS_PC6 SILABS_DBUS_USART0_CTS(0x2, 0x6)
#define USART0_CTS_PC7 SILABS_DBUS_USART0_CTS(0x2, 0x7)
#define USART0_CTS_PC8 SILABS_DBUS_USART0_CTS(0x2, 0x8)
#define USART0_CTS_PC9 SILABS_DBUS_USART0_CTS(0x2, 0x9)
#define USART0_CTS_PD0 SILABS_DBUS_USART0_CTS(0x3, 0x0)
#define USART0_CTS_PD1 SILABS_DBUS_USART0_CTS(0x3, 0x1)
#define USART0_CTS_PD2 SILABS_DBUS_USART0_CTS(0x3, 0x2)
#define USART0_CTS_PD3 SILABS_DBUS_USART0_CTS(0x3, 0x3)
#define USART0_CTS_PD4 SILABS_DBUS_USART0_CTS(0x3, 0x4)
#define USART0_CTS_PD5 SILABS_DBUS_USART0_CTS(0x3, 0x5)

#define ABUS_AEVEN0_IADC0     SILABS_ABUS(0x0, 0x0, 0x1)
#define ABUS_AEVEN0_ACMP0     SILABS_ABUS(0x0, 0x0, 0x2)
#define ABUS_AEVEN0_ACMP1     SILABS_ABUS(0x0, 0x0, 0x3)
#define ABUS_AEVEN0_VDAC0CH0  SILABS_ABUS(0x0, 0x0, 0x4)
#define ABUS_AEVEN0_VDAC1CH0  SILABS_ABUS(0x0, 0x0, 0x5)
#define ABUS_AEVEN1_IADC0     SILABS_ABUS(0x0, 0x1, 0x1)
#define ABUS_AEVEN1_ACMP0     SILABS_ABUS(0x0, 0x1, 0x2)
#define ABUS_AEVEN1_ACMP1     SILABS_ABUS(0x0, 0x1, 0x3)
#define ABUS_AEVEN1_VDAC0CH1  SILABS_ABUS(0x0, 0x1, 0x4)
#define ABUS_AEVEN1_VDAC1CH1  SILABS_ABUS(0x0, 0x1, 0x5)
#define ABUS_AODD0_IADC0      SILABS_ABUS(0x0, 0x2, 0x1)
#define ABUS_AODD0_ACMP0      SILABS_ABUS(0x0, 0x2, 0x2)
#define ABUS_AODD0_ACMP1      SILABS_ABUS(0x0, 0x2, 0x3)
#define ABUS_AODD0_VDAC0CH0   SILABS_ABUS(0x0, 0x2, 0x4)
#define ABUS_AODD0_VDAC1CH0   SILABS_ABUS(0x0, 0x2, 0x5)
#define ABUS_AODD1_IADC0      SILABS_ABUS(0x0, 0x3, 0x1)
#define ABUS_AODD1_ACMP0      SILABS_ABUS(0x0, 0x3, 0x2)
#define ABUS_AODD1_ACMP1      SILABS_ABUS(0x0, 0x3, 0x3)
#define ABUS_AODD1_VDAC0CH1   SILABS_ABUS(0x0, 0x3, 0x4)
#define ABUS_AODD1_VDAC1CH1   SILABS_ABUS(0x0, 0x3, 0x5)
#define ABUS_BEVEN0_IADC0     SILABS_ABUS(0x1, 0x0, 0x1)
#define ABUS_BEVEN0_ACMP0     SILABS_ABUS(0x1, 0x0, 0x2)
#define ABUS_BEVEN0_ACMP1     SILABS_ABUS(0x1, 0x0, 0x3)
#define ABUS_BEVEN0_VDAC0CH0  SILABS_ABUS(0x1, 0x0, 0x4)
#define ABUS_BEVEN0_VDAC1CH0  SILABS_ABUS(0x1, 0x0, 0x5)
#define ABUS_BEVEN1_IADC0     SILABS_ABUS(0x1, 0x1, 0x1)
#define ABUS_BEVEN1_ACMP0     SILABS_ABUS(0x1, 0x1, 0x2)
#define ABUS_BEVEN1_ACMP1     SILABS_ABUS(0x1, 0x1, 0x3)
#define ABUS_BEVEN1_VDAC0CH1  SILABS_ABUS(0x1, 0x1, 0x4)
#define ABUS_BEVEN1_VDAC1CH1  SILABS_ABUS(0x1, 0x1, 0x5)
#define ABUS_BODD0_IADC0      SILABS_ABUS(0x1, 0x2, 0x1)
#define ABUS_BODD0_ACMP0      SILABS_ABUS(0x1, 0x2, 0x2)
#define ABUS_BODD0_ACMP1      SILABS_ABUS(0x1, 0x2, 0x3)
#define ABUS_BODD0_VDAC0CH0   SILABS_ABUS(0x1, 0x2, 0x4)
#define ABUS_BODD0_VDAC1CH0   SILABS_ABUS(0x1, 0x2, 0x5)
#define ABUS_BODD1_IADC0      SILABS_ABUS(0x1, 0x3, 0x1)
#define ABUS_BODD1_ACMP0      SILABS_ABUS(0x1, 0x3, 0x2)
#define ABUS_BODD1_ACMP1      SILABS_ABUS(0x1, 0x3, 0x3)
#define ABUS_BODD1_VDAC0CH1   SILABS_ABUS(0x1, 0x3, 0x4)
#define ABUS_BODD1_VDAC1CH1   SILABS_ABUS(0x1, 0x3, 0x5)
#define ABUS_CDEVEN0_IADC0    SILABS_ABUS(0x2, 0x0, 0x1)
#define ABUS_CDEVEN0_ACMP0    SILABS_ABUS(0x2, 0x0, 0x2)
#define ABUS_CDEVEN0_ACMP1    SILABS_ABUS(0x2, 0x0, 0x3)
#define ABUS_CDEVEN0_VDAC0CH0 SILABS_ABUS(0x2, 0x0, 0x4)
#define ABUS_CDEVEN0_VDAC1CH0 SILABS_ABUS(0x2, 0x0, 0x5)
#define ABUS_CDEVEN1_IADC0    SILABS_ABUS(0x2, 0x1, 0x1)
#define ABUS_CDEVEN1_ACMP0    SILABS_ABUS(0x2, 0x1, 0x2)
#define ABUS_CDEVEN1_ACMP1    SILABS_ABUS(0x2, 0x1, 0x3)
#define ABUS_CDEVEN1_VDAC0CH1 SILABS_ABUS(0x2, 0x1, 0x4)
#define ABUS_CDEVEN1_VDAC1CH1 SILABS_ABUS(0x2, 0x1, 0x5)
#define ABUS_CDODD0_IADC0     SILABS_ABUS(0x2, 0x2, 0x1)
#define ABUS_CDODD0_ACMP0     SILABS_ABUS(0x2, 0x2, 0x2)
#define ABUS_CDODD0_ACMP1     SILABS_ABUS(0x2, 0x2, 0x3)
#define ABUS_CDODD0_VDAC0CH0  SILABS_ABUS(0x2, 0x2, 0x4)
#define ABUS_CDODD0_VDAC1CH0  SILABS_ABUS(0x2, 0x2, 0x5)
#define ABUS_CDODD1_IADC0     SILABS_ABUS(0x2, 0x3, 0x1)
#define ABUS_CDODD1_ACMP0     SILABS_ABUS(0x2, 0x3, 0x2)
#define ABUS_CDODD1_ACMP1     SILABS_ABUS(0x2, 0x3, 0x3)
#define ABUS_CDODD1_VDAC0CH1  SILABS_ABUS(0x2, 0x3, 0x4)
#define ABUS_CDODD1_VDAC1CH1  SILABS_ABUS(0x2, 0x3, 0x5)

#endif /* ZEPHYR_DT_BINDINGS_PINCTRL_SILABS_XG24_PINCTRL_H_ */
