/*
 * Copyright (c) 2022 Teslabs Engineering S.L.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_RESET_GD32F4XX_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_RESET_GD32F4XX_H_

#include "gd32-common.h"

/**
 * @name Register offsets
 * @{
 */

#define GD32_AHB1RST_OFFSET       0x10U
#define GD32_AHB2RST_OFFSET       0x14U
#define GD32_AHB3RST_OFFSET       0x18U
#define GD32_APB1RST_OFFSET       0x20U
#define GD32_APB2RST_OFFSET       0x24U
#define GD32_ADDAPB1RST_OFFSET    0xE0U

/** @} */

/**
 * @name Clock enable/disable definitions for peripherals
 * @{
 */

/* AHB1 peripherals */
#define GD32_RESET_GPIOA      GD32_RESET_CONFIG(AHB1RST, 0U)
#define GD32_RESET_GPIOB      GD32_RESET_CONFIG(AHB1RST, 1U)
#define GD32_RESET_GPIOC      GD32_RESET_CONFIG(AHB1RST, 2U)
#define GD32_RESET_GPIOD      GD32_RESET_CONFIG(AHB1RST, 3U)
#define GD32_RESET_GPIOE      GD32_RESET_CONFIG(AHB1RST, 4U)
#define GD32_RESET_GPIOF      GD32_RESET_CONFIG(AHB1RST, 5U)
#define GD32_RESET_GPIOG      GD32_RESET_CONFIG(AHB1RST, 6U)
#define GD32_RESET_GPIOH      GD32_RESET_CONFIG(AHB1RST, 7U)
#define GD32_RESET_GPIOI      GD32_RESET_CONFIG(AHB1RST, 8U)
#define GD32_RESET_CRC        GD32_RESET_CONFIG(AHB1RST, 12U)
#define GD32_RESET_BKPSRAM    GD32_RESET_CONFIG(AHB1RST, 18U)
#define GD32_RESET_TCMSRAM    GD32_RESET_CONFIG(AHB1RST, 20U)
#define GD32_RESET_DMA0       GD32_RESET_CONFIG(AHB1RST, 21U)
#define GD32_RESET_DMA1       GD32_RESET_CONFIG(AHB1RST, 22U)
#define GD32_RESET_IPA        GD32_RESET_CONFIG(AHB1RST, 23U)
#define GD32_RESET_ENET       GD32_RESET_CONFIG(AHB1RST, 25U)
#define GD32_RESET_ENETTX     GD32_RESET_CONFIG(AHB1RST, 26U)
#define GD32_RESET_ENETRX     GD32_RESET_CONFIG(AHB1RST, 27U)
#define GD32_RESET_ENETPTP    GD32_RESET_CONFIG(AHB1RST, 28U)
#define GD32_RESET_USBHS      GD32_RESET_CONFIG(AHB1RST, 29U)
#define GD32_RESET_USBHSULPI  GD32_RESET_CONFIG(AHB1RST, 30U)

/* AHB2 peripherals */
#define GD32_RESET_DCI        GD32_RESET_CONFIG(AHB2RST, 0U)
#define GD32_RESET_TRNG       GD32_RESET_CONFIG(AHB2RST, 6U)
#define GD32_RESET_USBFS      GD32_RESET_CONFIG(AHB2RST, 7U)

/* AHB3 peripherals */
#define GD32_RESET_EXMC       GD32_RESET_CONFIG(AHB3RST, 0U)

/* APB1 peripherals */
#define GD32_RESET_TIMER1     GD32_RESET_CONFIG(APB1RST, 0U)
#define GD32_RESET_TIMER2     GD32_RESET_CONFIG(APB1RST, 1U)
#define GD32_RESET_TIMER3     GD32_RESET_CONFIG(APB1RST, 2U)
#define GD32_RESET_TIMER4     GD32_RESET_CONFIG(APB1RST, 3U)
#define GD32_RESET_TIMER5     GD32_RESET_CONFIG(APB1RST, 4U)
#define GD32_RESET_TIMER6     GD32_RESET_CONFIG(APB1RST, 5U)
#define GD32_RESET_TIMER11    GD32_RESET_CONFIG(APB1RST, 6U)
#define GD32_RESET_TIMER12    GD32_RESET_CONFIG(APB1RST, 7U)
#define GD32_RESET_TIMER13    GD32_RESET_CONFIG(APB1RST, 8U)
#define GD32_RESET_WWDGT      GD32_RESET_CONFIG(APB1RST, 11U)
#define GD32_RESET_SPI1       GD32_RESET_CONFIG(APB1RST, 14U)
#define GD32_RESET_SPI2       GD32_RESET_CONFIG(APB1RST, 15U)
#define GD32_RESET_USART1     GD32_RESET_CONFIG(APB1RST, 17U)
#define GD32_RESET_USART2     GD32_RESET_CONFIG(APB1RST, 18U)
#define GD32_RESET_UART3      GD32_RESET_CONFIG(APB1RST, 19U)
#define GD32_RESET_UART4      GD32_RESET_CONFIG(APB1RST, 20U)
#define GD32_RESET_I2C0       GD32_RESET_CONFIG(APB1RST, 21U)
#define GD32_RESET_I2C1       GD32_RESET_CONFIG(APB1RST, 22U)
#define GD32_RESET_I2C2       GD32_RESET_CONFIG(APB1RST, 23U)
#define GD32_RESET_CAN0       GD32_RESET_CONFIG(APB1RST, 25U)
#define GD32_RESET_CAN1       GD32_RESET_CONFIG(APB1RST, 26U)
#define GD32_RESET_PMU        GD32_RESET_CONFIG(APB1RST, 28U)
#define GD32_RESET_DAC        GD32_RESET_CONFIG(APB1RST, 29U)
#define GD32_RESET_UART6      GD32_RESET_CONFIG(APB1RST, 30U)
#define GD32_RESET_UART7      GD32_RESET_CONFIG(APB1RST, 31U)
#define GD32_RESET_RTC        GD32_RESET_CONFIG(BDCTL, 15U)

/* APB2 peripherals */
#define GD32_RESET_TIMER0     GD32_RESET_CONFIG(APB2RST, 0U)
#define GD32_RESET_TIMER7     GD32_RESET_CONFIG(APB2RST, 1U)
#define GD32_RESET_USART0     GD32_RESET_CONFIG(APB2RST, 4U)
#define GD32_RESET_USART5     GD32_RESET_CONFIG(APB2RST, 5U)
#define GD32_RESET_ADC0       GD32_RESET_CONFIG(APB2RST, 8U)
#define GD32_RESET_ADC1       GD32_RESET_CONFIG(APB2RST, 9U)
#define GD32_RESET_ADC2       GD32_RESET_CONFIG(APB2RST, 10U)
#define GD32_RESET_SDIO       GD32_RESET_CONFIG(APB2RST, 11U)
#define GD32_RESET_SPI0       GD32_RESET_CONFIG(APB2RST, 12U)
#define GD32_RESET_SPI3       GD32_RESET_CONFIG(APB2RST, 13U)
#define GD32_RESET_SYSCFG     GD32_RESET_CONFIG(APB2RST, 14U)
#define GD32_RESET_TIMER8     GD32_RESET_CONFIG(APB2RST, 16U)
#define GD32_RESET_TIMER9     GD32_RESET_CONFIG(APB2RST, 17U)
#define GD32_RESET_TIMER10    GD32_RESET_CONFIG(APB2RST, 18U)
#define GD32_RESET_SPI4       GD32_RESET_CONFIG(APB2RST, 20U)
#define GD32_RESET_SPI5       GD32_RESET_CONFIG(APB2RST, 21U)
#define GD32_RESET_TLI        GD32_RESET_CONFIG(APB2RST, 26U)

/* APB1 additional peripherals */
#define GD32_RESET_CTC        GD32_RESET_CONFIG(ADDAPB1RST, 27U)
#define GD32_RESET_IREF       GD32_RESET_CONFIG(ADDAPB1RST, 31U)

/** @} */

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_RESET_GD32F4XX_H_ */
