/*
 * Copyright (c) 2023 deveritec GmbH
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_TMAG5273_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_TMAG5273_H_

#include <zephyr/dt-bindings/dt-util.h>

/* Operating Mode */
#define TMAG5273_DT_OPER_MODE_CONTINUOUS 0
#define TMAG5273_DT_OPER_MODE_STANDBY    1

/* Axis */
#define TMAG5273_DT_AXIS_NONE 0x0
#define TMAG5273_DT_AXIS_X    0x1
#define TMAG5273_DT_AXIS_Y    0x2
#define TMAG5273_DT_AXIS_Z    0x4
#define TMAG5273_DT_AXIS_XY   (TMAG5273_DT_AXIS_X | TMAG5273_DT_AXIS_Y)
#define TMAG5273_DT_AXIS_XZ   (TMAG5273_DT_AXIS_X | TMAG5273_DT_AXIS_Z)
#define TMAG5273_DT_AXIS_YZ   (TMAG5273_DT_AXIS_Y | TMAG5273_DT_AXIS_Z)
#define TMAG5273_DT_AXIS_XYZ  (TMAG5273_DT_AXIS_X | TMAG5273_DT_AXIS_Y | TMAG5273_DT_AXIS_Z)
#define TMAG5273_DT_AXIS_XYX  0x8
#define TMAG5273_DT_AXIS_YXY  0x9
#define TMAG5273_DT_AXIS_YZY  0xA
#define TMAG5273_DT_AXIS_XZX  0xB

/* Range */
#define TMAG5273_DT_AXIS_RANGE_LOW     0
#define TMAG5273_DT_AXIS_RANGE_HIGH    1
#define TMAG5273_DT_AXIS_RANGE_RUNTIME 2

/* Interrupt-Mode */
#define TMAG5273_DT_INT_THROUGH_INT         0
#define TMAG5273_DT_INT_THROUGH_INT_EXC_I2C 1
#define TMAG5273_DT_INT_THROUGH_SCL         2
#define TMAG5273_DT_INT_THROUGH_SCL_EXC_I2C 3

/* Threshold crossings */
#define TMAG5273_DT_THRX_COUNT_1 0
#define TMAG5273_DT_THRX_COUNT_4 1

/* Threshold direction */
#define TMAG5273_DT_THRX_ABOVE   0
#define TMAG5273_DT_THRX_BELOW   1
#define TMAG5273_DT_THRX_OUTSIDE 2
#define TMAG5273_DT_THRX_INSIDE  3

/* Temperature coefficient */
#define TMAG5273_DT_TEMP_COEFF_NONE    0
#define TMAG5273_DT_TEMP_COEFF_NDBFE   1
#define TMAG5273_DT_TEMP_COEFF_CERAMIC 2

/* Angle/Magnitude calculation */
#define TMAG5273_DT_ANGLE_MAG_NONE    0
#define TMAG5273_DT_ANGLE_MAG_XY      1
#define TMAG5273_DT_ANGLE_MAG_YZ      2
#define TMAG5273_DT_ANGLE_MAG_XZ      3
#define TMAG5273_DT_ANGLE_MAG_RUNTIME 4

/* Channel Magnitude Gain Correction */
#define TMAG5273_DT_CORRECTION_CH_1 0
#define TMAG5273_DT_CORRECTION_CH_2 1

/* Averaging */
#define TMAG5273_DT_AVERAGING_NONE 0
#define TMAG5273_DT_AVERAGING_2X   1
#define TMAG5273_DT_AVERAGING_4X   2
#define TMAG5273_DT_AVERAGING_8X   3
#define TMAG5273_DT_AVERAGING_16X  4
#define TMAG5273_DT_AVERAGING_32X  5

/* Sleeptime */
#define TMAG5273_DT_SLEEPTIME_1MS     0
#define TMAG5273_DT_SLEEPTIME_5MS     1
#define TMAG5273_DT_SLEEPTIME_10MS    2
#define TMAG5273_DT_SLEEPTIME_15MS    3
#define TMAG5273_DT_SLEEPTIME_20MS    4
#define TMAG5273_DT_SLEEPTIME_30MS    5
#define TMAG5273_DT_SLEEPTIME_50MS    6
#define TMAG5273_DT_SLEEPTIME_100MS   7
#define TMAG5273_DT_SLEEPTIME_500MS   8
#define TMAG5273_DT_SLEEPTIME_1000MS  9
#define TMAG5273_DT_SLEEPTIME_2000MS  10
#define TMAG5273_DT_SLEEPTIME_5000MS  11
#define TMAG5273_DT_SLEEPTIME_20000MS 12

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_TMAG5273_H_ */
