/* SPDX-License-Identifier: Apache-2.0 */

#include <zephyr/linker/iterable_sections.h>

#if defined(CONFIG_LOG_FMT_SECTION_STRIP) && defined(DEVNULL_REGION)
	SECTION_PROLOGUE(log_strings,(COPY),SUBALIGN(Z_LINK_ITERABLE_SUBALIGN))
	{
		Z_LINK_ITERABLE(log_strings);
	} GROUP_ROM_LINK_IN(DEVNULL_REGION, DEVNULL_REGION)

	SECTION_PROLOGUE(log_stmesp_ptr,(COPY),SUBALIGN(Z_LINK_ITERABLE_SUBALIGN))
	{
		Z_LINK_ITERABLE(log_stmesp_ptr);
	} GROUP_ROM_LINK_IN(DEVNULL_REGION, DEVNULL_REGION)

	SECTION_PROLOGUE(log_stmesp_str,(COPY),SUBALIGN(Z_LINK_ITERABLE_SUBALIGN))
	{
		Z_LINK_ITERABLE(log_stmesp_str);
	} GROUP_ROM_LINK_IN(DEVNULL_REGION, DEVNULL_REGION)
#else
	ITERABLE_SECTION_ROM(log_strings, Z_LINK_ITERABLE_SUBALIGN)

	ITERABLE_SECTION_ROM(log_stmesp_ptr, Z_LINK_ITERABLE_SUBALIGN)

	ITERABLE_SECTION_ROM(log_stmesp_str, Z_LINK_ITERABLE_SUBALIGN)
#endif

	ITERABLE_SECTION_ROM(log_const, Z_LINK_ITERABLE_SUBALIGN)

	ITERABLE_SECTION_ROM(log_backend, Z_LINK_ITERABLE_SUBALIGN)

	ITERABLE_SECTION_ROM(log_link, Z_LINK_ITERABLE_SUBALIGN)
