/*
 * Copyright (c) 2024, Nordic Semiconductor ASA
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef NRFX_KCONFIG_H__
#define NRFX_KCONFIG_H__

/*
 * These are mappings of Kconfig options enabling nrfx drivers and particular
 * peripheral instances to the corresponding symbols used inside of nrfx.
 * Please note that only subsets of these entries are used for particular SoCs
 * supported by nrfx (see the corresponding nrfx_config_*.h files).
 */

#ifdef CONFIG_NRFX_ADC
#define NRFX_ADC_ENABLED 1
#endif
#ifdef CONFIG_NRFX_ADC_LOG
#define NRFX_ADC_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_CLOCK
#define NRFX_CLOCK_ENABLED 1
#endif
#ifdef CONFIG_NRFX_CLOCK_LOG
#define NRFX_CLOCK_CONFIG_LOG_ENABLED 1
#endif
#ifdef CONFIG_NRFX_CLOCK_USE_LFRC_CALIBRATION
#define NRFX_CLOCK_CONFIG_USE_LFRC_CALIBRATION 1
#endif

#ifdef CONFIG_NRFX_CLOCK_LF_SRC_RC
#if defined(CONFIG_SOC_SERIES_NRF91X) || defined(CONFIG_SOC_COMPATIBLE_NRF53X)
#define NRFX_CLOCK_CONFIG_LF_SRC 1
#else
#define NRFX_CLOCK_CONFIG_LF_SRC 0
#endif
#endif

#ifdef CONFIG_NRFX_CLOCK_LF_SRC_XTAL
#if defined(CONFIG_SOC_SERIES_NRF91X) || defined(CONFIG_SOC_COMPATIBLE_NRF53X)
#define NRFX_CLOCK_CONFIG_LF_SRC 2
#else
#define NRFX_CLOCK_CONFIG_LF_SRC 1
#endif
#endif

#ifdef CONFIG_NRFX_CLOCK_LF_SRC_SYNTH
#ifdef CONFIG_SOC_COMPATIBLE_NRF53X
#define NRFX_CLOCK_CONFIG_LF_SRC 3
#else
#define NRFX_CLOCK_CONFIG_LF_SRC 2
#endif
#endif

#ifdef CONFIG_NRFX_CLOCK_LF_SRC_LOW_SWING
#define NRFX_CLOCK_CONFIG_LF_SRC 131073
#endif

#ifdef CONFIG_NRFX_CLOCK_LF_SRC_FULL_SWING
#define NRFX_CLOCK_CONFIG_LF_SRC 196609
#endif

#ifdef CONFIG_NRFX_CLOCK_LF_CAL_ENABLED
#define NRFX_CLOCK_CONFIG_LF_CAL_ENABLED 1
#endif

#ifdef CONFIG_NRFX_CLOCK_LFXO_TWO_STAGE_ENABLED
#define NRFX_CLOCK_CONFIG_LFXO_TWO_STAGE_ENABLED 1
#endif

#ifdef CONFIG_NRFX_COMP
#define NRFX_COMP_ENABLED 1
#endif
#ifdef CONFIG_NRFX_COMP_LOG
#define NRFX_COMP_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_CRACEN
#define NRFX_CRACEN_ENABLED 1
#endif
#ifdef CONFIG_NRFX_CRACEN_BSIM_SUPPORT
#define NRFX_CRACEN_BSIM_SUPPORT 1
#endif

#ifdef CONFIG_NRFX_EGU
#define NRFX_EGU_ENABLED 1
#endif
#ifdef CONFIG_NRFX_EGU_LOG
#define NRFX_EGU_CONFIG_LOG_ENABLED 1
#endif
#ifdef CONFIG_NRFX_EGU0
#define NRFX_EGU0_ENABLED 1
#endif
#ifdef CONFIG_NRFX_EGU1
#define NRFX_EGU1_ENABLED 1
#endif
#ifdef CONFIG_NRFX_EGU2
#define NRFX_EGU2_ENABLED 1
#endif
#ifdef CONFIG_NRFX_EGU3
#define NRFX_EGU3_ENABLED 1
#endif
#ifdef CONFIG_NRFX_EGU4
#define NRFX_EGU4_ENABLED 1
#endif
#ifdef CONFIG_NRFX_EGU5
#define NRFX_EGU5_ENABLED 1
#endif
#ifdef CONFIG_NRFX_EGU10
#define NRFX_EGU10_ENABLED 1
#endif
#ifdef CONFIG_NRFX_EGU20
#define NRFX_EGU20_ENABLED 1
#endif
#ifdef CONFIG_NRFX_EGU020
#define NRFX_EGU020_ENABLED 1
#endif
#ifdef CONFIG_NRFX_EGU130
#define NRFX_EGU130_ENABLED 1
#endif

#ifdef CONFIG_NRFX_GRTC
#define NRFX_GRTC_ENABLED 1
#endif
#ifdef CONFIG_NRFX_GRTC_LOG
#define NRFX_GRTC_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRF_GRTC_TIMER_CLOCK_MANAGEMENT
#define NRF_GRTC_HAS_EXTENDED 1
#define NRFX_GRTC_CONFIG_LFCLK_SELECT_AT_INIT 0
#endif
#ifdef CONFIG_NRF_GRTC_TIMER_AUTO_KEEP_ALIVE
#define NRFX_GRTC_CONFIG_AUTOEN 1
#endif
#ifdef CONFIG_NRF_GRTC_START_SYSCOUNTER
#define NRFX_GRTC_CONFIG_AUTOSTART 1
#endif

#ifdef CONFIG_NRFX_GPIOTE
#define NRFX_GPIOTE_ENABLED 1
#endif
#ifdef CONFIG_NRFX_GPIOTE_LOG
#define NRFX_GPIOTE_CONFIG_LOG_ENABLED 1
#endif
#ifdef CONFIG_NRFX_GPIOTE0
#define NRFX_GPIOTE0_ENABLED 1
#endif
#ifdef CONFIG_NRFX_GPIOTE1
#define NRFX_GPIOTE1_ENABLED 1
#endif
#ifdef CONFIG_NRFX_GPIOTE20
#define NRFX_GPIOTE20_ENABLED 1
#endif
#ifdef CONFIG_NRFX_GPIOTE30
#define NRFX_GPIOTE30_ENABLED 1
#endif
#ifdef CONFIG_NRFX_GPIOTE130
#define NRFX_GPIOTE130_ENABLED 1
#endif
#ifdef CONFIG_NRFX_GPIOTE131
#define NRFX_GPIOTE131_ENABLED 1
#endif
#ifdef CONFIG_NRFX_GPIOTE_NONUNIFORM_INSTANCES
#define NRFX_GPIOTE_CONFIG_NONUNIFORM_INSTANCES 1
#endif

#ifdef CONFIG_NRFX_GPIOTE_NUM_OF_EVT_HANDLERS
#define NRFX_GPIOTE_CONFIG_NUM_OF_EVT_HANDLERS CONFIG_NRFX_GPIOTE_NUM_OF_EVT_HANDLERS
#endif

#ifdef CONFIG_NRFX_I2S
#define NRFX_I2S_ENABLED 1
#endif
#ifdef CONFIG_NRFX_I2S_LOG
#define NRFX_I2S_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_IPC
#define NRFX_IPC_ENABLED 1
#endif
#ifdef CONFIG_NRFX_IPC_LOG
#define NRFX_IPC_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_LPCOMP
#define NRFX_LPCOMP_ENABLED 1
#endif
#ifdef CONFIG_NRFX_LPCOMP_LOG
#define NRFX_LPCOMP_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_MRAMC
#define NRFX_MRAMC_ENABLED 1
#endif
#ifdef CONFIG_NRFX_MRAMC_LOG
#define NRFX_MRAMC_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_NFCT
#define NRFX_NFCT_ENABLED 1
#endif
#ifdef CONFIG_NRFX_NFCT_LOG
#define NRFX_NFCT_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_NVMC
#define NRFX_NVMC_ENABLED 1
#endif
#ifdef CONFIG_NRFX_NVMC_LOG
#define NRFX_NVMC_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_PDM
#define NRFX_PDM_ENABLED 1
#endif
#ifdef CONFIG_NRFX_PDM_LOG
#define NRFX_PDM_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_POWER
#define NRFX_POWER_ENABLED 1
#endif
#ifdef CONFIG_NRFX_POWER_LOG
#define NRFX_POWER_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_PRS
#define NRFX_PRS_ENABLED 1
#endif
#ifdef CONFIG_NRFX_PRS_LOG
#define NRFX_PRS_CONFIG_LOG_ENABLED 1
#endif
#ifdef CONFIG_NRFX_PRS_BOX_0
#define NRFX_PRS_BOX_0_ENABLED 1
#endif
#ifdef CONFIG_NRFX_PRS_BOX_1
#define NRFX_PRS_BOX_1_ENABLED 1
#endif
#ifdef CONFIG_NRFX_PRS_BOX_2
#define NRFX_PRS_BOX_2_ENABLED 1
#endif
#ifdef CONFIG_NRFX_PRS_BOX_3
#define NRFX_PRS_BOX_3_ENABLED 1
#endif
#ifdef CONFIG_NRFX_PRS_BOX_4
#define NRFX_PRS_BOX_4_ENABLED 1
#endif

#ifdef CONFIG_NRFX_PWM
#define NRFX_PWM_ENABLED 1
#endif
#ifdef CONFIG_NRFX_PWM_LOG
#define NRFX_PWM_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_QDEC
#define NRFX_QDEC_ENABLED 1
#endif
#ifdef CONFIG_NRFX_QDEC_LOG
#define NRFX_QDEC_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_QSPI
#define NRFX_QSPI_ENABLED 1
#endif
#ifdef CONFIG_NRFX_QSPI_LOG
#define NRFX_QSPI_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_RNG
#define NRFX_RNG_ENABLED 1
#endif
#ifdef CONFIG_NRFX_RNG_LOG
#define NRFX_RNG_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_RRAMC
#define NRFX_RRAMC_ENABLED 1
#endif

#ifdef CONFIG_NRFX_RTC
#define NRFX_RTC_ENABLED 1
#endif
#ifdef CONFIG_NRFX_RTC_LOG
#define NRFX_RTC_CONFIG_LOG_ENABLED 1
#endif
#ifdef CONFIG_NRFX_RTC0
#define NRFX_RTC0_ENABLED 1
#endif
#ifdef CONFIG_NRFX_RTC1
#define NRFX_RTC1_ENABLED 1
#endif
#ifdef CONFIG_NRFX_RTC2
#define NRFX_RTC2_ENABLED 1
#endif
#ifdef CONFIG_NRFX_RTC130
#define NRFX_RTC130_ENABLED 1
#endif
#ifdef CONFIG_NRFX_RTC131
#define NRFX_RTC131_ENABLED 1
#endif

#ifdef CONFIG_NRFX_SAADC
#define NRFX_SAADC_ENABLED 1
#endif
#ifdef CONFIG_NRFX_SAADC_LOG
#define NRFX_SAADC_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_SPI
#define NRFX_SPI_ENABLED 1
#endif
#ifdef CONFIG_NRFX_SPI_LOG
#define NRFX_SPI_CONFIG_LOG_ENABLED 1
#endif
#ifdef CONFIG_NRFX_SPI0
#define NRFX_SPI0_ENABLED 1
#endif
#ifdef CONFIG_NRFX_SPI1
#define NRFX_SPI1_ENABLED 1
#endif
#ifdef CONFIG_NRFX_SPI2
#define NRFX_SPI2_ENABLED 1
#endif

#ifdef CONFIG_NRFX_SPIM
#define NRFX_SPIM_ENABLED 1
#endif
#ifdef CONFIG_NRFX_SPIM_LOG
#define NRFX_SPIM_CONFIG_LOG_ENABLED 1
#endif
#ifdef CONFIG_NRF52_ANOMALY_198_WORKAROUND
#define NRF52_ERRATA_198_ENABLE_WORKAROUND 1
#endif
#ifdef CONFIG_NRF52_ANOMALY_58_WORKAROUND
#define NRF52_ERRATA_58_ENABLE_WORKAROUND 1
#endif

#define NRFX_SPIM_DT_HAS_RX_DELAY(node) DT_PROP(node, rx_delay_supported) +

#ifndef NRFX_SPIM_EXTENDED_ENABLED
#if DT_FOREACH_STATUS_OKAY(nordic_nrf_spim, NRFX_SPIM_DT_HAS_RX_DELAY) 0
#define NRFX_SPIM_EXTENDED_ENABLED 1
#endif
#endif

#ifdef CONFIG_NRFX_SPIS
#define NRFX_SPIS_ENABLED 1
#endif
#ifdef CONFIG_NRFX_SPIS_LOG
#define NRFX_SPIS_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_SYSTICK
#define NRFX_SYSTICK_ENABLED 1
#endif
#ifdef CONFIG_NRFX_SYSTICK_LOG
#define NRFX_SYSTICK_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_TBM
#define NRFX_TBM_ENABLED 1
#endif

#ifdef CONFIG_NRFX_TEMP
#define NRFX_TEMP_ENABLED 1
#endif
#ifdef CONFIG_NRFX_TEMP_LOG
#define NRFX_TEMP_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_TIMER
#define NRFX_TIMER_ENABLED 1
#endif

#ifdef CONFIG_NRFX_TWI
#define NRFX_TWI_ENABLED 1
#endif
#ifdef CONFIG_NRFX_TWI_LOG
#define NRFX_TWI_CONFIG_LOG_ENABLED 1
#endif
#ifdef CONFIG_NRFX_TWI0
#define NRFX_TWI0_ENABLED 1
#endif
#ifdef CONFIG_NRFX_TWI1
#define NRFX_TWI1_ENABLED 1
#endif

#ifdef CONFIG_NRFX_TWIM
#define NRFX_TWIM_ENABLED 1
#endif
#ifdef CONFIG_NRFX_TWIM_LOG
#define NRFX_TWIM_CONFIG_LOG_ENABLED 1
#endif
#ifdef CONFIG_NRF52_ANOMALY_219_WORKAROUND
#define NRF52_ERRATA_219_ENABLE_WORKAROUND 1
#endif
#ifdef CONFIG_SOC_NRF53_ANOMALY_47_WORKAROUND
#define NRF53_ERRATA_47_ENABLE_WORKAROUND 1
#endif

#ifdef CONFIG_NRFX_TWIS
#define NRFX_TWIS_ENABLED 1
#endif
#ifdef CONFIG_NRFX_TWIS_LOG
#define NRFX_TWIS_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_UART
#define NRFX_UART_ENABLED 1
#endif
#ifdef CONFIG_NRFX_UART_LOG
#define NRFX_UART_CONFIG_LOG_ENABLED 1
#endif
#ifdef CONFIG_NRFX_UART0
#define NRFX_UART0_ENABLED 1
#endif

#ifdef CONFIG_NRFX_UARTE
#define NRFX_UARTE_ENABLED 1
#endif
#ifdef CONFIG_NRFX_UARTE_LOG
#define NRFX_UARTE_CONFIG_LOG_ENABLED 1
#endif
#ifdef CONFIG_NRFX_UARTE_CONFIG_SKIP_GPIO_CONFIG
#define NRFX_UARTE_CONFIG_SKIP_GPIO_CONFIG 1
#endif
#ifdef CONFIG_NRFX_UARTE_CONFIG_SKIP_PSEL_CONFIG
#define NRFX_UARTE_CONFIG_SKIP_PSEL_CONFIG 1
#endif
#ifdef CONFIG_NRFX_UARTE_CONFIG_TX_LINK
#define NRFX_UARTE_CONFIG_TX_LINK 1
#endif
#ifdef CONFIG_NRFX_UARTE_CONFIG_RX_CACHE_ENABLED
#define NRFX_UARTE_CONFIG_RX_CACHE_ENABLED 1
#endif

#ifdef CONFIG_NRFX_USBREG
#define NRFX_USBREG_ENABLED 1
#endif
#ifdef CONFIG_NRFX_USBREG_LOG
#define NRFX_USBREG_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRFX_WDT
#define NRFX_WDT_ENABLED 1
#endif
#ifdef CONFIG_WDT_NRFX_NO_IRQ
#define NRFX_WDT_CONFIG_NO_IRQ 1
#endif
#ifdef CONFIG_NRFX_WDT_LOG
#define NRFX_WDT_CONFIG_LOG_ENABLED 1
#endif

#ifdef CONFIG_NRF52_ANOMALY_109_WORKAROUND
#define NRF52_ERRATA_109_ENABLE_WORKAROUND 1
#define NRFX_PWM_NRF52_ANOMALY_109_EGU_INSTANCE \
	CONFIG_NRF52_ANOMALY_109_WORKAROUND_EGU_INSTANCE
#endif

/* If local or global DPPIC peripherals are used, provide the following macro
 * definitions required by the interconnect/ipct layer:
 * - NRFX_IPCTx_PUB_CONFIG_ALLOWED_CHANNELS_MASK_BY_INST_NUM(inst_num)
 * - NRFX_IPCTx_SUB_CONFIG_ALLOWED_CHANNELS_MASK_BY_INST_NUM(inst_num)
 * - NRFX_IPCT_PUB_OR_SUB_MASK(inst_num)
 * - NRFX_IPCTx_CHANNELS_SINGLE_VAR_NAME_BY_INST_NUM(inst_num)
 * - NRFX_INTERCONNECT_IPCT_GLOBAL_DEFINE
 * - NRFX_INTERCONNECT_IPCT_LOCAL_DEFINE
 * based on information from devicetree.
 */
#if	DT_HAS_COMPAT_STATUS_OKAY(nordic_nrf_ipct_global) || \
	DT_HAS_COMPAT_STATUS_OKAY(nordic_nrf_ipct_local)
/* Channels masks generation. */
#define NRFX_CONFIG_IPCT_MASK_DT(node_id) \
	COND_CODE_1(DT_NODE_HAS_PROP(node_id, owned_channels), \
		(NRFX_CONFIG_MASK_DT(node_id, owned_channels)), \
		(COND_CODE_1(DT_NODE_HAS_COMPAT(node_id, nordic_nrf_ipct_local), \
			(BIT_MASK(DT_PROP(node_id, channels))), (0))))

#if defined(NRF_APPLICATION)
#define NRFX_CONFIG_IPCT_LOCAL_NODE DT_NODELABEL(cpuapp_ipct)
#elif defined(NRF_RADIOCORE)
#define NRFX_CONFIG_IPCT_LOCAL_NODE DT_NODELABEL(cpurad_ipct)
#endif
#define NRFX_CONFIG_IPCT_NODE_BY_INST_NUM(inst_num) \
	COND_CODE_1(IS_EMPTY(inst_num), \
		(NRFX_CONFIG_IPCT_LOCAL_NODE), \
		(DT_NODELABEL(_CONCAT(ipct, inst_num))))

#define NRFX_IPCTx_PUB_CONFIG_ALLOWED_CHANNELS_MASK_BY_INST_NUM(inst_num) \
	NRFX_CONFIG_IPCT_MASK_DT(NRFX_CONFIG_IPCT_NODE_BY_INST_NUM(inst_num))

#define NRFX_IPCTx_SUB_CONFIG_ALLOWED_CHANNELS_MASK_BY_INST_NUM(inst_num) \
	NRFX_CONFIG_IPCT_MASK_DT(NRFX_CONFIG_IPCT_NODE_BY_INST_NUM(inst_num))

#define NRFX_IPCT_PUB_OR_SUB_MASK(inst_num) \
	COND_CODE_1(IS_EMPTY(inst_num), \
		(DT_NODE_HAS_STATUS_OKAY(NRFX_CONFIG_IPCT_LOCAL_NODE)), \
		(DT_NODE_HAS_PROP(DT_NODELABEL(_CONCAT(ipct, inst_num)), owned_channels)))

/* Variables names generation. */
#define NRFX_CONFIG_IPCT_CHANNELS_ENTRY_NAME(node_id) _CONCAT(_CONCAT(m_, node_id), _channels)
#define NRFX_IPCTx_CHANNELS_SINGLE_VAR_NAME_BY_INST_NUM(inst_num) \
	COND_CODE_1(IS_EMPTY(inst_num), \
		(NRFX_CONFIG_IPCT_CHANNELS_ENTRY_NAME(NRFX_CONFIG_IPCT_LOCAL_NODE)), \
		(NRFX_CONFIG_IPCT_CHANNELS_ENTRY_NAME(DT_NODELABEL(_CONCAT(ipct, inst_num)))))

/* Variables entries generation. */
#define NRFX_CONFIG_IPCT_CHANNELS_ENTRY(node_id) \
	static nrfx_atomic_t NRFX_CONFIG_IPCT_CHANNELS_ENTRY_NAME(node_id) \
		__attribute__((used)) = \
		NRFX_CONFIG_IPCT_MASK_DT(node_id);
#define NRFX_INTERCONNECT_IPCT_LOCAL_DEFINE \
	DT_FOREACH_STATUS_OKAY(nordic_nrf_ipct_local, NRFX_CONFIG_IPCT_CHANNELS_ENTRY)
#define NRFX_INTERCONNECT_IPCT_GLOBAL_DEFINE \
	DT_FOREACH_STATUS_OKAY(nordic_nrf_ipct_global, NRFX_CONFIG_IPCT_CHANNELS_ENTRY)
#endif /* DT_HAS_COMPAT_STATUS_OKAY(nordic_nrf_ipct_global) || ... */

#endif /* NRFX_KCONFIG_H__ */
