# Copyright (c) 2020 Intel Corporation.
#
# SPDX-License-Identifier: Apache-2.0

import os
import pytest

# fixture cmdopt defined in conftest.py, it can be requested either in
# tests or in other fixtures

@pytest.fixture(autouse=True)
def pytest_cmdopt_handle(cmdopt):
    ''' An auto fixture, all tests automatically request this fixture.
        Argument "cmdopt" is a fixture defined in conftest.py, it returns
        the value of an option passed by twister, this fixture export
        that value to environment.
    '''
    print("handle cmdopt:")
    print(cmdopt)
    data_path = cmdopt
    os.environ['data_path'] = str(data_path)

def test_case(cmdopt):
    ''' Test cases make use of fixture cmdopt to get the value of "--cmdopt" option
        passed by twister. Actually, fixture cmdopt returns a path of the directory
        which holds the artifacts generated by ztest. The main work of test cases
        in this file is to check those stuff in that directory.
        This test case simply compare the return value of cmdopt with the
        environment variable exported by fixture pytest_cmdopt_handle.
    '''
    assert os.path.exists(cmdopt)

    print("run test cases in:")
    print(cmdopt)

def test_custom_arg(custom_pytest_arg):
    ''' Test passing of custom command line arguments to pytest.
    '''
    assert custom_pytest_arg == "foo"

if __name__ == "__main__":
    pytest.main()
