/*
 * Copyright (c) 2021,2025 Henrik Brix Andersen <henrik@brixandersen.dk>
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef _NEORV32_SOC_H
#define _NEORV32_SOC_H

/* System information (SYSINFO) register offsets */
#define NEORV32_SYSINFO_CLK         0x00U
#define NEORV32_SYSINFO_MISC        0x04U
#define NEORV32_SYSINFO_SOC         0x08U
#define NEORV32_SYSINFO_CACHE       0x0cU

/* System information (SYSINFO) MISC register bits */
#define NEORV32_SYSINFO_MISC_IMEM GENMASK(7, 0)
#define NEORV32_SYSINFO_MISC_DMEM GENMASK(15, 8)
#define NEORV32_SYSINFO_MISC_HART GENMASK(23, 16)
#define NEORV32_SYSINFO_MISC_BOOT GENMASK(31, 24)

/* System information (SYSINFO) SOC register bits */
#define NEORV32_SYSINFO_SOC_BOOTLOADER    BIT(0)
#define NEORV32_SYSINFO_SOC_XBUS          BIT(1)
#define NEORV32_SYSINFO_SOC_IMEM          BIT(2)
#define NEORV32_SYSINFO_SOC_DMEM          BIT(3)
#define NEORV32_SYSINFO_SOC_OCD           BIT(4)
#define NEORV32_SYSINFO_SOC_ICACHE        BIT(5)
#define NEORV32_SYSINFO_SOC_DCACHE        BIT(6)
#define NEORV32_SYSINFO_SOC_OCD_AUTH      BIT(11)
#define NEORV32_SYSINFO_SOC_IMEM_ROM      BIT(12)
#define NEORV32_SYSINFO_SOC_IO_TWD        BIT(13)
#define NEORV32_SYSINFO_SOC_IO_DMA        BIT(14)
#define NEORV32_SYSINFO_SOC_IO_GPIO       BIT(15)
#define NEORV32_SYSINFO_SOC_IO_CLINT      BIT(16)
#define NEORV32_SYSINFO_SOC_IO_UART0      BIT(17)
#define NEORV32_SYSINFO_SOC_IO_SPI        BIT(18)
#define NEORV32_SYSINFO_SOC_IO_TWI        BIT(19)
#define NEORV32_SYSINFO_SOC_IO_PWM        BIT(20)
#define NEORV32_SYSINFO_SOC_IO_WDT        BIT(21)
#define NEORV32_SYSINFO_SOC_IO_CFS        BIT(22)
#define NEORV32_SYSINFO_SOC_IO_TRNG       BIT(23)
#define NEORV32_SYSINFO_SOC_IO_SDI        BIT(24)
#define NEORV32_SYSINFO_SOC_IO_UART1      BIT(25)
#define NEORV32_SYSINFO_SOC_IO_NEOLED     BIT(26)
#define NEORV32_SYSINFO_SOC_IO_GPTMR      BIT(28)
#define NEORV32_SYSINFO_SOC_IO_SLINK      BIT(29)
#define NEORV32_SYSINFO_SOC_IO_ONEWIRE    BIT(30)

/* System information (SYSINFO) CACHE register bits */
#define NEORV32_SYSINFO_CACHE_INST_BLOCK_SIZE GENMASK(3, 0)
#define NEORV32_SYSINFO_CACHE_INST_NUM_BLOCKS GENMASK(7, 4)
#define NEORV32_SYSINFO_CACHE_DATA_BLOCK_SIZE GENMASK(11, 8)
#define NEORV32_SYSINFO_CACHE_DATA_NUM_BLOCKS GENMASK(15, 12)

#endif /* _NEORV32_SOC_H */
