/*
 * Copyright (c) 2024 Realtek Semiconductor Corp.
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#include <soc.h>
#include <ameba_soc.h>
#include <zephyr/device.h>
#include <zephyr/init.h>
#include <zephyr/kernel.h>
#include <zephyr/cache.h>
#include "ameba_system.h"

void z_arm_reset(void);

IMAGE2_ENTRY_SECTION
RAM_START_FUNCTION Img2EntryFun0 = {z_arm_reset, NULL, /* BOOT_RAM_WakeFromPG, */
				    (uint32_t)NewVectorTable};

static void app_vdd1833_detect(void)
{
	uint32_t temp;

	if (is_power_supply18() == false) {
		temp = sys_read32(SYSTEM_CTRL_BASE_HP + REG_HS_RFAFE_IND_VIO1833);
		temp |= BIT_RFAFE_IND_VIO1833;
		sys_write32(temp, SYSTEM_CTRL_BASE_HP + REG_HS_RFAFE_IND_VIO1833);
	}
}

void soc_early_init_hook(void)
{
	/*
	 * Cache is enabled by default at reset, disable it before
	 * sys_cache*-functions can enable them.
	 */
	Cache_Enable(DISABLE);
	sys_cache_data_enable();
	sys_cache_instr_enable();

	SystemSetCpuClk(CLK_KM4_200M);

	app_vdd1833_detect();
}
