/*
 * Copyright (c) 2025 Realtek, SIBG-SD7
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_SOC_REALTEK_RTS5912_REG_ESPI_H
#define ZEPHYR_SOC_REALTEK_RTS5912_REG_ESPI_H

struct espi_reg {
	uint32_t EPSTS;
	uint32_t EPCFG;
	uint32_t EPINTEN;
	const uint32_t EPRXINFO;
	uint32_t EPRXADRH;
	uint32_t EPRXADRL;
	uint32_t EPCPRADR;
	uint32_t EPCPRVLD;
	uint32_t EPBUF;
	uint32_t EPBUFSZ;
	uint32_t EPPTRCLR;
	uint32_t ELMSG;
	uint32_t EPMRDA;
	uint32_t EPMRADRL;
	uint32_t EPMRADRH;
	uint32_t EPMRLEN;
	uint32_t EVSTS;
	uint32_t EVCFG;
	uint32_t EVIDX2;
	uint32_t EVIDX3;
	uint32_t EVIDX7;
	uint32_t EVIDX41;
	uint32_t EVIDX42;
	uint32_t EVIDX43;
	uint32_t EVIDX44;
	uint32_t EVIDX47;
	uint32_t EVIDX4A;
	uint32_t EVTXDAT;
	uint32_t EVPVIDX;
	uint32_t EVRXINTEN;
	uint32_t EVTXINTEN;
	uint32_t EOSTS;
	uint32_t EOCFG;
	uint32_t EORXINTEN;
	uint32_t EORXBUF;
	uint32_t EORXLEN;
	uint32_t EOTXBUF;
	uint32_t EOTXLEN;
	uint32_t EOTXCTRL;
	uint32_t EOTXINTEN;
	uint32_t EFSTS;
	uint32_t EFCONF;
	uint32_t EMADR;
	uint32_t EMTRLEN;
	uint32_t EMBUF;
	uint32_t EMCTRL;
	uint32_t EMINTEN;
	uint32_t ESBUF;
	uint32_t ESINTEN;
	uint32_t ESRXADR;
	uint32_t ESRXLEN;
	uint32_t ESPICFG;
	uint32_t ERSTCFG;
	uint32_t EVIDX51;
	uint32_t EVIDX61;
	uint32_t ESRXC;
	uint32_t EFCFG2;
	uint32_t EFCFG3;
	uint32_t EFCFG4;
	const uint32_t RESERVED[3];
	uint32_t ELCTRL;
	uint32_t ESBUF1;
	uint32_t ESPRG0;
	uint32_t ESPRG1;
	uint32_t ESPDRT;
	uint32_t ESP0STR;
	uint32_t ESP1STR;
	uint32_t ESP2STR;
	uint32_t ESP3STR;
	uint32_t ESP4STR;
	uint32_t ESP5STR;
	uint32_t ESP6STR;
	uint32_t ESP7STR;
	uint32_t ESP8STR;
	uint32_t ESP9STR;
	uint32_t ESPASTR;
	uint32_t ESPBSTR;
	uint32_t ESPCSTR;
	uint32_t ESPDSTR;
	uint32_t ESPESTR;
	uint32_t ESPFSTR;
	uint32_t ESP0LEN;
	uint32_t ESP1LEN;
	uint32_t ESP2LEN;
	uint32_t ESP3LEN;
	uint32_t ESP4LEN;
	uint32_t ESP5LEN;
	uint32_t ESP6LEN;
	uint32_t ESP7LEN;
	uint32_t ESP8LEN;
	uint32_t ESP9LEN;
	uint32_t ESPALEN;
	uint32_t ESPBLEN;
	uint32_t ESPCLEN;
	uint32_t ESPDLEN;
	uint32_t ESPELEN;
	uint32_t ESPFLEN;
	uint32_t ESWPRG0;
	uint32_t ESRPRG0;
	uint32_t ESWPRG1;
	uint32_t ESRPRG1;
	uint32_t ESWPRG2;
	uint32_t ESRPRG2;
	uint32_t ESWPRG3;
	uint32_t ESRPRG3;
	uint32_t ESWPRG4;
	uint32_t ESRPRG4;
	uint32_t ESWPRG5;
	uint32_t ESRPRG5;
	uint32_t ESWPRG6;
	uint32_t ESRPRG6;
	uint32_t ESWPRG7;
	uint32_t ESRPRG7;
	uint32_t ESWPRG8;
	uint32_t ESRPRG8;
	uint32_t ESWPRG9;
	uint32_t ESRPRG9;
	uint32_t ESWPRGA;
	uint32_t ESRPRGA;
	uint32_t ESWPRGB;
	uint32_t ESRPRGB;
	uint32_t ESWPRGC;
	uint32_t ESRPRGC;
	uint32_t ESWPRGD;
	uint32_t ESRPRGD;
	uint32_t ESWPRGE;
	uint32_t ESRPRGE;
	uint32_t ESWPRGF;
	uint32_t ESRPRGF;
	uint32_t ESPREN;
	uint32_t ESPSTS;
	uint32_t ESFLSZ;
	uint32_t ESPINTEN;
	uint32_t IOSHORTSTS;
	uint32_t IOSHORTRDADDR;
	uint32_t IOSHORTRDDATA;
	uint32_t LDNCFG;
	uint32_t ID0;
	uint32_t ID1;
	uint32_t VER;
};

BUILD_ASSERT(sizeof(struct espi_reg) == 568, "reg_espi size is not correct");

/* EPSTS */
#define ESPI_EPSTS_MWDONE  BIT(0)
#define ESPI_EPSTS_MWADMS  BIT(1)
#define ESPI_EPSTS_MRDONE  BIT(2)
#define ESPI_EPSTS_LTXDONE BIT(3)
#define ESPI_EPSTS_CLRSTS  BIT(4)

/* EPCFG */
#define ESPI_EPCFG_CHEN    BIT(0)
#define ESPI_EPCFG_CHRDY   BIT(1)
#define ESPI_EPCFG_BMTREN  BIT(2)
#define ESPI_EPCFG_MXPLSUP GENMASK(6, 4)
#define ESPI_EPCFG_MXPLSEL GENMASK(10, 8)
#define ESPI_EPCFG_MXRDSZ  GENMASK(14, 12)

/* EPINTEN */
#define ESPI_EPINTEN_CFGCHGEN BIT(0)
#define ESPI_EPINTEN_MEMWREN  BIT(1)
#define ESPI_EPINTEN_MEMRDEN  BIT(2)

/* EPRXINFO */
#define ESPI_EPRXINFO_LENGTH GENMASK(11, 0)
#define ESPI_EPRXINFO_TAG    GENMASK(15, 12)
#define ESPI_EPRXINFO_CYCLE  GENMASK(23, 16)
#define ESPI_EPRXINFO_OPCODE GENMASK(31, 24)

/* EPCPRVLD */
#define ESPI_EPCPRVLD_VALIDEN BIT(0)

/* EPBUFSZ */
#define ESPI_EPBUFSZ_SIZE GENMASK(3, 0)

/* EPPTRCLR */
#define ESPI_EPPTRCLR_WRCLR BIT(0)
#define ESPI_EPPTRCLR_RDCLR BIT(1)

/* ELMSG */
#define ESPI_ELMSG_MSGDAT  GENMASK(15, 0)
#define ESPI_ELMSG_MSGCODE GENMASK(31, 16)

/* EPMRLEN */
#define ESPI_EPMRLEN_RXLEN GENMASK(11, 0)

/* EVSTS */
#define ESPI_EVSTS_RXEPT    BIT(0)
#define ESPI_EVSTS_RXOVR    BIT(1)
#define ESPI_EVSTS_TXFULL   BIT(2)
#define ESPI_EVSTS_ILLCHG   BIT(3)
#define ESPI_EVSTS_IDX2CHG  BIT(4)
#define ESPI_EVSTS_IDX3CHG  BIT(5)
#define ESPI_EVSTS_IDX7CHG  BIT(6)
#define ESPI_EVSTS_IDX41CHG BIT(7)
#define ESPI_EVSTS_IDX42CHG BIT(8)
#define ESPI_EVSTS_IDX43CHG BIT(9)
#define ESPI_EVSTS_IDX44CHG BIT(10)
#define ESPI_EVSTS_IDX47CHG BIT(11)
#define ESPI_EVSTS_IDX4ACHG BIT(12)
#define ESPI_EVSTS_IDX51CHG BIT(13)
#define ESPI_EVSTS_IDX61CHG BIT(14)
#define ESPI_EVSTS_RXIDXCHG BIT(15)
#define ESPI_EVSTS_TXDONE   BIT(16)
#define ESPI_EVSTS_RXIDXCLR BIT(17)

/* EVCFG */
#define ESPI_EVCFG_CHEN   BIT(0)
#define ESPI_EVCFG_CHRDY  BIT(1)
#define ESPI_EVCFG_MAXSUP GENMASK(13, 8)
#define ESPI_EVCFG_MAXCNT GENMASK(21, 16)

/* EVIDX2 */
#define ESPI_EVIDX2_RXDAT GENMASK(7, 0)

/* EVIDX3 */
#define ESPI_EVIDX3_RXDAT GENMASK(7, 0)

/* EVIDX7 */
#define ESPI_EVIDX7_RXDAT GENMASK(7, 0)

/* EVIDX41 */
#define ESPI_EVIDX41_RXDAT GENMASK(7, 0)

/* EVIDX42 */
#define ESPI_EVIDX42_RXDAT GENMASK(7, 0)

/* EVIDX43 */
#define ESPI_EVIDX43_RXDAT GENMASK(7, 0)

/* EVIDX44 */
#define ESPI_EVIDX44_RXDAT GENMASK(7, 0)

/* EVIDX47 */
#define ESPI_EVIDX47_RXDAT GENMASK(7, 0)

/* EVIDX4A */
#define ESPI_EVIDX4A_RXDAT GENMASK(7, 0)

/* EVTXDAT */
#define ESPI_EVTXDAT_TXDAT GENMASK(7, 0)
#define ESPI_EVTXDAT_TXIDX GENMASK(15, 8)

/* EVPVIDX */
#define ESPI_EVPVIDX_PVIDX GENMASK(7, 0)

/* EVRXINTEN */
#define ESPI_EVRXINTEN_CFGCHGEN BIT(0)
#define ESPI_EVRXINTEN_RXCHGEN  GENMASK(2, 1)

/* EVTXINTEN */
#define ESPI_EVTXINTEN_TXMPTEN BIT(0)

/* EOSTS */
#define ESPI_EOSTS_RXPND    BIT(0)
#define ESPI_EOSTS_RXDONE   BIT(1)
#define ESPI_EOSTS_TXPND    BIT(2)
#define ESPI_EOSTS_TXDONE   BIT(3)
#define ESPI_EOSTS_CFGENCHG BIT(4)

/* EOCFG */
#define ESPI_EOCFG_CHEN    BIT(0)
#define ESPI_EOCFG_CHRDY   BIT(1)
#define ESPI_EOCFG_MXSZSUP GENMASK(6, 4)
#define ESPI_EOCFG_MXSZSEL GENMASK(10, 8)

/* EORXINTEN */
#define ESPI_EORXINTEN_CHENCHG BIT(0)
#define ESPI_EORXINTEN_RXEN    GENMASK(1, 0)

/* EORXBUF */
#define ESPI_EORXBUF_RXDAT GENMASK(7, 0)

/* EORXLEN */
#define ESPI_EORXLEN_LENGTH GENMASK(11, 0)

/* EOTXBUF */
#define ESPI_EOTXBUF_TXDAT GENMASK(7, 0)

/* EOTXLEN */
#define ESPI_EOTXLEN_LENGTH GENMASK(11, 0)

/* EOTXCTRL */
#define ESPI_EOTXCTRL_TXSTR BIT(0)

/* EOTXINTEN */
#define ESPI_EOTXINTEN_TXEN BIT(0)

/* EFSTS */
#define ESPI_EFSTS_MAFTXDN  BIT(0)
#define ESPI_EFSTS_MAFREOVR BIT(1)
#define ESPI_EFSTS_MAFREUDR BIT(2)
#define ESPI_EFSTS_SAFDONE  BIT(3)
#define ESPI_EFSTS_SAFRW    BIT(4)
#define ESPI_EFSTS_SAFERS   BIT(5)
#define ESPI_EFSTS_CHENCHG  BIT(6)
#define ESPI_EFSTS_OP2      BIT(7)

/* EFCONF */
#define ESPI_EFCONF_CHEN       BIT(0)
#define ESPI_EFCONF_CHRDY      BIT(1)
#define ESPI_EFCONF_ERBLKSZ    GENMASK(3, 1)
#define ESPI_EFCONF_MXPLSUP    GENMASK(13, 11)
#define ESPI_EFCONF_MXPLSEL    GENMASK(15, 13)
#define ESPI_EFCONF_SHAREMD    BIT(11)
#define ESPI_EFCONF_MXRDSZ     GENMASK(14, 12)
#define ESPI_EFCONF_SHARECAPSP GENMASK(18, 16)
#define ESPI_EFCONF_RPMCCNT1   GENMASK(22, 20)
#define ESPI_EFCONF_RPMCOP1    GENMASK(31, 24)

/* EMTRLEN */
#define ESPI_EMTRLEN_TRLEN GENMASK(11, 0)

/* EMCTRL */
#define ESPI_EMCTRL_START     BIT(0)
#define ESPI_EMCTRL_MDSEL_Pos 1
#define ESPI_EMCTRL_MDSEL_Msk (0x3UL << ESPI_EMCTRL_MDSEL_Pos)
#define ESPI_EMCTRL_MDSEL     GENMASK(2, 1)

/* EMINTEN */
#define ESPI_EMINTEN_CHENCHG  BIT(0)
#define ESPI_EMINTEN_TRDONEEN BIT(1)

/* ESBUF */
#define ESPI_ESINTEN_TRDONEEN BIT(0)
#define ESPI_ESINTEN_ERASEEN  BIT(1)
#define ESPI_ESINTEN_RPMCEN   BIT(2)

/* ESRXADR */
#define ESPI_ESRXLEN_LENGTH GENMASK(11, 0)

/* ESPICFG */
#define ESPI_ESPICFG_CHSUP_Pos     (0UL)
#define ESPI_ESPICFG_CHSUP         GENMASK(7, 0)
#define ESPI_ESPICFG_MXWAITALW     GENMASK(11, 8)
#define ESPI_ESPICFG_MXFREQSUP_Pos (16UL)
#define ESPI_ESPICFG_MXFREQSUP_Msk (0x7UL << ESPI_ESPICFG_MXFREQSUP_Pos)
#define ESPI_ESPICFG_ODALRSUP      BIT(19)
#define ESPI_ESPICFG_OPFREQ        GENMASK(22, 20)
#define ESPI_ESPICFG_ODALRSEL      GENMASK(25, 24)
#define ESPI_ESPICFG_IOSUP_Pos     (24UL) /*!< IOSUP (Bit 24) */
#define ESPI_ESPICFG_IOSUP         GENMASK(27, 26)
#define ESPI_ESPICFG_IOSEL         GENMASK(29, 28)
#define ESPI_ESPICFG_ALRMODE       BIT(28)
#define ESPI_ESPICFG_RTCINBMC      BIT(29)
#define ESPI_ESPICFG_RSPMDFEN      BIT(30)
#define ESPI_ESPICFG_CRCCHKEN      BIT(31)

/* ERSTCFG */
#define ESPI_ERSTCFG_RSTMONEN BIT(0)
#define ESPI_ERSTCFG_RSTPOL   BIT(1)
#define ESPI_ERSTCFG_RSTINTEN BIT(2)
#define ESPI_ERSTCFG_RSTSTS   BIT(3)

/* EVIDX51 */
#define ESPI_EVIDX51_RXDAT GENMASK(7, 0)

/* EVIDX61 */
#define ESPI_EVIDX61_RXDAT GENMASK(7, 0)

/* ESRXC */
#define ESPI_ESRXC_RXDAT GENMASK(7, 0)

/* EFCFG2 */
#define ESPI_EFCFG2_MXRDSZ  GENMASK(2, 0)
#define ESPI_EFCFG2_ERBLKSZ GENMASK(11, 8)
#define ESPI_EFCFG2_RPMCSP  GENMASK(21, 16)
#define ESPI_EFCFG2_NUMRPMC GENMASK(24, 22)

/* EFCFG3 */
#define ESPI_EFCFG3_RPMCCNT2 GENMASK(23, 20)
#define ESPI_EFCFG3_RPMCOP2  GENMASK(31, 24)

/* EFCFG4 */
#define ESPI_EFCFG4_RPMCCNT3 GENMASK(3, 0)
#define ESPI_EFCFG4_RPMCOP3  GENMASK(11, 8)
#define ESPI_EFCFG4_RPMCCNT4 GENMASK(23, 20)
#define ESPI_EFCFG4_RPMCOP4  GENMASK(31, 24)

/* ELCTRL */
#define ESPI_ELCTRL_TXSTR BIT(0)

/* ESBUF1 */
#define ESPI_ESPRG0_TAG0GRP GENMASK(2, 0)
#define ESPI_ESPRG0_TAG1GRP GENMASK(6, 4)
#define ESPI_ESPRG0_TAG2GRP GENMASK(10, 8)
#define ESPI_ESPRG0_TAG3GRP GENMASK(14, 12)
#define ESPI_ESPRG0_TAG4GRP GENMASK(18, 16)
#define ESPI_ESPRG0_TAG5GRP GENMASK(22, 20)
#define ESPI_ESPRG0_TAG6GRP GENMASK(26, 24)
#define ESPI_ESPRG0_TAG7GRP GENMASK(30, 28)

/* ESPRG1 */
#define ESPI_ESPRG1_TAG8GRP GENMASK(2, 0)
#define ESPI_ESPRG1_TAG9GRP GENMASK(6, 4)
#define ESPI_ESPRG1_TAGAGRP GENMASK(10, 8)
#define ESPI_ESPRG1_TAGBGRP GENMASK(14, 12)
#define ESPI_ESPRG1_TAGCGRP GENMASK(18, 16)
#define ESPI_ESPRG1_TAGDGRP GENMASK(22, 20)
#define ESPI_ESPRG1_TAGEGRP GENMASK(26, 24)
#define ESPI_ESPRG1_TAGFGRP GENMASK(30, 28)

/* ESPDRT */
#define ESPI_ESPDRT_TAGDRT BIT(0)

/* ESP0STR */
#define ESPI_ESP0STR_ADDR GENMASK(19, 0)

/* ESP1STR */
#define ESPI_ESP1STR_ADDR GENMASK(19, 0)

/* ESP2STR */
#define ESPI_ESP2STR_ADDR GENMASK(19, 0)

/* ESP3STR */
#define ESPI_ESP3STR_ADDR GENMASK(19, 0)

/* ESP4STR */
#define ESPI_ESP4STR_ADDR GENMASK(19, 0)

/* ESP5STR */
#define ESPI_ESP5STR_ADDR GENMASK(19, 0)

/* ESP6STR */
#define ESPI_ESP6STR_ADDR GENMASK(19, 0)

/* ESP7STR */
#define ESPI_ESP7STR_ADDR GENMASK(19, 0)

/* ESP8STR */
#define ESPI_ESP8STR_ADDR GENMASK(19, 0)

/* ESP9STR */
#define ESPI_ESP9STR_ADDR GENMASK(19, 0)

/* ESPASTR */
#define ESPI_ESPASTR_ADDR GENMASK(19, 0)

/* ESPBSTR */
#define ESPI_ESPBSTR_ADDR GENMASK(19, 0)

/* ESPCSTR */
#define ESPI_ESPCSTR_ADDR GENMASK(19, 0)

/* ESPDSTR */
#define ESPI_ESPDSTR_ADDR GENMASK(19, 0)

/* ESPESTR */
#define ESPI_ESPESTR_ADDR GENMASK(19, 0)

/* ESPFSTR */
#define ESPI_ESPFSTR_ADDR GENMASK(19, 0)

/* ESP0LEN */
#define ESPI_ESP0LEN_LEN GENMASK(15, 0)

/* ESP1LEN */
#define ESPI_ESP1LEN_LEN GENMASK(15, 0)

/* ESP2LEN */
#define ESPI_ESP2LEN_LEN GENMASK(15, 0)

/* ESP3LEN */
#define ESPI_ESP3LEN_LEN GENMASK(15, 0)

/* ESP4LEN */
#define ESPI_ESP4LEN_LEN GENMASK(15, 0)

/* ESP5LEN */
#define ESPI_ESP5LEN_LEN GENMASK(15, 0)

/* ESP6LEN */
#define ESPI_ESP6LEN_LEN GENMASK(15, 0)

/* ESP7LEN */
#define ESPI_ESP7LEN_LEN GENMASK(15, 0)

/* ESP8LEN */
#define ESPI_ESP8LEN_LEN GENMASK(15, 0)

/* ESP9LEN */
#define ESPI_ESP9LEN_LEN GENMASK(15, 0)

/* ESPALEN */
#define ESPI_ESPALEN_LEN GENMASK(15, 0)

/* ESPBLEN */
#define ESPI_ESPBLEN_LEN GENMASK(15, 0)

/* ESPCLEN */
#define ESPI_ESPCLEN_LEN GENMASK(15, 0)

/* ESPDLEN */
#define ESPI_ESPDLEN_LEN GENMASK(15, 0)

/* ESPELEN */
#define ESPI_ESPELEN_LEN GENMASK(15, 0)

/* ESPFLEN */
#define ESPI_ESPFLEN_LEN GENMASK(15, 0)

/* ESWPRG0 */
#define ESPI_ESWPRG0_GWREN BIT(0)

/* ESWPRG1 */
#define ESPI_ESWPRG1_GWREN BIT(0)

/* ESWPRG2 */
#define ESPI_ESWPRG2_GWREN BIT(0)

/* ESWPRG3 */
#define ESPI_ESWPRG3_GWREN BIT(0)

/* ESWPRG4 */
#define ESPI_ESWPRG4_GWREN BIT(0)

/* ESWPRG5 */
#define ESPI_ESWPRG5_GWREN BIT(0)

/* ESWPRG6 */
#define ESPI_ESWPRG6_GWREN BIT(0)

/* ESWPRG7 */
#define ESPI_ESWPRG7_GWREN BIT(0)

/* ESWPRG8 */
#define ESPI_ESWPRG8_GWREN BIT(0)

/* ESWPRG9 */
#define ESPI_ESWPRG9_GWREN BIT(0)

/* ESWPRGA */
#define ESPI_ESWPRGA_GWREN BIT(0)

/* ESWPRGB */
#define ESPI_ESWPRGB_GWREN BIT(0)

/* ESWPRGC */
#define ESPI_ESWPRGC_GWREN BIT(0)

/* ESWPRGD */
#define ESPI_ESWPRGD_GWREN BIT(0)

/* ESWPRGE */
#define ESPI_ESWPRGE_GWREN BIT(0)

/* ESWPRGF */
#define ESPI_ESWPRGF_GWREN BIT(0)

/* ESRPRG0 */
#define ESPI_ESRPRG0_GRDEN BIT(0)

/* ESRPRG1 */
#define ESPI_ESRPRG1_GRDEN BIT(0)

/* ESRPRG2 */
#define ESPI_ESRPRG2_GRDEN BIT(0)

/* ESRPRG3 */
#define ESPI_ESRPRG3_GRDEN BIT(0)

/* ESRPRG4 */
#define ESPI_ESRPRG4_GRDEN BIT(0)

/* ESRPRG5 */
#define ESPI_ESRPRG5_GRDEN BIT(0)

/* ESRPRG6 */
#define ESPI_ESRPRG6_GRDEN BIT(0)

/* ESRPRG7 */
#define ESPI_ESRPRG7_GRDEN BIT(0)

/* ESRPRG8 */
#define ESPI_ESRPRG8_GRDEN BIT(0)

/* ESRPRG9 */
#define ESPI_ESRPRG9_GRDEN BIT(0)

/* ESRPRGA */
#define ESPI_ESRPRGA_GRDEN BIT(0)

/* ESRPRGB */
#define ESPI_ESRPRGB_GRDEN BIT(0)

/* ESRPRGC */
#define ESPI_ESRPRGC_GRDEN BIT(0)

/* ESRPRGD */
#define ESPI_ESRPRGD_GRDEN BIT(0)

/* ESRPRGE */
#define ESPI_ESRPRGE_GRDEN BIT(0)

/* ESRPRGF */
#define ESPI_ESRPRGF_GRDEN BIT(0)

/* ESPREN */
#define ESPI_ESPREN_EN BIT(0)

/* ESPSTS */
#define ESPI_ESPSTS_OVSIZE BIT(0)
#define ESPI_ESPSTS_HIT    BIT(1)
#define ESPI_ESPSTS_CRS4K  BIT(2)

/* ESPINTEN */
#define ESPI_ESPINTEN_OVSIZEEN BIT(0)
#define ESPI_ESPINTEN_HITEN    BIT(1)
#define ESPI_ESPINTEN_CRS4KEN  BIT(2)

/* IOSHORTSTS */
#define ESPI_IOSHORTSTS_BYTES  GENMASK(1, 0)
#define ESPI_IOSHORTSTS_TYPE   GENMASK(3, 2)
#define ESPI_IOSHORTSTS_ACCEPT GENMASK(4, 3)

/* IOSHORTRDADDR */
#define ESPI_IOSHORTRDADDR_ADDR GENMASK(15, 0)

/* LDNCFG */
#define ESPI_LDNCFG_IDX GENMASK(15, 0)

#endif /* ZEPHYR_SOC_REALTEK_RTS5912_REG_ESPI_H */
