static const uint64_t in_cfft_noisy_16[32] = {
    0xbfa58a3e7ce8c268, 0x0,
    0x3fdf7503d421b8a3, 0x0,
    0x3fe7298971b2f05d, 0x0,
    0x3fe27d5ab48bbded, 0x0,
    0x3f8e957bf3faf458, 0x0,
    0xbfda690069668b72, 0x0,
    0xbfe71fc287a1a803, 0x0,
    0xbfddfb560e6e15ae, 0x0,
    0x3f98de5d5c60cb98, 0x0,
    0x3fdf04b94d0d4acb, 0x0,
    0x3fe5566e79baa53b, 0x0,
    0x3fdffff61cb3edfe, 0x0,
    0xbf7cc7493acba971, 0x0,
    0xbfdfd1ff3dab52f8, 0x0,
    0xbfe701f88151f40a, 0x0,
    0xbfe00d861e2461f8, 0x0
    };

static const uint64_t in_cifft_noisy_16[32] = {
    0x3fbcf6b4ec0d16fe, 0x0,
    0xbfa9c9df688de925, 0xbfcccd2244264894,
    0xbfc1f0d290c2f6c4, 0xc01674b1c6dcc343,
    0xbfbcf489f19d767a, 0x3f8323285fcba484,
    0x3fa50d97df4d528c, 0x3fa52c5e07bb59b0,
    0xbfbafa9b702db951, 0x3fa4f38fc1d5a03d,
    0x3fb6ba1f7d284904, 0x3fa9dd7b1dc49300,
    0x3f6c2757fbfa7eb0, 0xbfbb08516aaad111,
    0xbfce10c05ec04979, 0x0,
    0x3f6c2757fbfa7ed0, 0x3fbb08516aaad111,
    0x3fb6ba1f7d284904, 0xbfa9dd7b1dc49300,
    0xbfbafa9b702db952, 0xbfa4f38fc1d5a03d,
    0x3fa50d97df4d528c, 0xbfa52c5e07bb59b0,
    0xbfbcf489f19d767b, 0xbf8323285fcba484,
    0xbfc1f0d290c2f6c4, 0x401674b1c6dcc343,
    0xbfa9c9df688de923, 0x3fcccd2244264894
    };

static const uint64_t ref_cfft_noisy_16[32] = {
    0x3fbcf6b4ec0d16fe, 0x0,
    0xbfa9c9df688de925, 0xbfcccd2244264894,
    0xbfc1f0d290c2f6c4, 0xc01674b1c6dcc343,
    0xbfbcf489f19d767a, 0x3f8323285fcba484,
    0x3fa50d97df4d528c, 0x3fa52c5e07bb59b0,
    0xbfbafa9b702db951, 0x3fa4f38fc1d5a03d,
    0x3fb6ba1f7d284904, 0x3fa9dd7b1dc49300,
    0x3f6c2757fbfa7eb0, 0xbfbb08516aaad111,
    0xbfce10c05ec04979, 0x0,
    0x3f6c2757fbfa7ed0, 0x3fbb08516aaad111,
    0x3fb6ba1f7d284904, 0xbfa9dd7b1dc49300,
    0xbfbafa9b702db952, 0xbfa4f38fc1d5a03d,
    0x3fa50d97df4d528c, 0xbfa52c5e07bb59b0,
    0xbfbcf489f19d767b, 0xbf8323285fcba484,
    0xbfc1f0d290c2f6c4, 0x401674b1c6dcc343,
    0xbfa9c9df688de923, 0x3fcccd2244264894
    };

static const uint64_t in_cfft_noisy_32[64] = {
    0x3fa89117984a9562, 0x0,
    0x3fddc2de7434712d, 0x0,
    0x3fe8953f1cd52833, 0x0,
    0x3fde365b89867849, 0x0,
    0xbfafbe46aab40401, 0x0,
    0xbfdee9c10a4d1b7a, 0x0,
    0xbfe61a026041333c, 0x0,
    0xbfdf0514866bb5c2, 0x0,
    0xbfb4ab8518e22a6c, 0x0,
    0x3fe27b90f4351232, 0x0,
    0x3fe7364e272ce422, 0x0,
    0x3fe09e911971446b, 0x0,
    0xbfbb5531fa2e1aa9, 0x0,
    0xbfddf28d1b1c50ef, 0x0,
    0xbfe6d26da0d26eca, 0x0,
    0xbfe098bc0fcec34a, 0x0,
    0x3fa5058b1de3a42a, 0x0,
    0x3fdcb985e7b42496, 0x0,
    0x3fe64ea42cf02730, 0x0,
    0x3fdd5a9357e2dbe8, 0x0,
    0xbfb47ddf1659640e, 0x0,
    0xbfe06d870dffbc64, 0x0,
    0xbfe78653753192cd, 0x0,
    0xbfdb09e1527bf464, 0x0,
    0x3fa7cb0593aaf57c, 0x0,
    0x3fe16f2910513255, 0x0,
    0x3fe5e228dbc3f202, 0x0,
    0x3fdd98ca4eb214f9, 0x0,
    0x3fa30b8f82a39660, 0x0,
    0xbfdd145b395848c6, 0x0,
    0xbfe2769458fdf6ff, 0x0,
    0xbfe02bdcaf820d19, 0x0
    };

static const uint64_t in_cifft_noisy_32[64] = {
    0x3fb9c44a29b4e4f0, 0x0,
    0x3fd54347b2c2333a, 0x3fbe17eb096f811a,
    0xbfa0dc38a6504f18, 0x3fd1e33746ec1ead,
    0x3fb12975e658d145, 0x3f885e3538125848,
    0x3fd6152bf51766e8, 0xc02635c1f3d5fc80,
    0xbfd1d28a567e523e, 0x3fcd89ff1d9b3be4,
    0xbfc43aed2ee5e524, 0x3f9521f998180fe0,
    0xbf832ae373c8384c, 0xbfd4fdae608912af,
    0xbfd42fcc6107458c, 0xbfc16ed9bd7e9390,
    0xbfc107065f7744e6, 0x3fcb571595fe1ad2,
    0x3fc116bf1c3ad388, 0x3fab2872b2c5bb58,
    0xbfb70c3904b9368a, 0xbfa036ea65bed442,
    0x3fc80763c66b54d0, 0x3fb37a27d496d540,
    0xbfc085b2870a16cc, 0xbfb90c6ac7714ddd,
    0x3fe19f78e421af92, 0x3f9688dd0ec3e850,
    0x3fd2f333749a1928, 0xbfca5a16af456f6b,
    0xbfb8e25d838fda50, 0x0,
    0x3fd2f333749a1928, 0x3fca5a16af456f6b,
    0x3fe19f78e421af92, 0xbf9688dd0ec3e850,
    0xbfc085b2870a16cc, 0x3fb90c6ac7714ddd,
    0x3fc80763c66b54d0, 0xbfb37a27d496d540,
    0xbfb70c3904b9368a, 0x3fa036ea65bed442,
    0x3fc116bf1c3ad388, 0xbfab2872b2c5bb58,
    0xbfc107065f7744e6, 0xbfcb571595fe1ad2,
    0xbfd42fcc6107458c, 0x3fc16ed9bd7e9390,
    0xbf832ae373c8384c, 0x3fd4fdae608912af,
    0xbfc43aed2ee5e524, 0xbf9521f998180fe0,
    0xbfd1d28a567e523e, 0xbfcd89ff1d9b3be4,
    0x3fd6152bf51766e8, 0x402635c1f3d5fc80,
    0x3fb12975e658d145, 0xbf885e3538125848,
    0xbfa0dc38a6504f18, 0xbfd1e33746ec1ead,
    0x3fd54347b2c2333a, 0xbfbe17eb096f811a
    };

static const uint64_t ref_cfft_noisy_32[64] = {
    0x3fb9c44a29b4e4f0, 0x0,
    0x3fd54347b2c2333a, 0x3fbe17eb096f811a,
    0xbfa0dc38a6504f18, 0x3fd1e33746ec1ead,
    0x3fb12975e658d145, 0x3f885e3538125848,
    0x3fd6152bf51766e8, 0xc02635c1f3d5fc80,
    0xbfd1d28a567e523e, 0x3fcd89ff1d9b3be4,
    0xbfc43aed2ee5e524, 0x3f9521f998180fe0,
    0xbf832ae373c8384c, 0xbfd4fdae608912af,
    0xbfd42fcc6107458c, 0xbfc16ed9bd7e9390,
    0xbfc107065f7744e6, 0x3fcb571595fe1ad2,
    0x3fc116bf1c3ad388, 0x3fab2872b2c5bb58,
    0xbfb70c3904b9368a, 0xbfa036ea65bed442,
    0x3fc80763c66b54d0, 0x3fb37a27d496d540,
    0xbfc085b2870a16cc, 0xbfb90c6ac7714ddd,
    0x3fe19f78e421af92, 0x3f9688dd0ec3e850,
    0x3fd2f333749a1928, 0xbfca5a16af456f6b,
    0xbfb8e25d838fda50, 0x0,
    0x3fd2f333749a1928, 0x3fca5a16af456f6b,
    0x3fe19f78e421af92, 0xbf9688dd0ec3e850,
    0xbfc085b2870a16cc, 0x3fb90c6ac7714ddd,
    0x3fc80763c66b54d0, 0xbfb37a27d496d540,
    0xbfb70c3904b9368a, 0x3fa036ea65bed442,
    0x3fc116bf1c3ad388, 0xbfab2872b2c5bb58,
    0xbfc107065f7744e6, 0xbfcb571595fe1ad2,
    0xbfd42fcc6107458c, 0x3fc16ed9bd7e9390,
    0xbf832ae373c8384c, 0x3fd4fdae608912af,
    0xbfc43aed2ee5e524, 0xbf9521f998180fe0,
    0xbfd1d28a567e523e, 0xbfcd89ff1d9b3be4,
    0x3fd6152bf51766e8, 0x402635c1f3d5fc80,
    0x3fb12975e658d145, 0xbf885e3538125848,
    0xbfa0dc38a6504f18, 0xbfd1e33746ec1ead,
    0x3fd54347b2c2333a, 0xbfbe17eb096f811a
    };

static const uint64_t in_cfft_noisy_64[128] = {
    0xbfa19f3eebc6b9b3, 0x0,
    0x3fe09e332b55834f, 0x0,
    0x3fe5b05db0dbab0f, 0x0,
    0x3fdc8270446799ee, 0x0,
    0xbf862d2dcd7026f8, 0x0,
    0xbfe0896a5f0aded0, 0x0,
    0xbfe4da07fd6cd265, 0x0,
    0xbfdf332f6a79b460, 0x0,
    0x3fbcda97bf2a5f51, 0x0,
    0x3fe0b1417e3c169d, 0x0,
    0x3fe7f7cb5ed5e138, 0x0,
    0x3fdc877e43885564, 0x0,
    0xbf9a4de51307e89a, 0x0,
    0xbfe00ae06b08d636, 0x0,
    0xbfe5a47bc567ff14, 0x0,
    0xbfdc2fdad2259e77, 0x0,
    0x3fa334b7e284708d, 0x0,
    0x3fddea7b84941dd6, 0x0,
    0x3fe6c136a9ed372c, 0x0,
    0x3fde6715d842821a, 0x0,
    0x3fa61ad028349b3a, 0x0,
    0xbfdea11258b7d7e8, 0x0,
    0xbfe5c08e64e72612, 0x0,
    0xbfdf69c267e7ced7, 0x0,
    0x3f953bce0b587569, 0x0,
    0x3fe12ea6d113dd12, 0x0,
    0x3fe5db0cf2456618, 0x0,
    0x3fde1afb478fa5a3, 0x0,
    0xbf8c3660f7388a03, 0x0,
    0xbfe06f1be896f46c, 0x0,
    0xbfe64888a7cb4448, 0x0,
    0xbfd9b06ff322f917, 0x0,
    0xbf8c51e15231bac2, 0x0,
    0x3fdf78476fae1e5b, 0x0,
    0x3fea0778db75123f, 0x0,
    0x3fe03469028f7c4a, 0x0,
    0xbfa026000ff9cbbe, 0x0,
    0xbfe02bc80af35111, 0x0,
    0xbfe818472e8ce877, 0x0,
    0xbfe0e157f36bd1f8, 0x0,
    0xbf815867f9556f0d, 0x0,
    0x3fdd12ab896123e0, 0x0,
    0x3fe59da0f602b765, 0x0,
    0x3fded9501b4f432c, 0x0,
    0x3fb428fa64e19651, 0x0,
    0xbfdc69385cc6df94, 0x0,
    0xbfe63eec8d538fc7, 0x0,
    0xbfdf3c6175c5f250, 0x0,
    0x3fa06a21afac4107, 0x0,
    0x3fe08b3e6a4dbe3a, 0x0,
    0x3fe5a3a4bfb6edc1, 0x0,
    0x3fe31773505abe42, 0x0,
    0xbfb53f51d24bcfaf, 0x0,
    0xbfdd433a9eb73c34, 0x0,
    0xbfe5e541ca38951d, 0x0,
    0xbfdc4cda4b7ed2cf, 0x0,
    0xbfaf538c3f5f446c, 0x0,
    0x3fdd26a62bac3824, 0x0,
    0x3fe71085d7c44808, 0x0,
    0x3fd94eeccab3c48c, 0x0,
    0x3f3a96492cc5e2c3, 0x0,
    0xbfd8c0548e1384f3, 0x0,
    0xbfe6ef96e6103574, 0x0,
    0xbfe1d5ed7bd8ec3b, 0x0
    };

static const uint64_t in_cifft_noisy_64[128] = {
    0x3fd5a7d809c69672, 0x0,
    0xbfc0888dfcbee041, 0xbfc4dd2c1782fa98,
    0xbfd2c897bc05e7da, 0xbf9e9949cb0c1f58,
    0xbfd177560ef7e04c, 0xbfd409e99fc598f4,
    0x3fc8d2ccccca658c, 0xbf952e0de063d9b8,
    0xbfdb9db0b9beb405, 0x3fd6f09e82d345c6,
    0x3fca3589b4a7e648, 0x3f852ef0930fd968,
    0xbf9eff0b8dd91ef4, 0x3fe2cf6f8bcb294c,
    0x3fcabb5dfea926d4, 0xc03629cd30698880,
    0x3fa9c928f19b4b56, 0xbfc543d613d8b1ef,
    0xbfc4acbced865fe9, 0xbfcce7b5f46188c4,
    0xbfdc961ddc9294aa, 0xbfbc986e7accbb14,
    0xbfd659c72f7484be, 0xbfb7bb0e535b50d9,
    0x3fd72587ac715be1, 0xbfd055749fc34ff0,
    0xbfcc040df945d319, 0xbfa7803c789b9a28,
    0xbf99fb2c94395d67, 0xbfd14f634994f846,
    0xbfbc6749b2977d58, 0xbfc6d73e331ebad0,
    0xbfb16ceb63cce227, 0xbfd69827b9a05cd5,
    0xbfc75b24604478fc, 0xbfd6766cbedcd099,
    0x3fdb406f034fd85c, 0xbfe2dad3e56d2838,
    0x3fcba2d7abb8d5bd, 0x3fcf569a673916e1,
    0x3fd5f56648f1e51a, 0xbfb747c4aa2cbd24,
    0xbfc19b1f0b5c6533, 0x3fd075e9347a8a26,
    0x3fc298bcdcb9a6d8, 0xbfc6f0ee488f2d90,
    0x3fa7c0be0b8b9966, 0x3fd6d21527bc7e20,
    0x3fb65d0a078b70ae, 0x3fb19b40ba34e844,
    0xbfc7475d292b859e, 0x3fb8660ae58b93fa,
    0xbfe20c1492553c85, 0xbfc75edb6ce4c7ba,
    0xbfcd80640e0901c5, 0xbfc5d955bfa93723,
    0x3fc94d04897e40b1, 0xbfba84d5e4d80450,
    0x3f9d277ccfa66258, 0x3fdb2b07f35764fa,
    0x3f9be40a90d89be4, 0x3fdc396d1a49e3fc,
    0x3faba68f3117eb10, 0x0,
    0x3f9be40a90d89bd8, 0xbfdc396d1a49e3fc,
    0x3f9d277ccfa66250, 0xbfdb2b07f35764fa,
    0x3fc94d04897e40b1, 0x3fba84d5e4d8044e,
    0xbfcd80640e0901c4, 0x3fc5d955bfa93723,
    0xbfe20c1492553c86, 0x3fc75edb6ce4c7bb,
    0xbfc7475d292b859e, 0xbfb8660ae58b93fb,
    0x3fb65d0a078b70af, 0xbfb19b40ba34e840,
    0x3fa7c0be0b8b9966, 0xbfd6d21527bc7e20,
    0x3fc298bcdcb9a6da, 0x3fc6f0ee488f2d8f,
    0xbfc19b1f0b5c6533, 0xbfd075e9347a8a26,
    0x3fd5f56648f1e51a, 0x3fb747c4aa2cbd24,
    0x3fcba2d7abb8d5bf, 0xbfcf569a673916e2,
    0x3fdb406f034fd85b, 0x3fe2dad3e56d2838,
    0xbfc75b24604478fd, 0x3fd6766cbedcd09a,
    0xbfb16ceb63cce226, 0x3fd69827b9a05cd6,
    0xbfbc6749b2977d58, 0x3fc6d73e331ebad0,
    0xbf99fb2c94395d64, 0x3fd14f634994f845,
    0xbfcc040df945d31a, 0x3fa7803c789b9a20,
    0x3fd72587ac715be0, 0x3fd055749fc34ff0,
    0xbfd659c72f7484be, 0x3fb7bb0e535b50da,
    0xbfdc961ddc9294aa, 0x3fbc986e7accbb14,
    0xbfc4acbced865fe9, 0x3fcce7b5f46188c5,
    0x3fa9c928f19b4b5a, 0x3fc543d613d8b1f0,
    0x3fcabb5dfea926d4, 0x403629cd30698880,
    0xbf9eff0b8dd91ef2, 0xbfe2cf6f8bcb294c,
    0x3fca3589b4a7e64a, 0xbf852ef0930fd960,
    0xbfdb9db0b9beb405, 0xbfd6f09e82d345c7,
    0x3fc8d2ccccca658d, 0x3f952e0de063d9b8,
    0xbfd177560ef7e04c, 0x3fd409e99fc598f5,
    0xbfd2c897bc05e7da, 0x3f9e9949cb0c1f50,
    0xbfc0888dfcbee042, 0x3fc4dd2c1782fa97
    };

static const uint64_t ref_cfft_noisy_64[128] = {
    0x3fd5a7d809c69672, 0x0,
    0xbfc0888dfcbee041, 0xbfc4dd2c1782fa98,
    0xbfd2c897bc05e7da, 0xbf9e9949cb0c1f58,
    0xbfd177560ef7e04c, 0xbfd409e99fc598f4,
    0x3fc8d2ccccca658c, 0xbf952e0de063d9b8,
    0xbfdb9db0b9beb405, 0x3fd6f09e82d345c6,
    0x3fca3589b4a7e648, 0x3f852ef0930fd968,
    0xbf9eff0b8dd91ef4, 0x3fe2cf6f8bcb294c,
    0x3fcabb5dfea926d4, 0xc03629cd30698880,
    0x3fa9c928f19b4b56, 0xbfc543d613d8b1ef,
    0xbfc4acbced865fe9, 0xbfcce7b5f46188c4,
    0xbfdc961ddc9294aa, 0xbfbc986e7accbb14,
    0xbfd659c72f7484be, 0xbfb7bb0e535b50d9,
    0x3fd72587ac715be1, 0xbfd055749fc34ff0,
    0xbfcc040df945d319, 0xbfa7803c789b9a28,
    0xbf99fb2c94395d67, 0xbfd14f634994f846,
    0xbfbc6749b2977d58, 0xbfc6d73e331ebad0,
    0xbfb16ceb63cce227, 0xbfd69827b9a05cd5,
    0xbfc75b24604478fc, 0xbfd6766cbedcd099,
    0x3fdb406f034fd85c, 0xbfe2dad3e56d2838,
    0x3fcba2d7abb8d5bd, 0x3fcf569a673916e1,
    0x3fd5f56648f1e51a, 0xbfb747c4aa2cbd24,
    0xbfc19b1f0b5c6533, 0x3fd075e9347a8a26,
    0x3fc298bcdcb9a6d8, 0xbfc6f0ee488f2d90,
    0x3fa7c0be0b8b9966, 0x3fd6d21527bc7e20,
    0x3fb65d0a078b70ae, 0x3fb19b40ba34e844,
    0xbfc7475d292b859e, 0x3fb8660ae58b93fa,
    0xbfe20c1492553c85, 0xbfc75edb6ce4c7ba,
    0xbfcd80640e0901c5, 0xbfc5d955bfa93723,
    0x3fc94d04897e40b1, 0xbfba84d5e4d80450,
    0x3f9d277ccfa66258, 0x3fdb2b07f35764fa,
    0x3f9be40a90d89be4, 0x3fdc396d1a49e3fc,
    0x3faba68f3117eb10, 0x0,
    0x3f9be40a90d89bd8, 0xbfdc396d1a49e3fc,
    0x3f9d277ccfa66250, 0xbfdb2b07f35764fa,
    0x3fc94d04897e40b1, 0x3fba84d5e4d8044e,
    0xbfcd80640e0901c4, 0x3fc5d955bfa93723,
    0xbfe20c1492553c86, 0x3fc75edb6ce4c7bb,
    0xbfc7475d292b859e, 0xbfb8660ae58b93fb,
    0x3fb65d0a078b70af, 0xbfb19b40ba34e840,
    0x3fa7c0be0b8b9966, 0xbfd6d21527bc7e20,
    0x3fc298bcdcb9a6da, 0x3fc6f0ee488f2d8f,
    0xbfc19b1f0b5c6533, 0xbfd075e9347a8a26,
    0x3fd5f56648f1e51a, 0x3fb747c4aa2cbd24,
    0x3fcba2d7abb8d5bf, 0xbfcf569a673916e2,
    0x3fdb406f034fd85b, 0x3fe2dad3e56d2838,
    0xbfc75b24604478fd, 0x3fd6766cbedcd09a,
    0xbfb16ceb63cce226, 0x3fd69827b9a05cd6,
    0xbfbc6749b2977d58, 0x3fc6d73e331ebad0,
    0xbf99fb2c94395d64, 0x3fd14f634994f845,
    0xbfcc040df945d31a, 0x3fa7803c789b9a20,
    0x3fd72587ac715be0, 0x3fd055749fc34ff0,
    0xbfd659c72f7484be, 0x3fb7bb0e535b50da,
    0xbfdc961ddc9294aa, 0x3fbc986e7accbb14,
    0xbfc4acbced865fe9, 0x3fcce7b5f46188c5,
    0x3fa9c928f19b4b5a, 0x3fc543d613d8b1f0,
    0x3fcabb5dfea926d4, 0x403629cd30698880,
    0xbf9eff0b8dd91ef2, 0xbfe2cf6f8bcb294c,
    0x3fca3589b4a7e64a, 0xbf852ef0930fd960,
    0xbfdb9db0b9beb405, 0xbfd6f09e82d345c7,
    0x3fc8d2ccccca658d, 0x3f952e0de063d9b8,
    0xbfd177560ef7e04c, 0x3fd409e99fc598f5,
    0xbfd2c897bc05e7da, 0x3f9e9949cb0c1f50,
    0xbfc0888dfcbee042, 0x3fc4dd2c1782fa97
    };

static const uint64_t in_cfft_noisy_128[256] = {
    0xbf8255c35c4ecec7, 0x0,
    0x3fe0f66c830ecc1b, 0x0,
    0x3fe5280da71c812f, 0x0,
    0x3fe050f9716d7c99, 0x0,
    0xbf96605179ee2db0, 0x0,
    0xbfdc797571a8b236, 0x0,
    0xbfe6a28bd97327b7, 0x0,
    0xbfdc9f40e0a8150f, 0x0,
    0xbf723f0de90e5be9, 0x0,
    0x3fde3b421e08786f, 0x0,
    0x3fe6cd67639cd228, 0x0,
    0x3fe1cdf25bcf9cf8, 0x0,
    0x3faa6022425dc24c, 0x0,
    0xbfdd268324057c35, 0x0,
    0xbfe54abe72ed2e20, 0x0,
    0xbfddc3fa8af82ebc, 0x0,
    0xbf9b14d9ebd79550, 0x0,
    0x3fe0a7b02eac1a83, 0x0,
    0x3fe6b42a0f4692ed, 0x0,
    0x3fdfaa1d9c374e2a, 0x0,
    0x3fa93d28c260c706, 0x0,
    0xbfe13cb83c778845, 0x0,
    0xbfe60fd8e2530ee3, 0x0,
    0xbfe2254cbce5c318, 0x0,
    0xbfafe4fed873fd7a, 0x0,
    0x3fdcf433e52f241c, 0x0,
    0x3fe5390e21933a0c, 0x0,
    0x3fda4396664b3c3f, 0x0,
    0xbfa29a963cb64848, 0x0,
    0xbfdedfebb22846dc, 0x0,
    0xbfe64a755e8b9da0, 0x0,
    0xbfe1cb9b66eaf69a, 0x0,
    0x3f4d9152ca380738, 0x0,
    0x3fdeff399ceca5fc, 0x0,
    0x3fe328392dd1f32a, 0x0,
    0x3fe0004e39a7d476, 0x0,
    0x3f8ac67b6a68f9e5, 0x0,
    0xbfde457efa69eb57, 0x0,
    0xbfe62ff6330169ab, 0x0,
    0xbfe02baa867389c4, 0x0,
    0x3fa7906a1a7f2014, 0x0,
    0x3fe09b19059693d2, 0x0,
    0x3fe7875f8e9fd060, 0x0,
    0x3fdd4c09c0c8d539, 0x0,
    0x3f8d83adcb58f85e, 0x0,
    0xbfdc994ce949073c, 0x0,
    0xbfe51654cf3ef23c, 0x0,
    0xbfe1472a43c2614c, 0x0,
    0xbf8154847b0abd5e, 0x0,
    0x3fe001823081511b, 0x0,
    0x3fe6f81bf1e11a9f, 0x0,
    0x3fe092c06aa637c5, 0x0,
    0x3fa0f805f0f52d05, 0x0,
    0xbfdc46020564b28e, 0x0,
    0xbfe5d627d2a749a8, 0x0,
    0xbfe0d5343c7b2cd5, 0x0,
    0x3f8ae74b1e9bffb1, 0x0,
    0x3fe09ce9d793bb03, 0x0,
    0x3fe60deaf1a0f874, 0x0,
    0x3fdbb2756272fc74, 0x0,
    0xbfa87cf11b38b3df, 0x0,
    0xbfdfa20a226d5cdc, 0x0,
    0xbfe5e6edeff9e2d0, 0x0,
    0xbfdf0503bde96d3b, 0x0,
    0xbfb01c8e7682021b, 0x0,
    0x3fe2631ac0c57c2c, 0x0,
    0x3fe5e48f2dcdbc0b, 0x0,
    0x3fe388aec04fc1d3, 0x0,
    0xbf53f9b6987b9dc0, 0x0,
    0xbfe0f5e720f3b121, 0x0,
    0xbfe64d58fa57abb3, 0x0,
    0xbfdf6b4811cbcee0, 0x0,
    0xbfb357dfbe83a28e, 0x0,
    0x3fdebfaecedd5fb6, 0x0,
    0x3fe3562c37d256cd, 0x0,
    0x3fe025fb55a091b9, 0x0,
    0x3fc1b255bba56b33, 0x0,
    0xbfdf110bbf428968, 0x0,
    0xbfe53b4f7ac4e3f2, 0x0,
    0xbfdd443f037c2616, 0x0,
    0xbf981e510ea5bb1a, 0x0,
    0x3fe11d4afc5eb137, 0x0,
    0x3fe6ca8f9b505234, 0x0,
    0x3fdd772dd192a776, 0x0,
    0x3f90a594625f2faf, 0x0,
    0xbfe1dc3157251947, 0x0,
    0xbfe4f1c2f017ab70, 0x0,
    0xbfdbac0246f3e7ca, 0x0,
    0x3f8a08ae3854f3d0, 0x0,
    0x3fe3c17291a5fcf0, 0x0,
    0x3fe6aac20074bdb9, 0x0,
    0x3fe0bffada4ecdc5, 0x0,
    0x3fa0a42ed2c05ace, 0x0,
    0xbfdbb2ceb00ee108, 0x0,
    0xbfe5e7275492aaec, 0x0,
    0xbfe109c7cf5cc1d2, 0x0,
    0xbf9f68888cdb322b, 0x0,
    0x3fe063b478be51d5, 0x0,
    0x3fe34febd911b29e, 0x0,
    0x3fddaa53cbbe1c42, 0x0,
    0x3faf530c8500aa26, 0x0,
    0xbfe2d6f27c147e61, 0x0,
    0xbfe6603f624e7e04, 0x0,
    0xbfe1e3fb88c7ef7f, 0x0,
    0xbfa24cd78b11399f, 0x0,
    0x3fe318dd1f4bafda, 0x0,
    0x3fe87168ca63fe7a, 0x0,
    0x3fda1a820840bd1d, 0x0,
    0x3fa689ef83be2c00, 0x0,
    0xbfde7b0b20ac6d6a, 0x0,
    0xbfe8ed4aaad00501, 0x0,
    0xbfde3c8ac22884e0, 0x0,
    0x3f735ba1ca0ac551, 0x0,
    0x3fdf3f91fbab1772, 0x0,
    0x3fe57f7b3740a70d, 0x0,
    0x3fde407d759e9490, 0x0,
    0xbf7b4f976e72af36, 0x0,
    0xbfddfdde2ebea5e9, 0x0,
    0xbfe4067b8bcefaf2, 0x0,
    0xbfe213d8f58050c9, 0x0,
    0xbfa174dbc20d37bd, 0x0,
    0x3fdbde4a794e0196, 0x0,
    0x3fe8cd3caea9e62f, 0x0,
    0x3fe144cea3b45814, 0x0,
    0x3f9c17d15b18af33, 0x0,
    0xbfdc0f27ae8c0d40, 0x0,
    0xbfe3c4b8fee06bd0, 0x0,
    0xbfe1362577479091, 0x0
    };

static const uint64_t in_cifft_noisy_128[256] = {
    0x3fd8e1ef5d2d50c1, 0x0,
    0xbfabb219d819de08, 0x3fd20268b42c72b3,
    0x3fe07967b60706a3, 0xbfc925b0413018f0,
    0x3fed1dc5db4099c6, 0xbfe0642c0c0692a0,
    0xbfdf732a6c5ec14e, 0xbfbd67b5471e657e,
    0xbfe38af729020129, 0x3fbfda2ee1dd2593,
    0x3fcd407ff5e107f4, 0x3fc2daeb5e80e74c,
    0x3fd9f8b8faa8b4b8, 0x3fe32d68f19802c6,
    0x3fb2219fefc6b162, 0x3fda4113dd0bad44,
    0xbfe1e26a6cdefbbc, 0x3fc6c87525ce835e,
    0x3fe3a4abd1db66cc, 0xbfe24aafe001ed94,
    0xbfd8ed010d58e550, 0x3fe91008c5ec7db8,
    0x3fbda1b42b52cc23, 0xbfa60536d207883c,
    0x3fcbc969d8df1c84, 0x3fdd25e3be2a3045,
    0xbfdbfe10833a552b, 0xbfab5cf036993b30,
    0xbfda013f16002cee, 0xbfb7b0a3279cd733,
    0xbfe562e8e81c8b47, 0xc0464446df76a06c,
    0x3fa2487ed1f53466, 0x3fc574b307a7229c,
    0xbfc597ba76f6e046, 0x3fc1a9e0bf30c3f6,
    0xbfc8ebf7cb1a4085, 0x3fbc18a24a089988,
    0xbfb0458fc53cc944, 0x3fbedbe7781b5d24,
    0xbfcc8cb2c052db6d, 0xbfe33b6402839fa2,
    0x3fe31c8a040af7ea, 0xbfe0f0c705c696f7,
    0x3fd893dcbe163447, 0xbfa83a809fc56946,
    0xbfd07e81ba676bac, 0x3fb1c305703832ed,
    0x3fe4d62e976573fe, 0x3fbd52df8a77c18c,
    0xbfda48a7d6e463a8, 0xbfc438cdd2c8aa97,
    0x3fd0e119eac0c13d, 0xbfaf45cddcfe0b08,
    0xbfcfc6736e32e161, 0x3fd68fd385ae2bbd,
    0x3fb33383a5754186, 0xbfa0a256dff94311,
    0xbfec52d97803e8c0, 0x3fdbc18e519eb28d,
    0xbfbad6cb34ec37be, 0xbfbde6394b492cb8,
    0xbfa473d7068faff8, 0xbfe8442674b0d3c0,
    0xbfc2a6de10b5753b, 0x3fa6dbd576bfddfc,
    0x3fc177c1411793d0, 0x3fd0f2ba22eb98fd,
    0xbfc9e352703888ee, 0x3f9c700b4488eed4,
    0x3fc1aecb7d2291b9, 0xbfe17e247f2373c4,
    0xbfb006cca976459a, 0xbfdc8b9085eb71bd,
    0xbfd8895bd9a32dd5, 0xbfd060388521052b,
    0x3fd5354fdd1199bc, 0xbfdc6bfc6ef86a5e,
    0x3fe4962396c2f92a, 0xbfc74ab1c93fdf97,
    0xbfc9aca8f62d6b18, 0x3fad1ed4972dccdb,
    0xbfdfb0a9400b2861, 0x3fd4d2d1ab36c1aa,
    0xbfe2e732fa359e6e, 0xbfc5f92e3283aaec,
    0x3fd459655527225f, 0xbfe714dd9f079268,
    0x3fd33b310c3cefc6, 0xbfa483038dac0da2,
    0x3fe11f415697d337, 0xbfd7e77e8971f9d5,
    0x3fc115027ff93b46, 0x3feaf3e300348250,
    0xbfe5094240a69e49, 0xbfe6da55c9a4b620,
    0x3fda7ec576776287, 0xbfd534b6456da247,
    0x3f7fb7bc376804a0, 0x3fdd9b4edf66d1d1,
    0x3fd98ad7dc674eed, 0x3fa6f5a95661b308,
    0x3fd4c0354cc58585, 0xbfcdd4af4fad2d52,
    0x3fc6921e40a4cf7b, 0xbf8eed92e18c95e0,
    0xbfc8eb9671e460aa, 0xbfbff879e4f04c94,
    0x3fc450003ff30d24, 0x3fa23def396c6952,
    0xbfe08a8fc42f2cd2, 0xbfc504363293031a,
    0xbfd830c40f561ec5, 0x3fa6e55e16050608,
    0x3facc89ccf6f14fa, 0xbfe5289e684ce334,
    0x3fe28183d8829097, 0xbfd29a2db8f76ccf,
    0xbfde7aefb327b179, 0xbfd6c537ed3287f9,
    0x3fb9cf2d79e92e54, 0xbfc9e7d89260e03c,
    0xbfd8e0d5a4b5be97, 0xbfd85be423a2d6aa,
    0x3fd41f88d9b148d4, 0x3fba6f33b81d6d82,
    0xbf976070a1950bf0, 0x0,
    0x3fd41f88d9b148d3, 0xbfba6f33b81d6d88,
    0xbfd8e0d5a4b5be96, 0x3fd85be423a2d6aa,
    0x3fb9cf2d79e92e50, 0x3fc9e7d89260e03e,
    0xbfde7aefb327b17a, 0x3fd6c537ed3287f8,
    0x3fe28183d8829097, 0x3fd29a2db8f76ccf,
    0x3facc89ccf6f14f8, 0x3fe5289e684ce335,
    0xbfd830c40f561ec6, 0xbfa6e55e160505f8,
    0xbfe08a8fc42f2cd2, 0x3fc504363293031c,
    0x3fc450003ff30d22, 0xbfa23def396c6952,
    0xbfc8eb9671e460a8, 0x3fbff879e4f04c8c,
    0x3fc6921e40a4cf77, 0x3f8eed92e18c9620,
    0x3fd4c0354cc58585, 0x3fcdd4af4fad2d51,
    0x3fd98ad7dc674eee, 0xbfa6f5a95661b2f8,
    0x3f7fb7bc376804c0, 0xbfdd9b4edf66d1d2,
    0x3fda7ec576776286, 0x3fd534b6456da248,
    0xbfe5094240a69e49, 0x3fe6da55c9a4b620,
    0x3fc115027ff93b44, 0xbfeaf3e300348251,
    0x3fe11f415697d338, 0x3fd7e77e8971f9d5,
    0x3fd33b310c3cefc8, 0x3fa483038dac0d9f,
    0x3fd459655527225f, 0x3fe714dd9f079268,
    0xbfe2e732fa359e6f, 0x3fc5f92e3283aaf0,
    0xbfdfb0a9400b2863, 0xbfd4d2d1ab36c1a9,
    0xbfc9aca8f62d6b16, 0xbfad1ed4972dccd2,
    0x3fe4962396c2f92a, 0x3fc74ab1c93fdf96,
    0x3fd5354fdd1199bb, 0x3fdc6bfc6ef86a5d,
    0xbfd8895bd9a32dd4, 0x3fd060388521052c,
    0xbfb006cca97645a3, 0x3fdc8b9085eb71bd,
    0x3fc1aecb7d2291bb, 0x3fe17e247f2373c4,
    0xbfc9e352703888ef, 0xbf9c700b4488eef6,
    0x3fc177c1411793d0, 0xbfd0f2ba22eb98ff,
    0xbfc2a6de10b5753f, 0xbfa6dbd576bfde00,
    0xbfa473d7068faff8, 0x3fe8442674b0d3c0,
    0xbfbad6cb34ec37c2, 0x3fbde6394b492cb6,
    0xbfec52d97803e8c0, 0xbfdbc18e519eb28b,
    0x3fb33383a5754188, 0x3fa0a256dff94312,
    0xbfcfc6736e32e15f, 0xbfd68fd385ae2bbd,
    0x3fd0e119eac0c13e, 0x3faf45cddcfe0b18,
    0xbfda48a7d6e463a7, 0x3fc438cdd2c8aa94,
    0x3fe4d62e976573fe, 0xbfbd52df8a77c190,
    0xbfd07e81ba676baa, 0xbfb1c305703832ea,
    0x3fd893dcbe163446, 0x3fa83a809fc5694b,
    0x3fe31c8a040af7ea, 0x3fe0f0c705c696f7,
    0xbfcc8cb2c052db72, 0x3fe33b6402839fa3,
    0xbfb0458fc53cc944, 0xbfbedbe7781b5d24,
    0xbfc8ebf7cb1a4085, 0xbfbc18a24a089989,
    0xbfc597ba76f6e044, 0xbfc1a9e0bf30c3f6,
    0x3fa2487ed1f53460, 0xbfc574b307a72298,
    0xbfe562e8e81c8b47, 0x40464446df76a06c,
    0xbfda013f16002ced, 0x3fb7b0a3279cd733,
    0xbfdbfe10833a552a, 0x3fab5cf036993b38,
    0x3fcbc969d8df1c86, 0xbfdd25e3be2a3047,
    0x3fbda1b42b52cc23, 0x3fa60536d2078840,
    0xbfd8ed010d58e552, 0xbfe91008c5ec7db6,
    0x3fe3a4abd1db66cc, 0x3fe24aafe001ed94,
    0xbfe1e26a6cdefbbc, 0xbfc6c87525ce8362,
    0x3fb2219fefc6b162, 0xbfda4113dd0bad45,
    0x3fd9f8b8faa8b4b7, 0xbfe32d68f19802c6,
    0x3fcd407ff5e107f4, 0xbfc2daeb5e80e74e,
    0xbfe38af729020129, 0xbfbfda2ee1dd258c,
    0xbfdf732a6c5ec14f, 0x3fbd67b5471e6580,
    0x3fed1dc5db4099c6, 0x3fe0642c0c06929f,
    0x3fe07967b60706a4, 0x3fc925b0413018f0,
    0xbfabb219d819de14, 0xbfd20268b42c72b2
    };

static const uint64_t ref_cfft_noisy_128[256] = {
    0x3fd8e1ef5d2d50c1, 0x0,
    0xbfabb219d819de08, 0x3fd20268b42c72b3,
    0x3fe07967b60706a3, 0xbfc925b0413018f0,
    0x3fed1dc5db4099c6, 0xbfe0642c0c0692a0,
    0xbfdf732a6c5ec14e, 0xbfbd67b5471e657e,
    0xbfe38af729020129, 0x3fbfda2ee1dd2593,
    0x3fcd407ff5e107f4, 0x3fc2daeb5e80e74c,
    0x3fd9f8b8faa8b4b8, 0x3fe32d68f19802c6,
    0x3fb2219fefc6b162, 0x3fda4113dd0bad44,
    0xbfe1e26a6cdefbbc, 0x3fc6c87525ce835e,
    0x3fe3a4abd1db66cc, 0xbfe24aafe001ed94,
    0xbfd8ed010d58e550, 0x3fe91008c5ec7db8,
    0x3fbda1b42b52cc23, 0xbfa60536d207883c,
    0x3fcbc969d8df1c84, 0x3fdd25e3be2a3045,
    0xbfdbfe10833a552b, 0xbfab5cf036993b30,
    0xbfda013f16002cee, 0xbfb7b0a3279cd733,
    0xbfe562e8e81c8b47, 0xc0464446df76a06c,
    0x3fa2487ed1f53466, 0x3fc574b307a7229c,
    0xbfc597ba76f6e046, 0x3fc1a9e0bf30c3f6,
    0xbfc8ebf7cb1a4085, 0x3fbc18a24a089988,
    0xbfb0458fc53cc944, 0x3fbedbe7781b5d24,
    0xbfcc8cb2c052db6d, 0xbfe33b6402839fa2,
    0x3fe31c8a040af7ea, 0xbfe0f0c705c696f7,
    0x3fd893dcbe163447, 0xbfa83a809fc56946,
    0xbfd07e81ba676bac, 0x3fb1c305703832ed,
    0x3fe4d62e976573fe, 0x3fbd52df8a77c18c,
    0xbfda48a7d6e463a8, 0xbfc438cdd2c8aa97,
    0x3fd0e119eac0c13d, 0xbfaf45cddcfe0b08,
    0xbfcfc6736e32e161, 0x3fd68fd385ae2bbd,
    0x3fb33383a5754186, 0xbfa0a256dff94311,
    0xbfec52d97803e8c0, 0x3fdbc18e519eb28d,
    0xbfbad6cb34ec37be, 0xbfbde6394b492cb8,
    0xbfa473d7068faff8, 0xbfe8442674b0d3c0,
    0xbfc2a6de10b5753b, 0x3fa6dbd576bfddfc,
    0x3fc177c1411793d0, 0x3fd0f2ba22eb98fd,
    0xbfc9e352703888ee, 0x3f9c700b4488eed4,
    0x3fc1aecb7d2291b9, 0xbfe17e247f2373c4,
    0xbfb006cca976459a, 0xbfdc8b9085eb71bd,
    0xbfd8895bd9a32dd5, 0xbfd060388521052b,
    0x3fd5354fdd1199bc, 0xbfdc6bfc6ef86a5e,
    0x3fe4962396c2f92a, 0xbfc74ab1c93fdf97,
    0xbfc9aca8f62d6b18, 0x3fad1ed4972dccdb,
    0xbfdfb0a9400b2861, 0x3fd4d2d1ab36c1aa,
    0xbfe2e732fa359e6e, 0xbfc5f92e3283aaec,
    0x3fd459655527225f, 0xbfe714dd9f079268,
    0x3fd33b310c3cefc6, 0xbfa483038dac0da2,
    0x3fe11f415697d337, 0xbfd7e77e8971f9d5,
    0x3fc115027ff93b46, 0x3feaf3e300348250,
    0xbfe5094240a69e49, 0xbfe6da55c9a4b620,
    0x3fda7ec576776287, 0xbfd534b6456da247,
    0x3f7fb7bc376804a0, 0x3fdd9b4edf66d1d1,
    0x3fd98ad7dc674eed, 0x3fa6f5a95661b308,
    0x3fd4c0354cc58585, 0xbfcdd4af4fad2d52,
    0x3fc6921e40a4cf7b, 0xbf8eed92e18c95e0,
    0xbfc8eb9671e460aa, 0xbfbff879e4f04c94,
    0x3fc450003ff30d24, 0x3fa23def396c6952,
    0xbfe08a8fc42f2cd2, 0xbfc504363293031a,
    0xbfd830c40f561ec5, 0x3fa6e55e16050608,
    0x3facc89ccf6f14fa, 0xbfe5289e684ce334,
    0x3fe28183d8829097, 0xbfd29a2db8f76ccf,
    0xbfde7aefb327b179, 0xbfd6c537ed3287f9,
    0x3fb9cf2d79e92e54, 0xbfc9e7d89260e03c,
    0xbfd8e0d5a4b5be97, 0xbfd85be423a2d6aa,
    0x3fd41f88d9b148d4, 0x3fba6f33b81d6d82,
    0xbf976070a1950bf0, 0x0,
    0x3fd41f88d9b148d3, 0xbfba6f33b81d6d88,
    0xbfd8e0d5a4b5be96, 0x3fd85be423a2d6aa,
    0x3fb9cf2d79e92e50, 0x3fc9e7d89260e03e,
    0xbfde7aefb327b17a, 0x3fd6c537ed3287f8,
    0x3fe28183d8829097, 0x3fd29a2db8f76ccf,
    0x3facc89ccf6f14f8, 0x3fe5289e684ce335,
    0xbfd830c40f561ec6, 0xbfa6e55e160505f8,
    0xbfe08a8fc42f2cd2, 0x3fc504363293031c,
    0x3fc450003ff30d22, 0xbfa23def396c6952,
    0xbfc8eb9671e460a8, 0x3fbff879e4f04c8c,
    0x3fc6921e40a4cf77, 0x3f8eed92e18c9620,
    0x3fd4c0354cc58585, 0x3fcdd4af4fad2d51,
    0x3fd98ad7dc674eee, 0xbfa6f5a95661b2f8,
    0x3f7fb7bc376804c0, 0xbfdd9b4edf66d1d2,
    0x3fda7ec576776286, 0x3fd534b6456da248,
    0xbfe5094240a69e49, 0x3fe6da55c9a4b620,
    0x3fc115027ff93b44, 0xbfeaf3e300348251,
    0x3fe11f415697d338, 0x3fd7e77e8971f9d5,
    0x3fd33b310c3cefc8, 0x3fa483038dac0d9f,
    0x3fd459655527225f, 0x3fe714dd9f079268,
    0xbfe2e732fa359e6f, 0x3fc5f92e3283aaf0,
    0xbfdfb0a9400b2863, 0xbfd4d2d1ab36c1a9,
    0xbfc9aca8f62d6b16, 0xbfad1ed4972dccd2,
    0x3fe4962396c2f92a, 0x3fc74ab1c93fdf96,
    0x3fd5354fdd1199bb, 0x3fdc6bfc6ef86a5d,
    0xbfd8895bd9a32dd4, 0x3fd060388521052c,
    0xbfb006cca97645a3, 0x3fdc8b9085eb71bd,
    0x3fc1aecb7d2291bb, 0x3fe17e247f2373c4,
    0xbfc9e352703888ef, 0xbf9c700b4488eef6,
    0x3fc177c1411793d0, 0xbfd0f2ba22eb98ff,
    0xbfc2a6de10b5753f, 0xbfa6dbd576bfde00,
    0xbfa473d7068faff8, 0x3fe8442674b0d3c0,
    0xbfbad6cb34ec37c2, 0x3fbde6394b492cb6,
    0xbfec52d97803e8c0, 0xbfdbc18e519eb28b,
    0x3fb33383a5754188, 0x3fa0a256dff94312,
    0xbfcfc6736e32e15f, 0xbfd68fd385ae2bbd,
    0x3fd0e119eac0c13e, 0x3faf45cddcfe0b18,
    0xbfda48a7d6e463a7, 0x3fc438cdd2c8aa94,
    0x3fe4d62e976573fe, 0xbfbd52df8a77c190,
    0xbfd07e81ba676baa, 0xbfb1c305703832ea,
    0x3fd893dcbe163446, 0x3fa83a809fc5694b,
    0x3fe31c8a040af7ea, 0x3fe0f0c705c696f7,
    0xbfcc8cb2c052db72, 0x3fe33b6402839fa3,
    0xbfb0458fc53cc944, 0xbfbedbe7781b5d24,
    0xbfc8ebf7cb1a4085, 0xbfbc18a24a089989,
    0xbfc597ba76f6e044, 0xbfc1a9e0bf30c3f6,
    0x3fa2487ed1f53460, 0xbfc574b307a72298,
    0xbfe562e8e81c8b47, 0x40464446df76a06c,
    0xbfda013f16002ced, 0x3fb7b0a3279cd733,
    0xbfdbfe10833a552a, 0x3fab5cf036993b38,
    0x3fcbc969d8df1c86, 0xbfdd25e3be2a3047,
    0x3fbda1b42b52cc23, 0x3fa60536d2078840,
    0xbfd8ed010d58e552, 0xbfe91008c5ec7db6,
    0x3fe3a4abd1db66cc, 0x3fe24aafe001ed94,
    0xbfe1e26a6cdefbbc, 0xbfc6c87525ce8362,
    0x3fb2219fefc6b162, 0xbfda4113dd0bad45,
    0x3fd9f8b8faa8b4b7, 0xbfe32d68f19802c6,
    0x3fcd407ff5e107f4, 0xbfc2daeb5e80e74e,
    0xbfe38af729020129, 0xbfbfda2ee1dd258c,
    0xbfdf732a6c5ec14f, 0x3fbd67b5471e6580,
    0x3fed1dc5db4099c6, 0x3fe0642c0c06929f,
    0x3fe07967b60706a4, 0x3fc925b0413018f0,
    0xbfabb219d819de14, 0xbfd20268b42c72b2
    };

static const uint64_t in_cfft_noisy_256[512] = {
    0x3fa3a093d12bc8b0, 0x0,
    0x3fdda0360699b0b6, 0x0,
    0x3fe58b53c36213ca, 0x0,
    0x3fd9d909e82a632a, 0x0,
    0x3fa30d89aa484b7c, 0x0,
    0xbfde052c178cff92, 0x0,
    0xbfe4c01feebf9195, 0x0,
    0xbfe0d06b1215320d, 0x0,
    0x3f9d40e616b7f846, 0x0,
    0x3fd9e68e056c256e, 0x0,
    0x3fe6efa92e51a842, 0x0,
    0x3fe0244a6251f0cf, 0x0,
    0x3f916cb78d188a67, 0x0,
    0xbfdde0fd3397a256, 0x0,
    0xbfe93264e320ef7c, 0x0,
    0xbfe366ee18b15339, 0x0,
    0x3fb2c45acd014d6e, 0x0,
    0x3fddb0b513f14ab7, 0x0,
    0x3fe728dac05b5730, 0x0,
    0x3fe0da47ae41c695, 0x0,
    0xbf9adc31d0836ef8, 0x0,
    0xbfd9f25f307cd10c, 0x0,
    0xbfe589601b203c56, 0x0,
    0xbfe026153068095e, 0x0,
    0xbfaa567b3b58c43c, 0x0,
    0x3fde0b0e5655fb40, 0x0,
    0x3fe55d36cac59f0d, 0x0,
    0x3fdf2268d6ac8e9f, 0x0,
    0xbfab57a9886d5734, 0x0,
    0xbfdd7e11eff49191, 0x0,
    0xbfe78b5bae70f424, 0x0,
    0xbfe03c86eea560d5, 0x0,
    0xbf9f1e28dee66570, 0x0,
    0x3fe1fa57ef27c7f7, 0x0,
    0x3fe85402ab832e6c, 0x0,
    0x3fdaf2ce16aab555, 0x0,
    0xbfb043fb36e07c75, 0x0,
    0xbfe0d1b65841b4dc, 0x0,
    0xbfe784bd5576de1a, 0x0,
    0xbfdf01b5013e1d4c, 0x0,
    0x3fa5e23394f87321, 0x0,
    0x3fe10702c4679664, 0x0,
    0x3fe5fc3c1957c677, 0x0,
    0x3fdd58cac63c9b4b, 0x0,
    0xbfbc36bbd51a51c1, 0x0,
    0xbfe108bac2467d11, 0x0,
    0xbfe61630744d36ec, 0x0,
    0xbfdff8f2ef03cbe7, 0x0,
    0x3fae9704303668b9, 0x0,
    0x3fdc8a1cb704eebe, 0x0,
    0x3fe3e24eb0aa4079, 0x0,
    0x3fd98a4a36e9a47a, 0x0,
    0xbfb073cc57035866, 0x0,
    0xbfdf5b717e02204e, 0x0,
    0xbfe616579cac1174, 0x0,
    0xbfde524dd3b09a96, 0x0,
    0x3f895fed78dd1e40, 0x0,
    0x3fdd37f9f2452ac0, 0x0,
    0x3fe946f96344fc87, 0x0,
    0x3fe068643913c713, 0x0,
    0x3f7b96c775493ad3, 0x0,
    0xbfe194f303a2811e, 0x0,
    0xbfe528a3eafba170, 0x0,
    0xbfde39588aefbe13, 0x0,
    0x3f50a71b20a9a44a, 0x0,
    0x3fe00ed24c0a7aa8, 0x0,
    0x3fe88cdf110f526d, 0x0,
    0x3fe2db4964d40497, 0x0,
    0x3fa9f086bc47fb61, 0x0,
    0xbfe2d56eda57a7dc, 0x0,
    0xbfe888bf645ad483, 0x0,
    0xbfe00f523be5f936, 0x0,
    0x3f70fe0566706618, 0x0,
    0x3fe1a64541c07987, 0x0,
    0x3fe688ba223f2f38, 0x0,
    0x3fe0d3d659cd6723, 0x0,
    0xbfb2fe14f19c0565, 0x0,
    0xbfdf1a9f555392fb, 0x0,
    0xbfe73c7ab8b13e03, 0x0,
    0xbfe19a99c6ae28be, 0x0,
    0x3f79ee7d48a4d844, 0x0,
    0x3fde82574b13fc8f, 0x0,
    0x3fe291582e948a65, 0x0,
    0x3fdf0fb6954654a9, 0x0,
    0x3f9c75e3433a863e, 0x0,
    0xbfdda0260b1de97e, 0x0,
    0xbfe3c392f303b2a6, 0x0,
    0xbfddfc2f9c31a016, 0x0,
    0xbf95e94badc14c0e, 0x0,
    0x3fdf010166865cbe, 0x0,
    0x3fe5861e07a47bae, 0x0,
    0x3fde47d6a6a32b8c, 0x0,
    0xbf6778078904d25d, 0x0,
    0xbfdb06e8fab21ef5, 0x0,
    0xbfe6340f71b52bdd, 0x0,
    0xbfde2ee5429d33ae, 0x0,
    0xbfa67548eda75649, 0x0,
    0x3fe035d706a5a39a, 0x0,
    0x3fe3964dcc03be3d, 0x0,
    0x3fe19d32fe9beca9, 0x0,
    0x3f6f42f0ddc9d723, 0x0,
    0xbfdc8fe2ea0f96f6, 0x0,
    0xbfe4e670b3bd3e82, 0x0,
    0xbfdd6c9cdd977808, 0x0,
    0xbfb0901f3d74574b, 0x0,
    0x3fdc384a6cda70c2, 0x0,
    0x3fe775c118502175, 0x0,
    0x3fdf6a8c0d9e5df0, 0x0,
    0xbfaa75e13d2b1108, 0x0,
    0xbfdc859932fdfeae, 0x0,
    0xbfe594683b075275, 0x0,
    0xbfdd2dcbffa5461e, 0x0,
    0x3fb17b7c3d2f0f14, 0x0,
    0x3fdea2e33f75812c, 0x0,
    0x3fe5a242687e4b9d, 0x0,
    0x3fdf7daad6cfcabd, 0x0,
    0x3fb243e054132bb9, 0x0,
    0xbfdec5ef7af5f69e, 0x0,
    0xbfe53b116ee06265, 0x0,
    0xbfdb674e4ff0b4b1, 0x0,
    0x3fa54005ee7672ce, 0x0,
    0x3fdfb0dacb8c1e96, 0x0,
    0x3fe5c1361923c8b1, 0x0,
    0x3fdabf29a8056012, 0x0,
    0x3f6a39eb1089c235, 0x0,
    0xbfe11c539ca367bc, 0x0,
    0xbfe94fde1a8d0312, 0x0,
    0xbfe1806bf7b65f65, 0x0,
    0xbfa75ca512d0d90b, 0x0,
    0x3fde2d3178de2f7b, 0x0,
    0x3fe90ca729bfca9d, 0x0,
    0x3fd9766004431734, 0x0,
    0xbfa7f11e7d92d5cb, 0x0,
    0xbfddaf31f4946141, 0x0,
    0xbfe83fefa478e9db, 0x0,
    0xbfd88c4c7a69790b, 0x0,
    0xbf9303ca16b71b31, 0x0,
    0x3fdaa5632139bbec, 0x0,
    0x3fe7e678effb9e1f, 0x0,
    0x3fe129ae91336016, 0x0,
    0xbfb9bea0fd4fa4f2, 0x0,
    0xbfe155d3014f238d, 0x0,
    0xbfe7895f64636988, 0x0,
    0xbfde0d93411c6f70, 0x0,
    0x3faee917334f5f7b, 0x0,
    0x3fdce0537d28da5f, 0x0,
    0x3fe30421665bd283, 0x0,
    0x3fdce374ab67165c, 0x0,
    0x3fb1463965c714c4, 0x0,
    0xbfe2ecd9d47ed6ab, 0x0,
    0xbfe519765614afe2, 0x0,
    0xbfe123ff9741871a, 0x0,
    0xbf9c295345ed9ecd, 0x0,
    0x3fe2cce3777260b0, 0x0,
    0x3fe64ca2268949af, 0x0,
    0x3fdc3f0ae4f58dac, 0x0,
    0x3f9f21b9d4d591ff, 0x0,
    0xbfdd144b920a6761, 0x0,
    0xbfe5f78138126073, 0x0,
    0xbfde784b96e91a8a, 0x0,
    0x3f897a7b9153a8e5, 0x0,
    0x3fdcbfb419740cdb, 0x0,
    0x3fe5f4bf61f8b213, 0x0,
    0x3fd8403ca2523e94, 0x0,
    0x3f90e6571317538e, 0x0,
    0xbfde4f7105654e0e, 0x0,
    0xbfe75118ddab5475, 0x0,
    0xbfe27512e6f8d831, 0x0,
    0x3f8808e51e361e6b, 0x0,
    0x3fda67283d0aaafc, 0x0,
    0x3fe9319a1c3e7741, 0x0,
    0x3fe1cd2c610073af, 0x0,
    0x3f9ab2c076cc4950, 0x0,
    0xbfe0dc81c9d4bfcc, 0x0,
    0xbfe856f39ab4cb65, 0x0,
    0xbfe048e689cff4f2, 0x0,
    0x3f9dc34031b2b1c5, 0x0,
    0x3fdd05d4c7192f60, 0x0,
    0x3fe78673387aec64, 0x0,
    0x3fddd2d445c6ea56, 0x0,
    0x3fad1ca71a07bac2, 0x0,
    0xbfe06c4c1a3481cb, 0x0,
    0xbfe743eac49017b4, 0x0,
    0xbfe06342619440f7, 0x0,
    0x3f922a6e77857f87, 0x0,
    0x3fdc745d340fdf88, 0x0,
    0x3fe656b2da7f7ef3, 0x0,
    0x3fe1d70db388f6b5, 0x0,
    0x3fa9184d0ccf751e, 0x0,
    0xbfe080171dc6243e, 0x0,
    0xbfe7cf4b9a28e03d, 0x0,
    0xbfdfcb06c28ac725, 0x0,
    0x3f97b25687ab0ab8, 0x0,
    0x3fde3171004fae23, 0x0,
    0x3fe765de09adce76, 0x0,
    0x3fdd04dc13324d72, 0x0,
    0xbfb3270f38dbd187, 0x0,
    0xbfe0e37a81f54efe, 0x0,
    0xbfe562679d151d41, 0x0,
    0xbfe028d6189c062a, 0x0,
    0xbfa3b0bdf589cf53, 0x0,
    0x3fdfa5dc81e5795d, 0x0,
    0x3fe75fd702873553, 0x0,
    0x3fe0c5de2e85ef63, 0x0,
    0xbfaa4a85498f5c69, 0x0,
    0xbfe0b76916c51083, 0x0,
    0xbfe595fe16b8eea3, 0x0,
    0xbfe004bc641ba5f6, 0x0,
    0x3f9b26ada4103553, 0x0,
    0x3fde99fe131ca6c2, 0x0,
    0x3fe5c898cc507f89, 0x0,
    0x3fe0aa28bb68e6cf, 0x0,
    0x3fc2c87726174a9e, 0x0,
    0xbfe1f2f6525cfdd5, 0x0,
    0xbfe3c9073b1ee31d, 0x0,
    0xbfe283e780229269, 0x0,
    0xbf936af1f55a1568, 0x0,
    0x3fe148dca9e7ca20, 0x0,
    0x3fe82393992d2d20, 0x0,
    0x3fdf46bd519f35eb, 0x0,
    0x3fa48c312301e7c0, 0x0,
    0xbfe0d73890b24f4d, 0x0,
    0xbfe68680bec8bcaf, 0x0,
    0xbfdc491c2abc6e26, 0x0,
    0xbfa0cb916b9fdaf8, 0x0,
    0x3fe28d07cb3df399, 0x0,
    0x3fe3b22798212b6e, 0x0,
    0x3fdcfed937f738d7, 0x0,
    0x3fafe62da50d7f52, 0x0,
    0xbfe109cbcee74d51, 0x0,
    0xbfe50dcc89478446, 0x0,
    0xbfde7888c3f1cddb, 0x0,
    0xbf936af60419bc2a, 0x0,
    0x3fddd9cce394658f, 0x0,
    0x3fe4edccda3618d5, 0x0,
    0x3fdf189e71237858, 0x0,
    0x3fafe2e19244bf2f, 0x0,
    0xbfdfa5a90b071b20, 0x0,
    0xbfe4d5106ac7dcc4, 0x0,
    0xbfe0f7e46bf2fa48, 0x0,
    0x3f9065dd70f01b14, 0x0,
    0x3fdd4fcc264a122d, 0x0,
    0x3fe7f05a8f1f3048, 0x0,
    0x3fdcc6e7c9a8cf77, 0x0,
    0x3fb12c2abd2e6ef5, 0x0,
    0xbfda365194af391d, 0x0,
    0xbfe6a61e97aa62d3, 0x0,
    0xbfe04548ada7b219, 0x0,
    0x3f79cdb54bc8e432, 0x0,
    0x3fdfe7c01c1fa5cd, 0x0,
    0x3fe75fb2f9d88d3d, 0x0,
    0x3fdf4cabb2881a94, 0x0,
    0x3f9fd8a6079d0bdb, 0x0,
    0xbfde94af658751e1, 0x0,
    0xbfe6ef6bdb9e446c, 0x0,
    0xbfe27c76f5c2950b, 0x0
    };

static const uint64_t in_cifft_noisy_256[512] = {
    0xbfe927f57c820850, 0x0,
    0x3fcb6f4e54f81206, 0x3fbe20f4129d80d8,
    0xbfa6979d8d8580d8, 0x3ff14d241b256560,
    0x3fd17ac2e231edb6, 0xbfa6843af1c1fd50,
    0xbfc35dd14a4cdc7c, 0x3fd3996754c169d1,
    0x3fc88b431267d778, 0xbfe5b31c1ef16cd6,
    0xbfe4d030cc0135fa, 0x3fce1e30f0251405,
    0x3fd43efa607b7b2d, 0x3fe4c2de61a4ab40,
    0xbfacafaf7fa93958, 0x3fe8560e08196b1b,
    0xbfc0c4044c41e16b, 0xbfdba7f939e18226,
    0xbfed597ab9597911, 0xbfd1dd0b4c682b83,
    0x3fc36e4b40fddad0, 0x3fe91b2a14ffde9c,
    0xbfc1284d8f62a018, 0xbfd676a652698626,
    0x3fdd837e728f5633, 0x3fd90713a2abf06b,
    0xbfe5c9cf9c96fc06, 0xbfe41c7aa999e06d,
    0x3fe315bfdf396d62, 0xbfcd7b59af71bcf9,
    0xbfe50153c0cc0fac, 0xbfc0d4bb05015d70,
    0xbfd0ee2ee77444f4, 0x3fb26746ea95e224,
    0x3fbec24f1b234da5, 0xbfe257b511472f4e,
    0xbfe34c53fbfa8632, 0x3fc226a573f0d7f3,
    0xbfe3d45daf871437, 0xbfa104787204fac8,
    0xbfc2693af774af3b, 0x3fd6e10a99299282,
    0xbfe463b2c34fb3e7, 0x3fbbea52fedbda5c,
    0x3fe27ab9785b4ba5, 0x3fe402235a1cff4b,
    0x3fdd1a9f6f50aea3, 0x3fc0f6ae1cfb65a0,
    0xbfddac143ed3d1b7, 0x3fc45b28adb18685,
    0xbfb7cc64d1d20167, 0xbfc7cc4062112513,
    0x3fe6b9ddbea342f4, 0x3fc3ce79029f3f62,
    0x3fd9ed2560eaf6ee, 0xbfed4d6b8cc15a64,
    0xbff52a175c683427, 0xbfc619886ab09eb0,
    0x3fd41efaff950f60, 0x3ff52bae00cff2ff,
    0xbfe4e4a3b97346c0, 0x3fcf12ba0b47d5b6,
    0xbfb1d2d99334006c, 0xc0564cbb42c99726,
    0x3f467765d4f93200, 0xbfe88538e32c581d,
    0xbfea471684cd3c27, 0x3fb672e010a4d070,
    0xbff0d9c6a896c096, 0x3fdf04ef765b7957,
    0xbfc2d56f120bf0b0, 0xbfe2a0f8cd4bccc7,
    0xbfd51c178e9bd002, 0x3ff2faa200e1fb10,
    0x3fdff65c4ba7925f, 0x3fc2855ae2b882a9,
    0x3ff3fa2a98ea0dcd, 0xbff3bcdac8466800,
    0xbfd2cd796c1f2818, 0xbfe8d81c411a8dee,
    0x3fc1c2e1d573ed9a, 0x3fe8161d8e1e0059,
    0x3fe41eeb488a13bd, 0x3feac89cb1761c62,
    0x3f979c45debf8dc0, 0x3fed78dd6f27fce2,
    0xbfcbea2c659d7800, 0xbfdb5ed19cee41fd,
    0x3fee55088883bb38, 0x3fb3c455b80b9271,
    0x3fda928f58fdbc86, 0xbfd30ac77d9fcab5,
    0x3fbdbffd0027e83c, 0xbfeb9d31bd6d5ab4,
    0x3ff6dca291b63284, 0x3fc10700595e256c,
    0x3f8beca26ff0bd38, 0x3fbf9181bff80e44,
    0xbfc8ae8f3e64c391, 0xbfe7c1a7093db36b,
    0xbfe3249069f90585, 0xbfd036be3ba6ece9,
    0x3fb60578576a37c4, 0xbfe07bbf32a26eef,
    0x3fe6d5acb0bb5301, 0x3fe7a61ae0f3e6af,
    0xbfc0828a1d0cebbc, 0xbfe6e3f138f5ebc0,
    0xbfe110bd122d8972, 0x3fe75d3103a40c90,
    0xbfefad2936e5c103, 0xbfed59673cf0b4e4,
    0x3ff11bb2da5979ef, 0x3feb6678aaf553bf,
    0xbfdf6f4a3ce35b4f, 0xbfd651b2c49f99ed,
    0xbfd6b2d650ff0530, 0x3fbe9defc862d7ec,
    0x3fb1f98fd18bee83, 0x3fe0bd9fc5289d6c,
    0x3fe48f965bd2af79, 0xbfe244e63ee829fb,
    0x3fdf684d5a5904c1, 0xbfe3a3f893e845cd,
    0x3fc496ef1d5bae8a, 0xbfeea453db31eab5,
    0x3fd27c23911c3ce1, 0xbfc3c98bfa016e80,
    0xbfbcb63a28c869ac, 0xbfd0ecd1fb2c0a14,
    0x3fbc180127ce1824, 0xbfe3028065b9ab20,
    0x3fdacb495f996d75, 0xbfb56fdbb430203a,
    0x3faeeb610c5daade, 0x3fe6476cb2440fb5,
    0xbfc3f730bae70112, 0xbfd9ed12106303e1,
    0x3fea6b85da86e4b9, 0xbfe70bb68df8c196,
    0xbfb834bc22da051c, 0xbfde0a75335f8ce0,
    0x3f800a4d7e3f4840, 0x3fa8332e11bec528,
    0x3f9b668f6ba7c8b0, 0xbfa78349daa9a2d8,
    0xbfb4ef7f988bdad5, 0xbfc05a53b4ff3f26,
    0x3fe2657aef845b66, 0x3fd0009335a5fe53,
    0xbfd4765e1686f8f0, 0x3fe657b5267fb1d8,
    0xbfc020ec4adca541, 0x3fcaeac179acdad0,
    0xbfc5573745e4695f, 0xbfe30025f056afcc,
    0x3f879a4e92be04d0, 0x3fdcc1eff06b0071,
    0x3fe2d022fc943ac9, 0xbfec795eee3604cd,
    0xbfe3317e20642728, 0xbfaf78cf89387b88,
    0x3fd21c7ce7cf11d4, 0x3fd5cfbf5ba91a4f,
    0x3fd6ef9ca9d5e0de, 0xbfafc15e43582672,
    0xbfdab845930686e2, 0xbfea72a7ff1a13b9,
    0x3fe4b63291a1eb98, 0xbfd3fbb6fc4890cc,
    0xbfe794538540e1d8, 0xbfd3a6aa3fb3f6cf,
    0x3fe745be2ad03e0b, 0xbfe94e9210d31b80,
    0xbff5d9697d0b1aa8, 0x3feebaa0b6cd703a,
    0x3fbc8e23d7d5f848, 0xbfea346814cfbb7c,
    0xbfa9cf6474c05d80, 0x3fdd5b97266036f8,
    0x3fccdd9a8fb4108d, 0xbfe01b2531da4ffb,
    0x3ff2a4a85b7a25d0, 0x3fe88f4f1c36e749,
    0x3fc88362a46431ec, 0x3fea585116b5a7aa,
    0xbfe9c74df5f20789, 0x3ff514be77b914c0,
    0x3fc9d52ca8f62f96, 0x3fcadda01389fdba,
    0x3fb88e49b3450994, 0x3fdf2d3e0623cb80,
    0x3fcc1693a35e6469, 0xbfed6a81e6f82152,
    0x3feba6f87e90e2b3, 0xbf9e9118fd0fae80,
    0x3fec7c77a281d11d, 0xbfe8cc0c6d325a20,
    0xbfc3a0e88b801530, 0x3fe3d633f6d7ab99,
    0x3fbc5de6efc63be0, 0xbfd2677d3ad7095a,
    0x3fc08b93d3415dbc, 0x3fc863a2a1a31c36,
    0xbfef1dbc8fa4c66e, 0xbfde413cdb57c978,
    0xbfe130527c4c38c8, 0xbfc978c1cac10c34,
    0xbfe0dc682225ca0e, 0x3fe4d8dcb6ed14c5,
    0x3fca47c7c5c6eca2, 0xbfd7ac861d0f1341,
    0xbfb55f52a8daa9f7, 0xbfde04b0afe0ccae,
    0x3fd1ede788107380, 0xbfd3f382ed780f13,
    0xbf6f42a58bbb3d00, 0xbfc08156c872c182,
    0x3fc0695a89c4f315, 0x3fd37fe68b65f56a,
    0x3fe08f507c46724a, 0x3fab9abcc87b4a24,
    0x3fb110814ae271b4, 0x3fec67cae617a58c,
    0xbfd62b3b743b5e94, 0xbfcbe54c32679b6e,
    0x3fde161aefa5169e, 0xbfdf451526d338e9,
    0xbfb3cf4d4cb99310, 0x3f919e26d641f4b8,
    0x3ff1763d9c450533, 0xbfab08ff5c617414,
    0xbfc348ed3271383c, 0x3fe028c16020a25e,
    0xbfe3fc6afa6cf420, 0x3fe7a99205053627,
    0xbfc614b721bb1749, 0x3fe8fcf365d55144,
    0xbfe1e5b07911282e, 0xbfdc2d49029954d6,
    0xbfb152024c29a5c2, 0x3fcb686382669780,
    0x3fe0f60dab2c7064, 0xbfac68e9734b1e38,
    0x3fe2166585ef006f, 0x3ff00a2bb4d91df0,
    0x3fe92711813ea3ea, 0xbfde706cd13ee7fa,
    0x3fd3e8d535a3ff92, 0xbfe1e84eb0a38b3e,
    0x3fba2dba70139658, 0x3fd9aceba4853012,
    0x3fe46495550b3273, 0xbff3b1432e8a1d9f,
    0x3ff7df9746b25918, 0x0,
    0x3fe46495550b3272, 0x3ff3b1432e8a1d9e,
    0x3fba2dba70139654, 0xbfd9aceba4853012,
    0x3fd3e8d535a3ff94, 0x3fe1e84eb0a38b3f,
    0x3fe92711813ea3eb, 0x3fde706cd13ee7fb,
    0x3fe2166585ef006f, 0xbff00a2bb4d91df0,
    0x3fe0f60dab2c7064, 0x3fac68e9734b1e44,
    0xbfb152024c29a5cc, 0xbfcb686382669779,
    0xbfe1e5b07911282e, 0x3fdc2d49029954d6,
    0xbfc614b721bb1751, 0xbfe8fcf365d55145,
    0xbfe3fc6afa6cf41f, 0xbfe7a99205053626,
    0xbfc348ed32713840, 0xbfe028c16020a260,
    0x3ff1763d9c450533, 0x3fab08ff5c617410,
    0xbfb3cf4d4cb9930c, 0xbf919e26d641f4e0,
    0x3fde161aefa516a0, 0x3fdf451526d338eb,
    0xbfd62b3b743b5e92, 0x3fcbe54c32679b6b,
    0x3fb110814ae271b4, 0xbfec67cae617a58c,
    0x3fe08f507c46724a, 0xbfab9abcc87b4a38,
    0x3fc0695a89c4f315, 0xbfd37fe68b65f569,
    0xbf6f42a58bbb3c80, 0x3fc08156c872c181,
    0x3fd1ede788107382, 0x3fd3f382ed780f13,
    0xbfb55f52a8daa9f6, 0x3fde04b0afe0ccb0,
    0x3fca47c7c5c6eca1, 0x3fd7ac861d0f1341,
    0xbfe0dc682225ca0f, 0xbfe4d8dcb6ed14c5,
    0xbfe130527c4c38c8, 0x3fc978c1cac10c34,
    0xbfef1dbc8fa4c66c, 0x3fde413cdb57c976,
    0x3fc08b93d3415dba, 0xbfc863a2a1a31c37,
    0x3fbc5de6efc63be0, 0x3fd2677d3ad7095d,
    0xbfc3a0e88b80152c, 0xbfe3d633f6d7ab9a,
    0x3fec7c77a281d11d, 0x3fe8cc0c6d325a20,
    0x3feba6f87e90e2b4, 0x3f9e9118fd0fae80,
    0x3fcc1693a35e6468, 0x3fed6a81e6f82152,
    0x3fb88e49b3450994, 0xbfdf2d3e0623cb80,
    0x3fc9d52ca8f62f98, 0xbfcadda01389fdbc,
    0xbfe9c74df5f20789, 0xbff514be77b914bf,
    0x3fc88362a46431e4, 0xbfea585116b5a7ac,
    0x3ff2a4a85b7a25d0, 0xbfe88f4f1c36e747,
    0x3fccdd9a8fb4108d, 0x3fe01b2531da4ffb,
    0xbfa9cf6474c05d88, 0xbfdd5b97266036fc,
    0x3fbc8e23d7d5f850, 0x3fea346814cfbb7c,
    0xbff5d9697d0b1aa8, 0xbfeebaa0b6cd703a,
    0x3fe745be2ad03e0a, 0x3fe94e9210d31b81,
    0xbfe794538540e1d9, 0x3fd3a6aa3fb3f6cd,
    0x3fe4b63291a1eb9a, 0x3fd3fbb6fc4890cb,
    0xbfdab845930686e2, 0x3fea72a7ff1a13b8,
    0x3fd6ef9ca9d5e0e0, 0x3fafc15e4358268a,
    0x3fd21c7ce7cf11d8, 0xbfd5cfbf5ba91a4f,
    0xbfe3317e20642726, 0x3faf78cf89387b80,
    0x3fe2d022fc943ac9, 0x3fec795eee3604cd,
    0x3f879a4e92be04e8, 0xbfdcc1eff06b0071,
    0xbfc5573745e46965, 0x3fe30025f056afcd,
    0xbfc020ec4adca53c, 0xbfcaeac179acdacc,
    0xbfd4765e1686f8ef, 0xbfe657b5267fb1d9,
    0x3fe2657aef845b67, 0xbfd0009335a5fe54,
    0xbfb4ef7f988bdac9, 0x3fc05a53b4ff3f20,
    0x3f9b668f6ba7c890, 0x3fa78349daa9a2d8,
    0x3f800a4d7e3f4840, 0xbfa8332e11bec528,
    0xbfb834bc22da0514, 0x3fde0a75335f8cda,
    0x3fea6b85da86e4ba, 0x3fe70bb68df8c196,
    0xbfc3f730bae70115, 0x3fd9ed12106303dd,
    0x3faeeb610c5daad2, 0xbfe6476cb2440fb6,
    0x3fdacb495f996d75, 0x3fb56fdbb4302048,
    0x3fbc180127ce1824, 0x3fe3028065b9ab1f,
    0xbfbcb63a28c869a0, 0x3fd0ecd1fb2c0a12,
    0x3fd27c23911c3ce1, 0x3fc3c98bfa016e80,
    0x3fc496ef1d5bae8c, 0x3feea453db31eab6,
    0x3fdf684d5a5904c1, 0x3fe3a3f893e845cc,
    0x3fe48f965bd2af79, 0x3fe244e63ee829fc,
    0x3fb1f98fd18bee7d, 0xbfe0bd9fc5289d6d,
    0xbfd6b2d650ff0531, 0xbfbe9defc862d7ec,
    0xbfdf6f4a3ce35b4e, 0x3fd651b2c49f99f0,
    0x3ff11bb2da5979ef, 0xbfeb6678aaf553c0,
    0xbfefad2936e5c103, 0x3fed59673cf0b4e4,
    0xbfe110bd122d8972, 0xbfe75d3103a40c92,
    0xbfc0828a1d0cebb6, 0x3fe6e3f138f5ebc0,
    0x3fe6d5acb0bb52fe, 0xbfe7a61ae0f3e6ae,
    0x3fb60578576a37c6, 0x3fe07bbf32a26ef0,
    0xbfe3249069f90586, 0x3fd036be3ba6ece7,
    0xbfc8ae8f3e64c397, 0x3fe7c1a7093db36a,
    0x3f8beca26ff0bd10, 0xbfbf9181bff80e44,
    0x3ff6dca291b63284, 0xbfc10700595e256c,
    0x3fbdbffd0027e840, 0x3feb9d31bd6d5ab4,
    0x3fda928f58fdbc86, 0x3fd30ac77d9fcab5,
    0x3fee55088883bb37, 0xbfb3c455b80b9269,
    0xbfcbea2c659d77fc, 0x3fdb5ed19cee41fe,
    0x3f979c45debf8db0, 0xbfed78dd6f27fce4,
    0x3fe41eeb488a13bc, 0xbfeac89cb1761c60,
    0x3fc1c2e1d573ed9c, 0xbfe8161d8e1e005a,
    0xbfd2cd796c1f2818, 0x3fe8d81c411a8dee,
    0x3ff3fa2a98ea0dcc, 0x3ff3bcdac8466800,
    0x3fdff65c4ba7925e, 0xbfc2855ae2b882a7,
    0xbfd51c178e9bd000, 0xbff2faa200e1fb0e,
    0xbfc2d56f120bf0b0, 0x3fe2a0f8cd4bccc9,
    0xbff0d9c6a896c096, 0xbfdf04ef765b7953,
    0xbfea471684cd3c27, 0xbfb672e010a4d070,
    0x3f467765d4f93200, 0x3fe88538e32c581c,
    0xbfb1d2d99334006c, 0x40564cbb42c99726,
    0xbfe4e4a3b97346c0, 0xbfcf12ba0b47d5b8,
    0x3fd41efaff950f62, 0xbff52bae00cff300,
    0xbff52a175c683427, 0x3fc619886ab09eaa,
    0x3fd9ed2560eaf6ee, 0x3fed4d6b8cc15a61,
    0x3fe6b9ddbea342f6, 0xbfc3ce79029f3f63,
    0xbfb7cc64d1d2016c, 0x3fc7cc4062112514,
    0xbfddac143ed3d1bb, 0xbfc45b28adb18684,
    0x3fdd1a9f6f50aea3, 0xbfc0f6ae1cfb65a0,
    0x3fe27ab9785b4ba6, 0xbfe402235a1cff4b,
    0xbfe463b2c34fb3e8, 0xbfbbea52fedbda54,
    0xbfc2693af774af38, 0xbfd6e10a99299280,
    0xbfe3d45daf871436, 0x3fa104787204fae8,
    0xbfe34c53fbfa8631, 0xbfc226a573f0d7f2,
    0x3fbec24f1b234d9e, 0x3fe257b511472f4d,
    0xbfd0ee2ee77444f7, 0xbfb26746ea95e222,
    0xbfe50153c0cc0fac, 0x3fc0d4bb05015d70,
    0x3fe315bfdf396d61, 0x3fcd7b59af71bcfe,
    0xbfe5c9cf9c96fc05, 0x3fe41c7aa999e06c,
    0x3fdd837e728f5634, 0xbfd90713a2abf06c,
    0xbfc1284d8f62a01e, 0x3fd676a652698626,
    0x3fc36e4b40fddad0, 0xbfe91b2a14ffde9c,
    0xbfed597ab9597910, 0x3fd1dd0b4c682b82,
    0xbfc0c4044c41e167, 0x3fdba7f939e18224,
    0xbfacafaf7fa93958, 0xbfe8560e08196b1b,
    0x3fd43efa607b7b2a, 0xbfe4c2de61a4ab3f,
    0xbfe4d030cc0135fc, 0xbfce1e30f0251406,
    0x3fc88b431267d778, 0x3fe5b31c1ef16cd5,
    0xbfc35dd14a4cdc80, 0xbfd3996754c169d2,
    0x3fd17ac2e231edb6, 0x3fa6843af1c1fd48,
    0xbfa6979d8d8580e0, 0xbff14d241b256560,
    0x3fcb6f4e54f81203, 0xbfbe20f4129d80d0
    };

static const uint64_t ref_cfft_noisy_256[512] = {
    0xbfe927f57c820850, 0x0,
    0x3fcb6f4e54f81206, 0x3fbe20f4129d80d8,
    0xbfa6979d8d8580d8, 0x3ff14d241b256560,
    0x3fd17ac2e231edb6, 0xbfa6843af1c1fd50,
    0xbfc35dd14a4cdc7c, 0x3fd3996754c169d1,
    0x3fc88b431267d778, 0xbfe5b31c1ef16cd6,
    0xbfe4d030cc0135fa, 0x3fce1e30f0251405,
    0x3fd43efa607b7b2d, 0x3fe4c2de61a4ab40,
    0xbfacafaf7fa93958, 0x3fe8560e08196b1b,
    0xbfc0c4044c41e16b, 0xbfdba7f939e18226,
    0xbfed597ab9597911, 0xbfd1dd0b4c682b83,
    0x3fc36e4b40fddad0, 0x3fe91b2a14ffde9c,
    0xbfc1284d8f62a018, 0xbfd676a652698626,
    0x3fdd837e728f5633, 0x3fd90713a2abf06b,
    0xbfe5c9cf9c96fc06, 0xbfe41c7aa999e06d,
    0x3fe315bfdf396d62, 0xbfcd7b59af71bcf9,
    0xbfe50153c0cc0fac, 0xbfc0d4bb05015d70,
    0xbfd0ee2ee77444f4, 0x3fb26746ea95e224,
    0x3fbec24f1b234da5, 0xbfe257b511472f4e,
    0xbfe34c53fbfa8632, 0x3fc226a573f0d7f3,
    0xbfe3d45daf871437, 0xbfa104787204fac8,
    0xbfc2693af774af3b, 0x3fd6e10a99299282,
    0xbfe463b2c34fb3e7, 0x3fbbea52fedbda5c,
    0x3fe27ab9785b4ba5, 0x3fe402235a1cff4b,
    0x3fdd1a9f6f50aea3, 0x3fc0f6ae1cfb65a0,
    0xbfddac143ed3d1b7, 0x3fc45b28adb18685,
    0xbfb7cc64d1d20167, 0xbfc7cc4062112513,
    0x3fe6b9ddbea342f4, 0x3fc3ce79029f3f62,
    0x3fd9ed2560eaf6ee, 0xbfed4d6b8cc15a64,
    0xbff52a175c683427, 0xbfc619886ab09eb0,
    0x3fd41efaff950f60, 0x3ff52bae00cff2ff,
    0xbfe4e4a3b97346c0, 0x3fcf12ba0b47d5b6,
    0xbfb1d2d99334006c, 0xc0564cbb42c99726,
    0x3f467765d4f93200, 0xbfe88538e32c581d,
    0xbfea471684cd3c27, 0x3fb672e010a4d070,
    0xbff0d9c6a896c096, 0x3fdf04ef765b7957,
    0xbfc2d56f120bf0b0, 0xbfe2a0f8cd4bccc7,
    0xbfd51c178e9bd002, 0x3ff2faa200e1fb10,
    0x3fdff65c4ba7925f, 0x3fc2855ae2b882a9,
    0x3ff3fa2a98ea0dcd, 0xbff3bcdac8466800,
    0xbfd2cd796c1f2818, 0xbfe8d81c411a8dee,
    0x3fc1c2e1d573ed9a, 0x3fe8161d8e1e0059,
    0x3fe41eeb488a13bd, 0x3feac89cb1761c62,
    0x3f979c45debf8dc0, 0x3fed78dd6f27fce2,
    0xbfcbea2c659d7800, 0xbfdb5ed19cee41fd,
    0x3fee55088883bb38, 0x3fb3c455b80b9271,
    0x3fda928f58fdbc86, 0xbfd30ac77d9fcab5,
    0x3fbdbffd0027e83c, 0xbfeb9d31bd6d5ab4,
    0x3ff6dca291b63284, 0x3fc10700595e256c,
    0x3f8beca26ff0bd38, 0x3fbf9181bff80e44,
    0xbfc8ae8f3e64c391, 0xbfe7c1a7093db36b,
    0xbfe3249069f90585, 0xbfd036be3ba6ece9,
    0x3fb60578576a37c4, 0xbfe07bbf32a26eef,
    0x3fe6d5acb0bb5301, 0x3fe7a61ae0f3e6af,
    0xbfc0828a1d0cebbc, 0xbfe6e3f138f5ebc0,
    0xbfe110bd122d8972, 0x3fe75d3103a40c90,
    0xbfefad2936e5c103, 0xbfed59673cf0b4e4,
    0x3ff11bb2da5979ef, 0x3feb6678aaf553bf,
    0xbfdf6f4a3ce35b4f, 0xbfd651b2c49f99ed,
    0xbfd6b2d650ff0530, 0x3fbe9defc862d7ec,
    0x3fb1f98fd18bee83, 0x3fe0bd9fc5289d6c,
    0x3fe48f965bd2af79, 0xbfe244e63ee829fb,
    0x3fdf684d5a5904c1, 0xbfe3a3f893e845cd,
    0x3fc496ef1d5bae8a, 0xbfeea453db31eab5,
    0x3fd27c23911c3ce1, 0xbfc3c98bfa016e80,
    0xbfbcb63a28c869ac, 0xbfd0ecd1fb2c0a14,
    0x3fbc180127ce1824, 0xbfe3028065b9ab20,
    0x3fdacb495f996d75, 0xbfb56fdbb430203a,
    0x3faeeb610c5daade, 0x3fe6476cb2440fb5,
    0xbfc3f730bae70112, 0xbfd9ed12106303e1,
    0x3fea6b85da86e4b9, 0xbfe70bb68df8c196,
    0xbfb834bc22da051c, 0xbfde0a75335f8ce0,
    0x3f800a4d7e3f4840, 0x3fa8332e11bec528,
    0x3f9b668f6ba7c8b0, 0xbfa78349daa9a2d8,
    0xbfb4ef7f988bdad5, 0xbfc05a53b4ff3f26,
    0x3fe2657aef845b66, 0x3fd0009335a5fe53,
    0xbfd4765e1686f8f0, 0x3fe657b5267fb1d8,
    0xbfc020ec4adca541, 0x3fcaeac179acdad0,
    0xbfc5573745e4695f, 0xbfe30025f056afcc,
    0x3f879a4e92be04d0, 0x3fdcc1eff06b0071,
    0x3fe2d022fc943ac9, 0xbfec795eee3604cd,
    0xbfe3317e20642728, 0xbfaf78cf89387b88,
    0x3fd21c7ce7cf11d4, 0x3fd5cfbf5ba91a4f,
    0x3fd6ef9ca9d5e0de, 0xbfafc15e43582672,
    0xbfdab845930686e2, 0xbfea72a7ff1a13b9,
    0x3fe4b63291a1eb98, 0xbfd3fbb6fc4890cc,
    0xbfe794538540e1d8, 0xbfd3a6aa3fb3f6cf,
    0x3fe745be2ad03e0b, 0xbfe94e9210d31b80,
    0xbff5d9697d0b1aa8, 0x3feebaa0b6cd703a,
    0x3fbc8e23d7d5f848, 0xbfea346814cfbb7c,
    0xbfa9cf6474c05d80, 0x3fdd5b97266036f8,
    0x3fccdd9a8fb4108d, 0xbfe01b2531da4ffb,
    0x3ff2a4a85b7a25d0, 0x3fe88f4f1c36e749,
    0x3fc88362a46431ec, 0x3fea585116b5a7aa,
    0xbfe9c74df5f20789, 0x3ff514be77b914c0,
    0x3fc9d52ca8f62f96, 0x3fcadda01389fdba,
    0x3fb88e49b3450994, 0x3fdf2d3e0623cb80,
    0x3fcc1693a35e6469, 0xbfed6a81e6f82152,
    0x3feba6f87e90e2b3, 0xbf9e9118fd0fae80,
    0x3fec7c77a281d11d, 0xbfe8cc0c6d325a20,
    0xbfc3a0e88b801530, 0x3fe3d633f6d7ab99,
    0x3fbc5de6efc63be0, 0xbfd2677d3ad7095a,
    0x3fc08b93d3415dbc, 0x3fc863a2a1a31c36,
    0xbfef1dbc8fa4c66e, 0xbfde413cdb57c978,
    0xbfe130527c4c38c8, 0xbfc978c1cac10c34,
    0xbfe0dc682225ca0e, 0x3fe4d8dcb6ed14c5,
    0x3fca47c7c5c6eca2, 0xbfd7ac861d0f1341,
    0xbfb55f52a8daa9f7, 0xbfde04b0afe0ccae,
    0x3fd1ede788107380, 0xbfd3f382ed780f13,
    0xbf6f42a58bbb3d00, 0xbfc08156c872c182,
    0x3fc0695a89c4f315, 0x3fd37fe68b65f56a,
    0x3fe08f507c46724a, 0x3fab9abcc87b4a24,
    0x3fb110814ae271b4, 0x3fec67cae617a58c,
    0xbfd62b3b743b5e94, 0xbfcbe54c32679b6e,
    0x3fde161aefa5169e, 0xbfdf451526d338e9,
    0xbfb3cf4d4cb99310, 0x3f919e26d641f4b8,
    0x3ff1763d9c450533, 0xbfab08ff5c617414,
    0xbfc348ed3271383c, 0x3fe028c16020a25e,
    0xbfe3fc6afa6cf420, 0x3fe7a99205053627,
    0xbfc614b721bb1749, 0x3fe8fcf365d55144,
    0xbfe1e5b07911282e, 0xbfdc2d49029954d6,
    0xbfb152024c29a5c2, 0x3fcb686382669780,
    0x3fe0f60dab2c7064, 0xbfac68e9734b1e38,
    0x3fe2166585ef006f, 0x3ff00a2bb4d91df0,
    0x3fe92711813ea3ea, 0xbfde706cd13ee7fa,
    0x3fd3e8d535a3ff92, 0xbfe1e84eb0a38b3e,
    0x3fba2dba70139658, 0x3fd9aceba4853012,
    0x3fe46495550b3273, 0xbff3b1432e8a1d9f,
    0x3ff7df9746b25918, 0x0,
    0x3fe46495550b3272, 0x3ff3b1432e8a1d9e,
    0x3fba2dba70139654, 0xbfd9aceba4853012,
    0x3fd3e8d535a3ff94, 0x3fe1e84eb0a38b3f,
    0x3fe92711813ea3eb, 0x3fde706cd13ee7fb,
    0x3fe2166585ef006f, 0xbff00a2bb4d91df0,
    0x3fe0f60dab2c7064, 0x3fac68e9734b1e44,
    0xbfb152024c29a5cc, 0xbfcb686382669779,
    0xbfe1e5b07911282e, 0x3fdc2d49029954d6,
    0xbfc614b721bb1751, 0xbfe8fcf365d55145,
    0xbfe3fc6afa6cf41f, 0xbfe7a99205053626,
    0xbfc348ed32713840, 0xbfe028c16020a260,
    0x3ff1763d9c450533, 0x3fab08ff5c617410,
    0xbfb3cf4d4cb9930c, 0xbf919e26d641f4e0,
    0x3fde161aefa516a0, 0x3fdf451526d338eb,
    0xbfd62b3b743b5e92, 0x3fcbe54c32679b6b,
    0x3fb110814ae271b4, 0xbfec67cae617a58c,
    0x3fe08f507c46724a, 0xbfab9abcc87b4a38,
    0x3fc0695a89c4f315, 0xbfd37fe68b65f569,
    0xbf6f42a58bbb3c80, 0x3fc08156c872c181,
    0x3fd1ede788107382, 0x3fd3f382ed780f13,
    0xbfb55f52a8daa9f6, 0x3fde04b0afe0ccb0,
    0x3fca47c7c5c6eca1, 0x3fd7ac861d0f1341,
    0xbfe0dc682225ca0f, 0xbfe4d8dcb6ed14c5,
    0xbfe130527c4c38c8, 0x3fc978c1cac10c34,
    0xbfef1dbc8fa4c66c, 0x3fde413cdb57c976,
    0x3fc08b93d3415dba, 0xbfc863a2a1a31c37,
    0x3fbc5de6efc63be0, 0x3fd2677d3ad7095d,
    0xbfc3a0e88b80152c, 0xbfe3d633f6d7ab9a,
    0x3fec7c77a281d11d, 0x3fe8cc0c6d325a20,
    0x3feba6f87e90e2b4, 0x3f9e9118fd0fae80,
    0x3fcc1693a35e6468, 0x3fed6a81e6f82152,
    0x3fb88e49b3450994, 0xbfdf2d3e0623cb80,
    0x3fc9d52ca8f62f98, 0xbfcadda01389fdbc,
    0xbfe9c74df5f20789, 0xbff514be77b914bf,
    0x3fc88362a46431e4, 0xbfea585116b5a7ac,
    0x3ff2a4a85b7a25d0, 0xbfe88f4f1c36e747,
    0x3fccdd9a8fb4108d, 0x3fe01b2531da4ffb,
    0xbfa9cf6474c05d88, 0xbfdd5b97266036fc,
    0x3fbc8e23d7d5f850, 0x3fea346814cfbb7c,
    0xbff5d9697d0b1aa8, 0xbfeebaa0b6cd703a,
    0x3fe745be2ad03e0a, 0x3fe94e9210d31b81,
    0xbfe794538540e1d9, 0x3fd3a6aa3fb3f6cd,
    0x3fe4b63291a1eb9a, 0x3fd3fbb6fc4890cb,
    0xbfdab845930686e2, 0x3fea72a7ff1a13b8,
    0x3fd6ef9ca9d5e0e0, 0x3fafc15e4358268a,
    0x3fd21c7ce7cf11d8, 0xbfd5cfbf5ba91a4f,
    0xbfe3317e20642726, 0x3faf78cf89387b80,
    0x3fe2d022fc943ac9, 0x3fec795eee3604cd,
    0x3f879a4e92be04e8, 0xbfdcc1eff06b0071,
    0xbfc5573745e46965, 0x3fe30025f056afcd,
    0xbfc020ec4adca53c, 0xbfcaeac179acdacc,
    0xbfd4765e1686f8ef, 0xbfe657b5267fb1d9,
    0x3fe2657aef845b67, 0xbfd0009335a5fe54,
    0xbfb4ef7f988bdac9, 0x3fc05a53b4ff3f20,
    0x3f9b668f6ba7c890, 0x3fa78349daa9a2d8,
    0x3f800a4d7e3f4840, 0xbfa8332e11bec528,
    0xbfb834bc22da0514, 0x3fde0a75335f8cda,
    0x3fea6b85da86e4ba, 0x3fe70bb68df8c196,
    0xbfc3f730bae70115, 0x3fd9ed12106303dd,
    0x3faeeb610c5daad2, 0xbfe6476cb2440fb6,
    0x3fdacb495f996d75, 0x3fb56fdbb4302048,
    0x3fbc180127ce1824, 0x3fe3028065b9ab1f,
    0xbfbcb63a28c869a0, 0x3fd0ecd1fb2c0a12,
    0x3fd27c23911c3ce1, 0x3fc3c98bfa016e80,
    0x3fc496ef1d5bae8c, 0x3feea453db31eab6,
    0x3fdf684d5a5904c1, 0x3fe3a3f893e845cc,
    0x3fe48f965bd2af79, 0x3fe244e63ee829fc,
    0x3fb1f98fd18bee7d, 0xbfe0bd9fc5289d6d,
    0xbfd6b2d650ff0531, 0xbfbe9defc862d7ec,
    0xbfdf6f4a3ce35b4e, 0x3fd651b2c49f99f0,
    0x3ff11bb2da5979ef, 0xbfeb6678aaf553c0,
    0xbfefad2936e5c103, 0x3fed59673cf0b4e4,
    0xbfe110bd122d8972, 0xbfe75d3103a40c92,
    0xbfc0828a1d0cebb6, 0x3fe6e3f138f5ebc0,
    0x3fe6d5acb0bb52fe, 0xbfe7a61ae0f3e6ae,
    0x3fb60578576a37c6, 0x3fe07bbf32a26ef0,
    0xbfe3249069f90586, 0x3fd036be3ba6ece7,
    0xbfc8ae8f3e64c397, 0x3fe7c1a7093db36a,
    0x3f8beca26ff0bd10, 0xbfbf9181bff80e44,
    0x3ff6dca291b63284, 0xbfc10700595e256c,
    0x3fbdbffd0027e840, 0x3feb9d31bd6d5ab4,
    0x3fda928f58fdbc86, 0x3fd30ac77d9fcab5,
    0x3fee55088883bb37, 0xbfb3c455b80b9269,
    0xbfcbea2c659d77fc, 0x3fdb5ed19cee41fe,
    0x3f979c45debf8db0, 0xbfed78dd6f27fce4,
    0x3fe41eeb488a13bc, 0xbfeac89cb1761c60,
    0x3fc1c2e1d573ed9c, 0xbfe8161d8e1e005a,
    0xbfd2cd796c1f2818, 0x3fe8d81c411a8dee,
    0x3ff3fa2a98ea0dcc, 0x3ff3bcdac8466800,
    0x3fdff65c4ba7925e, 0xbfc2855ae2b882a7,
    0xbfd51c178e9bd000, 0xbff2faa200e1fb0e,
    0xbfc2d56f120bf0b0, 0x3fe2a0f8cd4bccc9,
    0xbff0d9c6a896c096, 0xbfdf04ef765b7953,
    0xbfea471684cd3c27, 0xbfb672e010a4d070,
    0x3f467765d4f93200, 0x3fe88538e32c581c,
    0xbfb1d2d99334006c, 0x40564cbb42c99726,
    0xbfe4e4a3b97346c0, 0xbfcf12ba0b47d5b8,
    0x3fd41efaff950f62, 0xbff52bae00cff300,
    0xbff52a175c683427, 0x3fc619886ab09eaa,
    0x3fd9ed2560eaf6ee, 0x3fed4d6b8cc15a61,
    0x3fe6b9ddbea342f6, 0xbfc3ce79029f3f63,
    0xbfb7cc64d1d2016c, 0x3fc7cc4062112514,
    0xbfddac143ed3d1bb, 0xbfc45b28adb18684,
    0x3fdd1a9f6f50aea3, 0xbfc0f6ae1cfb65a0,
    0x3fe27ab9785b4ba6, 0xbfe402235a1cff4b,
    0xbfe463b2c34fb3e8, 0xbfbbea52fedbda54,
    0xbfc2693af774af38, 0xbfd6e10a99299280,
    0xbfe3d45daf871436, 0x3fa104787204fae8,
    0xbfe34c53fbfa8631, 0xbfc226a573f0d7f2,
    0x3fbec24f1b234d9e, 0x3fe257b511472f4d,
    0xbfd0ee2ee77444f7, 0xbfb26746ea95e222,
    0xbfe50153c0cc0fac, 0x3fc0d4bb05015d70,
    0x3fe315bfdf396d61, 0x3fcd7b59af71bcfe,
    0xbfe5c9cf9c96fc05, 0x3fe41c7aa999e06c,
    0x3fdd837e728f5634, 0xbfd90713a2abf06c,
    0xbfc1284d8f62a01e, 0x3fd676a652698626,
    0x3fc36e4b40fddad0, 0xbfe91b2a14ffde9c,
    0xbfed597ab9597910, 0x3fd1dd0b4c682b82,
    0xbfc0c4044c41e167, 0x3fdba7f939e18224,
    0xbfacafaf7fa93958, 0xbfe8560e08196b1b,
    0x3fd43efa607b7b2a, 0xbfe4c2de61a4ab3f,
    0xbfe4d030cc0135fc, 0xbfce1e30f0251406,
    0x3fc88b431267d778, 0x3fe5b31c1ef16cd5,
    0xbfc35dd14a4cdc80, 0xbfd3996754c169d2,
    0x3fd17ac2e231edb6, 0x3fa6843af1c1fd48,
    0xbfa6979d8d8580e0, 0xbff14d241b256560,
    0x3fcb6f4e54f81203, 0xbfbe20f4129d80d0
    };

static const uint64_t in_cfft_noisy_512[1024] = {
    0xbfa60f365b2d2f9e, 0x0,
    0x3fdf13586d181fb3, 0x0,
    0x3fe6f66f898770b4, 0x0,
    0x3fddec8adbb0daac, 0x0,
    0xbfa2c86a88fa8a2e, 0x0,
    0xbfe32db977e72205, 0x0,
    0xbfe6e5dfadb09146, 0x0,
    0xbfe0c6d55b85b8df, 0x0,
    0x3f878ec449f1f4f7, 0x0,
    0x3fdf3601653a1e8f, 0x0,
    0x3fe67140cf066f1d, 0x0,
    0x3fe0441f9c86f5bd, 0x0,
    0x3f747a4973f28fc0, 0x0,
    0xbfde2a4116c5a0fa, 0x0,
    0xbfe4033f66785321, 0x0,
    0xbfe2c2ae21660484, 0x0,
    0x3fb30044db682deb, 0x0,
    0x3fda4b762c6378e9, 0x0,
    0x3fe723adef15e077, 0x0,
    0x3fe23b7ab4f35fa9, 0x0,
    0xbf9c33926e4b1448, 0x0,
    0xbfda7544b5b69a32, 0x0,
    0xbfe458f02c60d306, 0x0,
    0xbfe282610eab9f00, 0x0,
    0xbf846359545b72d7, 0x0,
    0x3fe0d1099738b6e1, 0x0,
    0x3fe4f5eb1aaf201a, 0x0,
    0x3fe2e4684d4ffd53, 0x0,
    0x3fa20a5d44387869, 0x0,
    0xbfdee716d0fe743e, 0x0,
    0xbfe651b20041944c, 0x0,
    0xbfe0ebefa171a6b9, 0x0,
    0x3f79d15528836c50, 0x0,
    0x3fdb5d439ce672d4, 0x0,
    0x3fe4e615fbe096a9, 0x0,
    0x3fe21a17ec76a81f, 0x0,
    0xbfa581c9d818ffc4, 0x0,
    0xbfdf564c35378e25, 0x0,
    0xbfe3040ff1f03979, 0x0,
    0xbfe2c2fb5b008b38, 0x0,
    0xbfa8d87001453a7c, 0x0,
    0x3fdee3ee327a3a5b, 0x0,
    0x3fe463e0c499a228, 0x0,
    0x3fe25003f1d46bad, 0x0,
    0x3fade90042df4ea8, 0x0,
    0xbfe06df9cc67eaf9, 0x0,
    0xbfe9c423c8a40d0a, 0x0,
    0xbfde497f4f9f3acb, 0x0,
    0x3fa83e23d257f715, 0x0,
    0x3fe1e5aaa417e897, 0x0,
    0x3fe737acbaf73889, 0x0,
    0x3fd884dc8115801a, 0x0,
    0x3f7248ff30e11555, 0x0,
    0xbfe0dc5559cdd596, 0x0,
    0xbfe41707d62b5636, 0x0,
    0xbfdc77f297b640e0, 0x0,
    0xbfa7cf4b7f4786b6, 0x0,
    0x3fe150e06fd15077, 0x0,
    0x3fe53a00ad452276, 0x0,
    0x3fdbed3f67b66b27, 0x0,
    0x3fb22b95da7aeba1, 0x0,
    0xbfde15a896f68d35, 0x0,
    0xbfe72ef6f4a8625b, 0x0,
    0xbfde27c052ed6745, 0x0,
    0xbf9b079c89d7ba90, 0x0,
    0x3fe0e142d47d21c5, 0x0,
    0x3fe58cd44621aa6c, 0x0,
    0x3fd83e904a954df6, 0x0,
    0xbfaf51b7b0bded8c, 0x0,
    0xbfe1300b86130a5d, 0x0,
    0xbfe8147b702974c1, 0x0,
    0xbfdcd261c4da1340, 0x0,
    0x3f92a7f3f6783e2c, 0x0,
    0x3fe11dd588bb7cc2, 0x0,
    0x3fe61dd07e1473b0, 0x0,
    0x3fdeec3f0b9c114a, 0x0,
    0x3fab56f8c1c3a360, 0x0,
    0xbfdb83ac2450bc95, 0x0,
    0xbfe4c151fc75d348, 0x0,
    0xbfe0969f042bb450, 0x0,
    0xbf8f80a748a06b94, 0x0,
    0x3fe0bd425da22253, 0x0,
    0x3fe685e5e4c5152f, 0x0,
    0x3fe44eb3da5387ac, 0x0,
    0x3fbb1817011666a9, 0x0,
    0xbfdd7e886d24c06d, 0x0,
    0xbfe5a90d089d8516, 0x0,
    0xbfe2e3831f97cfbc, 0x0,
    0xbf931d4d90d3901c, 0x0,
    0x3fe136af468ee0b7, 0x0,
    0x3fe5a76d71fa9af4, 0x0,
    0x3fe0b96c9d0878df, 0x0,
    0xbfac6d73c0b6caa9, 0x0,
    0xbfdc72e6238f997f, 0x0,
    0xbfe61dc28e55624f, 0x0,
    0xbfe2f1812f099f91, 0x0,
    0x3fb9b8bc34d89edc, 0x0,
    0x3fdddcaf47af3632, 0x0,
    0x3fe635e737ccf4da, 0x0,
    0x3fdd85f666689110, 0x0,
    0x3f95625f1419fef6, 0x0,
    0xbfd7b4860ec74495, 0x0,
    0xbfe7e8fd7d442070, 0x0,
    0xbfe0087e0a6bb419, 0x0,
    0xbf9dab6cb43027e6, 0x0,
    0x3fe016e4c10ea576, 0x0,
    0x3fe708403fbedb06, 0x0,
    0x3fdba420b76cbed2, 0x0,
    0xbf6e78504f5224f9, 0x0,
    0xbfdfbdc780ef708b, 0x0,
    0xbfe4e0684ad7ffa3, 0x0,
    0xbfe08f717c71b0b1, 0x0,
    0x3f85b7e5cf2a911b, 0x0,
    0x3fe07a3d7a0697c1, 0x0,
    0x3fe6a148e7e67c41, 0x0,
    0x3fdaea4c971b1cb2, 0x0,
    0xbfa477f86c11980c, 0x0,
    0xbfe05b84b4f340eb, 0x0,
    0xbfe3b4479cdf894c, 0x0,
    0xbfde487e4dd96a18, 0x0,
    0x3fa8976acf807dde, 0x0,
    0x3fdf9628cc210cba, 0x0,
    0x3fe70e681b4e100e, 0x0,
    0x3fdbbd17d44a437d, 0x0,
    0x3fa553a74c7b0144, 0x0,
    0xbfde6b76bacdc811, 0x0,
    0xbfe6a42a44c34b43, 0x0,
    0xbfe425f3bcc697ff, 0x0,
    0xbfa76cdcfd8ed63c, 0x0,
    0x3fde8ad8fe77c4cf, 0x0,
    0x3fe58914075eedfe, 0x0,
    0x3fdfb4fea6940b0c, 0x0,
    0x3fa8f4a29a32ac71, 0x0,
    0xbfdd9400add51c8a, 0x0,
    0xbfe4bf78c3df3cb1, 0x0,
    0xbfe1b8768d5603b6, 0x0,
    0x3f9bce49d96c97e1, 0x0,
    0x3fe105090ffa5a8c, 0x0,
    0x3fe67a3b57a053f5, 0x0,
    0x3fde0c86ea6ace30, 0x0,
    0x3fa032e09b7dbc50, 0x0,
    0xbfe063333243f6ff, 0x0,
    0xbfe4692846cc4d84, 0x0,
    0xbfddf00bd0063fea, 0x0,
    0xbfc191b9ccb91725, 0x0,
    0x3fdf31b13a689ea4, 0x0,
    0x3fe42baa8061e219, 0x0,
    0x3fe1d25608bc01b1, 0x0,
    0x3f9644525c97355b, 0x0,
    0xbfda63e22b598354, 0x0,
    0xbfe6838a3dcc7527, 0x0,
    0xbfdbd55fb72bc345, 0x0,
    0xbf9471b1858070da, 0x0,
    0x3fdc2f21afbc8948, 0x0,
    0x3fe6fd77713ed9d6, 0x0,
    0x3fdfb53d63778bb8, 0x0,
    0xbfa415781aa23883, 0x0,
    0xbfe07be7729c1598, 0x0,
    0xbfe443c43c531301, 0x0,
    0xbfe10a34c3e81745, 0x0,
    0xbfaba942f44d69eb, 0x0,
    0x3fe0e18389e392e6, 0x0,
    0x3fe615466c5e707e, 0x0,
    0x3fd90a15020a5a39, 0x0,
    0x3fbc21ee977d23bf, 0x0,
    0xbfe04d46b450f948, 0x0,
    0xbfe2bd971e4ed77f, 0x0,
    0xbfdcfde62ba7bb68, 0x0,
    0x3fa68cef0dcf3453, 0x0,
    0x3fe05366ad8f7be4, 0x0,
    0x3fe86c3ae7b50723, 0x0,
    0x3fdf0472d81dc42a, 0x0,
    0xbfa0dd780d95566b, 0x0,
    0xbfe0b1ed95402607, 0x0,
    0xbfe6996410c0a79e, 0x0,
    0xbfe106a3d0ab09bc, 0x0,
    0xbfb90a57998589c9, 0x0,
    0x3fdc1df4460dccd3, 0x0,
    0x3fe5340cbcf74c7d, 0x0,
    0x3fe2e50cf8d5c606, 0x0,
    0x3fbd24d035c348af, 0x0,
    0xbfdb7fa14dcacac0, 0x0,
    0xbfe88c054f1605b2, 0x0,
    0xbfdce0a95d96877b, 0x0,
    0xbf903b2d0a32baaa, 0x0,
    0x3fe0bff7e3acf735, 0x0,
    0x3fe6b98cfb5f7cba, 0x0,
    0x3fddf96588a9e469, 0x0,
    0xbf9f48d1362eb924, 0x0,
    0xbfdd43d11a86faa4, 0x0,
    0xbfe636cf258501d5, 0x0,
    0xbfe153b7607bf32c, 0x0,
    0x3fa118601ae3b9ee, 0x0,
    0x3fdf37701f938e7c, 0x0,
    0x3fe634a7c3c1c76a, 0x0,
    0x3fe17eba7604840d, 0x0,
    0x3fbf81fe3f231cff, 0x0,
    0xbfe085c9d4eef0bc, 0x0,
    0xbfe67ef8cea3a3d6, 0x0,
    0xbfdce2d0e6a2f704, 0x0,
    0xbf7315a95898d03e, 0x0,
    0x3fe280f8cceaf05e, 0x0,
    0x3fe8dbaca85d84ee, 0x0,
    0x3fe22241f48c7f83, 0x0,
    0xbf916088d2d5d96f, 0x0,
    0xbfdb79d1f7c783f4, 0x0,
    0xbfe5d7851288fba8, 0x0,
    0xbfe0efba81928350, 0x0,
    0x3fa7bdad6d9a1d3f, 0x0,
    0x3fdd5778c8e9715a, 0x0,
    0x3fe56b3d0ad57331, 0x0,
    0x3fdbf5544f2573b1, 0x0,
    0xbf77885ce287b70c, 0x0,
    0xbfdd510d06c5e523, 0x0,
    0xbfe6534ff2a34112, 0x0,
    0xbfe1911c64d8ceef, 0x0,
    0xbfa54180fa03e01d, 0x0,
    0x3fdf0ac045c4d001, 0x0,
    0x3fe5a2a0166a2542, 0x0,
    0x3fe3929176cbe590, 0x0,
    0xbfb99aa914f7799b, 0x0,
    0xbfe0319cc565cba0, 0x0,
    0xbfe49915fcbf6c2c, 0x0,
    0xbfd6d18d785d83ac, 0x0,
    0xbf852ea6ba1e0654, 0x0,
    0x3fdddb7a10964ae9, 0x0,
    0x3fe4117ca4366b50, 0x0,
    0x3fe043647ed6082f, 0x0,
    0x3faa90869cdb7105, 0x0,
    0xbfdd5baea456495a, 0x0,
    0xbfe4f8e240dfdc02, 0x0,
    0xbfe070de51d1ba5c, 0x0,
    0x3fa7851bbe84659f, 0x0,
    0x3fdc6a2f7a3d3394, 0x0,
    0x3fe70835f7a73fb1, 0x0,
    0x3fe2b00023ca7694, 0x0,
    0x3f9c57c656b7388e, 0x0,
    0xbfe2c3ac4192a26d, 0x0,
    0xbfe6ad084c93cfe1, 0x0,
    0xbfdc2bf64ebec326, 0x0,
    0x3f94965906188f25, 0x0,
    0x3fe005c7726a0f9d, 0x0,
    0x3fe65b5970084ca4, 0x0,
    0x3fe13b3b38e7dddb, 0x0,
    0xbf9a593b59d369c7, 0x0,
    0xbfe2e5956b68d7fd, 0x0,
    0xbfe80395b4b692a3, 0x0,
    0xbfe1a0f2bdd111e2, 0x0,
    0x3f974f03fa950ae8, 0x0,
    0x3fe00bc9f1ca87f6, 0x0,
    0x3fe43bc846b46566, 0x0,
    0x3fe15fc2bc9f3edf, 0x0,
    0x3fa3e6d8e99d59cb, 0x0,
    0xbfe1da0d065ec632, 0x0,
    0xbfe7c6f753fbd041, 0x0,
    0xbfe2be92a0cf5194, 0x0,
    0x3f8bdcc4ca60f729, 0x0,
    0x3fe1aca545cfd974, 0x0,
    0x3fe5a60b5cbeeabf, 0x0,
    0x3fdfbbf7abc49ce0, 0x0,
    0x3f94740b6bd535e1, 0x0,
    0xbfdf01415576505d, 0x0,
    0xbfe99a8ef10ec3c8, 0x0,
    0xbfe126757ab73a4b, 0x0,
    0xbf94498d604d4c22, 0x0,
    0x3fe038aff1aa0641, 0x0,
    0x3fe724aeb1c35872, 0x0,
    0x3fdf682054886d18, 0x0,
    0xbfab0a5450322a18, 0x0,
    0xbfe18e0e9edb48d1, 0x0,
    0xbfe7086a9480fdbd, 0x0,
    0xbfdabf3dd2d106a6, 0x0,
    0x3f948ca51284bff1, 0x0,
    0x3fe0502b4f714162, 0x0,
    0x3fe524b1917da43b, 0x0,
    0x3fda7e69e3f54367, 0x0,
    0x3fafb4da4d366bfa, 0x0,
    0xbfe1b39983f59d6e, 0x0,
    0xbfe5ee8ad7af1882, 0x0,
    0xbfe263be18b76912, 0x0,
    0x3f86164f4fab6fb8, 0x0,
    0x3fdcfe2ac425f5e9, 0x0,
    0x3fe73ff9d9c95cf6, 0x0,
    0x3fe059d4b91b0155, 0x0,
    0x3f87042004b71f5c, 0x0,
    0xbfdee63be8e66e7d, 0x0,
    0xbfe71f165e8ba837, 0x0,
    0xbfe05a14f41e3236, 0x0,
    0x3f9499c6e066e5f9, 0x0,
    0x3fe023666bfb4e7c, 0x0,
    0x3fe2ef31b8f00e50, 0x0,
    0x3fdda51cb3c7f152, 0x0,
    0x3f4ed41662153fae, 0x0,
    0xbfe1b3a4d0bfe9c0, 0x0,
    0xbfe5adb70994a265, 0x0,
    0xbfdc43e70a4a9534, 0x0,
    0x3fb1a79c6d803289, 0x0,
    0x3fde2b607e7b5a17, 0x0,
    0x3fe914e6ce8d4d86, 0x0,
    0x3fde591d56995a12, 0x0,
    0x3f8ab443efbedac3, 0x0,
    0xbfe004a260f3c9f8, 0x0,
    0xbfe89d8d2467ad3f, 0x0,
    0xbfe0549f9cb2989c, 0x0,
    0x3faaa11b5fc13385, 0x0,
    0x3fde74dcef4d9041, 0x0,
    0x3fe7e6ce5dac7269, 0x0,
    0x3fe042722bc122e3, 0x0,
    0x3fb1de38c510e288, 0x0,
    0xbfdf367823a7162e, 0x0,
    0xbfea56967adfc56b, 0x0,
    0xbfe1faeb23250806, 0x0,
    0x3fb1997c026e8fc5, 0x0,
    0x3fe0bb4154bfdfa2, 0x0,
    0x3fe6c67e4ab10ea1, 0x0,
    0x3fdc32b342657474, 0x0,
    0x3f8f15658715ef23, 0x0,
    0xbfddcf0a8b533862, 0x0,
    0xbfe7266152d11507, 0x0,
    0xbfdd2886d7aecfbe, 0x0,
    0x3f9f4434e637acb7, 0x0,
    0x3fe00d98044db389, 0x0,
    0x3fe42859dd50034f, 0x0,
    0x3fdd41245f9e07a2, 0x0,
    0xbf8a74f777c57c24, 0x0,
    0xbfe1ad54f850b5cd, 0x0,
    0xbfe93a4f023bc2c4, 0x0,
    0xbfe095d78ad2d0b3, 0x0,
    0x3f8c3ce5d89cb1d4, 0x0,
    0x3fe179861de71a53, 0x0,
    0x3fe4df106e4bd712, 0x0,
    0x3fe099e72ce604c0, 0x0,
    0xbfa581f7ccf278d4, 0x0,
    0xbfdfa20524009287, 0x0,
    0xbfe6d7f0cd10be0b, 0x0,
    0xbfe095810fd528eb, 0x0,
    0xbfa1d1a2437a5a6d, 0x0,
    0x3fe1fcbeaa38d404, 0x0,
    0x3fe4f44a569c99f4, 0x0,
    0x3fdb40761b0ebb8b, 0x0,
    0xbfa3a0b0da10a920, 0x0,
    0xbfe1091b35061569, 0x0,
    0xbfe668829830ac0d, 0x0,
    0xbfdbb44ac8202fb8, 0x0,
    0xbf61b1d70cc34448, 0x0,
    0x3fe0fc2325431970, 0x0,
    0x3fe54197fdd16cb4, 0x0,
    0x3fe387de2920750e, 0x0,
    0xbfba745f761d595e, 0x0,
    0xbfd8ea41aa2be6d0, 0x0,
    0xbfe5465aecddcd4c, 0x0,
    0xbfddbc957681bf52, 0x0,
    0x3fc19b04b9038d5c, 0x0,
    0x3fdecdbd3ebee13b, 0x0,
    0x3fe4e19afb98a5bb, 0x0,
    0x3fdd7d0866ec5ff3, 0x0,
    0x3f8a88a014f4d36e, 0x0,
    0xbfe09a42bd0e30a8, 0x0,
    0xbfe7a1fa4b324a8f, 0x0,
    0xbfdd94603a7c10b6, 0x0,
    0xbf8b83b22544722e, 0x0,
    0x3fdfff1fb4390f24, 0x0,
    0x3fe5d4577f8e4707, 0x0,
    0x3fdda827c4eda068, 0x0,
    0x3f71cffd999d1dc3, 0x0,
    0xbfdda75a6ee2bf44, 0x0,
    0xbfe44e5932edd5ec, 0x0,
    0xbfde60ece0f0e6ed, 0x0,
    0xbfc16d2a58929234, 0x0,
    0x3fe092f4c397424e, 0x0,
    0x3fe7ca99e55df217, 0x0,
    0x3fdbbab1d36f3ef8, 0x0,
    0x3fbb8a4102792cb4, 0x0,
    0xbfdbde01b86fac53, 0x0,
    0xbfe8fea6fb802dc0, 0x0,
    0xbfdf3341d3cec423, 0x0,
    0x3fc49cc9062c985c, 0x0,
    0x3fdf44e2183d9b7a, 0x0,
    0x3fe6cebd1fa62cad, 0x0,
    0x3fdc089b3cd15876, 0x0,
    0x3f899977e3df72c2, 0x0,
    0xbfe0869395f1aaac, 0x0,
    0xbfe52b7262fa54fe, 0x0,
    0xbfdb890166b25c70, 0x0,
    0x3fbf220ea170caa7, 0x0,
    0x3fe0922700622042, 0x0,
    0x3fe5f2ddcc521bc4, 0x0,
    0x3fe21c2a70d80993, 0x0,
    0xbf9901831458703c, 0x0,
    0xbfdfb1dfa88abc8c, 0x0,
    0xbfe605e143a99ec4, 0x0,
    0xbfe00df697cfe963, 0x0,
    0xbf5cd5e0f92e56a9, 0x0,
    0x3fdfaa496523f9e9, 0x0,
    0x3fe36ce207583266, 0x0,
    0x3fe10d20a78def31, 0x0,
    0xbfc18ba9d9da91f0, 0x0,
    0xbfe0a18bd013c527, 0x0,
    0xbfe93842c8c27871, 0x0,
    0xbfdddec7ca471eab, 0x0,
    0xbfa175a8198c3b0b, 0x0,
    0x3fdbc16cd49dc15d, 0x0,
    0x3fe3c309e423115a, 0x0,
    0x3fded65d4f4276eb, 0x0,
    0x3fa53692bb7baa8b, 0x0,
    0xbfe141748371df63, 0x0,
    0xbfe57c54015fff06, 0x0,
    0xbfdf606b1636a2b7, 0x0,
    0xbfb2190f25664180, 0x0,
    0x3fded6d053d788ef, 0x0,
    0x3fe80169bf375c29, 0x0,
    0x3fdd35d1ff8f7812, 0x0,
    0xbfb8303019aaaf2d, 0x0,
    0xbfde4637b36fdb9f, 0x0,
    0xbfe654a821a828ea, 0x0,
    0xbfdc6ed847aeed9a, 0x0,
    0xbf95e18e83d0aa37, 0x0,
    0x3fe12ab5d15db98c, 0x0,
    0x3fe8ce9d7aee46ba, 0x0,
    0x3fdf31ffc4361f4c, 0x0,
    0xbfa5a4f9c412813c, 0x0,
    0xbfe265ac62c28692, 0x0,
    0xbfe5c8f61619c906, 0x0,
    0xbfe0fe7a1ef1c56b, 0x0,
    0xbfb3a309921742e5, 0x0,
    0x3fe0b43815701b68, 0x0,
    0x3fe75b31eda3a239, 0x0,
    0x3fdf346710b46425, 0x0,
    0x3fa30412e79cb9eb, 0x0,
    0xbfdab56a35a1ff46, 0x0,
    0xbfe608eb55ac5eb9, 0x0,
    0xbfe05bcb8c959462, 0x0,
    0x3f8cb414181ec000, 0x0,
    0x3fdb6f4690141ade, 0x0,
    0x3fe5204250842325, 0x0,
    0x3fdc801ba2a2e290, 0x0,
    0x3fb6786f1b8097a1, 0x0,
    0xbfe1533e0cdb527e, 0x0,
    0xbfe4b0f87b8d0c92, 0x0,
    0xbfdd4faba643e7d5, 0x0,
    0x3f7094652c281c1c, 0x0,
    0x3fdec0d5624284a3, 0x0,
    0x3fe79787d14a9a2e, 0x0,
    0x3fdb908ddb293646, 0x0,
    0x3faabcbecc3ebea7, 0x0,
    0xbfde374e07bb260e, 0x0,
    0xbfe657b6a260af27, 0x0,
    0xbfe01ffb5ff7ac10, 0x0,
    0xbf9b08e9f72dde06, 0x0,
    0x3fdf2d203949707e, 0x0,
    0x3fe685f7f99eeff6, 0x0,
    0x3fdf4d01e5e74b07, 0x0,
    0x3fbbeff37ab3adf3, 0x0,
    0xbfe1cac1267f2f70, 0x0,
    0xbfe867828a5917fd, 0x0,
    0xbfda9145480f9a33, 0x0,
    0x3f904a9a792a75cc, 0x0,
    0x3fda32a77ec0a366, 0x0,
    0x3fe8b33ed399a154, 0x0,
    0x3fdf80858482590c, 0x0,
    0xbf87107ddc173ff2, 0x0,
    0xbfdfbd00ccaaf15a, 0x0,
    0xbfe7262967bc4aac, 0x0,
    0xbfe12d9b8b1df3df, 0x0,
    0xbfa5469a577d4f7c, 0x0,
    0x3fe2190aa16a3ae3, 0x0,
    0x3fe98f8251799328, 0x0,
    0x3fe00057fcf2c4b2, 0x0,
    0xbfb1caa2a43eb784, 0x0,
    0xbfe06651866a95a6, 0x0,
    0xbfe648fdb02b1c0c, 0x0,
    0xbfdfc31fc1afbf91, 0x0,
    0xbfb9a733a6d46a13, 0x0,
    0x3fe0e5002473b7a6, 0x0,
    0x3fe3f264f9510c96, 0x0,
    0x3fdd1abecddb8e10, 0x0,
    0x3f9df83d9913a8fb, 0x0,
    0xbfdeb10996f82e19, 0x0,
    0xbfe3683c859e813c, 0x0,
    0xbfe13c78232b3cad, 0x0,
    0xbfa67f87f89b9e57, 0x0,
    0x3fdb614eece03cf8, 0x0,
    0x3fe7f6081435cfd2, 0x0,
    0x3fe0be82fa828ec1, 0x0,
    0xbfb5a8df01f7d09f, 0x0,
    0xbfe22d3351539026, 0x0,
    0xbfe4ff88541055a4, 0x0,
    0xbfdcc12c4e541b73, 0x0,
    0x3fa9b0ed670976ef, 0x0,
    0x3fe321da9bebd12c, 0x0,
    0x3fe77862054597e7, 0x0,
    0x3fdd9fe4ac2385cb, 0x0,
    0xbfaf7344e9ce27c1, 0x0,
    0xbfdf021ea2a78dc5, 0x0,
    0xbfe5fdf8299b0fe3, 0x0,
    0xbfdea816a0467f2d, 0x0,
    0xbfa2914f604548b1, 0x0,
    0x3fdf1deec03f77c1, 0x0,
    0x3fe7ccc679b123ab, 0x0,
    0x3fe1cbb4b6413310, 0x0,
    0x3f87b7a152811257, 0x0,
    0xbfe005c53b146076, 0x0,
    0xbfe87e5c364d2009, 0x0,
    0xbfe02c41848f084d, 0x0,
    0xbf8f3b41fb411741, 0x0,
    0x3fdde2b57f25fb7e, 0x0,
    0x3fe731446046eb90, 0x0,
    0x3fdd702bd892291a, 0x0,
    0xbfa9f6cd9a7de05e, 0x0,
    0xbfe1ed5e0fd8ab63, 0x0,
    0xbfe6edba886d2955, 0x0,
    0xbfdc47d8134272ed, 0x0
    };

static const uint64_t in_cifft_noisy_512[1024] = {
    0xbfb8e29ab4bc2fa4, 0x0,
    0xbfc199602539f3b8, 0xbfed0f7370e4a318,
    0xbfe75925b74494fe, 0x3fd961ca943ef88e,
    0x3fe030f26390b3c8, 0xbfea179f712598e3,
    0xbfeddc2b4a40932b, 0x3fe919c475784085,
    0xbfaa42e84179d800, 0x3fd5b89c458ae4c4,
    0xbfdbd015c77a3f49, 0xbff0d6788f088b56,
    0x3ff39c753ec521f7, 0xbfe2e4010ff81afb,
    0xbfe1561f88dafa7b, 0x3fe3f869ae791f22,
    0xbff447b0fbbb8302, 0xbfaf546edcbe214e,
    0xbfec3a1529f14598, 0x3fdd0ddf1d59c2bd,
    0xbfd47491f5117130, 0xbfd2cfb8244de86a,
    0xbfb7cd244d000514, 0x3fc2123919f18895,
    0xbfb83f3c57110958, 0x3fea5d1d9d6e2562,
    0xc0015d20162817e6, 0xbff68dd41116009b,
    0xbfc45053709c6404, 0xbfdc0542cae05426,
    0xbfcbaaf2b1623f6b, 0xbfc04b5c5a9fe49c,
    0xbff733a1d52016bb, 0x3ffb12d2ed0bf302,
    0x3fd5a9301acf13c2, 0xbfa3af4c5e27bed8,
    0x3fe03d6fe0daa822, 0xbfe5888405a43564,
    0x3fe458af435e5b48, 0x3fb0a7095893a110,
    0x3fc19ffec8b34950, 0xbfdf139dc2644120,
    0xbfb9c4292582371c, 0x3fcafd0a49e1a3c8,
    0xbfe363fb5aeaf0ea, 0xbfc94d33257f7ca0,
    0xbfd56a49d448467c, 0x3fd206c7fc34a854,
    0x3fef31f3901d963e, 0x3fed039e4e5f4be4,
    0x3fdd95b30d9a81e8, 0xbf96ebee138e5e50,
    0xbfe8c9c9ce1713d8, 0x3f6bbd395fd37800,
    0x3fe3d55155486b3c, 0xbff4b24c22aff828,
    0xbfed9a0c5242f962, 0x3fd85b2b6175afea,
    0xbfd0a110f60b1e3d, 0x3ff590fb8c8388ba,
    0x3feeab5cc2559888, 0xbff41dd3b9235c6c,
    0xbfe2ed8d20f72be0, 0x3fdc0540a88f7169,
    0xbfd7ac2047dcf95c, 0x3fec5d6ff5571739,
    0x3ff7b33c65841854, 0x3fc88c5cb07c1899,
    0xbfe6b3bef1dca818, 0xbfe707441e462407,
    0xbfcc82b50d3e954b, 0x3fb0aa8ac72de558,
    0x3ff1af5911da8145, 0xbfc0188fc6d7ff6f,
    0x3fcc27570b095c0b, 0x3fc8afa99fbff856,
    0xbff385982e87f7b2, 0x3fdcdd16ff0efa4c,
    0x3fcabd8bf756a15c, 0xbfe68c7fb1e25b38,
    0xbfb374d66b90e3b8, 0x3fb6311c76755278,
    0x3ffd19b6bcdbdaf6, 0xbfe1cf53f73654bc,
    0x3ffef19eb0b8a926, 0xbfdaf23d231a0687,
    0xbfc97de42e17c349, 0xbfdfc9999416cc69,
    0x3ff215fa9dc0cbf0, 0x3ff74d1250d9bd6c,
    0xbff0d3e2dd289047, 0x3fe0c68fd1a2c769,
    0x3fd78a47a44f6ed0, 0xbfe220fdb85c6c29,
    0x3ff30557d129c58f, 0x3ff5336b64aaa52b,
    0x3fdd1bc2797198f1, 0x3fe3c9865d5f2c6e,
    0xbfe142a64381bcb3, 0x3ff62cce8adb5aa5,
    0xbfb687ecbddd6bac, 0x3f53a7c08893b800,
    0xbfecd18205210481, 0xbff24c2ef909d3d1,
    0xbff004c9c0fc6af2, 0x3fe0ff7ad9c831d8,
    0xbfc2fbe64cfe3458, 0x3fa38ff82d765040,
    0x400006869fb6a966, 0x3fdcee65076f9bac,
    0x3fdcd9b0de2fc75a, 0xbff7bae905df4c11,
    0x3fc6b9729f39f08e, 0x3fb7989e6defdce2,
    0xbfc34d9e868bde4b, 0xbff7a8492474859c,
    0xbfc8b6bdc6b94736, 0xbfef918be518846b,
    0x3fd2f9f8aa50f040, 0xbfe3ec5f14a7309a,
    0xbfd5340c7e04bad9, 0x3fc5caabbb9dabd6,
    0x3fca166b07e118be, 0xbfe1532ac7f7dc42,
    0xbfe902635185b91f, 0xbff4479fff4ac05c,
    0xbfcd2150937de3b8, 0xc066647a10be550a,
    0x3f9a68d5465f85c0, 0x3ffd445c4ff69e18,
    0x3f9dd04c605d6170, 0xc00185f0706bc100,
    0x3fdce9375692f4d9, 0x3fda00c7edc128f6,
    0x3fdb9e2cc79a4414, 0x3fe68af6c229c0ae,
    0x3fe0136521a64dc7, 0x3fc1079128bd9a0a,
    0x3fb1d864b52bfdfc, 0x3fdbc0f47a4e7dd0,
    0xbfe1de24e8ed9f54, 0x3ffb513a2f8d5698,
    0x3fe2f51e06480ba6, 0xbfe4ae75cb172736,
    0x3fefcb57daf73e5e, 0x3ff31541a5bd67d0,
    0x3ff1ffb848ec9bf8, 0xbff7edcc62819eda,
    0xbfc0b0e4e8ec23ae, 0xbff8df32b671ad1f,
    0x3fe70d3f4b771362, 0xbfe2cdac8fe9044d,
    0x3fc9f565812c1594, 0x3fe3e43880bf759e,
    0xbfe9ca7c2085c91e, 0x3fe038a397183b0d,
    0x3fa12ae79ddd4878, 0xbfe12c70d3af6254,
    0x3fd8ace33fc428c1, 0xbfbc89e2b728a940,
    0xbfc90d7b7234e3e0, 0xbfad8dea8d03202c,
    0xbfd72be59cc45f48, 0xbfd7eacb13179f74,
    0x3fef77d9b51a91ef, 0xbfe28a63ebd68d0a,
    0xbfe612e7cad26e3e, 0xbfe191f664eb3dc5,
    0x3ff8cbf43793d089, 0x3fe032987fadd268,
    0x3fee53223169d2c6, 0xbfe8829d7033ae07,
    0x40020ad06679614c, 0xc000187f26917a4d,
    0xbff81ea0a30f0188, 0x3fd1ed869e49ca1a,
    0xbfebc7ec603720e7, 0x3fd4e22d6ff4cd52,
    0xbfe0a72e424135d2, 0x3fe9e4529022d473,
    0x3fe45828db0438f4, 0x4002b518e46153aa,
    0x3fc8597f12bc5b70, 0x3ff44b75c81dc76f,
    0xbff58dc5dde8f75d, 0x3ffab564c39042d8,
    0x3ff41d953f8eacdc, 0x3fd08ee55f669e84,
    0xbfed3471618e6345, 0xbfe9c02a5661a5c8,
    0xbfd61094011465ab, 0x3ff659e37e2c2a8b,
    0xbff0e392a89565f2, 0xbffd8a4d08037dd4,
    0xbfc2d0cb72b120d0, 0xbfec3d998b0495b6,
    0xbfe20ccaa9269928, 0xbfe2a6afa6d2886c,
    0xbfa7d3fa2966dfa0, 0xbfd0d9a9ce70e4ce,
    0xbfe2633ed2f4d3c5, 0x3fdc64409ee3b31a,
    0xbfd4cab04ecb19ec, 0x3fd9eb7ba3800e94,
    0x3fd25407d8329b9d, 0x3fecdec4372100be,
    0xbfeca0e866316172, 0xbfde2cb9c3390c6b,
    0x3fe3b356945e03d6, 0x3fd6bfd1503b251d,
    0x3fd961362cf9ab92, 0xbfc56e84c2ac212c,
    0xbff67e7f18beea15, 0x3fddd3a08e30e8b5,
    0x3ff8b44af475802c, 0xbff6e4d1869a505e,
    0xbfbd1e6e36ce6708, 0xbf9313a878e7c7a0,
    0xbfe200ea5f733a58, 0x3fe4a008983ac139,
    0xbfb58fdc14d8a9fc, 0x3ff06ab4f8b9b7d5,
    0xbf9c3e81281b1550, 0xbfd019ba8bd9e40f,
    0xbfead803c61ac83f, 0x3fb1a503371dd5da,
    0xbfe157d34b966666, 0x3fb75be3562c07a0,
    0x3fe41080ecc8226f, 0x3feac0c43791dade,
    0xbfc0a0ceabd7a4d2, 0x3fc6d0857bf3f0e4,
    0x3fd13f89dfc92e7a, 0x3f879e4c7fa370d8,
    0x3fecf35f27fa19e0, 0xbff478d87e1b838b,
    0xbfdcc936e7b1b20c, 0x3fe2d46b53f6f7ec,
    0x3ffa636695699955, 0xbfee3ed18f79c25a,
    0xbfdfd5d0691eddca, 0x3ff4756e760e951f,
    0x3fe1de57b53197dd, 0x3fe0d08105339c41,
    0xbfd6e9cc3d1b1660, 0xbfcd3c75aa99fdb7,
    0xbfe7ead5ed7d723a, 0x3fe524761b8818a6,
    0xbff470c2c81d1efe, 0x3fe1fbba3906d046,
    0x3ff496787be022c9, 0x400563aeebce2ddc,
    0xbfe793590556a5b4, 0xbfe747a0d4fba492,
    0x3fdda0fb7e245fd7, 0xbfdef4fe5e5f49c0,
    0xc002da8a3f632ade, 0xbf69e180a667fb80,
    0xbfee550e32cacddb, 0xbfd3bdefb6eecb20,
    0x3fd3bf4fb70ddf41, 0xbfc76d79d7a70398,
    0xbfcac5b88fe1cdac, 0x3fd4f2d7dfec6b3e,
    0x3fb38cde770db3aa, 0xbfaeb6fdd59b6fee,
    0xbfea31cf9fd4e7ce, 0xbfe3a3e1de23e551,
    0x3fe81d826b984516, 0xbfe080e4ca4fc526,
    0x3ffa544bce815cc4, 0x3fcf7502baccdb1c,
    0xbfc640b864b108c2, 0x3ff65f4353619584,
    0xbff7843aaeda50aa, 0x3fe3f78f713f7558,
    0xbfd461372209693d, 0x3fbd7966b8797668,
    0xbfb983d387dc1e48, 0xbfe88fd92bd10c1e,
    0xbfd6c878e207393c, 0x3fdd13ec9d8e9387,
    0x3fc1009e4fb8308c, 0x3fe68b993f7c60ec,
    0x3fe319b17b9d51a9, 0xbfc3bd91260634e7,
    0x3fec9e2ec46ad5f4, 0x3fb0ac9be34b94e6,
    0xbff11955096a4ad6, 0x3fe379cf726ce0da,
    0x3fc83ff89546eb13, 0xbfb4ecdb3babab3c,
    0x3fe64ceebec11ce6, 0x3ff148dbfd188d5c,
    0xbfdca66dba3702ea, 0x3feb032611c67ec9,
    0xbfef2f70d47ccaf6, 0x3fe4bf489db1b70e,
    0xbfe03b1d306dafa4, 0xbffdbedbdc0c5794,
    0xbfce77da4472e9ee, 0xbfd5bc0202be57dc,
    0x3fd113f3643b6021, 0xbfc7eebe982e3a06,
    0xbfe001fa224a554d, 0xbffb5f8ba848895e,
    0x3ff18eb244fc0ee4, 0xbfdaad2c7146074d,
    0x3fddb1bba31a1571, 0x3fa470524037a694,
    0xbff5a2cfddafd5bb, 0x3ff6e70a9d724553,
    0xbff1511745685e06, 0xbfe3e3095ddf0eca,
    0xbfebf2c7296ca758, 0x3fea6f9075313de8,
    0x3fdfc1c93d7bb588, 0x3ff33d22e7850ef1,
    0x3fdb270b7ad6b27c, 0xbff630f2786eb327,
    0x3ff1feff646e75dd, 0x3ff8a85e1c15ed33,
    0x3fe67e26a5c09434, 0x3ff42db91c671c4d,
    0x3fc80bbdc129c610, 0xbfb799454e7e3058,
    0xbfe8eda21f5920a0, 0xbfb11331cfb732d0,
    0x3ff9e24f6e053306, 0x3fce1de6eaf08070,
    0xbfe56f03d5f11148, 0xbff76a6d2928f315,
    0xbfe280b52ba6784e, 0x3fb0efafec94c18a,
    0xbfe3e845412c61c8, 0xbfd168cbfaaa4139,
    0xbf78c7b592de9200, 0xbff98222afe6b93d,
    0x3fb20c620db4c854, 0x3fc10d09ba033f8c,
    0xbfe2ae038a49ad19, 0xbfbb3fae02dd2288,
    0x3fe9be0768219901, 0xbfb4fc0420af8ed0,
    0x3fe4a97d9c8a68be, 0xbfc92cd7c3e8bb04,
    0xbff750182d545cee, 0x3fd4d4a021b59b85,
    0xbfd2b8ad8e03edd2, 0x3fcb59898983fc66,
    0x3fdfd118d3bdbea6, 0xbfe48719ab180a2a,
    0xbfe0cb92b266552d, 0x3ff50aa60b228a76,
    0xbff37d2cbefe735e, 0xbfea218c34a05218,
    0x3fed1df1dedee9bc, 0xbff25996cf069cd0,
    0x3fe589a8e1093dbb, 0xbfcdfd73e59b3603,
    0xbfd7363244f60e7c, 0x3fcea365df4ba758,
    0xbff43a719819a1a6, 0x3fdaf2ec1b1a3ecc,
    0xbfe3e621fb28bcaa, 0x3fe154c7009f4f35,
    0xbfb6aa23788e6360, 0x3ffc14ec991e4231,
    0xbfe2515a817e28bd, 0x3ffccec251125a7f,
    0xbfe479198cbd2c89, 0x3fe4ac4c8934b2bb,
    0x4000bab9f661117a, 0x3ff05a1a11a9ec7c,
    0x3fec2b346bbbab72, 0xbff3edc6c9e4e44a,
    0x3ff2114287dece60, 0x3fe48d4b5c509d56,
    0x3fe782ba0a5d171f, 0x3fc5cb0a96713ef8,
    0x3fe7e80364052cfa, 0x3fb64ffd0ddb0848,
    0xbfd7989e6d379442, 0xbfe861ca44519e80,
    0xbff063d592874419, 0xbfc121ae72229194,
    0x3fc427338bce291a, 0xbff2cc35108290be,
    0xbfd2232534f5957c, 0xbfe9379e6aa990a2,
    0x3feaa7784101ed92, 0xbfc5eaaf5c9f560a,
    0x3fe3a857e44957c8, 0xbfc3fb53eb87b00a,
    0x3fad9c1ca37bcc5e, 0xbfebc878ae7e9eda,
    0xbfe51b9cb0a24da2, 0xbfc97553764de91d,
    0xc0010d52412937e3, 0x3fa03946e2cadd20,
    0xbfea878c85da472a, 0x3fe0598af9d6e0ff,
    0x3fa2fbdcc60e7e6a, 0x400247aab465607b,
    0xbff366fe167bb5a7, 0x3fcc21244f285200,
    0x3fe42c407ee33963, 0xbff7328b9611d503,
    0xbfef9eb841d878f8, 0xbfc0879a65cdafdc,
    0xbfe32bebf51e9c26, 0x3fd4b67c7c8cc7ae,
    0xbfecc866514e956a, 0xbfb3d99766cab474,
    0x3fdc3c1a9023252c, 0xbfcee8563e743bfc,
    0x3fb2be011c662f92, 0xbfcba270842843a0,
    0xbfd5747a3432f9c9, 0xbff6f76aa7ac42df,
    0xbff351d8520faf57, 0x3fe4335789026d21,
    0xbfd449d258e91f5d, 0x3ff7158684ed3379,
    0xbfe0318248f7d8b2, 0x3fe7a59815326544,
    0x3fe5d874daa3b70f, 0x3fd999f708635f02,
    0xbfd9bbcc616883e0, 0x3ff13bc236d3a81a,
    0xbfe3fbb5312dc4ec, 0xbfdd9f3b2b71f07e,
    0x3f9ce395a776a000, 0xbfd223eb467fc37e,
    0x3fdbce4c9bb53d24, 0x3ff04087d482b112,
    0xbfa3c84515c611c0, 0x3fcff8d0054c2a76,
    0xbfe3c4f95aad0198, 0xbffca39649171000,
    0xbfe6638ba06e5fdf, 0x3fcafa530d5fbb82,
    0xbf936e775260ebc0, 0x3fbc44ff9d1d7586,
    0x3ff67bf9ad2bcee7, 0x3fba09302c678ce0,
    0xbf938e40f826cac0, 0x3ff47fa00e0ba7e4,
    0xbfbdd9ab17e43ed0, 0xbfe034b456ed435e,
    0x3fa1e5fe31940430, 0xbf93ba64b862a760,
    0x3ff7a903f86d4383, 0xbfdf1c932ee1e027,
    0xbfd55279fbf9d83e, 0x3fd7c81932aa438f,
    0x3fe0f4d76a620e31, 0x3fd1c2143c714ee8,
    0x3fd7fc73e2d236d4, 0xbfdeb29cb04b61b0,
    0xbffe910abc38cb8d, 0xbf9b7957a2f5d130,
    0x3fb22909bd202954, 0xbff465096b3a60a8,
    0xbff4138e6a50a5ae, 0x3fe20dece27c78b6,
    0x3fda0251a95eff9f, 0xbf89426375cf4690,
    0xbff5272c5d8fa1b7, 0xbff5f90c8f536fd3,
    0x3fdf9fa5a7136b87, 0xbfdfd4182f280772,
    0x3fec0cd17a864d7b, 0x3feb2334ffa596cb,
    0xbfce2d2b770b75ea, 0xbfd4cab0ea2226ed,
    0xbfe84370cc6c68a6, 0x3fc34cfd6f203974,
    0x3fd74407bc7c6a4a, 0x3fc5ce9e40e77e53,
    0x3ff1bfe8f988ea7c, 0xbfd4484058bcdfdd,
    0xbff9fb56116bf0cb, 0x3ff0063b71bb2c97,
    0x3fde962c044d8f2a, 0x3ffb3851c24ed1c1,
    0x3fb39202f883895c, 0xbfe42910ce030f59,
    0xbfd21795662e59fb, 0x3fdae8b3a852ef6d,
    0xbfd4adc27fd5b780, 0x3ff1e926744a8f72,
    0xbfb53aa28ef85848, 0x3fd1ac0521d0c8db,
    0x3fe3fa31c522384e, 0xbffa5ae52a6333f8,
    0x3ff0f3ab0220f420, 0x3fe947d381454338,
    0xbfde1b4410139129, 0x3ff815cf8b8f63fd,
    0x3fc46bb608f19bc2, 0x3fccda670e23e70b,
    0x3fdaa2715811bec8, 0x3ff0a3d5e3a4a1c4,
    0xbfe59d14adef7245, 0xbff6c9bfb09db078,
    0x3fcffd446d2d4832, 0xbfd3a683da0aa622,
    0x3fdd5ed05709ca79, 0x3fe04c2ab7af94bc,
    0x3fe0cd4b8476c7cc, 0x0,
    0x3fdd5ed05709ca74, 0xbfe04c2ab7af94b8,
    0x3fcffd446d2d482f, 0x3fd3a683da0aa626,
    0xbfe59d14adef7246, 0x3ff6c9bfb09db078,
    0x3fdaa2715811bec6, 0xbff0a3d5e3a4a1c2,
    0x3fc46bb608f19bc0, 0xbfccda670e23e708,
    0xbfde1b4410139123, 0xbff815cf8b8f63fc,
    0x3ff0f3ab0220f421, 0xbfe947d381454335,
    0x3fe3fa31c522384d, 0x3ffa5ae52a6333f9,
    0xbfb53aa28ef85860, 0xbfd1ac0521d0c8de,
    0xbfd4adc27fd5b780, 0xbff1e926744a8f73,
    0xbfd21795662e59fe, 0xbfdae8b3a852ef72,
    0x3fb39202f8838958, 0x3fe42910ce030f5c,
    0x3fde962c044d8f2c, 0xbffb3851c24ed1c1,
    0xbff9fb56116bf0ca, 0xbff0063b71bb2c97,
    0x3ff1bfe8f988ea7c, 0x3fd4484058bcdfdc,
    0x3fd74407bc7c6a48, 0xbfc5ce9e40e77e52,
    0xbfe84370cc6c68a6, 0xbfc34cfd6f20397c,
    0xbfce2d2b770b75e7, 0x3fd4cab0ea2226ef,
    0x3fec0cd17a864d7c, 0xbfeb2334ffa596ca,
    0x3fdf9fa5a7136b88, 0x3fdfd4182f280770,
    0xbff5272c5d8fa1b6, 0x3ff5f90c8f536fd2,
    0x3fda0251a95effa5, 0x3f89426375cf4600,
    0xbff4138e6a50a5ad, 0xbfe20dece27c78b5,
    0x3fb22909bd202958, 0x3ff465096b3a60a8,
    0xbffe910abc38cb8d, 0x3f9b7957a2f5d140,
    0x3fd7fc73e2d236d2, 0x3fdeb29cb04b61ad,
    0x3fe0f4d76a620e2e, 0xbfd1c2143c714eea,
    0xbfd55279fbf9d83c, 0xbfd7c81932aa4394,
    0x3ff7a903f86d4383, 0x3fdf1c932ee1e028,
    0x3fa1e5fe31940438, 0x3f93ba64b862a7a0,
    0xbfbdd9ab17e43ee0, 0x3fe034b456ed4360,
    0xbf938e40f826cab0, 0xbff47fa00e0ba7e4,
    0x3ff67bf9ad2bcee7, 0xbfba09302c678cf8,
    0xbf936e775260eb60, 0xbfbc44ff9d1d7582,
    0xbfe6638ba06e5fdc, 0xbfcafa530d5fbb8c,
    0xbfe3c4f95aad0196, 0x3ffca39649170ffe,
    0xbfa3c84515c611c0, 0xbfcff8d0054c2a71,
    0x3fdbce4c9bb53d22, 0xbff04087d482b111,
    0x3f9ce395a7769fa0, 0x3fd223eb467fc37a,
    0xbfe3fbb5312dc4ec, 0x3fdd9f3b2b71f080,
    0xbfd9bbcc616883e6, 0xbff13bc236d3a818,
    0x3fe5d874daa3b70d, 0xbfd999f708635f01,
    0xbfe0318248f7d8b3, 0xbfe7a59815326544,
    0xbfd449d258e91f60, 0xbff7158684ed3379,
    0xbff351d8520faf56, 0xbfe4335789026d1f,
    0xbfd5747a3432f9c5, 0x3ff6f76aa7ac42e0,
    0x3fb2be011c662f88, 0x3fcba270842843a8,
    0x3fdc3c1a9023252b, 0x3fcee8563e743c00,
    0xbfecc866514e956c, 0x3fb3d99766cab480,
    0xbfe32bebf51e9c25, 0xbfd4b67c7c8cc7ac,
    0xbfef9eb841d878f6, 0x3fc0879a65cdafdc,
    0x3fe42c407ee33963, 0x3ff7328b9611d503,
    0xbff366fe167bb5a6, 0xbfcc21244f285200,
    0x3fa2fbdcc60e7e70, 0xc00247aab465607b,
    0xbfea878c85da4722, 0xbfe0598af9d6e0ff,
    0xc0010d52412937e3, 0xbfa03946e2cadd40,
    0xbfe51b9cb0a24da0, 0x3fc97553764de91b,
    0x3fad9c1ca37bcc44, 0x3febc878ae7e9edc,
    0x3fe3a857e44957ca, 0x3fc3fb53eb87b004,
    0x3feaa7784101ed94, 0x3fc5eaaf5c9f560a,
    0xbfd2232534f5957b, 0x3fe9379e6aa990a2,
    0x3fc427338bce2926, 0x3ff2cc35108290bf,
    0xbff063d592874418, 0x3fc121ae72229190,
    0xbfd7989e6d379442, 0x3fe861ca44519e80,
    0x3fe7e80364052cfa, 0xbfb64ffd0ddb0860,
    0x3fe782ba0a5d1720, 0xbfc5cb0a96713ef8,
    0x3ff2114287dece62, 0xbfe48d4b5c509d57,
    0x3fec2b346bbbab70, 0x3ff3edc6c9e4e44b,
    0x4000bab9f6611179, 0xbff05a1a11a9ec7e,
    0xbfe479198cbd2c8c, 0xbfe4ac4c8934b2ba,
    0xbfe2515a817e28be, 0xbffccec251125a7e,
    0xbfb6aa23788e6364, 0xbffc14ec991e4231,
    0xbfe3e621fb28bcaa, 0xbfe154c7009f4f39,
    0xbff43a719819a1a6, 0xbfdaf2ec1b1a3ec0,
    0xbfd7363244f60e79, 0xbfcea365df4ba758,
    0x3fe589a8e1093dbc, 0x3fcdfd73e59b360f,
    0x3fed1df1dedee9bf, 0x3ff25996cf069ccf,
    0xbff37d2cbefe735f, 0x3fea218c34a05217,
    0xbfe0cb92b266552e, 0xbff50aa60b228a75,
    0x3fdfd118d3bdbea7, 0x3fe48719ab180a2a,
    0xbfd2b8ad8e03edcf, 0xbfcb59898983fc61,
    0xbff750182d545cf0, 0xbfd4d4a021b59b88,
    0x3fe4a97d9c8a68bf, 0x3fc92cd7c3e8bb05,
    0x3fe9be0768219904, 0x3fb4fc0420af8ed8,
    0xbfe2ae038a49ad1a, 0x3fbb3fae02dd227e,
    0x3fb20c620db4c84c, 0xbfc10d09ba033f80,
    0xbf78c7b592de9300, 0x3ff98222afe6b93f,
    0xbfe3e845412c61c8, 0x3fd168cbfaaa413a,
    0xbfe280b52ba67851, 0xbfb0efafec94c190,
    0xbfe56f03d5f11146, 0x3ff76a6d2928f316,
    0x3ff9e24f6e053308, 0xbfce1de6eaf08078,
    0xbfe8eda21f59209f, 0x3fb11331cfb732c0,
    0x3fc80bbdc129c618, 0x3fb799454e7e3038,
    0x3fe67e26a5c09434, 0xbff42db91c671c4d,
    0x3ff1feff646e75de, 0xbff8a85e1c15ed34,
    0x3fdb270b7ad6b27d, 0x3ff630f2786eb327,
    0x3fdfc1c93d7bb58a, 0xbff33d22e7850ef0,
    0xbfebf2c7296ca758, 0xbfea6f9075313dea,
    0xbff1511745685e08, 0x3fe3e3095ddf0ec8,
    0xbff5a2cfddafd5bb, 0xbff6e70a9d724552,
    0x3fddb1bba31a156e, 0xbfa470524037a678,
    0x3ff18eb244fc0ee4, 0x3fdaad2c71460752,
    0xbfe001fa224a554c, 0x3ffb5f8ba848895d,
    0x3fd113f3643b6023, 0x3fc7eebe982e3a06,
    0xbfce77da4472e9e6, 0x3fd5bc0202be57db,
    0xbfe03b1d306dafa3, 0x3ffdbedbdc0c5796,
    0xbfef2f70d47ccaf7, 0xbfe4bf489db1b710,
    0xbfdca66dba3702ec, 0xbfeb032611c67ecd,
    0x3fe64ceebec11ce5, 0xbff148dbfd188d5c,
    0x3fc83ff89546eb10, 0x3fb4ecdb3babab38,
    0xbff11955096a4ad6, 0xbfe379cf726ce0dc,
    0x3fec9e2ec46ad5f4, 0xbfb0ac9be34b94e9,
    0x3fe319b17b9d51a9, 0x3fc3bd91260634e6,
    0x3fc1009e4fb83088, 0xbfe68b993f7c60ed,
    0xbfd6c878e207393a, 0xbfdd13ec9d8e9389,
    0xbfb983d387dc1e3e, 0x3fe88fd92bd10c1d,
    0xbfd461372209693a, 0xbfbd7966b879765b,
    0xbff7843aaeda50aa, 0xbfe3f78f713f7558,
    0xbfc640b864b108c1, 0xbff65f4353619583,
    0x3ffa544bce815cc3, 0xbfcf7502baccdb18,
    0x3fe81d826b984515, 0x3fe080e4ca4fc526,
    0xbfea31cf9fd4e7cf, 0x3fe3a3e1de23e551,
    0x3fb38cde770db3aa, 0x3faeb6fdd59b6ff4,
    0xbfcac5b88fe1cda8, 0xbfd4f2d7dfec6b3f,
    0x3fd3bf4fb70ddf44, 0x3fc76d79d7a70398,
    0xbfee550e32cacdde, 0x3fd3bdefb6eecb1c,
    0xc002da8a3f632adf, 0x3f69e180a667fc80,
    0x3fdda0fb7e245fd7, 0x3fdef4fe5e5f49c0,
    0xbfe793590556a5b2, 0x3fe747a0d4fba490,
    0x3ff496787be022c8, 0xc00563aeebce2ddc,
    0xbff470c2c81d1efe, 0xbfe1fbba3906d048,
    0xbfe7ead5ed7d7239, 0xbfe524761b8818a7,
    0xbfd6e9cc3d1b165e, 0x3fcd3c75aa99fdbc,
    0x3fe1de57b53197de, 0xbfe0d08105339c43,
    0xbfdfd5d0691eddc8, 0xbff4756e760e951f,
    0x3ffa636695699954, 0x3fee3ed18f79c259,
    0xbfdcc936e7b1b20d, 0xbfe2d46b53f6f7f0,
    0x3fecf35f27fa19e0, 0x3ff478d87e1b838a,
    0x3fd13f89dfc92e7b, 0xbf879e4c7fa370e0,
    0xbfc0a0ceabd7a4d2, 0xbfc6d0857bf3f0e6,
    0x3fe41080ecc82271, 0xbfeac0c43791dadc,
    0xbfe157d34b966667, 0xbfb75be3562c078c,
    0xbfead803c61ac83f, 0xbfb1a503371dd5ee,
    0xbf9c3e81281b1540, 0x3fd019ba8bd9e410,
    0xbfb58fdc14d8a9f8, 0xbff06ab4f8b9b7d5,
    0xbfe200ea5f733a5a, 0xbfe4a008983ac136,
    0xbfbd1e6e36ce670c, 0x3f9313a878e7c760,
    0x3ff8b44af475802c, 0x3ff6e4d1869a505c,
    0xbff67e7f18beea15, 0xbfddd3a08e30e8b4,
    0x3fd961362cf9ab8d, 0x3fc56e84c2ac2120,
    0x3fe3b356945e03d4, 0xbfd6bfd1503b251e,
    0xbfeca0e866316172, 0x3fde2cb9c3390c6b,
    0x3fd25407d8329b9a, 0xbfecdec4372100bb,
    0xbfd4cab04ecb19ef, 0xbfd9eb7ba3800e93,
    0xbfe2633ed2f4d3c8, 0xbfdc64409ee3b320,
    0xbfa7d3fa2966dfc0, 0x3fd0d9a9ce70e4d0,
    0xbfe20ccaa9269929, 0x3fe2a6afa6d2886e,
    0xbfc2d0cb72b120d0, 0x3fec3d998b0495b2,
    0xbff0e392a89565f2, 0x3ffd8a4d08037dd3,
    0xbfd61094011465aa, 0xbff659e37e2c2a8b,
    0xbfed3471618e6346, 0x3fe9c02a5661a5ca,
    0x3ff41d953f8eacdb, 0xbfd08ee55f669e84,
    0xbff58dc5dde8f75c, 0xbffab564c39042d8,
    0x3fc8597f12bc5b6a, 0xbff44b75c81dc76d,
    0x3fe45828db0438f3, 0xc002b518e46153a9,
    0xbfe0a72e424135d4, 0xbfe9e4529022d472,
    0xbfebc7ec603720e6, 0xbfd4e22d6ff4cd50,
    0xbff81ea0a30f0188, 0xbfd1ed869e49ca1b,
    0x40020ad06679614b, 0x4000187f26917a4c,
    0x3fee53223169d2c6, 0x3fe8829d7033ae07,
    0x3ff8cbf43793d08a, 0xbfe032987fadd267,
    0xbfe612e7cad26e3b, 0x3fe191f664eb3dc4,
    0x3fef77d9b51a91f0, 0x3fe28a63ebd68d0b,
    0xbfd72be59cc45f46, 0x3fd7eacb13179f71,
    0xbfc90d7b7234e3e0, 0x3fad8dea8d032028,
    0x3fd8ace33fc428c2, 0x3fbc89e2b728a944,
    0x3fa12ae79ddd4870, 0x3fe12c70d3af6256,
    0xbfe9ca7c2085c91c, 0xbfe038a397183b0c,
    0x3fc9f565812c15a0, 0xbfe3e43880bf759c,
    0x3fe70d3f4b771363, 0x3fe2cdac8fe9044b,
    0xbfc0b0e4e8ec23ad, 0x3ff8df32b671ad21,
    0x3ff1ffb848ec9bf6, 0x3ff7edcc62819ed9,
    0x3fefcb57daf73e5e, 0xbff31541a5bd67d0,
    0x3fe2f51e06480ba6, 0x3fe4ae75cb172736,
    0xbfe1de24e8ed9f53, 0xbffb513a2f8d5697,
    0x3fb1d864b52bfdf8, 0xbfdbc0f47a4e7dd2,
    0x3fe0136521a64dc6, 0xbfc1079128bd9a0c,
    0x3fdb9e2cc79a4414, 0xbfe68af6c229c0af,
    0x3fdce9375692f4da, 0xbfda00c7edc128f3,
    0x3f9dd04c605d6140, 0x400185f0706bc100,
    0x3f9a68d5465f85b0, 0xbffd445c4ff69e16,
    0xbfcd2150937de3b8, 0x4066647a10be550a,
    0xbfe902635185b922, 0x3ff4479fff4ac05c,
    0x3fca166b07e118c6, 0x3fe1532ac7f7dc40,
    0xbfd5340c7e04bada, 0xbfc5caabbb9dabd6,
    0x3fd2f9f8aa50f040, 0x3fe3ec5f14a7309a,
    0xbfc8b6bdc6b94732, 0x3fef918be518846c,
    0xbfc34d9e868bde54, 0x3ff7a8492474859d,
    0x3fc6b9729f39f08a, 0xbfb7989e6defdcda,
    0x3fdcd9b0de2fc75a, 0x3ff7bae905df4c12,
    0x400006869fb6a968, 0xbfdcee65076f9baa,
    0xbfc2fbe64cfe3460, 0xbfa38ff82d765080,
    0xbff004c9c0fc6af1, 0xbfe0ff7ad9c831d7,
    0xbfecd18205210481, 0x3ff24c2ef909d3d1,
    0xbfb687ecbddd6ba4, 0xbf53a7c08893ba40,
    0xbfe142a64381bcb2, 0xbff62cce8adb5aa6,
    0x3fdd1bc2797198ef, 0xbfe3c9865d5f2c6c,
    0x3ff30557d129c58f, 0xbff5336b64aaa52c,
    0x3fd78a47a44f6eca, 0x3fe220fdb85c6c29,
    0xbff0d3e2dd289048, 0xbfe0c68fd1a2c768,
    0x3ff215fa9dc0cbef, 0xbff74d1250d9bd6e,
    0xbfc97de42e17c34e, 0x3fdfc9999416cc67,
    0x3ffef19eb0b8a925, 0x3fdaf23d231a0687,
    0x3ffd19b6bcdbdaf4, 0x3fe1cf53f73654bc,
    0xbfb374d66b90e3d2, 0xbfb6311c7675528c,
    0x3fcabd8bf756a15a, 0x3fe68c7fb1e25b37,
    0xbff385982e87f7b2, 0xbfdcdd16ff0efa52,
    0x3fcc27570b095c04, 0xbfc8afa99fbff864,
    0x3ff1af5911da8146, 0x3fc0188fc6d7ff72,
    0xbfcc82b50d3e9556, 0xbfb0aa8ac72de558,
    0xbfe6b3bef1dca815, 0x3fe707441e462406,
    0x3ff7b33c65841855, 0xbfc88c5cb07c1893,
    0xbfd7ac2047dcf960, 0xbfec5d6ff557173c,
    0xbfe2ed8d20f72bdf, 0xbfdc0540a88f716b,
    0x3feeab5cc2559888, 0x3ff41dd3b9235c6e,
    0xbfd0a110f60b1e40, 0xbff590fb8c8388ba,
    0xbfed9a0c5242f95e, 0xbfd85b2b6175afe9,
    0x3fe3d55155486b3c, 0x3ff4b24c22aff828,
    0xbfe8c9c9ce1713d9, 0xbf6bbd395fd379c0,
    0x3fdd95b30d9a81e8, 0x3f96ebee138e5e60,
    0x3fef31f3901d963e, 0xbfed039e4e5f4be6,
    0xbfd56a49d448467b, 0xbfd206c7fc34a852,
    0xbfe363fb5aeaf0e8, 0x3fc94d33257f7c9a,
    0xbfb9c4292582371c, 0xbfcafd0a49e1a3cf,
    0x3fc19ffec8b34950, 0x3fdf139dc2644127,
    0x3fe458af435e5b4a, 0xbfb0a7095893a128,
    0x3fe03d6fe0daa821, 0x3fe5888405a43565,
    0x3fd5a9301acf13c1, 0x3fa3af4c5e27bee8,
    0xbff733a1d52016bb, 0xbffb12d2ed0bf302,
    0xbfcbaaf2b1623f6d, 0x3fc04b5c5a9fe49b,
    0xbfc45053709c640c, 0x3fdc0542cae05427,
    0xc0015d20162817e6, 0x3ff68dd41116009b,
    0xbfb83f3c57110948, 0xbfea5d1d9d6e2562,
    0xbfb7cd244d00051a, 0xbfc2123919f18894,
    0xbfd47491f5117131, 0x3fd2cfb8244de867,
    0xbfec3a1529f14598, 0xbfdd0ddf1d59c2be,
    0xbff447b0fbbb8302, 0x3faf546edcbe2172,
    0xbfe1561f88dafa7c, 0xbfe3f869ae791f24,
    0x3ff39c753ec521f6, 0x3fe2e4010ff81afc,
    0xbfdbd015c77a3f4b, 0x3ff0d6788f088b57,
    0xbfaa42e84179d800, 0xbfd5b89c458ae4c6,
    0xbfeddc2b4a40932a, 0xbfe919c475784088,
    0x3fe030f26390b3c7, 0x3fea179f712598e3,
    0xbfe75925b7449500, 0xbfd961ca943ef88e,
    0xbfc199602539f3b2, 0x3fed0f7370e4a318
    };

static const uint64_t ref_cfft_noisy_512[1024] = {
    0xbfb8e29ab4bc2fa4, 0x0,
    0xbfc199602539f3b8, 0xbfed0f7370e4a318,
    0xbfe75925b74494fe, 0x3fd961ca943ef88e,
    0x3fe030f26390b3c8, 0xbfea179f712598e3,
    0xbfeddc2b4a40932b, 0x3fe919c475784085,
    0xbfaa42e84179d800, 0x3fd5b89c458ae4c4,
    0xbfdbd015c77a3f49, 0xbff0d6788f088b56,
    0x3ff39c753ec521f7, 0xbfe2e4010ff81afb,
    0xbfe1561f88dafa7b, 0x3fe3f869ae791f22,
    0xbff447b0fbbb8302, 0xbfaf546edcbe214e,
    0xbfec3a1529f14598, 0x3fdd0ddf1d59c2bd,
    0xbfd47491f5117130, 0xbfd2cfb8244de86a,
    0xbfb7cd244d000514, 0x3fc2123919f18895,
    0xbfb83f3c57110958, 0x3fea5d1d9d6e2562,
    0xc0015d20162817e6, 0xbff68dd41116009b,
    0xbfc45053709c6404, 0xbfdc0542cae05426,
    0xbfcbaaf2b1623f6b, 0xbfc04b5c5a9fe49c,
    0xbff733a1d52016bb, 0x3ffb12d2ed0bf302,
    0x3fd5a9301acf13c2, 0xbfa3af4c5e27bed8,
    0x3fe03d6fe0daa822, 0xbfe5888405a43564,
    0x3fe458af435e5b48, 0x3fb0a7095893a110,
    0x3fc19ffec8b34950, 0xbfdf139dc2644120,
    0xbfb9c4292582371c, 0x3fcafd0a49e1a3c8,
    0xbfe363fb5aeaf0ea, 0xbfc94d33257f7ca0,
    0xbfd56a49d448467c, 0x3fd206c7fc34a854,
    0x3fef31f3901d963e, 0x3fed039e4e5f4be4,
    0x3fdd95b30d9a81e8, 0xbf96ebee138e5e50,
    0xbfe8c9c9ce1713d8, 0x3f6bbd395fd37800,
    0x3fe3d55155486b3c, 0xbff4b24c22aff828,
    0xbfed9a0c5242f962, 0x3fd85b2b6175afea,
    0xbfd0a110f60b1e3d, 0x3ff590fb8c8388ba,
    0x3feeab5cc2559888, 0xbff41dd3b9235c6c,
    0xbfe2ed8d20f72be0, 0x3fdc0540a88f7169,
    0xbfd7ac2047dcf95c, 0x3fec5d6ff5571739,
    0x3ff7b33c65841854, 0x3fc88c5cb07c1899,
    0xbfe6b3bef1dca818, 0xbfe707441e462407,
    0xbfcc82b50d3e954b, 0x3fb0aa8ac72de558,
    0x3ff1af5911da8145, 0xbfc0188fc6d7ff6f,
    0x3fcc27570b095c0b, 0x3fc8afa99fbff856,
    0xbff385982e87f7b2, 0x3fdcdd16ff0efa4c,
    0x3fcabd8bf756a15c, 0xbfe68c7fb1e25b38,
    0xbfb374d66b90e3b8, 0x3fb6311c76755278,
    0x3ffd19b6bcdbdaf6, 0xbfe1cf53f73654bc,
    0x3ffef19eb0b8a926, 0xbfdaf23d231a0687,
    0xbfc97de42e17c349, 0xbfdfc9999416cc69,
    0x3ff215fa9dc0cbf0, 0x3ff74d1250d9bd6c,
    0xbff0d3e2dd289047, 0x3fe0c68fd1a2c769,
    0x3fd78a47a44f6ed0, 0xbfe220fdb85c6c29,
    0x3ff30557d129c58f, 0x3ff5336b64aaa52b,
    0x3fdd1bc2797198f1, 0x3fe3c9865d5f2c6e,
    0xbfe142a64381bcb3, 0x3ff62cce8adb5aa5,
    0xbfb687ecbddd6bac, 0x3f53a7c08893b800,
    0xbfecd18205210481, 0xbff24c2ef909d3d1,
    0xbff004c9c0fc6af2, 0x3fe0ff7ad9c831d8,
    0xbfc2fbe64cfe3458, 0x3fa38ff82d765040,
    0x400006869fb6a966, 0x3fdcee65076f9bac,
    0x3fdcd9b0de2fc75a, 0xbff7bae905df4c11,
    0x3fc6b9729f39f08e, 0x3fb7989e6defdce2,
    0xbfc34d9e868bde4b, 0xbff7a8492474859c,
    0xbfc8b6bdc6b94736, 0xbfef918be518846b,
    0x3fd2f9f8aa50f040, 0xbfe3ec5f14a7309a,
    0xbfd5340c7e04bad9, 0x3fc5caabbb9dabd6,
    0x3fca166b07e118be, 0xbfe1532ac7f7dc42,
    0xbfe902635185b91f, 0xbff4479fff4ac05c,
    0xbfcd2150937de3b8, 0xc066647a10be550a,
    0x3f9a68d5465f85c0, 0x3ffd445c4ff69e18,
    0x3f9dd04c605d6170, 0xc00185f0706bc100,
    0x3fdce9375692f4d9, 0x3fda00c7edc128f6,
    0x3fdb9e2cc79a4414, 0x3fe68af6c229c0ae,
    0x3fe0136521a64dc7, 0x3fc1079128bd9a0a,
    0x3fb1d864b52bfdfc, 0x3fdbc0f47a4e7dd0,
    0xbfe1de24e8ed9f54, 0x3ffb513a2f8d5698,
    0x3fe2f51e06480ba6, 0xbfe4ae75cb172736,
    0x3fefcb57daf73e5e, 0x3ff31541a5bd67d0,
    0x3ff1ffb848ec9bf8, 0xbff7edcc62819eda,
    0xbfc0b0e4e8ec23ae, 0xbff8df32b671ad1f,
    0x3fe70d3f4b771362, 0xbfe2cdac8fe9044d,
    0x3fc9f565812c1594, 0x3fe3e43880bf759e,
    0xbfe9ca7c2085c91e, 0x3fe038a397183b0d,
    0x3fa12ae79ddd4878, 0xbfe12c70d3af6254,
    0x3fd8ace33fc428c1, 0xbfbc89e2b728a940,
    0xbfc90d7b7234e3e0, 0xbfad8dea8d03202c,
    0xbfd72be59cc45f48, 0xbfd7eacb13179f74,
    0x3fef77d9b51a91ef, 0xbfe28a63ebd68d0a,
    0xbfe612e7cad26e3e, 0xbfe191f664eb3dc5,
    0x3ff8cbf43793d089, 0x3fe032987fadd268,
    0x3fee53223169d2c6, 0xbfe8829d7033ae07,
    0x40020ad06679614c, 0xc000187f26917a4d,
    0xbff81ea0a30f0188, 0x3fd1ed869e49ca1a,
    0xbfebc7ec603720e7, 0x3fd4e22d6ff4cd52,
    0xbfe0a72e424135d2, 0x3fe9e4529022d473,
    0x3fe45828db0438f4, 0x4002b518e46153aa,
    0x3fc8597f12bc5b70, 0x3ff44b75c81dc76f,
    0xbff58dc5dde8f75d, 0x3ffab564c39042d8,
    0x3ff41d953f8eacdc, 0x3fd08ee55f669e84,
    0xbfed3471618e6345, 0xbfe9c02a5661a5c8,
    0xbfd61094011465ab, 0x3ff659e37e2c2a8b,
    0xbff0e392a89565f2, 0xbffd8a4d08037dd4,
    0xbfc2d0cb72b120d0, 0xbfec3d998b0495b6,
    0xbfe20ccaa9269928, 0xbfe2a6afa6d2886c,
    0xbfa7d3fa2966dfa0, 0xbfd0d9a9ce70e4ce,
    0xbfe2633ed2f4d3c5, 0x3fdc64409ee3b31a,
    0xbfd4cab04ecb19ec, 0x3fd9eb7ba3800e94,
    0x3fd25407d8329b9d, 0x3fecdec4372100be,
    0xbfeca0e866316172, 0xbfde2cb9c3390c6b,
    0x3fe3b356945e03d6, 0x3fd6bfd1503b251d,
    0x3fd961362cf9ab92, 0xbfc56e84c2ac212c,
    0xbff67e7f18beea15, 0x3fddd3a08e30e8b5,
    0x3ff8b44af475802c, 0xbff6e4d1869a505e,
    0xbfbd1e6e36ce6708, 0xbf9313a878e7c7a0,
    0xbfe200ea5f733a58, 0x3fe4a008983ac139,
    0xbfb58fdc14d8a9fc, 0x3ff06ab4f8b9b7d5,
    0xbf9c3e81281b1550, 0xbfd019ba8bd9e40f,
    0xbfead803c61ac83f, 0x3fb1a503371dd5da,
    0xbfe157d34b966666, 0x3fb75be3562c07a0,
    0x3fe41080ecc8226f, 0x3feac0c43791dade,
    0xbfc0a0ceabd7a4d2, 0x3fc6d0857bf3f0e4,
    0x3fd13f89dfc92e7a, 0x3f879e4c7fa370d8,
    0x3fecf35f27fa19e0, 0xbff478d87e1b838b,
    0xbfdcc936e7b1b20c, 0x3fe2d46b53f6f7ec,
    0x3ffa636695699955, 0xbfee3ed18f79c25a,
    0xbfdfd5d0691eddca, 0x3ff4756e760e951f,
    0x3fe1de57b53197dd, 0x3fe0d08105339c41,
    0xbfd6e9cc3d1b1660, 0xbfcd3c75aa99fdb7,
    0xbfe7ead5ed7d723a, 0x3fe524761b8818a6,
    0xbff470c2c81d1efe, 0x3fe1fbba3906d046,
    0x3ff496787be022c9, 0x400563aeebce2ddc,
    0xbfe793590556a5b4, 0xbfe747a0d4fba492,
    0x3fdda0fb7e245fd7, 0xbfdef4fe5e5f49c0,
    0xc002da8a3f632ade, 0xbf69e180a667fb80,
    0xbfee550e32cacddb, 0xbfd3bdefb6eecb20,
    0x3fd3bf4fb70ddf41, 0xbfc76d79d7a70398,
    0xbfcac5b88fe1cdac, 0x3fd4f2d7dfec6b3e,
    0x3fb38cde770db3aa, 0xbfaeb6fdd59b6fee,
    0xbfea31cf9fd4e7ce, 0xbfe3a3e1de23e551,
    0x3fe81d826b984516, 0xbfe080e4ca4fc526,
    0x3ffa544bce815cc4, 0x3fcf7502baccdb1c,
    0xbfc640b864b108c2, 0x3ff65f4353619584,
    0xbff7843aaeda50aa, 0x3fe3f78f713f7558,
    0xbfd461372209693d, 0x3fbd7966b8797668,
    0xbfb983d387dc1e48, 0xbfe88fd92bd10c1e,
    0xbfd6c878e207393c, 0x3fdd13ec9d8e9387,
    0x3fc1009e4fb8308c, 0x3fe68b993f7c60ec,
    0x3fe319b17b9d51a9, 0xbfc3bd91260634e7,
    0x3fec9e2ec46ad5f4, 0x3fb0ac9be34b94e6,
    0xbff11955096a4ad6, 0x3fe379cf726ce0da,
    0x3fc83ff89546eb13, 0xbfb4ecdb3babab3c,
    0x3fe64ceebec11ce6, 0x3ff148dbfd188d5c,
    0xbfdca66dba3702ea, 0x3feb032611c67ec9,
    0xbfef2f70d47ccaf6, 0x3fe4bf489db1b70e,
    0xbfe03b1d306dafa4, 0xbffdbedbdc0c5794,
    0xbfce77da4472e9ee, 0xbfd5bc0202be57dc,
    0x3fd113f3643b6021, 0xbfc7eebe982e3a06,
    0xbfe001fa224a554d, 0xbffb5f8ba848895e,
    0x3ff18eb244fc0ee4, 0xbfdaad2c7146074d,
    0x3fddb1bba31a1571, 0x3fa470524037a694,
    0xbff5a2cfddafd5bb, 0x3ff6e70a9d724553,
    0xbff1511745685e06, 0xbfe3e3095ddf0eca,
    0xbfebf2c7296ca758, 0x3fea6f9075313de8,
    0x3fdfc1c93d7bb588, 0x3ff33d22e7850ef1,
    0x3fdb270b7ad6b27c, 0xbff630f2786eb327,
    0x3ff1feff646e75dd, 0x3ff8a85e1c15ed33,
    0x3fe67e26a5c09434, 0x3ff42db91c671c4d,
    0x3fc80bbdc129c610, 0xbfb799454e7e3058,
    0xbfe8eda21f5920a0, 0xbfb11331cfb732d0,
    0x3ff9e24f6e053306, 0x3fce1de6eaf08070,
    0xbfe56f03d5f11148, 0xbff76a6d2928f315,
    0xbfe280b52ba6784e, 0x3fb0efafec94c18a,
    0xbfe3e845412c61c8, 0xbfd168cbfaaa4139,
    0xbf78c7b592de9200, 0xbff98222afe6b93d,
    0x3fb20c620db4c854, 0x3fc10d09ba033f8c,
    0xbfe2ae038a49ad19, 0xbfbb3fae02dd2288,
    0x3fe9be0768219901, 0xbfb4fc0420af8ed0,
    0x3fe4a97d9c8a68be, 0xbfc92cd7c3e8bb04,
    0xbff750182d545cee, 0x3fd4d4a021b59b85,
    0xbfd2b8ad8e03edd2, 0x3fcb59898983fc66,
    0x3fdfd118d3bdbea6, 0xbfe48719ab180a2a,
    0xbfe0cb92b266552d, 0x3ff50aa60b228a76,
    0xbff37d2cbefe735e, 0xbfea218c34a05218,
    0x3fed1df1dedee9bc, 0xbff25996cf069cd0,
    0x3fe589a8e1093dbb, 0xbfcdfd73e59b3603,
    0xbfd7363244f60e7c, 0x3fcea365df4ba758,
    0xbff43a719819a1a6, 0x3fdaf2ec1b1a3ecc,
    0xbfe3e621fb28bcaa, 0x3fe154c7009f4f35,
    0xbfb6aa23788e6360, 0x3ffc14ec991e4231,
    0xbfe2515a817e28bd, 0x3ffccec251125a7f,
    0xbfe479198cbd2c89, 0x3fe4ac4c8934b2bb,
    0x4000bab9f661117a, 0x3ff05a1a11a9ec7c,
    0x3fec2b346bbbab72, 0xbff3edc6c9e4e44a,
    0x3ff2114287dece60, 0x3fe48d4b5c509d56,
    0x3fe782ba0a5d171f, 0x3fc5cb0a96713ef8,
    0x3fe7e80364052cfa, 0x3fb64ffd0ddb0848,
    0xbfd7989e6d379442, 0xbfe861ca44519e80,
    0xbff063d592874419, 0xbfc121ae72229194,
    0x3fc427338bce291a, 0xbff2cc35108290be,
    0xbfd2232534f5957c, 0xbfe9379e6aa990a2,
    0x3feaa7784101ed92, 0xbfc5eaaf5c9f560a,
    0x3fe3a857e44957c8, 0xbfc3fb53eb87b00a,
    0x3fad9c1ca37bcc5e, 0xbfebc878ae7e9eda,
    0xbfe51b9cb0a24da2, 0xbfc97553764de91d,
    0xc0010d52412937e3, 0x3fa03946e2cadd20,
    0xbfea878c85da472a, 0x3fe0598af9d6e0ff,
    0x3fa2fbdcc60e7e6a, 0x400247aab465607b,
    0xbff366fe167bb5a7, 0x3fcc21244f285200,
    0x3fe42c407ee33963, 0xbff7328b9611d503,
    0xbfef9eb841d878f8, 0xbfc0879a65cdafdc,
    0xbfe32bebf51e9c26, 0x3fd4b67c7c8cc7ae,
    0xbfecc866514e956a, 0xbfb3d99766cab474,
    0x3fdc3c1a9023252c, 0xbfcee8563e743bfc,
    0x3fb2be011c662f92, 0xbfcba270842843a0,
    0xbfd5747a3432f9c9, 0xbff6f76aa7ac42df,
    0xbff351d8520faf57, 0x3fe4335789026d21,
    0xbfd449d258e91f5d, 0x3ff7158684ed3379,
    0xbfe0318248f7d8b2, 0x3fe7a59815326544,
    0x3fe5d874daa3b70f, 0x3fd999f708635f02,
    0xbfd9bbcc616883e0, 0x3ff13bc236d3a81a,
    0xbfe3fbb5312dc4ec, 0xbfdd9f3b2b71f07e,
    0x3f9ce395a776a000, 0xbfd223eb467fc37e,
    0x3fdbce4c9bb53d24, 0x3ff04087d482b112,
    0xbfa3c84515c611c0, 0x3fcff8d0054c2a76,
    0xbfe3c4f95aad0198, 0xbffca39649171000,
    0xbfe6638ba06e5fdf, 0x3fcafa530d5fbb82,
    0xbf936e775260ebc0, 0x3fbc44ff9d1d7586,
    0x3ff67bf9ad2bcee7, 0x3fba09302c678ce0,
    0xbf938e40f826cac0, 0x3ff47fa00e0ba7e4,
    0xbfbdd9ab17e43ed0, 0xbfe034b456ed435e,
    0x3fa1e5fe31940430, 0xbf93ba64b862a760,
    0x3ff7a903f86d4383, 0xbfdf1c932ee1e027,
    0xbfd55279fbf9d83e, 0x3fd7c81932aa438f,
    0x3fe0f4d76a620e31, 0x3fd1c2143c714ee8,
    0x3fd7fc73e2d236d4, 0xbfdeb29cb04b61b0,
    0xbffe910abc38cb8d, 0xbf9b7957a2f5d130,
    0x3fb22909bd202954, 0xbff465096b3a60a8,
    0xbff4138e6a50a5ae, 0x3fe20dece27c78b6,
    0x3fda0251a95eff9f, 0xbf89426375cf4690,
    0xbff5272c5d8fa1b7, 0xbff5f90c8f536fd3,
    0x3fdf9fa5a7136b87, 0xbfdfd4182f280772,
    0x3fec0cd17a864d7b, 0x3feb2334ffa596cb,
    0xbfce2d2b770b75ea, 0xbfd4cab0ea2226ed,
    0xbfe84370cc6c68a6, 0x3fc34cfd6f203974,
    0x3fd74407bc7c6a4a, 0x3fc5ce9e40e77e53,
    0x3ff1bfe8f988ea7c, 0xbfd4484058bcdfdd,
    0xbff9fb56116bf0cb, 0x3ff0063b71bb2c97,
    0x3fde962c044d8f2a, 0x3ffb3851c24ed1c1,
    0x3fb39202f883895c, 0xbfe42910ce030f59,
    0xbfd21795662e59fb, 0x3fdae8b3a852ef6d,
    0xbfd4adc27fd5b780, 0x3ff1e926744a8f72,
    0xbfb53aa28ef85848, 0x3fd1ac0521d0c8db,
    0x3fe3fa31c522384e, 0xbffa5ae52a6333f8,
    0x3ff0f3ab0220f420, 0x3fe947d381454338,
    0xbfde1b4410139129, 0x3ff815cf8b8f63fd,
    0x3fc46bb608f19bc2, 0x3fccda670e23e70b,
    0x3fdaa2715811bec8, 0x3ff0a3d5e3a4a1c4,
    0xbfe59d14adef7245, 0xbff6c9bfb09db078,
    0x3fcffd446d2d4832, 0xbfd3a683da0aa622,
    0x3fdd5ed05709ca79, 0x3fe04c2ab7af94bc,
    0x3fe0cd4b8476c7cc, 0x0,
    0x3fdd5ed05709ca74, 0xbfe04c2ab7af94b8,
    0x3fcffd446d2d482f, 0x3fd3a683da0aa626,
    0xbfe59d14adef7246, 0x3ff6c9bfb09db078,
    0x3fdaa2715811bec6, 0xbff0a3d5e3a4a1c2,
    0x3fc46bb608f19bc0, 0xbfccda670e23e708,
    0xbfde1b4410139123, 0xbff815cf8b8f63fc,
    0x3ff0f3ab0220f421, 0xbfe947d381454335,
    0x3fe3fa31c522384d, 0x3ffa5ae52a6333f9,
    0xbfb53aa28ef85860, 0xbfd1ac0521d0c8de,
    0xbfd4adc27fd5b780, 0xbff1e926744a8f73,
    0xbfd21795662e59fe, 0xbfdae8b3a852ef72,
    0x3fb39202f8838958, 0x3fe42910ce030f5c,
    0x3fde962c044d8f2c, 0xbffb3851c24ed1c1,
    0xbff9fb56116bf0ca, 0xbff0063b71bb2c97,
    0x3ff1bfe8f988ea7c, 0x3fd4484058bcdfdc,
    0x3fd74407bc7c6a48, 0xbfc5ce9e40e77e52,
    0xbfe84370cc6c68a6, 0xbfc34cfd6f20397c,
    0xbfce2d2b770b75e7, 0x3fd4cab0ea2226ef,
    0x3fec0cd17a864d7c, 0xbfeb2334ffa596ca,
    0x3fdf9fa5a7136b88, 0x3fdfd4182f280770,
    0xbff5272c5d8fa1b6, 0x3ff5f90c8f536fd2,
    0x3fda0251a95effa5, 0x3f89426375cf4600,
    0xbff4138e6a50a5ad, 0xbfe20dece27c78b5,
    0x3fb22909bd202958, 0x3ff465096b3a60a8,
    0xbffe910abc38cb8d, 0x3f9b7957a2f5d140,
    0x3fd7fc73e2d236d2, 0x3fdeb29cb04b61ad,
    0x3fe0f4d76a620e2e, 0xbfd1c2143c714eea,
    0xbfd55279fbf9d83c, 0xbfd7c81932aa4394,
    0x3ff7a903f86d4383, 0x3fdf1c932ee1e028,
    0x3fa1e5fe31940438, 0x3f93ba64b862a7a0,
    0xbfbdd9ab17e43ee0, 0x3fe034b456ed4360,
    0xbf938e40f826cab0, 0xbff47fa00e0ba7e4,
    0x3ff67bf9ad2bcee7, 0xbfba09302c678cf8,
    0xbf936e775260eb60, 0xbfbc44ff9d1d7582,
    0xbfe6638ba06e5fdc, 0xbfcafa530d5fbb8c,
    0xbfe3c4f95aad0196, 0x3ffca39649170ffe,
    0xbfa3c84515c611c0, 0xbfcff8d0054c2a71,
    0x3fdbce4c9bb53d22, 0xbff04087d482b111,
    0x3f9ce395a7769fa0, 0x3fd223eb467fc37a,
    0xbfe3fbb5312dc4ec, 0x3fdd9f3b2b71f080,
    0xbfd9bbcc616883e6, 0xbff13bc236d3a818,
    0x3fe5d874daa3b70d, 0xbfd999f708635f01,
    0xbfe0318248f7d8b3, 0xbfe7a59815326544,
    0xbfd449d258e91f60, 0xbff7158684ed3379,
    0xbff351d8520faf56, 0xbfe4335789026d1f,
    0xbfd5747a3432f9c5, 0x3ff6f76aa7ac42e0,
    0x3fb2be011c662f88, 0x3fcba270842843a8,
    0x3fdc3c1a9023252b, 0x3fcee8563e743c00,
    0xbfecc866514e956c, 0x3fb3d99766cab480,
    0xbfe32bebf51e9c25, 0xbfd4b67c7c8cc7ac,
    0xbfef9eb841d878f6, 0x3fc0879a65cdafdc,
    0x3fe42c407ee33963, 0x3ff7328b9611d503,
    0xbff366fe167bb5a6, 0xbfcc21244f285200,
    0x3fa2fbdcc60e7e70, 0xc00247aab465607b,
    0xbfea878c85da4722, 0xbfe0598af9d6e0ff,
    0xc0010d52412937e3, 0xbfa03946e2cadd40,
    0xbfe51b9cb0a24da0, 0x3fc97553764de91b,
    0x3fad9c1ca37bcc44, 0x3febc878ae7e9edc,
    0x3fe3a857e44957ca, 0x3fc3fb53eb87b004,
    0x3feaa7784101ed94, 0x3fc5eaaf5c9f560a,
    0xbfd2232534f5957b, 0x3fe9379e6aa990a2,
    0x3fc427338bce2926, 0x3ff2cc35108290bf,
    0xbff063d592874418, 0x3fc121ae72229190,
    0xbfd7989e6d379442, 0x3fe861ca44519e80,
    0x3fe7e80364052cfa, 0xbfb64ffd0ddb0860,
    0x3fe782ba0a5d1720, 0xbfc5cb0a96713ef8,
    0x3ff2114287dece62, 0xbfe48d4b5c509d57,
    0x3fec2b346bbbab70, 0x3ff3edc6c9e4e44b,
    0x4000bab9f6611179, 0xbff05a1a11a9ec7e,
    0xbfe479198cbd2c8c, 0xbfe4ac4c8934b2ba,
    0xbfe2515a817e28be, 0xbffccec251125a7e,
    0xbfb6aa23788e6364, 0xbffc14ec991e4231,
    0xbfe3e621fb28bcaa, 0xbfe154c7009f4f39,
    0xbff43a719819a1a6, 0xbfdaf2ec1b1a3ec0,
    0xbfd7363244f60e79, 0xbfcea365df4ba758,
    0x3fe589a8e1093dbc, 0x3fcdfd73e59b360f,
    0x3fed1df1dedee9bf, 0x3ff25996cf069ccf,
    0xbff37d2cbefe735f, 0x3fea218c34a05217,
    0xbfe0cb92b266552e, 0xbff50aa60b228a75,
    0x3fdfd118d3bdbea7, 0x3fe48719ab180a2a,
    0xbfd2b8ad8e03edcf, 0xbfcb59898983fc61,
    0xbff750182d545cf0, 0xbfd4d4a021b59b88,
    0x3fe4a97d9c8a68bf, 0x3fc92cd7c3e8bb05,
    0x3fe9be0768219904, 0x3fb4fc0420af8ed8,
    0xbfe2ae038a49ad1a, 0x3fbb3fae02dd227e,
    0x3fb20c620db4c84c, 0xbfc10d09ba033f80,
    0xbf78c7b592de9300, 0x3ff98222afe6b93f,
    0xbfe3e845412c61c8, 0x3fd168cbfaaa413a,
    0xbfe280b52ba67851, 0xbfb0efafec94c190,
    0xbfe56f03d5f11146, 0x3ff76a6d2928f316,
    0x3ff9e24f6e053308, 0xbfce1de6eaf08078,
    0xbfe8eda21f59209f, 0x3fb11331cfb732c0,
    0x3fc80bbdc129c618, 0x3fb799454e7e3038,
    0x3fe67e26a5c09434, 0xbff42db91c671c4d,
    0x3ff1feff646e75de, 0xbff8a85e1c15ed34,
    0x3fdb270b7ad6b27d, 0x3ff630f2786eb327,
    0x3fdfc1c93d7bb58a, 0xbff33d22e7850ef0,
    0xbfebf2c7296ca758, 0xbfea6f9075313dea,
    0xbff1511745685e08, 0x3fe3e3095ddf0ec8,
    0xbff5a2cfddafd5bb, 0xbff6e70a9d724552,
    0x3fddb1bba31a156e, 0xbfa470524037a678,
    0x3ff18eb244fc0ee4, 0x3fdaad2c71460752,
    0xbfe001fa224a554c, 0x3ffb5f8ba848895d,
    0x3fd113f3643b6023, 0x3fc7eebe982e3a06,
    0xbfce77da4472e9e6, 0x3fd5bc0202be57db,
    0xbfe03b1d306dafa3, 0x3ffdbedbdc0c5796,
    0xbfef2f70d47ccaf7, 0xbfe4bf489db1b710,
    0xbfdca66dba3702ec, 0xbfeb032611c67ecd,
    0x3fe64ceebec11ce5, 0xbff148dbfd188d5c,
    0x3fc83ff89546eb10, 0x3fb4ecdb3babab38,
    0xbff11955096a4ad6, 0xbfe379cf726ce0dc,
    0x3fec9e2ec46ad5f4, 0xbfb0ac9be34b94e9,
    0x3fe319b17b9d51a9, 0x3fc3bd91260634e6,
    0x3fc1009e4fb83088, 0xbfe68b993f7c60ed,
    0xbfd6c878e207393a, 0xbfdd13ec9d8e9389,
    0xbfb983d387dc1e3e, 0x3fe88fd92bd10c1d,
    0xbfd461372209693a, 0xbfbd7966b879765b,
    0xbff7843aaeda50aa, 0xbfe3f78f713f7558,
    0xbfc640b864b108c1, 0xbff65f4353619583,
    0x3ffa544bce815cc3, 0xbfcf7502baccdb18,
    0x3fe81d826b984515, 0x3fe080e4ca4fc526,
    0xbfea31cf9fd4e7cf, 0x3fe3a3e1de23e551,
    0x3fb38cde770db3aa, 0x3faeb6fdd59b6ff4,
    0xbfcac5b88fe1cda8, 0xbfd4f2d7dfec6b3f,
    0x3fd3bf4fb70ddf44, 0x3fc76d79d7a70398,
    0xbfee550e32cacdde, 0x3fd3bdefb6eecb1c,
    0xc002da8a3f632adf, 0x3f69e180a667fc80,
    0x3fdda0fb7e245fd7, 0x3fdef4fe5e5f49c0,
    0xbfe793590556a5b2, 0x3fe747a0d4fba490,
    0x3ff496787be022c8, 0xc00563aeebce2ddc,
    0xbff470c2c81d1efe, 0xbfe1fbba3906d048,
    0xbfe7ead5ed7d7239, 0xbfe524761b8818a7,
    0xbfd6e9cc3d1b165e, 0x3fcd3c75aa99fdbc,
    0x3fe1de57b53197de, 0xbfe0d08105339c43,
    0xbfdfd5d0691eddc8, 0xbff4756e760e951f,
    0x3ffa636695699954, 0x3fee3ed18f79c259,
    0xbfdcc936e7b1b20d, 0xbfe2d46b53f6f7f0,
    0x3fecf35f27fa19e0, 0x3ff478d87e1b838a,
    0x3fd13f89dfc92e7b, 0xbf879e4c7fa370e0,
    0xbfc0a0ceabd7a4d2, 0xbfc6d0857bf3f0e6,
    0x3fe41080ecc82271, 0xbfeac0c43791dadc,
    0xbfe157d34b966667, 0xbfb75be3562c078c,
    0xbfead803c61ac83f, 0xbfb1a503371dd5ee,
    0xbf9c3e81281b1540, 0x3fd019ba8bd9e410,
    0xbfb58fdc14d8a9f8, 0xbff06ab4f8b9b7d5,
    0xbfe200ea5f733a5a, 0xbfe4a008983ac136,
    0xbfbd1e6e36ce670c, 0x3f9313a878e7c760,
    0x3ff8b44af475802c, 0x3ff6e4d1869a505c,
    0xbff67e7f18beea15, 0xbfddd3a08e30e8b4,
    0x3fd961362cf9ab8d, 0x3fc56e84c2ac2120,
    0x3fe3b356945e03d4, 0xbfd6bfd1503b251e,
    0xbfeca0e866316172, 0x3fde2cb9c3390c6b,
    0x3fd25407d8329b9a, 0xbfecdec4372100bb,
    0xbfd4cab04ecb19ef, 0xbfd9eb7ba3800e93,
    0xbfe2633ed2f4d3c8, 0xbfdc64409ee3b320,
    0xbfa7d3fa2966dfc0, 0x3fd0d9a9ce70e4d0,
    0xbfe20ccaa9269929, 0x3fe2a6afa6d2886e,
    0xbfc2d0cb72b120d0, 0x3fec3d998b0495b2,
    0xbff0e392a89565f2, 0x3ffd8a4d08037dd3,
    0xbfd61094011465aa, 0xbff659e37e2c2a8b,
    0xbfed3471618e6346, 0x3fe9c02a5661a5ca,
    0x3ff41d953f8eacdb, 0xbfd08ee55f669e84,
    0xbff58dc5dde8f75c, 0xbffab564c39042d8,
    0x3fc8597f12bc5b6a, 0xbff44b75c81dc76d,
    0x3fe45828db0438f3, 0xc002b518e46153a9,
    0xbfe0a72e424135d4, 0xbfe9e4529022d472,
    0xbfebc7ec603720e6, 0xbfd4e22d6ff4cd50,
    0xbff81ea0a30f0188, 0xbfd1ed869e49ca1b,
    0x40020ad06679614b, 0x4000187f26917a4c,
    0x3fee53223169d2c6, 0x3fe8829d7033ae07,
    0x3ff8cbf43793d08a, 0xbfe032987fadd267,
    0xbfe612e7cad26e3b, 0x3fe191f664eb3dc4,
    0x3fef77d9b51a91f0, 0x3fe28a63ebd68d0b,
    0xbfd72be59cc45f46, 0x3fd7eacb13179f71,
    0xbfc90d7b7234e3e0, 0x3fad8dea8d032028,
    0x3fd8ace33fc428c2, 0x3fbc89e2b728a944,
    0x3fa12ae79ddd4870, 0x3fe12c70d3af6256,
    0xbfe9ca7c2085c91c, 0xbfe038a397183b0c,
    0x3fc9f565812c15a0, 0xbfe3e43880bf759c,
    0x3fe70d3f4b771363, 0x3fe2cdac8fe9044b,
    0xbfc0b0e4e8ec23ad, 0x3ff8df32b671ad21,
    0x3ff1ffb848ec9bf6, 0x3ff7edcc62819ed9,
    0x3fefcb57daf73e5e, 0xbff31541a5bd67d0,
    0x3fe2f51e06480ba6, 0x3fe4ae75cb172736,
    0xbfe1de24e8ed9f53, 0xbffb513a2f8d5697,
    0x3fb1d864b52bfdf8, 0xbfdbc0f47a4e7dd2,
    0x3fe0136521a64dc6, 0xbfc1079128bd9a0c,
    0x3fdb9e2cc79a4414, 0xbfe68af6c229c0af,
    0x3fdce9375692f4da, 0xbfda00c7edc128f3,
    0x3f9dd04c605d6140, 0x400185f0706bc100,
    0x3f9a68d5465f85b0, 0xbffd445c4ff69e16,
    0xbfcd2150937de3b8, 0x4066647a10be550a,
    0xbfe902635185b922, 0x3ff4479fff4ac05c,
    0x3fca166b07e118c6, 0x3fe1532ac7f7dc40,
    0xbfd5340c7e04bada, 0xbfc5caabbb9dabd6,
    0x3fd2f9f8aa50f040, 0x3fe3ec5f14a7309a,
    0xbfc8b6bdc6b94732, 0x3fef918be518846c,
    0xbfc34d9e868bde54, 0x3ff7a8492474859d,
    0x3fc6b9729f39f08a, 0xbfb7989e6defdcda,
    0x3fdcd9b0de2fc75a, 0x3ff7bae905df4c12,
    0x400006869fb6a968, 0xbfdcee65076f9baa,
    0xbfc2fbe64cfe3460, 0xbfa38ff82d765080,
    0xbff004c9c0fc6af1, 0xbfe0ff7ad9c831d7,
    0xbfecd18205210481, 0x3ff24c2ef909d3d1,
    0xbfb687ecbddd6ba4, 0xbf53a7c08893ba40,
    0xbfe142a64381bcb2, 0xbff62cce8adb5aa6,
    0x3fdd1bc2797198ef, 0xbfe3c9865d5f2c6c,
    0x3ff30557d129c58f, 0xbff5336b64aaa52c,
    0x3fd78a47a44f6eca, 0x3fe220fdb85c6c29,
    0xbff0d3e2dd289048, 0xbfe0c68fd1a2c768,
    0x3ff215fa9dc0cbef, 0xbff74d1250d9bd6e,
    0xbfc97de42e17c34e, 0x3fdfc9999416cc67,
    0x3ffef19eb0b8a925, 0x3fdaf23d231a0687,
    0x3ffd19b6bcdbdaf4, 0x3fe1cf53f73654bc,
    0xbfb374d66b90e3d2, 0xbfb6311c7675528c,
    0x3fcabd8bf756a15a, 0x3fe68c7fb1e25b37,
    0xbff385982e87f7b2, 0xbfdcdd16ff0efa52,
    0x3fcc27570b095c04, 0xbfc8afa99fbff864,
    0x3ff1af5911da8146, 0x3fc0188fc6d7ff72,
    0xbfcc82b50d3e9556, 0xbfb0aa8ac72de558,
    0xbfe6b3bef1dca815, 0x3fe707441e462406,
    0x3ff7b33c65841855, 0xbfc88c5cb07c1893,
    0xbfd7ac2047dcf960, 0xbfec5d6ff557173c,
    0xbfe2ed8d20f72bdf, 0xbfdc0540a88f716b,
    0x3feeab5cc2559888, 0x3ff41dd3b9235c6e,
    0xbfd0a110f60b1e40, 0xbff590fb8c8388ba,
    0xbfed9a0c5242f95e, 0xbfd85b2b6175afe9,
    0x3fe3d55155486b3c, 0x3ff4b24c22aff828,
    0xbfe8c9c9ce1713d9, 0xbf6bbd395fd379c0,
    0x3fdd95b30d9a81e8, 0x3f96ebee138e5e60,
    0x3fef31f3901d963e, 0xbfed039e4e5f4be6,
    0xbfd56a49d448467b, 0xbfd206c7fc34a852,
    0xbfe363fb5aeaf0e8, 0x3fc94d33257f7c9a,
    0xbfb9c4292582371c, 0xbfcafd0a49e1a3cf,
    0x3fc19ffec8b34950, 0x3fdf139dc2644127,
    0x3fe458af435e5b4a, 0xbfb0a7095893a128,
    0x3fe03d6fe0daa821, 0x3fe5888405a43565,
    0x3fd5a9301acf13c1, 0x3fa3af4c5e27bee8,
    0xbff733a1d52016bb, 0xbffb12d2ed0bf302,
    0xbfcbaaf2b1623f6d, 0x3fc04b5c5a9fe49b,
    0xbfc45053709c640c, 0x3fdc0542cae05427,
    0xc0015d20162817e6, 0x3ff68dd41116009b,
    0xbfb83f3c57110948, 0xbfea5d1d9d6e2562,
    0xbfb7cd244d00051a, 0xbfc2123919f18894,
    0xbfd47491f5117131, 0x3fd2cfb8244de867,
    0xbfec3a1529f14598, 0xbfdd0ddf1d59c2be,
    0xbff447b0fbbb8302, 0x3faf546edcbe2172,
    0xbfe1561f88dafa7c, 0xbfe3f869ae791f24,
    0x3ff39c753ec521f6, 0x3fe2e4010ff81afc,
    0xbfdbd015c77a3f4b, 0x3ff0d6788f088b57,
    0xbfaa42e84179d800, 0xbfd5b89c458ae4c6,
    0xbfeddc2b4a40932a, 0xbfe919c475784088,
    0x3fe030f26390b3c7, 0x3fea179f712598e3,
    0xbfe75925b7449500, 0xbfd961ca943ef88e,
    0xbfc199602539f3b2, 0x3fed0f7370e4a318
    };

static const uint64_t in_cfft_noisy_1024[2048] = {
    0xbf9ad4f03fc385ac, 0x0,
    0x3fe16029b61f75d3, 0x0,
    0x3fe81d1110c8e626, 0x0,
    0x3fe01abc1e02216e, 0x0,
    0x3fa0b6a3c49caec4, 0x0,
    0xbfe139885a941f88, 0x0,
    0xbfe4537612a1b8fe, 0x0,
    0xbfddfd99620dbc54, 0x0,
    0x3f8bd1dbeb67886d, 0x0,
    0x3fdf55bbfd32dd22, 0x0,
    0x3fe5c562a11eef68, 0x0,
    0x3fdcf6d08abaea46, 0x0,
    0x3fa1d99f4e3ea089, 0x0,
    0xbfe00e01966be78d, 0x0,
    0xbfe6e50768bdfaa1, 0x0,
    0xbfdb35be0b6db78b, 0x0,
    0xbf96e0b1eae412ec, 0x0,
    0x3fe0ed8056c6e364, 0x0,
    0x3fe538536acda833, 0x0,
    0x3fde3b835e57689e, 0x0,
    0xbfa44406f8494c16, 0x0,
    0xbfe00119319b77ad, 0x0,
    0xbfe52f4dbe1c81f4, 0x0,
    0xbfe04e8be3d8dea5, 0x0,
    0xbfa8ebffb6a45250, 0x0,
    0x3fdc79cd4b065f46, 0x0,
    0x3fea1b155bbbcda0, 0x0,
    0x3fe0410ef4c9742d, 0x0,
    0xbf9f87eeebf2889b, 0x0,
    0xbfe06883f03bc2d4, 0x0,
    0xbfe8a70d7cf637c0, 0x0,
    0xbfe00b0ff85e77c1, 0x0,
    0xbf6a47a5f1f0d074, 0x0,
    0x3fdd458afcba2cc5, 0x0,
    0x3fe7d597f19a9866, 0x0,
    0x3fde7096cdb7b780, 0x0,
    0x3fa457a974052f66, 0x0,
    0xbfe184d7d1c5fb13, 0x0,
    0xbfe397ebaf6ee34c, 0x0,
    0xbfdd576345746d5b, 0x0,
    0xbfb253b7ec2c2e8a, 0x0,
    0x3fe02516cf114bca, 0x0,
    0x3fe959e7ea6cf12c, 0x0,
    0x3fde9a2704651096, 0x0,
    0x3fb146e763e5d9b0, 0x0,
    0xbfdbb983a2635fff, 0x0,
    0xbfe6032b75e4a1ba, 0x0,
    0xbfe13d9b4baa535f, 0x0,
    0xbfa57a07bee22988, 0x0,
    0x3fdf603664dfc23d, 0x0,
    0x3fe77891029bdb6b, 0x0,
    0x3fe0578756a38bfe, 0x0,
    0x3fa4139c55e35dff, 0x0,
    0xbfdd30f0e8b4151e, 0x0,
    0xbfe5dc11900517fd, 0x0,
    0xbfe0be21d737414e, 0x0,
    0xbf6ead5cda87c05e, 0x0,
    0x3fe16b4dbf73234c, 0x0,
    0x3fe77555cdd2167b, 0x0,
    0x3fddce6b7db8ec42, 0x0,
    0xbf9abc64a88af249, 0x0,
    0xbfe1c3b79fb61032, 0x0,
    0xbfe4b2492a0268df, 0x0,
    0xbfdf59d23151a8f9, 0x0,
    0xbfa1cbd1067230e4, 0x0,
    0x3fdd85fa568fa321, 0x0,
    0x3fe6b6d83fa67095, 0x0,
    0x3fe316e8fcbed6d6, 0x0,
    0xbfa477ef0c281857, 0x0,
    0xbfde2eee9500d629, 0x0,
    0xbfe6154394008930, 0x0,
    0xbfe4f28ef06dbd44, 0x0,
    0xbfadb7c569f6ed48, 0x0,
    0x3fdff77060c4ed12, 0x0,
    0x3fe7e25d8e74cae4, 0x0,
    0x3fe3621e59a825d0, 0x0,
    0xbfa7c17b82fd1073, 0x0,
    0xbfe2d0377609520a, 0x0,
    0xbfe698623cb2a19a, 0x0,
    0xbfdd6679080ee3d2, 0x0,
    0x3f8dbdb292be14e8, 0x0,
    0x3fdb536ee0fa0573, 0x0,
    0x3fe6072bd642b237, 0x0,
    0x3fdca4b95cd8a135, 0x0,
    0xbfb48f35bf206bad, 0x0,
    0xbfdf38cf80f82262, 0x0,
    0xbfe5b90674deb914, 0x0,
    0xbfe10cf6399fcd8c, 0x0,
    0x3f7730587f04906c, 0x0,
    0x3fdcefb2d364aa06, 0x0,
    0x3fe53fa8bf132e66, 0x0,
    0x3fe183f8a47ab00e, 0x0,
    0x3fae0d3d33955195, 0x0,
    0xbfdd527b15eaa2ad, 0x0,
    0xbfe640657d3e357c, 0x0,
    0xbfd8dcaf637da057, 0x0,
    0x3fa12929a162492f, 0x0,
    0x3fe0c12c12967f08, 0x0,
    0x3fe6dcef0b562e40, 0x0,
    0x3fe1478122cc4178, 0x0,
    0x3fb2d23cf9d36835, 0x0,
    0xbfdb5bed42c86172, 0x0,
    0xbfe5a34f7b539434, 0x0,
    0xbfe1bce54c75dd75, 0x0,
    0x3f9b57e2c4cf7eee, 0x0,
    0x3fe0cd697c6500e5, 0x0,
    0x3fe4206396d34689, 0x0,
    0x3fde1e37737ae155, 0x0,
    0x3f80a8e325d74d49, 0x0,
    0xbfde43b289f11673, 0x0,
    0xbfe805eff48e3e97, 0x0,
    0xbfe0d776eefbf384, 0x0,
    0x3fa0ff6fb8fc638f, 0x0,
    0x3fdbb578fd3f595c, 0x0,
    0x3fe88d18e19b3154, 0x0,
    0x3fdd1bc597c4edc5, 0x0,
    0xbfa43f66b0279d10, 0x0,
    0xbfe248a5186094f1, 0x0,
    0xbfe562d2ad06d3ef, 0x0,
    0xbfe10b9e0697ce40, 0x0,
    0x3f90a147aa242d49, 0x0,
    0x3fdd3078e7fa475a, 0x0,
    0x3fe0c7f432234621, 0x0,
    0x3fdd37ee7c2249d6, 0x0,
    0x3faf5c91c4ee7434, 0x0,
    0xbfe0ea53068a0d97, 0x0,
    0xbfe836e77000cdf2, 0x0,
    0xbfdd48fa6bfa969d, 0x0,
    0xbf81f049905d9e1d, 0x0,
    0x3fdfb5dd7d97a7ed, 0x0,
    0x3fea09c106d76fe3, 0x0,
    0x3fe20381b604ef3b, 0x0,
    0xbfad600623656083, 0x0,
    0xbfde6dc138a66e98, 0x0,
    0xbfe888bbbdd23167, 0x0,
    0xbfd9b884df6d4746, 0x0,
    0x3f91ddea33e9b646, 0x0,
    0x3fdf24083bd8e87d, 0x0,
    0x3fe5f2d68a4bd2d5, 0x0,
    0x3fdd93ac5122655d, 0x0,
    0x3fae27b062592b87, 0x0,
    0xbfe0fd07e3e4e649, 0x0,
    0xbfe4d08f325eabe6, 0x0,
    0xbfdf948a5a51b028, 0x0,
    0xbf813f1fcbf63622, 0x0,
    0x3fe10c0e364ecc90, 0x0,
    0x3fe466478930d506, 0x0,
    0x3fe04ff76f7a91a2, 0x0,
    0xbfb82cc4843b9524, 0x0,
    0xbfdd455cfadd409a, 0x0,
    0xbfe4a35d201c917f, 0x0,
    0xbfdc7b994f908b80, 0x0,
    0x3f86edf2aa4a44b7, 0x0,
    0x3fdd543252ea6bef, 0x0,
    0x3fe60bbb68e5cbdf, 0x0,
    0x3fe2ea273718742a, 0x0,
    0x3fb0cc90d11d71d3, 0x0,
    0xbfe065b39f39b459, 0x0,
    0xbfe6c61e18052434, 0x0,
    0xbfe1bab94cc98906, 0x0,
    0x3fb3ec6129d09d73, 0x0,
    0x3fdaa01ab0ec2948, 0x0,
    0x3fe830807ca7da0b, 0x0,
    0x3fe2ce3f4a97c91f, 0x0,
    0xbfb81ded4c837d8e, 0x0,
    0xbfe0771a1ca049f5, 0x0,
    0xbfe7847ac53d6248, 0x0,
    0xbfdaf6b942585efb, 0x0,
    0x3fb10e3121f30443, 0x0,
    0x3fe00ab786364731, 0x0,
    0x3fe96672da37bbb9, 0x0,
    0x3fe1539c656728cc, 0x0,
    0xbfb50c0f0ec77b29, 0x0,
    0xbfe01ebba99158ba, 0x0,
    0xbfe5b6a065a74b7c, 0x0,
    0xbfdff7b361b9b839, 0x0,
    0x3fba52622b471db7, 0x0,
    0x3fe47731c4bd9a6d, 0x0,
    0x3fe648fd61abe5ce, 0x0,
    0x3fdc528c790dcfa6, 0x0,
    0xbfa9091c327a6b5e, 0x0,
    0xbfe20c49bf1aae3e, 0x0,
    0xbfe6a3bfdc0502f5, 0x0,
    0xbfe0eb35061d5672, 0x0,
    0x3fc010ab5af2627b, 0x0,
    0x3fdf9fa20b218c31, 0x0,
    0x3fe6aa7679229581, 0x0,
    0x3fdfe43d9588721f, 0x0,
    0x3f418e6e9a646468, 0x0,
    0xbfde4541161c631c, 0x0,
    0xbfe68cef07c00868, 0x0,
    0xbfe00b337f5af8de, 0x0,
    0xbf90ea036cfff6bf, 0x0,
    0x3fe129ce125c8e08, 0x0,
    0x3fe5855bc08fe8a3, 0x0,
    0x3fe09fa3bd0e94d0, 0x0,
    0x3fb76cf545e79eb2, 0x0,
    0xbfe08e91ab14b136, 0x0,
    0xbfe79635d7587d66, 0x0,
    0xbfdd274c8fbbe69b, 0x0,
    0xbf81e8aa334c428b, 0x0,
    0x3fe226735fe1d5a7, 0x0,
    0x3fe64c8776cef2c5, 0x0,
    0x3fe0b731d5eaddab, 0x0,
    0xbfb5d6d94929c325, 0x0,
    0xbfdaf352f9000ad0, 0x0,
    0xbfe7859d85331c3b, 0x0,
    0xbfda0dc05581203e, 0x0,
    0x3fac2642c83ebe84, 0x0,
    0x3fe200994612b2ed, 0x0,
    0x3fe6c078cf0d3f25, 0x0,
    0x3fe1de3fa06366ac, 0x0,
    0xbf6babe2bc2f272f, 0x0,
    0xbfe13badbf20f0e3, 0x0,
    0xbfe3daeb0c6d7aa7, 0x0,
    0xbfe0f587664dfe8a, 0x0,
    0xbfc173bdb538b570, 0x0,
    0x3fe21b8f2c919fc2, 0x0,
    0x3fe623a9e289c1c6, 0x0,
    0x3fdcdfe00e54ee3c, 0x0,
    0xbfaf0ef5a4c188f8, 0x0,
    0xbfe061a121960d23, 0x0,
    0xbfe4f23a82f521f9, 0x0,
    0xbfe458b41d249f74, 0x0,
    0x3f7bd4173eae0081, 0x0,
    0x3fddffa268269ba9, 0x0,
    0x3fe484f3062b6cad, 0x0,
    0x3fe2f46c02ea1eed, 0x0,
    0xbf9d7c388818ba86, 0x0,
    0xbfdd52210841d956, 0x0,
    0xbfe73462637a6289, 0x0,
    0xbfdb636d2f48d4e3, 0x0,
    0xbfb2539965e9e361, 0x0,
    0x3fdf0c840ee8b4ba, 0x0,
    0x3fe7df04ff044dfd, 0x0,
    0x3fdf58ad5b84ceaf, 0x0,
    0xbf6433c6f8b1ddd4, 0x0,
    0xbfe031f345a5d4e7, 0x0,
    0xbfe51eb693bc3ca9, 0x0,
    0xbfddcfe10ffae31f, 0x0,
    0xbfab73bf3c9cd64b, 0x0,
    0x3fddd8544f9b3b80, 0x0,
    0x3fe45057dfcf2031, 0x0,
    0x3fe02723ab02cd35, 0x0,
    0x3fa8c73ee30c4e63, 0x0,
    0xbfe214183e4e3f74, 0x0,
    0xbfe82528b82abc87, 0x0,
    0xbfdc6b4d25268cb6, 0x0,
    0x3fac36907057bc71, 0x0,
    0x3fdccc35203e1585, 0x0,
    0x3fe71f037f5eb5f4, 0x0,
    0x3fdb0921f8482a27, 0x0,
    0xbfa84052b2badce2, 0x0,
    0xbfdf37bbbf3eba5e, 0x0,
    0xbfe74d4510a07c1d, 0x0,
    0xbfddb643720ddaf8, 0x0,
    0xbf78cc89b8424aa0, 0x0,
    0x3fdf44e5279b2e92, 0x0,
    0x3fe6b69049eaaa14, 0x0,
    0x3fdc8536e0b5be10, 0x0,
    0xbf8075c2dd698cb6, 0x0,
    0xbfde2c60c9df5ff0, 0x0,
    0xbfe61d9d3254a31c, 0x0,
    0xbfdebdac2507672e, 0x0,
    0x3f835a4c9380b599, 0x0,
    0x3fe275825f7955f2, 0x0,
    0x3fe5cd507713d8ac, 0x0,
    0x3fdedc6184650bff, 0x0,
    0xbf9d443e8bce3cc1, 0x0,
    0xbfde8b83ef256028, 0x0,
    0xbfe419a35d37860a, 0x0,
    0xbfdb07e5167ccbae, 0x0,
    0x3fa5ab2374dc3ce0, 0x0,
    0x3fe48b6c279efd36, 0x0,
    0x3fe267307881053a, 0x0,
    0x3fdd816c9b009306, 0x0,
    0x3f9bf22f0ca1eae3, 0x0,
    0xbfe09a1e53ec09a7, 0x0,
    0xbfe5b6f92c481c68, 0x0,
    0xbfe0a270743a7243, 0x0,
    0xbfa073fb52a2fcf5, 0x0,
    0x3fddd03b697f1995, 0x0,
    0x3fe830671c421d69, 0x0,
    0x3fe0ae5536a69ec6, 0x0,
    0x3fa219cac9611c72, 0x0,
    0xbfe18ffb6942fc11, 0x0,
    0xbfe28a7d0564e846, 0x0,
    0xbfdc669aa90bebe0, 0x0,
    0x3f8e92152437932a, 0x0,
    0x3fe10a0a75361d73, 0x0,
    0x3fe5e87b7a45f125, 0x0,
    0x3fdfcf8a6f3462b6, 0x0,
    0xbfb291c446881f34, 0x0,
    0xbfdd10aaaec4987c, 0x0,
    0xbfe6e147bb355368, 0x0,
    0xbfe062f136343a82, 0x0,
    0x3fa51ddcbe4dd197, 0x0,
    0x3fe26797d58c5d76, 0x0,
    0x3fe85ec8d46e6289, 0x0,
    0x3fdd131ed553de24, 0x0,
    0xbf9e80cae9583052, 0x0,
    0xbfddd0390ba02fbc, 0x0,
    0xbfe8048be1cce524, 0x0,
    0xbfdd4e668a4fb88d, 0x0,
    0x3f9241cc6906cac1, 0x0,
    0x3fe16e012390a768, 0x0,
    0x3fe312c927cc0a9d, 0x0,
    0x3fddd7ca8bf71292, 0x0,
    0x3fa52c1dbfc48753, 0x0,
    0xbfde9e93f1be9efc, 0x0,
    0xbfe890302327bb79, 0x0,
    0xbfe0e0a0c48d940d, 0x0,
    0x3f88128d42a2c71f, 0x0,
    0x3fe017c297eeb093, 0x0,
    0x3fe55538511ea14b, 0x0,
    0x3fe32b93085ac709, 0x0,
    0x3fa17eb461559850, 0x0,
    0xbfe041bf438c56e2, 0x0,
    0xbfe6b7bd008e6d5a, 0x0,
    0xbfe013d488bcdcd4, 0x0,
    0x3faba6129924ad51, 0x0,
    0x3fe155a3595a1833, 0x0,
    0x3fe8cce2cd7b6e1c, 0x0,
    0x3fdf8346e111ec00, 0x0,
    0x3fba10d7339a8aca, 0x0,
    0xbfe154da66a07622, 0x0,
    0xbfe5d3a59934773d, 0x0,
    0xbfe25ec61603be21, 0x0,
    0xbfaca3de45ab334d, 0x0,
    0x3fd9524c374037a4, 0x0,
    0x3fe6e0832ec6d7f4, 0x0,
    0x3fddc78a2557d52e, 0x0,
    0xbf959c58ecb89c7e, 0x0,
    0xbfdb622b6a13e74f, 0x0,
    0xbfe3a010a953e356, 0x0,
    0xbfd95d2e382a32b6, 0x0,
    0xbfb58bf90c834bed, 0x0,
    0x3fdec109c6aab888, 0x0,
    0x3fe5daefd8b588bb, 0x0,
    0x3fde741fee2ffef7, 0x0,
    0xbfabfe23d0b837e3, 0x0,
    0xbfe1d002af2c033b, 0x0,
    0xbfe4f6dae67038f3, 0x0,
    0xbfe0c1426df2deec, 0x0,
    0x3fa7bb235d526a96, 0x0,
    0x3fe1bbf07b329648, 0x0,
    0x3fe701d3dba23193, 0x0,
    0x3fddf3db250d8cf7, 0x0,
    0x3facb4b3417e70c7, 0x0,
    0xbfdff6f4b956e36c, 0x0,
    0xbfe5a9d717662a26, 0x0,
    0xbfe1a9530f57d59e, 0x0,
    0xbfa5197b49248dd6, 0x0,
    0x3fe058f22e9ff07d, 0x0,
    0x3fe2a964eda68d24, 0x0,
    0x3fe10ce9de917a2f, 0x0,
    0xbf750350b47af7c0, 0x0,
    0xbfdd0b67ecb680bd, 0x0,
    0xbfe3d94ff2480212, 0x0,
    0xbfdd15c2d8011e3c, 0x0,
    0x3fad02ab5fdc67ad, 0x0,
    0x3fdde8a8781ab306, 0x0,
    0x3fe5303dcd9548f6, 0x0,
    0x3fdafb31b31081bc, 0x0,
    0x3f81ca23d551f147, 0x0,
    0xbfe15bc328c54016, 0x0,
    0xbfe3caf756e1aaba, 0x0,
    0xbfdaafea18c529cc, 0x0,
    0xbf94d5e745f7b47c, 0x0,
    0x3fe244dd38808f69, 0x0,
    0x3fe545294d2bb22f, 0x0,
    0x3fdeb71e27b270a1, 0x0,
    0xbf63bb01b1037241, 0x0,
    0xbfdfc42763262dcd, 0x0,
    0xbfe5c2f0d8da46b1, 0x0,
    0xbfde653cc3885a1a, 0x0,
    0xbfb3a4a340b26a97, 0x0,
    0x3fe117fb19ed8091, 0x0,
    0x3fe6a14942781def, 0x0,
    0x3fe271c8fcbd817b, 0x0,
    0x3f7bc72d933a3763, 0x0,
    0xbfe19ffede8c4a2c, 0x0,
    0xbfe639a5a93396c7, 0x0,
    0xbfe09395bf45ca11, 0x0,
    0xbfb47fc4e3807513, 0x0,
    0x3fe2367d57c4cb50, 0x0,
    0x3fe3777a73bf32c9, 0x0,
    0x3fe214cd7cdf1b79, 0x0,
    0x3fb24a67f71e8398, 0x0,
    0xbfde0fb36c873964, 0x0,
    0xbfe6bdaafb3a18d1, 0x0,
    0xbfde1ccd720ca4f1, 0x0,
    0xbfa490974de2b6eb, 0x0,
    0x3fdc4643a977df3a, 0x0,
    0x3fe6fc86d03bd144, 0x0,
    0x3fe2163e0f100368, 0x0,
    0xbf9cf86caa43e4f5, 0x0,
    0xbfe174e7f7bb0053, 0x0,
    0xbfe6a64ff3ed4038, 0x0,
    0xbfdcd84048ea30e7, 0x0,
    0xbfb4a267daa3473a, 0x0,
    0x3fe0fa4428237288, 0x0,
    0x3fe67657fcf02e63, 0x0,
    0x3fdd69964eb79854, 0x0,
    0xbfa6e681121945d9, 0x0,
    0xbfe3d1c8e2d50a35, 0x0,
    0xbfe70d074aaa9a2f, 0x0,
    0xbfdc8358cd4007e6, 0x0,
    0x3f84a024fc07155c, 0x0,
    0x3fd96c590b176eca, 0x0,
    0x3fe7a0cfd40aef61, 0x0,
    0x3fe03f7c414654cc, 0x0,
    0x3fb79b22f38aeafe, 0x0,
    0xbfe1facfd557684d, 0x0,
    0xbfe6eb369f8a31d5, 0x0,
    0xbfde8798417e1a53, 0x0,
    0x3fa68f54467cdcd6, 0x0,
    0x3fde239f5728732f, 0x0,
    0x3fe5a57e6a9e5753, 0x0,
    0x3fe1110f08ea3c9b, 0x0,
    0xbfa30d3002926b8e, 0x0,
    0xbfdd11a31560f855, 0x0,
    0xbfe69a9917b5a8ac, 0x0,
    0xbfe1098d1408a22d, 0x0,
    0xbf53985fa383e49c, 0x0,
    0x3fe1f3f4ef99a5b9, 0x0,
    0x3fe460134919f2a4, 0x0,
    0x3fdb20dbd95d8209, 0x0,
    0xbf9f08ff1dd94aeb, 0x0,
    0xbfdc08a9cad52d0e, 0x0,
    0xbfe918cdde209a91, 0x0,
    0xbfde4bd1cee4aa3a, 0x0,
    0xbfa6f60174b7fe54, 0x0,
    0x3fe23d36a220f401, 0x0,
    0x3fe73e5526800053, 0x0,
    0x3fe0bdf516db50aa, 0x0,
    0xbfaef87aab93c386, 0x0,
    0xbfdccdef180713c1, 0x0,
    0xbfe7a5224d4965bb, 0x0,
    0xbfe041ac4cd81645, 0x0,
    0x3f870d121bb2b99e, 0x0,
    0x3fe37e8d707c0008, 0x0,
    0x3fe5f1109d76ad5b, 0x0,
    0x3fdcaf9246ee4801, 0x0,
    0x3f855db3ed8ca1c4, 0x0,
    0xbfde04af77bc2b4d, 0x0,
    0xbfe38717fdbc292a, 0x0,
    0xbfd9fad82027fbd2, 0x0,
    0xbf8a27bdfd48f2ac, 0x0,
    0x3fe0c8753fefe00e, 0x0,
    0x3fe76fb652dee5f4, 0x0,
    0x3fdb67818b018554, 0x0,
    0x3f9d266bd22f5e22, 0x0,
    0xbfe2bd4923d8d7f1, 0x0,
    0xbfe63779de8e6935, 0x0,
    0xbfdfabbb6b26f34d, 0x0,
    0xbf73e6c3bea9b40e, 0x0,
    0x3fdee7a170db726d, 0x0,
    0x3fe475bf47783873, 0x0,
    0x3fde848082f0da5d, 0x0,
    0xbf9559dee52f4ac5, 0x0,
    0xbfe16ad9ad71a83d, 0x0,
    0xbfe6e5781a22d036, 0x0,
    0xbfdf1e379887a633, 0x0,
    0x3fa78dc5573cb0b4, 0x0,
    0x3fe2a25e8adaa422, 0x0,
    0x3fe7e3bf49f44818, 0x0,
    0x3fe0069899dd0074, 0x0,
    0xbfa4f41f993f5ca2, 0x0,
    0xbfdf87809fb70dbf, 0x0,
    0xbfe772002f99bbbc, 0x0,
    0xbfe3b4047f2b4b06, 0x0,
    0xbfaad6b74b8459f6, 0x0,
    0x3fe0cb7814d2f4ab, 0x0,
    0x3fe334b502302661, 0x0,
    0x3fdcd6c9c0cd697a, 0x0,
    0xbf80bdad14284a59, 0x0,
    0xbfdee5e2d7068992, 0x0,
    0xbfe7fb19a10ba6e7, 0x0,
    0xbfe12e9cd5eea653, 0x0,
    0xbfc07398d0ed6369, 0x0,
    0x3fded9b99043039c, 0x0,
    0x3fe72875012b01a8, 0x0,
    0x3fde5d979847da5b, 0x0,
    0x3f8d4411042fb365, 0x0,
    0xbfdd770275cb459b, 0x0,
    0xbfe6650e8428e3e6, 0x0,
    0xbfdee53967387413, 0x0,
    0x3fa963aaf4bb308b, 0x0,
    0x3fe0f894288dffd1, 0x0,
    0x3fe817fa004cc0a7, 0x0,
    0x3fe14bab682702c8, 0x0,
    0xbfb45a7398e522e9, 0x0,
    0xbfddf0334d7c331c, 0x0,
    0xbfe37b005c6f3582, 0x0,
    0xbfdc855f792fd6e0, 0x0,
    0x3f9544be23a4b4eb, 0x0,
    0x3fdca8ad331f4a92, 0x0,
    0x3fe576e94be48d7f, 0x0,
    0x3fe1c19e6aa04bbe, 0x0,
    0x3fac14027c6395b7, 0x0,
    0xbfe0c2858e1cee6d, 0x0,
    0xbfe8bad6e5bd0df3, 0x0,
    0xbfddb8ba2a98fcc9, 0x0,
    0xbfb3662078e0369c, 0x0,
    0x3fdc5977b7748e94, 0x0,
    0x3fe5de90b10354c6, 0x0,
    0x3fe06a2d9d0230ed, 0x0,
    0xbfa8bfd28ab69e9a, 0x0,
    0xbfde16f93f4dcb8a, 0x0,
    0xbfe83db9de976816, 0x0,
    0xbfddd855dafa501a, 0x0,
    0x3fac02c3f8dfabab, 0x0,
    0x3fdd33495cbe95c6, 0x0,
    0x3fe48ac4c9106681, 0x0,
    0x3fe0f5a685c1c725, 0x0,
    0xbf8fb070bfbfc916, 0x0,
    0xbfddb4053e1fa453, 0x0,
    0xbfe6bf62cead71cb, 0x0,
    0xbfdf3dde12dffe14, 0x0,
    0x3f5eecbea3ccc4f0, 0x0,
    0x3fdc3e3bd541e059, 0x0,
    0x3fe654b21aa140e2, 0x0,
    0x3fdfb977fe4bef59, 0x0,
    0x3fb05a35edfd484d, 0x0,
    0xbfdad601ab005841, 0x0,
    0xbfe55058aab78125, 0x0,
    0xbfdbbca81b461742, 0x0,
    0x3f8299f5ce848bf5, 0x0,
    0x3fe3546932ebd689, 0x0,
    0x3fe7302689c9e1d4, 0x0,
    0x3fdd1b81531830e7, 0x0,
    0xbf9d1747f60926db, 0x0,
    0xbfdbd59de42ed6b5, 0x0,
    0xbfe6c697b61a34fb, 0x0,
    0xbfdfee72878220b3, 0x0,
    0x3fb55d5ce1f0d39b, 0x0,
    0x3fdfae63829093a7, 0x0,
    0x3fe75b8a010fdfb2, 0x0,
    0x3fde40886ecbad13, 0x0,
    0x3f9e8f457a24cccf, 0x0,
    0xbfe26260ab9b75d9, 0x0,
    0xbfe77e8b36dbb975, 0x0,
    0xbfe01237bc8666d4, 0x0,
    0xbfaa1d62b022bba2, 0x0,
    0x3fe081cd75efd839, 0x0,
    0x3fe4bc493461346c, 0x0,
    0x3fe10362a98f3687, 0x0,
    0xbfa3984071b846d2, 0x0,
    0xbfe009665144d453, 0x0,
    0xbfe448fc5d5f9c48, 0x0,
    0xbfe02254330b0a7a, 0x0,
    0xbf904ebc966403ff, 0x0,
    0x3fdbe15f7265e578, 0x0,
    0x3fe6322eb11419b0, 0x0,
    0x3fe052a0493985f2, 0x0,
    0x3fa4eee4ea219ec1, 0x0,
    0xbfe1ed301c337445, 0x0,
    0xbfe5a13d2248e507, 0x0,
    0xbfdf39586c907a3d, 0x0,
    0x3f77cd23a6dfca02, 0x0,
    0x3fdfc098080424c8, 0x0,
    0x3fe5c91238f6fd04, 0x0,
    0x3fe02e2798d85e41, 0x0,
    0xbfbc93b0a934efdd, 0x0,
    0xbfda5eefc723a024, 0x0,
    0xbfe407395ebde075, 0x0,
    0xbfe02831eff01685, 0x0,
    0x3fa0ded275278905, 0x0,
    0x3fdb59fdcc139c57, 0x0,
    0x3fe637dba93c52ce, 0x0,
    0x3fe272c65ec5f207, 0x0,
    0xbfa53725fef78ffa, 0x0,
    0xbfdb2895206ef67b, 0x0,
    0xbfe5c2eaa013f5e9, 0x0,
    0xbfe13f0fbbffbebb, 0x0,
    0x3fa5df9c3f6ea498, 0x0,
    0x3fddd48b0d3cac84, 0x0,
    0x3fe79dcd21310cea, 0x0,
    0x3fe236dc939fb9f7, 0x0,
    0xbf9ec6f03d74e10b, 0x0,
    0xbfdf1af1d87b6479, 0x0,
    0xbfe6bf4f2dc6856a, 0x0,
    0xbfe1a2aa9e307df3, 0x0,
    0xbfa0b4718a6b8ee2, 0x0,
    0x3fdb44529d6f6244, 0x0,
    0x3fe5775f2ee9e354, 0x0,
    0x3fdd0952dced275a, 0x0,
    0x3f19263d8ec4f63a, 0x0,
    0xbfe233b86b866357, 0x0,
    0xbfe7caf021d2de6e, 0x0,
    0xbfe1c65785942352, 0x0,
    0x3f9ce425453327d1, 0x0,
    0x3fdce8838531c764, 0x0,
    0x3fe1a0de76fa8623, 0x0,
    0x3fdf3ed556d261d6, 0x0,
    0x3f7b693473bb315f, 0x0,
    0xbfdf6f0b1ec6a4f7, 0x0,
    0xbfe47d83e2c31d49, 0x0,
    0xbfe04ea4c6c1dbe6, 0x0,
    0x3faee8ba6109a4dd, 0x0,
    0x3fdd8be3a75e5818, 0x0,
    0x3fe80907d0ad2869, 0x0,
    0x3fe0b809349f2356, 0x0,
    0xbfa60db920984fea, 0x0,
    0xbfe2c248a412982e, 0x0,
    0xbfe57609e8283595, 0x0,
    0xbfe1d56f32479698, 0x0,
    0x3fbe3372d2938c5f, 0x0,
    0x3fda2fad07cea97d, 0x0,
    0x3fe89b18d3201693, 0x0,
    0x3fe087f087760b57, 0x0,
    0xbfa5fea7185d8466, 0x0,
    0xbfdfda2cbedad648, 0x0,
    0xbfe37747768e50bc, 0x0,
    0xbfdcba48bc3a7be4, 0x0,
    0xbfa23cf76cdc0e59, 0x0,
    0x3fdf6f8f2ddfaf72, 0x0,
    0x3fe36b995674d472, 0x0,
    0x3fdc5aecaba8618a, 0x0,
    0xbfa0a6a2fc9fcee6, 0x0,
    0xbfe00409e43370fd, 0x0,
    0xbfe664b68fb2e46a, 0x0,
    0xbfddcae3cfa683ea, 0x0,
    0x3f8e4b5f28c62a74, 0x0,
    0x3fe1de7504b34571, 0x0,
    0x3fe41cd829025f72, 0x0,
    0x3fdea4d7bc3a56d0, 0x0,
    0x3f8124605ca661ab, 0x0,
    0xbfe0232ed18f1aab, 0x0,
    0xbfe96a820abf28e2, 0x0,
    0xbfe0183668a45090, 0x0,
    0xbfa081df95172f99, 0x0,
    0x3fdc3f28e5655cd6, 0x0,
    0x3fe560bc89598a2e, 0x0,
    0x3fdfa4b3c4bb87c2, 0x0,
    0xbf9f9c91cea09b58, 0x0,
    0xbfda1eb1d9eb0b80, 0x0,
    0xbfe6db9fd58f1977, 0x0,
    0xbfde833d6b5a3a1f, 0x0,
    0xbf7b3fbb09115822, 0x0,
    0x3fe07ce468a3ee1e, 0x0,
    0x3fe62cac843d5d7a, 0x0,
    0x3fe0783af2145772, 0x0,
    0xbfaa942857013f70, 0x0,
    0xbfe3ce9e05067696, 0x0,
    0xbfe67b5f40cb0157, 0x0,
    0xbfde87e7689bed49, 0x0,
    0x3fa15c1cae1bbc60, 0x0,
    0x3fdea5ca3e0882f5, 0x0,
    0x3fe689e510d7bc7f, 0x0,
    0x3fdc63ea0971c6cf, 0x0,
    0xbf75c6b5a6d09ce2, 0x0,
    0xbfdad85b759f6d57, 0x0,
    0xbfe77497dcd043ce, 0x0,
    0xbfd9ed11d54978f0, 0x0,
    0xbfa93221acf70a1a, 0x0,
    0x3fdbce53639fd9de, 0x0,
    0x3fe5140fead36309, 0x0,
    0x3fdd2c5bfa4a3192, 0x0,
    0xbfb44d18e6053645, 0x0,
    0xbfdde5e1f25743e5, 0x0,
    0xbfe484e9740d9560, 0x0,
    0xbfdefa63daada3fd, 0x0,
    0x3fa3c6f865942a17, 0x0,
    0x3fdc17edf905a382, 0x0,
    0x3fe62baea3df283a, 0x0,
    0x3fe55ff78a21fb5e, 0x0,
    0x3fb458f7c3a643c1, 0x0,
    0xbfe3191bd60e7325, 0x0,
    0xbfe7989ff4f64134, 0x0,
    0xbfda9e9bb407bb61, 0x0,
    0xbfa1dac0ed913ae4, 0x0,
    0x3fdfddbafe510914, 0x0,
    0x3fe745a92a42136a, 0x0,
    0x3fe270a908e92dee, 0x0,
    0xbfa73d53969ea52a, 0x0,
    0xbfe1435936e90d2a, 0x0,
    0xbfe1c0c00e62da6e, 0x0,
    0xbfdb8b01d9036566, 0x0,
    0xbf91c70ee4da7d62, 0x0,
    0x3fe08d93052811bf, 0x0,
    0x3fe65e6514491ff6, 0x0,
    0x3fe0daa8ce607fc9, 0x0,
    0xbfaa2f45ff645221, 0x0,
    0xbfdc0056647f654e, 0x0,
    0xbfe6c4ab6016fa43, 0x0,
    0xbfe00cd13ea06aee, 0x0,
    0x3f795158643d7568, 0x0,
    0x3fdc8222e068803e, 0x0,
    0x3fe213de3292312a, 0x0,
    0x3fe03139743011c8, 0x0,
    0xbfb698a5ad6e1169, 0x0,
    0xbfdea6e4a727d952, 0x0,
    0xbfe8d3c19e2f149c, 0x0,
    0xbfe1f60f82a111d2, 0x0,
    0xbfadad1bba86bd2b, 0x0,
    0x3fdee5530ab1b62d, 0x0,
    0x3fe522862fda60d1, 0x0,
    0x3fe2e8593647914a, 0x0,
    0x3fa2a0f1a9f5c1a9, 0x0,
    0xbfd752c454b5c667, 0x0,
    0xbfe75b37464ae065, 0x0,
    0xbfdea66505260068, 0x0,
    0xbfb7a242045a7f0e, 0x0,
    0x3fdd8dbfbceb0592, 0x0,
    0x3fe80a19b9e06602, 0x0,
    0x3fe053c07e002570, 0x0,
    0x3fb4601c88702328, 0x0,
    0xbfdd2c5baab3d785, 0x0,
    0xbfe5581440879f1e, 0x0,
    0xbfe022060d4a235d, 0x0,
    0xbf7519f212bdfa85, 0x0,
    0x3fe0c38259096ec6, 0x0,
    0x3fe49bdfbfc4765d, 0x0,
    0x3fe259ccb2dfcc33, 0x0,
    0xbf55827272de4ef1, 0x0,
    0xbfe0170e81a568e9, 0x0,
    0xbfe3fd140e7394da, 0x0,
    0xbfe14c127dbb2c0c, 0x0,
    0xbfb7d4426d8a69f1, 0x0,
    0x3fe166460823c425, 0x0,
    0x3fe551bdd1aefe6a, 0x0,
    0x3fdedbbf984c900c, 0x0,
    0xbfb445b8661bcb6b, 0x0,
    0xbfdf16fcd9411d7c, 0x0,
    0xbfe7e45aba11a864, 0x0,
    0xbfde127974d7f809, 0x0,
    0xbfa582d70d962e8d, 0x0,
    0x3fd691736f570cca, 0x0,
    0x3fe5fbf7e3afa163, 0x0,
    0x3fdf1274f509ad40, 0x0,
    0x3f9d09964fa626b7, 0x0,
    0xbfde912ff7f99f41, 0x0,
    0xbfe4ec9cefccef31, 0x0,
    0xbfe1ec3ca4c47fcb, 0x0,
    0x3facbc6d0e3e2b28, 0x0,
    0x3fe0d90366163365, 0x0,
    0x3fe7fa080f68ba38, 0x0,
    0x3fe097339bb431c5, 0x0,
    0xbfbf77e0183ad5e6, 0x0,
    0xbfdeee05045fbe41, 0x0,
    0xbfe7b1c2dcf59521, 0x0,
    0xbfdac6812fd7e33a, 0x0,
    0xbf864b6cd72d48ae, 0x0,
    0x3fdd94160f66a68f, 0x0,
    0x3fe79561b9e8a284, 0x0,
    0x3fdfc0c8809a8c2c, 0x0,
    0x3fb252948fb3a68d, 0x0,
    0xbfe0797188e56840, 0x0,
    0xbfe6660240c5032b, 0x0,
    0xbfe119ab82de5d32, 0x0,
    0x3fa2c7bd97bbd6ad, 0x0,
    0x3fdeb3718ee6fac9, 0x0,
    0x3fe304beef43c6f0, 0x0,
    0x3fe0ba81f0b54646, 0x0,
    0x3f90f24648e27b16, 0x0,
    0xbfe2a18c6b1870dc, 0x0,
    0xbfe320b1a20a4932, 0x0,
    0xbfe1e2bd2afd834e, 0x0,
    0xbf8575d917800778, 0x0,
    0x3fe0bcd32f35e812, 0x0,
    0x3feaecaf02c1aee0, 0x0,
    0x3fe02fd9985c8c27, 0x0,
    0x3f9812506fa89b70, 0x0,
    0xbfdad382911d5c5a, 0x0,
    0xbfe6954e132c3574, 0x0,
    0xbfda1703afe863ae, 0x0,
    0xbf73598296cded10, 0x0,
    0x3fdcc752b89e8961, 0x0,
    0x3fe507246817f4f2, 0x0,
    0x3fe07f5d07bbd921, 0x0,
    0xbfa2e86c9c42aaeb, 0x0,
    0xbfe065d082fa081b, 0x0,
    0xbfe8689fd8f28a07, 0x0,
    0xbfe0e062fb364696, 0x0,
    0xbf2e3fae710f32cf, 0x0,
    0x3fddca194780c7a8, 0x0,
    0x3fe414f015c85d14, 0x0,
    0x3fe24a74ada8381f, 0x0,
    0xbf7a980385298382, 0x0,
    0xbfe09ded174dce90, 0x0,
    0xbfe8f21c57a3d524, 0x0,
    0xbfde631fd5049198, 0x0,
    0x3f9d28e279115e11, 0x0,
    0x3fe06c0c38331f4b, 0x0,
    0x3fe57950213a663b, 0x0,
    0x3fe0090d98eb6ea8, 0x0,
    0x3f97620d9bcf7e0c, 0x0,
    0xbfde01c3c135d519, 0x0,
    0xbfe59a73b4fbf0f6, 0x0,
    0xbfe091022905aaf8, 0x0,
    0x3fa0a0416b57b50c, 0x0,
    0x3fe139e1a69893fe, 0x0,
    0x3fe820534e99ad03, 0x0,
    0x3fe05671a55e84c2, 0x0,
    0xbf87e6f83c559551, 0x0,
    0xbfddfe860a2bbfb0, 0x0,
    0xbfe8dcc222c54299, 0x0,
    0xbfe091421b79346a, 0x0,
    0x3f7208f80417baaa, 0x0,
    0x3fe1d9801a59573f, 0x0,
    0x3fe57c7aa29af2cd, 0x0,
    0x3fdfb0c5e22273c4, 0x0,
    0x3fb3152bd8ee550d, 0x0,
    0xbfdc9ddcce6a1bef, 0x0,
    0xbfe6a6807bb96fad, 0x0,
    0xbfdbf310ee2b3c6b, 0x0,
    0x3f95fad2c2e167ba, 0x0,
    0x3fe2fdf6ba2caa6c, 0x0,
    0x3fe5f2021e479d70, 0x0,
    0x3fde43dec443523a, 0x0,
    0xbf79f5ab1cce4949, 0x0,
    0xbfdb8bacff994189, 0x0,
    0xbfe7c6ddbeacd910, 0x0,
    0xbfdfcb75ac404af1, 0x0,
    0x3f71d76f75ad8f45, 0x0,
    0x3fe03f28acba7394, 0x0,
    0x3fe755cca4d292f7, 0x0,
    0x3fdbdeb0f1c2dc84, 0x0,
    0xbfa03c21e670404e, 0x0,
    0xbfdcece3bb15821c, 0x0,
    0xbfe5f5afa8da1384, 0x0,
    0xbfe1eee3c359c11c, 0x0,
    0xbfb1abea0c653896, 0x0,
    0x3fe059f498470138, 0x0,
    0x3fe7e56916a84fdf, 0x0,
    0x3fdb77a4dfcd8a70, 0x0,
    0xbfaad06a91cbeb11, 0x0,
    0xbfe2d3bb4a0335ec, 0x0,
    0xbfe50d52fdacf5b4, 0x0,
    0xbfd927ff836be19f, 0x0,
    0x3f9c6230ce54b141, 0x0,
    0x3fe0f0d30134df80, 0x0,
    0x3fe69f5d6c69f6e8, 0x0,
    0x3fe0b33e6027c506, 0x0,
    0x3fa0bb178312198f, 0x0,
    0xbfe00b4bc2b47c81, 0x0,
    0xbfe47ddcfde92979, 0x0,
    0xbfd89cbc28c93067, 0x0,
    0x3f615e29e332dfbd, 0x0,
    0x3fdd88999fb4c6a8, 0x0,
    0x3fe737ccc4ff1b2f, 0x0,
    0x3fdf48d7bb33927b, 0x0,
    0x3fa77d07067d16ea, 0x0,
    0xbfde5992551968f8, 0x0,
    0xbfe8847ff1ea7650, 0x0,
    0xbfdd7ed069650426, 0x0,
    0x3fa9c54e90d38845, 0x0,
    0x3fdfe8f0744e5d0e, 0x0,
    0x3fe7f5432ac48cc8, 0x0,
    0x3fe04fc4ebcb4e6d, 0x0,
    0xbf7ab864fa8868ab, 0x0,
    0xbfdba207ba0fb1c1, 0x0,
    0xbfe71faea55f55e9, 0x0,
    0xbfde9572b4b29ecc, 0x0,
    0x3fac5a4cab785716, 0x0,
    0x3fddb2c212101c30, 0x0,
    0x3fe7740de72ed581, 0x0,
    0x3fdb21306e6e0f31, 0x0,
    0xbf8ab3f2ee4dc8c7, 0x0,
    0xbfdb429ab411bd08, 0x0,
    0xbfe8d5203e31bd96, 0x0,
    0xbfe146d65cda9bc4, 0x0,
    0xbfac296fa3955ee8, 0x0,
    0x3fe0abcadd13052e, 0x0,
    0x3fe7a66cb10cf3d4, 0x0,
    0x3fe209253ad909af, 0x0,
    0x3fa05982cd16c409, 0x0,
    0xbfdbe58a4b0bf2d5, 0x0,
    0xbfe6c902b7fb6588, 0x0,
    0xbfdbb6794aa396ef, 0x0,
    0x3f8464bafd44ffe5, 0x0,
    0x3fda99ebf46e409a, 0x0,
    0x3fe92ca01bf16914, 0x0,
    0x3fdb376bedf29a37, 0x0,
    0xbf969cfdbe0f0b95, 0x0,
    0xbfe0594a2622b7e3, 0x0,
    0xbfe7515ca7080dbf, 0x0,
    0xbfe18ab60dd3a62a, 0x0,
    0x3fb6d04130462886, 0x0,
    0x3fe12684087e41cc, 0x0,
    0x3fe7fd6b7b3f4df6, 0x0,
    0x3fddbad5a971452d, 0x0,
    0xbf757b63faa51b3a, 0x0,
    0xbfdd0a54b6850a3f, 0x0,
    0xbfe65be25b86dafb, 0x0,
    0xbfda1441885ba261, 0x0,
    0x3f8192031d3b6114, 0x0,
    0x3fdfb8a0920d0ca7, 0x0,
    0x3fe8ef3bb1594299, 0x0,
    0x3fe076073cc830ec, 0x0,
    0x3fa2a379e847a13a, 0x0,
    0xbfe02c116ee716b9, 0x0,
    0xbfebb51af57d7ed4, 0x0,
    0xbfe071f2cab1952e, 0x0,
    0xbf79b7497949aa03, 0x0,
    0x3fddbe05799f7878, 0x0,
    0x3fe4c685e0cf4839, 0x0,
    0x3fe1db311267747c, 0x0,
    0x3f8fbd673a89f500, 0x0,
    0xbfd7c4eb08f66fef, 0x0,
    0xbfe6c75cc656811f, 0x0,
    0xbfdd2cd709dd648c, 0x0,
    0x3f9da86864ca9e10, 0x0,
    0x3fdda3b5e7f742a0, 0x0,
    0x3fe82a4bfe286806, 0x0,
    0x3fe088a362b2a8bb, 0x0,
    0xbfbe34797d9f5e09, 0x0,
    0xbfdf1762d2ee7214, 0x0,
    0xbfe470eb06b6beb8, 0x0,
    0xbfe1a6c31a7a93b1, 0x0,
    0xbfa1ea2639787449, 0x0,
    0x3fdcc76042749dbe, 0x0,
    0x3fe5df8ada2be99d, 0x0,
    0x3fd818be1f4d335f, 0x0,
    0xbfc5d2c9b79a28ad, 0x0,
    0xbfe082da479cd15e, 0x0,
    0xbfe79624fbc452dc, 0x0,
    0xbfe06e3471673dfc, 0x0,
    0xbf9c462501c53aa4, 0x0,
    0x3fe032977c6ffbb5, 0x0,
    0x3fe48d473b9f4c9b, 0x0,
    0x3fdd0cf3dce4eb84, 0x0,
    0xbfaad931b3b99315, 0x0,
    0xbfdda66db6bad36a, 0x0,
    0xbfe63f81d3d7b9d0, 0x0,
    0xbfe0286a0a6a8e3d, 0x0,
    0xbfab660d92accce1, 0x0,
    0x3fe0aa28605aef03, 0x0,
    0x3fe6b1f55dc51754, 0x0,
    0x3fe1c7cd16e99c62, 0x0,
    0x3f9fc8146a752879, 0x0,
    0xbfdcefab167bf6d3, 0x0,
    0xbfe61cb813c2f5a7, 0x0,
    0xbfe26f2eca2ee733, 0x0,
    0x3fb5adda72b88edf, 0x0,
    0x3fe2b8c8e1d92476, 0x0,
    0x3fe4e0a8a05ae0eb, 0x0,
    0x3fe268c8f2840192, 0x0,
    0xbfa085c97d1c8a57, 0x0,
    0xbfdb3c84a76540ff, 0x0,
    0xbfe6cb723c699000, 0x0,
    0xbfd9b1b9ca98038a, 0x0,
    0xbf83191ccc211854, 0x0,
    0x3fde00e1f1da45d5, 0x0,
    0x3fe5ff1c5dc60f89, 0x0,
    0x3fe158f4d3834d40, 0x0,
    0x3f5abb06e1c6e8db, 0x0,
    0xbfdd9e0223365644, 0x0,
    0xbfe4882c2724c9a3, 0x0,
    0xbfdf8e44cf1d2eb4, 0x0,
    0x3fb91f66ebbb492e, 0x0,
    0x3fe2cb101fec3d64, 0x0,
    0x3fe4644bbb646aa7, 0x0,
    0x3fe0244ad49ef2c1, 0x0,
    0xbfae4a606b3e098c, 0x0,
    0xbfe12075687121db, 0x0,
    0xbfe5e0aa0c75535c, 0x0,
    0xbfdd10038a7c1cc7, 0x0,
    0xbfb3b221193d4488, 0x0,
    0x3fdc7989c8a1d948, 0x0,
    0x3fe635728ab89771, 0x0,
    0x3fe12bba27e51b6c, 0x0,
    0xbf8f30f8b10b80e1, 0x0,
    0xbfdf0984a700b83d, 0x0,
    0xbfe53b76c0f2ee24, 0x0,
    0xbfe1144ce3f45d24, 0x0,
    0x3fb3099e2f703843, 0x0,
    0x3fe3042055f753d1, 0x0,
    0x3fe513e587dbccd8, 0x0,
    0x3fe031a3169625a6, 0x0,
    0xbfa097311be9ca4a, 0x0,
    0xbfdbc99687c05da6, 0x0,
    0xbfe4b64ac7141425, 0x0,
    0xbfdcba49d1c4b741, 0x0,
    0x3fb45f99508187cc, 0x0,
    0x3fdb80a5d1140b9d, 0x0,
    0x3fe5c5372bb7282b, 0x0,
    0x3fe024881be2bb5b, 0x0,
    0xbfb98f3ada629eda, 0x0,
    0xbfe15746087c081a, 0x0,
    0xbfe74526fd134dca, 0x0,
    0xbfe032690c89f51c, 0x0,
    0x3fb17bbbedd9a028, 0x0,
    0x3fe2499c3efd61dc, 0x0,
    0x3fe634df275cfa02, 0x0,
    0x3fe14b7acccc3dc0, 0x0,
    0xbfb109a384bba025, 0x0,
    0xbfe0b3794ff91658, 0x0,
    0xbfe490237887c046, 0x0,
    0xbfdcd4024afcd74a, 0x0,
    0xbfac63b3c8de76a3, 0x0,
    0x3fde66bcedc55562, 0x0,
    0x3fe76a21c20e9863, 0x0,
    0x3fdfc85a60a2a6f9, 0x0,
    0xbf8f654ba257d3b0, 0x0,
    0xbfe0a85bd3834138, 0x0,
    0xbfe5f4639ab3a2a2, 0x0,
    0xbfdfec61f68a1a6c, 0x0,
    0x3f7c474b5f34e384, 0x0,
    0x3fdd1e12378e2792, 0x0,
    0x3fe91e53f63ecef6, 0x0,
    0x3fdf1e7e0b8ee36b, 0x0,
    0xbfa24bdb00e17f1f, 0x0,
    0xbfde22740508c4f9, 0x0,
    0xbfe551a2d776aa33, 0x0,
    0xbfe06fbc1ebeac4e, 0x0,
    0x3f933494dd38273c, 0x0,
    0x3fdf6016784fe30c, 0x0,
    0x3fe553387302563b, 0x0,
    0x3fdcfc579dd9fede, 0x0,
    0xbfac7790986e52a6, 0x0,
    0xbfdfbbe12b6e764e, 0x0,
    0xbfe2165e1b0b6971, 0x0,
    0xbfe01ebe2d6516a5, 0x0,
    0xbf8faba543a95083, 0x0,
    0x3fde8467653d54bf, 0x0,
    0x3fe586dda8d88d51, 0x0,
    0x3fe14bae3dd36fc4, 0x0,
    0x3f8711d47582222a, 0x0,
    0xbfe1f84082459f86, 0x0,
    0xbfe615a6ee01477d, 0x0,
    0xbfdc31ec5fabfaba, 0x0
    };

static const uint64_t in_cifft_noisy_1024[2048] = {
    0x3ff654f627f9c034, 0x0,
    0x3ffa74b3b71806aa, 0xbfdd3925c4b06a31,
    0xbff0169c9deec3c6, 0x3feac565e960fa9e,
    0xbfe4c343702ff05b, 0x3fa67a79bc9cf7a4,
    0x3fe8770854d5ff1c, 0xbfd553eece5be5ec,
    0x3fbc67431e9e32f4, 0x3fe540c44e264c6c,
    0x3ffe32d6f1fc1202, 0x3fe21360ec935635,
    0xbfd95df2f569595c, 0x3fe27bb461f8c719,
    0xbff0b2a9873df302, 0xbff6fd27dfb965ef,
    0xbff96904e0706a88, 0x3fe7da13d486c982,
    0xbfebe60553366c1b, 0xbfb82e952f16c168,
    0x3fe5099f2c4ad37d, 0xbfdeadc42c9e72bd,
    0x3ff13304ef9ef441, 0xbffedad84b42ca1e,
    0xbfdfd48a065a3744, 0xbf93715228411560,
    0x3ff8fc3bbe8b65db, 0xbfcdf209f87e0086,
    0x3fd652b9ffe08c02, 0x3fd6a722e768240c,
    0xbfb4809dcbc3e250, 0x3ff485361022b502,
    0xbfe9555e3b152ff1, 0x3fc993ec5cfacc50,
    0xbfe44d51ee93f14a, 0x40047f7c6f7250e2,
    0x3fb0f6e90bee0733, 0x3fe3c3409e4a0c34,
    0x3fdbdaceba154025, 0x3fcf8fdd3ddbe026,
    0x3fc5cc141986a812, 0xbfde72db401f87b1,
    0x3ff643e770c705b7, 0xc00a199f05fe0a2e,
    0x400fcee81948bcaa, 0xbfd9399a4bb38dd1,
    0xbfe4754f22374da2, 0xbfba8e98dba325b0,
    0x3fee9ca93139c11c, 0x3fd411b4c00ab4f5,
    0xbff4297d549baf22, 0xbffa14ac7b8a683e,
    0x3fe8548954eb9b47, 0x3ff15a7eee41800c,
    0xc0084c2a54361254, 0x3fe865acd20c73ca,
    0x3ff86be22b9f97a0, 0x3ff594a42391015f,
    0xbfebc62645f375c1, 0x3ff3d713c42ba8c5,
    0xbf8e185e8665cb00, 0xc0004b2bd2c9e670,
    0x3ff84b2cd2b69ab0, 0xc006ccf0ae51fcd0,
    0x3fb2e60eb5de53ac, 0xbfb9e561fa99b460,
    0xbfe628d8d09b8272, 0xbfe5d37a75aeb91e,
    0x3ffed84c4b88526e, 0xbfe128f8803f34e9,
    0xbfe5ca42c642b88e, 0xbfe0fffb456bb3f6,
    0xbff910a79d419d62, 0x3ff44acb3350645c,
    0xbff0a6ae33748e5c, 0xbfe8146a049ad4bd,
    0x4003b197753da385, 0x3ffa65d60ac2bf27,
    0xbfda43cd33c91555, 0xbfdb46aaa64a5a87,
    0xbfea4db258e37d84, 0x3fe331f2d44757be,
    0x3ffa01eadc57866f, 0xbff48c2f15c51158,
    0x3fda47c52599e56d, 0xbfe120e1bf8e9df7,
    0x3ffc1f8773fa1302, 0x400254eb58fa2876,
    0xbfeadbd837f2b849, 0x3fcf6f290e95370e,
    0xbfd4bdb6f674ddd3, 0x3fe029f2d8fc0351,
    0xbff6cbace4ace091, 0xbfecd4c33068bc91,
    0x3fe71ef0d6fc1934, 0x3fefa4694968c40d,
    0xbffd641ff04b5bde, 0xbfed878037f57df7,
    0xbfe87147ef4fe5ad, 0xbffad3899e5f23f4,
    0xbf9bf8c184b2d330, 0xbfeec01107ba1328,
    0x3fe84e4f0f59b42b, 0x3feca3901a800f58,
    0x3ffe8d064c901162, 0x3fce60f9a1e8a60c,
    0x400032d13f1c7fca, 0x3fe4720fcddfa14c,
    0x3feb2559f74e3260, 0xbff601ae08527b34,
    0xbffa06b5cb4aeeb4, 0xbfec32b7e2eaa80d,
    0x3fcf77081988fa34, 0xbfc8ddd31abd10ec,
    0x3fd4ce1151df2f10, 0xbff49f4384026554,
    0x3fd8c55b078352d0, 0xbfe86bb743ba1b8e,
    0x3ffc356c9e309bb2, 0x3ff21d5b0c041c81,
    0xbfe007f27d85c334, 0x40082b6eaaf9322b,
    0xbfe7c2684cbc78ba, 0xbfa491c9d61257a8,
    0xbff67151b7f1fea4, 0x3febf2e51eaa75f0,
    0x3fc08e22839cb380, 0x3fe4642544e73000,
    0xbfefdc5da59bb6c2, 0xbffdab34b59db556,
    0x3fe61230916a9b27, 0xbff5b6987d81d0b6,
    0x3f8c48bef4c6f880, 0x3ff2efaf7a7602d2,
    0xbfe96aa3b4393ac4, 0x3fe64fa1e7966eff,
    0xbff189d7f1125763, 0xbffb1fe360fb1cc8,
    0xbfe7cc3564d2ed5e, 0x3ff2928db3a5d6a9,
    0x3feb319fd62533b3, 0xbfd469d2183f4bd0,
    0x3fe8431dc9e4c8bc, 0x3ff0629b2014f341,
    0xbff75ea00d36767d, 0xbfce342e84399470,
    0x3ff15c853f3267c8, 0xbffa85c1ec9259d0,
    0x3fd4039ddc16f0a0, 0x3fe919d8758bbc94,
    0xbff13d601fb42938, 0x3fcac420153d5ad0,
    0x3fd6f99a3f5f2288, 0xbfd63f527088a8f0,
    0xbfd207a1b02e7ad0, 0xbfc74b4b4c2afc74,
    0x3fea3e3c1bb6034e, 0xbfde6d53fa8a974a,
    0x4002ffe4b162ca2b, 0xbfe73945fbcff8b9,
    0xc0034902e4753d56, 0xbff9434c95c2d410,
    0x3fff290d25e3e448, 0xbfd2acb9bafdaefe,
    0x3fdb17a437e1bfde, 0xbfde9c84e39325c4,
    0xbfe95b6b95713808, 0xc00800e94dae42d1,
    0x3fd05319d9aab506, 0x3ff80e16f09a98fd,
    0x3fea57166140aedd, 0x3ff8ab5fe85168b3,
    0xbfea5a9477b59adf, 0xbfe44438dd808bb2,
    0xbfd266a36400c2c8, 0x3fd0d5a114efdff7,
    0x3fd422a07b44f506, 0x3fd470a43862f12a,
    0xbfe02b8a846ac0ff, 0xbff3c37322c2a812,
    0xbff84e7f48317bf3, 0x3fdaa461e0f4b904,
    0x400135b3c5df9656, 0x3ff46ce544fd2376,
    0xbff4cee0f0ee79d7, 0xbfd33645d012303e,
    0x3fb82867e5d04b3c, 0x3fe2508bc4b32535,
    0x3fec7c01d919a49e, 0xbff833e5e3fbe688,
    0xc00a95357f02473d, 0xc0041be5d6ecac9f,
    0x3fef96a027bbedf4, 0xbfdd3edca95d1910,
    0x3fe2493ec762807c, 0xc001200c18b1958b,
    0x3ff56864970db361, 0xbff20cecaf5cf41c,
    0x3fa3ad5cd8d13720, 0xbfae547451ffa8b0,
    0x3fee6654a7375c66, 0x3fbef6f8b37386a8,
    0xc003791b81db60dc, 0x3fe39aa1234c8ebd,
    0x3fe4eae9a981f0e8, 0x3ff05e6f5c962ab0,
    0xbfe00d240a71dbc0, 0xbfdbb598771f78e4,
    0xbfd16e84ab6cdaac, 0xbfea318e59f73cf2,
    0xbfc48b3ec008f0b2, 0xbff1e221c1ffc49e,
    0x3fe717ecb5be0439, 0x3ff33fc57c42248e,
    0x3ff503806db0a7ef, 0x3ff80c4765283310,
    0xbfdc15258f8c85b4, 0x3fc80429e47fce0c,
    0x3feeec477db6ce4c, 0x3ff030792a574f25,
    0x3ff217d1be07a07f, 0x3fea54875d0f4011,
    0xbfe2b780d2bfcff1, 0x3fbfc371ddf25990,
    0xbfe00a56870c5ea8, 0x3fb3eb57adc5b560,
    0x3fdb8768867b58d1, 0x3ff31cef7e4e5461,
    0xbff894622bda6f0d, 0xbfe8aabbb7fb1940,
    0x3f84c237d6320dc0, 0x3ffe6fd66f5c056f,
    0x40020e16329bf5c6, 0xbfe6a1bb11f90ef7,
    0xbff587df9a6ffa47, 0x3fd191917c3da1a2,
    0xc0002a6c5ac8b531, 0x3fc53f4411bb5968,
    0x3fef88f535755c3c, 0x3ff7de439f4d2261,
    0x3ffb577e5fc84a1c, 0xbfc8f34dc4437670,
    0x3fd02be2aab5ccaa, 0xc0001506d34e1a36,
    0x3fff5f303ccd1748, 0xbff1b12d6142b1a3,
    0xbfd30fb5cc4f7d2c, 0xbfeed47558684664,
    0x3fc46e11ac34f3a2, 0xbfd31fc3a7634ca9,
    0xbfccc64770379286, 0xbfdbe9800dc7fc6a,
    0x3fedae235b31fba2, 0x3fc35ec19f45cd70,
    0x3ff6a9186454c6c6, 0xc0765a4be82bf96a,
    0x3fcce348da9fcf70, 0xbffba089ff1e6f58,
    0x3fba6b95936bcd48, 0x3ff0901600729555,
    0xc0011c21449e8c15, 0x40050873c43ec51b,
    0x3fc69a14112ec85c, 0x3fe8ea3aa18a15a8,
    0x3ff2f16f5b7b43e0, 0x3fa201e197c57a10,
    0xbfe88706e580e2ec, 0x4001f51254e77eaf,
    0xbfda5a6f976b0cc0, 0xbfe36c28fd18d00e,
    0xbfd8d428e78ea0a0, 0x3fc50890c35fd990,
    0x3fccecae0c5654dc, 0x3ff5151ce06799c0,
    0x3fe1f8472aae49b0, 0xbfbf1a02c865e6f0,
    0x3feb34bba320fbc8, 0x3fffb781bd8305b6,
    0x3fe802b47b20e3c2, 0xbfd7e033674f8802,
    0xbffa5e6b41a97fac, 0xbff4e05a8fafa85e,
    0xbfe1333816afbfa2, 0xbfe53ed6930fa40f,
    0x3ff8937fd8e69a44, 0x3fd6e5f369833a38,
    0xbfd0d7276322acc2, 0x3fa45508b575fdee,
    0x3fefe0fec8182052, 0xbfebb10c5d7eabac,
    0xbfd4ea67b3a1ee07, 0xbfd8a35fc0ce1b49,
    0xbff5e1b6371a9bc5, 0xbfe38a24a9dca044,
    0xbfe65cddd57f08c5, 0x3fe74bbb97f130a8,
    0xbfd528a9863facec, 0xbfe01e6c9fcd4af7,
    0xbfcf4636f88583ba, 0x40011c5396f36d98,
    0x3fe6786c6d522b9b, 0x3fd5526e104d817a,
    0x3fefb4ad6b5903f6, 0xbff1ef43456944c3,
    0xbfa9046268636108, 0xbfde20ab4e4d2d4e,
    0xbfedf8886acbe777, 0xc000334415442e91,
    0x3ff01140ad3df068, 0x3fe654a46e64e8b4,
    0x3ff16192fe318f46, 0x3ff585136ae1006e,
    0xbfaefa07c1e8e8e0, 0xbff0bf98e431441c,
    0x3ff45fdeb1e400ee, 0x3fc2cce91627e858,
    0xbff7cae3d668be3c, 0xbfb8f6bfa1a88944,
    0xc002ff542d2cfaf6, 0xbffc05cf1bc584f1,
    0xbfe8bd0931ed3020, 0x3ff9988150a62ed7,
    0xbff4677168b0bc52, 0x3ff8a7ef2a3ac380,
    0x3ffa7d99e395ae80, 0xbffb73ed97f77bb8,
    0x3ff3a8e38eecb628, 0xbfebd8e43e9f58c6,
    0x3fece8cf536e75fe, 0xbfd479be85c12b66,
    0x3ff5b7fd3f98d44f, 0xbff0b40a1379e5fe,
    0xbff7a1aa1fb88f9e, 0xbfe44498f1dc7dd4,
    0xbfd3f6bca3835a93, 0xbff49b92be15f51e,
    0xbff10ccbae3c3c44, 0xbfec0077a1aeb7fb,
    0x3fbc5bc82c60a918, 0xbffce4a543e98868,
    0xc0017bf599bb68d0, 0x3fc7ab798b480bdc,
    0x3fe7f2fe4469ff5f, 0x3fa2088975ee9910,
    0xc0037edc4c2b9336, 0x3fe3df7a33751cde,
    0xbfedaa56a8dc2f5d, 0xc0075d6468447f8f,
    0xbfdff89037c339c0, 0xbfe27e5c45007c3e,
    0x3fc47b7551f8acf7, 0x3ffc954f56571752,
    0xbfe13d5a85e99770, 0x3fdceda0362f3cbe,
    0x3fe6e89edeb5e5d8, 0x4000be402155dbb7,
    0x3fe504dbfde542bd, 0xbfedfd78726763ea,
    0x3fc756aa2b9753ee, 0x3fce74037c6586ee,
    0x3fde19c901947d5a, 0xbfc4f33d0ffc94ce,
    0x3ffd89cf329ff207, 0xbfff00bf90a2749a,
    0xbfb6cf5ac0726368, 0xbff5e7da49cf98c4,
    0x3ff0f980edcdab00, 0xbfd69ac3a52a5b9d,
    0xbfbde8dbb19a9860, 0xc004b4a31338e0a1,
    0x3fefebc46b43d358, 0xbfe111947273a714,
    0xbfb6fbf6f2756338, 0x3f7ae076cd2c6b80,
    0x3fe0419764545588, 0x401003ddd6c644d7,
    0x3ff65c3deb8570c3, 0x3fe8666e15bd6771,
    0x3ff5ce65eca8f33f, 0x3fe2cb1ad00470b0,
    0xbff3ea77d1bf249f, 0x3fc46329cb221628,
    0x3ff15a9dee503226, 0xbfd1a1ef4c3908e9,
    0x3fe64844f0a6961a, 0x3ff0021ee35ce7d0,
    0xbfff725253020c0a, 0xbfca6193a28db700,
    0xbfe7c014a91e7a36, 0x3fc0892a4a963341,
    0x3fe83bd1e0de4725, 0xbfe868d8be4ad3d7,
    0x3ff2cec88a1868ba, 0xbfde57d81d178b96,
    0xbfe655ff6f91b2b6, 0xc0062285be0f8e74,
    0x3ff2dc7a9efe6e2a, 0xc0045edac1dfc0bb,
    0x3f7ea141345b34c4, 0xc003dcfebd203c0f,
    0x3f9417789d581558, 0x3fbe4aa250a21490,
    0xbfe9b7f56c532260, 0x4002d0177d5487c5,
    0x3fec28ed1204a526, 0xbfef1c9568349362,
    0x3fdddd6d6db02bec, 0x3ff211ccf975bd3e,
    0xbfe34345fc4eb4b0, 0x3fc5913aeb753522,
    0x3fe2a46c0d637e45, 0xc000a4cae0c78862,
    0x40024986ca6e2739, 0xbfe0c75870e5610e,
    0xbff034697f6f5479, 0x3fe7d8f80f5f5769,
    0xbfdd5e72ea817508, 0xbfaf2a3f7a6df6b4,
    0xbfe0e065bf13e694, 0x3fe5d659b2c2f361,
    0x3fc002b2788636e6, 0x3ff2a542d597f685,
    0xbfebdd65b5a22b4f, 0xbff2f4c8e574ca45,
    0xbfe540013bd03b7b, 0x3fe35e0cfc721ef1,
    0x3ff90f94282cc4c6, 0xbfb91fca274f5984,
    0x3fe8610fb516d4eb, 0xbfd4e84b1086d347,
    0xbfda01d2dee40072, 0x3fee27587022ae47,
    0xbfc7c33884769454, 0xbfcae33834a2204f,
    0x3fe240a48cb96f84, 0x3fe70216f6bcec2e,
    0xbfe6accab8a7e21c, 0x3ff36f228b8ab57e,
    0xbff962752b66b095, 0xbfd5c02657bd235f,
    0xbfb87d0b24d317f0, 0x3f87ff36c4252650,
    0x3fd4e98f5570beb6, 0xbfe10d699e2ad6fd,
    0x3ff0b87d95d4b4ca, 0x3ffecee10fbb9b38,
    0xbfe1f127e36df6d6, 0x3ff92a04665b31a5,
    0xbfe300900819a874, 0xbfe523159b5c33d6,
    0x3fd12a1d53c6c548, 0x3fed9a5ff2892f2f,
    0x3ff0bfc3d3c05be3, 0xbfdb99df14feadcc,
    0xbff0f4470105884e, 0x3fe10fbf16688d9b,
    0xbffaad45455d0d7c, 0x3ff87a21b736cc62,
    0xbfc50294be9b7ab0, 0xbfe0233916bd4930,
    0xbfe6c0ef4ac46677, 0x3ff326c12d801850,
    0x4005c85d46784ae5, 0xbfe5a4b4085619ee,
    0x3fd321951103d778, 0x3fe64bde38f409f4,
    0x3fff9b91f546eef3, 0x3fefe67328cad536,
    0xbff119c883bed6b1, 0x3ff30a480c58c008,
    0x3fe4f0203d199744, 0x3fd216b9d07d06c5,
    0xbff6c30cb1bce591, 0xc011c78ac290cc6a,
    0x3feff57b4caab14e, 0x3ff757df8bbdb9ae,
    0x3fe46a25675a782c, 0x3fdf276e83917dbc,
    0xbfaebb46d4a790e0, 0x3f964c78e4d0fea0,
    0xbff44b5d933b9114, 0xbfdafe95ac35c245,
    0xbff5a87dc48a7bfe, 0x3fc799deed698ee7,
    0x3fbcd82cbf3919d8, 0x3ff25bbf4394e87c,
    0x40083ad264555890, 0x4008950e3d529489,
    0xbfffd5b57592e14b, 0x3fe462208ad86b89,
    0x3feba7a8795af635, 0xbfe55ec309baa0ce,
    0xbfbb5b7a409fe95c, 0xbff670a08206631a,
    0x3fe49857400c04cb, 0x3ffcd487c64b2d64,
    0x3ff1deb81b4ec198, 0xbfd468c1a2faf98a,
    0xbff0499b7e1fdf38, 0xbfe5367737e5abec,
    0x3fd068d1eef1c94f, 0xbfd1b36ee67888eb,
    0xbfd881a40ee68d37, 0xbfe2240a6969f314,
    0xbff8001d36ac0ede, 0x3ff259054b2df31c,
    0xc005e1b87d87c0c9, 0x3fdaed83d3b5ae3f,
    0xbfe58ef0d44b5e5a, 0xbfcebfe4e3cc4d45,
    0xbff63bff9d503f0c, 0x3ff5143f229f13c0,
    0xbff0b3204bf8be26, 0xbfd0164c9e71e6c2,
    0x3fe7c1d2e282fdc4, 0x3fdb4d93a0490a04,
    0xbff3a98fd579ed2b, 0x3feab69136b5d626,
    0xbfef8b3a0bee155e, 0xbff227a3cdf6a6de,
    0xbff39b83154bb7a2, 0x3ff2d295115bed53,
    0xbfc1c535eed7f8cc, 0x40013bc794bd252f,
    0xbfed355f9c5f3124, 0xbfcede9043955ec3,
    0x3fe4202801bad9ac, 0x3ff304b6fd59c88c,
    0xbfd82ffddb032536, 0xbfc753c75d385a1c,
    0x3fdf76a8302a7972, 0xbfecd971b75f6c92,
    0x3fe9938c705bb44e, 0xbff61733428d8631,
    0xbff7600f6dcac75c, 0xbfea20c1033d5466,
    0x3fe5b5a3e99d6309, 0xbfd7f4490b44e97c,
    0x3ff414002a9bc268, 0xbfd3f0cd8098e3e7,
    0xbfd5d27a88386d66, 0x3ff2a8c5e301343e,
    0x3ffe806fecdbe1f3, 0x3fe8c84df48b82fa,
    0x3fed8fa2a121b1b6, 0x3fd36adab9373ee0,
    0xc00152b4ad904f98, 0xbfea8abdef4f3a49,
    0x3fef013fe274e8d2, 0xbfe6482b8f2bffd0,
    0xbfd5b11e706f11d1, 0xbfb12b341802ee54,
    0x3ff0d9f64888476f, 0xc003062cf81227e1,
    0x3fd1b89eed679202, 0xbfb2d69bb56439f8,
    0x40009d60a0311f82, 0xbff598b2b3289b40,
    0xbff4cea1fe74a1d1, 0xbfda3f81bcafc468,
    0xbfd9ae6935d67ecc, 0x4000d82f1965f1c9,
    0x4003afd74f456b9f, 0x4006dbd7604aaf61,
    0xbff18c81916b3ec6, 0xbfee65fdd0c1df53,
    0xbff0c794017de5fa, 0xbff16b3922a21770,
    0xbfe7e096c147d314, 0x3ff8c5b7275112c0,
    0xbff5fd21e65c8d66, 0xbfd6a140f6f39246,
    0xbfc821c656318b18, 0xbfbcc1c3d777cf00,
    0x3fd87f1f48e1a378, 0x4000b56a205944fb,
    0x3fd2a285b1d069d3, 0xbfd42640bd261294,
    0x3ff7336fb540672e, 0x3ff3626cc47e0c78,
    0xc0034bda027e170b, 0xbfd19f02c11adc9b,
    0xbff026ccb2c98e08, 0xbfeb5ec0dad3bdee,
    0x3ff07fb780bfa61b, 0xbfc551058e010e78,
    0x3fdcf209133bc26a, 0xbfc09068091a7d84,
    0xbff32f7d373b738e, 0x3fcc0f4702b30c17,
    0x3ff949ace48ddc25, 0x3fb0c636177da1b0,
    0x3fed86c36ffec036, 0xbfe985214f719556,
    0xbfea9479d93b4781, 0xbfe329a65755d6c0,
    0xbfe35fc045f8cf4e, 0x3fdcb0e8cae6b86a,
    0xbff031bb70dd3746, 0x3fe799305f1c3fa7,
    0x3fe5395c36ecc4c5, 0xbfe241f2b6569234,
    0x3fe1e798f575e5da, 0xbfe0ed634dae4455,
    0xbff65bceac915c83, 0x3fe15b6eacdee6de,
    0xbfeb8e3fe1dd27d2, 0xbff81faa61beb28e,
    0xbfe08f617ec06365, 0x400436aca95abb05,
    0x3fd0c6055649820a, 0x3fea59df0235ad6a,
    0xbfece5004cab3013, 0xbfea1f06dd3721e2,
    0xbf94dd44537637b0, 0x3fe17f8de43a47c9,
    0xc000c15a2f619d16, 0x3ff767e834ee082f,
    0xbffb20ade92b8e9c, 0x3fa1d127582c6060,
    0x3fd25f444aa08319, 0x3ff2018693788c24,
    0x3fa1d2fabe4e37b8, 0xc0000865b88d9b65,
    0x3fef0944c5410c28, 0x3fe1acd9a78c368b,
    0x4000b68cbe6d8d15, 0xbfd11928607c6a1c,
    0x40028618ffe80619, 0xbfc22b17903f064c,
    0x3feb510f31815215, 0xbfdefd2d2b6a06a8,
    0xbffb03bb679bbde9, 0xbf94ec5529011c98,
    0xc00071b92e183954, 0x40050e2421b6b027,
    0x3feaa8d56d383162, 0x3fe345038dcd7f98,
    0x3fd882a4b0973d4a, 0x3feefa6146dcbab1,
    0xbfd2639472de9326, 0x3ff839b5bb662e6a,
    0xbfd6ad544cdc2e46, 0x3ff58a84c96e49fc,
    0x3fe65078e27c37f2, 0x3fe756524af68ba8,
    0x3fe54dc626cecde9, 0xbff6e2561ecadf75,
    0x3ff78725d0e2921a, 0xbffae9666bdfeb3c,
    0xbffba8468213da07, 0xc00121555f4fe320,
    0xbff372a1c045befe, 0xbffc745b71050f03,
    0x3ff3a42eac355725, 0xbfe06ea40a7ae6b1,
    0xbfe2fd9600fcc964, 0x40003bb8fce5461f,
    0x3ff17acc2c7f60c0, 0xbff7c66c9de4a78e,
    0xbfe5c1e0093b1ebe, 0xbfea7f35f2ee691c,
    0x3fe654b35a069a79, 0x3ff1e57b89b31285,
    0xc0011cfb8b23f925, 0xbfc7cacc88d3b47c,
    0x3fbca94dce8ce8e4, 0x3fc07dff36174294,
    0x3ff0480b8faeed74, 0x3fdb83b8fc45a649,
    0xbfd19cb74803d2a0, 0x3ff1482160d838d8,
    0xc00001978c5244a2, 0x40006ebad3ad7e40,
    0x3fe8ccc022464854, 0xbfe3a1bfcdf9acb0,
    0x3fefaef30cb65c96, 0x3ff1e647052b756d,
    0x3fe50760913b291a, 0x3ff4f66298a75070,
    0xbfe08d39bacee5be, 0xc00031b97fe671a2,
    0x3ffb1dc3bba494fd, 0x3fe67b9098b2e421,
    0xc001993c44950eb8, 0x3fc708cbb3572bca,
    0x3ff400874d480a00, 0x40015d19fbf352c2,
    0xbfef0e54561db9d8, 0x3ff38d12afbb9677,
    0xbffb41e74494470c, 0x3fe08a6ac2ae995a,
    0x3fd07b0eabb5cf3c, 0xbff3a9b75256bf1a,
    0x3feb9d02dc79eb50, 0x3ffc0b03ae2558e0,
    0xbfce0b6db0c26d28, 0xbfefeca5643d5f17,
    0xbf98f7e217f1f1c0, 0xbfa7be458cdad900,
    0xbffac3021214a284, 0x3f87fd8e6a27dbc0,
    0xbfe5c7c1917b6de2, 0xbfa6ba72954b7cd0,
    0xbff1ddd393f42586, 0x3fdde08f115cd8a3,
    0xbfd805db8e0a0fee, 0xbff5d5c53df012d6,
    0x3fe28a25ec5ff98b, 0xbfd4c9f21bc39786,
    0xbff12f29e82617a0, 0xbfe1cf8cfec4f176,
    0xbfd36be43b0ca5e0, 0xbff9807dc7abad32,
    0xbfed4e20556eb2be, 0xc0064bd6982bda51,
    0x3fe510e0878aef9b, 0x3fec3c8e85af7714,
    0x3fcdceaf881355b4, 0x3ff3663517dc79cd,
    0xbfe9d6c9afb8e158, 0xbffaf03f8b2f022f,
    0xbff0b786dca1cb0c, 0xbfe38f6e53be5035,
    0xbff4247e510bdaac, 0x3fd4f402316a5df8,
    0x3fe779d77f72e18e, 0x3fd1f0bb0b119a92,
    0x3feef09360fa109e, 0xbff190756ee312f6,
    0x3fb0e39b14125efc, 0xbfd58e242915c6c7,
    0x3f947f205875a7e0, 0xbfc3f8056ae3ed9e,
    0xbfe2efcdd4a46350, 0x3fbc61daf6a666c2,
    0xbfe157fc88697c21, 0xbfd7fa18a68c1f0f,
    0x3fd91cf3cfaf2e34, 0xbfea06ad01a6bc7d,
    0xbff509bc1d7f0eca, 0x3fd98f38ba50e47c,
    0x3ff7ae56f1e55190, 0xbff5b712b03cef50,
    0xbfe6ae3373430728, 0xbff3eb0da52eed36,
    0xbff81daf7a6ad913, 0xbff6f427409e94fc,
    0x3fdbe277286df322, 0xbff5fdf8e0ed1175,
    0xbff4aaad8ec00d2b, 0x3fede9790b4a516a,
    0x3fde5d09eb428e92, 0x3ff8534833a04973,
    0xbfe734e8491cecfa, 0x3ff43a665ef05394,
    0xc00ac7fb9087f063, 0xbff73a166c599700,
    0xbffda2175df810c8, 0xbfec46433991fb17,
    0xbff9f8bda50f8bcf, 0xc00d8aaae49de300,
    0x3ff7bfc246a317ca, 0x3ff5f4087ab2e11a,
    0x4001b612118a1a1a, 0xbfeea6028605ac6a,
    0x3ff8546f98a2ac7a, 0xbff74903ab872380,
    0xbfed1b4ed795de47, 0x4004a78675209af2,
    0x3f935db5c429209c, 0xbffe7cb4d292bfd0,
    0xbfe7550d709ea342, 0xbfd7086297cacef8,
    0x3fbcb42e8cba518e, 0x3fc9b32c5f8c790a,
    0x3fe46476cff86057, 0x3ff7ae1e909a252a,
    0xbfe21850592b6b00, 0x3fedc6a57eb03e29,
    0x3fe0e5b09d1558ce, 0x3fe81f926e999fa2,
    0xbfec0a0ad2738b03, 0x3ff93ed1bb7a6b96,
    0xbff20f3452163cf9, 0x3fc3cab2991b1522,
    0x3fe3c00ff58bb7a5, 0x3ffa98069d8b257a,
    0xbfeac257eaec6da0, 0xbff696cb70afa659,
    0x3fee839453344fd8, 0x3ff3002e1cadf469,
    0x3ffaf30edbe398d2, 0xbfedf848882024eb,
    0x3fd1953578b146b7, 0xbfe664458b86e2f4,
    0xbff6bb08775dd120, 0xc003f9319b9ed920,
    0xbff3b11aefb54cdf, 0x3fdc56f2459a467d,
    0x3fccabc30641ad36, 0xbfdbe1231be47b5f,
    0x3ffd146761371ae4, 0xbff0e5f10e6de76c,
    0xbff1dbeb96ba5bf3, 0xbfd20893a8d2dc8c,
    0xbfed3e6e1b3c1682, 0xbff100f9a2bc9d21,
    0xbfe7c91eabcf405a, 0x3fa611fec7933cb0,
    0xbfae111089ddbdeb, 0xbfc6ca7b9c64adbe,
    0xc0001fedfe9fc89d, 0x3fe2c5ae0cb56f98,
    0x3ff261d3d7a4de99, 0xbfe3ea695c0d56a4,
    0x3fed96839beedaae, 0x4007f47bf443b173,
    0xbfa073eceda88700, 0x3fc11221d3245f76,
    0x3fee885d8880a925, 0xbff33c9a169dced9,
    0x3fd2a5581858602e, 0x3ff8a40d663f0fb9,
    0xbfc843e2d06943e4, 0xbfe8a42b91388147,
    0xc00658ac1887e01f, 0x3fe08e2127d5fc2b,
    0x3fe12bad76dcf3de, 0x3ff72381d527c1f4,
    0x3fe4a12ad1d27d8a, 0x3fde2d3ad9f082c4,
    0xbff99f05222162f6, 0xbfff6871dc78da2a,
    0x3fe8b26a64121133, 0xbff34860521faed4,
    0x3fb52b6a19dad080, 0x3fe5942e43afc0d6,
    0x3fbd1d60d70e3c30, 0x3fe5b499afa4ee9d,
    0x3fe0688a15f2779c, 0x3ff82ed666e8435c,
    0xbfc30350fa491152, 0xbfcc3685e4b544cc,
    0x3ff497b05b72d46f, 0x3ff3a7d3bc7696e5,
    0x3feed627c0f50a8e, 0x3fe0e8116577a06a,
    0x3fe7d82a1c6c428d, 0xbfc905a0136a69b7,
    0xbfcdea2d2fabe5c2, 0xbff889d2e8dc62eb,
    0xbfe91f3f0ee7e777, 0xbfea73d7b05298e2,
    0x3fe85857313f0a56, 0x3ffc699e9ccd1598,
    0x3fdb4a347a6ff23b, 0x3fee75d2ae6110fa,
    0x3ffaaf91c6e09a90, 0xbffc29dc0d200e04,
    0xbfca3724890e98b8, 0xbfd682c1a2c3eba8,
    0xbfda5c231fc7eba6, 0x3ff617187bff9060,
    0x3fe8b4a900710a8a, 0xbfc4d5b907c7ad9a,
    0x3ff5227c0a8822c2, 0xbff49c0aa58cd638,
    0xbff1470cb52a2c30, 0xbfc6c8e37514cbad,
    0xc003ed6c20dc8093, 0xbfc0d1f167598c67,
    0xc007da804e3e119e, 0xbfda92414720b429,
    0x3ff1f58d32dbb059, 0x3febc1fc151df864,
    0x3fce253410f394f4, 0x4004d8ba39f0652d,
    0xbfdf6b6574c9319a, 0xc00321f4fecd008c,
    0xbfcb72c195691bf4, 0xbffc68e948ebc5d0,
    0x3ff318dfdef933a4, 0xbfdbd9bb8521a55b,
    0xbfeaf3b2f9695a48, 0x3fc4ef7123103b00,
    0x3fe77dbc0eeeeec4, 0xbfdde9c9a597b475,
    0xbff3f0221bd00de0, 0x3feae32cf835f9c3,
    0xbfb82112a8606ae8, 0x3ff811fcfcb6bb1a,
    0x3fed3eeeb28141d2, 0x3fed616b6ad7b5b7,
    0xc0068d73a9eae596, 0xbfef2b2e3e400fcb,
    0x3fc1f88940e77848, 0x3feaeb2053994165,
    0x3fa18e8ef59589b8, 0xbfbd720e392c85b6,
    0xbff34ccddd809f0f, 0x3febe293a09f9a1a,
    0xbff560d3f3ccd069, 0x3ff2146be79029c2,
    0x3fdbd455d63a8581, 0xbf712553ea7e2c00,
    0xc005c437d575ed90, 0x3fb3c95962302cf0,
    0x3ff83ddc1f8a3e01, 0xbffe20efd8859fe0,
    0xbfdc43b5ccccdb54, 0xbfb12591bae13020,
    0xbfdb2092a2733138, 0x3faead240343d390,
    0x3fd426c970ef2fe2, 0x3ffb9268ee28d775,
    0xbfcc70c496243c50, 0x3fe4060858173bfb,
    0x3fa7a53f6b0879f8, 0x3ff5759e98261840,
    0x3fdfc9f8356decdd, 0x3fef1dcfa86b5a15,
    0xbfb4782542efed88, 0xc003a9768de8eda0,
    0xbff330a0b161283c, 0xbff4d365ebc5de48,
    0xbfddeec3b41a1f32, 0x4004384eaedd5377,
    0xbfbcb0f6c9e6c528, 0xbffdfe28f3e9b64d,
    0x3fd34156d3f0a071, 0x3fc1af01ad299c46,
    0x3fd846ac0f1fd1fe, 0x3fea41f1b492ccec,
    0x3fe9d5c6f4fefd5c, 0xbfca5aad921e2fe8,
    0xbfc0a26bceb4a0ca, 0xbfeafe64de4d1620,
    0x3ff3cc731fd75d1a, 0x3fd72a7fe45ec5ff,
    0xbfefbe29b75c94ed, 0x3ff5a86f51cf4f61,
    0xbff41693f693ad1e, 0x3fe1c3b010aafd54,
    0x3fd83eafa8552874, 0x3ff2409424717aa9,
    0x3fb7ff1ffe547f58, 0x3ff09a584a80be6a,
    0x3fe0ba90463265aa, 0xbfdde378dbf6ddaf,
    0x3fd0f223e191eb0e, 0xbfeb27ecf93ad05a,
    0x3ffa0fc3fdff4c1a, 0x3fdec16589a3d452,
    0xbfcc7070ac38f665, 0x4001c37dee6ab331,
    0xbfe8a24162cf45f4, 0x3fd88be25791e3e2,
    0x3ff06714044deef9, 0xbfeb6f3b29f1686a,
    0xbffcb1d97750c3f7, 0xbff6b980505dc23d,
    0xbfe3a940b2052588, 0x3ff4213bfb4734c7,
    0x3fe94ffaba45b49c, 0x3ff8a92ebc0e982e,
    0x3fe0bd48471d6a88, 0x3fa3fa3d72f900e0,
    0x3ffa41dc0480a73b, 0xbff5eff7c91fb6dd,
    0xbfe8490bc7d84977, 0x400171dfeb7e5c2b,
    0x3feaa04d4e0c82eb, 0xbfccf16825a5fbf8,
    0xc000c0b331056e39, 0xbffda507ee6da0a3,
    0xbfc4726880cb5398, 0x3fd358987c7b26c2,
    0x3ff2edaf4476515b, 0xbffd13ec0299b236,
    0xbff00cc7bb027bad, 0x3fd543d11d94564d,
    0x3fe7f0c5b3cf24ea, 0xbff0bd2b8e30a121,
    0xbfcfd1857cc306f6, 0x3ff5118c28a2f62b,
    0x3fd2fbaf3860cc72, 0x3fc05779c16f1fa8,
    0x3ff150662979737a, 0xbffcf429eaf0336b,
    0xbff5619f5c33f700, 0x3fb1bcbadf1ffb78,
    0x3fe934b1d436c7d6, 0xc001c865b652811a,
    0xbff4741bf1105a95, 0x3ff28bb4d2cd6193,
    0xbff1a252c03a2218, 0x3fe7e7302d974c83,
    0x3fef15f6536e5589, 0xbfef7753c494a285,
    0x3fc43cc452e78c2f, 0xbfd7af68fe412fdb,
    0xbfed5cd8ae4b0fd5, 0x3fe3c01cb3322a6a,
    0xbfde674581c4f78c, 0xbfc3fe59d5081dea,
    0xbfb38ecdb20bb360, 0xbffa0690f3a52368,
    0x40029179eab862ed, 0x3feb0adb0a74646e,
    0x3fbec33417852ef0, 0x3fcbd167434a8d38,
    0x3febc1029c625e5e, 0xbfe790a9e0b8fca2,
    0x3fe128b368bb03ed, 0x40082794ffef9f0f,
    0x3fd66466fc00a962, 0x3fd30eee8c318a2a,
    0x3ff2a1fcb80d8da6, 0x3feed570ed901ec1,
    0x3fedaa1b328fe153, 0x3fe346917c192425,
    0xc00d0e91104aa6a6, 0x0,
    0x3fedaa1b328fe150, 0xbfe346917c192424,
    0x3ff2a1fcb80d8da6, 0xbfeed570ed901ebc,
    0x3fd66466fc00a966, 0xbfd30eee8c318a28,
    0x3fe128b368bb03ec, 0xc0082794ffef9f10,
    0x3febc1029c625e60, 0x3fe790a9e0b8fca4,
    0x3fbec33417852ef8, 0xbfcbd167434a8d34,
    0x40029179eab862ec, 0xbfeb0adb0a74646f,
    0xbfb38ecdb20bb378, 0x3ffa0690f3a52369,
    0xbfde674581c4f798, 0x3fc3fe59d5081df0,
    0xbfed5cd8ae4b0fd1, 0xbfe3c01cb3322a6b,
    0x3fc43cc452e78c38, 0x3fd7af68fe412fdb,
    0x3fef15f6536e5586, 0x3fef7753c494a283,
    0xbff1a252c03a2219, 0xbfe7e7302d974c83,
    0xbff4741bf1105a97, 0xbff28bb4d2cd6193,
    0x3fe934b1d436c7d5, 0x4001c865b652811a,
    0xbff5619f5c33f6ff, 0xbfb1bcbadf1ffb78,
    0x3ff150662979737a, 0x3ffcf429eaf0336a,
    0x3fd2fbaf3860cc77, 0xbfc05779c16f1f98,
    0xbfcfd1857cc306f6, 0xbff5118c28a2f62b,
    0x3fe7f0c5b3cf24ea, 0x3ff0bd2b8e30a120,
    0xbff00cc7bb027bac, 0xbfd543d11d94564b,
    0x3ff2edaf4476515d, 0x3ffd13ec0299b235,
    0xbfc4726880cb5388, 0xbfd358987c7b26bf,
    0xc000c0b331056e3a, 0x3ffda507ee6da0a1,
    0x3feaa04d4e0c82ea, 0x3fccf16825a5fbe2,
    0xbfe8490bc7d84978, 0xc00171dfeb7e5c2a,
    0x3ffa41dc0480a740, 0x3ff5eff7c91fb6dc,
    0x3fe0bd48471d6a86, 0xbfa3fa3d72f900e8,
    0x3fe94ffaba45b499, 0xbff8a92ebc0e982b,
    0xbfe3a940b2052585, 0xbff4213bfb4734c7,
    0xbffcb1d97750c3fa, 0x3ff6b980505dc23b,
    0x3ff06714044deef8, 0x3feb6f3b29f16868,
    0xbfe8a24162cf45f2, 0xbfd88be25791e3e6,
    0xbfcc7070ac38f668, 0xc001c37dee6ab330,
    0x3ffa0fc3fdff4c1a, 0xbfdec16589a3d452,
    0x3fd0f223e191eb0d, 0x3feb27ecf93ad05a,
    0x3fe0ba90463265a5, 0x3fdde378dbf6ddb0,
    0x3fb7ff1ffe547f54, 0xbff09a584a80be6b,
    0x3fd83eafa8552878, 0xbff2409424717aa5,
    0xbff41693f693ad1f, 0xbfe1c3b010aafd50,
    0xbfefbe29b75c94ec, 0xbff5a86f51cf4f61,
    0x3ff3cc731fd75d19, 0xbfd72a7fe45ec5f9,
    0xbfc0a26bceb4a0ba, 0x3feafe64de4d1621,
    0x3fe9d5c6f4fefd5b, 0x3fca5aad921e2fe8,
    0x3fd846ac0f1fd206, 0xbfea41f1b492ccea,
    0x3fd34156d3f0a071, 0xbfc1af01ad299c54,
    0xbfbcb0f6c9e6c510, 0x3ffdfe28f3e9b64e,
    0xbfddeec3b41a1f34, 0xc004384eaedd5377,
    0xbff330a0b161283a, 0x3ff4d365ebc5de48,
    0xbfb4782542efed88, 0x4003a9768de8eda0,
    0x3fdfc9f8356decdf, 0xbfef1dcfa86b5a16,
    0x3fa7a53f6b0879d0, 0xbff5759e98261840,
    0xbfcc70c496243c60, 0xbfe4060858173bf9,
    0x3fd426c970ef2fe4, 0xbffb9268ee28d776,
    0xbfdb2092a2733131, 0xbfaead240343d3a0,
    0xbfdc43b5ccccdb4e, 0x3fb12591bae13020,
    0x3ff83ddc1f8a3e02, 0x3ffe20efd8859fde,
    0xc005c437d575ed90, 0xbfb3c95962302cd8,
    0x3fdbd455d63a8588, 0x3f712553ea7e2c00,
    0xbff560d3f3ccd06a, 0xbff2146be79029c1,
    0xbff34ccddd809f0c, 0xbfebe293a09f9a1c,
    0x3fa18e8ef59589d8, 0x3fbd720e392c85d4,
    0x3fc1f88940e77838, 0xbfeaeb2053994164,
    0xc0068d73a9eae596, 0x3fef2b2e3e400fcc,
    0x3fed3eeeb28141d6, 0xbfed616b6ad7b5bc,
    0xbfb82112a8606ae8, 0xbff811fcfcb6bb1a,
    0xbff3f0221bd00ddf, 0xbfeae32cf835f9c0,
    0x3fe77dbc0eeeeec0, 0x3fdde9c9a597b47a,
    0xbfeaf3b2f9695a4e, 0xbfc4ef7123103b08,
    0x3ff318dfdef933a1, 0x3fdbd9bb8521a55c,
    0xbfcb72c195691bfc, 0x3ffc68e948ebc5ce,
    0xbfdf6b6574c93190, 0x400321f4fecd008c,
    0x3fce253410f394f8, 0xc004d8ba39f0652f,
    0x3ff1f58d32dbb058, 0xbfebc1fc151df860,
    0xc007da804e3e119d, 0x3fda92414720b427,
    0xc003ed6c20dc8092, 0x3fc0d1f167598c70,
    0xbff1470cb52a2c31, 0x3fc6c8e37514cbb9,
    0x3ff5227c0a8822c2, 0x3ff49c0aa58cd63a,
    0x3fe8b4a900710a86, 0x3fc4d5b907c7ad8c,
    0xbfda5c231fc7eba6, 0xbff617187bff9060,
    0xbfca3724890e98b0, 0x3fd682c1a2c3ebb0,
    0x3ffaaf91c6e09a90, 0x3ffc29dc0d200e04,
    0x3fdb4a347a6ff23c, 0xbfee75d2ae6110fc,
    0x3fe85857313f0a58, 0xbffc699e9ccd159a,
    0xbfe91f3f0ee7e773, 0x3fea73d7b05298e6,
    0xbfcdea2d2fabe5c4, 0x3ff889d2e8dc62ed,
    0x3fe7d82a1c6c428d, 0x3fc905a0136a69ba,
    0x3feed627c0f50a90, 0xbfe0e8116577a06c,
    0x3ff497b05b72d46e, 0xbff3a7d3bc7696e6,
    0xbfc30350fa491153, 0x3fcc3685e4b544cc,
    0x3fe0688a15f277a2, 0xbff82ed666e8435d,
    0x3fbd1d60d70e3c40, 0xbfe5b499afa4ee9b,
    0x3fb52b6a19dad070, 0xbfe5942e43afc0d7,
    0x3fe8b26a64121132, 0x3ff34860521faed4,
    0xbff99f05222162f9, 0x3fff6871dc78da28,
    0x3fe4a12ad1d27d8c, 0xbfde2d3ad9f082c8,
    0x3fe12bad76dcf3dc, 0xbff72381d527c1f5,
    0xc00658ac1887e01f, 0xbfe08e2127d5fc2c,
    0xbfc843e2d06943e0, 0x3fe8a42b91388145,
    0x3fd2a5581858602e, 0xbff8a40d663f0fba,
    0x3fee885d8880a922, 0x3ff33c9a169dceda,
    0xbfa073eceda88720, 0xbfc11221d3245f70,
    0x3fed96839beedaae, 0xc007f47bf443b174,
    0x3ff261d3d7a4de9a, 0x3fe3ea695c0d56ac,
    0xc0001fedfe9fc89c, 0xbfe2c5ae0cb56f96,
    0xbfae111089ddbda8, 0x3fc6ca7b9c64adb0,
    0xbfe7c91eabcf4059, 0xbfa611fec7933cc0,
    0xbfed3e6e1b3c1686, 0x3ff100f9a2bc9d20,
    0xbff1dbeb96ba5bf3, 0x3fd20893a8d2dc8a,
    0x3ffd146761371ae2, 0x3ff0e5f10e6de76d,
    0x3fccabc30641ad38, 0x3fdbe1231be47b56,
    0xbff3b11aefb54ce0, 0xbfdc56f2459a467e,
    0xbff6bb08775dd121, 0x4003f9319b9ed91f,
    0x3fd1953578b146b3, 0x3fe664458b86e2f4,
    0x3ffaf30edbe398cf, 0x3fedf848882024ea,
    0x3fee839453344fd7, 0xbff3002e1cadf46b,
    0xbfeac257eaec6da0, 0x3ff696cb70afa65a,
    0x3fe3c00ff58bb7a4, 0xbffa98069d8b257a,
    0xbff20f3452163cfa, 0xbfc3cab2991b1518,
    0xbfec0a0ad2738b00, 0xbff93ed1bb7a6b93,
    0x3fe0e5b09d1558d0, 0xbfe81f926e999f9c,
    0xbfe21850592b6aff, 0xbfedc6a57eb03e2a,
    0x3fe46476cff86059, 0xbff7ae1e909a2529,
    0x3fbcb42e8cba5182, 0xbfc9b32c5f8c7902,
    0xbfe7550d709ea344, 0x3fd7086297cacef1,
    0x3f935db5c4292050, 0x3ffe7cb4d292bfd2,
    0xbfed1b4ed795de46, 0xc004a78675209af2,
    0x3ff8546f98a2ac7a, 0x3ff74903ab872380,
    0x4001b612118a1a19, 0x3feea6028605ac71,
    0x3ff7bfc246a317ca, 0xbff5f4087ab2e119,
    0xbff9f8bda50f8bcd, 0x400d8aaae49de301,
    0xbffda2175df810ca, 0x3fec46433991fb16,
    0xc00ac7fb9087f062, 0x3ff73a166c5996fe,
    0xbfe734e8491cecfc, 0xbff43a665ef05396,
    0x3fde5d09eb428e94, 0xbff8534833a04975,
    0xbff4aaad8ec00d2b, 0xbfede9790b4a516a,
    0x3fdbe277286df326, 0x3ff5fdf8e0ed1176,
    0xbff81daf7a6ad912, 0x3ff6f427409e94fc,
    0xbfe6ae337343072a, 0x3ff3eb0da52eed36,
    0x3ff7ae56f1e5518f, 0x3ff5b712b03cef50,
    0xbff509bc1d7f0ec8, 0xbfd98f38ba50e47e,
    0x3fd91cf3cfaf2e34, 0x3fea06ad01a6bc7b,
    0xbfe157fc88697c23, 0x3fd7fa18a68c1f08,
    0xbfe2efcdd4a4634f, 0xbfbc61daf6a666bf,
    0x3f947f205875a850, 0x3fc3f8056ae3eda8,
    0x3fb0e39b14125eec, 0x3fd58e242915c6c5,
    0x3feef09360fa10a2, 0x3ff190756ee312f6,
    0x3fe779d77f72e18f, 0xbfd1f0bb0b119a90,
    0xbff4247e510bdaab, 0xbfd4f402316a5df6,
    0xbff0b786dca1cb0e, 0x3fe38f6e53be5036,
    0xbfe9d6c9afb8e15b, 0x3ffaf03f8b2f0230,
    0x3fcdceaf881355b8, 0xbff3663517dc79cd,
    0x3fe510e0878aef9a, 0xbfec3c8e85af7715,
    0xbfed4e20556eb2bd, 0x40064bd6982bda51,
    0xbfd36be43b0ca5e2, 0x3ff9807dc7abad32,
    0xbff12f29e82617a0, 0x3fe1cf8cfec4f17c,
    0x3fe28a25ec5ff98b, 0x3fd4c9f21bc39786,
    0xbfd805db8e0a0ff2, 0x3ff5d5c53df012d6,
    0xbff1ddd393f42588, 0xbfdde08f115cd89b,
    0xbfe5c7c1917b6de0, 0x3fa6ba72954b7cc0,
    0xbffac3021214a286, 0xbf87fd8e6a27dd00,
    0xbf98f7e217f1f1e0, 0x3fa7be458cdad8f0,
    0xbfce0b6db0c26d14, 0x3fefeca5643d5f14,
    0x3feb9d02dc79eb50, 0xbffc0b03ae2558df,
    0x3fd07b0eabb5cf44, 0x3ff3a9b75256bf1c,
    0xbffb41e74494470d, 0xbfe08a6ac2ae995c,
    0xbfef0e54561db9d7, 0xbff38d12afbb9679,
    0x3ff400874d480a01, 0xc0015d19fbf352c3,
    0xc001993c44950eb7, 0xbfc708cbb3572bc4,
    0x3ffb1dc3bba494fc, 0xbfe67b9098b2e425,
    0xbfe08d39bacee5bf, 0x400031b97fe671a3,
    0x3fe50760913b291d, 0xbff4f66298a75070,
    0x3fefaef30cb65c97, 0xbff1e647052b756e,
    0x3fe8ccc022464855, 0x3fe3a1bfcdf9acb0,
    0xc00001978c5244a2, 0xc0006ebad3ad7e40,
    0xbfd19cb74803d2a0, 0xbff1482160d838d8,
    0x3ff0480b8faeed74, 0xbfdb83b8fc45a64a,
    0x3fbca94dce8ce8f4, 0xbfc07dff361742a0,
    0xc0011cfb8b23f927, 0x3fc7cacc88d3b488,
    0x3fe654b35a069a7a, 0xbff1e57b89b31284,
    0xbfe5c1e0093b1ec3, 0x3fea7f35f2ee691c,
    0x3ff17acc2c7f60bf, 0x3ff7c66c9de4a78e,
    0xbfe2fd9600fcc967, 0xc0003bb8fce5461e,
    0x3ff3a42eac355724, 0x3fe06ea40a7ae6b2,
    0xbff372a1c045befd, 0x3ffc745b71050f06,
    0xbffba8468213da0a, 0x400121555f4fe321,
    0x3ff78725d0e2921a, 0x3ffae9666bdfeb3e,
    0x3fe54dc626cecdec, 0x3ff6e2561ecadf71,
    0x3fe65078e27c37f2, 0xbfe756524af68ba5,
    0xbfd6ad544cdc2e54, 0xbff58a84c96e49fc,
    0xbfd2639472de9325, 0xbff839b5bb662e6b,
    0x3fd882a4b0973d48, 0xbfeefa6146dcbab0,
    0x3feaa8d56d383164, 0xbfe345038dcd7f99,
    0xc00071b92e183953, 0xc0050e2421b6b027,
    0xbffb03bb679bbde7, 0x3f94ec5529011c78,
    0x3feb510f31815217, 0x3fdefd2d2b6a06a6,
    0x40028618ffe80619, 0x3fc22b17903f0648,
    0x4000b68cbe6d8d16, 0x3fd11928607c6a1c,
    0x3fef0944c5410c28, 0xbfe1acd9a78c368d,
    0x3fa1d2fabe4e37a8, 0x40000865b88d9b63,
    0x3fd25f444aa0831a, 0xbff2018693788c23,
    0xbffb20ade92b8e9c, 0xbfa1d127582c6040,
    0xc000c15a2f619d16, 0xbff767e834ee082f,
    0xbf94dd4453763738, 0xbfe17f8de43a47c6,
    0xbfece5004cab3014, 0x3fea1f06dd3721e6,
    0x3fd0c60556498202, 0xbfea59df0235ad6e,
    0xbfe08f617ec06364, 0xc00436aca95abb06,
    0xbfeb8e3fe1dd27d1, 0x3ff81faa61beb28e,
    0xbff65bceac915c86, 0xbfe15b6eacdee6e4,
    0x3fe1e798f575e5de, 0x3fe0ed634dae4457,
    0x3fe5395c36ecc4c8, 0x3fe241f2b6569232,
    0xbff031bb70dd3745, 0xbfe799305f1c3fb0,
    0xbfe35fc045f8cf55, 0xbfdcb0e8cae6b869,
    0xbfea9479d93b477f, 0x3fe329a65755d6c0,
    0x3fed86c36ffec033, 0x3fe985214f719552,
    0x3ff949ace48ddc26, 0xbfb0c636177da1b8,
    0xbff32f7d373b7390, 0xbfcc0f4702b30c0b,
    0x3fdcf209133bc26b, 0x3fc09068091a7d86,
    0x3ff07fb780bfa61b, 0x3fc551058e010e70,
    0xbff026ccb2c98e07, 0x3feb5ec0dad3bdec,
    0xc0034bda027e170c, 0x3fd19f02c11adc9c,
    0x3ff7336fb5406730, 0xbff3626cc47e0c7a,
    0x3fd2a285b1d069d6, 0x3fd42640bd261298,
    0x3fd87f1f48e1a378, 0xc000b56a205944fa,
    0xbfc821c656318b21, 0x3fbcc1c3d777cef4,
    0xbff5fd21e65c8d68, 0x3fd6a140f6f3924a,
    0xbfe7e096c147d310, 0xbff8c5b7275112c3,
    0xbff0c794017de5f8, 0x3ff16b3922a2176e,
    0xbff18c81916b3ec6, 0x3fee65fdd0c1df50,
    0x4003afd74f456ba0, 0xc006dbd7604aaf62,
    0xbfd9ae6935d67eca, 0xc000d82f1965f1c8,
    0xbff4cea1fe74a1d2, 0x3fda3f81bcafc46b,
    0x40009d60a0311f82, 0x3ff598b2b3289b40,
    0x3fd1b89eed679204, 0x3fb2d69bb5643a00,
    0x3ff0d9f648884771, 0x4003062cf81227e0,
    0xbfd5b11e706f11cf, 0x3fb12b341802ee3c,
    0x3fef013fe274e8d2, 0x3fe6482b8f2bffd4,
    0xc00152b4ad904f98, 0x3fea8abdef4f3a44,
    0x3fed8fa2a121b1b8, 0xbfd36adab9373ed8,
    0x3ffe806fecdbe1f3, 0xbfe8c84df48b82fb,
    0xbfd5d27a88386d68, 0xbff2a8c5e3013440,
    0x3ff414002a9bc26a, 0x3fd3f0cd8098e3e0,
    0x3fe5b5a3e99d6306, 0x3fd7f4490b44e97a,
    0xbff7600f6dcac75c, 0x3fea20c1033d5464,
    0x3fe9938c705bb44e, 0x3ff61733428d8630,
    0x3fdf76a8302a7972, 0x3fecd971b75f6c92,
    0xbfd82ffddb032535, 0x3fc753c75d385a1c,
    0x3fe4202801bad9ad, 0xbff304b6fd59c88c,
    0xbfed355f9c5f3127, 0x3fcede9043955ed5,
    0xbfc1c535eed7f8bc, 0xc0013bc794bd2531,
    0xbff39b83154bb7a3, 0xbff2d295115bed53,
    0xbfef8b3a0bee155c, 0x3ff227a3cdf6a6de,
    0xbff3a98fd579ed2a, 0xbfeab69136b5d626,
    0x3fe7c1d2e282fdc7, 0xbfdb4d93a0490a03,
    0xbff0b3204bf8be27, 0x3fd0164c9e71e6bc,
    0xbff63bff9d503f0c, 0xbff5143f229f13c0,
    0xbfe58ef0d44b5e58, 0x3fcebfe4e3cc4d43,
    0xc005e1b87d87c0c9, 0xbfdaed83d3b5ae40,
    0xbff8001d36ac0edd, 0xbff259054b2df31a,
    0xbfd881a40ee68d3c, 0x3fe2240a6969f310,
    0x3fd068d1eef1c94a, 0x3fd1b36ee67888f5,
    0xbff0499b7e1fdf38, 0x3fe5367737e5abef,
    0x3ff1deb81b4ec196, 0x3fd468c1a2faf982,
    0x3fe49857400c04ce, 0xbffcd487c64b2d62,
    0xbfbb5b7a409fe940, 0x3ff670a082066318,
    0x3feba7a8795af637, 0x3fe55ec309baa0cc,
    0xbfffd5b57592e149, 0xbfe462208ad86b8e,
    0x40083ad264555890, 0xc008950e3d529488,
    0x3fbcd82cbf3919d8, 0xbff25bbf4394e87c,
    0xbff5a87dc48a7bfe, 0xbfc799deed698ede,
    0xbff44b5d933b9112, 0x3fdafe95ac35c242,
    0xbfaebb46d4a790e0, 0xbf964c78e4d0fe90,
    0x3fe46a25675a7830, 0xbfdf276e83917dc0,
    0x3feff57b4caab14e, 0xbff757df8bbdb9ae,
    0xbff6c30cb1bce591, 0x4011c78ac290cc6a,
    0x3fe4f0203d199742, 0xbfd216b9d07d06c7,
    0xbff119c883bed6af, 0xbff30a480c58c006,
    0x3fff9b91f546eef4, 0xbfefe67328cad539,
    0x3fd321951103d77c, 0xbfe64bde38f409f8,
    0x4005c85d46784ae6, 0x3fe5a4b4085619f0,
    0xbfe6c0ef4ac46678, 0xbff326c12d801852,
    0xbfc50294be9b7aa0, 0x3fe0233916bd4930,
    0xbffaad45455d0d7e, 0xbff87a21b736cc66,
    0xbff0f4470105884e, 0xbfe10fbf16688d9c,
    0x3ff0bfc3d3c05be4, 0x3fdb99df14feadd0,
    0x3fd12a1d53c6c54a, 0xbfed9a5ff2892f2f,
    0xbfe300900819a872, 0x3fe523159b5c33d8,
    0xbfe1f127e36df6d6, 0xbff92a04665b31a6,
    0x3ff0b87d95d4b4cb, 0xbffecee10fbb9b37,
    0x3fd4e98f5570beb8, 0x3fe10d699e2ad6ff,
    0xbfb87d0b24d317e0, 0xbf87ff36c4252720,
    0xbff962752b66b094, 0x3fd5c02657bd2363,
    0xbfe6accab8a7e215, 0xbff36f228b8ab57d,
    0x3fe240a48cb96f83, 0xbfe70216f6bcec2d,
    0xbfc7c33884769458, 0x3fcae33834a2204f,
    0xbfda01d2dee40074, 0xbfee27587022ae46,
    0x3fe8610fb516d4ea, 0x3fd4e84b1086d345,
    0x3ff90f94282cc4c6, 0x3fb91fca274f598c,
    0xbfe540013bd03b7a, 0xbfe35e0cfc721eef,
    0xbfebdd65b5a22b53, 0x3ff2f4c8e574ca46,
    0x3fc002b2788636dc, 0xbff2a542d597f684,
    0xbfe0e065bf13e696, 0xbfe5d659b2c2f363,
    0xbfdd5e72ea81750b, 0x3faf2a3f7a6df6a8,
    0xbff034697f6f5478, 0xbfe7d8f80f5f5767,
    0x40024986ca6e2739, 0x3fe0c75870e5610c,
    0x3fe2a46c0d637e43, 0x4000a4cae0c78864,
    0xbfe34345fc4eb4af, 0xbfc5913aeb753522,
    0x3fdddd6d6db02beb, 0xbff211ccf975bd3e,
    0x3fec28ed1204a526, 0x3fef1c9568349362,
    0xbfe9b7f56c532261, 0xc002d0177d5487c6,
    0x3f9417789d5815d0, 0xbfbe4aa250a21488,
    0x3f7ea141345b3540, 0x4003dcfebd203c0f,
    0x3ff2dc7a9efe6e28, 0x40045edac1dfc0b9,
    0xbfe655ff6f91b2b4, 0x40062285be0f8e74,
    0x3ff2cec88a1868b8, 0x3fde57d81d178b92,
    0x3fe83bd1e0de4721, 0x3fe868d8be4ad3da,
    0xbfe7c014a91e7a3a, 0xbfc0892a4a963335,
    0xbfff725253020c09, 0x3fca6193a28db6f0,
    0x3fe64844f0a6961c, 0xbff0021ee35ce7cf,
    0x3ff15a9dee503226, 0x3fd1a1ef4c3908e6,
    0xbff3ea77d1bf249e, 0xbfc46329cb22162c,
    0x3ff5ce65eca8f33e, 0xbfe2cb1ad00470ad,
    0x3ff65c3deb8570c1, 0xbfe8666e15bd6770,
    0x3fe041976454558b, 0xc01003ddd6c644d7,
    0xbfb6fbf6f2756328, 0xbf7ae076cd2c6a80,
    0x3fefebc46b43d352, 0x3fe111947273a712,
    0xbfbde8dbb19a9880, 0x4004b4a31338e0a3,
    0x3ff0f980edcdab01, 0x3fd69ac3a52a5b96,
    0xbfb6cf5ac0726380, 0x3ff5e7da49cf98c2,
    0x3ffd89cf329ff208, 0x3fff00bf90a27496,
    0x3fde19c901947d5c, 0x3fc4f33d0ffc94e2,
    0x3fc756aa2b9753fc, 0xbfce74037c6586f0,
    0x3fe504dbfde542bb, 0x3fedfd78726763eb,
    0x3fe6e89edeb5e5dc, 0xc000be402155dbb6,
    0xbfe13d5a85e99770, 0xbfdceda0362f3cbd,
    0x3fc47b7551f8acf8, 0xbffc954f56571750,
    0xbfdff89037c339b8, 0x3fe27e5c45007c3a,
    0xbfedaa56a8dc2f5c, 0x40075d6468447f90,
    0xc0037edc4c2b9336, 0xbfe3df7a33751cdd,
    0x3fe7f2fe4469ff5a, 0xbfa2088975ee98f0,
    0xc0017bf599bb68d0, 0xbfc7ab798b480bdc,
    0x3fbc5bc82c60a910, 0x3ffce4a543e98868,
    0xbff10ccbae3c3c45, 0x3fec0077a1aeb7fa,
    0xbfd3f6bca3835a8e, 0x3ff49b92be15f51f,
    0xbff7a1aa1fb88f9e, 0x3fe44498f1dc7dd4,
    0x3ff5b7fd3f98d450, 0x3ff0b40a1379e5fe,
    0x3fece8cf536e75fe, 0x3fd479be85c12b69,
    0x3ff3a8e38eecb628, 0x3febd8e43e9f58c9,
    0x3ffa7d99e395ae81, 0x3ffb73ed97f77bba,
    0xbff4677168b0bc52, 0xbff8a7ef2a3ac382,
    0xbfe8bd0931ed301b, 0xbff9988150a62ed8,
    0xc002ff542d2cfaf6, 0x3ffc05cf1bc584f2,
    0xbff7cae3d668be3a, 0x3fb8f6bfa1a88944,
    0x3ff45fdeb1e400f0, 0xbfc2cce91627e850,
    0xbfaefa07c1e8e890, 0x3ff0bf98e431441e,
    0x3ff16192fe318f46, 0xbff585136ae1006e,
    0x3ff01140ad3df068, 0xbfe654a46e64e8b5,
    0xbfedf8886acbe776, 0x4000334415442e91,
    0xbfa9046268636110, 0x3fde20ab4e4d2d55,
    0x3fefb4ad6b5903f7, 0x3ff1ef43456944c3,
    0x3fe6786c6d522b98, 0xbfd5526e104d817c,
    0xbfcf4636f88583c0, 0xc0011c5396f36d9a,
    0xbfd528a9863faced, 0x3fe01e6c9fcd4af2,
    0xbfe65cddd57f08c6, 0xbfe74bbb97f130a7,
    0xbff5e1b6371a9bc5, 0x3fe38a24a9dca040,
    0xbfd4ea67b3a1ee03, 0x3fd8a35fc0ce1b4f,
    0x3fefe0fec818204d, 0x3febb10c5d7eaba8,
    0xbfd0d7276322acc1, 0xbfa45508b575fdf4,
    0x3ff8937fd8e69a44, 0xbfd6e5f369833a39,
    0xbfe1333816afbfa4, 0x3fe53ed6930fa413,
    0xbffa5e6b41a97fac, 0x3ff4e05a8fafa85b,
    0x3fe802b47b20e3c8, 0x3fd7e033674f8801,
    0x3feb34bba320fbcc, 0xbfffb781bd8305b6,
    0x3fe1f8472aae49b2, 0x3fbf1a02c865e6f8,
    0x3fccecae0c5654dc, 0xbff5151ce06799bf,
    0xbfd8d428e78ea09c, 0xbfc50890c35fd996,
    0xbfda5a6f976b0cc6, 0x3fe36c28fd18d00e,
    0xbfe88706e580e2ee, 0xc001f51254e77eaf,
    0x3ff2f16f5b7b43e2, 0xbfa201e197c579e0,
    0x3fc69a14112ec85c, 0xbfe8ea3aa18a15a9,
    0xc0011c21449e8c15, 0xc0050873c43ec51c,
    0x3fba6b95936bcd40, 0xbff0901600729556,
    0x3fcce348da9fcf74, 0x3ffba089ff1e6f57,
    0x3ff6a9186454c6c6, 0x40765a4be82bf96a,
    0x3fedae235b31fba5, 0xbfc35ec19f45cd78,
    0xbfccc6477037928c, 0x3fdbe9800dc7fc60,
    0x3fc46e11ac34f3b2, 0x3fd31fc3a7634ca8,
    0xbfd30fb5cc4f7d2c, 0x3feed47558684668,
    0x3fff5f303ccd1748, 0x3ff1b12d6142b1a2,
    0x3fd02be2aab5ccae, 0x40001506d34e1a35,
    0x3ffb577e5fc84a1d, 0x3fc8f34dc4437684,
    0x3fef88f535755c3d, 0xbff7de439f4d2262,
    0xc0002a6c5ac8b52f, 0xbfc53f4411bb5972,
    0xbff587df9a6ffa48, 0xbfd191917c3da19e,
    0x40020e16329bf5c8, 0x3fe6a1bb11f90efa,
    0x3f84c237d6320d80, 0xbffe6fd66f5c056d,
    0xbff894622bda6f0a, 0x3fe8aabbb7fb1941,
    0x3fdb8768867b58d1, 0xbff31cef7e4e5462,
    0xbfe00a56870c5ea6, 0xbfb3eb57adc5b530,
    0xbfe2b780d2bfcff2, 0xbfbfc371ddf2598c,
    0x3ff217d1be07a07f, 0xbfea54875d0f400e,
    0x3feeec477db6ce48, 0xbff030792a574f24,
    0xbfdc15258f8c85bb, 0xbfc80429e47fce18,
    0x3ff503806db0a7f1, 0xbff80c476528330f,
    0x3fe717ecb5be043a, 0xbff33fc57c42248e,
    0xbfc48b3ec008f0ad, 0x3ff1e221c1ffc49d,
    0xbfd16e84ab6cdaa8, 0x3fea318e59f73cec,
    0xbfe00d240a71dbbe, 0x3fdbb598771f78e8,
    0x3fe4eae9a981f0ea, 0xbff05e6f5c962ab2,
    0xc003791b81db60dd, 0xbfe39aa1234c8ebe,
    0x3fee6654a7375c67, 0xbfbef6f8b37386b0,
    0x3fa3ad5cd8d13744, 0x3fae547451ffa8e0,
    0x3ff56864970db360, 0x3ff20cecaf5cf41c,
    0x3fe2493ec7628080, 0x4001200c18b1958b,
    0x3fef96a027bbedf8, 0x3fdd3edca95d1912,
    0xc00a95357f02473c, 0x40041be5d6ecaca0,
    0x3fec7c01d919a4a4, 0x3ff833e5e3fbe68a,
    0x3fb82867e5d04b48, 0xbfe2508bc4b32533,
    0xbff4cee0f0ee79d6, 0x3fd33645d012303b,
    0x400135b3c5df9656, 0xbff46ce544fd2378,
    0xbff84e7f48317bf2, 0xbfdaa461e0f4b8f8,
    0xbfe02b8a846ac0fe, 0x3ff3c37322c2a814,
    0x3fd422a07b44f50d, 0xbfd470a43862f128,
    0xbfd266a36400c2c3, 0xbfd0d5a114efdff7,
    0xbfea5a9477b59ae1, 0x3fe44438dd808bb3,
    0x3fea57166140aede, 0xbff8ab5fe85168b3,
    0x3fd05319d9aab4fe, 0xbff80e16f09a98fd,
    0xbfe95b6b95713806, 0x400800e94dae42d0,
    0x3fdb17a437e1bfe1, 0x3fde9c84e39325cd,
    0x3fff290d25e3e44a, 0x3fd2acb9bafdaf00,
    0xc0034902e4753d56, 0x3ff9434c95c2d410,
    0x4002ffe4b162ca2b, 0x3fe73945fbcff8b9,
    0x3fea3e3c1bb60352, 0x3fde6d53fa8a9751,
    0xbfd207a1b02e7ad2, 0x3fc74b4b4c2afc70,
    0x3fd6f99a3f5f2282, 0x3fd63f527088a8ee,
    0xbff13d601fb42936, 0xbfcac420153d5ad5,
    0x3fd4039ddc16f0b0, 0xbfe919d8758bbc94,
    0x3ff15c853f3267c9, 0x3ffa85c1ec9259d2,
    0xbff75ea00d36767e, 0x3fce342e84399470,
    0x3fe8431dc9e4c8bb, 0xbff0629b2014f33f,
    0x3feb319fd62533b3, 0x3fd469d2183f4bda,
    0xbfe7cc3564d2ed65, 0xbff2928db3a5d6a9,
    0xbff189d7f1125764, 0x3ffb1fe360fb1cca,
    0xbfe96aa3b4393ac6, 0xbfe64fa1e7966efe,
    0x3f8c48bef4c6f940, 0xbff2efaf7a7602d2,
    0x3fe61230916a9b28, 0x3ff5b6987d81d0b6,
    0xbfefdc5da59bb6c0, 0x3ffdab34b59db556,
    0x3fc08e22839cb380, 0xbfe4642544e73001,
    0xbff67151b7f1fea2, 0xbfebf2e51eaa75ef,
    0xbfe7c2684cbc78ba, 0x3fa491c9d61257ac,
    0xbfe007f27d85c334, 0xc0082b6eaaf9322a,
    0x3ffc356c9e309bb3, 0xbff21d5b0c041c80,
    0x3fd8c55b078352c3, 0x3fe86bb743ba1b8b,
    0x3fd4ce1151df2f18, 0x3ff49f4384026557,
    0x3fcf77081988fa48, 0x3fc8ddd31abd10e0,
    0xbffa06b5cb4aeeb5, 0x3fec32b7e2eaa80d,
    0x3feb2559f74e325c, 0x3ff601ae08527b36,
    0x400032d13f1c7fca, 0xbfe4720fcddfa14a,
    0x3ffe8d064c901162, 0xbfce60f9a1e8a604,
    0x3fe84e4f0f59b42a, 0xbfeca3901a800f5c,
    0xbf9bf8c184b2d2b0, 0x3feec01107ba1325,
    0xbfe87147ef4fe5ab, 0x3ffad3899e5f23f3,
    0xbffd641ff04b5be0, 0x3fed878037f57df9,
    0x3fe71ef0d6fc1933, 0xbfefa4694968c40d,
    0xbff6cbace4ace092, 0x3fecd4c33068bc96,
    0xbfd4bdb6f674ddd5, 0xbfe029f2d8fc0352,
    0xbfeadbd837f2b849, 0xbfcf6f290e953700,
    0x3ffc1f8773fa1302, 0xc00254eb58fa2876,
    0x3fda47c52599e56b, 0x3fe120e1bf8e9df8,
    0x3ffa01eadc57866e, 0x3ff48c2f15c5115a,
    0xbfea4db258e37d85, 0xbfe331f2d44757c2,
    0xbfda43cd33c91552, 0x3fdb46aaa64a5a88,
    0x4003b197753da386, 0xbffa65d60ac2bf25,
    0xbff0a6ae33748e5c, 0x3fe8146a049ad4bc,
    0xbff910a79d419d63, 0xbff44acb3350645c,
    0xbfe5ca42c642b88b, 0x3fe0fffb456bb3f6,
    0x3ffed84c4b88526e, 0x3fe128f8803f34e7,
    0xbfe628d8d09b8275, 0x3fe5d37a75aeb91c,
    0x3fb2e60eb5de53b4, 0x3fb9e561fa99b442,
    0x3ff84b2cd2b69aaf, 0x4006ccf0ae51fcd0,
    0xbf8e185e8665c980, 0x40004b2bd2c9e670,
    0xbfebc62645f375bc, 0xbff3d713c42ba8c5,
    0x3ff86be22b9f97a2, 0xbff594a423910160,
    0xc0084c2a54361253, 0xbfe865acd20c73ce,
    0x3fe8548954eb9b46, 0xbff15a7eee41800d,
    0xbff4297d549baf22, 0x3ffa14ac7b8a683f,
    0x3fee9ca93139c11d, 0xbfd411b4c00ab4f4,
    0xbfe4754f22374d9c, 0x3fba8e98dba325b0,
    0x400fcee81948bcaa, 0x3fd9399a4bb38dcc,
    0x3ff643e770c705b9, 0x400a199f05fe0a2f,
    0x3fc5cc141986a818, 0x3fde72db401f87b3,
    0x3fdbdaceba154024, 0xbfcf8fdd3ddbe022,
    0x3fb0f6e90bee072b, 0xbfe3c3409e4a0c34,
    0xbfe44d51ee93f149, 0xc0047f7c6f7250e2,
    0xbfe9555e3b152ff2, 0xbfc993ec5cfacc48,
    0xbfb4809dcbc3e240, 0xbff485361022b502,
    0x3fd652b9ffe08c04, 0xbfd6a722e768240c,
    0x3ff8fc3bbe8b65d9, 0x3fcdf209f87e0092,
    0xbfdfd48a065a3741, 0x3f937152284114e0,
    0x3ff13304ef9ef443, 0x3ffedad84b42ca1e,
    0x3fe5099f2c4ad384, 0x3fdeadc42c9e72c3,
    0xbfebe60553366c1d, 0x3fb82e952f16c17c,
    0xbff96904e0706a89, 0xbfe7da13d486c986,
    0xbff0b2a9873df302, 0x3ff6fd27dfb965ee,
    0xbfd95df2f569596a, 0xbfe27bb461f8c71a,
    0x3ffe32d6f1fc1205, 0xbfe21360ec93563c,
    0x3fbc67431e9e32dc, 0xbfe540c44e264c6e,
    0x3fe8770854d5ff1b, 0x3fd553eece5be5e0,
    0xbfe4c343702ff057, 0xbfa67a79bc9cf72c,
    0xbff0169c9deec3c4, 0xbfeac565e960faa1,
    0x3ffa74b3b71806aa, 0x3fdd3925c4b06a25
    };

static const uint64_t ref_cfft_noisy_1024[2048] = {
    0x3ff654f627f9c034, 0x0,
    0x3ffa74b3b71806aa, 0xbfdd3925c4b06a31,
    0xbff0169c9deec3c6, 0x3feac565e960fa9e,
    0xbfe4c343702ff05b, 0x3fa67a79bc9cf7a4,
    0x3fe8770854d5ff1c, 0xbfd553eece5be5ec,
    0x3fbc67431e9e32f4, 0x3fe540c44e264c6c,
    0x3ffe32d6f1fc1202, 0x3fe21360ec935635,
    0xbfd95df2f569595c, 0x3fe27bb461f8c719,
    0xbff0b2a9873df302, 0xbff6fd27dfb965ef,
    0xbff96904e0706a88, 0x3fe7da13d486c982,
    0xbfebe60553366c1b, 0xbfb82e952f16c168,
    0x3fe5099f2c4ad37d, 0xbfdeadc42c9e72bd,
    0x3ff13304ef9ef441, 0xbffedad84b42ca1e,
    0xbfdfd48a065a3744, 0xbf93715228411560,
    0x3ff8fc3bbe8b65db, 0xbfcdf209f87e0086,
    0x3fd652b9ffe08c02, 0x3fd6a722e768240c,
    0xbfb4809dcbc3e250, 0x3ff485361022b502,
    0xbfe9555e3b152ff1, 0x3fc993ec5cfacc50,
    0xbfe44d51ee93f14a, 0x40047f7c6f7250e2,
    0x3fb0f6e90bee0733, 0x3fe3c3409e4a0c34,
    0x3fdbdaceba154025, 0x3fcf8fdd3ddbe026,
    0x3fc5cc141986a812, 0xbfde72db401f87b1,
    0x3ff643e770c705b7, 0xc00a199f05fe0a2e,
    0x400fcee81948bcaa, 0xbfd9399a4bb38dd1,
    0xbfe4754f22374da2, 0xbfba8e98dba325b0,
    0x3fee9ca93139c11c, 0x3fd411b4c00ab4f5,
    0xbff4297d549baf22, 0xbffa14ac7b8a683e,
    0x3fe8548954eb9b47, 0x3ff15a7eee41800c,
    0xc0084c2a54361254, 0x3fe865acd20c73ca,
    0x3ff86be22b9f97a0, 0x3ff594a42391015f,
    0xbfebc62645f375c1, 0x3ff3d713c42ba8c5,
    0xbf8e185e8665cb00, 0xc0004b2bd2c9e670,
    0x3ff84b2cd2b69ab0, 0xc006ccf0ae51fcd0,
    0x3fb2e60eb5de53ac, 0xbfb9e561fa99b460,
    0xbfe628d8d09b8272, 0xbfe5d37a75aeb91e,
    0x3ffed84c4b88526e, 0xbfe128f8803f34e9,
    0xbfe5ca42c642b88e, 0xbfe0fffb456bb3f6,
    0xbff910a79d419d62, 0x3ff44acb3350645c,
    0xbff0a6ae33748e5c, 0xbfe8146a049ad4bd,
    0x4003b197753da385, 0x3ffa65d60ac2bf27,
    0xbfda43cd33c91555, 0xbfdb46aaa64a5a87,
    0xbfea4db258e37d84, 0x3fe331f2d44757be,
    0x3ffa01eadc57866f, 0xbff48c2f15c51158,
    0x3fda47c52599e56d, 0xbfe120e1bf8e9df7,
    0x3ffc1f8773fa1302, 0x400254eb58fa2876,
    0xbfeadbd837f2b849, 0x3fcf6f290e95370e,
    0xbfd4bdb6f674ddd3, 0x3fe029f2d8fc0351,
    0xbff6cbace4ace091, 0xbfecd4c33068bc91,
    0x3fe71ef0d6fc1934, 0x3fefa4694968c40d,
    0xbffd641ff04b5bde, 0xbfed878037f57df7,
    0xbfe87147ef4fe5ad, 0xbffad3899e5f23f4,
    0xbf9bf8c184b2d330, 0xbfeec01107ba1328,
    0x3fe84e4f0f59b42b, 0x3feca3901a800f58,
    0x3ffe8d064c901162, 0x3fce60f9a1e8a60c,
    0x400032d13f1c7fca, 0x3fe4720fcddfa14c,
    0x3feb2559f74e3260, 0xbff601ae08527b34,
    0xbffa06b5cb4aeeb4, 0xbfec32b7e2eaa80d,
    0x3fcf77081988fa34, 0xbfc8ddd31abd10ec,
    0x3fd4ce1151df2f10, 0xbff49f4384026554,
    0x3fd8c55b078352d0, 0xbfe86bb743ba1b8e,
    0x3ffc356c9e309bb2, 0x3ff21d5b0c041c81,
    0xbfe007f27d85c334, 0x40082b6eaaf9322b,
    0xbfe7c2684cbc78ba, 0xbfa491c9d61257a8,
    0xbff67151b7f1fea4, 0x3febf2e51eaa75f0,
    0x3fc08e22839cb380, 0x3fe4642544e73000,
    0xbfefdc5da59bb6c2, 0xbffdab34b59db556,
    0x3fe61230916a9b27, 0xbff5b6987d81d0b6,
    0x3f8c48bef4c6f880, 0x3ff2efaf7a7602d2,
    0xbfe96aa3b4393ac4, 0x3fe64fa1e7966eff,
    0xbff189d7f1125763, 0xbffb1fe360fb1cc8,
    0xbfe7cc3564d2ed5e, 0x3ff2928db3a5d6a9,
    0x3feb319fd62533b3, 0xbfd469d2183f4bd0,
    0x3fe8431dc9e4c8bc, 0x3ff0629b2014f341,
    0xbff75ea00d36767d, 0xbfce342e84399470,
    0x3ff15c853f3267c8, 0xbffa85c1ec9259d0,
    0x3fd4039ddc16f0a0, 0x3fe919d8758bbc94,
    0xbff13d601fb42938, 0x3fcac420153d5ad0,
    0x3fd6f99a3f5f2288, 0xbfd63f527088a8f0,
    0xbfd207a1b02e7ad0, 0xbfc74b4b4c2afc74,
    0x3fea3e3c1bb6034e, 0xbfde6d53fa8a974a,
    0x4002ffe4b162ca2b, 0xbfe73945fbcff8b9,
    0xc0034902e4753d56, 0xbff9434c95c2d410,
    0x3fff290d25e3e448, 0xbfd2acb9bafdaefe,
    0x3fdb17a437e1bfde, 0xbfde9c84e39325c4,
    0xbfe95b6b95713808, 0xc00800e94dae42d1,
    0x3fd05319d9aab506, 0x3ff80e16f09a98fd,
    0x3fea57166140aedd, 0x3ff8ab5fe85168b3,
    0xbfea5a9477b59adf, 0xbfe44438dd808bb2,
    0xbfd266a36400c2c8, 0x3fd0d5a114efdff7,
    0x3fd422a07b44f506, 0x3fd470a43862f12a,
    0xbfe02b8a846ac0ff, 0xbff3c37322c2a812,
    0xbff84e7f48317bf3, 0x3fdaa461e0f4b904,
    0x400135b3c5df9656, 0x3ff46ce544fd2376,
    0xbff4cee0f0ee79d7, 0xbfd33645d012303e,
    0x3fb82867e5d04b3c, 0x3fe2508bc4b32535,
    0x3fec7c01d919a49e, 0xbff833e5e3fbe688,
    0xc00a95357f02473d, 0xc0041be5d6ecac9f,
    0x3fef96a027bbedf4, 0xbfdd3edca95d1910,
    0x3fe2493ec762807c, 0xc001200c18b1958b,
    0x3ff56864970db361, 0xbff20cecaf5cf41c,
    0x3fa3ad5cd8d13720, 0xbfae547451ffa8b0,
    0x3fee6654a7375c66, 0x3fbef6f8b37386a8,
    0xc003791b81db60dc, 0x3fe39aa1234c8ebd,
    0x3fe4eae9a981f0e8, 0x3ff05e6f5c962ab0,
    0xbfe00d240a71dbc0, 0xbfdbb598771f78e4,
    0xbfd16e84ab6cdaac, 0xbfea318e59f73cf2,
    0xbfc48b3ec008f0b2, 0xbff1e221c1ffc49e,
    0x3fe717ecb5be0439, 0x3ff33fc57c42248e,
    0x3ff503806db0a7ef, 0x3ff80c4765283310,
    0xbfdc15258f8c85b4, 0x3fc80429e47fce0c,
    0x3feeec477db6ce4c, 0x3ff030792a574f25,
    0x3ff217d1be07a07f, 0x3fea54875d0f4011,
    0xbfe2b780d2bfcff1, 0x3fbfc371ddf25990,
    0xbfe00a56870c5ea8, 0x3fb3eb57adc5b560,
    0x3fdb8768867b58d1, 0x3ff31cef7e4e5461,
    0xbff894622bda6f0d, 0xbfe8aabbb7fb1940,
    0x3f84c237d6320dc0, 0x3ffe6fd66f5c056f,
    0x40020e16329bf5c6, 0xbfe6a1bb11f90ef7,
    0xbff587df9a6ffa47, 0x3fd191917c3da1a2,
    0xc0002a6c5ac8b531, 0x3fc53f4411bb5968,
    0x3fef88f535755c3c, 0x3ff7de439f4d2261,
    0x3ffb577e5fc84a1c, 0xbfc8f34dc4437670,
    0x3fd02be2aab5ccaa, 0xc0001506d34e1a36,
    0x3fff5f303ccd1748, 0xbff1b12d6142b1a3,
    0xbfd30fb5cc4f7d2c, 0xbfeed47558684664,
    0x3fc46e11ac34f3a2, 0xbfd31fc3a7634ca9,
    0xbfccc64770379286, 0xbfdbe9800dc7fc6a,
    0x3fedae235b31fba2, 0x3fc35ec19f45cd70,
    0x3ff6a9186454c6c6, 0xc0765a4be82bf96a,
    0x3fcce348da9fcf70, 0xbffba089ff1e6f58,
    0x3fba6b95936bcd48, 0x3ff0901600729555,
    0xc0011c21449e8c15, 0x40050873c43ec51b,
    0x3fc69a14112ec85c, 0x3fe8ea3aa18a15a8,
    0x3ff2f16f5b7b43e0, 0x3fa201e197c57a10,
    0xbfe88706e580e2ec, 0x4001f51254e77eaf,
    0xbfda5a6f976b0cc0, 0xbfe36c28fd18d00e,
    0xbfd8d428e78ea0a0, 0x3fc50890c35fd990,
    0x3fccecae0c5654dc, 0x3ff5151ce06799c0,
    0x3fe1f8472aae49b0, 0xbfbf1a02c865e6f0,
    0x3feb34bba320fbc8, 0x3fffb781bd8305b6,
    0x3fe802b47b20e3c2, 0xbfd7e033674f8802,
    0xbffa5e6b41a97fac, 0xbff4e05a8fafa85e,
    0xbfe1333816afbfa2, 0xbfe53ed6930fa40f,
    0x3ff8937fd8e69a44, 0x3fd6e5f369833a38,
    0xbfd0d7276322acc2, 0x3fa45508b575fdee,
    0x3fefe0fec8182052, 0xbfebb10c5d7eabac,
    0xbfd4ea67b3a1ee07, 0xbfd8a35fc0ce1b49,
    0xbff5e1b6371a9bc5, 0xbfe38a24a9dca044,
    0xbfe65cddd57f08c5, 0x3fe74bbb97f130a8,
    0xbfd528a9863facec, 0xbfe01e6c9fcd4af7,
    0xbfcf4636f88583ba, 0x40011c5396f36d98,
    0x3fe6786c6d522b9b, 0x3fd5526e104d817a,
    0x3fefb4ad6b5903f6, 0xbff1ef43456944c3,
    0xbfa9046268636108, 0xbfde20ab4e4d2d4e,
    0xbfedf8886acbe777, 0xc000334415442e91,
    0x3ff01140ad3df068, 0x3fe654a46e64e8b4,
    0x3ff16192fe318f46, 0x3ff585136ae1006e,
    0xbfaefa07c1e8e8e0, 0xbff0bf98e431441c,
    0x3ff45fdeb1e400ee, 0x3fc2cce91627e858,
    0xbff7cae3d668be3c, 0xbfb8f6bfa1a88944,
    0xc002ff542d2cfaf6, 0xbffc05cf1bc584f1,
    0xbfe8bd0931ed3020, 0x3ff9988150a62ed7,
    0xbff4677168b0bc52, 0x3ff8a7ef2a3ac380,
    0x3ffa7d99e395ae80, 0xbffb73ed97f77bb8,
    0x3ff3a8e38eecb628, 0xbfebd8e43e9f58c6,
    0x3fece8cf536e75fe, 0xbfd479be85c12b66,
    0x3ff5b7fd3f98d44f, 0xbff0b40a1379e5fe,
    0xbff7a1aa1fb88f9e, 0xbfe44498f1dc7dd4,
    0xbfd3f6bca3835a93, 0xbff49b92be15f51e,
    0xbff10ccbae3c3c44, 0xbfec0077a1aeb7fb,
    0x3fbc5bc82c60a918, 0xbffce4a543e98868,
    0xc0017bf599bb68d0, 0x3fc7ab798b480bdc,
    0x3fe7f2fe4469ff5f, 0x3fa2088975ee9910,
    0xc0037edc4c2b9336, 0x3fe3df7a33751cde,
    0xbfedaa56a8dc2f5d, 0xc0075d6468447f8f,
    0xbfdff89037c339c0, 0xbfe27e5c45007c3e,
    0x3fc47b7551f8acf7, 0x3ffc954f56571752,
    0xbfe13d5a85e99770, 0x3fdceda0362f3cbe,
    0x3fe6e89edeb5e5d8, 0x4000be402155dbb7,
    0x3fe504dbfde542bd, 0xbfedfd78726763ea,
    0x3fc756aa2b9753ee, 0x3fce74037c6586ee,
    0x3fde19c901947d5a, 0xbfc4f33d0ffc94ce,
    0x3ffd89cf329ff207, 0xbfff00bf90a2749a,
    0xbfb6cf5ac0726368, 0xbff5e7da49cf98c4,
    0x3ff0f980edcdab00, 0xbfd69ac3a52a5b9d,
    0xbfbde8dbb19a9860, 0xc004b4a31338e0a1,
    0x3fefebc46b43d358, 0xbfe111947273a714,
    0xbfb6fbf6f2756338, 0x3f7ae076cd2c6b80,
    0x3fe0419764545588, 0x401003ddd6c644d7,
    0x3ff65c3deb8570c3, 0x3fe8666e15bd6771,
    0x3ff5ce65eca8f33f, 0x3fe2cb1ad00470b0,
    0xbff3ea77d1bf249f, 0x3fc46329cb221628,
    0x3ff15a9dee503226, 0xbfd1a1ef4c3908e9,
    0x3fe64844f0a6961a, 0x3ff0021ee35ce7d0,
    0xbfff725253020c0a, 0xbfca6193a28db700,
    0xbfe7c014a91e7a36, 0x3fc0892a4a963341,
    0x3fe83bd1e0de4725, 0xbfe868d8be4ad3d7,
    0x3ff2cec88a1868ba, 0xbfde57d81d178b96,
    0xbfe655ff6f91b2b6, 0xc0062285be0f8e74,
    0x3ff2dc7a9efe6e2a, 0xc0045edac1dfc0bb,
    0x3f7ea141345b34c4, 0xc003dcfebd203c0f,
    0x3f9417789d581558, 0x3fbe4aa250a21490,
    0xbfe9b7f56c532260, 0x4002d0177d5487c5,
    0x3fec28ed1204a526, 0xbfef1c9568349362,
    0x3fdddd6d6db02bec, 0x3ff211ccf975bd3e,
    0xbfe34345fc4eb4b0, 0x3fc5913aeb753522,
    0x3fe2a46c0d637e45, 0xc000a4cae0c78862,
    0x40024986ca6e2739, 0xbfe0c75870e5610e,
    0xbff034697f6f5479, 0x3fe7d8f80f5f5769,
    0xbfdd5e72ea817508, 0xbfaf2a3f7a6df6b4,
    0xbfe0e065bf13e694, 0x3fe5d659b2c2f361,
    0x3fc002b2788636e6, 0x3ff2a542d597f685,
    0xbfebdd65b5a22b4f, 0xbff2f4c8e574ca45,
    0xbfe540013bd03b7b, 0x3fe35e0cfc721ef1,
    0x3ff90f94282cc4c6, 0xbfb91fca274f5984,
    0x3fe8610fb516d4eb, 0xbfd4e84b1086d347,
    0xbfda01d2dee40072, 0x3fee27587022ae47,
    0xbfc7c33884769454, 0xbfcae33834a2204f,
    0x3fe240a48cb96f84, 0x3fe70216f6bcec2e,
    0xbfe6accab8a7e21c, 0x3ff36f228b8ab57e,
    0xbff962752b66b095, 0xbfd5c02657bd235f,
    0xbfb87d0b24d317f0, 0x3f87ff36c4252650,
    0x3fd4e98f5570beb6, 0xbfe10d699e2ad6fd,
    0x3ff0b87d95d4b4ca, 0x3ffecee10fbb9b38,
    0xbfe1f127e36df6d6, 0x3ff92a04665b31a5,
    0xbfe300900819a874, 0xbfe523159b5c33d6,
    0x3fd12a1d53c6c548, 0x3fed9a5ff2892f2f,
    0x3ff0bfc3d3c05be3, 0xbfdb99df14feadcc,
    0xbff0f4470105884e, 0x3fe10fbf16688d9b,
    0xbffaad45455d0d7c, 0x3ff87a21b736cc62,
    0xbfc50294be9b7ab0, 0xbfe0233916bd4930,
    0xbfe6c0ef4ac46677, 0x3ff326c12d801850,
    0x4005c85d46784ae5, 0xbfe5a4b4085619ee,
    0x3fd321951103d778, 0x3fe64bde38f409f4,
    0x3fff9b91f546eef3, 0x3fefe67328cad536,
    0xbff119c883bed6b1, 0x3ff30a480c58c008,
    0x3fe4f0203d199744, 0x3fd216b9d07d06c5,
    0xbff6c30cb1bce591, 0xc011c78ac290cc6a,
    0x3feff57b4caab14e, 0x3ff757df8bbdb9ae,
    0x3fe46a25675a782c, 0x3fdf276e83917dbc,
    0xbfaebb46d4a790e0, 0x3f964c78e4d0fea0,
    0xbff44b5d933b9114, 0xbfdafe95ac35c245,
    0xbff5a87dc48a7bfe, 0x3fc799deed698ee7,
    0x3fbcd82cbf3919d8, 0x3ff25bbf4394e87c,
    0x40083ad264555890, 0x4008950e3d529489,
    0xbfffd5b57592e14b, 0x3fe462208ad86b89,
    0x3feba7a8795af635, 0xbfe55ec309baa0ce,
    0xbfbb5b7a409fe95c, 0xbff670a08206631a,
    0x3fe49857400c04cb, 0x3ffcd487c64b2d64,
    0x3ff1deb81b4ec198, 0xbfd468c1a2faf98a,
    0xbff0499b7e1fdf38, 0xbfe5367737e5abec,
    0x3fd068d1eef1c94f, 0xbfd1b36ee67888eb,
    0xbfd881a40ee68d37, 0xbfe2240a6969f314,
    0xbff8001d36ac0ede, 0x3ff259054b2df31c,
    0xc005e1b87d87c0c9, 0x3fdaed83d3b5ae3f,
    0xbfe58ef0d44b5e5a, 0xbfcebfe4e3cc4d45,
    0xbff63bff9d503f0c, 0x3ff5143f229f13c0,
    0xbff0b3204bf8be26, 0xbfd0164c9e71e6c2,
    0x3fe7c1d2e282fdc4, 0x3fdb4d93a0490a04,
    0xbff3a98fd579ed2b, 0x3feab69136b5d626,
    0xbfef8b3a0bee155e, 0xbff227a3cdf6a6de,
    0xbff39b83154bb7a2, 0x3ff2d295115bed53,
    0xbfc1c535eed7f8cc, 0x40013bc794bd252f,
    0xbfed355f9c5f3124, 0xbfcede9043955ec3,
    0x3fe4202801bad9ac, 0x3ff304b6fd59c88c,
    0xbfd82ffddb032536, 0xbfc753c75d385a1c,
    0x3fdf76a8302a7972, 0xbfecd971b75f6c92,
    0x3fe9938c705bb44e, 0xbff61733428d8631,
    0xbff7600f6dcac75c, 0xbfea20c1033d5466,
    0x3fe5b5a3e99d6309, 0xbfd7f4490b44e97c,
    0x3ff414002a9bc268, 0xbfd3f0cd8098e3e7,
    0xbfd5d27a88386d66, 0x3ff2a8c5e301343e,
    0x3ffe806fecdbe1f3, 0x3fe8c84df48b82fa,
    0x3fed8fa2a121b1b6, 0x3fd36adab9373ee0,
    0xc00152b4ad904f98, 0xbfea8abdef4f3a49,
    0x3fef013fe274e8d2, 0xbfe6482b8f2bffd0,
    0xbfd5b11e706f11d1, 0xbfb12b341802ee54,
    0x3ff0d9f64888476f, 0xc003062cf81227e1,
    0x3fd1b89eed679202, 0xbfb2d69bb56439f8,
    0x40009d60a0311f82, 0xbff598b2b3289b40,
    0xbff4cea1fe74a1d1, 0xbfda3f81bcafc468,
    0xbfd9ae6935d67ecc, 0x4000d82f1965f1c9,
    0x4003afd74f456b9f, 0x4006dbd7604aaf61,
    0xbff18c81916b3ec6, 0xbfee65fdd0c1df53,
    0xbff0c794017de5fa, 0xbff16b3922a21770,
    0xbfe7e096c147d314, 0x3ff8c5b7275112c0,
    0xbff5fd21e65c8d66, 0xbfd6a140f6f39246,
    0xbfc821c656318b18, 0xbfbcc1c3d777cf00,
    0x3fd87f1f48e1a378, 0x4000b56a205944fb,
    0x3fd2a285b1d069d3, 0xbfd42640bd261294,
    0x3ff7336fb540672e, 0x3ff3626cc47e0c78,
    0xc0034bda027e170b, 0xbfd19f02c11adc9b,
    0xbff026ccb2c98e08, 0xbfeb5ec0dad3bdee,
    0x3ff07fb780bfa61b, 0xbfc551058e010e78,
    0x3fdcf209133bc26a, 0xbfc09068091a7d84,
    0xbff32f7d373b738e, 0x3fcc0f4702b30c17,
    0x3ff949ace48ddc25, 0x3fb0c636177da1b0,
    0x3fed86c36ffec036, 0xbfe985214f719556,
    0xbfea9479d93b4781, 0xbfe329a65755d6c0,
    0xbfe35fc045f8cf4e, 0x3fdcb0e8cae6b86a,
    0xbff031bb70dd3746, 0x3fe799305f1c3fa7,
    0x3fe5395c36ecc4c5, 0xbfe241f2b6569234,
    0x3fe1e798f575e5da, 0xbfe0ed634dae4455,
    0xbff65bceac915c83, 0x3fe15b6eacdee6de,
    0xbfeb8e3fe1dd27d2, 0xbff81faa61beb28e,
    0xbfe08f617ec06365, 0x400436aca95abb05,
    0x3fd0c6055649820a, 0x3fea59df0235ad6a,
    0xbfece5004cab3013, 0xbfea1f06dd3721e2,
    0xbf94dd44537637b0, 0x3fe17f8de43a47c9,
    0xc000c15a2f619d16, 0x3ff767e834ee082f,
    0xbffb20ade92b8e9c, 0x3fa1d127582c6060,
    0x3fd25f444aa08319, 0x3ff2018693788c24,
    0x3fa1d2fabe4e37b8, 0xc0000865b88d9b65,
    0x3fef0944c5410c28, 0x3fe1acd9a78c368b,
    0x4000b68cbe6d8d15, 0xbfd11928607c6a1c,
    0x40028618ffe80619, 0xbfc22b17903f064c,
    0x3feb510f31815215, 0xbfdefd2d2b6a06a8,
    0xbffb03bb679bbde9, 0xbf94ec5529011c98,
    0xc00071b92e183954, 0x40050e2421b6b027,
    0x3feaa8d56d383162, 0x3fe345038dcd7f98,
    0x3fd882a4b0973d4a, 0x3feefa6146dcbab1,
    0xbfd2639472de9326, 0x3ff839b5bb662e6a,
    0xbfd6ad544cdc2e46, 0x3ff58a84c96e49fc,
    0x3fe65078e27c37f2, 0x3fe756524af68ba8,
    0x3fe54dc626cecde9, 0xbff6e2561ecadf75,
    0x3ff78725d0e2921a, 0xbffae9666bdfeb3c,
    0xbffba8468213da07, 0xc00121555f4fe320,
    0xbff372a1c045befe, 0xbffc745b71050f03,
    0x3ff3a42eac355725, 0xbfe06ea40a7ae6b1,
    0xbfe2fd9600fcc964, 0x40003bb8fce5461f,
    0x3ff17acc2c7f60c0, 0xbff7c66c9de4a78e,
    0xbfe5c1e0093b1ebe, 0xbfea7f35f2ee691c,
    0x3fe654b35a069a79, 0x3ff1e57b89b31285,
    0xc0011cfb8b23f925, 0xbfc7cacc88d3b47c,
    0x3fbca94dce8ce8e4, 0x3fc07dff36174294,
    0x3ff0480b8faeed74, 0x3fdb83b8fc45a649,
    0xbfd19cb74803d2a0, 0x3ff1482160d838d8,
    0xc00001978c5244a2, 0x40006ebad3ad7e40,
    0x3fe8ccc022464854, 0xbfe3a1bfcdf9acb0,
    0x3fefaef30cb65c96, 0x3ff1e647052b756d,
    0x3fe50760913b291a, 0x3ff4f66298a75070,
    0xbfe08d39bacee5be, 0xc00031b97fe671a2,
    0x3ffb1dc3bba494fd, 0x3fe67b9098b2e421,
    0xc001993c44950eb8, 0x3fc708cbb3572bca,
    0x3ff400874d480a00, 0x40015d19fbf352c2,
    0xbfef0e54561db9d8, 0x3ff38d12afbb9677,
    0xbffb41e74494470c, 0x3fe08a6ac2ae995a,
    0x3fd07b0eabb5cf3c, 0xbff3a9b75256bf1a,
    0x3feb9d02dc79eb50, 0x3ffc0b03ae2558e0,
    0xbfce0b6db0c26d28, 0xbfefeca5643d5f17,
    0xbf98f7e217f1f1c0, 0xbfa7be458cdad900,
    0xbffac3021214a284, 0x3f87fd8e6a27dbc0,
    0xbfe5c7c1917b6de2, 0xbfa6ba72954b7cd0,
    0xbff1ddd393f42586, 0x3fdde08f115cd8a3,
    0xbfd805db8e0a0fee, 0xbff5d5c53df012d6,
    0x3fe28a25ec5ff98b, 0xbfd4c9f21bc39786,
    0xbff12f29e82617a0, 0xbfe1cf8cfec4f176,
    0xbfd36be43b0ca5e0, 0xbff9807dc7abad32,
    0xbfed4e20556eb2be, 0xc0064bd6982bda51,
    0x3fe510e0878aef9b, 0x3fec3c8e85af7714,
    0x3fcdceaf881355b4, 0x3ff3663517dc79cd,
    0xbfe9d6c9afb8e158, 0xbffaf03f8b2f022f,
    0xbff0b786dca1cb0c, 0xbfe38f6e53be5035,
    0xbff4247e510bdaac, 0x3fd4f402316a5df8,
    0x3fe779d77f72e18e, 0x3fd1f0bb0b119a92,
    0x3feef09360fa109e, 0xbff190756ee312f6,
    0x3fb0e39b14125efc, 0xbfd58e242915c6c7,
    0x3f947f205875a7e0, 0xbfc3f8056ae3ed9e,
    0xbfe2efcdd4a46350, 0x3fbc61daf6a666c2,
    0xbfe157fc88697c21, 0xbfd7fa18a68c1f0f,
    0x3fd91cf3cfaf2e34, 0xbfea06ad01a6bc7d,
    0xbff509bc1d7f0eca, 0x3fd98f38ba50e47c,
    0x3ff7ae56f1e55190, 0xbff5b712b03cef50,
    0xbfe6ae3373430728, 0xbff3eb0da52eed36,
    0xbff81daf7a6ad913, 0xbff6f427409e94fc,
    0x3fdbe277286df322, 0xbff5fdf8e0ed1175,
    0xbff4aaad8ec00d2b, 0x3fede9790b4a516a,
    0x3fde5d09eb428e92, 0x3ff8534833a04973,
    0xbfe734e8491cecfa, 0x3ff43a665ef05394,
    0xc00ac7fb9087f063, 0xbff73a166c599700,
    0xbffda2175df810c8, 0xbfec46433991fb17,
    0xbff9f8bda50f8bcf, 0xc00d8aaae49de300,
    0x3ff7bfc246a317ca, 0x3ff5f4087ab2e11a,
    0x4001b612118a1a1a, 0xbfeea6028605ac6a,
    0x3ff8546f98a2ac7a, 0xbff74903ab872380,
    0xbfed1b4ed795de47, 0x4004a78675209af2,
    0x3f935db5c429209c, 0xbffe7cb4d292bfd0,
    0xbfe7550d709ea342, 0xbfd7086297cacef8,
    0x3fbcb42e8cba518e, 0x3fc9b32c5f8c790a,
    0x3fe46476cff86057, 0x3ff7ae1e909a252a,
    0xbfe21850592b6b00, 0x3fedc6a57eb03e29,
    0x3fe0e5b09d1558ce, 0x3fe81f926e999fa2,
    0xbfec0a0ad2738b03, 0x3ff93ed1bb7a6b96,
    0xbff20f3452163cf9, 0x3fc3cab2991b1522,
    0x3fe3c00ff58bb7a5, 0x3ffa98069d8b257a,
    0xbfeac257eaec6da0, 0xbff696cb70afa659,
    0x3fee839453344fd8, 0x3ff3002e1cadf469,
    0x3ffaf30edbe398d2, 0xbfedf848882024eb,
    0x3fd1953578b146b7, 0xbfe664458b86e2f4,
    0xbff6bb08775dd120, 0xc003f9319b9ed920,
    0xbff3b11aefb54cdf, 0x3fdc56f2459a467d,
    0x3fccabc30641ad36, 0xbfdbe1231be47b5f,
    0x3ffd146761371ae4, 0xbff0e5f10e6de76c,
    0xbff1dbeb96ba5bf3, 0xbfd20893a8d2dc8c,
    0xbfed3e6e1b3c1682, 0xbff100f9a2bc9d21,
    0xbfe7c91eabcf405a, 0x3fa611fec7933cb0,
    0xbfae111089ddbdeb, 0xbfc6ca7b9c64adbe,
    0xc0001fedfe9fc89d, 0x3fe2c5ae0cb56f98,
    0x3ff261d3d7a4de99, 0xbfe3ea695c0d56a4,
    0x3fed96839beedaae, 0x4007f47bf443b173,
    0xbfa073eceda88700, 0x3fc11221d3245f76,
    0x3fee885d8880a925, 0xbff33c9a169dced9,
    0x3fd2a5581858602e, 0x3ff8a40d663f0fb9,
    0xbfc843e2d06943e4, 0xbfe8a42b91388147,
    0xc00658ac1887e01f, 0x3fe08e2127d5fc2b,
    0x3fe12bad76dcf3de, 0x3ff72381d527c1f4,
    0x3fe4a12ad1d27d8a, 0x3fde2d3ad9f082c4,
    0xbff99f05222162f6, 0xbfff6871dc78da2a,
    0x3fe8b26a64121133, 0xbff34860521faed4,
    0x3fb52b6a19dad080, 0x3fe5942e43afc0d6,
    0x3fbd1d60d70e3c30, 0x3fe5b499afa4ee9d,
    0x3fe0688a15f2779c, 0x3ff82ed666e8435c,
    0xbfc30350fa491152, 0xbfcc3685e4b544cc,
    0x3ff497b05b72d46f, 0x3ff3a7d3bc7696e5,
    0x3feed627c0f50a8e, 0x3fe0e8116577a06a,
    0x3fe7d82a1c6c428d, 0xbfc905a0136a69b7,
    0xbfcdea2d2fabe5c2, 0xbff889d2e8dc62eb,
    0xbfe91f3f0ee7e777, 0xbfea73d7b05298e2,
    0x3fe85857313f0a56, 0x3ffc699e9ccd1598,
    0x3fdb4a347a6ff23b, 0x3fee75d2ae6110fa,
    0x3ffaaf91c6e09a90, 0xbffc29dc0d200e04,
    0xbfca3724890e98b8, 0xbfd682c1a2c3eba8,
    0xbfda5c231fc7eba6, 0x3ff617187bff9060,
    0x3fe8b4a900710a8a, 0xbfc4d5b907c7ad9a,
    0x3ff5227c0a8822c2, 0xbff49c0aa58cd638,
    0xbff1470cb52a2c30, 0xbfc6c8e37514cbad,
    0xc003ed6c20dc8093, 0xbfc0d1f167598c67,
    0xc007da804e3e119e, 0xbfda92414720b429,
    0x3ff1f58d32dbb059, 0x3febc1fc151df864,
    0x3fce253410f394f4, 0x4004d8ba39f0652d,
    0xbfdf6b6574c9319a, 0xc00321f4fecd008c,
    0xbfcb72c195691bf4, 0xbffc68e948ebc5d0,
    0x3ff318dfdef933a4, 0xbfdbd9bb8521a55b,
    0xbfeaf3b2f9695a48, 0x3fc4ef7123103b00,
    0x3fe77dbc0eeeeec4, 0xbfdde9c9a597b475,
    0xbff3f0221bd00de0, 0x3feae32cf835f9c3,
    0xbfb82112a8606ae8, 0x3ff811fcfcb6bb1a,
    0x3fed3eeeb28141d2, 0x3fed616b6ad7b5b7,
    0xc0068d73a9eae596, 0xbfef2b2e3e400fcb,
    0x3fc1f88940e77848, 0x3feaeb2053994165,
    0x3fa18e8ef59589b8, 0xbfbd720e392c85b6,
    0xbff34ccddd809f0f, 0x3febe293a09f9a1a,
    0xbff560d3f3ccd069, 0x3ff2146be79029c2,
    0x3fdbd455d63a8581, 0xbf712553ea7e2c00,
    0xc005c437d575ed90, 0x3fb3c95962302cf0,
    0x3ff83ddc1f8a3e01, 0xbffe20efd8859fe0,
    0xbfdc43b5ccccdb54, 0xbfb12591bae13020,
    0xbfdb2092a2733138, 0x3faead240343d390,
    0x3fd426c970ef2fe2, 0x3ffb9268ee28d775,
    0xbfcc70c496243c50, 0x3fe4060858173bfb,
    0x3fa7a53f6b0879f8, 0x3ff5759e98261840,
    0x3fdfc9f8356decdd, 0x3fef1dcfa86b5a15,
    0xbfb4782542efed88, 0xc003a9768de8eda0,
    0xbff330a0b161283c, 0xbff4d365ebc5de48,
    0xbfddeec3b41a1f32, 0x4004384eaedd5377,
    0xbfbcb0f6c9e6c528, 0xbffdfe28f3e9b64d,
    0x3fd34156d3f0a071, 0x3fc1af01ad299c46,
    0x3fd846ac0f1fd1fe, 0x3fea41f1b492ccec,
    0x3fe9d5c6f4fefd5c, 0xbfca5aad921e2fe8,
    0xbfc0a26bceb4a0ca, 0xbfeafe64de4d1620,
    0x3ff3cc731fd75d1a, 0x3fd72a7fe45ec5ff,
    0xbfefbe29b75c94ed, 0x3ff5a86f51cf4f61,
    0xbff41693f693ad1e, 0x3fe1c3b010aafd54,
    0x3fd83eafa8552874, 0x3ff2409424717aa9,
    0x3fb7ff1ffe547f58, 0x3ff09a584a80be6a,
    0x3fe0ba90463265aa, 0xbfdde378dbf6ddaf,
    0x3fd0f223e191eb0e, 0xbfeb27ecf93ad05a,
    0x3ffa0fc3fdff4c1a, 0x3fdec16589a3d452,
    0xbfcc7070ac38f665, 0x4001c37dee6ab331,
    0xbfe8a24162cf45f4, 0x3fd88be25791e3e2,
    0x3ff06714044deef9, 0xbfeb6f3b29f1686a,
    0xbffcb1d97750c3f7, 0xbff6b980505dc23d,
    0xbfe3a940b2052588, 0x3ff4213bfb4734c7,
    0x3fe94ffaba45b49c, 0x3ff8a92ebc0e982e,
    0x3fe0bd48471d6a88, 0x3fa3fa3d72f900e0,
    0x3ffa41dc0480a73b, 0xbff5eff7c91fb6dd,
    0xbfe8490bc7d84977, 0x400171dfeb7e5c2b,
    0x3feaa04d4e0c82eb, 0xbfccf16825a5fbf8,
    0xc000c0b331056e39, 0xbffda507ee6da0a3,
    0xbfc4726880cb5398, 0x3fd358987c7b26c2,
    0x3ff2edaf4476515b, 0xbffd13ec0299b236,
    0xbff00cc7bb027bad, 0x3fd543d11d94564d,
    0x3fe7f0c5b3cf24ea, 0xbff0bd2b8e30a121,
    0xbfcfd1857cc306f6, 0x3ff5118c28a2f62b,
    0x3fd2fbaf3860cc72, 0x3fc05779c16f1fa8,
    0x3ff150662979737a, 0xbffcf429eaf0336b,
    0xbff5619f5c33f700, 0x3fb1bcbadf1ffb78,
    0x3fe934b1d436c7d6, 0xc001c865b652811a,
    0xbff4741bf1105a95, 0x3ff28bb4d2cd6193,
    0xbff1a252c03a2218, 0x3fe7e7302d974c83,
    0x3fef15f6536e5589, 0xbfef7753c494a285,
    0x3fc43cc452e78c2f, 0xbfd7af68fe412fdb,
    0xbfed5cd8ae4b0fd5, 0x3fe3c01cb3322a6a,
    0xbfde674581c4f78c, 0xbfc3fe59d5081dea,
    0xbfb38ecdb20bb360, 0xbffa0690f3a52368,
    0x40029179eab862ed, 0x3feb0adb0a74646e,
    0x3fbec33417852ef0, 0x3fcbd167434a8d38,
    0x3febc1029c625e5e, 0xbfe790a9e0b8fca2,
    0x3fe128b368bb03ed, 0x40082794ffef9f0f,
    0x3fd66466fc00a962, 0x3fd30eee8c318a2a,
    0x3ff2a1fcb80d8da6, 0x3feed570ed901ec1,
    0x3fedaa1b328fe153, 0x3fe346917c192425,
    0xc00d0e91104aa6a6, 0x0,
    0x3fedaa1b328fe150, 0xbfe346917c192424,
    0x3ff2a1fcb80d8da6, 0xbfeed570ed901ebc,
    0x3fd66466fc00a966, 0xbfd30eee8c318a28,
    0x3fe128b368bb03ec, 0xc0082794ffef9f10,
    0x3febc1029c625e60, 0x3fe790a9e0b8fca4,
    0x3fbec33417852ef8, 0xbfcbd167434a8d34,
    0x40029179eab862ec, 0xbfeb0adb0a74646f,
    0xbfb38ecdb20bb378, 0x3ffa0690f3a52369,
    0xbfde674581c4f798, 0x3fc3fe59d5081df0,
    0xbfed5cd8ae4b0fd1, 0xbfe3c01cb3322a6b,
    0x3fc43cc452e78c38, 0x3fd7af68fe412fdb,
    0x3fef15f6536e5586, 0x3fef7753c494a283,
    0xbff1a252c03a2219, 0xbfe7e7302d974c83,
    0xbff4741bf1105a97, 0xbff28bb4d2cd6193,
    0x3fe934b1d436c7d5, 0x4001c865b652811a,
    0xbff5619f5c33f6ff, 0xbfb1bcbadf1ffb78,
    0x3ff150662979737a, 0x3ffcf429eaf0336a,
    0x3fd2fbaf3860cc77, 0xbfc05779c16f1f98,
    0xbfcfd1857cc306f6, 0xbff5118c28a2f62b,
    0x3fe7f0c5b3cf24ea, 0x3ff0bd2b8e30a120,
    0xbff00cc7bb027bac, 0xbfd543d11d94564b,
    0x3ff2edaf4476515d, 0x3ffd13ec0299b235,
    0xbfc4726880cb5388, 0xbfd358987c7b26bf,
    0xc000c0b331056e3a, 0x3ffda507ee6da0a1,
    0x3feaa04d4e0c82ea, 0x3fccf16825a5fbe2,
    0xbfe8490bc7d84978, 0xc00171dfeb7e5c2a,
    0x3ffa41dc0480a740, 0x3ff5eff7c91fb6dc,
    0x3fe0bd48471d6a86, 0xbfa3fa3d72f900e8,
    0x3fe94ffaba45b499, 0xbff8a92ebc0e982b,
    0xbfe3a940b2052585, 0xbff4213bfb4734c7,
    0xbffcb1d97750c3fa, 0x3ff6b980505dc23b,
    0x3ff06714044deef8, 0x3feb6f3b29f16868,
    0xbfe8a24162cf45f2, 0xbfd88be25791e3e6,
    0xbfcc7070ac38f668, 0xc001c37dee6ab330,
    0x3ffa0fc3fdff4c1a, 0xbfdec16589a3d452,
    0x3fd0f223e191eb0d, 0x3feb27ecf93ad05a,
    0x3fe0ba90463265a5, 0x3fdde378dbf6ddb0,
    0x3fb7ff1ffe547f54, 0xbff09a584a80be6b,
    0x3fd83eafa8552878, 0xbff2409424717aa5,
    0xbff41693f693ad1f, 0xbfe1c3b010aafd50,
    0xbfefbe29b75c94ec, 0xbff5a86f51cf4f61,
    0x3ff3cc731fd75d19, 0xbfd72a7fe45ec5f9,
    0xbfc0a26bceb4a0ba, 0x3feafe64de4d1621,
    0x3fe9d5c6f4fefd5b, 0x3fca5aad921e2fe8,
    0x3fd846ac0f1fd206, 0xbfea41f1b492ccea,
    0x3fd34156d3f0a071, 0xbfc1af01ad299c54,
    0xbfbcb0f6c9e6c510, 0x3ffdfe28f3e9b64e,
    0xbfddeec3b41a1f34, 0xc004384eaedd5377,
    0xbff330a0b161283a, 0x3ff4d365ebc5de48,
    0xbfb4782542efed88, 0x4003a9768de8eda0,
    0x3fdfc9f8356decdf, 0xbfef1dcfa86b5a16,
    0x3fa7a53f6b0879d0, 0xbff5759e98261840,
    0xbfcc70c496243c60, 0xbfe4060858173bf9,
    0x3fd426c970ef2fe4, 0xbffb9268ee28d776,
    0xbfdb2092a2733131, 0xbfaead240343d3a0,
    0xbfdc43b5ccccdb4e, 0x3fb12591bae13020,
    0x3ff83ddc1f8a3e02, 0x3ffe20efd8859fde,
    0xc005c437d575ed90, 0xbfb3c95962302cd8,
    0x3fdbd455d63a8588, 0x3f712553ea7e2c00,
    0xbff560d3f3ccd06a, 0xbff2146be79029c1,
    0xbff34ccddd809f0c, 0xbfebe293a09f9a1c,
    0x3fa18e8ef59589d8, 0x3fbd720e392c85d4,
    0x3fc1f88940e77838, 0xbfeaeb2053994164,
    0xc0068d73a9eae596, 0x3fef2b2e3e400fcc,
    0x3fed3eeeb28141d6, 0xbfed616b6ad7b5bc,
    0xbfb82112a8606ae8, 0xbff811fcfcb6bb1a,
    0xbff3f0221bd00ddf, 0xbfeae32cf835f9c0,
    0x3fe77dbc0eeeeec0, 0x3fdde9c9a597b47a,
    0xbfeaf3b2f9695a4e, 0xbfc4ef7123103b08,
    0x3ff318dfdef933a1, 0x3fdbd9bb8521a55c,
    0xbfcb72c195691bfc, 0x3ffc68e948ebc5ce,
    0xbfdf6b6574c93190, 0x400321f4fecd008c,
    0x3fce253410f394f8, 0xc004d8ba39f0652f,
    0x3ff1f58d32dbb058, 0xbfebc1fc151df860,
    0xc007da804e3e119d, 0x3fda92414720b427,
    0xc003ed6c20dc8092, 0x3fc0d1f167598c70,
    0xbff1470cb52a2c31, 0x3fc6c8e37514cbb9,
    0x3ff5227c0a8822c2, 0x3ff49c0aa58cd63a,
    0x3fe8b4a900710a86, 0x3fc4d5b907c7ad8c,
    0xbfda5c231fc7eba6, 0xbff617187bff9060,
    0xbfca3724890e98b0, 0x3fd682c1a2c3ebb0,
    0x3ffaaf91c6e09a90, 0x3ffc29dc0d200e04,
    0x3fdb4a347a6ff23c, 0xbfee75d2ae6110fc,
    0x3fe85857313f0a58, 0xbffc699e9ccd159a,
    0xbfe91f3f0ee7e773, 0x3fea73d7b05298e6,
    0xbfcdea2d2fabe5c4, 0x3ff889d2e8dc62ed,
    0x3fe7d82a1c6c428d, 0x3fc905a0136a69ba,
    0x3feed627c0f50a90, 0xbfe0e8116577a06c,
    0x3ff497b05b72d46e, 0xbff3a7d3bc7696e6,
    0xbfc30350fa491153, 0x3fcc3685e4b544cc,
    0x3fe0688a15f277a2, 0xbff82ed666e8435d,
    0x3fbd1d60d70e3c40, 0xbfe5b499afa4ee9b,
    0x3fb52b6a19dad070, 0xbfe5942e43afc0d7,
    0x3fe8b26a64121132, 0x3ff34860521faed4,
    0xbff99f05222162f9, 0x3fff6871dc78da28,
    0x3fe4a12ad1d27d8c, 0xbfde2d3ad9f082c8,
    0x3fe12bad76dcf3dc, 0xbff72381d527c1f5,
    0xc00658ac1887e01f, 0xbfe08e2127d5fc2c,
    0xbfc843e2d06943e0, 0x3fe8a42b91388145,
    0x3fd2a5581858602e, 0xbff8a40d663f0fba,
    0x3fee885d8880a922, 0x3ff33c9a169dceda,
    0xbfa073eceda88720, 0xbfc11221d3245f70,
    0x3fed96839beedaae, 0xc007f47bf443b174,
    0x3ff261d3d7a4de9a, 0x3fe3ea695c0d56ac,
    0xc0001fedfe9fc89c, 0xbfe2c5ae0cb56f96,
    0xbfae111089ddbda8, 0x3fc6ca7b9c64adb0,
    0xbfe7c91eabcf4059, 0xbfa611fec7933cc0,
    0xbfed3e6e1b3c1686, 0x3ff100f9a2bc9d20,
    0xbff1dbeb96ba5bf3, 0x3fd20893a8d2dc8a,
    0x3ffd146761371ae2, 0x3ff0e5f10e6de76d,
    0x3fccabc30641ad38, 0x3fdbe1231be47b56,
    0xbff3b11aefb54ce0, 0xbfdc56f2459a467e,
    0xbff6bb08775dd121, 0x4003f9319b9ed91f,
    0x3fd1953578b146b3, 0x3fe664458b86e2f4,
    0x3ffaf30edbe398cf, 0x3fedf848882024ea,
    0x3fee839453344fd7, 0xbff3002e1cadf46b,
    0xbfeac257eaec6da0, 0x3ff696cb70afa65a,
    0x3fe3c00ff58bb7a4, 0xbffa98069d8b257a,
    0xbff20f3452163cfa, 0xbfc3cab2991b1518,
    0xbfec0a0ad2738b00, 0xbff93ed1bb7a6b93,
    0x3fe0e5b09d1558d0, 0xbfe81f926e999f9c,
    0xbfe21850592b6aff, 0xbfedc6a57eb03e2a,
    0x3fe46476cff86059, 0xbff7ae1e909a2529,
    0x3fbcb42e8cba5182, 0xbfc9b32c5f8c7902,
    0xbfe7550d709ea344, 0x3fd7086297cacef1,
    0x3f935db5c4292050, 0x3ffe7cb4d292bfd2,
    0xbfed1b4ed795de46, 0xc004a78675209af2,
    0x3ff8546f98a2ac7a, 0x3ff74903ab872380,
    0x4001b612118a1a19, 0x3feea6028605ac71,
    0x3ff7bfc246a317ca, 0xbff5f4087ab2e119,
    0xbff9f8bda50f8bcd, 0x400d8aaae49de301,
    0xbffda2175df810ca, 0x3fec46433991fb16,
    0xc00ac7fb9087f062, 0x3ff73a166c5996fe,
    0xbfe734e8491cecfc, 0xbff43a665ef05396,
    0x3fde5d09eb428e94, 0xbff8534833a04975,
    0xbff4aaad8ec00d2b, 0xbfede9790b4a516a,
    0x3fdbe277286df326, 0x3ff5fdf8e0ed1176,
    0xbff81daf7a6ad912, 0x3ff6f427409e94fc,
    0xbfe6ae337343072a, 0x3ff3eb0da52eed36,
    0x3ff7ae56f1e5518f, 0x3ff5b712b03cef50,
    0xbff509bc1d7f0ec8, 0xbfd98f38ba50e47e,
    0x3fd91cf3cfaf2e34, 0x3fea06ad01a6bc7b,
    0xbfe157fc88697c23, 0x3fd7fa18a68c1f08,
    0xbfe2efcdd4a4634f, 0xbfbc61daf6a666bf,
    0x3f947f205875a850, 0x3fc3f8056ae3eda8,
    0x3fb0e39b14125eec, 0x3fd58e242915c6c5,
    0x3feef09360fa10a2, 0x3ff190756ee312f6,
    0x3fe779d77f72e18f, 0xbfd1f0bb0b119a90,
    0xbff4247e510bdaab, 0xbfd4f402316a5df6,
    0xbff0b786dca1cb0e, 0x3fe38f6e53be5036,
    0xbfe9d6c9afb8e15b, 0x3ffaf03f8b2f0230,
    0x3fcdceaf881355b8, 0xbff3663517dc79cd,
    0x3fe510e0878aef9a, 0xbfec3c8e85af7715,
    0xbfed4e20556eb2bd, 0x40064bd6982bda51,
    0xbfd36be43b0ca5e2, 0x3ff9807dc7abad32,
    0xbff12f29e82617a0, 0x3fe1cf8cfec4f17c,
    0x3fe28a25ec5ff98b, 0x3fd4c9f21bc39786,
    0xbfd805db8e0a0ff2, 0x3ff5d5c53df012d6,
    0xbff1ddd393f42588, 0xbfdde08f115cd89b,
    0xbfe5c7c1917b6de0, 0x3fa6ba72954b7cc0,
    0xbffac3021214a286, 0xbf87fd8e6a27dd00,
    0xbf98f7e217f1f1e0, 0x3fa7be458cdad8f0,
    0xbfce0b6db0c26d14, 0x3fefeca5643d5f14,
    0x3feb9d02dc79eb50, 0xbffc0b03ae2558df,
    0x3fd07b0eabb5cf44, 0x3ff3a9b75256bf1c,
    0xbffb41e74494470d, 0xbfe08a6ac2ae995c,
    0xbfef0e54561db9d7, 0xbff38d12afbb9679,
    0x3ff400874d480a01, 0xc0015d19fbf352c3,
    0xc001993c44950eb7, 0xbfc708cbb3572bc4,
    0x3ffb1dc3bba494fc, 0xbfe67b9098b2e425,
    0xbfe08d39bacee5bf, 0x400031b97fe671a3,
    0x3fe50760913b291d, 0xbff4f66298a75070,
    0x3fefaef30cb65c97, 0xbff1e647052b756e,
    0x3fe8ccc022464855, 0x3fe3a1bfcdf9acb0,
    0xc00001978c5244a2, 0xc0006ebad3ad7e40,
    0xbfd19cb74803d2a0, 0xbff1482160d838d8,
    0x3ff0480b8faeed74, 0xbfdb83b8fc45a64a,
    0x3fbca94dce8ce8f4, 0xbfc07dff361742a0,
    0xc0011cfb8b23f927, 0x3fc7cacc88d3b488,
    0x3fe654b35a069a7a, 0xbff1e57b89b31284,
    0xbfe5c1e0093b1ec3, 0x3fea7f35f2ee691c,
    0x3ff17acc2c7f60bf, 0x3ff7c66c9de4a78e,
    0xbfe2fd9600fcc967, 0xc0003bb8fce5461e,
    0x3ff3a42eac355724, 0x3fe06ea40a7ae6b2,
    0xbff372a1c045befd, 0x3ffc745b71050f06,
    0xbffba8468213da0a, 0x400121555f4fe321,
    0x3ff78725d0e2921a, 0x3ffae9666bdfeb3e,
    0x3fe54dc626cecdec, 0x3ff6e2561ecadf71,
    0x3fe65078e27c37f2, 0xbfe756524af68ba5,
    0xbfd6ad544cdc2e54, 0xbff58a84c96e49fc,
    0xbfd2639472de9325, 0xbff839b5bb662e6b,
    0x3fd882a4b0973d48, 0xbfeefa6146dcbab0,
    0x3feaa8d56d383164, 0xbfe345038dcd7f99,
    0xc00071b92e183953, 0xc0050e2421b6b027,
    0xbffb03bb679bbde7, 0x3f94ec5529011c78,
    0x3feb510f31815217, 0x3fdefd2d2b6a06a6,
    0x40028618ffe80619, 0x3fc22b17903f0648,
    0x4000b68cbe6d8d16, 0x3fd11928607c6a1c,
    0x3fef0944c5410c28, 0xbfe1acd9a78c368d,
    0x3fa1d2fabe4e37a8, 0x40000865b88d9b63,
    0x3fd25f444aa0831a, 0xbff2018693788c23,
    0xbffb20ade92b8e9c, 0xbfa1d127582c6040,
    0xc000c15a2f619d16, 0xbff767e834ee082f,
    0xbf94dd4453763738, 0xbfe17f8de43a47c6,
    0xbfece5004cab3014, 0x3fea1f06dd3721e6,
    0x3fd0c60556498202, 0xbfea59df0235ad6e,
    0xbfe08f617ec06364, 0xc00436aca95abb06,
    0xbfeb8e3fe1dd27d1, 0x3ff81faa61beb28e,
    0xbff65bceac915c86, 0xbfe15b6eacdee6e4,
    0x3fe1e798f575e5de, 0x3fe0ed634dae4457,
    0x3fe5395c36ecc4c8, 0x3fe241f2b6569232,
    0xbff031bb70dd3745, 0xbfe799305f1c3fb0,
    0xbfe35fc045f8cf55, 0xbfdcb0e8cae6b869,
    0xbfea9479d93b477f, 0x3fe329a65755d6c0,
    0x3fed86c36ffec033, 0x3fe985214f719552,
    0x3ff949ace48ddc26, 0xbfb0c636177da1b8,
    0xbff32f7d373b7390, 0xbfcc0f4702b30c0b,
    0x3fdcf209133bc26b, 0x3fc09068091a7d86,
    0x3ff07fb780bfa61b, 0x3fc551058e010e70,
    0xbff026ccb2c98e07, 0x3feb5ec0dad3bdec,
    0xc0034bda027e170c, 0x3fd19f02c11adc9c,
    0x3ff7336fb5406730, 0xbff3626cc47e0c7a,
    0x3fd2a285b1d069d6, 0x3fd42640bd261298,
    0x3fd87f1f48e1a378, 0xc000b56a205944fa,
    0xbfc821c656318b21, 0x3fbcc1c3d777cef4,
    0xbff5fd21e65c8d68, 0x3fd6a140f6f3924a,
    0xbfe7e096c147d310, 0xbff8c5b7275112c3,
    0xbff0c794017de5f8, 0x3ff16b3922a2176e,
    0xbff18c81916b3ec6, 0x3fee65fdd0c1df50,
    0x4003afd74f456ba0, 0xc006dbd7604aaf62,
    0xbfd9ae6935d67eca, 0xc000d82f1965f1c8,
    0xbff4cea1fe74a1d2, 0x3fda3f81bcafc46b,
    0x40009d60a0311f82, 0x3ff598b2b3289b40,
    0x3fd1b89eed679204, 0x3fb2d69bb5643a00,
    0x3ff0d9f648884771, 0x4003062cf81227e0,
    0xbfd5b11e706f11cf, 0x3fb12b341802ee3c,
    0x3fef013fe274e8d2, 0x3fe6482b8f2bffd4,
    0xc00152b4ad904f98, 0x3fea8abdef4f3a44,
    0x3fed8fa2a121b1b8, 0xbfd36adab9373ed8,
    0x3ffe806fecdbe1f3, 0xbfe8c84df48b82fb,
    0xbfd5d27a88386d68, 0xbff2a8c5e3013440,
    0x3ff414002a9bc26a, 0x3fd3f0cd8098e3e0,
    0x3fe5b5a3e99d6306, 0x3fd7f4490b44e97a,
    0xbff7600f6dcac75c, 0x3fea20c1033d5464,
    0x3fe9938c705bb44e, 0x3ff61733428d8630,
    0x3fdf76a8302a7972, 0x3fecd971b75f6c92,
    0xbfd82ffddb032535, 0x3fc753c75d385a1c,
    0x3fe4202801bad9ad, 0xbff304b6fd59c88c,
    0xbfed355f9c5f3127, 0x3fcede9043955ed5,
    0xbfc1c535eed7f8bc, 0xc0013bc794bd2531,
    0xbff39b83154bb7a3, 0xbff2d295115bed53,
    0xbfef8b3a0bee155c, 0x3ff227a3cdf6a6de,
    0xbff3a98fd579ed2a, 0xbfeab69136b5d626,
    0x3fe7c1d2e282fdc7, 0xbfdb4d93a0490a03,
    0xbff0b3204bf8be27, 0x3fd0164c9e71e6bc,
    0xbff63bff9d503f0c, 0xbff5143f229f13c0,
    0xbfe58ef0d44b5e58, 0x3fcebfe4e3cc4d43,
    0xc005e1b87d87c0c9, 0xbfdaed83d3b5ae40,
    0xbff8001d36ac0edd, 0xbff259054b2df31a,
    0xbfd881a40ee68d3c, 0x3fe2240a6969f310,
    0x3fd068d1eef1c94a, 0x3fd1b36ee67888f5,
    0xbff0499b7e1fdf38, 0x3fe5367737e5abef,
    0x3ff1deb81b4ec196, 0x3fd468c1a2faf982,
    0x3fe49857400c04ce, 0xbffcd487c64b2d62,
    0xbfbb5b7a409fe940, 0x3ff670a082066318,
    0x3feba7a8795af637, 0x3fe55ec309baa0cc,
    0xbfffd5b57592e149, 0xbfe462208ad86b8e,
    0x40083ad264555890, 0xc008950e3d529488,
    0x3fbcd82cbf3919d8, 0xbff25bbf4394e87c,
    0xbff5a87dc48a7bfe, 0xbfc799deed698ede,
    0xbff44b5d933b9112, 0x3fdafe95ac35c242,
    0xbfaebb46d4a790e0, 0xbf964c78e4d0fe90,
    0x3fe46a25675a7830, 0xbfdf276e83917dc0,
    0x3feff57b4caab14e, 0xbff757df8bbdb9ae,
    0xbff6c30cb1bce591, 0x4011c78ac290cc6a,
    0x3fe4f0203d199742, 0xbfd216b9d07d06c7,
    0xbff119c883bed6af, 0xbff30a480c58c006,
    0x3fff9b91f546eef4, 0xbfefe67328cad539,
    0x3fd321951103d77c, 0xbfe64bde38f409f8,
    0x4005c85d46784ae6, 0x3fe5a4b4085619f0,
    0xbfe6c0ef4ac46678, 0xbff326c12d801852,
    0xbfc50294be9b7aa0, 0x3fe0233916bd4930,
    0xbffaad45455d0d7e, 0xbff87a21b736cc66,
    0xbff0f4470105884e, 0xbfe10fbf16688d9c,
    0x3ff0bfc3d3c05be4, 0x3fdb99df14feadd0,
    0x3fd12a1d53c6c54a, 0xbfed9a5ff2892f2f,
    0xbfe300900819a872, 0x3fe523159b5c33d8,
    0xbfe1f127e36df6d6, 0xbff92a04665b31a6,
    0x3ff0b87d95d4b4cb, 0xbffecee10fbb9b37,
    0x3fd4e98f5570beb8, 0x3fe10d699e2ad6ff,
    0xbfb87d0b24d317e0, 0xbf87ff36c4252720,
    0xbff962752b66b094, 0x3fd5c02657bd2363,
    0xbfe6accab8a7e215, 0xbff36f228b8ab57d,
    0x3fe240a48cb96f83, 0xbfe70216f6bcec2d,
    0xbfc7c33884769458, 0x3fcae33834a2204f,
    0xbfda01d2dee40074, 0xbfee27587022ae46,
    0x3fe8610fb516d4ea, 0x3fd4e84b1086d345,
    0x3ff90f94282cc4c6, 0x3fb91fca274f598c,
    0xbfe540013bd03b7a, 0xbfe35e0cfc721eef,
    0xbfebdd65b5a22b53, 0x3ff2f4c8e574ca46,
    0x3fc002b2788636dc, 0xbff2a542d597f684,
    0xbfe0e065bf13e696, 0xbfe5d659b2c2f363,
    0xbfdd5e72ea81750b, 0x3faf2a3f7a6df6a8,
    0xbff034697f6f5478, 0xbfe7d8f80f5f5767,
    0x40024986ca6e2739, 0x3fe0c75870e5610c,
    0x3fe2a46c0d637e43, 0x4000a4cae0c78864,
    0xbfe34345fc4eb4af, 0xbfc5913aeb753522,
    0x3fdddd6d6db02beb, 0xbff211ccf975bd3e,
    0x3fec28ed1204a526, 0x3fef1c9568349362,
    0xbfe9b7f56c532261, 0xc002d0177d5487c6,
    0x3f9417789d5815d0, 0xbfbe4aa250a21488,
    0x3f7ea141345b3540, 0x4003dcfebd203c0f,
    0x3ff2dc7a9efe6e28, 0x40045edac1dfc0b9,
    0xbfe655ff6f91b2b4, 0x40062285be0f8e74,
    0x3ff2cec88a1868b8, 0x3fde57d81d178b92,
    0x3fe83bd1e0de4721, 0x3fe868d8be4ad3da,
    0xbfe7c014a91e7a3a, 0xbfc0892a4a963335,
    0xbfff725253020c09, 0x3fca6193a28db6f0,
    0x3fe64844f0a6961c, 0xbff0021ee35ce7cf,
    0x3ff15a9dee503226, 0x3fd1a1ef4c3908e6,
    0xbff3ea77d1bf249e, 0xbfc46329cb22162c,
    0x3ff5ce65eca8f33e, 0xbfe2cb1ad00470ad,
    0x3ff65c3deb8570c1, 0xbfe8666e15bd6770,
    0x3fe041976454558b, 0xc01003ddd6c644d7,
    0xbfb6fbf6f2756328, 0xbf7ae076cd2c6a80,
    0x3fefebc46b43d352, 0x3fe111947273a712,
    0xbfbde8dbb19a9880, 0x4004b4a31338e0a3,
    0x3ff0f980edcdab01, 0x3fd69ac3a52a5b96,
    0xbfb6cf5ac0726380, 0x3ff5e7da49cf98c2,
    0x3ffd89cf329ff208, 0x3fff00bf90a27496,
    0x3fde19c901947d5c, 0x3fc4f33d0ffc94e2,
    0x3fc756aa2b9753fc, 0xbfce74037c6586f0,
    0x3fe504dbfde542bb, 0x3fedfd78726763eb,
    0x3fe6e89edeb5e5dc, 0xc000be402155dbb6,
    0xbfe13d5a85e99770, 0xbfdceda0362f3cbd,
    0x3fc47b7551f8acf8, 0xbffc954f56571750,
    0xbfdff89037c339b8, 0x3fe27e5c45007c3a,
    0xbfedaa56a8dc2f5c, 0x40075d6468447f90,
    0xc0037edc4c2b9336, 0xbfe3df7a33751cdd,
    0x3fe7f2fe4469ff5a, 0xbfa2088975ee98f0,
    0xc0017bf599bb68d0, 0xbfc7ab798b480bdc,
    0x3fbc5bc82c60a910, 0x3ffce4a543e98868,
    0xbff10ccbae3c3c45, 0x3fec0077a1aeb7fa,
    0xbfd3f6bca3835a8e, 0x3ff49b92be15f51f,
    0xbff7a1aa1fb88f9e, 0x3fe44498f1dc7dd4,
    0x3ff5b7fd3f98d450, 0x3ff0b40a1379e5fe,
    0x3fece8cf536e75fe, 0x3fd479be85c12b69,
    0x3ff3a8e38eecb628, 0x3febd8e43e9f58c9,
    0x3ffa7d99e395ae81, 0x3ffb73ed97f77bba,
    0xbff4677168b0bc52, 0xbff8a7ef2a3ac382,
    0xbfe8bd0931ed301b, 0xbff9988150a62ed8,
    0xc002ff542d2cfaf6, 0x3ffc05cf1bc584f2,
    0xbff7cae3d668be3a, 0x3fb8f6bfa1a88944,
    0x3ff45fdeb1e400f0, 0xbfc2cce91627e850,
    0xbfaefa07c1e8e890, 0x3ff0bf98e431441e,
    0x3ff16192fe318f46, 0xbff585136ae1006e,
    0x3ff01140ad3df068, 0xbfe654a46e64e8b5,
    0xbfedf8886acbe776, 0x4000334415442e91,
    0xbfa9046268636110, 0x3fde20ab4e4d2d55,
    0x3fefb4ad6b5903f7, 0x3ff1ef43456944c3,
    0x3fe6786c6d522b98, 0xbfd5526e104d817c,
    0xbfcf4636f88583c0, 0xc0011c5396f36d9a,
    0xbfd528a9863faced, 0x3fe01e6c9fcd4af2,
    0xbfe65cddd57f08c6, 0xbfe74bbb97f130a7,
    0xbff5e1b6371a9bc5, 0x3fe38a24a9dca040,
    0xbfd4ea67b3a1ee03, 0x3fd8a35fc0ce1b4f,
    0x3fefe0fec818204d, 0x3febb10c5d7eaba8,
    0xbfd0d7276322acc1, 0xbfa45508b575fdf4,
    0x3ff8937fd8e69a44, 0xbfd6e5f369833a39,
    0xbfe1333816afbfa4, 0x3fe53ed6930fa413,
    0xbffa5e6b41a97fac, 0x3ff4e05a8fafa85b,
    0x3fe802b47b20e3c8, 0x3fd7e033674f8801,
    0x3feb34bba320fbcc, 0xbfffb781bd8305b6,
    0x3fe1f8472aae49b2, 0x3fbf1a02c865e6f8,
    0x3fccecae0c5654dc, 0xbff5151ce06799bf,
    0xbfd8d428e78ea09c, 0xbfc50890c35fd996,
    0xbfda5a6f976b0cc6, 0x3fe36c28fd18d00e,
    0xbfe88706e580e2ee, 0xc001f51254e77eaf,
    0x3ff2f16f5b7b43e2, 0xbfa201e197c579e0,
    0x3fc69a14112ec85c, 0xbfe8ea3aa18a15a9,
    0xc0011c21449e8c15, 0xc0050873c43ec51c,
    0x3fba6b95936bcd40, 0xbff0901600729556,
    0x3fcce348da9fcf74, 0x3ffba089ff1e6f57,
    0x3ff6a9186454c6c6, 0x40765a4be82bf96a,
    0x3fedae235b31fba5, 0xbfc35ec19f45cd78,
    0xbfccc6477037928c, 0x3fdbe9800dc7fc60,
    0x3fc46e11ac34f3b2, 0x3fd31fc3a7634ca8,
    0xbfd30fb5cc4f7d2c, 0x3feed47558684668,
    0x3fff5f303ccd1748, 0x3ff1b12d6142b1a2,
    0x3fd02be2aab5ccae, 0x40001506d34e1a35,
    0x3ffb577e5fc84a1d, 0x3fc8f34dc4437684,
    0x3fef88f535755c3d, 0xbff7de439f4d2262,
    0xc0002a6c5ac8b52f, 0xbfc53f4411bb5972,
    0xbff587df9a6ffa48, 0xbfd191917c3da19e,
    0x40020e16329bf5c8, 0x3fe6a1bb11f90efa,
    0x3f84c237d6320d80, 0xbffe6fd66f5c056d,
    0xbff894622bda6f0a, 0x3fe8aabbb7fb1941,
    0x3fdb8768867b58d1, 0xbff31cef7e4e5462,
    0xbfe00a56870c5ea6, 0xbfb3eb57adc5b530,
    0xbfe2b780d2bfcff2, 0xbfbfc371ddf2598c,
    0x3ff217d1be07a07f, 0xbfea54875d0f400e,
    0x3feeec477db6ce48, 0xbff030792a574f24,
    0xbfdc15258f8c85bb, 0xbfc80429e47fce18,
    0x3ff503806db0a7f1, 0xbff80c476528330f,
    0x3fe717ecb5be043a, 0xbff33fc57c42248e,
    0xbfc48b3ec008f0ad, 0x3ff1e221c1ffc49d,
    0xbfd16e84ab6cdaa8, 0x3fea318e59f73cec,
    0xbfe00d240a71dbbe, 0x3fdbb598771f78e8,
    0x3fe4eae9a981f0ea, 0xbff05e6f5c962ab2,
    0xc003791b81db60dd, 0xbfe39aa1234c8ebe,
    0x3fee6654a7375c67, 0xbfbef6f8b37386b0,
    0x3fa3ad5cd8d13744, 0x3fae547451ffa8e0,
    0x3ff56864970db360, 0x3ff20cecaf5cf41c,
    0x3fe2493ec7628080, 0x4001200c18b1958b,
    0x3fef96a027bbedf8, 0x3fdd3edca95d1912,
    0xc00a95357f02473c, 0x40041be5d6ecaca0,
    0x3fec7c01d919a4a4, 0x3ff833e5e3fbe68a,
    0x3fb82867e5d04b48, 0xbfe2508bc4b32533,
    0xbff4cee0f0ee79d6, 0x3fd33645d012303b,
    0x400135b3c5df9656, 0xbff46ce544fd2378,
    0xbff84e7f48317bf2, 0xbfdaa461e0f4b8f8,
    0xbfe02b8a846ac0fe, 0x3ff3c37322c2a814,
    0x3fd422a07b44f50d, 0xbfd470a43862f128,
    0xbfd266a36400c2c3, 0xbfd0d5a114efdff7,
    0xbfea5a9477b59ae1, 0x3fe44438dd808bb3,
    0x3fea57166140aede, 0xbff8ab5fe85168b3,
    0x3fd05319d9aab4fe, 0xbff80e16f09a98fd,
    0xbfe95b6b95713806, 0x400800e94dae42d0,
    0x3fdb17a437e1bfe1, 0x3fde9c84e39325cd,
    0x3fff290d25e3e44a, 0x3fd2acb9bafdaf00,
    0xc0034902e4753d56, 0x3ff9434c95c2d410,
    0x4002ffe4b162ca2b, 0x3fe73945fbcff8b9,
    0x3fea3e3c1bb60352, 0x3fde6d53fa8a9751,
    0xbfd207a1b02e7ad2, 0x3fc74b4b4c2afc70,
    0x3fd6f99a3f5f2282, 0x3fd63f527088a8ee,
    0xbff13d601fb42936, 0xbfcac420153d5ad5,
    0x3fd4039ddc16f0b0, 0xbfe919d8758bbc94,
    0x3ff15c853f3267c9, 0x3ffa85c1ec9259d2,
    0xbff75ea00d36767e, 0x3fce342e84399470,
    0x3fe8431dc9e4c8bb, 0xbff0629b2014f33f,
    0x3feb319fd62533b3, 0x3fd469d2183f4bda,
    0xbfe7cc3564d2ed65, 0xbff2928db3a5d6a9,
    0xbff189d7f1125764, 0x3ffb1fe360fb1cca,
    0xbfe96aa3b4393ac6, 0xbfe64fa1e7966efe,
    0x3f8c48bef4c6f940, 0xbff2efaf7a7602d2,
    0x3fe61230916a9b28, 0x3ff5b6987d81d0b6,
    0xbfefdc5da59bb6c0, 0x3ffdab34b59db556,
    0x3fc08e22839cb380, 0xbfe4642544e73001,
    0xbff67151b7f1fea2, 0xbfebf2e51eaa75ef,
    0xbfe7c2684cbc78ba, 0x3fa491c9d61257ac,
    0xbfe007f27d85c334, 0xc0082b6eaaf9322a,
    0x3ffc356c9e309bb3, 0xbff21d5b0c041c80,
    0x3fd8c55b078352c3, 0x3fe86bb743ba1b8b,
    0x3fd4ce1151df2f18, 0x3ff49f4384026557,
    0x3fcf77081988fa48, 0x3fc8ddd31abd10e0,
    0xbffa06b5cb4aeeb5, 0x3fec32b7e2eaa80d,
    0x3feb2559f74e325c, 0x3ff601ae08527b36,
    0x400032d13f1c7fca, 0xbfe4720fcddfa14a,
    0x3ffe8d064c901162, 0xbfce60f9a1e8a604,
    0x3fe84e4f0f59b42a, 0xbfeca3901a800f5c,
    0xbf9bf8c184b2d2b0, 0x3feec01107ba1325,
    0xbfe87147ef4fe5ab, 0x3ffad3899e5f23f3,
    0xbffd641ff04b5be0, 0x3fed878037f57df9,
    0x3fe71ef0d6fc1933, 0xbfefa4694968c40d,
    0xbff6cbace4ace092, 0x3fecd4c33068bc96,
    0xbfd4bdb6f674ddd5, 0xbfe029f2d8fc0352,
    0xbfeadbd837f2b849, 0xbfcf6f290e953700,
    0x3ffc1f8773fa1302, 0xc00254eb58fa2876,
    0x3fda47c52599e56b, 0x3fe120e1bf8e9df8,
    0x3ffa01eadc57866e, 0x3ff48c2f15c5115a,
    0xbfea4db258e37d85, 0xbfe331f2d44757c2,
    0xbfda43cd33c91552, 0x3fdb46aaa64a5a88,
    0x4003b197753da386, 0xbffa65d60ac2bf25,
    0xbff0a6ae33748e5c, 0x3fe8146a049ad4bc,
    0xbff910a79d419d63, 0xbff44acb3350645c,
    0xbfe5ca42c642b88b, 0x3fe0fffb456bb3f6,
    0x3ffed84c4b88526e, 0x3fe128f8803f34e7,
    0xbfe628d8d09b8275, 0x3fe5d37a75aeb91c,
    0x3fb2e60eb5de53b4, 0x3fb9e561fa99b442,
    0x3ff84b2cd2b69aaf, 0x4006ccf0ae51fcd0,
    0xbf8e185e8665c980, 0x40004b2bd2c9e670,
    0xbfebc62645f375bc, 0xbff3d713c42ba8c5,
    0x3ff86be22b9f97a2, 0xbff594a423910160,
    0xc0084c2a54361253, 0xbfe865acd20c73ce,
    0x3fe8548954eb9b46, 0xbff15a7eee41800d,
    0xbff4297d549baf22, 0x3ffa14ac7b8a683f,
    0x3fee9ca93139c11d, 0xbfd411b4c00ab4f4,
    0xbfe4754f22374d9c, 0x3fba8e98dba325b0,
    0x400fcee81948bcaa, 0x3fd9399a4bb38dcc,
    0x3ff643e770c705b9, 0x400a199f05fe0a2f,
    0x3fc5cc141986a818, 0x3fde72db401f87b3,
    0x3fdbdaceba154024, 0xbfcf8fdd3ddbe022,
    0x3fb0f6e90bee072b, 0xbfe3c3409e4a0c34,
    0xbfe44d51ee93f149, 0xc0047f7c6f7250e2,
    0xbfe9555e3b152ff2, 0xbfc993ec5cfacc48,
    0xbfb4809dcbc3e240, 0xbff485361022b502,
    0x3fd652b9ffe08c04, 0xbfd6a722e768240c,
    0x3ff8fc3bbe8b65d9, 0x3fcdf209f87e0092,
    0xbfdfd48a065a3741, 0x3f937152284114e0,
    0x3ff13304ef9ef443, 0x3ffedad84b42ca1e,
    0x3fe5099f2c4ad384, 0x3fdeadc42c9e72c3,
    0xbfebe60553366c1d, 0x3fb82e952f16c17c,
    0xbff96904e0706a89, 0xbfe7da13d486c986,
    0xbff0b2a9873df302, 0x3ff6fd27dfb965ee,
    0xbfd95df2f569596a, 0xbfe27bb461f8c71a,
    0x3ffe32d6f1fc1205, 0xbfe21360ec93563c,
    0x3fbc67431e9e32dc, 0xbfe540c44e264c6e,
    0x3fe8770854d5ff1b, 0x3fd553eece5be5e0,
    0xbfe4c343702ff057, 0xbfa67a79bc9cf72c,
    0xbff0169c9deec3c4, 0xbfeac565e960faa1,
    0x3ffa74b3b71806aa, 0x3fdd3925c4b06a25
    };

static const uint64_t in_cfft_noisy_2048[4096] = {
    0x3f9293c3bc4b8c87, 0x0,
    0x3fdf60408ef845cb, 0x0,
    0x3fe711ff982eeca9, 0x0,
    0x3fdc2a576d1cd230, 0x0,
    0x3f9a1543bfc4ac73, 0x0,
    0xbfda9e81b4d5dd57, 0x0,
    0xbfe63eae54244380, 0x0,
    0xbfde4434117cad97, 0x0,
    0x3fadca676969057e, 0x0,
    0x3fe025b22e2d2fcd, 0x0,
    0x3fe5ea4f49392ace, 0x0,
    0x3fddb30c806865a0, 0x0,
    0xbf88e5a499aae6dc, 0x0,
    0xbfe11d87e096b239, 0x0,
    0xbfe76946e4d0683f, 0x0,
    0xbfdc935422d4d8c1, 0x0,
    0xbf31e141b5982d44, 0x0,
    0x3fde99b3d4fa66a7, 0x0,
    0x3fe551b294bb149a, 0x0,
    0x3fe086e50c5396b5, 0x0,
    0xbfa8fcc182053306, 0x0,
    0xbfd9a2cbf3c4bfa8, 0x0,
    0xbfe4ca0881babfc9, 0x0,
    0xbfe0eacb77e1b379, 0x0,
    0xbf9345badf8483c0, 0x0,
    0x3fe06d8a62e07f4e, 0x0,
    0x3fe57cf7afca057d, 0x0,
    0x3fe1f40481a72729, 0x0,
    0x3f628ae6d87d8c21, 0x0,
    0xbfe12d26f9acb7d3, 0x0,
    0xbfe609a5a38aab22, 0x0,
    0xbfe2c734ef8770b2, 0x0,
    0x3f905af7100a35ab, 0x0,
    0x3fe003ebb3314935, 0x0,
    0x3fe675693c6c1ec8, 0x0,
    0x3fdf8a80930d68d9, 0x0,
    0x3fb7ddfcac5f3418, 0x0,
    0xbfe026f39f1161f2, 0x0,
    0xbfe77b5198a3694c, 0x0,
    0xbfe0a250d1f6cdaf, 0x0,
    0xbfa7559f4bfa92f8, 0x0,
    0x3fe06c898780ac8b, 0x0,
    0x3fe43fbeb3ceeba2, 0x0,
    0x3fe0e18c39771e3f, 0x0,
    0xbfaa6edd56bb0982, 0x0,
    0xbfde78cc4b717966, 0x0,
    0xbfe6abbeec0ba159, 0x0,
    0xbfdc05000777d167, 0x0,
    0x3f912294f2b697d7, 0x0,
    0x3fe372ca2a0daec8, 0x0,
    0x3fe7e42df94de0f9, 0x0,
    0x3fdbd009cd398dfc, 0x0,
    0x3f9ec9d59d0a9238, 0x0,
    0xbfe0a03042e9c8d2, 0x0,
    0xbfe763981d610ad3, 0x0,
    0xbfdf9c605ecf4110, 0x0,
    0xbfb7297a97c6ebfd, 0x0,
    0x3fe0e951fcb982fd, 0x0,
    0x3fe4ce69c358dd48, 0x0,
    0x3fe339108b967034, 0x0,
    0x3fb73c4cc0a06e5e, 0x0,
    0xbfdfa7e4339def78, 0x0,
    0xbfe66dc2d1c0f272, 0x0,
    0xbfdaa86018f7c4b8, 0x0,
    0xbf85250a2659b505, 0x0,
    0x3fe0dde804919088, 0x0,
    0x3fe50c70300242f1, 0x0,
    0x3fe1c18a7a6f13ea, 0x0,
    0xbfabd6b2cf38e594, 0x0,
    0xbfdbf5cbb8defecc, 0x0,
    0xbfe4ad0f439a544b, 0x0,
    0xbfe295867fe79c4e, 0x0,
    0x3fa6a5a17397f3e2, 0x0,
    0x3fdaac443098212a, 0x0,
    0x3fe681223ba16020, 0x0,
    0x3fdc7901c354c9b8, 0x0,
    0xbfc0ab605feb9a13, 0x0,
    0xbfdef3a0d28f4332, 0x0,
    0xbfe6ef59fef444a2, 0x0,
    0xbfddbc17dfa997bc, 0x0,
    0xbf9dcfe5518df0c3, 0x0,
    0x3fdce79d50a6665c, 0x0,
    0x3fe67ba8a0319890, 0x0,
    0x3fd98079a2f38f60, 0x0,
    0x3facb7a03533fc92, 0x0,
    0xbfde53ddaa2555db, 0x0,
    0xbfe4dc8fbc8a4b67, 0x0,
    0xbfde47dbf3512ebf, 0x0,
    0x3fa2be38a15051f6, 0x0,
    0x3fdebaf5844bc138, 0x0,
    0x3fe7baf764bd2d42, 0x0,
    0x3fe04e2cb366d6b6, 0x0,
    0x3fb57cf18f32cf79, 0x0,
    0xbfe1f13bfe02c408, 0x0,
    0xbfe54e3ae2645319, 0x0,
    0xbfdf3b48373f4d3f, 0x0,
    0x3f842c79cd1f1681, 0x0,
    0x3fddbf499d8bd286, 0x0,
    0x3fe7f77f90dc0f1f, 0x0,
    0x3fd85a861840e98b, 0x0,
    0xbfa4631f63c98c12, 0x0,
    0xbfdf338f07945286, 0x0,
    0xbfe5fb9a924553ae, 0x0,
    0xbfe20946898aaa4f, 0x0,
    0x3fb4cb50ebb4cd52, 0x0,
    0x3fe0c92dcdb468ba, 0x0,
    0x3fe48e5d499f5b72, 0x0,
    0x3fe13ed51d4f1bf5, 0x0,
    0x3fa23b4795d8ab17, 0x0,
    0xbfdd7acdbc3dcbe0, 0x0,
    0xbfe6aaa1b28c714d, 0x0,
    0xbfdc7263ee9da9fb, 0x0,
    0xbf89c0a2c17823aa, 0x0,
    0x3fe18fcaa6b54537, 0x0,
    0x3fe643106eb1d04d, 0x0,
    0x3fe2dbdf11c0ba3c, 0x0,
    0x3f8fb2aef463e845, 0x0,
    0xbfde3a1f2067cd66, 0x0,
    0xbfe83b580f34490f, 0x0,
    0xbfdddf4704b0be77, 0x0,
    0xbf93680b7737349f, 0x0,
    0x3fddfb05dc77de58, 0x0,
    0x3fe9857378afe60d, 0x0,
    0x3fdfc57646e03267, 0x0,
    0x3f42b7b9d7f24f2a, 0x0,
    0xbfe0db2086e78433, 0x0,
    0xbfe720b25403c76e, 0x0,
    0xbfdfd49db75bdd8a, 0x0,
    0xbf8539d45fd2453c, 0x0,
    0x3fddb8e974502eca, 0x0,
    0x3fe5657ad35cb7ba, 0x0,
    0x3fe1cbc11d253f3d, 0x0,
    0x3f9613e9c95d848c, 0x0,
    0xbfdcd367ae56133b, 0x0,
    0xbfe81054784e2caf, 0x0,
    0xbfde15235e151c2e, 0x0,
    0xbfc504658abaa544, 0x0,
    0x3fdebf593128d3b8, 0x0,
    0x3fe847ee276c37ee, 0x0,
    0x3fe0792ef3009f65, 0x0,
    0x3fa67a3af7397a24, 0x0,
    0xbfe32271ce00633b, 0x0,
    0xbfe7f68aff740092, 0x0,
    0xbfe2065bc89de7fc, 0x0,
    0xbfa3ae46dd8b6702, 0x0,
    0x3fd95df454ba1b68, 0x0,
    0x3fe4983c7b0513b5, 0x0,
    0x3fe10c0d78c2f765, 0x0,
    0x3f98fedeffedda89, 0x0,
    0xbfe17240c196a476, 0x0,
    0xbfe58754b47d6086, 0x0,
    0xbfdcf3ba56aa56f8, 0x0,
    0xbf7425c017ff32a3, 0x0,
    0x3fe2087e6b92c92b, 0x0,
    0x3fe61b4c5dc1d637, 0x0,
    0x3fe0ebbd7000bb71, 0x0,
    0xbfa296c592bf8880, 0x0,
    0xbfdc2d4201f3ef64, 0x0,
    0xbfe6923ade1b1466, 0x0,
    0xbfe1003d6e279ec8, 0x0,
    0xbf9c6faecd343ec1, 0x0,
    0x3fd82fd6c45f773d, 0x0,
    0x3fe51fa8d76ad41a, 0x0,
    0x3fdaff2ff5e87f90, 0x0,
    0x3fb449116061575e, 0x0,
    0xbfdd16cfb8959dc3, 0x0,
    0xbfe3f21fa835def0, 0x0,
    0xbfe2105ca3acadbb, 0x0,
    0xbfb20792eb90b712, 0x0,
    0x3fdee180d3b8ee58, 0x0,
    0x3fe57f65c65d8591, 0x0,
    0x3fdd6b41ea6076eb, 0x0,
    0xbf9a6cd838604aaf, 0x0,
    0xbfe249cf55c766c5, 0x0,
    0xbfe4e5213ee13038, 0x0,
    0xbfdfdbcf4c29c3b9, 0x0,
    0xbf9084d853662cb0, 0x0,
    0x3fdae3cfa5894eca, 0x0,
    0x3fe65b9cfdd92c7d, 0x0,
    0x3fdcdc5aa3ea8d13, 0x0,
    0x3fbecbd280f27b4f, 0x0,
    0xbfe059cd79f14602, 0x0,
    0xbfe5a09e2e27e686, 0x0,
    0xbfdf2bb417e4782f, 0x0,
    0xbf85cac994ae5eae, 0x0,
    0x3fde0fa2f7982cbc, 0x0,
    0x3fe62db6b1db634e, 0x0,
    0x3fe16eb008dcc6e2, 0x0,
    0xbf738bd1e3dea36c, 0x0,
    0xbfe1883bccc259d6, 0x0,
    0xbfe29e5df5974c41, 0x0,
    0xbfe19db103b2192f, 0x0,
    0xbfaaeb6859dca7ce, 0x0,
    0x3fe1f9fca699e283, 0x0,
    0x3fe3dd65076116c2, 0x0,
    0x3fe04b4957822ed4, 0x0,
    0xbf8034fbc1cfa5ec, 0x0,
    0xbfdfbe9d4fbb0560, 0x0,
    0xbfe3c6a03b011fa6, 0x0,
    0xbfe243f5a9ed7d27, 0x0,
    0xbfab0cc931eb8777, 0x0,
    0x3fe1501653e82bdf, 0x0,
    0x3fe61415c80e7978, 0x0,
    0x3fdd84f00e3c1e54, 0x0,
    0x3fbbffb99f42b535, 0x0,
    0xbfe06df9599550ef, 0x0,
    0xbfe633afe8825eef, 0x0,
    0xbfe0875aa6957d6b, 0x0,
    0xbf984dc0b344b169, 0x0,
    0x3fd986eb9a4fc630, 0x0,
    0x3fe59e89228f074a, 0x0,
    0x3fdcccfba392c0c2, 0x0,
    0x3fa9020905303efd, 0x0,
    0xbfe0fe85ec540a07, 0x0,
    0xbfe88289782aa3e2, 0x0,
    0xbfdc368dd6ac52ef, 0x0,
    0xbf8e318bcfd52c58, 0x0,
    0x3fd8de20b270ced6, 0x0,
    0x3fe753b496787256, 0x0,
    0x3fe27c908444b72e, 0x0,
    0xbf8311e4aa35757b, 0x0,
    0xbfdde4393be32cde, 0x0,
    0xbfe73df3f7aa29f0, 0x0,
    0xbfe1f6f358b26c76, 0x0,
    0xbfb6d0b3ee83a4c3, 0x0,
    0x3fde8f08bcabcee9, 0x0,
    0x3fe5818c2b6435fc, 0x0,
    0x3fe05fbf6ae2e07f, 0x0,
    0x3f90f9e71645e748, 0x0,
    0xbfdd9e2153fceef5, 0x0,
    0xbfe4667df84d53e9, 0x0,
    0xbfdb25be225e3404, 0x0,
    0x3fa71266d976ddc0, 0x0,
    0x3fdb27466a7dd668, 0x0,
    0x3fe32eef981d38c5, 0x0,
    0x3fe28fe719c2ad26, 0x0,
    0x3faa56c18146ef06, 0x0,
    0xbfde66ea3bb043ce, 0x0,
    0xbfe5f55cd64863dc, 0x0,
    0xbfdf6ce1b8b93d6e, 0x0,
    0x3f850800558e0526, 0x0,
    0x3fdce26d6969b7d1, 0x0,
    0x3fe4d7e29dce6786, 0x0,
    0x3fe0fbb49348a0a2, 0x0,
    0xbf641b28e9576e95, 0x0,
    0xbfdea8f6fb18ee97, 0x0,
    0xbfe78db720dc72d3, 0x0,
    0xbfe284f3aa3aa39a, 0x0,
    0xbfaa3629492c641d, 0x0,
    0x3fd763ca3ad58cda, 0x0,
    0x3fe524167d247833, 0x0,
    0x3fe0dff1e4e1d776, 0x0,
    0xbf7dc641b1a9d3b9, 0x0,
    0xbfe052a06a1c4000, 0x0,
    0xbfe80eede26a0ea8, 0x0,
    0xbfdcdb1732a4dca2, 0x0,
    0xbfa3e0f01cb18262, 0x0,
    0x3fdd5ecd9fbd2070, 0x0,
    0x3fe4877bae14d315, 0x0,
    0x3fe1ba50e0c82bfd, 0x0,
    0xbfa5251d25903166, 0x0,
    0xbfe229694f6269ca, 0x0,
    0xbfe7c4367c82c97d, 0x0,
    0xbfe03d8cb106e1fd, 0x0,
    0xbf8fc69fe9acab57, 0x0,
    0x3fdd204e708f4425, 0x0,
    0x3fe3087aac87ac18, 0x0,
    0x3fe12200c3de0a83, 0x0,
    0x3fa0080f07a5b93b, 0x0,
    0xbfde5886f211dd37, 0x0,
    0xbfe7e97b73ecadf6, 0x0,
    0xbfe19e9102c623cb, 0x0,
    0x3f9d866d833072f8, 0x0,
    0x3fde726edd2d5c76, 0x0,
    0x3fe5269af8703548, 0x0,
    0x3fdc23faaf304865, 0x0,
    0xbfb238d23933a2c5, 0x0,
    0xbfe0034ef686b03c, 0x0,
    0xbfe997cd2310b32e, 0x0,
    0xbfdc116cb3d1f3b4, 0x0,
    0x3f8d29a4a8ae0c37, 0x0,
    0x3fdf55259b2e5f76, 0x0,
    0x3fe81f9a986e9b8b, 0x0,
    0x3fe366e790faedb9, 0x0,
    0xbfa4dc26a678fdca, 0x0,
    0xbfdd5e0ab4be40ad, 0x0,
    0xbfe72a672a52188e, 0x0,
    0xbfdcbd69aeb6d197, 0x0,
    0x3fa87161c032b1a0, 0x0,
    0x3fdf36e51362f7e2, 0x0,
    0x3fe854b7731085e4, 0x0,
    0x3fe09ec8981d2fe9, 0x0,
    0xbf99bac612ca604e, 0x0,
    0xbfdf45278d75b17b, 0x0,
    0xbfe79da5c659378f, 0x0,
    0xbfe4b9328eb28570, 0x0,
    0xbf38ede63158b369, 0x0,
    0x3fe1ea4461592904, 0x0,
    0x3fe2f6447f52ec9c, 0x0,
    0x3fddce6b224b9838, 0x0,
    0x3fb2a172153c9e87, 0x0,
    0xbfe036a1b0d12eb2, 0x0,
    0xbfe692eb2c478717, 0x0,
    0xbfdfe7a84259cda1, 0x0,
    0x3fa4572a8bdc9ae5, 0x0,
    0x3fe2567d6bf27267, 0x0,
    0x3fe66f3ced665337, 0x0,
    0x3fe1bb0125e0dc29, 0x0,
    0xbf9bc404e4c9078a, 0x0,
    0xbfdbe8db26961236, 0x0,
    0xbfe4a02fccbd34e5, 0x0,
    0xbfe1a8dc835021b8, 0x0,
    0x3f929c52ca6909cc, 0x0,
    0x3fe0b81d7473d582, 0x0,
    0x3fe81675fe08dc11, 0x0,
    0x3fde90471f657a5c, 0x0,
    0x3fb20c7011365add, 0x0,
    0xbfdd5f0c0600f17d, 0x0,
    0xbfe4a54856b621bc, 0x0,
    0xbfdf322c024976ca, 0x0,
    0xbf760bca80b0e68b, 0x0,
    0x3fdf9a62882a8037, 0x0,
    0x3fe67d087b4ecac1, 0x0,
    0x3fdc06bbf231253c, 0x0,
    0x3f456b825a7f9fbe, 0x0,
    0xbfe0e219616ed1d2, 0x0,
    0xbfe71b668cdc4f3a, 0x0,
    0xbfdcabecf7f6199a, 0x0,
    0xbf92a1b0aa839e96, 0x0,
    0x3fe3da4f4ba9f249, 0x0,
    0x3fe496b16244cb29, 0x0,
    0x3fe0c6dc5e1f50c7, 0x0,
    0xbf979be0b44c3b57, 0x0,
    0xbfde99c0215a374c, 0x0,
    0xbfe762365250db7c, 0x0,
    0xbfe1c17125ba9fd2, 0x0,
    0x3f7ecbf67b50eece, 0x0,
    0x3fde8a4c42af7fa5, 0x0,
    0x3fe50fae01cc7e06, 0x0,
    0x3fde3832f4811c1f, 0x0,
    0xbfb5183bdc5eb52e, 0x0,
    0xbfe3346c4827a7ae, 0x0,
    0xbfe624695bca46ac, 0x0,
    0xbfe179a0cbeafd89, 0x0,
    0x3f9893ff5b8f5fcb, 0x0,
    0x3fd8a878ac4ee8de, 0x0,
    0x3fe7dda0ae90a2f5, 0x0,
    0x3fe11e7397b744d2, 0x0,
    0xbf79b9564b0ac36d, 0x0,
    0xbfdd8af3219ec8ca, 0x0,
    0xbfe7a2a8fc852d6e, 0x0,
    0xbfdf02d4497b4c72, 0x0,
    0x3fa560bb27684ffd, 0x0,
    0x3fde3e001a608984, 0x0,
    0x3fe96eb6168f6f66, 0x0,
    0x3fdd6b8fcb13cfdd, 0x0,
    0x3fabd8ace3dca54b, 0x0,
    0xbfde17bae5413bd6, 0x0,
    0xbfe438665fc6e4ff, 0x0,
    0xbfe116f476eaae82, 0x0,
    0xbfae8156b394e537, 0x0,
    0x3fe1f9011e33b4ae, 0x0,
    0x3fe6b7e7138a78e4, 0x0,
    0x3fdf4f5ae0d52bd1, 0x0,
    0xbf9b35b6f20c4512, 0x0,
    0xbfe195d76b3080c1, 0x0,
    0xbfe6f824b26e9741, 0x0,
    0xbfd855779be6d162, 0x0,
    0xbfbded7b08a481bf, 0x0,
    0x3fd997c8f5fcbbb3, 0x0,
    0x3feaae28994c041c, 0x0,
    0x3fe1b6dfc10dc117, 0x0,
    0x3fb02d8cfb02a645, 0x0,
    0xbfe04fd5f9267ced, 0x0,
    0xbfe5b74e5e1e62e2, 0x0,
    0xbfe19641c7cf06c1, 0x0,
    0x3fb12f03fba67c82, 0x0,
    0x3fdd26a133473e73, 0x0,
    0x3fe6f080de51a13e, 0x0,
    0x3fdd1c7bb867d624, 0x0,
    0xbfb530eba114c7d2, 0x0,
    0xbfdd9789fa922966, 0x0,
    0xbfe74439c192d6e0, 0x0,
    0xbfe045e86778d853, 0x0,
    0xbf8935052e396e9b, 0x0,
    0x3fd629dc4c6d7674, 0x0,
    0x3fe6e91af38f41dc, 0x0,
    0x3fdbbd0896caff82, 0x0,
    0x3fbb4354ce086df3, 0x0,
    0xbfe0ab01a851bbd0, 0x0,
    0xbfe564412b493d20, 0x0,
    0xbfe315c4fde68d2b, 0x0,
    0x3fac36058816588b, 0x0,
    0x3fe051278584f366, 0x0,
    0x3fe578dfa615d028, 0x0,
    0x3fdcd1bf3ebe34d0, 0x0,
    0x3f890c29e93c581f, 0x0,
    0xbfe2a7bcd44fa7fb, 0x0,
    0xbfe848e53bd02a76, 0x0,
    0xbfdb50c7c6eafae1, 0x0,
    0x3fa1752d4d2ec9ac, 0x0,
    0x3fdf27173c7918ea, 0x0,
    0x3fe56bcae5e099d7, 0x0,
    0x3fe016f910ce4f95, 0x0,
    0x3fa4ef877f016c95, 0x0,
    0xbfe006fc2f978c6c, 0x0,
    0xbfe49e543ff14111, 0x0,
    0xbfe0741a7ad67caf, 0x0,
    0x3fbdacbe3d7f07f3, 0x0,
    0x3fe092bb4f19133b, 0x0,
    0x3fe6e5a62e811109, 0x0,
    0x3fe082312c681720, 0x0,
    0x3fadbcc507910eb0, 0x0,
    0xbfde0ddda487800c, 0x0,
    0xbfe75731148d0586, 0x0,
    0xbfe1c08b4d70160a, 0x0,
    0x3f644ac3ac574a0e, 0x0,
    0x3fe150073fcee6af, 0x0,
    0x3fe646b48ec83d5a, 0x0,
    0x3fdc379d7ed16a1b, 0x0,
    0x3f80889b8205348c, 0x0,
    0xbfe1a0249ca1c653, 0x0,
    0xbfe61e53e3842770, 0x0,
    0xbfe01278ca2f55f5, 0x0,
    0xbf7a305464e385a8, 0x0,
    0x3fde34c987ffbc79, 0x0,
    0x3fe7a88c0fb659b9, 0x0,
    0x3fe0ba55b1e9c6d3, 0x0,
    0xbfbb39f32c9dcc42, 0x0,
    0xbfdf96a6a17344e5, 0x0,
    0xbfe53b0f9da444eb, 0x0,
    0xbfdfbfbc11c419ab, 0x0,
    0x3fa7cde8f087ff82, 0x0,
    0x3fdf257fe588ee80, 0x0,
    0x3fe766033418c5c7, 0x0,
    0x3fdc99f92f0f269d, 0x0,
    0x3f8d948fef7a9856, 0x0,
    0xbfe1f10ea347dbb1, 0x0,
    0xbfe40f73512e306e, 0x0,
    0xbfe14a45b96e6e33, 0x0,
    0x3f946cdbf9a7e984, 0x0,
    0x3fdb0b6f1feca23f, 0x0,
    0x3fe39d830586eeb4, 0x0,
    0x3fdb8f1c969d8185, 0x0,
    0x3f8e90cbd57441ae, 0x0,
    0xbfe1ba6d180ddad6, 0x0,
    0xbfe77df37dff3d44, 0x0,
    0xbfe22be4be89dc71, 0x0,
    0x3fa8728ab44806ec, 0x0,
    0x3fe1754361f7ceb5, 0x0,
    0x3fe59d95447e1b37, 0x0,
    0x3fdc7610fff4bc0b, 0x0,
    0x3f79ab2b7b63ec69, 0x0,
    0xbfda6853183eacf0, 0x0,
    0xbfe6dcc4b8c9becd, 0x0,
    0xbfe0d32f4494ccdc, 0x0,
    0xbf6bb3d313270c12, 0x0,
    0x3fdc7376f84b8c78, 0x0,
    0x3fe62000b44597d3, 0x0,
    0x3fdc6a7a89adec25, 0x0,
    0xbfb1b1c64b3547cf, 0x0,
    0xbfe2b3cc6bb74008, 0x0,
    0xbfe656c68f9786dc, 0x0,
    0xbfdb67e274b368fb, 0x0,
    0xbfa88f8df4d8cfcd, 0x0,
    0x3fd7f3474003323a, 0x0,
    0x3fe5809d6900000e, 0x0,
    0x3fdbc6dd94e48036, 0x0,
    0x3faa252eb021ed64, 0x0,
    0xbfdf3fe1989e2c1c, 0x0,
    0xbfe56d04b4ec89e9, 0x0,
    0xbfdf522db33933a4, 0x0,
    0x3fa3ac2716c207f6, 0x0,
    0x3fdf11429aa8f798, 0x0,
    0x3fe60db4e5aef6bc, 0x0,
    0x3fe1145d0632631e, 0x0,
    0x3faeb8b35ba2906e, 0x0,
    0xbfe093320652f368, 0x0,
    0xbfe9ace24aa645b2, 0x0,
    0xbfdace4763a7d020, 0x0,
    0x3fac49172e25f799, 0x0,
    0x3fdb85376253740c, 0x0,
    0x3fe45899c375fbcb, 0x0,
    0x3fe0a50efa9e2325, 0x0,
    0xbfaca2b1fe4ca65b, 0x0,
    0xbfdcd2126518cb2a, 0x0,
    0xbfe68f19e72d4011, 0x0,
    0xbfe11eb88112ddb1, 0x0,
    0xbf813140a52a1d65, 0x0,
    0x3fde0ff461357c47, 0x0,
    0x3fe4d58df0132590, 0x0,
    0x3fe0d9017a2ac652, 0x0,
    0xbf77c63b09b758dd, 0x0,
    0xbfdef883dad062ef, 0x0,
    0xbfe603d9cc77fb70, 0x0,
    0xbfdd87aec25f0fe8, 0x0,
    0xbf96bc18bb0c0e02, 0x0,
    0x3fe2e17e48df87c6, 0x0,
    0x3fe568db432039b1, 0x0,
    0x3fdbbefcc8f856c6, 0x0,
    0x3fba3884b94e1817, 0x0,
    0xbfdeed017c186af2, 0x0,
    0xbfe74c53b5217052, 0x0,
    0xbfdfd469453f8638, 0x0,
    0x3fa5903f0816d5d4, 0x0,
    0x3fe1a2b4c26cbe30, 0x0,
    0x3fe62e050514ae52, 0x0,
    0x3fe1f8c102e19b03, 0x0,
    0x3fa7b8a2a6a22308, 0x0,
    0xbfdc2c7ba3d2fd6d, 0x0,
    0xbfe63c6794f6eec2, 0x0,
    0xbfdc8d1f7946ddd3, 0x0,
    0xbf9a73bd70ac0e98, 0x0,
    0x3fe1a85a36520990, 0x0,
    0x3fe1bdd7804df32c, 0x0,
    0x3fdd7b8ef86dd930, 0x0,
    0xbfa81fa1cad8d4cd, 0x0,
    0xbfe22629d366ff66, 0x0,
    0xbfe72de487b31462, 0x0,
    0xbfe1d8f90738f5dc, 0x0,
    0xbfaa8d9f39bcffd4, 0x0,
    0x3fdbfd1e0f00fdb9, 0x0,
    0x3fe77a6ec58da4d2, 0x0,
    0x3fdd1e94ab272bec, 0x0,
    0xbfb33b28878102c6, 0x0,
    0xbfe0243b527cc0a3, 0x0,
    0xbfe55d51b8fdcdfd, 0x0,
    0xbfe075a56314e546, 0x0,
    0xbfa41b0400f76c21, 0x0,
    0x3fe1cd302acf2d02, 0x0,
    0x3fe4c7ec87149b6e, 0x0,
    0x3fde97fe2e8962f8, 0x0,
    0x3f86ec5f0c29b937, 0x0,
    0xbfd7f858e34076f0, 0x0,
    0xbfe61fffa953409e, 0x0,
    0xbfdf68839b5819fd, 0x0,
    0xbf8595144607783b, 0x0,
    0x3fdaf633ad2c2d29, 0x0,
    0x3fe81418c9910b79, 0x0,
    0x3fdf9eada4ebc61d, 0x0,
    0x3fa17b1aa3de9150, 0x0,
    0xbfe1acf0732e1b6a, 0x0,
    0xbfe704cedc5652f7, 0x0,
    0xbfe1ec7b237177b6, 0x0,
    0xbf954e8136761387, 0x0,
    0x3fddffeb0e6ab84b, 0x0,
    0x3fe40cfcf2c539b0, 0x0,
    0x3fe1b0819753aaa8, 0x0,
    0xbfab192b0f3930b5, 0x0,
    0xbfd723fc12e99b42, 0x0,
    0xbfe841a7c17021c7, 0x0,
    0xbfdf58e771a4ac79, 0x0,
    0xbf95dae312afdae4, 0x0,
    0x3fdc16b9f00a589a, 0x0,
    0x3fe8f8ad0c92a74e, 0x0,
    0x3fe0fca539533313, 0x0,
    0xbf9ab11c783fe068, 0x0,
    0xbfe1628f059a7fd0, 0x0,
    0xbfe7eb43c547f956, 0x0,
    0xbfde7aa69a3ac97a, 0x0,
    0x3f98344f6ccb7c52, 0x0,
    0x3fdcc58d5ba51589, 0x0,
    0x3fe4b620bf49b255, 0x0,
    0x3fde50febcf144a1, 0x0,
    0xbfb0d5cb5f79c517, 0x0,
    0xbfe3a01ae8e9d982, 0x0,
    0xbfe56c36c0eebbac, 0x0,
    0xbfde20b7ae7064a7, 0x0,
    0xbf97509b0d7fbe8e, 0x0,
    0x3fde753c9f26a668, 0x0,
    0x3fe416213d26d329, 0x0,
    0x3fdb465a7d48cb9c, 0x0,
    0x3f76ab7207f3e3cd, 0x0,
    0xbfe3f3cbe9a415bf, 0x0,
    0xbfe470e9fe859001, 0x0,
    0xbfe05b06c552dbfb, 0x0,
    0x3f8783ec50d88aa9, 0x0,
    0x3fe0dd5125ef5d4b, 0x0,
    0x3fe67505ade65061, 0x0,
    0x3fdd1ab494f5729a, 0x0,
    0xbf9087fa9af027cf, 0x0,
    0xbfde689f3898329e, 0x0,
    0xbfe60fc1c674efb7, 0x0,
    0xbfe0ccfe8820ef30, 0x0,
    0x3f6841784d454a8f, 0x0,
    0x3fdf2506f792e4b9, 0x0,
    0x3fe64d4ffe4f8b26, 0x0,
    0x3fdbbe266b4766e7, 0x0,
    0xbfac025e5812b21f, 0x0,
    0xbfe1d7aa5dbdd890, 0x0,
    0xbfe7033933fd29b5, 0x0,
    0xbfe19a6b3725b2c4, 0x0,
    0xbf9e687739c83968, 0x0,
    0x3fdeebe9909182ee, 0x0,
    0x3fe4adef8744fbed, 0x0,
    0x3fe008df43f7ac1e, 0x0,
    0x3fb388857846700d, 0x0,
    0xbfe4ee8d1b1ff12a, 0x0,
    0xbfe8297d1d78df4c, 0x0,
    0xbfdef57c565e92b4, 0x0,
    0xbfa15d0c9f7ecdf6, 0x0,
    0x3fe34660cf0d7d0e, 0x0,
    0x3fea0d76ddf8a404, 0x0,
    0x3fdef335beb8b73d, 0x0,
    0xbf8e5878a3bb1354, 0x0,
    0xbfdca052d22fe898, 0x0,
    0xbfe67c1d2ee60c08, 0x0,
    0xbfd8d2ee6a16b35e, 0x0,
    0x3fb207c12d31a08e, 0x0,
    0x3fe06991ace6e513, 0x0,
    0x3fe5ab5109c3b54f, 0x0,
    0x3fdfde5816150ca3, 0x0,
    0x3f93576109888690, 0x0,
    0xbfdc8368a0b8fcf0, 0x0,
    0xbfe3d2957438a45e, 0x0,
    0xbfe0749f1cea6747, 0x0,
    0x3fb1acf0a3b776eb, 0x0,
    0x3fe0b2d8739247ae, 0x0,
    0x3fe6416442de026d, 0x0,
    0x3fe1a877b8311dbf, 0x0,
    0xbf7bb9b4937eea81, 0x0,
    0xbfe26f87e630a595, 0x0,
    0xbfe6fb4fdacbf43f, 0x0,
    0xbfe2025fe0385188, 0x0,
    0x3fab4f147b7dac23, 0x0,
    0x3fe0ae5c530424f5, 0x0,
    0x3fe5ab51def85834, 0x0,
    0x3fe135ca27856900, 0x0,
    0xbfbdc830a4086922, 0x0,
    0xbfe1774d9e53bc97, 0x0,
    0xbfe6d260cd3dc61a, 0x0,
    0xbfdc7a97e77a6a99, 0x0,
    0x3fa1d8a01626a51f, 0x0,
    0x3fdf3cfb00df6050, 0x0,
    0x3fe6b4a1c977864e, 0x0,
    0x3fd87054002b7a94, 0x0,
    0x3f957bce91612046, 0x0,
    0xbfdc87c4a93dbccc, 0x0,
    0xbfe6ce4cefcd1416, 0x0,
    0xbfe15546dd47c55b, 0x0,
    0x3f660494faba08e9, 0x0,
    0x3fe09ef9285bf0f1, 0x0,
    0x3fe5add6be99cb7d, 0x0,
    0x3fde7c0ee22a85bf, 0x0,
    0xbf8826e1b94af569, 0x0,
    0xbfe1035934eba999, 0x0,
    0xbfe7ba8c9a7d41ef, 0x0,
    0xbfd8d667af75361b, 0x0,
    0xbf8ed201ab43485e, 0x0,
    0x3fded29785e572ff, 0x0,
    0x3fe50f57fbe8b342, 0x0,
    0x3fe28509f45fab1a, 0x0,
    0xbf88265a54b506f6, 0x0,
    0xbfde681ba103e974, 0x0,
    0xbfe9666722ba3e8d, 0x0,
    0xbfdb7b36b89c0d3f, 0x0,
    0xbf99702e165ce8b8, 0x0,
    0x3fe02dc97cf19016, 0x0,
    0x3fe53410b9db05cb, 0x0,
    0x3fdafd72098bd7b8, 0x0,
    0xbfb8d93072d2c881, 0x0,
    0xbfe08c6e34f5c29e, 0x0,
    0xbfe71f03361c9256, 0x0,
    0xbfdb867bf8bcb1f2, 0x0,
    0xbfa2c41e6477eda9, 0x0,
    0x3fe11627ad2d2127, 0x0,
    0x3fe3d958a50976dc, 0x0,
    0x3fdc3a07877ed2f6, 0x0,
    0x3f8c05934cdc720b, 0x0,
    0xbfe04b917d143ab0, 0x0,
    0xbfe81b8c5efb4c17, 0x0,
    0xbfdba592cfd5df59, 0x0,
    0xbf950a85ba696e4f, 0x0,
    0x3fe0f9bfa5bc7b7c, 0x0,
    0x3fe59885bca89c76, 0x0,
    0x3fdf1ab75ac25a37, 0x0,
    0x3f81be68e7ebf2bb, 0x0,
    0xbfe08aa8f18ccebb, 0x0,
    0xbfe519354c78f0a9, 0x0,
    0xbfe0f1a53f51ebe4, 0x0,
    0x3fa6cbef858eeced, 0x0,
    0x3fdd567adbb43ccf, 0x0,
    0x3fe29a459807b4ee, 0x0,
    0x3fdf0a8a425bb75f, 0x0,
    0x3f982277633f2ce6, 0x0,
    0xbfdfdb1b6816f03e, 0x0,
    0xbfe825b7a72177fe, 0x0,
    0xbfe0a24886968cdf, 0x0,
    0xbfaf3e40593f117c, 0x0,
    0x3fdc9141eb4b6e2d, 0x0,
    0x3fe698bf6b0f3152, 0x0,
    0x3fe1f1d3178ead46, 0x0,
    0xbf98c299a4f8e1a3, 0x0,
    0xbfe1c1d816e6ff1d, 0x0,
    0xbfe79ada8e66aadc, 0x0,
    0xbfdf07ec37ecc48f, 0x0,
    0x3fb37c50c867a138, 0x0,
    0x3fdf484abdc17c94, 0x0,
    0x3fe7308896fd12a1, 0x0,
    0x3fe00644620a375a, 0x0,
    0xbf91d5e99c99d184, 0x0,
    0xbfde260ab9230881, 0x0,
    0xbfe6797d28e2a2ec, 0x0,
    0xbfd961e332c4715d, 0x0,
    0x3f514a7032d9f7ba, 0x0,
    0x3fe0cf0baa69d487, 0x0,
    0x3fe4b5dd2b741464, 0x0,
    0x3fdc84c7c27eb8b2, 0x0,
    0xbfbb57cc1af6d386, 0x0,
    0xbfe11f78cc485b19, 0x0,
    0xbfe81eb2f81dcbe6, 0x0,
    0xbfdee010e5fdd7bf, 0x0,
    0xbfb8c26b1089b9b9, 0x0,
    0x3fdde808677e75fa, 0x0,
    0x3fe73b15ba962d4e, 0x0,
    0x3fe30810870589b5, 0x0,
    0xbf8f1a9f2e1bf833, 0x0,
    0xbfdfb8bccd29fd02, 0x0,
    0xbfe65a55c9373a67, 0x0,
    0xbfdd6b320ab3c391, 0x0,
    0xbfa7f39856b086dc, 0x0,
    0x3fdc0788330081ab, 0x0,
    0x3fe6fab95e096e67, 0x0,
    0x3fe042277898a448, 0x0,
    0x3fa6719e3bc73430, 0x0,
    0xbfdcb56d4b28bdb2, 0x0,
    0xbfe688d62c325b48, 0x0,
    0xbfe1fb16853c4af2, 0x0,
    0x3f839e4739607849, 0x0,
    0x3fdad5bcb1646ec8, 0x0,
    0x3fe5c63c390b776a, 0x0,
    0x3fe175bfadce1741, 0x0,
    0xbfaf959adf5802bd, 0x0,
    0xbfe0f1abd3a40dd5, 0x0,
    0xbfe534afb4af1c8b, 0x0,
    0xbfe1407e102b3e47, 0x0,
    0x3fa2aeb2da096e99, 0x0,
    0x3fe029736cd3aec0, 0x0,
    0x3fe7dd88f7fa4ea1, 0x0,
    0x3fdf1a7e37749040, 0x0,
    0x3f836e840d824288, 0x0,
    0xbfe145ea37576593, 0x0,
    0xbfe7f376788abd9b, 0x0,
    0xbfde9350221f0b6b, 0x0,
    0xbf9ba9e77e2d6c73, 0x0,
    0x3fe0297eb123276b, 0x0,
    0x3fe6f22bb6afec74, 0x0,
    0x3fe0097962e51fd0, 0x0,
    0xbf9690b97fd0fe46, 0x0,
    0xbfde68959900b3ee, 0x0,
    0xbfe5d863fd242873, 0x0,
    0xbfdf28090f5b8fd0, 0x0,
    0x3fb772c5347abde9, 0x0,
    0x3fe15117288d7122, 0x0,
    0x3fe60eb536df5d99, 0x0,
    0x3fdf8ed8d250b78f, 0x0,
    0xbf8970f2e6d55109, 0x0,
    0xbfdee482541a1b10, 0x0,
    0xbfe433b5131a9370, 0x0,
    0xbfe095533fcb47b5, 0x0,
    0x3f9e9c8f87dfaa65, 0x0,
    0x3fdfe52451c9cb43, 0x0,
    0x3fe76a0fe23af5c3, 0x0,
    0x3fe0a225a9babd8e, 0x0,
    0x3fa55fc87231b2d3, 0x0,
    0xbfe03ad42532b8ef, 0x0,
    0xbfe9f4eea109b84c, 0x0,
    0xbfdd41a244e4aed5, 0x0,
    0x3fb4b797a1061d94, 0x0,
    0x3fdb581d3fdd2730, 0x0,
    0x3fe6035f09add1f5, 0x0,
    0x3fdf43c87a9c1285, 0x0,
    0xbf7a790482320dca, 0x0,
    0xbfddf3a8d7ac0794, 0x0,
    0xbfe5108a7e273e63, 0x0,
    0xbfe0ccaea5c2a5bb, 0x0,
    0xbf88382354521aca, 0x0,
    0x3fe0e00c8a2ba810, 0x0,
    0x3fe57e785405ab8a, 0x0,
    0x3fdfc1ff5ceb7e19, 0x0,
    0x3fb56a3af69f5be6, 0x0,
    0xbfdfaa2dcc4f60ec, 0x0,
    0xbfe553833dabcbab, 0x0,
    0xbfde73bd9a2f2bce, 0x0,
    0x3f5037e2a244d2a1, 0x0,
    0x3fe03dd71faafa4d, 0x0,
    0x3fe593596f8ca88e, 0x0,
    0x3fd9400946b0d01e, 0x0,
    0xbfa11a257d68ca55, 0x0,
    0xbfe1110ca194901b, 0x0,
    0xbfe834c49336b473, 0x0,
    0xbfde8110bedc5c44, 0x0,
    0xbf8a157bf8763517, 0x0,
    0x3fe1de6cf5e30338, 0x0,
    0x3fe34f678fd3dfca, 0x0,
    0x3fdff1aa69a6cae0, 0x0,
    0x3f5f2595556189cb, 0x0,
    0xbfdc6015429d1e17, 0x0,
    0xbfe73fcb515e27ba, 0x0,
    0xbfe11ea9c18bffe8, 0x0,
    0x3fab709b1b610769, 0x0,
    0x3fdcafde41e7aa5d, 0x0,
    0x3fe5aa57cf20fb27, 0x0,
    0x3fdcf2eba5865784, 0x0,
    0xbfb3de35fbedbb3e, 0x0,
    0xbfdc03038c006cde, 0x0,
    0xbfe46f2a1555a6ff, 0x0,
    0xbfe06dc7cdb63d49, 0x0,
    0xbfa45713937c841c, 0x0,
    0x3fde833d1c4bc126, 0x0,
    0x3fe6440600392dfa, 0x0,
    0x3fe33263ca1c335f, 0x0,
    0x3fb0355661e12654, 0x0,
    0xbfdcdea7f64e5096, 0x0,
    0xbfe30bf801b4062d, 0x0,
    0xbfe204654a0b0a52, 0x0,
    0xbfade7e8fe494811, 0x0,
    0x3fde7f85a39cae44, 0x0,
    0x3fe5a7e46683a630, 0x0,
    0x3fdb31438b8d0675, 0x0,
    0x3f876634795ca053, 0x0,
    0xbfe0bf8479b42684, 0x0,
    0xbfe585307315a5a8, 0x0,
    0xbfdfc2ec6dfa44cd, 0x0,
    0x3f82fc27000a2f67, 0x0,
    0x3fdfe90ef9553fea, 0x0,
    0x3fe7b916bc7ee92e, 0x0,
    0x3fdcf2a8f8be86f9, 0x0,
    0xbf99b862c521947c, 0x0,
    0xbfdf3a5de2625015, 0x0,
    0xbfe6c45c1b4d6227, 0x0,
    0xbfe023690636a3a8, 0x0,
    0xbfac03ed93514af8, 0x0,
    0x3fe0cc3ce1f877c0, 0x0,
    0x3fe5bc304832ab05, 0x0,
    0x3fd9a86d6139f4d6, 0x0,
    0x3fa90c72298fb38d, 0x0,
    0xbfe0838b4c480ccf, 0x0,
    0xbfe71958a1fe36d3, 0x0,
    0xbfe1fec8324835b2, 0x0,
    0xbfb828ece88788d9, 0x0,
    0x3fe05a3096138c49, 0x0,
    0x3fe48d8cb1c3e185, 0x0,
    0x3fe00411a5371711, 0x0,
    0x3fa1aa0912d67645, 0x0,
    0xbfdf02432382dc69, 0x0,
    0xbfe71db666ea8f5c, 0x0,
    0xbfded4f8a7c7c444, 0x0,
    0x3f9c1b19e5a995bf, 0x0,
    0x3fe3127152a8a146, 0x0,
    0x3fe6544e432551dc, 0x0,
    0x3fe17e3118ee858e, 0x0,
    0x3f8769b73a0518e0, 0x0,
    0xbfe0253f3e10b1f5, 0x0,
    0xbfe605ab050aca48, 0x0,
    0xbfe0d9e2813f5da1, 0x0,
    0x3fa11f90969e4478, 0x0,
    0x3fdfafe56be057c0, 0x0,
    0x3fe83bc2980fb4fa, 0x0,
    0x3fdd11817346d23f, 0x0,
    0x3f9a0b3b74e58834, 0x0,
    0xbfe0170fcba257be, 0x0,
    0xbfe9ae3bba01435a, 0x0,
    0xbfe12522eeb70ede, 0x0,
    0x3fbdfbd43bea5e78, 0x0,
    0x3fdd264397302cb4, 0x0,
    0x3fe48e42a0646583, 0x0,
    0x3fda731ea8f30e6d, 0x0,
    0x3fb0366e4bd4caef, 0x0,
    0xbfe0b69f4c3099cd, 0x0,
    0xbfe91f29f11c4748, 0x0,
    0xbfdf38951884f567, 0x0,
    0xbfa606e253a8ad7b, 0x0,
    0x3fddb75dee87bfe1, 0x0,
    0x3fe627221cc4da3f, 0x0,
    0x3fdc1d47510bf787, 0x0,
    0xbf749a1a7bec8a41, 0x0,
    0xbfe28aeab0a090ba, 0x0,
    0xbfe76ce5d06305db, 0x0,
    0xbfe054ddef1b29a9, 0x0,
    0x3f89d24ae90a52c7, 0x0,
    0x3fdf7b9d7903e86f, 0x0,
    0x3fe76bfd38d16649, 0x0,
    0x3fde747bdebb19a7, 0x0,
    0xbf9ba94fc73cc72f, 0x0,
    0xbfe18c35fa8a99fe, 0x0,
    0xbfe4b4d126f8fefa, 0x0,
    0xbfe18d73565d08de, 0x0,
    0xbfc0640f2fed3585, 0x0,
    0x3fe15fa257d25d3a, 0x0,
    0x3fe95fef999067b2, 0x0,
    0x3fdfee47af1a41af, 0x0,
    0xbf8c3b5583b573fe, 0x0,
    0xbfdbb666d0e9ed3c, 0x0,
    0xbfe39fb337638a99, 0x0,
    0xbfe09876f4139046, 0x0,
    0x3fb51a4f4bac318b, 0x0,
    0x3fddec40d323e118, 0x0,
    0x3fe6b0c499b54a4b, 0x0,
    0x3fe1a1d2b930ea83, 0x0,
    0x3faf10f1a3d6a804, 0x0,
    0xbfdea041551b15f5, 0x0,
    0xbfe8a4baa2112dc3, 0x0,
    0xbfdc229993ce2b63, 0x0,
    0x3f4df971ced33ae4, 0x0,
    0x3fe10d0544705d56, 0x0,
    0x3fe809fdc94f52c0, 0x0,
    0x3fe164c729ebdc40, 0x0,
    0xbfb558624274b0f1, 0x0,
    0xbfe0f0567220c847, 0x0,
    0xbfe690e61af8a834, 0x0,
    0xbfe094cba9267f54, 0x0,
    0xbfac3d4ac50c17c3, 0x0,
    0x3fdc190bbf01bedc, 0x0,
    0x3fe7f024fc028743, 0x0,
    0x3fe0837804b0feef, 0x0,
    0xbfa15c105d9b3842, 0x0,
    0xbfe3a4425b58a894, 0x0,
    0xbfe7cf9c2c48e7a0, 0x0,
    0xbfdadcd72f6c2ea2, 0x0,
    0xbfae6e74b4eee63f, 0x0,
    0x3fe0946e830fe009, 0x0,
    0x3fe3174314ec67e4, 0x0,
    0x3fdc0f8fb078ee92, 0x0,
    0xbf8e90de70d5ea8c, 0x0,
    0xbfdd2a12902d0c5a, 0x0,
    0xbfea59da81b6080a, 0x0,
    0xbfdc50e052567814, 0x0,
    0xbf53bed6fc7d009c, 0x0,
    0x3fe0582b55f388a4, 0x0,
    0x3fe3e24145c6a7bf, 0x0,
    0x3fdee7291504bf67, 0x0,
    0xbfb1f960df8b3db6, 0x0,
    0xbfe1d152c9c51f13, 0x0,
    0xbfe308092a1e82f9, 0x0,
    0xbfd9e4dc71602968, 0x0,
    0x3fb6edbd79dd41c9, 0x0,
    0x3fe0483209f7d750, 0x0,
    0x3fe74e5104f08164, 0x0,
    0x3fe0c72647882963, 0x0,
    0xbf7fdd24ff00abe3, 0x0,
    0xbfdc6bb86e362ffc, 0x0,
    0xbfe9bba79c7daa00, 0x0,
    0xbfdc6c69dcb856aa, 0x0,
    0xbfa092c6db425900, 0x0,
    0x3fe2bd5ef54085b7, 0x0,
    0x3fe77c269a238607, 0x0,
    0x3fe11abfa7f8120e, 0x0,
    0xbfb11bd8d44cccbd, 0x0,
    0xbfe1cde56793fcaf, 0x0,
    0xbfe7725b25556673, 0x0,
    0xbfded9d0b9900b8c, 0x0,
    0x3fc246fd157c45e0, 0x0,
    0x3fe056a9a8f44312, 0x0,
    0x3fe58c57968340e4, 0x0,
    0x3fdd63937ab7af5f, 0x0,
    0x3f7f47fb17378366, 0x0,
    0xbfd9598bcaf932b3, 0x0,
    0xbfe8d5b9e393d875, 0x0,
    0xbfe0fda628045e73, 0x0,
    0x3f95024a740c4f2d, 0x0,
    0x3fe1f7e43f9fa698, 0x0,
    0x3fe4b02372ae1484, 0x0,
    0x3fdc6b5d8243ec35, 0x0,
    0xbf9c53c56a2824e6, 0x0,
    0xbfde01dfa09ff8c5, 0x0,
    0xbfe81c08bd9d4fd7, 0x0,
    0xbfdd84906e581e77, 0x0,
    0x3fb297c1a5f4e8ec, 0x0,
    0x3fe1d0f054995a96, 0x0,
    0x3fe6282ac96321f5, 0x0,
    0x3fdb085fc9da558f, 0x0,
    0xbf56416df7e71a66, 0x0,
    0xbfddefd10be57f9e, 0x0,
    0xbfe589586b1f46c3, 0x0,
    0xbfde90df74563b72, 0x0,
    0xbf907e7c1101f38d, 0x0,
    0x3fd90f4ac355cdba, 0x0,
    0x3fe5e3b594119b48, 0x0,
    0x3fe191529a0f6edf, 0x0,
    0xbf6a3a24ebd44ec6, 0x0,
    0xbfe087e5fd366924, 0x0,
    0xbfe5b3e198b02c29, 0x0,
    0xbfe0e1f1124ce279, 0x0,
    0x3fbb3ec01fa55ac4, 0x0,
    0x3fe253fec5d5e48b, 0x0,
    0x3fe6eaae3674d908, 0x0,
    0x3fe1196c84e340b5, 0x0,
    0x3f867c06f5086f70, 0x0,
    0xbfdb7de18c593a09, 0x0,
    0xbfe5c407cace7e38, 0x0,
    0xbfda47a07e3ec301, 0x0,
    0x3fac8cc92a7ae837, 0x0,
    0x3fe27ae48173ca5f, 0x0,
    0x3fe6d31413a0f4cc, 0x0,
    0x3fdb553fa25df9f0, 0x0,
    0x3fc1292604688a16, 0x0,
    0xbfe168eb5f76061c, 0x0,
    0xbfe52754bfb73be1, 0x0,
    0xbfdfb217ac7d8686, 0x0,
    0xbf93bd3dbcd99562, 0x0,
    0x3fe09b21b0c0de41, 0x0,
    0x3fe7f1a05822901a, 0x0,
    0x3fdf70788df01899, 0x0,
    0xbf99cf1369860a8e, 0x0,
    0xbfe04d663e000061, 0x0,
    0xbfe71230b9782a60, 0x0,
    0xbfddf463bea23d50, 0x0,
    0xbfa59147b45adf86, 0x0,
    0x3fdeed35da116354, 0x0,
    0x3fe70b434bdbb177, 0x0,
    0x3fdd25c1757eebcb, 0x0,
    0xbf9d3b8b5d50ec7c, 0x0,
    0xbfe069439b4c2853, 0x0,
    0xbfe5c8f0e978fc50, 0x0,
    0xbfde247fde0b7389, 0x0,
    0x3f7ea40930dcda8b, 0x0,
    0x3fde9eea0f1b3986, 0x0,
    0x3fe5ec3bb3a82ebd, 0x0,
    0x3fddb5c56a2d8ecc, 0x0,
    0x3fa4a8e257c2418a, 0x0,
    0xbfddc5e14ba6ba48, 0x0,
    0xbfe684a3d66cad5d, 0x0,
    0xbfd8e6a0d2ab69e2, 0x0,
    0xbfb1f7e94ccb3cda, 0x0,
    0x3fe0bad9ef81eedd, 0x0,
    0x3fe5e67dab3e67ef, 0x0,
    0x3fde5665da334712, 0x0,
    0xbfb73da0e4f21184, 0x0,
    0xbfdd2b25cf03f7c6, 0x0,
    0xbfe72f2d3720bbd8, 0x0,
    0xbfdfddb367b0fc38, 0x0,
    0x3faccc9858565b20, 0x0,
    0x3fdbf30ae2f634ff, 0x0,
    0x3fe61c9090af469c, 0x0,
    0x3fdcf8cda04d472d, 0x0,
    0x3f510a158f77c8fe, 0x0,
    0xbfe02df4ede2dff8, 0x0,
    0xbfe8e77db2d8aa6a, 0x0,
    0xbfdcfdcd4b0d63ec, 0x0,
    0xbf962d47268f11db, 0x0,
    0x3fdc44ca36050892, 0x0,
    0x3fe953fae4b19834, 0x0,
    0x3fe0f2c116699f3d, 0x0,
    0x3fb56c0dc2548eec, 0x0,
    0xbfe0d71e202d748a, 0x0,
    0xbfe5ea2f26798993, 0x0,
    0xbfe0b7ddf4ed6709, 0x0,
    0xbfc16abdcfcb5328, 0x0,
    0x3fe00e04d0a2957f, 0x0,
    0x3fe40db3d7903ec7, 0x0,
    0x3fdacd6d43b50230, 0x0,
    0x3fbdf02fe125c724, 0x0,
    0xbfe009c56bc65f5b, 0x0,
    0xbfe6617cef9d499d, 0x0,
    0xbfdcd7d7cb8aaf68, 0x0,
    0xbf9ceeda6b262439, 0x0,
    0x3fdf4c0987f46a50, 0x0,
    0x3fe70e4b688c1273, 0x0,
    0x3fe05fe407a8bd99, 0x0,
    0xbf9234c4e8d76d5e, 0x0,
    0xbfe15400ea85244d, 0x0,
    0xbfe5942b2ae90fa7, 0x0,
    0xbfdc5368815c35b7, 0x0,
    0xbf8e00e62a3dd518, 0x0,
    0x3fe09b8752add287, 0x0,
    0x3fe3686674f07f9f, 0x0,
    0x3fe35c9f13a5dbab, 0x0,
    0xbfba0fae82a48fbd, 0x0,
    0xbfe00459cf41200f, 0x0,
    0xbfe5a76846483812, 0x0,
    0xbfdf26416079f94b, 0x0,
    0x3fbcb11f3e43f1e3, 0x0,
    0x3fde7ffd94835a3d, 0x0,
    0x3fe8e2256cef14b8, 0x0,
    0x3fddff9a1a272e9c, 0x0,
    0xbfb11ad6cc8f4017, 0x0,
    0xbfde24376dfcd1a4, 0x0,
    0xbfe679cf9512e229, 0x0,
    0xbfe0727b61fe94c7, 0x0,
    0xbf979b8e903b4dac, 0x0,
    0x3fe2885c1f8c0ae0, 0x0,
    0x3fe797563459ca61, 0x0,
    0x3fe07d3d15cd19f3, 0x0,
    0x3fb827f4d0e9ed78, 0x0,
    0xbfdddb1905dd2c9b, 0x0,
    0xbfe5d7df4d54059f, 0x0,
    0xbfdef63a1b520a8c, 0x0,
    0xbfb7c9d8b33ed939, 0x0,
    0x3fe0b76657ae891c, 0x0,
    0x3fe4561f5f5c6921, 0x0,
    0x3fdec61eaeb901da, 0x0,
    0xbf4a802f6037312b, 0x0,
    0xbfe070ae0f7c2659, 0x0,
    0xbfe4c1a0b980f45a, 0x0,
    0xbfe12f7d2f67564a, 0x0,
    0xbf947a71c8e77e86, 0x0,
    0x3fdfe57881b3f1f3, 0x0,
    0x3fe2da191c140f88, 0x0,
    0x3fdb7f2ed0966f98, 0x0,
    0xbfa58ab5cd468bc8, 0x0,
    0xbfdd2d48c7a802b0, 0x0,
    0xbfea38e6e3d966b9, 0x0,
    0xbfe21d2a9244d78f, 0x0,
    0x3fb3bcd133db85b9, 0x0,
    0x3fe0658354c7568b, 0x0,
    0x3fe54f7e4a39a3de, 0x0,
    0x3fe00f8822757728, 0x0,
    0x3f9996805c62ebe9, 0x0,
    0xbfdb561040be9afe, 0x0,
    0xbfe6380d7c9653e8, 0x0,
    0xbfe0d59cf50cad85, 0x0,
    0xbfa69b02cc359405, 0x0,
    0x3fdc84949923a418, 0x0,
    0x3fe4433e03ec909d, 0x0,
    0x3fdf1ad5408975da, 0x0,
    0xbfac5a316e24a088, 0x0,
    0xbfe1896b1d6f906d, 0x0,
    0xbfe78b50fef50743, 0x0,
    0xbfdf296be7ece37d, 0x0,
    0xbf914bec89666691, 0x0,
    0x3fdb216da7fcb663, 0x0,
    0x3fe7e83cd5069623, 0x0,
    0x3fe28d2c910fdbbd, 0x0,
    0xbfa5a4a410ddbf61, 0x0,
    0xbfe0507a2fd08d42, 0x0,
    0xbfe7005dd56bc6f1, 0x0,
    0xbfde4c57538f3f1c, 0x0,
    0xbf86962821453daa, 0x0,
    0x3fe05e476f03a6b9, 0x0,
    0x3fe82dc4ecf3380c, 0x0,
    0x3fe13acefabc2fc3, 0x0,
    0xbfa315a40a7935fb, 0x0,
    0xbfe066d965706c42, 0x0,
    0xbfe5deb426a0c4e7, 0x0,
    0xbfe0bb2be7757323, 0x0,
    0xbf87574cd556a40f, 0x0,
    0x3fdb4f38f43d8576, 0x0,
    0x3fe700886cb64d9a, 0x0,
    0x3fe1473cb5fd858f, 0x0,
    0xbfa0add6dc30ab05, 0x0,
    0xbfe1900f3bf65ec4, 0x0,
    0xbfe3f6ded108a9f2, 0x0,
    0xbfde63e64ed725fd, 0x0,
    0xbf98333ede91239a, 0x0,
    0x3fdf7ceab673fd97, 0x0,
    0x3fe6585382a33728, 0x0,
    0x3fdf5318a488077a, 0x0,
    0xbfa6d7d2e17e4537, 0x0,
    0xbfe1b15d427daa93, 0x0,
    0xbfe68c428d90de4f, 0x0,
    0xbfddab28751e00fd, 0x0,
    0xbf9328fb1b7f07b5, 0x0,
    0x3fdaf4972c472493, 0x0,
    0x3fe6b1ca12b06364, 0x0,
    0x3fe278eed249f45b, 0x0,
    0x3fafedf53c8799a2, 0x0,
    0xbfdeb88744694293, 0x0,
    0xbfe68d5b3b0fa61a, 0x0,
    0xbfdd93b774f7f60d, 0x0,
    0x3fb1e44838892df2, 0x0,
    0x3fdfbb46dcc3509b, 0x0,
    0x3fe5ff1ef517b95a, 0x0,
    0x3fdef8346bdf756e, 0x0,
    0xbf958a67f3ea2135, 0x0,
    0xbfe2288224b2b78c, 0x0,
    0xbfe6cdee0324a362, 0x0,
    0xbfdcb8d8dfe1bddd, 0x0,
    0xbfabb706b2d44930, 0x0,
    0x3fe0cc2931c26fa8, 0x0,
    0x3fe74ffefa0594e2, 0x0,
    0x3fdbb74305a18e91, 0x0,
    0x3f9c6fb696d13e05, 0x0,
    0xbfdc6e00eccb4fc8, 0x0,
    0xbfe56246c8ba99ad, 0x0,
    0xbfe1e3b2ce04d5a2, 0x0,
    0xbf89cf86ffa3d6fe, 0x0,
    0x3fe10768bc1b0a9c, 0x0,
    0x3fe975481163ee66, 0x0,
    0x3fe43fdaf6f71f41, 0x0,
    0xbf98ac2c38eae783, 0x0,
    0xbfe108bbda2c6e70, 0x0,
    0xbfe72854960b0b32, 0x0,
    0xbfe2f791b1e0b66c, 0x0,
    0xbfa11622622281df, 0x0,
    0x3fe2e04a346ba99a, 0x0,
    0x3fe5235c4efc3431, 0x0,
    0x3fe1f803eeecd9df, 0x0,
    0x3f8ed34b3e091fcc, 0x0,
    0xbfdc204b47d2c04a, 0x0,
    0xbfe6392970ea5fbc, 0x0,
    0xbfe0cdcbffaf26dd, 0x0,
    0x3fa6dc0d4490a8f6, 0x0,
    0x3fde4f2c0ad632ec, 0x0,
    0x3fe6ac848969013a, 0x0,
    0x3fdd3c58046b0fe8, 0x0,
    0x3fb0ee6f5530255f, 0x0,
    0xbfe4b285dfee4180, 0x0,
    0xbfe5747663f2cb87, 0x0,
    0xbfdd3736cc051c44, 0x0,
    0xbfb33a24ba283aa8, 0x0,
    0x3fda32b577f25510, 0x0,
    0x3fe49618d3bc1aa2, 0x0,
    0x3fe2e72799d5bb3a, 0x0,
    0x3f96c9cc1b639fa9, 0x0,
    0xbfde8e52a257cf3b, 0x0,
    0xbfe5907102facb24, 0x0,
    0xbfdd6fe0f1077333, 0x0,
    0xbfa237f9cd630f0b, 0x0,
    0x3fe2466bf29ea244, 0x0,
    0x3fe58acb88f7cd83, 0x0,
    0x3fdd962af5e0fc95, 0x0,
    0xbfa43807e9763b16, 0x0,
    0xbfe224ecaf0768e6, 0x0,
    0xbfe5c7c15781d869, 0x0,
    0xbfde0e52ee185d66, 0x0,
    0xbf9b579909ae216b, 0x0,
    0x3fdcff21aa28a659, 0x0,
    0x3fe98fbb0e51c28a, 0x0,
    0x3fe12f0aa3ac0d23, 0x0,
    0xbf9c3493c85f5a48, 0x0,
    0xbfe1e8f43f282f0b, 0x0,
    0xbfe915b9b9c85ab8, 0x0,
    0xbfdf4ca114bb3191, 0x0,
    0xbf9fe04a6918af99, 0x0,
    0x3fdded8ecdf7c668, 0x0,
    0x3fe7874c24f5da44, 0x0,
    0x3fe0b55822baafbf, 0x0,
    0x3f4b586cd151d00a, 0x0,
    0xbfde42000ac44757, 0x0,
    0xbfe6f4232abcbb80, 0x0,
    0xbfe07dfc00156ccb, 0x0,
    0x3fb5315fcbd12141, 0x0,
    0x3fe0e3ed7263987f, 0x0,
    0x3fe337177f660260, 0x0,
    0x3fdd935be0914f0e, 0x0,
    0x3f820f9c18dc166a, 0x0,
    0xbfe07269e92bd14c, 0x0,
    0xbfe552e15fbaa8ae, 0x0,
    0xbfe17095f5cd2f55, 0x0,
    0xbf7108d87c3c5598, 0x0,
    0x3fdf746a0f62e618, 0x0,
    0x3fe7ebcd94eb46e0, 0x0,
    0x3fe00c907142d6fe, 0x0,
    0xbfb5d41ac7f697a3, 0x0,
    0xbfe0773ae940b538, 0x0,
    0xbfe63dc558d522eb, 0x0,
    0xbfdec3e374ffb71a, 0x0,
    0x3fb5ea3840179d38, 0x0,
    0x3fdf906ada7da588, 0x0,
    0x3fe847e37229fe83, 0x0,
    0x3fe25788d4890a29, 0x0,
    0x3f9f8ce71947569d, 0x0,
    0xbfdda67f0e47702a, 0x0,
    0xbfe64fc947feed5e, 0x0,
    0xbfd8cdc3ad0596e5, 0x0,
    0x3f746025c79779df, 0x0,
    0x3fe1e770b249c0a2, 0x0,
    0x3fe6bf684cf86660, 0x0,
    0x3fdf1e29e57449f2, 0x0,
    0x3f95d599ca888835, 0x0,
    0xbfdaa1feaf7ce382, 0x0,
    0xbfe6f32b5b64ec60, 0x0,
    0xbfdb7c6694371c4b, 0x0,
    0x3fa7ec0fffbb8d5d, 0x0,
    0x3fe111796e996418, 0x0,
    0x3fe6855a73b793d8, 0x0,
    0x3fdbe6ef9ffff060, 0x0,
    0xbfac4f612739eccc, 0x0,
    0xbfe0cecd0c447464, 0x0,
    0xbfe7b20ee9dbdb40, 0x0,
    0xbfe1c1f59279488c, 0x0,
    0xbfab0dcc751ecf92, 0x0,
    0x3fe13f8b9ec3b855, 0x0,
    0x3fe5405b23103b7e, 0x0,
    0x3fe175e566d89c95, 0x0,
    0x3fa01b6b0128b653, 0x0,
    0xbfde3e21ade38f68, 0x0,
    0xbfe3e2d68d993b50, 0x0,
    0xbfdbae312d653d87, 0x0,
    0x3f91167d4eba9d36, 0x0,
    0x3fdf7fbf2a285efe, 0x0,
    0x3fe649a1bf1e8c0e, 0x0,
    0x3fdb72c2d585ea18, 0x0,
    0x3faf49208dd8626b, 0x0,
    0xbfe0a950d20b53cd, 0x0,
    0xbfe82526d95c3371, 0x0,
    0xbfe00a00a70b05d3, 0x0,
    0xbf9d13ba78132855, 0x0,
    0x3fdee8d8eb101b79, 0x0,
    0x3fe6ad7030380757, 0x0,
    0x3fe177f52a77d115, 0x0,
    0x3f93a9e8cc632e87, 0x0,
    0xbfe0813c266e88d4, 0x0,
    0xbfe6cfb5ec35e42b, 0x0,
    0xbfdca7aca48109f0, 0x0,
    0xbfa8430e2c27e336, 0x0,
    0x3fdecbd38c9fa4b0, 0x0,
    0x3fe2640532a35e35, 0x0,
    0x3fe0460cb90967b7, 0x0,
    0xbfab800aa2a19b6e, 0x0,
    0xbfdfbaf59d44fea7, 0x0,
    0xbfe5bda37e66a3fb, 0x0,
    0xbfe12ace30e43fe5, 0x0,
    0x3faee44c53c56e85, 0x0,
    0x3fde025b959f674a, 0x0,
    0x3fe8ddf1d7e31bc5, 0x0,
    0x3fe001da12874737, 0x0,
    0xbfaa0af69c38719b, 0x0,
    0xbfdba6f00d696cbb, 0x0,
    0xbfe7605fa02190aa, 0x0,
    0xbfdcfafd6b68fc9a, 0x0,
    0xbfa4b5344aca0544, 0x0,
    0x3fdde66cbf6176fd, 0x0,
    0x3fe935cc2e1b7d25, 0x0,
    0x3fdd02d765471564, 0x0,
    0x3f97abf090912071, 0x0,
    0xbfe1c7c954557d12, 0x0,
    0xbfe738b1197b44c6, 0x0,
    0xbfdcef2e9f1444e6, 0x0,
    0xbf90704cbbb2d361, 0x0,
    0x3fdba86d0da1fc96, 0x0,
    0x3fe681083f0a0560, 0x0,
    0x3fe064760a4c7fee, 0x0,
    0xbfb15506d59d04a3, 0x0,
    0xbfe0208e8044cf89, 0x0,
    0xbfe7baf597897354, 0x0,
    0xbfe21bad0c4893ed, 0x0,
    0x3f976f197eb4b414, 0x0,
    0x3fdf137556b10daf, 0x0,
    0x3fe7096822b97d0d, 0x0,
    0x3fe18181e02592b4, 0x0,
    0xbf6c391695548320, 0x0,
    0xbfdda626b0c50ea6, 0x0,
    0xbfe53d46a2680401, 0x0,
    0xbfdedd18a7029148, 0x0,
    0x3f57148ab9600fb8, 0x0,
    0x3fdb89485e49c132, 0x0,
    0x3fe7ba6e2c51a89b, 0x0,
    0x3fdcfd159aa3f076, 0x0,
    0x3fa12b7468bfcb72, 0x0,
    0xbfdf438c84d6d08c, 0x0,
    0xbfe5a41c11eb1385, 0x0,
    0xbfe1341331389fe0, 0x0,
    0xbfaef77f94d4ca19, 0x0,
    0x3fe01f88ae94270e, 0x0,
    0x3fe64f995720a8b1, 0x0,
    0x3fdd6c25133d26d4, 0x0,
    0x3fbd30acbdf0b039, 0x0,
    0xbfdd1dadddc115e5, 0x0,
    0xbfe5a784090e1066, 0x0,
    0xbfdc1caaaffbbf46, 0x0,
    0xbf86b9f6e383a313, 0x0,
    0x3fe11a111351b788, 0x0,
    0x3fe62d239757ff46, 0x0,
    0x3fdd6b62db079071, 0x0,
    0x3fa44cd05ea07dea, 0x0,
    0xbfe21f51a6aa2d6e, 0x0,
    0xbfe859a8799215bb, 0x0,
    0xbfe187ec404e177a, 0x0,
    0xbfac43b8a2de43d1, 0x0,
    0x3fdc5028aa6011dd, 0x0,
    0x3fe9057bd653a328, 0x0,
    0x3fe08afa1132622b, 0x0,
    0xbfa1a8af401a5b16, 0x0,
    0xbfdcade119d92c3e, 0x0,
    0xbfe5fad29df0d7dd, 0x0,
    0xbfe11c894764c752, 0x0,
    0xbf90c3f09afdd0f4, 0x0,
    0x3fe19e528740551e, 0x0,
    0x3fea81f28410df68, 0x0,
    0x3fde3dbca0cfbca7, 0x0,
    0xbfa08a4ad10418d1, 0x0,
    0xbfde24b90953110a, 0x0,
    0xbfe3197258889808, 0x0,
    0xbfdd4d63b4c5c187, 0x0,
    0xbf17f9005057d8f9, 0x0,
    0x3fe0798594355b8a, 0x0,
    0x3fe6ad4d213b4e8b, 0x0,
    0x3fe0b7555cf9c654, 0x0,
    0x3f985f8bd07446af, 0x0,
    0xbfe15f7dfd71708f, 0x0,
    0xbfe6f169b6e0caaf, 0x0,
    0xbfdcd1d74ec32ba5, 0x0,
    0xbfb14117f68b4fef, 0x0,
    0x3fe071cc3f9eda3c, 0x0,
    0x3fe651a1305da620, 0x0,
    0x3fe1da126ef486ca, 0x0,
    0xbfb6bf1839ac186a, 0x0,
    0xbfe03c3f5432c2c9, 0x0,
    0xbfe5f154f4e0abbd, 0x0,
    0xbfde821361f3e3c7, 0x0,
    0xbf8cf666a3445e35, 0x0,
    0x3fddac5fc9e5bec8, 0x0,
    0x3fea1b0c81315192, 0x0,
    0x3fdf8bb0b3e464e3, 0x0,
    0x3fba03da40e6f746, 0x0,
    0xbfe0fcef0c3574db, 0x0,
    0xbfe4ca33c7516b89, 0x0,
    0xbfdd3fbd128cf81e, 0x0,
    0xbfa480df567903aa, 0x0,
    0x3fde51248c141ff0, 0x0,
    0x3fe676ae917f7a01, 0x0,
    0x3fdc4ef89839340a, 0x0,
    0x3f93480757b67499, 0x0,
    0xbfdb57f366b1a22a, 0x0,
    0xbfe7a90c1865084b, 0x0,
    0xbfddda8f9d45c92e, 0x0,
    0xbfa6ff710acc834e, 0x0,
    0x3fdf117d1ee832af, 0x0,
    0x3fe62383e3e62184, 0x0,
    0x3fe03ab66453ea38, 0x0,
    0xbf97d346b0ce8d2e, 0x0,
    0xbfe014d5b3505d0d, 0x0,
    0xbfe6f657ccdf9b00, 0x0,
    0xbfe0cc430306d228, 0x0,
    0xbf81d9365313825f, 0x0,
    0x3fdfcf3ec9e2ff61, 0x0,
    0x3fe6fc8c8e3ff383, 0x0,
    0x3fde6378b40745e0, 0x0,
    0xbfadcb13f7260f42, 0x0,
    0xbfe1bbbc896024c8, 0x0,
    0xbfe6892cebae8b98, 0x0,
    0xbfe2394110101d5d, 0x0,
    0x3fa90c09b137dda7, 0x0,
    0x3fe0bc7d5b7aeae6, 0x0,
    0x3fe6709ea2bf1b5e, 0x0,
    0x3fe185f3a781556d, 0x0,
    0xbf864117d5b02d89, 0x0,
    0xbfdccb75e2fa3a1a, 0x0,
    0xbfe7628532633c8b, 0x0,
    0xbfe02395b7bb50f8, 0x0,
    0xbfa54fe6d79c5e0f, 0x0,
    0x3fdd497286b45574, 0x0,
    0x3fe524695e553e06, 0x0,
    0x3fdc36261cdb6568, 0x0,
    0x3fbee48563457862, 0x0,
    0xbfdefb79f7042565, 0x0,
    0xbfe855bec7758230, 0x0,
    0xbfdc23caa6719e68, 0x0,
    0x3fa9d9ae420b8aa3, 0x0,
    0x3fde50093fe553a1, 0x0,
    0x3fe60dd14c58d8d6, 0x0,
    0x3fe044e9434bb96a, 0x0,
    0xbf805c663dd324e0, 0x0,
    0xbfe1c09ef4466cae, 0x0,
    0xbfe89d8cde6ac487, 0x0,
    0xbfe072d354dfec02, 0x0,
    0x3faafa484d39b002, 0x0,
    0x3fde8329145223c7, 0x0,
    0x3fe8c72c34df688b, 0x0,
    0x3fe2159be759ab22, 0x0,
    0x3fa465fb50fe34eb, 0x0,
    0xbfe113201e24a1bb, 0x0,
    0xbfe90699f8684753, 0x0,
    0xbfe40feb1a414777, 0x0,
    0x3f8ddb503e801ce2, 0x0,
    0x3fdd600f3294e30e, 0x0,
    0x3fe7b280c2ad9806, 0x0,
    0x3fe00e47c4d97f03, 0x0,
    0xbf9cacfd2b786a65, 0x0,
    0xbfe32e1047f64553, 0x0,
    0xbfe38d5b9436bbff, 0x0,
    0xbfe06b4446b033b3, 0x0,
    0x3f85822f4f416849, 0x0,
    0x3fe10255d24c6f82, 0x0,
    0x3fe4d01345e8efd3, 0x0,
    0x3fe0bceee5a0b340, 0x0,
    0x3f8fa1a9dffe6ed6, 0x0,
    0xbfdb05857f039ba3, 0x0,
    0xbfe596c0102a42fb, 0x0,
    0xbfe2bde608d5e7f8, 0x0,
    0xbf6536a807602eca, 0x0,
    0x3fe0c7232c68b1c7, 0x0,
    0x3fe643bed2c796f3, 0x0,
    0x3fe360d3c65c33a4, 0x0,
    0x3f9009da0b4484e2, 0x0,
    0xbfd957fc44ab7914, 0x0,
    0xbfe6ae4c318cea14, 0x0,
    0xbfe0b351f740c206, 0x0,
    0xbf459c7468ddc0da, 0x0,
    0x3fdde0e7d7bfaa60, 0x0,
    0x3fe529fe889db23c, 0x0,
    0x3fdceec1db747706, 0x0,
    0xbfad4906c70c3ebc, 0x0,
    0xbfdfa7f61ed75284, 0x0,
    0xbfe4f4c25b1570e1, 0x0,
    0xbfdf49080f169e7f, 0x0,
    0x3fa587ef3236102d, 0x0,
    0x3fe040d942d956e3, 0x0,
    0x3fe63ac5bad3fa6d, 0x0,
    0x3fdf9ec3abacc47a, 0x0,
    0xbfb0e832ad679a1d, 0x0,
    0xbfe03ae268dec1a3, 0x0,
    0xbfe65b5effe95be4, 0x0,
    0xbfe3b1925fcca40e, 0x0,
    0xbfaafc9020a85f95, 0x0,
    0x3fdaa0acfd950822, 0x0,
    0x3fe6fe09b6df69ec, 0x0,
    0x3fe0560bab802c41, 0x0,
    0x3f8fbf3dcb500773, 0x0,
    0xbfe2c7ed0f8c88f5, 0x0,
    0xbfe4f634afeee4d3, 0x0,
    0xbfdfbc2ffa6d48d3, 0x0,
    0x3fb9a55cefc96b67, 0x0,
    0x3fe04aaa52935871, 0x0,
    0x3fe63a1653815442, 0x0,
    0x3fe3fd71cf11b218, 0x0,
    0xbf82a9b913d39481, 0x0,
    0xbfdf231576f19fc3, 0x0,
    0xbfe7edd38e9fc606, 0x0,
    0xbfdc05516a133f1f, 0x0,
    0x3f9e7ea20292a87b, 0x0,
    0x3fe27a193b757d7a, 0x0,
    0x3fe500cff8691e7e, 0x0,
    0x3fdee91ca965d86c, 0x0,
    0x3fa4a24ae3386425, 0x0,
    0xbfe0d47274e88e7f, 0x0,
    0xbfe82dc596f23368, 0x0,
    0xbfda77e18f02d4a4, 0x0,
    0xbf89ad411960735b, 0x0,
    0x3fe14d971c6b26f2, 0x0,
    0x3fe5a406fb38aa44, 0x0,
    0x3fdb458c9bb7f69b, 0x0,
    0x3f82ef48dbc63bee, 0x0,
    0xbfdeb73809346314, 0x0,
    0xbfe54d0fe71e9962, 0x0,
    0xbfdef5dffb57e184, 0x0,
    0xbf828aafc472a84e, 0x0,
    0x3fdda32dfc81db68, 0x0,
    0x3fe4e183edef25b0, 0x0,
    0x3fdbf1786c7ddeb4, 0x0,
    0x3f9fd63b4d873a5f, 0x0,
    0xbfdd47790fbba73d, 0x0,
    0xbfe378e8d7ddc6e8, 0x0,
    0xbfdeea6232693096, 0x0,
    0x3fa2e1e34b8190a7, 0x0,
    0x3fe172c58596a440, 0x0,
    0x3fe300e03c00fa4b, 0x0,
    0x3fe104e9bebe3400, 0x0,
    0xbf81c346ba0db700, 0x0,
    0xbfde6e5fd95175e9, 0x0,
    0xbfe660af2ee768d8, 0x0,
    0xbfe09424f47932d4, 0x0,
    0xbf8a573582884a95, 0x0,
    0x3fdc943d243b4327, 0x0,
    0x3fe27e50adde9aa1, 0x0,
    0x3fe2606fb422ad1d, 0x0,
    0x3fadbc178e300afe, 0x0,
    0xbfdf902ad0d9eef9, 0x0,
    0xbfe69b9c130d6466, 0x0,
    0xbfdba6eae4380624, 0x0,
    0xbfa4312c5507dec8, 0x0,
    0x3fdb7ca1e7beb0a8, 0x0,
    0x3fe77f572d2b60b7, 0x0,
    0x3fdef0572a6fe67b, 0x0,
    0xbfaaa5ac8a317e53, 0x0,
    0xbfe37029f3437c08, 0x0,
    0xbfe758e7fdb32495, 0x0,
    0xbfdea46b6355d014, 0x0,
    0xbfa5efb3f773de0e, 0x0,
    0x3fe026dc89a617a8, 0x0,
    0x3fe7fa9245b14203, 0x0,
    0x3fdec6f1edfa23ab, 0x0,
    0xbf9732cb39a5fe36, 0x0,
    0xbfe29be918f05180, 0x0,
    0xbfe6107303849144, 0x0,
    0xbfe16cc08f8efbf1, 0x0,
    0x3fb7e7046453055a, 0x0,
    0x3fdc6f3c91663aed, 0x0,
    0x3fe6987e6f9ecde6, 0x0,
    0x3fdf922d6ef51e43, 0x0,
    0xbf8a5ed9aba226c2, 0x0,
    0xbfe0352e57b1f38f, 0x0,
    0xbfe6f74be0a30344, 0x0,
    0xbfdece9231ead128, 0x0,
    0xbf93d060dda113af, 0x0,
    0x3fe2b79d25ca49b5, 0x0,
    0x3fe4db48370cbd65, 0x0,
    0x3fde85b2c8459673, 0x0,
    0xbfb4b764e31ab1aa, 0x0,
    0xbfe0964998c58ef6, 0x0,
    0xbfe8e2f312d8bf55, 0x0,
    0xbfdd89e8b8ea5773, 0x0,
    0x3f909ec61e070890, 0x0,
    0x3fde83f1351ac04b, 0x0,
    0x3fe7144b80a36c50, 0x0,
    0x3fdfa1f2a67d0813, 0x0,
    0xbf6ee950a8a74e86, 0x0,
    0xbfe028875af3cfdc, 0x0,
    0xbfe6d2091fea540e, 0x0,
    0xbfdc1b6b113b6c12, 0x0,
    0x3faf3c89e37cb34c, 0x0,
    0x3fdf9538c4f25441, 0x0,
    0x3fe4f0a6a29317ef, 0x0,
    0x3fe04c75027353c8, 0x0,
    0x3fb1e55ac9ff58c2, 0x0,
    0xbfe091ff49d43efa, 0x0,
    0xbfe770d7eebcbc9f, 0x0,
    0xbfe1b9a19a08152b, 0x0,
    0x3f97219979ba04b9, 0x0,
    0x3fe01f2b360d6b8d, 0x0,
    0x3fe4450b8f24da78, 0x0,
    0x3fe089949343090f, 0x0,
    0xbfaa35cd28b8b1ac, 0x0,
    0xbfe24fb61e882f7a, 0x0,
    0xbfe429fd8a888ce8, 0x0,
    0xbfe0dbe36960e589, 0x0,
    0x3f9b49f6c6508260, 0x0,
    0x3fe149367f15ad75, 0x0,
    0x3fe6fe8879abccb5, 0x0,
    0x3fdebef9b3b71391, 0x0,
    0x3f8b27e785259775, 0x0,
    0xbfde0aab88229fd8, 0x0,
    0xbfe5eb8def13d0ec, 0x0,
    0xbfde6dfb5d0a0cc3, 0x0,
    0x3f7ffa4b5ed44e36, 0x0,
    0x3fdf450d9468c19a, 0x0,
    0x3fe96a83a8f1ec16, 0x0,
    0x3fe0379029088f94, 0x0,
    0x3fa11cc693b8f7f0, 0x0,
    0xbfdf5e75713fe7cc, 0x0,
    0xbfe59ae920d46294, 0x0,
    0xbfe37c51b08781f7, 0x0,
    0xbfa114f9fc3be48a, 0x0,
    0x3fdc6efede529299, 0x0,
    0x3fe9d0be18eb23ba, 0x0,
    0x3fe08120568e575f, 0x0,
    0xbf553bbe8d4e04df, 0x0,
    0xbfe1ff552e015ed1, 0x0,
    0xbfe86c37b5f3bc77, 0x0,
    0xbfe02c7942b12959, 0x0,
    0x3fa114b6d6b306e2, 0x0,
    0x3fdefe0bfe2326c4, 0x0,
    0x3fe6d9a72c6b052a, 0x0,
    0x3fdf1bdf20f6a6e9, 0x0,
    0x3f994efde99c48a9, 0x0,
    0xbfddd37be06fcf04, 0x0,
    0xbfe708ccb96518c6, 0x0,
    0xbfdca3c01ca20c32, 0x0,
    0x3fb4e81030e8bcf3, 0x0,
    0x3fe0158dffd2e137, 0x0,
    0x3fe798246bb082db, 0x0,
    0x3fdb549ce819011c, 0x0,
    0x3f6ac90da1dc5196, 0x0,
    0xbfd90682210d09e8, 0x0,
    0xbfe878ada0f4c243, 0x0,
    0xbfdf3075caa3d317, 0x0,
    0x3fa5cd8e95edef63, 0x0,
    0x3fe271c72c3e2336, 0x0,
    0x3fe7ebcbf20b30a6, 0x0,
    0x3fe1520fd37d7bd1, 0x0,
    0x3fb24c9007cad35d, 0x0,
    0xbfe13060c108b751, 0x0,
    0xbfe82aa38216c5a0, 0x0,
    0xbfdf67b9d50b37f5, 0x0,
    0xbf8229a00b37ca57, 0x0,
    0x3fe106d51a61e41b, 0x0,
    0x3fe453b4840af788, 0x0,
    0x3fdd1669c24c5294, 0x0,
    0x3fa53bf9b5df6c32, 0x0,
    0xbfe2ea8773e60e9e, 0x0,
    0xbfe511e034c32506, 0x0,
    0xbfe219672c43602d, 0x0,
    0x3f90db172798215a, 0x0,
    0x3fdf2a9a4f035141, 0x0,
    0x3fe60145d2411f79, 0x0,
    0x3fe1b5ef5397244d, 0x0,
    0x3f8b5295425c92f0, 0x0,
    0xbfdb9263c81d849e, 0x0,
    0xbfe6065dd57918b3, 0x0,
    0xbfe015e39634bf55, 0x0,
    0x3f54fb3e9ba96fdf, 0x0,
    0x3fddc7293876c0c5, 0x0,
    0x3fe50529e8c35fac, 0x0,
    0x3fe1740a8a6645f0, 0x0,
    0x3fac1fb3a89bd8b9, 0x0,
    0xbfe16a760867f81e, 0x0,
    0xbfe4cc2f6a0af382, 0x0,
    0xbfde37799014a438, 0x0,
    0xbfa5a1d95eb6c841, 0x0,
    0x3fdc7d20d501da86, 0x0,
    0x3fe72b158d438346, 0x0,
    0x3fe03f98ba8e1e68, 0x0,
    0xbfbec6f9b0c0eff4, 0x0,
    0xbfda892a88a15c35, 0x0,
    0xbfe4dd2f64bf77c7, 0x0,
    0xbfe0827a0323360b, 0x0,
    0xbf6d4521ffd96b33, 0x0,
    0x3fe166a8c67ed5be, 0x0,
    0x3fe6287f721ccc9e, 0x0,
    0x3fdbbce625bea471, 0x0,
    0x3faa59e78ca0092c, 0x0,
    0xbfdf4673326b95d4, 0x0,
    0xbfeac8b8192576a3, 0x0,
    0xbfdf22a06b48cdad, 0x0,
    0x3f9847a0cbf5e6a6, 0x0,
    0x3fdfebe863ca458f, 0x0,
    0x3fe4951c66593492, 0x0,
    0x3fdc0a405b46f641, 0x0,
    0xbfa22e16d501857d, 0x0,
    0xbfe1dbf88cb2ea53, 0x0,
    0xbfe6af86a9bb6697, 0x0,
    0xbfe058914d0bdba4, 0x0,
    0x3f6c3d806d124e26, 0x0,
    0x3fe0a8cafe9860d5, 0x0,
    0x3fe7fd599077ad0d, 0x0,
    0x3fe1849ba991dc95, 0x0,
    0x3fa86aa55dcd09f5, 0x0,
    0xbfddb5eafea65eec, 0x0,
    0xbfe4b3e6f50bb5af, 0x0,
    0xbfe020ac4a9eeabd, 0x0,
    0x3fbaabcbb1b35e2b, 0x0,
    0x3fdc358c98da628a, 0x0,
    0x3fe755c7373ab653, 0x0,
    0x3fe044eb86c00224, 0x0,
    0x3f98bd58de520144, 0x0,
    0xbfdb44d9a125c6d7, 0x0,
    0xbfe3c45dea206a04, 0x0,
    0xbfe29b92bac2ba32, 0x0,
    0x3fb11fdd9dd588ef, 0x0,
    0x3fdc2936ba46313a, 0x0,
    0x3fe76d9f9617cb89, 0x0,
    0x3fe0c550641af846, 0x0,
    0x3f95bb462ad91d2c, 0x0,
    0xbfdac5855266147d, 0x0,
    0xbfe5f7a48eb86d0e, 0x0,
    0xbfde10719cdd45f8, 0x0,
    0xbfa3a11117589a82, 0x0,
    0x3fe33f24c051373e, 0x0,
    0x3fe7c99412302749, 0x0,
    0x3fe1027c782129b5, 0x0,
    0xbf93e09d625d3e9c, 0x0,
    0xbfe1fd9bfaa5d15c, 0x0,
    0xbfe4528e5ea5bc5e, 0x0,
    0xbfe0a6f9b36acbc3, 0x0,
    0xbfac8a372cfe9843, 0x0,
    0x3fde88dd55e4ef07, 0x0,
    0x3fe65335d7eb5922, 0x0,
    0x3fde46b696027b11, 0x0,
    0xbfb121dc481e449c, 0x0,
    0xbfdfe42f556fe09c, 0x0,
    0xbfe75261181fb756, 0x0,
    0xbfdd65b1acaf2974, 0x0,
    0xbfa5eda229537dad, 0x0,
    0x3fe076b028219288, 0x0,
    0x3fe5ae55ddc7c881, 0x0,
    0x3fdd9eddc7761bd5, 0x0,
    0xbf81ff892c6326f3, 0x0,
    0xbfde7eed46768bc0, 0x0,
    0xbfe48193f3050898, 0x0,
    0xbfdf9d7ae9e55735, 0x0,
    0x3fa0644ef03e0443, 0x0,
    0x3fdcacc6ec62b722, 0x0,
    0x3fe62e0f9e7a75ab, 0x0,
    0x3fddf6e5b5a0e062, 0x0,
    0x3fa388e6ea9047e4, 0x0,
    0xbfd8f05d706ea583, 0x0,
    0xbfe6fc143c0f5968, 0x0,
    0xbfe1dfb8b4bd0721, 0x0,
    0xbfa4985794dfda0d, 0x0,
    0x3fdccc179e221201, 0x0,
    0x3fe74b9f8ce47042, 0x0,
    0x3fe01a227e9ef558, 0x0,
    0xbfb07594570c5957, 0x0,
    0xbfe243530e42a458, 0x0,
    0xbfe4f469e3e2f721, 0x0,
    0xbfdf2cf1c662a8e3, 0x0,
    0x3fa5db0e2b2e46f4, 0x0,
    0x3fe08509e8542562, 0x0,
    0x3fe90225230f4586, 0x0,
    0x3fe3336646c7701a, 0x0,
    0xbfb3955b73e7cf00, 0x0,
    0xbfdccc550ca93188, 0x0,
    0xbfe68f261a7680df, 0x0,
    0xbfdd7138717108fd, 0x0,
    0xbfaac51fe94aab80, 0x0,
    0x3fe2318159d0a66a, 0x0,
    0x3fe4ba3584e36660, 0x0,
    0x3fe39f4312159fb6, 0x0,
    0xbfa7c6ef6945676a, 0x0,
    0xbfdafc253b04dcfb, 0x0,
    0xbfe53b3b4842d8b1, 0x0,
    0xbfe18f1f1b475567, 0x0,
    0xbfa76fe8e5fdfb90, 0x0,
    0x3fdff6e192969e3a, 0x0,
    0x3fe4caa7f528ba1d, 0x0,
    0x3fdd30b9493b0bc4, 0x0,
    0xbfa1a9bf5182c163, 0x0,
    0xbfe034bf1df68087, 0x0,
    0xbfe5bc15a9d250a7, 0x0,
    0xbfdda7a5d0a1b11d, 0x0,
    0xbfb6b3d058c714f6, 0x0,
    0x3fd91d159755ce2c, 0x0,
    0x3fe5bbdcd9c89c31, 0x0,
    0x3fdfdfa50ddb9fdd, 0x0,
    0xbfaa72949d4d45a3, 0x0,
    0xbfde6280a8641506, 0x0,
    0xbfe5d523a87b66f9, 0x0,
    0xbfe2349137dd1217, 0x0,
    0x3fa2e8fa77a00787, 0x0,
    0x3fdcdd0a69ce09a6, 0x0,
    0x3fe53046d6ec1a5b, 0x0,
    0x3fdcd1f03f65014f, 0x0,
    0xbfa27c354fe57d5b, 0x0,
    0xbfdf318349c801b7, 0x0,
    0xbfe6200464d52632, 0x0,
    0xbfddd5ad2bebc8b6, 0x0,
    0xbf771211d1333bd5, 0x0,
    0x3fda75622b439538, 0x0,
    0x3fe789a5ecb0782b, 0x0,
    0x3fe33fa8a931492b, 0x0,
    0x3f893f3c38becbc8, 0x0,
    0xbfe0a07894734cc7, 0x0,
    0xbfe655d0492fa0ac, 0x0,
    0xbfe0f791c03c8476, 0x0,
    0xbf95aec1048817bf, 0x0,
    0x3fe0c58fa6640b07, 0x0,
    0x3fe706b48fec27c2, 0x0,
    0x3fdcccd32818ad71, 0x0,
    0x3f6df6d39c1c80f2, 0x0,
    0xbfdf17aa7017a92d, 0x0,
    0xbfe6495b8be62ad9, 0x0,
    0xbfdb70ac0555ae0c, 0x0,
    0xbfac183495bf9282, 0x0,
    0x3fdbcafc79870ca3, 0x0,
    0x3fe5719a5bcfd491, 0x0,
    0x3fd8f7c140270875, 0x0,
    0x3fa9881c13af6e5e, 0x0,
    0xbfe16d29cfef2ba0, 0x0,
    0xbfe617a44b53f185, 0x0,
    0xbfdfbf19e6347a97, 0x0,
    0xbf9779a9de7b96c6, 0x0,
    0x3fe07c0a16e7a977, 0x0,
    0x3fe7c5fc03fb3e43, 0x0,
    0x3fdc1a7505bfad2b, 0x0,
    0x3fa5bc0d5c461309, 0x0,
    0xbfddcfeb00f1af0f, 0x0,
    0xbfe281c3944e3eb3, 0x0,
    0xbfe19b2f19776ae5, 0x0,
    0x3fb9f308124e672f, 0x0,
    0x3fe298f5d0259f37, 0x0,
    0x3fe96e23a4007dda, 0x0,
    0x3fd80e3645d9f74a, 0x0,
    0xbfb05cb206783076, 0x0,
    0xbfe05ce5bc9f3c93, 0x0,
    0xbfe853d46d1a5b7b, 0x0,
    0xbfdf86a0ae6424a6, 0x0,
    0x3fb248a3b03c575d, 0x0,
    0x3fe0b2dc6817f6bd, 0x0,
    0x3fe536dde935eb39, 0x0,
    0x3fe1a3764e716319, 0x0,
    0x3fa8a22255c97edb, 0x0,
    0xbfe06ca82054c901, 0x0,
    0xbfe88e0053e4d1b2, 0x0,
    0xbfe1bff63c2c7650, 0x0,
    0x3fb88531d28cd1dd, 0x0,
    0x3fdd67f43be9673a, 0x0,
    0x3fe7c79bba961c45, 0x0,
    0x3fe048900558dbbc, 0x0,
    0x3f9ad31626938aa5, 0x0,
    0xbfdc925a85749128, 0x0,
    0xbfe75928c867ae30, 0x0,
    0xbfdf872d7fc3a5b4, 0x0,
    0x3fbb69851d1b9085, 0x0,
    0x3fdeeeee016861c2, 0x0,
    0x3fe3d1a09d1ae903, 0x0,
    0x3fdc4421b6ce9fb4, 0x0,
    0xbfaa4eabb1c7d3db, 0x0,
    0xbfdda1e7f6067bdf, 0x0,
    0xbfe54ac3b4f76fd4, 0x0,
    0xbfdc8d8ce0484710, 0x0,
    0xbf878b79221a78ee, 0x0,
    0x3fe06d28e350b916, 0x0,
    0x3fe7c9af34027d46, 0x0,
    0x3fdb037de8558191, 0x0,
    0xbfae01a4ffb78207, 0x0,
    0xbfe154775149d4c9, 0x0,
    0xbfe3dc43733d6fd4, 0x0,
    0xbfdf808d254a9a41, 0x0,
    0x3f8920cce131b06a, 0x0,
    0x3fe0458c3f986ff0, 0x0,
    0x3fe7a6cea7b220a4, 0x0,
    0x3fde4280102af49f, 0x0,
    0xbfab9ca122dd6921, 0x0,
    0xbfe15d716e34525f, 0x0,
    0xbfe67574b86c3c7e, 0x0,
    0xbfde25d5b3e20631, 0x0,
    0xbfb099a783ac645b, 0x0,
    0x3fe079398585f424, 0x0,
    0x3fe7fc757f3d19b4, 0x0,
    0x3fdaf6c9d4f951b2, 0x0,
    0xbfb794d19b320453, 0x0,
    0xbfe05a1408a24451, 0x0,
    0xbfe8a773b325ade4, 0x0,
    0xbfdd47f3f8418900, 0x0,
    0x3f723e859921a195, 0x0,
    0x3fdae2c2cb3484bf, 0x0,
    0x3fe6d36f819c9087, 0x0,
    0x3fdfc6247e0c71ed, 0x0,
    0xbf8d60230e7e436c, 0x0,
    0xbfde8b715c86bd22, 0x0,
    0xbfe89dc97fb94223, 0x0,
    0xbfdd8a33590ecb30, 0x0,
    0xbf876086b4e745de, 0x0,
    0x3fdf7b1edaa6c62b, 0x0,
    0x3fe4c71812a40158, 0x0,
    0x3fdfa29337e97c5f, 0x0,
    0x3f8bc5662cfa3f4e, 0x0,
    0xbfe0a195d2c47632, 0x0,
    0xbfe64f96934a894e, 0x0,
    0xbfdafb65dad7ee1c, 0x0,
    0xbf89a32ea7a43fa3, 0x0,
    0x3fe0cfd305a0919f, 0x0,
    0x3fe748db2d63c62e, 0x0,
    0x3fdf437f8bf3c08e, 0x0,
    0xbfb98feecb7ba59b, 0x0,
    0xbfe22626b77c0b08, 0x0,
    0xbfe68e89db1a8bf0, 0x0,
    0xbfdf5b2bc38d7722, 0x0,
    0xbfb6f365acddce8e, 0x0,
    0x3fdb84142005d870, 0x0,
    0x3fe5c900a2c93721, 0x0,
    0x3fe1742be6861a8e, 0x0,
    0xbfb1dbe4bbc99730, 0x0,
    0xbfdfe7fb0719b2db, 0x0,
    0xbfe530523895b0df, 0x0,
    0xbfe0675ca49b8f42, 0x0,
    0xbf9434d3fbafc764, 0x0,
    0x3fe02b254440ec81, 0x0,
    0x3fe5cf511a3857f3, 0x0,
    0x3fe04d96ad37ebc0, 0x0,
    0x3fb4ead04cd0f9b0, 0x0,
    0xbfddaf8db0be2f5d, 0x0,
    0xbfe721926aa0a003, 0x0,
    0xbfde09eabf973f25, 0x0,
    0x3f77505778569b83, 0x0,
    0x3fe25a57622ff53f, 0x0,
    0x3fe51a3b41a99556, 0x0,
    0x3fd9a254737af633, 0x0,
    0xbf80797ea204e0db, 0x0,
    0xbfe0042ba531e8db, 0x0,
    0xbfe534ec0e99b263, 0x0,
    0xbfe2f388dcf241ec, 0x0,
    0xbf93f565f8dab2f8, 0x0,
    0x3fe12abc670e6c6c, 0x0,
    0x3fe6b1c4851afb4e, 0x0,
    0x3fdd301542b20c08, 0x0,
    0x3f7a9e708f2ea092, 0x0,
    0xbfe1fa201844f513, 0x0,
    0xbfe7e5516c8dbc5f, 0x0,
    0xbfe05c393df45ea2, 0x0,
    0x3fb455150ec66061, 0x0,
    0x3fe26bc846d9760a, 0x0,
    0x3fe8d85a7afb412e, 0x0,
    0x3fddc8191e5a1fbe, 0x0,
    0xbfb3e334f1f2d007, 0x0,
    0xbfdea3991d128852, 0x0,
    0xbfe84a8b16d2225e, 0x0,
    0xbfdefe258afaf780, 0x0,
    0x3f6c5e42582d7e02, 0x0,
    0x3fdc03470cd66715, 0x0,
    0x3fe617f3c37be220, 0x0,
    0x3fddf8aba0c8f89c, 0x0,
    0x3faf14a047359510, 0x0,
    0xbfdfa8908a324b7c, 0x0,
    0xbfe82831ed5fa6e9, 0x0,
    0xbfde802ea2ea25dc, 0x0,
    0x3f764d410471fa45, 0x0,
    0x3fddc4c4f5a67807, 0x0,
    0x3fe702209aab741e, 0x0,
    0x3fdfd05a48f7fdec, 0x0,
    0x3f9716527ad834f7, 0x0,
    0xbfddb09b2f00bd16, 0x0,
    0xbfe639e4e2f54ed8, 0x0,
    0xbfe04a869ee92f8e, 0x0,
    0xbfb2cf07b9d45517, 0x0,
    0x3fd715959b16705e, 0x0,
    0x3fe62c2e6cc3b2ba, 0x0,
    0x3fe1d5e40a3d1ddb, 0x0,
    0xbfa1e998881d76ad, 0x0,
    0xbfe134b1bdad45e6, 0x0,
    0xbfe6ef82b0765a86, 0x0,
    0xbfdf59dde18fa151, 0x0,
    0x3f9fe73728125abe, 0x0,
    0x3fdb2ecb95ec8968, 0x0,
    0x3fe6dae6b5687d61, 0x0,
    0x3fdebaeaf5fc1304, 0x0,
    0x3f9ba024a13c22ce, 0x0,
    0xbfddfbbe2280d0f7, 0x0,
    0xbfe965caec19e586, 0x0,
    0xbfe318fb3af9fa18, 0x0,
    0xbfa8ac2fbfedcf38, 0x0,
    0x3fdd6ce9fee8cbe5, 0x0,
    0x3fe890d58b5fc58f, 0x0,
    0x3fdbb1af0440261e, 0x0,
    0x3f98ca3f38967f36, 0x0,
    0xbfdec183df699df9, 0x0,
    0xbfe47437d0de5b68, 0x0,
    0xbfdd520b90c8bd92, 0x0,
    0xbf8979298133bb19, 0x0,
    0x3fe13cc9ba125f84, 0x0,
    0x3fe64a2b26ae5b4a, 0x0,
    0x3fd6decc35e39be2, 0x0,
    0x3f7d9c593534758b, 0x0,
    0xbfe041f88a69308b, 0x0,
    0xbfe5e84e5c522166, 0x0,
    0xbfdec8246f5e3d77, 0x0,
    0xbf8207ce9c3a8714, 0x0,
    0x3fe25170eee34375, 0x0,
    0x3fe56b04b967fad4, 0x0,
    0x3fdd12245fb85ade, 0x0,
    0x3f705a89106e7161, 0x0,
    0xbfdd0df49169f63a, 0x0,
    0xbfe58879b10a2db1, 0x0,
    0xbfe04bfd6c61d5c2, 0x0,
    0xbfb11d4a0bf213bb, 0x0,
    0x3fdeee7c014d05fa, 0x0,
    0x3fe75231fcef82c6, 0x0,
    0x3fde094028eabfc3, 0x0,
    0xbfbe6e5e17ad174c, 0x0,
    0xbfdf2b995742e82c, 0x0,
    0xbfe728b3253313a6, 0x0,
    0xbfe1412d58cea92c, 0x0,
    0xbfa4b5df65ad9c3f, 0x0,
    0x3fdd25d00f25cf0d, 0x0,
    0x3fe78b4cc9f8507a, 0x0,
    0x3fe0c963047c527b, 0x0,
    0xbfb235d4abb88811, 0x0,
    0xbfe0543031609deb, 0x0,
    0xbfe46baf42ae22dc, 0x0,
    0xbfdb288a59da0b2d, 0x0,
    0x3f99d263f28cfb44, 0x0,
    0x3fe29623fe9b759f, 0x0,
    0x3fe7d5c0bbdee853, 0x0,
    0x3fdcf2341023062d, 0x0,
    0xbfa01e4bc9136615, 0x0,
    0xbfd7e0888ae3d51a, 0x0,
    0xbfe35276840af1d3, 0x0,
    0xbfe0fae61aac423d, 0x0,
    0x3f914d9d229f3db5, 0x0,
    0x3fde6e53e2a9956d, 0x0,
    0x3fe4aa08e52a82fa, 0x0,
    0x3fdce3d3a06b9326, 0x0,
    0xbf99a0bd453dcdc8, 0x0,
    0xbfe03ff2f741a327, 0x0,
    0xbfe70b877795297f, 0x0,
    0xbfe307dc4a955df4, 0x0
    };

static const uint64_t in_cifft_noisy_2048[4096] = {
    0xc01405d8ccbc9b1a, 0x0,
    0xbff57ed5eb3783f6, 0x40090b2d821d009a,
    0x3fe4103f98478e1f, 0xbfd7abb315a7b770,
    0xbfee33b9a7f286d8, 0xbfea261c54e2c14f,
    0xbfd349226edce82f, 0xbfd8e9ae13fdbe82,
    0x3ff86fa651c2d910, 0xbffbad39fb03d08e,
    0x4005a1c8e713fd92, 0xbfdec61c2bec465a,
    0xbfd14d0b0d057abc, 0xc0008cfd4c8fd3fa,
    0x3fd67c8a8f7c8e28, 0x3f8d858074a11a00,
    0xbffd034d7d5b7996, 0xc003c3adbccc07f0,
    0x3fe48800e9b984f8, 0x3fec6b2929b65164,
    0x3fda05babd70ec18, 0xbff108ae1613f0fd,
    0x3fdf515fa16afc35, 0x3ff64a6026888d6c,
    0x3fefe43c45df3943, 0x3fe0d91fc3e1bb82,
    0xbfea42828cd4d7e7, 0xbff646c5328beb98,
    0xbfeef5573c6f3866, 0x3fce7cb66877446e,
    0x3fb85284c70bf630, 0x400507651b34a2e8,
    0xbffa1b5191af528a, 0xbffeb8d9ed12754b,
    0xbfec090464d62ebd, 0xbff90742e5a79036,
    0x4008e5f3aecfeb46, 0x400462a8a84ce410,
    0x40044c60acefc075, 0xbfd62bdf66784128,
    0x400dc9fa6e22d7dc, 0xbfef2fab51736088,
    0xc00606a2cb3df32b, 0xbfc3828f88aa086c,
    0x3fe663ec70706c97, 0xbfea2839fef36f48,
    0xbfee1cdf8c96091b, 0x3ffc23cc6c66671a,
    0xbfcd27f5cef4e660, 0x3faf8c420e484b9c,
    0xbff962e0089fbc20, 0x3ffdf8a6d441face,
    0x3fcbaa64f6bc3f20, 0xbfe41d92a1f7f1c0,
    0xbff72ab08314a790, 0xbfdf79a404482ac4,
    0xbfd354a5eab974b4, 0x3fea6fc6a98166ce,
    0x3fd771b885061764, 0xbffd2466adfc5f52,
    0x3fc4c18fdc3bdf10, 0xbfe9ccf0d01f1412,
    0xbff7747e82f5f4ee, 0x4013a35a95fc7946,
    0x3fc7788fbffb3534, 0x3ffc324e33a9ebe1,
    0x3ff6eafeb45f7c96, 0x3feda87c81162267,
    0x3fddf140c00a6d82, 0xc008afe96c362010,
    0x3fe95d1bdcbeae4c, 0xbfc74189127a3842,
    0x3ff3844203255be1, 0xbfc5483cfebc5a4c,
    0x3fe580ec4b99f96e, 0x3fcbc234a8b1f528,
    0x3fd1203c25a7c95a, 0x3feb5f2204fa5bd2,
    0xbfe93ce099e735be, 0x3fedad15c2a9a370,
    0x3ff2ea5c3bf28b24, 0xbff48a73c0cca0d4,
    0xc00196d4449a425d, 0xc00acda988bf2628,
    0x3ff55be3d34d57bb, 0x4001328fa0bed226,
    0x40014125fb7b0da2, 0xbff504fcf72c3c24,
    0x3fe2f621f945b708, 0x400509cdd48a0ade,
    0x3ffc0cde4959b2ac, 0xc00e146cf8358024,
    0xc00a0d2a692b00f4, 0x3ffc8a3ef65bbf0c,
    0xc0002f7fa880b51d, 0xbffd073a33e909d2,
    0xc002bdf8c23cc363, 0x3fd8f8469ca7ab7e,
    0x4005e5d319a4bc27, 0x4004e20ce587161a,
    0x3fd541ff78b66894, 0xbfc421231d6157b0,
    0x3fcf17bbf08457b0, 0x400097a37ae990c7,
    0x3ff179cb36f720b2, 0xbfe635c6a03fbf0f,
    0xbfde9c53cf0fed7c, 0xbfe5a3698058137b,
    0xbffd37b5c3b59567, 0xbfc1a79448999900,
    0xbff3c6c35d620dae, 0x3fba1e6d5d61fe60,
    0x4000330aeee71c5e, 0x3ff6a719998e5490,
    0xbfffe0ca2c29ef34, 0xbfe1088b97033842,
    0xc0105ccf03c74704, 0x3fc651bd4f8e1bfc,
    0x3ff1942230cd6fa4, 0x3fe947b791c04e20,
    0x3ff9bac8034b3c14, 0x3fec2a74762d1e1c,
    0xbffd902b93f8b1ec, 0x400a2bc8e4e12bae,
    0xc01025f8557dac0a, 0x4000454103ef561b,
    0x3fe1aa98f3b335b2, 0x3ffb494d83badac4,
    0xbff45cca6cbf5fb7, 0x3fb399c42f64b370,
    0xbfdecfb559384fcc, 0xc0056ea79afabcf0,
    0x3fdfcea50cda3bee, 0xbfde01755502b856,
    0x3fd2b0dd3d8bf990, 0x3fdf57a4710fe3c0,
    0xbfe051789ec2f77a, 0xbfd7bba36ac3bbcd,
    0x4003a04aee7de2c2, 0x40001da1c8519cdb,
    0xbfe03fbadca97c3e, 0xc00a38d66ca7746e,
    0x3fdacdb45bae28aa, 0x3fbde32cdf4ba870,
    0xbfeb5a35b5927c45, 0x3ff2e9f546521a47,
    0xbff6d7b0224bdde2, 0xc002adbda8bd13aa,
    0xbffcd8b4d1d5a0d0, 0xc00b49581abad33a,
    0x3fe390a9fc52a2e7, 0x40090ce1e5646850,
    0x3fb3f6184498b010, 0x3fb3f3ff1407a4f8,
    0xbfea634de58abf74, 0x3fd9b548b8c4bb74,
    0xc0019d43561702fa, 0xbfead18d98ea0a18,
    0xbfea9b8715361e5c, 0xbfe7314fc52ea102,
    0x3fb83b2bf7fe5eb0, 0x3fde633e21158f95,
    0xbfe3334fc147417a, 0xc01347d68e7e79f6,
    0xc00ef8f277d25cec, 0xbffa33eaf6e95f40,
    0xc011a774fe7efda0, 0x3fed617f81832b00,
    0x400c5d3082208b6c, 0xbfd6d0ff0e8308ed,
    0xbfe5aebc6e24e7e6, 0x3ff68d7f1ff53254,
    0x3fce4e98e5dea3d2, 0xbff613c3cadaf5b0,
    0x3fefa152e86c6056, 0x3fedd0b5aa97f417,
    0x3ff0a1ea53bab26e, 0xbfeb6f6733926b8c,
    0xbff0fdf4f4afc4a0, 0x3fda89843d83793d,
    0x4002fa9fc9fbe392, 0x4008265b02e65e70,
    0xbfe04d15d4ea5daa, 0x40011e9466396083,
    0xbff9f5308e0728f8, 0xbfe6b73c7986d5bc,
    0x3ffb5f9b171c0746, 0xbff881731b72c19e,
    0x3fdc004aff3c44ae, 0xc00fe9a133a12ef4,
    0x3fdd8d39a7e440d6, 0xc000403a715c52d4,
    0xbfdb162e2d3d82bc, 0xc00b75f2c4cd4d81,
    0xbfe50264185a0863, 0x3fd02778f81509d8,
    0xbfda76b243d5544c, 0x3fe60a84f9c90676,
    0x3ff4bacb6f2dfd54, 0xbff2374945271d66,
    0xc00810ec9a799551, 0xc011e0a83f838b97,
    0xc0044fc1b3e0483d, 0xc010138617b9c570,
    0x3ffb26ad6750829e, 0x3fe13342a3e7b2cc,
    0x3fc5f4749f54df28, 0x3ff2e174265ecb1c,
    0xbfc9581bb3633dc7, 0xbfee9a60dc8c1701,
    0x3ff072a6b4c967e8, 0xc005a21bcb6ba7f3,
    0xbfff57503fd447bb, 0xbfc68d1adcafa82c,
    0x3ff7131220ae26c2, 0xbfbf192c7be2db40,
    0x40013924e8938341, 0x3fe5052afd74c1c0,
    0xbff1aaa9cb56e30b, 0x3fed3496658c4917,
    0xbff19a96618a0fd8, 0x3fcfcc9ca0255c00,
    0xbfec1bb85f0d1317, 0xbff3a01e2d77bc38,
    0xbfe8ad26edf41aa5, 0x3fd5658bc4609b9c,
    0x3fe77bfff5a5cf8a, 0xc000f207df0d133b,
    0xbff7545a44e26bac, 0xbfd5b944b225d458,
    0x3fd0e8e188b5878c, 0xbfbd599818e84926,
    0xbfb7075c09c7a870, 0xc009f07f8d3406f5,
    0xbff32f4ccd31095a, 0x3ff98db7de865fba,
    0xbff733467cc122da, 0xc0015fec12bdcecc,
    0x4005368eb1ef8664, 0x4006938e3d88aa46,
    0x3fd09c7597b5b122, 0xbfe077742ad1f8e8,
    0x400419536a4ae362, 0xbfa19927e7d4ac40,
    0x3fe3cb4da5052ae6, 0xc002ddf8bbda165e,
    0x3ff5aa35bbdae035, 0xc0097ae2dba0cbec,
    0xbfdb21b6d9cf78a2, 0x3fe139b525195aa6,
    0x3ff92b2cbbba8a0b, 0xbfe2d6949296dff4,
    0xbfee4d0911afdf62, 0xbfef9fba5186f674,
    0x3fb0df68cff93610, 0x3fe547cfbc64e892,
    0x3ffd91adfd596bf5, 0x3ff0e0ee4262da1b,
    0xbffe1f090bce66eb, 0x3fe4b2dcacf7643f,
    0x3fff1eb45cd9848c, 0xbfd6942e7e47c450,
    0x3f63a73eb345aa00, 0xbfeba91f994a614d,
    0x3fdf0cf209c00a8c, 0x3ff25f6129e7a2a4,
    0xbfe59a050170531a, 0xbfd8d24c4967e4ac,
    0x3ff45066803a9dbd, 0xbfd3b8af3b3c4c94,
    0x4002c8934acae5a9, 0x4003680d671efa66,
    0xbfeb67b7db6cd4c1, 0xbffd429a2aa808c4,
    0x3fe0e15ec09322a2, 0xc00b3f87dd5640d4,
    0xbfffc441a94ea139, 0x3ff32944c3dd7662,
    0xbff9608f40cb4d7f, 0xbff4b3cdaa63eb1a,
    0xbff32544d5d2f8c6, 0x400c08fa8a98b7f5,
    0xc0073a20628f50de, 0xbff7a1c6c948cf0c,
    0xbff866a7900c46d8, 0xc00a8891ca8b701a,
    0x3fd6a35574a1b7ec, 0x3fe779fa6a9da792,
    0xc004fbc6e749d30a, 0xbff0f43e722753d1,
    0xbfea1e00ef21e858, 0xbffbb58d00088c7a,
    0xbfef4b01e040b3ac, 0xbfa0f96a80a41410,
    0xbff02958918d3a6a, 0x3fe3c47a88482bea,
    0x3fee4434b64e0750, 0x3ff19589f5a9e038,
    0xbff7aa9873a74e3c, 0xc0075e1625ebad9d,
    0xbfd7b4d7e8d3b924, 0x3fba2ecbe7bf700c,
    0xbfd802a4ece0f84c, 0xbfe9a3876369090e,
    0xbfe59aa8aebc37c5, 0xbff20cc735a0ed0e,
    0x3fea559f124898c2, 0xc000eaa933e55627,
    0x3fe5e25b3318c977, 0x3ff0ae49b30fa288,
    0xc00496aa4b318e22, 0x3febbf13f9e52d2e,
    0x3fb8e0428cd23ddc, 0x3ff0e0cb9b6fdc2f,
    0xc0049cb1a3156208, 0x40000c4b495c4554,
    0xbfe1767fc2ac8d5d, 0x3fedecba104f2434,
    0x3ff831c31abac64f, 0x3fbf789c78e76990,
    0x400db3c5fbf388ed, 0xbfef872069636732,
    0x3fdb1204bab79b9a, 0xbf9dd5efb08330d0,
    0x3fcffc860dee568a, 0xbfe7637e8a80161b,
    0xbfbee93de0151aa0, 0xbffa6622417c71ba,
    0x4002cdf6dde75c91, 0x3fdd48adec68cfc8,
    0xc004beb993d728a9, 0x4011808f11ab8e44,
    0x3fed0e3b5e386014, 0xc00496faf7acbca2,
    0x3ff511cfa3d0bedc, 0x400d463837e1b8cc,
    0x3ff299898ff40dd7, 0x40022f7751443892,
    0x3ff0d612582ad86e, 0xbfe3b769ed7abb41,
    0xc006fb4c9a1c1314, 0xbfe036fa5c65e4ed,
    0x40014ddd68ffa4b6, 0x3fe511f7b35a59c4,
    0xbfe01be5e70d4b78, 0x3fe3ebb884f5ffad,
    0xbfc9734bce639a44, 0xbff1a2b71fb772b4,
    0x3ff9f73c3f9a992e, 0xbfe96a05941b362e,
    0x3fec598a9f1313db, 0x3fe7e97eac852a8a,
    0x3fee99404e98ad79, 0x3fce44c74a7cc704,
    0xbfed1b338bd53ddb, 0xbff04de2cf877274,
    0xbfbdabd762c9a658, 0xbfe07dad491fd8b2,
    0xbff597d0213794b0, 0xbfe291ab583585be,
    0x3fd9805c0d9d0aae, 0xbfdc4a10541a49fe,
    0xbfeb0492dd9964b5, 0xbff72f5e3e7a1d5e,
    0xbfe4e8368521081d, 0x3ff77b7c15cf4160,
    0xbff6e14040b45f0e, 0xc009fd166d1fd9ca,
    0xbfd95d229c69ca26, 0xbfda5edbd048f6ed,
    0x3fd04914e47bf728, 0x40024b92c7d704d5,
    0xbffce258cde3deb2, 0xc004613a57c98335,
    0xbfc03a4095ccb26c, 0x3ff121701af8f5b4,
    0xbfd100ee4b3ff240, 0xbffac54d7547fa2a,
    0xbff54f9bdf13247d, 0xbff483bcdae295ba,
    0xbfd360f5bd89ac34, 0xbffea730383a2b2d,
    0xbff7093122f3077c, 0x3fe7b16ac5ff2bd0,
    0xbffdf82b2c3aebdc, 0xbff4ca38a76064be,
    0x3f826ee76dfe5920, 0xbfb856f3feb3ad7c,
    0x4000cead697c6569, 0xbff79e4ef4bd012b,
    0xbfef4ccb10b8262a, 0x3ffb3b2b04febb92,
    0x3fff2de41bf864ac, 0xc001ec35341be59a,
    0x40035e03efe4ce4e, 0x40079a486f558322,
    0x3fda2be673db6b3e, 0x3ff74dc0e668a772,
    0x3feb60b8f2a4d0df, 0x40030c45c4bcac48,
    0xbffbd9bd032d41b8, 0x3ff90ab061e01462,
    0xc003d89a5006a5f2, 0x3fe162909e642d8e,
    0xc00b52b934c697e9, 0x3fb252f63e397128,
    0x400444b1f395d39d, 0xbffc59d73f61cb2c,
    0x3fe98e4c6a320dbd, 0xbfeab6533cd12474,
    0x400208c76072a55a, 0x3ffd8be1c4ce78a0,
    0xbfd5f38b454be2a4, 0xbffea65f158ba861,
    0xbfcfdeb6c152f40c, 0x3fe9d456cce11d52,
    0xbfa465072c03d080, 0x3fe5f0bb44b3a8a6,
    0x3ffd570df0f831e4, 0x3fec457cd79b4057,
    0xc0026af7a30c0802, 0xbfdaab594c5be3c8,
    0x400428bac1a5e548, 0x3fffabedcde96cc3,
    0xc004e473f3ebce40, 0xbff17875e95dd058,
    0x4001d1dace816016, 0xc0052220ec90c112,
    0x3fea9ab8b8e4be3d, 0xbfcb2127411ada72,
    0x3fe370ea43073a24, 0x3fd78b15810258cb,
    0x3fe7c279bc71e444, 0x3ff7b7f1cc5932d6,
    0xbfecb031c42755d2, 0xbfa38c29bb373ab8,
    0x3ff60b2a8d362b72, 0x3fe93e27c4f617f5,
    0x3ff0747bdac1c49c, 0x3ff56a5dd608dcc6,
    0x3fd366e0e9322d8a, 0xbfd89ba21cfc7762,
    0xbffa636a2f503904, 0xbfcebaa25a8e6f48,
    0xbfe722da2d614ae6, 0x4004a0d956ed2d68,
    0xc00336081c148b45, 0x3ff31a0f1107a885,
    0xbffa6fa6af9d3673, 0xbff68fffde5cc63d,
    0x3febce138bd97496, 0xbfff25c99cee7719,
    0xbff01b4d4b88a35b, 0x3fd75c4f633aadbc,
    0xbffce98795748810, 0xbff82dbb991bdb4d,
    0xc000b36e51a609d5, 0x3ff543c541d50452,
    0xbff0831a5a718772, 0x3ff3a774eea6a5ac,
    0x3fd17d3cfb9476c6, 0x40053dec56bf0f94,
    0x3ff459ede4cb8336, 0xbfd54186141f1ee4,
    0x3fe521386d455866, 0xbff1551e66d70e5d,
    0x3ffae7639295b34a, 0x3ff6efc874fc2613,
    0x4000453d29ca98c6, 0xbff90903ad98b73e,
    0x3ffc4e9c27e8151b, 0xbfe5b5ea1c17e384,
    0x3ff20146c873c1f6, 0xbff5d5c84db04669,
    0x3fed9c113338406d, 0x3f900d2d78b07420,
    0x3ff2e6a5ba650194, 0xbff170332e37c106,
    0xbfe27bc568fc3d7c, 0xbfb0677f592337d0,
    0xbfb9ca58790b7484, 0x3fdd4980b8c8481a,
    0x3fd4618f07b31139, 0xc00892136f2d6f26,
    0x40040176b560b0cf, 0xbfed8314d7f1cf44,
    0xbfd03c9de1801ee8, 0x3fe207199d0e2b84,
    0xbff2424f80073adc, 0x3ff764e284ab4322,
    0xbfd6f7a6d86244e6, 0x3ff127e6e241e154,
    0x3ffa871140f356bb, 0x3ffb9faa02887ecb,
    0x3fc75c50169e8904, 0x400f803188217e46,
    0x3fb2e8dd85355950, 0x400670e98ac571f5,
    0xbfe553d649101984, 0xc0021eb4f21073f6,
    0xbfe0a32f61d05676, 0xbff743f92e107840,
    0x3ffa7f9df13254e4, 0xbff0b9597cb4b389,
    0x3fe089dc8711dc58, 0xc0015f40a768db3c,
    0x3fd11714176cf298, 0xc006fc8ef2ced11d,
    0xc0091de01dfa33a6, 0x3ff7bb306b81f158,
    0x3fe2f34dd8ad3eef, 0xc0866a81da3e8fc8,
    0xbfda0f7f211449ce, 0x3ff2b6160db079e8,
    0xbfed7eaefec038c2, 0x400fd04f56247ac0,
    0xbfb7b8740b83144c, 0x3fff8c37509bde60,
    0x4004395e53cdfd1a, 0x3ffb29f43e2c6cb6,
    0x3fec983ba7d7aaae, 0xbfb7b987dfd98abc,
    0x3ff5500aa013e5ae, 0x3ffd15382d0fc6ce,
    0xbff26da928d552f1, 0xc01525b7fa15ee1c,
    0xbff992d392bc9246, 0x4002c637cb9d43ee,
    0xbff82bb6f5a6d08b, 0xbfe39ceb62749a26,
    0x3ff00ab019a64a16, 0xbfd2b20471b40581,
    0x3ff77a94900b82e7, 0xbfe5ffc1c28e64d6,
    0xbff7b5e93c060206, 0x3ffb9ce70f9d8cf4,
    0x400b04a1a2a9bf21, 0x40046fb931796cea,
    0xbfc27a54ce857fe8, 0xbff9d39f8fa08c6c,
    0x3fb2628bee1ff410, 0x3f8fef05abef7f40,
    0xbfe5d2e840137cbf, 0x3ff3f2363813d66a,
    0xc0086015553e5305, 0xbfd75e7638aefbc6,
    0xbfe8507df5fda8f5, 0x3ff6f6e5ba7b8f7e,
    0x3feec1435d1ccedf, 0x3feb058686e255dc,
    0xbfeebaedc23175e6, 0xbfd16edc2d825eb8,
    0x3fe279db8ae62a0c, 0x3fdf45b61d732f84,
    0x3fe94746953c285e, 0xbfc799ba90366b2e,
    0x3fe0616d3ae2abe1, 0x400544a3682959b6,
    0x3fd167a7834a1e02, 0x3ffa527a6ceaa982,
    0xbfd3488ca25ca280, 0xbfad305fdad367a0,
    0x3febae3625fe051b, 0x3ffdb7ef3c4d9c1f,
    0x3fd5f902f57bd730, 0x3fd661f548d00690,
    0x3fdc25727e75beee, 0x4009fe3c70745887,
    0xbfda3e3e84f9d098, 0xbffbacc0adf0da28,
    0xbfd0d0582127f8ea, 0xbffed3643db20d86,
    0x3ff9877c2e83833c, 0x3fb562a1cec25bec,
    0xbfe068308d187b19, 0x4009abea22ae26c5,
    0xc001d0ef1a5db66f, 0xc00090ebd7b1122e,
    0xbfd7e16ad53a4a5d, 0xbfebf3fcbc71ffc9,
    0xbfdfad715674f719, 0x3fef3acfd47659ce,
    0x3ffac2793dc27001, 0x3ff13b3c8f76425b,
    0xbffff3fe04f0193c, 0xbfdee72f3bc989b6,
    0x3fe9c368274b5af1, 0xc00089b67358a2b8,
    0x3fe9c4f2a8184a30, 0xbff2cbff34faf972,
    0x3fffe1e2f222cefc, 0x3ff314d7186baf20,
    0xbfd19d7fb36d4390, 0xbffd59ee6c5682dd,
    0x3f9b06007eb3c080, 0xbfeae5b5ab5c24a6,
    0x4001ec800ee668b3, 0x3ff207cb3fee4748,
    0x3fe093caacc08685, 0xbfe80fd779fcc582,
    0xbfd6b06c286037c0, 0xc00e24403b10f644,
    0x3ffbbbf7aa4bac4e, 0x4003a6a3f92adcaf,
    0x40064d56197722e4, 0x3fd573b677681a6e,
    0xbff9bedbb9c1d0e0, 0x3fede30030a6c6c8,
    0xbfe9f9aa2de8b434, 0x40000c2881f83cf6,
    0xbff1a1e28740ecce, 0xbfcbd0c5655db7ba,
    0xbff3d811fcb04a48, 0x3ff36c340fbeba63,
    0x3ff7d561c27d7328, 0xbfd7545721606bd4,
    0xbfd88afcffb26160, 0x3feca29c546e10e4,
    0x3fe7080a30cb6b6c, 0x3fe15507a1f9171a,
    0x4000283afcf53f9e, 0x3fec4d80eb673e1d,
    0xc000914e81b11df2, 0xbfeb0d9ddec666c0,
    0xc00aa94cb0f4696c, 0xbfa69c1a8b0671d0,
    0xbfd21fd5b87e71ea, 0xc0013e10380048ee,
    0xbff1b11211b09061, 0xc0045ad9e2ca7969,
    0xbfe4b8af995ab792, 0x3fcd4e76fad8f4d8,
    0xbffd7cd63b4c2004, 0x4003860d86ff6f7c,
    0x3ff1b80fefdd4e4a, 0xc00257e27bba8e16,
    0xc0025655c7a1e358, 0xbfe1b617bd5377e5,
    0xbff083c0b355f9a3, 0xbfbfc9ea57013ba0,
    0x3fea185e08dd3455, 0xc00545ad137c22c8,
    0xbfee2ed8011ef508, 0x3fe00a5b8673ce38,
    0x3fe8816167d5a9a2, 0x3fc9481014acada0,
    0xc000bb1cdeaa796d, 0xbff803322c43b0b4,
    0x3fcf6a646be35c50, 0xbffbd9991886b1f7,
    0xbffeab04feb2df53, 0x3ffc9d6a721b343a,
    0xbffb08e705ceef9e, 0xbfcf10c2700ee962,
    0x3fdfecda51f42e6e, 0xc001fd1038c05054,
    0xbffdf43e4f983648, 0xbffbe129c6a87193,
    0xbff28911550ce196, 0x3fe89dc38c2c56e5,
    0xbffea09149c4f030, 0x3fb5c58b75a9c988,
    0xbff7b0774032aede, 0x3ff0434386456e9a,
    0xbff6656846d7c132, 0x3fe60540ca584b36,
    0xbffac5bfa88f1422, 0xbff906d94b24bec0,
    0x3ff892668545914f, 0xbfd09f92a28f14c8,
    0x3fef4ad0e7d6488a, 0x3ffce885a23d86a1,
    0x4002fb75f9ae62a8, 0x3ffd52f3e27f8105,
    0x3fe0ae054466d262, 0xbffb0443c8986e24,
    0xbff3dfeed4433391, 0xc008361f215e0ab0,
    0x3fd7ff81cbc4c0bc, 0x3ff1c6395527ae3e,
    0x3feb767957afd5e7, 0xbfe4e93a08c9e421,
    0xc005de0197d9264c, 0xbff9eb2d181345ac,
    0xbfcccd5645de57c0, 0xc00558dc51c08a54,
    0x40073e8fcc889040, 0xc003d9ba1e6608bc,
    0xbfd3274a2f72f278, 0xbffb238ce5937ffa,
    0xbfc0c6a47836e3c8, 0x3fe3b4372357f3d6,
    0x3ff9e060a77b3009, 0x3ff83ef32b04b9c9,
    0xbffed7159ba8912c, 0xbfe1f4ab5254c809,
    0x3fd5417bd390ef08, 0x3ff1878b7333516a,
    0xbfc0ade45f6d59c4, 0x3fe7338a1f1b653a,
    0x3fec63c9669f0f9c, 0x3fe5110b9b9caef5,
    0xc00e2378d764c266, 0x3ff2b1a9661d0580,
    0x3ff97972d9b5f654, 0xbfd34ddf2cd742c6,
    0x3ffd88557e43525d, 0xbfd0e8f193c29b7a,
    0xbfe7b0d365ac2a98, 0xbfe8c1ffabafd1fe,
    0xbffe61460f9cacd0, 0xc00001e14e075c6a,
    0xbfc53cd3f65a47d8, 0x4008eac6ba095786,
    0x3ff73b3ed5a81b1a, 0xbff2c72a4726e53f,
    0xbfece043295f964f, 0x3feec7abdf4ca9de,
    0xbff0f430e9fce5d2, 0xc0036821de413026,
    0x3fb1ca5384141c10, 0x3fee96f8a8e24051,
    0xbfc597029645bc02, 0xbff5415682c73ef2,
    0xbff65e02fab69706, 0x3fc97c83d27efc58,
    0x4005100cced39674, 0xc000929aed146cf9,
    0x4007bf56668f7b0a, 0xbfebce2514e84596,
    0xbfe4077ae1cb4ab9, 0xbfeb05fd596e1b20,
    0xbff7aa74fbb0eab4, 0x3ffd11d8807f057a,
    0x3fffe4acb0cc00a4, 0x3ff87502321fe77e,
    0xc00e6817d0c5af70, 0x3fe85ab0df210229,
    0x3fd2e850f0a08396, 0x3ff27bdcf2fdb239,
    0xbf81074a90229480, 0xc0013cac9b9aef95,
    0x3fca480d5ff7f0d4, 0x3ffa402a7c520538,
    0x3fe8e2a8543d5390, 0x3fdb38bd775bd4e9,
    0x4002991bf9eeff7a, 0x3ff403b3bcd31322,
    0xbfeb2f468fa90470, 0xbfd1acd602705290,
    0x3fece9ed0bec0db4, 0xbfd878736351edb2,
    0xbfe95b0b81b9afdb, 0xc006a279323d5f20,
    0xc004975ca662209a, 0xbff02df2e8571c89,
    0x3ff355e86e4539bb, 0x3ff5aa45e3d8cc2a,
    0x3fe04d580b423076, 0x3fec698cea6dfe5b,
    0x400bd50f729e53b5, 0xbfd7f7c3a6d22eb0,
    0xc0004c2a86e99ce9, 0x3fd928190f167a2a,
    0x3ff2d4a8ee54ae54, 0x3ffaf7003b030a72,
    0x4007b37542b3f34a, 0xbfbcd19e45923540,
    0x3ffacad36ff6fcf6, 0xbffd36db5c6feb17,
    0x4001044b33c5a63c, 0xbfdb15a8b3bc515e,
    0x3fea6a46b6a3ce44, 0x3fda8ab325d3de2a,
    0x3ff80f86f91dd7ea, 0xbff02c97215edcc8,
    0x40105d063d16ba5b, 0x3ff0a4be08fb037a,
    0xbfeaf71877737e24, 0xc0003558a4cb8af7,
    0x3feb84b4e76e3dc0, 0x4002e2d1d5fd278e,
    0x3fef878c1e341d5e, 0xbfdbfec797e61fa8,
    0xc00084360cdf0509, 0x3fafb69dca4d79c0,
    0xc00c5eb65e8ebfa0, 0xbfe3ee3fe376e95a,
    0xbff66c199c3b7cb8, 0x3fe363f4d545c800,
    0x3fe74beddb611e44, 0x3fde54e869898895,
    0xbfe6e19d8fbc4b97, 0xbff5a7fc379df15a,
    0x3ff66be9988e922c, 0x3fe7b94e9b8ebd88,
    0x3ff53daa58d37ad7, 0xbff954425b740cd0,
    0xbffb936003434730, 0x3ff40df009904517,
    0x3fead39c29e953f0, 0xbfeddb4debb5b2c8,
    0x3fd4334f91ce8555, 0xbfe8c24d1ad44bc8,
    0x3fdc22520720d76d, 0xbffea91ee96133fa,
    0xc010763370ad3f49, 0xbffcea7b6f8f39c3,
    0x3fe781cd630e05f1, 0x3fe177cac6fd0bf0,
    0x3fc050e3f1b86cd8, 0xbfdda5fcc1292634,
    0x40034742650cfb00, 0xbff164d74a0e27c8,
    0x4005bd382400da65, 0xbfc95055cf47b508,
    0xbfe3f74ac4931a14, 0x3fec4d6fb55a23e8,
    0x3fe5cc7c56586e02, 0x3fa2797dbf752c3c,
    0xbff46fd1435f7362, 0x3ffbe1a273ed00b3,
    0x40049466ba5af7a1, 0xbff9a7a8a0c29ae8,
    0x3ffd18119dd70566, 0xbff004759c52dfea,
    0x40005d6822bfa658, 0x3ff67c698b000034,
    0xbfe25b6dd1492a03, 0x3feedef18c60d4a2,
    0xbf7e879a70ef5f00, 0xbfc6251e638ee5e7,
    0x3ff54f6effd3daf6, 0x3febbee0d3eb63de,
    0x3fc3d85168396578, 0x400acfabf7c9ee2a,
    0x4001954b287d5048, 0xbffae2044478dd9e,
    0xbffb53c107d2cb1e, 0x3fc46e7c9dc369e0,
    0x3fd13f86e2335fa4, 0xbff6ea6f84b7075e,
    0x3fe1ca541b563194, 0xbff1f8552e1a4827,
    0xc003682ec95ab80b, 0x3ff5faed902aa31a,
    0x3ff6eb6fa18fa032, 0x3ff034fbd79aa1ae,
    0x3fb2e79f8b416470, 0x3fc639b56081fcb8,
    0xbfe795a45cd5c863, 0xbff0cb255100cf5d,
    0x3ff4ac400f891582, 0x3feda80adf9a6b6e,
    0xc001b508471c8e1c, 0x3fe4211d0aaaf5da,
    0xbfebefbcb27edef4, 0x3ff060e0589ece57,
    0x3fe4b8ff69709d1f, 0x3fe07d8e36b08b2c,
    0xc00ab3913fdf25bf, 0xbffbbd0ea619fa3f,
    0xbfe26bf9a51014c8, 0x3ffc827dff0f98f3,
    0xc00bac26f9b09371, 0x3feb106b10b4844e,
    0xbff01c6452b4ab4a, 0xbff2c69c0d0dc6c9,
    0xbf9947c909219460, 0xbff1d970b74841a6,
    0x3fe153eba0037a83, 0xc00018babeaf3b98,
    0x3fffdc80b060d2a8, 0xbfe711637343f652,
    0xbff731d7d4ebf529, 0xc008174d3cd1c62e,
    0xbfe30fbf9492e458, 0x3ff722842be93790,
    0xc0092479a5bf508a, 0x3ff235b2a01de254,
    0xbfc9f59253eb64e0, 0x400530b6cf468c3e,
    0x3fe2ddf8e2d11dfc, 0xbfdc0fb22f292564,
    0x400d8aacacf44f52, 0x3ff49bd3e5084069,
    0x40031bea8a3769c4, 0xc003703b46fdb21a,
    0xbfe702054419d1c9, 0x4006b70103b5f100,
    0xc000d3bba2c39d79, 0x3fbef712eb004ff0,
    0x400969a92feb8db1, 0x3ffe3bb6b4097dbc,
    0x3fef0de5f24b97d2, 0xbfa631e6febe28a0,
    0xc00233b80b51939a, 0xbff7233ce1b218cc,
    0x3f843e90e74a7680, 0x4000494b01a5adaf,
    0xbffb6acfbd93a97e, 0xbfef0f21b87c9424,
    0x3fff8c1f943083cc, 0xbfbd36e8cfeec440,
    0xc0040ecfa6b87e04, 0xbff21d50902a1892,
    0xbffc860a235b1447, 0xc0023a7fd220d4aa,
    0xbfe4783740ea950e, 0x3fd827c076a26f85,
    0x3ffeba1dc5dfc4ea, 0xbfd566a47c584ae1,
    0x400331c174cc8b65, 0xbff993ca250fa39a,
    0x4009b3c12f5b99aa, 0xbf9100b0fbc09100,
    0xbfbba431bd627ca0, 0x3fdc6febae30de13,
    0xbff0aaeac2b628ce, 0x3ff20b2689455107,
    0xbff04f5c2f632572, 0xbffb470e640635b2,
    0x3fda61980ae7f8c8, 0x3fdddcc96a676246,
    0xc001ea20d43ad4a6, 0xbfe28a2b61bfdd40,
    0xc008a9f8bf846f2a, 0x3ff1cf4bfb33e514,
    0x3ff1b67018624797, 0xbffda25c8c063354,
    0x3fdb3e557d0e01f7, 0xbfec84090a81f610,
    0xbfc3f72bad7dd9d8, 0xbfe90b3d2a61b51e,
    0xbfea78f2f7c71e79, 0xbfd65ddac46b9684,
    0x3fdc43ae2111da44, 0x3ff0a1c53800d714,
    0x4002a27c133710ee, 0xbff80ebd3e6b52fb,
    0x4002b67562d76356, 0xbfe2a628fa91aabd,
    0xbfd0d0013abd416c, 0xbfd4768545a1d180,
    0xbfda5b9c25662dfa, 0xbff4f4cdda60bb16,
    0xbfdace3656563664, 0x3fcc346c039433bd,
    0x3ff113b3b47a9df0, 0xbfd4f0e2217ef3b4,
    0x3fe6fe6a87717815, 0xc002a78954d70130,
    0x4005d9ecae2b7594, 0xc00350db0db29791,
    0x3fc6b2be474b4e40, 0x400a526cce3d4dd8,
    0xbff15c68e26f4a2a, 0xbff21d3aaccb5622,
    0x3fee47663c8c7578, 0xbfc1863b2ef4ec0c,
    0x3ff4997069df1432, 0x3ff359dd48ac5c2c,
    0x3ff53dd480f2b8b7, 0x3ff79387025c3453,
    0xbfdba865806f7e36, 0x4003ff2d461de6ef,
    0x3fd1c3b6a2a5574c, 0xbfefea48fb1ef773,
    0xbff6ff29db720afa, 0x4007e10b5984df60,
    0x3ff44102d6f5e242, 0x3fecb07db6973c8e,
    0xbff5903b26ed9028, 0x3ffe68f61299feee,
    0xbfd3b2454dda9fe0, 0xc00418253b572dbc,
    0xbff35b60c6f128a0, 0xbfee65f4205c3b86,
    0xbff8629753565cdc, 0x400dba1fcd91b0d8,
    0x40027a8cdf36e024, 0xc00a665067e2d08a,
    0xbfb050c5aeb315a0, 0xbfe5dfe408795058,
    0xbfd3eff49d56aee0, 0xbff2cb1b50da5418,
    0xc006c71a415607c2, 0x3ffe9dcf8bbf078c,
    0x4003456e603e67a6, 0x4004ea6b08c3393c,
    0x3f908653202e44e0, 0x40103fd68be2329d,
    0x3fb83b1f9461c560, 0xbfd20c716b1ea214,
    0xbff76e5ac9f566d8, 0xbfa6660dd800c2e0,
    0x3febce9b4a9ee230, 0xbff87f7f8e8b987a,
    0xc00f300446165fa8, 0xc0018bb5fff5d0bc,
    0xbff1e2efdcea9b90, 0xbfd36edc6403d280,
    0x3febb4c0939e4d4f, 0x3ff2a51e6ad0becb,
    0xbfb7c0ca4b1df6f8, 0x4006b9e4b9cd78a2,
    0x3ffd9289d530982a, 0xbff9820801e21b44,
    0xbffbb1455a5f200e, 0xbfc80a7e44175620,
    0xbfe5ec7daa6a2c7c, 0xc002ca2408ca6f09,
    0x3ff40a5f1b41559c, 0xc0036aa7bb25b502,
    0xbfe5c87d477a8188, 0xbfe8e9a447aaebf9,
    0xbfed1ccc1e269f6e, 0x3ffa37605cca6962,
    0xc00c0fe36bcf4519, 0xbff00e917f0518f5,
    0xbfecd2996ff7dbbf, 0x3fe930e3180e2e58,
    0x3fe5932b351a25af, 0x3ff29116872b1140,
    0xbfe29901aa5031d2, 0xc0080bb9567676b6,
    0x3fdcb7d9128a3594, 0xbfeaeb5075715520,
    0xbfec9b5f10868842, 0xc0010480a46eb19b,
    0x4009b42abe7100f6, 0xbfeea3f84ab2e030,
    0xbfeb7c00e5019200, 0xbfeb755c51779e5e,
    0xbff68c7867971724, 0xbfcec12c25ee65e0,
    0x3fc1c08be6afadcc, 0xbff9220dcc88b1be,
    0xbfe14e55b0de2502, 0xbfd4e2efb6f8c61c,
    0x3f61be77e420fe00, 0xbfd95ffaed6a3b78,
    0x3fe74199a65ba5c4, 0xc01099b9a3103bcf,
    0x3fbc4a1862ab9e10, 0xbfe1a070799f9143,
    0x3fd664f12ae4c260, 0x3ff00498c893ec9d,
    0xbfb78d7ca3c893e8, 0xbffad696cc05a762,
    0xbfffc9fce2e347c8, 0x3ff371e91aee53fa,
    0xbff22b9e8d5d2b49, 0xbff7892e60962eb4,
    0x3fba47848004df8c, 0x3fe1499416ff8d3a,
    0x3fba475918e9e9e0, 0xbfeb705b5e083924,
    0xbfe00fc3553f9ce0, 0x3fe6979c87b4e3c9,
    0x400547d59adaa629, 0xc012b189ed1d5815,
    0x3fe7339d081b9e74, 0xc0027c7f0590ddb4,
    0x3ffd51afe5fa8d2a, 0xbffb8d9db76947de,
    0x3fe209c3bcbfcf18, 0xbfff9b1f50c2581a,
    0xbfeae02ee898726a, 0xbfd21580eaa6e6ce,
    0x400a97672e2eb0ad, 0x3fd874eeb2ad5ae0,
    0xc0042af62f14e018, 0x3ff80b9c53c3c572,
    0x40036ea92dec4d5c, 0xbff244fc3abdbd61,
    0x3fe098b78628efea, 0x3fe672fcad42cc6e,
    0xc0090e765457fc64, 0xbfe4cad989e72856,
    0xbfee211693d3da0b, 0x3ffafb56aa85b42a,
    0x3fe3f725b1c380f4, 0xbfe5c3fa8174e281,
    0x4002c0e93203705b, 0x3ffd84b0b4eebbb2,
    0xbfe3ef0327d0c14b, 0xbff2a2f28b7e5414,
    0x3fbc563a2a2c6ec8, 0x4004c4a417737c68,
    0xc0037494b9f10e18, 0xbfd0469de6803330,
    0xbfeac0b8ae3ac2fe, 0x3ff0fa0ec7d32850,
    0x3fffbf4609e2d3e1, 0xbfeaf884a837954f,
    0x3f946546f45092a0, 0x3fdf0a4df98cb450,
    0xbff876e69e547297, 0xbfe188e50b54af60,
    0xbffff3b1d6c396a9, 0xc0107ca9c104636e,
    0x3ffd005fc5bbafaa, 0xc008deea67c76488,
    0x4015f1015c246e87, 0xc00037984a59c443,
    0xbf92c33092f8af40, 0xbff2f6af750a5683,
    0x3ff760b41592c85a, 0xbffd4e14991df010,
    0x3fd66eee7e0f4746, 0x400a65aee0b7aa6c,
    0x3ff5720334bf8b44, 0xbfe18c4ec4a6b96b,
    0xbfe2de1bf104b680, 0x3fdc5f2d0b6fbd04,
    0xbff158f99f477eac, 0xbfe86048c22d12eb,
    0x400689bef155f654, 0x3fddd3406f9a2790,
    0xbfcc9c98e10cf378, 0xbff308ad86b5b8a0,
    0x3fe230f5cda14986, 0xbffb5da6ac7bb3d4,
    0xbfda9e95d0a90a10, 0x3fd5365e65435170,
    0x3fef4f08b7cc814c, 0xc00ac04901042c34,
    0x400140ae14ae8755, 0xbfd7966ec021d6f7,
    0x3fd81dc1ac8e2210, 0x3fddcaef46ff1e38,
    0xbfe109e82fb813fa, 0xbfba87a2172147c8,
    0xbfa37285e1aa7850, 0x3fefcb5180be55c6,
    0x40093a5d07a02248, 0xbfe5e8e7533489af,
    0xbfd2f562b6394be8, 0x3ff087dd16594018,
    0x3ff3db27e6a7ed51, 0x40045bf87c333cab,
    0x3feaf4635016a2c0, 0xbff6541953ddbec3,
    0x3ff4f1b1c9ff0e57, 0xbfcc5ccd314dc298,
    0x3fb4516d3ee0e3f0, 0xc0022e1ad928bc1a,
    0xc00419cc4091c842, 0xbfb78661638e0488,
    0x40013769e9056832, 0xc00575d5f32dacfc,
    0xc00195084e52eb3c, 0x4006e355416fbb47,
    0xbff7ffbe4f39ff3c, 0x40056bcce23502ac,
    0xbff425b332e0dd76, 0x3fbb8c6a7e670b80,
    0x4003101adc66e2c4, 0x3ff5870915d7a353,
    0x3ffa51824549a8ce, 0xbffbcf6e3b3bfce9,
    0x400735ace0592361, 0xc000946bcfceecc0,
    0xbfee0324f25b7090, 0xbfe5609322aa6246,
    0xbfb3bad323d885b0, 0x400917f6d67d880e,
    0x400d8300dba3d6fa, 0xbff077773476aa3f,
    0x3fd53c6156f2006c, 0xbffc621316272d52,
    0xbff583b12f9035e5, 0x3fd2147b97714bd6,
    0x3ff6eeb28666ee76, 0xbffd7d9526b34034,
    0x3ff8b63857ac5f74, 0x4002cd3ae0e26844,
    0xbfeb6e7febdba895, 0xbff47f79649c9f04,
    0xbff9453aefb63f22, 0x3ff063c564048dd0,
    0x3fedb1f298eeaca5, 0xc002da13172e28f2,
    0x3fb75696bcd75710, 0xc0028c76304b7464,
    0x3fd70add9284794e, 0xbff02251e5f69a85,
    0x3fc5c0f169e126e4, 0xbfe80ee05cc53b95,
    0xc00a046a00d3e961, 0x3fb8bb12a548dbcc,
    0xbff9eb5cafc998a2, 0xbffa13c291bc3cc1,
    0xbfe8c3b70593529b, 0x3ff95ef598918ee3,
    0xbfe66aca3a6a4ba4, 0x3ff54f86671092a2,
    0xbfff74a6595f0acc, 0x3ffb6e49e67263d0,
    0x3ffeb1ecfe4526eb, 0x3ff0da91e4ded70e,
    0xbff42c2447b22b9e, 0xbfe72c5d5b24994e,
    0x3fd240e60cf0d461, 0xc006fd468b1c8e7b,
    0xbfefd2f51fdcefcb, 0xbf9a1098668226a0,
    0x3ff8486ac2db1a6e, 0xbfd84a2409a3efc0,
    0xbff1ebe1f9b3d2cc, 0x400b974541a6bbda,
    0xbfdedb86a928a048, 0x4008d2310fe0fac6,
    0xbffa0876dcf8691c, 0xbfb06e533c39cab0,
    0x3fd07d5de0c1faba, 0xbff7adb2bbb12f69,
    0x3ff1599567f98b1e, 0xbfe55fcee0e434ea,
    0x3fed3512cb8b900b, 0xbfeb423e58e42a1e,
    0xbfd371da3279a348, 0xc001afab3eb2c525,
    0xbfda6affda243ec2, 0x3ffb4944a6ec821f,
    0xbfced1989edbe418, 0x3fe0c79bb8be3b06,
    0x4004592028f1deb6, 0xbff066ec1487e1aa,
    0x3fc9e22e409910f0, 0x3ff9bc305a76f590,
    0xbff3d3d8fd1fe2ed, 0xbff5cd24642f7326,
    0xc00ff818bda4c580, 0x400532e31d8a8895,
    0xbfd618df14d16295, 0x3ff28480ff66d1ae,
    0x3ff931a60c14ca9e, 0xbff05dde76397548,
    0x3fc87748a16d02e4, 0xbfbcde7f94712b50,
    0x3feb0f900dbac1fd, 0x3fec1b3715a6b023,
    0x3fe1266d9e6d40dd, 0x400af83242124906,
    0xbff34112b5a32554, 0x3fe5e2f5a08ca5e9,
    0x3fdc6568bf957497, 0x3fdf336b1189269e,
    0xbfd452493e4e0fc8, 0x3fc44b6dda644c92,
    0x4003ccd81514dede, 0x3fd0693bceadc860,
    0xbff0ef6be5d018b6, 0x3fec1a7bbdc7758c,
    0x3fd8c069a2982b60, 0xbfffcd7b6444697c,
    0xbfce37318a9b6a00, 0xbfe1f3db1779b242,
    0xbfe4c87f658330c6, 0xc00619bc76f5516f,
    0xc0033f040ff68b18, 0x3f9b9088b59112a0,
    0x3fcae23a5aa4093c, 0x3f830c0b0df1ae80,
    0xbffe0964ad310856, 0x3fee4002f72469e5,
    0x3ff26b47a36f717f, 0x3ff6ea38c9cc95ef,
    0xbfec4099862265ae, 0x3fd6d2b36b004cf2,
    0xbfeaa4545903af45, 0xbfe83944fa82c727,
    0xbfe2190402c93b3a, 0xbfdd7b5afc9690e6,
    0xbff9e0758fd48557, 0xbfdae34a424d5500,
    0x3fc47394ad07ea68, 0x400c0435b32f1bb6,
    0xc00db5c9264e355c, 0x3ff5ff03b1c1c9e4,
    0xbffc11da64b7f34c, 0x3ff28ee3b7386db6,
    0xbfec33a4be8a61d8, 0xc00ea91bd8800246,
    0xbfc5d23481bdf6d2, 0x3febde4e7449bf79,
    0xc00a48ac18b57e53, 0xbfda2d11794e1f20,
    0x3ff280e904dee594, 0x400867307ad598f7,
    0x3ffcd5cdaaca5395, 0xbfd530a3e163d31c,
    0xbffa58e4bd771dc6, 0xbfcd5dafc898f777,
    0xbfe09e06a159b404, 0x3fdd37576a4c2baa,
    0xbfc0c321e2c327d8, 0x3fe0ee1b725185aa,
    0xbfdd9b87bf3c0604, 0x3fe19a3b8af2a7e3,
    0xc001804b18a72d2f, 0xbff75fa5054fff4d,
    0x3ff9ca5b4fd88898, 0x3feec87f0053a968,
    0x3ff91c6ef81a75e2, 0xbfff5b952c7074ac,
    0x3fd71943d12d0c90, 0xbfeb98f82adbd8cf,
    0x3ffca8f253aeddb2, 0x3ff0e7190003ac3f,
    0xbfcb269669ddaa60, 0xbff5b9cbd7207485,
    0x3fe06ff3fe1e6bce, 0x4002e5bb3bd72a7c,
    0xbfe2ab052058c958, 0xbff82fb2c550ce52,
    0xbff8486b4173b049, 0xc000f9dde3943742,
    0xc0042bac79cf361e, 0x400310633356604a,
    0x3feac48d25b23870, 0x3feabc280b237506,
    0xbfe82f28cf1feb48, 0x3ffb35e97dbd8c97,
    0xbfee2291b61bbc52, 0x3ff042cc6dd6fdbb,
    0xc00277ab8a0a1698, 0xbffd839a8caf1224,
    0xbfe26a0b31ab2140, 0x3fffa081d20e1353,
    0x3fe5c3187a63a9c4, 0x3fefaa3dcc524ab4,
    0x3fb9caf001db2a90, 0xbffb384581c3796d,
    0x3ff7c06c8a1c9a19, 0x3fe8784b66b0a602,
    0x3ff241e83f31b834, 0xbff1f97f17d347aa,
    0x40020d1f95064a24, 0xbff75dcfdadd0403,
    0x3fb7aaec595fc770, 0xbfd13bba040a87af,
    0xbfc3c3f73a65e050, 0xbfdacbbf57d8e1ba,
    0x3fc9a8a4303ca120, 0x3fe873c5682bfa23,
    0x3fb84afb1dc12acb, 0xbfe5dc2cda962836,
    0x3fd7ab34bea5cd08, 0xbfef3fcb8e21a436,
    0xbff455826a93f66e, 0x3ff18397ea8738ce,
    0x3febfea7cb996b2d, 0xbff7d92de8b77c2d,
    0xc00566d79b5798f0, 0x3ff5bc8b85d3b549,
    0xbfee9b4bdb8c62ac, 0x3fd5aa713d290270,
    0x400ac58802ee1c92, 0xbfd5f2d9982c5dbc,
    0xbfe19227e389379e, 0x3fda2a2671cebd14,
    0x4002aa8ade41028e, 0xbfe31249affbfdff,
    0x3ff629ff77903bba, 0xbfedccb5368208af,
    0xbff12eae388ae126, 0xc00d264791484704,
    0x3fd717b13abc9f68, 0x3fff035e77ace969,
    0x4001591736bb22fa, 0x3fc3d43869193bb8,
    0x3fe38d7c5cef121e, 0x3fee2b1c40bdf9ba,
    0x3f34b95c0431c800, 0xc002537afaa7fff0,
    0xc003491364edde87, 0x3fea0a6ef2c32a64,
    0x4001eb6954aeee75, 0x3ff1103f19b978b8,
    0x4001291a80e9da3e, 0xc001fab28e3d201e,
    0x3fa34c28d866a1c0, 0xbfe319449d1b225c,
    0xbffe3d452713bffa, 0xbfde6ebf9bd085a6,
    0x3fcb5cb08c06e240, 0xbffe0d20ce1bc5e1,
    0xbff975dc4e1b0396, 0xbfeff6cddc6857ea,
    0x3fefc720198dbe4a, 0x3ff1ae4507cd91d8,
    0xc0076f3fe2378a44, 0xbff246b256a01de8,
    0x3fc094f7a9a4c32e, 0xc0068abcd3acb198,
    0xbfd61795dfeca94e, 0x3fe3137ad0e0fa1b,
    0x3ff0ef530382fcfc, 0x40100d8a3e60f107,
    0x3fcdf089647d3fb8, 0x3fe9e4ecd738a090,
    0x3fe74715e98a9315, 0x3ff7aae6e2e44493,
    0x3fdacb3fa4ba9925, 0x3fee8dbf72aedc1a,
    0x40044a3048c536c7, 0xc002e3e6263ba1d4,
    0xc004e6ae885a1948, 0xbfd465078ad09294,
    0xbffdb76d50b1d354, 0xbff31a43bd9dff01,
    0xbfe8ba9f74e27c86, 0x3fe4582a5f6517f0,
    0x3ff895fdaa4d3a45, 0x3fd50ca382775f8c,
    0xbff13095590647be, 0xbfdbe3be7d795df4,
    0xbfbee48c92f9d2d0, 0x3fffdc3042e2b1fd,
    0x3ff986df01ea2554, 0xbfe621f53f495e47,
    0x3feb43ea47997b86, 0xbff2b564152a6b0c,
    0xbf96df1b1d4c57e0, 0x4002dc6dbfe87083,
    0xc0030d800e6852bc, 0xc00a987adb63305d,
    0x3fd3a1357879fe3a, 0xc0018b7d3aa1c054,
    0xbfe5a1e879a08d5c, 0x3fea86ec8d816d10,
    0xbff6be41ced22b38, 0x3faa6f00dd96b700,
    0xbffc430dfdcba616, 0x3fe51b5f5fa6fe66,
    0x3ff9445de36e36ce, 0x3ffd68cfbd0b0ceb,
    0xc009e5d378ecf205, 0x3fe75c4437e37cda,
    0xbffb705818c13e80, 0xc003d63d21db240d,
    0xbfd816ad18cd6c6a, 0xbffbd20d7eceac6a,
    0xbfce3dd3c6748062, 0x40052dd2c17b6ee7,
    0x3ff8a49d3ada420e, 0xbff44a2459983f4d,
    0x3ffaf79057053fbc, 0x3fcf31f35ae8c602,
    0xc0075842faa11102, 0xbfc1c06e9627b3f0,
    0xbfeeb0eda0c7a0ec, 0xbfc0a55aa942ebd4,
    0xc0132742544d0cf8, 0x3ffcce09b4b0a761,
    0xbff97708391a391b, 0x3fccb156628a35a0,
    0xbfa648ee0af32cb0, 0xbfb1d912188f5438,
    0x4000bef119dd524a, 0xbff713e398026257,
    0xbfe7450afa1e9d3d, 0x3fe20c64ddae0258,
    0xbfb8d989abed5104, 0xbfd3410f36d02956,
    0x3ff440f23f538237, 0xc006bb7a4b105747,
    0xbff6861a8c40d2c6, 0xc004598055dc32d5,
    0x3ff0e8691a9c153b, 0x3fe68aa51c613db0,
    0x4000ac4c5649ffc9, 0x400be4919e78c425,
    0xbfb2f4597fa3aa84, 0x3fe1aa786f40d25c,
    0x3fd178930859c95e, 0x4005a3e574eab180,
    0xbfef0394f9d43df9, 0x3ff4aa42efe87bc8,
    0x4001b31d5ccf4da7, 0x3fed1e48700873eb,
    0x3ffd7cceebe10fcb, 0xbffaace70aabad5f,
    0xbffd5d856572d5ea, 0x3fe86319ce86249e,
    0x3ffe11f24f8b2e81, 0xbfcf2217d34d9790,
    0x3fcdb6e3762990e8, 0x3fed4727ec179753,
    0x3ff7703e718aae2f, 0xbfe63a508a502088,
    0xbfe2105785e693e0, 0x3ff401bd37fcead0,
    0xbff49720c4737511, 0xbfdc007d15060e48,
    0xbfd94ec9d1f19c38, 0xbfc29fbcbff9a318,
    0x3fe5e977bf554b40, 0x3ff18275990a35fc,
    0x3fe7c1ebf0714081, 0x3fe9f3c91a709b0f,
    0x40034f958ebcd66d, 0xbffe7a1dceba6bc8,
    0x4005835f8b6dd78c, 0xbff9c8d1cbd3536c,
    0x3ff472f6105d836d, 0xbfe67a869745b05a,
    0xc001d2874c681102, 0xbfe1f2545876b386,
    0x4005e99bedf23ae3, 0xbfdc7e84c2ca3a2a,
    0xbfe61b48a60c19b4, 0x3fd24012e56ed30a,
    0x3fbf133b92c400e8, 0x3ff78c6ae4886a4d,
    0x3fe85083e03bbd67, 0xbffe237d11118cf5,
    0x3ff896e36a8b00d9, 0xbffeed66188434b2,
    0x3ffd1b5ce23cb02f, 0x400744cb9ee30e40,
    0xbfd8635472ded212, 0xbfeeaaee7b0385f6,
    0x3ff60e8d33047ddf, 0xbfc29906bb1fa1e8,
    0x3fd2923f2e99a17a, 0x3fd1844fbaf33476,
    0xbfd1751089ec0fb6, 0x3fecfb7e99d89500,
    0x3ff6d66a706013be, 0xbfe8fe28de01b716,
    0x3fcb2fd4f96733bc, 0xbfe0a6ab74b75000,
    0x3fe5c96890311550, 0x3fdc464982cee30a,
    0xbffe9934c65c9795, 0x3ff6a2f31a8d2f34,
    0xbfffc37270892a55, 0x3fe57fcb1cadb380,
    0xc007b5366b0582c1, 0xbfb68f7c42efbee0,
    0x3ff3f7950fca3751, 0x3ff0784bbe9fbd2c,
    0xbfdb900fe6ed0f00, 0x3feb3c3d920c7fce,
    0x40002f7c6846b07c, 0xc001732bd61f28e8,
    0x3ffc75b14ae1c134, 0xbfbd30ecc1815b10,
    0x3fea2569afdc4040, 0xbfefb74bbda3f93a,
    0xbff8eb5275077d7c, 0xbff1229b8515c618,
    0x3fcad47b7fc857c8, 0xbfe30398e2d854e6,
    0xc008bb3b19cd00c6, 0x3fc98eca8d9ce656,
    0xbfbf4dad2298cb00, 0xbfed5ed6f54eb6a7,
    0xbfed48887e01e66a, 0x3fea11a8bbefd064,
    0xbfccae18873624e0, 0x3fcf237090cdbfd8,
    0xbffa57241bd8ed3b, 0x3ffb461b952f6a40,
    0x3ff0571187a85138, 0xbff8a9b238b610ca,
    0x3feb76776602f1b9, 0x3ff0519bfaf92074,
    0x3ff95254e51b80ed, 0xbfeba12f3dc812ce,
    0x3fe602e8a634c670, 0xbff2341bb995e11c,
    0xc003e4a121d13f9e, 0xbffc542fea9fa450,
    0x4004899959826283, 0x3feeb47af9851db6,
    0x400f077e31ffdda3, 0x3feb173dc3681861,
    0x3ffa4736e9bb7f9b, 0xbff7b86218ca0f53,
    0x3feee388dc2eced1, 0x3ff75516f0403ac6,
    0x3fddd20491ea617e, 0x400b15c6a4d2416c,
    0xbff302bd88de0af8, 0xbfd5fee30fff6d87,
    0x3fd55deb86d36ef4, 0xbf80b1f3c0911fc0,
    0x3fe0ae16dfc2a44a, 0x3ff59c610ce1f444,
    0x4001e7b20bfffbd5, 0x3fdfb7ccb8012644,
    0xbff4a525d6a5bf86, 0xbfe634bf3ed4d8ad,
    0xbfc733f81f4e9ad8, 0xbff5b31fdf5046be,
    0x4003d24b1fac2b03, 0xbff647099fe9645b,
    0x3fbc8a6f11e24540, 0x4009eff3d9768026,
    0xbff8651bd0fb57e0, 0x3ff710bdff38e3e6,
    0x3fefe5fc4b015ef6, 0xbfd51c942e0fc7f6,
    0xc0076785ec64ae96, 0xbfe0c4ddc397ab21,
    0x3ffc4121021b2f64, 0x3fec40eff609afbe,
    0x3fd64b720bae40c1, 0xc0007a7c4bc13e92,
    0xbff10e9d5c11d6cb, 0x3feabc01812364bc,
    0xbfdb9646f334f790, 0xbfccc49e125015e8,
    0xbfd575d713b9a8a8, 0xbfe99ee240c7d1fc,
    0x3fd1ef6ec07a3dfc, 0xbffae40cf2c1cf9d,
    0xbffa6337f04d26dc, 0x3ff0e056ff752ad2,
    0xc00975825dd1a520, 0x400a13b42273162a,
    0xbfe4e2fa57204fad, 0x3fc088066b873d1c,
    0xc01668d28b6e2336, 0x400626fbf967b3b4,
    0x3ff9a54e20777e93, 0xbfef93a0f4221c9b,
    0xbfeb9fb91bfc5a13, 0x3fea90d20fee7ed6,
    0x400b860a3d7f28ae, 0x40017051fe1f8eac,
    0xbffdf291317c8177, 0x3ff802658530fde5,
    0x3fff9a54c2b69504, 0x3fe828993fc3c22b,
    0x3ffd6961418f69d9, 0x3ff09c44574675b7,
    0x3ffd074b3252864a, 0xc0002dfce1d1ede0,
    0x3fa2cbaa0f32c320, 0xbfba78a2d261b9d0,
    0x3fd6d3e972091e95, 0xc004197594f3c203,
    0xbfe14061c2d5c23b, 0x3ff8a178e7e2b7a4,
    0xc008565faa0ef87a, 0x3ff214b40c374ca8,
    0x40082dfce71558b6, 0x3fe88c190b19e050,
    0x401071a1462c7ef6, 0xc019f545f7e746a1,
    0x3ffdc6bca8cfd8f0, 0xbffaa271e1334aee,
    0x3fb8e0b74585ee50, 0xbfeb72c8f8689eb8,
    0xbf9208ab9bfeef60, 0xbff08ec100fc72ce,
    0x3fd408b351aba252, 0xbfd99643a12aa42c,
    0x40012f4a51ee7cfa, 0xbfe8a4cfdac3f75c,
    0x3fff9f4b02d585d7, 0x3fdfb7cab2511131,
    0x3fff6e15da27532e, 0x3fe61f938a27ba46,
    0xbff199afcfee6898, 0xc00f248326d85286,
    0x400c0537fa417fdf, 0x3ffcdba372a2e3b0,
    0xc0109847b188c028, 0x400688a8b684f85f,
    0x3ff3cde9c67f31ed, 0xbfdede36bc447403,
    0xbfd19255d6e8ad46, 0x40016442986ee44e,
    0xc004ab214073c540, 0xbffea7ba983398a4,
    0xbfeea6c983c65ee6, 0x3feee592533b0f77,
    0x3ff102add34cb2df, 0x3ff512211d90bff8,
    0xc0033c757f991fe4, 0x3ff84a3f3e77c0f8,
    0xbf95ae94357ee030, 0x3fe6be181fa907f6,
    0x3fc2558222abe2fc, 0x3fe11d4efd8e93d5,
    0x3fea66e4f9d6bd50, 0xbfecf281787d637e,
    0x3fd3631d9da50174, 0x3ff8df575d749305,
    0x3ff8df54259d78ca, 0x4009fb2e1d059ea8,
    0x3fef6d47422bab4e, 0xbfee17ae05ead466,
    0xbfdcd50c72d60614, 0x3feb7e8e86ddb2b2,
    0xbfd47625e5c59fb4, 0xbfcebf68e764d7fe,
    0x4003a4ee7d235d46, 0xbfec26b940a0dc2d,
    0x40042c3d67348d74, 0xbfe47fb8f390078d,
    0xbff2dc164a9563ca, 0x3fee54d36e6a9d0e,
    0xbfd2e6284e0d6080, 0xbff6d0dc7c0664e4,
    0x3fc0a08dcec70f9a, 0x40026a2e6304b4f5,
    0x3feabb6b34cc6392, 0xbff08ebbb695a9fa,
    0x3fef7e9ac4577913, 0x40067badd2648fce,
    0x3ffce8c553d4aea6, 0xbff98fe8b08ab06e,
    0xbfc3779a2dec081f, 0x3fcfc0895c7d534c,
    0xbfde924804bd6aef, 0xbfd3f3cf40f2f2b2,
    0xbfe0e581c78130e8, 0xbff77e152db9ccfd,
    0x3f8c036b894089c0, 0xc0046c6718ff8ca1,
    0x3fea4afc95c24ae1, 0x3fddc87cff6becff,
    0xbff427cb7dd4f60b, 0xc00180eaf251ffd9,
    0x3fe5ed77ab6cf3cb, 0x3fe2c3f68baa8faa,
    0xbff183916fc2aa6c, 0x3ffb7eae343e32c6,
    0xbfe92e1d0d65e5dd, 0xbff91c835f8daba4,
    0x3fd579b22b889691, 0x3fc2c68ca5d70908,
    0xbfeb644e3732e246, 0x4001fc3b59cfaa54,
    0xc009405cd4d2c009, 0x3fe7c8a6ce0a1700,
    0x3ffc2c601339f9a1, 0xbfe82f487a321534,
    0x3fe5d9191858cbd6, 0xbffb1c0dbabf6691,
    0x4000b6824022888e, 0x3ff75f35c9e55ea2,
    0x3fcc8ba6f25b9ef4, 0x3fe2f461e6f6af21,
    0xbfdb70544573a30c, 0xbfdf1ac5e8e40bed,
    0xbfe18dbe9e732b9d, 0xbff348f6097054c7,
    0xbff172025ee3d342, 0x3feef9836a58ade3,
    0x3fe483fd3805ab38, 0x3fe5ad7ee538eebc,
    0xbfe3812e05696017, 0x3fd2ffdcbf2a2c54,
    0x3fcf386b91d5f670, 0x3fe58b08a687a7e3,
    0x3fc76f315c9d4be8, 0xbff50da452ea8e9f,
    0xbfed35c8979a2def, 0xbfe7167c528f1145,
    0x3fdd3c8165c7db08, 0xbff84897d004cca8,
    0x3ff5e45c956e4f8f, 0x3fe85f7e36bec91a,
    0x3ff9c2150935f570, 0x3fdae2d31b3daf20,
    0xbfe988bd0bea419c, 0x3ffc26f87b0b807c,
    0xbff88105dbc5dfa4, 0xc0078365b190723a,
    0xc0077c2a72e74476, 0x4002fb9676ff2182,
    0x3fd7dd2659fe4550, 0xbfe9a62d17d4863a,
    0x3ff4d3ce88150182, 0xbfeac8f8019dc7a8,
    0x3ff38e8efeabec56, 0x3fb24e337db3b398,
    0x3fde104030896766, 0x4000d448699226b3,
    0xbff990fd387f8ad4, 0xbfee6b2646094b96,
    0xbff86dfddb3784d0, 0x400277d4476aa86c,
    0x3fed5875cc787118, 0x3fcf57cb09b13694,
    0x3ff0cd49da7ee84b, 0x3fd33a85cc238e94,
    0x3fff52e90c4bb75a, 0xc00d14449ceb480a,
    0xc002be4bb7acffac, 0xbff62dfef42a283d,
    0x3fdaa83f495c2756, 0x40055ba1c2b9bf51,
    0x3fa458e9d4d817a0, 0x40014e5b16e5b307,
    0x3ffb595992022678, 0xbff089ed81ef87e0,
    0x3fcbf4be4669fc80, 0xc001bf7e9172c9a9,
    0xbfe7286f1fbb5528, 0x3ffadddbc97dce22,
    0x3ffa5fabd1a2efc1, 0x3fd728b659985bae,
    0x3ff9f84b739eae08, 0x3ff9322affd82055,
    0x4001215081952a85, 0xbfe1568030c4cfcc,
    0x4005f7badbb5ea87, 0x4013a4a1281a5ede,
    0xbff2662d01479b33, 0xc0010d9e1ce4ac11,
    0xbff5334eb16eefa6, 0xc0095144cb79cf37,
    0xbff0779fd0efb26e, 0xbffd1254b3a89c80,
    0x3f9f3e1909934700, 0xc002ac49a4f7c0c6,
    0x400c8fb659f1a5fa, 0x3fcc78925c9f0512,
    0xbff962b937a508f3, 0xc0075d23d4466c8c,
    0xc006d076bf0dfea2, 0xbffd9c127d707c98,
    0x3fdf85eb56738ffa, 0xbfb3391d7a5111b2,
    0xbff2f2bc5bd51326, 0x3fe95e87d445bb1e,
    0x3fe34a808864cc28, 0xbfe5633a19ce1dae,
    0xc00c31d421c2ce02, 0x3fd652ac03dc3386,
    0x400548528ac801fd, 0x4009fa69db55fbb4,
    0xc004f8ed4a8dbe18, 0xc0101f173756c038,
    0x3ff498e62aa410f6, 0x3fe93b1a1e091184,
    0xbff04b272cb923be, 0x3ff19442745be07e,
    0x40031eba9592f582, 0xbff5f29d544320c8,
    0x3fd6957c7a3348f6, 0xc001750f200cd1d4,
    0x3ff93081c08a2636, 0xbf96440d93096bc0,
    0xbffd1ca26237d362, 0xbff42e2dd329dad6,
    0xbfffc066548cc7f2, 0xbfed01ce8b994aa2,
    0x3fe36f6dc3c4d182, 0xbfd06cd597a94a3a,
    0xc0087ed5a4ae2e1f, 0x400ba9786498456b,
    0xc00658c544440b6f, 0x3fb7bcc805b19e40,
    0xbfd3723e764ea90c, 0x400416a2856738fa,
    0x3fc1045887d617ce, 0x3ff0c897c93c7e55,
    0xbfca189afdf355aa, 0xbff4f66f28391b7d,
    0xbfd77274b6836516, 0x3fe360d59e08ad29,
    0xbfb4284e9e769cac, 0xbfeb3e54306bf03a,
    0x3ffbd65a05ef6c06, 0x3ff283c5770bca75,
    0x3fc95b803c068020, 0x3ff56c6d77a0f69a,
    0x40038a278355a676, 0x40073e728f745e3e,
    0x3fe54f1239b87b8a, 0xbfea66e020c38d4e,
    0xbfc6223180e230a8, 0xc0055739ab293278,
    0xbfd8cddd96e75000, 0x3fc9f753b373e31e,
    0xbfe632ec8015a194, 0x3fad10b62d234840,
    0x4004ab91e4b2183b, 0xbf91f02449f0c6b0,
    0x3fe44cf2531d8f83, 0xbfb626a4976a82a4,
    0xbfe5de85495ccef4, 0x3fed187381698d83,
    0x3fe9e235c1c42ac1, 0xbfdfe0ac30f66c20,
    0xbfcbb79e53322170, 0xbfd34efdcf120714,
    0xbfd69ddff7bfadf6, 0x3ffa090dbb22cff9,
    0xbfed4bd5564fc36f, 0xbff1035f6d0c8735,
    0x3ff06dd96f8d56e6, 0x4002bc0bf868d68c,
    0xbfcd602daf300626, 0x400f63a1892768aa,
    0x3ff6cc0f1c7070dd, 0xbfd5f6d25a00eac6,
    0x3ff327902e1c9e1b, 0xbfcd7578cab11436,
    0xbff148e7f2e93bea, 0xbff66381087aa98c,
    0x3ff51210519e914e, 0x3fcb551eb95a6cfd,
    0x3f51a80d8ba52c00, 0x3ffcd189e097ca1a,
    0x3fe3f09c45a067a4, 0x3fc39ebb205ebfc2,
    0x3fd47fefe336e4fc, 0xc00c461264f5c1c8,
    0x3ff44b7477bebc92, 0x3fec3d161dd67d43,
    0xbfea940df693e094, 0x4005a757bbfa181e,
    0xbfdd05aeea0275fe, 0xbfa44785ae649ac8,
    0x3fd1da0115a48094, 0xbffac3d972181b49,
    0x400b2177ae870c05, 0xbfdfe1a000f8685c,
    0x3fece15d4f402613, 0x3fe0964239a90e7e,
    0x3fc6e68666636888, 0xbffec7be2f889fb5,
    0xbfd90e7f577345e3, 0xc0030afbc345e364,
    0x3fd97c04e4d84222, 0x4001277065567b32,
    0xc0013d77bc3db1eb, 0x3ffb3d5f3387ec33,
    0xbfd94cd571f1f3f2, 0x3fdeff24ec5a655a,
    0xbff9099d2d441b24, 0xbffa0dad2df68605,
    0x3fe6e31ce2bacb8a, 0xbff0c6194a5dee94,
    0x3fdaeb6960c20a00, 0xbfcf12df424d79e0,
    0x3fea4d039c364e88, 0xbfe745ac696182a8,
    0x400fd41bb984d82b, 0x40015884ea5692f8,
    0x3ff9d448c9236a57, 0x3febd6a88d75f545,
    0xbffb3b626d23700d, 0xbfd22b601bee3710,
    0x3ff092f1e1110a61, 0xc00683a461436473,
    0xc0022c56bb76281c, 0xc003f9f5980a3ad2,
    0x400146aeadc53076, 0x3f66206736cce800,
    0x40078efe9930e0d6, 0xbff5971fceefe626,
    0x3fe853a5b55dd56d, 0xbff63ce9433b9d90,
    0xbfed47695c45c4e4, 0x3ff7aab6ef87a86b,
    0x3fd6581da294ee45, 0xc00a3c99f6c9e0ea,
    0x3fe15f4c721ced3c, 0xbffe733d8638a9dc,
    0x3fe28fd627ccabcc, 0x3fee29fc325e5959,
    0xbfd4fbc6a65bcaf8, 0x3ff1b32f0ffca982,
    0x3fdea08d13cb13d9, 0xbff9eae155889fbb,
    0xbff80a29d315fc4a, 0x3feaaaf8202571be,
    0x3fe5c6e6251c9f30, 0x400167be216e9f51,
    0xbfeaa6870d333e78, 0xbfb9577788de7020,
    0xbffc4ee13f0974d8, 0x3fdc146dc31165f0,
    0xbfc18f7f243f4166, 0x3fd290ac2a5c4eba,
    0xbfe8ce50652b8f89, 0x3ff15bb908b64f07,
    0xbfb0f3129f5777b0, 0x4006e263929c4b52,
    0x3ffa435f11ef3083, 0x3fe88aaba049a540,
    0x3fba3d6ca5a046e0, 0x3fde9ddee450ad10,
    0x3ffd22db99d76e1e, 0x3fdfcf76385dee06,
    0x3fe14a2c51dec5df, 0x3ffc05c5fbcb4d36,
    0x3ffeca006ea4df36, 0x3fe9e8f01654cac5,
    0xbfbae7fe07618b90, 0x3fc4b7b86303dd6c,
    0x400456221cbc19be, 0xc000ffb58f12f51c,
    0x3ffbd1a82755a6dc, 0xbff659ca448e8822,
    0x3ffb524ce8b24dd8, 0x3fdd518f619a4250,
    0x3fe88d6af48cbd75, 0xbfe80e63c9ad50b6,
    0xbfdb0769b099edc2, 0x400240313d255c49,
    0xc00cfd1c585a7517, 0xbff125dba22fca73,
    0xc00d9e288a78be22, 0x3fefc17eeb07cbf5,
    0x3ffecc23914c9d05, 0xbfea0a85e3175072,
    0xc007d02a4deee317, 0xbff7ebb96cb6663c,
    0xbfa43f7a53d75ea8, 0xbfe2fae52b72c094,
    0x3fff7c797563a099, 0x3fe2d6567c0ba4c8,
    0x4011fdf1e8e93182, 0xc007a65db7e7636b,
    0xbfe9e0561d6d2a9e, 0xc000ce435a644ec4,
    0xc005bb63070d3531, 0x3fe47715db811d20,
    0xbffd4eef1851a3ae, 0xbff19a7093f70b8a,
    0xbfeb30ceca472f60, 0x3ffee5d519a20164,
    0x4001445f67d092f8, 0x3fe1e23bbd8d01ee,
    0xbfdb1ecdabef61dd, 0xc001329f88c0f9c4,
    0xbff16a9c70410e84, 0xbf8c2d8516d4cfa0,
    0xbffcb923343b8322, 0x3fee1c13cf4e47be,
    0x400121c56e39e9dc, 0xbfd9005bc1ab2cd8,
    0x3fec3570a7070430, 0x0,
    0x400121c56e39e9dc, 0x3fd9005bc1ab2ce0,
    0xbffcb923343b8322, 0xbfee1c13cf4e47bc,
    0xbff16a9c70410e82, 0x3f8c2d8516d4cfc0,
    0xbfdb1ecdabef61d3, 0x4001329f88c0f9c4,
    0x4001445f67d092f8, 0xbfe1e23bbd8d01eb,
    0xbfeb30ceca472f60, 0xbffee5d519a20166,
    0xbffd4eef1851a3af, 0x3ff19a7093f70b88,
    0xc005bb63070d3531, 0xbfe47715db811d26,
    0xbfe9e0561d6d2a9f, 0x4000ce435a644ec4,
    0x4011fdf1e8e93181, 0x4007a65db7e7636b,
    0x3fff7c797563a09a, 0xbfe2d6567c0ba4c6,
    0xbfa43f7a53d75e88, 0x3fe2fae52b72c097,
    0xc007d02a4deee317, 0x3ff7ebb96cb66637,
    0x3ffecc23914c9d08, 0x3fea0a85e3175074,
    0xc00d9e288a78be22, 0xbfefc17eeb07cbf6,
    0xc00cfd1c585a7518, 0x3ff125dba22fca72,
    0xbfdb0769b099edc0, 0xc00240313d255c48,
    0x3fe88d6af48cbd77, 0x3fe80e63c9ad50bb,
    0x3ffb524ce8b24dd3, 0xbfdd518f619a4264,
    0x3ffbd1a82755a6de, 0x3ff659ca448e8820,
    0x400456221cbc19bc, 0x4000ffb58f12f51c,
    0xbfbae7fe07618ba0, 0xbfc4b7b86303dd74,
    0x3ffeca006ea4df38, 0xbfe9e8f01654cac8,
    0x3fe14a2c51dec5dd, 0xbffc05c5fbcb4d36,
    0x3ffd22db99d76e20, 0xbfdfcf76385dee08,
    0x3fba3d6ca5a046a0, 0xbfde9ddee450ad08,
    0x3ffa435f11ef3082, 0xbfe88aaba049a53a,
    0xbfb0f3129f577780, 0xc006e263929c4b52,
    0xbfe8ce50652b8f8a, 0xbff15bb908b64f06,
    0xbfc18f7f243f4160, 0xbfd290ac2a5c4ebe,
    0xbffc4ee13f0974d6, 0xbfdc146dc31165f5,
    0xbfeaa6870d333e7c, 0x3fb9577788de7000,
    0x3fe5c6e6251c9f31, 0xc00167be216e9f50,
    0xbff80a29d315fc4a, 0xbfeaaaf8202571b9,
    0x3fdea08d13cb13d6, 0x3ff9eae155889fbb,
    0xbfd4fbc6a65bcb00, 0xbff1b32f0ffca983,
    0x3fe28fd627ccabc6, 0xbfee29fc325e5959,
    0x3fe15f4c721ced3e, 0x3ffe733d8638a9d9,
    0x3fd6581da294ee52, 0x400a3c99f6c9e0e8,
    0xbfed47695c45c4e4, 0xbff7aab6ef87a86a,
    0x3fe853a5b55dd571, 0x3ff63ce9433b9d8e,
    0x40078efe9930e0d7, 0x3ff5971fceefe627,
    0x400146aeadc53076, 0xbf66206736cce200,
    0xc0022c56bb76281c, 0x4003f9f5980a3ad3,
    0x3ff092f1e1110a62, 0x400683a461436472,
    0xbffb3b626d237010, 0x3fd22b601bee3710,
    0x3ff9d448c9236a57, 0xbfebd6a88d75f541,
    0x400fd41bb984d82b, 0xc0015884ea5692f7,
    0x3fea4d039c364e88, 0x3fe745ac696182a3,
    0x3fdaeb6960c20a00, 0x3fcf12df424d79d8,
    0x3fe6e31ce2bacb8a, 0x3ff0c6194a5dee97,
    0xbff9099d2d441b26, 0x3ffa0dad2df68606,
    0xbfd94cd571f1f3eb, 0xbfdeff24ec5a655a,
    0xc0013d77bc3db1ea, 0xbffb3d5f3387ec32,
    0x3fd97c04e4d8421c, 0xc001277065567b32,
    0xbfd90e7f577345e2, 0x40030afbc345e365,
    0x3fc6e68666636898, 0x3ffec7be2f889fb4,
    0x3fece15d4f402611, 0xbfe0964239a90e82,
    0x400b2177ae870c06, 0x3fdfe1a000f86856,
    0x3fd1da0115a48098, 0x3ffac3d972181b4a,
    0xbfdd05aeea027602, 0x3fa44785ae649ae0,
    0xbfea940df693e093, 0xc005a757bbfa181e,
    0x3ff44b7477bebc8f, 0xbfec3d161dd67d45,
    0x3fd47fefe336e4fc, 0x400c461264f5c1c8,
    0x3fe3f09c45a067ae, 0xbfc39ebb205ebfb8,
    0x3f51a80d8ba52c00, 0xbffcd189e097ca1b,
    0x3ff51210519e914c, 0xbfcb551eb95a6d04,
    0xbff148e7f2e93be6, 0x3ff66381087aa990,
    0x3ff327902e1c9e1b, 0x3fcd7578cab1143a,
    0x3ff6cc0f1c7070dc, 0x3fd5f6d25a00eaba,
    0xbfcd602daf30060a, 0xc00f63a1892768a8,
    0x3ff06dd96f8d56e4, 0xc002bc0bf868d68c,
    0xbfed4bd5564fc369, 0x3ff1035f6d0c8735,
    0xbfd69ddff7bfadfa, 0xbffa090dbb22cff8,
    0xbfcbb79e5332216c, 0x3fd34efdcf120718,
    0x3fe9e235c1c42abd, 0x3fdfe0ac30f66c10,
    0xbfe5de85495ccef6, 0xbfed187381698d7f,
    0x3fe44cf2531d8f86, 0x3fb626a4976a82ba,
    0x4004ab91e4b2183a, 0x3f91f02449f0c6c0,
    0xbfe632ec8015a192, 0xbfad10b62d234860,
    0xbfd8cddd96e75004, 0xbfc9f753b373e30e,
    0xbfc6223180e230a2, 0x40055739ab293278,
    0x3fe54f1239b87b90, 0x3fea66e020c38d4f,
    0x40038a278355a675, 0xc0073e728f745e3e,
    0x3fc95b803c068028, 0xbff56c6d77a0f69c,
    0x3ffbd65a05ef6c07, 0xbff283c5770bca74,
    0xbfb4284e9e769cbc, 0x3feb3e54306bf039,
    0xbfd77274b683651d, 0xbfe360d59e08ad25,
    0xbfca189afdf355a2, 0x3ff4f66f28391b7a,
    0x3fc1045887d617b8, 0xbff0c897c93c7e57,
    0xbfd3723e764ea914, 0xc00416a2856738fa,
    0xc00658c544440b70, 0xbfb7bcc805b19e20,
    0xc0087ed5a4ae2e1e, 0xc00ba9786498456d,
    0x3fe36f6dc3c4d17c, 0x3fd06cd597a94a36,
    0xbfffc066548cc7f0, 0x3fed01ce8b994aa2,
    0xbffd1ca26237d360, 0x3ff42e2dd329dad6,
    0x3ff93081c08a2635, 0x3f96440d93096b80,
    0x3fd6957c7a3348fa, 0x4001750f200cd1d5,
    0x40031eba9592f582, 0x3ff5f29d544320c7,
    0xbff04b272cb923bc, 0xbff19442745be07e,
    0x3ff498e62aa410f6, 0xbfe93b1a1e091188,
    0xc004f8ed4a8dbe19, 0x40101f173756c038,
    0x400548528ac801fd, 0xc009fa69db55fbb4,
    0xc00c31d421c2ce02, 0xbfd652ac03dc3382,
    0x3fe34a808864cc24, 0x3fe5633a19ce1db1,
    0xbff2f2bc5bd51326, 0xbfe95e87d445bb21,
    0x3fdf85eb56738ff4, 0x3fb3391d7a5111a8,
    0xc006d076bf0dfea3, 0x3ffd9c127d707c9a,
    0xbff962b937a508f0, 0x40075d23d4466c8c,
    0x400c8fb659f1a5fa, 0xbfcc78925c9f0504,
    0x3f9f3e1909934680, 0x4002ac49a4f7c0c6,
    0xbff0779fd0efb26e, 0x3ffd1254b3a89c82,
    0xbff5334eb16eefa6, 0x40095144cb79cf36,
    0xbff2662d01479b34, 0x40010d9e1ce4ac11,
    0x4005f7badbb5ea86, 0xc013a4a1281a5ede,
    0x4001215081952a84, 0x3fe1568030c4cfcd,
    0x3ff9f84b739eae09, 0xbff9322affd8205a,
    0x3ffa5fabd1a2efbe, 0xbfd728b659985bac,
    0xbfe7286f1fbb552b, 0xbffadddbc97dce24,
    0x3fcbf4be4669fc68, 0x4001bf7e9172c9a8,
    0x3ffb595992022678, 0x3ff089ed81ef87e1,
    0x3fa458e9d4d81780, 0xc0014e5b16e5b307,
    0x3fdaa83f495c2754, 0xc0055ba1c2b9bf52,
    0xc002be4bb7acffab, 0x3ff62dfef42a283c,
    0x3fff52e90c4bb75c, 0x400d14449ceb480a,
    0x3ff0cd49da7ee84b, 0xbfd33a85cc238e90,
    0x3fed5875cc787116, 0xbfcf57cb09b136a0,
    0xbff86dfddb3784d0, 0xc00277d4476aa86c,
    0xbff990fd387f8ad1, 0x3fee6b2646094b8e,
    0x3fde104030896764, 0xc000d448699226b4,
    0x3ff38e8efeabec54, 0xbfb24e337db3b3a0,
    0x3ff4d3ce88150185, 0x3feac8f8019dc7ab,
    0x3fd7dd2659fe4550, 0x3fe9a62d17d48639,
    0xc0077c2a72e74474, 0xc002fb9676ff2182,
    0xbff88105dbc5dfa1, 0x40078365b190723a,
    0xbfe988bd0bea4198, 0xbffc26f87b0b8079,
    0x3ff9c2150935f570, 0xbfdae2d31b3daf20,
    0x3ff5e45c956e4f8d, 0xbfe85f7e36bec920,
    0x3fdd3c8165c7db0c, 0x3ff84897d004cca6,
    0xbfed35c8979a2df6, 0x3fe7167c528f1141,
    0x3fc76f315c9d4bf4, 0x3ff50da452ea8e9e,
    0x3fcf386b91d5f660, 0xbfe58b08a687a7df,
    0xbfe3812e05696018, 0xbfd2ffdcbf2a2c50,
    0x3fe483fd3805ab3a, 0xbfe5ad7ee538eebe,
    0xbff172025ee3d341, 0xbfeef9836a58ade6,
    0xbfe18dbe9e732b9a, 0x3ff348f6097054c6,
    0xbfdb70544573a317, 0x3fdf1ac5e8e40be2,
    0x3fcc8ba6f25b9eee, 0xbfe2f461e6f6af22,
    0x4000b6824022888d, 0xbff75f35c9e55ea4,
    0x3fe5d9191858cbd4, 0x3ffb1c0dbabf668e,
    0x3ffc2c601339f99d, 0x3fe82f487a321536,
    0xc009405cd4d2c008, 0xbfe7c8a6ce0a1700,
    0xbfeb644e3732e247, 0xc001fc3b59cfaa55,
    0x3fd579b22b889695, 0xbfc2c68ca5d708f4,
    0xbfe92e1d0d65e5d9, 0x3ff91c835f8daba0,
    0xbff183916fc2aa6e, 0xbffb7eae343e32c5,
    0x3fe5ed77ab6cf3c4, 0xbfe2c3f68baa8fae,
    0xbff427cb7dd4f607, 0x400180eaf251ffd8,
    0x3fea4afc95c24ae3, 0xbfddc87cff6bed08,
    0x3f8c036b89408980, 0x40046c6718ff8ca0,
    0xbfe0e581c78130ec, 0x3ff77e152db9ccfd,
    0xbfde924804bd6ae2, 0x3fd3f3cf40f2f2ae,
    0xbfc3779a2dec082a, 0xbfcfc0895c7d5354,
    0x3ffce8c553d4aea8, 0x3ff98fe8b08ab070,
    0x3fef7e9ac4577915, 0xc0067badd2648fcd,
    0x3feabb6b34cc6391, 0x3ff08ebbb695a9f9,
    0x3fc0a08dcec70fc0, 0xc0026a2e6304b4f6,
    0xbfd2e6284e0d6080, 0x3ff6d0dc7c0664e4,
    0xbff2dc164a9563cb, 0xbfee54d36e6a9d0c,
    0x40042c3d67348d76, 0x3fe47fb8f390078b,
    0x4003a4ee7d235d46, 0x3fec26b940a0dc29,
    0xbfd47625e5c59fa2, 0x3fcebf68e764d802,
    0xbfdcd50c72d60617, 0xbfeb7e8e86ddb2b1,
    0x3fef6d47422bab4b, 0x3fee17ae05ead460,
    0x3ff8df54259d78ca, 0xc009fb2e1d059ea6,
    0x3fd3631d9da5016e, 0xbff8df575d749305,
    0x3fea66e4f9d6bd4f, 0x3fecf281787d637b,
    0x3fc2558222abe2f4, 0xbfe11d4efd8e93d3,
    0xbf95ae94357edfc0, 0xbfe6be181fa907f4,
    0xc0033c757f991fe3, 0xbff84a3f3e77c0f9,
    0x3ff102add34cb2e0, 0xbff512211d90bff8,
    0xbfeea6c983c65ee3, 0xbfeee592533b0f79,
    0xc004ab214073c53f, 0x3ffea7ba983398a2,
    0xbfd19255d6e8ad4e, 0xc0016442986ee450,
    0x3ff3cde9c67f31ee, 0x3fdede36bc4473fb,
    0xc0109847b188c028, 0xc00688a8b684f85f,
    0x400c0537fa417fdf, 0xbffcdba372a2e3b5,
    0xbff199afcfee6898, 0x400f248326d85286,
    0x3fff6e15da275330, 0xbfe61f938a27ba48,
    0x3fff9f4b02d585d7, 0xbfdfb7cab2511133,
    0x40012f4a51ee7cfa, 0x3fe8a4cfdac3f75e,
    0x3fd408b351aba252, 0x3fd99643a12aa42c,
    0xbf9208ab9bfeef20, 0x3ff08ec100fc72ce,
    0x3fb8e0b74585ee84, 0x3feb72c8f8689eb2,
    0x3ffdc6bca8cfd8f2, 0x3ffaa271e1334aed,
    0x401071a1462c7ef7, 0x4019f545f7e746a2,
    0x40082dfce71558b6, 0xbfe88c190b19e04f,
    0xc008565faa0ef876, 0xbff214b40c374ca5,
    0xbfe14061c2d5c231, 0xbff8a178e7e2b7a4,
    0x3fd6d3e972091e9a, 0x4004197594f3c202,
    0x3fa2cbaa0f32c2d0, 0x3fba78a2d261b9e0,
    0x3ffd074b32528648, 0x40002dfce1d1ede0,
    0x3ffd6961418f69da, 0xbff09c44574675b8,
    0x3fff9a54c2b6950a, 0xbfe828993fc3c22b,
    0xbffdf291317c8176, 0xbff802658530fde2,
    0x400b860a3d7f28ae, 0xc0017051fe1f8eac,
    0xbfeb9fb91bfc5a12, 0xbfea90d20fee7ed6,
    0x3ff9a54e20777e92, 0x3fef93a0f4221c9a,
    0xc01668d28b6e2337, 0xc00626fbf967b3b4,
    0xbfe4e2fa57204faf, 0xbfc088066b873d1c,
    0xc00975825dd1a51e, 0xc00a13b42273162b,
    0xbffa6337f04d26dc, 0xbff0e056ff752ad5,
    0x3fd1ef6ec07a3dfc, 0x3ffae40cf2c1cf9c,
    0xbfd575d713b9a8a4, 0x3fe99ee240c7d200,
    0xbfdb9646f334f786, 0x3fccc49e125015de,
    0xbff10e9d5c11d6cd, 0xbfeabc01812364be,
    0x3fd64b720bae40c8, 0x40007a7c4bc13e93,
    0x3ffc4121021b2f63, 0xbfec40eff609afba,
    0xc0076785ec64ae93, 0x3fe0c4ddc397ab1b,
    0x3fefe5fc4b015ef7, 0x3fd51c942e0fc7f6,
    0xbff8651bd0fb57de, 0xbff710bdff38e3e4,
    0x3fbc8a6f11e24540, 0xc009eff3d9768026,
    0x4003d24b1fac2b04, 0x3ff647099fe9645c,
    0xbfc733f81f4e9ad0, 0x3ff5b31fdf5046bf,
    0xbff4a525d6a5bf85, 0x3fe634bf3ed4d8aa,
    0x4001e7b20bfffbd4, 0xbfdfb7ccb801264c,
    0x3fe0ae16dfc2a44a, 0xbff59c610ce1f444,
    0x3fd55deb86d36ef0, 0x3f80b1f3c0912080,
    0xbff302bd88de0af6, 0x3fd5fee30fff6d79,
    0x3fddd20491ea618a, 0xc00b15c6a4d2416c,
    0x3feee388dc2eced5, 0xbff75516f0403ac0,
    0x3ffa4736e9bb7f9a, 0x3ff7b86218ca0f51,
    0x400f077e31ffdda4, 0xbfeb173dc3681862,
    0x4004899959826283, 0xbfeeb47af9851dba,
    0xc003e4a121d13f9e, 0x3ffc542fea9fa450,
    0x3fe602e8a634c672, 0x3ff2341bb995e11d,
    0x3ff95254e51b80ee, 0x3feba12f3dc812ce,
    0x3feb76776602f1b7, 0xbff0519bfaf92074,
    0x3ff0571187a85138, 0x3ff8a9b238b610ca,
    0xbffa57241bd8ed3a, 0xbffb461b952f6a42,
    0xbfccae18873624e6, 0xbfcf237090cdbfe4,
    0xbfed48887e01e664, 0xbfea11a8bbefd060,
    0xbfbf4dad2298cb00, 0x3fed5ed6f54eb6b2,
    0xc008bb3b19cd00c6, 0xbfc98eca8d9ce646,
    0x3fcad47b7fc857d4, 0x3fe30398e2d854ec,
    0xbff8eb5275077d7a, 0x3ff1229b8515c61a,
    0x3fea2569afdc4042, 0x3fefb74bbda3f93a,
    0x3ffc75b14ae1c132, 0x3fbd30ecc1815b40,
    0x40002f7c6846b07c, 0x4001732bd61f28eb,
    0xbfdb900fe6ed0ef8, 0xbfeb3c3d920c7fd4,
    0x3ff3f7950fca3751, 0xbff0784bbe9fbd2e,
    0xc007b5366b0582c0, 0x3fb68f7c42efbeb0,
    0xbfffc37270892a54, 0xbfe57fcb1cadb382,
    0xbffe9934c65c9796, 0xbff6a2f31a8d2f36,
    0x3fe5c96890311558, 0xbfdc464982cee308,
    0x3fcb2fd4f96733bc, 0x3fe0a6ab74b75000,
    0x3ff6d66a706013c0, 0x3fe8fe28de01b71c,
    0xbfd1751089ec0fb4, 0xbfecfb7e99d89506,
    0x3fd2923f2e99a175, 0xbfd1844fbaf33478,
    0x3ff60e8d33047de0, 0x3fc29906bb1fa1dc,
    0xbfd8635472ded20d, 0x3feeaaee7b0385fe,
    0x3ffd1b5ce23cb032, 0xc00744cb9ee30e41,
    0x3ff896e36a8b00d7, 0x3ffeed66188434b3,
    0x3fe85083e03bbd67, 0x3ffe237d11118cf4,
    0x3fbf133b92c400f0, 0xbff78c6ae4886a49,
    0xbfe61b48a60c19b8, 0xbfd24012e56ed307,
    0x4005e99bedf23ae2, 0x3fdc7e84c2ca3a29,
    0xc001d2874c681101, 0x3fe1f2545876b389,
    0x3ff472f6105d836e, 0x3fe67a869745b05d,
    0x4005835f8b6dd78e, 0x3ff9c8d1cbd3536c,
    0x40034f958ebcd66e, 0x3ffe7a1dceba6bc8,
    0x3fe7c1ebf0714085, 0xbfe9f3c91a709b11,
    0x3fe5e977bf554b3c, 0xbff18275990a35fc,
    0xbfd94ec9d1f19c3e, 0x3fc29fbcbff9a30c,
    0xbff49720c473750e, 0x3fdc007d15060e30,
    0xbfe2105785e693e0, 0xbff401bd37fcead0,
    0x3ff7703e718aae30, 0x3fe63a508a50208e,
    0x3fcdb6e3762990fe, 0xbfed4727ec179754,
    0x3ffe11f24f8b2e80, 0x3fcf2217d34d9780,
    0xbffd5d856572d5ec, 0xbfe86319ce8624a0,
    0x3ffd7cceebe10fcc, 0x3ffaace70aabad5c,
    0x4001b31d5ccf4da8, 0xbfed1e48700873ea,
    0xbfef0394f9d43df8, 0xbff4aa42efe87bc7,
    0x3fd178930859c95a, 0xc005a3e574eab181,
    0xbfb2f4597fa3aa80, 0xbfe1aa786f40d260,
    0x4000ac4c5649ffc9, 0xc00be4919e78c425,
    0x3ff0e8691a9c153a, 0xbfe68aa51c613dae,
    0xbff6861a8c40d2c6, 0x4004598055dc32d5,
    0x3ff440f23f53823a, 0x4006bb7a4b105746,
    0xbfb8d989abed5114, 0x3fd3410f36d02956,
    0xbfe7450afa1e9d3a, 0xbfe20c64ddae0252,
    0x4000bef119dd524a, 0x3ff713e398026255,
    0xbfa648ee0af32cf0, 0x3fb1d912188f5438,
    0xbff97708391a391c, 0xbfccb156628a3588,
    0xc0132742544d0cf8, 0xbffcce09b4b0a762,
    0xbfeeb0eda0c7a0ec, 0x3fc0a55aa942ebd0,
    0xc0075842faa11102, 0x3fc1c06e9627b3f0,
    0x3ffaf79057053fbc, 0xbfcf31f35ae8c5f8,
    0x3ff8a49d3ada4210, 0x3ff44a2459983f4e,
    0xbfce3dd3c674805c, 0xc0052dd2c17b6ee6,
    0xbfd816ad18cd6c70, 0x3ffbd20d7eceac6f,
    0xbffb705818c13e82, 0x4003d63d21db240d,
    0xc009e5d378ecf204, 0xbfe75c4437e37cd5,
    0x3ff9445de36e36d0, 0xbffd68cfbd0b0cee,
    0xbffc430dfdcba618, 0xbfe51b5f5fa6fe6a,
    0xbff6be41ced22b34, 0xbfaa6f00dd96b6f8,
    0xbfe5a1e879a08d5c, 0xbfea86ec8d816d12,
    0x3fd3a1357879fe42, 0x40018b7d3aa1c056,
    0xc0030d800e6852bd, 0x400a987adb63305d,
    0xbf96df1b1d4c5790, 0xc002dc6dbfe87082,
    0x3feb43ea47997b82, 0x3ff2b564152a6b0c,
    0x3ff986df01ea2554, 0x3fe621f53f495e48,
    0xbfbee48c92f9d2b0, 0xbfffdc3042e2b1fe,
    0xbff13095590647be, 0x3fdbe3be7d795e02,
    0x3ff895fdaa4d3a43, 0xbfd50ca382775f98,
    0xbfe8ba9f74e27c7e, 0xbfe4582a5f6517f6,
    0xbffdb76d50b1d354, 0x3ff31a43bd9dfeff,
    0xc004e6ae885a1947, 0x3fd465078ad09290,
    0x40044a3048c536c8, 0x4002e3e6263ba1d5,
    0x3fdacb3fa4ba9925, 0xbfee8dbf72aedc1a,
    0x3fe74715e98a931b, 0xbff7aae6e2e44493,
    0x3fcdf089647d3fae, 0xbfe9e4ecd738a090,
    0x3ff0ef530382fcf9, 0xc0100d8a3e60f106,
    0xbfd61795dfeca948, 0xbfe3137ad0e0fa18,
    0x3fc094f7a9a4c334, 0x40068abcd3acb198,
    0xc0076f3fe2378a44, 0x3ff246b256a01de6,
    0x3fefc720198dbe4c, 0xbff1ae4507cd91d6,
    0xbff975dc4e1b0396, 0x3feff6cddc6857f0,
    0x3fcb5cb08c06e230, 0x3ffe0d20ce1bc5e3,
    0xbffe3d452713bffa, 0x3fde6ebf9bd085ba,
    0x3fa34c28d866a1c0, 0x3fe319449d1b225d,
    0x4001291a80e9da3e, 0x4001fab28e3d201e,
    0x4001eb6954aeee75, 0xbff1103f19b978b9,
    0xc003491364edde87, 0xbfea0a6ef2c32a63,
    0x3f34b95c0431d000, 0x4002537afaa7fff0,
    0x3fe38d7c5cef121e, 0xbfee2b1c40bdf9ba,
    0x4001591736bb22f8, 0xbfc3d43869193bb0,
    0x3fd717b13abc9f6e, 0xbfff035e77ace964,
    0xbff12eae388ae127, 0x400d264791484704,
    0x3ff629ff77903bbd, 0x3fedccb5368208ac,
    0x4002aa8ade41028e, 0x3fe31249affbfdf7,
    0xbfe19227e38937a2, 0xbfda2a2671cebd08,
    0x400ac58802ee1c94, 0x3fd5f2d9982c5dc8,
    0xbfee9b4bdb8c62ae, 0xbfd5aa713d290274,
    0xc00566d79b5798f1, 0xbff5bc8b85d3b548,
    0x3febfea7cb996b2e, 0x3ff7d92de8b77c2b,
    0xbff455826a93f66d, 0xbff18397ea8738cf,
    0x3fd7ab34bea5cd10, 0x3fef3fcb8e21a433,
    0x3fb84afb1dc12abb, 0x3fe5dc2cda962834,
    0x3fc9a8a4303ca118, 0xbfe873c5682bfa24,
    0xbfc3c3f73a65e050, 0x3fdacbbf57d8e1c2,
    0x3fb7aaec595fc780, 0x3fd13bba040a87b2,
    0x40020d1f95064a25, 0x3ff75dcfdadd0406,
    0x3ff241e83f31b833, 0x3ff1f97f17d347aa,
    0x3ff7c06c8a1c9a14, 0xbfe8784b66b0a606,
    0x3fb9caf001db2a88, 0x3ffb384581c3796c,
    0x3fe5c3187a63a9ca, 0xbfefaa3dcc524ab8,
    0xbfe26a0b31ab213d, 0xbfffa081d20e1353,
    0xc00277ab8a0a1698, 0x3ffd839a8caf1223,
    0xbfee2291b61bbc51, 0xbff042cc6dd6fdbb,
    0xbfe82f28cf1feb47, 0xbffb35e97dbd8c98,
    0x3feac48d25b23870, 0xbfeabc280b237508,
    0xc0042bac79cf361d, 0xc00310633356604a,
    0xbff8486b4173b048, 0x4000f9dde3943743,
    0xbfe2ab052058c956, 0x3ff82fb2c550ce51,
    0x3fe06ff3fe1e6bcf, 0xc002e5bb3bd72a7b,
    0xbfcb269669ddaa58, 0x3ff5b9cbd7207486,
    0x3ffca8f253aeddb0, 0xbff0e7190003ac3e,
    0x3fd71943d12d0c90, 0x3feb98f82adbd8cf,
    0x3ff91c6ef81a75e0, 0x3fff5b952c7074af,
    0x3ff9ca5b4fd88895, 0xbfeec87f0053a968,
    0xc001804b18a72d2f, 0x3ff75fa5054fff4c,
    0xbfdd9b87bf3c05f5, 0xbfe19a3b8af2a7e2,
    0xbfc0c321e2c327d8, 0xbfe0ee1b725185a7,
    0xbfe09e06a159b406, 0xbfdd37576a4c2bac,
    0xbffa58e4bd771dc6, 0x3fcd5dafc898f75b,
    0x3ffcd5cdaaca5392, 0x3fd530a3e163d31c,
    0x3ff280e904dee594, 0xc00867307ad598f8,
    0xc00a48ac18b57e52, 0x3fda2d11794e1f22,
    0xbfc5d23481bdf6ca, 0xbfebde4e7449bf77,
    0xbfec33a4be8a61d4, 0x400ea91bd8800246,
    0xbffc11da64b7f34a, 0xbff28ee3b7386db8,
    0xc00db5c9264e355c, 0xbff5ff03b1c1c9e4,
    0x3fc47394ad07ea68, 0xc00c0435b32f1bb6,
    0xbff9e0758fd48556, 0x3fdae34a424d5504,
    0xbfe2190402c93b37, 0x3fdd7b5afc9690e8,
    0xbfeaa4545903af44, 0x3fe83944fa82c727,
    0xbfec4099862265b1, 0xbfd6d2b36b004cf0,
    0x3ff26b47a36f717c, 0xbff6ea38c9cc95ee,
    0xbffe0964ad310858, 0xbfee4002f72469e4,
    0x3fcae23a5aa4092a, 0xbf830c0b0df1ad80,
    0xc0033f040ff68b18, 0xbf9b9088b5911280,
    0xbfe4c87f658330bf, 0x400619bc76f55170,
    0xbfce37318a9b6a18, 0x3fe1f3db1779b23c,
    0x3fd8c069a2982b66, 0x3fffcd7b64446978,
    0xbff0ef6be5d018b5, 0xbfec1a7bbdc7758c,
    0x4003ccd81514dedd, 0xbfd0693bceadc862,
    0xbfd452493e4e0fc6, 0xbfc44b6dda644c8a,
    0x3fdc6568bf9574a4, 0xbfdf336b118926a2,
    0xbff34112b5a32554, 0xbfe5e2f5a08ca5e8,
    0x3fe1266d9e6d40e4, 0xc00af83242124906,
    0x3feb0f900dbac1fe, 0xbfec1b3715a6b024,
    0x3fc87748a16d02f2, 0x3fbcde7f94712b40,
    0x3ff931a60c14ca9b, 0x3ff05dde76397545,
    0xbfd618df14d1629e, 0xbff28480ff66d1aa,
    0xc00ff818bda4c57e, 0xc00532e31d8a8896,
    0xbff3d3d8fd1fe2ec, 0x3ff5cd24642f7326,
    0x3fc9e22e409910f0, 0xbff9bc305a76f590,
    0x4004592028f1deb6, 0x3ff066ec1487e1ac,
    0xbfced1989edbe3f8, 0xbfe0c79bb8be3b0b,
    0xbfda6affda243ecc, 0xbffb4944a6ec8221,
    0xbfd371da3279a348, 0x4001afab3eb2c524,
    0x3fed3512cb8b9004, 0x3feb423e58e42a1c,
    0x3ff1599567f98b20, 0x3fe55fcee0e434e5,
    0x3fd07d5de0c1fab2, 0x3ff7adb2bbb12f6b,
    0xbffa0876dcf86919, 0x3fb06e533c39caa2,
    0xbfdedb86a928a048, 0xc008d2310fe0fac4,
    0xbff1ebe1f9b3d2cc, 0xc00b974541a6bbda,
    0x3ff8486ac2db1a6e, 0x3fd84a2409a3efc2,
    0xbfefd2f51fdcefcc, 0x3f9a1098668226c0,
    0x3fd240e60cf0d454, 0x4006fd468b1c8e7b,
    0xbff42c2447b22b9b, 0x3fe72c5d5b24994e,
    0x3ffeb1ecfe4526eb, 0xbff0da91e4ded70c,
    0xbfff74a6595f0aca, 0xbffb6e49e67263ce,
    0xbfe66aca3a6a4ba4, 0xbff54f86671092a3,
    0xbfe8c3b70593529f, 0xbff95ef598918ee3,
    0xbff9eb5cafc998a2, 0x3ffa13c291bc3cbf,
    0xc00a046a00d3e960, 0xbfb8bb12a548dbb0,
    0x3fc5c0f169e126e0, 0x3fe80ee05cc53b9e,
    0x3fd70add92847946, 0x3ff02251e5f69a83,
    0x3fb75696bcd75760, 0x40028c76304b7465,
    0x3fedb1f298eeaca4, 0x4002da13172e28f2,
    0xbff9453aefb63f22, 0xbff063c564048dcf,
    0xbfeb6e7febdba89a, 0x3ff47f79649c9f05,
    0x3ff8b63857ac5f74, 0xc002cd3ae0e26843,
    0x3ff6eeb28666ee76, 0x3ffd7d9526b34031,
    0xbff583b12f9035e4, 0xbfd2147b97714bd5,
    0x3fd53c6156f20064, 0x3ffc621316272d50,
    0x400d8300dba3d6fa, 0x3ff077773476aa40,
    0xbfb3bad323d885f0, 0xc00917f6d67d880e,
    0xbfee0324f25b7090, 0x3fe5609322aa6246,
    0x400735ace0592362, 0x4000946bcfceecc2,
    0x3ffa51824549a8d1, 0x3ffbcf6e3b3bfceb,
    0x4003101adc66e2c4, 0xbff5870915d7a354,
    0xbff425b332e0dd72, 0xbfbb8c6a7e670b90,
    0xbff7ffbe4f39ff3a, 0xc0056bcce23502ac,
    0xc00195084e52eb3f, 0xc006e355416fbb46,
    0x40013769e9056832, 0x400575d5f32dacfc,
    0xc00419cc4091c842, 0x3fb78661638e0488,
    0x3fb4516d3ee0e410, 0x40022e1ad928bc1d,
    0x3ff4f1b1c9ff0e56, 0x3fcc5ccd314dc28a,
    0x3feaf4635016a2bc, 0x3ff6541953ddbec4,
    0x3ff3db27e6a7ed53, 0xc0045bf87c333cab,
    0xbfd2f562b6394bf4, 0xbff087dd16594019,
    0x40093a5d07a02248, 0x3fe5e8e7533489b0,
    0xbfa37285e1aa7840, 0xbfefcb5180be55c4,
    0xbfe109e82fb813f5, 0x3fba87a2172147c8,
    0x3fd81dc1ac8e21fc, 0xbfddcaef46ff1e44,
    0x400140ae14ae8755, 0x3fd7966ec021d6f5,
    0x3fef4f08b7cc814d, 0x400ac04901042c34,
    0xbfda9e95d0a90a14, 0xbfd5365e65435178,
    0x3fe230f5cda14986, 0x3ffb5da6ac7bb3d6,
    0xbfcc9c98e10cf378, 0x3ff308ad86b5b89e,
    0x400689bef155f654, 0xbfddd3406f9a2798,
    0xbff158f99f477eab, 0x3fe86048c22d12f3,
    0xbfe2de1bf104b67c, 0xbfdc5f2d0b6fbd10,
    0x3ff5720334bf8b41, 0x3fe18c4ec4a6b96e,
    0x3fd66eee7e0f474a, 0xc00a65aee0b7aa6c,
    0x3ff760b41592c859, 0x3ffd4e14991df00c,
    0xbf92c33092f8aec0, 0x3ff2f6af750a5683,
    0x4015f1015c246e87, 0x400037984a59c445,
    0x3ffd005fc5bbafab, 0x4008deea67c76489,
    0xbffff3b1d6c396b0, 0x40107ca9c104636e,
    0xbff876e69e547295, 0x3fe188e50b54af61,
    0x3f946546f4509280, 0xbfdf0a4df98cb458,
    0x3fffbf4609e2d3e2, 0x3feaf884a837954e,
    0xbfeac0b8ae3ac300, 0xbff0fa0ec7d32850,
    0xc0037494b9f10e18, 0x3fd0469de6803334,
    0x3fbc563a2a2c6ed4, 0xc004c4a417737c69,
    0xbfe3ef0327d0c150, 0x3ff2a2f28b7e5414,
    0x4002c0e93203705a, 0xbffd84b0b4eebbb4,
    0x3fe3f725b1c380f4, 0x3fe5c3fa8174e282,
    0xbfee211693d3da0b, 0xbffafb56aa85b42a,
    0xc0090e765457fc62, 0x3fe4cad989e72855,
    0x3fe098b78628efe7, 0xbfe672fcad42cc6a,
    0x40036ea92dec4d5b, 0x3ff244fc3abdbd61,
    0xc0042af62f14e01a, 0xbff80b9c53c3c570,
    0x400a97672e2eb0ae, 0xbfd874eeb2ad5ae0,
    0xbfeae02ee8987274, 0x3fd21580eaa6e6cc,
    0x3fe209c3bcbfcf18, 0x3fff9b1f50c25817,
    0x3ffd51afe5fa8d28, 0x3ffb8d9db76947dd,
    0x3fe7339d081b9e72, 0x40027c7f0590ddb4,
    0x400547d59adaa62a, 0x4012b189ed1d5815,
    0xbfe00fc3553f9ce2, 0xbfe6979c87b4e3c8,
    0x3fba475918e9ea20, 0x3feb705b5e08392f,
    0x3fba47848004df78, 0xbfe1499416ff8d3a,
    0xbff22b9e8d5d2b49, 0x3ff7892e60962eb3,
    0xbfffc9fce2e347c6, 0xbff371e91aee53f9,
    0xbfb78d7ca3c89420, 0x3ffad696cc05a762,
    0x3fd664f12ae4c26c, 0xbff00498c893ec9b,
    0x3fbc4a1862ab9e20, 0x3fe1a070799f9143,
    0x3fe74199a65ba5c9, 0x401099b9a3103bce,
    0x3f61be77e420fd00, 0x3fd95ffaed6a3b6c,
    0xbfe14e55b0de2505, 0x3fd4e2efb6f8c61e,
    0x3fc1c08be6afadcc, 0x3ff9220dcc88b1bf,
    0xbff68c7867971724, 0x3fcec12c25ee65e0,
    0xbfeb7c00e5019200, 0x3feb755c51779e5a,
    0x4009b42abe7100f4, 0x3feea3f84ab2e033,
    0xbfec9b5f10868846, 0x40010480a46eb19b,
    0x3fdcb7d9128a3588, 0x3feaeb5075715526,
    0xbfe29901aa5031d3, 0x40080bb9567676b6,
    0x3fe5932b351a25af, 0xbff29116872b1140,
    0xbfecd2996ff7dbc4, 0xbfe930e3180e2e62,
    0xc00c0fe36bcf4518, 0x3ff00e917f0518f6,
    0xbfed1ccc1e269f72, 0xbffa37605cca6962,
    0xbfe5c87d477a818a, 0x3fe8e9a447aaebfa,
    0x3ff40a5f1b4155a0, 0x40036aa7bb25b500,
    0xbfe5ec7daa6a2c7f, 0x4002ca2408ca6f08,
    0xbffbb1455a5f200c, 0x3fc80a7e44175600,
    0x3ffd9289d5309827, 0x3ff9820801e21b45,
    0xbfb7c0ca4b1df710, 0xc006b9e4b9cd78a3,
    0x3febb4c0939e4d50, 0xbff2a51e6ad0becc,
    0xbff1e2efdcea9b8e, 0x3fd36edc6403d27c,
    0xc00f300446165fa8, 0x40018bb5fff5d0bc,
    0x3febce9b4a9ee22b, 0x3ff87f7f8e8b987a,
    0xbff76e5ac9f566d8, 0x3fa6660dd800c2b0,
    0x3fb83b1f9461c560, 0x3fd20c716b1ea206,
    0x3f908653202e4510, 0xc0103fd68be2329d,
    0x4003456e603e67a6, 0xc004ea6b08c3393c,
    0xc006c71a415607c2, 0xbffe9dcf8bbf078e,
    0xbfd3eff49d56aed8, 0x3ff2cb1b50da541b,
    0xbfb050c5aeb315ac, 0x3fe5dfe40879505a,
    0x40027a8cdf36e023, 0x400a665067e2d089,
    0xbff8629753565cdc, 0xc00dba1fcd91b0d9,
    0xbff35b60c6f1289f, 0x3fee65f4205c3b8b,
    0xbfd3b2454dda9fd8, 0x400418253b572dbc,
    0xbff5903b26ed9028, 0xbffe68f61299feea,
    0x3ff44102d6f5e242, 0xbfecb07db6973c8e,
    0xbff6ff29db720afb, 0xc007e10b5984df62,
    0x3fd1c3b6a2a55750, 0x3fefea48fb1ef772,
    0xbfdba865806f7e3a, 0xc003ff2d461de6ef,
    0x3ff53dd480f2b8b7, 0xbff79387025c3452,
    0x3ff4997069df1432, 0xbff359dd48ac5c2a,
    0x3fee47663c8c757d, 0x3fc1863b2ef4ec0c,
    0xbff15c68e26f4a2e, 0x3ff21d3aaccb5621,
    0x3fc6b2be474b4e58, 0xc00a526cce3d4dd8,
    0x4005d9ecae2b7592, 0x400350db0db29791,
    0x3fe6fe6a8771781a, 0x4002a78954d70131,
    0x3ff113b3b47a9df0, 0x3fd4f0e2217ef3b6,
    0xbfdace365656365c, 0xbfcc346c039433b0,
    0xbfda5b9c25662dec, 0x3ff4f4cdda60bb19,
    0xbfd0d0013abd416e, 0x3fd4768545a1d17c,
    0x4002b67562d76354, 0x3fe2a628fa91aac3,
    0x4002a27c133710ee, 0x3ff80ebd3e6b52fd,
    0x3fdc43ae2111da48, 0xbff0a1c53800d712,
    0xbfea78f2f7c71e79, 0x3fd65ddac46b9688,
    0xbfc3f72bad7dd9d0, 0x3fe90b3d2a61b51b,
    0x3fdb3e557d0e0203, 0x3fec84090a81f614,
    0x3ff1b67018624798, 0x3ffda25c8c063354,
    0xc008a9f8bf846f2a, 0xbff1cf4bfb33e514,
    0xc001ea20d43ad4a6, 0x3fe28a2b61bfdd3d,
    0x3fda61980ae7f8cc, 0xbfdddcc96a676238,
    0xbff04f5c2f632572, 0x3ffb470e640635b0,
    0xbff0aaeac2b628ce, 0xbff20b2689455104,
    0xbfbba431bd627ca0, 0xbfdc6febae30de0b,
    0x4009b3c12f5b99aa, 0x3f9100b0fbc090a0,
    0x400331c174cc8b66, 0x3ff993ca250fa39a,
    0x3ffeba1dc5dfc4ea, 0x3fd566a47c584ae0,
    0xbfe4783740ea950a, 0xbfd827c076a26f7e,
    0xbffc860a235b1446, 0x40023a7fd220d4ab,
    0xc0040ecfa6b87e04, 0x3ff21d50902a1892,
    0x3fff8c1f943083ca, 0x3fbd36e8cfeec430,
    0xbffb6acfbd93a97d, 0x3fef0f21b87c9420,
    0x3f843e90e74a7580, 0xc000494b01a5adae,
    0xc00233b80b51939a, 0x3ff7233ce1b218d0,
    0x3fef0de5f24b97d2, 0x3fa631e6febe28a0,
    0x400969a92feb8db0, 0xbffe3bb6b4097dc2,
    0xc000d3bba2c39d78, 0xbfbef712eb004fb0,
    0xbfe702054419d1c4, 0xc006b70103b5f100,
    0x40031bea8a3769c4, 0x4003703b46fdb21a,
    0x400d8aacacf44f51, 0xbff49bd3e5084067,
    0x3fe2ddf8e2d11dfc, 0x3fdc0fb22f29255e,
    0xbfc9f59253eb64ee, 0xc00530b6cf468c3c,
    0xc0092479a5bf508a, 0xbff235b2a01de254,
    0xbfe30fbf9492e458, 0xbff722842be93791,
    0xbff731d7d4ebf528, 0x4008174d3cd1c62d,
    0x3fffdc80b060d2ad, 0x3fe711637343f659,
    0x3fe153eba0037a83, 0x400018babeaf3b98,
    0xbf9947c909219460, 0x3ff1d970b74841a9,
    0xbff01c6452b4ab4b, 0x3ff2c69c0d0dc6ca,
    0xc00bac26f9b09373, 0xbfeb106b10b48458,
    0xbfe26bf9a51014c7, 0xbffc827dff0f98f5,
    0xc00ab3913fdf25c0, 0x3ffbbd0ea619fa40,
    0x3fe4b8ff69709d17, 0xbfe07d8e36b08b2a,
    0xbfebefbcb27edef7, 0xbff060e0589ece56,
    0xc001b508471c8e1b, 0xbfe4211d0aaaf5e2,
    0x3ff4ac400f891582, 0xbfeda80adf9a6b6e,
    0xbfe795a45cd5c865, 0x3ff0cb255100cf59,
    0x3fb2e79f8b416474, 0xbfc639b56081fcc0,
    0x3ff6eb6fa18fa032, 0xbff034fbd79aa1ae,
    0xc003682ec95ab80a, 0xbff5faed902aa318,
    0x3fe1ca541b563195, 0x3ff1f8552e1a4828,
    0x3fd13f86e2335f91, 0x3ff6ea6f84b7075e,
    0xbffb53c107d2cb1e, 0xbfc46e7c9dc369f4,
    0x4001954b287d5046, 0x3ffae2044478dda0,
    0x3fc3d85168396588, 0xc00acfabf7c9ee2a,
    0x3ff54f6effd3daf7, 0xbfebbee0d3eb63da,
    0xbf7e879a70ef5d80, 0x3fc6251e638ee5f8,
    0xbfe25b6dd1492a05, 0xbfeedef18c60d4a6,
    0x40005d6822bfa657, 0xbff67c698b000033,
    0x3ffd18119dd70564, 0x3ff004759c52dfe9,
    0x40049466ba5af7a1, 0x3ff9a7a8a0c29ae6,
    0xbff46fd1435f7364, 0xbffbe1a273ed00b5,
    0x3fe5cc7c56586e06, 0xbfa2797dbf752bf8,
    0xbfe3f74ac4931a14, 0xbfec4d6fb55a23e6,
    0x4005bd382400da63, 0x3fc95055cf47b514,
    0x40034742650cfb00, 0x3ff164d74a0e27c6,
    0x3fc050e3f1b86ce8, 0x3fdda5fcc1292640,
    0x3fe781cd630e05f2, 0xbfe177cac6fd0bed,
    0xc010763370ad3f4a, 0x3ffcea7b6f8f39c6,
    0x3fdc22520720d76e, 0x3ffea91ee96133f9,
    0x3fd4334f91ce855e, 0x3fe8c24d1ad44bcf,
    0x3fead39c29e953f7, 0x3feddb4debb5b2ca,
    0xbffb93600343472e, 0xbff40df009904518,
    0x3ff53daa58d37ad7, 0x3ff954425b740cd0,
    0x3ff66be9988e922e, 0xbfe7b94e9b8ebd8a,
    0xbfe6e19d8fbc4b9b, 0x3ff5a7fc379df159,
    0x3fe74beddb611e46, 0xbfde54e869898890,
    0xbff66c199c3b7cb8, 0xbfe363f4d545c800,
    0xc00c5eb65e8ebf9e, 0x3fe3ee3fe376e95c,
    0xc00084360cdf050a, 0xbfafb69dca4d7940,
    0x3fef878c1e341d62, 0x3fdbfec797e61fa6,
    0x3feb84b4e76e3dc1, 0xc002e2d1d5fd278e,
    0xbfeaf71877737e25, 0x40003558a4cb8af9,
    0x40105d063d16ba5b, 0xbff0a4be08fb0377,
    0x3ff80f86f91dd7e9, 0x3ff02c97215edcc8,
    0x3fea6a46b6a3ce3f, 0xbfda8ab325d3de2a,
    0x4001044b33c5a63c, 0x3fdb15a8b3bc5164,
    0x3ffacad36ff6fcf7, 0x3ffd36db5c6feb18,
    0x4007b37542b3f34a, 0x3fbcd19e45923540,
    0x3ff2d4a8ee54ae54, 0xbffaf7003b030a72,
    0xc0004c2a86e99ce9, 0xbfd928190f167a2a,
    0x400bd50f729e53b6, 0x3fd7f7c3a6d22eb4,
    0x3fe04d580b423078, 0xbfec698cea6dfe5f,
    0x3ff355e86e4539ba, 0xbff5aa45e3d8cc29,
    0xc004975ca6622099, 0x3ff02df2e8571c8a,
    0xbfe95b0b81b9afe2, 0x4006a279323d5f20,
    0x3fece9ed0bec0db4, 0x3fd878736351edbc,
    0xbfeb2f468fa90476, 0x3fd1acd60270528a,
    0x4002991bf9eeff78, 0xbff403b3bcd31323,
    0x3fe8e2a8543d538e, 0xbfdb38bd775bd4e6,
    0x3fca480d5ff7f0c0, 0xbffa402a7c520537,
    0xbf81074a90229340, 0x40013cac9b9aef94,
    0x3fd2e850f0a08396, 0xbff27bdcf2fdb238,
    0xc00e6817d0c5af70, 0xbfe85ab0df21022b,
    0x3fffe4acb0cc00a6, 0xbff87502321fe77f,
    0xbff7aa74fbb0eab6, 0xbffd11d8807f057b,
    0xbfe4077ae1cb4abc, 0x3feb05fd596e1b22,
    0x4007bf56668f7b0c, 0x3febce2514e84594,
    0x4005100cced39674, 0x4000929aed146cf8,
    0xbff65e02fab69707, 0xbfc97c83d27efc58,
    0xbfc597029645bbf0, 0x3ff5415682c73ef1,
    0x3fb1ca5384141c04, 0xbfee96f8a8e2404e,
    0xbff0f430e9fce5d3, 0x40036821de413026,
    0xbfece043295f964a, 0xbfeec7abdf4ca9e7,
    0x3ff73b3ed5a81b1e, 0x3ff2c72a4726e53d,
    0xbfc53cd3f65a47d8, 0xc008eac6ba095787,
    0xbffe61460f9caccf, 0x400001e14e075c6b,
    0xbfe7b0d365ac2a96, 0x3fe8c1ffabafd1fe,
    0x3ffd88557e43525c, 0x3fd0e8f193c29b70,
    0x3ff97972d9b5f654, 0x3fd34ddf2cd742c4,
    0xc00e2378d764c264, 0xbff2b1a9661d057e,
    0x3fec63c9669f0f9c, 0xbfe5110b9b9caef1,
    0xbfc0ade45f6d59be, 0xbfe7338a1f1b6537,
    0x3fd5417bd390ef0f, 0xbff1878b7333516b,
    0xbffed7159ba8912c, 0x3fe1f4ab5254c806,
    0x3ff9e060a77b3006, 0xbff83ef32b04b9c6,
    0xbfc0c6a47836e3dc, 0xbfe3b4372357f3ce,
    0xbfd3274a2f72f274, 0x3ffb238ce5937ff9,
    0x40073e8fcc88903f, 0x4003d9ba1e6608ba,
    0xbfcccd5645de57c8, 0x400558dc51c08a54,
    0xc005de0197d9264c, 0x3ff9eb2d181345ab,
    0x3feb767957afd5e7, 0x3fe4e93a08c9e421,
    0x3fd7ff81cbc4c0c2, 0xbff1c6395527ae3e,
    0xbff3dfeed4433390, 0x4008361f215e0ab0,
    0x3fe0ae054466d25a, 0x3ffb0443c8986e27,
    0x4002fb75f9ae62a6, 0xbffd52f3e27f8103,
    0x3fef4ad0e7d6488c, 0xbffce885a23d86a1,
    0x3ff8926685459150, 0x3fd09f92a28f14cc,
    0xbffac5bfa88f1422, 0x3ff906d94b24bebe,
    0xbff6656846d7c133, 0xbfe60540ca584b34,
    0xbff7b0774032aeda, 0xbff0434386456e9b,
    0xbffea09149c4f030, 0xbfb5c58b75a9c970,
    0xbff28911550ce196, 0xbfe89dc38c2c56e5,
    0xbffdf43e4f983648, 0x3ffbe129c6a87193,
    0x3fdfecda51f42e72, 0x4001fd1038c05054,
    0xbffb08e705ceefa1, 0x3fcf10c2700ee942,
    0xbffeab04feb2df50, 0xbffc9d6a721b343c,
    0x3fcf6a646be35c3a, 0x3ffbd9991886b1f8,
    0xc000bb1cdeaa796e, 0x3ff803322c43b0b2,
    0x3fe8816167d5a9a0, 0xbfc9481014acad98,
    0xbfee2ed8011ef50a, 0xbfe00a5b8673ce3a,
    0x3fea185e08dd345b, 0x400545ad137c22ca,
    0xbff083c0b355f9a3, 0x3fbfc9ea57013ba0,
    0xc0025655c7a1e357, 0x3fe1b617bd5377e2,
    0x3ff1b80fefdd4e48, 0x400257e27bba8e16,
    0xbffd7cd63b4c2004, 0xc003860d86ff6f7c,
    0xbfe4b8af995ab78e, 0xbfcd4e76fad8f4f0,
    0xbff1b11211b0905f, 0x40045ad9e2ca796a,
    0xbfd21fd5b87e71de, 0x40013e10380048ee,
    0xc00aa94cb0f4696c, 0x3fa69c1a8b0671e0,
    0xc000914e81b11df3, 0x3feb0d9ddec666bf,
    0x4000283afcf53f9e, 0xbfec4d80eb673e1f,
    0x3fe7080a30cb6b69, 0xbfe15507a1f91720,
    0xbfd88afcffb2616c, 0xbfeca29c546e10e4,
    0x3ff7d561c27d7326, 0x3fd7545721606bce,
    0xbff3d811fcb04a49, 0xbff36c340fbeba64,
    0xbff1a1e28740ecd0, 0x3fcbd0c5655db7b4,
    0xbfe9f9aa2de8b438, 0xc0000c2881f83cf4,
    0xbff9bedbb9c1d0dc, 0xbfede30030a6c6c2,
    0x40064d56197722e5, 0xbfd573b677681a6b,
    0x3ffbbbf7aa4bac4c, 0xc003a6a3f92adcaf,
    0xbfd6b06c286037be, 0x400e24403b10f645,
    0x3fe093caacc08688, 0x3fe80fd779fcc57f,
    0x4001ec800ee668b4, 0xbff207cb3fee4747,
    0x3f9b06007eb3c000, 0x3feae5b5ab5c24a4,
    0xbfd19d7fb36d439c, 0x3ffd59ee6c5682de,
    0x3fffe1e2f222cefc, 0xbff314d7186baf20,
    0x3fe9c4f2a8184a2c, 0x3ff2cbff34faf973,
    0x3fe9c368274b5af2, 0x400089b67358a2b8,
    0xbffff3fe04f0193e, 0x3fdee72f3bc989ae,
    0x3ffac2793dc27000, 0xbff13b3c8f76425d,
    0xbfdfad715674f71e, 0xbfef3acfd47659ce,
    0xbfd7e16ad53a4a59, 0x3febf3fcbc71ffcd,
    0xc001d0ef1a5db66e, 0x400090ebd7b1122f,
    0xbfe068308d187b1c, 0xc009abea22ae26c5,
    0x3ff9877c2e838339, 0xbfb562a1cec25bcc,
    0xbfd0d0582127f8ea, 0x3ffed3643db20d8a,
    0xbfda3e3e84f9d09d, 0x3ffbacc0adf0da26,
    0x3fdc25727e75bef8, 0xc009fe3c70745886,
    0x3fd5f902f57bd726, 0xbfd661f548d00693,
    0x3febae3625fe051c, 0xbffdb7ef3c4d9c1e,
    0xbfd3488ca25ca274, 0x3fad305fdad36780,
    0x3fd167a7834a1e02, 0xbffa527a6ceaa981,
    0x3fe0616d3ae2abde, 0xc00544a3682959b8,
    0x3fe94746953c2860, 0x3fc799ba90366b34,
    0x3fe279db8ae62a12, 0xbfdf45b61d732f88,
    0xbfeebaedc23175e6, 0x3fd16edc2d825eb9,
    0x3feec1435d1ccede, 0xbfeb058686e255d8,
    0xbfe8507df5fda8f4, 0xbff6f6e5ba7b8f82,
    0xc0086015553e5306, 0x3fd75e7638aefbc6,
    0xbfe5d2e840137cbd, 0xbff3f2363813d668,
    0x3fb2628bee1ff3e0, 0xbf8fef05abef8000,
    0xbfc27a54ce858000, 0x3ff9d39f8fa08c6c,
    0x400b04a1a2a9bf22, 0xc0046fb931796cec,
    0xbff7b5e93c060206, 0xbffb9ce70f9d8cf1,
    0x3ff77a94900b82ea, 0x3fe5ffc1c28e64d5,
    0x3ff00ab019a64a14, 0x3fd2b20471b4057e,
    0xbff82bb6f5a6d08e, 0x3fe39ceb62749a2e,
    0xbff992d392bc9244, 0xc002c637cb9d43ee,
    0xbff26da928d552f3, 0x401525b7fa15ee1c,
    0x3ff5500aa013e5ad, 0xbffd15382d0fc6cf,
    0x3fec983ba7d7aaaf, 0x3fb7b987dfd98a90,
    0x4004395e53cdfd1a, 0xbffb29f43e2c6cb5,
    0xbfb7b8740b831458, 0xbfff8c37509bde5e,
    0xbfed7eaefec038c5, 0xc00fd04f56247ac0,
    0xbfda0f7f211449c8, 0xbff2b6160db079e7,
    0x3fe2f34dd8ad3eef, 0x40866a81da3e8fc8,
    0xc0091de01dfa33a3, 0xbff7bb306b81f158,
    0x3fd11714176cf28c, 0x4006fc8ef2ced11e,
    0x3fe089dc8711dc5a, 0x40015f40a768db3b,
    0x3ffa7f9df13254e6, 0x3ff0b9597cb4b389,
    0xbfe0a32f61d05678, 0x3ff743f92e10783e,
    0xbfe553d649101980, 0x40021eb4f21073f6,
    0x3fb2e8dd85355930, 0xc00670e98ac571f4,
    0x3fc75c50169e890c, 0xc00f803188217e48,
    0x3ffa871140f356bc, 0xbffb9faa02887ecb,
    0xbfd6f7a6d86244d8, 0xbff127e6e241e156,
    0xbff2424f80073ade, 0xbff764e284ab4321,
    0xbfd03c9de1801ef0, 0xbfe207199d0e2b84,
    0x40040176b560b0d0, 0x3fed8314d7f1cf43,
    0x3fd4618f07b3113b, 0x400892136f2d6f29,
    0xbfb9ca58790b7460, 0xbfdd4980b8c84818,
    0xbfe27bc568fc3d82, 0x3fb0677f592337e8,
    0x3ff2e6a5ba650190, 0x3ff170332e37c102,
    0x3fed9c1133384073, 0xbf900d2d78b074a0,
    0x3ff20146c873c1f7, 0x3ff5d5c84db04667,
    0x3ffc4e9c27e8151c, 0x3fe5b5ea1c17e387,
    0x4000453d29ca98ca, 0x3ff90903ad98b73e,
    0x3ffae7639295b34b, 0xbff6efc874fc2611,
    0x3fe521386d455864, 0x3ff1551e66d70e5c,
    0x3ff459ede4cb8335, 0x3fd54186141f1ee4,
    0x3fd17d3cfb9476be, 0xc0053dec56bf0f95,
    0xbff0831a5a71876e, 0xbff3a774eea6a5ad,
    0xc000b36e51a609d4, 0xbff543c541d50453,
    0xbffce98795748813, 0x3ff82dbb991bdb4c,
    0xbff01b4d4b88a35b, 0xbfd75c4f633aadba,
    0x3febce138bd9749c, 0x3fff25c99cee7719,
    0xbffa6fa6af9d3670, 0x3ff68fffde5cc63a,
    0xc00336081c148b46, 0xbff31a0f1107a886,
    0xbfe722da2d614ae3, 0xc004a0d956ed2d68,
    0xbffa636a2f503902, 0x3fcebaa25a8e6f28,
    0x3fd366e0e9322d8e, 0x3fd89ba21cfc7760,
    0x3ff0747bdac1c49d, 0xbff56a5dd608dcc6,
    0x3ff60b2a8d362b75, 0xbfe93e27c4f617ef,
    0xbfecb031c42755cf, 0x3fa38c29bb373a60,
    0x3fe7c279bc71e442, 0xbff7b7f1cc5932d5,
    0x3fe370ea43073a25, 0xbfd78b15810258cf,
    0x3fea9ab8b8e4be3a, 0x3fcb2127411ada70,
    0x4001d1dace816017, 0x40052220ec90c112,
    0xc004e473f3ebce3e, 0x3ff17875e95dd057,
    0x400428bac1a5e548, 0xbfffabedcde96cc0,
    0xc0026af7a30c0802, 0x3fdaab594c5be3d4,
    0x3ffd570df0f831e6, 0xbfec457cd79b405b,
    0xbfa465072c03d100, 0xbfe5f0bb44b3a89e,
    0xbfcfdeb6c152f418, 0xbfe9d456cce11d51,
    0xbfd5f38b454be2a2, 0x3ffea65f158ba85f,
    0x400208c76072a55a, 0xbffd8be1c4ce78a0,
    0x3fe98e4c6a320dba, 0x3feab6533cd12476,
    0x400444b1f395d39c, 0x3ffc59d73f61cb2c,
    0xc00b52b934c697ea, 0xbfb252f63e397130,
    0xc003d89a5006a5f1, 0xbfe162909e642d88,
    0xbffbd9bd032d41ba, 0xbff90ab061e01463,
    0x3feb60b8f2a4d0e0, 0xc0030c45c4bcac47,
    0x3fda2be673db6b3e, 0xbff74dc0e668a770,
    0x40035e03efe4ce50, 0xc0079a486f558322,
    0x3fff2de41bf864ac, 0x4001ec35341be59a,
    0xbfef4ccb10b82620, 0xbffb3b2b04febb94,
    0x4000cead697c6568, 0x3ff79e4ef4bd012e,
    0x3f826ee76dfe5a80, 0x3fb856f3feb3ad84,
    0xbffdf82b2c3aebde, 0x3ff4ca38a76064be,
    0xbff7093122f3077c, 0xbfe7b16ac5ff2bd0,
    0xbfd360f5bd89ac2c, 0x3ffea730383a2b2a,
    0xbff54f9bdf13247d, 0x3ff483bcdae295bc,
    0xbfd100ee4b3ff238, 0x3ffac54d7547fa29,
    0xbfc03a4095ccb27e, 0xbff121701af8f5b4,
    0xbffce258cde3deb2, 0x4004613a57c98334,
    0x3fd04914e47bf72c, 0xc0024b92c7d704d5,
    0xbfd95d229c69ca25, 0x3fda5edbd048f6ed,
    0xbff6e14040b45f0e, 0x4009fd166d1fd9ca,
    0xbfe4e8368521081c, 0xbff77b7c15cf4160,
    0xbfeb0492dd9964b2, 0x3ff72f5e3e7a1d5c,
    0x3fd9805c0d9d0ab4, 0x3fdc4a10541a49f5,
    0xbff597d0213794af, 0x3fe291ab583585c4,
    0xbfbdabd762c9a64c, 0x3fe07dad491fd8b2,
    0xbfed1b338bd53dd7, 0x3ff04de2cf877274,
    0x3fee99404e98ad78, 0xbfce44c74a7cc6f8,
    0x3fec598a9f1313d6, 0xbfe7e97eac852a8a,
    0x3ff9f73c3f9a9932, 0x3fe96a05941b3622,
    0xbfc9734bce639a4e, 0x3ff1a2b71fb772b3,
    0xbfe01be5e70d4b7a, 0xbfe3ebb884f5ffae,
    0x40014ddd68ffa4b6, 0xbfe511f7b35a59c4,
    0xc006fb4c9a1c1314, 0x3fe036fa5c65e4e9,
    0x3ff0d612582ad86b, 0x3fe3b769ed7abb41,
    0x3ff299898ff40dd8, 0xc0022f7751443890,
    0x3ff511cfa3d0bedc, 0xc00d463837e1b8ce,
    0x3fed0e3b5e386018, 0x400496faf7acbca1,
    0xc004beb993d728aa, 0xc011808f11ab8e44,
    0x4002cdf6dde75c90, 0xbfdd48adec68cfc4,
    0xbfbee93de0151a80, 0x3ffa6622417c71ba,
    0x3fcffc860dee568d, 0x3fe7637e8a80161d,
    0x3fdb1204bab79b9d, 0x3f9dd5efb0833128,
    0x400db3c5fbf388ee, 0x3fef87206963672a,
    0x3ff831c31abac650, 0xbfbf789c78e769a0,
    0xbfe1767fc2ac8d5d, 0xbfedecba104f2434,
    0xc0049cb1a315620a, 0xc0000c4b495c4553,
    0x3fb8e0428cd23df0, 0xbff0e0cb9b6fdc2b,
    0xc00496aa4b318e22, 0xbfebbf13f9e52d2d,
    0x3fe5e25b3318c97f, 0xbff0ae49b30fa288,
    0x3fea559f124898c2, 0x4000eaa933e55626,
    0xbfe59aa8aebc37c2, 0x3ff20cc735a0ed0e,
    0xbfd802a4ece0f850, 0x3fe9a3876369090e,
    0xbfd7b4d7e8d3b92c, 0xbfba2ecbe7bf6fec,
    0xbff7aa9873a74e3b, 0x40075e1625ebad9e,
    0x3fee4434b64e0758, 0xbff19589f5a9e03a,
    0xbff02958918d3a6c, 0xbfe3c47a88482beb,
    0xbfef4b01e040b3ae, 0x3fa0f96a80a41418,
    0xbfea1e00ef21e857, 0x3ffbb58d00088c79,
    0xc004fbc6e749d30b, 0x3ff0f43e722753d2,
    0x3fd6a35574a1b7ec, 0xbfe779fa6a9da790,
    0xbff866a7900c46d8, 0x400a8891ca8b701a,
    0xc0073a20628f50de, 0x3ff7a1c6c948cf0e,
    0xbff32544d5d2f8c7, 0xc00c08fa8a98b7f4,
    0xbff9608f40cb4d80, 0x3ff4b3cdaa63eb1a,
    0xbfffc441a94ea13a, 0xbff32944c3dd7664,
    0x3fe0e15ec09322a2, 0x400b3f87dd5640d4,
    0xbfeb67b7db6cd4bf, 0x3ffd429a2aa808c4,
    0x4002c8934acae5a9, 0xc003680d671efa66,
    0x3ff45066803a9dc0, 0x3fd3b8af3b3c4c8c,
    0xbfe59a050170531a, 0x3fd8d24c4967e4ae,
    0x3fdf0cf209c00a98, 0xbff25f6129e7a2a5,
    0x3f63a73eb345b100, 0x3feba91f994a614c,
    0x3fff1eb45cd9848e, 0x3fd6942e7e47c456,
    0xbffe1f090bce66ec, 0xbfe4b2dcacf7643f,
    0x3ffd91adfd596bf6, 0xbff0e0ee4262da1b,
    0x3fb0df68cff93610, 0xbfe547cfbc64e892,
    0xbfee4d0911afdf5a, 0x3fef9fba5186f673,
    0x3ff92b2cbbba8a09, 0x3fe2d6949296dff0,
    0xbfdb21b6d9cf78a8, 0xbfe139b525195aa8,
    0x3ff5aa35bbdae038, 0x40097ae2dba0cbee,
    0x3fe3cb4da5052ae9, 0x4002ddf8bbda165d,
    0x400419536a4ae360, 0x3fa19927e7d4ac40,
    0x3fd09c7597b5b11a, 0x3fe077742ad1f8ec,
    0x4005368eb1ef8663, 0xc006938e3d88aa45,
    0xbff733467cc122da, 0x40015fec12bdcecc,
    0xbff32f4ccd31095b, 0xbff98db7de865fb8,
    0xbfb7075c09c7a878, 0x4009f07f8d3406f6,
    0x3fd0e8e188b5878a, 0x3fbd599818e8490c,
    0xbff7545a44e26baa, 0x3fd5b944b225d460,
    0x3fe77bfff5a5cf89, 0x4000f207df0d133b,
    0xbfe8ad26edf41aa1, 0xbfd5658bc4609b98,
    0xbfec1bb85f0d131b, 0x3ff3a01e2d77bc38,
    0xbff19a96618a0fd8, 0xbfcfcc9ca0255c08,
    0xbff1aaa9cb56e30c, 0xbfed3496658c4918,
    0x40013924e8938342, 0xbfe5052afd74c1c2,
    0x3ff7131220ae26c3, 0x3fbf192c7be2db28,
    0xbfff57503fd447c0, 0x3fc68d1adcafa829,
    0x3ff072a6b4c967ec, 0x4005a21bcb6ba7f0,
    0xbfc9581bb3633dc2, 0x3fee9a60dc8c16fc,
    0x3fc5f4749f54df20, 0xbff2e174265ecb1e,
    0x3ffb26ad6750829f, 0xbfe13342a3e7b2c2,
    0xc0044fc1b3e04840, 0x4010138617b9c570,
    0xc00810ec9a799551, 0x4011e0a83f838b98,
    0x3ff4bacb6f2dfd56, 0x3ff2374945271d66,
    0xbfda76b243d55450, 0xbfe60a84f9c90678,
    0xbfe50264185a0863, 0xbfd02778f81509d6,
    0xbfdb162e2d3d82be, 0x400b75f2c4cd4d82,
    0x3fdd8d39a7e440d8, 0x4000403a715c52d4,
    0x3fdc004aff3c44b8, 0x400fe9a133a12ef4,
    0x3ffb5f9b171c0743, 0x3ff881731b72c19a,
    0xbff9f5308e0728fa, 0x3fe6b73c7986d5bc,
    0xbfe04d15d4ea5da4, 0xc0011e9466396082,
    0x4002fa9fc9fbe392, 0xc008265b02e65e70,
    0xbff0fdf4f4afc4a2, 0xbfda89843d837937,
    0x3ff0a1ea53bab26d, 0x3feb6f6733926b92,
    0x3fefa152e86c6055, 0xbfedd0b5aa97f40f,
    0x3fce4e98e5dea3d6, 0x3ff613c3cadaf5af,
    0xbfe5aebc6e24e7df, 0xbff68d7f1ff53251,
    0x400c5d3082208b6a, 0x3fd6d0ff0e8308e2,
    0xc011a774fe7efd9f, 0xbfed617f81832b04,
    0xc00ef8f277d25cec, 0x3ffa33eaf6e95f43,
    0xbfe3334fc147417c, 0x401347d68e7e79f6,
    0x3fb83b2bf7fe5ef0, 0xbfde633e21158f91,
    0xbfea9b8715361e5c, 0x3fe7314fc52ea104,
    0xc0019d43561702f9, 0x3fead18d98ea0a12,
    0xbfea634de58abf75, 0xbfd9b548b8c4bb7d,
    0x3fb3f6184498b05c, 0xbfb3f3ff1407a4d8,
    0x3fe390a9fc52a2e1, 0xc0090ce1e5646850,
    0xbffcd8b4d1d5a0d0, 0x400b49581abad33a,
    0xbff6d7b0224bdde2, 0x4002adbda8bd13aa,
    0xbfeb5a35b5927c49, 0xbff2e9f546521a47,
    0x3fdacdb45bae28b6, 0xbfbde32cdf4ba870,
    0xbfe03fbadca97c3c, 0x400a38d66ca7746e,
    0x4003a04aee7de2c2, 0xc0001da1c8519cda,
    0xbfe051789ec2f77e, 0x3fd7bba36ac3bbcb,
    0x3fd2b0dd3d8bf98a, 0xbfdf57a4710fe3b4,
    0x3fdfcea50cda3be6, 0x3fde01755502b84e,
    0xbfdecfb559384fcc, 0x40056ea79afabcf1,
    0xbff45cca6cbf5fb5, 0xbfb399c42f64b37c,
    0x3fe1aa98f3b335b2, 0xbffb494d83badac4,
    0xc01025f8557dac0a, 0xc000454103ef561a,
    0xbffd902b93f8b1ee, 0xc00a2bc8e4e12bb0,
    0x3ff9bac8034b3c12, 0xbfec2a74762d1e1c,
    0x3ff1942230cd6fa5, 0xbfe947b791c04e16,
    0xc0105ccf03c74704, 0xbfc651bd4f8e1c08,
    0xbfffe0ca2c29ef32, 0x3fe1088b97033846,
    0x4000330aeee71c5e, 0xbff6a719998e5493,
    0xbff3c6c35d620dab, 0xbfba1e6d5d61fe80,
    0xbffd37b5c3b5956a, 0x3fc1a794489998f8,
    0xbfde9c53cf0fed7e, 0x3fe5a3698058137a,
    0x3ff179cb36f720b2, 0x3fe635c6a03fbf0f,
    0x3fcf17bbf0845794, 0xc00097a37ae990c6,
    0x3fd541ff78b66899, 0x3fc421231d6157a0,
    0x4005e5d319a4bc26, 0xc004e20ce587161a,
    0xc002bdf8c23cc363, 0xbfd8f8469ca7ab7f,
    0xc0002f7fa880b51d, 0x3ffd073a33e909d3,
    0xc00a0d2a692b00f4, 0xbffc8a3ef65bbf08,
    0x3ffc0cde4959b2ad, 0x400e146cf8358024,
    0x3fe2f621f945b70a, 0xc00509cdd48a0add,
    0x40014125fb7b0da4, 0x3ff504fcf72c3c23,
    0x3ff55be3d34d57bb, 0xc001328fa0bed224,
    0xc00196d4449a425e, 0x400acda988bf2629,
    0x3ff2ea5c3bf28b24, 0x3ff48a73c0cca0d4,
    0xbfe93ce099e735bc, 0xbfedad15c2a9a36e,
    0x3fd1203c25a7c965, 0xbfeb5f2204fa5bd8,
    0x3fe580ec4b99f96c, 0xbfcbc234a8b1f520,
    0x3ff3844203255be0, 0x3fc5483cfebc5a44,
    0x3fe95d1bdcbeae4a, 0x3fc74189127a383c,
    0x3fddf140c00a6d81, 0x4008afe96c362012,
    0x3ff6eafeb45f7c98, 0xbfeda87c81162262,
    0x3fc7788fbffb3524, 0xbffc324e33a9ebde,
    0xbff7747e82f5f4ec, 0xc013a35a95fc7946,
    0x3fc4c18fdc3bdf0c, 0x3fe9ccf0d01f1414,
    0x3fd771b88506175f, 0x3ffd2466adfc5f52,
    0xbfd354a5eab974b2, 0xbfea6fc6a98166ca,
    0xbff72ab08314a78f, 0x3fdf79a404482ac0,
    0x3fcbaa64f6bc3f20, 0x3fe41d92a1f7f1c4,
    0xbff962e0089fbc22, 0xbffdf8a6d441facc,
    0xbfcd27f5cef4e65c, 0xbfaf8c420e484bb0,
    0xbfee1cdf8c96091d, 0xbffc23cc6c66671a,
    0x3fe663ec70706c90, 0x3fea2839fef36f47,
    0xc00606a2cb3df32a, 0x3fc3828f88aa0864,
    0x400dc9fa6e22d7de, 0x3fef2fab51736086,
    0x40044c60acefc074, 0x3fd62bdf6678412a,
    0x4008e5f3aecfeb46, 0xc00462a8a84ce40e,
    0xbfec090464d62ebb, 0x3ff90742e5a79037,
    0xbffa1b5191af528a, 0x3ffeb8d9ed12754e,
    0x3fb85284c70bf620, 0xc00507651b34a2e8,
    0xbfeef5573c6f3868, 0xbfce7cb668774474,
    0xbfea42828cd4d7e6, 0x3ff646c5328beb97,
    0x3fefe43c45df3944, 0xbfe0d91fc3e1bb7f,
    0x3fdf515fa16afc35, 0xbff64a6026888d6e,
    0x3fda05babd70ec14, 0x3ff108ae1613f102,
    0x3fe48800e9b984fa, 0xbfec6b2929b6515c,
    0xbffd034d7d5b7995, 0x4003c3adbccc07f0,
    0x3fd67c8a8f7c8e28, 0xbf8d858074a11a00,
    0xbfd14d0b0d057ac6, 0x40008cfd4c8fd3f9,
    0x4005a1c8e713fd93, 0x3fdec61c2bec4668,
    0x3ff86fa651c2d910, 0x3ffbad39fb03d091,
    0xbfd349226edce827, 0x3fd8e9ae13fdbe7e,
    0xbfee33b9a7f286dc, 0x3fea261c54e2c14e,
    0x3fe4103f98478e24, 0x3fd7abb315a7b76c,
    0xbff57ed5eb3783f8, 0xc0090b2d821d0099
    };

static const uint64_t ref_cfft_noisy_2048[4096] = {
    0xc01405d8ccbc9b1a, 0x0,
    0xbff57ed5eb3783f6, 0x40090b2d821d009a,
    0x3fe4103f98478e1f, 0xbfd7abb315a7b770,
    0xbfee33b9a7f286d8, 0xbfea261c54e2c14f,
    0xbfd349226edce82f, 0xbfd8e9ae13fdbe82,
    0x3ff86fa651c2d910, 0xbffbad39fb03d08e,
    0x4005a1c8e713fd92, 0xbfdec61c2bec465a,
    0xbfd14d0b0d057abc, 0xc0008cfd4c8fd3fa,
    0x3fd67c8a8f7c8e28, 0x3f8d858074a11a00,
    0xbffd034d7d5b7996, 0xc003c3adbccc07f0,
    0x3fe48800e9b984f8, 0x3fec6b2929b65164,
    0x3fda05babd70ec18, 0xbff108ae1613f0fd,
    0x3fdf515fa16afc35, 0x3ff64a6026888d6c,
    0x3fefe43c45df3943, 0x3fe0d91fc3e1bb82,
    0xbfea42828cd4d7e7, 0xbff646c5328beb98,
    0xbfeef5573c6f3866, 0x3fce7cb66877446e,
    0x3fb85284c70bf630, 0x400507651b34a2e8,
    0xbffa1b5191af528a, 0xbffeb8d9ed12754b,
    0xbfec090464d62ebd, 0xbff90742e5a79036,
    0x4008e5f3aecfeb46, 0x400462a8a84ce410,
    0x40044c60acefc075, 0xbfd62bdf66784128,
    0x400dc9fa6e22d7dc, 0xbfef2fab51736088,
    0xc00606a2cb3df32b, 0xbfc3828f88aa086c,
    0x3fe663ec70706c97, 0xbfea2839fef36f48,
    0xbfee1cdf8c96091b, 0x3ffc23cc6c66671a,
    0xbfcd27f5cef4e660, 0x3faf8c420e484b9c,
    0xbff962e0089fbc20, 0x3ffdf8a6d441face,
    0x3fcbaa64f6bc3f20, 0xbfe41d92a1f7f1c0,
    0xbff72ab08314a790, 0xbfdf79a404482ac4,
    0xbfd354a5eab974b4, 0x3fea6fc6a98166ce,
    0x3fd771b885061764, 0xbffd2466adfc5f52,
    0x3fc4c18fdc3bdf10, 0xbfe9ccf0d01f1412,
    0xbff7747e82f5f4ee, 0x4013a35a95fc7946,
    0x3fc7788fbffb3534, 0x3ffc324e33a9ebe1,
    0x3ff6eafeb45f7c96, 0x3feda87c81162267,
    0x3fddf140c00a6d82, 0xc008afe96c362010,
    0x3fe95d1bdcbeae4c, 0xbfc74189127a3842,
    0x3ff3844203255be1, 0xbfc5483cfebc5a4c,
    0x3fe580ec4b99f96e, 0x3fcbc234a8b1f528,
    0x3fd1203c25a7c95a, 0x3feb5f2204fa5bd2,
    0xbfe93ce099e735be, 0x3fedad15c2a9a370,
    0x3ff2ea5c3bf28b24, 0xbff48a73c0cca0d4,
    0xc00196d4449a425d, 0xc00acda988bf2628,
    0x3ff55be3d34d57bb, 0x4001328fa0bed226,
    0x40014125fb7b0da2, 0xbff504fcf72c3c24,
    0x3fe2f621f945b708, 0x400509cdd48a0ade,
    0x3ffc0cde4959b2ac, 0xc00e146cf8358024,
    0xc00a0d2a692b00f4, 0x3ffc8a3ef65bbf0c,
    0xc0002f7fa880b51d, 0xbffd073a33e909d2,
    0xc002bdf8c23cc363, 0x3fd8f8469ca7ab7e,
    0x4005e5d319a4bc27, 0x4004e20ce587161a,
    0x3fd541ff78b66894, 0xbfc421231d6157b0,
    0x3fcf17bbf08457b0, 0x400097a37ae990c7,
    0x3ff179cb36f720b2, 0xbfe635c6a03fbf0f,
    0xbfde9c53cf0fed7c, 0xbfe5a3698058137b,
    0xbffd37b5c3b59567, 0xbfc1a79448999900,
    0xbff3c6c35d620dae, 0x3fba1e6d5d61fe60,
    0x4000330aeee71c5e, 0x3ff6a719998e5490,
    0xbfffe0ca2c29ef34, 0xbfe1088b97033842,
    0xc0105ccf03c74704, 0x3fc651bd4f8e1bfc,
    0x3ff1942230cd6fa4, 0x3fe947b791c04e20,
    0x3ff9bac8034b3c14, 0x3fec2a74762d1e1c,
    0xbffd902b93f8b1ec, 0x400a2bc8e4e12bae,
    0xc01025f8557dac0a, 0x4000454103ef561b,
    0x3fe1aa98f3b335b2, 0x3ffb494d83badac4,
    0xbff45cca6cbf5fb7, 0x3fb399c42f64b370,
    0xbfdecfb559384fcc, 0xc0056ea79afabcf0,
    0x3fdfcea50cda3bee, 0xbfde01755502b856,
    0x3fd2b0dd3d8bf990, 0x3fdf57a4710fe3c0,
    0xbfe051789ec2f77a, 0xbfd7bba36ac3bbcd,
    0x4003a04aee7de2c2, 0x40001da1c8519cdb,
    0xbfe03fbadca97c3e, 0xc00a38d66ca7746e,
    0x3fdacdb45bae28aa, 0x3fbde32cdf4ba870,
    0xbfeb5a35b5927c45, 0x3ff2e9f546521a47,
    0xbff6d7b0224bdde2, 0xc002adbda8bd13aa,
    0xbffcd8b4d1d5a0d0, 0xc00b49581abad33a,
    0x3fe390a9fc52a2e7, 0x40090ce1e5646850,
    0x3fb3f6184498b010, 0x3fb3f3ff1407a4f8,
    0xbfea634de58abf74, 0x3fd9b548b8c4bb74,
    0xc0019d43561702fa, 0xbfead18d98ea0a18,
    0xbfea9b8715361e5c, 0xbfe7314fc52ea102,
    0x3fb83b2bf7fe5eb0, 0x3fde633e21158f95,
    0xbfe3334fc147417a, 0xc01347d68e7e79f6,
    0xc00ef8f277d25cec, 0xbffa33eaf6e95f40,
    0xc011a774fe7efda0, 0x3fed617f81832b00,
    0x400c5d3082208b6c, 0xbfd6d0ff0e8308ed,
    0xbfe5aebc6e24e7e6, 0x3ff68d7f1ff53254,
    0x3fce4e98e5dea3d2, 0xbff613c3cadaf5b0,
    0x3fefa152e86c6056, 0x3fedd0b5aa97f417,
    0x3ff0a1ea53bab26e, 0xbfeb6f6733926b8c,
    0xbff0fdf4f4afc4a0, 0x3fda89843d83793d,
    0x4002fa9fc9fbe392, 0x4008265b02e65e70,
    0xbfe04d15d4ea5daa, 0x40011e9466396083,
    0xbff9f5308e0728f8, 0xbfe6b73c7986d5bc,
    0x3ffb5f9b171c0746, 0xbff881731b72c19e,
    0x3fdc004aff3c44ae, 0xc00fe9a133a12ef4,
    0x3fdd8d39a7e440d6, 0xc000403a715c52d4,
    0xbfdb162e2d3d82bc, 0xc00b75f2c4cd4d81,
    0xbfe50264185a0863, 0x3fd02778f81509d8,
    0xbfda76b243d5544c, 0x3fe60a84f9c90676,
    0x3ff4bacb6f2dfd54, 0xbff2374945271d66,
    0xc00810ec9a799551, 0xc011e0a83f838b97,
    0xc0044fc1b3e0483d, 0xc010138617b9c570,
    0x3ffb26ad6750829e, 0x3fe13342a3e7b2cc,
    0x3fc5f4749f54df28, 0x3ff2e174265ecb1c,
    0xbfc9581bb3633dc7, 0xbfee9a60dc8c1701,
    0x3ff072a6b4c967e8, 0xc005a21bcb6ba7f3,
    0xbfff57503fd447bb, 0xbfc68d1adcafa82c,
    0x3ff7131220ae26c2, 0xbfbf192c7be2db40,
    0x40013924e8938341, 0x3fe5052afd74c1c0,
    0xbff1aaa9cb56e30b, 0x3fed3496658c4917,
    0xbff19a96618a0fd8, 0x3fcfcc9ca0255c00,
    0xbfec1bb85f0d1317, 0xbff3a01e2d77bc38,
    0xbfe8ad26edf41aa5, 0x3fd5658bc4609b9c,
    0x3fe77bfff5a5cf8a, 0xc000f207df0d133b,
    0xbff7545a44e26bac, 0xbfd5b944b225d458,
    0x3fd0e8e188b5878c, 0xbfbd599818e84926,
    0xbfb7075c09c7a870, 0xc009f07f8d3406f5,
    0xbff32f4ccd31095a, 0x3ff98db7de865fba,
    0xbff733467cc122da, 0xc0015fec12bdcecc,
    0x4005368eb1ef8664, 0x4006938e3d88aa46,
    0x3fd09c7597b5b122, 0xbfe077742ad1f8e8,
    0x400419536a4ae362, 0xbfa19927e7d4ac40,
    0x3fe3cb4da5052ae6, 0xc002ddf8bbda165e,
    0x3ff5aa35bbdae035, 0xc0097ae2dba0cbec,
    0xbfdb21b6d9cf78a2, 0x3fe139b525195aa6,
    0x3ff92b2cbbba8a0b, 0xbfe2d6949296dff4,
    0xbfee4d0911afdf62, 0xbfef9fba5186f674,
    0x3fb0df68cff93610, 0x3fe547cfbc64e892,
    0x3ffd91adfd596bf5, 0x3ff0e0ee4262da1b,
    0xbffe1f090bce66eb, 0x3fe4b2dcacf7643f,
    0x3fff1eb45cd9848c, 0xbfd6942e7e47c450,
    0x3f63a73eb345aa00, 0xbfeba91f994a614d,
    0x3fdf0cf209c00a8c, 0x3ff25f6129e7a2a4,
    0xbfe59a050170531a, 0xbfd8d24c4967e4ac,
    0x3ff45066803a9dbd, 0xbfd3b8af3b3c4c94,
    0x4002c8934acae5a9, 0x4003680d671efa66,
    0xbfeb67b7db6cd4c1, 0xbffd429a2aa808c4,
    0x3fe0e15ec09322a2, 0xc00b3f87dd5640d4,
    0xbfffc441a94ea139, 0x3ff32944c3dd7662,
    0xbff9608f40cb4d7f, 0xbff4b3cdaa63eb1a,
    0xbff32544d5d2f8c6, 0x400c08fa8a98b7f5,
    0xc0073a20628f50de, 0xbff7a1c6c948cf0c,
    0xbff866a7900c46d8, 0xc00a8891ca8b701a,
    0x3fd6a35574a1b7ec, 0x3fe779fa6a9da792,
    0xc004fbc6e749d30a, 0xbff0f43e722753d1,
    0xbfea1e00ef21e858, 0xbffbb58d00088c7a,
    0xbfef4b01e040b3ac, 0xbfa0f96a80a41410,
    0xbff02958918d3a6a, 0x3fe3c47a88482bea,
    0x3fee4434b64e0750, 0x3ff19589f5a9e038,
    0xbff7aa9873a74e3c, 0xc0075e1625ebad9d,
    0xbfd7b4d7e8d3b924, 0x3fba2ecbe7bf700c,
    0xbfd802a4ece0f84c, 0xbfe9a3876369090e,
    0xbfe59aa8aebc37c5, 0xbff20cc735a0ed0e,
    0x3fea559f124898c2, 0xc000eaa933e55627,
    0x3fe5e25b3318c977, 0x3ff0ae49b30fa288,
    0xc00496aa4b318e22, 0x3febbf13f9e52d2e,
    0x3fb8e0428cd23ddc, 0x3ff0e0cb9b6fdc2f,
    0xc0049cb1a3156208, 0x40000c4b495c4554,
    0xbfe1767fc2ac8d5d, 0x3fedecba104f2434,
    0x3ff831c31abac64f, 0x3fbf789c78e76990,
    0x400db3c5fbf388ed, 0xbfef872069636732,
    0x3fdb1204bab79b9a, 0xbf9dd5efb08330d0,
    0x3fcffc860dee568a, 0xbfe7637e8a80161b,
    0xbfbee93de0151aa0, 0xbffa6622417c71ba,
    0x4002cdf6dde75c91, 0x3fdd48adec68cfc8,
    0xc004beb993d728a9, 0x4011808f11ab8e44,
    0x3fed0e3b5e386014, 0xc00496faf7acbca2,
    0x3ff511cfa3d0bedc, 0x400d463837e1b8cc,
    0x3ff299898ff40dd7, 0x40022f7751443892,
    0x3ff0d612582ad86e, 0xbfe3b769ed7abb41,
    0xc006fb4c9a1c1314, 0xbfe036fa5c65e4ed,
    0x40014ddd68ffa4b6, 0x3fe511f7b35a59c4,
    0xbfe01be5e70d4b78, 0x3fe3ebb884f5ffad,
    0xbfc9734bce639a44, 0xbff1a2b71fb772b4,
    0x3ff9f73c3f9a992e, 0xbfe96a05941b362e,
    0x3fec598a9f1313db, 0x3fe7e97eac852a8a,
    0x3fee99404e98ad79, 0x3fce44c74a7cc704,
    0xbfed1b338bd53ddb, 0xbff04de2cf877274,
    0xbfbdabd762c9a658, 0xbfe07dad491fd8b2,
    0xbff597d0213794b0, 0xbfe291ab583585be,
    0x3fd9805c0d9d0aae, 0xbfdc4a10541a49fe,
    0xbfeb0492dd9964b5, 0xbff72f5e3e7a1d5e,
    0xbfe4e8368521081d, 0x3ff77b7c15cf4160,
    0xbff6e14040b45f0e, 0xc009fd166d1fd9ca,
    0xbfd95d229c69ca26, 0xbfda5edbd048f6ed,
    0x3fd04914e47bf728, 0x40024b92c7d704d5,
    0xbffce258cde3deb2, 0xc004613a57c98335,
    0xbfc03a4095ccb26c, 0x3ff121701af8f5b4,
    0xbfd100ee4b3ff240, 0xbffac54d7547fa2a,
    0xbff54f9bdf13247d, 0xbff483bcdae295ba,
    0xbfd360f5bd89ac34, 0xbffea730383a2b2d,
    0xbff7093122f3077c, 0x3fe7b16ac5ff2bd0,
    0xbffdf82b2c3aebdc, 0xbff4ca38a76064be,
    0x3f826ee76dfe5920, 0xbfb856f3feb3ad7c,
    0x4000cead697c6569, 0xbff79e4ef4bd012b,
    0xbfef4ccb10b8262a, 0x3ffb3b2b04febb92,
    0x3fff2de41bf864ac, 0xc001ec35341be59a,
    0x40035e03efe4ce4e, 0x40079a486f558322,
    0x3fda2be673db6b3e, 0x3ff74dc0e668a772,
    0x3feb60b8f2a4d0df, 0x40030c45c4bcac48,
    0xbffbd9bd032d41b8, 0x3ff90ab061e01462,
    0xc003d89a5006a5f2, 0x3fe162909e642d8e,
    0xc00b52b934c697e9, 0x3fb252f63e397128,
    0x400444b1f395d39d, 0xbffc59d73f61cb2c,
    0x3fe98e4c6a320dbd, 0xbfeab6533cd12474,
    0x400208c76072a55a, 0x3ffd8be1c4ce78a0,
    0xbfd5f38b454be2a4, 0xbffea65f158ba861,
    0xbfcfdeb6c152f40c, 0x3fe9d456cce11d52,
    0xbfa465072c03d080, 0x3fe5f0bb44b3a8a6,
    0x3ffd570df0f831e4, 0x3fec457cd79b4057,
    0xc0026af7a30c0802, 0xbfdaab594c5be3c8,
    0x400428bac1a5e548, 0x3fffabedcde96cc3,
    0xc004e473f3ebce40, 0xbff17875e95dd058,
    0x4001d1dace816016, 0xc0052220ec90c112,
    0x3fea9ab8b8e4be3d, 0xbfcb2127411ada72,
    0x3fe370ea43073a24, 0x3fd78b15810258cb,
    0x3fe7c279bc71e444, 0x3ff7b7f1cc5932d6,
    0xbfecb031c42755d2, 0xbfa38c29bb373ab8,
    0x3ff60b2a8d362b72, 0x3fe93e27c4f617f5,
    0x3ff0747bdac1c49c, 0x3ff56a5dd608dcc6,
    0x3fd366e0e9322d8a, 0xbfd89ba21cfc7762,
    0xbffa636a2f503904, 0xbfcebaa25a8e6f48,
    0xbfe722da2d614ae6, 0x4004a0d956ed2d68,
    0xc00336081c148b45, 0x3ff31a0f1107a885,
    0xbffa6fa6af9d3673, 0xbff68fffde5cc63d,
    0x3febce138bd97496, 0xbfff25c99cee7719,
    0xbff01b4d4b88a35b, 0x3fd75c4f633aadbc,
    0xbffce98795748810, 0xbff82dbb991bdb4d,
    0xc000b36e51a609d5, 0x3ff543c541d50452,
    0xbff0831a5a718772, 0x3ff3a774eea6a5ac,
    0x3fd17d3cfb9476c6, 0x40053dec56bf0f94,
    0x3ff459ede4cb8336, 0xbfd54186141f1ee4,
    0x3fe521386d455866, 0xbff1551e66d70e5d,
    0x3ffae7639295b34a, 0x3ff6efc874fc2613,
    0x4000453d29ca98c6, 0xbff90903ad98b73e,
    0x3ffc4e9c27e8151b, 0xbfe5b5ea1c17e384,
    0x3ff20146c873c1f6, 0xbff5d5c84db04669,
    0x3fed9c113338406d, 0x3f900d2d78b07420,
    0x3ff2e6a5ba650194, 0xbff170332e37c106,
    0xbfe27bc568fc3d7c, 0xbfb0677f592337d0,
    0xbfb9ca58790b7484, 0x3fdd4980b8c8481a,
    0x3fd4618f07b31139, 0xc00892136f2d6f26,
    0x40040176b560b0cf, 0xbfed8314d7f1cf44,
    0xbfd03c9de1801ee8, 0x3fe207199d0e2b84,
    0xbff2424f80073adc, 0x3ff764e284ab4322,
    0xbfd6f7a6d86244e6, 0x3ff127e6e241e154,
    0x3ffa871140f356bb, 0x3ffb9faa02887ecb,
    0x3fc75c50169e8904, 0x400f803188217e46,
    0x3fb2e8dd85355950, 0x400670e98ac571f5,
    0xbfe553d649101984, 0xc0021eb4f21073f6,
    0xbfe0a32f61d05676, 0xbff743f92e107840,
    0x3ffa7f9df13254e4, 0xbff0b9597cb4b389,
    0x3fe089dc8711dc58, 0xc0015f40a768db3c,
    0x3fd11714176cf298, 0xc006fc8ef2ced11d,
    0xc0091de01dfa33a6, 0x3ff7bb306b81f158,
    0x3fe2f34dd8ad3eef, 0xc0866a81da3e8fc8,
    0xbfda0f7f211449ce, 0x3ff2b6160db079e8,
    0xbfed7eaefec038c2, 0x400fd04f56247ac0,
    0xbfb7b8740b83144c, 0x3fff8c37509bde60,
    0x4004395e53cdfd1a, 0x3ffb29f43e2c6cb6,
    0x3fec983ba7d7aaae, 0xbfb7b987dfd98abc,
    0x3ff5500aa013e5ae, 0x3ffd15382d0fc6ce,
    0xbff26da928d552f1, 0xc01525b7fa15ee1c,
    0xbff992d392bc9246, 0x4002c637cb9d43ee,
    0xbff82bb6f5a6d08b, 0xbfe39ceb62749a26,
    0x3ff00ab019a64a16, 0xbfd2b20471b40581,
    0x3ff77a94900b82e7, 0xbfe5ffc1c28e64d6,
    0xbff7b5e93c060206, 0x3ffb9ce70f9d8cf4,
    0x400b04a1a2a9bf21, 0x40046fb931796cea,
    0xbfc27a54ce857fe8, 0xbff9d39f8fa08c6c,
    0x3fb2628bee1ff410, 0x3f8fef05abef7f40,
    0xbfe5d2e840137cbf, 0x3ff3f2363813d66a,
    0xc0086015553e5305, 0xbfd75e7638aefbc6,
    0xbfe8507df5fda8f5, 0x3ff6f6e5ba7b8f7e,
    0x3feec1435d1ccedf, 0x3feb058686e255dc,
    0xbfeebaedc23175e6, 0xbfd16edc2d825eb8,
    0x3fe279db8ae62a0c, 0x3fdf45b61d732f84,
    0x3fe94746953c285e, 0xbfc799ba90366b2e,
    0x3fe0616d3ae2abe1, 0x400544a3682959b6,
    0x3fd167a7834a1e02, 0x3ffa527a6ceaa982,
    0xbfd3488ca25ca280, 0xbfad305fdad367a0,
    0x3febae3625fe051b, 0x3ffdb7ef3c4d9c1f,
    0x3fd5f902f57bd730, 0x3fd661f548d00690,
    0x3fdc25727e75beee, 0x4009fe3c70745887,
    0xbfda3e3e84f9d098, 0xbffbacc0adf0da28,
    0xbfd0d0582127f8ea, 0xbffed3643db20d86,
    0x3ff9877c2e83833c, 0x3fb562a1cec25bec,
    0xbfe068308d187b19, 0x4009abea22ae26c5,
    0xc001d0ef1a5db66f, 0xc00090ebd7b1122e,
    0xbfd7e16ad53a4a5d, 0xbfebf3fcbc71ffc9,
    0xbfdfad715674f719, 0x3fef3acfd47659ce,
    0x3ffac2793dc27001, 0x3ff13b3c8f76425b,
    0xbffff3fe04f0193c, 0xbfdee72f3bc989b6,
    0x3fe9c368274b5af1, 0xc00089b67358a2b8,
    0x3fe9c4f2a8184a30, 0xbff2cbff34faf972,
    0x3fffe1e2f222cefc, 0x3ff314d7186baf20,
    0xbfd19d7fb36d4390, 0xbffd59ee6c5682dd,
    0x3f9b06007eb3c080, 0xbfeae5b5ab5c24a6,
    0x4001ec800ee668b3, 0x3ff207cb3fee4748,
    0x3fe093caacc08685, 0xbfe80fd779fcc582,
    0xbfd6b06c286037c0, 0xc00e24403b10f644,
    0x3ffbbbf7aa4bac4e, 0x4003a6a3f92adcaf,
    0x40064d56197722e4, 0x3fd573b677681a6e,
    0xbff9bedbb9c1d0e0, 0x3fede30030a6c6c8,
    0xbfe9f9aa2de8b434, 0x40000c2881f83cf6,
    0xbff1a1e28740ecce, 0xbfcbd0c5655db7ba,
    0xbff3d811fcb04a48, 0x3ff36c340fbeba63,
    0x3ff7d561c27d7328, 0xbfd7545721606bd4,
    0xbfd88afcffb26160, 0x3feca29c546e10e4,
    0x3fe7080a30cb6b6c, 0x3fe15507a1f9171a,
    0x4000283afcf53f9e, 0x3fec4d80eb673e1d,
    0xc000914e81b11df2, 0xbfeb0d9ddec666c0,
    0xc00aa94cb0f4696c, 0xbfa69c1a8b0671d0,
    0xbfd21fd5b87e71ea, 0xc0013e10380048ee,
    0xbff1b11211b09061, 0xc0045ad9e2ca7969,
    0xbfe4b8af995ab792, 0x3fcd4e76fad8f4d8,
    0xbffd7cd63b4c2004, 0x4003860d86ff6f7c,
    0x3ff1b80fefdd4e4a, 0xc00257e27bba8e16,
    0xc0025655c7a1e358, 0xbfe1b617bd5377e5,
    0xbff083c0b355f9a3, 0xbfbfc9ea57013ba0,
    0x3fea185e08dd3455, 0xc00545ad137c22c8,
    0xbfee2ed8011ef508, 0x3fe00a5b8673ce38,
    0x3fe8816167d5a9a2, 0x3fc9481014acada0,
    0xc000bb1cdeaa796d, 0xbff803322c43b0b4,
    0x3fcf6a646be35c50, 0xbffbd9991886b1f7,
    0xbffeab04feb2df53, 0x3ffc9d6a721b343a,
    0xbffb08e705ceef9e, 0xbfcf10c2700ee962,
    0x3fdfecda51f42e6e, 0xc001fd1038c05054,
    0xbffdf43e4f983648, 0xbffbe129c6a87193,
    0xbff28911550ce196, 0x3fe89dc38c2c56e5,
    0xbffea09149c4f030, 0x3fb5c58b75a9c988,
    0xbff7b0774032aede, 0x3ff0434386456e9a,
    0xbff6656846d7c132, 0x3fe60540ca584b36,
    0xbffac5bfa88f1422, 0xbff906d94b24bec0,
    0x3ff892668545914f, 0xbfd09f92a28f14c8,
    0x3fef4ad0e7d6488a, 0x3ffce885a23d86a1,
    0x4002fb75f9ae62a8, 0x3ffd52f3e27f8105,
    0x3fe0ae054466d262, 0xbffb0443c8986e24,
    0xbff3dfeed4433391, 0xc008361f215e0ab0,
    0x3fd7ff81cbc4c0bc, 0x3ff1c6395527ae3e,
    0x3feb767957afd5e7, 0xbfe4e93a08c9e421,
    0xc005de0197d9264c, 0xbff9eb2d181345ac,
    0xbfcccd5645de57c0, 0xc00558dc51c08a54,
    0x40073e8fcc889040, 0xc003d9ba1e6608bc,
    0xbfd3274a2f72f278, 0xbffb238ce5937ffa,
    0xbfc0c6a47836e3c8, 0x3fe3b4372357f3d6,
    0x3ff9e060a77b3009, 0x3ff83ef32b04b9c9,
    0xbffed7159ba8912c, 0xbfe1f4ab5254c809,
    0x3fd5417bd390ef08, 0x3ff1878b7333516a,
    0xbfc0ade45f6d59c4, 0x3fe7338a1f1b653a,
    0x3fec63c9669f0f9c, 0x3fe5110b9b9caef5,
    0xc00e2378d764c266, 0x3ff2b1a9661d0580,
    0x3ff97972d9b5f654, 0xbfd34ddf2cd742c6,
    0x3ffd88557e43525d, 0xbfd0e8f193c29b7a,
    0xbfe7b0d365ac2a98, 0xbfe8c1ffabafd1fe,
    0xbffe61460f9cacd0, 0xc00001e14e075c6a,
    0xbfc53cd3f65a47d8, 0x4008eac6ba095786,
    0x3ff73b3ed5a81b1a, 0xbff2c72a4726e53f,
    0xbfece043295f964f, 0x3feec7abdf4ca9de,
    0xbff0f430e9fce5d2, 0xc0036821de413026,
    0x3fb1ca5384141c10, 0x3fee96f8a8e24051,
    0xbfc597029645bc02, 0xbff5415682c73ef2,
    0xbff65e02fab69706, 0x3fc97c83d27efc58,
    0x4005100cced39674, 0xc000929aed146cf9,
    0x4007bf56668f7b0a, 0xbfebce2514e84596,
    0xbfe4077ae1cb4ab9, 0xbfeb05fd596e1b20,
    0xbff7aa74fbb0eab4, 0x3ffd11d8807f057a,
    0x3fffe4acb0cc00a4, 0x3ff87502321fe77e,
    0xc00e6817d0c5af70, 0x3fe85ab0df210229,
    0x3fd2e850f0a08396, 0x3ff27bdcf2fdb239,
    0xbf81074a90229480, 0xc0013cac9b9aef95,
    0x3fca480d5ff7f0d4, 0x3ffa402a7c520538,
    0x3fe8e2a8543d5390, 0x3fdb38bd775bd4e9,
    0x4002991bf9eeff7a, 0x3ff403b3bcd31322,
    0xbfeb2f468fa90470, 0xbfd1acd602705290,
    0x3fece9ed0bec0db4, 0xbfd878736351edb2,
    0xbfe95b0b81b9afdb, 0xc006a279323d5f20,
    0xc004975ca662209a, 0xbff02df2e8571c89,
    0x3ff355e86e4539bb, 0x3ff5aa45e3d8cc2a,
    0x3fe04d580b423076, 0x3fec698cea6dfe5b,
    0x400bd50f729e53b5, 0xbfd7f7c3a6d22eb0,
    0xc0004c2a86e99ce9, 0x3fd928190f167a2a,
    0x3ff2d4a8ee54ae54, 0x3ffaf7003b030a72,
    0x4007b37542b3f34a, 0xbfbcd19e45923540,
    0x3ffacad36ff6fcf6, 0xbffd36db5c6feb17,
    0x4001044b33c5a63c, 0xbfdb15a8b3bc515e,
    0x3fea6a46b6a3ce44, 0x3fda8ab325d3de2a,
    0x3ff80f86f91dd7ea, 0xbff02c97215edcc8,
    0x40105d063d16ba5b, 0x3ff0a4be08fb037a,
    0xbfeaf71877737e24, 0xc0003558a4cb8af7,
    0x3feb84b4e76e3dc0, 0x4002e2d1d5fd278e,
    0x3fef878c1e341d5e, 0xbfdbfec797e61fa8,
    0xc00084360cdf0509, 0x3fafb69dca4d79c0,
    0xc00c5eb65e8ebfa0, 0xbfe3ee3fe376e95a,
    0xbff66c199c3b7cb8, 0x3fe363f4d545c800,
    0x3fe74beddb611e44, 0x3fde54e869898895,
    0xbfe6e19d8fbc4b97, 0xbff5a7fc379df15a,
    0x3ff66be9988e922c, 0x3fe7b94e9b8ebd88,
    0x3ff53daa58d37ad7, 0xbff954425b740cd0,
    0xbffb936003434730, 0x3ff40df009904517,
    0x3fead39c29e953f0, 0xbfeddb4debb5b2c8,
    0x3fd4334f91ce8555, 0xbfe8c24d1ad44bc8,
    0x3fdc22520720d76d, 0xbffea91ee96133fa,
    0xc010763370ad3f49, 0xbffcea7b6f8f39c3,
    0x3fe781cd630e05f1, 0x3fe177cac6fd0bf0,
    0x3fc050e3f1b86cd8, 0xbfdda5fcc1292634,
    0x40034742650cfb00, 0xbff164d74a0e27c8,
    0x4005bd382400da65, 0xbfc95055cf47b508,
    0xbfe3f74ac4931a14, 0x3fec4d6fb55a23e8,
    0x3fe5cc7c56586e02, 0x3fa2797dbf752c3c,
    0xbff46fd1435f7362, 0x3ffbe1a273ed00b3,
    0x40049466ba5af7a1, 0xbff9a7a8a0c29ae8,
    0x3ffd18119dd70566, 0xbff004759c52dfea,
    0x40005d6822bfa658, 0x3ff67c698b000034,
    0xbfe25b6dd1492a03, 0x3feedef18c60d4a2,
    0xbf7e879a70ef5f00, 0xbfc6251e638ee5e7,
    0x3ff54f6effd3daf6, 0x3febbee0d3eb63de,
    0x3fc3d85168396578, 0x400acfabf7c9ee2a,
    0x4001954b287d5048, 0xbffae2044478dd9e,
    0xbffb53c107d2cb1e, 0x3fc46e7c9dc369e0,
    0x3fd13f86e2335fa4, 0xbff6ea6f84b7075e,
    0x3fe1ca541b563194, 0xbff1f8552e1a4827,
    0xc003682ec95ab80b, 0x3ff5faed902aa31a,
    0x3ff6eb6fa18fa032, 0x3ff034fbd79aa1ae,
    0x3fb2e79f8b416470, 0x3fc639b56081fcb8,
    0xbfe795a45cd5c863, 0xbff0cb255100cf5d,
    0x3ff4ac400f891582, 0x3feda80adf9a6b6e,
    0xc001b508471c8e1c, 0x3fe4211d0aaaf5da,
    0xbfebefbcb27edef4, 0x3ff060e0589ece57,
    0x3fe4b8ff69709d1f, 0x3fe07d8e36b08b2c,
    0xc00ab3913fdf25bf, 0xbffbbd0ea619fa3f,
    0xbfe26bf9a51014c8, 0x3ffc827dff0f98f3,
    0xc00bac26f9b09371, 0x3feb106b10b4844e,
    0xbff01c6452b4ab4a, 0xbff2c69c0d0dc6c9,
    0xbf9947c909219460, 0xbff1d970b74841a6,
    0x3fe153eba0037a83, 0xc00018babeaf3b98,
    0x3fffdc80b060d2a8, 0xbfe711637343f652,
    0xbff731d7d4ebf529, 0xc008174d3cd1c62e,
    0xbfe30fbf9492e458, 0x3ff722842be93790,
    0xc0092479a5bf508a, 0x3ff235b2a01de254,
    0xbfc9f59253eb64e0, 0x400530b6cf468c3e,
    0x3fe2ddf8e2d11dfc, 0xbfdc0fb22f292564,
    0x400d8aacacf44f52, 0x3ff49bd3e5084069,
    0x40031bea8a3769c4, 0xc003703b46fdb21a,
    0xbfe702054419d1c9, 0x4006b70103b5f100,
    0xc000d3bba2c39d79, 0x3fbef712eb004ff0,
    0x400969a92feb8db1, 0x3ffe3bb6b4097dbc,
    0x3fef0de5f24b97d2, 0xbfa631e6febe28a0,
    0xc00233b80b51939a, 0xbff7233ce1b218cc,
    0x3f843e90e74a7680, 0x4000494b01a5adaf,
    0xbffb6acfbd93a97e, 0xbfef0f21b87c9424,
    0x3fff8c1f943083cc, 0xbfbd36e8cfeec440,
    0xc0040ecfa6b87e04, 0xbff21d50902a1892,
    0xbffc860a235b1447, 0xc0023a7fd220d4aa,
    0xbfe4783740ea950e, 0x3fd827c076a26f85,
    0x3ffeba1dc5dfc4ea, 0xbfd566a47c584ae1,
    0x400331c174cc8b65, 0xbff993ca250fa39a,
    0x4009b3c12f5b99aa, 0xbf9100b0fbc09100,
    0xbfbba431bd627ca0, 0x3fdc6febae30de13,
    0xbff0aaeac2b628ce, 0x3ff20b2689455107,
    0xbff04f5c2f632572, 0xbffb470e640635b2,
    0x3fda61980ae7f8c8, 0x3fdddcc96a676246,
    0xc001ea20d43ad4a6, 0xbfe28a2b61bfdd40,
    0xc008a9f8bf846f2a, 0x3ff1cf4bfb33e514,
    0x3ff1b67018624797, 0xbffda25c8c063354,
    0x3fdb3e557d0e01f7, 0xbfec84090a81f610,
    0xbfc3f72bad7dd9d8, 0xbfe90b3d2a61b51e,
    0xbfea78f2f7c71e79, 0xbfd65ddac46b9684,
    0x3fdc43ae2111da44, 0x3ff0a1c53800d714,
    0x4002a27c133710ee, 0xbff80ebd3e6b52fb,
    0x4002b67562d76356, 0xbfe2a628fa91aabd,
    0xbfd0d0013abd416c, 0xbfd4768545a1d180,
    0xbfda5b9c25662dfa, 0xbff4f4cdda60bb16,
    0xbfdace3656563664, 0x3fcc346c039433bd,
    0x3ff113b3b47a9df0, 0xbfd4f0e2217ef3b4,
    0x3fe6fe6a87717815, 0xc002a78954d70130,
    0x4005d9ecae2b7594, 0xc00350db0db29791,
    0x3fc6b2be474b4e40, 0x400a526cce3d4dd8,
    0xbff15c68e26f4a2a, 0xbff21d3aaccb5622,
    0x3fee47663c8c7578, 0xbfc1863b2ef4ec0c,
    0x3ff4997069df1432, 0x3ff359dd48ac5c2c,
    0x3ff53dd480f2b8b7, 0x3ff79387025c3453,
    0xbfdba865806f7e36, 0x4003ff2d461de6ef,
    0x3fd1c3b6a2a5574c, 0xbfefea48fb1ef773,
    0xbff6ff29db720afa, 0x4007e10b5984df60,
    0x3ff44102d6f5e242, 0x3fecb07db6973c8e,
    0xbff5903b26ed9028, 0x3ffe68f61299feee,
    0xbfd3b2454dda9fe0, 0xc00418253b572dbc,
    0xbff35b60c6f128a0, 0xbfee65f4205c3b86,
    0xbff8629753565cdc, 0x400dba1fcd91b0d8,
    0x40027a8cdf36e024, 0xc00a665067e2d08a,
    0xbfb050c5aeb315a0, 0xbfe5dfe408795058,
    0xbfd3eff49d56aee0, 0xbff2cb1b50da5418,
    0xc006c71a415607c2, 0x3ffe9dcf8bbf078c,
    0x4003456e603e67a6, 0x4004ea6b08c3393c,
    0x3f908653202e44e0, 0x40103fd68be2329d,
    0x3fb83b1f9461c560, 0xbfd20c716b1ea214,
    0xbff76e5ac9f566d8, 0xbfa6660dd800c2e0,
    0x3febce9b4a9ee230, 0xbff87f7f8e8b987a,
    0xc00f300446165fa8, 0xc0018bb5fff5d0bc,
    0xbff1e2efdcea9b90, 0xbfd36edc6403d280,
    0x3febb4c0939e4d4f, 0x3ff2a51e6ad0becb,
    0xbfb7c0ca4b1df6f8, 0x4006b9e4b9cd78a2,
    0x3ffd9289d530982a, 0xbff9820801e21b44,
    0xbffbb1455a5f200e, 0xbfc80a7e44175620,
    0xbfe5ec7daa6a2c7c, 0xc002ca2408ca6f09,
    0x3ff40a5f1b41559c, 0xc0036aa7bb25b502,
    0xbfe5c87d477a8188, 0xbfe8e9a447aaebf9,
    0xbfed1ccc1e269f6e, 0x3ffa37605cca6962,
    0xc00c0fe36bcf4519, 0xbff00e917f0518f5,
    0xbfecd2996ff7dbbf, 0x3fe930e3180e2e58,
    0x3fe5932b351a25af, 0x3ff29116872b1140,
    0xbfe29901aa5031d2, 0xc0080bb9567676b6,
    0x3fdcb7d9128a3594, 0xbfeaeb5075715520,
    0xbfec9b5f10868842, 0xc0010480a46eb19b,
    0x4009b42abe7100f6, 0xbfeea3f84ab2e030,
    0xbfeb7c00e5019200, 0xbfeb755c51779e5e,
    0xbff68c7867971724, 0xbfcec12c25ee65e0,
    0x3fc1c08be6afadcc, 0xbff9220dcc88b1be,
    0xbfe14e55b0de2502, 0xbfd4e2efb6f8c61c,
    0x3f61be77e420fe00, 0xbfd95ffaed6a3b78,
    0x3fe74199a65ba5c4, 0xc01099b9a3103bcf,
    0x3fbc4a1862ab9e10, 0xbfe1a070799f9143,
    0x3fd664f12ae4c260, 0x3ff00498c893ec9d,
    0xbfb78d7ca3c893e8, 0xbffad696cc05a762,
    0xbfffc9fce2e347c8, 0x3ff371e91aee53fa,
    0xbff22b9e8d5d2b49, 0xbff7892e60962eb4,
    0x3fba47848004df8c, 0x3fe1499416ff8d3a,
    0x3fba475918e9e9e0, 0xbfeb705b5e083924,
    0xbfe00fc3553f9ce0, 0x3fe6979c87b4e3c9,
    0x400547d59adaa629, 0xc012b189ed1d5815,
    0x3fe7339d081b9e74, 0xc0027c7f0590ddb4,
    0x3ffd51afe5fa8d2a, 0xbffb8d9db76947de,
    0x3fe209c3bcbfcf18, 0xbfff9b1f50c2581a,
    0xbfeae02ee898726a, 0xbfd21580eaa6e6ce,
    0x400a97672e2eb0ad, 0x3fd874eeb2ad5ae0,
    0xc0042af62f14e018, 0x3ff80b9c53c3c572,
    0x40036ea92dec4d5c, 0xbff244fc3abdbd61,
    0x3fe098b78628efea, 0x3fe672fcad42cc6e,
    0xc0090e765457fc64, 0xbfe4cad989e72856,
    0xbfee211693d3da0b, 0x3ffafb56aa85b42a,
    0x3fe3f725b1c380f4, 0xbfe5c3fa8174e281,
    0x4002c0e93203705b, 0x3ffd84b0b4eebbb2,
    0xbfe3ef0327d0c14b, 0xbff2a2f28b7e5414,
    0x3fbc563a2a2c6ec8, 0x4004c4a417737c68,
    0xc0037494b9f10e18, 0xbfd0469de6803330,
    0xbfeac0b8ae3ac2fe, 0x3ff0fa0ec7d32850,
    0x3fffbf4609e2d3e1, 0xbfeaf884a837954f,
    0x3f946546f45092a0, 0x3fdf0a4df98cb450,
    0xbff876e69e547297, 0xbfe188e50b54af60,
    0xbffff3b1d6c396a9, 0xc0107ca9c104636e,
    0x3ffd005fc5bbafaa, 0xc008deea67c76488,
    0x4015f1015c246e87, 0xc00037984a59c443,
    0xbf92c33092f8af40, 0xbff2f6af750a5683,
    0x3ff760b41592c85a, 0xbffd4e14991df010,
    0x3fd66eee7e0f4746, 0x400a65aee0b7aa6c,
    0x3ff5720334bf8b44, 0xbfe18c4ec4a6b96b,
    0xbfe2de1bf104b680, 0x3fdc5f2d0b6fbd04,
    0xbff158f99f477eac, 0xbfe86048c22d12eb,
    0x400689bef155f654, 0x3fddd3406f9a2790,
    0xbfcc9c98e10cf378, 0xbff308ad86b5b8a0,
    0x3fe230f5cda14986, 0xbffb5da6ac7bb3d4,
    0xbfda9e95d0a90a10, 0x3fd5365e65435170,
    0x3fef4f08b7cc814c, 0xc00ac04901042c34,
    0x400140ae14ae8755, 0xbfd7966ec021d6f7,
    0x3fd81dc1ac8e2210, 0x3fddcaef46ff1e38,
    0xbfe109e82fb813fa, 0xbfba87a2172147c8,
    0xbfa37285e1aa7850, 0x3fefcb5180be55c6,
    0x40093a5d07a02248, 0xbfe5e8e7533489af,
    0xbfd2f562b6394be8, 0x3ff087dd16594018,
    0x3ff3db27e6a7ed51, 0x40045bf87c333cab,
    0x3feaf4635016a2c0, 0xbff6541953ddbec3,
    0x3ff4f1b1c9ff0e57, 0xbfcc5ccd314dc298,
    0x3fb4516d3ee0e3f0, 0xc0022e1ad928bc1a,
    0xc00419cc4091c842, 0xbfb78661638e0488,
    0x40013769e9056832, 0xc00575d5f32dacfc,
    0xc00195084e52eb3c, 0x4006e355416fbb47,
    0xbff7ffbe4f39ff3c, 0x40056bcce23502ac,
    0xbff425b332e0dd76, 0x3fbb8c6a7e670b80,
    0x4003101adc66e2c4, 0x3ff5870915d7a353,
    0x3ffa51824549a8ce, 0xbffbcf6e3b3bfce9,
    0x400735ace0592361, 0xc000946bcfceecc0,
    0xbfee0324f25b7090, 0xbfe5609322aa6246,
    0xbfb3bad323d885b0, 0x400917f6d67d880e,
    0x400d8300dba3d6fa, 0xbff077773476aa3f,
    0x3fd53c6156f2006c, 0xbffc621316272d52,
    0xbff583b12f9035e5, 0x3fd2147b97714bd6,
    0x3ff6eeb28666ee76, 0xbffd7d9526b34034,
    0x3ff8b63857ac5f74, 0x4002cd3ae0e26844,
    0xbfeb6e7febdba895, 0xbff47f79649c9f04,
    0xbff9453aefb63f22, 0x3ff063c564048dd0,
    0x3fedb1f298eeaca5, 0xc002da13172e28f2,
    0x3fb75696bcd75710, 0xc0028c76304b7464,
    0x3fd70add9284794e, 0xbff02251e5f69a85,
    0x3fc5c0f169e126e4, 0xbfe80ee05cc53b95,
    0xc00a046a00d3e961, 0x3fb8bb12a548dbcc,
    0xbff9eb5cafc998a2, 0xbffa13c291bc3cc1,
    0xbfe8c3b70593529b, 0x3ff95ef598918ee3,
    0xbfe66aca3a6a4ba4, 0x3ff54f86671092a2,
    0xbfff74a6595f0acc, 0x3ffb6e49e67263d0,
    0x3ffeb1ecfe4526eb, 0x3ff0da91e4ded70e,
    0xbff42c2447b22b9e, 0xbfe72c5d5b24994e,
    0x3fd240e60cf0d461, 0xc006fd468b1c8e7b,
    0xbfefd2f51fdcefcb, 0xbf9a1098668226a0,
    0x3ff8486ac2db1a6e, 0xbfd84a2409a3efc0,
    0xbff1ebe1f9b3d2cc, 0x400b974541a6bbda,
    0xbfdedb86a928a048, 0x4008d2310fe0fac6,
    0xbffa0876dcf8691c, 0xbfb06e533c39cab0,
    0x3fd07d5de0c1faba, 0xbff7adb2bbb12f69,
    0x3ff1599567f98b1e, 0xbfe55fcee0e434ea,
    0x3fed3512cb8b900b, 0xbfeb423e58e42a1e,
    0xbfd371da3279a348, 0xc001afab3eb2c525,
    0xbfda6affda243ec2, 0x3ffb4944a6ec821f,
    0xbfced1989edbe418, 0x3fe0c79bb8be3b06,
    0x4004592028f1deb6, 0xbff066ec1487e1aa,
    0x3fc9e22e409910f0, 0x3ff9bc305a76f590,
    0xbff3d3d8fd1fe2ed, 0xbff5cd24642f7326,
    0xc00ff818bda4c580, 0x400532e31d8a8895,
    0xbfd618df14d16295, 0x3ff28480ff66d1ae,
    0x3ff931a60c14ca9e, 0xbff05dde76397548,
    0x3fc87748a16d02e4, 0xbfbcde7f94712b50,
    0x3feb0f900dbac1fd, 0x3fec1b3715a6b023,
    0x3fe1266d9e6d40dd, 0x400af83242124906,
    0xbff34112b5a32554, 0x3fe5e2f5a08ca5e9,
    0x3fdc6568bf957497, 0x3fdf336b1189269e,
    0xbfd452493e4e0fc8, 0x3fc44b6dda644c92,
    0x4003ccd81514dede, 0x3fd0693bceadc860,
    0xbff0ef6be5d018b6, 0x3fec1a7bbdc7758c,
    0x3fd8c069a2982b60, 0xbfffcd7b6444697c,
    0xbfce37318a9b6a00, 0xbfe1f3db1779b242,
    0xbfe4c87f658330c6, 0xc00619bc76f5516f,
    0xc0033f040ff68b18, 0x3f9b9088b59112a0,
    0x3fcae23a5aa4093c, 0x3f830c0b0df1ae80,
    0xbffe0964ad310856, 0x3fee4002f72469e5,
    0x3ff26b47a36f717f, 0x3ff6ea38c9cc95ef,
    0xbfec4099862265ae, 0x3fd6d2b36b004cf2,
    0xbfeaa4545903af45, 0xbfe83944fa82c727,
    0xbfe2190402c93b3a, 0xbfdd7b5afc9690e6,
    0xbff9e0758fd48557, 0xbfdae34a424d5500,
    0x3fc47394ad07ea68, 0x400c0435b32f1bb6,
    0xc00db5c9264e355c, 0x3ff5ff03b1c1c9e4,
    0xbffc11da64b7f34c, 0x3ff28ee3b7386db6,
    0xbfec33a4be8a61d8, 0xc00ea91bd8800246,
    0xbfc5d23481bdf6d2, 0x3febde4e7449bf79,
    0xc00a48ac18b57e53, 0xbfda2d11794e1f20,
    0x3ff280e904dee594, 0x400867307ad598f7,
    0x3ffcd5cdaaca5395, 0xbfd530a3e163d31c,
    0xbffa58e4bd771dc6, 0xbfcd5dafc898f777,
    0xbfe09e06a159b404, 0x3fdd37576a4c2baa,
    0xbfc0c321e2c327d8, 0x3fe0ee1b725185aa,
    0xbfdd9b87bf3c0604, 0x3fe19a3b8af2a7e3,
    0xc001804b18a72d2f, 0xbff75fa5054fff4d,
    0x3ff9ca5b4fd88898, 0x3feec87f0053a968,
    0x3ff91c6ef81a75e2, 0xbfff5b952c7074ac,
    0x3fd71943d12d0c90, 0xbfeb98f82adbd8cf,
    0x3ffca8f253aeddb2, 0x3ff0e7190003ac3f,
    0xbfcb269669ddaa60, 0xbff5b9cbd7207485,
    0x3fe06ff3fe1e6bce, 0x4002e5bb3bd72a7c,
    0xbfe2ab052058c958, 0xbff82fb2c550ce52,
    0xbff8486b4173b049, 0xc000f9dde3943742,
    0xc0042bac79cf361e, 0x400310633356604a,
    0x3feac48d25b23870, 0x3feabc280b237506,
    0xbfe82f28cf1feb48, 0x3ffb35e97dbd8c97,
    0xbfee2291b61bbc52, 0x3ff042cc6dd6fdbb,
    0xc00277ab8a0a1698, 0xbffd839a8caf1224,
    0xbfe26a0b31ab2140, 0x3fffa081d20e1353,
    0x3fe5c3187a63a9c4, 0x3fefaa3dcc524ab4,
    0x3fb9caf001db2a90, 0xbffb384581c3796d,
    0x3ff7c06c8a1c9a19, 0x3fe8784b66b0a602,
    0x3ff241e83f31b834, 0xbff1f97f17d347aa,
    0x40020d1f95064a24, 0xbff75dcfdadd0403,
    0x3fb7aaec595fc770, 0xbfd13bba040a87af,
    0xbfc3c3f73a65e050, 0xbfdacbbf57d8e1ba,
    0x3fc9a8a4303ca120, 0x3fe873c5682bfa23,
    0x3fb84afb1dc12acb, 0xbfe5dc2cda962836,
    0x3fd7ab34bea5cd08, 0xbfef3fcb8e21a436,
    0xbff455826a93f66e, 0x3ff18397ea8738ce,
    0x3febfea7cb996b2d, 0xbff7d92de8b77c2d,
    0xc00566d79b5798f0, 0x3ff5bc8b85d3b549,
    0xbfee9b4bdb8c62ac, 0x3fd5aa713d290270,
    0x400ac58802ee1c92, 0xbfd5f2d9982c5dbc,
    0xbfe19227e389379e, 0x3fda2a2671cebd14,
    0x4002aa8ade41028e, 0xbfe31249affbfdff,
    0x3ff629ff77903bba, 0xbfedccb5368208af,
    0xbff12eae388ae126, 0xc00d264791484704,
    0x3fd717b13abc9f68, 0x3fff035e77ace969,
    0x4001591736bb22fa, 0x3fc3d43869193bb8,
    0x3fe38d7c5cef121e, 0x3fee2b1c40bdf9ba,
    0x3f34b95c0431c800, 0xc002537afaa7fff0,
    0xc003491364edde87, 0x3fea0a6ef2c32a64,
    0x4001eb6954aeee75, 0x3ff1103f19b978b8,
    0x4001291a80e9da3e, 0xc001fab28e3d201e,
    0x3fa34c28d866a1c0, 0xbfe319449d1b225c,
    0xbffe3d452713bffa, 0xbfde6ebf9bd085a6,
    0x3fcb5cb08c06e240, 0xbffe0d20ce1bc5e1,
    0xbff975dc4e1b0396, 0xbfeff6cddc6857ea,
    0x3fefc720198dbe4a, 0x3ff1ae4507cd91d8,
    0xc0076f3fe2378a44, 0xbff246b256a01de8,
    0x3fc094f7a9a4c32e, 0xc0068abcd3acb198,
    0xbfd61795dfeca94e, 0x3fe3137ad0e0fa1b,
    0x3ff0ef530382fcfc, 0x40100d8a3e60f107,
    0x3fcdf089647d3fb8, 0x3fe9e4ecd738a090,
    0x3fe74715e98a9315, 0x3ff7aae6e2e44493,
    0x3fdacb3fa4ba9925, 0x3fee8dbf72aedc1a,
    0x40044a3048c536c7, 0xc002e3e6263ba1d4,
    0xc004e6ae885a1948, 0xbfd465078ad09294,
    0xbffdb76d50b1d354, 0xbff31a43bd9dff01,
    0xbfe8ba9f74e27c86, 0x3fe4582a5f6517f0,
    0x3ff895fdaa4d3a45, 0x3fd50ca382775f8c,
    0xbff13095590647be, 0xbfdbe3be7d795df4,
    0xbfbee48c92f9d2d0, 0x3fffdc3042e2b1fd,
    0x3ff986df01ea2554, 0xbfe621f53f495e47,
    0x3feb43ea47997b86, 0xbff2b564152a6b0c,
    0xbf96df1b1d4c57e0, 0x4002dc6dbfe87083,
    0xc0030d800e6852bc, 0xc00a987adb63305d,
    0x3fd3a1357879fe3a, 0xc0018b7d3aa1c054,
    0xbfe5a1e879a08d5c, 0x3fea86ec8d816d10,
    0xbff6be41ced22b38, 0x3faa6f00dd96b700,
    0xbffc430dfdcba616, 0x3fe51b5f5fa6fe66,
    0x3ff9445de36e36ce, 0x3ffd68cfbd0b0ceb,
    0xc009e5d378ecf205, 0x3fe75c4437e37cda,
    0xbffb705818c13e80, 0xc003d63d21db240d,
    0xbfd816ad18cd6c6a, 0xbffbd20d7eceac6a,
    0xbfce3dd3c6748062, 0x40052dd2c17b6ee7,
    0x3ff8a49d3ada420e, 0xbff44a2459983f4d,
    0x3ffaf79057053fbc, 0x3fcf31f35ae8c602,
    0xc0075842faa11102, 0xbfc1c06e9627b3f0,
    0xbfeeb0eda0c7a0ec, 0xbfc0a55aa942ebd4,
    0xc0132742544d0cf8, 0x3ffcce09b4b0a761,
    0xbff97708391a391b, 0x3fccb156628a35a0,
    0xbfa648ee0af32cb0, 0xbfb1d912188f5438,
    0x4000bef119dd524a, 0xbff713e398026257,
    0xbfe7450afa1e9d3d, 0x3fe20c64ddae0258,
    0xbfb8d989abed5104, 0xbfd3410f36d02956,
    0x3ff440f23f538237, 0xc006bb7a4b105747,
    0xbff6861a8c40d2c6, 0xc004598055dc32d5,
    0x3ff0e8691a9c153b, 0x3fe68aa51c613db0,
    0x4000ac4c5649ffc9, 0x400be4919e78c425,
    0xbfb2f4597fa3aa84, 0x3fe1aa786f40d25c,
    0x3fd178930859c95e, 0x4005a3e574eab180,
    0xbfef0394f9d43df9, 0x3ff4aa42efe87bc8,
    0x4001b31d5ccf4da7, 0x3fed1e48700873eb,
    0x3ffd7cceebe10fcb, 0xbffaace70aabad5f,
    0xbffd5d856572d5ea, 0x3fe86319ce86249e,
    0x3ffe11f24f8b2e81, 0xbfcf2217d34d9790,
    0x3fcdb6e3762990e8, 0x3fed4727ec179753,
    0x3ff7703e718aae2f, 0xbfe63a508a502088,
    0xbfe2105785e693e0, 0x3ff401bd37fcead0,
    0xbff49720c4737511, 0xbfdc007d15060e48,
    0xbfd94ec9d1f19c38, 0xbfc29fbcbff9a318,
    0x3fe5e977bf554b40, 0x3ff18275990a35fc,
    0x3fe7c1ebf0714081, 0x3fe9f3c91a709b0f,
    0x40034f958ebcd66d, 0xbffe7a1dceba6bc8,
    0x4005835f8b6dd78c, 0xbff9c8d1cbd3536c,
    0x3ff472f6105d836d, 0xbfe67a869745b05a,
    0xc001d2874c681102, 0xbfe1f2545876b386,
    0x4005e99bedf23ae3, 0xbfdc7e84c2ca3a2a,
    0xbfe61b48a60c19b4, 0x3fd24012e56ed30a,
    0x3fbf133b92c400e8, 0x3ff78c6ae4886a4d,
    0x3fe85083e03bbd67, 0xbffe237d11118cf5,
    0x3ff896e36a8b00d9, 0xbffeed66188434b2,
    0x3ffd1b5ce23cb02f, 0x400744cb9ee30e40,
    0xbfd8635472ded212, 0xbfeeaaee7b0385f6,
    0x3ff60e8d33047ddf, 0xbfc29906bb1fa1e8,
    0x3fd2923f2e99a17a, 0x3fd1844fbaf33476,
    0xbfd1751089ec0fb6, 0x3fecfb7e99d89500,
    0x3ff6d66a706013be, 0xbfe8fe28de01b716,
    0x3fcb2fd4f96733bc, 0xbfe0a6ab74b75000,
    0x3fe5c96890311550, 0x3fdc464982cee30a,
    0xbffe9934c65c9795, 0x3ff6a2f31a8d2f34,
    0xbfffc37270892a55, 0x3fe57fcb1cadb380,
    0xc007b5366b0582c1, 0xbfb68f7c42efbee0,
    0x3ff3f7950fca3751, 0x3ff0784bbe9fbd2c,
    0xbfdb900fe6ed0f00, 0x3feb3c3d920c7fce,
    0x40002f7c6846b07c, 0xc001732bd61f28e8,
    0x3ffc75b14ae1c134, 0xbfbd30ecc1815b10,
    0x3fea2569afdc4040, 0xbfefb74bbda3f93a,
    0xbff8eb5275077d7c, 0xbff1229b8515c618,
    0x3fcad47b7fc857c8, 0xbfe30398e2d854e6,
    0xc008bb3b19cd00c6, 0x3fc98eca8d9ce656,
    0xbfbf4dad2298cb00, 0xbfed5ed6f54eb6a7,
    0xbfed48887e01e66a, 0x3fea11a8bbefd064,
    0xbfccae18873624e0, 0x3fcf237090cdbfd8,
    0xbffa57241bd8ed3b, 0x3ffb461b952f6a40,
    0x3ff0571187a85138, 0xbff8a9b238b610ca,
    0x3feb76776602f1b9, 0x3ff0519bfaf92074,
    0x3ff95254e51b80ed, 0xbfeba12f3dc812ce,
    0x3fe602e8a634c670, 0xbff2341bb995e11c,
    0xc003e4a121d13f9e, 0xbffc542fea9fa450,
    0x4004899959826283, 0x3feeb47af9851db6,
    0x400f077e31ffdda3, 0x3feb173dc3681861,
    0x3ffa4736e9bb7f9b, 0xbff7b86218ca0f53,
    0x3feee388dc2eced1, 0x3ff75516f0403ac6,
    0x3fddd20491ea617e, 0x400b15c6a4d2416c,
    0xbff302bd88de0af8, 0xbfd5fee30fff6d87,
    0x3fd55deb86d36ef4, 0xbf80b1f3c0911fc0,
    0x3fe0ae16dfc2a44a, 0x3ff59c610ce1f444,
    0x4001e7b20bfffbd5, 0x3fdfb7ccb8012644,
    0xbff4a525d6a5bf86, 0xbfe634bf3ed4d8ad,
    0xbfc733f81f4e9ad8, 0xbff5b31fdf5046be,
    0x4003d24b1fac2b03, 0xbff647099fe9645b,
    0x3fbc8a6f11e24540, 0x4009eff3d9768026,
    0xbff8651bd0fb57e0, 0x3ff710bdff38e3e6,
    0x3fefe5fc4b015ef6, 0xbfd51c942e0fc7f6,
    0xc0076785ec64ae96, 0xbfe0c4ddc397ab21,
    0x3ffc4121021b2f64, 0x3fec40eff609afbe,
    0x3fd64b720bae40c1, 0xc0007a7c4bc13e92,
    0xbff10e9d5c11d6cb, 0x3feabc01812364bc,
    0xbfdb9646f334f790, 0xbfccc49e125015e8,
    0xbfd575d713b9a8a8, 0xbfe99ee240c7d1fc,
    0x3fd1ef6ec07a3dfc, 0xbffae40cf2c1cf9d,
    0xbffa6337f04d26dc, 0x3ff0e056ff752ad2,
    0xc00975825dd1a520, 0x400a13b42273162a,
    0xbfe4e2fa57204fad, 0x3fc088066b873d1c,
    0xc01668d28b6e2336, 0x400626fbf967b3b4,
    0x3ff9a54e20777e93, 0xbfef93a0f4221c9b,
    0xbfeb9fb91bfc5a13, 0x3fea90d20fee7ed6,
    0x400b860a3d7f28ae, 0x40017051fe1f8eac,
    0xbffdf291317c8177, 0x3ff802658530fde5,
    0x3fff9a54c2b69504, 0x3fe828993fc3c22b,
    0x3ffd6961418f69d9, 0x3ff09c44574675b7,
    0x3ffd074b3252864a, 0xc0002dfce1d1ede0,
    0x3fa2cbaa0f32c320, 0xbfba78a2d261b9d0,
    0x3fd6d3e972091e95, 0xc004197594f3c203,
    0xbfe14061c2d5c23b, 0x3ff8a178e7e2b7a4,
    0xc008565faa0ef87a, 0x3ff214b40c374ca8,
    0x40082dfce71558b6, 0x3fe88c190b19e050,
    0x401071a1462c7ef6, 0xc019f545f7e746a1,
    0x3ffdc6bca8cfd8f0, 0xbffaa271e1334aee,
    0x3fb8e0b74585ee50, 0xbfeb72c8f8689eb8,
    0xbf9208ab9bfeef60, 0xbff08ec100fc72ce,
    0x3fd408b351aba252, 0xbfd99643a12aa42c,
    0x40012f4a51ee7cfa, 0xbfe8a4cfdac3f75c,
    0x3fff9f4b02d585d7, 0x3fdfb7cab2511131,
    0x3fff6e15da27532e, 0x3fe61f938a27ba46,
    0xbff199afcfee6898, 0xc00f248326d85286,
    0x400c0537fa417fdf, 0x3ffcdba372a2e3b0,
    0xc0109847b188c028, 0x400688a8b684f85f,
    0x3ff3cde9c67f31ed, 0xbfdede36bc447403,
    0xbfd19255d6e8ad46, 0x40016442986ee44e,
    0xc004ab214073c540, 0xbffea7ba983398a4,
    0xbfeea6c983c65ee6, 0x3feee592533b0f77,
    0x3ff102add34cb2df, 0x3ff512211d90bff8,
    0xc0033c757f991fe4, 0x3ff84a3f3e77c0f8,
    0xbf95ae94357ee030, 0x3fe6be181fa907f6,
    0x3fc2558222abe2fc, 0x3fe11d4efd8e93d5,
    0x3fea66e4f9d6bd50, 0xbfecf281787d637e,
    0x3fd3631d9da50174, 0x3ff8df575d749305,
    0x3ff8df54259d78ca, 0x4009fb2e1d059ea8,
    0x3fef6d47422bab4e, 0xbfee17ae05ead466,
    0xbfdcd50c72d60614, 0x3feb7e8e86ddb2b2,
    0xbfd47625e5c59fb4, 0xbfcebf68e764d7fe,
    0x4003a4ee7d235d46, 0xbfec26b940a0dc2d,
    0x40042c3d67348d74, 0xbfe47fb8f390078d,
    0xbff2dc164a9563ca, 0x3fee54d36e6a9d0e,
    0xbfd2e6284e0d6080, 0xbff6d0dc7c0664e4,
    0x3fc0a08dcec70f9a, 0x40026a2e6304b4f5,
    0x3feabb6b34cc6392, 0xbff08ebbb695a9fa,
    0x3fef7e9ac4577913, 0x40067badd2648fce,
    0x3ffce8c553d4aea6, 0xbff98fe8b08ab06e,
    0xbfc3779a2dec081f, 0x3fcfc0895c7d534c,
    0xbfde924804bd6aef, 0xbfd3f3cf40f2f2b2,
    0xbfe0e581c78130e8, 0xbff77e152db9ccfd,
    0x3f8c036b894089c0, 0xc0046c6718ff8ca1,
    0x3fea4afc95c24ae1, 0x3fddc87cff6becff,
    0xbff427cb7dd4f60b, 0xc00180eaf251ffd9,
    0x3fe5ed77ab6cf3cb, 0x3fe2c3f68baa8faa,
    0xbff183916fc2aa6c, 0x3ffb7eae343e32c6,
    0xbfe92e1d0d65e5dd, 0xbff91c835f8daba4,
    0x3fd579b22b889691, 0x3fc2c68ca5d70908,
    0xbfeb644e3732e246, 0x4001fc3b59cfaa54,
    0xc009405cd4d2c009, 0x3fe7c8a6ce0a1700,
    0x3ffc2c601339f9a1, 0xbfe82f487a321534,
    0x3fe5d9191858cbd6, 0xbffb1c0dbabf6691,
    0x4000b6824022888e, 0x3ff75f35c9e55ea2,
    0x3fcc8ba6f25b9ef4, 0x3fe2f461e6f6af21,
    0xbfdb70544573a30c, 0xbfdf1ac5e8e40bed,
    0xbfe18dbe9e732b9d, 0xbff348f6097054c7,
    0xbff172025ee3d342, 0x3feef9836a58ade3,
    0x3fe483fd3805ab38, 0x3fe5ad7ee538eebc,
    0xbfe3812e05696017, 0x3fd2ffdcbf2a2c54,
    0x3fcf386b91d5f670, 0x3fe58b08a687a7e3,
    0x3fc76f315c9d4be8, 0xbff50da452ea8e9f,
    0xbfed35c8979a2def, 0xbfe7167c528f1145,
    0x3fdd3c8165c7db08, 0xbff84897d004cca8,
    0x3ff5e45c956e4f8f, 0x3fe85f7e36bec91a,
    0x3ff9c2150935f570, 0x3fdae2d31b3daf20,
    0xbfe988bd0bea419c, 0x3ffc26f87b0b807c,
    0xbff88105dbc5dfa4, 0xc0078365b190723a,
    0xc0077c2a72e74476, 0x4002fb9676ff2182,
    0x3fd7dd2659fe4550, 0xbfe9a62d17d4863a,
    0x3ff4d3ce88150182, 0xbfeac8f8019dc7a8,
    0x3ff38e8efeabec56, 0x3fb24e337db3b398,
    0x3fde104030896766, 0x4000d448699226b3,
    0xbff990fd387f8ad4, 0xbfee6b2646094b96,
    0xbff86dfddb3784d0, 0x400277d4476aa86c,
    0x3fed5875cc787118, 0x3fcf57cb09b13694,
    0x3ff0cd49da7ee84b, 0x3fd33a85cc238e94,
    0x3fff52e90c4bb75a, 0xc00d14449ceb480a,
    0xc002be4bb7acffac, 0xbff62dfef42a283d,
    0x3fdaa83f495c2756, 0x40055ba1c2b9bf51,
    0x3fa458e9d4d817a0, 0x40014e5b16e5b307,
    0x3ffb595992022678, 0xbff089ed81ef87e0,
    0x3fcbf4be4669fc80, 0xc001bf7e9172c9a9,
    0xbfe7286f1fbb5528, 0x3ffadddbc97dce22,
    0x3ffa5fabd1a2efc1, 0x3fd728b659985bae,
    0x3ff9f84b739eae08, 0x3ff9322affd82055,
    0x4001215081952a85, 0xbfe1568030c4cfcc,
    0x4005f7badbb5ea87, 0x4013a4a1281a5ede,
    0xbff2662d01479b33, 0xc0010d9e1ce4ac11,
    0xbff5334eb16eefa6, 0xc0095144cb79cf37,
    0xbff0779fd0efb26e, 0xbffd1254b3a89c80,
    0x3f9f3e1909934700, 0xc002ac49a4f7c0c6,
    0x400c8fb659f1a5fa, 0x3fcc78925c9f0512,
    0xbff962b937a508f3, 0xc0075d23d4466c8c,
    0xc006d076bf0dfea2, 0xbffd9c127d707c98,
    0x3fdf85eb56738ffa, 0xbfb3391d7a5111b2,
    0xbff2f2bc5bd51326, 0x3fe95e87d445bb1e,
    0x3fe34a808864cc28, 0xbfe5633a19ce1dae,
    0xc00c31d421c2ce02, 0x3fd652ac03dc3386,
    0x400548528ac801fd, 0x4009fa69db55fbb4,
    0xc004f8ed4a8dbe18, 0xc0101f173756c038,
    0x3ff498e62aa410f6, 0x3fe93b1a1e091184,
    0xbff04b272cb923be, 0x3ff19442745be07e,
    0x40031eba9592f582, 0xbff5f29d544320c8,
    0x3fd6957c7a3348f6, 0xc001750f200cd1d4,
    0x3ff93081c08a2636, 0xbf96440d93096bc0,
    0xbffd1ca26237d362, 0xbff42e2dd329dad6,
    0xbfffc066548cc7f2, 0xbfed01ce8b994aa2,
    0x3fe36f6dc3c4d182, 0xbfd06cd597a94a3a,
    0xc0087ed5a4ae2e1f, 0x400ba9786498456b,
    0xc00658c544440b6f, 0x3fb7bcc805b19e40,
    0xbfd3723e764ea90c, 0x400416a2856738fa,
    0x3fc1045887d617ce, 0x3ff0c897c93c7e55,
    0xbfca189afdf355aa, 0xbff4f66f28391b7d,
    0xbfd77274b6836516, 0x3fe360d59e08ad29,
    0xbfb4284e9e769cac, 0xbfeb3e54306bf03a,
    0x3ffbd65a05ef6c06, 0x3ff283c5770bca75,
    0x3fc95b803c068020, 0x3ff56c6d77a0f69a,
    0x40038a278355a676, 0x40073e728f745e3e,
    0x3fe54f1239b87b8a, 0xbfea66e020c38d4e,
    0xbfc6223180e230a8, 0xc0055739ab293278,
    0xbfd8cddd96e75000, 0x3fc9f753b373e31e,
    0xbfe632ec8015a194, 0x3fad10b62d234840,
    0x4004ab91e4b2183b, 0xbf91f02449f0c6b0,
    0x3fe44cf2531d8f83, 0xbfb626a4976a82a4,
    0xbfe5de85495ccef4, 0x3fed187381698d83,
    0x3fe9e235c1c42ac1, 0xbfdfe0ac30f66c20,
    0xbfcbb79e53322170, 0xbfd34efdcf120714,
    0xbfd69ddff7bfadf6, 0x3ffa090dbb22cff9,
    0xbfed4bd5564fc36f, 0xbff1035f6d0c8735,
    0x3ff06dd96f8d56e6, 0x4002bc0bf868d68c,
    0xbfcd602daf300626, 0x400f63a1892768aa,
    0x3ff6cc0f1c7070dd, 0xbfd5f6d25a00eac6,
    0x3ff327902e1c9e1b, 0xbfcd7578cab11436,
    0xbff148e7f2e93bea, 0xbff66381087aa98c,
    0x3ff51210519e914e, 0x3fcb551eb95a6cfd,
    0x3f51a80d8ba52c00, 0x3ffcd189e097ca1a,
    0x3fe3f09c45a067a4, 0x3fc39ebb205ebfc2,
    0x3fd47fefe336e4fc, 0xc00c461264f5c1c8,
    0x3ff44b7477bebc92, 0x3fec3d161dd67d43,
    0xbfea940df693e094, 0x4005a757bbfa181e,
    0xbfdd05aeea0275fe, 0xbfa44785ae649ac8,
    0x3fd1da0115a48094, 0xbffac3d972181b49,
    0x400b2177ae870c05, 0xbfdfe1a000f8685c,
    0x3fece15d4f402613, 0x3fe0964239a90e7e,
    0x3fc6e68666636888, 0xbffec7be2f889fb5,
    0xbfd90e7f577345e3, 0xc0030afbc345e364,
    0x3fd97c04e4d84222, 0x4001277065567b32,
    0xc0013d77bc3db1eb, 0x3ffb3d5f3387ec33,
    0xbfd94cd571f1f3f2, 0x3fdeff24ec5a655a,
    0xbff9099d2d441b24, 0xbffa0dad2df68605,
    0x3fe6e31ce2bacb8a, 0xbff0c6194a5dee94,
    0x3fdaeb6960c20a00, 0xbfcf12df424d79e0,
    0x3fea4d039c364e88, 0xbfe745ac696182a8,
    0x400fd41bb984d82b, 0x40015884ea5692f8,
    0x3ff9d448c9236a57, 0x3febd6a88d75f545,
    0xbffb3b626d23700d, 0xbfd22b601bee3710,
    0x3ff092f1e1110a61, 0xc00683a461436473,
    0xc0022c56bb76281c, 0xc003f9f5980a3ad2,
    0x400146aeadc53076, 0x3f66206736cce800,
    0x40078efe9930e0d6, 0xbff5971fceefe626,
    0x3fe853a5b55dd56d, 0xbff63ce9433b9d90,
    0xbfed47695c45c4e4, 0x3ff7aab6ef87a86b,
    0x3fd6581da294ee45, 0xc00a3c99f6c9e0ea,
    0x3fe15f4c721ced3c, 0xbffe733d8638a9dc,
    0x3fe28fd627ccabcc, 0x3fee29fc325e5959,
    0xbfd4fbc6a65bcaf8, 0x3ff1b32f0ffca982,
    0x3fdea08d13cb13d9, 0xbff9eae155889fbb,
    0xbff80a29d315fc4a, 0x3feaaaf8202571be,
    0x3fe5c6e6251c9f30, 0x400167be216e9f51,
    0xbfeaa6870d333e78, 0xbfb9577788de7020,
    0xbffc4ee13f0974d8, 0x3fdc146dc31165f0,
    0xbfc18f7f243f4166, 0x3fd290ac2a5c4eba,
    0xbfe8ce50652b8f89, 0x3ff15bb908b64f07,
    0xbfb0f3129f5777b0, 0x4006e263929c4b52,
    0x3ffa435f11ef3083, 0x3fe88aaba049a540,
    0x3fba3d6ca5a046e0, 0x3fde9ddee450ad10,
    0x3ffd22db99d76e1e, 0x3fdfcf76385dee06,
    0x3fe14a2c51dec5df, 0x3ffc05c5fbcb4d36,
    0x3ffeca006ea4df36, 0x3fe9e8f01654cac5,
    0xbfbae7fe07618b90, 0x3fc4b7b86303dd6c,
    0x400456221cbc19be, 0xc000ffb58f12f51c,
    0x3ffbd1a82755a6dc, 0xbff659ca448e8822,
    0x3ffb524ce8b24dd8, 0x3fdd518f619a4250,
    0x3fe88d6af48cbd75, 0xbfe80e63c9ad50b6,
    0xbfdb0769b099edc2, 0x400240313d255c49,
    0xc00cfd1c585a7517, 0xbff125dba22fca73,
    0xc00d9e288a78be22, 0x3fefc17eeb07cbf5,
    0x3ffecc23914c9d05, 0xbfea0a85e3175072,
    0xc007d02a4deee317, 0xbff7ebb96cb6663c,
    0xbfa43f7a53d75ea8, 0xbfe2fae52b72c094,
    0x3fff7c797563a099, 0x3fe2d6567c0ba4c8,
    0x4011fdf1e8e93182, 0xc007a65db7e7636b,
    0xbfe9e0561d6d2a9e, 0xc000ce435a644ec4,
    0xc005bb63070d3531, 0x3fe47715db811d20,
    0xbffd4eef1851a3ae, 0xbff19a7093f70b8a,
    0xbfeb30ceca472f60, 0x3ffee5d519a20164,
    0x4001445f67d092f8, 0x3fe1e23bbd8d01ee,
    0xbfdb1ecdabef61dd, 0xc001329f88c0f9c4,
    0xbff16a9c70410e84, 0xbf8c2d8516d4cfa0,
    0xbffcb923343b8322, 0x3fee1c13cf4e47be,
    0x400121c56e39e9dc, 0xbfd9005bc1ab2cd8,
    0x3fec3570a7070430, 0x0,
    0x400121c56e39e9dc, 0x3fd9005bc1ab2ce0,
    0xbffcb923343b8322, 0xbfee1c13cf4e47bc,
    0xbff16a9c70410e82, 0x3f8c2d8516d4cfc0,
    0xbfdb1ecdabef61d3, 0x4001329f88c0f9c4,
    0x4001445f67d092f8, 0xbfe1e23bbd8d01eb,
    0xbfeb30ceca472f60, 0xbffee5d519a20166,
    0xbffd4eef1851a3af, 0x3ff19a7093f70b88,
    0xc005bb63070d3531, 0xbfe47715db811d26,
    0xbfe9e0561d6d2a9f, 0x4000ce435a644ec4,
    0x4011fdf1e8e93181, 0x4007a65db7e7636b,
    0x3fff7c797563a09a, 0xbfe2d6567c0ba4c6,
    0xbfa43f7a53d75e88, 0x3fe2fae52b72c097,
    0xc007d02a4deee317, 0x3ff7ebb96cb66637,
    0x3ffecc23914c9d08, 0x3fea0a85e3175074,
    0xc00d9e288a78be22, 0xbfefc17eeb07cbf6,
    0xc00cfd1c585a7518, 0x3ff125dba22fca72,
    0xbfdb0769b099edc0, 0xc00240313d255c48,
    0x3fe88d6af48cbd77, 0x3fe80e63c9ad50bb,
    0x3ffb524ce8b24dd3, 0xbfdd518f619a4264,
    0x3ffbd1a82755a6de, 0x3ff659ca448e8820,
    0x400456221cbc19bc, 0x4000ffb58f12f51c,
    0xbfbae7fe07618ba0, 0xbfc4b7b86303dd74,
    0x3ffeca006ea4df38, 0xbfe9e8f01654cac8,
    0x3fe14a2c51dec5dd, 0xbffc05c5fbcb4d36,
    0x3ffd22db99d76e20, 0xbfdfcf76385dee08,
    0x3fba3d6ca5a046a0, 0xbfde9ddee450ad08,
    0x3ffa435f11ef3082, 0xbfe88aaba049a53a,
    0xbfb0f3129f577780, 0xc006e263929c4b52,
    0xbfe8ce50652b8f8a, 0xbff15bb908b64f06,
    0xbfc18f7f243f4160, 0xbfd290ac2a5c4ebe,
    0xbffc4ee13f0974d6, 0xbfdc146dc31165f5,
    0xbfeaa6870d333e7c, 0x3fb9577788de7000,
    0x3fe5c6e6251c9f31, 0xc00167be216e9f50,
    0xbff80a29d315fc4a, 0xbfeaaaf8202571b9,
    0x3fdea08d13cb13d6, 0x3ff9eae155889fbb,
    0xbfd4fbc6a65bcb00, 0xbff1b32f0ffca983,
    0x3fe28fd627ccabc6, 0xbfee29fc325e5959,
    0x3fe15f4c721ced3e, 0x3ffe733d8638a9d9,
    0x3fd6581da294ee52, 0x400a3c99f6c9e0e8,
    0xbfed47695c45c4e4, 0xbff7aab6ef87a86a,
    0x3fe853a5b55dd571, 0x3ff63ce9433b9d8e,
    0x40078efe9930e0d7, 0x3ff5971fceefe627,
    0x400146aeadc53076, 0xbf66206736cce200,
    0xc0022c56bb76281c, 0x4003f9f5980a3ad3,
    0x3ff092f1e1110a62, 0x400683a461436472,
    0xbffb3b626d237010, 0x3fd22b601bee3710,
    0x3ff9d448c9236a57, 0xbfebd6a88d75f541,
    0x400fd41bb984d82b, 0xc0015884ea5692f7,
    0x3fea4d039c364e88, 0x3fe745ac696182a3,
    0x3fdaeb6960c20a00, 0x3fcf12df424d79d8,
    0x3fe6e31ce2bacb8a, 0x3ff0c6194a5dee97,
    0xbff9099d2d441b26, 0x3ffa0dad2df68606,
    0xbfd94cd571f1f3eb, 0xbfdeff24ec5a655a,
    0xc0013d77bc3db1ea, 0xbffb3d5f3387ec32,
    0x3fd97c04e4d8421c, 0xc001277065567b32,
    0xbfd90e7f577345e2, 0x40030afbc345e365,
    0x3fc6e68666636898, 0x3ffec7be2f889fb4,
    0x3fece15d4f402611, 0xbfe0964239a90e82,
    0x400b2177ae870c06, 0x3fdfe1a000f86856,
    0x3fd1da0115a48098, 0x3ffac3d972181b4a,
    0xbfdd05aeea027602, 0x3fa44785ae649ae0,
    0xbfea940df693e093, 0xc005a757bbfa181e,
    0x3ff44b7477bebc8f, 0xbfec3d161dd67d45,
    0x3fd47fefe336e4fc, 0x400c461264f5c1c8,
    0x3fe3f09c45a067ae, 0xbfc39ebb205ebfb8,
    0x3f51a80d8ba52c00, 0xbffcd189e097ca1b,
    0x3ff51210519e914c, 0xbfcb551eb95a6d04,
    0xbff148e7f2e93be6, 0x3ff66381087aa990,
    0x3ff327902e1c9e1b, 0x3fcd7578cab1143a,
    0x3ff6cc0f1c7070dc, 0x3fd5f6d25a00eaba,
    0xbfcd602daf30060a, 0xc00f63a1892768a8,
    0x3ff06dd96f8d56e4, 0xc002bc0bf868d68c,
    0xbfed4bd5564fc369, 0x3ff1035f6d0c8735,
    0xbfd69ddff7bfadfa, 0xbffa090dbb22cff8,
    0xbfcbb79e5332216c, 0x3fd34efdcf120718,
    0x3fe9e235c1c42abd, 0x3fdfe0ac30f66c10,
    0xbfe5de85495ccef6, 0xbfed187381698d7f,
    0x3fe44cf2531d8f86, 0x3fb626a4976a82ba,
    0x4004ab91e4b2183a, 0x3f91f02449f0c6c0,
    0xbfe632ec8015a192, 0xbfad10b62d234860,
    0xbfd8cddd96e75004, 0xbfc9f753b373e30e,
    0xbfc6223180e230a2, 0x40055739ab293278,
    0x3fe54f1239b87b90, 0x3fea66e020c38d4f,
    0x40038a278355a675, 0xc0073e728f745e3e,
    0x3fc95b803c068028, 0xbff56c6d77a0f69c,
    0x3ffbd65a05ef6c07, 0xbff283c5770bca74,
    0xbfb4284e9e769cbc, 0x3feb3e54306bf039,
    0xbfd77274b683651d, 0xbfe360d59e08ad25,
    0xbfca189afdf355a2, 0x3ff4f66f28391b7a,
    0x3fc1045887d617b8, 0xbff0c897c93c7e57,
    0xbfd3723e764ea914, 0xc00416a2856738fa,
    0xc00658c544440b70, 0xbfb7bcc805b19e20,
    0xc0087ed5a4ae2e1e, 0xc00ba9786498456d,
    0x3fe36f6dc3c4d17c, 0x3fd06cd597a94a36,
    0xbfffc066548cc7f0, 0x3fed01ce8b994aa2,
    0xbffd1ca26237d360, 0x3ff42e2dd329dad6,
    0x3ff93081c08a2635, 0x3f96440d93096b80,
    0x3fd6957c7a3348fa, 0x4001750f200cd1d5,
    0x40031eba9592f582, 0x3ff5f29d544320c7,
    0xbff04b272cb923bc, 0xbff19442745be07e,
    0x3ff498e62aa410f6, 0xbfe93b1a1e091188,
    0xc004f8ed4a8dbe19, 0x40101f173756c038,
    0x400548528ac801fd, 0xc009fa69db55fbb4,
    0xc00c31d421c2ce02, 0xbfd652ac03dc3382,
    0x3fe34a808864cc24, 0x3fe5633a19ce1db1,
    0xbff2f2bc5bd51326, 0xbfe95e87d445bb21,
    0x3fdf85eb56738ff4, 0x3fb3391d7a5111a8,
    0xc006d076bf0dfea3, 0x3ffd9c127d707c9a,
    0xbff962b937a508f0, 0x40075d23d4466c8c,
    0x400c8fb659f1a5fa, 0xbfcc78925c9f0504,
    0x3f9f3e1909934680, 0x4002ac49a4f7c0c6,
    0xbff0779fd0efb26e, 0x3ffd1254b3a89c82,
    0xbff5334eb16eefa6, 0x40095144cb79cf36,
    0xbff2662d01479b34, 0x40010d9e1ce4ac11,
    0x4005f7badbb5ea86, 0xc013a4a1281a5ede,
    0x4001215081952a84, 0x3fe1568030c4cfcd,
    0x3ff9f84b739eae09, 0xbff9322affd8205a,
    0x3ffa5fabd1a2efbe, 0xbfd728b659985bac,
    0xbfe7286f1fbb552b, 0xbffadddbc97dce24,
    0x3fcbf4be4669fc68, 0x4001bf7e9172c9a8,
    0x3ffb595992022678, 0x3ff089ed81ef87e1,
    0x3fa458e9d4d81780, 0xc0014e5b16e5b307,
    0x3fdaa83f495c2754, 0xc0055ba1c2b9bf52,
    0xc002be4bb7acffab, 0x3ff62dfef42a283c,
    0x3fff52e90c4bb75c, 0x400d14449ceb480a,
    0x3ff0cd49da7ee84b, 0xbfd33a85cc238e90,
    0x3fed5875cc787116, 0xbfcf57cb09b136a0,
    0xbff86dfddb3784d0, 0xc00277d4476aa86c,
    0xbff990fd387f8ad1, 0x3fee6b2646094b8e,
    0x3fde104030896764, 0xc000d448699226b4,
    0x3ff38e8efeabec54, 0xbfb24e337db3b3a0,
    0x3ff4d3ce88150185, 0x3feac8f8019dc7ab,
    0x3fd7dd2659fe4550, 0x3fe9a62d17d48639,
    0xc0077c2a72e74474, 0xc002fb9676ff2182,
    0xbff88105dbc5dfa1, 0x40078365b190723a,
    0xbfe988bd0bea4198, 0xbffc26f87b0b8079,
    0x3ff9c2150935f570, 0xbfdae2d31b3daf20,
    0x3ff5e45c956e4f8d, 0xbfe85f7e36bec920,
    0x3fdd3c8165c7db0c, 0x3ff84897d004cca6,
    0xbfed35c8979a2df6, 0x3fe7167c528f1141,
    0x3fc76f315c9d4bf4, 0x3ff50da452ea8e9e,
    0x3fcf386b91d5f660, 0xbfe58b08a687a7df,
    0xbfe3812e05696018, 0xbfd2ffdcbf2a2c50,
    0x3fe483fd3805ab3a, 0xbfe5ad7ee538eebe,
    0xbff172025ee3d341, 0xbfeef9836a58ade6,
    0xbfe18dbe9e732b9a, 0x3ff348f6097054c6,
    0xbfdb70544573a317, 0x3fdf1ac5e8e40be2,
    0x3fcc8ba6f25b9eee, 0xbfe2f461e6f6af22,
    0x4000b6824022888d, 0xbff75f35c9e55ea4,
    0x3fe5d9191858cbd4, 0x3ffb1c0dbabf668e,
    0x3ffc2c601339f99d, 0x3fe82f487a321536,
    0xc009405cd4d2c008, 0xbfe7c8a6ce0a1700,
    0xbfeb644e3732e247, 0xc001fc3b59cfaa55,
    0x3fd579b22b889695, 0xbfc2c68ca5d708f4,
    0xbfe92e1d0d65e5d9, 0x3ff91c835f8daba0,
    0xbff183916fc2aa6e, 0xbffb7eae343e32c5,
    0x3fe5ed77ab6cf3c4, 0xbfe2c3f68baa8fae,
    0xbff427cb7dd4f607, 0x400180eaf251ffd8,
    0x3fea4afc95c24ae3, 0xbfddc87cff6bed08,
    0x3f8c036b89408980, 0x40046c6718ff8ca0,
    0xbfe0e581c78130ec, 0x3ff77e152db9ccfd,
    0xbfde924804bd6ae2, 0x3fd3f3cf40f2f2ae,
    0xbfc3779a2dec082a, 0xbfcfc0895c7d5354,
    0x3ffce8c553d4aea8, 0x3ff98fe8b08ab070,
    0x3fef7e9ac4577915, 0xc0067badd2648fcd,
    0x3feabb6b34cc6391, 0x3ff08ebbb695a9f9,
    0x3fc0a08dcec70fc0, 0xc0026a2e6304b4f6,
    0xbfd2e6284e0d6080, 0x3ff6d0dc7c0664e4,
    0xbff2dc164a9563cb, 0xbfee54d36e6a9d0c,
    0x40042c3d67348d76, 0x3fe47fb8f390078b,
    0x4003a4ee7d235d46, 0x3fec26b940a0dc29,
    0xbfd47625e5c59fa2, 0x3fcebf68e764d802,
    0xbfdcd50c72d60617, 0xbfeb7e8e86ddb2b1,
    0x3fef6d47422bab4b, 0x3fee17ae05ead460,
    0x3ff8df54259d78ca, 0xc009fb2e1d059ea6,
    0x3fd3631d9da5016e, 0xbff8df575d749305,
    0x3fea66e4f9d6bd4f, 0x3fecf281787d637b,
    0x3fc2558222abe2f4, 0xbfe11d4efd8e93d3,
    0xbf95ae94357edfc0, 0xbfe6be181fa907f4,
    0xc0033c757f991fe3, 0xbff84a3f3e77c0f9,
    0x3ff102add34cb2e0, 0xbff512211d90bff8,
    0xbfeea6c983c65ee3, 0xbfeee592533b0f79,
    0xc004ab214073c53f, 0x3ffea7ba983398a2,
    0xbfd19255d6e8ad4e, 0xc0016442986ee450,
    0x3ff3cde9c67f31ee, 0x3fdede36bc4473fb,
    0xc0109847b188c028, 0xc00688a8b684f85f,
    0x400c0537fa417fdf, 0xbffcdba372a2e3b5,
    0xbff199afcfee6898, 0x400f248326d85286,
    0x3fff6e15da275330, 0xbfe61f938a27ba48,
    0x3fff9f4b02d585d7, 0xbfdfb7cab2511133,
    0x40012f4a51ee7cfa, 0x3fe8a4cfdac3f75e,
    0x3fd408b351aba252, 0x3fd99643a12aa42c,
    0xbf9208ab9bfeef20, 0x3ff08ec100fc72ce,
    0x3fb8e0b74585ee84, 0x3feb72c8f8689eb2,
    0x3ffdc6bca8cfd8f2, 0x3ffaa271e1334aed,
    0x401071a1462c7ef7, 0x4019f545f7e746a2,
    0x40082dfce71558b6, 0xbfe88c190b19e04f,
    0xc008565faa0ef876, 0xbff214b40c374ca5,
    0xbfe14061c2d5c231, 0xbff8a178e7e2b7a4,
    0x3fd6d3e972091e9a, 0x4004197594f3c202,
    0x3fa2cbaa0f32c2d0, 0x3fba78a2d261b9e0,
    0x3ffd074b32528648, 0x40002dfce1d1ede0,
    0x3ffd6961418f69da, 0xbff09c44574675b8,
    0x3fff9a54c2b6950a, 0xbfe828993fc3c22b,
    0xbffdf291317c8176, 0xbff802658530fde2,
    0x400b860a3d7f28ae, 0xc0017051fe1f8eac,
    0xbfeb9fb91bfc5a12, 0xbfea90d20fee7ed6,
    0x3ff9a54e20777e92, 0x3fef93a0f4221c9a,
    0xc01668d28b6e2337, 0xc00626fbf967b3b4,
    0xbfe4e2fa57204faf, 0xbfc088066b873d1c,
    0xc00975825dd1a51e, 0xc00a13b42273162b,
    0xbffa6337f04d26dc, 0xbff0e056ff752ad5,
    0x3fd1ef6ec07a3dfc, 0x3ffae40cf2c1cf9c,
    0xbfd575d713b9a8a4, 0x3fe99ee240c7d200,
    0xbfdb9646f334f786, 0x3fccc49e125015de,
    0xbff10e9d5c11d6cd, 0xbfeabc01812364be,
    0x3fd64b720bae40c8, 0x40007a7c4bc13e93,
    0x3ffc4121021b2f63, 0xbfec40eff609afba,
    0xc0076785ec64ae93, 0x3fe0c4ddc397ab1b,
    0x3fefe5fc4b015ef7, 0x3fd51c942e0fc7f6,
    0xbff8651bd0fb57de, 0xbff710bdff38e3e4,
    0x3fbc8a6f11e24540, 0xc009eff3d9768026,
    0x4003d24b1fac2b04, 0x3ff647099fe9645c,
    0xbfc733f81f4e9ad0, 0x3ff5b31fdf5046bf,
    0xbff4a525d6a5bf85, 0x3fe634bf3ed4d8aa,
    0x4001e7b20bfffbd4, 0xbfdfb7ccb801264c,
    0x3fe0ae16dfc2a44a, 0xbff59c610ce1f444,
    0x3fd55deb86d36ef0, 0x3f80b1f3c0912080,
    0xbff302bd88de0af6, 0x3fd5fee30fff6d79,
    0x3fddd20491ea618a, 0xc00b15c6a4d2416c,
    0x3feee388dc2eced5, 0xbff75516f0403ac0,
    0x3ffa4736e9bb7f9a, 0x3ff7b86218ca0f51,
    0x400f077e31ffdda4, 0xbfeb173dc3681862,
    0x4004899959826283, 0xbfeeb47af9851dba,
    0xc003e4a121d13f9e, 0x3ffc542fea9fa450,
    0x3fe602e8a634c672, 0x3ff2341bb995e11d,
    0x3ff95254e51b80ee, 0x3feba12f3dc812ce,
    0x3feb76776602f1b7, 0xbff0519bfaf92074,
    0x3ff0571187a85138, 0x3ff8a9b238b610ca,
    0xbffa57241bd8ed3a, 0xbffb461b952f6a42,
    0xbfccae18873624e6, 0xbfcf237090cdbfe4,
    0xbfed48887e01e664, 0xbfea11a8bbefd060,
    0xbfbf4dad2298cb00, 0x3fed5ed6f54eb6b2,
    0xc008bb3b19cd00c6, 0xbfc98eca8d9ce646,
    0x3fcad47b7fc857d4, 0x3fe30398e2d854ec,
    0xbff8eb5275077d7a, 0x3ff1229b8515c61a,
    0x3fea2569afdc4042, 0x3fefb74bbda3f93a,
    0x3ffc75b14ae1c132, 0x3fbd30ecc1815b40,
    0x40002f7c6846b07c, 0x4001732bd61f28eb,
    0xbfdb900fe6ed0ef8, 0xbfeb3c3d920c7fd4,
    0x3ff3f7950fca3751, 0xbff0784bbe9fbd2e,
    0xc007b5366b0582c0, 0x3fb68f7c42efbeb0,
    0xbfffc37270892a54, 0xbfe57fcb1cadb382,
    0xbffe9934c65c9796, 0xbff6a2f31a8d2f36,
    0x3fe5c96890311558, 0xbfdc464982cee308,
    0x3fcb2fd4f96733bc, 0x3fe0a6ab74b75000,
    0x3ff6d66a706013c0, 0x3fe8fe28de01b71c,
    0xbfd1751089ec0fb4, 0xbfecfb7e99d89506,
    0x3fd2923f2e99a175, 0xbfd1844fbaf33478,
    0x3ff60e8d33047de0, 0x3fc29906bb1fa1dc,
    0xbfd8635472ded20d, 0x3feeaaee7b0385fe,
    0x3ffd1b5ce23cb032, 0xc00744cb9ee30e41,
    0x3ff896e36a8b00d7, 0x3ffeed66188434b3,
    0x3fe85083e03bbd67, 0x3ffe237d11118cf4,
    0x3fbf133b92c400f0, 0xbff78c6ae4886a49,
    0xbfe61b48a60c19b8, 0xbfd24012e56ed307,
    0x4005e99bedf23ae2, 0x3fdc7e84c2ca3a29,
    0xc001d2874c681101, 0x3fe1f2545876b389,
    0x3ff472f6105d836e, 0x3fe67a869745b05d,
    0x4005835f8b6dd78e, 0x3ff9c8d1cbd3536c,
    0x40034f958ebcd66e, 0x3ffe7a1dceba6bc8,
    0x3fe7c1ebf0714085, 0xbfe9f3c91a709b11,
    0x3fe5e977bf554b3c, 0xbff18275990a35fc,
    0xbfd94ec9d1f19c3e, 0x3fc29fbcbff9a30c,
    0xbff49720c473750e, 0x3fdc007d15060e30,
    0xbfe2105785e693e0, 0xbff401bd37fcead0,
    0x3ff7703e718aae30, 0x3fe63a508a50208e,
    0x3fcdb6e3762990fe, 0xbfed4727ec179754,
    0x3ffe11f24f8b2e80, 0x3fcf2217d34d9780,
    0xbffd5d856572d5ec, 0xbfe86319ce8624a0,
    0x3ffd7cceebe10fcc, 0x3ffaace70aabad5c,
    0x4001b31d5ccf4da8, 0xbfed1e48700873ea,
    0xbfef0394f9d43df8, 0xbff4aa42efe87bc7,
    0x3fd178930859c95a, 0xc005a3e574eab181,
    0xbfb2f4597fa3aa80, 0xbfe1aa786f40d260,
    0x4000ac4c5649ffc9, 0xc00be4919e78c425,
    0x3ff0e8691a9c153a, 0xbfe68aa51c613dae,
    0xbff6861a8c40d2c6, 0x4004598055dc32d5,
    0x3ff440f23f53823a, 0x4006bb7a4b105746,
    0xbfb8d989abed5114, 0x3fd3410f36d02956,
    0xbfe7450afa1e9d3a, 0xbfe20c64ddae0252,
    0x4000bef119dd524a, 0x3ff713e398026255,
    0xbfa648ee0af32cf0, 0x3fb1d912188f5438,
    0xbff97708391a391c, 0xbfccb156628a3588,
    0xc0132742544d0cf8, 0xbffcce09b4b0a762,
    0xbfeeb0eda0c7a0ec, 0x3fc0a55aa942ebd0,
    0xc0075842faa11102, 0x3fc1c06e9627b3f0,
    0x3ffaf79057053fbc, 0xbfcf31f35ae8c5f8,
    0x3ff8a49d3ada4210, 0x3ff44a2459983f4e,
    0xbfce3dd3c674805c, 0xc0052dd2c17b6ee6,
    0xbfd816ad18cd6c70, 0x3ffbd20d7eceac6f,
    0xbffb705818c13e82, 0x4003d63d21db240d,
    0xc009e5d378ecf204, 0xbfe75c4437e37cd5,
    0x3ff9445de36e36d0, 0xbffd68cfbd0b0cee,
    0xbffc430dfdcba618, 0xbfe51b5f5fa6fe6a,
    0xbff6be41ced22b34, 0xbfaa6f00dd96b6f8,
    0xbfe5a1e879a08d5c, 0xbfea86ec8d816d12,
    0x3fd3a1357879fe42, 0x40018b7d3aa1c056,
    0xc0030d800e6852bd, 0x400a987adb63305d,
    0xbf96df1b1d4c5790, 0xc002dc6dbfe87082,
    0x3feb43ea47997b82, 0x3ff2b564152a6b0c,
    0x3ff986df01ea2554, 0x3fe621f53f495e48,
    0xbfbee48c92f9d2b0, 0xbfffdc3042e2b1fe,
    0xbff13095590647be, 0x3fdbe3be7d795e02,
    0x3ff895fdaa4d3a43, 0xbfd50ca382775f98,
    0xbfe8ba9f74e27c7e, 0xbfe4582a5f6517f6,
    0xbffdb76d50b1d354, 0x3ff31a43bd9dfeff,
    0xc004e6ae885a1947, 0x3fd465078ad09290,
    0x40044a3048c536c8, 0x4002e3e6263ba1d5,
    0x3fdacb3fa4ba9925, 0xbfee8dbf72aedc1a,
    0x3fe74715e98a931b, 0xbff7aae6e2e44493,
    0x3fcdf089647d3fae, 0xbfe9e4ecd738a090,
    0x3ff0ef530382fcf9, 0xc0100d8a3e60f106,
    0xbfd61795dfeca948, 0xbfe3137ad0e0fa18,
    0x3fc094f7a9a4c334, 0x40068abcd3acb198,
    0xc0076f3fe2378a44, 0x3ff246b256a01de6,
    0x3fefc720198dbe4c, 0xbff1ae4507cd91d6,
    0xbff975dc4e1b0396, 0x3feff6cddc6857f0,
    0x3fcb5cb08c06e230, 0x3ffe0d20ce1bc5e3,
    0xbffe3d452713bffa, 0x3fde6ebf9bd085ba,
    0x3fa34c28d866a1c0, 0x3fe319449d1b225d,
    0x4001291a80e9da3e, 0x4001fab28e3d201e,
    0x4001eb6954aeee75, 0xbff1103f19b978b9,
    0xc003491364edde87, 0xbfea0a6ef2c32a63,
    0x3f34b95c0431d000, 0x4002537afaa7fff0,
    0x3fe38d7c5cef121e, 0xbfee2b1c40bdf9ba,
    0x4001591736bb22f8, 0xbfc3d43869193bb0,
    0x3fd717b13abc9f6e, 0xbfff035e77ace964,
    0xbff12eae388ae127, 0x400d264791484704,
    0x3ff629ff77903bbd, 0x3fedccb5368208ac,
    0x4002aa8ade41028e, 0x3fe31249affbfdf7,
    0xbfe19227e38937a2, 0xbfda2a2671cebd08,
    0x400ac58802ee1c94, 0x3fd5f2d9982c5dc8,
    0xbfee9b4bdb8c62ae, 0xbfd5aa713d290274,
    0xc00566d79b5798f1, 0xbff5bc8b85d3b548,
    0x3febfea7cb996b2e, 0x3ff7d92de8b77c2b,
    0xbff455826a93f66d, 0xbff18397ea8738cf,
    0x3fd7ab34bea5cd10, 0x3fef3fcb8e21a433,
    0x3fb84afb1dc12abb, 0x3fe5dc2cda962834,
    0x3fc9a8a4303ca118, 0xbfe873c5682bfa24,
    0xbfc3c3f73a65e050, 0x3fdacbbf57d8e1c2,
    0x3fb7aaec595fc780, 0x3fd13bba040a87b2,
    0x40020d1f95064a25, 0x3ff75dcfdadd0406,
    0x3ff241e83f31b833, 0x3ff1f97f17d347aa,
    0x3ff7c06c8a1c9a14, 0xbfe8784b66b0a606,
    0x3fb9caf001db2a88, 0x3ffb384581c3796c,
    0x3fe5c3187a63a9ca, 0xbfefaa3dcc524ab8,
    0xbfe26a0b31ab213d, 0xbfffa081d20e1353,
    0xc00277ab8a0a1698, 0x3ffd839a8caf1223,
    0xbfee2291b61bbc51, 0xbff042cc6dd6fdbb,
    0xbfe82f28cf1feb47, 0xbffb35e97dbd8c98,
    0x3feac48d25b23870, 0xbfeabc280b237508,
    0xc0042bac79cf361d, 0xc00310633356604a,
    0xbff8486b4173b048, 0x4000f9dde3943743,
    0xbfe2ab052058c956, 0x3ff82fb2c550ce51,
    0x3fe06ff3fe1e6bcf, 0xc002e5bb3bd72a7b,
    0xbfcb269669ddaa58, 0x3ff5b9cbd7207486,
    0x3ffca8f253aeddb0, 0xbff0e7190003ac3e,
    0x3fd71943d12d0c90, 0x3feb98f82adbd8cf,
    0x3ff91c6ef81a75e0, 0x3fff5b952c7074af,
    0x3ff9ca5b4fd88895, 0xbfeec87f0053a968,
    0xc001804b18a72d2f, 0x3ff75fa5054fff4c,
    0xbfdd9b87bf3c05f5, 0xbfe19a3b8af2a7e2,
    0xbfc0c321e2c327d8, 0xbfe0ee1b725185a7,
    0xbfe09e06a159b406, 0xbfdd37576a4c2bac,
    0xbffa58e4bd771dc6, 0x3fcd5dafc898f75b,
    0x3ffcd5cdaaca5392, 0x3fd530a3e163d31c,
    0x3ff280e904dee594, 0xc00867307ad598f8,
    0xc00a48ac18b57e52, 0x3fda2d11794e1f22,
    0xbfc5d23481bdf6ca, 0xbfebde4e7449bf77,
    0xbfec33a4be8a61d4, 0x400ea91bd8800246,
    0xbffc11da64b7f34a, 0xbff28ee3b7386db8,
    0xc00db5c9264e355c, 0xbff5ff03b1c1c9e4,
    0x3fc47394ad07ea68, 0xc00c0435b32f1bb6,
    0xbff9e0758fd48556, 0x3fdae34a424d5504,
    0xbfe2190402c93b37, 0x3fdd7b5afc9690e8,
    0xbfeaa4545903af44, 0x3fe83944fa82c727,
    0xbfec4099862265b1, 0xbfd6d2b36b004cf0,
    0x3ff26b47a36f717c, 0xbff6ea38c9cc95ee,
    0xbffe0964ad310858, 0xbfee4002f72469e4,
    0x3fcae23a5aa4092a, 0xbf830c0b0df1ad80,
    0xc0033f040ff68b18, 0xbf9b9088b5911280,
    0xbfe4c87f658330bf, 0x400619bc76f55170,
    0xbfce37318a9b6a18, 0x3fe1f3db1779b23c,
    0x3fd8c069a2982b66, 0x3fffcd7b64446978,
    0xbff0ef6be5d018b5, 0xbfec1a7bbdc7758c,
    0x4003ccd81514dedd, 0xbfd0693bceadc862,
    0xbfd452493e4e0fc6, 0xbfc44b6dda644c8a,
    0x3fdc6568bf9574a4, 0xbfdf336b118926a2,
    0xbff34112b5a32554, 0xbfe5e2f5a08ca5e8,
    0x3fe1266d9e6d40e4, 0xc00af83242124906,
    0x3feb0f900dbac1fe, 0xbfec1b3715a6b024,
    0x3fc87748a16d02f2, 0x3fbcde7f94712b40,
    0x3ff931a60c14ca9b, 0x3ff05dde76397545,
    0xbfd618df14d1629e, 0xbff28480ff66d1aa,
    0xc00ff818bda4c57e, 0xc00532e31d8a8896,
    0xbff3d3d8fd1fe2ec, 0x3ff5cd24642f7326,
    0x3fc9e22e409910f0, 0xbff9bc305a76f590,
    0x4004592028f1deb6, 0x3ff066ec1487e1ac,
    0xbfced1989edbe3f8, 0xbfe0c79bb8be3b0b,
    0xbfda6affda243ecc, 0xbffb4944a6ec8221,
    0xbfd371da3279a348, 0x4001afab3eb2c524,
    0x3fed3512cb8b9004, 0x3feb423e58e42a1c,
    0x3ff1599567f98b20, 0x3fe55fcee0e434e5,
    0x3fd07d5de0c1fab2, 0x3ff7adb2bbb12f6b,
    0xbffa0876dcf86919, 0x3fb06e533c39caa2,
    0xbfdedb86a928a048, 0xc008d2310fe0fac4,
    0xbff1ebe1f9b3d2cc, 0xc00b974541a6bbda,
    0x3ff8486ac2db1a6e, 0x3fd84a2409a3efc2,
    0xbfefd2f51fdcefcc, 0x3f9a1098668226c0,
    0x3fd240e60cf0d454, 0x4006fd468b1c8e7b,
    0xbff42c2447b22b9b, 0x3fe72c5d5b24994e,
    0x3ffeb1ecfe4526eb, 0xbff0da91e4ded70c,
    0xbfff74a6595f0aca, 0xbffb6e49e67263ce,
    0xbfe66aca3a6a4ba4, 0xbff54f86671092a3,
    0xbfe8c3b70593529f, 0xbff95ef598918ee3,
    0xbff9eb5cafc998a2, 0x3ffa13c291bc3cbf,
    0xc00a046a00d3e960, 0xbfb8bb12a548dbb0,
    0x3fc5c0f169e126e0, 0x3fe80ee05cc53b9e,
    0x3fd70add92847946, 0x3ff02251e5f69a83,
    0x3fb75696bcd75760, 0x40028c76304b7465,
    0x3fedb1f298eeaca4, 0x4002da13172e28f2,
    0xbff9453aefb63f22, 0xbff063c564048dcf,
    0xbfeb6e7febdba89a, 0x3ff47f79649c9f05,
    0x3ff8b63857ac5f74, 0xc002cd3ae0e26843,
    0x3ff6eeb28666ee76, 0x3ffd7d9526b34031,
    0xbff583b12f9035e4, 0xbfd2147b97714bd5,
    0x3fd53c6156f20064, 0x3ffc621316272d50,
    0x400d8300dba3d6fa, 0x3ff077773476aa40,
    0xbfb3bad323d885f0, 0xc00917f6d67d880e,
    0xbfee0324f25b7090, 0x3fe5609322aa6246,
    0x400735ace0592362, 0x4000946bcfceecc2,
    0x3ffa51824549a8d1, 0x3ffbcf6e3b3bfceb,
    0x4003101adc66e2c4, 0xbff5870915d7a354,
    0xbff425b332e0dd72, 0xbfbb8c6a7e670b90,
    0xbff7ffbe4f39ff3a, 0xc0056bcce23502ac,
    0xc00195084e52eb3f, 0xc006e355416fbb46,
    0x40013769e9056832, 0x400575d5f32dacfc,
    0xc00419cc4091c842, 0x3fb78661638e0488,
    0x3fb4516d3ee0e410, 0x40022e1ad928bc1d,
    0x3ff4f1b1c9ff0e56, 0x3fcc5ccd314dc28a,
    0x3feaf4635016a2bc, 0x3ff6541953ddbec4,
    0x3ff3db27e6a7ed53, 0xc0045bf87c333cab,
    0xbfd2f562b6394bf4, 0xbff087dd16594019,
    0x40093a5d07a02248, 0x3fe5e8e7533489b0,
    0xbfa37285e1aa7840, 0xbfefcb5180be55c4,
    0xbfe109e82fb813f5, 0x3fba87a2172147c8,
    0x3fd81dc1ac8e21fc, 0xbfddcaef46ff1e44,
    0x400140ae14ae8755, 0x3fd7966ec021d6f5,
    0x3fef4f08b7cc814d, 0x400ac04901042c34,
    0xbfda9e95d0a90a14, 0xbfd5365e65435178,
    0x3fe230f5cda14986, 0x3ffb5da6ac7bb3d6,
    0xbfcc9c98e10cf378, 0x3ff308ad86b5b89e,
    0x400689bef155f654, 0xbfddd3406f9a2798,
    0xbff158f99f477eab, 0x3fe86048c22d12f3,
    0xbfe2de1bf104b67c, 0xbfdc5f2d0b6fbd10,
    0x3ff5720334bf8b41, 0x3fe18c4ec4a6b96e,
    0x3fd66eee7e0f474a, 0xc00a65aee0b7aa6c,
    0x3ff760b41592c859, 0x3ffd4e14991df00c,
    0xbf92c33092f8aec0, 0x3ff2f6af750a5683,
    0x4015f1015c246e87, 0x400037984a59c445,
    0x3ffd005fc5bbafab, 0x4008deea67c76489,
    0xbffff3b1d6c396b0, 0x40107ca9c104636e,
    0xbff876e69e547295, 0x3fe188e50b54af61,
    0x3f946546f4509280, 0xbfdf0a4df98cb458,
    0x3fffbf4609e2d3e2, 0x3feaf884a837954e,
    0xbfeac0b8ae3ac300, 0xbff0fa0ec7d32850,
    0xc0037494b9f10e18, 0x3fd0469de6803334,
    0x3fbc563a2a2c6ed4, 0xc004c4a417737c69,
    0xbfe3ef0327d0c150, 0x3ff2a2f28b7e5414,
    0x4002c0e93203705a, 0xbffd84b0b4eebbb4,
    0x3fe3f725b1c380f4, 0x3fe5c3fa8174e282,
    0xbfee211693d3da0b, 0xbffafb56aa85b42a,
    0xc0090e765457fc62, 0x3fe4cad989e72855,
    0x3fe098b78628efe7, 0xbfe672fcad42cc6a,
    0x40036ea92dec4d5b, 0x3ff244fc3abdbd61,
    0xc0042af62f14e01a, 0xbff80b9c53c3c570,
    0x400a97672e2eb0ae, 0xbfd874eeb2ad5ae0,
    0xbfeae02ee8987274, 0x3fd21580eaa6e6cc,
    0x3fe209c3bcbfcf18, 0x3fff9b1f50c25817,
    0x3ffd51afe5fa8d28, 0x3ffb8d9db76947dd,
    0x3fe7339d081b9e72, 0x40027c7f0590ddb4,
    0x400547d59adaa62a, 0x4012b189ed1d5815,
    0xbfe00fc3553f9ce2, 0xbfe6979c87b4e3c8,
    0x3fba475918e9ea20, 0x3feb705b5e08392f,
    0x3fba47848004df78, 0xbfe1499416ff8d3a,
    0xbff22b9e8d5d2b49, 0x3ff7892e60962eb3,
    0xbfffc9fce2e347c6, 0xbff371e91aee53f9,
    0xbfb78d7ca3c89420, 0x3ffad696cc05a762,
    0x3fd664f12ae4c26c, 0xbff00498c893ec9b,
    0x3fbc4a1862ab9e20, 0x3fe1a070799f9143,
    0x3fe74199a65ba5c9, 0x401099b9a3103bce,
    0x3f61be77e420fd00, 0x3fd95ffaed6a3b6c,
    0xbfe14e55b0de2505, 0x3fd4e2efb6f8c61e,
    0x3fc1c08be6afadcc, 0x3ff9220dcc88b1bf,
    0xbff68c7867971724, 0x3fcec12c25ee65e0,
    0xbfeb7c00e5019200, 0x3feb755c51779e5a,
    0x4009b42abe7100f4, 0x3feea3f84ab2e033,
    0xbfec9b5f10868846, 0x40010480a46eb19b,
    0x3fdcb7d9128a3588, 0x3feaeb5075715526,
    0xbfe29901aa5031d3, 0x40080bb9567676b6,
    0x3fe5932b351a25af, 0xbff29116872b1140,
    0xbfecd2996ff7dbc4, 0xbfe930e3180e2e62,
    0xc00c0fe36bcf4518, 0x3ff00e917f0518f6,
    0xbfed1ccc1e269f72, 0xbffa37605cca6962,
    0xbfe5c87d477a818a, 0x3fe8e9a447aaebfa,
    0x3ff40a5f1b4155a0, 0x40036aa7bb25b500,
    0xbfe5ec7daa6a2c7f, 0x4002ca2408ca6f08,
    0xbffbb1455a5f200c, 0x3fc80a7e44175600,
    0x3ffd9289d5309827, 0x3ff9820801e21b45,
    0xbfb7c0ca4b1df710, 0xc006b9e4b9cd78a3,
    0x3febb4c0939e4d50, 0xbff2a51e6ad0becc,
    0xbff1e2efdcea9b8e, 0x3fd36edc6403d27c,
    0xc00f300446165fa8, 0x40018bb5fff5d0bc,
    0x3febce9b4a9ee22b, 0x3ff87f7f8e8b987a,
    0xbff76e5ac9f566d8, 0x3fa6660dd800c2b0,
    0x3fb83b1f9461c560, 0x3fd20c716b1ea206,
    0x3f908653202e4510, 0xc0103fd68be2329d,
    0x4003456e603e67a6, 0xc004ea6b08c3393c,
    0xc006c71a415607c2, 0xbffe9dcf8bbf078e,
    0xbfd3eff49d56aed8, 0x3ff2cb1b50da541b,
    0xbfb050c5aeb315ac, 0x3fe5dfe40879505a,
    0x40027a8cdf36e023, 0x400a665067e2d089,
    0xbff8629753565cdc, 0xc00dba1fcd91b0d9,
    0xbff35b60c6f1289f, 0x3fee65f4205c3b8b,
    0xbfd3b2454dda9fd8, 0x400418253b572dbc,
    0xbff5903b26ed9028, 0xbffe68f61299feea,
    0x3ff44102d6f5e242, 0xbfecb07db6973c8e,
    0xbff6ff29db720afb, 0xc007e10b5984df62,
    0x3fd1c3b6a2a55750, 0x3fefea48fb1ef772,
    0xbfdba865806f7e3a, 0xc003ff2d461de6ef,
    0x3ff53dd480f2b8b7, 0xbff79387025c3452,
    0x3ff4997069df1432, 0xbff359dd48ac5c2a,
    0x3fee47663c8c757d, 0x3fc1863b2ef4ec0c,
    0xbff15c68e26f4a2e, 0x3ff21d3aaccb5621,
    0x3fc6b2be474b4e58, 0xc00a526cce3d4dd8,
    0x4005d9ecae2b7592, 0x400350db0db29791,
    0x3fe6fe6a8771781a, 0x4002a78954d70131,
    0x3ff113b3b47a9df0, 0x3fd4f0e2217ef3b6,
    0xbfdace365656365c, 0xbfcc346c039433b0,
    0xbfda5b9c25662dec, 0x3ff4f4cdda60bb19,
    0xbfd0d0013abd416e, 0x3fd4768545a1d17c,
    0x4002b67562d76354, 0x3fe2a628fa91aac3,
    0x4002a27c133710ee, 0x3ff80ebd3e6b52fd,
    0x3fdc43ae2111da48, 0xbff0a1c53800d712,
    0xbfea78f2f7c71e79, 0x3fd65ddac46b9688,
    0xbfc3f72bad7dd9d0, 0x3fe90b3d2a61b51b,
    0x3fdb3e557d0e0203, 0x3fec84090a81f614,
    0x3ff1b67018624798, 0x3ffda25c8c063354,
    0xc008a9f8bf846f2a, 0xbff1cf4bfb33e514,
    0xc001ea20d43ad4a6, 0x3fe28a2b61bfdd3d,
    0x3fda61980ae7f8cc, 0xbfdddcc96a676238,
    0xbff04f5c2f632572, 0x3ffb470e640635b0,
    0xbff0aaeac2b628ce, 0xbff20b2689455104,
    0xbfbba431bd627ca0, 0xbfdc6febae30de0b,
    0x4009b3c12f5b99aa, 0x3f9100b0fbc090a0,
    0x400331c174cc8b66, 0x3ff993ca250fa39a,
    0x3ffeba1dc5dfc4ea, 0x3fd566a47c584ae0,
    0xbfe4783740ea950a, 0xbfd827c076a26f7e,
    0xbffc860a235b1446, 0x40023a7fd220d4ab,
    0xc0040ecfa6b87e04, 0x3ff21d50902a1892,
    0x3fff8c1f943083ca, 0x3fbd36e8cfeec430,
    0xbffb6acfbd93a97d, 0x3fef0f21b87c9420,
    0x3f843e90e74a7580, 0xc000494b01a5adae,
    0xc00233b80b51939a, 0x3ff7233ce1b218d0,
    0x3fef0de5f24b97d2, 0x3fa631e6febe28a0,
    0x400969a92feb8db0, 0xbffe3bb6b4097dc2,
    0xc000d3bba2c39d78, 0xbfbef712eb004fb0,
    0xbfe702054419d1c4, 0xc006b70103b5f100,
    0x40031bea8a3769c4, 0x4003703b46fdb21a,
    0x400d8aacacf44f51, 0xbff49bd3e5084067,
    0x3fe2ddf8e2d11dfc, 0x3fdc0fb22f29255e,
    0xbfc9f59253eb64ee, 0xc00530b6cf468c3c,
    0xc0092479a5bf508a, 0xbff235b2a01de254,
    0xbfe30fbf9492e458, 0xbff722842be93791,
    0xbff731d7d4ebf528, 0x4008174d3cd1c62d,
    0x3fffdc80b060d2ad, 0x3fe711637343f659,
    0x3fe153eba0037a83, 0x400018babeaf3b98,
    0xbf9947c909219460, 0x3ff1d970b74841a9,
    0xbff01c6452b4ab4b, 0x3ff2c69c0d0dc6ca,
    0xc00bac26f9b09373, 0xbfeb106b10b48458,
    0xbfe26bf9a51014c7, 0xbffc827dff0f98f5,
    0xc00ab3913fdf25c0, 0x3ffbbd0ea619fa40,
    0x3fe4b8ff69709d17, 0xbfe07d8e36b08b2a,
    0xbfebefbcb27edef7, 0xbff060e0589ece56,
    0xc001b508471c8e1b, 0xbfe4211d0aaaf5e2,
    0x3ff4ac400f891582, 0xbfeda80adf9a6b6e,
    0xbfe795a45cd5c865, 0x3ff0cb255100cf59,
    0x3fb2e79f8b416474, 0xbfc639b56081fcc0,
    0x3ff6eb6fa18fa032, 0xbff034fbd79aa1ae,
    0xc003682ec95ab80a, 0xbff5faed902aa318,
    0x3fe1ca541b563195, 0x3ff1f8552e1a4828,
    0x3fd13f86e2335f91, 0x3ff6ea6f84b7075e,
    0xbffb53c107d2cb1e, 0xbfc46e7c9dc369f4,
    0x4001954b287d5046, 0x3ffae2044478dda0,
    0x3fc3d85168396588, 0xc00acfabf7c9ee2a,
    0x3ff54f6effd3daf7, 0xbfebbee0d3eb63da,
    0xbf7e879a70ef5d80, 0x3fc6251e638ee5f8,
    0xbfe25b6dd1492a05, 0xbfeedef18c60d4a6,
    0x40005d6822bfa657, 0xbff67c698b000033,
    0x3ffd18119dd70564, 0x3ff004759c52dfe9,
    0x40049466ba5af7a1, 0x3ff9a7a8a0c29ae6,
    0xbff46fd1435f7364, 0xbffbe1a273ed00b5,
    0x3fe5cc7c56586e06, 0xbfa2797dbf752bf8,
    0xbfe3f74ac4931a14, 0xbfec4d6fb55a23e6,
    0x4005bd382400da63, 0x3fc95055cf47b514,
    0x40034742650cfb00, 0x3ff164d74a0e27c6,
    0x3fc050e3f1b86ce8, 0x3fdda5fcc1292640,
    0x3fe781cd630e05f2, 0xbfe177cac6fd0bed,
    0xc010763370ad3f4a, 0x3ffcea7b6f8f39c6,
    0x3fdc22520720d76e, 0x3ffea91ee96133f9,
    0x3fd4334f91ce855e, 0x3fe8c24d1ad44bcf,
    0x3fead39c29e953f7, 0x3feddb4debb5b2ca,
    0xbffb93600343472e, 0xbff40df009904518,
    0x3ff53daa58d37ad7, 0x3ff954425b740cd0,
    0x3ff66be9988e922e, 0xbfe7b94e9b8ebd8a,
    0xbfe6e19d8fbc4b9b, 0x3ff5a7fc379df159,
    0x3fe74beddb611e46, 0xbfde54e869898890,
    0xbff66c199c3b7cb8, 0xbfe363f4d545c800,
    0xc00c5eb65e8ebf9e, 0x3fe3ee3fe376e95c,
    0xc00084360cdf050a, 0xbfafb69dca4d7940,
    0x3fef878c1e341d62, 0x3fdbfec797e61fa6,
    0x3feb84b4e76e3dc1, 0xc002e2d1d5fd278e,
    0xbfeaf71877737e25, 0x40003558a4cb8af9,
    0x40105d063d16ba5b, 0xbff0a4be08fb0377,
    0x3ff80f86f91dd7e9, 0x3ff02c97215edcc8,
    0x3fea6a46b6a3ce3f, 0xbfda8ab325d3de2a,
    0x4001044b33c5a63c, 0x3fdb15a8b3bc5164,
    0x3ffacad36ff6fcf7, 0x3ffd36db5c6feb18,
    0x4007b37542b3f34a, 0x3fbcd19e45923540,
    0x3ff2d4a8ee54ae54, 0xbffaf7003b030a72,
    0xc0004c2a86e99ce9, 0xbfd928190f167a2a,
    0x400bd50f729e53b6, 0x3fd7f7c3a6d22eb4,
    0x3fe04d580b423078, 0xbfec698cea6dfe5f,
    0x3ff355e86e4539ba, 0xbff5aa45e3d8cc29,
    0xc004975ca6622099, 0x3ff02df2e8571c8a,
    0xbfe95b0b81b9afe2, 0x4006a279323d5f20,
    0x3fece9ed0bec0db4, 0x3fd878736351edbc,
    0xbfeb2f468fa90476, 0x3fd1acd60270528a,
    0x4002991bf9eeff78, 0xbff403b3bcd31323,
    0x3fe8e2a8543d538e, 0xbfdb38bd775bd4e6,
    0x3fca480d5ff7f0c0, 0xbffa402a7c520537,
    0xbf81074a90229340, 0x40013cac9b9aef94,
    0x3fd2e850f0a08396, 0xbff27bdcf2fdb238,
    0xc00e6817d0c5af70, 0xbfe85ab0df21022b,
    0x3fffe4acb0cc00a6, 0xbff87502321fe77f,
    0xbff7aa74fbb0eab6, 0xbffd11d8807f057b,
    0xbfe4077ae1cb4abc, 0x3feb05fd596e1b22,
    0x4007bf56668f7b0c, 0x3febce2514e84594,
    0x4005100cced39674, 0x4000929aed146cf8,
    0xbff65e02fab69707, 0xbfc97c83d27efc58,
    0xbfc597029645bbf0, 0x3ff5415682c73ef1,
    0x3fb1ca5384141c04, 0xbfee96f8a8e2404e,
    0xbff0f430e9fce5d3, 0x40036821de413026,
    0xbfece043295f964a, 0xbfeec7abdf4ca9e7,
    0x3ff73b3ed5a81b1e, 0x3ff2c72a4726e53d,
    0xbfc53cd3f65a47d8, 0xc008eac6ba095787,
    0xbffe61460f9caccf, 0x400001e14e075c6b,
    0xbfe7b0d365ac2a96, 0x3fe8c1ffabafd1fe,
    0x3ffd88557e43525c, 0x3fd0e8f193c29b70,
    0x3ff97972d9b5f654, 0x3fd34ddf2cd742c4,
    0xc00e2378d764c264, 0xbff2b1a9661d057e,
    0x3fec63c9669f0f9c, 0xbfe5110b9b9caef1,
    0xbfc0ade45f6d59be, 0xbfe7338a1f1b6537,
    0x3fd5417bd390ef0f, 0xbff1878b7333516b,
    0xbffed7159ba8912c, 0x3fe1f4ab5254c806,
    0x3ff9e060a77b3006, 0xbff83ef32b04b9c6,
    0xbfc0c6a47836e3dc, 0xbfe3b4372357f3ce,
    0xbfd3274a2f72f274, 0x3ffb238ce5937ff9,
    0x40073e8fcc88903f, 0x4003d9ba1e6608ba,
    0xbfcccd5645de57c8, 0x400558dc51c08a54,
    0xc005de0197d9264c, 0x3ff9eb2d181345ab,
    0x3feb767957afd5e7, 0x3fe4e93a08c9e421,
    0x3fd7ff81cbc4c0c2, 0xbff1c6395527ae3e,
    0xbff3dfeed4433390, 0x4008361f215e0ab0,
    0x3fe0ae054466d25a, 0x3ffb0443c8986e27,
    0x4002fb75f9ae62a6, 0xbffd52f3e27f8103,
    0x3fef4ad0e7d6488c, 0xbffce885a23d86a1,
    0x3ff8926685459150, 0x3fd09f92a28f14cc,
    0xbffac5bfa88f1422, 0x3ff906d94b24bebe,
    0xbff6656846d7c133, 0xbfe60540ca584b34,
    0xbff7b0774032aeda, 0xbff0434386456e9b,
    0xbffea09149c4f030, 0xbfb5c58b75a9c970,
    0xbff28911550ce196, 0xbfe89dc38c2c56e5,
    0xbffdf43e4f983648, 0x3ffbe129c6a87193,
    0x3fdfecda51f42e72, 0x4001fd1038c05054,
    0xbffb08e705ceefa1, 0x3fcf10c2700ee942,
    0xbffeab04feb2df50, 0xbffc9d6a721b343c,
    0x3fcf6a646be35c3a, 0x3ffbd9991886b1f8,
    0xc000bb1cdeaa796e, 0x3ff803322c43b0b2,
    0x3fe8816167d5a9a0, 0xbfc9481014acad98,
    0xbfee2ed8011ef50a, 0xbfe00a5b8673ce3a,
    0x3fea185e08dd345b, 0x400545ad137c22ca,
    0xbff083c0b355f9a3, 0x3fbfc9ea57013ba0,
    0xc0025655c7a1e357, 0x3fe1b617bd5377e2,
    0x3ff1b80fefdd4e48, 0x400257e27bba8e16,
    0xbffd7cd63b4c2004, 0xc003860d86ff6f7c,
    0xbfe4b8af995ab78e, 0xbfcd4e76fad8f4f0,
    0xbff1b11211b0905f, 0x40045ad9e2ca796a,
    0xbfd21fd5b87e71de, 0x40013e10380048ee,
    0xc00aa94cb0f4696c, 0x3fa69c1a8b0671e0,
    0xc000914e81b11df3, 0x3feb0d9ddec666bf,
    0x4000283afcf53f9e, 0xbfec4d80eb673e1f,
    0x3fe7080a30cb6b69, 0xbfe15507a1f91720,
    0xbfd88afcffb2616c, 0xbfeca29c546e10e4,
    0x3ff7d561c27d7326, 0x3fd7545721606bce,
    0xbff3d811fcb04a49, 0xbff36c340fbeba64,
    0xbff1a1e28740ecd0, 0x3fcbd0c5655db7b4,
    0xbfe9f9aa2de8b438, 0xc0000c2881f83cf4,
    0xbff9bedbb9c1d0dc, 0xbfede30030a6c6c2,
    0x40064d56197722e5, 0xbfd573b677681a6b,
    0x3ffbbbf7aa4bac4c, 0xc003a6a3f92adcaf,
    0xbfd6b06c286037be, 0x400e24403b10f645,
    0x3fe093caacc08688, 0x3fe80fd779fcc57f,
    0x4001ec800ee668b4, 0xbff207cb3fee4747,
    0x3f9b06007eb3c000, 0x3feae5b5ab5c24a4,
    0xbfd19d7fb36d439c, 0x3ffd59ee6c5682de,
    0x3fffe1e2f222cefc, 0xbff314d7186baf20,
    0x3fe9c4f2a8184a2c, 0x3ff2cbff34faf973,
    0x3fe9c368274b5af2, 0x400089b67358a2b8,
    0xbffff3fe04f0193e, 0x3fdee72f3bc989ae,
    0x3ffac2793dc27000, 0xbff13b3c8f76425d,
    0xbfdfad715674f71e, 0xbfef3acfd47659ce,
    0xbfd7e16ad53a4a59, 0x3febf3fcbc71ffcd,
    0xc001d0ef1a5db66e, 0x400090ebd7b1122f,
    0xbfe068308d187b1c, 0xc009abea22ae26c5,
    0x3ff9877c2e838339, 0xbfb562a1cec25bcc,
    0xbfd0d0582127f8ea, 0x3ffed3643db20d8a,
    0xbfda3e3e84f9d09d, 0x3ffbacc0adf0da26,
    0x3fdc25727e75bef8, 0xc009fe3c70745886,
    0x3fd5f902f57bd726, 0xbfd661f548d00693,
    0x3febae3625fe051c, 0xbffdb7ef3c4d9c1e,
    0xbfd3488ca25ca274, 0x3fad305fdad36780,
    0x3fd167a7834a1e02, 0xbffa527a6ceaa981,
    0x3fe0616d3ae2abde, 0xc00544a3682959b8,
    0x3fe94746953c2860, 0x3fc799ba90366b34,
    0x3fe279db8ae62a12, 0xbfdf45b61d732f88,
    0xbfeebaedc23175e6, 0x3fd16edc2d825eb9,
    0x3feec1435d1ccede, 0xbfeb058686e255d8,
    0xbfe8507df5fda8f4, 0xbff6f6e5ba7b8f82,
    0xc0086015553e5306, 0x3fd75e7638aefbc6,
    0xbfe5d2e840137cbd, 0xbff3f2363813d668,
    0x3fb2628bee1ff3e0, 0xbf8fef05abef8000,
    0xbfc27a54ce858000, 0x3ff9d39f8fa08c6c,
    0x400b04a1a2a9bf22, 0xc0046fb931796cec,
    0xbff7b5e93c060206, 0xbffb9ce70f9d8cf1,
    0x3ff77a94900b82ea, 0x3fe5ffc1c28e64d5,
    0x3ff00ab019a64a14, 0x3fd2b20471b4057e,
    0xbff82bb6f5a6d08e, 0x3fe39ceb62749a2e,
    0xbff992d392bc9244, 0xc002c637cb9d43ee,
    0xbff26da928d552f3, 0x401525b7fa15ee1c,
    0x3ff5500aa013e5ad, 0xbffd15382d0fc6cf,
    0x3fec983ba7d7aaaf, 0x3fb7b987dfd98a90,
    0x4004395e53cdfd1a, 0xbffb29f43e2c6cb5,
    0xbfb7b8740b831458, 0xbfff8c37509bde5e,
    0xbfed7eaefec038c5, 0xc00fd04f56247ac0,
    0xbfda0f7f211449c8, 0xbff2b6160db079e7,
    0x3fe2f34dd8ad3eef, 0x40866a81da3e8fc8,
    0xc0091de01dfa33a3, 0xbff7bb306b81f158,
    0x3fd11714176cf28c, 0x4006fc8ef2ced11e,
    0x3fe089dc8711dc5a, 0x40015f40a768db3b,
    0x3ffa7f9df13254e6, 0x3ff0b9597cb4b389,
    0xbfe0a32f61d05678, 0x3ff743f92e10783e,
    0xbfe553d649101980, 0x40021eb4f21073f6,
    0x3fb2e8dd85355930, 0xc00670e98ac571f4,
    0x3fc75c50169e890c, 0xc00f803188217e48,
    0x3ffa871140f356bc, 0xbffb9faa02887ecb,
    0xbfd6f7a6d86244d8, 0xbff127e6e241e156,
    0xbff2424f80073ade, 0xbff764e284ab4321,
    0xbfd03c9de1801ef0, 0xbfe207199d0e2b84,
    0x40040176b560b0d0, 0x3fed8314d7f1cf43,
    0x3fd4618f07b3113b, 0x400892136f2d6f29,
    0xbfb9ca58790b7460, 0xbfdd4980b8c84818,
    0xbfe27bc568fc3d82, 0x3fb0677f592337e8,
    0x3ff2e6a5ba650190, 0x3ff170332e37c102,
    0x3fed9c1133384073, 0xbf900d2d78b074a0,
    0x3ff20146c873c1f7, 0x3ff5d5c84db04667,
    0x3ffc4e9c27e8151c, 0x3fe5b5ea1c17e387,
    0x4000453d29ca98ca, 0x3ff90903ad98b73e,
    0x3ffae7639295b34b, 0xbff6efc874fc2611,
    0x3fe521386d455864, 0x3ff1551e66d70e5c,
    0x3ff459ede4cb8335, 0x3fd54186141f1ee4,
    0x3fd17d3cfb9476be, 0xc0053dec56bf0f95,
    0xbff0831a5a71876e, 0xbff3a774eea6a5ad,
    0xc000b36e51a609d4, 0xbff543c541d50453,
    0xbffce98795748813, 0x3ff82dbb991bdb4c,
    0xbff01b4d4b88a35b, 0xbfd75c4f633aadba,
    0x3febce138bd9749c, 0x3fff25c99cee7719,
    0xbffa6fa6af9d3670, 0x3ff68fffde5cc63a,
    0xc00336081c148b46, 0xbff31a0f1107a886,
    0xbfe722da2d614ae3, 0xc004a0d956ed2d68,
    0xbffa636a2f503902, 0x3fcebaa25a8e6f28,
    0x3fd366e0e9322d8e, 0x3fd89ba21cfc7760,
    0x3ff0747bdac1c49d, 0xbff56a5dd608dcc6,
    0x3ff60b2a8d362b75, 0xbfe93e27c4f617ef,
    0xbfecb031c42755cf, 0x3fa38c29bb373a60,
    0x3fe7c279bc71e442, 0xbff7b7f1cc5932d5,
    0x3fe370ea43073a25, 0xbfd78b15810258cf,
    0x3fea9ab8b8e4be3a, 0x3fcb2127411ada70,
    0x4001d1dace816017, 0x40052220ec90c112,
    0xc004e473f3ebce3e, 0x3ff17875e95dd057,
    0x400428bac1a5e548, 0xbfffabedcde96cc0,
    0xc0026af7a30c0802, 0x3fdaab594c5be3d4,
    0x3ffd570df0f831e6, 0xbfec457cd79b405b,
    0xbfa465072c03d100, 0xbfe5f0bb44b3a89e,
    0xbfcfdeb6c152f418, 0xbfe9d456cce11d51,
    0xbfd5f38b454be2a2, 0x3ffea65f158ba85f,
    0x400208c76072a55a, 0xbffd8be1c4ce78a0,
    0x3fe98e4c6a320dba, 0x3feab6533cd12476,
    0x400444b1f395d39c, 0x3ffc59d73f61cb2c,
    0xc00b52b934c697ea, 0xbfb252f63e397130,
    0xc003d89a5006a5f1, 0xbfe162909e642d88,
    0xbffbd9bd032d41ba, 0xbff90ab061e01463,
    0x3feb60b8f2a4d0e0, 0xc0030c45c4bcac47,
    0x3fda2be673db6b3e, 0xbff74dc0e668a770,
    0x40035e03efe4ce50, 0xc0079a486f558322,
    0x3fff2de41bf864ac, 0x4001ec35341be59a,
    0xbfef4ccb10b82620, 0xbffb3b2b04febb94,
    0x4000cead697c6568, 0x3ff79e4ef4bd012e,
    0x3f826ee76dfe5a80, 0x3fb856f3feb3ad84,
    0xbffdf82b2c3aebde, 0x3ff4ca38a76064be,
    0xbff7093122f3077c, 0xbfe7b16ac5ff2bd0,
    0xbfd360f5bd89ac2c, 0x3ffea730383a2b2a,
    0xbff54f9bdf13247d, 0x3ff483bcdae295bc,
    0xbfd100ee4b3ff238, 0x3ffac54d7547fa29,
    0xbfc03a4095ccb27e, 0xbff121701af8f5b4,
    0xbffce258cde3deb2, 0x4004613a57c98334,
    0x3fd04914e47bf72c, 0xc0024b92c7d704d5,
    0xbfd95d229c69ca25, 0x3fda5edbd048f6ed,
    0xbff6e14040b45f0e, 0x4009fd166d1fd9ca,
    0xbfe4e8368521081c, 0xbff77b7c15cf4160,
    0xbfeb0492dd9964b2, 0x3ff72f5e3e7a1d5c,
    0x3fd9805c0d9d0ab4, 0x3fdc4a10541a49f5,
    0xbff597d0213794af, 0x3fe291ab583585c4,
    0xbfbdabd762c9a64c, 0x3fe07dad491fd8b2,
    0xbfed1b338bd53dd7, 0x3ff04de2cf877274,
    0x3fee99404e98ad78, 0xbfce44c74a7cc6f8,
    0x3fec598a9f1313d6, 0xbfe7e97eac852a8a,
    0x3ff9f73c3f9a9932, 0x3fe96a05941b3622,
    0xbfc9734bce639a4e, 0x3ff1a2b71fb772b3,
    0xbfe01be5e70d4b7a, 0xbfe3ebb884f5ffae,
    0x40014ddd68ffa4b6, 0xbfe511f7b35a59c4,
    0xc006fb4c9a1c1314, 0x3fe036fa5c65e4e9,
    0x3ff0d612582ad86b, 0x3fe3b769ed7abb41,
    0x3ff299898ff40dd8, 0xc0022f7751443890,
    0x3ff511cfa3d0bedc, 0xc00d463837e1b8ce,
    0x3fed0e3b5e386018, 0x400496faf7acbca1,
    0xc004beb993d728aa, 0xc011808f11ab8e44,
    0x4002cdf6dde75c90, 0xbfdd48adec68cfc4,
    0xbfbee93de0151a80, 0x3ffa6622417c71ba,
    0x3fcffc860dee568d, 0x3fe7637e8a80161d,
    0x3fdb1204bab79b9d, 0x3f9dd5efb0833128,
    0x400db3c5fbf388ee, 0x3fef87206963672a,
    0x3ff831c31abac650, 0xbfbf789c78e769a0,
    0xbfe1767fc2ac8d5d, 0xbfedecba104f2434,
    0xc0049cb1a315620a, 0xc0000c4b495c4553,
    0x3fb8e0428cd23df0, 0xbff0e0cb9b6fdc2b,
    0xc00496aa4b318e22, 0xbfebbf13f9e52d2d,
    0x3fe5e25b3318c97f, 0xbff0ae49b30fa288,
    0x3fea559f124898c2, 0x4000eaa933e55626,
    0xbfe59aa8aebc37c2, 0x3ff20cc735a0ed0e,
    0xbfd802a4ece0f850, 0x3fe9a3876369090e,
    0xbfd7b4d7e8d3b92c, 0xbfba2ecbe7bf6fec,
    0xbff7aa9873a74e3b, 0x40075e1625ebad9e,
    0x3fee4434b64e0758, 0xbff19589f5a9e03a,
    0xbff02958918d3a6c, 0xbfe3c47a88482beb,
    0xbfef4b01e040b3ae, 0x3fa0f96a80a41418,
    0xbfea1e00ef21e857, 0x3ffbb58d00088c79,
    0xc004fbc6e749d30b, 0x3ff0f43e722753d2,
    0x3fd6a35574a1b7ec, 0xbfe779fa6a9da790,
    0xbff866a7900c46d8, 0x400a8891ca8b701a,
    0xc0073a20628f50de, 0x3ff7a1c6c948cf0e,
    0xbff32544d5d2f8c7, 0xc00c08fa8a98b7f4,
    0xbff9608f40cb4d80, 0x3ff4b3cdaa63eb1a,
    0xbfffc441a94ea13a, 0xbff32944c3dd7664,
    0x3fe0e15ec09322a2, 0x400b3f87dd5640d4,
    0xbfeb67b7db6cd4bf, 0x3ffd429a2aa808c4,
    0x4002c8934acae5a9, 0xc003680d671efa66,
    0x3ff45066803a9dc0, 0x3fd3b8af3b3c4c8c,
    0xbfe59a050170531a, 0x3fd8d24c4967e4ae,
    0x3fdf0cf209c00a98, 0xbff25f6129e7a2a5,
    0x3f63a73eb345b100, 0x3feba91f994a614c,
    0x3fff1eb45cd9848e, 0x3fd6942e7e47c456,
    0xbffe1f090bce66ec, 0xbfe4b2dcacf7643f,
    0x3ffd91adfd596bf6, 0xbff0e0ee4262da1b,
    0x3fb0df68cff93610, 0xbfe547cfbc64e892,
    0xbfee4d0911afdf5a, 0x3fef9fba5186f673,
    0x3ff92b2cbbba8a09, 0x3fe2d6949296dff0,
    0xbfdb21b6d9cf78a8, 0xbfe139b525195aa8,
    0x3ff5aa35bbdae038, 0x40097ae2dba0cbee,
    0x3fe3cb4da5052ae9, 0x4002ddf8bbda165d,
    0x400419536a4ae360, 0x3fa19927e7d4ac40,
    0x3fd09c7597b5b11a, 0x3fe077742ad1f8ec,
    0x4005368eb1ef8663, 0xc006938e3d88aa45,
    0xbff733467cc122da, 0x40015fec12bdcecc,
    0xbff32f4ccd31095b, 0xbff98db7de865fb8,
    0xbfb7075c09c7a878, 0x4009f07f8d3406f6,
    0x3fd0e8e188b5878a, 0x3fbd599818e8490c,
    0xbff7545a44e26baa, 0x3fd5b944b225d460,
    0x3fe77bfff5a5cf89, 0x4000f207df0d133b,
    0xbfe8ad26edf41aa1, 0xbfd5658bc4609b98,
    0xbfec1bb85f0d131b, 0x3ff3a01e2d77bc38,
    0xbff19a96618a0fd8, 0xbfcfcc9ca0255c08,
    0xbff1aaa9cb56e30c, 0xbfed3496658c4918,
    0x40013924e8938342, 0xbfe5052afd74c1c2,
    0x3ff7131220ae26c3, 0x3fbf192c7be2db28,
    0xbfff57503fd447c0, 0x3fc68d1adcafa829,
    0x3ff072a6b4c967ec, 0x4005a21bcb6ba7f0,
    0xbfc9581bb3633dc2, 0x3fee9a60dc8c16fc,
    0x3fc5f4749f54df20, 0xbff2e174265ecb1e,
    0x3ffb26ad6750829f, 0xbfe13342a3e7b2c2,
    0xc0044fc1b3e04840, 0x4010138617b9c570,
    0xc00810ec9a799551, 0x4011e0a83f838b98,
    0x3ff4bacb6f2dfd56, 0x3ff2374945271d66,
    0xbfda76b243d55450, 0xbfe60a84f9c90678,
    0xbfe50264185a0863, 0xbfd02778f81509d6,
    0xbfdb162e2d3d82be, 0x400b75f2c4cd4d82,
    0x3fdd8d39a7e440d8, 0x4000403a715c52d4,
    0x3fdc004aff3c44b8, 0x400fe9a133a12ef4,
    0x3ffb5f9b171c0743, 0x3ff881731b72c19a,
    0xbff9f5308e0728fa, 0x3fe6b73c7986d5bc,
    0xbfe04d15d4ea5da4, 0xc0011e9466396082,
    0x4002fa9fc9fbe392, 0xc008265b02e65e70,
    0xbff0fdf4f4afc4a2, 0xbfda89843d837937,
    0x3ff0a1ea53bab26d, 0x3feb6f6733926b92,
    0x3fefa152e86c6055, 0xbfedd0b5aa97f40f,
    0x3fce4e98e5dea3d6, 0x3ff613c3cadaf5af,
    0xbfe5aebc6e24e7df, 0xbff68d7f1ff53251,
    0x400c5d3082208b6a, 0x3fd6d0ff0e8308e2,
    0xc011a774fe7efd9f, 0xbfed617f81832b04,
    0xc00ef8f277d25cec, 0x3ffa33eaf6e95f43,
    0xbfe3334fc147417c, 0x401347d68e7e79f6,
    0x3fb83b2bf7fe5ef0, 0xbfde633e21158f91,
    0xbfea9b8715361e5c, 0x3fe7314fc52ea104,
    0xc0019d43561702f9, 0x3fead18d98ea0a12,
    0xbfea634de58abf75, 0xbfd9b548b8c4bb7d,
    0x3fb3f6184498b05c, 0xbfb3f3ff1407a4d8,
    0x3fe390a9fc52a2e1, 0xc0090ce1e5646850,
    0xbffcd8b4d1d5a0d0, 0x400b49581abad33a,
    0xbff6d7b0224bdde2, 0x4002adbda8bd13aa,
    0xbfeb5a35b5927c49, 0xbff2e9f546521a47,
    0x3fdacdb45bae28b6, 0xbfbde32cdf4ba870,
    0xbfe03fbadca97c3c, 0x400a38d66ca7746e,
    0x4003a04aee7de2c2, 0xc0001da1c8519cda,
    0xbfe051789ec2f77e, 0x3fd7bba36ac3bbcb,
    0x3fd2b0dd3d8bf98a, 0xbfdf57a4710fe3b4,
    0x3fdfcea50cda3be6, 0x3fde01755502b84e,
    0xbfdecfb559384fcc, 0x40056ea79afabcf1,
    0xbff45cca6cbf5fb5, 0xbfb399c42f64b37c,
    0x3fe1aa98f3b335b2, 0xbffb494d83badac4,
    0xc01025f8557dac0a, 0xc000454103ef561a,
    0xbffd902b93f8b1ee, 0xc00a2bc8e4e12bb0,
    0x3ff9bac8034b3c12, 0xbfec2a74762d1e1c,
    0x3ff1942230cd6fa5, 0xbfe947b791c04e16,
    0xc0105ccf03c74704, 0xbfc651bd4f8e1c08,
    0xbfffe0ca2c29ef32, 0x3fe1088b97033846,
    0x4000330aeee71c5e, 0xbff6a719998e5493,
    0xbff3c6c35d620dab, 0xbfba1e6d5d61fe80,
    0xbffd37b5c3b5956a, 0x3fc1a794489998f8,
    0xbfde9c53cf0fed7e, 0x3fe5a3698058137a,
    0x3ff179cb36f720b2, 0x3fe635c6a03fbf0f,
    0x3fcf17bbf0845794, 0xc00097a37ae990c6,
    0x3fd541ff78b66899, 0x3fc421231d6157a0,
    0x4005e5d319a4bc26, 0xc004e20ce587161a,
    0xc002bdf8c23cc363, 0xbfd8f8469ca7ab7f,
    0xc0002f7fa880b51d, 0x3ffd073a33e909d3,
    0xc00a0d2a692b00f4, 0xbffc8a3ef65bbf08,
    0x3ffc0cde4959b2ad, 0x400e146cf8358024,
    0x3fe2f621f945b70a, 0xc00509cdd48a0add,
    0x40014125fb7b0da4, 0x3ff504fcf72c3c23,
    0x3ff55be3d34d57bb, 0xc001328fa0bed224,
    0xc00196d4449a425e, 0x400acda988bf2629,
    0x3ff2ea5c3bf28b24, 0x3ff48a73c0cca0d4,
    0xbfe93ce099e735bc, 0xbfedad15c2a9a36e,
    0x3fd1203c25a7c965, 0xbfeb5f2204fa5bd8,
    0x3fe580ec4b99f96c, 0xbfcbc234a8b1f520,
    0x3ff3844203255be0, 0x3fc5483cfebc5a44,
    0x3fe95d1bdcbeae4a, 0x3fc74189127a383c,
    0x3fddf140c00a6d81, 0x4008afe96c362012,
    0x3ff6eafeb45f7c98, 0xbfeda87c81162262,
    0x3fc7788fbffb3524, 0xbffc324e33a9ebde,
    0xbff7747e82f5f4ec, 0xc013a35a95fc7946,
    0x3fc4c18fdc3bdf0c, 0x3fe9ccf0d01f1414,
    0x3fd771b88506175f, 0x3ffd2466adfc5f52,
    0xbfd354a5eab974b2, 0xbfea6fc6a98166ca,
    0xbff72ab08314a78f, 0x3fdf79a404482ac0,
    0x3fcbaa64f6bc3f20, 0x3fe41d92a1f7f1c4,
    0xbff962e0089fbc22, 0xbffdf8a6d441facc,
    0xbfcd27f5cef4e65c, 0xbfaf8c420e484bb0,
    0xbfee1cdf8c96091d, 0xbffc23cc6c66671a,
    0x3fe663ec70706c90, 0x3fea2839fef36f47,
    0xc00606a2cb3df32a, 0x3fc3828f88aa0864,
    0x400dc9fa6e22d7de, 0x3fef2fab51736086,
    0x40044c60acefc074, 0x3fd62bdf6678412a,
    0x4008e5f3aecfeb46, 0xc00462a8a84ce40e,
    0xbfec090464d62ebb, 0x3ff90742e5a79037,
    0xbffa1b5191af528a, 0x3ffeb8d9ed12754e,
    0x3fb85284c70bf620, 0xc00507651b34a2e8,
    0xbfeef5573c6f3868, 0xbfce7cb668774474,
    0xbfea42828cd4d7e6, 0x3ff646c5328beb97,
    0x3fefe43c45df3944, 0xbfe0d91fc3e1bb7f,
    0x3fdf515fa16afc35, 0xbff64a6026888d6e,
    0x3fda05babd70ec14, 0x3ff108ae1613f102,
    0x3fe48800e9b984fa, 0xbfec6b2929b6515c,
    0xbffd034d7d5b7995, 0x4003c3adbccc07f0,
    0x3fd67c8a8f7c8e28, 0xbf8d858074a11a00,
    0xbfd14d0b0d057ac6, 0x40008cfd4c8fd3f9,
    0x4005a1c8e713fd93, 0x3fdec61c2bec4668,
    0x3ff86fa651c2d910, 0x3ffbad39fb03d091,
    0xbfd349226edce827, 0x3fd8e9ae13fdbe7e,
    0xbfee33b9a7f286dc, 0x3fea261c54e2c14e,
    0x3fe4103f98478e24, 0x3fd7abb315a7b76c,
    0xbff57ed5eb3783f8, 0xc0090b2d821d0099
    };

static const uint64_t in_cfft_noisy_4096[8192] = {
    0x3fb3235eefec727b, 0x0,
    0x3fde770b6d69a86b, 0x0,
    0x3fe6bef61983a484, 0x0,
    0x3fe125e160576455, 0x0,
    0xbf9cb7ca5b76dc36, 0x0,
    0xbfd9d6745672e132, 0x0,
    0xbfe6b2db5b3fb489, 0x0,
    0xbfde4599e8fafb41, 0x0,
    0xbf837a86990d6b62, 0x0,
    0x3fdc12893b961eff, 0x0,
    0x3fe3e6196d9278fe, 0x0,
    0x3fe17d708e861f79, 0x0,
    0xbf708d3a9ddcca43, 0x0,
    0xbfde1a2368220f26, 0x0,
    0xbfe616cd5d5bd55f, 0x0,
    0xbfe067ec328a0233, 0x0,
    0xbf88835f6a76fd15, 0x0,
    0x3fe08a8f5a561d66, 0x0,
    0x3fe8af9f926b1f86, 0x0,
    0x3fdabec7b4ebcfe9, 0x0,
    0x3fa6fd7f2c94796a, 0x0,
    0xbfe3e5ff32f6c8a0, 0x0,
    0xbfe554e419713e5c, 0x0,
    0xbfe16223eab92838, 0x0,
    0x3f91f67b7710ae9a, 0x0,
    0x3fe2b32b8efb2cd6, 0x0,
    0x3fe681c4ff96fa27, 0x0,
    0x3fdf1c8aad9eb8c7, 0x0,
    0x3fb4fb00ebd9d715, 0x0,
    0xbfe1c03eca3af99c, 0x0,
    0xbfe6e31142c72f8b, 0x0,
    0xbfe03e4d1d8cafc6, 0x0,
    0xbf8a68af3002fd2b, 0x0,
    0x3fde7d295c88ff59, 0x0,
    0x3fe6c79cdc80a046, 0x0,
    0x3fdb16bf308cc816, 0x0,
    0xbf97b01424a74fc5, 0x0,
    0xbfe194c37b34e29b, 0x0,
    0xbfe6f17fb868d76d, 0x0,
    0xbfe07d70dcb141ed, 0x0,
    0x3fb4f817a1b8cdbd, 0x0,
    0x3fe11acdfc04ac05, 0x0,
    0x3fe5b765a41a67b1, 0x0,
    0x3fdc9066edd53742, 0x0,
    0x3f85f857818e3394, 0x0,
    0xbfe008aa971eb91d, 0x0,
    0xbfe64cc4eded774c, 0x0,
    0xbfe1b9cef9eb18c9, 0x0,
    0x3f9d45f8a5839433, 0x0,
    0x3fe147c415c551ef, 0x0,
    0x3fe589cfe7345b26, 0x0,
    0x3fe33add576b925c, 0x0,
    0x3fb72f9b39d61065, 0x0,
    0xbfde04718e7408b4, 0x0,
    0xbfe64ccebd7028fd, 0x0,
    0xbfe12d39cbd3aa9e, 0x0,
    0x3f81aaea6a49dd8a, 0x0,
    0x3fdc88a4ff3235bb, 0x0,
    0x3fe602b667bd38ed, 0x0,
    0x3fe179abbb7d0fa2, 0x0,
    0xbfaa2cee7aba9d37, 0x0,
    0xbfe1178008ecf738, 0x0,
    0xbfe4a9636a02dfc9, 0x0,
    0xbfe001c489413d67, 0x0,
    0xbfb80b9a2f93e4ca, 0x0,
    0x3fdca87f6d0260c0, 0x0,
    0x3fe6a1a41efddfd6, 0x0,
    0x3fe0591cf44c3315, 0x0,
    0x3fa6f2d341642595, 0x0,
    0xbfe02fe07cb9e40b, 0x0,
    0xbfe6c0b9feba1760, 0x0,
    0xbfddba7b3d4f3572, 0x0,
    0xbfb9c8b2389013be, 0x0,
    0x3fe21097544e8e83, 0x0,
    0x3fe8076df37b77d3, 0x0,
    0x3fdd48300040a143, 0x0,
    0xbfaba5b34e14230e, 0x0,
    0xbfd6c3d2380e6730, 0x0,
    0xbfe6e63f210299bf, 0x0,
    0xbfdfad6fe0e5d4c6, 0x0,
    0xbfb79e001503ffae, 0x0,
    0x3fda255d3b7c04c4, 0x0,
    0x3fe8a8952fbcaa71, 0x0,
    0x3fdec42a3089e75a, 0x0,
    0x3faffb24b83eb172, 0x0,
    0xbfdf316ad7c344f2, 0x0,
    0xbfe6147084eb7d29, 0x0,
    0xbfe25ea47af18e7b, 0x0,
    0xbf737b5074206bca, 0x0,
    0x3fd8e11dab978b54, 0x0,
    0x3fe6950f45920a39, 0x0,
    0x3fdd302ef30bca1e, 0x0,
    0xbfb0037f3d70e32f, 0x0,
    0xbfe2763fd590ed8a, 0x0,
    0xbfe8f32c54383231, 0x0,
    0xbfdade37c0c80213, 0x0,
    0xbf9d0b4fae66add9, 0x0,
    0x3fe0381966099d3d, 0x0,
    0x3fe6d0c163159723, 0x0,
    0x3fe0658d76021dc4, 0x0,
    0x3f97ebf0247e1317, 0x0,
    0xbfdf9cad741cb1bd, 0x0,
    0xbfe41ba96823d357, 0x0,
    0xbfdf90f87cded80d, 0x0,
    0xbf91b635f3a34850, 0x0,
    0x3fe149b20ccf4130, 0x0,
    0x3fe479a08eac5902, 0x0,
    0x3fe04127b13c4af9, 0x0,
    0xbfa43e8a60ca98ca, 0x0,
    0xbfde2a12dd267cb1, 0x0,
    0xbfe37f6b4fc03c89, 0x0,
    0xbfde82b2e698b6b2, 0x0,
    0xbfb66df20a29f01e, 0x0,
    0x3fe269d4f3a06088, 0x0,
    0x3fea914db32b3292, 0x0,
    0x3fe01d935dc62ad6, 0x0,
    0x3f989815579c8450, 0x0,
    0xbfde81aaff6d87a3, 0x0,
    0xbfe84f48a75bce5d, 0x0,
    0xbfdf977b869149a7, 0x0,
    0x3f773168709cfded, 0x0,
    0x3fdfe095dc9e31dd, 0x0,
    0x3fe61657c73988aa, 0x0,
    0x3fe1b407e74dd210, 0x0,
    0x3f7dc17dbbbb5118, 0x0,
    0xbfe08fccfca708f8, 0x0,
    0xbfe68af5da80c508, 0x0,
    0xbfded517a2227467, 0x0,
    0x3fc089ba7ca39680, 0x0,
    0x3fe1ccace343fd86, 0x0,
    0x3fe47641acfbb7cc, 0x0,
    0x3fdd659a4395e2fc, 0x0,
    0xbfbc770446da8319, 0x0,
    0xbfe22a9c20326da7, 0x0,
    0xbfe7cf129c56e2d4, 0x0,
    0xbfdd697bf2b027a2, 0x0,
    0x3f941cb98de4ca73, 0x0,
    0x3fe065ffdeed9dad, 0x0,
    0x3fe333519fe26330, 0x0,
    0x3fdfb1d09654c99b, 0x0,
    0xbf9ebe70e7af4022, 0x0,
    0xbfe11ec50b693c20, 0x0,
    0xbfea1543799fe48b, 0x0,
    0xbfd7855e16e9fe22, 0x0,
    0xbfa6c028bfa1589c, 0x0,
    0x3fded6e2d5352825, 0x0,
    0x3fe60381481a8606, 0x0,
    0x3fdc9321a2c5855e, 0x0,
    0x3f94a12a9042b159, 0x0,
    0xbfdd9da183b74bac, 0x0,
    0xbfe56eed6857cb28, 0x0,
    0xbfe14c56a0b77f11, 0x0,
    0x3fae004e1e375942, 0x0,
    0x3fdf98bf4b350b80, 0x0,
    0x3fe7976c9ce8b5ec, 0x0,
    0x3fe2477e2611c041, 0x0,
    0xbf4fdcb4f0f0d3b1, 0x0,
    0xbfe0e8399074a0ed, 0x0,
    0xbfe5fa53736deb2e, 0x0,
    0xbfe018f8f57969c0, 0x0,
    0xbf89a11a7ea6fb35, 0x0,
    0x3fe1aa4f7ba14af6, 0x0,
    0x3fe4f894b900666b, 0x0,
    0x3fe054b652eaf0fe, 0x0,
    0xbf8983036acabb6e, 0x0,
    0xbfdff5c11d045044, 0x0,
    0xbfe5add08349c344, 0x0,
    0xbfdf187d9bac731d, 0x0,
    0xbf6ae36e2c42e619, 0x0,
    0x3fde5efa1a739892, 0x0,
    0x3fe80a081d9c48ab, 0x0,
    0x3fddd3968487ff31, 0x0,
    0xbfb52aa4b4b82549, 0x0,
    0xbfe0e4ddff1651d2, 0x0,
    0xbfe75c32e793dd10, 0x0,
    0xbfddd2f11475c6a1, 0x0,
    0x3f8c392615199bc0, 0x0,
    0x3fe156e751f48bad, 0x0,
    0x3fe72fb622ccea10, 0x0,
    0x3fdff27613794298, 0x0,
    0x3f9735fa1678afdc, 0x0,
    0xbfde970d00269dda, 0x0,
    0xbfe6e67638dc5bce, 0x0,
    0xbfe1b00e7a77f230, 0x0,
    0xbfb3437e86ad3559, 0x0,
    0x3fdb92856b6aa4ec, 0x0,
    0x3fe5639a8e8c8d56, 0x0,
    0x3fd89f72a2d7f555, 0x0,
    0xbf9da680a749a192, 0x0,
    0xbfe027a456a38556, 0x0,
    0xbfea0c7910fee11e, 0x0,
    0xbfde328960ea07d9, 0x0,
    0xbf84f9624c07dba0, 0x0,
    0x3fdeac611227493b, 0x0,
    0x3fe5fcd89bb1fb53, 0x0,
    0x3fe040ab3cfb9cd6, 0x0,
    0x3f820591b7f33125, 0x0,
    0xbfde8a94b131fe0b, 0x0,
    0xbfe953385b937f77, 0x0,
    0xbfdefbb4416e4a6b, 0x0,
    0xbf8059796bbd4353, 0x0,
    0x3fdf77fc515e6755, 0x0,
    0x3fe93dc6e84e68cc, 0x0,
    0x3fe2b54800e0a2d2, 0x0,
    0xbf74c9b5118e6ee2, 0x0,
    0xbfdce1970727e3a4, 0x0,
    0xbfe4c4f61648b8a0, 0x0,
    0xbfdfd996503b6b2b, 0x0,
    0x3fa782eb635fa1d6, 0x0,
    0x3fdfc0031f547f90, 0x0,
    0x3fe69604fa29760a, 0x0,
    0x3fe0f502d7764663, 0x0,
    0x3fb4b0b15a174240, 0x0,
    0xbfe17ddd24a2f5df, 0x0,
    0xbfe4599978904cc9, 0x0,
    0xbfddc50941d614dd, 0x0,
    0xbfa6270b9e169dfb, 0x0,
    0x3fdb5b190c4d73d4, 0x0,
    0x3fe699b213a270b1, 0x0,
    0x3fe042eae3d4645e, 0x0,
    0x3f8ecc7f52d3926d, 0x0,
    0xbfd95717722dc512, 0x0,
    0xbfe7022844989b57, 0x0,
    0xbfe0be1a2a731a77, 0x0,
    0x3fa297cdcc4ace8e, 0x0,
    0x3fe02db0e8860b47, 0x0,
    0x3fe5109648ac146c, 0x0,
    0x3fe0039363e3fa57, 0x0,
    0x3f68b00100f704ee, 0x0,
    0xbfe11b24f7fac794, 0x0,
    0xbfe65689efa5039b, 0x0,
    0xbfdd8d4ab9fc0c3d, 0x0,
    0x3fb4f0f35fd3865f, 0x0,
    0x3fe26f8f607e8529, 0x0,
    0x3fe6425eaaa7bd88, 0x0,
    0x3fe0aed4f286ceac, 0x0,
    0xbfb2113c1a96d927, 0x0,
    0xbfdde64fb136fc8a, 0x0,
    0xbfe60e0b536c2d39, 0x0,
    0xbfdd07f5dfb1c49b, 0x0,
    0x3fb5f34979db3496, 0x0,
    0x3fe163318a4f63a2, 0x0,
    0x3fe82585149f08f1, 0x0,
    0x3fe2b9898e7b4f70, 0x0,
    0x3fa738dccffc1003, 0x0,
    0xbfe214f02f025506, 0x0,
    0xbfe787ef114c2f02, 0x0,
    0xbfdfe58f81a0d239, 0x0,
    0xbf8f01c5223b9a30, 0x0,
    0x3fd9c876e448de1a, 0x0,
    0x3fe7b407937a87bb, 0x0,
    0x3fe090733ad4e02f, 0x0,
    0xbface273f688333d, 0x0,
    0xbfe2e2dd6cfdb37e, 0x0,
    0xbfe4f69ef887be53, 0x0,
    0xbfdfd3bb619fa714, 0x0,
    0xbfb2ea3ad4aad2ca, 0x0,
    0x3fdef018422c2d0b, 0x0,
    0x3fe5e6c147440968, 0x0,
    0x3fe2b7fe938d5403, 0x0,
    0xbf888b52b525df97, 0x0,
    0xbfdc5bc40078398c, 0x0,
    0xbfe3c5f6f4b7142f, 0x0,
    0xbfdad8f4c435d7dc, 0x0,
    0xbf964103e53d52c2, 0x0,
    0x3fe358b5c7aa8a0f, 0x0,
    0x3fe8b3d7ca9a8422, 0x0,
    0x3fe1573b4b9b1ef4, 0x0,
    0xbfa351a186cc79a3, 0x0,
    0xbfdc260c185909e2, 0x0,
    0xbfe5c8e54333dc10, 0x0,
    0xbfe0b610169c2054, 0x0,
    0xbfb08fa83fe3237f, 0x0,
    0x3fdf7d77cb564390, 0x0,
    0x3fe516a3d8cc6d22, 0x0,
    0x3fe1068b1cf8af63, 0x0,
    0x3fa31de2b53e5e01, 0x0,
    0xbfe0dd87e52a23bf, 0x0,
    0xbfe9d239faba2de3, 0x0,
    0xbfe28eab0f67bde8, 0x0,
    0x3fadeb1183ab1d7c, 0x0,
    0x3fe30088e8a1d628, 0x0,
    0x3fe601eae3557624, 0x0,
    0x3fe0663bf59c4489, 0x0,
    0xbf8097bb85ed4a19, 0x0,
    0xbfdf4e8414409ce9, 0x0,
    0xbfe68b94867389ab, 0x0,
    0xbfe3141f658fe6c9, 0x0,
    0x3fa3e648b5ba23b3, 0x0,
    0x3fe07b6dd3bfa79b, 0x0,
    0x3fe8601145581ab4, 0x0,
    0x3fd9badcc612cfe6, 0x0,
    0xbfb088bcfc8bbec5, 0x0,
    0xbfe02e9a5037227b, 0x0,
    0xbfe4e12f94dc194a, 0x0,
    0xbfe0d21949c6b98c, 0x0,
    0xbf8c6e97717efbe0, 0x0,
    0x3fdea520ef119bcf, 0x0,
    0x3fe449fd578c56e9, 0x0,
    0x3fddf4bbfeb8d714, 0x0,
    0xbfab98ea68bd7003, 0x0,
    0xbfe0151f8ff5fee8, 0x0,
    0xbfe8b3bd6c3493cf, 0x0,
    0xbfe1e55f21ec975d, 0x0,
    0xbf9ae1cec49a7688, 0x0,
    0x3fe21ba220df9cfc, 0x0,
    0x3fe427bc8d58ae65, 0x0,
    0x3fe122b48c86d8d1, 0x0,
    0xbfa0b29c7b15e7e7, 0x0,
    0xbfded6399b3f1411, 0x0,
    0xbfe636782b7ea397, 0x0,
    0xbfdeb26d5a907bcf, 0x0,
    0x3f9c5ba948b38667, 0x0,
    0x3fe18e525886773d, 0x0,
    0x3fe4a8b173a1d807, 0x0,
    0x3fe22c575ecc1c33, 0x0,
    0xbf8f9469fec59624, 0x0,
    0xbfe1118979f166c7, 0x0,
    0xbfe55442c4cc2e64, 0x0,
    0xbfe06b35ff66a7df, 0x0,
    0x3fa49605a25426bf, 0x0,
    0x3fdfcbb812002ef2, 0x0,
    0x3fe51b11ef8aec26, 0x0,
    0x3fe020ecf8c9a5aa, 0x0,
    0xbfc09c46050fdac8, 0x0,
    0xbfe0a159a9b26673, 0x0,
    0xbfe7e9654526d96e, 0x0,
    0xbfdf1f369cd1bb51, 0x0,
    0x3faa35db373d8c1d, 0x0,
    0x3fe073d4bd1dbca7, 0x0,
    0x3fe59436b14c9d06, 0x0,
    0x3fe0b63ead51c3d3, 0x0,
    0x3f7932b2aa152567, 0x0,
    0xbfe26213f2296756, 0x0,
    0xbfe78286530bacc2, 0x0,
    0xbfdd86f318c048f8, 0x0,
    0x3f6f03c06b24787c, 0x0,
    0x3fe24d1dafd33e8e, 0x0,
    0x3fe817a89d7c91fc, 0x0,
    0x3fe03dbfa42a54d0, 0x0,
    0xbfb3585c15dd1746, 0x0,
    0xbfdd45df4da41faf, 0x0,
    0xbfe6b18ef9b8f368, 0x0,
    0xbfe158ddb0e543fd, 0x0,
    0x3f7a9072f92beb43, 0x0,
    0x3fdcad356ecc9fbb, 0x0,
    0x3fe53720617eff9a, 0x0,
    0x3fded55342b718be, 0x0,
    0xbfa571cb20743104, 0x0,
    0xbfe2726201266366, 0x0,
    0xbfe6f83f4a4e4053, 0x0,
    0xbfddeb3b11c55d5e, 0x0,
    0x3f9686d60ad82979, 0x0,
    0x3fe07ad0a154da3b, 0x0,
    0x3fe715ff300a4c63, 0x0,
    0x3fe017d4226ff078, 0x0,
    0xbfa47b885dadc9f8, 0x0,
    0xbfdb3a9363380afe, 0x0,
    0xbfe4c94f8b30ea66, 0x0,
    0xbfdf6d4e9d9d67a4, 0x0,
    0x3fa7a89982272394, 0x0,
    0x3fdbd6173ad88cf3, 0x0,
    0x3fe4b5d69d5e5c6a, 0x0,
    0x3fdf984f376297a8, 0x0,
    0x3f88d1641bd80a93, 0x0,
    0xbfe08a35f5f8677f, 0x0,
    0xbfe8820e945a2611, 0x0,
    0xbfe0de51ef092dde, 0x0,
    0xbfb26bbb8caed260, 0x0,
    0x3fde20d3be578b8d, 0x0,
    0x3fe71d5c6966ef19, 0x0,
    0x3fddd983fc9335a0, 0x0,
    0x3fb157ffe2084390, 0x0,
    0xbfe15a278eeb83eb, 0x0,
    0xbfe7535bdd9d5f61, 0x0,
    0xbfe167f3fc031b1a, 0x0,
    0x3faa0d688a04288f, 0x0,
    0x3fe1d1e5183a01f7, 0x0,
    0x3fe51b13c6c1b431, 0x0,
    0x3fd99728877d48f1, 0x0,
    0x3f8faf4af8e34d24, 0x0,
    0xbfe3df16c7307e4b, 0x0,
    0xbfe47be5b7101754, 0x0,
    0xbfdadea683689088, 0x0,
    0xbfa0d7d7cec813ed, 0x0,
    0x3fe0acdc2078aa54, 0x0,
    0x3fe63a819f63191b, 0x0,
    0x3fe0a73ee4030efb, 0x0,
    0xbfb0b7366e4ccefe, 0x0,
    0xbfddbb308f2a25af, 0x0,
    0xbfe62132d8e82c2c, 0x0,
    0xbfe0540452fa4780, 0x0,
    0x3fb6b3e02664b28d, 0x0,
    0x3fdce855785e3573, 0x0,
    0x3fe4a7e3f00a72b6, 0x0,
    0x3fe1a956b2f4317b, 0x0,
    0x3fa6ea8a76465109, 0x0,
    0xbfe0c81ea13c9897, 0x0,
    0xbfe5b59011bd1e37, 0x0,
    0xbfe046f992610c26, 0x0,
    0xbfa51729aa8bf98a, 0x0,
    0x3fddc413f531f202, 0x0,
    0x3fe569ac328dd2b8, 0x0,
    0x3fe096aa4ebf00c5, 0x0,
    0xbfa922ecd706864e, 0x0,
    0xbfdc8407c92a7858, 0x0,
    0xbfe554ba7eb03d71, 0x0,
    0xbfdcc43b645ab182, 0x0,
    0x3f9e7bb97dce0978, 0x0,
    0x3fdcf690fd93c057, 0x0,
    0x3fe82582820a7cb5, 0x0,
    0x3fe2bb1d3b69e030, 0x0,
    0x3fad3c8ac8b2f412, 0x0,
    0xbfdf36af93ca1c86, 0x0,
    0xbfe5320fee6d3593, 0x0,
    0xbfe0f5ca1b6a961f, 0x0,
    0x3fa80666f1970d22, 0x0,
    0x3fe132cc1c1193a0, 0x0,
    0x3fe5e97443bc19f5, 0x0,
    0x3fe0082f90c2e86e, 0x0,
    0xbf9f72d57943d620, 0x0,
    0xbfe104ee5972d401, 0x0,
    0xbfe48223691b349c, 0x0,
    0xbfdf5d65c559af3b, 0x0,
    0x3fbee7e75b58e445, 0x0,
    0x3fdccb7538c633b3, 0x0,
    0x3fe690862e83890c, 0x0,
    0x3fd93594ca950590, 0x0,
    0xbf931539523d3764, 0x0,
    0xbfe1bb3af5cf03cc, 0x0,
    0xbfe6840a1d3037c7, 0x0,
    0xbfd807eca1207e1f, 0x0,
    0x3faa5c881460ef4c, 0x0,
    0x3fdfad88064c4f39, 0x0,
    0x3fe6e5c4bf6259d7, 0x0,
    0x3fe04fc0b82ba07f, 0x0,
    0x3f9b6bfe927fe48b, 0x0,
    0xbfdd6b7c305b813a, 0x0,
    0xbfe41509c295b9f8, 0x0,
    0xbfdb8512654c2a8a, 0x0,
    0xbfa96a9fd346f2ea, 0x0,
    0x3fe289d6c20e2426, 0x0,
    0x3fe4a167fb92ac1d, 0x0,
    0x3fe09043ffe308bd, 0x0,
    0xbf899c14880d9a53, 0x0,
    0xbfe158e0defd67b6, 0x0,
    0xbfe2d1dc93e40363, 0x0,
    0xbfdfb924a53c6239, 0x0,
    0x3fb4dbf568f07cdb, 0x0,
    0x3fe017e42c782e7a, 0x0,
    0x3fe80376b7e39fb5, 0x0,
    0x3fe1d47b114ace0d, 0x0,
    0xbf581f7bfe1d378c, 0x0,
    0xbfe0d7936d540f08, 0x0,
    0xbfe68b1cd80ec1d0, 0x0,
    0xbfde8364a881e1e0, 0x0,
    0x3f76d8df124e31ae, 0x0,
    0x3fd81c2851dd5027, 0x0,
    0x3fe90068fb81601f, 0x0,
    0x3fe0c831a02d0dca, 0x0,
    0xbfadb0548150f0e0, 0x0,
    0xbfe154a7e4e6c8a7, 0x0,
    0xbfe831f052bc8343, 0x0,
    0xbfda3dbba8105142, 0x0,
    0x3fa14acdfea39a2f, 0x0,
    0x3fe0e7df13ce0d64, 0x0,
    0x3fe410d91380da05, 0x0,
    0x3fe1a004d2e04530, 0x0,
    0xbfb3ae04306ba367, 0x0,
    0xbfe17fc53711bc34, 0x0,
    0xbfe60afcc95513d8, 0x0,
    0xbfe09e72642ae069, 0x0,
    0xbf9940c2a2fc12e5, 0x0,
    0x3fdc99d126746091, 0x0,
    0x3fe59af45648d96c, 0x0,
    0x3fdf46fe8401469a, 0x0,
    0xbeb9aa8772e58d23, 0x0,
    0xbfe13b508d3569f6, 0x0,
    0xbfe7293f92e75232, 0x0,
    0xbfe05a93ed845e68, 0x0,
    0x3f92e659e6853429, 0x0,
    0x3fe1244bf1f57c38, 0x0,
    0x3fe5b32851e50545, 0x0,
    0x3fe0d70e47e9c190, 0x0,
    0x3fa2f9abf063157a, 0x0,
    0xbfdf2bb9f06c3098, 0x0,
    0xbfe73cf0975fccd2, 0x0,
    0xbfe141018e807ae4, 0x0,
    0xbf841597ff9ca532, 0x0,
    0x3fdf44ce1aa972d3, 0x0,
    0x3fe71198707e7b54, 0x0,
    0x3fe042be3539a00a, 0x0,
    0x3fa14b66c3298ce8, 0x0,
    0xbfdb2b7f427a7932, 0x0,
    0xbfe892138a5371ea, 0x0,
    0xbfe18e4f112c74f8, 0x0,
    0x3f80581e0b0cabb1, 0x0,
    0x3fe1c1b941f86499, 0x0,
    0x3fe7589b619acd59, 0x0,
    0x3fdcf89f2f0e40d5, 0x0,
    0x3fb36c2de98d5b7b, 0x0,
    0xbfddc45ebed3a10f, 0x0,
    0xbfe468d6a1ade21d, 0x0,
    0xbfdeff058bf2b54c, 0x0,
    0xbfb38d6b1d53a92b, 0x0,
    0x3fde2409b7015e01, 0x0,
    0x3fe635b00d863708, 0x0,
    0x3fda8fc6e36053d0, 0x0,
    0xbfb805f6fe194401, 0x0,
    0xbfe2b23f71196899, 0x0,
    0xbfe43bab8bfd599f, 0x0,
    0xbfdd7152f7023a0e, 0x0,
    0x3f8ea87f0993a3c7, 0x0,
    0x3fe0901683942c5d, 0x0,
    0x3fe642fc55b27dc6, 0x0,
    0x3fde9dbdfe80d77b, 0x0,
    0x3f7779d0ca5ea8d6, 0x0,
    0xbfded76aa35e83fa, 0x0,
    0xbfe42b2b264d7762, 0x0,
    0xbfe0b4282c0dcc06, 0x0,
    0xbfb86731f6c38da8, 0x0,
    0x3fdf0bc014035cb8, 0x0,
    0x3fe85b6a8079dfbc, 0x0,
    0x3fde16e3a859b069, 0x0,
    0x3f985bc00889d5d6, 0x0,
    0xbfdd411c3dd6866b, 0x0,
    0xbfe7c793db2aac54, 0x0,
    0xbfe0516f9931141a, 0x0,
    0x3f85143292c72f07, 0x0,
    0x3fe14ff3da696e17, 0x0,
    0x3fe750736dbb4b3a, 0x0,
    0x3fe1184752a9f9df, 0x0,
    0xbf8204818e427940, 0x0,
    0xbfdd8d3fe69e3baa, 0x0,
    0xbfe56e05d3bc57d2, 0x0,
    0xbfe1151c7743782b, 0x0,
    0x3f74a8ef9aaed10b, 0x0,
    0x3fe2009f1da24669, 0x0,
    0x3fe9000f867cf083, 0x0,
    0x3fdcc959d3673b7b, 0x0,
    0x3fb19cb31b4d33a4, 0x0,
    0xbfe1c30ae8780734, 0x0,
    0xbfe62e3abf568e4c, 0x0,
    0xbfdbf93e794c9628, 0x0,
    0x3fb2444f890bd717, 0x0,
    0x3fdce6f6f9038aa7, 0x0,
    0x3fe5f1e63497cba5, 0x0,
    0x3fe1912ebb2f259a, 0x0,
    0x3f910cdc926e2b4d, 0x0,
    0xbfe07a4eb52afd74, 0x0,
    0xbfe6a0aff5bab068, 0x0,
    0xbfe09a0b469936d6, 0x0,
    0x3f9155df36990d67, 0x0,
    0x3fe2d1a8bf670a5f, 0x0,
    0x3fe60151898d4489, 0x0,
    0x3fe01542dfbb736f, 0x0,
    0x3fb47e209e49fbaa, 0x0,
    0xbfdb0bf20d9af571, 0x0,
    0xbfe5578017a6379f, 0x0,
    0xbfde146945ff2ea3, 0x0,
    0xbf9c11f1b03f6d9e, 0x0,
    0x3fda2fdd73a2e5fb, 0x0,
    0x3fe676bb90350438, 0x0,
    0x3fe0239a8fc4ab4b, 0x0,
    0x3fa84555529575c9, 0x0,
    0xbfe045fdc307d96d, 0x0,
    0xbfe9e7453fb50e7e, 0x0,
    0xbfd883cda0ab939a, 0x0,
    0xbfa6eddca917689e, 0x0,
    0x3fdc7834bb0694b5, 0x0,
    0x3fe736a4ffdc1a9b, 0x0,
    0x3fe0be02db375ce4, 0x0,
    0xbf93fac028bbaadd, 0x0,
    0xbfe1ed924306b89e, 0x0,
    0xbfe749067c0dcad4, 0x0,
    0xbfdb898e49fc1b38, 0x0,
    0x3f793f1bbad0241f, 0x0,
    0x3fe27d4994c7f89c, 0x0,
    0x3fe713db0a24844f, 0x0,
    0x3fe2767368a48741, 0x0,
    0xbf9768525921eac9, 0x0,
    0xbfdeb3348bae0c31, 0x0,
    0xbfe5df547ec19c42, 0x0,
    0xbfdb16dd8e9a824d, 0x0,
    0xbfaa2d0e69ebe6dc, 0x0,
    0x3fe15116b7cdf61e, 0x0,
    0x3fe779cd48df5752, 0x0,
    0x3fe2cfae8274f353, 0x0,
    0xbfb2d2aa9175713d, 0x0,
    0xbfe1f45869d26828, 0x0,
    0xbfe38177721cddae, 0x0,
    0xbfe057cfb25dbaa6, 0x0,
    0x3f7d2174628578de, 0x0,
    0x3fde11037d77742e, 0x0,
    0x3fe4e347d660e287, 0x0,
    0x3fe196464169e1da, 0x0,
    0x3fb4d017a0d01cc1, 0x0,
    0xbfe081444aee9e9e, 0x0,
    0xbfe5dd987b64f8f0, 0x0,
    0xbfdd45bd93aff0fc, 0x0,
    0xbf998d8dd03c250b, 0x0,
    0x3fdd00acdeb6b327, 0x0,
    0x3fe3c785512c5d65, 0x0,
    0x3fe18734d130d7e4, 0x0,
    0x3f89eafcf2329cb8, 0x0,
    0xbfde0eb7dc417446, 0x0,
    0xbfe7fca093702270, 0x0,
    0xbfde0aca0e9ec2e0, 0x0,
    0xbf876e065474ffd8, 0x0,
    0x3fe17306b78dc1e3, 0x0,
    0x3fe490c19c228734, 0x0,
    0x3fdaaab86668539c, 0x0,
    0x3fac4b9678e25af6, 0x0,
    0xbfddf23501169aa9, 0x0,
    0xbfe4911491f131d5, 0x0,
    0xbfdc7334831d323f, 0x0,
    0xbf999659e10a4184, 0x0,
    0x3fdef230a2dc2f31, 0x0,
    0x3fe59680e826d440, 0x0,
    0x3fe06ffe43172343, 0x0,
    0x3f9876cdccf7c558, 0x0,
    0xbfde30c25d46fd8a, 0x0,
    0xbfe6b238a805f438, 0x0,
    0xbfe21753e3a71872, 0x0,
    0xbfb3d6e561e9d8f8, 0x0,
    0x3fd95b8ecb03b347, 0x0,
    0x3fe6ab9205159585, 0x0,
    0x3fded2f2d16aae7b, 0x0,
    0x3f9ec4c3cd544228, 0x0,
    0xbfe07ea225072ec4, 0x0,
    0xbfe3b13b0cf2bd95, 0x0,
    0xbfdc252d614f2fa4, 0x0,
    0x3fa88600085812c5, 0x0,
    0x3fe230178cf19789, 0x0,
    0x3fe54644f331ad21, 0x0,
    0x3fdf6604be6b5259, 0x0,
    0x3faca77ca4ca7035, 0x0,
    0xbfe21eed6ab97f8e, 0x0,
    0xbfe480bf59535783, 0x0,
    0xbfdfd85d53bc4136, 0x0,
    0x3f9a55632ec5c51e, 0x0,
    0x3fdeb2d8a568669d, 0x0,
    0x3fe6fd073fcb6d50, 0x0,
    0x3fddaeafac09fe8c, 0x0,
    0x3f97ba696618f363, 0x0,
    0xbfdd7e0fe049b611, 0x0,
    0xbfe7c1520fa41226, 0x0,
    0xbfe0b97f7f8e26dd, 0x0,
    0xbf51422122bfb5fc, 0x0,
    0x3fe0e06cac73cef0, 0x0,
    0x3fe6369e248ed7b4, 0x0,
    0x3fe33401de7e20cb, 0x0,
    0x3f9975dab589b1f8, 0x0,
    0xbfdf98671ba37c4b, 0x0,
    0xbfe4687abdb6b966, 0x0,
    0xbfe01ad76de27126, 0x0,
    0xbfb06c12757f9736, 0x0,
    0x3fdde6f18a6e712a, 0x0,
    0x3fe39aff8fbe4162, 0x0,
    0x3fdedd85fbc484d9, 0x0,
    0x3facc0d674971375, 0x0,
    0xbfdb8e3b9769055d, 0x0,
    0xbfe58cbac0ce285b, 0x0,
    0xbfddf90e23664aa5, 0x0,
    0xbfa2fd9b62b7f6fb, 0x0,
    0x3fdec2356784c9d5, 0x0,
    0x3fe5a478a3b32b00, 0x0,
    0x3fe0dc2c1fafb5b9, 0x0,
    0x3f98471007f0998a, 0x0,
    0xbfdc521e6a6f6e64, 0x0,
    0xbfe6b5bdd0214f4d, 0x0,
    0xbfe0661db46b4ee5, 0x0,
    0xbf828c66eab6b5c1, 0x0,
    0x3fe312b79bef6b48, 0x0,
    0x3fe61a1a5c307172, 0x0,
    0x3fe1841d81d92262, 0x0,
    0x3fa296fb480df0a3, 0x0,
    0xbfe0e27218d8070c, 0x0,
    0xbfe632e17446aa87, 0x0,
    0xbfe0de4af1315751, 0x0,
    0xbfa1f30bab5e17f6, 0x0,
    0x3fdef736095639df, 0x0,
    0x3fe502b75dc3242e, 0x0,
    0x3fe026fbfef51db5, 0x0,
    0x3f21c24d4be4aded, 0x0,
    0xbfde9755c799c69e, 0x0,
    0xbfe4cd9732afc6cc, 0x0,
    0xbfe066d386e3affc, 0x0,
    0xbf92bdcc6efa73c1, 0x0,
    0x3fdd915cbb91c39d, 0x0,
    0x3fe5580ec9a99bd1, 0x0,
    0x3fe1552ab6afd394, 0x0,
    0x3f949e03d6fa342a, 0x0,
    0xbfdc2a8994c950f5, 0x0,
    0xbfe646c5060b21d4, 0x0,
    0xbfe0ca38ff1e1cdf, 0x0,
    0xbfa79af1dc058014, 0x0,
    0x3fe291d36ad536c0, 0x0,
    0x3fe8852fe1adfdd7, 0x0,
    0x3fe1472ea43c6448, 0x0,
    0x3fa5e2a2c49f520c, 0x0,
    0xbfde0cb37920a5f2, 0x0,
    0xbfe4e555531930dd, 0x0,
    0xbfe13a68813cea33, 0x0,
    0x3f836b95585121e7, 0x0,
    0x3fdebead703aab43, 0x0,
    0x3fe672c06d13a6bf, 0x0,
    0x3fdeb7fa13f89d5e, 0x0,
    0x3fac64fc9fab6b67, 0x0,
    0xbfe26da3b22062b1, 0x0,
    0xbfe3033ecd1b6e90, 0x0,
    0xbfdd34f4941e6265, 0x0,
    0xbfb6e7e978c8e413, 0x0,
    0x3fe0c2a94abaf659, 0x0,
    0x3fea40c5afe1bf80, 0x0,
    0x3fdd0d2d1a6bfb3f, 0x0,
    0xbf97802d5d84ddc8, 0x0,
    0xbfe11324d49d8398, 0x0,
    0xbfe74d6821d06cf6, 0x0,
    0xbfe05ae6b6ead2b3, 0x0,
    0xbfa6702ac65af9aa, 0x0,
    0x3fe1431e3208f094, 0x0,
    0x3fe7fc53d321fd0e, 0x0,
    0x3fdfec8316c8fd83, 0x0,
    0x3fa52e3865924c2f, 0x0,
    0xbfe00e3739bca1b5, 0x0,
    0xbfe4ff246148b2d6, 0x0,
    0xbfdbd5f7e225fc8b, 0x0,
    0x3f928e995855fc16, 0x0,
    0x3fdfdf593009cdb3, 0x0,
    0x3fe656ad469efa45, 0x0,
    0x3fe10fd92fe8fa07, 0x0,
    0x3fb1b80134d88b1b, 0x0,
    0xbfdf0ab4d7bff1f3, 0x0,
    0xbfe6551aba1957a8, 0x0,
    0xbfe11439c5c79a96, 0x0,
    0xbfc030a39d8f2824, 0x0,
    0x3fdec9a11d903ae4, 0x0,
    0x3fe65e119909dbe9, 0x0,
    0x3fdcd623dd94c018, 0x0,
    0xbf8c86048357c8a0, 0x0,
    0xbfdd2826d8cd5c54, 0x0,
    0xbfe6c25fa2ebdf05, 0x0,
    0xbfe08e79a74f4b03, 0x0,
    0xbfbd99c235f4671f, 0x0,
    0x3fe057ca156665d4, 0x0,
    0x3fe736ed80c4717b, 0x0,
    0x3fe109d76e0794ef, 0x0,
    0x3fa6b49798d4d47e, 0x0,
    0xbfe14336083eb5a2, 0x0,
    0xbfe40193ebd5aa33, 0x0,
    0xbfdc115cfbe0bfce, 0x0,
    0xbfb191313c56cef3, 0x0,
    0x3fe21306b992689e, 0x0,
    0x3fe6104e7ace0644, 0x0,
    0x3fe086ceedae0962, 0x0,
    0xbf9aa01a746429b2, 0x0,
    0xbfde5ea7754c1693, 0x0,
    0xbfe730f868bb7a6d, 0x0,
    0xbfe1e20f0d4e90da, 0x0,
    0xbfc060e5f31c5c1a, 0x0,
    0x3fdfe3e874b8187b, 0x0,
    0x3fe4c951be9f02a1, 0x0,
    0x3fde4b4c3527b028, 0x0,
    0xbf8e25c6a9d195c6, 0x0,
    0xbfe20cb530fec2ca, 0x0,
    0xbfe718998a199257, 0x0,
    0xbfe23be34aee3962, 0x0,
    0x3fa67dc11291b665, 0x0,
    0x3fdf3aab5546a009, 0x0,
    0x3fe834f385372936, 0x0,
    0x3fdd4a6c1f532295, 0x0,
    0x3fabca1a6f1b6d3e, 0x0,
    0xbfdd832a0fa8778c, 0x0,
    0xbfe65a5cdd8a8802, 0x0,
    0xbfdbf16850c54311, 0x0,
    0x3fbf92dda5d326e3, 0x0,
    0x3fdd23fa6ca8b9d8, 0x0,
    0x3fe846a1f65c7980, 0x0,
    0x3fe0980a6db5c2a8, 0x0,
    0xbfae8bdc0fa8a0bd, 0x0,
    0xbfdf62a738e99165, 0x0,
    0xbfe56443ec1ec56c, 0x0,
    0xbfe03f43cbac338e, 0x0,
    0x3fb3cff7d4626171, 0x0,
    0x3fe16e1bc98e3c77, 0x0,
    0x3fe5468377e343c6, 0x0,
    0x3fdf6691af0d32b3, 0x0,
    0xbf9c1ad27f64bfbe, 0x0,
    0xbfe2b3a974c212b2, 0x0,
    0xbfe62801246ee916, 0x0,
    0xbfe13bac1f9621bd, 0x0,
    0xbf86771a0cee2da5, 0x0,
    0x3fe090a439a1dea9, 0x0,
    0x3fe62d64da089fc4, 0x0,
    0x3fdb42e61f05b2d2, 0x0,
    0xbfb1c4b7a2c06017, 0x0,
    0xbfe2fcf8f59e860a, 0x0,
    0xbfe5d86eff302429, 0x0,
    0xbfde480dab20869e, 0x0,
    0xbfb74f5a7c132d3d, 0x0,
    0x3fe27443c276c9bd, 0x0,
    0x3fe694a2c82fcc63, 0x0,
    0x3fe162e953e3358a, 0x0,
    0xbf89f3bc9f60f0e2, 0x0,
    0xbfdc7bac4c4000d7, 0x0,
    0xbfe5543d2b95f4dd, 0x0,
    0xbfd9848fb8347844, 0x0,
    0x3f84677aba89d74d, 0x0,
    0x3fde5d21b8d7791e, 0x0,
    0x3fe6a80faf07d2cd, 0x0,
    0x3fdcad70dfcbb156, 0x0,
    0x3f75c4d740bd97e8, 0x0,
    0xbfdd53e6c5a4c75d, 0x0,
    0xbfe6e04bddbc9b10, 0x0,
    0xbfe09f077a3058c0, 0x0,
    0x3fbaf14497d26707, 0x0,
    0x3fe0045bb85357f4, 0x0,
    0x3fe69e5141380c47, 0x0,
    0x3fde7f1b6994a387, 0x0,
    0xbfb30d0555024ec7, 0x0,
    0xbfe140cbac8e1d64, 0x0,
    0xbfe766af84c12350, 0x0,
    0xbfda60e598a14bd4, 0x0,
    0xbfa477f502464581, 0x0,
    0x3fe1032e2fe4c984, 0x0,
    0x3fe6890d537ede00, 0x0,
    0x3fdbb4fa8a0584c9, 0x0,
    0x3fa33a2310df1f40, 0x0,
    0xbfe17363300e33cf, 0x0,
    0xbfe8ae3624c3d48a, 0x0,
    0xbfde5c2ee2525bc9, 0x0,
    0x3f7f342eead1d432, 0x0,
    0x3fde521b32ccd460, 0x0,
    0x3fe753255a9f63ed, 0x0,
    0x3fdf24d7556d90fc, 0x0,
    0x3fa56baa04e043bb, 0x0,
    0xbfe14670b3899348, 0x0,
    0xbfe5ec7d968e289b, 0x0,
    0xbfda4adb132db710, 0x0,
    0x3fb15da160408463, 0x0,
    0x3fe19fa06f374308, 0x0,
    0x3fe4d083ccea2cff, 0x0,
    0x3fdf3ab7b83fd413, 0x0,
    0x3fa0897af43fd69d, 0x0,
    0xbfe331c35636d12c, 0x0,
    0xbfe8f90ad7b4724f, 0x0,
    0xbfde996481f5a32a, 0x0,
    0x3f80e7a3abeb1fb2, 0x0,
    0x3fe0a9920bbf1680, 0x0,
    0x3fe7ac73c149619d, 0x0,
    0x3fdd1e6ca210abb3, 0x0,
    0x3f79b8fe2c709086, 0x0,
    0xbfdf1a46a9216bfe, 0x0,
    0xbfe5b49112b64ca3, 0x0,
    0xbfdcffa6715da744, 0x0,
    0x3fa4017a5df1ef83, 0x0,
    0x3fdc2d648339116a, 0x0,
    0x3fe6489469280928, 0x0,
    0x3fe1b84b5d2be73e, 0x0,
    0xbf9c5f945ad6f550, 0x0,
    0xbfdd671d0dd3141c, 0x0,
    0xbfe3765c54d7b8d9, 0x0,
    0xbfdbc4203ef05286, 0x0,
    0x3fa17aa8ee73f6c3, 0x0,
    0x3fdcb57a0dfa40e2, 0x0,
    0x3fe48b6891781819, 0x0,
    0x3fddaf9a2e294c9b, 0x0,
    0xbf9cd36feaf96cfb, 0x0,
    0xbfe1f3fc0073b613, 0x0,
    0xbfe6e4b546e3c097, 0x0,
    0xbfe3d5bd21b5b502, 0x0,
    0x3fc41b8625ff1f67, 0x0,
    0x3fe28352e663fdd8, 0x0,
    0x3fe8d8b3863285bb, 0x0,
    0x3fddea46f710f41b, 0x0,
    0x3f92703c0d41ccd9, 0x0,
    0xbfdaeb1f5b1a2d61, 0x0,
    0xbfe6e92bf8c03a13, 0x0,
    0xbfe1673eb484700a, 0x0,
    0xbfa68b599aa2dca0, 0x0,
    0x3fe1351ea10b1947, 0x0,
    0x3fe760273f6c4e45, 0x0,
    0x3fe07be22773e9da, 0x0,
    0x3f89b004f2a0f382, 0x0,
    0xbfe105af55a8d703, 0x0,
    0xbfe6ad3325eef4a2, 0x0,
    0xbfde57d8892a8336, 0x0,
    0x3f8e64679180c8f4, 0x0,
    0x3fe10134e90ee6c8, 0x0,
    0x3fe260cc641dcff7, 0x0,
    0x3fe16120c95d3979, 0x0,
    0x3fb05cda3415f397, 0x0,
    0xbfe1a3eeb0348f97, 0x0,
    0xbfe7dc4b9c6a9254, 0x0,
    0xbfe26b1f6785bcc0, 0x0,
    0xbfab4f2d1efe7acc, 0x0,
    0x3fd98311ad4631e3, 0x0,
    0x3fe69159238743f4, 0x0,
    0x3fdfacb313382c5c, 0x0,
    0x3f95107277317a62, 0x0,
    0xbfe275d2b18b7b66, 0x0,
    0xbfe63ef8a5497574, 0x0,
    0xbfdd717b9914e954, 0x0,
    0xbfb0d4005264a56b, 0x0,
    0x3fdf79b68203e6fc, 0x0,
    0x3fe56cb71faacf89, 0x0,
    0x3fe05f7c74e9fa1d, 0x0,
    0xbf610432f45c87b2, 0x0,
    0xbfe05a013c4a9fc3, 0x0,
    0xbfe4c64a562aafb6, 0x0,
    0xbfe0696c08a0e3c0, 0x0,
    0xbf98a78a30365361, 0x0,
    0x3fe057b15c881fb3, 0x0,
    0x3fe4c2270a3a72ab, 0x0,
    0x3fdc02672348ac16, 0x0,
    0xbfa9f70261ba080a, 0x0,
    0xbfdd8fac5e511841, 0x0,
    0xbfe5a46f672cc9aa, 0x0,
    0xbfe20d39e223c8cf, 0x0,
    0x3fa3eb33af1e3d8d, 0x0,
    0x3fdfc0916bb00be3, 0x0,
    0x3fe4fc737913e590, 0x0,
    0x3fe1c24421180cfe, 0x0,
    0x3f4b657874287adf, 0x0,
    0xbfe057cc09b6e738, 0x0,
    0xbfe935db1e069dc0, 0x0,
    0xbfdefdd6d5cc9fca, 0x0,
    0xbf9d4eca671a79c2, 0x0,
    0x3fdbe909c7e3de5e, 0x0,
    0x3fe400aa3401521c, 0x0,
    0x3fdf9040de22094c, 0x0,
    0x3f8c749c676e9652, 0x0,
    0xbfdd3b25a4444111, 0x0,
    0xbfe66d4f398cdc0e, 0x0,
    0xbfe1b81e0e0e4c34, 0x0,
    0xbfb6f3869bf4db0c, 0x0,
    0x3fdf18f5c20ecf13, 0x0,
    0x3fe512d287949dbd, 0x0,
    0x3fdf18758b98287f, 0x0,
    0xbf9ce761215c77a1, 0x0,
    0xbfdc13cb2ca248ac, 0x0,
    0xbfe6c406aae0b0d7, 0x0,
    0xbfdb63b23bb39410, 0x0,
    0xbf91fcb7a62f7e62, 0x0,
    0x3fdf5425ff00b9b9, 0x0,
    0x3fe82c81d1dd86fb, 0x0,
    0x3fdbaf5b2c8fed4f, 0x0,
    0x3f8bc770c24df73b, 0x0,
    0xbfdc16d624b3fc65, 0x0,
    0xbfe559e8bb3a19f6, 0x0,
    0xbfe00c9092276993, 0x0,
    0xbf9883c39a0bf1c5, 0x0,
    0x3fe261f9e6a3c5eb, 0x0,
    0x3fe5a4bc45f0f438, 0x0,
    0x3fe22f977e2a7c7a, 0x0,
    0x3fb3d34a8d5312e0, 0x0,
    0xbfddc197f1c83afd, 0x0,
    0xbfe66fe30b124ce8, 0x0,
    0xbfdf8ce4d6dfff8d, 0x0,
    0x3f874e124fc00c92, 0x0,
    0x3fdf8315a729656f, 0x0,
    0x3fe56f1bab251ec0, 0x0,
    0x3fddfc17653f0794, 0x0,
    0x3f9d679b09b6725e, 0x0,
    0xbfe01708a077b7de, 0x0,
    0xbfe6ea32bf7cfbcb, 0x0,
    0xbfe0f92195cf020c, 0x0,
    0x3fa27f0bbfb4e561, 0x0,
    0x3fdf1f381011d56e, 0x0,
    0x3fe5f002d7656c8b, 0x0,
    0x3fe1acfce321668f, 0x0,
    0xbf9b794f8929941d, 0x0,
    0xbfdf81f00de85220, 0x0,
    0xbfe3d529697669f9, 0x0,
    0xbfdf658df603e750, 0x0,
    0xbf80b61782ea5a69, 0x0,
    0x3fe05b7d4b3d5040, 0x0,
    0x3fe8350a5d9d309b, 0x0,
    0x3fe02d7f315e877e, 0x0,
    0xbf553b8215898ccc, 0x0,
    0xbfde183f7bef7f97, 0x0,
    0xbfe1e78aaeba5a7e, 0x0,
    0xbfddfe0283fb5728, 0x0,
    0x3f945d061322cd3b, 0x0,
    0x3fdf5faaf2aad1b6, 0x0,
    0x3fe85edc26b1c835, 0x0,
    0x3fe0c4eb5e3b8a94, 0x0,
    0xbf7f1dde4a310eae, 0x0,
    0xbfe011442818a74d, 0x0,
    0xbfe86be6fe7749ae, 0x0,
    0xbfdd4efda80eec9a, 0x0,
    0xbf7bd38de1b6bc1b, 0x0,
    0x3fe151491ddb5262, 0x0,
    0x3fe6d9af1d33e077, 0x0,
    0x3fe1126fd697b8b4, 0x0,
    0xbfac21501f9bfca2, 0x0,
    0xbfd902652c6112f7, 0x0,
    0xbfe5dc4be2d7c94d, 0x0,
    0xbfe18a34381ef635, 0x0,
    0x3f7cbf5b5c1ff811, 0x0,
    0x3fdb2d65bf325328, 0x0,
    0x3fe5a18b99a47877, 0x0,
    0x3fe198878d86cb55, 0x0,
    0xbf9bb0754428dd0e, 0x0,
    0xbfdbaece56b1b71e, 0x0,
    0xbfe2d4073bb58dc3, 0x0,
    0xbfdf3f14b136e67e, 0x0,
    0xbf6ccd002aac2e3c, 0x0,
    0x3fde87a7613b0a1e, 0x0,
    0x3fe5472e8bdf0edb, 0x0,
    0x3fdfd6759d010411, 0x0,
    0x3fb5ca6d0c289c06, 0x0,
    0xbfe25f76b96a8885, 0x0,
    0xbfe5411d005ab7a1, 0x0,
    0xbfe1711fdf74de46, 0x0,
    0xbfae11f447eae4ce, 0x0,
    0x3fe51aba2ef63017, 0x0,
    0x3fe38967a5a93898, 0x0,
    0x3fdf7a149bc2a72f, 0x0,
    0x3fb0dd49dfd0ba25, 0x0,
    0xbfde2bed02896f42, 0x0,
    0xbfe4613ebc090425, 0x0,
    0xbfde22515b4e627a, 0x0,
    0x3f98a1109468d15e, 0x0,
    0x3fe0cf76c4bff1af, 0x0,
    0x3fe2f08cd3eb5375, 0x0,
    0x3fe26a4a3bdbafe6, 0x0,
    0xbfa8a01de8e96052, 0x0,
    0xbfe1740b7d19595f, 0x0,
    0xbfe908f046006fa6, 0x0,
    0xbfe072dacd2b1c6e, 0x0,
    0xbf943f34bb71b067, 0x0,
    0x3fdf1c9be4ecb742, 0x0,
    0x3fe81bd2452d8b67, 0x0,
    0x3fdd69058696e60b, 0x0,
    0xbfa9266fe77f0f6e, 0x0,
    0xbfe1a171bd6ffd10, 0x0,
    0xbfe6065542bbbcf2, 0x0,
    0xbfe000dc0db49d47, 0x0,
    0x3fae4046a881d03c, 0x0,
    0x3fdca419e7c50d78, 0x0,
    0x3fe71769ef9d6f2a, 0x0,
    0x3fe37ee4a4b5c260, 0x0,
    0x3fa1ceee52346fd5, 0x0,
    0xbfdeffd8d0c4efcc, 0x0,
    0xbfe3a3869cf76e4f, 0x0,
    0xbfe118bda6597f56, 0x0,
    0x3fb203afe9b4000d, 0x0,
    0x3fe2cf921610b2f5, 0x0,
    0x3fe882b5d668af97, 0x0,
    0x3fe18563934f8f64, 0x0,
    0x3f9409a43c2108e6, 0x0,
    0xbfdd1a55bd110624, 0x0,
    0xbfe5a519e6880d68, 0x0,
    0xbfe08de9e47746d6, 0x0,
    0x3fab9ce165aa4440, 0x0,
    0x3fe16e0da6e0558e, 0x0,
    0x3fe7f310f69ff4ab, 0x0,
    0x3fe0961e74de7c0b, 0x0,
    0xbf61e3deca6f8416, 0x0,
    0xbfe290e5ceb59f51, 0x0,
    0xbfe4f52ad16327ee, 0x0,
    0xbfe01415448954ed, 0x0,
    0xbf5240028c017f93, 0x0,
    0x3fe09d80e77007c6, 0x0,
    0x3fe62afa014f0841, 0x0,
    0x3fe14f2ab63b2da9, 0x0,
    0xbfacb11f3f78a533, 0x0,
    0xbfe1be131aa2ce9c, 0x0,
    0xbfe64fea0393ffd6, 0x0,
    0xbfdf462cd478074f, 0x0,
    0xbfac4f61a6d537ce, 0x0,
    0x3fdf37081aaf7e84, 0x0,
    0x3fe78affaace4c13, 0x0,
    0x3fe059dc355e4326, 0x0,
    0xbf94d61b23e7f5c6, 0x0,
    0xbfdffbed3c2af714, 0x0,
    0xbfe47e2d4bc20fe0, 0x0,
    0xbfe1d98dbee5f171, 0x0,
    0x3f74d80700e58433, 0x0,
    0x3fe182a7794bc060, 0x0,
    0x3fe435b160bab3e8, 0x0,
    0x3fdfc50f8b0c682a, 0x0,
    0x3facaea438fdcc8f, 0x0,
    0xbfdf32f729ec1ade, 0x0,
    0xbfe7329e09beb02a, 0x0,
    0xbfdb31841cd492e8, 0x0,
    0x3fb5b5401f3948b8, 0x0,
    0x3fe0fcc7095bf51a, 0x0,
    0x3fe583fa987f7133, 0x0,
    0x3fde37c1c0877f9a, 0x0,
    0xbf97f754e3777b04, 0x0,
    0xbfe0217123a0085b, 0x0,
    0xbfe5af2e451c669f, 0x0,
    0xbfe0bc03edfa8f1e, 0x0,
    0xbf8290723becdf50, 0x0,
    0x3fddeeac40aa5a54, 0x0,
    0x3fe5fe0d2d009a5b, 0x0,
    0x3fde4da17f28870d, 0x0,
    0xbf9acb28f4a9fca6, 0x0,
    0xbfdbafa04b0de79c, 0x0,
    0xbfe81df46f35e3a2, 0x0,
    0xbfdd8e6c884e20cf, 0x0,
    0xbf9eeed7356c9adc, 0x0,
    0x3fdfa5e1ff88052c, 0x0,
    0x3fe6d5ee8c822a02, 0x0,
    0x3fe0677a6341356b, 0x0,
    0x3fa66357b2c98a93, 0x0,
    0xbfe0afd23df58125, 0x0,
    0xbfe6da0e297ac9af, 0x0,
    0xbfdfcce090fa7087, 0x0,
    0xbf4d9387a9e9db22, 0x0,
    0x3fe1085e587d0ac5, 0x0,
    0x3fe4823e2afe95cc, 0x0,
    0x3fdcafa9dea99494, 0x0,
    0xbf9b6dafb37e0d3e, 0x0,
    0xbfe135c363e7387e, 0x0,
    0xbfe481c19c50aa26, 0x0,
    0xbfdecc4393847411, 0x0,
    0xbf83b4dd5fabf0b7, 0x0,
    0x3fded34a41ef65ca, 0x0,
    0x3fe8b354c65b3fbe, 0x0,
    0x3fde3f236378b7cb, 0x0,
    0x3f98f4b1a40e91a0, 0x0,
    0xbfdf3fbac92a079b, 0x0,
    0xbfe7c3f351a409ac, 0x0,
    0xbfdd9a3862090c40, 0x0,
    0xbfb2d0780ef2b260, 0x0,
    0x3fe15ad2fff71ba2, 0x0,
    0x3fe6fe4315e1079d, 0x0,
    0x3fe197a7456c047f, 0x0,
    0x3f5cb58b7f987999, 0x0,
    0xbfdf10617fdf8451, 0x0,
    0xbfe53dd4ec07c9d4, 0x0,
    0xbfe190c58f37defd, 0x0,
    0x3fb7c61f5ca08a79, 0x0,
    0x3fdebdd125030a06, 0x0,
    0x3fe676083c369f3c, 0x0,
    0x3fe07dab747f3523, 0x0,
    0x3f9b571f69194449, 0x0,
    0xbfdf117714ec59fd, 0x0,
    0xbfe466646f7010c2, 0x0,
    0xbfdfeb568473ce0b, 0x0,
    0x3fa4fae1a54ae0c4, 0x0,
    0x3fddbdfb718069ae, 0x0,
    0x3fe585cd544e4eae, 0x0,
    0x3fe0ab7bca2cdb70, 0x0,
    0x3f944c44109789f9, 0x0,
    0xbfe0db83e4608211, 0x0,
    0xbfe7bd54bbe98e06, 0x0,
    0xbfdfa0977e733000, 0x0,
    0x3f9809385bb47bcc, 0x0,
    0x3fdc07fcd83797b6, 0x0,
    0x3fe5f95622f39de2, 0x0,
    0x3fdd200c8dd257ca, 0x0,
    0x3fbc83e5ea1f7310, 0x0,
    0xbfdc7fa9b009bf62, 0x0,
    0xbfe623f2ff2fdf76, 0x0,
    0xbfd87c2e5d3c6632, 0x0,
    0x3f986788e9d43e56, 0x0,
    0x3fe04e29eb2d5fe1, 0x0,
    0x3fe2441c1cbf3f97, 0x0,
    0x3fe11c51a41fe326, 0x0,
    0xbfb2535e12a3b8d1, 0x0,
    0xbfe018781ee56895, 0x0,
    0xbfe65af5a0e5d0bf, 0x0,
    0xbfe1ece1d6276bcb, 0x0,
    0x3f803394cae0782f, 0x0,
    0x3fe2cd7039c7e782, 0x0,
    0x3fe81f4e93b9c1c7, 0x0,
    0x3fdaa6ebaf9c2526, 0x0,
    0xbfab6ad489c5cd66, 0x0,
    0xbfdfc2802c6726f0, 0x0,
    0xbfe7a51605665aa0, 0x0,
    0xbfda3bbf2517df5e, 0x0,
    0x3f759c824e11cb8f, 0x0,
    0x3fe1e408a20bdee2, 0x0,
    0x3fe7aedafd9bf857, 0x0,
    0x3fe0154b56cd0001, 0x0,
    0x3fbb554af239803a, 0x0,
    0xbfdd3ec3b58a6390, 0x0,
    0xbfe73a6bb81b00c0, 0x0,
    0xbfdd6bf8294c052c, 0x0,
    0x3fa7c6a7e8a461f7, 0x0,
    0x3fe1ef01e2b3aea3, 0x0,
    0x3fe8665e0552d1c3, 0x0,
    0x3fdf7ddb75a0e4df, 0x0,
    0xbf9907d76d09c61e, 0x0,
    0xbfdc27d13ad9d364, 0x0,
    0xbfe5d292733c5bf6, 0x0,
    0xbfe23edb987f4c81, 0x0,
    0xbf9ab9ca7dc4dc59, 0x0,
    0x3fdfaded4e05d5ed, 0x0,
    0x3fe4e9a33076b1f1, 0x0,
    0x3fe00eef3db05175, 0x0,
    0x3f9d6a3a09303e86, 0x0,
    0xbfdacc30a1c43842, 0x0,
    0xbfea5d2672401294, 0x0,
    0xbfdf66f3c0f7f686, 0x0,
    0xbf9adc8b7959e4bd, 0x0,
    0x3fdd4cd51caf57de, 0x0,
    0x3fe75145cc817aee, 0x0,
    0x3fddeaff429b16f0, 0x0,
    0xbfa51903a92f5661, 0x0,
    0xbfe0e1206c76d582, 0x0,
    0xbfe38149e6370ed1, 0x0,
    0xbfdf07984217d947, 0x0,
    0xbf950d9e9e6c514a, 0x0,
    0x3fda17dbadbd5652, 0x0,
    0x3fe55d041a864eba, 0x0,
    0x3fe0449a9318dafb, 0x0,
    0xbfa5a162f44b0d0d, 0x0,
    0xbfde8689cf78b2e1, 0x0,
    0xbfe4ad40cb7acffe, 0x0,
    0xbfe36fccb674a356, 0x0,
    0x3fa1c50870967a10, 0x0,
    0x3fe19068bb0bc8f1, 0x0,
    0x3fe75194540239fc, 0x0,
    0x3fddaf237ce3f498, 0x0,
    0xbf710150ee9c66c0, 0x0,
    0xbfdacf36a47b896a, 0x0,
    0xbfe6106f3f999af8, 0x0,
    0xbfdcc7394108c821, 0x0,
    0xbfbc3b700e9fd0af, 0x0,
    0x3fde35fc0b751645, 0x0,
    0x3fe391f0a777f156, 0x0,
    0x3fdcb94f0620af47, 0x0,
    0xbf85999f3be735f5, 0x0,
    0xbfdd0d04501aceb8, 0x0,
    0xbfe4d7f934d3582d, 0x0,
    0xbfe12ccab1e61e0a, 0x0,
    0x3fa253cc2a779182, 0x0,
    0x3fdc0c9b5e96f412, 0x0,
    0x3fe5b076cfe7a915, 0x0,
    0x3fdb7d5ec2355d7a, 0x0,
    0x3f9c23cc3515820d, 0x0,
    0xbfdc1958356b18d9, 0x0,
    0xbfe5518f6014ca72, 0x0,
    0xbfde66a8bfb1f443, 0x0,
    0x3f721a45784de359, 0x0,
    0x3fe2d22b6e09064f, 0x0,
    0x3fe83318d1e23e04, 0x0,
    0x3fdff69a51c9ec92, 0x0,
    0xbf93a8422583b9db, 0x0,
    0xbfdd8654a148c2ef, 0x0,
    0xbfe50aa9b79ad16f, 0x0,
    0xbfe1eeeb4788531e, 0x0,
    0xbfabdfca7706b8d4, 0x0,
    0x3fdc348517fe3f11, 0x0,
    0x3fe7e12209fa2d69, 0x0,
    0x3fe0fca79bf78732, 0x0,
    0xbf954c07a7a0a379, 0x0,
    0xbfe2300f7662a12c, 0x0,
    0xbfe32a8c9742ef75, 0x0,
    0xbfdba89cafb7ce38, 0x0,
    0x3fc0fe73fcae703f, 0x0,
    0x3fe08291de41bcac, 0x0,
    0x3fe4b3bf00ed4098, 0x0,
    0x3fe0069a98289750, 0x0,
    0xbf8781faab76aab7, 0x0,
    0xbfe0e15ff375a2e3, 0x0,
    0xbfe7100ecc8a9425, 0x0,
    0xbfdf474c25ef80d7, 0x0,
    0xbfa5ee119b85d0d0, 0x0,
    0x3fde6d58f45255a4, 0x0,
    0x3fe77128f0c9227b, 0x0,
    0x3fde59c40937ab22, 0x0,
    0x3fa3c35a8201b037, 0x0,
    0xbfe14dd21acddd58, 0x0,
    0xbfe834b01bd2e063, 0x0,
    0xbfdc872f487f551f, 0x0,
    0xbfaf7c7614baef34, 0x0,
    0x3fe1591d4905da9f, 0x0,
    0x3fe54e1c203df589, 0x0,
    0x3fe0a229b4b35564, 0x0,
    0xbfacc9c6ebcf9c46, 0x0,
    0xbfde6be1e701b521, 0x0,
    0xbfe44dcd90e61696, 0x0,
    0xbfdda91bf1d9074f, 0x0,
    0x3f6af853ab711b4a, 0x0,
    0x3fdfd84053808276, 0x0,
    0x3fe594428e0d401d, 0x0,
    0x3fe0096186bea2a3, 0x0,
    0x3f9615a085f0ad0b, 0x0,
    0xbfe27d3ae9109bd8, 0x0,
    0xbfe6ba607782192f, 0x0,
    0xbfe1968f85ca7e22, 0x0,
    0xbfb09e79a562a73d, 0x0,
    0x3fdda90c1e1bdf52, 0x0,
    0x3fe4b1be28a9d7cf, 0x0,
    0x3fe15e4e09ab34ca, 0x0,
    0x3f99b11f77091407, 0x0,
    0xbfdab01f65e8eee4, 0x0,
    0xbfe774bb5f953b31, 0x0,
    0xbfe0412e6a9053bb, 0x0,
    0x3fa0275eb977287b, 0x0,
    0x3fdd33638655cfb2, 0x0,
    0x3fe64e1848248a37, 0x0,
    0x3fe0438cf77d0dbb, 0x0,
    0xbf803defaaeff5bf, 0x0,
    0xbfdc1cac281d5ed2, 0x0,
    0xbfe56569d1a082c5, 0x0,
    0xbfe0d45263eaf2bb, 0x0,
    0xbf94cbfa94af5599, 0x0,
    0x3fe067555f5e9dc7, 0x0,
    0x3fe286b5263f6848, 0x0,
    0x3fe296d6419590a6, 0x0,
    0x3fa0e9d66ca26f4c, 0x0,
    0xbfe173bf6f1e8deb, 0x0,
    0xbfe49396c74c8199, 0x0,
    0xbfdc0a45645672b0, 0x0,
    0xbf902d93030356e5, 0x0,
    0x3fdf8847bcf0d53e, 0x0,
    0x3fe703c2f7ddc5bf, 0x0,
    0x3fe05260a6aa1f0f, 0x0,
    0x3fa67e869b7f3d87, 0x0,
    0xbfdee04772c8d416, 0x0,
    0xbfe59d408094994e, 0x0,
    0xbfe0bdef96000ecf, 0x0,
    0xbfa5bc1e0bfc1ce1, 0x0,
    0x3fdff1f1ac9c0ab4, 0x0,
    0x3fe5efcb2b866281, 0x0,
    0x3fe03fe84634a4ce, 0x0,
    0xbf9bddb9b55c5239, 0x0,
    0xbfde9c3be98ee09a, 0x0,
    0xbfe6d207d16c63dd, 0x0,
    0xbfdf2321751ce04d, 0x0,
    0x3fa450da36f78d4e, 0x0,
    0x3fdeb1124af0b75d, 0x0,
    0x3fe69ef46713708d, 0x0,
    0x3fe06381e7c33f34, 0x0,
    0xbfc01bacc6414b2e, 0x0,
    0xbfe1aa158ad164f4, 0x0,
    0xbfe78d24d003be73, 0x0,
    0xbfdd5270f4ea9dc8, 0x0,
    0x3facd3dfff103092, 0x0,
    0x3fdc57f0d81528fa, 0x0,
    0x3fe37aeb3ef137dc, 0x0,
    0x3fda56e304063a85, 0x0,
    0xbfa1cb13fb66d3fe, 0x0,
    0xbfdef9b32028dac3, 0x0,
    0xbfe5afba43a87950, 0x0,
    0xbfdf2a08825dfa13, 0x0,
    0x3f8aa1a9daff1817, 0x0,
    0x3fdc3ad4ac1ee574, 0x0,
    0x3fe90208d7b5fe85, 0x0,
    0x3fe0637dba460eb8, 0x0,
    0x3fbce99cfbf094b6, 0x0,
    0xbfddf0a7d68b2c6a, 0x0,
    0xbfe4912fc10de7dc, 0x0,
    0xbfe1b0a6d64fd289, 0x0,
    0xbf984b7d1335d442, 0x0,
    0x3fdd3a830782d649, 0x0,
    0x3fe5d80cbd26cf77, 0x0,
    0x3fdeed210e5786fb, 0x0,
    0x3fa4623b79b9922c, 0x0,
    0xbfd9b6bf73af62fc, 0x0,
    0xbfe814f919ee3172, 0x0,
    0xbfe14882ccfa2bd6, 0x0,
    0xbfa0180bb264af70, 0x0,
    0x3fe069f969b31ea0, 0x0,
    0x3fe95bd9566e48d7, 0x0,
    0x3fddaf8547d303df, 0x0,
    0x3fb34d8ca7b08ad2, 0x0,
    0xbfdd3f2de3a5483e, 0x0,
    0xbfe64762d4c44393, 0x0,
    0xbfe34e3bf8fda2fa, 0x0,
    0x3fb503db8bd8abe9, 0x0,
    0x3fe115632bec817f, 0x0,
    0x3fea7a43754f8c5a, 0x0,
    0x3fdc8c8a5c47adeb, 0x0,
    0x3f7a624a97c411de, 0x0,
    0xbfdfa21aca71d24e, 0x0,
    0xbfe500fac88c8606, 0x0,
    0xbfe1068eadd2b20d, 0x0,
    0xbfb318815d8dc58c, 0x0,
    0x3fe0ab16fc7049f8, 0x0,
    0x3fe6d3bc4ab2d424, 0x0,
    0x3fe14548cde12628, 0x0,
    0x3fa1bdd026d9b4a6, 0x0,
    0xbfda83289a5f91da, 0x0,
    0xbfe64754e1b66a7e, 0x0,
    0xbfdcd05dac4bb1a4, 0x0,
    0x3fb8903eeb8e7b85, 0x0,
    0x3fdc6573676a6be6, 0x0,
    0x3fe4f2fd1d9e2a0d, 0x0,
    0x3fde28c06232343b, 0x0,
    0xbfb3960ca974ab85, 0x0,
    0xbfd9d3da01d079da, 0x0,
    0xbfe5a51c51a80276, 0x0,
    0xbfe19d142d412363, 0x0,
    0xbf261d23e02edbd5, 0x0,
    0x3fe0ad2de9e352c7, 0x0,
    0x3fe6c8f2acced5ba, 0x0,
    0x3fdb37b7dd411bec, 0x0,
    0xbf7cde7d866892da, 0x0,
    0xbfde53294dd66fbd, 0x0,
    0xbfe6736518ac6bfa, 0x0,
    0xbfe09f42fcc2a9bc, 0x0,
    0xbf988a0f5325c314, 0x0,
    0x3fe0760c60af9230, 0x0,
    0x3fe5cf756dc9d902, 0x0,
    0x3fe26e8343ff5287, 0x0,
    0x3f9ce371e4ffe2c1, 0x0,
    0xbfe1bcf9c3253127, 0x0,
    0xbfe7e9ea136ec392, 0x0,
    0xbfdf8d0b83f452a1, 0x0,
    0x3f82808fa521f2e5, 0x0,
    0x3fdcce5cf4017a6c, 0x0,
    0x3fe407b428710809, 0x0,
    0x3fe071e1fcac0b31, 0x0,
    0x3fb52145ecd409fe, 0x0,
    0xbfe0aca07cd58d5d, 0x0,
    0xbfe9395f99624c76, 0x0,
    0xbfe03c4b7871eb1a, 0x0,
    0xbfa6d19b4a578bce, 0x0,
    0x3fde084e7441f99c, 0x0,
    0x3fe629f9f54df00d, 0x0,
    0x3fe2b5311f0751de, 0x0,
    0xbf9ef50b82c2f53b, 0x0,
    0xbfe26128f20c2ad2, 0x0,
    0xbfe4f208c818e65a, 0x0,
    0xbfdc034d53bb58f5, 0x0,
    0x3f9bb5d579866353, 0x0,
    0x3fe11530be89c548, 0x0,
    0x3fe6eb16a5ef13ac, 0x0,
    0x3fe181da1be864d6, 0x0,
    0xbf93d0d932e1c23b, 0x0,
    0xbfdd873afcc2e1b1, 0x0,
    0xbfe50898488a6b83, 0x0,
    0xbfe046d12195493a, 0x0,
    0x3fa95aaec2d9d98a, 0x0,
    0x3fe15ab68969a51d, 0x0,
    0x3fe6df60595f69c9, 0x0,
    0x3fe36a6fd13a7a08, 0x0,
    0xbf9e2760976feb89, 0x0,
    0xbfdf8f205333a78e, 0x0,
    0xbfe3695834a1392e, 0x0,
    0xbfdd232b4098ffbb, 0x0,
    0x3fb4a20980c80d07, 0x0,
    0x3fdbc302f4e1417a, 0x0,
    0x3fe754be6229e3d9, 0x0,
    0x3fdd854d4324b3ad, 0x0,
    0x3fa0651778dbf22f, 0x0,
    0xbfdfeeba78866a38, 0x0,
    0xbfe47a3b2effae34, 0x0,
    0xbfdeeeb8f7f20b1e, 0x0,
    0xbfa54d3e5f0bf8c0, 0x0,
    0x3fdb758b8f14e708, 0x0,
    0x3fe67b8159e4f79a, 0x0,
    0x3fdfd28f8035ccbd, 0x0,
    0x3fa6e99c2e8f7211, 0x0,
    0xbfdcc5a219b15304, 0x0,
    0xbfe7188261352a1f, 0x0,
    0xbfe1493937abe8b7, 0x0,
    0xbfaa052b5c40792f, 0x0,
    0x3fde84a0b0cdfaad, 0x0,
    0x3fe6307ffd2ed241, 0x0,
    0x3fdd8c16847ad6af, 0x0,
    0x3fa06e70cfce7de6, 0x0,
    0xbfdb122cddb22d90, 0x0,
    0xbfe6972a4a0e8ff1, 0x0,
    0xbfd7f7898297ff4c, 0x0,
    0xbf8017566e2bfd54, 0x0,
    0x3fd9fcd49fc5d984, 0x0,
    0x3fe62e2ae5d488e9, 0x0,
    0x3fdeea0d679f5d2e, 0x0,
    0x3fa5e7ce5f7f6b58, 0x0,
    0xbfd7c6f1330094ee, 0x0,
    0xbfe50994f055fc79, 0x0,
    0xbfe0d3db8eac96a1, 0x0,
    0x3fb2899795ccc796, 0x0,
    0x3fe09fbf12fbdc27, 0x0,
    0x3fe843e8c73a183a, 0x0,
    0x3fe117f424fd516e, 0x0,
    0x3f8eea1ed284234a, 0x0,
    0xbfdc8c6bcf01c0bf, 0x0,
    0xbfe68bead184aa14, 0x0,
    0xbfdd549e67d3c9b2, 0x0,
    0xbfa28e07ffe9c7d3, 0x0,
    0x3fe28f65d679fbd2, 0x0,
    0x3fe76bb86134e4ec, 0x0,
    0x3fdf75ce729abb44, 0x0,
    0xbfa3508a59978c1f, 0x0,
    0xbfde43661cf17ef8, 0x0,
    0xbfe4f6960158767c, 0x0,
    0xbfde5146468eba1f, 0x0,
    0x3f908254b7ca7251, 0x0,
    0x3fdd7f2c156c206e, 0x0,
    0x3fe75469943c8025, 0x0,
    0x3fe0dc0f8199c08f, 0x0,
    0x3f9298d104da0f93, 0x0,
    0xbfd893a0e86a6535, 0x0,
    0xbfe865e832d8849f, 0x0,
    0xbfd889e7997611d1, 0x0,
    0x3fc210b5e346cd7f, 0x0,
    0x3fe248d73d5f91ab, 0x0,
    0x3fe50b2ee9e2c9da, 0x0,
    0x3fdc9f39b34187e8, 0x0,
    0xbf91ffebaf47d7ba, 0x0,
    0xbfe2ccc8adbdd0f8, 0x0,
    0xbfe5f31780b3aa76, 0x0,
    0xbfde968b0994cf64, 0x0,
    0xbfa6464fb815a516, 0x0,
    0x3fe24a86dd6027c7, 0x0,
    0x3fe8d4eb4a17dd0b, 0x0,
    0x3fe03f892961a928, 0x0,
    0x3f88db8468e58f24, 0x0,
    0xbfe17230fb6de137, 0x0,
    0xbfe5c6ef2b2eb92b, 0x0,
    0xbfe03120989d9386, 0x0,
    0xbfb05ffbb6f09f16, 0x0,
    0x3fe02cf7b1094059, 0x0,
    0x3fe5f895ec20b927, 0x0,
    0x3fe241cf590a9cab, 0x0,
    0x3f86b87a938cdae6, 0x0,
    0xbfe050bfc7f7bb62, 0x0,
    0xbfe955c0271850f9, 0x0,
    0xbfddbe36a157c8ca, 0x0,
    0x3f8c19f530c37ea6, 0x0,
    0x3fe0ec44eca4223c, 0x0,
    0x3fe7fa8f92cfe46b, 0x0,
    0x3fe1b17b54912872, 0x0,
    0xbf7c8fce9ce6ae40, 0x0,
    0xbfe0a0ec8d1faa7f, 0x0,
    0xbfe7e233d3e67624, 0x0,
    0xbfdd8b397cb75e9e, 0x0,
    0x3f7055e5628dc7c7, 0x0,
    0x3fe0f580c013be73, 0x0,
    0x3fe68a08069d9227, 0x0,
    0x3fdffe308a2e0f02, 0x0,
    0xbfc0ccf01315b18d, 0x0,
    0xbfe1f6a0dad98f99, 0x0,
    0xbfe6a44202d75b0d, 0x0,
    0xbfddb1075bf0d942, 0x0,
    0xbfa48ef245a0b1ac, 0x0,
    0x3fe167444c27e7ed, 0x0,
    0x3fe5c5a970425879, 0x0,
    0x3fe0618239f36665, 0x0,
    0x3f5a82a64cee8b5e, 0x0,
    0xbfe15b968ef145e8, 0x0,
    0xbfe535be8a8498df, 0x0,
    0xbfdc8fd8c6630d98, 0x0,
    0xbf8b547c219ff0d4, 0x0,
    0x3fe181e8b6a70b1c, 0x0,
    0x3fe5807241f97fb7, 0x0,
    0x3fe28a60f908c444, 0x0,
    0x3f7aa2de22de46e1, 0x0,
    0xbfdf400a3c06a9f4, 0x0,
    0xbfe62af86a350919, 0x0,
    0xbfdf2e0fd2b07dcf, 0x0,
    0xbfa76f7280e66e3f, 0x0,
    0x3fdd03bbb5b16b11, 0x0,
    0x3fe7ea45d1fbe156, 0x0,
    0x3fdb224eaac41fb8, 0x0,
    0xbfb44d5771208eae, 0x0,
    0xbfdc37f8dfe2d741, 0x0,
    0xbfe68c2a9695494f, 0x0,
    0xbfe1d1dc338f4e0b, 0x0,
    0x3fb7f5691ba71e19, 0x0,
    0x3fdc6748d1acace3, 0x0,
    0x3fe51c20b37aae26, 0x0,
    0x3fe0a32dde5770d9, 0x0,
    0xbf85d8bec2622ce5, 0x0,
    0xbfdd7ae9bb09c2d6, 0x0,
    0xbfe57c3d86b4d9d1, 0x0,
    0xbfded997c97928c6, 0x0,
    0xbfa6959897ce90af, 0x0,
    0x3fe108fa887d3f4c, 0x0,
    0x3fe7a6e41d8d9471, 0x0,
    0x3fe021ff302cd798, 0x0,
    0xbfa7bb074bc69265, 0x0,
    0xbfdebc6e7b69ec57, 0x0,
    0xbfe7ccdc1a21eebd, 0x0,
    0xbfe094e676b17bcb, 0x0,
    0x3f7ec5a34e91ae9f, 0x0,
    0x3fde4919b3036424, 0x0,
    0x3fe85a9702a3c786, 0x0,
    0x3fe0a275232440d2, 0x0,
    0x3f8008dff34e2205, 0x0,
    0xbfdf854964d8cfef, 0x0,
    0xbfe674d6c63e4e9d, 0x0,
    0xbfe345c9462f9880, 0x0,
    0x3f9ee4ee5d0b6978, 0x0,
    0x3fdb9cad5303132d, 0x0,
    0x3fe8caae4490c366, 0x0,
    0x3fde793445c585f5, 0x0,
    0x3fa01f1f9dcc99b1, 0x0,
    0xbfe0d28255b47f32, 0x0,
    0xbfe553fa34ebedf1, 0x0,
    0xbfdcfb0a940ba47f, 0x0,
    0xbfab820fdc629464, 0x0,
    0x3fdfea5d63f23ca4, 0x0,
    0x3fe72b7c6ac5f222, 0x0,
    0x3fdec1bc1536777e, 0x0,
    0x3fbb8c68302bf476, 0x0,
    0xbfe03c8b6efdedba, 0x0,
    0xbfe90719596b6cab, 0x0,
    0xbfe011693c54b8c9, 0x0,
    0x3f9970792fb32a21, 0x0,
    0x3fdd1ea42024fe91, 0x0,
    0x3fe7f52735b5e8bd, 0x0,
    0x3fe07147d488cf2b, 0x0,
    0x3f8b2c604209bb8e, 0x0,
    0xbfde64364846d67e, 0x0,
    0xbfe69341bb59ebbc, 0x0,
    0xbfde72b21f776bbd, 0x0,
    0xbf91d7d14b5e7b82, 0x0,
    0x3fe17c3f49b444f9, 0x0,
    0x3fe64a2275a3a07e, 0x0,
    0x3fde0c8d95f16d53, 0x0,
    0xbf90860703bbcefd, 0x0,
    0xbfdf129452a9df11, 0x0,
    0xbfe6fd265aa5e23e, 0x0,
    0xbfe02c39dd742605, 0x0,
    0x3f717381e44844ba, 0x0,
    0x3fe12d6da002df00, 0x0,
    0x3fe5a1582bad274e, 0x0,
    0x3fe183680fc01101, 0x0,
    0x3f8fe133577a0210, 0x0,
    0xbfdba0d204a2ca38, 0x0,
    0xbfe4b22fa0d848a1, 0x0,
    0xbfde328c197de9d2, 0x0,
    0xbf816af90f47cbda, 0x0,
    0x3fe015d4c740fed3, 0x0,
    0x3fe504242de92af3, 0x0,
    0x3fd831a9de09b48c, 0x0,
    0x3fab551a2907bba4, 0x0,
    0xbfdffe84eb52189c, 0x0,
    0xbfe69e289fab863b, 0x0,
    0xbfdf3787e915c790, 0x0,
    0x3fa715e1f2d06859, 0x0,
    0x3fe0861496738c38, 0x0,
    0x3fe75852e939fc97, 0x0,
    0x3fdd64161f13e237, 0x0,
    0x3f9d7b81ce34a6da, 0x0,
    0xbfe0b4ad6ec470e5, 0x0,
    0xbfe47710029225e8, 0x0,
    0xbfe086877ccd36fb, 0x0,
    0xbfb70729159a97bc, 0x0,
    0x3fe1276d7ef45c1a, 0x0,
    0x3fe69fd35a780838, 0x0,
    0x3fe2d829f62f9ba1, 0x0,
    0x3f84afd49de8623e, 0x0,
    0xbfdbcf1b5dd4e74e, 0x0,
    0xbfe80a44b9ecac02, 0x0,
    0xbfdcedf5be527e92, 0x0,
    0xbf99b5dac85f25a3, 0x0,
    0x3fe023660bbde319, 0x0,
    0x3fea7b84aa82d10e, 0x0,
    0x3fe0cb19b33704e8, 0x0,
    0x3fa9cdedb4752bd7, 0x0,
    0xbfe03093ef76d464, 0x0,
    0xbfe6ec677cd6c188, 0x0,
    0xbfe1c5bb70074f3d, 0x0,
    0x3fa13ebde49e2514, 0x0,
    0x3fe0df498bd100cc, 0x0,
    0x3fe813f97487f5a4, 0x0,
    0x3fded034d60af2e8, 0x0,
    0xbfa458ae4d40ec0c, 0x0,
    0xbfdee8e371588861, 0x0,
    0xbfe2bd8195c78b10, 0x0,
    0xbfde1cfa2d4fd515, 0x0,
    0x3fa9959336837078, 0x0,
    0x3fdc6fa883ade1fe, 0x0,
    0x3fe5ba42a461df48, 0x0,
    0x3fe00567e34a0da4, 0x0,
    0x3fa4836c27725df7, 0x0,
    0xbfdf62a5ad3d87d4, 0x0,
    0xbfe97ee676d1ba0b, 0x0,
    0xbfdf8505f344b40a, 0x0,
    0xbfb293574720842f, 0x0,
    0x3fde60afc70ab531, 0x0,
    0x3fe4d16d66229485, 0x0,
    0x3fe1fda701785dfe, 0x0,
    0x3fb018f2886efb66, 0x0,
    0xbfdefa4bb49e9341, 0x0,
    0xbfe76c15d002eb67, 0x0,
    0xbfe3414372e22fce, 0x0,
    0xbfb4a673346bff0a, 0x0,
    0x3fdcfa5b243e92a4, 0x0,
    0x3fe71a6e919b471f, 0x0,
    0x3fdf6a70d7b7df75, 0x0,
    0xbfa6e4af03128c9d, 0x0,
    0xbfdf643ce227e165, 0x0,
    0xbfe695d3eee3cf63, 0x0,
    0xbfda44bce1f48f5a, 0x0,
    0xbfa342e802be058c, 0x0,
    0x3fe194f02a02e951, 0x0,
    0x3fe8a369b87bcaac, 0x0,
    0x3fdf0cfe33ecb459, 0x0,
    0x3f7019b847031ae0, 0x0,
    0xbfdcdc8094005639, 0x0,
    0xbfe3763893311c7d, 0x0,
    0xbfe0977a03b7d242, 0x0,
    0x3fb9068a2aa5cf52, 0x0,
    0x3fdf5d84a48546c6, 0x0,
    0x3fe7e1fea671e568, 0x0,
    0x3fe0028e9b8480ac, 0x0,
    0x3f9ebf6cf6b3baf1, 0x0,
    0xbfd8a03c18a10bbb, 0x0,
    0xbfe5bcbfc7ab1d01, 0x0,
    0xbfe21b8b302e0849, 0x0,
    0xbf968ed45c4eacb4, 0x0,
    0x3fda414c49f0e2c4, 0x0,
    0x3fe69a2f174858ab, 0x0,
    0x3fe09e2313818216, 0x0,
    0x3fa44ce7fcbc070b, 0x0,
    0xbfe0f8c8dd7130ae, 0x0,
    0xbfe6f5879355d37a, 0x0,
    0xbfded78bcabc5f04, 0x0,
    0x3fae125b15fbf059, 0x0,
    0x3fe0592e4e45cae6, 0x0,
    0x3fe6cf6f0ce61182, 0x0,
    0x3fdc067cbd905f16, 0x0,
    0x3f87b7f3fda9247f, 0x0,
    0xbfdc99419b6e4274, 0x0,
    0xbfe6de66dc7391ef, 0x0,
    0xbfddb8ac77451ae9, 0x0,
    0xbfb5a24f265eaa20, 0x0,
    0x3fde38e7ee9632e7, 0x0,
    0x3fe5cba4b079d1c4, 0x0,
    0x3fdd1b48d776400c, 0x0,
    0xbfa4b1e41cb42575, 0x0,
    0xbfe07f49970ed100, 0x0,
    0xbfe920fbe0d1228a, 0x0,
    0xbfde5422268eb706, 0x0,
    0x3f8d23567c75a68a, 0x0,
    0x3fde95dc2b9f74cd, 0x0,
    0x3fe8a49ca4f13640, 0x0,
    0x3fdf16e29654194b, 0x0,
    0x3fb06a804f23940b, 0x0,
    0xbfe2851f300b0331, 0x0,
    0xbfe5ee22cf9b642e, 0x0,
    0xbfdd3c2b401bfa70, 0x0,
    0x3fa8e98eb1eef8f2, 0x0,
    0x3fdde6927157daf7, 0x0,
    0x3fe982525849e2b9, 0x0,
    0x3fdc1a0e9a95ee9e, 0x0,
    0xbfb247832605d0ad, 0x0,
    0xbfe05768b15387ac, 0x0,
    0xbfe89e0e90d49f65, 0x0,
    0xbfe0c75333fada68, 0x0,
    0xbfa3d2982eb51528, 0x0,
    0x3fda76fed72bea2e, 0x0,
    0x3fe5b69477d3919b, 0x0,
    0x3fe289ecd68cdd1e, 0x0,
    0x3f97e0798e82f952, 0x0,
    0xbfdfe60e251122e4, 0x0,
    0xbfe4f3e1154b2081, 0x0,
    0xbfe2d1c14f677763, 0x0,
    0x3f8aa1519a2ee0e8, 0x0,
    0x3fdf5435b0e7a424, 0x0,
    0x3fe5c35cb2607de7, 0x0,
    0x3fe0bd719754e284, 0x0,
    0xbf604725805b3ca6, 0x0,
    0xbfdef5b95fa442b2, 0x0,
    0xbfe5e585cd885a00, 0x0,
    0xbfe327b8534c38b8, 0x0,
    0xbfb264f275fd9f34, 0x0,
    0x3fe1f90cc41bbb37, 0x0,
    0x3fe60e152570e7ac, 0x0,
    0x3fdd44ea674dc618, 0x0,
    0xbf9f7b0f82062c3f, 0x0,
    0xbfdd995bb381cced, 0x0,
    0xbfe59911d8359284, 0x0,
    0xbfe1ff386a5cfe25, 0x0,
    0x3fb240a69cc3a9fc, 0x0,
    0x3fde4adfc6e9c8d8, 0x0,
    0x3fe5b4aa55d174de, 0x0,
    0x3fdd802b223f64fa, 0x0,
    0xbf8bfff751a403f9, 0x0,
    0xbfe3c32fc71eeb3f, 0x0,
    0xbfe81957a289257c, 0x0,
    0xbfdf5f0ac0e5ee98, 0x0,
    0x3f9861f32759f686, 0x0,
    0x3fdfdc29b9096100, 0x0,
    0x3fe80d743ca2cf7c, 0x0,
    0x3fe17b772ca3c002, 0x0,
    0x3f78108afbde0c84, 0x0,
    0xbfdc91490151fb76, 0x0,
    0xbfe74bf43c466628, 0x0,
    0xbfddf4f7964f8bff, 0x0,
    0x3faf77e8a18428d8, 0x0,
    0x3fe0c78aca3a50ac, 0x0,
    0x3fe437507ebb5ef6, 0x0,
    0x3fdfd941311aba7c, 0x0,
    0x3f918aeec0103717, 0x0,
    0xbfdfd5915a1e9156, 0x0,
    0xbfe5f16e7f7cd9e7, 0x0,
    0xbfde338c6dd04501, 0x0,
    0x3fac3ebe8b496a9b, 0x0,
    0x3fe1bf8d9c8f538d, 0x0,
    0x3fe652076c8e5264, 0x0,
    0x3fdc3347a1a092fd, 0x0,
    0xbfada6616642c6f7, 0x0,
    0xbfdf73414e593ab1, 0x0,
    0xbfe6cff481bad90b, 0x0,
    0xbfdf9679957bf413, 0x0,
    0xbf85ffe852fe0b9e, 0x0,
    0x3fdcf89791bed902, 0x0,
    0x3fe5059b9d49e5c0, 0x0,
    0x3fe1e5f8219aaac8, 0x0,
    0x3f9e96850910a143, 0x0,
    0xbfde09cf940ad866, 0x0,
    0xbfe6597c1298e98d, 0x0,
    0xbfdc07a3f25d14c8, 0x0,
    0xbfa225b9335dd4e3, 0x0,
    0x3fe16cb3d52e2fc9, 0x0,
    0x3fea1c27e1fd9b80, 0x0,
    0x3fdf3a88956d4b22, 0x0,
    0x3fb617669f870986, 0x0,
    0xbfe0162e33da020e, 0x0,
    0xbfe8f9c651bcca8e, 0x0,
    0xbfdcd1d731052ccc, 0x0,
    0xbfc09d6ba8cca8ec, 0x0,
    0x3fd97c500226ba27, 0x0,
    0x3fe82dc8c48603ce, 0x0,
    0x3fdef76c2c154413, 0x0,
    0xbf70d0de44ec195e, 0x0,
    0xbfdeb222cefb035d, 0x0,
    0xbfe578eece5bf8fe, 0x0,
    0xbfde324ec1690325, 0x0,
    0xbf4ecc4f29dd7863, 0x0,
    0x3fe22e580064a87b, 0x0,
    0x3fe669189f6d211e, 0x0,
    0x3fdcba9af6a55a9c, 0x0,
    0xbf97a7f0f19fb98e, 0x0,
    0xbfdb91d7d322fbfb, 0x0,
    0xbfe62a7678865e43, 0x0,
    0xbfdc17c686229432, 0x0,
    0x3f738135885fa43c, 0x0,
    0x3fdf66ae8e25ddab, 0x0,
    0x3fe50356a35690fe, 0x0,
    0x3fe1794e6ef07430, 0x0,
    0x3f11e373961e422a, 0x0,
    0xbfdcd45b17a7546c, 0x0,
    0xbfe669494044dfda, 0x0,
    0xbfe151f9cce726a9, 0x0,
    0x3f67757f285430a0, 0x0,
    0x3fdb2045dd3c2633, 0x0,
    0x3fe51f7d60188744, 0x0,
    0x3fdd0a0fe5897b55, 0x0,
    0xbf82b8d9b8afbe06, 0x0,
    0xbfe18e8eea69203a, 0x0,
    0xbfe69ea245cb77da, 0x0,
    0xbfda6ab9ea05f147, 0x0,
    0x3fa73d59aac22eb4, 0x0,
    0x3fe0b78279921b31, 0x0,
    0x3fe758d36217c4c6, 0x0,
    0x3fdda641b34444be, 0x0,
    0xbfa0cac5216296e6, 0x0,
    0xbfdfcca5a55b7a82, 0x0,
    0xbfe6af35882d8f83, 0x0,
    0xbfddc54a33050b8a, 0x0,
    0xbfa29bcc1fdde3fa, 0x0,
    0x3fe05d68e9ce6deb, 0x0,
    0x3fe598dd4b88ef80, 0x0,
    0x3fe2588d8687df19, 0x0,
    0xbfb5d83d85846efc, 0x0,
    0xbfe03bebcd4aa46a, 0x0,
    0xbfe837847c6d8522, 0x0,
    0xbfe1e71dc99e4f6b, 0x0,
    0xbfa2a6dbbc658f11, 0x0,
    0x3fddd301b9c8eda8, 0x0,
    0x3fe4c0d0d6b464f4, 0x0,
    0x3fe06993d93c95ac, 0x0,
    0x3f7f035eed0a7b90, 0x0,
    0xbfd9af37b528050e, 0x0,
    0xbfe5a1cb1e0c1b9b, 0x0,
    0xbfe0839e95439646, 0x0,
    0xbfa19259d5a0cfac, 0x0,
    0x3fe0bc537ad617fc, 0x0,
    0x3fe5e8432d0bda63, 0x0,
    0x3fdcc90b3cb4fd20, 0x0,
    0xbfa7cd9c23c4c17b, 0x0,
    0xbfe1edd8dc2ce58a, 0x0,
    0xbfe2532e6d79d7a3, 0x0,
    0xbfdb57124fadbaa8, 0x0,
    0x3f87752c2a09759d, 0x0,
    0x3fe08fe16464b78f, 0x0,
    0x3fe7995eb7657a5f, 0x0,
    0x3fdc49b3f4b33963, 0x0,
    0x3fb1dd3dfc143636, 0x0,
    0xbfe0a461b9e40b50, 0x0,
    0xbfe8841a3bdf2bd0, 0x0,
    0xbfd9fbae78713539, 0x0,
    0x3f741f0139af4dee, 0x0,
    0x3fdf935bfde00186, 0x0,
    0x3fe7ae954adbd146, 0x0,
    0x3fe15d330cc8b4f1, 0x0,
    0x3f950560e482c7dc, 0x0,
    0xbfdbfd141d4cf4b8, 0x0,
    0xbfe6863605bdc91d, 0x0,
    0xbfdb9d926b4f72a1, 0x0,
    0x3fb3af87333874fc, 0x0,
    0x3fe0c076d5ef04a1, 0x0,
    0x3fe7c2fd32fe0cfd, 0x0,
    0x3fe26444869a6586, 0x0,
    0xbf828454e8131b06, 0x0,
    0xbfdb1cdc6554f826, 0x0,
    0xbfe5c3fa3332af61, 0x0,
    0xbfe03abf4a9bf53c, 0x0,
    0xbfb04ff67f56e0d0, 0x0,
    0x3fdc055030bead62, 0x0,
    0x3fe43b2a9469c9e0, 0x0,
    0x3fdda2f707e8b98b, 0x0,
    0xbfa821105daf7ce1, 0x0,
    0xbfd9fcaf2dfce626, 0x0,
    0xbfe8dbb14c55e3ed, 0x0,
    0xbfdf6380ae5f6230, 0x0,
    0xbf7a2aed0532bc18, 0x0,
    0x3fdb8f1918e1f701, 0x0,
    0x3fe6b290652d62e3, 0x0,
    0x3fe0335bac57a334, 0x0,
    0xbfb0140a4d7dc8d7, 0x0,
    0xbfda52299a7a74d6, 0x0,
    0xbfe691bafa8b910c, 0x0,
    0xbfd77214b2664464, 0x0,
    0x3f95a0cd73363c6d, 0x0,
    0x3fdc3365af2ccbea, 0x0,
    0x3fe55304d065dfa4, 0x0,
    0x3fdb05282c02a7da, 0x0,
    0x3f96cbf8cefc214f, 0x0,
    0xbfdbc6459f343aee, 0x0,
    0xbfe8d5343ad2eef2, 0x0,
    0xbfdec87a3e5fa59e, 0x0,
    0x3fac93cc7c377059, 0x0,
    0x3fe05ce94d20cb26, 0x0,
    0x3fe445b09070fa19, 0x0,
    0x3fdc24b5feb905af, 0x0,
    0xbf8508e4959c6f17, 0x0,
    0xbfe201612fdc6a98, 0x0,
    0xbfe62cc1defe73a0, 0x0,
    0xbfdf2f2c43b4e164, 0x0,
    0x3f8b3c656ab6ee3f, 0x0,
    0x3fdf2ce9d64e26f4, 0x0,
    0x3fe78f6ce3dcd291, 0x0,
    0x3fd9a8ee4e36a361, 0x0,
    0x3f844c6995f906b8, 0x0,
    0xbfdca2d0c4b61f12, 0x0,
    0xbfe488e569d98a1d, 0x0,
    0xbfd9798737b0b863, 0x0,
    0x3fac6411b958ed6a, 0x0,
    0x3fdf904eec2fd1c0, 0x0,
    0x3fe7208e2e082243, 0x0,
    0x3fdea0781b4990fb, 0x0,
    0x3f8cff5482375bd8, 0x0,
    0xbfde161fa4feeeb2, 0x0,
    0xbfe77f0da187bf68, 0x0,
    0xbfdf73af85e1a5eb, 0x0,
    0x3fa52b1f30318c92, 0x0,
    0x3fe0801773614a61, 0x0,
    0x3fe4263bba35a35e, 0x0,
    0x3fe005aa2ce248e2, 0x0,
    0xbfa8f624de7988ec, 0x0,
    0xbfdffa6bf18a873d, 0x0,
    0xbfe7a4a602989453, 0x0,
    0xbfdaa2c2de7b916e, 0x0,
    0xbfad6efbae02c249, 0x0,
    0x3fdad81cbc1d998e, 0x0,
    0x3fe57121d23b41ad, 0x0,
    0x3fe114c6c5c385d6, 0x0,
    0xbf6403daf06f13cb, 0x0,
    0xbfdfe50307c494c8, 0x0,
    0xbfe52e5a9bc0eccf, 0x0,
    0xbfde24bde3ed97c7, 0x0,
    0x3fb18cf3e1f52fd5, 0x0,
    0x3fe078a2b861b0c8, 0x0,
    0x3fe5bfc60011b573, 0x0,
    0x3fe31b60c45a6852, 0x0,
    0x3f93cda40ed3ea15, 0x0,
    0xbfe13040115718cb, 0x0,
    0xbfe6a06fb5509cc5, 0x0,
    0xbfdce5eac38ccb45, 0x0,
    0x3f98fdb6237da1f9, 0x0,
    0x3fde07634f0cbdae, 0x0,
    0x3fe8bb66cc644ea7, 0x0,
    0x3fda9321c186a264, 0x0,
    0x3fad4571a01e4724, 0x0,
    0xbfe14cf56df945f9, 0x0,
    0xbfe290b396ee5782, 0x0,
    0xbfdeb188c1715c5a, 0x0,
    0x3fa798de5354e182, 0x0,
    0x3fdf2ad508351cf8, 0x0,
    0x3fe59546b297e312, 0x0,
    0x3fde7613c8d6f4e9, 0x0,
    0xbfa268e5169a0c8d, 0x0,
    0xbfdf0d16ceaf3a94, 0x0,
    0xbfe7453b0e5da2f6, 0x0,
    0xbfe06581bba78a91, 0x0,
    0x3f50f91db9c1a599, 0x0,
    0x3fe0ba263b5068ac, 0x0,
    0x3fe5fd2a029f83f2, 0x0,
    0x3fdf989f87333eee, 0x0,
    0xbfa42eae212d7bf6, 0x0,
    0xbfdb285aa2c1cefd, 0x0,
    0xbfe63897a632526b, 0x0,
    0xbfda183090ad70ee, 0x0,
    0xbf9a74a0f58c0b79, 0x0,
    0x3fdcecb13e8919ce, 0x0,
    0x3fe7961b13abd3f1, 0x0,
    0x3fe0981f24481375, 0x0,
    0x3fb3bfa4fbf24b72, 0x0,
    0xbfda24c292d55d32, 0x0,
    0xbfe5bad4815cca68, 0x0,
    0xbfdffbf4665554e9, 0x0,
    0x3f78b56964a40209, 0x0,
    0x3fdb4bd0c31ece4e, 0x0,
    0x3fe65812a84dba38, 0x0,
    0x3fdd0a44a03e8da8, 0x0,
    0x3facb1a0b874fa4b, 0x0,
    0xbfdd0eaf5b9aad2e, 0x0,
    0xbfe1f10145963b8f, 0x0,
    0xbfdbade9f23d266a, 0x0,
    0x3f771ad74713c570, 0x0,
    0x3fe1d1074458b72c, 0x0,
    0x3fe9d5740d58879e, 0x0,
    0x3fdc4db473a08546, 0x0,
    0xbf4ad171c9b873df, 0x0,
    0xbfe14895ec469acb, 0x0,
    0xbfe7f51c4ced2810, 0x0,
    0xbfe0ab4371791b32, 0x0,
    0x3fb0521c82a808ad, 0x0,
    0x3fe301b8fae0d6e4, 0x0,
    0x3fe687ac2348ad0f, 0x0,
    0x3fdd7d60bf4cf0a4, 0x0,
    0x3f728c8048711d2a, 0x0,
    0xbfda91c0c8ec22ff, 0x0,
    0xbfe4c7993fac5219, 0x0,
    0xbfdfe84e7cd73065, 0x0,
    0x3fbbd2e9e7743150, 0x0,
    0x3fdc94c7a5a7cfbb, 0x0,
    0x3fe6edb3f0eb12c5, 0x0,
    0x3fdacb58b4982c43, 0x0,
    0x3f92ecb42e3ca584, 0x0,
    0xbfe2d944757c719a, 0x0,
    0xbfe6e0a0ee3a4523, 0x0,
    0xbfde4399ec8ac4cc, 0x0,
    0x3f974a14bc54d66b, 0x0,
    0x3fe2859304e13a3c, 0x0,
    0x3fe9806104ede09c, 0x0,
    0x3fe05a1f7d8e9907, 0x0,
    0x3fb7fb521abe02fd, 0x0,
    0xbfdf76e42bbe818b, 0x0,
    0xbfe9161c4ec3d942, 0x0,
    0xbfdf86f035db1d22, 0x0,
    0xbf9e01193ca6afa8, 0x0,
    0x3fd7bc0c04365560, 0x0,
    0x3fe66179095b0c0f, 0x0,
    0x3fddd77886279135, 0x0,
    0xbf7fd4e7faf4706e, 0x0,
    0xbfe182f9090870d8, 0x0,
    0xbfe3f07c60f846f8, 0x0,
    0xbfe007493702689a, 0x0,
    0xbfa4cc44897266c6, 0x0,
    0x3fde4d7883806951, 0x0,
    0x3fe55f1cd554a574, 0x0,
    0x3fddb2975e447f6e, 0x0,
    0xbf9dab114097fd1d, 0x0,
    0xbfe35a96ad843ba7, 0x0,
    0xbfe71b1b3b9969cf, 0x0,
    0xbfdde9b58959ba99, 0x0,
    0xbfaff4df10c7ea46, 0x0,
    0x3fe0deff25e891e0, 0x0,
    0x3fe56b595d3af0da, 0x0,
    0x3fe1d27a88725d53, 0x0,
    0x3fb286ef50f052b1, 0x0,
    0xbfde5f5534a269fc, 0x0,
    0xbfe89cc4f4e3489e, 0x0,
    0xbfe1ec470319fbdb, 0x0,
    0x3faeecb8ea0694c7, 0x0,
    0x3fdf9e746a16611d, 0x0,
    0x3fe8a57ea47b6f45, 0x0,
    0x3fde4c0a7c60ace8, 0x0,
    0xbfb0a6bb2a1f34b8, 0x0,
    0xbfe1e4a9104071f9, 0x0,
    0xbfe79727d8b44824, 0x0,
    0xbfe024fa9af5b1fe, 0x0,
    0xbfb0f9526c8e71e4, 0x0,
    0x3fdcc09b069c73ea, 0x0,
    0x3fe5abfb42aa7c82, 0x0,
    0x3fdad8d59aab5f3e, 0x0,
    0x3fa2428f3d1bb698, 0x0,
    0xbfe253fa7a040aca, 0x0,
    0xbfe9487f92043218, 0x0,
    0xbfe0101e47a746da, 0x0,
    0x3fbcaac805762e62, 0x0,
    0x3fdc8458c910ea72, 0x0,
    0x3fe6c6fa6f6c3da4, 0x0,
    0x3fdf26aefefe3b4b, 0x0,
    0x3fa4a4dd4e990add, 0x0,
    0xbfe19ee3618aab8a, 0x0,
    0xbfe7ee5d1eadd52b, 0x0,
    0xbfdf00f7d37bd562, 0x0,
    0xbfb278fc236d1ac9, 0x0,
    0x3fe1457cd9d09256, 0x0,
    0x3fe62968e5760bfa, 0x0,
    0x3fe107959045ccfb, 0x0,
    0x3fa02a96aaab0f0a, 0x0,
    0xbfe17f8112f657fb, 0x0,
    0xbfe527296d44689a, 0x0,
    0xbfe004bf6615169c, 0x0,
    0x3f87e5b49cab5ed2, 0x0,
    0x3fde12ec7020d7a4, 0x0,
    0x3fe61b423dee0559, 0x0,
    0x3fde0cb25ee54a3b, 0x0,
    0xbfa87a4ac0c5011e, 0x0,
    0xbfe12621934413fe, 0x0,
    0xbfe8c9163e823183, 0x0,
    0xbfddf8233410754c, 0x0,
    0xbf9ce8e8a646534e, 0x0,
    0x3fe0ad610bb54f4d, 0x0,
    0x3fe661407bd56ba8, 0x0,
    0x3fdda6110963edaa, 0x0,
    0x3fb9ba96af79ff5b, 0x0,
    0xbfe035491b71af31, 0x0,
    0xbfe633403925b2c6, 0x0,
    0xbfe0c568ace371cf, 0x0,
    0xbf7f2d783dc61c32, 0x0,
    0x3fdc3e4db4ddd0a9, 0x0,
    0x3fe58a899b43f26b, 0x0,
    0x3fdbe642696b0c54, 0x0,
    0xbfb74d949cb02848, 0x0,
    0xbfddd2d772152f5e, 0x0,
    0xbfe5cc8eeb402f35, 0x0,
    0xbfdbad9c9f28b5a8, 0x0,
    0xbf5b387bdf6365aa, 0x0,
    0x3fdce9d7d7355d7f, 0x0,
    0x3fe404e309f8f578, 0x0,
    0x3fe14c99dfcae1ad, 0x0,
    0xbf9ffcb23a98e7df, 0x0,
    0xbfdb30e06ea578fb, 0x0,
    0xbfe68e4228f23d03, 0x0,
    0xbfe03af53c5d482b, 0x0,
    0x3fb2a8573d791485, 0x0,
    0x3fde533ac2b105e8, 0x0,
    0x3fe6641c49ae4bc0, 0x0,
    0x3fde14b0caf45682, 0x0,
    0xbf973960e830c6e5, 0x0,
    0xbfdff4e6f6e2b492, 0x0,
    0xbfe6ff4b5b683dd2, 0x0,
    0xbfe1ed58ced8aa0e, 0x0,
    0xbf9be3005bd6103a, 0x0,
    0x3fe1dcb1c96ff1bf, 0x0,
    0x3fe44296d4faffd7, 0x0,
    0x3fdf7ac75ed10aa9, 0x0,
    0x3fa1528acdf1b922, 0x0,
    0xbfdf0562ed526cf7, 0x0,
    0xbfe6aecede594dca, 0x0,
    0xbfde6901b232847b, 0x0,
    0x3f834828a32ecd5c, 0x0,
    0x3fdefa57cea1b4a7, 0x0,
    0x3fe55cd759273b8e, 0x0,
    0x3fdc25b08ef4b504, 0x0,
    0x3fbd17ace4f1f6de, 0x0,
    0xbfe0d5acddc9f74b, 0x0,
    0xbfe6eb359c2a9091, 0x0,
    0xbfdac168e6ee8eba, 0x0,
    0x3fa1498beaaa4b23, 0x0,
    0x3fdec32714482855, 0x0,
    0x3fe47c1e7154a209, 0x0,
    0x3fdbd833aeca1af0, 0x0,
    0x3fb0b80c168731b8, 0x0,
    0xbfe08ba14ccc1ab8, 0x0,
    0xbfe53315288bd847, 0x0,
    0xbfe07132948db399, 0x0,
    0x3f8e675d922888dd, 0x0,
    0x3fe2899ea5970cad, 0x0,
    0x3fe7c47211593e3f, 0x0,
    0x3fde5a1761f848ac, 0x0,
    0xbf72241b4991bc83, 0x0,
    0xbfe138affccb5fcf, 0x0,
    0xbfe51f6712b29e8f, 0x0,
    0xbfe0a1d60ad3a8b2, 0x0,
    0xbfb31b4fe71a6cf4, 0x0,
    0x3fda6264cfd87a52, 0x0,
    0x3fe551487af39636, 0x0,
    0x3fda38ff488d4c40, 0x0,
    0xbfa63d177d7a501d, 0x0,
    0xbfdff685cbe0cad4, 0x0,
    0xbfeac65e53d0e294, 0x0,
    0xbfdf1650d2205555, 0x0,
    0x3fb9dac6187a5f93, 0x0,
    0x3fe10149b748e53b, 0x0,
    0x3fe697ef9e4f9af0, 0x0,
    0x3fdc8e8bf6fd4d5b, 0x0,
    0xbf9f8d12d272389e, 0x0,
    0xbfdc025ae36e405e, 0x0,
    0xbfe729f77839257f, 0x0,
    0xbfdfb499d840e7cf, 0x0,
    0xbfaef98d45e24d8f, 0x0,
    0x3fdf030e3a306851, 0x0,
    0x3fe685389a003bc1, 0x0,
    0x3fd9a311ff3d5c26, 0x0,
    0x3f9aed3dd98e401c, 0x0,
    0xbfdb1a1c6a9ca5ec, 0x0,
    0xbfe6edb6476d2115, 0x0,
    0xbfe1b570cca6f070, 0x0,
    0x3fa458923c251393, 0x0,
    0x3fe0a5d13ef57d3a, 0x0,
    0x3fe646675aac75d7, 0x0,
    0x3fe0828d247298c3, 0x0,
    0x3f8a5c0aa6f7b1f3, 0x0,
    0xbfdfab3a72ba8fc0, 0x0,
    0xbfe668f6a3af4037, 0x0,
    0xbfe09ca5d455124d, 0x0,
    0xbfa1887e43f661fe, 0x0,
    0x3fdc1c8d0a6a0e90, 0x0,
    0x3fe6ff75e54d4e24, 0x0,
    0x3fe20a188712e68f, 0x0,
    0x3fa8f6477b2fc8fb, 0x0,
    0xbfe08dd81c26e242, 0x0,
    0xbfe8b8246b870f86, 0x0,
    0xbfe11c254a8e20ea, 0x0,
    0xbf925deb311e4316, 0x0,
    0x3fe0c6bfb21a060e, 0x0,
    0x3fe7506e7d30bd30, 0x0,
    0x3fe0fac03da2d84c, 0x0,
    0x3f94966f9aa02243, 0x0,
    0xbfdb68b134db7cbc, 0x0,
    0xbfe5766aaac49d49, 0x0,
    0xbfe15b249cdadf03, 0x0,
    0xbf9d3c084344b00a, 0x0,
    0x3fe29d035749a3cb, 0x0,
    0x3fe86f816f4d4e9e, 0x0,
    0x3fe082c21f8c47e3, 0x0,
    0x3f7f6e9f0816926f, 0x0,
    0xbfe215b99f75ef70, 0x0,
    0xbfe5082c99660ff9, 0x0,
    0xbfe13800a9dd09b8, 0x0,
    0xbfa195dcfd20a325, 0x0,
    0x3fe0982179c8c340, 0x0,
    0x3fe58358ab060119, 0x0,
    0x3fe0ef8cd4f05bf1, 0x0,
    0xbfae3d11a48e177c, 0x0,
    0xbfe0d4f0f8d57f26, 0x0,
    0xbfe45f06f97b8198, 0x0,
    0xbfe1947136a54cbe, 0x0,
    0xbf8f920ca6122f70, 0x0,
    0x3fdedef121dcbb48, 0x0,
    0x3fe7a5576a03bd33, 0x0,
    0x3fda28099d1deae7, 0x0,
    0xbfa39eadb6e9cb9c, 0x0,
    0xbfdcb7c12ac2716c, 0x0,
    0xbfe5c9aec32299f6, 0x0,
    0xbfe0c9d3874306ee, 0x0,
    0x3f9a687f5bf5bfc4, 0x0,
    0x3fdd727bd375e762, 0x0,
    0x3fe964e4476da89b, 0x0,
    0x3fde65cd60d0451c, 0x0,
    0xbf9c2eeafc106a27, 0x0,
    0xbfe27dd6a5cf1d04, 0x0,
    0xbfe4a3be9b9b45ba, 0x0,
    0xbfdd6c284ee092f8, 0x0,
    0xbfaa9bd688e9dc2d, 0x0,
    0x3fdd0c140fedace7, 0x0,
    0x3fe5c601c1e69d6b, 0x0,
    0x3fe3a42d77924889, 0x0,
    0x3fa881807e7763fe, 0x0,
    0xbfd8a4b273491739, 0x0,
    0xbfe9ecb21c14f138, 0x0,
    0xbfdcada59b6e0f2f, 0x0,
    0xbf94887519a5975c, 0x0,
    0x3fdf61c2249a8d37, 0x0,
    0x3fe958480f198663, 0x0,
    0x3fdc19861343ee24, 0x0,
    0x3fbdb7934bf023bb, 0x0,
    0xbfe087ec8e50ec10, 0x0,
    0xbfe79655fa20c9ce, 0x0,
    0xbfe001daf576ef51, 0x0,
    0x3fb615ef7ec1f45b, 0x0,
    0x3fdbd786c3555067, 0x0,
    0x3fe530a443e419c9, 0x0,
    0x3fde495cdcd10e6c, 0x0,
    0x3f7f9acdd07e7bfc, 0x0,
    0xbfddda3a4411ae67, 0x0,
    0xbfe6a887787155bb, 0x0,
    0xbfdbdc3bec0adbf5, 0x0,
    0xbf9c8d6624d3b6e5, 0x0,
    0x3fe0ac3528d39e1b, 0x0,
    0x3fe6262ff46bc922, 0x0,
    0x3fe058729cf9201f, 0x0,
    0x3fb4b0eea25a1156, 0x0,
    0xbfe12faa3348364c, 0x0,
    0xbfe5f40605c7e9bf, 0x0,
    0xbfe2985cc854e6c6, 0x0,
    0xbfb1312ee59ca328, 0x0,
    0x3fdc8635040b667a, 0x0,
    0x3fe4de6ddd4d2cb0, 0x0,
    0x3fdfa6bc16484a4e, 0x0,
    0xbf974eec3530ab83, 0x0,
    0xbfe0e730877101b0, 0x0,
    0xbfe7c5b2965639d2, 0x0,
    0xbfe21de164c2b489, 0x0,
    0xbfa7248a1851a671, 0x0,
    0x3fd860b98d8cc6ad, 0x0,
    0x3fe76252248cf617, 0x0,
    0x3fdb2082bdd27776, 0x0,
    0xbfac021e48b72e6b, 0x0,
    0xbfe3a20f3f881a0c, 0x0,
    0xbfe79282d7a69bda, 0x0,
    0xbfd9415cde569bfe, 0x0,
    0xbf80de4fed8c217d, 0x0,
    0x3fe11ac99390d234, 0x0,
    0x3fe534fbc0e8eab1, 0x0,
    0x3fe1013b33cc8c71, 0x0,
    0xbf8991878ffbd395, 0x0,
    0xbfe0a66226a200b7, 0x0,
    0xbfe5a23ec470ac55, 0x0,
    0xbfdc3a35058fd8c2, 0x0,
    0x3f54ba8aab08bc71, 0x0,
    0x3fdd2c0481440a26, 0x0,
    0x3fe4703c96f1ba63, 0x0,
    0x3fdd756a2a4e73f6, 0x0,
    0x3faed9cdb840ea73, 0x0,
    0xbfe0ebfa0f3fbe01, 0x0,
    0xbfe6f996f7f3d6f5, 0x0,
    0xbfd91f0d7185d3a4, 0x0,
    0xbf8d15c172bf9925, 0x0,
    0x3fe06bc1cd6a4ba0, 0x0,
    0x3fe6c77a2290b9a5, 0x0,
    0x3fe04b533f101c15, 0x0,
    0x3faf7b29237a3b94, 0x0,
    0xbfdc27487d09dfe9, 0x0,
    0xbfe4a569e76f0072, 0x0,
    0xbfdb7622565415e6, 0x0,
    0x3f62435f9ddbb100, 0x0,
    0x3fdc0fd996bf7b26, 0x0,
    0x3fe5967d015c1aff, 0x0,
    0x3fdff82f785297bb, 0x0,
    0x3f8692e5746551c1, 0x0,
    0xbfe05533d21d0743, 0x0,
    0xbfe64c425349ef74, 0x0,
    0xbfda2e8f0044caaf, 0x0,
    0xbfc36824aee7677a, 0x0,
    0x3fe19f9e08098065, 0x0,
    0x3fe505bba81cea5b, 0x0,
    0x3fe0bfd981cf219e, 0x0,
    0xbfa06aa2029c131b, 0x0,
    0xbfdc74f6868d2c1d, 0x0,
    0xbfe7248096030dbe, 0x0,
    0xbfdda74a27691f9c, 0x0,
    0xbfa9e2e738762088, 0x0,
    0x3fe21dded69035b1, 0x0,
    0x3fe7eb29ff809334, 0x0,
    0x3fdd6638a54c8612, 0x0,
    0xbf946921397eaef1, 0x0,
    0xbfe0f9a968e1f401, 0x0,
    0xbfe6870994adb762, 0x0,
    0xbfde59b7054dea64, 0x0,
    0xbf6e5f896a51753e, 0x0,
    0x3fd96b502de08a95, 0x0,
    0x3fe68b2f11506cb8, 0x0,
    0x3fe166d7d93b4074, 0x0,
    0x3fb4afec58719301, 0x0,
    0xbfe18b9316f359f8, 0x0,
    0xbfe70f26738637ff, 0x0,
    0xbfe107cd13e9a57a, 0x0,
    0xbf8fff55df383c21, 0x0,
    0x3fe02bd7fcc2a4e7, 0x0,
    0x3fe63b97d8bca555, 0x0,
    0x3fe0d30a263bc15a, 0x0,
    0xbf94f7a27e87d9f6, 0x0,
    0xbfdef97594e432ea, 0x0,
    0xbfe59a45f05751e8, 0x0,
    0xbfd7eb85dfba4c5a, 0x0,
    0xbf951a726a9b80f7, 0x0,
    0x3fe01a81b018693d, 0x0,
    0x3fe74954c4543056, 0x0,
    0x3fdb27684378998b, 0x0,
    0xbfa9f49121eba4a4, 0x0,
    0xbfde05a3a11ec5c3, 0x0,
    0xbfe6ef74a839ad22, 0x0,
    0xbfdc78932c891d69, 0x0,
    0x3f8dbf7a0ab9ba85, 0x0,
    0x3fe06f685c9669a0, 0x0,
    0x3fe618563a0f2380, 0x0,
    0x3fe07a61e8f02ab6, 0x0,
    0xbfbe9fc34ddda9bf, 0x0,
    0xbfdf404469920165, 0x0,
    0xbfe5ad259b5924e7, 0x0,
    0xbfe48e93cd8634cf, 0x0,
    0xbfb17c428b197c49, 0x0,
    0x3fdd77e511827ffe, 0x0,
    0x3fe8b79150605980, 0x0,
    0x3fde9509ebeff178, 0x0,
    0x3f9012288f1a7e9f, 0x0,
    0xbfdcdea21486adfe, 0x0,
    0xbfe68d396ea27fc0, 0x0,
    0xbfe1a2dcbe39ed89, 0x0,
    0xbfae7be2c26e77e6, 0x0,
    0x3fdf3845c757d6b2, 0x0,
    0x3fe6cda28e83aab6, 0x0,
    0x3fdca6e095c2c243, 0x0,
    0x3fa659de44123e3c, 0x0,
    0xbfe10c366420625b, 0x0,
    0xbfe6447eeb0991cf, 0x0,
    0xbfde808a52a4746c, 0x0,
    0xbfacdf7255edc9ca, 0x0,
    0x3fdb6e6df5f5f37c, 0x0,
    0x3fe543607d677059, 0x0,
    0x3fe0978741e31f3a, 0x0,
    0xbfac63d3530ee711, 0x0,
    0xbfdddc01b5904b8f, 0x0,
    0xbfe8fc495680b3da, 0x0,
    0xbfdde784c6057db6, 0x0,
    0xbfadab6b4435504f, 0x0,
    0x3fdb9c727a540689, 0x0,
    0x3fe6d5e1c020be55, 0x0,
    0x3fdee0230ff36c39, 0x0,
    0xbfb2b07e3c3b71c3, 0x0,
    0xbfdf87ef6fbb5c50, 0x0,
    0xbfe61e59266ab151, 0x0,
    0xbfde8b6bb36d208a, 0x0,
    0xbf95d2732944403b, 0x0,
    0x3fe2c3f45192f57f, 0x0,
    0x3fe534a5f0ea8a2d, 0x0,
    0x3fe09cf76b16e444, 0x0,
    0x3fa13e1dfe1ec741, 0x0,
    0xbfe356b907432511, 0x0,
    0xbfe4156af4891372, 0x0,
    0xbfe0e0f4bd6c3456, 0x0,
    0xbfad853af131f3d9, 0x0,
    0x3fd7b610088c9de8, 0x0,
    0x3fe3425b07c627ce, 0x0,
    0x3fe21dafa400d199, 0x0,
    0x3fa4b5007fcdb49c, 0x0,
    0xbfdc29805f10ee88, 0x0,
    0xbfe50dfa06f5b53b, 0x0,
    0xbfdd19797cfbc1ab, 0x0,
    0x3f9778a3f7f66a97, 0x0,
    0x3fdf41c01974e9f5, 0x0,
    0x3fe7f75a029d00d0, 0x0,
    0x3fd9ae538f98da5e, 0x0,
    0xbfb1a70df12f6c57, 0x0,
    0xbfe05fc51990985d, 0x0,
    0xbfe5b3bd0c5d2830, 0x0,
    0xbfda76df153a973c, 0x0,
    0xbfa68c95572eeb49, 0x0,
    0x3fd956c8b73cc3b4, 0x0,
    0x3fe5912d2791bd9c, 0x0,
    0x3fdfa3e0a0ecef4e, 0x0,
    0xbfb9178b928e4dbb, 0x0,
    0xbfd4c87c5e46b62b, 0x0,
    0xbfe71839b46fadf5, 0x0,
    0xbfe112891b70c6de, 0x0,
    0x3f7819fd707120ca, 0x0,
    0x3fdee28001590c1c, 0x0,
    0x3fe570edf279b2d7, 0x0,
    0x3fdfb124140f4e03, 0x0,
    0x3faa9a87f88ab4ed, 0x0,
    0xbfdbbe1937b557bf, 0x0,
    0xbfe53b229f7e984c, 0x0,
    0xbfdf4c44627e6b39, 0x0,
    0x3f9749f6469366d3, 0x0,
    0x3fdd0ca3e0cf6da0, 0x0,
    0x3fe6dbf1b37a70b0, 0x0,
    0x3fdef6ff057461b9, 0x0,
    0x3f6e4becdc9a6887, 0x0,
    0xbfe12445b64d5a00, 0x0,
    0xbfe19b8c18691df9, 0x0,
    0xbfdaf6237f36a6dd, 0x0,
    0xbfbea0ea846cb620, 0x0,
    0x3fe0c70784485ebf, 0x0,
    0x3fe55727d28d2365, 0x0,
    0x3fe39c1d5eac4696, 0x0,
    0xbfa00c0d44eb0544, 0x0,
    0xbfe05ed744c9effa, 0x0,
    0xbfe63b647d520ffa, 0x0,
    0xbfe0b1875048e324, 0x0,
    0xbf9de016baf53141, 0x0,
    0x3fde55b6b7ac9cbb, 0x0,
    0x3fe56c6bc1c4c1cb, 0x0,
    0x3fdcbc5caf08f45e, 0x0,
    0xbfa0d9e23ceb428b, 0x0,
    0xbfdba04aee1c25ea, 0x0,
    0xbfe7acaa00673593, 0x0,
    0xbfdfc8610346be3a, 0x0,
    0xbf7b949e3540e03e, 0x0,
    0x3fe01f1b984e2988, 0x0,
    0x3fe942365af3cc92, 0x0,
    0x3fe1d1486e835064, 0x0,
    0x3fa237938d46130b, 0x0,
    0xbfda4e99961398c6, 0x0,
    0xbfe7344551713cd3, 0x0,
    0xbfe0bad21fd300bd, 0x0,
    0xbf86f1fe8e03470e, 0x0,
    0x3fe07541c7d057dd, 0x0,
    0x3fe809b570c54f49, 0x0,
    0x3fe011dc6f193ba0, 0x0,
    0xbf988fa12d6877fd, 0x0,
    0xbfe08890e8631c44, 0x0,
    0xbfe7278ea9519502, 0x0,
    0xbfdfb588af548186, 0x0,
    0x3fa564179c8b52b9, 0x0,
    0x3fdf23928a6ff4a8, 0x0,
    0x3fe3d7cb64fd1665, 0x0,
    0x3fdce9a3bb073995, 0x0,
    0x3f8d62b366965796, 0x0,
    0xbfdd11a390714983, 0x0,
    0xbfe673f3d2fdf422, 0x0,
    0xbfdddeea08d72eee, 0x0,
    0x3f49acc5af0be281, 0x0,
    0x3fdfc8e2363e7eec, 0x0,
    0x3fead6f8457184cc, 0x0,
    0x3fe1e9f51b452738, 0x0,
    0xbf8b6603b3264700, 0x0,
    0xbfde15cddd9b9a67, 0x0,
    0xbfea0e49a7d815fc, 0x0,
    0xbfdd84289c6db2a3, 0x0,
    0xbfb3e3f27f76186e, 0x0,
    0x3fdfb512024acf78, 0x0,
    0x3fe5ee2da6fa99d0, 0x0,
    0x3fe24a19f1b6bbb0, 0x0,
    0x3f86175191580529, 0x0,
    0xbfe08069bd143238, 0x0,
    0xbfe7d19341a9d717, 0x0,
    0xbfdf4519d9690083, 0x0,
    0x3fbbc42d2f70659c, 0x0,
    0x3fde19c5c691d8b3, 0x0,
    0x3fe8cbb3f8cef38c, 0x0,
    0x3fe1fff573b01740, 0x0,
    0xbfa9a7dc9e432efb, 0x0,
    0xbfdd24573ece45dc, 0x0,
    0xbfe580dffb249dbc, 0x0,
    0xbfe1eccb53756c97, 0x0,
    0xbfae17384a250e93, 0x0,
    0x3fdf7a6c83fc421c, 0x0,
    0x3fe81917a029e560, 0x0,
    0x3fe1809037cbd174, 0x0,
    0x3f70fd9aeba9bd40, 0x0,
    0xbfdfe2b2e2c5bb25, 0x0,
    0xbfe6bf0f1196f26d, 0x0,
    0xbfdb37b53d813ba4, 0x0,
    0x3fa9276da7ff580f, 0x0,
    0x3fddf912192bf310, 0x0,
    0x3fe5d319aa1a7e87, 0x0,
    0x3fe279018dfcb827, 0x0,
    0x3fa5d1429868969e, 0x0,
    0xbfdc01727c2016a0, 0x0,
    0xbfe74782ae033850, 0x0,
    0xbfdc361d8cfca9d9, 0x0,
    0xbf9313f2b6a37877, 0x0,
    0x3fdad13cf20cd39e, 0x0,
    0x3fe707ea5bdb50f5, 0x0,
    0x3fdfc0f00cf9d9e8, 0x0,
    0xbfae496c535e4361, 0x0,
    0xbfde4f95d086bf11, 0x0,
    0xbfe7923d7f9ff89f, 0x0,
    0xbfdcc51f8de52eed, 0x0,
    0x3f8643ef490a829c, 0x0,
    0x3fdec25792c6f30e, 0x0,
    0x3fe73f97e21efdd7, 0x0,
    0x3fe069307fa29c7a, 0x0,
    0x3f6e7c50e968859f, 0x0,
    0xbfdf993933ad8972, 0x0,
    0xbfe69bb7029539d9, 0x0,
    0xbfd7b201720a61e9, 0x0,
    0xbfa30d8fe1e0c90f, 0x0,
    0x3fe03540faf72c45, 0x0,
    0x3fe962a3f648dbe7, 0x0,
    0x3fe0b4aa277c69c3, 0x0,
    0x3f8b1db5916b29aa, 0x0,
    0xbfe20f03d7b07f23, 0x0,
    0xbfe50a6afd8eab65, 0x0,
    0xbfe1fd6ff93bba92, 0x0,
    0xbfab6354295663c2, 0x0,
    0x3fde48b47b081208, 0x0,
    0x3fe7347b896e71ed, 0x0,
    0x3fdca3778694c579, 0x0,
    0xbfa269db9969a3ca, 0x0,
    0xbfdfd5cad13dcd82, 0x0,
    0xbfe67131f4c2b774, 0x0,
    0xbfe201b20e7e07fc, 0x0,
    0xbfb320c918a38614, 0x0,
    0x3fde713a0749ae2e, 0x0,
    0x3fe4f865e19feb38, 0x0,
    0x3fda83ea48760c90, 0x0,
    0xbf9d045046e97dfe, 0x0,
    0xbfe135ac3d1572d1, 0x0,
    0xbfe33c5d71bcf616, 0x0,
    0xbfe104d850048032, 0x0,
    0xbfa17258264e101a, 0x0,
    0x3fdb380a374ee4d8, 0x0,
    0x3fe36f94ee31d652, 0x0,
    0x3fe075433b4e3274, 0x0,
    0x3f99352e18067af8, 0x0,
    0xbfdbb4197a064080, 0x0,
    0xbfe7103766668790, 0x0,
    0xbfdecce873f0463a, 0x0,
    0xbfa7420a28c9b750, 0x0,
    0x3fe02b6e24ef0fc3, 0x0,
    0x3fe3960bdcd5c0b8, 0x0,
    0x3fde1d106efaa6a4, 0x0,
    0x3fbc60da859222a6, 0x0,
    0xbfe0eb4d44c92549, 0x0,
    0xbfe827014fd5cd33, 0x0,
    0xbfe102e4b1c53224, 0x0,
    0x3f9b20be502bd398, 0x0,
    0x3fdf4e0ef6afa93d, 0x0,
    0x3fe39e15dd6c574f, 0x0,
    0x3fdbd4341ac598b6, 0x0,
    0xbfa50cdeb095fbd4, 0x0,
    0xbfe1a9d5d2dca864, 0x0,
    0xbfe5f3c19adf0bd9, 0x0,
    0xbfe1f300ac8c22c2, 0x0,
    0x3fb00afce18991f4, 0x0,
    0x3fdea11f23d2af18, 0x0,
    0x3fe6fb6f5e8b5291, 0x0,
    0x3fde5e303b5c9d98, 0x0,
    0xbfb3188151edd939, 0x0,
    0xbfdd24650471bb56, 0x0,
    0xbfe76de86762d72f, 0x0,
    0xbfe027b60cbbc6ab, 0x0,
    0xbf9e13f2ed5cd276, 0x0,
    0x3fdfe4dbad1a3882, 0x0,
    0x3fe77062af04b387, 0x0,
    0x3fdfaab5bddb7150, 0x0,
    0xbfb1119fe777c497, 0x0,
    0xbfda68ae1184ac81, 0x0,
    0xbfe51a330d7d4fee, 0x0,
    0xbfdad21f79719e1d, 0x0,
    0x3fa38c7097492e9e, 0x0,
    0x3fdbdda07e09550c, 0x0,
    0x3fe96fd72b40e514, 0x0,
    0x3fdd69f3389e3bf5, 0x0,
    0x3f70bff7d6a30685, 0x0,
    0xbfdfb48752cc30d7, 0x0,
    0xbfe6dffe92b5f075, 0x0,
    0xbfdcf4e150e7ef89, 0x0,
    0x3fabd71e3ce5cd1b, 0x0,
    0x3fdfc857137b4c59, 0x0,
    0x3fe7239c2795d787, 0x0,
    0x3fe04887199e2bf0, 0x0,
    0x3fa05ff9c5d97cf0, 0x0,
    0xbfe0a1bd236b7fb8, 0x0,
    0xbfe5c470f2ef8c86, 0x0,
    0xbfdbb5781ac37532, 0x0,
    0x3f75378216021ab8, 0x0,
    0x3fe20ddb9ac56adb, 0x0,
    0x3fe3e1021770916c, 0x0,
    0x3fdeedf4b4942509, 0x0,
    0xbfa5691c78f187b9, 0x0,
    0xbfde1c94b38ce996, 0x0,
    0xbfe7b944b1e82332, 0x0,
    0xbfe08f118c61fa3f, 0x0,
    0x3fa5eb8bf8f65535, 0x0,
    0x3fdbd5d5a15ed94f, 0x0,
    0x3fea6c887fb8f441, 0x0,
    0x3fdc5e0544db3292, 0x0,
    0xbfa73eca0aab3b5b, 0x0,
    0xbfdfebc052fe4caf, 0x0,
    0xbfe68ee58fb34677, 0x0,
    0xbfdbfc1a24231582, 0x0,
    0x3fa2b276c9177303, 0x0,
    0x3fe256495382c450, 0x0,
    0x3fe69238c8f0d7c0, 0x0,
    0x3fe0848fca4c6821, 0x0,
    0x3faca7ca915ecf63, 0x0,
    0xbfd7bbe8662cf641, 0x0,
    0xbfe3ebdc563b7847, 0x0,
    0xbfe094948c9b4f76, 0x0,
    0xbfb76722e3ef9a54, 0x0,
    0x3fdf0ab4c7ce6f09, 0x0,
    0x3fe9813ba3fc78a8, 0x0,
    0x3fdff97139055068, 0x0,
    0xbf8b1e22dc7ee198, 0x0,
    0xbfdf79a9279ae55c, 0x0,
    0xbfe797077bb55dbf, 0x0,
    0xbfe1daa0d72d47e7, 0x0,
    0xbf68d12fab341be2, 0x0,
    0x3fdef4d21dd1eff4, 0x0,
    0x3fe602433f164512, 0x0,
    0x3fdf20cb4c3f93a6, 0x0,
    0xbfb3824d57c60210, 0x0,
    0xbfdfd8e7730f6c20, 0x0,
    0xbfe568e2bdf9b448, 0x0,
    0xbfe499381d899d6a, 0x0,
    0xbf8367d77972b784, 0x0,
    0x3fdf74b21570f98d, 0x0,
    0x3fe7f087276c5e36, 0x0,
    0x3fe09e84556919f7, 0x0,
    0xbf890f7ad58698e5, 0x0,
    0xbfdf2299b94f8ecd, 0x0,
    0xbfe5338fc0bfd114, 0x0,
    0xbfe15dc602fe1c6a, 0x0,
    0xbfa898ad25cf556a, 0x0,
    0x3fdab1982dededc5, 0x0,
    0x3fe624ae5b782fc1, 0x0,
    0x3fe1769aed884557, 0x0,
    0x3faa97d19e30e60a, 0x0,
    0xbfddfb87a216ef9a, 0x0,
    0xbfe5b835c1311bf7, 0x0,
    0xbfe03f12f6986c0e, 0x0,
    0x3f9b823cefd6bb39, 0x0,
    0x3fdd18a71f41e0c8, 0x0,
    0x3fe7bb9ebcc7953a, 0x0,
    0x3fe1b8cc9027d1e2, 0x0,
    0x3faf94537d549070, 0x0,
    0xbfd9c710dcd0fe49, 0x0,
    0xbfe6cb27d9445d40, 0x0,
    0xbfe034e400410190, 0x0,
    0x3f74987a782fad3b, 0x0,
    0x3fdd0be3051b3bca, 0x0,
    0x3fe7b66e5164c171, 0x0,
    0x3fe02e6b87ae6cec, 0x0,
    0x3f8a2da79bcfdc03, 0x0,
    0xbfdefddf289de836, 0x0,
    0xbfe4df6cc18f80a9, 0x0,
    0xbfde0decd59adc8c, 0x0,
    0xbfa3c0fead3e4e10, 0x0,
    0x3fdaf2ccb8637eb0, 0x0,
    0x3fe5eb2bd4c2a9ff, 0x0,
    0x3fe03671147e894a, 0x0,
    0xbf96b9aa106412da, 0x0,
    0xbfda70181b2edc41, 0x0,
    0xbfe4de908e2413f6, 0x0,
    0xbfdc17fe9cf30ab7, 0x0,
    0xbf47e87588ec6c33, 0x0,
    0x3fe14ae8a2abb357, 0x0,
    0x3fe720c04e59589a, 0x0,
    0x3fe0729320c14ab3, 0x0,
    0x3fa3740ae7485959, 0x0,
    0xbfda948d9f3a0234, 0x0,
    0xbfe729cc2e1823e6, 0x0,
    0xbfde69c24d4450a7, 0x0,
    0xbf8befff9af0f384, 0x0,
    0x3fdd8a8e650e4803, 0x0,
    0x3fe6684194b26fec, 0x0,
    0x3fde951019b92f1e, 0x0,
    0xbf83e944c9282543, 0x0,
    0xbfddc086daa4a984, 0x0,
    0xbfe7490f5f919833, 0x0,
    0xbfe0767560b74c23, 0x0,
    0xbfa5ebe22404fbcb, 0x0,
    0x3fe1d82660a8c91f, 0x0,
    0x3fe79b4c64b4083a, 0x0,
    0x3fdc4c016ffe6da2, 0x0,
    0x3fae2aa42b6168aa, 0x0,
    0xbfe00438b9fa83b1, 0x0,
    0xbfe64a420afa1dfb, 0x0,
    0xbfe0b20759ed6e00, 0x0,
    0x3f99f5fc62830a7d, 0x0,
    0x3fe0eded721f7101, 0x0,
    0x3fe5461da6397860, 0x0,
    0x3fdf6580a8289e50, 0x0,
    0xbfc12f1d740f8ae4, 0x0,
    0xbfe2b0ef5b08e237, 0x0,
    0xbfe56678de7fd086, 0x0,
    0xbfe301538dd6d03d, 0x0,
    0xbf98e9889af24148, 0x0,
    0x3fdf0f958495e832, 0x0,
    0x3fe4c4fdaa7df3d1, 0x0,
    0x3fd89e8d119b6b5f, 0x0,
    0xbf9974ca8bf4ea66, 0x0,
    0xbfe006a6a5329ce7, 0x0,
    0xbfe81f1fe3bdef5d, 0x0,
    0xbfde9d4c2dc4427c, 0x0,
    0x3fa61b2bf38d6d73, 0x0,
    0x3fddf0421a34605f, 0x0,
    0x3fe76950bdd3f361, 0x0,
    0x3fe29c4650bf2d01, 0x0,
    0xbf998c84f35fd6d3, 0x0,
    0xbfde48decaa3436c, 0x0,
    0xbfe52a2395f86a4e, 0x0,
    0xbfdde14b6de01fee, 0x0,
    0x3fa0173bb42ea7f5, 0x0,
    0x3fdd0624ff4ba4b6, 0x0,
    0x3fe78e99a7ad5046, 0x0,
    0x3fdce20118ebbfab, 0x0,
    0xbf849b85cd7f3ffe, 0x0,
    0xbfdf83810018fdc9, 0x0,
    0xbfe3b0cf29f601c6, 0x0,
    0xbfddcd08903770c6, 0x0,
    0xbfb01786ed34403a, 0x0,
    0x3fde2c329333da21, 0x0,
    0x3fe699bc7a59c984, 0x0,
    0x3fe06bf59928ab83, 0x0,
    0xbf9c4127737fc2b3, 0x0,
    0xbfdeb580da3a527a, 0x0,
    0xbfe5cc29bf772a7e, 0x0,
    0xbfe2d1ed26b88160, 0x0,
    0xbf9bd18bc62dd88d, 0x0,
    0x3fe17a81ed63f622, 0x0,
    0x3fe895d106a6304f, 0x0,
    0x3fdb2d10beab6e30, 0x0,
    0xbf54a54726b038d5, 0x0,
    0xbfe13942bab76d04, 0x0,
    0xbfe6faab23c7ae52, 0x0,
    0xbfe070bf4c48208c, 0x0,
    0x3fab787be3b0d4c8, 0x0,
    0x3fe1f2c3ff098c6d, 0x0,
    0x3fe61a9c41d467a2, 0x0,
    0x3fd885503b9ebf90, 0x0,
    0x3f9dfb6d5331ad51, 0x0,
    0xbfddc7bffeb758fd, 0x0,
    0xbfe44a8714b6ced8, 0x0,
    0xbfdd4d3b63d83aec, 0x0,
    0x3fb8dc8404102059, 0x0,
    0x3fe1c43246551c86, 0x0,
    0x3fe3808d3f0490d8, 0x0,
    0x3fe00fc6a66195f3, 0x0,
    0x3f869dc9bbff501d, 0x0,
    0xbfe048c41b156a06, 0x0,
    0xbfe77f12a1b16a30, 0x0,
    0xbfde1ac6d95c3958, 0x0,
    0x3fa7f892898e26d5, 0x0,
    0x3fe308d350d5950e, 0x0,
    0x3fe6f49a6caa7397, 0x0,
    0x3fdec16e5eba52af, 0x0,
    0x3f6d8ef0fef10705, 0x0,
    0xbfe1c600fc93fc38, 0x0,
    0xbfe6cd93c2f0da51, 0x0,
    0xbfe13270f460a3af, 0x0,
    0xbfa69abe76a40cfc, 0x0,
    0x3fe1a9e32bb4baf0, 0x0,
    0x3fe4b8e93f805168, 0x0,
    0x3fe16bc7edf626ae, 0x0,
    0xbfae62a954f8e144, 0x0,
    0xbfdef7c50dcf8077, 0x0,
    0xbfe579243720d6e4, 0x0,
    0xbfdfe3250756e12f, 0x0,
    0x3f8ad8e6d7f6b97b, 0x0,
    0x3fda8f1fc03800e2, 0x0,
    0x3fe59cd0d43ee413, 0x0,
    0x3fe06ad15d00a324, 0x0,
    0x3fac8c624336cb9c, 0x0,
    0xbfdafa5e13ae5b9d, 0x0,
    0xbfe4cb9ec767c6ec, 0x0,
    0xbfe04772b6f74686, 0x0,
    0x3f67f33fae417857, 0x0,
    0x3fdd7de66130af26, 0x0,
    0x3fe36cc63c48c575, 0x0,
    0x3fdf3c344aa4e8d0, 0x0,
    0x3f8ff8114ccf8db9, 0x0,
    0xbfe0a7a140b37ab7, 0x0,
    0xbfe4c078c576e87e, 0x0,
    0xbfdfe6db866d41c6, 0x0,
    0xbfb6043466c4a843, 0x0,
    0x3fde7b02abf5d07f, 0x0,
    0x3fe6e165d0c746f4, 0x0,
    0x3fe00a35c4605778, 0x0,
    0x3fa93f64a4b5f1b4, 0x0,
    0xbfe034ef9aa424c1, 0x0,
    0xbfe7e983ae4923c2, 0x0,
    0xbfe01ff1de8e8da0, 0x0,
    0xbf84c771d7a86109, 0x0,
    0x3fdf5271a7c927fc, 0x0,
    0x3fe3e2c76c53fea6, 0x0,
    0x3fe18b2a759412c8, 0x0,
    0xbfc1e360ea37ccb3, 0x0,
    0xbfdc335d631246f3, 0x0,
    0xbfe5d45ee0a293fc, 0x0,
    0xbfe175a4b9654815, 0x0,
    0xbfbe43afe0f48ef9, 0x0,
    0x3fdd28b4160c1221, 0x0,
    0x3fe4d98562166319, 0x0,
    0x3fe06520ced3ae0e, 0x0,
    0xbf7e06ae00cb4f49, 0x0,
    0xbfe1fc1a27473492, 0x0,
    0xbfe81f847214ce48, 0x0,
    0xbfe0d85a43f4c8c3, 0x0,
    0xbfaf29401170e802, 0x0,
    0x3fdbeeed6cb4fcba, 0x0,
    0x3fe57c6504a4d91f, 0x0,
    0x3fdeccd10a667372, 0x0,
    0xbfb809c1c96df4f4, 0x0,
    0xbfe06f45d55a1889, 0x0,
    0xbfe5a4b61acdefb2, 0x0,
    0xbfe0507ef16fff60, 0x0,
    0x3f8e3d1e5c25448d, 0x0,
    0x3fdf25449cad7077, 0x0,
    0x3fe542d378c29044, 0x0,
    0x3fe103db04751739, 0x0,
    0xbfa6697691a99b37, 0x0,
    0xbfdde53b7d6476ea, 0x0,
    0xbfe960728ed3bdcc, 0x0,
    0xbfdc6c6ff71ab845, 0x0,
    0x3f4821468acdc103, 0x0,
    0x3fe1310ba3bf4f05, 0x0,
    0x3fe6035d293b01b6, 0x0,
    0x3fdf8bf609eeb504, 0x0,
    0xbf9880f81a7ff899, 0x0,
    0xbfde74216140889b, 0x0,
    0xbfe448cb343d8467, 0x0,
    0xbfe07a04ab0d27ed, 0x0,
    0x3fb187705c576270, 0x0,
    0x3fe01960ea9d978d, 0x0,
    0x3fe6123cd3244e20, 0x0,
    0x3fe0ce6922300e53, 0x0,
    0x3faa74a96e78840d, 0x0,
    0xbfe1bfa6d7fde45d, 0x0,
    0xbfe5356eb6d2cc45, 0x0,
    0xbfe638c9f80113e4, 0x0,
    0x3f914247b8f8da54, 0x0,
    0x3fdefd56b168b322, 0x0,
    0x3fe7f5dbf3839c8f, 0x0,
    0x3fe2e7f7211955e7, 0x0,
    0x3fab20c5e3cf416a, 0x0,
    0xbfe022068321ca10, 0x0,
    0xbfe95b4284a42399, 0x0,
    0xbfe077ded470e38a, 0x0,
    0xbfa541e46638b93e, 0x0,
    0x3fde79b8f132f434, 0x0,
    0x3fe46285255e303d, 0x0,
    0x3fde5152c76c4b72, 0x0,
    0xbf871ba3beb7827c, 0x0,
    0xbfdc8beefd413e9b, 0x0,
    0xbfe7456e8a4a51f3, 0x0,
    0xbfe19439f7edac6f, 0x0,
    0x3f911bbc6ac2ef58, 0x0,
    0x3fdb6b1a385999a4, 0x0,
    0x3fe797882c48d3e8, 0x0,
    0x3fe03b2d7e1f6f70, 0x0,
    0xbfa48ca1f272fedd, 0x0,
    0xbfe353b632f7e362, 0x0,
    0xbfe5899f3b698359, 0x0,
    0xbfe5403470c9671f, 0x0,
    0x3f8a13f5fb780c17, 0x0,
    0x3fe078152ae1d01c, 0x0,
    0x3fe793a812886a9e, 0x0,
    0x3fe00726081c6876, 0x0,
    0xbfa913f4f97f0768, 0x0,
    0xbfde9c5e1b030de9, 0x0,
    0xbfe77b3e39916aad, 0x0,
    0xbfdbcc3a2a8028f4, 0x0,
    0xbf921efebefe4a57, 0x0,
    0x3fdb228bc5b1a556, 0x0,
    0x3fe7e0f1f2e421f9, 0x0,
    0x3fddd37795dba614, 0x0,
    0xbfa7c02af3c0840e, 0x0,
    0xbfdfdbc0ed04aa0e, 0x0,
    0xbfeac4b7a46c5b34, 0x0,
    0xbfdcb8a5bcbdde6c, 0x0,
    0xbf876a220b7a0283, 0x0,
    0x3fe16e67278f3969, 0x0,
    0x3fe58d3301329725, 0x0,
    0x3fe2e4cb3cd95384, 0x0,
    0x3f8573138e106589, 0x0,
    0xbfe107111462a9bd, 0x0,
    0xbfe819af6b61785e, 0x0,
    0xbfdd2531fd357cc9, 0x0,
    0x3fb0ffe99fb49705, 0x0,
    0x3fde8da81c7ddcae, 0x0,
    0x3fe749fcf07d40b9, 0x0,
    0x3fdbe56e8673bd18, 0x0,
    0x3f77c2aa30cf7d48, 0x0,
    0xbfdf78577711684a, 0x0,
    0xbfe4a126097c1815, 0x0,
    0xbfddd57158560a38, 0x0,
    0x3fa9817122355489, 0x0,
    0x3fe0cd27bcdaf53e, 0x0,
    0x3fe31d6fd59ef60e, 0x0,
    0x3fe0060d7aad4e47, 0x0,
    0xbf8973cf5b60536e, 0x0,
    0xbfe0f0f00d2820b9, 0x0,
    0xbfe7fc7e8ef58282, 0x0,
    0xbfdf3bf23a3ae753, 0x0,
    0xbf9a2c6bfb65dfd5, 0x0,
    0x3fe0ab7701bce176, 0x0,
    0x3fe66487bb3d4715, 0x0,
    0x3fdaf03b9ebe46cc, 0x0,
    0x3facf34061ca5b75, 0x0,
    0xbfde770352c6cbf5, 0x0,
    0xbfe5a400c5e7f09b, 0x0,
    0xbfe12ab43064eea6, 0x0,
    0xbfa8b17710170c35, 0x0,
    0x3fe00b0c147e6d08, 0x0,
    0x3fe76a1cf7d8fec1, 0x0,
    0x3fde2d3e21d0cac0, 0x0,
    0x3f69b70c398262be, 0x0,
    0xbfe1d76f416485d2, 0x0,
    0xbfe68d6e46fb67ed, 0x0,
    0xbfe118584660a7e0, 0x0,
    0xbf8911d55ae82fda, 0x0,
    0x3fdea4a34aaa9e1c, 0x0,
    0x3fe6a1e568affd1a, 0x0,
    0x3fde7d200a04c16c, 0x0,
    0x3f7a73fb3fc5765e, 0x0,
    0xbfdb76e2f28b44b7, 0x0,
    0xbfe62ce36f084069, 0x0,
    0xbfe087921f0befcf, 0x0,
    0xbfb2e4e4261639a2, 0x0,
    0x3fe188a8421d4863, 0x0,
    0x3fe5ecef0008e177, 0x0,
    0x3fdc23a9a066b079, 0x0,
    0x3f682474752c683a, 0x0,
    0xbfd91ef9926f249d, 0x0,
    0xbfe46e64fb9d2891, 0x0,
    0xbfe05bef26ff2059, 0x0,
    0x3f87284579c6aa45, 0x0,
    0x3fda5eef96b33f0e, 0x0,
    0x3fe6f2c3e2b790ad, 0x0,
    0x3fe0930edceb387a, 0x0,
    0x3fb4565c20d34077, 0x0,
    0xbfddbd16ac04dd50, 0x0,
    0xbfe63b8c68cd8f08, 0x0,
    0xbfde8aea10cd0aa2, 0x0,
    0xbfbd67a6e8c26c86, 0x0,
    0x3fdc6f9b3ca3e0d2, 0x0,
    0x3fe887611daabd76, 0x0,
    0x3fdf3b58a56c97a1, 0x0,
    0x3fb35c05b41b10a7, 0x0,
    0xbfe39d81f5e365a6, 0x0,
    0xbfe60cfe395165f7, 0x0,
    0xbfdab022459e4a0c, 0x0,
    0xbfa20c15b4e6cec3, 0x0,
    0x3fe0d9639aeb0736, 0x0,
    0x3fe820daa7a63961, 0x0,
    0x3fdf5f04c87e8775, 0x0,
    0xbf9c60e146cf00cb, 0x0,
    0xbfdb8f97ece63c9c, 0x0,
    0xbfe657126cc09272, 0x0,
    0xbfe09e0726fc45dd, 0x0,
    0x3fa77898917445ee, 0x0,
    0x3fe0b7dbcaed41ec, 0x0,
    0x3fe60378b405e29a, 0x0,
    0x3fe25beb76e96329, 0x0,
    0x3f80cb19b9a38d4c, 0x0,
    0xbfe0c7498de12405, 0x0,
    0xbfea43f42cc0eea6, 0x0,
    0xbfe1fedcdf295392, 0x0,
    0xbfa9256b6bed767c, 0x0,
    0x3fde641a548eabc2, 0x0,
    0x3fe3b1bdfb79264e, 0x0,
    0x3fdfc951255f44cc, 0x0,
    0xbf9c3773a17538cb, 0x0,
    0xbfda5cf23dfdea2a, 0x0,
    0xbfe6160f7a4966c0, 0x0,
    0xbfd9fc14e3439de5, 0x0,
    0x3f626d06060a0a54, 0x0,
    0x3fe05ae59b847fce, 0x0,
    0x3fe9b18b57e23e74, 0x0,
    0x3fda07ecc6033a5e, 0x0,
    0x3fb009731cfa271b, 0x0,
    0xbfe0662a8d37a097, 0x0,
    0xbfe9ab10b307413a, 0x0,
    0xbfe21d6327d02c64, 0x0,
    0x3f96a20235b42d30, 0x0,
    0x3fdf3f18f2903878, 0x0,
    0x3fe42858b9a985a4, 0x0,
    0x3fe0a443b6aabee3, 0x0,
    0x3f92812083c46db4, 0x0,
    0xbfe13e611dc9820d, 0x0,
    0xbfe9a8695379a5a4, 0x0,
    0xbfdf78e8be62f003, 0x0,
    0x3fa6b155b6637600, 0x0,
    0x3fe00b8b0e47d80d, 0x0,
    0x3fe3defd9ea8434a, 0x0,
    0x3fddd705ff57abc3, 0x0,
    0xbfa7e2fa0d2ca22d, 0x0,
    0xbfde777ae6407aa5, 0x0,
    0xbfe6e18864d7abba, 0x0,
    0xbfdd34aa6c807fc8, 0x0,
    0xbf5690023fb14af7, 0x0,
    0x3fdde5c5c2c5e432, 0x0,
    0x3fe6f967d9aef510, 0x0,
    0x3fe0649d1ee5c394, 0x0,
    0x3fae030a9be2041e, 0x0,
    0xbfe15cbe4a76a7ed, 0x0,
    0xbfe603638e5fb1ea, 0x0,
    0xbfe065245ebb6eca, 0x0,
    0x3fb2739c51d33f83, 0x0,
    0x3fdcde51a29e7411, 0x0,
    0x3fe1e81fb1a91d9d, 0x0,
    0x3fe001d9f02edcba, 0x0,
    0x3f9fbd0cdd178acd, 0x0,
    0xbfe2d13016021e35, 0x0,
    0xbfe583c62354898e, 0x0,
    0xbfe1749b30b287de, 0x0,
    0xbf91d578ef9dc828, 0x0,
    0x3fdc936971b3321e, 0x0,
    0x3fe6106c8e4f9070, 0x0,
    0x3fe101efd03268b0, 0x0,
    0xbfa46eb526f0f284, 0x0,
    0xbfe088731f666f07, 0x0,
    0xbfe56f1b8886d676, 0x0,
    0xbfd89720f83a410a, 0x0,
    0x3fb01b5c6ecfa118, 0x0,
    0x3fdc34080e59df53, 0x0,
    0x3fe5e5720e13df5e, 0x0,
    0x3fdc24747b31e242, 0x0,
    0x3f86d7b865763c9b, 0x0,
    0xbfddafa2aa45ee98, 0x0,
    0xbfe817be1b91247e, 0x0,
    0xbfe05daf350be228, 0x0,
    0x3fa1c36a38a0f7f5, 0x0,
    0x3fddf8e17e360528, 0x0,
    0x3fe6c71f696d3959, 0x0,
    0x3fdbb3211bb8a8bc, 0x0,
    0xbf99bf974f570aed, 0x0,
    0xbfd98edc66e5c6dc, 0x0,
    0xbfe7168edbb03a71, 0x0,
    0xbfdf119bdc89d6cd, 0x0,
    0x3f817bea68764d4c, 0x0,
    0x3fe1c23c0cd5bb45, 0x0,
    0x3fe4b354c1d5150d, 0x0,
    0x3fd9f8e3dd6210ed, 0x0,
    0x3f4cc93bcdf9bd23, 0x0,
    0xbfe0175cf2c409cd, 0x0,
    0xbfe84067d4a33a7a, 0x0,
    0xbfe098a05750d14e, 0x0,
    0x3fb3c908f8630396, 0x0,
    0x3fdb7a3809274400, 0x0,
    0x3fe69bc37550b7ba, 0x0,
    0x3fdfc0ac8a897576, 0x0,
    0xbfa490a91145942a, 0x0,
    0xbfe0cb0956fcbbdd, 0x0,
    0xbfe65807aa2a0e24, 0x0,
    0xbfe2b7f4a3b965a0, 0x0,
    0xbf73371cfbc9aa2c, 0x0,
    0x3fe036dbe33c3775, 0x0,
    0x3fe7bb05e2d61e74, 0x0,
    0x3fe1fd0dfd29176d, 0x0,
    0x3f9b92a2f14bd499, 0x0,
    0xbfe09b84b8ecd889, 0x0,
    0xbfe5a4f5e64faf19, 0x0,
    0xbfde94978474414c, 0x0,
    0x3fb4f0f23d7323fb, 0x0,
    0x3fddfbc632753b46, 0x0,
    0x3fe7a42a6416e77d, 0x0,
    0x3fdc1c82b282db15, 0x0,
    0x3fac425cb711ddf1, 0x0,
    0xbfe05e545d1c0cd6, 0x0,
    0xbfe3fbdebecf2c14, 0x0,
    0xbfdd4e4d1b03d5aa, 0x0,
    0x3f9532f144968d08, 0x0,
    0x3fdde5a346651192, 0x0,
    0x3fe7c0436d9e70b8, 0x0,
    0x3fe08e58cd09a948, 0x0,
    0x3fb63e4e4c43096e, 0x0,
    0xbfd69ef88ba0b6c0, 0x0,
    0xbfe7982bbec7cf41, 0x0,
    0xbfdd1d6cb0317197, 0x0,
    0x3f94296ee749800e, 0x0,
    0x3fe269d3e9b11dd7, 0x0,
    0x3fe721581685fd56, 0x0,
    0x3fdea2f109e5c034, 0x0,
    0xbf6363d9605a1586, 0x0,
    0xbfe24ce229f5a906, 0x0,
    0xbfe96e81c28b7906, 0x0,
    0xbfe053074417d598, 0x0,
    0xbf8d3d050d45d821, 0x0,
    0x3fe0bc8dcb8d9411, 0x0,
    0x3fe4afc77bb77dbd, 0x0,
    0x3fdeea5e7a9a8e16, 0x0,
    0xbfa4be2d06fe7c73, 0x0,
    0xbfe059878499df6f, 0x0,
    0xbfe3483aa812d736, 0x0,
    0xbfdbe2fda74e777c, 0x0,
    0xbf99d593ee7b43d2, 0x0,
    0x3fe44416eeb1d7d6, 0x0,
    0x3fe6e21a88eb232e, 0x0,
    0x3fdbaee2582692d1, 0x0,
    0xbfbaf0bd48acd15a, 0x0,
    0xbfe39a10b68090e5, 0x0,
    0xbfe6f23199c2a144, 0x0,
    0xbfdb59ed6d5dc9b7, 0x0,
    0xbfa9653a65a95fcd, 0x0,
    0x3fdedca19199b986, 0x0,
    0x3fe5b7ea6bdb51e1, 0x0,
    0x3fe04e5d8e3f383c, 0x0,
    0x3fb6f029a5d9d8a9, 0x0,
    0xbfd9daaab75dcba0, 0x0,
    0xbfe677f240c1e403, 0x0,
    0xbfe1adf98612eebe, 0x0,
    0x3f956ed716d1b412, 0x0,
    0x3fdd5984d2067c30, 0x0,
    0x3fe6f2a5cd7f567d, 0x0,
    0x3fda1c5d7779cf26, 0x0,
    0xbfb3c4bbc25ce750, 0x0,
    0xbfe0d6e9e207b8e6, 0x0,
    0xbfe3dd598197b8d9, 0x0,
    0xbfe1ebf9b76ea916, 0x0,
    0xbf9bddc643868443, 0x0,
    0x3fdea9d26cf3cfae, 0x0,
    0x3fe82ffdfe0e7c56, 0x0,
    0x3fdd2978556362c2, 0x0,
    0x3fa6d6d459c19436, 0x0,
    0xbfdfb3b62bddbd92, 0x0,
    0xbfe86cf166890e91, 0x0,
    0xbfe1dc5c7956d8f7, 0x0,
    0xbf9f2cd2a5fbea8b, 0x0,
    0x3fe087a85a5edfa7, 0x0,
    0x3fe5dd2e7ad0cfc5, 0x0,
    0x3fdc7b634a60aede, 0x0,
    0xbfab503140a0f027, 0x0,
    0xbfe0a99c56371844, 0x0,
    0xbfe6bfba5ea72f06, 0x0,
    0xbfe2a93143adb2ac, 0x0,
    0xbfa6c02645009e47, 0x0,
    0x3fde57a821e9162b, 0x0,
    0x3fe687f0974cd172, 0x0,
    0x3fddccefd21da574, 0x0,
    0x3fa0f44a3421f0a8, 0x0,
    0xbfe0de94518fc2d8, 0x0,
    0xbfe5e3a8755b5f40, 0x0,
    0xbfdff5b8983755a0, 0x0,
    0xbf9a5127a4ff8b34, 0x0,
    0x3fdf05c4b9a3aca6, 0x0,
    0x3fe53884fccac447, 0x0,
    0x3fdb96cb70546440, 0x0,
    0xbf9705e8e7c4c794, 0x0,
    0xbfe21b707e7fec1d, 0x0,
    0xbfe565f99309f4ae, 0x0,
    0xbfe14aa1c6295fea, 0x0,
    0xbf8df7c56c6e6a9a, 0x0,
    0x3fe10b597efe355b, 0x0,
    0x3fe6df93b5df6f5c, 0x0,
    0x3fde5f25a35ce5b0, 0x0,
    0x3fb003e709e8d99b, 0x0,
    0xbfe1804e43cacb28, 0x0,
    0xbfe77c20a01dfa04, 0x0,
    0xbfe05a8a18e5f385, 0x0,
    0xbfb082faed9087f4, 0x0,
    0x3fe0b3691741bd00, 0x0,
    0x3fe7068b9d09dcf9, 0x0,
    0x3fe3da05a43b0c8a, 0x0,
    0x3fa9c1a340872ab6, 0x0,
    0xbfe0418ae0cc268f, 0x0,
    0xbfe4765e924be1f1, 0x0,
    0xbfd838b17d24c54a, 0x0,
    0xbf9104c95c17e989, 0x0,
    0x3fe108d242a5f3ab, 0x0,
    0x3fe83e0d273ebfba, 0x0,
    0x3fe2ee5be08f8498, 0x0,
    0xbf8ba8691a24f4da, 0x0,
    0xbfd7b10aa0af82be, 0x0,
    0xbfe9ae0b80d56a16, 0x0,
    0xbfdd596d04e03667, 0x0,
    0xbf91e6b9c3c9eead, 0x0,
    0x3fdcdd67caca7596, 0x0,
    0x3fe7b1aeb8989d69, 0x0,
    0x3fe0734d81e816f5, 0x0,
    0x3fae93a9d123cf37, 0x0,
    0xbfe0a013fa0a5a50, 0x0,
    0xbfe5b401e3c9db5c, 0x0,
    0xbfdfc53c021ce1ba, 0x0,
    0xbfaef0238a873ece, 0x0,
    0x3fe1d5eac5b62d78, 0x0,
    0x3fe487f7c6e2e51d, 0x0,
    0x3fded074c2097626, 0x0,
    0xbfa52d1c0337e39c, 0x0,
    0xbfe0be704dc8aa61, 0x0,
    0xbfe7d7d9b07c61b0, 0x0,
    0xbfe106c91956f81b, 0x0,
    0xbfa47857e3721ae5, 0x0,
    0x3fe1c35e9c334710, 0x0,
    0x3fe571b08c539a8d, 0x0,
    0x3fdc61c22e352660, 0x0,
    0xbf977708e0e20da1, 0x0,
    0xbfe22a6f61b867d3, 0x0,
    0xbfe549048f02f6c4, 0x0,
    0xbfe05d6a43f85cdb, 0x0,
    0x3f96be65d4e781de, 0x0,
    0x3fe073fd7ea6a659, 0x0,
    0x3fe450fcdc8bc606, 0x0,
    0x3fe13f6653796525, 0x0,
    0x3fa81fb8d0066c35, 0x0,
    0xbfdd610ddfa055f8, 0x0,
    0xbfe5b687288b2a4a, 0x0,
    0xbfd8a7e6970ca266, 0x0,
    0xbfafa6777d600dfd, 0x0,
    0x3fe150fc787b1b86, 0x0,
    0x3fe6043ecc075853, 0x0,
    0x3fe12aaa865c22e0, 0x0,
    0x3fa42129d955cd5f, 0x0,
    0xbfe0e97f24e8269f, 0x0,
    0xbfe6db0609661a54, 0x0,
    0xbfe085eda73154e7, 0x0,
    0x3fbdeb9590d445b5, 0x0,
    0x3fde2548f841ed8a, 0x0,
    0x3fe6ec0db4bfb14d, 0x0,
    0x3fdb430ff0a1f6f8, 0x0,
    0xbfa3aae4d00135cd, 0x0,
    0xbfddb88980fe9f76, 0x0,
    0xbfe92b0c5c01dc95, 0x0,
    0xbfdd15af77be189b, 0x0,
    0xbfb0467c35ae66d2, 0x0,
    0x3fe0d6f1d11b251d, 0x0,
    0x3fe43aacfee30a10, 0x0,
    0x3fd9d096b2258539, 0x0,
    0x3fb6577a66f38dad, 0x0,
    0xbfe2ab9d404acf9c, 0x0,
    0xbfe7f1d4c53d5f28, 0x0,
    0xbfe090eabb3d682a, 0x0,
    0xbf9ce42a3586aa22, 0x0,
    0x3fddccad521c7e1c, 0x0,
    0x3fe3eb0e2b3a99e8, 0x0,
    0x3fddd0ba519addc6, 0x0,
    0x3f84c5e3e93b1245, 0x0,
    0xbfe2805a3d8c3c60, 0x0,
    0xbfe4a277acb1ac15, 0x0,
    0xbfda8078801a3733, 0x0,
    0xbfa2cceb8f836c7c, 0x0,
    0x3fddaf9656951791, 0x0,
    0x3fe5ca8aebd8f69a, 0x0,
    0x3fd99c8f47f670dc, 0x0,
    0x3faedbcf4e20434f, 0x0,
    0xbfe009925053baf5, 0x0,
    0xbfe60c218cb0bbc4, 0x0,
    0xbfe00e43b8500e4f, 0x0,
    0x3f75bce1e27cc5f7, 0x0,
    0x3fde5f99b6d20638, 0x0,
    0x3fe66511926fc5d2, 0x0,
    0x3fe0b2416c9e1d64, 0x0,
    0xbfb0df40718d41ff, 0x0,
    0xbfdf5b6f3bc484e1, 0x0,
    0xbfe6b8d2c63a6768, 0x0,
    0xbfe0338ab554b876, 0x0,
    0x3f6129843893d239, 0x0,
    0x3fe193934af0e5a7, 0x0,
    0x3fe2228a6dddcedd, 0x0,
    0x3fe00929397a3e5f, 0x0,
    0x3facb0c32f29ded7, 0x0,
    0xbfe13a6c153446c8, 0x0,
    0xbfe5cc389db2d21e, 0x0,
    0xbfe1e96fe17978e5, 0x0,
    0xbfa6be7931f11baf, 0x0,
    0x3fe26cb4693c49cd, 0x0,
    0x3fe64a49020c4a9f, 0x0,
    0x3fe0e1f6f48e5566, 0x0,
    0xbfb27b327449693e, 0x0,
    0xbfe0acc8481be655, 0x0,
    0xbfe5836fdc230886, 0x0,
    0xbfe03a70f4c1299e, 0x0,
    0x3faf55fec56d9e6f, 0x0,
    0x3fdd9108a149d460, 0x0,
    0x3fe59d879a557516, 0x0,
    0x3fdc759f79ea2151, 0x0,
    0xbf876923158b54fa, 0x0,
    0xbfe0b32f48c6c94e, 0x0,
    0xbfe5cda527424e30, 0x0,
    0xbfdbbea91c07a68d, 0x0,
    0xbf943274408cdeec, 0x0,
    0x3fe01463360cc677, 0x0,
    0x3fe5b4960a501eab, 0x0,
    0x3fdd3fe21b06b46b, 0x0,
    0xbf901980299ee6e9, 0x0,
    0xbfe0172c30c4de72, 0x0,
    0xbfe631007ee613bf, 0x0,
    0xbfe039c2803e96db, 0x0,
    0xbfae904484b0f92f, 0x0,
    0x3fe0ce8e42968510, 0x0,
    0x3fe98f973a4ae9dd, 0x0,
    0x3fdfdaafc1d559c5, 0x0,
    0x3f914a25aa0e2da3, 0x0,
    0xbfe047d9b5e9e657, 0x0,
    0xbfe7122f37fe7fb1, 0x0,
    0xbfdfcc65dd35f97f, 0x0,
    0xbf9e1b666ce2fafd, 0x0,
    0x3fe046a67649bd70, 0x0,
    0x3fe976f23aa7ac4f, 0x0,
    0x3fdbf26e58dc5c62, 0x0,
    0xbf905539314fd7da, 0x0,
    0xbfe067b19aa59ea2, 0x0,
    0xbfe78ac4c1ddb23d, 0x0,
    0xbfe23c92caeaf2ab, 0x0,
    0xbfa69dbdc8a02f83, 0x0,
    0x3fe0678f4453eab2, 0x0,
    0x3fe5b4684a155273, 0x0,
    0x3fdb6029839558f4, 0x0,
    0x3f962433bfdbcee4, 0x0,
    0xbfdbd5952f7135cc, 0x0,
    0xbfe5314e7295ffb6, 0x0,
    0xbfe00a99b8270f79, 0x0,
    0xbf85a6159ea7162d, 0x0,
    0x3fe24710612fa88a, 0x0,
    0x3fe3230895d0195a, 0x0,
    0x3fdeeed7aecbdaf4, 0x0,
    0x3f9a4c7271941514, 0x0,
    0xbfe0ee743077f334, 0x0,
    0xbfe69f62f82b41e9, 0x0,
    0xbfe25b2a144b2a72, 0x0,
    0xbfa185fc56a72f3e, 0x0,
    0x3fe03029d82f6e4c, 0x0,
    0x3fe3fddc8682f295, 0x0,
    0x3fdfb73e3125a1af, 0x0,
    0xbf95e9646e43e8ab, 0x0,
    0xbfdf090701924e09, 0x0,
    0xbfe568e1cc192e7b, 0x0,
    0xbfdb59953d9b28d0, 0x0,
    0xbfa0aba2bcf677b2, 0x0,
    0x3fdf4f78716acc68, 0x0,
    0x3fe681a9b6d6bb66, 0x0,
    0x3fe05c8840e39011, 0x0,
    0xbf972e22979465a2, 0x0,
    0xbfe040614f3a6ae4, 0x0,
    0xbfe67763f7c0834a, 0x0,
    0xbfe25925a436e8a6, 0x0,
    0x3f8663d19f222df8, 0x0,
    0x3fe1db99403954bd, 0x0,
    0x3fe54a0a0d294e0d, 0x0,
    0x3fdbd58e881583ac, 0x0,
    0xbfb9944a15ca89b9, 0x0,
    0xbfdff9e32780c615, 0x0,
    0xbfe70ae764c75d9f, 0x0,
    0xbfdecddc8f9823c3, 0x0,
    0xbfaaa016aec55d53, 0x0,
    0x3fe0440417a27829, 0x0,
    0x3fe734e6b1b28dec, 0x0,
    0x3fdb2c6232de636f, 0x0,
    0x3fa580ccf13e4935, 0x0,
    0xbfe1865fc2125d20, 0x0,
    0xbfe66874683bcac1, 0x0,
    0xbfe0488aec65ccec, 0x0,
    0x3f8c2f9dca4dc226, 0x0,
    0x3fdf2f39e9920612, 0x0,
    0x3fe69557ff2b6858, 0x0,
    0x3fe1cec76b245e8f, 0x0,
    0x3fab8fb28f69e2a8, 0x0,
    0xbfe344809bdc490d, 0x0,
    0xbfe647de077faddd, 0x0,
    0xbfdd5ecb5d4b624b, 0x0,
    0x3fc26d96e580713d, 0x0,
    0x3fdfc5e889ec85ef, 0x0,
    0x3fe7fdecc0ead229, 0x0,
    0x3fe39c940a018b24, 0x0,
    0x3fab1850e37459ad, 0x0,
    0xbfdb84753f8722a4, 0x0,
    0xbfe83ca6f32d4581, 0x0,
    0xbfd9e260b4fb68d5, 0x0,
    0xbfb605d87e39668b, 0x0,
    0x3fdd7b74fab16d7c, 0x0,
    0x3fe8203b6bf40b48, 0x0,
    0x3fe02d2bb8a930c3, 0x0,
    0x3f9c511af7ad80f3, 0x0,
    0xbfe2458264a77f1c, 0x0,
    0xbfe44b58a5552013, 0x0,
    0xbfdba525d3623daa, 0x0,
    0x3f9b05fa865e6688, 0x0,
    0x3fdc274e87c4a5ab, 0x0,
    0x3fe6247792951c83, 0x0,
    0x3fdf8590e9100b48, 0x0,
    0x3f717ead45f79b66, 0x0,
    0xbfe0e463f1545962, 0x0,
    0xbfe62dbece28d90d, 0x0,
    0xbfde3d891b79f13d, 0x0,
    0x3fa9c9308a151314, 0x0,
    0x3fdcb1b91419a958, 0x0,
    0x3fe70f0033f3cb9e, 0x0,
    0x3fdfaf5bb893f9cf, 0x0,
    0xbf960ddb5e780b21, 0x0,
    0xbfdd005e201479dd, 0x0,
    0xbfe88e9dbc41198e, 0x0,
    0xbfd965c0a790d29e, 0x0,
    0x3f944866e2e28ba6, 0x0,
    0x3fdd539d61767e87, 0x0,
    0x3fe785f9d29c906a, 0x0,
    0x3fdf1e407b68a4bc, 0x0,
    0x3f9dc2ebce2b03ed, 0x0,
    0xbfdf1a8bc62df14f, 0x0,
    0xbfe8b42a0c13b167, 0x0,
    0xbfe11cf651e53f2d, 0x0,
    0xbfa496de2e3649b7, 0x0,
    0x3fdee83d3d9d93ad, 0x0,
    0x3fe5795d4da62c00, 0x0,
    0x3fe446a10c1f67a4, 0x0,
    0x3f6f44d07446a261, 0x0,
    0xbfde1f401decf4dc, 0x0,
    0xbfe64edb772e2be3, 0x0,
    0xbfde4c8a8c1c8d44, 0x0,
    0x3fa2f7e1f8598f3a, 0x0,
    0x3fe0c60d46fa1d2e, 0x0,
    0x3fe716b53a2cd276, 0x0,
    0x3fdcb87948f4cd47, 0x0,
    0xbf99dc1ce5b581c8, 0x0,
    0xbfde7f65f2852c36, 0x0,
    0xbfe5459750a047ed, 0x0,
    0xbfde17bea017cdf5, 0x0,
    0x3fa45c27dbef4e33, 0x0,
    0x3fe05d6d407ade54, 0x0,
    0x3fe5651e6fe3a91b, 0x0,
    0x3fe2a18f1b5231d0, 0x0,
    0x3f92960bed221930, 0x0,
    0xbfdee664a6d3b012, 0x0,
    0xbfe5eae174a48a4e, 0x0,
    0xbfe3d65b23f80faf, 0x0,
    0xbfa00b32b98c08b1, 0x0,
    0x3fe15528f57215db, 0x0,
    0x3fea155f762c5809, 0x0,
    0x3fdfeea1fe1efbc4, 0x0,
    0x3f83b63d89732cc2, 0x0,
    0xbfe04bfaf6896913, 0x0,
    0xbfe5c58e0f418819, 0x0,
    0xbfdf8c6798ba710c, 0x0,
    0x3fb41521285b8054, 0x0,
    0x3fdc3f27fde9647c, 0x0,
    0x3fe6b31153ad5ac0, 0x0,
    0x3fdb98c57a41269d, 0x0,
    0x3f938d2f07ac886b, 0x0,
    0xbfe4004f358b6e77, 0x0,
    0xbfe78fea6b1f4cf2, 0x0,
    0xbfe10e5d6c23ec36, 0x0,
    0x3f96b08765227b4a, 0x0,
    0x3fd908130c3cc882, 0x0,
    0x3fe545dc1e6a24f2, 0x0,
    0x3fe05901e610e922, 0x0,
    0x3f998a08186b2682, 0x0,
    0xbfdf79711b0d1a7e, 0x0,
    0xbfe75f1a8b00513e, 0x0,
    0xbfdb0cc8f281211b, 0x0,
    0xbfa9489fdb32e0a5, 0x0,
    0x3fdee29bdf92eb37, 0x0,
    0x3fe6f618a7af0ab0, 0x0,
    0x3fe0cd8bb36676b5, 0x0,
    0x3f6513844d6aacb9, 0x0,
    0xbfdcc64d600f8be7, 0x0,
    0xbfe549fa552cd157, 0x0,
    0xbfdcafde8a2281f3, 0x0,
    0x3fa052a9c7e76d5e, 0x0,
    0x3fe0f7f0f2143b8d, 0x0,
    0x3fe759eb61775c3e, 0x0,
    0x3fdbd54b7d773758, 0x0,
    0x3fab2c42113656ff, 0x0,
    0xbfe24a0b25e4f3aa, 0x0,
    0xbfe6678614caa3f0, 0x0,
    0xbfe21552f28503b7, 0x0,
    0x3fa215632b9195a4, 0x0,
    0x3fe0c5b6d807d666, 0x0,
    0x3fe60397ebd9bfb6, 0x0,
    0x3fdfa7647d19f8ce, 0x0,
    0x3faac1a217fc4668, 0x0,
    0xbfddfdc3ac8b70bb, 0x0,
    0xbfe773cb570856f6, 0x0,
    0xbfe20a72d7dd2848, 0x0,
    0x3f7db1b2f099bef2, 0x0,
    0x3fe03b3552b6c256, 0x0,
    0x3fe50daa316995c3, 0x0,
    0x3fdb549fcd1383a6, 0x0,
    0xbfb091f8043da4fe, 0x0,
    0xbfe051f33fa533e5, 0x0,
    0xbfe82ed5a80ef97f, 0x0,
    0xbfe026ed34d0412e, 0x0,
    0xbf64d0a9f0c2f34c, 0x0,
    0x3fe12b46a519dde2, 0x0,
    0x3fe67a1a5d38c3be, 0x0,
    0x3fe06c4fc3474b3a, 0x0,
    0x3f8f95f59dae1b67, 0x0,
    0xbfdd01ce465fd156, 0x0,
    0xbfe4b89d4262fbbe, 0x0,
    0xbfdae6878fb0dcad, 0x0,
    0xbfafba95d9f9f451, 0x0,
    0x3fe0deb0459153be, 0x0,
    0x3fe4ceecd715a13c, 0x0,
    0x3fdcaed01ba84bd1, 0x0,
    0xbf939a0e24fc098e, 0x0,
    0xbfe1e0f617833f1f, 0x0,
    0xbfe94954b0b62b32, 0x0,
    0xbfdab44919dd5d83, 0x0,
    0xbf84e45c05893624, 0x0,
    0x3fdb007b8b028480, 0x0,
    0x3fe6bb11bee5e5f8, 0x0,
    0x3fde8ee978aac947, 0x0,
    0x3f9cc4af35bf3e42, 0x0,
    0xbfe0c07e90e74615, 0x0,
    0xbfe565c0c665a3f1, 0x0,
    0xbfdf88bde525bdda, 0x0,
    0xbfa1ac5651fba5f2, 0x0,
    0x3fe1bddb4c25b423, 0x0,
    0x3fe566656e29ddc4, 0x0,
    0x3fdc3707785ed571, 0x0,
    0xbf955244b4e5513f, 0x0,
    0xbfdeb5d5f8dbe1c7, 0x0,
    0xbfe43c3057c0ae82, 0x0,
    0xbfe2c4572e150e4c, 0x0,
    0xbfa093f878cc900f, 0x0,
    0x3fde30cbce2a0de8, 0x0,
    0x3fe4f565e0abc170, 0x0,
    0x3fe095e3b43e3667, 0x0,
    0xbfbd68a9fb853d74, 0x0,
    0xbfde9ae7d6fcf358, 0x0,
    0xbfe51e5883aff280, 0x0,
    0xbfdc297f88e68da7, 0x0,
    0x3f60f8cb7a4a0004, 0x0,
    0x3fdcc9e2a8f0b023, 0x0,
    0x3fe61f193d831d40, 0x0,
    0x3fde06a997782177, 0x0,
    0x3f9b76184f556e5a, 0x0,
    0xbfdd4c8e0be197e7, 0x0,
    0xbfe673d8b9a14b8a, 0x0,
    0xbfe0e5e5d0d481be, 0x0,
    0x3faf755261bf09d7, 0x0,
    0x3fe07cea620d293e, 0x0,
    0x3fe3eb012353d042, 0x0,
    0x3fe0f1215a8d684a, 0x0,
    0xbfa462b0e9e89e90, 0x0,
    0xbfdad65b901264e4, 0x0,
    0xbfe5d9e1a6bf399c, 0x0,
    0xbfe0d38da5b25a33, 0x0,
    0xbfa60d4c2939e3a1, 0x0,
    0x3fe06462e40f4c9c, 0x0,
    0x3fe64a333da56a9e, 0x0,
    0x3fe11635582a3b4f, 0x0,
    0x3f905385410e5cf2, 0x0,
    0xbfe1e67f65e78dbd, 0x0,
    0xbfe5f7e0b1b76281, 0x0,
    0xbfe07a59214bd8ad, 0x0,
    0x3fafff40202e5d1e, 0x0,
    0x3fdf5901554e61d9, 0x0,
    0x3fe6af7dc32d5697, 0x0,
    0x3fd9fbb50f00b990, 0x0,
    0xbfacc2fb7cf0c99a, 0x0,
    0xbfdfecc29dd30533, 0x0,
    0xbfe3d023e6d46ec5, 0x0,
    0xbfda3b117c48fa0a, 0x0,
    0x3fab037596b1ff1c, 0x0,
    0x3fe1329f2a3eaae7, 0x0,
    0x3fe8b8116da0a150, 0x0,
    0x3fe05901086fd842, 0x0,
    0xbfa658f91955b6ba, 0x0,
    0xbfdf84ca41b50b85, 0x0,
    0xbfe2948734623ac1, 0x0,
    0xbfddf27f5c8069bc, 0x0,
    0x3f9b4c67dda10640, 0x0,
    0x3fdba74f1a3d47c9, 0x0,
    0x3fe83eb2f1a443bf, 0x0,
    0x3fdf373cb094dea0, 0x0,
    0x3f4cda4e213102b7, 0x0,
    0xbfdbb6d8bd054081, 0x0,
    0xbfe9013ee52f3928, 0x0,
    0xbfe0f3bd856971a6, 0x0,
    0x3f4ca2e085ca347b, 0x0,
    0x3fdec920d2558223, 0x0,
    0x3fe5948588ae7f09, 0x0,
    0x3fe171ea133ab0cc, 0x0,
    0x3fb016784863642d, 0x0,
    0xbfdf96308a1ff4f6, 0x0,
    0xbfe6706e8b2d4223, 0x0,
    0xbfe0e6056dc7eb31, 0x0,
    0x3f8de82e4f363f84, 0x0,
    0x3fddf4cda4488bca, 0x0,
    0x3fe6703b0bbfcc7d, 0x0,
    0x3fe040fefe7a763f, 0x0,
    0x3f9aedc46e0848b8, 0x0,
    0xbfe467cf079a9ae2, 0x0,
    0xbfe4a466cba1dca2, 0x0,
    0xbfddfe62172fb944, 0x0,
    0x3faf44b65ddb4bac, 0x0,
    0x3fdfd9ee53ae1609, 0x0,
    0x3fe5bfd1d9bf88e4, 0x0,
    0x3fe19237b42cefb7, 0x0,
    0x3fb0ff7e82fa370e, 0x0,
    0xbfe06742127d929c, 0x0,
    0xbfe64982c9ac445e, 0x0,
    0xbfdcb896ab534a3b, 0x0,
    0x3fa9f5b62ab6fd6c, 0x0,
    0x3fdeb6c4aac9db7d, 0x0,
    0x3fe426a9e7545fc5, 0x0,
    0x3fe04c38883f1eb2, 0x0,
    0x3f9fd982bfec1a39, 0x0,
    0xbfde7b07737a1111, 0x0,
    0xbfe807b2fdec39ac, 0x0,
    0xbfe28eae61ee26b5, 0x0,
    0x3fa8768a5a8b07a0, 0x0,
    0x3fd99bb9225960a2, 0x0,
    0x3fe65b340f9f7a1b, 0x0,
    0x3fe194807cec0776, 0x0,
    0x3fac838ce77028cf, 0x0,
    0xbfe153c2c60f83fa, 0x0,
    0xbfe5a95ba3f83d24, 0x0,
    0xbfe2b3210362fa96, 0x0,
    0x3fa31d20a2391400, 0x0,
    0x3fdc35f19bfe3986, 0x0,
    0x3fe5a34e5bbb9323, 0x0,
    0x3fdd11983837cde5, 0x0,
    0xbf79c93dc936d542, 0x0,
    0xbfe0e5314ebed12d, 0x0,
    0xbfe4260be03cf560, 0x0,
    0xbfdb446fcc644299, 0x0,
    0x3fa097fd93efaa7f, 0x0,
    0x3fe0dc5e995cdc56, 0x0,
    0x3fe7a538b3d10b45, 0x0,
    0x3fdb50a4f72c36e3, 0x0,
    0xbfa2d83523eb96d8, 0x0,
    0xbfe24497c2150ef9, 0x0,
    0xbfe5ac024886dc97, 0x0,
    0xbfe0247be37bcec5, 0x0,
    0x3fbaaa0b791d6d3c, 0x0,
    0x3fe007d994aab78e, 0x0,
    0x3fea7196b7c13cd9, 0x0,
    0x3fddb69fa331ece8, 0x0,
    0xbfacd4f399c429c4, 0x0,
    0xbfe340dc24ca9282, 0x0,
    0xbfe87581d5239f00, 0x0,
    0xbfe02acbe4abc7b6, 0x0,
    0x3f7403f232c89b4a, 0x0,
    0x3fde96afe9b47f97, 0x0,
    0x3fe8defd235da766, 0x0,
    0x3fdeb81b32285c47, 0x0,
    0xbf773a23e309813b, 0x0,
    0xbfdf4310f67ad38e, 0x0,
    0xbfe869cd690e26e5, 0x0,
    0xbfe0d5eafc0ab004, 0x0,
    0xbfb8900da5213cec, 0x0,
    0x3fdf8d55579949c8, 0x0,
    0x3fe831618bf6661b, 0x0,
    0x3fe3e57f270e5601, 0x0,
    0xbfade32ef40b4335, 0x0,
    0xbfe16b6fee2143fa, 0x0,
    0xbfe8671627c4584a, 0x0,
    0xbfe08208c37e83e5, 0x0,
    0xbf9b55c0f59b4197, 0x0,
    0x3fe03e8fdf34c6d3, 0x0,
    0x3fe69d94c3a34627, 0x0,
    0x3fe0cbe1ad997f82, 0x0,
    0xbfa11685dd5ac852, 0x0,
    0xbfdb702384af58b3, 0x0,
    0xbfe9a351c8218aa2, 0x0,
    0xbfde26e2a04b2aeb, 0x0,
    0xbf6c8d66fc81880a, 0x0,
    0x3fe021696b39aa0f, 0x0,
    0x3fe8a5ac1de8ad59, 0x0,
    0x3fdf03a4f31d9a0c, 0x0,
    0x3fafd1364d31a71a, 0x0,
    0xbfe1523dea60714f, 0x0,
    0xbfe8d985c531fe4a, 0x0,
    0xbfe143cfdbb9995c, 0x0,
    0x3fadcaa026c666b8, 0x0,
    0x3fdd9694fdbe5e2b, 0x0,
    0x3fea666b1c530130, 0x0,
    0x3fe12f427724386e, 0x0,
    0x3f74992f3375a822, 0x0,
    0xbfdf5ce6c8912641, 0x0,
    0xbfe5d7218a652214, 0x0,
    0xbfdb5dacc47d01a0, 0x0,
    0x3faddb33cef7e42d, 0x0,
    0x3fe0df299d3fcdcd, 0x0,
    0x3fe6376f3bef8bb5, 0x0,
    0x3fe11d28e1dd5ca3, 0x0,
    0x3fb6baba3ada9c0b, 0x0,
    0xbfdc49bdbf64c436, 0x0,
    0xbfe7a5eb435e4ef6, 0x0,
    0xbfdd341a77cdd1fa, 0x0,
    0x3f993193589006a2, 0x0,
    0x3fe1652c5a33e7cf, 0x0,
    0x3fe7b5d36acd2813, 0x0,
    0x3fdffd7740dda93d, 0x0,
    0xbfa2bacdc76dd9aa, 0x0,
    0xbfd9bee43c55b440, 0x0,
    0xbfe485775b0adec4, 0x0,
    0xbfe1758f282fb22c, 0x0,
    0x3fb7e95e57598d66, 0x0,
    0x3fe1a2e448587205, 0x0,
    0x3fe77ef5679b8f22, 0x0,
    0x3fde68553ff6f8cb, 0x0,
    0x3fa66f30a07a2725, 0x0,
    0xbfe1f967799beb06, 0x0,
    0xbfe5457a00110b54, 0x0,
    0xbfe15c3478ad1336, 0x0,
    0x3fb2734b22830b2e, 0x0,
    0x3fe1e1568fb78eac, 0x0,
    0x3fe89e7a23cc9329, 0x0,
    0x3fdf11efbee9957c, 0x0,
    0xbfa5f322a820eb75, 0x0,
    0xbfe246234c2cad45, 0x0,
    0xbfe10531d81ee7d0, 0x0,
    0xbfe0a70a0a23b7ca, 0x0,
    0xbfbecb86d4ccefb5, 0x0,
    0x3fddd31d5974f8d2, 0x0,
    0x3fe6514b8eb926b3, 0x0,
    0x3fde4eccace87df3, 0x0,
    0x3fb4396c5dce9531, 0x0,
    0xbfd6d0aa9614c427, 0x0,
    0xbfe51f3e11106577, 0x0,
    0xbfe048dba770d0dc, 0x0,
    0xbf9b9e37014ca005, 0x0,
    0x3fe0958fa98c6e57, 0x0,
    0x3fe59e658242852a, 0x0,
    0x3fdefa38a902880f, 0x0,
    0x3fa4dd17fbc6a174, 0x0,
    0xbfe36811518b6309, 0x0,
    0xbfe69d6b905c3cbe, 0x0,
    0xbfe1689a09051986, 0x0,
    0x3f95696aa98f7efd, 0x0,
    0x3fe099a639c0e7aa, 0x0,
    0x3fe86c820327a4ee, 0x0,
    0x3fdfb35314a20979, 0x0,
    0x3fa8ded222e7348b, 0x0,
    0xbfda8a81b42e084d, 0x0,
    0xbfe6855963fd70b1, 0x0,
    0xbfdd7e66413af19d, 0x0,
    0x3f836a85bc8d9d02, 0x0,
    0x3fe09fca473b0642, 0x0,
    0x3fe68d47e64c822c, 0x0,
    0x3fe0ec39b0383cf4, 0x0,
    0xbfa5eb908e5d47fa, 0x0,
    0xbfe0af18c08d148c, 0x0,
    0xbfe4f0a3394a7a03, 0x0,
    0xbfe22cc9cdafe4f3, 0x0,
    0x3fa65622acc6a7be, 0x0,
    0x3fe04304a456c753, 0x0,
    0x3fe8e35248676478, 0x0,
    0x3fe0786bf8f41dab, 0x0,
    0xbfb43963b32faca0, 0x0,
    0xbfdaf9dc3a3d2e6c, 0x0,
    0xbfead62c2dceb296, 0x0,
    0xbfe03039b3f7d6b7, 0x0,
    0xbf8e65a59b88b9a6, 0x0,
    0x3fdc169cbb9f4d98, 0x0,
    0x3fe6594b93ef088e, 0x0,
    0x3fe13be8a6d2eb8d, 0x0,
    0xbf6564c78deb85ee, 0x0,
    0xbfdce35c81ed5f57, 0x0,
    0xbfe27f582f63b976, 0x0,
    0xbfdb02486eaa18d9, 0x0,
    0xbfaaedc8b8ea785e, 0x0,
    0x3fe07dace1451d72, 0x0,
    0x3fe74884857f2937, 0x0,
    0x3fe191eca7b44696, 0x0,
    0x3fa7bfbcd1066465, 0x0,
    0xbfe1f97255f4c1b4, 0x0,
    0xbfe59540f2facc52, 0x0,
    0xbfe1e0382229c855, 0x0,
    0xbfb02edbe06c975d, 0x0,
    0x3fe0d5a1be3b51b7, 0x0,
    0x3fe6e4b49ccfe9b5, 0x0,
    0x3fdc8953ffd29739, 0x0,
    0x3f88c3223c18c415, 0x0,
    0xbfdcf84c3186a96b, 0x0,
    0xbfe5f15a52f72195, 0x0,
    0xbfdca85ce0642275, 0x0,
    0xbf9b808ed81ae2ac, 0x0,
    0x3fe10374a94eb57e, 0x0,
    0x3fe85e3dc83ddd0d, 0x0,
    0x3fe3a29275df708d, 0x0,
    0x3f99223c817243c5, 0x0,
    0xbfe067bcb0c92b2b, 0x0,
    0xbfe7bbb69ac5dd2f, 0x0,
    0xbfd85dfeaaa38ad9, 0x0,
    0xbf81629979869e08, 0x0,
    0x3fdfd91c02bd2f44, 0x0,
    0x3fe4a9c46b712087, 0x0,
    0x3fdfe123bd321693, 0x0,
    0x3f734a32335e1d73, 0x0,
    0xbfdf8d4c85750bee, 0x0,
    0xbfe61d7f94822c05, 0x0,
    0xbfdebb33c3ecbe00, 0x0,
    0xbf86c7a3fcfad160, 0x0,
    0x3fe06c73e08566a3, 0x0,
    0x3fe86a0d990438b2, 0x0,
    0x3fe0fc3497f064a6, 0x0,
    0xbfa78a68e26b6f9b, 0x0,
    0xbfdf5d2d6f5e01ef, 0x0,
    0xbfe4f2429c2193aa, 0x0,
    0xbfe20ffd4ab4f180, 0x0,
    0x3f75e95f6655392f, 0x0,
    0x3fdf28f109f187a3, 0x0,
    0x3fe64a67eef7a6c1, 0x0,
    0x3fd994a22e425e6c, 0x0,
    0x3f72e98d463d3967, 0x0,
    0xbfdcc9899d6f6998, 0x0,
    0xbfe6a4f8f4e03fc5, 0x0,
    0xbfe04d6e4a352a43, 0x0,
    0xbfa32c686db41f08, 0x0,
    0x3fdf78427dd8bc46, 0x0,
    0x3fe805102d450ae8, 0x0,
    0x3fdc0c95a00b737a, 0x0,
    0xbf978eb60ba6365f, 0x0,
    0xbfe150035ba59584, 0x0,
    0xbfe6d61bd333f395, 0x0,
    0xbfdbb9225866ba78, 0x0,
    0x3f8cb8c357f85ddc, 0x0,
    0x3fe0da2c056c068b, 0x0,
    0x3fe660d30f0223f5, 0x0,
    0x3fe1669c78fd6bf8, 0x0,
    0xbf9f3f102eb05e0e, 0x0,
    0xbfde1afdc7012dc6, 0x0,
    0xbfe4f53b86235832, 0x0,
    0xbfe1d278e586db9f, 0x0,
    0x3f96a985eaedf9b8, 0x0,
    0x3fe02467b213a84a, 0x0,
    0x3fe83e1879c38f3e, 0x0,
    0x3fddc4bdafa6e9aa, 0x0,
    0xbfbbad4dc5f78fee, 0x0,
    0xbfdd028e371fa68a, 0x0,
    0xbfe91d889855f0aa, 0x0,
    0xbfdec506e2d0bc13, 0x0,
    0xbf94dc2f1cf486f2, 0x0,
    0x3fdfb43a3c40b392, 0x0,
    0x3fe99a37a2840ce5, 0x0,
    0x3fdf285bacd4430c, 0x0,
    0xbf9ffb34b4db0d5d, 0x0,
    0xbfe10c3381a02570, 0x0,
    0xbfe5561af96842a9, 0x0,
    0xbfd997afd469cf8e, 0x0,
    0x3f8a7c4db08a3268, 0x0,
    0x3fde571f1e527266, 0x0,
    0x3fe68936bacc03b7, 0x0,
    0x3fe0b114a61be263, 0x0,
    0xbf9a9f8bb1e61299, 0x0,
    0xbfde52fc389b13b7, 0x0,
    0xbfe71bdbe0bdb706, 0x0,
    0xbfe21e42e8c0f256, 0x0,
    0x3fa7d6dc92521e7a, 0x0,
    0x3fe333d2edac0b16, 0x0,
    0x3fe608255bde4990, 0x0,
    0x3fe2117363edb85e, 0x0,
    0xbf94f7803a65b13a, 0x0,
    0xbfe23c62c1fc8b3a, 0x0,
    0xbfe566a104220165, 0x0,
    0xbfdcb05342b70494, 0x0,
    0xbf733b43a462437b, 0x0,
    0x3fdde8155d8c9003, 0x0,
    0x3fe6274d625f2d8b, 0x0,
    0x3fdd15d2d209197a, 0x0,
    0x3faee02cd3921d97, 0x0,
    0xbfdd5b1bc32bcc43, 0x0,
    0xbfe6fe4577a11467, 0x0,
    0xbfdb4277adb59172, 0x0,
    0x3fb58eacaa6c8981, 0x0,
    0x3fdedc386f4005f6, 0x0,
    0x3fe6f4c8fa63fd67, 0x0,
    0x3fe1edb4ee3bfc70, 0x0,
    0xbf91d1dd9b9902c4, 0x0,
    0xbfdafe180cdc340a, 0x0,
    0xbfe7bd1b937a38cf, 0x0,
    0xbfde33d99b0f79fa, 0x0,
    0xbf625dd7e1a1ad41, 0x0,
    0x3fe15d9f3af80854, 0x0,
    0x3fe71bbfec0a3865, 0x0,
    0x3fdc766e305ac290, 0x0,
    0x3fc011658484147c, 0x0,
    0xbfdeb9f5c0fc264c, 0x0,
    0xbfe6e2eccae629c0, 0x0,
    0xbfdede9f03b7f574, 0x0,
    0x3fb0dae80fa7ab69, 0x0,
    0x3fe0629a544dbcb0, 0x0,
    0x3fe776fb28f2d925, 0x0,
    0x3fd97ff5b01e33d3, 0x0,
    0xbf99ed5ec2340d29, 0x0,
    0xbfe0b12e53fffe5d, 0x0,
    0xbfe5b015f8ac17f8, 0x0,
    0xbfdeb845513a16a3, 0x0,
    0x3fa1e7342c85796b, 0x0,
    0x3fe181779e7d7401, 0x0,
    0x3fe363cee07d0670, 0x0,
    0x3fdfe7cd76904764, 0x0,
    0x3fb1a018ad7eef40, 0x0,
    0xbfde379f2b14fb41, 0x0,
    0xbfe5160fcbc731bf, 0x0,
    0xbfdf6555d82a6a28, 0x0,
    0xbfb7c5b58629a303, 0x0,
    0x3fe0d145036df3c7, 0x0,
    0x3fe1e6e797504d9e, 0x0,
    0x3fe097f0d3ced795, 0x0,
    0x3fadbc6163f77eb1, 0x0,
    0xbfdc727ca124b6af, 0x0,
    0xbfe5da5991f19269, 0x0,
    0xbfdbd62ba3bf3ff4, 0x0,
    0x3fc069a33f92b03b, 0x0,
    0x3fde468f36ccf606, 0x0,
    0x3fe5750bc3f4372e, 0x0,
    0x3fda0e6e5ed95b95, 0x0,
    0xbfa39758a3d98343, 0x0,
    0xbfe01f9ff75c7a4e, 0x0,
    0xbfe67903d09d696e, 0x0,
    0xbfdfeab62e3fc76c, 0x0,
    0xbfacfef8b93bb4c0, 0x0,
    0x3fe2669b02676d85, 0x0,
    0x3fe7e51818a67207, 0x0,
    0x3fde89232b4bc782, 0x0,
    0x3f26dfe8d583591a, 0x0,
    0xbfdf9cc4e6288bb7, 0x0,
    0xbfe749c9ced5307b, 0x0,
    0xbfdd37a2822b84b5, 0x0,
    0xbfb738a29667990e, 0x0,
    0x3fddf8057b567746, 0x0,
    0x3fe7165b62552e5c, 0x0,
    0x3fda41870f1356fc, 0x0,
    0x3f963e7337b182ec, 0x0,
    0xbfdcc1d282fc9004, 0x0,
    0xbfe7b2fe7e48d598, 0x0,
    0xbfdb43929236a19b, 0x0,
    0x3f394f423040dee7, 0x0,
    0x3fe0f16a41fe261c, 0x0,
    0x3fe51c232446c9e3, 0x0,
    0x3fd974b7f70eb1e7, 0x0,
    0xbf78e67e0baffda3, 0x0,
    0xbfdad35171a247ed, 0x0,
    0xbfe7f4db5fc0b57f, 0x0,
    0xbfdf5acc3baa3fab, 0x0,
    0xbf9eb93f041f5b95, 0x0,
    0x3fdcf926352338c0, 0x0,
    0x3fe87aef99c45716, 0x0,
    0x3fe048514fe5256d, 0x0,
    0xbf85bf53b2d53b70, 0x0,
    0xbfdf07eff9f1e257, 0x0,
    0xbfe81cae46594578, 0x0,
    0xbfd6f800968f8667, 0x0,
    0x3f7be1cc863098dd, 0x0,
    0x3fe0552f6453c2af, 0x0,
    0x3fe4508676195b65, 0x0,
    0x3fdecbc089d30712, 0x0,
    0xbfa66c34b76b953f, 0x0,
    0xbfdd46c64243a21a, 0x0,
    0xbfe586ce4189eed2, 0x0,
    0xbfe121a20924bf87, 0x0,
    0x3fb38b197b57a718, 0x0,
    0x3fdd6e988a3e1a52, 0x0,
    0x3fe795c10ba528a7, 0x0,
    0x3fe02a41dabebce9, 0x0,
    0xbfc1281f8b3ef3e8, 0x0,
    0xbfd9f3453798ca82, 0x0,
    0xbfe6bfdc5658b4fb, 0x0,
    0xbfdd504893a17611, 0x0,
    0xbf95c0518e8fb751, 0x0,
    0x3fe1505f041e4f66, 0x0,
    0x3fe6ac4b8fe72a39, 0x0,
    0x3fdde4f818d9b00d, 0x0,
    0x3f9422e8bd8cbaa5, 0x0,
    0xbfe1e7bd3d969797, 0x0,
    0xbfe7c254a4011cad, 0x0,
    0xbfdc825e2658a6a3, 0x0,
    0x3fa75371512ad1a0, 0x0,
    0x3fe08d41dee44425, 0x0,
    0x3fe8dd7aac020b76, 0x0,
    0x3fdf735f402ce663, 0x0,
    0xbfa9f05bda0a06af, 0x0,
    0xbfd921aac4378edc, 0x0,
    0xbfe458e1dc6c008e, 0x0,
    0xbfe2ae2c028daf62, 0x0,
    0x3fb32080f6bdd4c3, 0x0,
    0x3fe125a3cda034b1, 0x0,
    0x3fe6efd9120526ca, 0x0,
    0x3fe05ae78ad0105e, 0x0,
    0x3fb052f7225bafc4, 0x0,
    0xbfdb373d16dd0e69, 0x0,
    0xbfe534acf0438bc3, 0x0,
    0xbfd91d8497e84c2c, 0x0,
    0x3f92d997f84988c6, 0x0,
    0x3fdeff208b8a44fb, 0x0,
    0x3fe63984972afa69, 0x0,
    0x3fddd4fb480311ea, 0x0,
    0xbfb3530c71d29115, 0x0,
    0xbfd962c416309dfd, 0x0,
    0xbfe6b45ee8900436, 0x0,
    0xbfe1202ea07e07a3, 0x0,
    0x3faf59173617abc7, 0x0,
    0x3fe1b64334ba6e28, 0x0,
    0x3fe308fdb7fbce3a, 0x0,
    0x3fdd564f6c942315, 0x0,
    0x3fa68f71f11f811c, 0x0,
    0xbfdb06e9db9c7cec, 0x0,
    0xbfe62f009c62d940, 0x0,
    0xbfde337970ef99e8, 0x0,
    0x3fa898d19374e163, 0x0,
    0x3fdd27498baf1b49, 0x0,
    0x3fe804190918173d, 0x0,
    0x3fde33dc6248f7fe, 0x0,
    0xbf9fb68a099d3534, 0x0,
    0xbfe07788455a8dd2, 0x0,
    0xbfe50312b3bee085, 0x0,
    0xbfe01eca7ddbf569, 0x0,
    0x3f81d582ffa853c1, 0x0,
    0x3fe2138590d606fe, 0x0,
    0x3fe5f51ff638f2bb, 0x0,
    0x3fe13a7097ef6d7e, 0x0,
    0x3fb484b1ac4ee27e, 0x0,
    0xbfdeba761d7f5afb, 0x0,
    0xbfe4a38dd5c98ba4, 0x0,
    0xbfe2343eb46f2330, 0x0,
    0xbf97eab25075ceed, 0x0,
    0x3fdbf0030fe977c2, 0x0,
    0x3fe5f19b7fde3c6a, 0x0,
    0x3fddbfb963add9d9, 0x0,
    0x3f8cf336e02f9ec5, 0x0,
    0xbfddbc2b19f3409a, 0x0,
    0xbfe6694cb70482c1, 0x0,
    0xbfe28b26213e3b47, 0x0,
    0xbf7234890873edc6, 0x0,
    0x3fdd2e50da4bc64c, 0x0,
    0x3fe752d2fdc35e97, 0x0,
    0x3fdce6ee3d5af268, 0x0,
    0x3fa16f780edab4b7, 0x0,
    0xbfe1b9fcacb994bc, 0x0,
    0xbfe71d9f33d08006, 0x0,
    0xbfdbd1b1e8707bfa, 0x0,
    0x3f7053acef4835df, 0x0,
    0x3fe0e65f35f21bc2, 0x0,
    0x3fe5494c0852ead0, 0x0,
    0x3fe14d6b5924d95a, 0x0,
    0x3f9a56a3409e50f2, 0x0,
    0xbfe0522acf0fd1dc, 0x0,
    0xbfe5aab3805cd890, 0x0,
    0xbfe0641c0925a131, 0x0,
    0xbfa8fec531df5097, 0x0,
    0x3fdcb9e024b9b2ca, 0x0,
    0x3fe4dd3f3c2d8f97, 0x0,
    0x3fe1cd602d4f23e0, 0x0,
    0xbf9a86e61e8675db, 0x0,
    0xbfe062a368f9e943, 0x0,
    0xbfe6cf969ca97915, 0x0,
    0xbfdc93763e126bb3, 0x0
    };

static const uint64_t in_cifft_noisy_4096[8192] = {
    0x4010785baf69d0c4, 0x0,
    0x40046255f53cf243, 0xc01930a0be8be4f8,
    0x3ffc97b4c0741cc0, 0x400ca32f3104f35e,
    0x3ffc7a4073ddee2d, 0x4003424a8d478d6b,
    0xc00b0ed4b8440794, 0x400b910f67a09806,
    0xbfe5feab65054ace, 0x3fef8e8fdfc6f8a1,
    0x3fb9c8fcff9009d8, 0x400ccaf2bee083ee,
    0xbffd0dc71e50abf6, 0x3fb3cb5d1a81bdf0,
    0x400bf0ccd7777920, 0xbfd47b881979e798,
    0xbff4f24e69d31196, 0xc00723c9478f1088,
    0xc010fdbf5376bd33, 0x4001fa8b897ae7cd,
    0x3fed6319624165bc, 0xbff7990e8bf26d6f,
    0x3ffee2b9f82ff11f, 0x3fe7cfd762db16d1,
    0x3fe23e87be1114ee, 0x3fe32c00ac7424d2,
    0xbff40c5ee71dc0d0, 0x400f96d037fa9af6,
    0x3ff292fae6ddf4ac, 0x3fdb6dc4802c563c,
    0xbffca36883cf9be4, 0x401495b568ebedd0,
    0x3fd6ea6c34327b84, 0xc0065c608db61b26,
    0x400269fdd91164b9, 0x3fc5749783f0ed04,
    0xbfd00ba7a0b26a38, 0x400275fdd1d6095e,
    0x4009986f7eb6c3f2, 0xbfcb17390540ef92,
    0xbfeb22c0df754146, 0xc0020d07af281d6f,
    0xbffef20b7e8a414a, 0xbfe9d7251a122d37,
    0xbfe30cac63aa522a, 0xc00fb3dea14cab55,
    0xbff51514d2fe847b, 0x4002309301d8e5bb,
    0x400945c1aaedd73e, 0xc010ee7f3d5d5a32,
    0xbff1c8e948fca4e8, 0x4012d2e7f3cf92ce,
    0xc016c63d97845bc2, 0x4015accdb1d0325a,
    0x3f98c30659d83ac0, 0x400400f66cf10328,
    0x3ff381e5739ed4af, 0x400939ae765620b9,
    0xbfe3825cc8b95919, 0x3fe3c2c55a4a2708,
    0xbff58715cd470558, 0xc005ed5b03ae3f4c,
    0xc006dfababf5b770, 0xbfca5d032f39fea8,
    0x3ff7876ccc95e341, 0xc0014001ddaea81e,
    0x3ff3ded438516464, 0x3ffe27efb8be6b3f,
    0xbf807f81773e5d80, 0x3ff1a12849db76ca,
    0xc0023ea534e38498, 0x3ff8cc63f4cf014a,
    0x3feb800b892e6fac, 0xc012aa57abddfb2c,
    0x3ffd9c58eae263ed, 0x400bda162fd88f26,
    0x3ff6e2573a53fef2, 0xc00fb994d81b1516,
    0xc01766492f5ffb20, 0xc0034bf331e255f2,
    0xc0096fe0c36f80f4, 0xc0186b9536936d2c,
    0x400cf674724e6ed6, 0xc003f292e97430cc,
    0xbf99ac84c7b1f480, 0xbff7c4c23d0eb581,
    0xbfef3f9f9d1d1c7d, 0xc00910a39479e459,
    0x3fcb00ffa4806150, 0x4014291f5bbe608d,
    0xbff5d9c80f2f8759, 0xbfed53df049f08b8,
    0x400e8ca96015e48a, 0xbffba46b83d2bc46,
    0x4004567e89eca3e2, 0x3ff8aa5e39e1d3ae,
    0xc00c6b4efaf9aa21, 0x3ff2b3b79c793850,
    0x3ff77b6e2a9aa2ba, 0x3f994115be505480,
    0x3fe6e2f7b334ab9c, 0x3fe1a4c6cd124dd1,
    0xbffa20461ec9fa8a, 0x3fcc2fd912ab7538,
    0xbfe50361fef74a1c, 0xc0087070f667c19b,
    0xbff359f03a9b28a8, 0x3ff7c45b05eabebb,
    0xbfe446e4523726e2, 0xc00215ed0b75dd68,
    0x3ffaf8b5b7087110, 0x3fe7b2a3186cca4a,
    0x3ff5af54e4434fe3, 0x3fe579f64a6e7f69,
    0x3fd1d84afa1b7839, 0xbfaedab2aad624e0,
    0x3feea58d31ab4c32, 0xbfe8c2a16e066c8e,
    0x3ff4c84f3aa56650, 0x3fbdc979f0097c00,
    0x3f9bbdbbe757f280, 0x3ff0a209987bb96f,
    0xbff365db800dcc40, 0x400f7e8219ec3138,
    0x3ffe2565b1b4a0cd, 0xc0065d8c20baad94,
    0xc009b59423ce0024, 0xc009c3fc48369198,
    0x400a69a9e4179e6f, 0x4001480187caa05f,
    0xbfdf634b924004ae, 0x3fc83229d525b820,
    0x3ff23b089049ae26, 0xc0035177916454b4,
    0xbfee3a33adfd0cef, 0x40105003440680e6,
    0x40023c4ccbb1ab68, 0x40051aaa6e46bb3f,
    0xbffe529da585e474, 0xbff915415e729184,
    0x3ff0e9407cec298b, 0x3fe385deec1a05e8,
    0x40066b904417ebf1, 0x4011bfc1318c6270,
    0xc00e4e1b43b0f0c3, 0xbfe360753aba410b,
    0x4012e1ca141830af, 0x3ff878dee6a18cc7,
    0x4004bb18881628d1, 0x3fe9658d4b93c05e,
    0x3ffc44e5c30cb8af, 0xbff7eab70e4f9eeb,
    0x3feb5058334ab814, 0xbfebf83ad1085cb8,
    0x40109c9ef6dbbc83, 0xc010ba37865b4a70,
    0x3fea34bd553109a0, 0x3ff76eaec1d30e80,
    0x400327cb80f12172, 0xbff4d16152e8d04a,
    0xbff39e51b0dc1ce4, 0x4001f65a1cb5d25a,
    0xc000fd39fc5dc97c, 0xbfc3702bb5ebb1ac,
    0x3fe250b56bc398db, 0xc011cc123fa12ce7,
    0xbfe1db78c6bab4e3, 0xc006949b17458cf1,
    0x40079ab887fdcff9, 0xbffa055798df968a,
    0xc00fc3c71c17e2b9, 0x400043ce0b683a45,
    0xc00d450a869d0a6e, 0xc015228170af3d60,
    0xc010edd5011bcf46, 0xbff3b2e5e33c3fd7,
    0x40051b9cce96c240, 0x4000c72b188312ad,
    0x3ff2cb64c7d9f4ec, 0x3ff4c2568725e41f,
    0x3fe0bb801c63914b, 0x3fd3b1d66dfbab84,
    0x3fe9b1ed21dbfa84, 0xc00478a404b8a100,
    0xbfe30c8eaf0d5af9, 0x400d9194df9c50b7,
    0x3ffc7020595310da, 0x3fe456dff3a41057,
    0xc007306bf45e3f80, 0xbfd58a56a5972e08,
    0xc015f577bedecb9e, 0x3fd829cb3c5d71c6,
    0x4000114719323f84, 0xbfaaea385332c540,
    0x3fe225c101eb28da, 0xbfe12e8554a737fe,
    0x3ff1ce68f5c01ce8, 0x4010f4149b44d2ea,
    0xbfeaf052a3645c20, 0x3ffd3cd80fc8e31e,
    0x3fea10f153eb2998, 0xbfe8ad42aca27c5e,
    0x3ff05f19348c3653, 0xc005db43ad2677cb,
    0x3fde0c5793572d08, 0x3fc699f3ce90da98,
    0x40049fc023866e8c, 0xbfe3864f0bfde450,
    0x3feaff65d42e9560, 0x3fe9699e868eec3a,
    0x40005ffb43bff2f4, 0xbf8b360b41dab180,
    0xc003aa15ff451165, 0xc01160ce4c626671,
    0x4009e9306719d612, 0xbfe5c801fbdbdffc,
    0x4002dfcb89315df6, 0xbfeb3dc2cc9d85ac,
    0xbff7171736a5558f, 0xbfed97190d490b9c,
    0x3ff7286d2b035b7f, 0x3fde4971f8e32c18,
    0x3feba176805d1e54, 0xbfe8274b47efbe9c,
    0xbffe2e429b68ea64, 0xc00903d0e026a0b2,
    0x3ffb33e4276a7239, 0xbfbfd9dd29a6cba0,
    0xc00212d02b1341ee, 0x40159b791361108a,
    0xc0042b9a590f4419, 0x3fe8d3480e74c448,
    0x40166be21eb45a8a, 0xc009b22da86f4cc3,
    0x40012812c0e9b480, 0x3fcc0b3ac63b1514,
    0xbfed86f25664e7fc, 0xbfe06bb5598da22c,
    0x3fffde1207f8752a, 0x4013c0780a55b0e2,
    0x3ffa9890c9f62176, 0x4003b993d5b6c102,
    0xbfcb47949252ab16, 0xc015c49db8827504,
    0xbff3e98d00fa1b6c, 0x3fa0bde650f86b08,
    0xc0120eb90d35b9aa, 0x4000074eeae92cbd,
    0x4004265eeb79d0ee, 0xbfffbcf716738ec8,
    0x4000048c83ce0fce, 0xbffb4227761516b4,
    0xbfe12e99f7a24d64, 0xbfd755b3a0198bb6,
    0x3fe36e3163c94072, 0x4012f2b75b31bdee,
    0xbffc444eb038851a, 0xbfdb06e64b33d174,
    0xc017ed474ca79642, 0x3ff80f0409568354,
    0xbff0edc516762ea6, 0xbffcc1d8eb33b502,
    0xbffe7c802be22388, 0x3ff63c5c5b6aa374,
    0x3fdb221270d7bd97, 0xbfe423362c6fcc2c,
    0xc0002020fb73e532, 0x400d3578423da0b0,
    0xbfc23d659445d0fa, 0xbfaedb326cc5f7a0,
    0xbff19068f77d9b5c, 0x400cf68071a91718,
    0x3ff5b4707ac8228b, 0xbfce00506f6fa674,
    0x3fe0d8d212aefc72, 0x3fe4b7cccaef3de2,
    0x3fd317a555ad8a2a, 0xbfce772556423cc0,
    0x3ff0eae66cea359c, 0x4013b17aef8cac29,
    0x3fcdcac60cad17c0, 0xbffc4d29c21d6910,
    0x400b36b76e7dfa35, 0xbff5f6e249c3f29e,
    0x3fc8ccdd187651a0, 0xc005fd42f4078fa5,
    0xc0100d78dbe6637e, 0xc008395c2e2bf67a,
    0x3fd0fee8f1b7b4ca, 0x40088339e2b3c37c,
    0xc000a5394d33a3d5, 0x3ffa5d4ec18397d7,
    0x3fdbcaddbd2f8ea4, 0x400d32539ec13a6f,
    0xbfe383a5cb174128, 0x3fe6aed6c751cd4c,
    0xbff71b3cbcf4669a, 0xc00078a875173f7a,
    0xc0198ec309be8577, 0xbff2a9eb23c64f18,
    0xc0079283227c9796, 0x40064230b96c399a,
    0x3ff8319d3c6d57ca, 0x3fe8085ec9ecefe4,
    0xbff10c129af08956, 0xbfb54b1c3b3fa700,
    0x3ffae273c57f0488, 0xbff63953b5e855fa,
    0x3fdabc27587c0878, 0x4006a49ce0ad4dfc,
    0xbfa94b8c07ddede0, 0x400820cbb4579d47,
    0x4003029acf6addfc, 0xbfe9619e20df2c72,
    0x40119630f6862175, 0x400b46d88667cc09,
    0x3ffd0d1881ab2976, 0xc005cea6b3419d7e,
    0x4003f8f9ef70bf11, 0xc00c541f45281595,
    0xbff0c8297b9359a4, 0xbfde0ada26a61539,
    0x40041e75fe3e2aa6, 0xbfc010fb767013f1,
    0x3ff53e6914dfcce6, 0xbfe598392ff6edac,
    0xbfd52dd2615e0336, 0xbfdeceeff4be7d99,
    0xc00ab17e2493b2eb, 0xc012eecb31abc9a8,
    0xbffd8193e6883af1, 0x40061118df0542ff,
    0x3fc19c6c613a91cc, 0x3faf262221cb9c40,
    0x400c0effb7d6a36e, 0xbfb8728a5e09f878,
    0x4001c8aa2ba011ef, 0xbfd0819b7551ac42,
    0x40163d953c222264, 0x3fdd9340e009f37d,
    0xbffe33f444623c80, 0xc0009ff8e6a602dd,
    0xbff07144a2abfde7, 0x3feeac6560b8417c,
    0x3fff6095dd3445fa, 0xc01ee96eb814d927,
    0xbfd58f59a929eaf8, 0x3fe59dc98c8a7c8d,
    0x3ff29004c19cd184, 0xc00341617de4f342,
    0xc00330701b484f60, 0x3fc3fd8f89a734a0,
    0x3fd89c6d21770738, 0xc00d82f60e3b0c9e,
    0xc009758e8dea8922, 0xbffbd54867e54b7c,
    0xc0062c3f010eba98, 0x400d56c856cb8258,
    0xbfe96e8c3c15a36d, 0xbff821e12db58a70,
    0x400322292071aa00, 0x3fe10da0de7e53b1,
    0x3ff5ae4de3e2b810, 0xbff59da19feb2652,
    0xbfef8863ff902504, 0x4010e1004fb842ae,
    0x3ffb9a7e441d1800, 0xc001f1115be2a4a9,
    0x4007ccf8305916ff, 0x3ff37e039a5f74e8,
    0x4003a060a38049b4, 0x3ff4347474e0ec5e,
    0xbff8dbce09545864, 0xc0097c6f08783dc1,
    0x400201b912f3ad1d, 0x3ffea688ee401931,
    0xc00843f6b0257273, 0xc003c32013775b7c,
    0xbfb28a920a2d0890, 0xbff7dc8e3f6cc11e,
    0xc0021e3e48b4c7c8, 0xbff2f93b1fea58ec,
    0x3ffdcde0b670e6d6, 0xc00cc1308628c502,
    0xc002c8d45443a9e3, 0xc002f22fb01403d4,
    0xbff3e170b9920df6, 0x3ff78d259809f498,
    0xbffe8e7ef6d30d96, 0x3fd66c3424c91a4c,
    0x4007a1667fe85b35, 0xc0045f309a6b3a58,
    0x40061bbd5a4d8594, 0x3ff70cc2479f49de,
    0xc0046f2dc0bd0380, 0x400458dab80f25bf,
    0x3ffa38f4cbdc14b0, 0xc0095f2969854bc6,
    0x3ffee90c5ad62cc9, 0x3ff536cbe0a5115a,
    0x40058d77468cc3a2, 0x400389526ea15af8,
    0xbff0b571c0724e36, 0xbff19f6a33e9ec0c,
    0xc006fe88e762e548, 0x3ff9999e07f09acc,
    0xc004b67f90dda016, 0x400537b34810980d,
    0xbfee5e262fb17324, 0xbffc38589806b676,
    0x3ffe8e3c764fe5bb, 0xbfc216d97dc43e04,
    0xbffdc448b04c4f35, 0xbff60902652bd3cd,
    0x4016579e10ddff56, 0xc009fd2eb595abb4,
    0xbfd46c307f3164b4, 0xbffef485a2a65c50,
    0xc0097d513774a032, 0xc0092a0d09935edf,
    0xbff8f6287f0ea386, 0xbfe018a779f1d670,
    0x3ff626b41671838c, 0xbfd0af418b9ecb9e,
    0x4005d1dd90058960, 0xbfec76b43ff1292c,
    0xbfea0809fee9bcda, 0x3fe867f16782fd92,
    0x3fff0968aa4d2a42, 0x40017376823e94c0,
    0xc005de8ec83d327a, 0xc0067e90be4f821a,
    0xc00261c3805973ec, 0x401031323380cdc2,
    0xc002673d88463af8, 0x3ff513de46e30908,
    0x4009c45509cfac04, 0x3fb076b690f7a940,
    0x4000f8e9160f1c7a, 0xc010fe5e7c8d8cb2,
    0x4000ce23d281ca36, 0xbff44d681affe7c0,
    0x3fd39cc9f1b87938, 0x3fe4dfbefd1bb401,
    0xc0011183d32b7efb, 0xc01abb09f933328d,
    0xbfec244290b33c62, 0x4005a91d4379a564,
    0x3ff1790a89483d1c, 0xbff2a9fc4e89449b,
    0xbfe6f06315fdae6d, 0xc00117f1ebff2bec,
    0xbfea57a50834e2c3, 0x40088d9cadb7026a,
    0x3fe336e574526b8a, 0xbfd6dd2a8be2f024,
    0x4011dfc706ab6ca2, 0xbfe39ed90603fbe4,
    0x3ff08f65bd8fdcb0, 0x4008ff6b6fe25a97,
    0x40012c6a9330cbb2, 0x3fe26613be4f8689,
    0xc006c98b5a7ca28c, 0x3fe47a91da0a6a5e,
    0xc0061f6c4cb9f7ae, 0xbffdbd6850201b50,
    0x40173b0f785ad372, 0xbff0daa814ac093a,
    0xbfe4b91bd949162b, 0xc0008c771adcf1e2,
    0x40001cf9856eca7b, 0xbfc8587d2effd2ee,
    0xbfd801f386cb3a3a, 0x4004490f1f5716a4,
    0x3fdcaa49bca7bdb5, 0x3fe3e296f1cfc920,
    0x3fd905883aa2328c, 0x400aa963b9c03297,
    0xbfe8a38d629fdc14, 0xbff92a0b37f5613e,
    0xbfcaa78e5cbc14aa, 0xc013780f5afbd624,
    0x3ffe7c52b4c96894, 0xc00def94814ce26c,
    0xc00167c55cb8bcac, 0x4016c23ffa5e36ec,
    0x4006324d8db1c74c, 0x3fd47802cafba692,
    0x3fd72b36ee1d21f2, 0x3fcfb0d0800bf890,
    0x4003f0bd2fd383fa, 0x3fd3866604bc43c8,
    0x3fde1c2098ac2f4c, 0x400c3148bc606aa6,
    0x3fc4938e5a130660, 0x3ff936ac93ac1e6b,
    0xbfd770a5e9c78240, 0xbff7252403f012b4,
    0xbfe4803b3bc897be, 0xbffb20c323e8a38a,
    0xbfe087611a01c9ac, 0x3fedd55f0ac0414c,
    0x3ff4ec102724c0bc, 0x400231e519c78820,
    0x400eaf82fd23443a, 0xbff46bdeb2871544,
    0x3ffaefa185763943, 0xbff106cf3c1f854e,
    0x4004b79e51a595a4, 0x3fdb5c977a48714c,
    0xbff1c7829b4c93c3, 0xc00240b37c6fb5ff,
    0xbff9ae8959ec4bdc, 0xbff97d1420539168,
    0x3ff9ca42e65b1cee, 0xbfd9aa588be0f758,
    0x3ffc7f283c7d67e7, 0xbfea412063235e88,
    0xc0003b5fc7a5c122, 0x4003bfce5e95a833,
    0x3fd3cdf896778908, 0xbfa493e0dca716b8,
    0xc00977dadd9b9d42, 0x40068236916c074f,
    0x3fd78f9cfdf04fc6, 0xc006f82d6f7dbdff,
    0x3feab3c9659add30, 0x3fbe134c322b82e8,
    0x4001f14c5488d56c, 0xbfd740985c544d80,
    0xbffac92d43dec51a, 0xbfc18c0d35e2da24,
    0xc00e2c7106d4078b, 0xc0064fffd151a21b,
    0xbfe789abb79e96fe, 0xc004f8ee6cc24775,
    0xbff58bf147f8e88c, 0x3ff222b592fa140e,
    0xbfef608990140868, 0x3fec2b9eae0e84f5,
    0x3fe88f0c7703ed49, 0x3ff977170c027f6e,
    0x40036b96c79f097e, 0xbfeef3bfd1bdaa66,
    0x40047c38923c6c96, 0x3ffbe91618d6940b,
    0xbfed35151bfbd8d4, 0x4013201680b253bc,
    0xc001e8a7333f2c28, 0xbfe1aec627e58a20,
    0xbfe4f3c5a1c004f4, 0x4003bfe233ca5ac6,
    0x3ff63f5e87d5615c, 0xc000193d1fb76193,
    0xbffd7b6ae8778ff0, 0x4014b3bc0d0b30a6,
    0xc0013cec5ee05967, 0xbfe6c51f49cec7e3,
    0xc003a076e661816c, 0xbfd31e446e273858,
    0x40190fb61c0a8919, 0xc00968c2f8f0525e,
    0xc01005c05d1d0b13, 0x3ffa4bec157f2193,
    0x3fe5167e0f020628, 0xbffb80ed925a72be,
    0xc011005ad0dc664d, 0xbfe0212b9eda09c1,
    0x4003ba1492b15d7a, 0xbfe52b3dc4356e4e,
    0x3fff93c8887957e6, 0x3fbbda694204f410,
    0x3ff356c19caa9a1e, 0x40037b613f8bccf6,
    0x3feafa16f841b82c, 0x3fff4f1a62fd03a1,
    0x3fedb18ebc811d9f, 0xbfe3417c23871f04,
    0x3ff38e646f8f788e, 0x4011955e8e79c784,
    0x400692e6f8e79098, 0x3fec30ce6142811c,
    0xc011ebe00bfbcec6, 0x4006b132c443a135,
    0x3ff330c40bfe68ad, 0xbff28e8617d6bcee,
    0x3fe046c773e33008, 0xc002fb0b68224bce,
    0x3fd7b443d2542f9c, 0xc007402d62cd4f6c,
    0x3feda6e4faec3e66, 0x3ff2f0d18e4d0210,
    0x40038f0662b551e6, 0xc00a8070b70792c4,
    0x3fd195df779dbf90, 0x3ff933b525a791d7,
    0x3fb2852f2c3882d0, 0xc00140c5e523c58e,
    0x40006be728c073fb, 0xc0007b7d28a4345d,
    0x400997bea42fd30b, 0xbffe3cf457885460,
    0xbfe6c41ff26f0884, 0xc00b39b65d52596d,
    0xbfe87cbd440f55ec, 0x3fe0cd8f0c7b85c0,
    0x400d33ea9dff9509, 0xc00bf57fd9e52ac6,
    0xbff8fdc81aecfa36, 0xbff444da6bf2491a,
    0xc011a698c7017eea, 0xc01508b11a5e5d24,
    0xbfe4cac75f752dc9, 0xc011ea11fc632528,
    0x400ca15e2bd95068, 0x3febee742f526ca2,
    0x40119202722355db, 0xbfa312037004d2c0,
    0x3ff8392d23c75fd0, 0x3ffd53c402422a0d,
    0x4010326ffc92f3ce, 0xbfeed7ad85ca9a00,
    0x3f8eac2323a07cc0, 0x400479861ca0d828,
    0x3fcbaec0442cd816, 0x3ff6ec0f5926f6db,
    0xc00212a436510d33, 0xc00a77acb8d287a2,
    0x3ff481fcd679df28, 0x4011d44e8dd3a1ac,
    0xbff1ae232bbf5c74, 0x4015d4c9c515afc5,
    0x4005fc09c52e3999, 0x4010ff37241e0a0c,
    0xbff24f7579883592, 0x3fef730b119f44ba,
    0x4002e6a2dd03a3d6, 0xbfb0f5cb1330d8e0,
    0xbfc0bdc090d37998, 0x40073b35e6218234,
    0x3fe7a650ca67c79a, 0xc00982ec50fc8f07,
    0x4009bd46bf9db1e8, 0xbfd30aca7faff17c,
    0x400678a8033fa27e, 0x3fcd6b7500058550,
    0xbffb53ba2b05133c, 0xc0082bab32be21fc,
    0x4000df395fd904f0, 0x3ff6cf418302d532,
    0x3fbb62a7922b5540, 0x3fe2edbfb6237cca,
    0x3ff819fb4be7c7f8, 0xc00978091eadace8,
    0xbfe5bb36fc0790d8, 0x3fd4671182f9377a,
    0x4009683546e19da2, 0xbff93f7227506d0c,
    0xbffba680bf4ec58d, 0xc0053a10f1605e19,
    0xbff7aaa87f7d2702, 0xbfef250e29617619,
    0xbff6b369418a3a90, 0x3fca783daada8588,
    0x400e769736e5a6cc, 0xc0043526c48de0de,
    0x3fe2574d1e9d4a86, 0xc016a609ca6f7eb0,
    0x3fef2d27b9768cd1, 0x3ff0bfd3be35e284,
    0xbf8f53e1a5344e80, 0xbff3621bead582ab,
    0x4019303cd1385f96, 0x40006681b2cae479,
    0x3fc45d1c3b7f03ec, 0xc0058fb7ec566b5e,
    0x4015c689afa7153e, 0x4015d49c23662d69,
    0xc006246d32bd3302, 0xbf92719f6e48b6c0,
    0xbff9fe6f41333835, 0xbfe313b4b8a903ee,
    0x3ff689ae1ca2e136, 0xbff9bac30f6bfe90,
    0x400bbd6c2db699a8, 0x3fe29c990c40c860,
    0xc014534bc163588d, 0x3fcdc29343c74068,
    0xbff9789c7becf076, 0x3ffe887a4eadb5be,
    0x3fc34f6f8a1c2e98, 0x3fd7eaaea12de1ca,
    0x4009311f7674bfd2, 0xc0039f85e1086a32,
    0xc00d77fc49666c7c, 0xbff37693ded78cc2,
    0xc00fcfb02d3cb358, 0x3fd3cd894f2dc660,
    0x3ff8b2bf5bef5361, 0x3ff72ec004e280ee,
    0x3ff1113b3d6f28bc, 0x3fed78e1f4f03cb2,
    0xbffa08c253c53852, 0xbfecfc8e1deef8c0,
    0x3fe8290dd46e3f80, 0xc005e7027b1e8e7a,
    0xc011dad7604e8de0, 0xbffe21d4c40813a2,
    0xbffa1e26516ff036, 0xbfb77da55f40b630,
    0xbfd6a219d029fee4, 0x3ff42262b9bf7cb0,
    0x3ffb019ec54960bf, 0x3fe7deb707d169be,
    0xc01377854e5901bc, 0x3fe2c81b8735ae63,
    0x4003bba9fc43e7da, 0xbfede6b11e4e0730,
    0xbff9f08c10ba39cd, 0xc0041a3309d1d3b2,
    0x3fd67138ff4a9608, 0x4003e4725b72f23c,
    0x40084f15e06df424, 0xc00a1bcd3210c098,
    0xc004deed6d42327a, 0xbff74d1611d69194,
    0x3fdf1e251e5541a0, 0x400978205d6e0e9a,
    0x3fd0b9c210f6aee6, 0xbff23106de28e127,
    0x3fffcdf13670d9de, 0xbff00a4984e5b472,
    0xc00bf8feff3a6fc6, 0xbfeb3363da45b27b,
    0x3fdd64d22a7c8bf0, 0xbfc54f96a16ed66c,
    0x3ffc84fbb353c381, 0x3ffc2eb750dc70ba,
    0x3fe1b4453d4f0530, 0x401021db778f2459,
    0x3fb414851fb9b24c, 0xbffe0725e7d062e2,
    0xbfdc899c4d0934e5, 0xbf7f800c0be58700,
    0x3fb37ad79cd1c214, 0x3fe7f0b53852ffa4,
    0xbfce09f0ade800e0, 0x3ff55219d8f15854,
    0xbfecfab4b2b46c0c, 0x4005d073925cf1e0,
    0x400361251a2e771a, 0x3fd03531a19abee0,
    0x3fec88dc8b79a7b5, 0x3ff57080e228ade1,
    0xc00f111e3548bc60, 0xc0018b19890e9ca8,
    0xc00221b93e151a13, 0x40074400b067f8c2,
    0xc01b8188340bd888, 0xbf58bba849769800,
    0xc000130607fb29a3, 0x3ff3b124c7f517f4,
    0xbff9240e25a3d70b, 0x40014af734b412f8,
    0xbfb6d1661c509128, 0x3ff4b364b0ff58b0,
    0x400b26fdf78b41c9, 0x3feb1e5f4d24a3c0,
    0xc004090ed35a6f98, 0xbfcba547823a681c,
    0x40107654f588b349, 0x400290993b7e7507,
    0xbfae9c65235cb160, 0xbffd26d15585cba0,
    0xbfde95ed168d8421, 0x400f7479853a0936,
    0xbfeeebe792dc5baf, 0x4013d46a62ced142,
    0xc011659e08931046, 0xc009c459480b37eb,
    0x4004aa00b3daa7fd, 0xbffa2f1bb8bc0e04,
    0x400177d9190dbe0b, 0xc0158b128de79760,
    0x3ffc4242356b01dc, 0xc01479c11897701e,
    0xbfe33f59979dbcf8, 0x4005b6e0e22b505e,
    0x3ff44bacc539ba1e, 0xbfdff48449dd2b28,
    0xbff3dfc3a3c2eeeb, 0x400bf6f4ea3a5bcb,
    0x3ff148cf67c3c9ab, 0xc000564f5c0815d7,
    0xc003d25d2c64268c, 0x4006b9843e43ee50,
    0xbfffe1b16d4d59f1, 0xbfdac14ea450079c,
    0xbfeb300fc3f29f96, 0xbfde9fe9832c5a08,
    0xbff50367d0e83e25, 0xbff6dbe91f31b8f8,
    0xc015985cb0c254d4, 0x3ffe1238be75fece,
    0x4007b56a9fa3eabb, 0xbfc5964cefee3178,
    0x3fc3678ec639dd24, 0xc008468352313f91,
    0x3fe8d8989a47b4b2, 0x3f8d18357cb92e80,
    0xc0007ba318be5d5e, 0x3ff3dc756e20b7f8,
    0x3ff4a06986b780ec, 0x3ff05bccaa8b86e6,
    0x4005d0cdb0ad4ff5, 0x3ff403d17469a816,
    0xc007131f4ea2f593, 0xbff4f58b4eac50e2,
    0xbfe08aa7f2c7d321, 0xc012119c7e4c2977,
    0xc0010bec1ae8910b, 0xbffe07e39d2d9e12,
    0xbff57f3cbe3bae74, 0x3ffb2b0855dbf34a,
    0xbff1290a91c57810, 0xc00c6e72d9b4c486,
    0x400a0be9a8ada04d, 0x3fa8bbe2af5a4250,
    0xbfff12c6e1ec56a9, 0x3fd6006e98674822,
    0xc00cb0459dd8f9f6, 0xbfbceaf46ca5e970,
    0x3ffc192eaad0c955, 0xbfee531bdd3b1f58,
    0xbfe33a72878f26a0, 0xbfe69aa4ccc03804,
    0x3fff03811c762f1e, 0xc0018d77fe08d808,
    0xbff56771c04e887c, 0x3ff7a1aa51c3c7b9,
    0x401056ab2a6fb5e0, 0xbff259e0f6bc9a36,
    0x3fed49c82fca34f6, 0x3ff8837811efb5ba,
    0x3ffa8d84ee24d82e, 0x3fe29cdfbb5d3988,
    0x40084eb9db9770d6, 0xbff08ac0a946cba6,
    0x400be5b601b2dc79, 0x3ff5c6ed2fb7c8fe,
    0x3f7cc4fd0e133800, 0x3fea478b6a2063a4,
    0x400e9c21fd068850, 0x3ff9b5ae34685593,
    0xc002db4b8b8dfb4a, 0xc010f95d83c54e90,
    0x3f7c5f7932e2cd00, 0xc010ed2e98915bda,
    0xc0038628583c537b, 0xc001c7b4ea2bbce5,
    0xbff7c65a5f26ef33, 0x401406275c86992c,
    0x3fefd15a4ed8c9c0, 0xbff9618304ca014e,
    0x3fbed0d0269b92c0, 0x3ff13ad3d7578b71,
    0x3fdf0b9ab61ad670, 0xbfe7773086c5d10a,
    0x3ff35fbec069d644, 0x40045b810908710f,
    0xbfe19cf02a65c8b3, 0x3ff51fd330334033,
    0xbff139ea6e9bb98b, 0x3ff5bc4610994144,
    0xbfe890f6d6671380, 0x4005cbf028b0d971,
    0xbff0bd4b32142b0c, 0xbf7ae2f1cd533000,
    0xc008f2c5fbd4045c, 0x3ff0cae02f3c4d40,
    0x40018e4d24c46bca, 0xbfd8dfea0ab34c98,
    0x3fe0a94e408380a7, 0xc00f9a41f1b0e53c,
    0x4005553c26a462f6, 0x3fc6cb638f9213d8,
    0xc003d0de740868aa, 0x4005ff5c629dfbe3,
    0xbfdfc19f4de1b9a8, 0x3fe1ccba51c07fa0,
    0xbfe24c267570ea10, 0x3fed416ed66479c0,
    0xbfeb24fd1a9f78e8, 0x3fd2a10a1ead0d30,
    0x3ff1eb335db63fe7, 0x3fe123a3d5a03306,
    0x3fc1eae7b93daea8, 0x3ff29c1d7bfdc8d2,
    0xc0098417ab5d0dcd, 0xc00c57fd58e3c49c,
    0xc00f70198b03008a, 0xc00cc9a9a36be61b,
    0x3fdbd2c539fc6d0c, 0x3fdfb3ff6a1ed558,
    0xbfd5953849d2f570, 0x3fe496fa18f241d0,
    0xbfdf3572887e45b8, 0xbfbd24d3526de1e8,
    0x40014093718a38e6, 0x40043aa99dd182e1,
    0xc0031c131a05abf5, 0x401846b5b0acee2d,
    0xbfc5136198536c50, 0xbfe573656b7c54c4,
    0xc0118de683b948dc, 0xc009be6cc9e9b497,
    0x4008a411881bf5d2, 0x401a9a48a7fbf70f,
    0x3ff86ce6121d6a90, 0xc00a9429f8ac7f2e,
    0xbff53669ecca7c85, 0xc002c3c5db03432d,
    0x3fe6defd9405ecee, 0x3ff5482cccc0238c,
    0x3fe1aab08893dbdc, 0x3ff948128d34c8fa,
    0x3fde397ea33d8df8, 0x3fdd058b4474ed94,
    0x3fd7243ef9a3c77b, 0x40126e8fd6a50bf2,
    0xbfd1d9fba826903a, 0xbfdaa321021b5d92,
    0xc00532158d35b2f2, 0xbfe3a367c160877e,
    0xc00be4d858f4d56c, 0x3fe154fb6556929b,
    0xc000d737cfa1cbf7, 0xbffa68d26d61241a,
    0xbfca74f6e92b265c, 0xbff1661411d2d332,
    0xc00588a41985d7d5, 0x3fd89904520ebb7c,
    0x400835e1683d7880, 0x400436c664c99f96,
    0x3fe11457b89b8a57, 0x400b00c9a85fd9d6,
    0x4009b6469e5bd13a, 0x3ff34c3fc82717cf,
    0x3fe5884438cffd4c, 0x3fd467d8c3d1d810,
    0x4013184c0bce04ee, 0x40109c8006c9d97c,
    0x3fdd127935614d50, 0xbfee1c27619eb7d4,
    0xbfea912f675bd586, 0xbfb793b64b0239e0,
    0x3ff59ce6aa1b48a4, 0x400506340f3647e8,
    0xbff23777ce6798bb, 0xbf989e8efb2dd100,
    0x3ff3a7eb6f54ba06, 0x3fcb4d31dbd89c78,
    0x4013b1a3f5a496d6, 0x401421f88b902107,
    0xc00619d09c4c35fb, 0xbfe26537089463be,
    0x4013260a439ae5b2, 0xbff20fa07713390b,
    0xbff8d04c57cd09d2, 0x400764dbbd9d4af3,
    0xbfabb9ec32f98820, 0xc0056df5b3945be2,
    0x400cc5a3c3cd796f, 0x400884cfe9a65036,
    0xbff448406fe92526, 0xc0045df85b4fba1e,
    0xc00bb3c8bb10e31e, 0xc008e881bb90aeb6,
    0xbffa3b14875b936a, 0xbff871bb570c6e3d,
    0x3fc2ece985b5edd8, 0x3fd77d8178b6ea24,
    0x3fd3f1c7fc46096e, 0xbfeaccf9d0b2ea11,
    0x4009732cf5d0affe, 0xbfeb35489a82996c,
    0xc0018f78c34b1716, 0xc01495206b64d808,
    0x3ffd4470eaaae442, 0x4002a1df25b75481,
    0x400c052d966802c6, 0x3ffbaedf441fea2e,
    0xc007937ebb7bda5d, 0x3ff17bcd912c4542,
    0xc00e7dd2c7e3f41a, 0xc006ee5df84ac04e,
    0xc005ba09292583ae, 0xc005712c1a5a8fef,
    0xbff7929309a39fa8, 0x3ff22c176ea42c88,
    0x3fbcb9a4df218ed0, 0x3fa5a653e63f35d0,
    0x40101d431d075150, 0xc00cb78cbe096045,
    0x3fea72727f831183, 0x3fd07123d64db12e,
    0x400c5aaff1f80cee, 0xbffadc25acd46e1e,
    0xc00d99efc725a350, 0x3fe0438cc7b09240,
    0x4008aa906d47492a, 0x4002257ffb637c81,
    0xbffda2e70d630f64, 0x3fffe94cd399bb6e,
    0x3ffd551af00e1876, 0x3ffddc466964a790,
    0xbfd458326608f7b8, 0x3ff4a26ae0e591f8,
    0x3fe936c5399901a2, 0xbff254051b85d81c,
    0x400550afc0e1c365, 0xc00573374f8098a8,
    0xbfd98cc5529993d2, 0xc09666fc4e690dfc,
    0x400b7ab36ca7611a, 0xbfffb66531289158,
    0x4003d9ab8ddca7a2, 0x3ff7bb146e227a6d,
    0xc00738a937551b0d, 0xbff1bb3c5010e938,
    0x4003009b8d0089b6, 0x3fed629938eba9ff,
    0xc0012d091e9fa17b, 0xbffc9b88c08d493a,
    0xc012aa454bf6b2fc, 0x400b5a15deda612d,
    0xc0046f1f83f6a501, 0x400a4ae019f1a79a,
    0xc007e912d39e77da, 0x40093f2c188bdc71,
    0x3f9280f634cace80, 0x400cf40d96605080,
    0xbff891a8735cdeef, 0x400055b358a00bf0,
    0x3ff9904b5f41f1b2, 0xc00ee8d1245b10be,
    0xc012455e2baddf72, 0xc002b0cab75ea767,
    0xc002e7883a2b179e, 0x40009af95ae4e4fc,
    0x3ffb4d9e0e1455cc, 0xbfdaaf7136ab52ac,
    0x3fec41c79f351f88, 0xbfe568fea588dd41,
    0x3fda5e0645d13c5e, 0xc00f93b29e92a78c,
    0xc01a0c9f0290c1dc, 0x3ffcffc9562d6dd4,
    0xc012d6de173469d7, 0xbff5ad5c4c85d460,
    0x3fdef642c741f449, 0x4002a3b05e14cbe9,
    0xbff3f56d105089d1, 0xbfd6eb7a68356712,
    0x400e68b4668cddb9, 0xbffaea8cdca7edee,
    0x3ffb17e71052faec, 0x3ff0f8235e4656d0,
    0xbfd7da7e875aefca, 0x400498f1863424e3,
    0x3fe223059c6a058b, 0xc001787750c56f71,
    0x4006f954c4048214, 0x40165f118b3a78a6,
    0xbffa6ab1565aa3c7, 0x400432b8ba2952ac,
    0xbfdbd0c044daf663, 0xbff0786e33693df8,
    0xbfef53f148ba6cd9, 0xc00558634d18dbbe,
    0x4000b0f17c12f0ee, 0x3fe850db91876e6d,
    0xc003d91e75a6d52b, 0xbffe0678a886bcda,
    0x3ff22a743c9d1556, 0xc00bb40c7c2b17da,
    0x3fe4854bbe267939, 0x3feed328817fe7ad,
    0xc012166baddb16db, 0xbff85b2eb0308c6f,
    0x3ffad82f799ea148, 0xbfec3780b5999d99,
    0x400dfb69589916f2, 0xc0000cd3817075fb,
    0xbfeca086678a6300, 0xbfe9c55c31a0ed61,
    0xbfe2187218fa9320, 0x3ffa55c2327a3083,
    0xbffc3f45bf0748e0, 0xc0123e133682a379,
    0x3ff523d29395f27e, 0xc0065d441f1be445,
    0xbfe0cc4f2476d110, 0x3ffd97bd4a2dfc62,
    0xbffbc3ae8e7b7bea, 0xc00b1cf5c807cfaa,
    0xbf6fdf4032bbac00, 0xc00c1ce1d0fdf05e,
    0x3ff083f049ef1c9e, 0xc008bd642fa23cb0,
    0xbff608fc4c6406e5, 0xbfec0bb7435058fa,
    0xbffb9d4c7d60ce1f, 0x4007589a4946fd61,
    0x3ff7dd4803c56312, 0xbffbba64bcf774b4,
    0xbfe7363d51745eed, 0xbfefa4647e66d856,
    0x3fc6a1818317df78, 0x400273180e834c6c,
    0xbfd82236d36fbe18, 0xbfe6232b72d00ce0,
    0xbfd0a20cd8ea2564, 0x3fe9d239d9a93e31,
    0x3ff22ad7e401f42f, 0x3fe8b75290be4a34,
    0xc0081a793cb7bca5, 0x3fc1591455b21b94,
    0x3fea118833dcd13e, 0xbff11e92c1f517d9,
    0x3fc40d54d3c4b428, 0x3fcc9b85c6cbdd88,
    0xbfd13c39d762aedd, 0x3fdf38f3d324e5d0,
    0xbfe342f67a0a0d08, 0x3fd6207af8f1d60a,
    0x4000cbdcd4b12048, 0x3fdf62a85db39260,
    0x3ff6d1a30a02f073, 0x3ffb1d167d37faa8,
    0x3fb144e095435b30, 0xc00cf66e34e9295c,
    0xbff1ec83bdebbe45, 0x3ff562f6e97c77bd,
    0xbfe69442e598d797, 0x400486559e86a2a4,
    0x3ff08ec91b50efce, 0x40120dc1b740c892,
    0xc00d8c390c002472, 0xc004aeff8f9fff7a,
    0x400cdd1ede650d1a, 0x3fabebb026495b60,
    0xc00e56bac7d69a13, 0x3fd4171b09c19c16,
    0x3ff66c37815df4a0, 0xbfff90916bc7098d,
    0x3ff400de55896315, 0x4002c65254dc51ad,
    0x4007b655d0aadf2f, 0x4000ed219fdc0a64,
    0x400224b054eb3727, 0xbffd92099aaf834c,
    0xbfff8422722e6800, 0x3fe2369c7b4c677a,
    0x3fe8bcfefe5aba5c, 0x40103706e77bc2cd,
    0xc00719c60722bd48, 0xc00e3287c6ffc3d5,
    0xbfdee94a6dadc1cc, 0x3f870db00cad4d80,
    0x4007242ae9b25567, 0x4009b28528ca9e72,
    0xc000eef9a66515bd, 0xc0052077f68ff53e,
    0xbff0f3fc27e06013, 0x4001622dcba8f302,
    0x3fe58a426a8a98a4, 0xbfe5456bb52331ab,
    0xbff183662a798f7c, 0xbfed8680f250163f,
    0xc004cfcb0627f662, 0x3fd6398b090065b8,
    0x3ff173501ac080f7, 0x400639cda01dd086,
    0xbff2d73cff311538, 0xbfeac7104a2ad206,
    0xbff0ac9f38235d11, 0x401834051d4ed688,
    0x4011fc33e6a6a2e6, 0x40071960c5ab9aaf,
    0xbff982c57c7e4a9d, 0x4008da1a7c8fcec3,
    0x3fe1dedc703e7302, 0x3fe3fa8613710c13,
    0x3fdf48b62da94eb4, 0x3fff36a16ad41bf6,
    0x3f8f459104f35100, 0xbfee77336aa21b79,
    0xbff035b7f8ea8392, 0x3ffeca031c4d7031,
    0x3fc709755dde54a8, 0xbfe36ccedba0e5a2,
    0xbff678fa9746f1e4, 0xc000166c3489e6f1,
    0x3ff800220c054ec8, 0xbfe94093bb8e215a,
    0x3ff72893461d449e, 0x3fdf2cf08345c6a0,
    0xc013e8556a5ee6fa, 0x3fecc4b6e72b6603,
    0x3fda8cd3d565b080, 0x3ff03d0a999f91b0,
    0x4003499688667ca9, 0x400368870235660e,
    0x400822101fde8102, 0x3ff74e0596f72d35,
    0x4013cc000f0b1d8a, 0x3feca985a6a30fea,
    0xbfbea79394ca83a0, 0xbfe87c2a16f0e1dc,
    0x4010817a9f2b2b7d, 0xc0156ff654e7f370,
    0xc008b6df398bf7da, 0xbff5996e397a0b8a,
    0x40035ec2788831ea, 0x4002819f10ce2c4f,
    0xc00b5dfff09c39ad, 0xbfe43dd5ce56f6c6,
    0xc00dbbe77daf8770, 0x40031456dc26383c,
    0x3fddb095f4af408d, 0x3fd0e9c1a960b72e,
    0xbfdef32a9034c20c, 0xc004006482be7011,
    0xbfcc476f38077b38, 0x3fe097d305a20b38,
    0x4011b5bb61c6b4c4, 0xbfff3b1be795239d,
    0x3fcd57646051c0d0, 0x3fe414e275ecfa1a,
    0xc00484b5e4f413f9, 0xc0034b94b14bf7cb,
    0x3fa679e8155ce920, 0x400cfa1180bfad6a,
    0xc0102062556f58e8, 0x40157b758a983552,
    0xc009c723eaa0e11d, 0x3ffb62a5050ed19c,
    0xbff9582fa97896a4, 0x40125ad1a78feeb6,
    0x3fd8809700cced8e, 0x3ffdc95bb46e9b3f,
    0xbff93bf12bc9e45e, 0xbff93605e8675950,
    0x400bf61bfb46a70c, 0xc00818f1cdf0929e,
    0x4006a8c9a484de39, 0xbff02fe730d4a199,
    0x3ffe3e6c7a7793dc, 0x4006b922fbe6f359,
    0xbfc21e88ae7e7514, 0x40126e0ecbfa0ddf,
    0xc0009b01f57b270a, 0xbfe95f01df64c11f,
    0x4011427a8dfe949c, 0xc003f022b7351e8e,
    0x4000388ce014e17b, 0x3fd90c0a7e924124,
    0xbfe46ba8901057bb, 0x3ff34e3b9341aefa,
    0x3ff20d06c3896226, 0xc0021b26bbd67eab,
    0x3ff0c5f505e7671b, 0x40076b64284168a8,
    0x4015e927b3f0ba8a, 0x3ff677f630d4dbe4,
    0xbff826a51d67111d, 0xbfe91756f2530415,
    0x4010b7f9de7d9506, 0x3fdf4c35ec8bac04,
    0x3ffbeb92683fd8ae, 0xbff4291e12f241e1,
    0xbfd8ef81b35bfe26, 0xbff9ca9aa81e0b50,
    0x3fd623aead1eae6c, 0x3fecfe3ab93e37fb,
    0xbfd9d70776b4a0f0, 0xc01383fbd0f7467d,
    0xbfe6729781524f0f, 0x3fe52a1380aecbb5,
    0xbffc934ed3bab51a, 0xbfc4958109a28d6c,
    0x4006cd9f013aa8e0, 0x3fec7d4613c2f2e0,
    0xbffcac84c313d31e, 0x4000ce9f6f79ea9f,
    0xc00e0441d4879f2a, 0x3fb46ef496472830,
    0xbffb934501bf09cd, 0x3fd116142dc03a6c,
    0xbfd366555c27859c, 0x3fe1bab240ab40ea,
    0xbfdc61af489c6de2, 0xbffc33dc02ad35f2,
    0x3fdc210029f8df62, 0xc0036fc159a69fe0,
    0xbfd7d2a3b65b8864, 0xc0002dc9e2f9227a,
    0x3ff255ad58e56fa6, 0x3fe811ed7d516eae,
    0x400791a1bbb53dd2, 0xc004c72acfc6904b,
    0xc001a39fb734224f, 0xbfd035d0b9d4b4c2,
    0xc00126e2554f512b, 0x3fbd3dda63f8c980,
    0xc00f5d568cf703eb, 0xbff08162c76441fe,
    0x4001bba9541b5326, 0xbff563f86f6d90b8,
    0xc011c5ff31a9a1d3, 0xbfc9b119adc970b3,
    0x3ff15d20b3fe7070, 0xbfe819aff4369754,
    0x400b348d8c7fe4f3, 0x3fd93c452e6b63b2,
    0xc012982e68e88282, 0x400d0f75d3d333ca,
    0x3ffabef6c6342d6d, 0xbfc0bff2169b3082,
    0x40020d05e4705830, 0xbff92fcd5d844ec4,
    0x400280ef3f6a9e8f, 0x3ffc78f8c4ba1b33,
    0x3fe72afcc0070b86, 0xbfe0a1bd515276da,
    0x3fd5315149984ac6, 0x401554e13d26163a,
    0x3feda66d1eb4a8f6, 0xbfec7183be35ed54,
    0xc00bc8f341a244c8, 0x3fe058c3db166390,
    0x4002ce9cf6cfd8e4, 0x3fdf1fbca2987987,
    0xbfc352ffded7bfdc, 0xbfe7b9a1d300a3bc,
    0xbfec0899a2410528, 0x40037d71aec18bb0,
    0x3fcae9aac1a26b99, 0xc00a4f053b83c7dc,
    0x3ffb03eae1b53f0d, 0xc010cb03425cd07e,
    0xbff92fd6e358ccfc, 0x3fd98059b1f10918,
    0xbfe574e1f2d9774c, 0xc00b6b2000e88ba3,
    0xc004df0b0577b47a, 0xbf48fb87c0f76400,
    0x400b6b23ebc00af4, 0xbfc047735de75a34,
    0x4006c94fd620c5fc, 0x4005f942e16abc48,
    0x40047ff188a56897, 0xbfd1820e386637d0,
    0xbff858c5710d1f12, 0x3ff7618f2ae5a6f6,
    0xc00ab90e421f5e5e, 0x3fe9cdcf63072999,
    0x4004c2b5a1521a00, 0x3ff3bd302fab9b0d,
    0x3fe1b5ab51553b7e, 0x3ff5e360f72a07ac,
    0x3ff2842376f76eca, 0xc01183e3b0a00053,
    0x400f14dd3dca7cb3, 0xbfb8dfe0c779f610,
    0x3fe2c0c39b7863b6, 0xbfe064019990b9a7,
    0xc00294cba63c708e, 0xc0083ca83a7a3a2e,
    0xc00be9c757c7bb54, 0x3ffea2d52c69c02a,
    0x3ffaa8bef32be925, 0xbf95f7efe390a000,
    0x3feceacb574c0308, 0x3ff26666155dc438,
    0x4009f9752bdb4d09, 0xbff08a271e962294,
    0xc008aab299cb852c, 0x40049131fa0cef56,
    0xbff869ed50b54b18, 0x3fcc2a3f21dc0744,
    0xbfc0f6ee7ff844d8, 0x3fe0faa264458114,
    0xc000110e1fd4e6b2, 0xbff68d969e259862,
    0xbff3e4f8b9ce1a82, 0xc016878d200a350e,
    0x3ff9606ba45c09ae, 0xc012836d772febf9,
    0x3feb3a7643cf10e4, 0xc0048039d2220008,
    0xbffee1cb749d237b, 0x4005aec1e1cd840a,
    0xbfeff0defc2921c8, 0xc0001659d6cd68a3,
    0x3ff4bea9f8f13b85, 0x3ff5a371cd96b32c,
    0x40075d3d91768e56, 0x400318550fdd9744,
    0x4001bae9583e7d22, 0xbff19d4cb434a4a1,
    0x4004593b1995f984, 0xbfd7225f38993bd5,
    0xbfbe247387a57886, 0xbfc40c0d766ebae0,
    0x3ff22fd5c204f202, 0xc0042aa636d865d0,
    0xbff4523da2d4c9f0, 0x4000b36d4042cf38,
    0x400e553d7f3f91c7, 0xc000c3469ff8d73f,
    0x3fe28de89ad6c9f2, 0x4000feb1261220d0,
    0xbff06764630b728e, 0xbfafbba36d7b4570,
    0x4005414c074301ac, 0xbfec0f603a94d304,
    0x3ff447c72bd077ac, 0xbfea4d671abf7662,
    0xbff5bb7d88a445dc, 0x3fced7aed8cdc403,
    0x3ff93371365b2d02, 0x400575309f19e415,
    0xbfb1e14ae915d050, 0xc00547c7c3dc301e,
    0x400510d1a5dfd1e3, 0x3fe753aca6d69954,
    0x3fed08c2cf7eb784, 0x3ff7e2c71ab7e888,
    0x3ff052d8d981760a, 0xbff1f448e2ca15c2,
    0x4019231ed2fc713c, 0x3ff5148296d48404,
    0xc0061da214ac5886, 0x4012027413c82d98,
    0xc0070c5df10af412, 0x3fd2e6d71eddcbab,
    0x400eacccf8980afe, 0x3fc2418e6750d366,
    0x3ff08827267e7d94, 0xbfef06740346dc4e,
    0x3ffa9ded8044b880, 0x3fe22c7182e5009f,
    0x3ff0e40b0ecbce62, 0xbffeaa4d179203e6,
    0x3fd5960093844178, 0xbff734708a14c47d,
    0x3ff82178b8e7f2d5, 0xbfe465b26e2bf87a,
    0xbfe129a16799aa09, 0xc00625f546868924,
    0x3feba3f01a663be2, 0x4006e195bf613e58,
    0xbff2f34bc7bd3762, 0x3ff262c269f81466,
    0x40129cc12392126a, 0xc0139511fc0c542d,
    0xc011b48e4e3a3940, 0x3fd0660710be5ce8,
    0xbfe055e391e4d7c6, 0x4001130241dbdeb2,
    0xbfcc577fcffbdff0, 0xc002cabe3a346656,
    0xc008a7998d514fb4, 0xc0051f84c29d70e9,
    0x40123bc50f383b70, 0xbff33c98fa23442c,
    0x3ff264a2637b43c1, 0xbfd09abaf330ac8c,
    0x4009479786511875, 0xc00cd963043d0874,
    0x401a69dc173804b7, 0x40000f1458a7b627,
    0x3ffb37f57e2ab6b9, 0xbfd53a9c88cd6db8,
    0xc0059114308f1c11, 0xbff9b4b8ea433e4c,
    0x400611225a14d1bc, 0xc003b1e63b978641,
    0x40031288a7b3c359, 0x4005fef479bbc106,
    0x3ff9357f9e56e2d0, 0x3fd6760d35899218,
    0xc00d8df153a4cac3, 0x3fd4b75bde076b90,
    0xc01034d1a05cb02e, 0x3fd57f2e7a0d7e81,
    0xbffa6c618e90df34, 0xbff3723fcfd5c8c8,
    0x3ffb816d17ca3036, 0xc003c0cac3179d4b,
    0x3fee69ac37dd590e, 0xbff540f69656c605,
    0x3fc49dfa7714159a, 0x4001eb8e5de7aaa6,
    0xbfb9607c920d5ad8, 0xbfb066e990661be0,
    0xc01693a905b0e396, 0xc002127329772598,
    0x3fe8a9ee51ca2c80, 0x3fe31248f03da32f,
    0x3ff25e8a8ba5fa31, 0xbfdba83df939686c,
    0xc010a627c39e7b24, 0xc00901a1ad440415,
    0xbfea304dc4e40540, 0xbff272a5184762df,
    0xbfc7cb1a314f696c, 0x3ffac1a8bd95794c,
    0x400da2d979639b32, 0xc0038bc40e9e85e6,
    0xbff815c1e08920c4, 0x3ff7869752c82160,
    0x3ff237d9d1078d66, 0xbfa4089d0b78f9c0,
    0xbff5e5bfd8052552, 0xbfe91ec8911f9808,
    0x40063577219fc2bf, 0x3fe1342164dc3477,
    0xc004664a40157c66, 0x4018ca7b2096fffd,
    0x3ff46d06390e1231, 0x3fc4a27ed0369fe0,
    0xbfd6e1366b925838, 0x3fd3d99286ce2880,
    0x3fcf8fd4c15fee8f, 0xbfe58e709bdb5f56,
    0xbfcdbe8b81f9b4fc, 0x3ff9898509e6d35b,
    0xc009c057aac36d9a, 0xc00882f227f06716,
    0xbfea123ea597b67b, 0x3ff4499025ba4726,
    0xbfec987646c8fb1f, 0xbffc942fd8312e5c,
    0x3ff71ae398917142, 0x3ff32f02347e0ea8,
    0x3fe2c423275438e8, 0xbfac3b6b91c80400,
    0x3ff8cd988748ce8d, 0x3fe0cc9e3af81c90,
    0x400a388dc52a9f8d, 0xbff42e53a505090f,
    0x40014b89780d1631, 0xbffbe5290da40ab4,
    0xbff0671192284210, 0x3fc267273b5b24ac,
    0xc0062f6b219a19f7, 0x4005481d21d8e46c,
    0xbfea58f6396bcfe6, 0xc00ad9fa7dbd2e8d,
    0xbfd024c6c3005ced, 0x3f9ac5474b270680,
    0xc00026c3e2c92a2e, 0x4006dc84929cbcfd,
    0xc0037c020efb4a59, 0x3ffebb9ea85ae9dc,
    0x4007c20b510456b8, 0xbfe0e5c9f2ebe839,
    0x3ffd6f7dc5ac3128, 0xc008fa83ffbcb4fc,
    0x3fc2499d18775770, 0x3ff5693724b5d569,
    0x40070caa0edb31d4, 0x3ff5e816f8cfd0a5,
    0x3ff0b273f8396429, 0x3ffbd64bb2241d85,
    0x3ff5f07b6d312c75, 0xbfebde4fdab7e52f,
    0x401118d3e5847ce4, 0x40090c430f3a372e,
    0x3fb9261ab5b09ba0, 0x3fc7660d69944156,
    0x401298eafa175606, 0x3fe8b473e24a467e,
    0x40000a0fed1a2252, 0x3ff816ad1a837ac8,
    0x3fd33a777ec3280a, 0xbff7553babcebcb6,
    0xc0041b317c194862, 0x3feb91457df540eb,
    0xc006d46756131aa8, 0xbff43415d16fcbab,
    0xbfd7cd008031be44, 0xbfd9712fc101ba53,
    0xbff2990972e795e0, 0xbfd036be1bd200b8,
    0xbff8860d470190c3, 0xc0011e573374d0db,
    0x3ff4c9466fec853a, 0x3fe2d396950b7324,
    0x3fe8bcd13559a598, 0xbfeea3532695d38a,
    0xbffa38592f55d17a, 0xc003dadc182b617e,
    0xbfd2c4a96397ded0, 0xbff959c37ea05e14,
    0x3ff1609154f78409, 0x3ff6913b5f54f860,
    0x3ff58843c26351b4, 0x3fe8518d77eadd6c,
    0xc00aa5147880e8b7, 0xc011bd4fc9ed4053,
    0x400a9ae95d8b4ffe, 0xbfc55faf8bb273a1,
    0x3fd47e9e22ddfa15, 0xc0002e6d3ca0651f,
    0xc00c716354ec9a05, 0xbfd786dc7c3f1228,
    0xc001917f5bd88321, 0x401285002311d2b6,
    0xbffd9546ace98fd2, 0xbfeedb1c72d39bd8,
    0xbff28475f51d2f3f, 0x3fde6ded916722c8,
    0x3fe0f5cf8d27692e, 0xbfe3a73ef049d147,
    0xc006d501a8497e5d, 0x401c0c609cd512c4,
    0x3ff3256637c08cdf, 0xc006a6ce0f82c460,
    0x4002278b6281252b, 0xbfe2e14882110576,
    0x400c9ee42b084f29, 0xc0107dc2e6ed0c9c,
    0xbffd613dac38c7d5, 0xbff4e01cf022892b,
    0xbfe69140269c82a6, 0x400151bf49d6eb3c,
    0x4003d3540636c49e, 0xbfebe1efd15c48c5,
    0x40144f446b2b003d, 0xbfc39912daa0f320,
    0xbffaae6df719f124, 0xbfcb5a5e30fa596e,
    0x3fdfdab130432db7, 0xbfe68971cdceefeb,
    0x4012215a791da537, 0x3fe32e6c4bb9d65c,
    0x4017f6916d074ab7, 0x4007a11cea35de0c,
    0xbff87c148a36a2aa, 0x400245cf3ceb6a95,
    0xbffa1015d3ba21e9, 0x4016162a608bca6c,
    0xc010498562ef4461, 0xbfed538b9314cbcc,
    0x3ffa1403eff03924, 0x3ff0b99d50d9a73a,
    0xbff6154af25f7a6b, 0x3feaf3d28ae90d2e,
    0x3feecb30c10076f8, 0x3fe6389673d33f28,
    0xbfdf623b1a099907, 0xbff691ae934a3997,
    0x3fd9f469c0066bf4, 0x4010b857d374fd3d,
    0x40002e564a570422, 0x400c966d43cdf2ce,
    0xc005b124424c5776, 0xbff9bde88d86c55e,
    0xbfdf9824284ae89b, 0x40124edeac3fb0c8,
    0xbff61bae351c9bb4, 0xbfe5dad1754511dd,
    0xc013fd3dc6f226a6, 0xc000d53fc7e1bd9a,
    0x4009b8d3b353731c, 0xbffe37163b2f90e6,
    0xc0111f95a25ae1c2, 0xbff67c04a628d4de,
    0xc0098de5cdaec200, 0xbff42e5f53047e5d,
    0xbffc4138758a75d6, 0x4011c99e3766ed3f,
    0xbfe76d6cbbc58267, 0xbff69fc1f5a7c096,
    0x3ff7e418ce644369, 0x400ebe86992aa676,
    0xbff2025027e424b8, 0x3ff7b00d0cca005e,
    0xbfed34299c2687da, 0xc003f78b10a8b063,
    0x3fd82c8b3268a894, 0xbfc386deaba2ff26,
    0xbfd1f97915507618, 0xbfe7419d872c8de4,
    0x400cd9cc43b22272, 0xbff312a90e6ec812,
    0xc004106356af7a04, 0x3ffd1d58d13c7013,
    0x40019e270aca6521, 0xc00b131ee0dacf40,
    0xbffec1e51337e7e7, 0x400440af36d741dd,
    0xbff63f645d046bd6, 0xbffe8ae10c1e3f07,
    0x3ffed60d32599383, 0x3fb016b489eac3f0,
    0xc005bd17eb2bbcde, 0xc0110d56ede632b9,
    0x3ff21ede8863ec98, 0x40088e55b6a7c9af,
    0x4005463c5df413dd, 0x3fcfc69160be2e00,
    0x3ffe7bfc88801eee, 0xbfe49b1d317a484a,
    0xbff7562da5ab92a1, 0xc00a6e20d8634598,
    0x400121fce0217559, 0x3fed7504921205f2,
    0x40028e9a8f1093b4, 0xbff5e53764371588,
    0x400393dc9123655e, 0xbffc5d563cd0028c,
    0xc00e923f0fc18095, 0x3ff1c0dd464448f8,
    0x40136c3973119be2, 0xc01061e424a970c5,
    0x3fd324713b0d8f80, 0xbfcb5c222bd4257c,
    0x3ff42925712aa693, 0x400683aefcdafb0c,
    0x400e637e78b6bb1d, 0xbfdfa2caed1f9a66,
    0xc00e3d81f9df73e0, 0xc005f76add030a9d,
    0xc01078c3f03c2782, 0x400b12fe3279603a,
    0xc01175c4a66d4f65, 0xc000710291915ab4,
    0xc00064011024d7f6, 0x3fffee3654e221f9,
    0x3fe55223624acb36, 0xbfe979a8dd83cf7a,
    0x3fdf4b61d53787e9, 0x3ff6f887b8508858,
    0x3fb3be8e98466f55, 0x3fd277c76f0a6f3c,
    0xbff2fb7f44413632, 0xbff59c7e716fbd87,
    0xbfff05faf80a9515, 0xbff9f150a6e2c284,
    0xbfe39887c9c82f1f, 0xbff54f7bdff47b40,
    0x4007f7ab927c0e00, 0xbffccaf6801908c5,
    0xbff7074d8ea0de2a, 0xbffe6d781e5f60ca,
    0x3fc59d36eea855de, 0x4013665b915476a7,
    0x3ff1b341d9be0284, 0xbfe3040b346875f6,
    0x3fdb1f780e6f2526, 0xbfe2ae58a1f3d1f7,
    0xbfd01910f15bd7f4, 0xc00ee48871306948,
    0xc00385192420e098, 0xbfe00d3a4717df31,
    0xc00915796aef6f52, 0x3ffa7fbfa5aaf074,
    0x400a59800b66b31e, 0x401b1f41b85aee63,
    0x4006fbc28cf0a958, 0x400328e11f3adbe5,
    0x3fd6b3120f4a488e, 0x3ff4e0460732c136,
    0xbfd36a15a732f847, 0x4009c5071d8b44c9,
    0xbfd18d2a3d7ba862, 0x3fe5e2c0fa5ca861,
    0x3fbef9657b08e6a0, 0xbfedbb677ac8b5c8,
    0xbfd485b348c7ae92, 0xbfc4a22ecce8e540,
    0xbfe9da9628e4cf3e, 0xbfed5453eecc5fea,
    0x4007eb8adbe10fde, 0xbff692102643690c,
    0x4002bb61c9118dc5, 0x40008394a82a65ba,
    0x3ff42a014b20cde7, 0xbfcd6ee6a21de178,
    0xbfd2b415851a975c, 0x3fdfbe233b6941bc,
    0xc00373639f31a014, 0x3ff605da39b6c367,
    0x400408cbdc980eac, 0x3fe9e114f4aa08c8,
    0x3ff7994bc75149a1, 0xbfd8c41e9e21e71c,
    0xbff5a1037edcedee, 0x3fde39459f4cd642,
    0x4001997e96209ee4, 0xc00257e0b9745458,
    0xbfca5a6974fbd7c0, 0x3fe2b3877b40c8f2,
    0xbff90052d1c06282, 0x3fe46dcb2a2c5add,
    0x3fc1f23480c62930, 0x3ff01e3636e7ffdc,
    0x3ff4bf8823901302, 0xbfd30f699d07942a,
    0xc00519b3ede40072, 0xbffa5fa8a14f26c5,
    0x3ff98f470018f442, 0xc0065410aa6b23e5,
    0x400c5c963bbe3797, 0xbff28006a47c98cc,
    0x4000837389848d63, 0x400af2c6ca2cfe60,
    0xbfeeeffa85d6c96e, 0xc007077560cc3fb0,
    0xbff125e06289b1e0, 0x40025b920d64908b,
    0x4010ad56cd22f257, 0xbfe39681ac301a70,
    0xbff1a48743261400, 0x3feeadef178a2e0c,
    0xc00339661c617b5f, 0x3ff2923e8704a200,
    0xbfdc24e18e4f03a0, 0xbffd362a263ddb48,
    0x3ff1a1716a748ef0, 0xbfde02d7d70032a2,
    0xc00062dd84f34017, 0xbff4e5a338a68672,
    0x3fdc7aac73254d91, 0x400240451a5b6a79,
    0x3fea0e75db2cd402, 0x3ffbb2906367358d,
    0xbfed138b2591923e, 0xbfb973aed37dbc08,
    0x40059ebc14ba1869, 0x3fe35d99edacaa7a,
    0xc005909875bf73bf, 0xbff2b26a6283c927,
    0xbfecb1ed9da4c224, 0xc000abc8c51fe8aa,
    0xbff69f93c4e1fbb1, 0x4005b04e73682edc,
    0xbffeaec4f2f7f9a0, 0xbfd0613beb107246,
    0xbfd071c478fe3118, 0x40097a55c791e323,
    0xbfe1d7af853bc0e4, 0x3fc76882e37a6bd2,
    0x3ff60777268c6d93, 0xbfd110e38158ba60,
    0x3fd169b86a0c6a06, 0xc00416fefd2ad3dd,
    0xbfeaf59d06fa2a93, 0x3ff8a07afa0404af,
    0x3fe3432e9d905363, 0x3fca49cc028e5759,
    0x4012f4ffeb6217d7, 0x3ff24c045a001f55,
    0x4003a08e9f696244, 0x3ffb1d377261ea5b,
    0x3fe5ac92051563b7, 0xbfe1357084922bc8,
    0x3fe312f576fab892, 0x3ff9959614eada14,
    0xc0015572ca1d4831, 0xc00f4f4e61018b7a,
    0x40108f1a03d5209c, 0xbfefd89ed53d8b43,
    0xbfc7ba1b2ff76ee4, 0xbfed1bdf195a8c63,
    0xbff4d65b7b025807, 0xbff4275ea0bc0c98,
    0xbfef81be269a22da, 0xbfe3a8472037bcfc,
    0x3ff25ea00584c1c8, 0xbfe0fde5825d2964,
    0xc0002bbe0bb43b18, 0x3ff1c8d7fab1af34,
    0x3fffbe6768e89f2e, 0xbfb3e6a621a5ef1d,
    0x3fe228d02ae45faf, 0x40003ab6e975ae24,
    0x3fb9f001f007aae0, 0xbff4f5269608c6c4,
    0x40117083ead04c83, 0x3ffed49a9fe024b4,
    0xbff6c31e743cdbd2, 0x3feabc6235182ace,
    0x3ff153120f4fda2c, 0xbff442f2f13f7a1b,
    0xbff8ff28179a395c, 0xbfe7240118eec8cb,
    0xbffec8f7bb2ec4be, 0xc0080176387b50dc,
    0x3fed3ed6bc33ba90, 0x4006502776cd6f18,
    0xc00d3969d20037d6, 0xbfef60df3d9b101b,
    0x3feb59a0649c28a8, 0xbfdb3c83d3db408c,
    0x4003ee7e7e97388e, 0x3fc519b8a09a2b38,
    0x3fe8456d6bca762a, 0xbfaef25dd6abee90,
    0xbfec33c722e24e7c, 0xc018cd5fdf80254a,
    0xbfe3ada08108d8d6, 0x3fd1d8b44724fb58,
    0x3ffebd205e3ede37, 0x400b4c88e7e1496e,
    0xbf701365e3a9fbc0, 0x3ff0ed3d181c1b5c,
    0xbfe0852e56d9ca90, 0x4013fd5231bf231d,
    0x4006e6e0a929411a, 0x401306b3ca27fdbd,
    0xbfcaa41e025c8140, 0x3ff935c5d1f789c0,
    0xc0085a530dbb342b, 0xbff8263c97044fe4,
    0xbfd18becbc8b8144, 0xc00bd85bc8bdfa2e,
    0x4006ad3af2bf55bc, 0xc00f4738520d62a2,
    0x3ff3d9601e39b678, 0x3ff43c276ed4b72f,
    0xc007334301602e66, 0xbff90303114f93e5,
    0x40018f17f0695fd1, 0x4001c35f6113ff45,
    0x3fc1c491c9a93ee0, 0x3ffad158907647e4,
    0xc0030f71fe691adf, 0xbff16a76dede27c2,
    0x3fef15f84f583863, 0xc004b676172d2e5e,
    0xbff538e36fa9c461, 0x3fdfef0aecc8f5ac,
    0x3ff7d86f1dc11d38, 0x3ffc6bd77237cc05,
    0x3fd4d57fde904bd0, 0xc00aaf073819eeb6,
    0x3fe8dddcb3f389dc, 0xbfe46eef980cb63a,
    0xbff504d98bf45847, 0x4004db3635026a68,
    0x4005bcd15383c508, 0x3fe8ce6839939b0b,
    0x3ff5fa9526cf1ae0, 0x400d2f2ca3710ebe,
    0x40089b63b77d7d5b, 0x400c330ebfbf6ef0,
    0xbfe953b0c56429c6, 0x4007edf16bc5917e,
    0xc00ac1d4e3224ff9, 0x3fd5c1b0434f2af4,
    0xc00a1bbd55e8e11c, 0x3fe8d7ab61cfabba,
    0xbfe77408f7675f9f, 0xbfbff7f1a2bea290,
    0xc002b104d6f1f166, 0x3ff9ff9d188bf65f,
    0xbffeb78cbc375410, 0x3ff0b58b608b7039,
    0xbfd5923f52c5e1b0, 0x3ff73e9632fff540,
    0x3ff04b650ea8ab7f, 0x400766e084808139,
    0x3fea5eee414344d3, 0x3ff75eec27c3e76c,
    0xbfc2a4f596906730, 0xbff31963f8bac19e,
    0x3ff9e55709eaaf68, 0x3fee70b67e728908,
    0x3ff6104048660eb2, 0xbfe8e527cd1bd8eb,
    0xbfef8f9581a1d648, 0xbffffe6a4bcaace8,
    0xbfff71c434a4be2f, 0x400c16b8f324e7f4,
    0x400f305418009b88, 0xbfd87c9cb097dd18,
    0x3ff94c7f7d2fcb01, 0x3feb5aa3ab954a99,
    0xbfddcff185939426, 0x3fd94f6cb49b16f7,
    0x401899c4d8373c8f, 0xbfe3961b8e1d16d3,
    0xbfe4dd5dbac740ba, 0xbfded89774943452,
    0xc000c2f0bb28b5e9, 0x3f9582c18b3ef520,
    0xc005f40fa0fe6cc3, 0xc0005bc36b7af087,
    0x40188c35030cf893, 0xbff08e414ac09e55,
    0x3ff4c58c1ae450e0, 0x4011e1c6c1c37fc3,
    0x401572578e0119fd, 0x4015c9fff1fd896e,
    0xbfefae6422a04780, 0x3ffd664aa5f8c0bc,
    0xc009426c3b113726, 0xc0138acb2b4b5540,
    0xc006ea15cd7c3bf0, 0x40044c0543335b94,
    0xbfdf73379ab392ab, 0x3fe8f8199800aee8,
    0x3fe6c05b7158db18, 0xbfce2e349e1bafe4,
    0xbff0c9a299b59c45, 0xc0062ae98e15fe55,
    0xbff5f21df474d2fc, 0xbff963c19ef3ac8c,
    0xbff0c2f1d1353a77, 0xbff37ec0b9dad7a8,
    0xbff062493dbd4a16, 0x3fe9e2e9fc972268,
    0xbfff70ae7561e000, 0xc0062eaec04b0331,
    0x40101dc4b6539839, 0xbf9a2fb9237c9280,
    0xbffc0e54301ca17a, 0x3fc466e06b9c3b30,
    0x3fbbfa36d03116a0, 0xbfd971fb45a128be,
    0xc000ef6660a67f9c, 0xbfe41149d4a012cf,
    0x3ffda0c897f7478f, 0xbffd9272765c1f61,
    0xc00037dcdf23d1e3, 0xbfe3bdbbb35fa0d2,
    0xbffd23213fc4cc33, 0xbfdac6d84ebd4bdc,
    0xbfc5667b647c2cc2, 0xbfde70754b71669c,
    0xbff5cdc86f729b6f, 0x3fe545280baf1d00,
    0x3ff0cfd59a68636a, 0x3fd4de8f422cb7f4,
    0x3ff27cde0285a5b9, 0x400529e7e475d0ea,
    0xbff895a6e054219a, 0xc0116709b02028a5,
    0x40157932dfc636f6, 0xc00aa513ec109136,
    0xbff4804023c5f4c4, 0x3fbb4ce8d70c42c8,
    0x3ff9dcb438a88efe, 0xc001de3316da9ca1,
    0x40024e4f6622802c, 0x3ff6ed1e5b3099dc,
    0x3fbad3234960a960, 0x4005d38c728f842c,
    0x40079775d3648d06, 0x400004e3c2508b10,
    0x3fded032a11a6790, 0xbfe8fec59187f65c,
    0x3ff63851515d8f2b, 0x3ff5cd1f6df05f08,
    0xbfe3650e54cb9145, 0x3fe46df2e315729c,
    0x3fca9ed4136c1a9c, 0x3ff67d3896109d9e,
    0xbfd96cda29085382, 0x3ff8222607222104,
    0x3fd6ecf412352b31, 0xc0133a155e0d9f18,
    0x3fa9d62a60ed1900, 0xbfcce44bbbc5b720,
    0xbfffd545b31f8ff1, 0x3fd40ed2831d61b8,
    0xbfdbbaea80808224, 0x3fe3e2ef964511c0,
    0x3fdf69ec1cd6c7b8, 0x400a60ea23f1d1f9,
    0x400a1e1ec3fb749b, 0x4007b1dd8c1bd81c,
    0xbfeb9ae8a62c1628, 0x40042ba497961030,
    0xbfd976d9461480dc, 0xc0026a03e8a80a2a,
    0x4011a9ade1ba5c4a, 0xbff1b285d592b9cf,
    0x400255bbf47e2f32, 0xc001a6f77cc758d6,
    0x4006bec9f33a2372, 0x3fec28deed885ee2,
    0x3fdf0ddfee22e094, 0xbfe83b289f154ccb,
    0xbfe594b2301cc9ca, 0xbfdb650982c18b14,
    0x3ff8c0e96f82f67b, 0x3fd2d650903cc3c0,
    0x3fffc002d0bc09f2, 0x400cc16858413a8c,
    0x40020cfd6dcbd6f3, 0x3f90924a2b1a80a0,
    0xc0012b9556aaea6d, 0x3ff2149918b97c39,
    0x3fe22a838f664310, 0x3fffd66fbdc8dd8b,
    0xc0154e5da924e7fa, 0xc0062404356205fe,
    0xc00185f15dd78274, 0xbfde662a088c6214,
    0x3fe12924d4537700, 0x400380b7318f5c34,
    0x40162700a3d12695, 0x3ff60a2e74c7c608,
    0xc00cce20b85b87d3, 0x401192f2c3754690,
    0x4008c3ad134926e2, 0xbffde0fb93c71861,
    0x3f8c0b4ba145c380, 0xbfdcfba461329040,
    0xc00be4b3a08cc42d, 0xbff3eb3fe6ebfb8e,
    0x4005db2b0765c946, 0xc00d40902d3a1406,
    0xbfe86acd04e9a6a0, 0x3fe1f9bee158d9ce,
    0xc007992270240da6, 0x3ff6e56236b741ac,
    0x3ff89b7e2ac008ce, 0xc001f7fb682804ef,
    0xc00eed9c552f2e39, 0xc003b6ca5a6f4344,
    0xbfe275f9ae16933f, 0x3fd02613fb1f1198,
    0xbffa4109155abb22, 0x3feae9672a1b6cc6,
    0xc0130519534d0a76, 0x400348e752523f9a,
    0xc01065692fa519e4, 0x3fe3546b85503207,
    0xbffc71b1af25fb6a, 0x3ffbc3a1097f88df,
    0xbff27b02f694a4c7, 0xbf8987cc78544a00,
    0x4000fe09ce23e598, 0x4013a471c102561a,
    0xbfdba169ad9df87c, 0xc0037d1f3a77f8c5,
    0x3fd296ada2537eda, 0xbfee66b48c9f63bd,
    0x40101aa4ea471d98, 0x4006efe5fd1bf59a,
    0xbffa9854c1ce7e70, 0x3ff368d36b0b8447,
    0xc002d6cf848e7882, 0xbfee4425d1e9e140,
    0xbfe0770dd849774a, 0x3fd548cca01d5d34,
    0x3feb0571682f9a7a, 0x400757da22f98514,
    0x3fe50bfd0b7522a4, 0xc003a445423dac59,
    0xc00312663afd71b4, 0xbfda18dc0e230468,
    0xc0134528c8599ee8, 0xbfc973a9c65a7440,
    0xbfccfcdc86f57628, 0xbfd81661295040dc,
    0x3ffb14c7a1c88d6d, 0x40126367716c19cd,
    0x400338a644ccdf20, 0xc00073197e4a4a71,
    0xbfed4e5b2e75ca58, 0x3ff825e6f419d9fa,
    0x400ca2f715c9866d, 0x3fd4b9253f59aa19,
    0xbfab44afeeae9000, 0x40076243882388a0,
    0x3feb30e646434cc8, 0xc00c9534fc2460a6,
    0xbff7be3c8a5041d4, 0xc005836994008a4d,
    0xc001ce703d5a670a, 0x3fe0161db0103c22,
    0xbff792fa8aae0eae, 0x3fbdbbc9ab4d1410,
    0x40065940a4038e62, 0xbff7d3caeb6e5364,
    0x4008e077413cb05e, 0x3ff79e21ef268bc1,
    0xbff0bfd371da2539, 0x3fef2989ec71bd82,
    0x3fe864a8cc8c2e2c, 0xbfd69f1cae4a9b00,
    0xc018f62fe44a1a84, 0xbff521008a409759,
    0x3fe9c62780512be6, 0x4006165e3e4500e2,
    0x400770762a6cb84f, 0xbfb0c2026c09775c,
    0xbfd396a87a3a9898, 0x401346188367fa1d,
    0xc00657bddb2963eb, 0x3feb4eb74e7da409,
    0x40122773f7fe5ad3, 0x400f6492de81ac3a,
    0xbff0db70614f447a, 0x40178b494fcf6698,
    0xbfcf4c6f7386daf8, 0xbfbf5a725c7e5510,
    0x400794f61d0329d8, 0x3ffbe68b41fdb5f4,
    0xbfe36080c9af7dda, 0x3fe2c1e0a37a3920,
    0x3ff3b3d892c979fc, 0x3fd68f4d38104320,
    0x3ff95d4b0722549a, 0x400576af6feef700,
    0x4011de0eddb61e74, 0xbffdfd4c04ed8346,
    0x400c2e3c039b041e, 0x3ff752fcd9194d0a,
    0xbffc2a338cd02e48, 0xbfc765fb697d00ce,
    0xbfe992ed22174a0c, 0x40055f6af23d3380,
    0xbfe939dc0fb16d1e, 0x3fd5bdcfc1fdb4f8,
    0xc003be6188e9ba8e, 0xc016f5de9957310d,
    0x3fe600e335c9631d, 0x3faf8fcb64d6a510,
    0x3ff8b7ccf106b36e, 0x400468599360eccd,
    0xbff08f5077485c24, 0xbfb5108a0ac6f474,
    0xbff174d3efc47b73, 0x3ff5864c161898fa,
    0xc00aa1145ee1213e, 0xbffaec1589a38940,
    0xbfe89b31aac912c0, 0x3fd3146a826ea034,
    0x400aef9c3a55acdc, 0xc00d5825b4d9c8d1,
    0x4007fdd456b9bd3e, 0x3fddc2be13c39a46,
    0x3ff3f20848e6b9a5, 0xc010fcb7f9fe3522,
    0xbfe0d488edc4a17f, 0x4003e8b75e18104a,
    0xbff0224af2e35ce4, 0xc0075fc6e7f635c5,
    0x3ffdbf5d5a26e78a, 0xbfe1cb7d9f026042,
    0x40143716fb00a61c, 0xc00eb16ddc2ba211,
    0x3ff94d818e281f78, 0x3fd8dc941ffd92d6,
    0xc014730d9d13813c, 0xbfd60e9520ecb68e,
    0xbffc89cd936f553d, 0x3fdbece0129c3d48,
    0x3fd0bc4459e7eac1, 0xc004c5d70a81b888,
    0xc01295a4525a1e3a, 0xbff4bd3663c8939c,
    0xbffc6b3cf28a8900, 0x3ff1ae1fe8f5ff60,
    0xc00bea7af0a643c9, 0x3fe4a7ac250b9567,
    0xbfcc0e0573c5e628, 0x400cdde5834fd6e6,
    0x3ff393abbb497077, 0x3fe381cd7522eee6,
    0xbff64ecd32e70822, 0xbfef186eacd43f62,
    0xc00d66999b09ced4, 0x3fac30c5e845c990,
    0xc007944659ed5194, 0xbfed18e522bff15e,
    0x40110c75d78f8532, 0x3ffa80d9016c83c8,
    0xc005de68da691e86, 0xbfe892fbc538a5ec,
    0xc0067180e6bf4b15, 0x3fe642e2584cbb6e,
    0x40039f3d770621f4, 0x4008d744bb8b4fe8,
    0xbffb58a42c390c80, 0xbfbda521f733c380,
    0xbfd688daf05f29d8, 0xbfae0b8135289b40,
    0xc009da5adae018a2, 0xbffe285c18cb7078,
    0xbff1796ac9fd28e4, 0x400c66587924f43f,
    0xbff1765fecd58cb0, 0x3fecd950adec0aac,
    0x3fe166a003fdb07c, 0xbffb2bb88378317f,
    0xbfc3533277b7697c, 0xbfca9f0751c22160,
    0xbff39fe61549bc48, 0x400255ed141952ab,
    0x4005c3988a2d7b21, 0x3fe29963a1e13b2d,
    0xbff990b8393fb211, 0x3ff2c64dc37e3bca,
    0xbff05ce4e93e09af, 0xc006106340cbfe33,
    0x3fdbc43c3a613d2c, 0xbff919ab8e2f75b7,
    0x3fe4e429b2304cb6, 0xbffd815fc946195f,
    0x40103be2f1ab432c, 0xbffeb1cba91ae1b4,
    0xbfffb691a1546dca, 0xbfce70ae5eba5750,
    0x3fead5bae46e6d8c, 0xbfdda64d05ec16e8,
    0x40006d26aa5152df, 0xbff9f27b40e4562c,
    0x3ff8b3e0fbb3402a, 0xbfea64d96e84e0ca,
    0xbff202cc35ddd958, 0x4010eab0301fe51c,
    0xbfe7f8192c1734ce, 0x400b1e8795c2b39a,
    0xbfef021a3d238a12, 0x3fda6c473b37681e,
    0x3fe8e12b767bf842, 0x4004b50b0ca7456e,
    0xc00328bf58800cbe, 0xbfc44b75508876d8,
    0x40000b4c451f81ac, 0xc00cfe56683a55fc,
    0x3ff9862231fa10fa, 0xc00512a45624747a,
    0x3fd1678da0819142, 0xc001158cc88c1c25,
    0x3fd61e47885c224c, 0x40001df08db9024e,
    0x400a49089605c3ec, 0xbf894e998a0b2940,
    0x400ce79058d8753a, 0xbfead7e828b89dac,
    0xbfe41f2bcfc974dc, 0x40061be40e90e899,
    0x3ff3e2668f188efe, 0xbfe17cdb36391978,
    0x3fcdcdd293722bf0, 0xbff9dec168428180,
    0x3fbdc88956d5cc30, 0x3fe9544683056c25,
    0x3ffb651a24aee7be, 0x3fe632d918bd75a8,
    0xc00a1779ca7a784b, 0x3fe97f8a480b8076,
    0xbfd376958783c050, 0x3fdf21ab654f1840,
    0xbfebabc24ec613c8, 0x3fdd692adff8b0cc,
    0xc009dbd35f4b6e0f, 0xc0018c766be035a5,
    0x3fee4b372034bc54, 0xbff845d2489f6cd5,
    0x3febc5d5815ee6bc, 0xbfd5e4376cd6e1ba,
    0x400acbfdf015c2c0, 0xbff59afe89a332e7,
    0x3fd2946d24f8e5f8, 0x3fb07c28ccaa38b8,
    0x3ff32637441e7199, 0xc00a131ceb77e349,
    0x40054ac1dd6c465b, 0xbfe2fb4c25538c34,
    0xbff2747a7f961b8c, 0x3fd997af02d89388,
    0xbfdf8564837957b0, 0x40031c0074679830,
    0xbfd86edc5dbc35c4, 0xbffaa1b6504535b1,
    0x4004c5cda57c2f07, 0xbffb2c9059b92478,
    0xbfe6e5abf386038a, 0x4003f6d17c0cf102,
    0xbfeeb12048b9ea1a, 0x4002bf191021dcea,
    0x3feaf8fc0be582e8, 0xbfe6e48bb7714c3c,
    0x40016237af12db64, 0xc007fa7d7f3dd77a,
    0x400349717fe87d1d, 0x3fec210c550dfb00,
    0xbff12fb604398e29, 0xbfe2d4364ba70b0a,
    0x3fface88e040c1e8, 0xbfc0ae716fc79300,
    0xc0060b813742d34d, 0xc002a7204cb355ce,
    0xbfe260f0df22746b, 0x4010d5cb56d18c15,
    0x3ffc882fef25af35, 0xc00123657217b7ce,
    0x3fc917d341baa438, 0xbfe795c803953934,
    0xbffa2026f3be168c, 0xc001574ce77f8663,
    0xbfe947990d0c3380, 0x3fde70558c873270,
    0xbfefd9ecf25ccba0, 0xbfe2bf79f1770870,
    0x40040550cbdb6f8c, 0xbff07168cefb432c,
    0xbfded7ecdf1ee6ea, 0x3ff74532ae241b34,
    0x3fedca8b7e4b5bd5, 0xbfe6f2d1c9548776,
    0xbfd311766fe6d150, 0xc004eaab83edbbbc,
    0xbfee5ab8803eedc2, 0x3fc64be77bacba20,
    0x3fe8f24b8ad04ea7, 0x400cb646811d7ab6,
    0x40030e442dfb3168, 0xbff9c00ac02b064a,
    0xbffa2904f3674813, 0xbff1b2840999ed84,
    0xbfdb0cc3874c73c0, 0x3ff8c586a8cc48e6,
    0xbfe8b4091a09f548, 0x4006ab1bed0e7e0b,
    0xc01060e1c44b601a, 0x3fea3d6342dba2d8,
    0x400e2c66fe4d9e8f, 0xbfbcc0819ec16da0,
    0xbff5bc778b6bad16, 0xbfb0343d3dd92280,
    0xbfeaba8c4ec9472a, 0xbfe30090ea9c47ab,
    0xbfb5ac5c833a22f0, 0xbfe37c4a151fd603,
    0xc00c8333f4cddd6c, 0xbfd40db30a9ca24a,
    0x401181e64d32aa74, 0xbff93c7312e5652b,
    0xc00bb4213cb2aa63, 0x40057cb660f74d26,
    0x3fef5183538f2ad0, 0xbfdfc661ffa5c868,
    0x3fdaaa1bd8f2d9d4, 0xbfe317cd609d2237,
    0xbff78771440f70ba, 0xbff6886d673b8768,
    0xc015fd0d531533c6, 0x3fd1f8d40f75943d,
    0x3ff2adbd350c02f8, 0xbfe125900a8a2eb0,
    0xbff7cd4bec9ea8ec, 0xc00ec1b5fa92f6de,
    0x3ffe642934201840, 0x3ffefff650909755,
    0xbff968f9fe49a278, 0x3fea7bc4cd6b7ede,
    0x3fe0b75863c7fd04, 0x3fcbe82d32f7b15c,
    0xbfe0c6ed6d26f954, 0xbfe68e39a51a3514,
    0xbfeaf1d751433864, 0xc00293c579c9948e,
    0xbfd250321f9550b3, 0x3fe7cf0849df8d13,
    0xbfdf9af9025b93c0, 0x3fc6acdade5eb512,
    0xc0064f230b7fadc8, 0xc0115d46a01d1d1a,
    0x3fece99c0ed66ab6, 0x3ff4727fcb6c723c,
    0xbfef68a5180f81ca, 0x3ff9aef1b9ae3e16,
    0x3fbf1cffd32f8500, 0xc0013ecdedf0ec88,
    0xc000c53ea3c4aeef, 0xc012d389bb96b639,
    0xbfdc51a6386c048c, 0xc0081803d2ebea83,
    0x3ffb0c6697250484, 0xc00caee9e887aee1,
    0xbff6d097a0f4c002, 0x3fd47c73824e60ac,
    0xbfbf71214a21f728, 0x400a2c74fde1060e,
    0x400b67e102d91e5b, 0x3fce826bd81e21b6,
    0x3fe4d856c517efaa, 0x3ffbb0ec27080202,
    0xbfe6acec994b290c, 0x3fff9542df3fe9ed,
    0xbff3dc52cc2da680, 0xbff2152d9a408b55,
    0xc0008bc948fa8c8c, 0x3fef26440743db65,
    0xbffb063c44abd6c1, 0x3fc5fab2deac1800,
    0x3fdc05eb2021890a, 0xbfd3d7226c11e195,
    0x40019165361a30f0, 0x3fd350970049d3f4,
    0x3ffc27e1198bfa9f, 0x3fc1bf1cfe0e3890,
    0x3fdae4d4cdacadac, 0xbfd00e095302d426,
    0x401262adeddb3ae7, 0x3fe461cf1963e898,
    0x40008252fb4f5a50, 0x3fd2860f76260e24,
    0x40054bbe1f605beb, 0x3ff3639cf751b783,
    0x400da94f413a3c7b, 0xbfe28816857a3ced,
    0x3fc6361a2dee0b50, 0x3fe21f5d2df7eca6,
    0x40009def10099b83, 0xc00bfda7f5987d24,
    0xbfd81d75e29c1fc8, 0xc0048870a02984d2,
    0xc00e5b783795204b, 0x3ff6e7c68fa45994,
    0x3fb358aa20ff0b40, 0xbff318c58f762fe3,
    0xc00682dca352b64f, 0x3fda0ff711338611,
    0x3fe69cf70beab82a, 0x3fdf44d450ed7e9c,
    0x3ff9061704b3d73e, 0x3ff850e808cfa60e,
    0x4011082d85876b2b, 0x401314e85ab30c7a,
    0x4011da18d0b5fcf0, 0x4007eb8b749fce46,
    0xbfd7cc6b9fad5ef8, 0xbfff6fc4fde3ad86,
    0x3ff2074cc0b75e95, 0x3ffab004caea7310,
    0xbfb51b9f834a7a90, 0x400d1a2fd738e086,
    0xc0030de93906339d, 0x40031abcd7d3da06,
    0xbfffee5eac70ead2, 0xbff2f5a453028c0c,
    0x3fce86719a7a4648, 0x3fe09722f37856fe,
    0xc009fe74b5d8abef, 0x3feb666c145fbb08,
    0x3ff6a900026ae30f, 0x400917a5cc05f369,
    0xc0103202846078be, 0xbfe39dfd815e6504,
    0xbff39676ef578216, 0x3fe1461fd4149bf6,
    0xbfee583db6cd3174, 0x400a6d9e66c9b03f,
    0xbfe2e911adfc926f, 0xbff40fded65956ac,
    0x3feee6f7c705fc5f, 0xbfefc6bcfeeebd78,
    0xbfd2146b8a02da20, 0x40033ebdca0a448e,
    0xbff8a4a21496d606, 0x40016cc0b28bc970,
    0xc011171537a86e14, 0x3ff68df6849fabeb,
    0xbff243afd818a1f8, 0x4003e9d5ed831f96,
    0xc00ca691007d618d, 0x3fa1683e9a14c8c0,
    0xc007507c9712cef0, 0x3fca874d590ed410,
    0x4002f7b904de5d5a, 0x3fff9acad6fe632f,
    0xbff8c0f0e5489f06, 0x4016c872b1a26b32,
    0xbfe3ad6caa276047, 0x3ff394a8cb2107fc,
    0x4008fe106c07abce, 0x3fc276827c20e53c,
    0x3fe4e12d6878a0b2, 0xc00741914c778a08,
    0xbfff26459e1d4f0e, 0xbffdf44c8ce9e53e,
    0xbfe5538c81384f4c, 0xbff39655a3793226,
    0x3fcd80e7300dcaf8, 0xc00b533e8c6b4d9e,
    0xc01a0936793f9e64, 0xbffefc0f68265bde,
    0xc001d3e98ddb1ae5, 0xbffab95ecc57c970,
    0x3ff7d1bf43c7fa04, 0x3ff59b5ef83d85b0,
    0xc00417c262f7257a, 0x3fed14cf371a9e9e,
    0xbff0cfc3c33ccbd4, 0xc010a5ef8cb3a4b4,
    0xbff550a08a813158, 0xbffb3e53f4042eca,
    0xbfe58276e5705ff2, 0xc009a09365448dcf,
    0x3feb21cce8969b79, 0x3fefb8c61af73864,
    0x3ff70e65bdee4ae9, 0xc00efd2abd098028,
    0xc004d33a5f481304, 0x400adcff342bad22,
    0x40123d762575a99e, 0xc011f9b261e959ce,
    0x3fd502b0a43b07df, 0x3ff0e057ac044266,
    0x3ff58395d27c712d, 0x4006b549d72c2bdc,
    0xc0010187ad3aa7b4, 0x3ffb0fa414ced042,
    0x4003dcd5ab6f9654, 0x400ed4b835b2fc89,
    0x3fd2ea75f1d84a80, 0xc00374168909c467,
    0xc0021ee5b85064df, 0xbfd534c69c347964,
    0x3ff0c46e3662e9e6, 0x40043de481250172,
    0xbff29256518b0c7c, 0x400913d108b88c75,
    0x400b9885edb9b042, 0x3fea3822a7ad822e,
    0xbfb32e34b53ac660, 0xc0005408aeccfcef,
    0xbfc11baac1d41aac, 0xc006657989076336,
    0xc00fe9b18e151e5a, 0xbfe9346a810f5511,
    0xbfc261cc1d161e40, 0x3fe0950408e26113,
    0xbfd5963115cb3554, 0x3ff4447691f4e7e1,
    0x400eafd90f0b272e, 0x3ff25d1cece9fc72,
    0x3ffdf89b172f0152, 0xc001d9f8e2c89962,
    0x400cb410b7e66b08, 0xbfcb6a4804e40470,
    0x3fe3eaf291351834, 0x3fd496262010cf96,
    0xbff3500f3de10ce8, 0x4004802d92079a54,
    0xbffa56d2e59e38fc, 0xbff7367f4ceda442,
    0x400d7f211cbc4cb8, 0xbfbc9d27613cd726,
    0x3fef5e20e84b3019, 0x400e0538d8e43cc6,
    0x3ff61c9cc1d11777, 0x3fe7d064a927c923,
    0x3fbde463809fe610, 0x3fe25d779370542b,
    0x400600f052189149, 0xbfe19a1fdbce5885,
    0xbffd2d118a304179, 0xc0086508303ca470,
    0x400751d958e301f8, 0x3ff5a2f4fa2c1466,
    0x400670f3dfeb08e5, 0x3ff933e9503107ed,
    0xbfb143c414433168, 0x401118087a49d4ac,
    0x3fd98981cf7fdc00, 0x3f8702c4599aa220,
    0x3fdcb9e820ca0334, 0xbfdbe3b3af209755,
    0xbffa8675339ff7fa, 0x4005e07d2b8b236e,
    0xc00bdc62dc84179a, 0x3ffde044f7162cb5,
    0xc00523d737e4620d, 0xc0110833eb79bad0,
    0x4001d4aab36d53b1, 0x401169dcb5c03110,
    0xc00531fe3fa43e83, 0xbff6a389a7a02b96,
    0xc008a8cf5bfaba2f, 0xc003482f50677e96,
    0xbfe374a183d59a35, 0xc006d15585d128e8,
    0x400c6c4357240429, 0xc00387d49255f5a2,
    0xc00308c58a55a3de, 0xc01563001894db7b,
    0x3fe6102868dfd1c4, 0x3ff34b899f2d4515,
    0xbfe659278e2e0b2e, 0xc00a92dbdc237a52,
    0xbfe6469edbfb307e, 0xbfe8a74bb3f00e6c,
    0xbfc129a2648004ae, 0x3fd88d06956f5e26,
    0xbfb00b10cbd0dce8, 0xbff1854f8e97ccc5,
    0xbfd9ec37d8cae054, 0xc0043f3f3c192f2e,
    0x3fe83437fc29cada, 0x3fd77cadd6cfea9c,
    0x3ff1339964cb6efa, 0xbfd48b6fb13142f6,
    0x4013144613bd130d, 0xc0044f73e1277a5a,
    0xc00fa8f0fd6914e6, 0xc00c7350f1534ac7,
    0xc00afc0981fffea7, 0x40117989615baa2d,
    0xbfe5e137acdda46a, 0x4005799661977009,
    0xc014a6ba6697e287, 0x3ff44f6b6085a8b7,
    0x3fec2d982e3c29c2, 0x4008491e36ee9768,
    0xbfdc5fd54fe2a778, 0x4002e2b0780b43af,
    0xc002259ab3dbb5f0, 0x4000a4bfa7f13ad4,
    0xbff11e83df264c24, 0xbff745bf6a320c0d,
    0x400c1d522008c87f, 0x3ff7dd5bafbde318,
    0x4003625494b8588f, 0x40098c5d4b28d248,
    0xbffa62afa933c8ba, 0x3fd79878cb9d74f2,
    0x3ff953286eb7e693, 0x3fff8006318aec56,
    0x3fe3b5de5a0ff2a3, 0xc001e0055895db74,
    0x400721c51ff21a70, 0xbfc8727d32c35590,
    0xbfeba19c4473ee20, 0x3fd7cbbbed6da5a8,
    0x40010178fa15139e, 0x3fbbbcc1015fc7bc,
    0x3ffb6ab37b50e85a, 0x3ff1923049bf88c7,
    0x3ffd818adfd022a4, 0x3ff22aa60f187a66,
    0xbff0306133dfca64, 0xc000acd69eba4886,
    0x3fec586e5cbb6ab1, 0xc004511646b64659,
    0x3fe3b74783275cee, 0xc001e2a80564f1b5,
    0xc016767828a4d965, 0x3ff54946d6b6656e,
    0xbfde7b80685a2c98, 0x3fe92b28f114b45e,
    0xbfe3f0022ab8830c, 0x3ff684cbb3ebcf8f,
    0x4007bd834cf3970e, 0xbfff96f6dd8845cd,
    0xbffceca60d6ea935, 0x400434859193ab18,
    0xc013f41ba46f961f, 0x3fe0a4b82a2d649b,
    0x3ff9b74bd7960936, 0x4016dbec4b44d78e,
    0xc00581b901a72aaf, 0xc00d8827274a9366,
    0xbff61c197c16abe4, 0xbff392fac025b147,
    0x4000c9c4e657e0bf, 0x3ffb3f4d354af6ca,
    0xc00798a1966f5b12, 0x3fa4fe67ba068f80,
    0xc007896d6689aa87, 0x4001b423f5470b47,
    0x400839a5bb0311f4, 0xbfeffd6cc5c136a2,
    0x3fff93a039b67ca6, 0x3fd8c09e3db19240,
    0xbfc03d281c2c51a2, 0xbfe546e10442cc74,
    0x3ffe9cd65d928319, 0x3ff8b83668fcb8c2,
    0x3ff92338b2b0a54b, 0x3ffc514ad5190be3,
    0xbff8fd12893b27b3, 0x3ffc0a082f9a0aad,
    0xbfb83f5c5fcc2e60, 0x3fd9aafe684b15a4,
    0xbff1ce844c4b619a, 0x400496f66757416e,
    0xbfc872cdc116b79c, 0xbff056e0157bb1ad,
    0xc0056ff1ad19a805, 0xbff20fd02882c5c0,
    0x4000734ff8bf32d6, 0x3ff8cab4e9549c84,
    0xbfee814da823d3ed, 0xbfb35e702cacd234,
    0x3fdd57f381d91933, 0xc007dfa494915317,
    0x4006505d21e35911, 0xbfffe109d0f28c5c,
    0xc0048ec26e46a947, 0x40002b5d2cbcdd7e,
    0xbfebe85f0e99ae18, 0x3ffee452886a0348,
    0x3fc4a8ccddeb1120, 0x3fe6c04f6d584616,
    0x3fd6700790e1858e, 0xc01c0da74ec2623c,
    0xbf8934373c573ac0, 0x40052dc67836d274,
    0x3fe7375ea6d6772c, 0xbff2e6daf4eee353,
    0x3fcd299a4269d40c, 0xc005b43bde8d3bee,
    0x3feec745e63a1788, 0x3ff4ddd8c6eece6e,
    0xbfe8d739a40b4c26, 0xbfd86e4d662bd710,
    0x3ff23da231c340ce, 0x3ff7a66eec78b5b0,
    0xc00eb3cc266b2bbd, 0x3fb142e288b133a0,
    0xbff23078eabe1a76, 0x3fb1c0e8ef291a10,
    0xc012333cf3bb4a43, 0x3ffbf4ed8ccf5ef8,
    0x4009b25c8991d869, 0xbff2272a001c7d4a,
    0x3fffb84b9b28c0ff, 0x3ff7aabc5fc3a208,
    0xc01196d22b203ac8, 0x3feba21ef1d5bd2e,
    0x3ff16182948936de, 0x3fe3ab1ae4f48045,
    0xbfeed460b2bf3e48, 0x4000d65ef745d4ad,
    0x3ffc8b2660962286, 0x3fed0d418958cb50,
    0xc00a7b3896c8cb19, 0x400c6a60c793320c,
    0xc00d9fa2757635aa, 0x400ad707f603dff6,
    0x3fc101dd8c78e7f0, 0x4000c78df5a74c18,
    0x4002ade2dfd0cdf7, 0x4010e4da161c874a,
    0x3ff0f89a4dd79670, 0xc0033cfcd114c270,
    0x3ff2ec86aaf8384e, 0x3ff2b4774898010f,
    0xbfd45f7e0e0018e8, 0xbfe73772f0db9948,
    0x3fe96ee06a17c958, 0x400e5e7438de8d43,
    0xbfc9f5b60a9cad48, 0x3feda541640b4545,
    0x3f9b4fdbc95238c0, 0xbfe6c1ee285c9ed6,
    0x40105604da3ee594, 0x4008d5311cd9ed10,
    0x3fe59fd5a7760a60, 0xc006a1237807911a,
    0xbffc84d90adef51d, 0xbfd3b81c8c6a147d,
    0xbfad04bafbf355c0, 0xc00118c34a14a0f6,
    0x4006e9aa969003ff, 0x40007049c39f002c,
    0x401e090415e0badd, 0x3ff4607eb24e4e80,
    0xc011552a0c20b42b, 0xbfa6f5f8f86a72a8,
    0x3ffddbf4872e5536, 0x4008c2e192304098,
    0xbfeb16a191778048, 0x3fc3b15aafac932c,
    0x40026372d81227fa, 0x400294c21316eee9,
    0x400661fde12c1ab4, 0x3fc4f144f07d83e4,
    0xc01093023c99a033, 0xc0101c99650278a4,
    0xc011860f09815a8a, 0x3ffb150f3cbd630f,
    0x400d0c59b58f9058, 0x3fd3803002b3b19c,
    0x3ff8365c46ca2069, 0xbff30b3d6488968f,
    0x4000566e23ea4d23, 0xc000aa6a35ec0cc5,
    0x4002a86611911d30, 0xbfd0003e6cf1ea4c,
    0x400c58ee212f004b, 0xbffb556e8125003c,
    0x3fede08bf4bbc214, 0xbff8101f3a229995,
    0x3ffd467a09d9d9ec, 0x3fef6b73121f9522,
    0x400d0b8356c5081f, 0xbff11c53896d9a7a,
    0x4013fb2dcf5f0f60, 0xbffcdbe1dd1c673f,
    0x4006eb8d9ccdf3ee, 0x3fd3a4f3f97ec88c,
    0xc00bff21476d3974, 0x3fe9e3e818066a83,
    0x3fee6fe6b8497b1e, 0xbfbf066802d1d6b0,
    0xc009287856df0294, 0xbfa0f262371c8240,
    0xbfcd31fa30e2ccb8, 0xbff685a7550e58fb,
    0x3fe6b09afbc82b26, 0xbfc53613bd8c07f8,
    0x400b55be658f63e8, 0x3ff7e64bbe550090,
    0x3ff5777d11bb6568, 0xbfc1d79f293f1734,
    0x3ff3273958941fee, 0x3ff348c133067f33,
    0xbffd8d2b5bbe08cc, 0xc0067df0e9a8f2fd,
    0x3ffb9e7d30602d83, 0x400237d4b9bd6f82,
    0xc00211817c95dee8, 0x40018295b5b82580,
    0xc001136394b40630, 0xbfd0cfec3751849c,
    0xc008e317a4e14d3a, 0x3fe698cce2d5b4c4,
    0x3fde5ec025e3ee88, 0x3fde23a6a8db0244,
    0x3fe47ab4e2a5110a, 0x40052efc21fd236d,
    0xbff0ce197010840e, 0xbfbbe6f7acc5cc90,
    0xc00e662b360eab3a, 0xbff1e5968b67048e,
    0xc0065bd580db9874, 0xbff94de48d0b6054,
    0x400d59ad427039e4, 0xbfe5829266c04a0b,
    0x4001527d74371a89, 0xc0042d53ac71f64a,
    0x3fe140d4ae9ae50a, 0x3ffa16151655b1ab,
    0xbfe27ef639e44f8b, 0xc000b7964f966477,
    0x400a61421f2085ed, 0x4002dcf540616732,
    0xbfb2db941e55fc20, 0xbff9370c77daef60,
    0x3ff04f509ecdec6e, 0x3ff6a4ac85b975be,
    0xbfe3a85bc63a426f, 0x3fa22ba2d5b86160,
    0x3ff15007b8a25685, 0xbfdf0929db334f91,
    0xc001eca93ce0cdde, 0x3ff4eefd98e08fe1,
    0xc00066201c9316f3, 0xbffe0c9b367d0c5c,
    0x40041966ec4e85b2, 0x3fcef9b7d74c55be,
    0x3fc120bc789fc96c, 0xc0163a4cdd756a59,
    0xbfd07c4858d1c3f4, 0x401703d8439beb21,
    0x40012b27d14e0610, 0x3fe195f1565dfd0e,
    0x3ff957c922e64ec6, 0x400b0eccf5550e76,
    0x40099685e7884f73, 0x3ff0511b0e373770,
    0x3fbba373cfcde738, 0xbfc161679ec23d08,
    0x3fd3504e781737b2, 0x3fa57da595021530,
    0xbfcbdb9165cdf03c, 0x400b76e6e8bd9b36,
    0x40011d33fc953e4e, 0x4006b728ba50f61e,
    0x3ffd640bc91e9a40, 0x3fe01a220f847b79,
    0xbfd31c31a8c9eeac, 0x3ff1f05c54642df4,
    0xbff05b7ba06b1ece, 0xc0069fbe9ae6a0d8,
    0x3fb05d6c75fd8370, 0x4001470bf93731a2,
    0x3ff9a0351016ded6, 0x3ff2cdc0a89cb234,
    0xbfc5b98f3a5d6cf8, 0xbfebe8124441853a,
    0xbfefc767d97f271a, 0x400667604c24a2a3,
    0xc011108b07de9cdd, 0x3ffe162a8baa2a39,
    0xbffbb6b9da4dd9fa, 0xbffb4161baddf6e0,
    0xc0066332b37b4778, 0xbff8ccf238ed16e3,
    0xbff0174c258b45a1, 0xc00d0455e32238a0,
    0xbfd9a8207f95626a, 0xbff536d74285d51c,
    0xc003c6cc86421bda, 0xc0068a743c2a96b5,
    0x3ffd0c855979fa44, 0xbfe0914cb8bc1e13,
    0xbff8183808fc2b40, 0xc0020f2a21b1938c,
    0xc00e296a0ad8b308, 0x3fb214f923961318,
    0x40034912b1f8750d, 0x3fa3b40bb4902a80,
    0x4004377fb010481d, 0xbfeffb9154ceae49,
    0x3fe165eca9e20080, 0xbfe551a2112d6a9d,
    0xbff653b7f4258934, 0xc0065c4ce5b23e01,
    0x4002d910697fbe02, 0xbfc6cd2aad6c9590,
    0xbfc794a0b5ae1772, 0xc00b434fcd16b573,
    0x3fe9de47a2f01453, 0x3fad5d90cae9f438,
    0x3ff4d842437b4e3d, 0xbffd47d75b700d4c,
    0x4010222e8844f60d, 0xc00b7b46625663d3,
    0x3ffe4f52dbd4b090, 0xc000c52a12727cfa,
    0xc0098b3911ad6cbe, 0xbff6c15b74babd5a,
    0xbfef23b4715bbbea, 0xbff2c5dff87490cf,
    0x4008cfa5a2068909, 0xc002124495d32c0b,
    0x4003a0fb7b61eb20, 0xbff5381d1b24c6ba,
    0xc005cd8a695904d4, 0x3fe0fadd24adfb54,
    0xbfd6764d47f47d80, 0x3fea2fbfb7cd220c,
    0xbffee82e67e7264a, 0x401306d11bd11afe,
    0xbfdb093056fecd7c, 0xbfee092354729632,
    0x4015a2c336c3883a, 0x3fe77b2324f5234e,
    0x4005d10cc446f801, 0x4011c209e7afa220,
    0x400432ae89401f8e, 0xc00f253e180f6a68,
    0xc001429bc609ceb4, 0xbfa46576d5e9c000,
    0xc00a8623248b29a2, 0xc010a3ce6ef58c16,
    0xbff56e0a207c8fe1, 0x4013f70cdc7ae14d,
    0x4013ab054c100e29, 0x3ff610da0d951166,
    0xc00c11d78d6ddc52, 0x3fe48f44e7d5e61d,
    0xc012002eab11af74, 0xc000d6cc0065b6db,
    0xc00b6d832ab65162, 0xbfe50ab1c449415c,
    0x3ff4bacdcf602e96, 0xbff013ac191b3a90,
    0x3fd7949aa81cf29c, 0x400eb0b630a25b4a,
    0xbfe41095e2c8a47e, 0x3fdc5c8bda9bc0d7,
    0x3fcb2ab26d2f3cb8, 0xbffa9f56ee83e331,
    0x400df03f153d89f6, 0x3ff86c4976717343,
    0x3fd526ba8f4177a4, 0xc0006748be8679e7,
    0xbfbe7afe5c37fd70, 0xbff27a354b00f072,
    0xc0096bada1b8664b, 0x3ff3274feacf3db9,
    0x3f9795243a087c40, 0xbfd10f167c31cdaf,
    0xc000fd7c18b92642, 0xc00874e7b3e9daca,
    0x400a4f88a59c715f, 0xbffac219274bb8a0,
    0x3ff9118f5bf418f7, 0x400c8a5702e09384,
    0xbfecd3eddf162480, 0xbffc707c7f5afed8,
    0x3ff9db21c3751b14, 0x3fd161d137503b0c,
    0xbff7109b27e43f65, 0x4010cacc29e6d7ad,
    0xc007c33255de1298, 0x3fb0a9efba7a6918,
    0xbfed499d2f3f100a, 0xbfd55af2eac0db34,
    0x3ff16c96ddbcbefe, 0x3fab9985ab1d8240,
    0x3fc1d5e6778034b8, 0x3ff588e4a0acaa1e,
    0x3ff1aea34b0e1d22, 0xbfeeb895bf141df6,
    0x3fe280458a26b9bb, 0xc0039e2205bd7e87,
    0x3ff4663021c653be, 0xbff19a911396f6e5,
    0xbff4c8a34e4c9334, 0xbfe5b3d26b3c2208,
    0xc0029db027a5b894, 0x3fd64dcbd159da90,
    0x400b2d0afc4f5379, 0xbfe9c83283c6b9f9,
    0xbffb61974c560aca, 0xc0080ea82e7e39c6,
    0xc00432f721f1d28e, 0xbfe04c6d061c6a68,
    0xbfe2cc352dce3814, 0x401213ca3c5cd8af,
    0xc004239ce7900386, 0xc00d0e474dd63b5e,
    0xbfd2d2b350ddf820, 0x400b55e9b4501b7f,
    0x4009f4f4e662750b, 0xc00cee79aefc20b9,
    0xc0027737e8ba9b86, 0xbff36287d1a5cfb6,
    0x3fffdeb28ce5c9f6, 0x3ffbfd38f5564a74,
    0xbfeaa7014cfa97d2, 0xc000d605aca8bfea,
    0x3fff81515363ec61, 0x3ffdcc83dda6b04c,
    0x3ff7da166dd4564f, 0x4004d6d458b02ebc,
    0xc004487fff564b28, 0x3ff84e8c76f642b5,
    0xc003dac5e6c1b286, 0xbfd84b8b350dfdd4,
    0xc00a67f868fb14a3, 0x40122d9d17904a8d,
    0xbffa7e38d009d4b6, 0xbfd64e2941c3e313,
    0x3ff50d5031bd6f22, 0x3fca849505bb2e10,
    0x3fdefbb9e49a063f, 0xbff6e34bbb8bbf17,
    0x40042b9fa99e3d6e, 0x3fe78194e271a116,
    0x3ff5369b5b936a6e, 0x400f9d997134a371,
    0xc00427a8aef1874a, 0xbfd7d8edbd9f2c24,
    0x40048066c1cb929c, 0xc0017821b6b69388,
    0x40118a8078d17271, 0x3ffd6d73065185d4,
    0xbff2e7aeed1741a3, 0xc0044d646c71937c,
    0x3ffb6c98430879a9, 0xbfaedebb35073c30,
    0xbfff3d9487b568f4, 0x40015734908ca0ec,
    0xbffb0eda8d3f1510, 0x3fea26617f503ca4,
    0x401038c1ea420896, 0xbfc8e74c99276063,
    0x3fcec2d785bf4d66, 0x400fd5ad1d967abc,
    0x4002d7fb5bdbedc2, 0x4000420c869a6742,
    0xbfee3802eeb4bcee, 0xbfdb7304b08984f8,
    0x400b0de45916fc2c, 0x3fd987cfd618be08,
    0x3fb926dc3c2e3c59, 0xc010fc7308a397ff,
    0x3ffdd6a78bc61bb2, 0xbff8f5b1718f102a,
    0x3fe9b2532b4992a3, 0x400148e439112121,
    0x3ffa1b3e54818cf5, 0x3ff582983b52c5b0,
    0x3ff5bdcaeb6a47cc, 0x4010b442c7624d7f,
    0x3fe1eaf713d13658, 0xbff5694cb38b30da,
    0x40010a78cfa19a3c, 0x40044a3acc357d51,
    0xbfd37e8bdeb038dc, 0x400860962e7e0af4,
    0x4016b36fa27b1b4b, 0x3fea5553c8dd47c2,
    0xc00aace67c395bd8, 0xc00b56ee80c9ad5e,
    0xbfd489be1e1be103, 0xc0092c4f25b37e0c,
    0x3fe2f65595c35d9a, 0x4002612ad4320c6c,
    0x40047da7365e8986, 0xbfeabb388ada6fa4,
    0x3f84bf9ef6131680, 0xc009383586563806,
    0xbffafeab0df3b58f, 0xbfea31ccfb2e4764,
    0xc01d48e9ad3e7156, 0xbff54643dfa2333c,
    0x40084b7e2dd80a87, 0xc0049a7342a2e36a,
    0x400f9091771e25dc, 0xbfe835192a500420,
    0x3fd5f05db0dd2c94, 0x3fdec772f7baa960,
    0xbffe0e32d0bc55f8, 0x3ff3692135c7d7d0,
    0xbfd88e8a802d33c4, 0xc012a538b66355a7,
    0x4007038687085b92, 0xbff8ddc6bf88d1cd,
    0xbff38f7edfa481aa, 0x3fea8f7c283095a4,
    0x4000e9200027e4a4, 0x3fdb0d0ebb27da28,
    0xbff35ad8d7fe6523, 0xbfd26d99c223f8a2,
    0x3ff15e588bce7ebc, 0x40022fa9724ab04c,
    0x4010cba72bd1c384, 0x40010ad2b60568e6,
    0xc0018a5f5e2594bc, 0x3fff0869a5b0070c,
    0x400419b74c502462, 0xc00a023ca3f148a1,
    0x3ff34298e275f27f, 0xc002f74bf13a0f6c,
    0x3ff06a9047f172b6, 0xbfed8c94117fa6df,
    0x400977951435fcfa, 0x4013d8d7b2903132,
    0x3fe4773bf90f0544, 0xbfb7ad3456de1c00,
    0x3ff1e038010ae37a, 0x3ffaf4b153277a20,
    0xbff1fd2e4105a7e4, 0x3ff3fe198ef1ef5b,
    0xc00ae5a4bda7791e, 0x3fea67ec92242282,
    0xbffaedb2135d4a7a, 0x3fd08c6588067194,
    0xbfe77712a4d09352, 0x40050b5ec8c91340,
    0x3ff7af922becbce4, 0xbff1bb27a482979f,
    0x3fe117dc992149f6, 0xbffcdedef8db59e5,
    0x3ff57d188ef0fe23, 0xc00c7561d720b75f,
    0xbff19dc04f92d762, 0xbfe4489855da2e7a,
    0x3fd96e6d28ed72df, 0xbff107809d105121,
    0xc00ab1b71a6a8df0, 0xc0099ac8c8a414a7,
    0x3ff8e9bf65022d14, 0xc00306781ffb54e0,
    0x3ff4b81236836e8e, 0xc00ae3360346a727,
    0x3ffb110f41302846, 0xbfcb6541c263fb51,
    0xbfdf9ec6f1104888, 0x3fd6341a46aa05f0,
    0x4011c9cc9aae1371, 0x400313b464ed59c8,
    0xc00aad25b92d8db8, 0xc007fcff04d423e2,
    0x40003519f03b0293, 0xbfec3d817aa69c66,
    0xbfcb254efb962c00, 0x400ff1b3592a8f86,
    0xbff65afa9e04785c, 0xbfe0b0f9d109024b,
    0x400b67ad34f5bb0f, 0x3ff48adf1993c4dd,
    0x3fe0680150182ac7, 0xbfe47859de59bd9e,
    0x4009c306096a13cc, 0xbff6f2ebb72c8aec,
    0x400af04bcbdf21ef, 0xc000b433a60db523,
    0xc00f6f1feedbdf65, 0x3ff861bd55aecfd9,
    0xbff535af1b2536b3, 0xc01381e1460982e8,
    0xbff512eb23f2ae30, 0x4004978e2fce84f6,
    0xbfc3394320d96b3e, 0x4003353f72c4aefb,
    0x3fd7122c039c49ce, 0x3fd8fb71aa725888,
    0x4000a18b56ad43e2, 0xc0054d972a5a9496,
    0x400187ce39bf0c8f, 0x3ffcea352844f772,
    0x4013e4745b788a1a, 0xbff8c2b57468c7a4,
    0xbfd9039db4449ea4, 0xc011131acd7dc2ce,
    0x3fe7ca1aa194a0d0, 0xbff29f65be398c65,
    0x3fb631ac13a03fb8, 0xbff2ac934f6cc16b,
    0xbffec020cd95d6ea, 0xbfc43899c8bc10e8,
    0x400398da5cd7febd, 0xbffe4375b4dd8982,
    0x3ffcf82c10fb3c38, 0x3fefca3b554a050d,
    0x3fdf7954c0f4fbd8, 0x400a5bf096141e51,
    0xbfe3ca0f6b1a6e82, 0x3fecdda9889309b0,
    0x4000ee9689694bc0, 0xbfeb818be1bc587c,
    0x400ce2c92a6bf2c9, 0xbfb2016c9332b690,
    0x3fe0fe2b097ad6ac, 0xbfc3a641222a55b8,
    0x3fc2bcfedae25f8b, 0x400f808ace6289cc,
    0x3f99fd3f98bffde0, 0xbffc2df9c2a7bf86,
    0xbfd364c900278f0a, 0x3fee5f9374c42a22,
    0xc012fbb20ab174f4, 0x4005ee87bb1138d7,
    0x3ff4dac6889e5d5d, 0xc00692b2f81afae0,
    0x4005a8a489318c4e, 0xbfc72184a33550da,
    0x4002490fb4721c78, 0x3fd41695e5b421c6,
    0x40011f18e5cca4ec, 0x3fa4b1a1b0eba668,
    0x3ff756e60d4c754e, 0xbfe1cc2db873404b,
    0x400543939ad4a794, 0xc002597f9d4076f4,
    0x3fa2972675ca0c40, 0xbff00cd7211f8f04,
    0x4009b7ec844d4938, 0x40142d0ec5095cac,
    0xbfcd3ac899124e20, 0x400b527b9dfa8220,
    0x3ff4d630f30203f3, 0x3faad5331093de00,
    0xc00fddd42ce18c42, 0x40038512e681a3b7,
    0x4007fecc7e4c9e66, 0x3fa494cc37a02978,
    0xbfd8a9279980ba60, 0xbfe2d8ddd8793f66,
    0x40011f73f0e3d0ba, 0xbffefbe6e86a067e,
    0x3f7f5d79f8b1e680, 0xc006dd0f5d1da222,
    0xc0036b416398afe6, 0xc005ebe1cf6ca735,
    0xbff61155a88cc242, 0xbfef33677c5cf0ca,
    0x3fcf0e3eb9e4acc4, 0xc0092132a23bf990,
    0x3ff356790581a2b1, 0xc00204fd20341630,
    0xbff21e5aa421ecbe, 0xbff4327f47eb879b,
    0xbff7115c188d374a, 0xc011583efdeb3584,
    0x40118ec212b73b6d, 0xbfe611fe3582bf8c,
    0x4010197c215b4604, 0x401007ea595745a4,
    0xc003df32dcc8ff60, 0xbfff17f94d3467ae,
    0xbfe42a6db5ee42a3, 0xbfdd2cbad64ff064,
    0x3ff92dadaae1d04f, 0x3ffab6470c8a903c,
    0x4002612e68e4e48f, 0xbff8ff6f8ce94810,
    0xbffa382d59caeaf6, 0x3ff594207a1353cc,
    0xbfd58d60d03f7e3e, 0x4010c6eb7b45ee3e,
    0x3ffe1b1a9dc83e89, 0x3ff32360d61721b2,
    0xc008d40e64a4d893, 0xbff727f74d952bc8,
    0x3ffb6f69348794f2, 0xbffff2437ff5dacb,
    0x4007e98e63b140b6, 0x401194a0fa0a2455,
    0xc001308e4c12d5d7, 0xc001bf34e2dba740,
    0xbff462435d6cb086, 0xbfd6461f4016a66d,
    0xc00123c13e5c647e, 0x40047afca5d54580,
    0x4012e5144c2c870f, 0xbfe5cbda5a092988,
    0x3ff36f13f124871e, 0x3fe064bdcfe55941,
    0xbfe06b97866eaeb0, 0x4001dfdf165aebc1,
    0x3fefb090bbbcbbf8, 0x401f9808272a32ec,
    0xbff30eeab734f782, 0x3ff855c84454b1c7,
    0x3fefa2db81d98acc, 0xbff72b8611d00dbb,
    0xc000af06ec14ebb2, 0xbfe21223d0dbeb96,
    0xbffc807c9addea38, 0xbfe8e73796d87946,
    0x400ae9161da16e77, 0x3fb1a66e5c061ba0,
    0xbff3d156a6147b89, 0x4006aecacf38ca15,
    0x3fdafc2b9c0c1180, 0x4011faa7cabfd808,
    0xc008f7bfb0e04b30, 0x400b1c54b908ddda,
    0xc0008c11724fc6f3, 0x3fedd71e959e37f6,
    0x400bef8a2b20297a, 0xbfebdbfdb23a54d2,
    0xbfde2c7dba5a8150, 0xc017698ac4a32346,
    0xc0048816a21bda7a, 0xbfde7a064d854651,
    0xc00e00b6506ab40d, 0x400088b52f2ff715,
    0xc005101c036512cc, 0x3fd7b8464badae50,
    0xc00e6ece20b88461, 0xbfd2d5a53c15f148,
    0xbfedf21d9eece309, 0xc008232a123daf2a,
    0xbfe684380b838234, 0x4008a634d29942be,
    0x3ffb7080ed494294, 0xbfe6ab569a5ba392,
    0xbff784db955ac85c, 0x3ffbd6d55042bd8f,
    0xbffe8fa0c526705e, 0xbfc0444714b294e8,
    0x3fd2954a1257d320, 0xc00a94d87f1a15b6,
    0x3fe5328912e18088, 0x3ffd21017f4ad21c,
    0xc00063f74eeaff39, 0xbfda515e9aee3b88,
    0x3ff8ab55cf50bb36, 0xbff55daaa2a627ca,
    0xc00115cf5ef59435, 0x3fd280c7bb5b2727,
    0xbffb1bd2988fb3fe, 0xbff0bc78509ab8e2,
    0x3fbb52a15fe77b08, 0x4013317b56434feb,
    0xc005ef11836a3f3c, 0xbff2d50b54648498,
    0xc001fd61ff5a501c, 0xbfb82a8897a6bbc0,
    0x400b3743f9ef837f, 0x3fdf7f27485a4100,
    0xc00fb9a909f78524, 0xbfaaafb0e30da9c0,
    0xbffd508129f39c88, 0x3fe73f0fac871850,
    0xc003d84debc0cb90, 0xbff3cffb02b28632,
    0x40094df004c84cdf, 0xbfde3946294431d9,
    0x3fef3b611d1e41da, 0xbffbaa1b2635031d,
    0x4012905ea4876b60, 0xbfff59591e3cf4bd,
    0x3ff6a10a29e36962, 0x40083c8d45da37f6,
    0x40126007958f74e5, 0xbffc96e3dfae26fc,
    0xc00c861f7db45694, 0x40090445fb24bd11,
    0x3ffc1f9476a37c92, 0xbfeba264a36c0e9a,
    0x3ff3b03ba16571c2, 0x3ffd7392b427c6e2,
    0x3fe7e28a43eac37b, 0x4009d67552c4c04e,
    0x3fff2d542a60cbde, 0xbffafac172855bd8,
    0xc001fb4ae4039426, 0x40052bcd69c52e42,
    0x3ff2974ad98ff962, 0xbff5579281b29d64,
    0x3ff0e7571cf31d54, 0x3fbac0d36f1e9c5e,
    0xbfc5f3dd89876ebc, 0xbfe02ddb01d79f04,
    0xbfcaef406d6c6498, 0x3ff3fca7ed4fea2c,
    0x400c3920b97d656d, 0xbff213b542c9bd14,
    0xc0008ce19fb369ac, 0x40028b8eae0f1de0,
    0xc01230cfba3b9878, 0xbff23db3011b1468,
    0x40180c587c0cd14e, 0xbfcee57808c27fc0,
    0xc00ba6ed5841929e, 0x40169bed26288c1d,
    0xc012eadad5f3080a, 0xbfe9c8f00f99f573,
    0xc0102a974abd90aa, 0xbfdc17e5bb23998d,
    0xc0012c386c0dcaa0, 0xbfe0b174cc71be80,
    0x3ffc6ae8c430b8df, 0x3fcf00d9fa581d8c,
    0xbff368a5d0eea316, 0xc008f50a758f61bc,
    0x3ff74cc5864491dc, 0x400ad8c92808ef23,
    0xc0003897641c65a6, 0x3fcb73f4d5aff038,
    0x3fed1cfd553c47ab, 0xbff7e6ff12153890,
    0x3fe4273c4fd8b8eb, 0xc0112ed6531d0c3a,
    0x4007cf6670eb03d2, 0xbff1ca1f297fc486,
    0xc002600442d1b8d7, 0xbfeda232e86eea4d,
    0xc0077ed5bdd2944b, 0xbffee69448422daf,
    0xc0085b9c72ab93e3, 0x3fca7b479334bb6a,
    0x4000fc4626af96a2, 0xbff01a85958e1502,
    0x3ff5106e0d8851e5, 0x3ffa1d098914b0ca,
    0xc003b91717f7b890, 0xbfea7d822e79b628,
    0xbff9ee77d8de7268, 0xbfd8d9b81f685edc,
    0x4003bcfc382f1e8b, 0x4004f828ad777d88,
    0x3fc30ed45d88f788, 0xc01b2bab06549d26,
    0xbfd78ad2970a4c18, 0x4006186005aa98c1,
    0x3ff3c344b0f7d3e0, 0x40083138a095da73,
    0x40085112583b3dc5, 0xc0078d900860ea3e,
    0xc00acfffd876b89f, 0x3ff10ab36c99bc37,
    0x3fff2dd0262b8cc2, 0x400e774dfe0fbdd3,
    0x3ff6d3f7c156e927, 0x40168264883367e2,
    0x3f8aabb634beed40, 0x4014b9dd5d671eca,
    0xc0013d95f24c5125, 0x3fea1da001ee65fe,
    0x4012000dc34e35ea, 0xbff66023e33cd6c0,
    0x3ffd9f4e99267f35, 0x3fdd8c44a6aff98a,
    0xbf98a0da884816d0, 0x3fb7af35436aec40,
    0x3ff7952b45fe2c0c, 0x401065715fcad107,
    0xbffbf9727c44aed0, 0xc00a9fa0ab8c4a2f,
    0xbff2e38396ffa53c, 0x40003358e5ada1a1,
    0x3fc10e2ea696c390, 0x3fec50073c07b108,
    0x400d6a1359a24c42, 0x3ff409e1a0d58218,
    0xbfb4aeb198c65a87, 0xc0095cf7d7473f35,
    0x3ff087dcb51411a2, 0xbff00c544693f631,
    0x4005a52b09e3345a, 0xbff500b116c4a0f3,
    0x3fc7b83265e457c2, 0x400ad61a1ddd9c64,
    0x3fa5775e066a9b8c, 0x3ffdb60064b98858,
    0x3fe47c9882e3ebd3, 0xbfec743d2e1182de,
    0xbfe672d19720b16d, 0xc00122c872ba3efe,
    0xbff2b5fe5e0bd3d8, 0x4004625a307b10d7,
    0xbfee1ce1c2e9351a, 0xc01ae0abcdf7be55,
    0x3ff29747ec9c4ef6, 0x40069003939737dd,
    0xbff9e3e41d9acc3e, 0x3fd8836b052c07cc,
    0xbff6c12dfc7246a4, 0x3fc99bb079656448,
    0x3ffc6b9d191d48c8, 0xbffb19f96a85b7e1,
    0x3fff2008bfbb13b6, 0x3ff8824908f0a68b,
    0x3fec9c76abd83bb7, 0x3fcdc4bd68e92278,
    0xbffbef746a0702c8, 0x3fda3d469af638c2,
    0xc0007db91a6db171, 0xbff585cf9de02f90,
    0xbfb4359d33d08174, 0xbfef06aaecef7501,
    0xbff90ad1cd6abb5a, 0xbfdbc822eb5ed668,
    0x3fe96d51d1d33ee5, 0x3fffad00100c6520,
    0xbffd20c3a8950754, 0x3ff84e57dd126c6d,
    0x400bc137d6675f3a, 0xc0015b26fdb80b03,
    0xbff87cd2000607d4, 0xc000b03c8847210b,
    0x3ff10b492ef3b1e2, 0x3ff0b3aa0b9e175a,
    0x3ff8bf97abfebc01, 0xbfc3aa168f50a2d8,
    0x3fe266d4ed8825a4, 0xbff1d393f2dbf49c,
    0x400d641199eb4c4c, 0xc0002c45e3028671,
    0xbfff3ff08ab75df5, 0x4003a5ca0d5f5ab4,
    0x40113b7bb2a17658, 0x40127943e747412c,
    0xbfffb425daea7674, 0xbffccc19ffd3b796,
    0xc002b4f28bdb22d0, 0xbfd02632915fa0ed,
    0xbfdbfbb2f20b7798, 0xbf9a8919c9331380,
    0x3fb4c9adc85e79ba, 0xbff1020848df84f4,
    0xc004266d8e19527c, 0x3fe2ea69184f8a50,
    0x3ff2d2d2941cad3a, 0xbff98747f2edbbbe,
    0x3fc7145b2b0a0730, 0xbfea7b18f0d8f6b5,
    0xbff41ffa40911892, 0xc010e432741df9be,
    0x3fe35b43c0d05348, 0x3ff71322df012375,
    0x3fb70d4662184900, 0x4007c787040cc264,
    0xc000c051beba96c4, 0x4007232a07e07fb6,
    0xbfd2eef07a628830, 0x3fdb82d28179c614,
    0xbfe1d0c7adfd387c, 0xbff45e18dcfa9f7c,
    0xbfc1004aba04d4f0, 0x3ffae1e237dd4b3f,
    0x40174dfaec9d1ac9, 0xbfe6c5ddc90eca34,
    0x40137f984efe2b5a, 0x400e8c4503c8e041,
    0x3fed972d046713d4, 0xbff8bf1585869108,
    0x40012a0c09c69ac1, 0xbff12116ef38409e,
    0xc000a8e3d5e9fad9, 0x40061f9d00f4ebc7,
    0x3fd56e8baa85f42c, 0xbff1dbc8bcdc8a87,
    0x40016bf7a288fdf3, 0x400131e9d0d2952f,
    0x3febd24f4e1af312, 0xc01cc57a0ac93ec7,
    0x400e22dbeb02dca7, 0xbfeea4fb5de5327e,
    0xbfe223ee1b5c3710, 0x3fed2521b0f3ee73,
    0xbffbb182d997cb76, 0x3ffe767d92f91b6c,
    0x3feb60d700932a26, 0xbfe36f299d5a9ae0,
    0x4004a0116402fed8, 0xbff30b137780e846,
    0xbfebfe1dca2058cc, 0xc00711183ad3fdce,
    0xc000266d6be99595, 0x400066e23d5808e5,
    0xbffac4cfec866110, 0xbfe3be9c46fa04d4,
    0x4004c2b17b42549e, 0xc009ee8a09c232e6,
    0xbfe03c69a7c10188, 0xbffaa18ac64deb79,
    0x3ff18402c06d8623, 0xc007a3ba83fbe9f9,
    0x3ff1a7458ce7f842, 0xc01481855824fd7f,
    0x3fdc247b43daac38, 0xc015ce752741dafb,
    0xbfd9fee72e440ea5, 0xbfd5de169236e698,
    0x3ff1e6e485f4145c, 0x3fdd1de7c6616392,
    0x3fe25ba48a61e2a0, 0xc0025e99f06f0802,
    0x3ff5f78fd9b17a11, 0x400054ad759f0416,
    0x4012f44eaa812032, 0xbffe96166e0cc4f8,
    0xc011d6e2f2e65f06, 0xbfbacfa2b52406e0,
    0x3fe8672fdc8bddf4, 0xc002d7265dc6cd96,
    0x3ffd5ac519204c16, 0xbfe2ea154bf18550,
    0xbff41ef71f3e05b7, 0x3ffabb9bc578981c,
    0xbfe17da59c706396, 0xbfcc8b5cae6b0478,
    0x3ff84fdf1775f58a, 0x3ff4532fa5e95ada,
    0x3ff3f3f354e256fc, 0x40159c4dca2af7e2,
    0x3fc9b54e123e1678, 0xc005c652e742bf74,
    0x3fe62bf1827485ac, 0xbfdebdc028d5ab26,
    0x3fd0aa8cb9c490e2, 0x3fe3b9da5fe07e67,
    0x3fda0474a438a6b8, 0x3fc78ef9f1ef4f60,
    0xbfc6206969ed7ebc, 0xbfb7c1219adb6580,
    0x3fdc6606c648bb18, 0xbffb9ee32212dfba,
    0x3ff05c80ddee9dae, 0x4015a4ab78ebeee2,
    0xc013d5103c5214a7, 0xbff599ef7e0e9f81,
    0xbffa685da43e0a48, 0xbff9bfefcf8d0f54,
    0x3fecf44eb4f88cb9, 0x400fe9b69cdc0093,
    0x4004743bc4d1b740, 0xc0015724171dcdae,
    0xbffbb60df26b3b78, 0xbfdd522251739e84,
    0x40162e012d2560fc, 0xbfe2d404e3df57f6,
    0xc0135cc305394465, 0xbff34f4ad1e359a8,
    0x3ff70e36382607ac, 0xc00764e79d4b8c78,
    0x4011aef90f22f7a1, 0xbff8f0ba7c2297e2,
    0xbfd27154775f11ec, 0xbfe72e38b90471fb,
    0xc00ebe738a9c4dd5, 0x4003be1fdda3cb5e,
    0xbff7e59c32a4957e, 0x4014d8ce63c8b9ba,
    0x4002392461b0a8bd, 0x3fed03e79becd3a8,
    0xbffb8a2fcfcadc31, 0x3fde5dc07f5c6014,
    0xbf9ae1da86fa8c80, 0xc00b49edc4518044,
    0x40161d7cbe46fc1c, 0xbff55a5f6bfe0005,
    0x400817166cb9792e, 0x4008a902958cb592,
    0xc00accfda9d9603d, 0x4005449e855af5e1,
    0xc00106b0aa720a9f, 0x3ff5cc61f6911584,
    0x4001a39f6c7643e9, 0x4003c1b43b69a81e,
    0xc000ba88458d547c, 0x400c93bcb8c69f8f,
    0xbfc0e8462258e3a0, 0xbff30e820772cdd6,
    0xbfd1c9c42d1862bb, 0xbffa5d1a35ba06f4,
    0xbfda58bf1681d4b4, 0xc0014f3dc46091fa,
    0xbfc6028177a2dafc, 0xbfddd7dd8a1c81e4,
    0x3fdc759ad7ef6369, 0xc009c02d327ace0b,
    0x3ffcc2cfe9e77a86, 0xbfeb8f8f3b1011a1,
    0x3f64c2ddfc6ae000, 0xbfdeac4984e851a4,
    0x3ffd0d0c7163f1a2, 0xc011922e9c9b626b,
    0x3fff4fa43c1ed984, 0x40039b6b0c283d8e,
    0x4004a29d8155c8d4, 0xc003d86282319baf,
    0xbff0fc698afa92c3, 0x3fea730775403b42,
    0xbff322d7ecde04ac, 0xbffdb3271127f433,
    0xbff5bdc94e53e4b2, 0xc009e01fb8c1df20,
    0xc0112880188d4c43, 0xc0103fa4b4ddf6f8,
    0xc00614043c617bc2, 0xbfdc9f98523a4f12,
    0x3fdca28eb924556d, 0xbf964eb0dd83e980,
    0xc008bb578971abec, 0xc00db7e2df2d039c,
    0x400109cd38e1d52b, 0xc004d6d9febac514,
    0xc00a4ddfdc2c8daa, 0x40138163f0c14e94,
    0x4013e7937b787e9e, 0x3fd91e81af059298,
    0xbff4c2d2d7ab5156, 0x3fed18d170fb6fd8,
    0x40059d90b2e50e1a, 0xbff454080b627a66,
    0x3fe89e6b06797230, 0x3ff72f0da790d1de,
    0xbff80e013718044a, 0x400cdd31b4259d67,
    0x3fe33977c053dcdd, 0xc01138569c820d9b,
    0xc0082cbe1b9a2d5a, 0x401228790cde1e59,
    0xbfe7a762e3992877, 0xbfeca50aa0a99b7a,
    0xbfe361f5bfef8522, 0xbff91856995cc490,
    0xc005ed5a45536f55, 0xbfeb970fb9ef33b7,
    0x400ae92fb6c6fca2, 0xc00e50440f505350,
    0xc00e23db28c3fb66, 0x3fe15dbbe1459d0c,
    0x400332a918a961ea, 0x4007172a011e83b4,
    0xc00168ac9e537e93, 0x40006d476d1c4c84,
    0xbfe21a1b9c4e710a, 0x3ffe22c4b352c8b0,
    0xc01159146f7fa9aa, 0xbfe2644ebbf6f82a,
    0x3fa547e832f459e0, 0xbffb65f16a1c7bde,
    0x400a9267df658892, 0xbfe4a5e0a08a57d9,
    0x4006225ce6412d2c, 0x4002069e80a86c6d,
    0x400066a0c5ae6327, 0x40055947eef50395,
    0x4001cc1bc111cab6, 0xbf765a841d4d3a40,
    0x400f0a0c17448c4f, 0xbff1f143bada4612,
    0xbf83f11b135c2b00, 0x4000d46d9a698814,
    0xbffc06de096f2d08, 0xc00491ffbe379d54,
    0xbff4323e157605f9, 0xbff385bc0175dfab,
    0xbfe3864f624e604b, 0xbfdd24ff0971f398,
    0xc010bf6329e9ea1c, 0x3ff3ea5aacd2485b,
    0x3fd78051364f4c0e, 0x40087c0ac34de271,
    0xc00738f361a7b06a, 0x3ff741611b1c6e9a,
    0x3ff3ff582231621c, 0xc0092919f10a2a0e,
    0xbff2cff778a1fa0d, 0xbff85f2baffdf776,
    0x3ff748ab728ab6fc, 0x3fed6e2a011ffd60,
    0xc0010c8eaf733bc7, 0x4004b8415f46044c,
    0x4001e8f340b46627, 0x3ffc668ac735ef26,
    0xbfea72509358be5c, 0xc0008db86fbbe492,
    0xbff963cbd990ffdc, 0x4003ffb6c1eb6d44,
    0xbfec34691fedd7a6, 0xbff37c918c7a29f5,
    0xc002c1d08ea60de4, 0x3fe69b6bc5d375ed,
    0xc001ef5f783c8334, 0xbfed80b689aebba9,
    0xbfc02ff7186e5092, 0x3fd8881b6d61dc26,
    0xbff16abc70a1e684, 0xbff80b2af98d0c1d,
    0xc00a75c1d108a00a, 0x3febdfa2aee9803a,
    0x3fe9d05e5f2a6a2c, 0xbff709e3f64c3e28,
    0x3fe2fe36a9961b17, 0x4003c8d638f0f602,
    0xc002a21fd09bc41e, 0xbff05bfe880c6b8c,
    0xc009d9aef29ca638, 0xbff6098ef407f362,
    0x3ff455350cb3cccf, 0xbffd69a2a56e9dd7,
    0xc00397d50fdf8952, 0x3fbbd8e952377008,
    0xbfe834d355e8130b, 0x3fe3d1001a719226,
    0xbff3bd20644671fb, 0xbffac520c3c33d62,
    0x3fff5a9ce4892384, 0xbffee81b810e864e,
    0x3fcd96d629b7e0f4, 0xbff522d47b0f4c71,
    0xbff9bb7ea1db3b6c, 0x3ffdb50635ba8373,
    0xc002db767b60912d, 0x3ff16f7629c4335f,
    0xc007db577facafc8, 0xbfd9ede441c7fa90,
    0xc006a2557b24f32c, 0x3fd7f726c4540e24,
    0xbff8b724d0d5be80, 0xc00f77d6336143ab,
    0xc010ceaf17b5ac21, 0x400156acf7423776,
    0xc004771aab0da654, 0x3fd6d7a08a22d962,
    0x400428b00097dea5, 0x40041dcab8d5f777,
    0x3fd6f6c74665cded, 0x400542f1a13aabe0,
    0xbfdab2b62f3df97f, 0xbfd0b00393945578,
    0xc010b5fdced6021a, 0xc011aead2f8f5099,
    0x4000f02c9ef737fd, 0x3ffef8a5266a3a5b,
    0x3fea432d1e7183eb, 0x4002421f0b8253aa,
    0xc007eec44241512b, 0x3fe89bee22e7acf0,
    0xbff6666b60241797, 0xbfe21a8f560eb766,
    0xbfa1eff8a66bdae8, 0xc003f84677cc6f2b,
    0xbff5c98ba4eb35f2, 0xc00a8c9c1fe615af,
    0xbfc38d2fe1cfb348, 0x3fe5d0087ce64856,
    0x3fde90827e8ee9d8, 0x400e9f39e40257e5,
    0x400163cd19a48bf3, 0x4011093e4e9e452e,
    0x400003575b420bac, 0x3fbc1ebc61062f30,
    0xbfdec3d856a7415e, 0xbfd3f264ac677b00,
    0xc006658871610df8, 0x3ff4644baab83448,
    0xc009c13848003d06, 0x4000ea838d4b8ce5,
    0xbffbc459b0e0908c, 0xc001b1e9542db4f2,
    0xbfa0a20728b66680, 0xc00456f2978b2042,
    0x3fe61232adb244bc, 0x4016683ebbb77756,
    0xbff7318ad3c9f8a6, 0xc00033a716dbde37,
    0xbfd80b12cdc92418, 0xc00f2acc9d2a7c12,
    0x3fd78e5c6e92ebdc, 0xbfd6e82aba485198,
    0x3ffa63ecd6d2f18c, 0xbff685ca58c2a66d,
    0xc006306b4c0ee4e2, 0x3fe624c41e25446a,
    0xbf7130af20144680, 0x4014969831f8b544,
    0x3f82a930bec88ec0, 0x3fee0b47a9bae784,
    0xbff89d2694104374, 0xbffb30843fb17667,
    0xbfce9eeb2a890cbc, 0x3ffcae15dfd643cb,
    0xc002e1a0049620ca, 0xc007764e6e1c508e,
    0xbff996248f3a5549, 0xbffef961bbb52819,
    0x3fe700914d5cfecf, 0xc0071bc06501d569,
    0x3fb7a49032035120, 0xbfb6a80d17ba3e20,
    0x3fdec8445d6763f8, 0x3ff26ed482775026,
    0xbfb54633098eac10, 0x3ff12cc5c06386bf,
    0x3ff1d8cd0f3e7e82, 0x401267493ab17bf2,
    0xbfed46cda8e2f191, 0xbffa34652d9ac6ae,
    0x3ff3457e86bfea12, 0xbffd770450eedcd8,
    0x3ffa8a3d3bc8556a, 0x4003f9c2ea4b9f41,
    0x400710b79da7f77c, 0xbfc904144584ab22,
    0x3fee16b72c96b290, 0x3ffa7c11ecceb7f9,
    0x400eb339ebfb468e, 0xbff5c54ad1bc9aa1,
    0x3fe473eee7fc0d84, 0x3ff5e07f84c04356,
    0x3fc2c1acad4356b8, 0x3fd6bc128b22e300,
    0xbfe01bacbc167562, 0x3ff12a6f2a1f537c,
    0x3fd986d3622d7e7b, 0xc00c50787285311a,
    0xc004f1f51f73423c, 0x3ff71ba417a732e0,
    0x40122786dca50e16, 0x3fd0ec54547ffd2c,
    0x3fe2374eb842acd3, 0x3ff93e9875890b4a,
    0x40091e337f0bfefd, 0x400238959d3a0b02,
    0x40084c45c68ef61c, 0xc00da19ae38a00ab,
    0x400857c63fdc68dc, 0x400d7d8e6defd238,
    0xbfea47a7272a233e, 0xbfd5b30a9eb32612,
    0x3ff11ad20491e8d8, 0x4001f537205f8220,
    0xc00b93ab6f0b6836, 0xbfdcf4e31713b377,
    0xbfcfbf4373d299e0, 0xbff13b81a18c5d5a,
    0xc004ff036f144a38, 0xbfe67b3c366e5cfb,
    0xbfe63a341ec61e6c, 0xc0033440ed56fe14,
    0x3faa21cd5f9f8ee0, 0xbff8318ae9230a96,
    0xbfc92a9604168f78, 0x0,
    0x3faa21cd5f9f8f40, 0x3ff8318ae9230a98,
    0xbfe63a341ec61e64, 0x40033440ed56fe14,
    0xc004ff036f144a3a, 0x3fe67b3c366e5d00,
    0xbfcfbf4373d299e0, 0x3ff13b81a18c5d58,
    0xc00b93ab6f0b6836, 0x3fdcf4e31713b372,
    0x3ff11ad20491e8dc, 0xc001f537205f821e,
    0xbfea47a7272a233d, 0x3fd5b30a9eb3260c,
    0x400857c63fdc68dc, 0xc00d7d8e6defd239,
    0x40084c45c68ef61d, 0x400da19ae38a00ac,
    0x40091e337f0bfefc, 0xc00238959d3a0b03,
    0x3fe2374eb842acdc, 0xbff93e9875890b47,
    0x40122786dca50e15, 0xbfd0ec54547ffd3a,
    0xc004f1f51f73423e, 0xbff71ba417a732e3,
    0x3fd986d3622d7e82, 0x400c50787285311a,
    0xbfe01bacbc167565, 0xbff12a6f2a1f537d,
    0x3fc2c1acad4356bc, 0xbfd6bc128b22e300,
    0x3fe473eee7fc0d8e, 0xbff5e07f84c04351,
    0x400eb339ebfb468d, 0x3ff5c54ad1bc9aa4,
    0x3fee16b72c96b28c, 0xbffa7c11ecceb7f9,
    0x400710b79da7f77c, 0x3fc904144584ab16,
    0x3ffa8a3d3bc8556d, 0xc003f9c2ea4b9f43,
    0x3ff3457e86bfea14, 0x3ffd770450eedcd8,
    0xbfed46cda8e2f19a, 0x3ffa34652d9ac6ae,
    0x3ff1d8cd0f3e7e81, 0xc01267493ab17bf2,
    0xbfb54633098eac40, 0xbff12cc5c06386bf,
    0x3fdec8445d6763f8, 0xbff26ed482775022,
    0x3fb7a49032035100, 0x3fb6a80d17ba3e80,
    0x3fe700914d5cfec6, 0x40071bc06501d56a,
    0xbff996248f3a5549, 0x3ffef961bbb52816,
    0xc002e1a0049620ca, 0x4007764e6e1c508c,
    0xbfce9eeb2a890cb0, 0xbffcae15dfd643cd,
    0xbff89d2694104375, 0x3ffb30843fb17667,
    0x3f82a930bec88b80, 0xbfee0b47a9bae78a,
    0xbf7130af20144a00, 0xc014969831f8b544,
    0xc006306b4c0ee4de, 0xbfe624c41e254463,
    0x3ffa63ecd6d2f18c, 0x3ff685ca58c2a66e,
    0x3fd78e5c6e92ebd8, 0x3fd6e82aba4851a8,
    0xbfd80b12cdc92404, 0x400f2acc9d2a7c10,
    0xbff7318ad3c9f8aa, 0x400033a716dbde34,
    0x3fe61232adb244bc, 0xc016683ebbb77755,
    0xbfa0a20728b666e0, 0x400456f2978b2040,
    0xbffbc459b0e0908b, 0x4001b1e9542db4f0,
    0xc009c13848003d09, 0xc000ea838d4b8ce4,
    0xc006658871610df7, 0xbff4644baab83446,
    0xbfdec3d856a74148, 0x3fd3f264ac677b00,
    0x400003575b420bac, 0xbfbc1ebc61062f10,
    0x400163cd19a48bf4, 0xc011093e4e9e452e,
    0x3fde90827e8ee9d0, 0xc00e9f39e40257e5,
    0xbfc38d2fe1cfb350, 0xbfe5d0087ce64859,
    0xbff5c98ba4eb35ee, 0x400a8c9c1fe615ae,
    0xbfa1eff8a66bdae8, 0x4003f84677cc6f2c,
    0xbff6666b60241796, 0x3fe21a8f560eb76e,
    0xc007eec44241512b, 0xbfe89bee22e7acec,
    0x3fea432d1e7183e7, 0xc002421f0b8253a8,
    0x4000f02c9ef737fa, 0xbffef8a5266a3a59,
    0xc010b5fdced6021a, 0x4011aead2f8f5098,
    0xbfdab2b62f3df984, 0x3fd0b0039394556a,
    0x3fd6f6c74665cded, 0xc00542f1a13aabe2,
    0x400428b00097dea6, 0xc0041dcab8d5f776,
    0xc004771aab0da654, 0xbfd6d7a08a22d96c,
    0xc010ceaf17b5ac20, 0xc00156acf7423778,
    0xbff8b724d0d5be84, 0x400f77d6336143ac,
    0xc006a2557b24f32a, 0xbfd7f726c4540e2c,
    0xc007db577facafc8, 0x3fd9ede441c7fa94,
    0xc002db767b60912d, 0xbff16f7629c4335c,
    0xbff9bb7ea1db3b68, 0xbffdb50635ba836c,
    0x3fcd96d629b7e104, 0x3ff522d47b0f4c73,
    0x3fff5a9ce4892382, 0x3ffee81b810e864e,
    0xbff3bd20644671f8, 0x3ffac520c3c33d61,
    0xbfe834d355e81308, 0xbfe3d1001a719220,
    0xc00397d50fdf8952, 0xbfbbd8e952377040,
    0x3ff455350cb3ccd2, 0x3ffd69a2a56e9dd6,
    0xc009d9aef29ca639, 0x3ff6098ef407f362,
    0xc002a21fd09bc41a, 0x3ff05bfe880c6b8b,
    0x3fe2fe36a9961b1b, 0xc003c8d638f0f600,
    0x3fe9d05e5f2a6a2e, 0x3ff709e3f64c3e29,
    0xc00a75c1d108a00b, 0xbfebdfa2aee98038,
    0xbff16abc70a1e689, 0x3ff80b2af98d0c22,
    0xbfc02ff7186e50a0, 0xbfd8881b6d61dc1a,
    0xc001ef5f783c8334, 0x3fed80b689aebbac,
    0xc002c1d08ea60de4, 0xbfe69b6bc5d375ea,
    0xbfec34691fedd7a6, 0x3ff37c918c7a29f8,
    0xbff963cbd990ffda, 0xc003ffb6c1eb6d48,
    0xbfea72509358be5b, 0x40008db86fbbe491,
    0x4001e8f340b46627, 0xbffc668ac735ef26,
    0xc0010c8eaf733bc7, 0xc004b8415f46044b,
    0x3ff748ab728ab6fb, 0xbfed6e2a011ffd64,
    0xbff2cff778a1fa0e, 0x3ff85f2baffdf779,
    0x3ff3ff5822316221, 0x40092919f10a2a0f,
    0xc00738f361a7b06a, 0xbff741611b1c6e99,
    0x3fd78051364f4c13, 0xc0087c0ac34de270,
    0xc010bf6329e9ea1c, 0xbff3ea5aacd2485f,
    0xbfe3864f624e6047, 0x3fdd24ff0971f398,
    0xbff4323e157605fa, 0x3ff385bc0175dfac,
    0xbffc06de096f2d08, 0x400491ffbe379d51,
    0xbf83f11b135c2700, 0xc000d46d9a698815,
    0x400f0a0c17448c50, 0x3ff1f143bada4612,
    0x4001cc1bc111cab6, 0x3f765a841d4d3500,
    0x400066a0c5ae6329, 0xc0055947eef50397,
    0x4006225ce6412d2a, 0xc002069e80a86c6f,
    0x400a9267df658892, 0x3fe4a5e0a08a57d6,
    0x3fa547e832f45a20, 0x3ffb65f16a1c7bda,
    0xc01159146f7fa9aa, 0x3fe2644ebbf6f826,
    0xbfe21a1b9c4e7108, 0xbffe22c4b352c8b4,
    0xc00168ac9e537e93, 0xc0006d476d1c4c84,
    0x400332a918a961ea, 0xc007172a011e83b2,
    0xc00e23db28c3fb69, 0xbfe15dbbe1459d0e,
    0x400ae92fb6c6fca4, 0x400e50440f50534f,
    0xc005ed5a45536f56, 0x3feb970fb9ef33ae,
    0xbfe361f5bfef8526, 0x3ff91856995cc488,
    0xbfe7a762e399287a, 0x3feca50aa0a99b78,
    0xc0082cbe1b9a2d59, 0xc01228790cde1e58,
    0x3fe33977c053dcdc, 0x401138569c820d9b,
    0xbff80e013718044f, 0xc00cdd31b4259d65,
    0x3fe89e6b0679722a, 0xbff72f0da790d1e0,
    0x40059d90b2e50e1b, 0x3ff454080b627a66,
    0xbff4c2d2d7ab5158, 0xbfed18d170fb6fd4,
    0x4013e7937b787e9f, 0xbfd91e81af05928e,
    0xc00a4ddfdc2c8da7, 0xc0138163f0c14e94,
    0x400109cd38e1d52b, 0x4004d6d9febac514,
    0xc008bb578971abef, 0x400db7e2df2d039a,
    0x3fdca28eb9245567, 0x3f964eb0dd83eb80,
    0xc00614043c617bc2, 0x3fdc9f98523a4f07,
    0xc0112880188d4c42, 0x40103fa4b4ddf6f8,
    0xbff5bdc94e53e4b1, 0x4009e01fb8c1df1e,
    0xbff322d7ecde04b0, 0x3ffdb3271127f438,
    0xbff0fc698afa92c2, 0xbfea730775403b43,
    0x4004a29d8155c8d4, 0x4003d86282319baf,
    0x3fff4fa43c1ed984, 0xc0039b6b0c283d8c,
    0x3ffd0d0c7163f1a4, 0x4011922e9c9b626b,
    0x3f64c2ddfc6ae400, 0x3fdeac4984e851a6,
    0x3ffcc2cfe9e77a84, 0x3feb8f8f3b1011a0,
    0x3fdc759ad7ef6365, 0x4009c02d327ace09,
    0xbfc6028177a2dae8, 0x3fddd7dd8a1c81e0,
    0xbfda58bf1681d4bf, 0x40014f3dc46091fa,
    0xbfd1c9c42d1862bb, 0x3ffa5d1a35ba06f1,
    0xbfc0e8462258e398, 0x3ff30e820772cdd0,
    0xc000ba88458d547e, 0xc00c93bcb8c69f90,
    0x4001a39f6c7643e9, 0xc003c1b43b69a820,
    0xc00106b0aa720a9e, 0xbff5cc61f6911580,
    0xc00accfda9d9603d, 0xc005449e855af5e0,
    0x400817166cb9792d, 0xc008a902958cb593,
    0x40161d7cbe46fc1d, 0x3ff55a5f6bfe0006,
    0xbf9ae1da86fa8c80, 0x400b49edc4518042,
    0xbffb8a2fcfcadc30, 0xbfde5dc07f5c6014,
    0x4002392461b0a8bf, 0xbfed03e79becd3a2,
    0xbff7e59c32a4957d, 0xc014d8ce63c8b9b9,
    0xc00ebe738a9c4dd2, 0xc003be1fdda3cb5f,
    0xbfd27154775f11e4, 0x3fe72e38b90471fb,
    0x4011aef90f22f7a1, 0x3ff8f0ba7c2297e8,
    0x3ff70e36382607ac, 0x400764e79d4b8c7a,
    0xc0135cc305394464, 0x3ff34f4ad1e359a6,
    0x40162e012d2560fc, 0x3fe2d404e3df57f0,
    0xbffbb60df26b3b74, 0x3fdd522251739e86,
    0x4004743bc4d1b741, 0x40015724171dcdaa,
    0x3fecf44eb4f88cc2, 0xc00fe9b69cdc008f,
    0xbffa685da43e0a47, 0x3ff9bfefcf8d0f51,
    0xc013d5103c5214a7, 0x3ff599ef7e0e9f7e,
    0x3ff05c80ddee9dae, 0xc015a4ab78ebeee3,
    0x3fdc6606c648bb18, 0x3ffb9ee32212dfb6,
    0xbfc6206969ed7ecc, 0x3fb7c1219adb655c,
    0x3fda0474a438a6bc, 0xbfc78ef9f1ef4f51,
    0x3fd0aa8cb9c490de, 0xbfe3b9da5fe07e5c,
    0x3fe62bf1827485af, 0x3fdebdc028d5ab23,
    0x3fc9b54e123e1690, 0x4005c652e742bf73,
    0x3ff3f3f354e256f7, 0xc0159c4dca2af7e0,
    0x3ff84fdf1775f58c, 0xbff4532fa5e95ad9,
    0xbfe17da59c706390, 0x3fcc8b5cae6b047c,
    0xbff41ef71f3e05b6, 0xbffabb9bc578981c,
    0x3ffd5ac519204c16, 0x3fe2ea154bf1854a,
    0x3fe8672fdc8bddf0, 0x4002d7265dc6cd95,
    0xc011d6e2f2e65f06, 0x3fbacfa2b52406c0,
    0x4012f44eaa812030, 0x3ffe96166e0cc4f4,
    0x3ff5f78fd9b17a0b, 0xc00054ad759f0415,
    0x3fe25ba48a61e29d, 0x40025e99f06f0802,
    0x3ff1e6e485f4145c, 0xbfdd1de7c661639c,
    0xbfd9fee72e440ea8, 0x3fd5de169236e694,
    0x3fdc247b43daac24, 0x4015ce752741daf9,
    0x3ff1a7458ce7f842, 0x401481855824fd7e,
    0x3ff18402c06d8624, 0x4007a3ba83fbe9f8,
    0xbfe03c69a7c1017e, 0x3ffaa18ac64deb7c,
    0x4004c2b17b42549f, 0x4009ee8a09c232e5,
    0xbffac4cfec866112, 0x3fe3be9c46fa04cc,
    0xc000266d6be99592, 0xc00066e23d5808e5,
    0xbfebfe1dca2058c4, 0x400711183ad3fdcc,
    0x4004a0116402fed8, 0x3ff30b137780e84a,
    0x3feb60d700932a29, 0x3fe36f299d5a9ae4,
    0xbffbb182d997cb76, 0xbffe767d92f91b6b,
    0xbfe223ee1b5c370c, 0xbfed2521b0f3ee7e,
    0x400e22dbeb02dca6, 0x3feea4fb5de53270,
    0x3febd24f4e1af311, 0x401cc57a0ac93ec5,
    0x40016bf7a288fdf3, 0xc00131e9d0d2952e,
    0x3fd56e8baa85f438, 0x3ff1dbc8bcdc8a8e,
    0xc000a8e3d5e9fad9, 0xc0061f9d00f4ebc8,
    0x40012a0c09c69ac1, 0x3ff12116ef38409e,
    0x3fed972d046713d0, 0x3ff8bf1585869105,
    0x40137f984efe2b5a, 0xc00e8c4503c8e043,
    0x40174dfaec9d1ac8, 0x3fe6c5ddc90eca44,
    0xbfc1004aba04d4ec, 0xbffae1e237dd4b3f,
    0xbfe1d0c7adfd387e, 0x3ff45e18dcfa9f7e,
    0xbfd2eef07a628834, 0xbfdb82d28179c60c,
    0xc000c051beba96c1, 0xc007232a07e07fb6,
    0x3fb70d46621848b0, 0xc007c787040cc266,
    0x3fe35b43c0d05349, 0xbff71322df012372,
    0xbff41ffa40911892, 0x4010e432741df9be,
    0x3fc7145b2b0a0728, 0x3fea7b18f0d8f6b7,
    0x3ff2d2d2941cad3d, 0x3ff98747f2edbbbf,
    0xc004266d8e19527c, 0xbfe2ea69184f8a52,
    0x3fb4c9adc85e7990, 0x3ff1020848df84f8,
    0xbfdbfbb2f20b7784, 0x3f9a8919c9331480,
    0xc002b4f28bdb22d1, 0x3fd02632915fa0d3,
    0xbfffb425daea7674, 0x3ffccc19ffd3b796,
    0x40113b7bb2a17657, 0xc0127943e747412c,
    0xbfff3ff08ab75df9, 0xc003a5ca0d5f5ab4,
    0x400d641199eb4c4b, 0x40002c45e3028670,
    0x3fe266d4ed8825a2, 0x3ff1d393f2dbf499,
    0x3ff8bf97abfebbfd, 0x3fc3aa168f50a2c8,
    0x3ff10b492ef3b1e0, 0xbff0b3aa0b9e1756,
    0xbff87cd2000607d1, 0x4000b03c8847210a,
    0x400bc137d6675f3a, 0x40015b26fdb80b00,
    0xbffd20c3a895074c, 0xbff84e57dd126c6e,
    0x3fe96d51d1d33eea, 0xbfffad00100c6518,
    0xbff90ad1cd6abb58, 0x3fdbc822eb5ed670,
    0xbfb4359d33d08150, 0x3fef06aaecef7500,
    0xc0007db91a6db16e, 0x3ff585cf9de02f91,
    0xbffbef746a0702ca, 0xbfda3d469af638ce,
    0x3fec9c76abd83bbf, 0xbfcdc4bd68e92288,
    0x3fff2008bfbb13b9, 0xbff8824908f0a68d,
    0x3ffc6b9d191d48c9, 0x3ffb19f96a85b7de,
    0xbff6c12dfc7246a6, 0xbfc99bb079656450,
    0xbff9e3e41d9acc3d, 0xbfd8836b052c07ce,
    0x3ff29747ec9c4ef8, 0xc0069003939737dc,
    0xbfee1ce1c2e9351a, 0x401ae0abcdf7be54,
    0xbff2b5fe5e0bd3d0, 0xc004625a307b10d6,
    0xbfe672d19720b169, 0x400122c872ba3f00,
    0x3fe47c9882e3ebcc, 0x3fec743d2e1182d8,
    0x3fa5775e066a9b70, 0xbffdb60064b9885c,
    0x3fc7b83265e457d6, 0xc00ad61a1ddd9c66,
    0x4005a52b09e3345a, 0x3ff500b116c4a0f2,
    0x3ff087dcb51411a2, 0x3ff00c544693f632,
    0xbfb4aeb198c65ab4, 0x40095cf7d7473f34,
    0x400d6a1359a24c44, 0xbff409e1a0d58214,
    0x3fc10e2ea696c3c0, 0xbfec50073c07b108,
    0xbff2e38396ffa53a, 0xc0003358e5ada1a2,
    0xbffbf9727c44aece, 0x400a9fa0ab8c4a2b,
    0x3ff7952b45fe2c0b, 0xc01065715fcad108,
    0xbf98a0da884815c0, 0xbfb7af35436aec30,
    0x3ffd9f4e99267f34, 0xbfdd8c44a6aff97c,
    0x4012000dc34e35ec, 0x3ff66023e33cd6c2,
    0xc0013d95f24c5124, 0xbfea1da001ee6600,
    0x3f8aabb634beed60, 0xc014b9dd5d671eca,
    0x3ff6d3f7c156e922, 0xc0168264883367e2,
    0x3fff2dd0262b8cbd, 0xc00e774dfe0fbdd0,
    0xc00acfffd876b8a2, 0xbff10ab36c99bc36,
    0x40085112583b3dc4, 0x40078d900860ea3e,
    0x3ff3c344b0f7d3df, 0xc0083138a095da73,
    0xbfd78ad2970a4c22, 0xc006186005aa98c2,
    0x3fc30ed45d88f780, 0x401b2bab06549d24,
    0x4003bcfc382f1e8a, 0xc004f828ad777d89,
    0xbff9ee77d8de7268, 0x3fd8d9b81f685ed8,
    0xc003b91717f7b88d, 0x3fea7d822e79b628,
    0x3ff5106e0d8851e8, 0xbffa1d098914b0c6,
    0x4000fc4626af96a3, 0x3ff01a85958e14fe,
    0xc0085b9c72ab93e2, 0xbfca7b479334bb68,
    0xc0077ed5bdd2944c, 0x3ffee69448422dae,
    0xc002600442d1b8d8, 0x3feda232e86eea4d,
    0x4007cf6670eb03d1, 0x3ff1ca1f297fc482,
    0x3fe4273c4fd8b8f0, 0x40112ed6531d0c39,
    0x3fed1cfd553c47b0, 0x3ff7e6ff12153890,
    0xc0003897641c65a5, 0xbfcb73f4d5aff044,
    0x3ff74cc5864491d8, 0xc00ad8c92808ef21,
    0xbff368a5d0eea315, 0x4008f50a758f61bc,
    0x3ffc6ae8c430b8dd, 0xbfcf00d9fa581d78,
    0xc0012c386c0dca9f, 0x3fe0b174cc71be94,
    0xc0102a974abd90aa, 0x3fdc17e5bb23998c,
    0xc012eadad5f3080a, 0x3fe9c8f00f99f572,
    0xc00ba6ed5841929c, 0xc0169bed26288c1c,
    0x40180c587c0cd14d, 0x3fcee57808c27fb0,
    0xc01230cfba3b9878, 0x3ff23db3011b146e,
    0xc0008ce19fb369ac, 0xc0028b8eae0f1ddf,
    0x400c3920b97d656e, 0x3ff213b542c9bd14,
    0xbfcaef406d6c64b8, 0xbff3fca7ed4fea29,
    0xbfc5f3dd89876ed0, 0x3fe02ddb01d79efb,
    0x3ff0e7571cf31d53, 0xbfbac0d36f1e9c7a,
    0x3ff2974ad98ff964, 0x3ff5579281b29d63,
    0xc001fb4ae4039425, 0xc0052bcd69c52e42,
    0x3fff2d542a60cbde, 0x3ffafac172855bdb,
    0x3fe7e28a43eac37c, 0xc009d67552c4c04e,
    0x3ff3b03ba16571c2, 0xbffd7392b427c6e4,
    0x3ffc1f9476a37c94, 0x3feba264a36c0e94,
    0xc00c861f7db45696, 0xc0090445fb24bd11,
    0x40126007958f74e4, 0x3ffc96e3dfae2702,
    0x3ff6a10a29e36963, 0xc0083c8d45da37f5,
    0x4012905ea4876b5f, 0x3fff59591e3cf4b8,
    0x3fef3b611d1e41e8, 0x3ffbaa1b26350318,
    0x40094df004c84cdc, 0x3fde3946294431cf,
    0xc003d84debc0cb92, 0x3ff3cffb02b28630,
    0xbffd508129f39c88, 0xbfe73f0fac871852,
    0xc00fb9a909f78526, 0x3faaafb0e30daa00,
    0x400b3743f9ef837f, 0xbfdf7f27485a40fe,
    0xc001fd61ff5a501d, 0x3fb82a8897a6bbe0,
    0xc005ef11836a3f3f, 0x3ff2d50b54648496,
    0x3fbb52a15fe77ad0, 0xc013317b56434fec,
    0xbffb1bd2988fb3fe, 0x3ff0bc78509ab8dc,
    0xc00115cf5ef59433, 0xbfd280c7bb5b2734,
    0x3ff8ab55cf50bb36, 0x3ff55daaa2a627c9,
    0xc00063f74eeaff37, 0x3fda515e9aee3b80,
    0x3fe5328912e1808e, 0xbffd21017f4ad217,
    0x3fd2954a1257d320, 0x400a94d87f1a15b5,
    0xbffe8fa0c5267060, 0x3fc0444714b294e8,
    0xbff784db955ac85e, 0xbffbd6d55042bd8c,
    0x3ffb7080ed494292, 0x3fe6ab569a5ba398,
    0xbfe684380b838232, 0xc008a634d29942be,
    0xbfedf21d9eece30d, 0x4008232a123daf2a,
    0xc00e6ece20b88460, 0x3fd2d5a53c15f140,
    0xc005101c036512ca, 0xbfd7b8464badae50,
    0xc00e00b6506ab40f, 0xc00088b52f2ff716,
    0xc0048816a21bda7a, 0x3fde7a064d854654,
    0xbfde2c7dba5a8150, 0x4017698ac4a32348,
    0x400bef8a2b20297a, 0x3febdbfdb23a54d2,
    0xc0008c11724fc6f2, 0xbfedd71e959e37f4,
    0xc008f7bfb0e04b30, 0xc00b1c54b908ddda,
    0x3fdafc2b9c0c1164, 0xc011faa7cabfd808,
    0xbff3d156a6147b88, 0xc006aecacf38ca14,
    0x400ae9161da16e74, 0xbfb1a66e5c061b78,
    0xbffc807c9addea38, 0x3fe8e73796d87942,
    0xc000af06ec14ebb2, 0x3fe21223d0dbeb9a,
    0x3fefa2db81d98ace, 0x3ff72b8611d00db8,
    0xbff30eeab734f781, 0xbff855c84454b1c8,
    0x3fefb090bbbcbbee, 0xc01f9808272a32ec,
    0xbfe06b97866eaeac, 0xc001dfdf165aebc0,
    0x3ff36f13f124871c, 0xbfe064bdcfe55940,
    0x4012e5144c2c8710, 0x3fe5cbda5a09298a,
    0xc00123c13e5c647e, 0xc0047afca5d54580,
    0xbff462435d6cb086, 0x3fd6461f4016a66c,
    0xc001308e4c12d5d6, 0x4001bf34e2dba742,
    0x4007e98e63b140b7, 0xc01194a0fa0a2454,
    0x3ffb6f69348794f4, 0x3ffff2437ff5dac8,
    0xc008d40e64a4d894, 0x3ff727f74d952bcc,
    0x3ffe1b1a9dc83e83, 0xbff32360d61721b3,
    0xbfd58d60d03f7e3c, 0xc010c6eb7b45ee3e,
    0xbffa382d59caeaf6, 0xbff594207a1353cc,
    0x4002612e68e4e48c, 0x3ff8ff6f8ce9480e,
    0x3ff92dadaae1d04c, 0xbffab6470c8a903f,
    0xbfe42a6db5ee42ac, 0x3fdd2cbad64ff060,
    0xc003df32dcc8ff60, 0x3fff17f94d3467a8,
    0x4010197c215b4605, 0xc01007ea595745a5,
    0x40118ec212b73b6c, 0x3fe611fe3582bf84,
    0xbff7115c188d374c, 0x4011583efdeb3584,
    0xbff21e5aa421ecbf, 0x3ff4327f47eb8796,
    0x3ff356790581a2ae, 0x400204fd20341630,
    0x3fcf0e3eb9e4acc0, 0x40092132a23bf990,
    0xbff61155a88cc240, 0x3fef33677c5cf0d0,
    0xc0036b416398afe5, 0x4005ebe1cf6ca735,
    0x3f7f5d79f8b1e780, 0x4006dd0f5d1da220,
    0x40011f73f0e3d0ba, 0x3ffefbe6e86a067a,
    0xbfd8a9279980ba74, 0x3fe2d8ddd8793f66,
    0x4007fecc7e4c9e64, 0xbfa494cc37a02950,
    0xc00fddd42ce18c42, 0xc0038512e681a3b6,
    0x3ff4d630f30203f7, 0xbfaad5331093de20,
    0xbfcd3ac899124e20, 0xc00b527b9dfa8220,
    0x4009b7ec844d4938, 0xc0142d0ec5095cac,
    0x3fa2972675ca0d00, 0x3ff00cd7211f8f06,
    0x400543939ad4a792, 0x4002597f9d4076f4,
    0x3ff756e60d4c754c, 0x3fe1cc2db873404a,
    0x40011f18e5cca4eb, 0xbfa4b1a1b0eba668,
    0x4002490fb4721c7a, 0xbfd41695e5b421d2,
    0x4005a8a489318c50, 0x3fc72184a33550c4,
    0x3ff4dac6889e5d63, 0x400692b2f81afae3,
    0xc012fbb20ab174f4, 0xc005ee87bb1138d8,
    0xbfd364c900278f1f, 0xbfee5f9374c42a1c,
    0x3f99fd3f98bffd30, 0x3ffc2df9c2a7bf87,
    0x3fc2bcfedae25fa2, 0xc00f808ace6289cb,
    0x3fe0fe2b097ad6ab, 0x3fc3a641222a55c0,
    0x400ce2c92a6bf2cb, 0x3fb2016c9332b6a0,
    0x4000ee9689694bc2, 0x3feb818be1bc5874,
    0xbfe3ca0f6b1a6e7b, 0xbfecdda9889309aa,
    0x3fdf7954c0f4fbe0, 0xc00a5bf096141e52,
    0x3ffcf82c10fb3c3a, 0xbfefca3b554a0506,
    0x400398da5cd7febb, 0x3ffe4375b4dd8984,
    0xbffec020cd95d6e6, 0x3fc43899c8bc10ec,
    0x3fb631ac13a03f90, 0x3ff2ac934f6cc16b,
    0x3fe7ca1aa194a0d1, 0x3ff29f65be398c68,
    0xbfd9039db4449e98, 0x4011131acd7dc2ce,
    0x4013e4745b788a1a, 0x3ff8c2b57468c7a6,
    0x400187ce39bf0c8e, 0xbffcea352844f773,
    0x4000a18b56ad43e4, 0x40054d972a5a9496,
    0x3fd7122c039c49c9, 0xbfd8fb71aa725884,
    0xbfc3394320d96b54, 0xc003353f72c4aefb,
    0xbff512eb23f2ae30, 0xc004978e2fce84f5,
    0xbff535af1b2536b2, 0x401381e1460982e7,
    0xc00f6f1feedbdf61, 0xbff861bd55aecfd9,
    0x400af04bcbdf21ee, 0x4000b433a60db523,
    0x4009c306096a13ce, 0x3ff6f2ebb72c8ae8,
    0x3fe0680150182acf, 0x3fe47859de59bd9c,
    0x400b67ad34f5bb0e, 0xbff48adf1993c4da,
    0xbff65afa9e047855, 0x3fe0b0f9d109024f,
    0xbfcb254efb962be8, 0xc00ff1b3592a8f84,
    0x40003519f03b0294, 0x3fec3d817aa69c62,
    0xc00aad25b92d8db8, 0x4007fcff04d423df,
    0x4011c9cc9aae1370, 0xc00313b464ed59c6,
    0xbfdf9ec6f1104888, 0xbfd6341a46aa05e8,
    0x3ffb110f41302846, 0x3fcb6541c263fb28,
    0x3ff4b81236836e90, 0x400ae3360346a727,
    0x3ff8e9bf65022d13, 0x400306781ffb54dc,
    0xc00ab1b71a6a8df0, 0x40099ac8c8a414a6,
    0x3fd96e6d28ed72de, 0x3ff107809d105122,
    0xbff19dc04f92d75e, 0x3fe4489855da2e7f,
    0x3ff57d188ef0fe22, 0x400c7561d720b761,
    0x3fe117dc992149ef, 0x3ffcdedef8db59e7,
    0x3ff7af922becbce6, 0x3ff1bb27a482979c,
    0xbfe77712a4d09350, 0xc0050b5ec8c9133d,
    0xbffaedb2135d4a7c, 0xbfd08c65880671a0,
    0xc00ae5a4bda7791f, 0xbfea67ec92242289,
    0xbff1fd2e4105a7e5, 0xbff3fe198ef1ef5a,
    0x3ff1e038010ae37c, 0xbffaf4b153277a1f,
    0x3fe4773bf90f054a, 0x3fb7ad3456de1c00,
    0x400977951435fcfc, 0xc013d8d7b2903132,
    0x3ff06a9047f172b0, 0x3fed8c94117fa6da,
    0x3ff34298e275f27c, 0x4002f74bf13a0f6c,
    0x400419b74c502463, 0x400a023ca3f1489f,
    0xc0018a5f5e2594bc, 0xbfff0869a5b00708,
    0x4010cba72bd1c384, 0xc0010ad2b60568e2,
    0x3ff15e588bce7ebd, 0xc0022fa9724ab04a,
    0xbff35ad8d7fe651e, 0x3fd26d99c223f896,
    0x4000e9200027e4a5, 0xbfdb0d0ebb27da38,
    0xbff38f7edfa481a8, 0xbfea8f7c28309596,
    0x4007038687085b94, 0x3ff8ddc6bf88d1cc,
    0xbfd88e8a802d33b4, 0x4012a538b66355a8,
    0xbffe0e32d0bc55fe, 0xbff3692135c7d7ce,
    0x3fd5f05db0dd2cb4, 0xbfdec772f7baa980,
    0x400f9091771e25dc, 0x3fe835192a50041c,
    0x40084b7e2dd80a86, 0x40049a7342a2e368,
    0xc01d48e9ad3e7156, 0x3ff54643dfa23339,
    0xbffafeab0df3b588, 0x3fea31ccfb2e4758,
    0x3f84bf9ef61315c0, 0x4009383586563804,
    0x40047da7365e8988, 0x3feabb388ada6fa0,
    0x3fe2f65595c35d96, 0xc002612ad4320c6b,
    0xbfd489be1e1be10c, 0x40092c4f25b37e0a,
    0xc00aace67c395bd8, 0x400b56ee80c9ad60,
    0x4016b36fa27b1b4a, 0xbfea5553c8dd47b8,
    0xbfd37e8bdeb038d6, 0xc00860962e7e0af6,
    0x40010a78cfa19a3e, 0xc0044a3acc357d52,
    0x3fe1eaf713d13651, 0x3ff5694cb38b30d6,
    0x3ff5bdcaeb6a47cc, 0xc010b442c7624d7e,
    0x3ffa1b3e54818cf8, 0xbff582983b52c5b0,
    0x3fe9b2532b49929c, 0xc00148e439112121,
    0x3ffdd6a78bc61bb3, 0x3ff8f5b1718f1029,
    0x3fb926dc3c2e3c70, 0x4010fc7308a39800,
    0x400b0de45916fc2d, 0xbfd987cfd618be1c,
    0xbfee3802eeb4bcf2, 0x3fdb7304b0898508,
    0x4002d7fb5bdbedc2, 0xc000420c869a6742,
    0x3fcec2d785bf4d80, 0xc00fd5ad1d967aba,
    0x401038c1ea420894, 0x3fc8e74c9927607c,
    0xbffb0eda8d3f1512, 0xbfea26617f503ca4,
    0xbfff3d9487b568ee, 0xc0015734908ca0ee,
    0x3ffb6c98430879ad, 0x3faedebb35073bc0,
    0xbff2e7aeed1741a7, 0x40044d646c71937b,
    0x40118a8078d17272, 0xbffd6d73065185cc,
    0x40048066c1cb92a0, 0x40017821b6b69386,
    0xc00427a8aef1874c, 0x3fd7d8edbd9f2c20,
    0x3ff5369b5b936a6d, 0xc00f9d997134a372,
    0x40042b9fa99e3d6f, 0xbfe78194e271a114,
    0x3fdefbb9e49a0640, 0x3ff6e34bbb8bbf19,
    0x3ff50d5031bd6f1f, 0xbfca849505bb2dd0,
    0xbffa7e38d009d4b2, 0x3fd64e2941c3e2fe,
    0xc00a67f868fb14a6, 0xc0122d9d17904a8c,
    0xc003dac5e6c1b284, 0x3fd84b8b350dfdd2,
    0xc004487fff564b25, 0xbff84e8c76f642b8,
    0x3ff7da166dd45654, 0xc004d6d458b02ebb,
    0x3fff81515363ec62, 0xbffdcc83dda6b049,
    0xbfeaa7014cfa97d6, 0x4000d605aca8bfea,
    0x3fffdeb28ce5c9fc, 0xbffbfd38f5564a79,
    0xc0027737e8ba9b82, 0x3ff36287d1a5cfbd,
    0x4009f4f4e662750b, 0x400cee79aefc20b8,
    0xbfd2d2b350ddf828, 0xc00b55e9b4501b7e,
    0xc004239ce7900386, 0x400d0e474dd63b5d,
    0xbfe2cc352dce381c, 0xc01213ca3c5cd8ae,
    0xc00432f721f1d28d, 0x3fe04c6d061c6a6e,
    0xbffb61974c560acb, 0x40080ea82e7e39c6,
    0x400b2d0afc4f537b, 0x3fe9c83283c6b9fa,
    0xc0029db027a5b891, 0xbfd64dcbd159da80,
    0xbff4c8a34e4c9332, 0x3fe5b3d26b3c2206,
    0x3ff4663021c653bb, 0x3ff19a911396f6eb,
    0x3fe280458a26b9b9, 0x40039e2205bd7e87,
    0x3ff1aea34b0e1d21, 0x3feeb895bf141df7,
    0x3fc1d5e6778034d0, 0xbff588e4a0acaa1c,
    0x3ff16c96ddbcbefe, 0xbfab9985ab1d8280,
    0xbfed499d2f3f1012, 0x3fd55af2eac0db24,
    0xc007c33255de1299, 0xbfb0a9efba7a68f0,
    0xbff7109b27e43f63, 0xc010cacc29e6d7ad,
    0x3ff9db21c3751b16, 0xbfd161d137503b0e,
    0xbfecd3eddf162470, 0x3ffc707c7f5afeda,
    0x3ff9118f5bf418f6, 0xc00c8a5702e09385,
    0x400a4f88a59c715f, 0x3ffac219274bb8a2,
    0xc000fd7c18b92640, 0x400874e7b3e9dac9,
    0x3f9795243a087b80, 0x3fd10f167c31cdb8,
    0xc0096bada1b8664c, 0xbff3274feacf3db9,
    0xbfbe7afe5c37fd90, 0x3ff27a354b00f076,
    0x3fd526ba8f41779e, 0x40006748be8679e6,
    0x400df03f153d89f4, 0xbff86c4976717344,
    0x3fcb2ab26d2f3cd8, 0x3ffa9f56ee83e32e,
    0xbfe41095e2c8a483, 0xbfdc5c8bda9bc0e6,
    0x3fd7949aa81cf294, 0xc00eb0b630a25b4b,
    0x3ff4bacdcf602e97, 0x3ff013ac191b3a95,
    0xc00b6d832ab65164, 0x3fe50ab1c449415c,
    0xc012002eab11af73, 0x4000d6cc0065b6d9,
    0xc00c11d78d6ddc51, 0xbfe48f44e7d5e614,
    0x4013ab054c100e28, 0xbff610da0d951168,
    0xbff56e0a207c8fdf, 0xc013f70cdc7ae14d,
    0xc00a8623248b29a3, 0x4010a3ce6ef58c16,
    0xc001429bc609ceb4, 0x3fa46576d5e9c000,
    0x400432ae89401f8e, 0x400f253e180f6a68,
    0x4005d10cc446f804, 0xc011c209e7afa220,
    0x4015a2c336c3883c, 0xbfe77b2324f5234e,
    0xbfdb093056fecd64, 0x3fee09235472962f,
    0xbffee82e67e7264b, 0xc01306d11bd11afc,
    0xbfd6764d47f47d78, 0xbfea2fbfb7cd2204,
    0xc005cd8a695904d3, 0xbfe0fadd24adfb4e,
    0x4003a0fb7b61eb22, 0x3ff5381d1b24c6ba,
    0x4008cfa5a206890b, 0x4002124495d32c06,
    0xbfef23b4715bbbea, 0x3ff2c5dff87490cf,
    0xc0098b3911ad6cbd, 0x3ff6c15b74babd5b,
    0x3ffe4f52dbd4b090, 0x4000c52a12727cf9,
    0x4010222e8844f60d, 0x400b7b46625663d0,
    0x3ff4d842437b4e40, 0x3ffd47d75b700d4d,
    0x3fe9de47a2f0144c, 0xbfad5d90cae9f450,
    0xbfc794a0b5ae177c, 0x400b434fcd16b574,
    0x4002d910697fbe05, 0x3fc6cd2aad6c95c0,
    0xbff653b7f425893b, 0x40065c4ce5b23e04,
    0x3fe165eca9e2007a, 0x3fe551a2112d6a94,
    0x4004377fb010481c, 0x3feffb9154ceae49,
    0x40034912b1f8750d, 0xbfa3b40bb4902a80,
    0xc00e296a0ad8b306, 0xbfb214f9239612fc,
    0xbff8183808fc2b42, 0x40020f2a21b1938b,
    0x3ffd0c855979fa46, 0x3fe0914cb8bc1e13,
    0xc003c6cc86421bda, 0x40068a743c2a96b4,
    0xbfd9a8207f95626c, 0x3ff536d74285d51f,
    0xbff0174c258b45a0, 0x400d0455e32238a2,
    0xc0066332b37b4778, 0x3ff8ccf238ed16e3,
    0xbffbb6b9da4dd9fc, 0x3ffb4161baddf6e8,
    0xc011108b07de9cdd, 0xbffe162a8baa2a3c,
    0xbfefc767d97f2720, 0xc00667604c24a2a4,
    0xbfc5b98f3a5d6cfc, 0x3febe81244418535,
    0x3ff9a0351016ded8, 0xbff2cdc0a89cb233,
    0x3fb05d6c75fd8340, 0xc001470bf937319e,
    0xbff05b7ba06b1ed1, 0x40069fbe9ae6a0d9,
    0xbfd31c31a8c9eea0, 0xbff1f05c54642df0,
    0x3ffd640bc91e9a40, 0xbfe01a220f847b76,
    0x40011d33fc953e4d, 0xc006b728ba50f61c,
    0xbfcbdb9165cdf050, 0xc00b76e6e8bd9b35,
    0x3fd3504e781737b5, 0xbfa57da595021500,
    0x3fbba373cfcde748, 0x3fc161679ec23d08,
    0x40099685e7884f73, 0xbff0511b0e37376f,
    0x3ff957c922e64eca, 0xc00b0eccf5550e76,
    0x40012b27d14e0612, 0xbfe195f1565dfd12,
    0xbfd07c4858d1c3e4, 0xc01703d8439beb20,
    0x3fc120bc789fc97c, 0x40163a4cdd756a59,
    0x40041966ec4e85b2, 0xbfcef9b7d74c55c8,
    0xc00066201c9316f4, 0x3ffe0c9b367d0c5c,
    0xc001eca93ce0cde1, 0xbff4eefd98e08fe0,
    0x3ff15007b8a25684, 0x3fdf0929db334f7a,
    0xbfe3a85bc63a426e, 0xbfa22ba2d5b86140,
    0x3ff04f509ecdec6e, 0xbff6a4ac85b975be,
    0xbfb2db941e55fbf4, 0x3ff9370c77daef5f,
    0x400a61421f2085ec, 0xc002dcf540616732,
    0xbfe27ef639e44f86, 0x4000b7964f966478,
    0x3fe140d4ae9ae504, 0xbffa16151655b1ae,
    0x4001527d74371a88, 0x40042d53ac71f647,
    0x400d59ad427039e4, 0x3fe5829266c04a0b,
    0xc0065bd580db9872, 0x3ff94de48d0b6057,
    0xc00e662b360eab3e, 0x3ff1e5968b67048b,
    0xbff0ce1970108413, 0x3fbbe6f7acc5ccc0,
    0x3fe47ab4e2a51104, 0xc0052efc21fd2370,
    0x3fde5ec025e3eea0, 0xbfde23a6a8db0250,
    0xc008e317a4e14d38, 0xbfe698cce2d5b4c6,
    0xc001136394b40631, 0x3fd0cfec37518482,
    0xc00211817c95deea, 0xc0018295b5b82580,
    0x3ffb9e7d30602d83, 0xc00237d4b9bd6f83,
    0xbffd8d2b5bbe08ce, 0x40067df0e9a8f2fc,
    0x3ff3273958941fea, 0xbff348c133067f30,
    0x3ff5777d11bb6568, 0x3fc1d79f293f1718,
    0x400b55be658f63e9, 0xbff7e64bbe550093,
    0x3fe6b09afbc82b2e, 0x3fc53613bd8c0810,
    0xbfcd31fa30e2ccb9, 0x3ff685a7550e58f9,
    0xc009287856df0297, 0x3fa0f262371c8220,
    0x3fee6fe6b8497b25, 0x3fbf066802d1d6d0,
    0xc00bff21476d3976, 0xbfe9e3e818066a87,
    0x4006eb8d9ccdf3f1, 0xbfd3a4f3f97ec88e,
    0x4013fb2dcf5f0f60, 0x3ffcdbe1dd1c6744,
    0x400d0b8356c5081e, 0x3ff11c53896d9a7a,
    0x3ffd467a09d9d9eb, 0xbfef6b73121f9520,
    0x3fede08bf4bbc214, 0x3ff8101f3a229997,
    0x400c58ee212f004c, 0x3ffb556e8125003a,
    0x4002a86611911d2e, 0x3fd0003e6cf1ea58,
    0x4000566e23ea4d23, 0x4000aa6a35ec0cc5,
    0x3ff8365c46ca206b, 0x3ff30b3d6488968c,
    0x400d0c59b58f9058, 0xbfd3803002b3b1a2,
    0xc011860f09815a8a, 0xbffb150f3cbd6314,
    0xc01093023c99a032, 0x40101c99650278a4,
    0x400661fde12c1ab4, 0xbfc4f144f07d8407,
    0x40026372d81227fb, 0xc00294c21316eeeb,
    0xbfeb16a191778050, 0xbfc3b15aafac931e,
    0x3ffddbf4872e5536, 0xc008c2e192304098,
    0xc011552a0c20b42c, 0x3fa6f5f8f86a7270,
    0x401e090415e0bade, 0xbff4607eb24e4e7e,
    0x4006e9aa969003ff, 0xc0007049c39f002c,
    0xbfad04bafbf355a0, 0x400118c34a14a0f8,
    0xbffc84d90adef51d, 0x3fd3b81c8c6a146b,
    0x3fe59fd5a7760a62, 0x4006a1237807911c,
    0x40105604da3ee595, 0xc008d5311cd9ed10,
    0x3f9b4fdbc95238c0, 0x3fe6c1ee285c9ed4,
    0xbfc9f5b60a9cad58, 0xbfeda541640b4548,
    0x3fe96ee06a17c964, 0xc00e5e7438de8d42,
    0xbfd45f7e0e0018fc, 0x3fe73772f0db9942,
    0x3ff2ec86aaf8384c, 0xbff2b4774898010e,
    0x3ff0f89a4dd79671, 0x40033cfcd114c26f,
    0x4002ade2dfd0cdfa, 0xc010e4da161c874a,
    0x3fc101dd8c78e7d0, 0xc000c78df5a74c19,
    0xc00d9fa2757635ac, 0xc00ad707f603dff8,
    0xc00a7b3896c8cb19, 0xc00c6a60c793320d,
    0x3ffc8b2660962289, 0xbfed0d418958cb56,
    0xbfeed460b2bf3e48, 0xc000d65ef745d4ae,
    0x3ff16182948936da, 0xbfe3ab1ae4f48044,
    0xc01196d22b203ac8, 0xbfeba21ef1d5bd30,
    0x3fffb84b9b28c100, 0xbff7aabc5fc3a20d,
    0x4009b25c8991d86b, 0x3ff2272a001c7d48,
    0xc012333cf3bb4a44, 0xbffbf4ed8ccf5efd,
    0xbff23078eabe1a7c, 0xbfb1c0e8ef291a10,
    0xc00eb3cc266b2bbe, 0xbfb142e288b133a0,
    0x3ff23da231c340c8, 0xbff7a66eec78b5b0,
    0xbfe8d739a40b4c27, 0x3fd86e4d662bd716,
    0x3feec745e63a177e, 0xbff4ddd8c6eece6f,
    0x3fcd299a4269d410, 0x4005b43bde8d3bee,
    0x3fe7375ea6d67737, 0x3ff2e6daf4eee34e,
    0xbf8934373c573cc0, 0xc0052dc67836d275,
    0x3fd6700790e18593, 0x401c0da74ec2623c,
    0x3fc4a8ccddeb1130, 0xbfe6c04f6d58461b,
    0xbfebe85f0e99ae1e, 0xbffee452886a0348,
    0xc0048ec26e46a947, 0xc0002b5d2cbcdd7e,
    0x4006505d21e35911, 0x3fffe109d0f28c5f,
    0x3fdd57f381d9193e, 0x4007dfa494915318,
    0xbfee814da823d3f0, 0x3fb35e702cacd248,
    0x4000734ff8bf32d6, 0xbff8cab4e9549c84,
    0xc0056ff1ad19a806, 0x3ff20fd02882c5bc,
    0xbfc872cdc116b7ac, 0x3ff056e0157bb1ac,
    0xbff1ce844c4b6199, 0xc00496f66757416e,
    0xbfb83f5c5fcc2e38, 0xbfd9aafe684b1598,
    0xbff8fd12893b27af, 0xbffc0a082f9a0aac,
    0x3ff92338b2b0a54d, 0xbffc514ad5190be3,
    0x3ffe9cd65d92831f, 0xbff8b83668fcb8c3,
    0xbfc03d281c2c51a5, 0x3fe546e10442cc6f,
    0x3fff93a039b67ca8, 0xbfd8c09e3db19244,
    0x400839a5bb0311f6, 0x3feffd6cc5c1369f,
    0xc007896d6689aa8b, 0xc001b423f5470b46,
    0xc00798a1966f5b10, 0xbfa4fe67ba068f40,
    0x4000c9c4e657e0bd, 0xbffb3f4d354af6ca,
    0xbff61c197c16abe8, 0x3ff392fac025b149,
    0xc00581b901a72ab1, 0x400d8827274a9363,
    0x3ff9b74bd7960935, 0xc016dbec4b44d78e,
    0xc013f41ba46f9621, 0xbfe0a4b82a2d6493,
    0xbffceca60d6ea93a, 0xc00434859193ab15,
    0x4007bd834cf39711, 0x3fff96f6dd8845cc,
    0xbfe3f0022ab88314, 0xbff684cbb3ebcf8c,
    0xbfde7b80685a2c9c, 0xbfe92b28f114b45c,
    0xc016767828a4d965, 0xbff54946d6b6656c,
    0x3fe3b74783275cf0, 0x4001e2a80564f1b5,
    0x3fec586e5cbb6ab6, 0x4004511646b6465a,
    0xbff0306133dfca64, 0x4000acd69eba4886,
    0x3ffd818adfd022a1, 0xbff22aa60f187a6a,
    0x3ffb6ab37b50e863, 0xbff1923049bf88c8,
    0x40010178fa15139c, 0xbfbbbcc1015fc7b4,
    0xbfeba19c4473ee1d, 0xbfd7cbbbed6da5a9,
    0x400721c51ff21a6e, 0x3fc8727d32c35580,
    0x3fe3b5de5a0ff2a2, 0x4001e0055895db72,
    0x3ff953286eb7e693, 0xbfff8006318aec5b,
    0xbffa62afa933c8b8, 0xbfd79878cb9d74f0,
    0x4003625494b85891, 0xc0098c5d4b28d247,
    0x400c1d522008c87c, 0xbff7dd5bafbde314,
    0xbff11e83df264c27, 0x3ff745bf6a320c0c,
    0xc002259ab3dbb5ee, 0xc000a4bfa7f13ad4,
    0xbfdc5fd54fe2a788, 0xc002e2b0780b43b0,
    0x3fec2d982e3c29bc, 0xc008491e36ee9769,
    0xc014a6ba6697e287, 0xbff44f6b6085a8ba,
    0xbfe5e137acdda462, 0xc00579966197700c,
    0xc00afc0981fffea8, 0xc0117989615baa2e,
    0xc00fa8f0fd6914e9, 0x400c7350f1534ac8,
    0x4013144613bd130e, 0x40044f73e1277a58,
    0x3ff1339964cb6efb, 0x3fd48b6fb13142ee,
    0x3fe83437fc29cade, 0xbfd77cadd6cfea94,
    0xbfd9ec37d8cae060, 0x40043f3f3c192f2b,
    0xbfb00b10cbd0dcc0, 0x3ff1854f8e97ccc5,
    0xbfc129a2648004b8, 0xbfd88d06956f5e28,
    0xbfe6469edbfb3084, 0x3fe8a74bb3f00e70,
    0xbfe659278e2e0b28, 0x400a92dbdc237a54,
    0x3fe6102868dfd1c5, 0xbff34b899f2d4514,
    0xc00308c58a55a3de, 0x401563001894db7a,
    0x400c6c4357240428, 0x400387d49255f5a2,
    0xbfe374a183d59a43, 0x4006d15585d128eb,
    0xc008a8cf5bfaba2d, 0x4003482f50677e96,
    0xc00531fe3fa43e82, 0x3ff6a389a7a02b98,
    0x4001d4aab36d53ae, 0xc01169dcb5c0310f,
    0xc00523d737e4620c, 0x40110833eb79bad0,
    0xc00bdc62dc84179c, 0xbffde044f7162cb6,
    0xbffa8675339ff7fb, 0xc005e07d2b8b2370,
    0x3fdcb9e820ca0330, 0x3fdbe3b3af209755,
    0x3fd98981cf7fdc0c, 0xbf8702c4599a9f60,
    0xbfb143c41443315a, 0xc01118087a49d4ad,
    0x400670f3dfeb08e5, 0xbff933e9503107eb,
    0x400751d958e301fa, 0xbff5a2f4fa2c1465,
    0xbffd2d118a30417e, 0x40086508303ca46f,
    0x400600f05218914a, 0x3fe19a1fdbce5888,
    0x3fbde463809fe658, 0xbfe25d7793705439,
    0x3ff61c9cc1d11774, 0xbfe7d064a927c91a,
    0x3fef5e20e84b301f, 0xc00e0538d8e43cc8,
    0x400d7f211cbc4cba, 0x3fbc9d27613cd746,
    0xbffa56d2e59e38fe, 0x3ff7367f4ceda442,
    0xbff3500f3de10ceb, 0xc004802d92079a54,
    0x3fe3eaf291351834, 0xbfd496262010cf9f,
    0x400cb410b7e66b09, 0x3fcb6a4804e40464,
    0x3ffdf89b172f0152, 0x4001d9f8e2c89962,
    0x400eafd90f0b272c, 0xbff25d1cece9fc70,
    0xbfd5963115cb3548, 0xbff4447691f4e7e6,
    0xbfc261cc1d161e40, 0xbfe0950408e26114,
    0xc00fe9b18e151e5a, 0x3fe9346a810f550e,
    0xbfc11baac1d41a9c, 0x4006657989076338,
    0xbfb32e34b53ac620, 0x40005408aeccfcee,
    0x400b9885edb9b041, 0xbfea3822a7ad822b,
    0xbff29256518b0c76, 0xc00913d108b88c76,
    0x3ff0c46e3662e9eb, 0xc0043de481250170,
    0xc0021ee5b85064de, 0x3fd534c69c34796c,
    0x3fd2ea75f1d84a7d, 0x400374168909c468,
    0x4003dcd5ab6f9653, 0xc00ed4b835b2fc89,
    0xc0010187ad3aa7b2, 0xbffb0fa414ced048,
    0x3ff58395d27c712b, 0xc006b549d72c2bde,
    0x3fd502b0a43b07d5, 0xbff0e057ac044266,
    0x40123d762575a99e, 0x4011f9b261e959ce,
    0xc004d33a5f481304, 0xc00adcff342bad21,
    0x3ff70e65bdee4aea, 0x400efd2abd09802a,
    0x3feb21cce8969b75, 0xbfefb8c61af73866,
    0xbfe58276e5705ff4, 0x4009a09365448dd0,
    0xbff550a08a81315c, 0x3ffb3e53f4042ecb,
    0xbff0cfc3c33ccbd5, 0x4010a5ef8cb3a4b6,
    0xc00417c262f72579, 0xbfed14cf371a9e9c,
    0x3ff7d1bf43c7fa00, 0xbff59b5ef83d85ae,
    0xc001d3e98ddb1ae3, 0x3ffab95ecc57c968,
    0xc01a0936793f9e66, 0x3ffefc0f68265be0,
    0x3fcd80e7300dcb20, 0x400b533e8c6b4d9b,
    0xbfe5538c81384f4c, 0x3ff39655a379322c,
    0xbfff26459e1d4f10, 0x3ffdf44c8ce9e542,
    0x3fe4e12d6878a0b3, 0x400741914c778a07,
    0x4008fe106c07abce, 0xbfc276827c20e510,
    0xbfe3ad6caa276046, 0xbff394a8cb2107ff,
    0xbff8c0f0e5489f06, 0xc016c872b1a26b32,
    0x4002f7b904de5d59, 0xbfff9acad6fe632b,
    0xc007507c9712cef0, 0xbfca874d590ed41c,
    0xc00ca691007d618e, 0xbfa1683e9a14c85c,
    0xbff243afd818a1f2, 0xc003e9d5ed831f95,
    0xc011171537a86e14, 0xbff68df6849fabeb,
    0xbff8a4a21496d608, 0xc0016cc0b28bc971,
    0xbfd2146b8a02da20, 0xc0033ebdca0a448c,
    0x3feee6f7c705fc58, 0x3fefc6bcfeeebd79,
    0xbfe2e911adfc9271, 0x3ff40fded65956ab,
    0xbfee583db6cd317c, 0xc00a6d9e66c9b03e,
    0xbff39676ef578216, 0xbfe1461fd4149bf3,
    0xc0103202846078bd, 0x3fe39dfd815e64f8,
    0x3ff6a900026ae30d, 0xc00917a5cc05f36a,
    0xc009fe74b5d8abef, 0xbfeb666c145fbb08,
    0x3fce86719a7a4641, 0xbfe09722f37856fe,
    0xbfffee5eac70ead0, 0x3ff2f5a453028c0f,
    0xc0030de93906339c, 0xc0031abcd7d3da06,
    0xbfb51b9f834a7ac8, 0xc00d1a2fd738e085,
    0x3ff2074cc0b75e94, 0xbffab004caea7310,
    0xbfd7cc6b9fad5f02, 0x3fff6fc4fde3ad86,
    0x4011da18d0b5fcf1, 0xc007eb8b749fce46,
    0x4011082d85876b2b, 0xc01314e85ab30c7a,
    0x3ff9061704b3d73e, 0xbff850e808cfa605,
    0x3fe69cf70beab831, 0xbfdf44d450ed7e98,
    0xc00682dca352b651, 0xbfda0ff71133860a,
    0x3fb358aa20ff0b60, 0x3ff318c58f762fe7,
    0xc00e5b783795204a, 0xbff6e7c68fa4599a,
    0xbfd81d75e29c1fbb, 0x40048870a02984ce,
    0x40009def10099b84, 0x400bfda7f5987d25,
    0x3fc6361a2dee0b50, 0xbfe21f5d2df7eca8,
    0x400da94f413a3c7c, 0x3fe28816857a3ce5,
    0x40054bbe1f605bec, 0xbff3639cf751b780,
    0x40008252fb4f5a51, 0xbfd2860f76260e28,
    0x401262adeddb3ae6, 0xbfe461cf1963e89a,
    0x3fdae4d4cdacadb5, 0x3fd00e095302d430,
    0x3ffc27e1198bfa9f, 0xbfc1bf1cfe0e38c4,
    0x40019165361a30ec, 0xbfd350970049d3ec,
    0x3fdc05eb20218904, 0x3fd3d7226c11e18f,
    0xbffb063c44abd6bd, 0xbfc5fab2deac17ee,
    0xc0008bc948fa8c8c, 0xbfef26440743db6d,
    0xbff3dc52cc2da682, 0x3ff2152d9a408b5a,
    0xbfe6acec994b2910, 0xbfff9542df3fe9ee,
    0x3fe4d856c517efac, 0xbffbb0ec270801fd,
    0x400b67e102d91e58, 0xbfce826bd81e21aa,
    0xbfbf71214a21f708, 0xc00a2c74fde1060d,
    0xbff6d097a0f4c001, 0xbfd47c73824e60aa,
    0x3ffb0c6697250484, 0x400caee9e887aee1,
    0xbfdc51a6386c0489, 0x40081803d2ebea84,
    0xc000c53ea3c4aeee, 0x4012d389bb96b63a,
    0x3fbf1cffd32f84c0, 0x40013ecdedf0ec86,
    0xbfef68a5180f81ca, 0xbff9aef1b9ae3e14,
    0x3fece99c0ed66ab7, 0xbff4727fcb6c723e,
    0xc0064f230b7fadc7, 0x40115d46a01d1d1b,
    0xbfdf9af9025b93c4, 0xbfc6acdade5eb527,
    0xbfd250321f9550bd, 0xbfe7cf0849df8d10,
    0xbfeaf1d751433864, 0x400293c579c9948e,
    0xbfe0c6ed6d26f95d, 0x3fe68e39a51a351a,
    0x3fe0b75863c7fd07, 0xbfcbe82d32f7b160,
    0xbff968f9fe49a27d, 0xbfea7bc4cd6b7ee0,
    0x3ffe642934201845, 0xbffefff65090975c,
    0xbff7cd4bec9ea8e6, 0x400ec1b5fa92f6e0,
    0x3ff2adbd350c02fb, 0x3fe125900a8a2eb2,
    0xc015fd0d531533c6, 0xbfd1f8d40f759440,
    0xbff78771440f70ba, 0x3ff6886d673b876a,
    0x3fdaaa1bd8f2d9c4, 0x3fe317cd609d2236,
    0x3fef5183538f2ad2, 0x3fdfc661ffa5c86a,
    0xc00bb4213cb2aa64, 0xc0057cb660f74d2b,
    0x401181e64d32aa73, 0x3ff93c7312e5652a,
    0xc00c8333f4cddd6e, 0x3fd40db30a9ca24f,
    0xbfb5ac5c833a231c, 0x3fe37c4a151fd5ff,
    0xbfeaba8c4ec94720, 0x3fe30090ea9c47ac,
    0xbff5bc778b6bad18, 0x3fb0343d3dd92230,
    0x400e2c66fe4d9e8f, 0x3fbcc0819ec16da0,
    0xc01060e1c44b6019, 0xbfea3d6342dba2e0,
    0xbfe8b4091a09f53e, 0xc006ab1bed0e7e09,
    0xbfdb0cc3874c73b0, 0xbff8c586a8cc48e6,
    0xbffa2904f3674811, 0x3ff1b2840999ed87,
    0x40030e442dfb3168, 0x3ff9c00ac02b064a,
    0x3fe8f24b8ad04eae, 0xc00cb646811d7ab4,
    0xbfee5ab8803eedb8, 0xbfc64be77bacba20,
    0xbfd311766fe6d144, 0x4004eaab83edbbba,
    0x3fedca8b7e4b5bd1, 0x3fe6f2d1c9548775,
    0xbfded7ecdf1ee6f5, 0xbff74532ae241b37,
    0x40040550cbdb6f8b, 0x3ff07168cefb432c,
    0xbfefd9ecf25ccb9c, 0x3fe2bf79f177087e,
    0xbfe947990d0c3380, 0xbfde70558c87326e,
    0xbffa2026f3be168a, 0x4001574ce77f8665,
    0x3fc917d341baa428, 0x3fe795c803953934,
    0x3ffc882fef25af36, 0x400123657217b7ce,
    0xbfe260f0df227469, 0xc010d5cb56d18c16,
    0xc0060b813742d34c, 0x4002a7204cb355ca,
    0x3fface88e040c1e4, 0x3fc0ae716fc79300,
    0xbff12fb604398e2b, 0x3fe2d4364ba70b07,
    0x400349717fe87d1e, 0xbfec210c550dfaf6,
    0x40016237af12db63, 0x4007fa7d7f3dd779,
    0x3feaf8fc0be582e2, 0x3fe6e48bb7714c36,
    0xbfeeb12048b9ea16, 0xc002bf191021dce8,
    0xbfe6e5abf386038c, 0xc003f6d17c0cf104,
    0x4004c5cda57c2f08, 0x3ffb2c9059b92476,
    0xbfd86edc5dbc35ae, 0x3ffaa1b6504535b3,
    0xbfdf8564837957bc, 0xc0031c0074679830,
    0xbff2747a7f961b8a, 0xbfd997af02d89380,
    0x40054ac1dd6c465a, 0x3fe2fb4c25538c3c,
    0x3ff32637441e7196, 0x400a131ceb77e34a,
    0x3fd2946d24f8e5ea, 0xbfb07c28ccaa38d0,
    0x400acbfdf015c2c4, 0x3ff59afe89a332e7,
    0x3febc5d5815ee6b7, 0x3fd5e4376cd6e1b1,
    0x3fee4b372034bc5f, 0x3ff845d2489f6cd4,
    0xc009dbd35f4b6e10, 0x40018c766be035a6,
    0xbfebabc24ec613cc, 0xbfdd692adff8b0ca,
    0xbfd376958783c050, 0xbfdf21ab654f184c,
    0xc00a1779ca7a784c, 0xbfe97f8a480b806b,
    0x3ffb651a24aee7c1, 0xbfe632d918bd75ae,
    0x3fbdc88956d5cbe0, 0xbfe9544683056c29,
    0x3fcdcdd293722c00, 0x3ff9dec168428182,
    0x3ff3e2668f188f02, 0x3fe17cdb36391976,
    0xbfe41f2bcfc974de, 0xc0061be40e90e898,
    0x400ce79058d8753a, 0x3fead7e828b89db2,
    0x400a49089605c3ec, 0x3f894e998a0b29a0,
    0x3fd61e47885c224f, 0xc0001df08db90250,
    0x3fd1678da0819153, 0x4001158cc88c1c26,
    0x3ff9862231fa10f6, 0x400512a45624747c,
    0x40000b4c451f81af, 0x400cfe56683a55fe,
    0xc00328bf58800cc0, 0x3fc44b75508876d4,
    0x3fe8e12b767bf846, 0xc004b50b0ca74570,
    0xbfef021a3d238a11, 0xbfda6c473b37681e,
    0xbfe7f8192c1734d4, 0xc00b1e8795c2b39a,
    0xbff202cc35ddd95c, 0xc010eab0301fe51c,
    0x3ff8b3e0fbb3402e, 0x3fea64d96e84e0cf,
    0x40006d26aa5152de, 0x3ff9f27b40e4562c,
    0x3fead5bae46e6d89, 0x3fdda64d05ec16e2,
    0xbfffb691a1546dc8, 0x3fce70ae5eba5740,
    0x40103be2f1ab432d, 0x3ffeb1cba91ae1b4,
    0x3fe4e429b2304cb8, 0x3ffd815fc946195e,
    0x3fdbc43c3a613d22, 0x3ff919ab8e2f75ba,
    0xbff05ce4e93e09b3, 0x4006106340cbfe31,
    0xbff990b8393fb212, 0xbff2c64dc37e3bce,
    0x4005c3988a2d7b25, 0xbfe29963a1e13b24,
    0xbff39fe61549bc4a, 0xc00255ed141952ab,
    0xbfc3533277b76968, 0x3fca9f0751c22168,
    0x3fe166a003fdb07a, 0x3ffb2bb883783180,
    0xbff1765fecd58cb2, 0xbfecd950adec0aaa,
    0xbff1796ac9fd28e3, 0xc00c66587924f43e,
    0xc009da5adae018a2, 0x3ffe285c18cb707b,
    0xbfd688daf05f29e0, 0x3fae0b8135289b60,
    0xbffb58a42c390c80, 0x3fbda521f733c380,
    0x40039f3d770621f4, 0xc008d744bb8b4fea,
    0xc0067180e6bf4b15, 0xbfe642e2584cbb69,
    0xc005de68da691e86, 0x3fe892fbc538a5f4,
    0x40110c75d78f8532, 0xbffa80d9016c83c5,
    0xc007944659ed5193, 0x3fed18e522bff161,
    0xc00d66999b09ced2, 0xbfac30c5e845c9c8,
    0xbff64ecd32e70824, 0x3fef186eacd43f5f,
    0x3ff393abbb497073, 0xbfe381cd7522eee6,
    0xbfcc0e0573c5e644, 0xc00cdde5834fd6e5,
    0xc00bea7af0a643cb, 0xbfe4a7ac250b956c,
    0xbffc6b3cf28a8904, 0xbff1ae1fe8f5ff5f,
    0xc01295a4525a1e39, 0x3ff4bd3663c8939b,
    0x3fd0bc4459e7eaba, 0x4004c5d70a81b88b,
    0xbffc89cd936f553f, 0xbfdbece0129c3d45,
    0xc014730d9d13813c, 0x3fd60e9520ecb691,
    0x3ff94d818e281f76, 0xbfd8dc941ffd92da,
    0x40143716fb00a61d, 0x400eb16ddc2ba212,
    0x3ffdbf5d5a26e784, 0x3fe1cb7d9f026045,
    0xbff0224af2e35ce6, 0x40075fc6e7f635c5,
    0xbfe0d488edc4a182, 0xc003e8b75e18104b,
    0x3ff3f20848e6b9a7, 0x4010fcb7f9fe3521,
    0x4007fdd456b9bd40, 0xbfddc2be13c39a40,
    0x400aef9c3a55acdb, 0x400d5825b4d9c8d2,
    0xbfe89b31aac912bb, 0xbfd3146a826ea02f,
    0xc00aa1145ee1213f, 0x3ffaec1589a3893a,
    0xbff174d3efc47b75, 0xbff5864c161898fb,
    0xbff08f5077485c28, 0x3fb5108a0ac6f3fa,
    0x3ff8b7ccf106b36c, 0xc00468599360eccd,
    0x3fe600e335c96318, 0xbfaf8fcb64d6a4a6,
    0xc003be6188e9ba8c, 0x4016f5de9957310d,
    0xbfe939dc0fb16d1d, 0xbfd5bdcfc1fdb4f8,
    0xbfe992ed22174a0d, 0xc0055f6af23d3380,
    0xbffc2a338cd02e4a, 0x3fc765fb697d00cf,
    0x400c2e3c039b041e, 0xbff752fcd9194d0b,
    0x4011de0eddb61e74, 0x3ffdfd4c04ed8345,
    0x3ff95d4b07225498, 0xc00576af6feef700,
    0x3ff3b3d892c979fb, 0xbfd68f4d3810430a,
    0xbfe36080c9af7dd4, 0xbfe2c1e0a37a392a,
    0x400794f61d0329d8, 0xbffbe68b41fdb5f6,
    0xbfcf4c6f7386db0c, 0x3fbf5a725c7e54e8,
    0xbff0db70614f4475, 0xc0178b494fcf6697,
    0x40122773f7fe5ad4, 0xc00f6492de81ac3b,
    0xc00657bddb2963ec, 0xbfeb4eb74e7da412,
    0xbfd396a87a3a989e, 0xc01346188367fa1c,
    0x400770762a6cb851, 0x3fb0c2026c097775,
    0x3fe9c62780512be9, 0xc006165e3e4500e2,
    0xc018f62fe44a1a84, 0x3ff521008a40975a,
    0x3fe864a8cc8c2e26, 0x3fd69f1cae4a9afe,
    0xbff0bfd371da2536, 0xbfef2989ec71bd86,
    0x4008e077413cb05e, 0xbff79e21ef268bc1,
    0x40065940a4038e60, 0x3ff7d3caeb6e5366,
    0xbff792fa8aae0eaa, 0xbfbdbbc9ab4d1420,
    0xc001ce703d5a670b, 0xbfe0161db0103c26,
    0xbff7be3c8a5041d0, 0x4005836994008a4d,
    0x3feb30e646434cc4, 0x400c9534fc2460a6,
    0xbfab44afeeae8fa0, 0xc0076243882388a2,
    0x400ca2f715c98670, 0xbfd4b9253f59aa0e,
    0xbfed4e5b2e75ca56, 0xbff825e6f419da02,
    0x400338a644ccdf20, 0x400073197e4a4a71,
    0x3ffb14c7a1c88d6f, 0xc0126367716c19cd,
    0xbfccfcdc86f57628, 0x3fd81661295040ce,
    0xc0134528c8599ee6, 0x3fc973a9c65a7440,
    0xc00312663afd71b6, 0x3fda18dc0e230470,
    0x3fe50bfd0b7522aa, 0x4003a445423dac5a,
    0x3feb0571682f9a84, 0xc00757da22f98514,
    0xbfe0770dd849774e, 0xbfd548cca01d5d34,
    0xc002d6cf848e7884, 0x3fee4425d1e9e142,
    0xbffa9854c1ce7e72, 0xbff368d36b0b8447,
    0x40101aa4ea471d99, 0xc006efe5fd1bf59c,
    0x3fd296ada2537eca, 0x3fee66b48c9f63c0,
    0xbfdba169ad9df868, 0x40037d1f3a77f8c8,
    0x4000fe09ce23e597, 0xc013a471c102561a,
    0xbff27b02f694a4c6, 0x3f8987cc78544b80,
    0xbffc71b1af25fb6d, 0xbffbc3a1097f88e7,
    0xc01065692fa519e5, 0xbfe3546b8550320a,
    0xc0130519534d0a76, 0xc00348e752523f98,
    0xbffa4109155abb26, 0xbfeae9672a1b6cca,
    0xbfe275f9ae169340, 0xbfd02613fb1f11b0,
    0xc00eed9c552f2e3a, 0x4003b6ca5a6f4344,
    0x3ff89b7e2ac008ce, 0x4001f7fb682804ee,
    0xc007992270240da5, 0xbff6e56236b741b0,
    0xbfe86acd04e9a6a0, 0xbfe1f9bee158d9d6,
    0x4005db2b0765c945, 0x400d40902d3a1404,
    0xc00be4b3a08cc430, 0x3ff3eb3fe6ebfb95,
    0x3f8c0b4ba145c440, 0x3fdcfba461329048,
    0x4008c3ad134926e2, 0x3ffde0fb93c71861,
    0xc00cce20b85b87d4, 0xc01192f2c3754691,
    0x40162700a3d12695, 0xbff60a2e74c7c60a,
    0x3fe12924d4537704, 0xc00380b7318f5c31,
    0xc00185f15dd78276, 0x3fde662a088c6231,
    0xc0154e5da924e7fa, 0x40062404356205ff,
    0x3fe22a838f664315, 0xbfffd66fbdc8dd8c,
    0xc0012b9556aaea6d, 0xbff2149918b97c3a,
    0x40020cfd6dcbd6f3, 0xbf90924a2b1a80a0,
    0x3fffc002d0bc09f1, 0xc00cc16858413a8e,
    0x3ff8c0e96f82f67f, 0xbfd2d650903cc3b8,
    0xbfe594b2301cc9ca, 0x3fdb650982c18b0e,
    0x3fdf0ddfee22e09a, 0x3fe83b289f154ccc,
    0x4006bec9f33a2372, 0xbfec28deed885edd,
    0x400255bbf47e2f32, 0x4001a6f77cc758d9,
    0x4011a9ade1ba5c4c, 0x3ff1b285d592b9ce,
    0xbfd976d9461480f8, 0x40026a03e8a80a2b,
    0xbfeb9ae8a62c1628, 0xc0042ba497961030,
    0x400a1e1ec3fb749c, 0xc007b1dd8c1bd81c,
    0x3fdf69ec1cd6c7d0, 0xc00a60ea23f1d1f8,
    0xbfdbbaea80808221, 0xbfe3e2ef964511c4,
    0xbfffd545b31f8ff3, 0xbfd40ed2831d61b8,
    0x3fa9d62a60ed18e0, 0x3fcce44bbbc5b720,
    0x3fd6ecf412352b33, 0x40133a155e0d9f19,
    0xbfd96cda2908537f, 0xbff8222607222104,
    0x3fca9ed4136c1a9e, 0xbff67d3896109d9e,
    0xbfe3650e54cb9141, 0xbfe46df2e31572a4,
    0x3ff63851515d8f29, 0xbff5cd1f6df05f0a,
    0x3fded032a11a679a, 0x3fe8fec59187f65c,
    0x40079775d3648d08, 0xc00004e3c2508b11,
    0x3fbad3234960a970, 0xc005d38c728f842b,
    0x40024e4f6622802b, 0xbff6ed1e5b3099de,
    0x3ff9dcb438a88efb, 0x4001de3316da9ca1,
    0xbff4804023c5f4c3, 0xbfbb4ce8d70c42d8,
    0x40157932dfc636f7, 0x400aa513ec109136,
    0xbff895a6e054219a, 0x40116709b02028a6,
    0x3ff27cde0285a5bb, 0xc00529e7e475d0ec,
    0x3ff0cfd59a68636c, 0xbfd4de8f422cb7ec,
    0xbff5cdc86f729b6f, 0xbfe545280baf1d00,
    0xbfc5667b647c2cfc, 0x3fde70754b7166a4,
    0xbffd23213fc4cc2d, 0x3fdac6d84ebd4bdc,
    0xc00037dcdf23d1e4, 0x3fe3bdbbb35fa0d6,
    0x3ffda0c897f7478c, 0x3ffd9272765c1f60,
    0xc000ef6660a67f9d, 0x3fe41149d4a012cd,
    0x3fbbfa36d0311688, 0x3fd971fb45a128c8,
    0xbffc0e54301ca178, 0xbfc466e06b9c3b5c,
    0x40101dc4b6539838, 0x3f9a2fb9237c9300,
    0xbfff70ae7561dffd, 0x40062eaec04b0330,
    0xbff062493dbd4a16, 0xbfe9e2e9fc972274,
    0xbff0c2f1d1353a75, 0x3ff37ec0b9dad7aa,
    0xbff5f21df474d2fa, 0x3ff963c19ef3ac8e,
    0xbff0c9a299b59c4a, 0x40062ae98e15fe55,
    0x3fe6c05b7158db1b, 0x3fce2e349e1bafe0,
    0xbfdf73379ab392b7, 0xbfe8f8199800aef0,
    0xc006ea15cd7c3bf0, 0xc0044c0543335b94,
    0xc009426c3b113728, 0x40138acb2b4b5542,
    0xbfefae6422a04786, 0xbffd664aa5f8c0b8,
    0x401572578e0119fc, 0xc015c9fff1fd8970,
    0x3ff4c58c1ae450de, 0xc011e1c6c1c37fc4,
    0x40188c35030cf893, 0x3ff08e414ac09e54,
    0xc005f40fa0fe6cc2, 0x40005bc36b7af086,
    0xc000c2f0bb28b5e8, 0xbf9582c18b3ef5c0,
    0xbfe4dd5dbac740ba, 0x3fded8977494343e,
    0x401899c4d8373c91, 0x3fe3961b8e1d16d0,
    0xbfddcff18593942c, 0xbfd94f6cb49b16fe,
    0x3ff94c7f7d2fcafd, 0xbfeb5aa3ab954a96,
    0x400f305418009b86, 0x3fd87c9cb097dd10,
    0xbfff71c434a4be2a, 0xc00c16b8f324e7f4,
    0xbfef8f9581a1d64c, 0x3ffffe6a4bcaace2,
    0x3ff6104048660eb0, 0x3fe8e527cd1bd8e6,
    0x3ff9e55709eaaf68, 0xbfee70b67e728906,
    0xbfc2a4f596906770, 0x3ff31963f8bac1a6,
    0x3fea5eee414344ce, 0xbff75eec27c3e769,
    0x3ff04b650ea8ab78, 0xc00766e08480813c,
    0xbfd5923f52c5e1a0, 0xbff73e9632fff544,
    0xbffeb78cbc37540e, 0xbff0b58b608b7039,
    0xc002b104d6f1f166, 0xbff9ff9d188bf663,
    0xbfe77408f7675f9a, 0x3fbff7f1a2bea280,
    0xc00a1bbd55e8e11b, 0xbfe8d7ab61cfabb4,
    0xc00ac1d4e3224ff8, 0xbfd5c1b0434f2afc,
    0xbfe953b0c56429c8, 0xc007edf16bc5917a,
    0x40089b63b77d7d5a, 0xc00c330ebfbf6ef2,
    0x3ff5fa9526cf1ade, 0xc00d2f2ca3710ec1,
    0x4005bcd15383c505, 0xbfe8ce6839939b08,
    0xbff504d98bf45846, 0xc004db3635026a69,
    0x3fe8dddcb3f389e4, 0x3fe46eef980cb636,
    0x3fd4d57fde904bc8, 0x400aaf073819eeb4,
    0x3ff7d86f1dc11d36, 0xbffc6bd77237cc00,
    0xbff538e36fa9c460, 0xbfdfef0aecc8f5a4,
    0x3fef15f84f583862, 0x4004b676172d2e5e,
    0xc0030f71fe691ade, 0x3ff16a76dede27c2,
    0x3fc1c491c9a93ed8, 0xbffad158907647e6,
    0x40018f17f0695fd1, 0xc001c35f6113ff43,
    0xc007334301602e64, 0x3ff90303114f93e3,
    0x3ff3d9601e39b676, 0xbff43c276ed4b72f,
    0x4006ad3af2bf55ba, 0x400f4738520d62a0,
    0xbfd18becbc8b8141, 0x400bd85bc8bdfa30,
    0xc0085a530dbb342a, 0x3ff8263c97044fe3,
    0xbfcaa41e025c8147, 0xbff935c5d1f789c2,
    0x4006e6e0a9294118, 0xc01306b3ca27fdbc,
    0xbfe0852e56d9ca8c, 0xc013fd5231bf231c,
    0xbf701365e3a9ff00, 0xbff0ed3d181c1b5d,
    0x3ffebd205e3ede39, 0xc00b4c88e7e1496e,
    0xbfe3ada08108d8d5, 0xbfd1d8b44724fb58,
    0xbfec33c722e24e7a, 0x4018cd5fdf80254c,
    0x3fe8456d6bca762c, 0x3faef25dd6abee48,
    0x4003ee7e7e97388e, 0xbfc519b8a09a2b38,
    0x3feb59a0649c28a8, 0x3fdb3c83d3db4090,
    0xc00d3969d20037d6, 0x3fef60df3d9b101d,
    0x3fed3ed6bc33ba90, 0xc006502776cd6f1a,
    0xbffec8f7bb2ec4be, 0x40080176387b50da,
    0xbff8ff28179a395d, 0x3fe7240118eec8cf,
    0x3ff153120f4fda28, 0x3ff442f2f13f7a25,
    0xbff6c31e743cdbd3, 0xbfeabc6235182acc,
    0x40117083ead04c84, 0xbffed49a9fe024b4,
    0x3fb9f001f007aaa0, 0x3ff4f5269608c6c9,
    0x3fe228d02ae45fb6, 0xc0003ab6e975ae24,
    0x3fffbe6768e89f32, 0x3fb3e6a621a5ef24,
    0xc0002bbe0bb43b19, 0xbff1c8d7fab1af38,
    0x3ff25ea00584c1ca, 0x3fe0fde5825d296b,
    0xbfef81be269a22d6, 0x3fe3a8472037bcf8,
    0xbff4d65b7b025806, 0x3ff4275ea0bc0c96,
    0xbfc7ba1b2ff76ed8, 0x3fed1bdf195a8c66,
    0x40108f1a03d5209c, 0x3fefd89ed53d8b47,
    0xc0015572ca1d4832, 0x400f4f4e61018b7a,
    0x3fe312f576fab893, 0xbff9959614eada14,
    0x3fe5ac92051563b9, 0x3fe1357084922bca,
    0x4003a08e9f696243, 0xbffb1d377261ea5c,
    0x4012f4ffeb6217d7, 0xbff24c045a001f56,
    0x3fe3432e9d905360, 0xbfca49cc028e5752,
    0xbfeaf59d06fa2a96, 0xbff8a07afa0404b1,
    0x3fd169b86a0c69f4, 0x400416fefd2ad3dd,
    0x3ff60777268c6d94, 0x3fd110e38158ba60,
    0xbfe1d7af853bc0e1, 0xbfc76882e37a6bd4,
    0xbfd071c478fe311a, 0xc0097a55c791e321,
    0xbffeaec4f2f7f9a2, 0x3fd0613beb107233,
    0xbff69f93c4e1fbb3, 0xc005b04e73682edd,
    0xbfecb1ed9da4c226, 0x4000abc8c51fe8aa,
    0xc005909875bf73c0, 0x3ff2b26a6283c929,
    0x40059ebc14ba1868, 0xbfe35d99edacaa7c,
    0xbfed138b25919242, 0x3fb973aed37dbbd6,
    0x3fea0e75db2cd3fe, 0xbffbb2906367358a,
    0x3fdc7aac73254d82, 0xc00240451a5b6a78,
    0xc00062dd84f3401b, 0x3ff4e5a338a68676,
    0x3ff1a1716a748ef2, 0x3fde02d7d7003294,
    0xbfdc24e18e4f03a8, 0x3ffd362a263ddb46,
    0xc00339661c617b62, 0xbff2923e8704a202,
    0xbff1a487432613fe, 0xbfeeadef178a2e07,
    0x4010ad56cd22f257, 0x3fe39681ac301a6c,
    0xbff125e06289b1e0, 0xc0025b920d64908c,
    0xbfeeeffa85d6c96c, 0x4007077560cc3fb0,
    0x4000837389848d61, 0xc00af2c6ca2cfe60,
    0x400c5c963bbe3797, 0x3ff28006a47c98c8,
    0x3ff98f470018f443, 0x40065410aa6b23e6,
    0xc00519b3ede40072, 0x3ffa5fa8a14f26c3,
    0x3ff4bf8823901302, 0x3fd30f699d079434,
    0x3fc1f23480c62918, 0xbff01e3636e7ffe0,
    0xbff90052d1c06283, 0xbfe46dcb2a2c5adc,
    0xbfca5a6974fbd7c0, 0xbfe2b3877b40c8f0,
    0x4001997e96209ee2, 0x400257e0b9745459,
    0xbff5a1037edcedee, 0xbfde39459f4cd654,
    0x3ff7994bc75149a6, 0x3fd8c41e9e21e720,
    0x400408cbdc980eae, 0xbfe9e114f4aa08c0,
    0xc00373639f31a013, 0xbff605da39b6c366,
    0xbfd2b415851a9750, 0xbfdfbe233b6941ae,
    0x3ff42a014b20cde8, 0x3fcd6ee6a21de190,
    0x4002bb61c9118dc4, 0xc0008394a82a65ba,
    0x4007eb8adbe10fdc, 0x3ff692102643690b,
    0xbfe9da9628e4cf41, 0x3fed5453eecc5ff0,
    0xbfd485b348c7ae8f, 0x3fc4a22ecce8e530,
    0x3fbef9657b08e660, 0x3fedbb677ac8b5c5,
    0xbfd18d2a3d7ba870, 0xbfe5e2c0fa5ca85f,
    0xbfd36a15a732f84c, 0xc009c5071d8b44c9,
    0x3fd6b3120f4a4894, 0xbff4e0460732c133,
    0x4006fbc28cf0a958, 0xc00328e11f3adbe4,
    0x400a59800b66b31c, 0xc01b1f41b85aee63,
    0xc00915796aef6f51, 0xbffa7fbfa5aaf074,
    0xc00385192420e099, 0x3fe00d3a4717df32,
    0xbfd01910f15bd7f8, 0x400ee48871306946,
    0x3fdb1f780e6f252e, 0x3fe2ae58a1f3d1fa,
    0x3ff1b341d9be0284, 0x3fe3040b346875f8,
    0x3fc59d36eea855c8, 0xc013665b915476a7,
    0xbff7074d8ea0de2b, 0x3ffe6d781e5f60ca,
    0x4007f7ab927c0e02, 0x3ffccaf6801908c4,
    0xbfe39887c9c82f29, 0x3ff54f7bdff47b3d,
    0xbfff05faf80a9516, 0x3ff9f150a6e2c280,
    0xbff2fb7f44413632, 0x3ff59c7e716fbd84,
    0x3fb3be8e98466f28, 0xbfd277c76f0a6f46,
    0x3fdf4b61d53787f8, 0xbff6f887b8508858,
    0x3fe55223624acb40, 0x3fe979a8dd83cf75,
    0xc00064011024d7f6, 0xbfffee3654e221fa,
    0xc01175c4a66d4f66, 0x4000710291915ab7,
    0xc01078c3f03c2782, 0xc00b12fe3279603a,
    0xc00e3d81f9df73e1, 0x4005f76add030a9a,
    0x400e637e78b6bb1c, 0x3fdfa2caed1f9a7e,
    0x3ff42925712aa692, 0xc00683aefcdafb0d,
    0x3fd324713b0d8f78, 0x3fcb5c222bd42578,
    0x40136c3973119be1, 0x401061e424a970c4,
    0xc00e923f0fc18096, 0xbff1c0dd464448f8,
    0x400393dc9123655f, 0x3ffc5d563cd0028d,
    0x40028e9a8f1093b5, 0x3ff5e53764371585,
    0x400121fce021755a, 0xbfed7504921205f3,
    0xbff7562da5ab92a0, 0x400a6e20d8634598,
    0x3ffe7bfc88801eee, 0x3fe49b1d317a4849,
    0x4005463c5df413da, 0xbfcfc69160be2df0,
    0x3ff21ede8863ec94, 0xc0088e55b6a7c9ab,
    0xc005bd17eb2bbcde, 0x40110d56ede632b8,
    0x3ffed60d32599384, 0xbfb016b489eac3c0,
    0xbff63f645d046bd9, 0x3ffe8ae10c1e3f0b,
    0xbffec1e51337e7e6, 0xc00440af36d741dc,
    0x40019e270aca6522, 0x400b131ee0dacf42,
    0xc004106356af7a00, 0xbffd1d58d13c7011,
    0x400cd9cc43b22274, 0x3ff312a90e6ec80f,
    0xbfd1f9791550762c, 0x3fe7419d872c8df0,
    0x3fd82c8b3268a898, 0x3fc386deaba2ff28,
    0xbfed34299c2687d2, 0x4003f78b10a8b064,
    0xbff2025027e424b6, 0xbff7b00d0cca005d,
    0x3ff7e418ce64436e, 0xc00ebe86992aa676,
    0xbfe76d6cbbc58267, 0x3ff69fc1f5a7c093,
    0xbffc4138758a75d3, 0xc011c99e3766ed3e,
    0xc0098de5cdaec202, 0x3ff42e5f53047e60,
    0xc0111f95a25ae1c2, 0x3ff67c04a628d4da,
    0x4009b8d3b353731c, 0x3ffe37163b2f90e8,
    0xc013fd3dc6f226a5, 0x4000d53fc7e1bd98,
    0xbff61bae351c9bb1, 0x3fe5dad1754511df,
    0xbfdf9824284ae89a, 0xc0124edeac3fb0c7,
    0xc005b124424c5777, 0x3ff9bde88d86c561,
    0x40002e564a570422, 0xc00c966d43cdf2d0,
    0x3fd9f469c0066bf4, 0xc010b857d374fd3d,
    0xbfdf623b1a099902, 0x3ff691ae934a399c,
    0x3feecb30c10076fa, 0xbfe6389673d33f29,
    0xbff6154af25f7a69, 0xbfeaf3d28ae90d31,
    0x3ffa1403eff03920, 0xbff0b99d50d9a736,
    0xc010498562ef4462, 0x3fed538b9314cbcc,
    0xbffa1015d3ba21e7, 0xc016162a608bca6d,
    0xbff87c148a36a2a6, 0xc00245cf3ceb6a95,
    0x4017f6916d074ab6, 0xc007a11cea35de0c,
    0x4012215a791da537, 0xbfe32e6c4bb9d65d,
    0x3fdfdab130432db4, 0x3fe68971cdceefe7,
    0xbffaae6df719f121, 0x3fcb5a5e30fa593c,
    0x40144f446b2b003e, 0x3fc39912daa0f310,
    0x4003d3540636c49d, 0x3febe1efd15c48c6,
    0xbfe69140269c82a6, 0xc00151bf49d6eb3b,
    0xbffd613dac38c7d3, 0x3ff4e01cf022892c,
    0x400c9ee42b084f29, 0x40107dc2e6ed0c9c,
    0x4002278b6281252a, 0x3fe2e14882110572,
    0x3ff3256637c08ce0, 0x4006a6ce0f82c460,
    0xc006d501a8497e5c, 0xc01c0c609cd512c3,
    0x3fe0f5cf8d276928, 0x3fe3a73ef049d146,
    0xbff28475f51d2f3c, 0xbfde6ded916722ad,
    0xbffd9546ace98fd4, 0x3feedb1c72d39bcf,
    0xc001917f5bd88321, 0xc01285002311d2b6,
    0xc00c716354ec9a05, 0x3fd786dc7c3f1234,
    0x3fd47e9e22ddfa1b, 0x40002e6d3ca0651c,
    0x400a9ae95d8b4ffe, 0x3fc55faf8bb27382,
    0xc00aa5147880e8b4, 0x4011bd4fc9ed4052,
    0x3ff58843c26351b1, 0xbfe8518d77eadd68,
    0x3ff1609154f78407, 0xbff6913b5f54f860,
    0xbfd2c4a96397dec8, 0x3ff959c37ea05e15,
    0xbffa38592f55d17a, 0x4003dadc182b617e,
    0x3fe8bcd13559a59c, 0x3feea3532695d38c,
    0x3ff4c9466fec853e, 0xbfe2d396950b732c,
    0xbff8860d470190c2, 0x40011e573374d0da,
    0xbff2990972e795e2, 0x3fd036be1bd200ac,
    0xbfd7cd008031be38, 0x3fd9712fc101ba57,
    0xc006d46756131aa8, 0x3ff43415d16fcbac,
    0xc0041b317c194862, 0xbfeb91457df540ee,
    0x3fd33a777ec32816, 0x3ff7553babcebcb5,
    0x40000a0fed1a2252, 0xbff816ad1a837ac4,
    0x401298eafa175606, 0xbfe8b473e24a467e,
    0x3fb9261ab5b09bc8, 0xbfc7660d6994413a,
    0x401118d3e5847ce4, 0xc0090c430f3a372e,
    0x3ff5f07b6d312c75, 0x3febde4fdab7e538,
    0x3ff0b273f8396427, 0xbffbd64bb2241d8a,
    0x40070caa0edb31d0, 0xbff5e816f8cfd0a8,
    0x3fc2499d1877575c, 0xbff5693724b5d569,
    0x3ffd6f7dc5ac312e, 0x4008fa83ffbcb500,
    0x4007c20b510456b9, 0x3fe0e5c9f2ebe841,
    0xc0037c020efb4a5b, 0xbffebb9ea85ae9dd,
    0xc00026c3e2c92a2d, 0xc006dc84929cbcfc,
    0xbfd024c6c3005cf8, 0xbf9ac5474b270700,
    0xbfea58f6396bcfe4, 0x400ad9fa7dbd2e8c,
    0xc0062f6b219a19f6, 0xc005481d21d8e46c,
    0xbff0671192284212, 0xbfc267273b5b249a,
    0x40014b89780d1630, 0x3ffbe5290da40ab5,
    0x400a388dc52a9f8d, 0x3ff42e53a5050910,
    0x3ff8cd988748ce8d, 0xbfe0cc9e3af81c8c,
    0x3fe2c423275438de, 0x3fac3b6b91c80420,
    0x3ff71ae398917144, 0xbff32f02347e0eac,
    0xbfec987646c8fb1f, 0x3ffc942fd8312e5c,
    0xbfea123ea597b682, 0xbff4499025ba4724,
    0xc009c057aac36d9b, 0x400882f227f06714,
    0xbfcdbe8b81f9b504, 0xbff9898509e6d35c,
    0x3fcf8fd4c15feea8, 0x3fe58e709bdb5f60,
    0xbfd6e1366b925838, 0xbfd3d99286ce2880,
    0x3ff46d06390e1231, 0xbfc4a27ed0369fd0,
    0xc004664a40157c64, 0xc018ca7b2096fffc,
    0x40063577219fc2bd, 0xbfe1342164dc3472,
    0xbff5e5bfd8052552, 0x3fe91ec8911f980c,
    0x3ff237d9d1078d66, 0x3fa4089d0b78fa00,
    0xbff815c1e08920c0, 0xbff7869752c82160,
    0x400da2d979639b32, 0x40038bc40e9e85e6,
    0xbfc7cb1a314f6970, 0xbffac1a8bd95794c,
    0xbfea304dc4e4053e, 0x3ff272a5184762df,
    0xc010a627c39e7b24, 0x400901a1ad440416,
    0x3ff25e8a8ba5fa2e, 0x3fdba83df9396868,
    0x3fe8a9ee51ca2c7a, 0xbfe31248f03da32a,
    0xc01693a905b0e395, 0x400212732977259a,
    0xbfb9607c920d5ac8, 0x3fb066e990661c00,
    0x3fc49dfa77141584, 0xc001eb8e5de7aaa4,
    0x3fee69ac37dd590a, 0x3ff540f69656c606,
    0x3ffb816d17ca302f, 0x4003c0cac3179d4c,
    0xbffa6c618e90df32, 0x3ff3723fcfd5c8c2,
    0xc01034d1a05cb02e, 0xbfd57f2e7a0d7e8a,
    0xc00d8df153a4cac2, 0xbfd4b75bde076b90,
    0x3ff9357f9e56e2ce, 0xbfd6760d35899208,
    0x40031288a7b3c35b, 0xc005fef479bbc106,
    0x400611225a14d1b8, 0x4003b1e63b978642,
    0xc0059114308f1c12, 0x3ff9b4b8ea433e4d,
    0x3ffb37f57e2ab6b4, 0x3fd53a9c88cd6da0,
    0x401a69dc173804b7, 0xc0000f1458a7b626,
    0x4009479786511876, 0x400cd963043d0875,
    0x3ff264a2637b43c2, 0x3fd09abaf330aca0,
    0x40123bc50f383b70, 0x3ff33c98fa23442f,
    0xc008a7998d514fb2, 0x40051f84c29d70ea,
    0xbfcc577fcffbdfd0, 0x4002cabe3a346654,
    0xbfe055e391e4d7c8, 0xc001130241dbdeb2,
    0xc011b48e4e3a3941, 0xbfd0660710be5cf4,
    0x40129cc12392126b, 0x40139511fc0c542e,
    0xbff2f34bc7bd3764, 0xbff262c269f81462,
    0x3feba3f01a663be4, 0xc006e195bf613e5b,
    0xbfe129a16799aa03, 0x400625f546868922,
    0x3ff82178b8e7f2d2, 0x3fe465b26e2bf87a,
    0x3fd596009384416e, 0x3ff734708a14c47e,
    0x3ff0e40b0ecbce61, 0x3ffeaa4d179203e5,
    0x3ffa9ded8044b87c, 0xbfe22c7182e5009c,
    0x3ff08827267e7d92, 0x3fef06740346dc4e,
    0x400eacccf8980afc, 0xbfc2418e6750d37c,
    0xc0070c5df10af412, 0xbfd2e6d71eddcbae,
    0xc0061da214ac5888, 0xc012027413c82d98,
    0x4019231ed2fc713d, 0xbff5148296d483fe,
    0x3ff052d8d9817612, 0x3ff1f448e2ca15c0,
    0x3fed08c2cf7eb780, 0xbff7e2c71ab7e886,
    0x400510d1a5dfd1e1, 0xbfe753aca6d69959,
    0xbfb1e14ae915d058, 0x400547c7c3dc301c,
    0x3ff93371365b2d06, 0xc00575309f19e417,
    0xbff5bb7d88a445dd, 0xbfced7aed8cdc403,
    0x3ff447c72bd077ac, 0x3fea4d671abf765e,
    0x4005414c074301ae, 0x3fec0f603a94d309,
    0xbff06764630b7294, 0x3fafbba36d7b4570,
    0x3fe28de89ad6c9f4, 0xc000feb1261220d1,
    0x400e553d7f3f91c8, 0x4000c3469ff8d73e,
    0xbff4523da2d4c9f0, 0xc000b36d4042cf39,
    0x3ff22fd5c204f206, 0x40042aa636d865d2,
    0xbfbe247387a57888, 0x3fc40c0d766ebac0,
    0x4004593b1995f982, 0x3fd7225f38993bd9,
    0x4001bae9583e7d22, 0x3ff19d4cb434a4a2,
    0x40075d3d91768e55, 0xc00318550fdd9744,
    0x3ff4bea9f8f13b83, 0xbff5a371cd96b32b,
    0xbfeff0defc2921c9, 0x40001659d6cd68a0,
    0xbffee1cb749d237e, 0xc005aec1e1cd840c,
    0x3feb3a7643cf10dc, 0x40048039d2220008,
    0x3ff9606ba45c09b2, 0x4012836d772febf8,
    0xbff3e4f8b9ce1a82, 0x4016878d200a350e,
    0xc000110e1fd4e6b1, 0x3ff68d969e259860,
    0xbfc0f6ee7ff844c8, 0xbfe0faa264458110,
    0xbff869ed50b54b18, 0xbfcc2a3f21dc0740,
    0xc008aab299cb852c, 0xc0049131fa0cef58,
    0x4009f9752bdb4d0a, 0x3ff08a271e962292,
    0x3feceacb574c0306, 0xbff26666155dc432,
    0x3ffaa8bef32be926, 0x3f95f7efe390a000,
    0xc00be9c757c7bb52, 0xbffea2d52c69c02c,
    0xc00294cba63c708c, 0x40083ca83a7a3a2c,
    0x3fe2c0c39b7863ae, 0x3fe064019990b9a9,
    0x400f14dd3dca7cb2, 0x3fb8dfe0c779f610,
    0x3ff2842376f76ec7, 0x401183e3b0a00051,
    0x3fe1b5ab51553b7c, 0xbff5e360f72a07ac,
    0x4004c2b5a1521a02, 0xbff3bd302fab9b12,
    0xc00ab90e421f5e62, 0xbfe9cdcf63072992,
    0xbff858c5710d1f11, 0xbff7618f2ae5a6f8,
    0x40047ff188a56895, 0x3fd1820e386637c8,
    0x4006c94fd620c5fc, 0xc005f942e16abc48,
    0x400b6b23ebc00af4, 0x3fc047735de75a18,
    0xc004df0b0577b47d, 0x3f48fb87c0f77000,
    0xbfe574e1f2d9774b, 0x400b6b2000e88ba4,
    0xbff92fd6e358cd00, 0xbfd98059b1f10912,
    0x3ffb03eae1b53f0f, 0x4010cb03425cd080,
    0x3fcae9aac1a26b94, 0x400a4f053b83c7da,
    0xbfec0899a2410522, 0xc0037d71aec18bad,
    0xbfc352ffded7bfe0, 0x3fe7b9a1d300a3ba,
    0x4002ce9cf6cfd8e2, 0xbfdf1fbca2987983,
    0xc00bc8f341a244c9, 0xbfe058c3db166394,
    0x3feda66d1eb4a8fd, 0x3fec7183be35ed5c,
    0x3fd5315149984ac1, 0xc01554e13d261639,
    0x3fe72afcc0070b87, 0x3fe0a1bd515276d8,
    0x400280ef3f6a9e90, 0xbffc78f8c4ba1b36,
    0x40020d05e4705830, 0x3ff92fcd5d844ec6,
    0x3ffabef6c6342d72, 0x3fc0bff2169b3068,
    0xc012982e68e88282, 0xc00d0f75d3d333ca,
    0x400b348d8c7fe4f2, 0xbfd93c452e6b63c4,
    0x3ff15d20b3fe706d, 0x3fe819aff4369757,
    0xc011c5ff31a9a1d1, 0x3fc9b119adc970b4,
    0x4001bba9541b5327, 0x3ff563f86f6d90b4,
    0xc00f5d568cf703ed, 0x3ff08162c76441ff,
    0xc00126e2554f512c, 0xbfbd3dda63f8c960,
    0xc001a39fb734224f, 0x3fd035d0b9d4b4c0,
    0x400791a1bbb53dd2, 0x4004c72acfc6904a,
    0x3ff255ad58e56fa6, 0xbfe811ed7d516ea8,
    0xbfd7d2a3b65b884c, 0x40002dc9e2f9227c,
    0x3fdc210029f8df68, 0x40036fc159a69fe0,
    0xbfdc61af489c6de9, 0x3ffc33dc02ad35f4,
    0xbfd366555c27858c, 0xbfe1bab240ab40ec,
    0xbffb934501bf09cd, 0xbfd116142dc03a74,
    0xc00e0441d4879f2e, 0xbfb46ef496472870,
    0xbffcac84c313d320, 0xc000ce9f6f79eaa0,
    0x4006cd9f013aa8e2, 0xbfec7d4613c2f2ee,
    0xbffc934ed3bab518, 0x3fc4958109a28d48,
    0xbfe6729781524f14, 0xbfe52a1380aecbad,
    0xbfd9d70776b4a0ea, 0x401383fbd0f7467d,
    0x3fd623aead1eae4a, 0xbfecfe3ab93e37fa,
    0xbfd8ef81b35bfe25, 0x3ff9ca9aa81e0b4a,
    0x3ffbeb92683fd8ae, 0x3ff4291e12f241e0,
    0x4010b7f9de7d9506, 0xbfdf4c35ec8bac04,
    0xbff826a51d67111e, 0x3fe91756f2530410,
    0x4015e927b3f0ba87, 0xbff677f630d4dbe5,
    0x3ff0c5f505e76718, 0xc0076b64284168a8,
    0x3ff20d06c3896228, 0x40021b26bbd67eac,
    0xbfe46ba8901057b0, 0xbff34e3b9341aef5,
    0x4000388ce014e178, 0xbfd90c0a7e92412c,
    0x4011427a8dfe949b, 0x4003f022b7351e8f,
    0xc0009b01f57b2708, 0x3fe95f01df64c11c,
    0xbfc21e88ae7e7500, 0xc0126e0ecbfa0dde,
    0x3ffe3e6c7a7793d6, 0xc006b922fbe6f357,
    0x4006a8c9a484de37, 0x3ff02fe730d4a195,
    0x400bf61bfb46a70a, 0x400818f1cdf0929e,
    0xbff93bf12bc9e45e, 0x3ff93605e867594e,
    0x3fd8809700cced94, 0xbffdc95bb46e9b3e,
    0xbff9582fa97896a2, 0xc0125ad1a78feeb6,
    0xc009c723eaa0e11d, 0xbffb62a5050ed19c,
    0xc0102062556f58e7, 0xc0157b758a983552,
    0x3fa679e8155ce980, 0xc00cfa1180bfad6a,
    0xc00484b5e4f413f9, 0x40034b94b14bf7cc,
    0x3fcd57646051c0e0, 0xbfe414e275ecfa20,
    0x4011b5bb61c6b4c4, 0x3fff3b1be79523a1,
    0xbfcc476f38077b30, 0xbfe097d305a20b36,
    0xbfdef32a9034c20a, 0x4004006482be7012,
    0x3fddb095f4af4082, 0xbfd0e9c1a960b729,
    0xc00dbbe77daf8773, 0xc0031456dc26383c,
    0xc00b5dfff09c39ac, 0x3fe43dd5ce56f6c4,
    0x40035ec2788831e8, 0xc002819f10ce2c4d,
    0xc008b6df398bf7dc, 0x3ff5996e397a0b8b,
    0x4010817a9f2b2b7c, 0x40156ff654e7f370,
    0xbfbea79394ca839c, 0x3fe87c2a16f0e1da,
    0x4013cc000f0b1d89, 0xbfeca985a6a30fec,
    0x400822101fde8103, 0xbff74e0596f72d35,
    0x4003499688667ca9, 0xc00368870235660c,
    0x3fda8cd3d565b070, 0xbff03d0a999f91b0,
    0xc013e8556a5ee6f9, 0xbfecc4b6e72b660a,
    0x3ff72893461d449e, 0xbfdf2cf08345c6a4,
    0x3ff800220c054ec8, 0x3fe94093bb8e215c,
    0xbff678fa9746f1e6, 0x4000166c3489e6f1,
    0x3fc709755dde54c8, 0x3fe36ccedba0e59f,
    0xbff035b7f8ea8395, 0xbffeca031c4d7031,
    0x3f8f459104f35100, 0x3fee77336aa21b7a,
    0x3fdf48b62da94ec0, 0xbfff36a16ad41bf7,
    0x3fe1dedc703e72fe, 0xbfe3fa8613710c1a,
    0xbff982c57c7e4a9e, 0xc008da1a7c8fcec1,
    0x4011fc33e6a6a2e6, 0xc0071960c5ab9ab0,
    0xbff0ac9f38235d0e, 0xc01834051d4ed687,
    0xbff2d73cff311536, 0x3feac7104a2ad216,
    0x3ff173501ac080f6, 0xc00639cda01dd088,
    0xc004cfcb0627f661, 0xbfd6398b090065a6,
    0xbff183662a798f7a, 0x3fed8680f250163a,
    0x3fe58a426a8a989e, 0x3fe5456bb52331ae,
    0xbff0f3fc27e0600f, 0xc001622dcba8f301,
    0xc000eef9a66515ba, 0x40052077f68ff53e,
    0x4007242ae9b25568, 0xc009b28528ca9e6f,
    0xbfdee94a6dadc1d0, 0xbf870db00cad4c00,
    0xc00719c60722bd46, 0x400e3287c6ffc3d6,
    0x3fe8bcfefe5aba58, 0xc0103706e77bc2cd,
    0xbfff8422722e67fc, 0xbfe2369c7b4c677b,
    0x400224b054eb3725, 0x3ffd92099aaf834b,
    0x4007b655d0aadf2c, 0xc000ed219fdc0a65,
    0x3ff400de55896315, 0xc002c65254dc51ae,
    0x3ff66c37815df49c, 0x3fff90916bc70990,
    0xc00e56bac7d69a10, 0xbfd4171b09c19c1a,
    0x400cdd1ede650d1a, 0xbfabebb026495b40,
    0xc00d8c390c002471, 0x4004aeff8f9fff7c,
    0x3ff08ec91b50efcf, 0xc0120dc1b740c890,
    0xbfe69442e598d79c, 0xc00486559e86a2a4,
    0xbff1ec83bdebbe43, 0xbff562f6e97c77bc,
    0x3fb144e095435b30, 0x400cf66e34e9295c,
    0x3ff6d1a30a02f074, 0xbffb1d167d37faa6,
    0x4000cbdcd4b12047, 0xbfdf62a85db39264,
    0xbfe342f67a0a0d0e, 0xbfd6207af8f1d608,
    0xbfd13c39d762aee6, 0xbfdf38f3d324e5ca,
    0x3fc40d54d3c4b470, 0xbfcc9b85c6cbdd90,
    0x3fea118833dcd14c, 0x3ff11e92c1f517d6,
    0xc0081a793cb7bca5, 0xbfc1591455b21bb4,
    0x3ff22ad7e401f432, 0xbfe8b75290be4a32,
    0xbfd0a20cd8ea2554, 0xbfe9d239d9a93e38,
    0xbfd82236d36fbe10, 0x3fe6232b72d00cde,
    0x3fc6a1818317df70, 0xc00273180e834c6e,
    0xbfe7363d51745ee8, 0x3fefa4647e66d852,
    0x3ff7dd4803c56316, 0x3ffbba64bcf774b8,
    0xbffb9d4c7d60ce1b, 0xc007589a4946fd62,
    0xbff608fc4c6406eb, 0x3fec0bb7435058fe,
    0x3ff083f049ef1c9a, 0x4008bd642fa23cb2,
    0xbf6fdf4032bbac00, 0x400c1ce1d0fdf05c,
    0xbffbc3ae8e7b7be8, 0x400b1cf5c807cfaa,
    0xbfe0cc4f2476d115, 0xbffd97bd4a2dfc60,
    0x3ff523d29395f27e, 0x40065d441f1be446,
    0xbffc3f45bf0748de, 0x40123e133682a37a,
    0xbfe2187218fa9329, 0xbffa55c2327a3084,
    0xbfeca086678a62fe, 0x3fe9c55c31a0ed59,
    0x400dfb69589916f3, 0x40000cd3817075fa,
    0x3ffad82f799ea148, 0x3fec3780b5999d92,
    0xc012166baddb16dc, 0x3ff85b2eb0308c72,
    0x3fe4854bbe26793a, 0xbfeed328817fe7ac,
    0x3ff22a743c9d1551, 0x400bb40c7c2b17db,
    0xc003d91e75a6d52b, 0x3ffe0678a886bcd3,
    0x4000b0f17c12f0ee, 0xbfe850db91876e67,
    0xbfef53f148ba6cda, 0x400558634d18dbbe,
    0xbfdbd0c044daf657, 0x3ff0786e33693df8,
    0xbffa6ab1565aa3ca, 0xc00432b8ba2952ac,
    0x4006f954c4048216, 0xc0165f118b3a78a8,
    0x3fe223059c6a0585, 0x4001787750c56f71,
    0xbfd7da7e875aefd4, 0xc00498f1863424e4,
    0x3ffb17e71052fae8, 0xbff0f8235e4656d2,
    0x400e68b4668cddb9, 0x3ffaea8cdca7edee,
    0xbff3f56d105089d2, 0x3fd6eb7a68356712,
    0x3fdef642c741f438, 0xc002a3b05e14cbe5,
    0xc012d6de173469d7, 0x3ff5ad5c4c85d462,
    0xc01a0c9f0290c1db, 0xbffcffc9562d6dce,
    0x3fda5e0645d13c53, 0x400f93b29e92a78b,
    0x3fec41c79f351f83, 0x3fe568fea588dd44,
    0x3ffb4d9e0e1455c7, 0x3fdaaf7136ab52a0,
    0xc002e7883a2b179c, 0xc0009af95ae4e4fd,
    0xc012455e2baddf71, 0x4002b0cab75ea766,
    0x3ff9904b5f41f1b3, 0x400ee8d1245b10bd,
    0xbff891a8735cdeef, 0xc00055b358a00bee,
    0x3f9280f634cace80, 0xc00cf40d96605081,
    0xc007e912d39e77da, 0xc0093f2c188bdc71,
    0xc0046f1f83f6a500, 0xc00a4ae019f1a79b,
    0xc012aa454bf6b2fe, 0xc00b5a15deda612f,
    0xc0012d091e9fa17b, 0x3ffc9b88c08d4938,
    0x4003009b8d0089b6, 0xbfed629938eba9fa,
    0xc00738a937551b0f, 0x3ff1bb3c5010e93d,
    0x4003d9ab8ddca7a3, 0xbff7bb146e227a70,
    0x400b7ab36ca7611c, 0x3fffb66531289157,
    0xbfd98cc5529993d2, 0x409666fc4e690dfc,
    0x400550afc0e1c366, 0x400573374f8098a8,
    0x3fe936c53999019a, 0x3ff254051b85d81b,
    0xbfd458326608f7c0, 0xbff4a26ae0e591fa,
    0x3ffd551af00e1877, 0xbffddc466964a790,
    0xbffda2e70d630f61, 0xbfffe94cd399bb6e,
    0x4008aa906d47492c, 0xc002257ffb637c85,
    0xc00d99efc725a34f, 0xbfe0438cc7b09246,
    0x400c5aaff1f80cee, 0x3ffadc25acd46e1f,
    0x3fea72727f83118c, 0xbfd07123d64db127,
    0x40101d431d07514f, 0x400cb78cbe096048,
    0x3fbcb9a4df218f50, 0xbfa5a653e63f3620,
    0xbff7929309a39fa8, 0xbff22c176ea42c8a,
    0xc005ba09292583ae, 0x4005712c1a5a8ff0,
    0xc00e7dd2c7e3f41b, 0x4006ee5df84ac04c,
    0xc007937ebb7bda5e, 0xbff17bcd912c4541,
    0x400c052d966802c8, 0xbffbaedf441fea2d,
    0x3ffd4470eaaae43e, 0xc002a1df25b75482,
    0xc0018f78c34b1714, 0x401495206b64d808,
    0x4009732cf5d0b000, 0x3feb35489a829977,
    0x3fd3f1c7fc46095e, 0x3feaccf9d0b2ea0e,
    0x3fc2ece985b5edc8, 0xbfd77d8178b6ea24,
    0xbffa3b14875b9370, 0x3ff871bb570c6e3e,
    0xc00bb3c8bb10e320, 0x4008e881bb90aeb4,
    0xbff448406fe92524, 0x40045df85b4fba1d,
    0x400cc5a3c3cd7972, 0xc00884cfe9a65037,
    0xbfabb9ec32f98870, 0x40056df5b3945be2,
    0xbff8d04c57cd09ce, 0xc00764dbbd9d4af3,
    0x4013260a439ae5b2, 0x3ff20fa077133907,
    0xc00619d09c4c35fa, 0x3fe26537089463bc,
    0x4013b1a3f5a496d5, 0xc01421f88b902107,
    0x3ff3a7eb6f54ba06, 0xbfcb4d31dbd89c7c,
    0xbff23777ce6798ba, 0x3f989e8efb2dd040,
    0x3ff59ce6aa1b48a2, 0xc00506340f3647e5,
    0xbfea912f675bd58c, 0x3fb793b64b023a00,
    0x3fdd127935614d5c, 0x3fee1c27619eb7e0,
    0x4013184c0bce04f0, 0xc0109c8006c9d97e,
    0x3fe5884438cffd44, 0xbfd467d8c3d1d818,
    0x4009b6469e5bd13c, 0xbff34c3fc82717ce,
    0x3fe11457b89b8a57, 0xc00b00c9a85fd9d8,
    0x400835e1683d7880, 0xc00436c664c99f96,
    0xc00588a41985d7d4, 0xbfd89904520ebb6e,
    0xbfca74f6e92b2678, 0x3ff1661411d2d32e,
    0xc000d737cfa1cbf4, 0x3ffa68d26d61241f,
    0xc00be4d858f4d56e, 0xbfe154fb65569296,
    0xc00532158d35b2f1, 0x3fe3a367c1608780,
    0xbfd1d9fba8269042, 0x3fdaa321021b5d97,
    0x3fd7243ef9a3c776, 0xc0126e8fd6a50bf0,
    0x3fde397ea33d8dff, 0xbfdd058b4474eda1,
    0x3fe1aab08893dbd9, 0xbff948128d34c8f9,
    0x3fe6defd9405ecfd, 0xbff5482cccc0238e,
    0xbff53669ecca7c85, 0x4002c3c5db03432c,
    0x3ff86ce6121d6a8d, 0x400a9429f8ac7f30,
    0x4008a411881bf5d3, 0xc01a9a48a7fbf70f,
    0xc0118de683b948db, 0x4009be6cc9e9b498,
    0xbfc5136198536c38, 0x3fe573656b7c54c5,
    0xc0031c131a05abf6, 0xc01846b5b0acee2c,
    0x40014093718a38e6, 0xc0043aa99dd182e2,
    0xbfdf3572887e45c8, 0x3fbd24d3526de1a6,
    0xbfd5953849d2f55f, 0xbfe496fa18f241ca,
    0x3fdbd2c539fc6d0e, 0xbfdfb3ff6a1ed55e,
    0xc00f70198b03008a, 0x400cc9a9a36be619,
    0xc0098417ab5d0dcc, 0x400c57fd58e3c49d,
    0x3fc1eae7b93daebc, 0xbff29c1d7bfdc8d5,
    0x3ff1eb335db63fe8, 0xbfe123a3d5a03304,
    0xbfeb24fd1a9f78e3, 0xbfd2a10a1ead0d40,
    0xbfe24c267570ea16, 0xbfed416ed66479c9,
    0xbfdfc19f4de1b9ae, 0xbfe1ccba51c07fa2,
    0xc003d0de740868aa, 0xc005ff5c629dfbe3,
    0x4005553c26a462f4, 0xbfc6cb638f9213f0,
    0x3fe0a94e4083809b, 0x400f9a41f1b0e53c,
    0x40018e4d24c46bca, 0x3fd8dfea0ab34c84,
    0xc008f2c5fbd4045c, 0xbff0cae02f3c4d3b,
    0xbff0bd4b32142b11, 0x3f7ae2f1cd533300,
    0xbfe890f6d667137c, 0xc005cbf028b0d96e,
    0xbff139ea6e9bb988, 0xbff5bc4610994146,
    0xbfe19cf02a65c8b6, 0xbff51fd330334030,
    0x3ff35fbec069d64b, 0xc0045b810908710f,
    0x3fdf0b9ab61ad690, 0x3fe7773086c5d103,
    0x3fbed0d0269b92e0, 0xbff13ad3d7578b70,
    0x3fefd15a4ed8c9c0, 0x3ff9618304ca0150,
    0xbff7c65a5f26ef35, 0xc01406275c86992d,
    0xc0038628583c537c, 0x4001c7b4ea2bbce5,
    0x3f7c5f7932e2d120, 0x4010ed2e98915bdb,
    0xc002db4b8b8dfb48, 0x4010f95d83c54e90,
    0x400e9c21fd068851, 0xbff9b5ae34685594,
    0x3f7cc4fd0e133900, 0xbfea478b6a20639a,
    0x400be5b601b2dc7c, 0xbff5c6ed2fb7c8fc,
    0x40084eb9db9770d4, 0x3ff08ac0a946cba8,
    0x3ffa8d84ee24d82a, 0xbfe29cdfbb5d398c,
    0x3fed49c82fca34f2, 0xbff8837811efb5ba,
    0x401056ab2a6fb5df, 0x3ff259e0f6bc9a3e,
    0xbff56771c04e887f, 0xbff7a1aa51c3c7b8,
    0x3fff03811c762f22, 0x40018d77fe08d807,
    0xbfe33a72878f26a4, 0x3fe69aa4ccc03800,
    0x3ffc192eaad0c952, 0x3fee531bdd3b1f5a,
    0xc00cb0459dd8f9f7, 0x3fbceaf46ca5e948,
    0xbfff12c6e1ec56aa, 0xbfd6006e9867481c,
    0x400a0be9a8ada04e, 0xbfa8bbe2af5a4260,
    0xbff1290a91c57810, 0x400c6e72d9b4c484,
    0xbff57f3cbe3bae75, 0xbffb2b0855dbf348,
    0xc0010bec1ae8910b, 0x3ffe07e39d2d9e11,
    0xbfe08aa7f2c7d32c, 0x4012119c7e4c2978,
    0xc007131f4ea2f594, 0x3ff4f58b4eac50e2,
    0x4005d0cdb0ad4ff5, 0xbff403d17469a819,
    0x3ff4a06986b780ea, 0xbff05bccaa8b86e3,
    0xc0007ba318be5d5e, 0xbff3dc756e20b7f6,
    0x3fe8d8989a47b4b4, 0xbf8d18357cb92d80,
    0x3fc3678ec639dd00, 0x4008468352313f91,
    0x4007b56a9fa3eabb, 0x3fc5964cefee3191,
    0xc015985cb0c254d4, 0xbffe1238be75feca,
    0xbff50367d0e83e25, 0x3ff6dbe91f31b8f8,
    0xbfeb300fc3f29f98, 0x3fde9fe9832c5a18,
    0xbfffe1b16d4d59f2, 0x3fdac14ea45007ac,
    0xc003d25d2c64268a, 0xc006b9843e43ee50,
    0x3ff148cf67c3c9ae, 0x4000564f5c0815d6,
    0xbff3dfc3a3c2eeee, 0xc00bf6f4ea3a5bcc,
    0x3ff44bacc539ba1e, 0x3fdff48449dd2b24,
    0xbfe33f59979dbd02, 0xc005b6e0e22b505e,
    0x3ffc4242356b01da, 0x401479c118977020,
    0x400177d9190dbe0d, 0x40158b128de79760,
    0x4004aa00b3daa800, 0x3ffa2f1bb8bc0e0e,
    0xc011659e08931045, 0x4009c459480b37ec,
    0xbfeeebe792dc5bb0, 0xc013d46a62ced144,
    0xbfde95ed168d8416, 0xc00f7479853a0935,
    0xbfae9c65235cb1a0, 0x3ffd26d15585cba0,
    0x40107654f588b34a, 0xc00290993b7e7507,
    0xc004090ed35a6f9a, 0x3fcba547823a6834,
    0x400b26fdf78b41ca, 0xbfeb1e5f4d24a3c0,
    0xbfb6d1661c50911c, 0xbff4b364b0ff58b1,
    0xbff9240e25a3d70a, 0xc0014af734b412f8,
    0xc000130607fb29a3, 0xbff3b124c7f517f5,
    0xc01b8188340bd88a, 0x3f58bba84976a000,
    0xc00221b93e151a12, 0xc0074400b067f8c2,
    0xc00f111e3548bc5d, 0x40018b19890e9ca7,
    0x3fec88dc8b79a7b6, 0xbff57080e228ade2,
    0x400361251a2e771a, 0xbfd03531a19abedf,
    0xbfecfab4b2b46c0c, 0xc005d073925cf1de,
    0xbfce09f0ade800f2, 0xbff55219d8f15855,
    0x3fb37ad79cd1c1d2, 0xbfe7f0b53852ff9a,
    0xbfdc899c4d0934eb, 0x3f7f800c0be58580,
    0x3fb414851fb9b226, 0x3ffe0725e7d062df,
    0x3fe1b4453d4f052c, 0xc01021db778f245a,
    0x3ffc84fbb353c37f, 0xbffc2eb750dc70b9,
    0x3fdd64d22a7c8bf4, 0x3fc54f96a16ed67a,
    0xc00bf8feff3a6fc6, 0x3feb3363da45b281,
    0x3fffcdf13670d9dd, 0x3ff00a4984e5b470,
    0x3fd0b9c210f6aee8, 0x3ff23106de28e12a,
    0x3fdf1e251e5541a4, 0xc00978205d6e0e98,
    0xc004deed6d42327b, 0x3ff74d1611d69194,
    0x40084f15e06df424, 0x400a1bcd3210c098,
    0x3fd67138ff4a95f0, 0xc003e4725b72f23c,
    0xbff9f08c10ba39cf, 0x40041a3309d1d3b2,
    0x4003bba9fc43e7de, 0x3fede6b11e4e072f,
    0xc01377854e5901bd, 0xbfe2c81b8735ae68,
    0x3ffb019ec54960c2, 0xbfe7deb707d169c8,
    0xbfd6a219d029fedc, 0xbff42262b9bf7cac,
    0xbffa1e26516ff03a, 0x3fb77da55f40b600,
    0xc011dad7604e8dde, 0x3ffe21d4c40813a2,
    0x3fe8290dd46e3f88, 0x4005e7027b1e8e78,
    0xbffa08c253c53852, 0x3fecfc8e1deef8ba,
    0x3ff1113b3d6f28bd, 0xbfed78e1f4f03caf,
    0x3ff8b2bf5bef5362, 0xbff72ec004e280ed,
    0xc00fcfb02d3cb355, 0xbfd3cd894f2dc668,
    0xc00d77fc49666c7f, 0x3ff37693ded78cc2,
    0x4009311f7674bfce, 0x40039f85e1086a34,
    0x3fc34f6f8a1c2e80, 0xbfd7eaaea12de1ba,
    0xbff9789c7becf072, 0xbffe887a4eadb5b7,
    0xc014534bc163588d, 0xbfcdc29343c74090,
    0x400bbd6c2db699ab, 0xbfe29c990c40c863,
    0x3ff689ae1ca2e136, 0x3ff9bac30f6bfe94,
    0xbff9fe6f41333834, 0x3fe313b4b8a903e4,
    0xc006246d32bd3300, 0x3f92719f6e48b5e0,
    0x4015c689afa7153e, 0xc015d49c23662d69,
    0x3fc45d1c3b7f0408, 0x40058fb7ec566b60,
    0x4019303cd1385f97, 0xc0006681b2cae47c,
    0xbf8f53e1a5344f00, 0x3ff3621bead582aa,
    0x3fef2d27b9768ccc, 0xbff0bfd3be35e287,
    0x3fe2574d1e9d4a88, 0x4016a609ca6f7eb0,
    0x400e769736e5a6ca, 0x40043526c48de0df,
    0xbff6b369418a3a94, 0xbfca783daada856d,
    0xbff7aaa87f7d2703, 0x3fef250e2961761d,
    0xbffba680bf4ec58e, 0x40053a10f1605e18,
    0x4009683546e19d9f, 0x3ff93f7227506d05,
    0xbfe5bb36fc0790da, 0xbfd4671182f9377c,
    0x3ff819fb4be7c7f5, 0x400978091eadace8,
    0x3fbb62a7922b5530, 0xbfe2edbfb6237cc6,
    0x4000df395fd904ef, 0xbff6cf418302d52f,
    0xbffb53ba2b05133b, 0x40082bab32be21fb,
    0x400678a8033fa27d, 0xbfcd6b7500058530,
    0x4009bd46bf9db1e8, 0x3fd30aca7faff16c,
    0x3fe7a650ca67c799, 0x400982ec50fc8f06,
    0xbfc0bdc090d37990, 0xc0073b35e6218234,
    0x4002e6a2dd03a3d7, 0x3fb0f5cb1330d920,
    0xbff24f7579883594, 0xbfef730b119f44b0,
    0x4005fc09c52e399b, 0xc010ff37241e0a0c,
    0xbff1ae232bbf5c72, 0xc015d4c9c515afc5,
    0x3ff481fcd679df2e, 0xc011d44e8dd3a1ac,
    0xc00212a436510d34, 0x400a77acb8d287a4,
    0x3fcbaec0442cd816, 0xbff6ec0f5926f6e0,
    0x3f8eac2323a07d40, 0xc00479861ca0d828,
    0x4010326ffc92f3cf, 0x3feed7ad85ca99fe,
    0x3ff8392d23c75fd2, 0xbffd53c402422a0e,
    0x40119202722355db, 0x3fa312037004d2a0,
    0x400ca15e2bd9506a, 0xbfebee742f526ca0,
    0xbfe4cac75f752dc9, 0x4011ea11fc63252a,
    0xc011a698c7017eec, 0x401508b11a5e5d26,
    0xbff8fdc81aecfa37, 0x3ff444da6bf24918,
    0x400d33ea9dff9509, 0x400bf57fd9e52ac7,
    0xbfe87cbd440f55e3, 0xbfe0cd8f0c7b85c8,
    0xbfe6c41ff26f087e, 0x400b39b65d52596e,
    0x400997bea42fd30e, 0x3ffe3cf45788545f,
    0x40006be728c073fb, 0x40007b7d28a4345c,
    0x3fb2852f2c3882d0, 0x400140c5e523c58d,
    0x3fd195df779dbf7a, 0xbff933b525a791da,
    0x40038f0662b551e8, 0x400a8070b70792c3,
    0x3feda6e4faec3e6c, 0xbff2f0d18e4d020f,
    0x3fd7b443d2542f9b, 0x4007402d62cd4f6e,
    0x3fe046c773e33004, 0x4002fb0b68224bce,
    0x3ff330c40bfe68b2, 0x3ff28e8617d6bcec,
    0xc011ebe00bfbcec7, 0xc006b132c443a132,
    0x400692e6f8e79098, 0xbfec30ce6142810c,
    0x3ff38e646f8f7892, 0xc011955e8e79c784,
    0x3fedb18ebc811da0, 0x3fe3417c23871f07,
    0x3feafa16f841b82d, 0xbfff4f1a62fd03a4,
    0x3ff356c19caa9a20, 0xc0037b613f8bccf4,
    0x3fff93c8887957e5, 0xbfbbda694204f400,
    0x4003ba1492b15d7c, 0x3fe52b3dc4356e51,
    0xc011005ad0dc664d, 0x3fe0212b9eda09bb,
    0x3fe5167e0f020625, 0x3ffb80ed925a72c4,
    0xc01005c05d1d0b13, 0xbffa4bec157f2196,
    0x40190fb61c0a891a, 0x400968c2f8f05262,
    0xc003a076e661816a, 0x3fd31e446e273854,
    0xc0013cec5ee05964, 0x3fe6c51f49cec7e1,
    0xbffd7b6ae8778ff0, 0xc014b3bc0d0b30a5,
    0x3ff63f5e87d5615b, 0x4000193d1fb76196,
    0xbfe4f3c5a1c004f4, 0xc003bfe233ca5ac6,
    0xc001e8a7333f2c27, 0x3fe1aec627e58a1e,
    0xbfed35151bfbd8d2, 0xc013201680b253bc,
    0x40047c38923c6c96, 0xbffbe91618d69410,
    0x40036b96c79f097f, 0x3feef3bfd1bdaa60,
    0x3fe88f0c7703ed40, 0xbff977170c027f72,
    0xbfef608990140867, 0xbfec2b9eae0e84fe,
    0xbff58bf147f8e88c, 0xbff222b592fa140a,
    0xbfe789abb79e96f7, 0x4004f8ee6cc24778,
    0xc00e2c7106d4078c, 0x40064fffd151a21d,
    0xbffac92d43dec51b, 0x3fc18c0d35e2da14,
    0x4001f14c5488d56d, 0x3fd740985c544d84,
    0x3feab3c9659add34, 0xbfbe134c322b8324,
    0x3fd78f9cfdf04fc0, 0x4006f82d6f7dbdff,
    0xc00977dadd9b9d42, 0xc0068236916c0751,
    0x3fd3cdf896778920, 0x3fa493e0dca71728,
    0xc0003b5fc7a5c122, 0xc003bfce5e95a834,
    0x3ffc7f283c7d67e6, 0x3fea412063235e82,
    0x3ff9ca42e65b1cf1, 0x3fd9aa588be0f768,
    0xbff9ae8959ec4bdc, 0x3ff97d1420539166,
    0xbff1c7829b4c93c4, 0x400240b37c6fb5ff,
    0x4004b79e51a595a3, 0xbfdb5c977a487148,
    0x3ffaefa185763942, 0x3ff106cf3c1f854f,
    0x400eaf82fd234439, 0x3ff46bdeb2871542,
    0x3ff4ec102724c0b9, 0xc00231e519c7881e,
    0xbfe087611a01c9af, 0xbfedd55f0ac04148,
    0xbfe4803b3bc897c1, 0x3ffb20c323e8a387,
    0xbfd770a5e9c78240, 0x3ff7252403f012b0,
    0x3fc4938e5a130668, 0xbff936ac93ac1e6a,
    0x3fde1c2098ac2f3d, 0xc00c3148bc606aa4,
    0x4003f0bd2fd383fd, 0xbfd3866604bc43cc,
    0x3fd72b36ee1d21e8, 0xbfcfb0d0800bf890,
    0x4006324d8db1c74f, 0xbfd47802cafba692,
    0xc00167c55cb8bcae, 0xc016c23ffa5e36ec,
    0x3ffe7c52b4c96895, 0x400def94814ce26c,
    0xbfcaa78e5cbc14d8, 0x4013780f5afbd624,
    0xbfe8a38d629fdc17, 0x3ff92a0b37f5613d,
    0x3fd905883aa23290, 0xc00aa963b9c03296,
    0x3fdcaa49bca7bdb7, 0xbfe3e296f1cfc916,
    0xbfd801f386cb3a32, 0xc004490f1f5716a0,
    0x40001cf9856eca7e, 0x3fc8587d2effd30e,
    0xbfe4b91bd9491623, 0x40008c771adcf1e2,
    0x40173b0f785ad371, 0x3ff0daa814ac093a,
    0xc0061f6c4cb9f7ae, 0x3ffdbd6850201b54,
    0xc006c98b5a7ca28d, 0xbfe47a91da0a6a60,
    0x40012c6a9330cbb2, 0xbfe26613be4f8684,
    0x3ff08f65bd8fdcb0, 0xc008ff6b6fe25a98,
    0x4011dfc706ab6ca1, 0x3fe39ed90603fbe6,
    0x3fe336e574526b8c, 0x3fd6dd2a8be2f030,
    0xbfea57a50834e2c7, 0xc0088d9cadb7026c,
    0xbfe6f06315fdae6f, 0x400117f1ebff2beb,
    0x3ff1790a89483d1c, 0x3ff2a9fc4e89449e,
    0xbfec244290b33c62, 0xc005a91d4379a564,
    0xc0011183d32b7efc, 0x401abb09f933328e,
    0x3fd39cc9f1b8792e, 0xbfe4dfbefd1bb404,
    0x4000ce23d281ca35, 0x3ff44d681affe7bf,
    0x4000f8e9160f1c7a, 0x4010fe5e7c8d8cb2,
    0x4009c45509cfac02, 0xbfb076b690f7a960,
    0xc002673d88463af9, 0xbff513de46e3090a,
    0xc00261c3805973ea, 0xc01031323380cdc1,
    0xc005de8ec83d327a, 0x40067e90be4f8218,
    0x3fff0968aa4d2a40, 0xc0017376823e94bf,
    0xbfea0809fee9bcce, 0xbfe867f16782fd8c,
    0x4005d1dd9005895f, 0x3fec76b43ff12934,
    0x3ff626b416718390, 0x3fd0af418b9ecb98,
    0xbff8f6287f0ea38b, 0x3fe018a779f1d676,
    0xc0097d513774a033, 0x40092a0d09935edf,
    0xbfd46c307f3164a6, 0x3ffef485a2a65c54,
    0x4016579e10ddff56, 0x4009fd2eb595abb5,
    0xbffdc448b04c4f32, 0x3ff60902652bd3ca,
    0x3ffe8e3c764fe5ba, 0x3fc216d97dc43e0c,
    0xbfee5e262fb17324, 0x3ffc38589806b67a,
    0xc004b67f90dda015, 0xc00537b34810980c,
    0xc006fe88e762e549, 0xbff9999e07f09ad0,
    0xbff0b571c0724e34, 0x3ff19f6a33e9ec0e,
    0x40058d77468cc3a4, 0xc00389526ea15af8,
    0x3ffee90c5ad62cca, 0xbff536cbe0a5115a,
    0x3ffa38f4cbdc14b3, 0x40095f2969854bc6,
    0xc0046f2dc0bd0382, 0xc00458dab80f25c0,
    0x40061bbd5a4d8596, 0xbff70cc2479f49e2,
    0x4007a1667fe85b34, 0x40045f309a6b3a58,
    0xbffe8e7ef6d30d96, 0xbfd66c3424c91a48,
    0xbff3e170b9920dfa, 0xbff78d259809f49a,
    0xc002c8d45443a9e4, 0x4002f22fb01403d2,
    0x3ffdcde0b670e6d6, 0x400cc1308628c501,
    0xc0021e3e48b4c7ca, 0x3ff2f93b1fea58f4,
    0xbfb28a920a2d08a0, 0x3ff7dc8e3f6cc125,
    0xc00843f6b0257273, 0x4003c32013775b7a,
    0x400201b912f3ad1e, 0xbffea688ee401936,
    0xbff8dbce09545863, 0x40097c6f08783dbf,
    0x4003a060a38049b4, 0xbff4347474e0ec60,
    0x4007ccf830591701, 0xbff37e039a5f74e8,
    0x3ffb9a7e441d1802, 0x4001f1115be2a4a9,
    0xbfef8863ff9024ff, 0xc010e1004fb842ae,
    0x3ff5ae4de3e2b813, 0x3ff59da19feb264b,
    0x400322292071a9ff, 0xbfe10da0de7e53b2,
    0xbfe96e8c3c15a36e, 0x3ff821e12db58a72,
    0xc0062c3f010eba98, 0xc00d56c856cb8259,
    0xc009758e8dea891f, 0x3ffbd54867e54b83,
    0x3fd89c6d21770745, 0x400d82f60e3b0c9d,
    0xc00330701b484f61, 0xbfc3fd8f89a734a8,
    0x3ff29004c19cd184, 0x400341617de4f342,
    0xbfd58f59a929eaf4, 0xbfe59dc98c8a7c8d,
    0x3fff6095dd3445f5, 0x401ee96eb814d92a,
    0xbff07144a2abfde8, 0xbfeeac6560b8417c,
    0xbffe33f444623c80, 0x40009ff8e6a602de,
    0x40163d953c222264, 0xbfdd9340e009f384,
    0x4001c8aa2ba011f0, 0x3fd0819b7551ac48,
    0x400c0effb7d6a36e, 0x3fb8728a5e09f870,
    0x3fc19c6c613a918c, 0xbfaf262221cb9c10,
    0xbffd8193e6883af0, 0xc0061118df054305,
    0xc00ab17e2493b2ec, 0x4012eecb31abc9aa,
    0xbfd52dd2615e0330, 0x3fdeceeff4be7d9e,
    0x3ff53e6914dfccea, 0x3fe598392ff6eda7,
    0x40041e75fe3e2aa5, 0x3fc010fb767013dc,
    0xbff0c8297b9359a0, 0x3fde0ada26a61534,
    0x4003f8f9ef70bf11, 0x400c541f45281597,
    0x3ffd0d1881ab2976, 0x4005cea6b3419d7c,
    0x40119630f6862175, 0xc00b46d88667cc08,
    0x4003029acf6addfe, 0x3fe9619e20df2c7c,
    0xbfa94b8c07ddedb0, 0xc00820cbb4579d49,
    0x3fdabc27587c088c, 0xc006a49ce0ad4dfe,
    0x3ffae273c57f048c, 0x3ff63953b5e855fb,
    0xbff10c129af08956, 0x3fb54b1c3b3fa6ac,
    0x3ff8319d3c6d57c9, 0xbfe8085ec9ecefe4,
    0xc0079283227c9798, 0xc0064230b96c399c,
    0xc0198ec309be8577, 0x3ff2a9eb23c64f14,
    0xbff71b3cbcf4669b, 0x400078a875173f7c,
    0xbfe383a5cb174134, 0xbfe6aed6c751cd48,
    0x3fdbcaddbd2f8ea8, 0xc00d32539ec13a73,
    0xc000a5394d33a3d7, 0xbffa5d4ec18397d4,
    0x3fd0fee8f1b7b4c8, 0xc0088339e2b3c37c,
    0xc0100d78dbe6637e, 0x4008395c2e2bf67e,
    0x3fc8ccdd187651b0, 0x4005fd42f4078faa,
    0x400b36b76e7dfa34, 0x3ff5f6e249c3f29f,
    0x3fcdcac60cad1790, 0x3ffc4d29c21d6911,
    0x3ff0eae66cea359e, 0xc013b17aef8cac2a,
    0x3fd317a555ad8a26, 0x3fce772556423cb8,
    0x3fe0d8d212aefc68, 0xbfe4b7cccaef3de4,
    0x3ff5b4707ac8228e, 0x3fce00506f6fa68c,
    0xbff19068f77d9b59, 0xc00cf68071a9171a,
    0xbfc23d659445d108, 0x3faedb326cc5f7a0,
    0xc0002020fb73e534, 0xc00d3578423da0b2,
    0x3fdb221270d7bd9b, 0x3fe423362c6fcc30,
    0xbffe7c802be2238c, 0xbff63c5c5b6aa372,
    0xbff0edc516762ea4, 0x3ffcc1d8eb33b4ff,
    0xc017ed474ca79642, 0xbff80f0409568355,
    0xbffc444eb038851a, 0x3fdb06e64b33d174,
    0x3fe36e3163c94072, 0xc012f2b75b31bdee,
    0xbfe12e99f7a24d5a, 0x3fd755b3a0198bb4,
    0x4000048c83ce0fcc, 0x3ffb4227761516b5,
    0x4004265eeb79d0ed, 0x3fffbcf716738ec9,
    0xc0120eb90d35b9ab, 0xc000074eeae92cbe,
    0xbff3e98d00fa1b68, 0xbfa0bde650f86aac,
    0xbfcb47949252ab2a, 0x4015c49db8827504,
    0x3ffa9890c9f62175, 0xc003b993d5b6c100,
    0x3fffde1207f87529, 0xc013c0780a55b0e1,
    0xbfed86f25664e7f8, 0x3fe06bb5598da22c,
    0x40012812c0e9b47f, 0xbfcc0b3ac63b1524,
    0x40166be21eb45a8a, 0x4009b22da86f4cc4,
    0xc0042b9a590f4418, 0xbfe8d3480e74c444,
    0xc00212d02b1341ee, 0xc0159b791361108a,
    0x3ffb33e4276a723a, 0x3fbfd9dd29a6cb80,
    0xbffe2e429b68ea62, 0x400903d0e026a0b0,
    0x3feba176805d1e50, 0x3fe8274b47efbe98,
    0x3ff7286d2b035b84, 0xbfde4971f8e32c0c,
    0xbff7171736a55591, 0x3fed97190d490b99,
    0x4002dfcb89315df5, 0x3feb3dc2cc9d85ab,
    0x4009e9306719d60e, 0x3fe5c801fbdbdff8,
    0xc003aa15ff451164, 0x401160ce4c626672,
    0x40005ffb43bff2f4, 0x3f8b360b41daaf00,
    0x3feaff65d42e9564, 0xbfe9699e868eec3a,
    0x40049fc023866e8c, 0x3fe3864f0bfde454,
    0x3fde0c5793572cf8, 0xbfc699f3ce90da88,
    0x3ff05f19348c3656, 0x4005db43ad2677cb,
    0x3fea10f153eb2998, 0x3fe8ad42aca27c69,
    0xbfeaf052a3645c27, 0xbffd3cd80fc8e31e,
    0x3ff1ce68f5c01cea, 0xc010f4149b44d2ea,
    0x3fe225c101eb28da, 0x3fe12e8554a737fe,
    0x4000114719323f85, 0x3faaea385332c580,
    0xc015f577bedecb9e, 0xbfd829cb3c5d71ba,
    0xc007306bf45e3f80, 0x3fd58a56a5972e14,
    0x3ffc7020595310d7, 0xbfe456dff3a41054,
    0xbfe30c8eaf0d5af3, 0xc00d9194df9c50b7,
    0x3fe9b1ed21dbfa84, 0x400478a404b8a100,
    0x3fe0bb801c63914f, 0xbfd3b1d66dfbab88,
    0x3ff2cb64c7d9f4ec, 0xbff4c2568725e41e,
    0x40051b9cce96c23f, 0xc000c72b188312aa,
    0xc010edd5011bcf47, 0x3ff3b2e5e33c3fda,
    0xc00d450a869d0a70, 0x4015228170af3d60,
    0xc00fc3c71c17e2bb, 0xc00043ce0b683a46,
    0x40079ab887fdcff9, 0x3ffa055798df968a,
    0xbfe1db78c6bab4dc, 0x4006949b17458cf2,
    0x3fe250b56bc398e0, 0x4011cc123fa12ce7,
    0xc000fd39fc5dc97a, 0x3fc3702bb5ebb1a8,
    0xbff39e51b0dc1ce8, 0xc001f65a1cb5d25c,
    0x400327cb80f12170, 0x3ff4d16152e8d04c,
    0x3fea34bd553109ac, 0xbff76eaec1d30e80,
    0x40109c9ef6dbbc82, 0x4010ba37865b4a70,
    0x3feb5058334ab81a, 0x3febf83ad1085cba,
    0x3ffc44e5c30cb8b0, 0x3ff7eab70e4f9ee8,
    0x4004bb18881628d2, 0xbfe9658d4b93c05c,
    0x4012e1ca141830b0, 0xbff878dee6a18cc4,
    0xc00e4e1b43b0f0c2, 0x3fe360753aba4106,
    0x40066b904417ebf2, 0xc011bfc1318c6270,
    0x3ff0e9407cec298a, 0xbfe385deec1a05ed,
    0xbffe529da585e46e, 0x3ff915415e729187,
    0x40023c4ccbb1ab68, 0xc0051aaa6e46bb3f,
    0xbfee3a33adfd0ced, 0xc0105003440680e6,
    0x3ff23b089049ae26, 0x40035177916454b6,
    0xbfdf634b9240049e, 0xbfc83229d525b7f8,
    0x400a69a9e4179e6f, 0xc001480187caa062,
    0xc009b59423ce0024, 0x4009c3fc48369197,
    0x3ffe2565b1b4a0cd, 0x40065d8c20baad94,
    0xbff365db800dcc40, 0xc00f7e8219ec3137,
    0x3f9bbdbbe757f300, 0xbff0a209987bb96e,
    0x3ff4c84f3aa56652, 0xbfbdc979f0097c4a,
    0x3feea58d31ab4c34, 0x3fe8c2a16e066c90,
    0x3fd1d84afa1b7843, 0x3faedab2aad624a0,
    0x3ff5af54e4434fe5, 0xbfe579f64a6e7f60,
    0x3ffaf8b5b708710e, 0xbfe7b2a3186cca48,
    0xbfe446e4523726e9, 0x400215ed0b75dd68,
    0xbff359f03a9b28a6, 0xbff7c45b05eabec1,
    0xbfe50361fef74a20, 0x40087070f667c19c,
    0xbffa20461ec9fa8f, 0xbfcc2fd912ab7519,
    0x3fe6e2f7b334ab94, 0xbfe1a4c6cd124dc8,
    0x3ff77b6e2a9aa2c0, 0xbf994115be505380,
    0xc00c6b4efaf9aa22, 0xbff2b3b79c79384f,
    0x4004567e89eca3e1, 0xbff8aa5e39e1d3ae,
    0x400e8ca96015e489, 0x3ffba46b83d2bc48,
    0xbff5d9c80f2f875e, 0x3fed53df049f08ae,
    0x3fcb00ffa480614c, 0xc014291f5bbe608c,
    0xbfef3f9f9d1d1c7a, 0x400910a39479e45c,
    0xbf99ac84c7b1f280, 0x3ff7c4c23d0eb582,
    0x400cf674724e6ed8, 0x4003f292e97430cc,
    0xc0096fe0c36f80f4, 0x40186b9536936d2d,
    0xc01766492f5ffb20, 0x40034bf331e255f4,
    0x3ff6e2573a53fef6, 0x400fb994d81b1517,
    0x3ffd9c58eae263ee, 0xc00bda162fd88f26,
    0x3feb800b892e6fae, 0x4012aa57abddfb2c,
    0xc0023ea534e38497, 0xbff8cc63f4cf0147,
    0xbf807f81773e5c00, 0xbff1a12849db76cc,
    0x3ff3ded438516462, 0xbffe27efb8be6b42,
    0x3ff7876ccc95e344, 0x40014001ddaea821,
    0xc006dfababf5b76e, 0x3fca5d032f39fea8,
    0xbff58715cd47055a, 0x4005ed5b03ae3f4b,
    0xbfe3825cc8b95926, 0xbfe3c2c55a4a2704,
    0x3ff381e5739ed4ad, 0xc00939ae765620b8,
    0x3f98c30659d83a20, 0xc00400f66cf10329,
    0xc016c63d97845bc2, 0xc015accdb1d0325a,
    0xbff1c8e948fca4ed, 0xc012d2e7f3cf92ce,
    0x400945c1aaedd73e, 0x4010ee7f3d5d5a32,
    0xbff51514d2fe847a, 0xc002309301d8e5bc,
    0xbfe30cac63aa5225, 0x400fb3dea14cab57,
    0xbffef20b7e8a414a, 0x3fe9d7251a122d33,
    0xbfeb22c0df75414c, 0x40020d07af281d6f,
    0x4009986f7eb6c3f4, 0x3fcb17390540ef96,
    0xbfd00ba7a0b26a48, 0xc00275fdd1d6095e,
    0x400269fdd91164ba, 0xbfc5749783f0ed08,
    0x3fd6ea6c34327b70, 0x40065c608db61b29,
    0xbffca36883cf9be3, 0xc01495b568ebedd1,
    0x3ff292fae6ddf4af, 0xbfdb6dc4802c5648,
    0xbff40c5ee71dc0cd, 0xc00f96d037fa9af6,
    0x3fe23e87be1114e2, 0xbfe32c00ac7424db,
    0x3ffee2b9f82ff11e, 0xbfe7cfd762db16d2,
    0x3fed6319624165c5, 0x3ff7990e8bf26d6c,
    0xc010fdbf5376bd34, 0xc001fa8b897ae7ce,
    0xbff4f24e69d31194, 0x400723c9478f1087,
    0x400bf0ccd7777922, 0x3fd47b881979e78c,
    0xbffd0dc71e50abf9, 0xbfb3cb5d1a81be36,
    0x3fb9c8fcff900a2c, 0xc00ccaf2bee083ee,
    0xbfe5feab65054ad0, 0xbfef8e8fdfc6f8a2,
    0xc00b0ed4b8440794, 0xc00b910f67a09807,
    0x3ffc7a4073ddee30, 0xc003424a8d478d6e,
    0x3ffc97b4c0741cca, 0xc00ca32f3104f360,
    0x40046255f53cf242, 0x401930a0be8be4fa
    };

static const uint64_t ref_cfft_noisy_4096[8192] = {
    0x4010785baf69d0c4, 0x0,
    0x40046255f53cf243, 0xc01930a0be8be4f8,
    0x3ffc97b4c0741cc0, 0x400ca32f3104f35e,
    0x3ffc7a4073ddee2d, 0x4003424a8d478d6b,
    0xc00b0ed4b8440794, 0x400b910f67a09806,
    0xbfe5feab65054ace, 0x3fef8e8fdfc6f8a1,
    0x3fb9c8fcff9009d8, 0x400ccaf2bee083ee,
    0xbffd0dc71e50abf6, 0x3fb3cb5d1a81bdf0,
    0x400bf0ccd7777920, 0xbfd47b881979e798,
    0xbff4f24e69d31196, 0xc00723c9478f1088,
    0xc010fdbf5376bd33, 0x4001fa8b897ae7cd,
    0x3fed6319624165bc, 0xbff7990e8bf26d6f,
    0x3ffee2b9f82ff11f, 0x3fe7cfd762db16d1,
    0x3fe23e87be1114ee, 0x3fe32c00ac7424d2,
    0xbff40c5ee71dc0d0, 0x400f96d037fa9af6,
    0x3ff292fae6ddf4ac, 0x3fdb6dc4802c563c,
    0xbffca36883cf9be4, 0x401495b568ebedd0,
    0x3fd6ea6c34327b84, 0xc0065c608db61b26,
    0x400269fdd91164b9, 0x3fc5749783f0ed04,
    0xbfd00ba7a0b26a38, 0x400275fdd1d6095e,
    0x4009986f7eb6c3f2, 0xbfcb17390540ef92,
    0xbfeb22c0df754146, 0xc0020d07af281d6f,
    0xbffef20b7e8a414a, 0xbfe9d7251a122d37,
    0xbfe30cac63aa522a, 0xc00fb3dea14cab55,
    0xbff51514d2fe847b, 0x4002309301d8e5bb,
    0x400945c1aaedd73e, 0xc010ee7f3d5d5a32,
    0xbff1c8e948fca4e8, 0x4012d2e7f3cf92ce,
    0xc016c63d97845bc2, 0x4015accdb1d0325a,
    0x3f98c30659d83ac0, 0x400400f66cf10328,
    0x3ff381e5739ed4af, 0x400939ae765620b9,
    0xbfe3825cc8b95919, 0x3fe3c2c55a4a2708,
    0xbff58715cd470558, 0xc005ed5b03ae3f4c,
    0xc006dfababf5b770, 0xbfca5d032f39fea8,
    0x3ff7876ccc95e341, 0xc0014001ddaea81e,
    0x3ff3ded438516464, 0x3ffe27efb8be6b3f,
    0xbf807f81773e5d80, 0x3ff1a12849db76ca,
    0xc0023ea534e38498, 0x3ff8cc63f4cf014a,
    0x3feb800b892e6fac, 0xc012aa57abddfb2c,
    0x3ffd9c58eae263ed, 0x400bda162fd88f26,
    0x3ff6e2573a53fef2, 0xc00fb994d81b1516,
    0xc01766492f5ffb20, 0xc0034bf331e255f2,
    0xc0096fe0c36f80f4, 0xc0186b9536936d2c,
    0x400cf674724e6ed6, 0xc003f292e97430cc,
    0xbf99ac84c7b1f480, 0xbff7c4c23d0eb581,
    0xbfef3f9f9d1d1c7d, 0xc00910a39479e459,
    0x3fcb00ffa4806150, 0x4014291f5bbe608d,
    0xbff5d9c80f2f8759, 0xbfed53df049f08b8,
    0x400e8ca96015e48a, 0xbffba46b83d2bc46,
    0x4004567e89eca3e2, 0x3ff8aa5e39e1d3ae,
    0xc00c6b4efaf9aa21, 0x3ff2b3b79c793850,
    0x3ff77b6e2a9aa2ba, 0x3f994115be505480,
    0x3fe6e2f7b334ab9c, 0x3fe1a4c6cd124dd1,
    0xbffa20461ec9fa8a, 0x3fcc2fd912ab7538,
    0xbfe50361fef74a1c, 0xc0087070f667c19b,
    0xbff359f03a9b28a8, 0x3ff7c45b05eabebb,
    0xbfe446e4523726e2, 0xc00215ed0b75dd68,
    0x3ffaf8b5b7087110, 0x3fe7b2a3186cca4a,
    0x3ff5af54e4434fe3, 0x3fe579f64a6e7f69,
    0x3fd1d84afa1b7839, 0xbfaedab2aad624e0,
    0x3feea58d31ab4c32, 0xbfe8c2a16e066c8e,
    0x3ff4c84f3aa56650, 0x3fbdc979f0097c00,
    0x3f9bbdbbe757f280, 0x3ff0a209987bb96f,
    0xbff365db800dcc40, 0x400f7e8219ec3138,
    0x3ffe2565b1b4a0cd, 0xc0065d8c20baad94,
    0xc009b59423ce0024, 0xc009c3fc48369198,
    0x400a69a9e4179e6f, 0x4001480187caa05f,
    0xbfdf634b924004ae, 0x3fc83229d525b820,
    0x3ff23b089049ae26, 0xc0035177916454b4,
    0xbfee3a33adfd0cef, 0x40105003440680e6,
    0x40023c4ccbb1ab68, 0x40051aaa6e46bb3f,
    0xbffe529da585e474, 0xbff915415e729184,
    0x3ff0e9407cec298b, 0x3fe385deec1a05e8,
    0x40066b904417ebf1, 0x4011bfc1318c6270,
    0xc00e4e1b43b0f0c3, 0xbfe360753aba410b,
    0x4012e1ca141830af, 0x3ff878dee6a18cc7,
    0x4004bb18881628d1, 0x3fe9658d4b93c05e,
    0x3ffc44e5c30cb8af, 0xbff7eab70e4f9eeb,
    0x3feb5058334ab814, 0xbfebf83ad1085cb8,
    0x40109c9ef6dbbc83, 0xc010ba37865b4a70,
    0x3fea34bd553109a0, 0x3ff76eaec1d30e80,
    0x400327cb80f12172, 0xbff4d16152e8d04a,
    0xbff39e51b0dc1ce4, 0x4001f65a1cb5d25a,
    0xc000fd39fc5dc97c, 0xbfc3702bb5ebb1ac,
    0x3fe250b56bc398db, 0xc011cc123fa12ce7,
    0xbfe1db78c6bab4e3, 0xc006949b17458cf1,
    0x40079ab887fdcff9, 0xbffa055798df968a,
    0xc00fc3c71c17e2b9, 0x400043ce0b683a45,
    0xc00d450a869d0a6e, 0xc015228170af3d60,
    0xc010edd5011bcf46, 0xbff3b2e5e33c3fd7,
    0x40051b9cce96c240, 0x4000c72b188312ad,
    0x3ff2cb64c7d9f4ec, 0x3ff4c2568725e41f,
    0x3fe0bb801c63914b, 0x3fd3b1d66dfbab84,
    0x3fe9b1ed21dbfa84, 0xc00478a404b8a100,
    0xbfe30c8eaf0d5af9, 0x400d9194df9c50b7,
    0x3ffc7020595310da, 0x3fe456dff3a41057,
    0xc007306bf45e3f80, 0xbfd58a56a5972e08,
    0xc015f577bedecb9e, 0x3fd829cb3c5d71c6,
    0x4000114719323f84, 0xbfaaea385332c540,
    0x3fe225c101eb28da, 0xbfe12e8554a737fe,
    0x3ff1ce68f5c01ce8, 0x4010f4149b44d2ea,
    0xbfeaf052a3645c20, 0x3ffd3cd80fc8e31e,
    0x3fea10f153eb2998, 0xbfe8ad42aca27c5e,
    0x3ff05f19348c3653, 0xc005db43ad2677cb,
    0x3fde0c5793572d08, 0x3fc699f3ce90da98,
    0x40049fc023866e8c, 0xbfe3864f0bfde450,
    0x3feaff65d42e9560, 0x3fe9699e868eec3a,
    0x40005ffb43bff2f4, 0xbf8b360b41dab180,
    0xc003aa15ff451165, 0xc01160ce4c626671,
    0x4009e9306719d612, 0xbfe5c801fbdbdffc,
    0x4002dfcb89315df6, 0xbfeb3dc2cc9d85ac,
    0xbff7171736a5558f, 0xbfed97190d490b9c,
    0x3ff7286d2b035b7f, 0x3fde4971f8e32c18,
    0x3feba176805d1e54, 0xbfe8274b47efbe9c,
    0xbffe2e429b68ea64, 0xc00903d0e026a0b2,
    0x3ffb33e4276a7239, 0xbfbfd9dd29a6cba0,
    0xc00212d02b1341ee, 0x40159b791361108a,
    0xc0042b9a590f4419, 0x3fe8d3480e74c448,
    0x40166be21eb45a8a, 0xc009b22da86f4cc3,
    0x40012812c0e9b480, 0x3fcc0b3ac63b1514,
    0xbfed86f25664e7fc, 0xbfe06bb5598da22c,
    0x3fffde1207f8752a, 0x4013c0780a55b0e2,
    0x3ffa9890c9f62176, 0x4003b993d5b6c102,
    0xbfcb47949252ab16, 0xc015c49db8827504,
    0xbff3e98d00fa1b6c, 0x3fa0bde650f86b08,
    0xc0120eb90d35b9aa, 0x4000074eeae92cbd,
    0x4004265eeb79d0ee, 0xbfffbcf716738ec8,
    0x4000048c83ce0fce, 0xbffb4227761516b4,
    0xbfe12e99f7a24d64, 0xbfd755b3a0198bb6,
    0x3fe36e3163c94072, 0x4012f2b75b31bdee,
    0xbffc444eb038851a, 0xbfdb06e64b33d174,
    0xc017ed474ca79642, 0x3ff80f0409568354,
    0xbff0edc516762ea6, 0xbffcc1d8eb33b502,
    0xbffe7c802be22388, 0x3ff63c5c5b6aa374,
    0x3fdb221270d7bd97, 0xbfe423362c6fcc2c,
    0xc0002020fb73e532, 0x400d3578423da0b0,
    0xbfc23d659445d0fa, 0xbfaedb326cc5f7a0,
    0xbff19068f77d9b5c, 0x400cf68071a91718,
    0x3ff5b4707ac8228b, 0xbfce00506f6fa674,
    0x3fe0d8d212aefc72, 0x3fe4b7cccaef3de2,
    0x3fd317a555ad8a2a, 0xbfce772556423cc0,
    0x3ff0eae66cea359c, 0x4013b17aef8cac29,
    0x3fcdcac60cad17c0, 0xbffc4d29c21d6910,
    0x400b36b76e7dfa35, 0xbff5f6e249c3f29e,
    0x3fc8ccdd187651a0, 0xc005fd42f4078fa5,
    0xc0100d78dbe6637e, 0xc008395c2e2bf67a,
    0x3fd0fee8f1b7b4ca, 0x40088339e2b3c37c,
    0xc000a5394d33a3d5, 0x3ffa5d4ec18397d7,
    0x3fdbcaddbd2f8ea4, 0x400d32539ec13a6f,
    0xbfe383a5cb174128, 0x3fe6aed6c751cd4c,
    0xbff71b3cbcf4669a, 0xc00078a875173f7a,
    0xc0198ec309be8577, 0xbff2a9eb23c64f18,
    0xc0079283227c9796, 0x40064230b96c399a,
    0x3ff8319d3c6d57ca, 0x3fe8085ec9ecefe4,
    0xbff10c129af08956, 0xbfb54b1c3b3fa700,
    0x3ffae273c57f0488, 0xbff63953b5e855fa,
    0x3fdabc27587c0878, 0x4006a49ce0ad4dfc,
    0xbfa94b8c07ddede0, 0x400820cbb4579d47,
    0x4003029acf6addfc, 0xbfe9619e20df2c72,
    0x40119630f6862175, 0x400b46d88667cc09,
    0x3ffd0d1881ab2976, 0xc005cea6b3419d7e,
    0x4003f8f9ef70bf11, 0xc00c541f45281595,
    0xbff0c8297b9359a4, 0xbfde0ada26a61539,
    0x40041e75fe3e2aa6, 0xbfc010fb767013f1,
    0x3ff53e6914dfcce6, 0xbfe598392ff6edac,
    0xbfd52dd2615e0336, 0xbfdeceeff4be7d99,
    0xc00ab17e2493b2eb, 0xc012eecb31abc9a8,
    0xbffd8193e6883af1, 0x40061118df0542ff,
    0x3fc19c6c613a91cc, 0x3faf262221cb9c40,
    0x400c0effb7d6a36e, 0xbfb8728a5e09f878,
    0x4001c8aa2ba011ef, 0xbfd0819b7551ac42,
    0x40163d953c222264, 0x3fdd9340e009f37d,
    0xbffe33f444623c80, 0xc0009ff8e6a602dd,
    0xbff07144a2abfde7, 0x3feeac6560b8417c,
    0x3fff6095dd3445fa, 0xc01ee96eb814d927,
    0xbfd58f59a929eaf8, 0x3fe59dc98c8a7c8d,
    0x3ff29004c19cd184, 0xc00341617de4f342,
    0xc00330701b484f60, 0x3fc3fd8f89a734a0,
    0x3fd89c6d21770738, 0xc00d82f60e3b0c9e,
    0xc009758e8dea8922, 0xbffbd54867e54b7c,
    0xc0062c3f010eba98, 0x400d56c856cb8258,
    0xbfe96e8c3c15a36d, 0xbff821e12db58a70,
    0x400322292071aa00, 0x3fe10da0de7e53b1,
    0x3ff5ae4de3e2b810, 0xbff59da19feb2652,
    0xbfef8863ff902504, 0x4010e1004fb842ae,
    0x3ffb9a7e441d1800, 0xc001f1115be2a4a9,
    0x4007ccf8305916ff, 0x3ff37e039a5f74e8,
    0x4003a060a38049b4, 0x3ff4347474e0ec5e,
    0xbff8dbce09545864, 0xc0097c6f08783dc1,
    0x400201b912f3ad1d, 0x3ffea688ee401931,
    0xc00843f6b0257273, 0xc003c32013775b7c,
    0xbfb28a920a2d0890, 0xbff7dc8e3f6cc11e,
    0xc0021e3e48b4c7c8, 0xbff2f93b1fea58ec,
    0x3ffdcde0b670e6d6, 0xc00cc1308628c502,
    0xc002c8d45443a9e3, 0xc002f22fb01403d4,
    0xbff3e170b9920df6, 0x3ff78d259809f498,
    0xbffe8e7ef6d30d96, 0x3fd66c3424c91a4c,
    0x4007a1667fe85b35, 0xc0045f309a6b3a58,
    0x40061bbd5a4d8594, 0x3ff70cc2479f49de,
    0xc0046f2dc0bd0380, 0x400458dab80f25bf,
    0x3ffa38f4cbdc14b0, 0xc0095f2969854bc6,
    0x3ffee90c5ad62cc9, 0x3ff536cbe0a5115a,
    0x40058d77468cc3a2, 0x400389526ea15af8,
    0xbff0b571c0724e36, 0xbff19f6a33e9ec0c,
    0xc006fe88e762e548, 0x3ff9999e07f09acc,
    0xc004b67f90dda016, 0x400537b34810980d,
    0xbfee5e262fb17324, 0xbffc38589806b676,
    0x3ffe8e3c764fe5bb, 0xbfc216d97dc43e04,
    0xbffdc448b04c4f35, 0xbff60902652bd3cd,
    0x4016579e10ddff56, 0xc009fd2eb595abb4,
    0xbfd46c307f3164b4, 0xbffef485a2a65c50,
    0xc0097d513774a032, 0xc0092a0d09935edf,
    0xbff8f6287f0ea386, 0xbfe018a779f1d670,
    0x3ff626b41671838c, 0xbfd0af418b9ecb9e,
    0x4005d1dd90058960, 0xbfec76b43ff1292c,
    0xbfea0809fee9bcda, 0x3fe867f16782fd92,
    0x3fff0968aa4d2a42, 0x40017376823e94c0,
    0xc005de8ec83d327a, 0xc0067e90be4f821a,
    0xc00261c3805973ec, 0x401031323380cdc2,
    0xc002673d88463af8, 0x3ff513de46e30908,
    0x4009c45509cfac04, 0x3fb076b690f7a940,
    0x4000f8e9160f1c7a, 0xc010fe5e7c8d8cb2,
    0x4000ce23d281ca36, 0xbff44d681affe7c0,
    0x3fd39cc9f1b87938, 0x3fe4dfbefd1bb401,
    0xc0011183d32b7efb, 0xc01abb09f933328d,
    0xbfec244290b33c62, 0x4005a91d4379a564,
    0x3ff1790a89483d1c, 0xbff2a9fc4e89449b,
    0xbfe6f06315fdae6d, 0xc00117f1ebff2bec,
    0xbfea57a50834e2c3, 0x40088d9cadb7026a,
    0x3fe336e574526b8a, 0xbfd6dd2a8be2f024,
    0x4011dfc706ab6ca2, 0xbfe39ed90603fbe4,
    0x3ff08f65bd8fdcb0, 0x4008ff6b6fe25a97,
    0x40012c6a9330cbb2, 0x3fe26613be4f8689,
    0xc006c98b5a7ca28c, 0x3fe47a91da0a6a5e,
    0xc0061f6c4cb9f7ae, 0xbffdbd6850201b50,
    0x40173b0f785ad372, 0xbff0daa814ac093a,
    0xbfe4b91bd949162b, 0xc0008c771adcf1e2,
    0x40001cf9856eca7b, 0xbfc8587d2effd2ee,
    0xbfd801f386cb3a3a, 0x4004490f1f5716a4,
    0x3fdcaa49bca7bdb5, 0x3fe3e296f1cfc920,
    0x3fd905883aa2328c, 0x400aa963b9c03297,
    0xbfe8a38d629fdc14, 0xbff92a0b37f5613e,
    0xbfcaa78e5cbc14aa, 0xc013780f5afbd624,
    0x3ffe7c52b4c96894, 0xc00def94814ce26c,
    0xc00167c55cb8bcac, 0x4016c23ffa5e36ec,
    0x4006324d8db1c74c, 0x3fd47802cafba692,
    0x3fd72b36ee1d21f2, 0x3fcfb0d0800bf890,
    0x4003f0bd2fd383fa, 0x3fd3866604bc43c8,
    0x3fde1c2098ac2f4c, 0x400c3148bc606aa6,
    0x3fc4938e5a130660, 0x3ff936ac93ac1e6b,
    0xbfd770a5e9c78240, 0xbff7252403f012b4,
    0xbfe4803b3bc897be, 0xbffb20c323e8a38a,
    0xbfe087611a01c9ac, 0x3fedd55f0ac0414c,
    0x3ff4ec102724c0bc, 0x400231e519c78820,
    0x400eaf82fd23443a, 0xbff46bdeb2871544,
    0x3ffaefa185763943, 0xbff106cf3c1f854e,
    0x4004b79e51a595a4, 0x3fdb5c977a48714c,
    0xbff1c7829b4c93c3, 0xc00240b37c6fb5ff,
    0xbff9ae8959ec4bdc, 0xbff97d1420539168,
    0x3ff9ca42e65b1cee, 0xbfd9aa588be0f758,
    0x3ffc7f283c7d67e7, 0xbfea412063235e88,
    0xc0003b5fc7a5c122, 0x4003bfce5e95a833,
    0x3fd3cdf896778908, 0xbfa493e0dca716b8,
    0xc00977dadd9b9d42, 0x40068236916c074f,
    0x3fd78f9cfdf04fc6, 0xc006f82d6f7dbdff,
    0x3feab3c9659add30, 0x3fbe134c322b82e8,
    0x4001f14c5488d56c, 0xbfd740985c544d80,
    0xbffac92d43dec51a, 0xbfc18c0d35e2da24,
    0xc00e2c7106d4078b, 0xc0064fffd151a21b,
    0xbfe789abb79e96fe, 0xc004f8ee6cc24775,
    0xbff58bf147f8e88c, 0x3ff222b592fa140e,
    0xbfef608990140868, 0x3fec2b9eae0e84f5,
    0x3fe88f0c7703ed49, 0x3ff977170c027f6e,
    0x40036b96c79f097e, 0xbfeef3bfd1bdaa66,
    0x40047c38923c6c96, 0x3ffbe91618d6940b,
    0xbfed35151bfbd8d4, 0x4013201680b253bc,
    0xc001e8a7333f2c28, 0xbfe1aec627e58a20,
    0xbfe4f3c5a1c004f4, 0x4003bfe233ca5ac6,
    0x3ff63f5e87d5615c, 0xc000193d1fb76193,
    0xbffd7b6ae8778ff0, 0x4014b3bc0d0b30a6,
    0xc0013cec5ee05967, 0xbfe6c51f49cec7e3,
    0xc003a076e661816c, 0xbfd31e446e273858,
    0x40190fb61c0a8919, 0xc00968c2f8f0525e,
    0xc01005c05d1d0b13, 0x3ffa4bec157f2193,
    0x3fe5167e0f020628, 0xbffb80ed925a72be,
    0xc011005ad0dc664d, 0xbfe0212b9eda09c1,
    0x4003ba1492b15d7a, 0xbfe52b3dc4356e4e,
    0x3fff93c8887957e6, 0x3fbbda694204f410,
    0x3ff356c19caa9a1e, 0x40037b613f8bccf6,
    0x3feafa16f841b82c, 0x3fff4f1a62fd03a1,
    0x3fedb18ebc811d9f, 0xbfe3417c23871f04,
    0x3ff38e646f8f788e, 0x4011955e8e79c784,
    0x400692e6f8e79098, 0x3fec30ce6142811c,
    0xc011ebe00bfbcec6, 0x4006b132c443a135,
    0x3ff330c40bfe68ad, 0xbff28e8617d6bcee,
    0x3fe046c773e33008, 0xc002fb0b68224bce,
    0x3fd7b443d2542f9c, 0xc007402d62cd4f6c,
    0x3feda6e4faec3e66, 0x3ff2f0d18e4d0210,
    0x40038f0662b551e6, 0xc00a8070b70792c4,
    0x3fd195df779dbf90, 0x3ff933b525a791d7,
    0x3fb2852f2c3882d0, 0xc00140c5e523c58e,
    0x40006be728c073fb, 0xc0007b7d28a4345d,
    0x400997bea42fd30b, 0xbffe3cf457885460,
    0xbfe6c41ff26f0884, 0xc00b39b65d52596d,
    0xbfe87cbd440f55ec, 0x3fe0cd8f0c7b85c0,
    0x400d33ea9dff9509, 0xc00bf57fd9e52ac6,
    0xbff8fdc81aecfa36, 0xbff444da6bf2491a,
    0xc011a698c7017eea, 0xc01508b11a5e5d24,
    0xbfe4cac75f752dc9, 0xc011ea11fc632528,
    0x400ca15e2bd95068, 0x3febee742f526ca2,
    0x40119202722355db, 0xbfa312037004d2c0,
    0x3ff8392d23c75fd0, 0x3ffd53c402422a0d,
    0x4010326ffc92f3ce, 0xbfeed7ad85ca9a00,
    0x3f8eac2323a07cc0, 0x400479861ca0d828,
    0x3fcbaec0442cd816, 0x3ff6ec0f5926f6db,
    0xc00212a436510d33, 0xc00a77acb8d287a2,
    0x3ff481fcd679df28, 0x4011d44e8dd3a1ac,
    0xbff1ae232bbf5c74, 0x4015d4c9c515afc5,
    0x4005fc09c52e3999, 0x4010ff37241e0a0c,
    0xbff24f7579883592, 0x3fef730b119f44ba,
    0x4002e6a2dd03a3d6, 0xbfb0f5cb1330d8e0,
    0xbfc0bdc090d37998, 0x40073b35e6218234,
    0x3fe7a650ca67c79a, 0xc00982ec50fc8f07,
    0x4009bd46bf9db1e8, 0xbfd30aca7faff17c,
    0x400678a8033fa27e, 0x3fcd6b7500058550,
    0xbffb53ba2b05133c, 0xc0082bab32be21fc,
    0x4000df395fd904f0, 0x3ff6cf418302d532,
    0x3fbb62a7922b5540, 0x3fe2edbfb6237cca,
    0x3ff819fb4be7c7f8, 0xc00978091eadace8,
    0xbfe5bb36fc0790d8, 0x3fd4671182f9377a,
    0x4009683546e19da2, 0xbff93f7227506d0c,
    0xbffba680bf4ec58d, 0xc0053a10f1605e19,
    0xbff7aaa87f7d2702, 0xbfef250e29617619,
    0xbff6b369418a3a90, 0x3fca783daada8588,
    0x400e769736e5a6cc, 0xc0043526c48de0de,
    0x3fe2574d1e9d4a86, 0xc016a609ca6f7eb0,
    0x3fef2d27b9768cd1, 0x3ff0bfd3be35e284,
    0xbf8f53e1a5344e80, 0xbff3621bead582ab,
    0x4019303cd1385f96, 0x40006681b2cae479,
    0x3fc45d1c3b7f03ec, 0xc0058fb7ec566b5e,
    0x4015c689afa7153e, 0x4015d49c23662d69,
    0xc006246d32bd3302, 0xbf92719f6e48b6c0,
    0xbff9fe6f41333835, 0xbfe313b4b8a903ee,
    0x3ff689ae1ca2e136, 0xbff9bac30f6bfe90,
    0x400bbd6c2db699a8, 0x3fe29c990c40c860,
    0xc014534bc163588d, 0x3fcdc29343c74068,
    0xbff9789c7becf076, 0x3ffe887a4eadb5be,
    0x3fc34f6f8a1c2e98, 0x3fd7eaaea12de1ca,
    0x4009311f7674bfd2, 0xc0039f85e1086a32,
    0xc00d77fc49666c7c, 0xbff37693ded78cc2,
    0xc00fcfb02d3cb358, 0x3fd3cd894f2dc660,
    0x3ff8b2bf5bef5361, 0x3ff72ec004e280ee,
    0x3ff1113b3d6f28bc, 0x3fed78e1f4f03cb2,
    0xbffa08c253c53852, 0xbfecfc8e1deef8c0,
    0x3fe8290dd46e3f80, 0xc005e7027b1e8e7a,
    0xc011dad7604e8de0, 0xbffe21d4c40813a2,
    0xbffa1e26516ff036, 0xbfb77da55f40b630,
    0xbfd6a219d029fee4, 0x3ff42262b9bf7cb0,
    0x3ffb019ec54960bf, 0x3fe7deb707d169be,
    0xc01377854e5901bc, 0x3fe2c81b8735ae63,
    0x4003bba9fc43e7da, 0xbfede6b11e4e0730,
    0xbff9f08c10ba39cd, 0xc0041a3309d1d3b2,
    0x3fd67138ff4a9608, 0x4003e4725b72f23c,
    0x40084f15e06df424, 0xc00a1bcd3210c098,
    0xc004deed6d42327a, 0xbff74d1611d69194,
    0x3fdf1e251e5541a0, 0x400978205d6e0e9a,
    0x3fd0b9c210f6aee6, 0xbff23106de28e127,
    0x3fffcdf13670d9de, 0xbff00a4984e5b472,
    0xc00bf8feff3a6fc6, 0xbfeb3363da45b27b,
    0x3fdd64d22a7c8bf0, 0xbfc54f96a16ed66c,
    0x3ffc84fbb353c381, 0x3ffc2eb750dc70ba,
    0x3fe1b4453d4f0530, 0x401021db778f2459,
    0x3fb414851fb9b24c, 0xbffe0725e7d062e2,
    0xbfdc899c4d0934e5, 0xbf7f800c0be58700,
    0x3fb37ad79cd1c214, 0x3fe7f0b53852ffa4,
    0xbfce09f0ade800e0, 0x3ff55219d8f15854,
    0xbfecfab4b2b46c0c, 0x4005d073925cf1e0,
    0x400361251a2e771a, 0x3fd03531a19abee0,
    0x3fec88dc8b79a7b5, 0x3ff57080e228ade1,
    0xc00f111e3548bc60, 0xc0018b19890e9ca8,
    0xc00221b93e151a13, 0x40074400b067f8c2,
    0xc01b8188340bd888, 0xbf58bba849769800,
    0xc000130607fb29a3, 0x3ff3b124c7f517f4,
    0xbff9240e25a3d70b, 0x40014af734b412f8,
    0xbfb6d1661c509128, 0x3ff4b364b0ff58b0,
    0x400b26fdf78b41c9, 0x3feb1e5f4d24a3c0,
    0xc004090ed35a6f98, 0xbfcba547823a681c,
    0x40107654f588b349, 0x400290993b7e7507,
    0xbfae9c65235cb160, 0xbffd26d15585cba0,
    0xbfde95ed168d8421, 0x400f7479853a0936,
    0xbfeeebe792dc5baf, 0x4013d46a62ced142,
    0xc011659e08931046, 0xc009c459480b37eb,
    0x4004aa00b3daa7fd, 0xbffa2f1bb8bc0e04,
    0x400177d9190dbe0b, 0xc0158b128de79760,
    0x3ffc4242356b01dc, 0xc01479c11897701e,
    0xbfe33f59979dbcf8, 0x4005b6e0e22b505e,
    0x3ff44bacc539ba1e, 0xbfdff48449dd2b28,
    0xbff3dfc3a3c2eeeb, 0x400bf6f4ea3a5bcb,
    0x3ff148cf67c3c9ab, 0xc000564f5c0815d7,
    0xc003d25d2c64268c, 0x4006b9843e43ee50,
    0xbfffe1b16d4d59f1, 0xbfdac14ea450079c,
    0xbfeb300fc3f29f96, 0xbfde9fe9832c5a08,
    0xbff50367d0e83e25, 0xbff6dbe91f31b8f8,
    0xc015985cb0c254d4, 0x3ffe1238be75fece,
    0x4007b56a9fa3eabb, 0xbfc5964cefee3178,
    0x3fc3678ec639dd24, 0xc008468352313f91,
    0x3fe8d8989a47b4b2, 0x3f8d18357cb92e80,
    0xc0007ba318be5d5e, 0x3ff3dc756e20b7f8,
    0x3ff4a06986b780ec, 0x3ff05bccaa8b86e6,
    0x4005d0cdb0ad4ff5, 0x3ff403d17469a816,
    0xc007131f4ea2f593, 0xbff4f58b4eac50e2,
    0xbfe08aa7f2c7d321, 0xc012119c7e4c2977,
    0xc0010bec1ae8910b, 0xbffe07e39d2d9e12,
    0xbff57f3cbe3bae74, 0x3ffb2b0855dbf34a,
    0xbff1290a91c57810, 0xc00c6e72d9b4c486,
    0x400a0be9a8ada04d, 0x3fa8bbe2af5a4250,
    0xbfff12c6e1ec56a9, 0x3fd6006e98674822,
    0xc00cb0459dd8f9f6, 0xbfbceaf46ca5e970,
    0x3ffc192eaad0c955, 0xbfee531bdd3b1f58,
    0xbfe33a72878f26a0, 0xbfe69aa4ccc03804,
    0x3fff03811c762f1e, 0xc0018d77fe08d808,
    0xbff56771c04e887c, 0x3ff7a1aa51c3c7b9,
    0x401056ab2a6fb5e0, 0xbff259e0f6bc9a36,
    0x3fed49c82fca34f6, 0x3ff8837811efb5ba,
    0x3ffa8d84ee24d82e, 0x3fe29cdfbb5d3988,
    0x40084eb9db9770d6, 0xbff08ac0a946cba6,
    0x400be5b601b2dc79, 0x3ff5c6ed2fb7c8fe,
    0x3f7cc4fd0e133800, 0x3fea478b6a2063a4,
    0x400e9c21fd068850, 0x3ff9b5ae34685593,
    0xc002db4b8b8dfb4a, 0xc010f95d83c54e90,
    0x3f7c5f7932e2cd00, 0xc010ed2e98915bda,
    0xc0038628583c537b, 0xc001c7b4ea2bbce5,
    0xbff7c65a5f26ef33, 0x401406275c86992c,
    0x3fefd15a4ed8c9c0, 0xbff9618304ca014e,
    0x3fbed0d0269b92c0, 0x3ff13ad3d7578b71,
    0x3fdf0b9ab61ad670, 0xbfe7773086c5d10a,
    0x3ff35fbec069d644, 0x40045b810908710f,
    0xbfe19cf02a65c8b3, 0x3ff51fd330334033,
    0xbff139ea6e9bb98b, 0x3ff5bc4610994144,
    0xbfe890f6d6671380, 0x4005cbf028b0d971,
    0xbff0bd4b32142b0c, 0xbf7ae2f1cd533000,
    0xc008f2c5fbd4045c, 0x3ff0cae02f3c4d40,
    0x40018e4d24c46bca, 0xbfd8dfea0ab34c98,
    0x3fe0a94e408380a7, 0xc00f9a41f1b0e53c,
    0x4005553c26a462f6, 0x3fc6cb638f9213d8,
    0xc003d0de740868aa, 0x4005ff5c629dfbe3,
    0xbfdfc19f4de1b9a8, 0x3fe1ccba51c07fa0,
    0xbfe24c267570ea10, 0x3fed416ed66479c0,
    0xbfeb24fd1a9f78e8, 0x3fd2a10a1ead0d30,
    0x3ff1eb335db63fe7, 0x3fe123a3d5a03306,
    0x3fc1eae7b93daea8, 0x3ff29c1d7bfdc8d2,
    0xc0098417ab5d0dcd, 0xc00c57fd58e3c49c,
    0xc00f70198b03008a, 0xc00cc9a9a36be61b,
    0x3fdbd2c539fc6d0c, 0x3fdfb3ff6a1ed558,
    0xbfd5953849d2f570, 0x3fe496fa18f241d0,
    0xbfdf3572887e45b8, 0xbfbd24d3526de1e8,
    0x40014093718a38e6, 0x40043aa99dd182e1,
    0xc0031c131a05abf5, 0x401846b5b0acee2d,
    0xbfc5136198536c50, 0xbfe573656b7c54c4,
    0xc0118de683b948dc, 0xc009be6cc9e9b497,
    0x4008a411881bf5d2, 0x401a9a48a7fbf70f,
    0x3ff86ce6121d6a90, 0xc00a9429f8ac7f2e,
    0xbff53669ecca7c85, 0xc002c3c5db03432d,
    0x3fe6defd9405ecee, 0x3ff5482cccc0238c,
    0x3fe1aab08893dbdc, 0x3ff948128d34c8fa,
    0x3fde397ea33d8df8, 0x3fdd058b4474ed94,
    0x3fd7243ef9a3c77b, 0x40126e8fd6a50bf2,
    0xbfd1d9fba826903a, 0xbfdaa321021b5d92,
    0xc00532158d35b2f2, 0xbfe3a367c160877e,
    0xc00be4d858f4d56c, 0x3fe154fb6556929b,
    0xc000d737cfa1cbf7, 0xbffa68d26d61241a,
    0xbfca74f6e92b265c, 0xbff1661411d2d332,
    0xc00588a41985d7d5, 0x3fd89904520ebb7c,
    0x400835e1683d7880, 0x400436c664c99f96,
    0x3fe11457b89b8a57, 0x400b00c9a85fd9d6,
    0x4009b6469e5bd13a, 0x3ff34c3fc82717cf,
    0x3fe5884438cffd4c, 0x3fd467d8c3d1d810,
    0x4013184c0bce04ee, 0x40109c8006c9d97c,
    0x3fdd127935614d50, 0xbfee1c27619eb7d4,
    0xbfea912f675bd586, 0xbfb793b64b0239e0,
    0x3ff59ce6aa1b48a4, 0x400506340f3647e8,
    0xbff23777ce6798bb, 0xbf989e8efb2dd100,
    0x3ff3a7eb6f54ba06, 0x3fcb4d31dbd89c78,
    0x4013b1a3f5a496d6, 0x401421f88b902107,
    0xc00619d09c4c35fb, 0xbfe26537089463be,
    0x4013260a439ae5b2, 0xbff20fa07713390b,
    0xbff8d04c57cd09d2, 0x400764dbbd9d4af3,
    0xbfabb9ec32f98820, 0xc0056df5b3945be2,
    0x400cc5a3c3cd796f, 0x400884cfe9a65036,
    0xbff448406fe92526, 0xc0045df85b4fba1e,
    0xc00bb3c8bb10e31e, 0xc008e881bb90aeb6,
    0xbffa3b14875b936a, 0xbff871bb570c6e3d,
    0x3fc2ece985b5edd8, 0x3fd77d8178b6ea24,
    0x3fd3f1c7fc46096e, 0xbfeaccf9d0b2ea11,
    0x4009732cf5d0affe, 0xbfeb35489a82996c,
    0xc0018f78c34b1716, 0xc01495206b64d808,
    0x3ffd4470eaaae442, 0x4002a1df25b75481,
    0x400c052d966802c6, 0x3ffbaedf441fea2e,
    0xc007937ebb7bda5d, 0x3ff17bcd912c4542,
    0xc00e7dd2c7e3f41a, 0xc006ee5df84ac04e,
    0xc005ba09292583ae, 0xc005712c1a5a8fef,
    0xbff7929309a39fa8, 0x3ff22c176ea42c88,
    0x3fbcb9a4df218ed0, 0x3fa5a653e63f35d0,
    0x40101d431d075150, 0xc00cb78cbe096045,
    0x3fea72727f831183, 0x3fd07123d64db12e,
    0x400c5aaff1f80cee, 0xbffadc25acd46e1e,
    0xc00d99efc725a350, 0x3fe0438cc7b09240,
    0x4008aa906d47492a, 0x4002257ffb637c81,
    0xbffda2e70d630f64, 0x3fffe94cd399bb6e,
    0x3ffd551af00e1876, 0x3ffddc466964a790,
    0xbfd458326608f7b8, 0x3ff4a26ae0e591f8,
    0x3fe936c5399901a2, 0xbff254051b85d81c,
    0x400550afc0e1c365, 0xc00573374f8098a8,
    0xbfd98cc5529993d2, 0xc09666fc4e690dfc,
    0x400b7ab36ca7611a, 0xbfffb66531289158,
    0x4003d9ab8ddca7a2, 0x3ff7bb146e227a6d,
    0xc00738a937551b0d, 0xbff1bb3c5010e938,
    0x4003009b8d0089b6, 0x3fed629938eba9ff,
    0xc0012d091e9fa17b, 0xbffc9b88c08d493a,
    0xc012aa454bf6b2fc, 0x400b5a15deda612d,
    0xc0046f1f83f6a501, 0x400a4ae019f1a79a,
    0xc007e912d39e77da, 0x40093f2c188bdc71,
    0x3f9280f634cace80, 0x400cf40d96605080,
    0xbff891a8735cdeef, 0x400055b358a00bf0,
    0x3ff9904b5f41f1b2, 0xc00ee8d1245b10be,
    0xc012455e2baddf72, 0xc002b0cab75ea767,
    0xc002e7883a2b179e, 0x40009af95ae4e4fc,
    0x3ffb4d9e0e1455cc, 0xbfdaaf7136ab52ac,
    0x3fec41c79f351f88, 0xbfe568fea588dd41,
    0x3fda5e0645d13c5e, 0xc00f93b29e92a78c,
    0xc01a0c9f0290c1dc, 0x3ffcffc9562d6dd4,
    0xc012d6de173469d7, 0xbff5ad5c4c85d460,
    0x3fdef642c741f449, 0x4002a3b05e14cbe9,
    0xbff3f56d105089d1, 0xbfd6eb7a68356712,
    0x400e68b4668cddb9, 0xbffaea8cdca7edee,
    0x3ffb17e71052faec, 0x3ff0f8235e4656d0,
    0xbfd7da7e875aefca, 0x400498f1863424e3,
    0x3fe223059c6a058b, 0xc001787750c56f71,
    0x4006f954c4048214, 0x40165f118b3a78a6,
    0xbffa6ab1565aa3c7, 0x400432b8ba2952ac,
    0xbfdbd0c044daf663, 0xbff0786e33693df8,
    0xbfef53f148ba6cd9, 0xc00558634d18dbbe,
    0x4000b0f17c12f0ee, 0x3fe850db91876e6d,
    0xc003d91e75a6d52b, 0xbffe0678a886bcda,
    0x3ff22a743c9d1556, 0xc00bb40c7c2b17da,
    0x3fe4854bbe267939, 0x3feed328817fe7ad,
    0xc012166baddb16db, 0xbff85b2eb0308c6f,
    0x3ffad82f799ea148, 0xbfec3780b5999d99,
    0x400dfb69589916f2, 0xc0000cd3817075fb,
    0xbfeca086678a6300, 0xbfe9c55c31a0ed61,
    0xbfe2187218fa9320, 0x3ffa55c2327a3083,
    0xbffc3f45bf0748e0, 0xc0123e133682a379,
    0x3ff523d29395f27e, 0xc0065d441f1be445,
    0xbfe0cc4f2476d110, 0x3ffd97bd4a2dfc62,
    0xbffbc3ae8e7b7bea, 0xc00b1cf5c807cfaa,
    0xbf6fdf4032bbac00, 0xc00c1ce1d0fdf05e,
    0x3ff083f049ef1c9e, 0xc008bd642fa23cb0,
    0xbff608fc4c6406e5, 0xbfec0bb7435058fa,
    0xbffb9d4c7d60ce1f, 0x4007589a4946fd61,
    0x3ff7dd4803c56312, 0xbffbba64bcf774b4,
    0xbfe7363d51745eed, 0xbfefa4647e66d856,
    0x3fc6a1818317df78, 0x400273180e834c6c,
    0xbfd82236d36fbe18, 0xbfe6232b72d00ce0,
    0xbfd0a20cd8ea2564, 0x3fe9d239d9a93e31,
    0x3ff22ad7e401f42f, 0x3fe8b75290be4a34,
    0xc0081a793cb7bca5, 0x3fc1591455b21b94,
    0x3fea118833dcd13e, 0xbff11e92c1f517d9,
    0x3fc40d54d3c4b428, 0x3fcc9b85c6cbdd88,
    0xbfd13c39d762aedd, 0x3fdf38f3d324e5d0,
    0xbfe342f67a0a0d08, 0x3fd6207af8f1d60a,
    0x4000cbdcd4b12048, 0x3fdf62a85db39260,
    0x3ff6d1a30a02f073, 0x3ffb1d167d37faa8,
    0x3fb144e095435b30, 0xc00cf66e34e9295c,
    0xbff1ec83bdebbe45, 0x3ff562f6e97c77bd,
    0xbfe69442e598d797, 0x400486559e86a2a4,
    0x3ff08ec91b50efce, 0x40120dc1b740c892,
    0xc00d8c390c002472, 0xc004aeff8f9fff7a,
    0x400cdd1ede650d1a, 0x3fabebb026495b60,
    0xc00e56bac7d69a13, 0x3fd4171b09c19c16,
    0x3ff66c37815df4a0, 0xbfff90916bc7098d,
    0x3ff400de55896315, 0x4002c65254dc51ad,
    0x4007b655d0aadf2f, 0x4000ed219fdc0a64,
    0x400224b054eb3727, 0xbffd92099aaf834c,
    0xbfff8422722e6800, 0x3fe2369c7b4c677a,
    0x3fe8bcfefe5aba5c, 0x40103706e77bc2cd,
    0xc00719c60722bd48, 0xc00e3287c6ffc3d5,
    0xbfdee94a6dadc1cc, 0x3f870db00cad4d80,
    0x4007242ae9b25567, 0x4009b28528ca9e72,
    0xc000eef9a66515bd, 0xc0052077f68ff53e,
    0xbff0f3fc27e06013, 0x4001622dcba8f302,
    0x3fe58a426a8a98a4, 0xbfe5456bb52331ab,
    0xbff183662a798f7c, 0xbfed8680f250163f,
    0xc004cfcb0627f662, 0x3fd6398b090065b8,
    0x3ff173501ac080f7, 0x400639cda01dd086,
    0xbff2d73cff311538, 0xbfeac7104a2ad206,
    0xbff0ac9f38235d11, 0x401834051d4ed688,
    0x4011fc33e6a6a2e6, 0x40071960c5ab9aaf,
    0xbff982c57c7e4a9d, 0x4008da1a7c8fcec3,
    0x3fe1dedc703e7302, 0x3fe3fa8613710c13,
    0x3fdf48b62da94eb4, 0x3fff36a16ad41bf6,
    0x3f8f459104f35100, 0xbfee77336aa21b79,
    0xbff035b7f8ea8392, 0x3ffeca031c4d7031,
    0x3fc709755dde54a8, 0xbfe36ccedba0e5a2,
    0xbff678fa9746f1e4, 0xc000166c3489e6f1,
    0x3ff800220c054ec8, 0xbfe94093bb8e215a,
    0x3ff72893461d449e, 0x3fdf2cf08345c6a0,
    0xc013e8556a5ee6fa, 0x3fecc4b6e72b6603,
    0x3fda8cd3d565b080, 0x3ff03d0a999f91b0,
    0x4003499688667ca9, 0x400368870235660e,
    0x400822101fde8102, 0x3ff74e0596f72d35,
    0x4013cc000f0b1d8a, 0x3feca985a6a30fea,
    0xbfbea79394ca83a0, 0xbfe87c2a16f0e1dc,
    0x4010817a9f2b2b7d, 0xc0156ff654e7f370,
    0xc008b6df398bf7da, 0xbff5996e397a0b8a,
    0x40035ec2788831ea, 0x4002819f10ce2c4f,
    0xc00b5dfff09c39ad, 0xbfe43dd5ce56f6c6,
    0xc00dbbe77daf8770, 0x40031456dc26383c,
    0x3fddb095f4af408d, 0x3fd0e9c1a960b72e,
    0xbfdef32a9034c20c, 0xc004006482be7011,
    0xbfcc476f38077b38, 0x3fe097d305a20b38,
    0x4011b5bb61c6b4c4, 0xbfff3b1be795239d,
    0x3fcd57646051c0d0, 0x3fe414e275ecfa1a,
    0xc00484b5e4f413f9, 0xc0034b94b14bf7cb,
    0x3fa679e8155ce920, 0x400cfa1180bfad6a,
    0xc0102062556f58e8, 0x40157b758a983552,
    0xc009c723eaa0e11d, 0x3ffb62a5050ed19c,
    0xbff9582fa97896a4, 0x40125ad1a78feeb6,
    0x3fd8809700cced8e, 0x3ffdc95bb46e9b3f,
    0xbff93bf12bc9e45e, 0xbff93605e8675950,
    0x400bf61bfb46a70c, 0xc00818f1cdf0929e,
    0x4006a8c9a484de39, 0xbff02fe730d4a199,
    0x3ffe3e6c7a7793dc, 0x4006b922fbe6f359,
    0xbfc21e88ae7e7514, 0x40126e0ecbfa0ddf,
    0xc0009b01f57b270a, 0xbfe95f01df64c11f,
    0x4011427a8dfe949c, 0xc003f022b7351e8e,
    0x4000388ce014e17b, 0x3fd90c0a7e924124,
    0xbfe46ba8901057bb, 0x3ff34e3b9341aefa,
    0x3ff20d06c3896226, 0xc0021b26bbd67eab,
    0x3ff0c5f505e7671b, 0x40076b64284168a8,
    0x4015e927b3f0ba8a, 0x3ff677f630d4dbe4,
    0xbff826a51d67111d, 0xbfe91756f2530415,
    0x4010b7f9de7d9506, 0x3fdf4c35ec8bac04,
    0x3ffbeb92683fd8ae, 0xbff4291e12f241e1,
    0xbfd8ef81b35bfe26, 0xbff9ca9aa81e0b50,
    0x3fd623aead1eae6c, 0x3fecfe3ab93e37fb,
    0xbfd9d70776b4a0f0, 0xc01383fbd0f7467d,
    0xbfe6729781524f0f, 0x3fe52a1380aecbb5,
    0xbffc934ed3bab51a, 0xbfc4958109a28d6c,
    0x4006cd9f013aa8e0, 0x3fec7d4613c2f2e0,
    0xbffcac84c313d31e, 0x4000ce9f6f79ea9f,
    0xc00e0441d4879f2a, 0x3fb46ef496472830,
    0xbffb934501bf09cd, 0x3fd116142dc03a6c,
    0xbfd366555c27859c, 0x3fe1bab240ab40ea,
    0xbfdc61af489c6de2, 0xbffc33dc02ad35f2,
    0x3fdc210029f8df62, 0xc0036fc159a69fe0,
    0xbfd7d2a3b65b8864, 0xc0002dc9e2f9227a,
    0x3ff255ad58e56fa6, 0x3fe811ed7d516eae,
    0x400791a1bbb53dd2, 0xc004c72acfc6904b,
    0xc001a39fb734224f, 0xbfd035d0b9d4b4c2,
    0xc00126e2554f512b, 0x3fbd3dda63f8c980,
    0xc00f5d568cf703eb, 0xbff08162c76441fe,
    0x4001bba9541b5326, 0xbff563f86f6d90b8,
    0xc011c5ff31a9a1d3, 0xbfc9b119adc970b3,
    0x3ff15d20b3fe7070, 0xbfe819aff4369754,
    0x400b348d8c7fe4f3, 0x3fd93c452e6b63b2,
    0xc012982e68e88282, 0x400d0f75d3d333ca,
    0x3ffabef6c6342d6d, 0xbfc0bff2169b3082,
    0x40020d05e4705830, 0xbff92fcd5d844ec4,
    0x400280ef3f6a9e8f, 0x3ffc78f8c4ba1b33,
    0x3fe72afcc0070b86, 0xbfe0a1bd515276da,
    0x3fd5315149984ac6, 0x401554e13d26163a,
    0x3feda66d1eb4a8f6, 0xbfec7183be35ed54,
    0xc00bc8f341a244c8, 0x3fe058c3db166390,
    0x4002ce9cf6cfd8e4, 0x3fdf1fbca2987987,
    0xbfc352ffded7bfdc, 0xbfe7b9a1d300a3bc,
    0xbfec0899a2410528, 0x40037d71aec18bb0,
    0x3fcae9aac1a26b99, 0xc00a4f053b83c7dc,
    0x3ffb03eae1b53f0d, 0xc010cb03425cd07e,
    0xbff92fd6e358ccfc, 0x3fd98059b1f10918,
    0xbfe574e1f2d9774c, 0xc00b6b2000e88ba3,
    0xc004df0b0577b47a, 0xbf48fb87c0f76400,
    0x400b6b23ebc00af4, 0xbfc047735de75a34,
    0x4006c94fd620c5fc, 0x4005f942e16abc48,
    0x40047ff188a56897, 0xbfd1820e386637d0,
    0xbff858c5710d1f12, 0x3ff7618f2ae5a6f6,
    0xc00ab90e421f5e5e, 0x3fe9cdcf63072999,
    0x4004c2b5a1521a00, 0x3ff3bd302fab9b0d,
    0x3fe1b5ab51553b7e, 0x3ff5e360f72a07ac,
    0x3ff2842376f76eca, 0xc01183e3b0a00053,
    0x400f14dd3dca7cb3, 0xbfb8dfe0c779f610,
    0x3fe2c0c39b7863b6, 0xbfe064019990b9a7,
    0xc00294cba63c708e, 0xc0083ca83a7a3a2e,
    0xc00be9c757c7bb54, 0x3ffea2d52c69c02a,
    0x3ffaa8bef32be925, 0xbf95f7efe390a000,
    0x3feceacb574c0308, 0x3ff26666155dc438,
    0x4009f9752bdb4d09, 0xbff08a271e962294,
    0xc008aab299cb852c, 0x40049131fa0cef56,
    0xbff869ed50b54b18, 0x3fcc2a3f21dc0744,
    0xbfc0f6ee7ff844d8, 0x3fe0faa264458114,
    0xc000110e1fd4e6b2, 0xbff68d969e259862,
    0xbff3e4f8b9ce1a82, 0xc016878d200a350e,
    0x3ff9606ba45c09ae, 0xc012836d772febf9,
    0x3feb3a7643cf10e4, 0xc0048039d2220008,
    0xbffee1cb749d237b, 0x4005aec1e1cd840a,
    0xbfeff0defc2921c8, 0xc0001659d6cd68a3,
    0x3ff4bea9f8f13b85, 0x3ff5a371cd96b32c,
    0x40075d3d91768e56, 0x400318550fdd9744,
    0x4001bae9583e7d22, 0xbff19d4cb434a4a1,
    0x4004593b1995f984, 0xbfd7225f38993bd5,
    0xbfbe247387a57886, 0xbfc40c0d766ebae0,
    0x3ff22fd5c204f202, 0xc0042aa636d865d0,
    0xbff4523da2d4c9f0, 0x4000b36d4042cf38,
    0x400e553d7f3f91c7, 0xc000c3469ff8d73f,
    0x3fe28de89ad6c9f2, 0x4000feb1261220d0,
    0xbff06764630b728e, 0xbfafbba36d7b4570,
    0x4005414c074301ac, 0xbfec0f603a94d304,
    0x3ff447c72bd077ac, 0xbfea4d671abf7662,
    0xbff5bb7d88a445dc, 0x3fced7aed8cdc403,
    0x3ff93371365b2d02, 0x400575309f19e415,
    0xbfb1e14ae915d050, 0xc00547c7c3dc301e,
    0x400510d1a5dfd1e3, 0x3fe753aca6d69954,
    0x3fed08c2cf7eb784, 0x3ff7e2c71ab7e888,
    0x3ff052d8d981760a, 0xbff1f448e2ca15c2,
    0x4019231ed2fc713c, 0x3ff5148296d48404,
    0xc0061da214ac5886, 0x4012027413c82d98,
    0xc0070c5df10af412, 0x3fd2e6d71eddcbab,
    0x400eacccf8980afe, 0x3fc2418e6750d366,
    0x3ff08827267e7d94, 0xbfef06740346dc4e,
    0x3ffa9ded8044b880, 0x3fe22c7182e5009f,
    0x3ff0e40b0ecbce62, 0xbffeaa4d179203e6,
    0x3fd5960093844178, 0xbff734708a14c47d,
    0x3ff82178b8e7f2d5, 0xbfe465b26e2bf87a,
    0xbfe129a16799aa09, 0xc00625f546868924,
    0x3feba3f01a663be2, 0x4006e195bf613e58,
    0xbff2f34bc7bd3762, 0x3ff262c269f81466,
    0x40129cc12392126a, 0xc0139511fc0c542d,
    0xc011b48e4e3a3940, 0x3fd0660710be5ce8,
    0xbfe055e391e4d7c6, 0x4001130241dbdeb2,
    0xbfcc577fcffbdff0, 0xc002cabe3a346656,
    0xc008a7998d514fb4, 0xc0051f84c29d70e9,
    0x40123bc50f383b70, 0xbff33c98fa23442c,
    0x3ff264a2637b43c1, 0xbfd09abaf330ac8c,
    0x4009479786511875, 0xc00cd963043d0874,
    0x401a69dc173804b7, 0x40000f1458a7b627,
    0x3ffb37f57e2ab6b9, 0xbfd53a9c88cd6db8,
    0xc0059114308f1c11, 0xbff9b4b8ea433e4c,
    0x400611225a14d1bc, 0xc003b1e63b978641,
    0x40031288a7b3c359, 0x4005fef479bbc106,
    0x3ff9357f9e56e2d0, 0x3fd6760d35899218,
    0xc00d8df153a4cac3, 0x3fd4b75bde076b90,
    0xc01034d1a05cb02e, 0x3fd57f2e7a0d7e81,
    0xbffa6c618e90df34, 0xbff3723fcfd5c8c8,
    0x3ffb816d17ca3036, 0xc003c0cac3179d4b,
    0x3fee69ac37dd590e, 0xbff540f69656c605,
    0x3fc49dfa7714159a, 0x4001eb8e5de7aaa6,
    0xbfb9607c920d5ad8, 0xbfb066e990661be0,
    0xc01693a905b0e396, 0xc002127329772598,
    0x3fe8a9ee51ca2c80, 0x3fe31248f03da32f,
    0x3ff25e8a8ba5fa31, 0xbfdba83df939686c,
    0xc010a627c39e7b24, 0xc00901a1ad440415,
    0xbfea304dc4e40540, 0xbff272a5184762df,
    0xbfc7cb1a314f696c, 0x3ffac1a8bd95794c,
    0x400da2d979639b32, 0xc0038bc40e9e85e6,
    0xbff815c1e08920c4, 0x3ff7869752c82160,
    0x3ff237d9d1078d66, 0xbfa4089d0b78f9c0,
    0xbff5e5bfd8052552, 0xbfe91ec8911f9808,
    0x40063577219fc2bf, 0x3fe1342164dc3477,
    0xc004664a40157c66, 0x4018ca7b2096fffd,
    0x3ff46d06390e1231, 0x3fc4a27ed0369fe0,
    0xbfd6e1366b925838, 0x3fd3d99286ce2880,
    0x3fcf8fd4c15fee8f, 0xbfe58e709bdb5f56,
    0xbfcdbe8b81f9b4fc, 0x3ff9898509e6d35b,
    0xc009c057aac36d9a, 0xc00882f227f06716,
    0xbfea123ea597b67b, 0x3ff4499025ba4726,
    0xbfec987646c8fb1f, 0xbffc942fd8312e5c,
    0x3ff71ae398917142, 0x3ff32f02347e0ea8,
    0x3fe2c423275438e8, 0xbfac3b6b91c80400,
    0x3ff8cd988748ce8d, 0x3fe0cc9e3af81c90,
    0x400a388dc52a9f8d, 0xbff42e53a505090f,
    0x40014b89780d1631, 0xbffbe5290da40ab4,
    0xbff0671192284210, 0x3fc267273b5b24ac,
    0xc0062f6b219a19f7, 0x4005481d21d8e46c,
    0xbfea58f6396bcfe6, 0xc00ad9fa7dbd2e8d,
    0xbfd024c6c3005ced, 0x3f9ac5474b270680,
    0xc00026c3e2c92a2e, 0x4006dc84929cbcfd,
    0xc0037c020efb4a59, 0x3ffebb9ea85ae9dc,
    0x4007c20b510456b8, 0xbfe0e5c9f2ebe839,
    0x3ffd6f7dc5ac3128, 0xc008fa83ffbcb4fc,
    0x3fc2499d18775770, 0x3ff5693724b5d569,
    0x40070caa0edb31d4, 0x3ff5e816f8cfd0a5,
    0x3ff0b273f8396429, 0x3ffbd64bb2241d85,
    0x3ff5f07b6d312c75, 0xbfebde4fdab7e52f,
    0x401118d3e5847ce4, 0x40090c430f3a372e,
    0x3fb9261ab5b09ba0, 0x3fc7660d69944156,
    0x401298eafa175606, 0x3fe8b473e24a467e,
    0x40000a0fed1a2252, 0x3ff816ad1a837ac8,
    0x3fd33a777ec3280a, 0xbff7553babcebcb6,
    0xc0041b317c194862, 0x3feb91457df540eb,
    0xc006d46756131aa8, 0xbff43415d16fcbab,
    0xbfd7cd008031be44, 0xbfd9712fc101ba53,
    0xbff2990972e795e0, 0xbfd036be1bd200b8,
    0xbff8860d470190c3, 0xc0011e573374d0db,
    0x3ff4c9466fec853a, 0x3fe2d396950b7324,
    0x3fe8bcd13559a598, 0xbfeea3532695d38a,
    0xbffa38592f55d17a, 0xc003dadc182b617e,
    0xbfd2c4a96397ded0, 0xbff959c37ea05e14,
    0x3ff1609154f78409, 0x3ff6913b5f54f860,
    0x3ff58843c26351b4, 0x3fe8518d77eadd6c,
    0xc00aa5147880e8b7, 0xc011bd4fc9ed4053,
    0x400a9ae95d8b4ffe, 0xbfc55faf8bb273a1,
    0x3fd47e9e22ddfa15, 0xc0002e6d3ca0651f,
    0xc00c716354ec9a05, 0xbfd786dc7c3f1228,
    0xc001917f5bd88321, 0x401285002311d2b6,
    0xbffd9546ace98fd2, 0xbfeedb1c72d39bd8,
    0xbff28475f51d2f3f, 0x3fde6ded916722c8,
    0x3fe0f5cf8d27692e, 0xbfe3a73ef049d147,
    0xc006d501a8497e5d, 0x401c0c609cd512c4,
    0x3ff3256637c08cdf, 0xc006a6ce0f82c460,
    0x4002278b6281252b, 0xbfe2e14882110576,
    0x400c9ee42b084f29, 0xc0107dc2e6ed0c9c,
    0xbffd613dac38c7d5, 0xbff4e01cf022892b,
    0xbfe69140269c82a6, 0x400151bf49d6eb3c,
    0x4003d3540636c49e, 0xbfebe1efd15c48c5,
    0x40144f446b2b003d, 0xbfc39912daa0f320,
    0xbffaae6df719f124, 0xbfcb5a5e30fa596e,
    0x3fdfdab130432db7, 0xbfe68971cdceefeb,
    0x4012215a791da537, 0x3fe32e6c4bb9d65c,
    0x4017f6916d074ab7, 0x4007a11cea35de0c,
    0xbff87c148a36a2aa, 0x400245cf3ceb6a95,
    0xbffa1015d3ba21e9, 0x4016162a608bca6c,
    0xc010498562ef4461, 0xbfed538b9314cbcc,
    0x3ffa1403eff03924, 0x3ff0b99d50d9a73a,
    0xbff6154af25f7a6b, 0x3feaf3d28ae90d2e,
    0x3feecb30c10076f8, 0x3fe6389673d33f28,
    0xbfdf623b1a099907, 0xbff691ae934a3997,
    0x3fd9f469c0066bf4, 0x4010b857d374fd3d,
    0x40002e564a570422, 0x400c966d43cdf2ce,
    0xc005b124424c5776, 0xbff9bde88d86c55e,
    0xbfdf9824284ae89b, 0x40124edeac3fb0c8,
    0xbff61bae351c9bb4, 0xbfe5dad1754511dd,
    0xc013fd3dc6f226a6, 0xc000d53fc7e1bd9a,
    0x4009b8d3b353731c, 0xbffe37163b2f90e6,
    0xc0111f95a25ae1c2, 0xbff67c04a628d4de,
    0xc0098de5cdaec200, 0xbff42e5f53047e5d,
    0xbffc4138758a75d6, 0x4011c99e3766ed3f,
    0xbfe76d6cbbc58267, 0xbff69fc1f5a7c096,
    0x3ff7e418ce644369, 0x400ebe86992aa676,
    0xbff2025027e424b8, 0x3ff7b00d0cca005e,
    0xbfed34299c2687da, 0xc003f78b10a8b063,
    0x3fd82c8b3268a894, 0xbfc386deaba2ff26,
    0xbfd1f97915507618, 0xbfe7419d872c8de4,
    0x400cd9cc43b22272, 0xbff312a90e6ec812,
    0xc004106356af7a04, 0x3ffd1d58d13c7013,
    0x40019e270aca6521, 0xc00b131ee0dacf40,
    0xbffec1e51337e7e7, 0x400440af36d741dd,
    0xbff63f645d046bd6, 0xbffe8ae10c1e3f07,
    0x3ffed60d32599383, 0x3fb016b489eac3f0,
    0xc005bd17eb2bbcde, 0xc0110d56ede632b9,
    0x3ff21ede8863ec98, 0x40088e55b6a7c9af,
    0x4005463c5df413dd, 0x3fcfc69160be2e00,
    0x3ffe7bfc88801eee, 0xbfe49b1d317a484a,
    0xbff7562da5ab92a1, 0xc00a6e20d8634598,
    0x400121fce0217559, 0x3fed7504921205f2,
    0x40028e9a8f1093b4, 0xbff5e53764371588,
    0x400393dc9123655e, 0xbffc5d563cd0028c,
    0xc00e923f0fc18095, 0x3ff1c0dd464448f8,
    0x40136c3973119be2, 0xc01061e424a970c5,
    0x3fd324713b0d8f80, 0xbfcb5c222bd4257c,
    0x3ff42925712aa693, 0x400683aefcdafb0c,
    0x400e637e78b6bb1d, 0xbfdfa2caed1f9a66,
    0xc00e3d81f9df73e0, 0xc005f76add030a9d,
    0xc01078c3f03c2782, 0x400b12fe3279603a,
    0xc01175c4a66d4f65, 0xc000710291915ab4,
    0xc00064011024d7f6, 0x3fffee3654e221f9,
    0x3fe55223624acb36, 0xbfe979a8dd83cf7a,
    0x3fdf4b61d53787e9, 0x3ff6f887b8508858,
    0x3fb3be8e98466f55, 0x3fd277c76f0a6f3c,
    0xbff2fb7f44413632, 0xbff59c7e716fbd87,
    0xbfff05faf80a9515, 0xbff9f150a6e2c284,
    0xbfe39887c9c82f1f, 0xbff54f7bdff47b40,
    0x4007f7ab927c0e00, 0xbffccaf6801908c5,
    0xbff7074d8ea0de2a, 0xbffe6d781e5f60ca,
    0x3fc59d36eea855de, 0x4013665b915476a7,
    0x3ff1b341d9be0284, 0xbfe3040b346875f6,
    0x3fdb1f780e6f2526, 0xbfe2ae58a1f3d1f7,
    0xbfd01910f15bd7f4, 0xc00ee48871306948,
    0xc00385192420e098, 0xbfe00d3a4717df31,
    0xc00915796aef6f52, 0x3ffa7fbfa5aaf074,
    0x400a59800b66b31e, 0x401b1f41b85aee63,
    0x4006fbc28cf0a958, 0x400328e11f3adbe5,
    0x3fd6b3120f4a488e, 0x3ff4e0460732c136,
    0xbfd36a15a732f847, 0x4009c5071d8b44c9,
    0xbfd18d2a3d7ba862, 0x3fe5e2c0fa5ca861,
    0x3fbef9657b08e6a0, 0xbfedbb677ac8b5c8,
    0xbfd485b348c7ae92, 0xbfc4a22ecce8e540,
    0xbfe9da9628e4cf3e, 0xbfed5453eecc5fea,
    0x4007eb8adbe10fde, 0xbff692102643690c,
    0x4002bb61c9118dc5, 0x40008394a82a65ba,
    0x3ff42a014b20cde7, 0xbfcd6ee6a21de178,
    0xbfd2b415851a975c, 0x3fdfbe233b6941bc,
    0xc00373639f31a014, 0x3ff605da39b6c367,
    0x400408cbdc980eac, 0x3fe9e114f4aa08c8,
    0x3ff7994bc75149a1, 0xbfd8c41e9e21e71c,
    0xbff5a1037edcedee, 0x3fde39459f4cd642,
    0x4001997e96209ee4, 0xc00257e0b9745458,
    0xbfca5a6974fbd7c0, 0x3fe2b3877b40c8f2,
    0xbff90052d1c06282, 0x3fe46dcb2a2c5add,
    0x3fc1f23480c62930, 0x3ff01e3636e7ffdc,
    0x3ff4bf8823901302, 0xbfd30f699d07942a,
    0xc00519b3ede40072, 0xbffa5fa8a14f26c5,
    0x3ff98f470018f442, 0xc0065410aa6b23e5,
    0x400c5c963bbe3797, 0xbff28006a47c98cc,
    0x4000837389848d63, 0x400af2c6ca2cfe60,
    0xbfeeeffa85d6c96e, 0xc007077560cc3fb0,
    0xbff125e06289b1e0, 0x40025b920d64908b,
    0x4010ad56cd22f257, 0xbfe39681ac301a70,
    0xbff1a48743261400, 0x3feeadef178a2e0c,
    0xc00339661c617b5f, 0x3ff2923e8704a200,
    0xbfdc24e18e4f03a0, 0xbffd362a263ddb48,
    0x3ff1a1716a748ef0, 0xbfde02d7d70032a2,
    0xc00062dd84f34017, 0xbff4e5a338a68672,
    0x3fdc7aac73254d91, 0x400240451a5b6a79,
    0x3fea0e75db2cd402, 0x3ffbb2906367358d,
    0xbfed138b2591923e, 0xbfb973aed37dbc08,
    0x40059ebc14ba1869, 0x3fe35d99edacaa7a,
    0xc005909875bf73bf, 0xbff2b26a6283c927,
    0xbfecb1ed9da4c224, 0xc000abc8c51fe8aa,
    0xbff69f93c4e1fbb1, 0x4005b04e73682edc,
    0xbffeaec4f2f7f9a0, 0xbfd0613beb107246,
    0xbfd071c478fe3118, 0x40097a55c791e323,
    0xbfe1d7af853bc0e4, 0x3fc76882e37a6bd2,
    0x3ff60777268c6d93, 0xbfd110e38158ba60,
    0x3fd169b86a0c6a06, 0xc00416fefd2ad3dd,
    0xbfeaf59d06fa2a93, 0x3ff8a07afa0404af,
    0x3fe3432e9d905363, 0x3fca49cc028e5759,
    0x4012f4ffeb6217d7, 0x3ff24c045a001f55,
    0x4003a08e9f696244, 0x3ffb1d377261ea5b,
    0x3fe5ac92051563b7, 0xbfe1357084922bc8,
    0x3fe312f576fab892, 0x3ff9959614eada14,
    0xc0015572ca1d4831, 0xc00f4f4e61018b7a,
    0x40108f1a03d5209c, 0xbfefd89ed53d8b43,
    0xbfc7ba1b2ff76ee4, 0xbfed1bdf195a8c63,
    0xbff4d65b7b025807, 0xbff4275ea0bc0c98,
    0xbfef81be269a22da, 0xbfe3a8472037bcfc,
    0x3ff25ea00584c1c8, 0xbfe0fde5825d2964,
    0xc0002bbe0bb43b18, 0x3ff1c8d7fab1af34,
    0x3fffbe6768e89f2e, 0xbfb3e6a621a5ef1d,
    0x3fe228d02ae45faf, 0x40003ab6e975ae24,
    0x3fb9f001f007aae0, 0xbff4f5269608c6c4,
    0x40117083ead04c83, 0x3ffed49a9fe024b4,
    0xbff6c31e743cdbd2, 0x3feabc6235182ace,
    0x3ff153120f4fda2c, 0xbff442f2f13f7a1b,
    0xbff8ff28179a395c, 0xbfe7240118eec8cb,
    0xbffec8f7bb2ec4be, 0xc0080176387b50dc,
    0x3fed3ed6bc33ba90, 0x4006502776cd6f18,
    0xc00d3969d20037d6, 0xbfef60df3d9b101b,
    0x3feb59a0649c28a8, 0xbfdb3c83d3db408c,
    0x4003ee7e7e97388e, 0x3fc519b8a09a2b38,
    0x3fe8456d6bca762a, 0xbfaef25dd6abee90,
    0xbfec33c722e24e7c, 0xc018cd5fdf80254a,
    0xbfe3ada08108d8d6, 0x3fd1d8b44724fb58,
    0x3ffebd205e3ede37, 0x400b4c88e7e1496e,
    0xbf701365e3a9fbc0, 0x3ff0ed3d181c1b5c,
    0xbfe0852e56d9ca90, 0x4013fd5231bf231d,
    0x4006e6e0a929411a, 0x401306b3ca27fdbd,
    0xbfcaa41e025c8140, 0x3ff935c5d1f789c0,
    0xc0085a530dbb342b, 0xbff8263c97044fe4,
    0xbfd18becbc8b8144, 0xc00bd85bc8bdfa2e,
    0x4006ad3af2bf55bc, 0xc00f4738520d62a2,
    0x3ff3d9601e39b678, 0x3ff43c276ed4b72f,
    0xc007334301602e66, 0xbff90303114f93e5,
    0x40018f17f0695fd1, 0x4001c35f6113ff45,
    0x3fc1c491c9a93ee0, 0x3ffad158907647e4,
    0xc0030f71fe691adf, 0xbff16a76dede27c2,
    0x3fef15f84f583863, 0xc004b676172d2e5e,
    0xbff538e36fa9c461, 0x3fdfef0aecc8f5ac,
    0x3ff7d86f1dc11d38, 0x3ffc6bd77237cc05,
    0x3fd4d57fde904bd0, 0xc00aaf073819eeb6,
    0x3fe8dddcb3f389dc, 0xbfe46eef980cb63a,
    0xbff504d98bf45847, 0x4004db3635026a68,
    0x4005bcd15383c508, 0x3fe8ce6839939b0b,
    0x3ff5fa9526cf1ae0, 0x400d2f2ca3710ebe,
    0x40089b63b77d7d5b, 0x400c330ebfbf6ef0,
    0xbfe953b0c56429c6, 0x4007edf16bc5917e,
    0xc00ac1d4e3224ff9, 0x3fd5c1b0434f2af4,
    0xc00a1bbd55e8e11c, 0x3fe8d7ab61cfabba,
    0xbfe77408f7675f9f, 0xbfbff7f1a2bea290,
    0xc002b104d6f1f166, 0x3ff9ff9d188bf65f,
    0xbffeb78cbc375410, 0x3ff0b58b608b7039,
    0xbfd5923f52c5e1b0, 0x3ff73e9632fff540,
    0x3ff04b650ea8ab7f, 0x400766e084808139,
    0x3fea5eee414344d3, 0x3ff75eec27c3e76c,
    0xbfc2a4f596906730, 0xbff31963f8bac19e,
    0x3ff9e55709eaaf68, 0x3fee70b67e728908,
    0x3ff6104048660eb2, 0xbfe8e527cd1bd8eb,
    0xbfef8f9581a1d648, 0xbffffe6a4bcaace8,
    0xbfff71c434a4be2f, 0x400c16b8f324e7f4,
    0x400f305418009b88, 0xbfd87c9cb097dd18,
    0x3ff94c7f7d2fcb01, 0x3feb5aa3ab954a99,
    0xbfddcff185939426, 0x3fd94f6cb49b16f7,
    0x401899c4d8373c8f, 0xbfe3961b8e1d16d3,
    0xbfe4dd5dbac740ba, 0xbfded89774943452,
    0xc000c2f0bb28b5e9, 0x3f9582c18b3ef520,
    0xc005f40fa0fe6cc3, 0xc0005bc36b7af087,
    0x40188c35030cf893, 0xbff08e414ac09e55,
    0x3ff4c58c1ae450e0, 0x4011e1c6c1c37fc3,
    0x401572578e0119fd, 0x4015c9fff1fd896e,
    0xbfefae6422a04780, 0x3ffd664aa5f8c0bc,
    0xc009426c3b113726, 0xc0138acb2b4b5540,
    0xc006ea15cd7c3bf0, 0x40044c0543335b94,
    0xbfdf73379ab392ab, 0x3fe8f8199800aee8,
    0x3fe6c05b7158db18, 0xbfce2e349e1bafe4,
    0xbff0c9a299b59c45, 0xc0062ae98e15fe55,
    0xbff5f21df474d2fc, 0xbff963c19ef3ac8c,
    0xbff0c2f1d1353a77, 0xbff37ec0b9dad7a8,
    0xbff062493dbd4a16, 0x3fe9e2e9fc972268,
    0xbfff70ae7561e000, 0xc0062eaec04b0331,
    0x40101dc4b6539839, 0xbf9a2fb9237c9280,
    0xbffc0e54301ca17a, 0x3fc466e06b9c3b30,
    0x3fbbfa36d03116a0, 0xbfd971fb45a128be,
    0xc000ef6660a67f9c, 0xbfe41149d4a012cf,
    0x3ffda0c897f7478f, 0xbffd9272765c1f61,
    0xc00037dcdf23d1e3, 0xbfe3bdbbb35fa0d2,
    0xbffd23213fc4cc33, 0xbfdac6d84ebd4bdc,
    0xbfc5667b647c2cc2, 0xbfde70754b71669c,
    0xbff5cdc86f729b6f, 0x3fe545280baf1d00,
    0x3ff0cfd59a68636a, 0x3fd4de8f422cb7f4,
    0x3ff27cde0285a5b9, 0x400529e7e475d0ea,
    0xbff895a6e054219a, 0xc0116709b02028a5,
    0x40157932dfc636f6, 0xc00aa513ec109136,
    0xbff4804023c5f4c4, 0x3fbb4ce8d70c42c8,
    0x3ff9dcb438a88efe, 0xc001de3316da9ca1,
    0x40024e4f6622802c, 0x3ff6ed1e5b3099dc,
    0x3fbad3234960a960, 0x4005d38c728f842c,
    0x40079775d3648d06, 0x400004e3c2508b10,
    0x3fded032a11a6790, 0xbfe8fec59187f65c,
    0x3ff63851515d8f2b, 0x3ff5cd1f6df05f08,
    0xbfe3650e54cb9145, 0x3fe46df2e315729c,
    0x3fca9ed4136c1a9c, 0x3ff67d3896109d9e,
    0xbfd96cda29085382, 0x3ff8222607222104,
    0x3fd6ecf412352b31, 0xc0133a155e0d9f18,
    0x3fa9d62a60ed1900, 0xbfcce44bbbc5b720,
    0xbfffd545b31f8ff1, 0x3fd40ed2831d61b8,
    0xbfdbbaea80808224, 0x3fe3e2ef964511c0,
    0x3fdf69ec1cd6c7b8, 0x400a60ea23f1d1f9,
    0x400a1e1ec3fb749b, 0x4007b1dd8c1bd81c,
    0xbfeb9ae8a62c1628, 0x40042ba497961030,
    0xbfd976d9461480dc, 0xc0026a03e8a80a2a,
    0x4011a9ade1ba5c4a, 0xbff1b285d592b9cf,
    0x400255bbf47e2f32, 0xc001a6f77cc758d6,
    0x4006bec9f33a2372, 0x3fec28deed885ee2,
    0x3fdf0ddfee22e094, 0xbfe83b289f154ccb,
    0xbfe594b2301cc9ca, 0xbfdb650982c18b14,
    0x3ff8c0e96f82f67b, 0x3fd2d650903cc3c0,
    0x3fffc002d0bc09f2, 0x400cc16858413a8c,
    0x40020cfd6dcbd6f3, 0x3f90924a2b1a80a0,
    0xc0012b9556aaea6d, 0x3ff2149918b97c39,
    0x3fe22a838f664310, 0x3fffd66fbdc8dd8b,
    0xc0154e5da924e7fa, 0xc0062404356205fe,
    0xc00185f15dd78274, 0xbfde662a088c6214,
    0x3fe12924d4537700, 0x400380b7318f5c34,
    0x40162700a3d12695, 0x3ff60a2e74c7c608,
    0xc00cce20b85b87d3, 0x401192f2c3754690,
    0x4008c3ad134926e2, 0xbffde0fb93c71861,
    0x3f8c0b4ba145c380, 0xbfdcfba461329040,
    0xc00be4b3a08cc42d, 0xbff3eb3fe6ebfb8e,
    0x4005db2b0765c946, 0xc00d40902d3a1406,
    0xbfe86acd04e9a6a0, 0x3fe1f9bee158d9ce,
    0xc007992270240da6, 0x3ff6e56236b741ac,
    0x3ff89b7e2ac008ce, 0xc001f7fb682804ef,
    0xc00eed9c552f2e39, 0xc003b6ca5a6f4344,
    0xbfe275f9ae16933f, 0x3fd02613fb1f1198,
    0xbffa4109155abb22, 0x3feae9672a1b6cc6,
    0xc0130519534d0a76, 0x400348e752523f9a,
    0xc01065692fa519e4, 0x3fe3546b85503207,
    0xbffc71b1af25fb6a, 0x3ffbc3a1097f88df,
    0xbff27b02f694a4c7, 0xbf8987cc78544a00,
    0x4000fe09ce23e598, 0x4013a471c102561a,
    0xbfdba169ad9df87c, 0xc0037d1f3a77f8c5,
    0x3fd296ada2537eda, 0xbfee66b48c9f63bd,
    0x40101aa4ea471d98, 0x4006efe5fd1bf59a,
    0xbffa9854c1ce7e70, 0x3ff368d36b0b8447,
    0xc002d6cf848e7882, 0xbfee4425d1e9e140,
    0xbfe0770dd849774a, 0x3fd548cca01d5d34,
    0x3feb0571682f9a7a, 0x400757da22f98514,
    0x3fe50bfd0b7522a4, 0xc003a445423dac59,
    0xc00312663afd71b4, 0xbfda18dc0e230468,
    0xc0134528c8599ee8, 0xbfc973a9c65a7440,
    0xbfccfcdc86f57628, 0xbfd81661295040dc,
    0x3ffb14c7a1c88d6d, 0x40126367716c19cd,
    0x400338a644ccdf20, 0xc00073197e4a4a71,
    0xbfed4e5b2e75ca58, 0x3ff825e6f419d9fa,
    0x400ca2f715c9866d, 0x3fd4b9253f59aa19,
    0xbfab44afeeae9000, 0x40076243882388a0,
    0x3feb30e646434cc8, 0xc00c9534fc2460a6,
    0xbff7be3c8a5041d4, 0xc005836994008a4d,
    0xc001ce703d5a670a, 0x3fe0161db0103c22,
    0xbff792fa8aae0eae, 0x3fbdbbc9ab4d1410,
    0x40065940a4038e62, 0xbff7d3caeb6e5364,
    0x4008e077413cb05e, 0x3ff79e21ef268bc1,
    0xbff0bfd371da2539, 0x3fef2989ec71bd82,
    0x3fe864a8cc8c2e2c, 0xbfd69f1cae4a9b00,
    0xc018f62fe44a1a84, 0xbff521008a409759,
    0x3fe9c62780512be6, 0x4006165e3e4500e2,
    0x400770762a6cb84f, 0xbfb0c2026c09775c,
    0xbfd396a87a3a9898, 0x401346188367fa1d,
    0xc00657bddb2963eb, 0x3feb4eb74e7da409,
    0x40122773f7fe5ad3, 0x400f6492de81ac3a,
    0xbff0db70614f447a, 0x40178b494fcf6698,
    0xbfcf4c6f7386daf8, 0xbfbf5a725c7e5510,
    0x400794f61d0329d8, 0x3ffbe68b41fdb5f4,
    0xbfe36080c9af7dda, 0x3fe2c1e0a37a3920,
    0x3ff3b3d892c979fc, 0x3fd68f4d38104320,
    0x3ff95d4b0722549a, 0x400576af6feef700,
    0x4011de0eddb61e74, 0xbffdfd4c04ed8346,
    0x400c2e3c039b041e, 0x3ff752fcd9194d0a,
    0xbffc2a338cd02e48, 0xbfc765fb697d00ce,
    0xbfe992ed22174a0c, 0x40055f6af23d3380,
    0xbfe939dc0fb16d1e, 0x3fd5bdcfc1fdb4f8,
    0xc003be6188e9ba8e, 0xc016f5de9957310d,
    0x3fe600e335c9631d, 0x3faf8fcb64d6a510,
    0x3ff8b7ccf106b36e, 0x400468599360eccd,
    0xbff08f5077485c24, 0xbfb5108a0ac6f474,
    0xbff174d3efc47b73, 0x3ff5864c161898fa,
    0xc00aa1145ee1213e, 0xbffaec1589a38940,
    0xbfe89b31aac912c0, 0x3fd3146a826ea034,
    0x400aef9c3a55acdc, 0xc00d5825b4d9c8d1,
    0x4007fdd456b9bd3e, 0x3fddc2be13c39a46,
    0x3ff3f20848e6b9a5, 0xc010fcb7f9fe3522,
    0xbfe0d488edc4a17f, 0x4003e8b75e18104a,
    0xbff0224af2e35ce4, 0xc0075fc6e7f635c5,
    0x3ffdbf5d5a26e78a, 0xbfe1cb7d9f026042,
    0x40143716fb00a61c, 0xc00eb16ddc2ba211,
    0x3ff94d818e281f78, 0x3fd8dc941ffd92d6,
    0xc014730d9d13813c, 0xbfd60e9520ecb68e,
    0xbffc89cd936f553d, 0x3fdbece0129c3d48,
    0x3fd0bc4459e7eac1, 0xc004c5d70a81b888,
    0xc01295a4525a1e3a, 0xbff4bd3663c8939c,
    0xbffc6b3cf28a8900, 0x3ff1ae1fe8f5ff60,
    0xc00bea7af0a643c9, 0x3fe4a7ac250b9567,
    0xbfcc0e0573c5e628, 0x400cdde5834fd6e6,
    0x3ff393abbb497077, 0x3fe381cd7522eee6,
    0xbff64ecd32e70822, 0xbfef186eacd43f62,
    0xc00d66999b09ced4, 0x3fac30c5e845c990,
    0xc007944659ed5194, 0xbfed18e522bff15e,
    0x40110c75d78f8532, 0x3ffa80d9016c83c8,
    0xc005de68da691e86, 0xbfe892fbc538a5ec,
    0xc0067180e6bf4b15, 0x3fe642e2584cbb6e,
    0x40039f3d770621f4, 0x4008d744bb8b4fe8,
    0xbffb58a42c390c80, 0xbfbda521f733c380,
    0xbfd688daf05f29d8, 0xbfae0b8135289b40,
    0xc009da5adae018a2, 0xbffe285c18cb7078,
    0xbff1796ac9fd28e4, 0x400c66587924f43f,
    0xbff1765fecd58cb0, 0x3fecd950adec0aac,
    0x3fe166a003fdb07c, 0xbffb2bb88378317f,
    0xbfc3533277b7697c, 0xbfca9f0751c22160,
    0xbff39fe61549bc48, 0x400255ed141952ab,
    0x4005c3988a2d7b21, 0x3fe29963a1e13b2d,
    0xbff990b8393fb211, 0x3ff2c64dc37e3bca,
    0xbff05ce4e93e09af, 0xc006106340cbfe33,
    0x3fdbc43c3a613d2c, 0xbff919ab8e2f75b7,
    0x3fe4e429b2304cb6, 0xbffd815fc946195f,
    0x40103be2f1ab432c, 0xbffeb1cba91ae1b4,
    0xbfffb691a1546dca, 0xbfce70ae5eba5750,
    0x3fead5bae46e6d8c, 0xbfdda64d05ec16e8,
    0x40006d26aa5152df, 0xbff9f27b40e4562c,
    0x3ff8b3e0fbb3402a, 0xbfea64d96e84e0ca,
    0xbff202cc35ddd958, 0x4010eab0301fe51c,
    0xbfe7f8192c1734ce, 0x400b1e8795c2b39a,
    0xbfef021a3d238a12, 0x3fda6c473b37681e,
    0x3fe8e12b767bf842, 0x4004b50b0ca7456e,
    0xc00328bf58800cbe, 0xbfc44b75508876d8,
    0x40000b4c451f81ac, 0xc00cfe56683a55fc,
    0x3ff9862231fa10fa, 0xc00512a45624747a,
    0x3fd1678da0819142, 0xc001158cc88c1c25,
    0x3fd61e47885c224c, 0x40001df08db9024e,
    0x400a49089605c3ec, 0xbf894e998a0b2940,
    0x400ce79058d8753a, 0xbfead7e828b89dac,
    0xbfe41f2bcfc974dc, 0x40061be40e90e899,
    0x3ff3e2668f188efe, 0xbfe17cdb36391978,
    0x3fcdcdd293722bf0, 0xbff9dec168428180,
    0x3fbdc88956d5cc30, 0x3fe9544683056c25,
    0x3ffb651a24aee7be, 0x3fe632d918bd75a8,
    0xc00a1779ca7a784b, 0x3fe97f8a480b8076,
    0xbfd376958783c050, 0x3fdf21ab654f1840,
    0xbfebabc24ec613c8, 0x3fdd692adff8b0cc,
    0xc009dbd35f4b6e0f, 0xc0018c766be035a5,
    0x3fee4b372034bc54, 0xbff845d2489f6cd5,
    0x3febc5d5815ee6bc, 0xbfd5e4376cd6e1ba,
    0x400acbfdf015c2c0, 0xbff59afe89a332e7,
    0x3fd2946d24f8e5f8, 0x3fb07c28ccaa38b8,
    0x3ff32637441e7199, 0xc00a131ceb77e349,
    0x40054ac1dd6c465b, 0xbfe2fb4c25538c34,
    0xbff2747a7f961b8c, 0x3fd997af02d89388,
    0xbfdf8564837957b0, 0x40031c0074679830,
    0xbfd86edc5dbc35c4, 0xbffaa1b6504535b1,
    0x4004c5cda57c2f07, 0xbffb2c9059b92478,
    0xbfe6e5abf386038a, 0x4003f6d17c0cf102,
    0xbfeeb12048b9ea1a, 0x4002bf191021dcea,
    0x3feaf8fc0be582e8, 0xbfe6e48bb7714c3c,
    0x40016237af12db64, 0xc007fa7d7f3dd77a,
    0x400349717fe87d1d, 0x3fec210c550dfb00,
    0xbff12fb604398e29, 0xbfe2d4364ba70b0a,
    0x3fface88e040c1e8, 0xbfc0ae716fc79300,
    0xc0060b813742d34d, 0xc002a7204cb355ce,
    0xbfe260f0df22746b, 0x4010d5cb56d18c15,
    0x3ffc882fef25af35, 0xc00123657217b7ce,
    0x3fc917d341baa438, 0xbfe795c803953934,
    0xbffa2026f3be168c, 0xc001574ce77f8663,
    0xbfe947990d0c3380, 0x3fde70558c873270,
    0xbfefd9ecf25ccba0, 0xbfe2bf79f1770870,
    0x40040550cbdb6f8c, 0xbff07168cefb432c,
    0xbfded7ecdf1ee6ea, 0x3ff74532ae241b34,
    0x3fedca8b7e4b5bd5, 0xbfe6f2d1c9548776,
    0xbfd311766fe6d150, 0xc004eaab83edbbbc,
    0xbfee5ab8803eedc2, 0x3fc64be77bacba20,
    0x3fe8f24b8ad04ea7, 0x400cb646811d7ab6,
    0x40030e442dfb3168, 0xbff9c00ac02b064a,
    0xbffa2904f3674813, 0xbff1b2840999ed84,
    0xbfdb0cc3874c73c0, 0x3ff8c586a8cc48e6,
    0xbfe8b4091a09f548, 0x4006ab1bed0e7e0b,
    0xc01060e1c44b601a, 0x3fea3d6342dba2d8,
    0x400e2c66fe4d9e8f, 0xbfbcc0819ec16da0,
    0xbff5bc778b6bad16, 0xbfb0343d3dd92280,
    0xbfeaba8c4ec9472a, 0xbfe30090ea9c47ab,
    0xbfb5ac5c833a22f0, 0xbfe37c4a151fd603,
    0xc00c8333f4cddd6c, 0xbfd40db30a9ca24a,
    0x401181e64d32aa74, 0xbff93c7312e5652b,
    0xc00bb4213cb2aa63, 0x40057cb660f74d26,
    0x3fef5183538f2ad0, 0xbfdfc661ffa5c868,
    0x3fdaaa1bd8f2d9d4, 0xbfe317cd609d2237,
    0xbff78771440f70ba, 0xbff6886d673b8768,
    0xc015fd0d531533c6, 0x3fd1f8d40f75943d,
    0x3ff2adbd350c02f8, 0xbfe125900a8a2eb0,
    0xbff7cd4bec9ea8ec, 0xc00ec1b5fa92f6de,
    0x3ffe642934201840, 0x3ffefff650909755,
    0xbff968f9fe49a278, 0x3fea7bc4cd6b7ede,
    0x3fe0b75863c7fd04, 0x3fcbe82d32f7b15c,
    0xbfe0c6ed6d26f954, 0xbfe68e39a51a3514,
    0xbfeaf1d751433864, 0xc00293c579c9948e,
    0xbfd250321f9550b3, 0x3fe7cf0849df8d13,
    0xbfdf9af9025b93c0, 0x3fc6acdade5eb512,
    0xc0064f230b7fadc8, 0xc0115d46a01d1d1a,
    0x3fece99c0ed66ab6, 0x3ff4727fcb6c723c,
    0xbfef68a5180f81ca, 0x3ff9aef1b9ae3e16,
    0x3fbf1cffd32f8500, 0xc0013ecdedf0ec88,
    0xc000c53ea3c4aeef, 0xc012d389bb96b639,
    0xbfdc51a6386c048c, 0xc0081803d2ebea83,
    0x3ffb0c6697250484, 0xc00caee9e887aee1,
    0xbff6d097a0f4c002, 0x3fd47c73824e60ac,
    0xbfbf71214a21f728, 0x400a2c74fde1060e,
    0x400b67e102d91e5b, 0x3fce826bd81e21b6,
    0x3fe4d856c517efaa, 0x3ffbb0ec27080202,
    0xbfe6acec994b290c, 0x3fff9542df3fe9ed,
    0xbff3dc52cc2da680, 0xbff2152d9a408b55,
    0xc0008bc948fa8c8c, 0x3fef26440743db65,
    0xbffb063c44abd6c1, 0x3fc5fab2deac1800,
    0x3fdc05eb2021890a, 0xbfd3d7226c11e195,
    0x40019165361a30f0, 0x3fd350970049d3f4,
    0x3ffc27e1198bfa9f, 0x3fc1bf1cfe0e3890,
    0x3fdae4d4cdacadac, 0xbfd00e095302d426,
    0x401262adeddb3ae7, 0x3fe461cf1963e898,
    0x40008252fb4f5a50, 0x3fd2860f76260e24,
    0x40054bbe1f605beb, 0x3ff3639cf751b783,
    0x400da94f413a3c7b, 0xbfe28816857a3ced,
    0x3fc6361a2dee0b50, 0x3fe21f5d2df7eca6,
    0x40009def10099b83, 0xc00bfda7f5987d24,
    0xbfd81d75e29c1fc8, 0xc0048870a02984d2,
    0xc00e5b783795204b, 0x3ff6e7c68fa45994,
    0x3fb358aa20ff0b40, 0xbff318c58f762fe3,
    0xc00682dca352b64f, 0x3fda0ff711338611,
    0x3fe69cf70beab82a, 0x3fdf44d450ed7e9c,
    0x3ff9061704b3d73e, 0x3ff850e808cfa60e,
    0x4011082d85876b2b, 0x401314e85ab30c7a,
    0x4011da18d0b5fcf0, 0x4007eb8b749fce46,
    0xbfd7cc6b9fad5ef8, 0xbfff6fc4fde3ad86,
    0x3ff2074cc0b75e95, 0x3ffab004caea7310,
    0xbfb51b9f834a7a90, 0x400d1a2fd738e086,
    0xc0030de93906339d, 0x40031abcd7d3da06,
    0xbfffee5eac70ead2, 0xbff2f5a453028c0c,
    0x3fce86719a7a4648, 0x3fe09722f37856fe,
    0xc009fe74b5d8abef, 0x3feb666c145fbb08,
    0x3ff6a900026ae30f, 0x400917a5cc05f369,
    0xc0103202846078be, 0xbfe39dfd815e6504,
    0xbff39676ef578216, 0x3fe1461fd4149bf6,
    0xbfee583db6cd3174, 0x400a6d9e66c9b03f,
    0xbfe2e911adfc926f, 0xbff40fded65956ac,
    0x3feee6f7c705fc5f, 0xbfefc6bcfeeebd78,
    0xbfd2146b8a02da20, 0x40033ebdca0a448e,
    0xbff8a4a21496d606, 0x40016cc0b28bc970,
    0xc011171537a86e14, 0x3ff68df6849fabeb,
    0xbff243afd818a1f8, 0x4003e9d5ed831f96,
    0xc00ca691007d618d, 0x3fa1683e9a14c8c0,
    0xc007507c9712cef0, 0x3fca874d590ed410,
    0x4002f7b904de5d5a, 0x3fff9acad6fe632f,
    0xbff8c0f0e5489f06, 0x4016c872b1a26b32,
    0xbfe3ad6caa276047, 0x3ff394a8cb2107fc,
    0x4008fe106c07abce, 0x3fc276827c20e53c,
    0x3fe4e12d6878a0b2, 0xc00741914c778a08,
    0xbfff26459e1d4f0e, 0xbffdf44c8ce9e53e,
    0xbfe5538c81384f4c, 0xbff39655a3793226,
    0x3fcd80e7300dcaf8, 0xc00b533e8c6b4d9e,
    0xc01a0936793f9e64, 0xbffefc0f68265bde,
    0xc001d3e98ddb1ae5, 0xbffab95ecc57c970,
    0x3ff7d1bf43c7fa04, 0x3ff59b5ef83d85b0,
    0xc00417c262f7257a, 0x3fed14cf371a9e9e,
    0xbff0cfc3c33ccbd4, 0xc010a5ef8cb3a4b4,
    0xbff550a08a813158, 0xbffb3e53f4042eca,
    0xbfe58276e5705ff2, 0xc009a09365448dcf,
    0x3feb21cce8969b79, 0x3fefb8c61af73864,
    0x3ff70e65bdee4ae9, 0xc00efd2abd098028,
    0xc004d33a5f481304, 0x400adcff342bad22,
    0x40123d762575a99e, 0xc011f9b261e959ce,
    0x3fd502b0a43b07df, 0x3ff0e057ac044266,
    0x3ff58395d27c712d, 0x4006b549d72c2bdc,
    0xc0010187ad3aa7b4, 0x3ffb0fa414ced042,
    0x4003dcd5ab6f9654, 0x400ed4b835b2fc89,
    0x3fd2ea75f1d84a80, 0xc00374168909c467,
    0xc0021ee5b85064df, 0xbfd534c69c347964,
    0x3ff0c46e3662e9e6, 0x40043de481250172,
    0xbff29256518b0c7c, 0x400913d108b88c75,
    0x400b9885edb9b042, 0x3fea3822a7ad822e,
    0xbfb32e34b53ac660, 0xc0005408aeccfcef,
    0xbfc11baac1d41aac, 0xc006657989076336,
    0xc00fe9b18e151e5a, 0xbfe9346a810f5511,
    0xbfc261cc1d161e40, 0x3fe0950408e26113,
    0xbfd5963115cb3554, 0x3ff4447691f4e7e1,
    0x400eafd90f0b272e, 0x3ff25d1cece9fc72,
    0x3ffdf89b172f0152, 0xc001d9f8e2c89962,
    0x400cb410b7e66b08, 0xbfcb6a4804e40470,
    0x3fe3eaf291351834, 0x3fd496262010cf96,
    0xbff3500f3de10ce8, 0x4004802d92079a54,
    0xbffa56d2e59e38fc, 0xbff7367f4ceda442,
    0x400d7f211cbc4cb8, 0xbfbc9d27613cd726,
    0x3fef5e20e84b3019, 0x400e0538d8e43cc6,
    0x3ff61c9cc1d11777, 0x3fe7d064a927c923,
    0x3fbde463809fe610, 0x3fe25d779370542b,
    0x400600f052189149, 0xbfe19a1fdbce5885,
    0xbffd2d118a304179, 0xc0086508303ca470,
    0x400751d958e301f8, 0x3ff5a2f4fa2c1466,
    0x400670f3dfeb08e5, 0x3ff933e9503107ed,
    0xbfb143c414433168, 0x401118087a49d4ac,
    0x3fd98981cf7fdc00, 0x3f8702c4599aa220,
    0x3fdcb9e820ca0334, 0xbfdbe3b3af209755,
    0xbffa8675339ff7fa, 0x4005e07d2b8b236e,
    0xc00bdc62dc84179a, 0x3ffde044f7162cb5,
    0xc00523d737e4620d, 0xc0110833eb79bad0,
    0x4001d4aab36d53b1, 0x401169dcb5c03110,
    0xc00531fe3fa43e83, 0xbff6a389a7a02b96,
    0xc008a8cf5bfaba2f, 0xc003482f50677e96,
    0xbfe374a183d59a35, 0xc006d15585d128e8,
    0x400c6c4357240429, 0xc00387d49255f5a2,
    0xc00308c58a55a3de, 0xc01563001894db7b,
    0x3fe6102868dfd1c4, 0x3ff34b899f2d4515,
    0xbfe659278e2e0b2e, 0xc00a92dbdc237a52,
    0xbfe6469edbfb307e, 0xbfe8a74bb3f00e6c,
    0xbfc129a2648004ae, 0x3fd88d06956f5e26,
    0xbfb00b10cbd0dce8, 0xbff1854f8e97ccc5,
    0xbfd9ec37d8cae054, 0xc0043f3f3c192f2e,
    0x3fe83437fc29cada, 0x3fd77cadd6cfea9c,
    0x3ff1339964cb6efa, 0xbfd48b6fb13142f6,
    0x4013144613bd130d, 0xc0044f73e1277a5a,
    0xc00fa8f0fd6914e6, 0xc00c7350f1534ac7,
    0xc00afc0981fffea7, 0x40117989615baa2d,
    0xbfe5e137acdda46a, 0x4005799661977009,
    0xc014a6ba6697e287, 0x3ff44f6b6085a8b7,
    0x3fec2d982e3c29c2, 0x4008491e36ee9768,
    0xbfdc5fd54fe2a778, 0x4002e2b0780b43af,
    0xc002259ab3dbb5f0, 0x4000a4bfa7f13ad4,
    0xbff11e83df264c24, 0xbff745bf6a320c0d,
    0x400c1d522008c87f, 0x3ff7dd5bafbde318,
    0x4003625494b8588f, 0x40098c5d4b28d248,
    0xbffa62afa933c8ba, 0x3fd79878cb9d74f2,
    0x3ff953286eb7e693, 0x3fff8006318aec56,
    0x3fe3b5de5a0ff2a3, 0xc001e0055895db74,
    0x400721c51ff21a70, 0xbfc8727d32c35590,
    0xbfeba19c4473ee20, 0x3fd7cbbbed6da5a8,
    0x40010178fa15139e, 0x3fbbbcc1015fc7bc,
    0x3ffb6ab37b50e85a, 0x3ff1923049bf88c7,
    0x3ffd818adfd022a4, 0x3ff22aa60f187a66,
    0xbff0306133dfca64, 0xc000acd69eba4886,
    0x3fec586e5cbb6ab1, 0xc004511646b64659,
    0x3fe3b74783275cee, 0xc001e2a80564f1b5,
    0xc016767828a4d965, 0x3ff54946d6b6656e,
    0xbfde7b80685a2c98, 0x3fe92b28f114b45e,
    0xbfe3f0022ab8830c, 0x3ff684cbb3ebcf8f,
    0x4007bd834cf3970e, 0xbfff96f6dd8845cd,
    0xbffceca60d6ea935, 0x400434859193ab18,
    0xc013f41ba46f961f, 0x3fe0a4b82a2d649b,
    0x3ff9b74bd7960936, 0x4016dbec4b44d78e,
    0xc00581b901a72aaf, 0xc00d8827274a9366,
    0xbff61c197c16abe4, 0xbff392fac025b147,
    0x4000c9c4e657e0bf, 0x3ffb3f4d354af6ca,
    0xc00798a1966f5b12, 0x3fa4fe67ba068f80,
    0xc007896d6689aa87, 0x4001b423f5470b47,
    0x400839a5bb0311f4, 0xbfeffd6cc5c136a2,
    0x3fff93a039b67ca6, 0x3fd8c09e3db19240,
    0xbfc03d281c2c51a2, 0xbfe546e10442cc74,
    0x3ffe9cd65d928319, 0x3ff8b83668fcb8c2,
    0x3ff92338b2b0a54b, 0x3ffc514ad5190be3,
    0xbff8fd12893b27b3, 0x3ffc0a082f9a0aad,
    0xbfb83f5c5fcc2e60, 0x3fd9aafe684b15a4,
    0xbff1ce844c4b619a, 0x400496f66757416e,
    0xbfc872cdc116b79c, 0xbff056e0157bb1ad,
    0xc0056ff1ad19a805, 0xbff20fd02882c5c0,
    0x4000734ff8bf32d6, 0x3ff8cab4e9549c84,
    0xbfee814da823d3ed, 0xbfb35e702cacd234,
    0x3fdd57f381d91933, 0xc007dfa494915317,
    0x4006505d21e35911, 0xbfffe109d0f28c5c,
    0xc0048ec26e46a947, 0x40002b5d2cbcdd7e,
    0xbfebe85f0e99ae18, 0x3ffee452886a0348,
    0x3fc4a8ccddeb1120, 0x3fe6c04f6d584616,
    0x3fd6700790e1858e, 0xc01c0da74ec2623c,
    0xbf8934373c573ac0, 0x40052dc67836d274,
    0x3fe7375ea6d6772c, 0xbff2e6daf4eee353,
    0x3fcd299a4269d40c, 0xc005b43bde8d3bee,
    0x3feec745e63a1788, 0x3ff4ddd8c6eece6e,
    0xbfe8d739a40b4c26, 0xbfd86e4d662bd710,
    0x3ff23da231c340ce, 0x3ff7a66eec78b5b0,
    0xc00eb3cc266b2bbd, 0x3fb142e288b133a0,
    0xbff23078eabe1a76, 0x3fb1c0e8ef291a10,
    0xc012333cf3bb4a43, 0x3ffbf4ed8ccf5ef8,
    0x4009b25c8991d869, 0xbff2272a001c7d4a,
    0x3fffb84b9b28c0ff, 0x3ff7aabc5fc3a208,
    0xc01196d22b203ac8, 0x3feba21ef1d5bd2e,
    0x3ff16182948936de, 0x3fe3ab1ae4f48045,
    0xbfeed460b2bf3e48, 0x4000d65ef745d4ad,
    0x3ffc8b2660962286, 0x3fed0d418958cb50,
    0xc00a7b3896c8cb19, 0x400c6a60c793320c,
    0xc00d9fa2757635aa, 0x400ad707f603dff6,
    0x3fc101dd8c78e7f0, 0x4000c78df5a74c18,
    0x4002ade2dfd0cdf7, 0x4010e4da161c874a,
    0x3ff0f89a4dd79670, 0xc0033cfcd114c270,
    0x3ff2ec86aaf8384e, 0x3ff2b4774898010f,
    0xbfd45f7e0e0018e8, 0xbfe73772f0db9948,
    0x3fe96ee06a17c958, 0x400e5e7438de8d43,
    0xbfc9f5b60a9cad48, 0x3feda541640b4545,
    0x3f9b4fdbc95238c0, 0xbfe6c1ee285c9ed6,
    0x40105604da3ee594, 0x4008d5311cd9ed10,
    0x3fe59fd5a7760a60, 0xc006a1237807911a,
    0xbffc84d90adef51d, 0xbfd3b81c8c6a147d,
    0xbfad04bafbf355c0, 0xc00118c34a14a0f6,
    0x4006e9aa969003ff, 0x40007049c39f002c,
    0x401e090415e0badd, 0x3ff4607eb24e4e80,
    0xc011552a0c20b42b, 0xbfa6f5f8f86a72a8,
    0x3ffddbf4872e5536, 0x4008c2e192304098,
    0xbfeb16a191778048, 0x3fc3b15aafac932c,
    0x40026372d81227fa, 0x400294c21316eee9,
    0x400661fde12c1ab4, 0x3fc4f144f07d83e4,
    0xc01093023c99a033, 0xc0101c99650278a4,
    0xc011860f09815a8a, 0x3ffb150f3cbd630f,
    0x400d0c59b58f9058, 0x3fd3803002b3b19c,
    0x3ff8365c46ca2069, 0xbff30b3d6488968f,
    0x4000566e23ea4d23, 0xc000aa6a35ec0cc5,
    0x4002a86611911d30, 0xbfd0003e6cf1ea4c,
    0x400c58ee212f004b, 0xbffb556e8125003c,
    0x3fede08bf4bbc214, 0xbff8101f3a229995,
    0x3ffd467a09d9d9ec, 0x3fef6b73121f9522,
    0x400d0b8356c5081f, 0xbff11c53896d9a7a,
    0x4013fb2dcf5f0f60, 0xbffcdbe1dd1c673f,
    0x4006eb8d9ccdf3ee, 0x3fd3a4f3f97ec88c,
    0xc00bff21476d3974, 0x3fe9e3e818066a83,
    0x3fee6fe6b8497b1e, 0xbfbf066802d1d6b0,
    0xc009287856df0294, 0xbfa0f262371c8240,
    0xbfcd31fa30e2ccb8, 0xbff685a7550e58fb,
    0x3fe6b09afbc82b26, 0xbfc53613bd8c07f8,
    0x400b55be658f63e8, 0x3ff7e64bbe550090,
    0x3ff5777d11bb6568, 0xbfc1d79f293f1734,
    0x3ff3273958941fee, 0x3ff348c133067f33,
    0xbffd8d2b5bbe08cc, 0xc0067df0e9a8f2fd,
    0x3ffb9e7d30602d83, 0x400237d4b9bd6f82,
    0xc00211817c95dee8, 0x40018295b5b82580,
    0xc001136394b40630, 0xbfd0cfec3751849c,
    0xc008e317a4e14d3a, 0x3fe698cce2d5b4c4,
    0x3fde5ec025e3ee88, 0x3fde23a6a8db0244,
    0x3fe47ab4e2a5110a, 0x40052efc21fd236d,
    0xbff0ce197010840e, 0xbfbbe6f7acc5cc90,
    0xc00e662b360eab3a, 0xbff1e5968b67048e,
    0xc0065bd580db9874, 0xbff94de48d0b6054,
    0x400d59ad427039e4, 0xbfe5829266c04a0b,
    0x4001527d74371a89, 0xc0042d53ac71f64a,
    0x3fe140d4ae9ae50a, 0x3ffa16151655b1ab,
    0xbfe27ef639e44f8b, 0xc000b7964f966477,
    0x400a61421f2085ed, 0x4002dcf540616732,
    0xbfb2db941e55fc20, 0xbff9370c77daef60,
    0x3ff04f509ecdec6e, 0x3ff6a4ac85b975be,
    0xbfe3a85bc63a426f, 0x3fa22ba2d5b86160,
    0x3ff15007b8a25685, 0xbfdf0929db334f91,
    0xc001eca93ce0cdde, 0x3ff4eefd98e08fe1,
    0xc00066201c9316f3, 0xbffe0c9b367d0c5c,
    0x40041966ec4e85b2, 0x3fcef9b7d74c55be,
    0x3fc120bc789fc96c, 0xc0163a4cdd756a59,
    0xbfd07c4858d1c3f4, 0x401703d8439beb21,
    0x40012b27d14e0610, 0x3fe195f1565dfd0e,
    0x3ff957c922e64ec6, 0x400b0eccf5550e76,
    0x40099685e7884f73, 0x3ff0511b0e373770,
    0x3fbba373cfcde738, 0xbfc161679ec23d08,
    0x3fd3504e781737b2, 0x3fa57da595021530,
    0xbfcbdb9165cdf03c, 0x400b76e6e8bd9b36,
    0x40011d33fc953e4e, 0x4006b728ba50f61e,
    0x3ffd640bc91e9a40, 0x3fe01a220f847b79,
    0xbfd31c31a8c9eeac, 0x3ff1f05c54642df4,
    0xbff05b7ba06b1ece, 0xc0069fbe9ae6a0d8,
    0x3fb05d6c75fd8370, 0x4001470bf93731a2,
    0x3ff9a0351016ded6, 0x3ff2cdc0a89cb234,
    0xbfc5b98f3a5d6cf8, 0xbfebe8124441853a,
    0xbfefc767d97f271a, 0x400667604c24a2a3,
    0xc011108b07de9cdd, 0x3ffe162a8baa2a39,
    0xbffbb6b9da4dd9fa, 0xbffb4161baddf6e0,
    0xc0066332b37b4778, 0xbff8ccf238ed16e3,
    0xbff0174c258b45a1, 0xc00d0455e32238a0,
    0xbfd9a8207f95626a, 0xbff536d74285d51c,
    0xc003c6cc86421bda, 0xc0068a743c2a96b5,
    0x3ffd0c855979fa44, 0xbfe0914cb8bc1e13,
    0xbff8183808fc2b40, 0xc0020f2a21b1938c,
    0xc00e296a0ad8b308, 0x3fb214f923961318,
    0x40034912b1f8750d, 0x3fa3b40bb4902a80,
    0x4004377fb010481d, 0xbfeffb9154ceae49,
    0x3fe165eca9e20080, 0xbfe551a2112d6a9d,
    0xbff653b7f4258934, 0xc0065c4ce5b23e01,
    0x4002d910697fbe02, 0xbfc6cd2aad6c9590,
    0xbfc794a0b5ae1772, 0xc00b434fcd16b573,
    0x3fe9de47a2f01453, 0x3fad5d90cae9f438,
    0x3ff4d842437b4e3d, 0xbffd47d75b700d4c,
    0x4010222e8844f60d, 0xc00b7b46625663d3,
    0x3ffe4f52dbd4b090, 0xc000c52a12727cfa,
    0xc0098b3911ad6cbe, 0xbff6c15b74babd5a,
    0xbfef23b4715bbbea, 0xbff2c5dff87490cf,
    0x4008cfa5a2068909, 0xc002124495d32c0b,
    0x4003a0fb7b61eb20, 0xbff5381d1b24c6ba,
    0xc005cd8a695904d4, 0x3fe0fadd24adfb54,
    0xbfd6764d47f47d80, 0x3fea2fbfb7cd220c,
    0xbffee82e67e7264a, 0x401306d11bd11afe,
    0xbfdb093056fecd7c, 0xbfee092354729632,
    0x4015a2c336c3883a, 0x3fe77b2324f5234e,
    0x4005d10cc446f801, 0x4011c209e7afa220,
    0x400432ae89401f8e, 0xc00f253e180f6a68,
    0xc001429bc609ceb4, 0xbfa46576d5e9c000,
    0xc00a8623248b29a2, 0xc010a3ce6ef58c16,
    0xbff56e0a207c8fe1, 0x4013f70cdc7ae14d,
    0x4013ab054c100e29, 0x3ff610da0d951166,
    0xc00c11d78d6ddc52, 0x3fe48f44e7d5e61d,
    0xc012002eab11af74, 0xc000d6cc0065b6db,
    0xc00b6d832ab65162, 0xbfe50ab1c449415c,
    0x3ff4bacdcf602e96, 0xbff013ac191b3a90,
    0x3fd7949aa81cf29c, 0x400eb0b630a25b4a,
    0xbfe41095e2c8a47e, 0x3fdc5c8bda9bc0d7,
    0x3fcb2ab26d2f3cb8, 0xbffa9f56ee83e331,
    0x400df03f153d89f6, 0x3ff86c4976717343,
    0x3fd526ba8f4177a4, 0xc0006748be8679e7,
    0xbfbe7afe5c37fd70, 0xbff27a354b00f072,
    0xc0096bada1b8664b, 0x3ff3274feacf3db9,
    0x3f9795243a087c40, 0xbfd10f167c31cdaf,
    0xc000fd7c18b92642, 0xc00874e7b3e9daca,
    0x400a4f88a59c715f, 0xbffac219274bb8a0,
    0x3ff9118f5bf418f7, 0x400c8a5702e09384,
    0xbfecd3eddf162480, 0xbffc707c7f5afed8,
    0x3ff9db21c3751b14, 0x3fd161d137503b0c,
    0xbff7109b27e43f65, 0x4010cacc29e6d7ad,
    0xc007c33255de1298, 0x3fb0a9efba7a6918,
    0xbfed499d2f3f100a, 0xbfd55af2eac0db34,
    0x3ff16c96ddbcbefe, 0x3fab9985ab1d8240,
    0x3fc1d5e6778034b8, 0x3ff588e4a0acaa1e,
    0x3ff1aea34b0e1d22, 0xbfeeb895bf141df6,
    0x3fe280458a26b9bb, 0xc0039e2205bd7e87,
    0x3ff4663021c653be, 0xbff19a911396f6e5,
    0xbff4c8a34e4c9334, 0xbfe5b3d26b3c2208,
    0xc0029db027a5b894, 0x3fd64dcbd159da90,
    0x400b2d0afc4f5379, 0xbfe9c83283c6b9f9,
    0xbffb61974c560aca, 0xc0080ea82e7e39c6,
    0xc00432f721f1d28e, 0xbfe04c6d061c6a68,
    0xbfe2cc352dce3814, 0x401213ca3c5cd8af,
    0xc004239ce7900386, 0xc00d0e474dd63b5e,
    0xbfd2d2b350ddf820, 0x400b55e9b4501b7f,
    0x4009f4f4e662750b, 0xc00cee79aefc20b9,
    0xc0027737e8ba9b86, 0xbff36287d1a5cfb6,
    0x3fffdeb28ce5c9f6, 0x3ffbfd38f5564a74,
    0xbfeaa7014cfa97d2, 0xc000d605aca8bfea,
    0x3fff81515363ec61, 0x3ffdcc83dda6b04c,
    0x3ff7da166dd4564f, 0x4004d6d458b02ebc,
    0xc004487fff564b28, 0x3ff84e8c76f642b5,
    0xc003dac5e6c1b286, 0xbfd84b8b350dfdd4,
    0xc00a67f868fb14a3, 0x40122d9d17904a8d,
    0xbffa7e38d009d4b6, 0xbfd64e2941c3e313,
    0x3ff50d5031bd6f22, 0x3fca849505bb2e10,
    0x3fdefbb9e49a063f, 0xbff6e34bbb8bbf17,
    0x40042b9fa99e3d6e, 0x3fe78194e271a116,
    0x3ff5369b5b936a6e, 0x400f9d997134a371,
    0xc00427a8aef1874a, 0xbfd7d8edbd9f2c24,
    0x40048066c1cb929c, 0xc0017821b6b69388,
    0x40118a8078d17271, 0x3ffd6d73065185d4,
    0xbff2e7aeed1741a3, 0xc0044d646c71937c,
    0x3ffb6c98430879a9, 0xbfaedebb35073c30,
    0xbfff3d9487b568f4, 0x40015734908ca0ec,
    0xbffb0eda8d3f1510, 0x3fea26617f503ca4,
    0x401038c1ea420896, 0xbfc8e74c99276063,
    0x3fcec2d785bf4d66, 0x400fd5ad1d967abc,
    0x4002d7fb5bdbedc2, 0x4000420c869a6742,
    0xbfee3802eeb4bcee, 0xbfdb7304b08984f8,
    0x400b0de45916fc2c, 0x3fd987cfd618be08,
    0x3fb926dc3c2e3c59, 0xc010fc7308a397ff,
    0x3ffdd6a78bc61bb2, 0xbff8f5b1718f102a,
    0x3fe9b2532b4992a3, 0x400148e439112121,
    0x3ffa1b3e54818cf5, 0x3ff582983b52c5b0,
    0x3ff5bdcaeb6a47cc, 0x4010b442c7624d7f,
    0x3fe1eaf713d13658, 0xbff5694cb38b30da,
    0x40010a78cfa19a3c, 0x40044a3acc357d51,
    0xbfd37e8bdeb038dc, 0x400860962e7e0af4,
    0x4016b36fa27b1b4b, 0x3fea5553c8dd47c2,
    0xc00aace67c395bd8, 0xc00b56ee80c9ad5e,
    0xbfd489be1e1be103, 0xc0092c4f25b37e0c,
    0x3fe2f65595c35d9a, 0x4002612ad4320c6c,
    0x40047da7365e8986, 0xbfeabb388ada6fa4,
    0x3f84bf9ef6131680, 0xc009383586563806,
    0xbffafeab0df3b58f, 0xbfea31ccfb2e4764,
    0xc01d48e9ad3e7156, 0xbff54643dfa2333c,
    0x40084b7e2dd80a87, 0xc0049a7342a2e36a,
    0x400f9091771e25dc, 0xbfe835192a500420,
    0x3fd5f05db0dd2c94, 0x3fdec772f7baa960,
    0xbffe0e32d0bc55f8, 0x3ff3692135c7d7d0,
    0xbfd88e8a802d33c4, 0xc012a538b66355a7,
    0x4007038687085b92, 0xbff8ddc6bf88d1cd,
    0xbff38f7edfa481aa, 0x3fea8f7c283095a4,
    0x4000e9200027e4a4, 0x3fdb0d0ebb27da28,
    0xbff35ad8d7fe6523, 0xbfd26d99c223f8a2,
    0x3ff15e588bce7ebc, 0x40022fa9724ab04c,
    0x4010cba72bd1c384, 0x40010ad2b60568e6,
    0xc0018a5f5e2594bc, 0x3fff0869a5b0070c,
    0x400419b74c502462, 0xc00a023ca3f148a1,
    0x3ff34298e275f27f, 0xc002f74bf13a0f6c,
    0x3ff06a9047f172b6, 0xbfed8c94117fa6df,
    0x400977951435fcfa, 0x4013d8d7b2903132,
    0x3fe4773bf90f0544, 0xbfb7ad3456de1c00,
    0x3ff1e038010ae37a, 0x3ffaf4b153277a20,
    0xbff1fd2e4105a7e4, 0x3ff3fe198ef1ef5b,
    0xc00ae5a4bda7791e, 0x3fea67ec92242282,
    0xbffaedb2135d4a7a, 0x3fd08c6588067194,
    0xbfe77712a4d09352, 0x40050b5ec8c91340,
    0x3ff7af922becbce4, 0xbff1bb27a482979f,
    0x3fe117dc992149f6, 0xbffcdedef8db59e5,
    0x3ff57d188ef0fe23, 0xc00c7561d720b75f,
    0xbff19dc04f92d762, 0xbfe4489855da2e7a,
    0x3fd96e6d28ed72df, 0xbff107809d105121,
    0xc00ab1b71a6a8df0, 0xc0099ac8c8a414a7,
    0x3ff8e9bf65022d14, 0xc00306781ffb54e0,
    0x3ff4b81236836e8e, 0xc00ae3360346a727,
    0x3ffb110f41302846, 0xbfcb6541c263fb51,
    0xbfdf9ec6f1104888, 0x3fd6341a46aa05f0,
    0x4011c9cc9aae1371, 0x400313b464ed59c8,
    0xc00aad25b92d8db8, 0xc007fcff04d423e2,
    0x40003519f03b0293, 0xbfec3d817aa69c66,
    0xbfcb254efb962c00, 0x400ff1b3592a8f86,
    0xbff65afa9e04785c, 0xbfe0b0f9d109024b,
    0x400b67ad34f5bb0f, 0x3ff48adf1993c4dd,
    0x3fe0680150182ac7, 0xbfe47859de59bd9e,
    0x4009c306096a13cc, 0xbff6f2ebb72c8aec,
    0x400af04bcbdf21ef, 0xc000b433a60db523,
    0xc00f6f1feedbdf65, 0x3ff861bd55aecfd9,
    0xbff535af1b2536b3, 0xc01381e1460982e8,
    0xbff512eb23f2ae30, 0x4004978e2fce84f6,
    0xbfc3394320d96b3e, 0x4003353f72c4aefb,
    0x3fd7122c039c49ce, 0x3fd8fb71aa725888,
    0x4000a18b56ad43e2, 0xc0054d972a5a9496,
    0x400187ce39bf0c8f, 0x3ffcea352844f772,
    0x4013e4745b788a1a, 0xbff8c2b57468c7a4,
    0xbfd9039db4449ea4, 0xc011131acd7dc2ce,
    0x3fe7ca1aa194a0d0, 0xbff29f65be398c65,
    0x3fb631ac13a03fb8, 0xbff2ac934f6cc16b,
    0xbffec020cd95d6ea, 0xbfc43899c8bc10e8,
    0x400398da5cd7febd, 0xbffe4375b4dd8982,
    0x3ffcf82c10fb3c38, 0x3fefca3b554a050d,
    0x3fdf7954c0f4fbd8, 0x400a5bf096141e51,
    0xbfe3ca0f6b1a6e82, 0x3fecdda9889309b0,
    0x4000ee9689694bc0, 0xbfeb818be1bc587c,
    0x400ce2c92a6bf2c9, 0xbfb2016c9332b690,
    0x3fe0fe2b097ad6ac, 0xbfc3a641222a55b8,
    0x3fc2bcfedae25f8b, 0x400f808ace6289cc,
    0x3f99fd3f98bffde0, 0xbffc2df9c2a7bf86,
    0xbfd364c900278f0a, 0x3fee5f9374c42a22,
    0xc012fbb20ab174f4, 0x4005ee87bb1138d7,
    0x3ff4dac6889e5d5d, 0xc00692b2f81afae0,
    0x4005a8a489318c4e, 0xbfc72184a33550da,
    0x4002490fb4721c78, 0x3fd41695e5b421c6,
    0x40011f18e5cca4ec, 0x3fa4b1a1b0eba668,
    0x3ff756e60d4c754e, 0xbfe1cc2db873404b,
    0x400543939ad4a794, 0xc002597f9d4076f4,
    0x3fa2972675ca0c40, 0xbff00cd7211f8f04,
    0x4009b7ec844d4938, 0x40142d0ec5095cac,
    0xbfcd3ac899124e20, 0x400b527b9dfa8220,
    0x3ff4d630f30203f3, 0x3faad5331093de00,
    0xc00fddd42ce18c42, 0x40038512e681a3b7,
    0x4007fecc7e4c9e66, 0x3fa494cc37a02978,
    0xbfd8a9279980ba60, 0xbfe2d8ddd8793f66,
    0x40011f73f0e3d0ba, 0xbffefbe6e86a067e,
    0x3f7f5d79f8b1e680, 0xc006dd0f5d1da222,
    0xc0036b416398afe6, 0xc005ebe1cf6ca735,
    0xbff61155a88cc242, 0xbfef33677c5cf0ca,
    0x3fcf0e3eb9e4acc4, 0xc0092132a23bf990,
    0x3ff356790581a2b1, 0xc00204fd20341630,
    0xbff21e5aa421ecbe, 0xbff4327f47eb879b,
    0xbff7115c188d374a, 0xc011583efdeb3584,
    0x40118ec212b73b6d, 0xbfe611fe3582bf8c,
    0x4010197c215b4604, 0x401007ea595745a4,
    0xc003df32dcc8ff60, 0xbfff17f94d3467ae,
    0xbfe42a6db5ee42a3, 0xbfdd2cbad64ff064,
    0x3ff92dadaae1d04f, 0x3ffab6470c8a903c,
    0x4002612e68e4e48f, 0xbff8ff6f8ce94810,
    0xbffa382d59caeaf6, 0x3ff594207a1353cc,
    0xbfd58d60d03f7e3e, 0x4010c6eb7b45ee3e,
    0x3ffe1b1a9dc83e89, 0x3ff32360d61721b2,
    0xc008d40e64a4d893, 0xbff727f74d952bc8,
    0x3ffb6f69348794f2, 0xbffff2437ff5dacb,
    0x4007e98e63b140b6, 0x401194a0fa0a2455,
    0xc001308e4c12d5d7, 0xc001bf34e2dba740,
    0xbff462435d6cb086, 0xbfd6461f4016a66d,
    0xc00123c13e5c647e, 0x40047afca5d54580,
    0x4012e5144c2c870f, 0xbfe5cbda5a092988,
    0x3ff36f13f124871e, 0x3fe064bdcfe55941,
    0xbfe06b97866eaeb0, 0x4001dfdf165aebc1,
    0x3fefb090bbbcbbf8, 0x401f9808272a32ec,
    0xbff30eeab734f782, 0x3ff855c84454b1c7,
    0x3fefa2db81d98acc, 0xbff72b8611d00dbb,
    0xc000af06ec14ebb2, 0xbfe21223d0dbeb96,
    0xbffc807c9addea38, 0xbfe8e73796d87946,
    0x400ae9161da16e77, 0x3fb1a66e5c061ba0,
    0xbff3d156a6147b89, 0x4006aecacf38ca15,
    0x3fdafc2b9c0c1180, 0x4011faa7cabfd808,
    0xc008f7bfb0e04b30, 0x400b1c54b908ddda,
    0xc0008c11724fc6f3, 0x3fedd71e959e37f6,
    0x400bef8a2b20297a, 0xbfebdbfdb23a54d2,
    0xbfde2c7dba5a8150, 0xc017698ac4a32346,
    0xc0048816a21bda7a, 0xbfde7a064d854651,
    0xc00e00b6506ab40d, 0x400088b52f2ff715,
    0xc005101c036512cc, 0x3fd7b8464badae50,
    0xc00e6ece20b88461, 0xbfd2d5a53c15f148,
    0xbfedf21d9eece309, 0xc008232a123daf2a,
    0xbfe684380b838234, 0x4008a634d29942be,
    0x3ffb7080ed494294, 0xbfe6ab569a5ba392,
    0xbff784db955ac85c, 0x3ffbd6d55042bd8f,
    0xbffe8fa0c526705e, 0xbfc0444714b294e8,
    0x3fd2954a1257d320, 0xc00a94d87f1a15b6,
    0x3fe5328912e18088, 0x3ffd21017f4ad21c,
    0xc00063f74eeaff39, 0xbfda515e9aee3b88,
    0x3ff8ab55cf50bb36, 0xbff55daaa2a627ca,
    0xc00115cf5ef59435, 0x3fd280c7bb5b2727,
    0xbffb1bd2988fb3fe, 0xbff0bc78509ab8e2,
    0x3fbb52a15fe77b08, 0x4013317b56434feb,
    0xc005ef11836a3f3c, 0xbff2d50b54648498,
    0xc001fd61ff5a501c, 0xbfb82a8897a6bbc0,
    0x400b3743f9ef837f, 0x3fdf7f27485a4100,
    0xc00fb9a909f78524, 0xbfaaafb0e30da9c0,
    0xbffd508129f39c88, 0x3fe73f0fac871850,
    0xc003d84debc0cb90, 0xbff3cffb02b28632,
    0x40094df004c84cdf, 0xbfde3946294431d9,
    0x3fef3b611d1e41da, 0xbffbaa1b2635031d,
    0x4012905ea4876b60, 0xbfff59591e3cf4bd,
    0x3ff6a10a29e36962, 0x40083c8d45da37f6,
    0x40126007958f74e5, 0xbffc96e3dfae26fc,
    0xc00c861f7db45694, 0x40090445fb24bd11,
    0x3ffc1f9476a37c92, 0xbfeba264a36c0e9a,
    0x3ff3b03ba16571c2, 0x3ffd7392b427c6e2,
    0x3fe7e28a43eac37b, 0x4009d67552c4c04e,
    0x3fff2d542a60cbde, 0xbffafac172855bd8,
    0xc001fb4ae4039426, 0x40052bcd69c52e42,
    0x3ff2974ad98ff962, 0xbff5579281b29d64,
    0x3ff0e7571cf31d54, 0x3fbac0d36f1e9c5e,
    0xbfc5f3dd89876ebc, 0xbfe02ddb01d79f04,
    0xbfcaef406d6c6498, 0x3ff3fca7ed4fea2c,
    0x400c3920b97d656d, 0xbff213b542c9bd14,
    0xc0008ce19fb369ac, 0x40028b8eae0f1de0,
    0xc01230cfba3b9878, 0xbff23db3011b1468,
    0x40180c587c0cd14e, 0xbfcee57808c27fc0,
    0xc00ba6ed5841929e, 0x40169bed26288c1d,
    0xc012eadad5f3080a, 0xbfe9c8f00f99f573,
    0xc0102a974abd90aa, 0xbfdc17e5bb23998d,
    0xc0012c386c0dcaa0, 0xbfe0b174cc71be80,
    0x3ffc6ae8c430b8df, 0x3fcf00d9fa581d8c,
    0xbff368a5d0eea316, 0xc008f50a758f61bc,
    0x3ff74cc5864491dc, 0x400ad8c92808ef23,
    0xc0003897641c65a6, 0x3fcb73f4d5aff038,
    0x3fed1cfd553c47ab, 0xbff7e6ff12153890,
    0x3fe4273c4fd8b8eb, 0xc0112ed6531d0c3a,
    0x4007cf6670eb03d2, 0xbff1ca1f297fc486,
    0xc002600442d1b8d7, 0xbfeda232e86eea4d,
    0xc0077ed5bdd2944b, 0xbffee69448422daf,
    0xc0085b9c72ab93e3, 0x3fca7b479334bb6a,
    0x4000fc4626af96a2, 0xbff01a85958e1502,
    0x3ff5106e0d8851e5, 0x3ffa1d098914b0ca,
    0xc003b91717f7b890, 0xbfea7d822e79b628,
    0xbff9ee77d8de7268, 0xbfd8d9b81f685edc,
    0x4003bcfc382f1e8b, 0x4004f828ad777d88,
    0x3fc30ed45d88f788, 0xc01b2bab06549d26,
    0xbfd78ad2970a4c18, 0x4006186005aa98c1,
    0x3ff3c344b0f7d3e0, 0x40083138a095da73,
    0x40085112583b3dc5, 0xc0078d900860ea3e,
    0xc00acfffd876b89f, 0x3ff10ab36c99bc37,
    0x3fff2dd0262b8cc2, 0x400e774dfe0fbdd3,
    0x3ff6d3f7c156e927, 0x40168264883367e2,
    0x3f8aabb634beed40, 0x4014b9dd5d671eca,
    0xc0013d95f24c5125, 0x3fea1da001ee65fe,
    0x4012000dc34e35ea, 0xbff66023e33cd6c0,
    0x3ffd9f4e99267f35, 0x3fdd8c44a6aff98a,
    0xbf98a0da884816d0, 0x3fb7af35436aec40,
    0x3ff7952b45fe2c0c, 0x401065715fcad107,
    0xbffbf9727c44aed0, 0xc00a9fa0ab8c4a2f,
    0xbff2e38396ffa53c, 0x40003358e5ada1a1,
    0x3fc10e2ea696c390, 0x3fec50073c07b108,
    0x400d6a1359a24c42, 0x3ff409e1a0d58218,
    0xbfb4aeb198c65a87, 0xc0095cf7d7473f35,
    0x3ff087dcb51411a2, 0xbff00c544693f631,
    0x4005a52b09e3345a, 0xbff500b116c4a0f3,
    0x3fc7b83265e457c2, 0x400ad61a1ddd9c64,
    0x3fa5775e066a9b8c, 0x3ffdb60064b98858,
    0x3fe47c9882e3ebd3, 0xbfec743d2e1182de,
    0xbfe672d19720b16d, 0xc00122c872ba3efe,
    0xbff2b5fe5e0bd3d8, 0x4004625a307b10d7,
    0xbfee1ce1c2e9351a, 0xc01ae0abcdf7be55,
    0x3ff29747ec9c4ef6, 0x40069003939737dd,
    0xbff9e3e41d9acc3e, 0x3fd8836b052c07cc,
    0xbff6c12dfc7246a4, 0x3fc99bb079656448,
    0x3ffc6b9d191d48c8, 0xbffb19f96a85b7e1,
    0x3fff2008bfbb13b6, 0x3ff8824908f0a68b,
    0x3fec9c76abd83bb7, 0x3fcdc4bd68e92278,
    0xbffbef746a0702c8, 0x3fda3d469af638c2,
    0xc0007db91a6db171, 0xbff585cf9de02f90,
    0xbfb4359d33d08174, 0xbfef06aaecef7501,
    0xbff90ad1cd6abb5a, 0xbfdbc822eb5ed668,
    0x3fe96d51d1d33ee5, 0x3fffad00100c6520,
    0xbffd20c3a8950754, 0x3ff84e57dd126c6d,
    0x400bc137d6675f3a, 0xc0015b26fdb80b03,
    0xbff87cd2000607d4, 0xc000b03c8847210b,
    0x3ff10b492ef3b1e2, 0x3ff0b3aa0b9e175a,
    0x3ff8bf97abfebc01, 0xbfc3aa168f50a2d8,
    0x3fe266d4ed8825a4, 0xbff1d393f2dbf49c,
    0x400d641199eb4c4c, 0xc0002c45e3028671,
    0xbfff3ff08ab75df5, 0x4003a5ca0d5f5ab4,
    0x40113b7bb2a17658, 0x40127943e747412c,
    0xbfffb425daea7674, 0xbffccc19ffd3b796,
    0xc002b4f28bdb22d0, 0xbfd02632915fa0ed,
    0xbfdbfbb2f20b7798, 0xbf9a8919c9331380,
    0x3fb4c9adc85e79ba, 0xbff1020848df84f4,
    0xc004266d8e19527c, 0x3fe2ea69184f8a50,
    0x3ff2d2d2941cad3a, 0xbff98747f2edbbbe,
    0x3fc7145b2b0a0730, 0xbfea7b18f0d8f6b5,
    0xbff41ffa40911892, 0xc010e432741df9be,
    0x3fe35b43c0d05348, 0x3ff71322df012375,
    0x3fb70d4662184900, 0x4007c787040cc264,
    0xc000c051beba96c4, 0x4007232a07e07fb6,
    0xbfd2eef07a628830, 0x3fdb82d28179c614,
    0xbfe1d0c7adfd387c, 0xbff45e18dcfa9f7c,
    0xbfc1004aba04d4f0, 0x3ffae1e237dd4b3f,
    0x40174dfaec9d1ac9, 0xbfe6c5ddc90eca34,
    0x40137f984efe2b5a, 0x400e8c4503c8e041,
    0x3fed972d046713d4, 0xbff8bf1585869108,
    0x40012a0c09c69ac1, 0xbff12116ef38409e,
    0xc000a8e3d5e9fad9, 0x40061f9d00f4ebc7,
    0x3fd56e8baa85f42c, 0xbff1dbc8bcdc8a87,
    0x40016bf7a288fdf3, 0x400131e9d0d2952f,
    0x3febd24f4e1af312, 0xc01cc57a0ac93ec7,
    0x400e22dbeb02dca7, 0xbfeea4fb5de5327e,
    0xbfe223ee1b5c3710, 0x3fed2521b0f3ee73,
    0xbffbb182d997cb76, 0x3ffe767d92f91b6c,
    0x3feb60d700932a26, 0xbfe36f299d5a9ae0,
    0x4004a0116402fed8, 0xbff30b137780e846,
    0xbfebfe1dca2058cc, 0xc00711183ad3fdce,
    0xc000266d6be99595, 0x400066e23d5808e5,
    0xbffac4cfec866110, 0xbfe3be9c46fa04d4,
    0x4004c2b17b42549e, 0xc009ee8a09c232e6,
    0xbfe03c69a7c10188, 0xbffaa18ac64deb79,
    0x3ff18402c06d8623, 0xc007a3ba83fbe9f9,
    0x3ff1a7458ce7f842, 0xc01481855824fd7f,
    0x3fdc247b43daac38, 0xc015ce752741dafb,
    0xbfd9fee72e440ea5, 0xbfd5de169236e698,
    0x3ff1e6e485f4145c, 0x3fdd1de7c6616392,
    0x3fe25ba48a61e2a0, 0xc0025e99f06f0802,
    0x3ff5f78fd9b17a11, 0x400054ad759f0416,
    0x4012f44eaa812032, 0xbffe96166e0cc4f8,
    0xc011d6e2f2e65f06, 0xbfbacfa2b52406e0,
    0x3fe8672fdc8bddf4, 0xc002d7265dc6cd96,
    0x3ffd5ac519204c16, 0xbfe2ea154bf18550,
    0xbff41ef71f3e05b7, 0x3ffabb9bc578981c,
    0xbfe17da59c706396, 0xbfcc8b5cae6b0478,
    0x3ff84fdf1775f58a, 0x3ff4532fa5e95ada,
    0x3ff3f3f354e256fc, 0x40159c4dca2af7e2,
    0x3fc9b54e123e1678, 0xc005c652e742bf74,
    0x3fe62bf1827485ac, 0xbfdebdc028d5ab26,
    0x3fd0aa8cb9c490e2, 0x3fe3b9da5fe07e67,
    0x3fda0474a438a6b8, 0x3fc78ef9f1ef4f60,
    0xbfc6206969ed7ebc, 0xbfb7c1219adb6580,
    0x3fdc6606c648bb18, 0xbffb9ee32212dfba,
    0x3ff05c80ddee9dae, 0x4015a4ab78ebeee2,
    0xc013d5103c5214a7, 0xbff599ef7e0e9f81,
    0xbffa685da43e0a48, 0xbff9bfefcf8d0f54,
    0x3fecf44eb4f88cb9, 0x400fe9b69cdc0093,
    0x4004743bc4d1b740, 0xc0015724171dcdae,
    0xbffbb60df26b3b78, 0xbfdd522251739e84,
    0x40162e012d2560fc, 0xbfe2d404e3df57f6,
    0xc0135cc305394465, 0xbff34f4ad1e359a8,
    0x3ff70e36382607ac, 0xc00764e79d4b8c78,
    0x4011aef90f22f7a1, 0xbff8f0ba7c2297e2,
    0xbfd27154775f11ec, 0xbfe72e38b90471fb,
    0xc00ebe738a9c4dd5, 0x4003be1fdda3cb5e,
    0xbff7e59c32a4957e, 0x4014d8ce63c8b9ba,
    0x4002392461b0a8bd, 0x3fed03e79becd3a8,
    0xbffb8a2fcfcadc31, 0x3fde5dc07f5c6014,
    0xbf9ae1da86fa8c80, 0xc00b49edc4518044,
    0x40161d7cbe46fc1c, 0xbff55a5f6bfe0005,
    0x400817166cb9792e, 0x4008a902958cb592,
    0xc00accfda9d9603d, 0x4005449e855af5e1,
    0xc00106b0aa720a9f, 0x3ff5cc61f6911584,
    0x4001a39f6c7643e9, 0x4003c1b43b69a81e,
    0xc000ba88458d547c, 0x400c93bcb8c69f8f,
    0xbfc0e8462258e3a0, 0xbff30e820772cdd6,
    0xbfd1c9c42d1862bb, 0xbffa5d1a35ba06f4,
    0xbfda58bf1681d4b4, 0xc0014f3dc46091fa,
    0xbfc6028177a2dafc, 0xbfddd7dd8a1c81e4,
    0x3fdc759ad7ef6369, 0xc009c02d327ace0b,
    0x3ffcc2cfe9e77a86, 0xbfeb8f8f3b1011a1,
    0x3f64c2ddfc6ae000, 0xbfdeac4984e851a4,
    0x3ffd0d0c7163f1a2, 0xc011922e9c9b626b,
    0x3fff4fa43c1ed984, 0x40039b6b0c283d8e,
    0x4004a29d8155c8d4, 0xc003d86282319baf,
    0xbff0fc698afa92c3, 0x3fea730775403b42,
    0xbff322d7ecde04ac, 0xbffdb3271127f433,
    0xbff5bdc94e53e4b2, 0xc009e01fb8c1df20,
    0xc0112880188d4c43, 0xc0103fa4b4ddf6f8,
    0xc00614043c617bc2, 0xbfdc9f98523a4f12,
    0x3fdca28eb924556d, 0xbf964eb0dd83e980,
    0xc008bb578971abec, 0xc00db7e2df2d039c,
    0x400109cd38e1d52b, 0xc004d6d9febac514,
    0xc00a4ddfdc2c8daa, 0x40138163f0c14e94,
    0x4013e7937b787e9e, 0x3fd91e81af059298,
    0xbff4c2d2d7ab5156, 0x3fed18d170fb6fd8,
    0x40059d90b2e50e1a, 0xbff454080b627a66,
    0x3fe89e6b06797230, 0x3ff72f0da790d1de,
    0xbff80e013718044a, 0x400cdd31b4259d67,
    0x3fe33977c053dcdd, 0xc01138569c820d9b,
    0xc0082cbe1b9a2d5a, 0x401228790cde1e59,
    0xbfe7a762e3992877, 0xbfeca50aa0a99b7a,
    0xbfe361f5bfef8522, 0xbff91856995cc490,
    0xc005ed5a45536f55, 0xbfeb970fb9ef33b7,
    0x400ae92fb6c6fca2, 0xc00e50440f505350,
    0xc00e23db28c3fb66, 0x3fe15dbbe1459d0c,
    0x400332a918a961ea, 0x4007172a011e83b4,
    0xc00168ac9e537e93, 0x40006d476d1c4c84,
    0xbfe21a1b9c4e710a, 0x3ffe22c4b352c8b0,
    0xc01159146f7fa9aa, 0xbfe2644ebbf6f82a,
    0x3fa547e832f459e0, 0xbffb65f16a1c7bde,
    0x400a9267df658892, 0xbfe4a5e0a08a57d9,
    0x4006225ce6412d2c, 0x4002069e80a86c6d,
    0x400066a0c5ae6327, 0x40055947eef50395,
    0x4001cc1bc111cab6, 0xbf765a841d4d3a40,
    0x400f0a0c17448c4f, 0xbff1f143bada4612,
    0xbf83f11b135c2b00, 0x4000d46d9a698814,
    0xbffc06de096f2d08, 0xc00491ffbe379d54,
    0xbff4323e157605f9, 0xbff385bc0175dfab,
    0xbfe3864f624e604b, 0xbfdd24ff0971f398,
    0xc010bf6329e9ea1c, 0x3ff3ea5aacd2485b,
    0x3fd78051364f4c0e, 0x40087c0ac34de271,
    0xc00738f361a7b06a, 0x3ff741611b1c6e9a,
    0x3ff3ff582231621c, 0xc0092919f10a2a0e,
    0xbff2cff778a1fa0d, 0xbff85f2baffdf776,
    0x3ff748ab728ab6fc, 0x3fed6e2a011ffd60,
    0xc0010c8eaf733bc7, 0x4004b8415f46044c,
    0x4001e8f340b46627, 0x3ffc668ac735ef26,
    0xbfea72509358be5c, 0xc0008db86fbbe492,
    0xbff963cbd990ffdc, 0x4003ffb6c1eb6d44,
    0xbfec34691fedd7a6, 0xbff37c918c7a29f5,
    0xc002c1d08ea60de4, 0x3fe69b6bc5d375ed,
    0xc001ef5f783c8334, 0xbfed80b689aebba9,
    0xbfc02ff7186e5092, 0x3fd8881b6d61dc26,
    0xbff16abc70a1e684, 0xbff80b2af98d0c1d,
    0xc00a75c1d108a00a, 0x3febdfa2aee9803a,
    0x3fe9d05e5f2a6a2c, 0xbff709e3f64c3e28,
    0x3fe2fe36a9961b17, 0x4003c8d638f0f602,
    0xc002a21fd09bc41e, 0xbff05bfe880c6b8c,
    0xc009d9aef29ca638, 0xbff6098ef407f362,
    0x3ff455350cb3cccf, 0xbffd69a2a56e9dd7,
    0xc00397d50fdf8952, 0x3fbbd8e952377008,
    0xbfe834d355e8130b, 0x3fe3d1001a719226,
    0xbff3bd20644671fb, 0xbffac520c3c33d62,
    0x3fff5a9ce4892384, 0xbffee81b810e864e,
    0x3fcd96d629b7e0f4, 0xbff522d47b0f4c71,
    0xbff9bb7ea1db3b6c, 0x3ffdb50635ba8373,
    0xc002db767b60912d, 0x3ff16f7629c4335f,
    0xc007db577facafc8, 0xbfd9ede441c7fa90,
    0xc006a2557b24f32c, 0x3fd7f726c4540e24,
    0xbff8b724d0d5be80, 0xc00f77d6336143ab,
    0xc010ceaf17b5ac21, 0x400156acf7423776,
    0xc004771aab0da654, 0x3fd6d7a08a22d962,
    0x400428b00097dea5, 0x40041dcab8d5f777,
    0x3fd6f6c74665cded, 0x400542f1a13aabe0,
    0xbfdab2b62f3df97f, 0xbfd0b00393945578,
    0xc010b5fdced6021a, 0xc011aead2f8f5099,
    0x4000f02c9ef737fd, 0x3ffef8a5266a3a5b,
    0x3fea432d1e7183eb, 0x4002421f0b8253aa,
    0xc007eec44241512b, 0x3fe89bee22e7acf0,
    0xbff6666b60241797, 0xbfe21a8f560eb766,
    0xbfa1eff8a66bdae8, 0xc003f84677cc6f2b,
    0xbff5c98ba4eb35f2, 0xc00a8c9c1fe615af,
    0xbfc38d2fe1cfb348, 0x3fe5d0087ce64856,
    0x3fde90827e8ee9d8, 0x400e9f39e40257e5,
    0x400163cd19a48bf3, 0x4011093e4e9e452e,
    0x400003575b420bac, 0x3fbc1ebc61062f30,
    0xbfdec3d856a7415e, 0xbfd3f264ac677b00,
    0xc006658871610df8, 0x3ff4644baab83448,
    0xc009c13848003d06, 0x4000ea838d4b8ce5,
    0xbffbc459b0e0908c, 0xc001b1e9542db4f2,
    0xbfa0a20728b66680, 0xc00456f2978b2042,
    0x3fe61232adb244bc, 0x4016683ebbb77756,
    0xbff7318ad3c9f8a6, 0xc00033a716dbde37,
    0xbfd80b12cdc92418, 0xc00f2acc9d2a7c12,
    0x3fd78e5c6e92ebdc, 0xbfd6e82aba485198,
    0x3ffa63ecd6d2f18c, 0xbff685ca58c2a66d,
    0xc006306b4c0ee4e2, 0x3fe624c41e25446a,
    0xbf7130af20144680, 0x4014969831f8b544,
    0x3f82a930bec88ec0, 0x3fee0b47a9bae784,
    0xbff89d2694104374, 0xbffb30843fb17667,
    0xbfce9eeb2a890cbc, 0x3ffcae15dfd643cb,
    0xc002e1a0049620ca, 0xc007764e6e1c508e,
    0xbff996248f3a5549, 0xbffef961bbb52819,
    0x3fe700914d5cfecf, 0xc0071bc06501d569,
    0x3fb7a49032035120, 0xbfb6a80d17ba3e20,
    0x3fdec8445d6763f8, 0x3ff26ed482775026,
    0xbfb54633098eac10, 0x3ff12cc5c06386bf,
    0x3ff1d8cd0f3e7e82, 0x401267493ab17bf2,
    0xbfed46cda8e2f191, 0xbffa34652d9ac6ae,
    0x3ff3457e86bfea12, 0xbffd770450eedcd8,
    0x3ffa8a3d3bc8556a, 0x4003f9c2ea4b9f41,
    0x400710b79da7f77c, 0xbfc904144584ab22,
    0x3fee16b72c96b290, 0x3ffa7c11ecceb7f9,
    0x400eb339ebfb468e, 0xbff5c54ad1bc9aa1,
    0x3fe473eee7fc0d84, 0x3ff5e07f84c04356,
    0x3fc2c1acad4356b8, 0x3fd6bc128b22e300,
    0xbfe01bacbc167562, 0x3ff12a6f2a1f537c,
    0x3fd986d3622d7e7b, 0xc00c50787285311a,
    0xc004f1f51f73423c, 0x3ff71ba417a732e0,
    0x40122786dca50e16, 0x3fd0ec54547ffd2c,
    0x3fe2374eb842acd3, 0x3ff93e9875890b4a,
    0x40091e337f0bfefd, 0x400238959d3a0b02,
    0x40084c45c68ef61c, 0xc00da19ae38a00ab,
    0x400857c63fdc68dc, 0x400d7d8e6defd238,
    0xbfea47a7272a233e, 0xbfd5b30a9eb32612,
    0x3ff11ad20491e8d8, 0x4001f537205f8220,
    0xc00b93ab6f0b6836, 0xbfdcf4e31713b377,
    0xbfcfbf4373d299e0, 0xbff13b81a18c5d5a,
    0xc004ff036f144a38, 0xbfe67b3c366e5cfb,
    0xbfe63a341ec61e6c, 0xc0033440ed56fe14,
    0x3faa21cd5f9f8ee0, 0xbff8318ae9230a96,
    0xbfc92a9604168f78, 0x0,
    0x3faa21cd5f9f8f40, 0x3ff8318ae9230a98,
    0xbfe63a341ec61e64, 0x40033440ed56fe14,
    0xc004ff036f144a3a, 0x3fe67b3c366e5d00,
    0xbfcfbf4373d299e0, 0x3ff13b81a18c5d58,
    0xc00b93ab6f0b6836, 0x3fdcf4e31713b372,
    0x3ff11ad20491e8dc, 0xc001f537205f821e,
    0xbfea47a7272a233d, 0x3fd5b30a9eb3260c,
    0x400857c63fdc68dc, 0xc00d7d8e6defd239,
    0x40084c45c68ef61d, 0x400da19ae38a00ac,
    0x40091e337f0bfefc, 0xc00238959d3a0b03,
    0x3fe2374eb842acdc, 0xbff93e9875890b47,
    0x40122786dca50e15, 0xbfd0ec54547ffd3a,
    0xc004f1f51f73423e, 0xbff71ba417a732e3,
    0x3fd986d3622d7e82, 0x400c50787285311a,
    0xbfe01bacbc167565, 0xbff12a6f2a1f537d,
    0x3fc2c1acad4356bc, 0xbfd6bc128b22e300,
    0x3fe473eee7fc0d8e, 0xbff5e07f84c04351,
    0x400eb339ebfb468d, 0x3ff5c54ad1bc9aa4,
    0x3fee16b72c96b28c, 0xbffa7c11ecceb7f9,
    0x400710b79da7f77c, 0x3fc904144584ab16,
    0x3ffa8a3d3bc8556d, 0xc003f9c2ea4b9f43,
    0x3ff3457e86bfea14, 0x3ffd770450eedcd8,
    0xbfed46cda8e2f19a, 0x3ffa34652d9ac6ae,
    0x3ff1d8cd0f3e7e81, 0xc01267493ab17bf2,
    0xbfb54633098eac40, 0xbff12cc5c06386bf,
    0x3fdec8445d6763f8, 0xbff26ed482775022,
    0x3fb7a49032035100, 0x3fb6a80d17ba3e80,
    0x3fe700914d5cfec6, 0x40071bc06501d56a,
    0xbff996248f3a5549, 0x3ffef961bbb52816,
    0xc002e1a0049620ca, 0x4007764e6e1c508c,
    0xbfce9eeb2a890cb0, 0xbffcae15dfd643cd,
    0xbff89d2694104375, 0x3ffb30843fb17667,
    0x3f82a930bec88b80, 0xbfee0b47a9bae78a,
    0xbf7130af20144a00, 0xc014969831f8b544,
    0xc006306b4c0ee4de, 0xbfe624c41e254463,
    0x3ffa63ecd6d2f18c, 0x3ff685ca58c2a66e,
    0x3fd78e5c6e92ebd8, 0x3fd6e82aba4851a8,
    0xbfd80b12cdc92404, 0x400f2acc9d2a7c10,
    0xbff7318ad3c9f8aa, 0x400033a716dbde34,
    0x3fe61232adb244bc, 0xc016683ebbb77755,
    0xbfa0a20728b666e0, 0x400456f2978b2040,
    0xbffbc459b0e0908b, 0x4001b1e9542db4f0,
    0xc009c13848003d09, 0xc000ea838d4b8ce4,
    0xc006658871610df7, 0xbff4644baab83446,
    0xbfdec3d856a74148, 0x3fd3f264ac677b00,
    0x400003575b420bac, 0xbfbc1ebc61062f10,
    0x400163cd19a48bf4, 0xc011093e4e9e452e,
    0x3fde90827e8ee9d0, 0xc00e9f39e40257e5,
    0xbfc38d2fe1cfb350, 0xbfe5d0087ce64859,
    0xbff5c98ba4eb35ee, 0x400a8c9c1fe615ae,
    0xbfa1eff8a66bdae8, 0x4003f84677cc6f2c,
    0xbff6666b60241796, 0x3fe21a8f560eb76e,
    0xc007eec44241512b, 0xbfe89bee22e7acec,
    0x3fea432d1e7183e7, 0xc002421f0b8253a8,
    0x4000f02c9ef737fa, 0xbffef8a5266a3a59,
    0xc010b5fdced6021a, 0x4011aead2f8f5098,
    0xbfdab2b62f3df984, 0x3fd0b0039394556a,
    0x3fd6f6c74665cded, 0xc00542f1a13aabe2,
    0x400428b00097dea6, 0xc0041dcab8d5f776,
    0xc004771aab0da654, 0xbfd6d7a08a22d96c,
    0xc010ceaf17b5ac20, 0xc00156acf7423778,
    0xbff8b724d0d5be84, 0x400f77d6336143ac,
    0xc006a2557b24f32a, 0xbfd7f726c4540e2c,
    0xc007db577facafc8, 0x3fd9ede441c7fa94,
    0xc002db767b60912d, 0xbff16f7629c4335c,
    0xbff9bb7ea1db3b68, 0xbffdb50635ba836c,
    0x3fcd96d629b7e104, 0x3ff522d47b0f4c73,
    0x3fff5a9ce4892382, 0x3ffee81b810e864e,
    0xbff3bd20644671f8, 0x3ffac520c3c33d61,
    0xbfe834d355e81308, 0xbfe3d1001a719220,
    0xc00397d50fdf8952, 0xbfbbd8e952377040,
    0x3ff455350cb3ccd2, 0x3ffd69a2a56e9dd6,
    0xc009d9aef29ca639, 0x3ff6098ef407f362,
    0xc002a21fd09bc41a, 0x3ff05bfe880c6b8b,
    0x3fe2fe36a9961b1b, 0xc003c8d638f0f600,
    0x3fe9d05e5f2a6a2e, 0x3ff709e3f64c3e29,
    0xc00a75c1d108a00b, 0xbfebdfa2aee98038,
    0xbff16abc70a1e689, 0x3ff80b2af98d0c22,
    0xbfc02ff7186e50a0, 0xbfd8881b6d61dc1a,
    0xc001ef5f783c8334, 0x3fed80b689aebbac,
    0xc002c1d08ea60de4, 0xbfe69b6bc5d375ea,
    0xbfec34691fedd7a6, 0x3ff37c918c7a29f8,
    0xbff963cbd990ffda, 0xc003ffb6c1eb6d48,
    0xbfea72509358be5b, 0x40008db86fbbe491,
    0x4001e8f340b46627, 0xbffc668ac735ef26,
    0xc0010c8eaf733bc7, 0xc004b8415f46044b,
    0x3ff748ab728ab6fb, 0xbfed6e2a011ffd64,
    0xbff2cff778a1fa0e, 0x3ff85f2baffdf779,
    0x3ff3ff5822316221, 0x40092919f10a2a0f,
    0xc00738f361a7b06a, 0xbff741611b1c6e99,
    0x3fd78051364f4c13, 0xc0087c0ac34de270,
    0xc010bf6329e9ea1c, 0xbff3ea5aacd2485f,
    0xbfe3864f624e6047, 0x3fdd24ff0971f398,
    0xbff4323e157605fa, 0x3ff385bc0175dfac,
    0xbffc06de096f2d08, 0x400491ffbe379d51,
    0xbf83f11b135c2700, 0xc000d46d9a698815,
    0x400f0a0c17448c50, 0x3ff1f143bada4612,
    0x4001cc1bc111cab6, 0x3f765a841d4d3500,
    0x400066a0c5ae6329, 0xc0055947eef50397,
    0x4006225ce6412d2a, 0xc002069e80a86c6f,
    0x400a9267df658892, 0x3fe4a5e0a08a57d6,
    0x3fa547e832f45a20, 0x3ffb65f16a1c7bda,
    0xc01159146f7fa9aa, 0x3fe2644ebbf6f826,
    0xbfe21a1b9c4e7108, 0xbffe22c4b352c8b4,
    0xc00168ac9e537e93, 0xc0006d476d1c4c84,
    0x400332a918a961ea, 0xc007172a011e83b2,
    0xc00e23db28c3fb69, 0xbfe15dbbe1459d0e,
    0x400ae92fb6c6fca4, 0x400e50440f50534f,
    0xc005ed5a45536f56, 0x3feb970fb9ef33ae,
    0xbfe361f5bfef8526, 0x3ff91856995cc488,
    0xbfe7a762e399287a, 0x3feca50aa0a99b78,
    0xc0082cbe1b9a2d59, 0xc01228790cde1e58,
    0x3fe33977c053dcdc, 0x401138569c820d9b,
    0xbff80e013718044f, 0xc00cdd31b4259d65,
    0x3fe89e6b0679722a, 0xbff72f0da790d1e0,
    0x40059d90b2e50e1b, 0x3ff454080b627a66,
    0xbff4c2d2d7ab5158, 0xbfed18d170fb6fd4,
    0x4013e7937b787e9f, 0xbfd91e81af05928e,
    0xc00a4ddfdc2c8da7, 0xc0138163f0c14e94,
    0x400109cd38e1d52b, 0x4004d6d9febac514,
    0xc008bb578971abef, 0x400db7e2df2d039a,
    0x3fdca28eb9245567, 0x3f964eb0dd83eb80,
    0xc00614043c617bc2, 0x3fdc9f98523a4f07,
    0xc0112880188d4c42, 0x40103fa4b4ddf6f8,
    0xbff5bdc94e53e4b1, 0x4009e01fb8c1df1e,
    0xbff322d7ecde04b0, 0x3ffdb3271127f438,
    0xbff0fc698afa92c2, 0xbfea730775403b43,
    0x4004a29d8155c8d4, 0x4003d86282319baf,
    0x3fff4fa43c1ed984, 0xc0039b6b0c283d8c,
    0x3ffd0d0c7163f1a4, 0x4011922e9c9b626b,
    0x3f64c2ddfc6ae400, 0x3fdeac4984e851a6,
    0x3ffcc2cfe9e77a84, 0x3feb8f8f3b1011a0,
    0x3fdc759ad7ef6365, 0x4009c02d327ace09,
    0xbfc6028177a2dae8, 0x3fddd7dd8a1c81e0,
    0xbfda58bf1681d4bf, 0x40014f3dc46091fa,
    0xbfd1c9c42d1862bb, 0x3ffa5d1a35ba06f1,
    0xbfc0e8462258e398, 0x3ff30e820772cdd0,
    0xc000ba88458d547e, 0xc00c93bcb8c69f90,
    0x4001a39f6c7643e9, 0xc003c1b43b69a820,
    0xc00106b0aa720a9e, 0xbff5cc61f6911580,
    0xc00accfda9d9603d, 0xc005449e855af5e0,
    0x400817166cb9792d, 0xc008a902958cb593,
    0x40161d7cbe46fc1d, 0x3ff55a5f6bfe0006,
    0xbf9ae1da86fa8c80, 0x400b49edc4518042,
    0xbffb8a2fcfcadc30, 0xbfde5dc07f5c6014,
    0x4002392461b0a8bf, 0xbfed03e79becd3a2,
    0xbff7e59c32a4957d, 0xc014d8ce63c8b9b9,
    0xc00ebe738a9c4dd2, 0xc003be1fdda3cb5f,
    0xbfd27154775f11e4, 0x3fe72e38b90471fb,
    0x4011aef90f22f7a1, 0x3ff8f0ba7c2297e8,
    0x3ff70e36382607ac, 0x400764e79d4b8c7a,
    0xc0135cc305394464, 0x3ff34f4ad1e359a6,
    0x40162e012d2560fc, 0x3fe2d404e3df57f0,
    0xbffbb60df26b3b74, 0x3fdd522251739e86,
    0x4004743bc4d1b741, 0x40015724171dcdaa,
    0x3fecf44eb4f88cc2, 0xc00fe9b69cdc008f,
    0xbffa685da43e0a47, 0x3ff9bfefcf8d0f51,
    0xc013d5103c5214a7, 0x3ff599ef7e0e9f7e,
    0x3ff05c80ddee9dae, 0xc015a4ab78ebeee3,
    0x3fdc6606c648bb18, 0x3ffb9ee32212dfb6,
    0xbfc6206969ed7ecc, 0x3fb7c1219adb655c,
    0x3fda0474a438a6bc, 0xbfc78ef9f1ef4f51,
    0x3fd0aa8cb9c490de, 0xbfe3b9da5fe07e5c,
    0x3fe62bf1827485af, 0x3fdebdc028d5ab23,
    0x3fc9b54e123e1690, 0x4005c652e742bf73,
    0x3ff3f3f354e256f7, 0xc0159c4dca2af7e0,
    0x3ff84fdf1775f58c, 0xbff4532fa5e95ad9,
    0xbfe17da59c706390, 0x3fcc8b5cae6b047c,
    0xbff41ef71f3e05b6, 0xbffabb9bc578981c,
    0x3ffd5ac519204c16, 0x3fe2ea154bf1854a,
    0x3fe8672fdc8bddf0, 0x4002d7265dc6cd95,
    0xc011d6e2f2e65f06, 0x3fbacfa2b52406c0,
    0x4012f44eaa812030, 0x3ffe96166e0cc4f4,
    0x3ff5f78fd9b17a0b, 0xc00054ad759f0415,
    0x3fe25ba48a61e29d, 0x40025e99f06f0802,
    0x3ff1e6e485f4145c, 0xbfdd1de7c661639c,
    0xbfd9fee72e440ea8, 0x3fd5de169236e694,
    0x3fdc247b43daac24, 0x4015ce752741daf9,
    0x3ff1a7458ce7f842, 0x401481855824fd7e,
    0x3ff18402c06d8624, 0x4007a3ba83fbe9f8,
    0xbfe03c69a7c1017e, 0x3ffaa18ac64deb7c,
    0x4004c2b17b42549f, 0x4009ee8a09c232e5,
    0xbffac4cfec866112, 0x3fe3be9c46fa04cc,
    0xc000266d6be99592, 0xc00066e23d5808e5,
    0xbfebfe1dca2058c4, 0x400711183ad3fdcc,
    0x4004a0116402fed8, 0x3ff30b137780e84a,
    0x3feb60d700932a29, 0x3fe36f299d5a9ae4,
    0xbffbb182d997cb76, 0xbffe767d92f91b6b,
    0xbfe223ee1b5c370c, 0xbfed2521b0f3ee7e,
    0x400e22dbeb02dca6, 0x3feea4fb5de53270,
    0x3febd24f4e1af311, 0x401cc57a0ac93ec5,
    0x40016bf7a288fdf3, 0xc00131e9d0d2952e,
    0x3fd56e8baa85f438, 0x3ff1dbc8bcdc8a8e,
    0xc000a8e3d5e9fad9, 0xc0061f9d00f4ebc8,
    0x40012a0c09c69ac1, 0x3ff12116ef38409e,
    0x3fed972d046713d0, 0x3ff8bf1585869105,
    0x40137f984efe2b5a, 0xc00e8c4503c8e043,
    0x40174dfaec9d1ac8, 0x3fe6c5ddc90eca44,
    0xbfc1004aba04d4ec, 0xbffae1e237dd4b3f,
    0xbfe1d0c7adfd387e, 0x3ff45e18dcfa9f7e,
    0xbfd2eef07a628834, 0xbfdb82d28179c60c,
    0xc000c051beba96c1, 0xc007232a07e07fb6,
    0x3fb70d46621848b0, 0xc007c787040cc266,
    0x3fe35b43c0d05349, 0xbff71322df012372,
    0xbff41ffa40911892, 0x4010e432741df9be,
    0x3fc7145b2b0a0728, 0x3fea7b18f0d8f6b7,
    0x3ff2d2d2941cad3d, 0x3ff98747f2edbbbf,
    0xc004266d8e19527c, 0xbfe2ea69184f8a52,
    0x3fb4c9adc85e7990, 0x3ff1020848df84f8,
    0xbfdbfbb2f20b7784, 0x3f9a8919c9331480,
    0xc002b4f28bdb22d1, 0x3fd02632915fa0d3,
    0xbfffb425daea7674, 0x3ffccc19ffd3b796,
    0x40113b7bb2a17657, 0xc0127943e747412c,
    0xbfff3ff08ab75df9, 0xc003a5ca0d5f5ab4,
    0x400d641199eb4c4b, 0x40002c45e3028670,
    0x3fe266d4ed8825a2, 0x3ff1d393f2dbf499,
    0x3ff8bf97abfebbfd, 0x3fc3aa168f50a2c8,
    0x3ff10b492ef3b1e0, 0xbff0b3aa0b9e1756,
    0xbff87cd2000607d1, 0x4000b03c8847210a,
    0x400bc137d6675f3a, 0x40015b26fdb80b00,
    0xbffd20c3a895074c, 0xbff84e57dd126c6e,
    0x3fe96d51d1d33eea, 0xbfffad00100c6518,
    0xbff90ad1cd6abb58, 0x3fdbc822eb5ed670,
    0xbfb4359d33d08150, 0x3fef06aaecef7500,
    0xc0007db91a6db16e, 0x3ff585cf9de02f91,
    0xbffbef746a0702ca, 0xbfda3d469af638ce,
    0x3fec9c76abd83bbf, 0xbfcdc4bd68e92288,
    0x3fff2008bfbb13b9, 0xbff8824908f0a68d,
    0x3ffc6b9d191d48c9, 0x3ffb19f96a85b7de,
    0xbff6c12dfc7246a6, 0xbfc99bb079656450,
    0xbff9e3e41d9acc3d, 0xbfd8836b052c07ce,
    0x3ff29747ec9c4ef8, 0xc0069003939737dc,
    0xbfee1ce1c2e9351a, 0x401ae0abcdf7be54,
    0xbff2b5fe5e0bd3d0, 0xc004625a307b10d6,
    0xbfe672d19720b169, 0x400122c872ba3f00,
    0x3fe47c9882e3ebcc, 0x3fec743d2e1182d8,
    0x3fa5775e066a9b70, 0xbffdb60064b9885c,
    0x3fc7b83265e457d6, 0xc00ad61a1ddd9c66,
    0x4005a52b09e3345a, 0x3ff500b116c4a0f2,
    0x3ff087dcb51411a2, 0x3ff00c544693f632,
    0xbfb4aeb198c65ab4, 0x40095cf7d7473f34,
    0x400d6a1359a24c44, 0xbff409e1a0d58214,
    0x3fc10e2ea696c3c0, 0xbfec50073c07b108,
    0xbff2e38396ffa53a, 0xc0003358e5ada1a2,
    0xbffbf9727c44aece, 0x400a9fa0ab8c4a2b,
    0x3ff7952b45fe2c0b, 0xc01065715fcad108,
    0xbf98a0da884815c0, 0xbfb7af35436aec30,
    0x3ffd9f4e99267f34, 0xbfdd8c44a6aff97c,
    0x4012000dc34e35ec, 0x3ff66023e33cd6c2,
    0xc0013d95f24c5124, 0xbfea1da001ee6600,
    0x3f8aabb634beed60, 0xc014b9dd5d671eca,
    0x3ff6d3f7c156e922, 0xc0168264883367e2,
    0x3fff2dd0262b8cbd, 0xc00e774dfe0fbdd0,
    0xc00acfffd876b8a2, 0xbff10ab36c99bc36,
    0x40085112583b3dc4, 0x40078d900860ea3e,
    0x3ff3c344b0f7d3df, 0xc0083138a095da73,
    0xbfd78ad2970a4c22, 0xc006186005aa98c2,
    0x3fc30ed45d88f780, 0x401b2bab06549d24,
    0x4003bcfc382f1e8a, 0xc004f828ad777d89,
    0xbff9ee77d8de7268, 0x3fd8d9b81f685ed8,
    0xc003b91717f7b88d, 0x3fea7d822e79b628,
    0x3ff5106e0d8851e8, 0xbffa1d098914b0c6,
    0x4000fc4626af96a3, 0x3ff01a85958e14fe,
    0xc0085b9c72ab93e2, 0xbfca7b479334bb68,
    0xc0077ed5bdd2944c, 0x3ffee69448422dae,
    0xc002600442d1b8d8, 0x3feda232e86eea4d,
    0x4007cf6670eb03d1, 0x3ff1ca1f297fc482,
    0x3fe4273c4fd8b8f0, 0x40112ed6531d0c39,
    0x3fed1cfd553c47b0, 0x3ff7e6ff12153890,
    0xc0003897641c65a5, 0xbfcb73f4d5aff044,
    0x3ff74cc5864491d8, 0xc00ad8c92808ef21,
    0xbff368a5d0eea315, 0x4008f50a758f61bc,
    0x3ffc6ae8c430b8dd, 0xbfcf00d9fa581d78,
    0xc0012c386c0dca9f, 0x3fe0b174cc71be94,
    0xc0102a974abd90aa, 0x3fdc17e5bb23998c,
    0xc012eadad5f3080a, 0x3fe9c8f00f99f572,
    0xc00ba6ed5841929c, 0xc0169bed26288c1c,
    0x40180c587c0cd14d, 0x3fcee57808c27fb0,
    0xc01230cfba3b9878, 0x3ff23db3011b146e,
    0xc0008ce19fb369ac, 0xc0028b8eae0f1ddf,
    0x400c3920b97d656e, 0x3ff213b542c9bd14,
    0xbfcaef406d6c64b8, 0xbff3fca7ed4fea29,
    0xbfc5f3dd89876ed0, 0x3fe02ddb01d79efb,
    0x3ff0e7571cf31d53, 0xbfbac0d36f1e9c7a,
    0x3ff2974ad98ff964, 0x3ff5579281b29d63,
    0xc001fb4ae4039425, 0xc0052bcd69c52e42,
    0x3fff2d542a60cbde, 0x3ffafac172855bdb,
    0x3fe7e28a43eac37c, 0xc009d67552c4c04e,
    0x3ff3b03ba16571c2, 0xbffd7392b427c6e4,
    0x3ffc1f9476a37c94, 0x3feba264a36c0e94,
    0xc00c861f7db45696, 0xc0090445fb24bd11,
    0x40126007958f74e4, 0x3ffc96e3dfae2702,
    0x3ff6a10a29e36963, 0xc0083c8d45da37f5,
    0x4012905ea4876b5f, 0x3fff59591e3cf4b8,
    0x3fef3b611d1e41e8, 0x3ffbaa1b26350318,
    0x40094df004c84cdc, 0x3fde3946294431cf,
    0xc003d84debc0cb92, 0x3ff3cffb02b28630,
    0xbffd508129f39c88, 0xbfe73f0fac871852,
    0xc00fb9a909f78526, 0x3faaafb0e30daa00,
    0x400b3743f9ef837f, 0xbfdf7f27485a40fe,
    0xc001fd61ff5a501d, 0x3fb82a8897a6bbe0,
    0xc005ef11836a3f3f, 0x3ff2d50b54648496,
    0x3fbb52a15fe77ad0, 0xc013317b56434fec,
    0xbffb1bd2988fb3fe, 0x3ff0bc78509ab8dc,
    0xc00115cf5ef59433, 0xbfd280c7bb5b2734,
    0x3ff8ab55cf50bb36, 0x3ff55daaa2a627c9,
    0xc00063f74eeaff37, 0x3fda515e9aee3b80,
    0x3fe5328912e1808e, 0xbffd21017f4ad217,
    0x3fd2954a1257d320, 0x400a94d87f1a15b5,
    0xbffe8fa0c5267060, 0x3fc0444714b294e8,
    0xbff784db955ac85e, 0xbffbd6d55042bd8c,
    0x3ffb7080ed494292, 0x3fe6ab569a5ba398,
    0xbfe684380b838232, 0xc008a634d29942be,
    0xbfedf21d9eece30d, 0x4008232a123daf2a,
    0xc00e6ece20b88460, 0x3fd2d5a53c15f140,
    0xc005101c036512ca, 0xbfd7b8464badae50,
    0xc00e00b6506ab40f, 0xc00088b52f2ff716,
    0xc0048816a21bda7a, 0x3fde7a064d854654,
    0xbfde2c7dba5a8150, 0x4017698ac4a32348,
    0x400bef8a2b20297a, 0x3febdbfdb23a54d2,
    0xc0008c11724fc6f2, 0xbfedd71e959e37f4,
    0xc008f7bfb0e04b30, 0xc00b1c54b908ddda,
    0x3fdafc2b9c0c1164, 0xc011faa7cabfd808,
    0xbff3d156a6147b88, 0xc006aecacf38ca14,
    0x400ae9161da16e74, 0xbfb1a66e5c061b78,
    0xbffc807c9addea38, 0x3fe8e73796d87942,
    0xc000af06ec14ebb2, 0x3fe21223d0dbeb9a,
    0x3fefa2db81d98ace, 0x3ff72b8611d00db8,
    0xbff30eeab734f781, 0xbff855c84454b1c8,
    0x3fefb090bbbcbbee, 0xc01f9808272a32ec,
    0xbfe06b97866eaeac, 0xc001dfdf165aebc0,
    0x3ff36f13f124871c, 0xbfe064bdcfe55940,
    0x4012e5144c2c8710, 0x3fe5cbda5a09298a,
    0xc00123c13e5c647e, 0xc0047afca5d54580,
    0xbff462435d6cb086, 0x3fd6461f4016a66c,
    0xc001308e4c12d5d6, 0x4001bf34e2dba742,
    0x4007e98e63b140b7, 0xc01194a0fa0a2454,
    0x3ffb6f69348794f4, 0x3ffff2437ff5dac8,
    0xc008d40e64a4d894, 0x3ff727f74d952bcc,
    0x3ffe1b1a9dc83e83, 0xbff32360d61721b3,
    0xbfd58d60d03f7e3c, 0xc010c6eb7b45ee3e,
    0xbffa382d59caeaf6, 0xbff594207a1353cc,
    0x4002612e68e4e48c, 0x3ff8ff6f8ce9480e,
    0x3ff92dadaae1d04c, 0xbffab6470c8a903f,
    0xbfe42a6db5ee42ac, 0x3fdd2cbad64ff060,
    0xc003df32dcc8ff60, 0x3fff17f94d3467a8,
    0x4010197c215b4605, 0xc01007ea595745a5,
    0x40118ec212b73b6c, 0x3fe611fe3582bf84,
    0xbff7115c188d374c, 0x4011583efdeb3584,
    0xbff21e5aa421ecbf, 0x3ff4327f47eb8796,
    0x3ff356790581a2ae, 0x400204fd20341630,
    0x3fcf0e3eb9e4acc0, 0x40092132a23bf990,
    0xbff61155a88cc240, 0x3fef33677c5cf0d0,
    0xc0036b416398afe5, 0x4005ebe1cf6ca735,
    0x3f7f5d79f8b1e780, 0x4006dd0f5d1da220,
    0x40011f73f0e3d0ba, 0x3ffefbe6e86a067a,
    0xbfd8a9279980ba74, 0x3fe2d8ddd8793f66,
    0x4007fecc7e4c9e64, 0xbfa494cc37a02950,
    0xc00fddd42ce18c42, 0xc0038512e681a3b6,
    0x3ff4d630f30203f7, 0xbfaad5331093de20,
    0xbfcd3ac899124e20, 0xc00b527b9dfa8220,
    0x4009b7ec844d4938, 0xc0142d0ec5095cac,
    0x3fa2972675ca0d00, 0x3ff00cd7211f8f06,
    0x400543939ad4a792, 0x4002597f9d4076f4,
    0x3ff756e60d4c754c, 0x3fe1cc2db873404a,
    0x40011f18e5cca4eb, 0xbfa4b1a1b0eba668,
    0x4002490fb4721c7a, 0xbfd41695e5b421d2,
    0x4005a8a489318c50, 0x3fc72184a33550c4,
    0x3ff4dac6889e5d63, 0x400692b2f81afae3,
    0xc012fbb20ab174f4, 0xc005ee87bb1138d8,
    0xbfd364c900278f1f, 0xbfee5f9374c42a1c,
    0x3f99fd3f98bffd30, 0x3ffc2df9c2a7bf87,
    0x3fc2bcfedae25fa2, 0xc00f808ace6289cb,
    0x3fe0fe2b097ad6ab, 0x3fc3a641222a55c0,
    0x400ce2c92a6bf2cb, 0x3fb2016c9332b6a0,
    0x4000ee9689694bc2, 0x3feb818be1bc5874,
    0xbfe3ca0f6b1a6e7b, 0xbfecdda9889309aa,
    0x3fdf7954c0f4fbe0, 0xc00a5bf096141e52,
    0x3ffcf82c10fb3c3a, 0xbfefca3b554a0506,
    0x400398da5cd7febb, 0x3ffe4375b4dd8984,
    0xbffec020cd95d6e6, 0x3fc43899c8bc10ec,
    0x3fb631ac13a03f90, 0x3ff2ac934f6cc16b,
    0x3fe7ca1aa194a0d1, 0x3ff29f65be398c68,
    0xbfd9039db4449e98, 0x4011131acd7dc2ce,
    0x4013e4745b788a1a, 0x3ff8c2b57468c7a6,
    0x400187ce39bf0c8e, 0xbffcea352844f773,
    0x4000a18b56ad43e4, 0x40054d972a5a9496,
    0x3fd7122c039c49c9, 0xbfd8fb71aa725884,
    0xbfc3394320d96b54, 0xc003353f72c4aefb,
    0xbff512eb23f2ae30, 0xc004978e2fce84f5,
    0xbff535af1b2536b2, 0x401381e1460982e7,
    0xc00f6f1feedbdf61, 0xbff861bd55aecfd9,
    0x400af04bcbdf21ee, 0x4000b433a60db523,
    0x4009c306096a13ce, 0x3ff6f2ebb72c8ae8,
    0x3fe0680150182acf, 0x3fe47859de59bd9c,
    0x400b67ad34f5bb0e, 0xbff48adf1993c4da,
    0xbff65afa9e047855, 0x3fe0b0f9d109024f,
    0xbfcb254efb962be8, 0xc00ff1b3592a8f84,
    0x40003519f03b0294, 0x3fec3d817aa69c62,
    0xc00aad25b92d8db8, 0x4007fcff04d423df,
    0x4011c9cc9aae1370, 0xc00313b464ed59c6,
    0xbfdf9ec6f1104888, 0xbfd6341a46aa05e8,
    0x3ffb110f41302846, 0x3fcb6541c263fb28,
    0x3ff4b81236836e90, 0x400ae3360346a727,
    0x3ff8e9bf65022d13, 0x400306781ffb54dc,
    0xc00ab1b71a6a8df0, 0x40099ac8c8a414a6,
    0x3fd96e6d28ed72de, 0x3ff107809d105122,
    0xbff19dc04f92d75e, 0x3fe4489855da2e7f,
    0x3ff57d188ef0fe22, 0x400c7561d720b761,
    0x3fe117dc992149ef, 0x3ffcdedef8db59e7,
    0x3ff7af922becbce6, 0x3ff1bb27a482979c,
    0xbfe77712a4d09350, 0xc0050b5ec8c9133d,
    0xbffaedb2135d4a7c, 0xbfd08c65880671a0,
    0xc00ae5a4bda7791f, 0xbfea67ec92242289,
    0xbff1fd2e4105a7e5, 0xbff3fe198ef1ef5a,
    0x3ff1e038010ae37c, 0xbffaf4b153277a1f,
    0x3fe4773bf90f054a, 0x3fb7ad3456de1c00,
    0x400977951435fcfc, 0xc013d8d7b2903132,
    0x3ff06a9047f172b0, 0x3fed8c94117fa6da,
    0x3ff34298e275f27c, 0x4002f74bf13a0f6c,
    0x400419b74c502463, 0x400a023ca3f1489f,
    0xc0018a5f5e2594bc, 0xbfff0869a5b00708,
    0x4010cba72bd1c384, 0xc0010ad2b60568e2,
    0x3ff15e588bce7ebd, 0xc0022fa9724ab04a,
    0xbff35ad8d7fe651e, 0x3fd26d99c223f896,
    0x4000e9200027e4a5, 0xbfdb0d0ebb27da38,
    0xbff38f7edfa481a8, 0xbfea8f7c28309596,
    0x4007038687085b94, 0x3ff8ddc6bf88d1cc,
    0xbfd88e8a802d33b4, 0x4012a538b66355a8,
    0xbffe0e32d0bc55fe, 0xbff3692135c7d7ce,
    0x3fd5f05db0dd2cb4, 0xbfdec772f7baa980,
    0x400f9091771e25dc, 0x3fe835192a50041c,
    0x40084b7e2dd80a86, 0x40049a7342a2e368,
    0xc01d48e9ad3e7156, 0x3ff54643dfa23339,
    0xbffafeab0df3b588, 0x3fea31ccfb2e4758,
    0x3f84bf9ef61315c0, 0x4009383586563804,
    0x40047da7365e8988, 0x3feabb388ada6fa0,
    0x3fe2f65595c35d96, 0xc002612ad4320c6b,
    0xbfd489be1e1be10c, 0x40092c4f25b37e0a,
    0xc00aace67c395bd8, 0x400b56ee80c9ad60,
    0x4016b36fa27b1b4a, 0xbfea5553c8dd47b8,
    0xbfd37e8bdeb038d6, 0xc00860962e7e0af6,
    0x40010a78cfa19a3e, 0xc0044a3acc357d52,
    0x3fe1eaf713d13651, 0x3ff5694cb38b30d6,
    0x3ff5bdcaeb6a47cc, 0xc010b442c7624d7e,
    0x3ffa1b3e54818cf8, 0xbff582983b52c5b0,
    0x3fe9b2532b49929c, 0xc00148e439112121,
    0x3ffdd6a78bc61bb3, 0x3ff8f5b1718f1029,
    0x3fb926dc3c2e3c70, 0x4010fc7308a39800,
    0x400b0de45916fc2d, 0xbfd987cfd618be1c,
    0xbfee3802eeb4bcf2, 0x3fdb7304b0898508,
    0x4002d7fb5bdbedc2, 0xc000420c869a6742,
    0x3fcec2d785bf4d80, 0xc00fd5ad1d967aba,
    0x401038c1ea420894, 0x3fc8e74c9927607c,
    0xbffb0eda8d3f1512, 0xbfea26617f503ca4,
    0xbfff3d9487b568ee, 0xc0015734908ca0ee,
    0x3ffb6c98430879ad, 0x3faedebb35073bc0,
    0xbff2e7aeed1741a7, 0x40044d646c71937b,
    0x40118a8078d17272, 0xbffd6d73065185cc,
    0x40048066c1cb92a0, 0x40017821b6b69386,
    0xc00427a8aef1874c, 0x3fd7d8edbd9f2c20,
    0x3ff5369b5b936a6d, 0xc00f9d997134a372,
    0x40042b9fa99e3d6f, 0xbfe78194e271a114,
    0x3fdefbb9e49a0640, 0x3ff6e34bbb8bbf19,
    0x3ff50d5031bd6f1f, 0xbfca849505bb2dd0,
    0xbffa7e38d009d4b2, 0x3fd64e2941c3e2fe,
    0xc00a67f868fb14a6, 0xc0122d9d17904a8c,
    0xc003dac5e6c1b284, 0x3fd84b8b350dfdd2,
    0xc004487fff564b25, 0xbff84e8c76f642b8,
    0x3ff7da166dd45654, 0xc004d6d458b02ebb,
    0x3fff81515363ec62, 0xbffdcc83dda6b049,
    0xbfeaa7014cfa97d6, 0x4000d605aca8bfea,
    0x3fffdeb28ce5c9fc, 0xbffbfd38f5564a79,
    0xc0027737e8ba9b82, 0x3ff36287d1a5cfbd,
    0x4009f4f4e662750b, 0x400cee79aefc20b8,
    0xbfd2d2b350ddf828, 0xc00b55e9b4501b7e,
    0xc004239ce7900386, 0x400d0e474dd63b5d,
    0xbfe2cc352dce381c, 0xc01213ca3c5cd8ae,
    0xc00432f721f1d28d, 0x3fe04c6d061c6a6e,
    0xbffb61974c560acb, 0x40080ea82e7e39c6,
    0x400b2d0afc4f537b, 0x3fe9c83283c6b9fa,
    0xc0029db027a5b891, 0xbfd64dcbd159da80,
    0xbff4c8a34e4c9332, 0x3fe5b3d26b3c2206,
    0x3ff4663021c653bb, 0x3ff19a911396f6eb,
    0x3fe280458a26b9b9, 0x40039e2205bd7e87,
    0x3ff1aea34b0e1d21, 0x3feeb895bf141df7,
    0x3fc1d5e6778034d0, 0xbff588e4a0acaa1c,
    0x3ff16c96ddbcbefe, 0xbfab9985ab1d8280,
    0xbfed499d2f3f1012, 0x3fd55af2eac0db24,
    0xc007c33255de1299, 0xbfb0a9efba7a68f0,
    0xbff7109b27e43f63, 0xc010cacc29e6d7ad,
    0x3ff9db21c3751b16, 0xbfd161d137503b0e,
    0xbfecd3eddf162470, 0x3ffc707c7f5afeda,
    0x3ff9118f5bf418f6, 0xc00c8a5702e09385,
    0x400a4f88a59c715f, 0x3ffac219274bb8a2,
    0xc000fd7c18b92640, 0x400874e7b3e9dac9,
    0x3f9795243a087b80, 0x3fd10f167c31cdb8,
    0xc0096bada1b8664c, 0xbff3274feacf3db9,
    0xbfbe7afe5c37fd90, 0x3ff27a354b00f076,
    0x3fd526ba8f41779e, 0x40006748be8679e6,
    0x400df03f153d89f4, 0xbff86c4976717344,
    0x3fcb2ab26d2f3cd8, 0x3ffa9f56ee83e32e,
    0xbfe41095e2c8a483, 0xbfdc5c8bda9bc0e6,
    0x3fd7949aa81cf294, 0xc00eb0b630a25b4b,
    0x3ff4bacdcf602e97, 0x3ff013ac191b3a95,
    0xc00b6d832ab65164, 0x3fe50ab1c449415c,
    0xc012002eab11af73, 0x4000d6cc0065b6d9,
    0xc00c11d78d6ddc51, 0xbfe48f44e7d5e614,
    0x4013ab054c100e28, 0xbff610da0d951168,
    0xbff56e0a207c8fdf, 0xc013f70cdc7ae14d,
    0xc00a8623248b29a3, 0x4010a3ce6ef58c16,
    0xc001429bc609ceb4, 0x3fa46576d5e9c000,
    0x400432ae89401f8e, 0x400f253e180f6a68,
    0x4005d10cc446f804, 0xc011c209e7afa220,
    0x4015a2c336c3883c, 0xbfe77b2324f5234e,
    0xbfdb093056fecd64, 0x3fee09235472962f,
    0xbffee82e67e7264b, 0xc01306d11bd11afc,
    0xbfd6764d47f47d78, 0xbfea2fbfb7cd2204,
    0xc005cd8a695904d3, 0xbfe0fadd24adfb4e,
    0x4003a0fb7b61eb22, 0x3ff5381d1b24c6ba,
    0x4008cfa5a206890b, 0x4002124495d32c06,
    0xbfef23b4715bbbea, 0x3ff2c5dff87490cf,
    0xc0098b3911ad6cbd, 0x3ff6c15b74babd5b,
    0x3ffe4f52dbd4b090, 0x4000c52a12727cf9,
    0x4010222e8844f60d, 0x400b7b46625663d0,
    0x3ff4d842437b4e40, 0x3ffd47d75b700d4d,
    0x3fe9de47a2f0144c, 0xbfad5d90cae9f450,
    0xbfc794a0b5ae177c, 0x400b434fcd16b574,
    0x4002d910697fbe05, 0x3fc6cd2aad6c95c0,
    0xbff653b7f425893b, 0x40065c4ce5b23e04,
    0x3fe165eca9e2007a, 0x3fe551a2112d6a94,
    0x4004377fb010481c, 0x3feffb9154ceae49,
    0x40034912b1f8750d, 0xbfa3b40bb4902a80,
    0xc00e296a0ad8b306, 0xbfb214f9239612fc,
    0xbff8183808fc2b42, 0x40020f2a21b1938b,
    0x3ffd0c855979fa46, 0x3fe0914cb8bc1e13,
    0xc003c6cc86421bda, 0x40068a743c2a96b4,
    0xbfd9a8207f95626c, 0x3ff536d74285d51f,
    0xbff0174c258b45a0, 0x400d0455e32238a2,
    0xc0066332b37b4778, 0x3ff8ccf238ed16e3,
    0xbffbb6b9da4dd9fc, 0x3ffb4161baddf6e8,
    0xc011108b07de9cdd, 0xbffe162a8baa2a3c,
    0xbfefc767d97f2720, 0xc00667604c24a2a4,
    0xbfc5b98f3a5d6cfc, 0x3febe81244418535,
    0x3ff9a0351016ded8, 0xbff2cdc0a89cb233,
    0x3fb05d6c75fd8340, 0xc001470bf937319e,
    0xbff05b7ba06b1ed1, 0x40069fbe9ae6a0d9,
    0xbfd31c31a8c9eea0, 0xbff1f05c54642df0,
    0x3ffd640bc91e9a40, 0xbfe01a220f847b76,
    0x40011d33fc953e4d, 0xc006b728ba50f61c,
    0xbfcbdb9165cdf050, 0xc00b76e6e8bd9b35,
    0x3fd3504e781737b5, 0xbfa57da595021500,
    0x3fbba373cfcde748, 0x3fc161679ec23d08,
    0x40099685e7884f73, 0xbff0511b0e37376f,
    0x3ff957c922e64eca, 0xc00b0eccf5550e76,
    0x40012b27d14e0612, 0xbfe195f1565dfd12,
    0xbfd07c4858d1c3e4, 0xc01703d8439beb20,
    0x3fc120bc789fc97c, 0x40163a4cdd756a59,
    0x40041966ec4e85b2, 0xbfcef9b7d74c55c8,
    0xc00066201c9316f4, 0x3ffe0c9b367d0c5c,
    0xc001eca93ce0cde1, 0xbff4eefd98e08fe0,
    0x3ff15007b8a25684, 0x3fdf0929db334f7a,
    0xbfe3a85bc63a426e, 0xbfa22ba2d5b86140,
    0x3ff04f509ecdec6e, 0xbff6a4ac85b975be,
    0xbfb2db941e55fbf4, 0x3ff9370c77daef5f,
    0x400a61421f2085ec, 0xc002dcf540616732,
    0xbfe27ef639e44f86, 0x4000b7964f966478,
    0x3fe140d4ae9ae504, 0xbffa16151655b1ae,
    0x4001527d74371a88, 0x40042d53ac71f647,
    0x400d59ad427039e4, 0x3fe5829266c04a0b,
    0xc0065bd580db9872, 0x3ff94de48d0b6057,
    0xc00e662b360eab3e, 0x3ff1e5968b67048b,
    0xbff0ce1970108413, 0x3fbbe6f7acc5ccc0,
    0x3fe47ab4e2a51104, 0xc0052efc21fd2370,
    0x3fde5ec025e3eea0, 0xbfde23a6a8db0250,
    0xc008e317a4e14d38, 0xbfe698cce2d5b4c6,
    0xc001136394b40631, 0x3fd0cfec37518482,
    0xc00211817c95deea, 0xc0018295b5b82580,
    0x3ffb9e7d30602d83, 0xc00237d4b9bd6f83,
    0xbffd8d2b5bbe08ce, 0x40067df0e9a8f2fc,
    0x3ff3273958941fea, 0xbff348c133067f30,
    0x3ff5777d11bb6568, 0x3fc1d79f293f1718,
    0x400b55be658f63e9, 0xbff7e64bbe550093,
    0x3fe6b09afbc82b2e, 0x3fc53613bd8c0810,
    0xbfcd31fa30e2ccb9, 0x3ff685a7550e58f9,
    0xc009287856df0297, 0x3fa0f262371c8220,
    0x3fee6fe6b8497b25, 0x3fbf066802d1d6d0,
    0xc00bff21476d3976, 0xbfe9e3e818066a87,
    0x4006eb8d9ccdf3f1, 0xbfd3a4f3f97ec88e,
    0x4013fb2dcf5f0f60, 0x3ffcdbe1dd1c6744,
    0x400d0b8356c5081e, 0x3ff11c53896d9a7a,
    0x3ffd467a09d9d9eb, 0xbfef6b73121f9520,
    0x3fede08bf4bbc214, 0x3ff8101f3a229997,
    0x400c58ee212f004c, 0x3ffb556e8125003a,
    0x4002a86611911d2e, 0x3fd0003e6cf1ea58,
    0x4000566e23ea4d23, 0x4000aa6a35ec0cc5,
    0x3ff8365c46ca206b, 0x3ff30b3d6488968c,
    0x400d0c59b58f9058, 0xbfd3803002b3b1a2,
    0xc011860f09815a8a, 0xbffb150f3cbd6314,
    0xc01093023c99a032, 0x40101c99650278a4,
    0x400661fde12c1ab4, 0xbfc4f144f07d8407,
    0x40026372d81227fb, 0xc00294c21316eeeb,
    0xbfeb16a191778050, 0xbfc3b15aafac931e,
    0x3ffddbf4872e5536, 0xc008c2e192304098,
    0xc011552a0c20b42c, 0x3fa6f5f8f86a7270,
    0x401e090415e0bade, 0xbff4607eb24e4e7e,
    0x4006e9aa969003ff, 0xc0007049c39f002c,
    0xbfad04bafbf355a0, 0x400118c34a14a0f8,
    0xbffc84d90adef51d, 0x3fd3b81c8c6a146b,
    0x3fe59fd5a7760a62, 0x4006a1237807911c,
    0x40105604da3ee595, 0xc008d5311cd9ed10,
    0x3f9b4fdbc95238c0, 0x3fe6c1ee285c9ed4,
    0xbfc9f5b60a9cad58, 0xbfeda541640b4548,
    0x3fe96ee06a17c964, 0xc00e5e7438de8d42,
    0xbfd45f7e0e0018fc, 0x3fe73772f0db9942,
    0x3ff2ec86aaf8384c, 0xbff2b4774898010e,
    0x3ff0f89a4dd79671, 0x40033cfcd114c26f,
    0x4002ade2dfd0cdfa, 0xc010e4da161c874a,
    0x3fc101dd8c78e7d0, 0xc000c78df5a74c19,
    0xc00d9fa2757635ac, 0xc00ad707f603dff8,
    0xc00a7b3896c8cb19, 0xc00c6a60c793320d,
    0x3ffc8b2660962289, 0xbfed0d418958cb56,
    0xbfeed460b2bf3e48, 0xc000d65ef745d4ae,
    0x3ff16182948936da, 0xbfe3ab1ae4f48044,
    0xc01196d22b203ac8, 0xbfeba21ef1d5bd30,
    0x3fffb84b9b28c100, 0xbff7aabc5fc3a20d,
    0x4009b25c8991d86b, 0x3ff2272a001c7d48,
    0xc012333cf3bb4a44, 0xbffbf4ed8ccf5efd,
    0xbff23078eabe1a7c, 0xbfb1c0e8ef291a10,
    0xc00eb3cc266b2bbe, 0xbfb142e288b133a0,
    0x3ff23da231c340c8, 0xbff7a66eec78b5b0,
    0xbfe8d739a40b4c27, 0x3fd86e4d662bd716,
    0x3feec745e63a177e, 0xbff4ddd8c6eece6f,
    0x3fcd299a4269d410, 0x4005b43bde8d3bee,
    0x3fe7375ea6d67737, 0x3ff2e6daf4eee34e,
    0xbf8934373c573cc0, 0xc0052dc67836d275,
    0x3fd6700790e18593, 0x401c0da74ec2623c,
    0x3fc4a8ccddeb1130, 0xbfe6c04f6d58461b,
    0xbfebe85f0e99ae1e, 0xbffee452886a0348,
    0xc0048ec26e46a947, 0xc0002b5d2cbcdd7e,
    0x4006505d21e35911, 0x3fffe109d0f28c5f,
    0x3fdd57f381d9193e, 0x4007dfa494915318,
    0xbfee814da823d3f0, 0x3fb35e702cacd248,
    0x4000734ff8bf32d6, 0xbff8cab4e9549c84,
    0xc0056ff1ad19a806, 0x3ff20fd02882c5bc,
    0xbfc872cdc116b7ac, 0x3ff056e0157bb1ac,
    0xbff1ce844c4b6199, 0xc00496f66757416e,
    0xbfb83f5c5fcc2e38, 0xbfd9aafe684b1598,
    0xbff8fd12893b27af, 0xbffc0a082f9a0aac,
    0x3ff92338b2b0a54d, 0xbffc514ad5190be3,
    0x3ffe9cd65d92831f, 0xbff8b83668fcb8c3,
    0xbfc03d281c2c51a5, 0x3fe546e10442cc6f,
    0x3fff93a039b67ca8, 0xbfd8c09e3db19244,
    0x400839a5bb0311f6, 0x3feffd6cc5c1369f,
    0xc007896d6689aa8b, 0xc001b423f5470b46,
    0xc00798a1966f5b10, 0xbfa4fe67ba068f40,
    0x4000c9c4e657e0bd, 0xbffb3f4d354af6ca,
    0xbff61c197c16abe8, 0x3ff392fac025b149,
    0xc00581b901a72ab1, 0x400d8827274a9363,
    0x3ff9b74bd7960935, 0xc016dbec4b44d78e,
    0xc013f41ba46f9621, 0xbfe0a4b82a2d6493,
    0xbffceca60d6ea93a, 0xc00434859193ab15,
    0x4007bd834cf39711, 0x3fff96f6dd8845cc,
    0xbfe3f0022ab88314, 0xbff684cbb3ebcf8c,
    0xbfde7b80685a2c9c, 0xbfe92b28f114b45c,
    0xc016767828a4d965, 0xbff54946d6b6656c,
    0x3fe3b74783275cf0, 0x4001e2a80564f1b5,
    0x3fec586e5cbb6ab6, 0x4004511646b6465a,
    0xbff0306133dfca64, 0x4000acd69eba4886,
    0x3ffd818adfd022a1, 0xbff22aa60f187a6a,
    0x3ffb6ab37b50e863, 0xbff1923049bf88c8,
    0x40010178fa15139c, 0xbfbbbcc1015fc7b4,
    0xbfeba19c4473ee1d, 0xbfd7cbbbed6da5a9,
    0x400721c51ff21a6e, 0x3fc8727d32c35580,
    0x3fe3b5de5a0ff2a2, 0x4001e0055895db72,
    0x3ff953286eb7e693, 0xbfff8006318aec5b,
    0xbffa62afa933c8b8, 0xbfd79878cb9d74f0,
    0x4003625494b85891, 0xc0098c5d4b28d247,
    0x400c1d522008c87c, 0xbff7dd5bafbde314,
    0xbff11e83df264c27, 0x3ff745bf6a320c0c,
    0xc002259ab3dbb5ee, 0xc000a4bfa7f13ad4,
    0xbfdc5fd54fe2a788, 0xc002e2b0780b43b0,
    0x3fec2d982e3c29bc, 0xc008491e36ee9769,
    0xc014a6ba6697e287, 0xbff44f6b6085a8ba,
    0xbfe5e137acdda462, 0xc00579966197700c,
    0xc00afc0981fffea8, 0xc0117989615baa2e,
    0xc00fa8f0fd6914e9, 0x400c7350f1534ac8,
    0x4013144613bd130e, 0x40044f73e1277a58,
    0x3ff1339964cb6efb, 0x3fd48b6fb13142ee,
    0x3fe83437fc29cade, 0xbfd77cadd6cfea94,
    0xbfd9ec37d8cae060, 0x40043f3f3c192f2b,
    0xbfb00b10cbd0dcc0, 0x3ff1854f8e97ccc5,
    0xbfc129a2648004b8, 0xbfd88d06956f5e28,
    0xbfe6469edbfb3084, 0x3fe8a74bb3f00e70,
    0xbfe659278e2e0b28, 0x400a92dbdc237a54,
    0x3fe6102868dfd1c5, 0xbff34b899f2d4514,
    0xc00308c58a55a3de, 0x401563001894db7a,
    0x400c6c4357240428, 0x400387d49255f5a2,
    0xbfe374a183d59a43, 0x4006d15585d128eb,
    0xc008a8cf5bfaba2d, 0x4003482f50677e96,
    0xc00531fe3fa43e82, 0x3ff6a389a7a02b98,
    0x4001d4aab36d53ae, 0xc01169dcb5c0310f,
    0xc00523d737e4620c, 0x40110833eb79bad0,
    0xc00bdc62dc84179c, 0xbffde044f7162cb6,
    0xbffa8675339ff7fb, 0xc005e07d2b8b2370,
    0x3fdcb9e820ca0330, 0x3fdbe3b3af209755,
    0x3fd98981cf7fdc0c, 0xbf8702c4599a9f60,
    0xbfb143c41443315a, 0xc01118087a49d4ad,
    0x400670f3dfeb08e5, 0xbff933e9503107eb,
    0x400751d958e301fa, 0xbff5a2f4fa2c1465,
    0xbffd2d118a30417e, 0x40086508303ca46f,
    0x400600f05218914a, 0x3fe19a1fdbce5888,
    0x3fbde463809fe658, 0xbfe25d7793705439,
    0x3ff61c9cc1d11774, 0xbfe7d064a927c91a,
    0x3fef5e20e84b301f, 0xc00e0538d8e43cc8,
    0x400d7f211cbc4cba, 0x3fbc9d27613cd746,
    0xbffa56d2e59e38fe, 0x3ff7367f4ceda442,
    0xbff3500f3de10ceb, 0xc004802d92079a54,
    0x3fe3eaf291351834, 0xbfd496262010cf9f,
    0x400cb410b7e66b09, 0x3fcb6a4804e40464,
    0x3ffdf89b172f0152, 0x4001d9f8e2c89962,
    0x400eafd90f0b272c, 0xbff25d1cece9fc70,
    0xbfd5963115cb3548, 0xbff4447691f4e7e6,
    0xbfc261cc1d161e40, 0xbfe0950408e26114,
    0xc00fe9b18e151e5a, 0x3fe9346a810f550e,
    0xbfc11baac1d41a9c, 0x4006657989076338,
    0xbfb32e34b53ac620, 0x40005408aeccfcee,
    0x400b9885edb9b041, 0xbfea3822a7ad822b,
    0xbff29256518b0c76, 0xc00913d108b88c76,
    0x3ff0c46e3662e9eb, 0xc0043de481250170,
    0xc0021ee5b85064de, 0x3fd534c69c34796c,
    0x3fd2ea75f1d84a7d, 0x400374168909c468,
    0x4003dcd5ab6f9653, 0xc00ed4b835b2fc89,
    0xc0010187ad3aa7b2, 0xbffb0fa414ced048,
    0x3ff58395d27c712b, 0xc006b549d72c2bde,
    0x3fd502b0a43b07d5, 0xbff0e057ac044266,
    0x40123d762575a99e, 0x4011f9b261e959ce,
    0xc004d33a5f481304, 0xc00adcff342bad21,
    0x3ff70e65bdee4aea, 0x400efd2abd09802a,
    0x3feb21cce8969b75, 0xbfefb8c61af73866,
    0xbfe58276e5705ff4, 0x4009a09365448dd0,
    0xbff550a08a81315c, 0x3ffb3e53f4042ecb,
    0xbff0cfc3c33ccbd5, 0x4010a5ef8cb3a4b6,
    0xc00417c262f72579, 0xbfed14cf371a9e9c,
    0x3ff7d1bf43c7fa00, 0xbff59b5ef83d85ae,
    0xc001d3e98ddb1ae3, 0x3ffab95ecc57c968,
    0xc01a0936793f9e66, 0x3ffefc0f68265be0,
    0x3fcd80e7300dcb20, 0x400b533e8c6b4d9b,
    0xbfe5538c81384f4c, 0x3ff39655a379322c,
    0xbfff26459e1d4f10, 0x3ffdf44c8ce9e542,
    0x3fe4e12d6878a0b3, 0x400741914c778a07,
    0x4008fe106c07abce, 0xbfc276827c20e510,
    0xbfe3ad6caa276046, 0xbff394a8cb2107ff,
    0xbff8c0f0e5489f06, 0xc016c872b1a26b32,
    0x4002f7b904de5d59, 0xbfff9acad6fe632b,
    0xc007507c9712cef0, 0xbfca874d590ed41c,
    0xc00ca691007d618e, 0xbfa1683e9a14c85c,
    0xbff243afd818a1f2, 0xc003e9d5ed831f95,
    0xc011171537a86e14, 0xbff68df6849fabeb,
    0xbff8a4a21496d608, 0xc0016cc0b28bc971,
    0xbfd2146b8a02da20, 0xc0033ebdca0a448c,
    0x3feee6f7c705fc58, 0x3fefc6bcfeeebd79,
    0xbfe2e911adfc9271, 0x3ff40fded65956ab,
    0xbfee583db6cd317c, 0xc00a6d9e66c9b03e,
    0xbff39676ef578216, 0xbfe1461fd4149bf3,
    0xc0103202846078bd, 0x3fe39dfd815e64f8,
    0x3ff6a900026ae30d, 0xc00917a5cc05f36a,
    0xc009fe74b5d8abef, 0xbfeb666c145fbb08,
    0x3fce86719a7a4641, 0xbfe09722f37856fe,
    0xbfffee5eac70ead0, 0x3ff2f5a453028c0f,
    0xc0030de93906339c, 0xc0031abcd7d3da06,
    0xbfb51b9f834a7ac8, 0xc00d1a2fd738e085,
    0x3ff2074cc0b75e94, 0xbffab004caea7310,
    0xbfd7cc6b9fad5f02, 0x3fff6fc4fde3ad86,
    0x4011da18d0b5fcf1, 0xc007eb8b749fce46,
    0x4011082d85876b2b, 0xc01314e85ab30c7a,
    0x3ff9061704b3d73e, 0xbff850e808cfa605,
    0x3fe69cf70beab831, 0xbfdf44d450ed7e98,
    0xc00682dca352b651, 0xbfda0ff71133860a,
    0x3fb358aa20ff0b60, 0x3ff318c58f762fe7,
    0xc00e5b783795204a, 0xbff6e7c68fa4599a,
    0xbfd81d75e29c1fbb, 0x40048870a02984ce,
    0x40009def10099b84, 0x400bfda7f5987d25,
    0x3fc6361a2dee0b50, 0xbfe21f5d2df7eca8,
    0x400da94f413a3c7c, 0x3fe28816857a3ce5,
    0x40054bbe1f605bec, 0xbff3639cf751b780,
    0x40008252fb4f5a51, 0xbfd2860f76260e28,
    0x401262adeddb3ae6, 0xbfe461cf1963e89a,
    0x3fdae4d4cdacadb5, 0x3fd00e095302d430,
    0x3ffc27e1198bfa9f, 0xbfc1bf1cfe0e38c4,
    0x40019165361a30ec, 0xbfd350970049d3ec,
    0x3fdc05eb20218904, 0x3fd3d7226c11e18f,
    0xbffb063c44abd6bd, 0xbfc5fab2deac17ee,
    0xc0008bc948fa8c8c, 0xbfef26440743db6d,
    0xbff3dc52cc2da682, 0x3ff2152d9a408b5a,
    0xbfe6acec994b2910, 0xbfff9542df3fe9ee,
    0x3fe4d856c517efac, 0xbffbb0ec270801fd,
    0x400b67e102d91e58, 0xbfce826bd81e21aa,
    0xbfbf71214a21f708, 0xc00a2c74fde1060d,
    0xbff6d097a0f4c001, 0xbfd47c73824e60aa,
    0x3ffb0c6697250484, 0x400caee9e887aee1,
    0xbfdc51a6386c0489, 0x40081803d2ebea84,
    0xc000c53ea3c4aeee, 0x4012d389bb96b63a,
    0x3fbf1cffd32f84c0, 0x40013ecdedf0ec86,
    0xbfef68a5180f81ca, 0xbff9aef1b9ae3e14,
    0x3fece99c0ed66ab7, 0xbff4727fcb6c723e,
    0xc0064f230b7fadc7, 0x40115d46a01d1d1b,
    0xbfdf9af9025b93c4, 0xbfc6acdade5eb527,
    0xbfd250321f9550bd, 0xbfe7cf0849df8d10,
    0xbfeaf1d751433864, 0x400293c579c9948e,
    0xbfe0c6ed6d26f95d, 0x3fe68e39a51a351a,
    0x3fe0b75863c7fd07, 0xbfcbe82d32f7b160,
    0xbff968f9fe49a27d, 0xbfea7bc4cd6b7ee0,
    0x3ffe642934201845, 0xbffefff65090975c,
    0xbff7cd4bec9ea8e6, 0x400ec1b5fa92f6e0,
    0x3ff2adbd350c02fb, 0x3fe125900a8a2eb2,
    0xc015fd0d531533c6, 0xbfd1f8d40f759440,
    0xbff78771440f70ba, 0x3ff6886d673b876a,
    0x3fdaaa1bd8f2d9c4, 0x3fe317cd609d2236,
    0x3fef5183538f2ad2, 0x3fdfc661ffa5c86a,
    0xc00bb4213cb2aa64, 0xc0057cb660f74d2b,
    0x401181e64d32aa73, 0x3ff93c7312e5652a,
    0xc00c8333f4cddd6e, 0x3fd40db30a9ca24f,
    0xbfb5ac5c833a231c, 0x3fe37c4a151fd5ff,
    0xbfeaba8c4ec94720, 0x3fe30090ea9c47ac,
    0xbff5bc778b6bad18, 0x3fb0343d3dd92230,
    0x400e2c66fe4d9e8f, 0x3fbcc0819ec16da0,
    0xc01060e1c44b6019, 0xbfea3d6342dba2e0,
    0xbfe8b4091a09f53e, 0xc006ab1bed0e7e09,
    0xbfdb0cc3874c73b0, 0xbff8c586a8cc48e6,
    0xbffa2904f3674811, 0x3ff1b2840999ed87,
    0x40030e442dfb3168, 0x3ff9c00ac02b064a,
    0x3fe8f24b8ad04eae, 0xc00cb646811d7ab4,
    0xbfee5ab8803eedb8, 0xbfc64be77bacba20,
    0xbfd311766fe6d144, 0x4004eaab83edbbba,
    0x3fedca8b7e4b5bd1, 0x3fe6f2d1c9548775,
    0xbfded7ecdf1ee6f5, 0xbff74532ae241b37,
    0x40040550cbdb6f8b, 0x3ff07168cefb432c,
    0xbfefd9ecf25ccb9c, 0x3fe2bf79f177087e,
    0xbfe947990d0c3380, 0xbfde70558c87326e,
    0xbffa2026f3be168a, 0x4001574ce77f8665,
    0x3fc917d341baa428, 0x3fe795c803953934,
    0x3ffc882fef25af36, 0x400123657217b7ce,
    0xbfe260f0df227469, 0xc010d5cb56d18c16,
    0xc0060b813742d34c, 0x4002a7204cb355ca,
    0x3fface88e040c1e4, 0x3fc0ae716fc79300,
    0xbff12fb604398e2b, 0x3fe2d4364ba70b07,
    0x400349717fe87d1e, 0xbfec210c550dfaf6,
    0x40016237af12db63, 0x4007fa7d7f3dd779,
    0x3feaf8fc0be582e2, 0x3fe6e48bb7714c36,
    0xbfeeb12048b9ea16, 0xc002bf191021dce8,
    0xbfe6e5abf386038c, 0xc003f6d17c0cf104,
    0x4004c5cda57c2f08, 0x3ffb2c9059b92476,
    0xbfd86edc5dbc35ae, 0x3ffaa1b6504535b3,
    0xbfdf8564837957bc, 0xc0031c0074679830,
    0xbff2747a7f961b8a, 0xbfd997af02d89380,
    0x40054ac1dd6c465a, 0x3fe2fb4c25538c3c,
    0x3ff32637441e7196, 0x400a131ceb77e34a,
    0x3fd2946d24f8e5ea, 0xbfb07c28ccaa38d0,
    0x400acbfdf015c2c4, 0x3ff59afe89a332e7,
    0x3febc5d5815ee6b7, 0x3fd5e4376cd6e1b1,
    0x3fee4b372034bc5f, 0x3ff845d2489f6cd4,
    0xc009dbd35f4b6e10, 0x40018c766be035a6,
    0xbfebabc24ec613cc, 0xbfdd692adff8b0ca,
    0xbfd376958783c050, 0xbfdf21ab654f184c,
    0xc00a1779ca7a784c, 0xbfe97f8a480b806b,
    0x3ffb651a24aee7c1, 0xbfe632d918bd75ae,
    0x3fbdc88956d5cbe0, 0xbfe9544683056c29,
    0x3fcdcdd293722c00, 0x3ff9dec168428182,
    0x3ff3e2668f188f02, 0x3fe17cdb36391976,
    0xbfe41f2bcfc974de, 0xc0061be40e90e898,
    0x400ce79058d8753a, 0x3fead7e828b89db2,
    0x400a49089605c3ec, 0x3f894e998a0b29a0,
    0x3fd61e47885c224f, 0xc0001df08db90250,
    0x3fd1678da0819153, 0x4001158cc88c1c26,
    0x3ff9862231fa10f6, 0x400512a45624747c,
    0x40000b4c451f81af, 0x400cfe56683a55fe,
    0xc00328bf58800cc0, 0x3fc44b75508876d4,
    0x3fe8e12b767bf846, 0xc004b50b0ca74570,
    0xbfef021a3d238a11, 0xbfda6c473b37681e,
    0xbfe7f8192c1734d4, 0xc00b1e8795c2b39a,
    0xbff202cc35ddd95c, 0xc010eab0301fe51c,
    0x3ff8b3e0fbb3402e, 0x3fea64d96e84e0cf,
    0x40006d26aa5152de, 0x3ff9f27b40e4562c,
    0x3fead5bae46e6d89, 0x3fdda64d05ec16e2,
    0xbfffb691a1546dc8, 0x3fce70ae5eba5740,
    0x40103be2f1ab432d, 0x3ffeb1cba91ae1b4,
    0x3fe4e429b2304cb8, 0x3ffd815fc946195e,
    0x3fdbc43c3a613d22, 0x3ff919ab8e2f75ba,
    0xbff05ce4e93e09b3, 0x4006106340cbfe31,
    0xbff990b8393fb212, 0xbff2c64dc37e3bce,
    0x4005c3988a2d7b25, 0xbfe29963a1e13b24,
    0xbff39fe61549bc4a, 0xc00255ed141952ab,
    0xbfc3533277b76968, 0x3fca9f0751c22168,
    0x3fe166a003fdb07a, 0x3ffb2bb883783180,
    0xbff1765fecd58cb2, 0xbfecd950adec0aaa,
    0xbff1796ac9fd28e3, 0xc00c66587924f43e,
    0xc009da5adae018a2, 0x3ffe285c18cb707b,
    0xbfd688daf05f29e0, 0x3fae0b8135289b60,
    0xbffb58a42c390c80, 0x3fbda521f733c380,
    0x40039f3d770621f4, 0xc008d744bb8b4fea,
    0xc0067180e6bf4b15, 0xbfe642e2584cbb69,
    0xc005de68da691e86, 0x3fe892fbc538a5f4,
    0x40110c75d78f8532, 0xbffa80d9016c83c5,
    0xc007944659ed5193, 0x3fed18e522bff161,
    0xc00d66999b09ced2, 0xbfac30c5e845c9c8,
    0xbff64ecd32e70824, 0x3fef186eacd43f5f,
    0x3ff393abbb497073, 0xbfe381cd7522eee6,
    0xbfcc0e0573c5e644, 0xc00cdde5834fd6e5,
    0xc00bea7af0a643cb, 0xbfe4a7ac250b956c,
    0xbffc6b3cf28a8904, 0xbff1ae1fe8f5ff5f,
    0xc01295a4525a1e39, 0x3ff4bd3663c8939b,
    0x3fd0bc4459e7eaba, 0x4004c5d70a81b88b,
    0xbffc89cd936f553f, 0xbfdbece0129c3d45,
    0xc014730d9d13813c, 0x3fd60e9520ecb691,
    0x3ff94d818e281f76, 0xbfd8dc941ffd92da,
    0x40143716fb00a61d, 0x400eb16ddc2ba212,
    0x3ffdbf5d5a26e784, 0x3fe1cb7d9f026045,
    0xbff0224af2e35ce6, 0x40075fc6e7f635c5,
    0xbfe0d488edc4a182, 0xc003e8b75e18104b,
    0x3ff3f20848e6b9a7, 0x4010fcb7f9fe3521,
    0x4007fdd456b9bd40, 0xbfddc2be13c39a40,
    0x400aef9c3a55acdb, 0x400d5825b4d9c8d2,
    0xbfe89b31aac912bb, 0xbfd3146a826ea02f,
    0xc00aa1145ee1213f, 0x3ffaec1589a3893a,
    0xbff174d3efc47b75, 0xbff5864c161898fb,
    0xbff08f5077485c28, 0x3fb5108a0ac6f3fa,
    0x3ff8b7ccf106b36c, 0xc00468599360eccd,
    0x3fe600e335c96318, 0xbfaf8fcb64d6a4a6,
    0xc003be6188e9ba8c, 0x4016f5de9957310d,
    0xbfe939dc0fb16d1d, 0xbfd5bdcfc1fdb4f8,
    0xbfe992ed22174a0d, 0xc0055f6af23d3380,
    0xbffc2a338cd02e4a, 0x3fc765fb697d00cf,
    0x400c2e3c039b041e, 0xbff752fcd9194d0b,
    0x4011de0eddb61e74, 0x3ffdfd4c04ed8345,
    0x3ff95d4b07225498, 0xc00576af6feef700,
    0x3ff3b3d892c979fb, 0xbfd68f4d3810430a,
    0xbfe36080c9af7dd4, 0xbfe2c1e0a37a392a,
    0x400794f61d0329d8, 0xbffbe68b41fdb5f6,
    0xbfcf4c6f7386db0c, 0x3fbf5a725c7e54e8,
    0xbff0db70614f4475, 0xc0178b494fcf6697,
    0x40122773f7fe5ad4, 0xc00f6492de81ac3b,
    0xc00657bddb2963ec, 0xbfeb4eb74e7da412,
    0xbfd396a87a3a989e, 0xc01346188367fa1c,
    0x400770762a6cb851, 0x3fb0c2026c097775,
    0x3fe9c62780512be9, 0xc006165e3e4500e2,
    0xc018f62fe44a1a84, 0x3ff521008a40975a,
    0x3fe864a8cc8c2e26, 0x3fd69f1cae4a9afe,
    0xbff0bfd371da2536, 0xbfef2989ec71bd86,
    0x4008e077413cb05e, 0xbff79e21ef268bc1,
    0x40065940a4038e60, 0x3ff7d3caeb6e5366,
    0xbff792fa8aae0eaa, 0xbfbdbbc9ab4d1420,
    0xc001ce703d5a670b, 0xbfe0161db0103c26,
    0xbff7be3c8a5041d0, 0x4005836994008a4d,
    0x3feb30e646434cc4, 0x400c9534fc2460a6,
    0xbfab44afeeae8fa0, 0xc0076243882388a2,
    0x400ca2f715c98670, 0xbfd4b9253f59aa0e,
    0xbfed4e5b2e75ca56, 0xbff825e6f419da02,
    0x400338a644ccdf20, 0x400073197e4a4a71,
    0x3ffb14c7a1c88d6f, 0xc0126367716c19cd,
    0xbfccfcdc86f57628, 0x3fd81661295040ce,
    0xc0134528c8599ee6, 0x3fc973a9c65a7440,
    0xc00312663afd71b6, 0x3fda18dc0e230470,
    0x3fe50bfd0b7522aa, 0x4003a445423dac5a,
    0x3feb0571682f9a84, 0xc00757da22f98514,
    0xbfe0770dd849774e, 0xbfd548cca01d5d34,
    0xc002d6cf848e7884, 0x3fee4425d1e9e142,
    0xbffa9854c1ce7e72, 0xbff368d36b0b8447,
    0x40101aa4ea471d99, 0xc006efe5fd1bf59c,
    0x3fd296ada2537eca, 0x3fee66b48c9f63c0,
    0xbfdba169ad9df868, 0x40037d1f3a77f8c8,
    0x4000fe09ce23e597, 0xc013a471c102561a,
    0xbff27b02f694a4c6, 0x3f8987cc78544b80,
    0xbffc71b1af25fb6d, 0xbffbc3a1097f88e7,
    0xc01065692fa519e5, 0xbfe3546b8550320a,
    0xc0130519534d0a76, 0xc00348e752523f98,
    0xbffa4109155abb26, 0xbfeae9672a1b6cca,
    0xbfe275f9ae169340, 0xbfd02613fb1f11b0,
    0xc00eed9c552f2e3a, 0x4003b6ca5a6f4344,
    0x3ff89b7e2ac008ce, 0x4001f7fb682804ee,
    0xc007992270240da5, 0xbff6e56236b741b0,
    0xbfe86acd04e9a6a0, 0xbfe1f9bee158d9d6,
    0x4005db2b0765c945, 0x400d40902d3a1404,
    0xc00be4b3a08cc430, 0x3ff3eb3fe6ebfb95,
    0x3f8c0b4ba145c440, 0x3fdcfba461329048,
    0x4008c3ad134926e2, 0x3ffde0fb93c71861,
    0xc00cce20b85b87d4, 0xc01192f2c3754691,
    0x40162700a3d12695, 0xbff60a2e74c7c60a,
    0x3fe12924d4537704, 0xc00380b7318f5c31,
    0xc00185f15dd78276, 0x3fde662a088c6231,
    0xc0154e5da924e7fa, 0x40062404356205ff,
    0x3fe22a838f664315, 0xbfffd66fbdc8dd8c,
    0xc0012b9556aaea6d, 0xbff2149918b97c3a,
    0x40020cfd6dcbd6f3, 0xbf90924a2b1a80a0,
    0x3fffc002d0bc09f1, 0xc00cc16858413a8e,
    0x3ff8c0e96f82f67f, 0xbfd2d650903cc3b8,
    0xbfe594b2301cc9ca, 0x3fdb650982c18b0e,
    0x3fdf0ddfee22e09a, 0x3fe83b289f154ccc,
    0x4006bec9f33a2372, 0xbfec28deed885edd,
    0x400255bbf47e2f32, 0x4001a6f77cc758d9,
    0x4011a9ade1ba5c4c, 0x3ff1b285d592b9ce,
    0xbfd976d9461480f8, 0x40026a03e8a80a2b,
    0xbfeb9ae8a62c1628, 0xc0042ba497961030,
    0x400a1e1ec3fb749c, 0xc007b1dd8c1bd81c,
    0x3fdf69ec1cd6c7d0, 0xc00a60ea23f1d1f8,
    0xbfdbbaea80808221, 0xbfe3e2ef964511c4,
    0xbfffd545b31f8ff3, 0xbfd40ed2831d61b8,
    0x3fa9d62a60ed18e0, 0x3fcce44bbbc5b720,
    0x3fd6ecf412352b33, 0x40133a155e0d9f19,
    0xbfd96cda2908537f, 0xbff8222607222104,
    0x3fca9ed4136c1a9e, 0xbff67d3896109d9e,
    0xbfe3650e54cb9141, 0xbfe46df2e31572a4,
    0x3ff63851515d8f29, 0xbff5cd1f6df05f0a,
    0x3fded032a11a679a, 0x3fe8fec59187f65c,
    0x40079775d3648d08, 0xc00004e3c2508b11,
    0x3fbad3234960a970, 0xc005d38c728f842b,
    0x40024e4f6622802b, 0xbff6ed1e5b3099de,
    0x3ff9dcb438a88efb, 0x4001de3316da9ca1,
    0xbff4804023c5f4c3, 0xbfbb4ce8d70c42d8,
    0x40157932dfc636f7, 0x400aa513ec109136,
    0xbff895a6e054219a, 0x40116709b02028a6,
    0x3ff27cde0285a5bb, 0xc00529e7e475d0ec,
    0x3ff0cfd59a68636c, 0xbfd4de8f422cb7ec,
    0xbff5cdc86f729b6f, 0xbfe545280baf1d00,
    0xbfc5667b647c2cfc, 0x3fde70754b7166a4,
    0xbffd23213fc4cc2d, 0x3fdac6d84ebd4bdc,
    0xc00037dcdf23d1e4, 0x3fe3bdbbb35fa0d6,
    0x3ffda0c897f7478c, 0x3ffd9272765c1f60,
    0xc000ef6660a67f9d, 0x3fe41149d4a012cd,
    0x3fbbfa36d0311688, 0x3fd971fb45a128c8,
    0xbffc0e54301ca178, 0xbfc466e06b9c3b5c,
    0x40101dc4b6539838, 0x3f9a2fb9237c9300,
    0xbfff70ae7561dffd, 0x40062eaec04b0330,
    0xbff062493dbd4a16, 0xbfe9e2e9fc972274,
    0xbff0c2f1d1353a75, 0x3ff37ec0b9dad7aa,
    0xbff5f21df474d2fa, 0x3ff963c19ef3ac8e,
    0xbff0c9a299b59c4a, 0x40062ae98e15fe55,
    0x3fe6c05b7158db1b, 0x3fce2e349e1bafe0,
    0xbfdf73379ab392b7, 0xbfe8f8199800aef0,
    0xc006ea15cd7c3bf0, 0xc0044c0543335b94,
    0xc009426c3b113728, 0x40138acb2b4b5542,
    0xbfefae6422a04786, 0xbffd664aa5f8c0b8,
    0x401572578e0119fc, 0xc015c9fff1fd8970,
    0x3ff4c58c1ae450de, 0xc011e1c6c1c37fc4,
    0x40188c35030cf893, 0x3ff08e414ac09e54,
    0xc005f40fa0fe6cc2, 0x40005bc36b7af086,
    0xc000c2f0bb28b5e8, 0xbf9582c18b3ef5c0,
    0xbfe4dd5dbac740ba, 0x3fded8977494343e,
    0x401899c4d8373c91, 0x3fe3961b8e1d16d0,
    0xbfddcff18593942c, 0xbfd94f6cb49b16fe,
    0x3ff94c7f7d2fcafd, 0xbfeb5aa3ab954a96,
    0x400f305418009b86, 0x3fd87c9cb097dd10,
    0xbfff71c434a4be2a, 0xc00c16b8f324e7f4,
    0xbfef8f9581a1d64c, 0x3ffffe6a4bcaace2,
    0x3ff6104048660eb0, 0x3fe8e527cd1bd8e6,
    0x3ff9e55709eaaf68, 0xbfee70b67e728906,
    0xbfc2a4f596906770, 0x3ff31963f8bac1a6,
    0x3fea5eee414344ce, 0xbff75eec27c3e769,
    0x3ff04b650ea8ab78, 0xc00766e08480813c,
    0xbfd5923f52c5e1a0, 0xbff73e9632fff544,
    0xbffeb78cbc37540e, 0xbff0b58b608b7039,
    0xc002b104d6f1f166, 0xbff9ff9d188bf663,
    0xbfe77408f7675f9a, 0x3fbff7f1a2bea280,
    0xc00a1bbd55e8e11b, 0xbfe8d7ab61cfabb4,
    0xc00ac1d4e3224ff8, 0xbfd5c1b0434f2afc,
    0xbfe953b0c56429c8, 0xc007edf16bc5917a,
    0x40089b63b77d7d5a, 0xc00c330ebfbf6ef2,
    0x3ff5fa9526cf1ade, 0xc00d2f2ca3710ec1,
    0x4005bcd15383c505, 0xbfe8ce6839939b08,
    0xbff504d98bf45846, 0xc004db3635026a69,
    0x3fe8dddcb3f389e4, 0x3fe46eef980cb636,
    0x3fd4d57fde904bc8, 0x400aaf073819eeb4,
    0x3ff7d86f1dc11d36, 0xbffc6bd77237cc00,
    0xbff538e36fa9c460, 0xbfdfef0aecc8f5a4,
    0x3fef15f84f583862, 0x4004b676172d2e5e,
    0xc0030f71fe691ade, 0x3ff16a76dede27c2,
    0x3fc1c491c9a93ed8, 0xbffad158907647e6,
    0x40018f17f0695fd1, 0xc001c35f6113ff43,
    0xc007334301602e64, 0x3ff90303114f93e3,
    0x3ff3d9601e39b676, 0xbff43c276ed4b72f,
    0x4006ad3af2bf55ba, 0x400f4738520d62a0,
    0xbfd18becbc8b8141, 0x400bd85bc8bdfa30,
    0xc0085a530dbb342a, 0x3ff8263c97044fe3,
    0xbfcaa41e025c8147, 0xbff935c5d1f789c2,
    0x4006e6e0a9294118, 0xc01306b3ca27fdbc,
    0xbfe0852e56d9ca8c, 0xc013fd5231bf231c,
    0xbf701365e3a9ff00, 0xbff0ed3d181c1b5d,
    0x3ffebd205e3ede39, 0xc00b4c88e7e1496e,
    0xbfe3ada08108d8d5, 0xbfd1d8b44724fb58,
    0xbfec33c722e24e7a, 0x4018cd5fdf80254c,
    0x3fe8456d6bca762c, 0x3faef25dd6abee48,
    0x4003ee7e7e97388e, 0xbfc519b8a09a2b38,
    0x3feb59a0649c28a8, 0x3fdb3c83d3db4090,
    0xc00d3969d20037d6, 0x3fef60df3d9b101d,
    0x3fed3ed6bc33ba90, 0xc006502776cd6f1a,
    0xbffec8f7bb2ec4be, 0x40080176387b50da,
    0xbff8ff28179a395d, 0x3fe7240118eec8cf,
    0x3ff153120f4fda28, 0x3ff442f2f13f7a25,
    0xbff6c31e743cdbd3, 0xbfeabc6235182acc,
    0x40117083ead04c84, 0xbffed49a9fe024b4,
    0x3fb9f001f007aaa0, 0x3ff4f5269608c6c9,
    0x3fe228d02ae45fb6, 0xc0003ab6e975ae24,
    0x3fffbe6768e89f32, 0x3fb3e6a621a5ef24,
    0xc0002bbe0bb43b19, 0xbff1c8d7fab1af38,
    0x3ff25ea00584c1ca, 0x3fe0fde5825d296b,
    0xbfef81be269a22d6, 0x3fe3a8472037bcf8,
    0xbff4d65b7b025806, 0x3ff4275ea0bc0c96,
    0xbfc7ba1b2ff76ed8, 0x3fed1bdf195a8c66,
    0x40108f1a03d5209c, 0x3fefd89ed53d8b47,
    0xc0015572ca1d4832, 0x400f4f4e61018b7a,
    0x3fe312f576fab893, 0xbff9959614eada14,
    0x3fe5ac92051563b9, 0x3fe1357084922bca,
    0x4003a08e9f696243, 0xbffb1d377261ea5c,
    0x4012f4ffeb6217d7, 0xbff24c045a001f56,
    0x3fe3432e9d905360, 0xbfca49cc028e5752,
    0xbfeaf59d06fa2a96, 0xbff8a07afa0404b1,
    0x3fd169b86a0c69f4, 0x400416fefd2ad3dd,
    0x3ff60777268c6d94, 0x3fd110e38158ba60,
    0xbfe1d7af853bc0e1, 0xbfc76882e37a6bd4,
    0xbfd071c478fe311a, 0xc0097a55c791e321,
    0xbffeaec4f2f7f9a2, 0x3fd0613beb107233,
    0xbff69f93c4e1fbb3, 0xc005b04e73682edd,
    0xbfecb1ed9da4c226, 0x4000abc8c51fe8aa,
    0xc005909875bf73c0, 0x3ff2b26a6283c929,
    0x40059ebc14ba1868, 0xbfe35d99edacaa7c,
    0xbfed138b25919242, 0x3fb973aed37dbbd6,
    0x3fea0e75db2cd3fe, 0xbffbb2906367358a,
    0x3fdc7aac73254d82, 0xc00240451a5b6a78,
    0xc00062dd84f3401b, 0x3ff4e5a338a68676,
    0x3ff1a1716a748ef2, 0x3fde02d7d7003294,
    0xbfdc24e18e4f03a8, 0x3ffd362a263ddb46,
    0xc00339661c617b62, 0xbff2923e8704a202,
    0xbff1a487432613fe, 0xbfeeadef178a2e07,
    0x4010ad56cd22f257, 0x3fe39681ac301a6c,
    0xbff125e06289b1e0, 0xc0025b920d64908c,
    0xbfeeeffa85d6c96c, 0x4007077560cc3fb0,
    0x4000837389848d61, 0xc00af2c6ca2cfe60,
    0x400c5c963bbe3797, 0x3ff28006a47c98c8,
    0x3ff98f470018f443, 0x40065410aa6b23e6,
    0xc00519b3ede40072, 0x3ffa5fa8a14f26c3,
    0x3ff4bf8823901302, 0x3fd30f699d079434,
    0x3fc1f23480c62918, 0xbff01e3636e7ffe0,
    0xbff90052d1c06283, 0xbfe46dcb2a2c5adc,
    0xbfca5a6974fbd7c0, 0xbfe2b3877b40c8f0,
    0x4001997e96209ee2, 0x400257e0b9745459,
    0xbff5a1037edcedee, 0xbfde39459f4cd654,
    0x3ff7994bc75149a6, 0x3fd8c41e9e21e720,
    0x400408cbdc980eae, 0xbfe9e114f4aa08c0,
    0xc00373639f31a013, 0xbff605da39b6c366,
    0xbfd2b415851a9750, 0xbfdfbe233b6941ae,
    0x3ff42a014b20cde8, 0x3fcd6ee6a21de190,
    0x4002bb61c9118dc4, 0xc0008394a82a65ba,
    0x4007eb8adbe10fdc, 0x3ff692102643690b,
    0xbfe9da9628e4cf41, 0x3fed5453eecc5ff0,
    0xbfd485b348c7ae8f, 0x3fc4a22ecce8e530,
    0x3fbef9657b08e660, 0x3fedbb677ac8b5c5,
    0xbfd18d2a3d7ba870, 0xbfe5e2c0fa5ca85f,
    0xbfd36a15a732f84c, 0xc009c5071d8b44c9,
    0x3fd6b3120f4a4894, 0xbff4e0460732c133,
    0x4006fbc28cf0a958, 0xc00328e11f3adbe4,
    0x400a59800b66b31c, 0xc01b1f41b85aee63,
    0xc00915796aef6f51, 0xbffa7fbfa5aaf074,
    0xc00385192420e099, 0x3fe00d3a4717df32,
    0xbfd01910f15bd7f8, 0x400ee48871306946,
    0x3fdb1f780e6f252e, 0x3fe2ae58a1f3d1fa,
    0x3ff1b341d9be0284, 0x3fe3040b346875f8,
    0x3fc59d36eea855c8, 0xc013665b915476a7,
    0xbff7074d8ea0de2b, 0x3ffe6d781e5f60ca,
    0x4007f7ab927c0e02, 0x3ffccaf6801908c4,
    0xbfe39887c9c82f29, 0x3ff54f7bdff47b3d,
    0xbfff05faf80a9516, 0x3ff9f150a6e2c280,
    0xbff2fb7f44413632, 0x3ff59c7e716fbd84,
    0x3fb3be8e98466f28, 0xbfd277c76f0a6f46,
    0x3fdf4b61d53787f8, 0xbff6f887b8508858,
    0x3fe55223624acb40, 0x3fe979a8dd83cf75,
    0xc00064011024d7f6, 0xbfffee3654e221fa,
    0xc01175c4a66d4f66, 0x4000710291915ab7,
    0xc01078c3f03c2782, 0xc00b12fe3279603a,
    0xc00e3d81f9df73e1, 0x4005f76add030a9a,
    0x400e637e78b6bb1c, 0x3fdfa2caed1f9a7e,
    0x3ff42925712aa692, 0xc00683aefcdafb0d,
    0x3fd324713b0d8f78, 0x3fcb5c222bd42578,
    0x40136c3973119be1, 0x401061e424a970c4,
    0xc00e923f0fc18096, 0xbff1c0dd464448f8,
    0x400393dc9123655f, 0x3ffc5d563cd0028d,
    0x40028e9a8f1093b5, 0x3ff5e53764371585,
    0x400121fce021755a, 0xbfed7504921205f3,
    0xbff7562da5ab92a0, 0x400a6e20d8634598,
    0x3ffe7bfc88801eee, 0x3fe49b1d317a4849,
    0x4005463c5df413da, 0xbfcfc69160be2df0,
    0x3ff21ede8863ec94, 0xc0088e55b6a7c9ab,
    0xc005bd17eb2bbcde, 0x40110d56ede632b8,
    0x3ffed60d32599384, 0xbfb016b489eac3c0,
    0xbff63f645d046bd9, 0x3ffe8ae10c1e3f0b,
    0xbffec1e51337e7e6, 0xc00440af36d741dc,
    0x40019e270aca6522, 0x400b131ee0dacf42,
    0xc004106356af7a00, 0xbffd1d58d13c7011,
    0x400cd9cc43b22274, 0x3ff312a90e6ec80f,
    0xbfd1f9791550762c, 0x3fe7419d872c8df0,
    0x3fd82c8b3268a898, 0x3fc386deaba2ff28,
    0xbfed34299c2687d2, 0x4003f78b10a8b064,
    0xbff2025027e424b6, 0xbff7b00d0cca005d,
    0x3ff7e418ce64436e, 0xc00ebe86992aa676,
    0xbfe76d6cbbc58267, 0x3ff69fc1f5a7c093,
    0xbffc4138758a75d3, 0xc011c99e3766ed3e,
    0xc0098de5cdaec202, 0x3ff42e5f53047e60,
    0xc0111f95a25ae1c2, 0x3ff67c04a628d4da,
    0x4009b8d3b353731c, 0x3ffe37163b2f90e8,
    0xc013fd3dc6f226a5, 0x4000d53fc7e1bd98,
    0xbff61bae351c9bb1, 0x3fe5dad1754511df,
    0xbfdf9824284ae89a, 0xc0124edeac3fb0c7,
    0xc005b124424c5777, 0x3ff9bde88d86c561,
    0x40002e564a570422, 0xc00c966d43cdf2d0,
    0x3fd9f469c0066bf4, 0xc010b857d374fd3d,
    0xbfdf623b1a099902, 0x3ff691ae934a399c,
    0x3feecb30c10076fa, 0xbfe6389673d33f29,
    0xbff6154af25f7a69, 0xbfeaf3d28ae90d31,
    0x3ffa1403eff03920, 0xbff0b99d50d9a736,
    0xc010498562ef4462, 0x3fed538b9314cbcc,
    0xbffa1015d3ba21e7, 0xc016162a608bca6d,
    0xbff87c148a36a2a6, 0xc00245cf3ceb6a95,
    0x4017f6916d074ab6, 0xc007a11cea35de0c,
    0x4012215a791da537, 0xbfe32e6c4bb9d65d,
    0x3fdfdab130432db4, 0x3fe68971cdceefe7,
    0xbffaae6df719f121, 0x3fcb5a5e30fa593c,
    0x40144f446b2b003e, 0x3fc39912daa0f310,
    0x4003d3540636c49d, 0x3febe1efd15c48c6,
    0xbfe69140269c82a6, 0xc00151bf49d6eb3b,
    0xbffd613dac38c7d3, 0x3ff4e01cf022892c,
    0x400c9ee42b084f29, 0x40107dc2e6ed0c9c,
    0x4002278b6281252a, 0x3fe2e14882110572,
    0x3ff3256637c08ce0, 0x4006a6ce0f82c460,
    0xc006d501a8497e5c, 0xc01c0c609cd512c3,
    0x3fe0f5cf8d276928, 0x3fe3a73ef049d146,
    0xbff28475f51d2f3c, 0xbfde6ded916722ad,
    0xbffd9546ace98fd4, 0x3feedb1c72d39bcf,
    0xc001917f5bd88321, 0xc01285002311d2b6,
    0xc00c716354ec9a05, 0x3fd786dc7c3f1234,
    0x3fd47e9e22ddfa1b, 0x40002e6d3ca0651c,
    0x400a9ae95d8b4ffe, 0x3fc55faf8bb27382,
    0xc00aa5147880e8b4, 0x4011bd4fc9ed4052,
    0x3ff58843c26351b1, 0xbfe8518d77eadd68,
    0x3ff1609154f78407, 0xbff6913b5f54f860,
    0xbfd2c4a96397dec8, 0x3ff959c37ea05e15,
    0xbffa38592f55d17a, 0x4003dadc182b617e,
    0x3fe8bcd13559a59c, 0x3feea3532695d38c,
    0x3ff4c9466fec853e, 0xbfe2d396950b732c,
    0xbff8860d470190c2, 0x40011e573374d0da,
    0xbff2990972e795e2, 0x3fd036be1bd200ac,
    0xbfd7cd008031be38, 0x3fd9712fc101ba57,
    0xc006d46756131aa8, 0x3ff43415d16fcbac,
    0xc0041b317c194862, 0xbfeb91457df540ee,
    0x3fd33a777ec32816, 0x3ff7553babcebcb5,
    0x40000a0fed1a2252, 0xbff816ad1a837ac4,
    0x401298eafa175606, 0xbfe8b473e24a467e,
    0x3fb9261ab5b09bc8, 0xbfc7660d6994413a,
    0x401118d3e5847ce4, 0xc0090c430f3a372e,
    0x3ff5f07b6d312c75, 0x3febde4fdab7e538,
    0x3ff0b273f8396427, 0xbffbd64bb2241d8a,
    0x40070caa0edb31d0, 0xbff5e816f8cfd0a8,
    0x3fc2499d1877575c, 0xbff5693724b5d569,
    0x3ffd6f7dc5ac312e, 0x4008fa83ffbcb500,
    0x4007c20b510456b9, 0x3fe0e5c9f2ebe841,
    0xc0037c020efb4a5b, 0xbffebb9ea85ae9dd,
    0xc00026c3e2c92a2d, 0xc006dc84929cbcfc,
    0xbfd024c6c3005cf8, 0xbf9ac5474b270700,
    0xbfea58f6396bcfe4, 0x400ad9fa7dbd2e8c,
    0xc0062f6b219a19f6, 0xc005481d21d8e46c,
    0xbff0671192284212, 0xbfc267273b5b249a,
    0x40014b89780d1630, 0x3ffbe5290da40ab5,
    0x400a388dc52a9f8d, 0x3ff42e53a5050910,
    0x3ff8cd988748ce8d, 0xbfe0cc9e3af81c8c,
    0x3fe2c423275438de, 0x3fac3b6b91c80420,
    0x3ff71ae398917144, 0xbff32f02347e0eac,
    0xbfec987646c8fb1f, 0x3ffc942fd8312e5c,
    0xbfea123ea597b682, 0xbff4499025ba4724,
    0xc009c057aac36d9b, 0x400882f227f06714,
    0xbfcdbe8b81f9b504, 0xbff9898509e6d35c,
    0x3fcf8fd4c15feea8, 0x3fe58e709bdb5f60,
    0xbfd6e1366b925838, 0xbfd3d99286ce2880,
    0x3ff46d06390e1231, 0xbfc4a27ed0369fd0,
    0xc004664a40157c64, 0xc018ca7b2096fffc,
    0x40063577219fc2bd, 0xbfe1342164dc3472,
    0xbff5e5bfd8052552, 0x3fe91ec8911f980c,
    0x3ff237d9d1078d66, 0x3fa4089d0b78fa00,
    0xbff815c1e08920c0, 0xbff7869752c82160,
    0x400da2d979639b32, 0x40038bc40e9e85e6,
    0xbfc7cb1a314f6970, 0xbffac1a8bd95794c,
    0xbfea304dc4e4053e, 0x3ff272a5184762df,
    0xc010a627c39e7b24, 0x400901a1ad440416,
    0x3ff25e8a8ba5fa2e, 0x3fdba83df9396868,
    0x3fe8a9ee51ca2c7a, 0xbfe31248f03da32a,
    0xc01693a905b0e395, 0x400212732977259a,
    0xbfb9607c920d5ac8, 0x3fb066e990661c00,
    0x3fc49dfa77141584, 0xc001eb8e5de7aaa4,
    0x3fee69ac37dd590a, 0x3ff540f69656c606,
    0x3ffb816d17ca302f, 0x4003c0cac3179d4c,
    0xbffa6c618e90df32, 0x3ff3723fcfd5c8c2,
    0xc01034d1a05cb02e, 0xbfd57f2e7a0d7e8a,
    0xc00d8df153a4cac2, 0xbfd4b75bde076b90,
    0x3ff9357f9e56e2ce, 0xbfd6760d35899208,
    0x40031288a7b3c35b, 0xc005fef479bbc106,
    0x400611225a14d1b8, 0x4003b1e63b978642,
    0xc0059114308f1c12, 0x3ff9b4b8ea433e4d,
    0x3ffb37f57e2ab6b4, 0x3fd53a9c88cd6da0,
    0x401a69dc173804b7, 0xc0000f1458a7b626,
    0x4009479786511876, 0x400cd963043d0875,
    0x3ff264a2637b43c2, 0x3fd09abaf330aca0,
    0x40123bc50f383b70, 0x3ff33c98fa23442f,
    0xc008a7998d514fb2, 0x40051f84c29d70ea,
    0xbfcc577fcffbdfd0, 0x4002cabe3a346654,
    0xbfe055e391e4d7c8, 0xc001130241dbdeb2,
    0xc011b48e4e3a3941, 0xbfd0660710be5cf4,
    0x40129cc12392126b, 0x40139511fc0c542e,
    0xbff2f34bc7bd3764, 0xbff262c269f81462,
    0x3feba3f01a663be4, 0xc006e195bf613e5b,
    0xbfe129a16799aa03, 0x400625f546868922,
    0x3ff82178b8e7f2d2, 0x3fe465b26e2bf87a,
    0x3fd596009384416e, 0x3ff734708a14c47e,
    0x3ff0e40b0ecbce61, 0x3ffeaa4d179203e5,
    0x3ffa9ded8044b87c, 0xbfe22c7182e5009c,
    0x3ff08827267e7d92, 0x3fef06740346dc4e,
    0x400eacccf8980afc, 0xbfc2418e6750d37c,
    0xc0070c5df10af412, 0xbfd2e6d71eddcbae,
    0xc0061da214ac5888, 0xc012027413c82d98,
    0x4019231ed2fc713d, 0xbff5148296d483fe,
    0x3ff052d8d9817612, 0x3ff1f448e2ca15c0,
    0x3fed08c2cf7eb780, 0xbff7e2c71ab7e886,
    0x400510d1a5dfd1e1, 0xbfe753aca6d69959,
    0xbfb1e14ae915d058, 0x400547c7c3dc301c,
    0x3ff93371365b2d06, 0xc00575309f19e417,
    0xbff5bb7d88a445dd, 0xbfced7aed8cdc403,
    0x3ff447c72bd077ac, 0x3fea4d671abf765e,
    0x4005414c074301ae, 0x3fec0f603a94d309,
    0xbff06764630b7294, 0x3fafbba36d7b4570,
    0x3fe28de89ad6c9f4, 0xc000feb1261220d1,
    0x400e553d7f3f91c8, 0x4000c3469ff8d73e,
    0xbff4523da2d4c9f0, 0xc000b36d4042cf39,
    0x3ff22fd5c204f206, 0x40042aa636d865d2,
    0xbfbe247387a57888, 0x3fc40c0d766ebac0,
    0x4004593b1995f982, 0x3fd7225f38993bd9,
    0x4001bae9583e7d22, 0x3ff19d4cb434a4a2,
    0x40075d3d91768e55, 0xc00318550fdd9744,
    0x3ff4bea9f8f13b83, 0xbff5a371cd96b32b,
    0xbfeff0defc2921c9, 0x40001659d6cd68a0,
    0xbffee1cb749d237e, 0xc005aec1e1cd840c,
    0x3feb3a7643cf10dc, 0x40048039d2220008,
    0x3ff9606ba45c09b2, 0x4012836d772febf8,
    0xbff3e4f8b9ce1a82, 0x4016878d200a350e,
    0xc000110e1fd4e6b1, 0x3ff68d969e259860,
    0xbfc0f6ee7ff844c8, 0xbfe0faa264458110,
    0xbff869ed50b54b18, 0xbfcc2a3f21dc0740,
    0xc008aab299cb852c, 0xc0049131fa0cef58,
    0x4009f9752bdb4d0a, 0x3ff08a271e962292,
    0x3feceacb574c0306, 0xbff26666155dc432,
    0x3ffaa8bef32be926, 0x3f95f7efe390a000,
    0xc00be9c757c7bb52, 0xbffea2d52c69c02c,
    0xc00294cba63c708c, 0x40083ca83a7a3a2c,
    0x3fe2c0c39b7863ae, 0x3fe064019990b9a9,
    0x400f14dd3dca7cb2, 0x3fb8dfe0c779f610,
    0x3ff2842376f76ec7, 0x401183e3b0a00051,
    0x3fe1b5ab51553b7c, 0xbff5e360f72a07ac,
    0x4004c2b5a1521a02, 0xbff3bd302fab9b12,
    0xc00ab90e421f5e62, 0xbfe9cdcf63072992,
    0xbff858c5710d1f11, 0xbff7618f2ae5a6f8,
    0x40047ff188a56895, 0x3fd1820e386637c8,
    0x4006c94fd620c5fc, 0xc005f942e16abc48,
    0x400b6b23ebc00af4, 0x3fc047735de75a18,
    0xc004df0b0577b47d, 0x3f48fb87c0f77000,
    0xbfe574e1f2d9774b, 0x400b6b2000e88ba4,
    0xbff92fd6e358cd00, 0xbfd98059b1f10912,
    0x3ffb03eae1b53f0f, 0x4010cb03425cd080,
    0x3fcae9aac1a26b94, 0x400a4f053b83c7da,
    0xbfec0899a2410522, 0xc0037d71aec18bad,
    0xbfc352ffded7bfe0, 0x3fe7b9a1d300a3ba,
    0x4002ce9cf6cfd8e2, 0xbfdf1fbca2987983,
    0xc00bc8f341a244c9, 0xbfe058c3db166394,
    0x3feda66d1eb4a8fd, 0x3fec7183be35ed5c,
    0x3fd5315149984ac1, 0xc01554e13d261639,
    0x3fe72afcc0070b87, 0x3fe0a1bd515276d8,
    0x400280ef3f6a9e90, 0xbffc78f8c4ba1b36,
    0x40020d05e4705830, 0x3ff92fcd5d844ec6,
    0x3ffabef6c6342d72, 0x3fc0bff2169b3068,
    0xc012982e68e88282, 0xc00d0f75d3d333ca,
    0x400b348d8c7fe4f2, 0xbfd93c452e6b63c4,
    0x3ff15d20b3fe706d, 0x3fe819aff4369757,
    0xc011c5ff31a9a1d1, 0x3fc9b119adc970b4,
    0x4001bba9541b5327, 0x3ff563f86f6d90b4,
    0xc00f5d568cf703ed, 0x3ff08162c76441ff,
    0xc00126e2554f512c, 0xbfbd3dda63f8c960,
    0xc001a39fb734224f, 0x3fd035d0b9d4b4c0,
    0x400791a1bbb53dd2, 0x4004c72acfc6904a,
    0x3ff255ad58e56fa6, 0xbfe811ed7d516ea8,
    0xbfd7d2a3b65b884c, 0x40002dc9e2f9227c,
    0x3fdc210029f8df68, 0x40036fc159a69fe0,
    0xbfdc61af489c6de9, 0x3ffc33dc02ad35f4,
    0xbfd366555c27858c, 0xbfe1bab240ab40ec,
    0xbffb934501bf09cd, 0xbfd116142dc03a74,
    0xc00e0441d4879f2e, 0xbfb46ef496472870,
    0xbffcac84c313d320, 0xc000ce9f6f79eaa0,
    0x4006cd9f013aa8e2, 0xbfec7d4613c2f2ee,
    0xbffc934ed3bab518, 0x3fc4958109a28d48,
    0xbfe6729781524f14, 0xbfe52a1380aecbad,
    0xbfd9d70776b4a0ea, 0x401383fbd0f7467d,
    0x3fd623aead1eae4a, 0xbfecfe3ab93e37fa,
    0xbfd8ef81b35bfe25, 0x3ff9ca9aa81e0b4a,
    0x3ffbeb92683fd8ae, 0x3ff4291e12f241e0,
    0x4010b7f9de7d9506, 0xbfdf4c35ec8bac04,
    0xbff826a51d67111e, 0x3fe91756f2530410,
    0x4015e927b3f0ba87, 0xbff677f630d4dbe5,
    0x3ff0c5f505e76718, 0xc0076b64284168a8,
    0x3ff20d06c3896228, 0x40021b26bbd67eac,
    0xbfe46ba8901057b0, 0xbff34e3b9341aef5,
    0x4000388ce014e178, 0xbfd90c0a7e92412c,
    0x4011427a8dfe949b, 0x4003f022b7351e8f,
    0xc0009b01f57b2708, 0x3fe95f01df64c11c,
    0xbfc21e88ae7e7500, 0xc0126e0ecbfa0dde,
    0x3ffe3e6c7a7793d6, 0xc006b922fbe6f357,
    0x4006a8c9a484de37, 0x3ff02fe730d4a195,
    0x400bf61bfb46a70a, 0x400818f1cdf0929e,
    0xbff93bf12bc9e45e, 0x3ff93605e867594e,
    0x3fd8809700cced94, 0xbffdc95bb46e9b3e,
    0xbff9582fa97896a2, 0xc0125ad1a78feeb6,
    0xc009c723eaa0e11d, 0xbffb62a5050ed19c,
    0xc0102062556f58e7, 0xc0157b758a983552,
    0x3fa679e8155ce980, 0xc00cfa1180bfad6a,
    0xc00484b5e4f413f9, 0x40034b94b14bf7cc,
    0x3fcd57646051c0e0, 0xbfe414e275ecfa20,
    0x4011b5bb61c6b4c4, 0x3fff3b1be79523a1,
    0xbfcc476f38077b30, 0xbfe097d305a20b36,
    0xbfdef32a9034c20a, 0x4004006482be7012,
    0x3fddb095f4af4082, 0xbfd0e9c1a960b729,
    0xc00dbbe77daf8773, 0xc0031456dc26383c,
    0xc00b5dfff09c39ac, 0x3fe43dd5ce56f6c4,
    0x40035ec2788831e8, 0xc002819f10ce2c4d,
    0xc008b6df398bf7dc, 0x3ff5996e397a0b8b,
    0x4010817a9f2b2b7c, 0x40156ff654e7f370,
    0xbfbea79394ca839c, 0x3fe87c2a16f0e1da,
    0x4013cc000f0b1d89, 0xbfeca985a6a30fec,
    0x400822101fde8103, 0xbff74e0596f72d35,
    0x4003499688667ca9, 0xc00368870235660c,
    0x3fda8cd3d565b070, 0xbff03d0a999f91b0,
    0xc013e8556a5ee6f9, 0xbfecc4b6e72b660a,
    0x3ff72893461d449e, 0xbfdf2cf08345c6a4,
    0x3ff800220c054ec8, 0x3fe94093bb8e215c,
    0xbff678fa9746f1e6, 0x4000166c3489e6f1,
    0x3fc709755dde54c8, 0x3fe36ccedba0e59f,
    0xbff035b7f8ea8395, 0xbffeca031c4d7031,
    0x3f8f459104f35100, 0x3fee77336aa21b7a,
    0x3fdf48b62da94ec0, 0xbfff36a16ad41bf7,
    0x3fe1dedc703e72fe, 0xbfe3fa8613710c1a,
    0xbff982c57c7e4a9e, 0xc008da1a7c8fcec1,
    0x4011fc33e6a6a2e6, 0xc0071960c5ab9ab0,
    0xbff0ac9f38235d0e, 0xc01834051d4ed687,
    0xbff2d73cff311536, 0x3feac7104a2ad216,
    0x3ff173501ac080f6, 0xc00639cda01dd088,
    0xc004cfcb0627f661, 0xbfd6398b090065a6,
    0xbff183662a798f7a, 0x3fed8680f250163a,
    0x3fe58a426a8a989e, 0x3fe5456bb52331ae,
    0xbff0f3fc27e0600f, 0xc001622dcba8f301,
    0xc000eef9a66515ba, 0x40052077f68ff53e,
    0x4007242ae9b25568, 0xc009b28528ca9e6f,
    0xbfdee94a6dadc1d0, 0xbf870db00cad4c00,
    0xc00719c60722bd46, 0x400e3287c6ffc3d6,
    0x3fe8bcfefe5aba58, 0xc0103706e77bc2cd,
    0xbfff8422722e67fc, 0xbfe2369c7b4c677b,
    0x400224b054eb3725, 0x3ffd92099aaf834b,
    0x4007b655d0aadf2c, 0xc000ed219fdc0a65,
    0x3ff400de55896315, 0xc002c65254dc51ae,
    0x3ff66c37815df49c, 0x3fff90916bc70990,
    0xc00e56bac7d69a10, 0xbfd4171b09c19c1a,
    0x400cdd1ede650d1a, 0xbfabebb026495b40,
    0xc00d8c390c002471, 0x4004aeff8f9fff7c,
    0x3ff08ec91b50efcf, 0xc0120dc1b740c890,
    0xbfe69442e598d79c, 0xc00486559e86a2a4,
    0xbff1ec83bdebbe43, 0xbff562f6e97c77bc,
    0x3fb144e095435b30, 0x400cf66e34e9295c,
    0x3ff6d1a30a02f074, 0xbffb1d167d37faa6,
    0x4000cbdcd4b12047, 0xbfdf62a85db39264,
    0xbfe342f67a0a0d0e, 0xbfd6207af8f1d608,
    0xbfd13c39d762aee6, 0xbfdf38f3d324e5ca,
    0x3fc40d54d3c4b470, 0xbfcc9b85c6cbdd90,
    0x3fea118833dcd14c, 0x3ff11e92c1f517d6,
    0xc0081a793cb7bca5, 0xbfc1591455b21bb4,
    0x3ff22ad7e401f432, 0xbfe8b75290be4a32,
    0xbfd0a20cd8ea2554, 0xbfe9d239d9a93e38,
    0xbfd82236d36fbe10, 0x3fe6232b72d00cde,
    0x3fc6a1818317df70, 0xc00273180e834c6e,
    0xbfe7363d51745ee8, 0x3fefa4647e66d852,
    0x3ff7dd4803c56316, 0x3ffbba64bcf774b8,
    0xbffb9d4c7d60ce1b, 0xc007589a4946fd62,
    0xbff608fc4c6406eb, 0x3fec0bb7435058fe,
    0x3ff083f049ef1c9a, 0x4008bd642fa23cb2,
    0xbf6fdf4032bbac00, 0x400c1ce1d0fdf05c,
    0xbffbc3ae8e7b7be8, 0x400b1cf5c807cfaa,
    0xbfe0cc4f2476d115, 0xbffd97bd4a2dfc60,
    0x3ff523d29395f27e, 0x40065d441f1be446,
    0xbffc3f45bf0748de, 0x40123e133682a37a,
    0xbfe2187218fa9329, 0xbffa55c2327a3084,
    0xbfeca086678a62fe, 0x3fe9c55c31a0ed59,
    0x400dfb69589916f3, 0x40000cd3817075fa,
    0x3ffad82f799ea148, 0x3fec3780b5999d92,
    0xc012166baddb16dc, 0x3ff85b2eb0308c72,
    0x3fe4854bbe26793a, 0xbfeed328817fe7ac,
    0x3ff22a743c9d1551, 0x400bb40c7c2b17db,
    0xc003d91e75a6d52b, 0x3ffe0678a886bcd3,
    0x4000b0f17c12f0ee, 0xbfe850db91876e67,
    0xbfef53f148ba6cda, 0x400558634d18dbbe,
    0xbfdbd0c044daf657, 0x3ff0786e33693df8,
    0xbffa6ab1565aa3ca, 0xc00432b8ba2952ac,
    0x4006f954c4048216, 0xc0165f118b3a78a8,
    0x3fe223059c6a0585, 0x4001787750c56f71,
    0xbfd7da7e875aefd4, 0xc00498f1863424e4,
    0x3ffb17e71052fae8, 0xbff0f8235e4656d2,
    0x400e68b4668cddb9, 0x3ffaea8cdca7edee,
    0xbff3f56d105089d2, 0x3fd6eb7a68356712,
    0x3fdef642c741f438, 0xc002a3b05e14cbe5,
    0xc012d6de173469d7, 0x3ff5ad5c4c85d462,
    0xc01a0c9f0290c1db, 0xbffcffc9562d6dce,
    0x3fda5e0645d13c53, 0x400f93b29e92a78b,
    0x3fec41c79f351f83, 0x3fe568fea588dd44,
    0x3ffb4d9e0e1455c7, 0x3fdaaf7136ab52a0,
    0xc002e7883a2b179c, 0xc0009af95ae4e4fd,
    0xc012455e2baddf71, 0x4002b0cab75ea766,
    0x3ff9904b5f41f1b3, 0x400ee8d1245b10bd,
    0xbff891a8735cdeef, 0xc00055b358a00bee,
    0x3f9280f634cace80, 0xc00cf40d96605081,
    0xc007e912d39e77da, 0xc0093f2c188bdc71,
    0xc0046f1f83f6a500, 0xc00a4ae019f1a79b,
    0xc012aa454bf6b2fe, 0xc00b5a15deda612f,
    0xc0012d091e9fa17b, 0x3ffc9b88c08d4938,
    0x4003009b8d0089b6, 0xbfed629938eba9fa,
    0xc00738a937551b0f, 0x3ff1bb3c5010e93d,
    0x4003d9ab8ddca7a3, 0xbff7bb146e227a70,
    0x400b7ab36ca7611c, 0x3fffb66531289157,
    0xbfd98cc5529993d2, 0x409666fc4e690dfc,
    0x400550afc0e1c366, 0x400573374f8098a8,
    0x3fe936c53999019a, 0x3ff254051b85d81b,
    0xbfd458326608f7c0, 0xbff4a26ae0e591fa,
    0x3ffd551af00e1877, 0xbffddc466964a790,
    0xbffda2e70d630f61, 0xbfffe94cd399bb6e,
    0x4008aa906d47492c, 0xc002257ffb637c85,
    0xc00d99efc725a34f, 0xbfe0438cc7b09246,
    0x400c5aaff1f80cee, 0x3ffadc25acd46e1f,
    0x3fea72727f83118c, 0xbfd07123d64db127,
    0x40101d431d07514f, 0x400cb78cbe096048,
    0x3fbcb9a4df218f50, 0xbfa5a653e63f3620,
    0xbff7929309a39fa8, 0xbff22c176ea42c8a,
    0xc005ba09292583ae, 0x4005712c1a5a8ff0,
    0xc00e7dd2c7e3f41b, 0x4006ee5df84ac04c,
    0xc007937ebb7bda5e, 0xbff17bcd912c4541,
    0x400c052d966802c8, 0xbffbaedf441fea2d,
    0x3ffd4470eaaae43e, 0xc002a1df25b75482,
    0xc0018f78c34b1714, 0x401495206b64d808,
    0x4009732cf5d0b000, 0x3feb35489a829977,
    0x3fd3f1c7fc46095e, 0x3feaccf9d0b2ea0e,
    0x3fc2ece985b5edc8, 0xbfd77d8178b6ea24,
    0xbffa3b14875b9370, 0x3ff871bb570c6e3e,
    0xc00bb3c8bb10e320, 0x4008e881bb90aeb4,
    0xbff448406fe92524, 0x40045df85b4fba1d,
    0x400cc5a3c3cd7972, 0xc00884cfe9a65037,
    0xbfabb9ec32f98870, 0x40056df5b3945be2,
    0xbff8d04c57cd09ce, 0xc00764dbbd9d4af3,
    0x4013260a439ae5b2, 0x3ff20fa077133907,
    0xc00619d09c4c35fa, 0x3fe26537089463bc,
    0x4013b1a3f5a496d5, 0xc01421f88b902107,
    0x3ff3a7eb6f54ba06, 0xbfcb4d31dbd89c7c,
    0xbff23777ce6798ba, 0x3f989e8efb2dd040,
    0x3ff59ce6aa1b48a2, 0xc00506340f3647e5,
    0xbfea912f675bd58c, 0x3fb793b64b023a00,
    0x3fdd127935614d5c, 0x3fee1c27619eb7e0,
    0x4013184c0bce04f0, 0xc0109c8006c9d97e,
    0x3fe5884438cffd44, 0xbfd467d8c3d1d818,
    0x4009b6469e5bd13c, 0xbff34c3fc82717ce,
    0x3fe11457b89b8a57, 0xc00b00c9a85fd9d8,
    0x400835e1683d7880, 0xc00436c664c99f96,
    0xc00588a41985d7d4, 0xbfd89904520ebb6e,
    0xbfca74f6e92b2678, 0x3ff1661411d2d32e,
    0xc000d737cfa1cbf4, 0x3ffa68d26d61241f,
    0xc00be4d858f4d56e, 0xbfe154fb65569296,
    0xc00532158d35b2f1, 0x3fe3a367c1608780,
    0xbfd1d9fba8269042, 0x3fdaa321021b5d97,
    0x3fd7243ef9a3c776, 0xc0126e8fd6a50bf0,
    0x3fde397ea33d8dff, 0xbfdd058b4474eda1,
    0x3fe1aab08893dbd9, 0xbff948128d34c8f9,
    0x3fe6defd9405ecfd, 0xbff5482cccc0238e,
    0xbff53669ecca7c85, 0x4002c3c5db03432c,
    0x3ff86ce6121d6a8d, 0x400a9429f8ac7f30,
    0x4008a411881bf5d3, 0xc01a9a48a7fbf70f,
    0xc0118de683b948db, 0x4009be6cc9e9b498,
    0xbfc5136198536c38, 0x3fe573656b7c54c5,
    0xc0031c131a05abf6, 0xc01846b5b0acee2c,
    0x40014093718a38e6, 0xc0043aa99dd182e2,
    0xbfdf3572887e45c8, 0x3fbd24d3526de1a6,
    0xbfd5953849d2f55f, 0xbfe496fa18f241ca,
    0x3fdbd2c539fc6d0e, 0xbfdfb3ff6a1ed55e,
    0xc00f70198b03008a, 0x400cc9a9a36be619,
    0xc0098417ab5d0dcc, 0x400c57fd58e3c49d,
    0x3fc1eae7b93daebc, 0xbff29c1d7bfdc8d5,
    0x3ff1eb335db63fe8, 0xbfe123a3d5a03304,
    0xbfeb24fd1a9f78e3, 0xbfd2a10a1ead0d40,
    0xbfe24c267570ea16, 0xbfed416ed66479c9,
    0xbfdfc19f4de1b9ae, 0xbfe1ccba51c07fa2,
    0xc003d0de740868aa, 0xc005ff5c629dfbe3,
    0x4005553c26a462f4, 0xbfc6cb638f9213f0,
    0x3fe0a94e4083809b, 0x400f9a41f1b0e53c,
    0x40018e4d24c46bca, 0x3fd8dfea0ab34c84,
    0xc008f2c5fbd4045c, 0xbff0cae02f3c4d3b,
    0xbff0bd4b32142b11, 0x3f7ae2f1cd533300,
    0xbfe890f6d667137c, 0xc005cbf028b0d96e,
    0xbff139ea6e9bb988, 0xbff5bc4610994146,
    0xbfe19cf02a65c8b6, 0xbff51fd330334030,
    0x3ff35fbec069d64b, 0xc0045b810908710f,
    0x3fdf0b9ab61ad690, 0x3fe7773086c5d103,
    0x3fbed0d0269b92e0, 0xbff13ad3d7578b70,
    0x3fefd15a4ed8c9c0, 0x3ff9618304ca0150,
    0xbff7c65a5f26ef35, 0xc01406275c86992d,
    0xc0038628583c537c, 0x4001c7b4ea2bbce5,
    0x3f7c5f7932e2d120, 0x4010ed2e98915bdb,
    0xc002db4b8b8dfb48, 0x4010f95d83c54e90,
    0x400e9c21fd068851, 0xbff9b5ae34685594,
    0x3f7cc4fd0e133900, 0xbfea478b6a20639a,
    0x400be5b601b2dc7c, 0xbff5c6ed2fb7c8fc,
    0x40084eb9db9770d4, 0x3ff08ac0a946cba8,
    0x3ffa8d84ee24d82a, 0xbfe29cdfbb5d398c,
    0x3fed49c82fca34f2, 0xbff8837811efb5ba,
    0x401056ab2a6fb5df, 0x3ff259e0f6bc9a3e,
    0xbff56771c04e887f, 0xbff7a1aa51c3c7b8,
    0x3fff03811c762f22, 0x40018d77fe08d807,
    0xbfe33a72878f26a4, 0x3fe69aa4ccc03800,
    0x3ffc192eaad0c952, 0x3fee531bdd3b1f5a,
    0xc00cb0459dd8f9f7, 0x3fbceaf46ca5e948,
    0xbfff12c6e1ec56aa, 0xbfd6006e9867481c,
    0x400a0be9a8ada04e, 0xbfa8bbe2af5a4260,
    0xbff1290a91c57810, 0x400c6e72d9b4c484,
    0xbff57f3cbe3bae75, 0xbffb2b0855dbf348,
    0xc0010bec1ae8910b, 0x3ffe07e39d2d9e11,
    0xbfe08aa7f2c7d32c, 0x4012119c7e4c2978,
    0xc007131f4ea2f594, 0x3ff4f58b4eac50e2,
    0x4005d0cdb0ad4ff5, 0xbff403d17469a819,
    0x3ff4a06986b780ea, 0xbff05bccaa8b86e3,
    0xc0007ba318be5d5e, 0xbff3dc756e20b7f6,
    0x3fe8d8989a47b4b4, 0xbf8d18357cb92d80,
    0x3fc3678ec639dd00, 0x4008468352313f91,
    0x4007b56a9fa3eabb, 0x3fc5964cefee3191,
    0xc015985cb0c254d4, 0xbffe1238be75feca,
    0xbff50367d0e83e25, 0x3ff6dbe91f31b8f8,
    0xbfeb300fc3f29f98, 0x3fde9fe9832c5a18,
    0xbfffe1b16d4d59f2, 0x3fdac14ea45007ac,
    0xc003d25d2c64268a, 0xc006b9843e43ee50,
    0x3ff148cf67c3c9ae, 0x4000564f5c0815d6,
    0xbff3dfc3a3c2eeee, 0xc00bf6f4ea3a5bcc,
    0x3ff44bacc539ba1e, 0x3fdff48449dd2b24,
    0xbfe33f59979dbd02, 0xc005b6e0e22b505e,
    0x3ffc4242356b01da, 0x401479c118977020,
    0x400177d9190dbe0d, 0x40158b128de79760,
    0x4004aa00b3daa800, 0x3ffa2f1bb8bc0e0e,
    0xc011659e08931045, 0x4009c459480b37ec,
    0xbfeeebe792dc5bb0, 0xc013d46a62ced144,
    0xbfde95ed168d8416, 0xc00f7479853a0935,
    0xbfae9c65235cb1a0, 0x3ffd26d15585cba0,
    0x40107654f588b34a, 0xc00290993b7e7507,
    0xc004090ed35a6f9a, 0x3fcba547823a6834,
    0x400b26fdf78b41ca, 0xbfeb1e5f4d24a3c0,
    0xbfb6d1661c50911c, 0xbff4b364b0ff58b1,
    0xbff9240e25a3d70a, 0xc0014af734b412f8,
    0xc000130607fb29a3, 0xbff3b124c7f517f5,
    0xc01b8188340bd88a, 0x3f58bba84976a000,
    0xc00221b93e151a12, 0xc0074400b067f8c2,
    0xc00f111e3548bc5d, 0x40018b19890e9ca7,
    0x3fec88dc8b79a7b6, 0xbff57080e228ade2,
    0x400361251a2e771a, 0xbfd03531a19abedf,
    0xbfecfab4b2b46c0c, 0xc005d073925cf1de,
    0xbfce09f0ade800f2, 0xbff55219d8f15855,
    0x3fb37ad79cd1c1d2, 0xbfe7f0b53852ff9a,
    0xbfdc899c4d0934eb, 0x3f7f800c0be58580,
    0x3fb414851fb9b226, 0x3ffe0725e7d062df,
    0x3fe1b4453d4f052c, 0xc01021db778f245a,
    0x3ffc84fbb353c37f, 0xbffc2eb750dc70b9,
    0x3fdd64d22a7c8bf4, 0x3fc54f96a16ed67a,
    0xc00bf8feff3a6fc6, 0x3feb3363da45b281,
    0x3fffcdf13670d9dd, 0x3ff00a4984e5b470,
    0x3fd0b9c210f6aee8, 0x3ff23106de28e12a,
    0x3fdf1e251e5541a4, 0xc00978205d6e0e98,
    0xc004deed6d42327b, 0x3ff74d1611d69194,
    0x40084f15e06df424, 0x400a1bcd3210c098,
    0x3fd67138ff4a95f0, 0xc003e4725b72f23c,
    0xbff9f08c10ba39cf, 0x40041a3309d1d3b2,
    0x4003bba9fc43e7de, 0x3fede6b11e4e072f,
    0xc01377854e5901bd, 0xbfe2c81b8735ae68,
    0x3ffb019ec54960c2, 0xbfe7deb707d169c8,
    0xbfd6a219d029fedc, 0xbff42262b9bf7cac,
    0xbffa1e26516ff03a, 0x3fb77da55f40b600,
    0xc011dad7604e8dde, 0x3ffe21d4c40813a2,
    0x3fe8290dd46e3f88, 0x4005e7027b1e8e78,
    0xbffa08c253c53852, 0x3fecfc8e1deef8ba,
    0x3ff1113b3d6f28bd, 0xbfed78e1f4f03caf,
    0x3ff8b2bf5bef5362, 0xbff72ec004e280ed,
    0xc00fcfb02d3cb355, 0xbfd3cd894f2dc668,
    0xc00d77fc49666c7f, 0x3ff37693ded78cc2,
    0x4009311f7674bfce, 0x40039f85e1086a34,
    0x3fc34f6f8a1c2e80, 0xbfd7eaaea12de1ba,
    0xbff9789c7becf072, 0xbffe887a4eadb5b7,
    0xc014534bc163588d, 0xbfcdc29343c74090,
    0x400bbd6c2db699ab, 0xbfe29c990c40c863,
    0x3ff689ae1ca2e136, 0x3ff9bac30f6bfe94,
    0xbff9fe6f41333834, 0x3fe313b4b8a903e4,
    0xc006246d32bd3300, 0x3f92719f6e48b5e0,
    0x4015c689afa7153e, 0xc015d49c23662d69,
    0x3fc45d1c3b7f0408, 0x40058fb7ec566b60,
    0x4019303cd1385f97, 0xc0006681b2cae47c,
    0xbf8f53e1a5344f00, 0x3ff3621bead582aa,
    0x3fef2d27b9768ccc, 0xbff0bfd3be35e287,
    0x3fe2574d1e9d4a88, 0x4016a609ca6f7eb0,
    0x400e769736e5a6ca, 0x40043526c48de0df,
    0xbff6b369418a3a94, 0xbfca783daada856d,
    0xbff7aaa87f7d2703, 0x3fef250e2961761d,
    0xbffba680bf4ec58e, 0x40053a10f1605e18,
    0x4009683546e19d9f, 0x3ff93f7227506d05,
    0xbfe5bb36fc0790da, 0xbfd4671182f9377c,
    0x3ff819fb4be7c7f5, 0x400978091eadace8,
    0x3fbb62a7922b5530, 0xbfe2edbfb6237cc6,
    0x4000df395fd904ef, 0xbff6cf418302d52f,
    0xbffb53ba2b05133b, 0x40082bab32be21fb,
    0x400678a8033fa27d, 0xbfcd6b7500058530,
    0x4009bd46bf9db1e8, 0x3fd30aca7faff16c,
    0x3fe7a650ca67c799, 0x400982ec50fc8f06,
    0xbfc0bdc090d37990, 0xc0073b35e6218234,
    0x4002e6a2dd03a3d7, 0x3fb0f5cb1330d920,
    0xbff24f7579883594, 0xbfef730b119f44b0,
    0x4005fc09c52e399b, 0xc010ff37241e0a0c,
    0xbff1ae232bbf5c72, 0xc015d4c9c515afc5,
    0x3ff481fcd679df2e, 0xc011d44e8dd3a1ac,
    0xc00212a436510d34, 0x400a77acb8d287a4,
    0x3fcbaec0442cd816, 0xbff6ec0f5926f6e0,
    0x3f8eac2323a07d40, 0xc00479861ca0d828,
    0x4010326ffc92f3cf, 0x3feed7ad85ca99fe,
    0x3ff8392d23c75fd2, 0xbffd53c402422a0e,
    0x40119202722355db, 0x3fa312037004d2a0,
    0x400ca15e2bd9506a, 0xbfebee742f526ca0,
    0xbfe4cac75f752dc9, 0x4011ea11fc63252a,
    0xc011a698c7017eec, 0x401508b11a5e5d26,
    0xbff8fdc81aecfa37, 0x3ff444da6bf24918,
    0x400d33ea9dff9509, 0x400bf57fd9e52ac7,
    0xbfe87cbd440f55e3, 0xbfe0cd8f0c7b85c8,
    0xbfe6c41ff26f087e, 0x400b39b65d52596e,
    0x400997bea42fd30e, 0x3ffe3cf45788545f,
    0x40006be728c073fb, 0x40007b7d28a4345c,
    0x3fb2852f2c3882d0, 0x400140c5e523c58d,
    0x3fd195df779dbf7a, 0xbff933b525a791da,
    0x40038f0662b551e8, 0x400a8070b70792c3,
    0x3feda6e4faec3e6c, 0xbff2f0d18e4d020f,
    0x3fd7b443d2542f9b, 0x4007402d62cd4f6e,
    0x3fe046c773e33004, 0x4002fb0b68224bce,
    0x3ff330c40bfe68b2, 0x3ff28e8617d6bcec,
    0xc011ebe00bfbcec7, 0xc006b132c443a132,
    0x400692e6f8e79098, 0xbfec30ce6142810c,
    0x3ff38e646f8f7892, 0xc011955e8e79c784,
    0x3fedb18ebc811da0, 0x3fe3417c23871f07,
    0x3feafa16f841b82d, 0xbfff4f1a62fd03a4,
    0x3ff356c19caa9a20, 0xc0037b613f8bccf4,
    0x3fff93c8887957e5, 0xbfbbda694204f400,
    0x4003ba1492b15d7c, 0x3fe52b3dc4356e51,
    0xc011005ad0dc664d, 0x3fe0212b9eda09bb,
    0x3fe5167e0f020625, 0x3ffb80ed925a72c4,
    0xc01005c05d1d0b13, 0xbffa4bec157f2196,
    0x40190fb61c0a891a, 0x400968c2f8f05262,
    0xc003a076e661816a, 0x3fd31e446e273854,
    0xc0013cec5ee05964, 0x3fe6c51f49cec7e1,
    0xbffd7b6ae8778ff0, 0xc014b3bc0d0b30a5,
    0x3ff63f5e87d5615b, 0x4000193d1fb76196,
    0xbfe4f3c5a1c004f4, 0xc003bfe233ca5ac6,
    0xc001e8a7333f2c27, 0x3fe1aec627e58a1e,
    0xbfed35151bfbd8d2, 0xc013201680b253bc,
    0x40047c38923c6c96, 0xbffbe91618d69410,
    0x40036b96c79f097f, 0x3feef3bfd1bdaa60,
    0x3fe88f0c7703ed40, 0xbff977170c027f72,
    0xbfef608990140867, 0xbfec2b9eae0e84fe,
    0xbff58bf147f8e88c, 0xbff222b592fa140a,
    0xbfe789abb79e96f7, 0x4004f8ee6cc24778,
    0xc00e2c7106d4078c, 0x40064fffd151a21d,
    0xbffac92d43dec51b, 0x3fc18c0d35e2da14,
    0x4001f14c5488d56d, 0x3fd740985c544d84,
    0x3feab3c9659add34, 0xbfbe134c322b8324,
    0x3fd78f9cfdf04fc0, 0x4006f82d6f7dbdff,
    0xc00977dadd9b9d42, 0xc0068236916c0751,
    0x3fd3cdf896778920, 0x3fa493e0dca71728,
    0xc0003b5fc7a5c122, 0xc003bfce5e95a834,
    0x3ffc7f283c7d67e6, 0x3fea412063235e82,
    0x3ff9ca42e65b1cf1, 0x3fd9aa588be0f768,
    0xbff9ae8959ec4bdc, 0x3ff97d1420539166,
    0xbff1c7829b4c93c4, 0x400240b37c6fb5ff,
    0x4004b79e51a595a3, 0xbfdb5c977a487148,
    0x3ffaefa185763942, 0x3ff106cf3c1f854f,
    0x400eaf82fd234439, 0x3ff46bdeb2871542,
    0x3ff4ec102724c0b9, 0xc00231e519c7881e,
    0xbfe087611a01c9af, 0xbfedd55f0ac04148,
    0xbfe4803b3bc897c1, 0x3ffb20c323e8a387,
    0xbfd770a5e9c78240, 0x3ff7252403f012b0,
    0x3fc4938e5a130668, 0xbff936ac93ac1e6a,
    0x3fde1c2098ac2f3d, 0xc00c3148bc606aa4,
    0x4003f0bd2fd383fd, 0xbfd3866604bc43cc,
    0x3fd72b36ee1d21e8, 0xbfcfb0d0800bf890,
    0x4006324d8db1c74f, 0xbfd47802cafba692,
    0xc00167c55cb8bcae, 0xc016c23ffa5e36ec,
    0x3ffe7c52b4c96895, 0x400def94814ce26c,
    0xbfcaa78e5cbc14d8, 0x4013780f5afbd624,
    0xbfe8a38d629fdc17, 0x3ff92a0b37f5613d,
    0x3fd905883aa23290, 0xc00aa963b9c03296,
    0x3fdcaa49bca7bdb7, 0xbfe3e296f1cfc916,
    0xbfd801f386cb3a32, 0xc004490f1f5716a0,
    0x40001cf9856eca7e, 0x3fc8587d2effd30e,
    0xbfe4b91bd9491623, 0x40008c771adcf1e2,
    0x40173b0f785ad371, 0x3ff0daa814ac093a,
    0xc0061f6c4cb9f7ae, 0x3ffdbd6850201b54,
    0xc006c98b5a7ca28d, 0xbfe47a91da0a6a60,
    0x40012c6a9330cbb2, 0xbfe26613be4f8684,
    0x3ff08f65bd8fdcb0, 0xc008ff6b6fe25a98,
    0x4011dfc706ab6ca1, 0x3fe39ed90603fbe6,
    0x3fe336e574526b8c, 0x3fd6dd2a8be2f030,
    0xbfea57a50834e2c7, 0xc0088d9cadb7026c,
    0xbfe6f06315fdae6f, 0x400117f1ebff2beb,
    0x3ff1790a89483d1c, 0x3ff2a9fc4e89449e,
    0xbfec244290b33c62, 0xc005a91d4379a564,
    0xc0011183d32b7efc, 0x401abb09f933328e,
    0x3fd39cc9f1b8792e, 0xbfe4dfbefd1bb404,
    0x4000ce23d281ca35, 0x3ff44d681affe7bf,
    0x4000f8e9160f1c7a, 0x4010fe5e7c8d8cb2,
    0x4009c45509cfac02, 0xbfb076b690f7a960,
    0xc002673d88463af9, 0xbff513de46e3090a,
    0xc00261c3805973ea, 0xc01031323380cdc1,
    0xc005de8ec83d327a, 0x40067e90be4f8218,
    0x3fff0968aa4d2a40, 0xc0017376823e94bf,
    0xbfea0809fee9bcce, 0xbfe867f16782fd8c,
    0x4005d1dd9005895f, 0x3fec76b43ff12934,
    0x3ff626b416718390, 0x3fd0af418b9ecb98,
    0xbff8f6287f0ea38b, 0x3fe018a779f1d676,
    0xc0097d513774a033, 0x40092a0d09935edf,
    0xbfd46c307f3164a6, 0x3ffef485a2a65c54,
    0x4016579e10ddff56, 0x4009fd2eb595abb5,
    0xbffdc448b04c4f32, 0x3ff60902652bd3ca,
    0x3ffe8e3c764fe5ba, 0x3fc216d97dc43e0c,
    0xbfee5e262fb17324, 0x3ffc38589806b67a,
    0xc004b67f90dda015, 0xc00537b34810980c,
    0xc006fe88e762e549, 0xbff9999e07f09ad0,
    0xbff0b571c0724e34, 0x3ff19f6a33e9ec0e,
    0x40058d77468cc3a4, 0xc00389526ea15af8,
    0x3ffee90c5ad62cca, 0xbff536cbe0a5115a,
    0x3ffa38f4cbdc14b3, 0x40095f2969854bc6,
    0xc0046f2dc0bd0382, 0xc00458dab80f25c0,
    0x40061bbd5a4d8596, 0xbff70cc2479f49e2,
    0x4007a1667fe85b34, 0x40045f309a6b3a58,
    0xbffe8e7ef6d30d96, 0xbfd66c3424c91a48,
    0xbff3e170b9920dfa, 0xbff78d259809f49a,
    0xc002c8d45443a9e4, 0x4002f22fb01403d2,
    0x3ffdcde0b670e6d6, 0x400cc1308628c501,
    0xc0021e3e48b4c7ca, 0x3ff2f93b1fea58f4,
    0xbfb28a920a2d08a0, 0x3ff7dc8e3f6cc125,
    0xc00843f6b0257273, 0x4003c32013775b7a,
    0x400201b912f3ad1e, 0xbffea688ee401936,
    0xbff8dbce09545863, 0x40097c6f08783dbf,
    0x4003a060a38049b4, 0xbff4347474e0ec60,
    0x4007ccf830591701, 0xbff37e039a5f74e8,
    0x3ffb9a7e441d1802, 0x4001f1115be2a4a9,
    0xbfef8863ff9024ff, 0xc010e1004fb842ae,
    0x3ff5ae4de3e2b813, 0x3ff59da19feb264b,
    0x400322292071a9ff, 0xbfe10da0de7e53b2,
    0xbfe96e8c3c15a36e, 0x3ff821e12db58a72,
    0xc0062c3f010eba98, 0xc00d56c856cb8259,
    0xc009758e8dea891f, 0x3ffbd54867e54b83,
    0x3fd89c6d21770745, 0x400d82f60e3b0c9d,
    0xc00330701b484f61, 0xbfc3fd8f89a734a8,
    0x3ff29004c19cd184, 0x400341617de4f342,
    0xbfd58f59a929eaf4, 0xbfe59dc98c8a7c8d,
    0x3fff6095dd3445f5, 0x401ee96eb814d92a,
    0xbff07144a2abfde8, 0xbfeeac6560b8417c,
    0xbffe33f444623c80, 0x40009ff8e6a602de,
    0x40163d953c222264, 0xbfdd9340e009f384,
    0x4001c8aa2ba011f0, 0x3fd0819b7551ac48,
    0x400c0effb7d6a36e, 0x3fb8728a5e09f870,
    0x3fc19c6c613a918c, 0xbfaf262221cb9c10,
    0xbffd8193e6883af0, 0xc0061118df054305,
    0xc00ab17e2493b2ec, 0x4012eecb31abc9aa,
    0xbfd52dd2615e0330, 0x3fdeceeff4be7d9e,
    0x3ff53e6914dfccea, 0x3fe598392ff6eda7,
    0x40041e75fe3e2aa5, 0x3fc010fb767013dc,
    0xbff0c8297b9359a0, 0x3fde0ada26a61534,
    0x4003f8f9ef70bf11, 0x400c541f45281597,
    0x3ffd0d1881ab2976, 0x4005cea6b3419d7c,
    0x40119630f6862175, 0xc00b46d88667cc08,
    0x4003029acf6addfe, 0x3fe9619e20df2c7c,
    0xbfa94b8c07ddedb0, 0xc00820cbb4579d49,
    0x3fdabc27587c088c, 0xc006a49ce0ad4dfe,
    0x3ffae273c57f048c, 0x3ff63953b5e855fb,
    0xbff10c129af08956, 0x3fb54b1c3b3fa6ac,
    0x3ff8319d3c6d57c9, 0xbfe8085ec9ecefe4,
    0xc0079283227c9798, 0xc0064230b96c399c,
    0xc0198ec309be8577, 0x3ff2a9eb23c64f14,
    0xbff71b3cbcf4669b, 0x400078a875173f7c,
    0xbfe383a5cb174134, 0xbfe6aed6c751cd48,
    0x3fdbcaddbd2f8ea8, 0xc00d32539ec13a73,
    0xc000a5394d33a3d7, 0xbffa5d4ec18397d4,
    0x3fd0fee8f1b7b4c8, 0xc0088339e2b3c37c,
    0xc0100d78dbe6637e, 0x4008395c2e2bf67e,
    0x3fc8ccdd187651b0, 0x4005fd42f4078faa,
    0x400b36b76e7dfa34, 0x3ff5f6e249c3f29f,
    0x3fcdcac60cad1790, 0x3ffc4d29c21d6911,
    0x3ff0eae66cea359e, 0xc013b17aef8cac2a,
    0x3fd317a555ad8a26, 0x3fce772556423cb8,
    0x3fe0d8d212aefc68, 0xbfe4b7cccaef3de4,
    0x3ff5b4707ac8228e, 0x3fce00506f6fa68c,
    0xbff19068f77d9b59, 0xc00cf68071a9171a,
    0xbfc23d659445d108, 0x3faedb326cc5f7a0,
    0xc0002020fb73e534, 0xc00d3578423da0b2,
    0x3fdb221270d7bd9b, 0x3fe423362c6fcc30,
    0xbffe7c802be2238c, 0xbff63c5c5b6aa372,
    0xbff0edc516762ea4, 0x3ffcc1d8eb33b4ff,
    0xc017ed474ca79642, 0xbff80f0409568355,
    0xbffc444eb038851a, 0x3fdb06e64b33d174,
    0x3fe36e3163c94072, 0xc012f2b75b31bdee,
    0xbfe12e99f7a24d5a, 0x3fd755b3a0198bb4,
    0x4000048c83ce0fcc, 0x3ffb4227761516b5,
    0x4004265eeb79d0ed, 0x3fffbcf716738ec9,
    0xc0120eb90d35b9ab, 0xc000074eeae92cbe,
    0xbff3e98d00fa1b68, 0xbfa0bde650f86aac,
    0xbfcb47949252ab2a, 0x4015c49db8827504,
    0x3ffa9890c9f62175, 0xc003b993d5b6c100,
    0x3fffde1207f87529, 0xc013c0780a55b0e1,
    0xbfed86f25664e7f8, 0x3fe06bb5598da22c,
    0x40012812c0e9b47f, 0xbfcc0b3ac63b1524,
    0x40166be21eb45a8a, 0x4009b22da86f4cc4,
    0xc0042b9a590f4418, 0xbfe8d3480e74c444,
    0xc00212d02b1341ee, 0xc0159b791361108a,
    0x3ffb33e4276a723a, 0x3fbfd9dd29a6cb80,
    0xbffe2e429b68ea62, 0x400903d0e026a0b0,
    0x3feba176805d1e50, 0x3fe8274b47efbe98,
    0x3ff7286d2b035b84, 0xbfde4971f8e32c0c,
    0xbff7171736a55591, 0x3fed97190d490b99,
    0x4002dfcb89315df5, 0x3feb3dc2cc9d85ab,
    0x4009e9306719d60e, 0x3fe5c801fbdbdff8,
    0xc003aa15ff451164, 0x401160ce4c626672,
    0x40005ffb43bff2f4, 0x3f8b360b41daaf00,
    0x3feaff65d42e9564, 0xbfe9699e868eec3a,
    0x40049fc023866e8c, 0x3fe3864f0bfde454,
    0x3fde0c5793572cf8, 0xbfc699f3ce90da88,
    0x3ff05f19348c3656, 0x4005db43ad2677cb,
    0x3fea10f153eb2998, 0x3fe8ad42aca27c69,
    0xbfeaf052a3645c27, 0xbffd3cd80fc8e31e,
    0x3ff1ce68f5c01cea, 0xc010f4149b44d2ea,
    0x3fe225c101eb28da, 0x3fe12e8554a737fe,
    0x4000114719323f85, 0x3faaea385332c580,
    0xc015f577bedecb9e, 0xbfd829cb3c5d71ba,
    0xc007306bf45e3f80, 0x3fd58a56a5972e14,
    0x3ffc7020595310d7, 0xbfe456dff3a41054,
    0xbfe30c8eaf0d5af3, 0xc00d9194df9c50b7,
    0x3fe9b1ed21dbfa84, 0x400478a404b8a100,
    0x3fe0bb801c63914f, 0xbfd3b1d66dfbab88,
    0x3ff2cb64c7d9f4ec, 0xbff4c2568725e41e,
    0x40051b9cce96c23f, 0xc000c72b188312aa,
    0xc010edd5011bcf47, 0x3ff3b2e5e33c3fda,
    0xc00d450a869d0a70, 0x4015228170af3d60,
    0xc00fc3c71c17e2bb, 0xc00043ce0b683a46,
    0x40079ab887fdcff9, 0x3ffa055798df968a,
    0xbfe1db78c6bab4dc, 0x4006949b17458cf2,
    0x3fe250b56bc398e0, 0x4011cc123fa12ce7,
    0xc000fd39fc5dc97a, 0x3fc3702bb5ebb1a8,
    0xbff39e51b0dc1ce8, 0xc001f65a1cb5d25c,
    0x400327cb80f12170, 0x3ff4d16152e8d04c,
    0x3fea34bd553109ac, 0xbff76eaec1d30e80,
    0x40109c9ef6dbbc82, 0x4010ba37865b4a70,
    0x3feb5058334ab81a, 0x3febf83ad1085cba,
    0x3ffc44e5c30cb8b0, 0x3ff7eab70e4f9ee8,
    0x4004bb18881628d2, 0xbfe9658d4b93c05c,
    0x4012e1ca141830b0, 0xbff878dee6a18cc4,
    0xc00e4e1b43b0f0c2, 0x3fe360753aba4106,
    0x40066b904417ebf2, 0xc011bfc1318c6270,
    0x3ff0e9407cec298a, 0xbfe385deec1a05ed,
    0xbffe529da585e46e, 0x3ff915415e729187,
    0x40023c4ccbb1ab68, 0xc0051aaa6e46bb3f,
    0xbfee3a33adfd0ced, 0xc0105003440680e6,
    0x3ff23b089049ae26, 0x40035177916454b6,
    0xbfdf634b9240049e, 0xbfc83229d525b7f8,
    0x400a69a9e4179e6f, 0xc001480187caa062,
    0xc009b59423ce0024, 0x4009c3fc48369197,
    0x3ffe2565b1b4a0cd, 0x40065d8c20baad94,
    0xbff365db800dcc40, 0xc00f7e8219ec3137,
    0x3f9bbdbbe757f300, 0xbff0a209987bb96e,
    0x3ff4c84f3aa56652, 0xbfbdc979f0097c4a,
    0x3feea58d31ab4c34, 0x3fe8c2a16e066c90,
    0x3fd1d84afa1b7843, 0x3faedab2aad624a0,
    0x3ff5af54e4434fe5, 0xbfe579f64a6e7f60,
    0x3ffaf8b5b708710e, 0xbfe7b2a3186cca48,
    0xbfe446e4523726e9, 0x400215ed0b75dd68,
    0xbff359f03a9b28a6, 0xbff7c45b05eabec1,
    0xbfe50361fef74a20, 0x40087070f667c19c,
    0xbffa20461ec9fa8f, 0xbfcc2fd912ab7519,
    0x3fe6e2f7b334ab94, 0xbfe1a4c6cd124dc8,
    0x3ff77b6e2a9aa2c0, 0xbf994115be505380,
    0xc00c6b4efaf9aa22, 0xbff2b3b79c79384f,
    0x4004567e89eca3e1, 0xbff8aa5e39e1d3ae,
    0x400e8ca96015e489, 0x3ffba46b83d2bc48,
    0xbff5d9c80f2f875e, 0x3fed53df049f08ae,
    0x3fcb00ffa480614c, 0xc014291f5bbe608c,
    0xbfef3f9f9d1d1c7a, 0x400910a39479e45c,
    0xbf99ac84c7b1f280, 0x3ff7c4c23d0eb582,
    0x400cf674724e6ed8, 0x4003f292e97430cc,
    0xc0096fe0c36f80f4, 0x40186b9536936d2d,
    0xc01766492f5ffb20, 0x40034bf331e255f4,
    0x3ff6e2573a53fef6, 0x400fb994d81b1517,
    0x3ffd9c58eae263ee, 0xc00bda162fd88f26,
    0x3feb800b892e6fae, 0x4012aa57abddfb2c,
    0xc0023ea534e38497, 0xbff8cc63f4cf0147,
    0xbf807f81773e5c00, 0xbff1a12849db76cc,
    0x3ff3ded438516462, 0xbffe27efb8be6b42,
    0x3ff7876ccc95e344, 0x40014001ddaea821,
    0xc006dfababf5b76e, 0x3fca5d032f39fea8,
    0xbff58715cd47055a, 0x4005ed5b03ae3f4b,
    0xbfe3825cc8b95926, 0xbfe3c2c55a4a2704,
    0x3ff381e5739ed4ad, 0xc00939ae765620b8,
    0x3f98c30659d83a20, 0xc00400f66cf10329,
    0xc016c63d97845bc2, 0xc015accdb1d0325a,
    0xbff1c8e948fca4ed, 0xc012d2e7f3cf92ce,
    0x400945c1aaedd73e, 0x4010ee7f3d5d5a32,
    0xbff51514d2fe847a, 0xc002309301d8e5bc,
    0xbfe30cac63aa5225, 0x400fb3dea14cab57,
    0xbffef20b7e8a414a, 0x3fe9d7251a122d33,
    0xbfeb22c0df75414c, 0x40020d07af281d6f,
    0x4009986f7eb6c3f4, 0x3fcb17390540ef96,
    0xbfd00ba7a0b26a48, 0xc00275fdd1d6095e,
    0x400269fdd91164ba, 0xbfc5749783f0ed08,
    0x3fd6ea6c34327b70, 0x40065c608db61b29,
    0xbffca36883cf9be3, 0xc01495b568ebedd1,
    0x3ff292fae6ddf4af, 0xbfdb6dc4802c5648,
    0xbff40c5ee71dc0cd, 0xc00f96d037fa9af6,
    0x3fe23e87be1114e2, 0xbfe32c00ac7424db,
    0x3ffee2b9f82ff11e, 0xbfe7cfd762db16d2,
    0x3fed6319624165c5, 0x3ff7990e8bf26d6c,
    0xc010fdbf5376bd34, 0xc001fa8b897ae7ce,
    0xbff4f24e69d31194, 0x400723c9478f1087,
    0x400bf0ccd7777922, 0x3fd47b881979e78c,
    0xbffd0dc71e50abf9, 0xbfb3cb5d1a81be36,
    0x3fb9c8fcff900a2c, 0xc00ccaf2bee083ee,
    0xbfe5feab65054ad0, 0xbfef8e8fdfc6f8a2,
    0xc00b0ed4b8440794, 0xc00b910f67a09807,
    0x3ffc7a4073ddee30, 0xc003424a8d478d6e,
    0x3ffc97b4c0741cca, 0xc00ca32f3104f360,
    0x40046255f53cf242, 0x401930a0be8be4fa
    };

static const uint64_t in_cfft_step_16[32] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0
    };

static const uint64_t in_cifft_step_16[32] = {
    0x401ccccccccccccd, 0x0,
    0xbfeccccccccccccd, 0x4012193232087380,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff58d16655168c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe33e58f33f2d66,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc6ea2a16b312d0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfc6ea2a16b312d0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfe33e58f33f2d6a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbff58d16655168be,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc012193232087380
    };

static const uint64_t ref_cfft_step_16[32] = {
    0x401ccccccccccccd, 0x0,
    0xbfeccccccccccccd, 0x4012193232087380,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff58d16655168c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe33e58f33f2d66,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc6ea2a16b312d0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfc6ea2a16b312d0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfe33e58f33f2d6a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbff58d16655168be,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc012193232087380
    };

static const uint64_t in_cfft_step_32[64] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0
    };

static const uint64_t in_cifft_step_32[64] = {
    0x402ccccccccccccd, 0x0,
    0xbfeccccccccccccc, 0x40224694b6d1e46b,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4007bc3751b89a60,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffaf0c4f1b61204,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff18be432937072,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe7a2b359cd577c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdec9aff9db9276,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd1790763398d10,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb6b14264b87580,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfb6b14264b87580,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfd1790763398d10,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfdec9aff9db9276,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbfe7a2b359cd577c,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbff18be432937072,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbffaf0c4f1b61204,
    0x0, 0x0,
    0xbfecccccccccccca, 0xc007bc3751b89a60,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xc0224694b6d1e46b
    };

static const uint64_t ref_cfft_step_32[64] = {
    0x402ccccccccccccd, 0x0,
    0xbfeccccccccccccc, 0x40224694b6d1e46b,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4007bc3751b89a60,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffaf0c4f1b61204,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff18be432937072,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe7a2b359cd577c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdec9aff9db9276,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd1790763398d10,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb6b14264b87580,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfb6b14264b87580,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfd1790763398d10,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfdec9aff9db9276,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbfe7a2b359cd577c,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbff18be432937072,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbffaf0c4f1b61204,
    0x0, 0x0,
    0xbfecccccccccccca, 0xc007bc3751b89a60,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xc0224694b6d1e46b
    };

static const uint64_t in_cfft_step_64[128] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0
    };

static const uint64_t in_cifft_step_64[128] = {
    0x403ccccccccccccd, 0x0,
    0xbfeccccccccccccb, 0x403251e65569b233,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x401844ec2b5fac27,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x400cbe7785552992,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x40041f661e754927,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ffe723ce98fc58a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff80663076302d4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff36a88f5ef7ae6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fefc6a199472fb2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fea1a5100191251,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe55c0a88a568bc,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe1431614ea7331,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdb3e263f09b83c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd49c0f5f0ec5ac,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fccdb2939f178e8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc1169b34e238f0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fa6a33d2f9b9000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfa6a33d2f9b9000,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfc1169b34e238e0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfccdb2939f178e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfd49c0f5f0ec5a8,
    0x0, 0x0,
    0xbfecccccccccccd8, 0xbfdb3e263f09b838,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfe1431614ea7331,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xbfe55c0a88a568bd,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xbfea1a5100191252,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfefc6a199472fb1,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbff36a88f5ef7ae6,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbff80663076302d4,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbffe723ce98fc58b,
    0x0, 0x0,
    0xbfecccccccccccce, 0xc0041f661e754928,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xc00cbe7785552992,
    0x0, 0x0,
    0xbfecccccccccccc7, 0xc01844ec2b5fac28,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xc03251e65569b233
    };

static const uint64_t ref_cfft_step_64[128] = {
    0x403ccccccccccccd, 0x0,
    0xbfeccccccccccccb, 0x403251e65569b233,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x401844ec2b5fac27,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x400cbe7785552992,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x40041f661e754927,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ffe723ce98fc58a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff80663076302d4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff36a88f5ef7ae6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fefc6a199472fb2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fea1a5100191251,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe55c0a88a568bc,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe1431614ea7331,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdb3e263f09b83c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd49c0f5f0ec5ac,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fccdb2939f178e8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc1169b34e238f0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fa6a33d2f9b9000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfa6a33d2f9b9000,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfc1169b34e238e0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfccdb2939f178e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfd49c0f5f0ec5a8,
    0x0, 0x0,
    0xbfecccccccccccd8, 0xbfdb3e263f09b838,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfe1431614ea7331,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xbfe55c0a88a568bd,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xbfea1a5100191252,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfefc6a199472fb1,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbff36a88f5ef7ae6,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbff80663076302d4,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbffe723ce98fc58b,
    0x0, 0x0,
    0xbfecccccccccccce, 0xc0041f661e754928,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xc00cbe7785552992,
    0x0, 0x0,
    0xbfecccccccccccc7, 0xc01844ec2b5fac28,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xc03251e65569b233
    };

static const uint64_t in_cfft_step_128[256] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0
    };

static const uint64_t in_cifft_step_128[256] = {
    0x404ccccccccccccd, 0x0,
    0xbfeccccccccccccd, 0x404254ba4d4dccca,
    0x0, 0x0,
    0xbfecccccccccccca, 0x402866e9c69d778c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x401d3022a95b27ca,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4014bf4fc9bb14b9,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x401008123832cdbc,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400a04780e45d71d,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4005cb722f4c178b,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x4002aa50fa649f45,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x40003e314c63f4d1,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffc9b9e74f4875f,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff96b67f3ac760f,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff6bd76358b76c6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff472492bef49d1,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff273af5fdf55bd,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff0b18fe45133e4,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fee3fe4ddc20688,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feb6b7d37ce94c5,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe8d7d22e314b76,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe679ca22c5ef02,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe44882f8cfcdea,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe23cc62c0d353d,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe050a3bd8405b4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdcfe4fb13c7aa0,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd9884662bb5d62,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd638016e083b6a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd30749cae4e54c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcfe1506e2d4488,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc9de786d5d5ed8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc3fd3568b97230,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fbc6ac9017f8d60,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb0fecd9ee5b300,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3f969fbf20d4b800,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbf969fbf20d4bc00,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfb0fecd9ee5b300,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfbc6ac9017f8da0,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfc3fd3568b97260,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfc9de786d5d5ec8,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfcfe1506e2d44b0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfd30749cae4e528,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbfd638016e083b6a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfd9884662bb5d46,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfdcfe4fb13c7a84,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfe050a3bd8405ba,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbfe23cc62c0d3547,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfe44882f8cfcdf6,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbfe679ca22c5ef0a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfe8d7d22e314b71,
    0x0, 0x0,
    0xbfecccccccccccc4, 0xbfeb6b7d37ce94c8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfee3fe4ddc206a5,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbff0b18fe45133ef,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbff273af5fdf55b9,
    0x0, 0x0,
    0xbfecccccccccccd5, 0xbff472492bef49cb,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbff6bd76358b76bc,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbff96b67f3ac760e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbffc9b9e74f4875c,
    0x0, 0x0,
    0xbfecccccccccccdb, 0xc0003e314c63f4cc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc002aa50fa649f46,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc005cb722f4c178a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc00a04780e45d720,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xc01008123832cdbc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc014bf4fc9bb14ba,
    0x0, 0x0,
    0xbfecccccccccccca, 0xc01d3022a95b27ca,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc02866e9c69d778c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xc04254ba4d4dccca
    };

static const uint64_t ref_cfft_step_128[256] = {
    0x404ccccccccccccd, 0x0,
    0xbfeccccccccccccd, 0x404254ba4d4dccca,
    0x0, 0x0,
    0xbfecccccccccccca, 0x402866e9c69d778c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x401d3022a95b27ca,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4014bf4fc9bb14b9,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x401008123832cdbc,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400a04780e45d71d,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4005cb722f4c178b,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x4002aa50fa649f45,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x40003e314c63f4d1,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffc9b9e74f4875f,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff96b67f3ac760f,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff6bd76358b76c6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff472492bef49d1,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff273af5fdf55bd,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff0b18fe45133e4,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fee3fe4ddc20688,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feb6b7d37ce94c5,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe8d7d22e314b76,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe679ca22c5ef02,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe44882f8cfcdea,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe23cc62c0d353d,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe050a3bd8405b4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdcfe4fb13c7aa0,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd9884662bb5d62,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd638016e083b6a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd30749cae4e54c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcfe1506e2d4488,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc9de786d5d5ed8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc3fd3568b97230,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fbc6ac9017f8d60,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb0fecd9ee5b300,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3f969fbf20d4b800,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbf969fbf20d4bc00,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfb0fecd9ee5b300,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfbc6ac9017f8da0,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfc3fd3568b97260,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfc9de786d5d5ec8,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfcfe1506e2d44b0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfd30749cae4e528,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbfd638016e083b6a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfd9884662bb5d46,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfdcfe4fb13c7a84,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfe050a3bd8405ba,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbfe23cc62c0d3547,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfe44882f8cfcdf6,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbfe679ca22c5ef0a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfe8d7d22e314b71,
    0x0, 0x0,
    0xbfecccccccccccc4, 0xbfeb6b7d37ce94c8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfee3fe4ddc206a5,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbff0b18fe45133ef,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbff273af5fdf55b9,
    0x0, 0x0,
    0xbfecccccccccccd5, 0xbff472492bef49cb,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbff6bd76358b76bc,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbff96b67f3ac760e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbffc9b9e74f4875c,
    0x0, 0x0,
    0xbfecccccccccccdb, 0xc0003e314c63f4cc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc002aa50fa649f46,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc005cb722f4c178a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc00a04780e45d720,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xc01008123832cdbc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc014bf4fc9bb14ba,
    0x0, 0x0,
    0xbfecccccccccccca, 0xc01d3022a95b27ca,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc02866e9c69d778c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xc04254ba4d4dccca
    };

static const uint64_t in_cfft_step_256[512] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0,
    0x3feccccccccccccd, 0x0
    };

static const uint64_t in_cifft_step_256[512] = {
    0x405ccccccccccccd, 0x0,
    0xbfecccccccccccca, 0x4052556f444c538a,
    0x0, 0x0,
    0xbfecccccccccccb3, 0x40386f6639ecffb6,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x402d4c71fd1460af,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4024e6fe4f285982,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x40203b2c44fd1a24,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x401a81a322d4ff2c,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40165fbb942eb8f4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x401355e79ffbb0ff,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4011014bfa560d2a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400e5159adcb89eb,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400b5137b880c652,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x4008d3fad768aef9,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4006ba35789a9a03,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x4004edc99aa463d0,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x40035eb2dfdfdf48,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4002010ecbb5f916,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4000cbdc2f4a60f6,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fff7050fec91eda,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffd8102fa1da670,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3ffbc1255464e0ba,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffa29bf2b66d238,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff8b5233638a614,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff75ea6114c1dfe,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff622675b95197f,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff4fd284472249e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff3ec2bd9ce6eb2,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff2ed1e8317f202,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff1fe02d5773622,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ff11d2270f55b1c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff04901f171b532,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fef00ae7d262608,
    0x0, 0x0,
    0xbfeccccccccccd14, 0x3fed8403679a1b7c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fec1a07758cd02d,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3feac0fb156cb96c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe97751a28386f3,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3fe83baa2d8dfd18,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe70cc9743fbcd3,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe5e994cf1941b4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe4d10de8b7f82d,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fe3c24f1adc0dc4,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fe2bc88546ed5ca,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe1befc715bc17c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe0c8fef16940af,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fdfb3e3fd6673ea,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fdde2896e544b20,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdc1ce35d5eddc8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fda61fb425f4db0,
    0x0, 0x0,
    0xbfecccccccccccb0, 0x3fd8b0ec9b18b4e0,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fd708e2e6a7adc2,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd56917dc755ac0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd3d0d1d62870a8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd23f62655a81a0,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fd0b4250ee9c1c8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fce5cfc4d450450,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcb5bb38d7028e0,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fc86355be430b40,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3fc572d4b2e23710,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc2892c9c542cd0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fbf4ac523ca0380,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fb98d0665263380,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb3d742b6a264c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fac4f53b938e580,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fa0f8e69f105500,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3f869edfd0d80000,
    0x0, 0x0,
    0xbfecccccccccccc4, 0xbf869edfd0d80000,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xbfa0f8e69f105500,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfac4f53b938e500,
    0x0, 0x0,
    0xbfecccccccccccc8, 0xbfb3d742b6a26440,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbfb98d06652633c0,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbfbf4ac523ca03a0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfc2892c9c542d00,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfc572d4b2e236e0,
    0x0, 0x0,
    0xbfeccccccccccce8, 0xbfc86355be430b50,
    0x0, 0x0,
    0xbfecccccccccccd3, 0xbfcb5bb38d7028d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfce5cfc4d450438,
    0x0, 0x0,
    0xbfecccccccccccd6, 0xbfd0b4250ee9c1c8,
    0x0, 0x0,
    0xbfecccccccccccbc, 0xbfd23f62655a81b8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0xbfd3d0d1d628709c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfd56917dc755ab4,
    0x0, 0x0,
    0xbfecccccccccccc0, 0xbfd708e2e6a7ade0,
    0x0, 0x0,
    0xbfecccccccccccc2, 0xbfd8b0ec9b18b51e,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbfda61fb425f4da0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfdc1ce35d5eddc8,
    0x0, 0x0,
    0xbfecccccccccccd7, 0xbfdde2896e544b1e,
    0x0, 0x0,
    0xbfeccccccccccce1, 0xbfdfb3e3fd6673e0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbfe0c8fef16940b1,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbfe1befc715bc177,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbfe2bc88546ed5d6,
    0x0, 0x0,
    0xbfecccccccccccbe, 0xbfe3c24f1adc0ddc,
    0x0, 0x0,
    0xbfecccccccccccd3, 0xbfe4d10de8b7f82c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbfe5e994cf1941b9,
    0x0, 0x0,
    0xbfeccccccccccce5, 0xbfe70cc9743fbcd7,
    0x0, 0x0,
    0xbfecccccccccccc6, 0xbfe83baa2d8dfd11,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbfe97751a28386f5,
    0x0, 0x0,
    0xbfecccccccccccc7, 0xbfeac0fb156cb978,
    0x0, 0x0,
    0xbfeccccccccccc94, 0xbfec1a07758ccffc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfed8403679a1b6d,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfef00ae7d26261c,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbff04901f171b532,
    0x0, 0x0,
    0xbfecccccccccccc4, 0xbff11d2270f55b1c,
    0x0, 0x0,
    0xbfecccccccccccc2, 0xbff1fe02d577361e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbff2ed1e8317f202,
    0x0, 0x0,
    0xbfeccccccccccccb, 0xbff3ec2bd9ce6eae,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbff4fd284472249e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xbff622675b951983,
    0x0, 0x0,
    0xbfeccccccccccccb, 0xbff75ea6114c1e02,
    0x0, 0x0,
    0xbfecccccccccccc8, 0xbff8b5233638a612,
    0x0, 0x0,
    0xbfecccccccccccd4, 0xbffa29bf2b66d240,
    0x0, 0x0,
    0xbfecccccccccccd6, 0xbffbc1255464e0c0,
    0x0, 0x0,
    0xbfecccccccccccd3, 0xbffd8102fa1da676,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbfff7050fec91ed6,
    0x0, 0x0,
    0xbfecccccccccccf0, 0xc000cbdc2f4a60f6,
    0x0, 0x0,
    0xbfecccccccccccc4, 0xc002010ecbb5f91b,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xc0035eb2dfdfdf49,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xc004edc99aa463d0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xc006ba35789a9a02,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc008d3fad768aef9,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xc00b5137b880c653,
    0x0, 0x0,
    0xbfecccccccccccca, 0xc00e5159adcb89ec,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xc011014bfa560d28,
    0x0, 0x0,
    0xbfecccccccccccd5, 0xc01355e79ffbb0fe,
    0x0, 0x0,
    0xbfecccccccccccca, 0xc0165fbb942eb8f4,
    0x0, 0x0,
    0xbfecccccccccccc3, 0xc01a81a322d4ff2c,
    0x0, 0x0,
    0xbfecccccccccccce, 0xc0203b2c44fd1a23,
    0x0, 0x0,
    0xbfecccccccccccc1, 0xc024e6fe4f285982,
    0x0, 0x0,
    0xbfecccccccccccdf, 0xc02d4c71fd1460ae,
    0x0, 0x0,
    0xbfecccccccccccbf, 0xc0386f6639ecffb6,
    0x0, 0x0,
    0xbfecccccccccccc0, 0xc052556f444c538a
    };

static const uint64_t ref_cfft_step_256[512] = {
    0x405ccccccccccccd, 0x0,
    0xbfecccccccccccca, 0x4052556f444c538a,
    0x0, 0x0,
    0xbfecccccccccccb3, 0x40386f6639ecffb6,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x402d4c71fd1460af,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4024e6fe4f285982,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x40203b2c44fd1a24,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x401a81a322d4ff2c,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40165fbb942eb8f4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x401355e79ffbb0ff,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4011014bfa560d2a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400e5159adcb89eb,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400b5137b880c652,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x4008d3fad768aef9,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4006ba35789a9a03,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x4004edc99aa463d0,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x40035eb2dfdfdf48,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4002010ecbb5f916,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4000cbdc2f4a60f6,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fff7050fec91eda,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffd8102fa1da670,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3ffbc1255464e0ba,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffa29bf2b66d238,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff8b5233638a614,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff75ea6114c1dfe,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff622675b95197f,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff4fd284472249e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff3ec2bd9ce6eb2,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff2ed1e8317f202,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff1fe02d5773622,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ff11d2270f55b1c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff04901f171b532,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fef00ae7d262608,
    0x0, 0x0,
    0xbfeccccccccccd14, 0x3fed8403679a1b7c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fec1a07758cd02d,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3feac0fb156cb96c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe97751a28386f3,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3fe83baa2d8dfd18,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe70cc9743fbcd3,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe5e994cf1941b4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe4d10de8b7f82d,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fe3c24f1adc0dc4,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fe2bc88546ed5ca,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe1befc715bc17c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe0c8fef16940af,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fdfb3e3fd6673ea,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fdde2896e544b20,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdc1ce35d5eddc8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fda61fb425f4db0,
    0x0, 0x0,
    0xbfecccccccccccb0, 0x3fd8b0ec9b18b4e0,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fd708e2e6a7adc2,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd56917dc755ac0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd3d0d1d62870a8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd23f62655a81a0,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fd0b4250ee9c1c8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fce5cfc4d450450,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcb5bb38d7028e0,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fc86355be430b40,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3fc572d4b2e23710,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc2892c9c542cd0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fbf4ac523ca0380,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fb98d0665263380,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb3d742b6a264c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fac4f53b938e580,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fa0f8e69f105500,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3f869edfd0d80000,
    0x0, 0x0,
    0xbfecccccccccccc4, 0xbf869edfd0d80000,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xbfa0f8e69f105500,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfac4f53b938e500,
    0x0, 0x0,
    0xbfecccccccccccc8, 0xbfb3d742b6a26440,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbfb98d06652633c0,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbfbf4ac523ca03a0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfc2892c9c542d00,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfc572d4b2e236e0,
    0x0, 0x0,
    0xbfeccccccccccce8, 0xbfc86355be430b50,
    0x0, 0x0,
    0xbfecccccccccccd3, 0xbfcb5bb38d7028d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfce5cfc4d450438,
    0x0, 0x0,
    0xbfecccccccccccd6, 0xbfd0b4250ee9c1c8,
    0x0, 0x0,
    0xbfecccccccccccbc, 0xbfd23f62655a81b8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0xbfd3d0d1d628709c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfd56917dc755ab4,
    0x0, 0x0,
    0xbfecccccccccccc0, 0xbfd708e2e6a7ade0,
    0x0, 0x0,
    0xbfecccccccccccc2, 0xbfd8b0ec9b18b51e,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbfda61fb425f4da0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xbfdc1ce35d5eddc8,
    0x0, 0x0,
    0xbfecccccccccccd7, 0xbfdde2896e544b1e,
    0x0, 0x0,
    0xbfeccccccccccce1, 0xbfdfb3e3fd6673e0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbfe0c8fef16940b1,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbfe1befc715bc177,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbfe2bc88546ed5d6,
    0x0, 0x0,
    0xbfecccccccccccbe, 0xbfe3c24f1adc0ddc,
    0x0, 0x0,
    0xbfecccccccccccd3, 0xbfe4d10de8b7f82c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbfe5e994cf1941b9,
    0x0, 0x0,
    0xbfeccccccccccce5, 0xbfe70cc9743fbcd7,
    0x0, 0x0,
    0xbfecccccccccccc6, 0xbfe83baa2d8dfd11,
    0x0, 0x0,
    0xbfecccccccccccca, 0xbfe97751a28386f5,
    0x0, 0x0,
    0xbfecccccccccccc7, 0xbfeac0fb156cb978,
    0x0, 0x0,
    0xbfeccccccccccc94, 0xbfec1a07758ccffc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xbfed8403679a1b6d,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbfef00ae7d26261c,
    0x0, 0x0,
    0xbfecccccccccccce, 0xbff04901f171b532,
    0x0, 0x0,
    0xbfecccccccccccc4, 0xbff11d2270f55b1c,
    0x0, 0x0,
    0xbfecccccccccccc2, 0xbff1fe02d577361e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xbff2ed1e8317f202,
    0x0, 0x0,
    0xbfeccccccccccccb, 0xbff3ec2bd9ce6eae,
    0x0, 0x0,
    0xbfecccccccccccd1, 0xbff4fd284472249e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xbff622675b951983,
    0x0, 0x0,
    0xbfeccccccccccccb, 0xbff75ea6114c1e02,
    0x0, 0x0,
    0xbfecccccccccccc8, 0xbff8b5233638a612,
    0x0, 0x0,
    0xbfecccccccccccd4, 0xbffa29bf2b66d240,
    0x0, 0x0,
    0xbfecccccccccccd6, 0xbffbc1255464e0c0,
    0x0, 0x0,
    0xbfecccccccccccd3, 0xbffd8102fa1da676,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xbfff7050fec91ed6,
    0x0, 0x0,
    0xbfecccccccccccf0, 0xc000cbdc2f4a60f6,
    0x0, 0x0,
    0xbfecccccccccccc4, 0xc002010ecbb5f91b,
    0x0, 0x0,
    0xbfecccccccccccd2, 0xc0035eb2dfdfdf49,
    0x0, 0x0,
    0xbfeccccccccccccc, 0xc004edc99aa463d0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0xc006ba35789a9a02,
    0x0, 0x0,
    0xbfeccccccccccccd, 0xc008d3fad768aef9,
    0x0, 0x0,
    0xbfeccccccccccccf, 0xc00b5137b880c653,
    0x0, 0x0,
    0xbfecccccccccccca, 0xc00e5159adcb89ec,
    0x0, 0x0,
    0xbfecccccccccccd0, 0xc011014bfa560d28,
    0x0, 0x0,
    0xbfecccccccccccd5, 0xc01355e79ffbb0fe,
    0x0, 0x0,
    0xbfecccccccccccca, 0xc0165fbb942eb8f4,
    0x0, 0x0,
    0xbfecccccccccccc3, 0xc01a81a322d4ff2c,
    0x0, 0x0,
    0xbfecccccccccccce, 0xc0203b2c44fd1a23,
    0x0, 0x0,
    0xbfecccccccccccc1, 0xc024e6fe4f285982,
    0x0, 0x0,
    0xbfecccccccccccdf, 0xc02d4c71fd1460ae,
    0x0, 0x0,
    0xbfecccccccccccbf, 0xc0386f6639ecffb6,
    0x0, 0x0,
    0xbfecccccccccccc0, 0xc052556f444c538a
    };

static const uint64_t in_cfft_step_512[1024] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
 