static const uint64_t in_rfft_noisy_32[32] = {
    0x3fa89117984a9562, 0x3fddc2de7434712d,
    0x3fe8953f1cd52833, 0x3fde365b89867849,
    0xbfafbe46aab40401, 0xbfdee9c10a4d1b7a,
    0xbfe61a026041333c, 0xbfdf0514866bb5c2,
    0xbfb4ab8518e22a6c, 0x3fe27b90f4351232,
    0x3fe7364e272ce422, 0x3fe09e911971446b,
    0xbfbb5531fa2e1aa9, 0xbfddf28d1b1c50ef,
    0xbfe6d26da0d26eca, 0xbfe098bc0fcec34a,
    0x3fa5058b1de3a42a, 0x3fdcb985e7b42496,
    0x3fe64ea42cf02730, 0x3fdd5a9357e2dbe8,
    0xbfb47ddf1659640e, 0xbfe06d870dffbc64,
    0xbfe78653753192cd, 0xbfdb09e1527bf464,
    0x3fa7cb0593aaf57c, 0x3fe16f2910513255,
    0x3fe5e228dbc3f202, 0x3fdd98ca4eb214f9,
    0x3fa30b8f82a39660, 0xbfdd145b395848c6,
    0xbfe2769458fdf6ff, 0xbfe02bdcaf820d19
    };

static const uint64_t in_rifft_noisy_32[33] = {
    0x3fb9c44a29b4e4f0, 0xbfb8e25d838fda50,
    0x3fd54347b2c2333a, 0x3fbe17eb096f8119,
    0xbfa0dc38a6504f18, 0x3fd1e33746ec1eac,
    0x3fb12975e658d145, 0x3f885e3538125850,
    0x3fd6152bf51766e8, 0xc02635c1f3d5fc80,
    0xbfd1d28a567e523e, 0x3fcd89ff1d9b3be2,
    0xbfc43aed2ee5e523, 0x3f9521f998180fde,
    0xbf832ae373c83840, 0xbfd4fdae608912af,
    0xbfd42fcc6107458c, 0xbfc16ed9bd7e9390,
    0xbfc107065f7744e5, 0x3fcb571595fe1ad2,
    0x3fc116bf1c3ad387, 0x3fab2872b2c5bb59,
    0xbfb70c3904b9368a, 0xbfa036ea65bed43a,
    0x3fc80763c66b54d0, 0x3fb37a27d496d540,
    0xbfc085b2870a16cc, 0xbfb90c6ac7714ddc,
    0x3fe19f78e421af92, 0x3f9688dd0ec3e848,
    0x3fd2f333749a1928, 0xbfca5a16af456f6c,
    0x0
    };

static const uint64_t ref_rfft_noisy_32[33] = {
    0x3fb9c44a29b4e4f0, 0xbfb8e25d838fda50,
    0x3fd54347b2c2333a, 0x3fbe17eb096f8119,
    0xbfa0dc38a6504f18, 0x3fd1e33746ec1eac,
    0x3fb12975e658d145, 0x3f885e3538125850,
    0x3fd6152bf51766e8, 0xc02635c1f3d5fc80,
    0xbfd1d28a567e523e, 0x3fcd89ff1d9b3be2,
    0xbfc43aed2ee5e523, 0x3f9521f998180fde,
    0xbf832ae373c83840, 0xbfd4fdae608912af,
    0xbfd42fcc6107458c, 0xbfc16ed9bd7e9390,
    0xbfc107065f7744e5, 0x3fcb571595fe1ad2,
    0x3fc116bf1c3ad387, 0x3fab2872b2c5bb59,
    0xbfb70c3904b9368a, 0xbfa036ea65bed43a,
    0x3fc80763c66b54d0, 0x3fb37a27d496d540,
    0xbfc085b2870a16cc, 0xbfb90c6ac7714ddc,
    0x3fe19f78e421af92, 0x3f9688dd0ec3e848,
    0x3fd2f333749a1928, 0xbfca5a16af456f6c,
    0x0
    };

static const uint64_t in_rfft_noisy_64[64] = {
    0xbfa19f3eebc6b9b3, 0x3fe09e332b55834f,
    0x3fe5b05db0dbab0f, 0x3fdc8270446799ee,
    0xbf862d2dcd7026f8, 0xbfe0896a5f0aded0,
    0xbfe4da07fd6cd265, 0xbfdf332f6a79b460,
    0x3fbcda97bf2a5f51, 0x3fe0b1417e3c169d,
    0x3fe7f7cb5ed5e138, 0x3fdc877e43885564,
    0xbf9a4de51307e89a, 0xbfe00ae06b08d636,
    0xbfe5a47bc567ff14, 0xbfdc2fdad2259e77,
    0x3fa334b7e284708d, 0x3fddea7b84941dd6,
    0x3fe6c136a9ed372c, 0x3fde6715d842821a,
    0x3fa61ad028349b3a, 0xbfdea11258b7d7e8,
    0xbfe5c08e64e72612, 0xbfdf69c267e7ced7,
    0x3f953bce0b587569, 0x3fe12ea6d113dd12,
    0x3fe5db0cf2456618, 0x3fde1afb478fa5a3,
    0xbf8c3660f7388a03, 0xbfe06f1be896f46c,
    0xbfe64888a7cb4448, 0xbfd9b06ff322f917,
    0xbf8c51e15231bac2, 0x3fdf78476fae1e5b,
    0x3fea0778db75123f, 0x3fe03469028f7c4a,
    0xbfa026000ff9cbbe, 0xbfe02bc80af35111,
    0xbfe818472e8ce877, 0xbfe0e157f36bd1f8,
    0xbf815867f9556f0d, 0x3fdd12ab896123e0,
    0x3fe59da0f602b765, 0x3fded9501b4f432c,
    0x3fb428fa64e19651, 0xbfdc69385cc6df94,
    0xbfe63eec8d538fc7, 0xbfdf3c6175c5f250,
    0x3fa06a21afac4107, 0x3fe08b3e6a4dbe3a,
    0x3fe5a3a4bfb6edc1, 0x3fe31773505abe42,
    0xbfb53f51d24bcfaf, 0xbfdd433a9eb73c34,
    0xbfe5e541ca38951d, 0xbfdc4cda4b7ed2cf,
    0xbfaf538c3f5f446c, 0x3fdd26a62bac3824,
    0x3fe71085d7c44808, 0x3fd94eeccab3c48c,
    0x3f3a96492cc5e2c3, 0xbfd8c0548e1384f3,
    0xbfe6ef96e6103574, 0xbfe1d5ed7bd8ec3b
    };

static const uint64_t in_rifft_noisy_64[65] = {
    0x3fd5a7d809c69672, 0x3faba68f3117eb10,
    0xbfc0888dfcbee041, 0xbfc4dd2c1782fa96,
    0xbfd2c897bc05e7da, 0xbf9e9949cb0c1f50,
    0xbfd177560ef7e04c, 0xbfd409e99fc598f4,
    0x3fc8d2ccccca658c, 0xbf952e0de063d9b8,
    0xbfdb9db0b9beb405, 0x3fd6f09e82d345c7,
    0x3fca3589b4a7e64a, 0x3f852ef0930fd970,
    0xbf9eff0b8dd91ef2, 0x3fe2cf6f8bcb294c,
    0x3fcabb5dfea926d4, 0xc03629cd30698880,
    0x3fa9c928f19b4b52, 0xbfc543d613d8b1ef,
    0xbfc4acbced865fea, 0xbfcce7b5f46188c4,
    0xbfdc961ddc9294aa, 0xbfbc986e7accbb14,
    0xbfd659c72f7484be, 0xbfb7bb0e535b50da,
    0x3fd72587ac715be0, 0xbfd055749fc34fee,
    0xbfcc040df945d31a, 0xbfa7803c789b9a28,
    0xbf99fb2c94395d5e, 0xbfd14f634994f846,
    0xbfbc6749b2977d58, 0xbfc6d73e331ebad0,
    0xbfb16ceb63cce228, 0xbfd69827b9a05cd6,
    0xbfc75b24604478fc, 0xbfd6766cbedcd099,
    0x3fdb406f034fd85c, 0xbfe2dad3e56d2837,
    0x3fcba2d7abb8d5bd, 0x3fcf569a673916e1,
    0x3fd5f56648f1e51a, 0xbfb747c4aa2cbd24,
    0xbfc19b1f0b5c6532, 0x3fd075e9347a8a26,
    0x3fc298bcdcb9a6da, 0xbfc6f0ee488f2d8f,
    0x3fa7c0be0b8b9966, 0x3fd6d21527bc7e20,
    0x3fb65d0a078b70ae, 0x3fb19b40ba34e840,
    0xbfc7475d292b859e, 0x3fb8660ae58b93f8,
    0xbfe20c1492553c86, 0xbfc75edb6ce4c7ba,
    0xbfcd80640e0901c4, 0xbfc5d955bfa93723,
    0x3fc94d04897e40b1, 0xbfba84d5e4d8044e,
    0x3f9d277ccfa66258, 0x3fdb2b07f35764fb,
    0x3f9be40a90d89be6, 0x3fdc396d1a49e3fd,
    0x0
    };

static const uint64_t ref_rfft_noisy_64[65] = {
    0x3fd5a7d809c69672, 0x3faba68f3117eb10,
    0xbfc0888dfcbee041, 0xbfc4dd2c1782fa96,
    0xbfd2c897bc05e7da, 0xbf9e9949cb0c1f50,
    0xbfd177560ef7e04c, 0xbfd409e99fc598f4,
    0x3fc8d2ccccca658c, 0xbf952e0de063d9b8,
    0xbfdb9db0b9beb405, 0x3fd6f09e82d345c7,
    0x3fca3589b4a7e64a, 0x3f852ef0930fd970,
    0xbf9eff0b8dd91ef2, 0x3fe2cf6f8bcb294c,
    0x3fcabb5dfea926d4, 0xc03629cd30698880,
    0x3fa9c928f19b4b52, 0xbfc543d613d8b1ef,
    0xbfc4acbced865fea, 0xbfcce7b5f46188c4,
    0xbfdc961ddc9294aa, 0xbfbc986e7accbb14,
    0xbfd659c72f7484be, 0xbfb7bb0e535b50da,
    0x3fd72587ac715be0, 0xbfd055749fc34fee,
    0xbfcc040df945d31a, 0xbfa7803c789b9a28,
    0xbf99fb2c94395d5e, 0xbfd14f634994f846,
    0xbfbc6749b2977d58, 0xbfc6d73e331ebad0,
    0xbfb16ceb63cce228, 0xbfd69827b9a05cd6,
    0xbfc75b24604478fc, 0xbfd6766cbedcd099,
    0x3fdb406f034fd85c, 0xbfe2dad3e56d2837,
    0x3fcba2d7abb8d5bd, 0x3fcf569a673916e1,
    0x3fd5f56648f1e51a, 0xbfb747c4aa2cbd24,
    0xbfc19b1f0b5c6532, 0x3fd075e9347a8a26,
    0x3fc298bcdcb9a6da, 0xbfc6f0ee488f2d8f,
    0x3fa7c0be0b8b9966, 0x3fd6d21527bc7e20,
    0x3fb65d0a078b70ae, 0x3fb19b40ba34e840,
    0xbfc7475d292b859e, 0x3fb8660ae58b93f8,
    0xbfe20c1492553c86, 0xbfc75edb6ce4c7ba,
    0xbfcd80640e0901c4, 0xbfc5d955bfa93723,
    0x3fc94d04897e40b1, 0xbfba84d5e4d8044e,
    0x3f9d277ccfa66258, 0x3fdb2b07f35764fb,
    0x3f9be40a90d89be6, 0x3fdc396d1a49e3fd,
    0x0
    };

static const uint64_t in_rfft_noisy_128[128] = {
    0xbf8255c35c4ecec7, 0x3fe0f66c830ecc1b,
    0x3fe5280da71c812f, 0x3fe050f9716d7c99,
    0xbf96605179ee2db0, 0xbfdc797571a8b236,
    0xbfe6a28bd97327b7, 0xbfdc9f40e0a8150f,
    0xbf723f0de90e5be9, 0x3fde3b421e08786f,
    0x3fe6cd67639cd228, 0x3fe1cdf25bcf9cf8,
    0x3faa6022425dc24c, 0xbfdd268324057c35,
    0xbfe54abe72ed2e20, 0xbfddc3fa8af82ebc,
    0xbf9b14d9ebd79550, 0x3fe0a7b02eac1a83,
    0x3fe6b42a0f4692ed, 0x3fdfaa1d9c374e2a,
    0x3fa93d28c260c706, 0xbfe13cb83c778845,
    0xbfe60fd8e2530ee3, 0xbfe2254cbce5c318,
    0xbfafe4fed873fd7a, 0x3fdcf433e52f241c,
    0x3fe5390e21933a0c, 0x3fda4396664b3c3f,
    0xbfa29a963cb64848, 0xbfdedfebb22846dc,
    0xbfe64a755e8b9da0, 0xbfe1cb9b66eaf69a,
    0x3f4d9152ca380738, 0x3fdeff399ceca5fc,
    0x3fe328392dd1f32a, 0x3fe0004e39a7d476,
    0x3f8ac67b6a68f9e5, 0xbfde457efa69eb57,
    0xbfe62ff6330169ab, 0xbfe02baa867389c4,
    0x3fa7906a1a7f2014, 0x3fe09b19059693d2,
    0x3fe7875f8e9fd060, 0x3fdd4c09c0c8d539,
    0x3f8d83adcb58f85e, 0xbfdc994ce949073c,
    0xbfe51654cf3ef23c, 0xbfe1472a43c2614c,
    0xbf8154847b0abd5e, 0x3fe001823081511b,
    0x3fe6f81bf1e11a9f, 0x3fe092c06aa637c5,
    0x3fa0f805f0f52d05, 0xbfdc46020564b28e,
    0xbfe5d627d2a749a8, 0xbfe0d5343c7b2cd5,
    0x3f8ae74b1e9bffb1, 0x3fe09ce9d793bb03,
    0x3fe60deaf1a0f874, 0x3fdbb2756272fc74,
    0xbfa87cf11b38b3df, 0xbfdfa20a226d5cdc,
    0xbfe5e6edeff9e2d0, 0xbfdf0503bde96d3b,
    0xbfb01c8e7682021b, 0x3fe2631ac0c57c2c,
    0x3fe5e48f2dcdbc0b, 0x3fe388aec04fc1d3,
    0xbf53f9b6987b9dc0, 0xbfe0f5e720f3b121,
    0xbfe64d58fa57abb3, 0xbfdf6b4811cbcee0,
    0xbfb357dfbe83a28e, 0x3fdebfaecedd5fb6,
    0x3fe3562c37d256cd, 0x3fe025fb55a091b9,
    0x3fc1b255bba56b33, 0xbfdf110bbf428968,
    0xbfe53b4f7ac4e3f2, 0xbfdd443f037c2616,
    0xbf981e510ea5bb1a, 0x3fe11d4afc5eb137,
    0x3fe6ca8f9b505234, 0x3fdd772dd192a776,
    0x3f90a594625f2faf, 0xbfe1dc3157251947,
    0xbfe4f1c2f017ab70, 0xbfdbac0246f3e7ca,
    0x3f8a08ae3854f3d0, 0x3fe3c17291a5fcf0,
    0x3fe6aac20074bdb9, 0x3fe0bffada4ecdc5,
    0x3fa0a42ed2c05ace, 0xbfdbb2ceb00ee108,
    0xbfe5e7275492aaec, 0xbfe109c7cf5cc1d2,
    0xbf9f68888cdb322b, 0x3fe063b478be51d5,
    0x3fe34febd911b29e, 0x3fddaa53cbbe1c42,
    0x3faf530c8500aa26, 0xbfe2d6f27c147e61,
    0xbfe6603f624e7e04, 0xbfe1e3fb88c7ef7f,
    0xbfa24cd78b11399f, 0x3fe318dd1f4bafda,
    0x3fe87168ca63fe7a, 0x3fda1a820840bd1d,
    0x3fa689ef83be2c00, 0xbfde7b0b20ac6d6a,
    0xbfe8ed4aaad00501, 0xbfde3c8ac22884e0,
    0x3f735ba1ca0ac551, 0x3fdf3f91fbab1772,
    0x3fe57f7b3740a70d, 0x3fde407d759e9490,
    0xbf7b4f976e72af36, 0xbfddfdde2ebea5e9,
    0xbfe4067b8bcefaf2, 0xbfe213d8f58050c9,
    0xbfa174dbc20d37bd, 0x3fdbde4a794e0196,
    0x3fe8cd3caea9e62f, 0x3fe144cea3b45814,
    0x3f9c17d15b18af33, 0xbfdc0f27ae8c0d40,
    0xbfe3c4b8fee06bd0, 0xbfe1362577479091
    };

static const uint64_t in_rifft_noisy_128[129] = {
    0x3fd8e1ef5d2d50c1, 0xbf976070a1950bf0,
    0xbfabb219d819de10, 0x3fd20268b42c72b1,
    0x3fe07967b60706a4, 0xbfc925b0413018f0,
    0x3fed1dc5db4099c6, 0xbfe0642c0c06929e,
    0xbfdf732a6c5ec14e, 0xbfbd67b5471e657e,
    0xbfe38af729020128, 0x3fbfda2ee1dd258e,
    0x3fcd407ff5e107f5, 0x3fc2daeb5e80e74e,
    0x3fd9f8b8faa8b4b7, 0x3fe32d68f19802c6,
    0x3fb2219fefc6b164, 0x3fda4113dd0bad44,
    0xbfe1e26a6cdefbba, 0x3fc6c87525ce835c,
    0x3fe3a4abd1db66cc, 0xbfe24aafe001ed94,
    0xbfd8ed010d58e552, 0x3fe91008c5ec7db6,
    0x3fbda1b42b52cc23, 0xbfa60536d2078840,
    0x3fcbc969d8df1c8a, 0x3fdd25e3be2a3048,
    0xbfdbfe10833a552a, 0xbfab5cf036993b30,
    0xbfda013f16002cec, 0xbfb7b0a3279cd738,
    0xbfe562e8e81c8b38, 0xc0464446df76a06c,
    0x3fa2487ed1f53468, 0x3fc574b307a7229a,
    0xbfc597ba76f6e044, 0x3fc1a9e0bf30c3f5,
    0xbfc8ebf7cb1a4085, 0x3fbc18a24a08998d,
    0xbfb0458fc53cc948, 0x3fbedbe7781b5d24,
    0xbfcc8cb2c052db6f, 0xbfe33b6402839fa2,
    0x3fe31c8a040af7ea, 0xbfe0f0c705c696f8,
    0x3fd893dcbe163445, 0xbfa83a809fc56954,
    0xbfd07e81ba676bad, 0x3fb1c305703832ea,
    0x3fe4d62e976573fe, 0x3fbd52df8a77c18c,
    0xbfda48a7d6e463a7, 0xbfc438cdd2c8aa95,
    0x3fd0e119eac0c13e, 0xbfaf45cddcfe0b0c,
    0xbfcfc6736e32e15f, 0x3fd68fd385ae2bbd,
    0x3fb33383a575417a, 0xbfa0a256dff9430a,
    0xbfec52d97803e8c0, 0x3fdbc18e519eb28b,
    0xbfbad6cb34ec37c0, 0xbfbde6394b492cb5,
    0xbfa473d7068faff8, 0xbfe8442674b0d3c0,
    0xbfc2a6de10b5753c, 0x3fa6dbd576bfddfa,
    0x3fc177c1411793d0, 0x3fd0f2ba22eb98fd,
    0xbfc9e352703888ed, 0x3f9c700b4488eef8,
    0x3fc1aecb7d2291b9, 0xbfe17e247f2373c4,
    0xbfb006cca976459e, 0xbfdc8b9085eb71bc,
    0xbfd8895bd9a32dd5, 0xbfd060388521052c,
    0x3fd5354fdd1199ba, 0xbfdc6bfc6ef86a5b,
    0x3fe4962396c2f92a, 0xbfc74ab1c93fdf97,
    0xbfc9aca8f62d6b16, 0x3fad1ed4972dcce0,
    0xbfdfb0a9400b2863, 0x3fd4d2d1ab36c1a9,
    0xbfe2e732fa359e6e, 0xbfc5f92e3283aaf2,
    0x3fd4596555272260, 0xbfe714dd9f079268,
    0x3fd33b310c3cefc4, 0xbfa483038dac0d9e,
    0x3fe11f415697d337, 0xbfd7e77e8971f9d6,
    0x3fc115027ff93b44, 0x3feaf3e300348250,
    0xbfe5094240a69e58, 0xbfe6da55c9a4b600,
    0x3fda7ec576776286, 0xbfd534b6456da248,
    0x3f7fb7bc376804a0, 0x3fdd9b4edf66d1d2,
    0x3fd98ad7dc674eed, 0x3fa6f5a95661b304,
    0x3fd4c0354cc58585, 0xbfcdd4af4fad2d52,
    0x3fc6921e40a4cf7b, 0xbf8eed92e18c9600,
    0xbfc8eb9671e460a6, 0xbfbff879e4f04c90,
    0x3fc450003ff30d22, 0x3fa23def396c6952,
    0xbfe08a8fc42f2cd2, 0xbfc504363293031c,
    0xbfd830c40f561ec5, 0x3fa6e55e16050608,
    0x3facc89ccf6f14f4, 0xbfe5289e684ce334,
    0x3fe28183d8829096, 0xbfd29a2db8f76cd0,
    0xbfde7aefb327b17a, 0xbfd6c537ed3287f8,
    0x3fb9cf2d79e92e54, 0xbfc9e7d89260e03b,
    0xbfd8e0d5a4b5be97, 0xbfd85be423a2d6aa,
    0x3fd41f88d9b148d2, 0x3fba6f33b81d6d87,
    0x0
    };

static const uint64_t ref_rfft_noisy_128[129] = {
    0x3fd8e1ef5d2d50c1, 0xbf976070a1950bf0,
    0xbfabb219d819de10, 0x3fd20268b42c72b1,
    0x3fe07967b60706a4, 0xbfc925b0413018f0,
    0x3fed1dc5db4099c6, 0xbfe0642c0c06929e,
    0xbfdf732a6c5ec14e, 0xbfbd67b5471e657e,
    0xbfe38af729020128, 0x3fbfda2ee1dd258e,
    0x3fcd407ff5e107f5, 0x3fc2daeb5e80e74e,
    0x3fd9f8b8faa8b4b7, 0x3fe32d68f19802c6,
    0x3fb2219fefc6b164, 0x3fda4113dd0bad44,
    0xbfe1e26a6cdefbba, 0x3fc6c87525ce835c,
    0x3fe3a4abd1db66cc, 0xbfe24aafe001ed94,
    0xbfd8ed010d58e552, 0x3fe91008c5ec7db6,
    0x3fbda1b42b52cc23, 0xbfa60536d2078840,
    0x3fcbc969d8df1c8a, 0x3fdd25e3be2a3048,
    0xbfdbfe10833a552a, 0xbfab5cf036993b30,
    0xbfda013f16002cec, 0xbfb7b0a3279cd738,
    0xbfe562e8e81c8b38, 0xc0464446df76a06c,
    0x3fa2487ed1f53468, 0x3fc574b307a7229a,
    0xbfc597ba76f6e044, 0x3fc1a9e0bf30c3f5,
    0xbfc8ebf7cb1a4085, 0x3fbc18a24a08998d,
    0xbfb0458fc53cc948, 0x3fbedbe7781b5d24,
    0xbfcc8cb2c052db6f, 0xbfe33b6402839fa2,
    0x3fe31c8a040af7ea, 0xbfe0f0c705c696f8,
    0x3fd893dcbe163445, 0xbfa83a809fc56954,
    0xbfd07e81ba676bad, 0x3fb1c305703832ea,
    0x3fe4d62e976573fe, 0x3fbd52df8a77c18c,
    0xbfda48a7d6e463a7, 0xbfc438cdd2c8aa95,
    0x3fd0e119eac0c13e, 0xbfaf45cddcfe0b0c,
    0xbfcfc6736e32e15f, 0x3fd68fd385ae2bbd,
    0x3fb33383a575417a, 0xbfa0a256dff9430a,
    0xbfec52d97803e8c0, 0x3fdbc18e519eb28b,
    0xbfbad6cb34ec37c0, 0xbfbde6394b492cb5,
    0xbfa473d7068faff8, 0xbfe8442674b0d3c0,
    0xbfc2a6de10b5753c, 0x3fa6dbd576bfddfa,
    0x3fc177c1411793d0, 0x3fd0f2ba22eb98fd,
    0xbfc9e352703888ed, 0x3f9c700b4488eef8,
    0x3fc1aecb7d2291b9, 0xbfe17e247f2373c4,
    0xbfb006cca976459e, 0xbfdc8b9085eb71bc,
    0xbfd8895bd9a32dd5, 0xbfd060388521052c,
    0x3fd5354fdd1199ba, 0xbfdc6bfc6ef86a5b,
    0x3fe4962396c2f92a, 0xbfc74ab1c93fdf97,
    0xbfc9aca8f62d6b16, 0x3fad1ed4972dcce0,
    0xbfdfb0a9400b2863, 0x3fd4d2d1ab36c1a9,
    0xbfe2e732fa359e6e, 0xbfc5f92e3283aaf2,
    0x3fd4596555272260, 0xbfe714dd9f079268,
    0x3fd33b310c3cefc4, 0xbfa483038dac0d9e,
    0x3fe11f415697d337, 0xbfd7e77e8971f9d6,
    0x3fc115027ff93b44, 0x3feaf3e300348250,
    0xbfe5094240a69e58, 0xbfe6da55c9a4b600,
    0x3fda7ec576776286, 0xbfd534b6456da248,
    0x3f7fb7bc376804a0, 0x3fdd9b4edf66d1d2,
    0x3fd98ad7dc674eed, 0x3fa6f5a95661b304,
    0x3fd4c0354cc58585, 0xbfcdd4af4fad2d52,
    0x3fc6921e40a4cf7b, 0xbf8eed92e18c9600,
    0xbfc8eb9671e460a6, 0xbfbff879e4f04c90,
    0x3fc450003ff30d22, 0x3fa23def396c6952,
    0xbfe08a8fc42f2cd2, 0xbfc504363293031c,
    0xbfd830c40f561ec5, 0x3fa6e55e16050608,
    0x3facc89ccf6f14f4, 0xbfe5289e684ce334,
    0x3fe28183d8829096, 0xbfd29a2db8f76cd0,
    0xbfde7aefb327b17a, 0xbfd6c537ed3287f8,
    0x3fb9cf2d79e92e54, 0xbfc9e7d89260e03b,
    0xbfd8e0d5a4b5be97, 0xbfd85be423a2d6aa,
    0x3fd41f88d9b148d2, 0x3fba6f33b81d6d87,
    0x0
    };

static const uint64_t in_rfft_noisy_256[256] = {
    0x3fa3a093d12bc8b0, 0x3fdda0360699b0b6,
    0x3fe58b53c36213ca, 0x3fd9d909e82a632a,
    0x3fa30d89aa484b7c, 0xbfde052c178cff92,
    0xbfe4c01feebf9195, 0xbfe0d06b1215320d,
    0x3f9d40e616b7f846, 0x3fd9e68e056c256e,
    0x3fe6efa92e51a842, 0x3fe0244a6251f0cf,
    0x3f916cb78d188a67, 0xbfdde0fd3397a256,
    0xbfe93264e320ef7c, 0xbfe366ee18b15339,
    0x3fb2c45acd014d6e, 0x3fddb0b513f14ab7,
    0x3fe728dac05b5730, 0x3fe0da47ae41c695,
    0xbf9adc31d0836ef8, 0xbfd9f25f307cd10c,
    0xbfe589601b203c56, 0xbfe026153068095e,
    0xbfaa567b3b58c43c, 0x3fde0b0e5655fb40,
    0x3fe55d36cac59f0d, 0x3fdf2268d6ac8e9f,
    0xbfab57a9886d5734, 0xbfdd7e11eff49191,
    0xbfe78b5bae70f424, 0xbfe03c86eea560d5,
    0xbf9f1e28dee66570, 0x3fe1fa57ef27c7f7,
    0x3fe85402ab832e6c, 0x3fdaf2ce16aab555,
    0xbfb043fb36e07c75, 0xbfe0d1b65841b4dc,
    0xbfe784bd5576de1a, 0xbfdf01b5013e1d4c,
    0x3fa5e23394f87321, 0x3fe10702c4679664,
    0x3fe5fc3c1957c677, 0x3fdd58cac63c9b4b,
    0xbfbc36bbd51a51c1, 0xbfe108bac2467d11,
    0xbfe61630744d36ec, 0xbfdff8f2ef03cbe7,
    0x3fae9704303668b9, 0x3fdc8a1cb704eebe,
    0x3fe3e24eb0aa4079, 0x3fd98a4a36e9a47a,
    0xbfb073cc57035866, 0xbfdf5b717e02204e,
    0xbfe616579cac1174, 0xbfde524dd3b09a96,
    0x3f895fed78dd1e40, 0x3fdd37f9f2452ac0,
    0x3fe946f96344fc87, 0x3fe068643913c713,
    0x3f7b96c775493ad3, 0xbfe194f303a2811e,
    0xbfe528a3eafba170, 0xbfde39588aefbe13,
    0x3f50a71b20a9a44a, 0x3fe00ed24c0a7aa8,
    0x3fe88cdf110f526d, 0x3fe2db4964d40497,
    0x3fa9f086bc47fb61, 0xbfe2d56eda57a7dc,
    0xbfe888bf645ad483, 0xbfe00f523be5f936,
    0x3f70fe0566706618, 0x3fe1a64541c07987,
    0x3fe688ba223f2f38, 0x3fe0d3d659cd6723,
    0xbfb2fe14f19c0565, 0xbfdf1a9f555392fb,
    0xbfe73c7ab8b13e03, 0xbfe19a99c6ae28be,
    0x3f79ee7d48a4d844, 0x3fde82574b13fc8f,
    0x3fe291582e948a65, 0x3fdf0fb6954654a9,
    0x3f9c75e3433a863e, 0xbfdda0260b1de97e,
    0xbfe3c392f303b2a6, 0xbfddfc2f9c31a016,
    0xbf95e94badc14c0e, 0x3fdf010166865cbe,
    0x3fe5861e07a47bae, 0x3fde47d6a6a32b8c,
    0xbf6778078904d25d, 0xbfdb06e8fab21ef5,
    0xbfe6340f71b52bdd, 0xbfde2ee5429d33ae,
    0xbfa67548eda75649, 0x3fe035d706a5a39a,
    0x3fe3964dcc03be3d, 0x3fe19d32fe9beca9,
    0x3f6f42f0ddc9d723, 0xbfdc8fe2ea0f96f6,
    0xbfe4e670b3bd3e82, 0xbfdd6c9cdd977808,
    0xbfb0901f3d74574b, 0x3fdc384a6cda70c2,
    0x3fe775c118502175, 0x3fdf6a8c0d9e5df0,
    0xbfaa75e13d2b1108, 0xbfdc859932fdfeae,
    0xbfe594683b075275, 0xbfdd2dcbffa5461e,
    0x3fb17b7c3d2f0f14, 0x3fdea2e33f75812c,
    0x3fe5a242687e4b9d, 0x3fdf7daad6cfcabd,
    0x3fb243e054132bb9, 0xbfdec5ef7af5f69e,
    0xbfe53b116ee06265, 0xbfdb674e4ff0b4b1,
    0x3fa54005ee7672ce, 0x3fdfb0dacb8c1e96,
    0x3fe5c1361923c8b1, 0x3fdabf29a8056012,
    0x3f6a39eb1089c235, 0xbfe11c539ca367bc,
    0xbfe94fde1a8d0312, 0xbfe1806bf7b65f65,
    0xbfa75ca512d0d90b, 0x3fde2d3178de2f7b,
    0x3fe90ca729bfca9d, 0x3fd9766004431734,
    0xbfa7f11e7d92d5cb, 0xbfddaf31f4946141,
    0xbfe83fefa478e9db, 0xbfd88c4c7a69790b,
    0xbf9303ca16b71b31, 0x3fdaa5632139bbec,
    0x3fe7e678effb9e1f, 0x3fe129ae91336016,
    0xbfb9bea0fd4fa4f2, 0xbfe155d3014f238d,
    0xbfe7895f64636988, 0xbfde0d93411c6f70,
    0x3faee917334f5f7b, 0x3fdce0537d28da5f,
    0x3fe30421665bd283, 0x3fdce374ab67165c,
    0x3fb1463965c714c4, 0xbfe2ecd9d47ed6ab,
    0xbfe519765614afe2, 0xbfe123ff9741871a,
    0xbf9c295345ed9ecd, 0x3fe2cce3777260b0,
    0x3fe64ca2268949af, 0x3fdc3f0ae4f58dac,
    0x3f9f21b9d4d591ff, 0xbfdd144b920a6761,
    0xbfe5f78138126073, 0xbfde784b96e91a8a,
    0x3f897a7b9153a8e5, 0x3fdcbfb419740cdb,
    0x3fe5f4bf61f8b213, 0x3fd8403ca2523e94,
    0x3f90e6571317538e, 0xbfde4f7105654e0e,
    0xbfe75118ddab5475, 0xbfe27512e6f8d831,
    0x3f8808e51e361e6b, 0x3fda67283d0aaafc,
    0x3fe9319a1c3e7741, 0x3fe1cd2c610073af,
    0x3f9ab2c076cc4950, 0xbfe0dc81c9d4bfcc,
    0xbfe856f39ab4cb65, 0xbfe048e689cff4f2,
    0x3f9dc34031b2b1c5, 0x3fdd05d4c7192f60,
    0x3fe78673387aec64, 0x3fddd2d445c6ea56,
    0x3fad1ca71a07bac2, 0xbfe06c4c1a3481cb,
    0xbfe743eac49017b4, 0xbfe06342619440f7,
    0x3f922a6e77857f87, 0x3fdc745d340fdf88,
    0x3fe656b2da7f7ef3, 0x3fe1d70db388f6b5,
    0x3fa9184d0ccf751e, 0xbfe080171dc6243e,
    0xbfe7cf4b9a28e03d, 0xbfdfcb06c28ac725,
    0x3f97b25687ab0ab8, 0x3fde3171004fae23,
    0x3fe765de09adce76, 0x3fdd04dc13324d72,
    0xbfb3270f38dbd187, 0xbfe0e37a81f54efe,
    0xbfe562679d151d41, 0xbfe028d6189c062a,
    0xbfa3b0bdf589cf53, 0x3fdfa5dc81e5795d,
    0x3fe75fd702873553, 0x3fe0c5de2e85ef63,
    0xbfaa4a85498f5c69, 0xbfe0b76916c51083,
    0xbfe595fe16b8eea3, 0xbfe004bc641ba5f6,
    0x3f9b26ada4103553, 0x3fde99fe131ca6c2,
    0x3fe5c898cc507f89, 0x3fe0aa28bb68e6cf,
    0x3fc2c87726174a9e, 0xbfe1f2f6525cfdd5,
    0xbfe3c9073b1ee31d, 0xbfe283e780229269,
    0xbf936af1f55a1568, 0x3fe148dca9e7ca20,
    0x3fe82393992d2d20, 0x3fdf46bd519f35eb,
    0x3fa48c312301e7c0, 0xbfe0d73890b24f4d,
    0xbfe68680bec8bcaf, 0xbfdc491c2abc6e26,
    0xbfa0cb916b9fdaf8, 0x3fe28d07cb3df399,
    0x3fe3b22798212b6e, 0x3fdcfed937f738d7,
    0x3fafe62da50d7f52, 0xbfe109cbcee74d51,
    0xbfe50dcc89478446, 0xbfde7888c3f1cddb,
    0xbf936af60419bc2a, 0x3fddd9cce394658f,
    0x3fe4edccda3618d5, 0x3fdf189e71237858,
    0x3fafe2e19244bf2f, 0xbfdfa5a90b071b20,
    0xbfe4d5106ac7dcc4, 0xbfe0f7e46bf2fa48,
    0x3f9065dd70f01b14, 0x3fdd4fcc264a122d,
    0x3fe7f05a8f1f3048, 0x3fdcc6e7c9a8cf77,
    0x3fb12c2abd2e6ef5, 0xbfda365194af391d,
    0xbfe6a61e97aa62d3, 0xbfe04548ada7b219,
    0x3f79cdb54bc8e432, 0x3fdfe7c01c1fa5cd,
    0x3fe75fb2f9d88d3d, 0x3fdf4cabb2881a94,
    0x3f9fd8a6079d0bdb, 0xbfde94af658751e1,
    0xbfe6ef6bdb9e446c, 0xbfe27c76f5c2950b
    };

static const uint64_t in_rifft_noisy_256[257] = {
    0xbfe927f57c820850, 0x3ff7df9746b25918,
    0x3fcb6f4e54f81200, 0x3fbe20f4129d80e0,
    0xbfa6979d8d8580f0, 0x3ff14d241b256560,
    0x3fd17ac2e231edb5, 0xbfa6843af1c1fd50,
    0xbfc35dd14a4cdc80, 0x3fd3996754c169d2,
    0x3fc88b431267d77a, 0xbfe5b31c1ef16cd5,
    0xbfe4d030cc0135fa, 0x3fce1e30f0251406,
    0x3fd43efa607b7b2c, 0x3fe4c2de61a4ab40,
    0xbfacafaf7fa93958, 0x3fe8560e08196b1b,
    0xbfc0c4044c41e16c, 0xbfdba7f939e1822a,
    0xbfed597ab9597911, 0xbfd1dd0b4c682b81,
    0x3fc36e4b40fddac9, 0x3fe91b2a14ffde9b,
    0xbfc1284d8f62a018, 0xbfd676a652698624,
    0x3fdd837e728f5633, 0x3fd90713a2abf06b,
    0xbfe5c9cf9c96fc05, 0xbfe41c7aa999e06c,
    0x3fe315bfdf396d60, 0xbfcd7b59af71bcfc,
    0xbfe50153c0cc0fac, 0xbfc0d4bb05015d70,
    0xbfd0ee2ee77444f1, 0x3fb26746ea95e220,
    0x3fbec24f1b234da2, 0xbfe257b511472f4e,
    0xbfe34c53fbfa8632, 0x3fc226a573f0d7f2,
    0xbfe3d45daf871436, 0xbfa104787204fac8,
    0xbfc2693af774af38, 0x3fd6e10a99299282,
    0xbfe463b2c34fb3e8, 0x3fbbea52fedbda58,
    0x3fe27ab9785b4ba6, 0x3fe402235a1cff4b,
    0x3fdd1a9f6f50aea3, 0x3fc0f6ae1cfb65a0,
    0xbfddac143ed3d1be, 0x3fc45b28adb18688,
    0xbfb7cc64d1d20162, 0xbfc7cc4062112514,
    0x3fe6b9ddbea342f3, 0x3fc3ce79029f3f5f,
    0x3fd9ed2560eaf6ee, 0xbfed4d6b8cc15a62,
    0xbff52a175c683427, 0xbfc619886ab09eb4,
    0x3fd41efaff950f64, 0x3ff52bae00cff300,
    0xbfe4e4a3b97346bf, 0x3fcf12ba0b47d5b8,
    0xbfb1d2d993340101, 0xc0564cbb42c99725,
    0x3f467765d4f93000, 0xbfe88538e32c581d,
    0xbfea471684cd3c26, 0x3fb672e010a4d070,
    0xbff0d9c6a896c096, 0x3fdf04ef765b7956,
    0xbfc2d56f120bf0ac, 0xbfe2a0f8cd4bccc8,
    0xbfd51c178e9bd000, 0x3ff2faa200e1fb0e,
    0x3fdff65c4ba7925f, 0x3fc2855ae2b882ac,
    0x3ff3fa2a98ea0dcc, 0xbff3bcdac84667fe,
    0xbfd2cd796c1f2818, 0xbfe8d81c411a8dee,
    0x3fc1c2e1d573eda0, 0x3fe8161d8e1e005a,
    0x3fe41eeb488a13bd, 0x3feac89cb1761c61,
    0x3f979c45debf8dc0, 0x3fed78dd6f27fce5,
    0xbfcbea2c659d77fc, 0xbfdb5ed19cee41fc,
    0x3fee55088883bb36, 0x3fb3c455b80b9266,
    0x3fda928f58fdbc86, 0xbfd30ac77d9fcab6,
    0x3fbdbffd0027e84c, 0xbfeb9d31bd6d5ab4,
    0x3ff6dca291b63284, 0x3fc10700595e256c,
    0x3f8beca26ff0bce8, 0x3fbf9181bff80e44,
    0xbfc8ae8f3e64c394, 0xbfe7c1a7093db36c,
    0xbfe3249069f90585, 0xbfd036be3ba6eced,
    0x3fb60578576a37be, 0xbfe07bbf32a26ef0,
    0x3fe6d5acb0bb52ff, 0x3fe7a61ae0f3e6b0,
    0xbfc0828a1d0cebb8, 0xbfe6e3f138f5ebc2,
    0xbfe110bd122d8972, 0x3fe75d3103a40c91,
    0xbfefad2936e5c103, 0xbfed59673cf0b4e4,
    0x3ff11bb2da5979f0, 0x3feb6678aaf553c0,
    0xbfdf6f4a3ce35b51, 0xbfd651b2c49f99ee,
    0xbfd6b2d650ff052e, 0x3fbe9defc862d7f4,
    0x3fb1f98fd18bee82, 0x3fe0bd9fc5289d6d,
    0x3fe48f965bd2af7a, 0xbfe244e63ee829fc,
    0x3fdf684d5a5904c0, 0xbfe3a3f893e845cc,
    0x3fc496ef1d5bae8a, 0xbfeea453db31eab5,
    0x3fd27c23911c3ce1, 0xbfc3c98bfa016e80,
    0xbfbcb63a28c869a8, 0xbfd0ecd1fb2c0a12,
    0x3fbc180127ce1828, 0xbfe3028065b9ab1e,
    0x3fdacb495f996d77, 0xbfb56fdbb430203a,
    0x3faeeb610c5daae5, 0x3fe6476cb2440fb5,
    0xbfc3f730bae7010f, 0xbfd9ed12106303df,
    0x3fea6b85da86e4ba, 0xbfe70bb68df8c197,
    0xbfb834bc22da0518, 0xbfde0a75335f8ce0,
    0x3f800a4d7e3f4840, 0x3fa8332e11bec528,
    0x3f9b668f6ba7c890, 0xbfa78349daa9a2d0,
    0xbfb4ef7f988bdac9, 0xbfc05a53b4ff3f22,
    0x3fe2657aef845b67, 0x3fd0009335a5fe54,
    0xbfd4765e1686f8f0, 0x3fe657b5267fb1d8,
    0xbfc020ec4adca538, 0x3fcaeac179acdaca,
    0xbfc5573745e46960, 0xbfe30025f056afcc,
    0x3f879a4e92be04c8, 0x3fdcc1eff06b0071,
    0x3fe2d022fc943ac9, 0xbfec795eee3604cd,
    0xbfe3317e20642726, 0xbfaf78cf89387b88,
    0x3fd21c7ce7cf11d6, 0x3fd5cfbf5ba91a50,
    0x3fd6ef9ca9d5e0e0, 0xbfafc15e4358267c,
    0xbfdab845930686e2, 0xbfea72a7ff1a13b8,
    0x3fe4b63291a1eb9a, 0xbfd3fbb6fc4890ce,
    0xbfe794538540e1d7, 0xbfd3a6aa3fb3f6ca,
    0x3fe745be2ad03e09, 0xbfe94e9210d31b80,
    0xbff5d9697d0b1aa8, 0x3feebaa0b6cd703a,
    0x3fbc8e23d7d5f848, 0xbfea346814cfbb7b,
    0xbfa9cf6474c05d98, 0x3fdd5b97266036fa,
    0x3fccdd9a8fb41090, 0xbfe01b2531da4ff9,
    0x3ff2a4a85b7a25d0, 0x3fe88f4f1c36e748,
    0x3fc88362a46431e6, 0x3fea585116b5a7ad,
    0xbfe9c74df5f20788, 0x3ff514be77b914bf,
    0x3fc9d52ca8f62f96, 0x3fcadda01389fdbc,
    0x3fb88e49b3450a29, 0x3fdf2d3e0623cc00,
    0x3fcc1693a35e6465, 0xbfed6a81e6f82152,
    0x3feba6f87e90e2b4, 0xbf9e9118fd0fae80,
    0x3fec7c77a281d11e, 0xbfe8cc0c6d325a21,
    0xbfc3a0e88b801531, 0x3fe3d633f6d7ab9a,
    0x3fbc5de6efc63bd8, 0xbfd2677d3ad7095c,
    0x3fc08b93d3415db9, 0x3fc863a2a1a31c38,
    0xbfef1dbc8fa4c66d, 0xbfde413cdb57c978,
    0xbfe130527c4c38c8, 0xbfc978c1cac10c34,
    0xbfe0dc682225ca0e, 0x3fe4d8dcb6ed14c5,
    0x3fca47c7c5c6eca2, 0xbfd7ac861d0f1342,
    0xbfb55f52a8daa9fc, 0xbfde04b0afe0ccb0,
    0x3fd1ede788107380, 0xbfd3f382ed780f13,
    0xbf6f42a58bbb3b80, 0xbfc08156c872c180,
    0x3fc0695a89c4f315, 0x3fd37fe68b65f56a,
    0x3fe08f507c46724a, 0x3fab9abcc87b4a48,
    0x3fb110814ae271b4, 0x3fec67cae617a58c,
    0xbfd62b3b743b5e95, 0xbfcbe54c32679b66,
    0x3fde161aefa5169e, 0xbfdf451526d338e9,
    0xbfb3cf4d4cb99314, 0x3f919e26d641f4f0,
    0x3ff1763d9c450533, 0xbfab08ff5c617408,
    0xbfc348ed32713841, 0x3fe028c16020a25f,
    0xbfe3fc6afa6cf41f, 0x3fe7a99205053628,
    0xbfc614b721bb174e, 0x3fe8fcf365d55145,
    0xbfe1e5b07911282e, 0xbfdc2d49029954d6,
    0xbfb152024c29a5d2, 0x3fcb68638266977a,
    0x3fe0f60dab2c7064, 0xbfac68e9734b1e38,
    0x3fe2166585ef006e, 0x3ff00a2bb4d91def,
    0x3fe92711813ea3ea, 0xbfde706cd13ee7fa,
    0x3fd3e8d535a3ff97, 0xbfe1e84eb0a38b3f,
    0x3fba2dba70139658, 0x3fd9aceba4853012,
    0x3fe46495550b3274, 0xbff3b1432e8a1d9e,
    0x0
    };

static const uint64_t ref_rfft_noisy_256[257] = {
    0xbfe927f57c820850, 0x3ff7df9746b25918,
    0x3fcb6f4e54f81200, 0x3fbe20f4129d80e0,
    0xbfa6979d8d8580f0, 0x3ff14d241b256560,
    0x3fd17ac2e231edb5, 0xbfa6843af1c1fd50,
    0xbfc35dd14a4cdc80, 0x3fd3996754c169d2,
    0x3fc88b431267d77a, 0xbfe5b31c1ef16cd5,
    0xbfe4d030cc0135fa, 0x3fce1e30f0251406,
    0x3fd43efa607b7b2c, 0x3fe4c2de61a4ab40,
    0xbfacafaf7fa93958, 0x3fe8560e08196b1b,
    0xbfc0c4044c41e16c, 0xbfdba7f939e1822a,
    0xbfed597ab9597911, 0xbfd1dd0b4c682b81,
    0x3fc36e4b40fddac9, 0x3fe91b2a14ffde9b,
    0xbfc1284d8f62a018, 0xbfd676a652698624,
    0x3fdd837e728f5633, 0x3fd90713a2abf06b,
    0xbfe5c9cf9c96fc05, 0xbfe41c7aa999e06c,
    0x3fe315bfdf396d60, 0xbfcd7b59af71bcfc,
    0xbfe50153c0cc0fac, 0xbfc0d4bb05015d70,
    0xbfd0ee2ee77444f1, 0x3fb26746ea95e220,
    0x3fbec24f1b234da2, 0xbfe257b511472f4e,
    0xbfe34c53fbfa8632, 0x3fc226a573f0d7f2,
    0xbfe3d45daf871436, 0xbfa104787204fac8,
    0xbfc2693af774af38, 0x3fd6e10a99299282,
    0xbfe463b2c34fb3e8, 0x3fbbea52fedbda58,
    0x3fe27ab9785b4ba6, 0x3fe402235a1cff4b,
    0x3fdd1a9f6f50aea3, 0x3fc0f6ae1cfb65a0,
    0xbfddac143ed3d1be, 0x3fc45b28adb18688,
    0xbfb7cc64d1d20162, 0xbfc7cc4062112514,
    0x3fe6b9ddbea342f3, 0x3fc3ce79029f3f5f,
    0x3fd9ed2560eaf6ee, 0xbfed4d6b8cc15a62,
    0xbff52a175c683427, 0xbfc619886ab09eb4,
    0x3fd41efaff950f64, 0x3ff52bae00cff300,
    0xbfe4e4a3b97346bf, 0x3fcf12ba0b47d5b8,
    0xbfb1d2d993340101, 0xc0564cbb42c99725,
    0x3f467765d4f93000, 0xbfe88538e32c581d,
    0xbfea471684cd3c26, 0x3fb672e010a4d070,
    0xbff0d9c6a896c096, 0x3fdf04ef765b7956,
    0xbfc2d56f120bf0ac, 0xbfe2a0f8cd4bccc8,
    0xbfd51c178e9bd000, 0x3ff2faa200e1fb0e,
    0x3fdff65c4ba7925f, 0x3fc2855ae2b882ac,
    0x3ff3fa2a98ea0dcc, 0xbff3bcdac84667fe,
    0xbfd2cd796c1f2818, 0xbfe8d81c411a8dee,
    0x3fc1c2e1d573eda0, 0x3fe8161d8e1e005a,
    0x3fe41eeb488a13bd, 0x3feac89cb1761c61,
    0x3f979c45debf8dc0, 0x3fed78dd6f27fce5,
    0xbfcbea2c659d77fc, 0xbfdb5ed19cee41fc,
    0x3fee55088883bb36, 0x3fb3c455b80b9266,
    0x3fda928f58fdbc86, 0xbfd30ac77d9fcab6,
    0x3fbdbffd0027e84c, 0xbfeb9d31bd6d5ab4,
    0x3ff6dca291b63284, 0x3fc10700595e256c,
    0x3f8beca26ff0bce8, 0x3fbf9181bff80e44,
    0xbfc8ae8f3e64c394, 0xbfe7c1a7093db36c,
    0xbfe3249069f90585, 0xbfd036be3ba6eced,
    0x3fb60578576a37be, 0xbfe07bbf32a26ef0,
    0x3fe6d5acb0bb52ff, 0x3fe7a61ae0f3e6b0,
    0xbfc0828a1d0cebb8, 0xbfe6e3f138f5ebc2,
    0xbfe110bd122d8972, 0x3fe75d3103a40c91,
    0xbfefad2936e5c103, 0xbfed59673cf0b4e4,
    0x3ff11bb2da5979f0, 0x3feb6678aaf553c0,
    0xbfdf6f4a3ce35b51, 0xbfd651b2c49f99ee,
    0xbfd6b2d650ff052e, 0x3fbe9defc862d7f4,
    0x3fb1f98fd18bee82, 0x3fe0bd9fc5289d6d,
    0x3fe48f965bd2af7a, 0xbfe244e63ee829fc,
    0x3fdf684d5a5904c0, 0xbfe3a3f893e845cc,
    0x3fc496ef1d5bae8a, 0xbfeea453db31eab5,
    0x3fd27c23911c3ce1, 0xbfc3c98bfa016e80,
    0xbfbcb63a28c869a8, 0xbfd0ecd1fb2c0a12,
    0x3fbc180127ce1828, 0xbfe3028065b9ab1e,
    0x3fdacb495f996d77, 0xbfb56fdbb430203a,
    0x3faeeb610c5daae5, 0x3fe6476cb2440fb5,
    0xbfc3f730bae7010f, 0xbfd9ed12106303df,
    0x3fea6b85da86e4ba, 0xbfe70bb68df8c197,
    0xbfb834bc22da0518, 0xbfde0a75335f8ce0,
    0x3f800a4d7e3f4840, 0x3fa8332e11bec528,
    0x3f9b668f6ba7c890, 0xbfa78349daa9a2d0,
    0xbfb4ef7f988bdac9, 0xbfc05a53b4ff3f22,
    0x3fe2657aef845b67, 0x3fd0009335a5fe54,
    0xbfd4765e1686f8f0, 0x3fe657b5267fb1d8,
    0xbfc020ec4adca538, 0x3fcaeac179acdaca,
    0xbfc5573745e46960, 0xbfe30025f056afcc,
    0x3f879a4e92be04c8, 0x3fdcc1eff06b0071,
    0x3fe2d022fc943ac9, 0xbfec795eee3604cd,
    0xbfe3317e20642726, 0xbfaf78cf89387b88,
    0x3fd21c7ce7cf11d6, 0x3fd5cfbf5ba91a50,
    0x3fd6ef9ca9d5e0e0, 0xbfafc15e4358267c,
    0xbfdab845930686e2, 0xbfea72a7ff1a13b8,
    0x3fe4b63291a1eb9a, 0xbfd3fbb6fc4890ce,
    0xbfe794538540e1d7, 0xbfd3a6aa3fb3f6ca,
    0x3fe745be2ad03e09, 0xbfe94e9210d31b80,
    0xbff5d9697d0b1aa8, 0x3feebaa0b6cd703a,
    0x3fbc8e23d7d5f848, 0xbfea346814cfbb7b,
    0xbfa9cf6474c05d98, 0x3fdd5b97266036fa,
    0x3fccdd9a8fb41090, 0xbfe01b2531da4ff9,
    0x3ff2a4a85b7a25d0, 0x3fe88f4f1c36e748,
    0x3fc88362a46431e6, 0x3fea585116b5a7ad,
    0xbfe9c74df5f20788, 0x3ff514be77b914bf,
    0x3fc9d52ca8f62f96, 0x3fcadda01389fdbc,
    0x3fb88e49b3450a29, 0x3fdf2d3e0623cc00,
    0x3fcc1693a35e6465, 0xbfed6a81e6f82152,
    0x3feba6f87e90e2b4, 0xbf9e9118fd0fae80,
    0x3fec7c77a281d11e, 0xbfe8cc0c6d325a21,
    0xbfc3a0e88b801531, 0x3fe3d633f6d7ab9a,
    0x3fbc5de6efc63bd8, 0xbfd2677d3ad7095c,
    0x3fc08b93d3415db9, 0x3fc863a2a1a31c38,
    0xbfef1dbc8fa4c66d, 0xbfde413cdb57c978,
    0xbfe130527c4c38c8, 0xbfc978c1cac10c34,
    0xbfe0dc682225ca0e, 0x3fe4d8dcb6ed14c5,
    0x3fca47c7c5c6eca2, 0xbfd7ac861d0f1342,
    0xbfb55f52a8daa9fc, 0xbfde04b0afe0ccb0,
    0x3fd1ede788107380, 0xbfd3f382ed780f13,
    0xbf6f42a58bbb3b80, 0xbfc08156c872c180,
    0x3fc0695a89c4f315, 0x3fd37fe68b65f56a,
    0x3fe08f507c46724a, 0x3fab9abcc87b4a48,
    0x3fb110814ae271b4, 0x3fec67cae617a58c,
    0xbfd62b3b743b5e95, 0xbfcbe54c32679b66,
    0x3fde161aefa5169e, 0xbfdf451526d338e9,
    0xbfb3cf4d4cb99314, 0x3f919e26d641f4f0,
    0x3ff1763d9c450533, 0xbfab08ff5c617408,
    0xbfc348ed32713841, 0x3fe028c16020a25f,
    0xbfe3fc6afa6cf41f, 0x3fe7a99205053628,
    0xbfc614b721bb174e, 0x3fe8fcf365d55145,
    0xbfe1e5b07911282e, 0xbfdc2d49029954d6,
    0xbfb152024c29a5d2, 0x3fcb68638266977a,
    0x3fe0f60dab2c7064, 0xbfac68e9734b1e38,
    0x3fe2166585ef006e, 0x3ff00a2bb4d91def,
    0x3fe92711813ea3ea, 0xbfde706cd13ee7fa,
    0x3fd3e8d535a3ff97, 0xbfe1e84eb0a38b3f,
    0x3fba2dba70139658, 0x3fd9aceba4853012,
    0x3fe46495550b3274, 0xbff3b1432e8a1d9e,
    0x0
    };

static const uint64_t in_rfft_noisy_512[512] = {
    0xbfa60f365b2d2f9e, 0x3fdf13586d181fb3,
    0x3fe6f66f898770b4, 0x3fddec8adbb0daac,
    0xbfa2c86a88fa8a2e, 0xbfe32db977e72205,
    0xbfe6e5dfadb09146, 0xbfe0c6d55b85b8df,
    0x3f878ec449f1f4f7, 0x3fdf3601653a1e8f,
    0x3fe67140cf066f1d, 0x3fe0441f9c86f5bd,
    0x3f747a4973f28fc0, 0xbfde2a4116c5a0fa,
    0xbfe4033f66785321, 0xbfe2c2ae21660484,
    0x3fb30044db682deb, 0x3fda4b762c6378e9,
    0x3fe723adef15e077, 0x3fe23b7ab4f35fa9,
    0xbf9c33926e4b1448, 0xbfda7544b5b69a32,
    0xbfe458f02c60d306, 0xbfe282610eab9f00,
    0xbf846359545b72d7, 0x3fe0d1099738b6e1,
    0x3fe4f5eb1aaf201a, 0x3fe2e4684d4ffd53,
    0x3fa20a5d44387869, 0xbfdee716d0fe743e,
    0xbfe651b20041944c, 0xbfe0ebefa171a6b9,
    0x3f79d15528836c50, 0x3fdb5d439ce672d4,
    0x3fe4e615fbe096a9, 0x3fe21a17ec76a81f,
    0xbfa581c9d818ffc4, 0xbfdf564c35378e25,
    0xbfe3040ff1f03979, 0xbfe2c2fb5b008b38,
    0xbfa8d87001453a7c, 0x3fdee3ee327a3a5b,
    0x3fe463e0c499a228, 0x3fe25003f1d46bad,
    0x3fade90042df4ea8, 0xbfe06df9cc67eaf9,
    0xbfe9c423c8a40d0a, 0xbfde497f4f9f3acb,
    0x3fa83e23d257f715, 0x3fe1e5aaa417e897,
    0x3fe737acbaf73889, 0x3fd884dc8115801a,
    0x3f7248ff30e11555, 0xbfe0dc5559cdd596,
    0xbfe41707d62b5636, 0xbfdc77f297b640e0,
    0xbfa7cf4b7f4786b6, 0x3fe150e06fd15077,
    0x3fe53a00ad452276, 0x3fdbed3f67b66b27,
    0x3fb22b95da7aeba1, 0xbfde15a896f68d35,
    0xbfe72ef6f4a8625b, 0xbfde27c052ed6745,
    0xbf9b079c89d7ba90, 0x3fe0e142d47d21c5,
    0x3fe58cd44621aa6c, 0x3fd83e904a954df6,
    0xbfaf51b7b0bded8c, 0xbfe1300b86130a5d,
    0xbfe8147b702974c1, 0xbfdcd261c4da1340,
    0x3f92a7f3f6783e2c, 0x3fe11dd588bb7cc2,
    0x3fe61dd07e1473b0, 0x3fdeec3f0b9c114a,
    0x3fab56f8c1c3a360, 0xbfdb83ac2450bc95,
    0xbfe4c151fc75d348, 0xbfe0969f042bb450,
    0xbf8f80a748a06b94, 0x3fe0bd425da22253,
    0x3fe685e5e4c5152f, 0x3fe44eb3da5387ac,
    0x3fbb1817011666a9, 0xbfdd7e886d24c06d,
    0xbfe5a90d089d8516, 0xbfe2e3831f97cfbc,
    0xbf931d4d90d3901c, 0x3fe136af468ee0b7,
    0x3fe5a76d71fa9af4, 0x3fe0b96c9d0878df,
    0xbfac6d73c0b6caa9, 0xbfdc72e6238f997f,
    0xbfe61dc28e55624f, 0xbfe2f1812f099f91,
    0x3fb9b8bc34d89edc, 0x3fdddcaf47af3632,
    0x3fe635e737ccf4da, 0x3fdd85f666689110,
    0x3f95625f1419fef6, 0xbfd7b4860ec74495,
    0xbfe7e8fd7d442070, 0xbfe0087e0a6bb419,
    0xbf9dab6cb43027e6, 0x3fe016e4c10ea576,
    0x3fe708403fbedb06, 0x3fdba420b76cbed2,
    0xbf6e78504f5224f9, 0xbfdfbdc780ef708b,
    0xbfe4e0684ad7ffa3, 0xbfe08f717c71b0b1,
    0x3f85b7e5cf2a911b, 0x3fe07a3d7a0697c1,
    0x3fe6a148e7e67c41, 0x3fdaea4c971b1cb2,
    0xbfa477f86c11980c, 0xbfe05b84b4f340eb,
    0xbfe3b4479cdf894c, 0xbfde487e4dd96a18,
    0x3fa8976acf807dde, 0x3fdf9628cc210cba,
    0x3fe70e681b4e100e, 0x3fdbbd17d44a437d,
    0x3fa553a74c7b0144, 0xbfde6b76bacdc811,
    0xbfe6a42a44c34b43, 0xbfe425f3bcc697ff,
    0xbfa76cdcfd8ed63c, 0x3fde8ad8fe77c4cf,
    0x3fe58914075eedfe, 0x3fdfb4fea6940b0c,
    0x3fa8f4a29a32ac71, 0xbfdd9400add51c8a,
    0xbfe4bf78c3df3cb1, 0xbfe1b8768d5603b6,
    0x3f9bce49d96c97e1, 0x3fe105090ffa5a8c,
    0x3fe67a3b57a053f5, 0x3fde0c86ea6ace30,
    0x3fa032e09b7dbc50, 0xbfe063333243f6ff,
    0xbfe4692846cc4d84, 0xbfddf00bd0063fea,
    0xbfc191b9ccb91725, 0x3fdf31b13a689ea4,
    0x3fe42baa8061e219, 0x3fe1d25608bc01b1,
    0x3f9644525c97355b, 0xbfda63e22b598354,
    0xbfe6838a3dcc7527, 0xbfdbd55fb72bc345,
    0xbf9471b1858070da, 0x3fdc2f21afbc8948,
    0x3fe6fd77713ed9d6, 0x3fdfb53d63778bb8,
    0xbfa415781aa23883, 0xbfe07be7729c1598,
    0xbfe443c43c531301, 0xbfe10a34c3e81745,
    0xbfaba942f44d69eb, 0x3fe0e18389e392e6,
    0x3fe615466c5e707e, 0x3fd90a15020a5a39,
    0x3fbc21ee977d23bf, 0xbfe04d46b450f948,
    0xbfe2bd971e4ed77f, 0xbfdcfde62ba7bb68,
    0x3fa68cef0dcf3453, 0x3fe05366ad8f7be4,
    0x3fe86c3ae7b50723, 0x3fdf0472d81dc42a,
    0xbfa0dd780d95566b, 0xbfe0b1ed95402607,
    0xbfe6996410c0a79e, 0xbfe106a3d0ab09bc,
    0xbfb90a57998589c9, 0x3fdc1df4460dccd3,
    0x3fe5340cbcf74c7d, 0x3fe2e50cf8d5c606,
    0x3fbd24d035c348af, 0xbfdb7fa14dcacac0,
    0xbfe88c054f1605b2, 0xbfdce0a95d96877b,
    0xbf903b2d0a32baaa, 0x3fe0bff7e3acf735,
    0x3fe6b98cfb5f7cba, 0x3fddf96588a9e469,
    0xbf9f48d1362eb924, 0xbfdd43d11a86faa4,
    0xbfe636cf258501d5, 0xbfe153b7607bf32c,
    0x3fa118601ae3b9ee, 0x3fdf37701f938e7c,
    0x3fe634a7c3c1c76a, 0x3fe17eba7604840d,
    0x3fbf81fe3f231cff, 0xbfe085c9d4eef0bc,
    0xbfe67ef8cea3a3d6, 0xbfdce2d0e6a2f704,
    0xbf7315a95898d03e, 0x3fe280f8cceaf05e,
    0x3fe8dbaca85d84ee, 0x3fe22241f48c7f83,
    0xbf916088d2d5d96f, 0xbfdb79d1f7c783f4,
    0xbfe5d7851288fba8, 0xbfe0efba81928350,
    0x3fa7bdad6d9a1d3f, 0x3fdd5778c8e9715a,
    0x3fe56b3d0ad57331, 0x3fdbf5544f2573b1,
    0xbf77885ce287b70c, 0xbfdd510d06c5e523,
    0xbfe6534ff2a34112, 0xbfe1911c64d8ceef,
    0xbfa54180fa03e01d, 0x3fdf0ac045c4d001,
    0x3fe5a2a0166a2542, 0x3fe3929176cbe590,
    0xbfb99aa914f7799b, 0xbfe0319cc565cba0,
    0xbfe49915fcbf6c2c, 0xbfd6d18d785d83ac,
    0xbf852ea6ba1e0654, 0x3fdddb7a10964ae9,
    0x3fe4117ca4366b50, 0x3fe043647ed6082f,
    0x3faa90869cdb7105, 0xbfdd5baea456495a,
    0xbfe4f8e240dfdc02, 0xbfe070de51d1ba5c,
    0x3fa7851bbe84659f, 0x3fdc6a2f7a3d3394,
    0x3fe70835f7a73fb1, 0x3fe2b00023ca7694,
    0x3f9c57c656b7388e, 0xbfe2c3ac4192a26d,
    0xbfe6ad084c93cfe1, 0xbfdc2bf64ebec326,
    0x3f94965906188f25, 0x3fe005c7726a0f9d,
    0x3fe65b5970084ca4, 0x3fe13b3b38e7dddb,
    0xbf9a593b59d369c7, 0xbfe2e5956b68d7fd,
    0xbfe80395b4b692a3, 0xbfe1a0f2bdd111e2,
    0x3f974f03fa950ae8, 0x3fe00bc9f1ca87f6,
    0x3fe43bc846b46566, 0x3fe15fc2bc9f3edf,
    0x3fa3e6d8e99d59cb, 0xbfe1da0d065ec632,
    0xbfe7c6f753fbd041, 0xbfe2be92a0cf5194,
    0x3f8bdcc4ca60f729, 0x3fe1aca545cfd974,
    0x3fe5a60b5cbeeabf, 0x3fdfbbf7abc49ce0,
    0x3f94740b6bd535e1, 0xbfdf01415576505d,
    0xbfe99a8ef10ec3c8, 0xbfe126757ab73a4b,
    0xbf94498d604d4c22, 0x3fe038aff1aa0641,
    0x3fe724aeb1c35872, 0x3fdf682054886d18,
    0xbfab0a5450322a18, 0xbfe18e0e9edb48d1,
    0xbfe7086a9480fdbd, 0xbfdabf3dd2d106a6,
    0x3f948ca51284bff1, 0x3fe0502b4f714162,
    0x3fe524b1917da43b, 0x3fda7e69e3f54367,
    0x3fafb4da4d366bfa, 0xbfe1b39983f59d6e,
    0xbfe5ee8ad7af1882, 0xbfe263be18b76912,
    0x3f86164f4fab6fb8, 0x3fdcfe2ac425f5e9,
    0x3fe73ff9d9c95cf6, 0x3fe059d4b91b0155,
    0x3f87042004b71f5c, 0xbfdee63be8e66e7d,
    0xbfe71f165e8ba837, 0xbfe05a14f41e3236,
    0x3f9499c6e066e5f9, 0x3fe023666bfb4e7c,
    0x3fe2ef31b8f00e50, 0x3fdda51cb3c7f152,
    0x3f4ed41662153fae, 0xbfe1b3a4d0bfe9c0,
    0xbfe5adb70994a265, 0xbfdc43e70a4a9534,
    0x3fb1a79c6d803289, 0x3fde2b607e7b5a17,
    0x3fe914e6ce8d4d86, 0x3fde591d56995a12,
    0x3f8ab443efbedac3, 0xbfe004a260f3c9f8,
    0xbfe89d8d2467ad3f, 0xbfe0549f9cb2989c,
    0x3faaa11b5fc13385, 0x3fde74dcef4d9041,
    0x3fe7e6ce5dac7269, 0x3fe042722bc122e3,
    0x3fb1de38c510e288, 0xbfdf367823a7162e,
    0xbfea56967adfc56b, 0xbfe1faeb23250806,
    0x3fb1997c026e8fc5, 0x3fe0bb4154bfdfa2,
    0x3fe6c67e4ab10ea1, 0x3fdc32b342657474,
    0x3f8f15658715ef23, 0xbfddcf0a8b533862,
    0xbfe7266152d11507, 0xbfdd2886d7aecfbe,
    0x3f9f4434e637acb7, 0x3fe00d98044db389,
    0x3fe42859dd50034f, 0x3fdd41245f9e07a2,
    0xbf8a74f777c57c24, 0xbfe1ad54f850b5cd,
    0xbfe93a4f023bc2c4, 0xbfe095d78ad2d0b3,
    0x3f8c3ce5d89cb1d4, 0x3fe179861de71a53,
    0x3fe4df106e4bd712, 0x3fe099e72ce604c0,
    0xbfa581f7ccf278d4, 0xbfdfa20524009287,
    0xbfe6d7f0cd10be0b, 0xbfe095810fd528eb,
    0xbfa1d1a2437a5a6d, 0x3fe1fcbeaa38d404,
    0x3fe4f44a569c99f4, 0x3fdb40761b0ebb8b,
    0xbfa3a0b0da10a920, 0xbfe1091b35061569,
    0xbfe668829830ac0d, 0xbfdbb44ac8202fb8,
    0xbf61b1d70cc34448, 0x3fe0fc2325431970,
    0x3fe54197fdd16cb4, 0x3fe387de2920750e,
    0xbfba745f761d595e, 0xbfd8ea41aa2be6d0,
    0xbfe5465aecddcd4c, 0xbfddbc957681bf52,
    0x3fc19b04b9038d5c, 0x3fdecdbd3ebee13b,
    0x3fe4e19afb98a5bb, 0x3fdd7d0866ec5ff3,
    0x3f8a88a014f4d36e, 0xbfe09a42bd0e30a8,
    0xbfe7a1fa4b324a8f, 0xbfdd94603a7c10b6,
    0xbf8b83b22544722e, 0x3fdfff1fb4390f24,
    0x3fe5d4577f8e4707, 0x3fdda827c4eda068,
    0x3f71cffd999d1dc3, 0xbfdda75a6ee2bf44,
    0xbfe44e5932edd5ec, 0xbfde60ece0f0e6ed,
    0xbfc16d2a58929234, 0x3fe092f4c397424e,
    0x3fe7ca99e55df217, 0x3fdbbab1d36f3ef8,
    0x3fbb8a4102792cb4, 0xbfdbde01b86fac53,
    0xbfe8fea6fb802dc0, 0xbfdf3341d3cec423,
    0x3fc49cc9062c985c, 0x3fdf44e2183d9b7a,
    0x3fe6cebd1fa62cad, 0x3fdc089b3cd15876,
    0x3f899977e3df72c2, 0xbfe0869395f1aaac,
    0xbfe52b7262fa54fe, 0xbfdb890166b25c70,
    0x3fbf220ea170caa7, 0x3fe0922700622042,
    0x3fe5f2ddcc521bc4, 0x3fe21c2a70d80993,
    0xbf9901831458703c, 0xbfdfb1dfa88abc8c,
    0xbfe605e143a99ec4, 0xbfe00df697cfe963,
    0xbf5cd5e0f92e56a9, 0x3fdfaa496523f9e9,
    0x3fe36ce207583266, 0x3fe10d20a78def31,
    0xbfc18ba9d9da91f0, 0xbfe0a18bd013c527,
    0xbfe93842c8c27871, 0xbfdddec7ca471eab,
    0xbfa175a8198c3b0b, 0x3fdbc16cd49dc15d,
    0x3fe3c309e423115a, 0x3fded65d4f4276eb,
    0x3fa53692bb7baa8b, 0xbfe141748371df63,
    0xbfe57c54015fff06, 0xbfdf606b1636a2b7,
    0xbfb2190f25664180, 0x3fded6d053d788ef,
    0x3fe80169bf375c29, 0x3fdd35d1ff8f7812,
    0xbfb8303019aaaf2d, 0xbfde4637b36fdb9f,
    0xbfe654a821a828ea, 0xbfdc6ed847aeed9a,
    0xbf95e18e83d0aa37, 0x3fe12ab5d15db98c,
    0x3fe8ce9d7aee46ba, 0x3fdf31ffc4361f4c,
    0xbfa5a4f9c412813c, 0xbfe265ac62c28692,
    0xbfe5c8f61619c906, 0xbfe0fe7a1ef1c56b,
    0xbfb3a309921742e5, 0x3fe0b43815701b68,
    0x3fe75b31eda3a239, 0x3fdf346710b46425,
    0x3fa30412e79cb9eb, 0xbfdab56a35a1ff46,
    0xbfe608eb55ac5eb9, 0xbfe05bcb8c959462,
    0x3f8cb414181ec000, 0x3fdb6f4690141ade,
    0x3fe5204250842325, 0x3fdc801ba2a2e290,
    0x3fb6786f1b8097a1, 0xbfe1533e0cdb527e,
    0xbfe4b0f87b8d0c92, 0xbfdd4faba643e7d5,
    0x3f7094652c281c1c, 0x3fdec0d5624284a3,
    0x3fe79787d14a9a2e, 0x3fdb908ddb293646,
    0x3faabcbecc3ebea7, 0xbfde374e07bb260e,
    0xbfe657b6a260af27, 0xbfe01ffb5ff7ac10,
    0xbf9b08e9f72dde06, 0x3fdf2d203949707e,
    0x3fe685f7f99eeff6, 0x3fdf4d01e5e74b07,
    0x3fbbeff37ab3adf3, 0xbfe1cac1267f2f70,
    0xbfe867828a5917fd, 0xbfda9145480f9a33,
    0x3f904a9a792a75cc, 0x3fda32a77ec0a366,
    0x3fe8b33ed399a154, 0x3fdf80858482590c,
    0xbf87107ddc173ff2, 0xbfdfbd00ccaaf15a,
    0xbfe7262967bc4aac, 0xbfe12d9b8b1df3df,
    0xbfa5469a577d4f7c, 0x3fe2190aa16a3ae3,
    0x3fe98f8251799328, 0x3fe00057fcf2c4b2,
    0xbfb1caa2a43eb784, 0xbfe06651866a95a6,
    0xbfe648fdb02b1c0c, 0xbfdfc31fc1afbf91,
    0xbfb9a733a6d46a13, 0x3fe0e5002473b7a6,
    0x3fe3f264f9510c96, 0x3fdd1abecddb8e10,
    0x3f9df83d9913a8fb, 0xbfdeb10996f82e19,
    0xbfe3683c859e813c, 0xbfe13c78232b3cad,
    0xbfa67f87f89b9e57, 0x3fdb614eece03cf8,
    0x3fe7f6081435cfd2, 0x3fe0be82fa828ec1,
    0xbfb5a8df01f7d09f, 0xbfe22d3351539026,
    0xbfe4ff88541055a4, 0xbfdcc12c4e541b73,
    0x3fa9b0ed670976ef, 0x3fe321da9bebd12c,
    0x3fe77862054597e7, 0x3fdd9fe4ac2385cb,
    0xbfaf7344e9ce27c1, 0xbfdf021ea2a78dc5,
    0xbfe5fdf8299b0fe3, 0xbfdea816a0467f2d,
    0xbfa2914f604548b1, 0x3fdf1deec03f77c1,
    0x3fe7ccc679b123ab, 0x3fe1cbb4b6413310,
    0x3f87b7a152811257, 0xbfe005c53b146076,
    0xbfe87e5c364d2009, 0xbfe02c41848f084d,
    0xbf8f3b41fb411741, 0x3fdde2b57f25fb7e,
    0x3fe731446046eb90, 0x3fdd702bd892291a,
    0xbfa9f6cd9a7de05e, 0xbfe1ed5e0fd8ab63,
    0xbfe6edba886d2955, 0xbfdc47d8134272ed
    };

static const uint64_t in_rifft_noisy_512[513] = {
    0xbfb8e29ab4bc2fa4, 0x3fe0cd4b8476c7cc,
    0xbfc199602539f3b8, 0xbfed0f7370e4a318,
    0xbfe75925b7449500, 0x3fd961ca943ef88e,
    0x3fe030f26390b3c8, 0xbfea179f712598e4,
    0xbfeddc2b4a40932a, 0x3fe919c475784086,
    0xbfaa42e84179d806, 0x3fd5b89c458ae4c1,
    0xbfdbd015c77a3f49, 0xbff0d6788f088b58,
    0x3ff39c753ec521f6, 0xbfe2e4010ff81afa,
    0xbfe1561f88dafa7d, 0x3fe3f869ae791f21,
    0xbff447b0fbbb8302, 0xbfaf546edcbe215e,
    0xbfec3a1529f14598, 0x3fdd0ddf1d59c2bb,
    0xbfd47491f5117132, 0xbfd2cfb8244de869,
    0xbfb7cd244d00051c, 0x3fc2123919f18891,
    0xbfb83f3c5711095a, 0x3fea5d1d9d6e2560,
    0xc0015d20162817e6, 0xbff68dd41116009c,
    0xbfc45053709c6406, 0xbfdc0542cae05420,
    0xbfcbaaf2b1623f6b, 0xbfc04b5c5a9fe49b,
    0xbff733a1d52016bb, 0x3ffb12d2ed0bf304,
    0x3fd5a9301acf13c3, 0xbfa3af4c5e27bed8,
    0x3fe03d6fe0daa822, 0xbfe5888405a43562,
    0x3fe458af435e5b4a, 0x3fb0a7095893a110,
    0x3fc19ffec8b3494c, 0xbfdf139dc2644128,
    0xbfb9c42925823710, 0x3fcafd0a49e1a3c6,
    0xbfe363fb5aeaf0e8, 0xbfc94d33257f7c9e,
    0xbfd56a49d448467b, 0x3fd206c7fc34a854,
    0x3fef31f3901d963a, 0x3fed039e4e5f4be5,
    0x3fdd95b30d9a81e4, 0xbf96ebee138e5e20,
    0xbfe8c9c9ce1713d7, 0x3f6bbd395fd379c0,
    0x3fe3d55155486b3d, 0xbff4b24c22aff828,
    0xbfed9a0c5242f962, 0x3fd85b2b6175afe9,
    0xbfd0a110f60b1e40, 0x3ff590fb8c8388bb,
    0x3feeab5cc2559886, 0xbff41dd3b9235c6c,
    0xbfe2ed8d20f72be0, 0x3fdc0540a88f716b,
    0xbfd7ac2047dcf95e, 0x3fec5d6ff557173a,
    0x3ff7b33c65841854, 0x3fc88c5cb07c1890,
    0xbfe6b3bef1dca817, 0xbfe707441e462408,
    0xbfcc82b50d3e9550, 0x3fb0aa8ac72de558,
    0x3ff1af5911da8144, 0xbfc0188fc6d7ff69,
    0x3fcc27570b095c06, 0x3fc8afa99fbff854,
    0xbff385982e87f7b2, 0x3fdcdd16ff0efa51,
    0x3fcabd8bf756a15a, 0xbfe68c7fb1e25b38,
    0xbfb374d66b90e3bc, 0x3fb6311c76755270,
    0x3ffd19b6bcdbdaf4, 0xbfe1cf53f73654ba,
    0x3ffef19eb0b8a926, 0xbfdaf23d231a068a,
    0xbfc97de42e17c34d, 0xbfdfc9999416cc66,
    0x3ff215fa9dc0cbf0, 0x3ff74d1250d9bd6e,
    0xbff0d3e2dd289048, 0x3fe0c68fd1a2c768,
    0x3fd78a47a44f6ecf, 0xbfe220fdb85c6c2a,
    0x3ff30557d129c58f, 0x3ff5336b64aaa52c,
    0x3fdd1bc2797198ec, 0x3fe3c9865d5f2c6c,
    0xbfe142a64381bcb2, 0x3ff62cce8adb5aa5,
    0xbfb687ecbddd6ba0, 0x3f53a7c08893b680,
    0xbfecd18205210480, 0xbff24c2ef909d3d0,
    0xbff004c9c0fc6af2, 0x3fe0ff7ad9c831d4,
    0xbfc2fbe64cfe3462, 0x3fa38ff82d765060,
    0x400006869fb6a966, 0x3fdcee65076f9bac,
    0x3fdcd9b0de2fc75e, 0xbff7bae905df4c12,
    0x3fc6b9729f39f081, 0x3fb7989e6defdcea,
    0xbfc34d9e868bde54, 0xbff7a8492474859c,
    0xbfc8b6bdc6b94738, 0xbfef918be518846c,
    0x3fd2f9f8aa50f03d, 0xbfe3ec5f14a7309a,
    0xbfd5340c7e04badd, 0x3fc5caabbb9dabd8,
    0x3fca166b07e118c2, 0xbfe1532ac7f7dc40,
    0xbfe902635185b920, 0xbff4479fff4ac05b,
    0xbfcd2150937de31e, 0xc066647a10be550a,
    0x3f9a68d5465f8590, 0x3ffd445c4ff69e17,
    0x3f9dd04c605d6160, 0xc00185f0706bc100,
    0x3fdce9375692f4d4, 0x3fda00c7edc128f6,
    0x3fdb9e2cc79a4414, 0x3fe68af6c229c0ae,
    0x3fe0136521a64dc7, 0x3fc1079128bd9a10,
    0x3fb1d864b52bfe04, 0x3fdbc0f47a4e7dd1,
    0xbfe1de24e8ed9f56, 0x3ffb513a2f8d5698,
    0x3fe2f51e06480ba7, 0xbfe4ae75cb172735,
    0x3fefcb57daf73e60, 0x3ff31541a5bd67cf,
    0x3ff1ffb848ec9bf7, 0xbff7edcc62819ed9,
    0xbfc0b0e4e8ec23a9, 0xbff8df32b671ad20,
    0x3fe70d3f4b771362, 0xbfe2cdac8fe9044a,
    0x3fc9f565812c15a2, 0x3fe3e43880bf759a,
    0xbfe9ca7c2085c91d, 0x3fe038a397183b0c,
    0x3fa12ae79ddd4870, 0xbfe12c70d3af6256,
    0x3fd8ace33fc428c1, 0xbfbc89e2b728a940,
    0xbfc90d7b7234e3d7, 0xbfad8dea8d03203a,
    0xbfd72be59cc45f46, 0xbfd7eacb13179f75,
    0x3fef77d9b51a91ed, 0xbfe28a63ebd68d0d,
    0xbfe612e7cad26e3c, 0xbfe191f664eb3dc5,
    0x3ff8cbf43793d08a, 0x3fe032987fadd269,
    0x3fee53223169d2c6, 0xbfe8829d7033ae08,
    0x40020ad06679614a, 0xc000187f26917a4c,
    0xbff81ea0a30f0188, 0x3fd1ed869e49ca1a,
    0xbfebc7ec603720e6, 0x3fd4e22d6ff4cd50,
    0xbfe0a72e424135d4, 0x3fe9e4529022d470,
    0x3fe45828db0438f2, 0x4002b518e46153a8,
    0x3fc8597f12bc5b6c, 0x3ff44b75c81dc76e,
    0xbff58dc5dde8f75c, 0x3ffab564c39042d8,
    0x3ff41d953f8eacdc, 0x3fd08ee55f669e86,
    0xbfed3471618e6343, 0xbfe9c02a5661a5ca,
    0xbfd61094011465aa, 0x3ff659e37e2c2a8b,
    0xbff0e392a89565f0, 0xbffd8a4d08037dd0,
    0xbfc2d0cb72b120d2, 0xbfec3d998b0495b7,
    0xbfe20ccaa926992a, 0xbfe2a6afa6d2886b,
    0xbfa7d3fa2966df90, 0xbfd0d9a9ce70e4ce,
    0xbfe2633ed2f4d3c7, 0x3fdc64409ee3b31e,
    0xbfd4cab04ecb19ef, 0x3fd9eb7ba3800e94,
    0x3fd25407d8329b9c, 0x3fecdec4372100ba,
    0xbfeca0e866316170, 0xbfde2cb9c3390c6a,
    0x3fe3b356945e03d5, 0x3fd6bfd1503b2519,
    0x3fd961362cf9ab8f, 0xbfc56e84c2ac2128,
    0xbff67e7f18beea16, 0x3fddd3a08e30e8b6,
    0x3ff8b44af475802b, 0xbff6e4d1869a505e,
    0xbfbd1e6e36ce6718, 0xbf9313a878e7c760,
    0xbfe200ea5f733a5a, 0x3fe4a008983ac138,
    0xbfb58fdc14d8a9f0, 0x3ff06ab4f8b9b7d4,
    0xbf9c3e81281b1550, 0xbfd019ba8bd9e40e,
    0xbfead803c61ac83e, 0x3fb1a503371dd5ee,
    0xbfe157d34b966666, 0x3fb75be3562c078c,
    0x3fe41080ecc82270, 0x3feac0c43791dada,
    0xbfc0a0ceabd7a4cf, 0x3fc6d0857bf3f0e6,
    0x3fd13f89dfc92e78, 0x3f879e4c7fa370b0,
    0x3fecf35f27fa19e0, 0xbff478d87e1b838b,
    0xbfdcc936e7b1b20c, 0x3fe2d46b53f6f7ed,
    0x3ffa636695699954, 0xbfee3ed18f79c25a,
    0xbfdfd5d0691eddc4, 0x3ff4756e760e9520,
    0x3fe1de57b53197dc, 0x3fe0d08105339c42,
    0xbfd6e9cc3d1b1662, 0xbfcd3c75aa99fdbc,
    0xbfe7ead5ed7d723a, 0x3fe524761b8818a7,
    0xbff470c2c81d1efe, 0x3fe1fbba3906d046,
    0x3ff496787be022c8, 0x400563aeebce2ddd,
    0xbfe793590556a5b4, 0xbfe747a0d4fba490,
    0x3fdda0fb7e245fd7, 0xbfdef4fe5e5f49c0,
    0xc002da8a3f632ade, 0xbf69e180a667fb80,
    0xbfee550e32cacddb, 0xbfd3bdefb6eecb18,
    0x3fd3bf4fb70ddf4a, 0xbfc76d79d7a70397,
    0xbfcac5b88fe1cdaa, 0x3fd4f2d7dfec6b3e,
    0x3fb38cde770db3ba, 0xbfaeb6fdd59b6fe0,
    0xbfea31cf9fd4e7ce, 0xbfe3a3e1de23e552,
    0x3fe81d826b984514, 0xbfe080e4ca4fc523,
    0x3ffa544bce815cc4, 0x3fcf7502baccdb1a,
    0xbfc640b864b108b9, 0x3ff65f4353619582,
    0xbff7843aaeda50aa, 0x3fe3f78f713f755e,
    0xbfd461372209693a, 0x3fbd7966b879766e,
    0xbfb983d387dc1e46, 0xbfe88fd92bd10c1e,
    0xbfd6c878e2073936, 0x3fdd13ec9d8e938b,
    0x3fc1009e4fb83086, 0x3fe68b993f7c60f0,
    0x3fe319b17b9d51a4, 0xbfc3bd91260634de,
    0x3fec9e2ec46ad5f4, 0x3fb0ac9be34b94ea,
    0xbff11955096a4ad7, 0x3fe379cf726ce0db,
    0x3fc83ff89546eb10, 0xbfb4ecdb3babab44,
    0x3fe64ceebec11ce5, 0x3ff148dbfd188d5c,
    0xbfdca66dba3702e8, 0x3feb032611c67ecc,
    0xbfef2f70d47ccaf5, 0x3fe4bf489db1b70d,
    0xbfe03b1d306dafa2, 0xbffdbedbdc0c5795,
    0xbfce77da4472e9ec, 0xbfd5bc0202be57df,
    0x3fd113f3643b601f, 0xbfc7eebe982e3a04,
    0xbfe001fa224a554f, 0xbffb5f8ba848895f,
    0x3ff18eb244fc0ee3, 0xbfdaad2c71460750,
    0x3fddb1bba31a156e, 0x3fa470524037a678,
    0xbff5a2cfddafd5ba, 0x3ff6e70a9d724552,
    0xbff1511745685e07, 0xbfe3e3095ddf0ec7,
    0xbfebf2c7296ca754, 0x3fea6f9075313deb,
    0x3fdfc1c93d7bb587, 0x3ff33d22e7850ef0,
    0x3fdb270b7ad6b27c, 0xbff630f2786eb327,
    0x3ff1feff646e75dc, 0x3ff8a85e1c15ed33,
    0x3fe67e26a5c09435, 0x3ff42db91c671c4e,
    0x3fc80bbdc129c610, 0xbfb799454e7e3060,
    0xbfe8eda21f59209f, 0xbfb11331cfb732c0,
    0x3ff9e24f6e053307, 0x3fce1de6eaf08080,
    0xbfe56f03d5f11146, 0xbff76a6d2928f314,
    0xbfe280b52ba67852, 0x3fb0efafec94c192,
    0xbfe3e845412c61c9, 0xbfd168cbfaaa413a,
    0xbf78c7b592de9400, 0xbff98222afe6b93c,
    0x3fb20c620db4c854, 0x3fc10d09ba033f8e,
    0xbfe2ae038a49ad19, 0xbfbb3fae02dd2298,
    0x3fe9be0768219902, 0xbfb4fc0420af8ed0,
    0x3fe4a97d9c8a68bf, 0xbfc92cd7c3e8bb09,
    0xbff750182d545cee, 0x3fd4d4a021b59b89,
    0xbfd2b8ad8e03edd0, 0x3fcb59898983fc66,
    0x3fdfd118d3bdbea7, 0xbfe48719ab180a2a,
    0xbfe0cb92b266552f, 0x3ff50aa60b228a73,
    0xbff37d2cbefe735e, 0xbfea218c34a05218,
    0x3fed1df1dedee9bc, 0xbff25996cf069ccf,
    0x3fe589a8e1093dbe, 0xbfcdfd73e59b360a,
    0xbfd7363244f60e78, 0x3fcea365df4ba750,
    0xbff43a719819a1a7, 0x3fdaf2ec1b1a3ec0,
    0xbfe3e621fb28bcaa, 0x3fe154c7009f4f3a,
    0xbfb6aa23788e6368, 0x3ffc14ec991e4232,
    0xbfe2515a817e28be, 0x3ffccec251125a80,
    0xbfe479198cbd2c8a, 0x3fe4ac4c8934b2ba,
    0x4000bab9f6611179, 0x3ff05a1a11a9ec7d,
    0x3fec2b346bbbab74, 0xbff3edc6c9e4e44b,
    0x3ff2114287dece61, 0x3fe48d4b5c509d57,
    0x3fe782ba0a5d171e, 0x3fc5cb0a96713ef8,
    0x3fe7e80364052cfc, 0x3fb64ffd0ddb0850,
    0xbfd7989e6d37948f, 0xbfe861ca44519e80,
    0xbff063d592874418, 0xbfc121ae72229198,
    0x3fc427338bce2922, 0xbff2cc35108290be,
    0xbfd2232534f5957b, 0xbfe9379e6aa990a2,
    0x3feaa7784101ed94, 0xbfc5eaaf5c9f560a,
    0x3fe3a857e44957ca, 0xbfc3fb53eb87aff8,
    0x3fad9c1ca37bcc52, 0xbfebc878ae7e9edc,
    0xbfe51b9cb0a24da4, 0xbfc97553764de921,
    0xc0010d52412937e3, 0x3fa03946e2cadd20,
    0xbfea878c85da4722, 0x3fe0598af9d6e100,
    0x3fa2fbdcc60e7e58, 0x400247aab465607a,
    0xbff366fe167bb5a6, 0x3fcc21244f285202,
    0x3fe42c407ee33960, 0xbff7328b9611d504,
    0xbfef9eb841d878f8, 0xbfc0879a65cdafe3,
    0xbfe32bebf51e9c24, 0x3fd4b67c7c8cc7ac,
    0xbfecc866514e956a, 0xbfb3d99766cab474,
    0x3fdc3c1a9023252c, 0xbfcee8563e743bfc,
    0x3fb2be011c662fa0, 0xbfcba270842843a2,
    0xbfd5747a3432f9c6, 0xbff6f76aa7ac42e0,
    0xbff351d8520faf56, 0x3fe4335789026d21,
    0xbfd449d258e91f5a, 0x3ff7158684ed3378,
    0xbfe0318248f7d8b1, 0x3fe7a59815326545,
    0x3fe5d874daa3b70f, 0x3fd999f708635eff,
    0xbfd9bbcc616883e5, 0x3ff13bc236d3a817,
    0xbfe3fbb5312dc4ec, 0xbfdd9f3b2b71f080,
    0x3f9ce395a7769fe0, 0xbfd223eb467fc37b,
    0x3fdbce4c9bb53d25, 0x3ff04087d482b112,
    0xbfa3c84515c611b0, 0x3fcff8d0054c2a6f,
    0xbfe3c4f95aad0198, 0xbffca39649170ffe,
    0xbfe6638ba06e5fdd, 0x3fcafa530d5fbb80,
    0xbf936e775260eb80, 0x3fbc44ff9d1d7588,
    0x3ff67bf9ad2bcee4, 0x3fba09302c678ce8,
    0xbf938e40f826cac0, 0x3ff47fa00e0ba7e4,
    0xbfbdd9ab17e43eec, 0xbfe034b456ed435b,
    0x3fa1e5fe31940434, 0xbf93ba64b862a800,
    0x3ff7a903f86d4383, 0xbfdf1c932ee1e027,
    0xbfd55279fbf9d83e, 0x3fd7c81932aa4391,
    0x3fe0f4d76a620e31, 0x3fd1c2143c714ee8,
    0x3fd7fc73e2d236d2, 0xbfdeb29cb04b61b2,
    0xbffe910abc38cb8b, 0xbf9b7957a2f5d1a0,
    0x3fb22909bd202954, 0xbff465096b3a60a8,
    0xbff4138e6a50a5ad, 0x3fe20dece27c78b4,
    0x3fda0251a95effa4, 0xbf89426375cf4668,
    0xbff5272c5d8fa1b6, 0xbff5f90c8f536fd2,
    0x3fdf9fa5a7136b88, 0xbfdfd4182f280770,
    0x3fec0cd17a864d7c, 0x3feb2334ffa596cc,
    0xbfce2d2b770b75e6, 0xbfd4cab0ea2226e9,
    0xbfe84370cc6c68a6, 0x3fc34cfd6f203974,
    0x3fd74407bc7c6a48, 0x3fc5ce9e40e77e53,
    0x3ff1bfe8f988ea79, 0xbfd4484058bcdfda,
    0xbff9fb56116bf0cb, 0x3ff0063b71bb2c98,
    0x3fde962c044d8f36, 0x3ffb3851c24ed1c0,
    0x3fb39202f8838962, 0xbfe42910ce030f5a,
    0xbfd21795662e59fe, 0x3fdae8b3a852ef71,
    0xbfd4adc27fd5b785, 0x3ff1e926744a8f73,
    0xbfb53aa28ef85848, 0x3fd1ac0521d0c8dd,
    0x3fe3fa31c522384f, 0xbffa5ae52a6333fa,
    0x3ff0f3ab0220f422, 0x3fe947d381454334,
    0xbfde1b4410139125, 0x3ff815cf8b8f63fc,
    0x3fc46bb608f19bc0, 0x3fccda670e23e706,
    0x3fdaa2715811bec3, 0x3ff0a3d5e3a4a1c3,
    0xbfe59d14adef7246, 0xbff6c9bfb09db07a,
    0x3fcffd446d2d4830, 0xbfd3a683da0aa622,
    0x3fdd5ed05709ca74, 0x3fe04c2ab7af94bc,
    0x0
    };

static const uint64_t ref_rfft_noisy_512[513] = {
    0xbfb8e29ab4bc2fa4, 0x3fe0cd4b8476c7cc,
    0xbfc199602539f3b8, 0xbfed0f7370e4a318,
    0xbfe75925b7449500, 0x3fd961ca943ef88e,
    0x3fe030f26390b3c8, 0xbfea179f712598e4,
    0xbfeddc2b4a40932a, 0x3fe919c475784086,
    0xbfaa42e84179d806, 0x3fd5b89c458ae4c1,
    0xbfdbd015c77a3f49, 0xbff0d6788f088b58,
    0x3ff39c753ec521f6, 0xbfe2e4010ff81afa,
    0xbfe1561f88dafa7d, 0x3fe3f869ae791f21,
    0xbff447b0fbbb8302, 0xbfaf546edcbe215e,
    0xbfec3a1529f14598, 0x3fdd0ddf1d59c2bb,
    0xbfd47491f5117132, 0xbfd2cfb8244de869,
    0xbfb7cd244d00051c, 0x3fc2123919f18891,
    0xbfb83f3c5711095a, 0x3fea5d1d9d6e2560,
    0xc0015d20162817e6, 0xbff68dd41116009c,
    0xbfc45053709c6406, 0xbfdc0542cae05420,
    0xbfcbaaf2b1623f6b, 0xbfc04b5c5a9fe49b,
    0xbff733a1d52016bb, 0x3ffb12d2ed0bf304,
    0x3fd5a9301acf13c3, 0xbfa3af4c5e27bed8,
    0x3fe03d6fe0daa822, 0xbfe5888405a43562,
    0x3fe458af435e5b4a, 0x3fb0a7095893a110,
    0x3fc19ffec8b3494c, 0xbfdf139dc2644128,
    0xbfb9c42925823710, 0x3fcafd0a49e1a3c6,
    0xbfe363fb5aeaf0e8, 0xbfc94d33257f7c9e,
    0xbfd56a49d448467b, 0x3fd206c7fc34a854,
    0x3fef31f3901d963a, 0x3fed039e4e5f4be5,
    0x3fdd95b30d9a81e4, 0xbf96ebee138e5e20,
    0xbfe8c9c9ce1713d7, 0x3f6bbd395fd379c0,
    0x3fe3d55155486b3d, 0xbff4b24c22aff828,
    0xbfed9a0c5242f962, 0x3fd85b2b6175afe9,
    0xbfd0a110f60b1e40, 0x3ff590fb8c8388bb,
    0x3feeab5cc2559886, 0xbff41dd3b9235c6c,
    0xbfe2ed8d20f72be0, 0x3fdc0540a88f716b,
    0xbfd7ac2047dcf95e, 0x3fec5d6ff557173a,
    0x3ff7b33c65841854, 0x3fc88c5cb07c1890,
    0xbfe6b3bef1dca817, 0xbfe707441e462408,
    0xbfcc82b50d3e9550, 0x3fb0aa8ac72de558,
    0x3ff1af5911da8144, 0xbfc0188fc6d7ff69,
    0x3fcc27570b095c06, 0x3fc8afa99fbff854,
    0xbff385982e87f7b2, 0x3fdcdd16ff0efa51,
    0x3fcabd8bf756a15a, 0xbfe68c7fb1e25b38,
    0xbfb374d66b90e3bc, 0x3fb6311c76755270,
    0x3ffd19b6bcdbdaf4, 0xbfe1cf53f73654ba,
    0x3ffef19eb0b8a926, 0xbfdaf23d231a068a,
    0xbfc97de42e17c34d, 0xbfdfc9999416cc66,
    0x3ff215fa9dc0cbf0, 0x3ff74d1250d9bd6e,
    0xbff0d3e2dd289048, 0x3fe0c68fd1a2c768,
    0x3fd78a47a44f6ecf, 0xbfe220fdb85c6c2a,
    0x3ff30557d129c58f, 0x3ff5336b64aaa52c,
    0x3fdd1bc2797198ec, 0x3fe3c9865d5f2c6c,
    0xbfe142a64381bcb2, 0x3ff62cce8adb5aa5,
    0xbfb687ecbddd6ba0, 0x3f53a7c08893b680,
    0xbfecd18205210480, 0xbff24c2ef909d3d0,
    0xbff004c9c0fc6af2, 0x3fe0ff7ad9c831d4,
    0xbfc2fbe64cfe3462, 0x3fa38ff82d765060,
    0x400006869fb6a966, 0x3fdcee65076f9bac,
    0x3fdcd9b0de2fc75e, 0xbff7bae905df4c12,
    0x3fc6b9729f39f081, 0x3fb7989e6defdcea,
    0xbfc34d9e868bde54, 0xbff7a8492474859c,
    0xbfc8b6bdc6b94738, 0xbfef918be518846c,
    0x3fd2f9f8aa50f03d, 0xbfe3ec5f14a7309a,
    0xbfd5340c7e04badd, 0x3fc5caabbb9dabd8,
    0x3fca166b07e118c2, 0xbfe1532ac7f7dc40,
    0xbfe902635185b920, 0xbff4479fff4ac05b,
    0xbfcd2150937de31e, 0xc066647a10be550a,
    0x3f9a68d5465f8590, 0x3ffd445c4ff69e17,
    0x3f9dd04c605d6160, 0xc00185f0706bc100,
    0x3fdce9375692f4d4, 0x3fda00c7edc128f6,
    0x3fdb9e2cc79a4414, 0x3fe68af6c229c0ae,
    0x3fe0136521a64dc7, 0x3fc1079128bd9a10,
    0x3fb1d864b52bfe04, 0x3fdbc0f47a4e7dd1,
    0xbfe1de24e8ed9f56, 0x3ffb513a2f8d5698,
    0x3fe2f51e06480ba7, 0xbfe4ae75cb172735,
    0x3fefcb57daf73e60, 0x3ff31541a5bd67cf,
    0x3ff1ffb848ec9bf7, 0xbff7edcc62819ed9,
    0xbfc0b0e4e8ec23a9, 0xbff8df32b671ad20,
    0x3fe70d3f4b771362, 0xbfe2cdac8fe9044a,
    0x3fc9f565812c15a2, 0x3fe3e43880bf759a,
    0xbfe9ca7c2085c91d, 0x3fe038a397183b0c,
    0x3fa12ae79ddd4870, 0xbfe12c70d3af6256,
    0x3fd8ace33fc428c1, 0xbfbc89e2b728a940,
    0xbfc90d7b7234e3d7, 0xbfad8dea8d03203a,
    0xbfd72be59cc45f46, 0xbfd7eacb13179f75,
    0x3fef77d9b51a91ed, 0xbfe28a63ebd68d0d,
    0xbfe612e7cad26e3c, 0xbfe191f664eb3dc5,
    0x3ff8cbf43793d08a, 0x3fe032987fadd269,
    0x3fee53223169d2c6, 0xbfe8829d7033ae08,
    0x40020ad06679614a, 0xc000187f26917a4c,
    0xbff81ea0a30f0188, 0x3fd1ed869e49ca1a,
    0xbfebc7ec603720e6, 0x3fd4e22d6ff4cd50,
    0xbfe0a72e424135d4, 0x3fe9e4529022d470,
    0x3fe45828db0438f2, 0x4002b518e46153a8,
    0x3fc8597f12bc5b6c, 0x3ff44b75c81dc76e,
    0xbff58dc5dde8f75c, 0x3ffab564c39042d8,
    0x3ff41d953f8eacdc, 0x3fd08ee55f669e86,
    0xbfed3471618e6343, 0xbfe9c02a5661a5ca,
    0xbfd61094011465aa, 0x3ff659e37e2c2a8b,
    0xbff0e392a89565f0, 0xbffd8a4d08037dd0,
    0xbfc2d0cb72b120d2, 0xbfec3d998b0495b7,
    0xbfe20ccaa926992a, 0xbfe2a6afa6d2886b,
    0xbfa7d3fa2966df90, 0xbfd0d9a9ce70e4ce,
    0xbfe2633ed2f4d3c7, 0x3fdc64409ee3b31e,
    0xbfd4cab04ecb19ef, 0x3fd9eb7ba3800e94,
    0x3fd25407d8329b9c, 0x3fecdec4372100ba,
    0xbfeca0e866316170, 0xbfde2cb9c3390c6a,
    0x3fe3b356945e03d5, 0x3fd6bfd1503b2519,
    0x3fd961362cf9ab8f, 0xbfc56e84c2ac2128,
    0xbff67e7f18beea16, 0x3fddd3a08e30e8b6,
    0x3ff8b44af475802b, 0xbff6e4d1869a505e,
    0xbfbd1e6e36ce6718, 0xbf9313a878e7c760,
    0xbfe200ea5f733a5a, 0x3fe4a008983ac138,
    0xbfb58fdc14d8a9f0, 0x3ff06ab4f8b9b7d4,
    0xbf9c3e81281b1550, 0xbfd019ba8bd9e40e,
    0xbfead803c61ac83e, 0x3fb1a503371dd5ee,
    0xbfe157d34b966666, 0x3fb75be3562c078c,
    0x3fe41080ecc82270, 0x3feac0c43791dada,
    0xbfc0a0ceabd7a4cf, 0x3fc6d0857bf3f0e6,
    0x3fd13f89dfc92e78, 0x3f879e4c7fa370b0,
    0x3fecf35f27fa19e0, 0xbff478d87e1b838b,
    0xbfdcc936e7b1b20c, 0x3fe2d46b53f6f7ed,
    0x3ffa636695699954, 0xbfee3ed18f79c25a,
    0xbfdfd5d0691eddc4, 0x3ff4756e760e9520,
    0x3fe1de57b53197dc, 0x3fe0d08105339c42,
    0xbfd6e9cc3d1b1662, 0xbfcd3c75aa99fdbc,
    0xbfe7ead5ed7d723a, 0x3fe524761b8818a7,
    0xbff470c2c81d1efe, 0x3fe1fbba3906d046,
    0x3ff496787be022c8, 0x400563aeebce2ddd,
    0xbfe793590556a5b4, 0xbfe747a0d4fba490,
    0x3fdda0fb7e245fd7, 0xbfdef4fe5e5f49c0,
    0xc002da8a3f632ade, 0xbf69e180a667fb80,
    0xbfee550e32cacddb, 0xbfd3bdefb6eecb18,
    0x3fd3bf4fb70ddf4a, 0xbfc76d79d7a70397,
    0xbfcac5b88fe1cdaa, 0x3fd4f2d7dfec6b3e,
    0x3fb38cde770db3ba, 0xbfaeb6fdd59b6fe0,
    0xbfea31cf9fd4e7ce, 0xbfe3a3e1de23e552,
    0x3fe81d826b984514, 0xbfe080e4ca4fc523,
    0x3ffa544bce815cc4, 0x3fcf7502baccdb1a,
    0xbfc640b864b108b9, 0x3ff65f4353619582,
    0xbff7843aaeda50aa, 0x3fe3f78f713f755e,
    0xbfd461372209693a, 0x3fbd7966b879766e,
    0xbfb983d387dc1e46, 0xbfe88fd92bd10c1e,
    0xbfd6c878e2073936, 0x3fdd13ec9d8e938b,
    0x3fc1009e4fb83086, 0x3fe68b993f7c60f0,
    0x3fe319b17b9d51a4, 0xbfc3bd91260634de,
    0x3fec9e2ec46ad5f4, 0x3fb0ac9be34b94ea,
    0xbff11955096a4ad7, 0x3fe379cf726ce0db,
    0x3fc83ff89546eb10, 0xbfb4ecdb3babab44,
    0x3fe64ceebec11ce5, 0x3ff148dbfd188d5c,
    0xbfdca66dba3702e8, 0x3feb032611c67ecc,
    0xbfef2f70d47ccaf5, 0x3fe4bf489db1b70d,
    0xbfe03b1d306dafa2, 0xbffdbedbdc0c5795,
    0xbfce77da4472e9ec, 0xbfd5bc0202be57df,
    0x3fd113f3643b601f, 0xbfc7eebe982e3a04,
    0xbfe001fa224a554f, 0xbffb5f8ba848895f,
    0x3ff18eb244fc0ee3, 0xbfdaad2c71460750,
    0x3fddb1bba31a156e, 0x3fa470524037a678,
    0xbff5a2cfddafd5ba, 0x3ff6e70a9d724552,
    0xbff1511745685e07, 0xbfe3e3095ddf0ec7,
    0xbfebf2c7296ca754, 0x3fea6f9075313deb,
    0x3fdfc1c93d7bb587, 0x3ff33d22e7850ef0,
    0x3fdb270b7ad6b27c, 0xbff630f2786eb327,
    0x3ff1feff646e75dc, 0x3ff8a85e1c15ed33,
    0x3fe67e26a5c09435, 0x3ff42db91c671c4e,
    0x3fc80bbdc129c610, 0xbfb799454e7e3060,
    0xbfe8eda21f59209f, 0xbfb11331cfb732c0,
    0x3ff9e24f6e053307, 0x3fce1de6eaf08080,
    0xbfe56f03d5f11146, 0xbff76a6d2928f314,
    0xbfe280b52ba67852, 0x3fb0efafec94c192,
    0xbfe3e845412c61c9, 0xbfd168cbfaaa413a,
    0xbf78c7b592de9400, 0xbff98222afe6b93c,
    0x3fb20c620db4c854, 0x3fc10d09ba033f8e,
    0xbfe2ae038a49ad19, 0xbfbb3fae02dd2298,
    0x3fe9be0768219902, 0xbfb4fc0420af8ed0,
    0x3fe4a97d9c8a68bf, 0xbfc92cd7c3e8bb09,
    0xbff750182d545cee, 0x3fd4d4a021b59b89,
    0xbfd2b8ad8e03edd0, 0x3fcb59898983fc66,
    0x3fdfd118d3bdbea7, 0xbfe48719ab180a2a,
    0xbfe0cb92b266552f, 0x3ff50aa60b228a73,
    0xbff37d2cbefe735e, 0xbfea218c34a05218,
    0x3fed1df1dedee9bc, 0xbff25996cf069ccf,
    0x3fe589a8e1093dbe, 0xbfcdfd73e59b360a,
    0xbfd7363244f60e78, 0x3fcea365df4ba750,
    0xbff43a719819a1a7, 0x3fdaf2ec1b1a3ec0,
    0xbfe3e621fb28bcaa, 0x3fe154c7009f4f3a,
    0xbfb6aa23788e6368, 0x3ffc14ec991e4232,
    0xbfe2515a817e28be, 0x3ffccec251125a80,
    0xbfe479198cbd2c8a, 0x3fe4ac4c8934b2ba,
    0x4000bab9f6611179, 0x3ff05a1a11a9ec7d,
    0x3fec2b346bbbab74, 0xbff3edc6c9e4e44b,
    0x3ff2114287dece61, 0x3fe48d4b5c509d57,
    0x3fe782ba0a5d171e, 0x3fc5cb0a96713ef8,
    0x3fe7e80364052cfc, 0x3fb64ffd0ddb0850,
    0xbfd7989e6d37948f, 0xbfe861ca44519e80,
    0xbff063d592874418, 0xbfc121ae72229198,
    0x3fc427338bce2922, 0xbff2cc35108290be,
    0xbfd2232534f5957b, 0xbfe9379e6aa990a2,
    0x3feaa7784101ed94, 0xbfc5eaaf5c9f560a,
    0x3fe3a857e44957ca, 0xbfc3fb53eb87aff8,
    0x3fad9c1ca37bcc52, 0xbfebc878ae7e9edc,
    0xbfe51b9cb0a24da4, 0xbfc97553764de921,
    0xc0010d52412937e3, 0x3fa03946e2cadd20,
    0xbfea878c85da4722, 0x3fe0598af9d6e100,
    0x3fa2fbdcc60e7e58, 0x400247aab465607a,
    0xbff366fe167bb5a6, 0x3fcc21244f285202,
    0x3fe42c407ee33960, 0xbff7328b9611d504,
    0xbfef9eb841d878f8, 0xbfc0879a65cdafe3,
    0xbfe32bebf51e9c24, 0x3fd4b67c7c8cc7ac,
    0xbfecc866514e956a, 0xbfb3d99766cab474,
    0x3fdc3c1a9023252c, 0xbfcee8563e743bfc,
    0x3fb2be011c662fa0, 0xbfcba270842843a2,
    0xbfd5747a3432f9c6, 0xbff6f76aa7ac42e0,
    0xbff351d8520faf56, 0x3fe4335789026d21,
    0xbfd449d258e91f5a, 0x3ff7158684ed3378,
    0xbfe0318248f7d8b1, 0x3fe7a59815326545,
    0x3fe5d874daa3b70f, 0x3fd999f708635eff,
    0xbfd9bbcc616883e5, 0x3ff13bc236d3a817,
    0xbfe3fbb5312dc4ec, 0xbfdd9f3b2b71f080,
    0x3f9ce395a7769fe0, 0xbfd223eb467fc37b,
    0x3fdbce4c9bb53d25, 0x3ff04087d482b112,
    0xbfa3c84515c611b0, 0x3fcff8d0054c2a6f,
    0xbfe3c4f95aad0198, 0xbffca39649170ffe,
    0xbfe6638ba06e5fdd, 0x3fcafa530d5fbb80,
    0xbf936e775260eb80, 0x3fbc44ff9d1d7588,
    0x3ff67bf9ad2bcee4, 0x3fba09302c678ce8,
    0xbf938e40f826cac0, 0x3ff47fa00e0ba7e4,
    0xbfbdd9ab17e43eec, 0xbfe034b456ed435b,
    0x3fa1e5fe31940434, 0xbf93ba64b862a800,
    0x3ff7a903f86d4383, 0xbfdf1c932ee1e027,
    0xbfd55279fbf9d83e, 0x3fd7c81932aa4391,
    0x3fe0f4d76a620e31, 0x3fd1c2143c714ee8,
    0x3fd7fc73e2d236d2, 0xbfdeb29cb04b61b2,
    0xbffe910abc38cb8b, 0xbf9b7957a2f5d1a0,
    0x3fb22909bd202954, 0xbff465096b3a60a8,
    0xbff4138e6a50a5ad, 0x3fe20dece27c78b4,
    0x3fda0251a95effa4, 0xbf89426375cf4668,
    0xbff5272c5d8fa1b6, 0xbff5f90c8f536fd2,
    0x3fdf9fa5a7136b88, 0xbfdfd4182f280770,
    0x3fec0cd17a864d7c, 0x3feb2334ffa596cc,
    0xbfce2d2b770b75e6, 0xbfd4cab0ea2226e9,
    0xbfe84370cc6c68a6, 0x3fc34cfd6f203974,
    0x3fd74407bc7c6a48, 0x3fc5ce9e40e77e53,
    0x3ff1bfe8f988ea79, 0xbfd4484058bcdfda,
    0xbff9fb56116bf0cb, 0x3ff0063b71bb2c98,
    0x3fde962c044d8f36, 0x3ffb3851c24ed1c0,
    0x3fb39202f8838962, 0xbfe42910ce030f5a,
    0xbfd21795662e59fe, 0x3fdae8b3a852ef71,
    0xbfd4adc27fd5b785, 0x3ff1e926744a8f73,
    0xbfb53aa28ef85848, 0x3fd1ac0521d0c8dd,
    0x3fe3fa31c522384f, 0xbffa5ae52a6333fa,
    0x3ff0f3ab0220f422, 0x3fe947d381454334,
    0xbfde1b4410139125, 0x3ff815cf8b8f63fc,
    0x3fc46bb608f19bc0, 0x3fccda670e23e706,
    0x3fdaa2715811bec3, 0x3ff0a3d5e3a4a1c3,
    0xbfe59d14adef7246, 0xbff6c9bfb09db07a,
    0x3fcffd446d2d4830, 0xbfd3a683da0aa622,
    0x3fdd5ed05709ca74, 0x3fe04c2ab7af94bc,
    0x0
    };

static const uint64_t in_rfft_noisy_1024[1024] = {
    0xbf9ad4f03fc385ac, 0x3fe16029b61f75d3,
    0x3fe81d1110c8e626, 0x3fe01abc1e02216e,
    0x3fa0b6a3c49caec4, 0xbfe139885a941f88,
    0xbfe4537612a1b8fe, 0xbfddfd99620dbc54,
    0x3f8bd1dbeb67886d, 0x3fdf55bbfd32dd22,
    0x3fe5c562a11eef68, 0x3fdcf6d08abaea46,
    0x3fa1d99f4e3ea089, 0xbfe00e01966be78d,
    0xbfe6e50768bdfaa1, 0xbfdb35be0b6db78b,
    0xbf96e0b1eae412ec, 0x3fe0ed8056c6e364,
    0x3fe538536acda833, 0x3fde3b835e57689e,
    0xbfa44406f8494c16, 0xbfe00119319b77ad,
    0xbfe52f4dbe1c81f4, 0xbfe04e8be3d8dea5,
    0xbfa8ebffb6a45250, 0x3fdc79cd4b065f46,
    0x3fea1b155bbbcda0, 0x3fe0410ef4c9742d,
    0xbf9f87eeebf2889b, 0xbfe06883f03bc2d4,
    0xbfe8a70d7cf637c0, 0xbfe00b0ff85e77c1,
    0xbf6a47a5f1f0d074, 0x3fdd458afcba2cc5,
    0x3fe7d597f19a9866, 0x3fde7096cdb7b780,
    0x3fa457a974052f66, 0xbfe184d7d1c5fb13,
    0xbfe397ebaf6ee34c, 0xbfdd576345746d5b,
    0xbfb253b7ec2c2e8a, 0x3fe02516cf114bca,
    0x3fe959e7ea6cf12c, 0x3fde9a2704651096,
    0x3fb146e763e5d9b0, 0xbfdbb983a2635fff,
    0xbfe6032b75e4a1ba, 0xbfe13d9b4baa535f,
    0xbfa57a07bee22988, 0x3fdf603664dfc23d,
    0x3fe77891029bdb6b, 0x3fe0578756a38bfe,
    0x3fa4139c55e35dff, 0xbfdd30f0e8b4151e,
    0xbfe5dc11900517fd, 0xbfe0be21d737414e,
    0xbf6ead5cda87c05e, 0x3fe16b4dbf73234c,
    0x3fe77555cdd2167b, 0x3fddce6b7db8ec42,
    0xbf9abc64a88af249, 0xbfe1c3b79fb61032,
    0xbfe4b2492a0268df, 0xbfdf59d23151a8f9,
    0xbfa1cbd1067230e4, 0x3fdd85fa568fa321,
    0x3fe6b6d83fa67095, 0x3fe316e8fcbed6d6,
    0xbfa477ef0c281857, 0xbfde2eee9500d629,
    0xbfe6154394008930, 0xbfe4f28ef06dbd44,
    0xbfadb7c569f6ed48, 0x3fdff77060c4ed12,
    0x3fe7e25d8e74cae4, 0x3fe3621e59a825d0,
    0xbfa7c17b82fd1073, 0xbfe2d0377609520a,
    0xbfe698623cb2a19a, 0xbfdd6679080ee3d2,
    0x3f8dbdb292be14e8, 0x3fdb536ee0fa0573,
    0x3fe6072bd642b237, 0x3fdca4b95cd8a135,
    0xbfb48f35bf206bad, 0xbfdf38cf80f82262,
    0xbfe5b90674deb914, 0xbfe10cf6399fcd8c,
    0x3f7730587f04906c, 0x3fdcefb2d364aa06,
    0x3fe53fa8bf132e66, 0x3fe183f8a47ab00e,
    0x3fae0d3d33955195, 0xbfdd527b15eaa2ad,
    0xbfe640657d3e357c, 0xbfd8dcaf637da057,
    0x3fa12929a162492f, 0x3fe0c12c12967f08,
    0x3fe6dcef0b562e40, 0x3fe1478122cc4178,
    0x3fb2d23cf9d36835, 0xbfdb5bed42c86172,
    0xbfe5a34f7b539434, 0xbfe1bce54c75dd75,
    0x3f9b57e2c4cf7eee, 0x3fe0cd697c6500e5,
    0x3fe4206396d34689, 0x3fde1e37737ae155,
    0x3f80a8e325d74d49, 0xbfde43b289f11673,
    0xbfe805eff48e3e97, 0xbfe0d776eefbf384,
    0x3fa0ff6fb8fc638f, 0x3fdbb578fd3f595c,
    0x3fe88d18e19b3154, 0x3fdd1bc597c4edc5,
    0xbfa43f66b0279d10, 0xbfe248a5186094f1,
    0xbfe562d2ad06d3ef, 0xbfe10b9e0697ce40,
    0x3f90a147aa242d49, 0x3fdd3078e7fa475a,
    0x3fe0c7f432234621, 0x3fdd37ee7c2249d6,
    0x3faf5c91c4ee7434, 0xbfe0ea53068a0d97,
    0xbfe836e77000cdf2, 0xbfdd48fa6bfa969d,
    0xbf81f049905d9e1d, 0x3fdfb5dd7d97a7ed,
    0x3fea09c106d76fe3, 0x3fe20381b604ef3b,
    0xbfad600623656083, 0xbfde6dc138a66e98,
    0xbfe888bbbdd23167, 0xbfd9b884df6d4746,
    0x3f91ddea33e9b646, 0x3fdf24083bd8e87d,
    0x3fe5f2d68a4bd2d5, 0x3fdd93ac5122655d,
    0x3fae27b062592b87, 0xbfe0fd07e3e4e649,
    0xbfe4d08f325eabe6, 0xbfdf948a5a51b028,
    0xbf813f1fcbf63622, 0x3fe10c0e364ecc90,
    0x3fe466478930d506, 0x3fe04ff76f7a91a2,
    0xbfb82cc4843b9524, 0xbfdd455cfadd409a,
    0xbfe4a35d201c917f, 0xbfdc7b994f908b80,
    0x3f86edf2aa4a44b7, 0x3fdd543252ea6bef,
    0x3fe60bbb68e5cbdf, 0x3fe2ea273718742a,
    0x3fb0cc90d11d71d3, 0xbfe065b39f39b459,
    0xbfe6c61e18052434, 0xbfe1bab94cc98906,
    0x3fb3ec6129d09d73, 0x3fdaa01ab0ec2948,
    0x3fe830807ca7da0b, 0x3fe2ce3f4a97c91f,
    0xbfb81ded4c837d8e, 0xbfe0771a1ca049f5,
    0xbfe7847ac53d6248, 0xbfdaf6b942585efb,
    0x3fb10e3121f30443, 0x3fe00ab786364731,
    0x3fe96672da37bbb9, 0x3fe1539c656728cc,
    0xbfb50c0f0ec77b29, 0xbfe01ebba99158ba,
    0xbfe5b6a065a74b7c, 0xbfdff7b361b9b839,
    0x3fba52622b471db7, 0x3fe47731c4bd9a6d,
    0x3fe648fd61abe5ce, 0x3fdc528c790dcfa6,
    0xbfa9091c327a6b5e, 0xbfe20c49bf1aae3e,
    0xbfe6a3bfdc0502f5, 0xbfe0eb35061d5672,
    0x3fc010ab5af2627b, 0x3fdf9fa20b218c31,
    0x3fe6aa7679229581, 0x3fdfe43d9588721f,
    0x3f418e6e9a646468, 0xbfde4541161c631c,
    0xbfe68cef07c00868, 0xbfe00b337f5af8de,
    0xbf90ea036cfff6bf, 0x3fe129ce125c8e08,
    0x3fe5855bc08fe8a3, 0x3fe09fa3bd0e94d0,
    0x3fb76cf545e79eb2, 0xbfe08e91ab14b136,
    0xbfe79635d7587d66, 0xbfdd274c8fbbe69b,
    0xbf81e8aa334c428b, 0x3fe226735fe1d5a7,
    0x3fe64c8776cef2c5, 0x3fe0b731d5eaddab,
    0xbfb5d6d94929c325, 0xbfdaf352f9000ad0,
    0xbfe7859d85331c3b, 0xbfda0dc05581203e,
    0x3fac2642c83ebe84, 0x3fe200994612b2ed,
    0x3fe6c078cf0d3f25, 0x3fe1de3fa06366ac,
    0xbf6babe2bc2f272f, 0xbfe13badbf20f0e3,
    0xbfe3daeb0c6d7aa7, 0xbfe0f587664dfe8a,
    0xbfc173bdb538b570, 0x3fe21b8f2c919fc2,
    0x3fe623a9e289c1c6, 0x3fdcdfe00e54ee3c,
    0xbfaf0ef5a4c188f8, 0xbfe061a121960d23,
    0xbfe4f23a82f521f9, 0xbfe458b41d249f74,
    0x3f7bd4173eae0081, 0x3fddffa268269ba9,
    0x3fe484f3062b6cad, 0x3fe2f46c02ea1eed,
    0xbf9d7c388818ba86, 0xbfdd52210841d956,
    0xbfe73462637a6289, 0xbfdb636d2f48d4e3,
    0xbfb2539965e9e361, 0x3fdf0c840ee8b4ba,
    0x3fe7df04ff044dfd, 0x3fdf58ad5b84ceaf,
    0xbf6433c6f8b1ddd4, 0xbfe031f345a5d4e7,
    0xbfe51eb693bc3ca9, 0xbfddcfe10ffae31f,
    0xbfab73bf3c9cd64b, 0x3fddd8544f9b3b80,
    0x3fe45057dfcf2031, 0x3fe02723ab02cd35,
    0x3fa8c73ee30c4e63, 0xbfe214183e4e3f74,
    0xbfe82528b82abc87, 0xbfdc6b4d25268cb6,
    0x3fac36907057bc71, 0x3fdccc35203e1585,
    0x3fe71f037f5eb5f4, 0x3fdb0921f8482a27,
    0xbfa84052b2badce2, 0xbfdf37bbbf3eba5e,
    0xbfe74d4510a07c1d, 0xbfddb643720ddaf8,
    0xbf78cc89b8424aa0, 0x3fdf44e5279b2e92,
    0x3fe6b69049eaaa14, 0x3fdc8536e0b5be10,
    0xbf8075c2dd698cb6, 0xbfde2c60c9df5ff0,
    0xbfe61d9d3254a31c, 0xbfdebdac2507672e,
    0x3f835a4c9380b599, 0x3fe275825f7955f2,
    0x3fe5cd507713d8ac, 0x3fdedc6184650bff,
    0xbf9d443e8bce3cc1, 0xbfde8b83ef256028,
    0xbfe419a35d37860a, 0xbfdb07e5167ccbae,
    0x3fa5ab2374dc3ce0, 0x3fe48b6c279efd36,
    0x3fe267307881053a, 0x3fdd816c9b009306,
    0x3f9bf22f0ca1eae3, 0xbfe09a1e53ec09a7,
    0xbfe5b6f92c481c68, 0xbfe0a270743a7243,
    0xbfa073fb52a2fcf5, 0x3fddd03b697f1995,
    0x3fe830671c421d69, 0x3fe0ae5536a69ec6,
    0x3fa219cac9611c72, 0xbfe18ffb6942fc11,
    0xbfe28a7d0564e846, 0xbfdc669aa90bebe0,
    0x3f8e92152437932a, 0x3fe10a0a75361d73,
    0x3fe5e87b7a45f125, 0x3fdfcf8a6f3462b6,
    0xbfb291c446881f34, 0xbfdd10aaaec4987c,
    0xbfe6e147bb355368, 0xbfe062f136343a82,
    0x3fa51ddcbe4dd197, 0x3fe26797d58c5d76,
    0x3fe85ec8d46e6289, 0x3fdd131ed553de24,
    0xbf9e80cae9583052, 0xbfddd0390ba02fbc,
    0xbfe8048be1cce524, 0xbfdd4e668a4fb88d,
    0x3f9241cc6906cac1, 0x3fe16e012390a768,
    0x3fe312c927cc0a9d, 0x3fddd7ca8bf71292,
    0x3fa52c1dbfc48753, 0xbfde9e93f1be9efc,
    0xbfe890302327bb79, 0xbfe0e0a0c48d940d,
    0x3f88128d42a2c71f, 0x3fe017c297eeb093,
    0x3fe55538511ea14b, 0x3fe32b93085ac709,
    0x3fa17eb461559850, 0xbfe041bf438c56e2,
    0xbfe6b7bd008e6d5a, 0xbfe013d488bcdcd4,
    0x3faba6129924ad51, 0x3fe155a3595a1833,
    0x3fe8cce2cd7b6e1c, 0x3fdf8346e111ec00,
    0x3fba10d7339a8aca, 0xbfe154da66a07622,
    0xbfe5d3a59934773d, 0xbfe25ec61603be21,
    0xbfaca3de45ab334d, 0x3fd9524c374037a4,
    0x3fe6e0832ec6d7f4, 0x3fddc78a2557d52e,
    0xbf959c58ecb89c7e, 0xbfdb622b6a13e74f,
    0xbfe3a010a953e356, 0xbfd95d2e382a32b6,
    0xbfb58bf90c834bed, 0x3fdec109c6aab888,
    0x3fe5daefd8b588bb, 0x3fde741fee2ffef7,
    0xbfabfe23d0b837e3, 0xbfe1d002af2c033b,
    0xbfe4f6dae67038f3, 0xbfe0c1426df2deec,
    0x3fa7bb235d526a96, 0x3fe1bbf07b329648,
    0x3fe701d3dba23193, 0x3fddf3db250d8cf7,
    0x3facb4b3417e70c7, 0xbfdff6f4b956e36c,
    0xbfe5a9d717662a26, 0xbfe1a9530f57d59e,
    0xbfa5197b49248dd6, 0x3fe058f22e9ff07d,
    0x3fe2a964eda68d24, 0x3fe10ce9de917a2f,
    0xbf750350b47af7c0, 0xbfdd0b67ecb680bd,
    0xbfe3d94ff2480212, 0xbfdd15c2d8011e3c,
    0x3fad02ab5fdc67ad, 0x3fdde8a8781ab306,
    0x3fe5303dcd9548f6, 0x3fdafb31b31081bc,
    0x3f81ca23d551f147, 0xbfe15bc328c54016,
    0xbfe3caf756e1aaba, 0xbfdaafea18c529cc,
    0xbf94d5e745f7b47c, 0x3fe244dd38808f69,
    0x3fe545294d2bb22f, 0x3fdeb71e27b270a1,
    0xbf63bb01b1037241, 0xbfdfc42763262dcd,
    0xbfe5c2f0d8da46b1, 0xbfde653cc3885a1a,
    0xbfb3a4a340b26a97, 0x3fe117fb19ed8091,
    0x3fe6a14942781def, 0x3fe271c8fcbd817b,
    0x3f7bc72d933a3763, 0xbfe19ffede8c4a2c,
    0xbfe639a5a93396c7, 0xbfe09395bf45ca11,
    0xbfb47fc4e3807513, 0x3fe2367d57c4cb50,
    0x3fe3777a73bf32c9, 0x3fe214cd7cdf1b79,
    0x3fb24a67f71e8398, 0xbfde0fb36c873964,
    0xbfe6bdaafb3a18d1, 0xbfde1ccd720ca4f1,
    0xbfa490974de2b6eb, 0x3fdc4643a977df3a,
    0x3fe6fc86d03bd144, 0x3fe2163e0f100368,
    0xbf9cf86caa43e4f5, 0xbfe174e7f7bb0053,
    0xbfe6a64ff3ed4038, 0xbfdcd84048ea30e7,
    0xbfb4a267daa3473a, 0x3fe0fa4428237288,
    0x3fe67657fcf02e63, 0x3fdd69964eb79854,
    0xbfa6e681121945d9, 0xbfe3d1c8e2d50a35,
    0xbfe70d074aaa9a2f, 0xbfdc8358cd4007e6,
    0x3f84a024fc07155c, 0x3fd96c590b176eca,
    0x3fe7a0cfd40aef61, 0x3fe03f7c414654cc,
    0x3fb79b22f38aeafe, 0xbfe1facfd557684d,
    0xbfe6eb369f8a31d5, 0xbfde8798417e1a53,
    0x3fa68f54467cdcd6, 0x3fde239f5728732f,
    0x3fe5a57e6a9e5753, 0x3fe1110f08ea3c9b,
    0xbfa30d3002926b8e, 0xbfdd11a31560f855,
    0xbfe69a9917b5a8ac, 0xbfe1098d1408a22d,
    0xbf53985fa383e49c, 0x3fe1f3f4ef99a5b9,
    0x3fe460134919f2a4, 0x3fdb20dbd95d8209,
    0xbf9f08ff1dd94aeb, 0xbfdc08a9cad52d0e,
    0xbfe918cdde209a91, 0xbfde4bd1cee4aa3a,
    0xbfa6f60174b7fe54, 0x3fe23d36a220f401,
    0x3fe73e5526800053, 0x3fe0bdf516db50aa,
    0xbfaef87aab93c386, 0xbfdccdef180713c1,
    0xbfe7a5224d4965bb, 0xbfe041ac4cd81645,
    0x3f870d121bb2b99e, 0x3fe37e8d707c0008,
    0x3fe5f1109d76ad5b, 0x3fdcaf9246ee4801,
    0x3f855db3ed8ca1c4, 0xbfde04af77bc2b4d,
    0xbfe38717fdbc292a, 0xbfd9fad82027fbd2,
    0xbf8a27bdfd48f2ac, 0x3fe0c8753fefe00e,
    0x3fe76fb652dee5f4, 0x3fdb67818b018554,
    0x3f9d266bd22f5e22, 0xbfe2bd4923d8d7f1,
    0xbfe63779de8e6935, 0xbfdfabbb6b26f34d,
    0xbf73e6c3bea9b40e, 0x3fdee7a170db726d,
    0x3fe475bf47783873, 0x3fde848082f0da5d,
    0xbf9559dee52f4ac5, 0xbfe16ad9ad71a83d,
    0xbfe6e5781a22d036, 0xbfdf1e379887a633,
    0x3fa78dc5573cb0b4, 0x3fe2a25e8adaa422,
    0x3fe7e3bf49f44818, 0x3fe0069899dd0074,
    0xbfa4f41f993f5ca2, 0xbfdf87809fb70dbf,
    0xbfe772002f99bbbc, 0xbfe3b4047f2b4b06,
    0xbfaad6b74b8459f6, 0x3fe0cb7814d2f4ab,
    0x3fe334b502302661, 0x3fdcd6c9c0cd697a,
    0xbf80bdad14284a59, 0xbfdee5e2d7068992,
    0xbfe7fb19a10ba6e7, 0xbfe12e9cd5eea653,
    0xbfc07398d0ed6369, 0x3fded9b99043039c,
    0x3fe72875012b01a8, 0x3fde5d979847da5b,
    0x3f8d4411042fb365, 0xbfdd770275cb459b,
    0xbfe6650e8428e3e6, 0xbfdee53967387413,
    0x3fa963aaf4bb308b, 0x3fe0f894288dffd1,
    0x3fe817fa004cc0a7, 0x3fe14bab682702c8,
    0xbfb45a7398e522e9, 0xbfddf0334d7c331c,
    0xbfe37b005c6f3582, 0xbfdc855f792fd6e0,
    0x3f9544be23a4b4eb, 0x3fdca8ad331f4a92,
    0x3fe576e94be48d7f, 0x3fe1c19e6aa04bbe,
    0x3fac14027c6395b7, 0xbfe0c2858e1cee6d,
    0xbfe8bad6e5bd0df3, 0xbfddb8ba2a98fcc9,
    0xbfb3662078e0369c, 0x3fdc5977b7748e94,
    0x3fe5de90b10354c6, 0x3fe06a2d9d0230ed,
    0xbfa8bfd28ab69e9a, 0xbfde16f93f4dcb8a,
    0xbfe83db9de976816, 0xbfddd855dafa501a,
    0x3fac02c3f8dfabab, 0x3fdd33495cbe95c6,
    0x3fe48ac4c9106681, 0x3fe0f5a685c1c725,
    0xbf8fb070bfbfc916, 0xbfddb4053e1fa453,
    0xbfe6bf62cead71cb, 0xbfdf3dde12dffe14,
    0x3f5eecbea3ccc4f0, 0x3fdc3e3bd541e059,
    0x3fe654b21aa140e2, 0x3fdfb977fe4bef59,
    0x3fb05a35edfd484d, 0xbfdad601ab005841,
    0xbfe55058aab78125, 0xbfdbbca81b461742,
    0x3f8299f5ce848bf5, 0x3fe3546932ebd689,
    0x3fe7302689c9e1d4, 0x3fdd1b81531830e7,
    0xbf9d1747f60926db, 0xbfdbd59de42ed6b5,
    0xbfe6c697b61a34fb, 0xbfdfee72878220b3,
    0x3fb55d5ce1f0d39b, 0x3fdfae63829093a7,
    0x3fe75b8a010fdfb2, 0x3fde40886ecbad13,
    0x3f9e8f457a24cccf, 0xbfe26260ab9b75d9,
    0xbfe77e8b36dbb975, 0xbfe01237bc8666d4,
    0xbfaa1d62b022bba2, 0x3fe081cd75efd839,
    0x3fe4bc493461346c, 0x3fe10362a98f3687,
    0xbfa3984071b846d2, 0xbfe009665144d453,
    0xbfe448fc5d5f9c48, 0xbfe02254330b0a7a,
    0xbf904ebc966403ff, 0x3fdbe15f7265e578,
    0x3fe6322eb11419b0, 0x3fe052a0493985f2,
    0x3fa4eee4ea219ec1, 0xbfe1ed301c337445,
    0xbfe5a13d2248e507, 0xbfdf39586c907a3d,
    0x3f77cd23a6dfca02, 0x3fdfc098080424c8,
    0x3fe5c91238f6fd04, 0x3fe02e2798d85e41,
    0xbfbc93b0a934efdd, 0xbfda5eefc723a024,
    0xbfe407395ebde075, 0xbfe02831eff01685,
    0x3fa0ded275278905, 0x3fdb59fdcc139c57,
    0x3fe637dba93c52ce, 0x3fe272c65ec5f207,
    0xbfa53725fef78ffa, 0xbfdb2895206ef67b,
    0xbfe5c2eaa013f5e9, 0xbfe13f0fbbffbebb,
    0x3fa5df9c3f6ea498, 0x3fddd48b0d3cac84,
    0x3fe79dcd21310cea, 0x3fe236dc939fb9f7,
    0xbf9ec6f03d74e10b, 0xbfdf1af1d87b6479,
    0xbfe6bf4f2dc6856a, 0xbfe1a2aa9e307df3,
    0xbfa0b4718a6b8ee2, 0x3fdb44529d6f6244,
    0x3fe5775f2ee9e354, 0x3fdd0952dced275a,
    0x3f19263d8ec4f63a, 0xbfe233b86b866357,
    0xbfe7caf021d2de6e, 0xbfe1c65785942352,
    0x3f9ce425453327d1, 0x3fdce8838531c764,
    0x3fe1a0de76fa8623, 0x3fdf3ed556d261d6,
    0x3f7b693473bb315f, 0xbfdf6f0b1ec6a4f7,
    0xbfe47d83e2c31d49, 0xbfe04ea4c6c1dbe6,
    0x3faee8ba6109a4dd, 0x3fdd8be3a75e5818,
    0x3fe80907d0ad2869, 0x3fe0b809349f2356,
    0xbfa60db920984fea, 0xbfe2c248a412982e,
    0xbfe57609e8283595, 0xbfe1d56f32479698,
    0x3fbe3372d2938c5f, 0x3fda2fad07cea97d,
    0x3fe89b18d3201693, 0x3fe087f087760b57,
    0xbfa5fea7185d8466, 0xbfdfda2cbedad648,
    0xbfe37747768e50bc, 0xbfdcba48bc3a7be4,
    0xbfa23cf76cdc0e59, 0x3fdf6f8f2ddfaf72,
    0x3fe36b995674d472, 0x3fdc5aecaba8618a,
    0xbfa0a6a2fc9fcee6, 0xbfe00409e43370fd,
    0xbfe664b68fb2e46a, 0xbfddcae3cfa683ea,
    0x3f8e4b5f28c62a74, 0x3fe1de7504b34571,
    0x3fe41cd829025f72, 0x3fdea4d7bc3a56d0,
    0x3f8124605ca661ab, 0xbfe0232ed18f1aab,
    0xbfe96a820abf28e2, 0xbfe0183668a45090,
    0xbfa081df95172f99, 0x3fdc3f28e5655cd6,
    0x3fe560bc89598a2e, 0x3fdfa4b3c4bb87c2,
    0xbf9f9c91cea09b58, 0xbfda1eb1d9eb0b80,
    0xbfe6db9fd58f1977, 0xbfde833d6b5a3a1f,
    0xbf7b3fbb09115822, 0x3fe07ce468a3ee1e,
    0x3fe62cac843d5d7a, 0x3fe0783af2145772,
    0xbfaa942857013f70, 0xbfe3ce9e05067696,
    0xbfe67b5f40cb0157, 0xbfde87e7689bed49,
    0x3fa15c1cae1bbc60, 0x3fdea5ca3e0882f5,
    0x3fe689e510d7bc7f, 0x3fdc63ea0971c6cf,
    0xbf75c6b5a6d09ce2, 0xbfdad85b759f6d57,
    0xbfe77497dcd043ce, 0xbfd9ed11d54978f0,
    0xbfa93221acf70a1a, 0x3fdbce53639fd9de,
    0x3fe5140fead36309, 0x3fdd2c5bfa4a3192,
    0xbfb44d18e6053645, 0xbfdde5e1f25743e5,
    0xbfe484e9740d9560, 0xbfdefa63daada3fd,
    0x3fa3c6f865942a17, 0x3fdc17edf905a382,
    0x3fe62baea3df283a, 0x3fe55ff78a21fb5e,
    0x3fb458f7c3a643c1, 0xbfe3191bd60e7325,
    0xbfe7989ff4f64134, 0xbfda9e9bb407bb61,
    0xbfa1dac0ed913ae4, 0x3fdfddbafe510914,
    0x3fe745a92a42136a, 0x3fe270a908e92dee,
    0xbfa73d53969ea52a, 0xbfe1435936e90d2a,
    0xbfe1c0c00e62da6e, 0xbfdb8b01d9036566,
    0xbf91c70ee4da7d62, 0x3fe08d93052811bf,
    0x3fe65e6514491ff6, 0x3fe0daa8ce607fc9,
    0xbfaa2f45ff645221, 0xbfdc0056647f654e,
    0xbfe6c4ab6016fa43, 0xbfe00cd13ea06aee,
    0x3f795158643d7568, 0x3fdc8222e068803e,
    0x3fe213de3292312a, 0x3fe03139743011c8,
    0xbfb698a5ad6e1169, 0xbfdea6e4a727d952,
    0xbfe8d3c19e2f149c, 0xbfe1f60f82a111d2,
    0xbfadad1bba86bd2b, 0x3fdee5530ab1b62d,
    0x3fe522862fda60d1, 0x3fe2e8593647914a,
    0x3fa2a0f1a9f5c1a9, 0xbfd752c454b5c667,
    0xbfe75b37464ae065, 0xbfdea66505260068,
    0xbfb7a242045a7f0e, 0x3fdd8dbfbceb0592,
    0x3fe80a19b9e06602, 0x3fe053c07e002570,
    0x3fb4601c88702328, 0xbfdd2c5baab3d785,
    0xbfe5581440879f1e, 0xbfe022060d4a235d,
    0xbf7519f212bdfa85, 0x3fe0c38259096ec6,
    0x3fe49bdfbfc4765d, 0x3fe259ccb2dfcc33,
    0xbf55827272de4ef1, 0xbfe0170e81a568e9,
    0xbfe3fd140e7394da, 0xbfe14c127dbb2c0c,
    0xbfb7d4426d8a69f1, 0x3fe166460823c425,
    0x3fe551bdd1aefe6a, 0x3fdedbbf984c900c,
    0xbfb445b8661bcb6b, 0xbfdf16fcd9411d7c,
    0xbfe7e45aba11a864, 0xbfde127974d7f809,
    0xbfa582d70d962e8d, 0x3fd691736f570cca,
    0x3fe5fbf7e3afa163, 0x3fdf1274f509ad40,
    0x3f9d09964fa626b7, 0xbfde912ff7f99f41,
    0xbfe4ec9cefccef31, 0xbfe1ec3ca4c47fcb,
    0x3facbc6d0e3e2b28, 0x3fe0d90366163365,
    0x3fe7fa080f68ba38, 0x3fe097339bb431c5,
    0xbfbf77e0183ad5e6, 0xbfdeee05045fbe41,
    0xbfe7b1c2dcf59521, 0xbfdac6812fd7e33a,
    0xbf864b6cd72d48ae, 0x3fdd94160f66a68f,
    0x3fe79561b9e8a284, 0x3fdfc0c8809a8c2c,
    0x3fb252948fb3a68d, 0xbfe0797188e56840,
    0xbfe6660240c5032b, 0xbfe119ab82de5d32,
    0x3fa2c7bd97bbd6ad, 0x3fdeb3718ee6fac9,
    0x3fe304beef43c6f0, 0x3fe0ba81f0b54646,
    0x3f90f24648e27b16, 0xbfe2a18c6b1870dc,
    0xbfe320b1a20a4932, 0xbfe1e2bd2afd834e,
    0xbf8575d917800778, 0x3fe0bcd32f35e812,
    0x3feaecaf02c1aee0, 0x3fe02fd9985c8c27,
    0x3f9812506fa89b70, 0xbfdad382911d5c5a,
    0xbfe6954e132c3574, 0xbfda1703afe863ae,
    0xbf73598296cded10, 0x3fdcc752b89e8961,
    0x3fe507246817f4f2, 0x3fe07f5d07bbd921,
    0xbfa2e86c9c42aaeb, 0xbfe065d082fa081b,
    0xbfe8689fd8f28a07, 0xbfe0e062fb364696,
    0xbf2e3fae710f32cf, 0x3fddca194780c7a8,
    0x3fe414f015c85d14, 0x3fe24a74ada8381f,
    0xbf7a980385298382, 0xbfe09ded174dce90,
    0xbfe8f21c57a3d524, 0xbfde631fd5049198,
    0x3f9d28e279115e11, 0x3fe06c0c38331f4b,
    0x3fe57950213a663b, 0x3fe0090d98eb6ea8,
    0x3f97620d9bcf7e0c, 0xbfde01c3c135d519,
    0xbfe59a73b4fbf0f6, 0xbfe091022905aaf8,
    0x3fa0a0416b57b50c, 0x3fe139e1a69893fe,
    0x3fe820534e99ad03, 0x3fe05671a55e84c2,
    0xbf87e6f83c559551, 0xbfddfe860a2bbfb0,
    0xbfe8dcc222c54299, 0xbfe091421b79346a,
    0x3f7208f80417baaa, 0x3fe1d9801a59573f,
    0x3fe57c7aa29af2cd, 0x3fdfb0c5e22273c4,
    0x3fb3152bd8ee550d, 0xbfdc9ddcce6a1bef,
    0xbfe6a6807bb96fad, 0xbfdbf310ee2b3c6b,
    0x3f95fad2c2e167ba, 0x3fe2fdf6ba2caa6c,
    0x3fe5f2021e479d70, 0x3fde43dec443523a,
    0xbf79f5ab1cce4949, 0xbfdb8bacff994189,
    0xbfe7c6ddbeacd910, 0xbfdfcb75ac404af1,
    0x3f71d76f75ad8f45, 0x3fe03f28acba7394,
    0x3fe755cca4d292f7, 0x3fdbdeb0f1c2dc84,
    0xbfa03c21e670404e, 0xbfdcece3bb15821c,
    0xbfe5f5afa8da1384, 0xbfe1eee3c359c11c,
    0xbfb1abea0c653896, 0x3fe059f498470138,
    0x3fe7e56916a84fdf, 0x3fdb77a4dfcd8a70,
    0xbfaad06a91cbeb11, 0xbfe2d3bb4a0335ec,
    0xbfe50d52fdacf5b4, 0xbfd927ff836be19f,
    0x3f9c6230ce54b141, 0x3fe0f0d30134df80,
    0x3fe69f5d6c69f6e8, 0x3fe0b33e6027c506,
    0x3fa0bb178312198f, 0xbfe00b4bc2b47c81,
    0xbfe47ddcfde92979, 0xbfd89cbc28c93067,
    0x3f615e29e332dfbd, 0x3fdd88999fb4c6a8,
    0x3fe737ccc4ff1b2f, 0x3fdf48d7bb33927b,
    0x3fa77d07067d16ea, 0xbfde5992551968f8,
    0xbfe8847ff1ea7650, 0xbfdd7ed069650426,
    0x3fa9c54e90d38845, 0x3fdfe8f0744e5d0e,
    0x3fe7f5432ac48cc8, 0x3fe04fc4ebcb4e6d,
    0xbf7ab864fa8868ab, 0xbfdba207ba0fb1c1,
    0xbfe71faea55f55e9, 0xbfde9572b4b29ecc,
    0x3fac5a4cab785716, 0x3fddb2c212101c30,
    0x3fe7740de72ed581, 0x3fdb21306e6e0f31,
    0xbf8ab3f2ee4dc8c7, 0xbfdb429ab411bd08,
    0xbfe8d5203e31bd96, 0xbfe146d65cda9bc4,
    0xbfac296fa3955ee8, 0x3fe0abcadd13052e,
    0x3fe7a66cb10cf3d4, 0x3fe209253ad909af,
    0x3fa05982cd16c409, 0xbfdbe58a4b0bf2d5,
    0xbfe6c902b7fb6588, 0xbfdbb6794aa396ef,
    0x3f8464bafd44ffe5, 0x3fda99ebf46e409a,
    0x3fe92ca01bf16914, 0x3fdb376bedf29a37,
    0xbf969cfdbe0f0b95, 0xbfe0594a2622b7e3,
    0xbfe7515ca7080dbf, 0xbfe18ab60dd3a62a,
    0x3fb6d04130462886, 0x3fe12684087e41cc,
    0x3fe7fd6b7b3f4df6, 0x3fddbad5a971452d,
    0xbf757b63faa51b3a, 0xbfdd0a54b6850a3f,
    0xbfe65be25b86dafb, 0xbfda1441885ba261,
    0x3f8192031d3b6114, 0x3fdfb8a0920d0ca7,
    0x3fe8ef3bb1594299, 0x3fe076073cc830ec,
    0x3fa2a379e847a13a, 0xbfe02c116ee716b9,
    0xbfebb51af57d7ed4, 0xbfe071f2cab1952e,
    0xbf79b7497949aa03, 0x3fddbe05799f7878,
    0x3fe4c685e0cf4839, 0x3fe1db311267747c,
    0x3f8fbd673a89f500, 0xbfd7c4eb08f66fef,
    0xbfe6c75cc656811f, 0xbfdd2cd709dd648c,
    0x3f9da86864ca9e10, 0x3fdda3b5e7f742a0,
    0x3fe82a4bfe286806, 0x3fe088a362b2a8bb,
    0xbfbe34797d9f5e09, 0xbfdf1762d2ee7214,
    0xbfe470eb06b6beb8, 0xbfe1a6c31a7a93b1,
    0xbfa1ea2639787449, 0x3fdcc76042749dbe,
    0x3fe5df8ada2be99d, 0x3fd818be1f4d335f,
    0xbfc5d2c9b79a28ad, 0xbfe082da479cd15e,
    0xbfe79624fbc452dc, 0xbfe06e3471673dfc,
    0xbf9c462501c53aa4, 0x3fe032977c6ffbb5,
    0x3fe48d473b9f4c9b, 0x3fdd0cf3dce4eb84,
    0xbfaad931b3b99315, 0xbfdda66db6bad36a,
    0xbfe63f81d3d7b9d0, 0xbfe0286a0a6a8e3d,
    0xbfab660d92accce1, 0x3fe0aa28605aef03,
    0x3fe6b1f55dc51754, 0x3fe1c7cd16e99c62,
    0x3f9fc8146a752879, 0xbfdcefab167bf6d3,
    0xbfe61cb813c2f5a7, 0xbfe26f2eca2ee733,
    0x3fb5adda72b88edf, 0x3fe2b8c8e1d92476,
    0x3fe4e0a8a05ae0eb, 0x3fe268c8f2840192,
    0xbfa085c97d1c8a57, 0xbfdb3c84a76540ff,
    0xbfe6cb723c699000, 0xbfd9b1b9ca98038a,
    0xbf83191ccc211854, 0x3fde00e1f1da45d5,
    0x3fe5ff1c5dc60f89, 0x3fe158f4d3834d40,
    0x3f5abb06e1c6e8db, 0xbfdd9e0223365644,
    0xbfe4882c2724c9a3, 0xbfdf8e44cf1d2eb4,
    0x3fb91f66ebbb492e, 0x3fe2cb101fec3d64,
    0x3fe4644bbb646aa7, 0x3fe0244ad49ef2c1,
    0xbfae4a606b3e098c, 0xbfe12075687121db,
    0xbfe5e0aa0c75535c, 0xbfdd10038a7c1cc7,
    0xbfb3b221193d4488, 0x3fdc7989c8a1d948,
    0x3fe635728ab89771, 0x3fe12bba27e51b6c,
    0xbf8f30f8b10b80e1, 0xbfdf0984a700b83d,
    0xbfe53b76c0f2ee24, 0xbfe1144ce3f45d24,
    0x3fb3099e2f703843, 0x3fe3042055f753d1,
    0x3fe513e587dbccd8, 0x3fe031a3169625a6,
    0xbfa097311be9ca4a, 0xbfdbc99687c05da6,
    0xbfe4b64ac7141425, 0xbfdcba49d1c4b741,
    0x3fb45f99508187cc, 0x3fdb80a5d1140b9d,
    0x3fe5c5372bb7282b, 0x3fe024881be2bb5b,
    0xbfb98f3ada629eda, 0xbfe15746087c081a,
    0xbfe74526fd134dca, 0xbfe032690c89f51c,
    0x3fb17bbbedd9a028, 0x3fe2499c3efd61dc,
    0x3fe634df275cfa02, 0x3fe14b7acccc3dc0,
    0xbfb109a384bba025, 0xbfe0b3794ff91658,
    0xbfe490237887c046, 0xbfdcd4024afcd74a,
    0xbfac63b3c8de76a3, 0x3fde66bcedc55562,
    0x3fe76a21c20e9863, 0x3fdfc85a60a2a6f9,
    0xbf8f654ba257d3b0, 0xbfe0a85bd3834138,
    0xbfe5f4639ab3a2a2, 0xbfdfec61f68a1a6c,
    0x3f7c474b5f34e384, 0x3fdd1e12378e2792,
    0x3fe91e53f63ecef6, 0x3fdf1e7e0b8ee36b,
    0xbfa24bdb00e17f1f, 0xbfde22740508c4f9,
    0xbfe551a2d776aa33, 0xbfe06fbc1ebeac4e,
    0x3f933494dd38273c, 0x3fdf6016784fe30c,
    0x3fe553387302563b, 0x3fdcfc579dd9fede,
    0xbfac7790986e52a6, 0xbfdfbbe12b6e764e,
    0xbfe2165e1b0b6971, 0xbfe01ebe2d6516a5,
    0xbf8faba543a95083, 0x3fde8467653d54bf,
    0x3fe586dda8d88d51, 0x3fe14bae3dd36fc4,
    0x3f8711d47582222a, 0xbfe1f84082459f86,
    0xbfe615a6ee01477d, 0xbfdc31ec5fabfaba
    };

static const uint64_t in_rifft_noisy_1024[1025] = {
    0x3ff654f627f9c034, 0xc00d0e91104aa6a6,
    0x3ffa74b3b71806a8, 0xbfdd3925c4b06a2b,
    0xbff0169c9deec3c4, 0x3feac565e960fa9d,
    0xbfe4c343702ff054, 0x3fa67a79bc9cf764,
    0x3fe8770854d5ff1a, 0xbfd553eece5be5e8,
    0x3fbc67431e9e32dc, 0x3fe540c44e264c6c,
    0x3ffe32d6f1fc1204, 0x3fe21360ec93563a,
    0xbfd95df2f5695966, 0x3fe27bb461f8c713,
    0xbff0b2a9873df300, 0xbff6fd27dfb965ee,
    0xbff96904e0706a89, 0x3fe7da13d486c984,
    0xbfebe60553366c1b, 0xbfb82e952f16c168,
    0x3fe5099f2c4ad380, 0xbfdeadc42c9e72c3,
    0x3ff13304ef9ef442, 0xbffedad84b42ca1e,
    0xbfdfd48a065a373e, 0xbf93715228411510,
    0x3ff8fc3bbe8b65da, 0xbfcdf209f87e0082,
    0x3fd652b9ffe08c04, 0x3fd6a722e768240c,
    0xbfb4809dcbc3e250, 0x3ff485361022b502,
    0xbfe9555e3b152ff1, 0x3fc993ec5cfacc44,
    0xbfe44d51ee93f14a, 0x40047f7c6f7250e3,
    0x3fb0f6e90bee072e, 0x3fe3c3409e4a0c33,
    0x3fdbdaceba15401f, 0x3fcf8fdd3ddbe026,
    0x3fc5cc141986a806, 0xbfde72db401f87b0,
    0x3ff643e770c705b8, 0xc00a199f05fe0a2e,
    0x400fcee81948bcaa, 0xbfd9399a4bb38dd7,
    0xbfe4754f22374da2, 0xbfba8e98dba325d0,
    0x3fee9ca93139c118, 0x3fd411b4c00ab4f3,
    0xbff4297d549baf22, 0xbffa14ac7b8a683b,
    0x3fe8548954eb9b46, 0x3ff15a7eee41800c,
    0xc0084c2a54361252, 0x3fe865acd20c73ce,
    0x3ff86be22b9f97a1, 0x3ff594a423910160,
    0xbfebc62645f375bc, 0x3ff3d713c42ba8c4,
    0xbf8e185e8665ca00, 0xc0004b2bd2c9e670,
    0x3ff84b2cd2b69ab0, 0xc006ccf0ae51fcd0,
    0x3fb2e60eb5de53a0, 0xbfb9e561fa99b46c,
    0xbfe628d8d09b8275, 0xbfe5d37a75aeb91e,
    0x3ffed84c4b885270, 0xbfe128f8803f34e9,
    0xbfe5ca42c642b88e, 0xbfe0fffb456bb3f4,
    0xbff910a79d419d60, 0x3ff44acb3350645a,
    0xbff0a6ae33748e5c, 0xbfe8146a049ad4b8,
    0x4003b197753da384, 0x3ffa65d60ac2bf26,
    0xbfda43cd33c91557, 0xbfdb46aaa64a5a89,
    0xbfea4db258e37d84, 0x3fe331f2d44757b9,
    0x3ffa01eadc57866f, 0xbff48c2f15c51158,
    0x3fda47c52599e575, 0xbfe120e1bf8e9df5,
    0x3ffc1f8773fa1302, 0x400254eb58fa2874,
    0xbfeadbd837f2b84e, 0x3fcf6f290e953716,
    0xbfd4bdb6f674ddd6, 0x3fe029f2d8fc0352,
    0xbff6cbace4ace090, 0xbfecd4c33068bc94,
    0x3fe71ef0d6fc1933, 0x3fefa4694968c408,
    0xbffd641ff04b5bde, 0xbfed878037f57df4,
    0xbfe87147ef4fe5ac, 0xbffad3899e5f23f2,
    0xbf9bf8c184b2d2d0, 0xbfeec01107ba1324,
    0x3fe84e4f0f59b42c, 0x3feca3901a800f5c,
    0x3ffe8d064c901160, 0x3fce60f9a1e8a5f4,
    0x400032d13f1c7fca, 0x3fe4720fcddfa14c,
    0x3feb2559f74e325e, 0xbff601ae08527b34,
    0xbffa06b5cb4aeeb4, 0xbfec32b7e2eaa80b,
    0x3fcf77081988fa3c, 0xbfc8ddd31abd10d8,
    0x3fd4ce1151df2f18, 0xbff49f4384026555,
    0x3fd8c55b078352ca, 0xbfe86bb743ba1b8d,
    0x3ffc356c9e309bb2, 0x3ff21d5b0c041c81,
    0xbfe007f27d85c336, 0x40082b6eaaf9322a,
    0xbfe7c2684cbc78b8, 0xbfa491c9d61257b4,
    0xbff67151b7f1fea2, 0x3febf2e51eaa75ee,
    0x3fc08e22839cb380, 0x3fe4642544e73000,
    0xbfefdc5da59bb6c4, 0xbffdab34b59db554,
    0x3fe61230916a9b26, 0xbff5b6987d81d0b7,
    0x3f8c48bef4c6f9c0, 0x3ff2efaf7a7602d1,
    0xbfe96aa3b4393ac4, 0x3fe64fa1e7966efe,
    0xbff189d7f1125762, 0xbffb1fe360fb1cc8,
    0xbfe7cc3564d2ed66, 0x3ff2928db3a5d6a8,
    0x3feb319fd62533b2, 0xbfd469d2183f4bd4,
    0x3fe8431dc9e4c8bb, 0x3ff0629b2014f33f,
    0xbff75ea00d36767e, 0xbfce342e84399460,
    0x3ff15c853f3267c8, 0xbffa85c1ec9259d1,
    0x3fd4039ddc16f09c, 0x3fe919d8758bbc94,
    0xbff13d601fb42936, 0x3fcac420153d5ad3,
    0x3fd6f99a3f5f227c, 0xbfd63f527088a8e9,
    0xbfd207a1b02e7ad2, 0xbfc74b4b4c2afc7c,
    0x3fea3e3c1bb60351, 0xbfde6d53fa8a974c,
    0x4002ffe4b162ca2c, 0xbfe73945fbcff8ba,
    0xc0034902e4753d56, 0xbff9434c95c2d410,
    0x3fff290d25e3e448, 0xbfd2acb9bafdaf02,
    0x3fdb17a437e1bfe1, 0xbfde9c84e39325cc,
    0xbfe95b6b95713805, 0xc00800e94dae42d2,
    0x3fd05319d9aab504, 0x3ff80e16f09a98fc,
    0x3fea57166140aeda, 0x3ff8ab5fe85168b2,
    0xbfea5a9477b59ade, 0xbfe44438dd808bb1,
    0xbfd266a36400c2c1, 0x3fd0d5a114efdff2,
    0x3fd422a07b44f505, 0x3fd470a43862f12c,
    0xbfe02b8a846ac0fe, 0xbff3c37322c2a812,
    0xbff84e7f48317bf4, 0x3fdaa461e0f4b8fc,
    0x400135b3c5df9656, 0x3ff46ce544fd2376,
    0xbff4cee0f0ee79d7, 0xbfd33645d0123032,
    0x3fb82867e5d04b30, 0x3fe2508bc4b32534,
    0x3fec7c01d919a49f, 0xbff833e5e3fbe688,
    0xc00a95357f02473d, 0xc0041be5d6ecac9e,
    0x3fef96a027bbedf5, 0xbfdd3edca95d1910,
    0x3fe2493ec762807c, 0xc001200c18b1958b,
    0x3ff56864970db360, 0xbff20cecaf5cf41c,
    0x3fa3ad5cd8d13718, 0xbfae547451ffa8d0,
    0x3fee6654a7375c66, 0x3fbef6f8b37386b0,
    0xc003791b81db60dc, 0x3fe39aa1234c8ebf,
    0x3fe4eae9a981f0e9, 0x3ff05e6f5c962ab1,
    0xbfe00d240a71dbbf, 0xbfdbb598771f78e6,
    0xbfd16e84ab6cdab2, 0xbfea318e59f73cef,
    0xbfc48b3ec008f0a8, 0xbff1e221c1ffc49e,
    0x3fe717ecb5be043a, 0x3ff33fc57c42248e,
    0x3ff503806db0a7f1, 0x3ff80c4765283310,
    0xbfdc15258f8c85bb, 0x3fc80429e47fce08,
    0x3feeec477db6ce4c, 0x3ff030792a574f24,
    0x3ff217d1be07a07e, 0x3fea54875d0f4010,
    0xbfe2b780d2bfcff2, 0x3fbfc371ddf25992,
    0xbfe00a56870c5ea4, 0x3fb3eb57adc5b520,
    0x3fdb8768867b58d7, 0x3ff31cef7e4e5462,
    0xbff894622bda6f0b, 0xbfe8aabbb7fb193c,
    0x3f84c237d6320d40, 0x3ffe6fd66f5c056e,
    0x40020e16329bf5c8, 0xbfe6a1bb11f90ef8,
    0xbff587df9a6ffa47, 0x3fd191917c3da19e,
    0xc0002a6c5ac8b530, 0x3fc53f4411bb597a,
    0x3fef88f535755c3b, 0x3ff7de439f4d2260,
    0x3ffb577e5fc84a1c, 0xbfc8f34dc4437676,
    0x3fd02be2aab5cca9, 0xc0001506d34e1a34,
    0x3fff5f303ccd174a, 0xbff1b12d6142b1a4,
    0xbfd30fb5cc4f7d2c, 0xbfeed47558684664,
    0x3fc46e11ac34f3a6, 0xbfd31fc3a7634c9c,
    0xbfccc64770379288, 0xbfdbe9800dc7fc64,
    0x3fedae235b31fba4, 0x3fc35ec19f45cd88,
    0x3ff6a9186454c6c6, 0xc0765a4be82bf96a,
    0x3fcce348da9fcf68, 0xbffba089ff1e6f56,
    0x3fba6b95936bcd48, 0x3ff0901600729558,
    0xc0011c21449e8c16, 0x40050873c43ec51c,
    0x3fc69a14112ec858, 0x3fe8ea3aa18a15a6,
    0x3ff2f16f5b7b43e2, 0x3fa201e197c579b0,
    0xbfe88706e580e2e9, 0x4001f51254e77eb0,
    0xbfda5a6f976b0cbf, 0xbfe36c28fd18d011,
    0xbfd8d428e78ea0a0, 0x3fc50890c35fd990,
    0x3fccecae0c5654da, 0x3ff5151ce06799c2,
    0x3fe1f8472aae49af, 0xbfbf1a02c865e708,
    0x3feb34bba320fbc8, 0x3fffb781bd8305b8,
    0x3fe802b47b20e3c8, 0xbfd7e033674f8800,
    0xbffa5e6b41a97fae, 0xbff4e05a8fafa85f,
    0xbfe1333816afbfa2, 0xbfe53ed6930fa412,
    0x3ff8937fd8e69a43, 0x3fd6e5f369833a2d,
    0xbfd0d7276322acbf, 0x3fa45508b575fdfe,
    0x3fefe0fec8182050, 0xbfebb10c5d7eabae,
    0xbfd4ea67b3a1ee05, 0xbfd8a35fc0ce1b4a,
    0xbff5e1b6371a9bc6, 0xbfe38a24a9dca043,
    0xbfe65cddd57f08c6, 0x3fe74bbb97f130ab,
    0xbfd528a9863facea, 0xbfe01e6c9fcd4af0,
    0xbfcf4636f88583b6, 0x40011c5396f36d99,
    0x3fe6786c6d522b96, 0x3fd5526e104d8182,
    0x3fefb4ad6b5903f6, 0xbff1ef43456944c3,
    0xbfa9046268636110, 0xbfde20ab4e4d2d52,
    0xbfedf8886acbe773, 0xc000334415442e92,
    0x3ff01140ad3df06a, 0x3fe654a46e64e8b8,
    0x3ff16192fe318f45, 0x3ff585136ae1006c,
    0xbfaefa07c1e8e910, 0xbff0bf98e431441c,
    0x3ff45fdeb1e400f0, 0x3fc2cce91627e850,
    0xbff7cae3d668be3a, 0xbfb8f6bfa1a8894a,
    0xc002ff542d2cfaf5, 0xbffc05cf1bc584f0,
    0xbfe8bd0931ed301e, 0x3ff9988150a62ed6,
    0xbff4677168b0bc51, 0x3ff8a7ef2a3ac382,
    0x3ffa7d99e395ae82, 0xbffb73ed97f77bba,
    0x3ff3a8e38eecb628, 0xbfebd8e43e9f58c8,
    0x3fece8cf536e75fc, 0xbfd479be85c12b66,
    0x3ff5b7fd3f98d450, 0xbff0b40a1379e5fd,
    0xbff7a1aa1fb88f9e, 0xbfe44498f1dc7dd2,
    0xbfd3f6bca3835a8f, 0xbff49b92be15f520,
    0xbff10ccbae3c3c43, 0xbfec0077a1aeb7fd,
    0x3fbc5bc82c60a910, 0xbffce4a543e98864,
    0xc0017bf599bb68d1, 0x3fc7ab798b480be0,
    0x3fe7f2fe4469ff5c, 0x3fa2088975ee98f0,
    0xc0037edc4c2b9335, 0x3fe3df7a33751cdc,
    0xbfedaa56a8dc2f5c, 0xc0075d6468447f8f,
    0xbfdff89037c339b4, 0xbfe27e5c45007c3d,
    0x3fc47b7551f8acf9, 0x3ffc954f56571752,
    0xbfe13d5a85e99770, 0x3fdceda0362f3cba,
    0x3fe6e89edeb5e5da, 0x4000be402155dbb5,
    0x3fe504dbfde542bd, 0xbfedfd78726763ea,
    0x3fc756aa2b9753fc, 0x3fce74037c6586e8,
    0x3fde19c901947d5c, 0xbfc4f33d0ffc94d4,
    0x3ffd89cf329ff208, 0xbfff00bf90a27499,
    0xbfb6cf5ac072636c, 0xbff5e7da49cf98c2,
    0x3ff0f980edcdab00, 0xbfd69ac3a52a5b98,
    0xbfbde8dbb19a9860, 0xc004b4a31338e0a2,
    0x3fefebc46b43d352, 0xbfe111947273a718,
    0xbfb6fbf6f2756338, 0x3f7ae076cd2c6900,
    0x3fe0419764545586, 0x401003ddd6c644d6,
    0x3ff65c3deb8570c1, 0x3fe8666e15bd676f,
    0x3ff5ce65eca8f33f, 0x3fe2cb1ad00470b1,
    0xbff3ea77d1bf249e, 0x3fc46329cb221630,
    0x3ff15a9dee503226, 0xbfd1a1ef4c3908e6,
    0x3fe64844f0a69619, 0x3ff0021ee35ce7cf,
    0xbfff725253020c09, 0xbfca6193a28db700,
    0xbfe7c014a91e7a38, 0x3fc0892a4a96333e,
    0x3fe83bd1e0de4724, 0xbfe868d8be4ad3d8,
    0x3ff2cec88a1868b9, 0xbfde57d81d178b96,
    0xbfe655ff6f91b2b5, 0xc0062285be0f8e74,
    0x3ff2dc7a9efe6e29, 0xc0045edac1dfc0ba,
    0x3f7ea141345b32a0, 0xc003dcfebd203c0f,
    0x3f9417789d5815f8, 0x3fbe4aa250a21498,
    0xbfe9b7f56c53225c, 0x4002d0177d5487c4,
    0x3fec28ed1204a522, 0xbfef1c956834935d,
    0x3fdddd6d6db02bf2, 0x3ff211ccf975bd3f,
    0xbfe34345fc4eb4af, 0x3fc5913aeb753518,
    0x3fe2a46c0d637e42, 0xc000a4cae0c78863,
    0x40024986ca6e2738, 0xbfe0c75870e5610c,
    0xbff034697f6f5479, 0x3fe7d8f80f5f5768,
    0xbfdd5e72ea81750c, 0xbfaf2a3f7a6df694,
    0xbfe0e065bf13e690, 0x3fe5d659b2c2f364,
    0x3fc002b2788636e2, 0x3ff2a542d597f684,
    0xbfebdd65b5a22b50, 0xbff2f4c8e574ca46,
    0xbfe540013bd03b7d, 0x3fe35e0cfc721ef2,
    0x3ff90f94282cc4c6, 0xbfb91fca274f5984,
    0x3fe8610fb516d4ed, 0xbfd4e84b1086d348,
    0xbfda01d2dee4006e, 0x3fee27587022ae48,
    0xbfc7c33884769458, 0xbfcae33834a22057,
    0x3fe240a48cb96f84, 0x3fe70216f6bcec2f,
    0xbfe6accab8a7e218, 0x3ff36f228b8ab57d,
    0xbff962752b66b094, 0xbfd5c02657bd235c,
    0xbfb87d0b24d31800, 0x3f87ff36c42526b0,
    0x3fd4e98f5570bebc, 0xbfe10d699e2ad6fe,
    0x3ff0b87d95d4b4cb, 0x3ffecee10fbb9b37,
    0xbfe1f127e36df6d8, 0x3ff92a04665b31a6,
    0xbfe300900819a873, 0xbfe523159b5c33d8,
    0x3fd12a1d53c6c548, 0x3fed9a5ff2892f2b,
    0x3ff0bfc3d3c05be4, 0xbfdb99df14feadca,
    0xbff0f4470105884e, 0x3fe10fbf16688d99,
    0xbffaad45455d0d7a, 0x3ff87a21b736cc63,
    0xbfc50294be9b7ab8, 0xbfe0233916bd492e,
    0xbfe6c0ef4ac46679, 0x3ff326c12d801852,
    0x4005c85d46784ae6, 0xbfe5a4b4085619ee,
    0x3fd321951103d784, 0x3fe64bde38f409fb,
    0x3fff9b91f546eef0, 0x3fefe67328cad537,
    0xbff119c883bed6b0, 0x3ff30a480c58c008,
    0x3fe4f0203d199746, 0x3fd216b9d07d06c3,
    0xbff6c30cb1bce58f, 0xc011c78ac290cc6a,
    0x3feff57b4caab14c, 0x3ff757df8bbdb9af,
    0x3fe46a25675a782e, 0x3fdf276e83917dc3,
    0xbfaebb46d4a79100, 0x3f964c78e4d0fea0,
    0xbff44b5d933b9112, 0xbfdafe95ac35c23e,
    0xbff5a87dc48a7bff, 0x3fc799deed698eef,
    0x3fbcd82cbf3919e0, 0x3ff25bbf4394e87e,
    0x40083ad26455588e, 0x4008950e3d52948a,
    0xbfffd5b57592e14a, 0x3fe462208ad86b8b,
    0x3feba7a8795af634, 0xbfe55ec309baa0cf,
    0xbfbb5b7a409fe946, 0xbff670a082066318,
    0x3fe49857400c04ca, 0x3ffcd487c64b2d64,
    0x3ff1deb81b4ec198, 0xbfd468c1a2faf987,
    0xbff0499b7e1fdf37, 0xbfe5367737e5abed,
    0x3fd068d1eef1c94a, 0xbfd1b36ee67888e5,
    0xbfd881a40ee68d32, 0xbfe2240a6969f311,
    0xbff8001d36ac0ede, 0x3ff259054b2df31b,
    0xc005e1b87d87c0c9, 0x3fdaed83d3b5ae3e,
    0xbfe58ef0d44b5e58, 0xbfcebfe4e3cc4d42,
    0xbff63bff9d503f0c, 0x3ff5143f229f13c0,
    0xbff0b3204bf8be27, 0xbfd0164c9e71e6bf,
    0x3fe7c1d2e282fdc3, 0x3fdb4d93a0490a00,
    0xbff3a98fd579ed2c, 0x3feab69136b5d62a,
    0xbfef8b3a0bee155d, 0xbff227a3cdf6a6de,
    0xbff39b83154bb7a2, 0x3ff2d295115bed54,
    0xbfc1c535eed7f8c8, 0x40013bc794bd252f,
    0xbfed355f9c5f3127, 0xbfcede9043955ed2,
    0x3fe4202801bad9ae, 0x3ff304b6fd59c88c,
    0xbfd82ffddb03253c, 0xbfc753c75d385a10,
    0x3fdf76a8302a7969, 0xbfecd971b75f6c8f,
    0x3fe9938c705bb44b, 0xbff61733428d8630,
    0xbff7600f6dcac75b, 0xbfea20c1033d5466,
    0x3fe5b5a3e99d6309, 0xbfd7f4490b44e97a,
    0x3ff414002a9bc269, 0xbfd3f0cd8098e3e4,
    0xbfd5d27a88386d6a, 0x3ff2a8c5e301343e,
    0x3ffe806fecdbe1f2, 0x3fe8c84df48b82fb,
    0x3fed8fa2a121b1b6, 0x3fd36adab9373ed9,
    0xc00152b4ad904f98, 0xbfea8abdef4f3a46,
    0x3fef013fe274e8d1, 0xbfe6482b8f2bffd0,
    0xbfd5b11e706f11cf, 0xbfb12b341802ee45,
    0x3ff0d9f64888476e, 0xc003062cf81227e1,
    0x3fd1b89eed679210, 0xbfb2d69bb56439e8,
    0x40009d60a0311f82, 0xbff598b2b3289b40,
    0xbff4cea1fe74a1d4, 0xbfda3f81bcafc464,
    0xbfd9ae6935d67ec6, 0x4000d82f1965f1c8,
    0x4003afd74f456b9e, 0x4006dbd7604aaf62,
    0xbff18c81916b3ec6, 0xbfee65fdd0c1df52,
    0xbff0c794017de5f8, 0xbff16b3922a21770,
    0xbfe7e096c147d317, 0x3ff8c5b7275112c2,
    0xbff5fd21e65c8d66, 0xbfd6a140f6f39246,
    0xbfc821c656318b14, 0xbfbcc1c3d777cf14,
    0x3fd87f1f48e1a37c, 0x4000b56a205944fb,
    0x3fd2a285b1d069d5, 0xbfd42640bd26128c,
    0x3ff7336fb540672d, 0x3ff3626cc47e0c78,
    0xc0034bda027e170c, 0xbfd19f02c11adca4,
    0xbff026ccb2c98e08, 0xbfeb5ec0dad3bdea,
    0x3ff07fb780bfa61b, 0xbfc551058e010e68,
    0x3fdcf209133bc269, 0xbfc09068091a7d94,
    0xbff32f7d373b738e, 0x3fcc0f4702b30bff,
    0x3ff949ace48ddc24, 0x3fb0c636177da1b0,
    0x3fed86c36ffec033, 0xbfe985214f719558,
    0xbfea9479d93b477b, 0xbfe329a65755d6c2,
    0xbfe35fc045f8cf4f, 0x3fdcb0e8cae6b868,
    0xbff031bb70dd3747, 0x3fe799305f1c3fb0,
    0x3fe5395c36ecc4c6, 0xbfe241f2b6569234,
    0x3fe1e798f575e5da, 0xbfe0ed634dae4458,
    0xbff65bceac915c84, 0x3fe15b6eacdee6df,
    0xbfeb8e3fe1dd27d0, 0xbff81faa61beb28e,
    0xbfe08f617ec06360, 0x400436aca95abb05,
    0x3fd0c60556498205, 0x3fea59df0235ad6d,
    0xbfece5004cab3015, 0xbfea1f06dd3721e6,
    0xbf94dd44537637e0, 0x3fe17f8de43a47ca,
    0xc000c15a2f619d16, 0x3ff767e834ee082e,
    0xbffb20ade92b8e9a, 0x3fa1d127582c6060,
    0x3fd25f444aa0831a, 0x3ff2018693788c24,
    0x3fa1d2fabe4e378c, 0xc0000865b88d9b65,
    0x3fef0944c5410c26, 0x3fe1acd9a78c368f,
    0x4000b68cbe6d8d15, 0xbfd11928607c6a20,
    0x40028618ffe8061a, 0xbfc22b17903f0654,
    0x3feb510f31815214, 0xbfdefd2d2b6a06a0,
    0xbffb03bb679bbde6, 0xbf94ec5529011c10,
    0xc00071b92e183954, 0x40050e2421b6b026,
    0x3feaa8d56d383165, 0x3fe345038dcd7f9a,
    0x3fd882a4b0973d4a, 0x3feefa6146dcbab1,
    0xbfd2639472de9328, 0x3ff839b5bb662e69,
    0xbfd6ad544cdc2e4c, 0x3ff58a84c96e49fe,
    0x3fe65078e27c37f2, 0x3fe756524af68ba7,
    0x3fe54dc626cecdea, 0xbff6e2561ecadf71,
    0x3ff78725d0e2921a, 0xbffae9666bdfeb3d,
    0xbffba8468213da07, 0xc00121555f4fe320,
    0xbff372a1c045befc, 0xbffc745b71050f04,
    0x3ff3a42eac355724, 0xbfe06ea40a7ae6b0,
    0xbfe2fd9600fcc966, 0x40003bb8fce5461f,
    0x3ff17acc2c7f60c2, 0xbff7c66c9de4a78f,
    0xbfe5c1e0093b1ebe, 0xbfea7f35f2ee691b,
    0x3fe654b35a069a7d, 0x3ff1e57b89b31284,
    0xc0011cfb8b23f926, 0xbfc7cacc88d3b492,
    0x3fbca94dce8ce8f0, 0x3fc07dff3617428c,
    0x3ff0480b8faeed73, 0x3fdb83b8fc45a646,
    0xbfd19cb74803d29c, 0x3ff1482160d838d8,
    0xc00001978c5244a2, 0x40006ebad3ad7e3f,
    0x3fe8ccc022464850, 0xbfe3a1bfcdf9acac,
    0x3fefaef30cb65c94, 0x3ff1e647052b756c,
    0x3fe50760913b291c, 0x3ff4f66298a75072,
    0xbfe08d39bacee5c3, 0xc00031b97fe671a3,
    0x3ffb1dc3bba494fa, 0x3fe67b9098b2e423,
    0xc001993c44950eb8, 0x3fc708cbb3572bb4,
    0x3ff400874d480a00, 0x40015d19fbf352c4,
    0xbfef0e54561db9d5, 0x3ff38d12afbb9678,
    0xbffb41e74494470c, 0x3fe08a6ac2ae995a,
    0x3fd07b0eabb5cf44, 0xbff3a9b75256bf1a,
    0x3feb9d02dc79eb53, 0x3ffc0b03ae2558de,
    0xbfce0b6db0c26d28, 0xbfefeca5643d5f1c,
    0xbf98f7e217f1f1c0, 0xbfa7be458cdad8f0,
    0xbffac3021214a285, 0x3f87fd8e6a27dbc0,
    0xbfe5c7c1917b6de4, 0xbfa6ba72954b7cf0,
    0xbff1ddd393f42586, 0x3fdde08f115cd8a6,
    0xbfd805db8e0a0ff4, 0xbff5d5c53df012d6,
    0x3fe28a25ec5ff98f, 0xbfd4c9f21bc39786,
    0xbff12f29e82617a1, 0xbfe1cf8cfec4f179,
    0xbfd36be43b0ca5dc, 0xbff9807dc7abad30,
    0xbfed4e20556eb2bd, 0xc0064bd6982bda52,
    0x3fe510e0878aef99, 0x3fec3c8e85af7717,
    0x3fcdceaf881355c0, 0x3ff3663517dc79cd,
    0xbfe9d6c9afb8e15a, 0xbffaf03f8b2f0230,
    0xbff0b786dca1cb0c, 0xbfe38f6e53be5037,
    0xbff4247e510bdaac, 0x3fd4f402316a5df5,
    0x3fe779d77f72e18e, 0x3fd1f0bb0b119a8e,
    0x3feef09360fa10a4, 0xbff190756ee312f6,
    0x3fb0e39b14125f04, 0xbfd58e242915c6c6,
    0x3f947f205875a800, 0xbfc3f8056ae3ed9a,
    0xbfe2efcdd4a46352, 0x3fbc61daf6a666c3,
    0xbfe157fc88697c22, 0xbfd7fa18a68c1f07,
    0x3fd91cf3cfaf2e2e, 0xbfea06ad01a6bc7c,
    0xbff509bc1d7f0ec8, 0x3fd98f38ba50e47c,
    0x3ff7ae56f1e55190, 0xbff5b712b03cef4f,
    0xbfe6ae3373430728, 0xbff3eb0da52eed36,
    0xbff81daf7a6ad912, 0xbff6f427409e94fc,
    0x3fdbe277286df31f, 0xbff5fdf8e0ed1176,
    0xbff4aaad8ec00d2b, 0x3fede9790b4a516a,
    0x3fde5d09eb428e8f, 0x3ff8534833a04974,
    0xbfe734e8491cecfb, 0x3ff43a665ef05395,
    0xc00ac7fb9087f063, 0xbff73a166c599702,
    0xbffda2175df810c9, 0xbfec46433991fb16,
    0xbff9f8bda50f8bce, 0xc00d8aaae49de300,
    0x3ff7bfc246a317ca, 0x3ff5f4087ab2e11a,
    0x4001b612118a1a1a, 0xbfeea6028605ac75,
    0x3ff8546f98a2ac7a, 0xbff74903ab872380,
    0xbfed1b4ed795de46, 0x4004a78675209af0,
    0x3f935db5c4292040, 0xbffe7cb4d292bfd1,
    0xbfe7550d709ea346, 0xbfd7086297cacef4,
    0x3fbcb42e8cba5188, 0x3fc9b32c5f8c790e,
    0x3fe46476cff86055, 0x3ff7ae1e909a2528,
    0xbfe21850592b6b04, 0x3fedc6a57eb03e28,
    0x3fe0e5b09d1558d1, 0x3fe81f926e999f9e,
    0xbfec0a0ad2738aff, 0x3ff93ed1bb7a6b94,
    0xbff20f3452163cf9, 0x3fc3cab2991b151a,
    0x3fe3c00ff58bb7a2, 0x3ffa98069d8b257a,
    0xbfeac257eaec6da2, 0xbff696cb70afa658,
    0x3fee839453344fd7, 0x3ff3002e1cadf46a,
    0x3ffaf30edbe398d1, 0xbfedf848882024ec,
    0x3fd1953578b146b3, 0xbfe664458b86e2f2,
    0xbff6bb08775dd120, 0xc003f9319b9ed91f,
    0xbff3b11aefb54ce0, 0x3fdc56f2459a467a,
    0x3fccabc30641ad3e, 0xbfdbe1231be47b58,
    0x3ffd146761371ae2, 0xbff0e5f10e6de76c,
    0xbff1dbeb96ba5bf4, 0xbfd20893a8d2dc88,
    0xbfed3e6e1b3c1686, 0xbff100f9a2bc9d22,
    0xbfe7c91eabcf405a, 0x3fa611fec7933cf0,
    0xbfae111089ddbdc0, 0xbfc6ca7b9c64adb0,
    0xc0001fedfe9fc89e, 0x3fe2c5ae0cb56f97,
    0x3ff261d3d7a4de98, 0xbfe3ea695c0d56a9,
    0x3fed96839beedaaf, 0x4007f47bf443b174,
    0xbfa073eceda88720, 0x3fc11221d3245f6b,
    0x3fee885d8880a924, 0xbff33c9a169dceda,
    0x3fd2a5581858602b, 0x3ff8a40d663f0fb8,
    0xbfc843e2d06943ec, 0xbfe8a42b91388147,
    0xc00658ac1887e01f, 0x3fe08e2127d5fc25,
    0x3fe12bad76dcf3db, 0x3ff72381d527c1f6,
    0x3fe4a12ad1d27d8c, 0x3fde2d3ad9f082cc,
    0xbff99f05222162f6, 0xbfff6871dc78da2a,
    0x3fe8b26a64121136, 0xbff34860521faed5,
    0x3fb52b6a19dad060, 0x3fe5942e43afc0d3,
    0x3fbd1d60d70e3c60, 0x3fe5b499afa4ee9d,
    0x3fe0688a15f2779d, 0x3ff82ed666e8435c,
    0xbfc30350fa491160, 0xbfcc3685e4b544c4,
    0x3ff497b05b72d46e, 0x3ff3a7d3bc7696e2,
    0x3feed627c0f50a90, 0x3fe0e8116577a06f,
    0x3fe7d82a1c6c428a, 0xbfc905a0136a69bc,
    0xbfcdea2d2fabe5c0, 0xbff889d2e8dc62ec,
    0xbfe91f3f0ee7e772, 0xbfea73d7b05298e3,
    0x3fe85857313f0a59, 0x3ffc699e9ccd159c,
    0x3fdb4a347a6ff23d, 0x3fee75d2ae6110fa,
    0x3ffaaf91c6e09a92, 0xbffc29dc0d200e04,
    0xbfca3724890e98a8, 0xbfd682c1a2c3ebb2,
    0xbfda5c231fc7eba8, 0x3ff617187bff905f,
    0x3fe8b4a900710a8b, 0xbfc4d5b907c7ada0,
    0x3ff5227c0a8822c2, 0xbff49c0aa58cd638,
    0xbff1470cb52a2c30, 0xbfc6c8e37514cbae,
    0xc003ed6c20dc8092, 0xbfc0d1f167598c75,
    0xc007da804e3e119e, 0xbfda92414720b42b,
    0x3ff1f58d32dbb05a, 0x3febc1fc151df862,
    0x3fce253410f394fc, 0x4004d8ba39f0652e,
    0xbfdf6b6574c93192, 0xc00321f4fecd008c,
    0xbfcb72c195691c0a, 0xbffc68e948ebc5cf,
    0x3ff318dfdef933a4, 0xbfdbd9bb8521a55e,
    0xbfeaf3b2f9695a4d, 0x3fc4ef7123103b00,
    0x3fe77dbc0eeeeec0, 0xbfdde9c9a597b46d,
    0xbff3f0221bd00de0, 0x3feae32cf835f9be,
    0xbfb82112a8606ad4, 0x3ff811fcfcb6bb19,
    0x3fed3eeeb28141d6, 0x3fed616b6ad7b5b8,
    0xc0068d73a9eae596, 0xbfef2b2e3e400fcc,
    0x3fc1f88940e7784c, 0x3feaeb2053994160,
    0x3fa18e8ef59589a8, 0xbfbd720e392c85da,
    0xbff34ccddd809f0f, 0x3febe293a09f9a1a,
    0xbff560d3f3ccd06a, 0x3ff2146be79029c3,
    0x3fdbd455d63a858a, 0xbf712553ea7e2b80,
    0xc005c437d575ed8f, 0x3fb3c95962302d10,
    0x3ff83ddc1f8a3e02, 0xbffe20efd8859fdf,
    0xbfdc43b5ccccdb50, 0xbfb12591bae13018,
    0xbfdb2092a273313c, 0x3faead240343d3b0,
    0x3fd426c970ef2fe0, 0x3ffb9268ee28d774,
    0xbfcc70c496243c60, 0x3fe4060858173bfb,
    0x3fa7a53f6b0879f8, 0x3ff5759e98261840,
    0x3fdfc9f8356decdb, 0x3fef1dcfa86b5a18,
    0xbfb4782542efed74, 0xc003a9768de8ed9f,
    0xbff330a0b161283a, 0xbff4d365ebc5de46,
    0xbfddeec3b41a1f32, 0x4004384eaedd5376,
    0xbfbcb0f6c9e6c518, 0xbffdfe28f3e9b64e,
    0x3fd34156d3f0a06e, 0x3fc1af01ad299c4e,
    0x3fd846ac0f1fd205, 0x3fea41f1b492cce8,
    0x3fe9d5c6f4fefd5c, 0xbfca5aad921e2fe8,
    0xbfc0a26bceb4a0c6, 0xbfeafe64de4d1625,
    0x3ff3cc731fd75d19, 0x3fd72a7fe45ec5fc,
    0xbfefbe29b75c94ec, 0x3ff5a86f51cf4f60,
    0xbff41693f693ad1f, 0x3fe1c3b010aafd52,
    0x3fd83eafa8552880, 0x3ff2409424717aa6,
    0x3fb7ff1ffe547f6c, 0x3ff09a584a80be6a,
    0x3fe0ba90463265a7, 0xbfdde378dbf6ddae,
    0x3fd0f223e191eb07, 0xbfeb27ecf93ad058,
    0x3ffa0fc3fdff4c18, 0x3fdec16589a3d44e,
    0xbfcc7070ac38f66c, 0x4001c37dee6ab330,
    0xbfe8a24162cf45f5, 0x3fd88be25791e3e5,
    0x3ff06714044deef8, 0xbfeb6f3b29f16868,
    0xbffcb1d97750c3f8, 0xbff6b980505dc23c,
    0xbfe3a940b2052588, 0x3ff4213bfb4734c4,
    0x3fe94ffaba45b496, 0x3ff8a92ebc0e982c,
    0x3fe0bd48471d6a86, 0x3fa3fa3d72f900b8,
    0x3ffa41dc0480a73d, 0xbff5eff7c91fb6dc,
    0xbfe8490bc7d84973, 0x400171dfeb7e5c2a,
    0x3feaa04d4e0c82ec, 0xbfccf16825a5fbee,
    0xc000c0b331056e3a, 0xbffda507ee6da0a3,
    0xbfc4726880cb5380, 0x3fd358987c7b26bf,
    0x3ff2edaf4476515c, 0xbffd13ec0299b234,
    0xbff00cc7bb027bad, 0x3fd543d11d945648,
    0x3fe7f0c5b3cf24e6, 0xbff0bd2b8e30a120,
    0xbfcfd1857cc306e9, 0x3ff5118c28a2f62a,
    0x3fd2fbaf3860cc71, 0x3fc05779c16f1fa0,
    0x3ff1506629797378, 0xbffcf429eaf0336a,
    0xbff5619f5c33f6ff, 0x3fb1bcbadf1ffb60,
    0x3fe934b1d436c7d4, 0xc001c865b652811a,
    0xbff4741bf1105a96, 0x3ff28bb4d2cd6195,
    0xbff1a252c03a2218, 0x3fe7e7302d974c84,
    0x3fef15f6536e5584, 0xbfef7753c494a288,
    0x3fc43cc452e78c38, 0xbfd7af68fe412fe1,
    0xbfed5cd8ae4b0fd1, 0x3fe3c01cb3322a6d,
    0xbfde674581c4f794, 0xbfc3fe59d5081dfe,
    0xbfb38ecdb20bb398, 0xbffa0690f3a52368,
    0x40029179eab862ec, 0x3feb0adb0a746469,
    0x3fbec33417852ee8, 0x3fcbd167434a8d30,
    0x3febc1029c625e5e, 0xbfe790a9e0b8fca2,
    0x3fe128b368bb03ec, 0x40082794ffef9f0f,
    0x3fd66466fc00a970, 0x3fd30eee8c318a22,
    0x3ff2a1fcb80d8da4, 0x3feed570ed901ebd,
    0x3fedaa1b328fe150, 0x3fe346917c192422,
    0x0
    };

static const uint64_t ref_rfft_noisy_1024[1025] = {
    0x3ff654f627f9c034, 0xc00d0e91104aa6a6,
    0x3ffa74b3b71806a8, 0xbfdd3925c4b06a2b,
    0xbff0169c9deec3c4, 0x3feac565e960fa9d,
    0xbfe4c343702ff054, 0x3fa67a79bc9cf764,
    0x3fe8770854d5ff1a, 0xbfd553eece5be5e8,
    0x3fbc67431e9e32dc, 0x3fe540c44e264c6c,
    0x3ffe32d6f1fc1204, 0x3fe21360ec93563a,
    0xbfd95df2f5695966, 0x3fe27bb461f8c713,
    0xbff0b2a9873df300, 0xbff6fd27dfb965ee,
    0xbff96904e0706a89, 0x3fe7da13d486c984,
    0xbfebe60553366c1b, 0xbfb82e952f16c168,
    0x3fe5099f2c4ad380, 0xbfdeadc42c9e72c3,
    0x3ff13304ef9ef442, 0xbffedad84b42ca1e,
    0xbfdfd48a065a373e, 0xbf93715228411510,
    0x3ff8fc3bbe8b65da, 0xbfcdf209f87e0082,
    0x3fd652b9ffe08c04, 0x3fd6a722e768240c,
    0xbfb4809dcbc3e250, 0x3ff485361022b502,
    0xbfe9555e3b152ff1, 0x3fc993ec5cfacc44,
    0xbfe44d51ee93f14a, 0x40047f7c6f7250e3,
    0x3fb0f6e90bee072e, 0x3fe3c3409e4a0c33,
    0x3fdbdaceba15401f, 0x3fcf8fdd3ddbe026,
    0x3fc5cc141986a806, 0xbfde72db401f87b0,
    0x3ff643e770c705b8, 0xc00a199f05fe0a2e,
    0x400fcee81948bcaa, 0xbfd9399a4bb38dd7,
    0xbfe4754f22374da2, 0xbfba8e98dba325d0,
    0x3fee9ca93139c118, 0x3fd411b4c00ab4f3,
    0xbff4297d549baf22, 0xbffa14ac7b8a683b,
    0x3fe8548954eb9b46, 0x3ff15a7eee41800c,
    0xc0084c2a54361252, 0x3fe865acd20c73ce,
    0x3ff86be22b9f97a1, 0x3ff594a423910160,
    0xbfebc62645f375bc, 0x3ff3d713c42ba8c4,
    0xbf8e185e8665ca00, 0xc0004b2bd2c9e670,
    0x3ff84b2cd2b69ab0, 0xc006ccf0ae51fcd0,
    0x3fb2e60eb5de53a0, 0xbfb9e561fa99b46c,
    0xbfe628d8d09b8275, 0xbfe5d37a75aeb91e,
    0x3ffed84c4b885270, 0xbfe128f8803f34e9,
    0xbfe5ca42c642b88e, 0xbfe0fffb456bb3f4,
    0xbff910a79d419d60, 0x3ff44acb3350645a,
    0xbff0a6ae33748e5c, 0xbfe8146a049ad4b8,
    0x4003b197753da384, 0x3ffa65d60ac2bf26,
    0xbfda43cd33c91557, 0xbfdb46aaa64a5a89,
    0xbfea4db258e37d84, 0x3fe331f2d44757b9,
    0x3ffa01eadc57866f, 0xbff48c2f15c51158,
    0x3fda47c52599e575, 0xbfe120e1bf8e9df5,
    0x3ffc1f8773fa1302, 0x400254eb58fa2874,
    0xbfeadbd837f2b84e, 0x3fcf6f290e953716,
    0xbfd4bdb6f674ddd6, 0x3fe029f2d8fc0352,
    0xbff6cbace4ace090, 0xbfecd4c33068bc94,
    0x3fe71ef0d6fc1933, 0x3fefa4694968c408,
    0xbffd641ff04b5bde, 0xbfed878037f57df4,
    0xbfe87147ef4fe5ac, 0xbffad3899e5f23f2,
    0xbf9bf8c184b2d2d0, 0xbfeec01107ba1324,
    0x3fe84e4f0f59b42c, 0x3feca3901a800f5c,
    0x3ffe8d064c901160, 0x3fce60f9a1e8a5f4,
    0x400032d13f1c7fca, 0x3fe4720fcddfa14c,
    0x3feb2559f74e325e, 0xbff601ae08527b34,
    0xbffa06b5cb4aeeb4, 0xbfec32b7e2eaa80b,
    0x3fcf77081988fa3c, 0xbfc8ddd31abd10d8,
    0x3fd4ce1151df2f18, 0xbff49f4384026555,
    0x3fd8c55b078352ca, 0xbfe86bb743ba1b8d,
    0x3ffc356c9e309bb2, 0x3ff21d5b0c041c81,
    0xbfe007f27d85c336, 0x40082b6eaaf9322a,
    0xbfe7c2684cbc78b8, 0xbfa491c9d61257b4,
    0xbff67151b7f1fea2, 0x3febf2e51eaa75ee,
    0x3fc08e22839cb380, 0x3fe4642544e73000,
    0xbfefdc5da59bb6c4, 0xbffdab34b59db554,
    0x3fe61230916a9b26, 0xbff5b6987d81d0b7,
    0x3f8c48bef4c6f9c0, 0x3ff2efaf7a7602d1,
    0xbfe96aa3b4393ac4, 0x3fe64fa1e7966efe,
    0xbff189d7f1125762, 0xbffb1fe360fb1cc8,
    0xbfe7cc3564d2ed66, 0x3ff2928db3a5d6a8,
    0x3feb319fd62533b2, 0xbfd469d2183f4bd4,
    0x3fe8431dc9e4c8bb, 0x3ff0629b2014f33f,
    0xbff75ea00d36767e, 0xbfce342e84399460,
    0x3ff15c853f3267c8, 0xbffa85c1ec9259d1,
    0x3fd4039ddc16f09c, 0x3fe919d8758bbc94,
    0xbff13d601fb42936, 0x3fcac420153d5ad3,
    0x3fd6f99a3f5f227c, 0xbfd63f527088a8e9,
    0xbfd207a1b02e7ad2, 0xbfc74b4b4c2afc7c,
    0x3fea3e3c1bb60351, 0xbfde6d53fa8a974c,
    0x4002ffe4b162ca2c, 0xbfe73945fbcff8ba,
    0xc0034902e4753d56, 0xbff9434c95c2d410,
    0x3fff290d25e3e448, 0xbfd2acb9bafdaf02,
    0x3fdb17a437e1bfe1, 0xbfde9c84e39325cc,
    0xbfe95b6b95713805, 0xc00800e94dae42d2,
    0x3fd05319d9aab504, 0x3ff80e16f09a98fc,
    0x3fea57166140aeda, 0x3ff8ab5fe85168b2,
    0xbfea5a9477b59ade, 0xbfe44438dd808bb1,
    0xbfd266a36400c2c1, 0x3fd0d5a114efdff2,
    0x3fd422a07b44f505, 0x3fd470a43862f12c,
    0xbfe02b8a846ac0fe, 0xbff3c37322c2a812,
    0xbff84e7f48317bf4, 0x3fdaa461e0f4b8fc,
    0x400135b3c5df9656, 0x3ff46ce544fd2376,
    0xbff4cee0f0ee79d7, 0xbfd33645d0123032,
    0x3fb82867e5d04b30, 0x3fe2508bc4b32534,
    0x3fec7c01d919a49f, 0xbff833e5e3fbe688,
    0xc00a95357f02473d, 0xc0041be5d6ecac9e,
    0x3fef96a027bbedf5, 0xbfdd3edca95d1910,
    0x3fe2493ec762807c, 0xc001200c18b1958b,
    0x3ff56864970db360, 0xbff20cecaf5cf41c,
    0x3fa3ad5cd8d13718, 0xbfae547451ffa8d0,
    0x3fee6654a7375c66, 0x3fbef6f8b37386b0,
    0xc003791b81db60dc, 0x3fe39aa1234c8ebf,
    0x3fe4eae9a981f0e9, 0x3ff05e6f5c962ab1,
    0xbfe00d240a71dbbf, 0xbfdbb598771f78e6,
    0xbfd16e84ab6cdab2, 0xbfea318e59f73cef,
    0xbfc48b3ec008f0a8, 0xbff1e221c1ffc49e,
    0x3fe717ecb5be043a, 0x3ff33fc57c42248e,
    0x3ff503806db0a7f1, 0x3ff80c4765283310,
    0xbfdc15258f8c85bb, 0x3fc80429e47fce08,
    0x3feeec477db6ce4c, 0x3ff030792a574f24,
    0x3ff217d1be07a07e, 0x3fea54875d0f4010,
    0xbfe2b780d2bfcff2, 0x3fbfc371ddf25992,
    0xbfe00a56870c5ea4, 0x3fb3eb57adc5b520,
    0x3fdb8768867b58d7, 0x3ff31cef7e4e5462,
    0xbff894622bda6f0b, 0xbfe8aabbb7fb193c,
    0x3f84c237d6320d40, 0x3ffe6fd66f5c056e,
    0x40020e16329bf5c8, 0xbfe6a1bb11f90ef8,
    0xbff587df9a6ffa47, 0x3fd191917c3da19e,
    0xc0002a6c5ac8b530, 0x3fc53f4411bb597a,
    0x3fef88f535755c3b, 0x3ff7de439f4d2260,
    0x3ffb577e5fc84a1c, 0xbfc8f34dc4437676,
    0x3fd02be2aab5cca9, 0xc0001506d34e1a34,
    0x3fff5f303ccd174a, 0xbff1b12d6142b1a4,
    0xbfd30fb5cc4f7d2c, 0xbfeed47558684664,
    0x3fc46e11ac34f3a6, 0xbfd31fc3a7634c9c,
    0xbfccc64770379288, 0xbfdbe9800dc7fc64,
    0x3fedae235b31fba4, 0x3fc35ec19f45cd88,
    0x3ff6a9186454c6c6, 0xc0765a4be82bf96a,
    0x3fcce348da9fcf68, 0xbffba089ff1e6f56,
    0x3fba6b95936bcd48, 0x3ff0901600729558,
    0xc0011c21449e8c16, 0x40050873c43ec51c,
    0x3fc69a14112ec858, 0x3fe8ea3aa18a15a6,
    0x3ff2f16f5b7b43e2, 0x3fa201e197c579b0,
    0xbfe88706e580e2e9, 0x4001f51254e77eb0,
    0xbfda5a6f976b0cbf, 0xbfe36c28fd18d011,
    0xbfd8d428e78ea0a0, 0x3fc50890c35fd990,
    0x3fccecae0c5654da, 0x3ff5151ce06799c2,
    0x3fe1f8472aae49af, 0xbfbf1a02c865e708,
    0x3feb34bba320fbc8, 0x3fffb781bd8305b8,
    0x3fe802b47b20e3c8, 0xbfd7e033674f8800,
    0xbffa5e6b41a97fae, 0xbff4e05a8fafa85f,
    0xbfe1333816afbfa2, 0xbfe53ed6930fa412,
    0x3ff8937fd8e69a43, 0x3fd6e5f369833a2d,
    0xbfd0d7276322acbf, 0x3fa45508b575fdfe,
    0x3fefe0fec8182050, 0xbfebb10c5d7eabae,
    0xbfd4ea67b3a1ee05, 0xbfd8a35fc0ce1b4a,
    0xbff5e1b6371a9bc6, 0xbfe38a24a9dca043,
    0xbfe65cddd57f08c6, 0x3fe74bbb97f130ab,
    0xbfd528a9863facea, 0xbfe01e6c9fcd4af0,
    0xbfcf4636f88583b6, 0x40011c5396f36d99,
    0x3fe6786c6d522b96, 0x3fd5526e104d8182,
    0x3fefb4ad6b5903f6, 0xbff1ef43456944c3,
    0xbfa9046268636110, 0xbfde20ab4e4d2d52,
    0xbfedf8886acbe773, 0xc000334415442e92,
    0x3ff01140ad3df06a, 0x3fe654a46e64e8b8,
    0x3ff16192fe318f45, 0x3ff585136ae1006c,
    0xbfaefa07c1e8e910, 0xbff0bf98e431441c,
    0x3ff45fdeb1e400f0, 0x3fc2cce91627e850,
    0xbff7cae3d668be3a, 0xbfb8f6bfa1a8894a,
    0xc002ff542d2cfaf5, 0xbffc05cf1bc584f0,
    0xbfe8bd0931ed301e, 0x3ff9988150a62ed6,
    0xbff4677168b0bc51, 0x3ff8a7ef2a3ac382,
    0x3ffa7d99e395ae82, 0xbffb73ed97f77bba,
    0x3ff3a8e38eecb628, 0xbfebd8e43e9f58c8,
    0x3fece8cf536e75fc, 0xbfd479be85c12b66,
    0x3ff5b7fd3f98d450, 0xbff0b40a1379e5fd,
    0xbff7a1aa1fb88f9e, 0xbfe44498f1dc7dd2,
    0xbfd3f6bca3835a8f, 0xbff49b92be15f520,
    0xbff10ccbae3c3c43, 0xbfec0077a1aeb7fd,
    0x3fbc5bc82c60a910, 0xbffce4a543e98864,
    0xc0017bf599bb68d1, 0x3fc7ab798b480be0,
    0x3fe7f2fe4469ff5c, 0x3fa2088975ee98f0,
    0xc0037edc4c2b9335, 0x3fe3df7a33751cdc,
    0xbfedaa56a8dc2f5c, 0xc0075d6468447f8f,
    0xbfdff89037c339b4, 0xbfe27e5c45007c3d,
    0x3fc47b7551f8acf9, 0x3ffc954f56571752,
    0xbfe13d5a85e99770, 0x3fdceda0362f3cba,
    0x3fe6e89edeb5e5da, 0x4000be402155dbb5,
    0x3fe504dbfde542bd, 0xbfedfd78726763ea,
    0x3fc756aa2b9753fc, 0x3fce74037c6586e8,
    0x3fde19c901947d5c, 0xbfc4f33d0ffc94d4,
    0x3ffd89cf329ff208, 0xbfff00bf90a27499,
    0xbfb6cf5ac072636c, 0xbff5e7da49cf98c2,
    0x3ff0f980edcdab00, 0xbfd69ac3a52a5b98,
    0xbfbde8dbb19a9860, 0xc004b4a31338e0a2,
    0x3fefebc46b43d352, 0xbfe111947273a718,
    0xbfb6fbf6f2756338, 0x3f7ae076cd2c6900,
    0x3fe0419764545586, 0x401003ddd6c644d6,
    0x3ff65c3deb8570c1, 0x3fe8666e15bd676f,
    0x3ff5ce65eca8f33f, 0x3fe2cb1ad00470b1,
    0xbff3ea77d1bf249e, 0x3fc46329cb221630,
    0x3ff15a9dee503226, 0xbfd1a1ef4c3908e6,
    0x3fe64844f0a69619, 0x3ff0021ee35ce7cf,
    0xbfff725253020c09, 0xbfca6193a28db700,
    0xbfe7c014a91e7a38, 0x3fc0892a4a96333e,
    0x3fe83bd1e0de4724, 0xbfe868d8be4ad3d8,
    0x3ff2cec88a1868b9, 0xbfde57d81d178b96,
    0xbfe655ff6f91b2b5, 0xc0062285be0f8e74,
    0x3ff2dc7a9efe6e29, 0xc0045edac1dfc0ba,
    0x3f7ea141345b32a0, 0xc003dcfebd203c0f,
    0x3f9417789d5815f8, 0x3fbe4aa250a21498,
    0xbfe9b7f56c53225c, 0x4002d0177d5487c4,
    0x3fec28ed1204a522, 0xbfef1c956834935d,
    0x3fdddd6d6db02bf2, 0x3ff211ccf975bd3f,
    0xbfe34345fc4eb4af, 0x3fc5913aeb753518,
    0x3fe2a46c0d637e42, 0xc000a4cae0c78863,
    0x40024986ca6e2738, 0xbfe0c75870e5610c,
    0xbff034697f6f5479, 0x3fe7d8f80f5f5768,
    0xbfdd5e72ea81750c, 0xbfaf2a3f7a6df694,
    0xbfe0e065bf13e690, 0x3fe5d659b2c2f364,
    0x3fc002b2788636e2, 0x3ff2a542d597f684,
    0xbfebdd65b5a22b50, 0xbff2f4c8e574ca46,
    0xbfe540013bd03b7d, 0x3fe35e0cfc721ef2,
    0x3ff90f94282cc4c6, 0xbfb91fca274f5984,
    0x3fe8610fb516d4ed, 0xbfd4e84b1086d348,
    0xbfda01d2dee4006e, 0x3fee27587022ae48,
    0xbfc7c33884769458, 0xbfcae33834a22057,
    0x3fe240a48cb96f84, 0x3fe70216f6bcec2f,
    0xbfe6accab8a7e218, 0x3ff36f228b8ab57d,
    0xbff962752b66b094, 0xbfd5c02657bd235c,
    0xbfb87d0b24d31800, 0x3f87ff36c42526b0,
    0x3fd4e98f5570bebc, 0xbfe10d699e2ad6fe,
    0x3ff0b87d95d4b4cb, 0x3ffecee10fbb9b37,
    0xbfe1f127e36df6d8, 0x3ff92a04665b31a6,
    0xbfe300900819a873, 0xbfe523159b5c33d8,
    0x3fd12a1d53c6c548, 0x3fed9a5ff2892f2b,
    0x3ff0bfc3d3c05be4, 0xbfdb99df14feadca,
    0xbff0f4470105884e, 0x3fe10fbf16688d99,
    0xbffaad45455d0d7a, 0x3ff87a21b736cc63,
    0xbfc50294be9b7ab8, 0xbfe0233916bd492e,
    0xbfe6c0ef4ac46679, 0x3ff326c12d801852,
    0x4005c85d46784ae6, 0xbfe5a4b4085619ee,
    0x3fd321951103d784, 0x3fe64bde38f409fb,
    0x3fff9b91f546eef0, 0x3fefe67328cad537,
    0xbff119c883bed6b0, 0x3ff30a480c58c008,
    0x3fe4f0203d199746, 0x3fd216b9d07d06c3,
    0xbff6c30cb1bce58f, 0xc011c78ac290cc6a,
    0x3feff57b4caab14c, 0x3ff757df8bbdb9af,
    0x3fe46a25675a782e, 0x3fdf276e83917dc3,
    0xbfaebb46d4a79100, 0x3f964c78e4d0fea0,
    0xbff44b5d933b9112, 0xbfdafe95ac35c23e,
    0xbff5a87dc48a7bff, 0x3fc799deed698eef,
    0x3fbcd82cbf3919e0, 0x3ff25bbf4394e87e,
    0x40083ad26455588e, 0x4008950e3d52948a,
    0xbfffd5b57592e14a, 0x3fe462208ad86b8b,
    0x3feba7a8795af634, 0xbfe55ec309baa0cf,
    0xbfbb5b7a409fe946, 0xbff670a082066318,
    0x3fe49857400c04ca, 0x3ffcd487c64b2d64,
    0x3ff1deb81b4ec198, 0xbfd468c1a2faf987,
    0xbff0499b7e1fdf37, 0xbfe5367737e5abed,
    0x3fd068d1eef1c94a, 0xbfd1b36ee67888e5,
    0xbfd881a40ee68d32, 0xbfe2240a6969f311,
    0xbff8001d36ac0ede, 0x3ff259054b2df31b,
    0xc005e1b87d87c0c9, 0x3fdaed83d3b5ae3e,
    0xbfe58ef0d44b5e58, 0xbfcebfe4e3cc4d42,
    0xbff63bff9d503f0c, 0x3ff5143f229f13c0,
    0xbff0b3204bf8be27, 0xbfd0164c9e71e6bf,
    0x3fe7c1d2e282fdc3, 0x3fdb4d93a0490a00,
    0xbff3a98fd579ed2c, 0x3feab69136b5d62a,
    0xbfef8b3a0bee155d, 0xbff227a3cdf6a6de,
    0xbff39b83154bb7a2, 0x3ff2d295115bed54,
    0xbfc1c535eed7f8c8, 0x40013bc794bd252f,
    0xbfed355f9c5f3127, 0xbfcede9043955ed2,
    0x3fe4202801bad9ae, 0x3ff304b6fd59c88c,
    0xbfd82ffddb03253c, 0xbfc753c75d385a10,
    0x3fdf76a8302a7969, 0xbfecd971b75f6c8f,
    0x3fe9938c705bb44b, 0xbff61733428d8630,
    0xbff7600f6dcac75b, 0xbfea20c1033d5466,
    0x3fe5b5a3e99d6309, 0xbfd7f4490b44e97a,
    0x3ff414002a9bc269, 0xbfd3f0cd8098e3e4,
    0xbfd5d27a88386d6a, 0x3ff2a8c5e301343e,
    0x3ffe806fecdbe1f2, 0x3fe8c84df48b82fb,
    0x3fed8fa2a121b1b6, 0x3fd36adab9373ed9,
    0xc00152b4ad904f98, 0xbfea8abdef4f3a46,
    0x3fef013fe274e8d1, 0xbfe6482b8f2bffd0,
    0xbfd5b11e706f11cf, 0xbfb12b341802ee45,
    0x3ff0d9f64888476e, 0xc003062cf81227e1,
    0x3fd1b89eed679210, 0xbfb2d69bb56439e8,
    0x40009d60a0311f82, 0xbff598b2b3289b40,
    0xbff4cea1fe74a1d4, 0xbfda3f81bcafc464,
    0xbfd9ae6935d67ec6, 0x4000d82f1965f1c8,
    0x4003afd74f456b9e, 0x4006dbd7604aaf62,
    0xbff18c81916b3ec6, 0xbfee65fdd0c1df52,
    0xbff0c794017de5f8, 0xbff16b3922a21770,
    0xbfe7e096c147d317, 0x3ff8c5b7275112c2,
    0xbff5fd21e65c8d66, 0xbfd6a140f6f39246,
    0xbfc821c656318b14, 0xbfbcc1c3d777cf14,
    0x3fd87f1f48e1a37c, 0x4000b56a205944fb,
    0x3fd2a285b1d069d5, 0xbfd42640bd26128c,
    0x3ff7336fb540672d, 0x3ff3626cc47e0c78,
    0xc0034bda027e170c, 0xbfd19f02c11adca4,
    0xbff026ccb2c98e08, 0xbfeb5ec0dad3bdea,
    0x3ff07fb780bfa61b, 0xbfc551058e010e68,
    0x3fdcf209133bc269, 0xbfc09068091a7d94,
    0xbff32f7d373b738e, 0x3fcc0f4702b30bff,
    0x3ff949ace48ddc24, 0x3fb0c636177da1b0,
    0x3fed86c36ffec033, 0xbfe985214f719558,
    0xbfea9479d93b477b, 0xbfe329a65755d6c2,
    0xbfe35fc045f8cf4f, 0x3fdcb0e8cae6b868,
    0xbff031bb70dd3747, 0x3fe799305f1c3fb0,
    0x3fe5395c36ecc4c6, 0xbfe241f2b6569234,
    0x3fe1e798f575e5da, 0xbfe0ed634dae4458,
    0xbff65bceac915c84, 0x3fe15b6eacdee6df,
    0xbfeb8e3fe1dd27d0, 0xbff81faa61beb28e,
    0xbfe08f617ec06360, 0x400436aca95abb05,
    0x3fd0c60556498205, 0x3fea59df0235ad6d,
    0xbfece5004cab3015, 0xbfea1f06dd3721e6,
    0xbf94dd44537637e0, 0x3fe17f8de43a47ca,
    0xc000c15a2f619d16, 0x3ff767e834ee082e,
    0xbffb20ade92b8e9a, 0x3fa1d127582c6060,
    0x3fd25f444aa0831a, 0x3ff2018693788c24,
    0x3fa1d2fabe4e378c, 0xc0000865b88d9b65,
    0x3fef0944c5410c26, 0x3fe1acd9a78c368f,
    0x4000b68cbe6d8d15, 0xbfd11928607c6a20,
    0x40028618ffe8061a, 0xbfc22b17903f0654,
    0x3feb510f31815214, 0xbfdefd2d2b6a06a0,
    0xbffb03bb679bbde6, 0xbf94ec5529011c10,
    0xc00071b92e183954, 0x40050e2421b6b026,
    0x3feaa8d56d383165, 0x3fe345038dcd7f9a,
    0x3fd882a4b0973d4a, 0x3feefa6146dcbab1,
    0xbfd2639472de9328, 0x3ff839b5bb662e69,
    0xbfd6ad544cdc2e4c, 0x3ff58a84c96e49fe,
    0x3fe65078e27c37f2, 0x3fe756524af68ba7,
    0x3fe54dc626cecdea, 0xbff6e2561ecadf71,
    0x3ff78725d0e2921a, 0xbffae9666bdfeb3d,
    0xbffba8468213da07, 0xc00121555f4fe320,
    0xbff372a1c045befc, 0xbffc745b71050f04,
    0x3ff3a42eac355724, 0xbfe06ea40a7ae6b0,
    0xbfe2fd9600fcc966, 0x40003bb8fce5461f,
    0x3ff17acc2c7f60c2, 0xbff7c66c9de4a78f,
    0xbfe5c1e0093b1ebe, 0xbfea7f35f2ee691b,
    0x3fe654b35a069a7d, 0x3ff1e57b89b31284,
    0xc0011cfb8b23f926, 0xbfc7cacc88d3b492,
    0x3fbca94dce8ce8f0, 0x3fc07dff3617428c,
    0x3ff0480b8faeed73, 0x3fdb83b8fc45a646,
    0xbfd19cb74803d29c, 0x3ff1482160d838d8,
    0xc00001978c5244a2, 0x40006ebad3ad7e3f,
    0x3fe8ccc022464850, 0xbfe3a1bfcdf9acac,
    0x3fefaef30cb65c94, 0x3ff1e647052b756c,
    0x3fe50760913b291c, 0x3ff4f66298a75072,
    0xbfe08d39bacee5c3, 0xc00031b97fe671a3,
    0x3ffb1dc3bba494fa, 0x3fe67b9098b2e423,
    0xc001993c44950eb8, 0x3fc708cbb3572bb4,
    0x3ff400874d480a00, 0x40015d19fbf352c4,
    0xbfef0e54561db9d5, 0x3ff38d12afbb9678,
    0xbffb41e74494470c, 0x3fe08a6ac2ae995a,
    0x3fd07b0eabb5cf44, 0xbff3a9b75256bf1a,
    0x3feb9d02dc79eb53, 0x3ffc0b03ae2558de,
    0xbfce0b6db0c26d28, 0xbfefeca5643d5f1c,
    0xbf98f7e217f1f1c0, 0xbfa7be458cdad8f0,
    0xbffac3021214a285, 0x3f87fd8e6a27dbc0,
    0xbfe5c7c1917b6de4, 0xbfa6ba72954b7cf0,
    0xbff1ddd393f42586, 0x3fdde08f115cd8a6,
    0xbfd805db8e0a0ff4, 0xbff5d5c53df012d6,
    0x3fe28a25ec5ff98f, 0xbfd4c9f21bc39786,
    0xbff12f29e82617a1, 0xbfe1cf8cfec4f179,
    0xbfd36be43b0ca5dc, 0xbff9807dc7abad30,
    0xbfed4e20556eb2bd, 0xc0064bd6982bda52,
    0x3fe510e0878aef99, 0x3fec3c8e85af7717,
    0x3fcdceaf881355c0, 0x3ff3663517dc79cd,
    0xbfe9d6c9afb8e15a, 0xbffaf03f8b2f0230,
    0xbff0b786dca1cb0c, 0xbfe38f6e53be5037,
    0xbff4247e510bdaac, 0x3fd4f402316a5df5,
    0x3fe779d77f72e18e, 0x3fd1f0bb0b119a8e,
    0x3feef09360fa10a4, 0xbff190756ee312f6,
    0x3fb0e39b14125f04, 0xbfd58e242915c6c6,
    0x3f947f205875a800, 0xbfc3f8056ae3ed9a,
    0xbfe2efcdd4a46352, 0x3fbc61daf6a666c3,
    0xbfe157fc88697c22, 0xbfd7fa18a68c1f07,
    0x3fd91cf3cfaf2e2e, 0xbfea06ad01a6bc7c,
    0xbff509bc1d7f0ec8, 0x3fd98f38ba50e47c,
    0x3ff7ae56f1e55190, 0xbff5b712b03cef4f,
    0xbfe6ae3373430728, 0xbff3eb0da52eed36,
    0xbff81daf7a6ad912, 0xbff6f427409e94fc,
    0x3fdbe277286df31f, 0xbff5fdf8e0ed1176,
    0xbff4aaad8ec00d2b, 0x3fede9790b4a516a,
    0x3fde5d09eb428e8f, 0x3ff8534833a04974,
    0xbfe734e8491cecfb, 0x3ff43a665ef05395,
    0xc00ac7fb9087f063, 0xbff73a166c599702,
    0xbffda2175df810c9, 0xbfec46433991fb16,
    0xbff9f8bda50f8bce, 0xc00d8aaae49de300,
    0x3ff7bfc246a317ca, 0x3ff5f4087ab2e11a,
    0x4001b612118a1a1a, 0xbfeea6028605ac75,
    0x3ff8546f98a2ac7a, 0xbff74903ab872380,
    0xbfed1b4ed795de46, 0x4004a78675209af0,
    0x3f935db5c4292040, 0xbffe7cb4d292bfd1,
    0xbfe7550d709ea346, 0xbfd7086297cacef4,
    0x3fbcb42e8cba5188, 0x3fc9b32c5f8c790e,
    0x3fe46476cff86055, 0x3ff7ae1e909a2528,
    0xbfe21850592b6b04, 0x3fedc6a57eb03e28,
    0x3fe0e5b09d1558d1, 0x3fe81f926e999f9e,
    0xbfec0a0ad2738aff, 0x3ff93ed1bb7a6b94,
    0xbff20f3452163cf9, 0x3fc3cab2991b151a,
    0x3fe3c00ff58bb7a2, 0x3ffa98069d8b257a,
    0xbfeac257eaec6da2, 0xbff696cb70afa658,
    0x3fee839453344fd7, 0x3ff3002e1cadf46a,
    0x3ffaf30edbe398d1, 0xbfedf848882024ec,
    0x3fd1953578b146b3, 0xbfe664458b86e2f2,
    0xbff6bb08775dd120, 0xc003f9319b9ed91f,
    0xbff3b11aefb54ce0, 0x3fdc56f2459a467a,
    0x3fccabc30641ad3e, 0xbfdbe1231be47b58,
    0x3ffd146761371ae2, 0xbff0e5f10e6de76c,
    0xbff1dbeb96ba5bf4, 0xbfd20893a8d2dc88,
    0xbfed3e6e1b3c1686, 0xbff100f9a2bc9d22,
    0xbfe7c91eabcf405a, 0x3fa611fec7933cf0,
    0xbfae111089ddbdc0, 0xbfc6ca7b9c64adb0,
    0xc0001fedfe9fc89e, 0x3fe2c5ae0cb56f97,
    0x3ff261d3d7a4de98, 0xbfe3ea695c0d56a9,
    0x3fed96839beedaaf, 0x4007f47bf443b174,
    0xbfa073eceda88720, 0x3fc11221d3245f6b,
    0x3fee885d8880a924, 0xbff33c9a169dceda,
    0x3fd2a5581858602b, 0x3ff8a40d663f0fb8,
    0xbfc843e2d06943ec, 0xbfe8a42b91388147,
    0xc00658ac1887e01f, 0x3fe08e2127d5fc25,
    0x3fe12bad76dcf3db, 0x3ff72381d527c1f6,
    0x3fe4a12ad1d27d8c, 0x3fde2d3ad9f082cc,
    0xbff99f05222162f6, 0xbfff6871dc78da2a,
    0x3fe8b26a64121136, 0xbff34860521faed5,
    0x3fb52b6a19dad060, 0x3fe5942e43afc0d3,
    0x3fbd1d60d70e3c60, 0x3fe5b499afa4ee9d,
    0x3fe0688a15f2779d, 0x3ff82ed666e8435c,
    0xbfc30350fa491160, 0xbfcc3685e4b544c4,
    0x3ff497b05b72d46e, 0x3ff3a7d3bc7696e2,
    0x3feed627c0f50a90, 0x3fe0e8116577a06f,
    0x3fe7d82a1c6c428a, 0xbfc905a0136a69bc,
    0xbfcdea2d2fabe5c0, 0xbff889d2e8dc62ec,
    0xbfe91f3f0ee7e772, 0xbfea73d7b05298e3,
    0x3fe85857313f0a59, 0x3ffc699e9ccd159c,
    0x3fdb4a347a6ff23d, 0x3fee75d2ae6110fa,
    0x3ffaaf91c6e09a92, 0xbffc29dc0d200e04,
    0xbfca3724890e98a8, 0xbfd682c1a2c3ebb2,
    0xbfda5c231fc7eba8, 0x3ff617187bff905f,
    0x3fe8b4a900710a8b, 0xbfc4d5b907c7ada0,
    0x3ff5227c0a8822c2, 0xbff49c0aa58cd638,
    0xbff1470cb52a2c30, 0xbfc6c8e37514cbae,
    0xc003ed6c20dc8092, 0xbfc0d1f167598c75,
    0xc007da804e3e119e, 0xbfda92414720b42b,
    0x3ff1f58d32dbb05a, 0x3febc1fc151df862,
    0x3fce253410f394fc, 0x4004d8ba39f0652e,
    0xbfdf6b6574c93192, 0xc00321f4fecd008c,
    0xbfcb72c195691c0a, 0xbffc68e948ebc5cf,
    0x3ff318dfdef933a4, 0xbfdbd9bb8521a55e,
    0xbfeaf3b2f9695a4d, 0x3fc4ef7123103b00,
    0x3fe77dbc0eeeeec0, 0xbfdde9c9a597b46d,
    0xbff3f0221bd00de0, 0x3feae32cf835f9be,
    0xbfb82112a8606ad4, 0x3ff811fcfcb6bb19,
    0x3fed3eeeb28141d6, 0x3fed616b6ad7b5b8,
    0xc0068d73a9eae596, 0xbfef2b2e3e400fcc,
    0x3fc1f88940e7784c, 0x3feaeb2053994160,
    0x3fa18e8ef59589a8, 0xbfbd720e392c85da,
    0xbff34ccddd809f0f, 0x3febe293a09f9a1a,
    0xbff560d3f3ccd06a, 0x3ff2146be79029c3,
    0x3fdbd455d63a858a, 0xbf712553ea7e2b80,
    0xc005c437d575ed8f, 0x3fb3c95962302d10,
    0x3ff83ddc1f8a3e02, 0xbffe20efd8859fdf,
    0xbfdc43b5ccccdb50, 0xbfb12591bae13018,
    0xbfdb2092a273313c, 0x3faead240343d3b0,
    0x3fd426c970ef2fe0, 0x3ffb9268ee28d774,
    0xbfcc70c496243c60, 0x3fe4060858173bfb,
    0x3fa7a53f6b0879f8, 0x3ff5759e98261840,
    0x3fdfc9f8356decdb, 0x3fef1dcfa86b5a18,
    0xbfb4782542efed74, 0xc003a9768de8ed9f,
    0xbff330a0b161283a, 0xbff4d365ebc5de46,
    0xbfddeec3b41a1f32, 0x4004384eaedd5376,
    0xbfbcb0f6c9e6c518, 0xbffdfe28f3e9b64e,
    0x3fd34156d3f0a06e, 0x3fc1af01ad299c4e,
    0x3fd846ac0f1fd205, 0x3fea41f1b492cce8,
    0x3fe9d5c6f4fefd5c, 0xbfca5aad921e2fe8,
    0xbfc0a26bceb4a0c6, 0xbfeafe64de4d1625,
    0x3ff3cc731fd75d19, 0x3fd72a7fe45ec5fc,
    0xbfefbe29b75c94ec, 0x3ff5a86f51cf4f60,
    0xbff41693f693ad1f, 0x3fe1c3b010aafd52,
    0x3fd83eafa8552880, 0x3ff2409424717aa6,
    0x3fb7ff1ffe547f6c, 0x3ff09a584a80be6a,
    0x3fe0ba90463265a7, 0xbfdde378dbf6ddae,
    0x3fd0f223e191eb07, 0xbfeb27ecf93ad058,
    0x3ffa0fc3fdff4c18, 0x3fdec16589a3d44e,
    0xbfcc7070ac38f66c, 0x4001c37dee6ab330,
    0xbfe8a24162cf45f5, 0x3fd88be25791e3e5,
    0x3ff06714044deef8, 0xbfeb6f3b29f16868,
    0xbffcb1d97750c3f8, 0xbff6b980505dc23c,
    0xbfe3a940b2052588, 0x3ff4213bfb4734c4,
    0x3fe94ffaba45b496, 0x3ff8a92ebc0e982c,
    0x3fe0bd48471d6a86, 0x3fa3fa3d72f900b8,
    0x3ffa41dc0480a73d, 0xbff5eff7c91fb6dc,
    0xbfe8490bc7d84973, 0x400171dfeb7e5c2a,
    0x3feaa04d4e0c82ec, 0xbfccf16825a5fbee,
    0xc000c0b331056e3a, 0xbffda507ee6da0a3,
    0xbfc4726880cb5380, 0x3fd358987c7b26bf,
    0x3ff2edaf4476515c, 0xbffd13ec0299b234,
    0xbff00cc7bb027bad, 0x3fd543d11d945648,
    0x3fe7f0c5b3cf24e6, 0xbff0bd2b8e30a120,
    0xbfcfd1857cc306e9, 0x3ff5118c28a2f62a,
    0x3fd2fbaf3860cc71, 0x3fc05779c16f1fa0,
    0x3ff1506629797378, 0xbffcf429eaf0336a,
    0xbff5619f5c33f6ff, 0x3fb1bcbadf1ffb60,
    0x3fe934b1d436c7d4, 0xc001c865b652811a,
    0xbff4741bf1105a96, 0x3ff28bb4d2cd6195,
    0xbff1a252c03a2218, 0x3fe7e7302d974c84,
    0x3fef15f6536e5584, 0xbfef7753c494a288,
    0x3fc43cc452e78c38, 0xbfd7af68fe412fe1,
    0xbfed5cd8ae4b0fd1, 0x3fe3c01cb3322a6d,
    0xbfde674581c4f794, 0xbfc3fe59d5081dfe,
    0xbfb38ecdb20bb398, 0xbffa0690f3a52368,
    0x40029179eab862ec, 0x3feb0adb0a746469,
    0x3fbec33417852ee8, 0x3fcbd167434a8d30,
    0x3febc1029c625e5e, 0xbfe790a9e0b8fca2,
    0x3fe128b368bb03ec, 0x40082794ffef9f0f,
    0x3fd66466fc00a970, 0x3fd30eee8c318a22,
    0x3ff2a1fcb80d8da4, 0x3feed570ed901ebd,
    0x3fedaa1b328fe150, 0x3fe346917c192422,
    0x0
    };

static const uint64_t in_rfft_noisy_2048[2048] = {
    0x3f9293c3bc4b8c87, 0x3fdf60408ef845cb,
    0x3fe711ff982eeca9, 0x3fdc2a576d1cd230,
    0x3f9a1543bfc4ac73, 0xbfda9e81b4d5dd57,
    0xbfe63eae54244380, 0xbfde4434117cad97,
    0x3fadca676969057e, 0x3fe025b22e2d2fcd,
    0x3fe5ea4f49392ace, 0x3fddb30c806865a0,
    0xbf88e5a499aae6dc, 0xbfe11d87e096b239,
    0xbfe76946e4d0683f, 0xbfdc935422d4d8c1,
    0xbf31e141b5982d44, 0x3fde99b3d4fa66a7,
    0x3fe551b294bb149a, 0x3fe086e50c5396b5,
    0xbfa8fcc182053306, 0xbfd9a2cbf3c4bfa8,
    0xbfe4ca0881babfc9, 0xbfe0eacb77e1b379,
    0xbf9345badf8483c0, 0x3fe06d8a62e07f4e,
    0x3fe57cf7afca057d, 0x3fe1f40481a72729,
    0x3f628ae6d87d8c21, 0xbfe12d26f9acb7d3,
    0xbfe609a5a38aab22, 0xbfe2c734ef8770b2,
    0x3f905af7100a35ab, 0x3fe003ebb3314935,
    0x3fe675693c6c1ec8, 0x3fdf8a80930d68d9,
    0x3fb7ddfcac5f3418, 0xbfe026f39f1161f2,
    0xbfe77b5198a3694c, 0xbfe0a250d1f6cdaf,
    0xbfa7559f4bfa92f8, 0x3fe06c898780ac8b,
    0x3fe43fbeb3ceeba2, 0x3fe0e18c39771e3f,
    0xbfaa6edd56bb0982, 0xbfde78cc4b717966,
    0xbfe6abbeec0ba159, 0xbfdc05000777d167,
    0x3f912294f2b697d7, 0x3fe372ca2a0daec8,
    0x3fe7e42df94de0f9, 0x3fdbd009cd398dfc,
    0x3f9ec9d59d0a9238, 0xbfe0a03042e9c8d2,
    0xbfe763981d610ad3, 0xbfdf9c605ecf4110,
    0xbfb7297a97c6ebfd, 0x3fe0e951fcb982fd,
    0x3fe4ce69c358dd48, 0x3fe339108b967034,
    0x3fb73c4cc0a06e5e, 0xbfdfa7e4339def78,
    0xbfe66dc2d1c0f272, 0xbfdaa86018f7c4b8,
    0xbf85250a2659b505, 0x3fe0dde804919088,
    0x3fe50c70300242f1, 0x3fe1c18a7a6f13ea,
    0xbfabd6b2cf38e594, 0xbfdbf5cbb8defecc,
    0xbfe4ad0f439a544b, 0xbfe295867fe79c4e,
    0x3fa6a5a17397f3e2, 0x3fdaac443098212a,
    0x3fe681223ba16020, 0x3fdc7901c354c9b8,
    0xbfc0ab605feb9a13, 0xbfdef3a0d28f4332,
    0xbfe6ef59fef444a2, 0xbfddbc17dfa997bc,
    0xbf9dcfe5518df0c3, 0x3fdce79d50a6665c,
    0x3fe67ba8a0319890, 0x3fd98079a2f38f60,
    0x3facb7a03533fc92, 0xbfde53ddaa2555db,
    0xbfe4dc8fbc8a4b67, 0xbfde47dbf3512ebf,
    0x3fa2be38a15051f6, 0x3fdebaf5844bc138,
    0x3fe7baf764bd2d42, 0x3fe04e2cb366d6b6,
    0x3fb57cf18f32cf79, 0xbfe1f13bfe02c408,
    0xbfe54e3ae2645319, 0xbfdf3b48373f4d3f,
    0x3f842c79cd1f1681, 0x3fddbf499d8bd286,
    0x3fe7f77f90dc0f1f, 0x3fd85a861840e98b,
    0xbfa4631f63c98c12, 0xbfdf338f07945286,
    0xbfe5fb9a924553ae, 0xbfe20946898aaa4f,
    0x3fb4cb50ebb4cd52, 0x3fe0c92dcdb468ba,
    0x3fe48e5d499f5b72, 0x3fe13ed51d4f1bf5,
    0x3fa23b4795d8ab17, 0xbfdd7acdbc3dcbe0,
    0xbfe6aaa1b28c714d, 0xbfdc7263ee9da9fb,
    0xbf89c0a2c17823aa, 0x3fe18fcaa6b54537,
    0x3fe643106eb1d04d, 0x3fe2dbdf11c0ba3c,
    0x3f8fb2aef463e845, 0xbfde3a1f2067cd66,
    0xbfe83b580f34490f, 0xbfdddf4704b0be77,
    0xbf93680b7737349f, 0x3fddfb05dc77de58,
    0x3fe9857378afe60d, 0x3fdfc57646e03267,
    0x3f42b7b9d7f24f2a, 0xbfe0db2086e78433,
    0xbfe720b25403c76e, 0xbfdfd49db75bdd8a,
    0xbf8539d45fd2453c, 0x3fddb8e974502eca,
    0x3fe5657ad35cb7ba, 0x3fe1cbc11d253f3d,
    0x3f9613e9c95d848c, 0xbfdcd367ae56133b,
    0xbfe81054784e2caf, 0xbfde15235e151c2e,
    0xbfc504658abaa544, 0x3fdebf593128d3b8,
    0x3fe847ee276c37ee, 0x3fe0792ef3009f65,
    0x3fa67a3af7397a24, 0xbfe32271ce00633b,
    0xbfe7f68aff740092, 0xbfe2065bc89de7fc,
    0xbfa3ae46dd8b6702, 0x3fd95df454ba1b68,
    0x3fe4983c7b0513b5, 0x3fe10c0d78c2f765,
    0x3f98fedeffedda89, 0xbfe17240c196a476,
    0xbfe58754b47d6086, 0xbfdcf3ba56aa56f8,
    0xbf7425c017ff32a3, 0x3fe2087e6b92c92b,
    0x3fe61b4c5dc1d637, 0x3fe0ebbd7000bb71,
    0xbfa296c592bf8880, 0xbfdc2d4201f3ef64,
    0xbfe6923ade1b1466, 0xbfe1003d6e279ec8,
    0xbf9c6faecd343ec1, 0x3fd82fd6c45f773d,
    0x3fe51fa8d76ad41a, 0x3fdaff2ff5e87f90,
    0x3fb449116061575e, 0xbfdd16cfb8959dc3,
    0xbfe3f21fa835def0, 0xbfe2105ca3acadbb,
    0xbfb20792eb90b712, 0x3fdee180d3b8ee58,
    0x3fe57f65c65d8591, 0x3fdd6b41ea6076eb,
    0xbf9a6cd838604aaf, 0xbfe249cf55c766c5,
    0xbfe4e5213ee13038, 0xbfdfdbcf4c29c3b9,
    0xbf9084d853662cb0, 0x3fdae3cfa5894eca,
    0x3fe65b9cfdd92c7d, 0x3fdcdc5aa3ea8d13,
    0x3fbecbd280f27b4f, 0xbfe059cd79f14602,
    0xbfe5a09e2e27e686, 0xbfdf2bb417e4782f,
    0xbf85cac994ae5eae, 0x3fde0fa2f7982cbc,
    0x3fe62db6b1db634e, 0x3fe16eb008dcc6e2,
    0xbf738bd1e3dea36c, 0xbfe1883bccc259d6,
    0xbfe29e5df5974c41, 0xbfe19db103b2192f,
    0xbfaaeb6859dca7ce, 0x3fe1f9fca699e283,
    0x3fe3dd65076116c2, 0x3fe04b4957822ed4,
    0xbf8034fbc1cfa5ec, 0xbfdfbe9d4fbb0560,
    0xbfe3c6a03b011fa6, 0xbfe243f5a9ed7d27,
    0xbfab0cc931eb8777, 0x3fe1501653e82bdf,
    0x3fe61415c80e7978, 0x3fdd84f00e3c1e54,
    0x3fbbffb99f42b535, 0xbfe06df9599550ef,
    0xbfe633afe8825eef, 0xbfe0875aa6957d6b,
    0xbf984dc0b344b169, 0x3fd986eb9a4fc630,
    0x3fe59e89228f074a, 0x3fdcccfba392c0c2,
    0x3fa9020905303efd, 0xbfe0fe85ec540a07,
    0xbfe88289782aa3e2, 0xbfdc368dd6ac52ef,
    0xbf8e318bcfd52c58, 0x3fd8de20b270ced6,
    0x3fe753b496787256, 0x3fe27c908444b72e,
    0xbf8311e4aa35757b, 0xbfdde4393be32cde,
    0xbfe73df3f7aa29f0, 0xbfe1f6f358b26c76,
    0xbfb6d0b3ee83a4c3, 0x3fde8f08bcabcee9,
    0x3fe5818c2b6435fc, 0x3fe05fbf6ae2e07f,
    0x3f90f9e71645e748, 0xbfdd9e2153fceef5,
    0xbfe4667df84d53e9, 0xbfdb25be225e3404,
    0x3fa71266d976ddc0, 0x3fdb27466a7dd668,
    0x3fe32eef981d38c5, 0x3fe28fe719c2ad26,
    0x3faa56c18146ef06, 0xbfde66ea3bb043ce,
    0xbfe5f55cd64863dc, 0xbfdf6ce1b8b93d6e,
    0x3f850800558e0526, 0x3fdce26d6969b7d1,
    0x3fe4d7e29dce6786, 0x3fe0fbb49348a0a2,
    0xbf641b28e9576e95, 0xbfdea8f6fb18ee97,
    0xbfe78db720dc72d3, 0xbfe284f3aa3aa39a,
    0xbfaa3629492c641d, 0x3fd763ca3ad58cda,
    0x3fe524167d247833, 0x3fe0dff1e4e1d776,
    0xbf7dc641b1a9d3b9, 0xbfe052a06a1c4000,
    0xbfe80eede26a0ea8, 0xbfdcdb1732a4dca2,
    0xbfa3e0f01cb18262, 0x3fdd5ecd9fbd2070,
    0x3fe4877bae14d315, 0x3fe1ba50e0c82bfd,
    0xbfa5251d25903166, 0xbfe229694f6269ca,
    0xbfe7c4367c82c97d, 0xbfe03d8cb106e1fd,
    0xbf8fc69fe9acab57, 0x3fdd204e708f4425,
    0x3fe3087aac87ac18, 0x3fe12200c3de0a83,
    0x3fa0080f07a5b93b, 0xbfde5886f211dd37,
    0xbfe7e97b73ecadf6, 0xbfe19e9102c623cb,
    0x3f9d866d833072f8, 0x3fde726edd2d5c76,
    0x3fe5269af8703548, 0x3fdc23faaf304865,
    0xbfb238d23933a2c5, 0xbfe0034ef686b03c,
    0xbfe997cd2310b32e, 0xbfdc116cb3d1f3b4,
    0x3f8d29a4a8ae0c37, 0x3fdf55259b2e5f76,
    0x3fe81f9a986e9b8b, 0x3fe366e790faedb9,
    0xbfa4dc26a678fdca, 0xbfdd5e0ab4be40ad,
    0xbfe72a672a52188e, 0xbfdcbd69aeb6d197,
    0x3fa87161c032b1a0, 0x3fdf36e51362f7e2,
    0x3fe854b7731085e4, 0x3fe09ec8981d2fe9,
    0xbf99bac612ca604e, 0xbfdf45278d75b17b,
    0xbfe79da5c659378f, 0xbfe4b9328eb28570,
    0xbf38ede63158b369, 0x3fe1ea4461592904,
    0x3fe2f6447f52ec9c, 0x3fddce6b224b9838,
    0x3fb2a172153c9e87, 0xbfe036a1b0d12eb2,
    0xbfe692eb2c478717, 0xbfdfe7a84259cda1,
    0x3fa4572a8bdc9ae5, 0x3fe2567d6bf27267,
    0x3fe66f3ced665337, 0x3fe1bb0125e0dc29,
    0xbf9bc404e4c9078a, 0xbfdbe8db26961236,
    0xbfe4a02fccbd34e5, 0xbfe1a8dc835021b8,
    0x3f929c52ca6909cc, 0x3fe0b81d7473d582,
    0x3fe81675fe08dc11, 0x3fde90471f657a5c,
    0x3fb20c7011365add, 0xbfdd5f0c0600f17d,
    0xbfe4a54856b621bc, 0xbfdf322c024976ca,
    0xbf760bca80b0e68b, 0x3fdf9a62882a8037,
    0x3fe67d087b4ecac1, 0x3fdc06bbf231253c,
    0x3f456b825a7f9fbe, 0xbfe0e219616ed1d2,
    0xbfe71b668cdc4f3a, 0xbfdcabecf7f6199a,
    0xbf92a1b0aa839e96, 0x3fe3da4f4ba9f249,
    0x3fe496b16244cb29, 0x3fe0c6dc5e1f50c7,
    0xbf979be0b44c3b57, 0xbfde99c0215a374c,
    0xbfe762365250db7c, 0xbfe1c17125ba9fd2,
    0x3f7ecbf67b50eece, 0x3fde8a4c42af7fa5,
    0x3fe50fae01cc7e06, 0x3fde3832f4811c1f,
    0xbfb5183bdc5eb52e, 0xbfe3346c4827a7ae,
    0xbfe624695bca46ac, 0xbfe179a0cbeafd89,
    0x3f9893ff5b8f5fcb, 0x3fd8a878ac4ee8de,
    0x3fe7dda0ae90a2f5, 0x3fe11e7397b744d2,
    0xbf79b9564b0ac36d, 0xbfdd8af3219ec8ca,
    0xbfe7a2a8fc852d6e, 0xbfdf02d4497b4c72,
    0x3fa560bb27684ffd, 0x3fde3e001a608984,
    0x3fe96eb6168f6f66, 0x3fdd6b8fcb13cfdd,
    0x3fabd8ace3dca54b, 0xbfde17bae5413bd6,
    0xbfe438665fc6e4ff, 0xbfe116f476eaae82,
    0xbfae8156b394e537, 0x3fe1f9011e33b4ae,
    0x3fe6b7e7138a78e4, 0x3fdf4f5ae0d52bd1,
    0xbf9b35b6f20c4512, 0xbfe195d76b3080c1,
    0xbfe6f824b26e9741, 0xbfd855779be6d162,
    0xbfbded7b08a481bf, 0x3fd997c8f5fcbbb3,
    0x3feaae28994c041c, 0x3fe1b6dfc10dc117,
    0x3fb02d8cfb02a645, 0xbfe04fd5f9267ced,
    0xbfe5b74e5e1e62e2, 0xbfe19641c7cf06c1,
    0x3fb12f03fba67c82, 0x3fdd26a133473e73,
    0x3fe6f080de51a13e, 0x3fdd1c7bb867d624,
    0xbfb530eba114c7d2, 0xbfdd9789fa922966,
    0xbfe74439c192d6e0, 0xbfe045e86778d853,
    0xbf8935052e396e9b, 0x3fd629dc4c6d7674,
    0x3fe6e91af38f41dc, 0x3fdbbd0896caff82,
    0x3fbb4354ce086df3, 0xbfe0ab01a851bbd0,
    0xbfe564412b493d20, 0xbfe315c4fde68d2b,
    0x3fac36058816588b, 0x3fe051278584f366,
    0x3fe578dfa615d028, 0x3fdcd1bf3ebe34d0,
    0x3f890c29e93c581f, 0xbfe2a7bcd44fa7fb,
    0xbfe848e53bd02a76, 0xbfdb50c7c6eafae1,
    0x3fa1752d4d2ec9ac, 0x3fdf27173c7918ea,
    0x3fe56bcae5e099d7, 0x3fe016f910ce4f95,
    0x3fa4ef877f016c95, 0xbfe006fc2f978c6c,
    0xbfe49e543ff14111, 0xbfe0741a7ad67caf,
    0x3fbdacbe3d7f07f3, 0x3fe092bb4f19133b,
    0x3fe6e5a62e811109, 0x3fe082312c681720,
    0x3fadbcc507910eb0, 0xbfde0ddda487800c,
    0xbfe75731148d0586, 0xbfe1c08b4d70160a,
    0x3f644ac3ac574a0e, 0x3fe150073fcee6af,
    0x3fe646b48ec83d5a, 0x3fdc379d7ed16a1b,
    0x3f80889b8205348c, 0xbfe1a0249ca1c653,
    0xbfe61e53e3842770, 0xbfe01278ca2f55f5,
    0xbf7a305464e385a8, 0x3fde34c987ffbc79,
    0x3fe7a88c0fb659b9, 0x3fe0ba55b1e9c6d3,
    0xbfbb39f32c9dcc42, 0xbfdf96a6a17344e5,
    0xbfe53b0f9da444eb, 0xbfdfbfbc11c419ab,
    0x3fa7cde8f087ff82, 0x3fdf257fe588ee80,
    0x3fe766033418c5c7, 0x3fdc99f92f0f269d,
    0x3f8d948fef7a9856, 0xbfe1f10ea347dbb1,
    0xbfe40f73512e306e, 0xbfe14a45b96e6e33,
    0x3f946cdbf9a7e984, 0x3fdb0b6f1feca23f,
    0x3fe39d830586eeb4, 0x3fdb8f1c969d8185,
    0x3f8e90cbd57441ae, 0xbfe1ba6d180ddad6,
    0xbfe77df37dff3d44, 0xbfe22be4be89dc71,
    0x3fa8728ab44806ec, 0x3fe1754361f7ceb5,
    0x3fe59d95447e1b37, 0x3fdc7610fff4bc0b,
    0x3f79ab2b7b63ec69, 0xbfda6853183eacf0,
    0xbfe6dcc4b8c9becd, 0xbfe0d32f4494ccdc,
    0xbf6bb3d313270c12, 0x3fdc7376f84b8c78,
    0x3fe62000b44597d3, 0x3fdc6a7a89adec25,
    0xbfb1b1c64b3547cf, 0xbfe2b3cc6bb74008,
    0xbfe656c68f9786dc, 0xbfdb67e274b368fb,
    0xbfa88f8df4d8cfcd, 0x3fd7f3474003323a,
    0x3fe5809d6900000e, 0x3fdbc6dd94e48036,
    0x3faa252eb021ed64, 0xbfdf3fe1989e2c1c,
    0xbfe56d04b4ec89e9, 0xbfdf522db33933a4,
    0x3fa3ac2716c207f6, 0x3fdf11429aa8f798,
    0x3fe60db4e5aef6bc, 0x3fe1145d0632631e,
    0x3faeb8b35ba2906e, 0xbfe093320652f368,
    0xbfe9ace24aa645b2, 0xbfdace4763a7d020,
    0x3fac49172e25f799, 0x3fdb85376253740c,
    0x3fe45899c375fbcb, 0x3fe0a50efa9e2325,
    0xbfaca2b1fe4ca65b, 0xbfdcd2126518cb2a,
    0xbfe68f19e72d4011, 0xbfe11eb88112ddb1,
    0xbf813140a52a1d65, 0x3fde0ff461357c47,
    0x3fe4d58df0132590, 0x3fe0d9017a2ac652,
    0xbf77c63b09b758dd, 0xbfdef883dad062ef,
    0xbfe603d9cc77fb70, 0xbfdd87aec25f0fe8,
    0xbf96bc18bb0c0e02, 0x3fe2e17e48df87c6,
    0x3fe568db432039b1, 0x3fdbbefcc8f856c6,
    0x3fba3884b94e1817, 0xbfdeed017c186af2,
    0xbfe74c53b5217052, 0xbfdfd469453f8638,
    0x3fa5903f0816d5d4, 0x3fe1a2b4c26cbe30,
    0x3fe62e050514ae52, 0x3fe1f8c102e19b03,
    0x3fa7b8a2a6a22308, 0xbfdc2c7ba3d2fd6d,
    0xbfe63c6794f6eec2, 0xbfdc8d1f7946ddd3,
    0xbf9a73bd70ac0e98, 0x3fe1a85a36520990,
    0x3fe1bdd7804df32c, 0x3fdd7b8ef86dd930,
    0xbfa81fa1cad8d4cd, 0xbfe22629d366ff66,
    0xbfe72de487b31462, 0xbfe1d8f90738f5dc,
    0xbfaa8d9f39bcffd4, 0x3fdbfd1e0f00fdb9,
    0x3fe77a6ec58da4d2, 0x3fdd1e94ab272bec,
    0xbfb33b28878102c6, 0xbfe0243b527cc0a3,
    0xbfe55d51b8fdcdfd, 0xbfe075a56314e546,
    0xbfa41b0400f76c21, 0x3fe1cd302acf2d02,
    0x3fe4c7ec87149b6e, 0x3fde97fe2e8962f8,
    0x3f86ec5f0c29b937, 0xbfd7f858e34076f0,
    0xbfe61fffa953409e, 0xbfdf68839b5819fd,
    0xbf8595144607783b, 0x3fdaf633ad2c2d29,
    0x3fe81418c9910b79, 0x3fdf9eada4ebc61d,
    0x3fa17b1aa3de9150, 0xbfe1acf0732e1b6a,
    0xbfe704cedc5652f7, 0xbfe1ec7b237177b6,
    0xbf954e8136761387, 0x3fddffeb0e6ab84b,
    0x3fe40cfcf2c539b0, 0x3fe1b0819753aaa8,
    0xbfab192b0f3930b5, 0xbfd723fc12e99b42,
    0xbfe841a7c17021c7, 0xbfdf58e771a4ac79,
    0xbf95dae312afdae4, 0x3fdc16b9f00a589a,
    0x3fe8f8ad0c92a74e, 0x3fe0fca539533313,
    0xbf9ab11c783fe068, 0xbfe1628f059a7fd0,
    0xbfe7eb43c547f956, 0xbfde7aa69a3ac97a,
    0x3f98344f6ccb7c52, 0x3fdcc58d5ba51589,
    0x3fe4b620bf49b255, 0x3fde50febcf144a1,
    0xbfb0d5cb5f79c517, 0xbfe3a01ae8e9d982,
    0xbfe56c36c0eebbac, 0xbfde20b7ae7064a7,
    0xbf97509b0d7fbe8e, 0x3fde753c9f26a668,
    0x3fe416213d26d329, 0x3fdb465a7d48cb9c,
    0x3f76ab7207f3e3cd, 0xbfe3f3cbe9a415bf,
    0xbfe470e9fe859001, 0xbfe05b06c552dbfb,
    0x3f8783ec50d88aa9, 0x3fe0dd5125ef5d4b,
    0x3fe67505ade65061, 0x3fdd1ab494f5729a,
    0xbf9087fa9af027cf, 0xbfde689f3898329e,
    0xbfe60fc1c674efb7, 0xbfe0ccfe8820ef30,
    0x3f6841784d454a8f, 0x3fdf2506f792e4b9,
    0x3fe64d4ffe4f8b26, 0x3fdbbe266b4766e7,
    0xbfac025e5812b21f, 0xbfe1d7aa5dbdd890,
    0xbfe7033933fd29b5, 0xbfe19a6b3725b2c4,
    0xbf9e687739c83968, 0x3fdeebe9909182ee,
    0x3fe4adef8744fbed, 0x3fe008df43f7ac1e,
    0x3fb388857846700d, 0xbfe4ee8d1b1ff12a,
    0xbfe8297d1d78df4c, 0xbfdef57c565e92b4,
    0xbfa15d0c9f7ecdf6, 0x3fe34660cf0d7d0e,
    0x3fea0d76ddf8a404, 0x3fdef335beb8b73d,
    0xbf8e5878a3bb1354, 0xbfdca052d22fe898,
    0xbfe67c1d2ee60c08, 0xbfd8d2ee6a16b35e,
    0x3fb207c12d31a08e, 0x3fe06991ace6e513,
    0x3fe5ab5109c3b54f, 0x3fdfde5816150ca3,
    0x3f93576109888690, 0xbfdc8368a0b8fcf0,
    0xbfe3d2957438a45e, 0xbfe0749f1cea6747,
    0x3fb1acf0a3b776eb, 0x3fe0b2d8739247ae,
    0x3fe6416442de026d, 0x3fe1a877b8311dbf,
    0xbf7bb9b4937eea81, 0xbfe26f87e630a595,
    0xbfe6fb4fdacbf43f, 0xbfe2025fe0385188,
    0x3fab4f147b7dac23, 0x3fe0ae5c530424f5,
    0x3fe5ab51def85834, 0x3fe135ca27856900,
    0xbfbdc830a4086922, 0xbfe1774d9e53bc97,
    0xbfe6d260cd3dc61a, 0xbfdc7a97e77a6a99,
    0x3fa1d8a01626a51f, 0x3fdf3cfb00df6050,
    0x3fe6b4a1c977864e, 0x3fd87054002b7a94,
    0x3f957bce91612046, 0xbfdc87c4a93dbccc,
    0xbfe6ce4cefcd1416, 0xbfe15546dd47c55b,
    0x3f660494faba08e9, 0x3fe09ef9285bf0f1,
    0x3fe5add6be99cb7d, 0x3fde7c0ee22a85bf,
    0xbf8826e1b94af569, 0xbfe1035934eba999,
    0xbfe7ba8c9a7d41ef, 0xbfd8d667af75361b,
    0xbf8ed201ab43485e, 0x3fded29785e572ff,
    0x3fe50f57fbe8b342, 0x3fe28509f45fab1a,
    0xbf88265a54b506f6, 0xbfde681ba103e974,
    0xbfe9666722ba3e8d, 0xbfdb7b36b89c0d3f,
    0xbf99702e165ce8b8, 0x3fe02dc97cf19016,
    0x3fe53410b9db05cb, 0x3fdafd72098bd7b8,
    0xbfb8d93072d2c881, 0xbfe08c6e34f5c29e,
    0xbfe71f03361c9256, 0xbfdb867bf8bcb1f2,
    0xbfa2c41e6477eda9, 0x3fe11627ad2d2127,
    0x3fe3d958a50976dc, 0x3fdc3a07877ed2f6,
    0x3f8c05934cdc720b, 0xbfe04b917d143ab0,
    0xbfe81b8c5efb4c17, 0xbfdba592cfd5df59,
    0xbf950a85ba696e4f, 0x3fe0f9bfa5bc7b7c,
    0x3fe59885bca89c76, 0x3fdf1ab75ac25a37,
    0x3f81be68e7ebf2bb, 0xbfe08aa8f18ccebb,
    0xbfe519354c78f0a9, 0xbfe0f1a53f51ebe4,
    0x3fa6cbef858eeced, 0x3fdd567adbb43ccf,
    0x3fe29a459807b4ee, 0x3fdf0a8a425bb75f,
    0x3f982277633f2ce6, 0xbfdfdb1b6816f03e,
    0xbfe825b7a72177fe, 0xbfe0a24886968cdf,
    0xbfaf3e40593f117c, 0x3fdc9141eb4b6e2d,
    0x3fe698bf6b0f3152, 0x3fe1f1d3178ead46,
    0xbf98c299a4f8e1a3, 0xbfe1c1d816e6ff1d,
    0xbfe79ada8e66aadc, 0xbfdf07ec37ecc48f,
    0x3fb37c50c867a138, 0x3fdf484abdc17c94,
    0x3fe7308896fd12a1, 0x3fe00644620a375a,
    0xbf91d5e99c99d184, 0xbfde260ab9230881,
    0xbfe6797d28e2a2ec, 0xbfd961e332c4715d,
    0x3f514a7032d9f7ba, 0x3fe0cf0baa69d487,
    0x3fe4b5dd2b741464, 0x3fdc84c7c27eb8b2,
    0xbfbb57cc1af6d386, 0xbfe11f78cc485b19,
    0xbfe81eb2f81dcbe6, 0xbfdee010e5fdd7bf,
    0xbfb8c26b1089b9b9, 0x3fdde808677e75fa,
    0x3fe73b15ba962d4e, 0x3fe30810870589b5,
    0xbf8f1a9f2e1bf833, 0xbfdfb8bccd29fd02,
    0xbfe65a55c9373a67, 0xbfdd6b320ab3c391,
    0xbfa7f39856b086dc, 0x3fdc0788330081ab,
    0x3fe6fab95e096e67, 0x3fe042277898a448,
    0x3fa6719e3bc73430, 0xbfdcb56d4b28bdb2,
    0xbfe688d62c325b48, 0xbfe1fb16853c4af2,
    0x3f839e4739607849, 0x3fdad5bcb1646ec8,
    0x3fe5c63c390b776a, 0x3fe175bfadce1741,
    0xbfaf959adf5802bd, 0xbfe0f1abd3a40dd5,
    0xbfe534afb4af1c8b, 0xbfe1407e102b3e47,
    0x3fa2aeb2da096e99, 0x3fe029736cd3aec0,
    0x3fe7dd88f7fa4ea1, 0x3fdf1a7e37749040,
    0x3f836e840d824288, 0xbfe145ea37576593,
    0xbfe7f376788abd9b, 0xbfde9350221f0b6b,
    0xbf9ba9e77e2d6c73, 0x3fe0297eb123276b,
    0x3fe6f22bb6afec74, 0x3fe0097962e51fd0,
    0xbf9690b97fd0fe46, 0xbfde68959900b3ee,
    0xbfe5d863fd242873, 0xbfdf28090f5b8fd0,
    0x3fb772c5347abde9, 0x3fe15117288d7122,
    0x3fe60eb536df5d99, 0x3fdf8ed8d250b78f,
    0xbf8970f2e6d55109, 0xbfdee482541a1b10,
    0xbfe433b5131a9370, 0xbfe095533fcb47b5,
    0x3f9e9c8f87dfaa65, 0x3fdfe52451c9cb43,
    0x3fe76a0fe23af5c3, 0x3fe0a225a9babd8e,
    0x3fa55fc87231b2d3, 0xbfe03ad42532b8ef,
    0xbfe9f4eea109b84c, 0xbfdd41a244e4aed5,
    0x3fb4b797a1061d94, 0x3fdb581d3fdd2730,
    0x3fe6035f09add1f5, 0x3fdf43c87a9c1285,
    0xbf7a790482320dca, 0xbfddf3a8d7ac0794,
    0xbfe5108a7e273e63, 0xbfe0ccaea5c2a5bb,
    0xbf88382354521aca, 0x3fe0e00c8a2ba810,
    0x3fe57e785405ab8a, 0x3fdfc1ff5ceb7e19,
    0x3fb56a3af69f5be6, 0xbfdfaa2dcc4f60ec,
    0xbfe553833dabcbab, 0xbfde73bd9a2f2bce,
    0x3f5037e2a244d2a1, 0x3fe03dd71faafa4d,
    0x3fe593596f8ca88e, 0x3fd9400946b0d01e,
    0xbfa11a257d68ca55, 0xbfe1110ca194901b,
    0xbfe834c49336b473, 0xbfde8110bedc5c44,
    0xbf8a157bf8763517, 0x3fe1de6cf5e30338,
    0x3fe34f678fd3dfca, 0x3fdff1aa69a6cae0,
    0x3f5f2595556189cb, 0xbfdc6015429d1e17,
    0xbfe73fcb515e27ba, 0xbfe11ea9c18bffe8,
    0x3fab709b1b610769, 0x3fdcafde41e7aa5d,
    0x3fe5aa57cf20fb27, 0x3fdcf2eba5865784,
    0xbfb3de35fbedbb3e, 0xbfdc03038c006cde,
    0xbfe46f2a1555a6ff, 0xbfe06dc7cdb63d49,
    0xbfa45713937c841c, 0x3fde833d1c4bc126,
    0x3fe6440600392dfa, 0x3fe33263ca1c335f,
    0x3fb0355661e12654, 0xbfdcdea7f64e5096,
    0xbfe30bf801b4062d, 0xbfe204654a0b0a52,
    0xbfade7e8fe494811, 0x3fde7f85a39cae44,
    0x3fe5a7e46683a630, 0x3fdb31438b8d0675,
    0x3f876634795ca053, 0xbfe0bf8479b42684,
    0xbfe585307315a5a8, 0xbfdfc2ec6dfa44cd,
    0x3f82fc27000a2f67, 0x3fdfe90ef9553fea,
    0x3fe7b916bc7ee92e, 0x3fdcf2a8f8be86f9,
    0xbf99b862c521947c, 0xbfdf3a5de2625015,
    0xbfe6c45c1b4d6227, 0xbfe023690636a3a8,
    0xbfac03ed93514af8, 0x3fe0cc3ce1f877c0,
    0x3fe5bc304832ab05, 0x3fd9a86d6139f4d6,
    0x3fa90c72298fb38d, 0xbfe0838b4c480ccf,
    0xbfe71958a1fe36d3, 0xbfe1fec8324835b2,
    0xbfb828ece88788d9, 0x3fe05a3096138c49,
    0x3fe48d8cb1c3e185, 0x3fe00411a5371711,
    0x3fa1aa0912d67645, 0xbfdf02432382dc69,
    0xbfe71db666ea8f5c, 0xbfded4f8a7c7c444,
    0x3f9c1b19e5a995bf, 0x3fe3127152a8a146,
    0x3fe6544e432551dc, 0x3fe17e3118ee858e,
    0x3f8769b73a0518e0, 0xbfe0253f3e10b1f5,
    0xbfe605ab050aca48, 0xbfe0d9e2813f5da1,
    0x3fa11f90969e4478, 0x3fdfafe56be057c0,
    0x3fe83bc2980fb4fa, 0x3fdd11817346d23f,
    0x3f9a0b3b74e58834, 0xbfe0170fcba257be,
    0xbfe9ae3bba01435a, 0xbfe12522eeb70ede,
    0x3fbdfbd43bea5e78, 0x3fdd264397302cb4,
    0x3fe48e42a0646583, 0x3fda731ea8f30e6d,
    0x3fb0366e4bd4caef, 0xbfe0b69f4c3099cd,
    0xbfe91f29f11c4748, 0xbfdf38951884f567,
    0xbfa606e253a8ad7b, 0x3fddb75dee87bfe1,
    0x3fe627221cc4da3f, 0x3fdc1d47510bf787,
    0xbf749a1a7bec8a41, 0xbfe28aeab0a090ba,
    0xbfe76ce5d06305db, 0xbfe054ddef1b29a9,
    0x3f89d24ae90a52c7, 0x3fdf7b9d7903e86f,
    0x3fe76bfd38d16649, 0x3fde747bdebb19a7,
    0xbf9ba94fc73cc72f, 0xbfe18c35fa8a99fe,
    0xbfe4b4d126f8fefa, 0xbfe18d73565d08de,
    0xbfc0640f2fed3585, 0x3fe15fa257d25d3a,
    0x3fe95fef999067b2, 0x3fdfee47af1a41af,
    0xbf8c3b5583b573fe, 0xbfdbb666d0e9ed3c,
    0xbfe39fb337638a99, 0xbfe09876f4139046,
    0x3fb51a4f4bac318b, 0x3fddec40d323e118,
    0x3fe6b0c499b54a4b, 0x3fe1a1d2b930ea83,
    0x3faf10f1a3d6a804, 0xbfdea041551b15f5,
    0xbfe8a4baa2112dc3, 0xbfdc229993ce2b63,
    0x3f4df971ced33ae4, 0x3fe10d0544705d56,
    0x3fe809fdc94f52c0, 0x3fe164c729ebdc40,
    0xbfb558624274b0f1, 0xbfe0f0567220c847,
    0xbfe690e61af8a834, 0xbfe094cba9267f54,
    0xbfac3d4ac50c17c3, 0x3fdc190bbf01bedc,
    0x3fe7f024fc028743, 0x3fe0837804b0feef,
    0xbfa15c105d9b3842, 0xbfe3a4425b58a894,
    0xbfe7cf9c2c48e7a0, 0xbfdadcd72f6c2ea2,
    0xbfae6e74b4eee63f, 0x3fe0946e830fe009,
    0x3fe3174314ec67e4, 0x3fdc0f8fb078ee92,
    0xbf8e90de70d5ea8c, 0xbfdd2a12902d0c5a,
    0xbfea59da81b6080a, 0xbfdc50e052567814,
    0xbf53bed6fc7d009c, 0x3fe0582b55f388a4,
    0x3fe3e24145c6a7bf, 0x3fdee7291504bf67,
    0xbfb1f960df8b3db6, 0xbfe1d152c9c51f13,
    0xbfe308092a1e82f9, 0xbfd9e4dc71602968,
    0x3fb6edbd79dd41c9, 0x3fe0483209f7d750,
    0x3fe74e5104f08164, 0x3fe0c72647882963,
    0xbf7fdd24ff00abe3, 0xbfdc6bb86e362ffc,
    0xbfe9bba79c7daa00, 0xbfdc6c69dcb856aa,
    0xbfa092c6db425900, 0x3fe2bd5ef54085b7,
    0x3fe77c269a238607, 0x3fe11abfa7f8120e,
    0xbfb11bd8d44cccbd, 0xbfe1cde56793fcaf,
    0xbfe7725b25556673, 0xbfded9d0b9900b8c,
    0x3fc246fd157c45e0, 0x3fe056a9a8f44312,
    0x3fe58c57968340e4, 0x3fdd63937ab7af5f,
    0x3f7f47fb17378366, 0xbfd9598bcaf932b3,
    0xbfe8d5b9e393d875, 0xbfe0fda628045e73,
    0x3f95024a740c4f2d, 0x3fe1f7e43f9fa698,
    0x3fe4b02372ae1484, 0x3fdc6b5d8243ec35,
    0xbf9c53c56a2824e6, 0xbfde01dfa09ff8c5,
    0xbfe81c08bd9d4fd7, 0xbfdd84906e581e77,
    0x3fb297c1a5f4e8ec, 0x3fe1d0f054995a96,
    0x3fe6282ac96321f5, 0x3fdb085fc9da558f,
    0xbf56416df7e71a66, 0xbfddefd10be57f9e,
    0xbfe589586b1f46c3, 0xbfde90df74563b72,
    0xbf907e7c1101f38d, 0x3fd90f4ac355cdba,
    0x3fe5e3b594119b48, 0x3fe191529a0f6edf,
    0xbf6a3a24ebd44ec6, 0xbfe087e5fd366924,
    0xbfe5b3e198b02c29, 0xbfe0e1f1124ce279,
    0x3fbb3ec01fa55ac4, 0x3fe253fec5d5e48b,
    0x3fe6eaae3674d908, 0x3fe1196c84e340b5,
    0x3f867c06f5086f70, 0xbfdb7de18c593a09,
    0xbfe5c407cace7e38, 0xbfda47a07e3ec301,
    0x3fac8cc92a7ae837, 0x3fe27ae48173ca5f,
    0x3fe6d31413a0f4cc, 0x3fdb553fa25df9f0,
    0x3fc1292604688a16, 0xbfe168eb5f76061c,
    0xbfe52754bfb73be1, 0xbfdfb217ac7d8686,
    0xbf93bd3dbcd99562, 0x3fe09b21b0c0de41,
    0x3fe7f1a05822901a, 0x3fdf70788df01899,
    0xbf99cf1369860a8e, 0xbfe04d663e000061,
    0xbfe71230b9782a60, 0xbfddf463bea23d50,
    0xbfa59147b45adf86, 0x3fdeed35da116354,
    0x3fe70b434bdbb177, 0x3fdd25c1757eebcb,
    0xbf9d3b8b5d50ec7c, 0xbfe069439b4c2853,
    0xbfe5c8f0e978fc50, 0xbfde247fde0b7389,
    0x3f7ea40930dcda8b, 0x3fde9eea0f1b3986,
    0x3fe5ec3bb3a82ebd, 0x3fddb5c56a2d8ecc,
    0x3fa4a8e257c2418a, 0xbfddc5e14ba6ba48,
    0xbfe684a3d66cad5d, 0xbfd8e6a0d2ab69e2,
    0xbfb1f7e94ccb3cda, 0x3fe0bad9ef81eedd,
    0x3fe5e67dab3e67ef, 0x3fde5665da334712,
    0xbfb73da0e4f21184, 0xbfdd2b25cf03f7c6,
    0xbfe72f2d3720bbd8, 0xbfdfddb367b0fc38,
    0x3faccc9858565b20, 0x3fdbf30ae2f634ff,
    0x3fe61c9090af469c, 0x3fdcf8cda04d472d,
    0x3f510a158f77c8fe, 0xbfe02df4ede2dff8,
    0xbfe8e77db2d8aa6a, 0xbfdcfdcd4b0d63ec,
    0xbf962d47268f11db, 0x3fdc44ca36050892,
    0x3fe953fae4b19834, 0x3fe0f2c116699f3d,
    0x3fb56c0dc2548eec, 0xbfe0d71e202d748a,
    0xbfe5ea2f26798993, 0xbfe0b7ddf4ed6709,
    0xbfc16abdcfcb5328, 0x3fe00e04d0a2957f,
    0x3fe40db3d7903ec7, 0x3fdacd6d43b50230,
    0x3fbdf02fe125c724, 0xbfe009c56bc65f5b,
    0xbfe6617cef9d499d, 0xbfdcd7d7cb8aaf68,
    0xbf9ceeda6b262439, 0x3fdf4c0987f46a50,
    0x3fe70e4b688c1273, 0x3fe05fe407a8bd99,
    0xbf9234c4e8d76d5e, 0xbfe15400ea85244d,
    0xbfe5942b2ae90fa7, 0xbfdc5368815c35b7,
    0xbf8e00e62a3dd518, 0x3fe09b8752add287,
    0x3fe3686674f07f9f, 0x3fe35c9f13a5dbab,
    0xbfba0fae82a48fbd, 0xbfe00459cf41200f,
    0xbfe5a76846483812, 0xbfdf26416079f94b,
    0x3fbcb11f3e43f1e3, 0x3fde7ffd94835a3d,
    0x3fe8e2256cef14b8, 0x3fddff9a1a272e9c,
    0xbfb11ad6cc8f4017, 0xbfde24376dfcd1a4,
    0xbfe679cf9512e229, 0xbfe0727b61fe94c7,
    0xbf979b8e903b4dac, 0x3fe2885c1f8c0ae0,
    0x3fe797563459ca61, 0x3fe07d3d15cd19f3,
    0x3fb827f4d0e9ed78, 0xbfdddb1905dd2c9b,
    0xbfe5d7df4d54059f, 0xbfdef63a1b520a8c,
    0xbfb7c9d8b33ed939, 0x3fe0b76657ae891c,
    0x3fe4561f5f5c6921, 0x3fdec61eaeb901da,
    0xbf4a802f6037312b, 0xbfe070ae0f7c2659,
    0xbfe4c1a0b980f45a, 0xbfe12f7d2f67564a,
    0xbf947a71c8e77e86, 0x3fdfe57881b3f1f3,
    0x3fe2da191c140f88, 0x3fdb7f2ed0966f98,
    0xbfa58ab5cd468bc8, 0xbfdd2d48c7a802b0,
    0xbfea38e6e3d966b9, 0xbfe21d2a9244d78f,
    0x3fb3bcd133db85b9, 0x3fe0658354c7568b,
    0x3fe54f7e4a39a3de, 0x3fe00f8822757728,
    0x3f9996805c62ebe9, 0xbfdb561040be9afe,
    0xbfe6380d7c9653e8, 0xbfe0d59cf50cad85,
    0xbfa69b02cc359405, 0x3fdc84949923a418,
    0x3fe4433e03ec909d, 0x3fdf1ad5408975da,
    0xbfac5a316e24a088, 0xbfe1896b1d6f906d,
    0xbfe78b50fef50743, 0xbfdf296be7ece37d,
    0xbf914bec89666691, 0x3fdb216da7fcb663,
    0x3fe7e83cd5069623, 0x3fe28d2c910fdbbd,
    0xbfa5a4a410ddbf61, 0xbfe0507a2fd08d42,
    0xbfe7005dd56bc6f1, 0xbfde4c57538f3f1c,
    0xbf86962821453daa, 0x3fe05e476f03a6b9,
    0x3fe82dc4ecf3380c, 0x3fe13acefabc2fc3,
    0xbfa315a40a7935fb, 0xbfe066d965706c42,
    0xbfe5deb426a0c4e7, 0xbfe0bb2be7757323,
    0xbf87574cd556a40f, 0x3fdb4f38f43d8576,
    0x3fe700886cb64d9a, 0x3fe1473cb5fd858f,
    0xbfa0add6dc30ab05, 0xbfe1900f3bf65ec4,
    0xbfe3f6ded108a9f2, 0xbfde63e64ed725fd,
    0xbf98333ede91239a, 0x3fdf7ceab673fd97,
    0x3fe6585382a33728, 0x3fdf5318a488077a,
    0xbfa6d7d2e17e4537, 0xbfe1b15d427daa93,
    0xbfe68c428d90de4f, 0xbfddab28751e00fd,
    0xbf9328fb1b7f07b5, 0x3fdaf4972c472493,
    0x3fe6b1ca12b06364, 0x3fe278eed249f45b,
    0x3fafedf53c8799a2, 0xbfdeb88744694293,
    0xbfe68d5b3b0fa61a, 0xbfdd93b774f7f60d,
    0x3fb1e44838892df2, 0x3fdfbb46dcc3509b,
    0x3fe5ff1ef517b95a, 0x3fdef8346bdf756e,
    0xbf958a67f3ea2135, 0xbfe2288224b2b78c,
    0xbfe6cdee0324a362, 0xbfdcb8d8dfe1bddd,
    0xbfabb706b2d44930, 0x3fe0cc2931c26fa8,
    0x3fe74ffefa0594e2, 0x3fdbb74305a18e91,
    0x3f9c6fb696d13e05, 0xbfdc6e00eccb4fc8,
    0xbfe56246c8ba99ad, 0xbfe1e3b2ce04d5a2,
    0xbf89cf86ffa3d6fe, 0x3fe10768bc1b0a9c,
    0x3fe975481163ee66, 0x3fe43fdaf6f71f41,
    0xbf98ac2c38eae783, 0xbfe108bbda2c6e70,
    0xbfe72854960b0b32, 0xbfe2f791b1e0b66c,
    0xbfa11622622281df, 0x3fe2e04a346ba99a,
    0x3fe5235c4efc3431, 0x3fe1f803eeecd9df,
    0x3f8ed34b3e091fcc, 0xbfdc204b47d2c04a,
    0xbfe6392970ea5fbc, 0xbfe0cdcbffaf26dd,
    0x3fa6dc0d4490a8f6, 0x3fde4f2c0ad632ec,
    0x3fe6ac848969013a, 0x3fdd3c58046b0fe8,
    0x3fb0ee6f5530255f, 0xbfe4b285dfee4180,
    0xbfe5747663f2cb87, 0xbfdd3736cc051c44,
    0xbfb33a24ba283aa8, 0x3fda32b577f25510,
    0x3fe49618d3bc1aa2, 0x3fe2e72799d5bb3a,
    0x3f96c9cc1b639fa9, 0xbfde8e52a257cf3b,
    0xbfe5907102facb24, 0xbfdd6fe0f1077333,
    0xbfa237f9cd630f0b, 0x3fe2466bf29ea244,
    0x3fe58acb88f7cd83, 0x3fdd962af5e0fc95,
    0xbfa43807e9763b16, 0xbfe224ecaf0768e6,
    0xbfe5c7c15781d869, 0xbfde0e52ee185d66,
    0xbf9b579909ae216b, 0x3fdcff21aa28a659,
    0x3fe98fbb0e51c28a, 0x3fe12f0aa3ac0d23,
    0xbf9c3493c85f5a48, 0xbfe1e8f43f282f0b,
    0xbfe915b9b9c85ab8, 0xbfdf4ca114bb3191,
    0xbf9fe04a6918af99, 0x3fdded8ecdf7c668,
    0x3fe7874c24f5da44, 0x3fe0b55822baafbf,
    0x3f4b586cd151d00a, 0xbfde42000ac44757,
    0xbfe6f4232abcbb80, 0xbfe07dfc00156ccb,
    0x3fb5315fcbd12141, 0x3fe0e3ed7263987f,
    0x3fe337177f660260, 0x3fdd935be0914f0e,
    0x3f820f9c18dc166a, 0xbfe07269e92bd14c,
    0xbfe552e15fbaa8ae, 0xbfe17095f5cd2f55,
    0xbf7108d87c3c5598, 0x3fdf746a0f62e618,
    0x3fe7ebcd94eb46e0, 0x3fe00c907142d6fe,
    0xbfb5d41ac7f697a3, 0xbfe0773ae940b538,
    0xbfe63dc558d522eb, 0xbfdec3e374ffb71a,
    0x3fb5ea3840179d38, 0x3fdf906ada7da588,
    0x3fe847e37229fe83, 0x3fe25788d4890a29,
    0x3f9f8ce71947569d, 0xbfdda67f0e47702a,
    0xbfe64fc947feed5e, 0xbfd8cdc3ad0596e5,
    0x3f746025c79779df, 0x3fe1e770b249c0a2,
    0x3fe6bf684cf86660, 0x3fdf1e29e57449f2,
    0x3f95d599ca888835, 0xbfdaa1feaf7ce382,
    0xbfe6f32b5b64ec60, 0xbfdb7c6694371c4b,
    0x3fa7ec0fffbb8d5d, 0x3fe111796e996418,
    0x3fe6855a73b793d8, 0x3fdbe6ef9ffff060,
    0xbfac4f612739eccc, 0xbfe0cecd0c447464,
    0xbfe7b20ee9dbdb40, 0xbfe1c1f59279488c,
    0xbfab0dcc751ecf92, 0x3fe13f8b9ec3b855,
    0x3fe5405b23103b7e, 0x3fe175e566d89c95,
    0x3fa01b6b0128b653, 0xbfde3e21ade38f68,
    0xbfe3e2d68d993b50, 0xbfdbae312d653d87,
    0x3f91167d4eba9d36, 0x3fdf7fbf2a285efe,
    0x3fe649a1bf1e8c0e, 0x3fdb72c2d585ea18,
    0x3faf49208dd8626b, 0xbfe0a950d20b53cd,
    0xbfe82526d95c3371, 0xbfe00a00a70b05d3,
    0xbf9d13ba78132855, 0x3fdee8d8eb101b79,
    0x3fe6ad7030380757, 0x3fe177f52a77d115,
    0x3f93a9e8cc632e87, 0xbfe0813c266e88d4,
    0xbfe6cfb5ec35e42b, 0xbfdca7aca48109f0,
    0xbfa8430e2c27e336, 0x3fdecbd38c9fa4b0,
    0x3fe2640532a35e35, 0x3fe0460cb90967b7,
    0xbfab800aa2a19b6e, 0xbfdfbaf59d44fea7,
    0xbfe5bda37e66a3fb, 0xbfe12ace30e43fe5,
    0x3faee44c53c56e85, 0x3fde025b959f674a,
    0x3fe8ddf1d7e31bc5, 0x3fe001da12874737,
    0xbfaa0af69c38719b, 0xbfdba6f00d696cbb,
    0xbfe7605fa02190aa, 0xbfdcfafd6b68fc9a,
    0xbfa4b5344aca0544, 0x3fdde66cbf6176fd,
    0x3fe935cc2e1b7d25, 0x3fdd02d765471564,
    0x3f97abf090912071, 0xbfe1c7c954557d12,
    0xbfe738b1197b44c6, 0xbfdcef2e9f1444e6,
    0xbf90704cbbb2d361, 0x3fdba86d0da1fc96,
    0x3fe681083f0a0560, 0x3fe064760a4c7fee,
    0xbfb15506d59d04a3, 0xbfe0208e8044cf89,
    0xbfe7baf597897354, 0xbfe21bad0c4893ed,
    0x3f976f197eb4b414, 0x3fdf137556b10daf,
    0x3fe7096822b97d0d, 0x3fe18181e02592b4,
    0xbf6c391695548320, 0xbfdda626b0c50ea6,
    0xbfe53d46a2680401, 0xbfdedd18a7029148,
    0x3f57148ab9600fb8, 0x3fdb89485e49c132,
    0x3fe7ba6e2c51a89b, 0x3fdcfd159aa3f076,
    0x3fa12b7468bfcb72, 0xbfdf438c84d6d08c,
    0xbfe5a41c11eb1385, 0xbfe1341331389fe0,
    0xbfaef77f94d4ca19, 0x3fe01f88ae94270e,
    0x3fe64f995720a8b1, 0x3fdd6c25133d26d4,
    0x3fbd30acbdf0b039, 0xbfdd1dadddc115e5,
    0xbfe5a784090e1066, 0xbfdc1caaaffbbf46,
    0xbf86b9f6e383a313, 0x3fe11a111351b788,
    0x3fe62d239757ff46, 0x3fdd6b62db079071,
    0x3fa44cd05ea07dea, 0xbfe21f51a6aa2d6e,
    0xbfe859a8799215bb, 0xbfe187ec404e177a,
    0xbfac43b8a2de43d1, 0x3fdc5028aa6011dd,
    0x3fe9057bd653a328, 0x3fe08afa1132622b,
    0xbfa1a8af401a5b16, 0xbfdcade119d92c3e,
    0xbfe5fad29df0d7dd, 0xbfe11c894764c752,
    0xbf90c3f09afdd0f4, 0x3fe19e528740551e,
    0x3fea81f28410df68, 0x3fde3dbca0cfbca7,
    0xbfa08a4ad10418d1, 0xbfde24b90953110a,
    0xbfe3197258889808, 0xbfdd4d63b4c5c187,
    0xbf17f9005057d8f9, 0x3fe0798594355b8a,
    0x3fe6ad4d213b4e8b, 0x3fe0b7555cf9c654,
    0x3f985f8bd07446af, 0xbfe15f7dfd71708f,
    0xbfe6f169b6e0caaf, 0xbfdcd1d74ec32ba5,
    0xbfb14117f68b4fef, 0x3fe071cc3f9eda3c,
    0x3fe651a1305da620, 0x3fe1da126ef486ca,
    0xbfb6bf1839ac186a, 0xbfe03c3f5432c2c9,
    0xbfe5f154f4e0abbd, 0xbfde821361f3e3c7,
    0xbf8cf666a3445e35, 0x3fddac5fc9e5bec8,
    0x3fea1b0c81315192, 0x3fdf8bb0b3e464e3,
    0x3fba03da40e6f746, 0xbfe0fcef0c3574db,
    0xbfe4ca33c7516b89, 0xbfdd3fbd128cf81e,
    0xbfa480df567903aa, 0x3fde51248c141ff0,
    0x3fe676ae917f7a01, 0x3fdc4ef89839340a,
    0x3f93480757b67499, 0xbfdb57f366b1a22a,
    0xbfe7a90c1865084b, 0xbfddda8f9d45c92e,
    0xbfa6ff710acc834e, 0x3fdf117d1ee832af,
    0x3fe62383e3e62184, 0x3fe03ab66453ea38,
    0xbf97d346b0ce8d2e, 0xbfe014d5b3505d0d,
    0xbfe6f657ccdf9b00, 0xbfe0cc430306d228,
    0xbf81d9365313825f, 0x3fdfcf3ec9e2ff61,
    0x3fe6fc8c8e3ff383, 0x3fde6378b40745e0,
    0xbfadcb13f7260f42, 0xbfe1bbbc896024c8,
    0xbfe6892cebae8b98, 0xbfe2394110101d5d,
    0x3fa90c09b137dda7, 0x3fe0bc7d5b7aeae6,
    0x3fe6709ea2bf1b5e, 0x3fe185f3a781556d,
    0xbf864117d5b02d89, 0xbfdccb75e2fa3a1a,
    0xbfe7628532633c8b, 0xbfe02395b7bb50f8,
    0xbfa54fe6d79c5e0f, 0x3fdd497286b45574,
    0x3fe524695e553e06, 0x3fdc36261cdb6568,
    0x3fbee48563457862, 0xbfdefb79f7042565,
    0xbfe855bec7758230, 0xbfdc23caa6719e68,
    0x3fa9d9ae420b8aa3, 0x3fde50093fe553a1,
    0x3fe60dd14c58d8d6, 0x3fe044e9434bb96a,
    0xbf805c663dd324e0, 0xbfe1c09ef4466cae,
    0xbfe89d8cde6ac487, 0xbfe072d354dfec02,
    0x3faafa484d39b002, 0x3fde8329145223c7,
    0x3fe8c72c34df688b, 0x3fe2159be759ab22,
    0x3fa465fb50fe34eb, 0xbfe113201e24a1bb,
    0xbfe90699f8684753, 0xbfe40feb1a414777,
    0x3f8ddb503e801ce2, 0x3fdd600f3294e30e,
    0x3fe7b280c2ad9806, 0x3fe00e47c4d97f03,
    0xbf9cacfd2b786a65, 0xbfe32e1047f64553,
    0xbfe38d5b9436bbff, 0xbfe06b4446b033b3,
    0x3f85822f4f416849, 0x3fe10255d24c6f82,
    0x3fe4d01345e8efd3, 0x3fe0bceee5a0b340,
    0x3f8fa1a9dffe6ed6, 0xbfdb05857f039ba3,
    0xbfe596c0102a42fb, 0xbfe2bde608d5e7f8,
    0xbf6536a807602eca, 0x3fe0c7232c68b1c7,
    0x3fe643bed2c796f3, 0x3fe360d3c65c33a4,
    0x3f9009da0b4484e2, 0xbfd957fc44ab7914,
    0xbfe6ae4c318cea14, 0xbfe0b351f740c206,
    0xbf459c7468ddc0da, 0x3fdde0e7d7bfaa60,
    0x3fe529fe889db23c, 0x3fdceec1db747706,
    0xbfad4906c70c3ebc, 0xbfdfa7f61ed75284,
    0xbfe4f4c25b1570e1, 0xbfdf49080f169e7f,
    0x3fa587ef3236102d, 0x3fe040d942d956e3,
    0x3fe63ac5bad3fa6d, 0x3fdf9ec3abacc47a,
    0xbfb0e832ad679a1d, 0xbfe03ae268dec1a3,
    0xbfe65b5effe95be4, 0xbfe3b1925fcca40e,
    0xbfaafc9020a85f95, 0x3fdaa0acfd950822,
    0x3fe6fe09b6df69ec, 0x3fe0560bab802c41,
    0x3f8fbf3dcb500773, 0xbfe2c7ed0f8c88f5,
    0xbfe4f634afeee4d3, 0xbfdfbc2ffa6d48d3,
    0x3fb9a55cefc96b67, 0x3fe04aaa52935871,
    0x3fe63a1653815442, 0x3fe3fd71cf11b218,
    0xbf82a9b913d39481, 0xbfdf231576f19fc3,
    0xbfe7edd38e9fc606, 0xbfdc05516a133f1f,
    0x3f9e7ea20292a87b, 0x3fe27a193b757d7a,
    0x3fe500cff8691e7e, 0x3fdee91ca965d86c,
    0x3fa4a24ae3386425, 0xbfe0d47274e88e7f,
    0xbfe82dc596f23368, 0xbfda77e18f02d4a4,
    0xbf89ad411960735b, 0x3fe14d971c6b26f2,
    0x3fe5a406fb38aa44, 0x3fdb458c9bb7f69b,
    0x3f82ef48dbc63bee, 0xbfdeb73809346314,
    0xbfe54d0fe71e9962, 0xbfdef5dffb57e184,
    0xbf828aafc472a84e, 0x3fdda32dfc81db68,
    0x3fe4e183edef25b0, 0x3fdbf1786c7ddeb4,
    0x3f9fd63b4d873a5f, 0xbfdd47790fbba73d,
    0xbfe378e8d7ddc6e8, 0xbfdeea6232693096,
    0x3fa2e1e34b8190a7, 0x3fe172c58596a440,
    0x3fe300e03c00fa4b, 0x3fe104e9bebe3400,
    0xbf81c346ba0db700, 0xbfde6e5fd95175e9,
    0xbfe660af2ee768d8, 0xbfe09424f47932d4,
    0xbf8a573582884a95, 0x3fdc943d243b4327,
    0x3fe27e50adde9aa1, 0x3fe2606fb422ad1d,
    0x3fadbc178e300afe, 0xbfdf902ad0d9eef9,
    0xbfe69b9c130d6466, 0xbfdba6eae4380624,
    0xbfa4312c5507dec8, 0x3fdb7ca1e7beb0a8,
    0x3fe77f572d2b60b7, 0x3fdef0572a6fe67b,
    0xbfaaa5ac8a317e53, 0xbfe37029f3437c08,
    0xbfe758e7fdb32495, 0xbfdea46b6355d014,
    0xbfa5efb3f773de0e, 0x3fe026dc89a617a8,
    0x3fe7fa9245b14203, 0x3fdec6f1edfa23ab,
    0xbf9732cb39a5fe36, 0xbfe29be918f05180,
    0xbfe6107303849144, 0xbfe16cc08f8efbf1,
    0x3fb7e7046453055a, 0x3fdc6f3c91663aed,
    0x3fe6987e6f9ecde6, 0x3fdf922d6ef51e43,
    0xbf8a5ed9aba226c2, 0xbfe0352e57b1f38f,
    0xbfe6f74be0a30344, 0xbfdece9231ead128,
    0xbf93d060dda113af, 0x3fe2b79d25ca49b5,
    0x3fe4db48370cbd65, 0x3fde85b2c8459673,
    0xbfb4b764e31ab1aa, 0xbfe0964998c58ef6,
    0xbfe8e2f312d8bf55, 0xbfdd89e8b8ea5773,
    0x3f909ec61e070890, 0x3fde83f1351ac04b,
    0x3fe7144b80a36c50, 0x3fdfa1f2a67d0813,
    0xbf6ee950a8a74e86, 0xbfe028875af3cfdc,
    0xbfe6d2091fea540e, 0xbfdc1b6b113b6c12,
    0x3faf3c89e37cb34c, 0x3fdf9538c4f25441,
    0x3fe4f0a6a29317ef, 0x3fe04c75027353c8,
    0x3fb1e55ac9ff58c2, 0xbfe091ff49d43efa,
    0xbfe770d7eebcbc9f, 0xbfe1b9a19a08152b,
    0x3f97219979ba04b9, 0x3fe01f2b360d6b8d,
    0x3fe4450b8f24da78, 0x3fe089949343090f,
    0xbfaa35cd28b8b1ac, 0xbfe24fb61e882f7a,
    0xbfe429fd8a888ce8, 0xbfe0dbe36960e589,
    0x3f9b49f6c6508260, 0x3fe149367f15ad75,
    0x3fe6fe8879abccb5, 0x3fdebef9b3b71391,
    0x3f8b27e785259775, 0xbfde0aab88229fd8,
    0xbfe5eb8def13d0ec, 0xbfde6dfb5d0a0cc3,
    0x3f7ffa4b5ed44e36, 0x3fdf450d9468c19a,
    0x3fe96a83a8f1ec16, 0x3fe0379029088f94,
    0x3fa11cc693b8f7f0, 0xbfdf5e75713fe7cc,
    0xbfe59ae920d46294, 0xbfe37c51b08781f7,
    0xbfa114f9fc3be48a, 0x3fdc6efede529299,
    0x3fe9d0be18eb23ba, 0x3fe08120568e575f,
    0xbf553bbe8d4e04df, 0xbfe1ff552e015ed1,
    0xbfe86c37b5f3bc77, 0xbfe02c7942b12959,
    0x3fa114b6d6b306e2, 0x3fdefe0bfe2326c4,
    0x3fe6d9a72c6b052a, 0x3fdf1bdf20f6a6e9,
    0x3f994efde99c48a9, 0xbfddd37be06fcf04,
    0xbfe708ccb96518c6, 0xbfdca3c01ca20c32,
    0x3fb4e81030e8bcf3, 0x3fe0158dffd2e137,
    0x3fe798246bb082db, 0x3fdb549ce819011c,
    0x3f6ac90da1dc5196, 0xbfd90682210d09e8,
    0xbfe878ada0f4c243, 0xbfdf3075caa3d317,
    0x3fa5cd8e95edef63, 0x3fe271c72c3e2336,
    0x3fe7ebcbf20b30a6, 0x3fe1520fd37d7bd1,
    0x3fb24c9007cad35d, 0xbfe13060c108b751,
    0xbfe82aa38216c5a0, 0xbfdf67b9d50b37f5,
    0xbf8229a00b37ca57, 0x3fe106d51a61e41b,
    0x3fe453b4840af788, 0x3fdd1669c24c5294,
    0x3fa53bf9b5df6c32, 0xbfe2ea8773e60e9e,
    0xbfe511e034c32506, 0xbfe219672c43602d,
    0x3f90db172798215a, 0x3fdf2a9a4f035141,
    0x3fe60145d2411f79, 0x3fe1b5ef5397244d,
    0x3f8b5295425c92f0, 0xbfdb9263c81d849e,
    0xbfe6065dd57918b3, 0xbfe015e39634bf55,
    0x3f54fb3e9ba96fdf, 0x3fddc7293876c0c5,
    0x3fe50529e8c35fac, 0x3fe1740a8a6645f0,
    0x3fac1fb3a89bd8b9, 0xbfe16a760867f81e,
    0xbfe4cc2f6a0af382, 0xbfde37799014a438,
    0xbfa5a1d95eb6c841, 0x3fdc7d20d501da86,
    0x3fe72b158d438346, 0x3fe03f98ba8e1e68,
    0xbfbec6f9b0c0eff4, 0xbfda892a88a15c35,
    0xbfe4dd2f64bf77c7, 0xbfe0827a0323360b,
    0xbf6d4521ffd96b33, 0x3fe166a8c67ed5be,
    0x3fe6287f721ccc9e, 0x3fdbbce625bea471,
    0x3faa59e78ca0092c, 0xbfdf4673326b95d4,
    0xbfeac8b8192576a3, 0xbfdf22a06b48cdad,
    0x3f9847a0cbf5e6a6, 0x3fdfebe863ca458f,
    0x3fe4951c66593492, 0x3fdc0a405b46f641,
    0xbfa22e16d501857d, 0xbfe1dbf88cb2ea53,
    0xbfe6af86a9bb6697, 0xbfe058914d0bdba4,
    0x3f6c3d806d124e26, 0x3fe0a8cafe9860d5,
    0x3fe7fd599077ad0d, 0x3fe1849ba991dc95,
    0x3fa86aa55dcd09f5, 0xbfddb5eafea65eec,
    0xbfe4b3e6f50bb5af, 0xbfe020ac4a9eeabd,
    0x3fbaabcbb1b35e2b, 0x3fdc358c98da628a,
    0x3fe755c7373ab653, 0x3fe044eb86c00224,
    0x3f98bd58de520144, 0xbfdb44d9a125c6d7,
    0xbfe3c45dea206a04, 0xbfe29b92bac2ba32,
    0x3fb11fdd9dd588ef, 0x3fdc2936ba46313a,
    0x3fe76d9f9617cb89, 0x3fe0c550641af846,
    0x3f95bb462ad91d2c, 0xbfdac5855266147d,
    0xbfe5f7a48eb86d0e, 0xbfde10719cdd45f8,
    0xbfa3a11117589a82, 0x3fe33f24c051373e,
    0x3fe7c99412302749, 0x3fe1027c782129b5,
    0xbf93e09d625d3e9c, 0xbfe1fd9bfaa5d15c,
    0xbfe4528e5ea5bc5e, 0xbfe0a6f9b36acbc3,
    0xbfac8a372cfe9843, 0x3fde88dd55e4ef07,
    0x3fe65335d7eb5922, 0x3fde46b696027b11,
    0xbfb121dc481e449c, 0xbfdfe42f556fe09c,
    0xbfe75261181fb756, 0xbfdd65b1acaf2974,
    0xbfa5eda229537dad, 0x3fe076b028219288,
    0x3fe5ae55ddc7c881, 0x3fdd9eddc7761bd5,
    0xbf81ff892c6326f3, 0xbfde7eed46768bc0,
    0xbfe48193f3050898, 0xbfdf9d7ae9e55735,
    0x3fa0644ef03e0443, 0x3fdcacc6ec62b722,
    0x3fe62e0f9e7a75ab, 0x3fddf6e5b5a0e062,
    0x3fa388e6ea9047e4, 0xbfd8f05d706ea583,
    0xbfe6fc143c0f5968, 0xbfe1dfb8b4bd0721,
    0xbfa4985794dfda0d, 0x3fdccc179e221201,
    0x3fe74b9f8ce47042, 0x3fe01a227e9ef558,
    0xbfb07594570c5957, 0xbfe243530e42a458,
    0xbfe4f469e3e2f721, 0xbfdf2cf1c662a8e3,
    0x3fa5db0e2b2e46f4, 0x3fe08509e8542562,
    0x3fe90225230f4586, 0x3fe3336646c7701a,
    0xbfb3955b73e7cf00, 0xbfdccc550ca93188,
    0xbfe68f261a7680df, 0xbfdd7138717108fd,
    0xbfaac51fe94aab80, 0x3fe2318159d0a66a,
    0x3fe4ba3584e36660, 0x3fe39f4312159fb6,
    0xbfa7c6ef6945676a, 0xbfdafc253b04dcfb,
    0xbfe53b3b4842d8b1, 0xbfe18f1f1b475567,
    0xbfa76fe8e5fdfb90, 0x3fdff6e192969e3a,
    0x3fe4caa7f528ba1d, 0x3fdd30b9493b0bc4,
    0xbfa1a9bf5182c163, 0xbfe034bf1df68087,
    0xbfe5bc15a9d250a7, 0xbfdda7a5d0a1b11d,
    0xbfb6b3d058c714f6, 0x3fd91d159755ce2c,
    0x3fe5bbdcd9c89c31, 0x3fdfdfa50ddb9fdd,
    0xbfaa72949d4d45a3, 0xbfde6280a8641506,
    0xbfe5d523a87b66f9, 0xbfe2349137dd1217,
    0x3fa2e8fa77a00787, 0x3fdcdd0a69ce09a6,
    0x3fe53046d6ec1a5b, 0x3fdcd1f03f65014f,
    0xbfa27c354fe57d5b, 0xbfdf318349c801b7,
    0xbfe6200464d52632, 0xbfddd5ad2bebc8b6,
    0xbf771211d1333bd5, 0x3fda75622b439538,
    0x3fe789a5ecb0782b, 0x3fe33fa8a931492b,
    0x3f893f3c38becbc8, 0xbfe0a07894734cc7,
    0xbfe655d0492fa0ac, 0xbfe0f791c03c8476,
    0xbf95aec1048817bf, 0x3fe0c58fa6640b07,
    0x3fe706b48fec27c2, 0x3fdcccd32818ad71,
    0x3f6df6d39c1c80f2, 0xbfdf17aa7017a92d,
    0xbfe6495b8be62ad9, 0xbfdb70ac0555ae0c,
    0xbfac183495bf9282, 0x3fdbcafc79870ca3,
    0x3fe5719a5bcfd491, 0x3fd8f7c140270875,
    0x3fa9881c13af6e5e, 0xbfe16d29cfef2ba0,
    0xbfe617a44b53f185, 0xbfdfbf19e6347a97,
    0xbf9779a9de7b96c6, 0x3fe07c0a16e7a977,
    0x3fe7c5fc03fb3e43, 0x3fdc1a7505bfad2b,
    0x3fa5bc0d5c461309, 0xbfddcfeb00f1af0f,
    0xbfe281c3944e3eb3, 0xbfe19b2f19776ae5,
    0x3fb9f308124e672f, 0x3fe298f5d0259f37,
    0x3fe96e23a4007dda, 0x3fd80e3645d9f74a,
    0xbfb05cb206783076, 0xbfe05ce5bc9f3c93,
    0xbfe853d46d1a5b7b, 0xbfdf86a0ae6424a6,
    0x3fb248a3b03c575d, 0x3fe0b2dc6817f6bd,
    0x3fe536dde935eb39, 0x3fe1a3764e716319,
    0x3fa8a22255c97edb, 0xbfe06ca82054c901,
    0xbfe88e0053e4d1b2, 0xbfe1bff63c2c7650,
    0x3fb88531d28cd1dd, 0x3fdd67f43be9673a,
    0x3fe7c79bba961c45, 0x3fe048900558dbbc,
    0x3f9ad31626938aa5, 0xbfdc925a85749128,
    0xbfe75928c867ae30, 0xbfdf872d7fc3a5b4,
    0x3fbb69851d1b9085, 0x3fdeeeee016861c2,
    0x3fe3d1a09d1ae903, 0x3fdc4421b6ce9fb4,
    0xbfaa4eabb1c7d3db, 0xbfdda1e7f6067bdf,
    0xbfe54ac3b4f76fd4, 0xbfdc8d8ce0484710,
    0xbf878b79221a78ee, 0x3fe06d28e350b916,
    0x3fe7c9af34027d46, 0x3fdb037de8558191,
    0xbfae01a4ffb78207, 0xbfe154775149d4c9,
    0xbfe3dc43733d6fd4, 0xbfdf808d254a9a41,
    0x3f8920cce131b06a, 0x3fe0458c3f986ff0,
    0x3fe7a6cea7b220a4, 0x3fde4280102af49f,
    0xbfab9ca122dd6921, 0xbfe15d716e34525f,
    0xbfe67574b86c3c7e, 0xbfde25d5b3e20631,
    0xbfb099a783ac645b, 0x3fe079398585f424,
    0x3fe7fc757f3d19b4, 0x3fdaf6c9d4f951b2,
    0xbfb794d19b320453, 0xbfe05a1408a24451,
    0xbfe8a773b325ade4, 0xbfdd47f3f8418900,
    0x3f723e859921a195, 0x3fdae2c2cb3484bf,
    0x3fe6d36f819c9087, 0x3fdfc6247e0c71ed,
    0xbf8d60230e7e436c, 0xbfde8b715c86bd22,
    0xbfe89dc97fb94223, 0xbfdd8a33590ecb30,
    0xbf876086b4e745de, 0x3fdf7b1edaa6c62b,
    0x3fe4c71812a40158, 0x3fdfa29337e97c5f,
    0x3f8bc5662cfa3f4e, 0xbfe0a195d2c47632,
    0xbfe64f96934a894e, 0xbfdafb65dad7ee1c,
    0xbf89a32ea7a43fa3, 0x3fe0cfd305a0919f,
    0x3fe748db2d63c62e, 0x3fdf437f8bf3c08e,
    0xbfb98feecb7ba59b, 0xbfe22626b77c0b08,
    0xbfe68e89db1a8bf0, 0xbfdf5b2bc38d7722,
    0xbfb6f365acddce8e, 0x3fdb84142005d870,
    0x3fe5c900a2c93721, 0x3fe1742be6861a8e,
    0xbfb1dbe4bbc99730, 0xbfdfe7fb0719b2db,
    0xbfe530523895b0df, 0xbfe0675ca49b8f42,
    0xbf9434d3fbafc764, 0x3fe02b254440ec81,
    0x3fe5cf511a3857f3, 0x3fe04d96ad37ebc0,
    0x3fb4ead04cd0f9b0, 0xbfddaf8db0be2f5d,
    0xbfe721926aa0a003, 0xbfde09eabf973f25,
    0x3f77505778569b83, 0x3fe25a57622ff53f,
    0x3fe51a3b41a99556, 0x3fd9a254737af633,
    0xbf80797ea204e0db, 0xbfe0042ba531e8db,
    0xbfe534ec0e99b263, 0xbfe2f388dcf241ec,
    0xbf93f565f8dab2f8, 0x3fe12abc670e6c6c,
    0x3fe6b1c4851afb4e, 0x3fdd301542b20c08,
    0x3f7a9e708f2ea092, 0xbfe1fa201844f513,
    0xbfe7e5516c8dbc5f, 0xbfe05c393df45ea2,
    0x3fb455150ec66061, 0x3fe26bc846d9760a,
    0x3fe8d85a7afb412e, 0x3fddc8191e5a1fbe,
    0xbfb3e334f1f2d007, 0xbfdea3991d128852,
    0xbfe84a8b16d2225e, 0xbfdefe258afaf780,
    0x3f6c5e42582d7e02, 0x3fdc03470cd66715,
    0x3fe617f3c37be220, 0x3fddf8aba0c8f89c,
    0x3faf14a047359510, 0xbfdfa8908a324b7c,
    0xbfe82831ed5fa6e9, 0xbfde802ea2ea25dc,
    0x3f764d410471fa45, 0x3fddc4c4f5a67807,
    0x3fe702209aab741e, 0x3fdfd05a48f7fdec,
    0x3f9716527ad834f7, 0xbfddb09b2f00bd16,
    0xbfe639e4e2f54ed8, 0xbfe04a869ee92f8e,
    0xbfb2cf07b9d45517, 0x3fd715959b16705e,
    0x3fe62c2e6cc3b2ba, 0x3fe1d5e40a3d1ddb,
    0xbfa1e998881d76ad, 0xbfe134b1bdad45e6,
    0xbfe6ef82b0765a86, 0xbfdf59dde18fa151,
    0x3f9fe73728125abe, 0x3fdb2ecb95ec8968,
    0x3fe6dae6b5687d61, 0x3fdebaeaf5fc1304,
    0x3f9ba024a13c22ce, 0xbfddfbbe2280d0f7,
    0xbfe965caec19e586, 0xbfe318fb3af9fa18,
    0xbfa8ac2fbfedcf38, 0x3fdd6ce9fee8cbe5,
    0x3fe890d58b5fc58f, 0x3fdbb1af0440261e,
    0x3f98ca3f38967f36, 0xbfdec183df699df9,
    0xbfe47437d0de5b68, 0xbfdd520b90c8bd92,
    0xbf8979298133bb19, 0x3fe13cc9ba125f84,
    0x3fe64a2b26ae5b4a, 0x3fd6decc35e39be2,
    0x3f7d9c593534758b, 0xbfe041f88a69308b,
    0xbfe5e84e5c522166, 0xbfdec8246f5e3d77,
    0xbf8207ce9c3a8714, 0x3fe25170eee34375,
    0x3fe56b04b967fad4, 0x3fdd12245fb85ade,
    0x3f705a89106e7161, 0xbfdd0df49169f63a,
    0xbfe58879b10a2db1, 0xbfe04bfd6c61d5c2,
    0xbfb11d4a0bf213bb, 0x3fdeee7c014d05fa,
    0x3fe75231fcef82c6, 0x3fde094028eabfc3,
    0xbfbe6e5e17ad174c, 0xbfdf2b995742e82c,
    0xbfe728b3253313a6, 0xbfe1412d58cea92c,
    0xbfa4b5df65ad9c3f, 0x3fdd25d00f25cf0d,
    0x3fe78b4cc9f8507a, 0x3fe0c963047c527b,
    0xbfb235d4abb88811, 0xbfe0543031609deb,
    0xbfe46baf42ae22dc, 0xbfdb288a59da0b2d,
    0x3f99d263f28cfb44, 0x3fe29623fe9b759f,
    0x3fe7d5c0bbdee853, 0x3fdcf2341023062d,
    0xbfa01e4bc9136615, 0xbfd7e0888ae3d51a,
    0xbfe35276840af1d3, 0xbfe0fae61aac423d,
    0x3f914d9d229f3db5, 0x3fde6e53e2a9956d,
    0x3fe4aa08e52a82fa, 0x3fdce3d3a06b9326,
    0xbf99a0bd453dcdc8, 0xbfe03ff2f741a327,
    0xbfe70b877795297f, 0xbfe307dc4a955df4
    };

static const uint64_t in_rifft_noisy_2048[2049] = {
    0xc01405d8ccbc9b1a, 0x3fec3570a7070430,
    0xbff57ed5eb3783f9, 0x40090b2d821d009b,
    0x3fe4103f98478e29, 0xbfd7abb315a7b76c,
    0xbfee33b9a7f286d7, 0xbfea261c54e2c148,
    0xbfd349226edce82c, 0xbfd8e9ae13fdbe84,
    0x3ff86fa651c2d912, 0xbffbad39fb03d090,
    0x4005a1c8e713fd94, 0xbfdec61c2bec465e,
    0xbfd14d0b0d057ab0, 0xc0008cfd4c8fd3f8,
    0x3fd67c8a8f7c8e30, 0x3f8d858074a11a60,
    0xbffd034d7d5b7998, 0xc003c3adbccc07f0,
    0x3fe48800e9b984f6, 0x3fec6b2929b6515c,
    0x3fda05babd70ec16, 0xbff108ae1613f100,
    0x3fdf515fa16afc34, 0x3ff64a6026888d6d,
    0x3fefe43c45df393c, 0x3fe0d91fc3e1bb7c,
    0xbfea42828cd4d7e7, 0xbff646c5328beb97,
    0xbfeef5573c6f3870, 0x3fce7cb668774474,
    0x3fb85284c70bf630, 0x400507651b34a2e8,
    0xbffa1b5191af528a, 0xbffeb8d9ed12754d,
    0xbfec090464d62ebf, 0xbff90742e5a79036,
    0x4008e5f3aecfeb46, 0x400462a8a84ce410,
    0x40044c60acefc073, 0xbfd62bdf66784130,
    0x400dc9fa6e22d7dd, 0xbfef2fab51736084,
    0xc00606a2cb3df32b, 0xbfc3828f88aa086e,
    0x3fe663ec70706c94, 0xbfea2839fef36f46,
    0xbfee1cdf8c96091d, 0x3ffc23cc6c666718,
    0xbfcd27f5cef4e680, 0x3faf8c420e484b18,
    0xbff962e0089fbc22, 0x3ffdf8a6d441facc,
    0x3fcbaa64f6bc3f24, 0xbfe41d92a1f7f1c5,
    0xbff72ab08314a78e, 0xbfdf79a404482ac4,
    0xbfd354a5eab974bf, 0x3fea6fc6a98166ca,
    0x3fd771b88506175f, 0xbffd2466adfc5f52,
    0x3fc4c18fdc3bdf10, 0xbfe9ccf0d01f1418,
    0xbff7747e82f5f4ef, 0x4013a35a95fc7946,
    0x3fc7788fbffb3524, 0x3ffc324e33a9ebe2,
    0x3ff6eafeb45f7c95, 0x3feda87c8116226a,
    0x3fddf140c00a6d84, 0xc008afe96c362011,
    0x3fe95d1bdcbeae47, 0xbfc74189127a3828,
    0x3ff3844203255be2, 0xbfc5483cfebc5a4c,
    0x3fe580ec4b99f96a, 0x3fcbc234a8b1f530,
    0x3fd1203c25a7c963, 0x3feb5f2204fa5bd2,
    0xbfe93ce099e735be, 0x3fedad15c2a9a36d,
    0x3ff2ea5c3bf28b23, 0xbff48a73c0cca0d4,
    0xc00196d4449a425e, 0xc00acda988bf262a,
    0x3ff55be3d34d57b8, 0x4001328fa0bed224,
    0x40014125fb7b0da4, 0xbff504fcf72c3c23,
    0x3fe2f621f945b70c, 0x400509cdd48a0adb,
    0x3ffc0cde4959b2ac, 0xc00e146cf8358023,
    0xc00a0d2a692b00f4, 0x3ffc8a3ef65bbf07,
    0xc0002f7fa880b51d, 0xbffd073a33e909d2,
    0xc002bdf8c23cc362, 0x3fd8f8469ca7ab88,
    0x4005e5d319a4bc27, 0x4004e20ce587161b,
    0x3fd541ff78b66892, 0xbfc421231d6157b4,
    0x3fcf17bbf08457b4, 0x400097a37ae990c6,
    0x3ff179cb36f720af, 0xbfe635c6a03fbf07,
    0xbfde9c53cf0fed70, 0xbfe5a36980581379,
    0xbffd37b5c3b59567, 0xbfc1a79448999908,
    0xbff3c6c35d620daa, 0x3fba1e6d5d61fe90,
    0x4000330aeee71c5e, 0x3ff6a719998e548f,
    0xbfffe0ca2c29ef32, 0xbfe1088b97033843,
    0xc0105ccf03c74704, 0x3fc651bd4f8e1bf8,
    0x3ff1942230cd6fa6, 0x3fe947b791c04e1b,
    0x3ff9bac8034b3c12, 0x3fec2a74762d1e1a,
    0xbffd902b93f8b1ec, 0x400a2bc8e4e12bb0,
    0xc01025f8557dac09, 0x4000454103ef561a,
    0x3fe1aa98f3b335b2, 0x3ffb494d83badac4,
    0xbff45cca6cbf5fb4, 0x3fb399c42f64b33c,
    0xbfdecfb559384fc3, 0xc0056ea79afabcf1,
    0x3fdfcea50cda3bdd, 0xbfde01755502b84f,
    0x3fd2b0dd3d8bf990, 0x3fdf57a4710fe3b4,
    0xbfe051789ec2f778, 0xbfd7bba36ac3bbd1,
    0x4003a04aee7de2c0, 0x40001da1c8519cda,
    0xbfe03fbadca97c42, 0xc00a38d66ca7746e,
    0x3fdacdb45bae28ac, 0x3fbde32cdf4ba870,
    0xbfeb5a35b5927c45, 0x3ff2e9f546521a49,
    0xbff6d7b0224bdde4, 0xc002adbda8bd13aa,
    0xbffcd8b4d1d5a0d0, 0xc00b49581abad33a,
    0x3fe390a9fc52a2ec, 0x40090ce1e564684f,
    0x3fb3f6184498b02c, 0x3fb3f3ff1407a4c8,
    0xbfea634de58abf75, 0x3fd9b548b8c4bb74,
    0xc0019d43561702f8, 0xbfead18d98ea0a11,
    0xbfea9b8715361e60, 0xbfe7314fc52ea102,
    0x3fb83b2bf7fe5ef8, 0x3fde633e21158f9a,
    0xbfe3334fc1474176, 0xc01347d68e7e79f6,
    0xc00ef8f277d25cea, 0xbffa33eaf6e95f40,
    0xc011a774fe7efd9f, 0x3fed617f81832b02,
    0x400c5d3082208b6a, 0xbfd6d0ff0e8308e9,
    0xbfe5aebc6e24e7e3, 0x3ff68d7f1ff53252,
    0x3fce4e98e5dea3c4, 0xbff613c3cadaf5ae,
    0x3fefa152e86c6056, 0x3fedd0b5aa97f418,
    0x3ff0a1ea53bab26a, 0xbfeb6f6733926b8c,
    0xbff0fdf4f4afc4a2, 0x3fda89843d83793c,
    0x4002fa9fc9fbe391, 0x4008265b02e65e6f,
    0xbfe04d15d4ea5da6, 0x40011e9466396081,
    0xbff9f5308e0728fa, 0xbfe6b73c7986d5ba,
    0x3ffb5f9b171c0744, 0xbff881731b72c19e,
    0x3fdc004aff3c44ac, 0xc00fe9a133a12ef3,
    0x3fdd8d39a7e440d8, 0xc000403a715c52d5,
    0xbfdb162e2d3d82be, 0xc00b75f2c4cd4d82,
    0xbfe50264185a0868, 0x3fd02778f81509d4,
    0xbfda76b243d5544e, 0x3fe60a84f9c90674,
    0x3ff4bacb6f2dfd54, 0xbff2374945271d67,
    0xc00810ec9a79954e, 0xc011e0a83f838b96,
    0xc0044fc1b3e0483e, 0xc010138617b9c570,
    0x3ffb26ad675082a0, 0x3fe13342a3e7b2cc,
    0x3fc5f4749f54df28, 0x3ff2e174265ecb1d,
    0xbfc9581bb3633dc4, 0xbfee9a60dc8c1702,
    0x3ff072a6b4c967ec, 0xc005a21bcb6ba7f3,
    0xbfff57503fd447be, 0xbfc68d1adcafa846,
    0x3ff7131220ae26c2, 0xbfbf192c7be2db18,
    0x40013924e8938340, 0x3fe5052afd74c1c8,
    0xbff1aaa9cb56e30c, 0x3fed3496658c4917,
    0xbff19a96618a0fd8, 0x3fcfcc9ca0255bf8,
    0xbfec1bb85f0d1319, 0xbff3a01e2d77bc38,
    0xbfe8ad26edf41aa6, 0x3fd5658bc4609ba8,
    0x3fe77bfff5a5cf8a, 0xc000f207df0d133b,
    0xbff7545a44e26baa, 0xbfd5b944b225d450,
    0x3fd0e8e188b58788, 0xbfbd599818e84908,
    0xbfb7075c09c7a860, 0xc009f07f8d3406f4,
    0xbff32f4ccd31095a, 0x3ff98db7de865fb8,
    0xbff733467cc122da, 0xc0015fec12bdcecc,
    0x4005368eb1ef8663, 0x4006938e3d88aa45,
    0x3fd09c7597b5b11a, 0xbfe077742ad1f8ea,
    0x400419536a4ae362, 0xbfa19927e7d4ac60,
    0x3fe3cb4da5052aea, 0xc002ddf8bbda165d,
    0x3ff5aa35bbdae038, 0xc0097ae2dba0cbee,
    0xbfdb21b6d9cf78a4, 0x3fe139b525195aa0,
    0x3ff92b2cbbba8a09, 0xbfe2d6949296dff5,
    0xbfee4d0911afdf5c, 0xbfef9fba5186f66e,
    0x3fb0df68cff93618, 0x3fe547cfbc64e890,
    0x3ffd91adfd596bf4, 0x3ff0e0ee4262da1e,
    0xbffe1f090bce66ed, 0x3fe4b2dcacf76442,
    0x3fff1eb45cd9848f, 0xbfd6942e7e47c455,
    0x3f63a73eb345b000, 0xbfeba91f994a614c,
    0x3fdf0cf209c00a89, 0x3ff25f6129e7a2a5,
    0xbfe59a0501705318, 0xbfd8d24c4967e4b8,
    0x3ff45066803a9dbe, 0xbfd3b8af3b3c4c94,
    0x4002c8934acae5a9, 0x4003680d671efa66,
    0xbfeb67b7db6cd4c0, 0xbffd429a2aa808c0,
    0x3fe0e15ec093229f, 0xc00b3f87dd5640d4,
    0xbfffc441a94ea137, 0x3ff32944c3dd7662,
    0xbff9608f40cb4d80, 0xbff4b3cdaa63eb1b,
    0xbff32544d5d2f8c6, 0x400c08fa8a98b7f5,
    0xc0073a20628f50de, 0xbff7a1c6c948cf0d,
    0xbff866a7900c46d7, 0xc00a8891ca8b7018,
    0x3fd6a35574a1b7e6, 0x3fe779fa6a9da793,
    0xc004fbc6e749d30b, 0xbff0f43e722753d2,
    0xbfea1e00ef21e856, 0xbffbb58d00088c7b,
    0xbfef4b01e040b3ae, 0xbfa0f96a80a41410,
    0xbff02958918d3a6c, 0x3fe3c47a88482be9,
    0x3fee4434b64e074e, 0x3ff19589f5a9e03a,
    0xbff7aa9873a74e39, 0xc0075e1625ebad9e,
    0xbfd7b4d7e8d3b922, 0x3fba2ecbe7bf7028,
    0xbfd802a4ece0f850, 0xbfe9a3876369090d,
    0xbfe59aa8aebc37c0, 0xbff20cc735a0ed0c,
    0x3fea559f124898c2, 0xc000eaa933e55628,
    0x3fe5e25b3318c97a, 0x3ff0ae49b30fa286,
    0xc00496aa4b318e22, 0x3febbf13f9e52d32,
    0x3fb8e0428cd23dd8, 0x3ff0e0cb9b6fdc2c,
    0xc0049cb1a315620a, 0x40000c4b495c4555,
    0xbfe1767fc2ac8d5e, 0x3fedecba104f243f,
    0x3ff831c31abac651, 0x3fbf789c78e76990,
    0x400db3c5fbf388ee, 0xbfef87206963672e,
    0x3fdb1204bab79b9a, 0xbf9dd5efb0833140,
    0x3fcffc860dee5688, 0xbfe7637e8a80161a,
    0xbfbee93de0151a90, 0xbffa6622417c71bb,
    0x4002cdf6dde75c92, 0x3fdd48adec68cfc4,
    0xc004beb993d728aa, 0x4011808f11ab8e44,
    0x3fed0e3b5e386015, 0xc00496faf7acbca1,
    0x3ff511cfa3d0beda, 0x400d463837e1b8ce,
    0x3ff299898ff40dd6, 0x40022f7751443890,
    0x3ff0d612582ad86c, 0xbfe3b769ed7abb40,
    0xc006fb4c9a1c1314, 0xbfe036fa5c65e4ed,
    0x40014ddd68ffa4b7, 0x3fe511f7b35a59c4,
    0xbfe01be5e70d4b77, 0x3fe3ebb884f5ffae,
    0xbfc9734bce639a4c, 0xbff1a2b71fb772b2,
    0x3ff9f73c3f9a992c, 0xbfe96a05941b3628,
    0x3fec598a9f1313db, 0x3fe7e97eac852a88,
    0x3fee99404e98ad7c, 0x3fce44c74a7cc6f6,
    0xbfed1b338bd53dda, 0xbff04de2cf877272,
    0xbfbdabd762c9a638, 0xbfe07dad491fd8b4,
    0xbff597d0213794b4, 0xbfe291ab583585b8,
    0x3fd9805c0d9d0aac, 0xbfdc4a10541a49ea,
    0xbfeb0492dd9964b6, 0xbff72f5e3e7a1d5d,
    0xbfe4e8368521081a, 0x3ff77b7c15cf415e,
    0xbff6e14040b45f0b, 0xc009fd166d1fd9ca,
    0xbfd95d229c69ca21, 0xbfda5edbd048f6f0,
    0x3fd04914e47bf738, 0x40024b92c7d704d4,
    0xbffce258cde3deb6, 0xc004613a57c98334,
    0xbfc03a4095ccb270, 0x3ff121701af8f5b3,
    0xbfd100ee4b3ff248, 0xbffac54d7547fa2a,
    0xbff54f9bdf13247e, 0xbff483bcdae295bc,
    0xbfd360f5bd89ac2a, 0xbffea730383a2b2b,
    0xbff7093122f3077e, 0x3fe7b16ac5ff2bd0,
    0xbffdf82b2c3aebdb, 0xbff4ca38a76064be,
    0x3f826ee76dfe59e0, 0xbfb856f3feb3ad48,
    0x4000cead697c6566, 0xbff79e4ef4bd012a,
    0xbfef4ccb10b82620, 0x3ffb3b2b04febb8e,
    0x3fff2de41bf864aa, 0xc001ec35341be598,
    0x40035e03efe4ce4e, 0x40079a486f558322,
    0x3fda2be673db6b41, 0x3ff74dc0e668a772,
    0x3feb60b8f2a4d0e0, 0x40030c45c4bcac47,
    0xbffbd9bd032d41b8, 0x3ff90ab061e01462,
    0xc003d89a5006a5f0, 0x3fe162909e642d8b,
    0xc00b52b934c697e7, 0x3fb252f63e397110,
    0x400444b1f395d39c, 0xbffc59d73f61cb2c,
    0x3fe98e4c6a320dbc, 0xbfeab6533cd12477,
    0x400208c76072a559, 0x3ffd8be1c4ce78a4,
    0xbfd5f38b454be2ac, 0xbffea65f158ba85d,
    0xbfcfdeb6c152f420, 0x3fe9d456cce11d50,
    0xbfa465072c03d080, 0x3fe5f0bb44b3a8a4,
    0x3ffd570df0f831e3, 0x3fec457cd79b405b,
    0xc0026af7a30c0803, 0xbfdaab594c5be3cc,
    0x400428bac1a5e549, 0x3fffabedcde96cc2,
    0xc004e473f3ebce3e, 0xbff17875e95dd057,
    0x4001d1dace816018, 0xc0052220ec90c112,
    0x3fea9ab8b8e4be3e, 0xbfcb2127411ada7d,
    0x3fe370ea43073a24, 0x3fd78b15810258c5,
    0x3fe7c279bc71e444, 0x3ff7b7f1cc5932d6,
    0xbfecb031c42755ca, 0xbfa38c29bb373a70,
    0x3ff60b2a8d362b72, 0x3fe93e27c4f617f4,
    0x3ff0747bdac1c49f, 0x3ff56a5dd608dcc7,
    0x3fd366e0e9322d96, 0xbfd89ba21cfc7760,
    0xbffa636a2f503904, 0xbfcebaa25a8e6f68,
    0xbfe722da2d614ae7, 0x4004a0d956ed2d68,
    0xc00336081c148b45, 0x3ff31a0f1107a884,
    0xbffa6fa6af9d3672, 0xbff68fffde5cc63c,
    0x3febce138bd97499, 0xbfff25c99cee7718,
    0xbff01b4d4b88a35b, 0x3fd75c4f633aadbe,
    0xbffce98795748812, 0xbff82dbb991bdb4a,
    0xc000b36e51a609d4, 0x3ff543c541d50452,
    0xbff0831a5a718770, 0x3ff3a774eea6a5aa,
    0x3fd17d3cfb9476bc, 0x40053dec56bf0f94,
    0x3ff459ede4cb8335, 0xbfd54186141f1ee4,
    0x3fe521386d455868, 0xbff1551e66d70e5a,
    0x3ffae7639295b349, 0x3ff6efc874fc2615,
    0x4000453d29ca98c8, 0xbff90903ad98b741,
    0x3ffc4e9c27e8151c, 0xbfe5b5ea1c17e382,
    0x3ff20146c873c1f6, 0xbff5d5c84db04668,
    0x3fed9c1133384076, 0x3f900d2d78b073e0,
    0x3ff2e6a5ba650194, 0xbff170332e37c102,
    0xbfe27bc568fc3d80, 0xbfb0677f592337c8,
    0xbfb9ca58790b748a, 0x3fdd4980b8c8480c,
    0x3fd4618f07b31139, 0xc00892136f2d6f28,
    0x40040176b560b0d0, 0xbfed8314d7f1cf40,
    0xbfd03c9de1801ef0, 0x3fe207199d0e2b7f,
    0xbff2424f80073add, 0x3ff764e284ab4320,
    0xbfd6f7a6d86244e8, 0x3ff127e6e241e156,
    0x3ffa871140f356bb, 0x3ffb9faa02887eca,
    0x3fc75c50169e890c, 0x400f803188217e47,
    0x3fb2e8dd85355960, 0x400670e98ac571f6,
    0xbfe553d649101986, 0xc0021eb4f21073f7,
    0xbfe0a32f61d05675, 0xbff743f92e10783e,
    0x3ffa7f9df13254e4, 0xbff0b9597cb4b38a,
    0x3fe089dc8711dc58, 0xc0015f40a768db3c,
    0x3fd11714176cf288, 0xc006fc8ef2ced11c,
    0xc0091de01dfa33a4, 0x3ff7bb306b81f15a,
    0x3fe2f34dd8ad3eef, 0xc0866a81da3e8fc8,
    0xbfda0f7f211449c0, 0x3ff2b6160db079e8,
    0xbfed7eaefec038c4, 0x400fd04f56247abf,
    0xbfb7b8740b831450, 0x3fff8c37509bde5e,
    0x4004395e53cdfd1b, 0x3ffb29f43e2c6cb6,
    0x3fec983ba7d7aaaf, 0xbfb7b987dfd98aa0,
    0x3ff5500aa013e5af, 0x3ffd15382d0fc6cd,
    0xbff26da928d552f3, 0xc01525b7fa15ee1c,
    0xbff992d392bc9246, 0x4002c637cb9d43ee,
    0xbff82bb6f5a6d08c, 0xbfe39ceb62749a2f,
    0x3ff00ab019a64a14, 0xbfd2b20471b40587,
    0x3ff77a94900b82e6, 0xbfe5ffc1c28e64d6,
    0xbff7b5e93c060206, 0x3ffb9ce70f9d8cf3,
    0x400b04a1a2a9bf22, 0x40046fb931796ce9,
    0xbfc27a54ce858008, 0xbff9d39f8fa08c6c,
    0x3fb2628bee1ff400, 0x3f8fef05abef7f80,
    0xbfe5d2e840137cbf, 0x3ff3f2363813d668,
    0xc0086015553e5304, 0xbfd75e7638aefbd4,
    0xbfe8507df5fda8f4, 0x3ff6f6e5ba7b8f7e,
    0x3feec1435d1ccedf, 0x3feb058686e255d7,
    0xbfeebaedc23175e9, 0xbfd16edc2d825eb7,
    0x3fe279db8ae62a0c, 0x3fdf45b61d732f7e,
    0x3fe94746953c2862, 0xbfc799ba90366b30,
    0x3fe0616d3ae2abe0, 0x400544a3682959b5,
    0x3fd167a7834a1e06, 0x3ffa527a6ceaa981,
    0xbfd3488ca25ca26e, 0xbfad305fdad36730,
    0x3febae3625fe051c, 0x3ffdb7ef3c4d9c1a,
    0x3fd5f902f57bd736, 0x3fd661f548d0068c,
    0x3fdc25727e75bef6, 0x4009fe3c70745888,
    0xbfda3e3e84f9d096, 0xbffbacc0adf0da28,
    0xbfd0d0582127f8f6, 0xbffed3643db20d8c,
    0x3ff9877c2e83833a, 0x3fb562a1cec25bd8,
    0xbfe068308d187b1c, 0x4009abea22ae26c6,
    0xc001d0ef1a5db66e, 0xc00090ebd7b1122e,
    0xbfd7e16ad53a4a5c, 0xbfebf3fcbc71ffc9,
    0xbfdfad715674f71f, 0x3fef3acfd47659d3,
    0x3ffac2793dc26fff, 0x3ff13b3c8f76425a,
    0xbffff3fe04f0193c, 0xbfdee72f3bc989a8,
    0x3fe9c368274b5af4, 0xc00089b67358a2b8,
    0x3fe9c4f2a8184a2a, 0xbff2cbff34faf96f,
    0x3fffe1e2f222cefb, 0x3ff314d7186baf1f,
    0xbfd19d7fb36d439c, 0xbffd59ee6c5682de,
    0x3f9b06007eb3bf80, 0xbfeae5b5ab5c24a8,
    0x4001ec800ee668b3, 0x3ff207cb3fee4746,
    0x3fe093caacc08681, 0xbfe80fd779fcc583,
    0xbfd6b06c286037c4, 0xc00e24403b10f642,
    0x3ffbbbf7aa4bac4f, 0x4003a6a3f92adcaf,
    0x40064d56197722e5, 0x3fd573b677681a6e,
    0xbff9bedbb9c1d0dd, 0x3fede30030a6c6c4,
    0xbfe9f9aa2de8b439, 0x40000c2881f83cf4,
    0xbff1a1e28740eccd, 0xbfcbd0c5655db7b6,
    0xbff3d811fcb04a4a, 0x3ff36c340fbeba62,
    0x3ff7d561c27d7324, 0xbfd7545721606bcc,
    0xbfd88afcffb26166, 0x3feca29c546e10de,
    0x3fe7080a30cb6b6a, 0x3fe15507a1f9171f,
    0x4000283afcf53f9e, 0x3fec4d80eb673e1a,
    0xc000914e81b11df2, 0xbfeb0d9ddec666be,
    0xc00aa94cb0f4696b, 0xbfa69c1a8b067160,
    0xbfd21fd5b87e71e2, 0xc0013e10380048ee,
    0xbff1b11211b0905b, 0xc0045ad9e2ca796a,
    0xbfe4b8af995ab78b, 0x3fcd4e76fad8f4e8,
    0xbffd7cd63b4c2004, 0x4003860d86ff6f7c,
    0x3ff1b80fefdd4e48, 0xc00257e27bba8e15,
    0xc0025655c7a1e358, 0xbfe1b617bd5377ec,
    0xbff083c0b355f9a2, 0xbfbfc9ea57013ba0,
    0x3fea185e08dd3458, 0xc00545ad137c22c8,
    0xbfee2ed8011ef50b, 0x3fe00a5b8673ce3c,
    0x3fe8816167d5a9a1, 0x3fc9481014acadb0,
    0xc000bb1cdeaa796c, 0xbff803322c43b0b4,
    0x3fcf6a646be35c44, 0xbffbd9991886b1f4,
    0xbffeab04feb2df52, 0x3ffc9d6a721b343e,
    0xbffb08e705ceef9f, 0xbfcf10c2700ee950,
    0x3fdfecda51f42e70, 0xc001fd1038c05056,
    0xbffdf43e4f983649, 0xbffbe129c6a87195,
    0xbff28911550ce194, 0x3fe89dc38c2c56e9,
    0xbffea09149c4f02c, 0x3fb5c58b75a9c950,
    0xbff7b0774032aeda, 0x3ff0434386456e9c,
    0xbff6656846d7c132, 0x3fe60540ca584b34,
    0xbffac5bfa88f1422, 0xbff906d94b24bebe,
    0x3ff892668545914e, 0xbfd09f92a28f14c8,
    0x3fef4ad0e7d6488b, 0x3ffce885a23d86a2,
    0x4002fb75f9ae62a6, 0x3ffd52f3e27f8104,
    0x3fe0ae054466d25b, 0xbffb0443c8986e22,
    0xbff3dfeed443338d, 0xc008361f215e0ab0,
    0x3fd7ff81cbc4c0cc, 0x3ff1c6395527ae3e,
    0x3feb767957afd5e0, 0xbfe4e93a08c9e424,
    0xc005de0197d9264b, 0xbff9eb2d181345ac,
    0xbfcccd5645de57c0, 0xc00558dc51c08a54,
    0x40073e8fcc889040, 0xc003d9ba1e6608ba,
    0xbfd3274a2f72f278, 0xbffb238ce5937ff9,
    0xbfc0c6a47836e3ba, 0x3fe3b4372357f3d3,
    0x3ff9e060a77b3006, 0x3ff83ef32b04b9c6,
    0xbffed7159ba89128, 0xbfe1f4ab5254c806,
    0x3fd5417bd390ef18, 0x3ff1878b7333516a,
    0xbfc0ade45f6d59b9, 0x3fe7338a1f1b6534,
    0x3fec63c9669f0f99, 0x3fe5110b9b9caef7,
    0xc00e2378d764c265, 0x3ff2b1a9661d057f,
    0x3ff97972d9b5f652, 0xbfd34ddf2cd742c8,
    0x3ffd88557e43525d, 0xbfd0e8f193c29b70,
    0xbfe7b0d365ac2a94, 0xbfe8c1ffabafd202,
    0xbffe61460f9cacd0, 0xc00001e14e075c6b,
    0xbfc53cd3f65a47f4, 0x4008eac6ba095787,
    0x3ff73b3ed5a81b1a, 0xbff2c72a4726e542,
    0xbfece043295f9652, 0x3feec7abdf4ca9de,
    0xbff0f430e9fce5d3, 0xc0036821de413026,
    0x3fb1ca5384141c18, 0x3fee96f8a8e2404f,
    0xbfc597029645bc06, 0xbff5415682c73ef2,
    0xbff65e02fab69707, 0x3fc97c83d27efc48,
    0x4005100cced39672, 0xc000929aed146cf8,
    0x4007bf56668f7b0b, 0xbfebce2514e84596,
    0xbfe4077ae1cb4ac1, 0xbfeb05fd596e1b26,
    0xbff7aa74fbb0eab6, 0x3ffd11d8807f057b,
    0x3fffe4acb0cc00a4, 0x3ff87502321fe77d,
    0xc00e6817d0c5af70, 0x3fe85ab0df21022f,
    0x3fd2e850f0a08390, 0x3ff27bdcf2fdb239,
    0xbf81074a90229440, 0xc0013cac9b9aef94,
    0x3fca480d5ff7f0c8, 0x3ffa402a7c520536,
    0x3fe8e2a8543d538e, 0x3fdb38bd775bd4f0,
    0x4002991bf9eeff78, 0x3ff403b3bcd31326,
    0xbfeb2f468fa9046f, 0xbfd1acd60270528c,
    0x3fece9ed0bec0db0, 0xbfd878736351edb8,
    0xbfe95b0b81b9afe4, 0xc006a279323d5f20,
    0xc004975ca662209b, 0xbff02df2e8571c8a,
    0x3ff355e86e4539ba, 0x3ff5aa45e3d8cc29,
    0x3fe04d580b423074, 0x3fec698cea6dfe64,
    0x400bd50f729e53b6, 0xbfd7f7c3a6d22ebc,
    0xc0004c2a86e99ce8, 0x3fd928190f167a33,
    0x3ff2d4a8ee54ae52, 0x3ffaf7003b030a70,
    0x4007b37542b3f34a, 0xbfbcd19e45923550,
    0x3ffacad36ff6fcf6, 0xbffd36db5c6feb15,
    0x4001044b33c5a63c, 0xbfdb15a8b3bc5162,
    0x3fea6a46b6a3ce44, 0x3fda8ab325d3de22,
    0x3ff80f86f91dd7e9, 0xbff02c97215edcc9,
    0x40105d063d16ba5b, 0x3ff0a4be08fb0379,
    0xbfeaf71877737e25, 0xc0003558a4cb8af7,
    0x3feb84b4e76e3dc6, 0x4002e2d1d5fd278e,
    0x3fef878c1e341d62, 0xbfdbfec797e61fa4,
    0xc00084360cdf050b, 0x3fafb69dca4d79a0,
    0xc00c5eb65e8ebf9e, 0xbfe3ee3fe376e95a,
    0xbff66c199c3b7cb8, 0x3fe363f4d545c7ff,
    0x3fe74beddb611e40, 0x3fde54e86989888f,
    0xbfe6e19d8fbc4b9b, 0xbff5a7fc379df15e,
    0x3ff66be9988e922e, 0x3fe7b94e9b8ebd88,
    0x3ff53daa58d37ad7, 0xbff954425b740cd0,
    0xbffb93600343472f, 0x3ff40df009904518,
    0x3fead39c29e953f4, 0xbfeddb4debb5b2cc,
    0x3fd4334f91ce8558, 0xbfe8c24d1ad44bcd,
    0x3fdc22520720d773, 0xbffea91ee96133fa,
    0xc010763370ad3f49, 0xbffcea7b6f8f39c5,
    0x3fe781cd630e05f1, 0x3fe177cac6fd0bee,
    0x3fc050e3f1b86ce0, 0xbfdda5fcc1292634,
    0x40034742650cfb00, 0xbff164d74a0e27c7,
    0x4005bd382400da65, 0xbfc95055cf47b518,
    0xbfe3f74ac4931a19, 0x3fec4d6fb55a23e0,
    0x3fe5cc7c56586e06, 0x3fa2797dbf752be4,
    0xbff46fd1435f7360, 0x3ffbe1a273ed00b2,
    0x40049466ba5af7a2, 0xbff9a7a8a0c29ae6,
    0x3ffd18119dd70564, 0xbff004759c52dfe9,
    0x40005d6822bfa656, 0x3ff67c698b000031,
    0xbfe25b6dd1492a03, 0x3feedef18c60d4a2,
    0xbf7e879a70ef5f00, 0xbfc6251e638ee5f8,
    0x3ff54f6effd3daf8, 0x3febbee0d3eb63dc,
    0x3fc3d8516839657c, 0x400acfabf7c9ee2b,
    0x4001954b287d5048, 0xbffae2044478dd9e,
    0xbffb53c107d2cb1e, 0x3fc46e7c9dc36a00,
    0x3fd13f86e2335f9e, 0xbff6ea6f84b7075a,
    0x3fe1ca541b563192, 0xbff1f8552e1a4828,
    0xc003682ec95ab80a, 0x3ff5faed902aa317,
    0x3ff6eb6fa18fa032, 0x3ff034fbd79aa1ae,
    0x3fb2e79f8b416464, 0x3fc639b56081fcc8,
    0xbfe795a45cd5c862, 0xbff0cb255100cf5d,
    0x3ff4ac400f891582, 0x3feda80adf9a6b70,
    0xc001b508471c8e1c, 0x3fe4211d0aaaf5e1,
    0xbfebefbcb27edef3, 0x3ff060e0589ece56,
    0x3fe4b8ff69709d1a, 0x3fe07d8e36b08b2f,
    0xc00ab3913fdf25c0, 0xbffbbd0ea619fa3b,
    0xbfe26bf9a51014c8, 0x3ffc827dff0f98f6,
    0xc00bac26f9b09372, 0x3feb106b10b48452,
    0xbff01c6452b4ab4a, 0xbff2c69c0d0dc6cc,
    0xbf9947c909219460, 0xbff1d970b74841a6,
    0x3fe153eba0037a83, 0xc00018babeaf3b98,
    0x3fffdc80b060d2ab, 0xbfe711637343f652,
    0xbff731d7d4ebf526, 0xc008174d3cd1c62d,
    0xbfe30fbf9492e45c, 0x3ff722842be93793,
    0xc0092479a5bf508a, 0x3ff235b2a01de254,
    0xbfc9f59253eb64f0, 0x400530b6cf468c3d,
    0x3fe2ddf8e2d11dfa, 0xbfdc0fb22f292564,
    0x400d8aacacf44f50, 0x3ff49bd3e5084068,
    0x40031bea8a3769c2, 0xc003703b46fdb21a,
    0xbfe702054419d1c2, 0x4006b70103b5f102,
    0xc000d3bba2c39d79, 0x3fbef712eb004fc0,
    0x400969a92feb8db2, 0x3ffe3bb6b4097dc0,
    0x3fef0de5f24b97d4, 0xbfa631e6febe2880,
    0xc00233b80b519399, 0xbff7233ce1b218d0,
    0x3f843e90e74a76e8, 0x4000494b01a5adad,
    0xbffb6acfbd93a97f, 0xbfef0f21b87c9426,
    0x3fff8c1f943083c6, 0xbfbd36e8cfeec430,
    0xc0040ecfa6b87e03, 0xbff21d50902a1890,
    0xbffc860a235b144a, 0xc0023a7fd220d4ac,
    0xbfe4783740ea950a, 0x3fd827c076a26f81,
    0x3ffeba1dc5dfc4e9, 0xbfd566a47c584ade,
    0x400331c174cc8b66, 0xbff993ca250fa39a,
    0x4009b3c12f5b99a8, 0xbf9100b0fbc09178,
    0xbfbba431bd627c70, 0x3fdc6febae30ddfa,
    0xbff0aaeac2b628d0, 0x3ff20b2689455108,
    0xbff04f5c2f632574, 0xbffb470e640635af,
    0x3fda61980ae7f8c6, 0x3fdddcc96a67623e,
    0xc001ea20d43ad4a4, 0xbfe28a2b61bfdd3e,
    0xc008a9f8bf846f29, 0x3ff1cf4bfb33e517,
    0x3ff1b67018624798, 0xbffda25c8c063354,
    0x3fdb3e557d0e0200, 0xbfec84090a81f614,
    0xbfc3f72bad7dd9d0, 0xbfe90b3d2a61b512,
    0xbfea78f2f7c71e72, 0xbfd65ddac46b9680,
    0x3fdc43ae2111da4a, 0x3ff0a1c53800d714,
    0x4002a27c133710ed, 0xbff80ebd3e6b52fe,
    0x4002b67562d76356, 0xbfe2a628fa91aabe,
    0xbfd0d0013abd4172, 0xbfd4768545a1d184,
    0xbfda5b9c25662df0, 0xbff4f4cdda60bb12,
    0xbfdace365656365e, 0x3fcc346c039433b9,
    0x3ff113b3b47a9df2, 0xbfd4f0e2217ef3b5,
    0x3fe6fe6a87717818, 0xc002a78954d70131,
    0x4005d9ecae2b7593, 0xc00350db0db29792,
    0x3fc6b2be474b4e58, 0x400a526cce3d4dd8,
    0xbff15c68e26f4a2c, 0xbff21d3aaccb5622,
    0x3fee47663c8c757b, 0xbfc1863b2ef4ec08,
    0x3ff4997069df1430, 0x3ff359dd48ac5c2d,
    0x3ff53dd480f2b8b6, 0x3ff79387025c3453,
    0xbfdba865806f7e36, 0x4003ff2d461de6f0,
    0x3fd1c3b6a2a55744, 0xbfefea48fb1ef774,
    0xbff6ff29db720af9, 0x4007e10b5984df60,
    0x3ff44102d6f5e244, 0x3fecb07db6973c8e,
    0xbff5903b26ed9026, 0x3ffe68f61299feec,
    0xbfd3b2454dda9fd8, 0xc00418253b572dbc,
    0xbff35b60c6f128a3, 0xbfee65f4205c3b8e,
    0xbff8629753565cdc, 0x400dba1fcd91b0da,
    0x40027a8cdf36e022, 0xc00a665067e2d089,
    0xbfb050c5aeb3159c, 0xbfe5dfe408795056,
    0xbfd3eff49d56aee4, 0xbff2cb1b50da5414,
    0xc006c71a415607c3, 0x3ffe9dcf8bbf078d,
    0x4003456e603e67a6, 0x4004ea6b08c3393c,
    0x3f908653202e451c, 0x40103fd68be2329c,
    0x3fb83b1f9461c558, 0xbfd20c716b1ea204,
    0xbff76e5ac9f566d7, 0xbfa6660dd800c2f0,
    0x3febce9b4a9ee229, 0xbff87f7f8e8b9876,
    0xc00f300446165fa6, 0xc0018bb5fff5d0bc,
    0xbff1e2efdcea9b8f, 0xbfd36edc6403d287,
    0x3febb4c0939e4d4d, 0x3ff2a51e6ad0bec9,
    0xbfb7c0ca4b1df712, 0x4006b9e4b9cd78a2,
    0x3ffd9289d5309828, 0xbff9820801e21b44,
    0xbffbb1455a5f200b, 0xbfc80a7e44175610,
    0xbfe5ec7daa6a2c82, 0xc002ca2408ca6f08,
    0x3ff40a5f1b41559b, 0xc0036aa7bb25b501,
    0xbfe5c87d477a817e, 0xbfe8e9a447aaebfb,
    0xbfed1ccc1e269f76, 0x3ffa37605cca6964,
    0xc00c0fe36bcf4516, 0xbff00e917f0518f5,
    0xbfecd2996ff7dbbd, 0x3fe930e3180e2e64,
    0x3fe5932b351a25af, 0x3ff29116872b1140,
    0xbfe29901aa5031cf, 0xc0080bb9567676b7,
    0x3fdcb7d9128a3584, 0xbfeaeb5075715524,
    0xbfec9b5f10868842, 0xc0010480a46eb19c,
    0x4009b42abe7100f4, 0xbfeea3f84ab2e031,
    0xbfeb7c00e50191fa, 0xbfeb755c51779e5c,
    0xbff68c7867971723, 0xbfcec12c25ee65d8,
    0x3fc1c08be6afadd0, 0xbff9220dcc88b1c1,
    0xbfe14e55b0de2504, 0xbfd4e2efb6f8c61a,
    0x3f61be77e420fc40, 0xbfd95ffaed6a3b74,
    0x3fe74199a65ba5c7, 0xc01099b9a3103bce,
    0x3fbc4a1862ab9e30, 0xbfe1a070799f9140,
    0x3fd664f12ae4c260, 0x3ff00498c893ec9c,
    0xbfb78d7ca3c89408, 0xbffad696cc05a764,
    0xbfffc9fce2e347c5, 0x3ff371e91aee53f8,
    0xbff22b9e8d5d2b4a, 0xbff7892e60962ead,
    0x3fba47848004df79, 0x3fe1499416ff8d38,
    0x3fba475918e9ea10, 0xbfeb705b5e08392a,
    0xbfe00fc3553f9cdc, 0x3fe6979c87b4e3c6,
    0x400547d59adaa628, 0xc012b189ed1d5815,
    0x3fe7339d081b9e70, 0xc0027c7f0590ddb4,
    0x3ffd51afe5fa8d28, 0xbffb8d9db76947de,
    0x3fe209c3bcbfcf18, 0xbfff9b1f50c25819,
    0xbfeae02ee8987272, 0xbfd21580eaa6e6cb,
    0x400a97672e2eb0ad, 0x3fd874eeb2ad5ae0,
    0xc0042af62f14e019, 0x3ff80b9c53c3c56c,
    0x40036ea92dec4d5c, 0xbff244fc3abdbd5d,
    0x3fe098b78628efe2, 0x3fe672fcad42cc68,
    0xc0090e765457fc64, 0xbfe4cad989e72858,
    0xbfee211693d3da0b, 0x3ffafb56aa85b428,
    0x3fe3f725b1c380ee, 0xbfe5c3fa8174e282,
    0x4002c0e93203705c, 0x3ffd84b0b4eebbb3,
    0xbfe3ef0327d0c14b, 0xbff2a2f28b7e5415,
    0x3fbc563a2a2c6ed4, 0x4004c4a417737c69,
    0xc0037494b9f10e18, 0xbfd0469de6803334,
    0xbfeac0b8ae3ac2ff, 0x3ff0fa0ec7d32851,
    0x3fffbf4609e2d3e2, 0xbfeaf884a8379553,
    0x3f946546f45092a0, 0x3fdf0a4df98cb451,
    0xbff876e69e547296, 0xbfe188e50b54af62,
    0xbffff3b1d6c396ac, 0xc0107ca9c104636e,
    0x3ffd005fc5bbafac, 0xc008deea67c76488,
    0x4015f1015c246e87, 0xc00037984a59c444,
    0xbf92c33092f8af80, 0xbff2f6af750a5684,
    0x3ff760b41592c858, 0xbffd4e14991df00e,
    0x3fd66eee7e0f4744, 0x400a65aee0b7aa6c,
    0x3ff5720334bf8b44, 0xbfe18c4ec4a6b96e,
    0xbfe2de1bf104b67c, 0x3fdc5f2d0b6fbd13,
    0xbff158f99f477eaa, 0xbfe86048c22d12f4,
    0x400689bef155f653, 0x3fddd3406f9a2794,
    0xbfcc9c98e10cf370, 0xbff308ad86b5b89e,
    0x3fe230f5cda14983, 0xbffb5da6ac7bb3d6,
    0xbfda9e95d0a90a10, 0x3fd5365e6543517c,
    0x3fef4f08b7cc814c, 0xc00ac04901042c34,
    0x400140ae14ae8754, 0xbfd7966ec021d6f6,
    0x3fd81dc1ac8e2200, 0x3fddcaef46ff1e44,
    0xbfe109e82fb81400, 0xbfba87a2172147d8,
    0xbfa37285e1aa7880, 0x3fefcb5180be55c5,
    0x40093a5d07a02246, 0xbfe5e8e7533489ae,
    0xbfd2f562b6394bfa, 0x3ff087dd16594016,
    0x3ff3db27e6a7ed50, 0x40045bf87c333caa,
    0x3feaf4635016a2bc, 0xbff6541953ddbec3,
    0x3ff4f1b1c9ff0e55, 0xbfcc5ccd314dc296,
    0x3fb4516d3ee0e3e3, 0xc0022e1ad928bc1b,
    0xc00419cc4091c843, 0xbfb78661638e04a8,
    0x40013769e9056833, 0xc00575d5f32dacfc,
    0xc00195084e52eb3e, 0x4006e355416fbb46,
    0xbff7ffbe4f39ff3a, 0x40056bcce23502ad,
    0xbff425b332e0dd73, 0x3fbb8c6a7e670b70,
    0x4003101adc66e2c2, 0x3ff5870915d7a354,
    0x3ffa51824549a8cf, 0xbffbcf6e3b3bfce6,
    0x400735ace0592362, 0xc000946bcfceecc2,
    0xbfee0324f25b7090, 0xbfe5609322aa6245,
    0xbfb3bad323d885c0, 0x400917f6d67d880e,
    0x400d8300dba3d6fb, 0xbff077773476aa3f,
    0x3fd53c6156f2006e, 0xbffc621316272d56,
    0xbff583b12f9035e1, 0x3fd2147b97714bd4,
    0x3ff6eeb28666ee78, 0xbffd7d9526b34030,
    0x3ff8b63857ac5f72, 0x4002cd3ae0e26843,
    0xbfeb6e7febdba898, 0xbff47f79649c9f06,
    0xbff9453aefb63f23, 0x3ff063c564048dcf,
    0x3fedb1f298eeaca2, 0xc002da13172e28f1,
    0x3fb75696bcd75770, 0xc0028c76304b7463,
    0x3fd70add9284794b, 0xbff02251e5f69a85,
    0x3fc5c0f169e126c4, 0xbfe80ee05cc53b9d,
    0xc00a046a00d3e960, 0x3fb8bb12a548dbb0,
    0xbff9eb5cafc998a2, 0xbffa13c291bc3cc0,
    0xbfe8c3b70593529c, 0x3ff95ef598918ee3,
    0xbfe66aca3a6a4ba6, 0x3ff54f86671092a1,
    0xbfff74a6595f0aca, 0x3ffb6e49e67263ce,
    0x3ffeb1ecfe4526e8, 0x3ff0da91e4ded70d,
    0xbff42c2447b22b9d, 0xbfe72c5d5b24994f,
    0x3fd240e60cf0d452, 0xc006fd468b1c8e79,
    0xbfefd2f51fdcefcc, 0xbf9a1098668225a4,
    0x3ff8486ac2db1a70, 0xbfd84a2409a3efc6,
    0xbff1ebe1f9b3d2cc, 0x400b974541a6bbd9,
    0xbfdedb86a928a050, 0x4008d2310fe0fac5,
    0xbffa0876dcf86919, 0xbfb06e533c39caa0,
    0x3fd07d5de0c1faba, 0xbff7adb2bbb12f6b,
    0x3ff1599567f98b20, 0xbfe55fcee0e434e2,
    0x3fed3512cb8b9009, 0xbfeb423e58e42a1e,
    0xbfd371da3279a34c, 0xc001afab3eb2c523,
    0xbfda6affda243ec8, 0x3ffb4944a6ec8220,
    0xbfced1989edbe3fa, 0x3fe0c79bb8be3b12,
    0x4004592028f1deb8, 0xbff066ec1487e1ab,
    0x3fc9e22e409910f0, 0x3ff9bc305a76f58f,
    0xbff3d3d8fd1fe2eb, 0xbff5cd24642f7325,
    0xc00ff818bda4c580, 0x400532e31d8a8894,
    0xbfd618df14d1629e, 0x3ff28480ff66d1ad,
    0x3ff931a60c14ca9c, 0xbff05dde76397547,
    0x3fc87748a16d02ea, 0xbfbcde7f94712b58,
    0x3feb0f900dbac1fa, 0x3fec1b3715a6b025,
    0x3fe1266d9e6d40e6, 0x400af83242124905,
    0xbff34112b5a32553, 0x3fe5e2f5a08ca5e9,
    0x3fdc6568bf957498, 0x3fdf336b118926a2,
    0xbfd452493e4e0fca, 0x3fc44b6dda644c86,
    0x4003ccd81514dedd, 0x3fd0693bceadc862,
    0xbff0ef6be5d018b6, 0x3fec1a7bbdc7758c,
    0x3fd8c069a2982b62, 0xbfffcd7b64446978,
    0xbfce37318a9b6a08, 0xbfe1f3db1779b23e,
    0xbfe4c87f658330c0, 0xc00619bc76f55170,
    0xc0033f040ff68b18, 0x3f9b9088b59112c0,
    0x3fcae23a5aa4091a, 0x3f830c0b0df1ae80,
    0xbffe0964ad310856, 0x3fee4002f72469e4,
    0x3ff26b47a36f717d, 0x3ff6ea38c9cc95ed,
    0xbfec4099862265ae, 0x3fd6d2b36b004cf0,
    0xbfeaa4545903af40, 0xbfe83944fa82c725,
    0xbfe2190402c93b37, 0xbfdd7b5afc9690ea,
    0xbff9e0758fd48554, 0xbfdae34a424d54f4,
    0x3fc47394ad07ea60, 0x400c0435b32f1bb6,
    0xc00db5c9264e355b, 0x3ff5ff03b1c1c9e0,
    0xbffc11da64b7f34e, 0x3ff28ee3b7386db7,
    0xbfec33a4be8a61d6, 0xc00ea91bd8800246,
    0xbfc5d23481bdf6da, 0x3febde4e7449bf78,
    0xc00a48ac18b57e51, 0xbfda2d11794e1f27,
    0x3ff280e904dee592, 0x400867307ad598f9,
    0x3ffcd5cdaaca5396, 0xbfd530a3e163d318,
    0xbffa58e4bd771dc4, 0xbfcd5dafc898f76c,
    0xbfe09e06a159b405, 0x3fdd37576a4c2bb0,
    0xbfc0c321e2c327d8, 0x3fe0ee1b725185a7,
    0xbfdd9b87bf3c05f7, 0x3fe19a3b8af2a7e6,
    0xc001804b18a72d30, 0xbff75fa5054fff4e,
    0x3ff9ca5b4fd8889a, 0x3feec87f0053a963,
    0x3ff91c6ef81a75e0, 0xbfff5b952c7074ad,
    0x3fd71943d12d0c90, 0xbfeb98f82adbd8d1,
    0x3ffca8f253aeddb2, 0x3ff0e7190003ac3d,
    0xbfcb269669ddaa54, 0xbff5b9cbd7207485,
    0x3fe06ff3fe1e6bcd, 0x4002e5bb3bd72a7c,
    0xbfe2ab052058c954, 0xbff82fb2c550ce51,
    0xbff8486b4173b048, 0xc000f9dde3943742,
    0xc0042bac79cf361c, 0x400310633356604a,
    0x3feac48d25b23870, 0x3feabc280b237504,
    0xbfe82f28cf1feb45, 0x3ffb35e97dbd8c96,
    0xbfee2291b61bbc52, 0x3ff042cc6dd6fdbc,
    0xc00277ab8a0a1698, 0xbffd839a8caf1221,
    0xbfe26a0b31ab213b, 0x3fffa081d20e1354,
    0x3fe5c3187a63a9c1, 0x3fefaa3dcc524abc,
    0x3fb9caf001db2a98, 0xbffb384581c3796e,
    0x3ff7c06c8a1c9a14, 0x3fe8784b66b0a604,
    0x3ff241e83f31b837, 0xbff1f97f17d347ac,
    0x40020d1f95064a23, 0xbff75dcfdadd0407,
    0x3fb7aaec595fc760, 0xbfd13bba040a87b0,
    0xbfc3c3f73a65e05c, 0xbfdacbbf57d8e1ba,
    0x3fc9a8a4303ca123, 0x3fe873c5682bfa28,
    0x3fb84afb1dc12af2, 0xbfe5dc2cda962836,
    0x3fd7ab34bea5cd0e, 0xbfef3fcb8e21a438,
    0xbff455826a93f66e, 0x3ff18397ea8738ce,
    0x3febfea7cb996b2e, 0xbff7d92de8b77c2a,
    0xc00566d79b5798f1, 0x3ff5bc8b85d3b54b,
    0xbfee9b4bdb8c62af, 0x3fd5aa713d290278,
    0x400ac58802ee1c92, 0xbfd5f2d9982c5db4,
    0xbfe19227e38937a0, 0x3fda2a2671cebd12,
    0x4002aa8ade41028e, 0xbfe31249affbfdf6,
    0x3ff629ff77903bb9, 0xbfedccb5368208af,
    0xbff12eae388ae127, 0xc00d264791484704,
    0x3fd717b13abc9f76, 0x3fff035e77ace966,
    0x4001591736bb22f8, 0x3fc3d43869193bac,
    0x3fe38d7c5cef1223, 0x3fee2b1c40bdf9bc,
    0x3f34b95c0431d800, 0xc002537afaa7fff0,
    0xc003491364edde87, 0x3fea0a6ef2c32a61,
    0x4001eb6954aeee74, 0x3ff1103f19b978b7,
    0x4001291a80e9da3e, 0xc001fab28e3d201d,
    0x3fa34c28d866a1d0, 0xbfe319449d1b225d,
    0xbffe3d452713bffa, 0xbfde6ebf9bd085ae,
    0x3fcb5cb08c06e238, 0xbffe0d20ce1bc5e3,
    0xbff975dc4e1b0398, 0xbfeff6cddc6857ee,
    0x3fefc720198dbe4e, 0x3ff1ae4507cd91d4,
    0xc0076f3fe2378a45, 0xbff246b256a01de6,
    0x3fc094f7a9a4c334, 0xc0068abcd3acb196,
    0xbfd61795dfeca94c, 0x3fe3137ad0e0fa19,
    0x3ff0ef530382fcfc, 0x40100d8a3e60f106,
    0x3fcdf089647d3fbc, 0x3fe9e4ecd738a094,
    0x3fe74715e98a931a, 0x3ff7aae6e2e44494,
    0x3fdacb3fa4ba9922, 0x3fee8dbf72aedc1c,
    0x40044a3048c536c8, 0xc002e3e6263ba1d5,
    0xc004e6ae885a1948, 0xbfd465078ad0929e,
    0xbffdb76d50b1d350, 0xbff31a43bd9dff01,
    0xbfe8ba9f74e27c7f, 0x3fe4582a5f6517f2,
    0x3ff895fdaa4d3a41, 0x3fd50ca382775f94,
    0xbff13095590647bc, 0xbfdbe3be7d795df8,
    0xbfbee48c92f9d2a0, 0x3fffdc3042e2b1fd,
    0x3ff986df01ea2554, 0xbfe621f53f495e46,
    0x3feb43ea47997b82, 0xbff2b564152a6b0b,
    0xbf96df1b1d4c5730, 0x4002dc6dbfe87082,
    0xc0030d800e6852bb, 0xc00a987adb63305a,
    0x3fd3a1357879fe40, 0xc0018b7d3aa1c054,
    0xbfe5a1e879a08d61, 0x3fea86ec8d816d10,
    0xbff6be41ced22b33, 0x3faa6f00dd96b6d2,
    0xbffc430dfdcba618, 0x3fe51b5f5fa6fe69,
    0x3ff9445de36e36cd, 0x3ffd68cfbd0b0cea,
    0xc009e5d378ecf207, 0x3fe75c4437e37cdd,
    0xbffb705818c13e81, 0xc003d63d21db240d,
    0xbfd816ad18cd6c64, 0xbffbd20d7eceac67,
    0xbfce3dd3c674804b, 0x40052dd2c17b6ee7,
    0x3ff8a49d3ada4212, 0xbff44a2459983f50,
    0x3ffaf79057053fbe, 0x3fcf31f35ae8c602,
    0xc0075842faa11100, 0xbfc1c06e9627b3e4,
    0xbfeeb0eda0c7a0ea, 0xbfc0a55aa942ebd8,
    0xc0132742544d0cf9, 0x3ffcce09b4b0a761,
    0xbff97708391a391a, 0x3fccb156628a3590,
    0xbfa648ee0af32cf0, 0xbfb1d912188f5416,
    0x4000bef119dd524a, 0xbff713e398026256,
    0xbfe7450afa1e9d36, 0x3fe20c64ddae0251,
    0xbfb8d989abed50de, 0xbfd3410f36d0294e,
    0x3ff440f23f538238, 0xc006bb7a4b105746,
    0xbff6861a8c40d2c5, 0xc004598055dc32d6,
    0x3ff0e8691a9c153a, 0x3fe68aa51c613daf,
    0x4000ac4c5649ffc9, 0x400be4919e78c426,
    0xbfb2f4597fa3aa90, 0x3fe1aa786f40d261,
    0x3fd178930859c95e, 0x4005a3e574eab180,
    0xbfef0394f9d43df9, 0x3ff4aa42efe87bc5,
    0x4001b31d5ccf4da7, 0x3fed1e48700873ec,
    0x3ffd7cceebe10fca, 0xbffaace70aabad5c,
    0xbffd5d856572d5ea, 0x3fe86319ce86249e,
    0x3ffe11f24f8b2e80, 0xbfcf2217d34d9790,
    0x3fcdb6e3762990f6, 0x3fed4727ec179754,
    0x3ff7703e718aae2c, 0xbfe63a508a502089,
    0xbfe2105785e693db, 0x3ff401bd37fcead0,
    0xbff49720c4737510, 0xbfdc007d15060e3a,
    0xbfd94ec9d1f19c3c, 0xbfc29fbcbff9a320,
    0x3fe5e977bf554b3a, 0x3ff18275990a35fa,
    0x3fe7c1ebf0714085, 0x3fe9f3c91a709b10,
    0x40034f958ebcd66e, 0xbffe7a1dceba6bca,
    0x4005835f8b6dd78e, 0xbff9c8d1cbd3536c,
    0x3ff472f6105d836d, 0xbfe67a869745b061,
    0xc001d2874c681101, 0xbfe1f2545876b38a,
    0x4005e99bedf23ae1, 0xbfdc7e84c2ca3a28,
    0xbfe61b48a60c19b8, 0x3fd24012e56ed30b,
    0x3fbf133b92c40138, 0x3ff78c6ae4886a4a,
    0x3fe85083e03bbd64, 0xbffe237d11118cf4,
    0x3ff896e36a8b00d7, 0xbffeed66188434b0,
    0x3ffd1b5ce23cb031, 0x400744cb9ee30e42,
    0xbfd8635472ded202, 0xbfeeaaee7b0385f8,
    0x3ff60e8d33047dde, 0xbfc29906bb1fa1d0,
    0x3fd2923f2e99a17e, 0x3fd1844fbaf33476,
    0xbfd1751089ec0fb8, 0x3fecfb7e99d89504,
    0x3ff6d66a706013c0, 0xbfe8fe28de01b719,
    0x3fcb2fd4f96733bc, 0xbfe0a6ab74b75000,
    0x3fe5c96890311550, 0x3fdc464982cee30a,
    0xbffe9934c65c9796, 0x3ff6a2f31a8d2f35,
    0xbfffc37270892a54, 0x3fe57fcb1cadb37f,
    0xc007b5366b0582be, 0xbfb68f7c42efbee0,
    0x3ff3f7950fca3750, 0x3ff0784bbe9fbd2c,
    0xbfdb900fe6ed0f05, 0x3feb3c3d920c7fd0,
    0x40002f7c6846b07b, 0xc001732bd61f28ea,
    0x3ffc75b14ae1c130, 0xbfbd30ecc1815b20,
    0x3fea2569afdc4042, 0xbfefb74bbda3f939,
    0xbff8eb5275077d7a, 0xbff1229b8515c616,
    0x3fcad47b7fc857c8, 0xbfe30398e2d854e7,
    0xc008bb3b19cd00c6, 0x3fc98eca8d9ce65c,
    0xbfbf4dad2298cac0, 0xbfed5ed6f54eb6b4,
    0xbfed48887e01e666, 0x3fea11a8bbefd060,
    0xbfccae18873624e3, 0x3fcf237090cdbfd0,
    0xbffa57241bd8ed3c, 0x3ffb461b952f6a40,
    0x3ff0571187a85138, 0xbff8a9b238b610c6,
    0x3feb76776602f1b8, 0x3ff0519bfaf92074,
    0x3ff95254e51b80ee, 0xbfeba12f3dc812d0,
    0x3fe602e8a634c670, 0xbff2341bb995e11a,
    0xc003e4a121d13f9e, 0xbffc542fea9fa44f,
    0x4004899959826284, 0x3feeb47af9851dba,
    0x400f077e31ffdda4, 0x3feb173dc368185d,
    0x3ffa4736e9bb7f9b, 0xbff7b86218ca0f53,
    0x3feee388dc2eced4, 0x3ff75516f0403ac4,
    0x3fddd20491ea6180, 0x400b15c6a4d2416b,
    0xbff302bd88de0af9, 0xbfd5fee30fff6d7f,
    0x3fd55deb86d36efe, 0xbf80b1f3c0912000,
    0x3fe0ae16dfc2a448, 0x3ff59c610ce1f446,
    0x4001e7b20bfffbd6, 0x3fdfb7ccb8012648,
    0xbff4a525d6a5bf86, 0xbfe634bf3ed4d8a9,
    0xbfc733f81f4e9ad0, 0xbff5b31fdf5046be,
    0x4003d24b1fac2b03, 0xbff647099fe9645a,
    0x3fbc8a6f11e24538, 0x4009eff3d9768026,
    0xbff8651bd0fb57e0, 0x3ff710bdff38e3e5,
    0x3fefe5fc4b015ef6, 0xbfd51c942e0fc7f4,
    0xc0076785ec64ae95, 0xbfe0c4ddc397ab1a,
    0x3ffc4121021b2f63, 0x3fec40eff609afb9,
    0x3fd64b720bae40d0, 0xc0007a7c4bc13e91,
    0xbff10e9d5c11d6cc, 0x3feabc01812364bc,
    0xbfdb9646f334f790, 0xbfccc49e125015e5,
    0xbfd575d713b9a8ac, 0xbfe99ee240c7d202,
    0x3fd1ef6ec07a3df4, 0xbffae40cf2c1cf9d,
    0xbffa6337f04d26de, 0x3ff0e056ff752ad2,
    0xc00975825dd1a51d, 0x400a13b42273162c,
    0xbfe4e2fa57204faa, 0x3fc088066b873d1c,
    0xc01668d28b6e2336, 0x400626fbf967b3b5,
    0x3ff9a54e20777e94, 0xbfef93a0f4221c98,
    0xbfeb9fb91bfc5a14, 0x3fea90d20fee7ed6,
    0x400b860a3d7f28af, 0x40017051fe1f8eac,
    0xbffdf291317c8178, 0x3ff802658530fde2,
    0x3fff9a54c2b69504, 0x3fe828993fc3c22b,
    0x3ffd6961418f69da, 0x3ff09c44574675b4,
    0x3ffd074b32528648, 0xc0002dfce1d1eddf,
    0x3fa2cbaa0f32c310, 0xbfba78a2d261b9c0,
    0x3fd6d3e972091e98, 0xc004197594f3c203,
    0xbfe14061c2d5c230, 0x3ff8a178e7e2b7a6,
    0xc008565faa0ef876, 0x3ff214b40c374ca5,
    0x40082dfce71558b3, 0x3fe88c190b19e04e,
    0x401071a1462c7ef6, 0xc019f545f7e746a0,
    0x3ffdc6bca8cfd8ef, 0xbffaa271e1334aec,
    0x3fb8e0b74585ee8c, 0xbfeb72c8f8689eb3,
    0xbf9208ab9bfeeec0, 0xbff08ec100fc72ce,
    0x3fd408b351aba24e, 0xbfd99643a12aa429,
    0x40012f4a51ee7cfc, 0xbfe8a4cfdac3f75e,
    0x3fff9f4b02d585d6, 0x3fdfb7cab251112e,
    0x3fff6e15da275330, 0x3fe61f938a27ba45,
    0xbff199afcfee6897, 0xc00f248326d85284,
    0x400c0537fa417fdf, 0x3ffcdba372a2e3b7,
    0xc0109847b188c028, 0x400688a8b684f860,
    0x3ff3cde9c67f31ee, 0xbfdede36bc4473f8,
    0xbfd19255d6e8ad54, 0x40016442986ee450,
    0xc004ab214073c53e, 0xbffea7ba983398a4,
    0xbfeea6c983c65ee6, 0x3feee592533b0f76,
    0x3ff102add34cb2dd, 0x3ff512211d90bff6,
    0xc0033c757f991fe4, 0x3ff84a3f3e77c0fa,
    0xbf95ae94357edfe2, 0x3fe6be181fa907f6,
    0x3fc2558222abe2e8, 0x3fe11d4efd8e93d2,
    0x3fea66e4f9d6bd4c, 0xbfecf281787d637a,
    0x3fd3631d9da50176, 0x3ff8df575d749304,
    0x3ff8df54259d78c8, 0x4009fb2e1d059ea6,
    0x3fef6d47422bab4b, 0xbfee17ae05ead467,
    0xbfdcd50c72d60622, 0x3feb7e8e86ddb2ae,
    0xbfd47625e5c59fb0, 0xbfcebf68e764d810,
    0x4003a4ee7d235d46, 0xbfec26b940a0dc27,
    0x40042c3d67348d75, 0xbfe47fb8f390078c,
    0xbff2dc164a9563ca, 0x3fee54d36e6a9d0a,
    0xbfd2e6284e0d607e, 0xbff6d0dc7c0664e3,
    0x3fc0a08dcec70fc4, 0x40026a2e6304b4f5,
    0x3feabb6b34cc638e, 0xbff08ebbb695a9fa,
    0x3fef7e9ac4577912, 0x40067badd2648fce,
    0x3ffce8c553d4aea6, 0xbff98fe8b08ab071,
    0xbfc3779a2dec0830, 0x3fcfc0895c7d5342,
    0xbfde924804bd6ae8, 0xbfd3f3cf40f2f2b2,
    0xbfe0e581c78130f0, 0xbff77e152db9ccfd,
    0x3f8c036b89408a00, 0xc0046c6718ff8ca0,
    0x3fea4afc95c24ade, 0x3fddc87cff6bed0a,
    0xbff427cb7dd4f608, 0xc00180eaf251ffd9,
    0x3fe5ed77ab6cf3c5, 0x3fe2c3f68baa8fab,
    0xbff183916fc2aa6e, 0x3ffb7eae343e32c7,
    0xbfe92e1d0d65e5de, 0xbff91c835f8daba2,
    0x3fd579b22b889688, 0x3fc2c68ca5d70914,
    0xbfeb644e3732e24a, 0x4001fc3b59cfaa54,
    0xc009405cd4d2c008, 0x3fe7c8a6ce0a1701,
    0x3ffc2c601339f9a0, 0xbfe82f487a321539,
    0x3fe5d9191858cbda, 0xbffb1c0dbabf6690,
    0x4000b6824022888e, 0x3ff75f35c9e55ea4,
    0x3fcc8ba6f25b9ef4, 0x3fe2f461e6f6af21,
    0xbfdb70544573a31c, 0xbfdf1ac5e8e40be2,
    0xbfe18dbe9e732b9a, 0xbff348f6097054c5,
    0xbff172025ee3d342, 0x3feef9836a58ade4,
    0x3fe483fd3805ab39, 0x3fe5ad7ee538eeb9,
    0xbfe3812e0569601a, 0x3fd2ffdcbf2a2c4c,
    0x3fcf386b91d5f680, 0x3fe58b08a687a7e2,
    0x3fc76f315c9d4bec, 0xbff50da452ea8e9e,
    0xbfed35c8979a2df3, 0xbfe7167c528f1142,
    0x3fdd3c8165c7db04, 0xbff84897d004cca6,
    0x3ff5e45c956e4f8c, 0x3fe85f7e36bec922,
    0x3ff9c2150935f570, 0x3fdae2d31b3daf1e,
    0xbfe988bd0bea4198, 0x3ffc26f87b0b807b,
    0xbff88105dbc5dfa2, 0xc0078365b190723a,
    0xc0077c2a72e74474, 0x4002fb9676ff2183,
    0x3fd7dd2659fe454b, 0xbfe9a62d17d48634,
    0x3ff4d3ce88150182, 0xbfeac8f8019dc7a8,
    0x3ff38e8efeabec57, 0x3fb24e337db3b3ac,
    0x3fde10403089676c, 0x4000d448699226b4,
    0xbff990fd387f8ace, 0xbfee6b2646094b8d,
    0xbff86dfddb3784d0, 0x400277d4476aa86d,
    0x3fed5875cc787114, 0x3fcf57cb09b136b6,
    0x3ff0cd49da7ee84b, 0x3fd33a85cc238e92,
    0x3fff52e90c4bb759, 0xc00d14449ceb480a,
    0xc002be4bb7acffac, 0xbff62dfef42a283c,
    0x3fdaa83f495c274c, 0x40055ba1c2b9bf53,
    0x3fa458e9d4d81780, 0x40014e5b16e5b306,
    0x3ffb595992022678, 0xbff089ed81ef87e3,
    0x3fcbf4be4669fc80, 0xc001bf7e9172c9a9,
    0xbfe7286f1fbb5530, 0x3ffadddbc97dce24,
    0x3ffa5fabd1a2efc0, 0x3fd728b659985bb6,
    0x3ff9f84b739eae08, 0x3ff9322affd82058,
    0x4001215081952a85, 0xbfe1568030c4cfd0,
    0x4005f7badbb5ea87, 0x4013a4a1281a5edd,
    0xbff2662d01479b35, 0xc0010d9e1ce4ac13,
    0xbff5334eb16eefa5, 0xc0095144cb79cf35,
    0xbff0779fd0efb26e, 0xbffd1254b3a89c82,
    0x3f9f3e19099346e0, 0xc002ac49a4f7c0c6,
    0x400c8fb659f1a5fc, 0x3fcc78925c9f0504,
    0xbff962b937a508ef, 0xc0075d23d4466c8c,
    0xc006d076bf0dfea3, 0xbffd9c127d707c98,
    0x3fdf85eb56738ffa, 0xbfb3391d7a5111b4,
    0xbff2f2bc5bd51324, 0x3fe95e87d445bb20,
    0x3fe34a808864cc29, 0xbfe5633a19ce1dae,
    0xc00c31d421c2ce02, 0x3fd652ac03dc3383,
    0x400548528ac801fc, 0x4009fa69db55fbb4,
    0xc004f8ed4a8dbe18, 0xc0101f173756c038,
    0x3ff498e62aa410f3, 0x3fe93b1a1e09118c,
    0xbff04b272cb923be, 0x3ff19442745be07d,
    0x40031eba9592f581, 0xbff5f29d544320ca,
    0x3fd6957c7a3348f0, 0xc001750f200cd1d4,
    0x3ff93081c08a2636, 0xbf96440d93096bc0,
    0xbffd1ca26237d360, 0xbff42e2dd329dad6,
    0xbfffc066548cc7ef, 0xbfed01ce8b994aa4,
    0x3fe36f6dc3c4d181, 0xbfd06cd597a94a38,
    0xc0087ed5a4ae2e1f, 0x400ba9786498456c,
    0xc00658c544440b6e, 0x3fb7bcc805b19e20,
    0xbfd3723e764ea908, 0x400416a2856738f9,
    0x3fc1045887d617ca, 0x3ff0c897c93c7e56,
    0xbfca189afdf355a0, 0xbff4f66f28391b7c,
    0xbfd77274b683651c, 0x3fe360d59e08ad2a,
    0xbfb4284e9e769cc0, 0xbfeb3e54306bf03c,
    0x3ffbd65a05ef6c08, 0x3ff283c5770bca74,
    0x3fc95b803c068020, 0x3ff56c6d77a0f69d,
    0x40038a278355a676, 0x40073e728f745e3e,
    0x3fe54f1239b87b88, 0xbfea66e020c38d50,
    0xbfc6223180e230a6, 0xc0055739ab293276,
    0xbfd8cddd96e74ff6, 0x3fc9f753b373e310,
    0xbfe632ec8015a194, 0x3fad10b62d234888,
    0x4004ab91e4b21838, 0xbf91f02449f0c660,
    0x3fe44cf2531d8f81, 0xbfb626a4976a82a4,
    0xbfe5de85495ccef4, 0x3fed187381698d81,
    0x3fe9e235c1c42abc, 0xbfdfe0ac30f66c18,
    0xbfcbb79e5332216c, 0xbfd34efdcf120728,
    0xbfd69ddff7bfadfa, 0x3ffa090dbb22cff7,
    0xbfed4bd5564fc36b, 0xbff1035f6d0c8735,
    0x3ff06dd96f8d56e5, 0x4002bc0bf868d68c,
    0xbfcd602daf300609, 0x400f63a1892768a8,
    0x3ff6cc0f1c7070df, 0xbfd5f6d25a00eab2,
    0x3ff327902e1c9e1c, 0xbfcd7578cab11422,
    0xbff148e7f2e93be7, 0xbff66381087aa98f,
    0x3ff51210519e914b, 0x3fcb551eb95a6cfa,
    0x3f51a80d8ba53300, 0x3ffcd189e097ca1b,
    0x3fe3f09c45a067a8, 0x3fc39ebb205ebfaa,
    0x3fd47fefe336e4fc, 0xc00c461264f5c1c8,
    0x3ff44b7477bebc8f, 0x3fec3d161dd67d3e,
    0xbfea940df693e097, 0x4005a757bbfa181e,
    0xbfdd05aeea0275f6, 0xbfa44785ae649ae8,
    0x3fd1da0115a48098, 0xbffac3d972181b46,
    0x400b2177ae870c06, 0xbfdfe1a000f86850,
    0x3fece15d4f402613, 0x3fe0964239a90e81,
    0x3fc6e686666368a0, 0xbffec7be2f889fb1,
    0xbfd90e7f577345e4, 0xc0030afbc345e364,
    0x3fd97c04e4d84224, 0x4001277065567b32,
    0xc0013d77bc3db1ea, 0x3ffb3d5f3387ec34,
    0xbfd94cd571f1f3e8, 0x3fdeff24ec5a655a,
    0xbff9099d2d441b22, 0xbffa0dad2df68604,
    0x3fe6e31ce2bacb8f, 0xbff0c6194a5dee98,
    0x3fdaeb6960c209f8, 0xbfcf12df424d79e0,
    0x3fea4d039c364e89, 0xbfe745ac696182a4,
    0x400fd41bb984d82b, 0x40015884ea5692f8,
    0x3ff9d448c9236a54, 0x3febd6a88d75f542,
    0xbffb3b626d23700e, 0xbfd22b601bee3718,
    0x3ff092f1e1110a64, 0xc00683a461436471,
    0xc0022c56bb76281c, 0xc003f9f5980a3ad2,
    0x400146aeadc53077, 0x3f66206736cce400,
    0x40078efe9930e0d8, 0xbff5971fceefe628,
    0x3fe853a5b55dd56f, 0xbff63ce9433b9d8e,
    0xbfed47695c45c4e4, 0x3ff7aab6ef87a86c,
    0x3fd6581da294ee3f, 0xc00a3c99f6c9e0e8,
    0x3fe15f4c721ced3e, 0xbffe733d8638a9dc,
    0x3fe28fd627ccabcb, 0x3fee29fc325e5959,
    0xbfd4fbc6a65bcaf6, 0x3ff1b32f0ffca982,
    0x3fdea08d13cb13d8, 0xbff9eae155889fba,
    0xbff80a29d315fc49, 0x3feaaaf8202571bc,
    0x3fe5c6e6251c9f34, 0x400167be216e9f4f,
    0xbfeaa6870d333e7e, 0xbfb9577788de7020,
    0xbffc4ee13f0974d6, 0x3fdc146dc31165e9,
    0xbfc18f7f243f4166, 0x3fd290ac2a5c4eb6,
    0xbfe8ce50652b8f8a, 0x3ff15bb908b64f06,
    0xbfb0f3129f5777b8, 0x4006e263929c4b50,
    0x3ffa435f11ef3082, 0x3fe88aaba049a53b,
    0x3fba3d6ca5a046a0, 0x3fde9ddee450ad10,
    0x3ffd22db99d76e20, 0x3fdfcf76385dee11,
    0x3fe14a2c51dec5df, 0x3ffc05c5fbcb4d34,
    0x3ffeca006ea4df36, 0x3fe9e8f01654caca,
    0xbfbae7fe07618ba0, 0x3fc4b7b86303dd72,
    0x400456221cbc19bd, 0xc000ffb58f12f51c,
    0x3ffbd1a82755a6db, 0xbff659ca448e8822,
    0x3ffb524ce8b24dd4, 0x3fdd518f619a4250,
    0x3fe88d6af48cbd71, 0xbfe80e63c9ad50bc,
    0xbfdb0769b099edc8, 0x400240313d255c4a,
    0xc00cfd1c585a7518, 0xbff125dba22fca73,
    0xc00d9e288a78be22, 0x3fefc17eeb07cbf5,
    0x3ffecc23914c9d06, 0xbfea0a85e3175072,
    0xc007d02a4deee317, 0xbff7ebb96cb66636,
    0xbfa43f7a53d75e80, 0xbfe2fae52b72c096,
    0x3fff7c797563a096, 0x3fe2d6567c0ba4c8,
    0x4011fdf1e8e93181, 0xc007a65db7e76369,
    0xbfe9e0561d6d2aa0, 0xc000ce435a644ec4,
    0xc005bb63070d3531, 0x3fe47715db811d22,
    0xbffd4eef1851a3ae, 0xbff19a7093f70b86,
    0xbfeb30ceca472f60, 0x3ffee5d519a20166,
    0x4001445f67d092f6, 0x3fe1e23bbd8d01ed,
    0xbfdb1ecdabef61d8, 0xc001329f88c0f9c4,
    0xbff16a9c70410e85, 0xbf8c2d8516d4cfa0,
    0xbffcb923343b8324, 0x3fee1c13cf4e47bc,
    0x400121c56e39e9dd, 0xbfd9005bc1ab2ce8,
    0x0
    };

static const uint64_t ref_rfft_noisy_2048[2049] = {
    0xc01405d8ccbc9b1a, 0x3fec3570a7070430,
    0xbff57ed5eb3783f9, 0x40090b2d821d009b,
    0x3fe4103f98478e29, 0xbfd7abb315a7b76c,
    0xbfee33b9a7f286d7, 0xbfea261c54e2c148,
    0xbfd349226edce82c, 0xbfd8e9ae13fdbe84,
    0x3ff86fa651c2d912, 0xbffbad39fb03d090,
    0x4005a1c8e713fd94, 0xbfdec61c2bec465e,
    0xbfd14d0b0d057ab0, 0xc0008cfd4c8fd3f8,
    0x3fd67c8a8f7c8e30, 0x3f8d858074a11a60,
    0xbffd034d7d5b7998, 0xc003c3adbccc07f0,
    0x3fe48800e9b984f6, 0x3fec6b2929b6515c,
    0x3fda05babd70ec16, 0xbff108ae1613f100,
    0x3fdf515fa16afc34, 0x3ff64a6026888d6d,
    0x3fefe43c45df393c, 0x3fe0d91fc3e1bb7c,
    0xbfea42828cd4d7e7, 0xbff646c5328beb97,
    0xbfeef5573c6f3870, 0x3fce7cb668774474,
    0x3fb85284c70bf630, 0x400507651b34a2e8,
    0xbffa1b5191af528a, 0xbffeb8d9ed12754d,
    0xbfec090464d62ebf, 0xbff90742e5a79036,
    0x4008e5f3aecfeb46, 0x400462a8a84ce410,
    0x40044c60acefc073, 0xbfd62bdf66784130,
    0x400dc9fa6e22d7dd, 0xbfef2fab51736084,
    0xc00606a2cb3df32b, 0xbfc3828f88aa086e,
    0x3fe663ec70706c94, 0xbfea2839fef36f46,
    0xbfee1cdf8c96091d, 0x3ffc23cc6c666718,
    0xbfcd27f5cef4e680, 0x3faf8c420e484b18,
    0xbff962e0089fbc22, 0x3ffdf8a6d441facc,
    0x3fcbaa64f6bc3f24, 0xbfe41d92a1f7f1c5,
    0xbff72ab08314a78e, 0xbfdf79a404482ac4,
    0xbfd354a5eab974bf, 0x3fea6fc6a98166ca,
    0x3fd771b88506175f, 0xbffd2466adfc5f52,
    0x3fc4c18fdc3bdf10, 0xbfe9ccf0d01f1418,
    0xbff7747e82f5f4ef, 0x4013a35a95fc7946,
    0x3fc7788fbffb3524, 0x3ffc324e33a9ebe2,
    0x3ff6eafeb45f7c95, 0x3feda87c8116226a,
    0x3fddf140c00a6d84, 0xc008afe96c362011,
    0x3fe95d1bdcbeae47, 0xbfc74189127a3828,
    0x3ff3844203255be2, 0xbfc5483cfebc5a4c,
    0x3fe580ec4b99f96a, 0x3fcbc234a8b1f530,
    0x3fd1203c25a7c963, 0x3feb5f2204fa5bd2,
    0xbfe93ce099e735be, 0x3fedad15c2a9a36d,
    0x3ff2ea5c3bf28b23, 0xbff48a73c0cca0d4,
    0xc00196d4449a425e, 0xc00acda988bf262a,
    0x3ff55be3d34d57b8, 0x4001328fa0bed224,
    0x40014125fb7b0da4, 0xbff504fcf72c3c23,
    0x3fe2f621f945b70c, 0x400509cdd48a0adb,
    0x3ffc0cde4959b2ac, 0xc00e146cf8358023,
    0xc00a0d2a692b00f4, 0x3ffc8a3ef65bbf07,
    0xc0002f7fa880b51d, 0xbffd073a33e909d2,
    0xc002bdf8c23cc362, 0x3fd8f8469ca7ab88,
    0x4005e5d319a4bc27, 0x4004e20ce587161b,
    0x3fd541ff78b66892, 0xbfc421231d6157b4,
    0x3fcf17bbf08457b4, 0x400097a37ae990c6,
    0x3ff179cb36f720af, 0xbfe635c6a03fbf07,
    0xbfde9c53cf0fed70, 0xbfe5a36980581379,
    0xbffd37b5c3b59567, 0xbfc1a79448999908,
    0xbff3c6c35d620daa, 0x3fba1e6d5d61fe90,
    0x4000330aeee71c5e, 0x3ff6a719998e548f,
    0xbfffe0ca2c29ef32, 0xbfe1088b97033843,
    0xc0105ccf03c74704, 0x3fc651bd4f8e1bf8,
    0x3ff1942230cd6fa6, 0x3fe947b791c04e1b,
    0x3ff9bac8034b3c12, 0x3fec2a74762d1e1a,
    0xbffd902b93f8b1ec, 0x400a2bc8e4e12bb0,
    0xc01025f8557dac09, 0x4000454103ef561a,
    0x3fe1aa98f3b335b2, 0x3ffb494d83badac4,
    0xbff45cca6cbf5fb4, 0x3fb399c42f64b33c,
    0xbfdecfb559384fc3, 0xc0056ea79afabcf1,
    0x3fdfcea50cda3bdd, 0xbfde01755502b84f,
    0x3fd2b0dd3d8bf990, 0x3fdf57a4710fe3b4,
    0xbfe051789ec2f778, 0xbfd7bba36ac3bbd1,
    0x4003a04aee7de2c0, 0x40001da1c8519cda,
    0xbfe03fbadca97c42, 0xc00a38d66ca7746e,
    0x3fdacdb45bae28ac, 0x3fbde32cdf4ba870,
    0xbfeb5a35b5927c45, 0x3ff2e9f546521a49,
    0xbff6d7b0224bdde4, 0xc002adbda8bd13aa,
    0xbffcd8b4d1d5a0d0, 0xc00b49581abad33a,
    0x3fe390a9fc52a2ec, 0x40090ce1e564684f,
    0x3fb3f6184498b02c, 0x3fb3f3ff1407a4c8,
    0xbfea634de58abf75, 0x3fd9b548b8c4bb74,
    0xc0019d43561702f8, 0xbfead18d98ea0a11,
    0xbfea9b8715361e60, 0xbfe7314fc52ea102,
    0x3fb83b2bf7fe5ef8, 0x3fde633e21158f9a,
    0xbfe3334fc1474176, 0xc01347d68e7e79f6,
    0xc00ef8f277d25cea, 0xbffa33eaf6e95f40,
    0xc011a774fe7efd9f, 0x3fed617f81832b02,
    0x400c5d3082208b6a, 0xbfd6d0ff0e8308e9,
    0xbfe5aebc6e24e7e3, 0x3ff68d7f1ff53252,
    0x3fce4e98e5dea3c4, 0xbff613c3cadaf5ae,
    0x3fefa152e86c6056, 0x3fedd0b5aa97f418,
    0x3ff0a1ea53bab26a, 0xbfeb6f6733926b8c,
    0xbff0fdf4f4afc4a2, 0x3fda89843d83793c,
    0x4002fa9fc9fbe391, 0x4008265b02e65e6f,
    0xbfe04d15d4ea5da6, 0x40011e9466396081,
    0xbff9f5308e0728fa, 0xbfe6b73c7986d5ba,
    0x3ffb5f9b171c0744, 0xbff881731b72c19e,
    0x3fdc004aff3c44ac, 0xc00fe9a133a12ef3,
    0x3fdd8d39a7e440d8, 0xc000403a715c52d5,
    0xbfdb162e2d3d82be, 0xc00b75f2c4cd4d82,
    0xbfe50264185a0868, 0x3fd02778f81509d4,
    0xbfda76b243d5544e, 0x3fe60a84f9c90674,
    0x3ff4bacb6f2dfd54, 0xbff2374945271d67,
    0xc00810ec9a79954e, 0xc011e0a83f838b96,
    0xc0044fc1b3e0483e, 0xc010138617b9c570,
    0x3ffb26ad675082a0, 0x3fe13342a3e7b2cc,
    0x3fc5f4749f54df28, 0x3ff2e174265ecb1d,
    0xbfc9581bb3633dc4, 0xbfee9a60dc8c1702,
    0x3ff072a6b4c967ec, 0xc005a21bcb6ba7f3,
    0xbfff57503fd447be, 0xbfc68d1adcafa846,
    0x3ff7131220ae26c2, 0xbfbf192c7be2db18,
    0x40013924e8938340, 0x3fe5052afd74c1c8,
    0xbff1aaa9cb56e30c, 0x3fed3496658c4917,
    0xbff19a96618a0fd8, 0x3fcfcc9ca0255bf8,
    0xbfec1bb85f0d1319, 0xbff3a01e2d77bc38,
    0xbfe8ad26edf41aa6, 0x3fd5658bc4609ba8,
    0x3fe77bfff5a5cf8a, 0xc000f207df0d133b,
    0xbff7545a44e26baa, 0xbfd5b944b225d450,
    0x3fd0e8e188b58788, 0xbfbd599818e84908,
    0xbfb7075c09c7a860, 0xc009f07f8d3406f4,
    0xbff32f4ccd31095a, 0x3ff98db7de865fb8,
    0xbff733467cc122da, 0xc0015fec12bdcecc,
    0x4005368eb1ef8663, 0x4006938e3d88aa45,
    0x3fd09c7597b5b11a, 0xbfe077742ad1f8ea,
    0x400419536a4ae362, 0xbfa19927e7d4ac60,
    0x3fe3cb4da5052aea, 0xc002ddf8bbda165d,
    0x3ff5aa35bbdae038, 0xc0097ae2dba0cbee,
    0xbfdb21b6d9cf78a4, 0x3fe139b525195aa0,
    0x3ff92b2cbbba8a09, 0xbfe2d6949296dff5,
    0xbfee4d0911afdf5c, 0xbfef9fba5186f66e,
    0x3fb0df68cff93618, 0x3fe547cfbc64e890,
    0x3ffd91adfd596bf4, 0x3ff0e0ee4262da1e,
    0xbffe1f090bce66ed, 0x3fe4b2dcacf76442,
    0x3fff1eb45cd9848f, 0xbfd6942e7e47c455,
    0x3f63a73eb345b000, 0xbfeba91f994a614c,
    0x3fdf0cf209c00a89, 0x3ff25f6129e7a2a5,
    0xbfe59a0501705318, 0xbfd8d24c4967e4b8,
    0x3ff45066803a9dbe, 0xbfd3b8af3b3c4c94,
    0x4002c8934acae5a9, 0x4003680d671efa66,
    0xbfeb67b7db6cd4c0, 0xbffd429a2aa808c0,
    0x3fe0e15ec093229f, 0xc00b3f87dd5640d4,
    0xbfffc441a94ea137, 0x3ff32944c3dd7662,
    0xbff9608f40cb4d80, 0xbff4b3cdaa63eb1b,
    0xbff32544d5d2f8c6, 0x400c08fa8a98b7f5,
    0xc0073a20628f50de, 0xbff7a1c6c948cf0d,
    0xbff866a7900c46d7, 0xc00a8891ca8b7018,
    0x3fd6a35574a1b7e6, 0x3fe779fa6a9da793,
    0xc004fbc6e749d30b, 0xbff0f43e722753d2,
    0xbfea1e00ef21e856, 0xbffbb58d00088c7b,
    0xbfef4b01e040b3ae, 0xbfa0f96a80a41410,
    0xbff02958918d3a6c, 0x3fe3c47a88482be9,
    0x3fee4434b64e074e, 0x3ff19589f5a9e03a,
    0xbff7aa9873a74e39, 0xc0075e1625ebad9e,
    0xbfd7b4d7e8d3b922, 0x3fba2ecbe7bf7028,
    0xbfd802a4ece0f850, 0xbfe9a3876369090d,
    0xbfe59aa8aebc37c0, 0xbff20cc735a0ed0c,
    0x3fea559f124898c2, 0xc000eaa933e55628,
    0x3fe5e25b3318c97a, 0x3ff0ae49b30fa286,
    0xc00496aa4b318e22, 0x3febbf13f9e52d32,
    0x3fb8e0428cd23dd8, 0x3ff0e0cb9b6fdc2c,
    0xc0049cb1a315620a, 0x40000c4b495c4555,
    0xbfe1767fc2ac8d5e, 0x3fedecba104f243f,
    0x3ff831c31abac651, 0x3fbf789c78e76990,
    0x400db3c5fbf388ee, 0xbfef87206963672e,
    0x3fdb1204bab79b9a, 0xbf9dd5efb0833140,
    0x3fcffc860dee5688, 0xbfe7637e8a80161a,
    0xbfbee93de0151a90, 0xbffa6622417c71bb,
    0x4002cdf6dde75c92, 0x3fdd48adec68cfc4,
    0xc004beb993d728aa, 0x4011808f11ab8e44,
    0x3fed0e3b5e386015, 0xc00496faf7acbca1,
    0x3ff511cfa3d0beda, 0x400d463837e1b8ce,
    0x3ff299898ff40dd6, 0x40022f7751443890,
    0x3ff0d612582ad86c, 0xbfe3b769ed7abb40,
    0xc006fb4c9a1c1314, 0xbfe036fa5c65e4ed,
    0x40014ddd68ffa4b7, 0x3fe511f7b35a59c4,
    0xbfe01be5e70d4b77, 0x3fe3ebb884f5ffae,
    0xbfc9734bce639a4c, 0xbff1a2b71fb772b2,
    0x3ff9f73c3f9a992c, 0xbfe96a05941b3628,
    0x3fec598a9f1313db, 0x3fe7e97eac852a88,
    0x3fee99404e98ad7c, 0x3fce44c74a7cc6f6,
    0xbfed1b338bd53dda, 0xbff04de2cf877272,
    0xbfbdabd762c9a638, 0xbfe07dad491fd8b4,
    0xbff597d0213794b4, 0xbfe291ab583585b8,
    0x3fd9805c0d9d0aac, 0xbfdc4a10541a49ea,
    0xbfeb0492dd9964b6, 0xbff72f5e3e7a1d5d,
    0xbfe4e8368521081a, 0x3ff77b7c15cf415e,
    0xbff6e14040b45f0b, 0xc009fd166d1fd9ca,
    0xbfd95d229c69ca21, 0xbfda5edbd048f6f0,
    0x3fd04914e47bf738, 0x40024b92c7d704d4,
    0xbffce258cde3deb6, 0xc004613a57c98334,
    0xbfc03a4095ccb270, 0x3ff121701af8f5b3,
    0xbfd100ee4b3ff248, 0xbffac54d7547fa2a,
    0xbff54f9bdf13247e, 0xbff483bcdae295bc,
    0xbfd360f5bd89ac2a, 0xbffea730383a2b2b,
    0xbff7093122f3077e, 0x3fe7b16ac5ff2bd0,
    0xbffdf82b2c3aebdb, 0xbff4ca38a76064be,
    0x3f826ee76dfe59e0, 0xbfb856f3feb3ad48,
    0x4000cead697c6566, 0xbff79e4ef4bd012a,
    0xbfef4ccb10b82620, 0x3ffb3b2b04febb8e,
    0x3fff2de41bf864aa, 0xc001ec35341be598,
    0x40035e03efe4ce4e, 0x40079a486f558322,
    0x3fda2be673db6b41, 0x3ff74dc0e668a772,
    0x3feb60b8f2a4d0e0, 0x40030c45c4bcac47,
    0xbffbd9bd032d41b8, 0x3ff90ab061e01462,
    0xc003d89a5006a5f0, 0x3fe162909e642d8b,
    0xc00b52b934c697e7, 0x3fb252f63e397110,
    0x400444b1f395d39c, 0xbffc59d73f61cb2c,
    0x3fe98e4c6a320dbc, 0xbfeab6533cd12477,
    0x400208c76072a559, 0x3ffd8be1c4ce78a4,
    0xbfd5f38b454be2ac, 0xbffea65f158ba85d,
    0xbfcfdeb6c152f420, 0x3fe9d456cce11d50,
    0xbfa465072c03d080, 0x3fe5f0bb44b3a8a4,
    0x3ffd570df0f831e3, 0x3fec457cd79b405b,
    0xc0026af7a30c0803, 0xbfdaab594c5be3cc,
    0x400428bac1a5e549, 0x3fffabedcde96cc2,
    0xc004e473f3ebce3e, 0xbff17875e95dd057,
    0x4001d1dace816018, 0xc0052220ec90c112,
    0x3fea9ab8b8e4be3e, 0xbfcb2127411ada7d,
    0x3fe370ea43073a24, 0x3fd78b15810258c5,
    0x3fe7c279bc71e444, 0x3ff7b7f1cc5932d6,
    0xbfecb031c42755ca, 0xbfa38c29bb373a70,
    0x3ff60b2a8d362b72, 0x3fe93e27c4f617f4,
    0x3ff0747bdac1c49f, 0x3ff56a5dd608dcc7,
    0x3fd366e0e9322d96, 0xbfd89ba21cfc7760,
    0xbffa636a2f503904, 0xbfcebaa25a8e6f68,
    0xbfe722da2d614ae7, 0x4004a0d956ed2d68,
    0xc00336081c148b45, 0x3ff31a0f1107a884,
    0xbffa6fa6af9d3672, 0xbff68fffde5cc63c,
    0x3febce138bd97499, 0xbfff25c99cee7718,
    0xbff01b4d4b88a35b, 0x3fd75c4f633aadbe,
    0xbffce98795748812, 0xbff82dbb991bdb4a,
    0xc000b36e51a609d4, 0x3ff543c541d50452,
    0xbff0831a5a718770, 0x3ff3a774eea6a5aa,
    0x3fd17d3cfb9476bc, 0x40053dec56bf0f94,
    0x3ff459ede4cb8335, 0xbfd54186141f1ee4,
    0x3fe521386d455868, 0xbff1551e66d70e5a,
    0x3ffae7639295b349, 0x3ff6efc874fc2615,
    0x4000453d29ca98c8, 0xbff90903ad98b741,
    0x3ffc4e9c27e8151c, 0xbfe5b5ea1c17e382,
    0x3ff20146c873c1f6, 0xbff5d5c84db04668,
    0x3fed9c1133384076, 0x3f900d2d78b073e0,
    0x3ff2e6a5ba650194, 0xbff170332e37c102,
    0xbfe27bc568fc3d80, 0xbfb0677f592337c8,
    0xbfb9ca58790b748a, 0x3fdd4980b8c8480c,
    0x3fd4618f07b31139, 0xc00892136f2d6f28,
    0x40040176b560b0d0, 0xbfed8314d7f1cf40,
    0xbfd03c9de1801ef0, 0x3fe207199d0e2b7f,
    0xbff2424f80073add, 0x3ff764e284ab4320,
    0xbfd6f7a6d86244e8, 0x3ff127e6e241e156,
    0x3ffa871140f356bb, 0x3ffb9faa02887eca,
    0x3fc75c50169e890c, 0x400f803188217e47,
    0x3fb2e8dd85355960, 0x400670e98ac571f6,
    0xbfe553d649101986, 0xc0021eb4f21073f7,
    0xbfe0a32f61d05675, 0xbff743f92e10783e,
    0x3ffa7f9df13254e4, 0xbff0b9597cb4b38a,
    0x3fe089dc8711dc58, 0xc0015f40a768db3c,
    0x3fd11714176cf288, 0xc006fc8ef2ced11c,
    0xc0091de01dfa33a4, 0x3ff7bb306b81f15a,
    0x3fe2f34dd8ad3eef, 0xc0866a81da3e8fc8,
    0xbfda0f7f211449c0, 0x3ff2b6160db079e8,
    0xbfed7eaefec038c4, 0x400fd04f56247abf,
    0xbfb7b8740b831450, 0x3fff8c37509bde5e,
    0x4004395e53cdfd1b, 0x3ffb29f43e2c6cb6,
    0x3fec983ba7d7aaaf, 0xbfb7b987dfd98aa0,
    0x3ff5500aa013e5af, 0x3ffd15382d0fc6cd,
    0xbff26da928d552f3, 0xc01525b7fa15ee1c,
    0xbff992d392bc9246, 0x4002c637cb9d43ee,
    0xbff82bb6f5a6d08c, 0xbfe39ceb62749a2f,
    0x3ff00ab019a64a14, 0xbfd2b20471b40587,
    0x3ff77a94900b82e6, 0xbfe5ffc1c28e64d6,
    0xbff7b5e93c060206, 0x3ffb9ce70f9d8cf3,
    0x400b04a1a2a9bf22, 0x40046fb931796ce9,
    0xbfc27a54ce858008, 0xbff9d39f8fa08c6c,
    0x3fb2628bee1ff400, 0x3f8fef05abef7f80,
    0xbfe5d2e840137cbf, 0x3ff3f2363813d668,
    0xc0086015553e5304, 0xbfd75e7638aefbd4,
    0xbfe8507df5fda8f4, 0x3ff6f6e5ba7b8f7e,
    0x3feec1435d1ccedf, 0x3feb058686e255d7,
    0xbfeebaedc23175e9, 0xbfd16edc2d825eb7,
    0x3fe279db8ae62a0c, 0x3fdf45b61d732f7e,
    0x3fe94746953c2862, 0xbfc799ba90366b30,
    0x3fe0616d3ae2abe0, 0x400544a3682959b5,
    0x3fd167a7834a1e06, 0x3ffa527a6ceaa981,
    0xbfd3488ca25ca26e, 0xbfad305fdad36730,
    0x3febae3625fe051c, 0x3ffdb7ef3c4d9c1a,
    0x3fd5f902f57bd736, 0x3fd661f548d0068c,
    0x3fdc25727e75bef6, 0x4009fe3c70745888,
    0xbfda3e3e84f9d096, 0xbffbacc0adf0da28,
    0xbfd0d0582127f8f6, 0xbffed3643db20d8c,
    0x3ff9877c2e83833a, 0x3fb562a1cec25bd8,
    0xbfe068308d187b1c, 0x4009abea22ae26c6,
    0xc001d0ef1a5db66e, 0xc00090ebd7b1122e,
    0xbfd7e16ad53a4a5c, 0xbfebf3fcbc71ffc9,
    0xbfdfad715674f71f, 0x3fef3acfd47659d3,
    0x3ffac2793dc26fff, 0x3ff13b3c8f76425a,
    0xbffff3fe04f0193c, 0xbfdee72f3bc989a8,
    0x3fe9c368274b5af4, 0xc00089b67358a2b8,
    0x3fe9c4f2a8184a2a, 0xbff2cbff34faf96f,
    0x3fffe1e2f222cefb, 0x3ff314d7186baf1f,
    0xbfd19d7fb36d439c, 0xbffd59ee6c5682de,
    0x3f9b06007eb3bf80, 0xbfeae5b5ab5c24a8,
    0x4001ec800ee668b3, 0x3ff207cb3fee4746,
    0x3fe093caacc08681, 0xbfe80fd779fcc583,
    0xbfd6b06c286037c4, 0xc00e24403b10f642,
    0x3ffbbbf7aa4bac4f, 0x4003a6a3f92adcaf,
    0x40064d56197722e5, 0x3fd573b677681a6e,
    0xbff9bedbb9c1d0dd, 0x3fede30030a6c6c4,
    0xbfe9f9aa2de8b439, 0x40000c2881f83cf4,
    0xbff1a1e28740eccd, 0xbfcbd0c5655db7b6,
    0xbff3d811fcb04a4a, 0x3ff36c340fbeba62,
    0x3ff7d561c27d7324, 0xbfd7545721606bcc,
    0xbfd88afcffb26166, 0x3feca29c546e10de,
    0x3fe7080a30cb6b6a, 0x3fe15507a1f9171f,
    0x4000283afcf53f9e, 0x3fec4d80eb673e1a,
    0xc000914e81b11df2, 0xbfeb0d9ddec666be,
    0xc00aa94cb0f4696b, 0xbfa69c1a8b067160,
    0xbfd21fd5b87e71e2, 0xc0013e10380048ee,
    0xbff1b11211b0905b, 0xc0045ad9e2ca796a,
    0xbfe4b8af995ab78b, 0x3fcd4e76fad8f4e8,
    0xbffd7cd63b4c2004, 0x4003860d86ff6f7c,
    0x3ff1b80fefdd4e48, 0xc00257e27bba8e15,
    0xc0025655c7a1e358, 0xbfe1b617bd5377ec,
    0xbff083c0b355f9a2, 0xbfbfc9ea57013ba0,
    0x3fea185e08dd3458, 0xc00545ad137c22c8,
    0xbfee2ed8011ef50b, 0x3fe00a5b8673ce3c,
    0x3fe8816167d5a9a1, 0x3fc9481014acadb0,
    0xc000bb1cdeaa796c, 0xbff803322c43b0b4,
    0x3fcf6a646be35c44, 0xbffbd9991886b1f4,
    0xbffeab04feb2df52, 0x3ffc9d6a721b343e,
    0xbffb08e705ceef9f, 0xbfcf10c2700ee950,
    0x3fdfecda51f42e70, 0xc001fd1038c05056,
    0xbffdf43e4f983649, 0xbffbe129c6a87195,
    0xbff28911550ce194, 0x3fe89dc38c2c56e9,
    0xbffea09149c4f02c, 0x3fb5c58b75a9c950,
    0xbff7b0774032aeda, 0x3ff0434386456e9c,
    0xbff6656846d7c132, 0x3fe60540ca584b34,
    0xbffac5bfa88f1422, 0xbff906d94b24bebe,
    0x3ff892668545914e, 0xbfd09f92a28f14c8,
    0x3fef4ad0e7d6488b, 0x3ffce885a23d86a2,
    0x4002fb75f9ae62a6, 0x3ffd52f3e27f8104,
    0x3fe0ae054466d25b, 0xbffb0443c8986e22,
    0xbff3dfeed443338d, 0xc008361f215e0ab0,
    0x3fd7ff81cbc4c0cc, 0x3ff1c6395527ae3e,
    0x3feb767957afd5e0, 0xbfe4e93a08c9e424,
    0xc005de0197d9264b, 0xbff9eb2d181345ac,
    0xbfcccd5645de57c0, 0xc00558dc51c08a54,
    0x40073e8fcc889040, 0xc003d9ba1e6608ba,
    0xbfd3274a2f72f278, 0xbffb238ce5937ff9,
    0xbfc0c6a47836e3ba, 0x3fe3b4372357f3d3,
    0x3ff9e060a77b3006, 0x3ff83ef32b04b9c6,
    0xbffed7159ba89128, 0xbfe1f4ab5254c806,
    0x3fd5417bd390ef18, 0x3ff1878b7333516a,
    0xbfc0ade45f6d59b9, 0x3fe7338a1f1b6534,
    0x3fec63c9669f0f99, 0x3fe5110b9b9caef7,
    0xc00e2378d764c265, 0x3ff2b1a9661d057f,
    0x3ff97972d9b5f652, 0xbfd34ddf2cd742c8,
    0x3ffd88557e43525d, 0xbfd0e8f193c29b70,
    0xbfe7b0d365ac2a94, 0xbfe8c1ffabafd202,
    0xbffe61460f9cacd0, 0xc00001e14e075c6b,
    0xbfc53cd3f65a47f4, 0x4008eac6ba095787,
    0x3ff73b3ed5a81b1a, 0xbff2c72a4726e542,
    0xbfece043295f9652, 0x3feec7abdf4ca9de,
    0xbff0f430e9fce5d3, 0xc0036821de413026,
    0x3fb1ca5384141c18, 0x3fee96f8a8e2404f,
    0xbfc597029645bc06, 0xbff5415682c73ef2,
    0xbff65e02fab69707, 0x3fc97c83d27efc48,
    0x4005100cced39672, 0xc000929aed146cf8,
    0x4007bf56668f7b0b, 0xbfebce2514e84596,
    0xbfe4077ae1cb4ac1, 0xbfeb05fd596e1b26,
    0xbff7aa74fbb0eab6, 0x3ffd11d8807f057b,
    0x3fffe4acb0cc00a4, 0x3ff87502321fe77d,
    0xc00e6817d0c5af70, 0x3fe85ab0df21022f,
    0x3fd2e850f0a08390, 0x3ff27bdcf2fdb239,
    0xbf81074a90229440, 0xc0013cac9b9aef94,
    0x3fca480d5ff7f0c8, 0x3ffa402a7c520536,
    0x3fe8e2a8543d538e, 0x3fdb38bd775bd4f0,
    0x4002991bf9eeff78, 0x3ff403b3bcd31326,
    0xbfeb2f468fa9046f, 0xbfd1acd60270528c,
    0x3fece9ed0bec0db0, 0xbfd878736351edb8,
    0xbfe95b0b81b9afe4, 0xc006a279323d5f20,
    0xc004975ca662209b, 0xbff02df2e8571c8a,
    0x3ff355e86e4539ba, 0x3ff5aa45e3d8cc29,
    0x3fe04d580b423074, 0x3fec698cea6dfe64,
    0x400bd50f729e53b6, 0xbfd7f7c3a6d22ebc,
    0xc0004c2a86e99ce8, 0x3fd928190f167a33,
    0x3ff2d4a8ee54ae52, 0x3ffaf7003b030a70,
    0x4007b37542b3f34a, 0xbfbcd19e45923550,
    0x3ffacad36ff6fcf6, 0xbffd36db5c6feb15,
    0x4001044b33c5a63c, 0xbfdb15a8b3bc5162,
    0x3fea6a46b6a3ce44, 0x3fda8ab325d3de22,
    0x3ff80f86f91dd7e9, 0xbff02c97215edcc9,
    0x40105d063d16ba5b, 0x3ff0a4be08fb0379,
    0xbfeaf71877737e25, 0xc0003558a4cb8af7,
    0x3feb84b4e76e3dc6, 0x4002e2d1d5fd278e,
    0x3fef878c1e341d62, 0xbfdbfec797e61fa4,
    0xc00084360cdf050b, 0x3fafb69dca4d79a0,
    0xc00c5eb65e8ebf9e, 0xbfe3ee3fe376e95a,
    0xbff66c199c3b7cb8, 0x3fe363f4d545c7ff,
    0x3fe74beddb611e40, 0x3fde54e86989888f,
    0xbfe6e19d8fbc4b9b, 0xbff5a7fc379df15e,
    0x3ff66be9988e922e, 0x3fe7b94e9b8ebd88,
    0x3ff53daa58d37ad7, 0xbff954425b740cd0,
    0xbffb93600343472f, 0x3ff40df009904518,
    0x3fead39c29e953f4, 0xbfeddb4debb5b2cc,
    0x3fd4334f91ce8558, 0xbfe8c24d1ad44bcd,
    0x3fdc22520720d773, 0xbffea91ee96133fa,
    0xc010763370ad3f49, 0xbffcea7b6f8f39c5,
    0x3fe781cd630e05f1, 0x3fe177cac6fd0bee,
    0x3fc050e3f1b86ce0, 0xbfdda5fcc1292634,
    0x40034742650cfb00, 0xbff164d74a0e27c7,
    0x4005bd382400da65, 0xbfc95055cf47b518,
    0xbfe3f74ac4931a19, 0x3fec4d6fb55a23e0,
    0x3fe5cc7c56586e06, 0x3fa2797dbf752be4,
    0xbff46fd1435f7360, 0x3ffbe1a273ed00b2,
    0x40049466ba5af7a2, 0xbff9a7a8a0c29ae6,
    0x3ffd18119dd70564, 0xbff004759c52dfe9,
    0x40005d6822bfa656, 0x3ff67c698b000031,
    0xbfe25b6dd1492a03, 0x3feedef18c60d4a2,
    0xbf7e879a70ef5f00, 0xbfc6251e638ee5f8,
    0x3ff54f6effd3daf8, 0x3febbee0d3eb63dc,
    0x3fc3d8516839657c, 0x400acfabf7c9ee2b,
    0x4001954b287d5048, 0xbffae2044478dd9e,
    0xbffb53c107d2cb1e, 0x3fc46e7c9dc36a00,
    0x3fd13f86e2335f9e, 0xbff6ea6f84b7075a,
    0x3fe1ca541b563192, 0xbff1f8552e1a4828,
    0xc003682ec95ab80a, 0x3ff5faed902aa317,
    0x3ff6eb6fa18fa032, 0x3ff034fbd79aa1ae,
    0x3fb2e79f8b416464, 0x3fc639b56081fcc8,
    0xbfe795a45cd5c862, 0xbff0cb255100cf5d,
    0x3ff4ac400f891582, 0x3feda80adf9a6b70,
    0xc001b508471c8e1c, 0x3fe4211d0aaaf5e1,
    0xbfebefbcb27edef3, 0x3ff060e0589ece56,
    0x3fe4b8ff69709d1a, 0x3fe07d8e36b08b2f,
    0xc00ab3913fdf25c0, 0xbffbbd0ea619fa3b,
    0xbfe26bf9a51014c8, 0x3ffc827dff0f98f6,
    0xc00bac26f9b09372, 0x3feb106b10b48452,
    0xbff01c6452b4ab4a, 0xbff2c69c0d0dc6cc,
    0xbf9947c909219460, 0xbff1d970b74841a6,
    0x3fe153eba0037a83, 0xc00018babeaf3b98,
    0x3fffdc80b060d2ab, 0xbfe711637343f652,
    0xbff731d7d4ebf526, 0xc008174d3cd1c62d,
    0xbfe30fbf9492e45c, 0x3ff722842be93793,
    0xc0092479a5bf508a, 0x3ff235b2a01de254,
    0xbfc9f59253eb64f0, 0x400530b6cf468c3d,
    0x3fe2ddf8e2d11dfa, 0xbfdc0fb22f292564,
    0x400d8aacacf44f50, 0x3ff49bd3e5084068,
    0x40031bea8a3769c2, 0xc003703b46fdb21a,
    0xbfe702054419d1c2, 0x4006b70103b5f102,
    0xc000d3bba2c39d79, 0x3fbef712eb004fc0,
    0x400969a92feb8db2, 0x3ffe3bb6b4097dc0,
    0x3fef0de5f24b97d4, 0xbfa631e6febe2880,
    0xc00233b80b519399, 0xbff7233ce1b218d0,
    0x3f843e90e74a76e8, 0x4000494b01a5adad,
    0xbffb6acfbd93a97f, 0xbfef0f21b87c9426,
    0x3fff8c1f943083c6, 0xbfbd36e8cfeec430,
    0xc0040ecfa6b87e03, 0xbff21d50902a1890,
    0xbffc860a235b144a, 0xc0023a7fd220d4ac,
    0xbfe4783740ea950a, 0x3fd827c076a26f81,
    0x3ffeba1dc5dfc4e9, 0xbfd566a47c584ade,
    0x400331c174cc8b66, 0xbff993ca250fa39a,
    0x4009b3c12f5b99a8, 0xbf9100b0fbc09178,
    0xbfbba431bd627c70, 0x3fdc6febae30ddfa,
    0xbff0aaeac2b628d0, 0x3ff20b2689455108,
    0xbff04f5c2f632574, 0xbffb470e640635af,
    0x3fda61980ae7f8c6, 0x3fdddcc96a67623e,
    0xc001ea20d43ad4a4, 0xbfe28a2b61bfdd3e,
    0xc008a9f8bf846f29, 0x3ff1cf4bfb33e517,
    0x3ff1b67018624798, 0xbffda25c8c063354,
    0x3fdb3e557d0e0200, 0xbfec84090a81f614,
    0xbfc3f72bad7dd9d0, 0xbfe90b3d2a61b512,
    0xbfea78f2f7c71e72, 0xbfd65ddac46b9680,
    0x3fdc43ae2111da4a, 0x3ff0a1c53800d714,
    0x4002a27c133710ed, 0xbff80ebd3e6b52fe,
    0x4002b67562d76356, 0xbfe2a628fa91aabe,
    0xbfd0d0013abd4172, 0xbfd4768545a1d184,
    0xbfda5b9c25662df0, 0xbff4f4cdda60bb12,
    0xbfdace365656365e, 0x3fcc346c039433b9,
    0x3ff113b3b47a9df2, 0xbfd4f0e2217ef3b5,
    0x3fe6fe6a87717818, 0xc002a78954d70131,
    0x4005d9ecae2b7593, 0xc00350db0db29792,
    0x3fc6b2be474b4e58, 0x400a526cce3d4dd8,
    0xbff15c68e26f4a2c, 0xbff21d3aaccb5622,
    0x3fee47663c8c757b, 0xbfc1863b2ef4ec08,
    0x3ff4997069df1430, 0x3ff359dd48ac5c2d,
    0x3ff53dd480f2b8b6, 0x3ff79387025c3453,
    0xbfdba865806f7e36, 0x4003ff2d461de6f0,
    0x3fd1c3b6a2a55744, 0xbfefea48fb1ef774,
    0xbff6ff29db720af9, 0x4007e10b5984df60,
    0x3ff44102d6f5e244, 0x3fecb07db6973c8e,
    0xbff5903b26ed9026, 0x3ffe68f61299feec,
    0xbfd3b2454dda9fd8, 0xc00418253b572dbc,
    0xbff35b60c6f128a3, 0xbfee65f4205c3b8e,
    0xbff8629753565cdc, 0x400dba1fcd91b0da,
    0x40027a8cdf36e022, 0xc00a665067e2d089,
    0xbfb050c5aeb3159c, 0xbfe5dfe408795056,
    0xbfd3eff49d56aee4, 0xbff2cb1b50da5414,
    0xc006c71a415607c3, 0x3ffe9dcf8bbf078d,
    0x4003456e603e67a6, 0x4004ea6b08c3393c,
    0x3f908653202e451c, 0x40103fd68be2329c,
    0x3fb83b1f9461c558, 0xbfd20c716b1ea204,
    0xbff76e5ac9f566d7, 0xbfa6660dd800c2f0,
    0x3febce9b4a9ee229, 0xbff87f7f8e8b9876,
    0xc00f300446165fa6, 0xc0018bb5fff5d0bc,
    0xbff1e2efdcea9b8f, 0xbfd36edc6403d287,
    0x3febb4c0939e4d4d, 0x3ff2a51e6ad0bec9,
    0xbfb7c0ca4b1df712, 0x4006b9e4b9cd78a2,
    0x3ffd9289d5309828, 0xbff9820801e21b44,
    0xbffbb1455a5f200b, 0xbfc80a7e44175610,
    0xbfe5ec7daa6a2c82, 0xc002ca2408ca6f08,
    0x3ff40a5f1b41559b, 0xc0036aa7bb25b501,
    0xbfe5c87d477a817e, 0xbfe8e9a447aaebfb,
    0xbfed1ccc1e269f76, 0x3ffa37605cca6964,
    0xc00c0fe36bcf4516, 0xbff00e917f0518f5,
    0xbfecd2996ff7dbbd, 0x3fe930e3180e2e64,
    0x3fe5932b351a25af, 0x3ff29116872b1140,
    0xbfe29901aa5031cf, 0xc0080bb9567676b7,
    0x3fdcb7d9128a3584, 0xbfeaeb5075715524,
    0xbfec9b5f10868842, 0xc0010480a46eb19c,
    0x4009b42abe7100f4, 0xbfeea3f84ab2e031,
    0xbfeb7c00e50191fa, 0xbfeb755c51779e5c,
    0xbff68c7867971723, 0xbfcec12c25ee65d8,
    0x3fc1c08be6afadd0, 0xbff9220dcc88b1c1,
    0xbfe14e55b0de2504, 0xbfd4e2efb6f8c61a,
    0x3f61be77e420fc40, 0xbfd95ffaed6a3b74,
    0x3fe74199a65ba5c7, 0xc01099b9a3103bce,
    0x3fbc4a1862ab9e30, 0xbfe1a070799f9140,
    0x3fd664f12ae4c260, 0x3ff00498c893ec9c,
    0xbfb78d7ca3c89408, 0xbffad696cc05a764,
    0xbfffc9fce2e347c5, 0x3ff371e91aee53f8,
    0xbff22b9e8d5d2b4a, 0xbff7892e60962ead,
    0x3fba47848004df79, 0x3fe1499416ff8d38,
    0x3fba475918e9ea10, 0xbfeb705b5e08392a,
    0xbfe00fc3553f9cdc, 0x3fe6979c87b4e3c6,
    0x400547d59adaa628, 0xc012b189ed1d5815,
    0x3fe7339d081b9e70, 0xc0027c7f0590ddb4,
    0x3ffd51afe5fa8d28, 0xbffb8d9db76947de,
    0x3fe209c3bcbfcf18, 0xbfff9b1f50c25819,
    0xbfeae02ee8987272, 0xbfd21580eaa6e6cb,
    0x400a97672e2eb0ad, 0x3fd874eeb2ad5ae0,
    0xc0042af62f14e019, 0x3ff80b9c53c3c56c,
    0x40036ea92dec4d5c, 0xbff244fc3abdbd5d,
    0x3fe098b78628efe2, 0x3fe672fcad42cc68,
    0xc0090e765457fc64, 0xbfe4cad989e72858,
    0xbfee211693d3da0b, 0x3ffafb56aa85b428,
    0x3fe3f725b1c380ee, 0xbfe5c3fa8174e282,
    0x4002c0e93203705c, 0x3ffd84b0b4eebbb3,
    0xbfe3ef0327d0c14b, 0xbff2a2f28b7e5415,
    0x3fbc563a2a2c6ed4, 0x4004c4a417737c69,
    0xc0037494b9f10e18, 0xbfd0469de6803334,
    0xbfeac0b8ae3ac2ff, 0x3ff0fa0ec7d32851,
    0x3fffbf4609e2d3e2, 0xbfeaf884a8379553,
    0x3f946546f45092a0, 0x3fdf0a4df98cb451,
    0xbff876e69e547296, 0xbfe188e50b54af62,
    0xbffff3b1d6c396ac, 0xc0107ca9c104636e,
    0x3ffd005fc5bbafac, 0xc008deea67c76488,
    0x4015f1015c246e87, 0xc00037984a59c444,
    0xbf92c33092f8af80, 0xbff2f6af750a5684,
    0x3ff760b41592c858, 0xbffd4e14991df00e,
    0x3fd66eee7e0f4744, 0x400a65aee0b7aa6c,
    0x3ff5720334bf8b44, 0xbfe18c4ec4a6b96e,
    0xbfe2de1bf104b67c, 0x3fdc5f2d0b6fbd13,
    0xbff158f99f477eaa, 0xbfe86048c22d12f4,
    0x400689bef155f653, 0x3fddd3406f9a2794,
    0xbfcc9c98e10cf370, 0xbff308ad86b5b89e,
    0x3fe230f5cda14983, 0xbffb5da6ac7bb3d6,
    0xbfda9e95d0a90a10, 0x3fd5365e6543517c,
    0x3fef4f08b7cc814c, 0xc00ac04901042c34,
    0x400140ae14ae8754, 0xbfd7966ec021d6f6,
    0x3fd81dc1ac8e2200, 0x3fddcaef46ff1e44,
    0xbfe109e82fb81400, 0xbfba87a2172147d8,
    0xbfa37285e1aa7880, 0x3fefcb5180be55c5,
    0x40093a5d07a02246, 0xbfe5e8e7533489ae,
    0xbfd2f562b6394bfa, 0x3ff087dd16594016,
    0x3ff3db27e6a7ed50, 0x40045bf87c333caa,
    0x3feaf4635016a2bc, 0xbff6541953ddbec3,
    0x3ff4f1b1c9ff0e55, 0xbfcc5ccd314dc296,
    0x3fb4516d3ee0e3e3, 0xc0022e1ad928bc1b,
    0xc00419cc4091c843, 0xbfb78661638e04a8,
    0x40013769e9056833, 0xc00575d5f32dacfc,
    0xc00195084e52eb3e, 0x4006e355416fbb46,
    0xbff7ffbe4f39ff3a, 0x40056bcce23502ad,
    0xbff425b332e0dd73, 0x3fbb8c6a7e670b70,
    0x4003101adc66e2c2, 0x3ff5870915d7a354,
    0x3ffa51824549a8cf, 0xbffbcf6e3b3bfce6,
    0x400735ace0592362, 0xc000946bcfceecc2,
    0xbfee0324f25b7090, 0xbfe5609322aa6245,
    0xbfb3bad323d885c0, 0x400917f6d67d880e,
    0x400d8300dba3d6fb, 0xbff077773476aa3f,
    0x3fd53c6156f2006e, 0xbffc621316272d56,
    0xbff583b12f9035e1, 0x3fd2147b97714bd4,
    0x3ff6eeb28666ee78, 0xbffd7d9526b34030,
    0x3ff8b63857ac5f72, 0x4002cd3ae0e26843,
    0xbfeb6e7febdba898, 0xbff47f79649c9f06,
    0xbff9453aefb63f23, 0x3ff063c564048dcf,
    0x3fedb1f298eeaca2, 0xc002da13172e28f1,
    0x3fb75696bcd75770, 0xc0028c76304b7463,
    0x3fd70add9284794b, 0xbff02251e5f69a85,
    0x3fc5c0f169e126c4, 0xbfe80ee05cc53b9d,
    0xc00a046a00d3e960, 0x3fb8bb12a548dbb0,
    0xbff9eb5cafc998a2, 0xbffa13c291bc3cc0,
    0xbfe8c3b70593529c, 0x3ff95ef598918ee3,
    0xbfe66aca3a6a4ba6, 0x3ff54f86671092a1,
    0xbfff74a6595f0aca, 0x3ffb6e49e67263ce,
    0x3ffeb1ecfe4526e8, 0x3ff0da91e4ded70d,
    0xbff42c2447b22b9d, 0xbfe72c5d5b24994f,
    0x3fd240e60cf0d452, 0xc006fd468b1c8e79,
    0xbfefd2f51fdcefcc, 0xbf9a1098668225a4,
    0x3ff8486ac2db1a70, 0xbfd84a2409a3efc6,
    0xbff1ebe1f9b3d2cc, 0x400b974541a6bbd9,
    0xbfdedb86a928a050, 0x4008d2310fe0fac5,
    0xbffa0876dcf86919, 0xbfb06e533c39caa0,
    0x3fd07d5de0c1faba, 0xbff7adb2bbb12f6b,
    0x3ff1599567f98b20, 0xbfe55fcee0e434e2,
    0x3fed3512cb8b9009, 0xbfeb423e58e42a1e,
    0xbfd371da3279a34c, 0xc001afab3eb2c523,
    0xbfda6affda243ec8, 0x3ffb4944a6ec8220,
    0xbfced1989edbe3fa, 0x3fe0c79bb8be3b12,
    0x4004592028f1deb8, 0xbff066ec1487e1ab,
    0x3fc9e22e409910f0, 0x3ff9bc305a76f58f,
    0xbff3d3d8fd1fe2eb, 0xbff5cd24642f7325,
    0xc00ff818bda4c580, 0x400532e31d8a8894,
    0xbfd618df14d1629e, 0x3ff28480ff66d1ad,
    0x3ff931a60c14ca9c, 0xbff05dde76397547,
    0x3fc87748a16d02ea, 0xbfbcde7f94712b58,
    0x3feb0f900dbac1fa, 0x3fec1b3715a6b025,
    0x3fe1266d9e6d40e6, 0x400af83242124905,
    0xbff34112b5a32553, 0x3fe5e2f5a08ca5e9,
    0x3fdc6568bf957498, 0x3fdf336b118926a2,
    0xbfd452493e4e0fca, 0x3fc44b6dda644c86,
    0x4003ccd81514dedd, 0x3fd0693bceadc862,
    0xbff0ef6be5d018b6, 0x3fec1a7bbdc7758c,
    0x3fd8c069a2982b62, 0xbfffcd7b64446978,
    0xbfce37318a9b6a08, 0xbfe1f3db1779b23e,
    0xbfe4c87f658330c0, 0xc00619bc76f55170,
    0xc0033f040ff68b18, 0x3f9b9088b59112c0,
    0x3fcae23a5aa4091a, 0x3f830c0b0df1ae80,
    0xbffe0964ad310856, 0x3fee4002f72469e4,
    0x3ff26b47a36f717d, 0x3ff6ea38c9cc95ed,
    0xbfec4099862265ae, 0x3fd6d2b36b004cf0,
    0xbfeaa4545903af40, 0xbfe83944fa82c725,
    0xbfe2190402c93b37, 0xbfdd7b5afc9690ea,
    0xbff9e0758fd48554, 0xbfdae34a424d54f4,
    0x3fc47394ad07ea60, 0x400c0435b32f1bb6,
    0xc00db5c9264e355b, 0x3ff5ff03b1c1c9e0,
    0xbffc11da64b7f34e, 0x3ff28ee3b7386db7,
    0xbfec33a4be8a61d6, 0xc00ea91bd8800246,
    0xbfc5d23481bdf6da, 0x3febde4e7449bf78,
    0xc00a48ac18b57e51, 0xbfda2d11794e1f27,
    0x3ff280e904dee592, 0x400867307ad598f9,
    0x3ffcd5cdaaca5396, 0xbfd530a3e163d318,
    0xbffa58e4bd771dc4, 0xbfcd5dafc898f76c,
    0xbfe09e06a159b405, 0x3fdd37576a4c2bb0,
    0xbfc0c321e2c327d8, 0x3fe0ee1b725185a7,
    0xbfdd9b87bf3c05f7, 0x3fe19a3b8af2a7e6,
    0xc001804b18a72d30, 0xbff75fa5054fff4e,
    0x3ff9ca5b4fd8889a, 0x3feec87f0053a963,
    0x3ff91c6ef81a75e0, 0xbfff5b952c7074ad,
    0x3fd71943d12d0c90, 0xbfeb98f82adbd8d1,
    0x3ffca8f253aeddb2, 0x3ff0e7190003ac3d,
    0xbfcb269669ddaa54, 0xbff5b9cbd7207485,
    0x3fe06ff3fe1e6bcd, 0x4002e5bb3bd72a7c,
    0xbfe2ab052058c954, 0xbff82fb2c550ce51,
    0xbff8486b4173b048, 0xc000f9dde3943742,
    0xc0042bac79cf361c, 0x400310633356604a,
    0x3feac48d25b23870, 0x3feabc280b237504,
    0xbfe82f28cf1feb45, 0x3ffb35e97dbd8c96,
    0xbfee2291b61bbc52, 0x3ff042cc6dd6fdbc,
    0xc00277ab8a0a1698, 0xbffd839a8caf1221,
    0xbfe26a0b31ab213b, 0x3fffa081d20e1354,
    0x3fe5c3187a63a9c1, 0x3fefaa3dcc524abc,
    0x3fb9caf001db2a98, 0xbffb384581c3796e,
    0x3ff7c06c8a1c9a14, 0x3fe8784b66b0a604,
    0x3ff241e83f31b837, 0xbff1f97f17d347ac,
    0x40020d1f95064a23, 0xbff75dcfdadd0407,
    0x3fb7aaec595fc760, 0xbfd13bba040a87b0,
    0xbfc3c3f73a65e05c, 0xbfdacbbf57d8e1ba,
    0x3fc9a8a4303ca123, 0x3fe873c5682bfa28,
    0x3fb84afb1dc12af2, 0xbfe5dc2cda962836,
    0x3fd7ab34bea5cd0e, 0xbfef3fcb8e21a438,
    0xbff455826a93f66e, 0x3ff18397ea8738ce,
    0x3febfea7cb996b2e, 0xbff7d92de8b77c2a,
    0xc00566d79b5798f1, 0x3ff5bc8b85d3b54b,
    0xbfee9b4bdb8c62af, 0x3fd5aa713d290278,
    0x400ac58802ee1c92, 0xbfd5f2d9982c5db4,
    0xbfe19227e38937a0, 0x3fda2a2671cebd12,
    0x4002aa8ade41028e, 0xbfe31249affbfdf6,
    0x3ff629ff77903bb9, 0xbfedccb5368208af,
    0xbff12eae388ae127, 0xc00d264791484704,
    0x3fd717b13abc9f76, 0x3fff035e77ace966,
    0x4001591736bb22f8, 0x3fc3d43869193bac,
    0x3fe38d7c5cef1223, 0x3fee2b1c40bdf9bc,
    0x3f34b95c0431d800, 0xc002537afaa7fff0,
    0xc003491364edde87, 0x3fea0a6ef2c32a61,
    0x4001eb6954aeee74, 0x3ff1103f19b978b7,
    0x4001291a80e9da3e, 0xc001fab28e3d201d,
    0x3fa34c28d866a1d0, 0xbfe319449d1b225d,
    0xbffe3d452713bffa, 0xbfde6ebf9bd085ae,
    0x3fcb5cb08c06e238, 0xbffe0d20ce1bc5e3,
    0xbff975dc4e1b0398, 0xbfeff6cddc6857ee,
    0x3fefc720198dbe4e, 0x3ff1ae4507cd91d4,
    0xc0076f3fe2378a45, 0xbff246b256a01de6,
    0x3fc094f7a9a4c334, 0xc0068abcd3acb196,
    0xbfd61795dfeca94c, 0x3fe3137ad0e0fa19,
    0x3ff0ef530382fcfc, 0x40100d8a3e60f106,
    0x3fcdf089647d3fbc, 0x3fe9e4ecd738a094,
    0x3fe74715e98a931a, 0x3ff7aae6e2e44494,
    0x3fdacb3fa4ba9922, 0x3fee8dbf72aedc1c,
    0x40044a3048c536c8, 0xc002e3e6263ba1d5,
    0xc004e6ae885a1948, 0xbfd465078ad0929e,
    0xbffdb76d50b1d350, 0xbff31a43bd9dff01,
    0xbfe8ba9f74e27c7f, 0x3fe4582a5f6517f2,
    0x3ff895fdaa4d3a41, 0x3fd50ca382775f94,
    0xbff13095590647bc, 0xbfdbe3be7d795df8,
    0xbfbee48c92f9d2a0, 0x3fffdc3042e2b1fd,
    0x3ff986df01ea2554, 0xbfe621f53f495e46,
    0x3feb43ea47997b82, 0xbff2b564152a6b0b,
    0xbf96df1b1d4c5730, 0x4002dc6dbfe87082,
    0xc0030d800e6852bb, 0xc00a987adb63305a,
    0x3fd3a1357879fe40, 0xc0018b7d3aa1c054,
    0xbfe5a1e879a08d61, 0x3fea86ec8d816d10,
    0xbff6be41ced22b33, 0x3faa6f00dd96b6d2,
    0xbffc430dfdcba618, 0x3fe51b5f5fa6fe69,
    0x3ff9445de36e36cd, 0x3ffd68cfbd0b0cea,
    0xc009e5d378ecf207, 0x3fe75c4437e37cdd,
    0xbffb705818c13e81, 0xc003d63d21db240d,
    0xbfd816ad18cd6c64, 0xbffbd20d7eceac67,
    0xbfce3dd3c674804b, 0x40052dd2c17b6ee7,
    0x3ff8a49d3ada4212, 0xbff44a2459983f50,
    0x3ffaf79057053fbe, 0x3fcf31f35ae8c602,
    0xc0075842faa11100, 0xbfc1c06e9627b3e4,
    0xbfeeb0eda0c7a0ea, 0xbfc0a55aa942ebd8,
    0xc0132742544d0cf9, 0x3ffcce09b4b0a761,
    0xbff97708391a391a, 0x3fccb156628a3590,
    0xbfa648ee0af32cf0, 0xbfb1d912188f5416,
    0x4000bef119dd524a, 0xbff713e398026256,
    0xbfe7450afa1e9d36, 0x3fe20c64ddae0251,
    0xbfb8d989abed50de, 0xbfd3410f36d0294e,
    0x3ff440f23f538238, 0xc006bb7a4b105746,
    0xbff6861a8c40d2c5, 0xc004598055dc32d6,
    0x3ff0e8691a9c153a, 0x3fe68aa51c613daf,
    0x4000ac4c5649ffc9, 0x400be4919e78c426,
    0xbfb2f4597fa3aa90, 0x3fe1aa786f40d261,
    0x3fd178930859c95e, 0x4005a3e574eab180,
    0xbfef0394f9d43df9, 0x3ff4aa42efe87bc5,
    0x4001b31d5ccf4da7, 0x3fed1e48700873ec,
    0x3ffd7cceebe10fca, 0xbffaace70aabad5c,
    0xbffd5d856572d5ea, 0x3fe86319ce86249e,
    0x3ffe11f24f8b2e80, 0xbfcf2217d34d9790,
    0x3fcdb6e3762990f6, 0x3fed4727ec179754,
    0x3ff7703e718aae2c, 0xbfe63a508a502089,
    0xbfe2105785e693db, 0x3ff401bd37fcead0,
    0xbff49720c4737510, 0xbfdc007d15060e3a,
    0xbfd94ec9d1f19c3c, 0xbfc29fbcbff9a320,
    0x3fe5e977bf554b3a, 0x3ff18275990a35fa,
    0x3fe7c1ebf0714085, 0x3fe9f3c91a709b10,
    0x40034f958ebcd66e, 0xbffe7a1dceba6bca,
    0x4005835f8b6dd78e, 0xbff9c8d1cbd3536c,
    0x3ff472f6105d836d, 0xbfe67a869745b061,
    0xc001d2874c681101, 0xbfe1f2545876b38a,
    0x4005e99bedf23ae1, 0xbfdc7e84c2ca3a28,
    0xbfe61b48a60c19b8, 0x3fd24012e56ed30b,
    0x3fbf133b92c40138, 0x3ff78c6ae4886a4a,
    0x3fe85083e03bbd64, 0xbffe237d11118cf4,
    0x3ff896e36a8b00d7, 0xbffeed66188434b0,
    0x3ffd1b5ce23cb031, 0x400744cb9ee30e42,
    0xbfd8635472ded202, 0xbfeeaaee7b0385f8,
    0x3ff60e8d33047dde, 0xbfc29906bb1fa1d0,
    0x3fd2923f2e99a17e, 0x3fd1844fbaf33476,
    0xbfd1751089ec0fb8, 0x3fecfb7e99d89504,
    0x3ff6d66a706013c0, 0xbfe8fe28de01b719,
    0x3fcb2fd4f96733bc, 0xbfe0a6ab74b75000,
    0x3fe5c96890311550, 0x3fdc464982cee30a,
    0xbffe9934c65c9796, 0x3ff6a2f31a8d2f35,
    0xbfffc37270892a54, 0x3fe57fcb1cadb37f,
    0xc007b5366b0582be, 0xbfb68f7c42efbee0,
    0x3ff3f7950fca3750, 0x3ff0784bbe9fbd2c,
    0xbfdb900fe6ed0f05, 0x3feb3c3d920c7fd0,
    0x40002f7c6846b07b, 0xc001732bd61f28ea,
    0x3ffc75b14ae1c130, 0xbfbd30ecc1815b20,
    0x3fea2569afdc4042, 0xbfefb74bbda3f939,
    0xbff8eb5275077d7a, 0xbff1229b8515c616,
    0x3fcad47b7fc857c8, 0xbfe30398e2d854e7,
    0xc008bb3b19cd00c6, 0x3fc98eca8d9ce65c,
    0xbfbf4dad2298cac0, 0xbfed5ed6f54eb6b4,
    0xbfed48887e01e666, 0x3fea11a8bbefd060,
    0xbfccae18873624e3, 0x3fcf237090cdbfd0,
    0xbffa57241bd8ed3c, 0x3ffb461b952f6a40,
    0x3ff0571187a85138, 0xbff8a9b238b610c6,
    0x3feb76776602f1b8, 0x3ff0519bfaf92074,
    0x3ff95254e51b80ee, 0xbfeba12f3dc812d0,
    0x3fe602e8a634c670, 0xbff2341bb995e11a,
    0xc003e4a121d13f9e, 0xbffc542fea9fa44f,
    0x4004899959826284, 0x3feeb47af9851dba,
    0x400f077e31ffdda4, 0x3feb173dc368185d,
    0x3ffa4736e9bb7f9b, 0xbff7b86218ca0f53,
    0x3feee388dc2eced4, 0x3ff75516f0403ac4,
    0x3fddd20491ea6180, 0x400b15c6a4d2416b,
    0xbff302bd88de0af9, 0xbfd5fee30fff6d7f,
    0x3fd55deb86d36efe, 0xbf80b1f3c0912000,
    0x3fe0ae16dfc2a448, 0x3ff59c610ce1f446,
    0x4001e7b20bfffbd6, 0x3fdfb7ccb8012648,
    0xbff4a525d6a5bf86, 0xbfe634bf3ed4d8a9,
    0xbfc733f81f4e9ad0, 0xbff5b31fdf5046be,
    0x4003d24b1fac2b03, 0xbff647099fe9645a,
    0x3fbc8a6f11e24538, 0x4009eff3d9768026,
    0xbff8651bd0fb57e0, 0x3ff710bdff38e3e5,
    0x3fefe5fc4b015ef6, 0xbfd51c942e0fc7f4,
    0xc0076785ec64ae95, 0xbfe0c4ddc397ab1a,
    0x3ffc4121021b2f63, 0x3fec40eff609afb9,
    0x3fd64b720bae40d0, 0xc0007a7c4bc13e91,
    0xbff10e9d5c11d6cc, 0x3feabc01812364bc,
    0xbfdb9646f334f790, 0xbfccc49e125015e5,
    0xbfd575d713b9a8ac, 0xbfe99ee240c7d202,
    0x3fd1ef6ec07a3df4, 0xbffae40cf2c1cf9d,
    0xbffa6337f04d26de, 0x3ff0e056ff752ad2,
    0xc00975825dd1a51d, 0x400a13b42273162c,
    0xbfe4e2fa57204faa, 0x3fc088066b873d1c,
    0xc01668d28b6e2336, 0x400626fbf967b3b5,
    0x3ff9a54e20777e94, 0xbfef93a0f4221c98,
    0xbfeb9fb91bfc5a14, 0x3fea90d20fee7ed6,
    0x400b860a3d7f28af, 0x40017051fe1f8eac,
    0xbffdf291317c8178, 0x3ff802658530fde2,
    0x3fff9a54c2b69504, 0x3fe828993fc3c22b,
    0x3ffd6961418f69da, 0x3ff09c44574675b4,
    0x3ffd074b32528648, 0xc0002dfce1d1eddf,
    0x3fa2cbaa0f32c310, 0xbfba78a2d261b9c0,
    0x3fd6d3e972091e98, 0xc004197594f3c203,
    0xbfe14061c2d5c230, 0x3ff8a178e7e2b7a6,
    0xc008565faa0ef876, 0x3ff214b40c374ca5,
    0x40082dfce71558b3, 0x3fe88c190b19e04e,
    0x401071a1462c7ef6, 0xc019f545f7e746a0,
    0x3ffdc6bca8cfd8ef, 0xbffaa271e1334aec,
    0x3fb8e0b74585ee8c, 0xbfeb72c8f8689eb3,
    0xbf9208ab9bfeeec0, 0xbff08ec100fc72ce,
    0x3fd408b351aba24e, 0xbfd99643a12aa429,
    0x40012f4a51ee7cfc, 0xbfe8a4cfdac3f75e,
    0x3fff9f4b02d585d6, 0x3fdfb7cab251112e,
    0x3fff6e15da275330, 0x3fe61f938a27ba45,
    0xbff199afcfee6897, 0xc00f248326d85284,
    0x400c0537fa417fdf, 0x3ffcdba372a2e3b7,
    0xc0109847b188c028, 0x400688a8b684f860,
    0x3ff3cde9c67f31ee, 0xbfdede36bc4473f8,
    0xbfd19255d6e8ad54, 0x40016442986ee450,
    0xc004ab214073c53e, 0xbffea7ba983398a4,
    0xbfeea6c983c65ee6, 0x3feee592533b0f76,
    0x3ff102add34cb2dd, 0x3ff512211d90bff6,
    0xc0033c757f991fe4, 0x3ff84a3f3e77c0fa,
    0xbf95ae94357edfe2, 0x3fe6be181fa907f6,
    0x3fc2558222abe2e8, 0x3fe11d4efd8e93d2,
    0x3fea66e4f9d6bd4c, 0xbfecf281787d637a,
    0x3fd3631d9da50176, 0x3ff8df575d749304,
    0x3ff8df54259d78c8, 0x4009fb2e1d059ea6,
    0x3fef6d47422bab4b, 0xbfee17ae05ead467,
    0xbfdcd50c72d60622, 0x3feb7e8e86ddb2ae,
    0xbfd47625e5c59fb0, 0xbfcebf68e764d810,
    0x4003a4ee7d235d46, 0xbfec26b940a0dc27,
    0x40042c3d67348d75, 0xbfe47fb8f390078c,
    0xbff2dc164a9563ca, 0x3fee54d36e6a9d0a,
    0xbfd2e6284e0d607e, 0xbff6d0dc7c0664e3,
    0x3fc0a08dcec70fc4, 0x40026a2e6304b4f5,
    0x3feabb6b34cc638e, 0xbff08ebbb695a9fa,
    0x3fef7e9ac4577912, 0x40067badd2648fce,
    0x3ffce8c553d4aea6, 0xbff98fe8b08ab071,
    0xbfc3779a2dec0830, 0x3fcfc0895c7d5342,
    0xbfde924804bd6ae8, 0xbfd3f3cf40f2f2b2,
    0xbfe0e581c78130f0, 0xbff77e152db9ccfd,
    0x3f8c036b89408a00, 0xc0046c6718ff8ca0,
    0x3fea4afc95c24ade, 0x3fddc87cff6bed0a,
    0xbff427cb7dd4f608, 0xc00180eaf251ffd9,
    0x3fe5ed77ab6cf3c5, 0x3fe2c3f68baa8fab,
    0xbff183916fc2aa6e, 0x3ffb7eae343e32c7,
    0xbfe92e1d0d65e5de, 0xbff91c835f8daba2,
    0x3fd579b22b889688, 0x3fc2c68ca5d70914,
    0xbfeb644e3732e24a, 0x4001fc3b59cfaa54,
    0xc009405cd4d2c008, 0x3fe7c8a6ce0a1701,
    0x3ffc2c601339f9a0, 0xbfe82f487a321539,
    0x3fe5d9191858cbda, 0xbffb1c0dbabf6690,
    0x4000b6824022888e, 0x3ff75f35c9e55ea4,
    0x3fcc8ba6f25b9ef4, 0x3fe2f461e6f6af21,
    0xbfdb70544573a31c, 0xbfdf1ac5e8e40be2,
    0xbfe18dbe9e732b9a, 0xbff348f6097054c5,
    0xbff172025ee3d342, 0x3feef9836a58ade4,
    0x3fe483fd3805ab39, 0x3fe5ad7ee538eeb9,
    0xbfe3812e0569601a, 0x3fd2ffdcbf2a2c4c,
    0x3fcf386b91d5f680, 0x3fe58b08a687a7e2,
    0x3fc76f315c9d4bec, 0xbff50da452ea8e9e,
    0xbfed35c8979a2df3, 0xbfe7167c528f1142,
    0x3fdd3c8165c7db04, 0xbff84897d004cca6,
    0x3ff5e45c956e4f8c, 0x3fe85f7e36bec922,
    0x3ff9c2150935f570, 0x3fdae2d31b3daf1e,
    0xbfe988bd0bea4198, 0x3ffc26f87b0b807b,
    0xbff88105dbc5dfa2, 0xc0078365b190723a,
    0xc0077c2a72e74474, 0x4002fb9676ff2183,
    0x3fd7dd2659fe454b, 0xbfe9a62d17d48634,
    0x3ff4d3ce88150182, 0xbfeac8f8019dc7a8,
    0x3ff38e8efeabec57, 0x3fb24e337db3b3ac,
    0x3fde10403089676c, 0x4000d448699226b4,
    0xbff990fd387f8ace, 0xbfee6b2646094b8d,
    0xbff86dfddb3784d0, 0x400277d4476aa86d,
    0x3fed5875cc787114, 0x3fcf57cb09b136b6,
    0x3ff0cd49da7ee84b, 0x3fd33a85cc238e92,
    0x3fff52e90c4bb759, 0xc00d14449ceb480a,
    0xc002be4bb7acffac, 0xbff62dfef42a283c,
    0x3fdaa83f495c274c, 0x40055ba1c2b9bf53,
    0x3fa458e9d4d81780, 0x40014e5b16e5b306,
    0x3ffb595992022678, 0xbff089ed81ef87e3,
    0x3fcbf4be4669fc80, 0xc001bf7e9172c9a9,
    0xbfe7286f1fbb5530, 0x3ffadddbc97dce24,
    0x3ffa5fabd1a2efc0, 0x3fd728b659985bb6,
    0x3ff9f84b739eae08, 0x3ff9322affd82058,
    0x4001215081952a85, 0xbfe1568030c4cfd0,
    0x4005f7badbb5ea87, 0x4013a4a1281a5edd,
    0xbff2662d01479b35, 0xc0010d9e1ce4ac13,
    0xbff5334eb16eefa5, 0xc0095144cb79cf35,
    0xbff0779fd0efb26e, 0xbffd1254b3a89c82,
    0x3f9f3e19099346e0, 0xc002ac49a4f7c0c6,
    0x400c8fb659f1a5fc, 0x3fcc78925c9f0504,
    0xbff962b937a508ef, 0xc0075d23d4466c8c,
    0xc006d076bf0dfea3, 0xbffd9c127d707c98,
    0x3fdf85eb56738ffa, 0xbfb3391d7a5111b4,
    0xbff2f2bc5bd51324, 0x3fe95e87d445bb20,
    0x3fe34a808864cc29, 0xbfe5633a19ce1dae,
    0xc00c31d421c2ce02, 0x3fd652ac03dc3383,
    0x400548528ac801fc, 0x4009fa69db55fbb4,
    0xc004f8ed4a8dbe18, 0xc0101f173756c038,
    0x3ff498e62aa410f3, 0x3fe93b1a1e09118c,
    0xbff04b272cb923be, 0x3ff19442745be07d,
    0x40031eba9592f581, 0xbff5f29d544320ca,
    0x3fd6957c7a3348f0, 0xc001750f200cd1d4,
    0x3ff93081c08a2636, 0xbf96440d93096bc0,
    0xbffd1ca26237d360, 0xbff42e2dd329dad6,
    0xbfffc066548cc7ef, 0xbfed01ce8b994aa4,
    0x3fe36f6dc3c4d181, 0xbfd06cd597a94a38,
    0xc0087ed5a4ae2e1f, 0x400ba9786498456c,
    0xc00658c544440b6e, 0x3fb7bcc805b19e20,
    0xbfd3723e764ea908, 0x400416a2856738f9,
    0x3fc1045887d617ca, 0x3ff0c897c93c7e56,
    0xbfca189afdf355a0, 0xbff4f66f28391b7c,
    0xbfd77274b683651c, 0x3fe360d59e08ad2a,
    0xbfb4284e9e769cc0, 0xbfeb3e54306bf03c,
    0x3ffbd65a05ef6c08, 0x3ff283c5770bca74,
    0x3fc95b803c068020, 0x3ff56c6d77a0f69d,
    0x40038a278355a676, 0x40073e728f745e3e,
    0x3fe54f1239b87b88, 0xbfea66e020c38d50,
    0xbfc6223180e230a6, 0xc0055739ab293276,
    0xbfd8cddd96e74ff6, 0x3fc9f753b373e310,
    0xbfe632ec8015a194, 0x3fad10b62d234888,
    0x4004ab91e4b21838, 0xbf91f02449f0c660,
    0x3fe44cf2531d8f81, 0xbfb626a4976a82a4,
    0xbfe5de85495ccef4, 0x3fed187381698d81,
    0x3fe9e235c1c42abc, 0xbfdfe0ac30f66c18,
    0xbfcbb79e5332216c, 0xbfd34efdcf120728,
    0xbfd69ddff7bfadfa, 0x3ffa090dbb22cff7,
    0xbfed4bd5564fc36b, 0xbff1035f6d0c8735,
    0x3ff06dd96f8d56e5, 0x4002bc0bf868d68c,
    0xbfcd602daf300609, 0x400f63a1892768a8,
    0x3ff6cc0f1c7070df, 0xbfd5f6d25a00eab2,
    0x3ff327902e1c9e1c, 0xbfcd7578cab11422,
    0xbff148e7f2e93be7, 0xbff66381087aa98f,
    0x3ff51210519e914b, 0x3fcb551eb95a6cfa,
    0x3f51a80d8ba53300, 0x3ffcd189e097ca1b,
    0x3fe3f09c45a067a8, 0x3fc39ebb205ebfaa,
    0x3fd47fefe336e4fc, 0xc00c461264f5c1c8,
    0x3ff44b7477bebc8f, 0x3fec3d161dd67d3e,
    0xbfea940df693e097, 0x4005a757bbfa181e,
    0xbfdd05aeea0275f6, 0xbfa44785ae649ae8,
    0x3fd1da0115a48098, 0xbffac3d972181b46,
    0x400b2177ae870c06, 0xbfdfe1a000f86850,
    0x3fece15d4f402613, 0x3fe0964239a90e81,
    0x3fc6e686666368a0, 0xbffec7be2f889fb1,
    0xbfd90e7f577345e4, 0xc0030afbc345e364,
    0x3fd97c04e4d84224, 0x4001277065567b32,
    0xc0013d77bc3db1ea, 0x3ffb3d5f3387ec34,
    0xbfd94cd571f1f3e8, 0x3fdeff24ec5a655a,
    0xbff9099d2d441b22, 0xbffa0dad2df68604,
    0x3fe6e31ce2bacb8f, 0xbff0c6194a5dee98,
    0x3fdaeb6960c209f8, 0xbfcf12df424d79e0,
    0x3fea4d039c364e89, 0xbfe745ac696182a4,
    0x400fd41bb984d82b, 0x40015884ea5692f8,
    0x3ff9d448c9236a54, 0x3febd6a88d75f542,
    0xbffb3b626d23700e, 0xbfd22b601bee3718,
    0x3ff092f1e1110a64, 0xc00683a461436471,
    0xc0022c56bb76281c, 0xc003f9f5980a3ad2,
    0x400146aeadc53077, 0x3f66206736cce400,
    0x40078efe9930e0d8, 0xbff5971fceefe628,
    0x3fe853a5b55dd56f, 0xbff63ce9433b9d8e,
    0xbfed47695c45c4e4, 0x3ff7aab6ef87a86c,
    0x3fd6581da294ee3f, 0xc00a3c99f6c9e0e8,
    0x3fe15f4c721ced3e, 0xbffe733d8638a9dc,
    0x3fe28fd627ccabcb, 0x3fee29fc325e5959,
    0xbfd4fbc6a65bcaf6, 0x3ff1b32f0ffca982,
    0x3fdea08d13cb13d8, 0xbff9eae155889fba,
    0xbff80a29d315fc49, 0x3feaaaf8202571bc,
    0x3fe5c6e6251c9f34, 0x400167be216e9f4f,
    0xbfeaa6870d333e7e, 0xbfb9577788de7020,
    0xbffc4ee13f0974d6, 0x3fdc146dc31165e9,
    0xbfc18f7f243f4166, 0x3fd290ac2a5c4eb6,
    0xbfe8ce50652b8f8a, 0x3ff15bb908b64f06,
    0xbfb0f3129f5777b8, 0x4006e263929c4b50,
    0x3ffa435f11ef3082, 0x3fe88aaba049a53b,
    0x3fba3d6ca5a046a0, 0x3fde9ddee450ad10,
    0x3ffd22db99d76e20, 0x3fdfcf76385dee11,
    0x3fe14a2c51dec5df, 0x3ffc05c5fbcb4d34,
    0x3ffeca006ea4df36, 0x3fe9e8f01654caca,
    0xbfbae7fe07618ba0, 0x3fc4b7b86303dd72,
    0x400456221cbc19bd, 0xc000ffb58f12f51c,
    0x3ffbd1a82755a6db, 0xbff659ca448e8822,
    0x3ffb524ce8b24dd4, 0x3fdd518f619a4250,
    0x3fe88d6af48cbd71, 0xbfe80e63c9ad50bc,
    0xbfdb0769b099edc8, 0x400240313d255c4a,
    0xc00cfd1c585a7518, 0xbff125dba22fca73,
    0xc00d9e288a78be22, 0x3fefc17eeb07cbf5,
    0x3ffecc23914c9d06, 0xbfea0a85e3175072,
    0xc007d02a4deee317, 0xbff7ebb96cb66636,
    0xbfa43f7a53d75e80, 0xbfe2fae52b72c096,
    0x3fff7c797563a096, 0x3fe2d6567c0ba4c8,
    0x4011fdf1e8e93181, 0xc007a65db7e76369,
    0xbfe9e0561d6d2aa0, 0xc000ce435a644ec4,
    0xc005bb63070d3531, 0x3fe47715db811d22,
    0xbffd4eef1851a3ae, 0xbff19a7093f70b86,
    0xbfeb30ceca472f60, 0x3ffee5d519a20166,
    0x4001445f67d092f6, 0x3fe1e23bbd8d01ed,
    0xbfdb1ecdabef61d8, 0xc001329f88c0f9c4,
    0xbff16a9c70410e85, 0xbf8c2d8516d4cfa0,
    0xbffcb923343b8324, 0x3fee1c13cf4e47bc,
    0x400121c56e39e9dd, 0xbfd9005bc1ab2ce8,
    0x0
    };

static const uint64_t in_rfft_noisy_4096[4096] = {
    0x3fb3235eefec727b, 0x3fde770b6d69a86b,
    0x3fe6bef61983a484, 0x3fe125e160576455,
    0xbf9cb7ca5b76dc36, 0xbfd9d6745672e132,
    0xbfe6b2db5b3fb489, 0xbfde4599e8fafb41,
    0xbf837a86990d6b62, 0x3fdc12893b961eff,
    0x3fe3e6196d9278fe, 0x3fe17d708e861f79,
    0xbf708d3a9ddcca43, 0xbfde1a2368220f26,
    0xbfe616cd5d5bd55f, 0xbfe067ec328a0233,
    0xbf88835f6a76fd15, 0x3fe08a8f5a561d66,
    0x3fe8af9f926b1f86, 0x3fdabec7b4ebcfe9,
    0x3fa6fd7f2c94796a, 0xbfe3e5ff32f6c8a0,
    0xbfe554e419713e5c, 0xbfe16223eab92838,
    0x3f91f67b7710ae9a, 0x3fe2b32b8efb2cd6,
    0x3fe681c4ff96fa27, 0x3fdf1c8aad9eb8c7,
    0x3fb4fb00ebd9d715, 0xbfe1c03eca3af99c,
    0xbfe6e31142c72f8b, 0xbfe03e4d1d8cafc6,
    0xbf8a68af3002fd2b, 0x3fde7d295c88ff59,
    0x3fe6c79cdc80a046, 0x3fdb16bf308cc816,
    0xbf97b01424a74fc5, 0xbfe194c37b34e29b,
    0xbfe6f17fb868d76d, 0xbfe07d70dcb141ed,
    0x3fb4f817a1b8cdbd, 0x3fe11acdfc04ac05,
    0x3fe5b765a41a67b1, 0x3fdc9066edd53742,
    0x3f85f857818e3394, 0xbfe008aa971eb91d,
    0xbfe64cc4eded774c, 0xbfe1b9cef9eb18c9,
    0x3f9d45f8a5839433, 0x3fe147c415c551ef,
    0x3fe589cfe7345b26, 0x3fe33add576b925c,
    0x3fb72f9b39d61065, 0xbfde04718e7408b4,
    0xbfe64ccebd7028fd, 0xbfe12d39cbd3aa9e,
    0x3f81aaea6a49dd8a, 0x3fdc88a4ff3235bb,
    0x3fe602b667bd38ed, 0x3fe179abbb7d0fa2,
    0xbfaa2cee7aba9d37, 0xbfe1178008ecf738,
    0xbfe4a9636a02dfc9, 0xbfe001c489413d67,
    0xbfb80b9a2f93e4ca, 0x3fdca87f6d0260c0,
    0x3fe6a1a41efddfd6, 0x3fe0591cf44c3315,
    0x3fa6f2d341642595, 0xbfe02fe07cb9e40b,
    0xbfe6c0b9feba1760, 0xbfddba7b3d4f3572,
    0xbfb9c8b2389013be, 0x3fe21097544e8e83,
    0x3fe8076df37b77d3, 0x3fdd48300040a143,
    0xbfaba5b34e14230e, 0xbfd6c3d2380e6730,
    0xbfe6e63f210299bf, 0xbfdfad6fe0e5d4c6,
    0xbfb79e001503ffae, 0x3fda255d3b7c04c4,
    0x3fe8a8952fbcaa71, 0x3fdec42a3089e75a,
    0x3faffb24b83eb172, 0xbfdf316ad7c344f2,
    0xbfe6147084eb7d29, 0xbfe25ea47af18e7b,
    0xbf737b5074206bca, 0x3fd8e11dab978b54,
    0x3fe6950f45920a39, 0x3fdd302ef30bca1e,
    0xbfb0037f3d70e32f, 0xbfe2763fd590ed8a,
    0xbfe8f32c54383231, 0xbfdade37c0c80213,
    0xbf9d0b4fae66add9, 0x3fe0381966099d3d,
    0x3fe6d0c163159723, 0x3fe0658d76021dc4,
    0x3f97ebf0247e1317, 0xbfdf9cad741cb1bd,
    0xbfe41ba96823d357, 0xbfdf90f87cded80d,
    0xbf91b635f3a34850, 0x3fe149b20ccf4130,
    0x3fe479a08eac5902, 0x3fe04127b13c4af9,
    0xbfa43e8a60ca98ca, 0xbfde2a12dd267cb1,
    0xbfe37f6b4fc03c89, 0xbfde82b2e698b6b2,
    0xbfb66df20a29f01e, 0x3fe269d4f3a06088,
    0x3fea914db32b3292, 0x3fe01d935dc62ad6,
    0x3f989815579c8450, 0xbfde81aaff6d87a3,
    0xbfe84f48a75bce5d, 0xbfdf977b869149a7,
    0x3f773168709cfded, 0x3fdfe095dc9e31dd,
    0x3fe61657c73988aa, 0x3fe1b407e74dd210,
    0x3f7dc17dbbbb5118, 0xbfe08fccfca708f8,
    0xbfe68af5da80c508, 0xbfded517a2227467,
    0x3fc089ba7ca39680, 0x3fe1ccace343fd86,
    0x3fe47641acfbb7cc, 0x3fdd659a4395e2fc,
    0xbfbc770446da8319, 0xbfe22a9c20326da7,
    0xbfe7cf129c56e2d4, 0xbfdd697bf2b027a2,
    0x3f941cb98de4ca73, 0x3fe065ffdeed9dad,
    0x3fe333519fe26330, 0x3fdfb1d09654c99b,
    0xbf9ebe70e7af4022, 0xbfe11ec50b693c20,
    0xbfea1543799fe48b, 0xbfd7855e16e9fe22,
    0xbfa6c028bfa1589c, 0x3fded6e2d5352825,
    0x3fe60381481a8606, 0x3fdc9321a2c5855e,
    0x3f94a12a9042b159, 0xbfdd9da183b74bac,
    0xbfe56eed6857cb28, 0xbfe14c56a0b77f11,
    0x3fae004e1e375942, 0x3fdf98bf4b350b80,
    0x3fe7976c9ce8b5ec, 0x3fe2477e2611c041,
    0xbf4fdcb4f0f0d3b1, 0xbfe0e8399074a0ed,
    0xbfe5fa53736deb2e, 0xbfe018f8f57969c0,
    0xbf89a11a7ea6fb35, 0x3fe1aa4f7ba14af6,
    0x3fe4f894b900666b, 0x3fe054b652eaf0fe,
    0xbf8983036acabb6e, 0xbfdff5c11d045044,
    0xbfe5add08349c344, 0xbfdf187d9bac731d,
    0xbf6ae36e2c42e619, 0x3fde5efa1a739892,
    0x3fe80a081d9c48ab, 0x3fddd3968487ff31,
    0xbfb52aa4b4b82549, 0xbfe0e4ddff1651d2,
    0xbfe75c32e793dd10, 0xbfddd2f11475c6a1,
    0x3f8c392615199bc0, 0x3fe156e751f48bad,
    0x3fe72fb622ccea10, 0x3fdff27613794298,
    0x3f9735fa1678afdc, 0xbfde970d00269dda,
    0xbfe6e67638dc5bce, 0xbfe1b00e7a77f230,
    0xbfb3437e86ad3559, 0x3fdb92856b6aa4ec,
    0x3fe5639a8e8c8d56, 0x3fd89f72a2d7f555,
    0xbf9da680a749a192, 0xbfe027a456a38556,
    0xbfea0c7910fee11e, 0xbfde328960ea07d9,
    0xbf84f9624c07dba0, 0x3fdeac611227493b,
    0x3fe5fcd89bb1fb53, 0x3fe040ab3cfb9cd6,
    0x3f820591b7f33125, 0xbfde8a94b131fe0b,
    0xbfe953385b937f77, 0xbfdefbb4416e4a6b,
    0xbf8059796bbd4353, 0x3fdf77fc515e6755,
    0x3fe93dc6e84e68cc, 0x3fe2b54800e0a2d2,
    0xbf74c9b5118e6ee2, 0xbfdce1970727e3a4,
    0xbfe4c4f61648b8a0, 0xbfdfd996503b6b2b,
    0x3fa782eb635fa1d6, 0x3fdfc0031f547f90,
    0x3fe69604fa29760a, 0x3fe0f502d7764663,
    0x3fb4b0b15a174240, 0xbfe17ddd24a2f5df,
    0xbfe4599978904cc9, 0xbfddc50941d614dd,
    0xbfa6270b9e169dfb, 0x3fdb5b190c4d73d4,
    0x3fe699b213a270b1, 0x3fe042eae3d4645e,
    0x3f8ecc7f52d3926d, 0xbfd95717722dc512,
    0xbfe7022844989b57, 0xbfe0be1a2a731a77,
    0x3fa297cdcc4ace8e, 0x3fe02db0e8860b47,
    0x3fe5109648ac146c, 0x3fe0039363e3fa57,
    0x3f68b00100f704ee, 0xbfe11b24f7fac794,
    0xbfe65689efa5039b, 0xbfdd8d4ab9fc0c3d,
    0x3fb4f0f35fd3865f, 0x3fe26f8f607e8529,
    0x3fe6425eaaa7bd88, 0x3fe0aed4f286ceac,
    0xbfb2113c1a96d927, 0xbfdde64fb136fc8a,
    0xbfe60e0b536c2d39, 0xbfdd07f5dfb1c49b,
    0x3fb5f34979db3496, 0x3fe163318a4f63a2,
    0x3fe82585149f08f1, 0x3fe2b9898e7b4f70,
    0x3fa738dccffc1003, 0xbfe214f02f025506,
    0xbfe787ef114c2f02, 0xbfdfe58f81a0d239,
    0xbf8f01c5223b9a30, 0x3fd9c876e448de1a,
    0x3fe7b407937a87bb, 0x3fe090733ad4e02f,
    0xbface273f688333d, 0xbfe2e2dd6cfdb37e,
    0xbfe4f69ef887be53, 0xbfdfd3bb619fa714,
    0xbfb2ea3ad4aad2ca, 0x3fdef018422c2d0b,
    0x3fe5e6c147440968, 0x3fe2b7fe938d5403,
    0xbf888b52b525df97, 0xbfdc5bc40078398c,
    0xbfe3c5f6f4b7142f, 0xbfdad8f4c435d7dc,
    0xbf964103e53d52c2, 0x3fe358b5c7aa8a0f,
    0x3fe8b3d7ca9a8422, 0x3fe1573b4b9b1ef4,
    0xbfa351a186cc79a3, 0xbfdc260c185909e2,
    0xbfe5c8e54333dc10, 0xbfe0b610169c2054,
    0xbfb08fa83fe3237f, 0x3fdf7d77cb564390,
    0x3fe516a3d8cc6d22, 0x3fe1068b1cf8af63,
    0x3fa31de2b53e5e01, 0xbfe0dd87e52a23bf,
    0xbfe9d239faba2de3, 0xbfe28eab0f67bde8,
    0x3fadeb1183ab1d7c, 0x3fe30088e8a1d628,
    0x3fe601eae3557624, 0x3fe0663bf59c4489,
    0xbf8097bb85ed4a19, 0xbfdf4e8414409ce9,
    0xbfe68b94867389ab, 0xbfe3141f658fe6c9,
    0x3fa3e648b5ba23b3, 0x3fe07b6dd3bfa79b,
    0x3fe8601145581ab4, 0x3fd9badcc612cfe6,
    0xbfb088bcfc8bbec5, 0xbfe02e9a5037227b,
    0xbfe4e12f94dc194a, 0xbfe0d21949c6b98c,
    0xbf8c6e97717efbe0, 0x3fdea520ef119bcf,
    0x3fe449fd578c56e9, 0x3fddf4bbfeb8d714,
    0xbfab98ea68bd7003, 0xbfe0151f8ff5fee8,
    0xbfe8b3bd6c3493cf, 0xbfe1e55f21ec975d,
    0xbf9ae1cec49a7688, 0x3fe21ba220df9cfc,
    0x3fe427bc8d58ae65, 0x3fe122b48c86d8d1,
    0xbfa0b29c7b15e7e7, 0xbfded6399b3f1411,
    0xbfe636782b7ea397, 0xbfdeb26d5a907bcf,
    0x3f9c5ba948b38667, 0x3fe18e525886773d,
    0x3fe4a8b173a1d807, 0x3fe22c575ecc1c33,
    0xbf8f9469fec59624, 0xbfe1118979f166c7,
    0xbfe55442c4cc2e64, 0xbfe06b35ff66a7df,
    0x3fa49605a25426bf, 0x3fdfcbb812002ef2,
    0x3fe51b11ef8aec26, 0x3fe020ecf8c9a5aa,
    0xbfc09c46050fdac8, 0xbfe0a159a9b26673,
    0xbfe7e9654526d96e, 0xbfdf1f369cd1bb51,
    0x3faa35db373d8c1d, 0x3fe073d4bd1dbca7,
    0x3fe59436b14c9d06, 0x3fe0b63ead51c3d3,
    0x3f7932b2aa152567, 0xbfe26213f2296756,
    0xbfe78286530bacc2, 0xbfdd86f318c048f8,
    0x3f6f03c06b24787c, 0x3fe24d1dafd33e8e,
    0x3fe817a89d7c91fc, 0x3fe03dbfa42a54d0,
    0xbfb3585c15dd1746, 0xbfdd45df4da41faf,
    0xbfe6b18ef9b8f368, 0xbfe158ddb0e543fd,
    0x3f7a9072f92beb43, 0x3fdcad356ecc9fbb,
    0x3fe53720617eff9a, 0x3fded55342b718be,
    0xbfa571cb20743104, 0xbfe2726201266366,
    0xbfe6f83f4a4e4053, 0xbfddeb3b11c55d5e,
    0x3f9686d60ad82979, 0x3fe07ad0a154da3b,
    0x3fe715ff300a4c63, 0x3fe017d4226ff078,
    0xbfa47b885dadc9f8, 0xbfdb3a9363380afe,
    0xbfe4c94f8b30ea66, 0xbfdf6d4e9d9d67a4,
    0x3fa7a89982272394, 0x3fdbd6173ad88cf3,
    0x3fe4b5d69d5e5c6a, 0x3fdf984f376297a8,
    0x3f88d1641bd80a93, 0xbfe08a35f5f8677f,
    0xbfe8820e945a2611, 0xbfe0de51ef092dde,
    0xbfb26bbb8caed260, 0x3fde20d3be578b8d,
    0x3fe71d5c6966ef19, 0x3fddd983fc9335a0,
    0x3fb157ffe2084390, 0xbfe15a278eeb83eb,
    0xbfe7535bdd9d5f61, 0xbfe167f3fc031b1a,
    0x3faa0d688a04288f, 0x3fe1d1e5183a01f7,
    0x3fe51b13c6c1b431, 0x3fd99728877d48f1,
    0x3f8faf4af8e34d24, 0xbfe3df16c7307e4b,
    0xbfe47be5b7101754, 0xbfdadea683689088,
    0xbfa0d7d7cec813ed, 0x3fe0acdc2078aa54,
    0x3fe63a819f63191b, 0x3fe0a73ee4030efb,
    0xbfb0b7366e4ccefe, 0xbfddbb308f2a25af,
    0xbfe62132d8e82c2c, 0xbfe0540452fa4780,
    0x3fb6b3e02664b28d, 0x3fdce855785e3573,
    0x3fe4a7e3f00a72b6, 0x3fe1a956b2f4317b,
    0x3fa6ea8a76465109, 0xbfe0c81ea13c9897,
    0xbfe5b59011bd1e37, 0xbfe046f992610c26,
    0xbfa51729aa8bf98a, 0x3fddc413f531f202,
    0x3fe569ac328dd2b8, 0x3fe096aa4ebf00c5,
    0xbfa922ecd706864e, 0xbfdc8407c92a7858,
    0xbfe554ba7eb03d71, 0xbfdcc43b645ab182,
    0x3f9e7bb97dce0978, 0x3fdcf690fd93c057,
    0x3fe82582820a7cb5, 0x3fe2bb1d3b69e030,
    0x3fad3c8ac8b2f412, 0xbfdf36af93ca1c86,
    0xbfe5320fee6d3593, 0xbfe0f5ca1b6a961f,
    0x3fa80666f1970d22, 0x3fe132cc1c1193a0,
    0x3fe5e97443bc19f5, 0x3fe0082f90c2e86e,
    0xbf9f72d57943d620, 0xbfe104ee5972d401,
    0xbfe48223691b349c, 0xbfdf5d65c559af3b,
    0x3fbee7e75b58e445, 0x3fdccb7538c633b3,
    0x3fe690862e83890c, 0x3fd93594ca950590,
    0xbf931539523d3764, 0xbfe1bb3af5cf03cc,
    0xbfe6840a1d3037c7, 0xbfd807eca1207e1f,
    0x3faa5c881460ef4c, 0x3fdfad88064c4f39,
    0x3fe6e5c4bf6259d7, 0x3fe04fc0b82ba07f,
    0x3f9b6bfe927fe48b, 0xbfdd6b7c305b813a,
    0xbfe41509c295b9f8, 0xbfdb8512654c2a8a,
    0xbfa96a9fd346f2ea, 0x3fe289d6c20e2426,
    0x3fe4a167fb92ac1d, 0x3fe09043ffe308bd,
    0xbf899c14880d9a53, 0xbfe158e0defd67b6,
    0xbfe2d1dc93e40363, 0xbfdfb924a53c6239,
    0x3fb4dbf568f07cdb, 0x3fe017e42c782e7a,
    0x3fe80376b7e39fb5, 0x3fe1d47b114ace0d,
    0xbf581f7bfe1d378c, 0xbfe0d7936d540f08,
    0xbfe68b1cd80ec1d0, 0xbfde8364a881e1e0,
    0x3f76d8df124e31ae, 0x3fd81c2851dd5027,
    0x3fe90068fb81601f, 0x3fe0c831a02d0dca,
    0xbfadb0548150f0e0, 0xbfe154a7e4e6c8a7,
    0xbfe831f052bc8343, 0xbfda3dbba8105142,
    0x3fa14acdfea39a2f, 0x3fe0e7df13ce0d64,
    0x3fe410d91380da05, 0x3fe1a004d2e04530,
    0xbfb3ae04306ba367, 0xbfe17fc53711bc34,
    0xbfe60afcc95513d8, 0xbfe09e72642ae069,
    0xbf9940c2a2fc12e5, 0x3fdc99d126746091,
    0x3fe59af45648d96c, 0x3fdf46fe8401469a,
    0xbeb9aa8772e58d23, 0xbfe13b508d3569f6,
    0xbfe7293f92e75232, 0xbfe05a93ed845e68,
    0x3f92e659e6853429, 0x3fe1244bf1f57c38,
    0x3fe5b32851e50545, 0x3fe0d70e47e9c190,
    0x3fa2f9abf063157a, 0xbfdf2bb9f06c3098,
    0xbfe73cf0975fccd2, 0xbfe141018e807ae4,
    0xbf841597ff9ca532, 0x3fdf44ce1aa972d3,
    0x3fe71198707e7b54, 0x3fe042be3539a00a,
    0x3fa14b66c3298ce8, 0xbfdb2b7f427a7932,
    0xbfe892138a5371ea, 0xbfe18e4f112c74f8,
    0x3f80581e0b0cabb1, 0x3fe1c1b941f86499,
    0x3fe7589b619acd59, 0x3fdcf89f2f0e40d5,
    0x3fb36c2de98d5b7b, 0xbfddc45ebed3a10f,
    0xbfe468d6a1ade21d, 0xbfdeff058bf2b54c,
    0xbfb38d6b1d53a92b, 0x3fde2409b7015e01,
    0x3fe635b00d863708, 0x3fda8fc6e36053d0,
    0xbfb805f6fe194401, 0xbfe2b23f71196899,
    0xbfe43bab8bfd599f, 0xbfdd7152f7023a0e,
    0x3f8ea87f0993a3c7, 0x3fe0901683942c5d,
    0x3fe642fc55b27dc6, 0x3fde9dbdfe80d77b,
    0x3f7779d0ca5ea8d6, 0xbfded76aa35e83fa,
    0xbfe42b2b264d7762, 0xbfe0b4282c0dcc06,
    0xbfb86731f6c38da8, 0x3fdf0bc014035cb8,
    0x3fe85b6a8079dfbc, 0x3fde16e3a859b069,
    0x3f985bc00889d5d6, 0xbfdd411c3dd6866b,
    0xbfe7c793db2aac54, 0xbfe0516f9931141a,
    0x3f85143292c72f07, 0x3fe14ff3da696e17,
    0x3fe750736dbb4b3a, 0x3fe1184752a9f9df,
    0xbf8204818e427940, 0xbfdd8d3fe69e3baa,
    0xbfe56e05d3bc57d2, 0xbfe1151c7743782b,
    0x3f74a8ef9aaed10b, 0x3fe2009f1da24669,
    0x3fe9000f867cf083, 0x3fdcc959d3673b7b,
    0x3fb19cb31b4d33a4, 0xbfe1c30ae8780734,
    0xbfe62e3abf568e4c, 0xbfdbf93e794c9628,
    0x3fb2444f890bd717, 0x3fdce6f6f9038aa7,
    0x3fe5f1e63497cba5, 0x3fe1912ebb2f259a,
    0x3f910cdc926e2b4d, 0xbfe07a4eb52afd74,
    0xbfe6a0aff5bab068, 0xbfe09a0b469936d6,
    0x3f9155df36990d67, 0x3fe2d1a8bf670a5f,
    0x3fe60151898d4489, 0x3fe01542dfbb736f,
    0x3fb47e209e49fbaa, 0xbfdb0bf20d9af571,
    0xbfe5578017a6379f, 0xbfde146945ff2ea3,
    0xbf9c11f1b03f6d9e, 0x3fda2fdd73a2e5fb,
    0x3fe676bb90350438, 0x3fe0239a8fc4ab4b,
    0x3fa84555529575c9, 0xbfe045fdc307d96d,
    0xbfe9e7453fb50e7e, 0xbfd883cda0ab939a,
    0xbfa6eddca917689e, 0x3fdc7834bb0694b5,
    0x3fe736a4ffdc1a9b, 0x3fe0be02db375ce4,
    0xbf93fac028bbaadd, 0xbfe1ed924306b89e,
    0xbfe749067c0dcad4, 0xbfdb898e49fc1b38,
    0x3f793f1bbad0241f, 0x3fe27d4994c7f89c,
    0x3fe713db0a24844f, 0x3fe2767368a48741,
    0xbf9768525921eac9, 0xbfdeb3348bae0c31,
    0xbfe5df547ec19c42, 0xbfdb16dd8e9a824d,
    0xbfaa2d0e69ebe6dc, 0x3fe15116b7cdf61e,
    0x3fe779cd48df5752, 0x3fe2cfae8274f353,
    0xbfb2d2aa9175713d, 0xbfe1f45869d26828,
    0xbfe38177721cddae, 0xbfe057cfb25dbaa6,
    0x3f7d2174628578de, 0x3fde11037d77742e,
    0x3fe4e347d660e287, 0x3fe196464169e1da,
    0x3fb4d017a0d01cc1, 0xbfe081444aee9e9e,
    0xbfe5dd987b64f8f0, 0xbfdd45bd93aff0fc,
    0xbf998d8dd03c250b, 0x3fdd00acdeb6b327,
    0x3fe3c785512c5d65, 0x3fe18734d130d7e4,
    0x3f89eafcf2329cb8, 0xbfde0eb7dc417446,
    0xbfe7fca093702270, 0xbfde0aca0e9ec2e0,
    0xbf876e065474ffd8, 0x3fe17306b78dc1e3,
    0x3fe490c19c228734, 0x3fdaaab86668539c,
    0x3fac4b9678e25af6, 0xbfddf23501169aa9,
    0xbfe4911491f131d5, 0xbfdc7334831d323f,
    0xbf999659e10a4184, 0x3fdef230a2dc2f31,
    0x3fe59680e826d440, 0x3fe06ffe43172343,
    0x3f9876cdccf7c558, 0xbfde30c25d46fd8a,
    0xbfe6b238a805f438, 0xbfe21753e3a71872,
    0xbfb3d6e561e9d8f8, 0x3fd95b8ecb03b347,
    0x3fe6ab9205159585, 0x3fded2f2d16aae7b,
    0x3f9ec4c3cd544228, 0xbfe07ea225072ec4,
    0xbfe3b13b0cf2bd95, 0xbfdc252d614f2fa4,
    0x3fa88600085812c5, 0x3fe230178cf19789,
    0x3fe54644f331ad21, 0x3fdf6604be6b5259,
    0x3faca77ca4ca7035, 0xbfe21eed6ab97f8e,
    0xbfe480bf59535783, 0xbfdfd85d53bc4136,
    0x3f9a55632ec5c51e, 0x3fdeb2d8a568669d,
    0x3fe6fd073fcb6d50, 0x3fddaeafac09fe8c,
    0x3f97ba696618f363, 0xbfdd7e0fe049b611,
    0xbfe7c1520fa41226, 0xbfe0b97f7f8e26dd,
    0xbf51422122bfb5fc, 0x3fe0e06cac73cef0,
    0x3fe6369e248ed7b4, 0x3fe33401de7e20cb,
    0x3f9975dab589b1f8, 0xbfdf98671ba37c4b,
    0xbfe4687abdb6b966, 0xbfe01ad76de27126,
    0xbfb06c12757f9736, 0x3fdde6f18a6e712a,
    0x3fe39aff8fbe4162, 0x3fdedd85fbc484d9,
    0x3facc0d674971375, 0xbfdb8e3b9769055d,
    0xbfe58cbac0ce285b, 0xbfddf90e23664aa5,
    0xbfa2fd9b62b7f6fb, 0x3fdec2356784c9d5,
    0x3fe5a478a3b32b00, 0x3fe0dc2c1fafb5b9,
    0x3f98471007f0998a, 0xbfdc521e6a6f6e64,
    0xbfe6b5bdd0214f4d, 0xbfe0661db46b4ee5,
    0xbf828c66eab6b5c1, 0x3fe312b79bef6b48,
    0x3fe61a1a5c307172, 0x3fe1841d81d92262,
    0x3fa296fb480df0a3, 0xbfe0e27218d8070c,
    0xbfe632e17446aa87, 0xbfe0de4af1315751,
    0xbfa1f30bab5e17f6, 0x3fdef736095639df,
    0x3fe502b75dc3242e, 0x3fe026fbfef51db5,
    0x3f21c24d4be4aded, 0xbfde9755c799c69e,
    0xbfe4cd9732afc6cc, 0xbfe066d386e3affc,
    0xbf92bdcc6efa73c1, 0x3fdd915cbb91c39d,
    0x3fe5580ec9a99bd1, 0x3fe1552ab6afd394,
    0x3f949e03d6fa342a, 0xbfdc2a8994c950f5,
    0xbfe646c5060b21d4, 0xbfe0ca38ff1e1cdf,
    0xbfa79af1dc058014, 0x3fe291d36ad536c0,
    0x3fe8852fe1adfdd7, 0x3fe1472ea43c6448,
    0x3fa5e2a2c49f520c, 0xbfde0cb37920a5f2,
    0xbfe4e555531930dd, 0xbfe13a68813cea33,
    0x3f836b95585121e7, 0x3fdebead703aab43,
    0x3fe672c06d13a6bf, 0x3fdeb7fa13f89d5e,
    0x3fac64fc9fab6b67, 0xbfe26da3b22062b1,
    0xbfe3033ecd1b6e90, 0xbfdd34f4941e6265,
    0xbfb6e7e978c8e413, 0x3fe0c2a94abaf659,
    0x3fea40c5afe1bf80, 0x3fdd0d2d1a6bfb3f,
    0xbf97802d5d84ddc8, 0xbfe11324d49d8398,
    0xbfe74d6821d06cf6, 0xbfe05ae6b6ead2b3,
    0xbfa6702ac65af9aa, 0x3fe1431e3208f094,
    0x3fe7fc53d321fd0e, 0x3fdfec8316c8fd83,
    0x3fa52e3865924c2f, 0xbfe00e3739bca1b5,
    0xbfe4ff246148b2d6, 0xbfdbd5f7e225fc8b,
    0x3f928e995855fc16, 0x3fdfdf593009cdb3,
    0x3fe656ad469efa45, 0x3fe10fd92fe8fa07,
    0x3fb1b80134d88b1b, 0xbfdf0ab4d7bff1f3,
    0xbfe6551aba1957a8, 0xbfe11439c5c79a96,
    0xbfc030a39d8f2824, 0x3fdec9a11d903ae4,
    0x3fe65e119909dbe9, 0x3fdcd623dd94c018,
    0xbf8c86048357c8a0, 0xbfdd2826d8cd5c54,
    0xbfe6c25fa2ebdf05, 0xbfe08e79a74f4b03,
    0xbfbd99c235f4671f, 0x3fe057ca156665d4,
    0x3fe736ed80c4717b, 0x3fe109d76e0794ef,
    0x3fa6b49798d4d47e, 0xbfe14336083eb5a2,
    0xbfe40193ebd5aa33, 0xbfdc115cfbe0bfce,
    0xbfb191313c56cef3, 0x3fe21306b992689e,
    0x3fe6104e7ace0644, 0x3fe086ceedae0962,
    0xbf9aa01a746429b2, 0xbfde5ea7754c1693,
    0xbfe730f868bb7a6d, 0xbfe1e20f0d4e90da,
    0xbfc060e5f31c5c1a, 0x3fdfe3e874b8187b,
    0x3fe4c951be9f02a1, 0x3fde4b4c3527b028,
    0xbf8e25c6a9d195c6, 0xbfe20cb530fec2ca,
    0xbfe718998a199257, 0xbfe23be34aee3962,
    0x3fa67dc11291b665, 0x3fdf3aab5546a009,
    0x3fe834f385372936, 0x3fdd4a6c1f532295,
    0x3fabca1a6f1b6d3e, 0xbfdd832a0fa8778c,
    0xbfe65a5cdd8a8802, 0xbfdbf16850c54311,
    0x3fbf92dda5d326e3, 0x3fdd23fa6ca8b9d8,
    0x3fe846a1f65c7980, 0x3fe0980a6db5c2a8,
    0xbfae8bdc0fa8a0bd, 0xbfdf62a738e99165,
    0xbfe56443ec1ec56c, 0xbfe03f43cbac338e,
    0x3fb3cff7d4626171, 0x3fe16e1bc98e3c77,
    0x3fe5468377e343c6, 0x3fdf6691af0d32b3,
    0xbf9c1ad27f64bfbe, 0xbfe2b3a974c212b2,
    0xbfe62801246ee916, 0xbfe13bac1f9621bd,
    0xbf86771a0cee2da5, 0x3fe090a439a1dea9,
    0x3fe62d64da089fc4, 0x3fdb42e61f05b2d2,
    0xbfb1c4b7a2c06017, 0xbfe2fcf8f59e860a,
    0xbfe5d86eff302429, 0xbfde480dab20869e,
    0xbfb74f5a7c132d3d, 0x3fe27443c276c9bd,
    0x3fe694a2c82fcc63, 0x3fe162e953e3358a,
    0xbf89f3bc9f60f0e2, 0xbfdc7bac4c4000d7,
    0xbfe5543d2b95f4dd, 0xbfd9848fb8347844,
    0x3f84677aba89d74d, 0x3fde5d21b8d7791e,
    0x3fe6a80faf07d2cd, 0x3fdcad70dfcbb156,
    0x3f75c4d740bd97e8, 0xbfdd53e6c5a4c75d,
    0xbfe6e04bddbc9b10, 0xbfe09f077a3058c0,
    0x3fbaf14497d26707, 0x3fe0045bb85357f4,
    0x3fe69e5141380c47, 0x3fde7f1b6994a387,
    0xbfb30d0555024ec7, 0xbfe140cbac8e1d64,
    0xbfe766af84c12350, 0xbfda60e598a14bd4,
    0xbfa477f502464581, 0x3fe1032e2fe4c984,
    0x3fe6890d537ede00, 0x3fdbb4fa8a0584c9,
    0x3fa33a2310df1f40, 0xbfe17363300e33cf,
    0xbfe8ae3624c3d48a, 0xbfde5c2ee2525bc9,
    0x3f7f342eead1d432, 0x3fde521b32ccd460,
    0x3fe753255a9f63ed, 0x3fdf24d7556d90fc,
    0x3fa56baa04e043bb, 0xbfe14670b3899348,
    0xbfe5ec7d968e289b, 0xbfda4adb132db710,
    0x3fb15da160408463, 0x3fe19fa06f374308,
    0x3fe4d083ccea2cff, 0x3fdf3ab7b83fd413,
    0x3fa0897af43fd69d, 0xbfe331c35636d12c,
    0xbfe8f90ad7b4724f, 0xbfde996481f5a32a,
    0x3f80e7a3abeb1fb2, 0x3fe0a9920bbf1680,
    0x3fe7ac73c149619d, 0x3fdd1e6ca210abb3,
    0x3f79b8fe2c709086, 0xbfdf1a46a9216bfe,
    0xbfe5b49112b64ca3, 0xbfdcffa6715da744,
    0x3fa4017a5df1ef83, 0x3fdc2d648339116a,
    0x3fe6489469280928, 0x3fe1b84b5d2be73e,
    0xbf9c5f945ad6f550, 0xbfdd671d0dd3141c,
    0xbfe3765c54d7b8d9, 0xbfdbc4203ef05286,
    0x3fa17aa8ee73f6c3, 0x3fdcb57a0dfa40e2,
    0x3fe48b6891781819, 0x3fddaf9a2e294c9b,
    0xbf9cd36feaf96cfb, 0xbfe1f3fc0073b613,
    0xbfe6e4b546e3c097, 0xbfe3d5bd21b5b502,
    0x3fc41b8625ff1f67, 0x3fe28352e663fdd8,
    0x3fe8d8b3863285bb, 0x3fddea46f710f41b,
    0x3f92703c0d41ccd9, 0xbfdaeb1f5b1a2d61,
    0xbfe6e92bf8c03a13, 0xbfe1673eb484700a,
    0xbfa68b599aa2dca0, 0x3fe1351ea10b1947,
    0x3fe760273f6c4e45, 0x3fe07be22773e9da,
    0x3f89b004f2a0f382, 0xbfe105af55a8d703,
    0xbfe6ad3325eef4a2, 0xbfde57d8892a8336,
    0x3f8e64679180c8f4, 0x3fe10134e90ee6c8,
    0x3fe260cc641dcff7, 0x3fe16120c95d3979,
    0x3fb05cda3415f397, 0xbfe1a3eeb0348f97,
    0xbfe7dc4b9c6a9254, 0xbfe26b1f6785bcc0,
    0xbfab4f2d1efe7acc, 0x3fd98311ad4631e3,
    0x3fe69159238743f4, 0x3fdfacb313382c5c,
    0x3f95107277317a62, 0xbfe275d2b18b7b66,
    0xbfe63ef8a5497574, 0xbfdd717b9914e954,
    0xbfb0d4005264a56b, 0x3fdf79b68203e6fc,
    0x3fe56cb71faacf89, 0x3fe05f7c74e9fa1d,
    0xbf610432f45c87b2, 0xbfe05a013c4a9fc3,
    0xbfe4c64a562aafb6, 0xbfe0696c08a0e3c0,
    0xbf98a78a30365361, 0x3fe057b15c881fb3,
    0x3fe4c2270a3a72ab, 0x3fdc02672348ac16,
    0xbfa9f70261ba080a, 0xbfdd8fac5e511841,
    0xbfe5a46f672cc9aa, 0xbfe20d39e223c8cf,
    0x3fa3eb33af1e3d8d, 0x3fdfc0916bb00be3,
    0x3fe4fc737913e590, 0x3fe1c24421180cfe,
    0x3f4b657874287adf, 0xbfe057cc09b6e738,
    0xbfe935db1e069dc0, 0xbfdefdd6d5cc9fca,
    0xbf9d4eca671a79c2, 0x3fdbe909c7e3de5e,
    0x3fe400aa3401521c, 0x3fdf9040de22094c,
    0x3f8c749c676e9652, 0xbfdd3b25a4444111,
    0xbfe66d4f398cdc0e, 0xbfe1b81e0e0e4c34,
    0xbfb6f3869bf4db0c, 0x3fdf18f5c20ecf13,
    0x3fe512d287949dbd, 0x3fdf18758b98287f,
    0xbf9ce761215c77a1, 0xbfdc13cb2ca248ac,
    0xbfe6c406aae0b0d7, 0xbfdb63b23bb39410,
    0xbf91fcb7a62f7e62, 0x3fdf5425ff00b9b9,
    0x3fe82c81d1dd86fb, 0x3fdbaf5b2c8fed4f,
    0x3f8bc770c24df73b, 0xbfdc16d624b3fc65,
    0xbfe559e8bb3a19f6, 0xbfe00c9092276993,
    0xbf9883c39a0bf1c5, 0x3fe261f9e6a3c5eb,
    0x3fe5a4bc45f0f438, 0x3fe22f977e2a7c7a,
    0x3fb3d34a8d5312e0, 0xbfddc197f1c83afd,
    0xbfe66fe30b124ce8, 0xbfdf8ce4d6dfff8d,
    0x3f874e124fc00c92, 0x3fdf8315a729656f,
    0x3fe56f1bab251ec0, 0x3fddfc17653f0794,
    0x3f9d679b09b6725e, 0xbfe01708a077b7de,
    0xbfe6ea32bf7cfbcb, 0xbfe0f92195cf020c,
    0x3fa27f0bbfb4e561, 0x3fdf1f381011d56e,
    0x3fe5f002d7656c8b, 0x3fe1acfce321668f,
    0xbf9b794f8929941d, 0xbfdf81f00de85220,
    0xbfe3d529697669f9, 0xbfdf658df603e750,
    0xbf80b61782ea5a69, 0x3fe05b7d4b3d5040,
    0x3fe8350a5d9d309b, 0x3fe02d7f315e877e,
    0xbf553b8215898ccc, 0xbfde183f7bef7f97,
    0xbfe1e78aaeba5a7e, 0xbfddfe0283fb5728,
    0x3f945d061322cd3b, 0x3fdf5faaf2aad1b6,
    0x3fe85edc26b1c835, 0x3fe0c4eb5e3b8a94,
    0xbf7f1dde4a310eae, 0xbfe011442818a74d,
    0xbfe86be6fe7749ae, 0xbfdd4efda80eec9a,
    0xbf7bd38de1b6bc1b, 0x3fe151491ddb5262,
    0x3fe6d9af1d33e077, 0x3fe1126fd697b8b4,
    0xbfac21501f9bfca2, 0xbfd902652c6112f7,
    0xbfe5dc4be2d7c94d, 0xbfe18a34381ef635,
    0x3f7cbf5b5c1ff811, 0x3fdb2d65bf325328,
    0x3fe5a18b99a47877, 0x3fe198878d86cb55,
    0xbf9bb0754428dd0e, 0xbfdbaece56b1b71e,
    0xbfe2d4073bb58dc3, 0xbfdf3f14b136e67e,
    0xbf6ccd002aac2e3c, 0x3fde87a7613b0a1e,
    0x3fe5472e8bdf0edb, 0x3fdfd6759d010411,
    0x3fb5ca6d0c289c06, 0xbfe25f76b96a8885,
    0xbfe5411d005ab7a1, 0xbfe1711fdf74de46,
    0xbfae11f447eae4ce, 0x3fe51aba2ef63017,
    0x3fe38967a5a93898, 0x3fdf7a149bc2a72f,
    0x3fb0dd49dfd0ba25, 0xbfde2bed02896f42,
    0xbfe4613ebc090425, 0xbfde22515b4e627a,
    0x3f98a1109468d15e, 0x3fe0cf76c4bff1af,
    0x3fe2f08cd3eb5375, 0x3fe26a4a3bdbafe6,
    0xbfa8a01de8e96052, 0xbfe1740b7d19595f,
    0xbfe908f046006fa6, 0xbfe072dacd2b1c6e,
    0xbf943f34bb71b067, 0x3fdf1c9be4ecb742,
    0x3fe81bd2452d8b67, 0x3fdd69058696e60b,
    0xbfa9266fe77f0f6e, 0xbfe1a171bd6ffd10,
    0xbfe6065542bbbcf2, 0xbfe000dc0db49d47,
    0x3fae4046a881d03c, 0x3fdca419e7c50d78,
    0x3fe71769ef9d6f2a, 0x3fe37ee4a4b5c260,
    0x3fa1ceee52346fd5, 0xbfdeffd8d0c4efcc,
    0xbfe3a3869cf76e4f, 0xbfe118bda6597f56,
    0x3fb203afe9b4000d, 0x3fe2cf921610b2f5,
    0x3fe882b5d668af97, 0x3fe18563934f8f64,
    0x3f9409a43c2108e6, 0xbfdd1a55bd110624,
    0xbfe5a519e6880d68, 0xbfe08de9e47746d6,
    0x3fab9ce165aa4440, 0x3fe16e0da6e0558e,
    0x3fe7f310f69ff4ab, 0x3fe0961e74de7c0b,
    0xbf61e3deca6f8416, 0xbfe290e5ceb59f51,
    0xbfe4f52ad16327ee, 0xbfe01415448954ed,
    0xbf5240028c017f93, 0x3fe09d80e77007c6,
    0x3fe62afa014f0841, 0x3fe14f2ab63b2da9,
    0xbfacb11f3f78a533, 0xbfe1be131aa2ce9c,
    0xbfe64fea0393ffd6, 0xbfdf462cd478074f,
    0xbfac4f61a6d537ce, 0x3fdf37081aaf7e84,
    0x3fe78affaace4c13, 0x3fe059dc355e4326,
    0xbf94d61b23e7f5c6, 0xbfdffbed3c2af714,
    0xbfe47e2d4bc20fe0, 0xbfe1d98dbee5f171,
    0x3f74d80700e58433, 0x3fe182a7794bc060,
    0x3fe435b160bab3e8, 0x3fdfc50f8b0c682a,
    0x3facaea438fdcc8f, 0xbfdf32f729ec1ade,
    0xbfe7329e09beb02a, 0xbfdb31841cd492e8,
    0x3fb5b5401f3948b8, 0x3fe0fcc7095bf51a,
    0x3fe583fa987f7133, 0x3fde37c1c0877f9a,
    0xbf97f754e3777b04, 0xbfe0217123a0085b,
    0xbfe5af2e451c669f, 0xbfe0bc03edfa8f1e,
    0xbf8290723becdf50, 0x3fddeeac40aa5a54,
    0x3fe5fe0d2d009a5b, 0x3fde4da17f28870d,
    0xbf9acb28f4a9fca6, 0xbfdbafa04b0de79c,
    0xbfe81df46f35e3a2, 0xbfdd8e6c884e20cf,
    0xbf9eeed7356c9adc, 0x3fdfa5e1ff88052c,
    0x3fe6d5ee8c822a02, 0x3fe0677a6341356b,
    0x3fa66357b2c98a93, 0xbfe0afd23df58125,
    0xbfe6da0e297ac9af, 0xbfdfcce090fa7087,
    0xbf4d9387a9e9db22, 0x3fe1085e587d0ac5,
    0x3fe4823e2afe95cc, 0x3fdcafa9dea99494,
    0xbf9b6dafb37e0d3e, 0xbfe135c363e7387e,
    0xbfe481c19c50aa26, 0xbfdecc4393847411,
    0xbf83b4dd5fabf0b7, 0x3fded34a41ef65ca,
    0x3fe8b354c65b3fbe, 0x3fde3f236378b7cb,
    0x3f98f4b1a40e91a0, 0xbfdf3fbac92a079b,
    0xbfe7c3f351a409ac, 0xbfdd9a3862090c40,
    0xbfb2d0780ef2b260, 0x3fe15ad2fff71ba2,
    0x3fe6fe4315e1079d, 0x3fe197a7456c047f,
    0x3f5cb58b7f987999, 0xbfdf10617fdf8451,
    0xbfe53dd4ec07c9d4, 0xbfe190c58f37defd,
    0x3fb7c61f5ca08a79, 0x3fdebdd125030a06,
    0x3fe676083c369f3c, 0x3fe07dab747f3523,
    0x3f9b571f69194449, 0xbfdf117714ec59fd,
    0xbfe466646f7010c2, 0xbfdfeb568473ce0b,
    0x3fa4fae1a54ae0c4, 0x3fddbdfb718069ae,
    0x3fe585cd544e4eae, 0x3fe0ab7bca2cdb70,
    0x3f944c44109789f9, 0xbfe0db83e4608211,
    0xbfe7bd54bbe98e06, 0xbfdfa0977e733000,
    0x3f9809385bb47bcc, 0x3fdc07fcd83797b6,
    0x3fe5f95622f39de2, 0x3fdd200c8dd257ca,
    0x3fbc83e5ea1f7310, 0xbfdc7fa9b009bf62,
    0xbfe623f2ff2fdf76, 0xbfd87c2e5d3c6632,
    0x3f986788e9d43e56, 0x3fe04e29eb2d5fe1,
    0x3fe2441c1cbf3f97, 0x3fe11c51a41fe326,
    0xbfb2535e12a3b8d1, 0xbfe018781ee56895,
    0xbfe65af5a0e5d0bf, 0xbfe1ece1d6276bcb,
    0x3f803394cae0782f, 0x3fe2cd7039c7e782,
    0x3fe81f4e93b9c1c7, 0x3fdaa6ebaf9c2526,
    0xbfab6ad489c5cd66, 0xbfdfc2802c6726f0,
    0xbfe7a51605665aa0, 0xbfda3bbf2517df5e,
    0x3f759c824e11cb8f, 0x3fe1e408a20bdee2,
    0x3fe7aedafd9bf857, 0x3fe0154b56cd0001,
    0x3fbb554af239803a, 0xbfdd3ec3b58a6390,
    0xbfe73a6bb81b00c0, 0xbfdd6bf8294c052c,
    0x3fa7c6a7e8a461f7, 0x3fe1ef01e2b3aea3,
    0x3fe8665e0552d1c3, 0x3fdf7ddb75a0e4df,
    0xbf9907d76d09c61e, 0xbfdc27d13ad9d364,
    0xbfe5d292733c5bf6, 0xbfe23edb987f4c81,
    0xbf9ab9ca7dc4dc59, 0x3fdfaded4e05d5ed,
    0x3fe4e9a33076b1f1, 0x3fe00eef3db05175,
    0x3f9d6a3a09303e86, 0xbfdacc30a1c43842,
    0xbfea5d2672401294, 0xbfdf66f3c0f7f686,
    0xbf9adc8b7959e4bd, 0x3fdd4cd51caf57de,
    0x3fe75145cc817aee, 0x3fddeaff429b16f0,
    0xbfa51903a92f5661, 0xbfe0e1206c76d582,
    0xbfe38149e6370ed1, 0xbfdf07984217d947,
    0xbf950d9e9e6c514a, 0x3fda17dbadbd5652,
    0x3fe55d041a864eba, 0x3fe0449a9318dafb,
    0xbfa5a162f44b0d0d, 0xbfde8689cf78b2e1,
    0xbfe4ad40cb7acffe, 0xbfe36fccb674a356,
    0x3fa1c50870967a10, 0x3fe19068bb0bc8f1,
    0x3fe75194540239fc, 0x3fddaf237ce3f498,
    0xbf710150ee9c66c0, 0xbfdacf36a47b896a,
    0xbfe6106f3f999af8, 0xbfdcc7394108c821,
    0xbfbc3b700e9fd0af, 0x3fde35fc0b751645,
    0x3fe391f0a777f156, 0x3fdcb94f0620af47,
    0xbf85999f3be735f5, 0xbfdd0d04501aceb8,
    0xbfe4d7f934d3582d, 0xbfe12ccab1e61e0a,
    0x3fa253cc2a779182, 0x3fdc0c9b5e96f412,
    0x3fe5b076cfe7a915, 0x3fdb7d5ec2355d7a,
    0x3f9c23cc3515820d, 0xbfdc1958356b18d9,
    0xbfe5518f6014ca72, 0xbfde66a8bfb1f443,
    0x3f721a45784de359, 0x3fe2d22b6e09064f,
    0x3fe83318d1e23e04, 0x3fdff69a51c9ec92,
    0xbf93a8422583b9db, 0xbfdd8654a148c2ef,
    0xbfe50aa9b79ad16f, 0xbfe1eeeb4788531e,
    0xbfabdfca7706b8d4, 0x3fdc348517fe3f11,
    0x3fe7e12209fa2d69, 0x3fe0fca79bf78732,
    0xbf954c07a7a0a379, 0xbfe2300f7662a12c,
    0xbfe32a8c9742ef75, 0xbfdba89cafb7ce38,
    0x3fc0fe73fcae703f, 0x3fe08291de41bcac,
    0x3fe4b3bf00ed4098, 0x3fe0069a98289750,
    0xbf8781faab76aab7, 0xbfe0e15ff375a2e3,
    0xbfe7100ecc8a9425, 0xbfdf474c25ef80d7,
    0xbfa5ee119b85d0d0, 0x3fde6d58f45255a4,
    0x3fe77128f0c9227b, 0x3fde59c40937ab22,
    0x3fa3c35a8201b037, 0xbfe14dd21acddd58,
    0xbfe834b01bd2e063, 0xbfdc872f487f551f,
    0xbfaf7c7614baef34, 0x3fe1591d4905da9f,
    0x3fe54e1c203df589, 0x3fe0a229b4b35564,
    0xbfacc9c6ebcf9c46, 0xbfde6be1e701b521,
    0xbfe44dcd90e61696, 0xbfdda91bf1d9074f,
    0x3f6af853ab711b4a, 0x3fdfd84053808276,
    0x3fe594428e0d401d, 0x3fe0096186bea2a3,
    0x3f9615a085f0ad0b, 0xbfe27d3ae9109bd8,
    0xbfe6ba607782192f, 0xbfe1968f85ca7e22,
    0xbfb09e79a562a73d, 0x3fdda90c1e1bdf52,
    0x3fe4b1be28a9d7cf, 0x3fe15e4e09ab34ca,
    0x3f99b11f77091407, 0xbfdab01f65e8eee4,
    0xbfe774bb5f953b31, 0xbfe0412e6a9053bb,
    0x3fa0275eb977287b, 0x3fdd33638655cfb2,
    0x3fe64e1848248a37, 0x3fe0438cf77d0dbb,
    0xbf803defaaeff5bf, 0xbfdc1cac281d5ed2,
    0xbfe56569d1a082c5, 0xbfe0d45263eaf2bb,
    0xbf94cbfa94af5599, 0x3fe067555f5e9dc7,
    0x3fe286b5263f6848, 0x3fe296d6419590a6,
    0x3fa0e9d66ca26f4c, 0xbfe173bf6f1e8deb,
    0xbfe49396c74c8199, 0xbfdc0a45645672b0,
    0xbf902d93030356e5, 0x3fdf8847bcf0d53e,
    0x3fe703c2f7ddc5bf, 0x3fe05260a6aa1f0f,
    0x3fa67e869b7f3d87, 0xbfdee04772c8d416,
    0xbfe59d408094994e, 0xbfe0bdef96000ecf,
    0xbfa5bc1e0bfc1ce1, 0x3fdff1f1ac9c0ab4,
    0x3fe5efcb2b866281, 0x3fe03fe84634a4ce,
    0xbf9bddb9b55c5239, 0xbfde9c3be98ee09a,
    0xbfe6d207d16c63dd, 0xbfdf2321751ce04d,
    0x3fa450da36f78d4e, 0x3fdeb1124af0b75d,
    0x3fe69ef46713708d, 0x3fe06381e7c33f34,
    0xbfc01bacc6414b2e, 0xbfe1aa158ad164f4,
    0xbfe78d24d003be73, 0xbfdd5270f4ea9dc8,
    0x3facd3dfff103092, 0x3fdc57f0d81528fa,
    0x3fe37aeb3ef137dc, 0x3fda56e304063a85,
    0xbfa1cb13fb66d3fe, 0xbfdef9b32028dac3,
    0xbfe5afba43a87950, 0xbfdf2a08825dfa13,
    0x3f8aa1a9daff1817, 0x3fdc3ad4ac1ee574,
    0x3fe90208d7b5fe85, 0x3fe0637dba460eb8,
    0x3fbce99cfbf094b6, 0xbfddf0a7d68b2c6a,
    0xbfe4912fc10de7dc, 0xbfe1b0a6d64fd289,
    0xbf984b7d1335d442, 0x3fdd3a830782d649,
    0x3fe5d80cbd26cf77, 0x3fdeed210e5786fb,
    0x3fa4623b79b9922c, 0xbfd9b6bf73af62fc,
    0xbfe814f919ee3172, 0xbfe14882ccfa2bd6,
    0xbfa0180bb264af70, 0x3fe069f969b31ea0,
    0x3fe95bd9566e48d7, 0x3fddaf8547d303df,
    0x3fb34d8ca7b08ad2, 0xbfdd3f2de3a5483e,
    0xbfe64762d4c44393, 0xbfe34e3bf8fda2fa,
    0x3fb503db8bd8abe9, 0x3fe115632bec817f,
    0x3fea7a43754f8c5a, 0x3fdc8c8a5c47adeb,
    0x3f7a624a97c411de, 0xbfdfa21aca71d24e,
    0xbfe500fac88c8606, 0xbfe1068eadd2b20d,
    0xbfb318815d8dc58c, 0x3fe0ab16fc7049f8,
    0x3fe6d3bc4ab2d424, 0x3fe14548cde12628,
    0x3fa1bdd026d9b4a6, 0xbfda83289a5f91da,
    0xbfe64754e1b66a7e, 0xbfdcd05dac4bb1a4,
    0x3fb8903eeb8e7b85, 0x3fdc6573676a6be6,
    0x3fe4f2fd1d9e2a0d, 0x3fde28c06232343b,
    0xbfb3960ca974ab85, 0xbfd9d3da01d079da,
    0xbfe5a51c51a80276, 0xbfe19d142d412363,
    0xbf261d23e02edbd5, 0x3fe0ad2de9e352c7,
    0x3fe6c8f2acced5ba, 0x3fdb37b7dd411bec,
    0xbf7cde7d866892da, 0xbfde53294dd66fbd,
    0xbfe6736518ac6bfa, 0xbfe09f42fcc2a9bc,
    0xbf988a0f5325c314, 0x3fe0760c60af9230,
    0x3fe5cf756dc9d902, 0x3fe26e8343ff5287,
    0x3f9ce371e4ffe2c1, 0xbfe1bcf9c3253127,
    0xbfe7e9ea136ec392, 0xbfdf8d0b83f452a1,
    0x3f82808fa521f2e5, 0x3fdcce5cf4017a6c,
    0x3fe407b428710809, 0x3fe071e1fcac0b31,
    0x3fb52145ecd409fe, 0xbfe0aca07cd58d5d,
    0xbfe9395f99624c76, 0xbfe03c4b7871eb1a,
    0xbfa6d19b4a578bce, 0x3fde084e7441f99c,
    0x3fe629f9f54df00d, 0x3fe2b5311f0751de,
    0xbf9ef50b82c2f53b, 0xbfe26128f20c2ad2,
    0xbfe4f208c818e65a, 0xbfdc034d53bb58f5,
    0x3f9bb5d579866353, 0x3fe11530be89c548,
    0x3fe6eb16a5ef13ac, 0x3fe181da1be864d6,
    0xbf93d0d932e1c23b, 0xbfdd873afcc2e1b1,
    0xbfe50898488a6b83, 0xbfe046d12195493a,
    0x3fa95aaec2d9d98a, 0x3fe15ab68969a51d,
    0x3fe6df60595f69c9, 0x3fe36a6fd13a7a08,
    0xbf9e2760976feb89, 0xbfdf8f205333a78e,
    0xbfe3695834a1392e, 0xbfdd232b4098ffbb,
    0x3fb4a20980c80d07, 0x3fdbc302f4e1417a,
    0x3fe754be6229e3d9, 0x3fdd854d4324b3ad,
    0x3fa0651778dbf22f, 0xbfdfeeba78866a38,
    0xbfe47a3b2effae34, 0xbfdeeeb8f7f20b1e,
    0xbfa54d3e5f0bf8c0, 0x3fdb758b8f14e708,
    0x3fe67b8159e4f79a, 0x3fdfd28f8035ccbd,
    0x3fa6e99c2e8f7211, 0xbfdcc5a219b15304,
    0xbfe7188261352a1f, 0xbfe1493937abe8b7,
    0xbfaa052b5c40792f, 0x3fde84a0b0cdfaad,
    0x3fe6307ffd2ed241, 0x3fdd8c16847ad6af,
    0x3fa06e70cfce7de6, 0xbfdb122cddb22d90,
    0xbfe6972a4a0e8ff1, 0xbfd7f7898297ff4c,
    0xbf8017566e2bfd54, 0x3fd9fcd49fc5d984,
    0x3fe62e2ae5d488e9, 0x3fdeea0d679f5d2e,
    0x3fa5e7ce5f7f6b58, 0xbfd7c6f1330094ee,
    0xbfe50994f055fc79, 0xbfe0d3db8eac96a1,
    0x3fb2899795ccc796, 0x3fe09fbf12fbdc27,
    0x3fe843e8c73a183a, 0x3fe117f424fd516e,
    0x3f8eea1ed284234a, 0xbfdc8c6bcf01c0bf,
    0xbfe68bead184aa14, 0xbfdd549e67d3c9b2,
    0xbfa28e07ffe9c7d3, 0x3fe28f65d679fbd2,
    0x3fe76bb86134e4ec, 0x3fdf75ce729abb44,
    0xbfa3508a59978c1f, 0xbfde43661cf17ef8,
    0xbfe4f6960158767c, 0xbfde5146468eba1f,
    0x3f908254b7ca7251, 0x3fdd7f2c156c206e,
    0x3fe75469943c8025, 0x3fe0dc0f8199c08f,
    0x3f9298d104da0f93, 0xbfd893a0e86a6535,
    0xbfe865e832d8849f, 0xbfd889e7997611d1,
    0x3fc210b5e346cd7f, 0x3fe248d73d5f91ab,
    0x3fe50b2ee9e2c9da, 0x3fdc9f39b34187e8,
    0xbf91ffebaf47d7ba, 0xbfe2ccc8adbdd0f8,
    0xbfe5f31780b3aa76, 0xbfde968b0994cf64,
    0xbfa6464fb815a516, 0x3fe24a86dd6027c7,
    0x3fe8d4eb4a17dd0b, 0x3fe03f892961a928,
    0x3f88db8468e58f24, 0xbfe17230fb6de137,
    0xbfe5c6ef2b2eb92b, 0xbfe03120989d9386,
    0xbfb05ffbb6f09f16, 0x3fe02cf7b1094059,
    0x3fe5f895ec20b927, 0x3fe241cf590a9cab,
    0x3f86b87a938cdae6, 0xbfe050bfc7f7bb62,
    0xbfe955c0271850f9, 0xbfddbe36a157c8ca,
    0x3f8c19f530c37ea6, 0x3fe0ec44eca4223c,
    0x3fe7fa8f92cfe46b, 0x3fe1b17b54912872,
    0xbf7c8fce9ce6ae40, 0xbfe0a0ec8d1faa7f,
    0xbfe7e233d3e67624, 0xbfdd8b397cb75e9e,
    0x3f7055e5628dc7c7, 0x3fe0f580c013be73,
    0x3fe68a08069d9227, 0x3fdffe308a2e0f02,
    0xbfc0ccf01315b18d, 0xbfe1f6a0dad98f99,
    0xbfe6a44202d75b0d, 0xbfddb1075bf0d942,
    0xbfa48ef245a0b1ac, 0x3fe167444c27e7ed,
    0x3fe5c5a970425879, 0x3fe0618239f36665,
    0x3f5a82a64cee8b5e, 0xbfe15b968ef145e8,
    0xbfe535be8a8498df, 0xbfdc8fd8c6630d98,
    0xbf8b547c219ff0d4, 0x3fe181e8b6a70b1c,
    0x3fe5807241f97fb7, 0x3fe28a60f908c444,
    0x3f7aa2de22de46e1, 0xbfdf400a3c06a9f4,
    0xbfe62af86a350919, 0xbfdf2e0fd2b07dcf,
    0xbfa76f7280e66e3f, 0x3fdd03bbb5b16b11,
    0x3fe7ea45d1fbe156, 0x3fdb224eaac41fb8,
    0xbfb44d5771208eae, 0xbfdc37f8dfe2d741,
    0xbfe68c2a9695494f, 0xbfe1d1dc338f4e0b,
    0x3fb7f5691ba71e19, 0x3fdc6748d1acace3,
    0x3fe51c20b37aae26, 0x3fe0a32dde5770d9,
    0xbf85d8bec2622ce5, 0xbfdd7ae9bb09c2d6,
    0xbfe57c3d86b4d9d1, 0xbfded997c97928c6,
    0xbfa6959897ce90af, 0x3fe108fa887d3f4c,
    0x3fe7a6e41d8d9471, 0x3fe021ff302cd798,
    0xbfa7bb074bc69265, 0xbfdebc6e7b69ec57,
    0xbfe7ccdc1a21eebd, 0xbfe094e676b17bcb,
    0x3f7ec5a34e91ae9f, 0x3fde4919b3036424,
    0x3fe85a9702a3c786, 0x3fe0a275232440d2,
    0x3f8008dff34e2205, 0xbfdf854964d8cfef,
    0xbfe674d6c63e4e9d, 0xbfe345c9462f9880,
    0x3f9ee4ee5d0b6978, 0x3fdb9cad5303132d,
    0x3fe8caae4490c366, 0x3fde793445c585f5,
    0x3fa01f1f9dcc99b1, 0xbfe0d28255b47f32,
    0xbfe553fa34ebedf1, 0xbfdcfb0a940ba47f,
    0xbfab820fdc629464, 0x3fdfea5d63f23ca4,
    0x3fe72b7c6ac5f222, 0x3fdec1bc1536777e,
    0x3fbb8c68302bf476, 0xbfe03c8b6efdedba,
    0xbfe90719596b6cab, 0xbfe011693c54b8c9,
    0x3f9970792fb32a21, 0x3fdd1ea42024fe91,
    0x3fe7f52735b5e8bd, 0x3fe07147d488cf2b,
    0x3f8b2c604209bb8e, 0xbfde64364846d67e,
    0xbfe69341bb59ebbc, 0xbfde72b21f776bbd,
    0xbf91d7d14b5e7b82, 0x3fe17c3f49b444f9,
    0x3fe64a2275a3a07e, 0x3fde0c8d95f16d53,
    0xbf90860703bbcefd, 0xbfdf129452a9df11,
    0xbfe6fd265aa5e23e, 0xbfe02c39dd742605,
    0x3f717381e44844ba, 0x3fe12d6da002df00,
    0x3fe5a1582bad274e, 0x3fe183680fc01101,
    0x3f8fe133577a0210, 0xbfdba0d204a2ca38,
    0xbfe4b22fa0d848a1, 0xbfde328c197de9d2,
    0xbf816af90f47cbda, 0x3fe015d4c740fed3,
    0x3fe504242de92af3, 0x3fd831a9de09b48c,
    0x3fab551a2907bba4, 0xbfdffe84eb52189c,
    0xbfe69e289fab863b, 0xbfdf3787e915c790,
    0x3fa715e1f2d06859, 0x3fe0861496738c38,
    0x3fe75852e939fc97, 0x3fdd64161f13e237,
    0x3f9d7b81ce34a6da, 0xbfe0b4ad6ec470e5,
    0xbfe47710029225e8, 0xbfe086877ccd36fb,
    0xbfb70729159a97bc, 0x3fe1276d7ef45c1a,
    0x3fe69fd35a780838, 0x3fe2d829f62f9ba1,
    0x3f84afd49de8623e, 0xbfdbcf1b5dd4e74e,
    0xbfe80a44b9ecac02, 0xbfdcedf5be527e92,
    0xbf99b5dac85f25a3, 0x3fe023660bbde319,
    0x3fea7b84aa82d10e, 0x3fe0cb19b33704e8,
    0x3fa9cdedb4752bd7, 0xbfe03093ef76d464,
    0xbfe6ec677cd6c188, 0xbfe1c5bb70074f3d,
    0x3fa13ebde49e2514, 0x3fe0df498bd100cc,
    0x3fe813f97487f5a4, 0x3fded034d60af2e8,
    0xbfa458ae4d40ec0c, 0xbfdee8e371588861,
    0xbfe2bd8195c78b10, 0xbfde1cfa2d4fd515,
    0x3fa9959336837078, 0x3fdc6fa883ade1fe,
    0x3fe5ba42a461df48, 0x3fe00567e34a0da4,
    0x3fa4836c27725df7, 0xbfdf62a5ad3d87d4,
    0xbfe97ee676d1ba0b, 0xbfdf8505f344b40a,
    0xbfb293574720842f, 0x3fde60afc70ab531,
    0x3fe4d16d66229485, 0x3fe1fda701785dfe,
    0x3fb018f2886efb66, 0xbfdefa4bb49e9341,
    0xbfe76c15d002eb67, 0xbfe3414372e22fce,
    0xbfb4a673346bff0a, 0x3fdcfa5b243e92a4,
    0x3fe71a6e919b471f, 0x3fdf6a70d7b7df75,
    0xbfa6e4af03128c9d, 0xbfdf643ce227e165,
    0xbfe695d3eee3cf63, 0xbfda44bce1f48f5a,
    0xbfa342e802be058c, 0x3fe194f02a02e951,
    0x3fe8a369b87bcaac, 0x3fdf0cfe33ecb459,
    0x3f7019b847031ae0, 0xbfdcdc8094005639,
    0xbfe3763893311c7d, 0xbfe0977a03b7d242,
    0x3fb9068a2aa5cf52, 0x3fdf5d84a48546c6,
    0x3fe7e1fea671e568, 0x3fe0028e9b8480ac,
    0x3f9ebf6cf6b3baf1, 0xbfd8a03c18a10bbb,
    0xbfe5bcbfc7ab1d01, 0xbfe21b8b302e0849,
    0xbf968ed45c4eacb4, 0x3fda414c49f0e2c4,
    0x3fe69a2f174858ab, 0x3fe09e2313818216,
    0x3fa44ce7fcbc070b, 0xbfe0f8c8dd7130ae,
    0xbfe6f5879355d37a, 0xbfded78bcabc5f04,
    0x3fae125b15fbf059, 0x3fe0592e4e45cae6,
    0x3fe6cf6f0ce61182, 0x3fdc067cbd905f16,
    0x3f87b7f3fda9247f, 0xbfdc99419b6e4274,
    0xbfe6de66dc7391ef, 0xbfddb8ac77451ae9,
    0xbfb5a24f265eaa20, 0x3fde38e7ee9632e7,
    0x3fe5cba4b079d1c4, 0x3fdd1b48d776400c,
    0xbfa4b1e41cb42575, 0xbfe07f49970ed100,
    0xbfe920fbe0d1228a, 0xbfde5422268eb706,
    0x3f8d23567c75a68a, 0x3fde95dc2b9f74cd,
    0x3fe8a49ca4f13640, 0x3fdf16e29654194b,
    0x3fb06a804f23940b, 0xbfe2851f300b0331,
    0xbfe5ee22cf9b642e, 0xbfdd3c2b401bfa70,
    0x3fa8e98eb1eef8f2, 0x3fdde6927157daf7,
    0x3fe982525849e2b9, 0x3fdc1a0e9a95ee9e,
    0xbfb247832605d0ad, 0xbfe05768b15387ac,
    0xbfe89e0e90d49f65, 0xbfe0c75333fada68,
    0xbfa3d2982eb51528, 0x3fda76fed72bea2e,
    0x3fe5b69477d3919b, 0x3fe289ecd68cdd1e,
    0x3f97e0798e82f952, 0xbfdfe60e251122e4,
    0xbfe4f3e1154b2081, 0xbfe2d1c14f677763,
    0x3f8aa1519a2ee0e8, 0x3fdf5435b0e7a424,
    0x3fe5c35cb2607de7, 0x3fe0bd719754e284,
    0xbf604725805b3ca6, 0xbfdef5b95fa442b2,
    0xbfe5e585cd885a00, 0xbfe327b8534c38b8,
    0xbfb264f275fd9f34, 0x3fe1f90cc41bbb37,
    0x3fe60e152570e7ac, 0x3fdd44ea674dc618,
    0xbf9f7b0f82062c3f, 0xbfdd995bb381cced,
    0xbfe59911d8359284, 0xbfe1ff386a5cfe25,
    0x3fb240a69cc3a9fc, 0x3fde4adfc6e9c8d8,
    0x3fe5b4aa55d174de, 0x3fdd802b223f64fa,
    0xbf8bfff751a403f9, 0xbfe3c32fc71eeb3f,
    0xbfe81957a289257c, 0xbfdf5f0ac0e5ee98,
    0x3f9861f32759f686, 0x3fdfdc29b9096100,
    0x3fe80d743ca2cf7c, 0x3fe17b772ca3c002,
    0x3f78108afbde0c84, 0xbfdc91490151fb76,
    0xbfe74bf43c466628, 0xbfddf4f7964f8bff,
    0x3faf77e8a18428d8, 0x3fe0c78aca3a50ac,
    0x3fe437507ebb5ef6, 0x3fdfd941311aba7c,
    0x3f918aeec0103717, 0xbfdfd5915a1e9156,
    0xbfe5f16e7f7cd9e7, 0xbfde338c6dd04501,
    0x3fac3ebe8b496a9b, 0x3fe1bf8d9c8f538d,
    0x3fe652076c8e5264, 0x3fdc3347a1a092fd,
    0xbfada6616642c6f7, 0xbfdf73414e593ab1,
    0xbfe6cff481bad90b, 0xbfdf9679957bf413,
    0xbf85ffe852fe0b9e, 0x3fdcf89791bed902,
    0x3fe5059b9d49e5c0, 0x3fe1e5f8219aaac8,
    0x3f9e96850910a143, 0xbfde09cf940ad866,
    0xbfe6597c1298e98d, 0xbfdc07a3f25d14c8,
    0xbfa225b9335dd4e3, 0x3fe16cb3d52e2fc9,
    0x3fea1c27e1fd9b80, 0x3fdf3a88956d4b22,
    0x3fb617669f870986, 0xbfe0162e33da020e,
    0xbfe8f9c651bcca8e, 0xbfdcd1d731052ccc,
    0xbfc09d6ba8cca8ec, 0x3fd97c500226ba27,
    0x3fe82dc8c48603ce, 0x3fdef76c2c154413,
    0xbf70d0de44ec195e, 0xbfdeb222cefb035d,
    0xbfe578eece5bf8fe, 0xbfde324ec1690325,
    0xbf4ecc4f29dd7863, 0x3fe22e580064a87b,
    0x3fe669189f6d211e, 0x3fdcba9af6a55a9c,
    0xbf97a7f0f19fb98e, 0xbfdb91d7d322fbfb,
    0xbfe62a7678865e43, 0xbfdc17c686229432,
    0x3f738135885fa43c, 0x3fdf66ae8e25ddab,
    0x3fe50356a35690fe, 0x3fe1794e6ef07430,
    0x3f11e373961e422a, 0xbfdcd45b17a7546c,
    0xbfe669494044dfda, 0xbfe151f9cce726a9,
    0x3f67757f285430a0, 0x3fdb2045dd3c2633,
    0x3fe51f7d60188744, 0x3fdd0a0fe5897b55,
    0xbf82b8d9b8afbe06, 0xbfe18e8eea69203a,
    0xbfe69ea245cb77da, 0xbfda6ab9ea05f147,
    0x3fa73d59aac22eb4, 0x3fe0b78279921b31,
    0x3fe758d36217c4c6, 0x3fdda641b34444be,
    0xbfa0cac5216296e6, 0xbfdfcca5a55b7a82,
    0xbfe6af35882d8f83, 0xbfddc54a33050b8a,
    0xbfa29bcc1fdde3fa, 0x3fe05d68e9ce6deb,
    0x3fe598dd4b88ef80, 0x3fe2588d8687df19,
    0xbfb5d83d85846efc, 0xbfe03bebcd4aa46a,
    0xbfe837847c6d8522, 0xbfe1e71dc99e4f6b,
    0xbfa2a6dbbc658f11, 0x3fddd301b9c8eda8,
    0x3fe4c0d0d6b464f4, 0x3fe06993d93c95ac,
    0x3f7f035eed0a7b90, 0xbfd9af37b528050e,
    0xbfe5a1cb1e0c1b9b, 0xbfe0839e95439646,
    0xbfa19259d5a0cfac, 0x3fe0bc537ad617fc,
    0x3fe5e8432d0bda63, 0x3fdcc90b3cb4fd20,
    0xbfa7cd9c23c4c17b, 0xbfe1edd8dc2ce58a,
    0xbfe2532e6d79d7a3, 0xbfdb57124fadbaa8,
    0x3f87752c2a09759d, 0x3fe08fe16464b78f,
    0x3fe7995eb7657a5f, 0x3fdc49b3f4b33963,
    0x3fb1dd3dfc143636, 0xbfe0a461b9e40b50,
    0xbfe8841a3bdf2bd0, 0xbfd9fbae78713539,
    0x3f741f0139af4dee, 0x3fdf935bfde00186,
    0x3fe7ae954adbd146, 0x3fe15d330cc8b4f1,
    0x3f950560e482c7dc, 0xbfdbfd141d4cf4b8,
    0xbfe6863605bdc91d, 0xbfdb9d926b4f72a1,
    0x3fb3af87333874fc, 0x3fe0c076d5ef04a1,
    0x3fe7c2fd32fe0cfd, 0x3fe26444869a6586,
    0xbf828454e8131b06, 0xbfdb1cdc6554f826,
    0xbfe5c3fa3332af61, 0xbfe03abf4a9bf53c,
    0xbfb04ff67f56e0d0, 0x3fdc055030bead62,
    0x3fe43b2a9469c9e0, 0x3fdda2f707e8b98b,
    0xbfa821105daf7ce1, 0xbfd9fcaf2dfce626,
    0xbfe8dbb14c55e3ed, 0xbfdf6380ae5f6230,
    0xbf7a2aed0532bc18, 0x3fdb8f1918e1f701,
    0x3fe6b290652d62e3, 0x3fe0335bac57a334,
    0xbfb0140a4d7dc8d7, 0xbfda52299a7a74d6,
    0xbfe691bafa8b910c, 0xbfd77214b2664464,
    0x3f95a0cd73363c6d, 0x3fdc3365af2ccbea,
    0x3fe55304d065dfa4, 0x3fdb05282c02a7da,
    0x3f96cbf8cefc214f, 0xbfdbc6459f343aee,
    0xbfe8d5343ad2eef2, 0xbfdec87a3e5fa59e,
    0x3fac93cc7c377059, 0x3fe05ce94d20cb26,
    0x3fe445b09070fa19, 0x3fdc24b5feb905af,
    0xbf8508e4959c6f17, 0xbfe201612fdc6a98,
    0xbfe62cc1defe73a0, 0xbfdf2f2c43b4e164,
    0x3f8b3c656ab6ee3f, 0x3fdf2ce9d64e26f4,
    0x3fe78f6ce3dcd291, 0x3fd9a8ee4e36a361,
    0x3f844c6995f906b8, 0xbfdca2d0c4b61f12,
    0xbfe488e569d98a1d, 0xbfd9798737b0b863,
    0x3fac6411b958ed6a, 0x3fdf904eec2fd1c0,
    0x3fe7208e2e082243, 0x3fdea0781b4990fb,
    0x3f8cff5482375bd8, 0xbfde161fa4feeeb2,
    0xbfe77f0da187bf68, 0xbfdf73af85e1a5eb,
    0x3fa52b1f30318c92, 0x3fe0801773614a61,
    0x3fe4263bba35a35e, 0x3fe005aa2ce248e2,
    0xbfa8f624de7988ec, 0xbfdffa6bf18a873d,
    0xbfe7a4a602989453, 0xbfdaa2c2de7b916e,
    0xbfad6efbae02c249, 0x3fdad81cbc1d998e,
    0x3fe57121d23b41ad, 0x3fe114c6c5c385d6,
    0xbf6403daf06f13cb, 0xbfdfe50307c494c8,
    0xbfe52e5a9bc0eccf, 0xbfde24bde3ed97c7,
    0x3fb18cf3e1f52fd5, 0x3fe078a2b861b0c8,
    0x3fe5bfc60011b573, 0x3fe31b60c45a6852,
    0x3f93cda40ed3ea15, 0xbfe13040115718cb,
    0xbfe6a06fb5509cc5, 0xbfdce5eac38ccb45,
    0x3f98fdb6237da1f9, 0x3fde07634f0cbdae,
    0x3fe8bb66cc644ea7, 0x3fda9321c186a264,
    0x3fad4571a01e4724, 0xbfe14cf56df945f9,
    0xbfe290b396ee5782, 0xbfdeb188c1715c5a,
    0x3fa798de5354e182, 0x3fdf2ad508351cf8,
    0x3fe59546b297e312, 0x3fde7613c8d6f4e9,
    0xbfa268e5169a0c8d, 0xbfdf0d16ceaf3a94,
    0xbfe7453b0e5da2f6, 0xbfe06581bba78a91,
    0x3f50f91db9c1a599, 0x3fe0ba263b5068ac,
    0x3fe5fd2a029f83f2, 0x3fdf989f87333eee,
    0xbfa42eae212d7bf6, 0xbfdb285aa2c1cefd,
    0xbfe63897a632526b, 0xbfda183090ad70ee,
    0xbf9a74a0f58c0b79, 0x3fdcecb13e8919ce,
    0x3fe7961b13abd3f1, 0x3fe0981f24481375,
    0x3fb3bfa4fbf24b72, 0xbfda24c292d55d32,
    0xbfe5bad4815cca68, 0xbfdffbf4665554e9,
    0x3f78b56964a40209, 0x3fdb4bd0c31ece4e,
    0x3fe65812a84dba38, 0x3fdd0a44a03e8da8,
    0x3facb1a0b874fa4b, 0xbfdd0eaf5b9aad2e,
    0xbfe1f10145963b8f, 0xbfdbade9f23d266a,
    0x3f771ad74713c570, 0x3fe1d1074458b72c,
    0x3fe9d5740d58879e, 0x3fdc4db473a08546,
    0xbf4ad171c9b873df, 0xbfe14895ec469acb,
    0xbfe7f51c4ced2810, 0xbfe0ab4371791b32,
    0x3fb0521c82a808ad, 0x3fe301b8fae0d6e4,
    0x3fe687ac2348ad0f, 0x3fdd7d60bf4cf0a4,
    0x3f728c8048711d2a, 0xbfda91c0c8ec22ff,
    0xbfe4c7993fac5219, 0xbfdfe84e7cd73065,
    0x3fbbd2e9e7743150, 0x3fdc94c7a5a7cfbb,
    0x3fe6edb3f0eb12c5, 0x3fdacb58b4982c43,
    0x3f92ecb42e3ca584, 0xbfe2d944757c719a,
    0xbfe6e0a0ee3a4523, 0xbfde4399ec8ac4cc,
    0x3f974a14bc54d66b, 0x3fe2859304e13a3c,
    0x3fe9806104ede09c, 0x3fe05a1f7d8e9907,
    0x3fb7fb521abe02fd, 0xbfdf76e42bbe818b,
    0xbfe9161c4ec3d942, 0xbfdf86f035db1d22,
    0xbf9e01193ca6afa8, 0x3fd7bc0c04365560,
    0x3fe66179095b0c0f, 0x3fddd77886279135,
    0xbf7fd4e7faf4706e, 0xbfe182f9090870d8,
    0xbfe3f07c60f846f8, 0xbfe007493702689a,
    0xbfa4cc44897266c6, 0x3fde4d7883806951,
    0x3fe55f1cd554a574, 0x3fddb2975e447f6e,
    0xbf9dab114097fd1d, 0xbfe35a96ad843ba7,
    0xbfe71b1b3b9969cf, 0xbfdde9b58959ba99,
    0xbfaff4df10c7ea46, 0x3fe0deff25e891e0,
    0x3fe56b595d3af0da, 0x3fe1d27a88725d53,
    0x3fb286ef50f052b1, 0xbfde5f5534a269fc,
    0xbfe89cc4f4e3489e, 0xbfe1ec470319fbdb,
    0x3faeecb8ea0694c7, 0x3fdf9e746a16611d,
    0x3fe8a57ea47b6f45, 0x3fde4c0a7c60ace8,
    0xbfb0a6bb2a1f34b8, 0xbfe1e4a9104071f9,
    0xbfe79727d8b44824, 0xbfe024fa9af5b1fe,
    0xbfb0f9526c8e71e4, 0x3fdcc09b069c73ea,
    0x3fe5abfb42aa7c82, 0x3fdad8d59aab5f3e,
    0x3fa2428f3d1bb698, 0xbfe253fa7a040aca,
    0xbfe9487f92043218, 0xbfe0101e47a746da,
    0x3fbcaac805762e62, 0x3fdc8458c910ea72,
    0x3fe6c6fa6f6c3da4, 0x3fdf26aefefe3b4b,
    0x3fa4a4dd4e990add, 0xbfe19ee3618aab8a,
    0xbfe7ee5d1eadd52b, 0xbfdf00f7d37bd562,
    0xbfb278fc236d1ac9, 0x3fe1457cd9d09256,
    0x3fe62968e5760bfa, 0x3fe107959045ccfb,
    0x3fa02a96aaab0f0a, 0xbfe17f8112f657fb,
    0xbfe527296d44689a, 0xbfe004bf6615169c,
    0x3f87e5b49cab5ed2, 0x3fde12ec7020d7a4,
    0x3fe61b423dee0559, 0x3fde0cb25ee54a3b,
    0xbfa87a4ac0c5011e, 0xbfe12621934413fe,
    0xbfe8c9163e823183, 0xbfddf8233410754c,
    0xbf9ce8e8a646534e, 0x3fe0ad610bb54f4d,
    0x3fe661407bd56ba8, 0x3fdda6110963edaa,
    0x3fb9ba96af79ff5b, 0xbfe035491b71af31,
    0xbfe633403925b2c6, 0xbfe0c568ace371cf,
    0xbf7f2d783dc61c32, 0x3fdc3e4db4ddd0a9,
    0x3fe58a899b43f26b, 0x3fdbe642696b0c54,
    0xbfb74d949cb02848, 0xbfddd2d772152f5e,
    0xbfe5cc8eeb402f35, 0xbfdbad9c9f28b5a8,
    0xbf5b387bdf6365aa, 0x3fdce9d7d7355d7f,
    0x3fe404e309f8f578, 0x3fe14c99dfcae1ad,
    0xbf9ffcb23a98e7df, 0xbfdb30e06ea578fb,
    0xbfe68e4228f23d03, 0xbfe03af53c5d482b,
    0x3fb2a8573d791485, 0x3fde533ac2b105e8,
    0x3fe6641c49ae4bc0, 0x3fde14b0caf45682,
    0xbf973960e830c6e5, 0xbfdff4e6f6e2b492,
    0xbfe6ff4b5b683dd2, 0xbfe1ed58ced8aa0e,
    0xbf9be3005bd6103a, 0x3fe1dcb1c96ff1bf,
    0x3fe44296d4faffd7, 0x3fdf7ac75ed10aa9,
    0x3fa1528acdf1b922, 0xbfdf0562ed526cf7,
    0xbfe6aecede594dca, 0xbfde6901b232847b,
    0x3f834828a32ecd5c, 0x3fdefa57cea1b4a7,
    0x3fe55cd759273b8e, 0x3fdc25b08ef4b504,
    0x3fbd17ace4f1f6de, 0xbfe0d5acddc9f74b,
    0xbfe6eb359c2a9091, 0xbfdac168e6ee8eba,
    0x3fa1498beaaa4b23, 0x3fdec32714482855,
    0x3fe47c1e7154a209, 0x3fdbd833aeca1af0,
    0x3fb0b80c168731b8, 0xbfe08ba14ccc1ab8,
    0xbfe53315288bd847, 0xbfe07132948db399,
    0x3f8e675d922888dd, 0x3fe2899ea5970cad,
    0x3fe7c47211593e3f, 0x3fde5a1761f848ac,
    0xbf72241b4991bc83, 0xbfe138affccb5fcf,
    0xbfe51f6712b29e8f, 0xbfe0a1d60ad3a8b2,
    0xbfb31b4fe71a6cf4, 0x3fda6264cfd87a52,
    0x3fe551487af39636, 0x3fda38ff488d4c40,
    0xbfa63d177d7a501d, 0xbfdff685cbe0cad4,
    0xbfeac65e53d0e294, 0xbfdf1650d2205555,
    0x3fb9dac6187a5f93, 0x3fe10149b748e53b,
    0x3fe697ef9e4f9af0, 0x3fdc8e8bf6fd4d5b,
    0xbf9f8d12d272389e, 0xbfdc025ae36e405e,
    0xbfe729f77839257f, 0xbfdfb499d840e7cf,
    0xbfaef98d45e24d8f, 0x3fdf030e3a306851,
    0x3fe685389a003bc1, 0x3fd9a311ff3d5c26,
    0x3f9aed3dd98e401c, 0xbfdb1a1c6a9ca5ec,
    0xbfe6edb6476d2115, 0xbfe1b570cca6f070,
    0x3fa458923c251393, 0x3fe0a5d13ef57d3a,
    0x3fe646675aac75d7, 0x3fe0828d247298c3,
    0x3f8a5c0aa6f7b1f3, 0xbfdfab3a72ba8fc0,
    0xbfe668f6a3af4037, 0xbfe09ca5d455124d,
    0xbfa1887e43f661fe, 0x3fdc1c8d0a6a0e90,
    0x3fe6ff75e54d4e24, 0x3fe20a188712e68f,
    0x3fa8f6477b2fc8fb, 0xbfe08dd81c26e242,
    0xbfe8b8246b870f86, 0xbfe11c254a8e20ea,
    0xbf925deb311e4316, 0x3fe0c6bfb21a060e,
    0x3fe7506e7d30bd30, 0x3fe0fac03da2d84c,
    0x3f94966f9aa02243, 0xbfdb68b134db7cbc,
    0xbfe5766aaac49d49, 0xbfe15b249cdadf03,
    0xbf9d3c084344b00a, 0x3fe29d035749a3cb,
    0x3fe86f816f4d4e9e, 0x3fe082c21f8c47e3,
    0x3f7f6e9f0816926f, 0xbfe215b99f75ef70,
    0xbfe5082c99660ff9, 0xbfe13800a9dd09b8,
    0xbfa195dcfd20a325, 0x3fe0982179c8c340,
    0x3fe58358ab060119, 0x3fe0ef8cd4f05bf1,
    0xbfae3d11a48e177c, 0xbfe0d4f0f8d57f26,
    0xbfe45f06f97b8198, 0xbfe1947136a54cbe,
    0xbf8f920ca6122f70, 0x3fdedef121dcbb48,
    0x3fe7a5576a03bd33, 0x3fda28099d1deae7,
    0xbfa39eadb6e9cb9c, 0xbfdcb7c12ac2716c,
    0xbfe5c9aec32299f6, 0xbfe0c9d3874306ee,
    0x3f9a687f5bf5bfc4, 0x3fdd727bd375e762,
    0x3fe964e4476da89b, 0x3fde65cd60d0451c,
    0xbf9c2eeafc106a27, 0xbfe27dd6a5cf1d04,
    0xbfe4a3be9b9b45ba, 0xbfdd6c284ee092f8,
    0xbfaa9bd688e9dc2d, 0x3fdd0c140fedace7,
    0x3fe5c601c1e69d6b, 0x3fe3a42d77924889,
    0x3fa881807e7763fe, 0xbfd8a4b273491739,
    0xbfe9ecb21c14f138, 0xbfdcada59b6e0f2f,
    0xbf94887519a5975c, 0x3fdf61c2249a8d37,
    0x3fe958480f198663, 0x3fdc19861343ee24,
    0x3fbdb7934bf023bb, 0xbfe087ec8e50ec10,
    0xbfe79655fa20c9ce, 0xbfe001daf576ef51,
    0x3fb615ef7ec1f45b, 0x3fdbd786c3555067,
    0x3fe530a443e419c9, 0x3fde495cdcd10e6c,
    0x3f7f9acdd07e7bfc, 0xbfddda3a4411ae67,
    0xbfe6a887787155bb, 0xbfdbdc3bec0adbf5,
    0xbf9c8d6624d3b6e5, 0x3fe0ac3528d39e1b,
    0x3fe6262ff46bc922, 0x3fe058729cf9201f,
    0x3fb4b0eea25a1156, 0xbfe12faa3348364c,
    0xbfe5f40605c7e9bf, 0xbfe2985cc854e6c6,
    0xbfb1312ee59ca328, 0x3fdc8635040b667a,
    0x3fe4de6ddd4d2cb0, 0x3fdfa6bc16484a4e,
    0xbf974eec3530ab83, 0xbfe0e730877101b0,
    0xbfe7c5b2965639d2, 0xbfe21de164c2b489,
    0xbfa7248a1851a671, 0x3fd860b98d8cc6ad,
    0x3fe76252248cf617, 0x3fdb2082bdd27776,
    0xbfac021e48b72e6b, 0xbfe3a20f3f881a0c,
    0xbfe79282d7a69bda, 0xbfd9415cde569bfe,
    0xbf80de4fed8c217d, 0x3fe11ac99390d234,
    0x3fe534fbc0e8eab1, 0x3fe1013b33cc8c71,
    0xbf8991878ffbd395, 0xbfe0a66226a200b7,
    0xbfe5a23ec470ac55, 0xbfdc3a35058fd8c2,
    0x3f54ba8aab08bc71, 0x3fdd2c0481440a26,
    0x3fe4703c96f1ba63, 0x3fdd756a2a4e73f6,
    0x3faed9cdb840ea73, 0xbfe0ebfa0f3fbe01,
    0xbfe6f996f7f3d6f5, 0xbfd91f0d7185d3a4,
    0xbf8d15c172bf9925, 0x3fe06bc1cd6a4ba0,
    0x3fe6c77a2290b9a5, 0x3fe04b533f101c15,
    0x3faf7b29237a3b94, 0xbfdc27487d09dfe9,
    0xbfe4a569e76f0072, 0xbfdb7622565415e6,
    0x3f62435f9ddbb100, 0x3fdc0fd996bf7b26,
    0x3fe5967d015c1aff, 0x3fdff82f785297bb,
    0x3f8692e5746551c1, 0xbfe05533d21d0743,
    0xbfe64c425349ef74, 0xbfda2e8f0044caaf,
    0xbfc36824aee7677a, 0x3fe19f9e08098065,
    0x3fe505bba81cea5b, 0x3fe0bfd981cf219e,
    0xbfa06aa2029c131b, 0xbfdc74f6868d2c1d,
    0xbfe7248096030dbe, 0xbfdda74a27691f9c,
    0xbfa9e2e738762088, 0x3fe21dded69035b1,
    0x3fe7eb29ff809334, 0x3fdd6638a54c8612,
    0xbf946921397eaef1, 0xbfe0f9a968e1f401,
    0xbfe6870994adb762, 0xbfde59b7054dea64,
    0xbf6e5f896a51753e, 0x3fd96b502de08a95,
    0x3fe68b2f11506cb8, 0x3fe166d7d93b4074,
    0x3fb4afec58719301, 0xbfe18b9316f359f8,
    0xbfe70f26738637ff, 0xbfe107cd13e9a57a,
    0xbf8fff55df383c21, 0x3fe02bd7fcc2a4e7,
    0x3fe63b97d8bca555, 0x3fe0d30a263bc15a,
    0xbf94f7a27e87d9f6, 0xbfdef97594e432ea,
    0xbfe59a45f05751e8, 0xbfd7eb85dfba4c5a,
    0xbf951a726a9b80f7, 0x3fe01a81b018693d,
    0x3fe74954c4543056, 0x3fdb27684378998b,
    0xbfa9f49121eba4a4, 0xbfde05a3a11ec5c3,
    0xbfe6ef74a839ad22, 0xbfdc78932c891d69,
    0x3f8dbf7a0ab9ba85, 0x3fe06f685c9669a0,
    0x3fe618563a0f2380, 0x3fe07a61e8f02ab6,
    0xbfbe9fc34ddda9bf, 0xbfdf404469920165,
    0xbfe5ad259b5924e7, 0xbfe48e93cd8634cf,
    0xbfb17c428b197c49, 0x3fdd77e511827ffe,
    0x3fe8b79150605980, 0x3fde9509ebeff178,
    0x3f9012288f1a7e9f, 0xbfdcdea21486adfe,
    0xbfe68d396ea27fc0, 0xbfe1a2dcbe39ed89,
    0xbfae7be2c26e77e6, 0x3fdf3845c757d6b2,
    0x3fe6cda28e83aab6, 0x3fdca6e095c2c243,
    0x3fa659de44123e3c, 0xbfe10c366420625b,
    0xbfe6447eeb0991cf, 0xbfde808a52a4746c,
    0xbfacdf7255edc9ca, 0x3fdb6e6df5f5f37c,
    0x3fe543607d677059, 0x3fe0978741e31f3a,
    0xbfac63d3530ee711, 0xbfdddc01b5904b8f,
    0xbfe8fc495680b3da, 0xbfdde784c6057db6,
    0xbfadab6b4435504f, 0x3fdb9c727a540689,
    0x3fe6d5e1c020be55, 0x3fdee0230ff36c39,
    0xbfb2b07e3c3b71c3, 0xbfdf87ef6fbb5c50,
    0xbfe61e59266ab151, 0xbfde8b6bb36d208a,
    0xbf95d2732944403b, 0x3fe2c3f45192f57f,
    0x3fe534a5f0ea8a2d, 0x3fe09cf76b16e444,
    0x3fa13e1dfe1ec741, 0xbfe356b907432511,
    0xbfe4156af4891372, 0xbfe0e0f4bd6c3456,
    0xbfad853af131f3d9, 0x3fd7b610088c9de8,
    0x3fe3425b07c627ce, 0x3fe21dafa400d199,
    0x3fa4b5007fcdb49c, 0xbfdc29805f10ee88,
    0xbfe50dfa06f5b53b, 0xbfdd19797cfbc1ab,
    0x3f9778a3f7f66a97, 0x3fdf41c01974e9f5,
    0x3fe7f75a029d00d0, 0x3fd9ae538f98da5e,
    0xbfb1a70df12f6c57, 0xbfe05fc51990985d,
    0xbfe5b3bd0c5d2830, 0xbfda76df153a973c,
    0xbfa68c95572eeb49, 0x3fd956c8b73cc3b4,
    0x3fe5912d2791bd9c, 0x3fdfa3e0a0ecef4e,
    0xbfb9178b928e4dbb, 0xbfd4c87c5e46b62b,
    0xbfe71839b46fadf5, 0xbfe112891b70c6de,
    0x3f7819fd707120ca, 0x3fdee28001590c1c,
    0x3fe570edf279b2d7, 0x3fdfb124140f4e03,
    0x3faa9a87f88ab4ed, 0xbfdbbe1937b557bf,
    0xbfe53b229f7e984c, 0xbfdf4c44627e6b39,
    0x3f9749f6469366d3, 0x3fdd0ca3e0cf6da0,
    0x3fe6dbf1b37a70b0, 0x3fdef6ff057461b9,
    0x3f6e4becdc9a6887, 0xbfe12445b64d5a00,
    0xbfe19b8c18691df9, 0xbfdaf6237f36a6dd,
    0xbfbea0ea846cb620, 0x3fe0c70784485ebf,
    0x3fe55727d28d2365, 0x3fe39c1d5eac4696,
    0xbfa00c0d44eb0544, 0xbfe05ed744c9effa,
    0xbfe63b647d520ffa, 0xbfe0b1875048e324,
    0xbf9de016baf53141, 0x3fde55b6b7ac9cbb,
    0x3fe56c6bc1c4c1cb, 0x3fdcbc5caf08f45e,
    0xbfa0d9e23ceb428b, 0xbfdba04aee1c25ea,
    0xbfe7acaa00673593, 0xbfdfc8610346be3a,
    0xbf7b949e3540e03e, 0x3fe01f1b984e2988,
    0x3fe942365af3cc92, 0x3fe1d1486e835064,
    0x3fa237938d46130b, 0xbfda4e99961398c6,
    0xbfe7344551713cd3, 0xbfe0bad21fd300bd,
    0xbf86f1fe8e03470e, 0x3fe07541c7d057dd,
    0x3fe809b570c54f49, 0x3fe011dc6f193ba0,
    0xbf988fa12d6877fd, 0xbfe08890e8631c44,
    0xbfe7278ea9519502, 0xbfdfb588af548186,
    0x3fa564179c8b52b9, 0x3fdf23928a6ff4a8,
    0x3fe3d7cb64fd1665, 0x3fdce9a3bb073995,
    0x3f8d62b366965796, 0xbfdd11a390714983,
    0xbfe673f3d2fdf422, 0xbfdddeea08d72eee,
    0x3f49acc5af0be281, 0x3fdfc8e2363e7eec,
    0x3fead6f8457184cc, 0x3fe1e9f51b452738,
    0xbf8b6603b3264700, 0xbfde15cddd9b9a67,
    0xbfea0e49a7d815fc, 0xbfdd84289c6db2a3,
    0xbfb3e3f27f76186e, 0x3fdfb512024acf78,
    0x3fe5ee2da6fa99d0, 0x3fe24a19f1b6bbb0,
    0x3f86175191580529, 0xbfe08069bd143238,
    0xbfe7d19341a9d717, 0xbfdf4519d9690083,
    0x3fbbc42d2f70659c, 0x3fde19c5c691d8b3,
    0x3fe8cbb3f8cef38c, 0x3fe1fff573b01740,
    0xbfa9a7dc9e432efb, 0xbfdd24573ece45dc,
    0xbfe580dffb249dbc, 0xbfe1eccb53756c97,
    0xbfae17384a250e93, 0x3fdf7a6c83fc421c,
    0x3fe81917a029e560, 0x3fe1809037cbd174,
    0x3f70fd9aeba9bd40, 0xbfdfe2b2e2c5bb25,
    0xbfe6bf0f1196f26d, 0xbfdb37b53d813ba4,
    0x3fa9276da7ff580f, 0x3fddf912192bf310,
    0x3fe5d319aa1a7e87, 0x3fe279018dfcb827,
    0x3fa5d1429868969e, 0xbfdc01727c2016a0,
    0xbfe74782ae033850, 0xbfdc361d8cfca9d9,
    0xbf9313f2b6a37877, 0x3fdad13cf20cd39e,
    0x3fe707ea5bdb50f5, 0x3fdfc0f00cf9d9e8,
    0xbfae496c535e4361, 0xbfde4f95d086bf11,
    0xbfe7923d7f9ff89f, 0xbfdcc51f8de52eed,
    0x3f8643ef490a829c, 0x3fdec25792c6f30e,
    0x3fe73f97e21efdd7, 0x3fe069307fa29c7a,
    0x3f6e7c50e968859f, 0xbfdf993933ad8972,
    0xbfe69bb7029539d9, 0xbfd7b201720a61e9,
    0xbfa30d8fe1e0c90f, 0x3fe03540faf72c45,
    0x3fe962a3f648dbe7, 0x3fe0b4aa277c69c3,
    0x3f8b1db5916b29aa, 0xbfe20f03d7b07f23,
    0xbfe50a6afd8eab65, 0xbfe1fd6ff93bba92,
    0xbfab6354295663c2, 0x3fde48b47b081208,
    0x3fe7347b896e71ed, 0x3fdca3778694c579,
    0xbfa269db9969a3ca, 0xbfdfd5cad13dcd82,
    0xbfe67131f4c2b774, 0xbfe201b20e7e07fc,
    0xbfb320c918a38614, 0x3fde713a0749ae2e,
    0x3fe4f865e19feb38, 0x3fda83ea48760c90,
    0xbf9d045046e97dfe, 0xbfe135ac3d1572d1,
    0xbfe33c5d71bcf616, 0xbfe104d850048032,
    0xbfa17258264e101a, 0x3fdb380a374ee4d8,
    0x3fe36f94ee31d652, 0x3fe075433b4e3274,
    0x3f99352e18067af8, 0xbfdbb4197a064080,
    0xbfe7103766668790, 0xbfdecce873f0463a,
    0xbfa7420a28c9b750, 0x3fe02b6e24ef0fc3,
    0x3fe3960bdcd5c0b8, 0x3fde1d106efaa6a4,
    0x3fbc60da859222a6, 0xbfe0eb4d44c92549,
    0xbfe827014fd5cd33, 0xbfe102e4b1c53224,
    0x3f9b20be502bd398, 0x3fdf4e0ef6afa93d,
    0x3fe39e15dd6c574f, 0x3fdbd4341ac598b6,
    0xbfa50cdeb095fbd4, 0xbfe1a9d5d2dca864,
    0xbfe5f3c19adf0bd9, 0xbfe1f300ac8c22c2,
    0x3fb00afce18991f4, 0x3fdea11f23d2af18,
    0x3fe6fb6f5e8b5291, 0x3fde5e303b5c9d98,
    0xbfb3188151edd939, 0xbfdd24650471bb56,
    0xbfe76de86762d72f, 0xbfe027b60cbbc6ab,
    0xbf9e13f2ed5cd276, 0x3fdfe4dbad1a3882,
    0x3fe77062af04b387, 0x3fdfaab5bddb7150,
    0xbfb1119fe777c497, 0xbfda68ae1184ac81,
    0xbfe51a330d7d4fee, 0xbfdad21f79719e1d,
    0x3fa38c7097492e9e, 0x3fdbdda07e09550c,
    0x3fe96fd72b40e514, 0x3fdd69f3389e3bf5,
    0x3f70bff7d6a30685, 0xbfdfb48752cc30d7,
    0xbfe6dffe92b5f075, 0xbfdcf4e150e7ef89,
    0x3fabd71e3ce5cd1b, 0x3fdfc857137b4c59,
    0x3fe7239c2795d787, 0x3fe04887199e2bf0,
    0x3fa05ff9c5d97cf0, 0xbfe0a1bd236b7fb8,
    0xbfe5c470f2ef8c86, 0xbfdbb5781ac37532,
    0x3f75378216021ab8, 0x3fe20ddb9ac56adb,
    0x3fe3e1021770916c, 0x3fdeedf4b4942509,
    0xbfa5691c78f187b9, 0xbfde1c94b38ce996,
    0xbfe7b944b1e82332, 0xbfe08f118c61fa3f,
    0x3fa5eb8bf8f65535, 0x3fdbd5d5a15ed94f,
    0x3fea6c887fb8f441, 0x3fdc5e0544db3292,
    0xbfa73eca0aab3b5b, 0xbfdfebc052fe4caf,
    0xbfe68ee58fb34677, 0xbfdbfc1a24231582,
    0x3fa2b276c9177303, 0x3fe256495382c450,
    0x3fe69238c8f0d7c0, 0x3fe0848fca4c6821,
    0x3faca7ca915ecf63, 0xbfd7bbe8662cf641,
    0xbfe3ebdc563b7847, 0xbfe094948c9b4f76,
    0xbfb76722e3ef9a54, 0x3fdf0ab4c7ce6f09,
    0x3fe9813ba3fc78a8, 0x3fdff97139055068,
    0xbf8b1e22dc7ee198, 0xbfdf79a9279ae55c,
    0xbfe797077bb55dbf, 0xbfe1daa0d72d47e7,
    0xbf68d12fab341be2, 0x3fdef4d21dd1eff4,
    0x3fe602433f164512, 0x3fdf20cb4c3f93a6,
    0xbfb3824d57c60210, 0xbfdfd8e7730f6c20,
    0xbfe568e2bdf9b448, 0xbfe499381d899d6a,
    0xbf8367d77972b784, 0x3fdf74b21570f98d,
    0x3fe7f087276c5e36, 0x3fe09e84556919f7,
    0xbf890f7ad58698e5, 0xbfdf2299b94f8ecd,
    0xbfe5338fc0bfd114, 0xbfe15dc602fe1c6a,
    0xbfa898ad25cf556a, 0x3fdab1982dededc5,
    0x3fe624ae5b782fc1, 0x3fe1769aed884557,
    0x3faa97d19e30e60a, 0xbfddfb87a216ef9a,
    0xbfe5b835c1311bf7, 0xbfe03f12f6986c0e,
    0x3f9b823cefd6bb39, 0x3fdd18a71f41e0c8,
    0x3fe7bb9ebcc7953a, 0x3fe1b8cc9027d1e2,
    0x3faf94537d549070, 0xbfd9c710dcd0fe49,
    0xbfe6cb27d9445d40, 0xbfe034e400410190,
    0x3f74987a782fad3b, 0x3fdd0be3051b3bca,
    0x3fe7b66e5164c171, 0x3fe02e6b87ae6cec,
    0x3f8a2da79bcfdc03, 0xbfdefddf289de836,
    0xbfe4df6cc18f80a9, 0xbfde0decd59adc8c,
    0xbfa3c0fead3e4e10, 0x3fdaf2ccb8637eb0,
    0x3fe5eb2bd4c2a9ff, 0x3fe03671147e894a,
    0xbf96b9aa106412da, 0xbfda70181b2edc41,
    0xbfe4de908e2413f6, 0xbfdc17fe9cf30ab7,
    0xbf47e87588ec6c33, 0x3fe14ae8a2abb357,
    0x3fe720c04e59589a, 0x3fe0729320c14ab3,
    0x3fa3740ae7485959, 0xbfda948d9f3a0234,
    0xbfe729cc2e1823e6, 0xbfde69c24d4450a7,
    0xbf8befff9af0f384, 0x3fdd8a8e650e4803,
    0x3fe6684194b26fec, 0x3fde951019b92f1e,
    0xbf83e944c9282543, 0xbfddc086daa4a984,
    0xbfe7490f5f919833, 0xbfe0767560b74c23,
    0xbfa5ebe22404fbcb, 0x3fe1d82660a8c91f,
    0x3fe79b4c64b4083a, 0x3fdc4c016ffe6da2,
    0x3fae2aa42b6168aa, 0xbfe00438b9fa83b1,
    0xbfe64a420afa1dfb, 0xbfe0b20759ed6e00,
    0x3f99f5fc62830a7d, 0x3fe0eded721f7101,
    0x3fe5461da6397860, 0x3fdf6580a8289e50,
    0xbfc12f1d740f8ae4, 0xbfe2b0ef5b08e237,
    0xbfe56678de7fd086, 0xbfe301538dd6d03d,
    0xbf98e9889af24148, 0x3fdf0f958495e832,
    0x3fe4c4fdaa7df3d1, 0x3fd89e8d119b6b5f,
    0xbf9974ca8bf4ea66, 0xbfe006a6a5329ce7,
    0xbfe81f1fe3bdef5d, 0xbfde9d4c2dc4427c,
    0x3fa61b2bf38d6d73, 0x3fddf0421a34605f,
    0x3fe76950bdd3f361, 0x3fe29c4650bf2d01,
    0xbf998c84f35fd6d3, 0xbfde48decaa3436c,
    0xbfe52a2395f86a4e, 0xbfdde14b6de01fee,
    0x3fa0173bb42ea7f5, 0x3fdd0624ff4ba4b6,
    0x3fe78e99a7ad5046, 0x3fdce20118ebbfab,
    0xbf849b85cd7f3ffe, 0xbfdf83810018fdc9,
    0xbfe3b0cf29f601c6, 0xbfddcd08903770c6,
    0xbfb01786ed34403a, 0x3fde2c329333da21,
    0x3fe699bc7a59c984, 0x3fe06bf59928ab83,
    0xbf9c4127737fc2b3, 0xbfdeb580da3a527a,
    0xbfe5cc29bf772a7e, 0xbfe2d1ed26b88160,
    0xbf9bd18bc62dd88d, 0x3fe17a81ed63f622,
    0x3fe895d106a6304f, 0x3fdb2d10beab6e30,
    0xbf54a54726b038d5, 0xbfe13942bab76d04,
    0xbfe6faab23c7ae52, 0xbfe070bf4c48208c,
    0x3fab787be3b0d4c8, 0x3fe1f2c3ff098c6d,
    0x3fe61a9c41d467a2, 0x3fd885503b9ebf90,
    0x3f9dfb6d5331ad51, 0xbfddc7bffeb758fd,
    0xbfe44a8714b6ced8, 0xbfdd4d3b63d83aec,
    0x3fb8dc8404102059, 0x3fe1c43246551c86,
    0x3fe3808d3f0490d8, 0x3fe00fc6a66195f3,
    0x3f869dc9bbff501d, 0xbfe048c41b156a06,
    0xbfe77f12a1b16a30, 0xbfde1ac6d95c3958,
    0x3fa7f892898e26d5, 0x3fe308d350d5950e,
    0x3fe6f49a6caa7397, 0x3fdec16e5eba52af,
    0x3f6d8ef0fef10705, 0xbfe1c600fc93fc38,
    0xbfe6cd93c2f0da51, 0xbfe13270f460a3af,
    0xbfa69abe76a40cfc, 0x3fe1a9e32bb4baf0,
    0x3fe4b8e93f805168, 0x3fe16bc7edf626ae,
    0xbfae62a954f8e144, 0xbfdef7c50dcf8077,
    0xbfe579243720d6e4, 0xbfdfe3250756e12f,
    0x3f8ad8e6d7f6b97b, 0x3fda8f1fc03800e2,
    0x3fe59cd0d43ee413, 0x3fe06ad15d00a324,
    0x3fac8c624336cb9c, 0xbfdafa5e13ae5b9d,
    0xbfe4cb9ec767c6ec, 0xbfe04772b6f74686,
    0x3f67f33fae417857, 0x3fdd7de66130af26,
    0x3fe36cc63c48c575, 0x3fdf3c344aa4e8d0,
    0x3f8ff8114ccf8db9, 0xbfe0a7a140b37ab7,
    0xbfe4c078c576e87e, 0xbfdfe6db866d41c6,
    0xbfb6043466c4a843, 0x3fde7b02abf5d07f,
    0x3fe6e165d0c746f4, 0x3fe00a35c4605778,
    0x3fa93f64a4b5f1b4, 0xbfe034ef9aa424c1,
    0xbfe7e983ae4923c2, 0xbfe01ff1de8e8da0,
    0xbf84c771d7a86109, 0x3fdf5271a7c927fc,
    0x3fe3e2c76c53fea6, 0x3fe18b2a759412c8,
    0xbfc1e360ea37ccb3, 0xbfdc335d631246f3,
    0xbfe5d45ee0a293fc, 0xbfe175a4b9654815,
    0xbfbe43afe0f48ef9, 0x3fdd28b4160c1221,
    0x3fe4d98562166319, 0x3fe06520ced3ae0e,
    0xbf7e06ae00cb4f49, 0xbfe1fc1a27473492,
    0xbfe81f847214ce48, 0xbfe0d85a43f4c8c3,
    0xbfaf29401170e802, 0x3fdbeeed6cb4fcba,
    0x3fe57c6504a4d91f, 0x3fdeccd10a667372,
    0xbfb809c1c96df4f4, 0xbfe06f45d55a1889,
    0xbfe5a4b61acdefb2, 0xbfe0507ef16fff60,
    0x3f8e3d1e5c25448d, 0x3fdf25449cad7077,
    0x3fe542d378c29044, 0x3fe103db04751739,
    0xbfa6697691a99b37, 0xbfdde53b7d6476ea,
    0xbfe960728ed3bdcc, 0xbfdc6c6ff71ab845,
    0x3f4821468acdc103, 0x3fe1310ba3bf4f05,
    0x3fe6035d293b01b6, 0x3fdf8bf609eeb504,
    0xbf9880f81a7ff899, 0xbfde74216140889b,
    0xbfe448cb343d8467, 0xbfe07a04ab0d27ed,
    0x3fb187705c576270, 0x3fe01960ea9d978d,
    0x3fe6123cd3244e20, 0x3fe0ce6922300e53,
    0x3faa74a96e78840d, 0xbfe1bfa6d7fde45d,
    0xbfe5356eb6d2cc45, 0xbfe638c9f80113e4,
    0x3f914247b8f8da54, 0x3fdefd56b168b322,
    0x3fe7f5dbf3839c8f, 0x3fe2e7f7211955e7,
    0x3fab20c5e3cf416a, 0xbfe022068321ca10,
    0xbfe95b4284a42399, 0xbfe077ded470e38a,
    0xbfa541e46638b93e, 0x3fde79b8f132f434,
    0x3fe46285255e303d, 0x3fde5152c76c4b72,
    0xbf871ba3beb7827c, 0xbfdc8beefd413e9b,
    0xbfe7456e8a4a51f3, 0xbfe19439f7edac6f,
    0x3f911bbc6ac2ef58, 0x3fdb6b1a385999a4,
    0x3fe797882c48d3e8, 0x3fe03b2d7e1f6f70,
    0xbfa48ca1f272fedd, 0xbfe353b632f7e362,
    0xbfe5899f3b698359, 0xbfe5403470c9671f,
    0x3f8a13f5fb780c17, 0x3fe078152ae1d01c,
    0x3fe793a812886a9e, 0x3fe00726081c6876,
    0xbfa913f4f97f0768, 0xbfde9c5e1b030de9,
    0xbfe77b3e39916aad, 0xbfdbcc3a2a8028f4,
    0xbf921efebefe4a57, 0x3fdb228bc5b1a556,
    0x3fe7e0f1f2e421f9, 0x3fddd37795dba614,
    0xbfa7c02af3c0840e, 0xbfdfdbc0ed04aa0e,
    0xbfeac4b7a46c5b34, 0xbfdcb8a5bcbdde6c,
    0xbf876a220b7a0283, 0x3fe16e67278f3969,
    0x3fe58d3301329725, 0x3fe2e4cb3cd95384,
    0x3f8573138e106589, 0xbfe107111462a9bd,
    0xbfe819af6b61785e, 0xbfdd2531fd357cc9,
    0x3fb0ffe99fb49705, 0x3fde8da81c7ddcae,
    0x3fe749fcf07d40b9, 0x3fdbe56e8673bd18,
    0x3f77c2aa30cf7d48, 0xbfdf78577711684a,
    0xbfe4a126097c1815, 0xbfddd57158560a38,
    0x3fa9817122355489, 0x3fe0cd27bcdaf53e,
    0x3fe31d6fd59ef60e, 0x3fe0060d7aad4e47,
    0xbf8973cf5b60536e, 0xbfe0f0f00d2820b9,
    0xbfe7fc7e8ef58282, 0xbfdf3bf23a3ae753,
    0xbf9a2c6bfb65dfd5, 0x3fe0ab7701bce176,
    0x3fe66487bb3d4715, 0x3fdaf03b9ebe46cc,
    0x3facf34061ca5b75, 0xbfde770352c6cbf5,
    0xbfe5a400c5e7f09b, 0xbfe12ab43064eea6,
    0xbfa8b17710170c35, 0x3fe00b0c147e6d08,
    0x3fe76a1cf7d8fec1, 0x3fde2d3e21d0cac0,
    0x3f69b70c398262be, 0xbfe1d76f416485d2,
    0xbfe68d6e46fb67ed, 0xbfe118584660a7e0,
    0xbf8911d55ae82fda, 0x3fdea4a34aaa9e1c,
    0x3fe6a1e568affd1a, 0x3fde7d200a04c16c,
    0x3f7a73fb3fc5765e, 0xbfdb76e2f28b44b7,
    0xbfe62ce36f084069, 0xbfe087921f0befcf,
    0xbfb2e4e4261639a2, 0x3fe188a8421d4863,
    0x3fe5ecef0008e177, 0x3fdc23a9a066b079,
    0x3f682474752c683a, 0xbfd91ef9926f249d,
    0xbfe46e64fb9d2891, 0xbfe05bef26ff2059,
    0x3f87284579c6aa45, 0x3fda5eef96b33f0e,
    0x3fe6f2c3e2b790ad, 0x3fe0930edceb387a,
    0x3fb4565c20d34077, 0xbfddbd16ac04dd50,
    0xbfe63b8c68cd8f08, 0xbfde8aea10cd0aa2,
    0xbfbd67a6e8c26c86, 0x3fdc6f9b3ca3e0d2,
    0x3fe887611daabd76, 0x3fdf3b58a56c97a1,
    0x3fb35c05b41b10a7, 0xbfe39d81f5e365a6,
    0xbfe60cfe395165f7, 0xbfdab022459e4a0c,
    0xbfa20c15b4e6cec3, 0x3fe0d9639aeb0736,
    0x3fe820daa7a63961, 0x3fdf5f04c87e8775,
    0xbf9c60e146cf00cb, 0xbfdb8f97ece63c9c,
    0xbfe657126cc09272, 0xbfe09e0726fc45dd,
    0x3fa77898917445ee, 0x3fe0b7dbcaed41ec,
    0x3fe60378b405e29a, 0x3fe25beb76e96329,
    0x3f80cb19b9a38d4c, 0xbfe0c7498de12405,
    0xbfea43f42cc0eea6, 0xbfe1fedcdf295392,
    0xbfa9256b6bed767c, 0x3fde641a548eabc2,
    0x3fe3b1bdfb79264e, 0x3fdfc951255f44cc,
    0xbf9c3773a17538cb, 0xbfda5cf23dfdea2a,
    0xbfe6160f7a4966c0, 0xbfd9fc14e3439de5,
    0x3f626d06060a0a54, 0x3fe05ae59b847fce,
    0x3fe9b18b57e23e74, 0x3fda07ecc6033a5e,
    0x3fb009731cfa271b, 0xbfe0662a8d37a097,
    0xbfe9ab10b307413a, 0xbfe21d6327d02c64,
    0x3f96a20235b42d30, 0x3fdf3f18f2903878,
    0x3fe42858b9a985a4, 0x3fe0a443b6aabee3,
    0x3f92812083c46db4, 0xbfe13e611dc9820d,
    0xbfe9a8695379a5a4, 0xbfdf78e8be62f003,
    0x3fa6b155b6637600, 0x3fe00b8b0e47d80d,
    0x3fe3defd9ea8434a, 0x3fddd705ff57abc3,
    0xbfa7e2fa0d2ca22d, 0xbfde777ae6407aa5,
    0xbfe6e18864d7abba, 0xbfdd34aa6c807fc8,
    0xbf5690023fb14af7, 0x3fdde5c5c2c5e432,
    0x3fe6f967d9aef510, 0x3fe0649d1ee5c394,
    0x3fae030a9be2041e, 0xbfe15cbe4a76a7ed,
    0xbfe603638e5fb1ea, 0xbfe065245ebb6eca,
    0x3fb2739c51d33f83, 0x3fdcde51a29e7411,
    0x3fe1e81fb1a91d9d, 0x3fe001d9f02edcba,
    0x3f9fbd0cdd178acd, 0xbfe2d13016021e35,
    0xbfe583c62354898e, 0xbfe1749b30b287de,
    0xbf91d578ef9dc828, 0x3fdc936971b3321e,
    0x3fe6106c8e4f9070, 0x3fe101efd03268b0,
    0xbfa46eb526f0f284, 0xbfe088731f666f07,
    0xbfe56f1b8886d676, 0xbfd89720f83a410a,
    0x3fb01b5c6ecfa118, 0x3fdc34080e59df53,
    0x3fe5e5720e13df5e, 0x3fdc24747b31e242,
    0x3f86d7b865763c9b, 0xbfddafa2aa45ee98,
    0xbfe817be1b91247e, 0xbfe05daf350be228,
    0x3fa1c36a38a0f7f5, 0x3fddf8e17e360528,
    0x3fe6c71f696d3959, 0x3fdbb3211bb8a8bc,
    0xbf99bf974f570aed, 0xbfd98edc66e5c6dc,
    0xbfe7168edbb03a71, 0xbfdf119bdc89d6cd,
    0x3f817bea68764d4c, 0x3fe1c23c0cd5bb45,
    0x3fe4b354c1d5150d, 0x3fd9f8e3dd6210ed,
    0x3f4cc93bcdf9bd23, 0xbfe0175cf2c409cd,
    0xbfe84067d4a33a7a, 0xbfe098a05750d14e,
    0x3fb3c908f8630396, 0x3fdb7a3809274400,
    0x3fe69bc37550b7ba, 0x3fdfc0ac8a897576,
    0xbfa490a91145942a, 0xbfe0cb0956fcbbdd,
    0xbfe65807aa2a0e24, 0xbfe2b7f4a3b965a0,
    0xbf73371cfbc9aa2c, 0x3fe036dbe33c3775,
    0x3fe7bb05e2d61e74, 0x3fe1fd0dfd29176d,
    0x3f9b92a2f14bd499, 0xbfe09b84b8ecd889,
    0xbfe5a4f5e64faf19, 0xbfde94978474414c,
    0x3fb4f0f23d7323fb, 0x3fddfbc632753b46,
    0x3fe7a42a6416e77d, 0x3fdc1c82b282db15,
    0x3fac425cb711ddf1, 0xbfe05e545d1c0cd6,
    0xbfe3fbdebecf2c14, 0xbfdd4e4d1b03d5aa,
    0x3f9532f144968d08, 0x3fdde5a346651192,
    0x3fe7c0436d9e70b8, 0x3fe08e58cd09a948,
    0x3fb63e4e4c43096e, 0xbfd69ef88ba0b6c0,
    0xbfe7982bbec7cf41, 0xbfdd1d6cb0317197,
    0x3f94296ee749800e, 0x3fe269d3e9b11dd7,
    0x3fe721581685fd56, 0x3fdea2f109e5c034,
    0xbf6363d9605a1586, 0xbfe24ce229f5a906,
    0xbfe96e81c28b7906, 0xbfe053074417d598,
    0xbf8d3d050d45d821, 0x3fe0bc8dcb8d9411,
    0x3fe4afc77bb77dbd, 0x3fdeea5e7a9a8e16,
    0xbfa4be2d06fe7c73, 0xbfe059878499df6f,
    0xbfe3483aa812d736, 0xbfdbe2fda74e777c,
    0xbf99d593ee7b43d2, 0x3fe44416eeb1d7d6,
    0x3fe6e21a88eb232e, 0x3fdbaee2582692d1,
    0xbfbaf0bd48acd15a, 0xbfe39a10b68090e5,
    0xbfe6f23199c2a144, 0xbfdb59ed6d5dc9b7,
    0xbfa9653a65a95fcd, 0x3fdedca19199b986,
    0x3fe5b7ea6bdb51e1, 0x3fe04e5d8e3f383c,
    0x3fb6f029a5d9d8a9, 0xbfd9daaab75dcba0,
    0xbfe677f240c1e403, 0xbfe1adf98612eebe,
    0x3f956ed716d1b412, 0x3fdd5984d2067c30,
    0x3fe6f2a5cd7f567d, 0x3fda1c5d7779cf26,
    0xbfb3c4bbc25ce750, 0xbfe0d6e9e207b8e6,
    0xbfe3dd598197b8d9, 0xbfe1ebf9b76ea916,
    0xbf9bddc643868443, 0x3fdea9d26cf3cfae,
    0x3fe82ffdfe0e7c56, 0x3fdd2978556362c2,
    0x3fa6d6d459c19436, 0xbfdfb3b62bddbd92,
    0xbfe86cf166890e91, 0xbfe1dc5c7956d8f7,
    0xbf9f2cd2a5fbea8b, 0x3fe087a85a5edfa7,
    0x3fe5dd2e7ad0cfc5, 0x3fdc7b634a60aede,
    0xbfab503140a0f027, 0xbfe0a99c56371844,
    0xbfe6bfba5ea72f06, 0xbfe2a93143adb2ac,
    0xbfa6c02645009e47, 0x3fde57a821e9162b,
    0x3fe687f0974cd172, 0x3fddccefd21da574,
    0x3fa0f44a3421f0a8, 0xbfe0de94518fc2d8,
    0xbfe5e3a8755b5f40, 0xbfdff5b8983755a0,
    0xbf9a5127a4ff8b34, 0x3fdf05c4b9a3aca6,
    0x3fe53884fccac447, 0x3fdb96cb70546440,
    0xbf9705e8e7c4c794, 0xbfe21b707e7fec1d,
    0xbfe565f99309f4ae, 0xbfe14aa1c6295fea,
    0xbf8df7c56c6e6a9a, 0x3fe10b597efe355b,
    0x3fe6df93b5df6f5c, 0x3fde5f25a35ce5b0,
    0x3fb003e709e8d99b, 0xbfe1804e43cacb28,
    0xbfe77c20a01dfa04, 0xbfe05a8a18e5f385,
    0xbfb082faed9087f4, 0x3fe0b3691741bd00,
    0x3fe7068b9d09dcf9, 0x3fe3da05a43b0c8a,
    0x3fa9c1a340872ab6, 0xbfe0418ae0cc268f,
    0xbfe4765e924be1f1, 0xbfd838b17d24c54a,
    0xbf9104c95c17e989, 0x3fe108d242a5f3ab,
    0x3fe83e0d273ebfba, 0x3fe2ee5be08f8498,
    0xbf8ba8691a24f4da, 0xbfd7b10aa0af82be,
    0xbfe9ae0b80d56a16, 0xbfdd596d04e03667,
    0xbf91e6b9c3c9eead, 0x3fdcdd67caca7596,
    0x3fe7b1aeb8989d69, 0x3fe0734d81e816f5,
    0x3fae93a9d123cf37, 0xbfe0a013fa0a5a50,
    0xbfe5b401e3c9db5c, 0xbfdfc53c021ce1ba,
    0xbfaef0238a873ece, 0x3fe1d5eac5b62d78,
    0x3fe487f7c6e2e51d, 0x3fded074c2097626,
    0xbfa52d1c0337e39c, 0xbfe0be704dc8aa61,
    0xbfe7d7d9b07c61b0, 0xbfe106c91956f81b,
    0xbfa47857e3721ae5, 0x3fe1c35e9c334710,
    0x3fe571b08c539a8d, 0x3fdc61c22e352660,
    0xbf977708e0e20da1, 0xbfe22a6f61b867d3,
    0xbfe549048f02f6c4, 0xbfe05d6a43f85cdb,
    0x3f96be65d4e781de, 0x3fe073fd7ea6a659,
    0x3fe450fcdc8bc606, 0x3fe13f6653796525,
    0x3fa81fb8d0066c35, 0xbfdd610ddfa055f8,
    0xbfe5b687288b2a4a, 0xbfd8a7e6970ca266,
    0xbfafa6777d600dfd, 0x3fe150fc787b1b86,
    0x3fe6043ecc075853, 0x3fe12aaa865c22e0,
    0x3fa42129d955cd5f, 0xbfe0e97f24e8269f,
    0xbfe6db0609661a54, 0xbfe085eda73154e7,
    0x3fbdeb9590d445b5, 0x3fde2548f841ed8a,
    0x3fe6ec0db4bfb14d, 0x3fdb430ff0a1f6f8,
    0xbfa3aae4d00135cd, 0xbfddb88980fe9f76,
    0xbfe92b0c5c01dc95, 0xbfdd15af77be189b,
    0xbfb0467c35ae66d2, 0x3fe0d6f1d11b251d,
    0x3fe43aacfee30a10, 0x3fd9d096b2258539,
    0x3fb6577a66f38dad, 0xbfe2ab9d404acf9c,
    0xbfe7f1d4c53d5f28, 0xbfe090eabb3d682a,
    0xbf9ce42a3586aa22, 0x3fddccad521c7e1c,
    0x3fe3eb0e2b3a99e8, 0x3fddd0ba519addc6,
    0x3f84c5e3e93b1245, 0xbfe2805a3d8c3c60,
    0xbfe4a277acb1ac15, 0xbfda8078801a3733,
    0xbfa2cceb8f836c7c, 0x3fddaf9656951791,
    0x3fe5ca8aebd8f69a, 0x3fd99c8f47f670dc,
    0x3faedbcf4e20434f, 0xbfe009925053baf5,
    0xbfe60c218cb0bbc4, 0xbfe00e43b8500e4f,
    0x3f75bce1e27cc5f7, 0x3fde5f99b6d20638,
    0x3fe66511926fc5d2, 0x3fe0b2416c9e1d64,
    0xbfb0df40718d41ff, 0xbfdf5b6f3bc484e1,
    0xbfe6b8d2c63a6768, 0xbfe0338ab554b876,
    0x3f6129843893d239, 0x3fe193934af0e5a7,
    0x3fe2228a6dddcedd, 0x3fe00929397a3e5f,
    0x3facb0c32f29ded7, 0xbfe13a6c153446c8,
    0xbfe5cc389db2d21e, 0xbfe1e96fe17978e5,
    0xbfa6be7931f11baf, 0x3fe26cb4693c49cd,
    0x3fe64a49020c4a9f, 0x3fe0e1f6f48e5566,
    0xbfb27b327449693e, 0xbfe0acc8481be655,
    0xbfe5836fdc230886, 0xbfe03a70f4c1299e,
    0x3faf55fec56d9e6f, 0x3fdd9108a149d460,
    0x3fe59d879a557516, 0x3fdc759f79ea2151,
    0xbf876923158b54fa, 0xbfe0b32f48c6c94e,
    0xbfe5cda527424e30, 0xbfdbbea91c07a68d,
    0xbf943274408cdeec, 0x3fe01463360cc677,
    0x3fe5b4960a501eab, 0x3fdd3fe21b06b46b,
    0xbf901980299ee6e9, 0xbfe0172c30c4de72,
    0xbfe631007ee613bf, 0xbfe039c2803e96db,
    0xbfae904484b0f92f, 0x3fe0ce8e42968510,
    0x3fe98f973a4ae9dd, 0x3fdfdaafc1d559c5,
    0x3f914a25aa0e2da3, 0xbfe047d9b5e9e657,
    0xbfe7122f37fe7fb1, 0xbfdfcc65dd35f97f,
    0xbf9e1b666ce2fafd, 0x3fe046a67649bd70,
    0x3fe976f23aa7ac4f, 0x3fdbf26e58dc5c62,
    0xbf905539314fd7da, 0xbfe067b19aa59ea2,
    0xbfe78ac4c1ddb23d, 0xbfe23c92caeaf2ab,
    0xbfa69dbdc8a02f83, 0x3fe0678f4453eab2,
    0x3fe5b4684a155273, 0x3fdb6029839558f4,
    0x3f962433bfdbcee4, 0xbfdbd5952f7135cc,
    0xbfe5314e7295ffb6, 0xbfe00a99b8270f79,
    0xbf85a6159ea7162d, 0x3fe24710612fa88a,
    0x3fe3230895d0195a, 0x3fdeeed7aecbdaf4,
    0x3f9a4c7271941514, 0xbfe0ee743077f334,
    0xbfe69f62f82b41e9, 0xbfe25b2a144b2a72,
    0xbfa185fc56a72f3e, 0x3fe03029d82f6e4c,
    0x3fe3fddc8682f295, 0x3fdfb73e3125a1af,
    0xbf95e9646e43e8ab, 0xbfdf090701924e09,
    0xbfe568e1cc192e7b, 0xbfdb59953d9b28d0,
    0xbfa0aba2bcf677b2, 0x3fdf4f78716acc68,
    0x3fe681a9b6d6bb66, 0x3fe05c8840e39011,
    0xbf972e22979465a2, 0xbfe040614f3a6ae4,
    0xbfe67763f7c0834a, 0xbfe25925a436e8a6,
    0x3f8663d19f222df8, 0x3fe1db99403954bd,
    0x3fe54a0a0d294e0d, 0x3fdbd58e881583ac,
    0xbfb9944a15ca89b9, 0xbfdff9e32780c615,
    0xbfe70ae764c75d9f, 0xbfdecddc8f9823c3,
    0xbfaaa016aec55d53, 0x3fe0440417a27829,
    0x3fe734e6b1b28dec, 0x3fdb2c6232de636f,
    0x3fa580ccf13e4935, 0xbfe1865fc2125d20,
    0xbfe66874683bcac1, 0xbfe0488aec65ccec,
    0x3f8c2f9dca4dc226, 0x3fdf2f39e9920612,
    0x3fe69557ff2b6858, 0x3fe1cec76b245e8f,
    0x3fab8fb28f69e2a8, 0xbfe344809bdc490d,
    0xbfe647de077faddd, 0xbfdd5ecb5d4b624b,
    0x3fc26d96e580713d, 0x3fdfc5e889ec85ef,
    0x3fe7fdecc0ead229, 0x3fe39c940a018b24,
    0x3fab1850e37459ad, 0xbfdb84753f8722a4,
    0xbfe83ca6f32d4581, 0xbfd9e260b4fb68d5,
    0xbfb605d87e39668b, 0x3fdd7b74fab16d7c,
    0x3fe8203b6bf40b48, 0x3fe02d2bb8a930c3,
    0x3f9c511af7ad80f3, 0xbfe2458264a77f1c,
    0xbfe44b58a5552013, 0xbfdba525d3623daa,
    0x3f9b05fa865e6688, 0x3fdc274e87c4a5ab,
    0x3fe6247792951c83, 0x3fdf8590e9100b48,
    0x3f717ead45f79b66, 0xbfe0e463f1545962,
    0xbfe62dbece28d90d, 0xbfde3d891b79f13d,
    0x3fa9c9308a151314, 0x3fdcb1b91419a958,
    0x3fe70f0033f3cb9e, 0x3fdfaf5bb893f9cf,
    0xbf960ddb5e780b21, 0xbfdd005e201479dd,
    0xbfe88e9dbc41198e, 0xbfd965c0a790d29e,
    0x3f944866e2e28ba6, 0x3fdd539d61767e87,
    0x3fe785f9d29c906a, 0x3fdf1e407b68a4bc,
    0x3f9dc2ebce2b03ed, 0xbfdf1a8bc62df14f,
    0xbfe8b42a0c13b167, 0xbfe11cf651e53f2d,
    0xbfa496de2e3649b7, 0x3fdee83d3d9d93ad,
    0x3fe5795d4da62c00, 0x3fe446a10c1f67a4,
    0x3f6f44d07446a261, 0xbfde1f401decf4dc,
    0xbfe64edb772e2be3, 0xbfde4c8a8c1c8d44,
    0x3fa2f7e1f8598f3a, 0x3fe0c60d46fa1d2e,
    0x3fe716b53a2cd276, 0x3fdcb87948f4cd47,
    0xbf99dc1ce5b581c8, 0xbfde7f65f2852c36,
    0xbfe5459750a047ed, 0xbfde17bea017cdf5,
    0x3fa45c27dbef4e33, 0x3fe05d6d407ade54,
    0x3fe5651e6fe3a91b, 0x3fe2a18f1b5231d0,
    0x3f92960bed221930, 0xbfdee664a6d3b012,
    0xbfe5eae174a48a4e, 0xbfe3d65b23f80faf,
    0xbfa00b32b98c08b1, 0x3fe15528f57215db,
    0x3fea155f762c5809, 0x3fdfeea1fe1efbc4,
    0x3f83b63d89732cc2, 0xbfe04bfaf6896913,
    0xbfe5c58e0f418819, 0xbfdf8c6798ba710c,
    0x3fb41521285b8054, 0x3fdc3f27fde9647c,
    0x3fe6b31153ad5ac0, 0x3fdb98c57a41269d,
    0x3f938d2f07ac886b, 0xbfe4004f358b6e77,
    0xbfe78fea6b1f4cf2, 0xbfe10e5d6c23ec36,
    0x3f96b08765227b4a, 0x3fd908130c3cc882,
    0x3fe545dc1e6a24f2, 0x3fe05901e610e922,
    0x3f998a08186b2682, 0xbfdf79711b0d1a7e,
    0xbfe75f1a8b00513e, 0xbfdb0cc8f281211b,
    0xbfa9489fdb32e0a5, 0x3fdee29bdf92eb37,
    0x3fe6f618a7af0ab0, 0x3fe0cd8bb36676b5,
    0x3f6513844d6aacb9, 0xbfdcc64d600f8be7,
    0xbfe549fa552cd157, 0xbfdcafde8a2281f3,
    0x3fa052a9c7e76d5e, 0x3fe0f7f0f2143b8d,
    0x3fe759eb61775c3e, 0x3fdbd54b7d773758,
    0x3fab2c42113656ff, 0xbfe24a0b25e4f3aa,
    0xbfe6678614caa3f0, 0xbfe21552f28503b7,
    0x3fa215632b9195a4, 0x3fe0c5b6d807d666,
    0x3fe60397ebd9bfb6, 0x3fdfa7647d19f8ce,
    0x3faac1a217fc4668, 0xbfddfdc3ac8b70bb,
    0xbfe773cb570856f6, 0xbfe20a72d7dd2848,
    0x3f7db1b2f099bef2, 0x3fe03b3552b6c256,
    0x3fe50daa316995c3, 0x3fdb549fcd1383a6,
    0xbfb091f8043da4fe, 0xbfe051f33fa533e5,
    0xbfe82ed5a80ef97f, 0xbfe026ed34d0412e,
    0xbf64d0a9f0c2f34c, 0x3fe12b46a519dde2,
    0x3fe67a1a5d38c3be, 0x3fe06c4fc3474b3a,
    0x3f8f95f59dae1b67, 0xbfdd01ce465fd156,
    0xbfe4b89d4262fbbe, 0xbfdae6878fb0dcad,
    0xbfafba95d9f9f451, 0x3fe0deb0459153be,
    0x3fe4ceecd715a13c, 0x3fdcaed01ba84bd1,
    0xbf939a0e24fc098e, 0xbfe1e0f617833f1f,
    0xbfe94954b0b62b32, 0xbfdab44919dd5d83,
    0xbf84e45c05893624, 0x3fdb007b8b028480,
    0x3fe6bb11bee5e5f8, 0x3fde8ee978aac947,
    0x3f9cc4af35bf3e42, 0xbfe0c07e90e74615,
    0xbfe565c0c665a3f1, 0xbfdf88bde525bdda,
    0xbfa1ac5651fba5f2, 0x3fe1bddb4c25b423,
    0x3fe566656e29ddc4, 0x3fdc3707785ed571,
    0xbf955244b4e5513f, 0xbfdeb5d5f8dbe1c7,
    0xbfe43c3057c0ae82, 0xbfe2c4572e150e4c,
    0xbfa093f878cc900f, 0x3fde30cbce2a0de8,
    0x3fe4f565e0abc170, 0x3fe095e3b43e3667,
    0xbfbd68a9fb853d74, 0xbfde9ae7d6fcf358,
    0xbfe51e5883aff280, 0xbfdc297f88e68da7,
    0x3f60f8cb7a4a0004, 0x3fdcc9e2a8f0b023,
    0x3fe61f193d831d40, 0x3fde06a997782177,
    0x3f9b76184f556e5a, 0xbfdd4c8e0be197e7,
    0xbfe673d8b9a14b8a, 0xbfe0e5e5d0d481be,
    0x3faf755261bf09d7, 0x3fe07cea620d293e,
    0x3fe3eb012353d042, 0x3fe0f1215a8d684a,
    0xbfa462b0e9e89e90, 0xbfdad65b901264e4,
    0xbfe5d9e1a6bf399c, 0xbfe0d38da5b25a33,
    0xbfa60d4c2939e3a1, 0x3fe06462e40f4c9c,
    0x3fe64a333da56a9e, 0x3fe11635582a3b4f,
    0x3f905385410e5cf2, 0xbfe1e67f65e78dbd,
    0xbfe5f7e0b1b76281, 0xbfe07a59214bd8ad,
    0x3fafff40202e5d1e, 0x3fdf5901554e61d9,
    0x3fe6af7dc32d5697, 0x3fd9fbb50f00b990,
    0xbfacc2fb7cf0c99a, 0xbfdfecc29dd30533,
    0xbfe3d023e6d46ec5, 0xbfda3b117c48fa0a,
    0x3fab037596b1ff1c, 0x3fe1329f2a3eaae7,
    0x3fe8b8116da0a150, 0x3fe05901086fd842,
    0xbfa658f91955b6ba, 0xbfdf84ca41b50b85,
    0xbfe2948734623ac1, 0xbfddf27f5c8069bc,
    0x3f9b4c67dda10640, 0x3fdba74f1a3d47c9,
    0x3fe83eb2f1a443bf, 0x3fdf373cb094dea0,
    0x3f4cda4e213102b7, 0xbfdbb6d8bd054081,
    0xbfe9013ee52f3928, 0xbfe0f3bd856971a6,
    0x3f4ca2e085ca347b, 0x3fdec920d2558223,
    0x3fe5948588ae7f09, 0x3fe171ea133ab0cc,
    0x3fb016784863642d, 0xbfdf96308a1ff4f6,
    0xbfe6706e8b2d4223, 0xbfe0e6056dc7eb31,
    0x3f8de82e4f363f84, 0x3fddf4cda4488bca,
    0x3fe6703b0bbfcc7d, 0x3fe040fefe7a763f,
    0x3f9aedc46e0848b8, 0xbfe467cf079a9ae2,
    0xbfe4a466cba1dca2, 0xbfddfe62172fb944,
    0x3faf44b65ddb4bac, 0x3fdfd9ee53ae1609,
    0x3fe5bfd1d9bf88e4, 0x3fe19237b42cefb7,
    0x3fb0ff7e82fa370e, 0xbfe06742127d929c,
    0xbfe64982c9ac445e, 0xbfdcb896ab534a3b,
    0x3fa9f5b62ab6fd6c, 0x3fdeb6c4aac9db7d,
    0x3fe426a9e7545fc5, 0x3fe04c38883f1eb2,
    0x3f9fd982bfec1a39, 0xbfde7b07737a1111,
    0xbfe807b2fdec39ac, 0xbfe28eae61ee26b5,
    0x3fa8768a5a8b07a0, 0x3fd99bb9225960a2,
    0x3fe65b340f9f7a1b, 0x3fe194807cec0776,
    0x3fac838ce77028cf, 0xbfe153c2c60f83fa,
    0xbfe5a95ba3f83d24, 0xbfe2b3210362fa96,
    0x3fa31d20a2391400, 0x3fdc35f19bfe3986,
    0x3fe5a34e5bbb9323, 0x3fdd11983837cde5,
    0xbf79c93dc936d542, 0xbfe0e5314ebed12d,
    0xbfe4260be03cf560, 0xbfdb446fcc644299,
    0x3fa097fd93efaa7f, 0x3fe0dc5e995cdc56,
    0x3fe7a538b3d10b45, 0x3fdb50a4f72c36e3,
    0xbfa2d83523eb96d8, 0xbfe24497c2150ef9,
    0xbfe5ac024886dc97, 0xbfe0247be37bcec5,
    0x3fbaaa0b791d6d3c, 0x3fe007d994aab78e,
    0x3fea7196b7c13cd9, 0x3fddb69fa331ece8,
    0xbfacd4f399c429c4, 0xbfe340dc24ca9282,
    0xbfe87581d5239f00, 0xbfe02acbe4abc7b6,
    0x3f7403f232c89b4a, 0x3fde96afe9b47f97,
    0x3fe8defd235da766, 0x3fdeb81b32285c47,
    0xbf773a23e309813b, 0xbfdf4310f67ad38e,
    0xbfe869cd690e26e5, 0xbfe0d5eafc0ab004,
    0xbfb8900da5213cec, 0x3fdf8d55579949c8,
    0x3fe831618bf6661b, 0x3fe3e57f270e5601,
    0xbfade32ef40b4335, 0xbfe16b6fee2143fa,
    0xbfe8671627c4584a, 0xbfe08208c37e83e5,
    0xbf9b55c0f59b4197, 0x3fe03e8fdf34c6d3,
    0x3fe69d94c3a34627, 0x3fe0cbe1ad997f82,
    0xbfa11685dd5ac852, 0xbfdb702384af58b3,
    0xbfe9a351c8218aa2, 0xbfde26e2a04b2aeb,
    0xbf6c8d66fc81880a, 0x3fe021696b39aa0f,
    0x3fe8a5ac1de8ad59, 0x3fdf03a4f31d9a0c,
    0x3fafd1364d31a71a, 0xbfe1523dea60714f,
    0xbfe8d985c531fe4a, 0xbfe143cfdbb9995c,
    0x3fadcaa026c666b8, 0x3fdd9694fdbe5e2b,
    0x3fea666b1c530130, 0x3fe12f427724386e,
    0x3f74992f3375a822, 0xbfdf5ce6c8912641,
    0xbfe5d7218a652214, 0xbfdb5dacc47d01a0,
    0x3faddb33cef7e42d, 0x3fe0df299d3fcdcd,
    0x3fe6376f3bef8bb5, 0x3fe11d28e1dd5ca3,
    0x3fb6baba3ada9c0b, 0xbfdc49bdbf64c436,
    0xbfe7a5eb435e4ef6, 0xbfdd341a77cdd1fa,
    0x3f993193589006a2, 0x3fe1652c5a33e7cf,
    0x3fe7b5d36acd2813, 0x3fdffd7740dda93d,
    0xbfa2bacdc76dd9aa, 0xbfd9bee43c55b440,
    0xbfe485775b0adec4, 0xbfe1758f282fb22c,
    0x3fb7e95e57598d66, 0x3fe1a2e448587205,
    0x3fe77ef5679b8f22, 0x3fde68553ff6f8cb,
    0x3fa66f30a07a2725, 0xbfe1f967799beb06,
    0xbfe5457a00110b54, 0xbfe15c3478ad1336,
    0x3fb2734b22830b2e, 0x3fe1e1568fb78eac,
    0x3fe89e7a23cc9329, 0x3fdf11efbee9957c,
    0xbfa5f322a820eb75, 0xbfe246234c2cad45,
    0xbfe10531d81ee7d0, 0xbfe0a70a0a23b7ca,
    0xbfbecb86d4ccefb5, 0x3fddd31d5974f8d2,
    0x3fe6514b8eb926b3, 0x3fde4eccace87df3,
    0x3fb4396c5dce9531, 0xbfd6d0aa9614c427,
    0xbfe51f3e11106577, 0xbfe048dba770d0dc,
    0xbf9b9e37014ca005, 0x3fe0958fa98c6e57,
    0x3fe59e658242852a, 0x3fdefa38a902880f,
    0x3fa4dd17fbc6a174, 0xbfe36811518b6309,
    0xbfe69d6b905c3cbe, 0xbfe1689a09051986,
    0x3f95696aa98f7efd, 0x3fe099a639c0e7aa,
    0x3fe86c820327a4ee, 0x3fdfb35314a20979,
    0x3fa8ded222e7348b, 0xbfda8a81b42e084d,
    0xbfe6855963fd70b1, 0xbfdd7e66413af19d,
    0x3f836a85bc8d9d02, 0x3fe09fca473b0642,
    0x3fe68d47e64c822c, 0x3fe0ec39b0383cf4,
    0xbfa5eb908e5d47fa, 0xbfe0af18c08d148c,
    0xbfe4f0a3394a7a03, 0xbfe22cc9cdafe4f3,
    0x3fa65622acc6a7be, 0x3fe04304a456c753,
    0x3fe8e35248676478, 0x3fe0786bf8f41dab,
    0xbfb43963b32faca0, 0xbfdaf9dc3a3d2e6c,
    0xbfead62c2dceb296, 0xbfe03039b3f7d6b7,
    0xbf8e65a59b88b9a6, 0x3fdc169cbb9f4d98,
    0x3fe6594b93ef088e, 0x3fe13be8a6d2eb8d,
    0xbf6564c78deb85ee, 0xbfdce35c81ed5f57,
    0xbfe27f582f63b976, 0xbfdb02486eaa18d9,
    0xbfaaedc8b8ea785e, 0x3fe07dace1451d72,
    0x3fe74884857f2937, 0x3fe191eca7b44696,
    0x3fa7bfbcd1066465, 0xbfe1f97255f4c1b4,
    0xbfe59540f2facc52, 0xbfe1e0382229c855,
    0xbfb02edbe06c975d, 0x3fe0d5a1be3b51b7,
    0x3fe6e4b49ccfe9b5, 0x3fdc8953ffd29739,
    0x3f88c3223c18c415, 0xbfdcf84c3186a96b,
    0xbfe5f15a52f72195, 0xbfdca85ce0642275,
    0xbf9b808ed81ae2ac, 0x3fe10374a94eb57e,
    0x3fe85e3dc83ddd0d, 0x3fe3a29275df708d,
    0x3f99223c817243c5, 0xbfe067bcb0c92b2b,
    0xbfe7bbb69ac5dd2f, 0xbfd85dfeaaa38ad9,
    0xbf81629979869e08, 0x3fdfd91c02bd2f44,
    0x3fe4a9c46b712087, 0x3fdfe123bd321693,
    0x3f734a32335e1d73, 0xbfdf8d4c85750bee,
    0xbfe61d7f94822c05, 0xbfdebb33c3ecbe00,
    0xbf86c7a3fcfad160, 0x3fe06c73e08566a3,
    0x3fe86a0d990438b2, 0x3fe0fc3497f064a6,
    0xbfa78a68e26b6f9b, 0xbfdf5d2d6f5e01ef,
    0xbfe4f2429c2193aa, 0xbfe20ffd4ab4f180,
    0x3f75e95f6655392f, 0x3fdf28f109f187a3,
    0x3fe64a67eef7a6c1, 0x3fd994a22e425e6c,
    0x3f72e98d463d3967, 0xbfdcc9899d6f6998,
    0xbfe6a4f8f4e03fc5, 0xbfe04d6e4a352a43,
    0xbfa32c686db41f08, 0x3fdf78427dd8bc46,
    0x3fe805102d450ae8, 0x3fdc0c95a00b737a,
    0xbf978eb60ba6365f, 0xbfe150035ba59584,
    0xbfe6d61bd333f395, 0xbfdbb9225866ba78,
    0x3f8cb8c357f85ddc, 0x3fe0da2c056c068b,
    0x3fe660d30f0223f5, 0x3fe1669c78fd6bf8,
    0xbf9f3f102eb05e0e, 0xbfde1afdc7012dc6,
    0xbfe4f53b86235832, 0xbfe1d278e586db9f,
    0x3f96a985eaedf9b8, 0x3fe02467b213a84a,
    0x3fe83e1879c38f3e, 0x3fddc4bdafa6e9aa,
    0xbfbbad4dc5f78fee, 0xbfdd028e371fa68a,
    0xbfe91d889855f0aa, 0xbfdec506e2d0bc13,
    0xbf94dc2f1cf486f2, 0x3fdfb43a3c40b392,
    0x3fe99a37a2840ce5, 0x3fdf285bacd4430c,
    0xbf9ffb34b4db0d5d, 0xbfe10c3381a02570,
    0xbfe5561af96842a9, 0xbfd997afd469cf8e,
    0x3f8a7c4db08a3268, 0x3fde571f1e527266,
    0x3fe68936bacc03b7, 0x3fe0b114a61be263,
    0xbf9a9f8bb1e61299, 0xbfde52fc389b13b7,
    0xbfe71bdbe0bdb706, 0xbfe21e42e8c0f256,
    0x3fa7d6dc92521e7a, 0x3fe333d2edac0b16,
    0x3fe608255bde4990, 0x3fe2117363edb85e,
    0xbf94f7803a65b13a, 0xbfe23c62c1fc8b3a,
    0xbfe566a104220165, 0xbfdcb05342b70494,
    0xbf733b43a462437b, 0x3fdde8155d8c9003,
    0x3fe6274d625f2d8b, 0x3fdd15d2d209197a,
    0x3faee02cd3921d97, 0xbfdd5b1bc32bcc43,
    0xbfe6fe4577a11467, 0xbfdb4277adb59172,
    0x3fb58eacaa6c8981, 0x3fdedc386f4005f6,
    0x3fe6f4c8fa63fd67, 0x3fe1edb4ee3bfc70,
    0xbf91d1dd9b9902c4, 0xbfdafe180cdc340a,
    0xbfe7bd1b937a38cf, 0xbfde33d99b0f79fa,
    0xbf625dd7e1a1ad41, 0x3fe15d9f3af80854,
    0x3fe71bbfec0a3865, 0x3fdc766e305ac290,
    0x3fc011658484147c, 0xbfdeb9f5c0fc264c,
    0xbfe6e2eccae629c0, 0xbfdede9f03b7f574,
    0x3fb0dae80fa7ab69, 0x3fe0629a544dbcb0,
    0x3fe776fb28f2d925, 0x3fd97ff5b01e33d3,
    0xbf99ed5ec2340d29, 0xbfe0b12e53fffe5d,
    0xbfe5b015f8ac17f8, 0xbfdeb845513a16a3,
    0x3fa1e7342c85796b, 0x3fe181779e7d7401,
    0x3fe363cee07d0670, 0x3fdfe7cd76904764,
    0x3fb1a018ad7eef40, 0xbfde379f2b14fb41,
    0xbfe5160fcbc731bf, 0xbfdf6555d82a6a28,
    0xbfb7c5b58629a303, 0x3fe0d145036df3c7,
    0x3fe1e6e797504d9e, 0x3fe097f0d3ced795,
    0x3fadbc6163f77eb1, 0xbfdc727ca124b6af,
    0xbfe5da5991f19269, 0xbfdbd62ba3bf3ff4,
    0x3fc069a33f92b03b, 0x3fde468f36ccf606,
    0x3fe5750bc3f4372e, 0x3fda0e6e5ed95b95,
    0xbfa39758a3d98343, 0xbfe01f9ff75c7a4e,
    0xbfe67903d09d696e, 0xbfdfeab62e3fc76c,
    0xbfacfef8b93bb4c0, 0x3fe2669b02676d85,
    0x3fe7e51818a67207, 0x3fde89232b4bc782,
    0x3f26dfe8d583591a, 0xbfdf9cc4e6288bb7,
    0xbfe749c9ced5307b, 0xbfdd37a2822b84b5,
    0xbfb738a29667990e, 0x3fddf8057b567746,
    0x3fe7165b62552e5c, 0x3fda41870f1356fc,
    0x3f963e7337b182ec, 0xbfdcc1d282fc9004,
    0xbfe7b2fe7e48d598, 0xbfdb43929236a19b,
    0x3f394f423040dee7, 0x3fe0f16a41fe261c,
    0x3fe51c232446c9e3, 0x3fd974b7f70eb1e7,
    0xbf78e67e0baffda3, 0xbfdad35171a247ed,
    0xbfe7f4db5fc0b57f, 0xbfdf5acc3baa3fab,
    0xbf9eb93f041f5b95, 0x3fdcf926352338c0,
    0x3fe87aef99c45716, 0x3fe048514fe5256d,
    0xbf85bf53b2d53b70, 0xbfdf07eff9f1e257,
    0xbfe81cae46594578, 0xbfd6f800968f8667,
    0x3f7be1cc863098dd, 0x3fe0552f6453c2af,
    0x3fe4508676195b65, 0x3fdecbc089d30712,
    0xbfa66c34b76b953f, 0xbfdd46c64243a21a,
    0xbfe586ce4189eed2, 0xbfe121a20924bf87,
    0x3fb38b197b57a718, 0x3fdd6e988a3e1a52,
    0x3fe795c10ba528a7, 0x3fe02a41dabebce9,
    0xbfc1281f8b3ef3e8, 0xbfd9f3453798ca82,
    0xbfe6bfdc5658b4fb, 0xbfdd504893a17611,
    0xbf95c0518e8fb751, 0x3fe1505f041e4f66,
    0x3fe6ac4b8fe72a39, 0x3fdde4f818d9b00d,
    0x3f9422e8bd8cbaa5, 0xbfe1e7bd3d969797,
    0xbfe7c254a4011cad, 0xbfdc825e2658a6a3,
    0x3fa75371512ad1a0, 0x3fe08d41dee44425,
    0x3fe8dd7aac020b76, 0x3fdf735f402ce663,
    0xbfa9f05bda0a06af, 0xbfd921aac4378edc,
    0xbfe458e1dc6c008e, 0xbfe2ae2c028daf62,
    0x3fb32080f6bdd4c3, 0x3fe125a3cda034b1,
    0x3fe6efd9120526ca, 0x3fe05ae78ad0105e,
    0x3fb052f7225bafc4, 0xbfdb373d16dd0e69,
    0xbfe534acf0438bc3, 0xbfd91d8497e84c2c,
    0x3f92d997f84988c6, 0x3fdeff208b8a44fb,
    0x3fe63984972afa69, 0x3fddd4fb480311ea,
    0xbfb3530c71d29115, 0xbfd962c416309dfd,
    0xbfe6b45ee8900436, 0xbfe1202ea07e07a3,
    0x3faf59173617abc7, 0x3fe1b64334ba6e28,
    0x3fe308fdb7fbce3a, 0x3fdd564f6c942315,
    0x3fa68f71f11f811c, 0xbfdb06e9db9c7cec,
    0xbfe62f009c62d940, 0xbfde337970ef99e8,
    0x3fa898d19374e163, 0x3fdd27498baf1b49,
    0x3fe804190918173d, 0x3fde33dc6248f7fe,
    0xbf9fb68a099d3534, 0xbfe07788455a8dd2,
    0xbfe50312b3bee085, 0xbfe01eca7ddbf569,
    0x3f81d582ffa853c1, 0x3fe2138590d606fe,
    0x3fe5f51ff638f2bb, 0x3fe13a7097ef6d7e,
    0x3fb484b1ac4ee27e, 0xbfdeba761d7f5afb,
    0xbfe4a38dd5c98ba4, 0xbfe2343eb46f2330,
    0xbf97eab25075ceed, 0x3fdbf0030fe977c2,
    0x3fe5f19b7fde3c6a, 0x3fddbfb963add9d9,
    0x3f8cf336e02f9ec5, 0xbfddbc2b19f3409a,
    0xbfe6694cb70482c1, 0xbfe28b26213e3b47,
    0xbf7234890873edc6, 0x3fdd2e50da4bc64c,
    0x3fe752d2fdc35e97, 0x3fdce6ee3d5af268,
    0x3fa16f780edab4b7, 0xbfe1b9fcacb994bc,
    0xbfe71d9f33d08006, 0xbfdbd1b1e8707bfa,
    0x3f7053acef4835df, 0x3fe0e65f35f21bc2,
    0x3fe5494c0852ead0, 0x3fe14d6b5924d95a,
    0x3f9a56a3409e50f2, 0xbfe0522acf0fd1dc,
    0xbfe5aab3805cd890, 0xbfe0641c0925a131,
    0xbfa8fec531df5097, 0x3fdcb9e024b9b2ca,
    0x3fe4dd3f3c2d8f97, 0x3fe1cd602d4f23e0,
    0xbf9a86e61e8675db, 0xbfe062a368f9e943,
    0xbfe6cf969ca97915, 0xbfdc93763e126bb3
    };

static const uint64_t in_rifft_noisy_4096[4097] = {
    0x4010785baf69d0c4, 0xbfc92a9604168f78,
    0x40046255f53cf244, 0xc01930a0be8be4f9,
    0x3ffc97b4c0741cc0, 0x400ca32f3104f35d,
    0x3ffc7a4073ddee2e, 0x4003424a8d478d6c,
    0xc00b0ed4b8440795, 0x400b910f67a09806,
    0xbfe5feab65054ad2, 0x3fef8e8fdfc6f8a7,
    0x3fb9c8fcff9009b0, 0x400ccaf2bee083ee,
    0xbffd0dc71e50abf6, 0x3fb3cb5d1a81bdfc,
    0x400bf0ccd7777920, 0xbfd47b881979e79c,
    0xbff4f24e69d3119b, 0xc00723c9478f108a,
    0xc010fdbf5376bd33, 0x4001fa8b897ae7cd,
    0x3fed6319624165c8, 0xbff7990e8bf26d6e,
    0x3ffee2b9f82ff124, 0x3fe7cfd762db16cd,
    0x3fe23e87be1114e4, 0x3fe32c00ac7424d4,
    0xbff40c5ee71dc0cc, 0x400f96d037fa9af5,
    0x3ff292fae6ddf4ae, 0x3fdb6dc4802c5640,
    0xbffca36883cf9be4, 0x401495b568ebedd1,
    0x3fd6ea6c34327b68, 0xc0065c608db61b26,
    0x400269fdd91164b9, 0x3fc5749783f0ed28,
    0xbfd00ba7a0b26a3c, 0x400275fdd1d6095f,
    0x4009986f7eb6c3f4, 0xbfcb17390540ef8e,
    0xbfeb22c0df75414c, 0xc0020d07af281d70,
    0xbffef20b7e8a414a, 0xbfe9d7251a122d31,
    0xbfe30cac63aa5228, 0xc00fb3dea14cab59,
    0xbff51514d2fe8478, 0x4002309301d8e5bc,
    0x400945c1aaedd740, 0xc010ee7f3d5d5a33,
    0xbff1c8e948fca4ee, 0x4012d2e7f3cf92ce,
    0xc016c63d97845bc3, 0x4015accdb1d0325a,
    0x3f98c30659d83ac0, 0x400400f66cf10326,
    0x3ff381e5739ed4af, 0x400939ae765620ba,
    0xbfe3825cc8b95923, 0x3fe3c2c55a4a270a,
    0xbff58715cd470556, 0xc005ed5b03ae3f4b,
    0xc006dfababf5b76e, 0xbfca5d032f39fea8,
    0x3ff7876ccc95e342, 0xc0014001ddaea81f,
    0x3ff3ded43851645e, 0x3ffe27efb8be6b40,
    0xbf807f81773e5a00, 0x3ff1a12849db76c9,
    0xc0023ea534e38498, 0x3ff8cc63f4cf0148,
    0x3feb800b892e6fa6, 0xc012aa57abddfb2a,
    0x3ffd9c58eae263ee, 0x400bda162fd88f24,
    0x3ff6e2573a53feee, 0xc00fb994d81b1515,
    0xc01766492f5ffb1f, 0xc0034bf331e255f4,
    0xc0096fe0c36f80f4, 0xc0186b9536936d2c,
    0x400cf674724e6ed6, 0xc003f292e97430cc,
    0xbf99ac84c7b1f380, 0xbff7c4c23d0eb580,
    0xbfef3f9f9d1d1c7c, 0xc00910a39479e459,
    0x3fcb00ffa4806150, 0x4014291f5bbe608c,
    0xbff5d9c80f2f8756, 0xbfed53df049f08b6,
    0x400e8ca96015e48c, 0xbffba46b83d2bc45,
    0x4004567e89eca3e1, 0x3ff8aa5e39e1d3b2,
    0xc00c6b4efaf9aa22, 0x3ff2b3b79c79384c,
    0x3ff77b6e2a9aa2b9, 0x3f994115be5053c0,
    0x3fe6e2f7b334ab9d, 0x3fe1a4c6cd124dd3,
    0xbffa20461ec9fa88, 0x3fcc2fd912ab7540,
    0xbfe50361fef74a1e, 0xc0087070f667c19b,
    0xbff359f03a9b28a7, 0x3ff7c45b05eabebe,
    0xbfe446e4523726e2, 0xc00215ed0b75dd6a,
    0x3ffaf8b5b708710e, 0x3fe7b2a3186cca42,
    0x3ff5af54e4434fe3, 0x3fe579f64a6e7f59,
    0x3fd1d84afa1b7844, 0xbfaedab2aad624e0,
    0x3feea58d31ab4c2f, 0xbfe8c2a16e066c8b,
    0x3ff4c84f3aa56654, 0x3fbdc979f0097c18,
    0x3f9bbdbbe757f200, 0x3ff0a209987bb96f,
    0xbff365db800dcc40, 0x400f7e8219ec3136,
    0x3ffe2565b1b4a0c6, 0xc0065d8c20baad92,
    0xc009b59423ce0024, 0xc009c3fc48369198,
    0x400a69a9e4179e6c, 0x4001480187caa060,
    0xbfdf634b924004ba, 0x3fc83229d525b800,
    0x3ff23b089049ae20, 0xc0035177916454b4,
    0xbfee3a33adfd0cf1, 0x40105003440680e6,
    0x40023c4ccbb1ab68, 0x40051aaa6e46bb41,
    0xbffe529da585e471, 0xbff915415e72918a,
    0x3ff0e9407cec2989, 0x3fe385deec1a05ea,
    0x40066b904417ebf2, 0x4011bfc1318c6270,
    0xc00e4e1b43b0f0c4, 0xbfe360753aba410e,
    0x4012e1ca141830ae, 0x3ff878dee6a18cc6,
    0x4004bb18881628d0, 0x3fe9658d4b93c058,
    0x3ffc44e5c30cb8b2, 0xbff7eab70e4f9ee4,
    0x3feb5058334ab81c, 0xbfebf83ad1085cb7,
    0x40109c9ef6dbbc82, 0xc010ba37865b4a70,
    0x3fea34bd553109ad, 0x3ff76eaec1d30e7f,
    0x400327cb80f12170, 0xbff4d16152e8d04d,
    0xbff39e51b0dc1ce5, 0x4001f65a1cb5d25c,
    0xc000fd39fc5dc97a, 0xbfc3702bb5ebb1c8,
    0x3fe250b56bc398e6, 0xc011cc123fa12ce8,
    0xbfe1db78c6bab4e0, 0xc006949b17458cf3,
    0x40079ab887fdcff8, 0xbffa055798df968a,
    0xc00fc3c71c17e2b8, 0x400043ce0b683a46,
    0xc00d450a869d0a71, 0xc015228170af3d60,
    0xc010edd5011bcf47, 0xbff3b2e5e33c3fda,
    0x40051b9cce96c241, 0x4000c72b188312ab,
    0x3ff2cb64c7d9f4ee, 0x3ff4c2568725e421,
    0x3fe0bb801c63914b, 0x3fd3b1d66dfbab98,
    0x3fe9b1ed21dbfa84, 0xc00478a404b8a100,
    0xbfe30c8eaf0d5af7, 0x400d9194df9c50b7,
    0x3ffc7020595310d6, 0x3fe456dff3a4105b,
    0xc007306bf45e3f7f, 0xbfd58a56a5972e10,
    0xc015f577bedecb9e, 0x3fd829cb3c5d71be,
    0x4000114719323f85, 0xbfaaea385332c500,
    0x3fe225c101eb28da, 0xbfe12e8554a73806,
    0x3ff1ce68f5c01cea, 0x4010f4149b44d2ea,
    0xbfeaf052a3645c21, 0x3ffd3cd80fc8e31d,
    0x3fea10f153eb299a, 0xbfe8ad42aca27c68,
    0x3ff05f19348c3658, 0xc005db43ad2677cb,
    0x3fde0c5793572cf4, 0x3fc699f3ce90da98,
    0x40049fc023866e8c, 0xbfe3864f0bfde453,
    0x3feaff65d42e9554, 0x3fe9699e868eec4c,
    0x40005ffb43bff2f5, 0xbf8b360b41dab180,
    0xc003aa15ff451162, 0xc01160ce4c626672,
    0x4009e9306719d60f, 0xbfe5c801fbdbdffc,
    0x4002dfcb89315df6, 0xbfeb3dc2cc9d85ac,
    0xbff7171736a55590, 0xbfed97190d490bac,
    0x3ff7286d2b035b7e, 0x3fde4971f8e32c16,
    0x3feba176805d1e54, 0xbfe8274b47efbe98,
    0xbffe2e429b68ea60, 0xc00903d0e026a0b0,
    0x3ffb33e4276a723d, 0xbfbfd9dd29a6cba0,
    0xc00212d02b1341ef, 0x40159b791361108a,
    0xc0042b9a590f4419, 0x3fe8d3480e74c441,
    0x40166be21eb45a8a, 0xc009b22da86f4cc4,
    0x40012812c0e9b47f, 0x3fcc0b3ac63b151c,
    0xbfed86f25664e7ee, 0xbfe06bb5598da230,
    0x3fffde1207f87529, 0x4013c0780a55b0e1,
    0x3ffa9890c9f62176, 0x4003b993d5b6c101,
    0xbfcb47949252ab3c, 0xc015c49db8827504,
    0xbff3e98d00fa1b68, 0x3fa0bde650f86a88,
    0xc0120eb90d35b9ab, 0x4000074eeae92cc0,
    0x4004265eeb79d0ec, 0xbfffbcf716738ec7,
    0x4000048c83ce0fce, 0xbffb4227761516b5,
    0xbfe12e99f7a24d5a, 0xbfd755b3a0198ba8,
    0x3fe36e3163c9406e, 0x4012f2b75b31bdee,
    0xbffc444eb038851c, 0xbfdb06e64b33d17c,
    0xc017ed474ca79642, 0x3ff80f0409568356,
    0xbff0edc516762ea9, 0xbffcc1d8eb33b500,
    0xbffe7c802be22389, 0x3ff63c5c5b6aa373,
    0x3fdb221270d7bd95, 0xbfe423362c6fcc2e,
    0xc0002020fb73e536, 0x400d3578423da0b0,
    0xbfc23d659445d112, 0xbfaedb326cc5f760,
    0xbff19068f77d9b5d, 0x400cf68071a9171a,
    0x3ff5b4707ac8228e, 0xbfce00506f6fa678,
    0x3fe0d8d212aefc6a, 0x3fe4b7cccaef3de6,
    0x3fd317a555ad8a26, 0xbfce772556423cb0,
    0x3ff0eae66cea359b, 0x4013b17aef8cac29,
    0x3fcdcac60cad17b0, 0xbffc4d29c21d6914,
    0x400b36b76e7dfa34, 0xbff5f6e249c3f29c,
    0x3fc8ccdd187651c0, 0xc005fd42f4078fa8,
    0xc0100d78dbe6637d, 0xc008395c2e2bf67c,
    0x3fd0fee8f1b7b4ba, 0x40088339e2b3c37b,
    0xc000a5394d33a3d6, 0x3ffa5d4ec18397d5,
    0x3fdbcaddbd2f8e8e, 0x400d32539ec13a6f,
    0xbfe383a5cb174130, 0x3fe6aed6c751cd50,
    0xbff71b3cbcf4669e, 0xc00078a875173f7a,
    0xc0198ec309be8577, 0xbff2a9eb23c64f19,
    0xc0079283227c9796, 0x40064230b96c399b,
    0x3ff8319d3c6d57c6, 0x3fe8085ec9ecefe7,
    0xbff10c129af08956, 0xbfb54b1c3b3fa6a0,
    0x3ffae273c57f0486, 0xbff63953b5e855f9,
    0x3fdabc27587c0878, 0x4006a49ce0ad4dfe,
    0xbfa94b8c07ddee08, 0x400820cbb4579d47,
    0x4003029acf6addfc, 0xbfe9619e20df2c78,
    0x40119630f6862173, 0x400b46d88667cc07,
    0x3ffd0d1881ab2970, 0xc005cea6b3419d7a,
    0x4003f8f9ef70bf12, 0xc00c541f45281596,
    0xbff0c8297b9359a5, 0xbfde0ada26a6153b,
    0x40041e75fe3e2aa6, 0xbfc010fb767013d4,
    0x3ff53e6914dfcce3, 0xbfe598392ff6edae,
    0xbfd52dd2615e0332, 0xbfdeceeff4be7da5,
    0xc00ab17e2493b2e7, 0xc012eecb31abc9a8,
    0xbffd8193e6883af6, 0x40061118df054304,
    0x3fc19c6c613a91bc, 0x3faf262221cb9c50,
    0x400c0effb7d6a36f, 0xbfb8728a5e09f87c,
    0x4001c8aa2ba011f1, 0xbfd0819b7551ac4a,
    0x40163d953c222264, 0x3fdd9340e009f382,
    0xbffe33f444623c83, 0xc0009ff8e6a602de,
    0xbff07144a2abfde7, 0x3feeac6560b8417b,
    0x3fff6095dd3445f5, 0xc01ee96eb814d926,
    0xbfd58f59a929eaf4, 0x3fe59dc98c8a7c8c,
    0x3ff29004c19cd180, 0xc00341617de4f344,
    0xc00330701b484f62, 0x3fc3fd8f89a73494,
    0x3fd89c6d21770737, 0xc00d82f60e3b0c9b,
    0xc009758e8dea891f, 0xbffbd54867e54b7a,
    0xc0062c3f010eba98, 0x400d56c856cb8256,
    0xbfe96e8c3c15a36e, 0xbff821e12db58a76,
    0x400322292071a9ff, 0x3fe10da0de7e53af,
    0x3ff5ae4de3e2b814, 0xbff59da19feb264e,
    0xbfef8863ff902504, 0x4010e1004fb842ad,
    0x3ffb9a7e441d17fe, 0xc001f1115be2a4aa,
    0x4007ccf830591702, 0x3ff37e039a5f74e9,
    0x4003a060a38049b7, 0x3ff4347474e0ec5a,
    0xbff8dbce09545868, 0xc0097c6f08783dbf,
    0x400201b912f3ad1c, 0x3ffea688ee401933,
    0xc00843f6b0257272, 0xc003c32013775b7a,
    0xbfb28a920a2d0830, 0xbff7dc8e3f6cc122,
    0xc0021e3e48b4c7ca, 0xbff2f93b1fea58f2,
    0x3ffdcde0b670e6d7, 0xc00cc1308628c502,
    0xc002c8d45443a9e3, 0xc002f22fb01403d2,
    0xbff3e170b9920df9, 0x3ff78d259809f49c,
    0xbffe8e7ef6d30d95, 0x3fd66c3424c91a3e,
    0x4007a1667fe85b34, 0xc0045f309a6b3a58,
    0x40061bbd5a4d8594, 0x3ff70cc2479f49e0,
    0xc0046f2dc0bd0384, 0x400458dab80f25bf,
    0x3ffa38f4cbdc14ae, 0xc0095f2969854bc9,
    0x3ffee90c5ad62cc9, 0x3ff536cbe0a51158,
    0x40058d77468cc3a4, 0x400389526ea15af6,
    0xbff0b571c0724e34, 0xbff19f6a33e9ec0f,
    0xc006fe88e762e547, 0x3ff9999e07f09ad0,
    0xc004b67f90dda014, 0x400537b34810980d,
    0xbfee5e262fb17329, 0xbffc38589806b677,
    0x3ffe8e3c764fe5b8, 0xbfc216d97dc43e08,
    0xbffdc448b04c4f2e, 0xbff60902652bd3ca,
    0x4016579e10ddff56, 0xc009fd2eb595abb4,
    0xbfd46c307f3164ae, 0xbffef485a2a65c53,
    0xc0097d513774a032, 0xc0092a0d09935ee0,
    0xbff8f6287f0ea386, 0xbfe018a779f1d676,
    0x3ff626b41671838e, 0xbfd0af418b9ecb9a,
    0x4005d1dd9005895f, 0xbfec76b43ff12934,
    0xbfea0809fee9bcce, 0x3fe867f16782fd8a,
    0x3fff0968aa4d2a41, 0x40017376823e94bf,
    0xc005de8ec83d327a, 0xc0067e90be4f8219,
    0xc00261c3805973ee, 0x401031323380cdc1,
    0xc002673d88463af7, 0x3ff513de46e30909,
    0x4009c45509cfac04, 0x3fb076b690f7a980,
    0x4000f8e9160f1c7a, 0xc010fe5e7c8d8cb2,
    0x4000ce23d281ca36, 0xbff44d681affe7bc,
    0x3fd39cc9f1b8792a, 0x3fe4dfbefd1bb3fe,
    0xc0011183d32b7efc, 0xc01abb09f933328d,
    0xbfec244290b33c64, 0x4005a91d4379a564,
    0x3ff1790a89483d1c, 0xbff2a9fc4e89449b,
    0xbfe6f06315fdae64, 0xc00117f1ebff2bec,
    0xbfea57a50834e2ce, 0x40088d9cadb7026d,
    0x3fe336e574526b86, 0xbfd6dd2a8be2f024,
    0x4011dfc706ab6ca1, 0xbfe39ed90603fbe4,
    0x3ff08f65bd8fdcb5, 0x4008ff6b6fe25a98,
    0x40012c6a9330cbb1, 0x3fe26613be4f8682,
    0xc006c98b5a7ca28e, 0x3fe47a91da0a6a60,
    0xc0061f6c4cb9f7ae, 0xbffdbd6850201b54,
    0x40173b0f785ad372, 0xbff0daa814ac093b,
    0xbfe4b91bd9491620, 0xc0008c771adcf1e2,
    0x40001cf9856eca7c, 0xbfc8587d2effd300,
    0xbfd801f386cb3a28, 0x4004490f1f5716a1,
    0x3fdcaa49bca7bdb3, 0x3fe3e296f1cfc91a,
    0x3fd905883aa232a0, 0x400aa963b9c03294,
    0xbfe8a38d629fdc1a, 0xbff92a0b37f5613c,
    0xbfcaa78e5cbc14c5, 0xc013780f5afbd623,
    0x3ffe7c52b4c96892, 0xc00def94814ce26b,
    0xc00167c55cb8bcac, 0x4016c23ffa5e36eb,
    0x4006324d8db1c74c, 0x3fd47802cafba698,
    0x3fd72b36ee1d21fa, 0x3fcfb0d0800bf8a8,
    0x4003f0bd2fd383fc, 0x3fd3866604bc43b8,
    0x3fde1c2098ac2f4f, 0x400c3148bc606aa2,
    0x3fc4938e5a130668, 0x3ff936ac93ac1e68,
    0xbfd770a5e9c78240, 0xbff7252403f012b0,
    0xbfe4803b3bc897bf, 0xbffb20c323e8a388,
    0xbfe087611a01c9b6, 0x3fedd55f0ac04144,
    0x3ff4ec102724c0bb, 0x400231e519c7881d,
    0x400eaf82fd23443a, 0xbff46bdeb2871544,
    0x3ffaefa185763946, 0xbff106cf3c1f854c,
    0x4004b79e51a595a1, 0x3fdb5c977a487150,
    0xbff1c7829b4c93c3, 0xc00240b37c6fb5ff,
    0xbff9ae8959ec4bde, 0xbff97d1420539166,
    0x3ff9ca42e65b1cef, 0xbfd9aa588be0f758,
    0x3ffc7f283c7d67e7, 0xbfea412063235e8a,
    0xc0003b5fc7a5c121, 0x4003bfce5e95a834,
    0x3fd3cdf896778914, 0xbfa493e0dca716e8,
    0xc00977dadd9b9d40, 0x40068236916c074c,
    0x3fd78f9cfdf04fc0, 0xc006f82d6f7dbdfd,
    0x3feab3c9659add32, 0x3fbe134c322b82f4,
    0x4001f14c5488d56b, 0xbfd740985c544d88,
    0xbffac92d43dec51c, 0xbfc18c0d35e2da28,
    0xc00e2c7106d40789, 0xc0064fffd151a21a,
    0xbfe789abb79e96f9, 0xc004f8ee6cc24776,
    0xbff58bf147f8e88c, 0x3ff222b592fa140a,
    0xbfef60899014086c, 0x3fec2b9eae0e84f8,
    0x3fe88f0c7703ed48, 0x3ff977170c027f6e,
    0x40036b96c79f0980, 0xbfeef3bfd1bdaa62,
    0x40047c38923c6c96, 0x3ffbe91618d6940c,
    0xbfed35151bfbd8d2, 0x4013201680b253bc,
    0xc001e8a7333f2c2a, 0xbfe1aec627e58a1c,
    0xbfe4f3c5a1c004f4, 0x4003bfe233ca5ac5,
    0x3ff63f5e87d5615a, 0xc000193d1fb76193,
    0xbffd7b6ae8778ff0, 0x4014b3bc0d0b30a5,
    0xc0013cec5ee05966, 0xbfe6c51f49cec7d5,
    0xc003a076e661816a, 0xbfd31e446e27385c,
    0x40190fb61c0a891a, 0xc00968c2f8f05260,
    0xc01005c05d1d0b12, 0x3ffa4bec157f2198,
    0x3fe5167e0f02061f, 0xbffb80ed925a72c6,
    0xc011005ad0dc664d, 0xbfe0212b9eda09bc,
    0x4003ba1492b15d7c, 0xbfe52b3dc4356e48,
    0x3fff93c8887957e3, 0x3fbbda694204f420,
    0x3ff356c19caa9a20, 0x40037b613f8bccf4,
    0x3feafa16f841b830, 0x3fff4f1a62fd03a2,
    0x3fedb18ebc811da1, 0xbfe3417c23871f00,
    0x3ff38e646f8f7892, 0x4011955e8e79c782,
    0x400692e6f8e79098, 0x3fec30ce61428114,
    0xc011ebe00bfbcec7, 0x4006b132c443a136,
    0x3ff330c40bfe68ac, 0xbff28e8617d6bcec,
    0x3fe046c773e33008, 0xc002fb0b68224bce,
    0x3fd7b443d2542f91, 0xc007402d62cd4f6d,
    0x3feda6e4faec3e68, 0x3ff2f0d18e4d020e,
    0x40038f0662b551e8, 0xc00a8070b70792c5,
    0x3fd195df779dbf7c, 0x3ff933b525a791d6,
    0x3fb2852f2c3882c0, 0xc00140c5e523c58f,
    0x40006be728c073fa, 0xc0007b7d28a4345d,
    0x400997bea42fd30c, 0xbffe3cf45788545b,
    0xbfe6c41ff26f087c, 0xc00b39b65d52596e,
    0xbfe87cbd440f55e2, 0x3fe0cd8f0c7b85bc,
    0x400d33ea9dff9509, 0xc00bf57fd9e52ac8,
    0xbff8fdc81aecfa34, 0xbff444da6bf24919,
    0xc011a698c7017eeb, 0xc01508b11a5e5d24,
    0xbfe4cac75f752dd8, 0xc011ea11fc632528,
    0x400ca15e2bd95066, 0x3febee742f526c9b,
    0x40119202722355da, 0xbfa312037004d3a0,
    0x3ff8392d23c75fd1, 0x3ffd53c402422a0a,
    0x4010326ffc92f3ce, 0xbfeed7ad85ca99ff,
    0x3f8eac2323a07d40, 0x400479861ca0d828,
    0x3fcbaec0442cd83a, 0x3ff6ec0f5926f6da,
    0xc00212a436510d33, 0xc00a77acb8d287a3,
    0x3ff481fcd679df28, 0x4011d44e8dd3a1ac,
    0xbff1ae232bbf5c78, 0x4015d4c9c515afc4,
    0x4005fc09c52e399b, 0x4010ff37241e0a0a,
    0xbff24f7579883592, 0x3fef730b119f44ae,
    0x4002e6a2dd03a3d6, 0xbfb0f5cb1330d940,
    0xbfc0bdc090d37988, 0x40073b35e6218236,
    0x3fe7a650ca67c7a0, 0xc00982ec50fc8f07,
    0x4009bd46bf9db1e9, 0xbfd30aca7faff17c,
    0x400678a8033fa27c, 0x3fcd6b7500058540,
    0xbffb53ba2b05133c, 0xc0082bab32be21fa,
    0x4000df395fd904ec, 0x3ff6cf418302d52e,
    0x3fbb62a7922b5548, 0x3fe2edbfb6237ccf,
    0x3ff819fb4be7c7f7, 0xc00978091eadace8,
    0xbfe5bb36fc0790d8, 0x3fd4671182f93770,
    0x4009683546e19d9f, 0xbff93f7227506d08,
    0xbffba680bf4ec589, 0xc0053a10f1605e18,
    0xbff7aaa87f7d2700, 0xbfef250e29617619,
    0xbff6b369418a3a93, 0x3fca783daada8578,
    0x400e769736e5a6c6, 0xc0043526c48de0db,
    0x3fe2574d1e9d4a87, 0xc016a609ca6f7eaf,
    0x3fef2d27b9768cc8, 0x3ff0bfd3be35e287,
    0xbf8f53e1a5344f00, 0xbff3621bead582aa,
    0x4019303cd1385f96, 0x40006681b2cae47c,
    0x3fc45d1c3b7f03f8, 0xc0058fb7ec566b5e,
    0x4015c689afa7153e, 0x4015d49c23662d68,
    0xc006246d32bd3302, 0xbf92719f6e48b640,
    0xbff9fe6f41333833, 0xbfe313b4b8a903ec,
    0x3ff689ae1ca2e138, 0xbff9bac30f6bfe93,
    0x400bbd6c2db699a9, 0x3fe29c990c40c85e,
    0xc014534bc163588c, 0x3fcdc29343c74074,
    0xbff9789c7becf073, 0x3ffe887a4eadb5bc,
    0x3fc34f6f8a1c2e98, 0x3fd7eaaea12de1be,
    0x4009311f7674bfd0, 0xc0039f85e1086a32,
    0xc00d77fc49666c7b, 0xbff37693ded78cc5,
    0xc00fcfb02d3cb354, 0x3fd3cd894f2dc668,
    0x3ff8b2bf5bef5361, 0x3ff72ec004e280e8,
    0x3ff1113b3d6f28c1, 0x3fed78e1f4f03caa,
    0xbffa08c253c53852, 0xbfecfc8e1deef8ba,
    0x3fe8290dd46e3f84, 0xc005e7027b1e8e7a,
    0xc011dad7604e8ddf, 0xbffe21d4c408139d,
    0xbffa1e26516ff036, 0xbfb77da55f40b5f0,
    0xbfd6a219d029fedc, 0x3ff42262b9bf7cad,
    0x3ffb019ec54960c3, 0x3fe7deb707d169c7,
    0xc01377854e5901bd, 0x3fe2c81b8735ae5f,
    0x4003bba9fc43e7de, 0xbfede6b11e4e0731,
    0xbff9f08c10ba39cd, 0xc0041a3309d1d3b0,
    0x3fd67138ff4a9602, 0x4003e4725b72f23a,
    0x40084f15e06df424, 0xc00a1bcd3210c098,
    0xc004deed6d42327b, 0xbff74d1611d69198,
    0x3fdf1e251e5541ac, 0x400978205d6e0e9c,
    0x3fd0b9c210f6aed8, 0xbff23106de28e126,
    0x3fffcdf13670d9db, 0xbff00a4984e5b46f,
    0xc00bf8feff3a6fc4, 0xbfeb3363da45b27b,
    0x3fdd64d22a7c8be4, 0xbfc54f96a16ed680,
    0x3ffc84fbb353c37e, 0x3ffc2eb750dc70ba,
    0x3fe1b4453d4f0528, 0x401021db778f245a,
    0x3fb414851fb9b218, 0xbffe0725e7d062de,
    0xbfdc899c4d0934dd, 0xbf7f800c0be58200,
    0x3fb37ad79cd1c218, 0x3fe7f0b53852ffa4,
    0xbfce09f0ade800ee, 0x3ff55219d8f15855,
    0xbfecfab4b2b46c02, 0x4005d073925cf1df,
    0x400361251a2e7719, 0x3fd03531a19abedb,
    0x3fec88dc8b79a7b4, 0x3ff57080e228ade4,
    0xc00f111e3548bc5e, 0xc0018b19890e9ca6,
    0xc00221b93e151a10, 0x40074400b067f8c2,
    0xc01b8188340bd889, 0xbf58bba84976aa00,
    0xc000130607fb29a3, 0x3ff3b124c7f517f6,
    0xbff9240e25a3d708, 0x40014af734b412fa,
    0xbfb6d1661c509160, 0x3ff4b364b0ff58ad,
    0x400b26fdf78b41ca, 0x3feb1e5f4d24a3c0,
    0xc004090ed35a6f9a, 0xbfcba547823a6818,
    0x40107654f588b349, 0x400290993b7e750a,
    0xbfae9c65235cb0c0, 0xbffd26d15585cba0,
    0xbfde95ed168d842d, 0x400f7479853a0934,
    0xbfeeebe792dc5bb2, 0x4013d46a62ced143,
    0xc011659e08931046, 0xc009c459480b37ee,
    0x4004aa00b3daa802, 0xbffa2f1bb8bc0e09,
    0x400177d9190dbe0b, 0xc0158b128de7975f,
    0x3ffc4242356b01e0, 0xc01479c118977020,
    0xbfe33f59979dbcf6, 0x4005b6e0e22b505c,
    0x3ff44bacc539ba20, 0xbfdff48449dd2b18,
    0xbff3dfc3a3c2eeec, 0x400bf6f4ea3a5bca,
    0x3ff148cf67c3c9ad, 0xc000564f5c0815d8,
    0xc003d25d2c64268c, 0x4006b9843e43ee52,
    0xbfffe1b16d4d59f0, 0xbfdac14ea4500788,
    0xbfeb300fc3f29f92, 0xbfde9fe9832c5a08,
    0xbff50367d0e83e28, 0xbff6dbe91f31b8f2,
    0xc015985cb0c254d3, 0x3ffe1238be75fec9,
    0x4007b56a9fa3eabb, 0xbfc5964cefee317b,
    0x3fc3678ec639dd14, 0xc008468352313f92,
    0x3fe8d8989a47b4b8, 0x3f8d18357cb93000,
    0xc0007ba318be5d60, 0x3ff3dc756e20b7f5,
    0x3ff4a06986b780e8, 0x3ff05bccaa8b86e5,
    0x4005d0cdb0ad4ff4, 0x3ff403d17469a818,
    0xc007131f4ea2f594, 0xbff4f58b4eac50df,
    0xbfe08aa7f2c7d32f, 0xc012119c7e4c2978,
    0xc0010bec1ae8910a, 0xbffe07e39d2d9e0e,
    0xbff57f3cbe3bae75, 0x3ffb2b0855dbf343,
    0xbff1290a91c57813, 0xc00c6e72d9b4c483,
    0x400a0be9a8ada04d, 0x3fa8bbe2af5a42a0,
    0xbfff12c6e1ec56ad, 0x3fd6006e98674820,
    0xc00cb0459dd8f9f6, 0xbfbceaf46ca5e950,
    0x3ffc192eaad0c950, 0xbfee531bdd3b1f50,
    0xbfe33a72878f26a2, 0xbfe69aa4ccc03800,
    0x3fff03811c762f1b, 0xc0018d77fe08d807,
    0xbff56771c04e887a, 0x3ff7a1aa51c3c7ba,
    0x401056ab2a6fb5de, 0xbff259e0f6bc9a36,
    0x3fed49c82fca34fa, 0x3ff8837811efb5be,
    0x3ffa8d84ee24d828, 0x3fe29cdfbb5d398e,
    0x40084eb9db9770d4, 0xbff08ac0a946cba8,
    0x400be5b601b2dc7c, 0x3ff5c6ed2fb7c901,
    0x3f7cc4fd0e133600, 0x3fea478b6a206398,
    0x400e9c21fd068850, 0x3ff9b5ae3468558e,
    0xc002db4b8b8dfb47, 0xc010f95d83c54e8f,
    0x3f7c5f7932e2cc80, 0xc010ed2e98915bdb,
    0xc0038628583c537a, 0xc001c7b4ea2bbce4,
    0xbff7c65a5f26ef30, 0x401406275c86992c,
    0x3fefd15a4ed8c9c4, 0xbff9618304ca014b,
    0x3fbed0d0269b92d0, 0x3ff13ad3d7578b6d,
    0x3fdf0b9ab61ad680, 0xbfe7773086c5d103,
    0x3ff35fbec069d649, 0x40045b8109087110,
    0xbfe19cf02a65c8b3, 0x3ff51fd33033402e,
    0xbff139ea6e9bb98a, 0x3ff5bc4610994144,
    0xbfe890f6d667137a, 0x4005cbf028b0d970,
    0xbff0bd4b32142b0e, 0xbf7ae2f1cd532f00,
    0xc008f2c5fbd4045c, 0x3ff0cae02f3c4d3c,
    0x40018e4d24c46bca, 0xbfd8dfea0ab34c8a,
    0x3fe0a94e408380a1, 0xc00f9a41f1b0e53c,
    0x4005553c26a462f5, 0x3fc6cb638f9213e8,
    0xc003d0de740868a8, 0x4005ff5c629dfbe5,
    0xbfdfc19f4de1b9b2, 0x3fe1ccba51c07f9c,
    0xbfe24c267570ea18, 0x3fed416ed66479c2,
    0xbfeb24fd1a9f78de, 0x3fd2a10a1ead0d44,
    0x3ff1eb335db63fe8, 0x3fe123a3d5a03308,
    0x3fc1eae7b93daeb0, 0x3ff29c1d7bfdc8d3,
    0xc0098417ab5d0dcc, 0xc00c57fd58e3c49e,
    0xc00f70198b030089, 0xc00cc9a9a36be618,
    0x3fdbd2c539fc6d10, 0x3fdfb3ff6a1ed54c,
    0xbfd5953849d2f55c, 0x3fe496fa18f241c8,
    0xbfdf3572887e45c8, 0xbfbd24d3526de1a8,
    0x40014093718a38e6, 0x40043aa99dd182e2,
    0xc0031c131a05abf5, 0x401846b5b0acee2c,
    0xbfc5136198536c40, 0xbfe573656b7c54c8,
    0xc0118de683b948dc, 0xc009be6cc9e9b498,
    0x4008a411881bf5d3, 0x401a9a48a7fbf70d,
    0x3ff86ce6121d6a8e, 0xc00a9429f8ac7f2d,
    0xbff53669ecca7c88, 0xc002c3c5db03432a,
    0x3fe6defd9405ecf0, 0x3ff5482cccc0238d,
    0x3fe1aab08893dbde, 0x3ff948128d34c8f6,
    0x3fde397ea33d8dfb, 0x3fdd058b4474ed98,
    0x3fd7243ef9a3c77f, 0x40126e8fd6a50bf0,
    0xbfd1d9fba8269050, 0xbfdaa321021b5d8a,
    0xc00532158d35b2ef, 0xbfe3a367c1608778,
    0xc00be4d858f4d56b, 0x3fe154fb6556929a,
    0xc000d737cfa1cbf6, 0xbffa68d26d61241c,
    0xbfca74f6e92b2678, 0xbff1661411d2d330,
    0xc00588a41985d7d4, 0x3fd89904520ebb72,
    0x400835e1683d7880, 0x400436c664c99f97,
    0x3fe11457b89b8a54, 0x400b00c9a85fd9da,
    0x4009b6469e5bd13b, 0x3ff34c3fc82717ce,
    0x3fe5884438cffd48, 0x3fd467d8c3d1d820,
    0x4013184c0bce04f0, 0x40109c8006c9d97c,
    0x3fdd127935614d54, 0xbfee1c27619eb7d4,
    0xbfea912f675bd57e, 0xbfb793b64b023a00,
    0x3ff59ce6aa1b48a3, 0x400506340f3647e5,
    0xbff23777ce6798ba, 0xbf989e8efb2dd100,
    0x3ff3a7eb6f54ba03, 0x3fcb4d31dbd89c54,
    0x4013b1a3f5a496d4, 0x401421f88b902107,
    0xc00619d09c4c35fa, 0xbfe26537089463bb,
    0x4013260a439ae5b2, 0xbff20fa07713390a,
    0xbff8d04c57cd09c8, 0x400764dbbd9d4af2,
    0xbfabb9ec32f988a0, 0xc0056df5b3945be2,
    0x400cc5a3c3cd7972, 0x400884cfe9a65038,
    0xbff448406fe92525, 0xc0045df85b4fba1e,
    0xc00bb3c8bb10e31e, 0xc008e881bb90aeb2,
    0xbffa3b14875b9374, 0xbff871bb570c6e3b,
    0x3fc2ece985b5edb8, 0x3fd77d8178b6ea30,
    0x3fd3f1c7fc460960, 0xbfeaccf9d0b2ea10,
    0x4009732cf5d0b000, 0xbfeb35489a829978,
    0xc0018f78c34b1715, 0xc01495206b64d806,
    0x3ffd4470eaaae443, 0x4002a1df25b75480,
    0x400c052d966802c8, 0x3ffbaedf441fea2d,
    0xc007937ebb7bda5c, 0x3ff17bcd912c4540,
    0xc00e7dd2c7e3f41b, 0xc006ee5df84ac04c,
    0xc005ba09292583ac, 0xc005712c1a5a8ff0,
    0xbff7929309a39fa6, 0x3ff22c176ea42c89,
    0x3fbcb9a4df218ef0, 0x3fa5a653e63f35c0,
    0x40101d431d075150, 0xc00cb78cbe096045,
    0x3fea72727f83118b, 0x3fd07123d64db12a,
    0x400c5aaff1f80cee, 0xbffadc25acd46e1e,
    0xc00d99efc725a351, 0x3fe0438cc7b0924a,
    0x4008aa906d47492a, 0x4002257ffb637c83,
    0xbffda2e70d630f60, 0x3fffe94cd399bb6b,
    0x3ffd551af00e1874, 0x3ffddc466964a78e,
    0xbfd458326608f7b8, 0x3ff4a26ae0e591fa,
    0x3fe936c53999019a, 0xbff254051b85d81c,
    0x400550afc0e1c366, 0xc00573374f8098a6,
    0xbfd98cc5529993d2, 0xc09666fc4e690dfc,
    0x400b7ab36ca7611a, 0xbfffb6653128915a,
    0x4003d9ab8ddca7a3, 0x3ff7bb146e227a6e,
    0xc00738a937551b0b, 0xbff1bb3c5010e934,
    0x4003009b8d0089b6, 0x3fed629938eba9fa,
    0xc0012d091e9fa179, 0xbffc9b88c08d4938,
    0xc012aa454bf6b2fc, 0x400b5a15deda612e,
    0xc0046f1f83f6a500, 0x400a4ae019f1a79c,
    0xc007e912d39e77db, 0x40093f2c188bdc70,
    0x3f9280f634cace80, 0x400cf40d9660507f,
    0xbff891a8735cdeed, 0x400055b358a00bef,
    0x3ff9904b5f41f1b1, 0xc00ee8d1245b10bc,
    0xc012455e2baddf71, 0xc002b0cab75ea766,
    0xc002e7883a2b179b, 0x40009af95ae4e500,
    0x3ffb4d9e0e1455cc, 0xbfdaaf7136ab52a0,
    0x3fec41c79f351f78, 0xbfe568fea588dd3f,
    0x3fda5e0645d13c55, 0xc00f93b29e92a78c,
    0xc01a0c9f0290c1da, 0x3ffcffc9562d6dd4,
    0xc012d6de173469d6, 0xbff5ad5c4c85d45e,
    0x3fdef642c741f43c, 0x4002a3b05e14cbe8,
    0xbff3f56d105089d0, 0xbfd6eb7a68356713,
    0x400e68b4668cddb9, 0xbffaea8cdca7edec,
    0x3ffb17e71052faeb, 0x3ff0f8235e4656cc,
    0xbfd7da7e875aefd8, 0x400498f1863424e6,
    0x3fe223059c6a0588, 0xc001787750c56f72,
    0x4006f954c4048212, 0x40165f118b3a78a6,
    0xbffa6ab1565aa3cc, 0x400432b8ba2952ab,
    0xbfdbd0c044daf65a, 0xbff0786e33693dfa,
    0xbfef53f148ba6cdb, 0xc00558634d18dbbe,
    0x4000b0f17c12f0ec, 0x3fe850db91876e71,
    0xc003d91e75a6d52c, 0xbffe0678a886bcd6,
    0x3ff22a743c9d1552, 0xc00bb40c7c2b17da,
    0x3fe4854bbe26793b, 0x3feed328817fe7ac,
    0xc012166baddb16db, 0xbff85b2eb0308c70,
    0x3ffad82f799ea149, 0xbfec3780b5999d9e,
    0x400dfb69589916f0, 0xc0000cd3817075fc,
    0xbfeca086678a62fe, 0xbfe9c55c31a0ed56,
    0xbfe2187218fa9322, 0x3ffa55c2327a3081,
    0xbffc3f45bf0748dd, 0xc0123e133682a379,
    0x3ff523d29395f282, 0xc0065d441f1be446,
    0xbfe0cc4f2476d116, 0x3ffd97bd4a2dfc61,
    0xbffbc3ae8e7b7be5, 0xc00b1cf5c807cfab,
    0xbf6fdf4032bbb000, 0xc00c1ce1d0fdf05c,
    0x3ff083f049ef1c9e, 0xc008bd642fa23caf,
    0xbff608fc4c6406e9, 0xbfec0bb7435058fa,
    0xbffb9d4c7d60ce19, 0x4007589a4946fd60,
    0x3ff7dd4803c56311, 0xbffbba64bcf774b4,
    0xbfe7363d51745eee, 0xbfefa4647e66d852,
    0x3fc6a1818317df78, 0x400273180e834c6d,
    0xbfd82236d36fbe28, 0xbfe6232b72d00cda,
    0xbfd0a20cd8ea2558, 0x3fe9d239d9a93e3e,
    0x3ff22ad7e401f42e, 0x3fe8b75290be4a34,
    0xc0081a793cb7bca6, 0x3fc1591455b21b94,
    0x3fea118833dcd13c, 0xbff11e92c1f517d2,
    0x3fc40d54d3c4b450, 0x3fcc9b85c6cbdda0,
    0xbfd13c39d762aee4, 0x3fdf38f3d324e5c0,
    0xbfe342f67a0a0d04, 0x3fd6207af8f1d618,
    0x4000cbdcd4b12046, 0x3fdf62a85db3924c,
    0x3ff6d1a30a02f077, 0x3ffb1d167d37faa7,
    0x3fb144e095435b40, 0xc00cf66e34e9295a,
    0xbff1ec83bdebbe44, 0x3ff562f6e97c77c0,
    0xbfe69442e598d797, 0x400486559e86a2a4,
    0x3ff08ec91b50efce, 0x40120dc1b740c891,
    0xc00d8c390c00246f, 0xc004aeff8f9fff7a,
    0x400cdd1ede650d1a, 0x3fabebb026495b40,
    0xc00e56bac7d69a12, 0x3fd4171b09c19c0a,
    0x3ff66c37815df4a2, 0xbfff90916bc7098c,
    0x3ff400de55896313, 0x4002c65254dc51ad,
    0x4007b655d0aadf2c, 0x4000ed219fdc0a62,
    0x400224b054eb3726, 0xbffd92099aaf834c,
    0xbfff8422722e67fe, 0x3fe2369c7b4c677c,
    0x3fe8bcfefe5aba5c, 0x40103706e77bc2ce,
    0xc00719c60722bd48, 0xc00e3287c6ffc3d4,
    0xbfdee94a6dadc1cd, 0x3f870db00cad4c80,
    0x4007242ae9b25567, 0x4009b28528ca9e71,
    0xc000eef9a66515bb, 0xc0052077f68ff53e,
    0xbff0f3fc27e06012, 0x4001622dcba8f302,
    0x3fe58a426a8a989a, 0xbfe5456bb52331ae,
    0xbff183662a798f7b, 0xbfed8680f2501647,
    0xc004cfcb0627f661, 0x3fd6398b090065a8,
    0x3ff173501ac080f9, 0x400639cda01dd087,
    0xbff2d73cff311537, 0xbfeac7104a2ad210,
    0xbff0ac9f38235d15, 0x401834051d4ed688,
    0x4011fc33e6a6a2e6, 0x40071960c5ab9ab2,
    0xbff982c57c7e4a9c, 0x4008da1a7c8fcec4,
    0x3fe1dedc703e7303, 0x3fe3fa8613710c19,
    0x3fdf48b62da94eb8, 0x3fff36a16ad41bf4,
    0x3f8f459104f35100, 0xbfee77336aa21b7d,
    0xbff035b7f8ea8399, 0x3ffeca031c4d7031,
    0x3fc709755dde5498, 0xbfe36ccedba0e5a6,
    0xbff678fa9746f1e4, 0xc000166c3489e6f0,
    0x3ff800220c054ec8, 0xbfe94093bb8e215c,
    0x3ff72893461d44a1, 0x3fdf2cf08345c6ac,
    0xc013e8556a5ee6fa, 0x3fecc4b6e72b6602,
    0x3fda8cd3d565b080, 0x3ff03d0a999f91b1,
    0x4003499688667ca9, 0x400368870235660b,
    0x400822101fde8102, 0x3ff74e0596f72d34,
    0x4013cc000f0b1d88, 0x3feca985a6a30fe4,
    0xbfbea79394ca83b4, 0xbfe87c2a16f0e1d8,
    0x4010817a9f2b2b7d, 0xc0156ff654e7f370,
    0xc008b6df398bf7da, 0xbff5996e397a0b8a,
    0x40035ec2788831e8, 0x4002819f10ce2c4c,
    0xc00b5dfff09c39ac, 0xbfe43dd5ce56f6c8,
    0xc00dbbe77daf8772, 0x40031456dc26383c,
    0x3fddb095f4af4092, 0x3fd0e9c1a960b728,
    0xbfdef32a9034c21b, 0xc004006482be7011,
    0xbfcc476f38077b50, 0x3fe097d305a20b36,
    0x4011b5bb61c6b4c2, 0xbfff3b1be79523a1,
    0x3fcd57646051c0f0, 0x3fe414e275ecfa10,
    0xc00484b5e4f413f7, 0xc0034b94b14bf7ca,
    0x3fa679e8155ce9b0, 0x400cfa1180bfad6a,
    0xc0102062556f58e8, 0x40157b758a983550,
    0xc009c723eaa0e11d, 0x3ffb62a5050ed19c,
    0xbff9582fa97896a3, 0x40125ad1a78feeb5,
    0x3fd8809700cced9c, 0x3ffdc95bb46e9b3e,
    0xbff93bf12bc9e45d, 0xbff93605e8675952,
    0x400bf61bfb46a70a, 0xc00818f1cdf0929d,
    0x4006a8c9a484de38, 0xbff02fe730d4a19a,
    0x3ffe3e6c7a7793d5, 0x4006b922fbe6f355,
    0xbfc21e88ae7e7510, 0x40126e0ecbfa0dde,
    0xc0009b01f57b2708, 0xbfe95f01df64c11e,
    0x4011427a8dfe949d, 0xc003f022b7351e90,
    0x4000388ce014e179, 0x3fd90c0a7e924130,
    0xbfe46ba8901057ac, 0x3ff34e3b9341aefb,
    0x3ff20d06c389622a, 0xc0021b26bbd67eac,
    0x3ff0c5f505e7671a, 0x40076b64284168a9,
    0x4015e927b3f0ba88, 0x3ff677f630d4dbe6,
    0xbff826a51d67111b, 0xbfe91756f253040e,
    0x4010b7f9de7d9506, 0x3fdf4c35ec8bac0c,
    0x3ffbeb92683fd8ac, 0xbff4291e12f241e2,
    0xbfd8ef81b35bfe2b, 0xbff9ca9aa81e0b4a,
    0x3fd623aead1eae5e, 0x3fecfe3ab93e37f9,
    0xbfd9d70776b4a0d4, 0xc01383fbd0f7467c,
    0xbfe6729781524f12, 0x3fe52a1380aecbb5,
    0xbffc934ed3bab51b, 0xbfc4958109a28d8c,
    0x4006cd9f013aa8e0, 0x3fec7d4613c2f2e8,
    0xbffcac84c313d31d, 0x4000ce9f6f79ea9f,
    0xc00e0441d4879f2a, 0x3fb46ef496472838,
    0xbffb934501bf09cc, 0x3fd116142dc03a74,
    0xbfd366555c278598, 0x3fe1bab240ab40ea,
    0xbfdc61af489c6ded, 0xbffc33dc02ad35f3,
    0x3fdc210029f8df7e, 0xc0036fc159a69fde,
    0xbfd7d2a3b65b8854, 0xc0002dc9e2f9227c,
    0x3ff255ad58e56fa9, 0x3fe811ed7d516eaa,
    0x400791a1bbb53dd3, 0xc004c72acfc6904b,
    0xc001a39fb734224e, 0xbfd035d0b9d4b4a2,
    0xc00126e2554f512c, 0x3fbd3dda63f8c968,
    0xc00f5d568cf703ed, 0xbff08162c7644201,
    0x4001bba9541b5325, 0xbff563f86f6d90b8,
    0xc011c5ff31a9a1d1, 0xbfc9b119adc97084,
    0x3ff15d20b3fe706d, 0xbfe819aff4369759,
    0x400b348d8c7fe4f3, 0x3fd93c452e6b63b2,
    0xc012982e68e88282, 0x400d0f75d3d333c8,
    0x3ffabef6c6342d6d, 0xbfc0bff2169b3088,
    0x40020d05e4705830, 0xbff92fcd5d844ec5,
    0x400280ef3f6a9e8f, 0x3ffc78f8c4ba1b32,
    0x3fe72afcc0070b86, 0xbfe0a1bd515276d8,
    0x3fd5315149984ad0, 0x401554e13d26163a,
    0x3feda66d1eb4a8f4, 0xbfec7183be35ed5e,
    0xc00bc8f341a244c6, 0x3fe058c3db166394,
    0x4002ce9cf6cfd8e3, 0x3fdf1fbca298797e,
    0xbfc352ffded7bff0, 0xbfe7b9a1d300a3b8,
    0xbfec0899a2410522, 0x40037d71aec18bae,
    0x3fcae9aac1a26bc0, 0xc00a4f053b83c7da,
    0x3ffb03eae1b53f10, 0xc010cb03425cd080,
    0xbff92fd6e358ccfe, 0x3fd98059b1f10915,
    0xbfe574e1f2d97752, 0xc00b6b2000e88ba3,
    0xc004df0b0577b47d, 0xbf48fb87c0f75800,
    0x400b6b23ebc00af4, 0xbfc047735de75a0c,
    0x4006c94fd620c5fa, 0x4005f942e16abc46,
    0x40047ff188a56896, 0xbfd1820e386637c0,
    0xbff858c5710d1f12, 0x3ff7618f2ae5a6fc,
    0xc00ab90e421f5e61, 0x3fe9cdcf63072993,
    0x4004c2b5a1521a00, 0x3ff3bd302fab9b0e,
    0x3fe1b5ab51553b80, 0x3ff5e360f72a07ac,
    0x3ff2842376f76ecb, 0xc01183e3b0a00052,
    0x400f14dd3dca7cb4, 0xbfb8dfe0c779f620,
    0x3fe2c0c39b7863b2, 0xbfe064019990b9ad,
    0xc00294cba63c708b, 0xc0083ca83a7a3a2c,
    0xc00be9c757c7bb53, 0x3ffea2d52c69c02b,
    0x3ffaa8bef32be926, 0xbf95f7efe390a020,
    0x3feceacb574c030c, 0x3ff26666155dc434,
    0x4009f9752bdb4d0a, 0xbff08a271e962295,
    0xc008aab299cb852a, 0x40049131fa0cef58,
    0xbff869ed50b54b13, 0x3fcc2a3f21dc074a,
    0xbfc0f6ee7ff844b8, 0x3fe0faa26445810c,
    0xc000110e1fd4e6b1, 0xbff68d969e259862,
    0xbff3e4f8b9ce1a7e, 0xc016878d200a350e,
    0x3ff9606ba45c09b0, 0xc012836d772febf9,
    0x3feb3a7643cf10e6, 0xc0048039d2220006,
    0xbffee1cb749d2377, 0x4005aec1e1cd840a,
    0xbfeff0defc2921c0, 0xc0001659d6cd68a0,
    0x3ff4bea9f8f13b83, 0x3ff5a371cd96b329,
    0x40075d3d91768e54, 0x400318550fdd9742,
    0x4001bae9583e7d22, 0xbff19d4cb434a4a7,
    0x4004593b1995f983, 0xbfd7225f38993bd2,
    0xbfbe247387a578c8, 0xbfc40c0d766ebab0,
    0x3ff22fd5c204f202, 0xc0042aa636d865d0,
    0xbff4523da2d4c9ee, 0x4000b36d4042cf37,
    0x400e553d7f3f91c5, 0xc000c3469ff8d73d,
    0x3fe28de89ad6c9f2, 0x4000feb1261220d0,
    0xbff06764630b728d, 0xbfafbba36d7b4550,
    0x4005414c074301ad, 0xbfec0f603a94d304,
    0x3ff447c72bd077ab, 0xbfea4d671abf7664,
    0xbff5bb7d88a445d9, 0x3fced7aed8cdc415,
    0x3ff93371365b2d04, 0x400575309f19e416,
    0xbfb1e14ae915d040, 0xc00547c7c3dc301e,
    0x400510d1a5dfd1e2, 0x3fe753aca6d69958,
    0x3fed08c2cf7eb786, 0x3ff7e2c71ab7e885,
    0x3ff052d8d981760f, 0xbff1f448e2ca15c0,
    0x4019231ed2fc713b, 0x3ff5148296d483ff,
    0xc0061da214ac5886, 0x4012027413c82d97,
    0xc0070c5df10af410, 0x3fd2e6d71eddcba4,
    0x400eacccf8980afe, 0x3fc2418e6750d36c,
    0x3ff08827267e7d98, 0xbfef06740346dc55,
    0x3ffa9ded8044b880, 0x3fe22c7182e50094,
    0x3ff0e40b0ecbce5e, 0xbffeaa4d179203e6,
    0x3fd5960093844170, 0xbff734708a14c485,
    0x3ff82178b8e7f2d2, 0xbfe465b26e2bf879,
    0xbfe129a16799aa03, 0xc00625f546868923,
    0x3feba3f01a663be7, 0x4006e195bf613e59,
    0xbff2f34bc7bd3761, 0x3ff262c269f81464,
    0x40129cc12392126a, 0xc0139511fc0c542d,
    0xc011b48e4e3a393f, 0x3fd0660710be5cf0,
    0xbfe055e391e4d7c4, 0x4001130241dbdeb2,
    0xbfcc577fcffbdfa0, 0xc002cabe3a346654,
    0xc008a7998d514fb2, 0xc0051f84c29d70ec,
    0x40123bc50f383b70, 0xbff33c98fa23442c,
    0x3ff264a2637b43c2, 0xbfd09abaf330aca8,
    0x4009479786511875, 0xc00cd963043d0874,
    0x401a69dc173804b7, 0x40000f1458a7b629,
    0x3ffb37f57e2ab6bc, 0xbfd53a9c88cd6da0,
    0xc0059114308f1c14, 0xbff9b4b8ea433e4b,
    0x400611225a14d1bb, 0xc003b1e63b97863f,
    0x40031288a7b3c35c, 0x4005fef479bbc108,
    0x3ff9357f9e56e2cc, 0x3fd6760d35899214,
    0xc00d8df153a4cac2, 0x3fd4b75bde076b94,
    0xc01034d1a05cb02e, 0x3fd57f2e7a0d7e87,
    0xbffa6c618e90df30, 0xbff3723fcfd5c8c5,
    0x3ffb816d17ca3036, 0xc003c0cac3179d4a,
    0x3fee69ac37dd5908, 0xbff540f69656c606,
    0x3fc49dfa7714158c, 0x4001eb8e5de7aaa2,
    0xbfb9607c920d5ab0, 0xbfb066e990661c20,
    0xc01693a905b0e394, 0xc00212732977259a,
    0x3fe8a9ee51ca2c82, 0x3fe31248f03da331,
    0x3ff25e8a8ba5fa2a, 0xbfdba83df9396868,
    0xc010a627c39e7b24, 0xc00901a1ad440417,
    0xbfea304dc4e4053a, 0xbff272a5184762df,
    0xbfc7cb1a314f6970, 0x3ffac1a8bd95794a,
    0x400da2d979639b34, 0xc0038bc40e9e85e4,
    0xbff815c1e08920c4, 0x3ff7869752c8215d,
    0x3ff237d9d1078d64, 0xbfa4089d0b78f9b0,
    0xbff5e5bfd8052556, 0xbfe91ec8911f9802,
    0x40063577219fc2be, 0x3fe1342164dc3470,
    0xc004664a40157c64, 0x4018ca7b2096fffc,
    0x3ff46d06390e1230, 0x3fc4a27ed0369fc8,
    0xbfd6e1366b925838, 0x3fd3d99286ce2880,
    0x3fcf8fd4c15fee78, 0xbfe58e709bdb5f53,
    0xbfcdbe8b81f9b520, 0x3ff9898509e6d35e,
    0xc009c057aac36d99, 0xc00882f227f06714,
    0xbfea123ea597b679, 0x3ff4499025ba4726,
    0xbfec987646c8fb1a, 0xbffc942fd8312e5a,
    0x3ff71ae398917141, 0x3ff32f02347e0eaa,
    0x3fe2c423275438de, 0xbfac3b6b91c803a0,
    0x3ff8cd988748ce8c, 0x3fe0cc9e3af81c8c,
    0x400a388dc52a9f8b, 0xbff42e53a5050910,
    0x40014b89780d162e, 0xbffbe5290da40ab3,
    0xbff0671192284212, 0x3fc267273b5b2496,
    0xc0062f6b219a19f5, 0x4005481d21d8e46c,
    0xbfea58f6396bcfec, 0xc00ad9fa7dbd2e8a,
    0xbfd024c6c3005cfe, 0x3f9ac5474b270680,
    0xc00026c3e2c92a2f, 0x4006dc84929cbcfb,
    0xc0037c020efb4a5a, 0x3ffebb9ea85ae9da,
    0x4007c20b510456b7, 0xbfe0e5c9f2ebe843,
    0x3ffd6f7dc5ac3129, 0xc008fa83ffbcb4fd,
    0x3fc2499d18775774, 0x3ff5693724b5d56c,
    0x40070caa0edb31d2, 0x3ff5e816f8cfd0a8,
    0x3ff0b273f8396425, 0x3ffbd64bb2241d87,
    0x3ff5f07b6d312c78, 0xbfebde4fdab7e52c,
    0x401118d3e5847ce4, 0x40090c430f3a3730,
    0x3fb9261ab5b09ba8, 0x3fc7660d6994415e,
    0x401298eafa175606, 0x3fe8b473e24a467e,
    0x40000a0fed1a2251, 0x3ff816ad1a837ac6,
    0x3fd33a777ec3280c, 0xbff7553babcebcb4,
    0xc0041b317c194862, 0x3feb91457df540f4,
    0xc006d46756131aa8, 0xbff43415d16fcba8,
    0xbfd7cd008031be30, 0xbfd9712fc101ba57,
    0xbff2990972e795de, 0xbfd036be1bd200c0,
    0xbff8860d470190c2, 0xc0011e573374d0da,
    0x3ff4c9466fec853c, 0x3fe2d396950b732e,
    0x3fe8bcd13559a593, 0xbfeea3532695d38c,
    0xbffa38592f55d17c, 0xc003dadc182b617c,
    0xbfd2c4a96397ded0, 0xbff959c37ea05e14,
    0x3ff1609154f7840b, 0x3ff6913b5f54f85c,
    0x3ff58843c26351b0, 0x3fe8518d77eadd64,
    0xc00aa5147880e8b6, 0xc011bd4fc9ed4053,
    0x400a9ae95d8b4ffd, 0xbfc55faf8bb27390,
    0x3fd47e9e22ddfa15, 0xc0002e6d3ca0651e,
    0xc00c716354ec9a03, 0xbfd786dc7c3f123c,
    0xc001917f5bd88320, 0x401285002311d2b6,
    0xbffd9546ace98fd0, 0xbfeedb1c72d39bd2,
    0xbff28475f51d2f3d, 0x3fde6ded916722cd,
    0x3fe0f5cf8d276928, 0xbfe3a73ef049d14b,
    0xc006d501a8497e5c, 0x401c0c609cd512c4,
    0x3ff3256637c08ce0, 0xc006a6ce0f82c460,
    0x4002278b62812529, 0xbfe2e14882110570,
    0x400c9ee42b084f26, 0xc0107dc2e6ed0c9c,
    0xbffd613dac38c7d2, 0xbff4e01cf022892c,
    0xbfe69140269c82a5, 0x400151bf49d6eb3a,
    0x4003d3540636c49f, 0xbfebe1efd15c48ca,
    0x40144f446b2b003e, 0xbfc39912daa0f318,
    0xbffaae6df719f127, 0xbfcb5a5e30fa5950,
    0x3fdfdab130432dba, 0xbfe68971cdceefec,
    0x4012215a791da536, 0x3fe32e6c4bb9d663,
    0x4017f6916d074ab6, 0x4007a11cea35de0c,
    0xbff87c148a36a2aa, 0x400245cf3ceb6a95,
    0xbffa1015d3ba21e6, 0x4016162a608bca6c,
    0xc010498562ef4462, 0xbfed538b9314cbc2,
    0x3ffa1403eff03922, 0x3ff0b99d50d9a737,
    0xbff6154af25f7a6c, 0x3feaf3d28ae90d2d,
    0x3feecb30c10076f7, 0x3fe6389673d33f27,
    0xbfdf623b1a099902, 0xbff691ae934a3997,
    0x3fd9f469c0066bee, 0x4010b857d374fd3c,
    0x40002e564a570423, 0x400c966d43cdf2cf,
    0xc005b124424c5778, 0xbff9bde88d86c55e,
    0xbfdf9824284ae894, 0x40124edeac3fb0c6,
    0xbff61bae351c9bb4, 0xbfe5dad1754511e1,
    0xc013fd3dc6f226a5, 0xc000d53fc7e1bd99,
    0x4009b8d3b353731c, 0xbffe37163b2f90e4,
    0xc0111f95a25ae1c2, 0xbff67c04a628d4d9,
    0xc0098de5cdaec200, 0xbff42e5f53047e5f,
    0xbffc4138758a75d7, 0x4011c99e3766ed3e,
    0xbfe76d6cbbc5826b, 0xbff69fc1f5a7c096,
    0x3ff7e418ce644369, 0x400ebe86992aa674,
    0xbff2025027e424b4, 0x3ff7b00d0cca005e,
    0xbfed34299c2687cf, 0xc003f78b10a8b062,
    0x3fd82c8b3268a8a0, 0xbfc386deaba2ff30,
    0xbfd1f97915507620, 0xbfe7419d872c8de8,
    0x400cd9cc43b22271, 0xbff312a90e6ec812,
    0xc004106356af7a02, 0x3ffd1d58d13c700a,
    0x40019e270aca6520, 0xc00b131ee0dacf40,
    0xbffec1e51337e7e9, 0x400440af36d741dc,
    0xbff63f645d046bd6, 0xbffe8ae10c1e3f09,
    0x3ffed60d32599383, 0x3fb016b489eac3e0,
    0xc005bd17eb2bbcdf, 0xc0110d56ede632b8,
    0x3ff21ede8863ec99, 0x40088e55b6a7c9ae,
    0x4005463c5df413dc, 0x3fcfc69160be2de0,
    0x3ffe7bfc88801eef, 0xbfe49b1d317a484e,
    0xbff7562da5ab92a2, 0xc00a6e20d8634596,
    0x400121fce021755a, 0x3fed7504921205f2,
    0x40028e9a8f1093b6, 0xbff5e53764371586,
    0x400393dc9123655d, 0xbffc5d563cd0028e,
    0xc00e923f0fc18095, 0x3ff1c0dd464448f8,
    0x40136c3973119be1, 0xc01061e424a970c6,
    0x3fd324713b0d8f8c, 0xbfcb5c222bd425b8,
    0x3ff42925712aa695, 0x400683aefcdafb0b,
    0x400e637e78b6bb1d, 0xbfdfa2caed1f9a67,
    0xc00e3d81f9df73df, 0xc005f76add030a98,
    0xc01078c3f03c2782, 0x400b12fe32796038,
    0xc01175c4a66d4f65, 0xc000710291915ab5,
    0xc00064011024d7f6, 0x3fffee3654e221f9,
    0x3fe55223624acb38, 0xbfe979a8dd83cf73,
    0x3fdf4b61d53787ea, 0x3ff6f887b850885c,
    0x3fb3be8e98466f58, 0x3fd277c76f0a6f3e,
    0xbff2fb7f44413630, 0xbff59c7e716fbd83,
    0xbfff05faf80a9516, 0xbff9f150a6e2c27f,
    0xbfe39887c9c82f1d, 0xbff54f7bdff47b40,
    0x4007f7ab927c0e00, 0xbffccaf6801908c2,
    0xbff7074d8ea0de2d, 0xbffe6d781e5f60c9,
    0x3fc59d36eea855e0, 0x4013665b915476a6,
    0x3ff1b341d9be0284, 0xbfe3040b346875f8,
    0x3fdb1f780e6f253c, 0xbfe2ae58a1f3d1fe,
    0xbfd01910f15bd7f0, 0xc00ee48871306944,
    0xc00385192420e096, 0xbfe00d3a4717df35,
    0xc00915796aef6f52, 0x3ffa7fbfa5aaf074,
    0x400a59800b66b31c, 0x401b1f41b85aee64,
    0x4006fbc28cf0a958, 0x400328e11f3adbe5,
    0x3fd6b3120f4a4891, 0x3ff4e0460732c134,
    0xbfd36a15a732f846, 0x4009c5071d8b44c7,
    0xbfd18d2a3d7ba856, 0x3fe5e2c0fa5ca862,
    0x3fbef9657b08e660, 0xbfedbb677ac8b5be,
    0xbfd485b348c7ae98, 0xbfc4a22ecce8e540,
    0xbfe9da9628e4cf3f, 0xbfed5453eecc5fe8,
    0x4007eb8adbe10fdc, 0xbff6921026436911,
    0x4002bb61c9118dc5, 0x40008394a82a65ba,
    0x3ff42a014b20cdea, 0xbfcd6ee6a21de190,
    0xbfd2b415851a9748, 0x3fdfbe233b6941ae,
    0xc00373639f31a014, 0x3ff605da39b6c36a,
    0x400408cbdc980eae, 0x3fe9e114f4aa08ca,
    0x3ff7994bc75149a2, 0xbfd8c41e9e21e718,
    0xbff5a1037edcedee, 0x3fde39459f4cd63c,
    0x4001997e96209ee3, 0xc00257e0b9745458,
    0xbfca5a6974fbd7c0, 0x3fe2b3877b40c8ec,
    0xbff90052d1c0627c, 0x3fe46dcb2a2c5ae3,
    0x3fc1f23480c62940, 0x3ff01e3636e7ffde,
    0x3ff4bf8823901301, 0xbfd30f699d079438,
    0xc00519b3ede40072, 0xbffa5fa8a14f26bf,
    0x3ff98f470018f442, 0xc0065410aa6b23e7,
    0x400c5c963bbe3797, 0xbff28006a47c98ca,
    0x4000837389848d5f, 0x400af2c6ca2cfe5f,
    0xbfeeeffa85d6c970, 0xc007077560cc3faf,
    0xbff125e06289b1e5, 0x40025b920d64908b,
    0x4010ad56cd22f258, 0xbfe39681ac301a73,
    0xbff1a48743261404, 0x3feeadef178a2e08,
    0xc00339661c617b62, 0x3ff2923e8704a200,
    0xbfdc24e18e4f03a8, 0xbffd362a263ddb45,
    0x3ff1a1716a748ef1, 0xbfde02d7d700329e,
    0xc00062dd84f34018, 0xbff4e5a338a68674,
    0x3fdc7aac73254d8f, 0x400240451a5b6a79,
    0x3fea0e75db2cd40f, 0x3ffbb29063673586,
    0xbfed138b25919240, 0xbfb973aed37dbbf2,
    0x40059ebc14ba1868, 0x3fe35d99edacaa7e,
    0xc005909875bf73bd, 0xbff2b26a6283c929,
    0xbfecb1ed9da4c226, 0xc000abc8c51fe8aa,
    0xbff69f93c4e1fbaf, 0x4005b04e73682edd,
    0xbffeaec4f2f7f9a1, 0xbfd0613beb10723a,
    0xbfd071c478fe311e, 0x40097a55c791e321,
    0xbfe1d7af853bc0d7, 0x3fc76882e37a6bbe,
    0x3ff60777268c6d8c, 0xbfd110e38158ba58,
    0x3fd169b86a0c6a00, 0xc00416fefd2ad3dd,
    0xbfeaf59d06fa2a9a, 0x3ff8a07afa0404af,
    0x3fe3432e9d90535e, 0x3fca49cc028e5763,
    0x4012f4ffeb6217d8, 0x3ff24c045a001f54,
    0x4003a08e9f696242, 0x3ffb1d377261ea5e,
    0x3fe5ac92051563b9, 0xbfe1357084922bc6,
    0x3fe312f576fab894, 0x3ff9959614eada10,
    0xc0015572ca1d4832, 0xc00f4f4e61018b7a,
    0x40108f1a03d5209c, 0xbfefd89ed53d8b48,
    0xbfc7ba1b2ff76ef4, 0xbfed1bdf195a8c67,
    0xbff4d65b7b025806, 0xbff4275ea0bc0c9c,
    0xbfef81be269a22d8, 0xbfe3a8472037bd06,
    0x3ff25ea00584c1c5, 0xbfe0fde5825d2964,
    0xc0002bbe0bb43b19, 0x3ff1c8d7fab1af36,
    0x3fffbe6768e89f30, 0xbfb3e6a621a5eefe,
    0x3fe228d02ae45fae, 0x40003ab6e975ae24,
    0x3fb9f001f007aae0, 0xbff4f5269608c6c2,
    0x40117083ead04c83, 0x3ffed49a9fe024b6,
    0xbff6c31e743cdbd8, 0x3feabc6235182acd,
    0x3ff153120f4fda2c, 0xbff442f2f13f7a20,
    0xbff8ff28179a395d, 0xbfe7240118eec8ce,
    0xbffec8f7bb2ec4c0, 0xc0080176387b50da,
    0x3fed3ed6bc33ba86, 0x4006502776cd6f1a,
    0xc00d3969d20037d5, 0xbfef60df3d9b1019,
    0x3feb59a0649c28a0, 0xbfdb3c83d3db408c,
    0x4003ee7e7e97388d, 0x3fc519b8a09a2b40,
    0x3fe8456d6bca7628, 0xbfaef25dd6abeea8,
    0xbfec33c722e24e86, 0xc018cd5fdf80254b,
    0xbfe3ada08108d8db, 0x3fd1d8b44724fb64,
    0x3ffebd205e3ede38, 0x400b4c88e7e1496c,
    0xbf701365e3a9fde0, 0x3ff0ed3d181c1b5b,
    0xbfe0852e56d9ca94, 0x4013fd5231bf231c,
    0x4006e6e0a9294117, 0x401306b3ca27fdbc,
    0xbfcaa41e025c814a, 0x3ff935c5d1f789c0,
    0xc0085a530dbb342a, 0xbff8263c97044fe2,
    0xbfd18becbc8b814a, 0xc00bd85bc8bdfa30,
    0x4006ad3af2bf55ba, 0xc00f4738520d629f,
    0x3ff3d9601e39b675, 0x3ff43c276ed4b732,
    0xc007334301602e62, 0xbff90303114f93e2,
    0x40018f17f0695fd2, 0x4001c35f6113ff42,
    0x3fc1c491c9a93ee2, 0x3ffad158907647e2,
    0xc0030f71fe691ae0, 0xbff16a76dede27c0,
    0x3fef15f84f583860, 0xc004b676172d2e5c,
    0xbff538e36fa9c45d, 0x3fdfef0aecc8f5a4,
    0x3ff7d86f1dc11d36, 0x3ffc6bd77237cbfb,
    0x3fd4d57fde904bd0, 0xc00aaf073819eeb4,
    0x3fe8dddcb3f389d4, 0xbfe46eef980cb63c,
    0xbff504d98bf45846, 0x4004db3635026a67,
    0x4005bcd15383c504, 0x3fe8ce6839939b01,
    0x3ff5fa9526cf1ade, 0x400d2f2ca3710ebe,
    0x40089b63b77d7d5d, 0x400c330ebfbf6ef4,
    0xbfe953b0c56429be, 0x4007edf16bc5917d,
    0xc00ac1d4e3224ff6, 0x3fd5c1b0434f2af8,
    0xc00a1bbd55e8e11a, 0x3fe8d7ab61cfabb8,
    0xbfe77408f7675fa5, 0xbfbff7f1a2bea2bc,
    0xc002b104d6f1f164, 0x3ff9ff9d188bf660,
    0xbffeb78cbc375408, 0x3ff0b58b608b7036,
    0xbfd5923f52c5e198, 0x3ff73e9632fff546,
    0x3ff04b650ea8ab78, 0x400766e08480813a,
    0x3fea5eee414344c8, 0x3ff75eec27c3e770,
    0xbfc2a4f596906730, 0xbff31963f8bac19c,
    0x3ff9e55709eaaf67, 0x3fee70b67e728904,
    0x3ff6104048660eae, 0xbfe8e527cd1bd8e6,
    0xbfef8f9581a1d648, 0xbffffe6a4bcaace6,
    0xbfff71c434a4be2a, 0x400c16b8f324e7f7,
    0x400f305418009b88, 0xbfd87c9cb097dd0e,
    0x3ff94c7f7d2fcafa, 0x3feb5aa3ab954a8e,
    0xbfddcff185939428, 0x3fd94f6cb49b1706,
    0x401899c4d8373c90, 0xbfe3961b8e1d16d0,
    0xbfe4dd5dbac740bf, 0xbfded89774943444,
    0xc000c2f0bb28b5e6, 0x3f9582c18b3ef500,
    0xc005f40fa0fe6cc0, 0xc0005bc36b7af086,
    0x40188c35030cf894, 0xbff08e414ac09e54,
    0x3ff4c58c1ae450db, 0x4011e1c6c1c37fc4,
    0x401572578e0119fe, 0x4015c9fff1fd896e,
    0xbfefae6422a04784, 0x3ffd664aa5f8c0b6,
    0xc009426c3b113726, 0xc0138acb2b4b5540,
    0xc006ea15cd7c3bf0, 0x40044c0543335b94,
    0xbfdf73379ab392b4, 0x3fe8f8199800aeec,
    0x3fe6c05b7158db1c, 0xbfce2e349e1bafe4,
    0xbff0c9a299b59c46, 0xc0062ae98e15fe55,
    0xbff5f21df474d2f9, 0xbff963c19ef3ac88,
    0xbff0c2f1d1353a74, 0xbff37ec0b9dad7a8,
    0xbff062493dbd4a1c, 0x3fe9e2e9fc97226f,
    0xbfff70ae7561e002, 0xc0062eaec04b032d,
    0x40101dc4b6539838, 0xbf9a2fb9237c9340,
    0xbffc0e54301ca178, 0x3fc466e06b9c3b68,
    0x3fbbfa36d03116b0, 0xbfd971fb45a128b6,
    0xc000ef6660a67f9d, 0xbfe41149d4a012d0,
    0x3ffda0c897f7478e, 0xbffd9272765c1f5d,
    0xc00037dcdf23d1e5, 0xbfe3bdbbb35fa0c6,
    0xbffd23213fc4cc30, 0xbfdac6d84ebd4be0,
    0xbfc5667b647c2ce2, 0xbfde70754b7166aa,
    0xbff5cdc86f729b6f, 0x3fe545280baf1d00,
    0x3ff0cfd59a686366, 0x3fd4de8f422cb7de,
    0x3ff27cde0285a5bc, 0x400529e7e475d0eb,
    0xbff895a6e054219a, 0xc0116709b02028a5,
    0x40157932dfc636f6, 0xc00aa513ec109134,
    0xbff4804023c5f4c2, 0x3fbb4ce8d70c42e0,
    0x3ff9dcb438a88efd, 0xc001de3316da9ca1,
    0x40024e4f6622802a, 0x3ff6ed1e5b3099df,
    0x3fbad3234960a970, 0x4005d38c728f842c,
    0x40079775d3648d05, 0x400004e3c2508b11,
    0x3fded032a11a679a, 0xbfe8fec59187f657,
    0x3ff63851515d8f24, 0x3ff5cd1f6df05f0a,
    0xbfe3650e54cb9142, 0x3fe46df2e31572a3,
    0x3fca9ed4136c1ab4, 0x3ff67d3896109d9a,
    0xbfd96cda29085383, 0x3ff8222607222106,
    0x3fd6ecf412352b34, 0xc0133a155e0d9f18,
    0x3fa9d62a60ed1980, 0xbfcce44bbbc5b720,
    0xbfffd545b31f8feb, 0x3fd40ed2831d61b8,
    0xbfdbbaea80808230, 0x3fe3e2ef964511c4,
    0x3fdf69ec1cd6c7b8, 0x400a60ea23f1d1f8,
    0x400a1e1ec3fb749c, 0x4007b1dd8c1bd81d,
    0xbfeb9ae8a62c1624, 0x40042ba497961032,
    0xbfd976d9461480f0, 0xc0026a03e8a80a2c,
    0x4011a9ade1ba5c4b, 0xbff1b285d592b9cd,
    0x400255bbf47e2f32, 0xc001a6f77cc758d6,
    0x4006bec9f33a2370, 0x3fec28deed885ee4,
    0x3fdf0ddfee22e098, 0xbfe83b289f154ccb,
    0xbfe594b2301cc9c8, 0xbfdb650982c18b24,
    0x3ff8c0e96f82f67f, 0x3fd2d650903cc3c2,
    0x3fffc002d0bc09ee, 0x400cc16858413a8d,
    0x40020cfd6dcbd6f5, 0x3f90924a2b1a8160,
    0xc0012b9556aaea6d, 0x3ff2149918b97c3d,
    0x3fe22a838f664312, 0x3fffd66fbdc8dd8c,
    0xc0154e5da924e7fa, 0xc0062404356205fe,
    0xc00185f15dd78275, 0xbfde662a088c6222,
    0x3fe12924d453770c, 0x400380b7318f5c32,
    0x40162700a3d12696, 0x3ff60a2e74c7c60c,
    0xc00cce20b85b87d4, 0x401192f2c375468e,
    0x4008c3ad134926e0, 0xbffde0fb93c7185c,
    0x3f8c0b4ba145c2c0, 0xbfdcfba461329041,
    0xc00be4b3a08cc42e, 0xbff3eb3fe6ebfb8e,
    0x4005db2b0765c944, 0xc00d40902d3a1404,
    0xbfe86acd04e9a69e, 0x3fe1f9bee158d9dc,
    0xc007992270240da7, 0x3ff6e56236b741ad,
    0x3ff89b7e2ac008d2, 0xc001f7fb682804ee,
    0xc00eed9c552f2e36, 0xc003b6ca5a6f4343,
    0xbfe275f9ae169345, 0x3fd02613fb1f1188,
    0xbffa4109155abb24, 0x3feae9672a1b6ccc,
    0xc0130519534d0a76, 0x400348e752523f98,
    0xc01065692fa519e4, 0x3fe3546b8550320a,
    0xbffc71b1af25fb6d, 0x3ffbc3a1097f88e3,
    0xbff27b02f694a4c4, 0xbf8987cc78544980,
    0x4000fe09ce23e598, 0x4013a471c102561a,
    0xbfdba169ad9df871, 0xc0037d1f3a77f8c5,
    0x3fd296ada2537edc, 0xbfee66b48c9f63b2,
    0x40101aa4ea471d99, 0x4006efe5fd1bf59b,
    0xbffa9854c1ce7e71, 0x3ff368d36b0b8444,
    0xc002d6cf848e7884, 0xbfee4425d1e9e144,
    0xbfe0770dd8497751, 0x3fd548cca01d5d34,
    0x3feb0571682f9a82, 0x400757da22f98513,
    0x3fe50bfd0b7522a6, 0xc003a445423dac5c,
    0xc00312663afd71b3, 0xbfda18dc0e230468,
    0xc0134528c8599ee8, 0xbfc973a9c65a7430,
    0xbfccfcdc86f57607, 0xbfd81661295040d4,
    0x3ffb14c7a1c88d6c, 0x40126367716c19cc,
    0x400338a644ccdf21, 0xc00073197e4a4a72,
    0xbfed4e5b2e75ca52, 0x3ff825e6f419d9fc,
    0x400ca2f715c9866e, 0x3fd4b9253f59aa11,
    0xbfab44afeeae8fc0, 0x40076243882388a0,
    0x3feb30e646434cc8, 0xc00c9534fc2460a6,
    0xbff7be3c8a5041d2, 0xc005836994008a4d,
    0xc001ce703d5a670a, 0x3fe0161db0103c2e,
    0xbff792fa8aae0eb0, 0x3fbdbbc9ab4d1440,
    0x40065940a4038e60, 0xbff7d3caeb6e5365,
    0x4008e077413cb05e, 0x3ff79e21ef268bc2,
    0xbff0bfd371da2538, 0x3fef2989ec71bd81,
    0x3fe864a8cc8c2e26, 0xbfd69f1cae4a9af8,
    0xc018f62fe44a1a82, 0xbff521008a40975c,
    0x3fe9c62780512bee, 0x4006165e3e4500e2,
    0x400770762a6cb84e, 0xbfb0c2026c097776,
    0xbfd396a87a3a9890, 0x401346188367fa1c,
    0xc00657bddb2963ec, 0x3feb4eb74e7da40a,
    0x40122773f7fe5ad4, 0x400f6492de81ac3a,
    0xbff0db70614f4478, 0x40178b494fcf6699,
    0xbfcf4c6f7386db04, 0xbfbf5a725c7e5508,
    0x400794f61d0329d7, 0x3ffbe68b41fdb5fa,
    0xbfe36080c9af7dd6, 0x3fe2c1e0a37a3928,
    0x3ff3b3d892c979fa, 0x3fd68f4d38104318,
    0x3ff95d4b0722549a, 0x400576af6feef6fe,
    0x4011de0eddb61e75, 0xbffdfd4c04ed8348,
    0x400c2e3c039b0420, 0x3ff752fcd9194d08,
    0xbffc2a338cd02e4b, 0xbfc765fb697d00cd,
    0xbfe992ed22174a0e, 0x40055f6af23d3380,
    0xbfe939dc0fb16d1e, 0x3fd5bdcfc1fdb4e8,
    0xc003be6188e9ba8e, 0xc016f5de9957310c,
    0x3fe600e335c96323, 0x3faf8fcb64d6a458,
    0x3ff8b7ccf106b370, 0x400468599360eccd,
    0xbff08f5077485c27, 0xbfb5108a0ac6f420,
    0xbff174d3efc47b75, 0x3ff5864c161898fe,
    0xc00aa1145ee1213c, 0xbffaec1589a3893f,
    0xbfe89b31aac912bd, 0x3fd3146a826ea034,
    0x400aef9c3a55acdc, 0xc00d5825b4d9c8d0,
    0x4007fdd456b9bd3e, 0x3fddc2be13c39a48,
    0x3ff3f20848e6b9a2, 0xc010fcb7f9fe3522,
    0xbfe0d488edc4a17e, 0x4003e8b75e181049,
    0xbff0224af2e35ce8, 0xc0075fc6e7f635c4,
    0x3ffdbf5d5a26e787, 0xbfe1cb7d9f02603d,
    0x40143716fb00a61c, 0xc00eb16ddc2ba212,
    0x3ff94d818e281f74, 0x3fd8dc941ffd92e6,
    0xc014730d9d13813b, 0xbfd60e9520ecb690,
    0xbffc89cd936f5541, 0x3fdbece0129c3d42,
    0x3fd0bc4459e7eacd, 0xc004c5d70a81b889,
    0xc01295a4525a1e38, 0xbff4bd3663c8939a,
    0xbffc6b3cf28a8902, 0x3ff1ae1fe8f5ff5a,
    0xc00bea7af0a643c9, 0x3fe4a7ac250b9564,
    0xbfcc0e0573c5e62c, 0x400cdde5834fd6e5,
    0x3ff393abbb497074, 0x3fe381cd7522eeee,
    0xbff64ecd32e70827, 0xbfef186eacd43f60,
    0xc00d66999b09ced2, 0x3fac30c5e845ca40,
    0xc007944659ed5196, 0xbfed18e522bff157,
    0x40110c75d78f8532, 0x3ffa80d9016c83ca,
    0xc005de68da691e87, 0xbfe892fbc538a5ea,
    0xc0067180e6bf4b15, 0x3fe642e2584cbb6a,
    0x40039f3d770621f4, 0x4008d744bb8b4fe9,
    0xbffb58a42c390c7c, 0xbfbda521f733c390,
    0xbfd688daf05f29d0, 0xbfae0b8135289b10,
    0xc009da5adae018a0, 0xbffe285c18cb707c,
    0xbff1796ac9fd28de, 0x400c66587924f43d,
    0xbff1765fecd58cb2, 0x3fecd950adec0aae,
    0x3fe166a003fdb078, 0xbffb2bb88378317f,
    0xbfc3533277b76994, 0xbfca9f0751c22180,
    0xbff39fe61549bc46, 0x400255ed141952ab,
    0x4005c3988a2d7b22, 0x3fe29963a1e13b24,
    0xbff990b8393fb212, 0x3ff2c64dc37e3bcb,
    0xbff05ce4e93e09b0, 0xc006106340cbfe31,
    0x3fdbc43c3a613d3d, 0xbff919ab8e2f75b2,
    0x3fe4e429b2304cb2, 0xbffd815fc946195e,
    0x40103be2f1ab432c, 0xbffeb1cba91ae1b2,
    0xbfffb691a1546dc8, 0xbfce70ae5eba5750,
    0x3fead5bae46e6d8a, 0xbfdda64d05ec16e2,
    0x40006d26aa5152de, 0xbff9f27b40e4562b,
    0x3ff8b3e0fbb3402b, 0xbfea64d96e84e0c6,
    0xbff202cc35ddd95a, 0x4010eab0301fe51e,
    0xbfe7f8192c1734d4, 0x400b1e8795c2b398,
    0xbfef021a3d238a0e, 0x3fda6c473b37681c,
    0x3fe8e12b767bf844, 0x4004b50b0ca7456d,
    0xc00328bf58800cbf, 0xbfc44b75508876c4,
    0x40000b4c451f81ad, 0xc00cfe56683a55fc,
    0x3ff9862231fa10f6, 0xc00512a45624747a,
    0x3fd1678da0819132, 0xc001158cc88c1c25,
    0x3fd61e47885c224e, 0x40001df08db90250,
    0x400a49089605c3ee, 0xbf894e998a0b28c0,
    0x400ce79058d8753a, 0xbfead7e828b89dae,
    0xbfe41f2bcfc974d6, 0x40061be40e90e897,
    0x3ff3e2668f188efe, 0xbfe17cdb36391972,
    0x3fcdcdd293722bd0, 0xbff9dec168428180,
    0x3fbdc88956d5cc20, 0x3fe9544683056c2e,
    0x3ffb651a24aee7bf, 0x3fe632d918bd75ac,
    0xc00a1779ca7a784c, 0x3fe97f8a480b8076,
    0xbfd376958783c050, 0x3fdf21ab654f1848,
    0xbfebabc24ec613cc, 0x3fdd692adff8b0d2,
    0xc009dbd35f4b6e0f, 0xc0018c766be035a6,
    0x3fee4b372034bc56, 0xbff845d2489f6cd4,
    0x3febc5d5815ee6b8, 0xbfd5e4376cd6e1b8,
    0x400acbfdf015c2c3, 0xbff59afe89a332e4,
    0x3fd2946d24f8e5e4, 0x3fb07c28ccaa38a0,
    0x3ff32637441e7196, 0xc00a131ceb77e34b,
    0x40054ac1dd6c465a, 0xbfe2fb4c25538c38,
    0xbff2747a7f961b8a, 0x3fd997af02d89380,
    0xbfdf8564837957b4, 0x40031c007467982f,
    0xbfd86edc5dbc35b8, 0xbffaa1b6504535b1,
    0x4004c5cda57c2f09, 0xbffb2c9059b92478,
    0xbfe6e5abf386038e, 0x4003f6d17c0cf104,
    0xbfeeb12048b9ea18, 0x4002bf191021dce7,
    0x3feaf8fc0be582e4, 0xbfe6e48bb7714c38,
    0x40016237af12db62, 0xc007fa7d7f3dd77a,
    0x400349717fe87d1e, 0x3fec210c550dfafc,
    0xbff12fb604398e28, 0xbfe2d4364ba70b09,
    0x3fface88e040c1e2, 0xbfc0ae716fc792f4,
    0xc0060b813742d34c, 0xc002a7204cb355cc,
    0xbfe260f0df227467, 0x4010d5cb56d18c14,
    0x3ffc882fef25af39, 0xc00123657217b7cd,
    0x3fc917d341baa458, 0xbfe795c803953934,
    0xbffa2026f3be168a, 0xc001574ce77f8662,
    0xbfe947990d0c3380, 0x3fde70558c87326e,
    0xbfefd9ecf25ccb98, 0xbfe2bf79f1770883,
    0x40040550cbdb6f8c, 0xbff07168cefb432c,
    0xbfded7ecdf1ee6f0, 0x3ff74532ae241b30,
    0x3fedca8b7e4b5bd8, 0xbfe6f2d1c9548778,
    0xbfd311766fe6d148, 0xc004eaab83edbbb9,
    0xbfee5ab8803eedb7, 0x3fc64be77bacba30,
    0x3fe8f24b8ad04eb3, 0x400cb646811d7ab2,
    0x40030e442dfb3167, 0xbff9c00ac02b0648,
    0xbffa2904f3674810, 0xbff1b2840999ed84,
    0xbfdb0cc3874c73c8, 0x3ff8c586a8cc48e3,
    0xbfe8b4091a09f54c, 0x4006ab1bed0e7e06,
    0xc01060e1c44b601a, 0x3fea3d6342dba2dc,
    0x400e2c66fe4d9e8f, 0xbfbcc0819ec16de0,
    0xbff5bc778b6bad16, 0xbfb0343d3dd92270,
    0xbfeaba8c4ec94720, 0xbfe30090ea9c47b1,
    0xbfb5ac5c833a2328, 0xbfe37c4a151fd600,
    0xc00c8333f4cddd6c, 0xbfd40db30a9ca250,
    0x401181e64d32aa74, 0xbff93c7312e56527,
    0xc00bb4213cb2aa63, 0x40057cb660f74d28,
    0x3fef5183538f2ad1, 0xbfdfc661ffa5c870,
    0x3fdaaa1bd8f2d9ca, 0xbfe317cd609d223d,
    0xbff78771440f70b3, 0xbff6886d673b8764,
    0xc015fd0d531533c4, 0x3fd1f8d40f759444,
    0x3ff2adbd350c02f8, 0xbfe125900a8a2eb4,
    0xbff7cd4bec9ea8e9, 0xc00ec1b5fa92f6e1,
    0x3ffe642934201848, 0x3ffefff650909758,
    0xbff968f9fe49a277, 0x3fea7bc4cd6b7ee6,
    0x3fe0b75863c7fd09, 0x3fcbe82d32f7b150,
    0xbfe0c6ed6d26f956, 0xbfe68e39a51a3514,
    0xbfeaf1d751433864, 0xc00293c579c9948e,
    0xbfd250321f95509d, 0x3fe7cf0849df8d16,
    0xbfdf9af9025b93c8, 0x3fc6acdade5eb510,
    0xc0064f230b7fadc6, 0xc0115d46a01d1d1b,
    0x3fece99c0ed66ab7, 0x3ff4727fcb6c723a,
    0xbfef68a5180f81d2, 0x3ff9aef1b9ae3e1a,
    0x3fbf1cffd32f84c0, 0xc0013ecdedf0ec87,
    0xc000c53ea3c4aeef, 0xc012d389bb96b638,
    0xbfdc51a6386c0482, 0xc0081803d2ebea84,
    0x3ffb0c6697250484, 0xc00caee9e887aee0,
    0xbff6d097a0f4c002, 0x3fd47c73824e60ac,
    0xbfbf71214a21f718, 0x400a2c74fde1060d,
    0x400b67e102d91e58, 0x3fce826bd81e21b2,
    0x3fe4d856c517efb0, 0x3ffbb0ec27080200,
    0xbfe6acec994b290e, 0x3fff9542df3fe9ee,
    0xbff3dc52cc2da683, 0xbff2152d9a408b5a,
    0xc0008bc948fa8c8d, 0x3fef26440743db68,
    0xbffb063c44abd6be, 0x3fc5fab2deac17d6,
    0x3fdc05eb2021890e, 0xbfd3d7226c11e18f,
    0x40019165361a30eb, 0x3fd350970049d3f4,
    0x3ffc27e1198bfa98, 0x3fc1bf1cfe0e38c0,
    0x3fdae4d4cdacadb4, 0xbfd00e095302d41c,
    0x401262adeddb3ae7, 0x3fe461cf1963e898,
    0x40008252fb4f5a52, 0x3fd2860f76260e2a,
    0x40054bbe1f605bec, 0x3ff3639cf751b77e,
    0x400da94f413a3c7b, 0xbfe28816857a3ce3,
    0x3fc6361a2dee0b48, 0x3fe21f5d2df7eca3,
    0x40009def10099b83, 0xc00bfda7f5987d25,
    0xbfd81d75e29c1fc2, 0xc0048870a02984d1,
    0xc00e5b7837952049, 0x3ff6e7c68fa45998,
    0x3fb358aa20ff0b60, 0xbff318c58f762fe4,
    0xc00682dca352b64f, 0x3fda0ff711338613,
    0x3fe69cf70beab826, 0x3fdf44d450ed7ea4,
    0x3ff9061704b3d742, 0x3ff850e808cfa606,
    0x4011082d85876b2b, 0x401314e85ab30c7a,
    0x4011da18d0b5fcf0, 0x4007eb8b749fce46,
    0xbfd7cc6b9fad5f14, 0xbfff6fc4fde3ad84,
    0x3ff2074cc0b75e93, 0x3ffab004caea7312,
    0xbfb51b9f834a7ac8, 0x400d1a2fd738e085,
    0xc0030de93906339b, 0x40031abcd7d3da08,
    0xbfffee5eac70ead4, 0xbff2f5a453028c0e,
    0x3fce86719a7a4658, 0x3fe09722f3785705,
    0xc009fe74b5d8abef, 0x3feb666c145fbb08,
    0x3ff6a900026ae30c, 0x400917a5cc05f368,
    0xc0103202846078be, 0xbfe39dfd815e6504,
    0xbff39676ef578218, 0x3fe1461fd4149bf4,
    0xbfee583db6cd3178, 0x400a6d9e66c9b040,
    0xbfe2e911adfc926d, 0xbff40fded65956a8,
    0x3feee6f7c705fc64, 0xbfefc6bcfeeebd76,
    0xbfd2146b8a02da1c, 0x40033ebdca0a448e,
    0xbff8a4a21496d606, 0x40016cc0b28bc96f,
    0xc011171537a86e14, 0x3ff68df6849fabeb,
    0xbff243afd818a1fa, 0x4003e9d5ed831f95,
    0xc00ca691007d618b, 0x3fa1683e9a14c900,
    0xc007507c9712ceee, 0x3fca874d590ed404,
    0x4002f7b904de5d58, 0x3fff9acad6fe632c,
    0xbff8c0f0e5489f07, 0x4016c872b1a26b32,
    0xbfe3ad6caa276041, 0x3ff394a8cb2107ff,
    0x4008fe106c07abce, 0x3fc276827c20e524,
    0x3fe4e12d6878a0b9, 0xc00741914c778a08,
    0xbfff26459e1d4f08, 0xbffdf44c8ce9e53d,
    0xbfe5538c81384f58, 0xbff39655a3793227,
    0x3fcd80e7300dcb18, 0xc00b533e8c6b4d9c,
    0xc01a0936793f9e65, 0xbffefc0f68265be3,
    0xc001d3e98ddb1ae2, 0xbffab95ecc57c96c,
    0x3ff7d1bf43c7fa02, 0x3ff59b5ef83d85ae,
    0xc00417c262f7257a, 0x3fed14cf371a9e9e,
    0xbff0cfc3c33ccbd0, 0xc010a5ef8cb3a4b4,
    0xbff550a08a81315c, 0xbffb3e53f4042eca,
    0xbfe58276e5705ff4, 0xc009a09365448dd0,
    0x3feb21cce8969b78, 0x3fefb8c61af73864,
    0x3ff70e65bdee4ae4, 0xc00efd2abd09802a,
    0xc004d33a5f481302, 0x400adcff342bad20,
    0x40123d762575a99c, 0xc011f9b261e959cd,
    0x3fd502b0a43b07d9, 0x3ff0e057ac044267,
    0x3ff58395d27c7128, 0x4006b549d72c2bde,
    0xc0010187ad3aa7b4, 0x3ffb0fa414ced044,
    0x4003dcd5ab6f9654, 0x400ed4b835b2fc88,
    0x3fd2ea75f1d84a82, 0xc00374168909c469,
    0xc0021ee5b85064dd, 0xbfd534c69c347968,
    0x3ff0c46e3662e9ea, 0x40043de481250171,
    0xbff29256518b0c79, 0x400913d108b88c74,
    0x400b9885edb9b041, 0x3fea3822a7ad822c,
    0xbfb32e34b53ac628, 0xc0005408aeccfced,
    0xbfc11baac1d41ab0, 0xc006657989076337,
    0xc00fe9b18e151e58, 0xbfe9346a810f550f,
    0xbfc261cc1d161e48, 0x3fe0950408e26112,
    0xbfd5963115cb353c, 0x3ff4447691f4e7e1,
    0x400eafd90f0b272e, 0x3ff25d1cece9fc71,
    0x3ffdf89b172f0151, 0xc001d9f8e2c89963,
    0x400cb410b7e66b08, 0xbfcb6a4804e40488,
    0x3fe3eaf291351830, 0x3fd496262010cf94,
    0xbff3500f3de10ce8, 0x4004802d92079a52,
    0xbffa56d2e59e3900, 0xbff7367f4ceda440,
    0x400d7f211cbc4cb6, 0xbfbc9d27613cd74a,
    0x3fef5e20e84b3022, 0x400e0538d8e43cc5,
    0x3ff61c9cc1d11776, 0x3fe7d064a927c912,
    0x3fbde463809fe61c, 0x3fe25d7793705435,
    0x400600f05218914a, 0xbfe19a1fdbce5886,
    0xbffd2d118a30417a, 0xc0086508303ca46f,
    0x400751d958e301f9, 0x3ff5a2f4fa2c1466,
    0x400670f3dfeb08e5, 0x3ff933e9503107ec,
    0xbfb143c4144330e8, 0x401118087a49d4ac,
    0x3fd98981cf7fdc08, 0x3f8702c4599aa040,
    0x3fdcb9e820ca0338, 0xbfdbe3b3af209750,
    0xbffa8675339ff7fb, 0x4005e07d2b8b236e,
    0xc00bdc62dc84179a, 0x3ffde044f7162cb7,
    0xc00523d737e4620e, 0xc0110833eb79bacf,
    0x4001d4aab36d53ae, 0x401169dcb5c0310f,
    0xc00531fe3fa43e82, 0xbff6a389a7a02b93,
    0xc008a8cf5bfaba2c, 0xc003482f50677e96,
    0xbfe374a183d59a42, 0xc006d15585d128eb,
    0x400c6c435724042b, 0xc00387d49255f5a2,
    0xc00308c58a55a3e0, 0xc01563001894db7a,
    0x3fe6102868dfd1c6, 0x3ff34b899f2d4515,
    0xbfe659278e2e0b20, 0xc00a92dbdc237a54,
    0xbfe6469edbfb3084, 0xbfe8a74bb3f00e72,
    0xbfc129a2648004a8, 0x3fd88d06956f5e26,
    0xbfb00b10cbd0dcd8, 0xbff1854f8e97ccc2,
    0xbfd9ec37d8cae060, 0xc0043f3f3c192f2c,
    0x3fe83437fc29cad3, 0x3fd77cadd6cfea9c,
    0x3ff1339964cb6ef5, 0xbfd48b6fb13142f2,
    0x4013144613bd130e, 0xc0044f73e1277a59,
    0xc00fa8f0fd6914e6, 0xc00c7350f1534ac8,
    0xc00afc0981fffea6, 0x40117989615baa2d,
    0xbfe5e137acdda46d, 0x400579966197700a,
    0xc014a6ba6697e288, 0x3ff44f6b6085a8b8,
    0x3fec2d982e3c29bb, 0x4008491e36ee9768,
    0xbfdc5fd54fe2a788, 0x4002e2b0780b43af,
    0xc002259ab3dbb5ee, 0x4000a4bfa7f13ad4,
    0xbff11e83df264c24, 0xbff745bf6a320c08,
    0x400c1d522008c881, 0x3ff7dd5bafbde315,
    0x4003625494b85890, 0x40098c5d4b28d247,
    0xbffa62afa933c8b8, 0x3fd79878cb9d74e5,
    0x3ff953286eb7e696, 0x3fff8006318aec5a,
    0x3fe3b5de5a0ff2a0, 0xc001e0055895db72,
    0x400721c51ff21a70, 0xbfc8727d32c35580,
    0xbfeba19c4473ee14, 0x3fd7cbbbed6da5a3,
    0x40010178fa15139d, 0x3fbbbcc1015fc7d8,
    0x3ffb6ab37b50e85b, 0x3ff1923049bf88c7,
    0x3ffd818adfd022a6, 0x3ff22aa60f187a65,
    0xbff0306133dfca66, 0xc000acd69eba488a,
    0x3fec586e5cbb6ab2, 0xc004511646b64659,
    0x3fe3b74783275cf0, 0xc001e2a80564f1b3,
    0xc016767828a4d965, 0x3ff54946d6b6656f,
    0xbfde7b80685a2c9c, 0x3fe92b28f114b452,
    0xbfe3f0022ab88310, 0x3ff684cbb3ebcf90,
    0x4007bd834cf39711, 0xbfff96f6dd8845cc,
    0xbffceca60d6ea937, 0x400434859193ab16,
    0xc013f41ba46f961f, 0x3fe0a4b82a2d6495,
    0x3ff9b74bd7960937, 0x4016dbec4b44d78c,
    0xc00581b901a72ab1, 0xc00d8827274a9364,
    0xbff61c197c16abe4, 0xbff392fac025b148,
    0x4000c9c4e657e0be, 0x3ffb3f4d354af6c8,
    0xc00798a1966f5b11, 0x3fa4fe67ba068f00,
    0xc007896d6689aa88, 0x4001b423f5470b4a,
    0x400839a5bb0311f8, 0xbfeffd6cc5c136a2,
    0x3fff93a039b67caa, 0x3fd8c09e3db19240,
    0xbfc03d281c2c519a, 0xbfe546e10442cc72,
    0x3ffe9cd65d92831e, 0x3ff8b83668fcb8c1,
    0x3ff92338b2b0a550, 0x3ffc514ad5190be3,
    0xbff8fd12893b27b4, 0x3ffc0a082f9a0ab0,
    0xbfb83f5c5fcc2e30, 0x3fd9aafe684b1596,
    0xbff1ce844c4b619b, 0x400496f66757416d,
    0xbfc872cdc116b7b8, 0xbff056e0157bb1ae,
    0xc0056ff1ad19a804, 0xbff20fd02882c5bc,
    0x4000734ff8bf32d6, 0x3ff8cab4e9549c86,
    0xbfee814da823d3f3, 0xbfb35e702cacd240,
    0x3fdd57f381d9192f, 0xc007dfa494915319,
    0x4006505d21e35912, 0xbfffe109d0f28c5c,
    0xc0048ec26e46a947, 0x40002b5d2cbcdd7e,
    0xbfebe85f0e99ae0e, 0x3ffee452886a034b,
    0x3fc4a8ccddeb1110, 0x3fe6c04f6d58461c,
    0x3fd6700790e18596, 0xc01c0da74ec2623c,
    0xbf8934373c573940, 0x40052dc67836d274,
    0x3fe7375ea6d67734, 0xbff2e6daf4eee34d,
    0x3fcd299a4269d420, 0xc005b43bde8d3bec,
    0x3feec745e63a1788, 0x3ff4ddd8c6eece69,
    0xbfe8d739a40b4c26, 0xbfd86e4d662bd714,
    0x3ff23da231c340c8, 0x3ff7a66eec78b5b0,
    0xc00eb3cc266b2bbe, 0x3fb142e288b133e0,
    0xbff23078eabe1a7b, 0x3fb1c0e8ef291a08,
    0xc012333cf3bb4a43, 0x3ffbf4ed8ccf5efa,
    0x4009b25c8991d868, 0xbff2272a001c7d48,
    0x3fffb84b9b28c0ff, 0x3ff7aabc5fc3a20a,
    0xc01196d22b203ac6, 0x3feba21ef1d5bd2e,
    0x3ff16182948936da, 0x3fe3ab1ae4f48045,
    0xbfeed460b2bf3e40, 0x4000d65ef745d4ad,
    0x3ffc8b2660962288, 0x3fed0d418958cb56,
    0xc00a7b3896c8cb19, 0x400c6a60c793320a,
    0xc00d9fa2757635ab, 0x400ad707f603dff8,
    0x3fc101dd8c78e800, 0x4000c78df5a74c18,
    0x4002ade2dfd0cdf8, 0x4010e4da161c874a,
    0x3ff0f89a4dd7966f, 0xc0033cfcd114c26f,
    0x3ff2ec86aaf8384c, 0x3ff2b4774898010f,
    0xbfd45f7e0e0018f4, 0xbfe73772f0db993a,
    0x3fe96ee06a17c95e, 0x400e5e7438de8d40,
    0xbfc9f5b60a9cad58, 0x3feda541640b453f,
    0x3f9b4fdbc95239c0, 0xbfe6c1ee285c9ed1,
    0x40105604da3ee595, 0x4008d5311cd9ed11,
    0x3fe59fd5a7760a64, 0xc006a1237807911a,
    0xbffc84d90adef518, 0xbfd3b81c8c6a1481,
    0xbfad04bafbf35640, 0xc00118c34a14a0f8,
    0x4006e9aa969003ff, 0x40007049c39f002d,
    0x401e090415e0bade, 0x3ff4607eb24e4e83,
    0xc011552a0c20b42a, 0xbfa6f5f8f86a72f8,
    0x3ffddbf4872e5535, 0x4008c2e192304098,
    0xbfeb16a191778040, 0x3fc3b15aafac9328,
    0x40026372d81227fa, 0x400294c21316eeec,
    0x400661fde12c1ab6, 0x3fc4f144f07d83fa,
    0xc01093023c99a034, 0xc0101c99650278a4,
    0xc011860f09815a8a, 0x3ffb150f3cbd6314,
    0x400d0c59b58f9057, 0x3fd3803002b3b192,
    0x3ff8365c46ca206c, 0xbff30b3d6488968e,
    0x4000566e23ea4d22, 0xc000aa6a35ec0cc4,
    0x4002a86611911d31, 0xbfd0003e6cf1ea50,
    0x400c58ee212f004e, 0xbffb556e81250036,
    0x3fede08bf4bbc20e, 0xbff8101f3a229994,
    0x3ffd467a09d9d9eb, 0x3fef6b73121f9524,
    0x400d0b8356c5081d, 0xbff11c53896d9a78,
    0x4013fb2dcf5f0f60, 0xbffcdbe1dd1c6744,
    0x4006eb8d9ccdf3ee, 0x3fd3a4f3f97ec89c,
    0xc00bff21476d3975, 0x3fe9e3e818066a89,
    0x3fee6fe6b8497b1f, 0xbfbf066802d1d6d0,
    0xc009287856df0295, 0xbfa0f262371c8240,
    0xbfcd31fa30e2ccb2, 0xbff685a7550e58f9,
    0x3fe6b09afbc82b2a, 0xbfc53613bd8c0818,
    0x400b55be658f63e9, 0x3ff7e64bbe550090,
    0x3ff5777d11bb6568, 0xbfc1d79f293f170e,
    0x3ff3273958941feb, 0x3ff348c133067f34,
    0xbffd8d2b5bbe08cb, 0xc0067df0e9a8f2fe,
    0x3ffb9e7d30602d81, 0x400237d4b9bd6f83,
    0xc00211817c95deeb, 0x40018295b5b8257e,
    0xc001136394b40632, 0xbfd0cfec3751847c,
    0xc008e317a4e14d3a, 0x3fe698cce2d5b4c4,
    0x3fde5ec025e3ee98, 0x3fde23a6a8db0254,
    0x3fe47ab4e2a51105, 0x40052efc21fd236e,
    0xbff0ce1970108410, 0xbfbbe6f7acc5cc70,
    0xc00e662b360eab3a, 0xbff1e5968b670492,
    0xc0065bd580db9872, 0xbff94de48d0b6054,
    0x400d59ad427039e6, 0xbfe5829266c04a0a,
    0x4001527d74371a86, 0xc0042d53ac71f64a,
    0x3fe140d4ae9ae4fc, 0x3ffa16151655b1ae,
    0xbfe27ef639e44f91, 0xc000b7964f966479,
    0x400a61421f2085ed, 0x4002dcf540616732,
    0xbfb2db941e55fc20, 0xbff9370c77daef5a,
    0x3ff04f509ecdec6d, 0x3ff6a4ac85b975be,
    0xbfe3a85bc63a4270, 0x3fa22ba2d5b86158,
    0x3ff15007b8a25682, 0xbfdf0929db334f7c,
    0xc001eca93ce0cdde, 0x3ff4eefd98e08fdd,
    0xc00066201c9316f2, 0xbffe0c9b367d0c5a,
    0x40041966ec4e85b0, 0x3fcef9b7d74c55d6,
    0x3fc120bc789fc988, 0xc0163a4cdd756a5a,
    0xbfd07c4858d1c404, 0x401703d8439beb20,
    0x40012b27d14e0612, 0x3fe195f1565dfd0e,
    0x3ff957c922e64ec6, 0x400b0eccf5550e77,
    0x40099685e7884f74, 0x3ff0511b0e37376f,
    0x3fbba373cfcde750, 0xbfc161679ec23d10,
    0x3fd3504e781737b0, 0x3fa57da595021520,
    0xbfcbdb9165cdf04c, 0x400b76e6e8bd9b36,
    0x40011d33fc953e50, 0x4006b728ba50f61e,
    0x3ffd640bc91e9a41, 0x3fe01a220f847b76,
    0xbfd31c31a8c9eeac, 0x3ff1f05c54642df5,
    0xbff05b7ba06b1ecf, 0xc0069fbe9ae6a0d8,
    0x3fb05d6c75fd8350, 0x4001470bf93731a0,
    0x3ff9a0351016ded7, 0x3ff2cdc0a89cb238,
    0xbfc5b98f3a5d6cf4, 0xbfebe81244418534,
    0xbfefc767d97f2714, 0x400667604c24a2a6,
    0xc011108b07de9cde, 0x3ffe162a8baa2a3a,
    0xbffbb6b9da4dd9f9, 0xbffb4161baddf6e6,
    0xc0066332b37b4777, 0xbff8ccf238ed16e4,
    0xbff0174c258b459c, 0xc00d0455e32238a1,
    0xbfd9a8207f956272, 0xbff536d74285d520,
    0xc003c6cc86421bda, 0xc0068a743c2a96b4,
    0x3ffd0c855979fa46, 0xbfe0914cb8bc1e12,
    0xbff8183808fc2b40, 0xc0020f2a21b1938c,
    0xc00e296a0ad8b306, 0x3fb214f923961318,
    0x40034912b1f8750d, 0x3fa3b40bb4902b80,
    0x4004377fb010481c, 0xbfeffb9154ceae44,
    0x3fe165eca9e2007c, 0xbfe551a2112d6a99,
    0xbff653b7f4258936, 0xc0065c4ce5b23e01,
    0x4002d910697fbe01, 0xbfc6cd2aad6c95b0,
    0xbfc794a0b5ae1786, 0xc00b434fcd16b574,
    0x3fe9de47a2f01456, 0x3fad5d90cae9f3f0,
    0x3ff4d842437b4e40, 0xbffd47d75b700d4e,
    0x4010222e8844f60c, 0xc00b7b46625663d2,
    0x3ffe4f52dbd4b08f, 0xc000c52a12727cfa,
    0xc0098b3911ad6cbc, 0xbff6c15b74babd55,
    0xbfef23b4715bbbe6, 0xbff2c5dff87490ce,
    0x4008cfa5a206890b, 0xc002124495d32c07,
    0x4003a0fb7b61eb21, 0xbff5381d1b24c6bc,
    0xc005cd8a695904d2, 0x3fe0fadd24adfb5a,
    0xbfd6764d47f47d88, 0x3fea2fbfb7cd220a,
    0xbffee82e67e7264d, 0x401306d11bd11afc,
    0xbfdb093056fecd6e, 0xbfee09235472962a,
    0x4015a2c336c3883a, 0x3fe77b2324f52348,
    0x4005d10cc446f805, 0x4011c209e7afa21e,
    0x400432ae89401f8e, 0xc00f253e180f6a67,
    0xc001429bc609ceb4, 0xbfa46576d5e9c000,
    0xc00a8623248b29a2, 0xc010a3ce6ef58c15,
    0xbff56e0a207c8fdb, 0x4013f70cdc7ae14c,
    0x4013ab054c100e28, 0x3ff610da0d951164,
    0xc00c11d78d6ddc52, 0x3fe48f44e7d5e614,
    0xc012002eab11af74, 0xc000d6cc0065b6db,
    0xc00b6d832ab65162, 0xbfe50ab1c4494161,
    0x3ff4bacdcf602e96, 0xbff013ac191b3a8f,
    0x3fd7949aa81cf290, 0x400eb0b630a25b4b,
    0xbfe41095e2c8a475, 0x3fdc5c8bda9bc0fa,
    0x3fcb2ab26d2f3cd0, 0xbffa9f56ee83e32e,
    0x400df03f153d89f6, 0x3ff86c4976717346,
    0x3fd526ba8f4177a0, 0xc0006748be8679e6,
    0xbfbe7afe5c37fdb0, 0xbff27a354b00f070,
    0xc0096bada1b8664b, 0x3ff3274feacf3db8,
    0x3f9795243a087b00, 0xbfd10f167c31cdc5,
    0xc000fd7c18b92640, 0xc00874e7b3e9daca,
    0x400a4f88a59c715c, 0xbffac219274bb8a0,
    0x3ff9118f5bf418f4, 0x400c8a5702e09383,
    0xbfecd3eddf162478, 0xbffc707c7f5afed8,
    0x3ff9db21c3751b15, 0x3fd161d137503b00,
    0xbff7109b27e43f63, 0x4010cacc29e6d7ad,
    0xc007c33255de129a, 0x3fb0a9efba7a68f0,
    0xbfed499d2f3f100a, 0xbfd55af2eac0db34,
    0x3ff16c96ddbcbeff, 0x3fab9985ab1d8240,
    0x3fc1d5e6778034d8, 0x3ff588e4a0acaa19,
    0x3ff1aea34b0e1d26, 0xbfeeb895bf141df2,
    0x3fe280458a26b9b9, 0xc0039e2205bd7e8a,
    0x3ff4663021c653bb, 0xbff19a911396f6ea,
    0xbff4c8a34e4c9334, 0xbfe5b3d26b3c2203,
    0xc0029db027a5b892, 0x3fd64dcbd159da90,
    0x400b2d0afc4f5376, 0xbfe9c83283c6b9fb,
    0xbffb61974c560aca, 0xc0080ea82e7e39c6,
    0xc00432f721f1d28c, 0xbfe04c6d061c6a6c,
    0xbfe2cc352dce3812, 0x401213ca3c5cd8ae,
    0xc004239ce7900386, 0xc00d0e474dd63b5b,
    0xbfd2d2b350ddf820, 0x400b55e9b4501b7e,
    0x4009f4f4e662750c, 0xc00cee79aefc20b7,
    0xc0027737e8ba9b85, 0xbff36287d1a5cfba,
    0x3fffdeb28ce5c9fe, 0x3ffbfd38f5564a78,
    0xbfeaa7014cfa97d6, 0xc000d605aca8bfe9,
    0x3fff81515363ec60, 0x3ffdcc83dda6b04a,
    0x3ff7da166dd4564f, 0x4004d6d458b02ebc,
    0xc004487fff564b28, 0x3ff84e8c76f642b8,
    0xc003dac5e6c1b285, 0xbfd84b8b350dfdc4,
    0xc00a67f868fb14a1, 0x40122d9d17904a8d,
    0xbffa7e38d009d4b0, 0xbfd64e2941c3e2f6,
    0x3ff50d5031bd6f24, 0x3fca849505bb2de0,
    0x3fdefbb9e49a0637, 0xbff6e34bbb8bbf19,
    0x40042b9fa99e3d6c, 0x3fe78194e271a110,
    0x3ff5369b5b936a6c, 0x400f9d997134a372,
    0xc00427a8aef1874b, 0xbfd7d8edbd9f2c04,
    0x40048066c1cb929d, 0xc0017821b6b69387,
    0x40118a8078d1726f, 0x3ffd6d73065185cc,
    0xbff2e7aeed1741a6, 0xc0044d646c71937c,
    0x3ffb6c98430879a8, 0xbfaedebb35073bc8,
    0xbfff3d9487b568ef, 0x40015734908ca0ef,
    0xbffb0eda8d3f1514, 0x3fea26617f503ca6,
    0x401038c1ea420896, 0xbfc8e74c9927606c,
    0x3fcec2d785bf4d78, 0x400fd5ad1d967aba,
    0x4002d7fb5bdbedc3, 0x4000420c869a6742,
    0xbfee3802eeb4bcec, 0xbfdb7304b08984fc,
    0x400b0de45916fc2c, 0x3fd987cfd618be10,
    0x3fb926dc3c2e3c40, 0xc010fc7308a397fd,
    0x3ffdd6a78bc61bb4, 0xbff8f5b1718f102c,
    0x3fe9b2532b4992a6, 0x400148e439112120,
    0x3ffa1b3e54818cf8, 0x3ff582983b52c5af,
    0x3ff5bdcaeb6a47ce, 0x4010b442c7624d7e,
    0x3fe1eaf713d1365e, 0xbff5694cb38b30d6,
    0x40010a78cfa19a3b, 0x40044a3acc357d52,
    0xbfd37e8bdeb038d8, 0x400860962e7e0af4,
    0x4016b36fa27b1b4b, 0x3fea5553c8dd47c3,
    0xc00aace67c395bd8, 0xc00b56ee80c9ad60,
    0xbfd489be1e1be111, 0xc0092c4f25b37e08,
    0x3fe2f65595c35d9c, 0x4002612ad4320c6c,
    0x40047da7365e8987, 0xbfeabb388ada6fac,
    0x3f84bf9ef61316c0, 0xc009383586563803,
    0xbffafeab0df3b587, 0xbfea31ccfb2e475e,
    0xc01d48e9ad3e7156, 0xbff54643dfa2333a,
    0x40084b7e2dd80a86, 0xc0049a7342a2e368,
    0x400f9091771e25db, 0xbfe835192a50041e,
    0x3fd5f05db0dd2caa, 0x3fdec772f7baa978,
    0xbffe0e32d0bc55fb, 0x3ff3692135c7d7cb,
    0xbfd88e8a802d33c2, 0xc012a538b66355a7,
    0x4007038687085b95, 0xbff8ddc6bf88d1cb,
    0xbff38f7edfa481a7, 0x3fea8f7c2830959d,
    0x4000e9200027e4a3, 0x3fdb0d0ebb27da34,
    0xbff35ad8d7fe6523, 0xbfd26d99c223f894,
    0x3ff15e588bce7ebf, 0x40022fa9724ab04d,
    0x4010cba72bd1c384, 0x40010ad2b60568e4,
    0xc0018a5f5e2594be, 0x3fff0869a5b0070a,
    0x400419b74c502462, 0xc00a023ca3f1489f,
    0x3ff34298e275f27e, 0xc002f74bf13a0f6c,
    0x3ff06a9047f172b1, 0xbfed8c94117fa6d9,
    0x400977951435fcfe, 0x4013d8d7b2903132,
    0x3fe4773bf90f0540, 0xbfb7ad3456de1c40,
    0x3ff1e038010ae379, 0x3ffaf4b153277a1f,
    0xbff1fd2e4105a7e3, 0x3ff3fe198ef1ef5a,
    0xc00ae5a4bda7791f, 0x3fea67ec9224227c,
    0xbffaedb2135d4a7d, 0x3fd08c65880671a8,
    0xbfe77712a4d0934e, 0x40050b5ec8c9133e,
    0x3ff7af922becbce5, 0xbff1bb27a482979e,
    0x3fe117dc992149fb, 0xbffcdedef8db59e8,
    0x3ff57d188ef0fe24, 0xc00c7561d720b75c,
    0xbff19dc04f92d760, 0xbfe4489855da2e7a,
    0x3fd96e6d28ed72e0, 0xbff107809d10511f,
    0xc00ab1b71a6a8df0, 0xc0099ac8c8a414a6,
    0x3ff8e9bf65022d14, 0xc00306781ffb54dd,
    0x3ff4b81236836e8e, 0xc00ae3360346a728,
    0x3ffb110f4130284a, 0xbfcb6541c263fb3b,
    0xbfdf9ec6f1104890, 0x3fd6341a46aa05ec,
    0x4011c9cc9aae136e, 0x400313b464ed59c9,
    0xc00aad25b92d8dba, 0xc007fcff04d423df,
    0x40003519f03b0292, 0xbfec3d817aa69c58,
    0xbfcb254efb962bd8, 0x400ff1b3592a8f86,
    0xbff65afa9e047859, 0xbfe0b0f9d1090247,
    0x400b67ad34f5bb0e, 0x3ff48adf1993c4d8,
    0x3fe0680150182ac9, 0xbfe47859de59bd96,
    0x4009c306096a13ca, 0xbff6f2ebb72c8ae7,
    0x400af04bcbdf21ec, 0xc000b433a60db521,
    0xc00f6f1feedbdf63, 0x3ff861bd55aecfdb,
    0xbff535af1b2536b5, 0xc01381e1460982e6,
    0xbff512eb23f2ae32, 0x4004978e2fce84f4,
    0xbfc3394320d96b56, 0x4003353f72c4aefa,
    0x3fd7122c039c49d1, 0x3fd8fb71aa725880,
    0x4000a18b56ad43e3, 0xc0054d972a5a9496,
    0x400187ce39bf0c8f, 0x3ffcea352844f778,
    0x4013e4745b788a1a, 0xbff8c2b57468c7a9,
    0xbfd9039db4449e94, 0xc011131acd7dc2ce,
    0x3fe7ca1aa194a0d0, 0xbff29f65be398c67,
    0x3fb631ac13a03f78, 0xbff2ac934f6cc168,
    0xbffec020cd95d6e8, 0xbfc43899c8bc10ec,
    0x400398da5cd7febe, 0xbffe4375b4dd897c,
    0x3ffcf82c10fb3c37, 0x3fefca3b554a0501,
    0x3fdf7954c0f4fbdc, 0x400a5bf096141e50,
    0xbfe3ca0f6b1a6e80, 0x3fecdda9889309b4,
    0x4000ee9689694bc1, 0xbfeb818be1bc587c,
    0x400ce2c92a6bf2c4, 0xbfb2016c9332b6e0,
    0x3fe0fe2b097ad6ae, 0xbfc3a641222a55a8,
    0x3fc2bcfedae25f7c, 0x400f808ace6289cb,
    0x3f99fd3f98bffdb0, 0xbffc2df9c2a7bf84,
    0xbfd364c900278f1e, 0x3fee5f9374c42a1b,
    0xc012fbb20ab174f5, 0x4005ee87bb1138da,
    0x3ff4dac6889e5d60, 0xc00692b2f81afadf,
    0x4005a8a489318c4e, 0xbfc72184a33550d0,
    0x4002490fb4721c76, 0x3fd41695e5b421c6,
    0x40011f18e5cca4ea, 0x3fa4b1a1b0eba620,
    0x3ff756e60d4c754e, 0xbfe1cc2db8734045,
    0x400543939ad4a792, 0xc002597f9d4076f4,
    0x3fa2972675ca0c40, 0xbff00cd7211f8f08,
    0x4009b7ec844d4934, 0x40142d0ec5095cac,
    0xbfcd3ac899124e04, 0x400b527b9dfa821e,
    0x3ff4d630f30203f3, 0x3faad5331093de00,
    0xc00fddd42ce18c42, 0x40038512e681a3b9,
    0x4007fecc7e4c9e66, 0x3fa494cc37a02990,
    0xbfd8a9279980ba64, 0xbfe2d8ddd8793f6b,
    0x40011f73f0e3d0ba, 0xbffefbe6e86a067d,
    0x3f7f5d79f8b1e800, 0xc006dd0f5d1da222,
    0xc0036b416398afe2, 0xc005ebe1cf6ca736,
    0xbff61155a88cc23e, 0xbfef33677c5cf0d8,
    0x3fcf0e3eb9e4acc4, 0xc0092132a23bf990,
    0x3ff356790581a2af, 0xc00204fd20341630,
    0xbff21e5aa421ecbf, 0xbff4327f47eb8798,
    0xbff7115c188d3750, 0xc011583efdeb3584,
    0x40118ec212b73b6a, 0xbfe611fe3582bf86,
    0x4010197c215b4604, 0x401007ea595745a4,
    0xc003df32dcc8ff5e, 0xbfff17f94d3467ac,
    0xbfe42a6db5ee42aa, 0xbfdd2cbad64ff050,
    0x3ff92dadaae1d04e, 0x3ffab6470c8a903e,
    0x4002612e68e4e48f, 0xbff8ff6f8ce94811,
    0xbffa382d59caeaf6, 0x3ff594207a1353cf,
    0xbfd58d60d03f7e40, 0x4010c6eb7b45ee40,
    0x3ffe1b1a9dc83e84, 0x3ff32360d61721b2,
    0xc008d40e64a4d894, 0xbff727f74d952bc8,
    0x3ffb6f69348794f1, 0xbffff2437ff5dac8,
    0x4007e98e63b140b4, 0x401194a0fa0a2454,
    0xc001308e4c12d5d9, 0xc001bf34e2dba741,
    0xbff462435d6cb084, 0xbfd6461f4016a663,
    0xc00123c13e5c6480, 0x40047afca5d54582,
    0x4012e5144c2c870f, 0xbfe5cbda5a092999,
    0x3ff36f13f1248721, 0x3fe064bdcfe55944,
    0xbfe06b97866eaeae, 0x4001dfdf165aebc0,
    0x3fefb090bbbcbbf2, 0x401f9808272a32ec,
    0xbff30eeab734f782, 0x3ff855c84454b1c0,
    0x3fefa2db81d98acc, 0xbff72b8611d00dba,
    0xc000af06ec14ebb2, 0xbfe21223d0dbeb9e,
    0xbffc807c9addea3e, 0xbfe8e73796d87943,
    0x400ae9161da16e76, 0x3fb1a66e5c061b68,
    0xbff3d156a6147b88, 0x4006aecacf38ca16,
    0x3fdafc2b9c0c1164, 0x4011faa7cabfd808,
    0xc008f7bfb0e04b2f, 0x400b1c54b908ddda,
    0xc0008c11724fc6f2, 0x3fedd71e959e37ec,
    0x400bef8a2b20297c, 0xbfebdbfdb23a54ce,
    0xbfde2c7dba5a815c, 0xc017698ac4a32346,
    0xc0048816a21bda78, 0xbfde7a064d854657,
    0xc00e00b6506ab40b, 0x400088b52f2ff715,
    0xc005101c036512cc, 0x3fd7b8464badae48,
    0xc00e6ece20b88462, 0xbfd2d5a53c15f138,
    0xbfedf21d9eece305, 0xc008232a123daf29,
    0xbfe684380b838236, 0x4008a634d29942bd,
    0x3ffb7080ed494294, 0xbfe6ab569a5ba396,
    0xbff784db955ac85e, 0x3ffbd6d55042bd8c,
    0xbffe8fa0c526705b, 0xbfc0444714b294ec,
    0x3fd2954a1257d318, 0xc00a94d87f1a15b4,
    0x3fe5328912e18086, 0x3ffd21017f4ad212,
    0xc00063f74eeaff38, 0xbfda515e9aee3b70,
    0x3ff8ab55cf50bb34, 0xbff55daaa2a627c9,
    0xc00115cf5ef59430, 0x3fd280c7bb5b2730,
    0xbffb1bd2988fb3fe, 0xbff0bc78509ab8e1,
    0x3fbb52a15fe77b10, 0x4013317b56434fea,
    0xc005ef11836a3f3d, 0xbff2d50b54648495,
    0xc001fd61ff5a501e, 0xbfb82a8897a6bbd0,
    0x400b3743f9ef837e, 0x3fdf7f27485a40fe,
    0xc00fb9a909f78526, 0xbfaaafb0e30da9c0,
    0xbffd508129f39c89, 0x3fe73f0fac871847,
    0xc003d84debc0cb90, 0xbff3cffb02b2862e,
    0x40094df004c84cde, 0xbfde3946294431d8,
    0x3fef3b611d1e41e6, 0xbffbaa1b2635031e,
    0x4012905ea4876b60, 0xbfff59591e3cf4bd,
    0x3ff6a10a29e36960, 0x40083c8d45da37f4,
    0x40126007958f74e5, 0xbffc96e3dfae2700,
    0xc00c861f7db45696, 0x40090445fb24bd11,
    0x3ffc1f9476a37c94, 0xbfeba264a36c0e9e,
    0x3ff3b03ba16571c4, 0x3ffd7392b427c6e4,
    0x3fe7e28a43eac378, 0x4009d67552c4c04d,
    0x3fff2d542a60cbdc, 0xbffafac172855bd8,
    0xc001fb4ae4039426, 0x40052bcd69c52e40,
    0x3ff2974ad98ff964, 0xbff5579281b29d61,
    0x3ff0e7571cf31d53, 0x3fbac0d36f1e9c78,
    0xbfc5f3dd89876ed4, 0xbfe02ddb01d79f05,
    0xbfcaef406d6c64c0, 0x3ff3fca7ed4fea28,
    0x400c3920b97d656b, 0xbff213b542c9bd14,
    0xc0008ce19fb369ac, 0x40028b8eae0f1de0,
    0xc01230cfba3b9877, 0xbff23db3011b1470,
    0x40180c587c0cd14d, 0xbfcee57808c27fc0,
    0xc00ba6ed5841929f, 0x40169bed26288c1c,
    0xc012eadad5f3080a, 0xbfe9c8f00f99f570,
    0xc0102a974abd90aa, 0xbfdc17e5bb239994,
    0xc0012c386c0dcaa0, 0xbfe0b174cc71be84,
    0x3ffc6ae8c430b8dc, 0x3fcf00d9fa581d78,
    0xbff368a5d0eea315, 0xc008f50a758f61bc,
    0x3ff74cc5864491dc, 0x400ad8c92808ef21,
    0xc0003897641c65a6, 0x3fcb73f4d5aff040,
    0x3fed1cfd553c47b1, 0xbff7e6ff1215388e,
    0x3fe4273c4fd8b8ed, 0xc0112ed6531d0c39,
    0x4007cf6670eb03cf, 0xbff1ca1f297fc47b,
    0xc002600442d1b8d7, 0xbfeda232e86eea56,
    0xc0077ed5bdd2944d, 0xbffee69448422db0,
    0xc0085b9c72ab93e2, 0x3fca7b479334bb62,
    0x4000fc4626af969f, 0xbff01a85958e1502,
    0x3ff5106e0d8851e1, 0x3ffa1d098914b0c7,
    0xc003b91717f7b88c, 0xbfea7d822e79b624,
    0xbff9ee77d8de726c, 0xbfd8d9b81f685ee8,
    0x4003bcfc382f1e8b, 0x4004f828ad777d8a,
    0x3fc30ed45d88f788, 0xc01b2bab06549d24,
    0xbfd78ad2970a4c12, 0x4006186005aa98bf,
    0x3ff3c344b0f7d3df, 0x40083138a095da73,
    0x40085112583b3dc3, 0xc0078d900860ea3e,
    0xc00acfffd876b89f, 0x3ff10ab36c99bc38,
    0x3fff2dd0262b8cc4, 0x400e774dfe0fbdd2,
    0x3ff6d3f7c156e925, 0x40168264883367e2,
    0x3f8aabb634beeaa0, 0x4014b9dd5d671eca,
    0xc0013d95f24c5123, 0x3fea1da001ee6604,
    0x4012000dc34e35ea, 0xbff66023e33cd6be,
    0x3ffd9f4e99267f35, 0x3fdd8c44a6aff97e,
    0xbf98a0da884814f0, 0x3fb7af35436aec30,
    0x3ff7952b45fe2c0d, 0x401065715fcad106,
    0xbffbf9727c44aed0, 0xc00a9fa0ab8c4a2a,
    0xbff2e38396ffa53c, 0x40003358e5ada1a1,
    0x3fc10e2ea696c3a0, 0x3fec50073c07b100,
    0x400d6a1359a24c45, 0x3ff409e1a0d58216,
    0xbfb4aeb198c65a7a, 0xc0095cf7d7473f32,
    0x3ff087dcb514119f, 0xbff00c544693f630,
    0x4005a52b09e3345a, 0xbff500b116c4a0f0,
    0x3fc7b83265e457aa, 0x400ad61a1ddd9c62,
    0x3fa5775e066a9b80, 0x3ffdb60064b9885a,
    0x3fe47c9882e3ebcf, 0xbfec743d2e1182d6,
    0xbfe672d19720b16c, 0xc00122c872ba3efe,
    0xbff2b5fe5e0bd3d8, 0x4004625a307b10da,
    0xbfee1ce1c2e93526, 0xc01ae0abcdf7be53,
    0x3ff29747ec9c4ef5, 0x40069003939737da,
    0xbff9e3e41d9acc40, 0x3fd8836b052c07c3,
    0xbff6c12dfc7246a9, 0x3fc99bb079656458,
    0x3ffc6b9d191d48c5, 0xbffb19f96a85b7e0,
    0x3fff2008bfbb13bb, 0x3ff8824908f0a68f,
    0x3fec9c76abd83bb6, 0x3fcdc4bd68e92270,
    0xbffbef746a0702c6, 0x3fda3d469af638d2,
    0xc0007db91a6db16d, 0xbff585cf9de02f8d,
    0xbfb4359d33d08160, 0xbfef06aaecef74fe,
    0xbff90ad1cd6abb57, 0xbfdbc822eb5ed670,
    0x3fe96d51d1d33ee9, 0x3fffad00100c6519,
    0xbffd20c3a8950755, 0x3ff84e57dd126c6e,
    0x400bc137d6675f3a, 0xc0015b26fdb80b02,
    0xbff87cd2000607cf, 0xc000b03c8847210a,
    0x3ff10b492ef3b1e2, 0x3ff0b3aa0b9e1753,
    0x3ff8bf97abfebbfe, 0xbfc3aa168f50a2d8,
    0x3fe266d4ed8825a6, 0xbff1d393f2dbf49e,
    0x400d641199eb4c4c, 0xc0002c45e302866d,
    0xbfff3ff08ab75df7, 0x4003a5ca0d5f5ab4,
    0x40113b7bb2a17659, 0x40127943e747412e,
    0xbfffb425daea7672, 0xbffccc19ffd3b796,
    0xc002b4f28bdb22d1, 0xbfd02632915fa0d7,
    0xbfdbfbb2f20b7790, 0xbf9a8919c9331340,
    0x3fb4c9adc85e7958, 0xbff1020848df84f3,
    0xc004266d8e19527c, 0x3fe2ea69184f8a52,
    0x3ff2d2d2941cad3a, 0xbff98747f2edbbbc,
    0x3fc7145b2b0a074c, 0xbfea7b18f0d8f6b2,
    0xbff41ffa40911892, 0xc010e432741df9bd,
    0x3fe35b43c0d0534e, 0x3ff71322df012372,
    0x3fb70d4662184900, 0x4007c787040cc262,
    0xc000c051beba96c3, 0x4007232a07e07fb4,
    0xbfd2eef07a62882c, 0x3fdb82d28179c614,
    0xbfe1d0c7adfd387a, 0xbff45e18dcfa9f7c,
    0xbfc1004aba04d4bc, 0x3ffae1e237dd4b3e,
    0x40174dfaec9d1ac8, 0xbfe6c5ddc90eca44,
    0x40137f984efe2b59, 0x400e8c4503c8e044,
    0x3fed972d046713d8, 0xbff8bf1585869105,
    0x40012a0c09c69ac2, 0xbff12116ef38409c,
    0xc000a8e3d5e9fad9, 0x40061f9d00f4ebc8,
    0x3fd56e8baa85f438, 0xbff1dbc8bcdc8a8b,
    0x40016bf7a288fdf2, 0x400131e9d0d29530,
    0x3febd24f4e1af315, 0xc01cc57a0ac93ec6,
    0x400e22dbeb02dca8, 0xbfeea4fb5de5327c,
    0xbfe223ee1b5c3710, 0x3fed2521b0f3ee78,
    0xbffbb182d997cb77, 0x3ffe767d92f91b69,
    0x3feb60d700932a2d, 0xbfe36f299d5a9ae4,
    0x4004a0116402fedb, 0xbff30b137780e84a,
    0xbfebfe1dca2058ca, 0xc00711183ad3fdca,
    0xc000266d6be99595, 0x400066e23d5808e6,
    0xbffac4cfec866112, 0xbfe3be9c46fa04c8,
    0x4004c2b17b42549e, 0xc009ee8a09c232e3,
    0xbfe03c69a7c10184, 0xbffaa18ac64deb7c,
    0x3ff18402c06d8620, 0xc007a3ba83fbe9f9,
    0x3ff1a7458ce7f841, 0xc01481855824fd7d,
    0x3fdc247b43daac28, 0xc015ce752741dafa,
    0xbfd9fee72e440eb9, 0xbfd5de169236e698,
    0x3ff1e6e485f4145c, 0x3fdd1de7c66163a2,
    0x3fe25ba48a61e2a0, 0xc0025e99f06f0802,
    0x3ff5f78fd9b17a0d, 0x400054ad759f0417,
    0x4012f44eaa812031, 0xbffe96166e0cc4ee,
    0xc011d6e2f2e65f06, 0xbfbacfa2b52406c8,
    0x3fe8672fdc8bddf2, 0xc002d7265dc6cd98,
    0x3ffd5ac519204c15, 0xbfe2ea154bf1854f,
    0xbff41ef71f3e05b3, 0x3ffabb9bc578981e,
    0xbfe17da59c706394, 0xbfcc8b5cae6b047e,
    0x3ff84fdf1775f58c, 0x3ff4532fa5e95adc,
    0x3ff3f3f354e256fc, 0x40159c4dca2af7e2,
    0x3fc9b54e123e1690, 0xc005c652e742bf71,
    0x3fe62bf1827485a7, 0xbfdebdc028d5ab2f,
    0x3fd0aa8cb9c490f0, 0x3fe3b9da5fe07e54,
    0x3fda0474a438a6b8, 0x3fc78ef9f1ef4f4c,
    0xbfc6206969ed7eb8, 0xbfb7c1219adb6574,
    0x3fdc6606c648bb0c, 0xbffb9ee32212dfb8,
    0x3ff05c80ddee9dae, 0x4015a4ab78ebeee3,
    0xc013d5103c5214a5, 0xbff599ef7e0e9f82,
    0xbffa685da43e0a44, 0xbff9bfefcf8d0f50,
    0x3fecf44eb4f88cba, 0x400fe9b69cdc0091,
    0x4004743bc4d1b73f, 0xc0015724171dcdaa,
    0xbffbb60df26b3b76, 0xbfdd522251739e6c,
    0x40162e012d2560fc, 0xbfe2d404e3df57f0,
    0xc0135cc305394464, 0xbff34f4ad1e359a6,
    0x3ff70e36382607a4, 0xc00764e79d4b8c79,
    0x4011aef90f22f7a1, 0xbff8f0ba7c2297eb,
    0xbfd27154775f11f2, 0xbfe72e38b90471f6,
    0xc00ebe738a9c4dd4, 0x4003be1fdda3cb5f,
    0xbff7e59c32a49580, 0x4014d8ce63c8b9b8,
    0x4002392461b0a8bc, 0x3fed03e79becd3a6,
    0xbffb8a2fcfcadc2c, 0x3fde5dc07f5c6010,
    0xbf9ae1da86fa8c40, 0xc00b49edc4518044,
    0x40161d7cbe46fc1a, 0xbff55a5f6bfe0009,
    0x400817166cb9792c, 0x4008a902958cb594,
    0xc00accfda9d9603e, 0x4005449e855af5e0,
    0xc00106b0aa720a9c, 0x3ff5cc61f6911585,
    0x4001a39f6c7643e9, 0x4003c1b43b69a81e,
    0xc000ba88458d547c, 0x400c93bcb8c69f90,
    0xbfc0e8462258e3b4, 0xbff30e820772cdd3,
    0xbfd1c9c42d1862c4, 0xbffa5d1a35ba06f4,
    0xbfda58bf1681d4ad, 0xc0014f3dc46091fa,
    0xbfc6028177a2dae0, 0xbfddd7dd8a1c81e4,
    0x3fdc759ad7ef6377, 0xc009c02d327ace08,
    0x3ffcc2cfe9e77a83, 0xbfeb8f8f3b10119a,
    0x3f64c2ddfc6ade00, 0xbfdeac4984e851a0,
    0x3ffd0d0c7163f1a2, 0xc011922e9c9b626a,
    0x3fff4fa43c1ed984, 0x40039b6b0c283d8e,
    0x4004a29d8155c8d2, 0xc003d86282319bae,
    0xbff0fc698afa92be, 0x3fea730775403b3e,
    0xbff322d7ecde04ad, 0xbffdb3271127f435,
    0xbff5bdc94e53e4b0, 0xc009e01fb8c1df1c,
    0xc0112880188d4c43, 0xc0103fa4b4ddf6f8,
    0xc00614043c617bc2, 0xbfdc9f98523a4f03,
    0x3fdca28eb9245566, 0xbf964eb0dd83ea80,
    0xc008bb578971abed, 0xc00db7e2df2d039b,
    0x400109cd38e1d52c, 0xc004d6d9febac514,
    0xc00a4ddfdc2c8da8, 0x40138163f0c14e94,
    0x4013e7937b787e9e, 0x3fd91e81af059296,
    0xbff4c2d2d7ab5158, 0x3fed18d170fb6fe0,
    0x40059d90b2e50e1b, 0xbff454080b627a6a,
    0x3fe89e6b0679722b, 0x3ff72f0da790d1e0,
    0xbff80e013718044f, 0x400cdd31b4259d65,
    0x3fe33977c053dcd5, 0xc01138569c820d9a,
    0xc0082cbe1b9a2d5b, 0x401228790cde1e59,
    0xbfe7a762e3992878, 0xbfeca50aa0a99b7b,
    0xbfe361f5bfef8524, 0xbff91856995cc48c,
    0xc005ed5a45536f56, 0xbfeb970fb9ef33b8,
    0x400ae92fb6c6fca3, 0xc00e50440f50534d,
    0xc00e23db28c3fb66, 0x3fe15dbbe1459d04,
    0x400332a918a961eb, 0x4007172a011e83b4,
    0xc00168ac9e537e91, 0x40006d476d1c4c87,
    0xbfe21a1b9c4e710a, 0x3ffe22c4b352c8b0,
    0xc01159146f7fa9ab, 0xbfe2644ebbf6f82a,
    0x3fa547e832f45990, 0xbffb65f16a1c7bde,
    0x400a9267df658892, 0xbfe4a5e0a08a57d8,
    0x4006225ce6412d2a, 0x4002069e80a86c6d,
    0x400066a0c5ae6329, 0x40055947eef50391,
    0x4001cc1bc111cab6, 0xbf765a841d4d3840,
    0x400f0a0c17448c4f, 0xbff1f143bada4612,
    0xbf83f11b135c2900, 0x4000d46d9a698814,
    0xbffc06de096f2d0a, 0xc00491ffbe379d54,
    0xbff4323e157605f8, 0xbff385bc0175dfa6,
    0xbfe3864f624e604b, 0xbfdd24ff0971f398,
    0xc010bf6329e9ea1c, 0x3ff3ea5aacd2485a,
    0x3fd78051364f4c0a, 0x40087c0ac34de270,
    0xc00738f361a7b06b, 0x3ff741611b1c6e99,
    0x3ff3ff582231621e, 0xc0092919f10a2a0f,
    0xbff2cff778a1fa0d, 0xbff85f2baffdf77a,
    0x3ff748ab728ab6fe, 0x3fed6e2a011ffd64,
    0xc0010c8eaf733bc4, 0x4004b8415f46044c,
    0x4001e8f340b46626, 0x3ffc668ac735ef24,
    0xbfea72509358be60, 0xc0008db86fbbe491,
    0xbff963cbd990ffdd, 0x4003ffb6c1eb6d47,
    0xbfec34691fedd7aa, 0xbff37c918c7a29f7,
    0xc002c1d08ea60de4, 0x3fe69b6bc5d375ed,
    0xc001ef5f783c8334, 0xbfed80b689aebbaa,
    0xbfc02ff7186e5094, 0x3fd8881b6d61dc24,
    0xbff16abc70a1e68b, 0xbff80b2af98d0c1e,
    0xc00a75c1d108a009, 0x3febdfa2aee9803b,
    0x3fe9d05e5f2a6a2c, 0xbff709e3f64c3e26,
    0x3fe2fe36a9961b17, 0x4003c8d638f0f600,
    0xc002a21fd09bc41c, 0xbff05bfe880c6b88,
    0xc009d9aef29ca638, 0xbff6098ef407f365,
    0x3ff455350cb3ccd0, 0xbffd69a2a56e9dd6,
    0xc00397d50fdf8950, 0x3fbbd8e952377050,
    0xbfe834d355e812fe, 0x3fe3d1001a719219,
    0xbff3bd20644671fa, 0xbffac520c3c33d63,
    0x3fff5a9ce4892384, 0xbffee81b810e8650,
    0x3fcd96d629b7e0f8, 0xbff522d47b0f4c6f,
    0xbff9bb7ea1db3b6a, 0x3ffdb50635ba836e,
    0xc002db767b609130, 0x3ff16f7629c43360,
    0xc007db577facafca, 0xbfd9ede441c7fa98,
    0xc006a2557b24f329, 0x3fd7f726c4540e20,
    0xbff8b724d0d5be80, 0xc00f77d6336143ac,
    0xc010ceaf17b5ac21, 0x400156acf7423776,
    0xc004771aab0da654, 0x3fd6d7a08a22d97e,
    0x400428b00097dea5, 0x40041dcab8d5f777,
    0x3fd6f6c74665cde8, 0x400542f1a13aabe2,
    0xbfdab2b62f3df975, 0xbfd0b00393945572,
    0xc010b5fdced6021a, 0xc011aead2f8f5098,
    0x4000f02c9ef737fc, 0x3ffef8a5266a3a55,
    0x3fea432d1e7183ea, 0x4002421f0b8253aa,
    0xc007eec44241512c, 0x3fe89bee22e7acec,
    0xbff6666b60241792, 0xbfe21a8f560eb764,
    0xbfa1eff8a66bdaf0, 0xc003f84677cc6f2a,
    0xbff5c98ba4eb35ef, 0xc00a8c9c1fe615ae,
    0xbfc38d2fe1cfb340, 0x3fe5d0087ce64853,
    0x3fde90827e8ee9d0, 0x400e9f39e40257e5,
    0x400163cd19a48bf4, 0x4011093e4e9e452e,
    0x400003575b420ba9, 0x3fbc1ebc61062f40,
    0xbfdec3d856a74144, 0xbfd3f264ac677ae8,
    0xc006658871610df7, 0x3ff4644baab83446,
    0xc009c13848003d09, 0x4000ea838d4b8ce3,
    0xbffbc459b0e0908d, 0xc001b1e9542db4f0,
    0xbfa0a20728b66720, 0xc00456f2978b2040,
    0x3fe61232adb244b8, 0x4016683ebbb77756,
    0xbff7318ad3c9f8a8, 0xc00033a716dbde35,
    0xbfd80b12cdc92418, 0xc00f2acc9d2a7c0e,
    0x3fd78e5c6e92ebe4, 0xbfd6e82aba485198,
    0x3ffa63ecd6d2f189, 0xbff685ca58c2a670,
    0xc006306b4c0ee4df, 0x3fe624c41e254463,
    0xbf7130af20144b80, 0x4014969831f8b544,
    0x3f82a930bec88c40, 0x3fee0b47a9bae784,
    0xbff89d2694104373, 0xbffb30843fb17667,
    0xbfce9eeb2a890cbc, 0x3ffcae15dfd643ca,
    0xc002e1a0049620c8, 0xc007764e6e1c508c,
    0xbff996248f3a554b, 0xbffef961bbb52818,
    0x3fe700914d5cfeca, 0xc0071bc06501d56a,
    0x3fb7a49032035140, 0xbfb6a80d17ba3e60,
    0x3fdec8445d6763f6, 0x3ff26ed482775020,
    0xbfb54633098eac30, 0x3ff12cc5c06386bd,
    0x3ff1d8cd0f3e7e84, 0x401267493ab17bf3,
    0xbfed46cda8e2f194, 0xbffa34652d9ac6ae,
    0x3ff3457e86bfea14, 0xbffd770450eedcdc,
    0x3ffa8a3d3bc8556a, 0x4003f9c2ea4b9f44,
    0x400710b79da7f77a, 0xbfc904144584ab22,
    0x3fee16b72c96b286, 0x3ffa7c11ecceb7fc,
    0x400eb339ebfb468f, 0xbff5c54ad1bc9aa7,
    0x3fe473eee7fc0d8c, 0x3ff5e07f84c04355,
    0x3fc2c1acad4356bc, 0x3fd6bc128b22e300,
    0xbfe01bacbc16755f, 0x3ff12a6f2a1f537c,
    0x3fd986d3622d7e7b, 0xc00c50787285311b,
    0xc004f1f51f73423d, 0x3ff71ba417a732e2,
    0x40122786dca50e15, 0x3fd0ec54547ffd32,
    0x3fe2374eb842acd4, 0x3ff93e9875890b48,
    0x40091e337f0bfefc, 0x400238959d3a0b03,
    0x40084c45c68ef61c, 0xc00da19ae38a00ac,
    0x400857c63fdc68dc, 0x400d7d8e6defd238,
    0xbfea47a7272a233c, 0xbfd5b30a9eb3261b,
    0x3ff11ad20491e8dd, 0x4001f537205f821e,
    0xc00b93ab6f0b6836, 0xbfdcf4e31713b37a,
    0xbfcfbf4373d299f0, 0xbff13b81a18c5d5c,
    0xc004ff036f144a39, 0xbfe67b3c366e5d03,
    0xbfe63a341ec61e6b, 0xc0033440ed56fe13,
    0x3faa21cd5f9f8ee0, 0xbff8318ae9230a94,
    0x0
    };

static const uint64_t ref_rfft_noisy_4096[4097] = {
    0x4010785baf69d0c4, 0xbfc92a9604168f78,
    0x40046255f53cf244, 0xc01930a0be8be4f9,
    0x3ffc97b4c0741cc0, 0x400ca32f3104f35d,
    0x3ffc7a4073ddee2e, 0x4003424a8d478d6c,
    0xc00b0ed4b8440795, 0x400b910f67a09806,
    0xbfe5feab65054ad2, 0x3fef8e8fdfc6f8a7,
    0x3fb9c8fcff9009b0, 0x400ccaf2bee083ee,
    0xbffd0dc71e50abf6, 0x3fb3cb5d1a81bdfc,
    0x400bf0ccd7777920, 0xbfd47b881979e79c,
    0xbff4f24e69d3119b, 0xc00723c9478f108a,
    0xc010fdbf5376bd33, 0x4001fa8b897ae7cd,
    0x3fed6319624165c8, 0xbff7990e8bf26d6e,
    0x3ffee2b9f82ff124, 0x3fe7cfd762db16cd,
    0x3fe23e87be1114e4, 0x3fe32c00ac7424d4,
    0xbff40c5ee71dc0cc, 0x400f96d037fa9af5,
    0x3ff292fae6ddf4ae, 0x3fdb6dc4802c5640,
    0xbffca36883cf9be4, 0x401495b568ebedd1,
    0x3fd6ea6c34327b68, 0xc0065c608db61b26,
    0x400269fdd91164b9, 0x3fc5749783f0ed28,
    0xbfd00ba7a0b26a3c, 0x400275fdd1d6095f,
    0x4009986f7eb6c3f4, 0xbfcb17390540ef8e,
    0xbfeb22c0df75414c, 0xc0020d07af281d70,
    0xbffef20b7e8a414a, 0xbfe9d7251a122d31,
    0xbfe30cac63aa5228, 0xc00fb3dea14cab59,
    0xbff51514d2fe8478, 0x4002309301d8e5bc,
    0x400945c1aaedd740, 0xc010ee7f3d5d5a33,
    0xbff1c8e948fca4ee, 0x4012d2e7f3cf92ce,
    0xc016c63d97845bc3, 0x4015accdb1d0325a,
    0x3f98c30659d83ac0, 0x400400f66cf10326,
    0x3ff381e5739ed4af, 0x400939ae765620ba,
    0xbfe3825cc8b95923, 0x3fe3c2c55a4a270a,
    0xbff58715cd470556, 0xc005ed5b03ae3f4b,
    0xc006dfababf5b76e, 0xbfca5d032f39fea8,
    0x3ff7876ccc95e342, 0xc0014001ddaea81f,
    0x3ff3ded43851645e, 0x3ffe27efb8be6b40,
    0xbf807f81773e5a00, 0x3ff1a12849db76c9,
    0xc0023ea534e38498, 0x3ff8cc63f4cf0148,
    0x3feb800b892e6fa6, 0xc012aa57abddfb2a,
    0x3ffd9c58eae263ee, 0x400bda162fd88f24,
    0x3ff6e2573a53feee, 0xc00fb994d81b1515,
    0xc01766492f5ffb1f, 0xc0034bf331e255f4,
    0xc0096fe0c36f80f4, 0xc0186b9536936d2c,
    0x400cf674724e6ed6, 0xc003f292e97430cc,
    0xbf99ac84c7b1f380, 0xbff7c4c23d0eb580,
    0xbfef3f9f9d1d1c7c, 0xc00910a39479e459,
    0x3fcb00ffa4806150, 0x4014291f5bbe608c,
    0xbff5d9c80f2f8756, 0xbfed53df049f08b6,
    0x400e8ca96015e48c, 0xbffba46b83d2bc45,
    0x4004567e89eca3e1, 0x3ff8aa5e39e1d3b2,
    0xc00c6b4efaf9aa22, 0x3ff2b3b79c79384c,
    0x3ff77b6e2a9aa2b9, 0x3f994115be5053c0,
    0x3fe6e2f7b334ab9d, 0x3fe1a4c6cd124dd3,
    0xbffa20461ec9fa88, 0x3fcc2fd912ab7540,
    0xbfe50361fef74a1e, 0xc0087070f667c19b,
    0xbff359f03a9b28a7, 0x3ff7c45b05eabebe,
    0xbfe446e4523726e2, 0xc00215ed0b75dd6a,
    0x3ffaf8b5b708710e, 0x3fe7b2a3186cca42,
    0x3ff5af54e4434fe3, 0x3fe579f64a6e7f59,
    0x3fd1d84afa1b7844, 0xbfaedab2aad624e0,
    0x3feea58d31ab4c2f, 0xbfe8c2a16e066c8b,
    0x3ff4c84f3aa56654, 0x3fbdc979f0097c18,
    0x3f9bbdbbe757f200, 0x3ff0a209987bb96f,
    0xbff365db800dcc40, 0x400f7e8219ec3136,
    0x3ffe2565b1b4a0c6, 0xc0065d8c20baad92,
    0xc009b59423ce0024, 0xc009c3fc48369198,
    0x400a69a9e4179e6c, 0x4001480187caa060,
    0xbfdf634b924004ba, 0x3fc83229d525b800,
    0x3ff23b089049ae20, 0xc0035177916454b4,
    0xbfee3a33adfd0cf1, 0x40105003440680e6,
    0x40023c4ccbb1ab68, 0x40051aaa6e46bb41,
    0xbffe529da585e471, 0xbff915415e72918a,
    0x3ff0e9407cec2989, 0x3fe385deec1a05ea,
    0x40066b904417ebf2, 0x4011bfc1318c6270,
    0xc00e4e1b43b0f0c4, 0xbfe360753aba410e,
    0x4012e1ca141830ae, 0x3ff878dee6a18cc6,
    0x4004bb18881628d0, 0x3fe9658d4b93c058,
    0x3ffc44e5c30cb8b2, 0xbff7eab70e4f9ee4,
    0x3feb5058334ab81c, 0xbfebf83ad1085cb7,
    0x40109c9ef6dbbc82, 0xc010ba37865b4a70,
    0x3fea34bd553109ad, 0x3ff76eaec1d30e7f,
    0x400327cb80f12170, 0xbff4d16152e8d04d,
    0xbff39e51b0dc1ce5, 0x4001f65a1cb5d25c,
    0xc000fd39fc5dc97a, 0xbfc3702bb5ebb1c8,
    0x3fe250b56bc398e6, 0xc011cc123fa12ce8,
    0xbfe1db78c6bab4e0, 0xc006949b17458cf3,
    0x40079ab887fdcff8, 0xbffa055798df968a,
    0xc00fc3c71c17e2b8, 0x400043ce0b683a46,
    0xc00d450a869d0a71, 0xc015228170af3d60,
    0xc010edd5011bcf47, 0xbff3b2e5e33c3fda,
    0x40051b9cce96c241, 0x4000c72b188312ab,
    0x3ff2cb64c7d9f4ee, 0x3ff4c2568725e421,
    0x3fe0bb801c63914b, 0x3fd3b1d66dfbab98,
    0x3fe9b1ed21dbfa84, 0xc00478a404b8a100,
    0xbfe30c8eaf0d5af7, 0x400d9194df9c50b7,
    0x3ffc7020595310d6, 0x3fe456dff3a4105b,
    0xc007306bf45e3f7f, 0xbfd58a56a5972e10,
    0xc015f577bedecb9e, 0x3fd829cb3c5d71be,
    0x4000114719323f85, 0xbfaaea385332c500,
    0x3fe225c101eb28da, 0xbfe12e8554a73806,
    0x3ff1ce68f5c01cea, 0x4010f4149b44d2ea,
    0xbfeaf052a3645c21, 0x3ffd3cd80fc8e31d,
    0x3fea10f153eb299a, 0xbfe8ad42aca27c68,
    0x3ff05f19348c3658, 0xc005db43ad2677cb,
    0x3fde0c5793572cf4, 0x3fc699f3ce90da98,
    0x40049fc023866e8c, 0xbfe3864f0bfde453,
    0x3feaff65d42e9554, 0x3fe9699e868eec4c,
    0x40005ffb43bff2f5, 0xbf8b360b41dab180,
    0xc003aa15ff451162, 0xc01160ce4c626672,
    0x4009e9306719d60f, 0xbfe5c801fbdbdffc,
    0x4002dfcb89315df6, 0xbfeb3dc2cc9d85ac,
    0xbff7171736a55590, 0xbfed97190d490bac,
    0x3ff7286d2b035b7e, 0x3fde4971f8e32c16,
    0x3feba176805d1e54, 0xbfe8274b47efbe98,
    0xbffe2e429b68ea60, 0xc00903d0e026a0b0,
    0x3ffb33e4276a723d, 0xbfbfd9dd29a6cba0,
    0xc00212d02b1341ef, 0x40159b791361108a,
    0xc0042b9a590f4419, 0x3fe8d3480e74c441,
    0x40166be21eb45a8a, 0xc009b22da86f4cc4,
    0x40012812c0e9b47f, 0x3fcc0b3ac63b151c,
    0xbfed86f25664e7ee, 0xbfe06bb5598da230,
    0x3fffde1207f87529, 0x4013c0780a55b0e1,
    0x3ffa9890c9f62176, 0x4003b993d5b6c101,
    0xbfcb47949252ab3c, 0xc015c49db8827504,
    0xbff3e98d00fa1b68, 0x3fa0bde650f86a88,
    0xc0120eb90d35b9ab, 0x4000074eeae92cc0,
    0x4004265eeb79d0ec, 0xbfffbcf716738ec7,
    0x4000048c83ce0fce, 0xbffb4227761516b5,
    0xbfe12e99f7a24d5a, 0xbfd755b3a0198ba8,
    0x3fe36e3163c9406e, 0x4012f2b75b31bdee,
    0xbffc444eb038851c, 0xbfdb06e64b33d17c,
    0xc017ed474ca79642, 0x3ff80f0409568356,
    0xbff0edc516762ea9, 0xbffcc1d8eb33b500,
    0xbffe7c802be22389, 0x3ff63c5c5b6aa373,
    0x3fdb221270d7bd95, 0xbfe423362c6fcc2e,
    0xc0002020fb73e536, 0x400d3578423da0b0,
    0xbfc23d659445d112, 0xbfaedb326cc5f760,
    0xbff19068f77d9b5d, 0x400cf68071a9171a,
    0x3ff5b4707ac8228e, 0xbfce00506f6fa678,
    0x3fe0d8d212aefc6a, 0x3fe4b7cccaef3de6,
    0x3fd317a555ad8a26, 0xbfce772556423cb0,
    0x3ff0eae66cea359b, 0x4013b17aef8cac29,
    0x3fcdcac60cad17b0, 0xbffc4d29c21d6914,
    0x400b36b76e7dfa34, 0xbff5f6e249c3f29c,
    0x3fc8ccdd187651c0, 0xc005fd42f4078fa8,
    0xc0100d78dbe6637d, 0xc008395c2e2bf67c,
    0x3fd0fee8f1b7b4ba, 0x40088339e2b3c37b,
    0xc000a5394d33a3d6, 0x3ffa5d4ec18397d5,
    0x3fdbcaddbd2f8e8e, 0x400d32539ec13a6f,
    0xbfe383a5cb174130, 0x3fe6aed6c751cd50,
    0xbff71b3cbcf4669e, 0xc00078a875173f7a,
    0xc0198ec309be8577, 0xbff2a9eb23c64f19,
    0xc0079283227c9796, 0x40064230b96c399b,
    0x3ff8319d3c6d57c6, 0x3fe8085ec9ecefe7,
    0xbff10c129af08956, 0xbfb54b1c3b3fa6a0,
    0x3ffae273c57f0486, 0xbff63953b5e855f9,
    0x3fdabc27587c0878, 0x4006a49ce0ad4dfe,
    0xbfa94b8c07ddee08, 0x400820cbb4579d47,
    0x4003029acf6addfc, 0xbfe9619e20df2c78,
    0x40119630f6862173, 0x400b46d88667cc07,
    0x3ffd0d1881ab2970, 0xc005cea6b3419d7a,
    0x4003f8f9ef70bf12, 0xc00c541f45281596,
    0xbff0c8297b9359a5, 0xbfde0ada26a6153b,
    0x40041e75fe3e2aa6, 0xbfc010fb767013d4,
    0x3ff53e6914dfcce3, 0xbfe598392ff6edae,
    0xbfd52dd2615e0332, 0xbfdeceeff4be7da5,
    0xc00ab17e2493b2e7, 0xc012eecb31abc9a8,
    0xbffd8193e6883af6, 0x40061118df054304,
    0x3fc19c6c613a91bc, 0x3faf262221cb9c50,
    0x400c0effb7d6a36f, 0xbfb8728a5e09f87c,
    0x4001c8aa2ba011f1, 0xbfd0819b7551ac4a,
    0x40163d953c222264, 0x3fdd9340e009f382,
    0xbffe33f444623c83, 0xc0009ff8e6a602de,
    0xbff07144a2abfde7, 0x3feeac6560b8417b,
    0x3fff6095dd3445f5, 0xc01ee96eb814d926,
    0xbfd58f59a929eaf4, 0x3fe59dc98c8a7c8c,
    0x3ff29004c19cd180, 0xc00341617de4f344,
    0xc00330701b484f62, 0x3fc3fd8f89a73494,
    0x3fd89c6d21770737, 0xc00d82f60e3b0c9b,
    0xc009758e8dea891f, 0xbffbd54867e54b7a,
    0xc0062c3f010eba98, 0x400d56c856cb8256,
    0xbfe96e8c3c15a36e, 0xbff821e12db58a76,
    0x400322292071a9ff, 0x3fe10da0de7e53af,
    0x3ff5ae4de3e2b814, 0xbff59da19feb264e,
    0xbfef8863ff902504, 0x4010e1004fb842ad,
    0x3ffb9a7e441d17fe, 0xc001f1115be2a4aa,
    0x4007ccf830591702, 0x3ff37e039a5f74e9,
    0x4003a060a38049b7, 0x3ff4347474e0ec5a,
    0xbff8dbce09545868, 0xc0097c6f08783dbf,
    0x400201b912f3ad1c, 0x3ffea688ee401933,
    0xc00843f6b0257272, 0xc003c32013775b7a,
    0xbfb28a920a2d0830, 0xbff7dc8e3f6cc122,
    0xc0021e3e48b4c7ca, 0xbff2f93b1fea58f2,
    0x3ffdcde0b670e6d7, 0xc00cc1308628c502,
    0xc002c8d45443a9e3, 0xc002f22fb01403d2,
    0xbff3e170b9920df9, 0x3ff78d259809f49c,
    0xbffe8e7ef6d30d95, 0x3fd66c3424c91a3e,
    0x4007a1667fe85b34, 0xc0045f309a6b3a58,
    0x40061bbd5a4d8594, 0x3ff70cc2479f49e0,
    0xc0046f2dc0bd0384, 0x400458dab80f25bf,
    0x3ffa38f4cbdc14ae, 0xc0095f2969854bc9,
    0x3ffee90c5ad62cc9, 0x3ff536cbe0a51158,
    0x40058d77468cc3a4, 0x400389526ea15af6,
    0xbff0b571c0724e34, 0xbff19f6a33e9ec0f,
    0xc006fe88e762e547, 0x3ff9999e07f09ad0,
    0xc004b67f90dda014, 0x400537b34810980d,
    0xbfee5e262fb17329, 0xbffc38589806b677,
    0x3ffe8e3c764fe5b8, 0xbfc216d97dc43e08,
    0xbffdc448b04c4f2e, 0xbff60902652bd3ca,
    0x4016579e10ddff56, 0xc009fd2eb595abb4,
    0xbfd46c307f3164ae, 0xbffef485a2a65c53,
    0xc0097d513774a032, 0xc0092a0d09935ee0,
    0xbff8f6287f0ea386, 0xbfe018a779f1d676,
    0x3ff626b41671838e, 0xbfd0af418b9ecb9a,
    0x4005d1dd9005895f, 0xbfec76b43ff12934,
    0xbfea0809fee9bcce, 0x3fe867f16782fd8a,
    0x3fff0968aa4d2a41, 0x40017376823e94bf,
    0xc005de8ec83d327a, 0xc0067e90be4f8219,
    0xc00261c3805973ee, 0x401031323380cdc1,
    0xc002673d88463af7, 0x3ff513de46e30909,
    0x4009c45509cfac04, 0x3fb076b690f7a980,
    0x4000f8e9160f1c7a, 0xc010fe5e7c8d8cb2,
    0x4000ce23d281ca36, 0xbff44d681affe7bc,
    0x3fd39cc9f1b8792a, 0x3fe4dfbefd1bb3fe,
    0xc0011183d32b7efc, 0xc01abb09f933328d,
    0xbfec244290b33c64, 0x4005a91d4379a564,
    0x3ff1790a89483d1c, 0xbff2a9fc4e89449b,
    0xbfe6f06315fdae64, 0xc00117f1ebff2bec,
    0xbfea57a50834e2ce, 0x40088d9cadb7026d,
    0x3fe336e574526b86, 0xbfd6dd2a8be2f024,
    0x4011dfc706ab6ca1, 0xbfe39ed90603fbe4,
    0x3ff08f65bd8fdcb5, 0x4008ff6b6fe25a98,
    0x40012c6a9330cbb1, 0x3fe26613be4f8682,
    0xc006c98b5a7ca28e, 0x3fe47a91da0a6a60,
    0xc0061f6c4cb9f7ae, 0xbffdbd6850201b54,
    0x40173b0f785ad372, 0xbff0daa814ac093b,
    0xbfe4b91bd9491620, 0xc0008c771adcf1e2,
    0x40001cf9856eca7c, 0xbfc8587d2effd300,
    0xbfd801f386cb3a28, 0x4004490f1f5716a1,
    0x3fdcaa49bca7bdb3, 0x3fe3e296f1cfc91a,
    0x3fd905883aa232a0, 0x400aa963b9c03294,
    0xbfe8a38d629fdc1a, 0xbff92a0b37f5613c,
    0xbfcaa78e5cbc14c5, 0xc013780f5afbd623,
    0x3ffe7c52b4c96892, 0xc00def94814ce26b,
    0xc00167c55cb8bcac, 0x4016c23ffa5e36eb,
    0x4006324d8db1c74c, 0x3fd47802cafba698,
    0x3fd72b36ee1d21fa, 0x3fcfb0d0800bf8a8,
    0x4003f0bd2fd383fc, 0x3fd3866604bc43b8,
    0x3fde1c2098ac2f4f, 0x400c3148bc606aa2,
    0x3fc4938e5a130668, 0x3ff936ac93ac1e68,
    0xbfd770a5e9c78240, 0xbff7252403f012b0,
    0xbfe4803b3bc897bf, 0xbffb20c323e8a388,
    0xbfe087611a01c9b6, 0x3fedd55f0ac04144,
    0x3ff4ec102724c0bb, 0x400231e519c7881d,
    0x400eaf82fd23443a, 0xbff46bdeb2871544,
    0x3ffaefa185763946, 0xbff106cf3c1f854c,
    0x4004b79e51a595a1, 0x3fdb5c977a487150,
    0xbff1c7829b4c93c3, 0xc00240b37c6fb5ff,
    0xbff9ae8959ec4bde, 0xbff97d1420539166,
    0x3ff9ca42e65b1cef, 0xbfd9aa588be0f758,
    0x3ffc7f283c7d67e7, 0xbfea412063235e8a,
    0xc0003b5fc7a5c121, 0x4003bfce5e95a834,
    0x3fd3cdf896778914, 0xbfa493e0dca716e8,
    0xc00977dadd9b9d40, 0x40068236916c074c,
    0x3fd78f9cfdf04fc0, 0xc006f82d6f7dbdfd,
    0x3feab3c9659add32, 0x3fbe134c322b82f4,
    0x4001f14c5488d56b, 0xbfd740985c544d88,
    0xbffac92d43dec51c, 0xbfc18c0d35e2da28,
    0xc00e2c7106d40789, 0xc0064fffd151a21a,
    0xbfe789abb79e96f9, 0xc004f8ee6cc24776,
    0xbff58bf147f8e88c, 0x3ff222b592fa140a,
    0xbfef60899014086c, 0x3fec2b9eae0e84f8,
    0x3fe88f0c7703ed48, 0x3ff977170c027f6e,
    0x40036b96c79f0980, 0xbfeef3bfd1bdaa62,
    0x40047c38923c6c96, 0x3ffbe91618d6940c,
    0xbfed35151bfbd8d2, 0x4013201680b253bc,
    0xc001e8a7333f2c2a, 0xbfe1aec627e58a1c,
    0xbfe4f3c5a1c004f4, 0x4003bfe233ca5ac5,
    0x3ff63f5e87d5615a, 0xc000193d1fb76193,
    0xbffd7b6ae8778ff0, 0x4014b3bc0d0b30a5,
    0xc0013cec5ee05966, 0xbfe6c51f49cec7d5,
    0xc003a076e661816a, 0xbfd31e446e27385c,
    0x40190fb61c0a891a, 0xc00968c2f8f05260,
    0xc01005c05d1d0b12, 0x3ffa4bec157f2198,
    0x3fe5167e0f02061f, 0xbffb80ed925a72c6,
    0xc011005ad0dc664d, 0xbfe0212b9eda09bc,
    0x4003ba1492b15d7c, 0xbfe52b3dc4356e48,
    0x3fff93c8887957e3, 0x3fbbda694204f420,
    0x3ff356c19caa9a20, 0x40037b613f8bccf4,
    0x3feafa16f841b830, 0x3fff4f1a62fd03a2,
    0x3fedb18ebc811da1, 0xbfe3417c23871f00,
    0x3ff38e646f8f7892, 0x4011955e8e79c782,
    0x400692e6f8e79098, 0x3fec30ce61428114,
    0xc011ebe00bfbcec7, 0x4006b132c443a136,
    0x3ff330c40bfe68ac, 0xbff28e8617d6bcec,
    0x3fe046c773e33008, 0xc002fb0b68224bce,
    0x3fd7b443d2542f91, 0xc007402d62cd4f6d,
    0x3feda6e4faec3e68, 0x3ff2f0d18e4d020e,
    0x40038f0662b551e8, 0xc00a8070b70792c5,
    0x3fd195df779dbf7c, 0x3ff933b525a791d6,
    0x3fb2852f2c3882c0, 0xc00140c5e523c58f,
    0x40006be728c073fa, 0xc0007b7d28a4345d,
    0x400997bea42fd30c, 0xbffe3cf45788545b,
    0xbfe6c41ff26f087c, 0xc00b39b65d52596e,
    0xbfe87cbd440f55e2, 0x3fe0cd8f0c7b85bc,
    0x400d33ea9dff9509, 0xc00bf57fd9e52ac8,
    0xbff8fdc81aecfa34, 0xbff444da6bf24919,
    0xc011a698c7017eeb, 0xc01508b11a5e5d24,
    0xbfe4cac75f752dd8, 0xc011ea11fc632528,
    0x400ca15e2bd95066, 0x3febee742f526c9b,
    0x40119202722355da, 0xbfa312037004d3a0,
    0x3ff8392d23c75fd1, 0x3ffd53c402422a0a,
    0x4010326ffc92f3ce, 0xbfeed7ad85ca99ff,
    0x3f8eac2323a07d40, 0x400479861ca0d828,
    0x3fcbaec0442cd83a, 0x3ff6ec0f5926f6da,
    0xc00212a436510d33, 0xc00a77acb8d287a3,
    0x3ff481fcd679df28, 0x4011d44e8dd3a1ac,
    0xbff1ae232bbf5c78, 0x4015d4c9c515afc4,
    0x4005fc09c52e399b, 0x4010ff37241e0a0a,
    0xbff24f7579883592, 0x3fef730b119f44ae,
    0x4002e6a2dd03a3d6, 0xbfb0f5cb1330d940,
    0xbfc0bdc090d37988, 0x40073b35e6218236,
    0x3fe7a650ca67c7a0, 0xc00982ec50fc8f07,
    0x4009bd46bf9db1e9, 0xbfd30aca7faff17c,
    0x400678a8033fa27c, 0x3fcd6b7500058540,
    0xbffb53ba2b05133c, 0xc0082bab32be21fa,
    0x4000df395fd904ec, 0x3ff6cf418302d52e,
    0x3fbb62a7922b5548, 0x3fe2edbfb6237ccf,
    0x3ff819fb4be7c7f7, 0xc00978091eadace8,
    0xbfe5bb36fc0790d8, 0x3fd4671182f93770,
    0x4009683546e19d9f, 0xbff93f7227506d08,
    0xbffba680bf4ec589, 0xc0053a10f1605e18,
    0xbff7aaa87f7d2700, 0xbfef250e29617619,
    0xbff6b369418a3a93, 0x3fca783daada8578,
    0x400e769736e5a6c6, 0xc0043526c48de0db,
    0x3fe2574d1e9d4a87, 0xc016a609ca6f7eaf,
    0x3fef2d27b9768cc8, 0x3ff0bfd3be35e287,
    0xbf8f53e1a5344f00, 0xbff3621bead582aa,
    0x4019303cd1385f96, 0x40006681b2cae47c,
    0x3fc45d1c3b7f03f8, 0xc0058fb7ec566b5e,
    0x4015c689afa7153e, 0x4015d49c23662d68,
    0xc006246d32bd3302, 0xbf92719f6e48b640,
    0xbff9fe6f41333833, 0xbfe313b4b8a903ec,
    0x3ff689ae1ca2e138, 0xbff9bac30f6bfe93,
    0x400bbd6c2db699a9, 0x3fe29c990c40c85e,
    0xc014534bc163588c, 0x3fcdc29343c74074,
    0xbff9789c7becf073, 0x3ffe887a4eadb5bc,
    0x3fc34f6f8a1c2e98, 0x3fd7eaaea12de1be,
    0x4009311f7674bfd0, 0xc0039f85e1086a32,
    0xc00d77fc49666c7b, 0xbff37693ded78cc5,
    0xc00fcfb02d3cb354, 0x3fd3cd894f2dc668,
    0x3ff8b2bf5bef5361, 0x3ff72ec004e280e8,
    0x3ff1113b3d6f28c1, 0x3fed78e1f4f03caa,
    0xbffa08c253c53852, 0xbfecfc8e1deef8ba,
    0x3fe8290dd46e3f84, 0xc005e7027b1e8e7a,
    0xc011dad7604e8ddf, 0xbffe21d4c408139d,
    0xbffa1e26516ff036, 0xbfb77da55f40b5f0,
    0xbfd6a219d029fedc, 0x3ff42262b9bf7cad,
    0x3ffb019ec54960c3, 0x3fe7deb707d169c7,
    0xc01377854e5901bd, 0x3fe2c81b8735ae5f,
    0x4003bba9fc43e7de, 0xbfede6b11e4e0731,
    0xbff9f08c10ba39cd, 0xc0041a3309d1d3b0,
    0x3fd67138ff4a9602, 0x4003e4725b72f23a,
    0x40084f15e06df424, 0xc00a1bcd3210c098,
    0xc004deed6d42327b, 0xbff74d1611d69198,
    0x3fdf1e251e5541ac, 0x400978205d6e0e9c,
    0x3fd0b9c210f6aed8, 0xbff23106de28e126,
    0x3fffcdf13670d9db, 0xbff00a4984e5b46f,
    0xc00bf8feff3a6fc4, 0xbfeb3363da45b27b,
    0x3fdd64d22a7c8be4, 0xbfc54f96a16ed680,
    0x3ffc84fbb353c37e, 0x3ffc2eb750dc70ba,
    0x3fe1b4453d4f0528, 0x401021db778f245a,
    0x3fb414851fb9b218, 0xbffe0725e7d062de,
    0xbfdc899c4d0934dd, 0xbf7f800c0be58200,
    0x3fb37ad79cd1c218, 0x3fe7f0b53852ffa4,
    0xbfce09f0ade800ee, 0x3ff55219d8f15855,
    0xbfecfab4b2b46c02, 0x4005d073925cf1df,
    0x400361251a2e7719, 0x3fd03531a19abedb,
    0x3fec88dc8b79a7b4, 0x3ff57080e228ade4,
    0xc00f111e3548bc5e, 0xc0018b19890e9ca6,
    0xc00221b93e151a10, 0x40074400b067f8c2,
    0xc01b8188340bd889, 0xbf58bba84976aa00,
    0xc000130607fb29a3, 0x3ff3b124c7f517f6,
    0xbff9240e25a3d708, 0x40014af734b412fa,
    0xbfb6d1661c509160, 0x3ff4b364b0ff58ad,
    0x400b26fdf78b41ca, 0x3feb1e5f4d24a3c0,
    0xc004090ed35a6f9a, 0xbfcba547823a6818,
    0x40107654f588b349, 0x400290993b7e750a,
    0xbfae9c65235cb0c0, 0xbffd26d15585cba0,
    0xbfde95ed168d842d, 0x400f7479853a0934,
    0xbfeeebe792dc5bb2, 0x4013d46a62ced143,
    0xc011659e08931046, 0xc009c459480b37ee,
    0x4004aa00b3daa802, 0xbffa2f1bb8bc0e09,
    0x400177d9190dbe0b, 0xc0158b128de7975f,
    0x3ffc4242356b01e0, 0xc01479c118977020,
    0xbfe33f59979dbcf6, 0x4005b6e0e22b505c,
    0x3ff44bacc539ba20, 0xbfdff48449dd2b18,
    0xbff3dfc3a3c2eeec, 0x400bf6f4ea3a5bca,
    0x3ff148cf67c3c9ad, 0xc000564f5c0815d8,
    0xc003d25d2c64268c, 0x4006b9843e43ee52,
    0xbfffe1b16d4d59f0, 0xbfdac14ea4500788,
    0xbfeb300fc3f29f92, 0xbfde9fe9832c5a08,
    0xbff50367d0e83e28, 0xbff6dbe91f31b8f2,
    0xc015985cb0c254d3, 0x3ffe1238be75fec9,
    0x4007b56a9fa3eabb, 0xbfc5964cefee317b,
    0x3fc3678ec639dd14, 0xc008468352313f92,
    0x3fe8d8989a47b4b8, 0x3f8d18357cb93000,
    0xc0007ba318be5d60, 0x3ff3dc756e20b7f5,
    0x3ff4a06986b780e8, 0x3ff05bccaa8b86e5,
    0x4005d0cdb0ad4ff4, 0x3ff403d17469a818,
    0xc007131f4ea2f594, 0xbff4f58b4eac50df,
    0xbfe08aa7f2c7d32f, 0xc012119c7e4c2978,
    0xc0010bec1ae8910a, 0xbffe07e39d2d9e0e,
    0xbff57f3cbe3bae75, 0x3ffb2b0855dbf343,
    0xbff1290a91c57813, 0xc00c6e72d9b4c483,
    0x400a0be9a8ada04d, 0x3fa8bbe2af5a42a0,
    0xbfff12c6e1ec56ad, 0x3fd6006e98674820,
    0xc00cb0459dd8f9f6, 0xbfbceaf46ca5e950,
    0x3ffc192eaad0c950, 0xbfee531bdd3b1f50,
    0xbfe33a72878f26a2, 0xbfe69aa4ccc03800,
    0x3fff03811c762f1b, 0xc0018d77fe08d807,
    0xbff56771c04e887a, 0x3ff7a1aa51c3c7ba,
    0x401056ab2a6fb5de, 0xbff259e0f6bc9a36,
    0x3fed49c82fca34fa, 0x3ff8837811efb5be,
    0x3ffa8d84ee24d828, 0x3fe29cdfbb5d398e,
    0x40084eb9db9770d4, 0xbff08ac0a946cba8,
    0x400be5b601b2dc7c, 0x3ff5c6ed2fb7c901,
    0x3f7cc4fd0e133600, 0x3fea478b6a206398,
    0x400e9c21fd068850, 0x3ff9b5ae3468558e,
    0xc002db4b8b8dfb47, 0xc010f95d83c54e8f,
    0x3f7c5f7932e2cc80, 0xc010ed2e98915bdb,
    0xc0038628583c537a, 0xc001c7b4ea2bbce4,
    0xbff7c65a5f26ef30, 0x401406275c86992c,
    0x3fefd15a4ed8c9c4, 0xbff9618304ca014b,
    0x3fbed0d0269b92d0, 0x3ff13ad3d7578b6d,
    0x3fdf0b9ab61ad680, 0xbfe7773086c5d103,
    0x3ff35fbec069d649, 0x40045b8109087110,
    0xbfe19cf02a65c8b3, 0x3ff51fd33033402e,
    0xbff139ea6e9bb98a, 0x3ff5bc4610994144,
    0xbfe890f6d667137a, 0x4005cbf028b0d970,
    0xbff0bd4b32142b0e, 0xbf7ae2f1cd532f00,
    0xc008f2c5fbd4045c, 0x3ff0cae02f3c4d3c,
    0x40018e4d24c46bca, 0xbfd8dfea0ab34c8a,
    0x3fe0a94e408380a1, 0xc00f9a41f1b0e53c,
    0x4005553c26a462f5, 0x3fc6cb638f9213e8,
    0xc003d0de740868a8, 0x4005ff5c629dfbe5,
    0xbfdfc19f4de1b9b2, 0x3fe1ccba51c07f9c,
    0xbfe24c267570ea18, 0x3fed416ed66479c2,
    0xbfeb24fd1a9f78de, 0x3fd2a10a1ead0d44,
    0x3ff1eb335db63fe8, 0x3fe123a3d5a03308,
    0x3fc1eae7b93daeb0, 0x3ff29c1d7bfdc8d3,
    0xc0098417ab5d0dcc, 0xc00c57fd58e3c49e,
    0xc00f70198b030089, 0xc00cc9a9a36be618,
    0x3fdbd2c539fc6d10, 0x3fdfb3ff6a1ed54c,
    0xbfd5953849d2f55c, 0x3fe496fa18f241c8,
    0xbfdf3572887e45c8, 0xbfbd24d3526de1a8,
    0x40014093718a38e6, 0x40043aa99dd182e2,
    0xc0031c131a05abf5, 0x401846b5b0acee2c,
    0xbfc5136198536c40, 0xbfe573656b7c54c8,
    0xc0118de683b948dc, 0xc009be6cc9e9b498,
    0x4008a411881bf5d3, 0x401a9a48a7fbf70d,
    0x3ff86ce6121d6a8e, 0xc00a9429f8ac7f2d,
    0xbff53669ecca7c88, 0xc002c3c5db03432a,
    0x3fe6defd9405ecf0, 0x3ff5482cccc0238d,
    0x3fe1aab08893dbde, 0x3ff948128d34c8f6,
    0x3fde397ea33d8dfb, 0x3fdd058b4474ed98,
    0x3fd7243ef9a3c77f, 0x40126e8fd6a50bf0,
    0xbfd1d9fba8269050, 0xbfdaa321021b5d8a,
    0xc00532158d35b2ef, 0xbfe3a367c1608778,
    0xc00be4d858f4d56b, 0x3fe154fb6556929a,
    0xc000d737cfa1cbf6, 0xbffa68d26d61241c,
    0xbfca74f6e92b2678, 0xbff1661411d2d330,
    0xc00588a41985d7d4, 0x3fd89904520ebb72,
    0x400835e1683d7880, 0x400436c664c99f97,
    0x3fe11457b89b8a54, 0x400b00c9a85fd9da,
    0x4009b6469e5bd13b, 0x3ff34c3fc82717ce,
    0x3fe5884438cffd48, 0x3fd467d8c3d1d820,
    0x4013184c0bce04f0, 0x40109c8006c9d97c,
    0x3fdd127935614d54, 0xbfee1c27619eb7d4,
    0xbfea912f675bd57e, 0xbfb793b64b023a00,
    0x3ff59ce6aa1b48a3, 0x400506340f3647e5,
    0xbff23777ce6798ba, 0xbf989e8efb2dd100,
    0x3ff3a7eb6f54ba03, 0x3fcb4d31dbd89c54,
    0x4013b1a3f5a496d4, 0x401421f88b902107,
    0xc00619d09c4c35fa, 0xbfe26537089463bb,
    0x4013260a439ae5b2, 0xbff20fa07713390a,
    0xbff8d04c57cd09c8, 0x400764dbbd9d4af2,
    0xbfabb9ec32f988a0, 0xc0056df5b3945be2,
    0x400cc5a3c3cd7972, 0x400884cfe9a65038,
    0xbff448406fe92525, 0xc0045df85b4fba1e,
    0xc00bb3c8bb10e31e, 0xc008e881bb90aeb2,
    0xbffa3b14875b9374, 0xbff871bb570c6e3b,
    0x3fc2ece985b5edb8, 0x3fd77d8178b6ea30,
    0x3fd3f1c7fc460960, 0xbfeaccf9d0b2ea10,
    0x4009732cf5d0b000, 0xbfeb35489a829978,
    0xc0018f78c34b1715, 0xc01495206b64d806,
    0x3ffd4470eaaae443, 0x4002a1df25b75480,
    0x400c052d966802c8, 0x3ffbaedf441fea2d,
    0xc007937ebb7bda5c, 0x3ff17bcd912c4540,
    0xc00e7dd2c7e3f41b, 0xc006ee5df84ac04c,
    0xc005ba09292583ac, 0xc005712c1a5a8ff0,
    0xbff7929309a39fa6, 0x3ff22c176ea42c89,
    0x3fbcb9a4df218ef0, 0x3fa5a653e63f35c0,
    0x40101d431d075150, 0xc00cb78cbe096045,
    0x3fea72727f83118b, 0x3fd07123d64db12a,
    0x400c5aaff1f80cee, 0xbffadc25acd46e1e,
    0xc00d99efc725a351, 0x3fe0438cc7b0924a,
    0x4008aa906d47492a, 0x4002257ffb637c83,
    0xbffda2e70d630f60, 0x3fffe94cd399bb6b,
    0x3ffd551af00e1874, 0x3ffddc466964a78e,
    0xbfd458326608f7b8, 0x3ff4a26ae0e591fa,
    0x3fe936c53999019a, 0xbff254051b85d81c,
    0x400550afc0e1c366, 0xc00573374f8098a6,
    0xbfd98cc5529993d2, 0xc09666fc4e690dfc,
    0x400b7ab36ca7611a, 0xbfffb6653128915a,
    0x4003d9ab8ddca7a3, 0x3ff7bb146e227a6e,
    0xc00738a937551b0b, 0xbff1bb3c5010e934,
    0x4003009b8d0089b6, 0x3fed629938eba9fa,
    0xc0012d091e9fa179, 0xbffc9b88c08d4938,
    0xc012aa454bf6b2fc, 0x400b5a15deda612e,
    0xc0046f1f83f6a500, 0x400a4ae019f1a79c,
    0xc007e912d39e77db, 0x40093f2c188bdc70,
    0x3f9280f634cace80, 0x400cf40d9660507f,
    0xbff891a8735cdeed, 0x400055b358a00bef,
    0x3ff9904b5f41f1b1, 0xc00ee8d1245b10bc,
    0xc012455e2baddf71, 0xc002b0cab75ea766,
    0xc002e7883a2b179b, 0x40009af95ae4e500,
    0x3ffb4d9e0e1455cc, 0xbfdaaf7136ab52a0,
    0x3fec41c79f351f78, 0xbfe568fea588dd3f,
    0x3fda5e0645d13c55, 0xc00f93b29e92a78c,
    0xc01a0c9f0290c1da, 0x3ffcffc9562d6dd4,
    0xc012d6de173469d6, 0xbff5ad5c4c85d45e,
    0x3fdef642c741f43c, 0x4002a3b05e14cbe8,
    0xbff3f56d105089d0, 0xbfd6eb7a68356713,
    0x400e68b4668cddb9, 0xbffaea8cdca7edec,
    0x3ffb17e71052faeb, 0x3ff0f8235e4656cc,
    0xbfd7da7e875aefd8, 0x400498f1863424e6,
    0x3fe223059c6a0588, 0xc001787750c56f72,
    0x4006f954c4048212, 0x40165f118b3a78a6,
    0xbffa6ab1565aa3cc, 0x400432b8ba2952ab,
    0xbfdbd0c044daf65a, 0xbff0786e33693dfa,
    0xbfef53f148ba6cdb, 0xc00558634d18dbbe,
    0x4000b0f17c12f0ec, 0x3fe850db91876e71,
    0xc003d91e75a6d52c, 0xbffe0678a886bcd6,
    0x3ff22a743c9d1552, 0xc00bb40c7c2b17da,
    0x3fe4854bbe26793b, 0x3feed328817fe7ac,
    0xc012166baddb16db, 0xbff85b2eb0308c70,
    0x3ffad82f799ea149, 0xbfec3780b5999d9e,
    0x400dfb69589916f0, 0xc0000cd3817075fc,
    0xbfeca086678a62fe, 0xbfe9c55c31a0ed56,
    0xbfe2187218fa9322, 0x3ffa55c2327a3081,
    0xbffc3f45bf0748dd, 0xc0123e133682a379,
    0x3ff523d29395f282, 0xc0065d441f1be446,
    0xbfe0cc4f2476d116, 0x3ffd97bd4a2dfc61,
    0xbffbc3ae8e7b7be5, 0xc00b1cf5c807cfab,
    0xbf6fdf4032bbb000, 0xc00c1ce1d0fdf05c,
    0x3ff083f049ef1c9e, 0xc008bd642fa23caf,
    0xbff608fc4c6406e9, 0xbfec0bb7435058fa,
    0xbffb9d4c7d60ce19, 0x4007589a4946fd60,
    0x3ff7dd4803c56311, 0xbffbba64bcf774b4,
    0xbfe7363d51745eee, 0xbfefa4647e66d852,
    0x3fc6a1818317df78, 0x400273180e834c6d,
    0xbfd82236d36fbe28, 0xbfe6232b72d00cda,
    0xbfd0a20cd8ea2558, 0x3fe9d239d9a93e3e,
    0x3ff22ad7e401f42e, 0x3fe8b75290be4a34,
    0xc0081a793cb7bca6, 0x3fc1591455b21b94,
    0x3fea118833dcd13c, 0xbff11e92c1f517d2,
    0x3fc40d54d3c4b450, 0x3fcc9b85c6cbdda0,
    0xbfd13c39d762aee4, 0x3fdf38f3d324e5c0,
    0xbfe342f67a0a0d04, 0x3fd6207af8f1d618,
    0x4000cbdcd4b12046, 0x3fdf62a85db3924c,
    0x3ff6d1a30a02f077, 0x3ffb1d167d37faa7,
    0x3fb144e095435b40, 0xc00cf66e34e9295a,
    0xbff1ec83bdebbe44, 0x3ff562f6e97c77c0,
    0xbfe69442e598d797, 0x400486559e86a2a4,
    0x3ff08ec91b50efce, 0x40120dc1b740c891,
    0xc00d8c390c00246f, 0xc004aeff8f9fff7a,
    0x400cdd1ede650d1a, 0x3fabebb026495b40,
    0xc00e56bac7d69a12, 0x3fd4171b09c19c0a,
    0x3ff66c37815df4a2, 0xbfff90916bc7098c,
    0x3ff400de55896313, 0x4002c65254dc51ad,
    0x4007b655d0aadf2c, 0x4000ed219fdc0a62,
    0x400224b054eb3726, 0xbffd92099aaf834c,
    0xbfff8422722e67fe, 0x3fe2369c7b4c677c,
    0x3fe8bcfefe5aba5c, 0x40103706e77bc2ce,
    0xc00719c60722bd48, 0xc00e3287c6ffc3d4,
    0xbfdee94a6dadc1cd, 0x3f870db00cad4c80,
    0x4007242ae9b25567, 0x4009b28528ca9e71,
    0xc000eef9a66515bb, 0xc0052077f68ff53e,
    0xbff0f3fc27e06012, 0x4001622dcba8f302,
    0x3fe58a426a8a989a, 0xbfe5456bb52331ae,
    0xbff183662a798f7b, 0xbfed8680f2501647,
    0xc004cfcb0627f661, 0x3fd6398b090065a8,
    0x3ff173501ac080f9, 0x400639cda01dd087,
    0xbff2d73cff311537, 0xbfeac7104a2ad210,
    0xbff0ac9f38235d15, 0x401834051d4ed688,
    0x4011fc33e6a6a2e6, 0x40071960c5ab9ab2,
    0xbff982c57c7e4a9c, 0x4008da1a7c8fcec4,
    0x3fe1dedc703e7303, 0x3fe3fa8613710c19,
    0x3fdf48b62da94eb8, 0x3fff36a16ad41bf4,
    0x3f8f459104f35100, 0xbfee77336aa21b7d,
    0xbff035b7f8ea8399, 0x3ffeca031c4d7031,
    0x3fc709755dde5498, 0xbfe36ccedba0e5a6,
    0xbff678fa9746f1e4, 0xc000166c3489e6f0,
    0x3ff800220c054ec8, 0xbfe94093bb8e215c,
    0x3ff72893461d44a1, 0x3fdf2cf08345c6ac,
    0xc013e8556a5ee6fa, 0x3fecc4b6e72b6602,
    0x3fda8cd3d565b080, 0x3ff03d0a999f91b1,
    0x4003499688667ca9, 0x400368870235660b,
    0x400822101fde8102, 0x3ff74e0596f72d34,
    0x4013cc000f0b1d88, 0x3feca985a6a30fe4,
    0xbfbea79394ca83b4, 0xbfe87c2a16f0e1d8,
    0x4010817a9f2b2b7d, 0xc0156ff654e7f370,
    0xc008b6df398bf7da, 0xbff5996e397a0b8a,
    0x40035ec2788831e8, 0x4002819f10ce2c4c,
    0xc00b5dfff09c39ac, 0xbfe43dd5ce56f6c8,
    0xc00dbbe77daf8772, 0x40031456dc26383c,
    0x3fddb095f4af4092, 0x3fd0e9c1a960b728,
    0xbfdef32a9034c21b, 0xc004006482be7011,
    0xbfcc476f38077b50, 0x3fe097d305a20b36,
    0x4011b5bb61c6b4c2, 0xbfff3b1be79523a1,
    0x3fcd57646051c0f0, 0x3fe414e275ecfa10,
    0xc00484b5e4f413f7, 0xc0034b94b14bf7ca,
    0x3fa679e8155ce9b0, 0x400cfa1180bfad6a,
    0xc0102062556f58e8, 0x40157b758a983550,
    0xc009c723eaa0e11d, 0x3ffb62a5050ed19c,
    0xbff9582fa97896a3, 0x40125ad1a78feeb5,
    0x3fd8809700cced9c, 0x3ffdc95bb46e9b3e,
    0xbff93bf12bc9e45d, 0xbff93605e8675952,
    0x400bf61bfb46a70a, 0xc00818f1cdf0929d,
    0x4006a8c9a484de38, 0xbff02fe730d4a19a,
    0x3ffe3e6c7a7793d5, 0x4006b922fbe6f355,
    0xbfc21e88ae7e7510, 0x40126e0ecbfa0dde,
    0xc0009b01f57b2708, 0xbfe95f01df64c11e,
    0x4011427a8dfe949d, 0xc003f022b7351e90,
    0x4000388ce014e179, 0x3fd90c0a7e924130,
    0xbfe46ba8901057ac, 0x3ff34e3b9341aefb,
    0x3ff20d06c389622a, 0xc0021b26bbd67eac,
    0x3ff0c5f505e7671a, 0x40076b64284168a9,
    0x4015e927b3f0ba88, 0x3ff677f630d4dbe6,
    0xbff826a51d67111b, 0xbfe91756f253040e,
    0x4010b7f9de7d9506, 0x3fdf4c35ec8bac0c,
    0x3ffbeb92683fd8ac, 0xbff4291e12f241e2,
    0xbfd8ef81b35bfe2b, 0xbff9ca9aa81e0b4a,
    0x3fd623aead1eae5e, 0x3fecfe3ab93e37f9,
    0xbfd9d70776b4a0d4, 0xc01383fbd0f7467c,
    0xbfe6729781524f12, 0x3fe52a1380aecbb5,
    0xbffc934ed3bab51b, 0xbfc4958109a28d8c,
    0x4006cd9f013aa8e0, 0x3fec7d4613c2f2e8,
    0xbffcac84c313d31d, 0x4000ce9f6f79ea9f,
    0xc00e0441d4879f2a, 0x3fb46ef496472838,
    0xbffb934501bf09cc, 0x3fd116142dc03a74,
    0xbfd366555c278598, 0x3fe1bab240ab40ea,
    0xbfdc61af489c6ded, 0xbffc33dc02ad35f3,
    0x3fdc210029f8df7e, 0xc0036fc159a69fde,
    0xbfd7d2a3b65b8854, 0xc0002dc9e2f9227c,
    0x3ff255ad58e56fa9, 0x3fe811ed7d516eaa,
    0x400791a1bbb53dd3, 0xc004c72acfc6904b,
    0xc001a39fb734224e, 0xbfd035d0b9d4b4a2,
    0xc00126e2554f512c, 0x3fbd3dda63f8c968,
    0xc00f5d568cf703ed, 0xbff08162c7644201,
    0x4001bba9541b5325, 0xbff563f86f6d90b8,
    0xc011c5ff31a9a1d1, 0xbfc9b119adc97084,
    0x3ff15d20b3fe706d, 0xbfe819aff4369759,
    0x400b348d8c7fe4f3, 0x3fd93c452e6b63b2,
    0xc012982e68e88282, 0x400d0f75d3d333c8,
    0x3ffabef6c6342d6d, 0xbfc0bff2169b3088,
    0x40020d05e4705830, 0xbff92fcd5d844ec5,
    0x400280ef3f6a9e8f, 0x3ffc78f8c4ba1b32,
    0x3fe72afcc0070b86, 0xbfe0a1bd515276d8,
    0x3fd5315149984ad0, 0x401554e13d26163a,
    0x3feda66d1eb4a8f4, 0xbfec7183be35ed5e,
    0xc00bc8f341a244c6, 0x3fe058c3db166394,
    0x4002ce9cf6cfd8e3, 0x3fdf1fbca298797e,
    0xbfc352ffded7bff0, 0xbfe7b9a1d300a3b8,
    0xbfec0899a2410522, 0x40037d71aec18bae,
    0x3fcae9aac1a26bc0, 0xc00a4f053b83c7da,
    0x3ffb03eae1b53f10, 0xc010cb03425cd080,
    0xbff92fd6e358ccfe, 0x3fd98059b1f10915,
    0xbfe574e1f2d97752, 0xc00b6b2000e88ba3,
    0xc004df0b0577b47d, 0xbf48fb87c0f75800,
    0x400b6b23ebc00af4, 0xbfc047735de75a0c,
    0x4006c94fd620c5fa, 0x4005f942e16abc46,
    0x40047ff188a56896, 0xbfd1820e386637c0,
    0xbff858c5710d1f12, 0x3ff7618f2ae5a6fc,
    0xc00ab90e421f5e61, 0x3fe9cdcf63072993,
    0x4004c2b5a1521a00, 0x3ff3bd302fab9b0e,
    0x3fe1b5ab51553b80, 0x3ff5e360f72a07ac,
    0x3ff2842376f76ecb, 0xc01183e3b0a00052,
    0x400f14dd3dca7cb4, 0xbfb8dfe0c779f620,
    0x3fe2c0c39b7863b2, 0xbfe064019990b9ad,
    0xc00294cba63c708b, 0xc0083ca83a7a3a2c,
    0xc00be9c757c7bb53, 0x3ffea2d52c69c02b,
    0x3ffaa8bef32be926, 0xbf95f7efe390a020,
    0x3feceacb574c030c, 0x3ff26666155dc434,
    0x4009f9752bdb4d0a, 0xbff08a271e962295,
    0xc008aab299cb852a, 0x40049131fa0cef58,
    0xbff869ed50b54b13, 0x3fcc2a3f21dc074a,
    0xbfc0f6ee7ff844b8, 0x3fe0faa26445810c,
    0xc000110e1fd4e6b1, 0xbff68d969e259862,
    0xbff3e4f8b9ce1a7e, 0xc016878d200a350e,
    0x3ff9606ba45c09b0, 0xc012836d772febf9,
    0x3feb3a7643cf10e6, 0xc0048039d2220006,
    0xbffee1cb749d2377, 0x4005aec1e1cd840a,
    0xbfeff0defc2921c0, 0xc0001659d6cd68a0,
    0x3ff4bea9f8f13b83, 0x3ff5a371cd96b329,
    0x40075d3d91768e54, 0x400318550fdd9742,
    0x4001bae9583e7d22, 0xbff19d4cb434a4a7,
    0x4004593b1995f983, 0xbfd7225f38993bd2,
    0xbfbe247387a578c8, 0xbfc40c0d766ebab0,
    0x3ff22fd5c204f202, 0xc0042aa636d865d0,
    0xbff4523da2d4c9ee, 0x4000b36d4042cf37,
    0x400e553d7f3f91c5, 0xc000c3469ff8d73d,
    0x3fe28de89ad6c9f2, 0x4000feb1261220d0,
    0xbff06764630b728d, 0xbfafbba36d7b4550,
    0x4005414c074301ad, 0xbfec0f603a94d304,
    0x3ff447c72bd077ab, 0xbfea4d671abf7664,
    0xbff5bb7d88a445d9, 0x3fced7aed8cdc415,
    0x3ff93371365b2d04, 0x400575309f19e416,
    0xbfb1e14ae915d040, 0xc00547c7c3dc301e,
    0x400510d1a5dfd1e2, 0x3fe753aca6d69958,
    0x3fed08c2cf7eb786, 0x3ff7e2c71ab7e885,
    0x3ff052d8d981760f, 0xbff1f448e2ca15c0,
    0x4019231ed2fc713b, 0x3ff5148296d483ff,
    0xc0061da214ac5886, 0x4012027413c82d97,
    0xc0070c5df10af410, 0x3fd2e6d71eddcba4,
    0x400eacccf8980afe, 0x3fc2418e6750d36c,
    0x3ff08827267e7d98, 0xbfef06740346dc55,
    0x3ffa9ded8044b880, 0x3fe22c7182e50094,
    0x3ff0e40b0ecbce5e, 0xbffeaa4d179203e6,
    0x3fd5960093844170, 0xbff734708a14c485,
    0x3ff82178b8e7f2d2, 0xbfe465b26e2bf879,
    0xbfe129a16799aa03, 0xc00625f546868923,
    0x3feba3f01a663be7, 0x4006e195bf613e59,
    0xbff2f34bc7bd3761, 0x3ff262c269f81464,
    0x40129cc12392126a, 0xc0139511fc0c542d,
    0xc011b48e4e3a393f, 0x3fd0660710be5cf0,
    0xbfe055e391e4d7c4, 0x4001130241dbdeb2,
    0xbfcc577fcffbdfa0, 0xc002cabe3a346654,
    0xc008a7998d514fb2, 0xc0051f84c29d70ec,
    0x40123bc50f383b70, 0xbff33c98fa23442c,
    0x3ff264a2637b43c2, 0xbfd09abaf330aca8,
    0x4009479786511875, 0xc00cd963043d0874,
    0x401a69dc173804b7, 0x40000f1458a7b629,
    0x3ffb37f57e2ab6bc, 0xbfd53a9c88cd6da0,
    0xc0059114308f1c14, 0xbff9b4b8ea433e4b,
    0x400611225a14d1bb, 0xc003b1e63b97863f,
    0x40031288a7b3c35c, 0x4005fef479bbc108,
    0x3ff9357f9e56e2cc, 0x3fd6760d35899214,
    0xc00d8df153a4cac2, 0x3fd4b75bde076b94,
    0xc01034d1a05cb02e, 0x3fd57f2e7a0d7e87,
    0xbffa6c618e90df30, 0xbff3723fcfd5c8c5,
    0x3ffb816d17ca3036, 0xc003c0cac3179d4a,
    0x3fee69ac37dd5908, 0xbff540f69656c606,
    0x3fc49dfa7714158c, 0x4001eb8e5de7aaa2,
    0xbfb9607c920d5ab0, 0xbfb066e990661c20,
    0xc01693a905b0e394, 0xc00212732977259a,
    0x3fe8a9ee51ca2c82, 0x3fe31248f03da331,
    0x3ff25e8a8ba5fa2a, 0xbfdba83df9396868,
    0xc010a627c39e7b24, 0xc00901a1ad440417,
    0xbfea304dc4e4053a, 0xbff272a5184762df,
    0xbfc7cb1a314f6970, 0x3ffac1a8bd95794a,
    0x400da2d979639b34, 0xc0038bc40e9e85e4,
    0xbff815c1e08920c4, 0x3ff7869752c8215d,
    0x3ff237d9d1078d64, 0xbfa4089d0b78f9b0,
    0xbff5e5bfd8052556, 0xbfe91ec8911f9802,
    0x40063577219fc2be, 0x3fe1342164dc3470,
    0xc004664a40157c64, 0x4018ca7b2096fffc,
    0x3ff46d06390e1230, 0x3fc4a27ed0369fc8,
    0xbfd6e1366b925838, 0x3fd3d99286ce2880,
    0x3fcf8fd4c15fee78, 0xbfe58e709bdb5f53,
    0xbfcdbe8b81f9b520, 0x3ff9898509e6d35e,
    0xc009c057aac36d99, 0xc00882f227f06714,
    0xbfea123ea597b679, 0x3ff4499025ba4726,
    0xbfec987646c8fb1a, 0xbffc942fd8312e5a,
    0x3ff71ae398917141, 0x3ff32f02347e0eaa,
    0x3fe2c423275438de, 0xbfac3b6b91c803a0,
    0x3ff8cd988748ce8c, 0x3fe0cc9e3af81c8c,
    0x400a388dc52a9f8b, 0xbff42e53a5050910,
    0x40014b89780d162e, 0xbffbe5290da40ab3,
    0xbff0671192284212, 0x3fc267273b5b2496,
    0xc0062f6b219a19f5, 0x4005481d21d8e46c,
    0xbfea58f6396bcfec, 0xc00ad9fa7dbd2e8a,
    0xbfd024c6c3005cfe, 0x3f9ac5474b270680,
    0xc00026c3e2c92a2f, 0x4006dc84929cbcfb,
    0xc0037c020efb4a5a, 0x3ffebb9ea85ae9da,
    0x4007c20b510456b7, 0xbfe0e5c9f2ebe843,
    0x3ffd6f7dc5ac3129, 0xc008fa83ffbcb4fd,
    0x3fc2499d18775774, 0x3ff5693724b5d56c,
    0x40070caa0edb31d2, 0x3ff5e816f8cfd0a8,
    0x3ff0b273f8396425, 0x3ffbd64bb2241d87,
    0x3ff5f07b6d312c78, 0xbfebde4fdab7e52c,
    0x401118d3e5847ce4, 0x40090c430f3a3730,
    0x3fb9261ab5b09ba8, 0x3fc7660d6994415e,
    0x401298eafa175606, 0x3fe8b473e24a467e,
    0x40000a0fed1a2251, 0x3ff816ad1a837ac6,
    0x3fd33a777ec3280c, 0xbff7553babcebcb4,
    0xc0041b317c194862, 0x3feb91457df540f4,
    0xc006d46756131aa8, 0xbff43415d16fcba8,
    0xbfd7cd008031be30, 0xbfd9712fc101ba57,
    0xbff2990972e795de, 0xbfd036be1bd200c0,
    0xbff8860d470190c2, 0xc0011e573374d0da,
    0x3ff4c9466fec853c, 0x3fe2d396950b732e,
    0x3fe8bcd13559a593, 0xbfeea3532695d38c,
    0xbffa38592f55d17c, 0xc003dadc182b617c,
    0xbfd2c4a96397ded0, 0xbff959c37ea05e14,
    0x3ff1609154f7840b, 0x3ff6913b5f54f85c,
    0x3ff58843c26351b0, 0x3fe8518d77eadd64,
    0xc00aa5147880e8b6, 0xc011bd4fc9ed4053,
    0x400a9ae95d8b4ffd, 0xbfc55faf8bb27390,
    0x3fd47e9e22ddfa15, 0xc0002e6d3ca0651e,
    0xc00c716354ec9a03, 0xbfd786dc7c3f123c,
    0xc001917f5bd88320, 0x401285002311d2b6,
    0xbffd9546ace98fd0, 0xbfeedb1c72d39bd2,
    0xbff28475f51d2f3d, 0x3fde6ded916722cd,
    0x3fe0f5cf8d276928, 0xbfe3a73ef049d14b,
    0xc006d501a8497e5c, 0x401c0c609cd512c4,
    0x3ff3256637c08ce0, 0xc006a6ce0f82c460,
    0x4002278b62812529, 0xbfe2e14882110570,
    0x400c9ee42b084f26, 0xc0107dc2e6ed0c9c,
    0xbffd613dac38c7d2, 0xbff4e01cf022892c,
    0xbfe69140269c82a5, 0x400151bf49d6eb3a,
    0x4003d3540636c49f, 0xbfebe1efd15c48ca,
    0x40144f446b2b003e, 0xbfc39912daa0f318,
    0xbffaae6df719f127, 0xbfcb5a5e30fa5950,
    0x3fdfdab130432dba, 0xbfe68971cdceefec,
    0x4012215a791da536, 0x3fe32e6c4bb9d663,
    0x4017f6916d074ab6, 0x4007a11cea35de0c,
    0xbff87c148a36a2aa, 0x400245cf3ceb6a95,
    0xbffa1015d3ba21e6, 0x4016162a608bca6c,
    0xc010498562ef4462, 0xbfed538b9314cbc2,
    0x3ffa1403eff03922, 0x3ff0b99d50d9a737,
    0xbff6154af25f7a6c, 0x3feaf3d28ae90d2d,
    0x3feecb30c10076f7, 0x3fe6389673d33f27,
    0xbfdf623b1a099902, 0xbff691ae934a3997,
    0x3fd9f469c0066bee, 0x4010b857d374fd3c,
    0x40002e564a570423, 0x400c966d43cdf2cf,
    0xc005b124424c5778, 0xbff9bde88d86c55e,
    0xbfdf9824284ae894, 0x40124edeac3fb0c6,
    0xbff61bae351c9bb4, 0xbfe5dad1754511e1,
    0xc013fd3dc6f226a5, 0xc000d53fc7e1bd99,
    0x4009b8d3b353731c, 0xbffe37163b2f90e4,
    0xc0111f95a25ae1c2, 0xbff67c04a628d4d9,
    0xc0098de5cdaec200, 0xbff42e5f53047e5f,
    0xbffc4138758a75d7, 0x4011c99e3766ed3e,
    0xbfe76d6cbbc5826b, 0xbff69fc1f5a7c096,
    0x3ff7e418ce644369, 0x400ebe86992aa674,
    0xbff2025027e424b4, 0x3ff7b00d0cca005e,
    0xbfed34299c2687cf, 0xc003f78b10a8b062,
    0x3fd82c8b3268a8a0, 0xbfc386deaba2ff30,
    0xbfd1f97915507620, 0xbfe7419d872c8de8,
    0x400cd9cc43b22271, 0xbff312a90e6ec812,
    0xc004106356af7a02, 0x3ffd1d58d13c700a,
    0x40019e270aca6520, 0xc00b131ee0dacf40,
    0xbffec1e51337e7e9, 0x400440af36d741dc,
    0xbff63f645d046bd6, 0xbffe8ae10c1e3f09,
    0x3ffed60d32599383, 0x3fb016b489eac3e0,
    0xc005bd17eb2bbcdf, 0xc0110d56ede632b8,
    0x3ff21ede8863ec99, 0x40088e55b6a7c9ae,
    0x4005463c5df413dc, 0x3fcfc69160be2de0,
    0x3ffe7bfc88801eef, 0xbfe49b1d317a484e,
    0xbff7562da5ab92a2, 0xc00a6e20d8634596,
    0x400121fce021755a, 0x3fed7504921205f2,
    0x40028e9a8f1093b6, 0xbff5e53764371586,
    0x400393dc9123655d, 0xbffc5d563cd0028e,
    0xc00e923f0fc18095, 0x3ff1c0dd464448f8,
    0x40136c3973119be1, 0xc01061e424a970c6,
    0x3fd324713b0d8f8c, 0xbfcb5c222bd425b8,
    0x3ff42925712aa695, 0x400683aefcdafb0b,
    0x400e637e78b6bb1d, 0xbfdfa2caed1f9a67,
    0xc00e3d81f9df73df, 0xc005f76add030a98,
    0xc01078c3f03c2782, 0x400b12fe32796038,
    0xc01175c4a66d4f65, 0xc000710291915ab5,
    0xc00064011024d7f6, 0x3fffee3654e221f9,
    0x3fe55223624acb38, 0xbfe979a8dd83cf73,
    0x3fdf4b61d53787ea, 0x3ff6f887b850885c,
    0x3fb3be8e98466f58, 0x3fd277c76f0a6f3e,
    0xbff2fb7f44413630, 0xbff59c7e716fbd83,
    0xbfff05faf80a9516, 0xbff9f150a6e2c27f,
    0xbfe39887c9c82f1d, 0xbff54f7bdff47b40,
    0x4007f7ab927c0e00, 0xbffccaf6801908c2,
    0xbff7074d8ea0de2d, 0xbffe6d781e5f60c9,
    0x3fc59d36eea855e0, 0x4013665b915476a6,
    0x3ff1b341d9be0284, 0xbfe3040b346875f8,
    0x3fdb1f780e6f253c, 0xbfe2ae58a1f3d1fe,
    0xbfd01910f15bd7f0, 0xc00ee48871306944,
    0xc00385192420e096, 0xbfe00d3a4717df35,
    0xc00915796aef6f52, 0x3ffa7fbfa5aaf074,
    0x400a59800b66b31c, 0x401b1f41b85aee64,
    0x4006fbc28cf0a958, 0x400328e11f3adbe5,
    0x3fd6b3120f4a4891, 0x3ff4e0460732c134,
    0xbfd36a15a732f846, 0x4009c5071d8b44c7,
    0xbfd18d2a3d7ba856, 0x3fe5e2c0fa5ca862,
    0x3fbef9657b08e660, 0xbfedbb677ac8b5be,
    0xbfd485b348c7ae98, 0xbfc4a22ecce8e540,
    0xbfe9da9628e4cf3f, 0xbfed5453eecc5fe8,
    0x4007eb8adbe10fdc, 0xbff6921026436911,
    0x4002bb61c9118dc5, 0x40008394a82a65ba,
    0x3ff42a014b20cdea, 0xbfcd6ee6a21de190,
    0xbfd2b415851a9748, 0x3fdfbe233b6941ae,
    0xc00373639f31a014, 0x3ff605da39b6c36a,
    0x400408cbdc980eae, 0x3fe9e114f4aa08ca,
    0x3ff7994bc75149a2, 0xbfd8c41e9e21e718,
    0xbff5a1037edcedee, 0x3fde39459f4cd63c,
    0x4001997e96209ee3, 0xc00257e0b9745458,
    0xbfca5a6974fbd7c0, 0x3fe2b3877b40c8ec,
    0xbff90052d1c0627c, 0x3fe46dcb2a2c5ae3,
    0x3fc1f23480c62940, 0x3ff01e3636e7ffde,
    0x3ff4bf8823901301, 0xbfd30f699d079438,
    0xc00519b3ede40072, 0xbffa5fa8a14f26bf,
    0x3ff98f470018f442, 0xc0065410aa6b23e7,
    0x400c5c963bbe3797, 0xbff28006a47c98ca,
    0x4000837389848d5f, 0x400af2c6ca2cfe5f,
    0xbfeeeffa85d6c970, 0xc007077560cc3faf,
    0xbff125e06289b1e5, 0x40025b920d64908b,
    0x4010ad56cd22f258, 0xbfe39681ac301a73,
    0xbff1a48743261404, 0x3feeadef178a2e08,
    0xc00339661c617b62, 0x3ff2923e8704a200,
    0xbfdc24e18e4f03a8, 0xbffd362a263ddb45,
    0x3ff1a1716a748ef1, 0xbfde02d7d700329e,
    0xc00062dd84f34018, 0xbff4e5a338a68674,
    0x3fdc7aac73254d8f, 0x400240451a5b6a79,
    0x3fea0e75db2cd40f, 0x3ffbb29063673586,
    0xbfed138b25919240, 0xbfb973aed37dbbf2,
    0x40059ebc14ba1868, 0x3fe35d99edacaa7e,
    0xc005909875bf73bd, 0xbff2b26a6283c929,
    0xbfecb1ed9da4c226, 0xc000abc8c51fe8aa,
    0xbff69f93c4e1fbaf, 0x4005b04e73682edd,
    0xbffeaec4f2f7f9a1, 0xbfd0613beb10723a,
    0xbfd071c478fe311e, 0x40097a55c791e321,
    0xbfe1d7af853bc0d7, 0x3fc76882e37a6bbe,
    0x3ff60777268c6d8c, 0xbfd110e38158ba58,
    0x3fd169b86a0c6a00, 0xc00416fefd2ad3dd,
    0xbfeaf59d06fa2a9a, 0x3ff8a07afa0404af,
    0x3fe3432e9d90535e, 0x3fca49cc028e5763,
    0x4012f4ffeb6217d8, 0x3ff24c045a001f54,
    0x4003a08e9f696242, 0x3ffb1d377261ea5e,
    0x3fe5ac92051563b9, 0xbfe1357084922bc6,
    0x3fe312f576fab894, 0x3ff9959614eada10,
    0xc0015572ca1d4832, 0xc00f4f4e61018b7a,
    0x40108f1a03d5209c, 0xbfefd89ed53d8b48,
    0xbfc7ba1b2ff76ef4, 0xbfed1bdf195a8c67,
    0xbff4d65b7b025806, 0xbff4275ea0bc0c9c,
    0xbfef81be269a22d8, 0xbfe3a8472037bd06,
    0x3ff25ea00584c1c5, 0xbfe0fde5825d2964,
    0xc0002bbe0bb43b19, 0x3ff1c8d7fab1af36,
    0x3fffbe6768e89f30, 0xbfb3e6a621a5eefe,
    0x3fe228d02ae45fae, 0x40003ab6e975ae24,
    0x3fb9f001f007aae0, 0xbff4f5269608c6c2,
    0x40117083ead04c83, 0x3ffed49a9fe024b6,
    0xbff6c31e743cdbd8, 0x3feabc6235182acd,
    0x3ff153120f4fda2c, 0xbff442f2f13f7a20,
    0xbff8ff28179a395d, 0xbfe7240118eec8ce,
    0xbffec8f7bb2ec4c0, 0xc0080176387b50da,
    0x3fed3ed6bc33ba86, 0x4006502776cd6f1a,
    0xc00d3969d20037d5, 0xbfef60df3d9b1019,
    0x3feb59a0649c28a0, 0xbfdb3c83d3db408c,
    0x4003ee7e7e97388d, 0x3fc519b8a09a2b40,
    0x3fe8456d6bca7628, 0xbfaef25dd6abeea8,
    0xbfec33c722e24e86, 0xc018cd5fdf80254b,
    0xbfe3ada08108d8db, 0x3fd1d8b44724fb64,
    0x3ffebd205e3ede38, 0x400b4c88e7e1496c,
    0xbf701365e3a9fde0, 0x3ff0ed3d181c1b5b,
    0xbfe0852e56d9ca94, 0x4013fd5231bf231c,
    0x4006e6e0a9294117, 0x401306b3ca27fdbc,
    0xbfcaa41e025c814a, 0x3ff935c5d1f789c0,
    0xc0085a530dbb342a, 0xbff8263c97044fe2,
    0xbfd18becbc8b814a, 0xc00bd85bc8bdfa30,
    0x4006ad3af2bf55ba, 0xc00f4738520d629f,
    0x3ff3d9601e39b675, 0x3ff43c276ed4b732,
    0xc007334301602e62, 0xbff90303114f93e2,
    0x40018f17f0695fd2, 0x4001c35f6113ff42,
    0x3fc1c491c9a93ee2, 0x3ffad158907647e2,
    0xc0030f71fe691ae0, 0xbff16a76dede27c0,
    0x3fef15f84f583860, 0xc004b676172d2e5c,
    0xbff538e36fa9c45d, 0x3fdfef0aecc8f5a4,
    0x3ff7d86f1dc11d36, 0x3ffc6bd77237cbfb,
    0x3fd4d57fde904bd0, 0xc00aaf073819eeb4,
    0x3fe8dddcb3f389d4, 0xbfe46eef980cb63c,
    0xbff504d98bf45846, 0x4004db3635026a67,
    0x4005bcd15383c504, 0x3fe8ce6839939b01,
    0x3ff5fa9526cf1ade, 0x400d2f2ca3710ebe,
    0x40089b63b77d7d5d, 0x400c330ebfbf6ef4,
    0xbfe953b0c56429be, 0x4007edf16bc5917d,
    0xc00ac1d4e3224ff6, 0x3fd5c1b0434f2af8,
    0xc00a1bbd55e8e11a, 0x3fe8d7ab61cfabb8,
    0xbfe77408f7675fa5, 0xbfbff7f1a2bea2bc,
    0xc002b104d6f1f164, 0x3ff9ff9d188bf660,
    0xbffeb78cbc375408, 0x3ff0b58b608b7036,
    0xbfd5923f52c5e198, 0x3ff73e9632fff546,
    0x3ff04b650ea8ab78, 0x400766e08480813a,
    0x3fea5eee414344c8, 0x3ff75eec27c3e770,
    0xbfc2a4f596906730, 0xbff31963f8bac19c,
    0x3ff9e55709eaaf67, 0x3fee70b67e728904,
    0x3ff6104048660eae, 0xbfe8e527cd1bd8e6,
    0xbfef8f9581a1d648, 0xbffffe6a4bcaace6,
    0xbfff71c434a4be2a, 0x400c16b8f324e7f7,
    0x400f305418009b88, 0xbfd87c9cb097dd0e,
    0x3ff94c7f7d2fcafa, 0x3feb5aa3ab954a8e,
    0xbfddcff185939428, 0x3fd94f6cb49b1706,
    0x401899c4d8373c90, 0xbfe3961b8e1d16d0,
    0xbfe4dd5dbac740bf, 0xbfded89774943444,
    0xc000c2f0bb28b5e6, 0x3f9582c18b3ef500,
    0xc005f40fa0fe6cc0, 0xc0005bc36b7af086,
    0x40188c35030cf894, 0xbff08e414ac09e54,
    0x3ff4c58c1ae450db, 0x4011e1c6c1c37fc4,
    0x401572578e0119fe, 0x4015c9fff1fd896e,
    0xbfefae6422a04784, 0x3ffd664aa5f8c0b6,
    0xc009426c3b113726, 0xc0138acb2b4b5540,
    0xc006ea15cd7c3bf0, 0x40044c0543335b94,
    0xbfdf73379ab392b4, 0x3fe8f8199800aeec,
    0x3fe6c05b7158db1c, 0xbfce2e349e1bafe4,
    0xbff0c9a299b59c46, 0xc0062ae98e15fe55,
    0xbff5f21df474d2f9, 0xbff963c19ef3ac88,
    0xbff0c2f1d1353a74, 0xbff37ec0b9dad7a8,
    0xbff062493dbd4a1c, 0x3fe9e2e9fc97226f,
    0xbfff70ae7561e002, 0xc0062eaec04b032d,
    0x40101dc4b6539838, 0xbf9a2fb9237c9340,
    0xbffc0e54301ca178, 0x3fc466e06b9c3b68,
    0x3fbbfa36d03116b0, 0xbfd971fb45a128b6,
    0xc000ef6660a67f9d, 0xbfe41149d4a012d0,
    0x3ffda0c897f7478e, 0xbffd9272765c1f5d,
    0xc00037dcdf23d1e5, 0xbfe3bdbbb35fa0c6,
    0xbffd23213fc4cc30, 0xbfdac6d84ebd4be0,
    0xbfc5667b647c2ce2, 0xbfde70754b7166aa,
    0xbff5cdc86f729b6f, 0x3fe545280baf1d00,
    0x3ff0cfd59a686366, 0x3fd4de8f422cb7de,
    0x3ff27cde0285a5bc, 0x400529e7e475d0eb,
    0xbff895a6e054219a, 0xc0116709b02028a5,
    0x40157932dfc636f6, 0xc00aa513ec109134,
    0xbff4804023c5f4c2, 0x3fbb4ce8d70c42e0,
    0x3ff9dcb438a88efd, 0xc001de3316da9ca1,
    0x40024e4f6622802a, 0x3ff6ed1e5b3099df,
    0x3fbad3234960a970, 0x4005d38c728f842c,
    0x40079775d3648d05, 0x400004e3c2508b11,
    0x3fded032a11a679a, 0xbfe8fec59187f657,
    0x3ff63851515d8f24, 0x3ff5cd1f6df05f0a,
    0xbfe3650e54cb9142, 0x3fe46df2e31572a3,
    0x3fca9ed4136c1ab4, 0x3ff67d3896109d9a,
    0xbfd96cda29085383, 0x3ff8222607222106,
    0x3fd6ecf412352b34, 0xc0133a155e0d9f18,
    0x3fa9d62a60ed1980, 0xbfcce44bbbc5b720,
    0xbfffd545b31f8feb, 0x3fd40ed2831d61b8,
    0xbfdbbaea80808230, 0x3fe3e2ef964511c4,
    0x3fdf69ec1cd6c7b8, 0x400a60ea23f1d1f8,
    0x400a1e1ec3fb749c, 0x4007b1dd8c1bd81d,
    0xbfeb9ae8a62c1624, 0x40042ba497961032,
    0xbfd976d9461480f0, 0xc0026a03e8a80a2c,
    0x4011a9ade1ba5c4b, 0xbff1b285d592b9cd,
    0x400255bbf47e2f32, 0xc001a6f77cc758d6,
    0x4006bec9f33a2370, 0x3fec28deed885ee4,
    0x3fdf0ddfee22e098, 0xbfe83b289f154ccb,
    0xbfe594b2301cc9c8, 0xbfdb650982c18b24,
    0x3ff8c0e96f82f67f, 0x3fd2d650903cc3c2,
    0x3fffc002d0bc09ee, 0x400cc16858413a8d,
    0x40020cfd6dcbd6f5, 0x3f90924a2b1a8160,
    0xc0012b9556aaea6d, 0x3ff2149918b97c3d,
    0x3fe22a838f664312, 0x3fffd66fbdc8dd8c,
    0xc0154e5da924e7fa, 0xc0062404356205fe,
    0xc00185f15dd78275, 0xbfde662a088c6222,
    0x3fe12924d453770c, 0x400380b7318f5c32,
    0x40162700a3d12696, 0x3ff60a2e74c7c60c,
    0xc00cce20b85b87d4, 0x401192f2c375468e,
    0x4008c3ad134926e0, 0xbffde0fb93c7185c,
    0x3f8c0b4ba145c2c0, 0xbfdcfba461329041,
    0xc00be4b3a08cc42e, 0xbff3eb3fe6ebfb8e,
    0x4005db2b0765c944, 0xc00d40902d3a1404,
    0xbfe86acd04e9a69e, 0x3fe1f9bee158d9dc,
    0xc007992270240da7, 0x3ff6e56236b741ad,
    0x3ff89b7e2ac008d2, 0xc001f7fb682804ee,
    0xc00eed9c552f2e36, 0xc003b6ca5a6f4343,
    0xbfe275f9ae169345, 0x3fd02613fb1f1188,
    0xbffa4109155abb24, 0x3feae9672a1b6ccc,
    0xc0130519534d0a76, 0x400348e752523f98,
    0xc01065692fa519e4, 0x3fe3546b8550320a,
    0xbffc71b1af25fb6d, 0x3ffbc3a1097f88e3,
    0xbff27b02f694a4c4, 0xbf8987cc78544980,
    0x4000fe09ce23e598, 0x4013a471c102561a,
    0xbfdba169ad9df871, 0xc0037d1f3a77f8c5,
    0x3fd296ada2537edc, 0xbfee66b48c9f63b2,
    0x40101aa4ea471d99, 0x4006efe5fd1bf59b,
    0xbffa9854c1ce7e71, 0x3ff368d36b0b8444,
    0xc002d6cf848e7884, 0xbfee4425d1e9e144,
    0xbfe0770dd8497751, 0x3fd548cca01d5d34,
    0x3feb0571682f9a82, 0x400757da22f98513,
    0x3fe50bfd0b7522a6, 0xc003a445423dac5c,
    0xc00312663afd71b3, 0xbfda18dc0e230468,
    0xc0134528c8599ee8, 0xbfc973a9c65a7430,
    0xbfccfcdc86f57607, 0xbfd81661295040d4,
    0x3ffb14c7a1c88d6c, 0x40126367716c19cc,
    0x400338a644ccdf21, 0xc00073197e4a4a72,
    0xbfed4e5b2e75ca52, 0x3ff825e6f419d9fc,
    0x400ca2f715c9866e, 0x3fd4b9253f59aa11,
    0xbfab44afeeae8fc0, 0x40076243882388a0,
    0x3feb30e646434cc8, 0xc00c9534fc2460a6,
    0xbff7be3c8a5041d2, 0xc005836994008a4d,
    0xc001ce703d5a670a, 0x3fe0161db0103c2e,
    0xbff792fa8aae0eb0, 0x3fbdbbc9ab4d1440,
    0x40065940a4038e60, 0xbff7d3caeb6e5365,
    0x4008e077413cb05e, 0x3ff79e21ef268bc2,
    0xbff0bfd371da2538, 0x3fef2989ec71bd81,
    0x3fe864a8cc8c2e26, 0xbfd69f1cae4a9af8,
    0xc018f62fe44a1a82, 0xbff521008a40975c,
    0x3fe9c62780512bee, 0x4006165e3e4500e2,
    0x400770762a6cb84e, 0xbfb0c2026c097776,
    0xbfd396a87a3a9890, 0x401346188367fa1c,
    0xc00657bddb2963ec, 0x3feb4eb74e7da40a,
    0x40122773f7fe5ad4, 0x400f6492de81ac3a,
    0xbff0db70614f4478, 0x40178b494fcf6699,
    0xbfcf4c6f7386db04, 0xbfbf5a725c7e5508,
    0x400794f61d0329d7, 0x3ffbe68b41fdb5fa,
    0xbfe36080c9af7dd6, 0x3fe2c1e0a37a3928,
    0x3ff3b3d892c979fa, 0x3fd68f4d38104318,
    0x3ff95d4b0722549a, 0x400576af6feef6fe,
    0x4011de0eddb61e75, 0xbffdfd4c04ed8348,
    0x400c2e3c039b0420, 0x3ff752fcd9194d08,
    0xbffc2a338cd02e4b, 0xbfc765fb697d00cd,
    0xbfe992ed22174a0e, 0x40055f6af23d3380,
    0xbfe939dc0fb16d1e, 0x3fd5bdcfc1fdb4e8,
    0xc003be6188e9ba8e, 0xc016f5de9957310c,
    0x3fe600e335c96323, 0x3faf8fcb64d6a458,
    0x3ff8b7ccf106b370, 0x400468599360eccd,
    0xbff08f5077485c27, 0xbfb5108a0ac6f420,
    0xbff174d3efc47b75, 0x3ff5864c161898fe,
    0xc00aa1145ee1213c, 0xbffaec1589a3893f,
    0xbfe89b31aac912bd, 0x3fd3146a826ea034,
    0x400aef9c3a55acdc, 0xc00d5825b4d9c8d0,
    0x4007fdd456b9bd3e, 0x3fddc2be13c39a48,
    0x3ff3f20848e6b9a2, 0xc010fcb7f9fe3522,
    0xbfe0d488edc4a17e, 0x4003e8b75e181049,
    0xbff0224af2e35ce8, 0xc0075fc6e7f635c4,
    0x3ffdbf5d5a26e787, 0xbfe1cb7d9f02603d,
    0x40143716fb00a61c, 0xc00eb16ddc2ba212,
    0x3ff94d818e281f74, 0x3fd8dc941ffd92e6,
    0xc014730d9d13813b, 0xbfd60e9520ecb690,
    0xbffc89cd936f5541, 0x3fdbece0129c3d42,
    0x3fd0bc4459e7eacd, 0xc004c5d70a81b889,
    0xc01295a4525a1e38, 0xbff4bd3663c8939a,
    0xbffc6b3cf28a8902, 0x3ff1ae1fe8f5ff5a,
    0xc00bea7af0a643c9, 0x3fe4a7ac250b9564,
    0xbfcc0e0573c5e62c, 0x400cdde5834fd6e5,
    0x3ff393abbb497074, 0x3fe381cd7522eeee,
    0xbff64ecd32e70827, 0xbfef186eacd43f60,
    0xc00d66999b09ced2, 0x3fac30c5e845ca40,
    0xc007944659ed5196, 0xbfed18e522bff157,
    0x40110c75d78f8532, 0x3ffa80d9016c83ca,
    0xc005de68da691e87, 0xbfe892fbc538a5ea,
    0xc0067180e6bf4b15, 0x3fe642e2584cbb6a,
    0x40039f3d770621f4, 0x4008d744bb8b4fe9,
    0xbffb58a42c390c7c, 0xbfbda521f733c390,
    0xbfd688daf05f29d0, 0xbfae0b8135289b10,
    0xc009da5adae018a0, 0xbffe285c18cb707c,
    0xbff1796ac9fd28de, 0x400c66587924f43d,
    0xbff1765fecd58cb2, 0x3fecd950adec0aae,
    0x3fe166a003fdb078, 0xbffb2bb88378317f,
    0xbfc3533277b76994, 0xbfca9f0751c22180,
    0xbff39fe61549bc46, 0x400255ed141952ab,
    0x4005c3988a2d7b22, 0x3fe29963a1e13b24,
    0xbff990b8393fb212, 0x3ff2c64dc37e3bcb,
    0xbff05ce4e93e09b0, 0xc006106340cbfe31,
    0x3fdbc43c3a613d3d, 0xbff919ab8e2f75b2,
    0x3fe4e429b2304cb2, 0xbffd815fc946195e,
    0x40103be2f1ab432c, 0xbffeb1cba91ae1b2,
    0xbfffb691a1546dc8, 0xbfce70ae5eba5750,
    0x3fead5bae46e6d8a, 0xbfdda64d05ec16e2,
    0x40006d26aa5152de, 0xbff9f27b40e4562b,
    0x3ff8b3e0fbb3402b, 0xbfea64d96e84e0c6,
    0xbff202cc35ddd95a, 0x4010eab0301fe51e,
    0xbfe7f8192c1734d4, 0x400b1e8795c2b398,
    0xbfef021a3d238a0e, 0x3fda6c473b37681c,
    0x3fe8e12b767bf844, 0x4004b50b0ca7456d,
    0xc00328bf58800cbf, 0xbfc44b75508876c4,
    0x40000b4c451f81ad, 0xc00cfe56683a55fc,
    0x3ff9862231fa10f6, 0xc00512a45624747a,
    0x3fd1678da0819132, 0xc001158cc88c1c25,
    0x3fd61e47885c224e, 0x40001df08db90250,
    0x400a49089605c3ee, 0xbf894e998a0b28c0,
    0x400ce79058d8753a, 0xbfead7e828b89dae,
    0xbfe41f2bcfc974d6, 0x40061be40e90e897,
    0x3ff3e2668f188efe, 0xbfe17cdb36391972,
    0x3fcdcdd293722bd0, 0xbff9dec168428180,
    0x3fbdc88956d5cc20, 0x3fe9544683056c2e,
    0x3ffb651a24aee7bf, 0x3fe632d918bd75ac,
    0xc00a1779ca7a784c, 0x3fe97f8a480b8076,
    0xbfd376958783c050, 0x3fdf21ab654f1848,
    0xbfebabc24ec613cc, 0x3fdd692adff8b0d2,
    0xc009dbd35f4b6e0f, 0xc0018c766be035a6,
    0x3fee4b372034bc56, 0xbff845d2489f6cd4,
    0x3febc5d5815ee6b8, 0xbfd5e4376cd6e1b8,
    0x400acbfdf015c2c3, 0xbff59afe89a332e4,
    0x3fd2946d24f8e5e4, 0x3fb07c28ccaa38a0,
    0x3ff32637441e7196, 0xc00a131ceb77e34b,
    0x40054ac1dd6c465a, 0xbfe2fb4c25538c38,
    0xbff2747a7f961b8a, 0x3fd997af02d89380,
    0xbfdf8564837957b4, 0x40031c007467982f,
    0xbfd86edc5dbc35b8, 0xbffaa1b6504535b1,
    0x4004c5cda57c2f09, 0xbffb2c9059b92478,
    0xbfe6e5abf386038e, 0x4003f6d17c0cf104,
    0xbfeeb12048b9ea18, 0x4002bf191021dce7,
    0x3feaf8fc0be582e4, 0xbfe6e48bb7714c38,
    0x40016237af12db62, 0xc007fa7d7f3dd77a,
    0x400349717fe87d1e, 0x3fec210c550dfafc,
    0xbff12fb604398e28, 0xbfe2d4364ba70b09,
    0x3fface88e040c1e2, 0xbfc0ae716fc792f4,
    0xc0060b813742d34c, 0xc002a7204cb355cc,
    0xbfe260f0df227467, 0x4010d5cb56d18c14,
    0x3ffc882fef25af39, 0xc00123657217b7cd,
    0x3fc917d341baa458, 0xbfe795c803953934,
    0xbffa2026f3be168a, 0xc001574ce77f8662,
    0xbfe947990d0c3380, 0x3fde70558c87326e,
    0xbfefd9ecf25ccb98, 0xbfe2bf79f1770883,
    0x40040550cbdb6f8c, 0xbff07168cefb432c,
    0xbfded7ecdf1ee6f0, 0x3ff74532ae241b30,
    0x3fedca8b7e4b5bd8, 0xbfe6f2d1c9548778,
    0xbfd311766fe6d148, 0xc004eaab83edbbb9,
    0xbfee5ab8803eedb7, 0x3fc64be77bacba30,
    0x3fe8f24b8ad04eb3, 0x400cb646811d7ab2,
    0x40030e442dfb3167, 0xbff9c00ac02b0648,
    0xbffa2904f3674810, 0xbff1b2840999ed84,
    0xbfdb0cc3874c73c8, 0x3ff8c586a8cc48e3,
    0xbfe8b4091a09f54c, 0x4006ab1bed0e7e06,
    0xc01060e1c44b601a, 0x3fea3d6342dba2dc,
    0x400e2c66fe4d9e8f, 0xbfbcc0819ec16de0,
    0xbff5bc778b6bad16, 0xbfb0343d3dd92270,
    0xbfeaba8c4ec94720, 0xbfe30090ea9c47b1,
    0xbfb5ac5c833a2328, 0xbfe37c4a151fd600,
    0xc00c8333f4cddd6c, 0xbfd40db30a9ca250,
    0x401181e64d32aa74, 0xbff93c7312e56527,
    0xc00bb4213cb2aa63, 0x40057cb660f74d28,
    0x3fef5183538f2ad1, 0xbfdfc661ffa5c870,
    0x3fdaaa1bd8f2d9ca, 0xbfe317cd609d223d,
    0xbff78771440f70b3, 0xbff6886d673b8764,
    0xc015fd0d531533c4, 0x3fd1f8d40f759444,
    0x3ff2adbd350c02f8, 0xbfe125900a8a2eb4,
    0xbff7cd4bec9ea8e9, 0xc00ec1b5fa92f6e1,
    0x3ffe642934201848, 0x3ffefff650909758,
    0xbff968f9fe49a277, 0x3fea7bc4cd6b7ee6,
    0x3fe0b75863c7fd09, 0x3fcbe82d32f7b150,
    0xbfe0c6ed6d26f956, 0xbfe68e39a51a3514,
    0xbfeaf1d751433864, 0xc00293c579c9948e,
    0xbfd250321f95509d, 0x3fe7cf0849df8d16,
    0xbfdf9af9025b93c8, 0x3fc6acdade5eb510,
    0xc0064f230b7fadc6, 0xc0115d46a01d1d1b,
    0x3fece99c0ed66ab7, 0x3ff4727fcb6c723a,
    0xbfef68a5180f81d2, 0x3ff9aef1b9ae3e1a,
    0x3fbf1cffd32f84c0, 0xc0013ecdedf0ec87,
    0xc000c53ea3c4aeef, 0xc012d389bb96b638,
    0xbfdc51a6386c0482, 0xc0081803d2ebea84,
    0x3ffb0c6697250484, 0xc00caee9e887aee0,
    0xbff6d097a0f4c002, 0x3fd47c73824e60ac,
    0xbfbf71214a21f718, 0x400a2c74fde1060d,
    0x400b67e102d91e58, 0x3fce826bd81e21b2,
    0x3fe4d856c517efb0, 0x3ffbb0ec27080200,
    0xbfe6acec994b290e, 0x3fff9542df3fe9ee,
    0xbff3dc52cc2da683, 0xbff2152d9a408b5a,
    0xc0008bc948fa8c8d, 0x3fef26440743db68,
    0xbffb063c44abd6be, 0x3fc5fab2deac17d6,
    0x3fdc05eb2021890e, 0xbfd3d7226c11e18f,
    0x40019165361a30eb, 0x3fd350970049d3f4,
    0x3ffc27e1198bfa98, 0x3fc1bf1cfe0e38c0,
    0x3fdae4d4cdacadb4, 0xbfd00e095302d41c,
    0x401262adeddb3ae7, 0x3fe461cf1963e898,
    0x40008252fb4f5a52, 0x3fd2860f76260e2a,
    0x40054bbe1f605bec, 0x3ff3639cf751b77e,
    0x400da94f413a3c7b, 0xbfe28816857a3ce3,
    0x3fc6361a2dee0b48, 0x3fe21f5d2df7eca3,
    0x40009def10099b83, 0xc00bfda7f5987d25,
    0xbfd81d75e29c1fc2, 0xc0048870a02984d1,
    0xc00e5b7837952049, 0x3ff6e7c68fa45998,
    0x3fb358aa20ff0b60, 0xbff318c58f762fe4,
    0xc00682dca352b64f, 0x3fda0ff711338613,
    0x3fe69cf70beab826, 0x3fdf44d450ed7ea4,
    0x3ff9061704b3d742, 0x3ff850e808cfa606,
    0x4011082d85876b2b, 0x401314e85ab30c7a,
    0x4011da18d0b5fcf0, 0x4007eb8b749fce46,
    0xbfd7cc6b9fad5f14, 0xbfff6fc4fde3ad84,
    0x3ff2074cc0b75e93, 0x3ffab004caea7312,
    0xbfb51b9f834a7ac8, 0x400d1a2fd738e085,
    0xc0030de93906339b, 0x40031abcd7d3da08,
    0xbfffee5eac70ead4, 0xbff2f5a453028c0e,
    0x3fce86719a7a4658, 0x3fe09722f3785705,
    0xc009fe74b5d8abef, 0x3feb666c145fbb08,
    0x3ff6a900026ae30c, 0x400917a5cc05f368,
    0xc0103202846078be, 0xbfe39dfd815e6504,
    0xbff39676ef578218, 0x3fe1461fd4149bf4,
    0xbfee583db6cd3178, 0x400a6d9e66c9b040,
    0xbfe2e911adfc926d, 0xbff40fded65956a8,
    0x3feee6f7c705fc64, 0xbfefc6bcfeeebd76,
    0xbfd2146b8a02da1c, 0x40033ebdca0a448e,
    0xbff8a4a21496d606, 0x40016cc0b28bc96f,
    0xc011171537a86e14, 0x3ff68df6849fabeb,
    0xbff243afd818a1fa, 0x4003e9d5ed831f95,
    0xc00ca691007d618b, 0x3fa1683e9a14c900,
    0xc007507c9712ceee, 0x3fca874d590ed404,
    0x4002f7b904de5d58, 0x3fff9acad6fe632c,
    0xbff8c0f0e5489f07, 0x4016c872b1a26b32,
    0xbfe3ad6caa276041, 0x3ff394a8cb2107ff,
    0x4008fe106c07abce, 0x3fc276827c20e524,
    0x3fe4e12d6878a0b9, 0xc00741914c778a08,
    0xbfff26459e1d4f08, 0xbffdf44c8ce9e53d,
    0xbfe5538c81384f58, 0xbff39655a3793227,
    0x3fcd80e7300dcb18, 0xc00b533e8c6b4d9c,
    0xc01a0936793f9e65, 0xbffefc0f68265be3,
    0xc001d3e98ddb1ae2, 0xbffab95ecc57c96c,
    0x3ff7d1bf43c7fa02, 0x3ff59b5ef83d85ae,
    0xc00417c262f7257a, 0x3fed14cf371a9e9e,
    0xbff0cfc3c33ccbd0, 0xc010a5ef8cb3a4b4,
    0xbff550a08a81315c, 0xbffb3e53f4042eca,
    0xbfe58276e5705ff4, 0xc009a09365448dd0,
    0x3feb21cce8969b78, 0x3fefb8c61af73864,
    0x3ff70e65bdee4ae4, 0xc00efd2abd09802a,
    0xc004d33a5f481302, 0x400adcff342bad20,
    0x40123d762575a99c, 0xc011f9b261e959cd,
    0x3fd502b0a43b07d9, 0x3ff0e057ac044267,
    0x3ff58395d27c7128, 0x4006b549d72c2bde,
    0xc0010187ad3aa7b4, 0x3ffb0fa414ced044,
    0x4003dcd5ab6f9654, 0x400ed4b835b2fc88,
    0x3fd2ea75f1d84a82, 0xc00374168909c469,
    0xc0021ee5b85064dd, 0xbfd534c69c347968,
    0x3ff0c46e3662e9ea, 0x40043de481250171,
    0xbff29256518b0c79, 0x400913d108b88c74,
    0x400b9885edb9b041, 0x3fea3822a7ad822c,
    0xbfb32e34b53ac628, 0xc0005408aeccfced,
    0xbfc11baac1d41ab0, 0xc006657989076337,
    0xc00fe9b18e151e58, 0xbfe9346a810f550f,
    0xbfc261cc1d161e48, 0x3fe0950408e26112,
    0xbfd5963115cb353c, 0x3ff4447691f4e7e1,
    0x400eafd90f0b272e, 0x3ff25d1cece9fc71,
    0x3ffdf89b172f0151, 0xc001d9f8e2c89963,
    0x400cb410b7e66b08, 0xbfcb6a4804e40488,
    0x3fe3eaf291351830, 0x3fd496262010cf94,
    0xbff3500f3de10ce8, 0x4004802d92079a52,
    0xbffa56d2e59e3900, 0xbff7367f4ceda440,
    0x400d7f211cbc4cb6, 0xbfbc9d27613cd74a,
    0x3fef5e20e84b3022, 0x400e0538d8e43cc5,
    0x3ff61c9cc1d11776, 0x3fe7d064a927c912,
    0x3fbde463809fe61c, 0x3fe25d7793705435,
    0x400600f05218914a, 0xbfe19a1fdbce5886,
    0xbffd2d118a30417a, 0xc0086508303ca46f,
    0x400751d958e301f9, 0x3ff5a2f4fa2c1466,
    0x400670f3dfeb08e5, 0x3ff933e9503107ec,
    0xbfb143c4144330e8, 0x401118087a49d4ac,
    0x3fd98981cf7fdc08, 0x3f8702c4599aa040,
    0x3fdcb9e820ca0338, 0xbfdbe3b3af209750,
    0xbffa8675339ff7fb, 0x4005e07d2b8b236e,
    0xc00bdc62dc84179a, 0x3ffde044f7162cb7,
    0xc00523d737e4620e, 0xc0110833eb79bacf,
    0x4001d4aab36d53ae, 0x401169dcb5c0310f,
    0xc00531fe3fa43e82, 0xbff6a389a7a02b93,
    0xc008a8cf5bfaba2c, 0xc003482f50677e96,
    0xbfe374a183d59a42, 0xc006d15585d128eb,
    0x400c6c435724042b, 0xc00387d49255f5a2,
    0xc00308c58a55a3e0, 0xc01563001894db7a,
    0x3fe6102868dfd1c6, 0x3ff34b899f2d4515,
    0xbfe659278e2e0b20, 0xc00a92dbdc237a54,
    0xbfe6469edbfb3084, 0xbfe8a74bb3f00e72,
    0xbfc129a2648004a8, 0x3fd88d06956f5e26,
    0xbfb00b10cbd0dcd8, 0xbff1854f8e97ccc2,
    0xbfd9ec37d8cae060, 0xc0043f3f3c192f2c,
    0x3fe83437fc29cad3, 0x3fd77cadd6cfea9c,
    0x3ff1339964cb6ef5, 0xbfd48b6fb13142f2,
    0x4013144613bd130e, 0xc0044f73e1277a59,
    0xc00fa8f0fd6914e6, 0xc00c7350f1534ac8,
    0xc00afc0981fffea6, 0x40117989615baa2d,
    0xbfe5e137acdda46d, 0x400579966197700a,
    0xc014a6ba6697e288, 0x3ff44f6b6085a8b8,
    0x3fec2d982e3c29bb, 0x4008491e36ee9768,
    0xbfdc5fd54fe2a788, 0x4002e2b0780b43af,
    0xc002259ab3dbb5ee, 0x4000a4bfa7f13ad4,
    0xbff11e83df264c24, 0xbff745bf6a320c08,
    0x400c1d522008c881, 0x3ff7dd5bafbde315,
    0x4003625494b85890, 0x40098c5d4b28d247,
    0xbffa62afa933c8b8, 0x3fd79878cb9d74e5,
    0x3ff953286eb7e696, 0x3fff8006318aec5a,
    0x3fe3b5de5a0ff2a0, 0xc001e0055895db72,
    0x400721c51ff21a70, 0xbfc8727d32c35580,
    0xbfeba19c4473ee14, 0x3fd7cbbbed6da5a3,
    0x40010178fa15139d, 0x3fbbbcc1015fc7d8,
    0x3ffb6ab37b50e85b, 0x3ff1923049bf88c7,
    0x3ffd818adfd022a6, 0x3ff22aa60f187a65,
    0xbff0306133dfca66, 0xc000acd69eba488a,
    0x3fec586e5cbb6ab2, 0xc004511646b64659,
    0x3fe3b74783275cf0, 0xc001e2a80564f1b3,
    0xc016767828a4d965, 0x3ff54946d6b6656f,
    0xbfde7b80685a2c9c, 0x3fe92b28f114b452,
    0xbfe3f0022ab88310, 0x3ff684cbb3ebcf90,
    0x4007bd834cf39711, 0xbfff96f6dd8845cc,
    0xbffceca60d6ea937, 0x400434859193ab16,
    0xc013f41ba46f961f, 0x3fe0a4b82a2d6495,
    0x3ff9b74bd7960937, 0x4016dbec4b44d78c,
    0xc00581b901a72ab1, 0xc00d8827274a9364,
    0xbff61c197c16abe4, 0xbff392fac025b148,
    0x4000c9c4e657e0be, 0x3ffb3f4d354af6c8,
    0xc00798a1966f5b11, 0x3fa4fe67ba068f00,
    0xc007896d6689aa88, 0x4001b423f5470b4a,
    0x400839a5bb0311f8, 0xbfeffd6cc5c136a2,
    0x3fff93a039b67caa, 0x3fd8c09e3db19240,
    0xbfc03d281c2c519a, 0xbfe546e10442cc72,
    0x3ffe9cd65d92831e, 0x3ff8b83668fcb8c1,
    0x3ff92338b2b0a550, 0x3ffc514ad5190be3,
    0xbff8fd12893b27b4, 0x3ffc0a082f9a0ab0,
    0xbfb83f5c5fcc2e30, 0x3fd9aafe684b1596,
    0xbff1ce844c4b619b, 0x400496f66757416d,
    0xbfc872cdc116b7b8, 0xbff056e0157bb1ae,
    0xc0056ff1ad19a804, 0xbff20fd02882c5bc,
    0x4000734ff8bf32d6, 0x3ff8cab4e9549c86,
    0xbfee814da823d3f3, 0xbfb35e702cacd240,
    0x3fdd57f381d9192f, 0xc007dfa494915319,
    0x4006505d21e35912, 0xbfffe109d0f28c5c,
    0xc0048ec26e46a947, 0x40002b5d2cbcdd7e,
    0xbfebe85f0e99ae0e, 0x3ffee452886a034b,
    0x3fc4a8ccddeb1110, 0x3fe6c04f6d58461c,
    0x3fd6700790e18596, 0xc01c0da74ec2623c,
    0xbf8934373c573940, 0x40052dc67836d274,
    0x3fe7375ea6d67734, 0xbff2e6daf4eee34d,
    0x3fcd299a4269d420, 0xc005b43bde8d3bec,
    0x3feec745e63a1788, 0x3ff4ddd8c6eece69,
    0xbfe8d739a40b4c26, 0xbfd86e4d662bd714,
    0x3ff23da231c340c8, 0x3ff7a66eec78b5b0,
    0xc00eb3cc266b2bbe, 0x3fb142e288b133e0,
    0xbff23078eabe1a7b, 0x3fb1c0e8ef291a08,
    0xc012333cf3bb4a43, 0x3ffbf4ed8ccf5efa,
    0x4009b25c8991d868, 0xbff2272a001c7d48,
    0x3fffb84b9b28c0ff, 0x3ff7aabc5fc3a20a,
    0xc01196d22b203ac6, 0x3feba21ef1d5bd2e,
    0x3ff16182948936da, 0x3fe3ab1ae4f48045,
    0xbfeed460b2bf3e40, 0x4000d65ef745d4ad,
    0x3ffc8b2660962288, 0x3fed0d418958cb56,
    0xc00a7b3896c8cb19, 0x400c6a60c793320a,
    0xc00d9fa2757635ab, 0x400ad707f603dff8,
    0x3fc101dd8c78e800, 0x4000c78df5a74c18,
    0x4002ade2dfd0cdf8, 0x4010e4da161c874a,
    0x3ff0f89a4dd7966f, 0xc0033cfcd114c26f,
    0x3ff2ec86aaf8384c, 0x3ff2b4774898010f,
    0xbfd45f7e0e0018f4, 0xbfe73772f0db993a,
    0x3fe96ee06a17c95e, 0x400e5e7438de8d40,
    0xbfc9f5b60a9cad58, 0x3feda541640b453f,
    0x3f9b4fdbc95239c0, 0xbfe6c1ee285c9ed1,
    0x40105604da3ee595, 0x4008d5311cd9ed11,
    0x3fe59fd5a7760a64, 0xc006a1237807911a,
    0xbffc84d90adef518, 0xbfd3b81c8c6a1481,
    0xbfad04bafbf35640, 0xc00118c34a14a0f8,
    0x4006e9aa969003ff, 0x40007049c39f002d,
    0x401e090415e0bade, 0x3ff4607eb24e4e83,
    0xc011552a0c20b42a, 0xbfa6f5f8f86a72f8,
    0x3ffddbf4872e5535, 0x4008c2e192304098,
    0xbfeb16a191778040, 0x3fc3b15aafac9328,
    0x40026372d81227fa, 0x400294c21316eeec,
    0x400661fde12c1ab6, 0x3fc4f144f07d83fa,
    0xc01093023c99a034, 0xc0101c99650278a4,
    0xc011860f09815a8a, 0x3ffb150f3cbd6314,
    0x400d0c59b58f9057, 0x3fd3803002b3b192,
    0x3ff8365c46ca206c, 0xbff30b3d6488968e,
    0x4000566e23ea4d22, 0xc000aa6a35ec0cc4,
    0x4002a86611911d31, 0xbfd0003e6cf1ea50,
    0x400c58ee212f004e, 0xbffb556e81250036,
    0x3fede08bf4bbc20e, 0xbff8101f3a229994,
    0x3ffd467a09d9d9eb, 0x3fef6b73121f9524,
    0x400d0b8356c5081d, 0xbff11c53896d9a78,
    0x4013fb2dcf5f0f60, 0xbffcdbe1dd1c6744,
    0x4006eb8d9ccdf3ee, 0x3fd3a4f3f97ec89c,
    0xc00bff21476d3975, 0x3fe9e3e818066a89,
    0x3fee6fe6b8497b1f, 0xbfbf066802d1d6d0,
    0xc009287856df0295, 0xbfa0f262371c8240,
    0xbfcd31fa30e2ccb2, 0xbff685a7550e58f9,
    0x3fe6b09afbc82b2a, 0xbfc53613bd8c0818,
    0x400b55be658f63e9, 0x3ff7e64bbe550090,
    0x3ff5777d11bb6568, 0xbfc1d79f293f170e,
    0x3ff3273958941feb, 0x3ff348c133067f34,
    0xbffd8d2b5bbe08cb, 0xc0067df0e9a8f2fe,
    0x3ffb9e7d30602d81, 0x400237d4b9bd6f83,
    0xc00211817c95deeb, 0x40018295b5b8257e,
    0xc001136394b40632, 0xbfd0cfec3751847c,
    0xc008e317a4e14d3a, 0x3fe698cce2d5b4c4,
    0x3fde5ec025e3ee98, 0x3fde23a6a8db0254,
    0x3fe47ab4e2a51105, 0x40052efc21fd236e,
    0xbff0ce1970108410, 0xbfbbe6f7acc5cc70,
    0xc00e662b360eab3a, 0xbff1e5968b670492,
    0xc0065bd580db9872, 0xbff94de48d0b6054,
    0x400d59ad427039e6, 0xbfe5829266c04a0a,
    0x4001527d74371a86, 0xc0042d53ac71f64a,
    0x3fe140d4ae9ae4fc, 0x3ffa16151655b1ae,
    0xbfe27ef639e44f91, 0xc000b7964f966479,
    0x400a61421f2085ed, 0x4002dcf540616732,
    0xbfb2db941e55fc20, 0xbff9370c77daef5a,
    0x3ff04f509ecdec6d, 0x3ff6a4ac85b975be,
    0xbfe3a85bc63a4270, 0x3fa22ba2d5b86158,
    0x3ff15007b8a25682, 0xbfdf0929db334f7c,
    0xc001eca93ce0cdde, 0x3ff4eefd98e08fdd,
    0xc00066201c9316f2, 0xbffe0c9b367d0c5a,
    0x40041966ec4e85b0, 0x3fcef9b7d74c55d6,
    0x3fc120bc789fc988, 0xc0163a4cdd756a5a,
    0xbfd07c4858d1c404, 0x401703d8439beb20,
    0x40012b27d14e0612, 0x3fe195f1565dfd0e,
    0x3ff957c922e64ec6, 0x400b0eccf5550e77,
    0x40099685e7884f74, 0x3ff0511b0e37376f,
    0x3fbba373cfcde750, 0xbfc161679ec23d10,
    0x3fd3504e781737b0, 0x3fa57da595021520,
    0xbfcbdb9165cdf04c, 0x400b76e6e8bd9b36,
    0x40011d33fc953e50, 0x4006b728ba50f61e,
    0x3ffd640bc91e9a41, 0x3fe01a220f847b76,
    0xbfd31c31a8c9eeac, 0x3ff1f05c54642df5,
    0xbff05b7ba06b1ecf, 0xc0069fbe9ae6a0d8,
    0x3fb05d6c75fd8350, 0x4001470bf93731a0,
    0x3ff9a0351016ded7, 0x3ff2cdc0a89cb238,
    0xbfc5b98f3a5d6cf4, 0xbfebe81244418534,
    0xbfefc767d97f2714, 0x400667604c24a2a6,
    0xc011108b07de9cde, 0x3ffe162a8baa2a3a,
    0xbffbb6b9da4dd9f9, 0xbffb4161baddf6e6,
    0xc0066332b37b4777, 0xbff8ccf238ed16e4,
    0xbff0174c258b459c, 0xc00d0455e32238a1,
    0xbfd9a8207f956272, 0xbff536d74285d520,
    0xc003c6cc86421bda, 0xc0068a743c2a96b4,
    0x3ffd0c855979fa46, 0xbfe0914cb8bc1e12,
    0xbff8183808fc2b40, 0xc0020f2a21b1938c,
    0xc00e296a0ad8b306, 0x3fb214f923961318,
    0x40034912b1f8750d, 0x3fa3b40bb4902b80,
    0x4004377fb010481c, 0xbfeffb9154ceae44,
    0x3fe165eca9e2007c, 0xbfe551a2112d6a99,
    0xbff653b7f4258936, 0xc0065c4ce5b23e01,
    0x4002d910697fbe01, 0xbfc6cd2aad6c95b0,
    0xbfc794a0b5ae1786, 0xc00b434fcd16b574,
    0x3fe9de47a2f01456, 0x3fad5d90cae9f3f0,
    0x3ff4d842437b4e40, 0xbffd47d75b700d4e,
    0x4010222e8844f60c, 0xc00b7b46625663d2,
    0x3ffe4f52dbd4b08f, 0xc000c52a12727cfa,
    0xc0098b3911ad6cbc, 0xbff6c15b74babd55,
    0xbfef23b4715bbbe6, 0xbff2c5dff87490ce,
    0x4008cfa5a206890b, 0xc002124495d32c07,
    0x4003a0fb7b61eb21, 0xbff5381d1b24c6bc,
    0xc005cd8a695904d2, 0x3fe0fadd24adfb5a,
    0xbfd6764d47f47d88, 0x3fea2fbfb7cd220a,
    0xbffee82e67e7264d, 0x401306d11bd11afc,
    0xbfdb093056fecd6e, 0xbfee09235472962a,
    0x4015a2c336c3883a, 0x3fe77b2324f52348,
    0x4005d10cc446f805, 0x4011c209e7afa21e,
    0x400432ae89401f8e, 0xc00f253e180f6a67,
    0xc001429bc609ceb4, 0xbfa46576d5e9c000,
    0xc00a8623248b29a2, 0xc010a3ce6ef58c15,
    0xbff56e0a207c8fdb, 0x4013f70cdc7ae14c,
    0x4013ab054c100e28, 0x3ff610da0d951164,
    0xc00c11d78d6ddc52, 0x3fe48f44e7d5e614,
    0xc012002eab11af74, 0xc000d6cc0065b6db,
    0xc00b6d832ab65162, 0xbfe50ab1c4494161,
    0x3ff4bacdcf602e96, 0xbff013ac191b3a8f,
    0x3fd7949aa81cf290, 0x400eb0b630a25b4b,
    0xbfe41095e2c8a475, 0x3fdc5c8bda9bc0fa,
    0x3fcb2ab26d2f3cd0, 0xbffa9f56ee83e32e,
    0x400df03f153d89f6, 0x3ff86c4976717346,
    0x3fd526ba8f4177a0, 0xc0006748be8679e6,
    0xbfbe7afe5c37fdb0, 0xbff27a354b00f070,
    0xc0096bada1b8664b, 0x3ff3274feacf3db8,
    0x3f9795243a087b00, 0xbfd10f167c31cdc5,
    0xc000fd7c18b92640, 0xc00874e7b3e9daca,
    0x400a4f88a59c715c, 0xbffac219274bb8a0,
    0x3ff9118f5bf418f4, 0x400c8a5702e09383,
    0xbfecd3eddf162478, 0xbffc707c7f5afed8,
    0x3ff9db21c3751b15, 0x3fd161d137503b00,
    0xbff7109b27e43f63, 0x4010cacc29e6d7ad,
    0xc007c33255de129a, 0x3fb0a9efba7a68f0,
    0xbfed499d2f3f100a, 0xbfd55af2eac0db34,
    0x3ff16c96ddbcbeff, 0x3fab9985ab1d8240,
    0x3fc1d5e6778034d8, 0x3ff588e4a0acaa19,
    0x3ff1aea34b0e1d26, 0xbfeeb895bf141df2,
    0x3fe280458a26b9b9, 0xc0039e2205bd7e8a,
    0x3ff4663021c653bb, 0xbff19a911396f6ea,
    0xbff4c8a34e4c9334, 0xbfe5b3d26b3c2203,
    0xc0029db027a5b892, 0x3fd64dcbd159da90,
    0x400b2d0afc4f5376, 0xbfe9c83283c6b9fb,
    0xbffb61974c560aca, 0xc0080ea82e7e39c6,
    0xc00432f721f1d28c, 0xbfe04c6d061c6a6c,
    0xbfe2cc352dce3812, 0x401213ca3c5cd8ae,
    0xc004239ce7900386, 0xc00d0e474dd63b5b,
    0xbfd2d2b350ddf820, 0x400b55e9b4501b7e,
    0x4009f4f4e662750c, 0xc00cee79aefc20b7,
    0xc0027737e8ba9b85, 0xbff36287d1a5cfba,
    0x3fffdeb28ce5c9fe, 0x3ffbfd38f5564a78,
    0xbfeaa7014cfa97d6, 0xc000d605aca8bfe9,
    0x3fff81515363ec60, 0x3ffdcc83dda6b04a,
    0x3ff7da166dd4564f, 0x4004d6d458b02ebc,
    0xc004487fff564b28, 0x3ff84e8c76f642b8,
    0xc003dac5e6c1b285, 0xbfd84b8b350dfdc4,
    0xc00a67f868fb14a1, 0x40122d9d17904a8d,
    0xbffa7e38d009d4b0, 0xbfd64e2941c3e2f6,
    0x3ff50d5031bd6f24, 0x3fca849505bb2de0,
    0x3fdefbb9e49a0637, 0xbff6e34bbb8bbf19,
    0x40042b9fa99e3d6c, 0x3fe78194e271a110,
    0x3ff5369b5b936a6c, 0x400f9d997134a372,
    0xc00427a8aef1874b, 0xbfd7d8edbd9f2c04,
    0x40048066c1cb929d, 0xc0017821b6b69387,
    0x40118a8078d1726f, 0x3ffd6d73065185cc,
    0xbff2e7aeed1741a6, 0xc0044d646c71937c,
    0x3ffb6c98430879a8, 0xbfaedebb35073bc8,
    0xbfff3d9487b568ef, 0x40015734908ca0ef,
    0xbffb0eda8d3f1514, 0x3fea26617f503ca6,
    0x401038c1ea420896, 0xbfc8e74c9927606c,
    0x3fcec2d785bf4d78, 0x400fd5ad1d967aba,
    0x4002d7fb5bdbedc3, 0x4000420c869a6742,
    0xbfee3802eeb4bcec, 0xbfdb7304b08984fc,
    0x400b0de45916fc2c, 0x3fd987cfd618be10,
    0x3fb926dc3c2e3c40, 0xc010fc7308a397fd,
    0x3ffdd6a78bc61bb4, 0xbff8f5b1718f102c,
    0x3fe9b2532b4992a6, 0x400148e439112120,
    0x3ffa1b3e54818cf8, 0x3ff582983b52c5af,
    0x3ff5bdcaeb6a47ce, 0x4010b442c7624d7e,
    0x3fe1eaf713d1365e, 0xbff5694cb38b30d6,
    0x40010a78cfa19a3b, 0x40044a3acc357d52,
    0xbfd37e8bdeb038d8, 0x400860962e7e0af4,
    0x4016b36fa27b1b4b, 0x3fea5553c8dd47c3,
    0xc00aace67c395bd8, 0xc00b56ee80c9ad60,
    0xbfd489be1e1be111, 0xc0092c4f25b37e08,
    0x3fe2f65595c35d9c, 0x4002612ad4320c6c,
    0x40047da7365e8987, 0xbfeabb388ada6fac,
    0x3f84bf9ef61316c0, 0xc009383586563803,
    0xbffafeab0df3b587, 0xbfea31ccfb2e475e,
    0xc01d48e9ad3e7156, 0xbff54643dfa2333a,
    0x40084b7e2dd80a86, 0xc0049a7342a2e368,
    0x400f9091771e25db, 0xbfe835192a50041e,
    0x3fd5f05db0dd2caa, 0x3fdec772f7baa978,
    0xbffe0e32d0bc55fb, 0x3ff3692135c7d7cb,
    0xbfd88e8a802d33c2, 0xc012a538b66355a7,
    0x4007038687085b95, 0xbff8ddc6bf88d1cb,
    0xbff38f7edfa481a7, 0x3fea8f7c2830959d,
    0x4000e9200027e4a3, 0x3fdb0d0ebb27da34,
    0xbff35ad8d7fe6523, 0xbfd26d99c223f894,
    0x3ff15e588bce7ebf, 0x40022fa9724ab04d,
    0x4010cba72bd1c384, 0x40010ad2b60568e4,
    0xc0018a5f5e2594be, 0x3fff0869a5b0070a,
    0x400419b74c502462, 0xc00a023ca3f1489f,
    0x3ff34298e275f27e, 0xc002f74bf13a0f6c,
    0x3ff06a9047f172b1, 0xbfed8c94117fa6d9,
    0x400977951435fcfe, 0x4013d8d7b2903132,
    0x3fe4773bf90f0540, 0xbfb7ad3456de1c40,
    0x3ff1e038010ae379, 0x3ffaf4b153277a1f,
    0xbff1fd2e4105a7e3, 0x3ff3fe198ef1ef5a,
    0xc00ae5a4bda7791f, 0x3fea67ec9224227c,
    0xbffaedb2135d4a7d, 0x3fd08c65880671a8,
    0xbfe77712a4d0934e, 0x40050b5ec8c9133e,
    0x3ff7af922becbce5, 0xbff1bb27a482979e,
    0x3fe117dc992149fb, 0xbffcdedef8db59e8,
    0x3ff57d188ef0fe24, 0xc00c7561d720b75c,
    0xbff19dc04f92d760, 0xbfe4489855da2e7a,
    0x3fd96e6d28ed72e0, 0xbff107809d10511f,
    0xc00ab1b71a6a8df0, 0xc0099ac8c8a414a6,
    0x3ff8e9bf65022d14, 0xc00306781ffb54dd,
    0x3ff4b81236836e8e, 0xc00ae3360346a728,
    0x3ffb110f4130284a, 0xbfcb6541c263fb3b,
    0xbfdf9ec6f1104890, 0x3fd6341a46aa05ec,
    0x4011c9cc9aae136e, 0x400313b464ed59c9,
    0xc00aad25b92d8dba, 0xc007fcff04d423df,
    0x40003519f03b0292, 0xbfec3d817aa69c58,
    0xbfcb254efb962bd8, 0x400ff1b3592a8f86,
    0xbff65afa9e047859, 0xbfe0b0f9d1090247,
    0x400b67ad34f5bb0e, 0x3ff48adf1993c4d8,
    0x3fe0680150182ac9, 0xbfe47859de59bd96,
    0x4009c306096a13ca, 0xbff6f2ebb72c8ae7,
    0x400af04bcbdf21ec, 0xc000b433a60db521,
    0xc00f6f1feedbdf63, 0x3ff861bd55aecfdb,
    0xbff535af1b2536b5, 0xc01381e1460982e6,
    0xbff512eb23f2ae32, 0x4004978e2fce84f4,
    0xbfc3394320d96b56, 0x4003353f72c4aefa,
    0x3fd7122c039c49d1, 0x3fd8fb71aa725880,
    0x4000a18b56ad43e3, 0xc0054d972a5a9496,
    0x400187ce39bf0c8f, 0x3ffcea352844f778,
    0x4013e4745b788a1a, 0xbff8c2b57468c7a9,
    0xbfd9039db4449e94, 0xc011131acd7dc2ce,
    0x3fe7ca1aa194a0d0, 0xbff29f65be398c67,
    0x3fb631ac13a03f78, 0xbff2ac934f6cc168,
    0xbffec020cd95d6e8, 0xbfc43899c8bc10ec,
    0x400398da5cd7febe, 0xbffe4375b4dd897c,
    0x3ffcf82c10fb3c37, 0x3fefca3b554a0501,
    0x3fdf7954c0f4fbdc, 0x400a5bf096141e50,
    0xbfe3ca0f6b1a6e80, 0x3fecdda9889309b4,
    0x4000ee9689694bc1, 0xbfeb818be1bc587c,
    0x400ce2c92a6bf2c4, 0xbfb2016c9332b6e0,
    0x3fe0fe2b097ad6ae, 0xbfc3a641222a55a8,
    0x3fc2bcfedae25f7c, 0x400f808ace6289cb,
    0x3f99fd3f98bffdb0, 0xbffc2df9c2a7bf84,
    0xbfd364c900278f1e, 0x3fee5f9374c42a1b,
    0xc012fbb20ab174f5, 0x4005ee87bb1138da,
    0x3ff4dac6889e5d60, 0xc00692b2f81afadf,
    0x4005a8a489318c4e, 0xbfc72184a33550d0,
    0x4002490fb4721c76, 0x3fd41695e5b421c6,
    0x40011f18e5cca4ea, 0x3fa4b1a1b0eba620,
    0x3ff756e60d4c754e, 0xbfe1cc2db8734045,
    0x400543939ad4a792, 0xc002597f9d4076f4,
    0x3fa2972675ca0c40, 0xbff00cd7211f8f08,
    0x4009b7ec844d4934, 0x40142d0ec5095cac,
    0xbfcd3ac899124e04, 0x400b527b9dfa821e,
    0x3ff4d630f30203f3, 0x3faad5331093de00,
    0xc00fddd42ce18c42, 0x40038512e681a3b9,
    0x4007fecc7e4c9e66, 0x3fa494cc37a02990,
    0xbfd8a9279980ba64, 0xbfe2d8ddd8793f6b,
    0x40011f73f0e3d0ba, 0xbffefbe6e86a067d,
    0x3f7f5d79f8b1e800, 0xc006dd0f5d1da222,
    0xc0036b416398afe2, 0xc005ebe1cf6ca736,
    0xbff61155a88cc23e, 0xbfef33677c5cf0d8,
    0x3fcf0e3eb9e4acc4, 0xc0092132a23bf990,
    0x3ff356790581a2af, 0xc00204fd20341630,
    0xbff21e5aa421ecbf, 0xbff4327f47eb8798,
    0xbff7115c188d3750, 0xc011583efdeb3584,
    0x40118ec212b73b6a, 0xbfe611fe3582bf86,
    0x4010197c215b4604, 0x401007ea595745a4,
    0xc003df32dcc8ff5e, 0xbfff17f94d3467ac,
    0xbfe42a6db5ee42aa, 0xbfdd2cbad64ff050,
    0x3ff92dadaae1d04e, 0x3ffab6470c8a903e,
    0x4002612e68e4e48f, 0xbff8ff6f8ce94811,
    0xbffa382d59caeaf6, 0x3ff594207a1353cf,
    0xbfd58d60d03f7e40, 0x4010c6eb7b45ee40,
    0x3ffe1b1a9dc83e84, 0x3ff32360d61721b2,
    0xc008d40e64a4d894, 0xbff727f74d952bc8,
    0x3ffb6f69348794f1, 0xbffff2437ff5dac8,
    0x4007e98e63b140b4, 0x401194a0fa0a2454,
    0xc001308e4c12d5d9, 0xc001bf34e2dba741,
    0xbff462435d6cb084, 0xbfd6461f4016a663,
    0xc00123c13e5c6480, 0x40047afca5d54582,
    0x4012e5144c2c870f, 0xbfe5cbda5a092999,
    0x3ff36f13f1248721, 0x3fe064bdcfe55944,
    0xbfe06b97866eaeae, 0x4001dfdf165aebc0,
    0x3fefb090bbbcbbf2, 0x401f9808272a32ec,
    0xbff30eeab734f782, 0x3ff855c84454b1c0,
    0x3fefa2db81d98acc, 0xbff72b8611d00dba,
    0xc000af06ec14ebb2, 0xbfe21223d0dbeb9e,
    0xbffc807c9addea3e, 0xbfe8e73796d87943,
    0x400ae9161da16e76, 0x3fb1a66e5c061b68,
    0xbff3d156a6147b88, 0x4006aecacf38ca16,
    0x3fdafc2b9c0c1164, 0x4011faa7cabfd808,
    0xc008f7bfb0e04b2f, 0x400b1c54b908ddda,
    0xc0008c11724fc6f2, 0x3fedd71e959e37ec,
    0x400bef8a2b20297c, 0xbfebdbfdb23a54ce,
    0xbfde2c7dba5a815c, 0xc017698ac4a32346,
    0xc0048816a21bda78, 0xbfde7a064d854657,
    0xc00e00b6506ab40b, 0x400088b52f2ff715,
    0xc005101c036512cc, 0x3fd7b8464badae48,
    0xc00e6ece20b88462, 0xbfd2d5a53c15f138,
    0xbfedf21d9eece305, 0xc008232a123daf29,
    0xbfe684380b838236, 0x4008a634d29942bd,
    0x3ffb7080ed494294, 0xbfe6ab569a5ba396,
    0xbff784db955ac85e, 0x3ffbd6d55042bd8c,
    0xbffe8fa0c526705b, 0xbfc0444714b294ec,
    0x3fd2954a1257d318, 0xc00a94d87f1a15b4,
    0x3fe5328912e18086, 0x3ffd21017f4ad212,
    0xc00063f74eeaff38, 0xbfda515e9aee3b70,
    0x3ff8ab55cf50bb34, 0xbff55daaa2a627c9,
    0xc00115cf5ef59430, 0x3fd280c7bb5b2730,
    0xbffb1bd2988fb3fe, 0xbff0bc78509ab8e1,
    0x3fbb52a15fe77b10, 0x4013317b56434fea,
    0xc005ef11836a3f3d, 0xbff2d50b54648495,
    0xc001fd61ff5a501e, 0xbfb82a8897a6bbd0,
    0x400b3743f9ef837e, 0x3fdf7f27485a40fe,
    0xc00fb9a909f78526, 0xbfaaafb0e30da9c0,
    0xbffd508129f39c89, 0x3fe73f0fac871847,
    0xc003d84debc0cb90, 0xbff3cffb02b2862e,
    0x40094df004c84cde, 0xbfde3946294431d8,
    0x3fef3b611d1e41e6, 0xbffbaa1b2635031e,
    0x4012905ea4876b60, 0xbfff59591e3cf4bd,
    0x3ff6a10a29e36960, 0x40083c8d45da37f4,
    0x40126007958f74e5, 0xbffc96e3dfae2700,
    0xc00c861f7db45696, 0x40090445fb24bd11,
    0x3ffc1f9476a37c94, 0xbfeba264a36c0e9e,
    0x3ff3b03ba16571c4, 0x3ffd7392b427c6e4,
    0x3fe7e28a43eac378, 0x4009d67552c4c04d,
    0x3fff2d542a60cbdc, 0xbffafac172855bd8,
    0xc001fb4ae4039426, 0x40052bcd69c52e40,
    0x3ff2974ad98ff964, 0xbff5579281b29d61,
    0x3ff0e7571cf31d53, 0x3fbac0d36f1e9c78,
    0xbfc5f3dd89876ed4, 0xbfe02ddb01d79f05,
    0xbfcaef406d6c64c0, 0x3ff3fca7ed4fea28,
    0x400c3920b97d656b, 0xbff213b542c9bd14,
    0xc0008ce19fb369ac, 0x40028b8eae0f1de0,
    0xc01230cfba3b9877, 0xbff23db3011b1470,
    0x40180c587c0cd14d, 0xbfcee57808c27fc0,
    0xc00ba6ed5841929f, 0x40169bed26288c1c,
    0xc012eadad5f3080a, 0xbfe9c8f00f99f570,
    0xc0102a974abd90aa, 0xbfdc17e5bb239994,
    0xc0012c386c0dcaa0, 0xbfe0b174cc71be84,
    0x3ffc6ae8c430b8dc, 0x3fcf00d9fa581d78,
    0xbff368a5d0eea315, 0xc008f50a758f61bc,
    0x3ff74cc5864491dc, 0x400ad8c92808ef21,
    0xc0003897641c65a6, 0x3fcb73f4d5aff040,
    0x3fed1cfd553c47b1, 0xbff7e6ff1215388e,
    0x3fe4273c4fd8b8ed, 0xc0112ed6531d0c39,
    0x4007cf6670eb03cf, 0xbff1ca1f297fc47b,
    0xc002600442d1b8d7, 0xbfeda232e86eea56,
    0xc0077ed5bdd2944d, 0xbffee69448422db0,
    0xc0085b9c72ab93e2, 0x3fca7b479334bb62,
    0x4000fc4626af969f, 0xbff01a85958e1502,
    0x3ff5106e0d8851e1, 0x3ffa1d098914b0c7,
    0xc003b91717f7b88c, 0xbfea7d822e79b624,
    0xbff9ee77d8de726c, 0xbfd8d9b81f685ee8,
    0x4003bcfc382f1e8b, 0x4004f828ad777d8a,
    0x3fc30ed45d88f788, 0xc01b2bab06549d24,
    0xbfd78ad2970a4c12, 0x4006186005aa98bf,
    0x3ff3c344b0f7d3df, 0x40083138a095da73,
    0x40085112583b3dc3, 0xc0078d900860ea3e,
    0xc00acfffd876b89f, 0x3ff10ab36c99bc38,
    0x3fff2dd0262b8cc4, 0x400e774dfe0fbdd2,
    0x3ff6d3f7c156e925, 0x40168264883367e2,
    0x3f8aabb634beeaa0, 0x4014b9dd5d671eca,
    0xc0013d95f24c5123, 0x3fea1da001ee6604,
    0x4012000dc34e35ea, 0xbff66023e33cd6be,
    0x3ffd9f4e99267f35, 0x3fdd8c44a6aff97e,
    0xbf98a0da884814f0, 0x3fb7af35436aec30,
    0x3ff7952b45fe2c0d, 0x401065715fcad106,
    0xbffbf9727c44aed0, 0xc00a9fa0ab8c4a2a,
    0xbff2e38396ffa53c, 0x40003358e5ada1a1,
    0x3fc10e2ea696c3a0, 0x3fec50073c07b100,
    0x400d6a1359a24c45, 0x3ff409e1a0d58216,
    0xbfb4aeb198c65a7a, 0xc0095cf7d7473f32,
    0x3ff087dcb514119f, 0xbff00c544693f630,
    0x4005a52b09e3345a, 0xbff500b116c4a0f0,
    0x3fc7b83265e457aa, 0x400ad61a1ddd9c62,
    0x3fa5775e066a9b80, 0x3ffdb60064b9885a,
    0x3fe47c9882e3ebcf, 0xbfec743d2e1182d6,
    0xbfe672d19720b16c, 0xc00122c872ba3efe,
    0xbff2b5fe5e0bd3d8, 0x4004625a307b10da,
    0xbfee1ce1c2e93526, 0xc01ae0abcdf7be53,
    0x3ff29747ec9c4ef5, 0x40069003939737da,
    0xbff9e3e41d9acc40, 0x3fd8836b052c07c3,
    0xbff6c12dfc7246a9, 0x3fc99bb079656458,
    0x3ffc6b9d191d48c5, 0xbffb19f96a85b7e0,
    0x3fff2008bfbb13bb, 0x3ff8824908f0a68f,
    0x3fec9c76abd83bb6, 0x3fcdc4bd68e92270,
    0xbffbef746a0702c6, 0x3fda3d469af638d2,
    0xc0007db91a6db16d, 0xbff585cf9de02f8d,
    0xbfb4359d33d08160, 0xbfef06aaecef74fe,
    0xbff90ad1cd6abb57, 0xbfdbc822eb5ed670,
    0x3fe96d51d1d33ee9, 0x3fffad00100c6519,
    0xbffd20c3a8950755, 0x3ff84e57dd126c6e,
    0x400bc137d6675f3a, 0xc0015b26fdb80b02,
    0xbff87cd2000607cf, 0xc000b03c8847210a,
    0x3ff10b492ef3b1e2, 0x3ff0b3aa0b9e1753,
    0x3ff8bf97abfebbfe, 0xbfc3aa168f50a2d8,
    0x3fe266d4ed8825a6, 0xbff1d393f2dbf49e,
    0x400d641199eb4c4c, 0xc0002c45e302866d,
    0xbfff3ff08ab75df7, 0x4003a5ca0d5f5ab4,
    0x40113b7bb2a17659, 0x40127943e747412e,
    0xbfffb425daea7672, 0xbffccc19ffd3b796,
    0xc002b4f28bdb22d1, 0xbfd02632915fa0d7,
    0xbfdbfbb2f20b7790, 0xbf9a8919c9331340,
    0x3fb4c9adc85e7958, 0xbff1020848df84f3,
    0xc004266d8e19527c, 0x3fe2ea69184f8a52,
    0x3ff2d2d2941cad3a, 0xbff98747f2edbbbc,
    0x3fc7145b2b0a074c, 0xbfea7b18f0d8f6b2,
    0xbff41ffa40911892, 0xc010e432741df9bd,
    0x3fe35b43c0d0534e, 0x3ff71322df012372,
    0x3fb70d4662184900, 0x4007c787040cc262,
    0xc000c051beba96c3, 0x4007232a07e07fb4,
    0xbfd2eef07a62882c, 0x3fdb82d28179c614,
    0xbfe1d0c7adfd387a, 0xbff45e18dcfa9f7c,
    0xbfc1004aba04d4bc, 0x3ffae1e237dd4b3e,
    0x40174dfaec9d1ac8, 0xbfe6c5ddc90eca44,
    0x40137f984efe2b59, 0x400e8c4503c8e044,
    0x3fed972d046713d8, 0xbff8bf1585869105,
    0x40012a0c09c69ac2, 0xbff12116ef38409c,
    0xc000a8e3d5e9fad9, 0x40061f9d00f4ebc8,
    0x3fd56e8baa85f438, 0xbff1dbc8bcdc8a8b,
    0x40016bf7a288fdf2, 0x400131e9d0d29530,
    0x3febd24f4e1af315, 0xc01cc57a0ac93ec6,
    0x400e22dbeb02dca8, 0xbfeea4fb5de5327c,
    0xbfe223ee1b5c3710, 0x3fed2521b0f3ee78,
    0xbffbb182d997cb77, 0x3ffe767d92f91b69,
    0x3feb60d700932a2d, 0xbfe36f299d5a9ae4,
    0x4004a0116402fedb, 0xbff30b137780e84a,
    0xbfebfe1dca2058ca, 0xc00711183ad3fdca,
    0xc000266d6be99595, 0x400066e23d5808e6,
    0xbffac4cfec866112, 0xbfe3be9c46fa04c8,
    0x4004c2b17b42549e, 0xc009ee8a09c232e3,
    0xbfe03c69a7c10184, 0xbffaa18ac64deb7c,
    0x3ff18402c06d8620, 0xc007a3ba83fbe9f9,
    0x3ff1a7458ce7f841, 0xc01481855824fd7d,
    0x3fdc247b43daac28, 0xc015ce752741dafa,
    0xbfd9fee72e440eb9, 0xbfd5de169236e698,
    0x3ff1e6e485f4145c, 0x3fdd1de7c66163a2,
    0x3fe25ba48a61e2a0, 0xc0025e99f06f0802,
    0x3ff5f78fd9b17a0d, 0x400054ad759f0417,
    0x4012f44eaa812031, 0xbffe96166e0cc4ee,
    0xc011d6e2f2e65f06, 0xbfbacfa2b52406c8,
    0x3fe8672fdc8bddf2, 0xc002d7265dc6cd98,
    0x3ffd5ac519204c15, 0xbfe2ea154bf1854f,
    0xbff41ef71f3e05b3, 0x3ffabb9bc578981e,
    0xbfe17da59c706394, 0xbfcc8b5cae6b047e,
    0x3ff84fdf1775f58c, 0x3ff4532fa5e95adc,
    0x3ff3f3f354e256fc, 0x40159c4dca2af7e2,
    0x3fc9b54e123e1690, 0xc005c652e742bf71,
    0x3fe62bf1827485a7, 0xbfdebdc028d5ab2f,
    0x3fd0aa8cb9c490f0, 0x3fe3b9da5fe07e54,
    0x3fda0474a438a6b8, 0x3fc78ef9f1ef4f4c,
    0xbfc6206969ed7eb8, 0xbfb7c1219adb6574,
    0x3fdc6606c648bb0c, 0xbffb9ee32212dfb8,
    0x3ff05c80ddee9dae, 0x4015a4ab78ebeee3,
    0xc013d5103c5214a5, 0xbff599ef7e0e9f82,
    0xbffa685da43e0a44, 0xbff9bfefcf8d0f50,
    0x3fecf44eb4f88cba, 0x400fe9b69cdc0091,
    0x4004743bc4d1b73f, 0xc0015724171dcdaa,
    0xbffbb60df26b3b76, 0xbfdd522251739e6c,
    0x40162e012d2560fc, 0xbfe2d404e3df57f0,
    0xc0135cc305394464, 0xbff34f4ad1e359a6,
    0x3ff70e36382607a4, 0xc00764e79d4b8c79,
    0x4011aef90f22f7a1, 0xbff8f0ba7c2297eb,
    0xbfd27154775f11f2, 0xbfe72e38b90471f6,
    0xc00ebe738a9c4dd4, 0x4003be1fdda3cb5f,
    0xbff7e59c32a49580, 0x4014d8ce63c8b9b8,
    0x4002392461b0a8bc, 0x3fed03e79becd3a6,
    0xbffb8a2fcfcadc2c, 0x3fde5dc07f5c6010,
    0xbf9ae1da86fa8c40, 0xc00b49edc4518044,
    0x40161d7cbe46fc1a, 0xbff55a5f6bfe0009,
    0x400817166cb9792c, 0x4008a902958cb594,
    0xc00accfda9d9603e, 0x4005449e855af5e0,
    0xc00106b0aa720a9c, 0x3ff5cc61f6911585,
    0x4001a39f6c7643e9, 0x4003c1b43b69a81e,
    0xc000ba88458d547c, 0x400c93bcb8c69f90,
    0xbfc0e8462258e3b4, 0xbff30e820772cdd3,
    0xbfd1c9c42d1862c4, 0xbffa5d1a35ba06f4,
    0xbfda58bf1681d4ad, 0xc0014f3dc46091fa,
    0xbfc6028177a2dae0, 0xbfddd7dd8a1c81e4,
    0x3fdc759ad7ef6377, 0xc009c02d327ace08,
    0x3ffcc2cfe9e77a83, 0xbfeb8f8f3b10119a,
    0x3f64c2ddfc6ade00, 0xbfdeac4984e851a0,
    0x3ffd0d0c7163f1a2, 0xc011922e9c9b626a,
    0x3fff4fa43c1ed984, 0x40039b6b0c283d8e,
    0x4004a29d8155c8d2, 0xc003d86282319bae,
    0xbff0fc698afa92be, 0x3fea730775403b3e,
    0xbff322d7ecde04ad, 0xbffdb3271127f435,
    0xbff5bdc94e53e4b0, 0xc009e01fb8c1df1c,
    0xc0112880188d4c43, 0xc0103fa4b4ddf6f8,
    0xc00614043c617bc2, 0xbfdc9f98523a4f03,
    0x3fdca28eb9245566, 0xbf964eb0dd83ea80,
    0xc008bb578971abed, 0xc00db7e2df2d039b,
    0x400109cd38e1d52c, 0xc004d6d9febac514,
    0xc00a4ddfdc2c8da8, 0x40138163f0c14e94,
    0x4013e7937b787e9e, 0x3fd91e81af059296,
    0xbff4c2d2d7ab5158, 0x3fed18d170fb6fe0,
    0x40059d90b2e50e1b, 0xbff454080b627a6a,
    0x3fe89e6b0679722b, 0x3ff72f0da790d1e0,
    0xbff80e013718044f, 0x400cdd31b4259d65,
    0x3fe33977c053dcd5, 0xc01138569c820d9a,
    0xc0082cbe1b9a2d5b, 0x401228790cde1e59,
    0xbfe7a762e3992878, 0xbfeca50aa0a99b7b,
    0xbfe361f5bfef8524, 0xbff91856995cc48c,
    0xc005ed5a45536f56, 0xbfeb970fb9ef33b8,
    0x400ae92fb6c6fca3, 0xc00e50440f50534d,
    0xc00e23db28c3fb66, 0x3fe15dbbe1459d04,
    0x400332a918a961eb, 0x4007172a011e83b4,
    0xc00168ac9e537e91, 0x40006d476d1c4c87,
    0xbfe21a1b9c4e710a, 0x3ffe22c4b352c8b0,
    0xc01159146f7fa9ab, 0xbfe2644ebbf6f82a,
    0x3fa547e832f45990, 0xbffb65f16a1c7bde,
    0x400a9267df658892, 0xbfe4a5e0a08a57d8,
    0x4006225ce6412d2a, 0x4002069e80a86c6d,
    0x400066a0c5ae6329, 0x40055947eef50391,
    0x4001cc1bc111cab6, 0xbf765a841d4d3840,
    0x400f0a0c17448c4f, 0xbff1f143bada4612,
    0xbf83f11b135c2900, 0x4000d46d9a698814,
    0xbffc06de096f2d0a, 0xc00491ffbe379d54,
    0xbff4323e157605f8, 0xbff385bc0175dfa6,
    0xbfe3864f624e604b, 0xbfdd24ff0971f398,
    0xc010bf6329e9ea1c, 0x3ff3ea5aacd2485a,
    0x3fd78051364f4c0a, 0x40087c0ac34de270,
    0xc00738f361a7b06b, 0x3ff741611b1c6e99,
    0x3ff3ff582231621e, 0xc0092919f10a2a0f,
    0xbff2cff778a1fa0d, 0xbff85f2baffdf77a,
    0x3ff748ab728ab6fe, 0x3fed6e2a011ffd64,
    0xc0010c8eaf733bc4, 0x4004b8415f46044c,
    0x4001e8f340b46626, 0x3ffc668ac735ef24,
    0xbfea72509358be60, 0xc0008db86fbbe491,
    0xbff963cbd990ffdd, 0x4003ffb6c1eb6d47,
    0xbfec34691fedd7aa, 0xbff37c918c7a29f7,
    0xc002c1d08ea60de4, 0x3fe69b6bc5d375ed,
    0xc001ef5f783c8334, 0xbfed80b689aebbaa,
    0xbfc02ff7186e5094, 0x3fd8881b6d61dc24,
    0xbff16abc70a1e68b, 0xbff80b2af98d0c1e,
    0xc00a75c1d108a009, 0x3febdfa2aee9803b,
    0x3fe9d05e5f2a6a2c, 0xbff709e3f64c3e26,
    0x3fe2fe36a9961b17, 0x4003c8d638f0f600,
    0xc002a21fd09bc41c, 0xbff05bfe880c6b88,
    0xc009d9aef29ca638, 0xbff6098ef407f365,
    0x3ff455350cb3ccd0, 0xbffd69a2a56e9dd6,
    0xc00397d50fdf8950, 0x3fbbd8e952377050,
    0xbfe834d355e812fe, 0x3fe3d1001a719219,
    0xbff3bd20644671fa, 0xbffac520c3c33d63,
    0x3fff5a9ce4892384, 0xbffee81b810e8650,
    0x3fcd96d629b7e0f8, 0xbff522d47b0f4c6f,
    0xbff9bb7ea1db3b6a, 0x3ffdb50635ba836e,
    0xc002db767b609130, 0x3ff16f7629c43360,
    0xc007db577facafca, 0xbfd9ede441c7fa98,
    0xc006a2557b24f329, 0x3fd7f726c4540e20,
    0xbff8b724d0d5be80, 0xc00f77d6336143ac,
    0xc010ceaf17b5ac21, 0x400156acf7423776,
    0xc004771aab0da654, 0x3fd6d7a08a22d97e,
    0x400428b00097dea5, 0x40041dcab8d5f777,
    0x3fd6f6c74665cde8, 0x400542f1a13aabe2,
    0xbfdab2b62f3df975, 0xbfd0b00393945572,
    0xc010b5fdced6021a, 0xc011aead2f8f5098,
    0x4000f02c9ef737fc, 0x3ffef8a5266a3a55,
    0x3fea432d1e7183ea, 0x4002421f0b8253aa,
    0xc007eec44241512c, 0x3fe89bee22e7acec,
    0xbff6666b60241792, 0xbfe21a8f560eb764,
    0xbfa1eff8a66bdaf0, 0xc003f84677cc6f2a,
    0xbff5c98ba4eb35ef, 0xc00a8c9c1fe615ae,
    0xbfc38d2fe1cfb340, 0x3fe5d0087ce64853,
    0x3fde90827e8ee9d0, 0x400e9f39e40257e5,
    0x400163cd19a48bf4, 0x4011093e4e9e452e,
    0x400003575b420ba9, 0x3fbc1ebc61062f40,
    0xbfdec3d856a74144, 0xbfd3f264ac677ae8,
    0xc006658871610df7, 0x3ff4644baab83446,
    0xc009c13848003d09, 0x4000ea838d4b8ce3,
    0xbffbc459b0e0908d, 0xc001b1e9542db4f0,
    0xbfa0a20728b66720, 0xc00456f2978b2040,
    0x3fe61232adb244b8, 0x4016683ebbb77756,
    0xbff7318ad3c9f8a8, 0xc00033a716dbde35,
    0xbfd80b12cdc92418, 0xc00f2acc9d2a7c0e,
    0x3fd78e5c6e92ebe4, 0xbfd6e82aba485198,
    0x3ffa63ecd6d2f189, 0xbff685ca58c2a670,
    0xc006306b4c0ee4df, 0x3fe624c41e254463,
    0xbf7130af20144b80, 0x4014969831f8b544,
    0x3f82a930bec88c40, 0x3fee0b47a9bae784,
    0xbff89d2694104373, 0xbffb30843fb17667,
    0xbfce9eeb2a890cbc, 0x3ffcae15dfd643ca,
    0xc002e1a0049620c8, 0xc007764e6e1c508c,
    0xbff996248f3a554b, 0xbffef961bbb52818,
    0x3fe700914d5cfeca, 0xc0071bc06501d56a,
    0x3fb7a49032035140, 0xbfb6a80d17ba3e60,
    0x3fdec8445d6763f6, 0x3ff26ed482775020,
    0xbfb54633098eac30, 0x3ff12cc5c06386bd,
    0x3ff1d8cd0f3e7e84, 0x401267493ab17bf3,
    0xbfed46cda8e2f194, 0xbffa34652d9ac6ae,
    0x3ff3457e86bfea14, 0xbffd770450eedcdc,
    0x3ffa8a3d3bc8556a, 0x4003f9c2ea4b9f44,
    0x400710b79da7f77a, 0xbfc904144584ab22,
    0x3fee16b72c96b286, 0x3ffa7c11ecceb7fc,
    0x400eb339ebfb468f, 0xbff5c54ad1bc9aa7,
    0x3fe473eee7fc0d8c, 0x3ff5e07f84c04355,
    0x3fc2c1acad4356bc, 0x3fd6bc128b22e300,
    0xbfe01bacbc16755f, 0x3ff12a6f2a1f537c,
    0x3fd986d3622d7e7b, 0xc00c50787285311b,
    0xc004f1f51f73423d, 0x3ff71ba417a732e2,
    0x40122786dca50e15, 0x3fd0ec54547ffd32,
    0x3fe2374eb842acd4, 0x3ff93e9875890b48,
    0x40091e337f0bfefc, 0x400238959d3a0b03,
    0x40084c45c68ef61c, 0xc00da19ae38a00ac,
    0x400857c63fdc68dc, 0x400d7d8e6defd238,
    0xbfea47a7272a233c, 0xbfd5b30a9eb3261b,
    0x3ff11ad20491e8dd, 0x4001f537205f821e,
    0xc00b93ab6f0b6836, 0xbfdcf4e31713b37a,
    0xbfcfbf4373d299f0, 0xbff13b81a18c5d5c,
    0xc004ff036f144a39, 0xbfe67b3c366e5d03,
    0xbfe63a341ec61e6b, 0xc0033440ed56fe13,
    0x3faa21cd5f9f8ee0, 0xbff8318ae9230a94,
    0x0
    };

static const uint64_t in_rfft_step_32[32] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_32[33] = {
    0x402ccccccccccccd, 0x0,
    0xbfeccccccccccccd, 0x40224694b6d1e46c,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccd, 0x4007bc3751b89a60,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffaf0c4f1b61203,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff18be432937072,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccd, 0x3fe7a2b359cd577b,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdec9aff9db9274,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd1790763398d10,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb6b14264b87600,
    0x0
    };

static const uint64_t ref_rfft_step_32[33] = {
    0x402ccccccccccccd, 0x0,
    0xbfeccccccccccccd, 0x40224694b6d1e46c,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccd, 0x4007bc3751b89a60,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffaf0c4f1b61203,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff18be432937072,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccd, 0x3fe7a2b359cd577b,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdec9aff9db9274,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd1790763398d10,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb6b14264b87600,
    0x0
    };

static const uint64_t in_rfft_step_64[64] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_64[65] = {
    0x403ccccccccccccd, 0x0,
    0xbfecccccccccccca, 0x403251e65569b234,
    0x0, 0x8000000000000000,
    0xbfecccccccccccce, 0x401844ec2b5fac27,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x400cbe7785552991,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x40041f661e754926,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccd, 0x3ffe723ce98fc58a,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff80663076302d2,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff36a88f5ef7ae5,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fefc6a199472fc2,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fea1a5100191242,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe55c0a88a568ba,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe1431614ea7330,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdb3e263f09b83a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd49c0f5f0ec5a4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fccdb2939f178e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc1169b34e238e0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fa6a33d2f9b8f00,
    0x0
    };

static const uint64_t ref_rfft_step_64[65] = {
    0x403ccccccccccccd, 0x0,
    0xbfecccccccccccca, 0x403251e65569b234,
    0x0, 0x8000000000000000,
    0xbfecccccccccccce, 0x401844ec2b5fac27,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x400cbe7785552991,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x40041f661e754926,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccd, 0x3ffe723ce98fc58a,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff80663076302d2,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff36a88f5ef7ae5,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fefc6a199472fc2,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fea1a5100191242,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe55c0a88a568ba,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe1431614ea7330,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdb3e263f09b83a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd49c0f5f0ec5a4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fccdb2939f178e0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc1169b34e238e0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fa6a33d2f9b8f00,
    0x0
    };

static const uint64_t in_rfft_step_128[128] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_128[129] = {
    0x404ccccccccccccd, 0x0,
    0xbfecccccccccccc5, 0x404254ba4d4dccca,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd0, 0x402866e9c69d778c,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x401d3022a95b27c8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x4014bf4fc9bb14b8,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccd, 0x401008123832cdbc,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x400a04780e45d71c,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4005cb722f4c178c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4002aa50fa649f4b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40003e314c63f4cc,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ffc9b9e74f4875c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff96b67f3ac760e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff6bd76358b76c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff472492bef49cb,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff273af5fdf55ba,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff0b18fe45133f0,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fee3fe4ddc206a6,
    0x0, 0x8000000000000000,
    0xbfecccccccccccc6, 0x3feb6b7d37ce94c6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe8d7d22e314b70,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe679ca22c5ef04,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe44882f8cfcdf2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe23cc62c0d3545,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe050a3bd8405bc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdcfe4fb13c7a88,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd9884662bb5d58,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd638016e083b50,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd30749cae4e534,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcfe1506e2d44a0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc9de786d5d5ee0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc3fd3568b97240,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbc6ac9017f8dc0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb0fecd9ee5b280,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f969fbf20d4b400,
    0x0
    };

static const uint64_t ref_rfft_step_128[129] = {
    0x404ccccccccccccd, 0x0,
    0xbfecccccccccccc5, 0x404254ba4d4dccca,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd0, 0x402866e9c69d778c,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x401d3022a95b27c8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x4014bf4fc9bb14b8,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccd, 0x401008123832cdbc,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x400a04780e45d71c,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4005cb722f4c178c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4002aa50fa649f4b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40003e314c63f4cc,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ffc9b9e74f4875c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff96b67f3ac760e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff6bd76358b76c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff472492bef49cb,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff273af5fdf55ba,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff0b18fe45133f0,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fee3fe4ddc206a6,
    0x0, 0x8000000000000000,
    0xbfecccccccccccc6, 0x3feb6b7d37ce94c6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe8d7d22e314b70,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe679ca22c5ef04,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe44882f8cfcdf2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe23cc62c0d3545,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe050a3bd8405bc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdcfe4fb13c7a88,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd9884662bb5d58,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd638016e083b50,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd30749cae4e534,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcfe1506e2d44a0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc9de786d5d5ee0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc3fd3568b97240,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbc6ac9017f8dc0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb0fecd9ee5b280,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f969fbf20d4b400,
    0x0
    };

static const uint64_t in_rfft_step_256[256] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_256[257] = {
    0x405ccccccccccccd, 0x0,
    0xbfecccccccccccbb, 0x4052556f444c538a,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd2, 0x40386f6639ecffb6,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x402d4c71fd1460ae,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x4024e6fe4f285982,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd3, 0x40203b2c44fd1a24,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x401a81a322d4ff2c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x40165fbb942eb8f3,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x401355e79ffbb102,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4011014bfa560d28,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x400e5159adcb89ea,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x400b5137b880c652,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4008d3fad768aef8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4006ba35789a9a03,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4004edc99aa463ce,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x40035eb2dfdfdf48,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x4002010ecbb5f914,
    0x0, 0x8000000000000000,
    0xbfecccccccccccb8, 0x4000cbdc2f4a60fe,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fff7050fec91ed8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffd8102fa1da676,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffbc1255464e0ba,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffa29bf2b66d23a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff8b5233638a614,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff75ea6114c1dff,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff622675b951989,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ff4fd2844722499,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff3ec2bd9ce6eb0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff2ed1e8317f202,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff1fe02d5773620,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff11d2270f55b1d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff04901f171b532,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fef00ae7d262610,
    0x0, 0x0,
    0xbfecccccccccccef, 0x3fed8403679a1b74,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x3fec1a07758cd034,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3feac0fb156cb970,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe97751a28386f4,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe83baa2d8dfd1a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe70cc9743fbcd0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe5e994cf1941b4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe4d10de8b7f82c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe3c24f1adc0de2,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe2bc88546ed5ba,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe1befc715bc172,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe0c8fef16940b1,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdfb3e3fd6673d6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdde2896e544b22,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdc1ce35d5eddc2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fda61fb425f4da0,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fd8b0ec9b18b4dc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd708e2e6a7ae0c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd56917dc755ac0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd3d0d1d62870b0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd23f62655a81b8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd0b4250ee9c1c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fce5cfc4d450440,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcb5bb38d7028d8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc86355be430b80,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fc572d4b2e236d0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc2892c9c542ce0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbf4ac523ca0380,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb98d0665263400,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb3d742b6a264c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fac4f53b938e500,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa0f8e69f105400,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f869edfd0d80000,
    0x0
    };

static const uint64_t ref_rfft_step_256[257] = {
    0x405ccccccccccccd, 0x0,
    0xbfecccccccccccbb, 0x4052556f444c538a,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd2, 0x40386f6639ecffb6,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x402d4c71fd1460ae,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x4024e6fe4f285982,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd3, 0x40203b2c44fd1a24,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x401a81a322d4ff2c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x40165fbb942eb8f3,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x401355e79ffbb102,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4011014bfa560d28,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x400e5159adcb89ea,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x400b5137b880c652,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4008d3fad768aef8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4006ba35789a9a03,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4004edc99aa463ce,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x40035eb2dfdfdf48,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x4002010ecbb5f914,
    0x0, 0x8000000000000000,
    0xbfecccccccccccb8, 0x4000cbdc2f4a60fe,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fff7050fec91ed8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffd8102fa1da676,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffbc1255464e0ba,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffa29bf2b66d23a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff8b5233638a614,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff75ea6114c1dff,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff622675b951989,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ff4fd2844722499,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff3ec2bd9ce6eb0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff2ed1e8317f202,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff1fe02d5773620,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff11d2270f55b1d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff04901f171b532,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fef00ae7d262610,
    0x0, 0x0,
    0xbfecccccccccccef, 0x3fed8403679a1b74,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x3fec1a07758cd034,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3feac0fb156cb970,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe97751a28386f4,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe83baa2d8dfd1a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe70cc9743fbcd0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe5e994cf1941b4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe4d10de8b7f82c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe3c24f1adc0de2,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe2bc88546ed5ba,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe1befc715bc172,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe0c8fef16940b1,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdfb3e3fd6673d6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdde2896e544b22,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdc1ce35d5eddc2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fda61fb425f4da0,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fd8b0ec9b18b4dc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd708e2e6a7ae0c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd56917dc755ac0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd3d0d1d62870b0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd23f62655a81b8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd0b4250ee9c1c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fce5cfc4d450440,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcb5bb38d7028d8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc86355be430b80,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fc572d4b2e236d0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc2892c9c542ce0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbf4ac523ca0380,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb98d0665263400,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb3d742b6a264c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fac4f53b938e500,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa0f8e69f105400,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f869edfd0d80000,
    0x0
    };

static const uint64_t in_rfft_step_512[512] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_512[513] = {
    0x406ccccccccccccd, 0x0,
    0xbfecccccccccccb9, 0x4062559c819c53b0,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd8, 0x4048718527a1778f,
    0x0, 0x0,
    0xbfecccccccccccfa, 0x403d53841d299f94,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x4034f0e53fa19834,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccd, 0x403047e8c9b183ee,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x402aa0c94d1aa2aa,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x40268491490c1ed4,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x4023806fbb4028f0,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x40213189cac93696,
    0x0, 0x0,
    0xbfecccccccccccce, 0x401ebd483ea04e08,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x401bc8a1a932b51d,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x401956e984ec49a6,
    0x0, 0x0,
    0xbfecccccccccccda, 0x401748b32fe0514e,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x401587e19bdecd0e,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x40140471621c330b,
    0x0, 0x0,
    0xbfeccccccccccd04, 0x4012b28100c9542e,
    0x0, 0x8000000000000000,
    0xbfeccccccccccc9b, 0x4011891048168074,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4010812db07702de,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x400f2ad0073bcf4d,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x400d82d7a2f6c005,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400c037b797b57fe,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400aa71075cc7f10,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x400968ed757ea690,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x4008453466c2d153,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x400738a8d73f3de4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40064090432cec79,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x40055a999155b142,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x400484c9e8613776,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4003bd6d8d1eae92,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4003030bd4ad8a04,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x4002545d75b2a3db,
    0x0, 0x0,
    0xbfeccccccccccd14, 0x4001b044b1b37114,
    0x0, 0x0,
    0xbfeccccccccccc89, 0x400115c6f0e5b665,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x40008407830b2572,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffff48693c6e287,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffeef9a3e4b2e7b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffdf815a412f9b8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffd0ce5402e49b3,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ffc2d1225a37298,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffb57be60bd7a21,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffa8c21e1a3194e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff9c987d90e53d1,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff90f4c745878c7,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff85cdae9836072,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff7b1abc6aabb0a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff70d437a7ea219,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff66f310d3159df,
    0x0, 0x0,
    0xbfecccccccccccde, 0x3ff5d70d02b46478,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3ff54478604e88ad,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff4b71bd08b1d54,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff42ea6e14da405,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff3aacf587c0674,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff32b509c3c6a30,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff2afeb2c36d800,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff2386429ab36c9,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff1c484ec7cbfb4,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3ff1541aa397ddc7,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff0e6f5ff509b7e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff07ceae4882556,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff015d02790f968,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fef62fe9bd8a589,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fee9fa8ac326ecf,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fede15b098e3690,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fed27d66da7f07d,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd7, 0x3fec72df6f21307d,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3febc23e35ac2c10,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3feb15be350b522f,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fea6d2dee300c69,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe9c85eb5d865d1,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe92724801dc9cd,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe88955b077208d,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe7eecaedbea026,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe7575ef9d7f9b1,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6c2ee8c9e5926,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe6315831cb2de4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe5a27c298f12a1,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe5163c4b9d8b2c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe48c7bec72d75e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe4051fc4a0dfed,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fe3800dd9f56352,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe2fd2d6a501418,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe27c66d803661e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe1fda3979e6672,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe180ce1f012af4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe105d1d5a04d09,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe08c9b05de7036,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe01516cf6524b6,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdf3e6634d10e58,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fde55bd1785b0fc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdd7010f3ade9a0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdc8d41c454200c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdbad30bf4cf39e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fdacfc042f4c58c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd9f4d3c50d6e54,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd91c4fc2a645cc,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fd84619b0fa7258,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd77217ef331ad4,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd6a031b8fc8698,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd5d04f19dea694,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd50258e14a9bb4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd4363897500ab0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd36bd871edfa10,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd2a3234af3ee58,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd1dc049668ca54,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd11668596dbe58,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd0523b21944474,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcf1ed3f93d8fe0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcd9bc4e1485c18,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcc1b24e91df4b0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fca9cd0d1e28d90,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc920a6224e6e50,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc7a6831983eee0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc62e46a26b6370,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc4b7d0478a7860,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc34300274d27c0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc1cfb6e8b6e970,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc05dd5b07355d0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fbdda7c2c7bb2c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbafba435310700,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fb81ee83994b7c0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb5440da23bf840,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb26ada6eb2f040,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3faf262a45a38000,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fa9790968d39400,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa3cde0f27d6700,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f9c488054fb9e00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f90f76da3bec800,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f769ea800134000,
    0x0
    };

static const uint64_t ref_rfft_step_512[513] = {
    0x406ccccccccccccd, 0x0,
    0xbfecccccccccccb9, 0x4062559c819c53b0,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd8, 0x4048718527a1778f,
    0x0, 0x0,
    0xbfecccccccccccfa, 0x403d53841d299f94,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x4034f0e53fa19834,
    0x0, 0x8000000000000000,
    0xbfeccccccccccccd, 0x403047e8c9b183ee,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x402aa0c94d1aa2aa,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x40268491490c1ed4,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x4023806fbb4028f0,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x40213189cac93696,
    0x0, 0x0,
    0xbfecccccccccccce, 0x401ebd483ea04e08,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x401bc8a1a932b51d,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x401956e984ec49a6,
    0x0, 0x0,
    0xbfecccccccccccda, 0x401748b32fe0514e,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x401587e19bdecd0e,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x40140471621c330b,
    0x0, 0x0,
    0xbfeccccccccccd04, 0x4012b28100c9542e,
    0x0, 0x8000000000000000,
    0xbfeccccccccccc9b, 0x4011891048168074,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4010812db07702de,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x400f2ad0073bcf4d,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x400d82d7a2f6c005,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400c037b797b57fe,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400aa71075cc7f10,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x400968ed757ea690,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x4008453466c2d153,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x400738a8d73f3de4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40064090432cec79,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x40055a999155b142,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x400484c9e8613776,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4003bd6d8d1eae92,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4003030bd4ad8a04,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x4002545d75b2a3db,
    0x0, 0x0,
    0xbfeccccccccccd14, 0x4001b044b1b37114,
    0x0, 0x0,
    0xbfeccccccccccc89, 0x400115c6f0e5b665,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x40008407830b2572,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffff48693c6e287,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffeef9a3e4b2e7b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffdf815a412f9b8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffd0ce5402e49b3,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ffc2d1225a37298,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffb57be60bd7a21,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffa8c21e1a3194e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff9c987d90e53d1,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff90f4c745878c7,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff85cdae9836072,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff7b1abc6aabb0a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff70d437a7ea219,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff66f310d3159df,
    0x0, 0x0,
    0xbfecccccccccccde, 0x3ff5d70d02b46478,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3ff54478604e88ad,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff4b71bd08b1d54,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff42ea6e14da405,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff3aacf587c0674,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff32b509c3c6a30,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff2afeb2c36d800,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff2386429ab36c9,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff1c484ec7cbfb4,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3ff1541aa397ddc7,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff0e6f5ff509b7e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff07ceae4882556,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff015d02790f968,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fef62fe9bd8a589,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fee9fa8ac326ecf,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fede15b098e3690,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fed27d66da7f07d,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd7, 0x3fec72df6f21307d,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3febc23e35ac2c10,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3feb15be350b522f,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fea6d2dee300c69,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe9c85eb5d865d1,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe92724801dc9cd,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe88955b077208d,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe7eecaedbea026,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe7575ef9d7f9b1,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6c2ee8c9e5926,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe6315831cb2de4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe5a27c298f12a1,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe5163c4b9d8b2c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe48c7bec72d75e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe4051fc4a0dfed,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fe3800dd9f56352,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe2fd2d6a501418,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe27c66d803661e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe1fda3979e6672,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe180ce1f012af4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe105d1d5a04d09,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe08c9b05de7036,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe01516cf6524b6,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdf3e6634d10e58,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fde55bd1785b0fc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdd7010f3ade9a0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdc8d41c454200c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdbad30bf4cf39e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fdacfc042f4c58c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd9f4d3c50d6e54,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd91c4fc2a645cc,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fd84619b0fa7258,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd77217ef331ad4,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd6a031b8fc8698,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd5d04f19dea694,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd50258e14a9bb4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd4363897500ab0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd36bd871edfa10,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd2a3234af3ee58,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd1dc049668ca54,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd11668596dbe58,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd0523b21944474,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcf1ed3f93d8fe0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcd9bc4e1485c18,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcc1b24e91df4b0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fca9cd0d1e28d90,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc920a6224e6e50,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc7a6831983eee0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc62e46a26b6370,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc4b7d0478a7860,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc34300274d27c0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc1cfb6e8b6e970,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc05dd5b07355d0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fbdda7c2c7bb2c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbafba435310700,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fb81ee83994b7c0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb5440da23bf840,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb26ada6eb2f040,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3faf262a45a38000,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fa9790968d39400,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa3cde0f27d6700,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f9c488054fb9e00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f90f76da3bec800,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f769ea800134000,
    0x0
    };

static const uint64_t in_rfft_step_1024[1024] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_1024[1025] = {
    0x407ccccccccccccd, 0x0,
    0xbfecccccccccccae, 0x407255a7d0e959bb,
    0x0, 0x8000000000000000,
    0xbfecccccccccccc2, 0x4058720ce01d00fe,
    0x0, 0x0,
    0xbfeccccccccccd0e, 0x404d554889eb3cee,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4044f35eb0e6f56c,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd1, 0x40404b174bb2101c,
    0x0, 0x0,
    0xbfeccccccccccc8f, 0x403aa89091ff4d37,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x40368dc2f54252f8,
    0x0, 0x0,
    0xbfecccccccccccaa, 0x40338b0bfc399932,
    0x0, 0x0,
    0xbfecccccccccccfc, 0x40313d90d4fed3cb,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x402ed82c5c8c5f09,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x402be65c55c7ebbc,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x4029777b537d1967,
    0x0, 0x0,
    0xbfecccccccccccec, 0x40276c1cc1f4c08e,
    0x0, 0x0,
    0xbfecccccccccccaa, 0x4025ae23a14101b4,
    0x0, 0x0,
    0xbfeccccccccccca7, 0x40242d8c98e61f80,
    0x0, 0x0,
    0xbfeccccccccccd32, 0x4022de76357386ee,
    0x0, 0x8000000000000000,
    0xbfeccccccccccc68, 0x4021b7e0558818a8,
    0x0, 0x0,
    0xbfecccccccccccea, 0x4020b2d98016ccb1,
    0x0, 0x0,
    0xbfeccccccccccce6, 0x401f93e11ac94640,
    0x0, 0x0,
    0xbfecccccccccccba, 0x401df1a4380e6b0c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x401c7805bacda35e,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x401b215aaba9a5fd,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x4019e8fa0604d6b2,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x4018cb05d60ec634,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4017c441c79f5c7e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4016d1f37556e795,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4015f1c9e49ebfdd,
    0x0, 0x0,
    0xbfecccccccccccce, 0x401521ca5af8e6c4,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x401460413c4c59d4,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x4013abb5fd1082aa,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x401302e173851539,
    0x0, 0x0,
    0xbfeccccccccccd5c, 0x401264a601100b47,
    0x0, 0x0,
    0xbfeccccccccccc4a, 0x4011d0092e102c71,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x4011442e6abb8bbb,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x4010c052b994891e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x401043c9156615fe,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x400f9beedda0b93b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400ebca84a361c42,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x400de8c7c7c72a88,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x400d1f6fa78f01b2,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x400c5fd81f669d38,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x400ba94ca68325a3,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400afb29b188cdd5,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400a54dabe9b13d1,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4009b5d8a4d53aa3,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x40091da81ccc3046,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x40088bd87983cede,
    0x0, 0x0,
    0xbfecccccccccccef, 0x400800028ab39c94,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x400779c7a264ada8,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x4006f8d0b8e8fbbe,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40067ccdaaf73e84,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400605748e5d9b9c,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x400592811a48230c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x400523b4208b5798,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x4004b8d315c3457d,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x400451a7a6684edc,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4003edff573ea31e,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40038dab2fbe8598,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4003307f6d43ed6f,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4002d6533dfd190c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40027f0082b2a6f5,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x40022a6396a19d49,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x4001d85b1cb95586,
    0x0, 0x0,
    0xbfecccccccccccba, 0x400188c7d1a52f90,
    0x0, 0x8000000000000000,
    0xbfeccccccccccce1, 0x40013b8c621ccc44,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x4000f08d4505d722,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x4000a7b0990077ae,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400060de0503b6d9,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40001bfe9bb9bae9,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fffb1f982a9ed5a,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fff2f88273ee5b6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffeb082a818c2f8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffe34c4a734a670,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ffdbc2bc0b39d68,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffd469768e19378,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffcd3e8ccef68e5,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffc6402b620ee2c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffbf6c96f360ec0,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffb8c22abdc3b9d,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x3ffb23f571fa46e0,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x3ffabe2a04ad6ee5,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ffa5aa9d0d2638d,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3ff9f95f5af8adba,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff99a362ea21644,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff93d1aceb28cde,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff8e1faa6f7a03a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff888c3feb0e7ae,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff83165ec04d02e,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff7dbd0484f1a2d,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff787f3a538012a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff735c142848823,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff6e52b0491c03a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff696236b6e19bc,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff6489d8a84e9f6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff5fc8d00d151ed,
    0x0, 0x0,
    0xbfecccccccccccef, 0x3ff5b1e5f18e987e,
    0x0, 0x0,
    0xbfecccccccccccad, 0x3ff5689cfd5ce040,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff520a73bd1db0a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff4d9fa356dd34f,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff4948bddedf6b2,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff450528ef56780,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff40d450307161b,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff3cb5a50cadf5a,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff38a89e698d806,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff34acb86461216,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff30c17412e839d,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff2ce6574780a4c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff291aec58ad3f8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff255ec1ebbb9be,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff21b16ac255c7c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff1e127d8ad0c33,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ff1a8194b30ba99,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x3ff16fe4e3db6ae2,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff13884b99dbe9a,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff101f317c86b58,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff0cc2a7bc689a0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff0972592f5d444,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff062df389b0ee0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff02f5273f0e9c2,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3feff8f4ec9fabde,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fef94a532daace6,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fef31acbb62e84f,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3feed002d14220cb,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3fee6f9f06b7cea8,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fee1079325a4d83,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3fedb2896c5b1f9b,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fed55c80bec5660,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fecfa2da4c54c40,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fec9fb304c4ff40,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fec465131b069e0,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3febee01670b65bb,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3feb96bd140aa0a3,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3feb407dd99d5c28,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3feaeb3d888db0cb,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fea96f61fb62c3f,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fea43a1ca4baed6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe9f13ade3a7dee,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe99fbbda9591c4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe94f1f66173111,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe8ff604db1fda0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe8b07983319e87,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe862661bea42d0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe815214f764105,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fe7c8a676812414,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe77cf1099f7dc2,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe731fca032e13e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6e7c4ef597230,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe69e45c8e87924,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6557b1a7179e0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe60d60ec514ca5,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe5c5f360c8c2ca,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe57f2eb31e65d4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe5390f36c8e5b8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe4f39156a1d058,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe4aeb194203222,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe46a6c869ac451,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe426beda9151b0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe3e3a550fd000e,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fe3a11cbea72f7d,
    0x0, 0x0,
    0xbfeccccccccccce5, 0x3fe35f220b86a5ac,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x3fe31db23222bea4,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe2dcca3efc5e0e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe29c674ffc659c,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe25c8693e76de7,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe21d2549d68cd7,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe1de40c0b4f03a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe19fd656c218b0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe161e379188356,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe12465a3389205,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe0e75a5e9785ec,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe0aabf42326009,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe06e91f2247fa9,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe032d01f41d6a1,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdfeeef0d691d2a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdf790be33bf5bc,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fdf03f269756b3c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fde8f9e60138e3e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fde1c0b9ced6ebc,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdda9360b0cdd8e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdd3719aa0d8bf2,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdcc5b28d81591c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdc54fcdc599652,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdbe4f4d0551102,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdb7596b572b2ee,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fdb06dee9688b58,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fda98c9db1f14a8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fda2b540a308e26,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd9be7a066c4006,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd952386f5d852a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd8e68bf3d674d0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd87b71517e08cc,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd810e55461a032,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd7a6e4d689ba96,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd73d6cbf91d1f4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd6d47a04432ee8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd66c09a632a18e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd60418b360fd1c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd59ca445de40b8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd535a9836f50d0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd4cf259d362aac,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd46915cf5c7930,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd4037760c07588,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd39e47a2a3fcc0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd33983f05dc6cc,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd2d529af0ca93c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd271364d4cd3f0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd20da742eef34c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd1aa7a10b127e4,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd147ac3ff9c0f4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd0e53b6293a7fc,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd08325126c7160,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd02166f153fcc8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcf7ffd517b35f0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fcebdd3d30550d0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fcdfc4cd74d1d30,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcd3b63dc383ea0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fcc7b146d1878f8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcbbb5a223b7f18,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcafc30a07d28b8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fca3d9398dbf830,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc97f7ec80fd810,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fc8c1edf622fb40,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fc804dcf60cc920,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc74847a54ec1a0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc68c29eb934660,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc5d07fba4e2bc0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc515450c5f14c0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc45a75e5b56830,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc3a00e52f5e9d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc2e60a6921d320,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc22c66453f6360,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc1731e0c03d340,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fc0ba2de97e9c30,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc0019210c60440,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbe928d7749bb40,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbd22905492d800,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbbb32545eac160,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fba4444e35dbc20,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb8d5e7cfe4e980,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb76806b8cc1a40,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb5fa9a551960c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb48d9b64f63ac0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb32102b11a5300,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb1b4c90a37a000,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb048e74867df80,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fadbaac95369f00,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3faae41dec10ff00,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fa80e146b3a6a00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa53881f2e08000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa263586c684900,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f9f1d1392aa2c00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f99741004617000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f93cb8a2ae9c000,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3f8c46cc19d58000,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f80f70f712dd000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f669e9a0c160000,
    0x0
    };

static const uint64_t ref_rfft_step_1024[1025] = {
    0x407ccccccccccccd, 0x0,
    0xbfecccccccccccae, 0x407255a7d0e959bb,
    0x0, 0x8000000000000000,
    0xbfecccccccccccc2, 0x4058720ce01d00fe,
    0x0, 0x0,
    0xbfeccccccccccd0e, 0x404d554889eb3cee,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4044f35eb0e6f56c,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd1, 0x40404b174bb2101c,
    0x0, 0x0,
    0xbfeccccccccccc8f, 0x403aa89091ff4d37,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x40368dc2f54252f8,
    0x0, 0x0,
    0xbfecccccccccccaa, 0x40338b0bfc399932,
    0x0, 0x0,
    0xbfecccccccccccfc, 0x40313d90d4fed3cb,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x402ed82c5c8c5f09,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x402be65c55c7ebbc,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x4029777b537d1967,
    0x0, 0x0,
    0xbfecccccccccccec, 0x40276c1cc1f4c08e,
    0x0, 0x0,
    0xbfecccccccccccaa, 0x4025ae23a14101b4,
    0x0, 0x0,
    0xbfeccccccccccca7, 0x40242d8c98e61f80,
    0x0, 0x0,
    0xbfeccccccccccd32, 0x4022de76357386ee,
    0x0, 0x8000000000000000,
    0xbfeccccccccccc68, 0x4021b7e0558818a8,
    0x0, 0x0,
    0xbfecccccccccccea, 0x4020b2d98016ccb1,
    0x0, 0x0,
    0xbfeccccccccccce6, 0x401f93e11ac94640,
    0x0, 0x0,
    0xbfecccccccccccba, 0x401df1a4380e6b0c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x401c7805bacda35e,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x401b215aaba9a5fd,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x4019e8fa0604d6b2,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x4018cb05d60ec634,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4017c441c79f5c7e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4016d1f37556e795,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4015f1c9e49ebfdd,
    0x0, 0x0,
    0xbfecccccccccccce, 0x401521ca5af8e6c4,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x401460413c4c59d4,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x4013abb5fd1082aa,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x401302e173851539,
    0x0, 0x0,
    0xbfeccccccccccd5c, 0x401264a601100b47,
    0x0, 0x0,
    0xbfeccccccccccc4a, 0x4011d0092e102c71,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x4011442e6abb8bbb,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x4010c052b994891e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x401043c9156615fe,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x400f9beedda0b93b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400ebca84a361c42,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x400de8c7c7c72a88,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x400d1f6fa78f01b2,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x400c5fd81f669d38,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x400ba94ca68325a3,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400afb29b188cdd5,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400a54dabe9b13d1,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4009b5d8a4d53aa3,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x40091da81ccc3046,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x40088bd87983cede,
    0x0, 0x0,
    0xbfecccccccccccef, 0x400800028ab39c94,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x400779c7a264ada8,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x4006f8d0b8e8fbbe,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40067ccdaaf73e84,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400605748e5d9b9c,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x400592811a48230c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x400523b4208b5798,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x4004b8d315c3457d,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x400451a7a6684edc,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4003edff573ea31e,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40038dab2fbe8598,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4003307f6d43ed6f,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4002d6533dfd190c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40027f0082b2a6f5,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x40022a6396a19d49,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x4001d85b1cb95586,
    0x0, 0x0,
    0xbfecccccccccccba, 0x400188c7d1a52f90,
    0x0, 0x8000000000000000,
    0xbfeccccccccccce1, 0x40013b8c621ccc44,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x4000f08d4505d722,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x4000a7b0990077ae,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400060de0503b6d9,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40001bfe9bb9bae9,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fffb1f982a9ed5a,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fff2f88273ee5b6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffeb082a818c2f8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffe34c4a734a670,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ffdbc2bc0b39d68,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffd469768e19378,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffcd3e8ccef68e5,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffc6402b620ee2c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffbf6c96f360ec0,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffb8c22abdc3b9d,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x3ffb23f571fa46e0,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x3ffabe2a04ad6ee5,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ffa5aa9d0d2638d,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3ff9f95f5af8adba,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff99a362ea21644,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff93d1aceb28cde,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff8e1faa6f7a03a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff888c3feb0e7ae,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff83165ec04d02e,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff7dbd0484f1a2d,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff787f3a538012a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff735c142848823,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff6e52b0491c03a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff696236b6e19bc,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff6489d8a84e9f6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff5fc8d00d151ed,
    0x0, 0x0,
    0xbfecccccccccccef, 0x3ff5b1e5f18e987e,
    0x0, 0x0,
    0xbfecccccccccccad, 0x3ff5689cfd5ce040,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff520a73bd1db0a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff4d9fa356dd34f,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff4948bddedf6b2,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff450528ef56780,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff40d450307161b,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff3cb5a50cadf5a,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff38a89e698d806,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff34acb86461216,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff30c17412e839d,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff2ce6574780a4c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff291aec58ad3f8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff255ec1ebbb9be,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff21b16ac255c7c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff1e127d8ad0c33,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ff1a8194b30ba99,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x3ff16fe4e3db6ae2,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff13884b99dbe9a,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff101f317c86b58,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff0cc2a7bc689a0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff0972592f5d444,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff062df389b0ee0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff02f5273f0e9c2,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3feff8f4ec9fabde,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fef94a532daace6,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fef31acbb62e84f,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3feed002d14220cb,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3fee6f9f06b7cea8,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fee1079325a4d83,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3fedb2896c5b1f9b,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fed55c80bec5660,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fecfa2da4c54c40,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fec9fb304c4ff40,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fec465131b069e0,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3febee01670b65bb,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3feb96bd140aa0a3,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3feb407dd99d5c28,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3feaeb3d888db0cb,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fea96f61fb62c3f,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fea43a1ca4baed6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe9f13ade3a7dee,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe99fbbda9591c4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe94f1f66173111,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe8ff604db1fda0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe8b07983319e87,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe862661bea42d0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe815214f764105,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fe7c8a676812414,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe77cf1099f7dc2,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe731fca032e13e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6e7c4ef597230,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe69e45c8e87924,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6557b1a7179e0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe60d60ec514ca5,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe5c5f360c8c2ca,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe57f2eb31e65d4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe5390f36c8e5b8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe4f39156a1d058,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe4aeb194203222,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe46a6c869ac451,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe426beda9151b0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe3e3a550fd000e,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fe3a11cbea72f7d,
    0x0, 0x0,
    0xbfeccccccccccce5, 0x3fe35f220b86a5ac,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x3fe31db23222bea4,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe2dcca3efc5e0e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe29c674ffc659c,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe25c8693e76de7,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe21d2549d68cd7,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe1de40c0b4f03a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe19fd656c218b0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe161e379188356,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe12465a3389205,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe0e75a5e9785ec,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe0aabf42326009,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe06e91f2247fa9,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe032d01f41d6a1,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdfeeef0d691d2a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdf790be33bf5bc,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fdf03f269756b3c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fde8f9e60138e3e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fde1c0b9ced6ebc,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdda9360b0cdd8e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdd3719aa0d8bf2,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdcc5b28d81591c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdc54fcdc599652,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdbe4f4d0551102,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdb7596b572b2ee,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fdb06dee9688b58,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fda98c9db1f14a8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fda2b540a308e26,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd9be7a066c4006,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd952386f5d852a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd8e68bf3d674d0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd87b71517e08cc,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd810e55461a032,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd7a6e4d689ba96,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd73d6cbf91d1f4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd6d47a04432ee8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd66c09a632a18e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd60418b360fd1c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd59ca445de40b8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd535a9836f50d0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd4cf259d362aac,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd46915cf5c7930,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd4037760c07588,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd39e47a2a3fcc0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd33983f05dc6cc,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd2d529af0ca93c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd271364d4cd3f0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd20da742eef34c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd1aa7a10b127e4,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd147ac3ff9c0f4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd0e53b6293a7fc,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd08325126c7160,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd02166f153fcc8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcf7ffd517b35f0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fcebdd3d30550d0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fcdfc4cd74d1d30,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcd3b63dc383ea0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fcc7b146d1878f8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcbbb5a223b7f18,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcafc30a07d28b8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fca3d9398dbf830,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc97f7ec80fd810,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fc8c1edf622fb40,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fc804dcf60cc920,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc74847a54ec1a0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc68c29eb934660,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc5d07fba4e2bc0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc515450c5f14c0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc45a75e5b56830,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc3a00e52f5e9d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc2e60a6921d320,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc22c66453f6360,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc1731e0c03d340,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fc0ba2de97e9c30,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc0019210c60440,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbe928d7749bb40,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbd22905492d800,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbbb32545eac160,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fba4444e35dbc20,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb8d5e7cfe4e980,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb76806b8cc1a40,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb5fa9a551960c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb48d9b64f63ac0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb32102b11a5300,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb1b4c90a37a000,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb048e74867df80,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fadbaac95369f00,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3faae41dec10ff00,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fa80e146b3a6a00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa53881f2e08000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa263586c684900,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f9f1d1392aa2c00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f99741004617000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f93cb8a2ae9c000,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3f8c46cc19d58000,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f80f70f712dd000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f669e9a0c160000,
    0x0
    };

static const uint64_t in_rfft_step_2048[2048] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_2048[2049] = {
    0x408ccccccccccccd, 0x0,
    0xbfeccccccccccc80, 0x408255aaa4bc2b9e,
    0x0, 0x8000000000000000,
    0xbfecccccccccccf6, 0x4068722ece0ccb9a,
    0x0, 0x0,
    0xbfeccccccccccd7d, 0x405d55b9a3679088,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x4054f3fd088b91ad,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd2, 0x40504be2e24253f0,
    0x0, 0x0,
    0xbfeccccccccccc7f, 0x404aaa823eed92bd,
    0x0, 0x0,
    0xbfecccccccccccae, 0x4046900f24647fa6,
    0x0, 0x0,
    0xbfeccccccccccc69, 0x40438db2b0659cb6,
    0x0, 0x0,
    0xbfeccccccccccd2d, 0x40414092117a723e,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x403edee3ed8e2318,
    0x0, 0x0,
    0xbfecccccccccccda, 0x403bedc9071f7614,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x40397f9d2e55bfe6,
    0x0, 0x0,
    0xbfeccccccccccd08, 0x403774f3d05a1d2a,
    0x0, 0x0,
    0xbfeccccccccccc7e, 0x4035b7afee1f2425,
    0x0, 0x0,
    0xbfeccccccccccc85, 0x403437ce3009c342,
    0x0, 0x0,
    0xbfeccccccccccda3, 0x4032e96d238a4da9,
    0x0, 0x8000000000000000,
    0xbfeccccccccccbfe, 0x4031c38ca820c8e2,
    0x0, 0x0,
    0xbfeccccccccccd05, 0x4030bf3b45a19504,
    0x0, 0x0,
    0xbfeccccccccccd00, 0x402fae0faa66c360,
    0x0, 0x0,
    0xbfeccccccccccca9, 0x402e0d3dec9b87f0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x402c950ab676ab00,
    0x0, 0x0,
    0xbfecccccccccccca, 0x402b3fcb12602487,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x402a08d5fd804bff,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x4028ec4d85cd611c,
    0x0, 0x0,
    0xbfecccccccccccfc, 0x4027e6f558e6bf26,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4026f6131334f4b2,
    0x0, 0x0,
    0xbfecccccccccccda, 0x40261755bbea70f9,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x402548c29a532b96,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x402488a61421009e,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4023d5879f9729c2,
    0x0, 0x0,
    0xbfeccccccccccca2, 0x40232e2014c225b5,
    0x0, 0x0,
    0xbfeccccccccccdd9, 0x40229151d6d5bcdf,
    0x0, 0x0,
    0xbfeccccccccccbbe, 0x4021fe226fff928e,
    0x0, 0x0,
    0xbfecccccccccccea, 0x402173b55245abf2,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x4020f14781fb7ad8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x4020762bfbbe2b98,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x402001c8b20155ef,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x401f27280bc2a8ef,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x401e562549a301e1,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x401d8fab728d5088,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x401cd2f2c00bbe12,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x401c1f46ad076592,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x401b7403b1db44d4,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x401ad095506490c5,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x401a3474637b4311,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x40199f25a77413f0,
    0x0, 0x0,
    0xbfecccccccccccb5, 0x401910387315cf60,
    0x0, 0x0,
    0xbfeccccccccccd15, 0x4018874599de291c,
    0x0, 0x0,
    0xbfeccccccccccc87, 0x401803ee719fb2f2,
    0x0, 0x0,
    0xbfeccccccccccce8, 0x401785dbf6794894,
    0x0, 0x0,
    0xbfecccccccccccde, 0x40170cbe08f1fcab,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x4016984ac2abdd94,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4016283ddeaa8692,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4015bc58329dbd43,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4015545f37009d76,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4014f01c9c2e7b02,
    0x0, 0x0,
    0xbfeccccccccccce8, 0x40148f5dead26e95,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x401431f42e4fb21e,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x4013d7b3a7f15674,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x4013807389d8ecf1,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x40132c0db8c6b662,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x4012da5e93f3c101,
    0x0, 0x0,
    0xbfecccccccccccea, 0x40128b44c24feade,
    0x0, 0x0,
    0xbfeccccccccccca4, 0x40123ea1048bab95,
    0x0, 0x8000000000000000,
    0xbfecccccccccccfa, 0x4011f4560b6865fe,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x4011ac4851da48f3,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4011665dfa94d838,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4011227eb0a76964,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4010e0938ad977c0,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4010a086f17feb7b,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x40106244868c7b66,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x401025b90f9f58d2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400fd5a4c3d2fb6b,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400f62fe9f66ba17,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400ef35f2ec0ea7c,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400e86a7a798e9aa,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x400e1cbadbc4a424,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x400db57d1ea1f4a0,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x400d50d42c884330,
    0x0, 0x0,
    0xbfecccccccccccf8, 0x400ceea714149627,
    0x0, 0x0,
    0xbfeccccccccccca5, 0x400c8ede2126d2c4,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x400c3162c96af8f5,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x400bd61f9a4cc198,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x400b7d0028373cf4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400b25f0ff04f1b8,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x400ad0df93878dcb,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400a7dba36108951,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400a2c7005e62d9c,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4009dcf0e5924dae,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x40098f2d6ff9a914,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x40094316ee2c7459,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4008f89f4de1dc5b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4008afb9189194a7,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400868576b1f9b7c,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4008226dee0f5f50,
    0x0, 0x0,
    0xbfeccccccccccd24, 0x4007ddf0ce345894,
    0x0, 0x0,
    0xbfeccccccccccc81, 0x40079ad4b5d6ffcd,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4007590ec645c290,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4007189491ca4e62,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4006d95c15fc1e5e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40069b5bb669d010,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x40065e8a3793415c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x400622deba2ef42d,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x4005e850b6b59fec,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4005aed7f92f3de8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x4005766c9d3d3823,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40053f070a5db5b2,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4005089ff0644d0d,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x4004d3304424a9ee,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x40049eb13c4bf58b,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x40046b1c4e660abc,
    0x0, 0x0,
    0xbfeccccccccccce5, 0x4004386b2c0bb635,
    0x0, 0x0,
    0xbfeccccccccccca7, 0x40040697c037751a,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4003d59c2cbe51cc,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4003a572c7eaaa4c,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x400376161a36d14c,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x40034780dc25a09a,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x400319adf43733d0,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x4002ec9874f821b8,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x4002c03b9b29a6d6,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x40029492cc014e94,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x40026999937ebfea,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40023f4ba2d66a7b,
    0x0, 0x0,
    0xbfecccccccccccb3, 0x400215a4ceefe450,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x4001eca10ef6dd93,
    0x0, 0x0,
    0xbfecccccccccccba, 0x4001c43c7afda046,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x40019c734ab02438,
    0x0, 0x0,
    0xbfeccccccccccceb, 0x40017541d416cca4,
    0x0, 0x0,
    0xbfecccccccccccb0, 0x40014ea48a67f7ba,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x40012897fce78efb,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x40010318d5d3dd68,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x4000de23d95ef0d6,
    0x0, 0x0,
    0xbfecccccccccccee, 0x4000b9b5e4b3e1ea,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400095cbed075f1c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40007262feb2e766,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x40004f783c5a2592,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x40002d08de19e813,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x40000b1230c037f6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fffd3232a1a312c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fff9108fdf702dc,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fff4fd0ea245117,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fff0f761f7775ea,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffecff3f14c4ad7,
    0x0, 0x0,
    0xbfeccccccccccceb, 0x3ffe9145d4512b4e,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3ffe53675d5fc076,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffe16544061f943,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffdda084f429a89,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffd9e7f78e8d8d8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffd63b5c83e7824,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffd29a7633ff2a7,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ffcf0508a162f6a,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffcb7ad9639577e,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3ffc7fbaf99c5f04,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ffc48753de0dbde,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffc11d90392ca36,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffbdbe3016be347,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3ffba690039e2f80,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffb71dceb258271,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3ffb3dc6ad1f9136,
    0x0, 0x0,
    0xbfeccccccccccd08, 0x3ffb0a4a522a5a68,
    0x0, 0x0,
    0xbfeccccccccccc96, 0x3ffad764f5c89827,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3ffaa513c5cbf94a,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffa735401c4e2fa,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffa4222fa777c90,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffa117e1155cd0e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff9e162b7feb366,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff9b1ce6fc184a4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff982bec9261ed8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff95431637940e3,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff92623ec5cfad6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff8f8941f5d0a70,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff8cb7fc586fc64,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff89ee4b505e9d7,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff872c0d0c1adcb,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff8471208016e29,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x3ff81bd656115703,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3ff7f10bc1eb6726,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff7c6b05de32f0d,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff79cc247546547,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff7733fa65432e4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff74a26ad651df0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff72175992d77a7,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff6f92ab03035ae,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff6d14442881eea,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff6a9c0a9a53541,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff6829e480c466c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff65bdb89188fc6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff63576e0bf6088,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff60f6ecb55a7fe,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff5e9c1cd575d60,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff5c46e7330aff8,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff59f735108eeb7,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x3ff57acf028f175e,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff556802ac7fe3f,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff5328573ddfef4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff50edd8ef22922,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff4eb8733eedae0,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff4c881215bbc37,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff4a5ca1c330f0c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff48360efb847ca,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff461446d4fe2f8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff43f736c586d3c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff41decca04b253,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff3fcaf69370a02,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff3dbba325db82a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff3bb0c13505748,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff39aa3ff2e43ea,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3ff37a80ee3e00f0,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff35aa1ddcd8bba,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff33b05d0139850,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff31babcc11ae83,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff2fc92dd771f54,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff2ddba1484ccad,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff2bf2085f1bbe8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff2a0c54ad06c8a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff282a78074ed1c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff264c6485ba7d0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff24720c810e0db,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff229b62918e140,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff20c8598d8c80c,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff1ef8e487ffd38,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff1d2cf6cf240aa,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff1b6483eb250ba,
    0x0, 0x0,
    0xbfecccccccccccee, 0x3ff199f7f9cd231a,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x3ff17dddddc5ac8a,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff161f92d813097,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff146492f34194a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff12acd2c4f4d6c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff10f84716e0620,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff0f46e4e441cf8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff0d98a158cd038,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff0bed71cf9f95a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff0a454bd23b237,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff08a02517865ff,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff06fdf382d4a0d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff055ead22f3c60,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff03c24831403d1,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff0228bb10bf00c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff0091fc4d3d58f,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fefdfc0534ec7a4,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fefad989a67a529,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fef7bc73f15c69d,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fef4a4b262c6bb9,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fef19233915d7a8,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3feee84e65bb34a7,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3feeb7cb9e6d0d6c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fee8799d9cc58e7,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3fee57b812b414ec,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fee282548236aed,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fedf8e07d2859c1,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fedc9e8b8cae4c8,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x3fed9b3d05f8befa,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x3fed6cdc7371743d,
    0x0, 0x0,
    0xbfeccccccccccc9e, 0x3fed3ec613b307b3,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fed10f8fce709f6,
    0x0, 0x0,
    0xbfeccccccccccc9b, 0x3fece37448d01fa4,
    0x0, 0x8000000000000000,
    0xbfecccccccccccfd, 0x3fecb63714b7f3a4,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fec8940815d9b76,
    0x0, 0x0,
    0xbfecccccccccccf2, 0x3fec5c8fb2e45b33,
    0x0, 0x0,
    0xbfecccccccccccec, 0x3fec3023d0c2d83d,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x3fec03fc05b2a7fa,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3febd8177fa041e8,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3febac756f9b50a1,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3feb811509c75aad,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3feb55f5854cc7ac,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3feb2b161c4a3907,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3feb00760bc6397c,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fead61493a13cc7,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3feaabf0f687efc8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fea820a79e5d6f9,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fea586065d837ed,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fea2ef205214cf9,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fea05bea51bc114,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe9dcc595ae70be,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe9b4062940710f,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe98b7fb4ad574a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe963318f39c2bf,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe93b1b1288255a,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe9133b9a8dc9d6,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe8eb928588164e,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe8c41f33f2090d,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe89ce10879eec1,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe875d767f75061,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe84f01b9611761,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe8285f65c3e6c9,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe801efd838a83d,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fe7dbb27ddb4b4e,
    0x0, 0x0,
    0xbfecccccccccccea, 0x3fe7b5a6c5c1b5e4,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x3fe78fcc20f2e56b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe76a22025e3ce3,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe744a7ded303b8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe71f5d2cf80e69,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6fa41654393ff,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6d55401f32e1c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe6b0947f04022a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe68c025a2b1320,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe6679d12cdbae9,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe6436429fa4a81,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe61f572260cf60,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe5fb75804bfe62,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe5d7bec99a41e3,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe5b43285b6eba6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe590d03d9388a5,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe56d977ba15683,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe54a87cbcad9fb,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe527a0bb6d9488,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe504e1d953daa3,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe4e24ab5aec715,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe4bfdae2104d38,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe49d91f16567de,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe47b6f77f064f0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe459730b434cc5,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe4379c423a64e3,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe415eab4f6cd48,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe3f45dfcd937ba,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe3d2f5b47cb8a5,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe3b1b177b1b0b2,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe39090e378cee9,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe36f9395fe2a8a,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe34eb92e947426,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe32e014db03d40,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe30d6b94e35724,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe2ecf7a6d84601,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe2cca5274dcacd,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe2ac73bb128109,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe28c6308009169,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe26c72b4f97831,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe24ca269e1df32,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe22cf1cf9d8aeb,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe20d60900b5a5e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe1edee560158f6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe1ce9acd48e2c4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe1af65a29ad9d1,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe1904e839bed02,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe171551ed8ef5e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe1527923c34010,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe133ba42ad42c2,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe115182cc6e696,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe0f692941a3e6e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe0d8292b88266e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe0b9dba6c4f977,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe09ba9ba5554d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe07d931b8ae9d0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe05f9780815dba,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe041b6a01b36fd,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe023f031fed7e8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe00643ee938660,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdfd1631dfd00da,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdf96719a403aa2,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdf5bb2c721f580,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdf21261b3e6cf2,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fdee6cb0e97660c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fdeaca11a8ed2f0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fde72a7b9e186e2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fde38de68a2099c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fddff44a4337748,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fddc5d9eb447bd4,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdd8c9dbdca6058,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdd538f9cfc2e18,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fdd1aaf0b4de530,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdce1fb8c6bc69a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdca974a535b288,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdc7119dbba980c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdc38eab733f90a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdc00e6c0017ed0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdbc90d7fa4a16c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdb915e80bc6014,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fdb59d94f010ac2,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdb227d77401cf2,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdaeb4a87582744,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fdab4400e34cc68,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fda7d5d9bcaca44,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fda46a2c11414f0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fda100f100c006a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd9d9a21bab789c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd9a35b77e548e8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd96d3ab9a2713a,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd9373f76be8a32,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd90169460435c0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd8cbb7bf299eb4,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fd8962a7acd0426,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fd860c112715450,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fd82b7b207ad058,
    0x0, 0x0,
    0xbfecccccccccccea, 0x3fd7f658402bc0d0,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x3fd7c1580da1341c,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fd78c7a25cfc840,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3fd757be268083c0,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd72323ae4db68a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd6eeaa5c9fe7dc,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd6ba51d1aad0b8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd68619ae6a5e16,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd65201949fc10e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd61e0926ce8740,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd5ea300839bfb0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd5b675dce12780,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd582da497e62b0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd54f5cf3823d64,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd51bfd8111f7a0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd4e8bb99049988,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd4b596e2e051b0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd4828f06d7dcd8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd44fa3adc7f448,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd41cd48134c880,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd3ea212b47817c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd3b78956cbc8a8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd3850caf2d5b40,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd352aae075a438,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd3206397495e90,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd2ee3680e63f1c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd2bc234b20a698,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd28a29a4615a1c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd258493ba34474,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd22681c0713d54,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd1f4d2e2e3d89c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd1c33c539f3c2c,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fd191bdc3d0fc58,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3fd16056e52e00b4,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fd12f0769f06b14,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd0fdcf04d58c2c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd0ccad691bd758,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd09ba24a80e108,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd06aad5d3f61c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd039ce560d3f54,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd00904ea199c10,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcfb0a19e15d6e8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fcf4f6375fa1a40,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fceee4ec8fed910,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fce8d6305264d98,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fce2c9f99526b00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcdcc03f5413de0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcd6b8f89895680,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fcd0b41c7963db0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fccab1a21a4f460,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcc4b180ac07930,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fcbeb3af6be5de8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcb8b825a3b5fa0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcb2bedaa980c58,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcacc7c5df57020,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fca6d2deb31cb10,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fca0e01c9e54fd0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fc9aef7725eeab0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc9500e5da11160,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc8f146055e9a00,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc8929de3f79ad0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc8341574765140,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc7d5ac328c10f0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc777619a8e3a20,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc7193529733730,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc6bb265ccf8080,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc65d34b2d2ab00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc5ff5faa447720,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc5a1a6c281ed60,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc544097b7a7ca0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fc4e68755ad2100,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc4891fd22590c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc42bd272796f20,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc3ce9eb8c584c0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc3718427aaff50,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc31482424cb540,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc2b7988c4c70d0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc25ac689c83f00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc1fe0bbf57c520,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc1a167b2099ac0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc144d9e760a900,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc0e861e55190d0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc08bff32401050,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc02fb154fc7590,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbfa6efa9821bc0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbeeea4725f3d00,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbe3680149dbfa0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fbd7e81a10ffb80,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fbcc6a8294836a0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbc0ef2bf93b5e0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbb576076f5d640,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fba9ff063232bc0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb9e8a1987ca8a0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb931732c0acd40,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fb87a643378dd00,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb7c373c5101bc0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb70ca0f7b30e40,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fb655eae2d8cb80,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fb59f509e883e00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb4e8d143538c40,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb4326bea536500,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb37c1fad226940,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb2c5eba5d88f00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb20fceef068e80,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb159c8a3b15440,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb0a3d7df4d7440,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fafdbf77b754d00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fae7066b67e8b00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fad04fba907a180,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fab99b48d1ce600,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3faa2e8f9d7d2180,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fa8c38b1590a500,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa758a531607500,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa5eddc2d8d7200,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fa4832e47478500,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa31899bc44e200,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fa1ae1ccab93900,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa043b5b14cfe00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f9db2c55e296000,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f9ade4407104400,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f9809e3dcf39400,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f9535a1601c2400,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f92617911657000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f8f1acee4587000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f8972d2087a8000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f83caf493882000,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f7c465f14e6c000,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f70f6f7e54dc000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f569e968f180000,
    0x0
    };

static const uint64_t ref_rfft_step_2048[2049] = {
    0x408ccccccccccccd, 0x0,
    0xbfeccccccccccc80, 0x408255aaa4bc2b9e,
    0x0, 0x8000000000000000,
    0xbfecccccccccccf6, 0x4068722ece0ccb9a,
    0x0, 0x0,
    0xbfeccccccccccd7d, 0x405d55b9a3679088,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x4054f3fd088b91ad,
    0x0, 0x8000000000000000,
    0xbfecccccccccccd2, 0x40504be2e24253f0,
    0x0, 0x0,
    0xbfeccccccccccc7f, 0x404aaa823eed92bd,
    0x0, 0x0,
    0xbfecccccccccccae, 0x4046900f24647fa6,
    0x0, 0x0,
    0xbfeccccccccccc69, 0x40438db2b0659cb6,
    0x0, 0x0,
    0xbfeccccccccccd2d, 0x40414092117a723e,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x403edee3ed8e2318,
    0x0, 0x0,
    0xbfecccccccccccda, 0x403bedc9071f7614,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x40397f9d2e55bfe6,
    0x0, 0x0,
    0xbfeccccccccccd08, 0x403774f3d05a1d2a,
    0x0, 0x0,
    0xbfeccccccccccc7e, 0x4035b7afee1f2425,
    0x0, 0x0,
    0xbfeccccccccccc85, 0x403437ce3009c342,
    0x0, 0x0,
    0xbfeccccccccccda3, 0x4032e96d238a4da9,
    0x0, 0x8000000000000000,
    0xbfeccccccccccbfe, 0x4031c38ca820c8e2,
    0x0, 0x0,
    0xbfeccccccccccd05, 0x4030bf3b45a19504,
    0x0, 0x0,
    0xbfeccccccccccd00, 0x402fae0faa66c360,
    0x0, 0x0,
    0xbfeccccccccccca9, 0x402e0d3dec9b87f0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x402c950ab676ab00,
    0x0, 0x0,
    0xbfecccccccccccca, 0x402b3fcb12602487,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x402a08d5fd804bff,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x4028ec4d85cd611c,
    0x0, 0x0,
    0xbfecccccccccccfc, 0x4027e6f558e6bf26,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4026f6131334f4b2,
    0x0, 0x0,
    0xbfecccccccccccda, 0x40261755bbea70f9,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x402548c29a532b96,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x402488a61421009e,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4023d5879f9729c2,
    0x0, 0x0,
    0xbfeccccccccccca2, 0x40232e2014c225b5,
    0x0, 0x0,
    0xbfeccccccccccdd9, 0x40229151d6d5bcdf,
    0x0, 0x0,
    0xbfeccccccccccbbe, 0x4021fe226fff928e,
    0x0, 0x0,
    0xbfecccccccccccea, 0x402173b55245abf2,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x4020f14781fb7ad8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x4020762bfbbe2b98,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x402001c8b20155ef,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x401f27280bc2a8ef,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x401e562549a301e1,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x401d8fab728d5088,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x401cd2f2c00bbe12,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x401c1f46ad076592,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x401b7403b1db44d4,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x401ad095506490c5,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x401a3474637b4311,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x40199f25a77413f0,
    0x0, 0x0,
    0xbfecccccccccccb5, 0x401910387315cf60,
    0x0, 0x0,
    0xbfeccccccccccd15, 0x4018874599de291c,
    0x0, 0x0,
    0xbfeccccccccccc87, 0x401803ee719fb2f2,
    0x0, 0x0,
    0xbfeccccccccccce8, 0x401785dbf6794894,
    0x0, 0x0,
    0xbfecccccccccccde, 0x40170cbe08f1fcab,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x4016984ac2abdd94,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4016283ddeaa8692,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4015bc58329dbd43,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4015545f37009d76,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4014f01c9c2e7b02,
    0x0, 0x0,
    0xbfeccccccccccce8, 0x40148f5dead26e95,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x401431f42e4fb21e,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x4013d7b3a7f15674,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x4013807389d8ecf1,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x40132c0db8c6b662,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x4012da5e93f3c101,
    0x0, 0x0,
    0xbfecccccccccccea, 0x40128b44c24feade,
    0x0, 0x0,
    0xbfeccccccccccca4, 0x40123ea1048bab95,
    0x0, 0x8000000000000000,
    0xbfecccccccccccfa, 0x4011f4560b6865fe,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x4011ac4851da48f3,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4011665dfa94d838,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4011227eb0a76964,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4010e0938ad977c0,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4010a086f17feb7b,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x40106244868c7b66,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x401025b90f9f58d2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400fd5a4c3d2fb6b,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400f62fe9f66ba17,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400ef35f2ec0ea7c,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400e86a7a798e9aa,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x400e1cbadbc4a424,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x400db57d1ea1f4a0,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x400d50d42c884330,
    0x0, 0x0,
    0xbfecccccccccccf8, 0x400ceea714149627,
    0x0, 0x0,
    0xbfeccccccccccca5, 0x400c8ede2126d2c4,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x400c3162c96af8f5,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x400bd61f9a4cc198,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x400b7d0028373cf4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400b25f0ff04f1b8,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x400ad0df93878dcb,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400a7dba36108951,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400a2c7005e62d9c,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4009dcf0e5924dae,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x40098f2d6ff9a914,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x40094316ee2c7459,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4008f89f4de1dc5b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4008afb9189194a7,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400868576b1f9b7c,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4008226dee0f5f50,
    0x0, 0x0,
    0xbfeccccccccccd24, 0x4007ddf0ce345894,
    0x0, 0x0,
    0xbfeccccccccccc81, 0x40079ad4b5d6ffcd,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4007590ec645c290,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4007189491ca4e62,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4006d95c15fc1e5e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40069b5bb669d010,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x40065e8a3793415c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x400622deba2ef42d,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x4005e850b6b59fec,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4005aed7f92f3de8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x4005766c9d3d3823,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40053f070a5db5b2,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4005089ff0644d0d,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x4004d3304424a9ee,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x40049eb13c4bf58b,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x40046b1c4e660abc,
    0x0, 0x0,
    0xbfeccccccccccce5, 0x4004386b2c0bb635,
    0x0, 0x0,
    0xbfeccccccccccca7, 0x40040697c037751a,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4003d59c2cbe51cc,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4003a572c7eaaa4c,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x400376161a36d14c,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x40034780dc25a09a,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x400319adf43733d0,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x4002ec9874f821b8,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x4002c03b9b29a6d6,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x40029492cc014e94,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x40026999937ebfea,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40023f4ba2d66a7b,
    0x0, 0x0,
    0xbfecccccccccccb3, 0x400215a4ceefe450,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x4001eca10ef6dd93,
    0x0, 0x0,
    0xbfecccccccccccba, 0x4001c43c7afda046,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x40019c734ab02438,
    0x0, 0x0,
    0xbfeccccccccccceb, 0x40017541d416cca4,
    0x0, 0x0,
    0xbfecccccccccccb0, 0x40014ea48a67f7ba,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x40012897fce78efb,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x40010318d5d3dd68,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x4000de23d95ef0d6,
    0x0, 0x0,
    0xbfecccccccccccee, 0x4000b9b5e4b3e1ea,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400095cbed075f1c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40007262feb2e766,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x40004f783c5a2592,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x40002d08de19e813,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x40000b1230c037f6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fffd3232a1a312c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fff9108fdf702dc,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fff4fd0ea245117,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fff0f761f7775ea,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffecff3f14c4ad7,
    0x0, 0x0,
    0xbfeccccccccccceb, 0x3ffe9145d4512b4e,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3ffe53675d5fc076,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffe16544061f943,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffdda084f429a89,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffd9e7f78e8d8d8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffd63b5c83e7824,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffd29a7633ff2a7,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ffcf0508a162f6a,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffcb7ad9639577e,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3ffc7fbaf99c5f04,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ffc48753de0dbde,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffc11d90392ca36,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffbdbe3016be347,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3ffba690039e2f80,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffb71dceb258271,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3ffb3dc6ad1f9136,
    0x0, 0x0,
    0xbfeccccccccccd08, 0x3ffb0a4a522a5a68,
    0x0, 0x0,
    0xbfeccccccccccc96, 0x3ffad764f5c89827,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3ffaa513c5cbf94a,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffa735401c4e2fa,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffa4222fa777c90,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffa117e1155cd0e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff9e162b7feb366,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff9b1ce6fc184a4,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff982bec9261ed8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff95431637940e3,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff92623ec5cfad6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff8f8941f5d0a70,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff8cb7fc586fc64,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff89ee4b505e9d7,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff872c0d0c1adcb,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff8471208016e29,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x3ff81bd656115703,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3ff7f10bc1eb6726,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff7c6b05de32f0d,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff79cc247546547,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff7733fa65432e4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff74a26ad651df0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff72175992d77a7,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff6f92ab03035ae,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff6d14442881eea,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff6a9c0a9a53541,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff6829e480c466c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff65bdb89188fc6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff63576e0bf6088,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff60f6ecb55a7fe,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff5e9c1cd575d60,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff5c46e7330aff8,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff59f735108eeb7,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x3ff57acf028f175e,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff556802ac7fe3f,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff5328573ddfef4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff50edd8ef22922,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff4eb8733eedae0,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff4c881215bbc37,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff4a5ca1c330f0c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff48360efb847ca,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff461446d4fe2f8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff43f736c586d3c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff41decca04b253,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff3fcaf69370a02,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff3dbba325db82a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff3bb0c13505748,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff39aa3ff2e43ea,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3ff37a80ee3e00f0,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff35aa1ddcd8bba,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff33b05d0139850,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff31babcc11ae83,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff2fc92dd771f54,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff2ddba1484ccad,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff2bf2085f1bbe8,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff2a0c54ad06c8a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff282a78074ed1c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff264c6485ba7d0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff24720c810e0db,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff229b62918e140,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff20c8598d8c80c,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff1ef8e487ffd38,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff1d2cf6cf240aa,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff1b6483eb250ba,
    0x0, 0x0,
    0xbfecccccccccccee, 0x3ff199f7f9cd231a,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x3ff17dddddc5ac8a,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff161f92d813097,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff146492f34194a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff12acd2c4f4d6c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff10f84716e0620,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff0f46e4e441cf8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff0d98a158cd038,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff0bed71cf9f95a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff0a454bd23b237,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff08a02517865ff,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff06fdf382d4a0d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff055ead22f3c60,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff03c24831403d1,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff0228bb10bf00c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff0091fc4d3d58f,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fefdfc0534ec7a4,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fefad989a67a529,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fef7bc73f15c69d,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fef4a4b262c6bb9,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fef19233915d7a8,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3feee84e65bb34a7,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3feeb7cb9e6d0d6c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fee8799d9cc58e7,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3fee57b812b414ec,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fee282548236aed,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fedf8e07d2859c1,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fedc9e8b8cae4c8,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x3fed9b3d05f8befa,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x3fed6cdc7371743d,
    0x0, 0x0,
    0xbfeccccccccccc9e, 0x3fed3ec613b307b3,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fed10f8fce709f6,
    0x0, 0x0,
    0xbfeccccccccccc9b, 0x3fece37448d01fa4,
    0x0, 0x8000000000000000,
    0xbfecccccccccccfd, 0x3fecb63714b7f3a4,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fec8940815d9b76,
    0x0, 0x0,
    0xbfecccccccccccf2, 0x3fec5c8fb2e45b33,
    0x0, 0x0,
    0xbfecccccccccccec, 0x3fec3023d0c2d83d,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x3fec03fc05b2a7fa,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3febd8177fa041e8,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3febac756f9b50a1,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3feb811509c75aad,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3feb55f5854cc7ac,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3feb2b161c4a3907,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3feb00760bc6397c,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fead61493a13cc7,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3feaabf0f687efc8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fea820a79e5d6f9,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fea586065d837ed,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fea2ef205214cf9,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fea05bea51bc114,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe9dcc595ae70be,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe9b4062940710f,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe98b7fb4ad574a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe963318f39c2bf,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe93b1b1288255a,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe9133b9a8dc9d6,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe8eb928588164e,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe8c41f33f2090d,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe89ce10879eec1,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe875d767f75061,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe84f01b9611761,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe8285f65c3e6c9,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe801efd838a83d,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fe7dbb27ddb4b4e,
    0x0, 0x0,
    0xbfecccccccccccea, 0x3fe7b5a6c5c1b5e4,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x3fe78fcc20f2e56b,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe76a22025e3ce3,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe744a7ded303b8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe71f5d2cf80e69,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6fa41654393ff,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6d55401f32e1c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe6b0947f04022a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe68c025a2b1320,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe6679d12cdbae9,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe6436429fa4a81,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe61f572260cf60,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe5fb75804bfe62,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe5d7bec99a41e3,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe5b43285b6eba6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe590d03d9388a5,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe56d977ba15683,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe54a87cbcad9fb,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe527a0bb6d9488,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe504e1d953daa3,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe4e24ab5aec715,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe4bfdae2104d38,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe49d91f16567de,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe47b6f77f064f0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe459730b434cc5,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe4379c423a64e3,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe415eab4f6cd48,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe3f45dfcd937ba,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe3d2f5b47cb8a5,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe3b1b177b1b0b2,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe39090e378cee9,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe36f9395fe2a8a,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe34eb92e947426,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe32e014db03d40,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe30d6b94e35724,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe2ecf7a6d84601,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe2cca5274dcacd,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe2ac73bb128109,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe28c6308009169,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe26c72b4f97831,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe24ca269e1df32,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe22cf1cf9d8aeb,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe20d60900b5a5e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe1edee560158f6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe1ce9acd48e2c4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe1af65a29ad9d1,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe1904e839bed02,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe171551ed8ef5e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe1527923c34010,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe133ba42ad42c2,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe115182cc6e696,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe0f692941a3e6e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe0d8292b88266e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe0b9dba6c4f977,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe09ba9ba5554d0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe07d931b8ae9d0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe05f9780815dba,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe041b6a01b36fd,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe023f031fed7e8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe00643ee938660,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdfd1631dfd00da,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdf96719a403aa2,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdf5bb2c721f580,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdf21261b3e6cf2,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fdee6cb0e97660c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fdeaca11a8ed2f0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fde72a7b9e186e2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fde38de68a2099c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fddff44a4337748,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fddc5d9eb447bd4,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdd8c9dbdca6058,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdd538f9cfc2e18,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fdd1aaf0b4de530,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdce1fb8c6bc69a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdca974a535b288,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdc7119dbba980c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdc38eab733f90a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdc00e6c0017ed0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdbc90d7fa4a16c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdb915e80bc6014,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fdb59d94f010ac2,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdb227d77401cf2,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdaeb4a87582744,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fdab4400e34cc68,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fda7d5d9bcaca44,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fda46a2c11414f0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fda100f100c006a,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd9d9a21bab789c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd9a35b77e548e8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd96d3ab9a2713a,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd9373f76be8a32,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd90169460435c0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd8cbb7bf299eb4,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fd8962a7acd0426,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fd860c112715450,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fd82b7b207ad058,
    0x0, 0x0,
    0xbfecccccccccccea, 0x3fd7f658402bc0d0,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x3fd7c1580da1341c,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fd78c7a25cfc840,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3fd757be268083c0,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd72323ae4db68a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd6eeaa5c9fe7dc,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd6ba51d1aad0b8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd68619ae6a5e16,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd65201949fc10e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd61e0926ce8740,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd5ea300839bfb0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd5b675dce12780,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd582da497e62b0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd54f5cf3823d64,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd51bfd8111f7a0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd4e8bb99049988,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd4b596e2e051b0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd4828f06d7dcd8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd44fa3adc7f448,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd41cd48134c880,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd3ea212b47817c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd3b78956cbc8a8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd3850caf2d5b40,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd352aae075a438,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd3206397495e90,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd2ee3680e63f1c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd2bc234b20a698,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd28a29a4615a1c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd258493ba34474,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd22681c0713d54,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd1f4d2e2e3d89c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd1c33c539f3c2c,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fd191bdc3d0fc58,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3fd16056e52e00b4,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fd12f0769f06b14,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd0fdcf04d58c2c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd0ccad691bd758,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd09ba24a80e108,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd06aad5d3f61c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd039ce560d3f54,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd00904ea199c10,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcfb0a19e15d6e8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fcf4f6375fa1a40,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fceee4ec8fed910,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fce8d6305264d98,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fce2c9f99526b00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcdcc03f5413de0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcd6b8f89895680,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fcd0b41c7963db0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fccab1a21a4f460,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcc4b180ac07930,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fcbeb3af6be5de8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcb8b825a3b5fa0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcb2bedaa980c58,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcacc7c5df57020,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fca6d2deb31cb10,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fca0e01c9e54fd0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fc9aef7725eeab0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc9500e5da11160,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc8f146055e9a00,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc8929de3f79ad0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc8341574765140,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc7d5ac328c10f0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc777619a8e3a20,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc7193529733730,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc6bb265ccf8080,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc65d34b2d2ab00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc5ff5faa447720,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc5a1a6c281ed60,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc544097b7a7ca0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fc4e68755ad2100,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc4891fd22590c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc42bd272796f20,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc3ce9eb8c584c0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc3718427aaff50,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc31482424cb540,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc2b7988c4c70d0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc25ac689c83f00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc1fe0bbf57c520,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc1a167b2099ac0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc144d9e760a900,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc0e861e55190d0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc08bff32401050,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc02fb154fc7590,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbfa6efa9821bc0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbeeea4725f3d00,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbe3680149dbfa0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fbd7e81a10ffb80,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fbcc6a8294836a0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbc0ef2bf93b5e0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbb576076f5d640,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fba9ff063232bc0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb9e8a1987ca8a0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb931732c0acd40,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fb87a643378dd00,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb7c373c5101bc0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb70ca0f7b30e40,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fb655eae2d8cb80,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fb59f509e883e00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb4e8d143538c40,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb4326bea536500,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb37c1fad226940,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb2c5eba5d88f00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb20fceef068e80,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb159c8a3b15440,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb0a3d7df4d7440,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fafdbf77b754d00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fae7066b67e8b00,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fad04fba907a180,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fab99b48d1ce600,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3faa2e8f9d7d2180,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fa8c38b1590a500,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa758a531607500,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa5eddc2d8d7200,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fa4832e47478500,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa31899bc44e200,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fa1ae1ccab93900,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa043b5b14cfe00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f9db2c55e296000,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f9ade4407104400,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f9809e3dcf39400,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f9535a1601c2400,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f92617911657000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f8f1acee4587000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f8972d2087a8000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f83caf493882000,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f7c465f14e6c000,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f70f6f7e54dc000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f569e968f180000,
    0x0
    };

static const uint64_t in_rfft_step_4096[4096] = {
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x0, 0x0,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd,
    0x3feccccccccccccd, 0x3feccccccccccccd
    };

static const uint64_t in_rifft_step_4096[4097] = {
    0x409ccccccccccccd, 0x0,
    0xbfeccccccccccc94, 0x409255ab59b0d91d,
    0x0, 0x8000000000000000,
    0xbfeccccccccccd1b, 0x407872374985cccb,
    0x0, 0x0,
    0xbfecccccccccce16, 0x406d55d5e9ab64d2,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4064f4249e29f05c,
    0x0, 0x8000000000000000,
    0xbfecccccccccccec, 0x40604c15c7477295,
    0x0, 0x0,
    0xbfeccccccccccc70, 0x405aaafea7e4b54b,
    0x0, 0x0,
    0xbfeccccccccccc89, 0x405690a22c6ee734,
    0x0, 0x0,
    0xbfeccccccccccc22, 0x40538e5c57b0a394,
    0x0, 0x0,
    0xbfeccccccccccd71, 0x40514152583a6d84,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x404ee091ba6ea2bb,
    0x0, 0x0,
    0xbfecccccccccccda, 0x404befa413e515be,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x404981a57b930dd0,
    0x0, 0x0,
    0xbfeccccccccccd56, 0x404777295eaf9f8f,
    0x0, 0x0,
    0xbfeccccccccccbe5, 0x4045ba12be3b5a06,
    0x0, 0x0,
    0xbfeccccccccccc3f, 0x40443a5e42a9253e,
    0x0, 0x0,
    0xbfecccccccccce5c, 0x4042ec2a79774ee3,
    0x0, 0x8000000000000000,
    0xbfeccccccccccb37, 0x4041c6774233d803,
    0x0, 0x0,
    0xbfeccccccccccd45, 0x4040c25324c11d3b,
    0x0, 0x0,
    0xbfeccccccccccd78, 0x403fb499f4a797b0,
    0x0, 0x0,
    0xbfeccccccccccc82, 0x403e1422c4e2ef82,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x403c9c4a1ee5755a,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x403b47650d332402,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x403a10ca8d105880,
    0x0, 0x0,
    0xbfeccccccccccca4, 0x4038f49cac8f5afc,
    0x0, 0x0,
    0xbfeccccccccccd10, 0x4037ef9f196b9240,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x4036ff1770299b8a,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x403620b4b817f80e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4035527c389eb4d3,
    0x0, 0x0,
    0xbfecccccccccccae, 0x403492ba578bc6ec,
    0x0, 0x0,
    0xbfecccccccccccf6, 0x4033dff68b3e84c5,
    0x0, 0x0,
    0xbfeccccccccccc80, 0x403338e9abdf8da2,
    0x0, 0x0,
    0xbfeccccccccccefc, 0x40329c761cbece79,
    0x0, 0x0,
    0xbfeccccccccccacc, 0x403209a16826134a,
    0x0, 0x0,
    0xbfecccccccccccf8, 0x40317f8f00378e3b,
    0x0, 0x0,
    0xbfecccccccccccb0, 0x4030fd7be962e271,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x403082bb20617229,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x40300eb297c30fb2,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x402f41b16180aa16,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x402e716431d1c090,
    0x0, 0x0,
    0xbfeccccccccccc92, 0x402dab9ff59b8f80,
    0x0, 0x0,
    0xbfeccccccccccced, 0x402cef9ce6a0dd67,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x402c3ca680036d63,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x402b92193a56f04f,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x402aef6097b15975,
    0x0, 0x0,
    0xbfecccccccccccec, 0x402a53f573236c6a,
    0x0, 0x0,
    0xbfeccccccccccc90, 0x4029bf5c893ab72d,
    0x0, 0x0,
    0xbfeccccccccccc9a, 0x4029312530f6e79f,
    0x0, 0x0,
    0xbfeccccccccccd61, 0x4028a8e83e0e9fd0,
    0x0, 0x0,
    0xbfeccccccccccc2a, 0x40282647068d6c86,
    0x0, 0x0,
    0xbfeccccccccccd03, 0x4027a8ea86cb316f,
    0x0, 0x0,
    0xbfeccccccccccce8, 0x402730829f88166c,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x4026bcc56a9f4c91,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x40264d6ea34d9fbb,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x4025e23f1f7c142c,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x40257afc57df12c5,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4025176ffd0b4b0e,
    0x0, 0x0,
    0xbfeccccccccccd01, 0x4024b76797e54061,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x40245ab43409a693,
    0x0, 0x0,
    0xbfeccccccccccceb, 0x4024012a12fd17e9,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4023aaa0671abef8,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x402356f1155c85e4,
    0x0, 0x0,
    0xbfeccccccccccc9b, 0x402305f87d3534a0,
    0x0, 0x0,
    0xbfeccccccccccd07, 0x4022b79545ce73a0,
    0x0, 0x0,
    0xbfeccccccccccc7e, 0x40226ba8301295d8,
    0x0, 0x8000000000000000,
    0xbfeccccccccccd1e, 0x40222213ecfceac2,
    0x0, 0x0,
    0xbfeccccccccccc9c, 0x4021dabcf7bb9f5c,
    0x0, 0x0,
    0xbfeccccccccccd01, 0x40219589733c4769,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x402152610ac85aa1,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4021112cd56188d9,
    0x0, 0x0,
    0xbfecccccccccccb9, 0x4020d1d73b97017e,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x4020944bdf94d5a7,
    0x0, 0x0,
    0xbfecccccccccccad, 0x402058778735a438,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40201e4807e4e856,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x401fcb58684b5418,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x401f5d27952c2210,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x401ef1decc991335,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x401e8960e0ddb91c,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x401e239225cdbdca,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x401dc0585836836b,
    0x0, 0x0,
    0xbfeccccccccccd2a, 0x401d5f9a872b35d0,
    0x0, 0x0,
    0xbfeccccccccccc7a, 0x401d0140ff020ba7,
    0x0, 0x0,
    0xbfeccccccccccced, 0x401ca53535dd8307,
    0x0, 0x0,
    0xbfecccccccccccf8, 0x401c4b61b9a00010,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x401bf3b21f2b6c30,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x401b9e12f2d155ac,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x401b4a71a9daa106,
    0x0, 0x0,
    0xbfecccccccccccce, 0x401af8bc95102cb4,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x401aa8e2d42fd8a0,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x401a5ad44a3b3f4f,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x401a0e81928f195b,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4019c3dbf6b3c681,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x40197ad564d8d19c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4019336066ee7fa6,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4018ed701a519452,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4018a8f827fe7838,
    0x0, 0x0,
    0xbfeccccccccccd82, 0x401865ecbd41d346,
    0x0, 0x0,
    0xbfeccccccccccc27, 0x4018244284dd835a,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4017e3eea0999226,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4017a4e6a339805a,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x401767208aced43a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40172a92bb626efb,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x4016ef33f9eeab5c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4016b4fb67a4c1f2,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x40167be07d785b4e,
    0x0, 0x0,
    0xbfecccccccccccda, 0x401643db07ec9d10,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40160ce3231e5952,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4015d6f137075bbe,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4015a1fdf3f71c7e,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x40156e024f3d66ca,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x40153af78003c1cd,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x401508d6fc52a577,
    0x0, 0x0,
    0xbfecccccccccccff, 0x4014d79a763fbb67,
    0x0, 0x0,
    0xbfeccccccccccc96, 0x4014a73bd9429e22,
    0x0, 0x0,
    0xbfecccccccccccea, 0x401477b547adb6a3,
    0x0, 0x0,
    0xbfecccccccccccf2, 0x401449011849034c,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x40141b19d40cb9c8,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x4013edfa33f9da15,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x4013c19d1f0ee9e6,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x401395fda8572ebe,
    0x0, 0x0,
    0xbfeccccccccccca6, 0x40136b170d12d924,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x401340e4b2f6ae90,
    0x0, 0x0,
    0xbfecccccccccccca, 0x401317622681d6b6,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4012ee8b19688965,
    0x0, 0x0,
    0xbfeccccccccccc9b, 0x4012c65b61126cf2,
    0x0, 0x0,
    0xbfecccccccccccf8, 0x40129ecef52b8ab2,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x401277e1ee46cf50,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x4012519084911f9d,
    0x0, 0x0,
    0xbfeccccccccccd21, 0x40122bd70e9416ca,
    0x0, 0x0,
    0xbfeccccccccccc7c, 0x401206b2000796b2,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x4011e21de8b1590a,
    0x0, 0x0,
    0xbfeccccccccccced, 0x4011be177351c61c,
    0x0, 0x0,
    0xbfeccccccccccca3, 0x40119a9b649d5701,
    0x0, 0x0,
    0xbfeccccccccccd02, 0x401177a69a41de4a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x4011553609f713b7,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x40113346c099cfb9,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x401111d5e151676f,
    0x0, 0x0,
    0xbfecccccccccccf0, 0x4010f0e0a4bea54d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4010d0645833e0bc,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4010b05e5cf5beac,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x401090cc27842c0d,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x401071ab3eeb2918,
    0x0, 0x0,
    0xbfecccccccccccae, 0x401052f93c1b026b,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x401034b3c9479aaf,
    0x0, 0x0,
    0xbfecccccccccccf6, 0x401016d8a14e6c74,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x400ff2cb1e45e1e2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400fb8b0da8239dc,
    0x0, 0x0,
    0xbfecccccccccccda, 0x400f7f5e4a4b52cf,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x400f46cf5d97c2da,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400f0f0020616572,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x400ed7ecb9b583ce,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x400ea1916ace8d19,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400e6bea8e36ed46,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x400e36f496f497c3,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x400e02ac0fbcdfb3,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400dcf0d9a303e3c,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400d9c15ee1daad0,
    0x0, 0x0,
    0xbfecccccccccccba, 0x400d69c1d8cd2f2c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400d380e3c5164c0,
    0x0, 0x0,
    0xbfecccccccccccba, 0x400d06f80edf8cd3,
    0x0, 0x0,
    0xbfeccccccccccd3e, 0x400cd67c5a2dfa52,
    0x0, 0x0,
    0xbfeccccccccccc5a, 0x400ca6983ad88527,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x400c7748dfcac5b6,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x400c488b89afd781,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400c1a5d8a676749,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400becbc447fd1fa,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400bbfa52ab51ed7,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400b9315bf749f3a,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x400b670b9465036c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400b3b8449f2b42a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400b107d8ee044b9,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x400ae5f51fdad144,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400abbe8c71221ee,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x400a92565bd46a13,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x400a693bc22d7f90,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x400a4096ea8965a3,
    0x0, 0x0,
    0xbfecccccccccccf6, 0x400a1865d15a09fd,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x4009f0a67ec01333,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x4009c9570636a190,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x4009a2758641e555,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x40097c0028206d06,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x400955f51f7f11e7,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40093052aa2f67e6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x40090b170fe098f3,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x4008e640a1da9398,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x4008c1cdbabb76cc,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x40089dbcbe3724a9,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40087a0c18d8e834,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400856ba3fc7199c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x400833c5b088ae52,
    0x0, 0x0,
    0xbfecccccccccccb5, 0x4008112cf0cca310,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4007eeee8e332dc1,
    0x0, 0x0,
    0xbfecccccccccccae, 0x4007cd091e18a75a,
    0x0, 0x0,
    0xbfeccccccccccce9, 0x4007ab7b3d621cf3,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x40078a43904b7982,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x40076960c23738bb,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400748d1857f95f1,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4007289493492862,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x400708a8ab56e0f4,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4006e90c93df5c46,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x4006c9bf19637d5a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x4006aabf0e864564,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x40068c0b4be5dde6,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x40066da2aff5c9e0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x40064f841eda34ea,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400631ae8244556e,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x40061420c94fd96a,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4005f6d9e8615417,
    0x0, 0x0,
    0xbfecccccccccccf3, 0x4005d9d8d905a46b,
    0x0, 0x0,
    0xbfecccccccccccae, 0x4005bd1c99d24b78,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x4005a0a42e46aaf5,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x4005846e9eae247c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4005687af8031166,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40054cc84bd28cac,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40053155b02107e0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x400516223f4fa431,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x4004fb2d18024994,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x4004e0755d0675d4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4004c5fa353abd4e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4004abbacb76f817,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400491b64e7515b6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x400477ebf0ba9257,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x40045e5ae8828852,
    0x0, 0x0,
    0xbfecccccccccccda, 0x400445026fa85925,
    0x0, 0x0,
    0xbfeccccccccccd0b, 0x40042be1c392e8d7,
    0x0, 0x0,
    0xbfeccccccccccc8d, 0x400412f82520680a,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x4003fa44d892a69a,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x4003e1c7257bed4a,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x4003c97e56ac5706,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x4003b169ba1fa8d8,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x40039988a0eba29a,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400381da5f2ec5e2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40036a5e4bff8f03,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x40035313c15c1cf7,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x40033bfa1c1a44f5,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x40032510bbd80dde,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40030e5702ec917a,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4002f7cc56593f69,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x4002e1701dbb7fb7,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4002cb41c33eb1b8,
    0x0, 0x0,
    0xbfeccccccccccced, 0x4002b540b38e84e6,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x40029f6c5dc9a8ec,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x400289c43374d20d,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x40027447a86e105b,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x40025ef632e07630,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x400249cf4b380c96,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400234d26c161315,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x40021fff12458868,
    0x0, 0x0,
    0xbfecccccccccccef, 0x40020b54bcaffaa3,
    0x0, 0x0,
    0xbfecccccccccccae, 0x4001f6d2ec529c8c,
    0x0, 0x0,
    0xbfeccccccccccce9, 0x4001e27924339da4,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x4001ce46e957c469,
    0x0, 0x0,
    0xbfeccccccccccd06, 0x4001ba3bc2b84726,
    0x0, 0x0,
    0xbfeccccccccccc7a, 0x4001a6573938e355,
    0x0, 0x0,
    0xbfecccccccccccfe, 0x40019298d79e302e,
    0x0, 0x0,
    0xbfecccccccccccf1, 0x40017f002a842cd9,
    0x0, 0x0,
    0xbfeccccccccccc57, 0x40016b8cc05505fe,
    0x0, 0x8000000000000000,
    0xbfeccccccccccd43, 0x4001583e29401360,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x40014513f7310bc5,
    0x0, 0x0,
    0xbfeccccccccccc92, 0x4001320dbdc76b6b,
    0x0, 0x0,
    0xbfeccccccccccd1d, 0x40011f2b124e0f3e,
    0x0, 0x0,
    0xbfeccccccccccc95, 0x40010c6b8bb3009e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4000f9cec27f7104,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x4000e75450cfe5ab,
    0x0, 0x0,
    0xbfeccccccccccced, 0x4000d4fbd24c8fa9,
    0x0, 0x0,
    0xbfeccccccccccca4, 0x4000c2c4e421d16c,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4000b0af24f8eed1,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x40009eba34f0e7cc,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x40008ce5b5977bfe,
    0x0, 0x0,
    0xbfecccccccccccea, 0x40007b3149e2560a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4000699c96285e37,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x40005827401b32a3,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x400046d0eec0c4ab,
    0x0, 0x0,
    0xbfecccccccccccad, 0x400035994a6d1a26,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4000247ffcbc31be,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x40001384b08c0994,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x400002a711f6c6f7,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fffe3cd9c99fd8e,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fffc28728203adc,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fffa17a25d9db42,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fff80a5f76c7aa4,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fff600a00bf3fcc,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fff3fa5a7f099ea,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fff1f78554c3631,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffeff8173412b8e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffedfc06e585b79,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3ffec034b52b06c5,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3ffea0ddb8599494,
    0x0, 0x0,
    0xbfeccccccccccd08, 0x3ffe81baea828adf,
    0x0, 0x0,
    0xbfeccccccccccc94, 0x3ffe62cbc039b707,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffe440fafff84e2,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffe25863238844d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ffe072ec1251af1,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffde908d8d96174,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffdcb13f7352be0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffdad4f9bdc3b10,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffd8fbb482e96d9,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffd72567f410fda,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffd5520c5d5e818,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffd3819a255a0fc,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffd1b409cc7eece,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ffcfe953ecccf9e,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffce2171395c5c9,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffcc5c5a7df34b4,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x3ffca9a089e9df3a,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x3ffc8da7497486dc,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffc71d977b5aac0,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ffc5636a75566bb,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ffc3abe6c67701b,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffc1f705c653109,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffc044c0e2800ce,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffbe95119e378e2,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffbce7f191fe5b0,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ffbb3d5a6b4d314,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffb99545ec3b30c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffb7efadeb29efe,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ffb64c8c527323f,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffb4abdb2017da0,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ffb30d946571382,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ffb171b246e2baf,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3ffafd82efb8deae,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3ffae4104cd077aa,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffacac2e170dd44,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3ffab19a54740f76,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffa98964dcdbbc0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffa7fb67686e56c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffa66fa78b9a2fc,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffa4e61ff8cef3c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffa35ecb7308e09,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ffa1d9a4cd90460,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffa056a6ebba341,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff9ed5ccc0aa4a2,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff9d57114f15ae2,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff9bda6fa907170,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff9a5fe2efa3f00,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff98e76652f284b,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x3ff9770f511a13d4,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x3ff95fc8a78ced94,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff948a21e3d3a3d,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3ff9319b6bc0bad0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff91ab4478a1e8a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff903ec69e5c44a,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff8ed438bf68a61,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff8d6b967b2aca0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff8c04db7e0b07a,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff8aa0038145ee9,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff893d0a4abcb99,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff87dbebacc697e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff867ca38602c12,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff851f2dc12b572,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff83c38654e909b,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff8269a943a783f,
    0x0, 0x0,
    0xbfecccccccccccf6, 0x3ff8111929b6a8b7,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x3ff7fbb3e75a3f0a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff7e66a8f70a104,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff7d13ce4f6f3be,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff7bc2aab9999df,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff7a733a7b1bf13,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff792579e42eca6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff77d9654f8a92b,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff768ef9224221c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff754631cb9df38,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff73ff0bc4f802a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff72b983919830c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff717595be9151e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff70333ee29ebe3,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff6ef27b9e027fe,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff6db3489a64064,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3ff6c75a28aaf69a,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3ff6b39862af5350,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff69fef0404ab2b,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff68c5dd98aac64,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff678e4b0ad73b4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff665835763a991,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff652399c2ca73f,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff63f074e0ea31e,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3ff62bec3c94e4e4,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff618e837ce00c0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff605fb104a1a16,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff5f32497192cd0,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff5e0649dc95e2c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff5cdbaf66553a6,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ff5bb27737291b6,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3ff5a8a9e7efdf41,
    0x0, 0x0,
    0xbfecccccccccccfe, 0x3ff596422753b1bc,
    0x0, 0x0,
    0xbfeccccccccccc99, 0x3ff583f0058a9d96,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3ff571b356f5ce61,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3ff55f8bf06983d6,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff54d79a72b9618,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff53b7c50f1fe46,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff52993c3e166c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff517bfd68bbf1e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff506005feed73c,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff4f4553772fec4,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff4e2be34e9aae9,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff4d13b308c206d,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff4bfcc02fa23d0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff4ae708538add3,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff49d2890b0a590,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff48bf3ff2d9eed,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff47ad2aadc9e62,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3ff469c46e4ae14a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff458c92464aa83,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff447e0a8741464,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff4370ad61fe67e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff42647896a7013,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff415969eb06700,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff404f7f2a7caa9,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff3f46b625ecb43,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3ff3e3f0cb3ab53f,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff3d3880af6e0a2,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff3c330ffa3a472,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff3b2eb87a54e24,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff3a2b781b31c91,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff39294ccd63f15,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff382834868d82e,
    0x0, 0x0,
    0xbfecccccccccccf5, 0x3ff37282d41503ca,
    0x0, 0x0,
    0xbfeccccccccccca3, 0x3ff362934fd3e15a,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3ff352b49beca0d6,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff342e698f3944c,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ff3332927c943d7,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff3237c29998550,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff313df7fda978a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff304530c4c406a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff2f4d6b0f6ee7c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff2e56a502add68,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff2d60dcc7f3ddd,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff2c6c108d16023,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff2b783e843e1ef,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff2a8564e3ddefd,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff299381e6a24c0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff28a293cb668a8,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3ff27b298d52817c,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3ff26c38f4afa363,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff25d57577f9e3b,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff24e849ab41f7c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff23fc0a37df5c1,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff2310b574c579a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff222649bcc2c89,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff213cc56e758b6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff205426ec40aef,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff1f6c6c9c40d30,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff1e8594e84177c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff1d9f9e3db2526,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff1cba870d9cc4d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff1bd64dcc997a0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff1af2f0f2c6290,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff1a106efbbb758,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff192ec66682fa2,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3ff184df5b58d6cd,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff176dfb6ea8ef6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff168ed61af7732,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff15b08446e54c8,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff14d304821fd90,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3ff13f6555f8c4e8,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff131a75753ea5c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff123f635c70a1a,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff11651db178f80,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff108ba313c2981,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff0fb2f225c4098,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff0edb098cf6ef0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff0e03e7f1cfa05,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff0d2d8bffb4e0e,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff0c57f464f7b3d,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3ff0b831fd2cb494,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3ff0aaf0cfd3d09c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff09dbba9b2cb1b,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff090927664498c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff0837521af1ff1,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff076639785d80e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff0695dc40639e0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff05c639378d5a6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff04f74f2508f53,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff04291cd2a2baa,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff035ba10cbdeaf,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff028edaa24db80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff01c2c864ce5a7,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff00f769283e3d6,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff002cbbc3173f1,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fefec57e1c90123,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fefd32e3ca5aef8,
    0x0, 0x0,
    0xbfecccccccccccb9, 0x3fefba1a64b184cf,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fefa11c35f13e36,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fef88338cb4f73e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fef6f604597619e,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fef56a23d7d0092,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fef3df9519364cb,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fef25655f506bca,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fef0ce644718184,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3feef47bdefae3cb,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3feedc260d36e8e5,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3feec3e4adb5478b,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feeabb79f4a61f6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fee939ec10e9220,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fee7b99f25d7980,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fee63a912d55190,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fee4bcc02563f7a,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3fee3402a101a962,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fee1c4ccf398d6c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fee04aa6d9fdbfc,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3feded1b5d15d246,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fedd59f7ebb5846,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3fedbe36b3ee5ff0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3feda6e0de4a467c,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fed8f9ddfa73768,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fed786d9a199185,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fed614feff14e2f,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fed4a44c3b9698f,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fed334bf8374d10,
    0x0, 0x0,
    0xbfeccccccccccd0d, 0x3fed1c65706a3bd6,
    0x0, 0x0,
    0xbfeccccccccccc8c, 0x3fed05910f8ac080,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3feceeceb90a1cff,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fecd81e5091ba6a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fecc17fba02a26a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fecaaf2d974e5ff,
    0x0, 0x0,
    0xbfeccccccccccd0c, 0x3fec947793372580,
    0x0, 0x0,
    0xbfeccccccccccc8d, 0x3fec7e0dcbcdfad6,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fec67b567f37910,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fec516e4c96a60f,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fec3b385edaf72f,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fec25138417cf45,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fec0effa1d7fe28,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3febf8fc9dd9423c,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3febe30a5e0bc9f0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3febcd28c891b886,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3febb757c3beab26,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feba19736173fbc,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3feb8be706509ccc,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3feb76471b4ffb22,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3feb60b75c2a30da,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3feb4b37b0233cf0,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3feb35c7feadd550,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feb20682f6af560,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feb0b182a296dc6,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3feaf5d7d6e5762b,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3feae0a71dc83f35,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3feacb85e72786bb,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3feab6741b852c74,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3feaa171a38ec82a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fea8c7e681d410b,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fea779a52346642,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fea62c54b02885e,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fea4dff3be0142e,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fea39480e4f2eb6,
    0x0, 0x0,
    0xbfeccccccccccce9, 0x3fea249fabfb51ef,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3fea1005feb8eb68,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3fe9fb7af084fa33,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fe9e6fe6b84b0a2,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe9d2905a05145d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe9be30a67aa126,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe9a9df3b80ec10,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe9959c03da47ce,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe98166ea6f69e4,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe96d3fda4f10fe,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe95926beadac6c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe9451b82e503d8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe9311e1273e0dd,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe91d2e58fdb8f2,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe9094c424a5857,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe8f577ba458e16,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fe8e1b0acfed8cf,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fe8cdf706a914a9,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe8ba4ab39a291a,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe8a6aba04ab98c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe89319b955d482,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe87f94eb78a577,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe86c1d23922688,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe858b24ea2d35a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe8455459cc5ca1,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fe8320332515ca3,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe81ebec5950c50,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe80b87011af950,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe7f85bd286bcd0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe7e53d279bb2df,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe7d22aee3cb2e4,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe7bf25146bc86d,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe7ac2b8849ed5a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe7993e3816c3ac,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe7865d123051a0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe773880512bc97,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe760beff5806a8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe74e01efb7cb32,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe73b50c506fd4d,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe728ab6e37a648,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe71611da58a507,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe70383f8956df6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6f101b835cbe5,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe6de8b089da102,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe6cc1fd94ca905,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6b9c019de3bba,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe6a76bba091007,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe69522a99effde,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fe682e4d88ccc96,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe670b236d9e421,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe65e8ab4a8260d,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe64c6e4233aa88,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe63a5ccfd28876,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe628564df49d12,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe6165aad2353be,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe60469de016e9a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe5f283d14acf58,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe5e0a877d440e4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe5ced7c28b4181,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe5bd11a275cd51,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe5ab5608b22999,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe599a4e676b056,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe587fe2d119c6b,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe57661cde8d697,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fe564cfba79c204,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fe55347e4590b3c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe541ca3d327434,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe53056b6c8a58e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe51eed42f4fbca,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe50d8dd3a757d8,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe4fc385ae5eecb,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe4eaeccacd1aab,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe4d9ab158f2b5a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe4c8732d7437fa,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe4b74504d9f11a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe4a6208e3372c5,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe49505bc09177e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe483f480f84b7b,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe472eccfb36048,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe461ee9b0160c2,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe450f9d5bde5bb,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe4400e72d8eb0c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe42f2c6556a456,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fe41e53a04f537d,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe40d8416ef1e42,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe3fcbdbc75e4ec,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe3ec008437195a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe3db4c61999622,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fe3caa148177649,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fe3b9ff2b3ded6c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe3a965fead2021,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe398d5b617fcc7,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fe3884e454414b3,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fe377cfa00975ac,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3fe36759ba5283f3,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe356ec881bd47e,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe34687fd74070f,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fe3362c0e7ba2a8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe325d8af64ee2a,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fe3158dd473cf1f,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3fe3054b71fda328,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3fe2f5117c691da8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe2e4dfe82e23e0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe2d4b6a9d5a9f5,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe2c495b5f99049,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe2b47d014480e1,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe2a46c8071cda5,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe29464284d4e16,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe28463edb33e2e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe2746bc5901d1d,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe2647ba4e08c63,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe2549380b12f12,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fe244b34e1e89b7,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe234db0254e271,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe2250a929020b4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe21541f41bae8f,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe205811c5258fa,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe1f5c8009e312d,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe1e61696786e10,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe1d66cd3694dcd,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe1c6caad07f7d0,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe1b73018fa5f04,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe1a79d0cf5243e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe198117ebb78ef,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe1888d641f0256,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe17910b2ffbc7a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe1699b614bdde0,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fe15a2d64ffbb2b,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x3fe14ac6b425ab24,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x3fe13b6744d5eb66,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe12c0f0d36838a,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe11cbe037b2bba,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe10d741de53043,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe0fe3152c35747,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe0eef59871c63c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe0dfc0e559e762,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe0d0932ff24fda,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe0c16c6ebea580,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe0b24c984f85a0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe0a333a3426b1e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe09421864195a5,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe085163803f037,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe07611af4cf8c8,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe06713e2eca74a,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe0581cc9bf55a8,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe0492c5aada788,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe03a428cac71da,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe02b5f56bca3f1,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe01c82afeb2f3f,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe00dac8f50f043,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdffdb9d8252ea8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdfe0277ac1238c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdfc2a1f4ede5d2,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdfa529353abb5c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdf87bd2a4ddc2a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdf6a5dc2e44650,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdf4d0aedd19190,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdf2fc499ffc3d0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdf128ab66f25f6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fdef55d32361880,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fded83bfc80e9b6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdebb270491aa2a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fde9e1e39c00494,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fde81218b791246,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fde6430e93f33be,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fde474c42a9e664,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fde2a7387659d10,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fde0da6a733970e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fddf0e591e9b8c2,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fddd430377263ae,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fddb78687cc4fc8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdd9ae8730a63c8,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdd7e55e9538f4c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdd61cedae2a414,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdd45533806306c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdd28e2f12058e0,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fdd0c7df6a6b37e,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdcf024392222ea,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdcd3d5a92eb040,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdcb792377b687c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdc9b59d4ca36ea,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdc7f2c71efc1b6,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdc6309ffd3466a,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdc46f26f6e765e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdc2ae5b1cd53c6,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdc0ee3b80e0edc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdbf2ec7360e398,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdbd6ffd507f70e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdbbb1dce5735da,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fdb9f4650b43224,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdb83794d96025c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdb67b6b6851ffe,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdb4bfe7d1b468c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fdb3050930353f4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdb14ace9f92512,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdaf91373c97a2c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdadd842251d2cc,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdac1fee78050aa,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdaa683b553973c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fda8b127ddaaca6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fda6fab3334db02,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fda544dc7919152,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fda38fa2d3045a8,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fda1db0566055fe,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fda02703580eb3e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd9e739bd00da88,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd9cc0cdf5e8870,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd9b0e98f27cafc,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd995cfbef9ccec,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd97abf6180f158,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd95fb86978b566,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd944bac9ab95da,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd929c674f2f164,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd90edb5e36ecd2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd8f3f9786e585e,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd8d920b69e924a,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd8be510bdb6cb2,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd8a38a6b471296,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd888ccc811eada,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd86e18157a8080,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fd8536c46cd6504,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fd838c94f6518f6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd81e2f22a9ed90,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fd8039db411f056,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x3fd7e914f720cc74,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x3fd7ce94df67b164,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd7b41d60853ef2,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3fd799ae6e2563ac,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fd77f47fc0149aa,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fd764e9fddf3d40,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd74a9467929028,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd730472cfb8626,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fd71602420738aa,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fd6fbc59aaf816a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd6e1912afadfc2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd6c764e6fc6322,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd6ad40c2d39212,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fd69324b2ac5294,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd67910aabed3fa,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd65f049f4f75f6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd6450084aeb2e4,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fd62b044f3908b4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd6110ff356e144,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd5f723657c7d48,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd5dd3e9a29dcb8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd5c36185eaa8d0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd5a98c1d561e80,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd58fbe550ef7a8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd575f821c35618,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd55c39782cad48,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd542824d0fad4c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd528d2953c2d0c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd50f2a458d15ac,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd4f58952e84cbc,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd4dbefb23e9fec,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd4c25d588bb010,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fd4a8d23ad5dc0c,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fd48f4e4e2e2de8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd475d187b04358,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd45c5bdc823d34,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd442ed41d4a8f8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd42985ace26d60,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd4102512f0b6d8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd3f6cb694ee39c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd3dd78a5567028,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd3c42cbc6ae3b4,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd3aae7a3f9bd38,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd391a9517a5fcc,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd37871ba6dfff4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd35f40d45f907c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd3461694e3afd4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd32cf2f1989528,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd313d5e025fdec,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd2fabf563d1be8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd2e1af49988168,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd2c8a5affc1110,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd2afa27f34ea2c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd296a5ad19574c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd27daf2f88bc74,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd264befc6b8550,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd24bd509b31360,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd232f14d59ac80,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd21a13bd6269d0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd2013c4fd925ec,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd1e86afad26c04,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd1cf9fb46b6688,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd1b6da72c9ce78,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd19e1b2c1bda14,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd18561d6982cb8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd16cae687dc514,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd15400d813ee48,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd13b591baa2d60,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd122b7299832bc,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd10a1af83dc894,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd0f1847e02c37c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd0d8f3b156f1e8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd0c06888b20c58,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd0a7e2fa93a56c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd08f62fd831a28,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd076e8880f8214,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd05e7390cf9fb8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd046040e61d120,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd02d99f76c0068,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd01535429b9414,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fcff9abcd4ac0b0,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fcfc8f7b48b2fd0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcf984e287f7790,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fcf67af16bd1c48,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcf371a6ce803b0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcf069018b258a0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fced61007dc6d58,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcea59a28349e30,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fce752e67973478,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fce44ccb3ee4960,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fce1474fb31a960,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcde4272b66b6f0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fcdb3e332a04ee8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fcd83a8fefeab90,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcd53787eaf4860,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fcd23519fecc6a8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fccf33450fed010,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fccc3208039fea0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fcc93161bffb9f0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fcc631512be24b8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fcc331d52effab8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcc032ecb1c78c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcbd34969d74038,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcba36d1dc03d50,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fcb7399d5838c00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcb43cf7fd95ca0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fcb140e0b85daf0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcae45567591260,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcab4a5822ed4e0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fca84fe4aeea028,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fca555fb08b8450,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fca25c9a2040988,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc9f63c0e6216f8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc9c6b6e4bad980,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc9973a142ea868,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc967c58be8eee8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc938593b201168,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc908f5111553e8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc8d998fd14c2f0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc8aa44ee7518f0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc87af8d497a740,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc84bb49ee83ba0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc81c783cdd0a60,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc7ed439df69360,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc7be16b1bf8c10,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fc78ef167ccc560,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fc75fd3afbd1690,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fc730bd793941d0,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x3fc701aeb3f3df00,
    0x0, 0x0,
    0xbfecccccccccccb5, 0x3fc6d2a74fa944c0,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fc6a3a73c1f6ca0,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3fc674ae6925e170,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fc645bcc695a400,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fc616d244511470,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc5e7eed243dd40,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc5b9126062d960,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fc58a3cdeabff70,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc55b6e3d2649c0,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc52ca66be1a0c0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc4fde55af6c2c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc4cf2afa872f60,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc4a0773abd0f70,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc471ca0bcb2010,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc443235dec9ae0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc4148321652130,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc3e5e94680a660,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc3b755bd935760,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc388c876f98820,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc35a4163179b70,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc32bc07259ee10,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc2fd459534c190,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fc2ced0bc2425f0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc2a061d7abe500,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc271f8d8576c40,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc24395aeb9b890,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fc215384b6d4020,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc1e6e09f13dda0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc1b88e9a56bb90,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc18a422de63f10,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fc15bfb4a79f2d0,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fc12db9e0d071f0,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fc0ff7de1af5650,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc0d1473de31d10,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fc0a315e63f1ab0,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc074e9cb9d5fe0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc046c2dedea830,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc018a110ea44e0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbfd508a55c11c0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fbf78d92a3c68c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbf1cb3926ac120,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbec097bfe8d8a0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbe648594c4ce80,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbe087cf318fc80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbdac7dbd0bcf00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbd5087d4cf9e20,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbcf49b1ca28440,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbc98b776ce3900,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbc3cdcc5a7e9e0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbbe10aeb900ec0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fbb8541caf24aa0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbb298146453de0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbacdc9400a62c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fba72199acde580,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fba167239268020,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb9bad2fdb55020,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb95f3bcb25b300,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb903ac842d2080,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb8a8250b8b0140,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb84ca544088c80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb7f12d10789f80,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb795bc53b79980,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb73a52f0ab3440,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb6def0ca426200,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb68395c37521c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb62841bf4460c0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb5ccf4a0b9cfc0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb571ae4ae7c200,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb5166ea0e903c0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fb4bb3585e0ba80,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb46002dcfa3a80,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb404d68968e600,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb3a9b06e680600,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fb34e906f3aa780,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb2f3766f2b7540,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb29862518c9480,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb23d53f9b77e80,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb1e24b4b0cdf40,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb1874828f46d80,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb12c4a76dcca00,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb0d152183b5a00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb0765ef08c1f80,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fb01b70e3519d80,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3faf810fa8295800,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3faecb474cc8af00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fae15887bab7b00,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fad5fd2fc07d100,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3facaa26951f5500,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fabf4830e3ef880,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fab3ee82ebeaf80,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3faa8955be012780,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fa9d3cb83738700,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa91e49468d2200,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fa868cececf3200,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fa7b35be3c49200,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fa6fdf04d017800,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fa6488bd2233600,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fa5932e3acfd900,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa4ddd74eb60600,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fa42886d58c9d00,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fa3733c97127a00,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fa2bdf85b0e2900,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fa208b9e94db000,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa1538109a63300,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fa09e4d83f3c000,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f9fd23e4031fe00,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f9e67eb4bfdee00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f9cfda1bb296a00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f9b93611d9e4200,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f9a292903514000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f98bef8fc41b800,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f9754d098790800,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f95eaaf6809d800,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f948094fb0fe000,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3f931680e1af0400,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f91ac72ac132800,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f904269ea6f5400,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f8db0cc59faa800,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f8adcce07fa4000,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3f8808d7ff68c000,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3f8534e960dbb000,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f8261014cf1d000,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f7f1a3dc8a38000,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3f7972828f528000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f73cacf2f57c000,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3f6c4643d4488000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f60f6f202620000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f469e95afe00000,
    0x0
    };

static const uint64_t ref_rfft_step_4096[4097] = {
    0x409ccccccccccccd, 0x0,
    0xbfeccccccccccc94, 0x409255ab59b0d91d,
    0x0, 0x8000000000000000,
    0xbfeccccccccccd1b, 0x407872374985cccb,
    0x0, 0x0,
    0xbfecccccccccce16, 0x406d55d5e9ab64d2,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4064f4249e29f05c,
    0x0, 0x8000000000000000,
    0xbfecccccccccccec, 0x40604c15c7477295,
    0x0, 0x0,
    0xbfeccccccccccc70, 0x405aaafea7e4b54b,
    0x0, 0x0,
    0xbfeccccccccccc89, 0x405690a22c6ee734,
    0x0, 0x0,
    0xbfeccccccccccc22, 0x40538e5c57b0a394,
    0x0, 0x0,
    0xbfeccccccccccd71, 0x40514152583a6d84,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x404ee091ba6ea2bb,
    0x0, 0x0,
    0xbfecccccccccccda, 0x404befa413e515be,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x404981a57b930dd0,
    0x0, 0x0,
    0xbfeccccccccccd56, 0x404777295eaf9f8f,
    0x0, 0x0,
    0xbfeccccccccccbe5, 0x4045ba12be3b5a06,
    0x0, 0x0,
    0xbfeccccccccccc3f, 0x40443a5e42a9253e,
    0x0, 0x0,
    0xbfecccccccccce5c, 0x4042ec2a79774ee3,
    0x0, 0x8000000000000000,
    0xbfeccccccccccb37, 0x4041c6774233d803,
    0x0, 0x0,
    0xbfeccccccccccd45, 0x4040c25324c11d3b,
    0x0, 0x0,
    0xbfeccccccccccd78, 0x403fb499f4a797b0,
    0x0, 0x0,
    0xbfeccccccccccc82, 0x403e1422c4e2ef82,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x403c9c4a1ee5755a,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x403b47650d332402,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x403a10ca8d105880,
    0x0, 0x0,
    0xbfeccccccccccca4, 0x4038f49cac8f5afc,
    0x0, 0x0,
    0xbfeccccccccccd10, 0x4037ef9f196b9240,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x4036ff1770299b8a,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x403620b4b817f80e,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4035527c389eb4d3,
    0x0, 0x0,
    0xbfecccccccccccae, 0x403492ba578bc6ec,
    0x0, 0x0,
    0xbfecccccccccccf6, 0x4033dff68b3e84c5,
    0x0, 0x0,
    0xbfeccccccccccc80, 0x403338e9abdf8da2,
    0x0, 0x0,
    0xbfeccccccccccefc, 0x40329c761cbece79,
    0x0, 0x0,
    0xbfeccccccccccacc, 0x403209a16826134a,
    0x0, 0x0,
    0xbfecccccccccccf8, 0x40317f8f00378e3b,
    0x0, 0x0,
    0xbfecccccccccccb0, 0x4030fd7be962e271,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x403082bb20617229,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x40300eb297c30fb2,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x402f41b16180aa16,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x402e716431d1c090,
    0x0, 0x0,
    0xbfeccccccccccc92, 0x402dab9ff59b8f80,
    0x0, 0x0,
    0xbfeccccccccccced, 0x402cef9ce6a0dd67,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x402c3ca680036d63,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x402b92193a56f04f,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x402aef6097b15975,
    0x0, 0x0,
    0xbfecccccccccccec, 0x402a53f573236c6a,
    0x0, 0x0,
    0xbfeccccccccccc90, 0x4029bf5c893ab72d,
    0x0, 0x0,
    0xbfeccccccccccc9a, 0x4029312530f6e79f,
    0x0, 0x0,
    0xbfeccccccccccd61, 0x4028a8e83e0e9fd0,
    0x0, 0x0,
    0xbfeccccccccccc2a, 0x40282647068d6c86,
    0x0, 0x0,
    0xbfeccccccccccd03, 0x4027a8ea86cb316f,
    0x0, 0x0,
    0xbfeccccccccccce8, 0x402730829f88166c,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x4026bcc56a9f4c91,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x40264d6ea34d9fbb,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x4025e23f1f7c142c,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x40257afc57df12c5,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4025176ffd0b4b0e,
    0x0, 0x0,
    0xbfeccccccccccd01, 0x4024b76797e54061,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x40245ab43409a693,
    0x0, 0x0,
    0xbfeccccccccccceb, 0x4024012a12fd17e9,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4023aaa0671abef8,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x402356f1155c85e4,
    0x0, 0x0,
    0xbfeccccccccccc9b, 0x402305f87d3534a0,
    0x0, 0x0,
    0xbfeccccccccccd07, 0x4022b79545ce73a0,
    0x0, 0x0,
    0xbfeccccccccccc7e, 0x40226ba8301295d8,
    0x0, 0x8000000000000000,
    0xbfeccccccccccd1e, 0x40222213ecfceac2,
    0x0, 0x0,
    0xbfeccccccccccc9c, 0x4021dabcf7bb9f5c,
    0x0, 0x0,
    0xbfeccccccccccd01, 0x40219589733c4769,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x402152610ac85aa1,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x4021112cd56188d9,
    0x0, 0x0,
    0xbfecccccccccccb9, 0x4020d1d73b97017e,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x4020944bdf94d5a7,
    0x0, 0x0,
    0xbfecccccccccccad, 0x402058778735a438,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40201e4807e4e856,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x401fcb58684b5418,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x401f5d27952c2210,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x401ef1decc991335,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x401e8960e0ddb91c,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x401e239225cdbdca,
    0x0, 0x0,
    0xbfecccccccccccaf, 0x401dc0585836836b,
    0x0, 0x0,
    0xbfeccccccccccd2a, 0x401d5f9a872b35d0,
    0x0, 0x0,
    0xbfeccccccccccc7a, 0x401d0140ff020ba7,
    0x0, 0x0,
    0xbfeccccccccccced, 0x401ca53535dd8307,
    0x0, 0x0,
    0xbfecccccccccccf8, 0x401c4b61b9a00010,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x401bf3b21f2b6c30,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x401b9e12f2d155ac,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x401b4a71a9daa106,
    0x0, 0x0,
    0xbfecccccccccccce, 0x401af8bc95102cb4,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x401aa8e2d42fd8a0,
    0x0, 0x0,
    0xbfeccccccccccce7, 0x401a5ad44a3b3f4f,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x401a0e81928f195b,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4019c3dbf6b3c681,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x40197ad564d8d19c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4019336066ee7fa6,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4018ed701a519452,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x4018a8f827fe7838,
    0x0, 0x0,
    0xbfeccccccccccd82, 0x401865ecbd41d346,
    0x0, 0x0,
    0xbfeccccccccccc27, 0x4018244284dd835a,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4017e3eea0999226,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4017a4e6a339805a,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x401767208aced43a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x40172a92bb626efb,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x4016ef33f9eeab5c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4016b4fb67a4c1f2,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x40167be07d785b4e,
    0x0, 0x0,
    0xbfecccccccccccda, 0x401643db07ec9d10,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40160ce3231e5952,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4015d6f137075bbe,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4015a1fdf3f71c7e,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x40156e024f3d66ca,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x40153af78003c1cd,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x401508d6fc52a577,
    0x0, 0x0,
    0xbfecccccccccccff, 0x4014d79a763fbb67,
    0x0, 0x0,
    0xbfeccccccccccc96, 0x4014a73bd9429e22,
    0x0, 0x0,
    0xbfecccccccccccea, 0x401477b547adb6a3,
    0x0, 0x0,
    0xbfecccccccccccf2, 0x401449011849034c,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x40141b19d40cb9c8,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x4013edfa33f9da15,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x4013c19d1f0ee9e6,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x401395fda8572ebe,
    0x0, 0x0,
    0xbfeccccccccccca6, 0x40136b170d12d924,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x401340e4b2f6ae90,
    0x0, 0x0,
    0xbfecccccccccccca, 0x401317622681d6b6,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4012ee8b19688965,
    0x0, 0x0,
    0xbfeccccccccccc9b, 0x4012c65b61126cf2,
    0x0, 0x0,
    0xbfecccccccccccf8, 0x40129ecef52b8ab2,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x401277e1ee46cf50,
    0x0, 0x0,
    0xbfecccccccccccb4, 0x4012519084911f9d,
    0x0, 0x0,
    0xbfeccccccccccd21, 0x40122bd70e9416ca,
    0x0, 0x0,
    0xbfeccccccccccc7c, 0x401206b2000796b2,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x4011e21de8b1590a,
    0x0, 0x0,
    0xbfeccccccccccced, 0x4011be177351c61c,
    0x0, 0x0,
    0xbfeccccccccccca3, 0x40119a9b649d5701,
    0x0, 0x0,
    0xbfeccccccccccd02, 0x401177a69a41de4a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x4011553609f713b7,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x40113346c099cfb9,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x401111d5e151676f,
    0x0, 0x0,
    0xbfecccccccccccf0, 0x4010f0e0a4bea54d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x4010d0645833e0bc,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4010b05e5cf5beac,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x401090cc27842c0d,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x401071ab3eeb2918,
    0x0, 0x0,
    0xbfecccccccccccae, 0x401052f93c1b026b,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x401034b3c9479aaf,
    0x0, 0x0,
    0xbfecccccccccccf6, 0x401016d8a14e6c74,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x400ff2cb1e45e1e2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400fb8b0da8239dc,
    0x0, 0x0,
    0xbfecccccccccccda, 0x400f7f5e4a4b52cf,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x400f46cf5d97c2da,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400f0f0020616572,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x400ed7ecb9b583ce,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x400ea1916ace8d19,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400e6bea8e36ed46,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x400e36f496f497c3,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x400e02ac0fbcdfb3,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400dcf0d9a303e3c,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400d9c15ee1daad0,
    0x0, 0x0,
    0xbfecccccccccccba, 0x400d69c1d8cd2f2c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400d380e3c5164c0,
    0x0, 0x0,
    0xbfecccccccccccba, 0x400d06f80edf8cd3,
    0x0, 0x0,
    0xbfeccccccccccd3e, 0x400cd67c5a2dfa52,
    0x0, 0x0,
    0xbfeccccccccccc5a, 0x400ca6983ad88527,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x400c7748dfcac5b6,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x400c488b89afd781,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x400c1a5d8a676749,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400becbc447fd1fa,
    0x0, 0x0,
    0xbfecccccccccccce, 0x400bbfa52ab51ed7,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400b9315bf749f3a,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x400b670b9465036c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400b3b8449f2b42a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400b107d8ee044b9,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x400ae5f51fdad144,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x400abbe8c71221ee,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x400a92565bd46a13,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x400a693bc22d7f90,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x400a4096ea8965a3,
    0x0, 0x0,
    0xbfecccccccccccf6, 0x400a1865d15a09fd,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x4009f0a67ec01333,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x4009c9570636a190,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x4009a2758641e555,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x40097c0028206d06,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x400955f51f7f11e7,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40093052aa2f67e6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x40090b170fe098f3,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x4008e640a1da9398,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x4008c1cdbabb76cc,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x40089dbcbe3724a9,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x40087a0c18d8e834,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x400856ba3fc7199c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x400833c5b088ae52,
    0x0, 0x0,
    0xbfecccccccccccb5, 0x4008112cf0cca310,
    0x0, 0x0,
    0xbfecccccccccccda, 0x4007eeee8e332dc1,
    0x0, 0x0,
    0xbfecccccccccccae, 0x4007cd091e18a75a,
    0x0, 0x0,
    0xbfeccccccccccce9, 0x4007ab7b3d621cf3,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x40078a43904b7982,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x40076960c23738bb,
    0x0, 0x0,
    0xbfecccccccccccca, 0x400748d1857f95f1,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x4007289493492862,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x400708a8ab56e0f4,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4006e90c93df5c46,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x4006c9bf19637d5a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x4006aabf0e864564,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x40068c0b4be5dde6,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x40066da2aff5c9e0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x40064f841eda34ea,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400631ae8244556e,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x40061420c94fd96a,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x4005f6d9e8615417,
    0x0, 0x0,
    0xbfecccccccccccf3, 0x4005d9d8d905a46b,
    0x0, 0x0,
    0xbfecccccccccccae, 0x4005bd1c99d24b78,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x4005a0a42e46aaf5,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x4005846e9eae247c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4005687af8031166,
    0x0, 0x0,
    0xbfecccccccccccce, 0x40054cc84bd28cac,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40053155b02107e0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x400516223f4fa431,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x4004fb2d18024994,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x4004e0755d0675d4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x4004c5fa353abd4e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4004abbacb76f817,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x400491b64e7515b6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x400477ebf0ba9257,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x40045e5ae8828852,
    0x0, 0x0,
    0xbfecccccccccccda, 0x400445026fa85925,
    0x0, 0x0,
    0xbfeccccccccccd0b, 0x40042be1c392e8d7,
    0x0, 0x0,
    0xbfeccccccccccc8d, 0x400412f82520680a,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x4003fa44d892a69a,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x4003e1c7257bed4a,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x4003c97e56ac5706,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x4003b169ba1fa8d8,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x40039988a0eba29a,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x400381da5f2ec5e2,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40036a5e4bff8f03,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x40035313c15c1cf7,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x40033bfa1c1a44f5,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x40032510bbd80dde,
    0x0, 0x0,
    0xbfecccccccccccca, 0x40030e5702ec917a,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x4002f7cc56593f69,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x4002e1701dbb7fb7,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x4002cb41c33eb1b8,
    0x0, 0x0,
    0xbfeccccccccccced, 0x4002b540b38e84e6,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x40029f6c5dc9a8ec,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x400289c43374d20d,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x40027447a86e105b,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x40025ef632e07630,
    0x0, 0x0,
    0xbfeccccccccccce0, 0x400249cf4b380c96,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x400234d26c161315,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x40021fff12458868,
    0x0, 0x0,
    0xbfecccccccccccef, 0x40020b54bcaffaa3,
    0x0, 0x0,
    0xbfecccccccccccae, 0x4001f6d2ec529c8c,
    0x0, 0x0,
    0xbfeccccccccccce9, 0x4001e27924339da4,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x4001ce46e957c469,
    0x0, 0x0,
    0xbfeccccccccccd06, 0x4001ba3bc2b84726,
    0x0, 0x0,
    0xbfeccccccccccc7a, 0x4001a6573938e355,
    0x0, 0x0,
    0xbfecccccccccccfe, 0x40019298d79e302e,
    0x0, 0x0,
    0xbfecccccccccccf1, 0x40017f002a842cd9,
    0x0, 0x0,
    0xbfeccccccccccc57, 0x40016b8cc05505fe,
    0x0, 0x8000000000000000,
    0xbfeccccccccccd43, 0x4001583e29401360,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x40014513f7310bc5,
    0x0, 0x0,
    0xbfeccccccccccc92, 0x4001320dbdc76b6b,
    0x0, 0x0,
    0xbfeccccccccccd1d, 0x40011f2b124e0f3e,
    0x0, 0x0,
    0xbfeccccccccccc95, 0x40010c6b8bb3009e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x4000f9cec27f7104,
    0x0, 0x0,
    0xbfecccccccccccb2, 0x4000e75450cfe5ab,
    0x0, 0x0,
    0xbfeccccccccccced, 0x4000d4fbd24c8fa9,
    0x0, 0x0,
    0xbfeccccccccccca4, 0x4000c2c4e421d16c,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x4000b0af24f8eed1,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x40009eba34f0e7cc,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x40008ce5b5977bfe,
    0x0, 0x0,
    0xbfecccccccccccea, 0x40007b3149e2560a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x4000699c96285e37,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x40005827401b32a3,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x400046d0eec0c4ab,
    0x0, 0x0,
    0xbfecccccccccccad, 0x400035994a6d1a26,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x4000247ffcbc31be,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x40001384b08c0994,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x400002a711f6c6f7,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fffe3cd9c99fd8e,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fffc28728203adc,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fffa17a25d9db42,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fff80a5f76c7aa4,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fff600a00bf3fcc,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fff3fa5a7f099ea,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fff1f78554c3631,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffeff8173412b8e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffedfc06e585b79,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3ffec034b52b06c5,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3ffea0ddb8599494,
    0x0, 0x0,
    0xbfeccccccccccd08, 0x3ffe81baea828adf,
    0x0, 0x0,
    0xbfeccccccccccc94, 0x3ffe62cbc039b707,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffe440fafff84e2,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffe25863238844d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ffe072ec1251af1,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffde908d8d96174,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffdcb13f7352be0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffdad4f9bdc3b10,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffd8fbb482e96d9,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ffd72567f410fda,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffd5520c5d5e818,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffd3819a255a0fc,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffd1b409cc7eece,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ffcfe953ecccf9e,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffce2171395c5c9,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffcc5c5a7df34b4,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x3ffca9a089e9df3a,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x3ffc8da7497486dc,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ffc71d977b5aac0,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ffc5636a75566bb,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ffc3abe6c67701b,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ffc1f705c653109,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffc044c0e2800ce,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffbe95119e378e2,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ffbce7f191fe5b0,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ffbb3d5a6b4d314,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffb99545ec3b30c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffb7efadeb29efe,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ffb64c8c527323f,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ffb4abdb2017da0,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ffb30d946571382,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ffb171b246e2baf,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3ffafd82efb8deae,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3ffae4104cd077aa,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffacac2e170dd44,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3ffab19a54740f76,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ffa98964dcdbbc0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ffa7fb67686e56c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ffa66fa78b9a2fc,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ffa4e61ff8cef3c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffa35ecb7308e09,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ffa1d9a4cd90460,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ffa056a6ebba341,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff9ed5ccc0aa4a2,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff9d57114f15ae2,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff9bda6fa907170,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff9a5fe2efa3f00,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff98e76652f284b,
    0x0, 0x0,
    0xbfeccccccccccce1, 0x3ff9770f511a13d4,
    0x0, 0x0,
    0xbfecccccccccccb8, 0x3ff95fc8a78ced94,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff948a21e3d3a3d,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3ff9319b6bc0bad0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff91ab4478a1e8a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff903ec69e5c44a,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff8ed438bf68a61,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff8d6b967b2aca0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff8c04db7e0b07a,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff8aa0038145ee9,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff893d0a4abcb99,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff87dbebacc697e,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff867ca38602c12,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff851f2dc12b572,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff83c38654e909b,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff8269a943a783f,
    0x0, 0x0,
    0xbfecccccccccccf6, 0x3ff8111929b6a8b7,
    0x0, 0x0,
    0xbfeccccccccccca8, 0x3ff7fbb3e75a3f0a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff7e66a8f70a104,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff7d13ce4f6f3be,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff7bc2aab9999df,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff7a733a7b1bf13,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff792579e42eca6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff77d9654f8a92b,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff768ef9224221c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff754631cb9df38,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff73ff0bc4f802a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff72b983919830c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff717595be9151e,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff70333ee29ebe3,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff6ef27b9e027fe,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff6db3489a64064,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3ff6c75a28aaf69a,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3ff6b39862af5350,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff69fef0404ab2b,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff68c5dd98aac64,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff678e4b0ad73b4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff665835763a991,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff652399c2ca73f,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff63f074e0ea31e,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3ff62bec3c94e4e4,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff618e837ce00c0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff605fb104a1a16,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff5f32497192cd0,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff5e0649dc95e2c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff5cdbaf66553a6,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ff5bb27737291b6,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3ff5a8a9e7efdf41,
    0x0, 0x0,
    0xbfecccccccccccfe, 0x3ff596422753b1bc,
    0x0, 0x0,
    0xbfeccccccccccc99, 0x3ff583f0058a9d96,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3ff571b356f5ce61,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3ff55f8bf06983d6,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff54d79a72b9618,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff53b7c50f1fe46,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff52993c3e166c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff517bfd68bbf1e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff506005feed73c,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff4f4553772fec4,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff4e2be34e9aae9,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff4d13b308c206d,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff4bfcc02fa23d0,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff4ae708538add3,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff49d2890b0a590,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff48bf3ff2d9eed,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3ff47ad2aadc9e62,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3ff469c46e4ae14a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff458c92464aa83,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff447e0a8741464,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff4370ad61fe67e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff42647896a7013,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff415969eb06700,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff404f7f2a7caa9,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff3f46b625ecb43,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3ff3e3f0cb3ab53f,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff3d3880af6e0a2,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff3c330ffa3a472,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff3b2eb87a54e24,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff3a2b781b31c91,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3ff39294ccd63f15,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff382834868d82e,
    0x0, 0x0,
    0xbfecccccccccccf5, 0x3ff37282d41503ca,
    0x0, 0x0,
    0xbfeccccccccccca3, 0x3ff362934fd3e15a,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3ff352b49beca0d6,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3ff342e698f3944c,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3ff3332927c943d7,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff3237c29998550,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff313df7fda978a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff304530c4c406a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff2f4d6b0f6ee7c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff2e56a502add68,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff2d60dcc7f3ddd,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff2c6c108d16023,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff2b783e843e1ef,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff2a8564e3ddefd,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff299381e6a24c0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff28a293cb668a8,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3ff27b298d52817c,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3ff26c38f4afa363,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff25d57577f9e3b,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff24e849ab41f7c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff23fc0a37df5c1,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff2310b574c579a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff222649bcc2c89,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff213cc56e758b6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff205426ec40aef,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff1f6c6c9c40d30,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff1e8594e84177c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3ff1d9f9e3db2526,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff1cba870d9cc4d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff1bd64dcc997a0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff1af2f0f2c6290,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3ff1a106efbbb758,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3ff192ec66682fa2,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3ff184df5b58d6cd,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3ff176dfb6ea8ef6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff168ed61af7732,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff15b08446e54c8,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff14d304821fd90,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3ff13f6555f8c4e8,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff131a75753ea5c,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3ff123f635c70a1a,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3ff11651db178f80,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff108ba313c2981,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff0fb2f225c4098,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff0edb098cf6ef0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff0e03e7f1cfa05,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff0d2d8bffb4e0e,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3ff0c57f464f7b3d,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3ff0b831fd2cb494,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3ff0aaf0cfd3d09c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff09dbba9b2cb1b,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3ff090927664498c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff0837521af1ff1,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff076639785d80e,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3ff0695dc40639e0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff05c639378d5a6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3ff04f74f2508f53,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3ff04291cd2a2baa,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3ff035ba10cbdeaf,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3ff028edaa24db80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3ff01c2c864ce5a7,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3ff00f769283e3d6,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3ff002cbbc3173f1,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fefec57e1c90123,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fefd32e3ca5aef8,
    0x0, 0x0,
    0xbfecccccccccccb9, 0x3fefba1a64b184cf,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fefa11c35f13e36,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fef88338cb4f73e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fef6f604597619e,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fef56a23d7d0092,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fef3df9519364cb,
    0x0, 0x0,
    0xbfecccccccccccd5, 0x3fef25655f506bca,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fef0ce644718184,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3feef47bdefae3cb,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3feedc260d36e8e5,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3feec3e4adb5478b,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feeabb79f4a61f6,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fee939ec10e9220,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fee7b99f25d7980,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fee63a912d55190,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3fee4bcc02563f7a,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3fee3402a101a962,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fee1c4ccf398d6c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fee04aa6d9fdbfc,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3feded1b5d15d246,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fedd59f7ebb5846,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3fedbe36b3ee5ff0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3feda6e0de4a467c,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fed8f9ddfa73768,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fed786d9a199185,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fed614feff14e2f,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fed4a44c3b9698f,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fed334bf8374d10,
    0x0, 0x0,
    0xbfeccccccccccd0d, 0x3fed1c65706a3bd6,
    0x0, 0x0,
    0xbfeccccccccccc8c, 0x3fed05910f8ac080,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3feceeceb90a1cff,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fecd81e5091ba6a,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fecc17fba02a26a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fecaaf2d974e5ff,
    0x0, 0x0,
    0xbfeccccccccccd0c, 0x3fec947793372580,
    0x0, 0x0,
    0xbfeccccccccccc8d, 0x3fec7e0dcbcdfad6,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fec67b567f37910,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fec516e4c96a60f,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fec3b385edaf72f,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fec25138417cf45,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fec0effa1d7fe28,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3febf8fc9dd9423c,
    0x0, 0x0,
    0xbfecccccccccccdd, 0x3febe30a5e0bc9f0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3febcd28c891b886,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3febb757c3beab26,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feba19736173fbc,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3feb8be706509ccc,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3feb76471b4ffb22,
    0x0, 0x0,
    0xbfecccccccccccbd, 0x3feb60b75c2a30da,
    0x0, 0x0,
    0xbfecccccccccccbb, 0x3feb4b37b0233cf0,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3feb35c7feadd550,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feb20682f6af560,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3feb0b182a296dc6,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3feaf5d7d6e5762b,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3feae0a71dc83f35,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3feacb85e72786bb,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3feab6741b852c74,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3feaa171a38ec82a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fea8c7e681d410b,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fea779a52346642,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fea62c54b02885e,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fea4dff3be0142e,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fea39480e4f2eb6,
    0x0, 0x0,
    0xbfeccccccccccce9, 0x3fea249fabfb51ef,
    0x0, 0x0,
    0xbfecccccccccccba, 0x3fea1005feb8eb68,
    0x0, 0x0,
    0xbfecccccccccccd9, 0x3fe9fb7af084fa33,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fe9e6fe6b84b0a2,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe9d2905a05145d,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe9be30a67aa126,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe9a9df3b80ec10,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe9959c03da47ce,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe98166ea6f69e4,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe96d3fda4f10fe,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe95926beadac6c,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe9451b82e503d8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe9311e1273e0dd,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe91d2e58fdb8f2,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe9094c424a5857,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe8f577ba458e16,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fe8e1b0acfed8cf,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fe8cdf706a914a9,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe8ba4ab39a291a,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe8a6aba04ab98c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe89319b955d482,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe87f94eb78a577,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe86c1d23922688,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe858b24ea2d35a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe8455459cc5ca1,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fe8320332515ca3,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe81ebec5950c50,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe80b87011af950,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe7f85bd286bcd0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe7e53d279bb2df,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe7d22aee3cb2e4,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe7bf25146bc86d,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe7ac2b8849ed5a,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe7993e3816c3ac,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe7865d123051a0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe773880512bc97,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe760beff5806a8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe74e01efb7cb32,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe73b50c506fd4d,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe728ab6e37a648,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe71611da58a507,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fe70383f8956df6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6f101b835cbe5,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe6de8b089da102,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe6cc1fd94ca905,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe6b9c019de3bba,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe6a76bba091007,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe69522a99effde,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fe682e4d88ccc96,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe670b236d9e421,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe65e8ab4a8260d,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe64c6e4233aa88,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe63a5ccfd28876,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe628564df49d12,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe6165aad2353be,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe60469de016e9a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe5f283d14acf58,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe5e0a877d440e4,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe5ced7c28b4181,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe5bd11a275cd51,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe5ab5608b22999,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe599a4e676b056,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe587fe2d119c6b,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe57661cde8d697,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fe564cfba79c204,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fe55347e4590b3c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe541ca3d327434,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe53056b6c8a58e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe51eed42f4fbca,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe50d8dd3a757d8,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe4fc385ae5eecb,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe4eaeccacd1aab,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe4d9ab158f2b5a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe4c8732d7437fa,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe4b74504d9f11a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe4a6208e3372c5,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe49505bc09177e,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe483f480f84b7b,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe472eccfb36048,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe461ee9b0160c2,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe450f9d5bde5bb,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe4400e72d8eb0c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe42f2c6556a456,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fe41e53a04f537d,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fe40d8416ef1e42,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe3fcbdbc75e4ec,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe3ec008437195a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe3db4c61999622,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fe3caa148177649,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fe3b9ff2b3ded6c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe3a965fead2021,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe398d5b617fcc7,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fe3884e454414b3,
    0x0, 0x0,
    0xbfecccccccccccd8, 0x3fe377cfa00975ac,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3fe36759ba5283f3,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe356ec881bd47e,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe34687fd74070f,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fe3362c0e7ba2a8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe325d8af64ee2a,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fe3158dd473cf1f,
    0x0, 0x0,
    0xbfecccccccccccbc, 0x3fe3054b71fda328,
    0x0, 0x0,
    0xbfecccccccccccdc, 0x3fe2f5117c691da8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe2e4dfe82e23e0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe2d4b6a9d5a9f5,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fe2c495b5f99049,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe2b47d014480e1,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe2a46c8071cda5,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe29464284d4e16,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe28463edb33e2e,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe2746bc5901d1d,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe2647ba4e08c63,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe2549380b12f12,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fe244b34e1e89b7,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe234db0254e271,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe2250a929020b4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fe21541f41bae8f,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe205811c5258fa,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe1f5c8009e312d,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe1e61696786e10,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fe1d66cd3694dcd,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe1c6caad07f7d0,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe1b73018fa5f04,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe1a79d0cf5243e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe198117ebb78ef,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe1888d641f0256,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fe17910b2ffbc7a,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fe1699b614bdde0,
    0x0, 0x0,
    0xbfecccccccccccc3, 0x3fe15a2d64ffbb2b,
    0x0, 0x0,
    0xbfeccccccccccce2, 0x3fe14ac6b425ab24,
    0x0, 0x0,
    0xbfecccccccccccb6, 0x3fe13b6744d5eb66,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fe12c0f0d36838a,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe11cbe037b2bba,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fe10d741de53043,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe0fe3152c35747,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe0eef59871c63c,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fe0dfc0e559e762,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe0d0932ff24fda,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe0c16c6ebea580,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe0b24c984f85a0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe0a333a3426b1e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe09421864195a5,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe085163803f037,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fe07611af4cf8c8,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe06713e2eca74a,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe0581cc9bf55a8,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fe0492c5aada788,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fe03a428cac71da,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fe02b5f56bca3f1,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fe01c82afeb2f3f,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fe00dac8f50f043,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdffdb9d8252ea8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdfe0277ac1238c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdfc2a1f4ede5d2,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdfa529353abb5c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdf87bd2a4ddc2a,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdf6a5dc2e44650,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdf4d0aedd19190,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdf2fc499ffc3d0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdf128ab66f25f6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fdef55d32361880,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fded83bfc80e9b6,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdebb270491aa2a,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fde9e1e39c00494,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fde81218b791246,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fde6430e93f33be,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fde474c42a9e664,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fde2a7387659d10,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fde0da6a733970e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fddf0e591e9b8c2,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fddd430377263ae,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fddb78687cc4fc8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdd9ae8730a63c8,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdd7e55e9538f4c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdd61cedae2a414,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdd45533806306c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdd28e2f12058e0,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fdd0c7df6a6b37e,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdcf024392222ea,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdcd3d5a92eb040,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdcb792377b687c,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fdc9b59d4ca36ea,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdc7f2c71efc1b6,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fdc6309ffd3466a,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdc46f26f6e765e,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdc2ae5b1cd53c6,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fdc0ee3b80e0edc,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fdbf2ec7360e398,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fdbd6ffd507f70e,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdbbb1dce5735da,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fdb9f4650b43224,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdb83794d96025c,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdb67b6b6851ffe,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fdb4bfe7d1b468c,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fdb3050930353f4,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fdb14ace9f92512,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdaf91373c97a2c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdadd842251d2cc,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fdac1fee78050aa,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fdaa683b553973c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fda8b127ddaaca6,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fda6fab3334db02,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fda544dc7919152,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fda38fa2d3045a8,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fda1db0566055fe,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fda02703580eb3e,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd9e739bd00da88,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd9cc0cdf5e8870,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd9b0e98f27cafc,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd995cfbef9ccec,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd97abf6180f158,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd95fb86978b566,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd944bac9ab95da,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd929c674f2f164,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd90edb5e36ecd2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd8f3f9786e585e,
    0x0, 0x0,
    0xbfecccccccccccd3, 0x3fd8d920b69e924a,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd8be510bdb6cb2,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd8a38a6b471296,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd888ccc811eada,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd86e18157a8080,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fd8536c46cd6504,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fd838c94f6518f6,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd81e2f22a9ed90,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fd8039db411f056,
    0x0, 0x0,
    0xbfecccccccccccb7, 0x3fd7e914f720cc74,
    0x0, 0x0,
    0xbfecccccccccccdf, 0x3fd7ce94df67b164,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd7b41d60853ef2,
    0x0, 0x0,
    0xbfecccccccccccbe, 0x3fd799ae6e2563ac,
    0x0, 0x0,
    0xbfecccccccccccda, 0x3fd77f47fc0149aa,
    0x0, 0x0,
    0xbfecccccccccccc2, 0x3fd764e9fddf3d40,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd74a9467929028,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd730472cfb8626,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fd71602420738aa,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fd6fbc59aaf816a,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd6e1912afadfc2,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd6c764e6fc6322,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd6ad40c2d39212,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fd69324b2ac5294,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd67910aabed3fa,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd65f049f4f75f6,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd6450084aeb2e4,
    0x0, 0x0,
    0xbfecccccccccccc5, 0x3fd62b044f3908b4,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd6110ff356e144,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd5f723657c7d48,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd5dd3e9a29dcb8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd5c36185eaa8d0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd5a98c1d561e80,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd58fbe550ef7a8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fd575f821c35618,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fd55c39782cad48,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd542824d0fad4c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd528d2953c2d0c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd50f2a458d15ac,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd4f58952e84cbc,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd4dbefb23e9fec,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fd4c25d588bb010,
    0x0, 0x0,
    0xbfecccccccccccdb, 0x3fd4a8d23ad5dc0c,
    0x0, 0x0,
    0xbfecccccccccccbf, 0x3fd48f4e4e2e2de8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd475d187b04358,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd45c5bdc823d34,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd442ed41d4a8f8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd42985ace26d60,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd4102512f0b6d8,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd3f6cb694ee39c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd3dd78a5567028,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd3c42cbc6ae3b4,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd3aae7a3f9bd38,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd391a9517a5fcc,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd37871ba6dfff4,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd35f40d45f907c,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd3461694e3afd4,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd32cf2f1989528,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd313d5e025fdec,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd2fabf563d1be8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd2e1af49988168,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd2c8a5affc1110,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd2afa27f34ea2c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd296a5ad19574c,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd27daf2f88bc74,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd264befc6b8550,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd24bd509b31360,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd232f14d59ac80,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd21a13bd6269d0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd2013c4fd925ec,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd1e86afad26c04,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd1cf9fb46b6688,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd1b6da72c9ce78,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd19e1b2c1bda14,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd18561d6982cb8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fd16cae687dc514,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd15400d813ee48,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd13b591baa2d60,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fd122b7299832bc,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd10a1af83dc894,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fd0f1847e02c37c,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd0d8f3b156f1e8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fd0c06888b20c58,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fd0a7e2fa93a56c,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fd08f62fd831a28,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fd076e8880f8214,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fd05e7390cf9fb8,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd046040e61d120,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fd02d99f76c0068,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fd01535429b9414,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fcff9abcd4ac0b0,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fcfc8f7b48b2fd0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcf984e287f7790,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fcf67af16bd1c48,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcf371a6ce803b0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcf069018b258a0,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fced61007dc6d58,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcea59a28349e30,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fce752e67973478,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fce44ccb3ee4960,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fce1474fb31a960,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fcde4272b66b6f0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fcdb3e332a04ee8,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fcd83a8fefeab90,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fcd53787eaf4860,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fcd23519fecc6a8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fccf33450fed010,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fccc3208039fea0,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fcc93161bffb9f0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fcc631512be24b8,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fcc331d52effab8,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcc032ecb1c78c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcbd34969d74038,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcba36d1dc03d50,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fcb7399d5838c00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcb43cf7fd95ca0,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fcb140e0b85daf0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fcae45567591260,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fcab4a5822ed4e0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fca84fe4aeea028,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fca555fb08b8450,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fca25c9a2040988,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc9f63c0e6216f8,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc9c6b6e4bad980,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc9973a142ea868,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc967c58be8eee8,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc938593b201168,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc908f5111553e8,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc8d998fd14c2f0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc8aa44ee7518f0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc87af8d497a740,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc84bb49ee83ba0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc81c783cdd0a60,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc7ed439df69360,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc7be16b1bf8c10,
    0x0, 0x0,
    0xbfecccccccccccc1, 0x3fc78ef167ccc560,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fc75fd3afbd1690,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fc730bd793941d0,
    0x0, 0x0,
    0xbfeccccccccccce4, 0x3fc701aeb3f3df00,
    0x0, 0x0,
    0xbfecccccccccccb5, 0x3fc6d2a74fa944c0,
    0x0, 0x0,
    0xbfecccccccccccd6, 0x3fc6a3a73c1f6ca0,
    0x0, 0x0,
    0xbfecccccccccccc0, 0x3fc674ae6925e170,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fc645bcc695a400,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fc616d244511470,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc5e7eed243dd40,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc5b9126062d960,
    0x0, 0x0,
    0xbfecccccccccccd4, 0x3fc58a3cdeabff70,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc55b6e3d2649c0,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc52ca66be1a0c0,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fc4fde55af6c2c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc4cf2afa872f60,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc4a0773abd0f70,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc471ca0bcb2010,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc443235dec9ae0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc4148321652130,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fc3e5e94680a660,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc3b755bd935760,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc388c876f98820,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc35a4163179b70,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc32bc07259ee10,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fc2fd459534c190,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fc2ced0bc2425f0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc2a061d7abe500,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc271f8d8576c40,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fc24395aeb9b890,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fc215384b6d4020,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc1e6e09f13dda0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fc1b88e9a56bb90,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc18a422de63f10,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fc15bfb4a79f2d0,
    0x0, 0x0,
    0xbfecccccccccccd7, 0x3fc12db9e0d071f0,
    0x0, 0x0,
    0xbfecccccccccccc4, 0x3fc0ff7de1af5650,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc0d1473de31d10,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fc0a315e63f1ab0,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fc074e9cb9d5fe0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fc046c2dedea830,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fc018a110ea44e0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbfd508a55c11c0,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fbf78d92a3c68c0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbf1cb3926ac120,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbec097bfe8d8a0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbe648594c4ce80,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fbe087cf318fc80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbdac7dbd0bcf00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbd5087d4cf9e20,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbcf49b1ca28440,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbc98b776ce3900,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbc3cdcc5a7e9e0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbbe10aeb900ec0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fbb8541caf24aa0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fbb298146453de0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fbacdc9400a62c0,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fba72199acde580,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fba167239268020,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb9bad2fdb55020,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb95f3bcb25b300,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb903ac842d2080,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb8a8250b8b0140,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb84ca544088c80,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb7f12d10789f80,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb795bc53b79980,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb73a52f0ab3440,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb6def0ca426200,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fb68395c37521c0,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb62841bf4460c0,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb5ccf4a0b9cfc0,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb571ae4ae7c200,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb5166ea0e903c0,
    0x0, 0x0,
    0xbfecccccccccccc7, 0x3fb4bb3585e0ba80,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb46002dcfa3a80,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb404d68968e600,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb3a9b06e680600,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fb34e906f3aa780,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fb2f3766f2b7540,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb29862518c9480,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fb23d53f9b77e80,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb1e24b4b0cdf40,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3fb1874828f46d80,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fb12c4a76dcca00,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3fb0d152183b5a00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fb0765ef08c1f80,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fb01b70e3519d80,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3faf810fa8295800,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3faecb474cc8af00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fae15887bab7b00,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3fad5fd2fc07d100,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3facaa26951f5500,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3fabf4830e3ef880,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fab3ee82ebeaf80,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3faa8955be012780,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3fa9d3cb83738700,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3fa91e49468d2200,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fa868cececf3200,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fa7b35be3c49200,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fa6fdf04d017800,
    0x0, 0x0,
    0xbfecccccccccccd2, 0x3fa6488bd2233600,
    0x0, 0x0,
    0xbfecccccccccccc6, 0x3fa5932e3acfd900,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa4ddd74eb60600,
    0x0, 0x0,
    0xbfecccccccccccc8, 0x3fa42886d58c9d00,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fa3733c97127a00,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fa2bdf85b0e2900,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3fa208b9e94db000,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3fa1538109a63300,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3fa09e4d83f3c000,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f9fd23e4031fe00,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f9e67eb4bfdee00,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f9cfda1bb296a00,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f9b93611d9e4200,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f9a292903514000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f98bef8fc41b800,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f9754d098790800,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f95eaaf6809d800,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f948094fb0fe000,
    0x0, 0x0,
    0xbfecccccccccccd1, 0x3f931680e1af0400,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f91ac72ac132800,
    0x0, 0x0,
    0xbfeccccccccccccf, 0x3f904269ea6f5400,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f8db0cc59faa800,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f8adcce07fa4000,
    0x0, 0x0,
    0xbfecccccccccccc9, 0x3f8808d7ff68c000,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3f8534e960dbb000,
    0x0, 0x0,
    0xbfeccccccccccccb, 0x3f8261014cf1d000,
    0x0, 0x0,
    0xbfecccccccccccce, 0x3f7f1a3dc8a38000,
    0x0, 0x0,
    0xbfecccccccccccd0, 0x3f7972828f528000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f73cacf2f57c000,
    0x0, 0x0,
    0xbfecccccccccccca, 0x3f6c4643d4488000,
    0x0, 0x0,
    0xbfeccccccccccccd, 0x3f60f6f202620000,
    0x0, 0x0,
    0xbfeccccccccccccc, 0x3f469e95afe00000,
    0x0
    };

