// Created on: 2002-10-31
// Created by: Michael SAZONOV
// Copyright (c) 2002-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _BinDrivers_DocumentRetrievalDriver_HeaderFile
#define _BinDrivers_DocumentRetrievalDriver_HeaderFile

#include <Standard.hxx>

#include <BinLDrivers_DocumentRetrievalDriver.hxx>
#include <Standard_IStream.hxx>
#include <Storage_Position.hxx>
#include <Standard_Integer.hxx>
class BinMDF_ADriverTable;
class Message_Messenger;
class BinLDrivers_DocumentSection;

class BinDrivers_DocumentRetrievalDriver : public BinLDrivers_DocumentRetrievalDriver
{

public:
  //! Constructor
  Standard_EXPORT BinDrivers_DocumentRetrievalDriver();

  Standard_EXPORT occ::handle<BinMDF_ADriverTable> AttributeDrivers(
    const occ::handle<Message_Messenger>& theMsgDriver) override;

  Standard_EXPORT void ReadShapeSection(
    BinLDrivers_DocumentSection& theSection,
    Standard_IStream&            theIS,
    const bool                   isMess   = false,
    const Message_ProgressRange& theRange = Message_ProgressRange()) override;

  Standard_EXPORT void CheckShapeSection(const Storage_Position& thePos,
                                         Standard_IStream&       theIS) override;

  //! Clears the NamedShape driver
  Standard_EXPORT void Clear() override;

  //! Enables reading in the quick part access mode.
  Standard_EXPORT void EnableQuickPartReading(
    const occ::handle<Message_Messenger>& theMessageDriver,
    bool                                  theValue) override;

  DEFINE_STANDARD_RTTIEXT(BinDrivers_DocumentRetrievalDriver, BinLDrivers_DocumentRetrievalDriver)
};

#endif // _BinDrivers_DocumentRetrievalDriver_HeaderFile
