// Created on: 2007-10-30
// Created by: Sergey ZARITCHNY
// Copyright (c) 2007-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _TDataStd_DeltaOnModificationOfRealArray_HeaderFile
#define _TDataStd_DeltaOnModificationOfRealArray_HeaderFile

#include <Standard.hxx>

#include <Standard_Integer.hxx>
#include <NCollection_Array1.hxx>
#include <NCollection_HArray1.hxx>
#include <TDF_DeltaOnModification.hxx>
class TDataStd_RealArray;

//! This class provides default services for an
//! AttributeDelta on a MODIFICATION action
class TDataStd_DeltaOnModificationOfRealArray : public TDF_DeltaOnModification
{

public:
  //! Initializes a TDF_DeltaOnModification.
  Standard_EXPORT TDataStd_DeltaOnModificationOfRealArray(
    const occ::handle<TDataStd_RealArray>& Arr);

  //! Applies the delta to the attribute.
  Standard_EXPORT void Apply() override;

  DEFINE_STANDARD_RTTIEXT(TDataStd_DeltaOnModificationOfRealArray, TDF_DeltaOnModification)

private:
  occ::handle<NCollection_HArray1<int>>    myIndxes;
  occ::handle<NCollection_HArray1<double>> myValues;
  int                                      myUp1;
  int                                      myUp2;
};

#endif // _TDataStd_DeltaOnModificationOfRealArray_HeaderFile
