// Created on: 2017-02-13
// Created by: Eugeny NIKONOV
// Copyright (c) 2005-2017 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <BinObjMgt_Persistent.hxx>
#include <Message_Messenger.hxx>
#include <Standard_Type.hxx>
#include <BinMXCAFDoc_NoteCommentDriver.hxx>
#include <XCAFDoc_NoteComment.hxx>

IMPLEMENT_STANDARD_RTTIEXT(BinMXCAFDoc_NoteCommentDriver, BinMXCAFDoc_NoteDriver)

//=================================================================================================

BinMXCAFDoc_NoteCommentDriver::BinMXCAFDoc_NoteCommentDriver(
  const occ::handle<Message_Messenger>& theMsgDriver)
    : BinMXCAFDoc_NoteDriver(theMsgDriver, STANDARD_TYPE(XCAFDoc_NoteComment)->Name())
{
}

//=================================================================================================

occ::handle<TDF_Attribute> BinMXCAFDoc_NoteCommentDriver::NewEmpty() const
{
  return new XCAFDoc_NoteComment();
}

//=================================================================================================

bool BinMXCAFDoc_NoteCommentDriver::Paste(const BinObjMgt_Persistent&       theSource,
                                          const occ::handle<TDF_Attribute>& theTarget,
                                          BinObjMgt_RRelocationTable&       theRelocTable) const
{
  if (!BinMXCAFDoc_NoteDriver::Paste(theSource, theTarget, theRelocTable))
    return false;

  occ::handle<XCAFDoc_NoteComment> aNote = occ::down_cast<XCAFDoc_NoteComment>(theTarget);
  if (aNote.IsNull())
    return false;

  TCollection_ExtendedString aComment;
  if (!(theSource >> aComment))
    return false;

  aNote->Set(aComment);

  return true;
}

//=================================================================================================

void BinMXCAFDoc_NoteCommentDriver::Paste(
  const occ::handle<TDF_Attribute>&                        theSource,
  BinObjMgt_Persistent&                                    theTarget,
  NCollection_IndexedMap<occ::handle<Standard_Transient>>& theRelocTable) const
{
  BinMXCAFDoc_NoteDriver::Paste(theSource, theTarget, theRelocTable);

  occ::handle<XCAFDoc_NoteComment> aNote = occ::down_cast<XCAFDoc_NoteComment>(theSource);
  if (!aNote.IsNull())
    theTarget << aNote->Comment();
}

//=================================================================================================

BinMXCAFDoc_NoteCommentDriver::BinMXCAFDoc_NoteCommentDriver(
  const occ::handle<Message_Messenger>& theMsgDriver,
  const char*                           theName)
    : BinMXCAFDoc_NoteDriver(theMsgDriver, theName)
{
}
