// Copyright (c) 2022 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <DE_Provider.hxx>

#include <DE_ConfigurationNode.hxx>
#include <Message.hxx>
#include <NCollection_IndexedDataMap.hxx>

IMPLEMENT_STANDARD_RTTIEXT(DE_Provider, Standard_Transient)

//=================================================================================================

DE_Provider::DE_Provider() = default;

//=================================================================================================

DE_Provider::DE_Provider(const occ::handle<DE_ConfigurationNode>& theNode)
    : myNode(theNode)
{
}

//=================================================================================================

bool DE_Provider::Read(const TCollection_AsciiString&       thePath,
                       const occ::handle<TDocStd_Document>& theDocument,
                       occ::handle<XSControl_WorkSession>&  theWS,
                       const Message_ProgressRange&         theProgress)
{
  (void)thePath;
  (void)theDocument;
  (void)theWS;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support read operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Write(const TCollection_AsciiString&       thePath,
                        const occ::handle<TDocStd_Document>& theDocument,
                        occ::handle<XSControl_WorkSession>&  theWS,
                        const Message_ProgressRange&         theProgress)
{
  (void)thePath;
  (void)theDocument;
  (void)theWS;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support write operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Read(const TCollection_AsciiString&       thePath,
                       const occ::handle<TDocStd_Document>& theDocument,
                       const Message_ProgressRange&         theProgress)
{
  (void)thePath;
  (void)theDocument;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support read operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Write(const TCollection_AsciiString&       thePath,
                        const occ::handle<TDocStd_Document>& theDocument,
                        const Message_ProgressRange&         theProgress)
{
  (void)thePath;
  (void)theDocument;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support write operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Read(const TCollection_AsciiString&      thePath,
                       TopoDS_Shape&                       theShape,
                       occ::handle<XSControl_WorkSession>& theWS,
                       const Message_ProgressRange&        theProgress)
{
  (void)thePath;
  (void)theShape;
  (void)theWS;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support read operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Write(const TCollection_AsciiString&      thePath,
                        const TopoDS_Shape&                 theShape,
                        occ::handle<XSControl_WorkSession>& theWS,
                        const Message_ProgressRange&        theProgress)
{
  (void)thePath;
  (void)theShape;
  (void)theWS;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support write operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Read(const TCollection_AsciiString& thePath,
                       TopoDS_Shape&                  theShape,
                       const Message_ProgressRange&   theProgress)
{
  (void)thePath;
  (void)theShape;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support read operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Write(const TCollection_AsciiString& thePath,
                        const TopoDS_Shape&            theShape,
                        const Message_ProgressRange&   theProgress)
{
  (void)thePath;
  (void)theShape;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support write operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Read(ReadStreamList&                      theStreams,
                       const occ::handle<TDocStd_Document>& theDocument,
                       occ::handle<XSControl_WorkSession>&  theWS,
                       const Message_ProgressRange&         theProgress)
{
  (void)theStreams;
  (void)theDocument;
  (void)theWS;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support stream read operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Write(WriteStreamList&                     theStreams,
                        const occ::handle<TDocStd_Document>& theDocument,
                        occ::handle<XSControl_WorkSession>&  theWS,
                        const Message_ProgressRange&         theProgress)
{
  (void)theStreams;
  (void)theDocument;
  (void)theWS;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support stream write operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Read(ReadStreamList&                     theStreams,
                       TopoDS_Shape&                       theShape,
                       occ::handle<XSControl_WorkSession>& theWS,
                       const Message_ProgressRange&        theProgress)
{
  (void)theStreams;
  (void)theShape;
  (void)theWS;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support stream read operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Write(WriteStreamList&                    theStreams,
                        const TopoDS_Shape&                 theShape,
                        occ::handle<XSControl_WorkSession>& theWS,
                        const Message_ProgressRange&        theProgress)
{
  (void)theStreams;
  (void)theShape;
  (void)theWS;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support stream write operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Read(ReadStreamList&                      theStreams,
                       const occ::handle<TDocStd_Document>& theDocument,
                       const Message_ProgressRange&         theProgress)
{
  (void)theStreams;
  (void)theDocument;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support stream read operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Write(WriteStreamList&                     theStreams,
                        const occ::handle<TDocStd_Document>& theDocument,
                        const Message_ProgressRange&         theProgress)
{
  (void)theStreams;
  (void)theDocument;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support stream write operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Read(ReadStreamList&              theStreams,
                       TopoDS_Shape&                theShape,
                       const Message_ProgressRange& theProgress)
{
  (void)theStreams;
  (void)theShape;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support stream read operation";
  return false;
}

//=================================================================================================

bool DE_Provider::Write(WriteStreamList&             theStreams,
                        const TopoDS_Shape&          theShape,
                        const Message_ProgressRange& theProgress)
{
  (void)theStreams;
  (void)theShape;
  (void)theProgress;
  Message::SendFail() << "Error: provider " << GetFormat() << " " << GetVendor()
                      << " doesn't support stream write operation";
  return false;
}
