// Created on: 1993-01-09
// Created by: CKY / Contract Toubro-Larsen ( Arun MENON )
// Copyright (c) 1993-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _IGESBasic_SingleParent_HeaderFile
#define _IGESBasic_SingleParent_HeaderFile

#include <Standard.hxx>

#include <Standard_Integer.hxx>
#include <IGESData_IGESEntity.hxx>
#include <NCollection_Array1.hxx>
#include <NCollection_HArray1.hxx>
#include <IGESData_SingleParentEntity.hxx>
class IGESData_IGESEntity;

//! defines SingleParent, Type <402> Form <9>
//! in package IGESBasic
//! It defines a logical structure of one independent
//! (parent) entity and one or more subordinate (children)
//! entities
class IGESBasic_SingleParent : public IGESData_SingleParentEntity
{

public:
  Standard_EXPORT IGESBasic_SingleParent();

  //! This method is used to set the fields of the class
  //! SingleParent
  //! - nbParentEntities : Indicates number of Parents, always = 1
  //! - aParentEntity    : Used to hold the Parent Entity
  //! - allChildren      : Used to hold the children
  Standard_EXPORT void Init(
    const int                                                                 nbParentEntities,
    const occ::handle<IGESData_IGESEntity>&                                   aParentEntity,
    const occ::handle<NCollection_HArray1<occ::handle<IGESData_IGESEntity>>>& allChildren);

  //! returns the number of Parent Entities, which should be 1
  Standard_EXPORT int NbParentEntities() const;

  //! Returns the Parent Entity (inherited method)
  Standard_EXPORT occ::handle<IGESData_IGESEntity> SingleParent() const override;

  //! returns the number of children of the Parent
  Standard_EXPORT int NbChildren() const override;

  //! returns the specific child as indicated by Index
  //! raises exception if Index <= 0 or Index > NbChildren()
  Standard_EXPORT occ::handle<IGESData_IGESEntity> Child(const int Index) const override;

  DEFINE_STANDARD_RTTIEXT(IGESBasic_SingleParent, IGESData_SingleParentEntity)

private:
  int                                                                theNbParentEntities;
  occ::handle<IGESData_IGESEntity>                                   theParentEntity;
  occ::handle<NCollection_HArray1<occ::handle<IGESData_IGESEntity>>> theChildren;
};

#endif // _IGESBasic_SingleParent_HeaderFile
