// Created by: CKY / Contract Toubro-Larsen
// Copyright (c) 1993-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

//--------------------------------------------------------------------
//--------------------------------------------------------------------

#include <IGESGraph_LineFontPredefined.hxx>
#include <Standard_Type.hxx>

IMPLEMENT_STANDARD_RTTIEXT(IGESGraph_LineFontPredefined, IGESData_IGESEntity)

IGESGraph_LineFontPredefined::IGESGraph_LineFontPredefined() = default;

void IGESGraph_LineFontPredefined::Init(const int nbProps, const int aLineFontPatternCode)
{
  theNbPropertyValues    = nbProps;
  theLineFontPatternCode = aLineFontPatternCode;
  InitTypeAndForm(406, 19);
}

int IGESGraph_LineFontPredefined::NbPropertyValues() const
{
  return theNbPropertyValues;
}

int IGESGraph_LineFontPredefined::LineFontPatternCode() const
{
  return theLineFontPatternCode;
}
