// Created on : Sat May 02 12:41:15 2020
// Created by: Irina KRYLOVA
// Generator:	Express (EXPRESS -> CASCADE/XSTEP Translator) V3.0
// Copyright (c) Open CASCADE 2020
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include "RWStepKinematics_RWProductDefinitionKinematics.pxx"

#include <Interface_EntityIterator.hxx>
#include <StepData_StepReaderData.hxx>
#include <StepData_StepWriter.hxx>
#include <StepKinematics_ProductDefinitionKinematics.hxx>
#include <TCollection_HAsciiString.hxx>
#include <StepRepr_CharacterizedDefinition.hxx>

//=================================================================================================

RWStepKinematics_RWProductDefinitionKinematics::RWStepKinematics_RWProductDefinitionKinematics() =
  default;

//=================================================================================================

void RWStepKinematics_RWProductDefinitionKinematics::ReadStep(
  const occ::handle<StepData_StepReaderData>&                    theData,
  const int                                                      theNum,
  occ::handle<Interface_Check>&                                  theArch,
  const occ::handle<StepKinematics_ProductDefinitionKinematics>& theEnt) const
{
  // Check number of parameters
  if (!theData->CheckNbParams(theNum, 3, theArch, "product_definition_kinematics"))
    return;

  // Inherited fields of PropertyDefinition

  occ::handle<TCollection_HAsciiString> aPropertyDefinition_Name;
  theData->ReadString(theNum, 1, "property_definition.name", theArch, aPropertyDefinition_Name);

  occ::handle<TCollection_HAsciiString> aPropertyDefinition_Description;
  bool                                  hasPropertyDefinition_Description = true;
  if (theData->IsParamDefined(theNum, 2))
  {
    theData->ReadString(theNum,
                        2,
                        "property_definition.description",
                        theArch,
                        aPropertyDefinition_Description);
  }
  else
  {
    hasPropertyDefinition_Description = false;
    aPropertyDefinition_Description.Nullify();
  }

  StepRepr_CharacterizedDefinition aPropertyDefinition_Definition;
  theData->ReadEntity(theNum,
                      3,
                      "property_definition.definition",
                      theArch,
                      aPropertyDefinition_Definition);

  // Initialize entity
  theEnt->Init(aPropertyDefinition_Name,
               hasPropertyDefinition_Description,
               aPropertyDefinition_Description,
               aPropertyDefinition_Definition);
}

//=================================================================================================

void RWStepKinematics_RWProductDefinitionKinematics::WriteStep(
  StepData_StepWriter&                                           theSW,
  const occ::handle<StepKinematics_ProductDefinitionKinematics>& theEnt) const
{

  // Own fields of PropertyDefinition

  theSW.Send(theEnt->Name());

  if (theEnt->HasDescription())
  {
    theSW.Send(theEnt->Description());
  }
  else
    theSW.SendUndef();

  theSW.Send(theEnt->Definition().Value());
}

//=================================================================================================

void RWStepKinematics_RWProductDefinitionKinematics::Share(
  const occ::handle<StepKinematics_ProductDefinitionKinematics>& theEnt,
  Interface_EntityIterator&                                      iter) const
{

  // Inherited fields of PropertyDefinition

  iter.AddItem(theEnt->StepRepr_PropertyDefinition::Definition().Value());
}
