// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <Interface_EntityIterator.hxx>
#include "RWStepVisual_RWSurfaceStyleUsage.pxx"
#include <StepData_StepReaderData.hxx>
#include <StepData_StepWriter.hxx>
#include <StepVisual_SurfaceSideStyle.hxx>
#include <StepVisual_SurfaceStyleUsage.hxx>
#include <TCollection_AsciiString.hxx>

#include "RWStepVisual_RWSurfaceSide.pxx"

RWStepVisual_RWSurfaceStyleUsage::RWStepVisual_RWSurfaceStyleUsage() = default;

void RWStepVisual_RWSurfaceStyleUsage::ReadStep(
  const occ::handle<StepData_StepReaderData>&      data,
  const int                                        num,
  occ::handle<Interface_Check>&                    ach,
  const occ::handle<StepVisual_SurfaceStyleUsage>& ent) const
{

  // --- Number of Parameter Control ---

  if (!data->CheckNbParams(num, 2, ach, "surface_style_usage"))
    return;

  // --- own field : side ---

  StepVisual_SurfaceSide aSide = StepVisual_ssNegative;
  if (data->ParamType(num, 1) == Interface_ParamEnum)
  {
    const char* text = data->ParamCValue(num, 1);
    if (!RWStepVisual_RWSurfaceSide::ConvertToEnum(text, aSide))
    {
      ach->AddFail("Enumeration surface_side has not an allowed value");
    }
  }
  else
    ach->AddFail("Parameter #1 (side) is not an enumeration");

  // --- own field : style ---

  occ::handle<StepVisual_SurfaceSideStyle> aStyle;
  // szv#4:S4163:12Mar99 `bool stat2 =` not needed
  data->ReadEntity(num, 2, "style", ach, STANDARD_TYPE(StepVisual_SurfaceSideStyle), aStyle);

  //--- Initialisation of the read entity ---

  ent->Init(aSide, aStyle);
}

void RWStepVisual_RWSurfaceStyleUsage::WriteStep(
  StepData_StepWriter&                             SW,
  const occ::handle<StepVisual_SurfaceStyleUsage>& ent) const
{

  // --- own field : side ---

  SW.SendEnum(RWStepVisual_RWSurfaceSide::ConvertToString(ent->Side()));

  // --- own field : style ---

  SW.Send(ent->Style());
}

void RWStepVisual_RWSurfaceStyleUsage::Share(const occ::handle<StepVisual_SurfaceStyleUsage>& ent,
                                             Interface_EntityIterator& iter) const
{

  iter.GetOneItem(ent->Style());
}
