// Created on: 2002-01-04
// Created by: data exchange team
// Copyright (c) 2002-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

// Generator:	ExpToCas (EXPRESS -> CASCADE/XSTEP Translator) V1.1

#include <StepShape_ConnectedFaceSubSet.hxx>
#include <TCollection_HAsciiString.hxx>

IMPLEMENT_STANDARD_RTTIEXT(StepShape_ConnectedFaceSubSet, StepShape_ConnectedFaceSet)

//=================================================================================================

StepShape_ConnectedFaceSubSet::StepShape_ConnectedFaceSubSet() = default;

//=================================================================================================

void StepShape_ConnectedFaceSubSet::Init(
  const occ::handle<TCollection_HAsciiString>&                         aRepresentationItem_Name,
  const occ::handle<NCollection_HArray1<occ::handle<StepShape_Face>>>& aConnectedFaceSet_CfsFaces,
  const occ::handle<StepShape_ConnectedFaceSet>&                       aParentFaceSet)
{
  StepShape_ConnectedFaceSet::Init(aRepresentationItem_Name, aConnectedFaceSet_CfsFaces);

  theParentFaceSet = aParentFaceSet;
}

//=================================================================================================

occ::handle<StepShape_ConnectedFaceSet> StepShape_ConnectedFaceSubSet::ParentFaceSet() const
{
  return theParentFaceSet;
}

//=================================================================================================

void StepShape_ConnectedFaceSubSet::SetParentFaceSet(
  const occ::handle<StepShape_ConnectedFaceSet>& aParentFaceSet)
{
  theParentFaceSet = aParentFaceSet;
}
