// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <StepGeom_Axis2Placement3d.hxx>
#include <StepShape_RightAngularWedge.hxx>
#include <TCollection_HAsciiString.hxx>

IMPLEMENT_STANDARD_RTTIEXT(StepShape_RightAngularWedge, StepGeom_GeometricRepresentationItem)

StepShape_RightAngularWedge::StepShape_RightAngularWedge() = default;

void StepShape_RightAngularWedge::Init(const occ::handle<TCollection_HAsciiString>&  aName,
                                       const occ::handle<StepGeom_Axis2Placement3d>& aPosition,
                                       const double                                  aX,
                                       const double                                  aY,
                                       const double                                  aZ,
                                       const double                                  aLtx)
{
  // --- classe own fields ---
  position = aPosition;
  x        = aX;
  y        = aY;
  z        = aZ;
  ltx      = aLtx;
  // --- classe inherited fields ---
  StepRepr_RepresentationItem::Init(aName);
}

void StepShape_RightAngularWedge::SetPosition(
  const occ::handle<StepGeom_Axis2Placement3d>& aPosition)
{
  position = aPosition;
}

occ::handle<StepGeom_Axis2Placement3d> StepShape_RightAngularWedge::Position() const
{
  return position;
}

void StepShape_RightAngularWedge::SetX(const double aX)
{
  x = aX;
}

double StepShape_RightAngularWedge::X() const
{
  return x;
}

void StepShape_RightAngularWedge::SetY(const double aY)
{
  y = aY;
}

double StepShape_RightAngularWedge::Y() const
{
  return y;
}

void StepShape_RightAngularWedge::SetZ(const double aZ)
{
  z = aZ;
}

double StepShape_RightAngularWedge::Z() const
{
  return z;
}

void StepShape_RightAngularWedge::SetLtx(const double aLtx)
{
  ltx = aLtx;
}

double StepShape_RightAngularWedge::Ltx() const
{
  return ltx;
}
