// Created on: 1995-12-01
// Created by: EXPRESS->CDL V0.2 Translator
// Copyright (c) 1995-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _StepVisual_StyledItem_HeaderFile
#define _StepVisual_StyledItem_HeaderFile

#include <Standard.hxx>

#include <StepVisual_PresentationStyleAssignment.hxx>
#include <NCollection_Array1.hxx>
#include <NCollection_HArray1.hxx>
#include <StepRepr_RepresentationItem.hxx>
#include <StepVisual_StyledItemTarget.hxx>
#include <Standard_Integer.hxx>
class TCollection_HAsciiString;
class StepVisual_PresentationStyleAssignment;

class StepVisual_StyledItem : public StepRepr_RepresentationItem
{

public:
  //! Returns a StyledItem
  StepVisual_StyledItem() = default;

  Standard_EXPORT void Init(
    const occ::handle<TCollection_HAsciiString>& aName,
    const occ::handle<NCollection_HArray1<occ::handle<StepVisual_PresentationStyleAssignment>>>&
                                           aStyles,
    const occ::handle<Standard_Transient>& aItem);

  Standard_EXPORT void SetStyles(
    const occ::handle<NCollection_HArray1<occ::handle<StepVisual_PresentationStyleAssignment>>>&
      aStyles);

  const occ::handle<NCollection_HArray1<occ::handle<StepVisual_PresentationStyleAssignment>>>&
    Styles() const
  {
    return myStyles;
  }

  const occ::handle<StepVisual_PresentationStyleAssignment>& StylesValue(const int num) const
  {
    return myStyles->Value(num);
  }

  int NbStyles() const { return myStyles.IsNull() ? 0 : myStyles->Length(); }

  Standard_EXPORT void SetItem(const occ::handle<StepRepr_RepresentationItem>& aItem);

  const occ::handle<StepRepr_RepresentationItem>& Item() const { return myReprItem; }

  Standard_EXPORT void SetItem(const StepVisual_StyledItemTarget& aItem);

  Standard_EXPORT StepVisual_StyledItemTarget ItemAP242() const;

  DEFINE_STANDARD_RTTIEXT(StepVisual_StyledItem, StepRepr_RepresentationItem)

private:
  occ::handle<NCollection_HArray1<occ::handle<StepVisual_PresentationStyleAssignment>>> myStyles;
  //! May be StepRepr_RepresentationItem for AP214(203) and StepVisual_StyledItemTarget for AP242
  occ::handle<Standard_Transient> myItem;
  //! This is downcasted from myItem
  occ::handle<StepRepr_RepresentationItem> myReprItem;
};

#endif // _StepVisual_StyledItem_HeaderFile
