// Created on: 1994-04-18
// Created by: Modelistation
// Copyright (c) 1994-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _Draw_Marker2D_HeaderFile
#define _Draw_Marker2D_HeaderFile

#include <Standard.hxx>

#include <gp_Pnt2d.hxx>
#include <Draw_Color.hxx>
#include <Draw_MarkerShape.hxx>
#include <Standard_Integer.hxx>
#include <Draw_Drawable2D.hxx>
class Draw_Display;

class Draw_Marker2D : public Draw_Drawable2D
{

public:
  Standard_EXPORT Draw_Marker2D(const gp_Pnt2d&        P,
                                const Draw_MarkerShape T,
                                const Draw_Color&      C,
                                const int              Size = 5);

  Standard_EXPORT Draw_Marker2D(const gp_Pnt2d&        P,
                                const Draw_MarkerShape T,
                                const Draw_Color&      C,
                                const double           RSize);

  //! myPos field
  Standard_EXPORT gp_Pnt2d& ChangePos();

  Standard_EXPORT void DrawOn(Draw_Display& dis) const override;

  //! Returns always false
  Standard_EXPORT bool PickReject(const double X, const double Y, const double Prec) const override;

  DEFINE_STANDARD_RTTIEXT(Draw_Marker2D, Draw_Drawable2D)

private:
  gp_Pnt2d         myPos;
  Draw_Color       myCol;
  Draw_MarkerShape myTyp;
  int              mySiz;
};

#endif // _Draw_Marker2D_HeaderFile
